"""Generated message classes for apihub version v1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'apihub'


class ApihubProjectsLocationsApiHubInstancesCreateRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApiHubInstancesCreateRequest object.

  Fields:
    apiHubInstanceId: Optional. Identifier to assign to the Api Hub instance.
      Must be unique within scope of the parent resource. If the field is not
      provided, system generated id will be used. This value should be 4-40
      characters, and valid characters are /a-z[0-9]-_/.
    googleCloudApihubV1ApiHubInstance: A GoogleCloudApihubV1ApiHubInstance
      resource to be passed as the request body.
    parent: Required. The parent resource for the Api Hub instance resource.
      Format: `projects/{project}/locations/{location}`
  """

  apiHubInstanceId = _messages.StringField(1)
  googleCloudApihubV1ApiHubInstance = _messages.MessageField('GoogleCloudApihubV1ApiHubInstance', 2)
  parent = _messages.StringField(3, required=True)


class ApihubProjectsLocationsApiHubInstancesGetRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApiHubInstancesGetRequest object.

  Fields:
    name: Required. The name of the Api Hub instance to retrieve. Format: `pro
      jects/{project}/locations/{location}/apiHubInstances/{apiHubInstance}`.
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsApiHubInstancesLookupRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApiHubInstancesLookupRequest object.

  Fields:
    parent: Required. There will always be only one Api Hub instance for a GCP
      project across all locations. For preview, the location can be 'us-
      central1' or 'eu-west1' in the request. The parent resource for the Api
      Hub instance resource. Format: `projects/{project}/locations/{location}`
  """

  parent = _messages.StringField(1, required=True)


class ApihubProjectsLocationsApisCreateRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisCreateRequest object.

  Fields:
    apiId: Optional. The ID to use for the API resource, which will become the
      final component of the API's resource name. This field is optional. * If
      provided, the same will be used. The service will throw an error if the
      specified id is already used by another API resource in the API hub. *
      If not provided, a system generated id will be used. This value should
      be 4-500 characters, and valid characters are /a-z[0-9]-_/.
    googleCloudApihubV1Api: A GoogleCloudApihubV1Api resource to be passed as
      the request body.
    parent: Required. The parent resource for the API resource. Format:
      `projects/{project}/locations/{location}`
  """

  apiId = _messages.StringField(1)
  googleCloudApihubV1Api = _messages.MessageField('GoogleCloudApihubV1Api', 2)
  parent = _messages.StringField(3, required=True)


class ApihubProjectsLocationsApisDeleteRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisDeleteRequest object.

  Fields:
    force: Optional. If set to true, any versions from this API will also be
      deleted. Otherwise, the request will only work if the API has no
      versions.
    name: Required. The name of the API resource to delete. Format:
      `projects/{project}/locations/{location}/apis/{api}`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class ApihubProjectsLocationsApisGetRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisGetRequest object.

  Fields:
    name: Required. The name of the API resource to retrieve. Format:
      `projects/{project}/locations/{location}/apis/{api}`
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsApisListRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisListRequest object.

  Fields:
    filter: Optional. An expression that filters the list of ApiResources. A
      filter expression consists of a field name, a comparison operator, and a
      value for filtering. The value must be a string. The comparison operator
      must be one of: `<`, `>`, `:` or `=`. Filters are not case sensitive.
      The following fields in the `ApiResource` are eligible for filtering: *
      `owner.email` - The email of the team which owns the ApiResource.
      Allowed comparison operators: `=`. * `create_time` - The time at which
      the ApiResource was created. The value should be in the
      (RFC3339)[https://tools.ietf.org/html/rfc3339] format. Allowed
      comparison operators: `>` and `<`. * `display_name` - The display name
      of the ApiResource. Allowed comparison operators: `=`. *
      `target_user.enum_values.values.id` - The allowed value id of the target
      users attribute associated with the ApiResource. Allowed comparison
      operator is `:`. * `team.enum_values.values.id` - The allowed value id
      of the team attribute associated with the ApiResource. Allowed
      comparison operator is `:`. * `business_unit.enum_values.values.id` -
      The allowed value id of the business unit attribute associated with the
      ApiResource. Allowed comparison operator is `:`. *
      `maturity_level.enum_values.values.id` - The allowed value id of the
      maturity level attribute associated with the ApiResource. Allowed
      comparison operator is `:`. * `api_style.enum_values.values.id` - The
      allowed value id of the api style attribute associated with the
      ApiResource. Allowed comparison operator is `:`. Expressions are
      combined with either `AND` logic operator or `OR` logical operator but
      not both of them together i.e. only one of the `AND` or `OR` operator
      can be used throughout the filter string and both the operators cannot
      be used together. No other logical operators are supported. At most
      three filter fields are allowed in the filter string and if provided
      more than that then `INVALID_ARGUMENT` error is returned by the API.
      Here are a few examples: * `owner.email = \"apihub@google.com\"` - - The
      owner team email is _apihub@google.com_. * `owner.email =
      \"apihub@google.com\" AND create_time < \"2021-08-15T14:50:00Z\" AND
      create_time > \"2021-08-10T12:00:00Z\"` - The owner team email is
      _apihub@google.com_ and the api was created before _2021-08-15 14:50:00
      UTC_ and after _2021-08-10 12:00:00 UTC_. * `owner.email =
      \"apihub@google.com\" OR team.enum_values.values.id: apihub-team-id` -
      The filter string specifies the APIs where the owner team email is
      _apihub@google.com_ or the id of the allowed value associated with the
      team attribute is _apihub-team-id_.
    pageSize: Optional. The maximum number of API resources to return. The
      service may return fewer than this value. If unspecified, at most 50
      Apis will be returned. The maximum value is 1000; values above 1000 will
      be coerced to 1000.
    pageToken: Optional. A page token, received from a previous `ListApis`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters (except page_size) provided to `ListApis` must match
      the call that provided the page token.
    parent: Required. The parent, which owns this collection of API resources.
      Format: `projects/{project}/locations/{location}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class ApihubProjectsLocationsApisPatchRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisPatchRequest object.

  Fields:
    googleCloudApihubV1Api: A GoogleCloudApihubV1Api resource to be passed as
      the request body.
    name: Identifier. The name of the API resource in the API Hub. Format:
      `projects/{project}/locations/{location}/apis/{api}`
    updateMask: Required. The list of fields to update.
  """

  googleCloudApihubV1Api = _messages.MessageField('GoogleCloudApihubV1Api', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class ApihubProjectsLocationsApisVersionsCreateRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisVersionsCreateRequest object.

  Fields:
    googleCloudApihubV1Version: A GoogleCloudApihubV1Version resource to be
      passed as the request body.
    parent: Required. The parent resource for API version. Format:
      `projects/{project}/locations/{location}/apis/{api}`
    versionId: Optional. The ID to use for the API version, which will become
      the final component of the version's resource name. This field is
      optional. * If provided, the same will be used. The service will throw
      an error if the specified id is already used by another version in the
      API resource. * If not provided, a system generated id will be used.
      This value should be 4-500 characters, and valid characters are
      /a-z[0-9]-_/.
  """

  googleCloudApihubV1Version = _messages.MessageField('GoogleCloudApihubV1Version', 1)
  parent = _messages.StringField(2, required=True)
  versionId = _messages.StringField(3)


class ApihubProjectsLocationsApisVersionsDefinitionsGetRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisVersionsDefinitionsGetRequest object.

  Fields:
    name: Required. The name of the definition to retrieve. Format: `projects/
      {project}/locations/{location}/apis/{api}/versions/{version}/definitions
      /{definition}`
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsApisVersionsDeleteRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisVersionsDeleteRequest object.

  Fields:
    force: Optional. If set to true, any specs from this version will also be
      deleted. Otherwise, the request will only work if the version has no
      specs.
    name: Required. The name of the version to delete. Format:
      `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class ApihubProjectsLocationsApisVersionsGetRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisVersionsGetRequest object.

  Fields:
    name: Required. The name of the API version to retrieve. Format:
      `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsApisVersionsListRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisVersionsListRequest object.

  Fields:
    filter: Optional. An expression that filters the list of Versions. A
      filter expression consists of a field name, a comparison operator, and a
      value for filtering. The value must be a string, a number, or a boolean.
      The comparison operator must be one of: `<`, `>` or `=`. Filters are not
      case sensitive. The following fields in the `Version` are eligible for
      filtering: * `display_name` - The display name of the Version. Allowed
      comparison operators: `=`. * `create_time` - The time at which the
      Version was created. The value should be in the
      (RFC3339)[https://tools.ietf.org/html/rfc3339] format. Allowed
      comparison operators: `>` and `<`. * `lifecycle.enum_values.values.id` -
      The allowed value id of the lifecycle attribute associated with the
      Version. Allowed comparison operators: `:`. *
      `compliance.enum_values.values.id` - The allowed value id of the
      compliances attribute associated with the Version. Allowed comparison
      operators: `:`. * `accreditation.enum_values.values.id` - The allowed
      value id of the accreditations attribute associated with the Version.
      Allowed comparison operators: `:`. Expressions are combined with either
      `AND` logic operator or `OR` logical operator but not both of them
      together i.e. only one of the `AND` or `OR` operator can be used
      throughout the filter string and both the operators cannot be used
      together. No other logical operators are supported. At most three filter
      fields are allowed in the filter string and if provided more than that
      then `INVALID_ARGUMENT` error is returned by the API. Here are a few
      examples: * `lifecycle.enum_values.values.id: preview-id` - The filter
      string specifies that the id of the allowed value associated with the
      lifecycle attribute of the Version is _preview-id_. *
      `lifecycle.enum_values.values.id: preview-id AND create_time <
      \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
      The id of the allowed value associated with the lifecycle attribute of
      the Version is _preview-id_ and it was created before _2021-08-15
      14:50:00 UTC_ and after _2021-08-10 12:00:00 UTC_. *
      `compliance.enum_values.values.id: gdpr-id OR
      compliance.enum_values.values.id: pci-dss-id` - The id of the allowed
      value associated with the compliance attribute is _gdpr-id_ or _pci-dss-
      id_.
    pageSize: Optional. The maximum number of versions to return. The service
      may return fewer than this value. If unspecified, at most 50 versions
      will be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: Optional. A page token, received from a previous `ListVersions`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters (except page_size) provided to `ListVersions` must
      match the call that provided the page token.
    parent: Required. The parent which owns this collection of API versions
      i.e., the API resource Format:
      `projects/{project}/locations/{location}/apis/{api}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class ApihubProjectsLocationsApisVersionsOperationsGetRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisVersionsOperationsGetRequest object.

  Fields:
    name: Required. The name of the operation to retrieve. Format: `projects/{
      project}/locations/{location}/apis/{api}/versions/{version}/operations/{
      operation}`
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsApisVersionsOperationsListRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisVersionsOperationsListRequest object.

  Fields:
    filter: Optional. An expression that filters the list of ApiOperations. A
      filter expression consists of a field name, a comparison operator, and a
      value for filtering. The value must be a string or a boolean. The
      comparison operator must be one of: `<`, `>` or `=`. Filters are not
      case sensitive. The following fields in the `ApiOperation` are eligible
      for filtering: * `name` - The ApiOperation resource name. Allowed
      comparison operators: `=`. * `details.http_operation.path.path` - The
      http operation's complete path relative to server endpoint. Allowed
      comparison operators: `=`. * `details.http_operation.method` - The http
      operation method type. Allowed comparison operators: `=`. *
      `details.deprecated` - Indicates if the ApiOperation is deprecated.
      Allowed values are True / False indicating the deprycation status of the
      ApiOperation. Allowed comparison operators: `=`. * `create_time` - The
      time at which the ApiOperation was created. The value should be in the
      (RFC3339)[https://tools.ietf.org/html/rfc3339] format. Allowed
      comparison operators: `>` and `<`. Expressions are combined with either
      `AND` logic operator or `OR` logical operator but not both of them
      together i.e. only one of the `AND` or `OR` operator can be used
      throughout the filter string and both the operators cannot be used
      together. No other logical operators are supported. At most three filter
      fields are allowed in the filter string and if provided more than that
      then `INVALID_ARGUMENT` error is returned by the API. Here are a few
      examples: * `details.deprecated = True` - The ApiOperation is
      deprecated. * `details.http_operation.method = GET AND create_time <
      \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
      The method of the http operation of the ApiOperation is _GET_ and the
      spec was created before _2021-08-15 14:50:00 UTC_ and after _2021-08-10
      12:00:00 UTC_. * `details.http_operation.method = GET OR
      details.http_operation.method = POST`. - The http operation of the
      method of ApiOperation is _GET_ or _POST_.
    pageSize: Optional. The maximum number of operations to return. The
      service may return fewer than this value. If unspecified, at most 50
      operations will be returned. The maximum value is 1000; values above
      1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListApiOperations` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters (except page_size) provided to
      `ListApiOperations` must match the call that provided the page token.
    parent: Required. The parent which owns this collection of operations
      i.e., the API version. Format:
      `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class ApihubProjectsLocationsApisVersionsPatchRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisVersionsPatchRequest object.

  Fields:
    googleCloudApihubV1Version: A GoogleCloudApihubV1Version resource to be
      passed as the request body.
    name: Identifier. The name of the version. Format:
      `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
    updateMask: Required. The list of fields to update.
  """

  googleCloudApihubV1Version = _messages.MessageField('GoogleCloudApihubV1Version', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class ApihubProjectsLocationsApisVersionsSpecsCreateRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisVersionsSpecsCreateRequest object.

  Fields:
    googleCloudApihubV1Spec: A GoogleCloudApihubV1Spec resource to be passed
      as the request body.
    parent: Required. The parent resource for Spec. Format:
      `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
    specId: Optional. The ID to use for the spec, which will become the final
      component of the spec's resource name. This field is optional. * If
      provided, the same will be used. The service will throw an error if the
      specified id is already used by another spec in the API resource. * If
      not provided, a system generated id will be used. This value should be
      4-500 characters, and valid characters are /a-z[0-9]-_/.
  """

  googleCloudApihubV1Spec = _messages.MessageField('GoogleCloudApihubV1Spec', 1)
  parent = _messages.StringField(2, required=True)
  specId = _messages.StringField(3)


class ApihubProjectsLocationsApisVersionsSpecsDeleteRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisVersionsSpecsDeleteRequest object.

  Fields:
    name: Required. The name of the spec to delete. Format: `projects/{project
      }/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsApisVersionsSpecsGetContentsRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisVersionsSpecsGetContentsRequest object.

  Fields:
    name: Required. The name of the spec whose contents need to be retrieved.
      Format: `projects/{project}/locations/{location}/apis/{api}/versions/{ve
      rsion}/specs/{spec}`
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsApisVersionsSpecsGetRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisVersionsSpecsGetRequest object.

  Fields:
    name: Required. The name of the spec to retrieve. Format: `projects/{proje
      ct}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsApisVersionsSpecsLintRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisVersionsSpecsLintRequest object.

  Fields:
    googleCloudApihubV1LintSpecRequest: A GoogleCloudApihubV1LintSpecRequest
      resource to be passed as the request body.
    name: Required. The name of the spec to be linted. Format: `projects/{proj
      ect}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
  """

  googleCloudApihubV1LintSpecRequest = _messages.MessageField('GoogleCloudApihubV1LintSpecRequest', 1)
  name = _messages.StringField(2, required=True)


class ApihubProjectsLocationsApisVersionsSpecsListRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisVersionsSpecsListRequest object.

  Fields:
    filter: Optional. An expression that filters the list of Specs. A filter
      expression consists of a field name, a comparison operator, and a value
      for filtering. The value must be a string. The comparison operator must
      be one of: `<`, `>`, `:` or `=`. Filters are not case sensitive. The
      following fields in the `Spec` are eligible for filtering: *
      `display_name` - The display name of the Spec. Allowed comparison
      operators: `=`. * `create_time` - The time at which the Spec was
      created. The value should be in the
      (RFC3339)[https://tools.ietf.org/html/rfc3339] format. Allowed
      comparison operators: `>` and `<`. * `spec_type.enum_values.values.id` -
      The allowed value id of the spec_type attribute associated with the
      Spec. Allowed comparison operators: `:`. *
      `lint_response.json_values.values` - The json value of the lint_response
      attribute associated with the Spec. Allowed comparison operators: `:`. *
      `mime_type` - The MIME type of the Spec. Allowed comparison operators:
      `=`. Expressions are combined with either `AND` logic operator or `OR`
      logical operator but not both of them together i.e. only one of the
      `AND` or `OR` operator can be used throughout the filter string and both
      the operators cannot be used together. No other logical operators are
      supported. At most three filter fields are allowed in the filter string
      and if provided more than that then `INVALID_ARGUMENT` error is returned
      by the API. Here are a few examples: * `spec_type.enum_values.values.id:
      rest-id` - The filter string specifies that the id of the allowed value
      associated with the spec_type attribute is _rest-id_. *
      `spec_type.enum_values.values.id: grpc-id AND create_time <
      \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
      The id of the allowed value associated with the spec_type attribute is
      _grpc-id_ and the spec was created before _2021-08-15 14:50:00 UTC_ and
      after _2021-08-10 12:00:00 UTC_. * `spec_type.enum_values.values.id:
      rest-id OR spec_type.enum_values.values.id: grpc-id` - The id of the
      allowed value associated with the spec_type attribute is _rest-id_ or
      _grpc-id_.
    pageSize: Optional. The maximum number of specs to return. The service may
      return fewer than this value. If unspecified, at most 50 specs will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. A page token, received from a previous `ListSpecs`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListSpecs` must match the call that
      provided the page token.
    parent: Required. The parent, which owns this collection of specs. Format:
      `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class ApihubProjectsLocationsApisVersionsSpecsPatchRequest(_messages.Message):
  r"""A ApihubProjectsLocationsApisVersionsSpecsPatchRequest object.

  Fields:
    googleCloudApihubV1Spec: A GoogleCloudApihubV1Spec resource to be passed
      as the request body.
    name: Identifier. The name of the spec. Format: `projects/{project}/locati
      ons/{location}/apis/{api}/versions/{version}/specs/{spec}`
    updateMask: Required. The list of fields to update.
  """

  googleCloudApihubV1Spec = _messages.MessageField('GoogleCloudApihubV1Spec', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class ApihubProjectsLocationsAttributesCreateRequest(_messages.Message):
  r"""A ApihubProjectsLocationsAttributesCreateRequest object.

  Fields:
    attributeId: Optional. The ID to use for the attribute, which will become
      the final component of the attribute's resource name. This field is
      optional. * If provided, the same will be used. The service will throw
      an error if the specified id is already used by another attribute
      resource in the API hub. * If not provided, a system generated id will
      be used. This value should be 4-500 characters, and valid characters are
      /a-z[0-9]-_/.
    googleCloudApihubV1Attribute: A GoogleCloudApihubV1Attribute resource to
      be passed as the request body.
    parent: Required. The parent resource for Attribute. Format:
      `projects/{project}/locations/{location}`
  """

  attributeId = _messages.StringField(1)
  googleCloudApihubV1Attribute = _messages.MessageField('GoogleCloudApihubV1Attribute', 2)
  parent = _messages.StringField(3, required=True)


class ApihubProjectsLocationsAttributesDeleteRequest(_messages.Message):
  r"""A ApihubProjectsLocationsAttributesDeleteRequest object.

  Fields:
    name: Required. The name of the attribute to delete. Format:
      `projects/{project}/locations/{location}/attributes/{attribute}`
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsAttributesGetRequest(_messages.Message):
  r"""A ApihubProjectsLocationsAttributesGetRequest object.

  Fields:
    name: Required. The name of the attribute to retrieve. Format:
      `projects/{project}/locations/{location}/attributes/{attribute}`
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsAttributesListRequest(_messages.Message):
  r"""A ApihubProjectsLocationsAttributesListRequest object.

  Fields:
    filter: Optional. An expression that filters the list of Attributes. A
      filter expression consists of a field name, a comparison operator, and a
      value for filtering. The value must be a string or a boolean. The
      comparison operator must be one of: `<`, `>` or `=`. Filters are not
      case sensitive. The following fields in the `Attribute` are eligible for
      filtering: * `display_name` - The display name of the Attribute. Allowed
      comparison operators: `=`. * `definition_type` - The definition type of
      the attribute. Allowed comparison operators: `=`. * `scope` - The scope
      of the attribute. Allowed comparison operators: `=`. * `data_type` - The
      type of the data of the attribute. Allowed comparison operators: `=`. *
      `mandatory` - Denotes whether the attribute is mandatory or not. Allowed
      comparison operators: `=`. * `create_time` - The time at which the
      Attribute was created. The value should be in the
      (RFC3339)[https://tools.ietf.org/html/rfc3339] format. Allowed
      comparison operators: `>` and `<`. Expressions are combined with either
      `AND` logic operator or `OR` logical operator but not both of them
      together i.e. only one of the `AND` or `OR` operator can be used
      throughout the filter string and both the operators cannot be used
      together. No other logical operators are supported. At most three filter
      fields are allowed in the filter string and if provided more than that
      then `INVALID_ARGUMENT` error is returned by the API. Here are a few
      examples: * `display_name = production` - - The display name of the
      attribute is _production_. * `(display_name = production) AND
      (create_time < \"2021-08-15T14:50:00Z\") AND (create_time >
      \"2021-08-10T12:00:00Z\")` - The display name of the attribute is
      _production_ and the attribute was created before _2021-08-15 14:50:00
      UTC_ and after _2021-08-10 12:00:00 UTC_. * `display_name = production
      OR scope = api` - The attribute where the display name is _production_
      or the scope is _api_.
    pageSize: Optional. The maximum number of attribute resources to return.
      The service may return fewer than this value. If unspecified, at most 50
      attributes will be returned. The maximum value is 1000; values above
      1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListAttributes` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to `ListAttributes` must
      match the call that provided the page token.
    parent: Required. The parent resource for Attribute. Format:
      `projects/{project}/locations/{location}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class ApihubProjectsLocationsAttributesPatchRequest(_messages.Message):
  r"""A ApihubProjectsLocationsAttributesPatchRequest object.

  Fields:
    googleCloudApihubV1Attribute: A GoogleCloudApihubV1Attribute resource to
      be passed as the request body.
    name: Identifier. The name of the attribute in the API Hub. Format:
      `projects/{project}/locations/{location}/attributes/{attribute}`
    updateMask: Required. The list of fields to update.
  """

  googleCloudApihubV1Attribute = _messages.MessageField('GoogleCloudApihubV1Attribute', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class ApihubProjectsLocationsDependenciesCreateRequest(_messages.Message):
  r"""A ApihubProjectsLocationsDependenciesCreateRequest object.

  Fields:
    dependencyId: Optional. The ID to use for the dependency resource, which
      will become the final component of the dependency's resource name. This
      field is optional. * If provided, the same will be used. The service
      will throw an error if duplicate id is provided by the client. * If not
      provided, a system generated id will be used. This value should be 4-500
      characters, and valid characters are `a-z[0-9]-_`.
    googleCloudApihubV1Dependency: A GoogleCloudApihubV1Dependency resource to
      be passed as the request body.
    parent: Required. The parent resource for the dependency resource. Format:
      `projects/{project}/locations/{location}`
  """

  dependencyId = _messages.StringField(1)
  googleCloudApihubV1Dependency = _messages.MessageField('GoogleCloudApihubV1Dependency', 2)
  parent = _messages.StringField(3, required=True)


class ApihubProjectsLocationsDependenciesDeleteRequest(_messages.Message):
  r"""A ApihubProjectsLocationsDependenciesDeleteRequest object.

  Fields:
    name: Required. The name of the dependency resource to delete. Format:
      `projects/{project}/locations/{location}/dependencies/{dependency}`
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsDependenciesGetRequest(_messages.Message):
  r"""A ApihubProjectsLocationsDependenciesGetRequest object.

  Fields:
    name: Required. The name of the dependency resource to retrieve. Format:
      `projects/{project}/locations/{location}/dependencies/{dependency}`
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsDependenciesListRequest(_messages.Message):
  r"""A ApihubProjectsLocationsDependenciesListRequest object.

  Fields:
    filter: Optional. An expression that filters the list of Dependencies. A
      filter expression consists of a field name, a comparison operator, and a
      value for filtering. The value must be a string. Allowed comparison
      operator is `=`. Filters are not case sensitive. The following fields in
      the `Dependency` are eligible for filtering: *
      `consumer.operation_resource_name` - The operation resource name for the
      consumer entity involved in a dependency. Allowed comparison operators:
      `=`. * `consumer.external_api_resource_name` - The external api resource
      name for the consumer entity involved in a dependency. Allowed
      comparison operators: `=`. * `supplier.operation_resource_name` - The
      operation resource name for the supplier entity involved in a
      dependency. Allowed comparison operators: `=`. *
      `supplier.external_api_resource_name` - The external api resource name
      for the supplier entity involved in a dependency. Allowed comparison
      operators: `=`. Expressions are combined with either `AND` logic
      operator or `OR` logical operator but not both of them together i.e.
      only one of the `AND` or `OR` operator can be used throughout the filter
      string and both the operators cannot be used together. No other logical
      operators are supported. At most three filter fields are allowed in the
      filter string and if provided more than that then `INVALID_ARGUMENT`
      error is returned by the API. For example,
      `consumer.operation_resource_name =
      \"projects/p1/locations/global/apis/a1/versions/v1/operations/o1\" OR
      supplier.operation_resource_name =
      \"projects/p1/locations/global/apis/a1/versions/v1/operations/o1\"` -
      The dependencies with either consumer or supplier operation resource
      name as
      _projects/p1/locations/global/apis/a1/versions/v1/operations/o1_.
    pageSize: Optional. The maximum number of dependency resources to return.
      The service may return fewer than this value. If unspecified, at most 50
      dependencies will be returned. The maximum value is 1000; values above
      1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListDependencies` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to `ListDependencies`
      must match the call that provided the page token.
    parent: Required. The parent which owns this collection of dependency
      resources. Format: `projects/{project}/locations/{location}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class ApihubProjectsLocationsDependenciesPatchRequest(_messages.Message):
  r"""A ApihubProjectsLocationsDependenciesPatchRequest object.

  Fields:
    googleCloudApihubV1Dependency: A GoogleCloudApihubV1Dependency resource to
      be passed as the request body.
    name: Identifier. The name of the dependency in the API Hub. Format:
      `projects/{project}/locations/{location}/dependencies/{dependency}`
    updateMask: Required. The list of fields to update.
  """

  googleCloudApihubV1Dependency = _messages.MessageField('GoogleCloudApihubV1Dependency', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class ApihubProjectsLocationsDeploymentsCreateRequest(_messages.Message):
  r"""A ApihubProjectsLocationsDeploymentsCreateRequest object.

  Fields:
    deploymentId: Optional. The ID to use for the deployment resource, which
      will become the final component of the deployment's resource name. This
      field is optional. * If provided, the same will be used. The service
      will throw an error if the specified id is already used by another
      deployment resource in the API hub. * If not provided, a system
      generated id will be used. This value should be 4-500 characters, and
      valid characters are /a-z[0-9]-_/.
    googleCloudApihubV1Deployment: A GoogleCloudApihubV1Deployment resource to
      be passed as the request body.
    parent: Required. The parent resource for the deployment resource. Format:
      `projects/{project}/locations/{location}`
  """

  deploymentId = _messages.StringField(1)
  googleCloudApihubV1Deployment = _messages.MessageField('GoogleCloudApihubV1Deployment', 2)
  parent = _messages.StringField(3, required=True)


class ApihubProjectsLocationsDeploymentsDeleteRequest(_messages.Message):
  r"""A ApihubProjectsLocationsDeploymentsDeleteRequest object.

  Fields:
    name: Required. The name of the deployment resource to delete. Format:
      `projects/{project}/locations/{location}/deployments/{deployment}`
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsDeploymentsGetRequest(_messages.Message):
  r"""A ApihubProjectsLocationsDeploymentsGetRequest object.

  Fields:
    name: Required. The name of the deployment resource to retrieve. Format:
      `projects/{project}/locations/{location}/deployments/{deployment}`
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsDeploymentsListRequest(_messages.Message):
  r"""A ApihubProjectsLocationsDeploymentsListRequest object.

  Fields:
    filter: Optional. An expression that filters the list of Deployments. A
      filter expression consists of a field name, a comparison operator, and a
      value for filtering. The value must be a string. The comparison operator
      must be one of: `<`, `>` or `=`. Filters are not case sensitive. The
      following fields in the `Deployments` are eligible for filtering: *
      `display_name` - The display name of the Deployment. Allowed comparison
      operators: `=`. * `create_time` - The time at which the Deployment was
      created. The value should be in the
      (RFC3339)[https://tools.ietf.org/html/rfc3339] format. Allowed
      comparison operators: `>` and `<`. * `resource_uri` - A URI to the
      deployment resource. Allowed comparison operators: `=`. * `api_versions`
      - The API versions linked to this deployment. Allowed comparison
      operators: `:`. * `deployment_type.enum_values.values.id` - The allowed
      value id of the deployment_type attribute associated with the
      Deployment. Allowed comparison operators: `:`. *
      `slo.string_values.values` -The allowed string value of the slo
      attribute associated with the deployment. Allowed comparison operators:
      `:`. * `environment.enum_values.values.id` - The allowed value id of the
      environment attribute associated with the deployment. Allowed comparison
      operators: `:`. Expressions are combined with either `AND` logic
      operator or `OR` logical operator but not both of them together i.e.
      only one of the `AND` or `OR` operator can be used throughout the filter
      string and both the operators cannot be used together. No other logical
      operators are supported. At most three filter fields are allowed in the
      filter string and if provided more than that then `INVALID_ARGUMENT`
      error is returned by the API. Here are a few examples: *
      `environment.enum_values.values.id: staging-id` - The allowed value id
      of the environment attribute associated with the Deployment is _staging-
      id_. * `environment.enum_values.values.id: production-id AND create_time
      < \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\"` -
      The allowed value id of the environment attribute associated with the
      Deployment is _production-id_ and Deployment was created before
      _2021-08-15 14:50:00 UTC_ and after _2021-08-10 12:00:00 UTC_. *
      `environment.enum_values.values.id: production-id OR
      slo.string_values.values: \"99.99%\"` - The allowed value id of the
      environment attribute Deployment is _production-id_ or string value of
      the slo attribute is _99.99%_.
    pageSize: Optional. The maximum number of deployment resources to return.
      The service may return fewer than this value. If unspecified, at most 50
      deployments will be returned. The maximum value is 1000; values above
      1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListDeployments` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters (except page_size) provided to
      `ListDeployments` must match the call that provided the page token.
    parent: Required. The parent, which owns this collection of deployment
      resources. Format: `projects/{project}/locations/{location}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class ApihubProjectsLocationsDeploymentsPatchRequest(_messages.Message):
  r"""A ApihubProjectsLocationsDeploymentsPatchRequest object.

  Fields:
    googleCloudApihubV1Deployment: A GoogleCloudApihubV1Deployment resource to
      be passed as the request body.
    name: Identifier. The name of the deployment. Format:
      `projects/{project}/locations/{location}/deployments/{deployment}`
    updateMask: Required. The list of fields to update.
  """

  googleCloudApihubV1Deployment = _messages.MessageField('GoogleCloudApihubV1Deployment', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class ApihubProjectsLocationsExternalApisCreateRequest(_messages.Message):
  r"""A ApihubProjectsLocationsExternalApisCreateRequest object.

  Fields:
    externalApiId: Optional. The ID to use for the External API resource,
      which will become the final component of the External API's resource
      name. This field is optional. * If provided, the same will be used. The
      service will throw an error if the specified id is already used by
      another External API resource in the API hub. * If not provided, a
      system generated id will be used. This value should be 4-500 characters,
      and valid characters are /a-z[0-9]-_/.
    googleCloudApihubV1ExternalApi: A GoogleCloudApihubV1ExternalApi resource
      to be passed as the request body.
    parent: Required. The parent resource for the External API resource.
      Format: `projects/{project}/locations/{location}`
  """

  externalApiId = _messages.StringField(1)
  googleCloudApihubV1ExternalApi = _messages.MessageField('GoogleCloudApihubV1ExternalApi', 2)
  parent = _messages.StringField(3, required=True)


class ApihubProjectsLocationsExternalApisDeleteRequest(_messages.Message):
  r"""A ApihubProjectsLocationsExternalApisDeleteRequest object.

  Fields:
    name: Required. The name of the External API resource to delete. Format:
      `projects/{project}/locations/{location}/externalApis/{externalApi}`
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsExternalApisGetRequest(_messages.Message):
  r"""A ApihubProjectsLocationsExternalApisGetRequest object.

  Fields:
    name: Required. The name of the External API resource to retrieve. Format:
      `projects/{project}/locations/{location}/externalApis/{externalApi}`
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsExternalApisListRequest(_messages.Message):
  r"""A ApihubProjectsLocationsExternalApisListRequest object.

  Fields:
    pageSize: Optional. The maximum number of External API resources to
      return. The service may return fewer than this value. If unspecified, at
      most 50 ExternalApis will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListExternalApis` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters (except page_size) provided to
      `ListExternalApis` must match the call that provided the page token.
    parent: Required. The parent, which owns this collection of External API
      resources. Format: `projects/{project}/locations/{location}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ApihubProjectsLocationsExternalApisPatchRequest(_messages.Message):
  r"""A ApihubProjectsLocationsExternalApisPatchRequest object.

  Fields:
    googleCloudApihubV1ExternalApi: A GoogleCloudApihubV1ExternalApi resource
      to be passed as the request body.
    name: Identifier. Format:
      `projects/{project}/locations/{location}/externalApi/{externalApi}`.
    updateMask: Required. The list of fields to update.
  """

  googleCloudApihubV1ExternalApi = _messages.MessageField('GoogleCloudApihubV1ExternalApi', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class ApihubProjectsLocationsGetRequest(_messages.Message):
  r"""A ApihubProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsHostProjectRegistrationsCreateRequest(_messages.Message):
  r"""A ApihubProjectsLocationsHostProjectRegistrationsCreateRequest object.

  Fields:
    googleCloudApihubV1HostProjectRegistration: A
      GoogleCloudApihubV1HostProjectRegistration resource to be passed as the
      request body.
    hostProjectRegistrationId: Required. The ID to use for the Host Project
      Registration, which will become the final component of the host project
      registration's resource name. The ID must be the same as the Google
      cloud project specified in the host_project_registration.gcp_project
      field.
    parent: Required. The parent resource for the host project. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudApihubV1HostProjectRegistration = _messages.MessageField('GoogleCloudApihubV1HostProjectRegistration', 1)
  hostProjectRegistrationId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ApihubProjectsLocationsHostProjectRegistrationsGetRequest(_messages.Message):
  r"""A ApihubProjectsLocationsHostProjectRegistrationsGetRequest object.

  Fields:
    name: Required. Host project registration resource name. projects/{project
      }/locations/{location}/hostProjectRegistrations/{hostProjectRegistration
      _id}
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsHostProjectRegistrationsListRequest(_messages.Message):
  r"""A ApihubProjectsLocationsHostProjectRegistrationsListRequest object.

  Fields:
    filter: Optional. An expression that filters the list of
      HostProjectRegistrations. A filter expression consists of a field name,
      a comparison operator, and a value for filtering. The value must be a
      string. All standard operators as documented at
      https://google.aip.dev/160 are supported. The following fields in the
      `HostProjectRegistration` are eligible for filtering: * `name` - The
      name of the HostProjectRegistration. * `create_time` - The time at which
      the HostProjectRegistration was created. The value should be in the
      (RFC3339)[https://tools.ietf.org/html/rfc3339] format. * `gcp_project` -
      The Google cloud project associated with the HostProjectRegistration.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. The maximum number of host project registrations to
      return. The service may return fewer than this value. If unspecified, at
      most 50 host project registrations will be returned. The maximum value
      is 1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListHostProjectRegistrations` call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters (except
      page_size) provided to `ListHostProjectRegistrations` must match the
      call that provided the page token.
    parent: Required. The parent, which owns this collection of host projects.
      Format: 'projects/*/locations/*'
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ApihubProjectsLocationsListRequest(_messages.Message):
  r"""A ApihubProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ApihubProjectsLocationsLookupRuntimeProjectAttachmentRequest(_messages.Message):
  r"""A ApihubProjectsLocationsLookupRuntimeProjectAttachmentRequest object.

  Fields:
    name: Required. Runtime project ID to look up runtime project attachment
      for. Lookup happens across all regions. Expected format:
      `projects/{project}/locations/{location}`.
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A ApihubProjectsLocationsOperationsCancelRequest object.

  Fields:
    googleLongrunningCancelOperationRequest: A
      GoogleLongrunningCancelOperationRequest resource to be passed as the
      request body.
    name: The name of the operation resource to be cancelled.
  """

  googleLongrunningCancelOperationRequest = _messages.MessageField('GoogleLongrunningCancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class ApihubProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A ApihubProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A ApihubProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A ApihubProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ApihubProjectsLocationsPluginsDisableRequest(_messages.Message):
  r"""A ApihubProjectsLocationsPluginsDisableRequest object.

  Fields:
    googleCloudApihubV1DisablePluginRequest: A
      GoogleCloudApihubV1DisablePluginRequest resource to be passed as the
      request body.
    name: Required. The name of the plugin to disable. Format:
      `projects/{project}/locations/{location}/plugins/{plugin}`.
  """

  googleCloudApihubV1DisablePluginRequest = _messages.MessageField('GoogleCloudApihubV1DisablePluginRequest', 1)
  name = _messages.StringField(2, required=True)


class ApihubProjectsLocationsPluginsEnableRequest(_messages.Message):
  r"""A ApihubProjectsLocationsPluginsEnableRequest object.

  Fields:
    googleCloudApihubV1EnablePluginRequest: A
      GoogleCloudApihubV1EnablePluginRequest resource to be passed as the
      request body.
    name: Required. The name of the plugin to enable. Format:
      `projects/{project}/locations/{location}/plugins/{plugin}`.
  """

  googleCloudApihubV1EnablePluginRequest = _messages.MessageField('GoogleCloudApihubV1EnablePluginRequest', 1)
  name = _messages.StringField(2, required=True)


class ApihubProjectsLocationsPluginsGetRequest(_messages.Message):
  r"""A ApihubProjectsLocationsPluginsGetRequest object.

  Fields:
    name: Required. The name of the plugin to retrieve. Format:
      `projects/{project}/locations/{location}/plugins/{plugin}`.
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsPluginsGetStyleGuideRequest(_messages.Message):
  r"""A ApihubProjectsLocationsPluginsGetStyleGuideRequest object.

  Fields:
    name: Required. The name of the spec to retrieve. Format:
      `projects/{project}/locations/{location}/plugins/{plugin}/styleGuide`.
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsPluginsStyleGuideGetContentsRequest(_messages.Message):
  r"""A ApihubProjectsLocationsPluginsStyleGuideGetContentsRequest object.

  Fields:
    name: Required. The name of the StyleGuide whose contents need to be
      retrieved. There is exactly one style guide resource per project per
      location. The expected format is
      `projects/{project}/locations/{location}/plugins/{plugin}/styleGuide`.
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsPluginsUpdateStyleGuideRequest(_messages.Message):
  r"""A ApihubProjectsLocationsPluginsUpdateStyleGuideRequest object.

  Fields:
    googleCloudApihubV1StyleGuide: A GoogleCloudApihubV1StyleGuide resource to
      be passed as the request body.
    name: Identifier. The name of the style guide. Format:
      `projects/{project}/locations/{location}/plugins/{plugin}/styleGuide`
    updateMask: Optional. The list of fields to update.
  """

  googleCloudApihubV1StyleGuide = _messages.MessageField('GoogleCloudApihubV1StyleGuide', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class ApihubProjectsLocationsRuntimeProjectAttachmentsCreateRequest(_messages.Message):
  r"""A ApihubProjectsLocationsRuntimeProjectAttachmentsCreateRequest object.

  Fields:
    googleCloudApihubV1RuntimeProjectAttachment: A
      GoogleCloudApihubV1RuntimeProjectAttachment resource to be passed as the
      request body.
    parent: Required. The parent resource for the Runtime Project Attachment.
      Format: `projects/{project}/locations/{location}`
    runtimeProjectAttachmentId: Required. The ID to use for the Runtime
      Project Attachment, which will become the final component of the Runtime
      Project Attachment's name. The ID must be the same as the project ID of
      the Google cloud project specified in the
      runtime_project_attachment.runtime_project field.
  """

  googleCloudApihubV1RuntimeProjectAttachment = _messages.MessageField('GoogleCloudApihubV1RuntimeProjectAttachment', 1)
  parent = _messages.StringField(2, required=True)
  runtimeProjectAttachmentId = _messages.StringField(3)


class ApihubProjectsLocationsRuntimeProjectAttachmentsDeleteRequest(_messages.Message):
  r"""A ApihubProjectsLocationsRuntimeProjectAttachmentsDeleteRequest object.

  Fields:
    name: Required. The name of the Runtime Project Attachment to delete.
      Format: `projects/{project}/locations/{location}/runtimeProjectAttachmen
      ts/{runtime_project_attachment}`
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsRuntimeProjectAttachmentsGetRequest(_messages.Message):
  r"""A ApihubProjectsLocationsRuntimeProjectAttachmentsGetRequest object.

  Fields:
    name: Required. The name of the API resource to retrieve. Format: `project
      s/{project}/locations/{location}/runtimeProjectAttachments/{runtime_proj
      ect_attachment}`
  """

  name = _messages.StringField(1, required=True)


class ApihubProjectsLocationsRuntimeProjectAttachmentsListRequest(_messages.Message):
  r"""A ApihubProjectsLocationsRuntimeProjectAttachmentsListRequest object.

  Fields:
    filter: Optional. An expression that filters the list of
      RuntimeProjectAttachments. A filter expression consists of a field name,
      a comparison operator, and a value for filtering. The value must be a
      string. All standard operators as documented at
      https://google.aip.dev/160 are supported. The following fields in the
      `RuntimeProjectAttachment` are eligible for filtering: * `name` - The
      name of the RuntimeProjectAttachment. * `create_time` - The time at
      which the RuntimeProjectAttachment was created. The value should be in
      the (RFC3339)[https://tools.ietf.org/html/rfc3339] format. *
      `runtime_project` - The Google cloud project associated with the
      RuntimeProjectAttachment.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. The maximum number of runtime project attachments to
      return. The service may return fewer than this value. If unspecified, at
      most 50 runtime project attachments will be returned. The maximum value
      is 1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListRuntimeProjectAttachments` call. Provide this to retrieve the
      subsequent page. When paginating, all other parameters (except
      page_size) provided to `ListRuntimeProjectAttachments` must match the
      call that provided the page token.
    parent: Required. The parent, which owns this collection of runtime
      project attachments. Format: `projects/{project}/locations/{location}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ApihubProjectsLocationsSearchResourcesRequest(_messages.Message):
  r"""A ApihubProjectsLocationsSearchResourcesRequest object.

  Fields:
    googleCloudApihubV1SearchResourcesRequest: A
      GoogleCloudApihubV1SearchResourcesRequest resource to be passed as the
      request body.
    location: Required. The resource name of the location which will be of the
      type `projects/{project_id}/locations/{location_id}`. This field is used
      to identify the instance of API-Hub in which resources should be
      searched.
  """

  googleCloudApihubV1SearchResourcesRequest = _messages.MessageField('GoogleCloudApihubV1SearchResourcesRequest', 1)
  location = _messages.StringField(2, required=True)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class GoogleCloudApihubV1AllowedValue(_messages.Message):
  r"""The value that can be assigned to the attribute when the data type is
  enum.

  Fields:
    description: Optional. The detailed description of the allowed value.
    displayName: Required. The display name of the allowed value.
    id: Required. The ID of the allowed value. * If provided, the same will be
      used. The service will throw an error if the specified id is already
      used by another allowed value in the same attribute resource. * If not
      provided, a system generated id derived from the display name will be
      used. In this case, the service will handle conflict resolution by
      adding a system generated suffix in case of duplicates. This value
      should be 4-63 characters, and valid characters are /a-z-/.
    immutable: Optional. When set to true, the allowed value cannot be updated
      or deleted by the user. It can only be true for System defined
      attributes.
  """

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  id = _messages.StringField(3)
  immutable = _messages.BooleanField(4)


class GoogleCloudApihubV1Api(_messages.Message):
  r"""An API resource in the API Hub.

  Messages:
    AttributesValue: Optional. The list of user defined attributes associated
      with the API resource. The key is the attribute name. It will be of the
      format:
      `projects/{project}/locations/{location}/attributes/{attribute}`. The
      value is the attribute values associated with the resource.

  Fields:
    apiStyle: Optional. The style of the API. This maps to the following
      system defined attribute:
      `projects/{project}/locations/{location}/attributes/system-api-style`
      attribute. The number of values for this attribute will be based on the
      cardinality of the attribute. The same can be retrieved via GetAttribute
      API. All values should be from the list of allowed values defined for
      the attribute.
    attributes: Optional. The list of user defined attributes associated with
      the API resource. The key is the attribute name. It will be of the
      format:
      `projects/{project}/locations/{location}/attributes/{attribute}`. The
      value is the attribute values associated with the resource.
    businessUnit: Optional. The business unit owning the API. This maps to the
      following system defined attribute:
      `projects/{project}/locations/{location}/attributes/system-business-
      unit` attribute. The number of values for this attribute will be based
      on the cardinality of the attribute. The same can be retrieved via
      GetAttribute API. All values should be from the list of allowed values
      defined for the attribute.
    createTime: Output only. The time at which the API resource was created.
    description: Optional. The description of the API resource.
    displayName: Required. The display name of the API resource.
    documentation: Optional. The documentation for the API resource.
    maturityLevel: Optional. The maturity level of the API. This maps to the
      following system defined attribute:
      `projects/{project}/locations/{location}/attributes/system-maturity-
      level` attribute. The number of values for this attribute will be based
      on the cardinality of the attribute. The same can be retrieved via
      GetAttribute API. All values should be from the list of allowed values
      defined for the attribute.
    name: Identifier. The name of the API resource in the API Hub. Format:
      `projects/{project}/locations/{location}/apis/{api}`
    owner: Optional. Owner details for the API resource.
    selectedVersion: Optional. The selected version for an API resource. This
      can be used when special handling is needed on client side for
      particular version of the API. Format is
      `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
    targetUser: Optional. The target users for the API. This maps to the
      following system defined attribute:
      `projects/{project}/locations/{location}/attributes/system-target-user`
      attribute. The number of values for this attribute will be based on the
      cardinality of the attribute. The same can be retrieved via GetAttribute
      API. All values should be from the list of allowed values defined for
      the attribute.
    team: Optional. The team owning the API. This maps to the following system
      defined attribute:
      `projects/{project}/locations/{location}/attributes/system-team`
      attribute. The number of values for this attribute will be based on the
      cardinality of the attribute. The same can be retrieved via GetAttribute
      API. All values should be from the list of allowed values defined for
      the attribute.
    updateTime: Output only. The time at which the API resource was last
      updated.
    versions: Output only. The list of versions present in an API resource.
      Note: An API resource can be associated with more than 1 version. Format
      is
      `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AttributesValue(_messages.Message):
    r"""Optional. The list of user defined attributes associated with the API
    resource. The key is the attribute name. It will be of the format:
    `projects/{project}/locations/{location}/attributes/{attribute}`. The
    value is the attribute values associated with the resource.

    Messages:
      AdditionalProperty: An additional property for a AttributesValue object.

    Fields:
      additionalProperties: Additional properties of type AttributesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AttributesValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudApihubV1AttributeValues attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  apiStyle = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 1)
  attributes = _messages.MessageField('AttributesValue', 2)
  businessUnit = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 3)
  createTime = _messages.StringField(4)
  description = _messages.StringField(5)
  displayName = _messages.StringField(6)
  documentation = _messages.MessageField('GoogleCloudApihubV1Documentation', 7)
  maturityLevel = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 8)
  name = _messages.StringField(9)
  owner = _messages.MessageField('GoogleCloudApihubV1Owner', 10)
  selectedVersion = _messages.StringField(11)
  targetUser = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 12)
  team = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 13)
  updateTime = _messages.StringField(14)
  versions = _messages.StringField(15, repeated=True)


class GoogleCloudApihubV1ApiHubInstance(_messages.Message):
  r"""An ApiHubInstance represents the instance resources of the API Hub.
  Currently, only one ApiHub instance is allowed for each project.

  Enums:
    StateValueValuesEnum: Output only. The current state of the ApiHub
      instance.

  Messages:
    LabelsValue: Optional. Instance labels to represent user-provided
      metadata. Refer to cloud documentation on labels for more details.
      https://cloud.google.com/compute/docs/labeling-resources

  Fields:
    config: Required. Config of the ApiHub instance.
    createTime: Output only. Creation timestamp.
    description: Optional. Description of the ApiHub instance.
    labels: Optional. Instance labels to represent user-provided metadata.
      Refer to cloud documentation on labels for more details.
      https://cloud.google.com/compute/docs/labeling-resources
    name: Identifier. Format: `projects/{project}/locations/{location}/apiHubI
      nstances/{apiHubInstance}`.
    state: Output only. The current state of the ApiHub instance.
    stateMessage: Output only. Extra information about ApiHub instance state.
      Currently the message would be populated when state is `FAILED`.
    updateTime: Output only. Last update timestamp.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the ApiHub instance.

    Values:
      STATE_UNSPECIFIED: The default value. This value is used if the state is
        omitted.
      INACTIVE: The ApiHub instance has not been initialized or has been
        deleted.
      CREATING: The ApiHub instance is being created.
      ACTIVE: The ApiHub instance has been created and is ready for use.
      UPDATING: The ApiHub instance is being updated.
      DELETING: The ApiHub instance is being deleted.
      FAILED: The ApiHub instance encountered an error during a state change.
    """
    STATE_UNSPECIFIED = 0
    INACTIVE = 1
    CREATING = 2
    ACTIVE = 3
    UPDATING = 4
    DELETING = 5
    FAILED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Instance labels to represent user-provided metadata. Refer
    to cloud documentation on labels for more details.
    https://cloud.google.com/compute/docs/labeling-resources

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  config = _messages.MessageField('GoogleCloudApihubV1Config', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  stateMessage = _messages.StringField(7)
  updateTime = _messages.StringField(8)


class GoogleCloudApihubV1ApiHubResource(_messages.Message):
  r"""ApiHubResource is one of the resources such as Api, Operation,
  Deployment, Definition, Spec and Version resources stored in API-Hub.

  Fields:
    api: This represents Api resource in search results. Only name,
      display_name, description and owner fields are populated in search
      results.
    definition: This represents Definition resource in search results. Only
      name field is populated in search results.
    deployment: This represents Deployment resource in search results. Only
      name, display_name and description fields are populated in search
      results.
    operation: This represents ApiOperation resource in search results. Only
      name, and description fields are populated in search results.
    spec: This represents Spec resource in search results. Only name,
      display_name and description fields are populated in search results.
    version: This represents Version resource in search results. Only name,
      display_name and description fields are populated in search results.
  """

  api = _messages.MessageField('GoogleCloudApihubV1Api', 1)
  definition = _messages.MessageField('GoogleCloudApihubV1Definition', 2)
  deployment = _messages.MessageField('GoogleCloudApihubV1Deployment', 3)
  operation = _messages.MessageField('GoogleCloudApihubV1ApiOperation', 4)
  spec = _messages.MessageField('GoogleCloudApihubV1Spec', 5)
  version = _messages.MessageField('GoogleCloudApihubV1Version', 6)


class GoogleCloudApihubV1ApiOperation(_messages.Message):
  r"""Represents an operation contained in an API version in the API Hub. An
  operation is added/updated/deleted in an API version when a new spec is
  added or an existing spec is updated/deleted in a version. Currently, an
  operation will be created only corresponding to OpenAPI spec as parsing is
  supported for OpenAPI spec.

  Messages:
    AttributesValue: Optional. The list of user defined attributes associated
      with the API operation resource. The key is the attribute name. It will
      be of the format:
      `projects/{project}/locations/{location}/attributes/{attribute}`. The
      value is the attribute values associated with the resource.

  Fields:
    attributes: Optional. The list of user defined attributes associated with
      the API operation resource. The key is the attribute name. It will be of
      the format:
      `projects/{project}/locations/{location}/attributes/{attribute}`. The
      value is the attribute values associated with the resource.
    createTime: Output only. The time at which the operation was created.
    details: Output only. Operation details.
    name: Identifier. The name of the operation. Format: `projects/{project}/l
      ocations/{location}/apis/{api}/versions/{version}/operations/{operation}
      `
    spec: Output only. The name of the spec from where the operation was
      parsed. Format is `projects/{project}/locations/{location}/apis/{api}/ve
      rsions/{version}/specs/{spec}`
    updateTime: Output only. The time at which the operation was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AttributesValue(_messages.Message):
    r"""Optional. The list of user defined attributes associated with the API
    operation resource. The key is the attribute name. It will be of the
    format: `projects/{project}/locations/{location}/attributes/{attribute}`.
    The value is the attribute values associated with the resource.

    Messages:
      AdditionalProperty: An additional property for a AttributesValue object.

    Fields:
      additionalProperties: Additional properties of type AttributesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AttributesValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudApihubV1AttributeValues attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  attributes = _messages.MessageField('AttributesValue', 1)
  createTime = _messages.StringField(2)
  details = _messages.MessageField('GoogleCloudApihubV1OperationDetails', 3)
  name = _messages.StringField(4)
  spec = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class GoogleCloudApihubV1Attribute(_messages.Message):
  r"""An attribute in the API Hub. An attribute is a name value pair which can
  be attached to different resources in the API hub based on the scope of the
  attribute. Attributes can either be pre-defined by the API Hub or created by
  users.

  Enums:
    DataTypeValueValuesEnum: Required. The type of the data of the attribute.
    DefinitionTypeValueValuesEnum: Output only. The definition type of the
      attribute.
    ScopeValueValuesEnum: Required. The scope of the attribute. It represents
      the resource in the API Hub to which the attribute can be linked.

  Fields:
    allowedValues: Optional. The list of allowed values when the attribute
      value is of type enum. This is required when the data_type of the
      attribute is ENUM. The maximum number of allowed values of an attribute
      will be 1000.
    cardinality: Optional. The maximum number of values that the attribute can
      have when associated with an API Hub resource. Cardinality 1 would
      represent a single-valued attribute. It must not be less than 1 or
      greater than 20. If not specified, the cardinality would be set to 1 by
      default and represent a single-valued attribute.
    createTime: Output only. The time at which the attribute was created.
    dataType: Required. The type of the data of the attribute.
    definitionType: Output only. The definition type of the attribute.
    description: Optional. The description of the attribute.
    displayName: Required. The display name of the attribute.
    mandatory: Output only. When mandatory is true, the attribute is mandatory
      for the resource specified in the scope. Only System defined attributes
      can be mandatory.
    name: Identifier. The name of the attribute in the API Hub. Format:
      `projects/{project}/locations/{location}/attributes/{attribute}`
    scope: Required. The scope of the attribute. It represents the resource in
      the API Hub to which the attribute can be linked.
    updateTime: Output only. The time at which the attribute was last updated.
  """

  class DataTypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the data of the attribute.

    Values:
      DATA_TYPE_UNSPECIFIED: Attribute data type unspecified.
      ENUM: Attribute's value is of type enum.
      JSON: Attribute's value is of type json.
      STRING: Attribute's value is of type string.
    """
    DATA_TYPE_UNSPECIFIED = 0
    ENUM = 1
    JSON = 2
    STRING = 3

  class DefinitionTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The definition type of the attribute.

    Values:
      DEFINITION_TYPE_UNSPECIFIED: Attribute definition type unspecified.
      SYSTEM_DEFINED: The attribute is predefined by the API Hub. Note that
        only the list of allowed values can be updated in this case via
        UpdateAttribute method.
      USER_DEFINED: The attribute is defined by the user.
    """
    DEFINITION_TYPE_UNSPECIFIED = 0
    SYSTEM_DEFINED = 1
    USER_DEFINED = 2

  class ScopeValueValuesEnum(_messages.Enum):
    r"""Required. The scope of the attribute. It represents the resource in
    the API Hub to which the attribute can be linked.

    Values:
      SCOPE_UNSPECIFIED: Scope Unspecified.
      API: Attribute can be linked to an API.
      VERSION: Attribute can be linked to an API version.
      SPEC: Attribute can be linked to a Spec.
      API_OPERATION: Attribute can be linked to an API Operation.
      DEPLOYMENT: Attribute can be linked to a Deployment.
      DEPENDENCY: Attribute can be linked to a Dependency.
      DEFINITION: Attribute can be linked to a definition.
      EXTERNAL_API: Attribute can be linked to a ExternalAPI.
      PLUGIN: Attribute can be linked to a Plugin.
    """
    SCOPE_UNSPECIFIED = 0
    API = 1
    VERSION = 2
    SPEC = 3
    API_OPERATION = 4
    DEPLOYMENT = 5
    DEPENDENCY = 6
    DEFINITION = 7
    EXTERNAL_API = 8
    PLUGIN = 9

  allowedValues = _messages.MessageField('GoogleCloudApihubV1AllowedValue', 1, repeated=True)
  cardinality = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  createTime = _messages.StringField(3)
  dataType = _messages.EnumField('DataTypeValueValuesEnum', 4)
  definitionType = _messages.EnumField('DefinitionTypeValueValuesEnum', 5)
  description = _messages.StringField(6)
  displayName = _messages.StringField(7)
  mandatory = _messages.BooleanField(8)
  name = _messages.StringField(9)
  scope = _messages.EnumField('ScopeValueValuesEnum', 10)
  updateTime = _messages.StringField(11)


class GoogleCloudApihubV1AttributeValues(_messages.Message):
  r"""The attribute values associated with resource.

  Fields:
    attribute: Output only. The name of the attribute. Format:
      projects/{project}/locations/{location}/attributes/{attribute}
    enumValues: The attribute values associated with a resource in case
      attribute data type is enum.
    jsonValues: The attribute values associated with a resource in case
      attribute data type is JSON.
    stringValues: The attribute values associated with a resource in case
      attribute data type is string.
  """

  attribute = _messages.StringField(1)
  enumValues = _messages.MessageField('GoogleCloudApihubV1EnumAttributeValues', 2)
  jsonValues = _messages.MessageField('GoogleCloudApihubV1StringAttributeValues', 3)
  stringValues = _messages.MessageField('GoogleCloudApihubV1StringAttributeValues', 4)


class GoogleCloudApihubV1Config(_messages.Message):
  r"""Available configurations to provision an ApiHub Instance.

  Fields:
    cmekKeyName: Required. The Customer Managed Encryption Key (CMEK) used for
      data encryption. The CMEK name should follow the format of `projects/([^
      /]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`, where the
      location must match the instance location.
  """

  cmekKeyName = _messages.StringField(1)


class GoogleCloudApihubV1Definition(_messages.Message):
  r"""Represents a definition for example schema, request, response
  definitions contained in an API version. A definition is
  added/updated/deleted in an API version when a new spec is added or an
  existing spec is updated/deleted in a version. Currently, definition will be
  created only corresponding to OpenAPI spec as parsing is supported for
  OpenAPI spec. Also, within OpenAPI spec, only `schema` object is supported.

  Enums:
    TypeValueValuesEnum: Output only. The type of the definition.

  Messages:
    AttributesValue: Optional. The list of user defined attributes associated
      with the definition resource. The key is the attribute name. It will be
      of the format:
      `projects/{project}/locations/{location}/attributes/{attribute}`. The
      value is the attribute values associated with the resource.

  Fields:
    attributes: Optional. The list of user defined attributes associated with
      the definition resource. The key is the attribute name. It will be of
      the format:
      `projects/{project}/locations/{location}/attributes/{attribute}`. The
      value is the attribute values associated with the resource.
    createTime: Output only. The time at which the definition was created.
    name: Identifier. The name of the definition. Format: `projects/{project}/
      locations/{location}/apis/{api}/versions/{version}/definitions/{definiti
      on}`
    schema: Output only. The value of a schema definition.
    spec: Output only. The name of the spec from where the definition was
      parsed. Format is `projects/{project}/locations/{location}/apis/{api}/ve
      rsions/{version}/specs/{spec}`
    type: Output only. The type of the definition.
    updateTime: Output only. The time at which the definition was last
      updated.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of the definition.

    Values:
      TYPE_UNSPECIFIED: Definition type unspecified.
      SCHEMA: Definition type schema.
    """
    TYPE_UNSPECIFIED = 0
    SCHEMA = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AttributesValue(_messages.Message):
    r"""Optional. The list of user defined attributes associated with the
    definition resource. The key is the attribute name. It will be of the
    format: `projects/{project}/locations/{location}/attributes/{attribute}`.
    The value is the attribute values associated with the resource.

    Messages:
      AdditionalProperty: An additional property for a AttributesValue object.

    Fields:
      additionalProperties: Additional properties of type AttributesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AttributesValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudApihubV1AttributeValues attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  attributes = _messages.MessageField('AttributesValue', 1)
  createTime = _messages.StringField(2)
  name = _messages.StringField(3)
  schema = _messages.MessageField('GoogleCloudApihubV1Schema', 4)
  spec = _messages.StringField(5)
  type = _messages.EnumField('TypeValueValuesEnum', 6)
  updateTime = _messages.StringField(7)


class GoogleCloudApihubV1Dependency(_messages.Message):
  r"""A dependency resource defined in the API hub describes a dependency
  directed from a consumer to a supplier entity. A dependency can be defined
  between two Operations or between an Operation and External API.

  Enums:
    DiscoveryModeValueValuesEnum: Output only. Discovery mode of the
      dependency.
    StateValueValuesEnum: Output only. State of the dependency.

  Messages:
    AttributesValue: Optional. The list of user defined attributes associated
      with the dependency resource. The key is the attribute name. It will be
      of the format:
      `projects/{project}/locations/{location}/attributes/{attribute}`. The
      value is the attribute values associated with the resource.

  Fields:
    attributes: Optional. The list of user defined attributes associated with
      the dependency resource. The key is the attribute name. It will be of
      the format:
      `projects/{project}/locations/{location}/attributes/{attribute}`. The
      value is the attribute values associated with the resource.
    consumer: Required. Immutable. The entity acting as the consumer in the
      dependency.
    createTime: Output only. The time at which the dependency was created.
    description: Optional. Human readable description corresponding of the
      dependency.
    discoveryMode: Output only. Discovery mode of the dependency.
    errorDetail: Output only. Error details of a dependency if the system has
      detected it internally.
    name: Identifier. The name of the dependency in the API Hub. Format:
      `projects/{project}/locations/{location}/dependencies/{dependency}`
    state: Output only. State of the dependency.
    supplier: Required. Immutable. The entity acting as the supplier in the
      dependency.
    updateTime: Output only. The time at which the dependency was last
      updated.
  """

  class DiscoveryModeValueValuesEnum(_messages.Enum):
    r"""Output only. Discovery mode of the dependency.

    Values:
      DISCOVERY_MODE_UNSPECIFIED: Default value. This value is unused.
      MANUAL: Manual mode of discovery when the dependency is defined by the
        user.
    """
    DISCOVERY_MODE_UNSPECIFIED = 0
    MANUAL = 1

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the dependency.

    Values:
      STATE_UNSPECIFIED: Default value. This value is unused.
      PROPOSED: Dependency will be in a proposed state when it is newly
        identified by the API hub on its own.
      VALIDATED: Dependency will be in a validated state when it is validated
        by the admin or manually created in the API hub.
    """
    STATE_UNSPECIFIED = 0
    PROPOSED = 1
    VALIDATED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AttributesValue(_messages.Message):
    r"""Optional. The list of user defined attributes associated with the
    dependency resource. The key is the attribute name. It will be of the
    format: `projects/{project}/locations/{location}/attributes/{attribute}`.
    The value is the attribute values associated with the resource.

    Messages:
      AdditionalProperty: An additional property for a AttributesValue object.

    Fields:
      additionalProperties: Additional properties of type AttributesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AttributesValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudApihubV1AttributeValues attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  attributes = _messages.MessageField('AttributesValue', 1)
  consumer = _messages.MessageField('GoogleCloudApihubV1DependencyEntityReference', 2)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  discoveryMode = _messages.EnumField('DiscoveryModeValueValuesEnum', 5)
  errorDetail = _messages.MessageField('GoogleCloudApihubV1DependencyErrorDetail', 6)
  name = _messages.StringField(7)
  state = _messages.EnumField('StateValueValuesEnum', 8)
  supplier = _messages.MessageField('GoogleCloudApihubV1DependencyEntityReference', 9)
  updateTime = _messages.StringField(10)


class GoogleCloudApihubV1DependencyEntityReference(_messages.Message):
  r"""Reference to an entity participating in a dependency.

  Fields:
    displayName: Output only. Display name of the entity.
    externalApiResourceName: The resource name of an external API in the API
      Hub. Format:
      `projects/{project}/locations/{location}/externalApis/{external_api}`
    operationResourceName: The resource name of an operation in the API Hub.
      Format: `projects/{project}/locations/{location}/apis/{api}/versions/{ve
      rsion}/operations/{operation}`
  """

  displayName = _messages.StringField(1)
  externalApiResourceName = _messages.StringField(2)
  operationResourceName = _messages.StringField(3)


class GoogleCloudApihubV1DependencyErrorDetail(_messages.Message):
  r"""Details describing error condition of a dependency.

  Enums:
    ErrorValueValuesEnum: Optional. Error in the dependency.

  Fields:
    error: Optional. Error in the dependency.
    errorTime: Optional. Timestamp at which the error was found.
  """

  class ErrorValueValuesEnum(_messages.Enum):
    r"""Optional. Error in the dependency.

    Values:
      ERROR_UNSPECIFIED: Default value used for no error in the dependency.
      SUPPLIER_NOT_FOUND: Supplier entity has been deleted.
      SUPPLIER_RECREATED: Supplier entity has been recreated.
    """
    ERROR_UNSPECIFIED = 0
    SUPPLIER_NOT_FOUND = 1
    SUPPLIER_RECREATED = 2

  error = _messages.EnumField('ErrorValueValuesEnum', 1)
  errorTime = _messages.StringField(2)


class GoogleCloudApihubV1Deployment(_messages.Message):
  r"""Details of the deployment where APIs are hosted. A deployment could
  represent an Apigee proxy, API gateway, other Google Cloud services or non-
  Google Cloud services as well. A deployment entity is a root level entity in
  the API hub and exists independent of any API.

  Messages:
    AttributesValue: Optional. The list of user defined attributes associated
      with the deployment resource. The key is the attribute name. It will be
      of the format:
      `projects/{project}/locations/{location}/attributes/{attribute}`. The
      value is the attribute values associated with the resource.

  Fields:
    apiVersions: Output only. The API versions linked to this deployment.
      Note: A particular deployment could be linked to multiple different API
      versions (of same or different APIs).
    attributes: Optional. The list of user defined attributes associated with
      the deployment resource. The key is the attribute name. It will be of
      the format:
      `projects/{project}/locations/{location}/attributes/{attribute}`. The
      value is the attribute values associated with the resource.
    createTime: Output only. The time at which the deployment was created.
    deploymentType: Required. The type of deployment. This maps to the
      following system defined attribute:
      `projects/{project}/locations/{location}/attributes/system-deployment-
      type` attribute. The number of values for this attribute will be based
      on the cardinality of the attribute. The same can be retrieved via
      GetAttribute API. All values should be from the list of allowed values
      defined for the attribute.
    description: Optional. The description of the deployment.
    displayName: Required. The display name of the deployment.
    documentation: Optional. The documentation of the deployment.
    endpoints: Required. The endpoints at which this deployment resource is
      listening for API requests. This could be a list of complete URIs,
      hostnames or an IP addresses.
    environment: Optional. The environment mapping to this deployment. This
      maps to the following system defined attribute:
      `projects/{project}/locations/{location}/attributes/system-environment`
      attribute. The number of values for this attribute will be based on the
      cardinality of the attribute. The same can be retrieved via GetAttribute
      API. All values should be from the list of allowed values defined for
      the attribute.
    name: Identifier. The name of the deployment. Format:
      `projects/{project}/locations/{location}/deployments/{deployment}`
    resourceUri: Required. A URI to the runtime resource. This URI can be used
      to manage the resource. For example, if the runtime resource is of type
      APIGEE_PROXY, then this field will contain the URI to the management UI
      of the proxy.
    slo: Optional. The SLO for this deployment. This maps to the following
      system defined attribute:
      `projects/{project}/locations/{location}/attributes/system-slo`
      attribute. The number of values for this attribute will be based on the
      cardinality of the attribute. The same can be retrieved via GetAttribute
      API. All values should be from the list of allowed values defined for
      the attribute.
    updateTime: Output only. The time at which the deployment was last
      updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AttributesValue(_messages.Message):
    r"""Optional. The list of user defined attributes associated with the
    deployment resource. The key is the attribute name. It will be of the
    format: `projects/{project}/locations/{location}/attributes/{attribute}`.
    The value is the attribute values associated with the resource.

    Messages:
      AdditionalProperty: An additional property for a AttributesValue object.

    Fields:
      additionalProperties: Additional properties of type AttributesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AttributesValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudApihubV1AttributeValues attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  apiVersions = _messages.StringField(1, repeated=True)
  attributes = _messages.MessageField('AttributesValue', 2)
  createTime = _messages.StringField(3)
  deploymentType = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 4)
  description = _messages.StringField(5)
  displayName = _messages.StringField(6)
  documentation = _messages.MessageField('GoogleCloudApihubV1Documentation', 7)
  endpoints = _messages.StringField(8, repeated=True)
  environment = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 9)
  name = _messages.StringField(10)
  resourceUri = _messages.StringField(11)
  slo = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 12)
  updateTime = _messages.StringField(13)


class GoogleCloudApihubV1DisablePluginRequest(_messages.Message):
  r"""The DisablePlugin method's request."""


class GoogleCloudApihubV1Documentation(_messages.Message):
  r"""Documentation details.

  Fields:
    externalUri: Optional. The uri of the externally hosted documentation.
  """

  externalUri = _messages.StringField(1)


class GoogleCloudApihubV1EnablePluginRequest(_messages.Message):
  r"""The EnablePlugin method's request."""


class GoogleCloudApihubV1EnumAttributeValues(_messages.Message):
  r"""The attribute values of data type enum.

  Fields:
    values: Required. The attribute values in case attribute data type is
      enum.
  """

  values = _messages.MessageField('GoogleCloudApihubV1AllowedValue', 1, repeated=True)


class GoogleCloudApihubV1ExternalApi(_messages.Message):
  r"""An external API represents an API being provided by external sources.
  This can be used to model third-party APIs and can be used to define
  dependencies.

  Messages:
    AttributesValue: Optional. The list of user defined attributes associated
      with the Version resource. The key is the attribute name. It will be of
      the format:
      `projects/{project}/locations/{location}/attributes/{attribute}`. The
      value is the attribute values associated with the resource.

  Fields:
    attributes: Optional. The list of user defined attributes associated with
      the Version resource. The key is the attribute name. It will be of the
      format:
      `projects/{project}/locations/{location}/attributes/{attribute}`. The
      value is the attribute values associated with the resource.
    createTime: Output only. Creation timestamp.
    description: Optional. Description of the external API. Max length is 2000
      characters (Unicode Code Points).
    displayName: Required. Display name of the external API. Max length is 63
      characters (Unicode Code Points).
    documentation: Optional. Documentation of the external API.
    endpoints: Optional. List of endpoints on which this API is accessible.
    name: Identifier. Format:
      `projects/{project}/locations/{location}/externalApi/{externalApi}`.
    paths: Optional. List of paths served by this API.
    updateTime: Output only. Last update timestamp.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AttributesValue(_messages.Message):
    r"""Optional. The list of user defined attributes associated with the
    Version resource. The key is the attribute name. It will be of the format:
    `projects/{project}/locations/{location}/attributes/{attribute}`. The
    value is the attribute values associated with the resource.

    Messages:
      AdditionalProperty: An additional property for a AttributesValue object.

    Fields:
      additionalProperties: Additional properties of type AttributesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AttributesValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudApihubV1AttributeValues attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  attributes = _messages.MessageField('AttributesValue', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  documentation = _messages.MessageField('GoogleCloudApihubV1Documentation', 5)
  endpoints = _messages.StringField(6, repeated=True)
  name = _messages.StringField(7)
  paths = _messages.StringField(8, repeated=True)
  updateTime = _messages.StringField(9)


class GoogleCloudApihubV1HostProjectRegistration(_messages.Message):
  r"""Host project registration refers to the registration of a Google cloud
  project with Api Hub as a host project. This is the project where Api Hub is
  provisioned. It acts as the consumer project for the Api Hub instance
  provisioned. Multiple runtime projects can be attached to the host project
  and these attachments define the scope of Api Hub.

  Fields:
    createTime: Output only. The time at which the host project registration
      was created.
    gcpProject: Required. Immutable. Google cloud project name in the format:
      "projects/abc" or "projects/123". As input, project name with either
      project id or number are accepted. As output, this field will contain
      project number.
    name: Identifier. The name of the host project registration. Format: "proj
      ects/{project}/locations/{location}/hostProjectRegistrations/{host_proje
      ct_registration}".
  """

  createTime = _messages.StringField(1)
  gcpProject = _messages.StringField(2)
  name = _messages.StringField(3)


class GoogleCloudApihubV1HttpOperation(_messages.Message):
  r"""The HTTP Operation.

  Enums:
    MethodValueValuesEnum: Output only. Operation method

  Fields:
    method: Output only. Operation method
    path: Output only. The path details for the Operation.
  """

  class MethodValueValuesEnum(_messages.Enum):
    r"""Output only. Operation method

    Values:
      METHOD_UNSPECIFIED: Method unspecified.
      GET: Get Operation type.
      PUT: Put Operation type.
      POST: Post Operation type.
      DELETE: Delete Operation type.
      OPTIONS: Options Operation type.
      HEAD: Head Operation type.
      PATCH: Patch Operation type.
      TRACE: Trace Operation type.
    """
    METHOD_UNSPECIFIED = 0
    GET = 1
    PUT = 2
    POST = 3
    DELETE = 4
    OPTIONS = 5
    HEAD = 6
    PATCH = 7
    TRACE = 8

  method = _messages.EnumField('MethodValueValuesEnum', 1)
  path = _messages.MessageField('GoogleCloudApihubV1Path', 2)


class GoogleCloudApihubV1Issue(_messages.Message):
  r"""Issue contains the details of a single issue found by the linter.

  Enums:
    SeverityValueValuesEnum: Required. Severity level of the rule violation.

  Fields:
    code: Required. Rule code unique to each rule defined in linter.
    message: Required. Human-readable message describing the issue found by
      the linter.
    path: Required. An array of strings indicating the location in the
      analyzed document where the rule was triggered.
    range: Required. Object describing where in the file the issue was found.
    severity: Required. Severity level of the rule violation.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Required. Severity level of the rule violation.

    Values:
      SEVERITY_UNSPECIFIED: Severity unspecified.
      SEVERITY_ERROR: Severity error.
      SEVERITY_WARNING: Severity warning.
      SEVERITY_INFO: Severity info.
      SEVERITY_HINT: Severity hint.
    """
    SEVERITY_UNSPECIFIED = 0
    SEVERITY_ERROR = 1
    SEVERITY_WARNING = 2
    SEVERITY_INFO = 3
    SEVERITY_HINT = 4

  code = _messages.StringField(1)
  message = _messages.StringField(2)
  path = _messages.StringField(3, repeated=True)
  range = _messages.MessageField('GoogleCloudApihubV1Range', 4)
  severity = _messages.EnumField('SeverityValueValuesEnum', 5)


class GoogleCloudApihubV1LintResponse(_messages.Message):
  r"""LintResponse contains the response from the linter.

  Enums:
    LinterValueValuesEnum: Required. Name of the linter used.
    StateValueValuesEnum: Required. Lint state represents success or failure
      for linting.

  Fields:
    createTime: Required. Timestamp when the linting response was generated.
    issues: Optional. Array of issues found in the analyzed document.
    linter: Required. Name of the linter used.
    source: Required. Name of the linting application.
    state: Required. Lint state represents success or failure for linting.
    summary: Optional. Summary of all issue types and counts for each severity
      level.
  """

  class LinterValueValuesEnum(_messages.Enum):
    r"""Required. Name of the linter used.

    Values:
      LINTER_UNSPECIFIED: Linter type unspecified.
      SPECTRAL: Linter type spectral.
      OTHER: Linter type other.
    """
    LINTER_UNSPECIFIED = 0
    SPECTRAL = 1
    OTHER = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Required. Lint state represents success or failure for linting.

    Values:
      LINT_STATE_UNSPECIFIED: Lint state unspecified.
      LINT_STATE_SUCCESS: Linting was completed successfully.
      LINT_STATE_ERROR: Linting encountered errors.
    """
    LINT_STATE_UNSPECIFIED = 0
    LINT_STATE_SUCCESS = 1
    LINT_STATE_ERROR = 2

  createTime = _messages.StringField(1)
  issues = _messages.MessageField('GoogleCloudApihubV1Issue', 2, repeated=True)
  linter = _messages.EnumField('LinterValueValuesEnum', 3)
  source = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  summary = _messages.MessageField('GoogleCloudApihubV1SummaryEntry', 6, repeated=True)


class GoogleCloudApihubV1LintSpecRequest(_messages.Message):
  r"""The LintSpec method's request."""


class GoogleCloudApihubV1ListApiOperationsResponse(_messages.Message):
  r"""The ListApiOperations method's response.

  Fields:
    apiOperations: The operations corresponding to an API version. Only
      following field will be populated in the response: name, spec,
      details.deprecated, details.http_operation.path.path,
      details.http_operation.method and details.documentation.external_uri.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  apiOperations = _messages.MessageField('GoogleCloudApihubV1ApiOperation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudApihubV1ListApisResponse(_messages.Message):
  r"""The ListApis method's response.

  Fields:
    apis: The API resources present in the API hub. Only following fields will
      be populated in the response: name, display_name,
      documentation.external_uri, team.enum_values.values.id and
      business_unit.enum_values.values.id.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  apis = _messages.MessageField('GoogleCloudApihubV1Api', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudApihubV1ListAttributesResponse(_messages.Message):
  r"""The ListAttributes method's response.

  Fields:
    attributes: The list of all attributes.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  attributes = _messages.MessageField('GoogleCloudApihubV1Attribute', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudApihubV1ListDependenciesResponse(_messages.Message):
  r"""The ListDependencies method's response.

  Fields:
    dependencies: The dependency resources present in the API hub. Only
      following field will be populated in the response: name.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  dependencies = _messages.MessageField('GoogleCloudApihubV1Dependency', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudApihubV1ListDeploymentsResponse(_messages.Message):
  r"""The ListDeployments method's response.

  Fields:
    deployments: The deployment resources present in the API hub. Only
      following field will be populated in the response: name, display_name,
      documentation.external_uri, deployment_type.enum_values.values.id,
      environment.enum_values.values.id, slo.string_values.values and
      resource_uri.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  deployments = _messages.MessageField('GoogleCloudApihubV1Deployment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudApihubV1ListExternalApisResponse(_messages.Message):
  r"""The ListExternalApis method's response.

  Fields:
    externalApis: The External API resources present in the API hub. Only
      following fields will be populated in the response: name, display_name,
      documentation.external_uri.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  externalApis = _messages.MessageField('GoogleCloudApihubV1ExternalApi', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudApihubV1ListHostProjectRegistrationsResponse(_messages.Message):
  r"""The ListHostProjectRegistrations method's response.

  Fields:
    hostProjectRegistrations: The list of host project registrations.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  hostProjectRegistrations = _messages.MessageField('GoogleCloudApihubV1HostProjectRegistration', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudApihubV1ListRuntimeProjectAttachmentsResponse(_messages.Message):
  r"""The ListRuntimeProjectAttachments method's response.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    runtimeProjectAttachments: List of runtime project attachments.
  """

  nextPageToken = _messages.StringField(1)
  runtimeProjectAttachments = _messages.MessageField('GoogleCloudApihubV1RuntimeProjectAttachment', 2, repeated=True)


class GoogleCloudApihubV1ListSpecsResponse(_messages.Message):
  r"""The ListSpecs method's response.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    specs: The specs corresponding to an API. Only following field will be
      populated in the response: name, display_name,
      spec_type.enum_values.values.id and lint_response.json_values.values.
  """

  nextPageToken = _messages.StringField(1)
  specs = _messages.MessageField('GoogleCloudApihubV1Spec', 2, repeated=True)


class GoogleCloudApihubV1ListVersionsResponse(_messages.Message):
  r"""The ListVersions method's response.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    versions: The versions corresponding to an API. Only following field will
      be populated in the response: name, display_name,
      lifecycle.enum_values.values.id and specs.
  """

  nextPageToken = _messages.StringField(1)
  versions = _messages.MessageField('GoogleCloudApihubV1Version', 2, repeated=True)


class GoogleCloudApihubV1LookupApiHubInstanceResponse(_messages.Message):
  r"""The LookupApiHubInstance method's response.`

  Fields:
    apiHubInstance: API Hub instance for a project if it exists, empty
      otherwise.
  """

  apiHubInstance = _messages.MessageField('GoogleCloudApihubV1ApiHubInstance', 1)


class GoogleCloudApihubV1LookupRuntimeProjectAttachmentResponse(_messages.Message):
  r"""The ListRuntimeProjectAttachments method's response.

  Fields:
    runtimeProjectAttachment: Runtime project attachment for a project if
      exists, empty otherwise.
  """

  runtimeProjectAttachment = _messages.MessageField('GoogleCloudApihubV1RuntimeProjectAttachment', 1)


class GoogleCloudApihubV1OpenApiSpecDetails(_messages.Message):
  r"""OpenApiSpecDetails contains the details parsed from an OpenAPI spec in
  addition to the fields mentioned in SpecDetails.

  Enums:
    FormatValueValuesEnum: Output only. The format of the spec.

  Fields:
    format: Output only. The format of the spec.
    owner: Output only. Owner details for the spec. This maps to
      `info.contact` in OpenAPI spec.
    version: Output only. The version in the spec. This maps to `info.version`
      in OpenAPI spec.
  """

  class FormatValueValuesEnum(_messages.Enum):
    r"""Output only. The format of the spec.

    Values:
      FORMAT_UNSPECIFIED: SpecFile type unspecified.
      OPEN_API_SPEC_2_0: OpenAPI Spec v2.0.
      OPEN_API_SPEC_3_0: OpenAPI Spec v3.0.
      OPEN_API_SPEC_3_1: OpenAPI Spec v3.1.
    """
    FORMAT_UNSPECIFIED = 0
    OPEN_API_SPEC_2_0 = 1
    OPEN_API_SPEC_3_0 = 2
    OPEN_API_SPEC_3_1 = 3

  format = _messages.EnumField('FormatValueValuesEnum', 1)
  owner = _messages.MessageField('GoogleCloudApihubV1Owner', 2)
  version = _messages.StringField(3)


class GoogleCloudApihubV1OperationDetails(_messages.Message):
  r"""The operation details parsed from the spec.

  Fields:
    deprecated: Output only. For OpenAPI spec, this will be set if
      `operation.deprecated`is marked as `true` in the spec.
    description: Output only. Description of the operation behavior. For
      OpenAPI spec, this will map to `operation.description` in the spec, in
      case description is empty, `operation.summary` will be used.
    documentation: Output only. Additional external documentation for this
      operation. For OpenAPI spec, this will map to `operation.documentation`
      in the spec.
    httpOperation: The HTTP Operation.
  """

  deprecated = _messages.BooleanField(1)
  description = _messages.StringField(2)
  documentation = _messages.MessageField('GoogleCloudApihubV1Documentation', 3)
  httpOperation = _messages.MessageField('GoogleCloudApihubV1HttpOperation', 4)


class GoogleCloudApihubV1OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class GoogleCloudApihubV1Owner(_messages.Message):
  r"""Owner details.

  Fields:
    displayName: Optional. The name of the owner.
    email: Required. The email of the owner.
  """

  displayName = _messages.StringField(1)
  email = _messages.StringField(2)


class GoogleCloudApihubV1Path(_messages.Message):
  r"""The path details derived from the spec.

  Fields:
    description: Output only. A short description for the path applicable to
      all operations.
    path: Output only. Complete path relative to server endpoint.
  """

  description = _messages.StringField(1)
  path = _messages.StringField(2)


class GoogleCloudApihubV1Plugin(_messages.Message):
  r"""A plugin resource in the API Hub.

  Enums:
    StateValueValuesEnum: Output only. Represents the state of the plugin.

  Fields:
    description: Optional. The plugin description. Max length is 2000
      characters (Unicode code points).
    displayName: Required. The display name of the plugin. Max length is 50
      characters (Unicode code points).
    name: Identifier. The name of the plugin. Format:
      `projects/{project}/locations/{location}/plugins/{plugin}`
    state: Output only. Represents the state of the plugin.
    type: Required. The type of the API. This maps to the following system
      defined attribute:
      `projects/{project}/locations/{location}/attributes/system-plugin-type`
      attribute. The number of allowed values for this attribute will be based
      on the cardinality of the attribute. The same can be retrieved via
      GetAttribute API. All values should be from the list of allowed values
      defined for the attribute.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Represents the state of the plugin.

    Values:
      STATE_UNSPECIFIED: The default value. This value is used if the state is
        omitted.
      ENABLED: The plugin is enabled.
      DISABLED: The plugin is disabled.
    """
    STATE_UNSPECIFIED = 0
    ENABLED = 1
    DISABLED = 2

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  name = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  type = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 5)


class GoogleCloudApihubV1Point(_messages.Message):
  r"""Point within the file (line and character).

  Fields:
    character: Required. Character position within the line (zero-indexed).
    line: Required. Line number (zero-indexed).
  """

  character = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  line = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudApihubV1Range(_messages.Message):
  r"""Object describing where in the file the issue was found.

  Fields:
    end: Required. End of the issue.
    start: Required. Start of the issue.
  """

  end = _messages.MessageField('GoogleCloudApihubV1Point', 1)
  start = _messages.MessageField('GoogleCloudApihubV1Point', 2)


class GoogleCloudApihubV1RuntimeProjectAttachment(_messages.Message):
  r"""Runtime project attachment represents an attachment from the runtime
  project to the host project. Api Hub looks for deployments in the attached
  runtime projects and creates corresponding resources in Api Hub for the
  discovered deployments.

  Fields:
    createTime: Output only. Create time.
    name: Identifier. The resource name of a runtime project attachment.
      Format: "projects/{project}/locations/{location}/runtimeProjectAttachmen
      ts/{runtime_project_attachment}".
    runtimeProject: Required. Immutable. Google cloud project name in the
      format: "projects/abc" or "projects/123". As input, project name with
      either project id or number are accepted. As output, this field will
      contain project number.
  """

  createTime = _messages.StringField(1)
  name = _messages.StringField(2)
  runtimeProject = _messages.StringField(3)


class GoogleCloudApihubV1Schema(_messages.Message):
  r"""The schema details derived from the spec. Currently, this entity is
  supported for OpenAPI spec only. For OpenAPI spec, this maps to the schema
  defined in the `definitions` section for OpenAPI 2.0 version and in
  `components.schemas` section for OpenAPI 3.0 and 3.1 version.

  Fields:
    displayName: Output only. The display name of the schema. This will map to
      the name of the schema in the spec.
    rawValue: Output only. The raw value of the schema definition
      corresponding to the schema name in the spec.
  """

  displayName = _messages.StringField(1)
  rawValue = _messages.BytesField(2)


class GoogleCloudApihubV1SearchResourcesRequest(_messages.Message):
  r"""The SearchResources method's request.

  Fields:
    filter: Optional. An expression that filters the list of search results. A
      filter expression consists of a field name, a comparison operator, and a
      value for filtering. The value must be a string, a number, or a boolean.
      The comparison operator must be `=`. Filters are not case sensitive. The
      following field names are eligible for filtering: * `resource_type` -
      The type of resource in the search results. Must be one of the
      following: `Api`, `ApiOperation`, `Deployment`, `Definition`, `Spec` or
      `Version`. This field can only be specified once in the filter. Here are
      is an example: * `resource_type = Api` - The resource_type is _Api_.
    pageSize: Optional. The maximum number of search results to return. The
      service may return fewer than this value. If unspecified at most 10
      search results will be returned. If value is negative then
      `INVALID_ARGUMENT` error is returned. The maximum value is 25; values
      above 25 will be coerced to 25. While paginating, you can specify a new
      page size parameter for each page of search results to be listed.
    pageToken: Optional. A page token, received from a previous
      SearchResources call. Specify this parameter to retrieve the next page
      of transactions. When paginating, you must specify the `page_token`
      parameter and all the other parameters except page_size should be
      specified with the same value which was used in the previous call. If
      the other fields are set with a different value than the previous call
      then `INVALID_ARGUMENT` error is returned.
    query: Required. The free text search query. This query can contain
      keywords which could be related to any detail of the API-Hub resources
      such display names, descriptions, attributes etc.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  query = _messages.StringField(4)


class GoogleCloudApihubV1SearchResourcesResponse(_messages.Message):
  r"""Response for the SearchResources method.

  Fields:
    nextPageToken: Pass this token in the SearchResourcesRequest to continue
      to list results. If all results have been returned, this field is an
      empty string or not present in the response.
    searchResults: List of search results according to the filter and search
      query specified. The order of search results represents the ranking.
  """

  nextPageToken = _messages.StringField(1)
  searchResults = _messages.MessageField('GoogleCloudApihubV1SearchResult', 2, repeated=True)


class GoogleCloudApihubV1SearchResult(_messages.Message):
  r"""Represents the search results.

  Fields:
    resource: This represents the ApiHubResource. Note: Only selected fields
      of the resources are populated in response.
  """

  resource = _messages.MessageField('GoogleCloudApihubV1ApiHubResource', 1)


class GoogleCloudApihubV1Spec(_messages.Message):
  r"""Represents a spec associated with an API version in the API Hub. Note
  that specs of various types can be uploaded, however parsing of details is
  supported for OpenAPI spec currently.

  Enums:
    ParsingModeValueValuesEnum: Optional. Input only. Enum specifying the
      parsing mode for OpenAPI Specification (OAS) parsing.

  Messages:
    AttributesValue: Optional. The list of user defined attributes associated
      with the spec. The key is the attribute name. It will be of the format:
      `projects/{project}/locations/{location}/attributes/{attribute}`. The
      value is the attribute values associated with the resource.

  Fields:
    attributes: Optional. The list of user defined attributes associated with
      the spec. The key is the attribute name. It will be of the format:
      `projects/{project}/locations/{location}/attributes/{attribute}`. The
      value is the attribute values associated with the resource.
    contents: Optional. Input only. The contents of the uploaded spec.
    createTime: Output only. The time at which the spec was created.
    details: Output only. Details parsed from the spec.
    displayName: Required. The display name of the spec. This can contain the
      file name of the spec.
    documentation: Optional. The documentation of the spec. For OpenAPI spec,
      this will be populated from `externalDocs` in OpenAPI spec.
    lintResponse: Optional. The lint response for the spec.
    name: Identifier. The name of the spec. Format: `projects/{project}/locati
      ons/{location}/apis/{api}/versions/{version}/specs/{spec}`
    parsingMode: Optional. Input only. Enum specifying the parsing mode for
      OpenAPI Specification (OAS) parsing.
    sourceUri: Optional. The URI of the spec source in case file is uploaded
      from an external version control system.
    specType: Required. The type of spec. The value should be one of the
      allowed values defined for
      `projects/{project}/locations/{location}/attributes/system-spec-type`
      attribute. The number of values for this attribute will be based on the
      cardinality of the attribute. The same can be retrieved via GetAttribute
      API. Note, this field is mandatory if content is provided.
    updateTime: Output only. The time at which the spec was last updated.
  """

  class ParsingModeValueValuesEnum(_messages.Enum):
    r"""Optional. Input only. Enum specifying the parsing mode for OpenAPI
    Specification (OAS) parsing.

    Values:
      PARSING_MODE_UNSPECIFIED: Defaults to `RELAXED`.
      RELAXED: Parsing of the Spec on create and update is relaxed, meaning
        that parsing errors the spec contents will not fail the API call.
      STRICT: Parsing of the Spec on create and update is strict, meaning that
        parsing errors in the spec contents will fail the API call.
    """
    PARSING_MODE_UNSPECIFIED = 0
    RELAXED = 1
    STRICT = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AttributesValue(_messages.Message):
    r"""Optional. The list of user defined attributes associated with the
    spec. The key is the attribute name. It will be of the format:
    `projects/{project}/locations/{location}/attributes/{attribute}`. The
    value is the attribute values associated with the resource.

    Messages:
      AdditionalProperty: An additional property for a AttributesValue object.

    Fields:
      additionalProperties: Additional properties of type AttributesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AttributesValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudApihubV1AttributeValues attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  attributes = _messages.MessageField('AttributesValue', 1)
  contents = _messages.MessageField('GoogleCloudApihubV1SpecContents', 2)
  createTime = _messages.StringField(3)
  details = _messages.MessageField('GoogleCloudApihubV1SpecDetails', 4)
  displayName = _messages.StringField(5)
  documentation = _messages.MessageField('GoogleCloudApihubV1Documentation', 6)
  lintResponse = _messages.MessageField('GoogleCloudApihubV1LintResponse', 7)
  name = _messages.StringField(8)
  parsingMode = _messages.EnumField('ParsingModeValueValuesEnum', 9)
  sourceUri = _messages.StringField(10)
  specType = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 11)
  updateTime = _messages.StringField(12)


class GoogleCloudApihubV1SpecContents(_messages.Message):
  r"""The spec contents.

  Fields:
    contents: Required. The contents of the spec.
    mimeType: Required. The mime type of the content for example
      application/json, application/yaml, application/wsdl etc.
  """

  contents = _messages.BytesField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudApihubV1SpecDetails(_messages.Message):
  r"""SpecDetails contains the details parsed from supported spec types.

  Fields:
    description: Output only. The description of the spec.
    openApiSpecDetails: Output only. Additional details apart from
      `OperationDetails` parsed from an OpenAPI spec. The OperationDetails
      parsed from the spec can be obtained by using ListAPIOperations method.
  """

  description = _messages.StringField(1)
  openApiSpecDetails = _messages.MessageField('GoogleCloudApihubV1OpenApiSpecDetails', 2)


class GoogleCloudApihubV1StringAttributeValues(_messages.Message):
  r"""The attribute values of data type string or JSON.

  Fields:
    values: Required. The attribute values in case attribute data type is
      string or JSON.
  """

  values = _messages.StringField(1, repeated=True)


class GoogleCloudApihubV1StyleGuide(_messages.Message):
  r"""Represents a singleton style guide resource to be used for linting Open
  API specs.

  Enums:
    LinterValueValuesEnum: Required. Target linter for the style guide.

  Fields:
    contents: Required. Input only. The contents of the uploaded style guide.
    linter: Required. Target linter for the style guide.
    name: Identifier. The name of the style guide. Format:
      `projects/{project}/locations/{location}/plugins/{plugin}/styleGuide`
  """

  class LinterValueValuesEnum(_messages.Enum):
    r"""Required. Target linter for the style guide.

    Values:
      LINTER_UNSPECIFIED: Linter type unspecified.
      SPECTRAL: Linter type spectral.
      OTHER: Linter type other.
    """
    LINTER_UNSPECIFIED = 0
    SPECTRAL = 1
    OTHER = 2

  contents = _messages.MessageField('GoogleCloudApihubV1StyleGuideContents', 1)
  linter = _messages.EnumField('LinterValueValuesEnum', 2)
  name = _messages.StringField(3)


class GoogleCloudApihubV1StyleGuideContents(_messages.Message):
  r"""The style guide contents.

  Fields:
    contents: Required. The contents of the style guide.
    mimeType: Required. The mime type of the content.
  """

  contents = _messages.BytesField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudApihubV1SummaryEntry(_messages.Message):
  r"""Count of issues with a given severity.

  Enums:
    SeverityValueValuesEnum: Required. Severity of the issue.

  Fields:
    count: Required. Count of issues with the given severity.
    severity: Required. Severity of the issue.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Required. Severity of the issue.

    Values:
      SEVERITY_UNSPECIFIED: Severity unspecified.
      SEVERITY_ERROR: Severity error.
      SEVERITY_WARNING: Severity warning.
      SEVERITY_INFO: Severity info.
      SEVERITY_HINT: Severity hint.
    """
    SEVERITY_UNSPECIFIED = 0
    SEVERITY_ERROR = 1
    SEVERITY_WARNING = 2
    SEVERITY_INFO = 3
    SEVERITY_HINT = 4

  count = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  severity = _messages.EnumField('SeverityValueValuesEnum', 2)


class GoogleCloudApihubV1Version(_messages.Message):
  r"""Represents a version of the API resource in API hub. This is also
  referred to as the API version.

  Messages:
    AttributesValue: Optional. The list of user defined attributes associated
      with the Version resource. The key is the attribute name. It will be of
      the format:
      `projects/{project}/locations/{location}/attributes/{attribute}`. The
      value is the attribute values associated with the resource.

  Fields:
    accreditation: Optional. The accreditations associated with the API
      version. This maps to the following system defined attribute:
      `projects/{project}/locations/{location}/attributes/system-
      accreditation` attribute. The number of values for this attribute will
      be based on the cardinality of the attribute. The same can be retrieved
      via GetAttribute API. All values should be from the list of allowed
      values defined for the attribute.
    apiOperations: Output only. The operations contained in the API version.
      These operations will be added to the version when a new spec is added
      or when an existing spec is updated. Format is `projects/{project}/locat
      ions/{location}/apis/{api}/versions/{version}/operations/{operation}`
    attributes: Optional. The list of user defined attributes associated with
      the Version resource. The key is the attribute name. It will be of the
      format:
      `projects/{project}/locations/{location}/attributes/{attribute}`. The
      value is the attribute values associated with the resource.
    compliance: Optional. The compliance associated with the API version. This
      maps to the following system defined attribute:
      `projects/{project}/locations/{location}/attributes/system-compliance`
      attribute. The number of values for this attribute will be based on the
      cardinality of the attribute. The same can be retrieved via GetAttribute
      API. All values should be from the list of allowed values defined for
      the attribute.
    createTime: Output only. The time at which the version was created.
    definitions: Output only. The definitions contained in the API version.
      These definitions will be added to the version when a new spec is added
      or when an existing spec is updated. Format is `projects/{project}/locat
      ions/{location}/apis/{api}/versions/{version}/definitions/{definition}`
    deployments: Optional. The deployments linked to this API version. Note: A
      particular API version could be deployed to multiple deployments (for
      dev deployment, UAT deployment, etc) Format is
      `projects/{project}/locations/{location}/deployments/{deployment}`
    description: Optional. The description of the version.
    displayName: Required. The display name of the version.
    documentation: Optional. The documentation of the version.
    lifecycle: Optional. The lifecycle of the API version. This maps to the
      following system defined attribute:
      `projects/{project}/locations/{location}/attributes/system-lifecycle`
      attribute. The number of values for this attribute will be based on the
      cardinality of the attribute. The same can be retrieved via GetAttribute
      API. All values should be from the list of allowed values defined for
      the attribute.
    name: Identifier. The name of the version. Format:
      `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
    selectedDeployment: Optional. The selected deployment for a Version
      resource. This can be used when special handling is needed on client
      side for a particular deployment linked to the version. Format is
      `projects/{project}/locations/{location}/deployments/{deployment}`
    specs: Output only. The specs associated with this version. Note that an
      API version can be associated with multiple specs. Format is `projects/{
      project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}
      `
    updateTime: Output only. The time at which the version was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AttributesValue(_messages.Message):
    r"""Optional. The list of user defined attributes associated with the
    Version resource. The key is the attribute name. It will be of the format:
    `projects/{project}/locations/{location}/attributes/{attribute}`. The
    value is the attribute values associated with the resource.

    Messages:
      AdditionalProperty: An additional property for a AttributesValue object.

    Fields:
      additionalProperties: Additional properties of type AttributesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AttributesValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudApihubV1AttributeValues attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  accreditation = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 1)
  apiOperations = _messages.StringField(2, repeated=True)
  attributes = _messages.MessageField('AttributesValue', 3)
  compliance = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 4)
  createTime = _messages.StringField(5)
  definitions = _messages.StringField(6, repeated=True)
  deployments = _messages.StringField(7, repeated=True)
  description = _messages.StringField(8)
  displayName = _messages.StringField(9)
  documentation = _messages.MessageField('GoogleCloudApihubV1Documentation', 10)
  lifecycle = _messages.MessageField('GoogleCloudApihubV1AttributeValues', 11)
  name = _messages.StringField(12)
  selectedDeployment = _messages.StringField(13)
  specs = _messages.StringField(14, repeated=True)
  updateTime = _messages.StringField(15)


class GoogleCloudCommonOperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    cancelRequested: Output only. Identifies whether the user has requested
      cancellation of the operation. Operations that have been cancelled
      successfully have Operation.error value with a google.rpc.Status.code of
      1, corresponding to `Code.CANCELLED`.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    statusDetail: Output only. Human-readable status of the operation, if any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  cancelRequested = _messages.BooleanField(2)
  createTime = _messages.StringField(3)
  endTime = _messages.StringField(4)
  statusDetail = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class GoogleCloudLocationListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('GoogleCloudLocationLocation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudLocationLocation(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class GoogleLongrunningCancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
