"""Generated message classes for policysimulator version v1beta.

 Policy Simulator is a collection of endpoints for creating, running, and
viewing a Replay. A `Replay` is a type of simulation that lets you see how
your members' access to resources might change if you changed your IAM policy.
During a `Replay`, Policy Simulator re-evaluates, or replays, past access
attempts under both the current policy and your proposed policy, and compares
those results to determine how your members' access might change under the
proposed policy.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'policysimulator'


class GoogleCloudAuditAuthorizationLoggingOptions(_messages.Message):
  r"""Authorization-related information used by Cloud Audit Logging.

  Enums:
    PermissionTypeValueValuesEnum: The type of the permission that was
      checked.

  Fields:
    permissionType: The type of the permission that was checked.
  """

  class PermissionTypeValueValuesEnum(_messages.Enum):
    r"""The type of the permission that was checked.

    Values:
      PERMISSION_TYPE_UNSPECIFIED: Default. Should not be used.
      ADMIN_READ: A read of admin (meta) data.
      ADMIN_WRITE: A write of admin (meta) data.
      DATA_READ: A read of standard data.
      DATA_WRITE: A write of standard data.
    """
    PERMISSION_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    ADMIN_WRITE = 2
    DATA_READ = 3
    DATA_WRITE = 4

  permissionType = _messages.EnumField('PermissionTypeValueValuesEnum', 1)


class GoogleCloudOrgpolicyV2AlternatePolicySpec(_messages.Message):
  r"""Similar to PolicySpec but with an extra 'launch' field for launch
  reference. The PolicySpec here is specific for dry-run/darklaunch.

  Fields:
    launch: Reference to the launch that will be used while audit logging and
      to control the launch. Should be set only in the alternate policy.
    spec: Specify constraint for configurations of Google Cloud resources.
  """

  launch = _messages.StringField(1)
  spec = _messages.MessageField('GoogleCloudOrgpolicyV2PolicySpec', 2)


class GoogleCloudOrgpolicyV2CustomConstraint(_messages.Message):
  r"""A custom constraint defined by customers which can *only* be applied to
  the given resource types and organization. By creating a custom constraint,
  customers can apply policies of this custom constraint. *Creating a custom
  constraint itself does NOT apply any policy enforcement*.

  Enums:
    ActionTypeValueValuesEnum: Allow or deny type.
    MethodTypesValueListEntryValuesEnum:

  Fields:
    actionType: Allow or deny type.
    condition: Org policy condition/expression. For example:
      `resource.instanceName.matches("[production|test]_.*_(\d)+")` or,
      `resource.management.auto_upgrade == true` The max length of the
      condition is 1000 characters.
    description: Detailed information about this custom policy constraint. The
      max length of the description is 2000 characters.
    displayName: One line display name for the UI. The max length of the
      display_name is 200 characters.
    methodTypes: All the operations being applied for this constraint.
    name: Immutable. Name of the constraint. This is unique within the
      organization. Format of the name should be * `organizations/{organizatio
      n_id}/customConstraints/{custom_constraint_id}` Example:
      `organizations/123/customConstraints/custom.createOnlyE2TypeVms` The max
      length is 70 characters and the minimum length is 1. Note that the
      prefix `organizations/{organization_id}/customConstraints/` is not
      counted.
    resourceTypes: Immutable. The resource instance type on which this policy
      applies. Format will be of the form : `/` Example: *
      `compute.googleapis.com/Instance`.
    updateTime: Output only. The last time this custom constraint was updated.
      This represents the last time that the `CreateCustomConstraint` or
      `UpdateCustomConstraint` RPC was called
  """

  class ActionTypeValueValuesEnum(_messages.Enum):
    r"""Allow or deny type.

    Values:
      ACTION_TYPE_UNSPECIFIED: Unspecified. Results in an error.
      ALLOW: Allowed action type.
      DENY: Deny action type.
    """
    ACTION_TYPE_UNSPECIFIED = 0
    ALLOW = 1
    DENY = 2

  class MethodTypesValueListEntryValuesEnum(_messages.Enum):
    r"""MethodTypesValueListEntryValuesEnum enum type.

    Values:
      METHOD_TYPE_UNSPECIFIED: Unspecified. Results in an error.
      CREATE: Constraint applied when creating the resource.
      UPDATE: Constraint applied when updating the resource.
      DELETE: Constraint applied when deleting the resource. Not supported
        yet.
    """
    METHOD_TYPE_UNSPECIFIED = 0
    CREATE = 1
    UPDATE = 2
    DELETE = 3

  actionType = _messages.EnumField('ActionTypeValueValuesEnum', 1)
  condition = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  methodTypes = _messages.EnumField('MethodTypesValueListEntryValuesEnum', 5, repeated=True)
  name = _messages.StringField(6)
  resourceTypes = _messages.StringField(7, repeated=True)
  updateTime = _messages.StringField(8)


class GoogleCloudOrgpolicyV2Policy(_messages.Message):
  r"""Defines an organization policy which is used to specify constraints for
  configurations of Google Cloud resources.

  Fields:
    alternate: Deprecated.
    dryRunSpec: Dry-run policy. Audit-only policy, can be used to monitor how
      the policy would have impacted the existing and future resources if it's
      enforced.
    etag: Optional. An opaque tag indicating the current state of the policy,
      used for concurrency control. This 'etag' is computed by the server
      based on the value of other fields, and may be sent on update and delete
      requests to ensure the client has an up-to-date value before proceeding.
    name: Immutable. The resource name of the policy. Must be one of the
      following forms, where `constraint_name` is the name of the constraint
      which this policy configures: *
      `projects/{project_number}/policies/{constraint_name}` *
      `folders/{folder_id}/policies/{constraint_name}` *
      `organizations/{organization_id}/policies/{constraint_name}` For
      example, `projects/123/policies/compute.disableSerialPortAccess`. Note:
      `projects/{project_id}/policies/{constraint_name}` is also an acceptable
      name for API requests, but responses will return the name using the
      equivalent project number.
    spec: Basic information about the Organization Policy.
  """

  alternate = _messages.MessageField('GoogleCloudOrgpolicyV2AlternatePolicySpec', 1)
  dryRunSpec = _messages.MessageField('GoogleCloudOrgpolicyV2PolicySpec', 2)
  etag = _messages.StringField(3)
  name = _messages.StringField(4)
  spec = _messages.MessageField('GoogleCloudOrgpolicyV2PolicySpec', 5)


class GoogleCloudOrgpolicyV2PolicySpec(_messages.Message):
  r"""Defines a Google Cloud policy specification which is used to specify
  constraints for configurations of Google Cloud resources.

  Fields:
    etag: An opaque tag indicating the current version of the policySpec, used
      for concurrency control. This field is ignored if used in a
      `CreatePolicy` request. When the policy is returned from either a
      `GetPolicy` or a `ListPolicies` request, this `etag` indicates the
      version of the current policySpec to use when executing a read-modify-
      write loop. When the policy is returned from a `GetEffectivePolicy`
      request, the `etag` will be unset.
    inheritFromParent: Determines the inheritance behavior for this policy. If
      `inherit_from_parent` is true, policy rules set higher up in the
      hierarchy (up to the closest root) are inherited and present in the
      effective policy. If it is false, then no rules are inherited, and this
      policy becomes the new root for evaluation. This field can be set only
      for policies which configure list constraints.
    reset: Ignores policies set above this resource and restores the
      `constraint_default` enforcement behavior of the specific constraint at
      this resource. This field can be set in policies for either list or
      boolean constraints. If set, `rules` must be empty and
      `inherit_from_parent` must be set to false.
    rules: In policies for boolean constraints, the following requirements
      apply: - There must be one and only one policy rule where condition is
      unset. - Boolean policy rules with conditions must set `enforced` to the
      opposite of the policy rule without a condition. - During policy
      evaluation, policy rules with conditions that are true for a target
      resource take precedence.
    updateTime: Output only. The time stamp this was previously updated. This
      represents the last time a call to `CreatePolicy` or `UpdatePolicy` was
      made for that policy.
  """

  etag = _messages.StringField(1)
  inheritFromParent = _messages.BooleanField(2)
  reset = _messages.BooleanField(3)
  rules = _messages.MessageField('GoogleCloudOrgpolicyV2PolicySpecPolicyRule', 4, repeated=True)
  updateTime = _messages.StringField(5)


class GoogleCloudOrgpolicyV2PolicySpecPolicyRule(_messages.Message):
  r"""A rule used to express this policy.

  Fields:
    allowAll: Setting this to true means that all values are allowed. This
      field can be set only in policies for list constraints.
    condition: A condition which determines whether this rule is used in the
      evaluation of the policy. When set, the `expression` field in the `Expr'
      must include from 1 to 10 subexpressions, joined by the "||" or "&&"
      operators. Each subexpression must be of the form
      "resource.matchTag('/tag_key_short_name, 'tag_value_short_name')". or
      "resource.matchTagId('tagKeys/key_id', 'tagValues/value_id')". where
      key_name and value_name are the resource names for Label Keys and
      Values. These names are available from the Tag Manager Service. An
      example expression is: "resource.matchTag('123456789/environment,
      'prod')". or "resource.matchTagId('tagKeys/123', 'tagValues/456')".
    denyAll: Setting this to true means that all values are denied. This field
      can be set only in policies for list constraints.
    enforce: If `true`, then the policy is enforced. If `false`, then any
      configuration is acceptable. This field can be set only in policies for
      boolean constraints.
    values: List of values to be used for this policy rule. This field can be
      set only in policies for list constraints.
  """

  allowAll = _messages.BooleanField(1)
  condition = _messages.MessageField('GoogleTypeExpr', 2)
  denyAll = _messages.BooleanField(3)
  enforce = _messages.BooleanField(4)
  values = _messages.MessageField('GoogleCloudOrgpolicyV2PolicySpecPolicyRuleStringValues', 5)


class GoogleCloudOrgpolicyV2PolicySpecPolicyRuleStringValues(_messages.Message):
  r"""A message that holds specific allowed and denied values. This message
  can define specific values and subtrees of the Resource Manager resource
  hierarchy (`Organizations`, `Folders`, `Projects`) that are allowed or
  denied. This is achieved by using the `under:` and optional `is:` prefixes.
  The `under:` prefix is used to denote resource subtree values. The `is:`
  prefix is used to denote specific values, and is required only if the value
  contains a ":". Values prefixed with "is:" are treated the same as values
  with no prefix. Ancestry subtrees must be in one of the following formats: -
  `projects/` (for example, `projects/tokyo-rain-123`) - `folders/` (for
  example, `folders/1234`) - `organizations/` (for example,
  `organizations/1234`) The `supports_under` field of the associated
  `Constraint` defines whether ancestry prefixes can be used.

  Fields:
    allowedValues: List of values allowed at this resource.
    deniedValues: List of values denied at this resource.
  """

  allowedValues = _messages.StringField(1, repeated=True)
  deniedValues = _messages.StringField(2, repeated=True)


class GoogleCloudPolicysimulatorV1Replay(_messages.Message):
  r"""A resource describing a `Replay`, or simulation.

  Enums:
    StateValueValuesEnum: Output only. The current state of the `Replay`.

  Fields:
    config: Required. The configuration used for the `Replay`.
    name: Output only. The resource name of the `Replay`, which has the
      following format: `{projects|folders|organizations}/{resource-
      id}/locations/global/replays/{replay-id}`, where `{resource-id}` is the
      ID of the project, folder, or organization that owns the Replay.
      Example: `projects/my-example-
      project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
    resultsSummary: Output only. Summary statistics about the replayed log
      entries.
    state: Output only. The current state of the `Replay`.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the `Replay`.

    Values:
      STATE_UNSPECIFIED: Default value. This value is unused.
      PENDING: The `Replay` has not started yet.
      RUNNING: The `Replay` is currently running.
      SUCCEEDED: The `Replay` has successfully completed.
      FAILED: The `Replay` has finished with an error.
    """
    STATE_UNSPECIFIED = 0
    PENDING = 1
    RUNNING = 2
    SUCCEEDED = 3
    FAILED = 4

  config = _messages.MessageField('GoogleCloudPolicysimulatorV1ReplayConfig', 1)
  name = _messages.StringField(2)
  resultsSummary = _messages.MessageField('GoogleCloudPolicysimulatorV1ReplayResultsSummary', 3)
  state = _messages.EnumField('StateValueValuesEnum', 4)


class GoogleCloudPolicysimulatorV1ReplayConfig(_messages.Message):
  r"""The configuration used for a Replay.

  Enums:
    LogSourceValueValuesEnum: The logs to use as input for the Replay.

  Messages:
    PolicyOverlayValue: A mapping of the resources that you want to simulate
      policies for and the policies that you want to simulate. Keys are the
      full resource names for the resources. For example,
      `//cloudresourcemanager.googleapis.com/projects/my-project`. For
      examples of full resource names for Google Cloud services, see
      https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
      Values are Policy objects representing the policies that you want to
      simulate. Replays automatically take into account any IAM policies
      inherited through the resource hierarchy, and any policies set on
      descendant resources. You do not need to include these policies in the
      policy overlay.

  Fields:
    logSource: The logs to use as input for the Replay.
    policyOverlay: A mapping of the resources that you want to simulate
      policies for and the policies that you want to simulate. Keys are the
      full resource names for the resources. For example,
      `//cloudresourcemanager.googleapis.com/projects/my-project`. For
      examples of full resource names for Google Cloud services, see
      https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
      Values are Policy objects representing the policies that you want to
      simulate. Replays automatically take into account any IAM policies
      inherited through the resource hierarchy, and any policies set on
      descendant resources. You do not need to include these policies in the
      policy overlay.
  """

  class LogSourceValueValuesEnum(_messages.Enum):
    r"""The logs to use as input for the Replay.

    Values:
      LOG_SOURCE_UNSPECIFIED: An unspecified log source. If the log source is
        unspecified, the Replay defaults to using `RECENT_ACCESSES`.
      RECENT_ACCESSES: All access logs from the last 90 days. These logs may
        not include logs from the most recent 7 days.
    """
    LOG_SOURCE_UNSPECIFIED = 0
    RECENT_ACCESSES = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PolicyOverlayValue(_messages.Message):
    r"""A mapping of the resources that you want to simulate policies for and
    the policies that you want to simulate. Keys are the full resource names
    for the resources. For example,
    `//cloudresourcemanager.googleapis.com/projects/my-project`. For examples
    of full resource names for Google Cloud services, see
    https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
    Values are Policy objects representing the policies that you want to
    simulate. Replays automatically take into account any IAM policies
    inherited through the resource hierarchy, and any policies set on
    descendant resources. You do not need to include these policies in the
    policy overlay.

    Messages:
      AdditionalProperty: An additional property for a PolicyOverlayValue
        object.

    Fields:
      additionalProperties: Additional properties of type PolicyOverlayValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PolicyOverlayValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleIamV1Policy attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleIamV1Policy', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  logSource = _messages.EnumField('LogSourceValueValuesEnum', 1)
  policyOverlay = _messages.MessageField('PolicyOverlayValue', 2)


class GoogleCloudPolicysimulatorV1ReplayOperationMetadata(_messages.Message):
  r"""Metadata about a Replay operation.

  Fields:
    startTime: Time when the request was received.
  """

  startTime = _messages.StringField(1)


class GoogleCloudPolicysimulatorV1ReplayResultsSummary(_messages.Message):
  r"""Summary statistics about the replayed log entries.

  Fields:
    differenceCount: The number of replayed log entries with a difference
      between baseline and simulated policies.
    errorCount: The number of log entries that could not be replayed.
    logCount: The total number of log entries replayed.
    newestDate: The date of the newest log entry replayed.
    oldestDate: The date of the oldest log entry replayed.
    unchangedCount: The number of replayed log entries with no difference
      between baseline and simulated policies.
  """

  differenceCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  errorCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  logCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  newestDate = _messages.MessageField('GoogleTypeDate', 4)
  oldestDate = _messages.MessageField('GoogleTypeDate', 5)
  unchangedCount = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class GoogleCloudPolicysimulatorV1alphaCreateOrgPolicyViolationsPreviewOperationMetadata(_messages.Message):
  r"""CreateOrgPolicyViolationsPreviewOperationMetadata is metadata about an
  OrgPolicyViolationsPreview generations operation.

  Enums:
    StateValueValuesEnum: Output only. The current state of the operation.

  Fields:
    requestTime: Time when the request was received.
    resourcesFound: Total number of resources that need scanning. Should equal
      resource_scanned + resources_pending
    resourcesPending: Number of resources still to scan.
    resourcesScanned: Number of resources already scanned.
    startTime: Time when the request started processing, i.e., when the state
      was set to RUNNING.
    state: Output only. The current state of the operation.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the operation.

    Values:
      PREVIEW_STATE_UNSPECIFIED: The state is unspecified.
      PREVIEW_PENDING: The OrgPolicyViolationsPreview has not been created
        yet.
      PREVIEW_RUNNING: The OrgPolicyViolationsPreview is currently being
        created.
      PREVIEW_SUCCEEDED: The OrgPolicyViolationsPreview creation finished
        successfully.
      PREVIEW_FAILED: The OrgPolicyViolationsPreview creation failed with an
        error.
    """
    PREVIEW_STATE_UNSPECIFIED = 0
    PREVIEW_PENDING = 1
    PREVIEW_RUNNING = 2
    PREVIEW_SUCCEEDED = 3
    PREVIEW_FAILED = 4

  requestTime = _messages.StringField(1)
  resourcesFound = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  resourcesPending = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  resourcesScanned = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)


class GoogleCloudPolicysimulatorV1alphaGenerateOrgPolicyViolationsPreviewOperationMetadata(_messages.Message):
  r"""GenerateOrgPolicyViolationsPreviewOperationMetadata is metadata about an
  OrgPolicyViolationsPreview generations operation.

  Enums:
    StateValueValuesEnum: The current state of the operation.

  Fields:
    requestTime: Time when the request was received.
    resourcesFound: Total number of resources that need scanning. Should equal
      resource_scanned + resources_pending
    resourcesPending: Number of resources still to scan.
    resourcesScanned: Number of resources already scanned.
    startTime: Time when the request started processing, i.e. when the state
      was set to RUNNING.
    state: The current state of the operation.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the operation.

    Values:
      PREVIEW_STATE_UNSPECIFIED: The state is unspecified.
      PREVIEW_PENDING: The OrgPolicyViolationsPreview has not been created
        yet.
      PREVIEW_RUNNING: The OrgPolicyViolationsPreview is currently being
        created.
      PREVIEW_SUCCEEDED: The OrgPolicyViolationsPreview creation finished
        successfully.
      PREVIEW_FAILED: The OrgPolicyViolationsPreview creation failed with an
        error.
    """
    PREVIEW_STATE_UNSPECIFIED = 0
    PREVIEW_PENDING = 1
    PREVIEW_RUNNING = 2
    PREVIEW_SUCCEEDED = 3
    PREVIEW_FAILED = 4

  requestTime = _messages.StringField(1)
  resourcesFound = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  resourcesPending = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  resourcesScanned = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)


class GoogleCloudPolicysimulatorV1alphaOrgPolicyOverlay(_messages.Message):
  r"""The proposed changes to OrgPolicy.

  Fields:
    customConstraints: Optional. The OrgPolicy CustomConstraint changes to
      preview violations for. Any existing CustomConstraints with the same
      name will be overridden in the simulation. That is, violations will be
      determined as if all custom constraints in the overlay were
      instantiated. Only a single custom_constraint is supported in the
      overlay at a time. For evaluating multiple constraints, multiple
      `GenerateOrgPolicyViolationsPreview` requests are made, where each
      request evaluates a single constraint.
    policies: Optional. The OrgPolicy changes to preview violations for. Any
      existing OrgPolicies with the same name will be overridden in the
      simulation. That is, violations will be determined as if all policies in
      the overlay were created or updated.
  """

  customConstraints = _messages.MessageField('GoogleCloudPolicysimulatorV1alphaOrgPolicyOverlayCustomConstraintOverlay', 1, repeated=True)
  policies = _messages.MessageField('GoogleCloudPolicysimulatorV1alphaOrgPolicyOverlayPolicyOverlay', 2, repeated=True)


class GoogleCloudPolicysimulatorV1alphaOrgPolicyOverlayCustomConstraintOverlay(_messages.Message):
  r"""A change to an OrgPolicy custom constraint.

  Fields:
    customConstraint: Optional. The new or updated custom constraint.
    customConstraintParent: Optional. Resource the constraint is attached to.
      Example: "organization/987654"
  """

  customConstraint = _messages.MessageField('GoogleCloudOrgpolicyV2CustomConstraint', 1)
  customConstraintParent = _messages.StringField(2)


class GoogleCloudPolicysimulatorV1alphaOrgPolicyOverlayPolicyOverlay(_messages.Message):
  r"""A change to an OrgPolicy.

  Fields:
    policy: Optional. The new or updated OrgPolicy.
    policyParent: Optional. The parent of the policy we are attaching to.
      Example: "projects/123456"
  """

  policy = _messages.MessageField('GoogleCloudOrgpolicyV2Policy', 1)
  policyParent = _messages.StringField(2)


class GoogleCloudPolicysimulatorV1alphaOrgPolicyViolationsPreview(_messages.Message):
  r"""OrgPolicyViolationsPreview is a resource providing a preview of the
  violations that will exist if an OrgPolicy change is made. The list of
  violations are modeled as child resources and retrieved via a
  ListOrgPolicyViolations API call. There are potentially more
  OrgPolicyViolations than could fit in an embedded field. Thus, the use of a
  child resource instead of a field.

  Enums:
    StateValueValuesEnum: Output only. The state of the
      `OrgPolicyViolationsPreview`.

  Fields:
    createTime: Output only. Time when this `OrgPolicyViolationsPreview` was
      created.
    customConstraints: Output only. The names of the constraints against which
      all `OrgPolicyViolations` were evaluated. If `OrgPolicyOverlay` only
      contains `PolicyOverlay` then it contains the name of the configured
      custom constraint, applicable to the specified policies. Otherwise it
      contains the name of the constraint specified in
      `CustomConstraintOverlay`. Format: `organizations/{organization_id}/cust
      omConstraints/{custom_constraint_id}` Example:
      `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
    name: Output only. The resource name of the `OrgPolicyViolationsPreview`.
      It has the following format: `organizations/{organization}/locations/{lo
      cation}/orgPolicyViolationsPreviews/{orgPolicyViolationsPreview}`
      Example: `organizations/my-example-
      org/locations/global/orgPolicyViolationsPreviews/506a5f7f`
    overlay: Required. The proposed changes we are previewing violations for.
    resourceCounts: Output only. A summary of the state of all resources
      scanned for compliance with the changed OrgPolicy.
    state: Output only. The state of the `OrgPolicyViolationsPreview`.
    violationsCount: Output only. The number of OrgPolicyViolations in this
      `OrgPolicyViolationsPreview`. This count may differ from
      `resource_summary.noncompliant_count` because each OrgPolicyViolation is
      specific to a resource **and** constraint. If there are multiple
      constraints being evaluated (i.e. multiple policies in the overlay), a
      single resource may violate multiple constraints.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the `OrgPolicyViolationsPreview`.

    Values:
      PREVIEW_STATE_UNSPECIFIED: The state is unspecified.
      PREVIEW_PENDING: The OrgPolicyViolationsPreview has not been created
        yet.
      PREVIEW_RUNNING: The OrgPolicyViolationsPreview is currently being
        created.
      PREVIEW_SUCCEEDED: The OrgPolicyViolationsPreview creation finished
        successfully.
      PREVIEW_FAILED: The OrgPolicyViolationsPreview creation failed with an
        error.
    """
    PREVIEW_STATE_UNSPECIFIED = 0
    PREVIEW_PENDING = 1
    PREVIEW_RUNNING = 2
    PREVIEW_SUCCEEDED = 3
    PREVIEW_FAILED = 4

  createTime = _messages.StringField(1)
  customConstraints = _messages.StringField(2, repeated=True)
  name = _messages.StringField(3)
  overlay = _messages.MessageField('GoogleCloudPolicysimulatorV1alphaOrgPolicyOverlay', 4)
  resourceCounts = _messages.MessageField('GoogleCloudPolicysimulatorV1alphaOrgPolicyViolationsPreviewResourceCounts', 5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  violationsCount = _messages.IntegerField(7, variant=_messages.Variant.INT32)


class GoogleCloudPolicysimulatorV1alphaOrgPolicyViolationsPreviewResourceCounts(_messages.Message):
  r"""A summary of the state of all resources scanned for compliance with the
  changed OrgPolicy.

  Fields:
    compliant: Output only. Number of scanned resources with zero violations.
    errors: Output only. Number of resources that returned an error when
      scanned.
    noncompliant: Output only. Number of scanned resources with at least one
      violation.
    scanned: Output only. Number of resources checked for compliance. Must
      equal: unenforced + noncompliant + compliant + error
    unenforced: Output only. Number of resources where the constraint was not
      enforced, i.e. the Policy set `enforced: false` for that resource.
  """

  compliant = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  errors = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  noncompliant = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  scanned = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  unenforced = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class GoogleCloudPolicysimulatorV1betaAccessStateDiff(_messages.Message):
  r"""A summary and comparison of the principal's access under the current
  (baseline) policies and the proposed (simulated) policies for a single
  access tuple.

  Enums:
    AccessChangeValueValuesEnum: How the principal's access, specified in the
      AccessState field, changed between the current (baseline) policies and
      proposed (simulated) policies.

  Fields:
    accessChange: How the principal's access, specified in the AccessState
      field, changed between the current (baseline) policies and proposed
      (simulated) policies.
    baseline: The results of evaluating the access tuple under the current
      (baseline) policies. If the AccessState couldn't be fully evaluated,
      this field explains why.
    simulated: The results of evaluating the access tuple under the proposed
      (simulated) policies. If the AccessState couldn't be fully evaluated,
      this field explains why.
  """

  class AccessChangeValueValuesEnum(_messages.Enum):
    r"""How the principal's access, specified in the AccessState field,
    changed between the current (baseline) policies and proposed (simulated)
    policies.

    Values:
      ACCESS_CHANGE_TYPE_UNSPECIFIED: Default value. This value is unused.
      NO_CHANGE: The principal's access did not change. This includes the case
        where both baseline and simulated are UNKNOWN, but the unknown
        information is equivalent.
      UNKNOWN_CHANGE: The principal's access under both the current policies
        and the proposed policies is `UNKNOWN`, but the unknown information
        differs between them.
      ACCESS_REVOKED: The principal had access under the current policies
        (`GRANTED`), but will no longer have access after the proposed changes
        (`NOT_GRANTED`).
      ACCESS_GAINED: The principal did not have access under the current
        policies (`NOT_GRANTED`), but will have access after the proposed
        changes (`GRANTED`).
      ACCESS_MAYBE_REVOKED: This result can occur for the following reasons: *
        The principal had access under the current policies (`GRANTED`), but
        their access after the proposed changes is `UNKNOWN`. * The
        principal's access under the current policies is `UNKNOWN`, but they
        will not have access after the proposed changes (`NOT_GRANTED`).
      ACCESS_MAYBE_GAINED: This result can occur for the following reasons: *
        The principal did not have access under the current policies
        (`NOT_GRANTED`), but their access after the proposed changes is
        `UNKNOWN`. * The principal's access under the current policies is
        `UNKNOWN`, but they will have access after the proposed changes
        (`GRANTED`).
    """
    ACCESS_CHANGE_TYPE_UNSPECIFIED = 0
    NO_CHANGE = 1
    UNKNOWN_CHANGE = 2
    ACCESS_REVOKED = 3
    ACCESS_GAINED = 4
    ACCESS_MAYBE_REVOKED = 5
    ACCESS_MAYBE_GAINED = 6

  accessChange = _messages.EnumField('AccessChangeValueValuesEnum', 1)
  baseline = _messages.MessageField('GoogleCloudPolicysimulatorV1betaExplainedAccess', 2)
  simulated = _messages.MessageField('GoogleCloudPolicysimulatorV1betaExplainedAccess', 3)


class GoogleCloudPolicysimulatorV1betaAccessTuple(_messages.Message):
  r"""Information about the principal, resource, and permission to check.

  Fields:
    fullResourceName: Required. The full resource name that identifies the
      resource. For example, `//compute.googleapis.com/projects/my-
      project/zones/us-central1-a/instances/my-instance`. For examples of full
      resource names for Google Cloud services, see
      https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
    permission: Required. The IAM permission to check for the specified
      principal and resource. For a complete list of IAM permissions, see
      https://cloud.google.com/iam/help/permissions/reference. For a complete
      list of predefined IAM roles and the permissions in each role, see
      https://cloud.google.com/iam/help/roles/reference.
    principal: Required. The principal whose access you want to check, in the
      form of the email address that represents that principal. For example,
      `alice@example.com` or `my-service-account@my-
      project.iam.gserviceaccount.com`. The principal must be a Google Account
      or a service account. Other types of principals are not supported.
  """

  fullResourceName = _messages.StringField(1)
  permission = _messages.StringField(2)
  principal = _messages.StringField(3)


class GoogleCloudPolicysimulatorV1betaBindingExplanation(_messages.Message):
  r"""Details about how a binding in a policy affects a principal's ability to
  use a permission.

  Enums:
    AccessValueValuesEnum: Required. Indicates whether _this binding_ provides
      the specified permission to the specified principal for the specified
      resource. This field does _not_ indicate whether the principal actually
      has the permission for the resource. There might be another binding that
      overrides this binding. To determine whether the principal actually has
      the permission, use the `access` field in the
      TroubleshootIamPolicyResponse.
    RelevanceValueValuesEnum: The relevance of this binding to the overall
      determination for the entire policy.
    RolePermissionValueValuesEnum: Indicates whether the role granted by this
      binding contains the specified permission.
    RolePermissionRelevanceValueValuesEnum: The relevance of the permission's
      existence, or nonexistence, in the role to the overall determination for
      the entire policy.

  Messages:
    MembershipsValue: Indicates whether each principal in the binding includes
      the principal specified in the request, either directly or indirectly.
      Each key identifies a principal in the binding, and each value indicates
      whether the principal in the binding includes the principal in the
      request. For example, suppose that a binding includes the following
      principals: * `user:alice@example.com` * `group:product-eng@example.com`
      The principal in the replayed access tuple is `user:bob@example.com`.
      This user is a principal of the group `group:product-eng@example.com`.
      For the first principal in the binding, the key is
      `user:alice@example.com`, and the `membership` field in the value is set
      to `MEMBERSHIP_NOT_INCLUDED`. For the second principal in the binding,
      the key is `group:product-eng@example.com`, and the `membership` field
      in the value is set to `MEMBERSHIP_INCLUDED`.

  Fields:
    access: Required. Indicates whether _this binding_ provides the specified
      permission to the specified principal for the specified resource. This
      field does _not_ indicate whether the principal actually has the
      permission for the resource. There might be another binding that
      overrides this binding. To determine whether the principal actually has
      the permission, use the `access` field in the
      TroubleshootIamPolicyResponse.
    condition: A condition expression that prevents this binding from granting
      access unless the expression evaluates to `true`. To learn about IAM
      Conditions, see https://cloud.google.com/iam/docs/conditions-overview.
    memberships: Indicates whether each principal in the binding includes the
      principal specified in the request, either directly or indirectly. Each
      key identifies a principal in the binding, and each value indicates
      whether the principal in the binding includes the principal in the
      request. For example, suppose that a binding includes the following
      principals: * `user:alice@example.com` * `group:product-eng@example.com`
      The principal in the replayed access tuple is `user:bob@example.com`.
      This user is a principal of the group `group:product-eng@example.com`.
      For the first principal in the binding, the key is
      `user:alice@example.com`, and the `membership` field in the value is set
      to `MEMBERSHIP_NOT_INCLUDED`. For the second principal in the binding,
      the key is `group:product-eng@example.com`, and the `membership` field
      in the value is set to `MEMBERSHIP_INCLUDED`.
    relevance: The relevance of this binding to the overall determination for
      the entire policy.
    role: The role that this binding grants. For example,
      `roles/compute.serviceAgent`. For a complete list of predefined IAM
      roles, as well as the permissions in each role, see
      https://cloud.google.com/iam/help/roles/reference.
    rolePermission: Indicates whether the role granted by this binding
      contains the specified permission.
    rolePermissionRelevance: The relevance of the permission's existence, or
      nonexistence, in the role to the overall determination for the entire
      policy.
  """

  class AccessValueValuesEnum(_messages.Enum):
    r"""Required. Indicates whether _this binding_ provides the specified
    permission to the specified principal for the specified resource. This
    field does _not_ indicate whether the principal actually has the
    permission for the resource. There might be another binding that overrides
    this binding. To determine whether the principal actually has the
    permission, use the `access` field in the TroubleshootIamPolicyResponse.

    Values:
      ACCESS_STATE_UNSPECIFIED: Default value. This value is unused.
      GRANTED: The principal has the permission.
      NOT_GRANTED: The principal does not have the permission.
      UNKNOWN_CONDITIONAL: The principal has the permission only if a
        condition expression evaluates to `true`.
      UNKNOWN_INFO_DENIED: The user who created the Replay does not have
        access to all of the policies that Policy Simulator needs to evaluate.
    """
    ACCESS_STATE_UNSPECIFIED = 0
    GRANTED = 1
    NOT_GRANTED = 2
    UNKNOWN_CONDITIONAL = 3
    UNKNOWN_INFO_DENIED = 4

  class RelevanceValueValuesEnum(_messages.Enum):
    r"""The relevance of this binding to the overall determination for the
    entire policy.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Default value. This value is unused.
      NORMAL: The data point has a limited effect on the result. Changing the
        data point is unlikely to affect the overall determination.
      HIGH: The data point has a strong effect on the result. Changing the
        data point is likely to affect the overall determination.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    NORMAL = 1
    HIGH = 2

  class RolePermissionRelevanceValueValuesEnum(_messages.Enum):
    r"""The relevance of the permission's existence, or nonexistence, in the
    role to the overall determination for the entire policy.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Default value. This value is unused.
      NORMAL: The data point has a limited effect on the result. Changing the
        data point is unlikely to affect the overall determination.
      HIGH: The data point has a strong effect on the result. Changing the
        data point is likely to affect the overall determination.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    NORMAL = 1
    HIGH = 2

  class RolePermissionValueValuesEnum(_messages.Enum):
    r"""Indicates whether the role granted by this binding contains the
    specified permission.

    Values:
      ROLE_PERMISSION_UNSPECIFIED: Default value. This value is unused.
      ROLE_PERMISSION_INCLUDED: The permission is included in the role.
      ROLE_PERMISSION_NOT_INCLUDED: The permission is not included in the
        role.
      ROLE_PERMISSION_UNKNOWN_INFO_DENIED: The user who created the Replay is
        not allowed to access the binding.
    """
    ROLE_PERMISSION_UNSPECIFIED = 0
    ROLE_PERMISSION_INCLUDED = 1
    ROLE_PERMISSION_NOT_INCLUDED = 2
    ROLE_PERMISSION_UNKNOWN_INFO_DENIED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MembershipsValue(_messages.Message):
    r"""Indicates whether each principal in the binding includes the principal
    specified in the request, either directly or indirectly. Each key
    identifies a principal in the binding, and each value indicates whether
    the principal in the binding includes the principal in the request. For
    example, suppose that a binding includes the following principals: *
    `user:alice@example.com` * `group:product-eng@example.com` The principal
    in the replayed access tuple is `user:bob@example.com`. This user is a
    principal of the group `group:product-eng@example.com`. For the first
    principal in the binding, the key is `user:alice@example.com`, and the
    `membership` field in the value is set to `MEMBERSHIP_NOT_INCLUDED`. For
    the second principal in the binding, the key is `group:product-
    eng@example.com`, and the `membership` field in the value is set to
    `MEMBERSHIP_INCLUDED`.

    Messages:
      AdditionalProperty: An additional property for a MembershipsValue
        object.

    Fields:
      additionalProperties: Additional properties of type MembershipsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MembershipsValue object.

      Fields:
        key: Name of the additional property.
        value: A
          GoogleCloudPolicysimulatorV1betaBindingExplanationAnnotatedMembershi
          p attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudPolicysimulatorV1betaBindingExplanationAnnotatedMembership', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  access = _messages.EnumField('AccessValueValuesEnum', 1)
  condition = _messages.MessageField('GoogleTypeExpr', 2)
  memberships = _messages.MessageField('MembershipsValue', 3)
  relevance = _messages.EnumField('RelevanceValueValuesEnum', 4)
  role = _messages.StringField(5)
  rolePermission = _messages.EnumField('RolePermissionValueValuesEnum', 6)
  rolePermissionRelevance = _messages.EnumField('RolePermissionRelevanceValueValuesEnum', 7)


class GoogleCloudPolicysimulatorV1betaBindingExplanationAnnotatedMembership(_messages.Message):
  r"""Details about whether the binding includes the principal.

  Enums:
    MembershipValueValuesEnum: Indicates whether the binding includes the
      principal.
    RelevanceValueValuesEnum: The relevance of the principal's status to the
      overall determination for the binding.

  Fields:
    membership: Indicates whether the binding includes the principal.
    relevance: The relevance of the principal's status to the overall
      determination for the binding.
  """

  class MembershipValueValuesEnum(_messages.Enum):
    r"""Indicates whether the binding includes the principal.

    Values:
      MEMBERSHIP_UNSPECIFIED: Default value. This value is unused.
      MEMBERSHIP_INCLUDED: The binding includes the principal. The principal
        can be included directly or indirectly. For example: * A principal is
        included directly if that principal is listed in the binding. * A
        principal is included indirectly if that principal is in a Google
        group or Google Workspace domain that is listed in the binding.
      MEMBERSHIP_NOT_INCLUDED: The binding does not include the principal.
      MEMBERSHIP_UNKNOWN_INFO_DENIED: The user who created the Replay is not
        allowed to access the binding.
      MEMBERSHIP_UNKNOWN_UNSUPPORTED: The principal is an unsupported type.
        Only Google Accounts and service accounts are supported.
    """
    MEMBERSHIP_UNSPECIFIED = 0
    MEMBERSHIP_INCLUDED = 1
    MEMBERSHIP_NOT_INCLUDED = 2
    MEMBERSHIP_UNKNOWN_INFO_DENIED = 3
    MEMBERSHIP_UNKNOWN_UNSUPPORTED = 4

  class RelevanceValueValuesEnum(_messages.Enum):
    r"""The relevance of the principal's status to the overall determination
    for the binding.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Default value. This value is unused.
      NORMAL: The data point has a limited effect on the result. Changing the
        data point is unlikely to affect the overall determination.
      HIGH: The data point has a strong effect on the result. Changing the
        data point is likely to affect the overall determination.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    NORMAL = 1
    HIGH = 2

  membership = _messages.EnumField('MembershipValueValuesEnum', 1)
  relevance = _messages.EnumField('RelevanceValueValuesEnum', 2)


class GoogleCloudPolicysimulatorV1betaCreateOrgPolicyViolationsPreviewOperationMetadata(_messages.Message):
  r"""CreateOrgPolicyViolationsPreviewOperationMetadata is metadata about an
  OrgPolicyViolationsPreview generations operation.

  Enums:
    StateValueValuesEnum: Output only. The current state of the operation.

  Fields:
    requestTime: Time when the request was received.
    resourcesFound: Total number of resources that need scanning. Should equal
      resource_scanned + resources_pending
    resourcesPending: Number of resources still to scan.
    resourcesScanned: Number of resources already scanned.
    startTime: Time when the request started processing, i.e., when the state
      was set to RUNNING.
    state: Output only. The current state of the operation.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the operation.

    Values:
      PREVIEW_STATE_UNSPECIFIED: The state is unspecified.
      PREVIEW_PENDING: The OrgPolicyViolationsPreview has not been created
        yet.
      PREVIEW_RUNNING: The OrgPolicyViolationsPreview is currently being
        created.
      PREVIEW_SUCCEEDED: The OrgPolicyViolationsPreview creation finished
        successfully.
      PREVIEW_FAILED: The OrgPolicyViolationsPreview creation failed with an
        error.
    """
    PREVIEW_STATE_UNSPECIFIED = 0
    PREVIEW_PENDING = 1
    PREVIEW_RUNNING = 2
    PREVIEW_SUCCEEDED = 3
    PREVIEW_FAILED = 4

  requestTime = _messages.StringField(1)
  resourcesFound = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  resourcesPending = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  resourcesScanned = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)


class GoogleCloudPolicysimulatorV1betaExplainedAccess(_messages.Message):
  r"""Details about how a set of policies, listed in ExplainedPolicy, resulted
  in a certain AccessState when replaying an access tuple.

  Enums:
    AccessStateValueValuesEnum: Whether the principal in the access tuple has
      permission to access the resource in the access tuple under the given
      policies.

  Fields:
    accessState: Whether the principal in the access tuple has permission to
      access the resource in the access tuple under the given policies.
    errors: If the AccessState is `UNKNOWN`, this field contains a list of
      errors explaining why the result is `UNKNOWN`. If the `AccessState` is
      `GRANTED` or `NOT_GRANTED`, this field is omitted.
    policies: If the AccessState is `UNKNOWN`, this field contains the
      policies that led to that result. If the `AccessState` is `GRANTED` or
      `NOT_GRANTED`, this field is omitted.
  """

  class AccessStateValueValuesEnum(_messages.Enum):
    r"""Whether the principal in the access tuple has permission to access the
    resource in the access tuple under the given policies.

    Values:
      ACCESS_STATE_UNSPECIFIED: Default value. This value is unused.
      GRANTED: The principal has the permission.
      NOT_GRANTED: The principal does not have the permission.
      UNKNOWN_CONDITIONAL: The principal has the permission only if a
        condition expression evaluates to `true`.
      UNKNOWN_INFO_DENIED: The user who created the Replay does not have
        access to all of the policies that Policy Simulator needs to evaluate.
    """
    ACCESS_STATE_UNSPECIFIED = 0
    GRANTED = 1
    NOT_GRANTED = 2
    UNKNOWN_CONDITIONAL = 3
    UNKNOWN_INFO_DENIED = 4

  accessState = _messages.EnumField('AccessStateValueValuesEnum', 1)
  errors = _messages.MessageField('GoogleRpcStatus', 2, repeated=True)
  policies = _messages.MessageField('GoogleCloudPolicysimulatorV1betaExplainedPolicy', 3, repeated=True)


class GoogleCloudPolicysimulatorV1betaExplainedPolicy(_messages.Message):
  r"""Details about how a specific IAM Policy contributed to the access check.

  Enums:
    AccessValueValuesEnum: Indicates whether _this policy_ provides the
      specified permission to the specified principal for the specified
      resource. This field does _not_ indicate whether the principal actually
      has the permission for the resource. There might be another policy that
      overrides this policy. To determine whether the principal actually has
      the permission, use the `access` field in the
      TroubleshootIamPolicyResponse.
    RelevanceValueValuesEnum: The relevance of this policy to the overall
      determination in the TroubleshootIamPolicyResponse. If the user who
      created the Replay does not have access to the policy, this field is
      omitted.

  Fields:
    access: Indicates whether _this policy_ provides the specified permission
      to the specified principal for the specified resource. This field does
      _not_ indicate whether the principal actually has the permission for the
      resource. There might be another policy that overrides this policy. To
      determine whether the principal actually has the permission, use the
      `access` field in the TroubleshootIamPolicyResponse.
    bindingExplanations: Details about how each binding in the policy affects
      the principal's ability, or inability, to use the permission for the
      resource. If the user who created the Replay does not have access to the
      policy, this field is omitted.
    fullResourceName: The full resource name that identifies the resource. For
      example, `//compute.googleapis.com/projects/my-project/zones/us-
      central1-a/instances/my-instance`. If the user who created the Replay
      does not have access to the policy, this field is omitted. For examples
      of full resource names for Google Cloud services, see
      https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
    policy: The IAM policy attached to the resource. If the user who created
      the Replay does not have access to the policy, this field is empty.
    relevance: The relevance of this policy to the overall determination in
      the TroubleshootIamPolicyResponse. If the user who created the Replay
      does not have access to the policy, this field is omitted.
  """

  class AccessValueValuesEnum(_messages.Enum):
    r"""Indicates whether _this policy_ provides the specified permission to
    the specified principal for the specified resource. This field does _not_
    indicate whether the principal actually has the permission for the
    resource. There might be another policy that overrides this policy. To
    determine whether the principal actually has the permission, use the
    `access` field in the TroubleshootIamPolicyResponse.

    Values:
      ACCESS_STATE_UNSPECIFIED: Default value. This value is unused.
      GRANTED: The principal has the permission.
      NOT_GRANTED: The principal does not have the permission.
      UNKNOWN_CONDITIONAL: The principal has the permission only if a
        condition expression evaluates to `true`.
      UNKNOWN_INFO_DENIED: The user who created the Replay does not have
        access to all of the policies that Policy Simulator needs to evaluate.
    """
    ACCESS_STATE_UNSPECIFIED = 0
    GRANTED = 1
    NOT_GRANTED = 2
    UNKNOWN_CONDITIONAL = 3
    UNKNOWN_INFO_DENIED = 4

  class RelevanceValueValuesEnum(_messages.Enum):
    r"""The relevance of this policy to the overall determination in the
    TroubleshootIamPolicyResponse. If the user who created the Replay does not
    have access to the policy, this field is omitted.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Default value. This value is unused.
      NORMAL: The data point has a limited effect on the result. Changing the
        data point is unlikely to affect the overall determination.
      HIGH: The data point has a strong effect on the result. Changing the
        data point is likely to affect the overall determination.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    NORMAL = 1
    HIGH = 2

  access = _messages.EnumField('AccessValueValuesEnum', 1)
  bindingExplanations = _messages.MessageField('GoogleCloudPolicysimulatorV1betaBindingExplanation', 2, repeated=True)
  fullResourceName = _messages.StringField(3)
  policy = _messages.MessageField('GoogleIamV1Policy', 4)
  relevance = _messages.EnumField('RelevanceValueValuesEnum', 5)


class GoogleCloudPolicysimulatorV1betaGenerateOrgPolicyViolationsPreviewOperationMetadata(_messages.Message):
  r"""GenerateOrgPolicyViolationsPreviewOperationMetadata is metadata about an
  OrgPolicyViolationsPreview generations operation.

  Enums:
    StateValueValuesEnum: The current state of the operation.

  Fields:
    requestTime: Time when the request was received.
    resourcesFound: Total number of resources that need scanning. Should equal
      resource_scanned + resources_pending
    resourcesPending: Number of resources still to scan.
    resourcesScanned: Number of resources already scanned.
    startTime: Time when the request started processing, i.e. when the state
      was set to RUNNING.
    state: The current state of the operation.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the operation.

    Values:
      PREVIEW_STATE_UNSPECIFIED: The state is unspecified.
      PREVIEW_PENDING: The OrgPolicyViolationsPreview has not been created
        yet.
      PREVIEW_RUNNING: The OrgPolicyViolationsPreview is currently being
        created.
      PREVIEW_SUCCEEDED: The OrgPolicyViolationsPreview creation finished
        successfully.
      PREVIEW_FAILED: The OrgPolicyViolationsPreview creation failed with an
        error.
    """
    PREVIEW_STATE_UNSPECIFIED = 0
    PREVIEW_PENDING = 1
    PREVIEW_RUNNING = 2
    PREVIEW_SUCCEEDED = 3
    PREVIEW_FAILED = 4

  requestTime = _messages.StringField(1)
  resourcesFound = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  resourcesPending = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  resourcesScanned = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)


class GoogleCloudPolicysimulatorV1betaListOrgPolicyViolationsPreviewsResponse(_messages.Message):
  r"""ListOrgPolicyViolationsPreviewsResponse is the response message for
  OrgPolicyViolationsPreviewService.ListOrgPolicyViolationsPreviews.

  Fields:
    nextPageToken: A token that you can use to retrieve the next page of
      results. If this field is omitted, there are no subsequent pages.
    orgPolicyViolationsPreviews: The list of OrgPolicyViolationsPreview
  """

  nextPageToken = _messages.StringField(1)
  orgPolicyViolationsPreviews = _messages.MessageField('GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview', 2, repeated=True)


class GoogleCloudPolicysimulatorV1betaListOrgPolicyViolationsResponse(_messages.Message):
  r"""ListOrgPolicyViolationsResponse is the response message for
  OrgPolicyViolationsPreviewService.ListOrgPolicyViolations

  Fields:
    nextPageToken: A token that you can use to retrieve the next page of
      results. If this field is omitted, there are no subsequent pages.
    orgPolicyViolations: The list of OrgPolicyViolations
  """

  nextPageToken = _messages.StringField(1)
  orgPolicyViolations = _messages.MessageField('GoogleCloudPolicysimulatorV1betaOrgPolicyViolation', 2, repeated=True)


class GoogleCloudPolicysimulatorV1betaListReplayResultsResponse(_messages.Message):
  r"""Response message for Simulator.ListReplayResults.

  Fields:
    nextPageToken: A token that you can use to retrieve the next page of
      ReplayResult objects. If this field is omitted, there are no subsequent
      pages.
    replayResults: The results of running a Replay.
  """

  nextPageToken = _messages.StringField(1)
  replayResults = _messages.MessageField('GoogleCloudPolicysimulatorV1betaReplayResult', 2, repeated=True)


class GoogleCloudPolicysimulatorV1betaListReplaysResponse(_messages.Message):
  r"""Response message for Simulator.ListReplays.

  Fields:
    nextPageToken: A token that you can use to retrieve the next page of
      results. If this field is omitted, there are no subsequent pages.
    replays: The list of Replay objects.
  """

  nextPageToken = _messages.StringField(1)
  replays = _messages.MessageField('GoogleCloudPolicysimulatorV1betaReplay', 2, repeated=True)


class GoogleCloudPolicysimulatorV1betaOrgPolicyOverlay(_messages.Message):
  r"""The proposed changes to OrgPolicy.

  Fields:
    customConstraints: Optional. The OrgPolicy CustomConstraint changes to
      preview violations for. Any existing CustomConstraints with the same
      name will be overridden in the simulation. That is, violations will be
      determined as if all custom constraints in the overlay were
      instantiated. Only a single custom_constraint is supported in the
      overlay at a time. For evaluating multiple constraints, multiple
      `GenerateOrgPolicyViolationsPreview` requests are made, where each
      request evaluates a single constraint.
    policies: Optional. The OrgPolicy changes to preview violations for. Any
      existing OrgPolicies with the same name will be overridden in the
      simulation. That is, violations will be determined as if all policies in
      the overlay were created or updated.
  """

  customConstraints = _messages.MessageField('GoogleCloudPolicysimulatorV1betaOrgPolicyOverlayCustomConstraintOverlay', 1, repeated=True)
  policies = _messages.MessageField('GoogleCloudPolicysimulatorV1betaOrgPolicyOverlayPolicyOverlay', 2, repeated=True)


class GoogleCloudPolicysimulatorV1betaOrgPolicyOverlayCustomConstraintOverlay(_messages.Message):
  r"""A change to an OrgPolicy custom constraint.

  Fields:
    customConstraint: Optional. The new or updated custom constraint.
    customConstraintParent: Optional. Resource the constraint is attached to.
      Example: "organization/987654"
  """

  customConstraint = _messages.MessageField('GoogleCloudOrgpolicyV2CustomConstraint', 1)
  customConstraintParent = _messages.StringField(2)


class GoogleCloudPolicysimulatorV1betaOrgPolicyOverlayPolicyOverlay(_messages.Message):
  r"""A change to an OrgPolicy.

  Fields:
    policy: Optional. The new or updated OrgPolicy.
    policyParent: Optional. The parent of the policy we are attaching to.
      Example: "projects/123456"
  """

  policy = _messages.MessageField('GoogleCloudOrgpolicyV2Policy', 1)
  policyParent = _messages.StringField(2)


class GoogleCloudPolicysimulatorV1betaOrgPolicyViolation(_messages.Message):
  r"""OrgPolicyViolation is a resource representing a single resource
  violating a single OrgPolicy constraint.

  Fields:
    customConstraint: The custom constraint being violated.
    error: Any error encountered during the evaluation.
    name: The name of the `OrgPolicyViolation`. Example: organizations/my-
      example-org/locations/global/orgPolicyViolationsPreviews/506a5f7f/orgPol
      icyViolations/38ce`
    resource: The resource violating the constraint.
  """

  customConstraint = _messages.MessageField('GoogleCloudOrgpolicyV2CustomConstraint', 1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  name = _messages.StringField(3)
  resource = _messages.MessageField('GoogleCloudPolicysimulatorV1betaResourceContext', 4)


class GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview(_messages.Message):
  r"""OrgPolicyViolationsPreview is a resource providing a preview of the
  violations that will exist if an OrgPolicy change is made. The list of
  violations are modeled as child resources and retrieved via a
  ListOrgPolicyViolations API call. There are potentially more
  OrgPolicyViolations than could fit in an embedded field. Thus, the use of a
  child resource instead of a field.

  Enums:
    StateValueValuesEnum: Output only. The state of the
      `OrgPolicyViolationsPreview`.

  Fields:
    createTime: Output only. Time when this `OrgPolicyViolationsPreview` was
      created.
    customConstraints: Output only. The names of the constraints against which
      all `OrgPolicyViolations` were evaluated. If `OrgPolicyOverlay` only
      contains `PolicyOverlay` then it contains the name of the configured
      custom constraint, applicable to the specified policies. Otherwise it
      contains the name of the constraint specified in
      `CustomConstraintOverlay`. Format: `organizations/{organization_id}/cust
      omConstraints/{custom_constraint_id}` Example:
      `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
    name: Output only. The resource name of the `OrgPolicyViolationsPreview`.
      It has the following format: `organizations/{organization}/locations/{lo
      cation}/orgPolicyViolationsPreviews/{orgPolicyViolationsPreview}`
      Example: `organizations/my-example-
      org/locations/global/orgPolicyViolationsPreviews/506a5f7f`
    overlay: Required. The proposed changes we are previewing violations for.
    resourceCounts: Output only. A summary of the state of all resources
      scanned for compliance with the changed OrgPolicy.
    state: Output only. The state of the `OrgPolicyViolationsPreview`.
    violationsCount: Output only. The number of OrgPolicyViolations in this
      `OrgPolicyViolationsPreview`. This count may differ from
      `resource_summary.noncompliant_count` because each OrgPolicyViolation is
      specific to a resource **and** constraint. If there are multiple
      constraints being evaluated (i.e. multiple policies in the overlay), a
      single resource may violate multiple constraints.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the `OrgPolicyViolationsPreview`.

    Values:
      PREVIEW_STATE_UNSPECIFIED: The state is unspecified.
      PREVIEW_PENDING: The OrgPolicyViolationsPreview has not been created
        yet.
      PREVIEW_RUNNING: The OrgPolicyViolationsPreview is currently being
        created.
      PREVIEW_SUCCEEDED: The OrgPolicyViolationsPreview creation finished
        successfully.
      PREVIEW_FAILED: The OrgPolicyViolationsPreview creation failed with an
        error.
    """
    PREVIEW_STATE_UNSPECIFIED = 0
    PREVIEW_PENDING = 1
    PREVIEW_RUNNING = 2
    PREVIEW_SUCCEEDED = 3
    PREVIEW_FAILED = 4

  createTime = _messages.StringField(1)
  customConstraints = _messages.StringField(2, repeated=True)
  name = _messages.StringField(3)
  overlay = _messages.MessageField('GoogleCloudPolicysimulatorV1betaOrgPolicyOverlay', 4)
  resourceCounts = _messages.MessageField('GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreviewResourceCounts', 5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  violationsCount = _messages.IntegerField(7, variant=_messages.Variant.INT32)


class GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreviewResourceCounts(_messages.Message):
  r"""A summary of the state of all resources scanned for compliance with the
  changed OrgPolicy.

  Fields:
    compliant: Output only. Number of scanned resources with zero violations.
    errors: Output only. Number of resources that returned an error when
      scanned.
    noncompliant: Output only. Number of scanned resources with at least one
      violation.
    scanned: Output only. Number of resources checked for compliance. Must
      equal: unenforced + noncompliant + compliant + error
    unenforced: Output only. Number of resources where the constraint was not
      enforced, i.e. the Policy set `enforced: false` for that resource.
  """

  compliant = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  errors = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  noncompliant = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  scanned = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  unenforced = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class GoogleCloudPolicysimulatorV1betaReplay(_messages.Message):
  r"""A resource describing a `Replay`, or simulation.

  Enums:
    StateValueValuesEnum: Output only. The current state of the `Replay`.

  Fields:
    config: Required. The configuration used for the `Replay`.
    name: Output only. The resource name of the `Replay`, which has the
      following format: `{projects|folders|organizations}/{resource-
      id}/locations/global/replays/{replay-id}`, where `{resource-id}` is the
      ID of the project, folder, or organization that owns the Replay.
      Example: `projects/my-example-
      project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
    resultsSummary: Output only. Summary statistics about the replayed log
      entries.
    state: Output only. The current state of the `Replay`.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the `Replay`.

    Values:
      STATE_UNSPECIFIED: Default value. This value is unused.
      PENDING: The `Replay` has not started yet.
      RUNNING: The `Replay` is currently running.
      SUCCEEDED: The `Replay` has successfully completed.
      FAILED: The `Replay` has finished with an error.
    """
    STATE_UNSPECIFIED = 0
    PENDING = 1
    RUNNING = 2
    SUCCEEDED = 3
    FAILED = 4

  config = _messages.MessageField('GoogleCloudPolicysimulatorV1betaReplayConfig', 1)
  name = _messages.StringField(2)
  resultsSummary = _messages.MessageField('GoogleCloudPolicysimulatorV1betaReplayResultsSummary', 3)
  state = _messages.EnumField('StateValueValuesEnum', 4)


class GoogleCloudPolicysimulatorV1betaReplayConfig(_messages.Message):
  r"""The configuration used for a Replay.

  Enums:
    LogSourceValueValuesEnum: The logs to use as input for the Replay.

  Messages:
    PolicyOverlayValue: A mapping of the resources that you want to simulate
      policies for and the policies that you want to simulate. Keys are the
      full resource names for the resources. For example,
      `//cloudresourcemanager.googleapis.com/projects/my-project`. For
      examples of full resource names for Google Cloud services, see
      https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
      Values are Policy objects representing the policies that you want to
      simulate. Replays automatically take into account any IAM policies
      inherited through the resource hierarchy, and any policies set on
      descendant resources. You do not need to include these policies in the
      policy overlay.

  Fields:
    logSource: The logs to use as input for the Replay.
    policyOverlay: A mapping of the resources that you want to simulate
      policies for and the policies that you want to simulate. Keys are the
      full resource names for the resources. For example,
      `//cloudresourcemanager.googleapis.com/projects/my-project`. For
      examples of full resource names for Google Cloud services, see
      https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
      Values are Policy objects representing the policies that you want to
      simulate. Replays automatically take into account any IAM policies
      inherited through the resource hierarchy, and any policies set on
      descendant resources. You do not need to include these policies in the
      policy overlay.
  """

  class LogSourceValueValuesEnum(_messages.Enum):
    r"""The logs to use as input for the Replay.

    Values:
      LOG_SOURCE_UNSPECIFIED: An unspecified log source. If the log source is
        unspecified, the Replay defaults to using `RECENT_ACCESSES`.
      RECENT_ACCESSES: All access logs from the last 90 days. These logs may
        not include logs from the most recent 7 days.
    """
    LOG_SOURCE_UNSPECIFIED = 0
    RECENT_ACCESSES = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PolicyOverlayValue(_messages.Message):
    r"""A mapping of the resources that you want to simulate policies for and
    the policies that you want to simulate. Keys are the full resource names
    for the resources. For example,
    `//cloudresourcemanager.googleapis.com/projects/my-project`. For examples
    of full resource names for Google Cloud services, see
    https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
    Values are Policy objects representing the policies that you want to
    simulate. Replays automatically take into account any IAM policies
    inherited through the resource hierarchy, and any policies set on
    descendant resources. You do not need to include these policies in the
    policy overlay.

    Messages:
      AdditionalProperty: An additional property for a PolicyOverlayValue
        object.

    Fields:
      additionalProperties: Additional properties of type PolicyOverlayValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PolicyOverlayValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleIamV1Policy attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleIamV1Policy', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  logSource = _messages.EnumField('LogSourceValueValuesEnum', 1)
  policyOverlay = _messages.MessageField('PolicyOverlayValue', 2)


class GoogleCloudPolicysimulatorV1betaReplayDiff(_messages.Message):
  r"""The difference between the results of evaluating an access tuple under
  the current (baseline) policies and under the proposed (simulated) policies.
  This difference explains how a principal's access could change if the
  proposed policies were applied.

  Fields:
    accessDiff: A summary and comparison of the principal's access under the
      current (baseline) policies and the proposed (simulated) policies for a
      single access tuple. The evaluation of the principal's access is
      reported in the AccessState field.
  """

  accessDiff = _messages.MessageField('GoogleCloudPolicysimulatorV1betaAccessStateDiff', 1)


class GoogleCloudPolicysimulatorV1betaReplayResult(_messages.Message):
  r"""The result of replaying a single access tuple against a simulated state.

  Fields:
    accessTuple: The access tuple that was replayed. This field includes
      information about the principal, resource, and permission that were
      involved in the access attempt.
    diff: The difference between the principal's access under the current
      (baseline) policies and the principal's access under the proposed
      (simulated) policies. This field is only included for access tuples that
      were successfully replayed and had different results under the current
      policies and the proposed policies.
    error: The error that caused the access tuple replay to fail. This field
      is only included for access tuples that were not replayed successfully.
    lastSeenDate: The latest date this access tuple was seen in the logs.
    name: The resource name of the `ReplayResult`, in the following format:
      `{projects|folders|organizations}/{resource-
      id}/locations/global/replays/{replay-id}/results/{replay-result-id}`,
      where `{resource-id}` is the ID of the project, folder, or organization
      that owns the Replay. Example: `projects/my-example-project/locations/gl
      obal/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36/results/1234`
    parent: The Replay that the access tuple was included in.
  """

  accessTuple = _messages.MessageField('GoogleCloudPolicysimulatorV1betaAccessTuple', 1)
  diff = _messages.MessageField('GoogleCloudPolicysimulatorV1betaReplayDiff', 2)
  error = _messages.MessageField('GoogleRpcStatus', 3)
  lastSeenDate = _messages.MessageField('GoogleTypeDate', 4)
  name = _messages.StringField(5)
  parent = _messages.StringField(6)


class GoogleCloudPolicysimulatorV1betaReplayResultsSummary(_messages.Message):
  r"""Summary statistics about the replayed log entries.

  Fields:
    differenceCount: The number of replayed log entries with a difference
      between baseline and simulated policies.
    errorCount: The number of log entries that could not be replayed.
    logCount: The total number of log entries replayed.
    newestDate: The date of the newest log entry replayed.
    oldestDate: The date of the oldest log entry replayed.
    unchangedCount: The number of replayed log entries with no difference
      between baseline and simulated policies.
  """

  differenceCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  errorCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  logCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  newestDate = _messages.MessageField('GoogleTypeDate', 4)
  oldestDate = _messages.MessageField('GoogleTypeDate', 5)
  unchangedCount = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class GoogleCloudPolicysimulatorV1betaResourceContext(_messages.Message):
  r"""ResourceContext provides the context we know about a resource. It is
  similar in concept to google.cloud.asset.v1.Resource, but focuses on the
  information specifically used by Simulator.

  Fields:
    ancestors: The ancestry path of the resource in Google Cloud [resource
      hierarchy](https://cloud.google.com/resource-manager/docs/cloud-
      platform-resource-hierarchy), represented as a list of relative resource
      names. An ancestry path starts with the closest ancestor in the
      hierarchy and ends at root. If the resource is a project, folder, or
      organization, the ancestry path starts from the resource itself.
      Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
    assetType: The asset type of the resource as defined by CAIS. Example:
      `compute.googleapis.com/Firewall` See [Supported asset
      types](https://cloud.google.com/asset-inventory/docs/supported-asset-
      types) for more information.
    resource: The full name of the resource. Example: `//compute.googleapis.co
      m/projects/my_project_123/zones/zone1/instances/instance1` See [Resource
      names](https://cloud.google.com/apis/design/resource_names#full_resource
      _name) for more information.
  """

  ancestors = _messages.StringField(1, repeated=True)
  assetType = _messages.StringField(2)
  resource = _messages.StringField(3)


class GoogleIamV1AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('GoogleIamV1AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class GoogleIamV1AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    ignoreChildExemptions: A boolean attribute.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  ignoreChildExemptions = _messages.BooleanField(2)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 3)


class GoogleIamV1Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    bindingId: A string attribute.
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. * `principal://iam.googleapis.com/locatio
      ns/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`: A
      single identity in a workforce identity pool. * `principalSet://iam.goog
      leapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}`:
      All workforce identities in a group. * `principalSet://iam.googleapis.co
      m/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{
      attribute_value}`: All workforce identities with a specific attribute
      value. * `principalSet://iam.googleapis.com/locations/global/workforcePo
      ols/{pool_id}/*`: All identities in a workforce identity pool. * `princi
      pal://iam.googleapis.com/projects/{project_number}/locations/global/work
      loadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
      identity in a workload identity pool. * `principalSet://iam.googleapis.c
      om/projects/{project_number}/locations/global/workloadIdentityPools/{poo
      l_id}/group/{group_id}`: A workload identity pool group. * `principalSet
      ://iam.googleapis.com/projects/{project_number}/locations/global/workloa
      dIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}`:
      All identities in a workload identity pool with a certain attribute. * `
      principalSet://iam.googleapis.com/projects/{project_number}/locations/gl
      obal/workloadIdentityPools/{pool_id}/*`: All identities in a workload
      identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email
      address (plus unique identifier) representing a user that has been
      recently deleted. For example,
      `alice@example.com?uid=123456789012345678901`. If the user is recovered,
      this value reverts to `user:{emailid}` and the recovered user retains
      the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `deleted:principal://iam.google
      apis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attr
      ibute_value}`: Deleted single identity in a workforce identity pool. For
      example, `deleted:principal://iam.googleapis.com/locations/global/workfo
      rcePools/my-pool-id/subject/my-subject-attribute-value`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an
      overview of the IAM roles and permissions, see the [IAM
      documentation](https://cloud.google.com/iam/docs/roles-overview). For a
      list of the available pre-defined roles, see
      [here](https://cloud.google.com/iam/docs/understanding-roles).
  """

  bindingId = _messages.StringField(1)
  condition = _messages.MessageField('GoogleTypeExpr', 2)
  members = _messages.StringField(3, repeated=True)
  role = _messages.StringField(4)


class GoogleIamV1Condition(_messages.Message):
  r"""A condition to be met.

  Enums:
    IamValueValuesEnum: Trusted attributes supplied by the IAM system.
    OpValueValuesEnum: An operator to apply the subject with.
    SysValueValuesEnum: Trusted attributes supplied by any service that owns
      resources and uses the IAM system for access control.

  Fields:
    iam: Trusted attributes supplied by the IAM system.
    op: An operator to apply the subject with.
    svc: Trusted attributes discharged by the service.
    sys: Trusted attributes supplied by any service that owns resources and
      uses the IAM system for access control.
    values: The objects of the condition.
  """

  class IamValueValuesEnum(_messages.Enum):
    r"""Trusted attributes supplied by the IAM system.

    Values:
      NO_ATTR: Default non-attribute.
      AUTHORITY: Either principal or (if present) authority selector.
      ATTRIBUTION: The principal (even if an authority selector is present),
        which must only be used for attribution, not authorization.
      SECURITY_REALM: Any of the security realms in the IAMContext
        (go/security-realms). When used with IN, the condition indicates "any
        of the request's realms match one of the given values; with NOT_IN,
        "none of the realms match any of the given values". Note that a value
        can be: - 'self:campus' (i.e., clients that are in the same campus) -
        'self:metro' (i.e., clients that are in the same metro) - 'self:cloud-
        region' (i.e., allow connections from clients that are in the same
        cloud region) - 'self:prod-region' (i.e., allow connections from
        clients that are in the same prod region) - 'guardians' (i.e., allow
        connections from its guardian realms. See go/security-realms-
        glossary#guardian for more information.) - 'self' [DEPRECATED] (i.e.,
        allow connections from clients that are in the same security realm,
        which is currently but not guaranteed to be campus-sized) - a realm
        (e.g., 'campus-abc') - a realm group (e.g., 'realms-for-borg-cell-xx',
        see: go/realm-groups) A match is determined by a realm group
        membership check performed by a RealmAclRep object (go/realm-acl-
        howto). It is not permitted to grant access based on the *absence* of
        a realm, so realm conditions can only be used in a "positive" context
        (e.g., ALLOW/IN or DENY/NOT_IN).
      APPROVER: An approver (distinct from the requester) that has authorized
        this request. When used with IN, the condition indicates that one of
        the approvers associated with the request matches the specified
        principal, or is a member of the specified group. Approvers can only
        grant additional access, and are thus only used in a strictly positive
        context (e.g. ALLOW/IN or DENY/NOT_IN).
      JUSTIFICATION_TYPE: What types of justifications have been supplied with
        this request. String values should match enum names from
        security.credentials.JustificationType, e.g. "MANUAL_STRING". It is
        not permitted to grant access based on the *absence* of a
        justification, so justification conditions can only be used in a
        "positive" context (e.g., ALLOW/IN or DENY/NOT_IN). Multiple
        justifications, e.g., a Buganizer ID and a manually-entered reason,
        are normal and supported.
      CREDENTIALS_TYPE: What type of credentials have been supplied with this
        request. String values should match enum names from
        security_loas_l2.CredentialsType - currently, only
        CREDS_TYPE_EMERGENCY is supported. It is not permitted to grant access
        based on the *absence* of a credentials type, so the conditions can
        only be used in a "positive" context (e.g., ALLOW/IN or DENY/NOT_IN).
      CREDS_ASSERTION: EXPERIMENTAL -- DO NOT USE. The conditions can only be
        used in a "positive" context (e.g., ALLOW/IN or DENY/NOT_IN).
    """
    NO_ATTR = 0
    AUTHORITY = 1
    ATTRIBUTION = 2
    SECURITY_REALM = 3
    APPROVER = 4
    JUSTIFICATION_TYPE = 5
    CREDENTIALS_TYPE = 6
    CREDS_ASSERTION = 7

  class OpValueValuesEnum(_messages.Enum):
    r"""An operator to apply the subject with.

    Values:
      NO_OP: Default no-op.
      EQUALS: DEPRECATED. Use IN instead.
      NOT_EQUALS: DEPRECATED. Use NOT_IN instead.
      IN: The condition is true if the subject (or any element of it if it is
        a set) matches any of the supplied values.
      NOT_IN: The condition is true if the subject (or every element of it if
        it is a set) matches none of the supplied values.
      DISCHARGED: Subject is discharged
    """
    NO_OP = 0
    EQUALS = 1
    NOT_EQUALS = 2
    IN = 3
    NOT_IN = 4
    DISCHARGED = 5

  class SysValueValuesEnum(_messages.Enum):
    r"""Trusted attributes supplied by any service that owns resources and
    uses the IAM system for access control.

    Values:
      NO_ATTR: Default non-attribute type
      REGION: Region of the resource
      SERVICE: Service name
      NAME: Resource name
      IP: IP address of the caller
    """
    NO_ATTR = 0
    REGION = 1
    SERVICE = 2
    NAME = 3
    IP = 4

  iam = _messages.EnumField('IamValueValuesEnum', 1)
  op = _messages.EnumField('OpValueValuesEnum', 2)
  svc = _messages.StringField(3)
  sys = _messages.EnumField('SysValueValuesEnum', 4)
  values = _messages.StringField(5, repeated=True)


class GoogleIamV1LogConfig(_messages.Message):
  r"""Specifies what kind of log the caller must write

  Fields:
    cloudAudit: Cloud audit options.
    counter: Counter options.
    dataAccess: Data access options.
  """

  cloudAudit = _messages.MessageField('GoogleIamV1LogConfigCloudAuditOptions', 1)
  counter = _messages.MessageField('GoogleIamV1LogConfigCounterOptions', 2)
  dataAccess = _messages.MessageField('GoogleIamV1LogConfigDataAccessOptions', 3)


class GoogleIamV1LogConfigCloudAuditOptions(_messages.Message):
  r"""Write a Cloud Audit log

  Enums:
    LogNameValueValuesEnum: The log_name to populate in the Cloud Audit
      Record.
    PermissionTypeValueValuesEnum: The type associated with the permission.

  Fields:
    authorizationLoggingOptions: Information used by the Cloud Audit Logging
      pipeline. Will be deprecated once the migration to PermissionType is
      complete (b/201806118).
    logName: The log_name to populate in the Cloud Audit Record.
    permissionType: The type associated with the permission.
  """

  class LogNameValueValuesEnum(_messages.Enum):
    r"""The log_name to populate in the Cloud Audit Record.

    Values:
      UNSPECIFIED_LOG_NAME: Default. Should not be used.
      ADMIN_ACTIVITY: Corresponds to "cloudaudit.googleapis.com/activity"
      DATA_ACCESS: Corresponds to "cloudaudit.googleapis.com/data_access"
    """
    UNSPECIFIED_LOG_NAME = 0
    ADMIN_ACTIVITY = 1
    DATA_ACCESS = 2

  class PermissionTypeValueValuesEnum(_messages.Enum):
    r"""The type associated with the permission.

    Values:
      PERMISSION_TYPE_UNSPECIFIED: Default. Should not be used.
      ADMIN_READ: Permissions that gate reading resource configuration or
        metadata.
      ADMIN_WRITE: Permissions that gate modification of resource
        configuration or metadata.
      DATA_READ: Permissions that gate reading user-provided data.
      DATA_WRITE: Permissions that gate writing user-provided data.
    """
    PERMISSION_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    ADMIN_WRITE = 2
    DATA_READ = 3
    DATA_WRITE = 4

  authorizationLoggingOptions = _messages.MessageField('GoogleCloudAuditAuthorizationLoggingOptions', 1)
  logName = _messages.EnumField('LogNameValueValuesEnum', 2)
  permissionType = _messages.EnumField('PermissionTypeValueValuesEnum', 3)


class GoogleIamV1LogConfigCounterOptions(_messages.Message):
  r"""Increment a streamz counter with the specified metric and field names.
  Metric names should start with a '/', generally be lowercase-only, and end
  in "_count". Field names should not contain an initial slash. The actual
  exported metric names will have "/iam/policy" prepended. Field names
  correspond to IAM request parameters and field values are their respective
  values. Supported field names: - "authority", which is "[token]" if
  IAMContext.token is present, otherwise the value of
  IAMContext.authority_selector if present, and otherwise a representation of
  IAMContext.principal; or - "iam_principal", a representation of
  IAMContext.principal even if a token or authority selector is present; or -
  "" (empty string), resulting in a counter with no fields. Examples: counter
  { metric: "/debug_access_count" field: "iam_principal" } ==> increment
  counter /iam/policy/debug_access_count {iam_principal=[value of
  IAMContext.principal]}

  Fields:
    customFields: Custom fields.
    field: The field value to attribute.
    metric: The metric to update.
  """

  customFields = _messages.MessageField('GoogleIamV1LogConfigCounterOptionsCustomField', 1, repeated=True)
  field = _messages.StringField(2)
  metric = _messages.StringField(3)


class GoogleIamV1LogConfigCounterOptionsCustomField(_messages.Message):
  r"""Custom fields. These can be used to create a counter with arbitrary
  field/value pairs. See: go/rpcsp-custom-fields.

  Fields:
    name: Name is the field name.
    value: Value is the field value. It is important that in contrast to the
      CounterOptions.field, the value here is a constant that is not derived
      from the IAMContext.
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class GoogleIamV1LogConfigDataAccessOptions(_messages.Message):
  r"""Write a Data Access (Gin) log

  Enums:
    LogModeValueValuesEnum:

  Fields:
    logMode: A LogModeValueValuesEnum attribute.
  """

  class LogModeValueValuesEnum(_messages.Enum):
    r"""LogModeValueValuesEnum enum type.

    Values:
      LOG_MODE_UNSPECIFIED: Client is not required to write a partial Gin log
        immediately after the authorization check. If client chooses to write
        one and it fails, client may either fail open (allow the operation to
        continue) or fail closed (handle as a DENY outcome).
      LOG_FAIL_CLOSED: The application's operation in the context of which
        this authorization check is being made may only be performed if it is
        successfully logged to Gin. For instance, the authorization library
        may satisfy this obligation by emitting a partial log entry at
        authorization check time and only returning ALLOW to the application
        if it succeeds. If a matching Rule has this directive, but the client
        has not indicated that it will honor such requirements, then the IAM
        check will result in authorization failure by setting
        CheckPolicyResponse.success=false.
    """
    LOG_MODE_UNSPECIFIED = 0
    LOG_FAIL_CLOSED = 1

  logMode = _messages.EnumField('LogModeValueValuesEnum', 1)


class GoogleIamV1Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** ``` { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
  members: - user:mike@example.com - group:admins@example.com -
  domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
  role: roles/resourcemanager.organizationAdmin - members: -
  user:eve@example.com role: roles/resourcemanager.organizationViewer
  condition: title: expirable access description: Does not grant access after
  Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
  etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
  see the [IAM documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    rules: If more than one rule is specified, the rules are applied in the
      following manner: - All matching LOG rules are always applied. - If any
      DENY/DENY_WITH_LOG rule matches, permission is denied. Logging will be
      applied if one or more matching rule requires logging. - Otherwise, if
      any ALLOW/ALLOW_WITH_LOG rule matches, permission is granted. Logging
      will be applied if one or more matching rule requires logging. -
      Otherwise, if no rule applies, permission is denied.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('GoogleIamV1AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('GoogleIamV1Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  rules = _messages.MessageField('GoogleIamV1Rule', 4, repeated=True)
  version = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class GoogleIamV1Rule(_messages.Message):
  r"""A rule to be applied in a Policy.

  Enums:
    ActionValueValuesEnum: Required

  Fields:
    action: Required
    conditions: Additional restrictions that must be met. All conditions must
      pass for the rule to match.
    description: Human-readable description of the rule.
    in_: If one or more 'in' clauses are specified, the rule matches if the
      PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
    logConfig: The config returned to callers of CheckPolicy for any entries
      that match the LOG action.
    notIn: If one or more 'not_in' clauses are specified, the rule matches if
      the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries. The format
      for in and not_in entries can be found at in the Local IAM documentation
      (see go/local-iam#features).
    permissions: A permission is a string of form '..' (e.g.,
      'storage.buckets.list'). A value of '*' matches all permissions, and a
      verb part of '*' (e.g., 'storage.buckets.*') matches all verbs.
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""Required

    Values:
      NO_ACTION: Default no action.
      ALLOW: Matching 'Entries' grant access.
      ALLOW_WITH_LOG: Matching 'Entries' grant access and the caller promises
        to log the request per the returned log_configs.
      DENY: Matching 'Entries' deny access.
      DENY_WITH_LOG: Matching 'Entries' deny access and the caller promises to
        log the request per the returned log_configs.
      LOG: Matching 'Entries' tell IAM.Check callers to generate logs.
    """
    NO_ACTION = 0
    ALLOW = 1
    ALLOW_WITH_LOG = 2
    DENY = 3
    DENY_WITH_LOG = 4
    LOG = 5

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  conditions = _messages.MessageField('GoogleIamV1Condition', 2, repeated=True)
  description = _messages.StringField(3)
  in_ = _messages.StringField(4, repeated=True)
  logConfig = _messages.MessageField('GoogleIamV1LogConfig', 5, repeated=True)
  notIn = _messages.StringField(6, repeated=True)
  permissions = _messages.StringField(7, repeated=True)


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GoogleTypeDate(_messages.Message):
  r"""Represents a whole or partial calendar date, such as a birthday. The
  time of day and time zone are either specified elsewhere or are
  insignificant. The date is relative to the Gregorian Calendar. This can
  represent one of the following: * A full date, with non-zero year, month,
  and day values. * A month and day, with a zero year (for example, an
  anniversary). * A year on its own, with a zero month and a zero day. * A
  year and month, with a zero day (for example, a credit card expiration
  date). Related types: * google.type.TimeOfDay * google.type.DateTime *
  google.protobuf.Timestamp

  Fields:
    day: Day of a month. Must be from 1 to 31 and valid for the year and
      month, or 0 to specify a year by itself or a year and month where the
      day isn't significant.
    month: Month of a year. Must be from 1 to 12, or 0 to specify a year
      without a month and day.
    year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
      without a year.
  """

  day = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  month = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  year = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleTypeExpr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class PolicysimulatorFoldersLocationsOrgPolicyViolationsPreviewsOperationsGetRequest(_messages.Message):
  r"""A PolicysimulatorFoldersLocationsOrgPolicyViolationsPreviewsOperationsGe
  tRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class PolicysimulatorFoldersLocationsReplaysCreateRequest(_messages.Message):
  r"""A PolicysimulatorFoldersLocationsReplaysCreateRequest object.

  Fields:
    googleCloudPolicysimulatorV1betaReplay: A
      GoogleCloudPolicysimulatorV1betaReplay resource to be passed as the
      request body.
    parent: Required. The parent resource where this Replay will be created.
      This resource must be a project, folder, or organization with a
      location. Example: `projects/my-example-project/locations/global`
  """

  googleCloudPolicysimulatorV1betaReplay = _messages.MessageField('GoogleCloudPolicysimulatorV1betaReplay', 1)
  parent = _messages.StringField(2, required=True)


class PolicysimulatorFoldersLocationsReplaysGetRequest(_messages.Message):
  r"""A PolicysimulatorFoldersLocationsReplaysGetRequest object.

  Fields:
    name: Required. The name of the Replay to retrieve, in the following
      format: `{projects|folders|organizations}/{resource-
      id}/locations/global/replays/{replay-id}`, where `{resource-id}` is the
      ID of the project, folder, or organization that owns the `Replay`.
      Example: `projects/my-example-
      project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
  """

  name = _messages.StringField(1, required=True)


class PolicysimulatorFoldersLocationsReplaysListRequest(_messages.Message):
  r"""A PolicysimulatorFoldersLocationsReplaysListRequest object.

  Fields:
    pageSize: The maximum number of Replay objects to return. Defaults to 50.
      The maximum value is 1000; values above 1000 are rounded down to 1000.
    pageToken: A page token, received from a previous Simulator.ListReplays
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to Simulator.ListReplays must match the call
      that provided the page token.
    parent: Required. The parent resource, in the following format:
      `{projects|folders|organizations}/{resource-id}/locations/global`, where
      `{resource-id}` is the ID of the project, folder, or organization that
      owns the Replay. Example: `projects/my-example-project/locations/global`
      Only `Replay` objects that are direct children of the provided parent
      are listed. In other words, `Replay` objects that are children of a
      project will not be included when the parent is a folder of that
      project.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class PolicysimulatorFoldersLocationsReplaysOperationsGetRequest(_messages.Message):
  r"""A PolicysimulatorFoldersLocationsReplaysOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class PolicysimulatorFoldersLocationsReplaysOperationsListRequest(_messages.Message):
  r"""A PolicysimulatorFoldersLocationsReplaysOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class PolicysimulatorFoldersLocationsReplaysResultsListRequest(_messages.Message):
  r"""A PolicysimulatorFoldersLocationsReplaysResultsListRequest object.

  Fields:
    pageSize: The maximum number of ReplayResult objects to return. Defaults
      to 5000. The maximum value is 5000; values above 5000 are rounded down
      to 5000.
    pageToken: A page token, received from a previous
      Simulator.ListReplayResults call. Provide this token to retrieve the
      next page of results. When paginating, all other parameters provided to
      [Simulator.ListReplayResults[] must match the call that provided the
      page token.
    parent: Required. The Replay whose results are listed, in the following
      format: `{projects|folders|organizations}/{resource-
      id}/locations/global/replays/{replay-id}` Example: `projects/my-
      project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class PolicysimulatorOperationsGetRequest(_messages.Message):
  r"""A PolicysimulatorOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class PolicysimulatorOperationsListRequest(_messages.Message):
  r"""A PolicysimulatorOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class PolicysimulatorOrganizationsLocationsOrgPolicyViolationsPreviewsCreateRequest(_messages.Message):
  r"""A PolicysimulatorOrganizationsLocationsOrgPolicyViolationsPreviewsCreate
  Request object.

  Fields:
    googleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview: A
      GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview resource to
      be passed as the request body.
    orgPolicyViolationsPreviewId: Optional. An optional user-specified ID for
      the OrgPolicyViolationsPreview. If not provided, a random ID will be
      generated.
    parent: Required. The organization under which this
      OrgPolicyViolationsPreview will be created. Example: `organizations/my-
      example-org/locations/global`
  """

  googleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview = _messages.MessageField('GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview', 1)
  orgPolicyViolationsPreviewId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class PolicysimulatorOrganizationsLocationsOrgPolicyViolationsPreviewsGenerateRequest(_messages.Message):
  r"""A PolicysimulatorOrganizationsLocationsOrgPolicyViolationsPreviewsGenera
  teRequest object.

  Fields:
    googleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview: A
      GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview resource to
      be passed as the request body.
    parent: Required. The organization under which this
      OrgPolicyViolationsPreview will be created. Example: `organizations/my-
      example-org/locations/global`
  """

  googleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview = _messages.MessageField('GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview', 1)
  parent = _messages.StringField(2, required=True)


class PolicysimulatorOrganizationsLocationsOrgPolicyViolationsPreviewsGetRequest(_messages.Message):
  r"""A
  PolicysimulatorOrganizationsLocationsOrgPolicyViolationsPreviewsGetRequest
  object.

  Fields:
    name: Required. The name of the OrgPolicyViolationsPreview to get.
  """

  name = _messages.StringField(1, required=True)


class PolicysimulatorOrganizationsLocationsOrgPolicyViolationsPreviewsListRequest(_messages.Message):
  r"""A
  PolicysimulatorOrganizationsLocationsOrgPolicyViolationsPreviewsListRequest
  object.

  Fields:
    pageSize: Optional. The maximum number of items to return. The service may
      return fewer than this value. If unspecified, at most 5 items will be
      returned. The maximum value is 10; values above 10 will be coerced to
      10.
    pageToken: Optional. A page token, received from a previous call. Provide
      this to retrieve the subsequent page. When paginating, all other
      parameters must match the call that provided the page token.
    parent: Required. The parent the violations are scoped to. Format:
      `organizations/{organization}/locations/{location}` Example:
      `organizations/my-example-org/locations/global`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class PolicysimulatorOrganizationsLocationsOrgPolicyViolationsPreviewsOperationsGetRequest(_messages.Message):
  r"""A PolicysimulatorOrganizationsLocationsOrgPolicyViolationsPreviewsOperat
  ionsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class PolicysimulatorOrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsGetRequest(_messages.Message):
  r"""A PolicysimulatorOrganizationsLocationsOrgPolicyViolationsPreviewsOrgPol
  icyViolationsGetRequest object.

  Fields:
    name: Required. The name of the OrgPolicyViolation to get.
  """

  name = _messages.StringField(1, required=True)


class PolicysimulatorOrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListRequest(_messages.Message):
  r"""A PolicysimulatorOrganizationsLocationsOrgPolicyViolationsPreviewsOrgPol
  icyViolationsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of items to return. The service may
      return fewer than this value. If unspecified, at most 50 items will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: Optional. A page token, received from a previous call. Provide
      this to retrieve the subsequent page. When paginating, all other
      parameters must match the call that provided the page token.
    parent: Required. The OrgPolicyViolationsPreview to get
      OrgPolicyViolations from. Format: organizations/{organization}/locations
      /{location}/orgPolicyViolationsPreviews/{orgPolicyViolationsPreview}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class PolicysimulatorOrganizationsLocationsOrgPolicyViolationsPreviewsRequest(_messages.Message):
  r"""A
  PolicysimulatorOrganizationsLocationsOrgPolicyViolationsPreviewsRequest
  object.

  Fields:
    googleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview: A
      GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview resource to
      be passed as the request body.
    parent: Required. The organization under which this
      OrgPolicyViolationsPreview will be created. Example: `organizations/my-
      example-org/locations/global`
  """

  googleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview = _messages.MessageField('GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview', 1)
  parent = _messages.StringField(2, required=True)


class PolicysimulatorOrganizationsLocationsReplaysCreateRequest(_messages.Message):
  r"""A PolicysimulatorOrganizationsLocationsReplaysCreateRequest object.

  Fields:
    googleCloudPolicysimulatorV1betaReplay: A
      GoogleCloudPolicysimulatorV1betaReplay resource to be passed as the
      request body.
    parent: Required. The parent resource where this Replay will be created.
      This resource must be a project, folder, or organization with a
      location. Example: `projects/my-example-project/locations/global`
  """

  googleCloudPolicysimulatorV1betaReplay = _messages.MessageField('GoogleCloudPolicysimulatorV1betaReplay', 1)
  parent = _messages.StringField(2, required=True)


class PolicysimulatorOrganizationsLocationsReplaysGetRequest(_messages.Message):
  r"""A PolicysimulatorOrganizationsLocationsReplaysGetRequest object.

  Fields:
    name: Required. The name of the Replay to retrieve, in the following
      format: `{projects|folders|organizations}/{resource-
      id}/locations/global/replays/{replay-id}`, where `{resource-id}` is the
      ID of the project, folder, or organization that owns the `Replay`.
      Example: `projects/my-example-
      project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
  """

  name = _messages.StringField(1, required=True)


class PolicysimulatorOrganizationsLocationsReplaysListRequest(_messages.Message):
  r"""A PolicysimulatorOrganizationsLocationsReplaysListRequest object.

  Fields:
    pageSize: The maximum number of Replay objects to return. Defaults to 50.
      The maximum value is 1000; values above 1000 are rounded down to 1000.
    pageToken: A page token, received from a previous Simulator.ListReplays
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to Simulator.ListReplays must match the call
      that provided the page token.
    parent: Required. The parent resource, in the following format:
      `{projects|folders|organizations}/{resource-id}/locations/global`, where
      `{resource-id}` is the ID of the project, folder, or organization that
      owns the Replay. Example: `projects/my-example-project/locations/global`
      Only `Replay` objects that are direct children of the provided parent
      are listed. In other words, `Replay` objects that are children of a
      project will not be included when the parent is a folder of that
      project.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class PolicysimulatorOrganizationsLocationsReplaysOperationsGetRequest(_messages.Message):
  r"""A PolicysimulatorOrganizationsLocationsReplaysOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class PolicysimulatorOrganizationsLocationsReplaysOperationsListRequest(_messages.Message):
  r"""A PolicysimulatorOrganizationsLocationsReplaysOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class PolicysimulatorOrganizationsLocationsReplaysResultsListRequest(_messages.Message):
  r"""A PolicysimulatorOrganizationsLocationsReplaysResultsListRequest object.

  Fields:
    pageSize: The maximum number of ReplayResult objects to return. Defaults
      to 5000. The maximum value is 5000; values above 5000 are rounded down
      to 5000.
    pageToken: A page token, received from a previous
      Simulator.ListReplayResults call. Provide this token to retrieve the
      next page of results. When paginating, all other parameters provided to
      [Simulator.ListReplayResults[] must match the call that provided the
      page token.
    parent: Required. The Replay whose results are listed, in the following
      format: `{projects|folders|organizations}/{resource-
      id}/locations/global/replays/{replay-id}` Example: `projects/my-
      project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class PolicysimulatorProjectsLocationsOrgPolicyViolationsPreviewsOperationsGetRequest(_messages.Message):
  r"""A PolicysimulatorProjectsLocationsOrgPolicyViolationsPreviewsOperationsG
  etRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class PolicysimulatorProjectsLocationsReplaysCreateRequest(_messages.Message):
  r"""A PolicysimulatorProjectsLocationsReplaysCreateRequest object.

  Fields:
    googleCloudPolicysimulatorV1betaReplay: A
      GoogleCloudPolicysimulatorV1betaReplay resource to be passed as the
      request body.
    parent: Required. The parent resource where this Replay will be created.
      This resource must be a project, folder, or organization with a
      location. Example: `projects/my-example-project/locations/global`
  """

  googleCloudPolicysimulatorV1betaReplay = _messages.MessageField('GoogleCloudPolicysimulatorV1betaReplay', 1)
  parent = _messages.StringField(2, required=True)


class PolicysimulatorProjectsLocationsReplaysGetRequest(_messages.Message):
  r"""A PolicysimulatorProjectsLocationsReplaysGetRequest object.

  Fields:
    name: Required. The name of the Replay to retrieve, in the following
      format: `{projects|folders|organizations}/{resource-
      id}/locations/global/replays/{replay-id}`, where `{resource-id}` is the
      ID of the project, folder, or organization that owns the `Replay`.
      Example: `projects/my-example-
      project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
  """

  name = _messages.StringField(1, required=True)


class PolicysimulatorProjectsLocationsReplaysListRequest(_messages.Message):
  r"""A PolicysimulatorProjectsLocationsReplaysListRequest object.

  Fields:
    pageSize: The maximum number of Replay objects to return. Defaults to 50.
      The maximum value is 1000; values above 1000 are rounded down to 1000.
    pageToken: A page token, received from a previous Simulator.ListReplays
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to Simulator.ListReplays must match the call
      that provided the page token.
    parent: Required. The parent resource, in the following format:
      `{projects|folders|organizations}/{resource-id}/locations/global`, where
      `{resource-id}` is the ID of the project, folder, or organization that
      owns the Replay. Example: `projects/my-example-project/locations/global`
      Only `Replay` objects that are direct children of the provided parent
      are listed. In other words, `Replay` objects that are children of a
      project will not be included when the parent is a folder of that
      project.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class PolicysimulatorProjectsLocationsReplaysOperationsGetRequest(_messages.Message):
  r"""A PolicysimulatorProjectsLocationsReplaysOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class PolicysimulatorProjectsLocationsReplaysOperationsListRequest(_messages.Message):
  r"""A PolicysimulatorProjectsLocationsReplaysOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class PolicysimulatorProjectsLocationsReplaysResultsListRequest(_messages.Message):
  r"""A PolicysimulatorProjectsLocationsReplaysResultsListRequest object.

  Fields:
    pageSize: The maximum number of ReplayResult objects to return. Defaults
      to 5000. The maximum value is 5000; values above 5000 are rounded down
      to 5000.
    pageToken: A page token, received from a previous
      Simulator.ListReplayResults call. Provide this token to retrieve the
      next page of results. When paginating, all other parameters provided to
      [Simulator.ListReplayResults[] must match the call that provided the
      page token.
    parent: Required. The Replay whose results are listed, in the following
      format: `{projects|folders|organizations}/{resource-
      id}/locations/global/replays/{replay-id}` Example: `projects/my-
      project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    GoogleIamV1Rule, 'in_', 'in')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
