"""Generated client library for iam version v3beta."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.iam.v3beta import iam_v3beta_messages as messages


class IamV3beta(base_api.BaseApiClient):
  """Generated client library for service iam version v3beta."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://iam.googleapis.com/'
  MTLS_BASE_URL = 'https://iam.mtls.googleapis.com/'

  _PACKAGE = 'iam'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v3beta'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'IamV3beta'
  _URL_VERSION = 'v3beta'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new iam handle."""
    url = url or self.BASE_URL
    super(IamV3beta, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.folders_locations_operations = self.FoldersLocationsOperationsService(self)
    self.folders_locations_policies = self.FoldersLocationsPoliciesService(self)
    self.folders_locations_policyBindings = self.FoldersLocationsPolicyBindingsService(self)
    self.folders_locations = self.FoldersLocationsService(self)
    self.folders = self.FoldersService(self)
    self.organizations_locations_operations = self.OrganizationsLocationsOperationsService(self)
    self.organizations_locations_policies = self.OrganizationsLocationsPoliciesService(self)
    self.organizations_locations_policyBindings = self.OrganizationsLocationsPolicyBindingsService(self)
    self.organizations_locations_principalAccessBoundaryPolicies = self.OrganizationsLocationsPrincipalAccessBoundaryPoliciesService(self)
    self.organizations_locations = self.OrganizationsLocationsService(self)
    self.organizations = self.OrganizationsService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_policies = self.ProjectsLocationsPoliciesService(self)
    self.projects_locations_policyBindings = self.ProjectsLocationsPolicyBindingsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class FoldersLocationsOperationsService(base_api.BaseApiService):
    """Service class for the folders_locations_operations resource."""

    _NAME = 'folders_locations_operations'

    def __init__(self, client):
      super(IamV3beta.FoldersLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (IamFoldersLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/folders/{foldersId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='iam.folders.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamFoldersLocationsOperationsGetRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

  class FoldersLocationsPoliciesService(base_api.BaseApiService):
    """Service class for the folders_locations_policies resource."""

    _NAME = 'folders_locations_policies'

    def __init__(self, client):
      super(IamV3beta.FoldersLocationsPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a policy, and returns a long running operation.

      Args:
        request: (IamFoldersLocationsPoliciesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/folders/{foldersId}/locations/{locationsId}/policies',
        http_method='POST',
        method_id='iam.folders.locations.policies.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['policyId', 'validateOnly'],
        relative_path='v3beta/{+parent}/policies',
        request_field='googleIamV3betaPolicy',
        request_type_name='IamFoldersLocationsPoliciesCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a policy. Policies with references to policy bindings can't be deleted unless `force` field is set to `true`, or these policy bindings are deleted.

      Args:
        request: (IamFoldersLocationsPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/folders/{foldersId}/locations/{locationsId}/policies/{policiesId}',
        http_method='DELETE',
        method_id='iam.folders.locations.policies.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['etag', 'force', 'validateOnly'],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamFoldersLocationsPoliciesDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a policy.

      Args:
        request: (IamFoldersLocationsPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleIamV3betaPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/folders/{foldersId}/locations/{locationsId}/policies/{policiesId}',
        http_method='GET',
        method_id='iam.folders.locations.policies.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamFoldersLocationsPoliciesGetRequest',
        response_type_name='GoogleIamV3betaPolicy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists policies.

      Args:
        request: (IamFoldersLocationsPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleIamV3betaListPoliciesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/folders/{foldersId}/locations/{locationsId}/policies',
        http_method='GET',
        method_id='iam.folders.locations.policies.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v3beta/{+parent}/policies',
        request_field='',
        request_type_name='IamFoldersLocationsPoliciesListRequest',
        response_type_name='GoogleIamV3betaListPoliciesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a policy.

      Args:
        request: (IamFoldersLocationsPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/folders/{foldersId}/locations/{locationsId}/policies/{policiesId}',
        http_method='PATCH',
        method_id='iam.folders.locations.policies.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask', 'validateOnly'],
        relative_path='v3beta/{+name}',
        request_field='googleIamV3betaPolicy',
        request_type_name='IamFoldersLocationsPoliciesPatchRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

  class FoldersLocationsPolicyBindingsService(base_api.BaseApiService):
    """Service class for the folders_locations_policyBindings resource."""

    _NAME = 'folders_locations_policyBindings'

    def __init__(self, client):
      super(IamV3beta.FoldersLocationsPolicyBindingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a policy binding and returns a long-running operation. Callers will need the IAM permissions on both the policy and target. Once the binding is created, the policy is applied to the target.

      Args:
        request: (IamFoldersLocationsPolicyBindingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/folders/{foldersId}/locations/{locationsId}/policyBindings',
        http_method='POST',
        method_id='iam.folders.locations.policyBindings.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['policyBindingId', 'validateOnly'],
        relative_path='v3beta/{+parent}/policyBindings',
        request_field='googleIamV3betaPolicyBinding',
        request_type_name='IamFoldersLocationsPolicyBindingsCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a policy binding. Callers will need the IAM permissions on both the policy and target. Once the binding is deleted, the policy no longer applies to the target.

      Args:
        request: (IamFoldersLocationsPolicyBindingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/folders/{foldersId}/locations/{locationsId}/policyBindings/{policyBindingsId}',
        http_method='DELETE',
        method_id='iam.folders.locations.policyBindings.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['etag', 'validateOnly'],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamFoldersLocationsPolicyBindingsDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a policy binding.

      Args:
        request: (IamFoldersLocationsPolicyBindingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleIamV3betaPolicyBinding) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/folders/{foldersId}/locations/{locationsId}/policyBindings/{policyBindingsId}',
        http_method='GET',
        method_id='iam.folders.locations.policyBindings.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamFoldersLocationsPolicyBindingsGetRequest',
        response_type_name='GoogleIamV3betaPolicyBinding',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists policy bindings.

      Args:
        request: (IamFoldersLocationsPolicyBindingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleIamV3betaListPolicyBindingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/folders/{foldersId}/locations/{locationsId}/policyBindings',
        http_method='GET',
        method_id='iam.folders.locations.policyBindings.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v3beta/{+parent}/policyBindings',
        request_field='',
        request_type_name='IamFoldersLocationsPolicyBindingsListRequest',
        response_type_name='GoogleIamV3betaListPolicyBindingsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a policy binding. Callers will need the IAM permissions on the policy and target in the binding to update, and the IAM permission to remove the existing policy from the binding. Target is immutable and cannot be updated. Once the binding is updated, the new policy is applied to the target.

      Args:
        request: (IamFoldersLocationsPolicyBindingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/folders/{foldersId}/locations/{locationsId}/policyBindings/{policyBindingsId}',
        http_method='PATCH',
        method_id='iam.folders.locations.policyBindings.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask', 'validateOnly'],
        relative_path='v3beta/{+name}',
        request_field='googleIamV3betaPolicyBinding',
        request_type_name='IamFoldersLocationsPolicyBindingsPatchRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

  class FoldersLocationsService(base_api.BaseApiService):
    """Service class for the folders_locations resource."""

    _NAME = 'folders_locations'

    def __init__(self, client):
      super(IamV3beta.FoldersLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (IamFoldersLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudLocationLocation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/folders/{foldersId}/locations/{locationsId}',
        http_method='GET',
        method_id='iam.folders.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamFoldersLocationsGetRequest',
        response_type_name='GoogleCloudLocationLocation',
        supports_download=False,
    )

    def ListLocations(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (IamFoldersLocationsListLocationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudLocationListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('ListLocations')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListLocations.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/folders/{foldersId}/locations/{locationsId}',
        http_method='GET',
        method_id='iam.folders.locations.listLocations',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamFoldersLocationsListLocationsRequest',
        response_type_name='GoogleCloudLocationListLocationsResponse',
        supports_download=False,
    )

  class FoldersService(base_api.BaseApiService):
    """Service class for the folders resource."""

    _NAME = 'folders'

    def __init__(self, client):
      super(IamV3beta.FoldersService, self).__init__(client)
      self._upload_configs = {
          }

  class OrganizationsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the organizations_locations_operations resource."""

    _NAME = 'organizations_locations_operations'

    def __init__(self, client):
      super(IamV3beta.OrganizationsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (IamOrganizationsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='iam.organizations.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamOrganizationsLocationsOperationsGetRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

  class OrganizationsLocationsPoliciesService(base_api.BaseApiService):
    """Service class for the organizations_locations_policies resource."""

    _NAME = 'organizations_locations_policies'

    def __init__(self, client):
      super(IamV3beta.OrganizationsLocationsPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a policy, and returns a long running operation.

      Args:
        request: (IamOrganizationsLocationsPoliciesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}/policies',
        http_method='POST',
        method_id='iam.organizations.locations.policies.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['policyId', 'validateOnly'],
        relative_path='v3beta/{+parent}/policies',
        request_field='googleIamV3betaPolicy',
        request_type_name='IamOrganizationsLocationsPoliciesCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a policy. Policies with references to policy bindings can't be deleted unless `force` field is set to `true`, or these policy bindings are deleted.

      Args:
        request: (IamOrganizationsLocationsPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}/policies/{policiesId}',
        http_method='DELETE',
        method_id='iam.organizations.locations.policies.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['etag', 'force', 'validateOnly'],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamOrganizationsLocationsPoliciesDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a policy.

      Args:
        request: (IamOrganizationsLocationsPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleIamV3betaPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}/policies/{policiesId}',
        http_method='GET',
        method_id='iam.organizations.locations.policies.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamOrganizationsLocationsPoliciesGetRequest',
        response_type_name='GoogleIamV3betaPolicy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists policies.

      Args:
        request: (IamOrganizationsLocationsPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleIamV3betaListPoliciesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}/policies',
        http_method='GET',
        method_id='iam.organizations.locations.policies.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v3beta/{+parent}/policies',
        request_field='',
        request_type_name='IamOrganizationsLocationsPoliciesListRequest',
        response_type_name='GoogleIamV3betaListPoliciesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a policy.

      Args:
        request: (IamOrganizationsLocationsPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}/policies/{policiesId}',
        http_method='PATCH',
        method_id='iam.organizations.locations.policies.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask', 'validateOnly'],
        relative_path='v3beta/{+name}',
        request_field='googleIamV3betaPolicy',
        request_type_name='IamOrganizationsLocationsPoliciesPatchRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

  class OrganizationsLocationsPolicyBindingsService(base_api.BaseApiService):
    """Service class for the organizations_locations_policyBindings resource."""

    _NAME = 'organizations_locations_policyBindings'

    def __init__(self, client):
      super(IamV3beta.OrganizationsLocationsPolicyBindingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a policy binding and returns a long-running operation. Callers will need the IAM permissions on both the policy and target. Once the binding is created, the policy is applied to the target.

      Args:
        request: (IamOrganizationsLocationsPolicyBindingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}/policyBindings',
        http_method='POST',
        method_id='iam.organizations.locations.policyBindings.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['policyBindingId', 'validateOnly'],
        relative_path='v3beta/{+parent}/policyBindings',
        request_field='googleIamV3betaPolicyBinding',
        request_type_name='IamOrganizationsLocationsPolicyBindingsCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a policy binding. Callers will need the IAM permissions on both the policy and target. Once the binding is deleted, the policy no longer applies to the target.

      Args:
        request: (IamOrganizationsLocationsPolicyBindingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}/policyBindings/{policyBindingsId}',
        http_method='DELETE',
        method_id='iam.organizations.locations.policyBindings.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['etag', 'validateOnly'],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamOrganizationsLocationsPolicyBindingsDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a policy binding.

      Args:
        request: (IamOrganizationsLocationsPolicyBindingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleIamV3betaPolicyBinding) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}/policyBindings/{policyBindingsId}',
        http_method='GET',
        method_id='iam.organizations.locations.policyBindings.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamOrganizationsLocationsPolicyBindingsGetRequest',
        response_type_name='GoogleIamV3betaPolicyBinding',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists policy bindings.

      Args:
        request: (IamOrganizationsLocationsPolicyBindingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleIamV3betaListPolicyBindingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}/policyBindings',
        http_method='GET',
        method_id='iam.organizations.locations.policyBindings.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v3beta/{+parent}/policyBindings',
        request_field='',
        request_type_name='IamOrganizationsLocationsPolicyBindingsListRequest',
        response_type_name='GoogleIamV3betaListPolicyBindingsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a policy binding. Callers will need the IAM permissions on the policy and target in the binding to update, and the IAM permission to remove the existing policy from the binding. Target is immutable and cannot be updated. Once the binding is updated, the new policy is applied to the target.

      Args:
        request: (IamOrganizationsLocationsPolicyBindingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}/policyBindings/{policyBindingsId}',
        http_method='PATCH',
        method_id='iam.organizations.locations.policyBindings.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask', 'validateOnly'],
        relative_path='v3beta/{+name}',
        request_field='googleIamV3betaPolicyBinding',
        request_type_name='IamOrganizationsLocationsPolicyBindingsPatchRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

  class OrganizationsLocationsPrincipalAccessBoundaryPoliciesService(base_api.BaseApiService):
    """Service class for the organizations_locations_principalAccessBoundaryPolicies resource."""

    _NAME = 'organizations_locations_principalAccessBoundaryPolicies'

    def __init__(self, client):
      super(IamV3beta.OrganizationsLocationsPrincipalAccessBoundaryPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a principal access boundary policy, and returns a long running operation.

      Args:
        request: (IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}/principalAccessBoundaryPolicies',
        http_method='POST',
        method_id='iam.organizations.locations.principalAccessBoundaryPolicies.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['principalAccessBoundaryPolicyId', 'validateOnly'],
        relative_path='v3beta/{+parent}/principalAccessBoundaryPolicies',
        request_field='googleIamV3betaPrincipalAccessBoundaryPolicy',
        request_type_name='IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a principal access boundary policy.

      Args:
        request: (IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}/principalAccessBoundaryPolicies/{principalAccessBoundaryPoliciesId}',
        http_method='DELETE',
        method_id='iam.organizations.locations.principalAccessBoundaryPolicies.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['etag', 'force', 'validateOnly'],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a principal access boundary policy.

      Args:
        request: (IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleIamV3betaPrincipalAccessBoundaryPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}/principalAccessBoundaryPolicies/{principalAccessBoundaryPoliciesId}',
        http_method='GET',
        method_id='iam.organizations.locations.principalAccessBoundaryPolicies.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesGetRequest',
        response_type_name='GoogleIamV3betaPrincipalAccessBoundaryPolicy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists principal access boundary policies.

      Args:
        request: (IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleIamV3betaListPrincipalAccessBoundaryPoliciesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}/principalAccessBoundaryPolicies',
        http_method='GET',
        method_id='iam.organizations.locations.principalAccessBoundaryPolicies.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v3beta/{+parent}/principalAccessBoundaryPolicies',
        request_field='',
        request_type_name='IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesListRequest',
        response_type_name='GoogleIamV3betaListPrincipalAccessBoundaryPoliciesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a principal access boundary policy.

      Args:
        request: (IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}/principalAccessBoundaryPolicies/{principalAccessBoundaryPoliciesId}',
        http_method='PATCH',
        method_id='iam.organizations.locations.principalAccessBoundaryPolicies.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask', 'validateOnly'],
        relative_path='v3beta/{+name}',
        request_field='googleIamV3betaPrincipalAccessBoundaryPolicy',
        request_type_name='IamOrganizationsLocationsPrincipalAccessBoundaryPoliciesPatchRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

  class OrganizationsLocationsService(base_api.BaseApiService):
    """Service class for the organizations_locations resource."""

    _NAME = 'organizations_locations'

    def __init__(self, client):
      super(IamV3beta.OrganizationsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (IamOrganizationsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudLocationLocation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}',
        http_method='GET',
        method_id='iam.organizations.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamOrganizationsLocationsGetRequest',
        response_type_name='GoogleCloudLocationLocation',
        supports_download=False,
    )

    def ListLocations(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (IamOrganizationsLocationsListLocationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudLocationListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('ListLocations')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListLocations.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/organizations/{organizationsId}/locations/{locationsId}',
        http_method='GET',
        method_id='iam.organizations.locations.listLocations',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamOrganizationsLocationsListLocationsRequest',
        response_type_name='GoogleCloudLocationListLocationsResponse',
        supports_download=False,
    )

  class OrganizationsService(base_api.BaseApiService):
    """Service class for the organizations resource."""

    _NAME = 'organizations'

    def __init__(self, client):
      super(IamV3beta.OrganizationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(IamV3beta.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (IamProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='iam.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamProjectsLocationsOperationsGetRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

  class ProjectsLocationsPoliciesService(base_api.BaseApiService):
    """Service class for the projects_locations_policies resource."""

    _NAME = 'projects_locations_policies'

    def __init__(self, client):
      super(IamV3beta.ProjectsLocationsPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a policy, and returns a long running operation.

      Args:
        request: (IamProjectsLocationsPoliciesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/projects/{projectsId}/locations/{locationsId}/policies',
        http_method='POST',
        method_id='iam.projects.locations.policies.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['policyId', 'validateOnly'],
        relative_path='v3beta/{+parent}/policies',
        request_field='googleIamV3betaPolicy',
        request_type_name='IamProjectsLocationsPoliciesCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a policy. Policies with references to policy bindings can't be deleted unless `force` field is set to `true`, or these policy bindings are deleted.

      Args:
        request: (IamProjectsLocationsPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/projects/{projectsId}/locations/{locationsId}/policies/{policiesId}',
        http_method='DELETE',
        method_id='iam.projects.locations.policies.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['etag', 'force', 'validateOnly'],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamProjectsLocationsPoliciesDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a policy.

      Args:
        request: (IamProjectsLocationsPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleIamV3betaPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/projects/{projectsId}/locations/{locationsId}/policies/{policiesId}',
        http_method='GET',
        method_id='iam.projects.locations.policies.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamProjectsLocationsPoliciesGetRequest',
        response_type_name='GoogleIamV3betaPolicy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists policies.

      Args:
        request: (IamProjectsLocationsPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleIamV3betaListPoliciesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/projects/{projectsId}/locations/{locationsId}/policies',
        http_method='GET',
        method_id='iam.projects.locations.policies.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v3beta/{+parent}/policies',
        request_field='',
        request_type_name='IamProjectsLocationsPoliciesListRequest',
        response_type_name='GoogleIamV3betaListPoliciesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a policy.

      Args:
        request: (IamProjectsLocationsPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/projects/{projectsId}/locations/{locationsId}/policies/{policiesId}',
        http_method='PATCH',
        method_id='iam.projects.locations.policies.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask', 'validateOnly'],
        relative_path='v3beta/{+name}',
        request_field='googleIamV3betaPolicy',
        request_type_name='IamProjectsLocationsPoliciesPatchRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

  class ProjectsLocationsPolicyBindingsService(base_api.BaseApiService):
    """Service class for the projects_locations_policyBindings resource."""

    _NAME = 'projects_locations_policyBindings'

    def __init__(self, client):
      super(IamV3beta.ProjectsLocationsPolicyBindingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a policy binding and returns a long-running operation. Callers will need the IAM permissions on both the policy and target. Once the binding is created, the policy is applied to the target.

      Args:
        request: (IamProjectsLocationsPolicyBindingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/projects/{projectsId}/locations/{locationsId}/policyBindings',
        http_method='POST',
        method_id='iam.projects.locations.policyBindings.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['policyBindingId', 'validateOnly'],
        relative_path='v3beta/{+parent}/policyBindings',
        request_field='googleIamV3betaPolicyBinding',
        request_type_name='IamProjectsLocationsPolicyBindingsCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a policy binding. Callers will need the IAM permissions on both the policy and target. Once the binding is deleted, the policy no longer applies to the target.

      Args:
        request: (IamProjectsLocationsPolicyBindingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/projects/{projectsId}/locations/{locationsId}/policyBindings/{policyBindingsId}',
        http_method='DELETE',
        method_id='iam.projects.locations.policyBindings.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['etag', 'validateOnly'],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamProjectsLocationsPolicyBindingsDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a policy binding.

      Args:
        request: (IamProjectsLocationsPolicyBindingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleIamV3betaPolicyBinding) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/projects/{projectsId}/locations/{locationsId}/policyBindings/{policyBindingsId}',
        http_method='GET',
        method_id='iam.projects.locations.policyBindings.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3beta/{+name}',
        request_field='',
        request_type_name='IamProjectsLocationsPolicyBindingsGetRequest',
        response_type_name='GoogleIamV3betaPolicyBinding',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists policy bindings.

      Args:
        request: (IamProjectsLocationsPolicyBindingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleIamV3betaListPolicyBindingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/projects/{projectsId}/locations/{locationsId}/policyBindings',
        http_method='GET',
        method_id='iam.projects.locations.policyBindings.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v3beta/{+parent}/policyBindings',
        request_field='',
        request_type_name='IamProjectsLocationsPolicyBindingsListRequest',
        response_type_name='GoogleIamV3betaListPolicyBindingsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a policy binding. Callers will need the IAM permissions on the policy and target in the binding to update, and the IAM permission to remove the existing policy from the binding. Target is immutable and cannot be updated. Once the binding is updated, the new policy is applied to the target.

      Args:
        request: (IamProjectsLocationsPolicyBindingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/projects/{projectsId}/locations/{locationsId}/policyBindings/{policyBindingsId}',
        http_method='PATCH',
        method_id='iam.projects.locations.policyBindings.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask', 'validateOnly'],
        relative_path='v3beta/{+name}',
        request_field='googleIamV3betaPolicyBinding',
        request_type_name='IamProjectsLocationsPolicyBindingsPatchRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(IamV3beta.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (IamProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudLocationListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/projects/{projectsId}/locations',
        http_method='GET',
        method_id='iam.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v3beta/{+name}/locations',
        request_field='',
        request_type_name='IamProjectsLocationsListRequest',
        response_type_name='GoogleCloudLocationListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(IamV3beta.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetLocations(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (IamProjectsGetLocationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudLocationLocation) The response message.
      """
      config = self.GetMethodConfig('GetLocations')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetLocations.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v3beta/projects/{projectsId}/locations',
        http_method='GET',
        method_id='iam.projects.getLocations',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v3beta/{+name}/locations',
        request_field='',
        request_type_name='IamProjectsGetLocationsRequest',
        response_type_name='GoogleCloudLocationLocation',
        supports_download=False,
    )
