"""Generated client library for apphub version v1alpha."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.apphub.v1alpha import apphub_v1alpha_messages as messages


class ApphubV1alpha(base_api.BaseApiClient):
  """Generated client library for service apphub version v1alpha."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://apphub.googleapis.com/'
  MTLS_BASE_URL = 'https://apphub.mtls.googleapis.com/'

  _PACKAGE = 'apphub'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1alpha'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'ApphubV1alpha'
  _URL_VERSION = 'v1alpha'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new apphub handle."""
    url = url or self.BASE_URL
    super(ApphubV1alpha, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_global_telemetry = self.ProjectsLocationsGlobalTelemetryService(self)
    self.projects_locations_global_topology = self.ProjectsLocationsGlobalTopologyService(self)
    self.projects_locations_global = self.ProjectsLocationsGlobalService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsGlobalTelemetryService(base_api.BaseApiService):
    """Service class for the projects_locations_global_telemetry resource."""

    _NAME = 'projects_locations_global_telemetry'

    def __init__(self, client):
      super(ApphubV1alpha.ProjectsLocationsGlobalTelemetryService, self).__init__(client)
      self._upload_configs = {
          }

    def Disable(self, request, global_params=None):
      r"""DisableTelemetry disables telemetry configuration.

      Args:
        request: (ApphubProjectsLocationsGlobalTelemetryDisableRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Telemetry) The response message.
      """
      config = self.GetMethodConfig('Disable')
      return self._RunMethod(
          config, request, global_params=global_params)

    Disable.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/global/telemetry:disable',
        http_method='POST',
        method_id='apphub.projects.locations.global.telemetry.disable',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:disable',
        request_field='disableTelemetryRequest',
        request_type_name='ApphubProjectsLocationsGlobalTelemetryDisableRequest',
        response_type_name='Telemetry',
        supports_download=False,
    )

    def Enable(self, request, global_params=None):
      r"""EnableTelemetry enables telemetry configuration.

      Args:
        request: (ApphubProjectsLocationsGlobalTelemetryEnableRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Telemetry) The response message.
      """
      config = self.GetMethodConfig('Enable')
      return self._RunMethod(
          config, request, global_params=global_params)

    Enable.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/global/telemetry:enable',
        http_method='POST',
        method_id='apphub.projects.locations.global.telemetry.enable',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:enable',
        request_field='enableTelemetryRequest',
        request_type_name='ApphubProjectsLocationsGlobalTelemetryEnableRequest',
        response_type_name='Telemetry',
        supports_download=False,
    )

  class ProjectsLocationsGlobalTopologyService(base_api.BaseApiService):
    """Service class for the projects_locations_global_topology resource."""

    _NAME = 'projects_locations_global_topology'

    def __init__(self, client):
      super(ApphubV1alpha.ProjectsLocationsGlobalTopologyService, self).__init__(client)
      self._upload_configs = {
          }

    def Disable(self, request, global_params=None):
      r"""DisableTopology disables topology configuration.

      Args:
        request: (ApphubProjectsLocationsGlobalTopologyDisableRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Topology) The response message.
      """
      config = self.GetMethodConfig('Disable')
      return self._RunMethod(
          config, request, global_params=global_params)

    Disable.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/global/topology:disable',
        http_method='POST',
        method_id='apphub.projects.locations.global.topology.disable',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:disable',
        request_field='disableTopologyRequest',
        request_type_name='ApphubProjectsLocationsGlobalTopologyDisableRequest',
        response_type_name='Topology',
        supports_download=False,
    )

    def Enable(self, request, global_params=None):
      r"""EnableTopology enables topology configuration.

      Args:
        request: (ApphubProjectsLocationsGlobalTopologyEnableRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Topology) The response message.
      """
      config = self.GetMethodConfig('Enable')
      return self._RunMethod(
          config, request, global_params=global_params)

    Enable.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/global/topology:enable',
        http_method='POST',
        method_id='apphub.projects.locations.global.topology.enable',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:enable',
        request_field='enableTopologyRequest',
        request_type_name='ApphubProjectsLocationsGlobalTopologyEnableRequest',
        response_type_name='Topology',
        supports_download=False,
    )

  class ProjectsLocationsGlobalService(base_api.BaseApiService):
    """Service class for the projects_locations_global resource."""

    _NAME = 'projects_locations_global'

    def __init__(self, client):
      super(ApphubV1alpha.ProjectsLocationsGlobalService, self).__init__(client)
      self._upload_configs = {
          }

    def Telemetry(self, request, global_params=None):
      r"""DescribeTelemetry describes current Telemetry configuration.

      Args:
        request: (ApphubProjectsLocationsGlobalTelemetryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Telemetry) The response message.
      """
      config = self.GetMethodConfig('Telemetry')
      return self._RunMethod(
          config, request, global_params=global_params)

    Telemetry.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/global/telemetry',
        http_method='GET',
        method_id='apphub.projects.locations.global.telemetry',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='ApphubProjectsLocationsGlobalTelemetryRequest',
        response_type_name='Telemetry',
        supports_download=False,
    )

    def Topology(self, request, global_params=None):
      r"""DescribeTopology describes current Topology configuration.

      Args:
        request: (ApphubProjectsLocationsGlobalTopologyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Topology) The response message.
      """
      config = self.GetMethodConfig('Topology')
      return self._RunMethod(
          config, request, global_params=global_params)

    Topology.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/global/topology',
        http_method='GET',
        method_id='apphub.projects.locations.global.topology',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='ApphubProjectsLocationsGlobalTopologyRequest',
        response_type_name='Topology',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(ApphubV1alpha.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.

      Args:
        request: (ApphubProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='apphub.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='ApphubProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (ApphubProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='apphub.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='ApphubProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (ApphubProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='apphub.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='ApphubProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (ApphubProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='apphub.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+name}/operations',
        request_field='',
        request_type_name='ApphubProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(ApphubV1alpha.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (ApphubProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='apphub.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='ApphubProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (ApphubProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations',
        http_method='GET',
        method_id='apphub.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+name}/locations',
        request_field='',
        request_type_name='ApphubProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(ApphubV1alpha.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
