"""Generated client library for telecomdatafabric version v1alpha."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.telecomdatafabric.v1alpha import telecomdatafabric_v1alpha_messages as messages


class TelecomdatafabricV1alpha(base_api.BaseApiClient):
  """Generated client library for service telecomdatafabric version v1alpha."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://telecomdatafabric.googleapis.com/'
  MTLS_BASE_URL = 'https://telecomdatafabric.mtls.googleapis.com/'

  _PACKAGE = 'telecomdatafabric'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1alpha'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'TelecomdatafabricV1alpha'
  _URL_VERSION = 'v1alpha'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new telecomdatafabric handle."""
    url = url or self.BASE_URL
    super(TelecomdatafabricV1alpha, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_batchIngestionPipelines = self.ProjectsLocationsBatchIngestionPipelinesService(self)
    self.projects_locations_dataAdapters = self.ProjectsLocationsDataAdaptersService(self)
    self.projects_locations_dataApiServers = self.ProjectsLocationsDataApiServersService(self)
    self.projects_locations_dataAssetManagers = self.ProjectsLocationsDataAssetManagersService(self)
    self.projects_locations_dataAssets = self.ProjectsLocationsDataAssetsService(self)
    self.projects_locations_deployments = self.ProjectsLocationsDeploymentsService(self)
    self.projects_locations_iaasMetricsCollectors = self.ProjectsLocationsIaasMetricsCollectorsService(self)
    self.projects_locations_metricsCorrelations = self.ProjectsLocationsMetricsCorrelationsService(self)
    self.projects_locations_metricsIngestionPipelines = self.ProjectsLocationsMetricsIngestionPipelinesService(self)
    self.projects_locations_metricsProcessors = self.ProjectsLocationsMetricsProcessorsService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_pipelineSchedulers = self.ProjectsLocationsPipelineSchedulersService(self)
    self.projects_locations_publicTemplates = self.ProjectsLocationsPublicTemplatesService(self)
    self.projects_locations_streamIngestionPipelines = self.ProjectsLocationsStreamIngestionPipelinesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsBatchIngestionPipelinesService(base_api.BaseApiService):
    """Service class for the projects_locations_batchIngestionPipelines resource."""

    _NAME = 'projects_locations_batchIngestionPipelines'

    def __init__(self, client):
      super(TelecomdatafabricV1alpha.ProjectsLocationsBatchIngestionPipelinesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new BatchIngestionPipeline in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsBatchIngestionPipelinesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/batchIngestionPipelines',
        http_method='POST',
        method_id='telecomdatafabric.projects.locations.batchIngestionPipelines.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['batchIngestionPipelineId', 'requestId'],
        relative_path='v1alpha/{+parent}/batchIngestionPipelines',
        request_field='batchIngestionPipeline',
        request_type_name='TelecomdatafabricProjectsLocationsBatchIngestionPipelinesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single BatchIngestionPipeline.

      Args:
        request: (TelecomdatafabricProjectsLocationsBatchIngestionPipelinesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/batchIngestionPipelines/{batchIngestionPipelinesId}',
        http_method='DELETE',
        method_id='telecomdatafabric.projects.locations.batchIngestionPipelines.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsBatchIngestionPipelinesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single BatchIngestionPipeline.

      Args:
        request: (TelecomdatafabricProjectsLocationsBatchIngestionPipelinesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BatchIngestionPipeline) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/batchIngestionPipelines/{batchIngestionPipelinesId}',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.batchIngestionPipelines.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsBatchIngestionPipelinesGetRequest',
        response_type_name='BatchIngestionPipeline',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists BatchIngestionPipelines in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsBatchIngestionPipelinesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListBatchIngestionPipelinesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/batchIngestionPipelines',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.batchIngestionPipelines.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/batchIngestionPipelines',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsBatchIngestionPipelinesListRequest',
        response_type_name='ListBatchIngestionPipelinesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single BatchIngestionPipeline.

      Args:
        request: (TelecomdatafabricProjectsLocationsBatchIngestionPipelinesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/batchIngestionPipelines/{batchIngestionPipelinesId}',
        http_method='PATCH',
        method_id='telecomdatafabric.projects.locations.batchIngestionPipelines.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='batchIngestionPipeline',
        request_type_name='TelecomdatafabricProjectsLocationsBatchIngestionPipelinesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsDataAdaptersService(base_api.BaseApiService):
    """Service class for the projects_locations_dataAdapters resource."""

    _NAME = 'projects_locations_dataAdapters'

    def __init__(self, client):
      super(TelecomdatafabricV1alpha.ProjectsLocationsDataAdaptersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new DataAdapter in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataAdaptersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataAdapters',
        http_method='POST',
        method_id='telecomdatafabric.projects.locations.dataAdapters.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['dataAdapterId', 'requestId'],
        relative_path='v1alpha/{+parent}/dataAdapters',
        request_field='dataAdapter',
        request_type_name='TelecomdatafabricProjectsLocationsDataAdaptersCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single DataAdapter.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataAdaptersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataAdapters/{dataAdaptersId}',
        http_method='DELETE',
        method_id='telecomdatafabric.projects.locations.dataAdapters.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsDataAdaptersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single DataAdapter.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataAdaptersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DataAdapter) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataAdapters/{dataAdaptersId}',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.dataAdapters.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsDataAdaptersGetRequest',
        response_type_name='DataAdapter',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists DataAdapters in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataAdaptersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDataAdaptersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataAdapters',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.dataAdapters.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/dataAdapters',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsDataAdaptersListRequest',
        response_type_name='ListDataAdaptersResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single DataAdapter.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataAdaptersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataAdapters/{dataAdaptersId}',
        http_method='PATCH',
        method_id='telecomdatafabric.projects.locations.dataAdapters.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='dataAdapter',
        request_type_name='TelecomdatafabricProjectsLocationsDataAdaptersPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsDataApiServersService(base_api.BaseApiService):
    """Service class for the projects_locations_dataApiServers resource."""

    _NAME = 'projects_locations_dataApiServers'

    def __init__(self, client):
      super(TelecomdatafabricV1alpha.ProjectsLocationsDataApiServersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new DataApiServer in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataApiServersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataApiServers',
        http_method='POST',
        method_id='telecomdatafabric.projects.locations.dataApiServers.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['dataApiServerId', 'requestId'],
        relative_path='v1alpha/{+parent}/dataApiServers',
        request_field='dataApiServer',
        request_type_name='TelecomdatafabricProjectsLocationsDataApiServersCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single DataApiServer.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataApiServersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataApiServers/{dataApiServersId}',
        http_method='DELETE',
        method_id='telecomdatafabric.projects.locations.dataApiServers.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsDataApiServersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single DataApiServer.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataApiServersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DataApiServer) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataApiServers/{dataApiServersId}',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.dataApiServers.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsDataApiServersGetRequest',
        response_type_name='DataApiServer',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists DataApiServers in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataApiServersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDataApiServersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataApiServers',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.dataApiServers.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/dataApiServers',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsDataApiServersListRequest',
        response_type_name='ListDataApiServersResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single DataApiServer.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataApiServersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataApiServers/{dataApiServersId}',
        http_method='PATCH',
        method_id='telecomdatafabric.projects.locations.dataApiServers.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='dataApiServer',
        request_type_name='TelecomdatafabricProjectsLocationsDataApiServersPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsDataAssetManagersService(base_api.BaseApiService):
    """Service class for the projects_locations_dataAssetManagers resource."""

    _NAME = 'projects_locations_dataAssetManagers'

    def __init__(self, client):
      super(TelecomdatafabricV1alpha.ProjectsLocationsDataAssetManagersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new DataAssetManager in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataAssetManagersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataAssetManagers',
        http_method='POST',
        method_id='telecomdatafabric.projects.locations.dataAssetManagers.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['dataAssetManagerId', 'requestId'],
        relative_path='v1alpha/{+parent}/dataAssetManagers',
        request_field='dataAssetManager',
        request_type_name='TelecomdatafabricProjectsLocationsDataAssetManagersCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single DataAssetManager.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataAssetManagersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataAssetManagers/{dataAssetManagersId}',
        http_method='DELETE',
        method_id='telecomdatafabric.projects.locations.dataAssetManagers.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsDataAssetManagersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single DataAssetManager.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataAssetManagersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DataAssetManager) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataAssetManagers/{dataAssetManagersId}',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.dataAssetManagers.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsDataAssetManagersGetRequest',
        response_type_name='DataAssetManager',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists DataAssetManagers in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataAssetManagersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDataAssetManagersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataAssetManagers',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.dataAssetManagers.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/dataAssetManagers',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsDataAssetManagersListRequest',
        response_type_name='ListDataAssetManagersResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single DataAssetManager.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataAssetManagersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataAssetManagers/{dataAssetManagersId}',
        http_method='PATCH',
        method_id='telecomdatafabric.projects.locations.dataAssetManagers.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='dataAssetManager',
        request_type_name='TelecomdatafabricProjectsLocationsDataAssetManagersPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsDataAssetsService(base_api.BaseApiService):
    """Service class for the projects_locations_dataAssets resource."""

    _NAME = 'projects_locations_dataAssets'

    def __init__(self, client):
      super(TelecomdatafabricV1alpha.ProjectsLocationsDataAssetsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new DataAsset in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataAssetsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataAssets',
        http_method='POST',
        method_id='telecomdatafabric.projects.locations.dataAssets.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['dataAssetId', 'requestId'],
        relative_path='v1alpha/{+parent}/dataAssets',
        request_field='dataAsset',
        request_type_name='TelecomdatafabricProjectsLocationsDataAssetsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single DataAsset.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataAssetsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataAssets/{dataAssetsId}',
        http_method='DELETE',
        method_id='telecomdatafabric.projects.locations.dataAssets.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsDataAssetsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single DataAsset.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataAssetsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DataAsset) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataAssets/{dataAssetsId}',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.dataAssets.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsDataAssetsGetRequest',
        response_type_name='DataAsset',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists DataAssets in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataAssetsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDataAssetsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataAssets',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.dataAssets.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/dataAssets',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsDataAssetsListRequest',
        response_type_name='ListDataAssetsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single DataAsset.

      Args:
        request: (TelecomdatafabricProjectsLocationsDataAssetsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/dataAssets/{dataAssetsId}',
        http_method='PATCH',
        method_id='telecomdatafabric.projects.locations.dataAssets.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='dataAsset',
        request_type_name='TelecomdatafabricProjectsLocationsDataAssetsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsDeploymentsService(base_api.BaseApiService):
    """Service class for the projects_locations_deployments resource."""

    _NAME = 'projects_locations_deployments'

    def __init__(self, client):
      super(TelecomdatafabricV1alpha.ProjectsLocationsDeploymentsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Deployment in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsDeploymentsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/deployments',
        http_method='POST',
        method_id='telecomdatafabric.projects.locations.deployments.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['deploymentId', 'requestId'],
        relative_path='v1alpha/{+parent}/deployments',
        request_field='deployment',
        request_type_name='TelecomdatafabricProjectsLocationsDeploymentsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Deployment.

      Args:
        request: (TelecomdatafabricProjectsLocationsDeploymentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/deployments/{deploymentsId}',
        http_method='DELETE',
        method_id='telecomdatafabric.projects.locations.deployments.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsDeploymentsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Deployment.

      Args:
        request: (TelecomdatafabricProjectsLocationsDeploymentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Deployment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/deployments/{deploymentsId}',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.deployments.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsDeploymentsGetRequest',
        response_type_name='Deployment',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Deployments in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsDeploymentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDeploymentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/deployments',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.deployments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/deployments',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsDeploymentsListRequest',
        response_type_name='ListDeploymentsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single Deployment.

      Args:
        request: (TelecomdatafabricProjectsLocationsDeploymentsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/deployments/{deploymentsId}',
        http_method='PATCH',
        method_id='telecomdatafabric.projects.locations.deployments.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='deployment',
        request_type_name='TelecomdatafabricProjectsLocationsDeploymentsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsIaasMetricsCollectorsService(base_api.BaseApiService):
    """Service class for the projects_locations_iaasMetricsCollectors resource."""

    _NAME = 'projects_locations_iaasMetricsCollectors'

    def __init__(self, client):
      super(TelecomdatafabricV1alpha.ProjectsLocationsIaasMetricsCollectorsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new IaasMetricsCollector in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsIaasMetricsCollectorsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/iaasMetricsCollectors',
        http_method='POST',
        method_id='telecomdatafabric.projects.locations.iaasMetricsCollectors.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['iaasMetricsCollectorId', 'requestId'],
        relative_path='v1alpha/{+parent}/iaasMetricsCollectors',
        request_field='iaasMetricsCollector',
        request_type_name='TelecomdatafabricProjectsLocationsIaasMetricsCollectorsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single IaasMetricsCollector.

      Args:
        request: (TelecomdatafabricProjectsLocationsIaasMetricsCollectorsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/iaasMetricsCollectors/{iaasMetricsCollectorsId}',
        http_method='DELETE',
        method_id='telecomdatafabric.projects.locations.iaasMetricsCollectors.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsIaasMetricsCollectorsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single IaasMetricsCollector.

      Args:
        request: (TelecomdatafabricProjectsLocationsIaasMetricsCollectorsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (IaasMetricsCollector) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/iaasMetricsCollectors/{iaasMetricsCollectorsId}',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.iaasMetricsCollectors.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsIaasMetricsCollectorsGetRequest',
        response_type_name='IaasMetricsCollector',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists IaasMetricsCollectors in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsIaasMetricsCollectorsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListIaasMetricsCollectorsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/iaasMetricsCollectors',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.iaasMetricsCollectors.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/iaasMetricsCollectors',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsIaasMetricsCollectorsListRequest',
        response_type_name='ListIaasMetricsCollectorsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single IaasMetricsCollector.

      Args:
        request: (TelecomdatafabricProjectsLocationsIaasMetricsCollectorsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/iaasMetricsCollectors/{iaasMetricsCollectorsId}',
        http_method='PATCH',
        method_id='telecomdatafabric.projects.locations.iaasMetricsCollectors.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='iaasMetricsCollector',
        request_type_name='TelecomdatafabricProjectsLocationsIaasMetricsCollectorsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsMetricsCorrelationsService(base_api.BaseApiService):
    """Service class for the projects_locations_metricsCorrelations resource."""

    _NAME = 'projects_locations_metricsCorrelations'

    def __init__(self, client):
      super(TelecomdatafabricV1alpha.ProjectsLocationsMetricsCorrelationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new MetricsCorrelation in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsMetricsCorrelationsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/metricsCorrelations',
        http_method='POST',
        method_id='telecomdatafabric.projects.locations.metricsCorrelations.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['metricsCorrelationId', 'requestId'],
        relative_path='v1alpha/{+parent}/metricsCorrelations',
        request_field='metricsCorrelation',
        request_type_name='TelecomdatafabricProjectsLocationsMetricsCorrelationsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single MetricsCorrelation.

      Args:
        request: (TelecomdatafabricProjectsLocationsMetricsCorrelationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/metricsCorrelations/{metricsCorrelationsId}',
        http_method='DELETE',
        method_id='telecomdatafabric.projects.locations.metricsCorrelations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsMetricsCorrelationsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single MetricsCorrelation.

      Args:
        request: (TelecomdatafabricProjectsLocationsMetricsCorrelationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MetricsCorrelation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/metricsCorrelations/{metricsCorrelationsId}',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.metricsCorrelations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsMetricsCorrelationsGetRequest',
        response_type_name='MetricsCorrelation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists MetricsCorrelations in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsMetricsCorrelationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMetricsCorrelationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/metricsCorrelations',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.metricsCorrelations.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/metricsCorrelations',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsMetricsCorrelationsListRequest',
        response_type_name='ListMetricsCorrelationsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single MetricsCorrelation.

      Args:
        request: (TelecomdatafabricProjectsLocationsMetricsCorrelationsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/metricsCorrelations/{metricsCorrelationsId}',
        http_method='PATCH',
        method_id='telecomdatafabric.projects.locations.metricsCorrelations.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='metricsCorrelation',
        request_type_name='TelecomdatafabricProjectsLocationsMetricsCorrelationsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsMetricsIngestionPipelinesService(base_api.BaseApiService):
    """Service class for the projects_locations_metricsIngestionPipelines resource."""

    _NAME = 'projects_locations_metricsIngestionPipelines'

    def __init__(self, client):
      super(TelecomdatafabricV1alpha.ProjectsLocationsMetricsIngestionPipelinesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new MetricsIngestionPipeline in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/metricsIngestionPipelines',
        http_method='POST',
        method_id='telecomdatafabric.projects.locations.metricsIngestionPipelines.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['metricsIngestionPipelineId', 'requestId'],
        relative_path='v1alpha/{+parent}/metricsIngestionPipelines',
        request_field='metricsIngestionPipeline',
        request_type_name='TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single MetricsIngestionPipeline.

      Args:
        request: (TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/metricsIngestionPipelines/{metricsIngestionPipelinesId}',
        http_method='DELETE',
        method_id='telecomdatafabric.projects.locations.metricsIngestionPipelines.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single MetricsIngestionPipeline.

      Args:
        request: (TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MetricsIngestionPipeline) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/metricsIngestionPipelines/{metricsIngestionPipelinesId}',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.metricsIngestionPipelines.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesGetRequest',
        response_type_name='MetricsIngestionPipeline',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists MetricsIngestionPipelines in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMetricsIngestionPipelinesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/metricsIngestionPipelines',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.metricsIngestionPipelines.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/metricsIngestionPipelines',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesListRequest',
        response_type_name='ListMetricsIngestionPipelinesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single MetricsIngestionPipeline.

      Args:
        request: (TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/metricsIngestionPipelines/{metricsIngestionPipelinesId}',
        http_method='PATCH',
        method_id='telecomdatafabric.projects.locations.metricsIngestionPipelines.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='metricsIngestionPipeline',
        request_type_name='TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsMetricsProcessorsService(base_api.BaseApiService):
    """Service class for the projects_locations_metricsProcessors resource."""

    _NAME = 'projects_locations_metricsProcessors'

    def __init__(self, client):
      super(TelecomdatafabricV1alpha.ProjectsLocationsMetricsProcessorsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new MetricsProcessor in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsMetricsProcessorsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/metricsProcessors',
        http_method='POST',
        method_id='telecomdatafabric.projects.locations.metricsProcessors.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['metricsProcessorId', 'requestId'],
        relative_path='v1alpha/{+parent}/metricsProcessors',
        request_field='metricsProcessor',
        request_type_name='TelecomdatafabricProjectsLocationsMetricsProcessorsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single MetricsProcessor.

      Args:
        request: (TelecomdatafabricProjectsLocationsMetricsProcessorsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/metricsProcessors/{metricsProcessorsId}',
        http_method='DELETE',
        method_id='telecomdatafabric.projects.locations.metricsProcessors.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsMetricsProcessorsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single MetricsProcessor.

      Args:
        request: (TelecomdatafabricProjectsLocationsMetricsProcessorsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MetricsProcessor) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/metricsProcessors/{metricsProcessorsId}',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.metricsProcessors.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsMetricsProcessorsGetRequest',
        response_type_name='MetricsProcessor',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists MetricsProcessors in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsMetricsProcessorsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMetricsProcessorsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/metricsProcessors',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.metricsProcessors.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/metricsProcessors',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsMetricsProcessorsListRequest',
        response_type_name='ListMetricsProcessorsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single MetricsProcessor.

      Args:
        request: (TelecomdatafabricProjectsLocationsMetricsProcessorsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/metricsProcessors/{metricsProcessorsId}',
        http_method='PATCH',
        method_id='telecomdatafabric.projects.locations.metricsProcessors.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='metricsProcessor',
        request_type_name='TelecomdatafabricProjectsLocationsMetricsProcessorsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(TelecomdatafabricV1alpha.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.

      Args:
        request: (TelecomdatafabricProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='telecomdatafabric.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='TelecomdatafabricProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (TelecomdatafabricProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='telecomdatafabric.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (TelecomdatafabricProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (TelecomdatafabricProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+name}/operations',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsPipelineSchedulersService(base_api.BaseApiService):
    """Service class for the projects_locations_pipelineSchedulers resource."""

    _NAME = 'projects_locations_pipelineSchedulers'

    def __init__(self, client):
      super(TelecomdatafabricV1alpha.ProjectsLocationsPipelineSchedulersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new PipelineScheduler in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsPipelineSchedulersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/pipelineSchedulers',
        http_method='POST',
        method_id='telecomdatafabric.projects.locations.pipelineSchedulers.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pipelineSchedulerId', 'requestId'],
        relative_path='v1alpha/{+parent}/pipelineSchedulers',
        request_field='pipelineScheduler',
        request_type_name='TelecomdatafabricProjectsLocationsPipelineSchedulersCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single PipelineScheduler.

      Args:
        request: (TelecomdatafabricProjectsLocationsPipelineSchedulersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/pipelineSchedulers/{pipelineSchedulersId}',
        http_method='DELETE',
        method_id='telecomdatafabric.projects.locations.pipelineSchedulers.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsPipelineSchedulersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single PipelineScheduler.

      Args:
        request: (TelecomdatafabricProjectsLocationsPipelineSchedulersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PipelineScheduler) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/pipelineSchedulers/{pipelineSchedulersId}',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.pipelineSchedulers.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsPipelineSchedulersGetRequest',
        response_type_name='PipelineScheduler',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists PipelineSchedulers in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsPipelineSchedulersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListPipelineSchedulersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/pipelineSchedulers',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.pipelineSchedulers.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/pipelineSchedulers',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsPipelineSchedulersListRequest',
        response_type_name='ListPipelineSchedulersResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single PipelineScheduler.

      Args:
        request: (TelecomdatafabricProjectsLocationsPipelineSchedulersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/pipelineSchedulers/{pipelineSchedulersId}',
        http_method='PATCH',
        method_id='telecomdatafabric.projects.locations.pipelineSchedulers.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='pipelineScheduler',
        request_type_name='TelecomdatafabricProjectsLocationsPipelineSchedulersPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsPublicTemplatesService(base_api.BaseApiService):
    """Service class for the projects_locations_publicTemplates resource."""

    _NAME = 'projects_locations_publicTemplates'

    def __init__(self, client):
      super(TelecomdatafabricV1alpha.ProjectsLocationsPublicTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets details of a single PublicTemplate.

      Args:
        request: (TelecomdatafabricProjectsLocationsPublicTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PublicTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/publicTemplates/{publicTemplatesId}',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.publicTemplates.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsPublicTemplatesGetRequest',
        response_type_name='PublicTemplate',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists PublicTemplates in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsPublicTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListPublicTemplatesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/publicTemplates',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.publicTemplates.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/publicTemplates',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsPublicTemplatesListRequest',
        response_type_name='ListPublicTemplatesResponse',
        supports_download=False,
    )

  class ProjectsLocationsStreamIngestionPipelinesService(base_api.BaseApiService):
    """Service class for the projects_locations_streamIngestionPipelines resource."""

    _NAME = 'projects_locations_streamIngestionPipelines'

    def __init__(self, client):
      super(TelecomdatafabricV1alpha.ProjectsLocationsStreamIngestionPipelinesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new StreamIngestionPipeline in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsStreamIngestionPipelinesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/streamIngestionPipelines',
        http_method='POST',
        method_id='telecomdatafabric.projects.locations.streamIngestionPipelines.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['requestId', 'streamIngestionPipelineId'],
        relative_path='v1alpha/{+parent}/streamIngestionPipelines',
        request_field='streamIngestionPipeline',
        request_type_name='TelecomdatafabricProjectsLocationsStreamIngestionPipelinesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single StreamIngestionPipeline.

      Args:
        request: (TelecomdatafabricProjectsLocationsStreamIngestionPipelinesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/streamIngestionPipelines/{streamIngestionPipelinesId}',
        http_method='DELETE',
        method_id='telecomdatafabric.projects.locations.streamIngestionPipelines.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsStreamIngestionPipelinesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single StreamIngestionPipeline.

      Args:
        request: (TelecomdatafabricProjectsLocationsStreamIngestionPipelinesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (StreamIngestionPipeline) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/streamIngestionPipelines/{streamIngestionPipelinesId}',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.streamIngestionPipelines.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsStreamIngestionPipelinesGetRequest',
        response_type_name='StreamIngestionPipeline',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists StreamIngestionPipelines in a given project and location.

      Args:
        request: (TelecomdatafabricProjectsLocationsStreamIngestionPipelinesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListStreamIngestionPipelinesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/streamIngestionPipelines',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.streamIngestionPipelines.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/streamIngestionPipelines',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsStreamIngestionPipelinesListRequest',
        response_type_name='ListStreamIngestionPipelinesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single StreamIngestionPipeline.

      Args:
        request: (TelecomdatafabricProjectsLocationsStreamIngestionPipelinesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/streamIngestionPipelines/{streamIngestionPipelinesId}',
        http_method='PATCH',
        method_id='telecomdatafabric.projects.locations.streamIngestionPipelines.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='streamIngestionPipeline',
        request_type_name='TelecomdatafabricProjectsLocationsStreamIngestionPipelinesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(TelecomdatafabricV1alpha.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (TelecomdatafabricProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (TelecomdatafabricProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations',
        http_method='GET',
        method_id='telecomdatafabric.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+name}/locations',
        request_field='',
        request_type_name='TelecomdatafabricProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(TelecomdatafabricV1alpha.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
