"""Generated client library for spanner version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.spanner.v1 import spanner_v1_messages as messages


class SpannerV1(base_api.BaseApiClient):
  """Generated client library for service spanner version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://spanner.googleapis.com/'
  MTLS_BASE_URL = 'https://spanner.mtls.googleapis.com/'

  _PACKAGE = 'spanner'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform', 'https://www.googleapis.com/auth/spanner.admin', 'https://www.googleapis.com/auth/spanner.data']
  _VERSION = 'v1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'SpannerV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new spanner handle."""
    url = url or self.BASE_URL
    super(SpannerV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_instanceConfigOperations = self.ProjectsInstanceConfigOperationsService(self)
    self.projects_instanceConfigs_operations = self.ProjectsInstanceConfigsOperationsService(self)
    self.projects_instanceConfigs = self.ProjectsInstanceConfigsService(self)
    self.projects_instances_backupOperations = self.ProjectsInstancesBackupOperationsService(self)
    self.projects_instances_backups_operations = self.ProjectsInstancesBackupsOperationsService(self)
    self.projects_instances_backups = self.ProjectsInstancesBackupsService(self)
    self.projects_instances_databaseOperations = self.ProjectsInstancesDatabaseOperationsService(self)
    self.projects_instances_databases_databaseRoles = self.ProjectsInstancesDatabasesDatabaseRolesService(self)
    self.projects_instances_databases_operations = self.ProjectsInstancesDatabasesOperationsService(self)
    self.projects_instances_databases_sessions = self.ProjectsInstancesDatabasesSessionsService(self)
    self.projects_instances_databases = self.ProjectsInstancesDatabasesService(self)
    self.projects_instances_instancePartitions_operations = self.ProjectsInstancesInstancePartitionsOperationsService(self)
    self.projects_instances_instancePartitions = self.ProjectsInstancesInstancePartitionsService(self)
    self.projects_instances_operations = self.ProjectsInstancesOperationsService(self)
    self.projects_instances = self.ProjectsInstancesService(self)
    self.projects = self.ProjectsService(self)
    self.scans = self.ScansService(self)

  class ProjectsInstanceConfigOperationsService(base_api.BaseApiService):
    """Service class for the projects_instanceConfigOperations resource."""

    _NAME = 'projects_instanceConfigOperations'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstanceConfigOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists the user-managed instance config long-running operations in the given project. An instance config operation has a name of the form `projects//instanceConfigs//operations/`. The long-running operation metadata field type `metadata.type_url` describes the type of the metadata. Operations returned include those that have completed/failed/canceled within the last 7 days, and pending operations. Operations returned are ordered by `operation.metadata.value.start_time` in descending order starting from the most recently started operation.

      Args:
        request: (SpannerProjectsInstanceConfigOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListInstanceConfigOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instanceConfigOperations',
        http_method='GET',
        method_id='spanner.projects.instanceConfigOperations.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/instanceConfigOperations',
        request_field='',
        request_type_name='SpannerProjectsInstanceConfigOperationsListRequest',
        response_type_name='ListInstanceConfigOperationsResponse',
        supports_download=False,
    )

  class ProjectsInstanceConfigsOperationsService(base_api.BaseApiService):
    """Service class for the projects_instanceConfigs_operations resource."""

    _NAME = 'projects_instanceConfigs_operations'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstanceConfigsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.

      Args:
        request: (SpannerProjectsInstanceConfigsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instanceConfigs/{instanceConfigsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='spanner.projects.instanceConfigs.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:cancel',
        request_field='',
        request_type_name='SpannerProjectsInstanceConfigsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (SpannerProjectsInstanceConfigsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instanceConfigs/{instanceConfigsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='spanner.projects.instanceConfigs.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstanceConfigsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (SpannerProjectsInstanceConfigsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instanceConfigs/{instanceConfigsId}/operations/{operationsId}',
        http_method='GET',
        method_id='spanner.projects.instanceConfigs.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstanceConfigsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (SpannerProjectsInstanceConfigsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instanceConfigs/{instanceConfigsId}/operations',
        http_method='GET',
        method_id='spanner.projects.instanceConfigs.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstanceConfigsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsInstanceConfigsService(base_api.BaseApiService):
    """Service class for the projects_instanceConfigs resource."""

    _NAME = 'projects_instanceConfigs'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstanceConfigsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an instance config and begins preparing it to be used. The returned long-running operation can be used to track the progress of preparing the new instance config. The instance config name is assigned by the caller. If the named instance config already exists, `CreateInstanceConfig` returns `ALREADY_EXISTS`. Immediately after the request returns: * The instance config is readable via the API, with all requested attributes. The instance config's reconciling field is set to true. Its state is `CREATING`. While the operation is pending: * Cancelling the operation renders the instance config immediately unreadable via the API. * Except for deleting the creating resource, all other attempts to modify the instance config are rejected. Upon completion of the returned operation: * Instances can be created using the instance configuration. * The instance config's reconciling field becomes false. Its state becomes `READY`. The returned long-running operation will have a name of the format `/operations/` and can be used to track creation of the instance config. The metadata field type is CreateInstanceConfigMetadata. The response field type is InstanceConfig, if successful. Authorization requires `spanner.instanceConfigs.create` permission on the resource parent.

      Args:
        request: (SpannerProjectsInstanceConfigsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instanceConfigs',
        http_method='POST',
        method_id='spanner.projects.instanceConfigs.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/instanceConfigs',
        request_field='createInstanceConfigRequest',
        request_type_name='SpannerProjectsInstanceConfigsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the instance config. Deletion is only allowed when no instances are using the configuration. If any instances are using the config, returns `FAILED_PRECONDITION`. Only user managed configurations can be deleted. Authorization requires `spanner.instanceConfigs.delete` permission on the resource name.

      Args:
        request: (SpannerProjectsInstanceConfigsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instanceConfigs/{instanceConfigsId}',
        http_method='DELETE',
        method_id='spanner.projects.instanceConfigs.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['etag', 'validateOnly'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstanceConfigsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets information about a particular instance configuration.

      Args:
        request: (SpannerProjectsInstanceConfigsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceConfig) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instanceConfigs/{instanceConfigsId}',
        http_method='GET',
        method_id='spanner.projects.instanceConfigs.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstanceConfigsGetRequest',
        response_type_name='InstanceConfig',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the supported instance configurations for a given project.

      Args:
        request: (SpannerProjectsInstanceConfigsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListInstanceConfigsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instanceConfigs',
        http_method='GET',
        method_id='spanner.projects.instanceConfigs.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/instanceConfigs',
        request_field='',
        request_type_name='SpannerProjectsInstanceConfigsListRequest',
        response_type_name='ListInstanceConfigsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an instance config. The returned long-running operation can be used to track the progress of updating the instance. If the named instance config does not exist, returns `NOT_FOUND`. Only user managed configurations can be updated. Immediately after the request returns: * The instance config's reconciling field is set to true. While the operation is pending: * Cancelling the operation sets its metadata's cancel_time. The operation is guaranteed to succeed at undoing all changes, after which point it terminates with a `CANCELLED` status. * All other attempts to modify the instance config are rejected. * Reading the instance config via the API continues to give the pre-request values. Upon completion of the returned operation: * Creating instances using the instance configuration uses the new values. * The instance config's new values are readable via the API. * The instance config's reconciling field becomes false. The returned long-running operation will have a name of the format `/operations/` and can be used to track the instance config modification. The metadata field type is UpdateInstanceConfigMetadata. The response field type is InstanceConfig, if successful. Authorization requires `spanner.instanceConfigs.update` permission on the resource name.

      Args:
        request: (SpannerProjectsInstanceConfigsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instanceConfigs/{instanceConfigsId}',
        http_method='PATCH',
        method_id='spanner.projects.instanceConfigs.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='updateInstanceConfigRequest',
        request_type_name='SpannerProjectsInstanceConfigsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsInstancesBackupOperationsService(base_api.BaseApiService):
    """Service class for the projects_instances_backupOperations resource."""

    _NAME = 'projects_instances_backupOperations'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstancesBackupOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists the backup long-running operations in the given instance. A backup operation has a name of the form `projects//instances//backups//operations/`. The long-running operation metadata field type `metadata.type_url` describes the type of the metadata. Operations returned include those that have completed/failed/canceled within the last 7 days, and pending operations. Operations returned are ordered by `operation.metadata.value.progress.start_time` in descending order starting from the most recently started operation.

      Args:
        request: (SpannerProjectsInstancesBackupOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListBackupOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/backupOperations',
        http_method='GET',
        method_id='spanner.projects.instances.backupOperations.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/backupOperations',
        request_field='',
        request_type_name='SpannerProjectsInstancesBackupOperationsListRequest',
        response_type_name='ListBackupOperationsResponse',
        supports_download=False,
    )

  class ProjectsInstancesBackupsOperationsService(base_api.BaseApiService):
    """Service class for the projects_instances_backups_operations resource."""

    _NAME = 'projects_instances_backups_operations'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstancesBackupsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.

      Args:
        request: (SpannerProjectsInstancesBackupsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/backups/{backupsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='spanner.projects.instances.backups.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:cancel',
        request_field='',
        request_type_name='SpannerProjectsInstancesBackupsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (SpannerProjectsInstancesBackupsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/backups/{backupsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='spanner.projects.instances.backups.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesBackupsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (SpannerProjectsInstancesBackupsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/backups/{backupsId}/operations/{operationsId}',
        http_method='GET',
        method_id='spanner.projects.instances.backups.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesBackupsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (SpannerProjectsInstancesBackupsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/backups/{backupsId}/operations',
        http_method='GET',
        method_id='spanner.projects.instances.backups.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesBackupsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsInstancesBackupsService(base_api.BaseApiService):
    """Service class for the projects_instances_backups resource."""

    _NAME = 'projects_instances_backups'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstancesBackupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Copy(self, request, global_params=None):
      r"""Starts copying a Cloud Spanner Backup. The returned backup long-running operation will have a name of the format `projects//instances//backups//operations/` and can be used to track copying of the backup. The operation is associated with the destination backup. The metadata field type is CopyBackupMetadata. The response field type is Backup, if successful. Cancelling the returned operation will stop the copying and delete the destination backup. Concurrent CopyBackup requests can run on the same source backup.

      Args:
        request: (SpannerProjectsInstancesBackupsCopyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Copy')
      return self._RunMethod(
          config, request, global_params=global_params)

    Copy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/backups:copy',
        http_method='POST',
        method_id='spanner.projects.instances.backups.copy',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/backups:copy',
        request_field='copyBackupRequest',
        request_type_name='SpannerProjectsInstancesBackupsCopyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Starts creating a new Cloud Spanner Backup. The returned backup long-running operation will have a name of the format `projects//instances//backups//operations/` and can be used to track creation of the backup. The metadata field type is CreateBackupMetadata. The response field type is Backup, if successful. Cancelling the returned operation will stop the creation and delete the backup. There can be only one pending backup creation per database. Backup creation of different databases can run concurrently.

      Args:
        request: (SpannerProjectsInstancesBackupsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/backups',
        http_method='POST',
        method_id='spanner.projects.instances.backups.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['backupId', 'encryptionConfig_encryptionType', 'encryptionConfig_kmsKeyName'],
        relative_path='v1/{+parent}/backups',
        request_field='backup',
        request_type_name='SpannerProjectsInstancesBackupsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a pending or completed Backup.

      Args:
        request: (SpannerProjectsInstancesBackupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/backups/{backupsId}',
        http_method='DELETE',
        method_id='spanner.projects.instances.backups.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesBackupsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets metadata on a pending or completed Backup.

      Args:
        request: (SpannerProjectsInstancesBackupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Backup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/backups/{backupsId}',
        http_method='GET',
        method_id='spanner.projects.instances.backups.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesBackupsGetRequest',
        response_type_name='Backup',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a database or backup resource. Returns an empty policy if a database or backup exists but does not have a policy set. Authorization requires `spanner.databases.getIamPolicy` permission on resource. For backups, authorization requires `spanner.backups.getIamPolicy` permission on resource.

      Args:
        request: (SpannerProjectsInstancesBackupsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/backups/{backupsId}:getIamPolicy',
        http_method='POST',
        method_id='spanner.projects.instances.backups.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='SpannerProjectsInstancesBackupsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists completed and pending backups. Backups returned are ordered by `create_time` in descending order, starting from the most recent `create_time`.

      Args:
        request: (SpannerProjectsInstancesBackupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListBackupsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/backups',
        http_method='GET',
        method_id='spanner.projects.instances.backups.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/backups',
        request_field='',
        request_type_name='SpannerProjectsInstancesBackupsListRequest',
        response_type_name='ListBackupsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a pending or completed Backup.

      Args:
        request: (SpannerProjectsInstancesBackupsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Backup) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/backups/{backupsId}',
        http_method='PATCH',
        method_id='spanner.projects.instances.backups.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='backup',
        request_type_name='SpannerProjectsInstancesBackupsPatchRequest',
        response_type_name='Backup',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on a database or backup resource. Replaces any existing policy. Authorization requires `spanner.databases.setIamPolicy` permission on resource. For backups, authorization requires `spanner.backups.setIamPolicy` permission on resource.

      Args:
        request: (SpannerProjectsInstancesBackupsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/backups/{backupsId}:setIamPolicy',
        http_method='POST',
        method_id='spanner.projects.instances.backups.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='SpannerProjectsInstancesBackupsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that the caller has on the specified database or backup resource. Attempting this RPC on a non-existent Cloud Spanner database will result in a NOT_FOUND error if the user has `spanner.databases.list` permission on the containing Cloud Spanner instance. Otherwise returns an empty set of permissions. Calling this method on a backup that does not exist will result in a NOT_FOUND error if the user has `spanner.backups.list` permission on the containing instance.

      Args:
        request: (SpannerProjectsInstancesBackupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/backups/{backupsId}:testIamPermissions',
        http_method='POST',
        method_id='spanner.projects.instances.backups.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='SpannerProjectsInstancesBackupsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsInstancesDatabaseOperationsService(base_api.BaseApiService):
    """Service class for the projects_instances_databaseOperations resource."""

    _NAME = 'projects_instances_databaseOperations'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstancesDatabaseOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists database longrunning-operations. A database operation has a name of the form `projects//instances//databases//operations/`. The long-running operation metadata field type `metadata.type_url` describes the type of the metadata. Operations returned include those that have completed/failed/canceled within the last 7 days, and pending operations.

      Args:
        request: (SpannerProjectsInstancesDatabaseOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDatabaseOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databaseOperations',
        http_method='GET',
        method_id='spanner.projects.instances.databaseOperations.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/databaseOperations',
        request_field='',
        request_type_name='SpannerProjectsInstancesDatabaseOperationsListRequest',
        response_type_name='ListDatabaseOperationsResponse',
        supports_download=False,
    )

  class ProjectsInstancesDatabasesDatabaseRolesService(base_api.BaseApiService):
    """Service class for the projects_instances_databases_databaseRoles resource."""

    _NAME = 'projects_instances_databases_databaseRoles'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstancesDatabasesDatabaseRolesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists Cloud Spanner database roles.

      Args:
        request: (SpannerProjectsInstancesDatabasesDatabaseRolesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDatabaseRolesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/databaseRoles',
        http_method='GET',
        method_id='spanner.projects.instances.databases.databaseRoles.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/databaseRoles',
        request_field='',
        request_type_name='SpannerProjectsInstancesDatabasesDatabaseRolesListRequest',
        response_type_name='ListDatabaseRolesResponse',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that the caller has on the specified database or backup resource. Attempting this RPC on a non-existent Cloud Spanner database will result in a NOT_FOUND error if the user has `spanner.databases.list` permission on the containing Cloud Spanner instance. Otherwise returns an empty set of permissions. Calling this method on a backup that does not exist will result in a NOT_FOUND error if the user has `spanner.backups.list` permission on the containing instance.

      Args:
        request: (SpannerProjectsInstancesDatabasesDatabaseRolesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/databaseRoles/{databaseRolesId}:testIamPermissions',
        http_method='POST',
        method_id='spanner.projects.instances.databases.databaseRoles.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='SpannerProjectsInstancesDatabasesDatabaseRolesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsInstancesDatabasesOperationsService(base_api.BaseApiService):
    """Service class for the projects_instances_databases_operations resource."""

    _NAME = 'projects_instances_databases_operations'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstancesDatabasesOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.

      Args:
        request: (SpannerProjectsInstancesDatabasesOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='spanner.projects.instances.databases.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:cancel',
        request_field='',
        request_type_name='SpannerProjectsInstancesDatabasesOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (SpannerProjectsInstancesDatabasesOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='spanner.projects.instances.databases.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesDatabasesOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (SpannerProjectsInstancesDatabasesOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/operations/{operationsId}',
        http_method='GET',
        method_id='spanner.projects.instances.databases.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesDatabasesOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (SpannerProjectsInstancesDatabasesOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/operations',
        http_method='GET',
        method_id='spanner.projects.instances.databases.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesDatabasesOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsInstancesDatabasesSessionsService(base_api.BaseApiService):
    """Service class for the projects_instances_databases_sessions resource."""

    _NAME = 'projects_instances_databases_sessions'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstancesDatabasesSessionsService, self).__init__(client)
      self._upload_configs = {
          }

    def BatchCreate(self, request, global_params=None):
      r"""Creates multiple new sessions. This API can be used to initialize a session cache on the clients. See https://goo.gl/TgSFN2 for best practices on session cache management.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsBatchCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BatchCreateSessionsResponse) The response message.
      """
      config = self.GetMethodConfig('BatchCreate')
      return self._RunMethod(
          config, request, global_params=global_params)

    BatchCreate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions:batchCreate',
        http_method='POST',
        method_id='spanner.projects.instances.databases.sessions.batchCreate',
        ordered_params=['database'],
        path_params=['database'],
        query_params=[],
        relative_path='v1/{+database}/sessions:batchCreate',
        request_field='batchCreateSessionsRequest',
        request_type_name='SpannerProjectsInstancesDatabasesSessionsBatchCreateRequest',
        response_type_name='BatchCreateSessionsResponse',
        supports_download=False,
    )

    def BeginTransaction(self, request, global_params=None):
      r"""Begins a new transaction. This step can often be skipped: Read, ExecuteSql and Commit can begin a new transaction as a side-effect.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsBeginTransactionRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Transaction) The response message.
      """
      config = self.GetMethodConfig('BeginTransaction')
      return self._RunMethod(
          config, request, global_params=global_params)

    BeginTransaction.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:beginTransaction',
        http_method='POST',
        method_id='spanner.projects.instances.databases.sessions.beginTransaction',
        ordered_params=['session'],
        path_params=['session'],
        query_params=[],
        relative_path='v1/{+session}:beginTransaction',
        request_field='beginTransactionRequest',
        request_type_name='SpannerProjectsInstancesDatabasesSessionsBeginTransactionRequest',
        response_type_name='Transaction',
        supports_download=False,
    )

    def Commit(self, request, global_params=None):
      r"""Commits a transaction. The request includes the mutations to be applied to rows in the database. `Commit` might return an `ABORTED` error. This can occur at any time; commonly, the cause is conflicts with concurrent transactions. However, it can also happen for a variety of other reasons. If `Commit` returns `ABORTED`, the caller should re-attempt the transaction from the beginning, re-using the same session. On very rare occasions, `Commit` might return `UNKNOWN`. This can happen, for example, if the client job experiences a 1+ hour networking failure. At that point, Cloud Spanner has lost track of the transaction outcome and we recommend that you perform another read from the database to see the state of things as they are now.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsCommitRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CommitResponse) The response message.
      """
      config = self.GetMethodConfig('Commit')
      return self._RunMethod(
          config, request, global_params=global_params)

    Commit.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:commit',
        http_method='POST',
        method_id='spanner.projects.instances.databases.sessions.commit',
        ordered_params=['session'],
        path_params=['session'],
        query_params=[],
        relative_path='v1/{+session}:commit',
        request_field='commitRequest',
        request_type_name='SpannerProjectsInstancesDatabasesSessionsCommitRequest',
        response_type_name='CommitResponse',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new session. A session can be used to perform transactions that read and/or modify data in a Cloud Spanner database. Sessions are meant to be reused for many consecutive transactions. Sessions can only execute one transaction at a time. To execute multiple concurrent read-write/write-only transactions, create multiple sessions. Note that standalone reads and queries use a transaction internally, and count toward the one transaction limit. Active sessions use additional server resources, so it is a good idea to delete idle and unneeded sessions. Aside from explicit deletes, Cloud Spanner may delete sessions for which no operations are sent for more than an hour. If a session is deleted, requests to it return `NOT_FOUND`. Idle sessions can be kept alive by sending a trivial SQL query periodically, e.g., `"SELECT 1"`.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Session) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions',
        http_method='POST',
        method_id='spanner.projects.instances.databases.sessions.create',
        ordered_params=['database'],
        path_params=['database'],
        query_params=[],
        relative_path='v1/{+database}/sessions',
        request_field='createSessionRequest',
        request_type_name='SpannerProjectsInstancesDatabasesSessionsCreateRequest',
        response_type_name='Session',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Ends a session, releasing server resources associated with it. This will asynchronously trigger cancellation of any operations that are running with this session.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}',
        http_method='DELETE',
        method_id='spanner.projects.instances.databases.sessions.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesDatabasesSessionsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def ExecuteBatchDml(self, request, global_params=None):
      r"""Executes a batch of SQL DML statements. This method allows many statements to be run with lower latency than submitting them sequentially with ExecuteSql. Statements are executed in sequential order. A request can succeed even if a statement fails. The ExecuteBatchDmlResponse.status field in the response provides information about the statement that failed. Clients must inspect this field to determine whether an error occurred. Execution stops after the first failed statement; the remaining statements are not executed.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsExecuteBatchDmlRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ExecuteBatchDmlResponse) The response message.
      """
      config = self.GetMethodConfig('ExecuteBatchDml')
      return self._RunMethod(
          config, request, global_params=global_params)

    ExecuteBatchDml.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:executeBatchDml',
        http_method='POST',
        method_id='spanner.projects.instances.databases.sessions.executeBatchDml',
        ordered_params=['session'],
        path_params=['session'],
        query_params=[],
        relative_path='v1/{+session}:executeBatchDml',
        request_field='executeBatchDmlRequest',
        request_type_name='SpannerProjectsInstancesDatabasesSessionsExecuteBatchDmlRequest',
        response_type_name='ExecuteBatchDmlResponse',
        supports_download=False,
    )

    def ExecuteSql(self, request, global_params=None):
      r"""Executes an SQL statement, returning all results in a single reply. This method cannot be used to return a result set larger than 10 MiB; if the query yields more data than that, the query fails with a `FAILED_PRECONDITION` error. Operations inside read-write transactions might return `ABORTED`. If this occurs, the application should restart the transaction from the beginning. See Transaction for more details. Larger result sets can be fetched in streaming fashion by calling ExecuteStreamingSql instead.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsExecuteSqlRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ResultSet) The response message.
      """
      config = self.GetMethodConfig('ExecuteSql')
      return self._RunMethod(
          config, request, global_params=global_params)

    ExecuteSql.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:executeSql',
        http_method='POST',
        method_id='spanner.projects.instances.databases.sessions.executeSql',
        ordered_params=['session'],
        path_params=['session'],
        query_params=[],
        relative_path='v1/{+session}:executeSql',
        request_field='executeSqlRequest',
        request_type_name='SpannerProjectsInstancesDatabasesSessionsExecuteSqlRequest',
        response_type_name='ResultSet',
        supports_download=False,
    )

    def ExecuteStreamingSql(self, request, global_params=None):
      r"""Like ExecuteSql, except returns the result set as a stream. Unlike ExecuteSql, there is no limit on the size of the returned result set. However, no individual row in the result set can exceed 100 MiB, and no column value can exceed 10 MiB.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsExecuteStreamingSqlRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PartialResultSet) The response message.
      """
      config = self.GetMethodConfig('ExecuteStreamingSql')
      return self._RunMethod(
          config, request, global_params=global_params)

    ExecuteStreamingSql.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:executeStreamingSql',
        http_method='POST',
        method_id='spanner.projects.instances.databases.sessions.executeStreamingSql',
        ordered_params=['session'],
        path_params=['session'],
        query_params=[],
        relative_path='v1/{+session}:executeStreamingSql',
        request_field='executeSqlRequest',
        request_type_name='SpannerProjectsInstancesDatabasesSessionsExecuteStreamingSqlRequest',
        response_type_name='PartialResultSet',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a session. Returns `NOT_FOUND` if the session does not exist. This is mainly useful for determining whether a session is still alive.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Session) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}',
        http_method='GET',
        method_id='spanner.projects.instances.databases.sessions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesDatabasesSessionsGetRequest',
        response_type_name='Session',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all sessions in a given database.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSessionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions',
        http_method='GET',
        method_id='spanner.projects.instances.databases.sessions.list',
        ordered_params=['database'],
        path_params=['database'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+database}/sessions',
        request_field='',
        request_type_name='SpannerProjectsInstancesDatabasesSessionsListRequest',
        response_type_name='ListSessionsResponse',
        supports_download=False,
    )

    def PartitionQuery(self, request, global_params=None):
      r"""Creates a set of partition tokens that can be used to execute a query operation in parallel. Each of the returned partition tokens can be used by ExecuteStreamingSql to specify a subset of the query result to read. The same session and read-only transaction must be used by the PartitionQueryRequest used to create the partition tokens and the ExecuteSqlRequests that use the partition tokens. Partition tokens become invalid when the session used to create them is deleted, is idle for too long, begins a new transaction, or becomes too old. When any of these happen, it is not possible to resume the query, and the whole operation must be restarted from the beginning.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsPartitionQueryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PartitionResponse) The response message.
      """
      config = self.GetMethodConfig('PartitionQuery')
      return self._RunMethod(
          config, request, global_params=global_params)

    PartitionQuery.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:partitionQuery',
        http_method='POST',
        method_id='spanner.projects.instances.databases.sessions.partitionQuery',
        ordered_params=['session'],
        path_params=['session'],
        query_params=[],
        relative_path='v1/{+session}:partitionQuery',
        request_field='partitionQueryRequest',
        request_type_name='SpannerProjectsInstancesDatabasesSessionsPartitionQueryRequest',
        response_type_name='PartitionResponse',
        supports_download=False,
    )

    def PartitionRead(self, request, global_params=None):
      r"""Creates a set of partition tokens that can be used to execute a read operation in parallel. Each of the returned partition tokens can be used by StreamingRead to specify a subset of the read result to read. The same session and read-only transaction must be used by the PartitionReadRequest used to create the partition tokens and the ReadRequests that use the partition tokens. There are no ordering guarantees on rows returned among the returned partition tokens, or even within each individual StreamingRead call issued with a partition_token. Partition tokens become invalid when the session used to create them is deleted, is idle for too long, begins a new transaction, or becomes too old. When any of these happen, it is not possible to resume the read, and the whole operation must be restarted from the beginning.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsPartitionReadRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PartitionResponse) The response message.
      """
      config = self.GetMethodConfig('PartitionRead')
      return self._RunMethod(
          config, request, global_params=global_params)

    PartitionRead.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:partitionRead',
        http_method='POST',
        method_id='spanner.projects.instances.databases.sessions.partitionRead',
        ordered_params=['session'],
        path_params=['session'],
        query_params=[],
        relative_path='v1/{+session}:partitionRead',
        request_field='partitionReadRequest',
        request_type_name='SpannerProjectsInstancesDatabasesSessionsPartitionReadRequest',
        response_type_name='PartitionResponse',
        supports_download=False,
    )

    def Read(self, request, global_params=None):
      r"""Reads rows from the database using key lookups and scans, as a simple key/value style alternative to ExecuteSql. This method cannot be used to return a result set larger than 10 MiB; if the read matches more data than that, the read fails with a `FAILED_PRECONDITION` error. Reads inside read-write transactions might return `ABORTED`. If this occurs, the application should restart the transaction from the beginning. See Transaction for more details. Larger result sets can be yielded in streaming fashion by calling StreamingRead instead.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsReadRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ResultSet) The response message.
      """
      config = self.GetMethodConfig('Read')
      return self._RunMethod(
          config, request, global_params=global_params)

    Read.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:read',
        http_method='POST',
        method_id='spanner.projects.instances.databases.sessions.read',
        ordered_params=['session'],
        path_params=['session'],
        query_params=[],
        relative_path='v1/{+session}:read',
        request_field='readRequest',
        request_type_name='SpannerProjectsInstancesDatabasesSessionsReadRequest',
        response_type_name='ResultSet',
        supports_download=False,
    )

    def Rollback(self, request, global_params=None):
      r"""Rolls back a transaction, releasing any locks it holds. It is a good idea to call this for any transaction that includes one or more Read or ExecuteSql requests and ultimately decides not to commit. `Rollback` returns `OK` if it successfully aborts the transaction, the transaction was already aborted, or the transaction is not found. `Rollback` never returns `ABORTED`.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsRollbackRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Rollback')
      return self._RunMethod(
          config, request, global_params=global_params)

    Rollback.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:rollback',
        http_method='POST',
        method_id='spanner.projects.instances.databases.sessions.rollback',
        ordered_params=['session'],
        path_params=['session'],
        query_params=[],
        relative_path='v1/{+session}:rollback',
        request_field='rollbackRequest',
        request_type_name='SpannerProjectsInstancesDatabasesSessionsRollbackRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def StreamingRead(self, request, global_params=None):
      r"""Like Read, except returns the result set as a stream. Unlike Read, there is no limit on the size of the returned result set. However, no individual row in the result set can exceed 100 MiB, and no column value can exceed 10 MiB.

      Args:
        request: (SpannerProjectsInstancesDatabasesSessionsStreamingReadRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PartialResultSet) The response message.
      """
      config = self.GetMethodConfig('StreamingRead')
      return self._RunMethod(
          config, request, global_params=global_params)

    StreamingRead.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:streamingRead',
        http_method='POST',
        method_id='spanner.projects.instances.databases.sessions.streamingRead',
        ordered_params=['session'],
        path_params=['session'],
        query_params=[],
        relative_path='v1/{+session}:streamingRead',
        request_field='readRequest',
        request_type_name='SpannerProjectsInstancesDatabasesSessionsStreamingReadRequest',
        response_type_name='PartialResultSet',
        supports_download=False,
    )

  class ProjectsInstancesDatabasesService(base_api.BaseApiService):
    """Service class for the projects_instances_databases resource."""

    _NAME = 'projects_instances_databases'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstancesDatabasesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Cloud Spanner database and starts to prepare it for serving. The returned long-running operation will have a name of the format `/operations/` and can be used to track preparation of the database. The metadata field type is CreateDatabaseMetadata. The response field type is Database, if successful.

      Args:
        request: (SpannerProjectsInstancesDatabasesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases',
        http_method='POST',
        method_id='spanner.projects.instances.databases.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/databases',
        request_field='createDatabaseRequest',
        request_type_name='SpannerProjectsInstancesDatabasesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DropDatabase(self, request, global_params=None):
      r"""Drops (aka deletes) a Cloud Spanner database. Completed backups for the database will be retained according to their `expire_time`. Note: Cloud Spanner might continue to accept requests for a few seconds after the database has been deleted.

      Args:
        request: (SpannerProjectsInstancesDatabasesDropDatabaseRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('DropDatabase')
      return self._RunMethod(
          config, request, global_params=global_params)

    DropDatabase.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}',
        http_method='DELETE',
        method_id='spanner.projects.instances.databases.dropDatabase',
        ordered_params=['database'],
        path_params=['database'],
        query_params=[],
        relative_path='v1/{+database}',
        request_field='',
        request_type_name='SpannerProjectsInstancesDatabasesDropDatabaseRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the state of a Cloud Spanner database.

      Args:
        request: (SpannerProjectsInstancesDatabasesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Database) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}',
        http_method='GET',
        method_id='spanner.projects.instances.databases.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesDatabasesGetRequest',
        response_type_name='Database',
        supports_download=False,
    )

    def GetDdl(self, request, global_params=None):
      r"""Returns the schema of a Cloud Spanner database as a list of formatted DDL statements. This method does not show pending schema updates, those may be queried using the Operations API.

      Args:
        request: (SpannerProjectsInstancesDatabasesGetDdlRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetDatabaseDdlResponse) The response message.
      """
      config = self.GetMethodConfig('GetDdl')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetDdl.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/ddl',
        http_method='GET',
        method_id='spanner.projects.instances.databases.getDdl',
        ordered_params=['database'],
        path_params=['database'],
        query_params=[],
        relative_path='v1/{+database}/ddl',
        request_field='',
        request_type_name='SpannerProjectsInstancesDatabasesGetDdlRequest',
        response_type_name='GetDatabaseDdlResponse',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a database or backup resource. Returns an empty policy if a database or backup exists but does not have a policy set. Authorization requires `spanner.databases.getIamPolicy` permission on resource. For backups, authorization requires `spanner.backups.getIamPolicy` permission on resource.

      Args:
        request: (SpannerProjectsInstancesDatabasesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}:getIamPolicy',
        http_method='POST',
        method_id='spanner.projects.instances.databases.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='SpannerProjectsInstancesDatabasesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def GetScans(self, request, global_params=None):
      r"""Request a specific scan with Database-specific data for Cloud Key Visualizer.

      Args:
        request: (SpannerProjectsInstancesDatabasesGetScansRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Scan) The response message.
      """
      config = self.GetMethodConfig('GetScans')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetScans.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/scans',
        http_method='GET',
        method_id='spanner.projects.instances.databases.getScans',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['endTime', 'startTime', 'view'],
        relative_path='v1/{+name}/scans',
        request_field='',
        request_type_name='SpannerProjectsInstancesDatabasesGetScansRequest',
        response_type_name='Scan',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Cloud Spanner databases.

      Args:
        request: (SpannerProjectsInstancesDatabasesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDatabasesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases',
        http_method='GET',
        method_id='spanner.projects.instances.databases.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/databases',
        request_field='',
        request_type_name='SpannerProjectsInstancesDatabasesListRequest',
        response_type_name='ListDatabasesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a Cloud Spanner database. The returned long-running operation can be used to track the progress of updating the database. If the named database does not exist, returns `NOT_FOUND`. While the operation is pending: * The database's reconciling field is set to true. * Cancelling the operation is best-effort. If the cancellation succeeds, the operation metadata's cancel_time is set, the updates are reverted, and the operation terminates with a `CANCELLED` status. * New UpdateDatabase requests will return a `FAILED_PRECONDITION` error until the pending operation is done (returns successfully or with error). * Reading the database via the API continues to give the pre-request values. Upon completion of the returned operation: * The new values are in effect and readable via the API. * The database's reconciling field becomes false. The returned long-running operation will have a name of the format `projects//instances//databases//operations/` and can be used to track the database modification. The metadata field type is UpdateDatabaseMetadata. The response field type is Database, if successful.

      Args:
        request: (SpannerProjectsInstancesDatabasesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}',
        http_method='PATCH',
        method_id='spanner.projects.instances.databases.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='database',
        request_type_name='SpannerProjectsInstancesDatabasesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Restore(self, request, global_params=None):
      r"""Create a new database by restoring from a completed backup. The new database must be in the same project and in an instance with the same instance configuration as the instance containing the backup. The returned database long-running operation has a name of the format `projects//instances//databases//operations/`, and can be used to track the progress of the operation, and to cancel it. The metadata field type is RestoreDatabaseMetadata. The response type is Database, if successful. Cancelling the returned operation will stop the restore and delete the database. There can be only one database being restored into an instance at a time. Once the restore operation completes, a new restore operation can be initiated, without waiting for the optimize operation associated with the first restore to complete.

      Args:
        request: (SpannerProjectsInstancesDatabasesRestoreRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Restore')
      return self._RunMethod(
          config, request, global_params=global_params)

    Restore.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases:restore',
        http_method='POST',
        method_id='spanner.projects.instances.databases.restore',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/databases:restore',
        request_field='restoreDatabaseRequest',
        request_type_name='SpannerProjectsInstancesDatabasesRestoreRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on a database or backup resource. Replaces any existing policy. Authorization requires `spanner.databases.setIamPolicy` permission on resource. For backups, authorization requires `spanner.backups.setIamPolicy` permission on resource.

      Args:
        request: (SpannerProjectsInstancesDatabasesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}:setIamPolicy',
        http_method='POST',
        method_id='spanner.projects.instances.databases.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='SpannerProjectsInstancesDatabasesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that the caller has on the specified database or backup resource. Attempting this RPC on a non-existent Cloud Spanner database will result in a NOT_FOUND error if the user has `spanner.databases.list` permission on the containing Cloud Spanner instance. Otherwise returns an empty set of permissions. Calling this method on a backup that does not exist will result in a NOT_FOUND error if the user has `spanner.backups.list` permission on the containing instance.

      Args:
        request: (SpannerProjectsInstancesDatabasesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}:testIamPermissions',
        http_method='POST',
        method_id='spanner.projects.instances.databases.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='SpannerProjectsInstancesDatabasesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

    def UpdateDdl(self, request, global_params=None):
      r"""Updates the schema of a Cloud Spanner database by creating/altering/dropping tables, columns, indexes, etc. The returned long-running operation will have a name of the format `/operations/` and can be used to track execution of the schema change(s). The metadata field type is UpdateDatabaseDdlMetadata. The operation has no response.

      Args:
        request: (SpannerProjectsInstancesDatabasesUpdateDdlRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateDdl')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateDdl.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/ddl',
        http_method='PATCH',
        method_id='spanner.projects.instances.databases.updateDdl',
        ordered_params=['database'],
        path_params=['database'],
        query_params=[],
        relative_path='v1/{+database}/ddl',
        request_field='updateDatabaseDdlRequest',
        request_type_name='SpannerProjectsInstancesDatabasesUpdateDdlRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsInstancesInstancePartitionsOperationsService(base_api.BaseApiService):
    """Service class for the projects_instances_instancePartitions_operations resource."""

    _NAME = 'projects_instances_instancePartitions_operations'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstancesInstancePartitionsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.

      Args:
        request: (SpannerProjectsInstancesInstancePartitionsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/instancePartitions/{instancePartitionsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='spanner.projects.instances.instancePartitions.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:cancel',
        request_field='',
        request_type_name='SpannerProjectsInstancesInstancePartitionsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (SpannerProjectsInstancesInstancePartitionsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/instancePartitions/{instancePartitionsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='spanner.projects.instances.instancePartitions.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesInstancePartitionsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (SpannerProjectsInstancesInstancePartitionsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/instancePartitions/{instancePartitionsId}/operations/{operationsId}',
        http_method='GET',
        method_id='spanner.projects.instances.instancePartitions.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesInstancePartitionsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (SpannerProjectsInstancesInstancePartitionsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/instancePartitions/{instancePartitionsId}/operations',
        http_method='GET',
        method_id='spanner.projects.instances.instancePartitions.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesInstancePartitionsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsInstancesInstancePartitionsService(base_api.BaseApiService):
    """Service class for the projects_instances_instancePartitions resource."""

    _NAME = 'projects_instances_instancePartitions'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstancesInstancePartitionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an instance partition and begins preparing it to be used. The returned long-running operation can be used to track the progress of preparing the new instance partition. The instance partition name is assigned by the caller. If the named instance partition already exists, `CreateInstancePartition` returns `ALREADY_EXISTS`. Immediately upon completion of this request: * The instance partition is readable via the API, with all requested attributes but no allocated resources. Its state is `CREATING`. Until completion of the returned operation: * Cancelling the operation renders the instance partition immediately unreadable via the API. * The instance partition can be deleted. * All other attempts to modify the instance partition are rejected. Upon completion of the returned operation: * Billing for all successfully-allocated resources begins (some types may have lower than the requested levels). * Databases can start using this instance partition. * The instance partition's allocated resource levels are readable via the API. * The instance partition's state becomes `READY`. The returned long-running operation will have a name of the format `/operations/` and can be used to track creation of the instance partition. The metadata field type is CreateInstancePartitionMetadata. The response field type is InstancePartition, if successful.

      Args:
        request: (SpannerProjectsInstancesInstancePartitionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/instancePartitions',
        http_method='POST',
        method_id='spanner.projects.instances.instancePartitions.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/instancePartitions',
        request_field='createInstancePartitionRequest',
        request_type_name='SpannerProjectsInstancesInstancePartitionsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an existing instance partition. Requires that the instance partition is not used by any database or backup and is not the default instance partition of an instance. Authorization requires `spanner.instancePartitions.delete` permission on the resource name.

      Args:
        request: (SpannerProjectsInstancesInstancePartitionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/instancePartitions/{instancePartitionsId}',
        http_method='DELETE',
        method_id='spanner.projects.instances.instancePartitions.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['etag'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesInstancePartitionsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets information about a particular instance partition.

      Args:
        request: (SpannerProjectsInstancesInstancePartitionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstancePartition) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/instancePartitions/{instancePartitionsId}',
        http_method='GET',
        method_id='spanner.projects.instances.instancePartitions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesInstancePartitionsGetRequest',
        response_type_name='InstancePartition',
        supports_download=False,
    )

  class ProjectsInstancesOperationsService(base_api.BaseApiService):
    """Service class for the projects_instances_operations resource."""

    _NAME = 'projects_instances_operations'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstancesOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.

      Args:
        request: (SpannerProjectsInstancesOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='spanner.projects.instances.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:cancel',
        request_field='',
        request_type_name='SpannerProjectsInstancesOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (SpannerProjectsInstancesOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='spanner.projects.instances.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (SpannerProjectsInstancesOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/operations/{operationsId}',
        http_method='GET',
        method_id='spanner.projects.instances.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (SpannerProjectsInstancesOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}/operations',
        http_method='GET',
        method_id='spanner.projects.instances.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsInstancesService(base_api.BaseApiService):
    """Service class for the projects_instances resource."""

    _NAME = 'projects_instances'

    def __init__(self, client):
      super(SpannerV1.ProjectsInstancesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an instance and begins preparing it to begin serving. The returned long-running operation can be used to track the progress of preparing the new instance. The instance name is assigned by the caller. If the named instance already exists, `CreateInstance` returns `ALREADY_EXISTS`. Immediately upon completion of this request: * The instance is readable via the API, with all requested attributes but no allocated resources. Its state is `CREATING`. Until completion of the returned operation: * Cancelling the operation renders the instance immediately unreadable via the API. * The instance can be deleted. * All other attempts to modify the instance are rejected. Upon completion of the returned operation: * Billing for all successfully-allocated resources begins (some types may have lower than the requested levels). * Databases can be created in the instance. * The instance's allocated resource levels are readable via the API. * The instance's state becomes `READY`. The returned long-running operation will have a name of the format `/operations/` and can be used to track creation of the instance. The metadata field type is CreateInstanceMetadata. The response field type is Instance, if successful.

      Args:
        request: (SpannerProjectsInstancesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances',
        http_method='POST',
        method_id='spanner.projects.instances.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/instances',
        request_field='createInstanceRequest',
        request_type_name='SpannerProjectsInstancesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an instance. Immediately upon completion of the request: * Billing ceases for all of the instance's reserved resources. Soon afterward: * The instance and *all of its databases* immediately and irrevocably disappear from the API. All data in the databases is permanently deleted.

      Args:
        request: (SpannerProjectsInstancesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}',
        http_method='DELETE',
        method_id='spanner.projects.instances.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets information about a particular instance.

      Args:
        request: (SpannerProjectsInstancesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Instance) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}',
        http_method='GET',
        method_id='spanner.projects.instances.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['fieldMask'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SpannerProjectsInstancesGetRequest',
        response_type_name='Instance',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for an instance resource. Returns an empty policy if an instance exists but does not have a policy set. Authorization requires `spanner.instances.getIamPolicy` on resource.

      Args:
        request: (SpannerProjectsInstancesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}:getIamPolicy',
        http_method='POST',
        method_id='spanner.projects.instances.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='SpannerProjectsInstancesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all instances in the given project.

      Args:
        request: (SpannerProjectsInstancesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListInstancesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances',
        http_method='GET',
        method_id='spanner.projects.instances.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'instanceDeadline', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/instances',
        request_field='',
        request_type_name='SpannerProjectsInstancesListRequest',
        response_type_name='ListInstancesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an instance, and begins allocating or releasing resources as requested. The returned long-running operation can be used to track the progress of updating the instance. If the named instance does not exist, returns `NOT_FOUND`. Immediately upon completion of this request: * For resource types for which a decrease in the instance's allocation has been requested, billing is based on the newly-requested level. Until completion of the returned operation: * Cancelling the operation sets its metadata's cancel_time, and begins restoring resources to their pre-request values. The operation is guaranteed to succeed at undoing all resource changes, after which point it terminates with a `CANCELLED` status. * All other attempts to modify the instance are rejected. * Reading the instance via the API continues to give the pre-request resource levels. Upon completion of the returned operation: * Billing begins for all successfully-allocated resources (some types may have lower than the requested levels). * All newly-reserved resources are available for serving the instance's tables. * The instance's new resource levels are readable via the API. The returned long-running operation will have a name of the format `/operations/` and can be used to track the instance modification. The metadata field type is UpdateInstanceMetadata. The response field type is Instance, if successful. Authorization requires `spanner.instances.update` permission on the resource name.

      Args:
        request: (SpannerProjectsInstancesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}',
        http_method='PATCH',
        method_id='spanner.projects.instances.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='updateInstanceRequest',
        request_type_name='SpannerProjectsInstancesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on an instance resource. Replaces any existing policy. Authorization requires `spanner.instances.setIamPolicy` on resource.

      Args:
        request: (SpannerProjectsInstancesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}:setIamPolicy',
        http_method='POST',
        method_id='spanner.projects.instances.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='SpannerProjectsInstancesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that the caller has on the specified instance resource. Attempting this RPC on a non-existent Cloud Spanner instance resource will result in a NOT_FOUND error if the user has `spanner.instances.list` permission on the containing Google Cloud Project. Otherwise returns an empty set of permissions.

      Args:
        request: (SpannerProjectsInstancesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/instances/{instancesId}:testIamPermissions',
        http_method='POST',
        method_id='spanner.projects.instances.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='SpannerProjectsInstancesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(SpannerV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class ScansService(base_api.BaseApiService):
    """Service class for the scans resource."""

    _NAME = 'scans'

    def __init__(self, client):
      super(SpannerV1.ScansService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Return available scans given a Database-specific resource name.

      Args:
        request: (SpannerScansListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListScansResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/scans',
        http_method='GET',
        method_id='spanner.scans.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken', 'view'],
        relative_path='v1/{+parent}',
        request_field='',
        request_type_name='SpannerScansListRequest',
        response_type_name='ListScansResponse',
        supports_download=False,
    )
