"""Generated message classes for privateca version v1.

The Certificate Authority Service API is a highly-available, scalable service
that enables you to simplify and automate the management of private
certificate authorities (CAs) while staying in control of your private keys.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'privateca'


class AccessUrls(_messages.Message):
  r"""URLs where a CertificateAuthority will publish content.

  Fields:
    caCertificateAccessUrl: The URL where this CertificateAuthority's CA
      certificate is published. This will only be set for CAs that have been
      activated.
    crlAccessUrls: The URLs where this CertificateAuthority's CRLs are
      published. This will only be set for CAs that have been activated.
  """

  caCertificateAccessUrl = _messages.StringField(1)
  crlAccessUrls = _messages.StringField(2, repeated=True)


class ActivateCertificateAuthorityRequest(_messages.Message):
  r"""Request message for
  CertificateAuthorityService.ActivateCertificateAuthority.

  Fields:
    pemCaCertificate: Required. The signed CA certificate issued from
      FetchCertificateAuthorityCsrResponse.pem_csr.
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    subordinateConfig: Required. Must include information about the issuer of
      'pem_ca_certificate', and any further issuers until the self-signed CA.
  """

  pemCaCertificate = _messages.StringField(1)
  requestId = _messages.StringField(2)
  subordinateConfig = _messages.MessageField('SubordinateConfig', 3)


class AllowedKeyType(_messages.Message):
  r"""Describes a "type" of key that may be used in a Certificate issued from
  a CaPool. Note that a single AllowedKeyType may refer to either a fully-
  qualified key algorithm, such as RSA 4096, or a family of key algorithms,
  such as any RSA key.

  Fields:
    ellipticCurve: Represents an allowed Elliptic Curve key type.
    rsa: Represents an allowed RSA key type.
  """

  ellipticCurve = _messages.MessageField('EcKeyType', 1)
  rsa = _messages.MessageField('RsaKeyType', 2)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CaOptions(_messages.Message):
  r"""Describes values that are relevant in a CA certificate.

  Fields:
    isCa: Optional. Refers to the "CA" X.509 extension, which is a boolean
      value. When this value is missing, the extension will be omitted from
      the CA certificate.
    maxIssuerPathLength: Optional. Refers to the path length restriction X.509
      extension. For a CA certificate, this value describes the depth of
      subordinate CA certificates that are allowed. If this value is less than
      0, the request will fail. If this value is missing, the max path length
      will be omitted from the CA certificate.
  """

  isCa = _messages.BooleanField(1)
  maxIssuerPathLength = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class CaPool(_messages.Message):
  r"""A CaPool represents a group of CertificateAuthorities that form a trust
  anchor. A CaPool can be used to manage issuance policies for one or more
  CertificateAuthority resources and to rotate CA certificates in and out of
  the trust anchor.

  Enums:
    TierValueValuesEnum: Required. Immutable. The Tier of this CaPool.

  Messages:
    LabelsValue: Optional. Labels with user-defined metadata.

  Fields:
    issuancePolicy: Optional. The IssuancePolicy to control how Certificates
      will be issued from this CaPool.
    labels: Optional. Labels with user-defined metadata.
    name: Output only. The resource name for this CaPool in the format
      `projects/*/locations/*/caPools/*`.
    publishingOptions: Optional. The PublishingOptions to follow when issuing
      Certificates from any CertificateAuthority in this CaPool.
    tier: Required. Immutable. The Tier of this CaPool.
  """

  class TierValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The Tier of this CaPool.

    Values:
      TIER_UNSPECIFIED: Not specified.
      ENTERPRISE: Enterprise tier.
      DEVOPS: DevOps tier.
    """
    TIER_UNSPECIFIED = 0
    ENTERPRISE = 1
    DEVOPS = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels with user-defined metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  issuancePolicy = _messages.MessageField('IssuancePolicy', 1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  publishingOptions = _messages.MessageField('PublishingOptions', 4)
  tier = _messages.EnumField('TierValueValuesEnum', 5)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CertChain(_messages.Message):
  r"""A CertChain object.

  Fields:
    certificates: The certificates that form the CA chain, from leaf to root
      order.
  """

  certificates = _messages.StringField(1, repeated=True)


class Certificate(_messages.Message):
  r"""A Certificate corresponds to a signed X.509 certificate issued by a
  CertificateAuthority.

  Enums:
    SubjectModeValueValuesEnum: Immutable. Specifies how the Certificate's
      identity fields are to be decided. If this is omitted, the `DEFAULT`
      subject mode will be used.

  Messages:
    LabelsValue: Optional. Labels with user-defined metadata.

  Fields:
    certificateDescription: Output only. A structured description of the
      issued X.509 certificate.
    certificateTemplate: Immutable. The resource name for a
      CertificateTemplate used to issue this certificate, in the format
      `projects/*/locations/*/certificateTemplates/*`. If this is specified,
      the caller must have the necessary permission to use this template. If
      this is omitted, no template will be used. This template must be in the
      same location as the Certificate.
    config: Immutable. A description of the certificate and key that does not
      require X.509 or ASN.1.
    createTime: Output only. The time at which this Certificate was created.
    issuerCertificateAuthority: Output only. The resource name of the issuing
      CertificateAuthority in the format
      `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
    labels: Optional. Labels with user-defined metadata.
    lifetime: Required. Immutable. The desired lifetime of a certificate. Used
      to create the "not_before_time" and "not_after_time" fields inside an
      X.509 certificate. Note that the lifetime may be truncated if it would
      extend past the life of any certificate authority in the issuing chain.
    name: Output only. The resource name for this Certificate in the format
      `projects/*/locations/*/caPools/*/certificates/*`.
    pemCertificate: Output only. The pem-encoded, signed X.509 certificate.
    pemCertificateChain: Output only. The chain that may be used to verify the
      X.509 certificate. Expected to be in issuer-to-root order according to
      RFC 5246.
    pemCsr: Immutable. A pem-encoded X.509 certificate signing request (CSR).
    revocationDetails: Output only. Details regarding the revocation of this
      Certificate. This Certificate is considered revoked if and only if this
      field is present.
    subjectMode: Immutable. Specifies how the Certificate's identity fields
      are to be decided. If this is omitted, the `DEFAULT` subject mode will
      be used.
    updateTime: Output only. The time at which this Certificate was updated.
  """

  class SubjectModeValueValuesEnum(_messages.Enum):
    r"""Immutable. Specifies how the Certificate's identity fields are to be
    decided. If this is omitted, the `DEFAULT` subject mode will be used.

    Values:
      SUBJECT_REQUEST_MODE_UNSPECIFIED: Not specified.
      DEFAULT: The default mode used in most cases. Indicates that the
        certificate's Subject and/or SubjectAltNames are specified in the
        certificate request. This mode requires the caller to have the
        `privateca.certificates.create` permission.
      REFLECTED_SPIFFE: A mode reserved for special cases. Indicates that the
        certificate should have one SPIFFE SubjectAltNames set by the service
        based on the caller's identity. This mode will ignore any explicitly
        specified Subject and/or SubjectAltNames in the certificate request.
        This mode requires the caller to have the
        `privateca.certificates.createForSelf` permission.
    """
    SUBJECT_REQUEST_MODE_UNSPECIFIED = 0
    DEFAULT = 1
    REFLECTED_SPIFFE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels with user-defined metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  certificateDescription = _messages.MessageField('CertificateDescription', 1)
  certificateTemplate = _messages.StringField(2)
  config = _messages.MessageField('CertificateConfig', 3)
  createTime = _messages.StringField(4)
  issuerCertificateAuthority = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  lifetime = _messages.StringField(7)
  name = _messages.StringField(8)
  pemCertificate = _messages.StringField(9)
  pemCertificateChain = _messages.StringField(10, repeated=True)
  pemCsr = _messages.StringField(11)
  revocationDetails = _messages.MessageField('RevocationDetails', 12)
  subjectMode = _messages.EnumField('SubjectModeValueValuesEnum', 13)
  updateTime = _messages.StringField(14)


class CertificateAuthority(_messages.Message):
  r"""A CertificateAuthority represents an individual Certificate Authority. A
  CertificateAuthority can be used to create Certificates.

  Enums:
    StateValueValuesEnum: Output only. The State for this
      CertificateAuthority.
    TierValueValuesEnum: Output only. The CaPool.Tier of the CaPool that
      includes this CertificateAuthority.
    TypeValueValuesEnum: Required. Immutable. The Type of this
      CertificateAuthority.

  Messages:
    LabelsValue: Optional. Labels with user-defined metadata.

  Fields:
    accessUrls: Output only. URLs for accessing content published by this CA,
      such as the CA certificate and CRLs.
    caCertificateDescriptions: Output only. A structured description of this
      CertificateAuthority's CA certificate and its issuers. Ordered as self-
      to-root.
    config: Required. Immutable. The config used to create a self-signed X.509
      certificate or CSR.
    createTime: Output only. The time at which this CertificateAuthority was
      created.
    deleteTime: Output only. The time at which this CertificateAuthority was
      soft deleted, if it is in the DELETED state.
    expireTime: Output only. The time at which this CertificateAuthority will
      be permanently purged, if it is in the DELETED state.
    gcsBucket: Immutable. The name of a Cloud Storage bucket where this
      CertificateAuthority will publish content, such as the CA certificate
      and CRLs. This must be a bucket name, without any prefixes (such as
      `gs://`) or suffixes (such as `.googleapis.com`). For example, to use a
      bucket named `my-bucket`, you would simply specify `my-bucket`. If not
      specified, a managed bucket will be created.
    keySpec: Required. Immutable. Used when issuing certificates for this
      CertificateAuthority. If this CertificateAuthority is a self-signed
      CertificateAuthority, this key is also used to sign the self-signed CA
      certificate. Otherwise, it is used to sign a CSR.
    labels: Optional. Labels with user-defined metadata.
    lifetime: Required. Immutable. The desired lifetime of the CA certificate.
      Used to create the "not_before_time" and "not_after_time" fields inside
      an X.509 certificate.
    name: Output only. The resource name for this CertificateAuthority in the
      format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
    pemCaCertificates: Output only. This CertificateAuthority's certificate
      chain, including the current CertificateAuthority's certificate. Ordered
      such that the root issuer is the final element (consistent with RFC
      5246). For a self-signed CA, this will only list the current
      CertificateAuthority's certificate.
    state: Output only. The State for this CertificateAuthority.
    subordinateConfig: Optional. If this is a subordinate
      CertificateAuthority, this field will be set with the subordinate
      configuration, which describes its issuers. This may be updated, but
      this CertificateAuthority must continue to validate.
    tier: Output only. The CaPool.Tier of the CaPool that includes this
      CertificateAuthority.
    type: Required. Immutable. The Type of this CertificateAuthority.
    updateTime: Output only. The time at which this CertificateAuthority was
      last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The State for this CertificateAuthority.

    Values:
      STATE_UNSPECIFIED: Not specified.
      ENABLED: Certificates can be issued from this CA. CRLs will be generated
        for this CA. The CA will be part of the CaPool's trust anchor, and
        will be used to issue certificates from the CaPool.
      DISABLED: Certificates cannot be issued from this CA. CRLs will still be
        generated. The CA will be part of the CaPool's trust anchor, but will
        not be used to issue certificates from the CaPool.
      STAGED: Certificates can be issued from this CA. CRLs will be generated
        for this CA. The CA will be part of the CaPool's trust anchor, but
        will not be used to issue certificates from the CaPool.
      AWAITING_USER_ACTIVATION: Certificates cannot be issued from this CA.
        CRLs will not be generated. The CA will not be part of the CaPool's
        trust anchor, and will not be used to issue certificates from the
        CaPool.
      DELETED: Certificates cannot be issued from this CA. CRLs will not be
        generated. The CA may still be recovered by calling
        CertificateAuthorityService.UndeleteCertificateAuthority before
        expire_time. The CA will not be part of the CaPool's trust anchor, and
        will not be used to issue certificates from the CaPool.
    """
    STATE_UNSPECIFIED = 0
    ENABLED = 1
    DISABLED = 2
    STAGED = 3
    AWAITING_USER_ACTIVATION = 4
    DELETED = 5

  class TierValueValuesEnum(_messages.Enum):
    r"""Output only. The CaPool.Tier of the CaPool that includes this
    CertificateAuthority.

    Values:
      TIER_UNSPECIFIED: Not specified.
      ENTERPRISE: Enterprise tier.
      DEVOPS: DevOps tier.
    """
    TIER_UNSPECIFIED = 0
    ENTERPRISE = 1
    DEVOPS = 2

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The Type of this CertificateAuthority.

    Values:
      TYPE_UNSPECIFIED: Not specified.
      SELF_SIGNED: Self-signed CA.
      SUBORDINATE: Subordinate CA. Could be issued by a Private CA
        CertificateAuthority or an unmanaged CA.
    """
    TYPE_UNSPECIFIED = 0
    SELF_SIGNED = 1
    SUBORDINATE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels with user-defined metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  accessUrls = _messages.MessageField('AccessUrls', 1)
  caCertificateDescriptions = _messages.MessageField('CertificateDescription', 2, repeated=True)
  config = _messages.MessageField('CertificateConfig', 3)
  createTime = _messages.StringField(4)
  deleteTime = _messages.StringField(5)
  expireTime = _messages.StringField(6)
  gcsBucket = _messages.StringField(7)
  keySpec = _messages.MessageField('KeyVersionSpec', 8)
  labels = _messages.MessageField('LabelsValue', 9)
  lifetime = _messages.StringField(10)
  name = _messages.StringField(11)
  pemCaCertificates = _messages.StringField(12, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 13)
  subordinateConfig = _messages.MessageField('SubordinateConfig', 14)
  tier = _messages.EnumField('TierValueValuesEnum', 15)
  type = _messages.EnumField('TypeValueValuesEnum', 16)
  updateTime = _messages.StringField(17)


class CertificateConfig(_messages.Message):
  r"""A CertificateConfig describes an X.509 certificate or CSR that is to be
  created, as an alternative to using ASN.1.

  Fields:
    publicKey: Optional. The public key that corresponds to this config. This
      is, for example, used when issuing Certificates, but not when creating a
      self-signed CertificateAuthority or CertificateAuthority CSR.
    subjectConfig: Required. Specifies some of the values in a certificate
      that are related to the subject.
    x509Config: Required. Describes how some of the technical X.509 fields in
      a certificate should be populated.
  """

  publicKey = _messages.MessageField('PublicKey', 1)
  subjectConfig = _messages.MessageField('SubjectConfig', 2)
  x509Config = _messages.MessageField('X509Parameters', 3)


class CertificateDescription(_messages.Message):
  r"""A CertificateDescription describes an X.509 certificate or CSR that has
  been issued, as an alternative to using ASN.1 / X.509.

  Fields:
    aiaIssuingCertificateUrls: Describes lists of issuer CA certificate URLs
      that appear in the "Authority Information Access" extension in the
      certificate.
    authorityKeyId: Identifies the subject_key_id of the parent certificate,
      per https://tools.ietf.org/html/rfc5280#section-4.2.1.1
    certFingerprint: The hash of the x.509 certificate.
    crlDistributionPoints: Describes a list of locations to obtain CRL
      information, i.e. the DistributionPoint.fullName described by
      https://tools.ietf.org/html/rfc5280#section-4.2.1.13
    publicKey: The public key that corresponds to an issued certificate.
    subjectDescription: Describes some of the values in a certificate that are
      related to the subject and lifetime.
    subjectKeyId: Provides a means of identifiying certificates that contain a
      particular public key, per
      https://tools.ietf.org/html/rfc5280#section-4.2.1.2.
    x509Description: Describes some of the technical X.509 fields in a
      certificate.
  """

  aiaIssuingCertificateUrls = _messages.StringField(1, repeated=True)
  authorityKeyId = _messages.MessageField('KeyId', 2)
  certFingerprint = _messages.MessageField('CertificateFingerprint', 3)
  crlDistributionPoints = _messages.StringField(4, repeated=True)
  publicKey = _messages.MessageField('PublicKey', 5)
  subjectDescription = _messages.MessageField('SubjectDescription', 6)
  subjectKeyId = _messages.MessageField('KeyId', 7)
  x509Description = _messages.MessageField('X509Parameters', 8)


class CertificateExtensionConstraints(_messages.Message):
  r"""Describes a set of X.509 extensions that may be part of some certificate
  issuance controls.

  Enums:
    KnownExtensionsValueListEntryValuesEnum:

  Fields:
    additionalExtensions: Optional. A set of ObjectIds identifying custom
      X.509 extensions. Will be combined with known_extensions to determine
      the full set of X.509 extensions.
    knownExtensions: Optional. A set of named X.509 extensions. Will be
      combined with additional_extensions to determine the full set of X.509
      extensions.
  """

  class KnownExtensionsValueListEntryValuesEnum(_messages.Enum):
    r"""KnownExtensionsValueListEntryValuesEnum enum type.

    Values:
      KNOWN_CERTIFICATE_EXTENSION_UNSPECIFIED: Not specified.
      BASE_KEY_USAGE: Refers to a certificate's Key Usage extension, as
        described in [RFC 5280 section
        4.2.1.3](https://tools.ietf.org/html/rfc5280#section-4.2.1.3). This
        corresponds to the KeyUsage.base_key_usage field.
      EXTENDED_KEY_USAGE: Refers to a certificate's Extended Key Usage
        extension, as described in [RFC 5280 section
        4.2.1.12](https://tools.ietf.org/html/rfc5280#section-4.2.1.12). This
        corresponds to the KeyUsage.extended_key_usage message.
      CA_OPTIONS: Refers to a certificate's Basic Constraints extension, as
        described in [RFC 5280 section
        4.2.1.9](https://tools.ietf.org/html/rfc5280#section-4.2.1.9). This
        corresponds to the X509Parameters.ca_options field.
      POLICY_IDS: Refers to a certificate's Policy object identifiers, as
        described in [RFC 5280 section
        4.2.1.4](https://tools.ietf.org/html/rfc5280#section-4.2.1.4). This
        corresponds to the X509Parameters.policy_ids field.
      AIA_OCSP_SERVERS: Refers to OCSP servers in a certificate's Authority
        Information Access extension, as described in [RFC 5280 section
        4.2.2.1](https://tools.ietf.org/html/rfc5280#section-4.2.2.1), This
        corresponds to the X509Parameters.aia_ocsp_servers field.
      NAME_CONSTRAINTS: Refers to Name Constraints extension as described in
        [RFC 5280 section
        4.2.1.10](https://tools.ietf.org/html/rfc5280#section-4.2.1.10)
    """
    KNOWN_CERTIFICATE_EXTENSION_UNSPECIFIED = 0
    BASE_KEY_USAGE = 1
    EXTENDED_KEY_USAGE = 2
    CA_OPTIONS = 3
    POLICY_IDS = 4
    AIA_OCSP_SERVERS = 5
    NAME_CONSTRAINTS = 6

  additionalExtensions = _messages.MessageField('ObjectId', 1, repeated=True)
  knownExtensions = _messages.EnumField('KnownExtensionsValueListEntryValuesEnum', 2, repeated=True)


class CertificateFingerprint(_messages.Message):
  r"""A group of fingerprints for the x509 certificate.

  Fields:
    sha256Hash: The SHA 256 hash, encoded in hexadecimal, of the DER x509
      certificate.
  """

  sha256Hash = _messages.StringField(1)


class CertificateIdentityConstraints(_messages.Message):
  r"""Describes constraints on a Certificate's Subject and SubjectAltNames.

  Fields:
    allowSubjectAltNamesPassthrough: Required. If this is true, the
      SubjectAltNames extension may be copied from a certificate request into
      the signed certificate. Otherwise, the requested SubjectAltNames will be
      discarded.
    allowSubjectPassthrough: Required. If this is true, the Subject field may
      be copied from a certificate request into the signed certificate.
      Otherwise, the requested Subject will be discarded.
    celExpression: Optional. A CEL expression that may be used to validate the
      resolved X.509 Subject and/or Subject Alternative Name before a
      certificate is signed. To see the full allowed syntax and some examples,
      see https://cloud.google.com/certificate-authority-service/docs/using-
      cel
  """

  allowSubjectAltNamesPassthrough = _messages.BooleanField(1)
  allowSubjectPassthrough = _messages.BooleanField(2)
  celExpression = _messages.MessageField('Expr', 3)


class CertificateRevocationList(_messages.Message):
  r"""A CertificateRevocationList corresponds to a signed X.509 certificate
  Revocation List (CRL). A CRL contains the serial numbers of certificates
  that should no longer be trusted.

  Enums:
    StateValueValuesEnum: Output only. The State for this
      CertificateRevocationList.

  Messages:
    LabelsValue: Optional. Labels with user-defined metadata.

  Fields:
    accessUrl: Output only. The location where 'pem_crl' can be accessed.
    createTime: Output only. The time at which this CertificateRevocationList
      was created.
    labels: Optional. Labels with user-defined metadata.
    name: Output only. The resource name for this CertificateRevocationList in
      the format `projects/*/locations/*/caPools/*certificateAuthorities/*/
      certificateRevocationLists/*`.
    pemCrl: Output only. The PEM-encoded X.509 CRL.
    revisionId: Output only. The revision ID of this
      CertificateRevocationList. A new revision is committed whenever a new
      CRL is published. The format is an 8-character hexadecimal string.
    revokedCertificates: Output only. The revoked serial numbers that appear
      in pem_crl.
    sequenceNumber: Output only. The CRL sequence number that appears in
      pem_crl.
    state: Output only. The State for this CertificateRevocationList.
    updateTime: Output only. The time at which this CertificateRevocationList
      was updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The State for this CertificateRevocationList.

    Values:
      STATE_UNSPECIFIED: Not specified.
      ACTIVE: The CertificateRevocationList is up to date.
      SUPERSEDED: The CertificateRevocationList is no longer current.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    SUPERSEDED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels with user-defined metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  accessUrl = _messages.StringField(1)
  createTime = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  pemCrl = _messages.StringField(5)
  revisionId = _messages.StringField(6)
  revokedCertificates = _messages.MessageField('RevokedCertificate', 7, repeated=True)
  sequenceNumber = _messages.IntegerField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  updateTime = _messages.StringField(10)


class CertificateTemplate(_messages.Message):
  r"""A CertificateTemplate refers to a managed template for certificate
  issuance.

  Messages:
    LabelsValue: Optional. Labels with user-defined metadata.

  Fields:
    createTime: Output only. The time at which this CertificateTemplate was
      created.
    description: Optional. A human-readable description of scenarios this
      template is intended for.
    identityConstraints: Optional. Describes constraints on identities that
      may be appear in Certificates issued using this template. If this is
      omitted, then this template will not add restrictions on a certificate's
      identity.
    labels: Optional. Labels with user-defined metadata.
    name: Output only. The resource name for this CertificateTemplate in the
      format `projects/*/locations/*/certificateTemplates/*`.
    passthroughExtensions: Optional. Describes the set of X.509 extensions
      that may appear in a Certificate issued using this CertificateTemplate.
      If a certificate request sets extensions that don't appear in the
      passthrough_extensions, those extensions will be dropped. If the issuing
      CaPool's IssuancePolicy defines baseline_values that don't appear here,
      the certificate issuance request will fail. If this is omitted, then
      this template will not add restrictions on a certificate's X.509
      extensions. These constraints do not apply to X.509 extensions set in
      this CertificateTemplate's predefined_values.
    predefinedValues: Optional. A set of X.509 values that will be applied to
      all issued certificates that use this template. If the certificate
      request includes conflicting values for the same properties, they will
      be overwritten by the values defined here. If the issuing CaPool's
      IssuancePolicy defines conflicting baseline_values for the same
      properties, the certificate issuance request will fail.
    updateTime: Output only. The time at which this CertificateTemplate was
      updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels with user-defined metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  identityConstraints = _messages.MessageField('CertificateIdentityConstraints', 3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  passthroughExtensions = _messages.MessageField('CertificateExtensionConstraints', 6)
  predefinedValues = _messages.MessageField('X509Parameters', 7)
  updateTime = _messages.StringField(8)


class DisableCertificateAuthorityRequest(_messages.Message):
  r"""Request message for
  CertificateAuthorityService.DisableCertificateAuthority.

  Fields:
    ignoreDependentResources: Optional. This field allows this CA to be
      disabled even if it's being depended on by another resource. However,
      doing so may result in unintended and unrecoverable effects on any
      dependent resource(s) since the CA will no longer be able to issue
      certificates.
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  ignoreDependentResources = _messages.BooleanField(1)
  requestId = _messages.StringField(2)


class EcKeyType(_messages.Message):
  r"""Describes an Elliptic Curve key that may be used in a Certificate issued
  from a CaPool.

  Enums:
    SignatureAlgorithmValueValuesEnum: Optional. A signature algorithm that
      must be used. If this is omitted, any EC-based signature algorithm will
      be allowed.

  Fields:
    signatureAlgorithm: Optional. A signature algorithm that must be used. If
      this is omitted, any EC-based signature algorithm will be allowed.
  """

  class SignatureAlgorithmValueValuesEnum(_messages.Enum):
    r"""Optional. A signature algorithm that must be used. If this is omitted,
    any EC-based signature algorithm will be allowed.

    Values:
      EC_SIGNATURE_ALGORITHM_UNSPECIFIED: Not specified. Signifies that any
        signature algorithm may be used.
      ECDSA_P256: Refers to the Elliptic Curve Digital Signature Algorithm
        over the NIST P-256 curve.
      ECDSA_P384: Refers to the Elliptic Curve Digital Signature Algorithm
        over the NIST P-384 curve.
      EDDSA_25519: Refers to the Edwards-curve Digital Signature Algorithm
        over curve 25519, as described in RFC 8410.
    """
    EC_SIGNATURE_ALGORITHM_UNSPECIFIED = 0
    ECDSA_P256 = 1
    ECDSA_P384 = 2
    EDDSA_25519 = 3

  signatureAlgorithm = _messages.EnumField('SignatureAlgorithmValueValuesEnum', 1)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class EnableCertificateAuthorityRequest(_messages.Message):
  r"""Request message for
  CertificateAuthorityService.EnableCertificateAuthority.

  Fields:
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  requestId = _messages.StringField(1)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class ExtendedKeyUsageOptions(_messages.Message):
  r"""KeyUsage.ExtendedKeyUsageOptions has fields that correspond to certain
  common OIDs that could be specified as an extended key usage value.

  Fields:
    clientAuth: Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as
      "TLS WWW client authentication", though regularly used for non-WWW TLS.
    codeSigning: Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as
      "Signing of downloadable executable code client authentication".
    emailProtection: Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially
      described as "Email protection".
    ocspSigning: Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as
      "Signing OCSP responses".
    serverAuth: Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as
      "TLS WWW server authentication", though regularly used for non-WWW TLS.
    timeStamping: Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described
      as "Binding the hash of an object to a time".
  """

  clientAuth = _messages.BooleanField(1)
  codeSigning = _messages.BooleanField(2)
  emailProtection = _messages.BooleanField(3)
  ocspSigning = _messages.BooleanField(4)
  serverAuth = _messages.BooleanField(5)
  timeStamping = _messages.BooleanField(6)


class FetchCaCertsRequest(_messages.Message):
  r"""Request message for CertificateAuthorityService.FetchCaCerts.

  Fields:
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  requestId = _messages.StringField(1)


class FetchCaCertsResponse(_messages.Message):
  r"""Response message for CertificateAuthorityService.FetchCaCerts.

  Fields:
    caCerts: The PEM encoded CA certificate chains of all ACTIVE
      CertificateAuthority resources in this CaPool.
  """

  caCerts = _messages.MessageField('CertChain', 1, repeated=True)


class FetchCertificateAuthorityCsrResponse(_messages.Message):
  r"""Response message for
  CertificateAuthorityService.FetchCertificateAuthorityCsr.

  Fields:
    pemCsr: Output only. The PEM-encoded signed certificate signing request
      (CSR).
  """

  pemCsr = _messages.StringField(1)


class IssuanceModes(_messages.Message):
  r"""IssuanceModes specifies the allowed ways in which Certificates may be
  requested from this CaPool.

  Fields:
    allowConfigBasedIssuance: Optional. When true, allows callers to create
      Certificates by specifying a CertificateConfig.
    allowCsrBasedIssuance: Optional. When true, allows callers to create
      Certificates by specifying a CSR.
  """

  allowConfigBasedIssuance = _messages.BooleanField(1)
  allowCsrBasedIssuance = _messages.BooleanField(2)


class IssuancePolicy(_messages.Message):
  r"""Defines controls over all certificate issuance within a CaPool.

  Fields:
    allowedIssuanceModes: Optional. If specified, then only methods allowed in
      the IssuanceModes may be used to issue Certificates.
    allowedKeyTypes: Optional. If any AllowedKeyType is specified, then the
      certificate request's public key must match one of the key types listed
      here. Otherwise, any key may be used.
    baselineValues: Optional. A set of X.509 values that will be applied to
      all certificates issued through this CaPool. If a certificate request
      includes conflicting values for the same properties, they will be
      overwritten by the values defined here. If a certificate request uses a
      CertificateTemplate that defines conflicting predefined_values for the
      same properties, the certificate issuance request will fail.
    identityConstraints: Optional. Describes constraints on identities that
      may appear in Certificates issued through this CaPool. If this is
      omitted, then this CaPool will not add restrictions on a certificate's
      identity.
    maximumLifetime: Optional. The maximum lifetime allowed for issued
      Certificates. Note that if the issuing CertificateAuthority expires
      before a Certificate's requested maximum_lifetime, the effective
      lifetime will be explicitly truncated to match it.
    passthroughExtensions: Optional. Describes the set of X.509 extensions
      that may appear in a Certificate issued through this CaPool. If a
      certificate request sets extensions that don't appear in the
      passthrough_extensions, those extensions will be dropped. If a
      certificate request uses a CertificateTemplate with predefined_values
      that don't appear here, the certificate issuance request will fail. If
      this is omitted, then this CaPool will not add restrictions on a
      certificate's X.509 extensions. These constraints do not apply to X.509
      extensions set in this CaPool's baseline_values.
  """

  allowedIssuanceModes = _messages.MessageField('IssuanceModes', 1)
  allowedKeyTypes = _messages.MessageField('AllowedKeyType', 2, repeated=True)
  baselineValues = _messages.MessageField('X509Parameters', 3)
  identityConstraints = _messages.MessageField('CertificateIdentityConstraints', 4)
  maximumLifetime = _messages.StringField(5)
  passthroughExtensions = _messages.MessageField('CertificateExtensionConstraints', 6)


class KeyId(_messages.Message):
  r"""A KeyId identifies a specific public key, usually by hashing the public
  key.

  Fields:
    keyId: Optional. The value of this KeyId encoded in lowercase hexadecimal.
      This is most likely the 160 bit SHA-1 hash of the public key.
  """

  keyId = _messages.StringField(1)


class KeyUsage(_messages.Message):
  r"""A KeyUsage describes key usage values that may appear in an X.509
  certificate.

  Fields:
    baseKeyUsage: Describes high-level ways in which a key may be used.
    extendedKeyUsage: Detailed scenarios in which a key may be used.
    unknownExtendedKeyUsages: Used to describe extended key usages that are
      not listed in the KeyUsage.ExtendedKeyUsageOptions message.
  """

  baseKeyUsage = _messages.MessageField('KeyUsageOptions', 1)
  extendedKeyUsage = _messages.MessageField('ExtendedKeyUsageOptions', 2)
  unknownExtendedKeyUsages = _messages.MessageField('ObjectId', 3, repeated=True)


class KeyUsageOptions(_messages.Message):
  r"""KeyUsage.KeyUsageOptions corresponds to the key usage values described
  in https://tools.ietf.org/html/rfc5280#section-4.2.1.3.

  Fields:
    certSign: The key may be used to sign certificates.
    contentCommitment: The key may be used for cryptographic commitments. Note
      that this may also be referred to as "non-repudiation".
    crlSign: The key may be used sign certificate revocation lists.
    dataEncipherment: The key may be used to encipher data.
    decipherOnly: The key may be used to decipher only.
    digitalSignature: The key may be used for digital signatures.
    encipherOnly: The key may be used to encipher only.
    keyAgreement: The key may be used in a key agreement protocol.
    keyEncipherment: The key may be used to encipher other keys.
  """

  certSign = _messages.BooleanField(1)
  contentCommitment = _messages.BooleanField(2)
  crlSign = _messages.BooleanField(3)
  dataEncipherment = _messages.BooleanField(4)
  decipherOnly = _messages.BooleanField(5)
  digitalSignature = _messages.BooleanField(6)
  encipherOnly = _messages.BooleanField(7)
  keyAgreement = _messages.BooleanField(8)
  keyEncipherment = _messages.BooleanField(9)


class KeyVersionSpec(_messages.Message):
  r"""A Cloud KMS key configuration that a CertificateAuthority will use.

  Enums:
    AlgorithmValueValuesEnum: The algorithm to use for creating a managed
      Cloud KMS key for a for a simplified experience. All managed keys will
      be have their ProtectionLevel as `HSM`.

  Fields:
    algorithm: The algorithm to use for creating a managed Cloud KMS key for a
      for a simplified experience. All managed keys will be have their
      ProtectionLevel as `HSM`.
    cloudKmsKeyVersion: The resource name for an existing Cloud KMS
      CryptoKeyVersion in the format
      `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`.
      This option enables full flexibility in the key's capabilities and
      properties.
  """

  class AlgorithmValueValuesEnum(_messages.Enum):
    r"""The algorithm to use for creating a managed Cloud KMS key for a for a
    simplified experience. All managed keys will be have their ProtectionLevel
    as `HSM`.

    Values:
      SIGN_HASH_ALGORITHM_UNSPECIFIED: Not specified.
      RSA_PSS_2048_SHA256: maps to
        CryptoKeyVersionAlgorithm.RSA_SIGN_PSS_2048_SHA256
      RSA_PSS_3072_SHA256: maps to CryptoKeyVersionAlgorithm.
        RSA_SIGN_PSS_3072_SHA256
      RSA_PSS_4096_SHA256: maps to
        CryptoKeyVersionAlgorithm.RSA_SIGN_PSS_4096_SHA256
      RSA_PKCS1_2048_SHA256: maps to
        CryptoKeyVersionAlgorithm.RSA_SIGN_PKCS1_2048_SHA256
      RSA_PKCS1_3072_SHA256: maps to
        CryptoKeyVersionAlgorithm.RSA_SIGN_PKCS1_3072_SHA256
      RSA_PKCS1_4096_SHA256: maps to
        CryptoKeyVersionAlgorithm.RSA_SIGN_PKCS1_4096_SHA256
      EC_P256_SHA256: maps to CryptoKeyVersionAlgorithm.EC_SIGN_P256_SHA256
      EC_P384_SHA384: maps to CryptoKeyVersionAlgorithm.EC_SIGN_P384_SHA384
    """
    SIGN_HASH_ALGORITHM_UNSPECIFIED = 0
    RSA_PSS_2048_SHA256 = 1
    RSA_PSS_3072_SHA256 = 2
    RSA_PSS_4096_SHA256 = 3
    RSA_PKCS1_2048_SHA256 = 4
    RSA_PKCS1_3072_SHA256 = 5
    RSA_PKCS1_4096_SHA256 = 6
    EC_P256_SHA256 = 7
    EC_P384_SHA384 = 8

  algorithm = _messages.EnumField('AlgorithmValueValuesEnum', 1)
  cloudKmsKeyVersion = _messages.StringField(2)


class ListCaPoolsResponse(_messages.Message):
  r"""Response message for CertificateAuthorityService.ListCaPools.

  Fields:
    caPools: The list of CaPools.
    nextPageToken: A token to retrieve next page of results. Pass this value
      in ListCertificateAuthoritiesRequest.next_page_token to retrieve the
      next page of results.
    unreachable: A list of locations (e.g. "us-west1") that could not be
      reached.
  """

  caPools = _messages.MessageField('CaPool', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListCertificateAuthoritiesResponse(_messages.Message):
  r"""Response message for
  CertificateAuthorityService.ListCertificateAuthorities.

  Fields:
    certificateAuthorities: The list of CertificateAuthorities.
    nextPageToken: A token to retrieve next page of results. Pass this value
      in ListCertificateAuthoritiesRequest.next_page_token to retrieve the
      next page of results.
    unreachable: A list of locations (e.g. "us-west1") that could not be
      reached.
  """

  certificateAuthorities = _messages.MessageField('CertificateAuthority', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListCertificateRevocationListsResponse(_messages.Message):
  r"""Response message for
  CertificateAuthorityService.ListCertificateRevocationLists.

  Fields:
    certificateRevocationLists: The list of CertificateRevocationLists.
    nextPageToken: A token to retrieve next page of results. Pass this value
      in ListCertificateRevocationListsRequest.next_page_token to retrieve the
      next page of results.
    unreachable: A list of locations (e.g. "us-west1") that could not be
      reached.
  """

  certificateRevocationLists = _messages.MessageField('CertificateRevocationList', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListCertificateTemplatesResponse(_messages.Message):
  r"""Response message for
  CertificateAuthorityService.ListCertificateTemplates.

  Fields:
    certificateTemplates: The list of CertificateTemplates.
    nextPageToken: A token to retrieve next page of results. Pass this value
      in ListCertificateTemplatesRequest.next_page_token to retrieve the next
      page of results.
    unreachable: A list of locations (e.g. "us-west1") that could not be
      reached.
  """

  certificateTemplates = _messages.MessageField('CertificateTemplate', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListCertificatesResponse(_messages.Message):
  r"""Response message for CertificateAuthorityService.ListCertificates.

  Fields:
    certificates: The list of Certificates.
    nextPageToken: A token to retrieve next page of results. Pass this value
      in ListCertificatesRequest.next_page_token to retrieve the next page of
      results.
    unreachable: A list of locations (e.g. "us-west1") that could not be
      reached.
  """

  certificates = _messages.MessageField('Certificate', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class NameConstraints(_messages.Message):
  r"""Describes the X.509 name constraints extension, per
  https://tools.ietf.org/html/rfc5280#section-4.2.1.10

  Fields:
    critical: Indicates whether or not the name constraints are marked
      critical.
    excludedDnsNames: Contains excluded DNS names. Any DNS name that can be
      constructed by simply adding zero or more labels to the left-hand side
      of the name satisfies the name constraint. For example, `example.com`,
      `www.example.com`, `www.sub.example.com` would satisfy `example.com`
      while `example1.com` does not.
    excludedEmailAddresses: Contains the excluded email addresses. The value
      can be a particular email address, a hostname to indicate all email
      addresses on that host or a domain with a leading period (e.g.
      `.example.com`) to indicate all email addresses in that domain.
    excludedIpRanges: Contains the excluded IP ranges. For IPv4 addresses, the
      ranges are expressed using CIDR notation as specified in RFC 4632. For
      IPv6 addresses, the ranges are expressed in similar encoding as IPv4
      addresses.
    excludedUris: Contains the excluded URIs that apply to the host part of
      the name. The value can be a hostname or a domain with a leading period
      (like `.example.com`)
    permittedDnsNames: Contains permitted DNS names. Any DNS name that can be
      constructed by simply adding zero or more labels to the left-hand side
      of the name satisfies the name constraint. For example, `example.com`,
      `www.example.com`, `www.sub.example.com` would satisfy `example.com`
      while `example1.com` does not.
    permittedEmailAddresses: Contains the permitted email addresses. The value
      can be a particular email address, a hostname to indicate all email
      addresses on that host or a domain with a leading period (e.g.
      `.example.com`) to indicate all email addresses in that domain.
    permittedIpRanges: Contains the permitted IP ranges. For IPv4 addresses,
      the ranges are expressed using CIDR notation as specified in RFC 4632.
      For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
      addresses.
    permittedUris: Contains the permitted URIs that apply to the host part of
      the name. The value can be a hostname or a domain with a leading period
      (like `.example.com`)
  """

  critical = _messages.BooleanField(1)
  excludedDnsNames = _messages.StringField(2, repeated=True)
  excludedEmailAddresses = _messages.StringField(3, repeated=True)
  excludedIpRanges = _messages.StringField(4, repeated=True)
  excludedUris = _messages.StringField(5, repeated=True)
  permittedDnsNames = _messages.StringField(6, repeated=True)
  permittedEmailAddresses = _messages.StringField(7, repeated=True)
  permittedIpRanges = _messages.StringField(8, repeated=True)
  permittedUris = _messages.StringField(9, repeated=True)


class ObjectId(_messages.Message):
  r"""An ObjectId specifies an object identifier (OID). These provide context
  and describe types in ASN.1 messages.

  Fields:
    objectIdPath: Required. The parts of an OID path. The most significant
      parts of the path come first.
  """

  objectIdPath = _messages.IntegerField(1, repeated=True, variant=_messages.Variant.INT32)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesActivateRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesActivateRequest
  object.

  Fields:
    activateCertificateAuthorityRequest: A ActivateCertificateAuthorityRequest
      resource to be passed as the request body.
    name: Required. The resource name for this CertificateAuthority in the
      format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
  """

  activateCertificateAuthorityRequest = _messages.MessageField('ActivateCertificateAuthorityRequest', 1)
  name = _messages.StringField(2, required=True)


class PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesCertificateRevocationListsGetIamPolicyRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesCertificateRevo
  cationListsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesCertificateRevocationListsGetRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesCertificateRevo
  cationListsGetRequest object.

  Fields:
    name: Required. The name of the CertificateRevocationList to get.
  """

  name = _messages.StringField(1, required=True)


class PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesCertificateRevocationListsListRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesCertificateRevo
  cationListsListRequest object.

  Fields:
    filter: Optional. Only include resources that match the filter in the
      response.
    orderBy: Optional. Specify how the results should be sorted.
    pageSize: Optional. Limit on the number of CertificateRevocationLists to
      include in the response. Further CertificateRevocationLists can
      subsequently be obtained by including the
      ListCertificateRevocationListsResponse.next_page_token in a subsequent
      request. If unspecified, the server will pick an appropriate default.
    pageToken: Optional. Pagination token, returned earlier via
      ListCertificateRevocationListsResponse.next_page_token.
    parent: Required. The resource name of the location associated with the
      CertificateRevocationLists, in the format
      `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesCertificateRevocationListsPatchRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesCertificateRevo
  cationListsPatchRequest object.

  Fields:
    certificateRevocationList: A CertificateRevocationList resource to be
      passed as the request body.
    name: Output only. The resource name for this CertificateRevocationList in
      the format `projects/*/locations/*/caPools/*certificateAuthorities/*/
      certificateRevocationLists/*`.
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Required. A list of fields to be updated in this request.
  """

  certificateRevocationList = _messages.MessageField('CertificateRevocationList', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesCertificateRevocationListsSetIamPolicyRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesCertificateRevo
  cationListsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesCertificateRevocationListsTestIamPermissionsRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesCertificateRevo
  cationListsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesCreateRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesCreateRequest
  object.

  Fields:
    certificateAuthority: A CertificateAuthority resource to be passed as the
      request body.
    certificateAuthorityId: Required. It must be unique within a location and
      match the regular expression `[a-zA-Z0-9_-]{1,63}`
    parent: Required. The resource name of the CaPool associated with the
      CertificateAuthorities, in the format
      `projects/*/locations/*/caPools/*`.
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  certificateAuthority = _messages.MessageField('CertificateAuthority', 1)
  certificateAuthorityId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesDeleteRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesDeleteRequest
  object.

  Fields:
    ignoreActiveCertificates: Optional. This field allows the CA to be deleted
      even if the CA has active certs. Active certs include both unrevoked and
      unexpired certs.
    ignoreDependentResources: Optional. This field allows this ca to be
      deleted even if it's being depended on by another resource. However,
      doing so may result in unintended and unrecoverable effects on any
      dependent resource(s) since the CA will no longer be able to issue
      certificates.
    name: Required. The resource name for this CertificateAuthority in the
      format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    skipGracePeriod: Optional. If this flag is set, the Certificate Authority
      will be deleted as soon as possible without a 30-day grace period where
      undeletion would have been allowed. If you proceed, there will be no way
      to recover this CA.
  """

  ignoreActiveCertificates = _messages.BooleanField(1)
  ignoreDependentResources = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  skipGracePeriod = _messages.BooleanField(5)


class PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesDisableRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesDisableRequest
  object.

  Fields:
    disableCertificateAuthorityRequest: A DisableCertificateAuthorityRequest
      resource to be passed as the request body.
    name: Required. The resource name for this CertificateAuthority in the
      format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
  """

  disableCertificateAuthorityRequest = _messages.MessageField('DisableCertificateAuthorityRequest', 1)
  name = _messages.StringField(2, required=True)


class PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesEnableRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesEnableRequest
  object.

  Fields:
    enableCertificateAuthorityRequest: A EnableCertificateAuthorityRequest
      resource to be passed as the request body.
    name: Required. The resource name for this CertificateAuthority in the
      format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
  """

  enableCertificateAuthorityRequest = _messages.MessageField('EnableCertificateAuthorityRequest', 1)
  name = _messages.StringField(2, required=True)


class PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesFetchRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesFetchRequest
  object.

  Fields:
    name: Required. The resource name for this CertificateAuthority in the
      format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
  """

  name = _messages.StringField(1, required=True)


class PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesGetRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesGetRequest
  object.

  Fields:
    name: Required. The name of the CertificateAuthority to get.
  """

  name = _messages.StringField(1, required=True)


class PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesListRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesListRequest
  object.

  Fields:
    filter: Optional. Only include resources that match the filter in the
      response.
    orderBy: Optional. Specify how the results should be sorted.
    pageSize: Optional. Limit on the number of CertificateAuthorities to
      include in the response. Further CertificateAuthorities can subsequently
      be obtained by including the
      ListCertificateAuthoritiesResponse.next_page_token in a subsequent
      request. If unspecified, the server will pick an appropriate default.
    pageToken: Optional. Pagination token, returned earlier via
      ListCertificateAuthoritiesResponse.next_page_token.
    parent: Required. The resource name of the CaPool associated with the
      CertificateAuthorities, in the format
      `projects/*/locations/*/caPools/*`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesPatchRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesPatchRequest
  object.

  Fields:
    certificateAuthority: A CertificateAuthority resource to be passed as the
      request body.
    name: Output only. The resource name for this CertificateAuthority in the
      format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Required. A list of fields to be updated in this request.
  """

  certificateAuthority = _messages.MessageField('CertificateAuthority', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesUndeleteRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificateAuthoritiesUndeleteRequest
  object.

  Fields:
    name: Required. The resource name for this CertificateAuthority in the
      format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
    undeleteCertificateAuthorityRequest: A UndeleteCertificateAuthorityRequest
      resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  undeleteCertificateAuthorityRequest = _messages.MessageField('UndeleteCertificateAuthorityRequest', 2)


class PrivatecaProjectsLocationsCaPoolsCertificatesCreateRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificatesCreateRequest object.

  Fields:
    certificate: A Certificate resource to be passed as the request body.
    certificateId: Optional. It must be unique within a location and match the
      regular expression `[a-zA-Z0-9_-]{1,63}`. This field is required when
      using a CertificateAuthority in the Enterprise
      CertificateAuthority.Tier, but is optional and its value is ignored
      otherwise.
    issuingCertificateAuthorityId: Optional. The resource ID of the
      CertificateAuthority that should issue the certificate. This optional
      field will ignore the load-balancing scheme of the Pool and directly
      issue the certificate from the CA with the specified ID, contained in
      the same CaPool referenced by `parent`. Per-CA quota rules apply. If
      left empty, a CertificateAuthority will be chosen from the CaPool by the
      service. For example, to issue a Certificate from a Certificate
      Authority with resource name "projects/my-project/locations/us-
      central1/caPools/my-pool/certificateAuthorities/my-ca", you can set the
      parent to "projects/my-project/locations/us-central1/caPools/my-pool"
      and the issuing_certificate_authority_id to "my-ca".
    parent: Required. The resource name of the CaPool associated with the
      Certificate, in the format `projects/*/locations/*/caPools/*`.
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. If this is true, no Certificate resource will be
      persisted regardless of the CaPool's tier, and the returned Certificate
      will not contain the pem_certificate field.
  """

  certificate = _messages.MessageField('Certificate', 1)
  certificateId = _messages.StringField(2)
  issuingCertificateAuthorityId = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)
  validateOnly = _messages.BooleanField(6)


class PrivatecaProjectsLocationsCaPoolsCertificatesGetRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificatesGetRequest object.

  Fields:
    name: Required. The name of the Certificate to get.
  """

  name = _messages.StringField(1, required=True)


class PrivatecaProjectsLocationsCaPoolsCertificatesListRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificatesListRequest object.

  Fields:
    filter: Optional. Only include resources that match the filter in the
      response. For details on supported filters and syntax, see [Certificates
      Filtering documentation](https://cloud.google.com/certificate-authority-
      service/docs/sorting-filtering-certificates#filtering_support).
    orderBy: Optional. Specify how the results should be sorted. For details
      on supported fields and syntax, see [Certificates Sorting
      documentation](https://cloud.google.com/certificate-authority-
      service/docs/sorting-filtering-certificates#sorting_support).
    pageSize: Optional. Limit on the number of Certificates to include in the
      response. Further Certificates can subsequently be obtained by including
      the ListCertificatesResponse.next_page_token in a subsequent request. If
      unspecified, the server will pick an appropriate default.
    pageToken: Optional. Pagination token, returned earlier via
      ListCertificatesResponse.next_page_token.
    parent: Required. The resource name of the location associated with the
      Certificates, in the format `projects/*/locations/*/caPools/*`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class PrivatecaProjectsLocationsCaPoolsCertificatesPatchRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificatesPatchRequest object.

  Fields:
    certificate: A Certificate resource to be passed as the request body.
    name: Output only. The resource name for this Certificate in the format
      `projects/*/locations/*/caPools/*/certificates/*`.
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Required. A list of fields to be updated in this request.
  """

  certificate = _messages.MessageField('Certificate', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class PrivatecaProjectsLocationsCaPoolsCertificatesRevokeRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCertificatesRevokeRequest object.

  Fields:
    name: Required. The resource name for this Certificate in the format
      `projects/*/locations/*/caPools/*/certificates/*`.
    revokeCertificateRequest: A RevokeCertificateRequest resource to be passed
      as the request body.
  """

  name = _messages.StringField(1, required=True)
  revokeCertificateRequest = _messages.MessageField('RevokeCertificateRequest', 2)


class PrivatecaProjectsLocationsCaPoolsCreateRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsCreateRequest object.

  Fields:
    caPool: A CaPool resource to be passed as the request body.
    caPoolId: Required. It must be unique within a location and match the
      regular expression `[a-zA-Z0-9_-]{1,63}`
    parent: Required. The resource name of the location associated with the
      CaPool, in the format `projects/*/locations/*`.
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  caPool = _messages.MessageField('CaPool', 1)
  caPoolId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class PrivatecaProjectsLocationsCaPoolsDeleteRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsDeleteRequest object.

  Fields:
    ignoreDependentResources: Optional. This field allows this pool to be
      deleted even if it's being depended on by another resource. However,
      doing so may result in unintended and unrecoverable effects on any
      dependent resource(s) since the pool will no longer be able to issue
      certificates.
    name: Required. The resource name for this CaPool in the format
      `projects/*/locations/*/caPools/*`.
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  ignoreDependentResources = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class PrivatecaProjectsLocationsCaPoolsFetchCaCertsRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsFetchCaCertsRequest object.

  Fields:
    caPool: Required. The resource name for the CaPool in the format
      `projects/*/locations/*/caPools/*`.
    fetchCaCertsRequest: A FetchCaCertsRequest resource to be passed as the
      request body.
  """

  caPool = _messages.StringField(1, required=True)
  fetchCaCertsRequest = _messages.MessageField('FetchCaCertsRequest', 2)


class PrivatecaProjectsLocationsCaPoolsGetIamPolicyRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class PrivatecaProjectsLocationsCaPoolsGetRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsGetRequest object.

  Fields:
    name: Required. The name of the CaPool to get.
  """

  name = _messages.StringField(1, required=True)


class PrivatecaProjectsLocationsCaPoolsListRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsListRequest object.

  Fields:
    filter: Optional. Only include resources that match the filter in the
      response.
    orderBy: Optional. Specify how the results should be sorted.
    pageSize: Optional. Limit on the number of CaPools to include in the
      response. Further CaPools can subsequently be obtained by including the
      ListCaPoolsResponse.next_page_token in a subsequent request. If
      unspecified, the server will pick an appropriate default.
    pageToken: Optional. Pagination token, returned earlier via
      ListCaPoolsResponse.next_page_token.
    parent: Required. The resource name of the location associated with the
      CaPools, in the format `projects/*/locations/*`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class PrivatecaProjectsLocationsCaPoolsPatchRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsPatchRequest object.

  Fields:
    caPool: A CaPool resource to be passed as the request body.
    name: Output only. The resource name for this CaPool in the format
      `projects/*/locations/*/caPools/*`.
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Required. A list of fields to be updated in this request.
  """

  caPool = _messages.MessageField('CaPool', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class PrivatecaProjectsLocationsCaPoolsSetIamPolicyRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class PrivatecaProjectsLocationsCaPoolsTestIamPermissionsRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCaPoolsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class PrivatecaProjectsLocationsCertificateTemplatesCreateRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCertificateTemplatesCreateRequest object.

  Fields:
    certificateTemplate: A CertificateTemplate resource to be passed as the
      request body.
    certificateTemplateId: Required. It must be unique within a location and
      match the regular expression `[a-zA-Z0-9_-]{1,63}`
    parent: Required. The resource name of the location associated with the
      CertificateTemplate, in the format `projects/*/locations/*`.
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  certificateTemplate = _messages.MessageField('CertificateTemplate', 1)
  certificateTemplateId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class PrivatecaProjectsLocationsCertificateTemplatesDeleteRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCertificateTemplatesDeleteRequest object.

  Fields:
    name: Required. The resource name for this CertificateTemplate in the
      format `projects/*/locations/*/certificateTemplates/*`.
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class PrivatecaProjectsLocationsCertificateTemplatesGetIamPolicyRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCertificateTemplatesGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class PrivatecaProjectsLocationsCertificateTemplatesGetRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCertificateTemplatesGetRequest object.

  Fields:
    name: Required. The name of the CertificateTemplate to get.
  """

  name = _messages.StringField(1, required=True)


class PrivatecaProjectsLocationsCertificateTemplatesListRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCertificateTemplatesListRequest object.

  Fields:
    filter: Optional. Only include resources that match the filter in the
      response.
    orderBy: Optional. Specify how the results should be sorted.
    pageSize: Optional. Limit on the number of CertificateTemplates to include
      in the response. Further CertificateTemplates can subsequently be
      obtained by including the
      ListCertificateTemplatesResponse.next_page_token in a subsequent
      request. If unspecified, the server will pick an appropriate default.
    pageToken: Optional. Pagination token, returned earlier via
      ListCertificateTemplatesResponse.next_page_token.
    parent: Required. The resource name of the location associated with the
      CertificateTemplates, in the format `projects/*/locations/*`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class PrivatecaProjectsLocationsCertificateTemplatesPatchRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCertificateTemplatesPatchRequest object.

  Fields:
    certificateTemplate: A CertificateTemplate resource to be passed as the
      request body.
    name: Output only. The resource name for this CertificateTemplate in the
      format `projects/*/locations/*/certificateTemplates/*`.
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Required. A list of fields to be updated in this request.
  """

  certificateTemplate = _messages.MessageField('CertificateTemplate', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class PrivatecaProjectsLocationsCertificateTemplatesSetIamPolicyRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsCertificateTemplatesSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class PrivatecaProjectsLocationsCertificateTemplatesTestIamPermissionsRequest(_messages.Message):
  r"""A
  PrivatecaProjectsLocationsCertificateTemplatesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class PrivatecaProjectsLocationsGetRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class PrivatecaProjectsLocationsListRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class PrivatecaProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class PrivatecaProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class PrivatecaProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class PrivatecaProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A PrivatecaProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class PublicKey(_messages.Message):
  r"""A PublicKey describes a public key.

  Enums:
    FormatValueValuesEnum: Required. The format of the public key.

  Fields:
    format: Required. The format of the public key.
    key: Required. A public key. The padding and encoding must match with the
      `KeyFormat` value specified for the `format` field.
  """

  class FormatValueValuesEnum(_messages.Enum):
    r"""Required. The format of the public key.

    Values:
      KEY_FORMAT_UNSPECIFIED: Default unspecified value.
      PEM: The key is PEM-encoded as defined in [RFC
        7468](https://tools.ietf.org/html/rfc7468). It can be any of the
        following: a PEM-encoded PKCS#1/RFC 3447 RSAPublicKey structure, an
        RFC 5280 [SubjectPublicKeyInfo](https://tools.ietf.org/html/rfc5280#se
        ction-4.1) or a PEM-encoded X.509 certificate signing request (CSR).
        If a [SubjectPublicKeyInfo](https://tools.ietf.org/html/rfc5280#sectio
        n-4.1) is specified, it can contain a A PEM-encoded PKCS#1/RFC 3447
        RSAPublicKey or a NIST P-256/secp256r1/prime256v1 or P-384 key. If a
        CSR is specified, it will used solely for the purpose of extracting
        the public key. When generated by the service, it will always be an
        RFC 5280 [SubjectPublicKeyInfo](https://tools.ietf.org/html/rfc5280#se
        ction-4.1) structure containing an algorithm identifier and a key.
    """
    KEY_FORMAT_UNSPECIFIED = 0
    PEM = 1

  format = _messages.EnumField('FormatValueValuesEnum', 1)
  key = _messages.BytesField(2)


class PublishingOptions(_messages.Message):
  r"""Options relating to the publication of each CertificateAuthority's CA
  certificate and CRLs and their inclusion as extensions in issued
  Certificates. The options set here apply to certificates issued by any
  CertificateAuthority in the CaPool.

  Enums:
    EncodingFormatValueValuesEnum: Optional. Specifies the encoding format of
      each CertificateAuthority's CA certificate and CRLs. If this is omitted,
      CA certificates and CRLs will be published in PEM.

  Fields:
    encodingFormat: Optional. Specifies the encoding format of each
      CertificateAuthority's CA certificate and CRLs. If this is omitted, CA
      certificates and CRLs will be published in PEM.
    publishCaCert: Optional. When true, publishes each CertificateAuthority's
      CA certificate and includes its URL in the "Authority Information
      Access" X.509 extension in all issued Certificates. If this is false,
      the CA certificate will not be published and the corresponding X.509
      extension will not be written in issued certificates.
    publishCrl: Optional. When true, publishes each CertificateAuthority's CRL
      and includes its URL in the "CRL Distribution Points" X.509 extension in
      all issued Certificates. If this is false, CRLs will not be published
      and the corresponding X.509 extension will not be written in issued
      certificates. CRLs will expire 7 days from their creation. However, we
      will rebuild daily. CRLs are also rebuilt shortly after a certificate is
      revoked.
  """

  class EncodingFormatValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the encoding format of each CertificateAuthority's
    CA certificate and CRLs. If this is omitted, CA certificates and CRLs will
    be published in PEM.

    Values:
      ENCODING_FORMAT_UNSPECIFIED: Not specified. By default, PEM format will
        be used.
      PEM: The CertificateAuthority's CA certificate and CRLs will be
        published in PEM format.
      DER: The CertificateAuthority's CA certificate and CRLs will be
        published in DER format.
    """
    ENCODING_FORMAT_UNSPECIFIED = 0
    PEM = 1
    DER = 2

  encodingFormat = _messages.EnumField('EncodingFormatValueValuesEnum', 1)
  publishCaCert = _messages.BooleanField(2)
  publishCrl = _messages.BooleanField(3)


class ReconciliationOperationMetadata(_messages.Message):
  r"""Operation metadata returned by the CLH during resource state
  reconciliation.

  Enums:
    ExclusiveActionValueValuesEnum: Excluisive action returned by the CLH.

  Fields:
    deleteResource: DEPRECATED. Use exclusive_action instead.
    exclusiveAction: Excluisive action returned by the CLH.
  """

  class ExclusiveActionValueValuesEnum(_messages.Enum):
    r"""Excluisive action returned by the CLH.

    Values:
      UNKNOWN_REPAIR_ACTION: Unknown repair action.
      DELETE: The resource has to be deleted. When using this bit, the CLH
        should fail the operation. DEPRECATED. Instead use DELETE_RESOURCE
        OperationSignal in SideChannel.
      RETRY: This resource could not be repaired but the repair should be
        tried again at a later time. This can happen if there is a dependency
        that needs to be resolved first- e.g. if a parent resource must be
        repaired before a child resource.
    """
    UNKNOWN_REPAIR_ACTION = 0
    DELETE = 1
    RETRY = 2

  deleteResource = _messages.BooleanField(1)
  exclusiveAction = _messages.EnumField('ExclusiveActionValueValuesEnum', 2)


class RevocationDetails(_messages.Message):
  r"""Describes fields that are relavent to the revocation of a Certificate.

  Enums:
    RevocationStateValueValuesEnum: Indicates why a Certificate was revoked.

  Fields:
    revocationState: Indicates why a Certificate was revoked.
    revocationTime: The time at which this Certificate was revoked.
  """

  class RevocationStateValueValuesEnum(_messages.Enum):
    r"""Indicates why a Certificate was revoked.

    Values:
      REVOCATION_REASON_UNSPECIFIED: Default unspecified value. This value
        does indicate that a Certificate has been revoked, but that a reason
        has not been recorded.
      KEY_COMPROMISE: Key material for this Certificate may have leaked.
      CERTIFICATE_AUTHORITY_COMPROMISE: The key material for a certificate
        authority in the issuing path may have leaked.
      AFFILIATION_CHANGED: The subject or other attributes in this Certificate
        have changed.
      SUPERSEDED: This Certificate has been superseded.
      CESSATION_OF_OPERATION: This Certificate or entities in the issuing path
        have ceased to operate.
      CERTIFICATE_HOLD: This Certificate should not be considered valid, it is
        expected that it may become valid in the future.
      PRIVILEGE_WITHDRAWN: This Certificate no longer has permission to assert
        the listed attributes.
      ATTRIBUTE_AUTHORITY_COMPROMISE: The authority which determines
        appropriate attributes for a Certificate may have been compromised.
    """
    REVOCATION_REASON_UNSPECIFIED = 0
    KEY_COMPROMISE = 1
    CERTIFICATE_AUTHORITY_COMPROMISE = 2
    AFFILIATION_CHANGED = 3
    SUPERSEDED = 4
    CESSATION_OF_OPERATION = 5
    CERTIFICATE_HOLD = 6
    PRIVILEGE_WITHDRAWN = 7
    ATTRIBUTE_AUTHORITY_COMPROMISE = 8

  revocationState = _messages.EnumField('RevocationStateValueValuesEnum', 1)
  revocationTime = _messages.StringField(2)


class RevokeCertificateRequest(_messages.Message):
  r"""Request message for CertificateAuthorityService.RevokeCertificate.

  Enums:
    ReasonValueValuesEnum: Required. The RevocationReason for revoking this
      certificate.

  Fields:
    reason: Required. The RevocationReason for revoking this certificate.
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  class ReasonValueValuesEnum(_messages.Enum):
    r"""Required. The RevocationReason for revoking this certificate.

    Values:
      REVOCATION_REASON_UNSPECIFIED: Default unspecified value. This value
        does indicate that a Certificate has been revoked, but that a reason
        has not been recorded.
      KEY_COMPROMISE: Key material for this Certificate may have leaked.
      CERTIFICATE_AUTHORITY_COMPROMISE: The key material for a certificate
        authority in the issuing path may have leaked.
      AFFILIATION_CHANGED: The subject or other attributes in this Certificate
        have changed.
      SUPERSEDED: This Certificate has been superseded.
      CESSATION_OF_OPERATION: This Certificate or entities in the issuing path
        have ceased to operate.
      CERTIFICATE_HOLD: This Certificate should not be considered valid, it is
        expected that it may become valid in the future.
      PRIVILEGE_WITHDRAWN: This Certificate no longer has permission to assert
        the listed attributes.
      ATTRIBUTE_AUTHORITY_COMPROMISE: The authority which determines
        appropriate attributes for a Certificate may have been compromised.
    """
    REVOCATION_REASON_UNSPECIFIED = 0
    KEY_COMPROMISE = 1
    CERTIFICATE_AUTHORITY_COMPROMISE = 2
    AFFILIATION_CHANGED = 3
    SUPERSEDED = 4
    CESSATION_OF_OPERATION = 5
    CERTIFICATE_HOLD = 6
    PRIVILEGE_WITHDRAWN = 7
    ATTRIBUTE_AUTHORITY_COMPROMISE = 8

  reason = _messages.EnumField('ReasonValueValuesEnum', 1)
  requestId = _messages.StringField(2)


class RevokedCertificate(_messages.Message):
  r"""Describes a revoked Certificate.

  Enums:
    RevocationReasonValueValuesEnum: The reason the Certificate was revoked.

  Fields:
    certificate: The resource name for the Certificate in the format
      `projects/*/locations/*/caPools/*/certificates/*`.
    hexSerialNumber: The serial number of the Certificate.
    revocationReason: The reason the Certificate was revoked.
  """

  class RevocationReasonValueValuesEnum(_messages.Enum):
    r"""The reason the Certificate was revoked.

    Values:
      REVOCATION_REASON_UNSPECIFIED: Default unspecified value. This value
        does indicate that a Certificate has been revoked, but that a reason
        has not been recorded.
      KEY_COMPROMISE: Key material for this Certificate may have leaked.
      CERTIFICATE_AUTHORITY_COMPROMISE: The key material for a certificate
        authority in the issuing path may have leaked.
      AFFILIATION_CHANGED: The subject or other attributes in this Certificate
        have changed.
      SUPERSEDED: This Certificate has been superseded.
      CESSATION_OF_OPERATION: This Certificate or entities in the issuing path
        have ceased to operate.
      CERTIFICATE_HOLD: This Certificate should not be considered valid, it is
        expected that it may become valid in the future.
      PRIVILEGE_WITHDRAWN: This Certificate no longer has permission to assert
        the listed attributes.
      ATTRIBUTE_AUTHORITY_COMPROMISE: The authority which determines
        appropriate attributes for a Certificate may have been compromised.
    """
    REVOCATION_REASON_UNSPECIFIED = 0
    KEY_COMPROMISE = 1
    CERTIFICATE_AUTHORITY_COMPROMISE = 2
    AFFILIATION_CHANGED = 3
    SUPERSEDED = 4
    CESSATION_OF_OPERATION = 5
    CERTIFICATE_HOLD = 6
    PRIVILEGE_WITHDRAWN = 7
    ATTRIBUTE_AUTHORITY_COMPROMISE = 8

  certificate = _messages.StringField(1)
  hexSerialNumber = _messages.StringField(2)
  revocationReason = _messages.EnumField('RevocationReasonValueValuesEnum', 3)


class RsaKeyType(_messages.Message):
  r"""Describes an RSA key that may be used in a Certificate issued from a
  CaPool.

  Fields:
    maxModulusSize: Optional. The maximum allowed RSA modulus size
      (inclusive), in bits. If this is not set, or if set to zero, the service
      will not enforce an explicit upper bound on RSA modulus sizes.
    minModulusSize: Optional. The minimum allowed RSA modulus size
      (inclusive), in bits. If this is not set, or if set to zero, the
      service-level min RSA modulus size will continue to apply.
  """

  maxModulusSize = _messages.IntegerField(1)
  minModulusSize = _messages.IntegerField(2)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Subject(_messages.Message):
  r"""Subject describes parts of a distinguished name that, in turn, describes
  the subject of the certificate.

  Fields:
    commonName: The "common name" of the subject.
    countryCode: The country code of the subject.
    locality: The locality or city of the subject.
    organization: The organization of the subject.
    organizationalUnit: The organizational_unit of the subject.
    postalCode: The postal code of the subject.
    province: The province, territory, or regional state of the subject.
    streetAddress: The street address of the subject.
  """

  commonName = _messages.StringField(1)
  countryCode = _messages.StringField(2)
  locality = _messages.StringField(3)
  organization = _messages.StringField(4)
  organizationalUnit = _messages.StringField(5)
  postalCode = _messages.StringField(6)
  province = _messages.StringField(7)
  streetAddress = _messages.StringField(8)


class SubjectAltNames(_messages.Message):
  r"""SubjectAltNames corresponds to a more modern way of listing what the
  asserted identity is in a certificate (i.e., compared to the "common name"
  in the distinguished name).

  Fields:
    customSans: Contains additional subject alternative name values. For each
      custom_san, the `value` field must contain an ASN.1 encoded UTF8String.
    dnsNames: Contains only valid, fully-qualified host names.
    emailAddresses: Contains only valid RFC 2822 E-mail addresses.
    ipAddresses: Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6
      addresses.
    uris: Contains only valid RFC 3986 URIs.
  """

  customSans = _messages.MessageField('X509Extension', 1, repeated=True)
  dnsNames = _messages.StringField(2, repeated=True)
  emailAddresses = _messages.StringField(3, repeated=True)
  ipAddresses = _messages.StringField(4, repeated=True)
  uris = _messages.StringField(5, repeated=True)


class SubjectConfig(_messages.Message):
  r"""These values are used to create the distinguished name and subject
  alternative name fields in an X.509 certificate.

  Fields:
    subject: Required. Contains distinguished name fields such as the common
      name, location and organization.
    subjectAltName: Optional. The subject alternative name fields.
  """

  subject = _messages.MessageField('Subject', 1)
  subjectAltName = _messages.MessageField('SubjectAltNames', 2)


class SubjectDescription(_messages.Message):
  r"""These values describe fields in an issued X.509 certificate such as the
  distinguished name, subject alternative names, serial number, and lifetime.

  Fields:
    hexSerialNumber: The serial number encoded in lowercase hexadecimal.
    lifetime: For convenience, the actual lifetime of an issued certificate.
    notAfterTime: The time after which the certificate is expired. Per RFC
      5280, the validity period for a certificate is the period of time from
      not_before_time through not_after_time, inclusive. Corresponds to
      'not_before_time' + 'lifetime' - 1 second.
    notBeforeTime: The time at which the certificate becomes valid.
    subject: Contains distinguished name fields such as the common name,
      location and / organization.
    subjectAltName: The subject alternative name fields.
  """

  hexSerialNumber = _messages.StringField(1)
  lifetime = _messages.StringField(2)
  notAfterTime = _messages.StringField(3)
  notBeforeTime = _messages.StringField(4)
  subject = _messages.MessageField('Subject', 5)
  subjectAltName = _messages.MessageField('SubjectAltNames', 6)


class SubordinateConfig(_messages.Message):
  r"""Describes a subordinate CA's issuers. This is either a resource name to
  a known issuing CertificateAuthority, or a PEM issuer certificate chain.

  Fields:
    certificateAuthority: Required. This can refer to a CertificateAuthority
      that was used to create a subordinate CertificateAuthority. This field
      is used for information and usability purposes only. The resource name
      is in the format
      `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
    pemIssuerChain: Required. Contains the PEM certificate chain for the
      issuers of this CertificateAuthority, but not pem certificate for this
      CA itself.
  """

  certificateAuthority = _messages.StringField(1)
  pemIssuerChain = _messages.MessageField('SubordinateConfigChain', 2)


class SubordinateConfigChain(_messages.Message):
  r"""This message describes a subordinate CA's issuer certificate chain. This
  wrapper exists for compatibility reasons.

  Fields:
    pemCertificates: Required. Expected to be in leaf-to-root order according
      to RFC 5246.
  """

  pemCertificates = _messages.StringField(1, repeated=True)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class UndeleteCertificateAuthorityRequest(_messages.Message):
  r"""Request message for
  CertificateAuthorityService.UndeleteCertificateAuthority.

  Fields:
    requestId: Optional. An ID to identify requests. Specify a unique request
      ID so that if you must retry your request, the server will know to
      ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  requestId = _messages.StringField(1)


class X509Extension(_messages.Message):
  r"""An X509Extension specifies an X.509 extension, which may be used in
  different parts of X.509 objects like certificates, CSRs, and CRLs.

  Fields:
    critical: Optional. Indicates whether or not this extension is critical
      (i.e., if the client does not know how to handle this extension, the
      client should consider this to be an error).
    objectId: Required. The OID for this X.509 extension.
    value: Required. The value of this X.509 extension.
  """

  critical = _messages.BooleanField(1)
  objectId = _messages.MessageField('ObjectId', 2)
  value = _messages.BytesField(3)


class X509Parameters(_messages.Message):
  r"""An X509Parameters is used to describe certain fields of an X.509
  certificate, such as the key usage fields, fields specific to CA
  certificates, certificate policy extensions and custom extensions.

  Fields:
    additionalExtensions: Optional. Describes custom X.509 extensions.
    aiaOcspServers: Optional. Describes Online Certificate Status Protocol
      (OCSP) endpoint addresses that appear in the "Authority Information
      Access" extension in the certificate.
    caOptions: Optional. Describes options in this X509Parameters that are
      relevant in a CA certificate.
    keyUsage: Optional. Indicates the intended use for keys that correspond to
      a certificate.
    nameConstraints: Optional. Describes the X.509 name constraints extension.
    policyIds: Optional. Describes the X.509 certificate policy object
      identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
  """

  additionalExtensions = _messages.MessageField('X509Extension', 1, repeated=True)
  aiaOcspServers = _messages.StringField(2, repeated=True)
  caOptions = _messages.MessageField('CaOptions', 3)
  keyUsage = _messages.MessageField('KeyUsage', 4)
  nameConstraints = _messages.MessageField('NameConstraints', 5)
  policyIds = _messages.MessageField('ObjectId', 6, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
