"""Generated message classes for telecomdatafabric version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'telecomdatafabric'


class BatchIngestionPipeline(_messages.Message):
  r"""Message describing BatchIngestionPipeline object

  Enums:
    StateValueValuesEnum: Output only. State of BatchIngestionPipeline

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    createTime: Output only. [Output only] Create time stamp
    labels: Labels as key value pairs
    name: name of resource
    state: Output only. State of BatchIngestionPipeline
    updateTime: Output only. [Output only] Update time stamp
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of BatchIngestionPipeline

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
      FAILED: Resource encountered an error.
      MALFORMED: Resource is in inderministic state.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4
    FAILED = 5
    MALFORMED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  updateTime = _messages.StringField(5)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class DataAdapter(_messages.Message):
  r"""Message describing DataAdapter object

  Enums:
    StateValueValuesEnum: Output only. State of DataAdapter

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    createTime: Output only. [Output only] Create time stamp
    labels: Labels as key value pairs
    name: name of resource
    state: Output only. State of DataAdapter
    updateTime: Output only. [Output only] Update time stamp
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of DataAdapter

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
      FAILED: Resource encountered an error.
      MALFORMED: Resource is in inderministic state.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4
    FAILED = 5
    MALFORMED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  updateTime = _messages.StringField(5)


class DataApiServer(_messages.Message):
  r"""Message describing DataApiServer object

  Enums:
    StateValueValuesEnum: Output only. State of DataApiServer

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    createTime: Output only. [Output only] Create time stamp
    labels: Labels as key value pairs
    name: name of resource
    state: Output only. State of DataApiServer
    updateTime: Output only. [Output only] Update time stamp
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of DataApiServer

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
      FAILED: Resource encountered an error.
      MALFORMED: Resource is in inderministic state.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4
    FAILED = 5
    MALFORMED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  updateTime = _messages.StringField(5)


class DataAsset(_messages.Message):
  r"""Message describing DataAsset object

  Enums:
    StateValueValuesEnum: Output only. State of DataAsset

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    bigqueryAsset: BigQuery Dataset.
    createTime: Output only. [Output only] Create time stamp
    gcsAsset: Cloud Storage Bucket.
    labels: Labels as key value pairs
    name: name of resource
    pubsubAsset: Pub/sub Topic.
    state: Output only. State of DataAsset
    updateTime: Output only. [Output only] Update time stamp
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of DataAsset

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
      FAILED: Resource encountered an error.
      MALFORMED: Resource is in inderministic state.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4
    FAILED = 5
    MALFORMED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  bigqueryAsset = _messages.MessageField('DataAssetBigQueryAsset', 1)
  createTime = _messages.StringField(2)
  gcsAsset = _messages.MessageField('DataAssetGCSAsset', 3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  pubsubAsset = _messages.MessageField('DataAssetPubSubAsset', 6)
  state = _messages.EnumField('StateValueValuesEnum', 7)
  updateTime = _messages.StringField(8)


class DataAssetBigQueryAsset(_messages.Message):
  r"""Message describing BigQuery data asset.

  Fields:
    datasetId: Dataset ID of the BigQuery Dataset.
  """

  datasetId = _messages.StringField(1)


class DataAssetGCSAsset(_messages.Message):
  r"""Message describing Cloud Storage data asset.

  Fields:
    bucket: Name of the Cloud Storage Bucket.
  """

  bucket = _messages.StringField(1)


class DataAssetManager(_messages.Message):
  r"""Message describing DataAssetManager object.

  Enums:
    StateValueValuesEnum: Output only. Current state of the DataAssetManager.

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    createTime: Output only. [Output only] Create time stamp
    labels: Labels as key value pairs
    lake: Required. The lake details required to create the lake in Dataplex.
    name: Output only. name of resource
    state: Output only. Current state of the DataAssetManager.
    updateTime: Output only. [Output only] Update time stamp
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the DataAssetManager.

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
      FAILED: Resource encountered an error.
      MALFORMED: Resource is in inderministic state.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4
    FAILED = 5
    MALFORMED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  lake = _messages.MessageField('DataAssetManagerLake', 3)
  name = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  updateTime = _messages.StringField(6)


class DataAssetManagerLake(_messages.Message):
  r"""Lake represents a Lake in Dataplex.

  Enums:
    StateValueValuesEnum: Output only. Current state of the lake.

  Fields:
    description: Optional. Description of the Lake.
    displayName: Optional. Use friendly display name.
    lake: Output only. The relative resource name of the Lake created in
      Dataplex in
      `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`
      format.
    lakeId: Required. The unique lake_id. The lake will be created using
      lake_id.
    location: Required. The physical region where the lake would be located
      e.g. us-central1
    metastore: Optional. Settings to manage Dataplex lake and Dataproc
      Metastore service instance association.
    project: Required. The project where the lake would be created.
    state: Output only. Current state of the lake.
    uid: Output only. Globally unique ID returned by Dataplex.
    zones: Required. The Zones to create inside the lake in Dataplex.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the lake.

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
      FAILED: Resource encountered an error.
      MALFORMED: Resource is in inderministic state.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4
    FAILED = 5
    MALFORMED = 6

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  lake = _messages.StringField(3)
  lakeId = _messages.StringField(4)
  location = _messages.StringField(5)
  metastore = _messages.MessageField('DataAssetManagerLakeMetastore', 6)
  project = _messages.StringField(7)
  state = _messages.EnumField('StateValueValuesEnum', 8)
  uid = _messages.StringField(9)
  zones = _messages.MessageField('DataAssetManagerLakeZone', 10, repeated=True)


class DataAssetManagerLakeMetastore(_messages.Message):
  r"""Settings to manage association of Dataproc Metastore with a lake in
  Dataplex].

  Fields:
    service: Optional. A relative reference to the Dataproc Metastore
      (https://cloud.google.com/dataproc-metastore/docs) service associated
      with the lake:
      `projects/{project_id}/locations/{location_id}/services/{service_id}`
  """

  service = _messages.StringField(1)


class DataAssetManagerLakeZone(_messages.Message):
  r"""Zone represents a Zone under a Lake, this will be used to create a Zone
  in Dataplex.

  Enums:
    StateValueValuesEnum: Output only. Current state of the zone.
    TypeValueValuesEnum: Required. The type of the zone.

  Fields:
    description: Optional. Description of the zone.
    discoverySpec: Optional. Specification of the discovery feature applied to
      data in this zone.
    displayName: Optional. User friendly display name.
    resourceSpec: Required. Specification of the resources that are referenced
      by the assets within this zone.
    state: Output only. Current state of the zone.
    type: Required. The type of the zone.
    uid: Output only. Globally unique ID returned by the Dataplex.
    zone: Output only. The relative resource name of the zone created inside
      lake in Dataplex in the form of `projects/{project_number}/locations/{lo
      cation_id}/lakes/{lake_id}/zones/{zone_id}`.
    zoneId: Required. The zone_id to use for creating the zone under the lake.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the zone.

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
      FAILED: Resource encountered an error.
      MALFORMED: Resource is in inderministic state.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4
    FAILED = 5
    MALFORMED = 6

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the zone.

    Values:
      TYPE_UNSPECIFIED: Zone type not specified.
      RAW: A zone that contains data that needs further processing before it
        is considered generally ready for consumption and analytics workloads.
      CURATED: A zone that contains data that is considered to be ready for
        broader consumption and analytics workloads. Curated structured data
        stored in Cloud Storage must conform to certain file formats (parquet,
        avro and orc) and organized in a hive-compatible directory layout.
    """
    TYPE_UNSPECIFIED = 0
    RAW = 1
    CURATED = 2

  description = _messages.StringField(1)
  discoverySpec = _messages.MessageField('DataAssetManagerLakeZoneDiscoverySpec', 2)
  displayName = _messages.StringField(3)
  resourceSpec = _messages.MessageField('DataAssetManagerLakeZoneResourceSpec', 4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  type = _messages.EnumField('TypeValueValuesEnum', 6)
  uid = _messages.StringField(7)
  zone = _messages.StringField(8)
  zoneId = _messages.StringField(9)


class DataAssetManagerLakeZoneDiscoverySpec(_messages.Message):
  r"""Settings to manage the metadata discovery and publishing in a zone.

  Fields:
    csvOptions: Optional. Configuration for CSV data.
    enabled: Required. Whether discovery is enabled.
    excludePatterns: Optional. The list of patterns to apply for selecting
      data to exclude during discovery. For Cloud Storage bucket assets, these
      are interpreted as glob patterns used to match object names. For
      BigQuery dataset assets, these are interpreted as patterns to match
      table names.
    includePatterns: Optional. The list of patterns to apply for selecting
      data to include during discovery if only a subset of the data should
      considered. For Cloud Storage bucket assets, these are interpreted as
      glob patterns used to match object names. For BigQuery dataset assets,
      these are interpreted as patterns to match table names.
    jsonOptions: Optional. Configuration for Json data.
    schedule: Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for
      running discovery periodically.
  """

  csvOptions = _messages.MessageField('DataAssetManagerLakeZoneDiscoverySpecCsvOptions', 1)
  enabled = _messages.BooleanField(2)
  excludePatterns = _messages.StringField(3, repeated=True)
  includePatterns = _messages.StringField(4, repeated=True)
  jsonOptions = _messages.MessageField('DataAssetManagerLakeZoneDiscoverySpecJsonOptions', 5)
  schedule = _messages.StringField(6)


class DataAssetManagerLakeZoneDiscoverySpecCsvOptions(_messages.Message):
  r"""Describe CSV and similar semi-structured data formats.

  Fields:
    delimiter: Optional. The delimiter being used to separate values. This
      defaults to ','.
    disableTypeInference: Optional. Whether to disable the inference of data
      type for CSV data. If true, all columns will be registered as strings.
    encoding: Optional. The character encoding of the data. The default is
      UTF-8.
    headerRows: Optional. The number of rows to interpret as header rows that
      should be skipped when reading data rows.
  """

  delimiter = _messages.StringField(1)
  disableTypeInference = _messages.BooleanField(2)
  encoding = _messages.StringField(3)
  headerRows = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class DataAssetManagerLakeZoneDiscoverySpecJsonOptions(_messages.Message):
  r"""Describe JSON data format.

  Fields:
    disableTypeInference: Optional. Whether to disable the inference of data
      type for Json data. If true, all columns will be registered as their
      primitive types (strings, number or boolean).
    encoding: Optional. The character encoding of the data. The default is
      UTF-8.
  """

  disableTypeInference = _messages.BooleanField(1)
  encoding = _messages.StringField(2)


class DataAssetManagerLakeZoneResourceSpec(_messages.Message):
  r"""Settings for resources attached as assets within the zone.

  Enums:
    LocationTypeValueValuesEnum: Required. Immutable. The location type of the
      resources that are allowed to be attached to the assets within this
      zone.

  Fields:
    locationType: Required. Immutable. The location type of the resources that
      are allowed to be attached to the assets within this zone.
  """

  class LocationTypeValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The location type of the resources that are
    allowed to be attached to the assets within this zone.

    Values:
      LOCATION_TYPE_UNSPECIFIED: Unspecified location type.
      SINGLE_REGION: Resources that are associated with a single region.
      MULTI_REGION: Resources that are associated with a multi-region
        location.
    """
    LOCATION_TYPE_UNSPECIFIED = 0
    SINGLE_REGION = 1
    MULTI_REGION = 2

  locationType = _messages.EnumField('LocationTypeValueValuesEnum', 1)


class DataAssetPubSubAsset(_messages.Message):
  r"""Message describing Pub/Sub data asset.

  Fields:
    topic: Pub/Sub topic of the data asset.
  """

  topic = _messages.StringField(1)


class DeplomentProcess(_messages.Message):
  r"""DeploymentProcess represents the process to be instantiated by template.

  Messages:
    ParametersValue: Process parameters.

  Fields:
    dataflowJob: DataflowJob represents the details about the dataflow job.
    id: Process ID.
    inputAssetIds: Input assets for process, used for recording dependency.
    outputAssetIds: Output assets for process, used for recording dependency.
    parameters: Process parameters.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Process parameters.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  dataflowJob = _messages.MessageField('DeplomentProcessDataflowJob', 1)
  id = _messages.StringField(2)
  inputAssetIds = _messages.StringField(3, repeated=True)
  outputAssetIds = _messages.StringField(4, repeated=True)
  parameters = _messages.MessageField('ParametersValue', 5)


class DeplomentProcessDataflowJob(_messages.Message):
  r"""DataflowJob represents dataflow job and its configurations.

  Enums:
    TypeValueValuesEnum: Dataflow job type.

  Fields:
    schedule: schedule reprsents configuration to schedule dataflow job.
    templateGcsPath: Cloud Storage bucket path where flex template is present.
    type: Dataflow job type.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Dataflow job type.

    Values:
      TYPE_UNSPECIFIED: Default value. This value is unused.
      CLASSIC: Classic dataflow job.
      FLEX: Flex dataflow job.
    """
    TYPE_UNSPECIFIED = 0
    CLASSIC = 1
    FLEX = 2

  schedule = _messages.StringField(1)
  templateGcsPath = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class Deployment(_messages.Message):
  r"""Message describing Deployment object

  Messages:
    LabelsValue: Labels as key value pairs
    ParametersValue: Key/value pair that will be replaced in the template.

  Fields:
    createTime: Output only. [Output only] Create time stamp
    deploymentView: Output only. [Output only] Details about the deployment.
    labels: Labels as key value pairs
    lake: Dataplex Lake that the assets are attached to.
    lakeInfo: Input only. LakeInfo supplied by the consumer. TDF would create
      the Lake and Zones. Assets would be attached to the Zone based on the
      asset type.
    locationId: Location of project where template will be deployed, if not
      supplied the default is resource's location.
    name: name of resource
    parameters: Key/value pair that will be replaced in the template.
    projectId: Id of project where template will be deployed, if not supplied
      the default is resource's project.
    templateId: Id of the template to use for deployment. This resource will
      be in the format "/projects/*/locations/*/template/"
    updateTime: Output only. [Output only] Update time stamp
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Key/value pair that will be replaced in the template.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  deploymentView = _messages.MessageField('DeploymentView', 2)
  labels = _messages.MessageField('LabelsValue', 3)
  lake = _messages.MessageField('DeploymentLake', 4)
  lakeInfo = _messages.MessageField('DeploymentLakeInfo', 5)
  locationId = _messages.StringField(6)
  name = _messages.StringField(7)
  parameters = _messages.MessageField('ParametersValue', 8)
  projectId = _messages.StringField(9)
  templateId = _messages.StringField(10)
  updateTime = _messages.StringField(11)


class DeploymentAsset(_messages.Message):
  r"""DeploymentAsset represents the details about the different input/output
  data assets.

  Enums:
    OwnershipValueValuesEnum: Ownership will represent whether asset is Google
      owned or customer owned.
    TypeValueValuesEnum: Asset type defines dataplex zone of this resource.

  Fields:
    attachedZone: The Dataplex Zone to which this asset is attached.
    bigqueryDataset: BigQueryDataset represents the details of bigquery
      dataset asset.
    bigqueryTable: BigQueryTable represents the details of bigquery table
      asset.
    gcsBucket: Cloud Storage bucket represents the details of Cloud Storage
      bucket asset.
    id: Asset ID.
    ownership: Ownership will represent whether asset is Google owned or
      customer owned.
    pubsubSubscription: PubSubSubscription represents the details of pub/sub
      subscriptions asset.
    pubsubTopic: PubSubTopic represents the details of pub/sub topic asset.
    type: Asset type defines dataplex zone of this resource.
  """

  class OwnershipValueValuesEnum(_messages.Enum):
    r"""Ownership will represent whether asset is Google owned or customer
    owned.

    Values:
      OWNERSHIP_UNSPECIFIED: Default value. This value is unused.
      OWNED: Asset to be created in this deployment.
      EXTERNAL: External asset to be used in this deployment.
    """
    OWNERSHIP_UNSPECIFIED = 0
    OWNED = 1
    EXTERNAL = 2

  class TypeValueValuesEnum(_messages.Enum):
    r"""Asset type defines dataplex zone of this resource.

    Values:
      TYPE_UNSPECIFIED: Default value. This value is unused.
      LANDING: LANDING represents that the asset is a initial input to the
        process.
      INTERMEDIATE: INTERMEDIATE represents that the asset is an
        intermediatory asset.
      CURATED: CURATED represents that the asset will contain curated data in
        some specific format.
      TEMPORARY: TEMPORARY represents that the asset is a temporary asset.
    """
    TYPE_UNSPECIFIED = 0
    LANDING = 1
    INTERMEDIATE = 2
    CURATED = 3
    TEMPORARY = 4

  attachedZone = _messages.StringField(1)
  bigqueryDataset = _messages.MessageField('DeploymentAssetBigQueryDataset', 2)
  bigqueryTable = _messages.MessageField('DeploymentAssetBigQueryTable', 3)
  gcsBucket = _messages.MessageField('DeploymentAssetGcsBucket', 4)
  id = _messages.StringField(5)
  ownership = _messages.EnumField('OwnershipValueValuesEnum', 6)
  pubsubSubscription = _messages.MessageField('DeploymentAssetPubSubSubscription', 7)
  pubsubTopic = _messages.MessageField('DeploymentAssetPubSubTopic', 8)
  type = _messages.EnumField('TypeValueValuesEnum', 9)


class DeploymentAssetBigQueryDataset(_messages.Message):
  r"""BigQueryDataset represents bigquery dataset data asset.

  Fields:
    name: BigQuery dataset name.
  """

  name = _messages.StringField(1)


class DeploymentAssetBigQueryTable(_messages.Message):
  r"""BigQueryTable represents bigquery table data asset.

  Fields:
    clusteringFields: Specifies column names to use for data clustering. Up to
      four top-level columns are allowed, and should be specified in
      descending priority order.
    dataset: BigQuery dataset name.
    expirationDays: The time when this table expires, in days. If not present,
      the table will persist indefinitely. Expired tables will be deleted and
      their storage reclaimed.
    name: BigQuery table name.
    schema: Json string defining BigQuery table schema.
    timePartitioning: Time partitioning information for the table.
  """

  clusteringFields = _messages.StringField(1, repeated=True)
  dataset = _messages.StringField(2)
  expirationDays = _messages.IntegerField(3)
  name = _messages.StringField(4)
  schema = _messages.StringField(5)
  timePartitioning = _messages.MessageField('DeploymentAssetBigQueryTableTimePartitioning', 6)


class DeploymentAssetBigQueryTableTimePartitioning(_messages.Message):
  r"""TimePartitioning configures time-based partitioning for the table.

  Fields:
    field: The field used to determine how to create a time-based partition.
      If time-based partitioning is enabled without this value, the table is
      partitioned based on the load time.
    type: Required. The supported types are DAY, HOUR, MONTH, and YEAR, which
      will generate one partition per day, hour, month, and year,
      respectively.
  """

  field = _messages.StringField(1)
  type = _messages.StringField(2)


class DeploymentAssetGcsBucket(_messages.Message):
  r"""Cloud Storage Bucket represents Cloud Storage bucket data asset.

  Fields:
    ageDays: Age in days after which you want to perform delete action.
    name: Cloud Storage bucket name.
    retentionDays: Specifies the days for which objects need to be retained.
  """

  ageDays = _messages.IntegerField(1)
  name = _messages.StringField(2)
  retentionDays = _messages.IntegerField(3)


class DeploymentAssetPubSubSubscription(_messages.Message):
  r"""PubSubSubscription represents pub/sub topic and its subscription data
  asset.

  Fields:
    name: Pub/Sub subscription name.
    topic: Pub/Sub topic name.
  """

  name = _messages.StringField(1)
  topic = _messages.StringField(2)


class DeploymentAssetPubSubTopic(_messages.Message):
  r"""Pub/Sub Topic represents pub/sub data asset.

  Fields:
    name: Pub/Sub topic name.
  """

  name = _messages.StringField(1)


class DeploymentLake(_messages.Message):
  r"""Lake represents a lake in Dataplex.

  Fields:
    lakeId: LakeID for the Dataplex Lake.
  """

  lakeId = _messages.StringField(1)


class DeploymentLakeInfo(_messages.Message):
  r"""LakeInfo contains Dataplex Lake to be created.

  Fields:
    lake: Lake in the Dataplex.
  """

  lake = _messages.MessageField('DeploymentLake', 1)


class DeploymentView(_messages.Message):
  r"""DeploymentView represents all details about template deployment.

  Fields:
    assets: Assets in deployment.
    processes: Processes in deployment.
  """

  assets = _messages.MessageField('DeploymentAsset', 1, repeated=True)
  processes = _messages.MessageField('DeplomentProcess', 2, repeated=True)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class IaasMetricsCollector(_messages.Message):
  r"""Message describing IaasMetricsCollector object

  Enums:
    StateValueValuesEnum: Output only. State of IaasMetricsCollector

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    createTime: Output only. [Output only] Create time stamp
    labels: Labels as key value pairs
    name: name of resource
    state: Output only. State of IaasMetricsCollector
    updateTime: Output only. [Output only] Update time stamp
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of IaasMetricsCollector

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
      FAILED: Resource encountered an error.
      MALFORMED: Resource is in inderministic state.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4
    FAILED = 5
    MALFORMED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  updateTime = _messages.StringField(5)


class ListBatchIngestionPipelinesResponse(_messages.Message):
  r"""Message for response to listing BatchIngestionPipelines

  Fields:
    batchIngestionPipelines: The list of BatchIngestionPipeline
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  batchIngestionPipelines = _messages.MessageField('BatchIngestionPipeline', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListDataAdaptersResponse(_messages.Message):
  r"""Message for response to listing DataAdapters

  Fields:
    dataAdapters: The list of DataAdapter
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  dataAdapters = _messages.MessageField('DataAdapter', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListDataApiServersResponse(_messages.Message):
  r"""Message for response to listing DataApiServers

  Fields:
    dataApiServers: The list of DataApiServer
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  dataApiServers = _messages.MessageField('DataApiServer', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListDataAssetManagersResponse(_messages.Message):
  r"""Message for response to listing DataAssetManagers

  Fields:
    dataAssetManagers: The list of DataAssetManager
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  dataAssetManagers = _messages.MessageField('DataAssetManager', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListDataAssetsResponse(_messages.Message):
  r"""Message for response to listing DataAssets

  Fields:
    dataAssets: The list of DataAsset
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  dataAssets = _messages.MessageField('DataAsset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListDeploymentsResponse(_messages.Message):
  r"""Message for response to listing Deployments

  Fields:
    deployments: The list of Deployment
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  deployments = _messages.MessageField('Deployment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListIaasMetricsCollectorsResponse(_messages.Message):
  r"""Message for response to listing IaasMetricsCollectors

  Fields:
    iaasMetricsCollectors: The list of IaasMetricsCollector
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  iaasMetricsCollectors = _messages.MessageField('IaasMetricsCollector', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMetricsCorrelationsResponse(_messages.Message):
  r"""Message for response to listing MetricsCorrelations

  Fields:
    metricsCorrelations: The list of MetricsCorrelation
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  metricsCorrelations = _messages.MessageField('MetricsCorrelation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListMetricsIngestionPipelinesResponse(_messages.Message):
  r"""Message for response to listing MetricsIngestionPipelines

  Fields:
    metricsIngestionPipelines: The list of MetricsIngestionPipeline
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  metricsIngestionPipelines = _messages.MessageField('MetricsIngestionPipeline', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListMetricsProcessorsResponse(_messages.Message):
  r"""Message for response to listing MetricsProcessors

  Fields:
    metricsProcessors: The list of MetricsProcessor
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  metricsProcessors = _messages.MessageField('MetricsProcessor', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListPipelineSchedulersResponse(_messages.Message):
  r"""Message for response to listing PipelineSchedulers

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    pipelineSchedulers: The list of PipelineScheduler
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  pipelineSchedulers = _messages.MessageField('PipelineScheduler', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListStreamIngestionPipelinesResponse(_messages.Message):
  r"""Message for response to listing StreamIngestionPipelines

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    streamIngestionPipelines: The list of StreamIngestionPipeline
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  streamIngestionPipelines = _messages.MessageField('StreamIngestionPipeline', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class MetricsCorrelation(_messages.Message):
  r"""Message describing MetricsCorrelation object

  Enums:
    StateValueValuesEnum: Output only. State of ObservabilityPipeline

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    createTime: Output only. [Output only] Create time stamp
    labels: Labels as key value pairs
    name: name of resource
    state: Output only. State of ObservabilityPipeline
    updateTime: Output only. [Output only] Update time stamp
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of ObservabilityPipeline

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
      FAILED: Resource encountered an error.
      MALFORMED: Resource is in inderministic state.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4
    FAILED = 5
    MALFORMED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  updateTime = _messages.StringField(5)


class MetricsIngestionPipeline(_messages.Message):
  r"""Message describing MetricsIngestionPipeline object

  Enums:
    StateValueValuesEnum: Output only. State of MetricsIngestionPipeline

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    createTime: Output only. [Output only] Create time stamp
    labels: Labels as key value pairs
    name: name of resource
    state: Output only. State of MetricsIngestionPipeline
    updateTime: Output only. [Output only] Update time stamp
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of MetricsIngestionPipeline

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
      FAILED: Resource encountered an error.
      MALFORMED: Resource is in inderministic state.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4
    FAILED = 5
    MALFORMED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  updateTime = _messages.StringField(5)


class MetricsProcessor(_messages.Message):
  r"""Message describing MetricsProcessor object

  Enums:
    StateValueValuesEnum: Output only. State of MetricsProcessor

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    createTime: Output only. [Output only] Create time stamp
    labels: Labels as key value pairs
    name: name of resource
    state: Output only. State of MetricsProcessor
    updateTime: Output only. [Output only] Update time stamp
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of MetricsProcessor

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
      FAILED: Resource encountered an error.
      MALFORMED: Resource is in inderministic state.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4
    FAILED = 5
    MALFORMED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  updateTime = _messages.StringField(5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class PipelineScheduler(_messages.Message):
  r"""Message describing PipelineScheduler object

  Enums:
    StateValueValuesEnum: Output only. State of PipelineScheduler

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    createTime: Output only. [Output only] Create time stamp
    labels: Labels as key value pairs
    name: name of resource
    state: Output only. State of PipelineScheduler
    updateTime: Output only. [Output only] Update time stamp
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of PipelineScheduler

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
      FAILED: Resource encountered an error.
      MALFORMED: Resource is in inderministic state.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4
    FAILED = 5
    MALFORMED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  updateTime = _messages.StringField(5)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StreamIngestionPipeline(_messages.Message):
  r"""Message describing StreamIngestionPipeline object

  Enums:
    StateValueValuesEnum: Output only. State of StreamIngestionPipeline

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    createTime: Output only. [Output only] Create time stamp
    labels: Labels as key value pairs
    name: name of resource
    state: Output only. State of StreamIngestionPipeline
    updateTime: Output only. [Output only] Update time stamp
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of StreamIngestionPipeline

    Values:
      STATE_UNSPECIFIED: State is not specified.
      ACTIVE: Resource is active, i.e., ready to use.
      CREATING: Resource is under creation.
      DELETING: Resource is under deletion.
      ACTION_REQUIRED: Resource is active but has unresolved actions.
      FAILED: Resource encountered an error.
      MALFORMED: Resource is in inderministic state.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    DELETING = 3
    ACTION_REQUIRED = 4
    FAILED = 5
    MALFORMED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  updateTime = _messages.StringField(5)


class TelecomdatafabricProjectsLocationsBatchIngestionPipelinesCreateRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsBatchIngestionPipelinesCreateRequest
  object.

  Fields:
    batchIngestionPipeline: A BatchIngestionPipeline resource to be passed as
      the request body.
    batchIngestionPipelineId: Required. Id of the requesting object If auto-
      generating Id server-side, remove this field and
      batch_ingestion_pipeline_id from the method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  batchIngestionPipeline = _messages.MessageField('BatchIngestionPipeline', 1)
  batchIngestionPipelineId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsBatchIngestionPipelinesDeleteRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsBatchIngestionPipelinesDeleteRequest
  object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class TelecomdatafabricProjectsLocationsBatchIngestionPipelinesGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsBatchIngestionPipelinesGetRequest
  object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsBatchIngestionPipelinesListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsBatchIngestionPipelinesListRequest
  object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListBatchIngestionPipelinesRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class TelecomdatafabricProjectsLocationsBatchIngestionPipelinesPatchRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsBatchIngestionPipelinesPatchRequest
  object.

  Fields:
    batchIngestionPipeline: A BatchIngestionPipeline resource to be passed as
      the request body.
    name: name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the BatchIngestionPipeline resource by the update. The
      fields specified in the update_mask are relative to the resource, not
      the full request. A field will be overwritten if it is in the mask. If
      the user does not provide a mask then all fields will be overwritten.
  """

  batchIngestionPipeline = _messages.MessageField('BatchIngestionPipeline', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsDataAdaptersCreateRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataAdaptersCreateRequest object.

  Fields:
    dataAdapter: A DataAdapter resource to be passed as the request body.
    dataAdapterId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and data_adapter_id from the
      method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  dataAdapter = _messages.MessageField('DataAdapter', 1)
  dataAdapterId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsDataAdaptersDeleteRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataAdaptersDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class TelecomdatafabricProjectsLocationsDataAdaptersGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataAdaptersGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsDataAdaptersListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataAdaptersListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListDataAdaptersRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class TelecomdatafabricProjectsLocationsDataAdaptersPatchRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataAdaptersPatchRequest object.

  Fields:
    dataAdapter: A DataAdapter resource to be passed as the request body.
    name: name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the DataAdapter resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  dataAdapter = _messages.MessageField('DataAdapter', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsDataApiServersCreateRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataApiServersCreateRequest object.

  Fields:
    dataApiServer: A DataApiServer resource to be passed as the request body.
    dataApiServerId: Required. Id of the requesting object If auto-generating
      Id server-side, remove this field and data_api_server_id from the
      method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  dataApiServer = _messages.MessageField('DataApiServer', 1)
  dataApiServerId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsDataApiServersDeleteRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataApiServersDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class TelecomdatafabricProjectsLocationsDataApiServersGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataApiServersGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsDataApiServersListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataApiServersListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListDataApiServersRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class TelecomdatafabricProjectsLocationsDataApiServersPatchRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataApiServersPatchRequest object.

  Fields:
    dataApiServer: A DataApiServer resource to be passed as the request body.
    name: name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the DataApiServer resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  dataApiServer = _messages.MessageField('DataApiServer', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsDataAssetManagersCreateRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataAssetManagersCreateRequest
  object.

  Fields:
    dataAssetManager: A DataAssetManager resource to be passed as the request
      body.
    dataAssetManagerId: Required. Id of the requesting object If auto-
      generating Id server-side, remove this field and data_asset_manager_id
      from the method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  dataAssetManager = _messages.MessageField('DataAssetManager', 1)
  dataAssetManagerId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsDataAssetManagersDeleteRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataAssetManagersDeleteRequest
  object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class TelecomdatafabricProjectsLocationsDataAssetManagersGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataAssetManagersGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsDataAssetManagersListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataAssetManagersListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListDataAssetManagersRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class TelecomdatafabricProjectsLocationsDataAssetManagersPatchRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataAssetManagersPatchRequest
  object.

  Fields:
    dataAssetManager: A DataAssetManager resource to be passed as the request
      body.
    name: Output only. name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the DataAssetManager resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  dataAssetManager = _messages.MessageField('DataAssetManager', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsDataAssetsCreateRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataAssetsCreateRequest object.

  Fields:
    dataAsset: A DataAsset resource to be passed as the request body.
    dataAssetId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and data_asset_id from the
      method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  dataAsset = _messages.MessageField('DataAsset', 1)
  dataAssetId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsDataAssetsDeleteRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataAssetsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class TelecomdatafabricProjectsLocationsDataAssetsGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataAssetsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsDataAssetsListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataAssetsListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListDataAssetsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class TelecomdatafabricProjectsLocationsDataAssetsPatchRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDataAssetsPatchRequest object.

  Fields:
    dataAsset: A DataAsset resource to be passed as the request body.
    name: name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the DataAsset resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  dataAsset = _messages.MessageField('DataAsset', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsDeploymentsCreateRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDeploymentsCreateRequest object.

  Fields:
    deployment: A Deployment resource to be passed as the request body.
    deploymentId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and deployment_id from the
      method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  deployment = _messages.MessageField('Deployment', 1)
  deploymentId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsDeploymentsDeleteRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDeploymentsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class TelecomdatafabricProjectsLocationsDeploymentsGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDeploymentsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsDeploymentsListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDeploymentsListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListDeploymentsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class TelecomdatafabricProjectsLocationsDeploymentsPatchRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsDeploymentsPatchRequest object.

  Fields:
    deployment: A Deployment resource to be passed as the request body.
    name: name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Deployment resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  deployment = _messages.MessageField('Deployment', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsIaasMetricsCollectorsCreateRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsIaasMetricsCollectorsCreateRequest
  object.

  Fields:
    iaasMetricsCollector: A IaasMetricsCollector resource to be passed as the
      request body.
    iaasMetricsCollectorId: Required. Id of the requesting object If auto-
      generating Id server-side, remove this field and
      iaas_metrics_collector_id from the method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  iaasMetricsCollector = _messages.MessageField('IaasMetricsCollector', 1)
  iaasMetricsCollectorId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsIaasMetricsCollectorsDeleteRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsIaasMetricsCollectorsDeleteRequest
  object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class TelecomdatafabricProjectsLocationsIaasMetricsCollectorsGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsIaasMetricsCollectorsGetRequest
  object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsIaasMetricsCollectorsListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsIaasMetricsCollectorsListRequest
  object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListIaasMetricsCollectorsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class TelecomdatafabricProjectsLocationsIaasMetricsCollectorsPatchRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsIaasMetricsCollectorsPatchRequest
  object.

  Fields:
    iaasMetricsCollector: A IaasMetricsCollector resource to be passed as the
      request body.
    name: name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the IaasMetricsCollector resource by the update. The
      fields specified in the update_mask are relative to the resource, not
      the full request. A field will be overwritten if it is in the mask. If
      the user does not provide a mask then all fields will be overwritten.
  """

  iaasMetricsCollector = _messages.MessageField('IaasMetricsCollector', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsMetricsCorrelationsCreateRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsMetricsCorrelationsCreateRequest
  object.

  Fields:
    metricsCorrelation: A MetricsCorrelation resource to be passed as the
      request body.
    metricsCorrelationId: Required. Id of the requesting object If auto-
      generating Id server-side, remove this field and metrics_correlation_id
      from the method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  metricsCorrelation = _messages.MessageField('MetricsCorrelation', 1)
  metricsCorrelationId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsMetricsCorrelationsDeleteRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsMetricsCorrelationsDeleteRequest
  object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class TelecomdatafabricProjectsLocationsMetricsCorrelationsGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsMetricsCorrelationsGetRequest
  object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsMetricsCorrelationsListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsMetricsCorrelationsListRequest
  object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListMetricsCorrelationsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class TelecomdatafabricProjectsLocationsMetricsCorrelationsPatchRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsMetricsCorrelationsPatchRequest
  object.

  Fields:
    metricsCorrelation: A MetricsCorrelation resource to be passed as the
      request body.
    name: name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the MetricsCorrelation resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  metricsCorrelation = _messages.MessageField('MetricsCorrelation', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesCreateRequest(_messages.Message):
  r"""A
  TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesCreateRequest
  object.

  Fields:
    metricsIngestionPipeline: A MetricsIngestionPipeline resource to be passed
      as the request body.
    metricsIngestionPipelineId: Required. Id of the requesting object If auto-
      generating Id server-side, remove this field and
      metrics_ingestion_pipeline_id from the method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  metricsIngestionPipeline = _messages.MessageField('MetricsIngestionPipeline', 1)
  metricsIngestionPipelineId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesDeleteRequest(_messages.Message):
  r"""A
  TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesDeleteRequest
  object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesGetRequest
  object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesListRequest
  object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListMetricsIngestionPipelinesRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesPatchRequest(_messages.Message):
  r"""A
  TelecomdatafabricProjectsLocationsMetricsIngestionPipelinesPatchRequest
  object.

  Fields:
    metricsIngestionPipeline: A MetricsIngestionPipeline resource to be passed
      as the request body.
    name: name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the MetricsIngestionPipeline resource by the update. The
      fields specified in the update_mask are relative to the resource, not
      the full request. A field will be overwritten if it is in the mask. If
      the user does not provide a mask then all fields will be overwritten.
  """

  metricsIngestionPipeline = _messages.MessageField('MetricsIngestionPipeline', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsMetricsProcessorsCreateRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsMetricsProcessorsCreateRequest
  object.

  Fields:
    metricsProcessor: A MetricsProcessor resource to be passed as the request
      body.
    metricsProcessorId: Required. Id of the requesting object If auto-
      generating Id server-side, remove this field and metrics_processor_id
      from the method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  metricsProcessor = _messages.MessageField('MetricsProcessor', 1)
  metricsProcessorId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsMetricsProcessorsDeleteRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsMetricsProcessorsDeleteRequest
  object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class TelecomdatafabricProjectsLocationsMetricsProcessorsGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsMetricsProcessorsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsMetricsProcessorsListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsMetricsProcessorsListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListMetricsProcessorsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class TelecomdatafabricProjectsLocationsMetricsProcessorsPatchRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsMetricsProcessorsPatchRequest
  object.

  Fields:
    metricsProcessor: A MetricsProcessor resource to be passed as the request
      body.
    name: name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the MetricsProcessor resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  metricsProcessor = _messages.MessageField('MetricsProcessor', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class TelecomdatafabricProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsPipelineSchedulersCreateRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsPipelineSchedulersCreateRequest
  object.

  Fields:
    parent: Required. Value for parent.
    pipelineScheduler: A PipelineScheduler resource to be passed as the
      request body.
    pipelineSchedulerId: Required. Id of the requesting object If auto-
      generating Id server-side, remove this field and pipeline_scheduler_id
      from the method_signature of Create RPC
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  parent = _messages.StringField(1, required=True)
  pipelineScheduler = _messages.MessageField('PipelineScheduler', 2)
  pipelineSchedulerId = _messages.StringField(3)
  requestId = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsPipelineSchedulersDeleteRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsPipelineSchedulersDeleteRequest
  object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class TelecomdatafabricProjectsLocationsPipelineSchedulersGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsPipelineSchedulersGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsPipelineSchedulersListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsPipelineSchedulersListRequest
  object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListPipelineSchedulersRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class TelecomdatafabricProjectsLocationsPipelineSchedulersPatchRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsPipelineSchedulersPatchRequest
  object.

  Fields:
    name: name of resource
    pipelineScheduler: A PipelineScheduler resource to be passed as the
      request body.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the PipelineScheduler resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  pipelineScheduler = _messages.MessageField('PipelineScheduler', 2)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsStreamIngestionPipelinesCreateRequest(_messages.Message):
  r"""A
  TelecomdatafabricProjectsLocationsStreamIngestionPipelinesCreateRequest
  object.

  Fields:
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    streamIngestionPipeline: A StreamIngestionPipeline resource to be passed
      as the request body.
    streamIngestionPipelineId: Required. Id of the requesting object If auto-
      generating Id server-side, remove this field and
      stream_ingestion_pipeline_id from the method_signature of Create RPC
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  streamIngestionPipeline = _messages.MessageField('StreamIngestionPipeline', 3)
  streamIngestionPipelineId = _messages.StringField(4)


class TelecomdatafabricProjectsLocationsStreamIngestionPipelinesDeleteRequest(_messages.Message):
  r"""A
  TelecomdatafabricProjectsLocationsStreamIngestionPipelinesDeleteRequest
  object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class TelecomdatafabricProjectsLocationsStreamIngestionPipelinesGetRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsStreamIngestionPipelinesGetRequest
  object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class TelecomdatafabricProjectsLocationsStreamIngestionPipelinesListRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsStreamIngestionPipelinesListRequest
  object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListStreamIngestionPipelinesRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class TelecomdatafabricProjectsLocationsStreamIngestionPipelinesPatchRequest(_messages.Message):
  r"""A TelecomdatafabricProjectsLocationsStreamIngestionPipelinesPatchRequest
  object.

  Fields:
    name: name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    streamIngestionPipeline: A StreamIngestionPipeline resource to be passed
      as the request body.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the StreamIngestionPipeline resource by the update. The
      fields specified in the update_mask are relative to the resource, not
      the full request. A field will be overwritten if it is in the mask. If
      the user does not provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  streamIngestionPipeline = _messages.MessageField('StreamIngestionPipeline', 3)
  updateMask = _messages.StringField(4)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
