"""Generated message classes for config version v1alpha1.

Creates and manages Google Cloud Platform resources and infrastructure.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'config'


class ApplyInput(_messages.Message):
  r"""Input parameters for preview of apply operation.

  Fields:
    blueprint: Required. Blueprint to preview.
    configController: The Config Controller instance to preview configurations
      against. Format:
      `projects/{project}/locations/{location}/krmApiHosts/{instance}`.
    createConfigController: Optional. If set, then a Config Controller
      instance with a default, well-known name will be created as part of the
      deployment, if it does not already exist. Note that Blueprints
      Controller does not manage this Config Controller instance and only
      creates it.
    deployment: Deployment to dry-run modification to during preview. For
      preview of new deployment this could be left empty. For preview
      modifications to existing deployment this must match an existing
      deployment, otherwise this will be considered as a new deployment.
      Format:
      `projects/{project}/locations/{location}/deployments/{deployment}`
    managedPipelineOnly: Optional. If set, then only the Pipeline will run.
      This is functionally identical to `pipeline_only`, but only supports
      Pipelines consisting of Google-authored Kpt functions. Using the managed
      pipeline is typically significantly lower latency than `pipeline_only`.
    pipelineOnly: Optional. If set, then only the Pipeline will run. The
      rendered content will still be uploaded to Cloud Storage. No dry-run
      will occur, and no preview diff artifacts will be generated.
  """

  blueprint = _messages.MessageField('Blueprint', 1)
  configController = _messages.StringField(2)
  createConfigController = _messages.BooleanField(3)
  deployment = _messages.StringField(4)
  managedPipelineOnly = _messages.BooleanField(5)
  pipelineOnly = _messages.BooleanField(6)


class ApplyResults(_messages.Message):
  r"""Locations of outputs from config application.

  Fields:
    artifacts: Location of kpt artifacts in Google Cloud Storage. Format:
      `gs://{bucket}/{object}`
    content: Location of generated manifests in Google Cloud Storage. Format:
      `gs://{bucket}/{object}`
  """

  artifacts = _messages.StringField(1)
  content = _messages.StringField(2)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class Blueprint(_messages.Message):
  r"""Contains details surrounding source configurations to be deployed.

  Fields:
    gcsSource: Required. URI of an object in Google Cloud Storage. Format:
      `gs://{bucket}/{object}` URI may also specify an object version. Format:
      `gs://{bucket}/{object}#{version}`
    gitSource: Required. A set of files in a Git repository.
    postprocessors: Optional. Functions to run after the pipeline defined in
      the blueprint's kptfile. At most 5 postprocessors can be provided.
    preprocessors: Optional. Functions to run before the pipeline defined in
      the blueprint's kptfile. At most 5 preprocessors can be provided.
  """

  gcsSource = _messages.StringField(1)
  gitSource = _messages.MessageField('GitSource', 2)
  postprocessors = _messages.MessageField('Function', 3, repeated=True)
  preprocessors = _messages.MessageField('Function', 4, repeated=True)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class ConfigProjectsLocationsDeploymentsCreateRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsCreateRequest object.

  Fields:
    deployment: A Deployment resource to be passed as the request body.
    deploymentId: A string attribute.
    parent: Required. The parent in whose context the Deployment is created.
      The parent value is in the format:
      'projects/{project_id}/locations/{location}'.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  deployment = _messages.MessageField('Deployment', 1)
  deploymentId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ConfigProjectsLocationsDeploymentsDeleteRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsDeleteRequest object.

  Fields:
    force: If set to true, any revisions for this deployment will also be
      deleted. (Otherwise, the request will only work if the deployment has no
      revisions.)
    name: Required. The name of this service resource in the format:
      'projects/{project_id}/locations/{location}/deployments/{deployment}'.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes after the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ConfigProjectsLocationsDeploymentsGetIamPolicyRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ConfigProjectsLocationsDeploymentsGetRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsGetRequest object.

  Fields:
    name: Required. The name of this service resource in the format:
      'projects/{project_id}/locations/{location}/deployments/{deployment}'.
  """

  name = _messages.StringField(1, required=True)


class ConfigProjectsLocationsDeploymentsListRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsListRequest object.

  Fields:
    filter: A string attribute.
    orderBy: A string attribute.
    pageSize: A integer attribute.
    pageToken: A string attribute.
    parent: Required. The parent in whose context the Deployments are listed.
      The parent value is in the format:
      'projects/{project_id}/locations/{location}'.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ConfigProjectsLocationsDeploymentsPatchRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsPatchRequest object.

  Fields:
    deployment: A Deployment resource to be passed as the request body.
    name: Resource name of the deployment. Format:
      `projects/{project}/locations/{location}/deployments/{deployment}`
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Field mask is used to specify the fields to be overwritten in
      the Deployment resource by the update. The fields specified in the
      update_mask are relative to the resource, not the full request. A field
      will be overwritten if it is in the mask. If the user does not provide a
      mask then all fields will be overwritten.
  """

  deployment = _messages.MessageField('Deployment', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class ConfigProjectsLocationsDeploymentsRevisionsGetRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsRevisionsGetRequest object.

  Fields:
    name: Required. The name of this service resource in the format: 'projects
      /{project_id}/locations/{location}/deployments/{deployment}/revisions/{r
      evision}'.
  """

  name = _messages.StringField(1, required=True)


class ConfigProjectsLocationsDeploymentsRevisionsListRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsRevisionsListRequest object.

  Fields:
    filter: Lists the Revisions that match the filter expression. A filter
      expression filters the resources listed in the response. The expression
      must be of the form '{field} {operator} {value}' where operators: '<',
      '>', '<=', '>=', '!=', '=', ':' are supported (colon ':' represents a
      HAS operator which is roughly synonymous with equality). {field} can
      refer to a proto or JSON field, or a synthetic field. Field names can be
      camelCase or snake_case. Examples: - Filter by name: name =
      "projects/foo/locations/us-central1/deployments/dep/revisions/bar -
      Filter by labels: - Resources that have a key called 'foo' labels.foo:*
      - Resources that have a key called 'foo' whose value is 'bar' labels.foo
      = bar - Filter by state: - Revisions in CREATING state. state=CREATING
    orderBy: Field to use to sort the list.
    pageSize: When requesting a 'page' of resources, 'page_size' specifies
      number of resources to return. If unspecified or set to 0, all resources
      will be returned.
    pageToken: Token returned by previous call to 'ListRevisions' which
      specifies the position in the list from where to continue listing the
      resources.
    parent: Required. The parent in whose context the Revisions are listed.
      The parent value is in the format:
      'projects/{project_id}/locations/{location}/deployments/{deployment}'.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ConfigProjectsLocationsDeploymentsSetIamPolicyRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ConfigProjectsLocationsDeploymentsTestIamPermissionsRequest(_messages.Message):
  r"""A ConfigProjectsLocationsDeploymentsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ConfigProjectsLocationsGetRequest(_messages.Message):
  r"""A ConfigProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class ConfigProjectsLocationsListRequest(_messages.Message):
  r"""A ConfigProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ConfigProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A ConfigProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class ConfigProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A ConfigProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class ConfigProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A ConfigProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class ConfigProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A ConfigProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ConfigProjectsLocationsPreviewsCreateRequest(_messages.Message):
  r"""A ConfigProjectsLocationsPreviewsCreateRequest object.

  Fields:
    parent: Required. The parent in whose context the Preview is created. The
      parent value is in the format:
      'projects/{project_id}/locations/{location}'.
    preview: A Preview resource to be passed as the request body.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  parent = _messages.StringField(1, required=True)
  preview = _messages.MessageField('Preview', 2)
  requestId = _messages.StringField(3)


class DeleteInput(_messages.Message):
  r"""Input parameters for preview of delete operation.

  Fields:
    deployment: Required. Name of existing deployment to preview its deletion.
      Format:
      `projects/{project}/locations/{location}/deployments/{deployment}`
  """

  deployment = _messages.StringField(1)


class Deployment(_messages.Message):
  r"""A Deployment object.

  Enums:
    ErrorCodeValueValuesEnum: Output only. Code describing any errors that may
      have occurred.
    StateValueValuesEnum: Output only. Current state of the deployment.

  Messages:
    LabelsValue: User-defined metadata for the deployment.

  Fields:
    blueprint: Required. Blueprint to deploy.
    clusterless: Required. If set, the deployment will create GCP resources
      without deploying to a Config Controller instance.
    configController: Required. Config Controller instance to deploy to.
      Format:
      `projects/{project}/locations/{location}/krmApiHosts/{instance}`.
    createConfigController: Optional. DEPRECATED: Please use config_controller
      target.
    createTime: Output only. Time the deployment was created.
    deleteBuild: Output only. Cloud Build instance UUID associated with
      deleting this deployment.
    deleteLogs: Output only. Location of Cloud Build logs in Google Cloud
      Storage, populated when deleting this deployment. Format:
      `gs://{bucket}/{object}`.
    deleteResults: Output only. Locations of outputs from delete operation.
    errorCode: Output only. Code describing any errors that may have occurred.
    gitTarget: Required. If set, then the hydrated blueprint will be uploaded
      to the specified Git repository.
    labels: User-defined metadata for the deployment.
    latestRevision: Output only. Revision that was most recently applied.
      Format:
      `projects/{project}/locations/{location}/deployments/{deployment}/
      revisions/{revision}`
    name: Resource name of the deployment. Format:
      `projects/{project}/locations/{location}/deployments/{deployment}`
    reconcileTimeout: Optional. How long apply attempt should wait for
      resource reconciliation on the Config Controller cluster to complete. If
      unset, a default value of 5m will be used. A value of 0s indicates that
      the Deployment will be ACTIVE as soon as resources are applied
      successfully to the cluster and final resource actuation status will
      need to be polled on asynchronously.
    state: Output only. Current state of the deployment.
    stateDetail: Output only. Additional information regarding the current
      state.
    updateTime: Output only. Time the deployment was last modified.
  """

  class ErrorCodeValueValuesEnum(_messages.Enum):
    r"""Output only. Code describing any errors that may have occurred.

    Values:
      ERROR_CODE_UNSPECIFIED: No error code was specified.
      REVISION_FAILED: The revision failed (check its error code).
      CLUSTER_CREATION_PERMISSION_DENIED: Cluster creation failed due to a
        permissions issue.
      CLOUD_BUILD_PERMISSION_DENIED: Cloud Build failed due to a permissions
        issue.
      CLUSTER_CREATION_FAILED: Cluster creation failed for a non-permissions-
        related issue.
      DELETE_BUILD_API_FAILED: The deletion Cloud Build failed before logs
        could be generated.
      DELETE_BUILD_RUN_FAILED: The deletion Cloud Build failed after logs
        could be generated.
      BUCKET_CREATION_PERMISSION_DENIED: A Cloud Storage bucket failed due to
        a permissions issue.
      BUCKET_CREATION_FAILED: A Cloud Storage bucket failed for a non-
        permissions-related issue.
    """
    ERROR_CODE_UNSPECIFIED = 0
    REVISION_FAILED = 1
    CLUSTER_CREATION_PERMISSION_DENIED = 2
    CLOUD_BUILD_PERMISSION_DENIED = 3
    CLUSTER_CREATION_FAILED = 4
    DELETE_BUILD_API_FAILED = 5
    DELETE_BUILD_RUN_FAILED = 6
    BUCKET_CREATION_PERMISSION_DENIED = 7
    BUCKET_CREATION_FAILED = 8

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the deployment.

    Values:
      STATE_UNSPECIFIED: The default value. This value is used if the state is
        omitted.
      CREATING: The deployment is being created.
      ACTIVE: The deployment is healthy.
      UPDATING: The deployment is being updated.
      DELETING: The deployment is being deleted.
      FAILED: The deployment has encountered an unexpected error.
      SUSPENDED: The deployment is no longer being actively reconciled. This
        may be the result of recovering the project after deletion.
      DELETED: The deployment is deleted.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    UPDATING = 3
    DELETING = 4
    FAILED = 5
    SUSPENDED = 6
    DELETED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""User-defined metadata for the deployment.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  blueprint = _messages.MessageField('Blueprint', 1)
  clusterless = _messages.BooleanField(2)
  configController = _messages.StringField(3)
  createConfigController = _messages.BooleanField(4)
  createTime = _messages.StringField(5)
  deleteBuild = _messages.StringField(6)
  deleteLogs = _messages.StringField(7)
  deleteResults = _messages.MessageField('ApplyResults', 8)
  errorCode = _messages.EnumField('ErrorCodeValueValuesEnum', 9)
  gitTarget = _messages.MessageField('GitTarget', 10)
  labels = _messages.MessageField('LabelsValue', 11)
  latestRevision = _messages.StringField(12)
  name = _messages.StringField(13)
  reconcileTimeout = _messages.StringField(14)
  state = _messages.EnumField('StateValueValuesEnum', 15)
  stateDetail = _messages.StringField(16)
  updateTime = _messages.StringField(17)


class DeploymentOperationMetadata(_messages.Message):
  r"""Ephemeral metadata content describing the state of a deployment
  operation.

  Enums:
    StepValueValuesEnum: The current step the deployment operation is running.

  Fields:
    applyResults: Locations of outputs from config application.
    build: Output only. Cloud Build instance UUID associated with this
      operation.
    logs: Output only. Location of Deployment operations logs in
      `gs://{bucket}/{object}` format.
    pipelineResults: Locations of outputs from kpt pipeline execution.
    step: The current step the deployment operation is running.
  """

  class StepValueValuesEnum(_messages.Enum):
    r"""The current step the deployment operation is running.

    Values:
      DEPLOYMENT_STEP_UNSPECIFIED: No deployment step was specified.
      PREPARING_STORAGE_BUCKET: Checking for existence of a storage bucket and
        creating one in it's absence. This can take up to 7 minutes on the
        first deployment.
      PREPARING_CONFIG_CONTROLLER: Checking for existence of a Config
        Controller instance and creating one in it's absence. This can take up
        to 20 minutes on the first deployment.
      CREATING_REVISION: Creating a revision resource.
      RUNNING_PIPELINE: Blueprint is being processed.
      RUNNING_APPLY: Blueprint is being applied to Config Controller.
      RUNNING_PREVIEW: Blueprint is being previewed with Config Controller.
    """
    DEPLOYMENT_STEP_UNSPECIFIED = 0
    PREPARING_STORAGE_BUCKET = 1
    PREPARING_CONFIG_CONTROLLER = 2
    CREATING_REVISION = 3
    RUNNING_PIPELINE = 4
    RUNNING_APPLY = 5
    RUNNING_PREVIEW = 6

  applyResults = _messages.MessageField('ApplyResults', 1)
  build = _messages.StringField(2)
  logs = _messages.StringField(3)
  pipelineResults = _messages.MessageField('PipelineResults', 4)
  step = _messages.EnumField('StepValueValuesEnum', 5)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class Function(_messages.Message):
  r"""A function that can be run to modify blueprint contents.

  Messages:
    ConfigValue: Optional. KRM resource passed to the function as input. The
      entire resource must be no larger than 1024 bytes.
    InlineConfigValue: Optional. KRM resource passed to the function as
      inlined input. The entire resource must be no larger than 1024 bytes.

  Fields:
    config: Optional. KRM resource passed to the function as input. The entire
      resource must be no larger than 1024 bytes.
    gcsConfig: Optional. A Cloud Storage link referencing a KRM yaml file to
      use as input to the function. There are no size limitations on this
      field. Format: gs://my-bucket/my-directory/my-function-config.yaml
    image: Required. Container image to run. Example: `gcr.io/kpt-fn/set-
      label`
    inlineConfig: Optional. KRM resource passed to the function as inlined
      input. The entire resource must be no larger than 1024 bytes.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConfigValue(_messages.Message):
    r"""Optional. KRM resource passed to the function as input. The entire
    resource must be no larger than 1024 bytes.

    Messages:
      AdditionalProperty: An additional property for a ConfigValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ConfigValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InlineConfigValue(_messages.Message):
    r"""Optional. KRM resource passed to the function as inlined input. The
    entire resource must be no larger than 1024 bytes.

    Messages:
      AdditionalProperty: An additional property for a InlineConfigValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InlineConfigValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  config = _messages.MessageField('ConfigValue', 1)
  gcsConfig = _messages.StringField(2)
  image = _messages.StringField(3)
  inlineConfig = _messages.MessageField('InlineConfigValue', 4)


class GitSource(_messages.Message):
  r"""A set of files in a Git repository.

  Fields:
    directory: Subdirectory inside the repository. Example: 'staging/my-
      package'
    ref: Git branch or tag.
    repo: Repository URL. Example:
      'https://github.com/kubernetes/examples.git'
  """

  directory = _messages.StringField(1)
  ref = _messages.StringField(2)
  repo = _messages.StringField(3)


class GitTarget(_messages.Message):
  r"""A Git repository to be used as a deployment target.

  Fields:
    branch: Git branch.
    directory: Subdirectory inside the repository. Example: 'staging/my-
      package'
    repo: Repository URL. Example:
      'https://github.com/kubernetes/examples.git'
  """

  branch = _messages.StringField(1)
  directory = _messages.StringField(2)
  repo = _messages.StringField(3)


class ListDeploymentsResponse(_messages.Message):
  r"""A ListDeploymentsResponse object.

  Fields:
    deployments: List of Deployments.
    nextPageToken: A string attribute.
    unreachable: Locations that could not be reached.
  """

  deployments = _messages.MessageField('Deployment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListRevisionsResponse(_messages.Message):
  r"""A response to a 'ListRevisions' call. Contains a list of Revisions.

  Fields:
    nextPageToken: A token to request the next page of resources from the
      'ListRevisions' method. The value of an empty string means that there
      are no more resources to return.
    revisions: List of Revisions.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  revisions = _messages.MessageField('Revision', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. Time the operation was created.
    deploymentMetadata: Output only. Metadata about the deployment operation
      state.
    endTime: Output only. Time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  deploymentMetadata = _messages.MessageField('DeploymentOperationMetadata', 3)
  endTime = _messages.StringField(4)
  requestedCancellation = _messages.BooleanField(5)
  statusMessage = _messages.StringField(6)
  target = _messages.StringField(7)
  verb = _messages.StringField(8)


class PipelineResults(_messages.Message):
  r"""Locations of outputs from kpt pipeline execution.

  Fields:
    artifacts: Location of kpt artifacts in Google Cloud Storage. Format:
      `gs://{bucket}/{object}`
    content: Location of generated manifests in Google Cloud Storage. Format:
      `gs://{bucket}/{object}`
  """

  artifacts = _messages.StringField(1)
  content = _messages.StringField(2)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Preview(_messages.Message):
  r"""Preview message contains preview results.

  Enums:
    ErrorCodeValueValuesEnum: Output only. Code describing any errors that may
      have occurred.
    StateValueValuesEnum: Output only. Current state of the preview.

  Fields:
    applyInput: Input parameters for preview of apply operation.
    build: Output only. Cloud Build instance UUID associated with this
      preview.
    createTime: Output only. Time the preview was created.
    deleteInput: Input parameters for preview of delete operation.
    errorCode: Output only. Code describing any errors that may have occurred.
    logs: Output only. Location of Preview operation logs in
      `gs://{bucket}/{object}` format.
    name: Output only. Resource name of the preview. Format:
      `projects/{project}/locations/{location}/previews/{preview}`
    pipelineResults: Output only. Locations of outputs from kpt pipeline
      execution.
    previewResults: Output only. Locations of outputs from preview operation.
    state: Output only. Current state of the preview.
    stateDetail: Output only. Additional information regarding the current
      state.
  """

  class ErrorCodeValueValuesEnum(_messages.Enum):
    r"""Output only. Code describing any errors that may have occurred.

    Values:
      ERROR_CODE_UNSPECIFIED: No error code was specified.
      CLUSTER_CREATION_PERMISSION_DENIED: Cluster creation failed due to a
        permissions issue.
      CLOUD_BUILD_PERMISSION_DENIED: Cloud Build failed due to a permissions
        issue.
      CLUSTER_CREATION_FAILED: Cluster creation failed for a non-permissions-
        related issue.
      BUCKET_CREATION_PERMISSION_DENIED: A Cloud Storage bucket failed due to
        a permissions issue.
      BUCKET_CREATION_FAILED: A Cloud Storage bucket failed for a non-
        permissions-related issue.
      PIPELINE_BUILD_API_FAILED: The pipeline Cloud Build failed before logs
        could be generated.
      PIPELINE_BUILD_RUN_FAILED: The pipeline Cloud Build failed after logs
        could be generated.
      PREVIEW_BUILD_API_FAILED: The preview Cloud Build failed before logs
        could be generated.
      PREVIEW_BUILD_RUN_FAILED: The preview Cloud Build failed after logs
        could be generated.
    """
    ERROR_CODE_UNSPECIFIED = 0
    CLUSTER_CREATION_PERMISSION_DENIED = 1
    CLOUD_BUILD_PERMISSION_DENIED = 2
    CLUSTER_CREATION_FAILED = 3
    BUCKET_CREATION_PERMISSION_DENIED = 4
    BUCKET_CREATION_FAILED = 5
    PIPELINE_BUILD_API_FAILED = 6
    PIPELINE_BUILD_RUN_FAILED = 7
    PREVIEW_BUILD_API_FAILED = 8
    PREVIEW_BUILD_RUN_FAILED = 9

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the preview.

    Values:
      STATE_UNSPECIFIED: The default value. This value is used if the state is
        omitted.
      CREATING: The preview is being created.
      COMPLETED: The preview is completed.
      FAILED: The preview has encountered an error.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    COMPLETED = 2
    FAILED = 3

  applyInput = _messages.MessageField('ApplyInput', 1)
  build = _messages.StringField(2)
  createTime = _messages.StringField(3)
  deleteInput = _messages.MessageField('DeleteInput', 4)
  errorCode = _messages.EnumField('ErrorCodeValueValuesEnum', 5)
  logs = _messages.StringField(6)
  name = _messages.StringField(7)
  pipelineResults = _messages.MessageField('PipelineResults', 8)
  previewResults = _messages.MessageField('PreviewResults', 9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  stateDetail = _messages.StringField(11)


class PreviewResults(_messages.Message):
  r"""Locations of outputs from config preview.

  Fields:
    artifacts: Location of kpt artifacts in Google Cloud Storage. Format:
      `gs://{bucket}/{object}`
    content: Location of generated preview data in Google Cloud Storage.
      Format: `gs://{bucket}/{object}`
  """

  artifacts = _messages.StringField(1)
  content = _messages.StringField(2)


class Revision(_messages.Message):
  r"""A child resource of a Deployment generated by a 'CreateDeployment' or
  'UpdateDeployment' call. Each Revision contains artifacts pertaining to a
  snapshot of a particular Deployment including transformed configurations and
  logs.

  Enums:
    ActionValueValuesEnum: Output only. The type of action that this revision
      represents.
    ErrorCodeValueValuesEnum: Output only. Code describing any errors that may
      have occurred.
    StateValueValuesEnum: Output only. Current state of the revision.

  Fields:
    action: Output only. The type of action that this revision represents.
    applyResults: Output only. Locations of outputs from config application.
    blueprint: Output only. Blueprint that was deployed.
    build: Output only. Cloud Build instance UUID associated with this
      revision.
    createTime: Output only. Time the revision was created.
    errorCode: Output only. Code describing any errors that may have occurred.
    logs: Output only. Location of Revision operation logs in
      `gs://{bucket}/{object}` format.
    name: Resource name of the revision. Format:
      `projects/{project}/locations/{location}/deployments/{deployment}/
      revisions/{revision}`
    pipelineResults: Output only. Locations of outputs from kpt pipeline
      execution.
    reconcileTimeout: Optional. How long apply attempt should wait for
      resource reconciliation on the Config Controller cluster to complete. If
      unset, a default value of 5m will be used. A value of 0s indicates that
      the Revision will be APPLIED as soon as resources are applied
      successfully to the cluster and final resource actuation status will
      need to be polled on asynchronously.
    state: Output only. Current state of the revision.
    stateDetail: Output only. Additional information regarding the current
      state.
    updateTime: Output only. Time the revision was last modified.
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""Output only. The type of action that this revision represents.

    Values:
      ACTION_UNSPECIFIED: The default value. This value is used if the action
        is omitted.
      CREATE: The revision was generated by creating a deployment.
      UPDATE: The revision was generated by updating a deployment.
      DELETE: The revision was generated by deleting a deployment.
    """
    ACTION_UNSPECIFIED = 0
    CREATE = 1
    UPDATE = 2
    DELETE = 3

  class ErrorCodeValueValuesEnum(_messages.Enum):
    r"""Output only. Code describing any errors that may have occurred.

    Values:
      ERROR_CODE_UNSPECIFIED: No error code was specified.
      CLOUD_BUILD_PERMISSION_DENIED: Cloud Build failed due to a permissions
        issue.
      PIPELINE_BUILD_API_FAILED: The pipeline Cloud Build failed before logs
        could be generated.
      PIPELINE_BUILD_RUN_FAILED: The pipeline Cloud Build failed after logs
        could be generated.
      APPLY_BUILD_API_FAILED: The apply Cloud Build failed before logs could
        be generated.
      APPLY_BUILD_RUN_FAILED: The apply Cloud Build failed after logs could be
        generated.
      PREVIEW_BUILD_API_FAILED: The preview Cloud Build failed before logs
        could be generated.
      PREVIEW_BUILD_RUN_FAILED: The preview Cloud Build failed after logs
        could be generated.
    """
    ERROR_CODE_UNSPECIFIED = 0
    CLOUD_BUILD_PERMISSION_DENIED = 1
    PIPELINE_BUILD_API_FAILED = 2
    PIPELINE_BUILD_RUN_FAILED = 3
    APPLY_BUILD_API_FAILED = 4
    APPLY_BUILD_RUN_FAILED = 5
    PREVIEW_BUILD_API_FAILED = 6
    PREVIEW_BUILD_RUN_FAILED = 7

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the revision.

    Values:
      STATE_UNSPECIFIED: The default value. This value is used if the state is
        omitted.
      APPLYING: The revision is being applied.
      APPLIED: The revision was applied successfully.
      FAILED: The revision could not be applied successfully.
    """
    STATE_UNSPECIFIED = 0
    APPLYING = 1
    APPLIED = 2
    FAILED = 3

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  applyResults = _messages.MessageField('ApplyResults', 2)
  blueprint = _messages.MessageField('Blueprint', 3)
  build = _messages.StringField(4)
  createTime = _messages.StringField(5)
  errorCode = _messages.EnumField('ErrorCodeValueValuesEnum', 6)
  logs = _messages.StringField(7)
  name = _messages.StringField(8)
  pipelineResults = _messages.MessageField('PipelineResults', 9)
  reconcileTimeout = _messages.StringField(10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  stateDetail = _messages.StringField(12)
  updateTime = _messages.StringField(13)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
