// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"

	"github.com/hashicorp/errwrap"
	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
	"google.golang.org/api/cloudresourcemanager/v1"
)

var TagsTagKeyIamSchema = map[string]*schema.Schema{
	"tag_key": {
		Type:             schema.TypeString,
		Required:         true,
		ForceNew:         true,
		DiffSuppressFunc: compareSelfLinkOrResourceName,
	},
}

type TagsTagKeyIamUpdater struct {
	tagKey string
	d      TerraformResourceData
	Config *Config
}

func TagsTagKeyIamUpdaterProducer(d TerraformResourceData, config *Config) (ResourceIamUpdater, error) {
	values := make(map[string]string)

	if v, ok := d.GetOk("tag_key"); ok {
		values["tag_key"] = v.(string)
	}

	// We may have gotten either a long or short name, so attempt to parse long name if possible
	m, err := getImportIdQualifiers([]string{"tagKeys/(?P<tag_key>[^/]+)", "(?P<tag_key>[^/]+)"}, d, config, d.Get("tag_key").(string))
	if err != nil {
		return nil, err
	}

	for k, v := range m {
		values[k] = v
	}

	u := &TagsTagKeyIamUpdater{
		tagKey: values["tag_key"],
		d:      d,
		Config: config,
	}

	if err := d.Set("tag_key", u.GetResourceId()); err != nil {
		return nil, fmt.Errorf("Error setting tag_key: %s", err)
	}

	return u, nil
}

func TagsTagKeyIdParseFunc(d *schema.ResourceData, config *Config) error {
	values := make(map[string]string)

	m, err := getImportIdQualifiers([]string{"tagKeys/(?P<tag_key>[^/]+)", "(?P<tag_key>[^/]+)"}, d, config, d.Id())
	if err != nil {
		return err
	}

	for k, v := range m {
		values[k] = v
	}

	u := &TagsTagKeyIamUpdater{
		tagKey: values["tag_key"],
		d:      d,
		Config: config,
	}
	if err := d.Set("tag_key", u.GetResourceId()); err != nil {
		return fmt.Errorf("Error setting tag_key: %s", err)
	}
	d.SetId(u.GetResourceId())
	return nil
}

func (u *TagsTagKeyIamUpdater) GetResourceIamPolicy() (*cloudresourcemanager.Policy, error) {
	url, err := u.qualifyTagKeyUrl("getIamPolicy")
	if err != nil {
		return nil, err
	}

	var obj map[string]interface{}

	userAgent, err := generateUserAgentString(u.d, u.Config.userAgent)
	if err != nil {
		return nil, err
	}

	policy, err := sendRequest(u.Config, "POST", "", url, userAgent, obj)
	if err != nil {
		return nil, errwrap.Wrapf(fmt.Sprintf("Error retrieving IAM policy for %s: {{err}}", u.DescribeResource()), err)
	}

	out := &cloudresourcemanager.Policy{}
	err = Convert(policy, out)
	if err != nil {
		return nil, errwrap.Wrapf("Cannot convert a policy to a resource manager policy: {{err}}", err)
	}

	return out, nil
}

func (u *TagsTagKeyIamUpdater) SetResourceIamPolicy(policy *cloudresourcemanager.Policy) error {
	json, err := ConvertToMap(policy)
	if err != nil {
		return err
	}

	obj := make(map[string]interface{})
	obj["policy"] = json

	url, err := u.qualifyTagKeyUrl("setIamPolicy")
	if err != nil {
		return err
	}

	userAgent, err := generateUserAgentString(u.d, u.Config.userAgent)
	if err != nil {
		return err
	}

	_, err = sendRequestWithTimeout(u.Config, "POST", "", url, userAgent, obj, u.d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return errwrap.Wrapf(fmt.Sprintf("Error setting IAM policy for %s: {{err}}", u.DescribeResource()), err)
	}

	return nil
}

func (u *TagsTagKeyIamUpdater) qualifyTagKeyUrl(methodIdentifier string) (string, error) {
	urlTemplate := fmt.Sprintf("{{TagsBasePath}}%s:%s", fmt.Sprintf("tagKeys/%s", u.tagKey), methodIdentifier)
	url, err := replaceVars(u.d, u.Config, urlTemplate)
	if err != nil {
		return "", err
	}
	return url, nil
}

func (u *TagsTagKeyIamUpdater) GetResourceId() string {
	return fmt.Sprintf("tagKeys/%s", u.tagKey)
}

func (u *TagsTagKeyIamUpdater) GetMutexKey() string {
	return fmt.Sprintf("iam-tags-tagkey-%s", u.GetResourceId())
}

func (u *TagsTagKeyIamUpdater) DescribeResource() string {
	return fmt.Sprintf("tags tagkey %q", u.GetResourceId())
}
