"""Generated message classes for policytroubleshooter version v3alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'policytroubleshooter'


class GoogleCloudPolicytroubleshooterV3alphaAllowBindingExplanation(_messages.Message):
  r"""Details about how a binding in an allow policy affects a member's
  ability to use a permission.

  Enums:
    AllowAccessStateValueValuesEnum: Required. Indicates whether _this
      binding_ provides the specified permission to the specified member for
      the specified resource. This field does _not_ indicate whether the
      member actually has the permission for the resource. There might be
      another binding that overrides this binding. To determine whether the
      member actually has the permission, use the `access` field in the
      TroubleshootIamPolicyResponse.
    RelevanceValueValuesEnum: The relevance of this binding to the overall
      determination for the entire policy.
    RolePermissionValueValuesEnum: Indicates whether the role granted by this
      binding contains the specified permission.
    RolePermissionRelevanceValueValuesEnum: The relevance of the permission's
      existence, or nonexistence, in the role to the overall determination for
      the entire policy.

  Messages:
    MembershipsValue: Indicates whether each member in the binding includes
      the member specified in the request, either directly or indirectly. Each
      key identifies a member in the binding, and each value indicates whether
      the member in the binding includes the member in the request. For
      example, suppose that a binding includes the following members: *
      `user:alice@example.com` * `group:product-eng@example.com` You want to
      troubleshoot access for `user:bob@example.com`. This user is a member of
      the group `group:product-eng@example.com`. For the first member in the
      binding, the key is `user:alice@example.com`, and the `membership` field
      in the value is set to `NOT_INCLUDED`. For the second member in the
      binding, the key is `group:product-eng@example.com`, and the
      `membership` field in the value is set to `INCLUDED`.

  Fields:
    allowAccessState: Required. Indicates whether _this binding_ provides the
      specified permission to the specified member for the specified resource.
      This field does _not_ indicate whether the member actually has the
      permission for the resource. There might be another binding that
      overrides this binding. To determine whether the member actually has the
      permission, use the `access` field in the TroubleshootIamPolicyResponse.
    combinedMembership: The combined result of all memberships. Indicates if
      there is any member in the binding includes the principal specified in
      the request, either directly or indirectly.
    condition: A condition expression that prevents access unless the
      expression evaluates to `true`. To learn about IAM Conditions, see
      https://cloud.google.com/iam/help/conditions/overview.
    conditionExplanation: Condition evaluation state for this binding.
    memberships: Indicates whether each member in the binding includes the
      member specified in the request, either directly or indirectly. Each key
      identifies a member in the binding, and each value indicates whether the
      member in the binding includes the member in the request. For example,
      suppose that a binding includes the following members: *
      `user:alice@example.com` * `group:product-eng@example.com` You want to
      troubleshoot access for `user:bob@example.com`. This user is a member of
      the group `group:product-eng@example.com`. For the first member in the
      binding, the key is `user:alice@example.com`, and the `membership` field
      in the value is set to `NOT_INCLUDED`. For the second member in the
      binding, the key is `group:product-eng@example.com`, and the
      `membership` field in the value is set to `INCLUDED`.
    relevance: The relevance of this binding to the overall determination for
      the entire policy.
    role: The role that this binding grants. For example,
      `roles/compute.serviceAgent`. For a complete list of predefined IAM
      roles, as well as the permissions in each role, see
      https://cloud.google.com/iam/help/roles/reference.
    rolePermission: Indicates whether the role granted by this binding
      contains the specified permission.
    rolePermissionRelevance: The relevance of the permission's existence, or
      nonexistence, in the role to the overall determination for the entire
      policy.
  """

  class AllowAccessStateValueValuesEnum(_messages.Enum):
    r"""Required. Indicates whether _this binding_ provides the specified
    permission to the specified member for the specified resource. This field
    does _not_ indicate whether the member actually has the permission for the
    resource. There might be another binding that overrides this binding. To
    determine whether the member actually has the permission, use the `access`
    field in the TroubleshootIamPolicyResponse.

    Values:
      ALLOW_ACCESS_STATE_UNSPECIFIED: Reserved for future use.
      ALLOW_ACCESS_STATE_GRANTED: Access is granted.
      ALLOW_ACCESS_STATE_NOT_GRANTED: Access is not granted.
      ALLOW_ACCESS_STATE_UNKNOWN_CONDITIONAL: Access is allowed only if a
        condition expression evaluates to `true`.
      ALLOW_ACCESS_STATE_UNKNOWN_INFO: The sender of the request does not have
        access to all of the policies that Policy Troubleshooter needs to
        evaluate.
    """
    ALLOW_ACCESS_STATE_UNSPECIFIED = 0
    ALLOW_ACCESS_STATE_GRANTED = 1
    ALLOW_ACCESS_STATE_NOT_GRANTED = 2
    ALLOW_ACCESS_STATE_UNKNOWN_CONDITIONAL = 3
    ALLOW_ACCESS_STATE_UNKNOWN_INFO = 4

  class RelevanceValueValuesEnum(_messages.Enum):
    r"""The relevance of this binding to the overall determination for the
    entire policy.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Reserved for future use.
      HEURISTIC_RELEVANCE_NORMAL: The data point has a limited effect on the
        result. Changing the data point is unlikely to affect the overall
        determination.
      HEURISTIC_RELEVANCE_HIGH: The data point has a strong effect on the
        result. Changing the data point is likely to affect the overall
        determination.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    HEURISTIC_RELEVANCE_NORMAL = 1
    HEURISTIC_RELEVANCE_HIGH = 2

  class RolePermissionRelevanceValueValuesEnum(_messages.Enum):
    r"""The relevance of the permission's existence, or nonexistence, in the
    role to the overall determination for the entire policy.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Reserved for future use.
      HEURISTIC_RELEVANCE_NORMAL: The data point has a limited effect on the
        result. Changing the data point is unlikely to affect the overall
        determination.
      HEURISTIC_RELEVANCE_HIGH: The data point has a strong effect on the
        result. Changing the data point is likely to affect the overall
        determination.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    HEURISTIC_RELEVANCE_NORMAL = 1
    HEURISTIC_RELEVANCE_HIGH = 2

  class RolePermissionValueValuesEnum(_messages.Enum):
    r"""Indicates whether the role granted by this binding contains the
    specified permission.

    Values:
      ROLE_PERMISSION_INCLUSION_STATE_UNSPECIFIED: Reserved for future use.
      ROLE_PERMISSION_INCLUDED: The permission is included in the role.
      ROLE_PERMISSION_NOT_INCLUDED: The permission is not included in the
        role.
      ROLE_PERMISSION_UNKNOWN_INFO: The sender of the request is not allowed
        to access the binding.
    """
    ROLE_PERMISSION_INCLUSION_STATE_UNSPECIFIED = 0
    ROLE_PERMISSION_INCLUDED = 1
    ROLE_PERMISSION_NOT_INCLUDED = 2
    ROLE_PERMISSION_UNKNOWN_INFO = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MembershipsValue(_messages.Message):
    r"""Indicates whether each member in the binding includes the member
    specified in the request, either directly or indirectly. Each key
    identifies a member in the binding, and each value indicates whether the
    member in the binding includes the member in the request. For example,
    suppose that a binding includes the following members: *
    `user:alice@example.com` * `group:product-eng@example.com` You want to
    troubleshoot access for `user:bob@example.com`. This user is a member of
    the group `group:product-eng@example.com`. For the first member in the
    binding, the key is `user:alice@example.com`, and the `membership` field
    in the value is set to `NOT_INCLUDED`. For the second member in the
    binding, the key is `group:product-eng@example.com`, and the `membership`
    field in the value is set to `INCLUDED`.

    Messages:
      AdditionalProperty: An additional property for a MembershipsValue
        object.

    Fields:
      additionalProperties: Additional properties of type MembershipsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MembershipsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudPolicytroubleshooterV3alphaAllowBindingExplanation
          AnnotatedAllowMembership attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaAllowBindingExplanationAnnotatedAllowMembership', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  allowAccessState = _messages.EnumField('AllowAccessStateValueValuesEnum', 1)
  combinedMembership = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaAllowBindingExplanationAnnotatedAllowMembership', 2)
  condition = _messages.MessageField('GoogleTypeExpr', 3)
  conditionExplanation = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaIamConditionExplanation', 4)
  memberships = _messages.MessageField('MembershipsValue', 5)
  relevance = _messages.EnumField('RelevanceValueValuesEnum', 6)
  role = _messages.StringField(7)
  rolePermission = _messages.EnumField('RolePermissionValueValuesEnum', 8)
  rolePermissionRelevance = _messages.EnumField('RolePermissionRelevanceValueValuesEnum', 9)


class GoogleCloudPolicytroubleshooterV3alphaAllowBindingExplanationAnnotatedAllowMembership(_messages.Message):
  r"""Details about whether the binding includes the member.

  Enums:
    MembershipValueValuesEnum: Indicates whether the binding includes the
      member.
    RelevanceValueValuesEnum: The relevance of the member's status to the
      overall determination for the binding.

  Fields:
    membership: Indicates whether the binding includes the member.
    relevance: The relevance of the member's status to the overall
      determination for the binding.
  """

  class MembershipValueValuesEnum(_messages.Enum):
    r"""Indicates whether the binding includes the member.

    Values:
      MEMBERSHIP_MATCHING_STATE_UNSPECIFIED: Reserved for future use.
      MEMBERSHIP_MATCHED: The principal matches the member. The member can be
        included directly or indirectly. For example: * A member is included
        directly if that member is listed in the binding. * A member is
        included indirectly if that member is in a Google group or G Suite
        domain that is listed in the binding.
      MEMBERSHIP_NOT_MATCHED: The binding does not match the member.
      MEMBERSHIP_UNKNOWN_INFO: The sender of the request is not allowed to
        access the binding.
      MEMBERSHIP_UNKNOWN_UNSUPPORTED: The member is an unsupported type.
    """
    MEMBERSHIP_MATCHING_STATE_UNSPECIFIED = 0
    MEMBERSHIP_MATCHED = 1
    MEMBERSHIP_NOT_MATCHED = 2
    MEMBERSHIP_UNKNOWN_INFO = 3
    MEMBERSHIP_UNKNOWN_UNSUPPORTED = 4

  class RelevanceValueValuesEnum(_messages.Enum):
    r"""The relevance of the member's status to the overall determination for
    the binding.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Reserved for future use.
      HEURISTIC_RELEVANCE_NORMAL: The data point has a limited effect on the
        result. Changing the data point is unlikely to affect the overall
        determination.
      HEURISTIC_RELEVANCE_HIGH: The data point has a strong effect on the
        result. Changing the data point is likely to affect the overall
        determination.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    HEURISTIC_RELEVANCE_NORMAL = 1
    HEURISTIC_RELEVANCE_HIGH = 2

  membership = _messages.EnumField('MembershipValueValuesEnum', 1)
  relevance = _messages.EnumField('RelevanceValueValuesEnum', 2)


class GoogleCloudPolicytroubleshooterV3alphaDenyRuleExplanation(_messages.Message):
  r"""Details about how a deny rule in a deny policy affects a member's
  ability to use a permission.

  Enums:
    DenyAccessStateValueValuesEnum: Required. Indicates whether _this rule_
      denies the specified permission to the specified member for the
      specified resource. This field does _not_ indicate whether the member is
      actually denied on the permission for the resource. There might be
      another rule that overrides this rule. To determine whether the member
      actually has the permission, use the `access` field in the
      TroubleshootIamPolicyResponse.
    RelevanceValueValuesEnum: The relevance of this binding to the overall
      determination for the entire policy.

  Messages:
    DeniedPermissionsValue: Indicates whether the permission matches each
      denied permission pattern. Each key identifies a denied permission in
      the rule, and each value indicates whether the denied permission matches
      the permission in the request.
    DeniedPrincipalsValue: Indicates whether the principal matches each denied
      principals. Each key identifies a denied principal in the rule, and each
      value indicates whether the denied principal matches the principal in
      the request.
    ExceptionPermissionsValue: Indicates whether the permission matches each
      exception permission pattern. Each key identifies a exception permission
      in the rule, and each value indicates whether the exception permission
      matches the permission in the request.
    ExceptionPrincipalsValue: Indicates whether the principal matches each
      exception principal pattern. Each key identifies a exception principal
      in the rule, and each value indicates whether the exception principal
      matches the principal in the request.

  Fields:
    combinedDeniedPermission: Indicates whether the permission matches any
      denied permission pattern.
    combinedDeniedPrincipal: Indicates whether the principal matches any
      denied principal pattern.
    combinedExceptionPermission: Indicates whether the permission matches any
      exception permission pattern.
    combinedExceptionPrincipal: Indicates whether the principal matches any
      exception principal pattern.
    condition: A condition expression that prevents access unless the
      expression evaluates to `true`. To learn about IAM Conditions, see
      https://cloud.google.com/iam/help/conditions/overview.
    conditionExplanation: Condition evaluation state for this binding.
    deniedPermissions: Indicates whether the permission matches each denied
      permission pattern. Each key identifies a denied permission in the rule,
      and each value indicates whether the denied permission matches the
      permission in the request.
    deniedPrincipals: Indicates whether the principal matches each denied
      principals. Each key identifies a denied principal in the rule, and each
      value indicates whether the denied principal matches the principal in
      the request.
    denyAccessState: Required. Indicates whether _this rule_ denies the
      specified permission to the specified member for the specified resource.
      This field does _not_ indicate whether the member is actually denied on
      the permission for the resource. There might be another rule that
      overrides this rule. To determine whether the member actually has the
      permission, use the `access` field in the TroubleshootIamPolicyResponse.
    exceptionPermissions: Indicates whether the permission matches each
      exception permission pattern. Each key identifies a exception permission
      in the rule, and each value indicates whether the exception permission
      matches the permission in the request.
    exceptionPrincipals: Indicates whether the principal matches each
      exception principal pattern. Each key identifies a exception principal
      in the rule, and each value indicates whether the exception principal
      matches the principal in the request.
    relevance: The relevance of this binding to the overall determination for
      the entire policy.
  """

  class DenyAccessStateValueValuesEnum(_messages.Enum):
    r"""Required. Indicates whether _this rule_ denies the specified
    permission to the specified member for the specified resource. This field
    does _not_ indicate whether the member is actually denied on the
    permission for the resource. There might be another rule that overrides
    this rule. To determine whether the member actually has the permission,
    use the `access` field in the TroubleshootIamPolicyResponse.

    Values:
      DENY_ACCESS_STATE_UNSPECIFIED: Reserved for future use.
      DENY_ACCESS_STATE_DENIED: Access is denied.
      DENY_ACCESS_STATE_NOT_DENIED: Access is not denied.
      DENY_ACCESS_STATE_UNKNOWN_CONDITIONAL: Access is denied only if a
        condition expression evaluates to `true`.
      DENY_ACCESS_STATE_UNKNOWN_INFO: The sender of the request does not have
        access to all of the deny policies that Policy Troubleshooter needs to
        evaluate.
    """
    DENY_ACCESS_STATE_UNSPECIFIED = 0
    DENY_ACCESS_STATE_DENIED = 1
    DENY_ACCESS_STATE_NOT_DENIED = 2
    DENY_ACCESS_STATE_UNKNOWN_CONDITIONAL = 3
    DENY_ACCESS_STATE_UNKNOWN_INFO = 4

  class RelevanceValueValuesEnum(_messages.Enum):
    r"""The relevance of this binding to the overall determination for the
    entire policy.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Reserved for future use.
      HEURISTIC_RELEVANCE_NORMAL: The data point has a limited effect on the
        result. Changing the data point is unlikely to affect the overall
        determination.
      HEURISTIC_RELEVANCE_HIGH: The data point has a strong effect on the
        result. Changing the data point is likely to affect the overall
        determination.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    HEURISTIC_RELEVANCE_NORMAL = 1
    HEURISTIC_RELEVANCE_HIGH = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DeniedPermissionsValue(_messages.Message):
    r"""Indicates whether the permission matches each denied permission
    pattern. Each key identifies a denied permission in the rule, and each
    value indicates whether the denied permission matches the permission in
    the request.

    Messages:
      AdditionalProperty: An additional property for a DeniedPermissionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        DeniedPermissionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DeniedPermissionsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudPolicytroubleshooterV3alphaDenyRuleExplanationAnno
          tatedPermissionMatching attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaDenyRuleExplanationAnnotatedPermissionMatching', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DeniedPrincipalsValue(_messages.Message):
    r"""Indicates whether the principal matches each denied principals. Each
    key identifies a denied principal in the rule, and each value indicates
    whether the denied principal matches the principal in the request.

    Messages:
      AdditionalProperty: An additional property for a DeniedPrincipalsValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        DeniedPrincipalsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DeniedPrincipalsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudPolicytroubleshooterV3alphaDenyRuleExplanationAnno
          tatedDenyPrincipalMatching attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaDenyRuleExplanationAnnotatedDenyPrincipalMatching', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExceptionPermissionsValue(_messages.Message):
    r"""Indicates whether the permission matches each exception permission
    pattern. Each key identifies a exception permission in the rule, and each
    value indicates whether the exception permission matches the permission in
    the request.

    Messages:
      AdditionalProperty: An additional property for a
        ExceptionPermissionsValue object.

    Fields:
      additionalProperties: Additional properties of type
        ExceptionPermissionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ExceptionPermissionsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudPolicytroubleshooterV3alphaDenyRuleExplanationAnno
          tatedPermissionMatching attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaDenyRuleExplanationAnnotatedPermissionMatching', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExceptionPrincipalsValue(_messages.Message):
    r"""Indicates whether the principal matches each exception principal
    pattern. Each key identifies a exception principal in the rule, and each
    value indicates whether the exception principal matches the principal in
    the request.

    Messages:
      AdditionalProperty: An additional property for a
        ExceptionPrincipalsValue object.

    Fields:
      additionalProperties: Additional properties of type
        ExceptionPrincipalsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ExceptionPrincipalsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudPolicytroubleshooterV3alphaDenyRuleExplanationAnno
          tatedDenyPrincipalMatching attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaDenyRuleExplanationAnnotatedDenyPrincipalMatching', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  combinedDeniedPermission = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaDenyRuleExplanationAnnotatedPermissionMatching', 1)
  combinedDeniedPrincipal = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaDenyRuleExplanationAnnotatedDenyPrincipalMatching', 2)
  combinedExceptionPermission = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaDenyRuleExplanationAnnotatedPermissionMatching', 3)
  combinedExceptionPrincipal = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaDenyRuleExplanationAnnotatedDenyPrincipalMatching', 4)
  condition = _messages.MessageField('GoogleTypeExpr', 5)
  conditionExplanation = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaIamConditionExplanation', 6)
  deniedPermissions = _messages.MessageField('DeniedPermissionsValue', 7)
  deniedPrincipals = _messages.MessageField('DeniedPrincipalsValue', 8)
  denyAccessState = _messages.EnumField('DenyAccessStateValueValuesEnum', 9)
  exceptionPermissions = _messages.MessageField('ExceptionPermissionsValue', 10)
  exceptionPrincipals = _messages.MessageField('ExceptionPrincipalsValue', 11)
  relevance = _messages.EnumField('RelevanceValueValuesEnum', 12)


class GoogleCloudPolicytroubleshooterV3alphaDenyRuleExplanationAnnotatedDenyPrincipalMatching(_messages.Message):
  r"""Details about whether the principal matches the principal set.

  Enums:
    MembershipValueValuesEnum: Indicates whether the principal is matched.
    RelevanceValueValuesEnum: The relevance of the member's status to the
      overall determination for the binding.

  Fields:
    membership: Indicates whether the principal is matched.
    relevance: The relevance of the member's status to the overall
      determination for the binding.
  """

  class MembershipValueValuesEnum(_messages.Enum):
    r"""Indicates whether the principal is matched.

    Values:
      MEMBERSHIP_MATCHING_STATE_UNSPECIFIED: Reserved for future use.
      MEMBERSHIP_MATCHED: The principal matches the member. The member can be
        included directly or indirectly. For example: * A member is included
        directly if that member is listed in the binding. * A member is
        included indirectly if that member is in a Google group or G Suite
        domain that is listed in the binding.
      MEMBERSHIP_NOT_MATCHED: The binding does not match the member.
      MEMBERSHIP_UNKNOWN_INFO: The sender of the request is not allowed to
        access the binding.
      MEMBERSHIP_UNKNOWN_UNSUPPORTED: The member is an unsupported type.
    """
    MEMBERSHIP_MATCHING_STATE_UNSPECIFIED = 0
    MEMBERSHIP_MATCHED = 1
    MEMBERSHIP_NOT_MATCHED = 2
    MEMBERSHIP_UNKNOWN_INFO = 3
    MEMBERSHIP_UNKNOWN_UNSUPPORTED = 4

  class RelevanceValueValuesEnum(_messages.Enum):
    r"""The relevance of the member's status to the overall determination for
    the binding.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Reserved for future use.
      HEURISTIC_RELEVANCE_NORMAL: The data point has a limited effect on the
        result. Changing the data point is unlikely to affect the overall
        determination.
      HEURISTIC_RELEVANCE_HIGH: The data point has a strong effect on the
        result. Changing the data point is likely to affect the overall
        determination.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    HEURISTIC_RELEVANCE_NORMAL = 1
    HEURISTIC_RELEVANCE_HIGH = 2

  membership = _messages.EnumField('MembershipValueValuesEnum', 1)
  relevance = _messages.EnumField('RelevanceValueValuesEnum', 2)


class GoogleCloudPolicytroubleshooterV3alphaDenyRuleExplanationAnnotatedPermissionMatching(_messages.Message):
  r"""Details about whether the permission matches the permission pattern.

  Enums:
    PermissionMatchingStateValueValuesEnum: Indicates whether the permission
      matches the permission pattern.
    RelevanceValueValuesEnum: The relevance of the permission status to the
      overall determination for the rule.

  Fields:
    permissionMatchingState: Indicates whether the permission matches the
      permission pattern.
    relevance: The relevance of the permission status to the overall
      determination for the rule.
  """

  class PermissionMatchingStateValueValuesEnum(_messages.Enum):
    r"""Indicates whether the permission matches the permission pattern.

    Values:
      PERMISSION_PATTERN_MATCHING_STATE_UNSPECIFIED: Reserved for future use.
      PERMISSION_PATTERN_MATCHED: The permission matches the permission
        pattern.
      PERMISSION_PATTERN_NOT_MATCHED: The permission does not match the
        permission pattern..
    """
    PERMISSION_PATTERN_MATCHING_STATE_UNSPECIFIED = 0
    PERMISSION_PATTERN_MATCHED = 1
    PERMISSION_PATTERN_NOT_MATCHED = 2

  class RelevanceValueValuesEnum(_messages.Enum):
    r"""The relevance of the permission status to the overall determination
    for the rule.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Reserved for future use.
      HEURISTIC_RELEVANCE_NORMAL: The data point has a limited effect on the
        result. Changing the data point is unlikely to affect the overall
        determination.
      HEURISTIC_RELEVANCE_HIGH: The data point has a strong effect on the
        result. Changing the data point is likely to affect the overall
        determination.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    HEURISTIC_RELEVANCE_NORMAL = 1
    HEURISTIC_RELEVANCE_HIGH = 2

  permissionMatchingState = _messages.EnumField('PermissionMatchingStateValueValuesEnum', 1)
  relevance = _messages.EnumField('RelevanceValueValuesEnum', 2)


class GoogleCloudPolicytroubleshooterV3alphaExplainedAllowPolicy(_messages.Message):
  r"""Details about how a specific IAM Policy contributed to the access check.

  Enums:
    AllowAccessStateValueValuesEnum: Required. Indicates whether _this policy_
      provides the specified permission to the specified member for the
      specified resource. This field does _not_ indicate whether the member
      actually has the permission for the resource. There might be another
      policy that overrides this policy. To determine whether the member
      actually has the permission, use the `access` field in the
      TroubleshootIamPolicyResponse.
    RelevanceValueValuesEnum: The relevance of this policy to the overall
      determination in the TroubleshootIamPolicyResponse. If the sender of the
      request does not have access to the policy, this field is omitted.

  Fields:
    allowAccessState: Required. Indicates whether _this policy_ provides the
      specified permission to the specified member for the specified resource.
      This field does _not_ indicate whether the member actually has the
      permission for the resource. There might be another policy that
      overrides this policy. To determine whether the member actually has the
      permission, use the `access` field in the TroubleshootIamPolicyResponse.
    bindingExplanations: Details about how each binding in the policy affects
      the member's ability, or inability, to use the permission for the
      resource. If the sender of the request does not have access to the
      policy, this field is omitted.
    fullResourceName: The full resource name that identifies the resource. For
      example, `//compute.googleapis.com/projects/my-project/zones/us-
      central1-a/instances/my-instance`. If the sender of the request does not
      have access to the policy, this field is omitted. For examples of full
      resource names for Google Cloud services, see
      https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
    relevance: The relevance of this policy to the overall determination in
      the TroubleshootIamPolicyResponse. If the sender of the request does not
      have access to the policy, this field is omitted.
  """

  class AllowAccessStateValueValuesEnum(_messages.Enum):
    r"""Required. Indicates whether _this policy_ provides the specified
    permission to the specified member for the specified resource. This field
    does _not_ indicate whether the member actually has the permission for the
    resource. There might be another policy that overrides this policy. To
    determine whether the member actually has the permission, use the `access`
    field in the TroubleshootIamPolicyResponse.

    Values:
      ALLOW_ACCESS_STATE_UNSPECIFIED: Reserved for future use.
      ALLOW_ACCESS_STATE_GRANTED: Access is granted.
      ALLOW_ACCESS_STATE_NOT_GRANTED: Access is not granted.
      ALLOW_ACCESS_STATE_UNKNOWN_CONDITIONAL: Access is allowed only if a
        condition expression evaluates to `true`.
      ALLOW_ACCESS_STATE_UNKNOWN_INFO: The sender of the request does not have
        access to all of the policies that Policy Troubleshooter needs to
        evaluate.
    """
    ALLOW_ACCESS_STATE_UNSPECIFIED = 0
    ALLOW_ACCESS_STATE_GRANTED = 1
    ALLOW_ACCESS_STATE_NOT_GRANTED = 2
    ALLOW_ACCESS_STATE_UNKNOWN_CONDITIONAL = 3
    ALLOW_ACCESS_STATE_UNKNOWN_INFO = 4

  class RelevanceValueValuesEnum(_messages.Enum):
    r"""The relevance of this policy to the overall determination in the
    TroubleshootIamPolicyResponse. If the sender of the request does not have
    access to the policy, this field is omitted.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Reserved for future use.
      HEURISTIC_RELEVANCE_NORMAL: The data point has a limited effect on the
        result. Changing the data point is unlikely to affect the overall
        determination.
      HEURISTIC_RELEVANCE_HIGH: The data point has a strong effect on the
        result. Changing the data point is likely to affect the overall
        determination.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    HEURISTIC_RELEVANCE_NORMAL = 1
    HEURISTIC_RELEVANCE_HIGH = 2

  allowAccessState = _messages.EnumField('AllowAccessStateValueValuesEnum', 1)
  bindingExplanations = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaAllowBindingExplanation', 2, repeated=True)
  fullResourceName = _messages.StringField(3)
  relevance = _messages.EnumField('RelevanceValueValuesEnum', 4)


class GoogleCloudPolicytroubleshooterV3alphaExplainedDenyPolicy(_messages.Message):
  r"""Details about how a specific IAM deny policy Policy contributed to the
  access check.

  Enums:
    DenyAccessStateValueValuesEnum: Required. Indicates whether _this policy_
      denies the specified permission to the specified member for the
      specified resource. This field does _not_ indicate whether the member
      actually has the permission for the resource. There might be another
      policy that overrides this policy. To determine whether the member
      actually has the permission, use the `access` field in the
      TroubleshootIamPolicyResponse.
    RelevanceValueValuesEnum: The relevance of this policy to the overall
      determination in the TroubleshootIamPolicyResponse. If the sender of the
      request does not have access to the policy, this field is omitted.

  Fields:
    denyAccessState: Required. Indicates whether _this policy_ denies the
      specified permission to the specified member for the specified resource.
      This field does _not_ indicate whether the member actually has the
      permission for the resource. There might be another policy that
      overrides this policy. To determine whether the member actually has the
      permission, use the `access` field in the TroubleshootIamPolicyResponse.
    displayName: Display name of the IAM deny policy.
    policy: Name of the IAM deny policy attached to the resource. The resource
      name of [google.iam.v2.Policy], which must be unique. Format:
      `policies/{attachment_point}/denypolicies/{policy_id}` The attachment
      point is identified by its URL-encoded full resource name, which means
      that the forward-slash character, `/`, must be written as `%2F`. For
      example, `policies/cloudresourcemanager.googleapis.com%2Fprojects%2Fmy-
      project/denypolicies/my-deny-policy`. For organizations and folders, use
      the numeric ID in the full resource name. For projects, requests can use
      the alphanumeric or the numeric ID. Responses always contain the numeric
      ID.
    relevance: The relevance of this policy to the overall determination in
      the TroubleshootIamPolicyResponse. If the sender of the request does not
      have access to the policy, this field is omitted.
    ruleExplanations: Details about how each rule in the policy affects the
      member's inability to use the permission for the resource. If the sender
      of the request does not have access to the policy, this field is
      omitted.
  """

  class DenyAccessStateValueValuesEnum(_messages.Enum):
    r"""Required. Indicates whether _this policy_ denies the specified
    permission to the specified member for the specified resource. This field
    does _not_ indicate whether the member actually has the permission for the
    resource. There might be another policy that overrides this policy. To
    determine whether the member actually has the permission, use the `access`
    field in the TroubleshootIamPolicyResponse.

    Values:
      DENY_ACCESS_STATE_UNSPECIFIED: Reserved for future use.
      DENY_ACCESS_STATE_DENIED: Access is denied.
      DENY_ACCESS_STATE_NOT_DENIED: Access is not denied.
      DENY_ACCESS_STATE_UNKNOWN_CONDITIONAL: Access is denied only if a
        condition expression evaluates to `true`.
      DENY_ACCESS_STATE_UNKNOWN_INFO: The sender of the request does not have
        access to all of the deny policies that Policy Troubleshooter needs to
        evaluate.
    """
    DENY_ACCESS_STATE_UNSPECIFIED = 0
    DENY_ACCESS_STATE_DENIED = 1
    DENY_ACCESS_STATE_NOT_DENIED = 2
    DENY_ACCESS_STATE_UNKNOWN_CONDITIONAL = 3
    DENY_ACCESS_STATE_UNKNOWN_INFO = 4

  class RelevanceValueValuesEnum(_messages.Enum):
    r"""The relevance of this policy to the overall determination in the
    TroubleshootIamPolicyResponse. If the sender of the request does not have
    access to the policy, this field is omitted.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Reserved for future use.
      HEURISTIC_RELEVANCE_NORMAL: The data point has a limited effect on the
        result. Changing the data point is unlikely to affect the overall
        determination.
      HEURISTIC_RELEVANCE_HIGH: The data point has a strong effect on the
        result. Changing the data point is likely to affect the overall
        determination.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    HEURISTIC_RELEVANCE_NORMAL = 1
    HEURISTIC_RELEVANCE_HIGH = 2

  denyAccessState = _messages.EnumField('DenyAccessStateValueValuesEnum', 1)
  displayName = _messages.StringField(2)
  policy = _messages.StringField(3)
  relevance = _messages.EnumField('RelevanceValueValuesEnum', 4)
  ruleExplanations = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaDenyRuleExplanation', 5, repeated=True)


class GoogleCloudPolicytroubleshooterV3alphaExplainedDenyResource(_messages.Message):
  r"""Details about how a specific resource contributed to the deny access
  check.

  Enums:
    DenyAccessStateValueValuesEnum: Required. Indicates whether any policies
      attached to _this resource_ deny the specific permission to the
      specified member for the specified resource. This field does _not_
      indicate whether the member actually has the permission for the
      resource. There might be another policy that overrides this policy. To
      determine whether the member actually has the permission, use the
      `access` field in the TroubleshootIamPolicyResponse.
    RelevanceValueValuesEnum: The relevance of this policy to the overall
      determination in the TroubleshootIamPolicyResponse. If the sender of the
      request does not have access to the policy, this field is omitted.

  Fields:
    denyAccessState: Required. Indicates whether any policies attached to
      _this resource_ deny the specific permission to the specified member for
      the specified resource. This field does _not_ indicate whether the
      member actually has the permission for the resource. There might be
      another policy that overrides this policy. To determine whether the
      member actually has the permission, use the `access` field in the
      TroubleshootIamPolicyResponse.
    explainedPolicies: List of IAM deny policies that were evaluated to check
      the member's denied permissions, with annotations to indicate how each
      policy contributed to the final result.
    fullResourceName: The full resource name that identifies the resource. For
      example, `//compute.googleapis.com/projects/my-project/zones/us-
      central1-a/instances/my-instance`. If the sender of the request does not
      have access to the policy, this field is omitted. For examples of full
      resource names for Google Cloud services, see
      https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
    relevance: The relevance of this policy to the overall determination in
      the TroubleshootIamPolicyResponse. If the sender of the request does not
      have access to the policy, this field is omitted.
  """

  class DenyAccessStateValueValuesEnum(_messages.Enum):
    r"""Required. Indicates whether any policies attached to _this resource_
    deny the specific permission to the specified member for the specified
    resource. This field does _not_ indicate whether the member actually has
    the permission for the resource. There might be another policy that
    overrides this policy. To determine whether the member actually has the
    permission, use the `access` field in the TroubleshootIamPolicyResponse.

    Values:
      DENY_ACCESS_STATE_UNSPECIFIED: Reserved for future use.
      DENY_ACCESS_STATE_DENIED: Access is denied.
      DENY_ACCESS_STATE_NOT_DENIED: Access is not denied.
      DENY_ACCESS_STATE_UNKNOWN_CONDITIONAL: Access is denied only if a
        condition expression evaluates to `true`.
      DENY_ACCESS_STATE_UNKNOWN_INFO: The sender of the request does not have
        access to all of the deny policies that Policy Troubleshooter needs to
        evaluate.
    """
    DENY_ACCESS_STATE_UNSPECIFIED = 0
    DENY_ACCESS_STATE_DENIED = 1
    DENY_ACCESS_STATE_NOT_DENIED = 2
    DENY_ACCESS_STATE_UNKNOWN_CONDITIONAL = 3
    DENY_ACCESS_STATE_UNKNOWN_INFO = 4

  class RelevanceValueValuesEnum(_messages.Enum):
    r"""The relevance of this policy to the overall determination in the
    TroubleshootIamPolicyResponse. If the sender of the request does not have
    access to the policy, this field is omitted.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Reserved for future use.
      HEURISTIC_RELEVANCE_NORMAL: The data point has a limited effect on the
        result. Changing the data point is unlikely to affect the overall
        determination.
      HEURISTIC_RELEVANCE_HIGH: The data point has a strong effect on the
        result. Changing the data point is likely to affect the overall
        determination.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    HEURISTIC_RELEVANCE_NORMAL = 1
    HEURISTIC_RELEVANCE_HIGH = 2

  denyAccessState = _messages.EnumField('DenyAccessStateValueValuesEnum', 1)
  explainedPolicies = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaExplainedDenyPolicy', 2, repeated=True)
  fullResourceName = _messages.StringField(3)
  relevance = _messages.EnumField('RelevanceValueValuesEnum', 4)


class GoogleCloudPolicytroubleshooterV3alphaIamAccessTuple(_messages.Message):
  r"""Information about the member, resource, and permission to check.

  Fields:
    conditionContext: Optional. The Cloud IAM condition context under which
      defines the kind of access being explained. TroubleshootIamPolicy would
      explain if and why the principal has the queried permission on the
      resource specified in full_resource_name under this context
    fullResourceName: Required. The full resource name that identifies the
      resource. For example, `//compute.googleapis.com/projects/my-
      project/zones/us-central1-a/instances/my-instance`. For examples of full
      resource names for Google Cloud services, see
      https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
    permission: Required. The IAM permission to check for the specified member
      and resource. This field can be either permission or permission FQDN.
      For a complete list of IAM permissions, see
      https://cloud.google.com/iam/help/permissions/reference. For a complete
      list of predefined IAM roles and the permissions in each role, see
      https://cloud.google.com/iam/help/roles/reference. For a complete list
      of IAM permission FQDNs used in IAM v2, see
      https://cloud.google.com/iam/docs/deny-permissions-support
    permissionFqdn: Output only. The FQDN of the IAM permission to check for
      the specified member and resource. For a complete list of IAM permission
      FQDNs used in IAM v2, see https://cloud.google.com/iam/docs/deny-
      permissions-support
    principal: Required. The member, or principal, whose access you want to
      check, in the form of the email address that represents that member. For
      example, `alice@example.com` or `my-service-account@my-
      project.iam.gserviceaccount.com`. The member must be a Google Account or
      a service account. Other types of members are not supported.
  """

  conditionContext = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaIamConditionContext', 1)
  fullResourceName = _messages.StringField(2)
  permission = _messages.StringField(3)
  permissionFqdn = _messages.StringField(4)
  principal = _messages.StringField(5)


class GoogleCloudPolicytroubleshooterV3alphaIamAllowPolicyExplanation(_messages.Message):
  r"""Details about how IAM allow policies contributed to the access check.

  Enums:
    AllowAccessStateValueValuesEnum: Indicates whether the member has the
      specified permission for the specified resource, based on evaluating all
      applicable IAM allow policies.
    RelevanceValueValuesEnum: The relevance of the allow policy type to the
      overall access state.

  Fields:
    allowAccessState: Indicates whether the member has the specified
      permission for the specified resource, based on evaluating all
      applicable IAM allow policies.
    explainedPolicies: List of IAM allow policies that were evaluated to check
      the member's permissions, with annotations to indicate how each policy
      contributed to the final result. The list of policies can include the
      policy for the resource itself. It can also include policies that are
      inherited from higher levels of the resource hierarchy, including the
      organization, the folder, and the project. To learn more about the
      resource hierarchy, see https://cloud.google.com/iam/help/resource-
      hierarchy.
    relevance: The relevance of the allow policy type to the overall access
      state.
  """

  class AllowAccessStateValueValuesEnum(_messages.Enum):
    r"""Indicates whether the member has the specified permission for the
    specified resource, based on evaluating all applicable IAM allow policies.

    Values:
      ALLOW_ACCESS_STATE_UNSPECIFIED: Reserved for future use.
      ALLOW_ACCESS_STATE_GRANTED: Access is granted.
      ALLOW_ACCESS_STATE_NOT_GRANTED: Access is not granted.
      ALLOW_ACCESS_STATE_UNKNOWN_CONDITIONAL: Access is allowed only if a
        condition expression evaluates to `true`.
      ALLOW_ACCESS_STATE_UNKNOWN_INFO: The sender of the request does not have
        access to all of the policies that Policy Troubleshooter needs to
        evaluate.
    """
    ALLOW_ACCESS_STATE_UNSPECIFIED = 0
    ALLOW_ACCESS_STATE_GRANTED = 1
    ALLOW_ACCESS_STATE_NOT_GRANTED = 2
    ALLOW_ACCESS_STATE_UNKNOWN_CONDITIONAL = 3
    ALLOW_ACCESS_STATE_UNKNOWN_INFO = 4

  class RelevanceValueValuesEnum(_messages.Enum):
    r"""The relevance of the allow policy type to the overall access state.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Reserved for future use.
      HEURISTIC_RELEVANCE_NORMAL: The data point has a limited effect on the
        result. Changing the data point is unlikely to affect the overall
        determination.
      HEURISTIC_RELEVANCE_HIGH: The data point has a strong effect on the
        result. Changing the data point is likely to affect the overall
        determination.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    HEURISTIC_RELEVANCE_NORMAL = 1
    HEURISTIC_RELEVANCE_HIGH = 2

  allowAccessState = _messages.EnumField('AllowAccessStateValueValuesEnum', 1)
  explainedPolicies = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaExplainedAllowPolicy', 2, repeated=True)
  relevance = _messages.EnumField('RelevanceValueValuesEnum', 3)


class GoogleCloudPolicytroubleshooterV3alphaIamConditionContext(_messages.Message):
  r"""Represents the attributes that will be used to do IAM condition
  evaluation.

  Fields:
    destination: The destination of a network activity, such as accepting a
      TCP connection. In a multi hop network activity, the destination
      represents the receiver of the last hop.
    request: Represents a network request, such as an HTTP request.
    resource: Represents a target resource that is involved with a network
      activity. If multiple resources are involved with an activity, this must
      be the primary one.
  """

  destination = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaIamConditionContextPeer', 1)
  request = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaIamConditionContextRequest', 2)
  resource = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaIamConditionContextResource', 3)


class GoogleCloudPolicytroubleshooterV3alphaIamConditionContextPeer(_messages.Message):
  r"""This message defines attributes for a node that handles a network
  request. The node can be either a service or an application that sends,
  forwards, or receives the request. Service peers should fill in `principal`
  and `labels` as appropriate.

  Fields:
    ip: The IPv4 or IPv6 address of the peer.
    port: The network port of the peer.
  """

  ip = _messages.StringField(1)
  port = _messages.IntegerField(2)


class GoogleCloudPolicytroubleshooterV3alphaIamConditionContextRequest(_messages.Message):
  r"""This message defines attributes for an HTTP request. If the actual
  request is not an HTTP request, the runtime system should try to map the
  actual request to an equivalent HTTP request.

  Fields:
    receiveTime: Optional. The timestamp when the `destination` service
      receives the first byte of the request.
    satisfiedAccessLevels: Optional. The information for access levels that
      are satisfied for the given access tuple. This field is google internal
      and can only be used by pantheon
    unsatisfiedAccessLevels: Optional. The information for access levels that
      are unsatisfied for the given access tuple. This field is google
      internal and can only be used by pantheon
  """

  receiveTime = _messages.StringField(1)
  satisfiedAccessLevels = _messages.StringField(2, repeated=True)
  unsatisfiedAccessLevels = _messages.StringField(3, repeated=True)


class GoogleCloudPolicytroubleshooterV3alphaIamConditionContextResource(_messages.Message):
  r"""This message defines core attributes for a resource. A resource is an
  addressable (named) entity provided by the destination service. For example,
  a file stored on a network storage service.

  Fields:
    name: The stable identifier (name) of a resource on the `service`. A
      resource can be logically identified as
      "//{resource.service}/{resource.name}". The differences between a
      resource name and a URI are: * Resource name is a logical identifier,
      independent of network protocol and API version. For example,
      `//pubsub.googleapis.com/projects/123/topics/news-feed`. * URI often
      includes protocol and version information, so it can be used directly by
      applications. For example,
      `https://pubsub.googleapis.com/v1/projects/123/topics/news-feed`. See
      https://google.aip.dev/122 for details.
    service: The name of the service that this resource belongs to, such as
      `pubsub.googleapis.com`. The service may be different from the DNS
      hostname that actually serves the request.
    type: The type of the resource. The syntax is platform-specific because
      different platforms define their resources differently. For Google APIs,
      the type format must be "{service}/{kind}".
  """

  name = _messages.StringField(1)
  service = _messages.StringField(2)
  type = _messages.StringField(3)


class GoogleCloudPolicytroubleshooterV3alphaIamConditionExplanation(_messages.Message):
  r"""Condition Explanation

  Fields:
    evaluationStates: List of evaluated states of non boolean expression in
      the condition
    value: Value of the condition
  """

  evaluationStates = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaIamConditionExplanationEvaluationState', 1, repeated=True)
  value = _messages.MessageField('extra_types.JsonValue', 2)


class GoogleCloudPolicytroubleshooterV3alphaIamConditionExplanationEvaluationState(_messages.Message):
  r"""Evaluated state of an expression

  Fields:
    end: End position of an expression in the original condition, by
      character, end included, for example: the end position of the first part
      of "a==b || c==d" would be 4
    start: Start position of an expression in the original condition, by
      character
    value: Value of this expression
  """

  end = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  start = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  value = _messages.MessageField('extra_types.JsonValue', 3)


class GoogleCloudPolicytroubleshooterV3alphaIamDenyPolicyExplanation(_messages.Message):
  r"""Details about how IAM deny policies contributed to the access check.

  Enums:
    DenyAccessStateValueValuesEnum: Indicates whether the member is denied for
      the specified permission for the specified resource, based on evaluating
      all applicable IAM deny policies.
    RelevanceValueValuesEnum: The relevance of the deny policy type to the
      overall access state.

  Fields:
    denyAccessState: Indicates whether the member is denied for the specified
      permission for the specified resource, based on evaluating all
      applicable IAM deny policies.
    explainedResources: List of resources with IAM deny policies that were
      evaluated to check the member's denied permissions, with annotations to
      indicate how each policy contributed to the final result. The list of
      resources can include the policy for the resource itself. It can also
      include policies that are inherited from higher levels of the resource
      hierarchy, including the organization, the folder, and the project. To
      learn more about the resource hierarchy, see
      https://cloud.google.com/iam/help/resource-hierarchy.
    permissionDeniable: Indicates whether the permission to troubleshoot
      supports deny.
    relevance: The relevance of the deny policy type to the overall access
      state.
  """

  class DenyAccessStateValueValuesEnum(_messages.Enum):
    r"""Indicates whether the member is denied for the specified permission
    for the specified resource, based on evaluating all applicable IAM deny
    policies.

    Values:
      DENY_ACCESS_STATE_UNSPECIFIED: Reserved for future use.
      DENY_ACCESS_STATE_DENIED: Access is denied.
      DENY_ACCESS_STATE_NOT_DENIED: Access is not denied.
      DENY_ACCESS_STATE_UNKNOWN_CONDITIONAL: Access is denied only if a
        condition expression evaluates to `true`.
      DENY_ACCESS_STATE_UNKNOWN_INFO: The sender of the request does not have
        access to all of the deny policies that Policy Troubleshooter needs to
        evaluate.
    """
    DENY_ACCESS_STATE_UNSPECIFIED = 0
    DENY_ACCESS_STATE_DENIED = 1
    DENY_ACCESS_STATE_NOT_DENIED = 2
    DENY_ACCESS_STATE_UNKNOWN_CONDITIONAL = 3
    DENY_ACCESS_STATE_UNKNOWN_INFO = 4

  class RelevanceValueValuesEnum(_messages.Enum):
    r"""The relevance of the deny policy type to the overall access state.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Reserved for future use.
      HEURISTIC_RELEVANCE_NORMAL: The data point has a limited effect on the
        result. Changing the data point is unlikely to affect the overall
        determination.
      HEURISTIC_RELEVANCE_HIGH: The data point has a strong effect on the
        result. Changing the data point is likely to affect the overall
        determination.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    HEURISTIC_RELEVANCE_NORMAL = 1
    HEURISTIC_RELEVANCE_HIGH = 2

  denyAccessState = _messages.EnumField('DenyAccessStateValueValuesEnum', 1)
  explainedResources = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaExplainedDenyResource', 2, repeated=True)
  permissionDeniable = _messages.BooleanField(3)
  relevance = _messages.EnumField('RelevanceValueValuesEnum', 4)


class GoogleCloudPolicytroubleshooterV3alphaTroubleshootIamPolicyRequest(_messages.Message):
  r"""Request for TroubleshootIamPolicy.

  Fields:
    accessTuple: The information to use for checking whether a member has a
      permission for a resource.
  """

  accessTuple = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaIamAccessTuple', 1)


class GoogleCloudPolicytroubleshooterV3alphaTroubleshootIamPolicyResponse(_messages.Message):
  r"""Response for TroubleshootIamPolicy.

  Enums:
    OverallAccessStateValueValuesEnum: Indicates whether the member has the
      specified permission for the specified resource, based on evaluating all
      types of the applicable IAM policies.

  Fields:
    accessTuple: The access tuples with evaluation information of both IAM v1
      and v2.
    allowPolicyExplanation: The explanation of IAM Allow policies with
      annotations to indicated how each policy contributed to the final
      result.
    denyPolicyExplanation: The explanation of IAM Allow policies with
      annotations to indicated how each policy contributed to the final
      result.
    overallAccessState: Indicates whether the member has the specified
      permission for the specified resource, based on evaluating all types of
      the applicable IAM policies.
  """

  class OverallAccessStateValueValuesEnum(_messages.Enum):
    r"""Indicates whether the member has the specified permission for the
    specified resource, based on evaluating all types of the applicable IAM
    policies.

    Values:
      OVERALL_ACCESS_STATE_UNSPECIFIED: Reserved for future use.
      CAN_ACCESS: The principal has the access.
      CANNOT_ACCESS: The principal does not have the access.
      UNKNOWN: The principal might have the access but it is unknown. The
        reason for unknown can be: 1. The sender lacks access to information
        needed to get a certain access state. 2. The sender did not provide
        required condition context which is required to get a certain access
        state.
    """
    OVERALL_ACCESS_STATE_UNSPECIFIED = 0
    CAN_ACCESS = 1
    CANNOT_ACCESS = 2
    UNKNOWN = 3

  accessTuple = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaIamAccessTuple', 1)
  allowPolicyExplanation = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaIamAllowPolicyExplanation', 2)
  denyPolicyExplanation = _messages.MessageField('GoogleCloudPolicytroubleshooterV3alphaIamDenyPolicyExplanation', 3)
  overallAccessState = _messages.EnumField('OverallAccessStateValueValuesEnum', 4)


class GoogleTypeExpr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
