"""Generated message classes for cloudasset version v1.

The Cloud Asset API manages the history and inventory of Google Cloud
resources.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudasset'


class AccessSelector(_messages.Message):
  r"""Specifies roles and/or permissions to analyze, to determine both the
  identities possessing them and the resources they control. If multiple
  values are specified, results will include roles or permissions matching any
  of them. The total number of roles and permissions should be equal or less
  than 10.

  Fields:
    permissions: Optional. The permissions to appear in result.
    roles: Optional. The roles to appear in result.
  """

  permissions = _messages.StringField(1, repeated=True)
  roles = _messages.StringField(2, repeated=True)


class AnalyzeIamPolicyLongrunningMetadata(_messages.Message):
  r"""Represents the metadata of the longrunning operation for the
  AnalyzeIamPolicyLongrunning RPC.

  Fields:
    createTime: Output only. The time the operation was created.
  """

  createTime = _messages.StringField(1)


class AnalyzeIamPolicyLongrunningRequest(_messages.Message):
  r"""A request message for AssetService.AnalyzeIamPolicyLongrunning.

  Fields:
    analysisQuery: Required. The request query.
    outputConfig: Required. Output configuration indicating where the results
      will be output to.
    savedAnalysisQuery: Optional. The name of a saved query, which must be in
      the format of: * projects/project_number/savedQueries/saved_query_id *
      folders/folder_number/savedQueries/saved_query_id *
      organizations/organization_number/savedQueries/saved_query_id If both
      `analysis_query` and `saved_analysis_query` are provided, they will be
      merged together with the `saved_analysis_query` as base and the
      `analysis_query` as overrides. For more details of the merge behavior,
      please refer to the [MergeFrom](https://developers.google.com/protocol-b
      uffers/docs/reference/cpp/google.protobuf.message#Message.MergeFrom.deta
      ils) doc. Note that you cannot override primitive fields with default
      value, such as 0 or empty string, etc., because we use proto3, which
      doesn't support field presence yet.
  """

  analysisQuery = _messages.MessageField('IamPolicyAnalysisQuery', 1)
  outputConfig = _messages.MessageField('IamPolicyAnalysisOutputConfig', 2)
  savedAnalysisQuery = _messages.StringField(3)


class AnalyzeIamPolicyLongrunningResponse(_messages.Message):
  r"""A response message for AssetService.AnalyzeIamPolicyLongrunning."""


class AnalyzeIamPolicyResponse(_messages.Message):
  r"""A response message for AssetService.AnalyzeIamPolicy.

  Fields:
    fullyExplored: Represents whether all entries in the main_analysis and
      service_account_impersonation_analysis have been fully explored to
      answer the query in the request.
    mainAnalysis: The main analysis that matches the original request.
    serviceAccountImpersonationAnalysis: The service account impersonation
      analysis if
      AnalyzeIamPolicyRequest.analyze_service_account_impersonation is
      enabled.
  """

  fullyExplored = _messages.BooleanField(1)
  mainAnalysis = _messages.MessageField('IamPolicyAnalysis', 2)
  serviceAccountImpersonationAnalysis = _messages.MessageField('IamPolicyAnalysis', 3, repeated=True)


class AnalyzeMoveResponse(_messages.Message):
  r"""The response message for resource move analysis.

  Fields:
    moveAnalysis: The list of analyses returned from performing the intended
      resource move analysis. The analysis is grouped by different Google
      Cloud services.
  """

  moveAnalysis = _messages.MessageField('MoveAnalysis', 1, repeated=True)


class AnalyzeOrgPoliciesResponse(_messages.Message):
  r"""The response message for AssetService.AnalyzeOrgPolicies.

  Fields:
    constraint: The definition of the constraint in the request.
    nextPageToken: The page token to fetch the next page for
      AnalyzeOrgPoliciesResponse.org_policy_results.
    orgPolicyResults: The organization policies under the
      AnalyzeOrgPoliciesRequest.scope with the
      AnalyzeOrgPoliciesRequest.constraint.
  """

  constraint = _messages.MessageField('AnalyzerOrgPolicyConstraint', 1)
  nextPageToken = _messages.StringField(2)
  orgPolicyResults = _messages.MessageField('OrgPolicyResult', 3, repeated=True)


class AnalyzeOrgPolicyGovernedAssetsResponse(_messages.Message):
  r"""The response message for AssetService.AnalyzeOrgPolicyGovernedAssets.

  Fields:
    constraint: The definition of the constraint in the request.
    governedAssets: The list of the analyzed governed assets.
    nextPageToken: The page token to fetch the next page for
      AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets.
  """

  constraint = _messages.MessageField('AnalyzerOrgPolicyConstraint', 1)
  governedAssets = _messages.MessageField('GoogleCloudAssetV1AnalyzeOrgPolicyGovernedAssetsResponseGovernedAsset', 2, repeated=True)
  nextPageToken = _messages.StringField(3)


class AnalyzeOrgPolicyGovernedContainersResponse(_messages.Message):
  r"""The response message for
  AssetService.AnalyzeOrgPolicyGovernedContainers.

  Fields:
    constraint: The definition of the constraint in the request.
    governedContainers: The list of the analyzed governed containers.
    nextPageToken: The page token to fetch the next page for
      AnalyzeOrgPolicyGovernedContainersResponse.governed_containers.
  """

  constraint = _messages.MessageField('AnalyzerOrgPolicyConstraint', 1)
  governedContainers = _messages.MessageField('GoogleCloudAssetV1GovernedContainer', 2, repeated=True)
  nextPageToken = _messages.StringField(3)


class AnalyzeOrgPolicyGovernedResourcesResponse(_messages.Message):
  r"""The response message for AssetService.AnalyzeOrgPolicyGovernedResources.

  Fields:
    constraint: The definition of the constraint in the request.
    governedResources: The list of the analyzed governed resources.
    nextPageToken: The page token to fetch the next page for
      AnalyzeOrgPolicyGovernedResourcesResponse.governed_resources.
  """

  constraint = _messages.MessageField('AnalyzerOrgPolicyConstraint', 1)
  governedResources = _messages.MessageField('GoogleCloudAssetV1GovernedResource', 2, repeated=True)
  nextPageToken = _messages.StringField(3)


class AnalyzerOrgPolicy(_messages.Message):
  r"""This organization policy message is a modified version of the one
  defined in the Organization Policy system. This message contains several
  fields defined in the original organization policy with some new fields for
  analysis purpose.

  Fields:
    appliedResource: The [full resource name] (https://cloud.google.com/asset-
      inventory/docs/resource-name-format) of an organization/folder/project
      resource where this organization policy applies to. For any user defined
      org policies, this field has the same value as the [attached_resource]
      field. Only for default policy, this field has the different value.
    attachedResource: The [full resource name]
      (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
      an organization/folder/project resource where this organization policy
      is set. Notice that some type of constraints are defined with default
      policy. This field will be empty for them.
    inheritFromParent: If `inherit_from_parent` is true, Rules set higher up
      in the hierarchy (up to the closest root) are inherited and present in
      the effective policy. If it is false, then no rules are inherited, and
      this policy becomes the effective root for evaluation.
    reset: Ignores policies set above this resource and restores the default
      behavior of the constraint at this resource. This field can be set in
      policies for either list or boolean constraints. If set, `rules` must be
      empty and `inherit_from_parent` must be set to false.
    rules: List of rules for this organization policy.
  """

  appliedResource = _messages.StringField(1)
  attachedResource = _messages.StringField(2)
  inheritFromParent = _messages.BooleanField(3)
  reset = _messages.BooleanField(4)
  rules = _messages.MessageField('GoogleCloudAssetV1Rule', 5, repeated=True)


class AnalyzerOrgPolicyConstraint(_messages.Message):
  r"""The organization policy constraint definition.

  Fields:
    customConstraint: The definition of the custom constraint.
    googleDefinedConstraint: The definition of the canned constraint defined
      by Google.
  """

  customConstraint = _messages.MessageField('GoogleCloudAssetV1CustomConstraint', 1)
  googleDefinedConstraint = _messages.MessageField('GoogleCloudAssetV1Constraint', 2)


class Asset(_messages.Message):
  r"""An asset in Google Cloud. An asset can be any resource in the Google
  Cloud [resource hierarchy](https://cloud.google.com/resource-
  manager/docs/cloud-platform-resource-hierarchy), a resource outside the
  Google Cloud resource hierarchy (such as Google Kubernetes Engine clusters
  and objects), or a policy (e.g. IAM policy), or a relationship (e.g. an
  INSTANCE_TO_INSTANCEGROUP relationship). See [Supported asset
  types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
  for more information.

  Fields:
    accessLevel: Please also refer to the [access level user
      guide](https://cloud.google.com/access-context-
      manager/docs/overview#access-levels).
    accessPolicy: Please also refer to the [access policy user
      guide](https://cloud.google.com/access-context-
      manager/docs/overview#access-policies).
    ancestors: The ancestry path of an asset in Google Cloud [resource
      hierarchy](https://cloud.google.com/resource-manager/docs/cloud-
      platform-resource-hierarchy), represented as a list of relative resource
      names. An ancestry path starts with the closest ancestor in the
      hierarchy and ends at root. If the asset is a project, folder, or
      organization, the ancestry path starts from the asset itself. Example:
      `["projects/123456789", "folders/5432", "organizations/1234"]`
    assetType: The type of the asset. Example: `compute.googleapis.com/Disk`
      See [Supported asset types](https://cloud.google.com/asset-
      inventory/docs/supported-asset-types) for more information.
    iamPolicy: A representation of the IAM policy set on a Google Cloud
      resource. There can be a maximum of one IAM policy set on any given
      resource. In addition, IAM policies inherit their granted access scope
      from any policies set on parent resources in the resource hierarchy.
      Therefore, the effectively policy is the union of both the policy set on
      this resource and each policy set on all of the resource's ancestry
      resource levels in the hierarchy. See [this
      topic](https://cloud.google.com/iam/help/allow-policies/inheritance) for
      more information.
    name: The full name of the asset. Example: `//compute.googleapis.com/proje
      cts/my_project_123/zones/zone1/instances/instance1` See [Resource names]
      (https://cloud.google.com/apis/design/resource_names#full_resource_name)
      for more information.
    orgPolicy: A representation of an [organization
      policy](https://cloud.google.com/resource-manager/docs/organization-
      policy/overview#organization_policy). There can be more than one
      organization policy with different constraints set on a given resource.
    osInventory: A representation of runtime OS Inventory information. See
      [this topic](https://cloud.google.com/compute/docs/instances/os-
      inventory-management) for more information.
    relatedAsset: One related asset of the current asset.
    relatedAssets: DEPRECATED. This field only presents for the purpose of
      backward-compatibility. The server will never generate responses with
      this field. The related assets of the asset of one relationship type.
      One asset only represents one type of relationship.
    resource: A representation of the resource.
    servicePerimeter: Please also refer to the [service perimeter user
      guide](https://cloud.google.com/vpc-service-controls/docs/overview).
    updateTime: The last update timestamp of an asset. update_time is updated
      when create/update/delete operation is performed.
  """

  accessLevel = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1AccessLevel', 1)
  accessPolicy = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1AccessPolicy', 2)
  ancestors = _messages.StringField(3, repeated=True)
  assetType = _messages.StringField(4)
  iamPolicy = _messages.MessageField('Policy', 5)
  name = _messages.StringField(6)
  orgPolicy = _messages.MessageField('GoogleCloudOrgpolicyV1Policy', 7, repeated=True)
  osInventory = _messages.MessageField('Inventory', 8)
  relatedAsset = _messages.MessageField('RelatedAsset', 9)
  relatedAssets = _messages.MessageField('RelatedAssets', 10)
  resource = _messages.MessageField('Resource', 11)
  servicePerimeter = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1ServicePerimeter', 12)
  updateTime = _messages.StringField(13)


class AttachedResource(_messages.Message):
  r"""Attached resource representation, which is defined by the corresponding
  service provider. It represents an attached resource's payload.

  Fields:
    assetType: The type of this attached resource. Example:
      `osconfig.googleapis.com/Inventory` You can find the supported attached
      asset types of each resource in this table:
      `https://cloud.google.com/asset-inventory/docs/supported-asset-
      types#searchable_asset_types`
    versionedResources: Versioned resource representations of this attached
      resource. This is repeated because there could be multiple versions of
      the attached resource representations during version migration.
  """

  assetType = _messages.StringField(1)
  versionedResources = _messages.MessageField('VersionedResource', 2, repeated=True)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class BatchGetAssetsHistoryResponse(_messages.Message):
  r"""Batch get assets history response.

  Fields:
    assets: A list of assets with valid time windows.
  """

  assets = _messages.MessageField('TemporalAsset', 1, repeated=True)


class BatchGetEffectiveIamPoliciesResponse(_messages.Message):
  r"""A response message for AssetService.BatchGetEffectiveIamPolicies.

  Fields:
    policyResults: The effective policies for a batch of resources. Note that
      the results order is the same as the order of
      BatchGetEffectiveIamPoliciesRequest.names. When a resource does not have
      any effective IAM policies, its corresponding policy_result will contain
      empty EffectiveIamPolicy.policies.
  """

  policyResults = _messages.MessageField('EffectiveIamPolicy', 1, repeated=True)


class BigQueryDestination(_messages.Message):
  r"""A BigQuery destination for exporting assets to.

  Fields:
    dataset: Required. The BigQuery dataset in format
      "projects/projectId/datasets/datasetId", to which the snapshot result
      should be exported. If this dataset does not exist, the export call
      returns an INVALID_ARGUMENT error. Setting the `contentType` for
      `exportAssets` determines the [schema](/asset-inventory/docs/exporting-
      to-bigquery#bigquery-schema) of the BigQuery table. Setting
      `separateTablesPerAssetType` to `TRUE` also influences the schema.
    force: If the destination table already exists and this flag is `TRUE`,
      the table will be overwritten by the contents of assets snapshot. If the
      flag is `FALSE` or unset and the destination table already exists, the
      export call returns an INVALID_ARGUMEMT error.
    partitionSpec: [partition_spec] determines whether to export to
      partitioned table(s) and how to partition the data. If [partition_spec]
      is unset or [partition_spec.partition_key] is unset or
      `PARTITION_KEY_UNSPECIFIED`, the snapshot results will be exported to
      non-partitioned table(s). [force] will decide whether to overwrite
      existing table(s). If [partition_spec] is specified. First, the snapshot
      results will be written to partitioned table(s) with two additional
      timestamp columns, readTime and requestTime, one of which will be the
      partition key. Secondly, in the case when any destination table already
      exists, it will first try to update existing table's schema as necessary
      by appending additional columns. Then, if [force] is `TRUE`, the
      corresponding partition will be overwritten by the snapshot results
      (data in different partitions will remain intact); if [force] is unset
      or `FALSE`, it will append the data. An error will be returned if the
      schema update or data appension fails.
    separateTablesPerAssetType: If this flag is `TRUE`, the snapshot results
      will be written to one or multiple tables, each of which contains
      results of one asset type. The [force] and [partition_spec] fields will
      apply to each of them. Field [table] will be concatenated with "_" and
      the asset type names (see https://cloud.google.com/asset-
      inventory/docs/supported-asset-types for supported asset types) to
      construct per-asset-type table names, in which all non-alphanumeric
      characters like "." and "/" will be substituted by "_". Example: if
      field [table] is "mytable" and snapshot results contain
      "storage.googleapis.com/Bucket" assets, the corresponding table name
      will be "mytable_storage_googleapis_com_Bucket". If any of these tables
      does not exist, a new table with the concatenated name will be created.
      When [content_type] in the ExportAssetsRequest is `RESOURCE`, the schema
      of each table will include RECORD-type columns mapped to the nested
      fields in the Asset.resource.data field of that asset type (up to the 15
      nested level BigQuery supports
      (https://cloud.google.com/bigquery/docs/nested-repeated#limitations)).
      The fields in >15 nested levels will be stored in JSON format string as
      a child column of its parent RECORD column. If error occurs when
      exporting to any table, the whole export call will return an error but
      the export results that already succeed will persist. Example: if
      exporting to table_type_A succeeds when exporting to table_type_B fails
      during one export call, the results in table_type_A will persist and
      there will not be partial results persisting in a table.
    table: Required. The BigQuery table to which the snapshot result should be
      written. If this table does not exist, a new table with the given name
      will be created.
  """

  dataset = _messages.StringField(1)
  force = _messages.BooleanField(2)
  partitionSpec = _messages.MessageField('PartitionSpec', 3)
  separateTablesPerAssetType = _messages.BooleanField(4)
  table = _messages.StringField(5)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CloudassetAnalyzeIamPolicyLongrunningRequest(_messages.Message):
  r"""A CloudassetAnalyzeIamPolicyLongrunningRequest object.

  Fields:
    analyzeIamPolicyLongrunningRequest: A AnalyzeIamPolicyLongrunningRequest
      resource to be passed as the request body.
    scope: Required. The relative name of the root asset. Only resources and
      IAM policies within the scope will be analyzed. This can only be an
      organization number (such as "organizations/123"), a folder number (such
      as "folders/123"), a project ID (such as "projects/my-project-id"), or a
      project number (such as "projects/12345"). To know how to get
      organization id, visit [here ](https://cloud.google.com/resource-
      manager/docs/creating-managing-
      organization#retrieving_your_organization_id). To know how to get folder
      or project id, visit [here ](https://cloud.google.com/resource-
      manager/docs/creating-managing-
      folders#viewing_or_listing_folders_and_projects).
  """

  analyzeIamPolicyLongrunningRequest = _messages.MessageField('AnalyzeIamPolicyLongrunningRequest', 1)
  scope = _messages.StringField(2, required=True)


class CloudassetAnalyzeIamPolicyRequest(_messages.Message):
  r"""A CloudassetAnalyzeIamPolicyRequest object.

  Fields:
    analysisQuery_accessSelector_permissions: Optional. The permissions to
      appear in result.
    analysisQuery_accessSelector_roles: Optional. The roles to appear in
      result.
    analysisQuery_conditionContext_accessTime: The hypothetical access
      timestamp to evaluate IAM conditions. Note that this value must not be
      earlier than the current time; otherwise, an INVALID_ARGUMENT error will
      be returned.
    analysisQuery_identitySelector_identity: Required. The identity appear in
      the form of principals in [IAM policy
      binding](https://cloud.google.com/iam/reference/rest/v1/Binding). The
      examples of supported forms are: "user:mike@example.com",
      "group:admins@example.com", "domain:google.com", "serviceAccount:my-
      project-id@appspot.gserviceaccount.com". Notice that wildcard characters
      (such as * and ?) are not supported. You must give a specific identity.
    analysisQuery_options_analyzeServiceAccountImpersonation: Optional. If
      true, the response will include access analysis from identities to
      resources via service account impersonation. This is a very expensive
      operation, because many derived queries will be executed. We highly
      recommend you use AssetService.AnalyzeIamPolicyLongrunning RPC instead.
      For example, if the request analyzes for which resources user A has
      permission P, and there's an IAM policy states user A has
      iam.serviceAccounts.getAccessToken permission to a service account SA,
      and there's another IAM policy states service account SA has permission
      P to a Google Cloud folder F, then user A potentially has access to the
      Google Cloud folder F. And those advanced analysis results will be
      included in
      AnalyzeIamPolicyResponse.service_account_impersonation_analysis. Another
      example, if the request analyzes for who has permission P to a Google
      Cloud folder F, and there's an IAM policy states user A has
      iam.serviceAccounts.actAs permission to a service account SA, and
      there's another IAM policy states service account SA has permission P to
      the Google Cloud folder F, then user A potentially has access to the
      Google Cloud folder F. And those advanced analysis results will be
      included in
      AnalyzeIamPolicyResponse.service_account_impersonation_analysis. Only
      the following permissions are considered in this analysis: *
      `iam.serviceAccounts.actAs` * `iam.serviceAccounts.signBlob` *
      `iam.serviceAccounts.signJwt` * `iam.serviceAccounts.getAccessToken` *
      `iam.serviceAccounts.getOpenIdToken` *
      `iam.serviceAccounts.implicitDelegation` Default is false.
    analysisQuery_options_expandGroups: Optional. If true, the identities
      section of the result will expand any Google groups appearing in an IAM
      policy binding. If IamPolicyAnalysisQuery.identity_selector is
      specified, the identity in the result will be determined by the
      selector, and this flag is not allowed to set. If true, the default max
      expansion per group is 1000 for AssetService.AnalyzeIamPolicy][].
      Default is false.
    analysisQuery_options_expandResources: Optional. If true and
      IamPolicyAnalysisQuery.resource_selector is not specified, the resource
      section of the result will expand any resource attached to an IAM policy
      to include resources lower in the resource hierarchy. For example, if
      the request analyzes for which resources user A has permission P, and
      the results include an IAM policy with P on a Google Cloud folder, the
      results will also include resources in that folder with permission P. If
      true and IamPolicyAnalysisQuery.resource_selector is specified, the
      resource section of the result will expand the specified resource to
      include resources lower in the resource hierarchy. Only project or lower
      resources are supported. Folder and organization resources cannot be
      used together with this option. For example, if the request analyzes for
      which users have permission P on a Google Cloud project with this option
      enabled, the results will include all users who have permission P on
      that project or any lower resource. If true, the default max expansion
      per resource is 1000 for AssetService.AnalyzeIamPolicy][] and 100000 for
      AssetService.AnalyzeIamPolicyLongrunning][]. Default is false.
    analysisQuery_options_expandRoles: Optional. If true, the access section
      of result will expand any roles appearing in IAM policy bindings to
      include their permissions. If IamPolicyAnalysisQuery.access_selector is
      specified, the access section of the result will be determined by the
      selector, and this flag is not allowed to set. Default is false.
    analysisQuery_options_outputGroupEdges: Optional. If true, the result will
      output the relevant membership relationships between groups and other
      groups, and between groups and principals. Default is false.
    analysisQuery_options_outputResourceEdges: Optional. If true, the result
      will output the relevant parent/child relationships between resources.
      Default is false.
    analysisQuery_resourceSelector_fullResourceName: Required. The [full
      resource name] (https://cloud.google.com/asset-inventory/docs/resource-
      name-format) of a resource of [supported resource
      types](https://cloud.google.com/asset-inventory/docs/supported-asset-
      types#analyzable_asset_types).
    executionTimeout: Optional. Amount of time executable has to complete. See
      JSON representation of
      [Duration](https://developers.google.com/protocol-
      buffers/docs/proto3#json). If this field is set with a value less than
      the RPC deadline, and the execution of your query hasn't finished in the
      specified execution timeout, you will get a response with partial
      result. Otherwise, your query's execution will continue until the RPC
      deadline. If it's not finished until then, you will get a
      DEADLINE_EXCEEDED error. Default is empty.
    savedAnalysisQuery: Optional. The name of a saved query, which must be in
      the format of: * projects/project_number/savedQueries/saved_query_id *
      folders/folder_number/savedQueries/saved_query_id *
      organizations/organization_number/savedQueries/saved_query_id If both
      `analysis_query` and `saved_analysis_query` are provided, they will be
      merged together with the `saved_analysis_query` as base and the
      `analysis_query` as overrides. For more details of the merge behavior,
      please refer to the [MergeFrom](https://developers.google.com/protocol-b
      uffers/docs/reference/cpp/google.protobuf.message#Message.MergeFrom.deta
      ils) page. Note that you cannot override primitive fields with default
      value, such as 0 or empty string, etc., because we use proto3, which
      doesn't support field presence yet.
    scope: Required. The relative name of the root asset. Only resources and
      IAM policies within the scope will be analyzed. This can only be an
      organization number (such as "organizations/123"), a folder number (such
      as "folders/123"), a project ID (such as "projects/my-project-id"), or a
      project number (such as "projects/12345"). To know how to get
      organization id, visit [here ](https://cloud.google.com/resource-
      manager/docs/creating-managing-
      organization#retrieving_your_organization_id). To know how to get folder
      or project id, visit [here ](https://cloud.google.com/resource-
      manager/docs/creating-managing-
      folders#viewing_or_listing_folders_and_projects).
  """

  analysisQuery_accessSelector_permissions = _messages.StringField(1, repeated=True)
  analysisQuery_accessSelector_roles = _messages.StringField(2, repeated=True)
  analysisQuery_conditionContext_accessTime = _messages.StringField(3)
  analysisQuery_identitySelector_identity = _messages.StringField(4)
  analysisQuery_options_analyzeServiceAccountImpersonation = _messages.BooleanField(5)
  analysisQuery_options_expandGroups = _messages.BooleanField(6)
  analysisQuery_options_expandResources = _messages.BooleanField(7)
  analysisQuery_options_expandRoles = _messages.BooleanField(8)
  analysisQuery_options_outputGroupEdges = _messages.BooleanField(9)
  analysisQuery_options_outputResourceEdges = _messages.BooleanField(10)
  analysisQuery_resourceSelector_fullResourceName = _messages.StringField(11)
  executionTimeout = _messages.StringField(12)
  savedAnalysisQuery = _messages.StringField(13)
  scope = _messages.StringField(14, required=True)


class CloudassetAnalyzeMoveRequest(_messages.Message):
  r"""A CloudassetAnalyzeMoveRequest object.

  Enums:
    ViewValueValuesEnum: Analysis view indicating what information should be
      included in the analysis response. If unspecified, the default view is
      FULL.

  Fields:
    destinationParent: Required. Name of the Google Cloud folder or
      organization to reparent the target resource. The analysis will be
      performed against hypothetically moving the resource to this specified
      desitination parent. This can only be a folder number (such as
      "folders/123") or an organization number (such as "organizations/123").
    resource: Required. Name of the resource to perform the analysis against.
      Only Google Cloud projects are supported as of today. Hence, this can
      only be a project ID (such as "projects/my-project-id") or a project
      number (such as "projects/12345").
    view: Analysis view indicating what information should be included in the
      analysis response. If unspecified, the default view is FULL.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Analysis view indicating what information should be included in the
    analysis response. If unspecified, the default view is FULL.

    Values:
      ANALYSIS_VIEW_UNSPECIFIED: The default/unset value. The API will default
        to the FULL view.
      FULL: Full analysis including all level of impacts of the specified
        resource move.
      BASIC: Basic analysis only including blockers which will prevent the
        specified resource move at runtime.
    """
    ANALYSIS_VIEW_UNSPECIFIED = 0
    FULL = 1
    BASIC = 2

  destinationParent = _messages.StringField(1)
  resource = _messages.StringField(2, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 3)


class CloudassetAnalyzeOrgPoliciesRequest(_messages.Message):
  r"""A CloudassetAnalyzeOrgPoliciesRequest object.

  Fields:
    constraint: Required. The name of the constraint to analyze organization
      policies for. The response only contains analyzed organization policies
      for the provided constraint.
    filter: The expression to filter
      AnalyzeOrgPoliciesResponse.org_policy_results. The only supported field
      is `consolidated_policy.attached_resource`, and the only supported
      operator is `=`. Example: consolidated_policy.attached_resource="//cloud
      resourcemanager.googleapis.com/folders/001" will return the org policy
      results of"folders/001".
    pageSize: The maximum number of items to return per page. If unspecified,
      AnalyzeOrgPoliciesResponse.org_policy_results will contain 20 items with
      a maximum of 200.
    pageToken: The pagination token to retrieve the next page.
    scope: Required. The organization to scope the request. Only organization
      policies within the scope will be analyzed. *
      organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
  """

  constraint = _messages.StringField(1)
  filter = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  scope = _messages.StringField(5, required=True)


class CloudassetAnalyzeOrgPolicyGovernedAssetsRequest(_messages.Message):
  r"""A CloudassetAnalyzeOrgPolicyGovernedAssetsRequest object.

  Fields:
    constraint: Required. The name of the constraint to analyze governed
      assets for. The analysis only contains analyzed organization policies
      for the provided constraint.
    filter: The expression to filter the governed assets in result. The only
      supported fields for governed resources are `governed_resource.project`
      and `governed_resource.folders`. The only supported fields for governed
      iam policies are `governed_iam_policy.project` and
      `governed_iam_policy.folders`. The only supported operator is `=`.
      Example 1: governed_resource.project="projects/12345678" filter will
      return all governed resources under projects/12345678 including the
      project ifself, if applicable. Example 2:
      governed_iam_policy.folders="folders/12345678" filter will return all
      governed iam policies under folders/12345678, if applicable.
    pageSize: The maximum number of items to return per page. If unspecified,
      AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets will contain 100
      items with a maximum of 200.
    pageToken: The pagination token to retrieve the next page.
    scope: Required. The organization to scope the request. Only organization
      policies within the scope will be analyzed. The output assets will also
      be limited to the ones governed by those in-scope organization policies.
      * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
  """

  constraint = _messages.StringField(1)
  filter = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  scope = _messages.StringField(5, required=True)


class CloudassetAnalyzeOrgPolicyGovernedContainersRequest(_messages.Message):
  r"""A CloudassetAnalyzeOrgPolicyGovernedContainersRequest object.

  Fields:
    constraint: Required. The name of the constraint to analyze governed
      containers for. The analysis only contains organization policies for the
      provided constraint.
    filter: The expression to filter the governed containers in result. The
      only supported field is `parent`, and the only supported operator is
      `=`. Example: parent="//cloudresourcemanager.googleapis.com/folders/001"
      will return all containers under "folders/001".
    pageSize: The maximum number of items to return per page. If unspecified,
      AnalyzeOrgPolicyGovernedContainersResponse.governed_containers will
      contain 100 items with a maximum of 200.
    pageToken: The pagination token to retrieve the next page.
    scope: Required. The organization to scope the request. Only organization
      policies within the scope will be analyzed. The output containers will
      also be limited to the ones governed by those in-scope organization
      policies. * organizations/{ORGANIZATION_NUMBER} (e.g.,
      "organizations/123456")
  """

  constraint = _messages.StringField(1)
  filter = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  scope = _messages.StringField(5, required=True)


class CloudassetAnalyzeOrgPolicyGovernedResourcesRequest(_messages.Message):
  r"""A CloudassetAnalyzeOrgPolicyGovernedResourcesRequest object.

  Fields:
    constraint: Required. The name of the constraint to analyze governed
      resources for. The analysis only contains analyzed organization policies
      for the provided constraint.
    filter: The expression to filter the governed resources in result. The
      only supported fields are `project` and `folders`, and the only
      supported operator is `=`. Example: project="projects/12345678" filter
      will return all governed resources under projects/12345678 including the
      project ifself, if applicable.
    pageSize: The maximum number of items to return per page. If unspecified,
      AnalyzeOrgPolicyGovernedResourcesResponse.governed_resources will
      contain 100 items with a maximum of 200.
    pageToken: The pagination token to retrieve the next page.
    scope: Required. The organization to scope the request. Only organization
      policies within the scope will be analyzed. The output resources will
      also be limited to the ones governed by those in-scope organization
      policies. * organizations/{ORGANIZATION_NUMBER} (e.g.,
      "organizations/123456")
  """

  constraint = _messages.StringField(1)
  filter = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  scope = _messages.StringField(5, required=True)


class CloudassetAssetsListRequest(_messages.Message):
  r"""A CloudassetAssetsListRequest object.

  Enums:
    ContentTypeValueValuesEnum: Asset content type. If not specified, no
      content but the asset name will be returned.

  Fields:
    assetTypes: A list of asset types to take a snapshot for. For example:
      "compute.googleapis.com/Disk". Regular expression is also supported. For
      example: * "compute.googleapis.com.*" snapshots resources whose asset
      type starts with "compute.googleapis.com". * ".*Instance" snapshots
      resources whose asset type ends with "Instance". * ".*Instance.*"
      snapshots resources whose asset type contains "Instance". See
      [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
      regular expression syntax. If the regular expression does not match any
      supported asset type, an INVALID_ARGUMENT error will be returned. If
      specified, only matching assets will be returned, otherwise, it will
      snapshot all asset types. See [Introduction to Cloud Asset
      Inventory](https://cloud.google.com/asset-inventory/docs/overview) for
      all supported asset types.
    contentType: Asset content type. If not specified, no content but the
      asset name will be returned.
    pageSize: The maximum number of assets to be returned in a single
      response. Default is 100, minimum is 1, and maximum is 1000.
    pageToken: The `next_page_token` returned from the previous
      `ListAssetsResponse`, or unspecified for the first `ListAssetsRequest`.
      It is a continuation of a prior `ListAssets` call, and the API should
      return the next page of assets.
    parent: Required. Name of the organization, folder, or project the assets
      belong to. Format: "organizations/[organization-number]" (such as
      "organizations/123"), "projects/[project-id]" (such as "projects/my-
      project-id"), "projects/[project-number]" (such as "projects/12345"), or
      "folders/[folder-number]" (such as "folders/12345").
    readTime: Timestamp to take an asset snapshot. This can only be set to a
      timestamp between the current time and the current time minus 35 days
      (inclusive). If not specified, the current time will be used. Due to
      delays in resource data collection and indexing, there is a volatile
      window during which running the same query may get different results.
    relationshipTypes: A list of relationship types to output, for example:
      `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
      content_type=RELATIONSHIP. * If specified: it snapshots specified
      relationships. It returns an error if any of the [relationship_types]
      doesn't belong to the supported relationship types of the [asset_types]
      or if any of the [asset_types] doesn't belong to the source types of the
      [relationship_types]. * Otherwise: it snapshots the supported
      relationships for all [asset_types] or returns an error if any of the
      [asset_types] has no relationship support. An unspecified asset types
      field means all supported asset_types. See [Introduction to Cloud Asset
      Inventory](https://cloud.google.com/asset-inventory/docs/overview) for
      all supported asset types and relationship types.
  """

  class ContentTypeValueValuesEnum(_messages.Enum):
    r"""Asset content type. If not specified, no content but the asset name
    will be returned.

    Values:
      CONTENT_TYPE_UNSPECIFIED: Unspecified content type.
      RESOURCE: Resource metadata.
      IAM_POLICY: The actual IAM policy set on a resource.
      ORG_POLICY: The organization policy set on an asset.
      ACCESS_POLICY: The Access Context Manager policy set on an asset.
      OS_INVENTORY: The runtime OS Inventory information.
      RELATIONSHIP: The related resources.
    """
    CONTENT_TYPE_UNSPECIFIED = 0
    RESOURCE = 1
    IAM_POLICY = 2
    ORG_POLICY = 3
    ACCESS_POLICY = 4
    OS_INVENTORY = 5
    RELATIONSHIP = 6

  assetTypes = _messages.StringField(1, repeated=True)
  contentType = _messages.EnumField('ContentTypeValueValuesEnum', 2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  readTime = _messages.StringField(6)
  relationshipTypes = _messages.StringField(7, repeated=True)


class CloudassetBatchGetAssetsHistoryRequest(_messages.Message):
  r"""A CloudassetBatchGetAssetsHistoryRequest object.

  Enums:
    ContentTypeValueValuesEnum: Optional. The content type.

  Fields:
    assetNames: A list of the full names of the assets. See:
      https://cloud.google.com/asset-inventory/docs/resource-name-format
      Example: `//compute.googleapis.com/projects/my_project_123/zones/zone1/i
      nstances/instance1`. The request becomes a no-op if the asset name list
      is empty, and the max size of the asset name list is 100 in one request.
    contentType: Optional. The content type.
    parent: Required. The relative name of the root asset. It can only be an
      organization number (such as "organizations/123"), a project ID (such as
      "projects/my-project-id")", or a project number (such as
      "projects/12345").
    readTimeWindow_endTime: End time of the time window (inclusive). If not
      specified, the current timestamp is used instead.
    readTimeWindow_startTime: Start time of the time window (exclusive).
    relationshipTypes: Optional. A list of relationship types to output, for
      example: `INSTANCE_TO_INSTANCEGROUP`. This field should only be
      specified if content_type=RELATIONSHIP. * If specified: it outputs
      specified relationships' history on the [asset_names]. It returns an
      error if any of the [relationship_types] doesn't belong to the supported
      relationship types of the [asset_names] or if any of the [asset_names]'s
      types doesn't belong to the source types of the [relationship_types]. *
      Otherwise: it outputs the supported relationships' history on the
      [asset_names] or returns an error if any of the [asset_names]'s types
      has no relationship support. See [Introduction to Cloud Asset
      Inventory](https://cloud.google.com/asset-inventory/docs/overview) for
      all supported asset types and relationship types.
  """

  class ContentTypeValueValuesEnum(_messages.Enum):
    r"""Optional. The content type.

    Values:
      CONTENT_TYPE_UNSPECIFIED: Unspecified content type.
      RESOURCE: Resource metadata.
      IAM_POLICY: The actual IAM policy set on a resource.
      ORG_POLICY: The organization policy set on an asset.
      ACCESS_POLICY: The Access Context Manager policy set on an asset.
      OS_INVENTORY: The runtime OS Inventory information.
      RELATIONSHIP: The related resources.
    """
    CONTENT_TYPE_UNSPECIFIED = 0
    RESOURCE = 1
    IAM_POLICY = 2
    ORG_POLICY = 3
    ACCESS_POLICY = 4
    OS_INVENTORY = 5
    RELATIONSHIP = 6

  assetNames = _messages.StringField(1, repeated=True)
  contentType = _messages.EnumField('ContentTypeValueValuesEnum', 2)
  parent = _messages.StringField(3, required=True)
  readTimeWindow_endTime = _messages.StringField(4)
  readTimeWindow_startTime = _messages.StringField(5)
  relationshipTypes = _messages.StringField(6, repeated=True)


class CloudassetEffectiveIamPoliciesBatchGetRequest(_messages.Message):
  r"""A CloudassetEffectiveIamPoliciesBatchGetRequest object.

  Fields:
    names: Required. The names refer to the [full_resource_names]
      (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
      [searchable asset types](https://cloud.google.com/asset-
      inventory/docs/supported-asset-types#searchable_asset_types). A maximum
      of 20 resources' effective policies can be retrieved in a batch.
    scope: Required. Only IAM policies on or below the scope will be returned.
      This can only be an organization number (such as "organizations/123"), a
      folder number (such as "folders/123"), a project ID (such as
      "projects/my-project-id"), or a project number (such as
      "projects/12345"). To know how to get organization id, visit [here
      ](https://cloud.google.com/resource-manager/docs/creating-managing-
      organization#retrieving_your_organization_id). To know how to get folder
      or project id, visit [here ](https://cloud.google.com/resource-
      manager/docs/creating-managing-
      folders#viewing_or_listing_folders_and_projects).
  """

  names = _messages.StringField(1, repeated=True)
  scope = _messages.StringField(2, required=True)


class CloudassetExportAssetsRequest(_messages.Message):
  r"""A CloudassetExportAssetsRequest object.

  Fields:
    exportAssetsRequest: A ExportAssetsRequest resource to be passed as the
      request body.
    parent: Required. The relative name of the root asset. This can only be an
      organization number (such as "organizations/123"), a project ID (such as
      "projects/my-project-id"), or a project number (such as
      "projects/12345"), or a folder number (such as "folders/123").
  """

  exportAssetsRequest = _messages.MessageField('ExportAssetsRequest', 1)
  parent = _messages.StringField(2, required=True)


class CloudassetFeedsCreateRequest(_messages.Message):
  r"""A CloudassetFeedsCreateRequest object.

  Fields:
    createFeedRequest: A CreateFeedRequest resource to be passed as the
      request body.
    parent: Required. The name of the project/folder/organization where this
      feed should be created in. It can only be an organization number (such
      as "organizations/123"), a folder number (such as "folders/123"), a
      project ID (such as "projects/my-project-id")", or a project number
      (such as "projects/12345").
  """

  createFeedRequest = _messages.MessageField('CreateFeedRequest', 1)
  parent = _messages.StringField(2, required=True)


class CloudassetFeedsDeleteRequest(_messages.Message):
  r"""A CloudassetFeedsDeleteRequest object.

  Fields:
    name: Required. The name of the feed and it must be in the format of:
      projects/project_number/feeds/feed_id
      folders/folder_number/feeds/feed_id
      organizations/organization_number/feeds/feed_id
  """

  name = _messages.StringField(1, required=True)


class CloudassetFeedsGetRequest(_messages.Message):
  r"""A CloudassetFeedsGetRequest object.

  Fields:
    name: Required. The name of the Feed and it must be in the format of:
      projects/project_number/feeds/feed_id
      folders/folder_number/feeds/feed_id
      organizations/organization_number/feeds/feed_id
  """

  name = _messages.StringField(1, required=True)


class CloudassetFeedsListRequest(_messages.Message):
  r"""A CloudassetFeedsListRequest object.

  Fields:
    parent: Required. The parent project/folder/organization whose feeds are
      to be listed. It can only be using project/folder/organization number
      (such as "folders/12345")", or a project ID (such as "projects/my-
      project-id").
  """

  parent = _messages.StringField(1, required=True)


class CloudassetFeedsPatchRequest(_messages.Message):
  r"""A CloudassetFeedsPatchRequest object.

  Fields:
    name: Required. The format will be
      projects/{project_number}/feeds/{client-assigned_feed_identifier} or
      folders/{folder_number}/feeds/{client-assigned_feed_identifier} or
      organizations/{organization_number}/feeds/{client-
      assigned_feed_identifier} The client-assigned feed identifier must be
      unique within the parent project/folder/organization.
    updateFeedRequest: A UpdateFeedRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  updateFeedRequest = _messages.MessageField('UpdateFeedRequest', 2)


class CloudassetOperationsGetRequest(_messages.Message):
  r"""A CloudassetOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CloudassetQueryAssetsRequest(_messages.Message):
  r"""A CloudassetQueryAssetsRequest object.

  Fields:
    parent: Required. The relative name of the root asset. This can only be an
      organization number (such as "organizations/123"), a project ID (such as
      "projects/my-project-id"), or a project number (such as
      "projects/12345"), or a folder number (such as "folders/123"). Only
      assets belonging to the `parent` will be returned.
    queryAssetsRequest: A QueryAssetsRequest resource to be passed as the
      request body.
  """

  parent = _messages.StringField(1, required=True)
  queryAssetsRequest = _messages.MessageField('QueryAssetsRequest', 2)


class CloudassetSavedQueriesCreateRequest(_messages.Message):
  r"""A CloudassetSavedQueriesCreateRequest object.

  Fields:
    parent: Required. The name of the project/folder/organization where this
      saved_query should be created in. It can only be an organization number
      (such as "organizations/123"), a folder number (such as "folders/123"),
      a project ID (such as "projects/my-project-id")", or a project number
      (such as "projects/12345").
    savedQuery: A SavedQuery resource to be passed as the request body.
    savedQueryId: Required. The ID to use for the saved query, which must be
      unique in the specified parent. It will become the final component of
      the saved query's resource name. This value should be 4-63 characters,
      and valid characters are `a-z-`. Notice that this field is required in
      the saved query creation, and the `name` field of the `saved_query` will
      be ignored.
  """

  parent = _messages.StringField(1, required=True)
  savedQuery = _messages.MessageField('SavedQuery', 2)
  savedQueryId = _messages.StringField(3)


class CloudassetSavedQueriesDeleteRequest(_messages.Message):
  r"""A CloudassetSavedQueriesDeleteRequest object.

  Fields:
    name: Required. The name of the saved query to delete. It must be in the
      format of: * projects/project_number/savedQueries/saved_query_id *
      folders/folder_number/savedQueries/saved_query_id *
      organizations/organization_number/savedQueries/saved_query_id
  """

  name = _messages.StringField(1, required=True)


class CloudassetSavedQueriesGetRequest(_messages.Message):
  r"""A CloudassetSavedQueriesGetRequest object.

  Fields:
    name: Required. The name of the saved query and it must be in the format
      of: * projects/project_number/savedQueries/saved_query_id *
      folders/folder_number/savedQueries/saved_query_id *
      organizations/organization_number/savedQueries/saved_query_id
  """

  name = _messages.StringField(1, required=True)


class CloudassetSavedQueriesListRequest(_messages.Message):
  r"""A CloudassetSavedQueriesListRequest object.

  Fields:
    filter: Optional. The expression to filter resources. The expression is a
      list of zero or more restrictions combined via logical operators `AND`
      and `OR`. When `AND` and `OR` are both used in the expression,
      parentheses must be appropriately used to group the combinations. The
      expression may also contain regular expressions. See
      https://google.aip.dev/160 for more information on the grammar.
    pageSize: Optional. The maximum number of saved queries to return per
      page. The service may return fewer than this value. If unspecified, at
      most 50 will be returned. The maximum value is 1000; values above 1000
      will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListSavedQueries` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to `ListSavedQueries`
      must match the call that provided the page token.
    parent: Required. The parent project/folder/organization whose
      savedQueries are to be listed. It can only be using
      project/folder/organization number (such as "folders/12345")", or a
      project ID (such as "projects/my-project-id").
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class CloudassetSavedQueriesPatchRequest(_messages.Message):
  r"""A CloudassetSavedQueriesPatchRequest object.

  Fields:
    name: The resource name of the saved query. The format must be: *
      projects/project_number/savedQueries/saved_query_id *
      folders/folder_number/savedQueries/saved_query_id *
      organizations/organization_number/savedQueries/saved_query_id
    savedQuery: A SavedQuery resource to be passed as the request body.
    updateMask: Required. The list of fields to update.
  """

  name = _messages.StringField(1, required=True)
  savedQuery = _messages.MessageField('SavedQuery', 2)
  updateMask = _messages.StringField(3)


class CloudassetSearchAllIamPoliciesRequest(_messages.Message):
  r"""A CloudassetSearchAllIamPoliciesRequest object.

  Fields:
    assetTypes: Optional. A list of asset types that the IAM policies are
      attached to. If empty, it will search the IAM policies that are attached
      to all the [searchable asset types](https://cloud.google.com/asset-
      inventory/docs/supported-asset-types#searchable_asset_types). Regular
      expressions are also supported. For example: *
      "compute.googleapis.com.*" snapshots IAM policies attached to asset type
      starts with "compute.googleapis.com". * ".*Instance" snapshots IAM
      policies attached to asset type ends with "Instance". * ".*Instance.*"
      snapshots IAM policies attached to asset type contains "Instance". See
      [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
      regular expression syntax. If the regular expression does not match any
      supported asset type, an INVALID_ARGUMENT error will be returned.
    orderBy: Optional. A comma-separated list of fields specifying the sorting
      order of the results. The default order is ascending. Add " DESC" after
      the field name to indicate descending order. Redundant space characters
      are ignored. Example: "assetType DESC, resource". Only singular
      primitive fields in the response are sortable: * resource * assetType *
      project All the other fields such as repeated fields (e.g., `folders`)
      and non-primitive fields (e.g., `policy`) are not supported.
    pageSize: Optional. The page size for search result pagination. Page size
      is capped at 500 even if a larger value is given. If set to zero, server
      will pick an appropriate default. Returned results may be fewer than
      requested. When this happens, there could be more results as long as
      `next_page_token` is returned.
    pageToken: Optional. If present, retrieve the next batch of results from
      the preceding call to this method. `page_token` must be the value of
      `next_page_token` from the previous response. The values of all other
      method parameters must be identical to those in the previous call.
    query: Optional. The query statement. See [how to construct a
      query](https://cloud.google.com/asset-inventory/docs/searching-iam-
      policies#how_to_construct_a_query) for more information. If not
      specified or empty, it will search all the IAM policies within the
      specified `scope`. Note that the query string is compared against each
      IAM policy binding, including its principals, roles, and IAM conditions.
      The returned IAM policies will only contain the bindings that match your
      query. To learn more about the IAM policy structure, see the [IAM policy
      documentation](https://cloud.google.com/iam/help/allow-
      policies/structure). Examples: * `policy:amy@gmail.com` to find IAM
      policy bindings that specify user "amy@gmail.com". *
      `policy:roles/compute.admin` to find IAM policy bindings that specify
      the Compute Admin role. * `policy:comp*` to find IAM policy bindings
      that contain "comp" as a prefix of any word in the binding. *
      `policy.role.permissions:storage.buckets.update` to find IAM policy
      bindings that specify a role containing "storage.buckets.update"
      permission. Note that if callers don't have `iam.roles.get` access to a
      role's included permissions, policy bindings that specify this role will
      be dropped from the search results. * `policy.role.permissions:upd*` to
      find IAM policy bindings that specify a role containing "upd" as a
      prefix of any word in the role permission. Note that if callers don't
      have `iam.roles.get` access to a role's included permissions, policy
      bindings that specify this role will be dropped from the search results.
      * `resource:organizations/123456` to find IAM policy bindings that are
      set on "organizations/123456". *
      `resource=//cloudresourcemanager.googleapis.com/projects/myproject` to
      find IAM policy bindings that are set on the project named "myproject".
      * `Important` to find IAM policy bindings that contain "Important" as a
      word in any of the searchable fields (except for the included
      permissions). * `resource:(instance1 OR instance2) policy:amy` to find
      IAM policy bindings that are set on resources "instance1" or "instance2"
      and also specify user "amy". * `roles:roles/compute.admin` to find IAM
      policy bindings that specify the Compute Admin role. *
      `memberTypes:user` to find IAM policy bindings that contain the
      principal type "user".
    scope: Required. A scope can be a project, a folder, or an organization.
      The search is limited to the IAM policies within the `scope`. The caller
      must be granted the [`cloudasset.assets.searchAllIamPolicies`](https://c
      loud.google.com/asset-inventory/docs/access-
      control#required_permissions) permission on the desired scope. The
      allowed values are: * projects/{PROJECT_ID} (e.g., "projects/foo-bar") *
      projects/{PROJECT_NUMBER} (e.g., "projects/12345678") *
      folders/{FOLDER_NUMBER} (e.g., "folders/1234567") *
      organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
  """

  assetTypes = _messages.StringField(1, repeated=True)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  query = _messages.StringField(5)
  scope = _messages.StringField(6, required=True)


class CloudassetSearchAllResourcesRequest(_messages.Message):
  r"""A CloudassetSearchAllResourcesRequest object.

  Fields:
    assetTypes: Optional. A list of asset types that this request searches
      for. If empty, it will search all the [searchable asset
      types](https://cloud.google.com/asset-inventory/docs/supported-asset-
      types#searchable_asset_types). Regular expressions are also supported.
      For example: * "compute.googleapis.com.*" snapshots resources whose
      asset type starts with "compute.googleapis.com". * ".*Instance"
      snapshots resources whose asset type ends with "Instance". *
      ".*Instance.*" snapshots resources whose asset type contains "Instance".
      See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
      regular expression syntax. If the regular expression does not match any
      supported asset type, an INVALID_ARGUMENT error will be returned.
    orderBy: Optional. A comma-separated list of fields specifying the sorting
      order of the results. The default order is ascending. Add " DESC" after
      the field name to indicate descending order. Redundant space characters
      are ignored. Example: "location DESC, name". Only singular primitive
      fields in the response are sortable: * name * assetType * project *
      displayName * description * location * createTime * updateTime * state *
      parentFullResourceName * parentAssetType All the other fields such as
      repeated fields (e.g., `networkTags`, `kmsKeys`), map fields (e.g.,
      `labels`) and struct fields (e.g., `additionalAttributes`) are not
      supported.
    pageSize: Optional. The page size for search result pagination. Page size
      is capped at 500 even if a larger value is given. If set to zero, server
      will pick an appropriate default. Returned results may be fewer than
      requested. When this happens, there could be more results as long as
      `next_page_token` is returned.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. `page_token` must be the value
      of `next_page_token` from the previous response. The values of all other
      method parameters, must be identical to those in the previous call.
    query: Optional. The query statement. See [how to construct a
      query](https://cloud.google.com/asset-inventory/docs/searching-
      resources#how_to_construct_a_query) for more information. If not
      specified or empty, it will search all the resources within the
      specified `scope`. Examples: * `name:Important` to find Google Cloud
      resources whose name contains "Important" as a word. * `name=Important`
      to find the Google Cloud resource whose name is exactly "Important". *
      `displayName:Impor*` to find Google Cloud resources whose display name
      contains "Impor" as a prefix of any word in the field. * `location:us-
      west*` to find Google Cloud resources whose location contains both "us"
      and "west" as prefixes. * `labels:prod` to find Google Cloud resources
      whose labels contain "prod" as a key or value. * `labels.env:prod` to
      find Google Cloud resources that have a label "env" and its value is
      "prod". * `labels.env:*` to find Google Cloud resources that have a
      label "env". * `kmsKey:key` to find Google Cloud resources encrypted
      with a customer-managed encryption key whose name contains "key" as a
      word. This field is deprecated. Please use the `kmsKeys` field to
      retrieve Cloud KMS key information. * `kmsKeys:key` to find Google Cloud
      resources encrypted with customer-managed encryption keys whose name
      contains the word "key". * `relationships:instance-group-1` to find
      Google Cloud resources that have relationships with "instance-group-1"
      in the related resource name. *
      `relationships:INSTANCE_TO_INSTANCEGROUP` to find Compute Engine
      instances that have relationships of type "INSTANCE_TO_INSTANCEGROUP". *
      `relationships.INSTANCE_TO_INSTANCEGROUP:instance-group-1` to find
      Compute Engine instances that have relationships with "instance-group-1"
      in the Compute Engine instance group resource name, for relationship
      type "INSTANCE_TO_INSTANCEGROUP". * `state:ACTIVE` to find Google Cloud
      resources whose state contains "ACTIVE" as a word. * `NOT state:ACTIVE`
      to find Google Cloud resources whose state doesn't contain "ACTIVE" as a
      word. * `createTime<1609459200` to find Google Cloud resources that were
      created before "2021-01-01 00:00:00 UTC". 1609459200 is the epoch
      timestamp of "2021-01-01 00:00:00 UTC" in seconds. *
      `updateTime>1609459200` to find Google Cloud resources that were updated
      after "2021-01-01 00:00:00 UTC". 1609459200 is the epoch timestamp of
      "2021-01-01 00:00:00 UTC" in seconds. * `Important` to find Google Cloud
      resources that contain "Important" as a word in any of the searchable
      fields. * `Impor*` to find Google Cloud resources that contain "Impor"
      as a prefix of any word in any of the searchable fields. * `Important
      location:(us-west1 OR global)` to find Google Cloud resources that
      contain "Important" as a word in any of the searchable fields and are
      also located in the "us-west1" region or the "global" location.
    readMask: Optional. A comma-separated list of fields specifying which
      fields to be returned in ResourceSearchResult. Only '*' or combination
      of top level fields can be specified. Field names of both snake_case and
      camelCase are supported. Examples: `"*"`, `"name,location"`,
      `"name,versionedResources"`. The read_mask paths must be valid field
      paths listed but not limited to (both snake_case and camelCase are
      supported): * name * assetType * project * displayName * description *
      location * tagKeys * tagValues * tagValueIds * labels * networkTags *
      kmsKey (This field is deprecated. Please use the `kmsKeys` field to
      retrieve Cloud KMS key information.) * kmsKeys * createTime * updateTime
      * state * additionalAttributes * versionedResources If read_mask is not
      specified, all fields except versionedResources will be returned. If
      only '*' is specified, all fields including versionedResources will be
      returned. Any invalid field path will trigger INVALID_ARGUMENT error.
    scope: Required. A scope can be a project, a folder, or an organization.
      The search is limited to the resources within the `scope`. The caller
      must be granted the
      [`cloudasset.assets.searchAllResources`](https://cloud.google.com/asset-
      inventory/docs/access-control#required_permissions) permission on the
      desired scope. The allowed values are: * projects/{PROJECT_ID} (e.g.,
      "projects/foo-bar") * projects/{PROJECT_NUMBER} (e.g.,
      "projects/12345678") * folders/{FOLDER_NUMBER} (e.g., "folders/1234567")
      * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
  """

  assetTypes = _messages.StringField(1, repeated=True)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  query = _messages.StringField(5)
  readMask = _messages.StringField(6)
  scope = _messages.StringField(7, required=True)


class ConditionContext(_messages.Message):
  r"""The IAM conditions context.

  Fields:
    accessTime: The hypothetical access timestamp to evaluate IAM conditions.
      Note that this value must not be earlier than the current time;
      otherwise, an INVALID_ARGUMENT error will be returned.
  """

  accessTime = _messages.StringField(1)


class ConditionEvaluation(_messages.Message):
  r"""The Condition evaluation.

  Enums:
    EvaluationValueValueValuesEnum: The evaluation result.

  Fields:
    evaluationValue: The evaluation result.
  """

  class EvaluationValueValueValuesEnum(_messages.Enum):
    r"""The evaluation result.

    Values:
      EVALUATION_VALUE_UNSPECIFIED: Reserved for future use.
      TRUE: The evaluation result is `true`.
      FALSE: The evaluation result is `false`.
      CONDITIONAL: The evaluation result is `conditional` when the condition
        expression contains variables that are either missing input values or
        have not been supported by Analyzer yet.
    """
    EVALUATION_VALUE_UNSPECIFIED = 0
    TRUE = 1
    FALSE = 2
    CONDITIONAL = 3

  evaluationValue = _messages.EnumField('EvaluationValueValueValuesEnum', 1)


class CreateFeedRequest(_messages.Message):
  r"""Create asset feed request.

  Fields:
    feed: Required. The feed details. The field `name` must be empty and it
      will be generated in the format of:
      projects/project_number/feeds/feed_id
      folders/folder_number/feeds/feed_id
      organizations/organization_number/feeds/feed_id
    feedId: Required. This is the client-assigned asset feed identifier and it
      needs to be unique under a specific parent project/folder/organization.
  """

  feed = _messages.MessageField('Feed', 1)
  feedId = _messages.StringField(2)


class Date(_messages.Message):
  r"""Represents a whole or partial calendar date, such as a birthday. The
  time of day and time zone are either specified elsewhere or are
  insignificant. The date is relative to the Gregorian Calendar. This can
  represent one of the following: * A full date, with non-zero year, month,
  and day values. * A month and day, with a zero year (for example, an
  anniversary). * A year on its own, with a zero month and a zero day. * A
  year and month, with a zero day (for example, a credit card expiration
  date). Related types: * google.type.TimeOfDay * google.type.DateTime *
  google.protobuf.Timestamp

  Fields:
    day: Day of a month. Must be from 1 to 31 and valid for the year and
      month, or 0 to specify a year by itself or a year and month where the
      day isn't significant.
    month: Month of a year. Must be from 1 to 12, or 0 to specify a year
      without a month and day.
    year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
      without a year.
  """

  day = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  month = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  year = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class EffectiveIamPolicy(_messages.Message):
  r"""The effective IAM policies on one resource.

  Fields:
    fullResourceName: The [full_resource_name]
      (https://cloud.google.com/asset-inventory/docs/resource-name-format) for
      which the policies are computed. This is one of the
      BatchGetEffectiveIamPoliciesRequest.names the caller provides in the
      request.
    policies: The effective policies for the full_resource_name. These
      policies include the policy set on the full_resource_name and those set
      on its parents and ancestors up to the
      BatchGetEffectiveIamPoliciesRequest.scope. Note that these policies are
      not filtered according to the resource type of the full_resource_name.
      These policies are hierarchically ordered by
      PolicyInfo.attached_resource starting from full_resource_name itself to
      its parents and ancestors, such that policies[i]'s
      PolicyInfo.attached_resource is the child of policies[i+1]'s
      PolicyInfo.attached_resource, if policies[i+1] exists.
  """

  fullResourceName = _messages.StringField(1)
  policies = _messages.MessageField('PolicyInfo', 2, repeated=True)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Explanation(_messages.Message):
  r"""Explanation about the IAM policy search result.

  Messages:
    MatchedPermissionsValue: The map from roles to their included permissions
      that match the permission query (i.e., a query containing
      `policy.role.permissions:`). Example: if query
      `policy.role.permissions:compute.disk.get` matches a policy binding that
      contains owner role, the matched_permissions will be `{"roles/owner":
      ["compute.disk.get"]}`. The roles can also be found in the returned
      `policy` bindings. Note that the map is populated only for requests with
      permission queries.

  Fields:
    matchedPermissions: The map from roles to their included permissions that
      match the permission query (i.e., a query containing
      `policy.role.permissions:`). Example: if query
      `policy.role.permissions:compute.disk.get` matches a policy binding that
      contains owner role, the matched_permissions will be `{"roles/owner":
      ["compute.disk.get"]}`. The roles can also be found in the returned
      `policy` bindings. Note that the map is populated only for requests with
      permission queries.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MatchedPermissionsValue(_messages.Message):
    r"""The map from roles to their included permissions that match the
    permission query (i.e., a query containing `policy.role.permissions:`).
    Example: if query `policy.role.permissions:compute.disk.get` matches a
    policy binding that contains owner role, the matched_permissions will be
    `{"roles/owner": ["compute.disk.get"]}`. The roles can also be found in
    the returned `policy` bindings. Note that the map is populated only for
    requests with permission queries.

    Messages:
      AdditionalProperty: An additional property for a MatchedPermissionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        MatchedPermissionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MatchedPermissionsValue object.

      Fields:
        key: Name of the additional property.
        value: A Permissions attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Permissions', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  matchedPermissions = _messages.MessageField('MatchedPermissionsValue', 1)


class ExportAssetsRequest(_messages.Message):
  r"""Export asset request.

  Enums:
    ContentTypeValueValuesEnum: Asset content type. If not specified, no
      content but the asset name will be returned.

  Fields:
    assetTypes: A list of asset types to take a snapshot for. For example:
      "compute.googleapis.com/Disk". Regular expressions are also supported.
      For example: * "compute.googleapis.com.*" snapshots resources whose
      asset type starts with "compute.googleapis.com". * ".*Instance"
      snapshots resources whose asset type ends with "Instance". *
      ".*Instance.*" snapshots resources whose asset type contains "Instance".
      See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
      regular expression syntax. If the regular expression does not match any
      supported asset type, an INVALID_ARGUMENT error will be returned. If
      specified, only matching assets will be returned, otherwise, it will
      snapshot all asset types. See [Introduction to Cloud Asset
      Inventory](https://cloud.google.com/asset-inventory/docs/overview) for
      all supported asset types.
    contentType: Asset content type. If not specified, no content but the
      asset name will be returned.
    outputConfig: Required. Output configuration indicating where the results
      will be output to.
    readTime: Timestamp to take an asset snapshot. This can only be set to a
      timestamp between the current time and the current time minus 35 days
      (inclusive). If not specified, the current time will be used. Due to
      delays in resource data collection and indexing, there is a volatile
      window during which running the same query may get different results.
    relationshipTypes: A list of relationship types to export, for example:
      `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
      content_type=RELATIONSHIP. * If specified: it snapshots specified
      relationships. It returns an error if any of the [relationship_types]
      doesn't belong to the supported relationship types of the [asset_types]
      or if any of the [asset_types] doesn't belong to the source types of the
      [relationship_types]. * Otherwise: it snapshots the supported
      relationships for all [asset_types] or returns an error if any of the
      [asset_types] has no relationship support. An unspecified asset types
      field means all supported asset_types. See [Introduction to Cloud Asset
      Inventory](https://cloud.google.com/asset-inventory/docs/overview) for
      all supported asset types and relationship types.
  """

  class ContentTypeValueValuesEnum(_messages.Enum):
    r"""Asset content type. If not specified, no content but the asset name
    will be returned.

    Values:
      CONTENT_TYPE_UNSPECIFIED: Unspecified content type.
      RESOURCE: Resource metadata.
      IAM_POLICY: The actual IAM policy set on a resource.
      ORG_POLICY: The organization policy set on an asset.
      ACCESS_POLICY: The Access Context Manager policy set on an asset.
      OS_INVENTORY: The runtime OS Inventory information.
      RELATIONSHIP: The related resources.
    """
    CONTENT_TYPE_UNSPECIFIED = 0
    RESOURCE = 1
    IAM_POLICY = 2
    ORG_POLICY = 3
    ACCESS_POLICY = 4
    OS_INVENTORY = 5
    RELATIONSHIP = 6

  assetTypes = _messages.StringField(1, repeated=True)
  contentType = _messages.EnumField('ContentTypeValueValuesEnum', 2)
  outputConfig = _messages.MessageField('OutputConfig', 3)
  readTime = _messages.StringField(4)
  relationshipTypes = _messages.StringField(5, repeated=True)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class Feed(_messages.Message):
  r"""An asset feed used to export asset updates to a destinations. An asset
  feed filter controls what updates are exported. The asset feed must be
  created within a project, organization, or folder. Supported destinations
  are: Pub/Sub topics.

  Enums:
    ContentTypeValueValuesEnum: Asset content type. If not specified, no
      content but the asset name and type will be returned.

  Fields:
    assetNames: A list of the full names of the assets to receive updates. You
      must specify either or both of asset_names and asset_types. Only asset
      updates matching specified asset_names or asset_types are exported to
      the feed. Example: `//compute.googleapis.com/projects/my_project_123/zon
      es/zone1/instances/instance1`. For a list of the full names for
      supported asset types, see [Resource name format](/asset-
      inventory/docs/resource-name-format).
    assetTypes: A list of types of the assets to receive updates. You must
      specify either or both of asset_names and asset_types. Only asset
      updates matching specified asset_names or asset_types are exported to
      the feed. Example: `"compute.googleapis.com/Disk"` For a list of all
      supported asset types, see [Supported asset types](/asset-
      inventory/docs/supported-asset-types).
    condition: A condition which determines whether an asset update should be
      published. If specified, an asset will be returned only when the
      expression evaluates to true. When set, `expression` field in the `Expr`
      must be a valid [CEL expression] (https://github.com/google/cel-spec) on
      a TemporalAsset with name `temporal_asset`. Example: a Feed with
      expression ("temporal_asset.deleted == true") will only publish Asset
      deletions. Other fields of `Expr` are optional. See our [user
      guide](https://cloud.google.com/asset-inventory/docs/monitoring-asset-
      changes-with-condition) for detailed instructions.
    contentType: Asset content type. If not specified, no content but the
      asset name and type will be returned.
    feedOutputConfig: Required. Feed output configuration defining where the
      asset updates are published to.
    name: Required. The format will be
      projects/{project_number}/feeds/{client-assigned_feed_identifier} or
      folders/{folder_number}/feeds/{client-assigned_feed_identifier} or
      organizations/{organization_number}/feeds/{client-
      assigned_feed_identifier} The client-assigned feed identifier must be
      unique within the parent project/folder/organization.
    relationshipTypes: A list of relationship types to output, for example:
      `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
      content_type=RELATIONSHIP. * If specified: it outputs specified
      relationship updates on the [asset_names] or the [asset_types]. It
      returns an error if any of the [relationship_types] doesn't belong to
      the supported relationship types of the [asset_names] or [asset_types],
      or any of the [asset_names] or the [asset_types] doesn't belong to the
      source types of the [relationship_types]. * Otherwise: it outputs the
      supported relationships of the types of [asset_names] and [asset_types]
      or returns an error if any of the [asset_names] or the [asset_types] has
      no replationship support. See [Introduction to Cloud Asset
      Inventory](https://cloud.google.com/asset-inventory/docs/overview) for
      all supported asset types and relationship types.
  """

  class ContentTypeValueValuesEnum(_messages.Enum):
    r"""Asset content type. If not specified, no content but the asset name
    and type will be returned.

    Values:
      CONTENT_TYPE_UNSPECIFIED: Unspecified content type.
      RESOURCE: Resource metadata.
      IAM_POLICY: The actual IAM policy set on a resource.
      ORG_POLICY: The organization policy set on an asset.
      ACCESS_POLICY: The Access Context Manager policy set on an asset.
      OS_INVENTORY: The runtime OS Inventory information.
      RELATIONSHIP: The related resources.
    """
    CONTENT_TYPE_UNSPECIFIED = 0
    RESOURCE = 1
    IAM_POLICY = 2
    ORG_POLICY = 3
    ACCESS_POLICY = 4
    OS_INVENTORY = 5
    RELATIONSHIP = 6

  assetNames = _messages.StringField(1, repeated=True)
  assetTypes = _messages.StringField(2, repeated=True)
  condition = _messages.MessageField('Expr', 3)
  contentType = _messages.EnumField('ContentTypeValueValuesEnum', 4)
  feedOutputConfig = _messages.MessageField('FeedOutputConfig', 5)
  name = _messages.StringField(6)
  relationshipTypes = _messages.StringField(7, repeated=True)


class FeedOutputConfig(_messages.Message):
  r"""Output configuration for asset feed destination.

  Fields:
    pubsubDestination: Destination on Pub/Sub.
  """

  pubsubDestination = _messages.MessageField('PubsubDestination', 1)


class GcsDestination(_messages.Message):
  r"""A Cloud Storage location.

  Fields:
    uri: The URI of the Cloud Storage object. It's the same URI that is used
      by gsutil. Example: "gs://bucket_name/object_name". See [Viewing and
      Editing Object Metadata](https://cloud.google.com/storage/docs/viewing-
      editing-metadata) for more information. If the specified Cloud Storage
      object already exists and there is no
      [hold](https://cloud.google.com/storage/docs/object-holds), it will be
      overwritten with the exported result.
    uriPrefix: The URI prefix of all generated Cloud Storage objects. Example:
      "gs://bucket_name/object_name_prefix". Each object URI is in format:
      "gs://bucket_name/object_name_prefix// and only contains assets for that
      type. starts from 0. Example:
      "gs://bucket_name/object_name_prefix/compute.googleapis.com/Disk/0" is
      the first shard of output objects containing all
      compute.googleapis.com/Disk assets. An INVALID_ARGUMENT error will be
      returned if file with the same name
      "gs://bucket_name/object_name_prefix" already exists.
  """

  uri = _messages.StringField(1)
  uriPrefix = _messages.StringField(2)


class GoogleCloudAssetV1Access(_messages.Message):
  r"""An IAM role or permission under analysis.

  Fields:
    analysisState: The analysis state of this access.
    permission: The permission.
    role: The role.
  """

  analysisState = _messages.MessageField('IamPolicyAnalysisState', 1)
  permission = _messages.StringField(2)
  role = _messages.StringField(3)


class GoogleCloudAssetV1AccessControlList(_messages.Message):
  r"""An access control list, derived from the above IAM policy binding, which
  contains a set of resources and accesses. May include one item from each set
  to compose an access control entry. NOTICE that there could be multiple
  access control lists for one IAM policy binding. The access control lists
  are created based on resource and access combinations. For example, assume
  we have the following cases in one IAM policy binding: - Permission P1 and
  P2 apply to resource R1 and R2; - Permission P3 applies to resource R2 and
  R3; This will result in the following access control lists: -
  AccessControlList 1: [R1, R2], [P1, P2] - AccessControlList 2: [R2, R3],
  [P3]

  Fields:
    accesses: The accesses that match one of the following conditions: - The
      access_selector, if it is specified in request; - Otherwise, access
      specifiers reachable from the policy binding's role.
    conditionEvaluation: Condition evaluation for this AccessControlList, if
      there is a condition defined in the above IAM policy binding.
    resourceEdges: Resource edges of the graph starting from the policy
      attached resource to any descendant resources. The Edge.source_node
      contains the full resource name of a parent resource and
      Edge.target_node contains the full resource name of a child resource.
      This field is present only if the output_resource_edges option is
      enabled in request.
    resources: The resources that match one of the following conditions: - The
      resource_selector, if it is specified in request; - Otherwise, resources
      reachable from the policy attached resource.
  """

  accesses = _messages.MessageField('GoogleCloudAssetV1Access', 1, repeated=True)
  conditionEvaluation = _messages.MessageField('ConditionEvaluation', 2)
  resourceEdges = _messages.MessageField('GoogleCloudAssetV1Edge', 3, repeated=True)
  resources = _messages.MessageField('GoogleCloudAssetV1Resource', 4, repeated=True)


class GoogleCloudAssetV1AnalyzeOrgPolicyGovernedAssetsResponseGovernedAsset(_messages.Message):
  r"""Represents a Google Cloud asset(resource or IAM policy) governed by the
  organization policies of the
  AnalyzeOrgPolicyGovernedAssetsRequest.constraint.

  Fields:
    consolidatedPolicy: The consolidated policy for the analyzed asset. The
      consolidated policy is computed by merging and evaluating
      AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset.policy_bundle. The
      evaluation will respect the organization policy [hierarchy
      rules](https://cloud.google.com/resource-manager/docs/organization-
      policy/understanding-hierarchy).
    governedIamPolicy: An IAM policy governed by the organization policies of
      the AnalyzeOrgPolicyGovernedAssetsRequest.constraint.
    governedResource: A Google Cloud resource governed by the organization
      policies of the AnalyzeOrgPolicyGovernedAssetsRequest.constraint.
    policyBundle: The ordered list of all organization policies from the Analy
      zeOrgPoliciesResponse.OrgPolicyResult.consolidated_policy.attached_resou
      rce to the scope specified in the request. If the constraint is defined
      with default policy, it will also appear in the list.
  """

  consolidatedPolicy = _messages.MessageField('AnalyzerOrgPolicy', 1)
  governedIamPolicy = _messages.MessageField('GoogleCloudAssetV1AnalyzeOrgPolicyGovernedAssetsResponseGovernedIamPolicy', 2)
  governedResource = _messages.MessageField('GoogleCloudAssetV1AnalyzeOrgPolicyGovernedAssetsResponseGovernedResource', 3)
  policyBundle = _messages.MessageField('AnalyzerOrgPolicy', 4, repeated=True)


class GoogleCloudAssetV1AnalyzeOrgPolicyGovernedAssetsResponseGovernedIamPolicy(_messages.Message):
  r"""The IAM policies governed by the organization policies of the
  AnalyzeOrgPolicyGovernedAssetsRequest.constraint.

  Fields:
    attachedResource: The full resource name of the resource associated with
      this IAM policy. Example: `//compute.googleapis.com/projects/my_project_
      123/zones/zone1/instances/instance1`. See [Cloud Asset Inventory
      Resource Name Format](https://cloud.google.com/asset-
      inventory/docs/resource-name-format) for more information.
    folders: The folder(s) that this IAM policy belongs to, in the form of
      folders/{FOLDER_NUMBER}. This field is available when the IAM policy
      belongs(directly or cascadingly) to one or more folders.
    organization: The organization that this IAM policy belongs to, in the
      form of organizations/{ORGANIZATION_NUMBER}. This field is available
      when the IAM policy belongs(directly or cascadingly) to an organization.
    policy: The IAM policy directly set on the given resource.
    project: The project that this IAM policy belongs to, in the form of
      projects/{PROJECT_NUMBER}. This field is available when the IAM policy
      belongs to a project.
  """

  attachedResource = _messages.StringField(1)
  folders = _messages.StringField(2, repeated=True)
  organization = _messages.StringField(3)
  policy = _messages.MessageField('Policy', 4)
  project = _messages.StringField(5)


class GoogleCloudAssetV1AnalyzeOrgPolicyGovernedAssetsResponseGovernedResource(_messages.Message):
  r"""The Google Cloud resources governed by the organization policies of the
  AnalyzeOrgPolicyGovernedAssetsRequest.constraint.

  Fields:
    folders: The folder(s) that this resource belongs to, in the form of
      folders/{FOLDER_NUMBER}. This field is available when the resource
      belongs(directly or cascadingly) to one or more folders.
    fullResourceName: The [full resource name]
      (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
      the Google Cloud resource.
    organization: The organization that this resource belongs to, in the form
      of organizations/{ORGANIZATION_NUMBER}. This field is available when the
      resource belongs(directly or cascadingly) to an organization.
    parent: The [full resource name] (https://cloud.google.com/asset-
      inventory/docs/resource-name-format) of the parent of AnalyzeOrgPolicyGo
      vernedAssetsResponse.GovernedResource.full_resource_name.
    project: The project that this resource belongs to, in the form of
      projects/{PROJECT_NUMBER}. This field is available when the resource
      belongs to a project.
  """

  folders = _messages.StringField(1, repeated=True)
  fullResourceName = _messages.StringField(2)
  organization = _messages.StringField(3)
  parent = _messages.StringField(4)
  project = _messages.StringField(5)


class GoogleCloudAssetV1BigQueryDestination(_messages.Message):
  r"""A BigQuery destination.

  Enums:
    PartitionKeyValueValuesEnum: The partition key for BigQuery partitioned
      table.

  Fields:
    dataset: Required. The BigQuery dataset in format
      "projects/projectId/datasets/datasetId", to which the analysis results
      should be exported. If this dataset does not exist, the export call will
      return an INVALID_ARGUMENT error.
    partitionKey: The partition key for BigQuery partitioned table.
    tablePrefix: Required. The prefix of the BigQuery tables to which the
      analysis results will be written. Tables will be created based on this
      table_prefix if not exist: * _analysis table will contain export
      operation's metadata. * _analysis_result will contain all the
      IamPolicyAnalysisResult. When [partition_key] is specified, both tables
      will be partitioned based on the [partition_key].
    writeDisposition: Optional. Specifies the action that occurs if the
      destination table or partition already exists. The following values are
      supported: * WRITE_TRUNCATE: If the table or partition already exists,
      BigQuery overwrites the entire table or all the partitions data. *
      WRITE_APPEND: If the table or partition already exists, BigQuery appends
      the data to the table or the latest partition. * WRITE_EMPTY: If the
      table already exists and contains data, an error is returned. The
      default value is WRITE_APPEND. Each action is atomic and only occurs if
      BigQuery is able to complete the job successfully. Details are at
      https://cloud.google.com/bigquery/docs/loading-data-
      local#appending_to_or_overwriting_a_table_using_a_local_file.
  """

  class PartitionKeyValueValuesEnum(_messages.Enum):
    r"""The partition key for BigQuery partitioned table.

    Values:
      PARTITION_KEY_UNSPECIFIED: Unspecified partition key. Tables won't be
        partitioned using this option.
      REQUEST_TIME: The time when the request is received. If specified as
        partition key, the result table(s) is partitoned by the RequestTime
        column, an additional timestamp column representing when the request
        was received.
    """
    PARTITION_KEY_UNSPECIFIED = 0
    REQUEST_TIME = 1

  dataset = _messages.StringField(1)
  partitionKey = _messages.EnumField('PartitionKeyValueValuesEnum', 2)
  tablePrefix = _messages.StringField(3)
  writeDisposition = _messages.StringField(4)


class GoogleCloudAssetV1BooleanConstraint(_messages.Message):
  r"""A `Constraint` that is either enforced or not. For example a constraint
  `constraints/compute.disableSerialPortAccess`. If it is enforced on a VM
  instance, serial port connections will not be opened to that instance.
  """



class GoogleCloudAssetV1Constraint(_messages.Message):
  r"""The definition of a constraint.

  Enums:
    ConstraintDefaultValueValuesEnum: The evaluation behavior of this
      constraint in the absence of 'Policy'.

  Fields:
    booleanConstraint: Defines this constraint as being a BooleanConstraint.
    constraintDefault: The evaluation behavior of this constraint in the
      absence of 'Policy'.
    description: Detailed description of what this `Constraint` controls as
      well as how and where it is enforced.
    displayName: The human readable name of the constraint.
    listConstraint: Defines this constraint as being a ListConstraint.
    name: The unique name of the constraint. Format of the name should be *
      `constraints/{constraint_name}` For example,
      `constraints/compute.disableSerialPortAccess`.
  """

  class ConstraintDefaultValueValuesEnum(_messages.Enum):
    r"""The evaluation behavior of this constraint in the absence of 'Policy'.

    Values:
      CONSTRAINT_DEFAULT_UNSPECIFIED: This is only used for distinguishing
        unset values and should never be used.
      ALLOW: Indicate that all values are allowed for list constraints.
        Indicate that enforcement is off for boolean constraints.
      DENY: Indicate that all values are denied for list constraints. Indicate
        that enforcement is on for boolean constraints.
    """
    CONSTRAINT_DEFAULT_UNSPECIFIED = 0
    ALLOW = 1
    DENY = 2

  booleanConstraint = _messages.MessageField('GoogleCloudAssetV1BooleanConstraint', 1)
  constraintDefault = _messages.EnumField('ConstraintDefaultValueValuesEnum', 2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  listConstraint = _messages.MessageField('GoogleCloudAssetV1ListConstraint', 5)
  name = _messages.StringField(6)


class GoogleCloudAssetV1CustomConstraint(_messages.Message):
  r"""The definition of a custom constraint.

  Enums:
    ActionTypeValueValuesEnum: Allow or deny type.
    MethodTypesValueListEntryValuesEnum:

  Fields:
    actionType: Allow or deny type.
    condition: Organization Policy condition/expression. For example:
      `resource.instanceName.matches("[production|test]_.*_(\d)+")'` or,
      `resource.management.auto_upgrade == true`
    description: Detailed information about this custom policy constraint.
    displayName: One line display name for the UI.
    methodTypes: All the operations being applied for this constraint.
    name: Name of the constraint. This is unique within the organization.
      Format of the name should be * `organizations/{organization_id}/customCo
      nstraints/{custom_constraint_id}` Example :
      "organizations/123/customConstraints/custom.createOnlyE2TypeVms"
    resourceTypes: The Resource Instance type on which this policy applies to.
      Format will be of the form : "/" Example: *
      `compute.googleapis.com/Instance`.
  """

  class ActionTypeValueValuesEnum(_messages.Enum):
    r"""Allow or deny type.

    Values:
      ACTION_TYPE_UNSPECIFIED: Unspecified. Will results in user error.
      ALLOW: Allowed action type.
      DENY: Deny action type.
    """
    ACTION_TYPE_UNSPECIFIED = 0
    ALLOW = 1
    DENY = 2

  class MethodTypesValueListEntryValuesEnum(_messages.Enum):
    r"""MethodTypesValueListEntryValuesEnum enum type.

    Values:
      METHOD_TYPE_UNSPECIFIED: Unspecified. Will results in user error.
      CREATE: Constraint applied when creating the resource.
      UPDATE: Constraint applied when updating the resource.
      DELETE: Constraint applied when deleting the resource.
    """
    METHOD_TYPE_UNSPECIFIED = 0
    CREATE = 1
    UPDATE = 2
    DELETE = 3

  actionType = _messages.EnumField('ActionTypeValueValuesEnum', 1)
  condition = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  methodTypes = _messages.EnumField('MethodTypesValueListEntryValuesEnum', 5, repeated=True)
  name = _messages.StringField(6)
  resourceTypes = _messages.StringField(7, repeated=True)


class GoogleCloudAssetV1Edge(_messages.Message):
  r"""A directional edge.

  Fields:
    sourceNode: The source node of the edge. For example, it could be a full
      resource name for a resource node or an email of an identity.
    targetNode: The target node of the edge. For example, it could be a full
      resource name for a resource node or an email of an identity.
  """

  sourceNode = _messages.StringField(1)
  targetNode = _messages.StringField(2)


class GoogleCloudAssetV1GcsDestination(_messages.Message):
  r"""A Cloud Storage location.

  Fields:
    uri: Required. The URI of the Cloud Storage object. It's the same URI that
      is used by gsutil. Example: "gs://bucket_name/object_name". See [Viewing
      and Editing Object
      Metadata](https://cloud.google.com/storage/docs/viewing-editing-
      metadata) for more information. If the specified Cloud Storage object
      already exists and there is no
      [hold](https://cloud.google.com/storage/docs/object-holds), it will be
      overwritten with the analysis result.
  """

  uri = _messages.StringField(1)


class GoogleCloudAssetV1GovernedContainer(_messages.Message):
  r"""The organization/folder/project resource governed by organization
  policies of AnalyzeOrgPolicyGovernedContainersRequest.constraint.

  Fields:
    consolidatedPolicy: The consolidated organization policy for the analyzed
      resource. The consolidated organization policy is computed by merging
      and evaluating AnalyzeOrgPolicyGovernedContainersResponse.GovernedContai
      ner.policy_bundle. The evaluation will respect the organization policy
      [hierarchy rules](https://cloud.google.com/resource-
      manager/docs/organization-policy/understanding-hierarchy).
    fullResourceName: The [full resource name]
      (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
      an organization/folder/project resource.
    parent: The [full resource name] (https://cloud.google.com/asset-
      inventory/docs/resource-name-format) of the parent of AnalyzeOrgPolicyGo
      vernedContainersResponse.GovernedContainer.full_resource_name.
    policyBundle: The ordered list of all organization policies from the Analy
      zeOrgPoliciesResponse.OrgPolicyResult.consolidated_policy.attached_resou
      rce. to the scope specified in the request. If the constraint is defined
      with default policy, it will also appear in the list.
  """

  consolidatedPolicy = _messages.MessageField('AnalyzerOrgPolicy', 1)
  fullResourceName = _messages.StringField(2)
  parent = _messages.StringField(3)
  policyBundle = _messages.MessageField('AnalyzerOrgPolicy', 4, repeated=True)


class GoogleCloudAssetV1GovernedResource(_messages.Message):
  r"""The Google Cloud resources governed by the organization policies of the
  AnalyzeOrgPolicyGovernedResourcesRequest.constraint.

  Fields:
    consolidatedPolicy: The consolidated policy for the analyzed resource. The
      consolidated policy is computed by merging and evaluating AnalyzeOrgPoli
      cyGovernedResourcesResponse.GovernedResource.policy_bundle. The
      evaluation will respect the organization policy [hierarchy
      rules](https://cloud.google.com/resource-manager/docs/organization-
      policy/understanding-hierarchy).
    folders: The folder(s) that this resource belongs to, in the form of
      folders/{FOLDER_NUMBER}. This field is available when the resource
      belongs(directly or cascadingly) to one or more folders.
    fullResourceName: The [full resource name]
      (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
      the Google Cloud resource.
    organization: The organization that this resource belongs to, in the form
      of organizations/{ORGANIZATION_NUMBER}. This field is available when the
      resource belongs(directly or cascadingly) to an organization.
    parent: The [full resource name] (https://cloud.google.com/asset-
      inventory/docs/resource-name-format) of the parent of AnalyzeOrgPolicyGo
      vernedContainersResponse.GovernedContainer.full_resource_name.
    policyBundle: The ordered list of all organization policies from the Analy
      zeOrgPoliciesResponse.OrgPolicyResult.consolidated_policy.attached_resou
      rce. to the scope specified in the request.
    project: The project that this resource belongs to, in the form of
      projects/{PROJECT_NUMBER}. This field is available when the resource
      belongs to a project.
  """

  consolidatedPolicy = _messages.MessageField('AnalyzerOrgPolicy', 1)
  folders = _messages.StringField(2, repeated=True)
  fullResourceName = _messages.StringField(3)
  organization = _messages.StringField(4)
  parent = _messages.StringField(5)
  policyBundle = _messages.MessageField('AnalyzerOrgPolicy', 6, repeated=True)
  project = _messages.StringField(7)


class GoogleCloudAssetV1Identity(_messages.Message):
  r"""An identity under analysis.

  Fields:
    analysisState: The analysis state of this identity.
    name: The identity name in any form of members appear in [IAM policy
      binding](https://cloud.google.com/iam/reference/rest/v1/Binding), such
      as: - user:foo@google.com - group:group1@google.com -
      serviceAccount:s1@prj1.iam.gserviceaccount.com -
      projectOwner:some_project_id - domain:google.com - allUsers - etc.
  """

  analysisState = _messages.MessageField('IamPolicyAnalysisState', 1)
  name = _messages.StringField(2)


class GoogleCloudAssetV1IdentityList(_messages.Message):
  r"""The identities and group edges.

  Fields:
    groupEdges: Group identity edges of the graph starting from the binding's
      group members to any node of the identities. The Edge.source_node
      contains a group, such as `group:parent@google.com`. The
      Edge.target_node contains a member of the group, such as
      `group:child@google.com` or `user:foo@google.com`. This field is present
      only if the output_group_edges option is enabled in request.
    identities: Only the identities that match one of the following conditions
      will be presented: - The identity_selector, if it is specified in
      request; - Otherwise, identities reachable from the policy binding's
      members.
  """

  groupEdges = _messages.MessageField('GoogleCloudAssetV1Edge', 1, repeated=True)
  identities = _messages.MessageField('GoogleCloudAssetV1Identity', 2, repeated=True)


class GoogleCloudAssetV1ListConstraint(_messages.Message):
  r"""A `Constraint` that allows or disallows a list of string values, which
  are configured by an organization's policy administrator with a `Policy`.

  Fields:
    supportsIn: Indicates whether values grouped into categories can be used
      in `Policy.allowed_values` and `Policy.denied_values`. For example,
      `"in:Python"` would match any value in the 'Python' group.
    supportsUnder: Indicates whether subtrees of Cloud Resource Manager
      resource hierarchy can be used in `Policy.allowed_values` and
      `Policy.denied_values`. For example, `"under:folders/123"` would match
      any resource under the 'folders/123' folder.
  """

  supportsIn = _messages.BooleanField(1)
  supportsUnder = _messages.BooleanField(2)


class GoogleCloudAssetV1QueryAssetsOutputConfigBigQueryDestination(_messages.Message):
  r"""BigQuery destination.

  Fields:
    dataset: Required. The BigQuery dataset where the query results will be
      saved. It has the format of "projects/{projectId}/datasets/{datasetId}".
    table: Required. The BigQuery table where the query results will be saved.
      If this table does not exist, a new table with the given name will be
      created.
    writeDisposition: Specifies the action that occurs if the destination
      table or partition already exists. The following values are supported: *
      WRITE_TRUNCATE: If the table or partition already exists, BigQuery
      overwrites the entire table or all the partitions data. * WRITE_APPEND:
      If the table or partition already exists, BigQuery appends the data to
      the table or the latest partition. * WRITE_EMPTY: If the table already
      exists and contains data, a 'duplicate' error is returned in the job
      result. The default value is WRITE_EMPTY.
  """

  dataset = _messages.StringField(1)
  table = _messages.StringField(2)
  writeDisposition = _messages.StringField(3)


class GoogleCloudAssetV1Resource(_messages.Message):
  r"""A Google Cloud resource under analysis.

  Fields:
    analysisState: The analysis state of this resource.
    fullResourceName: The [full resource name](https://cloud.google.com/asset-
      inventory/docs/resource-name-format)
  """

  analysisState = _messages.MessageField('IamPolicyAnalysisState', 1)
  fullResourceName = _messages.StringField(2)


class GoogleCloudAssetV1Rule(_messages.Message):
  r"""Represents a rule defined in an organization policy

  Fields:
    allowAll: Setting this to true means that all values are allowed. This
      field can be set only in Policies for list constraints.
    condition: The evaluating condition for this rule.
    denyAll: Setting this to true means that all values are denied. This field
      can be set only in Policies for list constraints.
    enforce: If `true`, then the `Policy` is enforced. If `false`, then any
      configuration is acceptable. This field can be set only in Policies for
      boolean constraints.
    values: List of values to be used for this PolicyRule. This field can be
      set only in Policies for list constraints.
  """

  allowAll = _messages.BooleanField(1)
  condition = _messages.MessageField('Expr', 2)
  denyAll = _messages.BooleanField(3)
  enforce = _messages.BooleanField(4)
  values = _messages.MessageField('GoogleCloudAssetV1StringValues', 5)


class GoogleCloudAssetV1StringValues(_messages.Message):
  r"""The string values for the list constraints.

  Fields:
    allowedValues: List of values allowed at this resource.
    deniedValues: List of values denied at this resource.
  """

  allowedValues = _messages.StringField(1, repeated=True)
  deniedValues = _messages.StringField(2, repeated=True)


class GoogleCloudAssetV1p7beta1Asset(_messages.Message):
  r"""An asset in Google Cloud. An asset can be any resource in the Google
  Cloud [resource hierarchy](https://cloud.google.com/resource-
  manager/docs/cloud-platform-resource-hierarchy), a resource outside the
  Google Cloud resource hierarchy (such as Google Kubernetes Engine clusters
  and objects), or a policy (e.g. IAM policy). See [Supported asset
  types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
  for more information.

  Fields:
    accessLevel: Please also refer to the [access level user
      guide](https://cloud.google.com/access-context-
      manager/docs/overview#access-levels).
    accessPolicy: Please also refer to the [access policy user
      guide](https://cloud.google.com/access-context-
      manager/docs/overview#access-policies).
    ancestors: The ancestry path of an asset in Google Cloud [resource
      hierarchy](https://cloud.google.com/resource-manager/docs/cloud-
      platform-resource-hierarchy), represented as a list of relative resource
      names. An ancestry path starts with the closest ancestor in the
      hierarchy and ends at root. If the asset is a project, folder, or
      organization, the ancestry path starts from the asset itself. Example:
      `["projects/123456789", "folders/5432", "organizations/1234"]`
    assetType: The type of the asset. Example: `compute.googleapis.com/Disk`
      See [Supported asset types](https://cloud.google.com/asset-
      inventory/docs/supported-asset-types) for more information.
    iamPolicy: A representation of the IAM policy set on a Google Cloud
      resource. There can be a maximum of one IAM policy set on any given
      resource. In addition, IAM policies inherit their granted access scope
      from any policies set on parent resources in the resource hierarchy.
      Therefore, the effectively policy is the union of both the policy set on
      this resource and each policy set on all of the resource's ancestry
      resource levels in the hierarchy. See [this
      topic](https://cloud.google.com/iam/help/allow-policies/inheritance) for
      more information.
    name: The full name of the asset. Example: `//compute.googleapis.com/proje
      cts/my_project_123/zones/zone1/instances/instance1` See [Resource names]
      (https://cloud.google.com/apis/design/resource_names#full_resource_name)
      for more information.
    orgPolicy: A representation of an [organization
      policy](https://cloud.google.com/resource-manager/docs/organization-
      policy/overview#organization_policy). There can be more than one
      organization policy with different constraints set on a given resource.
    relatedAssets: The related assets of the asset of one relationship type.
      One asset only represents one type of relationship.
    resource: A representation of the resource.
    servicePerimeter: Please also refer to the [service perimeter user
      guide](https://cloud.google.com/vpc-service-controls/docs/overview).
    updateTime: The last update timestamp of an asset. update_time is updated
      when create/update/delete operation is performed.
  """

  accessLevel = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1AccessLevel', 1)
  accessPolicy = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1AccessPolicy', 2)
  ancestors = _messages.StringField(3, repeated=True)
  assetType = _messages.StringField(4)
  iamPolicy = _messages.MessageField('Policy', 5)
  name = _messages.StringField(6)
  orgPolicy = _messages.MessageField('GoogleCloudOrgpolicyV1Policy', 7, repeated=True)
  relatedAssets = _messages.MessageField('GoogleCloudAssetV1p7beta1RelatedAssets', 8)
  resource = _messages.MessageField('GoogleCloudAssetV1p7beta1Resource', 9)
  servicePerimeter = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1ServicePerimeter', 10)
  updateTime = _messages.StringField(11)


class GoogleCloudAssetV1p7beta1RelatedAsset(_messages.Message):
  r"""An asset identify in Google Cloud which contains its name, type and
  ancestors. An asset can be any resource in the Google Cloud [resource
  hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-
  resource-hierarchy), a resource outside the Google Cloud resource hierarchy
  (such as Google Kubernetes Engine clusters and objects), or a policy (e.g.
  IAM policy). See [Supported asset types](https://cloud.google.com/asset-
  inventory/docs/supported-asset-types) for more information.

  Fields:
    ancestors: The ancestors of an asset in Google Cloud [resource
      hierarchy](https://cloud.google.com/resource-manager/docs/cloud-
      platform-resource-hierarchy), represented as a list of relative resource
      names. An ancestry path starts with the closest ancestor in the
      hierarchy and ends at root. Example: `["projects/123456789",
      "folders/5432", "organizations/1234"]`
    asset: The full name of the asset. Example: `//compute.googleapis.com/proj
      ects/my_project_123/zones/zone1/instances/instance1` See [Resource names
      ](https://cloud.google.com/apis/design/resource_names#full_resource_name
      ) for more information.
    assetType: The type of the asset. Example: `compute.googleapis.com/Disk`
      See [Supported asset types](https://cloud.google.com/asset-
      inventory/docs/supported-asset-types) for more information.
  """

  ancestors = _messages.StringField(1, repeated=True)
  asset = _messages.StringField(2)
  assetType = _messages.StringField(3)


class GoogleCloudAssetV1p7beta1RelatedAssets(_messages.Message):
  r"""The detailed related assets with the `relationship_type`.

  Fields:
    assets: The peer resources of the relationship.
    relationshipAttributes: The detailed relation attributes.
  """

  assets = _messages.MessageField('GoogleCloudAssetV1p7beta1RelatedAsset', 1, repeated=True)
  relationshipAttributes = _messages.MessageField('GoogleCloudAssetV1p7beta1RelationshipAttributes', 2)


class GoogleCloudAssetV1p7beta1RelationshipAttributes(_messages.Message):
  r"""The relationship attributes which include `type`,
  `source_resource_type`, `target_resource_type` and `action`.

  Fields:
    action: The detail of the relationship, e.g. `contains`, `attaches`
    sourceResourceType: The source asset type. Example:
      `compute.googleapis.com/Instance`
    targetResourceType: The target asset type. Example:
      `compute.googleapis.com/Disk`
    type: The unique identifier of the relationship type. Example:
      `INSTANCE_TO_INSTANCEGROUP`
  """

  action = _messages.StringField(1)
  sourceResourceType = _messages.StringField(2)
  targetResourceType = _messages.StringField(3)
  type = _messages.StringField(4)


class GoogleCloudAssetV1p7beta1Resource(_messages.Message):
  r"""A representation of a Google Cloud resource.

  Messages:
    DataValue: The content of the resource, in which some sensitive fields are
      removed and may not be present.

  Fields:
    data: The content of the resource, in which some sensitive fields are
      removed and may not be present.
    discoveryDocumentUri: The URL of the discovery document containing the
      resource's JSON schema. Example:
      `https://www.googleapis.com/discovery/v1/apis/compute/v1/rest` This
      value is unspecified for resources that do not have an API based on a
      discovery document, such as Cloud Bigtable.
    discoveryName: The JSON schema name listed in the discovery document.
      Example: `Project` This value is unspecified for resources that do not
      have an API based on a discovery document, such as Cloud Bigtable.
    location: The location of the resource in Google Cloud, such as its zone
      and region. For more information, see
      https://cloud.google.com/about/locations/.
    parent: The full name of the immediate parent of this resource. See
      [Resource Names](https://cloud.google.com/apis/design/resource_names#ful
      l_resource_name) for more information. For Google Cloud assets, this
      value is the parent resource defined in the [IAM policy
      hierarchy](https://cloud.google.com/iam/docs/overview#policy_hierarchy).
      Example: `//cloudresourcemanager.googleapis.com/projects/my_project_123`
      For third-party assets, this field may be set differently.
    resourceUrl: The REST URL for accessing the resource. An HTTP `GET`
      request using this URL returns the resource itself. Example:
      `https://cloudresourcemanager.googleapis.com/v1/projects/my-project-123`
      This value is unspecified for resources without a REST API.
    version: The API version. Example: `v1`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DataValue(_messages.Message):
    r"""The content of the resource, in which some sensitive fields are
    removed and may not be present.

    Messages:
      AdditionalProperty: An additional property for a DataValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  data = _messages.MessageField('DataValue', 1)
  discoveryDocumentUri = _messages.StringField(2)
  discoveryName = _messages.StringField(3)
  location = _messages.StringField(4)
  parent = _messages.StringField(5)
  resourceUrl = _messages.StringField(6)
  version = _messages.StringField(7)


class GoogleCloudOrgpolicyV1BooleanPolicy(_messages.Message):
  r"""Used in `policy_type` to specify how `boolean_policy` will behave at
  this resource.

  Fields:
    enforced: If `true`, then the `Policy` is enforced. If `false`, then any
      configuration is acceptable. Suppose you have a `Constraint`
      `constraints/compute.disableSerialPortAccess` with `constraint_default`
      set to `ALLOW`. A `Policy` for that `Constraint` exhibits the following
      behavior: - If the `Policy` at this resource has enforced set to
      `false`, serial port connection attempts will be allowed. - If the
      `Policy` at this resource has enforced set to `true`, serial port
      connection attempts will be refused. - If the `Policy` at this resource
      is `RestoreDefault`, serial port connection attempts will be allowed. -
      If no `Policy` is set at this resource or anywhere higher in the
      resource hierarchy, serial port connection attempts will be allowed. -
      If no `Policy` is set at this resource, but one exists higher in the
      resource hierarchy, the behavior is as if the`Policy` were set at this
      resource. The following examples demonstrate the different possible
      layerings: Example 1 (nearest `Constraint` wins): `organizations/foo`
      has a `Policy` with: {enforced: false} `projects/bar` has no `Policy`
      set. The constraint at `projects/bar` and `organizations/foo` will not
      be enforced. Example 2 (enforcement gets replaced): `organizations/foo`
      has a `Policy` with: {enforced: false} `projects/bar` has a `Policy`
      with: {enforced: true} The constraint at `organizations/foo` is not
      enforced. The constraint at `projects/bar` is enforced. Example 3
      (RestoreDefault): `organizations/foo` has a `Policy` with: {enforced:
      true} `projects/bar` has a `Policy` with: {RestoreDefault: {}} The
      constraint at `organizations/foo` is enforced. The constraint at
      `projects/bar` is not enforced, because `constraint_default` for the
      `Constraint` is `ALLOW`.
  """

  enforced = _messages.BooleanField(1)


class GoogleCloudOrgpolicyV1ListPolicy(_messages.Message):
  r"""Used in `policy_type` to specify how `list_policy` behaves at this
  resource. `ListPolicy` can define specific values and subtrees of Cloud
  Resource Manager resource hierarchy (`Organizations`, `Folders`, `Projects`)
  that are allowed or denied by setting the `allowed_values` and
  `denied_values` fields. This is achieved by using the `under:` and optional
  `is:` prefixes. The `under:` prefix is used to denote resource subtree
  values. The `is:` prefix is used to denote specific values, and is required
  only if the value contains a ":". Values prefixed with "is:" are treated the
  same as values with no prefix. Ancestry subtrees must be in one of the
  following formats: - "projects/", e.g. "projects/tokyo-rain-123" -
  "folders/", e.g. "folders/1234" - "organizations/", e.g.
  "organizations/1234" The `supports_under` field of the associated
  `Constraint` defines whether ancestry prefixes can be used. You can set
  `allowed_values` and `denied_values` in the same `Policy` if `all_values` is
  `ALL_VALUES_UNSPECIFIED`. `ALLOW` or `DENY` are used to allow or deny all
  values. If `all_values` is set to either `ALLOW` or `DENY`, `allowed_values`
  and `denied_values` must be unset.

  Enums:
    AllValuesValueValuesEnum: The policy all_values state.

  Fields:
    allValues: The policy all_values state.
    allowedValues: List of values allowed at this resource. Can only be set if
      `all_values` is set to `ALL_VALUES_UNSPECIFIED`.
    deniedValues: List of values denied at this resource. Can only be set if
      `all_values` is set to `ALL_VALUES_UNSPECIFIED`.
    inheritFromParent: Determines the inheritance behavior for this `Policy`.
      By default, a `ListPolicy` set at a resource supersedes any `Policy` set
      anywhere up the resource hierarchy. However, if `inherit_from_parent` is
      set to `true`, then the values from the effective `Policy` of the parent
      resource are inherited, meaning the values set in this `Policy` are
      added to the values inherited up the hierarchy. Setting `Policy`
      hierarchies that inherit both allowed values and denied values isn't
      recommended in most circumstances to keep the configuration simple and
      understandable. However, it is possible to set a `Policy` with
      `allowed_values` set that inherits a `Policy` with `denied_values` set.
      In this case, the values that are allowed must be in `allowed_values`
      and not present in `denied_values`. For example, suppose you have a
      `Constraint` `constraints/serviceuser.services`, which has a
      `constraint_type` of `list_constraint`, and with `constraint_default`
      set to `ALLOW`. Suppose that at the Organization level, a `Policy` is
      applied that restricts the allowed API activations to {`E1`, `E2`}.
      Then, if a `Policy` is applied to a project below the Organization that
      has `inherit_from_parent` set to `false` and field all_values set to
      DENY, then an attempt to activate any API will be denied. The following
      examples demonstrate different possible layerings for `projects/bar`
      parented by `organizations/foo`: Example 1 (no inherited values):
      `organizations/foo` has a `Policy` with values: {allowed_values: "E1"
      allowed_values:"E2"} `projects/bar` has `inherit_from_parent` `false`
      and values: {allowed_values: "E3" allowed_values: "E4"} The accepted
      values at `organizations/foo` are `E1`, `E2`. The accepted values at
      `projects/bar` are `E3`, and `E4`. Example 2 (inherited values):
      `organizations/foo` has a `Policy` with values: {allowed_values: "E1"
      allowed_values:"E2"} `projects/bar` has a `Policy` with values: {value:
      "E3" value: "E4" inherit_from_parent: true} The accepted values at
      `organizations/foo` are `E1`, `E2`. The accepted values at
      `projects/bar` are `E1`, `E2`, `E3`, and `E4`. Example 3 (inheriting
      both allowed and denied values): `organizations/foo` has a `Policy` with
      values: {allowed_values: "E1" allowed_values: "E2"} `projects/bar` has a
      `Policy` with: {denied_values: "E1"} The accepted values at
      `organizations/foo` are `E1`, `E2`. The value accepted at `projects/bar`
      is `E2`. Example 4 (RestoreDefault): `organizations/foo` has a `Policy`
      with values: {allowed_values: "E1" allowed_values:"E2"} `projects/bar`
      has a `Policy` with values: {RestoreDefault: {}} The accepted values at
      `organizations/foo` are `E1`, `E2`. The accepted values at
      `projects/bar` are either all or none depending on the value of
      `constraint_default` (if `ALLOW`, all; if `DENY`, none). Example 5 (no
      policy inherits parent policy): `organizations/foo` has no `Policy` set.
      `projects/bar` has no `Policy` set. The accepted values at both levels
      are either all or none depending on the value of `constraint_default`
      (if `ALLOW`, all; if `DENY`, none). Example 6 (ListConstraint allowing
      all): `organizations/foo` has a `Policy` with values: {allowed_values:
      "E1" allowed_values: "E2"} `projects/bar` has a `Policy` with: {all:
      ALLOW} The accepted values at `organizations/foo` are `E1`, E2`. Any
      value is accepted at `projects/bar`. Example 7 (ListConstraint allowing
      none): `organizations/foo` has a `Policy` with values: {allowed_values:
      "E1" allowed_values: "E2"} `projects/bar` has a `Policy` with: {all:
      DENY} The accepted values at `organizations/foo` are `E1`, E2`. No value
      is accepted at `projects/bar`. Example 10 (allowed and denied subtrees
      of Resource Manager hierarchy): Given the following resource hierarchy
      O1->{F1, F2}; F1->{P1}; F2->{P2, P3}, `organizations/foo` has a `Policy`
      with values: {allowed_values: "under:organizations/O1"} `projects/bar`
      has a `Policy` with: {allowed_values: "under:projects/P3"}
      {denied_values: "under:folders/F2"} The accepted values at
      `organizations/foo` are `organizations/O1`, `folders/F1`, `folders/F2`,
      `projects/P1`, `projects/P2`, `projects/P3`. The accepted values at
      `projects/bar` are `organizations/O1`, `folders/F1`, `projects/P1`.
    suggestedValue: Optional. The Google Cloud Console will try to default to
      a configuration that matches the value specified in this `Policy`. If
      `suggested_value` is not set, it will inherit the value specified higher
      in the hierarchy, unless `inherit_from_parent` is `false`.
  """

  class AllValuesValueValuesEnum(_messages.Enum):
    r"""The policy all_values state.

    Values:
      ALL_VALUES_UNSPECIFIED: Indicates that allowed_values or denied_values
        must be set.
      ALLOW: A policy with this set allows all values.
      DENY: A policy with this set denies all values.
    """
    ALL_VALUES_UNSPECIFIED = 0
    ALLOW = 1
    DENY = 2

  allValues = _messages.EnumField('AllValuesValueValuesEnum', 1)
  allowedValues = _messages.StringField(2, repeated=True)
  deniedValues = _messages.StringField(3, repeated=True)
  inheritFromParent = _messages.BooleanField(4)
  suggestedValue = _messages.StringField(5)


class GoogleCloudOrgpolicyV1Policy(_messages.Message):
  r"""Defines a Cloud Organization `Policy` which is used to specify
  `Constraints` for configurations of Cloud Platform resources.

  Fields:
    booleanPolicy: For boolean `Constraints`, whether to enforce the
      `Constraint` or not.
    constraint: The name of the `Constraint` the `Policy` is configuring, for
      example, `constraints/serviceuser.services`. A [list of available
      constraints](/resource-manager/docs/organization-policy/org-policy-
      constraints) is available. Immutable after creation.
    etag: An opaque tag indicating the current version of the `Policy`, used
      for concurrency control. When the `Policy` is returned from either a
      `GetPolicy` or a `ListOrgPolicy` request, this `etag` indicates the
      version of the current `Policy` to use when executing a read-modify-
      write loop. When the `Policy` is returned from a `GetEffectivePolicy`
      request, the `etag` will be unset. When the `Policy` is used in a
      `SetOrgPolicy` method, use the `etag` value that was returned from a
      `GetOrgPolicy` request as part of a read-modify-write loop for
      concurrency control. Not setting the `etag`in a `SetOrgPolicy` request
      will result in an unconditional write of the `Policy`.
    listPolicy: List of values either allowed or disallowed.
    restoreDefault: Restores the default behavior of the constraint;
      independent of `Constraint` type.
    updateTime: The time stamp the `Policy` was previously updated. This is
      set by the server, not specified by the caller, and represents the last
      time a call to `SetOrgPolicy` was made for that `Policy`. Any value set
      by the client will be ignored.
    version: Version of the `Policy`. Default version is 0;
  """

  booleanPolicy = _messages.MessageField('GoogleCloudOrgpolicyV1BooleanPolicy', 1)
  constraint = _messages.StringField(2)
  etag = _messages.BytesField(3)
  listPolicy = _messages.MessageField('GoogleCloudOrgpolicyV1ListPolicy', 4)
  restoreDefault = _messages.MessageField('GoogleCloudOrgpolicyV1RestoreDefault', 5)
  updateTime = _messages.StringField(6)
  version = _messages.IntegerField(7, variant=_messages.Variant.INT32)


class GoogleCloudOrgpolicyV1RestoreDefault(_messages.Message):
  r"""Ignores policies set above this resource and restores the
  `constraint_default` enforcement behavior of the specific `Constraint` at
  this resource. Suppose that `constraint_default` is set to `ALLOW` for the
  `Constraint` `constraints/serviceuser.services`. Suppose that organization
  foo.com sets a `Policy` at their Organization resource node that restricts
  the allowed service activations to deny all service activations. They could
  then set a `Policy` with the `policy_type` `restore_default` on several
  experimental projects, restoring the `constraint_default` enforcement of the
  `Constraint` for only those projects, allowing those projects to have all
  services activated.
  """



class GoogleIdentityAccesscontextmanagerV1AccessLevel(_messages.Message):
  r"""An `AccessLevel` is a label that can be applied to requests to Google
  Cloud services, along with a list of requirements necessary for the label to
  be applied.

  Fields:
    basic: A `BasicLevel` composed of `Conditions`.
    custom: A `CustomLevel` written in the Common Expression Language.
    description: Description of the `AccessLevel` and its use. Does not affect
      behavior.
    name: Resource name for the `AccessLevel`. Format:
      `accessPolicies/{access_policy}/accessLevels/{access_level}`. The
      `access_level` component must begin with a letter, followed by
      alphanumeric characters or `_`. Its maximum length is 50 characters.
      After you create an `AccessLevel`, you cannot change its `name`.
    title: Human readable title. Must be unique within the Policy.
  """

  basic = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1BasicLevel', 1)
  custom = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1CustomLevel', 2)
  description = _messages.StringField(3)
  name = _messages.StringField(4)
  title = _messages.StringField(5)


class GoogleIdentityAccesscontextmanagerV1AccessPolicy(_messages.Message):
  r"""`AccessPolicy` is a container for `AccessLevels` (which define the
  necessary attributes to use Google Cloud services) and `ServicePerimeters`
  (which define regions of services able to freely pass data within a
  perimeter). An access policy is globally visible within an organization, and
  the restrictions it specifies apply to all projects within an organization.

  Fields:
    etag: Output only. An opaque identifier for the current version of the
      `AccessPolicy`. This will always be a strongly validated etag, meaning
      that two Access Polices will be identical if and only if their etags are
      identical. Clients should not expect this to be in any specific format.
    name: Output only. Resource name of the `AccessPolicy`. Format:
      `accessPolicies/{access_policy}`
    parent: Required. The parent of this `AccessPolicy` in the Cloud Resource
      Hierarchy. Currently immutable once created. Format:
      `organizations/{organization_id}`
    scopes: The scopes of a policy define which resources an ACM policy can
      restrict, and where ACM resources can be referenced. For example, a
      policy with scopes=["folders/123"] has the following behavior: - vpcsc
      perimeters can only restrict projects within folders/123 - access levels
      can only be referenced by resources within folders/123. If empty, there
      are no limitations on which resources can be restricted by an ACM
      policy, and there are no limitations on where ACM resources can be
      referenced. Only one policy can include a given scope (attempting to
      create a second policy which includes "folders/123" will result in an
      error). Currently, scopes cannot be modified after a policy is created.
      Currently, policies can only have a single scope. Format: list of
      `folders/{folder_number}` or `projects/{project_number}`
    title: Required. Human readable title. Does not affect behavior.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2)
  parent = _messages.StringField(3)
  scopes = _messages.StringField(4, repeated=True)
  title = _messages.StringField(5)


class GoogleIdentityAccesscontextmanagerV1ApiOperation(_messages.Message):
  r"""Identification for an API Operation.

  Fields:
    methodSelectors: API methods or permissions to allow. Method or permission
      must belong to the service specified by `service_name` field. A single
      MethodSelector entry with `*` specified for the `method` field will
      allow all methods AND permissions for the service specified in
      `service_name`.
    serviceName: The name of the API whose methods or permissions the
      IngressPolicy or EgressPolicy want to allow. A single ApiOperation with
      `service_name` field set to `*` will allow all methods AND permissions
      for all services.
  """

  methodSelectors = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1MethodSelector', 1, repeated=True)
  serviceName = _messages.StringField(2)


class GoogleIdentityAccesscontextmanagerV1BasicLevel(_messages.Message):
  r"""`BasicLevel` is an `AccessLevel` using a set of recommended features.

  Enums:
    CombiningFunctionValueValuesEnum: How the `conditions` list should be
      combined to determine if a request is granted this `AccessLevel`. If AND
      is used, each `Condition` in `conditions` must be satisfied for the
      `AccessLevel` to be applied. If OR is used, at least one `Condition` in
      `conditions` must be satisfied for the `AccessLevel` to be applied.
      Default behavior is AND.

  Fields:
    combiningFunction: How the `conditions` list should be combined to
      determine if a request is granted this `AccessLevel`. If AND is used,
      each `Condition` in `conditions` must be satisfied for the `AccessLevel`
      to be applied. If OR is used, at least one `Condition` in `conditions`
      must be satisfied for the `AccessLevel` to be applied. Default behavior
      is AND.
    conditions: Required. A list of requirements for the `AccessLevel` to be
      granted.
  """

  class CombiningFunctionValueValuesEnum(_messages.Enum):
    r"""How the `conditions` list should be combined to determine if a request
    is granted this `AccessLevel`. If AND is used, each `Condition` in
    `conditions` must be satisfied for the `AccessLevel` to be applied. If OR
    is used, at least one `Condition` in `conditions` must be satisfied for
    the `AccessLevel` to be applied. Default behavior is AND.

    Values:
      AND: All `Conditions` must be true for the `BasicLevel` to be true.
      OR: If at least one `Condition` is true, then the `BasicLevel` is true.
    """
    AND = 0
    OR = 1

  combiningFunction = _messages.EnumField('CombiningFunctionValueValuesEnum', 1)
  conditions = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1Condition', 2, repeated=True)


class GoogleIdentityAccesscontextmanagerV1Condition(_messages.Message):
  r"""A condition necessary for an `AccessLevel` to be granted. The Condition
  is an AND over its fields. So a Condition is true if: 1) the request IP is
  from one of the listed subnetworks AND 2) the originating device complies
  with the listed device policy AND 3) all listed access levels are granted
  AND 4) the request was sent at a time allowed by the DateTimeRestriction.

  Fields:
    devicePolicy: Device specific restrictions, all restrictions must hold for
      the Condition to be true. If not specified, all devices are allowed.
    ipSubnetworks: CIDR block IP subnetwork specification. May be IPv4 or
      IPv6. Note that for a CIDR IP address block, the specified IP address
      portion must be properly truncated (i.e. all the host bits must be zero)
      or the input is considered malformed. For example, "192.0.2.0/24" is
      accepted but "192.0.2.1/24" is not. Similarly, for IPv6, "2001:db8::/32"
      is accepted whereas "2001:db8::1/32" is not. The originating IP of a
      request must be in one of the listed subnets in order for this Condition
      to be true. If empty, all IP addresses are allowed.
    members: The request must be made by one of the provided user or service
      accounts. Groups are not supported. Syntax: `user:{emailid}`
      `serviceAccount:{emailid}` If not specified, a request may come from any
      user.
    negate: Whether to negate the Condition. If true, the Condition becomes a
      NAND over its non-empty fields, each field must be false for the
      Condition overall to be satisfied. Defaults to false.
    regions: The request must originate from one of the provided
      countries/regions. Must be valid ISO 3166-1 alpha-2 codes.
    requiredAccessLevels: A list of other access levels defined in the same
      `Policy`, referenced by resource name. Referencing an `AccessLevel`
      which does not exist is an error. All access levels listed must be
      granted for the Condition to be true. Example:
      "`accessPolicies/MY_POLICY/accessLevels/LEVEL_NAME"`
  """

  devicePolicy = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1DevicePolicy', 1)
  ipSubnetworks = _messages.StringField(2, repeated=True)
  members = _messages.StringField(3, repeated=True)
  negate = _messages.BooleanField(4)
  regions = _messages.StringField(5, repeated=True)
  requiredAccessLevels = _messages.StringField(6, repeated=True)


class GoogleIdentityAccesscontextmanagerV1CustomLevel(_messages.Message):
  r"""`CustomLevel` is an `AccessLevel` using the Cloud Common Expression
  Language to represent the necessary conditions for the level to apply to a
  request. See CEL spec at: https://github.com/google/cel-spec

  Fields:
    expr: Required. A Cloud CEL expression evaluating to a boolean.
  """

  expr = _messages.MessageField('Expr', 1)


class GoogleIdentityAccesscontextmanagerV1DevicePolicy(_messages.Message):
  r"""`DevicePolicy` specifies device specific restrictions necessary to
  acquire a given access level. A `DevicePolicy` specifies requirements for
  requests from devices to be granted access levels, it does not do any
  enforcement on the device. `DevicePolicy` acts as an AND over all specified
  fields, and each repeated field is an OR over its elements. Any unset fields
  are ignored. For example, if the proto is { os_type : DESKTOP_WINDOWS,
  os_type : DESKTOP_LINUX, encryption_status: ENCRYPTED}, then the
  DevicePolicy will be true for requests originating from encrypted Linux
  desktops and encrypted Windows desktops.

  Enums:
    AllowedDeviceManagementLevelsValueListEntryValuesEnum:
    AllowedEncryptionStatusesValueListEntryValuesEnum:

  Fields:
    allowedDeviceManagementLevels: Allowed device management levels, an empty
      list allows all management levels.
    allowedEncryptionStatuses: Allowed encryptions statuses, an empty list
      allows all statuses.
    osConstraints: Allowed OS versions, an empty list allows all types and all
      versions.
    requireAdminApproval: Whether the device needs to be approved by the
      customer admin.
    requireCorpOwned: Whether the device needs to be corp owned.
    requireScreenlock: Whether or not screenlock is required for the
      DevicePolicy to be true. Defaults to `false`.
  """

  class AllowedDeviceManagementLevelsValueListEntryValuesEnum(_messages.Enum):
    r"""AllowedDeviceManagementLevelsValueListEntryValuesEnum enum type.

    Values:
      MANAGEMENT_UNSPECIFIED: The device's management level is not specified
        or not known.
      NONE: The device is not managed.
      BASIC: Basic management is enabled, which is generally limited to
        monitoring and wiping the corporate account.
      COMPLETE: Complete device management. This includes more thorough
        monitoring and the ability to directly manage the device (such as
        remote wiping). This can be enabled through the Android Enterprise
        Platform.
    """
    MANAGEMENT_UNSPECIFIED = 0
    NONE = 1
    BASIC = 2
    COMPLETE = 3

  class AllowedEncryptionStatusesValueListEntryValuesEnum(_messages.Enum):
    r"""AllowedEncryptionStatusesValueListEntryValuesEnum enum type.

    Values:
      ENCRYPTION_UNSPECIFIED: The encryption status of the device is not
        specified or not known.
      ENCRYPTION_UNSUPPORTED: The device does not support encryption.
      UNENCRYPTED: The device supports encryption, but is currently
        unencrypted.
      ENCRYPTED: The device is encrypted.
    """
    ENCRYPTION_UNSPECIFIED = 0
    ENCRYPTION_UNSUPPORTED = 1
    UNENCRYPTED = 2
    ENCRYPTED = 3

  allowedDeviceManagementLevels = _messages.EnumField('AllowedDeviceManagementLevelsValueListEntryValuesEnum', 1, repeated=True)
  allowedEncryptionStatuses = _messages.EnumField('AllowedEncryptionStatusesValueListEntryValuesEnum', 2, repeated=True)
  osConstraints = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1OsConstraint', 3, repeated=True)
  requireAdminApproval = _messages.BooleanField(4)
  requireCorpOwned = _messages.BooleanField(5)
  requireScreenlock = _messages.BooleanField(6)


class GoogleIdentityAccesscontextmanagerV1EgressFrom(_messages.Message):
  r"""Defines the conditions under which an EgressPolicy matches a request.
  Conditions based on information about the source of the request. Note that
  if the destination of the request is also protected by a ServicePerimeter,
  then that ServicePerimeter must have an IngressPolicy which allows access in
  order for this request to succeed.

  Enums:
    IdentityTypeValueValuesEnum: Specifies the type of identities that are
      allowed access to outside the perimeter. If left unspecified, then
      members of `identities` field will be allowed access.

  Fields:
    identities: A list of identities that are allowed access through this
      [EgressPolicy]. Should be in the format of email address. The email
      address should represent individual user or service account only.
    identityType: Specifies the type of identities that are allowed access to
      outside the perimeter. If left unspecified, then members of `identities`
      field will be allowed access.
  """

  class IdentityTypeValueValuesEnum(_messages.Enum):
    r"""Specifies the type of identities that are allowed access to outside
    the perimeter. If left unspecified, then members of `identities` field
    will be allowed access.

    Values:
      IDENTITY_TYPE_UNSPECIFIED: No blanket identity group specified.
      ANY_IDENTITY: Authorize access from all identities outside the
        perimeter.
      ANY_USER_ACCOUNT: Authorize access from all human users outside the
        perimeter.
      ANY_SERVICE_ACCOUNT: Authorize access from all service accounts outside
        the perimeter.
    """
    IDENTITY_TYPE_UNSPECIFIED = 0
    ANY_IDENTITY = 1
    ANY_USER_ACCOUNT = 2
    ANY_SERVICE_ACCOUNT = 3

  identities = _messages.StringField(1, repeated=True)
  identityType = _messages.EnumField('IdentityTypeValueValuesEnum', 2)


class GoogleIdentityAccesscontextmanagerV1EgressPolicy(_messages.Message):
  r"""Policy for egress from perimeter. EgressPolicies match requests based on
  `egress_from` and `egress_to` stanzas. For an EgressPolicy to match, both
  `egress_from` and `egress_to` stanzas must be matched. If an EgressPolicy
  matches a request, the request is allowed to span the ServicePerimeter
  boundary. For example, an EgressPolicy can be used to allow VMs on networks
  within the ServicePerimeter to access a defined set of projects outside the
  perimeter in certain contexts (e.g. to read data from a Cloud Storage bucket
  or query against a BigQuery dataset). EgressPolicies are concerned with the
  *resources* that a request relates as well as the API services and API
  actions being used. They do not related to the direction of data movement.
  More detailed documentation for this concept can be found in the
  descriptions of EgressFrom and EgressTo.

  Fields:
    egressFrom: Defines conditions on the source of a request causing this
      EgressPolicy to apply.
    egressTo: Defines the conditions on the ApiOperation and destination
      resources that cause this EgressPolicy to apply.
  """

  egressFrom = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1EgressFrom', 1)
  egressTo = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1EgressTo', 2)


class GoogleIdentityAccesscontextmanagerV1EgressTo(_messages.Message):
  r"""Defines the conditions under which an EgressPolicy matches a request.
  Conditions are based on information about the ApiOperation intended to be
  performed on the `resources` specified. Note that if the destination of the
  request is also protected by a ServicePerimeter, then that ServicePerimeter
  must have an IngressPolicy which allows access in order for this request to
  succeed. The request must match `operations` AND `resources` fields in order
  to be allowed egress out of the perimeter.

  Fields:
    externalResources: A list of external resources that are allowed to be
      accessed. Only AWS and Azure resources are supported. For Amazon S3, the
      supported format is s3://BUCKET_NAME. For Azure Storage, the supported
      format is azure://myaccount.blob.core.windows.net/CONTAINER_NAME. A
      request matches if it contains an external resource in this list
      (Example: s3://bucket/path). Currently '*' is not allowed.
    operations: A list of ApiOperations allowed to be performed by the sources
      specified in the corresponding EgressFrom. A request matches if it uses
      an operation/service in this list.
    resources: A list of resources, currently only projects in the form
      `projects/`, that are allowed to be accessed by sources defined in the
      corresponding EgressFrom. A request matches if it contains a resource in
      this list. If `*` is specified for `resources`, then this EgressTo rule
      will authorize access to all resources outside the perimeter.
  """

  externalResources = _messages.StringField(1, repeated=True)
  operations = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1ApiOperation', 2, repeated=True)
  resources = _messages.StringField(3, repeated=True)


class GoogleIdentityAccesscontextmanagerV1IngressFrom(_messages.Message):
  r"""Defines the conditions under which an IngressPolicy matches a request.
  Conditions are based on information about the source of the request. The
  request must satisfy what is defined in `sources` AND identity related
  fields in order to match.

  Enums:
    IdentityTypeValueValuesEnum: Specifies the type of identities that are
      allowed access from outside the perimeter. If left unspecified, then
      members of `identities` field will be allowed access.

  Fields:
    identities: A list of identities that are allowed access through this
      ingress policy. Should be in the format of email address. The email
      address should represent individual user or service account only.
    identityType: Specifies the type of identities that are allowed access
      from outside the perimeter. If left unspecified, then members of
      `identities` field will be allowed access.
    sources: Sources that this IngressPolicy authorizes access from.
  """

  class IdentityTypeValueValuesEnum(_messages.Enum):
    r"""Specifies the type of identities that are allowed access from outside
    the perimeter. If left unspecified, then members of `identities` field
    will be allowed access.

    Values:
      IDENTITY_TYPE_UNSPECIFIED: No blanket identity group specified.
      ANY_IDENTITY: Authorize access from all identities outside the
        perimeter.
      ANY_USER_ACCOUNT: Authorize access from all human users outside the
        perimeter.
      ANY_SERVICE_ACCOUNT: Authorize access from all service accounts outside
        the perimeter.
    """
    IDENTITY_TYPE_UNSPECIFIED = 0
    ANY_IDENTITY = 1
    ANY_USER_ACCOUNT = 2
    ANY_SERVICE_ACCOUNT = 3

  identities = _messages.StringField(1, repeated=True)
  identityType = _messages.EnumField('IdentityTypeValueValuesEnum', 2)
  sources = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1IngressSource', 3, repeated=True)


class GoogleIdentityAccesscontextmanagerV1IngressPolicy(_messages.Message):
  r"""Policy for ingress into ServicePerimeter. IngressPolicies match requests
  based on `ingress_from` and `ingress_to` stanzas. For an ingress policy to
  match, both the `ingress_from` and `ingress_to` stanzas must be matched. If
  an IngressPolicy matches a request, the request is allowed through the
  perimeter boundary from outside the perimeter. For example, access from the
  internet can be allowed either based on an AccessLevel or, for traffic
  hosted on Google Cloud, the project of the source network. For access from
  private networks, using the project of the hosting network is required.
  Individual ingress policies can be limited by restricting which services
  and/or actions they match using the `ingress_to` field.

  Fields:
    ingressFrom: Defines the conditions on the source of a request causing
      this IngressPolicy to apply.
    ingressTo: Defines the conditions on the ApiOperation and request
      destination that cause this IngressPolicy to apply.
  """

  ingressFrom = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1IngressFrom', 1)
  ingressTo = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1IngressTo', 2)


class GoogleIdentityAccesscontextmanagerV1IngressSource(_messages.Message):
  r"""The source that IngressPolicy authorizes access from.

  Fields:
    accessLevel: An AccessLevel resource name that allow resources within the
      ServicePerimeters to be accessed from the internet. AccessLevels listed
      must be in the same policy as this ServicePerimeter. Referencing a
      nonexistent AccessLevel will cause an error. If no AccessLevel names are
      listed, resources within the perimeter can only be accessed via Google
      Cloud calls with request origins within the perimeter. Example:
      `accessPolicies/MY_POLICY/accessLevels/MY_LEVEL`. If a single `*` is
      specified for `access_level`, then all IngressSources will be allowed.
    resource: A Google Cloud resource that is allowed to ingress the
      perimeter. Requests from these resources will be allowed to access
      perimeter data. Currently only projects and VPCs are allowed. Project
      format: `projects/{project_number}` VPC network format:
      `//compute.googleapis.com/projects/{PROJECT_ID}/global/networks/{NAME}`.
      The project may be in any Google Cloud organization, not just the
      organization that the perimeter is defined in. `*` is not allowed, the
      case of allowing all Google Cloud resources only is not supported.
  """

  accessLevel = _messages.StringField(1)
  resource = _messages.StringField(2)


class GoogleIdentityAccesscontextmanagerV1IngressTo(_messages.Message):
  r"""Defines the conditions under which an IngressPolicy matches a request.
  Conditions are based on information about the ApiOperation intended to be
  performed on the target resource of the request. The request must satisfy
  what is defined in `operations` AND `resources` in order to match.

  Fields:
    operations: A list of ApiOperations allowed to be performed by the sources
      specified in corresponding IngressFrom in this ServicePerimeter.
    resources: A list of resources, currently only projects in the form
      `projects/`, protected by this ServicePerimeter that are allowed to be
      accessed by sources defined in the corresponding IngressFrom. If a
      single `*` is specified, then access to all resources inside the
      perimeter are allowed.
  """

  operations = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1ApiOperation', 1, repeated=True)
  resources = _messages.StringField(2, repeated=True)


class GoogleIdentityAccesscontextmanagerV1MethodSelector(_messages.Message):
  r"""An allowed method or permission of a service specified in ApiOperation.

  Fields:
    method: Value for `method` should be a valid method name for the
      corresponding `service_name` in ApiOperation. If `*` used as value for
      `method`, then ALL methods and permissions are allowed.
    permission: Value for `permission` should be a valid Cloud IAM permission
      for the corresponding `service_name` in ApiOperation.
  """

  method = _messages.StringField(1)
  permission = _messages.StringField(2)


class GoogleIdentityAccesscontextmanagerV1OsConstraint(_messages.Message):
  r"""A restriction on the OS type and version of devices making requests.

  Enums:
    OsTypeValueValuesEnum: Required. The allowed OS type.

  Fields:
    minimumVersion: The minimum allowed OS version. If not set, any version of
      this OS satisfies the constraint. Format: `"major.minor.patch"`.
      Examples: `"10.5.301"`, `"9.2.1"`.
    osType: Required. The allowed OS type.
    requireVerifiedChromeOs: Only allows requests from devices with a verified
      Chrome OS. Verifications includes requirements that the device is
      enterprise-managed, conformant to domain policies, and the caller has
      permission to call the API targeted by the request.
  """

  class OsTypeValueValuesEnum(_messages.Enum):
    r"""Required. The allowed OS type.

    Values:
      OS_UNSPECIFIED: The operating system of the device is not specified or
        not known.
      DESKTOP_MAC: A desktop Mac operating system.
      DESKTOP_WINDOWS: A desktop Windows operating system.
      DESKTOP_LINUX: A desktop Linux operating system.
      DESKTOP_CHROME_OS: A desktop ChromeOS operating system.
      ANDROID: An Android operating system.
      IOS: An iOS operating system.
    """
    OS_UNSPECIFIED = 0
    DESKTOP_MAC = 1
    DESKTOP_WINDOWS = 2
    DESKTOP_LINUX = 3
    DESKTOP_CHROME_OS = 4
    ANDROID = 5
    IOS = 6

  minimumVersion = _messages.StringField(1)
  osType = _messages.EnumField('OsTypeValueValuesEnum', 2)
  requireVerifiedChromeOs = _messages.BooleanField(3)


class GoogleIdentityAccesscontextmanagerV1ServicePerimeter(_messages.Message):
  r"""`ServicePerimeter` describes a set of Google Cloud resources which can
  freely import and export data amongst themselves, but not export outside of
  the `ServicePerimeter`. If a request with a source within this
  `ServicePerimeter` has a target outside of the `ServicePerimeter`, the
  request will be blocked. Otherwise the request is allowed. There are two
  types of Service Perimeter - Regular and Bridge. Regular Service Perimeters
  cannot overlap, a single Google Cloud project or VPC network can only belong
  to a single regular Service Perimeter. Service Perimeter Bridges can contain
  only Google Cloud projects as members, a single Google Cloud project may
  belong to multiple Service Perimeter Bridges.

  Enums:
    PerimeterTypeValueValuesEnum: Perimeter type indicator. A single project
      or VPC network is allowed to be a member of single regular perimeter,
      but multiple service perimeter bridges. A project cannot be a included
      in a perimeter bridge without being included in regular perimeter. For
      perimeter bridges, the restricted service list as well as access level
      lists must be empty.

  Fields:
    description: Description of the `ServicePerimeter` and its use. Does not
      affect behavior.
    name: Resource name for the `ServicePerimeter`. Format:
      `accessPolicies/{access_policy}/servicePerimeters/{service_perimeter}`.
      The `service_perimeter` component must begin with a letter, followed by
      alphanumeric characters or `_`. After you create a `ServicePerimeter`,
      you cannot change its `name`.
    perimeterType: Perimeter type indicator. A single project or VPC network
      is allowed to be a member of single regular perimeter, but multiple
      service perimeter bridges. A project cannot be a included in a perimeter
      bridge without being included in regular perimeter. For perimeter
      bridges, the restricted service list as well as access level lists must
      be empty.
    spec: Proposed (or dry run) ServicePerimeter configuration. This
      configuration allows to specify and test ServicePerimeter configuration
      without enforcing actual access restrictions. Only allowed to be set
      when the "use_explicit_dry_run_spec" flag is set.
    status: Current ServicePerimeter configuration. Specifies sets of
      resources, restricted services and access levels that determine
      perimeter content and boundaries.
    title: Human readable title. Must be unique within the Policy.
    useExplicitDryRunSpec: Use explicit dry run spec flag. Ordinarily, a dry-
      run spec implicitly exists for all Service Perimeters, and that spec is
      identical to the status for those Service Perimeters. When this flag is
      set, it inhibits the generation of the implicit spec, thereby allowing
      the user to explicitly provide a configuration ("spec") to use in a dry-
      run version of the Service Perimeter. This allows the user to test
      changes to the enforced config ("status") without actually enforcing
      them. This testing is done through analyzing the differences between
      currently enforced and suggested restrictions. use_explicit_dry_run_spec
      must bet set to True if any of the fields in the spec are set to non-
      default values.
  """

  class PerimeterTypeValueValuesEnum(_messages.Enum):
    r"""Perimeter type indicator. A single project or VPC network is allowed
    to be a member of single regular perimeter, but multiple service perimeter
    bridges. A project cannot be a included in a perimeter bridge without
    being included in regular perimeter. For perimeter bridges, the restricted
    service list as well as access level lists must be empty.

    Values:
      PERIMETER_TYPE_REGULAR: Regular Perimeter. When no value is specified,
        the perimeter uses this type.
      PERIMETER_TYPE_BRIDGE: Perimeter Bridge.
    """
    PERIMETER_TYPE_REGULAR = 0
    PERIMETER_TYPE_BRIDGE = 1

  description = _messages.StringField(1)
  name = _messages.StringField(2)
  perimeterType = _messages.EnumField('PerimeterTypeValueValuesEnum', 3)
  spec = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1ServicePerimeterConfig', 4)
  status = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1ServicePerimeterConfig', 5)
  title = _messages.StringField(6)
  useExplicitDryRunSpec = _messages.BooleanField(7)


class GoogleIdentityAccesscontextmanagerV1ServicePerimeterConfig(_messages.Message):
  r"""`ServicePerimeterConfig` specifies a set of Google Cloud resources that
  describe specific Service Perimeter configuration.

  Fields:
    accessLevels: A list of `AccessLevel` resource names that allow resources
      within the `ServicePerimeter` to be accessed from the internet.
      `AccessLevels` listed must be in the same policy as this
      `ServicePerimeter`. Referencing a nonexistent `AccessLevel` is a syntax
      error. If no `AccessLevel` names are listed, resources within the
      perimeter can only be accessed via Google Cloud calls with request
      origins within the perimeter. Example:
      `"accessPolicies/MY_POLICY/accessLevels/MY_LEVEL"`. For Service
      Perimeter Bridge, must be empty.
    egressPolicies: List of EgressPolicies to apply to the perimeter. A
      perimeter may have multiple EgressPolicies, each of which is evaluated
      separately. Access is granted if any EgressPolicy grants it. Must be
      empty for a perimeter bridge.
    ingressPolicies: List of IngressPolicies to apply to the perimeter. A
      perimeter may have multiple IngressPolicies, each of which is evaluated
      separately. Access is granted if any Ingress Policy grants it. Must be
      empty for a perimeter bridge.
    resources: A list of Google Cloud resources that are inside of the service
      perimeter. Currently only projects and VPCs are allowed. Project format:
      `projects/{project_number}` VPC network format:
      `//compute.googleapis.com/projects/{PROJECT_ID}/global/networks/{NAME}`.
    restrictedServices: Google Cloud services that are subject to the Service
      Perimeter restrictions. For example, if `storage.googleapis.com` is
      specified, access to the storage buckets inside the perimeter must meet
      the perimeter's access restrictions.
    vpcAccessibleServices: Configuration for APIs allowed within Perimeter.
  """

  accessLevels = _messages.StringField(1, repeated=True)
  egressPolicies = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1EgressPolicy', 2, repeated=True)
  ingressPolicies = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1IngressPolicy', 3, repeated=True)
  resources = _messages.StringField(4, repeated=True)
  restrictedServices = _messages.StringField(5, repeated=True)
  vpcAccessibleServices = _messages.MessageField('GoogleIdentityAccesscontextmanagerV1VpcAccessibleServices', 6)


class GoogleIdentityAccesscontextmanagerV1VpcAccessibleServices(_messages.Message):
  r"""Specifies how APIs are allowed to communicate within the Service
  Perimeter.

  Fields:
    allowedServices: The list of APIs usable within the Service Perimeter.
      Must be empty unless 'enable_restriction' is True. You can specify a
      list of individual services, as well as include the 'RESTRICTED-
      SERVICES' value, which automatically includes all of the services
      protected by the perimeter.
    enableRestriction: Whether to restrict API calls within the Service
      Perimeter to the list of APIs specified in 'allowed_services'.
  """

  allowedServices = _messages.StringField(1, repeated=True)
  enableRestriction = _messages.BooleanField(2)


class IamPolicyAnalysis(_messages.Message):
  r"""An analysis message to group the query and results.

  Fields:
    analysisQuery: The analysis query.
    analysisResults: A list of IamPolicyAnalysisResult that matches the
      analysis query, or empty if no result is found.
    fullyExplored: Represents whether all entries in the analysis_results have
      been fully explored to answer the query.
    nonCriticalErrors: A list of non-critical errors happened during the query
      handling.
  """

  analysisQuery = _messages.MessageField('IamPolicyAnalysisQuery', 1)
  analysisResults = _messages.MessageField('IamPolicyAnalysisResult', 2, repeated=True)
  fullyExplored = _messages.BooleanField(3)
  nonCriticalErrors = _messages.MessageField('IamPolicyAnalysisState', 4, repeated=True)


class IamPolicyAnalysisOutputConfig(_messages.Message):
  r"""Output configuration for export IAM policy analysis destination.

  Fields:
    bigqueryDestination: Destination on BigQuery.
    gcsDestination: Destination on Cloud Storage.
  """

  bigqueryDestination = _messages.MessageField('GoogleCloudAssetV1BigQueryDestination', 1)
  gcsDestination = _messages.MessageField('GoogleCloudAssetV1GcsDestination', 2)


class IamPolicyAnalysisQuery(_messages.Message):
  r"""IAM policy analysis query message.

  Fields:
    accessSelector: Optional. Specifies roles or permissions for analysis.
      This is optional.
    conditionContext: Optional. The hypothetical context for IAM conditions
      evaluation.
    identitySelector: Optional. Specifies an identity for analysis.
    options: Optional. The query options.
    resourceSelector: Optional. Specifies a resource for analysis.
    scope: Required. The relative name of the root asset. Only resources and
      IAM policies within the scope will be analyzed. This can only be an
      organization number (such as "organizations/123"), a folder number (such
      as "folders/123"), a project ID (such as "projects/my-project-id"), or a
      project number (such as "projects/12345"). To know how to get
      organization id, visit [here ](https://cloud.google.com/resource-
      manager/docs/creating-managing-
      organization#retrieving_your_organization_id). To know how to get folder
      or project id, visit [here ](https://cloud.google.com/resource-
      manager/docs/creating-managing-
      folders#viewing_or_listing_folders_and_projects).
  """

  accessSelector = _messages.MessageField('AccessSelector', 1)
  conditionContext = _messages.MessageField('ConditionContext', 2)
  identitySelector = _messages.MessageField('IdentitySelector', 3)
  options = _messages.MessageField('Options', 4)
  resourceSelector = _messages.MessageField('ResourceSelector', 5)
  scope = _messages.StringField(6)


class IamPolicyAnalysisResult(_messages.Message):
  r"""IAM Policy analysis result, consisting of one IAM policy binding and
  derived access control lists.

  Fields:
    accessControlLists: The access control lists derived from the iam_binding
      that match or potentially match resource and access selectors specified
      in the request.
    attachedResourceFullName: The [full resource
      name](https://cloud.google.com/asset-inventory/docs/resource-name-
      format) of the resource to which the iam_binding policy attaches.
    fullyExplored: Represents whether all analyses on the iam_binding have
      successfully finished.
    iamBinding: The IAM policy binding under analysis.
    identityList: The identity list derived from members of the iam_binding
      that match or potentially match identity selector specified in the
      request.
  """

  accessControlLists = _messages.MessageField('GoogleCloudAssetV1AccessControlList', 1, repeated=True)
  attachedResourceFullName = _messages.StringField(2)
  fullyExplored = _messages.BooleanField(3)
  iamBinding = _messages.MessageField('Binding', 4)
  identityList = _messages.MessageField('GoogleCloudAssetV1IdentityList', 5)


class IamPolicyAnalysisState(_messages.Message):
  r"""Represents the detailed state of an entity under analysis, such as a
  resource, an identity or an access.

  Enums:
    CodeValueValuesEnum: The Google standard error code that best describes
      the state. For example: - OK means the analysis on this entity has been
      successfully finished; - PERMISSION_DENIED means an access denied error
      is encountered; - DEADLINE_EXCEEDED means the analysis on this entity
      hasn't been started in time;

  Fields:
    cause: The human-readable description of the cause of failure.
    code: The Google standard error code that best describes the state. For
      example: - OK means the analysis on this entity has been successfully
      finished; - PERMISSION_DENIED means an access denied error is
      encountered; - DEADLINE_EXCEEDED means the analysis on this entity
      hasn't been started in time;
  """

  class CodeValueValuesEnum(_messages.Enum):
    r"""The Google standard error code that best describes the state. For
    example: - OK means the analysis on this entity has been successfully
    finished; - PERMISSION_DENIED means an access denied error is encountered;
    - DEADLINE_EXCEEDED means the analysis on this entity hasn't been started
    in time;

    Values:
      OK: Not an error; returned on success. HTTP Mapping: 200 OK
      CANCELLED: The operation was cancelled, typically by the caller. HTTP
        Mapping: 499 Client Closed Request
      UNKNOWN: Unknown error. For example, this error may be returned when a
        `Status` value received from another address space belongs to an error
        space that is not known in this address space. Also errors raised by
        APIs that do not return enough error information may be converted to
        this error. HTTP Mapping: 500 Internal Server Error
      INVALID_ARGUMENT: The client specified an invalid argument. Note that
        this differs from `FAILED_PRECONDITION`. `INVALID_ARGUMENT` indicates
        arguments that are problematic regardless of the state of the system
        (e.g., a malformed file name). HTTP Mapping: 400 Bad Request
      DEADLINE_EXCEEDED: The deadline expired before the operation could
        complete. For operations that change the state of the system, this
        error may be returned even if the operation has completed
        successfully. For example, a successful response from a server could
        have been delayed long enough for the deadline to expire. HTTP
        Mapping: 504 Gateway Timeout
      NOT_FOUND: Some requested entity (e.g., file or directory) was not
        found. Note to server developers: if a request is denied for an entire
        class of users, such as gradual feature rollout or undocumented
        allowlist, `NOT_FOUND` may be used. If a request is denied for some
        users within a class of users, such as user-based access control,
        `PERMISSION_DENIED` must be used. HTTP Mapping: 404 Not Found
      ALREADY_EXISTS: The entity that a client attempted to create (e.g., file
        or directory) already exists. HTTP Mapping: 409 Conflict
      PERMISSION_DENIED: The caller does not have permission to execute the
        specified operation. `PERMISSION_DENIED` must not be used for
        rejections caused by exhausting some resource (use
        `RESOURCE_EXHAUSTED` instead for those errors). `PERMISSION_DENIED`
        must not be used if the caller can not be identified (use
        `UNAUTHENTICATED` instead for those errors). This error code does not
        imply the request is valid or the requested entity exists or satisfies
        other pre-conditions. HTTP Mapping: 403 Forbidden
      UNAUTHENTICATED: The request does not have valid authentication
        credentials for the operation. HTTP Mapping: 401 Unauthorized
      RESOURCE_EXHAUSTED: Some resource has been exhausted, perhaps a per-user
        quota, or perhaps the entire file system is out of space. HTTP
        Mapping: 429 Too Many Requests
      FAILED_PRECONDITION: The operation was rejected because the system is
        not in a state required for the operation's execution. For example,
        the directory to be deleted is non-empty, an rmdir operation is
        applied to a non-directory, etc. Service implementors can use the
        following guidelines to decide between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`: (a) Use `UNAVAILABLE` if the client can
        retry just the failing call. (b) Use `ABORTED` if the client should
        retry at a higher level. For example, when a client-specified test-
        and-set fails, indicating the client should restart a read-modify-
        write sequence. (c) Use `FAILED_PRECONDITION` if the client should not
        retry until the system state has been explicitly fixed. For example,
        if an "rmdir" fails because the directory is non-empty,
        `FAILED_PRECONDITION` should be returned since the client should not
        retry unless the files are deleted from the directory. HTTP Mapping:
        400 Bad Request
      ABORTED: The operation was aborted, typically due to a concurrency issue
        such as a sequencer check failure or transaction abort. See the
        guidelines above for deciding between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`. HTTP Mapping: 409 Conflict
      OUT_OF_RANGE: The operation was attempted past the valid range. E.g.,
        seeking or reading past end-of-file. Unlike `INVALID_ARGUMENT`, this
        error indicates a problem that may be fixed if the system state
        changes. For example, a 32-bit file system will generate
        `INVALID_ARGUMENT` if asked to read at an offset that is not in the
        range [0,2^32-1], but it will generate `OUT_OF_RANGE` if asked to read
        from an offset past the current file size. There is a fair bit of
        overlap between `FAILED_PRECONDITION` and `OUT_OF_RANGE`. We recommend
        using `OUT_OF_RANGE` (the more specific error) when it applies so that
        callers who are iterating through a space can easily look for an
        `OUT_OF_RANGE` error to detect when they are done. HTTP Mapping: 400
        Bad Request
      UNIMPLEMENTED: The operation is not implemented or is not
        supported/enabled in this service. HTTP Mapping: 501 Not Implemented
      INTERNAL: Internal errors. This means that some invariants expected by
        the underlying system have been broken. This error code is reserved
        for serious errors. HTTP Mapping: 500 Internal Server Error
      UNAVAILABLE: The service is currently unavailable. This is most likely a
        transient condition, which can be corrected by retrying with a
        backoff. Note that it is not always safe to retry non-idempotent
        operations. See the guidelines above for deciding between
        `FAILED_PRECONDITION`, `ABORTED`, and `UNAVAILABLE`. HTTP Mapping: 503
        Service Unavailable
      DATA_LOSS: Unrecoverable data loss or corruption. HTTP Mapping: 500
        Internal Server Error
    """
    OK = 0
    CANCELLED = 1
    UNKNOWN = 2
    INVALID_ARGUMENT = 3
    DEADLINE_EXCEEDED = 4
    NOT_FOUND = 5
    ALREADY_EXISTS = 6
    PERMISSION_DENIED = 7
    UNAUTHENTICATED = 8
    RESOURCE_EXHAUSTED = 9
    FAILED_PRECONDITION = 10
    ABORTED = 11
    OUT_OF_RANGE = 12
    UNIMPLEMENTED = 13
    INTERNAL = 14
    UNAVAILABLE = 15
    DATA_LOSS = 16

  cause = _messages.StringField(1)
  code = _messages.EnumField('CodeValueValuesEnum', 2)


class IamPolicySearchResult(_messages.Message):
  r"""A result of IAM Policy search, containing information of an IAM policy.

  Fields:
    assetType: The type of the resource associated with this IAM policy.
      Example: `compute.googleapis.com/Disk`. To search against the
      `asset_type`: * specify the `asset_types` field in your search request.
    explanation: Explanation about the IAM policy search result. It contains
      additional information to explain why the search result matches the
      query.
    folders: The folder(s) that the IAM policy belongs to, in the form of
      folders/{FOLDER_NUMBER}. This field is available when the IAM policy
      belongs to one or more folders. To search against `folders`: * use a
      field query. Example: `folders:(123 OR 456)` * use a free text query.
      Example: `123` * specify the `scope` field as this folder in your search
      request.
    organization: The organization that the IAM policy belongs to, in the form
      of organizations/{ORGANIZATION_NUMBER}. This field is available when the
      IAM policy belongs to an organization. To search against `organization`:
      * use a field query. Example: `organization:123` * use a free text
      query. Example: `123` * specify the `scope` field as this organization
      in your search request.
    policy: The IAM policy directly set on the given resource. Note that the
      original IAM policy can contain multiple bindings. This only contains
      the bindings that match the given query. For queries that don't contain
      a constrain on policies (e.g., an empty query), this contains all the
      bindings. To search against the `policy` bindings: * use a field query:
      - query by the policy contained members. Example: `policy:amy@gmail.com`
      - query by the policy contained roles. Example:
      `policy:roles/compute.admin` - query by the policy contained roles'
      included permissions. Example:
      `policy.role.permissions:compute.instances.create`
    project: The project that the associated Google Cloud resource belongs to,
      in the form of projects/{PROJECT_NUMBER}. If an IAM policy is set on a
      resource (like VM instance, Cloud Storage bucket), the project field
      will indicate the project that contains the resource. If an IAM policy
      is set on a folder or orgnization, this field will be empty. To search
      against the `project`: * specify the `scope` field as this project in
      your search request.
    resource: The full resource name of the resource associated with this IAM
      policy. Example: `//compute.googleapis.com/projects/my_project_123/zones
      /zone1/instances/instance1`. See [Cloud Asset Inventory Resource Name
      Format](https://cloud.google.com/asset-inventory/docs/resource-name-
      format) for more information. To search against the `resource`: * use a
      field query. Example: `resource:organizations/123`
  """

  assetType = _messages.StringField(1)
  explanation = _messages.MessageField('Explanation', 2)
  folders = _messages.StringField(3, repeated=True)
  organization = _messages.StringField(4)
  policy = _messages.MessageField('Policy', 5)
  project = _messages.StringField(6)
  resource = _messages.StringField(7)


class IdentitySelector(_messages.Message):
  r"""Specifies an identity for which to determine resource access, based on
  roles assigned either directly to them or to the groups they belong to,
  directly or indirectly.

  Fields:
    identity: Required. The identity appear in the form of principals in [IAM
      policy binding](https://cloud.google.com/iam/reference/rest/v1/Binding).
      The examples of supported forms are: "user:mike@example.com",
      "group:admins@example.com", "domain:google.com", "serviceAccount:my-
      project-id@appspot.gserviceaccount.com". Notice that wildcard characters
      (such as * and ?) are not supported. You must give a specific identity.
  """

  identity = _messages.StringField(1)


class Inventory(_messages.Message):
  r"""This API resource represents the available inventory data for a Compute
  Engine virtual machine (VM) instance at a given point in time. You can use
  this API resource to determine the inventory data of your VM. For more
  information, see [Information provided by OS inventory
  management](https://cloud.google.com/compute/docs/instances/os-inventory-
  management#data-collected).

  Messages:
    ItemsValue: Inventory items related to the VM keyed by an opaque unique
      identifier for each inventory item. The identifier is unique to each
      distinct and addressable inventory item and will change, when there is a
      new package version.

  Fields:
    items: Inventory items related to the VM keyed by an opaque unique
      identifier for each inventory item. The identifier is unique to each
      distinct and addressable inventory item and will change, when there is a
      new package version.
    name: Output only. The `Inventory` API resource name. Format: `projects/{p
      roject_number}/locations/{location}/instances/{instance_id}/inventory`
    osInfo: Base level operating system information for the VM.
    updateTime: Output only. Timestamp of the last reported inventory for the
      VM.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    r"""Inventory items related to the VM keyed by an opaque unique identifier
    for each inventory item. The identifier is unique to each distinct and
    addressable inventory item and will change, when there is a new package
    version.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: Additional properties of type ItemsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A Item attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Item', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  items = _messages.MessageField('ItemsValue', 1)
  name = _messages.StringField(2)
  osInfo = _messages.MessageField('OsInfo', 3)
  updateTime = _messages.StringField(4)


class Item(_messages.Message):
  r"""A single piece of inventory on a VM.

  Enums:
    OriginTypeValueValuesEnum: The origin of this inventory item.
    TypeValueValuesEnum: The specific type of inventory, correlating to its
      specific details.

  Fields:
    availablePackage: Software package available to be installed on the VM
      instance.
    createTime: When this inventory item was first detected.
    id: Identifier for this item, unique across items for this VM.
    installedPackage: Software package present on the VM instance.
    originType: The origin of this inventory item.
    type: The specific type of inventory, correlating to its specific details.
    updateTime: When this inventory item was last modified.
  """

  class OriginTypeValueValuesEnum(_messages.Enum):
    r"""The origin of this inventory item.

    Values:
      ORIGIN_TYPE_UNSPECIFIED: Invalid. An origin type must be specified.
      INVENTORY_REPORT: This inventory item was discovered as the result of
        the agent reporting inventory via the reporting API.
    """
    ORIGIN_TYPE_UNSPECIFIED = 0
    INVENTORY_REPORT = 1

  class TypeValueValuesEnum(_messages.Enum):
    r"""The specific type of inventory, correlating to its specific details.

    Values:
      TYPE_UNSPECIFIED: Invalid. An type must be specified.
      INSTALLED_PACKAGE: This represents a package that is installed on the
        VM.
      AVAILABLE_PACKAGE: This represents an update that is available for a
        package.
    """
    TYPE_UNSPECIFIED = 0
    INSTALLED_PACKAGE = 1
    AVAILABLE_PACKAGE = 2

  availablePackage = _messages.MessageField('SoftwarePackage', 1)
  createTime = _messages.StringField(2)
  id = _messages.StringField(3)
  installedPackage = _messages.MessageField('SoftwarePackage', 4)
  originType = _messages.EnumField('OriginTypeValueValuesEnum', 5)
  type = _messages.EnumField('TypeValueValuesEnum', 6)
  updateTime = _messages.StringField(7)


class ListAssetsResponse(_messages.Message):
  r"""ListAssets response.

  Fields:
    assets: Assets.
    nextPageToken: Token to retrieve the next page of results. It expires 72
      hours after the page token for the first page is generated. Set to empty
      if there are no remaining results.
    readTime: Time the snapshot was taken.
  """

  assets = _messages.MessageField('Asset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  readTime = _messages.StringField(3)


class ListFeedsResponse(_messages.Message):
  r"""A ListFeedsResponse object.

  Fields:
    feeds: A list of feeds.
  """

  feeds = _messages.MessageField('Feed', 1, repeated=True)


class ListSavedQueriesResponse(_messages.Message):
  r"""Response of listing saved queries.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    savedQueries: A list of savedQueries.
  """

  nextPageToken = _messages.StringField(1)
  savedQueries = _messages.MessageField('SavedQuery', 2, repeated=True)


class MoveAnalysis(_messages.Message):
  r"""A message to group the analysis information.

  Fields:
    analysis: Analysis result of moving the target resource.
    displayName: The user friendly display name of the analysis. E.g. IAM,
      organization policy etc.
    error: Description of error encountered when performing the analysis.
  """

  analysis = _messages.MessageField('MoveAnalysisResult', 1)
  displayName = _messages.StringField(2)
  error = _messages.MessageField('Status', 3)


class MoveAnalysisResult(_messages.Message):
  r"""An analysis result including blockers and warnings.

  Fields:
    blockers: Blocking information that would prevent the target resource from
      moving to the specified destination at runtime.
    warnings: Warning information indicating that moving the target resource
      to the specified destination might be unsafe. This can include important
      policy information and configuration changes, but will not block moves
      at runtime.
  """

  blockers = _messages.MessageField('MoveImpact', 1, repeated=True)
  warnings = _messages.MessageField('MoveImpact', 2, repeated=True)


class MoveImpact(_messages.Message):
  r"""A message to group impacts of moving the target resource.

  Fields:
    detail: User friendly impact detail in a free form message.
  """

  detail = _messages.StringField(1)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class Options(_messages.Message):
  r"""Contains query options.

  Fields:
    analyzeServiceAccountImpersonation: Optional. If true, the response will
      include access analysis from identities to resources via service account
      impersonation. This is a very expensive operation, because many derived
      queries will be executed. We highly recommend you use
      AssetService.AnalyzeIamPolicyLongrunning RPC instead. For example, if
      the request analyzes for which resources user A has permission P, and
      there's an IAM policy states user A has
      iam.serviceAccounts.getAccessToken permission to a service account SA,
      and there's another IAM policy states service account SA has permission
      P to a Google Cloud folder F, then user A potentially has access to the
      Google Cloud folder F. And those advanced analysis results will be
      included in
      AnalyzeIamPolicyResponse.service_account_impersonation_analysis. Another
      example, if the request analyzes for who has permission P to a Google
      Cloud folder F, and there's an IAM policy states user A has
      iam.serviceAccounts.actAs permission to a service account SA, and
      there's another IAM policy states service account SA has permission P to
      the Google Cloud folder F, then user A potentially has access to the
      Google Cloud folder F. And those advanced analysis results will be
      included in
      AnalyzeIamPolicyResponse.service_account_impersonation_analysis. Only
      the following permissions are considered in this analysis: *
      `iam.serviceAccounts.actAs` * `iam.serviceAccounts.signBlob` *
      `iam.serviceAccounts.signJwt` * `iam.serviceAccounts.getAccessToken` *
      `iam.serviceAccounts.getOpenIdToken` *
      `iam.serviceAccounts.implicitDelegation` Default is false.
    expandGroups: Optional. If true, the identities section of the result will
      expand any Google groups appearing in an IAM policy binding. If
      IamPolicyAnalysisQuery.identity_selector is specified, the identity in
      the result will be determined by the selector, and this flag is not
      allowed to set. If true, the default max expansion per group is 1000 for
      AssetService.AnalyzeIamPolicy][]. Default is false.
    expandResources: Optional. If true and
      IamPolicyAnalysisQuery.resource_selector is not specified, the resource
      section of the result will expand any resource attached to an IAM policy
      to include resources lower in the resource hierarchy. For example, if
      the request analyzes for which resources user A has permission P, and
      the results include an IAM policy with P on a Google Cloud folder, the
      results will also include resources in that folder with permission P. If
      true and IamPolicyAnalysisQuery.resource_selector is specified, the
      resource section of the result will expand the specified resource to
      include resources lower in the resource hierarchy. Only project or lower
      resources are supported. Folder and organization resources cannot be
      used together with this option. For example, if the request analyzes for
      which users have permission P on a Google Cloud project with this option
      enabled, the results will include all users who have permission P on
      that project or any lower resource. If true, the default max expansion
      per resource is 1000 for AssetService.AnalyzeIamPolicy][] and 100000 for
      AssetService.AnalyzeIamPolicyLongrunning][]. Default is false.
    expandRoles: Optional. If true, the access section of result will expand
      any roles appearing in IAM policy bindings to include their permissions.
      If IamPolicyAnalysisQuery.access_selector is specified, the access
      section of the result will be determined by the selector, and this flag
      is not allowed to set. Default is false.
    outputGroupEdges: Optional. If true, the result will output the relevant
      membership relationships between groups and other groups, and between
      groups and principals. Default is false.
    outputResourceEdges: Optional. If true, the result will output the
      relevant parent/child relationships between resources. Default is false.
  """

  analyzeServiceAccountImpersonation = _messages.BooleanField(1)
  expandGroups = _messages.BooleanField(2)
  expandResources = _messages.BooleanField(3)
  expandRoles = _messages.BooleanField(4)
  outputGroupEdges = _messages.BooleanField(5)
  outputResourceEdges = _messages.BooleanField(6)


class OrgPolicyResult(_messages.Message):
  r"""The organization policy result to the query.

  Fields:
    consolidatedPolicy: The consolidated organization policy for the analyzed
      resource. The consolidated organization policy is computed by merging
      and evaluating AnalyzeOrgPoliciesResponse.policy_bundle. The evaluation
      will respect the organization policy [hierarchy
      rules](https://cloud.google.com/resource-manager/docs/organization-
      policy/understanding-hierarchy).
    policyBundle: The ordered list of all organization policies from the Analy
      zeOrgPoliciesResponse.OrgPolicyResult.consolidated_policy.attached_resou
      rce. to the scope specified in the request. If the constraint is defined
      with default policy, it will also appear in the list.
  """

  consolidatedPolicy = _messages.MessageField('AnalyzerOrgPolicy', 1)
  policyBundle = _messages.MessageField('AnalyzerOrgPolicy', 2, repeated=True)


class OsInfo(_messages.Message):
  r"""Operating system information for the VM.

  Fields:
    architecture: The system architecture of the operating system.
    hostname: The VM hostname.
    kernelRelease: The kernel release of the operating system.
    kernelVersion: The kernel version of the operating system.
    longName: The operating system long name. For example 'Debian GNU/Linux 9'
      or 'Microsoft Window Server 2019 Datacenter'.
    osconfigAgentVersion: The current version of the OS Config agent running
      on the VM.
    shortName: The operating system short name. For example, 'windows' or
      'debian'.
    version: The version of the operating system.
  """

  architecture = _messages.StringField(1)
  hostname = _messages.StringField(2)
  kernelRelease = _messages.StringField(3)
  kernelVersion = _messages.StringField(4)
  longName = _messages.StringField(5)
  osconfigAgentVersion = _messages.StringField(6)
  shortName = _messages.StringField(7)
  version = _messages.StringField(8)


class OutputConfig(_messages.Message):
  r"""Output configuration for export assets destination.

  Fields:
    bigqueryDestination: Destination on BigQuery. The output table stores the
      fields in asset Protobuf as columns in BigQuery.
    gcsDestination: Destination on Cloud Storage.
  """

  bigqueryDestination = _messages.MessageField('BigQueryDestination', 1)
  gcsDestination = _messages.MessageField('GcsDestination', 2)


class PartitionSpec(_messages.Message):
  r"""Specifications of BigQuery partitioned table as export destination.

  Enums:
    PartitionKeyValueValuesEnum: The partition key for BigQuery partitioned
      table.

  Fields:
    partitionKey: The partition key for BigQuery partitioned table.
  """

  class PartitionKeyValueValuesEnum(_messages.Enum):
    r"""The partition key for BigQuery partitioned table.

    Values:
      PARTITION_KEY_UNSPECIFIED: Unspecified partition key. If used, it means
        using non-partitioned table.
      READ_TIME: The time when the snapshot is taken. If specified as
        partition key, the result table(s) is partitoned by the additional
        timestamp column, readTime. If [read_time] in ExportAssetsRequest is
        specified, the readTime column's value will be the same as it.
        Otherwise, its value will be the current time that is used to take the
        snapshot.
      REQUEST_TIME: The time when the request is received and started to be
        processed. If specified as partition key, the result table(s) is
        partitoned by the requestTime column, an additional timestamp column
        representing when the request was received.
    """
    PARTITION_KEY_UNSPECIFIED = 0
    READ_TIME = 1
    REQUEST_TIME = 2

  partitionKey = _messages.EnumField('PartitionKeyValueValuesEnum', 1)


class Permissions(_messages.Message):
  r"""IAM permissions

  Fields:
    permissions: A list of permissions. A sample permission string:
      `compute.disk.get`.
  """

  permissions = _messages.StringField(1, repeated=True)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class PolicyInfo(_messages.Message):
  r"""The IAM policy and its attached resource.

  Fields:
    attachedResource: The full resource name the policy is directly attached
      to.
    policy: The IAM policy that's directly attached to the attached_resource.
  """

  attachedResource = _messages.StringField(1)
  policy = _messages.MessageField('Policy', 2)


class PubsubDestination(_messages.Message):
  r"""A Pub/Sub destination.

  Fields:
    topic: The name of the Pub/Sub topic to publish to. Example:
      `projects/PROJECT_ID/topics/TOPIC_ID`.
  """

  topic = _messages.StringField(1)


class QueryAssetsOutputConfig(_messages.Message):
  r"""Output configuration query assets.

  Fields:
    bigqueryDestination: BigQuery destination where the query results will be
      saved.
  """

  bigqueryDestination = _messages.MessageField('GoogleCloudAssetV1QueryAssetsOutputConfigBigQueryDestination', 1)


class QueryAssetsRequest(_messages.Message):
  r"""QueryAssets request.

  Fields:
    jobReference: Optional. Reference to the query job, which is from the
      `QueryAssetsResponse` of previous `QueryAssets` call.
    outputConfig: Optional. Destination where the query results will be saved.
      When this field is specified, the query results won't be saved in the
      [QueryAssetsResponse.query_result]. Instead
      [QueryAssetsResponse.output_config] will be set. Meanwhile,
      [QueryAssetsResponse.job_reference] will be set and can be used to check
      the status of the query job when passed to a following [QueryAssets] API
      call.
    pageSize: Optional. The maximum number of rows to return in the results.
      Responses are limited to 10 MB and 1000 rows. By default, the maximum
      row count is 1000. When the byte or row count limit is reached, the rest
      of the query results will be paginated. The field will be ignored when
      [output_config] is specified.
    pageToken: Optional. A page token received from previous `QueryAssets`.
      The field will be ignored when [output_config] is specified.
    readTime: Optional. Queries cloud assets as they appeared at the specified
      point in time.
    readTimeWindow: Optional. [start_time] is required. [start_time] must be
      less than [end_time] Defaults [end_time] to now if [start_time] is set
      and [end_time] isn't. Maximum permitted time range is 7 days.
    statement: Optional. A SQL statement that's compatible with [BigQuery
      Standard SQL](http://cloud/bigquery/docs/reference/standard-
      sql/enabling-standard-sql).
    timeout: Optional. Specifies the maximum amount of time that the client is
      willing to wait for the query to complete. By default, this limit is 5
      min for the first query, and 1 minute for the following queries. If the
      query is complete, the `done` field in the `QueryAssetsResponse` is
      true, otherwise false. Like BigQuery [jobs.query API](https://cloud.goog
      le.com/bigquery/docs/reference/rest/v2/jobs/query#queryrequest) The call
      is not guaranteed to wait for the specified timeout; it typically
      returns after around 200 seconds (200,000 milliseconds), even if the
      query is not complete. The field will be ignored when [output_config] is
      specified.
  """

  jobReference = _messages.StringField(1)
  outputConfig = _messages.MessageField('QueryAssetsOutputConfig', 2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  readTime = _messages.StringField(5)
  readTimeWindow = _messages.MessageField('TimeWindow', 6)
  statement = _messages.StringField(7)
  timeout = _messages.StringField(8)


class QueryAssetsResponse(_messages.Message):
  r"""QueryAssets response.

  Fields:
    done: The query response, which can be either an `error` or a valid
      `response`. If `done` == `false` and the query result is being saved in
      a output, the output_config field will be set. If `done` == `true`,
      exactly one of `error`, `query_result` or `output_config` will be set.
    error: Error status.
    jobReference: Reference to a query job.
    outputConfig: Output configuration which indicates instead of being
      returned in API response on the fly, the query result will be saved in a
      specific output.
    queryResult: Result of the query.
  """

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  jobReference = _messages.StringField(3)
  outputConfig = _messages.MessageField('QueryAssetsOutputConfig', 4)
  queryResult = _messages.MessageField('QueryResult', 5)


class QueryContent(_messages.Message):
  r"""The query content.

  Fields:
    iamPolicyAnalysisQuery: An IAM Policy Analysis query, which could be used
      in the AssetService.AnalyzeIamPolicy RPC or the
      AssetService.AnalyzeIamPolicyLongrunning RPC.
  """

  iamPolicyAnalysisQuery = _messages.MessageField('IamPolicyAnalysisQuery', 1)


class QueryResult(_messages.Message):
  r"""Execution results of the query. The result is formatted as rows
  represented by BigQuery compatible [schema]. When pagination is necessary,
  it will contains the page token to retrieve the results of following pages.

  Messages:
    RowsValueListEntry: A RowsValueListEntry object.

  Fields:
    nextPageToken: Token to retrieve the next page of the results.
    rows: Each row hold a query result in the format of `Struct`.
    schema: Describes the format of the [rows].
    totalRows: Total rows of the whole query results.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RowsValueListEntry(_messages.Message):
    r"""A RowsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a RowsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RowsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  nextPageToken = _messages.StringField(1)
  rows = _messages.MessageField('RowsValueListEntry', 2, repeated=True)
  schema = _messages.MessageField('TableSchema', 3)
  totalRows = _messages.IntegerField(4)


class RelatedAsset(_messages.Message):
  r"""An asset identifier in Google Cloud which contains its name, type and
  ancestors. An asset can be any resource in the Google Cloud [resource
  hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-
  resource-hierarchy), a resource outside the Google Cloud resource hierarchy
  (such as Google Kubernetes Engine clusters and objects), or a policy (e.g.
  IAM policy). See [Supported asset types](https://cloud.google.com/asset-
  inventory/docs/supported-asset-types) for more information.

  Fields:
    ancestors: The ancestors of an asset in Google Cloud [resource
      hierarchy](https://cloud.google.com/resource-manager/docs/cloud-
      platform-resource-hierarchy), represented as a list of relative resource
      names. An ancestry path starts with the closest ancestor in the
      hierarchy and ends at root. Example: `["projects/123456789",
      "folders/5432", "organizations/1234"]`
    asset: The full name of the asset. Example: `//compute.googleapis.com/proj
      ects/my_project_123/zones/zone1/instances/instance1` See [Resource names
      ](https://cloud.google.com/apis/design/resource_names#full_resource_name
      ) for more information.
    assetType: The type of the asset. Example: `compute.googleapis.com/Disk`
      See [Supported asset types](https://cloud.google.com/asset-
      inventory/docs/supported-asset-types) for more information.
    relationshipType: The unique identifier of the relationship type. Example:
      `INSTANCE_TO_INSTANCEGROUP`
  """

  ancestors = _messages.StringField(1, repeated=True)
  asset = _messages.StringField(2)
  assetType = _messages.StringField(3)
  relationshipType = _messages.StringField(4)


class RelatedAssets(_messages.Message):
  r"""DEPRECATED. This message only presents for the purpose of backward-
  compatibility. The server will never populate this message in responses. The
  detailed related assets with the `relationship_type`.

  Fields:
    assets: The peer resources of the relationship.
    relationshipAttributes: The detailed relationship attributes.
  """

  assets = _messages.MessageField('RelatedAsset', 1, repeated=True)
  relationshipAttributes = _messages.MessageField('RelationshipAttributes', 2)


class RelatedResource(_messages.Message):
  r"""The detailed related resource.

  Fields:
    assetType: The type of the asset. Example:
      `compute.googleapis.com/Instance`
    fullResourceName: The full resource name of the related resource. Example:
      `//compute.googleapis.com/projects/my_proj_123/zones/instance/instance12
      3`
  """

  assetType = _messages.StringField(1)
  fullResourceName = _messages.StringField(2)


class RelatedResources(_messages.Message):
  r"""The related resources of the primary resource.

  Fields:
    relatedResources: The detailed related resources of the primary resource.
  """

  relatedResources = _messages.MessageField('RelatedResource', 1, repeated=True)


class RelationshipAttributes(_messages.Message):
  r"""DEPRECATED. This message only presents for the purpose of backward-
  compatibility. The server will never populate this message in responses. The
  relationship attributes which include `type`, `source_resource_type`,
  `target_resource_type` and `action`.

  Fields:
    action: The detail of the relationship, e.g. `contains`, `attaches`
    sourceResourceType: The source asset type. Example:
      `compute.googleapis.com/Instance`
    targetResourceType: The target asset type. Example:
      `compute.googleapis.com/Disk`
    type: The unique identifier of the relationship type. Example:
      `INSTANCE_TO_INSTANCEGROUP`
  """

  action = _messages.StringField(1)
  sourceResourceType = _messages.StringField(2)
  targetResourceType = _messages.StringField(3)
  type = _messages.StringField(4)


class Resource(_messages.Message):
  r"""A representation of a Google Cloud resource.

  Messages:
    DataValue: The content of the resource, in which some sensitive fields are
      removed and may not be present.

  Fields:
    data: The content of the resource, in which some sensitive fields are
      removed and may not be present.
    discoveryDocumentUri: The URL of the discovery document containing the
      resource's JSON schema. Example:
      `https://www.googleapis.com/discovery/v1/apis/compute/v1/rest` This
      value is unspecified for resources that do not have an API based on a
      discovery document, such as Cloud Bigtable.
    discoveryName: The JSON schema name listed in the discovery document.
      Example: `Project` This value is unspecified for resources that do not
      have an API based on a discovery document, such as Cloud Bigtable.
    location: The location of the resource in Google Cloud, such as its zone
      and region. For more information, see
      https://cloud.google.com/about/locations/.
    parent: The full name of the immediate parent of this resource. See
      [Resource Names](https://cloud.google.com/apis/design/resource_names#ful
      l_resource_name) for more information. For Google Cloud assets, this
      value is the parent resource defined in the [IAM policy
      hierarchy](https://cloud.google.com/iam/docs/overview#policy_hierarchy).
      Example: `//cloudresourcemanager.googleapis.com/projects/my_project_123`
      For third-party assets, this field may be set differently.
    resourceUrl: The REST URL for accessing the resource. An HTTP `GET`
      request using this URL returns the resource itself. Example:
      `https://cloudresourcemanager.googleapis.com/v1/projects/my-project-123`
      This value is unspecified for resources without a REST API.
    version: The API version. Example: `v1`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DataValue(_messages.Message):
    r"""The content of the resource, in which some sensitive fields are
    removed and may not be present.

    Messages:
      AdditionalProperty: An additional property for a DataValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  data = _messages.MessageField('DataValue', 1)
  discoveryDocumentUri = _messages.StringField(2)
  discoveryName = _messages.StringField(3)
  location = _messages.StringField(4)
  parent = _messages.StringField(5)
  resourceUrl = _messages.StringField(6)
  version = _messages.StringField(7)


class ResourceSearchResult(_messages.Message):
  r"""A result of Resource Search, containing information of a cloud resource.
  Next ID: 31

  Messages:
    AdditionalAttributesValue: The additional searchable attributes of this
      resource. The attributes may vary from one resource type to another.
      Examples: `projectId` for Project, `dnsName` for DNS ManagedZone. This
      field contains a subset of the resource metadata fields that are
      returned by the List or Get APIs provided by the corresponding Google
      Cloud service (e.g., Compute Engine). see [API references and supported
      searchable attributes](https://cloud.google.com/asset-
      inventory/docs/supported-asset-types#searchable_asset_types) to see
      which fields are included. You can search values of these fields through
      free text search. However, you should not consume the field
      programically as the field names and values may change as the Google
      Cloud service updates to a new incompatible API version. To search
      against the `additional_attributes`: * Use a free text query to match
      the attributes values. Example: to search `additional_attributes = {
      dnsName: "foobar" }`, you can issue a query `foobar`.
    LabelsValue: Labels associated with this resource. See [Labelling and
      grouping Google Cloud
      resources](https://cloud.google.com/blog/products/gcp/labelling-and-
      grouping-your-google-cloud-platform-resources) for more information.
      This field is available only when the resource's Protobuf contains it.
      To search against the `labels`: * Use a field query: - query on any
      label's key or value. Example: `labels:prod` - query by a given label.
      Example: `labels.env:prod` - query by a given label's existence.
      Example: `labels.env:*` * Use a free text query. Example: `prod`
    RelationshipsValue: A map of related resources of this resource, keyed by
      the relationship type. A relationship type is in the format of
      {SourceType}_{ACTION}_{DestType}. Example: `DISK_TO_INSTANCE`,
      `DISK_TO_NETWORK`, `INSTANCE_TO_INSTANCEGROUP`. See [supported
      relationship types](https://cloud.google.com/asset-
      inventory/docs/supported-asset-types#supported_relationship_types).

  Fields:
    additionalAttributes: The additional searchable attributes of this
      resource. The attributes may vary from one resource type to another.
      Examples: `projectId` for Project, `dnsName` for DNS ManagedZone. This
      field contains a subset of the resource metadata fields that are
      returned by the List or Get APIs provided by the corresponding Google
      Cloud service (e.g., Compute Engine). see [API references and supported
      searchable attributes](https://cloud.google.com/asset-
      inventory/docs/supported-asset-types#searchable_asset_types) to see
      which fields are included. You can search values of these fields through
      free text search. However, you should not consume the field
      programically as the field names and values may change as the Google
      Cloud service updates to a new incompatible API version. To search
      against the `additional_attributes`: * Use a free text query to match
      the attributes values. Example: to search `additional_attributes = {
      dnsName: "foobar" }`, you can issue a query `foobar`.
    assetType: The type of this resource. Example:
      `compute.googleapis.com/Disk`. To search against the `asset_type`: *
      Specify the `asset_type` field in your search request.
    attachedResources: Attached resources of this resource. For example, an
      OSConfig Inventory is an attached resource of a Compute Instance. This
      field is repeated because a resource could have multiple attached
      resources. This `attached_resources` field is not searchable. Some
      attributes of the attached resources are exposed in
      `additional_attributes` field, so as to allow users to search on them.
    createTime: The create timestamp of this resource, at which the resource
      was created. The granularity is in seconds. Timestamp.nanos will always
      be 0. This field is available only when the resource's Protobuf contains
      it. To search against `create_time`: * Use a field query. - value in
      seconds since unix epoch. Example: `createTime > 1609459200` - value in
      date string. Example: `createTime > 2021-01-01` - value in date-time
      string (must be quoted). Example: `createTime > "2021-01-01T00:00:00"`
    description: One or more paragraphs of text description of this resource.
      Maximum length could be up to 1M bytes. This field is available only
      when the resource's Protobuf contains it. To search against the
      `description`: * Use a field query. Example: `description:"important
      instance"` * Use a free text query. Example: `"important instance"`
    displayName: The display name of this resource. This field is available
      only when the resource's Protobuf contains it. To search against the
      `display_name`: * Use a field query. Example: `displayName:"My
      Instance"` * Use a free text query. Example: `"My Instance"`
    folders: The folder(s) that this resource belongs to, in the form of
      folders/{FOLDER_NUMBER}. This field is available when the resource
      belongs to one or more folders. To search against `folders`: * Use a
      field query. Example: `folders:(123 OR 456)` * Use a free text query.
      Example: `123` * Specify the `scope` field as this folder in your search
      request.
    kmsKey: The Cloud KMS [CryptoKey](https://cloud.google.com/kms/docs/refere
      nce/rest/v1/projects.locations.keyRings.cryptoKeys) name or [CryptoKeyVe
      rsion](https://cloud.google.com/kms/docs/reference/rest/v1/projects.loca
      tions.keyRings.cryptoKeys.cryptoKeyVersions) name. This field only
      presents for the purpose of backward compatibility. Please use the
      `kms_keys` field to retrieve Cloud KMS key information. This field is
      available only when the resource's Protobuf contains it and will only be
      populated for [these resource types](https://cloud.google.com/asset-
      inventory/docs/legacy-field-
      names#resource_types_with_the_to_be_deprecated_kmskey_field) for
      backward compatible purposes. To search against the `kms_key`: * Use a
      field query. Example: `kmsKey:key` * Use a free text query. Example:
      `key`
    kmsKeys: The Cloud KMS [CryptoKey](https://cloud.google.com/kms/docs/refer
      ence/rest/v1/projects.locations.keyRings.cryptoKeys) names or [CryptoKey
      Version](https://cloud.google.com/kms/docs/reference/rest/v1/projects.lo
      cations.keyRings.cryptoKeys.cryptoKeyVersions) names. This field is
      available only when the resource's Protobuf contains it. To search
      against the `kms_keys`: * Use a field query. Example: `kmsKeys:key` *
      Use a free text query. Example: `key`
    labels: Labels associated with this resource. See [Labelling and grouping
      Google Cloud
      resources](https://cloud.google.com/blog/products/gcp/labelling-and-
      grouping-your-google-cloud-platform-resources) for more information.
      This field is available only when the resource's Protobuf contains it.
      To search against the `labels`: * Use a field query: - query on any
      label's key or value. Example: `labels:prod` - query by a given label.
      Example: `labels.env:prod` - query by a given label's existence.
      Example: `labels.env:*` * Use a free text query. Example: `prod`
    location: Location can be `global`, regional like `us-east1`, or zonal
      like `us-west1-b`. This field is available only when the resource's
      Protobuf contains it. To search against the `location`: * Use a field
      query. Example: `location:us-west*` * Use a free text query. Example:
      `us-west*`
    name: The full resource name of this resource. Example: `//compute.googlea
      pis.com/projects/my_project_123/zones/zone1/instances/instance1`. See
      [Cloud Asset Inventory Resource Name
      Format](https://cloud.google.com/asset-inventory/docs/resource-name-
      format) for more information. To search against the `name`: * Use a
      field query. Example: `name:instance1` * Use a free text query. Example:
      `instance1`
    networkTags: Network tags associated with this resource. Like labels,
      network tags are a type of annotations used to group Google Cloud
      resources. See [Labelling Google Cloud
      resources](https://cloud.google.com/blog/products/gcp/labelling-and-
      grouping-your-google-cloud-platform-resources) for more information.
      This field is available only when the resource's Protobuf contains it.
      To search against the `network_tags`: * Use a field query. Example:
      `networkTags:internal` * Use a free text query. Example: `internal`
    organization: The organization that this resource belongs to, in the form
      of organizations/{ORGANIZATION_NUMBER}. This field is available when the
      resource belongs to an organization. To search against `organization`: *
      Use a field query. Example: `organization:123` * Use a free text query.
      Example: `123` * Specify the `scope` field as this organization in your
      search request.
    parentAssetType: The type of this resource's immediate parent, if there is
      one. To search against the `parent_asset_type`: * Use a field query.
      Example: `parentAssetType:"cloudresourcemanager.googleapis.com/Project"`
      * Use a free text query. Example:
      `cloudresourcemanager.googleapis.com/Project`
    parentFullResourceName: The full resource name of this resource's parent,
      if it has one. To search against the `parent_full_resource_name`: * Use
      a field query. Example: `parentFullResourceName:"project-name"` * Use a
      free text query. Example: `project-name`
    project: The project that this resource belongs to, in the form of
      projects/{PROJECT_NUMBER}. This field is available when the resource
      belongs to a project. To search against `project`: * Use a field query.
      Example: `project:12345` * Use a free text query. Example: `12345` *
      Specify the `scope` field as this project in your search request.
    relationships: A map of related resources of this resource, keyed by the
      relationship type. A relationship type is in the format of
      {SourceType}_{ACTION}_{DestType}. Example: `DISK_TO_INSTANCE`,
      `DISK_TO_NETWORK`, `INSTANCE_TO_INSTANCEGROUP`. See [supported
      relationship types](https://cloud.google.com/asset-
      inventory/docs/supported-asset-types#supported_relationship_types).
    state: The state of this resource. Different resources types have
      different state definitions that are mapped from various fields of
      different resource types. This field is available only when the
      resource's Protobuf contains it. Example: If the resource is an instance
      provided by Compute Engine, its state will include PROVISIONING,
      STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and
      TERMINATED. See `status` definition in [API Reference](https://cloud.goo
      gle.com/compute/docs/reference/rest/v1/instances). If the resource is a
      project provided by Resource Manager, its state will include
      LIFECYCLE_STATE_UNSPECIFIED, ACTIVE, DELETE_REQUESTED and
      DELETE_IN_PROGRESS. See `lifecycleState` definition in [API
      Reference](https://cloud.google.com/resource-
      manager/reference/rest/v1/projects). To search against the `state`: *
      Use a field query. Example: `state:RUNNING` * Use a free text query.
      Example: `RUNNING`
    tagKeys: TagKey namespaced names, in the format of
      {ORG_ID}/{TAG_KEY_SHORT_NAME}. To search against the `tagKeys`: * Use a
      field query. Example: - `tagKeys:"123456789/env*"` -
      `tagKeys="123456789/env"` - `tagKeys:"env"` * Use a free text query.
      Example: - `env`
    tagValueIds: TagValue IDs, in the format of tagValues/{TAG_VALUE_ID}. To
      search against the `tagValueIds`: * Use a field query. Example: -
      `tagValueIds:"456"` - `tagValueIds="tagValues/456"` * Use a free text
      query. Example: - `456`
    tagValues: TagValue namespaced names, in the format of
      {ORG_ID}/{TAG_KEY_SHORT_NAME}/{TAG_VALUE_SHORT_NAME}. To search against
      the `tagValues`: * Use a field query. Example: - `tagValues:"env"` -
      `tagValues:"env/prod"` - `tagValues:"123456789/env/prod*"` -
      `tagValues="123456789/env/prod"` * Use a free text query. Example: -
      `prod`
    updateTime: The last update timestamp of this resource, at which the
      resource was last modified or deleted. The granularity is in seconds.
      Timestamp.nanos will always be 0. This field is available only when the
      resource's Protobuf contains it. To search against `update_time`: * Use
      a field query. - value in seconds since unix epoch. Example: `updateTime
      < 1609459200` - value in date string. Example: `updateTime < 2021-01-01`
      - value in date-time string (must be quoted). Example: `updateTime <
      "2021-01-01T00:00:00"`
    versionedResources: Versioned resource representations of this resource.
      This is repeated because there could be multiple versions of resource
      representations during version migration. This `versioned_resources`
      field is not searchable. Some attributes of the resource representations
      are exposed in `additional_attributes` field, so as to allow users to
      search on them.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalAttributesValue(_messages.Message):
    r"""The additional searchable attributes of this resource. The attributes
    may vary from one resource type to another. Examples: `projectId` for
    Project, `dnsName` for DNS ManagedZone. This field contains a subset of
    the resource metadata fields that are returned by the List or Get APIs
    provided by the corresponding Google Cloud service (e.g., Compute Engine).
    see [API references and supported searchable
    attributes](https://cloud.google.com/asset-inventory/docs/supported-asset-
    types#searchable_asset_types) to see which fields are included. You can
    search values of these fields through free text search. However, you
    should not consume the field programically as the field names and values
    may change as the Google Cloud service updates to a new incompatible API
    version. To search against the `additional_attributes`: * Use a free text
    query to match the attributes values. Example: to search
    `additional_attributes = { dnsName: "foobar" }`, you can issue a query
    `foobar`.

    Messages:
      AdditionalProperty: An additional property for a
        AdditionalAttributesValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalAttributesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels associated with this resource. See [Labelling and grouping
    Google Cloud
    resources](https://cloud.google.com/blog/products/gcp/labelling-and-
    grouping-your-google-cloud-platform-resources) for more information. This
    field is available only when the resource's Protobuf contains it. To
    search against the `labels`: * Use a field query: - query on any label's
    key or value. Example: `labels:prod` - query by a given label. Example:
    `labels.env:prod` - query by a given label's existence. Example:
    `labels.env:*` * Use a free text query. Example: `prod`

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RelationshipsValue(_messages.Message):
    r"""A map of related resources of this resource, keyed by the relationship
    type. A relationship type is in the format of
    {SourceType}_{ACTION}_{DestType}. Example: `DISK_TO_INSTANCE`,
    `DISK_TO_NETWORK`, `INSTANCE_TO_INSTANCEGROUP`. See [supported
    relationship types](https://cloud.google.com/asset-
    inventory/docs/supported-asset-types#supported_relationship_types).

    Messages:
      AdditionalProperty: An additional property for a RelationshipsValue
        object.

    Fields:
      additionalProperties: Additional properties of type RelationshipsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RelationshipsValue object.

      Fields:
        key: Name of the additional property.
        value: A RelatedResources attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('RelatedResources', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalAttributes = _messages.MessageField('AdditionalAttributesValue', 1)
  assetType = _messages.StringField(2)
  attachedResources = _messages.MessageField('AttachedResource', 3, repeated=True)
  createTime = _messages.StringField(4)
  description = _messages.StringField(5)
  displayName = _messages.StringField(6)
  folders = _messages.StringField(7, repeated=True)
  kmsKey = _messages.StringField(8)
  kmsKeys = _messages.StringField(9, repeated=True)
  labels = _messages.MessageField('LabelsValue', 10)
  location = _messages.StringField(11)
  name = _messages.StringField(12)
  networkTags = _messages.StringField(13, repeated=True)
  organization = _messages.StringField(14)
  parentAssetType = _messages.StringField(15)
  parentFullResourceName = _messages.StringField(16)
  project = _messages.StringField(17)
  relationships = _messages.MessageField('RelationshipsValue', 18)
  state = _messages.StringField(19)
  tagKeys = _messages.StringField(20, repeated=True)
  tagValueIds = _messages.StringField(21, repeated=True)
  tagValues = _messages.StringField(22, repeated=True)
  updateTime = _messages.StringField(23)
  versionedResources = _messages.MessageField('VersionedResource', 24, repeated=True)


class ResourceSelector(_messages.Message):
  r"""Specifies the resource to analyze for access policies, which may be set
  directly on the resource, or on ancestors such as organizations, folders or
  projects.

  Fields:
    fullResourceName: Required. The [full resource name]
      (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
      a resource of [supported resource types](https://cloud.google.com/asset-
      inventory/docs/supported-asset-types#analyzable_asset_types).
  """

  fullResourceName = _messages.StringField(1)


class SavedQuery(_messages.Message):
  r"""A saved query which can be shared with others or used later.

  Messages:
    LabelsValue: Labels applied on the resource. This value should not contain
      more than 10 entries. The key and value of each entry must be non-empty
      and fewer than 64 characters.

  Fields:
    content: The query content.
    createTime: Output only. The create time of this saved query.
    creator: Output only. The account's email address who has created this
      saved query.
    description: The description of this saved query. This value should be
      fewer than 255 characters.
    labels: Labels applied on the resource. This value should not contain more
      than 10 entries. The key and value of each entry must be non-empty and
      fewer than 64 characters.
    lastUpdateTime: Output only. The last update time of this saved query.
    lastUpdater: Output only. The account's email address who has updated this
      saved query most recently.
    name: The resource name of the saved query. The format must be: *
      projects/project_number/savedQueries/saved_query_id *
      folders/folder_number/savedQueries/saved_query_id *
      organizations/organization_number/savedQueries/saved_query_id
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels applied on the resource. This value should not contain more
    than 10 entries. The key and value of each entry must be non-empty and
    fewer than 64 characters.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  content = _messages.MessageField('QueryContent', 1)
  createTime = _messages.StringField(2)
  creator = _messages.StringField(3)
  description = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  lastUpdateTime = _messages.StringField(6)
  lastUpdater = _messages.StringField(7)
  name = _messages.StringField(8)


class SearchAllIamPoliciesResponse(_messages.Message):
  r"""Search all IAM policies response.

  Fields:
    nextPageToken: Set if there are more results than those appearing in this
      response; to get the next set of results, call this method again, using
      this value as the `page_token`.
    results: A list of IAM policies that match the search query. Related
      information such as the associated resource is returned along with the
      policy.
  """

  nextPageToken = _messages.StringField(1)
  results = _messages.MessageField('IamPolicySearchResult', 2, repeated=True)


class SearchAllResourcesResponse(_messages.Message):
  r"""Search all resources response.

  Fields:
    nextPageToken: If there are more results than those appearing in this
      response, then `next_page_token` is included. To get the next set of
      results, call this method again using the value of `next_page_token` as
      `page_token`.
    results: A list of Resources that match the search query. It contains the
      resource standard metadata information.
  """

  nextPageToken = _messages.StringField(1)
  results = _messages.MessageField('ResourceSearchResult', 2, repeated=True)


class SoftwarePackage(_messages.Message):
  r"""Software package information of the operating system.

  Fields:
    aptPackage: Details of an APT package. For details about the apt package
      manager, see https://wiki.debian.org/Apt.
    cosPackage: Details of a COS package.
    googetPackage: Details of a Googet package. For details about the googet
      package manager, see https://github.com/google/googet.
    qfePackage: Details of a Windows Quick Fix engineering package. See
      https://docs.microsoft.com/en-
      us/windows/win32/cimwin32prov/win32-quickfixengineering for info in
      Windows Quick Fix Engineering.
    windowsApplication: Details of Windows Application.
    wuaPackage: Details of a Windows Update package. See
      https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for information
      about Windows Update.
    yumPackage: Yum package info. For details about the yum package manager,
      see https://access.redhat.com/documentation/en-
      us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
    zypperPackage: Details of a Zypper package. For details about the Zypper
      package manager, see https://en.opensuse.org/SDB:Zypper_manual.
    zypperPatch: Details of a Zypper patch. For details about the Zypper
      package manager, see https://en.opensuse.org/SDB:Zypper_manual.
  """

  aptPackage = _messages.MessageField('VersionedPackage', 1)
  cosPackage = _messages.MessageField('VersionedPackage', 2)
  googetPackage = _messages.MessageField('VersionedPackage', 3)
  qfePackage = _messages.MessageField('WindowsQuickFixEngineeringPackage', 4)
  windowsApplication = _messages.MessageField('WindowsApplication', 5)
  wuaPackage = _messages.MessageField('WindowsUpdatePackage', 6)
  yumPackage = _messages.MessageField('VersionedPackage', 7)
  zypperPackage = _messages.MessageField('VersionedPackage', 8)
  zypperPatch = _messages.MessageField('ZypperPatch', 9)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TableFieldSchema(_messages.Message):
  r"""A field in TableSchema.

  Fields:
    field: The field name. The name must contain only letters (a-z, A-Z),
      numbers (0-9), or underscores (_), and must start with a letter or
      underscore. The maximum length is 128 characters.
    fields: Describes the nested schema fields if the type property is set to
      RECORD.
    mode: The field mode. Possible values include NULLABLE, REQUIRED and
      REPEATED. The default value is NULLABLE.
    type: The field data type. Possible values include * STRING * BYTES *
      INTEGER * FLOAT * BOOLEAN * TIMESTAMP * DATE * TIME * DATETIME *
      GEOGRAPHY, * NUMERIC, * BIGNUMERIC, * RECORD (where RECORD indicates
      that the field contains a nested schema).
  """

  field = _messages.StringField(1)
  fields = _messages.MessageField('TableFieldSchema', 2, repeated=True)
  mode = _messages.StringField(3)
  type = _messages.StringField(4)


class TableSchema(_messages.Message):
  r"""BigQuery Compatible table schema.

  Fields:
    fields: Describes the fields in a table.
  """

  fields = _messages.MessageField('TableFieldSchema', 1, repeated=True)


class TemporalAsset(_messages.Message):
  r"""An asset in Google Cloud and its temporal metadata, including the time
  window when it was observed and its status during that window.

  Enums:
    PriorAssetStateValueValuesEnum: State of prior_asset.

  Fields:
    asset: An asset in Google Cloud.
    deleted: Whether the asset has been deleted or not.
    priorAsset: Prior copy of the asset. Populated if prior_asset_state is
      PRESENT. Currently this is only set for responses in Real-Time Feed.
    priorAssetState: State of prior_asset.
    window: The time window when the asset data and state was observed.
  """

  class PriorAssetStateValueValuesEnum(_messages.Enum):
    r"""State of prior_asset.

    Values:
      PRIOR_ASSET_STATE_UNSPECIFIED: prior_asset is not applicable for the
        current asset.
      PRESENT: prior_asset is populated correctly.
      INVALID: Failed to set prior_asset.
      DOES_NOT_EXIST: Current asset is the first known state.
      DELETED: prior_asset is a deletion.
    """
    PRIOR_ASSET_STATE_UNSPECIFIED = 0
    PRESENT = 1
    INVALID = 2
    DOES_NOT_EXIST = 3
    DELETED = 4

  asset = _messages.MessageField('Asset', 1)
  deleted = _messages.BooleanField(2)
  priorAsset = _messages.MessageField('Asset', 3)
  priorAssetState = _messages.EnumField('PriorAssetStateValueValuesEnum', 4)
  window = _messages.MessageField('TimeWindow', 5)


class TimeWindow(_messages.Message):
  r"""A time window specified by its `start_time` and `end_time`.

  Fields:
    endTime: End time of the time window (inclusive). If not specified, the
      current timestamp is used instead.
    startTime: Start time of the time window (exclusive).
  """

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class UpdateFeedRequest(_messages.Message):
  r"""Update asset feed request.

  Fields:
    feed: Required. The new values of feed details. It must match an existing
      feed and the field `name` must be in the format of:
      projects/project_number/feeds/feed_id or
      folders/folder_number/feeds/feed_id or
      organizations/organization_number/feeds/feed_id.
    updateMask: Required. Only updates the `feed` fields indicated by this
      mask. The field mask must not be empty, and it must not contain fields
      that are immutable or only set by the server.
  """

  feed = _messages.MessageField('Feed', 1)
  updateMask = _messages.StringField(2)


class VersionedPackage(_messages.Message):
  r"""Information related to the a standard versioned package. This includes
  package info for APT, Yum, Zypper, and Googet package managers.

  Fields:
    architecture: The system architecture this package is intended for.
    packageName: The name of the package.
    version: The version of the package.
  """

  architecture = _messages.StringField(1)
  packageName = _messages.StringField(2)
  version = _messages.StringField(3)


class VersionedResource(_messages.Message):
  r"""Resource representation as defined by the corresponding service
  providing the resource for a given API version.

  Messages:
    ResourceValue: JSON representation of the resource as defined by the
      corresponding service providing this resource. Example: If the resource
      is an instance provided by Compute Engine, this field will contain the
      JSON representation of the instance as defined by Compute Engine:
      `https://cloud.google.com/compute/docs/reference/rest/v1/instances`. You
      can find the resource definition for each supported resource type in
      this table: `https://cloud.google.com/asset-inventory/docs/supported-
      asset-types#searchable_asset_types`

  Fields:
    resource: JSON representation of the resource as defined by the
      corresponding service providing this resource. Example: If the resource
      is an instance provided by Compute Engine, this field will contain the
      JSON representation of the instance as defined by Compute Engine:
      `https://cloud.google.com/compute/docs/reference/rest/v1/instances`. You
      can find the resource definition for each supported resource type in
      this table: `https://cloud.google.com/asset-inventory/docs/supported-
      asset-types#searchable_asset_types`
    version: API version of the resource. Example: If the resource is an
      instance provided by Compute Engine v1 API as defined in
      `https://cloud.google.com/compute/docs/reference/rest/v1/instances`,
      version will be "v1".
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResourceValue(_messages.Message):
    r"""JSON representation of the resource as defined by the corresponding
    service providing this resource. Example: If the resource is an instance
    provided by Compute Engine, this field will contain the JSON
    representation of the instance as defined by Compute Engine:
    `https://cloud.google.com/compute/docs/reference/rest/v1/instances`. You
    can find the resource definition for each supported resource type in this
    table: `https://cloud.google.com/asset-inventory/docs/supported-asset-
    types#searchable_asset_types`

    Messages:
      AdditionalProperty: An additional property for a ResourceValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResourceValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  resource = _messages.MessageField('ResourceValue', 1)
  version = _messages.StringField(2)


class WindowsApplication(_messages.Message):
  r"""Contains information about a Windows application that is retrieved from
  the Windows Registry. For more information about these fields, see:
  https://docs.microsoft.com/en-us/windows/win32/msi/uninstall-registry-key

  Fields:
    displayName: The name of the application or product.
    displayVersion: The version of the product or application in string
      format.
    helpLink: The internet address for technical support.
    installDate: The last time this product received service. The value of
      this property is replaced each time a patch is applied or removed from
      the product or the command-line option is used to repair the product.
    publisher: The name of the manufacturer for the product or application.
  """

  displayName = _messages.StringField(1)
  displayVersion = _messages.StringField(2)
  helpLink = _messages.StringField(3)
  installDate = _messages.MessageField('Date', 4)
  publisher = _messages.StringField(5)


class WindowsQuickFixEngineeringPackage(_messages.Message):
  r"""Information related to a Quick Fix Engineering package. Fields are taken
  from Windows QuickFixEngineering Interface and match the source names:
  https://docs.microsoft.com/en-
  us/windows/win32/cimwin32prov/win32-quickfixengineering

  Fields:
    caption: A short textual description of the QFE update.
    description: A textual description of the QFE update.
    hotFixId: Unique identifier associated with a particular QFE update.
    installTime: Date that the QFE update was installed. Mapped from
      installed_on field.
  """

  caption = _messages.StringField(1)
  description = _messages.StringField(2)
  hotFixId = _messages.StringField(3)
  installTime = _messages.StringField(4)


class WindowsUpdateCategory(_messages.Message):
  r"""Categories specified by the Windows Update.

  Fields:
    id: The identifier of the windows update category.
    name: The name of the windows update category.
  """

  id = _messages.StringField(1)
  name = _messages.StringField(2)


class WindowsUpdatePackage(_messages.Message):
  r"""Details related to a Windows Update package. Field data and names are
  taken from Windows Update API IUpdate Interface:
  https://docs.microsoft.com/en-us/windows/win32/api/_wua/ Descriptive fields
  like title, and description are localized based on the locale of the VM
  being updated.

  Fields:
    categories: The categories that are associated with this update package.
    description: The localized description of the update package.
    kbArticleIds: A collection of Microsoft Knowledge Base article IDs that
      are associated with the update package.
    lastDeploymentChangeTime: The last published date of the update, in (UTC)
      date and time.
    moreInfoUrls: A collection of URLs that provide more information about the
      update package.
    revisionNumber: The revision number of this update package.
    supportUrl: A hyperlink to the language-specific support information for
      the update.
    title: The localized title of the update package.
    updateId: Gets the identifier of an update package. Stays the same across
      revisions.
  """

  categories = _messages.MessageField('WindowsUpdateCategory', 1, repeated=True)
  description = _messages.StringField(2)
  kbArticleIds = _messages.StringField(3, repeated=True)
  lastDeploymentChangeTime = _messages.StringField(4)
  moreInfoUrls = _messages.StringField(5, repeated=True)
  revisionNumber = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  supportUrl = _messages.StringField(7)
  title = _messages.StringField(8)
  updateId = _messages.StringField(9)


class ZypperPatch(_messages.Message):
  r"""Details related to a Zypper Patch.

  Fields:
    category: The category of the patch.
    patchName: The name of the patch.
    severity: The severity specified for this patch
    summary: Any summary information provided about this patch.
  """

  category = _messages.StringField(1)
  patchName = _messages.StringField(2)
  severity = _messages.StringField(3)
  summary = _messages.StringField(4)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
