"""Generated message classes for datapipelines version v1.

Data Pipelines provides an interface for creating, updating, and managing
recurring Data Analytics jobs.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'datapipelines'


class DatapipelinesProjectsLocationsComputeSchemaRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsComputeSchemaRequest object.

  Fields:
    googleCloudDatapipelinesV1ComputeSchemaRequest: A
      GoogleCloudDatapipelinesV1ComputeSchemaRequest resource to be passed as
      the request body.
    location: Required. The full location formatted as "projects/{your-
      project}/locations/{google-cloud-region}". If attempting to infer the
      schema from an existing Google Cloud resource, the default Data
      Pipelines service account for this project will be used in making
      requests for the resource. If the region given for "{google-cloud-
      region}" is different than the region where the resource is stored, then
      the data will be transferred to and processed in the region specified
      here, but it will not be persistently stored in this region.
  """

  googleCloudDatapipelinesV1ComputeSchemaRequest = _messages.MessageField('GoogleCloudDatapipelinesV1ComputeSchemaRequest', 1)
  location = _messages.StringField(2, required=True)


class DatapipelinesProjectsLocationsListPipelinesRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsListPipelinesRequest object.

  Fields:
    filter: An expression for filtering the results of the request. If
      unspecified, all pipelines will be returned. Multiple filters can be
      applied and must be comma separated. Fields eligible for filtering are:
      + `type`: The type of the pipeline (streaming or batch). Allowed values
      are `ALL`, `BATCH`, and `STREAMING`. + `status`: The activity status of
      the pipeline. Allowed values are `ALL`, `ACTIVE`, `ARCHIVED`, and
      `PAUSED`. For example, to limit results to active batch processing
      pipelines: type:BATCH,status:ACTIVE
    pageSize: The maximum number of entities to return. The service may return
      fewer than this value, even if there are additional pages. If
      unspecified, the max limit is yet to be determined by the backend
      implementation.
    pageToken: A page token, received from a previous `ListPipelines` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListPipelines` must match the call that provided
      the page token.
    parent: Required. The location name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID`.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DatapipelinesProjectsLocationsPipelinesCreateRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsPipelinesCreateRequest object.

  Fields:
    googleCloudDatapipelinesV1Pipeline: A GoogleCloudDatapipelinesV1Pipeline
      resource to be passed as the request body.
    parent: Required. The location name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID`.
  """

  googleCloudDatapipelinesV1Pipeline = _messages.MessageField('GoogleCloudDatapipelinesV1Pipeline', 1)
  parent = _messages.StringField(2, required=True)


class DatapipelinesProjectsLocationsPipelinesDeleteRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsPipelinesDeleteRequest object.

  Fields:
    name: Required. The pipeline name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID`.
  """

  name = _messages.StringField(1, required=True)


class DatapipelinesProjectsLocationsPipelinesGetRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsPipelinesGetRequest object.

  Fields:
    name: Required. The pipeline name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID`.
  """

  name = _messages.StringField(1, required=True)


class DatapipelinesProjectsLocationsPipelinesJobsListRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsPipelinesJobsListRequest object.

  Fields:
    pageSize: The maximum number of entities to return. The service may return
      fewer than this value, even if there are additional pages. If
      unspecified, the max limit will be determined by the backend
      implementation.
    pageToken: A page token, received from a previous `ListJobs` call. Provide
      this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListJobs` must match the call that provided the
      page token.
    parent: Required. The pipeline name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatapipelinesProjectsLocationsPipelinesPatchRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsPipelinesPatchRequest object.

  Fields:
    googleCloudDatapipelinesV1Pipeline: A GoogleCloudDatapipelinesV1Pipeline
      resource to be passed as the request body.
    name: The pipeline name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID`. *
      `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]), hyphens
      (-), colons (:), and periods (.). For more information, see [Identifying
      projects](https://cloud.google.com/resource-manager/docs/creating-
      managing-projects#identifying_projects). * `LOCATION_ID` is the
      canonical ID for the pipeline's location. The list of available
      locations can be obtained by calling
      `google.cloud.location.Locations.ListLocations`. Note that the Data
      Pipelines service is not available in all regions. It depends on Cloud
      Scheduler, an App Engine application, so it's only available in [App
      Engine regions](https://cloud.google.com/about/locations#region). *
      `PIPELINE_ID` is the ID of the pipeline. Must be unique for the selected
      project and location.
    updateMask: The list of fields to be updated.
  """

  googleCloudDatapipelinesV1Pipeline = _messages.MessageField('GoogleCloudDatapipelinesV1Pipeline', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatapipelinesProjectsLocationsPipelinesRunRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsPipelinesRunRequest object.

  Fields:
    googleCloudDatapipelinesV1RunPipelineRequest: A
      GoogleCloudDatapipelinesV1RunPipelineRequest resource to be passed as
      the request body.
    name: Required. The pipeline name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID`.
  """

  googleCloudDatapipelinesV1RunPipelineRequest = _messages.MessageField('GoogleCloudDatapipelinesV1RunPipelineRequest', 1)
  name = _messages.StringField(2, required=True)


class DatapipelinesProjectsLocationsPipelinesStopRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsPipelinesStopRequest object.

  Fields:
    googleCloudDatapipelinesV1StopPipelineRequest: A
      GoogleCloudDatapipelinesV1StopPipelineRequest resource to be passed as
      the request body.
    name: Required. The pipeline name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID`.
  """

  googleCloudDatapipelinesV1StopPipelineRequest = _messages.MessageField('GoogleCloudDatapipelinesV1StopPipelineRequest', 1)
  name = _messages.StringField(2, required=True)


class DatapipelinesProjectsLocationsTransformDescriptionsBatchGetRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsTransformDescriptionsBatchGetRequest
  object.

  Fields:
    names: Optional. The names of the transform descriptions being retrieved,
      formatted as "projects/{project}/locations/{location}/transformdescripti
      ons/{transform_description}". If no name is provided, all of the
      transform descriptions will be returned.
    parent: Required. The project and location shared by all transform
      descriptions being retrieved, formatted as
      "projects/{project}/locations/{location}".
  """

  names = _messages.StringField(1, repeated=True)
  parent = _messages.StringField(2, required=True)


class DatapipelinesProjectsLocationsTransformDescriptionsGetRequest(_messages.Message):
  r"""A DatapipelinesProjectsLocationsTransformDescriptionsGetRequest object.

  Fields:
    name: Required. The full name formatted as "projects/{your-
      project}/locations/{google-cloud-region}/transformdescriptions/{uniform-
      resource-name}".
  """

  name = _messages.StringField(1, required=True)


class GoogleCloudDatapipelinesV1ArrayValue(_messages.Message):
  r"""Represents an array of values. The elements can be of any type.

  Fields:
    elements: The elements of the array.
  """

  elements = _messages.MessageField('GoogleCloudDatapipelinesV1FieldValue', 1, repeated=True)


class GoogleCloudDatapipelinesV1AtomicValue(_messages.Message):
  r"""Represents a non-dividable value.

  Fields:
    booleanValue: A boolean value.
    byteValue: An 8-bit signed value.
    bytesValue: An array of raw bytes.
    datetimeValue: A datetime value.
    decimalValue: A large decimal value, equivalent to Java BigDecimal.
    doubleValue: A 64-bit floating point value.
    floatValue: A 32-bit floating point value.
    int16Value: A 16-bit signed value.
    int32Value: A 32-bit signed value.
    int64Value: A 64-bit signed value.
    stringValue: A string value.
  """

  booleanValue = _messages.BooleanField(1)
  byteValue = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  bytesValue = _messages.BytesField(3)
  datetimeValue = _messages.MessageField('GoogleTypeDateTime', 4)
  decimalValue = _messages.MessageField('GoogleTypeDecimal', 5)
  doubleValue = _messages.FloatField(6)
  floatValue = _messages.FloatField(7, variant=_messages.Variant.FLOAT)
  int16Value = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  int32Value = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  int64Value = _messages.IntegerField(10)
  stringValue = _messages.StringField(11)


class GoogleCloudDatapipelinesV1BatchGetTransformDescriptionsResponse(_messages.Message):
  r"""Response message for BatchGetTransformDescriptions

  Fields:
    transformDescriptions: List of requested transform descriptions.
  """

  transformDescriptions = _messages.MessageField('GoogleCloudDatapipelinesV1TransformDescription', 1, repeated=True)


class GoogleCloudDatapipelinesV1ComputeSchemaRequest(_messages.Message):
  r"""Request message for ComputeSchema

  Fields:
    config: Required. The configuration for the transform. If this is not a
      source, then each input with its schema must be set. It is not required
      to have any outputs set.
    inputSchemas: Optional. In relation to the full pipeline graph, the
      schemas of the transforms that are used as inputs to the one for
      `config`. If `config` represents a transform for reading from some
      resource, then this should be empty. For all other transforms, at least
      one value must be provided.
    rawSchema: Optional. If set, this will use the provided raw schema to
      compute the schema rather than connecting to any resources. Validation
      will still occur to make sure it is compatible with all input schemas.
      If the transform is an IO, the IO must support that schema type.
  """

  config = _messages.MessageField('GoogleCloudDatapipelinesV1ConfiguredTransform', 1)
  inputSchemas = _messages.MessageField('GoogleCloudDatapipelinesV1Schema', 2, repeated=True)
  rawSchema = _messages.MessageField('GoogleCloudDatapipelinesV1RawSchemaInfo', 3)


class GoogleCloudDatapipelinesV1ConfiguredTransform(_messages.Message):
  r"""A fully configured transform that can be validated.

  Fields:
    config: Configuration values provided. These must match the schema
      provided in the row's schema.
    uniformResourceName: Unique resource name of the transform. This should be
      the same as the equivalent `TransformDescription` value.
  """

  config = _messages.MessageField('GoogleCloudDatapipelinesV1Row', 1)
  uniformResourceName = _messages.StringField(2)


class GoogleCloudDatapipelinesV1DataflowJobDetails(_messages.Message):
  r"""Pipeline job details specific to the Dataflow API. This is encapsulated
  here to allow for more executors to store their specific details separately.

  Messages:
    ResourceInfoValue: Cached version of all the metrics of interest for the
      job. This value gets stored here when the job is terminated. As long as
      the job is running, this field is populated from the Dataflow API.

  Fields:
    currentWorkers: Output only. The current number of workers used to run the
      jobs. Only set to a value if the job is still running.
    resourceInfo: Cached version of all the metrics of interest for the job.
      This value gets stored here when the job is terminated. As long as the
      job is running, this field is populated from the Dataflow API.
    sdkVersion: Output only. The SDK version used to run the job.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResourceInfoValue(_messages.Message):
    r"""Cached version of all the metrics of interest for the job. This value
    gets stored here when the job is terminated. As long as the job is
    running, this field is populated from the Dataflow API.

    Messages:
      AdditionalProperty: An additional property for a ResourceInfoValue
        object.

    Fields:
      additionalProperties: Additional properties of type ResourceInfoValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResourceInfoValue object.

      Fields:
        key: Name of the additional property.
        value: A number attribute.
      """

      key = _messages.StringField(1)
      value = _messages.FloatField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  currentWorkers = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resourceInfo = _messages.MessageField('ResourceInfoValue', 2)
  sdkVersion = _messages.MessageField('GoogleCloudDatapipelinesV1SdkVersion', 3)


class GoogleCloudDatapipelinesV1EnumerationValue(_messages.Message):
  r"""Represents a selected value from an EnumerationType.

  Fields:
    name: Name of the enum option.
  """

  name = _messages.StringField(1)


class GoogleCloudDatapipelinesV1Field(_messages.Message):
  r"""Info for a single field in the schema.

  Fields:
    name: Name of the field.
    type: Type info for the field.
  """

  name = _messages.StringField(1)
  type = _messages.MessageField('GoogleCloudDatapipelinesV1FieldType', 2)


class GoogleCloudDatapipelinesV1FieldType(_messages.Message):
  r"""Type info about a field.

  Enums:
    TypeValueValuesEnum: Specific type of the field. For non-atomic types, the
      corresponding type info for that non-atomic must be set.

  Fields:
    collectionElementType: If `type` is an array or iterable, this is the type
      contained in that array or iterable.
    logicalType: If `type` is a logical type, this is the info for the
      specific logical type.
    mapType: If `type` is a map, this is the key and value types for that map.
    nullable: Whether or not this field is nullable.
    rowSchema: If `type` is a row, this is the schema of that row.
    type: Specific type of the field. For non-atomic types, the corresponding
      type info for that non-atomic must be set.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Specific type of the field. For non-atomic types, the corresponding
    type info for that non-atomic must be set.

    Values:
      TYPE_NAME_UNSPECIFIED: Type name is not set (generally an error)
      TYPE_NAME_BYTE: 8-bit signed integer
      TYPE_NAME_INT16: 16-bit signed integer
      TYPE_NAME_INT32: 32-bit signed integer
      TYPE_NAME_INT64: 64-bit signed integer
      TYPE_NAME_DECIMAL: Large decimal type (equivalent to Java BigDecimal)
      TYPE_NAME_FLOAT: 32-bit floating point integer
      TYPE_NAME_DOUBLE: 64-bit floating point integer
      TYPE_NAME_STRING: String
      TYPE_NAME_DATETIME: Datetime
      TYPE_NAME_BOOLEAN: Bool
      TYPE_NAME_BYTES: Convenience for an ARRAY of BYTE values
      TYPE_NAME_ARRAY: Array of some other values.
      TYPE_NAME_ITERABLE: Iterable of some other values.
      TYPE_NAME_MAP: Key/Value mapping between values.
      TYPE_NAME_ROW: Struct that follows a particular schema
      TYPE_NAME_LOGICAL_TYPE: Beam logical type
    """
    TYPE_NAME_UNSPECIFIED = 0
    TYPE_NAME_BYTE = 1
    TYPE_NAME_INT16 = 2
    TYPE_NAME_INT32 = 3
    TYPE_NAME_INT64 = 4
    TYPE_NAME_DECIMAL = 5
    TYPE_NAME_FLOAT = 6
    TYPE_NAME_DOUBLE = 7
    TYPE_NAME_STRING = 8
    TYPE_NAME_DATETIME = 9
    TYPE_NAME_BOOLEAN = 10
    TYPE_NAME_BYTES = 11
    TYPE_NAME_ARRAY = 12
    TYPE_NAME_ITERABLE = 13
    TYPE_NAME_MAP = 14
    TYPE_NAME_ROW = 15
    TYPE_NAME_LOGICAL_TYPE = 16

  collectionElementType = _messages.MessageField('GoogleCloudDatapipelinesV1FieldType', 1)
  logicalType = _messages.MessageField('GoogleCloudDatapipelinesV1LogicalType', 2)
  mapType = _messages.MessageField('GoogleCloudDatapipelinesV1MapType', 3)
  nullable = _messages.BooleanField(4)
  rowSchema = _messages.MessageField('GoogleCloudDatapipelinesV1Schema', 5)
  type = _messages.EnumField('TypeValueValuesEnum', 6)


class GoogleCloudDatapipelinesV1FieldValue(_messages.Message):
  r"""A single value in a row. The value set must correspond to the correct
  type from the row's schema.

  Fields:
    arrayValue: The array value of this field. Corresponds to TYPE_NAME_ARRAY
      in the schema.
    atomicValue: The atomic value of this field. Must correspond to the
      correct atomic type in the schema.
    enumValue: The enum value of this field. Corresponds to
      TYPE_NAME_LOGICAL_TYPE in the schema if that logical type represents an
      `EnumerationType` type.
    fixedBytesValue: The fixed-length byte collection of this field.
      Corresponds to TYPE_NAME_LOGICAL_TYPE in the schema if that logical type
      represents a `FixedBytes` type.
    iterableValue: The iterable value of this field. Corresponds to
      TYPE_NAME_ITERABLE in the schema.
    mapValue: The map value of this field. Corresponds to TYPE_NAME_MAP in the
      schema.
    rowValue: The row value of this field. Corresponds to TYPE_NAME_ROW in the
      schema. This row also holds to its own schema.
  """

  arrayValue = _messages.MessageField('GoogleCloudDatapipelinesV1ArrayValue', 1)
  atomicValue = _messages.MessageField('GoogleCloudDatapipelinesV1AtomicValue', 2)
  enumValue = _messages.MessageField('GoogleCloudDatapipelinesV1EnumerationValue', 3)
  fixedBytesValue = _messages.MessageField('GoogleCloudDatapipelinesV1FixedBytesValue', 4)
  iterableValue = _messages.MessageField('GoogleCloudDatapipelinesV1IterableValue', 5)
  mapValue = _messages.MessageField('GoogleCloudDatapipelinesV1MapValue', 6)
  rowValue = _messages.MessageField('GoogleCloudDatapipelinesV1Row', 7)


class GoogleCloudDatapipelinesV1FixedBytesValue(_messages.Message):
  r"""Represents a collection of bytes whose size is the same as the
  associated FixedBytes size value.

  Fields:
    value: The raw bytes. It must be exactly the size specified in the schema.
  """

  value = _messages.BytesField(1)


class GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironment(_messages.Message):
  r"""The environment values to be set at runtime for a Flex Template.

  Enums:
    FlexrsGoalValueValuesEnum: Set FlexRS goal for the job.
      https://cloud.google.com/dataflow/docs/guides/flexrs
    IpConfigurationValueValuesEnum: Configuration for VM IPs.

  Messages:
    AdditionalUserLabelsValue: Additional user labels to be specified for the
      job. Keys and values must follow the restrictions specified in the
      [labeling restrictions](https://cloud.google.com/compute/docs/labeling-
      resources#restrictions). An object containing a list of key/value pairs.
      Example: `{ "name": "wrench", "mass": "1kg", "count": "3" }`.

  Fields:
    additionalExperiments: Additional experiment flags for the job.
    additionalUserLabels: Additional user labels to be specified for the job.
      Keys and values must follow the restrictions specified in the [labeling
      restrictions](https://cloud.google.com/compute/docs/labeling-
      resources#restrictions). An object containing a list of key/value pairs.
      Example: `{ "name": "wrench", "mass": "1kg", "count": "3" }`.
    enableStreamingEngine: Whether to enable Streaming Engine for the job.
    flexrsGoal: Set FlexRS goal for the job.
      https://cloud.google.com/dataflow/docs/guides/flexrs
    ipConfiguration: Configuration for VM IPs.
    kmsKeyName: Name for the Cloud KMS key for the job. Key format is:
      projects//locations//keyRings//cryptoKeys/
    machineType: The machine type to use for the job. Defaults to the value
      from the template if not specified.
    maxWorkers: The maximum number of Compute Engine instances to be made
      available to your pipeline during execution, from 1 to 1000.
    network: Network to which VMs will be assigned. If empty or unspecified,
      the service will use the network "default".
    numWorkers: The initial number of Compute Engine instances for the job.
    serviceAccountEmail: The email address of the service account to run the
      job as.
    subnetwork: Subnetwork to which VMs will be assigned, if desired. You can
      specify a subnetwork using either a complete URL or an abbreviated path.
      Expected to be of the form "https://www.googleapis.com/compute/v1/projec
      ts/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or
      "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in
      a Shared VPC network, you must use the complete URL.
    tempLocation: The Cloud Storage path to use for temporary files. Must be a
      valid Cloud Storage URL, beginning with `gs://`.
    workerRegion: The Compute Engine region
      (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
      which worker processing should occur, e.g. "us-west1". Mutually
      exclusive with worker_zone. If neither worker_region nor worker_zone is
      specified, defaults to the control plane region.
    workerZone: The Compute Engine zone
      (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
      which worker processing should occur, e.g. "us-west1-a". Mutually
      exclusive with worker_region. If neither worker_region nor worker_zone
      is specified, a zone in the control plane region is chosen based on
      available capacity. If both `worker_zone` and `zone` are set,
      `worker_zone` takes precedence.
    zone: The Compute Engine [availability
      zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones)
      for launching worker instances to run your pipeline. In the future,
      worker_zone will take precedence.
  """

  class FlexrsGoalValueValuesEnum(_messages.Enum):
    r"""Set FlexRS goal for the job.
    https://cloud.google.com/dataflow/docs/guides/flexrs

    Values:
      FLEXRS_UNSPECIFIED: Run in the default mode.
      FLEXRS_SPEED_OPTIMIZED: Optimize for lower execution time.
      FLEXRS_COST_OPTIMIZED: Optimize for lower cost.
    """
    FLEXRS_UNSPECIFIED = 0
    FLEXRS_SPEED_OPTIMIZED = 1
    FLEXRS_COST_OPTIMIZED = 2

  class IpConfigurationValueValuesEnum(_messages.Enum):
    r"""Configuration for VM IPs.

    Values:
      WORKER_IP_UNSPECIFIED: The configuration is unknown, or unspecified.
      WORKER_IP_PUBLIC: Workers should have public IP addresses.
      WORKER_IP_PRIVATE: Workers should have private IP addresses.
    """
    WORKER_IP_UNSPECIFIED = 0
    WORKER_IP_PUBLIC = 1
    WORKER_IP_PRIVATE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalUserLabelsValue(_messages.Message):
    r"""Additional user labels to be specified for the job. Keys and values
    must follow the restrictions specified in the [labeling
    restrictions](https://cloud.google.com/compute/docs/labeling-
    resources#restrictions). An object containing a list of key/value pairs.
    Example: `{ "name": "wrench", "mass": "1kg", "count": "3" }`.

    Messages:
      AdditionalProperty: An additional property for a
        AdditionalUserLabelsValue object.

    Fields:
      additionalProperties: Additional properties of type
        AdditionalUserLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalUserLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalExperiments = _messages.StringField(1, repeated=True)
  additionalUserLabels = _messages.MessageField('AdditionalUserLabelsValue', 2)
  enableStreamingEngine = _messages.BooleanField(3)
  flexrsGoal = _messages.EnumField('FlexrsGoalValueValuesEnum', 4)
  ipConfiguration = _messages.EnumField('IpConfigurationValueValuesEnum', 5)
  kmsKeyName = _messages.StringField(6)
  machineType = _messages.StringField(7)
  maxWorkers = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  network = _messages.StringField(9)
  numWorkers = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  serviceAccountEmail = _messages.StringField(11)
  subnetwork = _messages.StringField(12)
  tempLocation = _messages.StringField(13)
  workerRegion = _messages.StringField(14)
  workerZone = _messages.StringField(15)
  zone = _messages.StringField(16)


class GoogleCloudDatapipelinesV1IterableValue(_messages.Message):
  r"""Represents an iterable of values. The elements can be of any type.

  Fields:
    elements: The elements of the iterable.
  """

  elements = _messages.MessageField('GoogleCloudDatapipelinesV1FieldValue', 1, repeated=True)


class GoogleCloudDatapipelinesV1Job(_messages.Message):
  r"""Definition of the job information maintained by the pipeline. Fields in
  this entity are retrieved from the executor API (e.g. Dataflow API).

  Enums:
    StateValueValuesEnum: The current state of the job.

  Fields:
    createTime: Output only. The time of job creation.
    dataflowJobDetails: All the details that are specific to a Dataflow job.
    endTime: Output only. The time of job termination. This is absent if the
      job is still running.
    id: Output only. The internal ID for the job.
    name: Required. The fully qualified resource name for the job.
    state: The current state of the job.
    status: Status capturing any error code or message related to job creation
      or execution.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the job.

    Values:
      STATE_UNSPECIFIED: The job state isn't specified.
      STATE_PENDING: The job is waiting to start execution.
      STATE_RUNNING: The job is executing.
      STATE_DONE: The job has finished execution successfully.
      STATE_FAILED: The job has finished execution with a failure.
      STATE_CANCELLED: The job has been terminated upon user request.
    """
    STATE_UNSPECIFIED = 0
    STATE_PENDING = 1
    STATE_RUNNING = 2
    STATE_DONE = 3
    STATE_FAILED = 4
    STATE_CANCELLED = 5

  createTime = _messages.StringField(1)
  dataflowJobDetails = _messages.MessageField('GoogleCloudDatapipelinesV1DataflowJobDetails', 2)
  endTime = _messages.StringField(3)
  id = _messages.StringField(4)
  name = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  status = _messages.MessageField('GoogleRpcStatus', 7)


class GoogleCloudDatapipelinesV1LaunchFlexTemplateParameter(_messages.Message):
  r"""Launch Flex Template parameter.

  Messages:
    LaunchOptionsValue: Launch options for this Flex Template job. This is a
      common set of options across languages and templates. This should not be
      used to pass job parameters.
    ParametersValue: The parameters for the Flex Template. Example:
      `{"num_workers":"5"}`
    TransformNameMappingsValue: Use this to pass transform name mappings for
      streaming update jobs. Example:
      `{"oldTransformName":"newTransformName",...}`

  Fields:
    containerSpecGcsPath: Cloud Storage path to a file with a JSON-serialized
      ContainerSpec as content.
    environment: The runtime environment for the Flex Template job.
    jobName: Required. The job name to use for the created job. For an update
      job request, the job name should be the same as the existing running
      job.
    launchOptions: Launch options for this Flex Template job. This is a common
      set of options across languages and templates. This should not be used
      to pass job parameters.
    parameters: The parameters for the Flex Template. Example:
      `{"num_workers":"5"}`
    transformNameMappings: Use this to pass transform name mappings for
      streaming update jobs. Example:
      `{"oldTransformName":"newTransformName",...}`
    update: Set this to true if you are sending a request to update a running
      streaming job. When set, the job name should be the same as the running
      job.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LaunchOptionsValue(_messages.Message):
    r"""Launch options for this Flex Template job. This is a common set of
    options across languages and templates. This should not be used to pass
    job parameters.

    Messages:
      AdditionalProperty: An additional property for a LaunchOptionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type LaunchOptionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LaunchOptionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""The parameters for the Flex Template. Example: `{"num_workers":"5"}`

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TransformNameMappingsValue(_messages.Message):
    r"""Use this to pass transform name mappings for streaming update jobs.
    Example: `{"oldTransformName":"newTransformName",...}`

    Messages:
      AdditionalProperty: An additional property for a
        TransformNameMappingsValue object.

    Fields:
      additionalProperties: Additional properties of type
        TransformNameMappingsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TransformNameMappingsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  containerSpecGcsPath = _messages.StringField(1)
  environment = _messages.MessageField('GoogleCloudDatapipelinesV1FlexTemplateRuntimeEnvironment', 2)
  jobName = _messages.StringField(3)
  launchOptions = _messages.MessageField('LaunchOptionsValue', 4)
  parameters = _messages.MessageField('ParametersValue', 5)
  transformNameMappings = _messages.MessageField('TransformNameMappingsValue', 6)
  update = _messages.BooleanField(7)


class GoogleCloudDatapipelinesV1LaunchFlexTemplateRequest(_messages.Message):
  r"""A request to launch a Dataflow job from a Flex Template.

  Fields:
    launchParameter: Required. Parameter to launch a job from a Flex Template.
    location: Required. The [regional endpoint]
      (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
      which to direct the request. For example, `us-central1`, `us-west1`.
    projectId: Required. The ID of the Cloud Platform project that the job
      belongs to.
    validateOnly: If true, the request is validated but not actually executed.
      Defaults to false.
  """

  launchParameter = _messages.MessageField('GoogleCloudDatapipelinesV1LaunchFlexTemplateParameter', 1)
  location = _messages.StringField(2)
  projectId = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class GoogleCloudDatapipelinesV1LaunchTemplateParameters(_messages.Message):
  r"""Parameters to provide to the template being launched.

  Messages:
    ParametersValue: The runtime parameters to pass to the job.
    TransformNameMappingValue: Map of transform name prefixes of the job to be
      replaced to the corresponding name prefixes of the new job. Only
      applicable when updating a pipeline.

  Fields:
    environment: The runtime environment for the job.
    jobName: Required. The job name to use for the created job.
    parameters: The runtime parameters to pass to the job.
    transformNameMapping: Map of transform name prefixes of the job to be
      replaced to the corresponding name prefixes of the new job. Only
      applicable when updating a pipeline.
    update: If set, replace the existing pipeline with the name specified by
      jobName with this pipeline, preserving state.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""The runtime parameters to pass to the job.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TransformNameMappingValue(_messages.Message):
    r"""Map of transform name prefixes of the job to be replaced to the
    corresponding name prefixes of the new job. Only applicable when updating
    a pipeline.

    Messages:
      AdditionalProperty: An additional property for a
        TransformNameMappingValue object.

    Fields:
      additionalProperties: Additional properties of type
        TransformNameMappingValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TransformNameMappingValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  environment = _messages.MessageField('GoogleCloudDatapipelinesV1RuntimeEnvironment', 1)
  jobName = _messages.StringField(2)
  parameters = _messages.MessageField('ParametersValue', 3)
  transformNameMapping = _messages.MessageField('TransformNameMappingValue', 4)
  update = _messages.BooleanField(5)


class GoogleCloudDatapipelinesV1LaunchTemplateRequest(_messages.Message):
  r"""A request to launch a template.

  Fields:
    gcsPath: A Cloud Storage path to the template from which to create the
      job. Must be a valid Cloud Storage URL, beginning with 'gs://'.
    launchParameters: The parameters of the template to launch. This should be
      part of the body of the POST request.
    location: The [regional endpoint]
      (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
      which to direct the request.
    projectId: Required. The ID of the Cloud Platform project that the job
      belongs to.
    validateOnly: If true, the request is validated but not actually executed.
      Defaults to false.
  """

  gcsPath = _messages.StringField(1)
  launchParameters = _messages.MessageField('GoogleCloudDatapipelinesV1LaunchTemplateParameters', 2)
  location = _messages.StringField(3)
  projectId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class GoogleCloudDatapipelinesV1ListJobsResponse(_messages.Message):
  r"""Response message for ListJobs

  Fields:
    jobs: Results that were accessible to the caller. Results are always in
      descending order of job creation date.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  jobs = _messages.MessageField('GoogleCloudDatapipelinesV1Job', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudDatapipelinesV1ListPipelinesResponse(_messages.Message):
  r"""Response message for ListPipelines.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    pipelines: Results that matched the filter criteria and were accessible to
      the caller. Results are always in descending order of pipeline creation
      date.
  """

  nextPageToken = _messages.StringField(1)
  pipelines = _messages.MessageField('GoogleCloudDatapipelinesV1Pipeline', 2, repeated=True)


class GoogleCloudDatapipelinesV1LogicalType(_messages.Message):
  r"""Represents the input for creating a specified logical type.

  Fields:
    enumerationType: The enum represented by this logical type.
    fixedBytes: The fixed-size byte collection represented by this logical
      type.
  """

  enumerationType = _messages.MessageField('GoogleCloudDatapipelinesV1LogicalTypeEnumerationType', 1)
  fixedBytes = _messages.MessageField('GoogleCloudDatapipelinesV1LogicalTypeFixedBytes', 2)


class GoogleCloudDatapipelinesV1LogicalTypeEnumerationType(_messages.Message):
  r"""Represents the Beam EnumerationType logical type.

  Fields:
    values: Names of the values. The numeric value is the same as the index.
  """

  values = _messages.StringField(1, repeated=True)


class GoogleCloudDatapipelinesV1LogicalTypeFixedBytes(_messages.Message):
  r"""Represents the Beam FixedBytes logical type.

  Fields:
    sizeBytes: Number of bytes to allocate.
  """

  sizeBytes = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudDatapipelinesV1MapType(_messages.Message):
  r"""Represents a map in a schema.

  Fields:
    mapKeyType: Key type of the map. Only atomic types are supported.
    mapValueType: Value type of the map.
  """

  mapKeyType = _messages.MessageField('GoogleCloudDatapipelinesV1FieldType', 1)
  mapValueType = _messages.MessageField('GoogleCloudDatapipelinesV1FieldType', 2)


class GoogleCloudDatapipelinesV1MapValue(_messages.Message):
  r"""Represents a key/value pairing.

  Fields:
    entries: The entries in the map.
  """

  entries = _messages.MessageField('GoogleCloudDatapipelinesV1MapValueEntry', 1, repeated=True)


class GoogleCloudDatapipelinesV1MapValueEntry(_messages.Message):
  r"""A single entry in the map. Each entry must have a unique key.

  Fields:
    key: The key value. Only atomic values are supported.
    value: The value associated with the key. It may be of any type.
  """

  key = _messages.MessageField('GoogleCloudDatapipelinesV1FieldValue', 1)
  value = _messages.MessageField('GoogleCloudDatapipelinesV1FieldValue', 2)


class GoogleCloudDatapipelinesV1Pipeline(_messages.Message):
  r"""The main pipeline entity and all the necessary metadata for launching
  and managing linked jobs.

  Enums:
    StateValueValuesEnum: Required. The state of the pipeline. When the
      pipeline is created, the state is set to 'PIPELINE_STATE_ACTIVE' by
      default. State changes can be requested by setting the state to
      stopping, paused, or resuming. State cannot be changed through
      UpdatePipeline requests.
    TypeValueValuesEnum: Required. The type of the pipeline. This field
      affects the scheduling of the pipeline and the type of metrics to show
      for the pipeline.

  Messages:
    PipelineSourcesValue: Immutable. The sources of the pipeline (for example,
      Dataplex). The keys and values are set by the corresponding sources
      during pipeline creation.

  Fields:
    createTime: Output only. Immutable. The timestamp when the pipeline was
      initially created. Set by the Data Pipelines service.
    displayName: Required. The display name of the pipeline. It can contain
      only letters ([A-Za-z]), numbers ([0-9]), hyphens (-), and underscores
      (_).
    jobCount: Output only. Number of jobs.
    lastUpdateTime: Output only. Immutable. The timestamp when the pipeline
      was last modified. Set by the Data Pipelines service.
    name: The pipeline name. For example:
      `projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID`. *
      `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]), hyphens
      (-), colons (:), and periods (.). For more information, see [Identifying
      projects](https://cloud.google.com/resource-manager/docs/creating-
      managing-projects#identifying_projects). * `LOCATION_ID` is the
      canonical ID for the pipeline's location. The list of available
      locations can be obtained by calling
      `google.cloud.location.Locations.ListLocations`. Note that the Data
      Pipelines service is not available in all regions. It depends on Cloud
      Scheduler, an App Engine application, so it's only available in [App
      Engine regions](https://cloud.google.com/about/locations#region). *
      `PIPELINE_ID` is the ID of the pipeline. Must be unique for the selected
      project and location.
    pipelineSources: Immutable. The sources of the pipeline (for example,
      Dataplex). The keys and values are set by the corresponding sources
      during pipeline creation.
    scheduleInfo: Internal scheduling information for a pipeline. If this
      information is provided, periodic jobs will be created per the schedule.
      If not, users are responsible for creating jobs externally.
    schedulerServiceAccountEmail: Optional. A service account email to be used
      with the Cloud Scheduler job. If not specified, the default compute
      engine service account will be used.
    state: Required. The state of the pipeline. When the pipeline is created,
      the state is set to 'PIPELINE_STATE_ACTIVE' by default. State changes
      can be requested by setting the state to stopping, paused, or resuming.
      State cannot be changed through UpdatePipeline requests.
    type: Required. The type of the pipeline. This field affects the
      scheduling of the pipeline and the type of metrics to show for the
      pipeline.
    workload: Workload information for creating new jobs.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Required. The state of the pipeline. When the pipeline is created, the
    state is set to 'PIPELINE_STATE_ACTIVE' by default. State changes can be
    requested by setting the state to stopping, paused, or resuming. State
    cannot be changed through UpdatePipeline requests.

    Values:
      STATE_UNSPECIFIED: The pipeline state isn't specified.
      STATE_RESUMING: The pipeline is getting started or resumed. When
        finished, the pipeline state will be 'PIPELINE_STATE_ACTIVE'.
      STATE_ACTIVE: The pipeline is actively running.
      STATE_STOPPING: The pipeline is in the process of stopping. When
        finished, the pipeline state will be 'PIPELINE_STATE_ARCHIVED'.
      STATE_ARCHIVED: The pipeline has been stopped. This is a terminal state
        and cannot be undone.
      STATE_PAUSED: The pipeline is paused. This is a non-terminal state. When
        the pipeline is paused, it will hold processing jobs, but can be
        resumed later. For a batch pipeline, this means pausing the scheduler
        job. For a streaming pipeline, creating a job snapshot to resume from
        will give the same effect.
    """
    STATE_UNSPECIFIED = 0
    STATE_RESUMING = 1
    STATE_ACTIVE = 2
    STATE_STOPPING = 3
    STATE_ARCHIVED = 4
    STATE_PAUSED = 5

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the pipeline. This field affects the scheduling
    of the pipeline and the type of metrics to show for the pipeline.

    Values:
      PIPELINE_TYPE_UNSPECIFIED: The pipeline type isn't specified.
      PIPELINE_TYPE_BATCH: A batch pipeline. It runs jobs on a specific
        schedule, and each job will automatically terminate once execution is
        finished.
      PIPELINE_TYPE_STREAMING: A streaming pipeline. The underlying job is
        continuously running until it is manually terminated by the user. This
        type of pipeline doesn't have a schedule to run on, and the linked job
        gets created when the pipeline is created.
    """
    PIPELINE_TYPE_UNSPECIFIED = 0
    PIPELINE_TYPE_BATCH = 1
    PIPELINE_TYPE_STREAMING = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PipelineSourcesValue(_messages.Message):
    r"""Immutable. The sources of the pipeline (for example, Dataplex). The
    keys and values are set by the corresponding sources during pipeline
    creation.

    Messages:
      AdditionalProperty: An additional property for a PipelineSourcesValue
        object.

    Fields:
      additionalProperties: Additional properties of type PipelineSourcesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PipelineSourcesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  jobCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  lastUpdateTime = _messages.StringField(4)
  name = _messages.StringField(5)
  pipelineSources = _messages.MessageField('PipelineSourcesValue', 6)
  scheduleInfo = _messages.MessageField('GoogleCloudDatapipelinesV1ScheduleSpec', 7)
  schedulerServiceAccountEmail = _messages.StringField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  type = _messages.EnumField('TypeValueValuesEnum', 10)
  workload = _messages.MessageField('GoogleCloudDatapipelinesV1Workload', 11)


class GoogleCloudDatapipelinesV1RawSchemaInfo(_messages.Message):
  r"""The raw schema and its type.

  Enums:
    TypeValueValuesEnum: The type of the schema.

  Fields:
    rawSchema: The schema.
    type: The type of the schema.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of the schema.

    Values:
      RAW_SCHEMA_TYPE_UNSPECIFIED: The schema type is unknown.
      RAW_SCHEMA_TYPE_AVRO: The schema is an Avro schema.
    """
    RAW_SCHEMA_TYPE_UNSPECIFIED = 0
    RAW_SCHEMA_TYPE_AVRO = 1

  rawSchema = _messages.StringField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class GoogleCloudDatapipelinesV1Row(_messages.Message):
  r"""Represents an Apache Beam row, though the `Any` nature of values is
  replaced with more concrete representations of valid values.

  Fields:
    schema: Required. The schema of the row's data.
    values: Required. The values of this Row. A fully built row is required to
      hold to the schema specified by `schema`.
  """

  schema = _messages.MessageField('GoogleCloudDatapipelinesV1SchemaSource', 1)
  values = _messages.MessageField('GoogleCloudDatapipelinesV1FieldValue', 2, repeated=True)


class GoogleCloudDatapipelinesV1RunPipelineRequest(_messages.Message):
  r"""Request message for RunPipeline"""


class GoogleCloudDatapipelinesV1RunPipelineResponse(_messages.Message):
  r"""Response message for RunPipeline

  Fields:
    job: Job that was created as part of RunPipeline operation.
  """

  job = _messages.MessageField('GoogleCloudDatapipelinesV1Job', 1)


class GoogleCloudDatapipelinesV1RuntimeEnvironment(_messages.Message):
  r"""The environment values to set at runtime.

  Enums:
    IpConfigurationValueValuesEnum: Configuration for VM IPs.

  Messages:
    AdditionalUserLabelsValue: Additional user labels to be specified for the
      job. Keys and values should follow the restrictions specified in the
      [labeling restrictions](https://cloud.google.com/compute/docs/labeling-
      resources#restrictions) page. An object containing a list of key/value
      pairs. Example: { "name": "wrench", "mass": "1kg", "count": "3" }.

  Fields:
    additionalExperiments: Additional experiment flags for the job.
    additionalUserLabels: Additional user labels to be specified for the job.
      Keys and values should follow the restrictions specified in the
      [labeling restrictions](https://cloud.google.com/compute/docs/labeling-
      resources#restrictions) page. An object containing a list of key/value
      pairs. Example: { "name": "wrench", "mass": "1kg", "count": "3" }.
    bypassTempDirValidation: Whether to bypass the safety checks for the job's
      temporary directory. Use with caution.
    enableStreamingEngine: Whether to enable Streaming Engine for the job.
    ipConfiguration: Configuration for VM IPs.
    kmsKeyName: Name for the Cloud KMS key for the job. The key format is:
      projects//locations//keyRings//cryptoKeys/
    machineType: The machine type to use for the job. Defaults to the value
      from the template if not specified.
    maxWorkers: The maximum number of Compute Engine instances to be made
      available to your pipeline during execution, from 1 to 1000.
    network: Network to which VMs will be assigned. If empty or unspecified,
      the service will use the network "default".
    numWorkers: The initial number of Compute Engine instances for the job.
    serviceAccountEmail: The email address of the service account to run the
      job as.
    subnetwork: Subnetwork to which VMs will be assigned, if desired. You can
      specify a subnetwork using either a complete URL or an abbreviated path.
      Expected to be of the form "https://www.googleapis.com/compute/v1/projec
      ts/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or
      "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in
      a Shared VPC network, you must use the complete URL.
    tempLocation: The Cloud Storage path to use for temporary files. Must be a
      valid Cloud Storage URL, beginning with `gs://`.
    workerRegion: The Compute Engine region
      (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
      which worker processing should occur, e.g. "us-west1". Mutually
      exclusive with worker_zone. If neither worker_region nor worker_zone is
      specified, default to the control plane's region.
    workerZone: The Compute Engine zone
      (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
      which worker processing should occur, e.g. "us-west1-a". Mutually
      exclusive with worker_region. If neither worker_region nor worker_zone
      is specified, a zone in the control plane's region is chosen based on
      available capacity. If both `worker_zone` and `zone` are set,
      `worker_zone` takes precedence.
    zone: The Compute Engine [availability
      zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones)
      for launching worker instances to run your pipeline. In the future,
      worker_zone will take precedence.
  """

  class IpConfigurationValueValuesEnum(_messages.Enum):
    r"""Configuration for VM IPs.

    Values:
      WORKER_IP_UNSPECIFIED: The configuration is unknown, or unspecified.
      WORKER_IP_PUBLIC: Workers should have public IP addresses.
      WORKER_IP_PRIVATE: Workers should have private IP addresses.
    """
    WORKER_IP_UNSPECIFIED = 0
    WORKER_IP_PUBLIC = 1
    WORKER_IP_PRIVATE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalUserLabelsValue(_messages.Message):
    r"""Additional user labels to be specified for the job. Keys and values
    should follow the restrictions specified in the [labeling
    restrictions](https://cloud.google.com/compute/docs/labeling-
    resources#restrictions) page. An object containing a list of key/value
    pairs. Example: { "name": "wrench", "mass": "1kg", "count": "3" }.

    Messages:
      AdditionalProperty: An additional property for a
        AdditionalUserLabelsValue object.

    Fields:
      additionalProperties: Additional properties of type
        AdditionalUserLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalUserLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalExperiments = _messages.StringField(1, repeated=True)
  additionalUserLabels = _messages.MessageField('AdditionalUserLabelsValue', 2)
  bypassTempDirValidation = _messages.BooleanField(3)
  enableStreamingEngine = _messages.BooleanField(4)
  ipConfiguration = _messages.EnumField('IpConfigurationValueValuesEnum', 5)
  kmsKeyName = _messages.StringField(6)
  machineType = _messages.StringField(7)
  maxWorkers = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  network = _messages.StringField(9)
  numWorkers = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  serviceAccountEmail = _messages.StringField(11)
  subnetwork = _messages.StringField(12)
  tempLocation = _messages.StringField(13)
  workerRegion = _messages.StringField(14)
  workerZone = _messages.StringField(15)
  zone = _messages.StringField(16)


class GoogleCloudDatapipelinesV1ScheduleSpec(_messages.Message):
  r"""Details of the schedule the pipeline runs on.

  Fields:
    nextJobTime: Output only. When the next Scheduler job is going to run.
    schedule: Unix-cron format of the schedule. This information is retrieved
      from the linked Cloud Scheduler.
    timeZone: Timezone ID. This matches the timezone IDs used by the Cloud
      Scheduler API. If empty, UTC time is assumed.
  """

  nextJobTime = _messages.StringField(1)
  schedule = _messages.StringField(2)
  timeZone = _messages.StringField(3)


class GoogleCloudDatapipelinesV1Schema(_messages.Message):
  r"""Represents a simplified Apache Beam schema.

  Fields:
    fields: Fields in the schema. Every field within a schema must have a
      unique name.
    referenceId: An identifier of the schema for looking it up in a
      repository. This only needs to be set if the schema is stored in a
      repository.
  """

  fields = _messages.MessageField('GoogleCloudDatapipelinesV1Field', 1, repeated=True)
  referenceId = _messages.StringField(2)


class GoogleCloudDatapipelinesV1SchemaSource(_messages.Message):
  r"""Holds a schema or a reference to a schema in some repository.

  Fields:
    localSchema: Schema located locally with the message.
    referenceId: The `reference_id` value of a schema in a repository.
  """

  localSchema = _messages.MessageField('GoogleCloudDatapipelinesV1Schema', 1)
  referenceId = _messages.StringField(2)


class GoogleCloudDatapipelinesV1SdkVersion(_messages.Message):
  r"""The version of the SDK used to run the job.

  Enums:
    SdkSupportStatusValueValuesEnum: The support status for this SDK version.

  Fields:
    sdkSupportStatus: The support status for this SDK version.
    version: The version of the SDK used to run the job.
    versionDisplayName: A readable string describing the version of the SDK.
  """

  class SdkSupportStatusValueValuesEnum(_messages.Enum):
    r"""The support status for this SDK version.

    Values:
      UNKNOWN: Dataflow is unaware of this version.
      SUPPORTED: This is a known version of an SDK, and is supported.
      STALE: A newer version of the SDK exists, and an update is recommended.
      DEPRECATED: This version of the SDK is deprecated and will eventually be
        unsupported.
      UNSUPPORTED: Support for this SDK version has ended and it should no
        longer be used.
    """
    UNKNOWN = 0
    SUPPORTED = 1
    STALE = 2
    DEPRECATED = 3
    UNSUPPORTED = 4

  sdkSupportStatus = _messages.EnumField('SdkSupportStatusValueValuesEnum', 1)
  version = _messages.StringField(2)
  versionDisplayName = _messages.StringField(3)


class GoogleCloudDatapipelinesV1StopPipelineRequest(_messages.Message):
  r"""Request message for StopPipeline."""


class GoogleCloudDatapipelinesV1TransformDescription(_messages.Message):
  r"""Description of a schema-aware transform, which provides info on how it
  can be configured.

  Fields:
    name: Output only. The full name of this resource formatted as: projects/{
      project}/locations/{location}/transformDescriptions/{transform_descripti
      on} `transform_description` is the same as the `uniform_resource_name`
      field.
    options: Available options for configuring the transform.
    uniformResourceName: Unique resource name of the transform.
  """

  name = _messages.StringField(1)
  options = _messages.MessageField('GoogleCloudDatapipelinesV1Schema', 2)
  uniformResourceName = _messages.StringField(3)


class GoogleCloudDatapipelinesV1Workload(_messages.Message):
  r"""Workload details for creating the pipeline jobs.

  Fields:
    dataflowFlexTemplateRequest: Template information and additional
      parameters needed to launch a Dataflow job using the flex launch API.
    dataflowLaunchTemplateRequest: Template information and additional
      parameters needed to launch a Dataflow job using the standard launch
      API.
  """

  dataflowFlexTemplateRequest = _messages.MessageField('GoogleCloudDatapipelinesV1LaunchFlexTemplateRequest', 1)
  dataflowLaunchTemplateRequest = _messages.MessageField('GoogleCloudDatapipelinesV1LaunchTemplateRequest', 2)


class GoogleProtobufEmpty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GoogleTypeDateTime(_messages.Message):
  r"""Represents civil time (or occasionally physical time). This type can
  represent a civil time in one of a few possible ways: * When utc_offset is
  set and time_zone is unset: a civil time on a calendar day with a particular
  offset from UTC. * When time_zone is set and utc_offset is unset: a civil
  time on a calendar day in a particular time zone. * When neither time_zone
  nor utc_offset is set: a civil time on a calendar day in local time. The
  date is relative to the Proleptic Gregorian Calendar. If year, month, or day
  are 0, the DateTime is considered not to have a specific year, month, or day
  respectively. This type may also be used to represent a physical time if all
  the date and time fields are set and either case of the `time_offset` oneof
  is set. Consider using `Timestamp` message for physical time instead. If
  your use case also would like to store the user's timezone, that can be done
  in another field. This type is more flexible than some applications may
  want. Make sure to document and validate your application's limitations.

  Fields:
    day: Optional. Day of month. Must be from 1 to 31 and valid for the year
      and month, or 0 if specifying a datetime without a day.
    hours: Optional. Hours of day in 24 hour format. Should be from 0 to 23,
      defaults to 0 (midnight). An API may choose to allow the value
      "24:00:00" for scenarios like business closing time.
    minutes: Optional. Minutes of hour of day. Must be from 0 to 59, defaults
      to 0.
    month: Optional. Month of year. Must be from 1 to 12, or 0 if specifying a
      datetime without a month.
    nanos: Optional. Fractions of seconds in nanoseconds. Must be from 0 to
      999,999,999, defaults to 0.
    seconds: Optional. Seconds of minutes of the time. Must normally be from 0
      to 59, defaults to 0. An API may allow the value 60 if it allows leap-
      seconds.
    timeZone: Time zone.
    utcOffset: UTC offset. Must be whole seconds, between -18 hours and +18
      hours. For example, a UTC offset of -4:00 would be represented as {
      seconds: -14400 }.
    year: Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a
      datetime without a year.
  """

  day = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  hours = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  minutes = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  month = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  nanos = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  timeZone = _messages.MessageField('GoogleTypeTimeZone', 7)
  utcOffset = _messages.StringField(8)
  year = _messages.IntegerField(9, variant=_messages.Variant.INT32)


class GoogleTypeDecimal(_messages.Message):
  r"""A representation of a decimal value, such as 2.5. Clients may convert
  values into language-native decimal formats, such as Java's BigDecimal or
  Python's decimal.Decimal. [BigDecimal]: https://docs.oracle.com/en/java/java
  se/11/docs/api/java.base/java/math/BigDecimal.html [decimal.Decimal]:
  https://docs.python.org/3/library/decimal.html

  Fields:
    value: The decimal value, as a string. The string representation consists
      of an optional sign, `+` (`U+002B`) or `-` (`U+002D`), followed by a
      sequence of zero or more decimal digits ("the integer"), optionally
      followed by a fraction, optionally followed by an exponent. An empty
      string **should** be interpreted as `0`. The fraction consists of a
      decimal point followed by zero or more decimal digits. The string must
      contain at least one digit in either the integer or the fraction. The
      number formed by the sign, the integer and the fraction is referred to
      as the significand. The exponent consists of the character `e`
      (`U+0065`) or `E` (`U+0045`) followed by one or more decimal digits.
      Services **should** normalize decimal values before storing them by: -
      Removing an explicitly-provided `+` sign (`+2.5` -> `2.5`). - Replacing
      a zero-length integer value with `0` (`.5` -> `0.5`). - Coercing the
      exponent character to upper-case, with explicit sign (`2.5e8` ->
      `2.5E+8`). - Removing an explicitly-provided zero exponent (`2.5E0` ->
      `2.5`). Services **may** perform additional normalization based on its
      own needs and the internal decimal implementation selected, such as
      shifting the decimal point and exponent value together (example:
      `2.5E-1` <-> `0.25`). Additionally, services **may** preserve trailing
      zeroes in the fraction to indicate increased precision, but are not
      required to do so. Note that only the `.` character is supported to
      divide the integer and the fraction; `,` **should not** be supported
      regardless of locale. Additionally, thousand separators **should not**
      be supported. If a service does support them, values **must** be
      normalized. The ENBF grammar is: DecimalString = '' | [Sign] Significand
      [Exponent]; Sign = '+' | '-'; Significand = Digits '.' | [Digits] '.'
      Digits; Exponent = ('e' | 'E') [Sign] Digits; Digits = { '0' | '1' | '2'
      | '3' | '4' | '5' | '6' | '7' | '8' | '9' }; Services **should** clearly
      document the range of supported values, the maximum supported precision
      (total number of digits), and, if applicable, the scale (number of
      digits after the decimal point), as well as how it behaves when
      receiving out-of-bounds values. Services **may** choose to accept values
      passed as input even when the value has a higher precision or scale than
      the service supports, and **should** round the value to fit the
      supported scale. Alternatively, the service **may** error with `400 Bad
      Request` (`INVALID_ARGUMENT` in gRPC) if precision would be lost.
      Services **should** error with `400 Bad Request` (`INVALID_ARGUMENT` in
      gRPC) if the service receives a value outside of the supported range.
  """

  value = _messages.StringField(1)


class GoogleTypeTimeZone(_messages.Message):
  r"""Represents a time zone from the [IANA Time Zone
  Database](https://www.iana.org/time-zones).

  Fields:
    id: IANA Time Zone Database time zone, e.g. "America/New_York".
    version: Optional. IANA Time Zone Database version number, e.g. "2019a".
  """

  id = _messages.StringField(1)
  version = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
