"""Generated client library for dataflow version v1b3."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.dataflow.v1b3 import dataflow_v1b3_messages as messages


class DataflowV1b3(base_api.BaseApiClient):
  """Generated client library for service dataflow version v1b3."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://dataflow.googleapis.com/'
  MTLS_BASE_URL = 'https://dataflow.mtls.googleapis.com/'

  _PACKAGE = 'dataflow'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform', 'https://www.googleapis.com/auth/compute', 'https://www.googleapis.com/auth/compute.readonly', 'https://www.googleapis.com/auth/userinfo.email']
  _VERSION = 'v1b3'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'DataflowV1b3'
  _URL_VERSION = 'v1b3'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new dataflow handle."""
    url = url or self.BASE_URL
    super(DataflowV1b3, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_catalogTemplates_templateVersions = self.ProjectsCatalogTemplatesTemplateVersionsService(self)
    self.projects_catalogTemplates = self.ProjectsCatalogTemplatesService(self)
    self.projects_jobs_debug = self.ProjectsJobsDebugService(self)
    self.projects_jobs_messages = self.ProjectsJobsMessagesService(self)
    self.projects_jobs_workItems = self.ProjectsJobsWorkItemsService(self)
    self.projects_jobs = self.ProjectsJobsService(self)
    self.projects_locations_deployments = self.ProjectsLocationsDeploymentsService(self)
    self.projects_locations_flexTemplates = self.ProjectsLocationsFlexTemplatesService(self)
    self.projects_locations_jobs_debug = self.ProjectsLocationsJobsDebugService(self)
    self.projects_locations_jobs_messages = self.ProjectsLocationsJobsMessagesService(self)
    self.projects_locations_jobs_snapshots = self.ProjectsLocationsJobsSnapshotsService(self)
    self.projects_locations_jobs_stages = self.ProjectsLocationsJobsStagesService(self)
    self.projects_locations_jobs_workItems = self.ProjectsLocationsJobsWorkItemsService(self)
    self.projects_locations_jobs = self.ProjectsLocationsJobsService(self)
    self.projects_locations_snapshots = self.ProjectsLocationsSnapshotsService(self)
    self.projects_locations_sql = self.ProjectsLocationsSqlService(self)
    self.projects_locations_templates = self.ProjectsLocationsTemplatesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects_snapshots = self.ProjectsSnapshotsService(self)
    self.projects_templateVersions = self.ProjectsTemplateVersionsService(self)
    self.projects_templates = self.ProjectsTemplatesService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsCatalogTemplatesTemplateVersionsService(base_api.BaseApiService):
    """Service class for the projects_catalogTemplates_templateVersions resource."""

    _NAME = 'projects_catalogTemplates_templateVersions'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsCatalogTemplatesTemplateVersionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Template with TemplateVersion. Requires project_id(projects) and template display_name(catalogTemplates). The template display_name is set by the user.

      Args:
        request: (DataflowProjectsCatalogTemplatesTemplateVersionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TemplateVersion) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1b3/projects/{projectsId}/catalogTemplates/{catalogTemplatesId}/templateVersions',
        http_method='POST',
        method_id='dataflow.projects.catalogTemplates.templateVersions.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1b3/{+parent}/templateVersions',
        request_field='createTemplateVersionRequest',
        request_type_name='DataflowProjectsCatalogTemplatesTemplateVersionsCreateRequest',
        response_type_name='TemplateVersion',
        supports_download=False,
    )

  class ProjectsCatalogTemplatesService(base_api.BaseApiService):
    """Service class for the projects_catalogTemplates resource."""

    _NAME = 'projects_catalogTemplates'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsCatalogTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Commit(self, request, global_params=None):
      r"""Creates a new TemplateVersion (Important: not new Template) entry in the spanner table. Requires project_id and display_name (template).

      Args:
        request: (DataflowProjectsCatalogTemplatesCommitRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TemplateVersion) The response message.
      """
      config = self.GetMethodConfig('Commit')
      return self._RunMethod(
          config, request, global_params=global_params)

    Commit.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1b3/projects/{projectsId}/catalogTemplates/{catalogTemplatesId}:commit',
        http_method='POST',
        method_id='dataflow.projects.catalogTemplates.commit',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1b3/{+name}:commit',
        request_field='commitTemplateVersionRequest',
        request_type_name='DataflowProjectsCatalogTemplatesCommitRequest',
        response_type_name='TemplateVersion',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an existing Template. Do nothing if Template does not exist.

      Args:
        request: (DataflowProjectsCatalogTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1b3/projects/{projectsId}/catalogTemplates/{catalogTemplatesId}',
        http_method='DELETE',
        method_id='dataflow.projects.catalogTemplates.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1b3/{+name}',
        request_field='',
        request_type_name='DataflowProjectsCatalogTemplatesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get TemplateVersion using project_id and display_name with an optional version_id field. Get latest (has tag "latest") TemplateVersion if version_id not set.

      Args:
        request: (DataflowProjectsCatalogTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TemplateVersion) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1b3/projects/{projectsId}/catalogTemplates/{catalogTemplatesId}',
        http_method='GET',
        method_id='dataflow.projects.catalogTemplates.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1b3/{+name}',
        request_field='',
        request_type_name='DataflowProjectsCatalogTemplatesGetRequest',
        response_type_name='TemplateVersion',
        supports_download=False,
    )

    def Label(self, request, global_params=None):
      r"""Updates the label of the TemplateVersion. Label can be duplicated in Template, so either add or remove the label in the TemplateVersion.

      Args:
        request: (DataflowProjectsCatalogTemplatesLabelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ModifyTemplateVersionLabelResponse) The response message.
      """
      config = self.GetMethodConfig('Label')
      return self._RunMethod(
          config, request, global_params=global_params)

    Label.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1b3/projects/{projectsId}/catalogTemplates/{catalogTemplatesId}:label',
        http_method='POST',
        method_id='dataflow.projects.catalogTemplates.label',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1b3/{+name}:label',
        request_field='modifyTemplateVersionLabelRequest',
        request_type_name='DataflowProjectsCatalogTemplatesLabelRequest',
        response_type_name='ModifyTemplateVersionLabelResponse',
        supports_download=False,
    )

    def Tag(self, request, global_params=None):
      r"""Updates the tag of the TemplateVersion, and tag is unique in Template. If tag exists in another TemplateVersion in the Template, updates the tag to this TemplateVersion will remove it from the old TemplateVersion and add it to this TemplateVersion. If request is remove_only (remove_only = true), remove the tag from this TemplateVersion.

      Args:
        request: (DataflowProjectsCatalogTemplatesTagRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ModifyTemplateVersionTagResponse) The response message.
      """
      config = self.GetMethodConfig('Tag')
      return self._RunMethod(
          config, request, global_params=global_params)

    Tag.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1b3/projects/{projectsId}/catalogTemplates/{catalogTemplatesId}:tag',
        http_method='POST',
        method_id='dataflow.projects.catalogTemplates.tag',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1b3/{+name}:tag',
        request_field='modifyTemplateVersionTagRequest',
        request_type_name='DataflowProjectsCatalogTemplatesTagRequest',
        response_type_name='ModifyTemplateVersionTagResponse',
        supports_download=False,
    )

  class ProjectsJobsDebugService(base_api.BaseApiService):
    """Service class for the projects_jobs_debug resource."""

    _NAME = 'projects_jobs_debug'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsJobsDebugService, self).__init__(client)
      self._upload_configs = {
          }

    def GetConfig(self, request, global_params=None):
      r"""Get encoded debug configuration for component. Not cacheable.

      Args:
        request: (DataflowProjectsJobsDebugGetConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetDebugConfigResponse) The response message.
      """
      config = self.GetMethodConfig('GetConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.jobs.debug.getConfig',
        ordered_params=['projectId', 'jobId'],
        path_params=['jobId', 'projectId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/jobs/{jobId}/debug/getConfig',
        request_field='getDebugConfigRequest',
        request_type_name='DataflowProjectsJobsDebugGetConfigRequest',
        response_type_name='GetDebugConfigResponse',
        supports_download=False,
    )

    def SendCapture(self, request, global_params=None):
      r"""Send encoded debug capture data for component.

      Args:
        request: (DataflowProjectsJobsDebugSendCaptureRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SendDebugCaptureResponse) The response message.
      """
      config = self.GetMethodConfig('SendCapture')
      return self._RunMethod(
          config, request, global_params=global_params)

    SendCapture.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.jobs.debug.sendCapture',
        ordered_params=['projectId', 'jobId'],
        path_params=['jobId', 'projectId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/jobs/{jobId}/debug/sendCapture',
        request_field='sendDebugCaptureRequest',
        request_type_name='DataflowProjectsJobsDebugSendCaptureRequest',
        response_type_name='SendDebugCaptureResponse',
        supports_download=False,
    )

  class ProjectsJobsMessagesService(base_api.BaseApiService):
    """Service class for the projects_jobs_messages resource."""

    _NAME = 'projects_jobs_messages'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsJobsMessagesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Request the job status. To request the status of a job, we recommend using `projects.locations.jobs.messages.list` with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using `projects.jobs.messages.list` is not recommended, as you can only request the status of jobs that are running in `us-central1`.

      Args:
        request: (DataflowProjectsJobsMessagesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListJobMessagesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.jobs.messages.list',
        ordered_params=['projectId', 'jobId'],
        path_params=['jobId', 'projectId'],
        query_params=['endTime', 'location', 'minimumImportance', 'pageSize', 'pageToken', 'startTime'],
        relative_path='v1b3/projects/{projectId}/jobs/{jobId}/messages',
        request_field='',
        request_type_name='DataflowProjectsJobsMessagesListRequest',
        response_type_name='ListJobMessagesResponse',
        supports_download=False,
    )

  class ProjectsJobsWorkItemsService(base_api.BaseApiService):
    """Service class for the projects_jobs_workItems resource."""

    _NAME = 'projects_jobs_workItems'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsJobsWorkItemsService, self).__init__(client)
      self._upload_configs = {
          }

    def Lease(self, request, global_params=None):
      r"""Leases a dataflow WorkItem to run.

      Args:
        request: (DataflowProjectsJobsWorkItemsLeaseRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LeaseWorkItemResponse) The response message.
      """
      config = self.GetMethodConfig('Lease')
      return self._RunMethod(
          config, request, global_params=global_params)

    Lease.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.jobs.workItems.lease',
        ordered_params=['projectId', 'jobId'],
        path_params=['jobId', 'projectId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/jobs/{jobId}/workItems:lease',
        request_field='leaseWorkItemRequest',
        request_type_name='DataflowProjectsJobsWorkItemsLeaseRequest',
        response_type_name='LeaseWorkItemResponse',
        supports_download=False,
    )

    def ReportStatus(self, request, global_params=None):
      r"""Reports the status of dataflow WorkItems leased by a worker.

      Args:
        request: (DataflowProjectsJobsWorkItemsReportStatusRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReportWorkItemStatusResponse) The response message.
      """
      config = self.GetMethodConfig('ReportStatus')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReportStatus.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.jobs.workItems.reportStatus',
        ordered_params=['projectId', 'jobId'],
        path_params=['jobId', 'projectId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/jobs/{jobId}/workItems:reportStatus',
        request_field='reportWorkItemStatusRequest',
        request_type_name='DataflowProjectsJobsWorkItemsReportStatusRequest',
        response_type_name='ReportWorkItemStatusResponse',
        supports_download=False,
    )

  class ProjectsJobsService(base_api.BaseApiService):
    """Service class for the projects_jobs resource."""

    _NAME = 'projects_jobs'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsJobsService, self).__init__(client)
      self._upload_configs = {
          }

    def Aggregated(self, request, global_params=None):
      r"""List the jobs of a project across all regions.

      Args:
        request: (DataflowProjectsJobsAggregatedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListJobsResponse) The response message.
      """
      config = self.GetMethodConfig('Aggregated')
      return self._RunMethod(
          config, request, global_params=global_params)

    Aggregated.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.jobs.aggregated',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=['filter', 'location', 'name', 'pageSize', 'pageToken', 'view'],
        relative_path='v1b3/projects/{projectId}/jobs:aggregated',
        request_field='',
        request_type_name='DataflowProjectsJobsAggregatedRequest',
        response_type_name='ListJobsResponse',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a Cloud Dataflow job. To create a job, we recommend using `projects.locations.jobs.create` with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using `projects.jobs.create` is not recommended, as your job will always start in `us-central1`. Do not enter confidential information when you supply string values using the API.

      Args:
        request: (DataflowProjectsJobsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Job) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.jobs.create',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=['location', 'replaceJobId', 'view'],
        relative_path='v1b3/projects/{projectId}/jobs',
        request_field='job',
        request_type_name='DataflowProjectsJobsCreateRequest',
        response_type_name='Job',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the state of the specified Cloud Dataflow job. To get the state of a job, we recommend using `projects.locations.jobs.get` with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using `projects.jobs.get` is not recommended, as you can only get the state of jobs that are running in `us-central1`.

      Args:
        request: (DataflowProjectsJobsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Job) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.jobs.get',
        ordered_params=['projectId', 'jobId'],
        path_params=['jobId', 'projectId'],
        query_params=['location', 'view'],
        relative_path='v1b3/projects/{projectId}/jobs/{jobId}',
        request_field='',
        request_type_name='DataflowProjectsJobsGetRequest',
        response_type_name='Job',
        supports_download=False,
    )

    def GetMetrics(self, request, global_params=None):
      r"""Request the job status. To request the status of a job, we recommend using `projects.locations.jobs.getMetrics` with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using `projects.jobs.getMetrics` is not recommended, as you can only request the status of jobs that are running in `us-central1`.

      Args:
        request: (DataflowProjectsJobsGetMetricsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (JobMetrics) The response message.
      """
      config = self.GetMethodConfig('GetMetrics')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetMetrics.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.jobs.getMetrics',
        ordered_params=['projectId', 'jobId'],
        path_params=['jobId', 'projectId'],
        query_params=['location', 'startTime'],
        relative_path='v1b3/projects/{projectId}/jobs/{jobId}/metrics',
        request_field='',
        request_type_name='DataflowProjectsJobsGetMetricsRequest',
        response_type_name='JobMetrics',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List the jobs of a project. To list the jobs of a project in a region, we recommend using `projects.locations.jobs.list` with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). To list the all jobs across all regions, use `projects.jobs.aggregated`. Using `projects.jobs.list` is not recommended, as you can only get the list of jobs that are running in `us-central1`.

      Args:
        request: (DataflowProjectsJobsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListJobsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.jobs.list',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=['filter', 'location', 'name', 'pageSize', 'pageToken', 'view'],
        relative_path='v1b3/projects/{projectId}/jobs',
        request_field='',
        request_type_name='DataflowProjectsJobsListRequest',
        response_type_name='ListJobsResponse',
        supports_download=False,
    )

    def Snapshot(self, request, global_params=None):
      r"""Snapshot the state of a streaming job.

      Args:
        request: (DataflowProjectsJobsSnapshotRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Snapshot) The response message.
      """
      config = self.GetMethodConfig('Snapshot')
      return self._RunMethod(
          config, request, global_params=global_params)

    Snapshot.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.jobs.snapshot',
        ordered_params=['projectId', 'jobId'],
        path_params=['jobId', 'projectId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/jobs/{jobId}:snapshot',
        request_field='snapshotJobRequest',
        request_type_name='DataflowProjectsJobsSnapshotRequest',
        response_type_name='Snapshot',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the state of an existing Cloud Dataflow job. To update the state of an existing job, we recommend using `projects.locations.jobs.update` with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using `projects.jobs.update` is not recommended, as you can only update the state of jobs that are running in `us-central1`.

      Args:
        request: (DataflowProjectsJobsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Job) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='dataflow.projects.jobs.update',
        ordered_params=['projectId', 'jobId'],
        path_params=['jobId', 'projectId'],
        query_params=['location'],
        relative_path='v1b3/projects/{projectId}/jobs/{jobId}',
        request_field='job',
        request_type_name='DataflowProjectsJobsUpdateRequest',
        response_type_name='Job',
        supports_download=False,
    )

  class ProjectsLocationsDeploymentsService(base_api.BaseApiService):
    """Service class for the projects_locations_deployments resource."""

    _NAME = 'projects_locations_deployments'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsLocationsDeploymentsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Request that creates a new `Deployment`. The result is an `Operation` which can be used to track the creation process. This process usually takes a few seconds, but can sometimes take much longer. The tracking `Operation` is automatically deleted after a few hours, so there is no need to call `DeleteOperation`.

      Args:
        request: (DataflowProjectsLocationsDeploymentsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1b3/projects/{projectsId}/locations/{locationsId}/deployments',
        http_method='POST',
        method_id='dataflow.projects.locations.deployments.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['deploymentId', 'requestId', 'validateOnly'],
        relative_path='v1b3/{+parent}/deployments',
        request_field='deployment',
        request_type_name='DataflowProjectsLocationsDeploymentsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Request that deletes `Deployment`. The result is an `Operation` which can be used to track the creation process. This process usually takes a few seconds, but can sometimes take much longer. The tracking `Operation` is automatically deleted after a few hours, so there is no need to call `DeleteOperation`.

      Args:
        request: (DataflowProjectsLocationsDeploymentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1b3/projects/{projectsId}/locations/{locationsId}/deployments/{deploymentsId}',
        http_method='DELETE',
        method_id='dataflow.projects.locations.deployments.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['allowMissing', 'etag', 'validateOnly'],
        relative_path='v1b3/{+name}',
        request_field='',
        request_type_name='DataflowProjectsLocationsDeploymentsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Request to get Deployment.

      Args:
        request: (DataflowProjectsLocationsDeploymentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Deployment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1b3/projects/{projectsId}/locations/{locationsId}/deployments/{deploymentsId}',
        http_method='GET',
        method_id='dataflow.projects.locations.deployments.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['view'],
        relative_path='v1b3/{+name}',
        request_field='',
        request_type_name='DataflowProjectsLocationsDeploymentsGetRequest',
        response_type_name='Deployment',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Request that lists `Deployments`.

      Args:
        request: (DataflowProjectsLocationsDeploymentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDeploymentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1b3/projects/{projectsId}/locations/{locationsId}/deployments',
        http_method='GET',
        method_id='dataflow.projects.locations.deployments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1b3/{+parent}/deployments',
        request_field='',
        request_type_name='DataflowProjectsLocationsDeploymentsListRequest',
        response_type_name='ListDeploymentsResponse',
        supports_download=False,
    )

    def ListRevisions(self, request, global_params=None):
      r"""Request that lists revisions of a `Deployment`.

      Args:
        request: (DataflowProjectsLocationsDeploymentsListRevisionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDeploymentRevisionsResponse) The response message.
      """
      config = self.GetMethodConfig('ListRevisions')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListRevisions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1b3/projects/{projectsId}/locations/{locationsId}/deployments/{deploymentsId}:listRevisions',
        http_method='GET',
        method_id='dataflow.projects.locations.deployments.listRevisions',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1b3/{+name}:listRevisions',
        request_field='',
        request_type_name='DataflowProjectsLocationsDeploymentsListRevisionsRequest',
        response_type_name='ListDeploymentRevisionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Request that updates or optionally creates a new `Deployment`. The result is an `Operation` which can be used to track the update/creation process. This process usually takes a few seconds, but can sometimes take much longer. The tracking `Operation` is automatically deleted after a few hours, so there is no need to call `DeleteOperation`.

      Args:
        request: (DataflowProjectsLocationsDeploymentsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1b3/projects/{projectsId}/locations/{locationsId}/deployments/{deploymentsId}',
        http_method='PATCH',
        method_id='dataflow.projects.locations.deployments.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['allowMissing', 'requestId', 'updateMask', 'validateOnly'],
        relative_path='v1b3/{+name}',
        request_field='deployment',
        request_type_name='DataflowProjectsLocationsDeploymentsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Rollback(self, request, global_params=None):
      r"""Request that rollback `Deployment` to any of the previous revisions.

      Args:
        request: (DataflowProjectsLocationsDeploymentsRollbackRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Rollback')
      return self._RunMethod(
          config, request, global_params=global_params)

    Rollback.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1b3/projects/{projectsId}/locations/{locationsId}/deployments/{deploymentsId}:rollback',
        http_method='POST',
        method_id='dataflow.projects.locations.deployments.rollback',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1b3/{+name}:rollback',
        request_field='rollbackDeploymentRequest',
        request_type_name='DataflowProjectsLocationsDeploymentsRollbackRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsFlexTemplatesService(base_api.BaseApiService):
    """Service class for the projects_locations_flexTemplates resource."""

    _NAME = 'projects_locations_flexTemplates'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsLocationsFlexTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Launch(self, request, global_params=None):
      r"""Launch a job with a FlexTemplate.

      Args:
        request: (DataflowProjectsLocationsFlexTemplatesLaunchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LaunchFlexTemplateResponse) The response message.
      """
      config = self.GetMethodConfig('Launch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Launch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.locations.flexTemplates.launch',
        ordered_params=['projectId', 'location'],
        path_params=['location', 'projectId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/locations/{location}/flexTemplates:launch',
        request_field='launchFlexTemplateRequest',
        request_type_name='DataflowProjectsLocationsFlexTemplatesLaunchRequest',
        response_type_name='LaunchFlexTemplateResponse',
        supports_download=False,
    )

  class ProjectsLocationsJobsDebugService(base_api.BaseApiService):
    """Service class for the projects_locations_jobs_debug resource."""

    _NAME = 'projects_locations_jobs_debug'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsLocationsJobsDebugService, self).__init__(client)
      self._upload_configs = {
          }

    def GetConfig(self, request, global_params=None):
      r"""Get encoded debug configuration for component. Not cacheable.

      Args:
        request: (DataflowProjectsLocationsJobsDebugGetConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetDebugConfigResponse) The response message.
      """
      config = self.GetMethodConfig('GetConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.locations.jobs.debug.getConfig',
        ordered_params=['projectId', 'location', 'jobId'],
        path_params=['jobId', 'location', 'projectId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/debug/getConfig',
        request_field='getDebugConfigRequest',
        request_type_name='DataflowProjectsLocationsJobsDebugGetConfigRequest',
        response_type_name='GetDebugConfigResponse',
        supports_download=False,
    )

    def SendCapture(self, request, global_params=None):
      r"""Send encoded debug capture data for component.

      Args:
        request: (DataflowProjectsLocationsJobsDebugSendCaptureRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SendDebugCaptureResponse) The response message.
      """
      config = self.GetMethodConfig('SendCapture')
      return self._RunMethod(
          config, request, global_params=global_params)

    SendCapture.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.locations.jobs.debug.sendCapture',
        ordered_params=['projectId', 'location', 'jobId'],
        path_params=['jobId', 'location', 'projectId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/debug/sendCapture',
        request_field='sendDebugCaptureRequest',
        request_type_name='DataflowProjectsLocationsJobsDebugSendCaptureRequest',
        response_type_name='SendDebugCaptureResponse',
        supports_download=False,
    )

  class ProjectsLocationsJobsMessagesService(base_api.BaseApiService):
    """Service class for the projects_locations_jobs_messages resource."""

    _NAME = 'projects_locations_jobs_messages'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsLocationsJobsMessagesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Request the job status. To request the status of a job, we recommend using `projects.locations.jobs.messages.list` with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using `projects.jobs.messages.list` is not recommended, as you can only request the status of jobs that are running in `us-central1`.

      Args:
        request: (DataflowProjectsLocationsJobsMessagesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListJobMessagesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.locations.jobs.messages.list',
        ordered_params=['projectId', 'location', 'jobId'],
        path_params=['jobId', 'location', 'projectId'],
        query_params=['endTime', 'minimumImportance', 'pageSize', 'pageToken', 'startTime'],
        relative_path='v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/messages',
        request_field='',
        request_type_name='DataflowProjectsLocationsJobsMessagesListRequest',
        response_type_name='ListJobMessagesResponse',
        supports_download=False,
    )

  class ProjectsLocationsJobsSnapshotsService(base_api.BaseApiService):
    """Service class for the projects_locations_jobs_snapshots resource."""

    _NAME = 'projects_locations_jobs_snapshots'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsLocationsJobsSnapshotsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists snapshots.

      Args:
        request: (DataflowProjectsLocationsJobsSnapshotsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSnapshotsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.locations.jobs.snapshots.list',
        ordered_params=['projectId', 'location', 'jobId'],
        path_params=['jobId', 'location', 'projectId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/snapshots',
        request_field='',
        request_type_name='DataflowProjectsLocationsJobsSnapshotsListRequest',
        response_type_name='ListSnapshotsResponse',
        supports_download=False,
    )

  class ProjectsLocationsJobsStagesService(base_api.BaseApiService):
    """Service class for the projects_locations_jobs_stages resource."""

    _NAME = 'projects_locations_jobs_stages'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsLocationsJobsStagesService, self).__init__(client)
      self._upload_configs = {
          }

    def GetExecutionDetails(self, request, global_params=None):
      r"""Request detailed information about the execution status of a stage of the job. EXPERIMENTAL. This API is subject to change or removal without notice.

      Args:
        request: (DataflowProjectsLocationsJobsStagesGetExecutionDetailsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (StageExecutionDetails) The response message.
      """
      config = self.GetMethodConfig('GetExecutionDetails')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetExecutionDetails.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.locations.jobs.stages.getExecutionDetails',
        ordered_params=['projectId', 'location', 'jobId', 'stageId'],
        path_params=['jobId', 'location', 'projectId', 'stageId'],
        query_params=['endTime', 'pageSize', 'pageToken', 'startTime'],
        relative_path='v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/stages/{stageId}/executionDetails',
        request_field='',
        request_type_name='DataflowProjectsLocationsJobsStagesGetExecutionDetailsRequest',
        response_type_name='StageExecutionDetails',
        supports_download=False,
    )

  class ProjectsLocationsJobsWorkItemsService(base_api.BaseApiService):
    """Service class for the projects_locations_jobs_workItems resource."""

    _NAME = 'projects_locations_jobs_workItems'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsLocationsJobsWorkItemsService, self).__init__(client)
      self._upload_configs = {
          }

    def Lease(self, request, global_params=None):
      r"""Leases a dataflow WorkItem to run.

      Args:
        request: (DataflowProjectsLocationsJobsWorkItemsLeaseRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LeaseWorkItemResponse) The response message.
      """
      config = self.GetMethodConfig('Lease')
      return self._RunMethod(
          config, request, global_params=global_params)

    Lease.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.locations.jobs.workItems.lease',
        ordered_params=['projectId', 'location', 'jobId'],
        path_params=['jobId', 'location', 'projectId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/workItems:lease',
        request_field='leaseWorkItemRequest',
        request_type_name='DataflowProjectsLocationsJobsWorkItemsLeaseRequest',
        response_type_name='LeaseWorkItemResponse',
        supports_download=False,
    )

    def ReportStatus(self, request, global_params=None):
      r"""Reports the status of dataflow WorkItems leased by a worker.

      Args:
        request: (DataflowProjectsLocationsJobsWorkItemsReportStatusRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReportWorkItemStatusResponse) The response message.
      """
      config = self.GetMethodConfig('ReportStatus')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReportStatus.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.locations.jobs.workItems.reportStatus',
        ordered_params=['projectId', 'location', 'jobId'],
        path_params=['jobId', 'location', 'projectId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/workItems:reportStatus',
        request_field='reportWorkItemStatusRequest',
        request_type_name='DataflowProjectsLocationsJobsWorkItemsReportStatusRequest',
        response_type_name='ReportWorkItemStatusResponse',
        supports_download=False,
    )

  class ProjectsLocationsJobsService(base_api.BaseApiService):
    """Service class for the projects_locations_jobs resource."""

    _NAME = 'projects_locations_jobs'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsLocationsJobsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a Cloud Dataflow job. To create a job, we recommend using `projects.locations.jobs.create` with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using `projects.jobs.create` is not recommended, as your job will always start in `us-central1`. Do not enter confidential information when you supply string values using the API.

      Args:
        request: (DataflowProjectsLocationsJobsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Job) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.locations.jobs.create',
        ordered_params=['projectId', 'location'],
        path_params=['location', 'projectId'],
        query_params=['replaceJobId', 'view'],
        relative_path='v1b3/projects/{projectId}/locations/{location}/jobs',
        request_field='job',
        request_type_name='DataflowProjectsLocationsJobsCreateRequest',
        response_type_name='Job',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the state of the specified Cloud Dataflow job. To get the state of a job, we recommend using `projects.locations.jobs.get` with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using `projects.jobs.get` is not recommended, as you can only get the state of jobs that are running in `us-central1`.

      Args:
        request: (DataflowProjectsLocationsJobsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Job) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.locations.jobs.get',
        ordered_params=['projectId', 'location', 'jobId'],
        path_params=['jobId', 'location', 'projectId'],
        query_params=['view'],
        relative_path='v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}',
        request_field='',
        request_type_name='DataflowProjectsLocationsJobsGetRequest',
        response_type_name='Job',
        supports_download=False,
    )

    def GetExecutionDetails(self, request, global_params=None):
      r"""Request detailed information about the execution status of the job. EXPERIMENTAL. This API is subject to change or removal without notice.

      Args:
        request: (DataflowProjectsLocationsJobsGetExecutionDetailsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (JobExecutionDetails) The response message.
      """
      config = self.GetMethodConfig('GetExecutionDetails')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetExecutionDetails.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.locations.jobs.getExecutionDetails',
        ordered_params=['projectId', 'location', 'jobId'],
        path_params=['jobId', 'location', 'projectId'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/executionDetails',
        request_field='',
        request_type_name='DataflowProjectsLocationsJobsGetExecutionDetailsRequest',
        response_type_name='JobExecutionDetails',
        supports_download=False,
    )

    def GetMetrics(self, request, global_params=None):
      r"""Request the job status. To request the status of a job, we recommend using `projects.locations.jobs.getMetrics` with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using `projects.jobs.getMetrics` is not recommended, as you can only request the status of jobs that are running in `us-central1`.

      Args:
        request: (DataflowProjectsLocationsJobsGetMetricsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (JobMetrics) The response message.
      """
      config = self.GetMethodConfig('GetMetrics')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetMetrics.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.locations.jobs.getMetrics',
        ordered_params=['projectId', 'location', 'jobId'],
        path_params=['jobId', 'location', 'projectId'],
        query_params=['startTime'],
        relative_path='v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/metrics',
        request_field='',
        request_type_name='DataflowProjectsLocationsJobsGetMetricsRequest',
        response_type_name='JobMetrics',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List the jobs of a project. To list the jobs of a project in a region, we recommend using `projects.locations.jobs.list` with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). To list the all jobs across all regions, use `projects.jobs.aggregated`. Using `projects.jobs.list` is not recommended, as you can only get the list of jobs that are running in `us-central1`.

      Args:
        request: (DataflowProjectsLocationsJobsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListJobsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.locations.jobs.list',
        ordered_params=['projectId', 'location'],
        path_params=['location', 'projectId'],
        query_params=['filter', 'name', 'pageSize', 'pageToken', 'view'],
        relative_path='v1b3/projects/{projectId}/locations/{location}/jobs',
        request_field='',
        request_type_name='DataflowProjectsLocationsJobsListRequest',
        response_type_name='ListJobsResponse',
        supports_download=False,
    )

    def Snapshot(self, request, global_params=None):
      r"""Snapshot the state of a streaming job.

      Args:
        request: (DataflowProjectsLocationsJobsSnapshotRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Snapshot) The response message.
      """
      config = self.GetMethodConfig('Snapshot')
      return self._RunMethod(
          config, request, global_params=global_params)

    Snapshot.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.locations.jobs.snapshot',
        ordered_params=['projectId', 'location', 'jobId'],
        path_params=['jobId', 'location', 'projectId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}:snapshot',
        request_field='snapshotJobRequest',
        request_type_name='DataflowProjectsLocationsJobsSnapshotRequest',
        response_type_name='Snapshot',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the state of an existing Cloud Dataflow job. To update the state of an existing job, we recommend using `projects.locations.jobs.update` with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using `projects.jobs.update` is not recommended, as you can only update the state of jobs that are running in `us-central1`.

      Args:
        request: (DataflowProjectsLocationsJobsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Job) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='dataflow.projects.locations.jobs.update',
        ordered_params=['projectId', 'location', 'jobId'],
        path_params=['jobId', 'location', 'projectId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}',
        request_field='job',
        request_type_name='DataflowProjectsLocationsJobsUpdateRequest',
        response_type_name='Job',
        supports_download=False,
    )

  class ProjectsLocationsSnapshotsService(base_api.BaseApiService):
    """Service class for the projects_locations_snapshots resource."""

    _NAME = 'projects_locations_snapshots'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsLocationsSnapshotsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes a snapshot.

      Args:
        request: (DataflowProjectsLocationsSnapshotsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DeleteSnapshotResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='dataflow.projects.locations.snapshots.delete',
        ordered_params=['projectId', 'location', 'snapshotId'],
        path_params=['location', 'projectId', 'snapshotId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/locations/{location}/snapshots/{snapshotId}',
        request_field='',
        request_type_name='DataflowProjectsLocationsSnapshotsDeleteRequest',
        response_type_name='DeleteSnapshotResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets information about a snapshot.

      Args:
        request: (DataflowProjectsLocationsSnapshotsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Snapshot) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.locations.snapshots.get',
        ordered_params=['projectId', 'location', 'snapshotId'],
        path_params=['location', 'projectId', 'snapshotId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/locations/{location}/snapshots/{snapshotId}',
        request_field='',
        request_type_name='DataflowProjectsLocationsSnapshotsGetRequest',
        response_type_name='Snapshot',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists snapshots.

      Args:
        request: (DataflowProjectsLocationsSnapshotsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSnapshotsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.locations.snapshots.list',
        ordered_params=['projectId', 'location'],
        path_params=['location', 'projectId'],
        query_params=['jobId'],
        relative_path='v1b3/projects/{projectId}/locations/{location}/snapshots',
        request_field='',
        request_type_name='DataflowProjectsLocationsSnapshotsListRequest',
        response_type_name='ListSnapshotsResponse',
        supports_download=False,
    )

  class ProjectsLocationsSqlService(base_api.BaseApiService):
    """Service class for the projects_locations_sql resource."""

    _NAME = 'projects_locations_sql'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsLocationsSqlService, self).__init__(client)
      self._upload_configs = {
          }

    def Validate(self, request, global_params=None):
      r"""Validates a GoogleSQL query for Cloud Dataflow syntax. Will always confirm the given query parses correctly, and if able to look up schema information from DataCatalog, will validate that the query analyzes properly as well.

      Args:
        request: (DataflowProjectsLocationsSqlValidateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ValidateResponse) The response message.
      """
      config = self.GetMethodConfig('Validate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Validate.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.locations.sql.validate',
        ordered_params=['projectId', 'location'],
        path_params=['location', 'projectId'],
        query_params=['query'],
        relative_path='v1b3/projects/{projectId}/locations/{location}/sql:validate',
        request_field='',
        request_type_name='DataflowProjectsLocationsSqlValidateRequest',
        response_type_name='ValidateResponse',
        supports_download=False,
    )

  class ProjectsLocationsTemplatesService(base_api.BaseApiService):
    """Service class for the projects_locations_templates resource."""

    _NAME = 'projects_locations_templates'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsLocationsTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a Cloud Dataflow job from a template. Do not enter confidential information when you supply string values using the API.

      Args:
        request: (DataflowProjectsLocationsTemplatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Job) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.locations.templates.create',
        ordered_params=['projectId', 'location'],
        path_params=['location', 'projectId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/locations/{location}/templates',
        request_field='createJobFromTemplateRequest',
        request_type_name='DataflowProjectsLocationsTemplatesCreateRequest',
        response_type_name='Job',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get the template associated with a template.

      Args:
        request: (DataflowProjectsLocationsTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetTemplateResponse) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.locations.templates.get',
        ordered_params=['projectId', 'location'],
        path_params=['location', 'projectId'],
        query_params=['gcsPath', 'view'],
        relative_path='v1b3/projects/{projectId}/locations/{location}/templates:get',
        request_field='',
        request_type_name='DataflowProjectsLocationsTemplatesGetRequest',
        response_type_name='GetTemplateResponse',
        supports_download=False,
    )

    def Launch(self, request, global_params=None):
      r"""Launch a template.

      Args:
        request: (DataflowProjectsLocationsTemplatesLaunchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LaunchTemplateResponse) The response message.
      """
      config = self.GetMethodConfig('Launch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Launch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.locations.templates.launch',
        ordered_params=['projectId', 'location'],
        path_params=['location', 'projectId'],
        query_params=['dynamicTemplate_gcsPath', 'dynamicTemplate_stagingLocation', 'gcsPath', 'validateOnly'],
        relative_path='v1b3/projects/{projectId}/locations/{location}/templates:launch',
        request_field='launchTemplateParameters',
        request_type_name='DataflowProjectsLocationsTemplatesLaunchRequest',
        response_type_name='LaunchTemplateResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def WorkerMessages(self, request, global_params=None):
      r"""Send a worker_message to the service.

      Args:
        request: (DataflowProjectsLocationsWorkerMessagesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SendWorkerMessagesResponse) The response message.
      """
      config = self.GetMethodConfig('WorkerMessages')
      return self._RunMethod(
          config, request, global_params=global_params)

    WorkerMessages.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.locations.workerMessages',
        ordered_params=['projectId', 'location'],
        path_params=['location', 'projectId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/locations/{location}/WorkerMessages',
        request_field='sendWorkerMessagesRequest',
        request_type_name='DataflowProjectsLocationsWorkerMessagesRequest',
        response_type_name='SendWorkerMessagesResponse',
        supports_download=False,
    )

  class ProjectsSnapshotsService(base_api.BaseApiService):
    """Service class for the projects_snapshots resource."""

    _NAME = 'projects_snapshots'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsSnapshotsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a snapshot.

      Args:
        request: (DataflowProjectsSnapshotsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Snapshot) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.snapshots.get',
        ordered_params=['projectId', 'snapshotId'],
        path_params=['projectId', 'snapshotId'],
        query_params=['location'],
        relative_path='v1b3/projects/{projectId}/snapshots/{snapshotId}',
        request_field='',
        request_type_name='DataflowProjectsSnapshotsGetRequest',
        response_type_name='Snapshot',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists snapshots.

      Args:
        request: (DataflowProjectsSnapshotsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSnapshotsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.snapshots.list',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=['jobId', 'location'],
        relative_path='v1b3/projects/{projectId}/snapshots',
        request_field='',
        request_type_name='DataflowProjectsSnapshotsListRequest',
        response_type_name='ListSnapshotsResponse',
        supports_download=False,
    )

  class ProjectsTemplateVersionsService(base_api.BaseApiService):
    """Service class for the projects_templateVersions resource."""

    _NAME = 'projects_templateVersions'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsTemplateVersionsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""List TemplateVersions using project_id and an optional display_name field. List all the TemplateVersions in the Template if display set. List all the TemplateVersions in the Project if display_name not set.

      Args:
        request: (DataflowProjectsTemplateVersionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTemplateVersionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1b3/projects/{projectsId}/templateVersions',
        http_method='GET',
        method_id='dataflow.projects.templateVersions.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1b3/{+parent}/templateVersions',
        request_field='',
        request_type_name='DataflowProjectsTemplateVersionsListRequest',
        response_type_name='ListTemplateVersionsResponse',
        supports_download=False,
    )

  class ProjectsTemplatesService(base_api.BaseApiService):
    """Service class for the projects_templates resource."""

    _NAME = 'projects_templates'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a Cloud Dataflow job from a template. Do not enter confidential information when you supply string values using the API.

      Args:
        request: (DataflowProjectsTemplatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Job) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.templates.create',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/templates',
        request_field='createJobFromTemplateRequest',
        request_type_name='DataflowProjectsTemplatesCreateRequest',
        response_type_name='Job',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get the template associated with a template.

      Args:
        request: (DataflowProjectsTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetTemplateResponse) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='dataflow.projects.templates.get',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=['gcsPath', 'location', 'view'],
        relative_path='v1b3/projects/{projectId}/templates:get',
        request_field='',
        request_type_name='DataflowProjectsTemplatesGetRequest',
        response_type_name='GetTemplateResponse',
        supports_download=False,
    )

    def Launch(self, request, global_params=None):
      r"""Launch a template.

      Args:
        request: (DataflowProjectsTemplatesLaunchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LaunchTemplateResponse) The response message.
      """
      config = self.GetMethodConfig('Launch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Launch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.templates.launch',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=['dynamicTemplate_gcsPath', 'dynamicTemplate_stagingLocation', 'gcsPath', 'location', 'validateOnly'],
        relative_path='v1b3/projects/{projectId}/templates:launch',
        request_field='launchTemplateParameters',
        request_type_name='DataflowProjectsTemplatesLaunchRequest',
        response_type_name='LaunchTemplateResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(DataflowV1b3.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

    def DeleteSnapshots(self, request, global_params=None):
      r"""Deletes a snapshot.

      Args:
        request: (DataflowProjectsDeleteSnapshotsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DeleteSnapshotResponse) The response message.
      """
      config = self.GetMethodConfig('DeleteSnapshots')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteSnapshots.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='dataflow.projects.deleteSnapshots',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=['location', 'snapshotId'],
        relative_path='v1b3/projects/{projectId}/snapshots',
        request_field='',
        request_type_name='DataflowProjectsDeleteSnapshotsRequest',
        response_type_name='DeleteSnapshotResponse',
        supports_download=False,
    )

    def WorkerMessages(self, request, global_params=None):
      r"""Send a worker_message to the service.

      Args:
        request: (DataflowProjectsWorkerMessagesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SendWorkerMessagesResponse) The response message.
      """
      config = self.GetMethodConfig('WorkerMessages')
      return self._RunMethod(
          config, request, global_params=global_params)

    WorkerMessages.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='dataflow.projects.workerMessages',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=[],
        relative_path='v1b3/projects/{projectId}/WorkerMessages',
        request_field='sendWorkerMessagesRequest',
        request_type_name='DataflowProjectsWorkerMessagesRequest',
        response_type_name='SendWorkerMessagesResponse',
        supports_download=False,
    )
