"""Generated client library for container version v1alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.container.v1alpha1 import container_v1alpha1_messages as messages


class ContainerV1alpha1(base_api.BaseApiClient):
  """Generated client library for service container version v1alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://container.googleapis.com/'
  MTLS_BASE_URL = 'https://container.mtls.googleapis.com/'

  _PACKAGE = 'container'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1alpha1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'ContainerV1alpha1'
  _URL_VERSION = 'v1alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new container handle."""
    url = url or self.BASE_URL
    super(ContainerV1alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_aggregated_usableSubnetworks = self.ProjectsAggregatedUsableSubnetworksService(self)
    self.projects_aggregated = self.ProjectsAggregatedService(self)
    self.projects_locations_clusters_nodePools = self.ProjectsLocationsClustersNodePoolsService(self)
    self.projects_locations_clusters_well_known = self.ProjectsLocationsClustersWellKnownService(self)
    self.projects_locations_clusters = self.ProjectsLocationsClustersService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects_zones_clusters_nodePools = self.ProjectsZonesClustersNodePoolsService(self)
    self.projects_zones_clusters = self.ProjectsZonesClustersService(self)
    self.projects_zones_operations = self.ProjectsZonesOperationsService(self)
    self.projects_zones = self.ProjectsZonesService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsAggregatedUsableSubnetworksService(base_api.BaseApiService):
    """Service class for the projects_aggregated_usableSubnetworks resource."""

    _NAME = 'projects_aggregated_usableSubnetworks'

    def __init__(self, client):
      super(ContainerV1alpha1.ProjectsAggregatedUsableSubnetworksService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists subnetworks that can be used for creating clusters in a project.

      Args:
        request: (ContainerProjectsAggregatedUsableSubnetworksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListUsableSubnetworksResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/aggregated/usableSubnetworks',
        http_method='GET',
        method_id='container.projects.aggregated.usableSubnetworks.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/aggregated/usableSubnetworks',
        request_field='',
        request_type_name='ContainerProjectsAggregatedUsableSubnetworksListRequest',
        response_type_name='ListUsableSubnetworksResponse',
        supports_download=False,
    )

  class ProjectsAggregatedService(base_api.BaseApiService):
    """Service class for the projects_aggregated resource."""

    _NAME = 'projects_aggregated'

    def __init__(self, client):
      super(ContainerV1alpha1.ProjectsAggregatedService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLocationsClustersNodePoolsService(base_api.BaseApiService):
    """Service class for the projects_locations_clusters_nodePools resource."""

    _NAME = 'projects_locations_clusters_nodePools'

    def __init__(self, client):
      super(ContainerV1alpha1.ProjectsLocationsClustersNodePoolsService, self).__init__(client)
      self._upload_configs = {
          }

    def CompleteUpgrade(self, request, global_params=None):
      r"""CompleteNodePoolUpgrade will signal an on-going node pool upgrade to complete.

      Args:
        request: (ContainerProjectsLocationsClustersNodePoolsCompleteUpgradeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('CompleteUpgrade')
      return self._RunMethod(
          config, request, global_params=global_params)

    CompleteUpgrade.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}:completeUpgrade',
        http_method='POST',
        method_id='container.projects.locations.clusters.nodePools.completeUpgrade',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:completeUpgrade',
        request_field='completeNodePoolUpgradeRequest',
        request_type_name='ContainerProjectsLocationsClustersNodePoolsCompleteUpgradeRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a node pool for a cluster.

      Args:
        request: (CreateNodePoolRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools',
        http_method='POST',
        method_id='container.projects.locations.clusters.nodePools.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha1/{+parent}/nodePools',
        request_field='<request>',
        request_type_name='CreateNodePoolRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a node pool from a cluster.

      Args:
        request: (ContainerProjectsLocationsClustersNodePoolsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}',
        http_method='DELETE',
        method_id='container.projects.locations.clusters.nodePools.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['clusterId', 'nodePoolId', 'projectId', 'zone'],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='ContainerProjectsLocationsClustersNodePoolsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the requested node pool.

      Args:
        request: (ContainerProjectsLocationsClustersNodePoolsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodePool) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}',
        http_method='GET',
        method_id='container.projects.locations.clusters.nodePools.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['clusterId', 'nodePoolId', 'projectId', 'zone'],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='ContainerProjectsLocationsClustersNodePoolsGetRequest',
        response_type_name='NodePool',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the node pools for a cluster.

      Args:
        request: (ContainerProjectsLocationsClustersNodePoolsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNodePoolsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools',
        http_method='GET',
        method_id='container.projects.locations.clusters.nodePools.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['clusterId', 'projectId', 'zone'],
        relative_path='v1alpha1/{+parent}/nodePools',
        request_field='',
        request_type_name='ContainerProjectsLocationsClustersNodePoolsListRequest',
        response_type_name='ListNodePoolsResponse',
        supports_download=False,
    )

    def Rollback(self, request, global_params=None):
      r"""Rolls back a previously Aborted or Failed NodePool upgrade. This makes no changes if the last upgrade successfully completed.

      Args:
        request: (RollbackNodePoolUpgradeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Rollback')
      return self._RunMethod(
          config, request, global_params=global_params)

    Rollback.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}:rollback',
        http_method='POST',
        method_id='container.projects.locations.clusters.nodePools.rollback',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:rollback',
        request_field='<request>',
        request_type_name='RollbackNodePoolUpgradeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetAutoscaling(self, request, global_params=None):
      r"""Sets the autoscaling settings of the specified node pool.

      Args:
        request: (SetNodePoolAutoscalingRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetAutoscaling')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetAutoscaling.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}:setAutoscaling',
        http_method='POST',
        method_id='container.projects.locations.clusters.nodePools.setAutoscaling',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:setAutoscaling',
        request_field='<request>',
        request_type_name='SetNodePoolAutoscalingRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetManagement(self, request, global_params=None):
      r"""Sets the NodeManagement options for a node pool.

      Args:
        request: (SetNodePoolManagementRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetManagement')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetManagement.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}:setManagement',
        http_method='POST',
        method_id='container.projects.locations.clusters.nodePools.setManagement',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:setManagement',
        request_field='<request>',
        request_type_name='SetNodePoolManagementRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetSize(self, request, global_params=None):
      r"""SetNodePoolSizeRequest sets the size of a node pool. The new size will be used for all replicas, including future replicas created by modifying NodePool.locations.

      Args:
        request: (SetNodePoolSizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSize')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSize.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}:setSize',
        http_method='POST',
        method_id='container.projects.locations.clusters.nodePools.setSize',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:setSize',
        request_field='<request>',
        request_type_name='SetNodePoolSizeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the version and/or image type of the specified node pool.

      Args:
        request: (UpdateNodePoolRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}',
        http_method='PUT',
        method_id='container.projects.locations.clusters.nodePools.update',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='<request>',
        request_type_name='UpdateNodePoolRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsClustersWellKnownService(base_api.BaseApiService):
    """Service class for the projects_locations_clusters_well_known resource."""

    _NAME = 'projects_locations_clusters_well_known'

    def __init__(self, client):
      super(ContainerV1alpha1.ProjectsLocationsClustersWellKnownService, self).__init__(client)
      self._upload_configs = {
          }

    def GetOpenid_configuration(self, request, global_params=None):
      r"""Gets the OIDC discovery document for the cluster. See the [OpenID Connect Discovery 1.0 specification](https://openid.net/specs/openid-connect-discovery-1_0.html) for details. This API is not yet intended for general use, and is not available for all clusters.

      Args:
        request: (ContainerProjectsLocationsClustersWellKnownGetOpenidConfigurationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetOpenIDConfigResponse) The response message.
      """
      config = self.GetMethodConfig('GetOpenid_configuration')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetOpenid_configuration.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/.well-known/openid-configuration',
        http_method='GET',
        method_id='container.projects.locations.clusters.well-known.getOpenid-configuration',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha1/{+parent}/.well-known/openid-configuration',
        request_field='',
        request_type_name='ContainerProjectsLocationsClustersWellKnownGetOpenidConfigurationRequest',
        response_type_name='GetOpenIDConfigResponse',
        supports_download=False,
    )

  class ProjectsLocationsClustersService(base_api.BaseApiService):
    """Service class for the projects_locations_clusters resource."""

    _NAME = 'projects_locations_clusters'

    def __init__(self, client):
      super(ContainerV1alpha1.ProjectsLocationsClustersService, self).__init__(client)
      self._upload_configs = {
          }

    def CheckAutopilotCompatibility(self, request, global_params=None):
      r"""Checks the cluster compatibility with Autopilot mode, and returns a list of compatibility issues.

      Args:
        request: (ContainerProjectsLocationsClustersCheckAutopilotCompatibilityRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CheckAutopilotCompatibilityResponse) The response message.
      """
      config = self.GetMethodConfig('CheckAutopilotCompatibility')
      return self._RunMethod(
          config, request, global_params=global_params)

    CheckAutopilotCompatibility.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:checkAutopilotCompatibility',
        http_method='GET',
        method_id='container.projects.locations.clusters.checkAutopilotCompatibility',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:checkAutopilotCompatibility',
        request_field='',
        request_type_name='ContainerProjectsLocationsClustersCheckAutopilotCompatibilityRequest',
        response_type_name='CheckAutopilotCompatibilityResponse',
        supports_download=False,
    )

    def CompleteIpRotation(self, request, global_params=None):
      r"""Completes master IP rotation.

      Args:
        request: (CompleteIPRotationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CompleteIpRotation')
      return self._RunMethod(
          config, request, global_params=global_params)

    CompleteIpRotation.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:completeIpRotation',
        http_method='POST',
        method_id='container.projects.locations.clusters.completeIpRotation',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:completeIpRotation',
        request_field='<request>',
        request_type_name='CompleteIPRotationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a cluster, consisting of the specified number and type of Google Compute Engine instances. By default, the cluster is created in the project's [default network](/compute/docs/networks-and-firewalls#networks). One firewall is added for the cluster. After cluster creation, the kubelet creates routes for each node to allow the containers on that node to communicate with all other instances in the cluster. Finally, an entry is added to the project's global metadata indicating which CIDR range the cluster is using.

      Args:
        request: (CreateClusterRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters',
        http_method='POST',
        method_id='container.projects.locations.clusters.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha1/{+parent}/clusters',
        request_field='<request>',
        request_type_name='CreateClusterRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the cluster, including the Kubernetes endpoint and all worker nodes. Firewalls and routes that were configured during cluster creation are also deleted. Other Google Compute Engine resources that might be in use by the cluster, such as load balancer resources, are not deleted if they weren't present when the cluster was initially created.

      Args:
        request: (ContainerProjectsLocationsClustersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}',
        http_method='DELETE',
        method_id='container.projects.locations.clusters.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['clusterId', 'projectId', 'zone'],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='ContainerProjectsLocationsClustersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the details for a specific cluster.

      Args:
        request: (ContainerProjectsLocationsClustersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Cluster) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}',
        http_method='GET',
        method_id='container.projects.locations.clusters.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['clusterId', 'projectId', 'zone'],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='ContainerProjectsLocationsClustersGetRequest',
        response_type_name='Cluster',
        supports_download=False,
    )

    def GetJwks(self, request, global_params=None):
      r"""Gets the public component of the cluster signing keys in JSON Web Key format. This API is not yet intended for general use, and is not available for all clusters.

      Args:
        request: (ContainerProjectsLocationsClustersGetJwksRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetJSONWebKeysResponse) The response message.
      """
      config = self.GetMethodConfig('GetJwks')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetJwks.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/jwks',
        http_method='GET',
        method_id='container.projects.locations.clusters.getJwks',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha1/{+parent}/jwks',
        request_field='',
        request_type_name='ContainerProjectsLocationsClustersGetJwksRequest',
        response_type_name='GetJSONWebKeysResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all clusters owned by a project in either the specified zone or all zones.

      Args:
        request: (ContainerProjectsLocationsClustersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListClustersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters',
        http_method='GET',
        method_id='container.projects.locations.clusters.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['projectId', 'zone'],
        relative_path='v1alpha1/{+parent}/clusters',
        request_field='',
        request_type_name='ContainerProjectsLocationsClustersListRequest',
        response_type_name='ListClustersResponse',
        supports_download=False,
    )

    def SetAddons(self, request, global_params=None):
      r"""Sets the addons for a specific cluster.

      Args:
        request: (SetAddonsConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetAddons')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetAddons.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setAddons',
        http_method='POST',
        method_id='container.projects.locations.clusters.setAddons',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:setAddons',
        request_field='<request>',
        request_type_name='SetAddonsConfigRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetLegacyAbac(self, request, global_params=None):
      r"""Enables or disables the ABAC authorization mechanism on a cluster.

      Args:
        request: (SetLegacyAbacRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLegacyAbac')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLegacyAbac.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setLegacyAbac',
        http_method='POST',
        method_id='container.projects.locations.clusters.setLegacyAbac',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:setLegacyAbac',
        request_field='<request>',
        request_type_name='SetLegacyAbacRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetLocations(self, request, global_params=None):
      r"""Sets the locations for a specific cluster. Deprecated. Use [projects.locations.clusters.update](/kubernetes-engine/docs/reference/rest/v1alpha1/projects.locations.clusters.update) instead.

      Args:
        request: (SetLocationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLocations')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLocations.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setLocations',
        http_method='POST',
        method_id='container.projects.locations.clusters.setLocations',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:setLocations',
        request_field='<request>',
        request_type_name='SetLocationsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetLogging(self, request, global_params=None):
      r"""Sets the logging service for a specific cluster.

      Args:
        request: (SetLoggingServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLogging')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLogging.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setLogging',
        http_method='POST',
        method_id='container.projects.locations.clusters.setLogging',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:setLogging',
        request_field='<request>',
        request_type_name='SetLoggingServiceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetMaintenancePolicy(self, request, global_params=None):
      r"""Sets the maintenance policy for a cluster.

      Args:
        request: (SetMaintenancePolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMaintenancePolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMaintenancePolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setMaintenancePolicy',
        http_method='POST',
        method_id='container.projects.locations.clusters.setMaintenancePolicy',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:setMaintenancePolicy',
        request_field='<request>',
        request_type_name='SetMaintenancePolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetMasterAuth(self, request, global_params=None):
      r"""Sets master auth materials. Currently supports changing the admin password or a specific cluster, either via password generation or explicitly setting the password. Modify basic_auth.csv and reset the K8S API server.

      Args:
        request: (SetMasterAuthRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMasterAuth')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMasterAuth.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setMasterAuth',
        http_method='POST',
        method_id='container.projects.locations.clusters.setMasterAuth',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:setMasterAuth',
        request_field='<request>',
        request_type_name='SetMasterAuthRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetMonitoring(self, request, global_params=None):
      r"""Sets the monitoring service for a specific cluster.

      Args:
        request: (SetMonitoringServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMonitoring')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMonitoring.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setMonitoring',
        http_method='POST',
        method_id='container.projects.locations.clusters.setMonitoring',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:setMonitoring',
        request_field='<request>',
        request_type_name='SetMonitoringServiceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetNetworkPolicy(self, request, global_params=None):
      r"""Enables or disables Network Policy for a cluster.

      Args:
        request: (SetNetworkPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetNetworkPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetNetworkPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setNetworkPolicy',
        http_method='POST',
        method_id='container.projects.locations.clusters.setNetworkPolicy',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:setNetworkPolicy',
        request_field='<request>',
        request_type_name='SetNetworkPolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetResourceLabels(self, request, global_params=None):
      r"""Sets labels on a cluster.

      Args:
        request: (SetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetResourceLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetResourceLabels.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setResourceLabels',
        http_method='POST',
        method_id='container.projects.locations.clusters.setResourceLabels',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:setResourceLabels',
        request_field='<request>',
        request_type_name='SetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def StartIpRotation(self, request, global_params=None):
      r"""Starts master IP rotation.

      Args:
        request: (StartIPRotationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StartIpRotation')
      return self._RunMethod(
          config, request, global_params=global_params)

    StartIpRotation.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:startIpRotation',
        http_method='POST',
        method_id='container.projects.locations.clusters.startIpRotation',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:startIpRotation',
        request_field='<request>',
        request_type_name='StartIPRotationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the settings for a specific cluster.

      Args:
        request: (UpdateClusterRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}',
        http_method='PUT',
        method_id='container.projects.locations.clusters.update',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='<request>',
        request_type_name='UpdateClusterRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdateMaster(self, request, global_params=None):
      r"""Updates the master for a specific cluster.

      Args:
        request: (UpdateMasterRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateMaster')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateMaster.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:updateMaster',
        http_method='POST',
        method_id='container.projects.locations.clusters.updateMaster',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:updateMaster',
        request_field='<request>',
        request_type_name='UpdateMasterRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(ContainerV1alpha1.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Cancels the specified operation.

      Args:
        request: (CancelOperationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='container.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:cancel',
        request_field='<request>',
        request_type_name='CancelOperationRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the specified operation.

      Args:
        request: (ContainerProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='container.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['operationId', 'projectId', 'zone'],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='ContainerProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all operations in a project in a specific zone or all zones.

      Args:
        request: (ContainerProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='container.projects.locations.operations.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['projectId', 'zone'],
        relative_path='v1alpha1/{+parent}/operations',
        request_field='',
        request_type_name='ContainerProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(ContainerV1alpha1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetServerConfig(self, request, global_params=None):
      r"""Returns configuration info about the Google Kubernetes Engine service.

      Args:
        request: (ContainerProjectsLocationsGetServerConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServerConfig) The response message.
      """
      config = self.GetMethodConfig('GetServerConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetServerConfig.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/serverConfig',
        http_method='GET',
        method_id='container.projects.locations.getServerConfig',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['projectId', 'zone'],
        relative_path='v1alpha1/{+name}/serverConfig',
        request_field='',
        request_type_name='ContainerProjectsLocationsGetServerConfigRequest',
        response_type_name='ServerConfig',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Fetches locations that offer Google Kubernetes Engine.

      Args:
        request: (ContainerProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations',
        http_method='GET',
        method_id='container.projects.locations.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha1/{+parent}/locations',
        request_field='',
        request_type_name='ContainerProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsZonesClustersNodePoolsService(base_api.BaseApiService):
    """Service class for the projects_zones_clusters_nodePools resource."""

    _NAME = 'projects_zones_clusters_nodePools'

    def __init__(self, client):
      super(ContainerV1alpha1.ProjectsZonesClustersNodePoolsService, self).__init__(client)
      self._upload_configs = {
          }

    def Autoscaling(self, request, global_params=None):
      r"""Sets the autoscaling settings of the specified node pool.

      Args:
        request: (SetNodePoolAutoscalingRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Autoscaling')
      return self._RunMethod(
          config, request, global_params=global_params)

    Autoscaling.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.nodePools.autoscaling',
        ordered_params=['projectId', 'zone', 'clusterId', 'nodePoolId'],
        path_params=['clusterId', 'nodePoolId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/autoscaling',
        request_field='<request>',
        request_type_name='SetNodePoolAutoscalingRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a node pool for a cluster.

      Args:
        request: (CreateNodePoolRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.nodePools.create',
        ordered_params=['projectId', 'zone', 'clusterId'],
        path_params=['clusterId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools',
        request_field='<request>',
        request_type_name='CreateNodePoolRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a node pool from a cluster.

      Args:
        request: (ContainerProjectsZonesClustersNodePoolsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='container.projects.zones.clusters.nodePools.delete',
        ordered_params=['projectId', 'zone', 'clusterId', 'nodePoolId'],
        path_params=['clusterId', 'nodePoolId', 'projectId', 'zone'],
        query_params=['name'],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}',
        request_field='',
        request_type_name='ContainerProjectsZonesClustersNodePoolsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the requested node pool.

      Args:
        request: (ContainerProjectsZonesClustersNodePoolsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodePool) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='container.projects.zones.clusters.nodePools.get',
        ordered_params=['projectId', 'zone', 'clusterId', 'nodePoolId'],
        path_params=['clusterId', 'nodePoolId', 'projectId', 'zone'],
        query_params=['name'],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}',
        request_field='',
        request_type_name='ContainerProjectsZonesClustersNodePoolsGetRequest',
        response_type_name='NodePool',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the node pools for a cluster.

      Args:
        request: (ContainerProjectsZonesClustersNodePoolsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNodePoolsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='container.projects.zones.clusters.nodePools.list',
        ordered_params=['projectId', 'zone', 'clusterId'],
        path_params=['clusterId', 'projectId', 'zone'],
        query_params=['parent'],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools',
        request_field='',
        request_type_name='ContainerProjectsZonesClustersNodePoolsListRequest',
        response_type_name='ListNodePoolsResponse',
        supports_download=False,
    )

    def Rollback(self, request, global_params=None):
      r"""Rolls back a previously Aborted or Failed NodePool upgrade. This makes no changes if the last upgrade successfully completed.

      Args:
        request: (RollbackNodePoolUpgradeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Rollback')
      return self._RunMethod(
          config, request, global_params=global_params)

    Rollback.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.nodePools.rollback',
        ordered_params=['projectId', 'zone', 'clusterId', 'nodePoolId'],
        path_params=['clusterId', 'nodePoolId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}:rollback',
        request_field='<request>',
        request_type_name='RollbackNodePoolUpgradeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetManagement(self, request, global_params=None):
      r"""Sets the NodeManagement options for a node pool.

      Args:
        request: (SetNodePoolManagementRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetManagement')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetManagement.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.nodePools.setManagement',
        ordered_params=['projectId', 'zone', 'clusterId', 'nodePoolId'],
        path_params=['clusterId', 'nodePoolId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/setManagement',
        request_field='<request>',
        request_type_name='SetNodePoolManagementRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetSize(self, request, global_params=None):
      r"""SetNodePoolSizeRequest sets the size of a node pool. The new size will be used for all replicas, including future replicas created by modifying NodePool.locations.

      Args:
        request: (SetNodePoolSizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSize')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSize.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.nodePools.setSize',
        ordered_params=['projectId', 'zone', 'clusterId', 'nodePoolId'],
        path_params=['clusterId', 'nodePoolId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/setSize',
        request_field='<request>',
        request_type_name='SetNodePoolSizeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the version and/or image type of the specified node pool.

      Args:
        request: (UpdateNodePoolRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.nodePools.update',
        ordered_params=['projectId', 'zone', 'clusterId', 'nodePoolId'],
        path_params=['clusterId', 'nodePoolId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/update',
        request_field='<request>',
        request_type_name='UpdateNodePoolRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsZonesClustersService(base_api.BaseApiService):
    """Service class for the projects_zones_clusters resource."""

    _NAME = 'projects_zones_clusters'

    def __init__(self, client):
      super(ContainerV1alpha1.ProjectsZonesClustersService, self).__init__(client)
      self._upload_configs = {
          }

    def Addons(self, request, global_params=None):
      r"""Sets the addons for a specific cluster.

      Args:
        request: (SetAddonsConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Addons')
      return self._RunMethod(
          config, request, global_params=global_params)

    Addons.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.addons',
        ordered_params=['projectId', 'zone', 'clusterId'],
        path_params=['clusterId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/addons',
        request_field='<request>',
        request_type_name='SetAddonsConfigRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def CompleteIpRotation(self, request, global_params=None):
      r"""Completes master IP rotation.

      Args:
        request: (CompleteIPRotationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CompleteIpRotation')
      return self._RunMethod(
          config, request, global_params=global_params)

    CompleteIpRotation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.completeIpRotation',
        ordered_params=['projectId', 'zone', 'clusterId'],
        path_params=['clusterId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:completeIpRotation',
        request_field='<request>',
        request_type_name='CompleteIPRotationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a cluster, consisting of the specified number and type of Google Compute Engine instances. By default, the cluster is created in the project's [default network](/compute/docs/networks-and-firewalls#networks). One firewall is added for the cluster. After cluster creation, the kubelet creates routes for each node to allow the containers on that node to communicate with all other instances in the cluster. Finally, an entry is added to the project's global metadata indicating which CIDR range the cluster is using.

      Args:
        request: (CreateClusterRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.create',
        ordered_params=['projectId', 'zone'],
        path_params=['projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters',
        request_field='<request>',
        request_type_name='CreateClusterRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the cluster, including the Kubernetes endpoint and all worker nodes. Firewalls and routes that were configured during cluster creation are also deleted. Other Google Compute Engine resources that might be in use by the cluster, such as load balancer resources, are not deleted if they weren't present when the cluster was initially created.

      Args:
        request: (ContainerProjectsZonesClustersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='container.projects.zones.clusters.delete',
        ordered_params=['projectId', 'zone', 'clusterId'],
        path_params=['clusterId', 'projectId', 'zone'],
        query_params=['name'],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}',
        request_field='',
        request_type_name='ContainerProjectsZonesClustersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the details for a specific cluster.

      Args:
        request: (ContainerProjectsZonesClustersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Cluster) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='container.projects.zones.clusters.get',
        ordered_params=['projectId', 'zone', 'clusterId'],
        path_params=['clusterId', 'projectId', 'zone'],
        query_params=['name'],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}',
        request_field='',
        request_type_name='ContainerProjectsZonesClustersGetRequest',
        response_type_name='Cluster',
        supports_download=False,
    )

    def LegacyAbac(self, request, global_params=None):
      r"""Enables or disables the ABAC authorization mechanism on a cluster.

      Args:
        request: (SetLegacyAbacRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('LegacyAbac')
      return self._RunMethod(
          config, request, global_params=global_params)

    LegacyAbac.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.legacyAbac',
        ordered_params=['projectId', 'zone', 'clusterId'],
        path_params=['clusterId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/legacyAbac',
        request_field='<request>',
        request_type_name='SetLegacyAbacRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all clusters owned by a project in either the specified zone or all zones.

      Args:
        request: (ContainerProjectsZonesClustersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListClustersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='container.projects.zones.clusters.list',
        ordered_params=['projectId', 'zone'],
        path_params=['projectId', 'zone'],
        query_params=['parent'],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters',
        request_field='',
        request_type_name='ContainerProjectsZonesClustersListRequest',
        response_type_name='ListClustersResponse',
        supports_download=False,
    )

    def Locations(self, request, global_params=None):
      r"""Sets the locations for a specific cluster. Deprecated. Use [projects.locations.clusters.update](/kubernetes-engine/docs/reference/rest/v1alpha1/projects.locations.clusters.update) instead.

      Args:
        request: (SetLocationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Locations')
      return self._RunMethod(
          config, request, global_params=global_params)

    Locations.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.locations',
        ordered_params=['projectId', 'zone', 'clusterId'],
        path_params=['clusterId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/locations',
        request_field='<request>',
        request_type_name='SetLocationsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Logging(self, request, global_params=None):
      r"""Sets the logging service for a specific cluster.

      Args:
        request: (SetLoggingServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Logging')
      return self._RunMethod(
          config, request, global_params=global_params)

    Logging.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.logging',
        ordered_params=['projectId', 'zone', 'clusterId'],
        path_params=['clusterId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/logging',
        request_field='<request>',
        request_type_name='SetLoggingServiceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Master(self, request, global_params=None):
      r"""Updates the master for a specific cluster.

      Args:
        request: (UpdateMasterRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Master')
      return self._RunMethod(
          config, request, global_params=global_params)

    Master.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.master',
        ordered_params=['projectId', 'zone', 'clusterId'],
        path_params=['clusterId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/master',
        request_field='<request>',
        request_type_name='UpdateMasterRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Monitoring(self, request, global_params=None):
      r"""Sets the monitoring service for a specific cluster.

      Args:
        request: (SetMonitoringServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Monitoring')
      return self._RunMethod(
          config, request, global_params=global_params)

    Monitoring.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.monitoring',
        ordered_params=['projectId', 'zone', 'clusterId'],
        path_params=['clusterId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/monitoring',
        request_field='<request>',
        request_type_name='SetMonitoringServiceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def ResourceLabels(self, request, global_params=None):
      r"""Sets labels on a cluster.

      Args:
        request: (SetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ResourceLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    ResourceLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.resourceLabels',
        ordered_params=['projectId', 'zone', 'clusterId'],
        path_params=['clusterId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/resourceLabels',
        request_field='<request>',
        request_type_name='SetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetMaintenancePolicy(self, request, global_params=None):
      r"""Sets the maintenance policy for a cluster.

      Args:
        request: (SetMaintenancePolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMaintenancePolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMaintenancePolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.setMaintenancePolicy',
        ordered_params=['projectId', 'zone', 'clusterId'],
        path_params=['clusterId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setMaintenancePolicy',
        request_field='<request>',
        request_type_name='SetMaintenancePolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetMasterAuth(self, request, global_params=None):
      r"""Sets master auth materials. Currently supports changing the admin password or a specific cluster, either via password generation or explicitly setting the password. Modify basic_auth.csv and reset the K8S API server.

      Args:
        request: (SetMasterAuthRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMasterAuth')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMasterAuth.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.setMasterAuth',
        ordered_params=['projectId', 'zone', 'clusterId'],
        path_params=['clusterId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setMasterAuth',
        request_field='<request>',
        request_type_name='SetMasterAuthRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetNetworkPolicy(self, request, global_params=None):
      r"""Enables or disables Network Policy for a cluster.

      Args:
        request: (SetNetworkPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetNetworkPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetNetworkPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.setNetworkPolicy',
        ordered_params=['projectId', 'zone', 'clusterId'],
        path_params=['clusterId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setNetworkPolicy',
        request_field='<request>',
        request_type_name='SetNetworkPolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def StartIpRotation(self, request, global_params=None):
      r"""Starts master IP rotation.

      Args:
        request: (StartIPRotationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StartIpRotation')
      return self._RunMethod(
          config, request, global_params=global_params)

    StartIpRotation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.clusters.startIpRotation',
        ordered_params=['projectId', 'zone', 'clusterId'],
        path_params=['clusterId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:startIpRotation',
        request_field='<request>',
        request_type_name='StartIPRotationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the settings for a specific cluster.

      Args:
        request: (UpdateClusterRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='container.projects.zones.clusters.update',
        ordered_params=['projectId', 'zone', 'clusterId'],
        path_params=['clusterId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/clusters/{clusterId}',
        request_field='<request>',
        request_type_name='UpdateClusterRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsZonesOperationsService(base_api.BaseApiService):
    """Service class for the projects_zones_operations resource."""

    _NAME = 'projects_zones_operations'

    def __init__(self, client):
      super(ContainerV1alpha1.ProjectsZonesOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Cancels the specified operation.

      Args:
        request: (CancelOperationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='container.projects.zones.operations.cancel',
        ordered_params=['projectId', 'zone', 'operationId'],
        path_params=['operationId', 'projectId', 'zone'],
        query_params=[],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/operations/{operationId}:cancel',
        request_field='<request>',
        request_type_name='CancelOperationRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the specified operation.

      Args:
        request: (ContainerProjectsZonesOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='container.projects.zones.operations.get',
        ordered_params=['projectId', 'zone', 'operationId'],
        path_params=['operationId', 'projectId', 'zone'],
        query_params=['name'],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/operations/{operationId}',
        request_field='',
        request_type_name='ContainerProjectsZonesOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all operations in a project in a specific zone or all zones.

      Args:
        request: (ContainerProjectsZonesOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='container.projects.zones.operations.list',
        ordered_params=['projectId', 'zone'],
        path_params=['projectId', 'zone'],
        query_params=['parent'],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/operations',
        request_field='',
        request_type_name='ContainerProjectsZonesOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsZonesService(base_api.BaseApiService):
    """Service class for the projects_zones resource."""

    _NAME = 'projects_zones'

    def __init__(self, client):
      super(ContainerV1alpha1.ProjectsZonesService, self).__init__(client)
      self._upload_configs = {
          }

    def GetServerconfig(self, request, global_params=None):
      r"""Returns configuration info about the Google Kubernetes Engine service.

      Args:
        request: (ContainerProjectsZonesGetServerconfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServerConfig) The response message.
      """
      config = self.GetMethodConfig('GetServerconfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetServerconfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='container.projects.zones.getServerconfig',
        ordered_params=['projectId', 'zone'],
        path_params=['projectId', 'zone'],
        query_params=['name'],
        relative_path='v1alpha1/projects/{projectId}/zones/{zone}/serverconfig',
        request_field='',
        request_type_name='ContainerProjectsZonesGetServerconfigRequest',
        response_type_name='ServerConfig',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(ContainerV1alpha1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
