# -*- coding: utf-8 -*- #
# Copyright 2022 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Implementation of insights inventory."""

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from googlecloudsdk.calliope import base


@base.ReleaseTracks(base.ReleaseTrack.ALPHA)
class List(base.ListCommand):
  """Lists inventory report configurations."""

  detailed_help = {
      'DESCRIPTION':
          """
      List all inventory reports generated by a given inventory report
      configuration.
      """,
      'EXAMPLES':
          """

      List all inventory reports generated by the inventory report
      configuration "some-id", which is stored in the source bucket
      "my-bucket":

        $ {command} gs://my-bucket some-id

      List buckets with JSON formatting, only returning the "status" key:

        $ {command} gs://my-bucket --format="json(status)"
      """,
  }

  @staticmethod
  def Args(parser):
    parser.add_argument(
        'source_bucket_url',
        help='Indicates URL of the source bucket that contains the inventory '
             'report configuration.')
    parser.add_argument(
        'config_id',
        help='Specifies the UUID of the report configuration that generated the'
             'that generated the.')

  def Run(self, args):
    raise NotImplementedError
