"""Generated message classes for cloudresourcemanager version v1beta1.

Creates, reads, and updates metadata for Google Cloud Platform resource
containers.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'cloudresourcemanager'


class Ancestor(_messages.Message):
  r"""Identifying information for a single ancestor of a project.

  Fields:
    resourceId: Resource id of the ancestor.
  """

  resourceId = _messages.MessageField('ResourceId', 1)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CloudresourcemanagerOrganizationsGetIamPolicyRequest(_messages.Message):
  r"""A CloudresourcemanagerOrganizationsGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    organizationsId: Part of `resource`. REQUIRED: The resource for which the
      policy is being requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  organizationsId = _messages.StringField(2, required=True)


class CloudresourcemanagerOrganizationsGetRequest(_messages.Message):
  r"""A CloudresourcemanagerOrganizationsGetRequest object.

  Fields:
    organizationId: The id of the Organization resource to fetch. This field
      is deprecated and will be removed in v1. Use name instead.
    organizationsId: Part of `name`. The resource name of the Organization to
      fetch. This is the organization's relative path in the API, formatted as
      "organizations/[organizationId]". For example, "organizations/1234".
  """

  organizationId = _messages.StringField(1)
  organizationsId = _messages.StringField(2, required=True)


class CloudresourcemanagerOrganizationsListRequest(_messages.Message):
  r"""A CloudresourcemanagerOrganizationsListRequest object.

  Fields:
    filter: An optional query string used to filter the Organizations to
      return in the response. Filter rules are case-insensitive. Organizations
      may be filtered by `owner.directoryCustomerId` or by `domain`, where the
      domain is a G Suite domain, for example: * Filter
      `owner.directorycustomerid:123456789` returns Organization resources
      with `owner.directory_customer_id` equal to `123456789`. * Filter
      `domain:google.com` returns Organization resources corresponding to the
      domain `google.com`. This field is optional.
    pageSize: The maximum number of Organizations to return in the response.
      This field is optional.
    pageToken: A pagination token returned from a previous call to
      `ListOrganizations` that indicates from where listing should continue.
      This field is optional.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class CloudresourcemanagerOrganizationsSetIamPolicyRequest(_messages.Message):
  r"""A CloudresourcemanagerOrganizationsSetIamPolicyRequest object.

  Fields:
    organizationsId: Part of `resource`. REQUIRED: The resource for which the
      policy is being specified. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  organizationsId = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CloudresourcemanagerOrganizationsTestIamPermissionsRequest(_messages.Message):
  r"""A CloudresourcemanagerOrganizationsTestIamPermissionsRequest object.

  Fields:
    organizationsId: Part of `resource`. REQUIRED: The resource for which the
      policy detail is being requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  organizationsId = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CloudresourcemanagerOrganizationsUpdateRequest(_messages.Message):
  r"""A CloudresourcemanagerOrganizationsUpdateRequest object.

  Fields:
    organization: A Organization resource to be passed as the request body.
    organizationsId: Part of `name`. Output only. The resource name of the
      organization. This is the organization's relative path in the API. Its
      format is "organizations/[organization_id]". For example,
      "organizations/1234".
  """

  organization = _messages.MessageField('Organization', 1)
  organizationsId = _messages.StringField(2, required=True)


class CloudresourcemanagerProjectsCreateRequest(_messages.Message):
  r"""A CloudresourcemanagerProjectsCreateRequest object.

  Fields:
    project: A Project resource to be passed as the request body.
    useLegacyStack: A now unused experiment opt-out option.
  """

  project = _messages.MessageField('Project', 1)
  useLegacyStack = _messages.BooleanField(2)


class CloudresourcemanagerProjectsDeleteRequest(_messages.Message):
  r"""A CloudresourcemanagerProjectsDeleteRequest object.

  Fields:
    projectId: The Project ID (for example, `foo-bar-123`).
  """

  projectId = _messages.StringField(1, required=True)


class CloudresourcemanagerProjectsGetAncestryRequest(_messages.Message):
  r"""A CloudresourcemanagerProjectsGetAncestryRequest object.

  Fields:
    getAncestryRequest: A GetAncestryRequest resource to be passed as the
      request body.
    projectId: Required. The Project ID (for example, `my-project-123`).
  """

  getAncestryRequest = _messages.MessageField('GetAncestryRequest', 1)
  projectId = _messages.StringField(2, required=True)


class CloudresourcemanagerProjectsGetIamPolicyRequest(_messages.Message):
  r"""A CloudresourcemanagerProjectsGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class CloudresourcemanagerProjectsGetRequest(_messages.Message):
  r"""A CloudresourcemanagerProjectsGetRequest object.

  Fields:
    projectId: Required. The Project ID (for example, `my-project-123`).
  """

  projectId = _messages.StringField(1, required=True)


class CloudresourcemanagerProjectsListRequest(_messages.Message):
  r"""A CloudresourcemanagerProjectsListRequest object.

  Fields:
    filter: An expression for filtering the results of the request. Filter
      rules are case insensitive. If multiple fields are included in a filter
      query, the query will return results that match any of the fields. Some
      eligible fields for filtering are: + `name` + `id` + `labels.` (where
      *key* is the name of a label) + `parent.type` + `parent.id` Some
      examples of using labels as filters: | Filter | Description | |---------
      ---------|-----------------------------------------------------| |
      name:how* | The project's name starts with "how". | | name:Howl | The
      project's name is `Howl` or `howl`. | | name:HOWL | Equivalent to above.
      | | NAME:howl | Equivalent to above. | | labels.color:* | The project
      has the label `color`. | | labels.color:red | The project's label
      `color` has the value `red`. | | labels.color:red labels.size:big |The
      project's label `color` has the value `red` and its label `size` has the
      value `big`. | If no filter is specified, the call will return projects
      for which the user has the `resourcemanager.projects.get` permission.
      NOTE: To perform a by-parent query (eg., what projects are directly in a
      Folder), the caller must have the `resourcemanager.projects.list`
      permission on the parent and the filter must contain both a
      `parent.type` and a `parent.id` restriction (example:
      "parent.type:folder parent.id:123"). In this case an alternate search
      index is used which provides more consistent results. Optional.
    pageSize: The maximum number of Projects to return in the response. The
      server can return fewer Projects than requested. If unspecified, server
      picks an appropriate default. Optional.
    pageToken: A pagination token returned from a previous call to
      ListProjects that indicates from where listing should continue.
      Optional.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class CloudresourcemanagerProjectsSetIamPolicyRequest(_messages.Message):
  r"""A CloudresourcemanagerProjectsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CloudresourcemanagerProjectsTestIamPermissionsRequest(_messages.Message):
  r"""A CloudresourcemanagerProjectsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CloudresourcemanagerProjectsUndeleteRequest(_messages.Message):
  r"""A CloudresourcemanagerProjectsUndeleteRequest object.

  Fields:
    projectId: Required. The project ID (for example, `foo-bar-123`).
    undeleteProjectRequest: A UndeleteProjectRequest resource to be passed as
      the request body.
  """

  projectId = _messages.StringField(1, required=True)
  undeleteProjectRequest = _messages.MessageField('UndeleteProjectRequest', 2)


class CreateFolderMetadata(_messages.Message):
  r"""Metadata pertaining to the Folder creation process.

  Fields:
    displayName: The display name of the folder.
    parent: The resource name of the folder or organization we are creating
      the folder under.
  """

  displayName = _messages.StringField(1)
  parent = _messages.StringField(2)


class CreateProjectMetadata(_messages.Message):
  r"""A status object which is used as the `metadata` field for the Operation
  returned by CreateProject. It provides insight for when significant phases
  of Project creation have completed.

  Fields:
    createTime: Creation time of the project creation workflow.
    gettable: True if the project can be retrieved using `GetProject`. No
      other operations on the project are guaranteed to work until the project
      creation is complete.
    ready: True if the project creation process is complete.
  """

  createTime = _messages.StringField(1)
  gettable = _messages.BooleanField(2)
  ready = _messages.BooleanField(3)


class CreateTagBindingMetadata(_messages.Message):
  r"""Runtime operation information for creating a TagValue."""


class CreateTagKeyMetadata(_messages.Message):
  r"""Runtime operation information for creating a TagKey."""


class CreateTagValueMetadata(_messages.Message):
  r"""Runtime operation information for creating a TagValue."""


class DeleteFolderMetadata(_messages.Message):
  r"""A status object which is used as the `metadata` field for the
  `Operation` returned by `DeleteFolder`.
  """



class DeleteOrganizationMetadata(_messages.Message):
  r"""A status object which is used as the `metadata` field for the operation
  returned by DeleteOrganization.
  """



class DeleteProjectMetadata(_messages.Message):
  r"""A status object which is used as the `metadata` field for the Operation
  returned by `DeleteProject`.
  """



class DeleteTagBindingMetadata(_messages.Message):
  r"""Runtime operation information for deleting a TagBinding."""


class DeleteTagKeyMetadata(_messages.Message):
  r"""Runtime operation information for deleting a TagKey."""


class DeleteTagValueMetadata(_messages.Message):
  r"""Runtime operation information for deleting a TagValue."""


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class FolderOperation(_messages.Message):
  r"""Metadata describing a long running folder operation

  Enums:
    OperationTypeValueValuesEnum: The type of this operation.

  Fields:
    destinationParent: The resource name of the folder or organization we are
      either creating the folder under or moving the folder to.
    displayName: The display name of the folder.
    operationType: The type of this operation.
    sourceParent: The resource name of the folder's parent. Only applicable
      when the operation_type is MOVE.
  """

  class OperationTypeValueValuesEnum(_messages.Enum):
    r"""The type of this operation.

    Values:
      OPERATION_TYPE_UNSPECIFIED: Operation type not specified.
      CREATE: A create folder operation.
      MOVE: A move folder operation.
    """
    OPERATION_TYPE_UNSPECIFIED = 0
    CREATE = 1
    MOVE = 2

  destinationParent = _messages.StringField(1)
  displayName = _messages.StringField(2)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 3)
  sourceParent = _messages.StringField(4)


class GetAncestryRequest(_messages.Message):
  r"""The request sent to the
  [google.cloudresourcemanager.projects.v1beta1.DeveloperProjects.GetAncestry]
  method.
  """



class GetAncestryResponse(_messages.Message):
  r"""Response from the projects.getAncestry method.

  Fields:
    ancestor: Ancestors are ordered from bottom to top of the resource
      hierarchy. The first ancestor is the project itself, followed by the
      project's parent, etc.
  """

  ancestor = _messages.MessageField('Ancestor', 1, repeated=True)


class GetIamPolicyRequest(_messages.Message):
  r"""Request message for `GetIamPolicy` method.

  Fields:
    options: OPTIONAL: A `GetPolicyOptions` object for specifying options to
      `GetIamPolicy`.
  """

  options = _messages.MessageField('GetPolicyOptions', 1)


class GetPolicyOptions(_messages.Message):
  r"""Encapsulates settings provided to GetIamPolicy.

  Fields:
    requestedPolicyVersion: Optional. The maximum policy version that will be
      used to format the policy. Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected. Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset. The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1. To learn which resources support conditions in
      their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class ListOrganizationsResponse(_messages.Message):
  r"""The response returned from the `ListOrganizations` method.

  Fields:
    nextPageToken: A pagination token to be used to retrieve the next page of
      results. If the result is too large to fit within the page size
      specified in the request, this field will be set with a token that can
      be used to fetch the next page of results. If this field is empty, it
      indicates that this response contains the last page of results.
    organizations: The list of Organizations that matched the list query,
      possibly paginated.
  """

  nextPageToken = _messages.StringField(1)
  organizations = _messages.MessageField('Organization', 2, repeated=True)


class ListProjectsResponse(_messages.Message):
  r"""A page of the response received from the ListProjects method. A
  paginated response where more pages are available has `next_page_token` set.
  This token can be used in a subsequent request to retrieve the next request
  page.

  Fields:
    nextPageToken: Pagination token. If the result set is too large to fit in
      a single response, this token is returned. It encodes the position of
      the current result cursor. Feeding this value into a new list request
      with the `page_token` parameter gives the next page of the results. When
      `next_page_token` is not filled in, there is no next page and the list
      returned is the last page in the result set. Pagination tokens have a
      limited lifetime.
    projects: The list of Projects that matched the list filter. This list can
      be paginated.
  """

  nextPageToken = _messages.StringField(1)
  projects = _messages.MessageField('Project', 2, repeated=True)


class MoveFolderMetadata(_messages.Message):
  r"""Metadata pertaining to the folder move process.

  Fields:
    destinationParent: The resource name of the folder or organization to move
      the folder to.
    displayName: The display name of the folder.
    sourceParent: The resource name of the folder's parent.
  """

  destinationParent = _messages.StringField(1)
  displayName = _messages.StringField(2)
  sourceParent = _messages.StringField(3)


class MoveProjectMetadata(_messages.Message):
  r"""A status object which is used as the `metadata` field for the Operation
  returned by MoveProject.
  """



class Organization(_messages.Message):
  r"""The root node in the resource hierarchy to which a particular entity's
  (e.g., company) resources belong.

  Enums:
    LifecycleStateValueValuesEnum: The organization's current lifecycle state.
      Assigned by the server.

  Fields:
    creationTime: Timestamp when the Organization was created. Assigned by the
      server.
    displayName: A human-readable string that refers to the Organization in
      the GCP Console UI. This string is set by the server and cannot be
      changed. The string will be set to the primary domain (for example,
      "google.com") of the G Suite customer that owns the organization.
    lifecycleState: The organization's current lifecycle state. Assigned by
      the server.
    name: Output only. The resource name of the organization. This is the
      organization's relative path in the API. Its format is
      "organizations/[organization_id]". For example, "organizations/1234".
    organizationId: An immutable id for the Organization that is assigned on
      creation. This should be omitted when creating a new Organization. This
      field is read-only.
    owner: The owner of this Organization. The owner should be specified on
      creation. Once set, it cannot be changed. This field is required.
  """

  class LifecycleStateValueValuesEnum(_messages.Enum):
    r"""The organization's current lifecycle state. Assigned by the server.

    Values:
      LIFECYCLE_STATE_UNSPECIFIED: Unspecified state. This is only useful for
        distinguishing unset values.
      ACTIVE: The normal and active state.
      DELETE_REQUESTED: The organization has been marked for deletion by the
        user.
    """
    LIFECYCLE_STATE_UNSPECIFIED = 0
    ACTIVE = 1
    DELETE_REQUESTED = 2

  creationTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  lifecycleState = _messages.EnumField('LifecycleStateValueValuesEnum', 3)
  name = _messages.StringField(4)
  organizationId = _messages.StringField(5)
  owner = _messages.MessageField('OrganizationOwner', 6)


class OrganizationOwner(_messages.Message):
  r"""The entity that owns an Organization. The lifetime of the Organization
  and all of its descendants are bound to the `OrganizationOwner`. If the
  `OrganizationOwner` is deleted, the Organization and all its descendants
  will be deleted.

  Fields:
    directoryCustomerId: The G Suite customer id used in the Directory API.
  """

  directoryCustomerId = _messages.StringField(1)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Project(_messages.Message):
  r"""A Project is a high-level Google Cloud Platform entity. It is a
  container for ACLs, APIs, App Engine Apps, VMs, and other Google Cloud
  Platform resources.

  Enums:
    LifecycleStateValueValuesEnum: The Project lifecycle state. Read-only.

  Messages:
    LabelsValue: The labels associated with this Project. Label keys must be
      between 1 and 63 characters long and must conform to the following
      regular expression: a-z{0,62}. Label values must be between 0 and 63
      characters long and must conform to the regular expression
      [a-z0-9_-]{0,63}. A label value can be empty. No more than 256 labels
      can be associated with a given resource. Clients should store labels in
      a representation such as JSON that does not depend on specific
      characters being disallowed. Example: `"environment" : "dev"` Read-
      write.

  Fields:
    createTime: Creation time. Read-only.
    labels: The labels associated with this Project. Label keys must be
      between 1 and 63 characters long and must conform to the following
      regular expression: a-z{0,62}. Label values must be between 0 and 63
      characters long and must conform to the regular expression
      [a-z0-9_-]{0,63}. A label value can be empty. No more than 256 labels
      can be associated with a given resource. Clients should store labels in
      a representation such as JSON that does not depend on specific
      characters being disallowed. Example: `"environment" : "dev"` Read-
      write.
    lifecycleState: The Project lifecycle state. Read-only.
    name: The optional user-assigned display name of the Project. When present
      it must be between 4 to 30 characters. Allowed characters are: lowercase
      and uppercase letters, numbers, hyphen, single-quote, double-quote,
      space, and exclamation point. Example: `My Project` Read-write.
    parent: An optional reference to a parent Resource. Supported parent types
      include "organization" and "folder". Once set, the parent cannot be
      cleared. The `parent` can be set on creation or using the
      `UpdateProject` method; the end user must have the
      `resourcemanager.projects.create` permission on the parent. Read-write.
    projectId: The unique, user-assigned ID of the Project. It must be 6 to 30
      lowercase letters, digits, or hyphens. It must start with a letter.
      Trailing hyphens are prohibited. Example: `tokyo-rain-123` Read-only
      after creation.
    projectNumber: The number uniquely identifying the project. Example:
      `415104041262` Read-only.
  """

  class LifecycleStateValueValuesEnum(_messages.Enum):
    r"""The Project lifecycle state. Read-only.

    Values:
      LIFECYCLE_STATE_UNSPECIFIED: Unspecified state. This is only used/useful
        for distinguishing unset values.
      ACTIVE: The normal and active state.
      DELETE_REQUESTED: The project has been marked for deletion by the user
        (by invoking DeleteProject) or by the system (Google Cloud Platform).
        This can generally be reversed by invoking UndeleteProject.
      DELETE_IN_PROGRESS: This lifecycle state is no longer used and is not
        returned by the API.
    """
    LIFECYCLE_STATE_UNSPECIFIED = 0
    ACTIVE = 1
    DELETE_REQUESTED = 2
    DELETE_IN_PROGRESS = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels associated with this Project. Label keys must be between 1
    and 63 characters long and must conform to the following regular
    expression: a-z{0,62}. Label values must be between 0 and 63 characters
    long and must conform to the regular expression [a-z0-9_-]{0,63}. A label
    value can be empty. No more than 256 labels can be associated with a given
    resource. Clients should store labels in a representation such as JSON
    that does not depend on specific characters being disallowed. Example:
    `"environment" : "dev"` Read-write.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  lifecycleState = _messages.EnumField('LifecycleStateValueValuesEnum', 3)
  name = _messages.StringField(4)
  parent = _messages.MessageField('ResourceId', 5)
  projectId = _messages.StringField(6)
  projectNumber = _messages.IntegerField(7)


class ProjectCreationStatus(_messages.Message):
  r"""A status object which is used as the `metadata` field for the Operation
  returned by CreateProject. It provides insight for when significant phases
  of Project creation have completed.

  Fields:
    createTime: Creation time of the project creation workflow.
    gettable: True if the project can be retrieved using GetProject. No other
      operations on the project are guaranteed to work until the project
      creation is complete.
    ready: True if the project creation process is complete.
  """

  createTime = _messages.StringField(1)
  gettable = _messages.BooleanField(2)
  ready = _messages.BooleanField(3)


class ResourceId(_messages.Message):
  r"""A container to reference an id for any resource type. A `resource` in
  Google Cloud Platform is a generic term for something you (a developer) may
  want to interact with through one of our API's. Some examples are an App
  Engine app, a Compute Engine instance, a Cloud SQL database, and so on.

  Fields:
    id: Required field for the type-specific id. This should correspond to the
      id used in the type-specific API's.
    type: Required field representing the resource type this id is for. At
      present, the valid types are "project", "folder", and "organization".
  """

  id = _messages.StringField(1)
  type = _messages.StringField(2)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class UndeleteFolderMetadata(_messages.Message):
  r"""A status object which is used as the `metadata` field for the
  `Operation` returned by `UndeleteFolder`.
  """



class UndeleteOrganizationMetadata(_messages.Message):
  r"""A status object which is used as the `metadata` field for the Operation
  returned by UndeleteOrganization.
  """



class UndeleteProjectMetadata(_messages.Message):
  r"""A status object which is used as the `metadata` field for the Operation
  returned by `UndeleteProject`.
  """



class UndeleteProjectRequest(_messages.Message):
  r"""The request sent to the UndeleteProject method."""


class UpdateFolderMetadata(_messages.Message):
  r"""A status object which is used as the `metadata` field for the Operation
  returned by UpdateFolder.
  """



class UpdateProjectMetadata(_messages.Message):
  r"""A status object which is used as the `metadata` field for the Operation
  returned by UpdateProject.
  """



class UpdateTagKeyMetadata(_messages.Message):
  r"""Runtime operation information for updating a TagKey."""


class UpdateTagValueMetadata(_messages.Message):
  r"""Runtime operation information for updating a TagValue."""


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
