"""Generated message classes for datafusion version v1beta1.

Cloud Data Fusion is a fully-managed, cloud native, enterprise data
integration service for quickly building and managing data pipelines. It
provides a graphical interface to increase time efficiency and reduce
complexity, and allows business users, developers, and data scientists to
easily and reliably build scalable data integration solutions to cleanse,
prepare, blend, transfer and transform data without having to wrestle with
infrastructure.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'datafusion'


class Accelerator(_messages.Message):
  r"""Identifies Data Fusion accelerators for an instance.

  Enums:
    AcceleratorTypeValueValuesEnum: The type of an accelator for a CDF
      instance.

  Fields:
    acceleratorType: The type of an accelator for a CDF instance.
  """

  class AcceleratorTypeValueValuesEnum(_messages.Enum):
    r"""The type of an accelator for a CDF instance.

    Values:
      ACCELERATOR_TYPE_UNSPECIFIED: Default value, if unspecified.
      CDC: Change Data Capture accelerator for CDF.
      HEALTHCARE: Cloud Healthcare accelerator for CDF. This accelerator is to
        enable Cloud Healthcare specific CDF plugins developed by Healthcare
        team.
    """
    ACCELERATOR_TYPE_UNSPECIFIED = 0
    CDC = 1
    HEALTHCARE = 2

  acceleratorType = _messages.EnumField('AcceleratorTypeValueValuesEnum', 1)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts jose@example.com from DATA_READ logging, and
  aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CryptoKeyConfig(_messages.Message):
  r"""The crypto key configuration. This field is used by the Customer-managed
  encryption keys (CMEK) feature.

  Fields:
    keyReference: The name of the key which is used to encrypt/decrypt
      customer data. For key in Cloud KMS, the key should be in the format of
      `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
  """

  keyReference = _messages.StringField(1)


class DatafusionProjectsLocationsGetRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class DatafusionProjectsLocationsInstancesCreateRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsInstancesCreateRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    instanceId: Required. The name of the instance to create.
    parent: Required. The instance's project and location in the format
      projects/{project}/locations/{location}.
  """

  instance = _messages.MessageField('Instance', 1)
  instanceId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatafusionProjectsLocationsInstancesDeleteRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsInstancesDeleteRequest object.

  Fields:
    name: Required. The instance resource name in the format
      projects/{project}/locations/{location}/instances/{instance}
  """

  name = _messages.StringField(1, required=True)


class DatafusionProjectsLocationsInstancesDnsPeeringsCreateRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsInstancesDnsPeeringsCreateRequest object.

  Fields:
    dnsPeering: A DnsPeering resource to be passed as the request body.
    dnsPeeringId: Required. The name of the peering to create.
    parent: Required. The resource on which DNS peering will be created.
  """

  dnsPeering = _messages.MessageField('DnsPeering', 1)
  dnsPeeringId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatafusionProjectsLocationsInstancesDnsPeeringsDeleteRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsInstancesDnsPeeringsDeleteRequest object.

  Fields:
    name: Required. The name of the DNS peering zone to delete. Format: projec
      ts/{project}/locations/{location}/instances/{instance}/dnsPeerings/{dns_
      peering}
  """

  name = _messages.StringField(1, required=True)


class DatafusionProjectsLocationsInstancesDnsPeeringsListRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsInstancesDnsPeeringsListRequest object.

  Fields:
    pageSize: The maximum number of dns peerings to return. The service may
      return fewer than this value. If unspecified, at most 50 dns peerings
      will be returned. The maximum value is 200; values above 200 will be
      coerced to 200.
    pageToken: A page token, received from a previous `ListDnsPeerings` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListDnsPeerings` must match the call that
      provided the page token.
    parent: Required. The parent, which owns this collection of dns peerings.
      Format: projects/{project}/locations/{location}/instances/{instance}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DatafusionProjectsLocationsInstancesGetIamPolicyRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsInstancesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DatafusionProjectsLocationsInstancesGetRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsInstancesGetRequest object.

  Fields:
    name: Required. The instance resource name in the format
      projects/{project}/locations/{location}/instances/{instance}.
  """

  name = _messages.StringField(1, required=True)


class DatafusionProjectsLocationsInstancesListRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsInstancesListRequest object.

  Fields:
    filter: List filter.
    orderBy: Sort results. Supported values are "name", "name desc", or ""
      (unsorted).
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value to use if there are additional
      results to retrieve for this list request.
    parent: Required. The project and location for which to retrieve instance
      information in the format projects/{project}/locations/{location}. If
      the location is specified as '-' (wildcard), then all regions available
      to the project are queried, and the results are aggregated.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DatafusionProjectsLocationsInstancesNamespacesGetIamPolicyRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsInstancesNamespacesGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class DatafusionProjectsLocationsInstancesNamespacesListRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsInstancesNamespacesListRequest object.

  Enums:
    ViewValueValuesEnum: By default, only basic information about a namespace
      is returned (e.g. name). When `NAMESPACE_VIEW_FULL` is specified,
      additional information associated with a namespace gets returned (e.g.
      IAM policy set on the namespace)

  Fields:
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value to use if there are additional
      results to retrieve for this list request.
    parent: Required. The instance to list its namespaces.
    view: By default, only basic information about a namespace is returned
      (e.g. name). When `NAMESPACE_VIEW_FULL` is specified, additional
      information associated with a namespace gets returned (e.g. IAM policy
      set on the namespace)
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""By default, only basic information about a namespace is returned (e.g.
    name). When `NAMESPACE_VIEW_FULL` is specified, additional information
    associated with a namespace gets returned (e.g. IAM policy set on the
    namespace)

    Values:
      NAMESPACE_VIEW_UNSPECIFIED: Default/unset value, which will use BASIC
        view.
      NAMESPACE_VIEW_BASIC: Show the most basic metadata of a namespace
      NAMESPACE_VIEW_FULL: Returns all metadata of a namespace
    """
    NAMESPACE_VIEW_UNSPECIFIED = 0
    NAMESPACE_VIEW_BASIC = 1
    NAMESPACE_VIEW_FULL = 2

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class DatafusionProjectsLocationsInstancesNamespacesSetIamPolicyRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsInstancesNamespacesSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DatafusionProjectsLocationsInstancesNamespacesTestIamPermissionsRequest(_messages.Message):
  r"""A
  DatafusionProjectsLocationsInstancesNamespacesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DatafusionProjectsLocationsInstancesPatchRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsInstancesPatchRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    name: Output only. The name of this instance is in the form of
      projects/{project}/locations/{location}/instances/{instance}.
    updateMask: Field mask is used to specify the fields that the update will
      overwrite in an instance resource. The fields specified in the
      update_mask are relative to the resource, not the full request. A field
      will be overwritten if it is in the mask. If the user does not provide a
      mask, all the supported fields (labels and options currently) will be
      overwritten.
  """

  instance = _messages.MessageField('Instance', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class DatafusionProjectsLocationsInstancesRestartRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsInstancesRestartRequest object.

  Fields:
    name: Required. Name of the Data Fusion instance which need to be
      restarted in the form of
      projects/{project}/locations/{location}/instances/{instance}
    restartInstanceRequest: A RestartInstanceRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  restartInstanceRequest = _messages.MessageField('RestartInstanceRequest', 2)


class DatafusionProjectsLocationsInstancesSetIamPolicyRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsInstancesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DatafusionProjectsLocationsInstancesTestIamPermissionsRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsInstancesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DatafusionProjectsLocationsInstancesUpgradeRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsInstancesUpgradeRequest object.

  Fields:
    name: Required. Name of the Data Fusion instance which need to be upgraded
      in the form of
      projects/{project}/locations/{location}/instances/{instance} Instance
      will be upgraded with the latest stable version of the Data Fusion.
    upgradeInstanceRequest: A UpgradeInstanceRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  upgradeInstanceRequest = _messages.MessageField('UpgradeInstanceRequest', 2)


class DatafusionProjectsLocationsListRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    includeUnrevealedLocations: If true, the returned list will include
      locations which are not yet revealed.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  includeUnrevealedLocations = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class DatafusionProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class DatafusionProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class DatafusionProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class DatafusionProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class DatafusionProjectsLocationsRemoveIamPolicyRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsRemoveIamPolicyRequest object.

  Fields:
    removeIamPolicyRequest: A RemoveIamPolicyRequest resource to be passed as
      the request body.
    resource: Required. The resource on which IAM policy to be removed is
      attached to.
  """

  removeIamPolicyRequest = _messages.MessageField('RemoveIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DatafusionProjectsLocationsVersionsListRequest(_messages.Message):
  r"""A DatafusionProjectsLocationsVersionsListRequest object.

  Fields:
    latestPatchOnly: Whether or not to return the latest patch of every
      available minor version. If true, only the latest patch will be
      returned. Ex. if allowed versions is [6.1.1, 6.1.2, 6.2.0] then response
      will be [6.1.2, 6.2.0]
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value to use if there are additional
      results to retrieve for this list request.
    parent: Required. The project and location for which to retrieve instance
      information in the format projects/{project}/locations/{location}.
  """

  latestPatchOnly = _messages.BooleanField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class DnsPeering(_messages.Message):
  r"""DNS peering configuration. These configurations are used to create DNS
  peering with the customer Cloud DNS.

  Fields:
    description: Optional. Optional description of the dns zone.
    domain: Required. The dns name suffix of the zone.
    name: Required. The resource name of the dns peering zone. Format: project
      s/{project}/locations/{location}/instances/{instance}/dnsPeerings/{dns_p
      eering}
    targetNetwork: Optional. Optional target network to which dns peering
      should happen.
    targetProject: Optional. Optional target project to which dns peering
      should happen.
  """

  description = _messages.StringField(1)
  domain = _messages.StringField(2)
  name = _messages.StringField(3)
  targetNetwork = _messages.StringField(4)
  targetProject = _messages.StringField(5)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class IAMPolicy(_messages.Message):
  r"""IAMPolicy encapsulates the IAM policy name, definition and status of
  policy fetching.

  Fields:
    policy: Policy definition if IAM policy fetching is successful, otherwise
      empty.
    status: Status of iam policy fetching.
  """

  policy = _messages.MessageField('Policy', 1)
  status = _messages.MessageField('Status', 2)


class Instance(_messages.Message):
  r"""Represents a Data Fusion instance.

  Enums:
    DisabledReasonValueListEntryValuesEnum:
    StateValueValuesEnum: Output only. The current state of this Data Fusion
      instance.
    TypeValueValuesEnum: Required. Instance type.

  Messages:
    LabelsValue: The resource labels for instance to use to annotate any
      related underlying resources such as Compute Engine VMs. The character
      '=' is not allowed to be used within the labels.
    OptionsValue: Map of additional options used to configure the behavior of
      Data Fusion instance.

  Fields:
    accelerators: List of accelerators enabled for this CDF instance.
    apiEndpoint: Output only. Endpoint on which the REST APIs is accessible.
    availableVersion: Available versions that the instance can be upgraded to
      using UpdateInstanceRequest.
    createTime: Output only. The time the instance was created.
    cryptoKeyConfig: The crypto key configuration. This field is used by the
      Customer-Managed Encryption Keys (CMEK) feature.
    dataprocServiceAccount: User-managed service account to set on Dataproc
      when Cloud Data Fusion creates Dataproc to run data processing
      pipelines. This allows users to have fine-grained access control on
      Dataproc's accesses to cloud resources.
    description: A description of this instance.
    disabledReason: Output only. If the instance state is DISABLED, the reason
      for disabling the instance.
    displayName: Display name for an instance.
    enableRbac: Option to enable granular role-based access control.
    enableStackdriverLogging: Option to enable Stackdriver Logging.
    enableStackdriverMonitoring: Option to enable Stackdriver Monitoring.
    gcsBucket: Output only. Cloud Storage bucket generated by Data Fusion in
      the customer project.
    labels: The resource labels for instance to use to annotate any related
      underlying resources such as Compute Engine VMs. The character '=' is
      not allowed to be used within the labels.
    name: Output only. The name of this instance is in the form of
      projects/{project}/locations/{location}/instances/{instance}.
    networkConfig: Network configuration options. These are required when a
      private Data Fusion instance is to be created.
    options: Map of additional options used to configure the behavior of Data
      Fusion instance.
    p4ServiceAccount: Output only. P4 service account for the customer
      project.
    privateInstance: Specifies whether the Data Fusion instance should be
      private. If set to true, all Data Fusion nodes will have private IP
      addresses and will not be able to access the public internet.
    serviceAccount: Output only. Deprecated. Use tenant_project_id instead to
      extract the tenant project ID.
    serviceEndpoint: Output only. Endpoint on which the Data Fusion UI is
      accessible.
    state: Output only. The current state of this Data Fusion instance.
    stateMessage: Output only. Additional information about the current state
      of this Data Fusion instance if available.
    tenantProjectId: Output only. The name of the tenant project.
    type: Required. Instance type.
    updateTime: Output only. The time the instance was last updated.
    version: Current version of Data Fusion.
    zone: Name of the zone in which the Data Fusion instance will be created.
      Only DEVELOPER instances use this field.
  """

  class DisabledReasonValueListEntryValuesEnum(_messages.Enum):
    r"""DisabledReasonValueListEntryValuesEnum enum type.

    Values:
      DISABLED_REASON_UNSPECIFIED: This is an unknown reason for disabling.
      KMS_KEY_ISSUE: The KMS key used by the instance is either revoked or
        denied access to
    """
    DISABLED_REASON_UNSPECIFIED = 0
    KMS_KEY_ISSUE = 1

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of this Data Fusion instance.

    Values:
      STATE_UNSPECIFIED: Instance does not have a state yet
      CREATING: Instance is being created
      RUNNING: Instance is running and ready for requests
      FAILED: Instance creation failed
      DELETING: Instance is being deleted
      UPGRADING: Instance is being upgraded
      RESTARTING: Instance is being restarted
      UPDATING: Instance is being updated on customer request
      AUTO_UPDATING: Instance is being auto-updated
      AUTO_UPGRADING: Instance is being auto-upgraded
      DISABLED: Instance is disabled
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    RUNNING = 2
    FAILED = 3
    DELETING = 4
    UPGRADING = 5
    RESTARTING = 6
    UPDATING = 7
    AUTO_UPDATING = 8
    AUTO_UPGRADING = 9
    DISABLED = 10

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. Instance type.

    Values:
      TYPE_UNSPECIFIED: No type specified. The instance creation will fail.
      BASIC: Basic Data Fusion instance. In Basic type, the user will be able
        to create data pipelines using point and click UI. However, there are
        certain limitations, such as fewer number of concurrent pipelines, no
        support for streaming pipelines, etc.
      ENTERPRISE: Enterprise Data Fusion instance. In Enterprise type, the
        user will have all features available, such as support for streaming
        pipelines, unlimited number of concurrent pipelines, etc.
      DEVELOPER: Developer Data Fusion instance. In Developer type, the user
        will have all features available but with restrictive capabilities.
        This is to help enterprises design and develop their data ingestion
        and integration pipelines at low cost.
    """
    TYPE_UNSPECIFIED = 0
    BASIC = 1
    ENTERPRISE = 2
    DEVELOPER = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The resource labels for instance to use to annotate any related
    underlying resources such as Compute Engine VMs. The character '=' is not
    allowed to be used within the labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OptionsValue(_messages.Message):
    r"""Map of additional options used to configure the behavior of Data
    Fusion instance.

    Messages:
      AdditionalProperty: An additional property for a OptionsValue object.

    Fields:
      additionalProperties: Additional properties of type OptionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OptionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  accelerators = _messages.MessageField('Accelerator', 1, repeated=True)
  apiEndpoint = _messages.StringField(2)
  availableVersion = _messages.MessageField('Version', 3, repeated=True)
  createTime = _messages.StringField(4)
  cryptoKeyConfig = _messages.MessageField('CryptoKeyConfig', 5)
  dataprocServiceAccount = _messages.StringField(6)
  description = _messages.StringField(7)
  disabledReason = _messages.EnumField('DisabledReasonValueListEntryValuesEnum', 8, repeated=True)
  displayName = _messages.StringField(9)
  enableRbac = _messages.BooleanField(10)
  enableStackdriverLogging = _messages.BooleanField(11)
  enableStackdriverMonitoring = _messages.BooleanField(12)
  gcsBucket = _messages.StringField(13)
  labels = _messages.MessageField('LabelsValue', 14)
  name = _messages.StringField(15)
  networkConfig = _messages.MessageField('NetworkConfig', 16)
  options = _messages.MessageField('OptionsValue', 17)
  p4ServiceAccount = _messages.StringField(18)
  privateInstance = _messages.BooleanField(19)
  serviceAccount = _messages.StringField(20)
  serviceEndpoint = _messages.StringField(21)
  state = _messages.EnumField('StateValueValuesEnum', 22)
  stateMessage = _messages.StringField(23)
  tenantProjectId = _messages.StringField(24)
  type = _messages.EnumField('TypeValueValuesEnum', 25)
  updateTime = _messages.StringField(26)
  version = _messages.StringField(27)
  zone = _messages.StringField(28)


class ListAvailableVersionsResponse(_messages.Message):
  r"""Response message for the list available versions request.

  Fields:
    availableVersions: Represents a list of versions that are supported.
    nextPageToken: Token to retrieve the next page of results or empty if
      there are no more results in the list.
  """

  availableVersions = _messages.MessageField('Version', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDnsPeeringsResponse(_messages.Message):
  r"""Response message for list DNS peerings.

  Fields:
    dnsPeerings: List of dns peering.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  dnsPeerings = _messages.MessageField('DnsPeering', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListInstancesResponse(_messages.Message):
  r"""Response message for the list instance request.

  Fields:
    instances: Represents a list of Data Fusion instances.
    nextPageToken: Token to retrieve the next page of results or empty if
      there are no more results in the list.
    unreachable: Locations that could not be reached.
  """

  instances = _messages.MessageField('Instance', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListNamespacesResponse(_messages.Message):
  r"""List namespaces response.

  Fields:
    namespaces: List of namespaces
    nextPageToken: Token to retrieve the next page of results or empty if
      there are no more results in the list.
  """

  namespaces = _messages.MessageField('Namespace', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Namespace(_messages.Message):
  r"""Represents the information of a namespace

  Fields:
    iamPolicy: IAM policy associated with this namespace.
    name: Name of the given namespace.
  """

  iamPolicy = _messages.MessageField('IAMPolicy', 1)
  name = _messages.StringField(2)


class NetworkConfig(_messages.Message):
  r"""Network configuration for a Data Fusion instance. These configurations
  are used for peering with the customer network. Configurations are optional
  when a public Data Fusion instance is to be created. However, providing
  these configurations allows several benefits, such as reduced network
  latency while accessing the customer resources from managed Data Fusion
  instance nodes, as well as access to the customer on-prem resources.

  Fields:
    ipAllocation: The IP range in CIDR notation to use for the managed Data
      Fusion instance nodes. This range must not overlap with any other ranges
      used in the Data Fusion instance network.
    network: Name of the network in the customer project with which the Tenant
      Project will be peered for executing pipelines. In case of shared VPC
      where the network resides in another host project the network should
      specified in the form of projects/{host-project-
      id}/global/networks/{network}
  """

  ipAllocation = _messages.StringField(1)
  network = _messages.StringField(2)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of a long-running operation.

  Fields:
    apiVersion: API version used to start the operation.
    createTime: The time the operation was created.
    endTime: The time the operation finished running.
    requestedCancellation: Identifies whether the user has requested
      cancellation of the operation. Operations that have successfully been
      cancelled have Operation.error value with a google.rpc.Status.code of 1,
      corresponding to `Code.CANCELLED`.
    statusDetail: Human-readable status of the operation if any.
    target: Server-defined resource path for the target of the operation.
    verb: Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusDetail = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class RemoveIamPolicyRequest(_messages.Message):
  r"""Request message for RemoveIamPolicy method."""


class RemoveIamPolicyResponse(_messages.Message):
  r"""Response message for RemoveIamPolicy method."""


class RestartInstanceRequest(_messages.Message):
  r"""Request message for restarting a Data Fusion instance."""


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class UpgradeInstanceRequest(_messages.Message):
  r"""Request message for upgrading a Data Fusion instance. To change the
  instance properties, instance update should be used.
  """



class Version(_messages.Message):
  r"""The Data Fusion version.

  Enums:
    TypeValueValuesEnum: Type represents the release availability of the
      version

  Fields:
    availableFeatures: Represents a list of available feature names for a
      given version.
    defaultVersion: Whether this is currently the default version for Cloud
      Data Fusion
    type: Type represents the release availability of the version
    versionNumber: The version number of the Data Fusion instance, such as
      '6.0.1.0'.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type represents the release availability of the version

    Values:
      TYPE_UNSPECIFIED: Version does not have availability yet
      TYPE_PREVIEW: Version is under development and not considered stable
      TYPE_GENERAL_AVAILABILITY: Version is available for public use
    """
    TYPE_UNSPECIFIED = 0
    TYPE_PREVIEW = 1
    TYPE_GENERAL_AVAILABILITY = 2

  availableFeatures = _messages.StringField(1, repeated=True)
  defaultVersion = _messages.BooleanField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)
  versionNumber = _messages.StringField(4)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
