"""Generated message classes for edgenetwork version v1alpha1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'edgenetwork'


class Bgp(_messages.Message):
  r"""A Bgp object.

  Fields:
    asn: Locally assigned BGP ASN.
    keepaliveIntervalInSeconds: The interval in seconds between BGP keepalive
      messages that are sent to the peer. Default is 20 with value between 20
      and 60.
  """

  asn = _messages.IntegerField(1, variant=_messages.Variant.UINT32)
  keepaliveIntervalInSeconds = _messages.IntegerField(2, variant=_messages.Variant.UINT32)


class BgpPeer(_messages.Message):
  r"""A BgpPeer object.

  Fields:
    interface: A string attribute.
    interfaceIpv4Cidr: IP range of the interface within Google.
    name: Name of this BGP peer. Unique within the Zones resource.
    peerAsn: Peer BGP Autonomous System Number (ASN). Each BGP interface may
      use a different value.
    peerIpv4Cidr: IP range of the BGP interface outside Google.
  """

  interface = _messages.StringField(1)
  interfaceIpv4Cidr = _messages.StringField(2)
  name = _messages.StringField(3)
  peerAsn = _messages.IntegerField(4, variant=_messages.Variant.UINT32)
  peerIpv4Cidr = _messages.StringField(5)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class EdgenetworkProjectsLocationsGetRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class EdgenetworkProjectsLocationsListRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like "displayName=tokyo", and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class EdgenetworkProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class EdgenetworkProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class EdgenetworkProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class EdgenetworkProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class EdgenetworkProjectsLocationsZonesCreateRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    zone: A Zone resource to be passed as the request body.
    zoneId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and zone_id from the method_signature of
      Create RPC
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  zone = _messages.MessageField('Zone', 3)
  zoneId = _messages.StringField(4)


class EdgenetworkProjectsLocationsZonesDeleteRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class EdgenetworkProjectsLocationsZonesGetRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class EdgenetworkProjectsLocationsZonesInterconnectAttachmentsCreateRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesInterconnectAttachmentsCreateRequest
  object.

  Fields:
    interconnectAttachment: A InterconnectAttachment resource to be passed as
      the request body.
    interconnectAttachmentId: Required. Id of the requesting object If auto-
      generating Id server-side, remove this field and
      interconnect_attachment_id from the method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  interconnectAttachment = _messages.MessageField('InterconnectAttachment', 1)
  interconnectAttachmentId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class EdgenetworkProjectsLocationsZonesInterconnectAttachmentsDeleteRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesInterconnectAttachmentsDeleteRequest
  object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class EdgenetworkProjectsLocationsZonesInterconnectAttachmentsGetRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesInterconnectAttachmentsGetRequest
  object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class EdgenetworkProjectsLocationsZonesInterconnectAttachmentsListRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesInterconnectAttachmentsListRequest
  object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListInterconnectAttachmentsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class EdgenetworkProjectsLocationsZonesInterconnectsCreateRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesInterconnectsCreateRequest object.

  Fields:
    interconnect: A Interconnect resource to be passed as the request body.
    interconnectId: Required. Id of the requesting object If auto-generating
      Id server-side, remove this field and interconnect_id from the
      method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  interconnect = _messages.MessageField('Interconnect', 1)
  interconnectId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class EdgenetworkProjectsLocationsZonesInterconnectsDeleteRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesInterconnectsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class EdgenetworkProjectsLocationsZonesInterconnectsGetRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesInterconnectsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class EdgenetworkProjectsLocationsZonesInterconnectsListRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesInterconnectsListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListInterconnectsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class EdgenetworkProjectsLocationsZonesListRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListZonesRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class EdgenetworkProjectsLocationsZonesNetworksCreateRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesNetworksCreateRequest object.

  Fields:
    network: A Network resource to be passed as the request body.
    networkId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and network_id from the method_signature
      of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  network = _messages.MessageField('Network', 1)
  networkId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class EdgenetworkProjectsLocationsZonesNetworksDeleteRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesNetworksDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class EdgenetworkProjectsLocationsZonesNetworksGetRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesNetworksGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class EdgenetworkProjectsLocationsZonesNetworksListRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesNetworksListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListNetworksRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class EdgenetworkProjectsLocationsZonesRoutersCreateRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesRoutersCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    router: A Router resource to be passed as the request body.
    routerId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and router_id from the method_signature
      of Create RPC
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  router = _messages.MessageField('Router', 3)
  routerId = _messages.StringField(4)


class EdgenetworkProjectsLocationsZonesRoutersDeleteRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesRoutersDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class EdgenetworkProjectsLocationsZonesRoutersGetRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesRoutersGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class EdgenetworkProjectsLocationsZonesRoutersListRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesRoutersListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListRoutersRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class EdgenetworkProjectsLocationsZonesRoutersPatchRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesRoutersPatchRequest object.

  Fields:
    name: Required. The canonical resource name of the router.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    router: A Router resource to be passed as the request body.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Router resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  router = _messages.MessageField('Router', 3)
  updateMask = _messages.StringField(4)


class EdgenetworkProjectsLocationsZonesSubnetsCreateRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesSubnetsCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    subnet: A Subnet resource to be passed as the request body.
    subnetId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and subnet_id from the method_signature
      of Create RPC
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  subnet = _messages.MessageField('Subnet', 3)
  subnetId = _messages.StringField(4)


class EdgenetworkProjectsLocationsZonesSubnetsDeleteRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesSubnetsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class EdgenetworkProjectsLocationsZonesSubnetsGetRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesSubnetsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class EdgenetworkProjectsLocationsZonesSubnetsListRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesSubnetsListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListSubnetsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class EdgenetworkProjectsLocationsZonesSubnetsPatchRequest(_messages.Message):
  r"""A EdgenetworkProjectsLocationsZonesSubnetsPatchRequest object.

  Fields:
    name: Required. The canonical resource name of the subnet.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    subnet: A Subnet resource to be passed as the request body.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Subnet resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  subnet = _messages.MessageField('Subnet', 3)
  updateMask = _messages.StringField(4)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class Interconnect(_messages.Message):
  r"""Message describing Interconnect object LINT.IfChange(Interconnect)

  Enums:
    InterconnectTypeValueValuesEnum: Optional. Type of interconnect, which
      takes only the value 'DEDICATED' for now.

  Messages:
    LabelsValue: Labels associated with this resource.

  Fields:
    createTime: Output only. The time when the subnet was created.
    description: Optional. A free-text description of the resource. Max length
      1024 characters.
    deviceCloudResourceName: Output only. Cloud resource name of the switch
      device.
    interconnectType: Optional. Type of interconnect, which takes only the
      value 'DEDICATED' for now.
    labels: Labels associated with this resource.
    name: Required. The canonical resource name of the interconnect.
    physicalPorts: Output only. Physical ports (e.g., TenGigE0/0/0/1) that
      form the interconnect.
    updateTime: Output only. The time when the subnet was last updated.
    uuid: Output only. Unique identifier for the link.
  """

  class InterconnectTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Type of interconnect, which takes only the value 'DEDICATED'
    for now.

    Values:
      INTERCONNECT_TYPE_UNSPECIFIED: <no description>
      DEDICATED: <no description>
    """
    INTERCONNECT_TYPE_UNSPECIFIED = 0
    DEDICATED = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels associated with this resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  deviceCloudResourceName = _messages.StringField(3)
  interconnectType = _messages.EnumField('InterconnectTypeValueValuesEnum', 4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  physicalPorts = _messages.StringField(7, repeated=True)
  updateTime = _messages.StringField(8)
  uuid = _messages.StringField(9)


class InterconnectAttachment(_messages.Message):
  r"""Message describing InterconnectAttachment object
  LINT.IfChange(InterconnectAttachment)

  Enums:
    StateValueValuesEnum: Output only. Current stage of the resource to the
      device by config push.

  Messages:
    LabelsValue: Labels associated with this resource.

  Fields:
    createTime: Output only. The time when the interconnect attachment was
      created.
    description: Optional. A free-text description of the resource. Max length
      1024 characters.
    interconnect: The canonical name of underlying Interconnect object that
      this attachment's traffic will traverse through. The name is in the form
      of projects/{project}/locations/{location}/zones/{zone}/interconnects/{i
      nterconnect}.
    labels: Labels associated with this resource.
    mtu: IP (L3) MTU value of the virtual edge cloud. Valid values are: 1500
      and 9000. Default to 1500 if not set.
    name: Required. The canonical resource name of the interconnect
      attachment.
    router: The canonical Router name in the form of
      projects/{project}/locations/{location}/zones/{zone}/routers/{router}.
    state: Output only. Current stage of the resource to the device by config
      push.
    updateTime: Output only. The time when the interconnect attachment was
      last updated.
    vlanId: Required. VLAN id provided by user. Must be site-wise unique.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current stage of the resource to the device by config
    push.

    Values:
      STATE_UNKNOWN: Unspecified state.
      STATE_PENDING: The resource has not been recognized by config push.
      STATE_PROVISIONING: The resource has reached config push.
      STATE_RUNNING: The resource has been pushed to device successfully by
        config push.
      STATE_SUSPENDED: The resource failed to push to device by config push.
    """
    STATE_UNKNOWN = 0
    STATE_PENDING = 1
    STATE_PROVISIONING = 2
    STATE_RUNNING = 3
    STATE_SUSPENDED = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels associated with this resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  interconnect = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  mtu = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  name = _messages.StringField(6)
  router = _messages.StringField(7)
  state = _messages.EnumField('StateValueValuesEnum', 8)
  updateTime = _messages.StringField(9)
  vlanId = _messages.IntegerField(10, variant=_messages.Variant.INT32)


class Interface(_messages.Message):
  r"""A Interface object.

  Fields:
    ipv4Cidr: IP address and range of the interface.
    linkedInterconnectAttachment: The canonical name of the linked
      Interconnect attachment.
    name: Name of this interface entry. Unique within the Zones resource.
    subnetwork: The canonical name of the subnetwork resource that this
      interface belongs to.
  """

  ipv4Cidr = _messages.StringField(1)
  linkedInterconnectAttachment = _messages.StringField(2)
  name = _messages.StringField(3)
  subnetwork = _messages.StringField(4)


class ListInterconnectAttachmentsResponse(_messages.Message):
  r"""Message for response to listing InterconnectAttachments

  Fields:
    interconnectAttachments: The list of InterconnectAttachment
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  interconnectAttachments = _messages.MessageField('InterconnectAttachment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListInterconnectsResponse(_messages.Message):
  r"""Message for response to listing Interconnects

  Fields:
    interconnects: The list of Interconnect
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  interconnects = _messages.MessageField('Interconnect', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListNetworksResponse(_messages.Message):
  r"""Message for response to listing Networks

  Fields:
    networks: The list of Network
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  networks = _messages.MessageField('Network', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListRoutersResponse(_messages.Message):
  r"""Message for response to listing Routers

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    routers: The list of Router
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  routers = _messages.MessageField('Router', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListSubnetsResponse(_messages.Message):
  r"""Message for response to listing Subnets

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    subnets: The list of Subnet
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  subnets = _messages.MessageField('Subnet', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListZonesResponse(_messages.Message):
  r"""Message for response to listing Zones

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
    zones: The list of Zone
  """

  nextPageToken = _messages.StringField(1)
  unreachable = _messages.StringField(2, repeated=True)
  zones = _messages.MessageField('Zone', 3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Network(_messages.Message):
  r"""Message describing Network object LINT.IfChange(Network)

  Messages:
    LabelsValue: Labels associated with this resource.

  Fields:
    createTime: Output only. The time when the network was created.
    description: Optional. A free-text description of the resource. Max length
      1024 characters.
    labels: Labels associated with this resource.
    mtu: IP (L3) MTU value of the network. Valid values are: 1500 and 9000.
      Default to 1500 if not set.
    name: Required. The canonical resource name of the network.
    updateTime: Output only. The time when the network was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels associated with this resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  mtu = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  name = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Router(_messages.Message):
  r"""Message describing Router object LINT.IfChange(Router)

  Enums:
    StateValueValuesEnum: Output only. Current stage of the resource to the
      device by config push.

  Messages:
    LabelsValue: Labels associated with this resource.

  Fields:
    bgp: BGP information specific to this router.
    bgpPeer: BGP peers.
    createTime: Output only. The time when the router was created.
    description: Optional. A free-text description of the resource. Max length
      1024 characters.
    interface: Router interfaces.
    labels: Labels associated with this resource.
    name: Required. The canonical resource name of the router.
    network: The canonical name of the network to which this router belongs.
      The name is in the form of
      projects/{project}/locations/{location}/zones/{zone}/networks/{network}.
    state: Output only. Current stage of the resource to the device by config
      push.
    updateTime: Output only. The time when the router was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current stage of the resource to the device by config
    push.

    Values:
      STATE_UNKNOWN: Unspecified state.
      STATE_PENDING: The resource has not been recognized by config push.
      STATE_PROVISIONING: The resource has reached config push.
      STATE_RUNNING: The resource has been pushed to device successfully by
        config push.
      STATE_SUSPENDED: The resource failed to push to device by config push.
    """
    STATE_UNKNOWN = 0
    STATE_PENDING = 1
    STATE_PROVISIONING = 2
    STATE_RUNNING = 3
    STATE_SUSPENDED = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels associated with this resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  bgp = _messages.MessageField('Bgp', 1)
  bgpPeer = _messages.MessageField('BgpPeer', 2, repeated=True)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  interface = _messages.MessageField('Interface', 5, repeated=True)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  network = _messages.StringField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  updateTime = _messages.StringField(10)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Subnet(_messages.Message):
  r"""Message describing Subnet object LINT.IfChange(Subnet)

  Enums:
    StateValueValuesEnum: Output only. Current stage of the resource to the
      device by config push.

  Messages:
    LabelsValue: Labels associated with this resource.

  Fields:
    createTime: Output only. The time when the subnet was created.
    description: Optional. A free-text description of the resource. Max length
      1024 characters.
    ipv4Cidr: The ranges of ipv4 addresses that are owned by this subnetwork.
    ipv6Cidr: The ranges of ipv6 addresses that are owned by this subnetwork.
    labels: Labels associated with this resource.
    name: Required. The canonical resource name of the subnet.
    network: The network that this subnetwork belongs to.
    state: Output only. Current stage of the resource to the device by config
      push.
    updateTime: Output only. The time when the subnet was last updated.
    vlanId: Optional. VLAN id provided by user. If not specified we assign one
      automatically.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current stage of the resource to the device by config
    push.

    Values:
      STATE_UNKNOWN: Unspecified state.
      STATE_PENDING: The resource has not been recognized by config push.
      STATE_PROVISIONING: The resource has reached config push.
      STATE_RUNNING: The resource has been pushed to device successfully by
        config push.
      STATE_SUSPENDED: The resource failed to push to device by config push.
    """
    STATE_UNKNOWN = 0
    STATE_PENDING = 1
    STATE_PROVISIONING = 2
    STATE_RUNNING = 3
    STATE_SUSPENDED = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels associated with this resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  ipv4Cidr = _messages.StringField(3, repeated=True)
  ipv6Cidr = _messages.StringField(4, repeated=True)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  network = _messages.StringField(7)
  state = _messages.EnumField('StateValueValuesEnum', 8)
  updateTime = _messages.StringField(9)
  vlanId = _messages.IntegerField(10, variant=_messages.Variant.INT32)


class Zone(_messages.Message):
  r"""A Google Edge Cloud zone.

  Messages:
    LabelsValue: Labels as key value pairs

  Fields:
    createTime: Output only. The time when the zone was created.
    labels: Labels as key value pairs
    layoutName: The deployment layout type. Defined by the NetworkLayout.name
      in //cloud/kubernetes/edge/network/proto/network_layout.proto The layout
      definition must exist in
      //cloud/kubernetes/edge/network/service/config/network_layout
    migrateToCcfe: Optional. / Skip GNAS site creation if set to true. This
      flag should be used for / migration only.
    name: Required. The resource name of the zone.
    updateTime: Output only. The time when the zone was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  layoutName = _messages.StringField(3)
  migrateToCcfe = _messages.BooleanField(4)
  name = _messages.StringField(5)
  updateTime = _messages.StringField(6)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
