"""Generated message classes for baremetalsolution version v2.

Provides ways to manage Bare Metal Solution hardware installed in a regional
extension located near a Google Cloud data center.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'baremetalsolution'


class AllowedClient(_messages.Message):
  r"""Represents an 'access point' for the share.

  Enums:
    MountPermissionsValueValuesEnum: Mount permissions.

  Fields:
    allowDev: Allow dev flag. Which controls whether to allow creation of
      devices.
    allowSuid: Allow the setuid flag.
    allowedClientsCidr: The subnet of IP addresses permitted to access the
      share.
    mountPermissions: Mount permissions.
    network: The network the access point sits on.
    noRootSquash: Disable root squashing, which is a feature of NFS. Root
      squash is a special mapping of the remote superuser (root) identity when
      using identity authentication.
    shareIp: The IP address of the share on this network.
  """

  class MountPermissionsValueValuesEnum(_messages.Enum):
    r"""Mount permissions.

    Values:
      MOUNT_PERMISSIONS_UNSPECIFIED: Permissions were not specified.
      READ: NFS share can be mount with read-only permissions.
      READ_WRITE: NFS share can be mount with read-write permissions.
    """
    MOUNT_PERMISSIONS_UNSPECIFIED = 0
    READ = 1
    READ_WRITE = 2

  allowDev = _messages.BooleanField(1)
  allowSuid = _messages.BooleanField(2)
  allowedClientsCidr = _messages.StringField(3)
  mountPermissions = _messages.EnumField('MountPermissionsValueValuesEnum', 4)
  network = _messages.StringField(5)
  noRootSquash = _messages.BooleanField(6)
  shareIp = _messages.StringField(7)


class BaremetalsolutionProjectsLocationsGetRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class BaremetalsolutionProjectsLocationsInstancesDisableInteractiveSerialConsoleRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsInstancesDisableInteractiveSerialCon
  soleRequest object.

  Fields:
    disableInteractiveSerialConsoleRequest: A
      DisableInteractiveSerialConsoleRequest resource to be passed as the
      request body.
    name: Required. Name of the resource.
  """

  disableInteractiveSerialConsoleRequest = _messages.MessageField('DisableInteractiveSerialConsoleRequest', 1)
  name = _messages.StringField(2, required=True)


class BaremetalsolutionProjectsLocationsInstancesEnableInteractiveSerialConsoleRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsInstancesEnableInteractiveSerialCons
  oleRequest object.

  Fields:
    enableInteractiveSerialConsoleRequest: A
      EnableInteractiveSerialConsoleRequest resource to be passed as the
      request body.
    name: Required. Name of the resource.
  """

  enableInteractiveSerialConsoleRequest = _messages.MessageField('EnableInteractiveSerialConsoleRequest', 1)
  name = _messages.StringField(2, required=True)


class BaremetalsolutionProjectsLocationsInstancesGetRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsInstancesGetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class BaremetalsolutionProjectsLocationsInstancesListRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsInstancesListRequest object.

  Fields:
    filter: List filter.
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, the server will pick an appropriate default.
    pageToken: A token identifying a page of results from the server.
    parent: Required. Parent value for ListInstancesRequest.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class BaremetalsolutionProjectsLocationsInstancesPatchRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsInstancesPatchRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    name: Output only. The resource name of this `Instance`. Resource names
      are schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. Format:
      `projects/{project}/locations/{location}/instances/{instance}`
    updateMask: The list of fields to update. The only currently supported
      fields are: `labels`
  """

  instance = _messages.MessageField('Instance', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class BaremetalsolutionProjectsLocationsInstancesResetRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsInstancesResetRequest object.

  Fields:
    name: Required. Name of the resource.
    resetInstanceRequest: A ResetInstanceRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  resetInstanceRequest = _messages.MessageField('ResetInstanceRequest', 2)


class BaremetalsolutionProjectsLocationsInstancesStartRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsInstancesStartRequest object.

  Fields:
    name: Required. Name of the resource.
    startInstanceRequest: A StartInstanceRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  startInstanceRequest = _messages.MessageField('StartInstanceRequest', 2)


class BaremetalsolutionProjectsLocationsListRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like "displayName=tokyo", and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class BaremetalsolutionProjectsLocationsNetworksGetRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsNetworksGetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class BaremetalsolutionProjectsLocationsNetworksListNetworkUsageRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsNetworksListNetworkUsageRequest
  object.

  Fields:
    location: Required. Parent value (project and location).
  """

  location = _messages.StringField(1, required=True)


class BaremetalsolutionProjectsLocationsNetworksListRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsNetworksListRequest object.

  Fields:
    filter: List filter.
    pageSize: Requested page size. The server might return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results from the server.
    parent: Required. Parent value for ListNetworksRequest.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class BaremetalsolutionProjectsLocationsNetworksPatchRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsNetworksPatchRequest object.

  Fields:
    name: Output only. The resource name of this `Network`. Resource names are
      schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. Format:
      `projects/{project}/locations/{location}/networks/{network}`
    network: A Network resource to be passed as the request body.
    updateMask: The list of fields to update. The only currently supported
      fields are: `labels`
  """

  name = _messages.StringField(1, required=True)
  network = _messages.MessageField('Network', 2)
  updateMask = _messages.StringField(3)


class BaremetalsolutionProjectsLocationsNfsSharesGetRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsNfsSharesGetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class BaremetalsolutionProjectsLocationsNfsSharesListRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsNfsSharesListRequest object.

  Fields:
    filter: List filter.
    pageSize: Requested page size. The server might return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results from the server.
    parent: Required. Parent value for ListNfsSharesRequest.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class BaremetalsolutionProjectsLocationsNfsSharesPatchRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsNfsSharesPatchRequest object.

  Fields:
    name: Output only. The name of the NFS share.
    nfsShare: A NfsShare resource to be passed as the request body.
    updateMask: The list of fields to update. The only currently supported
      fields are: `labels`
  """

  name = _messages.StringField(1, required=True)
  nfsShare = _messages.MessageField('NfsShare', 2)
  updateMask = _messages.StringField(3)


class BaremetalsolutionProjectsLocationsProvisioningConfigsSubmitRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsProvisioningConfigsSubmitRequest
  object.

  Fields:
    parent: Required. The parent project and location containing the
      ProvisioningConfig.
    submitProvisioningConfigRequest: A SubmitProvisioningConfigRequest
      resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  submitProvisioningConfigRequest = _messages.MessageField('SubmitProvisioningConfigRequest', 2)


class BaremetalsolutionProjectsLocationsProvisioningQuotasListRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsProvisioningQuotasListRequest
  object.

  Fields:
    pageSize: Requested page size. The server might return fewer items than
      requested. If unspecified, server will pick an appropriate default.
      Notice that page_size field is not supported and won't be respected in
      the API request for now, will be updated when pagination is supported.
    pageToken: A token identifying a page of results from the server.
    parent: Required. Parent value for ListProvisioningQuotasRequest.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesCreateRequest(_messages.Message):
  r"""A
  BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesCreateRequest
  object.

  Fields:
    parent: Required. The parent project and location containing the
      SnapshotSchedulePolicy.
    snapshotSchedulePolicy: A SnapshotSchedulePolicy resource to be passed as
      the request body.
    snapshotSchedulePolicyId: Required. Snapshot policy ID
  """

  parent = _messages.StringField(1, required=True)
  snapshotSchedulePolicy = _messages.MessageField('SnapshotSchedulePolicy', 2)
  snapshotSchedulePolicyId = _messages.StringField(3)


class BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesDeleteRequest(_messages.Message):
  r"""A
  BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesDeleteRequest
  object.

  Fields:
    name: Required. The name of the snapshot schedule policy to delete.
  """

  name = _messages.StringField(1, required=True)


class BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesGetRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesGetRequest
  object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesListRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesListRequest
  object.

  Fields:
    filter: List filter.
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: Required. The parent project containing the Snapshot Schedule
      Policies.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesPatchRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesPatchRequest
  object.

  Fields:
    name: Output only. The name of the snapshot schedule policy.
    snapshotSchedulePolicy: A SnapshotSchedulePolicy resource to be passed as
      the request body.
    updateMask: Required. The list of fields to update.
  """

  name = _messages.StringField(1, required=True)
  snapshotSchedulePolicy = _messages.MessageField('SnapshotSchedulePolicy', 2)
  updateMask = _messages.StringField(3)


class BaremetalsolutionProjectsLocationsSshKeysCreateRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsSshKeysCreateRequest object.

  Fields:
    parent: Required. The parent containing the SSH keys.
    sSHKey: A SSHKey resource to be passed as the request body.
    sshKeyId: Required. The ID to use for the key, which will become the final
      component of the key's resource name. This value must match the regex:
      [a-zA-Z0-9@.\-_]{1,64}
  """

  parent = _messages.StringField(1, required=True)
  sSHKey = _messages.MessageField('SSHKey', 2)
  sshKeyId = _messages.StringField(3)


class BaremetalsolutionProjectsLocationsSshKeysDeleteRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsSshKeysDeleteRequest object.

  Fields:
    name: Required. The name of the SSH key to delete. Currently, the only
      valid value for the location is "global".
  """

  name = _messages.StringField(1, required=True)


class BaremetalsolutionProjectsLocationsSshKeysListRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsSshKeysListRequest object.

  Fields:
    pageSize: The maximum number of items to return.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: Required. The parent containing the SSH keys. Currently, the only
      valid value for the location is "global".
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BaremetalsolutionProjectsLocationsVolumesGetRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsVolumesGetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class BaremetalsolutionProjectsLocationsVolumesListRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsVolumesListRequest object.

  Fields:
    filter: List filter.
    pageSize: Requested page size. The server might return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results from the server.
    parent: Required. Parent value for ListVolumesRequest.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class BaremetalsolutionProjectsLocationsVolumesLunsGetRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsVolumesLunsGetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class BaremetalsolutionProjectsLocationsVolumesLunsListRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsVolumesLunsListRequest object.

  Fields:
    pageSize: Requested page size. The server might return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results from the server.
    parent: Required. Parent value for ListLunsRequest.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BaremetalsolutionProjectsLocationsVolumesPatchRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsVolumesPatchRequest object.

  Fields:
    name: Output only. The resource name of this `Volume`. Resource names are
      schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. Format:
      `projects/{project}/locations/{location}/volumes/{volume}`
    updateMask: The list of fields to update. The only currently supported
      fields are: `snapshot_auto_delete_behavior`
      `snapshot_schedule_policy_name` 'labels' 'requested_size_gib'
      'snapshot_enabled' 'snapshot_reservation_detail.reserved_space_percent'
    volume: A Volume resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  updateMask = _messages.StringField(2)
  volume = _messages.MessageField('Volume', 3)


class BaremetalsolutionProjectsLocationsVolumesSnapshotsCreateRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsVolumesSnapshotsCreateRequest
  object.

  Fields:
    parent: Required. The volume to snapshot.
    volumeSnapshot: A VolumeSnapshot resource to be passed as the request
      body.
  """

  parent = _messages.StringField(1, required=True)
  volumeSnapshot = _messages.MessageField('VolumeSnapshot', 2)


class BaremetalsolutionProjectsLocationsVolumesSnapshotsDeleteRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsVolumesSnapshotsDeleteRequest
  object.

  Fields:
    name: Required. The name of the snapshot to delete.
  """

  name = _messages.StringField(1, required=True)


class BaremetalsolutionProjectsLocationsVolumesSnapshotsGetRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsVolumesSnapshotsGetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class BaremetalsolutionProjectsLocationsVolumesSnapshotsListRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsVolumesSnapshotsListRequest object.

  Fields:
    pageSize: Requested page size. The server might return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results from the server.
    parent: Required. Parent value for ListVolumesRequest.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BaremetalsolutionProjectsLocationsVolumesSnapshotsRestoreVolumeSnapshotRequest(_messages.Message):
  r"""A BaremetalsolutionProjectsLocationsVolumesSnapshotsRestoreVolumeSnapsho
  tRequest object.

  Fields:
    restoreVolumeSnapshotRequest: A RestoreVolumeSnapshotRequest resource to
      be passed as the request body.
    volumeSnapshot: Required. Name of the resource.
  """

  restoreVolumeSnapshotRequest = _messages.MessageField('RestoreVolumeSnapshotRequest', 1)
  volumeSnapshot = _messages.StringField(2, required=True)


class DisableInteractiveSerialConsoleRequest(_messages.Message):
  r"""Message for disabling the interactive serial console on an instance."""


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class EnableInteractiveSerialConsoleRequest(_messages.Message):
  r"""Message for enabling the interactive serial console on an instance."""


class Instance(_messages.Message):
  r"""A server.

  Enums:
    StateValueValuesEnum: The state of the server.

  Messages:
    LabelsValue: Labels as key value pairs.

  Fields:
    createTime: Output only. Create a time stamp.
    hyperthreadingEnabled: True if you enable hyperthreading for the server,
      otherwise false. The default value is false.
    id: An identifier for the `Instance`, generated by the backend.
    interactiveSerialConsoleEnabled: True if the interactive serial console
      feature is enabled for the instance, false otherwise. The default value
      is false.
    labels: Labels as key value pairs.
    luns: List of LUNs associated with this server.
    machineType: The server type. [Available server
      types](https://cloud.google.com/bare-metal/docs/bms-
      planning#server_configurations)
    name: Output only. The resource name of this `Instance`. Resource names
      are schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. Format:
      `projects/{project}/locations/{location}/instances/{instance}`
    networks: List of networks associated with this server.
    state: The state of the server.
    updateTime: Output only. Update a time stamp.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of the server.

    Values:
      STATE_UNSPECIFIED: The server is in an unknown state.
      PROVISIONING: The server is being provisioned.
      RUNNING: The server is running.
      DELETED: The server has been deleted.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    RUNNING = 2
    DELETED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  hyperthreadingEnabled = _messages.BooleanField(2)
  id = _messages.StringField(3)
  interactiveSerialConsoleEnabled = _messages.BooleanField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  luns = _messages.MessageField('Lun', 6, repeated=True)
  machineType = _messages.StringField(7)
  name = _messages.StringField(8)
  networks = _messages.MessageField('Network', 9, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  updateTime = _messages.StringField(11)


class InstanceConfig(_messages.Message):
  r"""Configuration parameters for a new instance.

  Fields:
    clientNetwork: Client network address.
    hyperthreading: Whether the instance should be provisioned with
      Hyperthreading enabled.
    id: A transient unique identifier to idenfity an instance within an
      ProvisioningConfig request.
    instanceType: Instance type. [Available
      types](https://cloud.google.com/bare-metal/docs/bms-
      planning#server_configurations)
    name: Output only. The name of the instance config.
    osImage: OS image to initialize the instance. [Available
      images](https://cloud.google.com/bare-metal/docs/bms-
      planning#server_configurations)
    privateNetwork: Private network address, if any.
    userNote: User note field, it can be used by customers to add additional
      information for the BMS Ops team .
  """

  clientNetwork = _messages.MessageField('NetworkAddress', 1)
  hyperthreading = _messages.BooleanField(2)
  id = _messages.StringField(3)
  instanceType = _messages.StringField(4)
  name = _messages.StringField(5)
  osImage = _messages.StringField(6)
  privateNetwork = _messages.MessageField('NetworkAddress', 7)
  userNote = _messages.StringField(8)


class InstanceQuota(_messages.Message):
  r"""A resource budget.

  Fields:
    availableMachineCount: Number of machines than can be created for the
      given location and instance_type.
    instanceType: Instance type.
    location: Location where the quota applies.
    name: Output only. The name of the instance quota.
  """

  availableMachineCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  instanceType = _messages.StringField(2)
  location = _messages.StringField(3)
  name = _messages.StringField(4)


class IntakeVlanAttachment(_messages.Message):
  r"""A GCP vlan attachment.

  Fields:
    id: Identifier of the VLAN attachment.
    pairingKey: Attachment pairing key.
  """

  id = _messages.StringField(1)
  pairingKey = _messages.StringField(2)


class ListInstancesResponse(_messages.Message):
  r"""Response message for the list of servers.

  Fields:
    instances: The list of servers.
    nextPageToken: A token identifying a page of results from the server.
    unreachable: Locations that could not be reached.
  """

  instances = _messages.MessageField('Instance', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLunsResponse(_messages.Message):
  r"""Response message containing the list of storage volume luns.

  Fields:
    luns: The list of luns.
    nextPageToken: A token identifying a page of results from the server.
    unreachable: Locations that could not be reached.
  """

  luns = _messages.MessageField('Lun', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListNetworkUsageResponse(_messages.Message):
  r"""Response with Networks with IPs

  Fields:
    networks: Networks with IPs.
  """

  networks = _messages.MessageField('NetworkUsage', 1, repeated=True)


class ListNetworksResponse(_messages.Message):
  r"""Response message containing the list of networks.

  Fields:
    networks: The list of networks.
    nextPageToken: A token identifying a page of results from the server.
    unreachable: Locations that could not be reached.
  """

  networks = _messages.MessageField('Network', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListNfsSharesResponse(_messages.Message):
  r"""Response message containing the list of NFS shares.

  Fields:
    nextPageToken: A token identifying a page of results from the server.
    nfsShares: The list of NFS shares.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  nfsShares = _messages.MessageField('NfsShare', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListProvisioningQuotasResponse(_messages.Message):
  r"""Response message for the list of provisioning quotas.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    provisioningQuotas: The provisioning quotas registered in this project.
  """

  nextPageToken = _messages.StringField(1)
  provisioningQuotas = _messages.MessageField('ProvisioningQuota', 2, repeated=True)


class ListSSHKeysResponse(_messages.Message):
  r"""Message for response of ListSSHKeys.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    sshKeys: The SSH keys registered in the project.
  """

  nextPageToken = _messages.StringField(1)
  sshKeys = _messages.MessageField('SSHKey', 2, repeated=True)


class ListSnapshotSchedulePoliciesResponse(_messages.Message):
  r"""Response message containing the list of snapshot schedule policies.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    snapshotSchedulePolicies: The snapshot schedule policies registered in
      this project.
  """

  nextPageToken = _messages.StringField(1)
  snapshotSchedulePolicies = _messages.MessageField('SnapshotSchedulePolicy', 2, repeated=True)


class ListVolumeSnapshotsResponse(_messages.Message):
  r"""Response message containing the list of storage volume snapshots.

  Fields:
    nextPageToken: A token identifying a page of results from the server.
    unreachable: Locations that could not be reached.
    volumeSnapshots: The list of storage volumes.
  """

  nextPageToken = _messages.StringField(1)
  unreachable = _messages.StringField(2, repeated=True)
  volumeSnapshots = _messages.MessageField('VolumeSnapshot', 3, repeated=True)


class ListVolumesResponse(_messages.Message):
  r"""Response message containing the list of storage volumes.

  Fields:
    nextPageToken: A token identifying a page of results from the server.
    unreachable: Locations that could not be reached.
    volumes: The list of storage volumes.
  """

  nextPageToken = _messages.StringField(1)
  unreachable = _messages.StringField(2, repeated=True)
  volumes = _messages.MessageField('Volume', 3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Lun(_messages.Message):
  r"""A storage volume logical unit number (LUN).

  Enums:
    MultiprotocolTypeValueValuesEnum: The LUN multiprotocol type ensures the
      characteristics of the LUN are optimized for each operating system.
    StateValueValuesEnum: The state of this storage volume.
    StorageTypeValueValuesEnum: The storage type for this LUN.

  Fields:
    bootLun: Display if this LUN is a boot LUN.
    id: An identifier for the LUN, generated by the backend.
    multiprotocolType: The LUN multiprotocol type ensures the characteristics
      of the LUN are optimized for each operating system.
    name: Output only. The name of the LUN.
    shareable: Display if this LUN can be shared between multiple physical
      servers.
    sizeGb: The size of this LUN, in gigabytes.
    state: The state of this storage volume.
    storageType: The storage type for this LUN.
    storageVolume: Display the storage volume for this LUN.
    wwid: The WWID for this LUN.
  """

  class MultiprotocolTypeValueValuesEnum(_messages.Enum):
    r"""The LUN multiprotocol type ensures the characteristics of the LUN are
    optimized for each operating system.

    Values:
      MULTIPROTOCOL_TYPE_UNSPECIFIED: Server has no OS specified.
      LINUX: Server with Linux OS.
    """
    MULTIPROTOCOL_TYPE_UNSPECIFIED = 0
    LINUX = 1

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of this storage volume.

    Values:
      STATE_UNSPECIFIED: The LUN is in an unknown state.
      CREATING: The LUN is being created.
      UPDATING: The LUN is being updated.
      READY: The LUN is ready for use.
      DELETING: The LUN has been requested to be deleted.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    UPDATING = 2
    READY = 3
    DELETING = 4

  class StorageTypeValueValuesEnum(_messages.Enum):
    r"""The storage type for this LUN.

    Values:
      STORAGE_TYPE_UNSPECIFIED: The storage type for this LUN is unknown.
      SSD: This storage type for this LUN is SSD.
      HDD: This storage type for this LUN is HDD.
    """
    STORAGE_TYPE_UNSPECIFIED = 0
    SSD = 1
    HDD = 2

  bootLun = _messages.BooleanField(1)
  id = _messages.StringField(2)
  multiprotocolType = _messages.EnumField('MultiprotocolTypeValueValuesEnum', 3)
  name = _messages.StringField(4)
  shareable = _messages.BooleanField(5)
  sizeGb = _messages.IntegerField(6)
  state = _messages.EnumField('StateValueValuesEnum', 7)
  storageType = _messages.EnumField('StorageTypeValueValuesEnum', 8)
  storageVolume = _messages.StringField(9)
  wwid = _messages.StringField(10)


class LunRange(_messages.Message):
  r"""A LUN(Logical Unit Number) range.

  Fields:
    quantity: Number of LUNs to create.
    sizeGb: The requested size of each LUN, in GB.
  """

  quantity = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  sizeGb = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class Network(_messages.Message):
  r"""A Network.

  Enums:
    StateValueValuesEnum: The Network state.
    TypeValueValuesEnum: The type of this network.

  Messages:
    LabelsValue: Labels as key value pairs.

  Fields:
    cidr: The cidr of the Network.
    id: An identifier for the `Network`, generated by the backend.
    ipAddress: IP address configured.
    labels: Labels as key value pairs.
    macAddress: List of physical interfaces.
    name: Output only. The resource name of this `Network`. Resource names are
      schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. Format:
      `projects/{project}/locations/{location}/networks/{network}`
    servicesCidr: IP range for reserved for services (e.g. NFS).
    state: The Network state.
    type: The type of this network.
    vlanId: The vlan id of the Network.
    vrf: The vrf for the Network.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The Network state.

    Values:
      STATE_UNSPECIFIED: The Network is in an unknown state.
      PROVISIONING: The Network is provisioning.
      PROVISIONED: The Network has been provisioned.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    PROVISIONED = 2

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of this network.

    Values:
      TYPE_UNSPECIFIED: Unspecified value.
      CLIENT: Client network, a network peered to a Google Cloud VPC.
      PRIVATE: Private network, a network local to the Bare Metal Solution
        environment.
    """
    TYPE_UNSPECIFIED = 0
    CLIENT = 1
    PRIVATE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  cidr = _messages.StringField(1)
  id = _messages.StringField(2)
  ipAddress = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  macAddress = _messages.StringField(5, repeated=True)
  name = _messages.StringField(6)
  servicesCidr = _messages.StringField(7)
  state = _messages.EnumField('StateValueValuesEnum', 8)
  type = _messages.EnumField('TypeValueValuesEnum', 9)
  vlanId = _messages.StringField(10)
  vrf = _messages.MessageField('VRF', 11)


class NetworkAddress(_messages.Message):
  r"""A network.

  Fields:
    address: IPv4 address to be assigned to the server.
    existingNetworkId: Name of the existing network to use.
    networkId: Id of the network to use, within the same ProvisioningConfig
      request.
  """

  address = _messages.StringField(1)
  existingNetworkId = _messages.StringField(2)
  networkId = _messages.StringField(3)


class NetworkConfig(_messages.Message):
  r"""Configuration parameters for a new network.

  Enums:
    BandwidthValueValuesEnum: Interconnect bandwidth. Set only when type is
      CLIENT.
    ServiceCidrValueValuesEnum: Service CIDR, if any.
    TypeValueValuesEnum: The type of this network, either Client or Private.

  Fields:
    bandwidth: Interconnect bandwidth. Set only when type is CLIENT.
    cidr: CIDR range of the network.
    gcpService: The GCP service of the network. Available gcp_service are in
      https://cloud.google.com/bare-metal/docs/bms-planning.
    id: A transient unique identifier to identify a volume within an
      ProvisioningConfig request.
    name: Output only. The name of the network config.
    serviceCidr: Service CIDR, if any.
    type: The type of this network, either Client or Private.
    userNote: User note field, it can be used by customers to add additional
      information for the BMS Ops team (b/194021617).
    vlanAttachments: List of VLAN attachments. As of now there are always 2
      attachments, but it is going to change in the future (multi vlan).
  """

  class BandwidthValueValuesEnum(_messages.Enum):
    r"""Interconnect bandwidth. Set only when type is CLIENT.

    Values:
      BANDWIDTH_UNSPECIFIED: Unspecified value.
      BW_1_GBPS: 1 Gbps.
      BW_2_GBPS: 2 Gbps.
      BW_5_GBPS: 5 Gbps.
      BW_10_GBPS: 10 Gbps.
    """
    BANDWIDTH_UNSPECIFIED = 0
    BW_1_GBPS = 1
    BW_2_GBPS = 2
    BW_5_GBPS = 3
    BW_10_GBPS = 4

  class ServiceCidrValueValuesEnum(_messages.Enum):
    r"""Service CIDR, if any.

    Values:
      SERVICE_CIDR_UNSPECIFIED: Unspecified value.
      DISABLED: Services are disabled for the given network.
      HIGH_26: Use the highest /26 block of the network to host services.
      HIGH_27: Use the highest /27 block of the network to host services.
      HIGH_28: Use the highest /28 block of the network to host services.
    """
    SERVICE_CIDR_UNSPECIFIED = 0
    DISABLED = 1
    HIGH_26 = 2
    HIGH_27 = 3
    HIGH_28 = 4

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of this network, either Client or Private.

    Values:
      TYPE_UNSPECIFIED: Unspecified value.
      CLIENT: Client network, that is a network peered to a GCP VPC.
      PRIVATE: Private network, that is a network local to the BMS POD.
    """
    TYPE_UNSPECIFIED = 0
    CLIENT = 1
    PRIVATE = 2

  bandwidth = _messages.EnumField('BandwidthValueValuesEnum', 1)
  cidr = _messages.StringField(2)
  gcpService = _messages.StringField(3)
  id = _messages.StringField(4)
  name = _messages.StringField(5)
  serviceCidr = _messages.EnumField('ServiceCidrValueValuesEnum', 6)
  type = _messages.EnumField('TypeValueValuesEnum', 7)
  userNote = _messages.StringField(8)
  vlanAttachments = _messages.MessageField('IntakeVlanAttachment', 9, repeated=True)


class NetworkUsage(_messages.Message):
  r"""Network with all used IP addresses.

  Fields:
    network: Network.
    usedIps: All used IP addresses in this network.
  """

  network = _messages.MessageField('Network', 1)
  usedIps = _messages.StringField(2, repeated=True)


class NfsExport(_messages.Message):
  r"""A NFS export entry.

  Enums:
    PermissionsValueValuesEnum: Export permissions.

  Fields:
    allowDev: Allow dev flag in NfsShare AllowedClientsRequest.
    allowSuid: Allow the setuid flag.
    cidr: A CIDR range.
    machineId: Either a single machine, identified by an ID, or a comma-
      separated list of machine IDs.
    networkId: Network to use to publish the export.
    noRootSquash: Disable root squashing, which is a feature of NFS. Root
      squash is a special mapping of the remote superuser (root) identity when
      using identity authentication.
    permissions: Export permissions.
  """

  class PermissionsValueValuesEnum(_messages.Enum):
    r"""Export permissions.

    Values:
      PERMISSIONS_UNSPECIFIED: Unspecified value.
      READ_ONLY: Read-only permission.
      READ_WRITE: Read-write permission.
    """
    PERMISSIONS_UNSPECIFIED = 0
    READ_ONLY = 1
    READ_WRITE = 2

  allowDev = _messages.BooleanField(1)
  allowSuid = _messages.BooleanField(2)
  cidr = _messages.StringField(3)
  machineId = _messages.StringField(4)
  networkId = _messages.StringField(5)
  noRootSquash = _messages.BooleanField(6)
  permissions = _messages.EnumField('PermissionsValueValuesEnum', 7)


class NfsShare(_messages.Message):
  r"""An NFS share.

  Enums:
    StateValueValuesEnum: The state of the NFS share.

  Messages:
    LabelsValue: Labels as key value pairs.

  Fields:
    allowedClients: List of allowed access points.
    labels: Labels as key value pairs.
    name: Output only. The name of the NFS share.
    nfsShareId: Output only. An identifier for the NFS share, generated by the
      backend.
    state: The state of the NFS share.
    volume: The volume containing the share.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of the NFS share.

    Values:
      STATE_UNSPECIFIED: The share is in an unknown state.
      PROVISIONED: The share has been provisioned.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONED = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  allowedClients = _messages.MessageField('AllowedClient', 1, repeated=True)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  nfsShareId = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  volume = _messages.StringField(6)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class ProvisioningConfig(_messages.Message):
  r"""A provisioning configuration.

  Fields:
    handoverServiceAccount: A service account to enable customers to access
      instance credentials upon handover.
    instances: Instances to be created.
    name: Output only. The name of the provisioning config.
    networks: Networks to be created.
    ticketId: A generated buganizer id to track provisioning request.
    volumes: Volumes to be created.
  """

  handoverServiceAccount = _messages.StringField(1)
  instances = _messages.MessageField('InstanceConfig', 2, repeated=True)
  name = _messages.StringField(3)
  networks = _messages.MessageField('NetworkConfig', 4, repeated=True)
  ticketId = _messages.StringField(5)
  volumes = _messages.MessageField('VolumeConfig', 6, repeated=True)


class ProvisioningQuota(_messages.Message):
  r"""A provisioning quota for a given project.

  Enums:
    AssetTypeValueValuesEnum: The asset type of this provisioning quota.

  Fields:
    assetType: The asset type of this provisioning quota.
    availableCount: The available count of the provisioning quota.
    gcpService: The gcp service of the provisioning quota.
    instanceQuota: Instance quota.
    location: The specific location of the provisioining quota.
    name: Output only. The name of the provisioning quota.
  """

  class AssetTypeValueValuesEnum(_messages.Enum):
    r"""The asset type of this provisioning quota.

    Values:
      ASSET_TYPE_UNSPECIFIED: The unspecified type.
      ASSET_TYPE_SERVER: The server asset type.
      ASSET_TYPE_STORAGE: The storage asset type.
      ASSET_TYPE_NETWORK: The network asset type.
    """
    ASSET_TYPE_UNSPECIFIED = 0
    ASSET_TYPE_SERVER = 1
    ASSET_TYPE_STORAGE = 2
    ASSET_TYPE_NETWORK = 3

  assetType = _messages.EnumField('AssetTypeValueValuesEnum', 1)
  availableCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  gcpService = _messages.StringField(3)
  instanceQuota = _messages.MessageField('InstanceQuota', 4)
  location = _messages.StringField(5)
  name = _messages.StringField(6)


class QosPolicy(_messages.Message):
  r"""QOS policy parameters.

  Fields:
    bandwidthGbps: The bandwidth permitted by the QOS policy, in gbps.
  """

  bandwidthGbps = _messages.FloatField(1)


class ResetInstanceRequest(_messages.Message):
  r"""Message requesting to reset a server."""


class RestoreVolumeSnapshotRequest(_messages.Message):
  r"""Message for restoring a volume snapshot."""


class SSHKey(_messages.Message):
  r"""An SSH key, used for authorizing with the interactive serial console
  feature.

  Fields:
    name: Output only. The name of this SSH key. Currently, the only valid
      value for the location is "global".
    publicKey: The public SSH key. This must be in OpenSSH .authorized_keys
      format.
  """

  name = _messages.StringField(1)
  publicKey = _messages.StringField(2)


class Schedule(_messages.Message):
  r"""A snapshot schedule.

  Fields:
    crontabSpec: A crontab-like specification that the schedule uses to take
      snapshots.
    prefix: A list of snapshot names created in this schedule.
    retentionCount: The maximum number of snapshots to retain in this
      schedule.
  """

  crontabSpec = _messages.StringField(1)
  prefix = _messages.StringField(2)
  retentionCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class SnapshotReservationDetail(_messages.Message):
  r"""Details about snapshot space reservation and usage on the storage
  volume.

  Fields:
    reservedSpaceGib: The space on this storage volume reserved for snapshots,
      shown in GiB.
    reservedSpacePercent: Percent of the total Volume size reserved for
      snapshot copies. Enabling snapshots requires reserving 20% or more of
      the storage volume space for snapshots. Maximum reserved space for
      snapshots is 40%. Setting this field will effectively set
      snapshot_enabled to true.
    reservedSpaceRemainingGib: The amount, in GiB, of available space in this
      storage volume's reserved snapshot space.
    reservedSpaceUsedPercent: The percent of snapshot space on this storage
      volume actually being used by the snapshot copies. This value might be
      higher than 100% if the snapshot copies have overflowed into the data
      portion of the storage volume.
  """

  reservedSpaceGib = _messages.IntegerField(1)
  reservedSpacePercent = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  reservedSpaceRemainingGib = _messages.IntegerField(3)
  reservedSpaceUsedPercent = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class SnapshotSchedulePolicy(_messages.Message):
  r"""A snapshot schedule policy.

  Enums:
    StateValueValuesEnum: The state of the snapshot schedule policy.

  Messages:
    LabelsValue: Labels as key value pairs.

  Fields:
    description: The description of the snapshot schedule policy.
    id: An identifier for the snapshot schedule policy, generated by the
      backend.
    labels: Labels as key value pairs.
    name: Output only. The name of the snapshot schedule policy.
    schedules: The snapshot schedules contained in this policy. You can
      specify a maximum of 5 schedules.
    state: The state of the snapshot schedule policy.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of the snapshot schedule policy.

    Values:
      STATE_UNSPECIFIED: The policy is in an unknown state.
      PROVISIONED: The policy is been provisioned.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONED = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  description = _messages.StringField(1)
  id = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  schedules = _messages.MessageField('Schedule', 5, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 6)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class StartInstanceRequest(_messages.Message):
  r"""Message requesting to start a server."""


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class SubmitProvisioningConfigRequest(_messages.Message):
  r"""Request for SubmitProvisioningConfig.

  Fields:
    email: Optional. Email provided to send a confirmation with provisioning
      config to.
    provisioningConfig: Required. The ProvisioningConfig to create.
  """

  email = _messages.StringField(1)
  provisioningConfig = _messages.MessageField('ProvisioningConfig', 2)


class SubmitProvisioningConfigResponse(_messages.Message):
  r"""Response for SubmitProvisioningConfig.

  Fields:
    provisioningConfig: The submitted provisioning config.
  """

  provisioningConfig = _messages.MessageField('ProvisioningConfig', 1)


class VRF(_messages.Message):
  r"""A network VRF.

  Enums:
    StateValueValuesEnum: The possible state of VRF.

  Fields:
    name: The name of the VRF.
    qosPolicy: The QOS policy applied to this VRF.
    state: The possible state of VRF.
    vlanAttachments: The list of VLAN attachments for the VRF.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The possible state of VRF.

    Values:
      STATE_UNSPECIFIED: The unspecified state.
      PROVISIONING: The vrf is provisioning.
      PROVISIONED: The vrf is provisioned.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    PROVISIONED = 2

  name = _messages.StringField(1)
  qosPolicy = _messages.MessageField('QosPolicy', 2)
  state = _messages.EnumField('StateValueValuesEnum', 3)
  vlanAttachments = _messages.MessageField('VlanAttachment', 4, repeated=True)


class VlanAttachment(_messages.Message):
  r"""VLAN attachment details.

  Fields:
    peerIp: The peer IP of the attachment.
    peerVlanId: The peer vlan ID of the attachment.
    routerIp: The router IP of the attachment.
  """

  peerIp = _messages.StringField(1)
  peerVlanId = _messages.IntegerField(2)
  routerIp = _messages.StringField(3)


class Volume(_messages.Message):
  r"""A storage volume.

  Enums:
    SnapshotAutoDeleteBehaviorValueValuesEnum: The behavior to use when
      snapshot reserved space is full.
    StateValueValuesEnum: The state of this storage volume.
    StorageTypeValueValuesEnum: The storage type for this volume.

  Messages:
    LabelsValue: Labels as key value pairs.

  Fields:
    autoGrownSizeGib: The size, in GiB, that this storage volume has expanded
      as a result of an auto grow policy. In the absence of auto-grow, the
      value is 0.
    currentSizeGib: The current size of this storage volume, in GiB, including
      space reserved for snapshots. This size might be different than the
      requested size if the storage volume has been configured with auto grow
      or auto shrink.
    id: An identifier for the `Volume`, generated by the backend.
    labels: Labels as key value pairs.
    name: Output only. The resource name of this `Volume`. Resource names are
      schemeless URIs that follow the conventions in
      https://cloud.google.com/apis/design/resource_names. Format:
      `projects/{project}/locations/{location}/volumes/{volume}`
    remainingSpaceGib: The space remaining in the storage volume for new LUNs,
      in GiB, excluding space reserved for snapshots.
    requestedSizeGib: The requested size of this storage volume, in GiB.
    snapshotAutoDeleteBehavior: The behavior to use when snapshot reserved
      space is full.
    snapshotEnabled: Whether snapshots are enabled.
    snapshotReservationDetail: Details about snapshot space reservation and
      usage on the storage volume.
    snapshotSchedulePolicy: The name of the snapshot schedule policy in use
      for this volume, if any.
    state: The state of this storage volume.
    storageType: The storage type for this volume.
  """

  class SnapshotAutoDeleteBehaviorValueValuesEnum(_messages.Enum):
    r"""The behavior to use when snapshot reserved space is full.

    Values:
      SNAPSHOT_AUTO_DELETE_BEHAVIOR_UNSPECIFIED: The unspecified behavior.
      DISABLED: Don't delete any snapshots. This disables new snapshot
        creation, as long as the snapshot reserved space is full.
      OLDEST_FIRST: Delete the oldest snapshots first.
      NEWEST_FIRST: Delete the newest snapshots first.
    """
    SNAPSHOT_AUTO_DELETE_BEHAVIOR_UNSPECIFIED = 0
    DISABLED = 1
    OLDEST_FIRST = 2
    NEWEST_FIRST = 3

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of this storage volume.

    Values:
      STATE_UNSPECIFIED: The storage volume is in an unknown state.
      CREATING: The storage volume is being created.
      READY: The storage volume is ready for use.
      DELETING: The storage volume has been requested to be deleted.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    DELETING = 3

  class StorageTypeValueValuesEnum(_messages.Enum):
    r"""The storage type for this volume.

    Values:
      STORAGE_TYPE_UNSPECIFIED: The storage type for this volume is unknown.
      SSD: The storage type for this volume is SSD.
      HDD: This storage type for this volume is HDD.
    """
    STORAGE_TYPE_UNSPECIFIED = 0
    SSD = 1
    HDD = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  autoGrownSizeGib = _messages.IntegerField(1)
  currentSizeGib = _messages.IntegerField(2)
  id = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  remainingSpaceGib = _messages.IntegerField(6)
  requestedSizeGib = _messages.IntegerField(7)
  snapshotAutoDeleteBehavior = _messages.EnumField('SnapshotAutoDeleteBehaviorValueValuesEnum', 8)
  snapshotEnabled = _messages.BooleanField(9)
  snapshotReservationDetail = _messages.MessageField('SnapshotReservationDetail', 10)
  snapshotSchedulePolicy = _messages.StringField(11)
  state = _messages.EnumField('StateValueValuesEnum', 12)
  storageType = _messages.EnumField('StorageTypeValueValuesEnum', 13)


class VolumeConfig(_messages.Message):
  r"""Configuration parameters for a new volume.

  Enums:
    ProtocolValueValuesEnum: Volume protocol.
    TypeValueValuesEnum: The type of this Volume.

  Fields:
    gcpService: The GCP service of the storage volume. Available gcp_service
      are in https://cloud.google.com/bare-metal/docs/bms-planning.
    id: A transient unique identifier to identify a volume within an
      ProvisioningConfig request.
    lunRanges: LUN ranges to be configured. Set only when protocol is
      PROTOCOL_FC.
    machineIds: Machine ids connected to this volume. Set only when protocol
      is PROTOCOL_FC.
    name: Output only. The name of the volume config.
    nfsExports: NFS exports. Set only when protocol is PROTOCOL_NFS.
    protocol: Volume protocol.
    sizeGb: The requested size of this volume, in GB.
    snapshotsEnabled: Whether snapshots should be enabled.
    type: The type of this Volume.
    userNote: User note field, it can be used by customers to add additional
      information for the BMS Ops team (b/194021617).
  """

  class ProtocolValueValuesEnum(_messages.Enum):
    r"""Volume protocol.

    Values:
      PROTOCOL_UNSPECIFIED: Unspecified value.
      PROTOCOL_FC: Fibre channel.
      PROTOCOL_NFS: Network file system.
    """
    PROTOCOL_UNSPECIFIED = 0
    PROTOCOL_FC = 1
    PROTOCOL_NFS = 2

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of this Volume.

    Values:
      TYPE_UNSPECIFIED: The unspecified type.
      FLASH: This Volume is on flash.
      DISK: This Volume is on disk.
    """
    TYPE_UNSPECIFIED = 0
    FLASH = 1
    DISK = 2

  gcpService = _messages.StringField(1)
  id = _messages.StringField(2)
  lunRanges = _messages.MessageField('LunRange', 3, repeated=True)
  machineIds = _messages.StringField(4, repeated=True)
  name = _messages.StringField(5)
  nfsExports = _messages.MessageField('NfsExport', 6, repeated=True)
  protocol = _messages.EnumField('ProtocolValueValuesEnum', 7)
  sizeGb = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  snapshotsEnabled = _messages.BooleanField(9)
  type = _messages.EnumField('TypeValueValuesEnum', 10)
  userNote = _messages.StringField(11)


class VolumeSnapshot(_messages.Message):
  r"""Snapshot registered for a given storage volume.

  Fields:
    createTime: Output only. The creation time of the storage volume snapshot.
    description: The description of the storage volume snapshot.
    id: An identifier for the snapshot, generated by the backend.
    name: Output only. The name of the storage volume snapshot.
    sizeBytes: The size of the storage volume snapshot, in bytes.
    storageVolume: The storage volume this snapshot belongs to.
  """

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  id = _messages.StringField(3)
  name = _messages.StringField(4)
  sizeBytes = _messages.IntegerField(5)
  storageVolume = _messages.StringField(6)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
