"""Generated client library for baremetalsolution version v2."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.baremetalsolution.v2 import baremetalsolution_v2_messages as messages


class BaremetalsolutionV2(base_api.BaseApiClient):
  """Generated client library for service baremetalsolution version v2."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://baremetalsolution.googleapis.com/'
  MTLS_BASE_URL = 'https://baremetalsolution.mtls.googleapis.com/'

  _PACKAGE = 'baremetalsolution'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v2'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'BaremetalsolutionV2'
  _URL_VERSION = 'v2'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new baremetalsolution handle."""
    url = url or self.BASE_URL
    super(BaremetalsolutionV2, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_instances = self.ProjectsLocationsInstancesService(self)
    self.projects_locations_networks = self.ProjectsLocationsNetworksService(self)
    self.projects_locations_nfsShares = self.ProjectsLocationsNfsSharesService(self)
    self.projects_locations_snapshotSchedulePolicies = self.ProjectsLocationsSnapshotSchedulePoliciesService(self)
    self.projects_locations_volumes_luns = self.ProjectsLocationsVolumesLunsService(self)
    self.projects_locations_volumes_snapshots = self.ProjectsLocationsVolumesSnapshotsService(self)
    self.projects_locations_volumes = self.ProjectsLocationsVolumesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsInstancesService(base_api.BaseApiService):
    """Service class for the projects_locations_instances resource."""

    _NAME = 'projects_locations_instances'

    def __init__(self, client):
      super(BaremetalsolutionV2.ProjectsLocationsInstancesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get details about a single server.

      Args:
        request: (BaremetalsolutionProjectsLocationsInstancesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Instance) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/instances/{instancesId}',
        http_method='GET',
        method_id='baremetalsolution.projects.locations.instances.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsInstancesGetRequest',
        response_type_name='Instance',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List servers in a given project and location.

      Args:
        request: (BaremetalsolutionProjectsLocationsInstancesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListInstancesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/instances',
        http_method='GET',
        method_id='baremetalsolution.projects.locations.instances.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v2/{+parent}/instances',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsInstancesListRequest',
        response_type_name='ListInstancesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update details of a single server.

      Args:
        request: (BaremetalsolutionProjectsLocationsInstancesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/instances/{instancesId}',
        http_method='PATCH',
        method_id='baremetalsolution.projects.locations.instances.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v2/{+name}',
        request_field='instance',
        request_type_name='BaremetalsolutionProjectsLocationsInstancesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Reset(self, request, global_params=None):
      r"""Perform an ungraceful, hard reset on a server. Equivalent to shutting the power off and then turning it back on.

      Args:
        request: (BaremetalsolutionProjectsLocationsInstancesResetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Reset')
      return self._RunMethod(
          config, request, global_params=global_params)

    Reset.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/instances/{instancesId}:reset',
        http_method='POST',
        method_id='baremetalsolution.projects.locations.instances.reset',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}:reset',
        request_field='resetInstanceRequest',
        request_type_name='BaremetalsolutionProjectsLocationsInstancesResetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Start(self, request, global_params=None):
      r"""Starts a server that was shutdown.

      Args:
        request: (BaremetalsolutionProjectsLocationsInstancesStartRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Start')
      return self._RunMethod(
          config, request, global_params=global_params)

    Start.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/instances/{instancesId}:start',
        http_method='POST',
        method_id='baremetalsolution.projects.locations.instances.start',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}:start',
        request_field='startInstanceRequest',
        request_type_name='BaremetalsolutionProjectsLocationsInstancesStartRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsNetworksService(base_api.BaseApiService):
    """Service class for the projects_locations_networks resource."""

    _NAME = 'projects_locations_networks'

    def __init__(self, client):
      super(BaremetalsolutionV2.ProjectsLocationsNetworksService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get details of a single network.

      Args:
        request: (BaremetalsolutionProjectsLocationsNetworksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Network) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/networks/{networksId}',
        http_method='GET',
        method_id='baremetalsolution.projects.locations.networks.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsNetworksGetRequest',
        response_type_name='Network',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List network in a given project and location.

      Args:
        request: (BaremetalsolutionProjectsLocationsNetworksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNetworksResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/networks',
        http_method='GET',
        method_id='baremetalsolution.projects.locations.networks.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v2/{+parent}/networks',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsNetworksListRequest',
        response_type_name='ListNetworksResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update details of a single network.

      Args:
        request: (BaremetalsolutionProjectsLocationsNetworksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/networks/{networksId}',
        http_method='PATCH',
        method_id='baremetalsolution.projects.locations.networks.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v2/{+name}',
        request_field='network',
        request_type_name='BaremetalsolutionProjectsLocationsNetworksPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsNfsSharesService(base_api.BaseApiService):
    """Service class for the projects_locations_nfsShares resource."""

    _NAME = 'projects_locations_nfsShares'

    def __init__(self, client):
      super(BaremetalsolutionV2.ProjectsLocationsNfsSharesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get details of a single NFS share.

      Args:
        request: (BaremetalsolutionProjectsLocationsNfsSharesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NfsShare) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/nfsShares/{nfsSharesId}',
        http_method='GET',
        method_id='baremetalsolution.projects.locations.nfsShares.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsNfsSharesGetRequest',
        response_type_name='NfsShare',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List NFS shares.

      Args:
        request: (BaremetalsolutionProjectsLocationsNfsSharesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNfsSharesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/nfsShares',
        http_method='GET',
        method_id='baremetalsolution.projects.locations.nfsShares.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2/{+parent}/nfsShares',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsNfsSharesListRequest',
        response_type_name='ListNfsSharesResponse',
        supports_download=False,
    )

  class ProjectsLocationsSnapshotSchedulePoliciesService(base_api.BaseApiService):
    """Service class for the projects_locations_snapshotSchedulePolicies resource."""

    _NAME = 'projects_locations_snapshotSchedulePolicies'

    def __init__(self, client):
      super(BaremetalsolutionV2.ProjectsLocationsSnapshotSchedulePoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Create a snapshot schedule policy in the specified project.

      Args:
        request: (BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SnapshotSchedulePolicy) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/snapshotSchedulePolicies',
        http_method='POST',
        method_id='baremetalsolution.projects.locations.snapshotSchedulePolicies.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['snapshotSchedulePolicyId'],
        relative_path='v2/{+parent}/snapshotSchedulePolicies',
        request_field='snapshotSchedulePolicy',
        request_type_name='BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesCreateRequest',
        response_type_name='SnapshotSchedulePolicy',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Delete a named snapshot schedule policy.

      Args:
        request: (BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/snapshotSchedulePolicies/{snapshotSchedulePoliciesId}',
        http_method='DELETE',
        method_id='baremetalsolution.projects.locations.snapshotSchedulePolicies.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get details of a single snapshot schedule policy.

      Args:
        request: (BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SnapshotSchedulePolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/snapshotSchedulePolicies/{snapshotSchedulePoliciesId}',
        http_method='GET',
        method_id='baremetalsolution.projects.locations.snapshotSchedulePolicies.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesGetRequest',
        response_type_name='SnapshotSchedulePolicy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List snapshot schedule policies in a given project and location.

      Args:
        request: (BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSnapshotSchedulePoliciesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/snapshotSchedulePolicies',
        http_method='GET',
        method_id='baremetalsolution.projects.locations.snapshotSchedulePolicies.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v2/{+parent}/snapshotSchedulePolicies',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesListRequest',
        response_type_name='ListSnapshotSchedulePoliciesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update a snapshot schedule policy in the specified project.

      Args:
        request: (BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SnapshotSchedulePolicy) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/snapshotSchedulePolicies/{snapshotSchedulePoliciesId}',
        http_method='PATCH',
        method_id='baremetalsolution.projects.locations.snapshotSchedulePolicies.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v2/{+name}',
        request_field='snapshotSchedulePolicy',
        request_type_name='BaremetalsolutionProjectsLocationsSnapshotSchedulePoliciesPatchRequest',
        response_type_name='SnapshotSchedulePolicy',
        supports_download=False,
    )

  class ProjectsLocationsVolumesLunsService(base_api.BaseApiService):
    """Service class for the projects_locations_volumes_luns resource."""

    _NAME = 'projects_locations_volumes_luns'

    def __init__(self, client):
      super(BaremetalsolutionV2.ProjectsLocationsVolumesLunsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get details of a single storage logical unit number(LUN).

      Args:
        request: (BaremetalsolutionProjectsLocationsVolumesLunsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Lun) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/volumes/{volumesId}/luns/{lunsId}',
        http_method='GET',
        method_id='baremetalsolution.projects.locations.volumes.luns.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsVolumesLunsGetRequest',
        response_type_name='Lun',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List storage volume luns for given storage volume.

      Args:
        request: (BaremetalsolutionProjectsLocationsVolumesLunsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLunsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/volumes/{volumesId}/luns',
        http_method='GET',
        method_id='baremetalsolution.projects.locations.volumes.luns.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2/{+parent}/luns',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsVolumesLunsListRequest',
        response_type_name='ListLunsResponse',
        supports_download=False,
    )

  class ProjectsLocationsVolumesSnapshotsService(base_api.BaseApiService):
    """Service class for the projects_locations_volumes_snapshots resource."""

    _NAME = 'projects_locations_volumes_snapshots'

    def __init__(self, client):
      super(BaremetalsolutionV2.ProjectsLocationsVolumesSnapshotsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Create a storage volume snapshot in a containing volume.

      Args:
        request: (BaremetalsolutionProjectsLocationsVolumesSnapshotsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VolumeSnapshot) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/volumes/{volumesId}/snapshots',
        http_method='POST',
        method_id='baremetalsolution.projects.locations.volumes.snapshots.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2/{+parent}/snapshots',
        request_field='volumeSnapshot',
        request_type_name='BaremetalsolutionProjectsLocationsVolumesSnapshotsCreateRequest',
        response_type_name='VolumeSnapshot',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a storage volume snapshot for a given volume.

      Args:
        request: (BaremetalsolutionProjectsLocationsVolumesSnapshotsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/volumes/{volumesId}/snapshots/{snapshotsId}',
        http_method='DELETE',
        method_id='baremetalsolution.projects.locations.volumes.snapshots.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsVolumesSnapshotsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get details of a single storage volume snapshot.

      Args:
        request: (BaremetalsolutionProjectsLocationsVolumesSnapshotsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VolumeSnapshot) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/volumes/{volumesId}/snapshots/{snapshotsId}',
        http_method='GET',
        method_id='baremetalsolution.projects.locations.volumes.snapshots.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsVolumesSnapshotsGetRequest',
        response_type_name='VolumeSnapshot',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List storage volume snapshots for given storage volume.

      Args:
        request: (BaremetalsolutionProjectsLocationsVolumesSnapshotsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListVolumeSnapshotsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/volumes/{volumesId}/snapshots',
        http_method='GET',
        method_id='baremetalsolution.projects.locations.volumes.snapshots.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v2/{+parent}/snapshots',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsVolumesSnapshotsListRequest',
        response_type_name='ListVolumeSnapshotsResponse',
        supports_download=False,
    )

    def RestoreVolumeSnapshot(self, request, global_params=None):
      r"""Restore a storage volume snapshot to its containing volume.

      Args:
        request: (BaremetalsolutionProjectsLocationsVolumesSnapshotsRestoreVolumeSnapshotRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RestoreVolumeSnapshot')
      return self._RunMethod(
          config, request, global_params=global_params)

    RestoreVolumeSnapshot.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/volumes/{volumesId}/snapshots/{snapshotsId}:restoreVolumeSnapshot',
        http_method='POST',
        method_id='baremetalsolution.projects.locations.volumes.snapshots.restoreVolumeSnapshot',
        ordered_params=['volumeSnapshot'],
        path_params=['volumeSnapshot'],
        query_params=[],
        relative_path='v2/{+volumeSnapshot}:restoreVolumeSnapshot',
        request_field='restoreVolumeSnapshotRequest',
        request_type_name='BaremetalsolutionProjectsLocationsVolumesSnapshotsRestoreVolumeSnapshotRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsVolumesService(base_api.BaseApiService):
    """Service class for the projects_locations_volumes resource."""

    _NAME = 'projects_locations_volumes'

    def __init__(self, client):
      super(BaremetalsolutionV2.ProjectsLocationsVolumesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Get details of a single storage volume.

      Args:
        request: (BaremetalsolutionProjectsLocationsVolumesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Volume) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/volumes/{volumesId}',
        http_method='GET',
        method_id='baremetalsolution.projects.locations.volumes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsVolumesGetRequest',
        response_type_name='Volume',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List storage volumes in a given project and location.

      Args:
        request: (BaremetalsolutionProjectsLocationsVolumesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListVolumesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/volumes',
        http_method='GET',
        method_id='baremetalsolution.projects.locations.volumes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v2/{+parent}/volumes',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsVolumesListRequest',
        response_type_name='ListVolumesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update details of a single storage volume.

      Args:
        request: (BaremetalsolutionProjectsLocationsVolumesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}/volumes/{volumesId}',
        http_method='PATCH',
        method_id='baremetalsolution.projects.locations.volumes.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v2/{+name}',
        request_field='volume',
        request_type_name='BaremetalsolutionProjectsLocationsVolumesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(BaremetalsolutionV2.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (BaremetalsolutionProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='baremetalsolution.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2/{+name}',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (BaremetalsolutionProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2/projects/{projectsId}/locations',
        http_method='GET',
        method_id='baremetalsolution.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v2/{+name}/locations',
        request_field='',
        request_type_name='BaremetalsolutionProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(BaremetalsolutionV2.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
