"""Generated message classes for metastore version v1.

The Dataproc Metastore API is used to manage the lifecycle and configuration
of metastore services.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'metastore'


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.If there are AuditConfigs for both allServices and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts jose@example.com from DATA_READ logging, and
  aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, storage.googleapis.com, cloudsql.googleapis.com. allServices is
      a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Backup(_messages.Message):
  r"""The details of a backup resource.

  Enums:
    StateValueValuesEnum: Output only. The current state of the backup.

  Fields:
    createTime: Output only. The time when the backup was started.
    description: The description of the backup.
    endTime: Output only. The time when the backup finished creating.
    name: Immutable. The relative resource name of the backup, in the
      following form:projects/{project_number}/locations/{location_id}/service
      s/{service_id}/backups/{backup_id}
    restoringServices: Output only. Services that are restoring from the
      backup.
    serviceRevision: Output only. The revision of the service at the time of
      backup.
    state: Output only. The current state of the backup.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the backup.

    Values:
      STATE_UNSPECIFIED: The state of the backup is unknown.
      CREATING: The backup is being created.
      DELETING: The backup is being deleted.
      ACTIVE: The backup is active and ready to use.
      FAILED: The backup failed.
      RESTORING: The backup is being restored.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    DELETING = 2
    ACTIVE = 3
    FAILED = 4
    RESTORING = 5

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  endTime = _messages.StringField(3)
  name = _messages.StringField(4)
  restoringServices = _messages.StringField(5, repeated=True)
  serviceRevision = _messages.MessageField('Service', 6)
  state = _messages.EnumField('StateValueValuesEnum', 7)


class Binding(_messages.Message):
  r"""Associates members, or principals, with a role.

  Fields:
    condition: The condition that is associated with this binding.If the
      condition evaluates to true, then this binding applies to the current
      request.If the condition evaluates to false, then this binding does not
      apply to the current request. However, a different role binding might
      grant the same role to one or more of the principals in this binding.To
      learn which resources support conditions in their IAM policies, see the
      IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    members: Specifies the principals requesting access for a Cloud Platform
      resource. members can have the following values: allUsers: A special
      identifier that represents anyone who is on the internet; with or
      without a Google account. allAuthenticatedUsers: A special identifier
      that represents anyone who is authenticated with a Google account or a
      service account. user:{emailid}: An email address that represents a
      specific Google account. For example, alice@example.com .
      serviceAccount:{emailid}: An email address that represents a service
      account. For example, my-other-app@appspot.gserviceaccount.com.
      group:{emailid}: An email address that represents a Google group. For
      example, admins@example.com. deleted:user:{emailid}?uid={uniqueid}: An
      email address (plus unique identifier) representing a user that has been
      recently deleted. For example,
      alice@example.com?uid=123456789012345678901. If the user is recovered,
      this value reverts to user:{emailid} and the recovered user retains the
      role in the binding. deleted:serviceAccount:{emailid}?uid={uniqueid}: An
      email address (plus unique identifier) representing a service account
      that has been recently deleted. For example, my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901. If the
      service account is undeleted, this value reverts to
      serviceAccount:{emailid} and the undeleted service account retains the
      role in the binding. deleted:group:{emailid}?uid={uniqueid}: An email
      address (plus unique identifier) representing a Google group that has
      been recently deleted. For example,
      admins@example.com?uid=123456789012345678901. If the group is recovered,
      this value reverts to group:{emailid} and the recovered group retains
      the role in the binding. domain:{domain}: The G Suite domain (primary)
      that represents all the users of that domain. For example, google.com or
      example.com.
    role: Role that is assigned to the list of members, or principals. For
      example, roles/viewer, roles/editor, or roles/owner.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class DatabaseDump(_messages.Message):
  r"""A specification of the location of and metadata about a database dump
  from a relational database management system.

  Enums:
    DatabaseTypeValueValuesEnum: The type of the database.
    TypeValueValuesEnum: Optional. The type of the database dump. If
      unspecified, defaults to MYSQL.

  Fields:
    databaseType: The type of the database.
    gcsUri: A Cloud Storage object or folder URI that specifies the source
      from which to import metadata. It must begin with gs://.
    sourceDatabase: The name of the source database.
    type: Optional. The type of the database dump. If unspecified, defaults to
      MYSQL.
  """

  class DatabaseTypeValueValuesEnum(_messages.Enum):
    r"""The type of the database.

    Values:
      DATABASE_TYPE_UNSPECIFIED: The type of the source database is unknown.
      MYSQL: The type of the source database is MySQL.
    """
    DATABASE_TYPE_UNSPECIFIED = 0
    MYSQL = 1

  class TypeValueValuesEnum(_messages.Enum):
    r"""Optional. The type of the database dump. If unspecified, defaults to
    MYSQL.

    Values:
      TYPE_UNSPECIFIED: The type of the database dump is unknown.
      MYSQL: Database dump is a MySQL dump file.
      AVRO: Database dump contains Avro files.
    """
    TYPE_UNSPECIFIED = 0
    MYSQL = 1
    AVRO = 2

  databaseType = _messages.EnumField('DatabaseTypeValueValuesEnum', 1)
  gcsUri = _messages.StringField(2)
  sourceDatabase = _messages.StringField(3)
  type = _messages.EnumField('TypeValueValuesEnum', 4)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for Empty is empty JSON object {}.
  """



class EncryptionConfig(_messages.Message):
  r"""Encryption settings for the service.

  Fields:
    kmsKey: The fully qualified customer provided Cloud KMS key name to use
      for customer data encryption, in the following form:projects/{project_nu
      mber}/locations/{location_id}/keyRings/{key_ring_id}/cryptoKeys/{crypto_
      key_id}.
  """

  kmsKey = _messages.StringField(1)


class ExportMetadataRequest(_messages.Message):
  r"""Request message for DataprocMetastore.ExportMetadata.

  Enums:
    DatabaseDumpTypeValueValuesEnum: Optional. The type of the database dump.
      If unspecified, defaults to MYSQL.

  Fields:
    databaseDumpType: Optional. The type of the database dump. If unspecified,
      defaults to MYSQL.
    destinationGcsFolder: A Cloud Storage URI of a folder, in the format
      gs:///. A sub-folder containing exported files will be created below it.
    requestId: Optional. A request ID. Specify a unique request ID to allow
      the server to ignore the request if it has completed. The server will
      ignore subsequent requests that provide a duplicate request ID for at
      least 60 minutes after the first request.For example, if an initial
      request times out, followed by another request with the same request ID,
      the server ignores the second request to prevent the creation of
      duplicate commitments.The request ID must be a valid UUID
      (https://en.wikipedia.org/wiki/Universally_unique_identifier#Format). A
      zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
  """

  class DatabaseDumpTypeValueValuesEnum(_messages.Enum):
    r"""Optional. The type of the database dump. If unspecified, defaults to
    MYSQL.

    Values:
      TYPE_UNSPECIFIED: The type of the database dump is unknown.
      MYSQL: Database dump is a MySQL dump file.
      AVRO: Database dump contains Avro files.
    """
    TYPE_UNSPECIFIED = 0
    MYSQL = 1
    AVRO = 2

  databaseDumpType = _messages.EnumField('DatabaseDumpTypeValueValuesEnum', 1)
  destinationGcsFolder = _messages.StringField(2)
  requestId = _messages.StringField(3)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec.Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class HiveMetastoreConfig(_messages.Message):
  r"""Specifies configuration information specific to running Hive metastore
  software as the metastore service.

  Messages:
    ConfigOverridesValue: A mapping of Hive metastore configuration key-value
      pairs to apply to the Hive metastore (configured in hive-site.xml). The
      mappings override system defaults (some keys cannot be overridden).
      These overrides are also applied to auxiliary versions and can be
      further customized in the auxiliary version's AuxiliaryVersionConfig.

  Fields:
    configOverrides: A mapping of Hive metastore configuration key-value pairs
      to apply to the Hive metastore (configured in hive-site.xml). The
      mappings override system defaults (some keys cannot be overridden).
      These overrides are also applied to auxiliary versions and can be
      further customized in the auxiliary version's AuxiliaryVersionConfig.
    kerberosConfig: Information used to configure the Hive metastore service
      as a service principal in a Kerberos realm. To disable Kerberos, use the
      UpdateService method and specify this field's path
      (hive_metastore_config.kerberos_config) in the request's update_mask
      while omitting this field from the request's service.
    version: Immutable. The Hive metastore schema version.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConfigOverridesValue(_messages.Message):
    r"""A mapping of Hive metastore configuration key-value pairs to apply to
    the Hive metastore (configured in hive-site.xml). The mappings override
    system defaults (some keys cannot be overridden). These overrides are also
    applied to auxiliary versions and can be further customized in the
    auxiliary version's AuxiliaryVersionConfig.

    Messages:
      AdditionalProperty: An additional property for a ConfigOverridesValue
        object.

    Fields:
      additionalProperties: Additional properties of type ConfigOverridesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ConfigOverridesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  configOverrides = _messages.MessageField('ConfigOverridesValue', 1)
  kerberosConfig = _messages.MessageField('KerberosConfig', 2)
  version = _messages.StringField(3)


class HiveMetastoreVersion(_messages.Message):
  r"""A specification of a supported version of the Hive Metastore software.

  Fields:
    isDefault: Whether version will be chosen by the server if a metastore
      service is created with a HiveMetastoreConfig that omits the version.
    version: The semantic version of the Hive Metastore software.
  """

  isDefault = _messages.BooleanField(1)
  version = _messages.StringField(2)


class KerberosConfig(_messages.Message):
  r"""Configuration information for a Kerberos principal.

  Fields:
    keytab: A Kerberos keytab file that can be used to authenticate a service
      principal with a Kerberos Key Distribution Center (KDC).
    krb5ConfigGcsUri: A Cloud Storage URI that specifies the path to a
      krb5.conf file. It is of the form gs://{bucket_name}/path/to/krb5.conf,
      although the file does not need to be named krb5.conf explicitly.
    principal: A Kerberos principal that exists in the both the keytab the KDC
      to authenticate as. A typical principal is of the form
      primary/instance@REALM, but there is no exact format.
  """

  keytab = _messages.MessageField('Secret', 1)
  krb5ConfigGcsUri = _messages.StringField(2)
  principal = _messages.StringField(3)


class ListBackupsResponse(_messages.Message):
  r"""Response message for DataprocMetastore.ListBackups.

  Fields:
    backups: The backups of the specified service.
    nextPageToken: A token that can be sent as page_token to retrieve the next
      page. If this field is omitted, there are no subsequent pages.
    unreachable: Locations that could not be reached.
  """

  backups = _messages.MessageField('Backup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMetadataImportsResponse(_messages.Message):
  r"""Response message for DataprocMetastore.ListMetadataImports.

  Fields:
    metadataImports: The imports in the specified service.
    nextPageToken: A token that can be sent as page_token to retrieve the next
      page. If this field is omitted, there are no subsequent pages.
    unreachable: Locations that could not be reached.
  """

  metadataImports = _messages.MessageField('MetadataImport', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListServicesResponse(_messages.Message):
  r"""Response message for DataprocMetastore.ListServices.

  Fields:
    nextPageToken: A token that can be sent as page_token to retrieve the next
      page. If this field is omitted, there are no subsequent pages.
    services: The services in the specified location.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  services = _messages.MessageField('Service', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: "us-east1".
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: "projects/example-project/locations/us-
      east1"
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LocationMetadata(_messages.Message):
  r"""Metadata about the service in a location.

  Fields:
    supportedHiveMetastoreVersions: The versions of Hive Metastore that can be
      used when creating a new metastore service in this location. The server
      guarantees that exactly one HiveMetastoreVersion in the list will set
      is_default.
  """

  supportedHiveMetastoreVersions = _messages.MessageField('HiveMetastoreVersion', 1, repeated=True)


class MaintenanceWindow(_messages.Message):
  r"""Maintenance window. This specifies when Dataproc Metastore may perform
  system maintenance operation to the service.

  Enums:
    DayOfWeekValueValuesEnum: The day of week, when the window starts.

  Fields:
    dayOfWeek: The day of week, when the window starts.
    hourOfDay: The hour of day (0-23) when the window starts.
  """

  class DayOfWeekValueValuesEnum(_messages.Enum):
    r"""The day of week, when the window starts.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  dayOfWeek = _messages.EnumField('DayOfWeekValueValuesEnum', 1)
  hourOfDay = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class MetadataExport(_messages.Message):
  r"""The details of a metadata export operation.

  Enums:
    DatabaseDumpTypeValueValuesEnum: Output only. The type of the database
      dump.
    StateValueValuesEnum: Output only. The current state of the export.

  Fields:
    databaseDumpType: Output only. The type of the database dump.
    destinationGcsUri: Output only. A Cloud Storage URI of a folder that
      metadata are exported to, in the form of gs:////, where is automatically
      generated.
    endTime: Output only. The time when the export ended.
    startTime: Output only. The time when the export started.
    state: Output only. The current state of the export.
  """

  class DatabaseDumpTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of the database dump.

    Values:
      TYPE_UNSPECIFIED: The type of the database dump is unknown.
      MYSQL: Database dump is a MySQL dump file.
      AVRO: Database dump contains Avro files.
    """
    TYPE_UNSPECIFIED = 0
    MYSQL = 1
    AVRO = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the export.

    Values:
      STATE_UNSPECIFIED: The state of the metadata export is unknown.
      RUNNING: The metadata export is running.
      SUCCEEDED: The metadata export completed successfully.
      FAILED: The metadata export failed.
      CANCELLED: The metadata export is cancelled.
    """
    STATE_UNSPECIFIED = 0
    RUNNING = 1
    SUCCEEDED = 2
    FAILED = 3
    CANCELLED = 4

  databaseDumpType = _messages.EnumField('DatabaseDumpTypeValueValuesEnum', 1)
  destinationGcsUri = _messages.StringField(2)
  endTime = _messages.StringField(3)
  startTime = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class MetadataImport(_messages.Message):
  r"""A metastore resource that imports metadata.

  Enums:
    StateValueValuesEnum: Output only. The current state of the metadata
      import.

  Fields:
    createTime: Output only. The time when the metadata import was started.
    databaseDump: Immutable. A database dump from a pre-existing metastore's
      database.
    description: The description of the metadata import.
    endTime: Output only. The time when the metadata import finished.
    name: Immutable. The relative resource name of the metadata import, of the
      form:projects/{project_number}/locations/{location_id}/services/{service
      _id}/metadataImports/{metadata_import_id}.
    state: Output only. The current state of the metadata import.
    updateTime: Output only. The time when the metadata import was last
      updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the metadata import.

    Values:
      STATE_UNSPECIFIED: The state of the metadata import is unknown.
      RUNNING: The metadata import is running.
      SUCCEEDED: The metadata import completed successfully.
      UPDATING: The metadata import is being updated.
      FAILED: The metadata import failed, and attempted metadata changes were
        rolled back.
    """
    STATE_UNSPECIFIED = 0
    RUNNING = 1
    SUCCEEDED = 2
    UPDATING = 3
    FAILED = 4

  createTime = _messages.StringField(1)
  databaseDump = _messages.MessageField('DatabaseDump', 2)
  description = _messages.StringField(3)
  endTime = _messages.StringField(4)
  name = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  updateTime = _messages.StringField(7)


class MetadataManagementActivity(_messages.Message):
  r"""The metadata management activities of the metastore service.

  Fields:
    metadataExports: Output only. The latest metadata exports of the metastore
      service.
    restores: Output only. The latest restores of the metastore service.
  """

  metadataExports = _messages.MessageField('MetadataExport', 1, repeated=True)
  restores = _messages.MessageField('Restore', 2, repeated=True)


class MetastoreOperationsCancelRequest(_messages.Message):
  r"""A MetastoreOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class MetastoreProjectsLocationsGetRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class MetastoreProjectsLocationsListRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like "displayName=tokyo", and is
      documented in more detail in AIP-160 (https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the next_page_token field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class MetastoreProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class MetastoreProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class MetastoreProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class MetastoreProjectsLocationsServicesBackupsCreateRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesBackupsCreateRequest object.

  Fields:
    backup: A Backup resource to be passed as the request body.
    backupId: Required. The ID of the backup, which is used as the final
      component of the backup's name.This value must be between 1 and 64
      characters long, begin with a letter, end with a letter or number, and
      consist of alpha-numeric ASCII characters or hyphens.
    parent: Required. The relative resource name of the service in which to
      create a backup of the following form:projects/{project_number}/location
      s/{location_id}/services/{service_id}.
    requestId: Optional. A request ID. Specify a unique request ID to allow
      the server to ignore the request if it has completed. The server will
      ignore subsequent requests that provide a duplicate request ID for at
      least 60 minutes after the first request.For example, if an initial
      request times out, followed by another request with the same request ID,
      the server ignores the second request to prevent the creation of
      duplicate commitments.The request ID must be a valid UUID
      (https://en.wikipedia.org/wiki/Universally_unique_identifier#Format) A
      zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
  """

  backup = _messages.MessageField('Backup', 1)
  backupId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class MetastoreProjectsLocationsServicesBackupsDeleteRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesBackupsDeleteRequest object.

  Fields:
    name: Required. The relative resource name of the backup to delete, in the
      following form:projects/{project_number}/locations/{location_id}/service
      s/{service_id}/backups/{backup_id}.
    requestId: Optional. A request ID. Specify a unique request ID to allow
      the server to ignore the request if it has completed. The server will
      ignore subsequent requests that provide a duplicate request ID for at
      least 60 minutes after the first request.For example, if an initial
      request times out, followed by another request with the same request ID,
      the server ignores the second request to prevent the creation of
      duplicate commitments.The request ID must be a valid UUID
      (https://en.wikipedia.org/wiki/Universally_unique_identifier#Format) A
      zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class MetastoreProjectsLocationsServicesBackupsGetIamPolicyRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesBackupsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class MetastoreProjectsLocationsServicesBackupsGetRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesBackupsGetRequest object.

  Fields:
    name: Required. The relative resource name of the backup to retrieve, in
      the following form:projects/{project_number}/locations/{location_id}/ser
      vices/{service_id}/backups/{backup_id}.
  """

  name = _messages.StringField(1, required=True)


class MetastoreProjectsLocationsServicesBackupsListRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesBackupsListRequest object.

  Fields:
    filter: Optional. The filter to apply to list results.
    orderBy: Optional. Specify the ordering of results as described in Sorting
      Order
      (https://cloud.google.com/apis/design/design_patterns#sorting_order). If
      not specified, the results will be sorted in the default order.
    pageSize: Optional. The maximum number of backups to return. The response
      may contain less than the maximum number. If unspecified, no more than
      500 backups are returned. The maximum value is 1000; values above 1000
      are changed to 1000.
    pageToken: Optional. A page token, received from a previous
      DataprocMetastore.ListBackups call. Provide this token to retrieve the
      subsequent page.To retrieve the first page, supply an empty page
      token.When paginating, other parameters provided to
      DataprocMetastore.ListBackups must match the call that provided the page
      token.
    parent: Required. The relative resource name of the service whose backups
      to list, in the following form:projects/{project_number}/locations/{loca
      tion_id}/services/{service_id}/backups.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class MetastoreProjectsLocationsServicesBackupsSetIamPolicyRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesBackupsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class MetastoreProjectsLocationsServicesCreateRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesCreateRequest object.

  Fields:
    parent: Required. The relative resource name of the location in which to
      create a metastore service, in the following
      form:projects/{project_number}/locations/{location_id}.
    requestId: Optional. A request ID. Specify a unique request ID to allow
      the server to ignore the request if it has completed. The server will
      ignore subsequent requests that provide a duplicate request ID for at
      least 60 minutes after the first request.For example, if an initial
      request times out, followed by another request with the same request ID,
      the server ignores the second request to prevent the creation of
      duplicate commitments.The request ID must be a valid UUID
      (https://en.wikipedia.org/wiki/Universally_unique_identifier#Format) A
      zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
    service: A Service resource to be passed as the request body.
    serviceId: Required. The ID of the metastore service, which is used as the
      final component of the metastore service's name.This value must be
      between 2 and 63 characters long inclusive, begin with a letter, end
      with a letter or number, and consist of alpha-numeric ASCII characters
      or hyphens.
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  service = _messages.MessageField('Service', 3)
  serviceId = _messages.StringField(4)


class MetastoreProjectsLocationsServicesDeleteRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesDeleteRequest object.

  Fields:
    name: Required. The relative resource name of the metastore service to
      delete, in the following form:projects/{project_number}/locations/{locat
      ion_id}/services/{service_id}.
    requestId: Optional. A request ID. Specify a unique request ID to allow
      the server to ignore the request if it has completed. The server will
      ignore subsequent requests that provide a duplicate request ID for at
      least 60 minutes after the first request.For example, if an initial
      request times out, followed by another request with the same request ID,
      the server ignores the second request to prevent the creation of
      duplicate commitments.The request ID must be a valid UUID
      (https://en.wikipedia.org/wiki/Universally_unique_identifier#Format) A
      zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class MetastoreProjectsLocationsServicesExportMetadataRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesExportMetadataRequest object.

  Fields:
    exportMetadataRequest: A ExportMetadataRequest resource to be passed as
      the request body.
    service: Required. The relative resource name of the metastore service to
      run export, in the following form:projects/{project_id}/locations/{locat
      ion_id}/services/{service_id}.
  """

  exportMetadataRequest = _messages.MessageField('ExportMetadataRequest', 1)
  service = _messages.StringField(2, required=True)


class MetastoreProjectsLocationsServicesGetIamPolicyRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy.Valid values are 0, 1, and 3. Requests
      specifying an invalid value will be rejected.Requests for policies with
      any conditional role bindings must specify version 3. Policies with no
      conditional role bindings may specify any valid value or leave the field
      unset.The policy in the response might use the policy version that you
      specified, or it might use a lower policy version. For example, if you
      specify version 3, but the policy has no conditional role bindings, the
      response uses version 1.To learn which resources support conditions in
      their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class MetastoreProjectsLocationsServicesGetRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesGetRequest object.

  Fields:
    name: Required. The relative resource name of the metastore service to
      retrieve, in the following form:projects/{project_number}/locations/{loc
      ation_id}/services/{service_id}.
  """

  name = _messages.StringField(1, required=True)


class MetastoreProjectsLocationsServicesListRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesListRequest object.

  Fields:
    filter: Optional. The filter to apply to list results.
    orderBy: Optional. Specify the ordering of results as described in Sorting
      Order
      (https://cloud.google.com/apis/design/design_patterns#sorting_order). If
      not specified, the results will be sorted in the default order.
    pageSize: Optional. The maximum number of services to return. The response
      may contain less than the maximum number. If unspecified, no more than
      500 services are returned. The maximum value is 1000; values above 1000
      are changed to 1000.
    pageToken: Optional. A page token, received from a previous
      DataprocMetastore.ListServices call. Provide this token to retrieve the
      subsequent page.To retrieve the first page, supply an empty page
      token.When paginating, other parameters provided to
      DataprocMetastore.ListServices must match the call that provided the
      page token.
    parent: Required. The relative resource name of the location of metastore
      services to list, in the following
      form:projects/{project_number}/locations/{location_id}.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class MetastoreProjectsLocationsServicesMetadataImportsCreateRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesMetadataImportsCreateRequest object.

  Fields:
    metadataImport: A MetadataImport resource to be passed as the request
      body.
    metadataImportId: Required. The ID of the metadata import, which is used
      as the final component of the metadata import's name.This value must be
      between 1 and 64 characters long, begin with a letter, end with a letter
      or number, and consist of alpha-numeric ASCII characters or hyphens.
    parent: Required. The relative resource name of the service in which to
      create a metastore import, in the following form:projects/{project_numbe
      r}/locations/{location_id}/services/{service_id}.
    requestId: Optional. A request ID. Specify a unique request ID to allow
      the server to ignore the request if it has completed. The server will
      ignore subsequent requests that provide a duplicate request ID for at
      least 60 minutes after the first request.For example, if an initial
      request times out, followed by another request with the same request ID,
      the server ignores the second request to prevent the creation of
      duplicate commitments.The request ID must be a valid UUID
      (https://en.wikipedia.org/wiki/Universally_unique_identifier#Format) A
      zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
  """

  metadataImport = _messages.MessageField('MetadataImport', 1)
  metadataImportId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class MetastoreProjectsLocationsServicesMetadataImportsGetRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesMetadataImportsGetRequest object.

  Fields:
    name: Required. The relative resource name of the metadata import to
      retrieve, in the following form:projects/{project_number}/locations/{loc
      ation_id}/services/{service_id}/metadataImports/{import_id}.
  """

  name = _messages.StringField(1, required=True)


class MetastoreProjectsLocationsServicesMetadataImportsListRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesMetadataImportsListRequest object.

  Fields:
    filter: Optional. The filter to apply to list results.
    orderBy: Optional. Specify the ordering of results as described in Sorting
      Order
      (https://cloud.google.com/apis/design/design_patterns#sorting_order). If
      not specified, the results will be sorted in the default order.
    pageSize: Optional. The maximum number of imports to return. The response
      may contain less than the maximum number. If unspecified, no more than
      500 imports are returned. The maximum value is 1000; values above 1000
      are changed to 1000.
    pageToken: Optional. A page token, received from a previous
      DataprocMetastore.ListServices call. Provide this token to retrieve the
      subsequent page.To retrieve the first page, supply an empty page
      token.When paginating, other parameters provided to
      DataprocMetastore.ListServices must match the call that provided the
      page token.
    parent: Required. The relative resource name of the service whose metadata
      imports to list, in the following form:projects/{project_number}/locatio
      ns/{location_id}/services/{service_id}/metadataImports.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class MetastoreProjectsLocationsServicesMetadataImportsPatchRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesMetadataImportsPatchRequest object.

  Fields:
    metadataImport: A MetadataImport resource to be passed as the request
      body.
    name: Immutable. The relative resource name of the metadata import, of the
      form:projects/{project_number}/locations/{location_id}/services/{service
      _id}/metadataImports/{metadata_import_id}.
    requestId: Optional. A request ID. Specify a unique request ID to allow
      the server to ignore the request if it has completed. The server will
      ignore subsequent requests that provide a duplicate request ID for at
      least 60 minutes after the first request.For example, if an initial
      request times out, followed by another request with the same request ID,
      the server ignores the second request to prevent the creation of
      duplicate commitments.The request ID must be a valid UUID
      (https://en.wikipedia.org/wiki/Universally_unique_identifier#Format) A
      zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
    updateMask: Required. A field mask used to specify the fields to be
      overwritten in the metadata import resource by the update. Fields
      specified in the update_mask are relative to the resource (not to the
      full request). A field is overwritten if it is in the mask.
  """

  metadataImport = _messages.MessageField('MetadataImport', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class MetastoreProjectsLocationsServicesPatchRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesPatchRequest object.

  Fields:
    name: Immutable. The relative resource name of the metastore service, of
      the form:projects/{project_number}/locations/{location_id}/services/{ser
      vice_id}.
    requestId: Optional. A request ID. Specify a unique request ID to allow
      the server to ignore the request if it has completed. The server will
      ignore subsequent requests that provide a duplicate request ID for at
      least 60 minutes after the first request.For example, if an initial
      request times out, followed by another request with the same request ID,
      the server ignores the second request to prevent the creation of
      duplicate commitments.The request ID must be a valid UUID
      (https://en.wikipedia.org/wiki/Universally_unique_identifier#Format) A
      zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
    service: A Service resource to be passed as the request body.
    updateMask: Required. A field mask used to specify the fields to be
      overwritten in the metastore service resource by the update. Fields
      specified in the update_mask are relative to the resource (not to the
      full request). A field is overwritten if it is in the mask.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  service = _messages.MessageField('Service', 3)
  updateMask = _messages.StringField(4)


class MetastoreProjectsLocationsServicesRestoreRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesRestoreRequest object.

  Fields:
    restoreServiceRequest: A RestoreServiceRequest resource to be passed as
      the request body.
    service: Required. The relative resource name of the metastore service to
      run restore, in the following form:projects/{project_id}/locations/{loca
      tion_id}/services/{service_id}.
  """

  restoreServiceRequest = _messages.MessageField('RestoreServiceRequest', 1)
  service = _messages.StringField(2, required=True)


class MetastoreProjectsLocationsServicesSetIamPolicyRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class MetastoreProjectsLocationsServicesTestIamPermissionsRequest(_messages.Message):
  r"""A MetastoreProjectsLocationsServicesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as Delete, the
      response is google.protobuf.Empty. If the original method is standard
      Get/Create/Update, the response should be the resource. For other
      methods, the response should have the type XxxResponse, where Xxx is the
      original method name. For example, if the original method name is
      TakeSnapshot(), the inferred response type is TakeSnapshotResponse.

  Fields:
    done: If the value is false, it means the operation is still in progress.
      If true, the operation is completed, and either error or response is
      available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the name should be a resource name ending with operations/{unique_id}.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as Delete, the response
      is google.protobuf.Empty. If the original method is standard
      Get/Create/Update, the response should be the resource. For other
      methods, the response should have the type XxxResponse, where Xxx is the
      original method name. For example, if the original method name is
      TakeSnapshot(), the inferred response type is TakeSnapshotResponse.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as Delete, the response
    is google.protobuf.Empty. If the original method is standard
    Get/Create/Update, the response should be the resource. For other methods,
    the response should have the type XxxResponse, where Xxx is the original
    method name. For example, if the original method name is TakeSnapshot(),
    the inferred response type is TakeSnapshotResponse.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of a long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the caller has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to Code.CANCELLED.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources.A Policy is a collection of bindings. A
  binding binds one or more members, or principals, to a single role.
  Principals can be user accounts, service accounts, Google groups, and
  domains (such as G Suite). A role is a named list of permissions; each role
  can be an IAM predefined role or a user-created custom role.For some types
  of Google Cloud resources, a binding can also specify a condition, which is
  a logical expression that allows access to a resource only if the expression
  evaluates to true. A condition can add constraints based on attributes of
  the request, the resource, or both. To learn which resources support
  conditions in their IAM policies, see the IAM documentation
  (https://cloud.google.com/iam/help/conditions/resource-policies).JSON
  example: { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } YAML example: bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
  version: 3 For a description of IAM and its features, see the IAM
  documentation (https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of members, or principals, with a role.
      Optionally, may specify a condition that determines how and when the
      bindings are applied. Each of the bindings must contain at least one
      principal.The bindings in a Policy can refer to up to 1,500 principals;
      up to 250 of these principals can be Google groups. Each occurrence of a
      principal counts towards these limits. For example, if the bindings
      grant 50 different roles to user:alice@example.com, and not to any other
      principal, then you can add another 1,450 principals to the bindings in
      the Policy.
    etag: etag is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the etag in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An etag is returned in the response to getIamPolicy, and
      systems are expected to put that etag in the request to setIamPolicy to
      ensure that their change will be applied to the same version of the
      policy.Important: If you use IAM Conditions, you must include the etag
      field whenever you call setIamPolicy. If you omit this field, then IAM
      allows you to overwrite a version 3 policy with a version 1 policy, and
      all of the conditions in the version 3 policy are lost.
    version: Specifies the format of the policy.Valid values are 0, 1, and 3.
      Requests that specify an invalid value are rejected.Any operation that
      affects conditional role bindings must specify version 3. This
      requirement applies to the following operations: Getting a policy that
      includes a conditional role binding Adding a conditional role binding to
      a policy Changing a conditional role binding in a policy Removing any
      role binding, with or without a condition, from a policy that includes
      conditionsImportant: If you use IAM Conditions, you must include the
      etag field whenever you call setIamPolicy. If you omit this field, then
      IAM allows you to overwrite a version 3 policy with a version 1 policy,
      and all of the conditions in the version 3 policy are lost.If a policy
      does not include any conditions, operations on that policy may specify
      any valid version or leave the field unset.To learn which resources
      support conditions in their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Restore(_messages.Message):
  r"""The details of a metadata restore operation.

  Enums:
    StateValueValuesEnum: Output only. The current state of the restore.
    TypeValueValuesEnum: Output only. The type of restore.

  Fields:
    backup: Output only. The relative resource name of the metastore service
      backup to restore from, in the following form:projects/{project_id}/loca
      tions/{location_id}/services/{service_id}/backups/{backup_id}.
    details: Output only. The restore details containing the revision of the
      service to be restored to, in format of JSON.
    endTime: Output only. The time when the restore ended.
    startTime: Output only. The time when the restore started.
    state: Output only. The current state of the restore.
    type: Output only. The type of restore.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the restore.

    Values:
      STATE_UNSPECIFIED: The state of the metadata restore is unknown.
      RUNNING: The metadata restore is running.
      SUCCEEDED: The metadata restore completed successfully.
      FAILED: The metadata restore failed.
      CANCELLED: The metadata restore is cancelled.
    """
    STATE_UNSPECIFIED = 0
    RUNNING = 1
    SUCCEEDED = 2
    FAILED = 3
    CANCELLED = 4

  class TypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of restore.

    Values:
      RESTORE_TYPE_UNSPECIFIED: The restore type is unknown.
      FULL: The service's metadata and configuration are restored.
      METADATA_ONLY: Only the service's metadata is restored.
    """
    RESTORE_TYPE_UNSPECIFIED = 0
    FULL = 1
    METADATA_ONLY = 2

  backup = _messages.StringField(1)
  details = _messages.StringField(2)
  endTime = _messages.StringField(3)
  startTime = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  type = _messages.EnumField('TypeValueValuesEnum', 6)


class RestoreServiceRequest(_messages.Message):
  r"""Request message for DataprocMetastore.Restore.

  Enums:
    RestoreTypeValueValuesEnum: Optional. The type of restore. If unspecified,
      defaults to METADATA_ONLY.

  Fields:
    backup: Required. The relative resource name of the metastore service
      backup to restore from, in the following form:projects/{project_id}/loca
      tions/{location_id}/services/{service_id}/backups/{backup_id}.
    requestId: Optional. A request ID. Specify a unique request ID to allow
      the server to ignore the request if it has completed. The server will
      ignore subsequent requests that provide a duplicate request ID for at
      least 60 minutes after the first request.For example, if an initial
      request times out, followed by another request with the same request ID,
      the server ignores the second request to prevent the creation of
      duplicate commitments.The request ID must be a valid UUID
      (https://en.wikipedia.org/wiki/Universally_unique_identifier#Format). A
      zero UUID (00000000-0000-0000-0000-000000000000) is not supported.
    restoreType: Optional. The type of restore. If unspecified, defaults to
      METADATA_ONLY.
  """

  class RestoreTypeValueValuesEnum(_messages.Enum):
    r"""Optional. The type of restore. If unspecified, defaults to
    METADATA_ONLY.

    Values:
      RESTORE_TYPE_UNSPECIFIED: The restore type is unknown.
      FULL: The service's metadata and configuration are restored.
      METADATA_ONLY: Only the service's metadata is restored.
    """
    RESTORE_TYPE_UNSPECIFIED = 0
    FULL = 1
    METADATA_ONLY = 2

  backup = _messages.StringField(1)
  requestId = _messages.StringField(2)
  restoreType = _messages.EnumField('RestoreTypeValueValuesEnum', 3)


class Secret(_messages.Message):
  r"""A securely stored value.

  Fields:
    cloudSecret: The relative resource name of a Secret Manager secret
      version, in the following form:projects/{project_number}/secrets/{secret
      _id}/versions/{version_id}.
  """

  cloudSecret = _messages.StringField(1)


class Service(_messages.Message):
  r"""A managed metastore service that serves metadata queries.

  Enums:
    DatabaseTypeValueValuesEnum: Immutable. The database type that the
      Metastore service stores its data.
    ReleaseChannelValueValuesEnum: Immutable. The release channel of the
      service. If unspecified, defaults to STABLE.
    StateValueValuesEnum: Output only. The current state of the metastore
      service.
    TierValueValuesEnum: The tier of the service.

  Messages:
    LabelsValue: User-defined labels for the metastore service.

  Fields:
    artifactGcsUri: Output only. A Cloud Storage URI (starting with gs://)
      that specifies where artifacts related to the metastore service are
      stored.
    createTime: Output only. The time when the metastore service was created.
    databaseType: Immutable. The database type that the Metastore service
      stores its data.
    encryptionConfig: Immutable. Information used to configure the Dataproc
      Metastore service to encrypt customer data at rest. Cannot be updated.
    endpointUri: Output only. The URI of the endpoint used to access the
      metastore service.
    hiveMetastoreConfig: Configuration information specific to running Hive
      metastore software as the metastore service.
    labels: User-defined labels for the metastore service.
    maintenanceWindow: The one hour maintenance window of the metastore
      service. This specifies when the service can be restarted for
      maintenance purposes in UTC time. Maintenance window is not needed for
      services with the SPANNER database type.
    metadataManagementActivity: Output only. The metadata management
      activities of the metastore service.
    name: Immutable. The relative resource name of the metastore service, of
      the form:projects/{project_number}/locations/{location_id}/services/{ser
      vice_id}.
    network: Immutable. The relative resource name of the VPC network on which
      the instance can be accessed. It is specified in the following
      form:projects/{project_number}/global/networks/{network_id}.
    port: The TCP port at which the metastore service is reached. Default:
      9083.
    releaseChannel: Immutable. The release channel of the service. If
      unspecified, defaults to STABLE.
    state: Output only. The current state of the metastore service.
    stateMessage: Output only. Additional information about the current state
      of the metastore service, if available.
    tier: The tier of the service.
    uid: Output only. The globally unique resource identifier of the metastore
      service.
    updateTime: Output only. The time when the metastore service was last
      updated.
  """

  class DatabaseTypeValueValuesEnum(_messages.Enum):
    r"""Immutable. The database type that the Metastore service stores its
    data.

    Values:
      DATABASE_TYPE_UNSPECIFIED: The DATABASE_TYPE is not set.
      MYSQL: MySQL is used to persist the metastore data.
      SPANNER: Spanner is used to persist the metastore data.
    """
    DATABASE_TYPE_UNSPECIFIED = 0
    MYSQL = 1
    SPANNER = 2

  class ReleaseChannelValueValuesEnum(_messages.Enum):
    r"""Immutable. The release channel of the service. If unspecified,
    defaults to STABLE.

    Values:
      RELEASE_CHANNEL_UNSPECIFIED: Release channel is not specified.
      CANARY: The CANARY release channel contains the newest features, which
        may be unstable and subject to unresolved issues with no known
        workarounds. Services using the CANARY release channel are not subject
        to any SLAs.
      STABLE: The STABLE release channel contains features that are considered
        stable and have been validated for production use.
    """
    RELEASE_CHANNEL_UNSPECIFIED = 0
    CANARY = 1
    STABLE = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the metastore service.

    Values:
      STATE_UNSPECIFIED: The state of the metastore service is unknown.
      CREATING: The metastore service is in the process of being created.
      ACTIVE: The metastore service is running and ready to serve queries.
      SUSPENDING: The metastore service is entering suspension. Its query-
        serving availability may cease unexpectedly.
      SUSPENDED: The metastore service is suspended and unable to serve
        queries.
      UPDATING: The metastore service is being updated. It remains usable but
        cannot accept additional update requests or be deleted at this time.
      DELETING: The metastore service is undergoing deletion. It cannot be
        used.
      ERROR: The metastore service has encountered an error and cannot be
        used. The metastore service should be deleted.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    SUSPENDING = 3
    SUSPENDED = 4
    UPDATING = 5
    DELETING = 6
    ERROR = 7

  class TierValueValuesEnum(_messages.Enum):
    r"""The tier of the service.

    Values:
      TIER_UNSPECIFIED: The tier is not set.
      DEVELOPER: The developer tier provides limited scalability and no fault
        tolerance. Good for low-cost proof-of-concept.
      ENTERPRISE: The enterprise tier provides multi-zone high availability,
        and sufficient scalability for enterprise-level Dataproc Metastore
        workloads.
    """
    TIER_UNSPECIFIED = 0
    DEVELOPER = 1
    ENTERPRISE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""User-defined labels for the metastore service.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  artifactGcsUri = _messages.StringField(1)
  createTime = _messages.StringField(2)
  databaseType = _messages.EnumField('DatabaseTypeValueValuesEnum', 3)
  encryptionConfig = _messages.MessageField('EncryptionConfig', 4)
  endpointUri = _messages.StringField(5)
  hiveMetastoreConfig = _messages.MessageField('HiveMetastoreConfig', 6)
  labels = _messages.MessageField('LabelsValue', 7)
  maintenanceWindow = _messages.MessageField('MaintenanceWindow', 8)
  metadataManagementActivity = _messages.MessageField('MetadataManagementActivity', 9)
  name = _messages.StringField(10)
  network = _messages.StringField(11)
  port = _messages.IntegerField(12, variant=_messages.Variant.INT32)
  releaseChannel = _messages.EnumField('ReleaseChannelValueValuesEnum', 13)
  state = _messages.EnumField('StateValueValuesEnum', 14)
  stateMessage = _messages.StringField(15)
  tier = _messages.EnumField('TierValueValuesEnum', 16)
  uid = _messages.StringField(17)
  updateTime = _messages.StringField(18)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for SetIamPolicy method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the resource. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used:paths: "bindings, etag"
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The Status type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by gRPC (https://github.com/grpc). Each Status message contains three
  pieces of data: error code, error message, and error details.You can find
  out more about this error model and how to work with it in the API Design
  Guide (https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for TestIamPermissions method.

  Fields:
    permissions: The set of permissions to check for the resource. Permissions
      with wildcards (such as '*' or 'storage.*') are not allowed. For more
      information see IAM Overview
      (https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for TestIamPermissions method.

  Fields:
    permissions: A subset of TestPermissionsRequest.permissions that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
