"""Generated message classes for compute version beta.

Creates and runs virtual machines on Google Cloud Platform.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'compute'


class AcceleratorConfig(_messages.Message):
  r"""A specification of the type and number of accelerator cards attached to
  the instance.

  Fields:
    acceleratorCount: The number of the guest accelerator cards exposed to
      this instance.
    acceleratorType: Full or partial URL of the accelerator type resource to
      attach to this instance. For example: projects/my-project/zones/us-
      central1-c/acceleratorTypes/nvidia-tesla-p100 If you are creating an
      instance template, specify only the accelerator name. See GPUs on
      Compute Engine for a full list of accelerator types.
  """

  acceleratorCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  acceleratorType = _messages.StringField(2)


class AcceleratorType(_messages.Message):
  r"""Represents an Accelerator Type resource. Google Cloud Platform provides
  graphics processing units (accelerators) that you can add to VM instances to
  improve or accelerate performance when working with intensive workloads. For
  more information, read GPUs on Compute Engine.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    deprecated: [Output Only] The deprecation status associated with this
      accelerator type.
    description: [Output Only] An optional textual description of the
      resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] The type of the resource. Always
      compute#acceleratorType for accelerator types.
    maximumCardsPerInstance: [Output Only] Maximum number of accelerator cards
      allowed per instance.
    name: [Output Only] Name of the resource.
    selfLink: [Output Only] Server-defined, fully qualified URL for this
      resource.
    zone: [Output Only] The name of the zone where the accelerator type
      resides, such as us-central1-a. You must specify this field as part of
      the HTTP request URL. It is not settable as a field in the request body.
  """

  creationTimestamp = _messages.StringField(1)
  deprecated = _messages.MessageField('DeprecationStatus', 2)
  description = _messages.StringField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default='compute#acceleratorType')
  maximumCardsPerInstance = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  name = _messages.StringField(7)
  selfLink = _messages.StringField(8)
  zone = _messages.StringField(9)


class AcceleratorTypeAggregatedList(_messages.Message):
  r"""A AcceleratorTypeAggregatedList object.

  Messages:
    ItemsValue: A list of AcceleratorTypesScopedList resources.
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of AcceleratorTypesScopedList resources.
    kind: [Output Only] Type of resource. Always
      compute#acceleratorTypeAggregatedList for aggregated lists of
      accelerator types.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    unreachables: [Output Only] Unreachable resources.
    warning: [Output Only] Informational warning message.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    r"""A list of AcceleratorTypesScopedList resources.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of accelerator types.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A AcceleratorTypesScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('AcceleratorTypesScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: Warning about failed cleanup of transient changes made
          by a failed operation.
        DEPRECATED_RESOURCE_USED: A link to a deprecated resource was created.
        DEPRECATED_TYPE_USED: When deploying and at least one of the resources
          has a type marked as deprecated
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: The user created a boot disk that is
          larger than image size.
        EXPERIMENTAL_TYPE_USED: When deploying and at least one of the
          resources has a type marked as experimental
        EXTERNAL_API_WARNING: Warning that is present in an external api call
        FIELD_VALUE_OVERRIDEN: Warning that value of a field has been
          overridden. Deprecated unused field.
        INJECTED_KERNELS_DEPRECATED: The operation involved use of an injected
          kernel, which is deprecated.
        LARGE_DEPLOYMENT_WARNING: When deploying a deployment with a
          exceedingly large number of resources
        MISSING_TYPE_DEPENDENCY: A resource depends on a missing type
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: The route's nextHopIp address is not
          assigned to an instance on the network.
        NEXT_HOP_CANNOT_IP_FORWARD: The route's next hop instance cannot ip
          forward.
        NEXT_HOP_INSTANCE_NOT_FOUND: The route's nextHopInstance URL refers to
          an instance that does not exist.
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: The route's nextHopInstance URL
          refers to an instance that is not on the same network as the route.
        NEXT_HOP_NOT_RUNNING: The route's next hop instance does not have a
          status of RUNNING.
        NOT_CRITICAL_ERROR: Error which is not critical. We decided to
          continue the process despite the mentioned error.
        NO_RESULTS_ON_PAGE: No results are present on a particular list page.
        PARTIAL_SUCCESS: Success is reported, but some results may be missing
          due to errors
        REQUIRED_TOS_AGREEMENT: The user attempted to use a resource that
          requires a TOS they have not accepted.
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: Warning that a resource is
          in use.
        RESOURCE_NOT_DELETED: One or more of the resources set to auto-delete
          could not be deleted because they were in use.
        SCHEMA_VALIDATION_IGNORED: When a resource schema validation is
          ignored.
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: Instance template used in instance
          group manager is valid as such, but its application does not make a
          lot of sense, because it allows only single instance in instance
          group.
        UNDECLARED_PROPERTIES: When undeclared properties in the schema are
          present
        UNREACHABLE: A given scope cannot be reached.
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      LARGE_DEPLOYMENT_WARNING = 8
      MISSING_TYPE_DEPENDENCY = 9
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 10
      NEXT_HOP_CANNOT_IP_FORWARD = 11
      NEXT_HOP_INSTANCE_NOT_FOUND = 12
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 13
      NEXT_HOP_NOT_RUNNING = 14
      NOT_CRITICAL_ERROR = 15
      NO_RESULTS_ON_PAGE = 16
      PARTIAL_SUCCESS = 17
      REQUIRED_TOS_AGREEMENT = 18
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 19
      RESOURCE_NOT_DELETED = 20
      SCHEMA_VALIDATION_IGNORED = 21
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 22
      UNDECLARED_PROPERTIES = 23
      UNREACHABLE = 24

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default='compute#acceleratorTypeAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  unreachables = _messages.StringField(6, repeated=True)
  warning = _messages.MessageField('WarningValue', 7)


class AcceleratorTypeList(_messages.Message):
  r"""Contains a list of accelerator types.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of AcceleratorType resources.
    kind: [Output Only] Type of resource. Always compute#acceleratorTypeList
      for lists of accelerator types.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: Warning about failed cleanup of transient changes made
          by a failed operation.
        DEPRECATED_RESOURCE_USED: A link to a deprecated resource was created.
        DEPRECATED_TYPE_USED: When deploying and at least one of the resources
          has a type marked as deprecated
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: The user created a boot disk that is
          larger than image size.
        EXPERIMENTAL_TYPE_USED: When deploying and at least one of the
          resources has a type marked as experimental
        EXTERNAL_API_WARNING: Warning that is present in an external api call
        FIELD_VALUE_OVERRIDEN: Warning that value of a field has been
          overridden. Deprecated unused field.
        INJECTED_KERNELS_DEPRECATED: The operation involved use of an injected
          kernel, which is deprecated.
        LARGE_DEPLOYMENT_WARNING: When deploying a deployment with a
          exceedingly large number of resources
        MISSING_TYPE_DEPENDENCY: A resource depends on a missing type
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: The route's nextHopIp address is not
          assigned to an instance on the network.
        NEXT_HOP_CANNOT_IP_FORWARD: The route's next hop instance cannot ip
          forward.
        NEXT_HOP_INSTANCE_NOT_FOUND: The route's nextHopInstance URL refers to
          an instance that does not exist.
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: The route's nextHopInstance URL
          refers to an instance that is not on the same network as the route.
        NEXT_HOP_NOT_RUNNING: The route's next hop instance does not have a
          status of RUNNING.
        NOT_CRITICAL_ERROR: Error which is not critical. We decided to
          continue the process despite the mentioned error.
        NO_RESULTS_ON_PAGE: No results are present on a particular list page.
        PARTIAL_SUCCESS: Success is reported, but some results may be missing
          due to errors
        REQUIRED_TOS_AGREEMENT: The user attempted to use a resource that
          requires a TOS they have not accepted.
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: Warning that a resource is
          in use.
        RESOURCE_NOT_DELETED: One or more of the resources set to auto-delete
          could not be deleted because they were in use.
        SCHEMA_VALIDATION_IGNORED: When a resource schema validation is
          ignored.
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: Instance template used in instance
          group manager is valid as such, but its application does not make a
          lot of sense, because it allows only single instance in instance
          group.
        UNDECLARED_PROPERTIES: When undeclared properties in the schema are
          present
        UNREACHABLE: A given scope cannot be reached.
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      LARGE_DEPLOYMENT_WARNING = 8
      MISSING_TYPE_DEPENDENCY = 9
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 10
      NEXT_HOP_CANNOT_IP_FORWARD = 11
      NEXT_HOP_INSTANCE_NOT_FOUND = 12
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 13
      NEXT_HOP_NOT_RUNNING = 14
      NOT_CRITICAL_ERROR = 15
      NO_RESULTS_ON_PAGE = 16
      PARTIAL_SUCCESS = 17
      REQUIRED_TOS_AGREEMENT = 18
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 19
      RESOURCE_NOT_DELETED = 20
      SCHEMA_VALIDATION_IGNORED = 21
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 22
      UNDECLARED_PROPERTIES = 23
      UNREACHABLE = 24

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('AcceleratorType', 2, repeated=True)
  kind = _messages.StringField(3, default='compute#acceleratorTypeList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class AcceleratorTypesScopedList(_messages.Message):
  r"""A AcceleratorTypesScopedList object.

  Messages:
    WarningValue: [Output Only] An informational warning that appears when the
      accelerator types list is empty.

  Fields:
    acceleratorTypes: [Output Only] A list of accelerator types contained in
      this scope.
    warning: [Output Only] An informational warning that appears when the
      accelerator types list is empty.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] An informational warning that appears when the
    accelerator types list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: Warning about failed cleanup of transient changes made
          by a failed operation.
        DEPRECATED_RESOURCE_USED: A link to a deprecated resource was created.
        DEPRECATED_TYPE_USED: When deploying and at least one of the resources
          has a type marked as deprecated
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: The user created a boot disk that is
          larger than image size.
        EXPERIMENTAL_TYPE_USED: When deploying and at least one of the
          resources has a type marked as experimental
        EXTERNAL_API_WARNING: Warning that is present in an external api call
        FIELD_VALUE_OVERRIDEN: Warning that value of a field has been
          overridden. Deprecated unused field.
        INJECTED_KERNELS_DEPRECATED: The operation involved use of an injected
          kernel, which is deprecated.
        LARGE_DEPLOYMENT_WARNING: When deploying a deployment with a
          exceedingly large number of resources
        MISSING_TYPE_DEPENDENCY: A resource depends on a missing type
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: The route's nextHopIp address is not
          assigned to an instance on the network.
        NEXT_HOP_CANNOT_IP_FORWARD: The route's next hop instance cannot ip
          forward.
        NEXT_HOP_INSTANCE_NOT_FOUND: The route's nextHopInstance URL refers to
          an instance that does not exist.
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: The route's nextHopInstance URL
          refers to an instance that is not on the same network as the route.
        NEXT_HOP_NOT_RUNNING: The route's next hop instance does not have a
          status of RUNNING.
        NOT_CRITICAL_ERROR: Error which is not critical. We decided to
          continue the process despite the mentioned error.
        NO_RESULTS_ON_PAGE: No results are present on a particular list page.
        PARTIAL_SUCCESS: Success is reported, but some results may be missing
          due to errors
        REQUIRED_TOS_AGREEMENT: The user attempted to use a resource that
          requires a TOS they have not accepted.
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: Warning that a resource is
          in use.
        RESOURCE_NOT_DELETED: One or more of the resources set to auto-delete
          could not be deleted because they were in use.
        SCHEMA_VALIDATION_IGNORED: When a resource schema validation is
          ignored.
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: Instance template used in instance
          group manager is valid as such, but its application does not make a
          lot of sense, because it allows only single instance in instance
          group.
        UNDECLARED_PROPERTIES: When undeclared properties in the schema are
          present
        UNREACHABLE: A given scope cannot be reached.
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      LARGE_DEPLOYMENT_WARNING = 8
      MISSING_TYPE_DEPENDENCY = 9
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 10
      NEXT_HOP_CANNOT_IP_FORWARD = 11
      NEXT_HOP_INSTANCE_NOT_FOUND = 12
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 13
      NEXT_HOP_NOT_RUNNING = 14
      NOT_CRITICAL_ERROR = 15
      NO_RESULTS_ON_PAGE = 16
      PARTIAL_SUCCESS = 17
      REQUIRED_TOS_AGREEMENT = 18
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 19
      RESOURCE_NOT_DELETED = 20
      SCHEMA_VALIDATION_IGNORED = 21
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 22
      UNDECLARED_PROPERTIES = 23
      UNREACHABLE = 24

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  acceleratorTypes = _messages.MessageField('AcceleratorType', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class AccessConfig(_messages.Message):
  r"""An access configuration attached to an instance's network interface.
  Only one access config per instance is supported.

  Enums:
    NetworkTierValueValuesEnum: This signifies the networking tier used for
      configuring this access configuration and can only take the following
      values: PREMIUM, STANDARD. If an AccessConfig is specified without a
      valid external IP address, an ephemeral IP will be created with this
      networkTier. If an AccessConfig with a valid external IP address is
      specified, it must match that of the networkTier associated with the
      Address resource owning that IP.
    TypeValueValuesEnum: The type of configuration. The default and only
      option is ONE_TO_ONE_NAT.

  Fields:
    externalIpv6: The first IPv6 address of the external IPv6 range associated
      with this instance, prefix length is stored in externalIpv6PrefixLength
      in ipv6AccessConfig. The field is output only, an IPv6 address from a
      subnetwork associated with the instance will be allocated dynamically.
    externalIpv6PrefixLength: The prefix length of the external IPv6 range.
    kind: [Output Only] Type of the resource. Always compute#accessConfig for
      access configs.
    name: The name of this access configuration. The default and recommended
      name is External NAT, but you can use any arbitrary string, such as My
      external IP or Network Access.
    natIP: An external IP address associated with this instance. Specify an
      unused static external IP address available to the project or leave this
      field undefined to use an IP from a shared ephemeral IP address pool. If
      you specify a static external IP address, it must live in the same
      region as the zone of the instance.
    networkTier: This signifies the networking tier used for configuring this
      access configuration and can only take the following values: PREMIUM,
      STANDARD. If an AccessConfig is specified without a valid external IP
      address, an ephemeral IP will be created with this networkTier. If an
      AccessConfig with a valid external IP address is specified, it must
      match that of the networkTier associated with the Address resource
      owning that IP.
    publicPtrDomainName: The DNS domain name for the public PTR record. You
      can set this field only if the `setPublicPtr` field is enabled in
      accessConfig. If this field is unspecified in ipv6AccessConfig, a
      default PTR record will be createc for first IP in associated external
      IPv6 range.
    setPublicPtr: Specifies whether a public DNS 'PTR' record should be
      created to map the external IP address of the instance to a DNS domain
      name. This field is not used in ipv6AccessConfig. A default PTR record
      will be created if the VM has external IPv6 range associated.
    type: The type of configuration. The default and only option is
      ONE_TO_ONE_NAT.
  """

  class NetworkTierValueValuesEnum(_messages.Enum):
    r"""This signifies the networking tier used for configuring this access
    configuration and can only take the following values: PREMIUM, STANDARD.
    If an AccessConfig is specified without a valid external IP address, an
    ephemeral IP will be created with this networkTier. If an AccessConfig
    with a valid external IP address is specified, it must match that of the
    networkTier associated with the Address resource owning that IP.

    Values:
      FIXED_STANDARD: Public internet quality with fixed bandwidth.
      PREMIUM: High quality, Google-grade network tier, support for all
        networking products.
      STANDARD: Public internet quality, only limited support for other
        networking products.
      STANDARD_OVERRIDES_FIXED_STANDARD: (Output only) Temporary tier for
        FIXED_STANDARD when fixed standard tier is expired or not configured.
    """
    FIXED_STANDARD = 0
    PREMIUM = 1
    STANDARD = 2
    STANDARD_OVERRIDES_FIXED_STANDARD = 3

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of configuration. The default and only option is
    ONE_TO_ONE_NAT.

    Values:
      DIRECT_IPV6: <no description>
      ONE_TO_ONE_NAT: <no description>
    """
    DIRECT_IPV6 = 0
    ONE_TO_ONE_NAT = 1

  externalIpv6 = _messages.StringField(1)
  externalIpv6PrefixLength = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  kind = _messages.StringField(3, default='compute#accessConfig')
  name = _messages.StringField(4)
  natIP = _messages.StringField(5)
  networkTier = _messages.EnumField('NetworkTierValueValuesEnum', 6)
  publicPtrDomainName = _messages.StringField(7)
  setPublicPtr = _messages.BooleanField(8)
  type = _messages.EnumField('TypeValueValuesEnum', 9, default='ONE_TO_ONE_NAT')


class Address(_messages.Message):
  r"""Represents an IP Address resource. Google Compute Engine has two IP
  Address resources: * [Global (external and internal)](https://cloud.google.c
  om/compute/docs/reference/rest/beta/globalAddresses) * [Regional (external
  and internal)](https://cloud.google.com/compute/docs/reference/rest/beta/add
  resses) For more information, see Reserving a static external IP address.

  Enums:
    AddressTypeValueValuesEnum: The type of address to reserve, either
      INTERNAL or EXTERNAL. If unspecified, defaults to EXTERNAL.
    IpVersionValueValuesEnum: The IP version that will be used by this
      address. Valid options are IPV4 or IPV6. This can only be specified for
      a global address.
    NetworkTierValueValuesEnum: This signifies the networking tier used for
      configuring this address and can only take the following values: PREMIUM
      or STANDARD. Internal IP addresses are always Premium Tier; global
      external IP addresses are always Premium Tier; regional external IP
      addresses can be either Standard or Premium Tier. If this field is not
      specified, it is assumed to be PREMIUM.
    PurposeValueValuesEnum: The purpose of this resource, which can be one of
      the following values: - GCE_ENDPOINT for addresses that are used by VM
      instances, alias IP ranges, load balancers, and similar resources. -
      DNS_RESOLVER for a DNS resolver address in a subnetwork for a Cloud DNS
      inbound forwarder IP addresses (regional internal IP address in a subnet
      of a VPC network) - VPC_PEERING for global internal IP addresses used
      for private services access allocated ranges. - NAT_AUTO for the
      regional external IP addresses used by Cloud NAT when allocating
      addresses using automatic NAT IP address allocation. -
      IPSEC_INTERCONNECT for addresses created from a private IP range that
      are reserved for a VLAN attachment in an *IPsec-encrypted Cloud
      Interconnect* configuration. These addresses are regional resources. Not
      currently available publicly. - `SHARED_LOADBALANCER_VIP` for an
      internal IP address that is assigned to multiple internal forwarding
      rules. - `PRIVATE_SERVICE_CONNECT` for a private network address that is
      used to configure Private Service Connect. Only global internal
      addresses can use this purpose.
    StatusValueValuesEnum: [Output Only] The status of the address, which can
      be one of RESERVING, RESERVED, or IN_USE. An address that is RESERVING
      is currently in the process of being reserved. A RESERVED address is
      currently reserved and available to use. An IN_USE address is currently
      being used by another resource and is not available.

  Messages:
    LabelsValue: Labels for this resource. These can only be added or modified
      by the setLabels method. Each label key/value pair must comply with
      RFC1035. Label values may be empty.

  Fields:
    address: The static IP address represented by this resource.
    addressType: The type of address to reserve, either INTERNAL or EXTERNAL.
      If unspecified, defaults to EXTERNAL.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this field
      when you create the resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    ipVersion: The IP version that will be used by this address. Valid options
      are IPV4 or IPV6. This can only be specified for a global address.
    kind: [Output Only] Type of the resource. Always compute#address for
      addresses.
    labelFingerprint: A fingerprint for the labels being applied to this
      Address, which is essentially a hash of the labels set used for
      optimistic locking. The fingerprint is initially generated by Compute
      Engine and changes after every request to modify or update labels. You
      must always provide an up-to-date fingerprint hash in order to update or
      change labels, otherwise the request will fail with error 412
      conditionNotMet. To see the latest fingerprint, make a get() request to
      retrieve an Address.
    labels: Labels for this resource. These can only be added or modified by
      the setLabels method. Each label key/value pair must comply with
      RFC1035. Label values may be empty.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character
      must be a lowercase letter, and all following characters (except for the
      last character) must be a dash, lowercase letter, or digit. The last
      character must be a lowercase letter or digit.
    network: The URL of the network in which to reserve the address. This
      field can only be used with INTERNAL type with the VPC_PEERING purpose.
    networkTier: This signifies the networking tier used for configuring this
      address and can only take the following values: PREMIUM or STANDARD.
      Internal IP addresses are always Premium Tier; global external IP
      addresses are always Premium Tier; regional external IP addresses can be
      either Standard or Premium Tier. If this field is not specified, it is
      assumed to be PREMIUM.
    prefixLength: The prefix length if the resource represents an IP range.
    purpose: The purpose of this resource, which can be one of the following
      values: - GCE_ENDPOINT for addresses that are used by VM instances,
      alias IP ranges, load balancers, and similar resources. - DNS_RESOLVER
      for a DNS resolver address in a subnetwork for a Cloud DNS inbound
      forwarder IP addresses (regional internal IP address in a subnet of a
      VPC network) - VPC_PEERING for global internal IP addresses used for
      private services access allocated ranges. - NAT_AUTO for the regional
      external IP addresses used by Cloud NAT when allocating addresses using
      automatic NAT IP address allocation. - IPSEC_INTERCONNECT for addresses
      created from a private IP range that are reserved for a VLAN attachment
      in an *IPsec-encrypted Cloud Interconnect* configuration. These
      addresses are regional resources. Not currently available publicly. -
      `SHARED_LOADBALANCER_VIP` for an internal IP address that is assigned to
      multiple internal forwarding rules. - `PRIVATE_SERVICE_CONNECT` for a
      private network address that is used to configure Private Service
      Connect. Only global internal addresses can use this purpose.
    region: [Output Only] The URL of the region where a regional address
      resides. For regional addresses, you must specify the region as a path
      parameter in the HTTP request URL. *This field is not applicable to
      global addresses.*
    selfLink: [Output Only] Server-defined URL for the resource.
    status: [Output Only] The status of the address, which can be one of
      RESERVING, RESERVED, or IN_USE. An address that is RESERVING is
      currently in the process of being reserved. A RESERVED address is
      currently reserved and available to use. An IN_USE address is currently
      being used by another resource and is not available.
    subnetwork: The URL of the subnetwork in which to reserve the address. If
      an IP address is specified, it must be within the subnetwork's IP range.
      This field can only be used with INTERNAL type with a GCE_ENDPOINT or
      DNS_RESOLVER purpose.
    users: [Output Only] The URLs of the resources that are using this
      address.
  """

  class AddressTypeValueValuesEnum(_messages.Enum):
    r"""The type of address to reserve, either INTERNAL or EXTERNAL. If
    unspecified, defaults to EXTERNAL.

    Values:
      EXTERNAL: A publicly visible external IP address.
      INTERNAL: A private network IP address, for use with an Instance or
        Internal Load Balancer forwarding rule.
      UNSPECIFIED_TYPE: <no description>
    """
    EXTERNAL = 0
    INTERNAL = 1
    UNSPECIFIED_TYPE = 2

  class IpVersionValueValuesEnum(_messages.Enum):
    r"""The IP version that will be used by this address. Valid options are
    IPV4 or IPV6. This can only be specified for a global address.

    Values:
      IPV4: <no description>
      IPV6: <no description>
      UNSPECIFIED_VERSION: <no description>
    """
    IPV4 = 0
    IPV6 = 1
    UNSPECIFIED_VERSION = 2

  class NetworkTierValueValuesEnum(_messages.Enum):
    r"""This signifies the networking tier used for configuring this address
    and can only take the following values: PREMIUM or STANDARD. Internal IP
    addresses are always Premium Tier; global external IP addresses are always
    Premium Tier; regional external IP addresses can be either Standard or
    Premium Tier. If this field is not specified, it is assumed to be PREMIUM.

    Values:
      FIXED_STANDARD: Public internet quality with fixed bandwidth.
      PREMIUM: High quality, Google-grade network tier, support for all
        networking products.
      STANDARD: Public internet quality, only limited support for other
        networking products.
      STANDARD_OVERRIDES_FIXED_STANDARD: (Output only) Temporary tier for
        FIXED_STANDARD when fixed standard tier is expired or not configured.
    """
    FIXED_STANDARD = 0
    PREMIUM = 1
    STANDARD = 2
    STANDARD_OVERRIDES_FIXED_STANDARD = 3

  class PurposeValueValuesEnum(_messages.Enum):
    r"""The purpose of this resource, which can be one of the following
    values: - GCE_ENDPOINT for addresses that are used by VM instances, alias
    IP ranges, load balancers, and similar resources. - DNS_RESOLVER for a DNS
    resolver address in a subnetwork for a Cloud DNS inbound forwarder IP
    addresses (regional internal IP address in a subnet of a VPC network) -
    VPC_PEERING for global internal IP addresses used for private services
    access allocated ranges. - NAT_AUTO for the regional external IP addresses
    used by Cloud NAT when allocating addresses using automatic NAT IP address
    allocation. - IPSEC_INTERCONNECT for addresses created from a private IP
    range that are reserved for a VLAN attachment in an *IPsec-encrypted Cloud
    Interconnect* configuration. These addresses are regional resources. Not
    currently available publicly. - `SHARED_LOADBALANCER_VIP` for an internal
    IP address that is assigned to multiple internal forwarding rules. -
    `PRIVATE_SERVICE_CONNECT` for a private network address that is used to
    configure Private Service Connect. Only global internal addresses can use
    this purpose.

    Values:
      DNS_RESOLVER: DNS resolver address in the subnetwork.
      GCE_ENDPOINT: VM internal/alias IP, Internal LB service IP, etc.
      IPSEC_INTERCONNECT: A regional internal IP address range reserved for
        the VLAN attachment that is used in IPsec-encrypted Cloud
        Interconnect. This regional internal IP address range must not overlap
        with any IP address range of subnet/route in the VPC network and its
        peering networks. After the VLAN attachment is created with the
        reserved IP address range, when creating a new VPN gateway, its
        interface IP address is allocated from the associated VLAN
        attachment's IP address range.
      NAT_AUTO: External IP automatically reserved for Cloud NAT.
      PRIVATE_SERVICE_CONNECT: A private network IP address that can be used
        to configure Private Service Connect. This purpose can be specified
        only for GLOBAL addresses of Type INTERNAL
      SHARED_LOADBALANCER_VIP: A private network IP address that can be shared
        by multiple Internal Load Balancer forwarding rules.
      VPC_PEERING: IP range for peer networks.
    """
    DNS_RESOLVER = 0
    GCE_ENDPOINT = 1
    IPSEC_INTERCONNECT = 2
    NAT_AUTO = 3
    PRIVATE_SERVICE_CONNECT = 4
    SHARED_LOADBALANCER_VIP = 5
    VPC_PEERING = 6

  class StatusValueValuesEnum(_messages.Enum):
    r"""[Output Only] The status of the address, which can be one of
    RESERVING, RESERVED, or IN_USE. An address that is RESERVING is currently
    in the process of being reserved. A RESERVED address is currently reserved
    and available to use. An IN_USE address is currently being used by another
    resource and is not available.

    Values:
      IN_USE: Address is being used by another resource and is not available.
      RESERVED: Address is reserved and available to use.
      RESERVING: Address is being reserved.
    """
    IN_USE = 0
    RESERVED = 1
    RESERVING = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels for this resource. These can only be added or modified by the
    setLabels method. Each label key/value pair must comply with RFC1035.
    Label values may be empty.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  address = _messages.StringField(1)
  addressType = _messages.EnumField('AddressTypeValueValuesEnum', 2)
  creationTimestamp = _messages.StringField(3)
  description = _messages.StringField(4)
  id = _messages.IntegerField(5, variant=_messages.Variant.UINT64)
  ipVersion = _messages.EnumField('IpVersionValueValuesEnum', 6)
  kind = _messages.StringField(7, default='compute#address')
  labelFingerprint = _messages.BytesField(8)
  labels = _messages.MessageField('LabelsValue', 9)
  name = _messages.StringField(10)
  network = _messages.StringField(11)
  networkTier = _messages.EnumField('NetworkTierValueValuesEnum', 12)
  prefixLength = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  purpose = _messages.EnumField('PurposeValueValuesEnum', 14)
  region = _messages.StringField(15)
  selfLink = _messages.StringField(16)
  status = _messages.EnumField('StatusValueValuesEnum', 17)
  subnetwork = _messages.StringField(18)
  users = _messages.StringField(19, repeated=True)


class AddressAggregatedList(_messages.Message):
  r"""A AddressAggregatedList object.

  Messages:
    ItemsValue: A list of AddressesScopedList resources.
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of AddressesScopedList resources.
    kind: [Output Only] Type of resource. Always compute#addressAggregatedList
      for aggregated lists of addresses.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    unreachables: [Output Only] Unreachable resources.
    warning: [Output Only] Informational warning message.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    r"""A list of AddressesScopedList resources.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of addresses.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A AddressesScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('AddressesScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: Warning about failed cleanup of transient changes made
          by a failed operation.
        DEPRECATED_RESOURCE_USED: A link to a deprecated resource was created.
        DEPRECATED_TYPE_USED: When deploying and at least one of the resources
          has a type marked as deprecated
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: The user created a boot disk that is
          larger than image size.
        EXPERIMENTAL_TYPE_USED: When deploying and at least one of the
          resources has a type marked as experimental
        EXTERNAL_API_WARNING: Warning that is present in an external api call
        FIELD_VALUE_OVERRIDEN: Warning that value of a field has been
          overridden. Deprecated unused field.
        INJECTED_KERNELS_DEPRECATED: The operation involved use of an injected
          kernel, which is deprecated.
        LARGE_DEPLOYMENT_WARNING: When deploying a deployment with a
          exceedingly large number of resources
        MISSING_TYPE_DEPENDENCY: A resource depends on a missing type
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: The route's nextHopIp address is not
          assigned to an instance on the network.
        NEXT_HOP_CANNOT_IP_FORWARD: The route's next hop instance cannot ip
          forward.
        NEXT_HOP_INSTANCE_NOT_FOUND: The route's nextHopInstance URL refers to
          an instance that does not exist.
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: The route's nextHopInstance URL
          refers to an instance that is not on the same network as the route.
        NEXT_HOP_NOT_RUNNING: The route's next hop instance does not have a
          status of RUNNING.
        NOT_CRITICAL_ERROR: Error which is not critical. We decided to
          continue the process despite the mentioned error.
        NO_RESULTS_ON_PAGE: No results are present on a particular list page.
        PARTIAL_SUCCESS: Success is reported, but some results may be missing
          due to errors
        REQUIRED_TOS_AGREEMENT: The user attempted to use a resource that
          requires a TOS they have not accepted.
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: Warning that a resource is
          in use.
        RESOURCE_NOT_DELETED: One or more of the resources set to auto-delete
          could not be deleted because they were in use.
        SCHEMA_VALIDATION_IGNORED: When a resource schema validation is
          ignored.
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: Instance template used in instance
          group manager is valid as such, but its application does not make a
          lot of sense, because it allows only single instance in instance
          group.
        UNDECLARED_PROPERTIES: When undeclared properties in the schema are
          present
        UNREACHABLE: A given scope cannot be reached.
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      LARGE_DEPLOYMENT_WARNING = 8
      MISSING_TYPE_DEPENDENCY = 9
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 10
      NEXT_HOP_CANNOT_IP_FORWARD = 11
      NEXT_HOP_INSTANCE_NOT_FOUND = 12
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 13
      NEXT_HOP_NOT_RUNNING = 14
      NOT_CRITICAL_ERROR = 15
      NO_RESULTS_ON_PAGE = 16
      PARTIAL_SUCCESS = 17
      REQUIRED_TOS_AGREEMENT = 18
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 19
      RESOURCE_NOT_DELETED = 20
      SCHEMA_VALIDATION_IGNORED = 21
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 22
      UNDECLARED_PROPERTIES = 23
      UNREACHABLE = 24

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default='compute#addressAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  unreachables = _messages.StringField(6, repeated=True)
  warning = _messages.MessageField('WarningValue', 7)


class AddressList(_messages.Message):
  r"""Contains a list of addresses.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of Address resources.
    kind: [Output Only] Type of resource. Always compute#addressList for lists
      of addresses.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: Warning about failed cleanup of transient changes made
          by a failed operation.
        DEPRECATED_RESOURCE_USED: A link to a deprecated resource was created.
        DEPRECATED_TYPE_USED: When deploying and at least one of the resources
          has a type marked as deprecated
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: The user created a boot disk that is
          larger than image size.
        EXPERIMENTAL_TYPE_USED: When deploying and at least one of the
          resources has a type marked as experimental
        EXTERNAL_API_WARNING: Warning that is present in an external api call
        FIELD_VALUE_OVERRIDEN: Warning that value of a field has been
          overridden. Deprecated unused field.
        INJECTED_KERNELS_DEPRECATED: The operation involved use of an injected
          kernel, which is deprecated.
        LARGE_DEPLOYMENT_WARNING: When deploying a deployment with a
          exceedingly large number of resources
        MISSING_TYPE_DEPENDENCY: A resource depends on a missing type
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: The route's nextHopIp address is not
          assigned to an instance on the network.
        NEXT_HOP_CANNOT_IP_FORWARD: The route's next hop instance cannot ip
          forward.
        NEXT_HOP_INSTANCE_NOT_FOUND: The route's nextHopInstance URL refers to
          an instance that does not exist.
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: The route's nextHopInstance URL
          refers to an instance that is not on the same network as the route.
        NEXT_HOP_NOT_RUNNING: The route's next hop instance does not have a
          status of RUNNING.
        NOT_CRITICAL_ERROR: Error which is not critical. We decided to
          continue the process despite the mentioned error.
        NO_RESULTS_ON_PAGE: No results are present on a particular list page.
        PARTIAL_SUCCESS: Success is reported, but some results may be missing
          due to errors
        REQUIRED_TOS_AGREEMENT: The user attempted to use a resource that
          requires a TOS they have not accepted.
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: Warning that a resource is
          in use.
        RESOURCE_NOT_DELETED: One or more of the resources set to auto-delete
          could not be deleted because they were in use.
        SCHEMA_VALIDATION_IGNORED: When a resource schema validation is
          ignored.
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: Instance template used in instance
          group manager is valid as such, but its application does not make a
          lot of sense, because it allows only single instance in instance
          group.
        UNDECLARED_PROPERTIES: When undeclared properties in the schema are
          present
        UNREACHABLE: A given scope cannot be reached.
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      LARGE_DEPLOYMENT_WARNING = 8
      MISSING_TYPE_DEPENDENCY = 9
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 10
      NEXT_HOP_CANNOT_IP_FORWARD = 11
      NEXT_HOP_INSTANCE_NOT_FOUND = 12
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 13
      NEXT_HOP_NOT_RUNNING = 14
      NOT_CRITICAL_ERROR = 15
      NO_RESULTS_ON_PAGE = 16
      PARTIAL_SUCCESS = 17
      REQUIRED_TOS_AGREEMENT = 18
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 19
      RESOURCE_NOT_DELETED = 20
      SCHEMA_VALIDATION_IGNORED = 21
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 22
      UNDECLARED_PROPERTIES = 23
      UNREACHABLE = 24

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('Address', 2, repeated=True)
  kind = _messages.StringField(3, default='compute#addressList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class AddressesScopedList(_messages.Message):
  r"""A AddressesScopedList object.

  Messages:
    WarningValue: [Output Only] Informational warning which replaces the list
      of addresses when the list is empty.

  Fields:
    addresses: [Output Only] A list of addresses contained in this scope.
    warning: [Output Only] Informational warning which replaces the list of
      addresses when the list is empty.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning which replaces the list of
    addresses when the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: Warning about failed cleanup of transient changes made
          by a failed operation.
        DEPRECATED_RESOURCE_USED: A link to a deprecated resource was created.
        DEPRECATED_TYPE_USED: When deploying and at least one of the resources
          has a type marked as deprecated
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: The user created a boot disk that is
          larger than image size.
        EXPERIMENTAL_TYPE_USED: When deploying and at least one of the
          resources has a type marked as experimental
        EXTERNAL_API_WARNING: Warning that is present in an external api call
        FIELD_VALUE_OVERRIDEN: Warning that value of a field has been
          overridden. Deprecated unused field.
        INJECTED_KERNELS_DEPRECATED: The operation involved use of an injected
          kernel, which is deprecated.
        LARGE_DEPLOYMENT_WARNING: When deploying a deployment with a
          exceedingly large number of resources
        MISSING_TYPE_DEPENDENCY: A resource depends on a missing type
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: The route's nextHopIp address is not
          assigned to an instance on the network.
        NEXT_HOP_CANNOT_IP_FORWARD: The route's next hop instance cannot ip
          forward.
        NEXT_HOP_INSTANCE_NOT_FOUND: The route's nextHopInstance URL refers to
          an instance that does not exist.
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: The route's nextHopInstance URL
          refers to an instance that is not on the same network as the route.
        NEXT_HOP_NOT_RUNNING: The route's next hop instance does not have a
          status of RUNNING.
        NOT_CRITICAL_ERROR: Error which is not critical. We decided to
          continue the process despite the mentioned error.
        NO_RESULTS_ON_PAGE: No results are present on a particular list page.
        PARTIAL_SUCCESS: Success is reported, but some results may be missing
          due to errors
        REQUIRED_TOS_AGREEMENT: The user attempted to use a resource that
          requires a TOS they have not accepted.
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: Warning that a resource is
          in use.
        RESOURCE_NOT_DELETED: One or more of the resources set to auto-delete
          could not be deleted because they were in use.
        SCHEMA_VALIDATION_IGNORED: When a resource schema validation is
          ignored.
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: Instance template used in instance
          group manager is valid as such, but its application does not make a
          lot of sense, because it allows only single instance in instance
          group.
        UNDECLARED_PROPERTIES: When undeclared properties in the schema are
          present
        UNREACHABLE: A given scope cannot be reached.
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      LARGE_DEPLOYMENT_WARNING = 8
      MISSING_TYPE_DEPENDENCY = 9
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 10
      NEXT_HOP_CANNOT_IP_FORWARD = 11
      NEXT_HOP_INSTANCE_NOT_FOUND = 12
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 13
      NEXT_HOP_NOT_RUNNING = 14
      NOT_CRITICAL_ERROR = 15
      NO_RESULTS_ON_PAGE = 16
      PARTIAL_SUCCESS = 17
      REQUIRED_TOS_AGREEMENT = 18
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 19
      RESOURCE_NOT_DELETED = 20
      SCHEMA_VALIDATION_IGNORED = 21
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 22
      UNDECLARED_PROPERTIES = 23
      UNREACHABLE = 24

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  addresses = _messages.MessageField('Address', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class AdvancedMachineFeatures(_messages.Message):
  r"""Specifies options for controlling advanced machine features. Options
  that would traditionally be configured in a BIOS belong here. Features that
  require operating system support may have corresponding entries in the
  GuestOsFeatures of an Image (e.g., whether or not the OS in the Image
  supports nested virtualization being enabled or disabled).

  Fields:
    enableNestedVirtualization: Whether to enable nested virtualization or not
      (default is false).
    enableUefiNetworking: Whether to enable UEFI networking for instance
      creation.
    threadsPerCore: The number of threads per physical core. To disable
      simultaneous multithreading (SMT) set this to 1. If unset, the maximum
      number of threads supported per core by the underlying processor is
      assumed.
  """

  enableNestedVirtualization = _messages.BooleanField(1)
  enableUefiNetworking = _messages.BooleanField(2)
  threadsPerCore = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class AliasIpRange(_messages.Message):
  r"""An alias IP range attached to an instance's network interface.

  Fields:
    ipCidrRange: The IP alias ranges to allocate for this interface. This IP
      CIDR range must belong to the specified subnetwork and cannot contain IP
      addresses reserved by system or used by other network interfaces. This
      range may be a single IP address (such as 10.2.3.4), a netmask (such as
      /24) or a CIDR-formatted string (such as 10.1.2.0/24).
    subnetworkRangeName: The name of a subnetwork secondary IP range from
      which to allocate an IP alias range. If not specified, the primary range
      of the subnetwork is used.
  """

  ipCidrRange = _messages.StringField(1)
  subnetworkRangeName = _messages.StringField(2)


class AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk(_messages.Message):
  r"""A AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk
  object.

  Enums:
    InterfaceValueValuesEnum: Specifies the disk interface to use for
      attaching this disk, which is either SCSI or NVME. The default is SCSI.
      For performance characteristics of SCSI over NVMe, see Local SSD
      performance.

  Fields:
    diskSizeGb: Specifies the size of the disk in base-2 GB.
    interface: Specifies the disk interface to use for attaching this disk,
      which is either SCSI or NVME. The default is SCSI. For performance
      characteristics of SCSI over NVMe, see Local SSD performance.
  """

  class InterfaceValueValuesEnum(_messages.Enum):
    r"""Specifies the disk interface to use for attaching this disk, which is
    either SCSI or NVME. The default is SCSI. For performance characteristics
    of SCSI over NVMe, see Local SSD performance.

    Values:
      NVME: <no description>
      SCSI: <no description>
    """
    NVME = 0
    SCSI = 1

  diskSizeGb = _messages.IntegerField(1)
  interface = _messages.EnumField('InterfaceValueValuesEnum', 2)


class AllocationSpecificSKUAllocationReservedInstanceProperties(_messages.Message):
  r"""Properties of the SKU instances being reserved. Next ID: 9

  Enums:
    MaintenanceIntervalValueValuesEnum: For more information about maintenance
      intervals, see Setting maintenance intervals.

  Fields:
    guestAccelerators: Specifies accelerator type and count.
    localSsds: Specifies amount of local ssd to reserve with each instance.
      The type of disk is local-ssd.
    locationHint: An opaque location hint used to place the allocation close
      to other resources. This field is for use by internal tools that use the
      public API.
    machineType: Specifies type of machine (name only) which has fixed number
      of vCPUs and fixed amount of memory. This also includes specifying
      custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY
      pattern.
    maintenanceFreezeDurationHours: Specifies the number of hours after
      reservation creation where instances using the reservation won't be
      scheduled for maintenance.
    maintenanceInterval: For more information about maintenance intervals, see
      Setting maintenance intervals.
    minCpuPlatform: Minimum cpu platform the reservation.
  """

  class MaintenanceIntervalValueValuesEnum(_messages.Enum):
    r"""For more information about maintenance intervals, see Setting
    maintenance intervals.

    Values:
      PERIODIC: VMs receive infrastructure and hypervisor updates on a
        periodic basis, minimizing the number of maintenance operations (live
        migrations or terminations) on an individual VM. This may mean a VM
        will take longer to receive an update than if it was configured for
        AS_NEEDED. Security updates will still be applied as soon as they are
        available.
    """
    PERIODIC = 0

  guestAccelerators = _messages.MessageField('AcceleratorConfig', 1, repeated=True)
  localSsds = _messages.MessageField('AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk', 2, repeated=True)
  locationHint = _messages.StringField(3)
  machineType = _messages.StringField(4)
  maintenanceFreezeDurationHours = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  maintenanceInterval = _messages.EnumField('MaintenanceIntervalValueValuesEnum', 6)
  minCpuPlatform = _messages.StringField(7)


class AllocationSpecificSKUReservation(_messages.Message):
  r"""This reservation type allows to pre allocate specific instance
  configuration. Next ID: 5

  Fields:
    assuredCount: [Output Only] Indicates how many instances are actually
      usable currently.
    count: Specifies the number of resources that are allocated.
    inUseCount: [Output Only] Indicates how many instances are in use.
    instanceProperties: The instance properties for the reservation.
  """

  assuredCount = _messages.IntegerField(1)
  count = _messages.IntegerField(2)
  inUseCount = _messages.IntegerField(3)
  instanceProperties = _messages.MessageField('AllocationSpecificSKUAllocationReservedInstanceProperties', 4)


class AttachedDisk(_messages.Message):
  r"""An instance-attached disk resource.

  Enums:
    InterfaceValueValuesEnum: Specifies the disk interface to use for
      attaching this disk, which is either SCSI or NVME. The default is SCSI.
      Persistent disks must always use SCSI and the request will fail if you
      attempt to attach a persistent disk in any other format than SCSI. Local
      SSDs can use either NVME or SCSI. For performance characteristics of
      SCSI over NVMe, see Local SSD performance.
    ModeValueValuesEnum: The mode in which to attach this disk, either
      READ_WRITE or READ_ONLY. If not specified, the default is to attach the
      disk in READ_WRITE mode.
    TypeValueValuesEnum: Specifies the type of the disk, either SCRATCH or
      PERSISTENT. If not specified, the default is PERSISTENT.

  Fields:
    autoDelete: Specifies whether the disk will be auto-deleted when the
      instance is deleted (but not when the disk is detached from the
      instance).
    boot: Indicates that this is a boot disk. The virtual machine will use the
      first partition of the disk for its root filesystem.
    deviceName: Specifies a unique device name of your choice that is
      reflected into the /dev/disk/by-id/google-* tree of a Linux operating
      system running within the instance. This name can be used to reference
      the device for mounting, resizing, and so on, from within the instance.
      If not specified, the server chooses a default device name to apply to
      this disk, in the form persistent-disk-x, where x is a number assigned
      by Google Compute Engine. This field is only applicable for persistent
      disks.
    diskEncryptionKey: Encrypts or decrypts a disk using a customer-supplied
      encryption key. If you are creating a new disk, this field encrypts the
      new disk using an encryption key that you provide. If you are attaching
      an existing disk that is already encrypted, this field decrypts the disk
      using the customer-supplied encryption key. If you encrypt a disk using
      a customer-supplied key, you must provide the same key again when you
      attempt to use this resource at a later time. For example, you must
      provide the key when you create a snapshot or an image from the disk or
      when you attach the disk to a virtual machine instance. If you do not
      provide an encryption key, then the disk will be encrypted using an
      automatically generated key and you do not need to provide a key to use
      the disk later. Instance templates do not store customer-supplied
      encryption keys, so you cannot use your own keys to encrypt disks in a
      managed instance group.
    diskSizeGb: The size of the disk in GB.
    guestOsFeatures: A list of features to enable on the guest operating
      system. Applicable only for bootable images. Read Enabling guest
      operating system features to see a list of available options.
    index: [Output Only] A zero-based index to this disk, where 0 is reserved
      for the boot disk. If you have many disks attached to an instance, each
      disk would have a unique index number.
    initializeParams: [Input Only] Specifies the parameters for a new disk
      that will be created alongside the new instance. Use initialization
      parameters to create boot disks or local SSDs attached to the new
      instance. This property is mutually exclusive with the source property;
      you can only define one or the other, but not both.
    interface: Specifies the disk interface to use for attaching this disk,
      which is either SCSI or NVME. The default is SCSI. Persistent disks must
      always use SCSI and the request will fail if you attempt to attach a
      persistent disk in any other format than SCSI. Local SSDs can use either
      NVME or SCSI. For performance characteristics of SCSI over NVMe, see
      Local SSD performance.
    kind: [Output Only] Type of the resource. Always compute#attachedDisk for
      attached disks.
    licenses: [Output Only] Any valid publicly visible licenses.
    locked: [Output Only] Whether to indicate the attached disk is locked. The
      locked disk is not allowed to be detached from the instance, or to be
      used as the source of the snapshot creation, and the image creation. The
      instance with at least one locked attached disk is not allow to be used
      as source of machine image creation, instant snapshot creation, and not
      allowed to be deleted with --keep-disk parameter set to true for locked
      disks.
    mode: The mode in which to attach this disk, either READ_WRITE or
      READ_ONLY. If not specified, the default is to attach the disk in
      READ_WRITE mode.
    shieldedInstanceInitialState: [Output Only] shielded vm initial state
      stored on disk
    source: Specifies a valid partial or full URL to an existing Persistent
      Disk resource. When creating a new instance, one of
      initializeParams.sourceImage or initializeParams.sourceSnapshot or
      disks.source is required except for local SSD. If desired, you can also
      attach existing non-root persistent disks using this property. This
      field is only applicable for persistent disks. Note that for
      InstanceTemplate, specify the disk name for zonal disk, and the URL for
      regional disk.
    type: Specifies the type of the disk, either SCRATCH or PERSISTENT. If not
      specified, the default is PERSISTENT.
    userLicenses: [Output Only] A list of user provided licenses. It
      represents a list of URLs to the license resource. Unlike regular
      licenses, user provided licenses can be modified after the disk is
      created.
  """

  class InterfaceValueValuesEnum(_messages.Enum):
    r"""Specifies the disk interface to use for attaching this disk, which is
    either SCSI or NVME. The default is SCSI. Persistent disks must always use
    SCSI and the request will fail if you attempt to attach a persistent disk
    in any other format than SCSI. Local SSDs can use either NVME or SCSI. For
    performance characteristics of SCSI over NVMe, see Local SSD performance.

    Values:
      NVME: <no description>
      SCSI: <no description>
    """
    NVME = 0
    SCSI = 1

  class ModeValueValuesEnum(_messages.Enum):
    r"""The mode in which to attach this disk, either READ_WRITE or READ_ONLY.
    If not specified, the default is to attach the disk in READ_WRITE mode.

    Values:
      READ_ONLY: Attaches this disk in read-only mode. Multiple virtual
        machines can use a disk in read-only mode at a time.
      READ_WRITE: *[Default]* Attaches this disk in read-write mode. Only one
        virtual machine at a time can be attached to a disk in read-write
        mode.
    """
    READ_ONLY = 0
    READ_WRITE = 1

  class TypeValueValuesEnum(_messages.Enum):
    r"""Specifies the type of the disk, either SCRATCH or PERSISTENT. If not
    specified, the default is PERSISTENT.

    Values:
      PERSISTENT: <no description>
      SCRATCH: <no description>
    """
    PERSISTENT = 0
    SCRATCH = 1

  autoDelete = _messages.BooleanField(1)
  boot = _messages.BooleanField(2)
  deviceName = _messages.StringField(3)
  diskEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 4)
  diskSizeGb = _messages.IntegerField(5)
  guestOsFeatures = _messages.MessageField('GuestOsFeature', 6, repeated=True)
  index = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  initializeParams = _messages.MessageField('AttachedDiskInitializeParams', 8)
  interface = _messages.EnumField('InterfaceValueValuesEnum', 9)
  kind = _messages.StringField(10, default='compute#attachedDisk')
  licenses = _messages.StringField(11, repeated=True)
  locked = _messages.BooleanField(12)
  mode = _messages.EnumField('ModeValueValuesEnum', 13)
  shieldedInstanceInitialState = _messages.MessageField('InitialStateConfig', 14)
  source = _messages.StringField(15)
  type = _messages.EnumField('TypeValueValuesEnum', 16)
  userLicenses = _messages.StringField(17, repeated=True)


class AttachedDiskInitializeParams(_messages.Message):
  r"""[Input Only] Specifies the parameters for a new disk that will be
  created alongside the new instance. Use initialization parameters to create
  boot disks or local SSDs attached to the new instance. This property is
  mutually exclusive with the source property; you can only define one or the
  other, but not both.

  Enums:
    OnUpdateActionValueValuesEnum: Specifies which action to take on instance
      update with this disk. Default is to use the existing disk.

  Messages:
    LabelsValue: Labels to apply to this disk. These can be later modified by
      the disks.setLabels method. This field is only applicable for persistent
      disks.

  Fields:
    description: An optional description. Provide this property when creating
      the disk.
    diskName: Specifies the disk name. If not specified, the default is to use
      the name of the instance. If a disk with the same name already exists in
      the given region, the existing disk is attached to the new instance and
      the new disk is not created.
    diskSizeGb: Specifies the size of the disk in base-2 GB. The size must be
      at least 10 GB. If you specify a sourceImage, which is required for boot
      disks, the default size is the size of the sourceImage. If you do not
      specify a sourceImage, the default disk size is 500 GB.
    diskType: Specifies the disk type to use to create the instance. If not
      specified, the default is pd-standard, specified using the full URL. For
      example:
      https://www.googleapis.com/compute/v1/projects/project/zones/zone
      /diskTypes/pd-standard For a full list of acceptable values, see
      Persistent disk types. If you define this field, you can provide either
      the full or partial URL. For example, the following are valid values: -
      https://www.googleapis.com/compute/v1/projects/project/zones/zone
      /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType -
      zones/zone/diskTypes/diskType Note that for InstanceTemplate, this is
      the name of the disk type, not URL.
    guestOsFeatures: A list of features to enable on the guest operating
      system. Applicable only for bootable images. Read Enabling guest
      operating system features to see a list of available options. Guest OS
      features are applied by merging initializeParams.guestOsFeatures and
      disks.guestOsFeatures
    labels: Labels to apply to this disk. These can be later modified by the
      disks.setLabels method. This field is only applicable for persistent
      disks.
    licenses: A list of publicly visible licenses. Reserved for Google's use.
    multiWriter: Indicates whether or not the disk can be read/write attached
      to more than one instance.
    onUpdateAction: Specifies which action to take on instance update with
      this disk. Default is to use the existing disk.
    provisionedIops: Indicates how many IOPS to provision for the disk. This
      sets the number of I/O operations per second that the disk can handle.
      Values must be between 10,000 and 120,000. For more details, see the
      Extreme persistent disk documentation.
    resourcePolicies: Resource policies applied to this disk for automatic
      snapshot creations. Specified using the full or partial URL. For
      instance template, specify only the resource policy name.
    sourceImage: The source image to create this disk. When creating a new
      instance, one of initializeParams.sourceImage or
      initializeParams.sourceSnapshot or disks.source is required except for
      local SSD. To create a disk with one of the public operating system
      images, specify the image by its family name. For example, specify
      family/debian-9 to use the latest Debian 9 image: projects/debian-
      cloud/global/images/family/debian-9 Alternatively, use a specific
      version of a public operating system image: projects/debian-
      cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a
      custom image that you created, specify the image name in the following
      format: global/images/my-custom-image You can also specify a custom
      image by its image family, which returns the latest version of the image
      in that family. Replace the image name with family/family-name:
      global/images/family/my-image-family If the source image is deleted
      later, this field will not be set.
    sourceImageEncryptionKey: The customer-supplied encryption key of the
      source image. Required if the source image is protected by a customer-
      supplied encryption key. Instance templates do not store customer-
      supplied encryption keys, so you cannot create disks for instances in a
      managed instance group if the source images are encrypted with your own
      keys.
    sourceSnapshot: The source snapshot to create this disk. When creating a
      new instance, one of initializeParams.sourceSnapshot or
      initializeParams.sourceImage or disks.source is required except for
      local SSD. To create a disk with a snapshot that you created, specify
      the snapshot name in the following format: global/snapshots/my-backup If
      the source snapshot is deleted later, this field will not be set.
    sourceSnapshotEncryptionKey: The customer-supplied encryption key of the
      source snapshot.
  """

  class OnUpdateActionValueValuesEnum(_messages.Enum):
    r"""Specifies which action to take on instance update with this disk.
    Default is to use the existing disk.

    Values:
      RECREATE_DISK: Always recreate the disk.
      RECREATE_DISK_IF_SOURCE_CHANGED: Recreate the disk if source (image,
        snapshot) of this disk is different from source of existing disk.
      USE_EXISTING_DISK: Use the existing disk, this is the default behaviour.
    """
    RECREATE_DISK = 0
    RECREATE_DISK_IF_SOURCE_CHANGED = 1
    USE_EXISTING_DISK = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels to apply to this disk. These can be later modified by the
    disks.setLabels method. This field is only applicable for persistent
    disks.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  description = _messages.StringField(1)
  diskName = _messages.StringField(2)
  diskSizeGb = _messages.IntegerField(3)
  diskType = _messages.StringField(4)
  guestOsFeatures = _messages.MessageField('GuestOsFeature', 5, repeated=True)
  labels = _messages.MessageField('LabelsValue', 6)
  licenses = _messages.StringField(7, repeated=True)
  multiWriter = _messages.BooleanField(8)
  onUpdateAction = _messages.EnumField('OnUpdateActionValueValuesEnum', 9)
  provisionedIops = _messages.IntegerField(10)
  resourcePolicies = _messages.StringField(11, repeated=True)
  sourceImage = _messages.StringField(12)
  sourceImageEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 13)
  sourceSnapshot = _messages.StringField(14)
  sourceSnapshotEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 15)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts jose@example.com from DATA_READ logging, and
  aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    exemptedMembers: This is deprecated and has no effect. Do not use.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  exemptedMembers = _messages.StringField(2, repeated=True)
  service = _messages.StringField(3)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    ignoreChildExemptions: This is deprecated and has no effect. Do not use.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_READ: Data reads. Example: CloudSQL Users list
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
    """
    ADMIN_READ = 0
    DATA_READ = 1
    DATA_WRITE = 2
    LOG_TYPE_UNSPECIFIED = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  ignoreChildExemptions = _messages.BooleanField(2)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 3)


class AuthorizationLoggingOptions(_messages.Message):
  r"""This is deprecated and has no effect. Do not use.

  Enums:
    PermissionTypeValueValuesEnum: This is deprecated and has no effect. Do
      not use.

  Fields:
    permissionType: This is deprecated and has no effect. Do not use.
  """

  class PermissionTypeValueValuesEnum(_messages.Enum):
    r"""This is deprecated and has no effect. Do not use.

    Values:
      ADMIN_READ: This is deprecated and has no effect. Do not use.
      ADMIN_WRITE: This is deprecated and has no effect. Do not use.
      DATA_READ: This is deprecated and has no effect. Do not use.
      DATA_WRITE: This is deprecated and has no effect. Do not use.
      PERMISSION_TYPE_UNSPECIFIED: This is deprecated and has no effect. Do
        not use.
    """
    ADMIN_READ = 0
    ADMIN_WRITE = 1
    DATA_READ = 2
    DATA_WRITE = 3
    PERMISSION_TYPE_UNSPECIFIED = 4

  permissionType = _messages.EnumField('PermissionTypeValueValuesEnum', 1)


class Autoscaler(_messages.Message):
  r"""Represents an Autoscaler resource. Google Compute Engine has two
  Autoscaler resources: *
  [Zonal](/compute/docs/reference/rest/beta/autoscalers) *
  [Regional](/compute/docs/reference/rest/beta/regionAutoscalers) Use
  autoscalers to automatically add or delete instances from a managed instance
  group according to your defined autoscaling policy. For more information,
  read Autoscaling Groups of Instances. For zonal managed instance groups
  resource, use the autoscaler resource. For regional managed instance groups,
  use the regionAutoscalers resource.

  Enums:
    StatusValueValuesEnum: [Output Only] The status of the autoscaler
      configuration. Current set of possible values: - PENDING: Autoscaler
      backend hasn't read new/updated configuration. - DELETING: Configuration
      is being deleted. - ACTIVE: Configuration is acknowledged to be
      effective. Some warnings might be present in the statusDetails field. -
      ERROR: Configuration has errors. Actionable for users. Details are
      present in the statusDetails field. New values might be added in the
      future.

  Messages:
    ScalingScheduleStatusValue: [Output Only] Status information of existing
      scaling schedules.

  Fields:
    autoscalingPolicy: The configuration parameters for the autoscaling
      algorithm. You can define one or more signals for an autoscaler:
      cpuUtilization, customMetricUtilizations, and loadBalancingUtilization.
      If none of these are specified, the default will be to autoscale based
      on cpuUtilization to 0.6 or 60%.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#autoscaler for
      autoscalers.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    recommendedSize: [Output Only] Target recommended MIG size (number of
      instances) computed by autoscaler. Autoscaler calculates the recommended
      MIG size even when the autoscaling policy mode is different from ON.
      This field is empty when autoscaler is not connected to an existing
      managed instance group or autoscaler did not generate its prediction.
    region: [Output Only] URL of the region where the instance group resides
      (for autoscalers living in regional scope).
    scalingScheduleStatus: [Output Only] Status information of existing
      scaling schedules.
    selfLink: [Output Only] Server-defined URL for the resource.
    status: [Output Only] The status of the autoscaler configuration. Current
      set of possible values: - PENDING: Autoscaler backend hasn't read
      new/updated configuration. - DELETING: Configuration is being deleted. -
      ACTIVE: Configuration is acknowledged to be effective. Some warnings
      might be present in the statusDetails field. - ERROR: Configuration has
      errors. Actionable for users. Details are present in the statusDetails
      field. New values might be added in the future.
    statusDetails: [Output Only] Human-readable details about the current
      state of the autoscaler. Read the documentation for Commonly returned
      status messages for examples of status messages you might encounter.
    target: URL of the managed instance group that this autoscaler will scale.
      This field is required when creating an autoscaler.
    zone: [Output Only] URL of the zone where the instance group resides (for
      autoscalers living in zonal scope).
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""[Output Only] The status of the autoscaler configuration. Current set
    of possible values: - PENDING: Autoscaler backend hasn't read new/updated
    configuration. - DELETING: Configuration is being deleted. - ACTIVE:
    Configuration is acknowledged to be effective. Some warnings might be
    present in the statusDetails field. - ERROR: Configuration has errors.
    Actionable for users. Details are present in the statusDetails field. New
    values might be added in the future.

    Values:
      ACTIVE: Configuration is acknowledged to be effective
      DELETING: Configuration is being deleted
      ERROR: Configuration has errors. Actionable for users.
      PENDING: Autoscaler backend hasn't read new/updated configuration
    """
    ACTIVE = 0
    DELETING = 1
    ERROR = 2
    PENDING = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ScalingScheduleStatusValue(_messages.Message):
    r"""[Output Only] Status information of existing scaling schedules.

    Messages:
      AdditionalProperty: An additional property for a
        ScalingScheduleStatusValue object.

    Fields:
      additionalProperties: Additional properties of type
        ScalingScheduleStatusValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ScalingScheduleStatusValue object.

      Fields:
        key: Name of the additional property.
        value: A ScalingScheduleStatus attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ScalingScheduleStatus', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  autoscalingPolicy = _messages.MessageField('AutoscalingPolicy', 1)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default='compute#autoscaler')
  name = _messages.StringField(6)
  recommendedSize = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  region = _messages.StringField(8)
  scalingScheduleStatus = _messages.MessageField('ScalingScheduleStatusValue', 9)
  selfLink = _messages.StringField(10)
  status = _messages.EnumField('StatusValueValuesEnum', 11)
  statusDetails = _messages.MessageField('AutoscalerStatusDetails', 12, repeated=True)
  target = _messages.StringField(13)
  zone = _messages.StringField(14)


class AutoscalerAggregatedList(_messages.Message):
  r"""A AutoscalerAggregatedList object.

  Messages:
    ItemsValue: A list of AutoscalersScopedList resources.
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of AutoscalersScopedList resources.
    kind: [Output Only] Type of resource. Always
      compute#autoscalerAggregatedList for aggregated lists of autoscalers.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    unreachables: [Output Only] Unreachable resources. end_interface:
      MixerListResponseWithEtagBuilder
    warning: [Output Only] Informational warning message.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    r"""A list of AutoscalersScopedList resources.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of autoscalers.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A AutoscalersScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('AutoscalersScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: Warning about failed cleanup of transient changes made
          by a failed operation.
        DEPRECATED_RESOURCE_USED: A link to a deprecated resource was created.
        DEPRECATED_TYPE_USED: When deploying and at least one of the resources
          has a type marked as deprecated
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: The user created a boot disk that is
          larger than image size.
        EXPERIMENTAL_TYPE_USED: When deploying and at least one of the
          resources has a type marked as experimental
        EXTERNAL_API_WARNING: Warning that is present in an external api call
        FIELD_VALUE_OVERRIDEN: Warning that value of a field has been
          overridden. Deprecated unused field.
        INJECTED_KERNELS_DEPRECATED: The operation involved use of an injected
          kernel, which is deprecated.
        LARGE_DEPLOYMENT_WARNING: When deploying a deployment with a
          exceedingly large number of resources
        MISSING_TYPE_DEPENDENCY: A resource depends on a missing type
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: The route's nextHopIp address is not
          assigned to an instance on the network.
        NEXT_HOP_CANNOT_IP_FORWARD: The route's next hop instance cannot ip
          forward.
        NEXT_HOP_INSTANCE_NOT_FOUND: The route's nextHopInstance URL refers to
          an instance that does not exist.
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: The route's nextHopInstance URL
          refers to an instance that is not on the same network as the route.
        NEXT_HOP_NOT_RUNNING: The route's next hop instance does not have a
          status of RUNNING.
        NOT_CRITICAL_ERROR: Error which is not critical. We decided to
          continue the process despite the mentioned error.
        NO_RESULTS_ON_PAGE: No results are present on a particular list page.
        PARTIAL_SUCCESS: Success is reported, but some results may be missing
          due to errors
        REQUIRED_TOS_AGREEMENT: The user attempted to use a resource that
          requires a TOS they have not accepted.
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: Warning that a resource is
          in use.
        RESOURCE_NOT_DELETED: One or more of the resources set to auto-delete
          could not be deleted because they were in use.
        SCHEMA_VALIDATION_IGNORED: When a resource schema validation is
          ignored.
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: Instance template used in instance
          group manager is valid as such, but its application does not make a
          lot of sense, because it allows only single instance in instance
          group.
        UNDECLARED_PROPERTIES: When undeclared properties in the schema are
          present
        UNREACHABLE: A given scope cannot be reached.
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      LARGE_DEPLOYMENT_WARNING = 8
      MISSING_TYPE_DEPENDENCY = 9
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 10
      NEXT_HOP_CANNOT_IP_FORWARD = 11
      NEXT_HOP_INSTANCE_NOT_FOUND = 12
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 13
      NEXT_HOP_NOT_RUNNING = 14
      NOT_CRITICAL_ERROR = 15
      NO_RESULTS_ON_PAGE = 16
      PARTIAL_SUCCESS = 17
      REQUIRED_TOS_AGREEMENT = 18
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 19
      RESOURCE_NOT_DELETED = 20
      SCHEMA_VALIDATION_IGNORED = 21
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 22
      UNDECLARED_PROPERTIES = 23
      UNREACHABLE = 24

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default='compute#autoscalerAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  unreachables = _messages.StringField(6, repeated=True)
  warning = _messages.MessageField('WarningValue', 7)


class AutoscalerList(_messages.Message):
  r"""Contains a list of Autoscaler resources.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of Autoscaler resources.
    kind: [Output Only] Type of resource. Always compute#autoscalerList for
      lists of autoscalers.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: Warning about failed cleanup of transient changes made
          by a failed operation.
        DEPRECATED_RESOURCE_USED: A link to a deprecated resource was created.
        DEPRECATED_TYPE_USED: When deploying and at least one of the resources
          has a type marked as deprecated
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: The user created a boot disk that is
          larger than image size.
        EXPERIMENTAL_TYPE_USED: When deploying and at least one of the
          resources has a type marked as experimental
        EXTERNAL_API_WARNING: Warning that is present in an external api call
        FIELD_VALUE_OVERRIDEN: Warning that value of a field has been
          overridden. Deprecated unused field.
        INJECTED_KERNELS_DEPRECATED: The operation involved use of an injected
          kernel, which is deprecated.
        LARGE_DEPLOYMENT_WARNING: When deploying a deployment with a
          exceedingly large number of resources
        MISSING_TYPE_DEPENDENCY: A resource depends on a missing type
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: The route's nextHopIp address is not
          assigned to an instance on the network.
        NEXT_HOP_CANNOT_IP_FORWARD: The route's next hop instance cannot ip
          forward.
        NEXT_HOP_INSTANCE_NOT_FOUND: The route's nextHopInstance URL refers to
          an instance that does not exist.
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: The route's nextHopInstance URL
          refers to an instance that is not on the same network as the route.
        NEXT_HOP_NOT_RUNNING: The route's next hop instance does not have a
          status of RUNNING.
        NOT_CRITICAL_ERROR: Error which is not critical. We decided to
          continue the process despite the mentioned error.
        NO_RESULTS_ON_PAGE: No results are present on a particular list page.
        PARTIAL_SUCCESS: Success is reported, but some results may be missing
          due to errors
        REQUIRED_TOS_AGREEMENT: The user attempted to use a resource that
          requires a TOS they have not accepted.
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: Warning that a resource is
          in use.
        RESOURCE_NOT_DELETED: One or more of the resources set to auto-delete
          could not be deleted because they were in use.
        SCHEMA_VALIDATION_IGNORED: When a resource schema validation is
          ignored.
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: Instance template used in instance
          group manager is valid as such, but its application does not make a
          lot of sense, because it allows only single instance in instance
          group.
        UNDECLARED_PROPERTIES: When undeclared properties in the schema are
          present
        UNREACHABLE: A given scope cannot be reached.
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      LARGE_DEPLOYMENT_WARNING = 8
      MISSING_TYPE_DEPENDENCY = 9
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 10
      NEXT_HOP_CANNOT_IP_FORWARD = 11
      NEXT_HOP_INSTANCE_NOT_FOUND = 12
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 13
      NEXT_HOP_NOT_RUNNING = 14
      NOT_CRITICAL_ERROR = 15
      NO_RESULTS_ON_PAGE = 16
      PARTIAL_SUCCESS = 17
      REQUIRED_TOS_AGREEMENT = 18
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 19
      RESOURCE_NOT_DELETED = 20
      SCHEMA_VALIDATION_IGNORED = 21
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 22
      UNDECLARED_PROPERTIES = 23
      UNREACHABLE = 24

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('Autoscaler', 2, repeated=True)
  kind = _messages.StringField(3, default='compute#autoscalerList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class AutoscalerStatusDetails(_messages.Message):
  r"""A AutoscalerStatusDetails object.

  Enums:
    TypeValueValuesEnum: The type of error, warning, or notice returned.
      Current set of possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All
      instances in the instance group are unhealthy (not in RUNNING state). -
      BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service
      attached to the instance group. - CAPPED_AT_MAX_NUM_REPLICAS (WARNING):
      Autoscaler recommends a size greater than maxNumReplicas. -
      CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric
      samples are not exported often enough to be a credible base for
      autoscaling. - CUSTOM_METRIC_INVALID (ERROR): The custom metric that was
      specified does not exist or does not have the necessary labels. -
      MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to maxNumReplicas.
      This means the autoscaler cannot add or remove instances from the
      instance group. - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The
      autoscaler did not receive any data from the custom metric configured
      for autoscaling. - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The
      autoscaler is configured to scale based on a load balancing signal but
      the instance group has not received any requests from the load balancer.
      - MODE_OFF (WARNING): Autoscaling is turned off. The number of instances
      in the group won't change automatically. The autoscaling configuration
      is preserved. - MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale
      only out" mode. The autoscaler can add instances but not remove any. -
      MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot be
      autoscaled because it has more than one backend service attached to it.
      - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota for
      the necessary resources, such as CPU or number of instances. -
      REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional autoscalers:
      there is a resource stockout in the chosen region. -
      SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled does not
      exist. - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR):
      Autoscaling does not work with an HTTP/S load balancer that has been
      configured for maxRate. - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal
      autoscalers: there is a resource stockout in the chosen zone. For
      regional autoscalers: in at least one of the zones you're using there is
      a resource stockout. New values might be added in the future. Some of
      the values might not be available in all API versions.

  Fields:
    message: The status message.
    type: The type of error, warning, or notice returned. Current set of
      possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All instances in
      the instance group are unhealthy (not in RUNNING state). -
      BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service
      attached to the instance group. - CAPPED_AT_MAX_NUM_REPLICAS (WARNING):
      Autoscaler recommends a size greater than maxNumReplicas. -
      CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric
      samples are not exported often enough to be a credible base for
      autoscaling. - CUSTOM_METRIC_INVALID (ERROR): The custom metric that was
      specified does not exist or does not have the necessary labels. -
      MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to maxNumReplicas.
      This means the autoscaler cannot add or remove instances from the
      instance group. - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The
      autoscaler did not receive any data from the custom metric configured
      for autoscaling. - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The
      autoscaler is configured to scale based on a load balancing signal but
      the instance group has not received any requests from the load balancer.
      - MODE_OFF (WARNING): Autoscaling is turned off. The number of instances
      in the group won't change automatically. The autoscaling configuration
      is preserved. - MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale
      only out" mode. The autoscaler can add instances but not remove any. -
      MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot be
      autoscaled because it has more than one backend service attached to it.
      - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota for
      the necessary resources, such as CPU or number of instances. -
      REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional autoscalers:
      there is a resource stockout in the chosen region. -
      SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled does not
      exist. - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR):
      Autoscaling does not work with an HTTP/S load balancer that has been
      configured for maxRate. - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal
      autoscalers: there is a resource stockout in the chosen zone. For
      regional autoscalers: in at least one of the zones you're using there is
      a resource stockout. New values might be added in the future. Some of
      the values might not be available in all API versions.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of error, warning, or notice returned. Current set of
    possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All instances in the
    instance group are unhealthy (not in RUNNING state). -
    BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service
    attached to the instance group. - CAPPED_AT_MAX_NUM_REPLICAS (WARNING):
    Autoscaler recommends a size greater than maxNumReplicas. -
    CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric samples
    are not exported often enough to be a credible base for autoscaling. -
    CUSTOM_METRIC_INVALID (ERROR): The custom metric that was specified does
    not exist or does not have the necessary labels. - MIN_EQUALS_MAX
    (WARNING): The minNumReplicas is equal to maxNumReplicas. This means the
    autoscaler cannot add or remove instances from the instance group. -
    MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not
    receive any data from the custom metric configured for autoscaling. -
    MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is configured
    to scale based on a load balancing signal but the instance group has not
    received any requests from the load balancer. - MODE_OFF (WARNING):
    Autoscaling is turned off. The number of instances in the group won't
    change automatically. The autoscaling configuration is preserved. -
    MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale only out" mode.
    The autoscaler can add instances but not remove any. -
    MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot be
    autoscaled because it has more than one backend service attached to it. -
    NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota for the
    necessary resources, such as CPU or number of instances. -
    REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional autoscalers:
    there is a resource stockout in the chosen region. -
    SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled does not
    exist. - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR):
    Autoscaling does not work with an HTTP/S load balancer that has been
    configured for maxRate. - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal
    autoscalers: there is a resource stockout in the chosen zone. For regional
    autoscalers: in at least one of the zones you're using there is a resource
    stockout. New values might be added in the future. Some of the values
    might not be available in all API versions.

    Values:
      ALL_INSTANCES_UNHEALTHY: All instances in the instance group are
        unhealthy (not in RUNNING state).
      BACKEND_SERVICE_DOES_NOT_EXIST: There is no backend service attached to
        the instance group.
      CAPPED_AT_MAX_NUM_REPLICAS: Autoscaler recommends a size greater than
        maxNumReplicas.
      CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE: The custom metric samples are not
        exported often enough to be a credible base for autoscaling.
      CUSTOM_METRIC_INVALID: The custom metric that was specified does not
        exist or does not have the necessary labels.
      MIN_EQUALS_MAX: The minNumReplicas is equal to maxNumReplicas. This
        means the autoscaler cannot add or remove instances from the instance
        group.
      MISSING_CUSTOM_METRIC_DATA_POINTS: The autoscaler did not receive any
        data from the custom metric configured for autoscaling.
      MISSING_LOAD_BALANCING_DATA_POINTS: The autoscaler is configured to
        scale based on a load balancing signal but the instance group has not
        received any requests from the load balancer.
      MODE_OFF: Autoscaling is turned off. The number of instances in the
        group won't change automatically. The autoscaling configuration is
        preserved.
      MODE_ONLY_SCALE_OUT: Autoscaling is in the "Autoscale only scale out"
        mode. Instances in the group will be only added.
      MODE_ONLY_UP: Autoscaling is in the "Autoscale only out" mode. Instances
        in the group will be only added.
      MORE_THAN_ONE_BACKEND_SERVICE: The instance group cannot be autoscaled
        because it has more than one backend service attached to it.
      NOT_ENOUGH_QUOTA_AVAILABLE: There is insufficient quota for the
        necessary resources, such as CPU or number of instances.
      REGION_RESOURCE_STOCKOUT: Showed only for regional autoscalers: there is
        a resource stockout in the chosen region.
      SCALING_TARGET_DOES_NOT_EXIST: The target to be scaled does not exist.
      SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX: For some scaling
        schedules minRequiredReplicas is greater than maxNumReplicas.
        Autoscaler always recommends at most maxNumReplicas instances.
      SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN: For some scaling schedules
        minRequiredReplicas is less than minNumReplicas. Autoscaler always
        recommends at least minNumReplicas instances.
      UNKNOWN: <no description>
      UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION: Autoscaling does not
        work with an HTTP/S load balancer that has been configured for
        maxRate.
      ZONE_RESOURCE_STOCKOUT: For zonal autoscalers: there is a resource
        stockout in the chosen zone. For regional autoscalers: in at least one
        of the zones you're using there is a resource stockout.
    """
    ALL_INSTANCES_UNHEALTHY = 0
    BACKEND_SERVICE_DOES_NOT_EXIST = 1
    CAPPED_AT_MAX_NUM_REPLICAS = 2
    CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE = 3
    CUSTOM_METRIC_INVALID = 4
    MIN_EQUALS_MAX = 5
    MISSING_CUSTOM_METRIC_DATA_POINTS = 6
    MISSING_LOAD_BALANCING_DATA_POINTS = 7
    MODE_OFF = 8
    MODE_ONLY_SCALE_OUT = 9
    MODE_ONLY_UP = 10
    MORE_THAN_ONE_BACKEND_SERVICE = 11
    NOT_ENOUGH_QUOTA_AVAILABLE = 12
    REGION_RESOURCE_STOCKOUT = 13
    SCALING_TARGET_DOES_NOT_EXIST = 14
    SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX = 15
    SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN = 16
    UNKNOWN = 17
    UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION = 18
    ZONE_RESOURCE_STOCKOUT = 19

  message = _messages.StringField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class AutoscalersScopedList(_messages.Message):
  r"""A AutoscalersScopedList object.

  Messages:
    WarningValue: [Output Only] Informational warning which replaces the list
      of autoscalers when the list is empty.

  Fields:
    autoscalers: [Output Only] A list of autoscalers contained in this scope.
    warning: [Output Only] Informational warning which replaces the list of
      autoscalers when the list is empty.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning which replaces the list of
    autoscalers when the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: Warning about failed cleanup of transient changes made
          by a failed operation.
        DEPRECATED_RESOURCE_USED: A link to a deprecated resource was created.
        DEPRECATED_TYPE_USED: When deploying and at least one of the resources
          has a type marked as deprecated
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: The user created a boot disk that is
          larger than image size.
        EXPERIMENTAL_TYPE_USED: When deploying and at least one of the
          resources has a type marked as experimental
        EXTERNAL_API_WARNING: Warning that is present in an external api call
        FIELD_VALUE_OVERRIDEN: Warning that value of a field has been
          overridden. Deprecated unused field.
        INJECTED_KERNELS_DEPRECATED: The operation involved use of an injected
          kernel, which is deprecated.
        LARGE_DEPLOYMENT_WARNING: When deploying a deployment with a
          exceedingly large number of resources
        MISSING_TYPE_DEPENDENCY: A resource depends on a missing type
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: The route's nextHopIp address is not
          assigned to an instance on the network.
        NEXT_HOP_CANNOT_IP_FORWARD: The route's next hop instance cannot ip
          forward.
        NEXT_HOP_INSTANCE_NOT_FOUND: The route's nextHopInstance URL refers to
          an instance that does not exist.
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: The route's nextHopInstance URL
          refers to an instance that is not on the same network as the route.
        NEXT_HOP_NOT_RUNNING: The route's next hop instance does not have a
          status of RUNNING.
        NOT_CRITICAL_ERROR: Error which is not critical. We decided to
          continue the process despite the mentioned error.
        NO_RESULTS_ON_PAGE: No results are present on a particular list page.
        PARTIAL_SUCCESS: Success is reported, but some results may be missing
          due to errors
        REQUIRED_TOS_AGREEMENT: The user attempted to use a resource that
          requires a TOS they have not accepted.
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: Warning that a resource is
          in use.
        RESOURCE_NOT_DELETED: One or more of the resources set to auto-delete
          could not be deleted because they were in use.
        SCHEMA_VALIDATION_IGNORED: When a resource schema validation is
          ignored.
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: Instance template used in instance
          group manager is valid as such, but its application does not make a
          lot of sense, because it allows only single instance in instance
          group.
        UNDECLARED_PROPERTIES: When undeclared properties in the schema are
          present
        UNREACHABLE: A given scope cannot be reached.
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      LARGE_DEPLOYMENT_WARNING = 8
      MISSING_TYPE_DEPENDENCY = 9
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 10
      NEXT_HOP_CANNOT_IP_FORWARD = 11
      NEXT_HOP_INSTANCE_NOT_FOUND = 12
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 13
      NEXT_HOP_NOT_RUNNING = 14
      NOT_CRITICAL_ERROR = 15
      NO_RESULTS_ON_PAGE = 16
      PARTIAL_SUCCESS = 17
      REQUIRED_TOS_AGREEMENT = 18
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 19
      RESOURCE_NOT_DELETED = 20
      SCHEMA_VALIDATION_IGNORED = 21
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 22
      UNDECLARED_PROPERTIES = 23
      UNREACHABLE = 24

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  autoscalers = _messages.MessageField('Autoscaler', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class AutoscalingPolicy(_messages.Message):
  r"""Cloud Autoscaler policy.

  Enums:
    ModeValueValuesEnum: Defines operating mode for this policy.

  Messages:
    ScalingSchedulesValue: Scaling schedules defined for an autoscaler.
      Multiple schedules can be set on an autoscaler, and they can overlap.
      During overlapping periods the greatest min_required_replicas of all
      scaling schedules is applied. Up to 128 scaling schedules are allowed.

  Fields:
    coolDownPeriodSec: The number of seconds that the autoscaler waits before
      it starts collecting information from a new instance. This prevents the
      autoscaler from collecting information when the instance is
      initializing, during which the collected usage would not be reliable.
      The default time autoscaler waits is 60 seconds. Virtual machine
      initialization times might vary because of numerous factors. We
      recommend that you test how long an instance may take to initialize. To
      do this, create an instance and time the startup process.
    cpuUtilization: Defines the CPU utilization policy that allows the
      autoscaler to scale based on the average CPU utilization of a managed
      instance group.
    customMetricUtilizations: Configuration parameters of autoscaling based on
      a custom metric.
    loadBalancingUtilization: Configuration parameters of autoscaling based on
      load balancer.
    maxNumReplicas: The maximum number of instances that the autoscaler can
      scale out to. This is required when creating or updating an autoscaler.
      The maximum number of replicas must not be lower than minimal number of
      replicas.
    minNumReplicas: The minimum number of replicas that the autoscaler can
      scale in to. This cannot be less than 0. If not provided, autoscaler
      chooses a default value depending on maximum number of instances
      allowed.
    mode: Defines operating mode for this policy.
    scaleDownControl: A AutoscalingPolicyScaleDownControl attribute.
    scaleInControl: A AutoscalingPolicyScaleInControl attribute.
    scalingSchedules: Scaling schedules defined for an autoscaler. Multiple
      schedules can be set on an autoscaler, and they can overlap. During
      overlapping periods the greatest min_required_replicas of all scaling
      schedules is applied. Up to 128 scaling schedules are allowed.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""Defines operating mode for this policy.

    Values:
      OFF: Do not automatically scale the MIG in or out. The recommended_size
        field contains the size of MIG that would be set if the actuation mode
        was enabled.
      ON: Automatically scale the MIG in and out according to the policy.
      ONLY_SCALE_OUT: Automatically create VMs according to the policy, but do
        not scale the MIG in.
      ONLY_UP: Automatically create VMs according to the policy, but do not
        scale the MIG in.
    """
    OFF = 0
    ON = 1
    ONLY_SCALE_OUT = 2
    ONLY_UP = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ScalingSchedulesValue(_messages.Message):
    r"""Scaling schedules defined for an autoscaler. Multiple schedules can be
    set on an autoscaler, and they can overlap. During overlapping periods the
    greatest min_required_replicas of all scaling schedules is applied. Up to
    128 scaling schedules are allowed.

    Messages:
      AdditionalProperty: An additional property for a ScalingSchedulesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        ScalingSchedulesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ScalingSchedulesValue object.

      Fields:
        key: Name of the additional property.
        value: A AutoscalingPolicyScalingSchedule attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('AutoscalingPolicyScalingSchedule', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  coolDownPeriodSec = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  cpuUtilization = _messages.MessageField('AutoscalingPolicyCpuUtilization', 2)
  customMetricUtilizations = _messages.MessageField('AutoscalingPolicyCustomMetricUtilization', 3, repeated=True)
  loadBalancingUtilization = _messages.MessageField('AutoscalingPolicyLoadBalancingUtilization', 4)
  maxNumReplicas = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  minNumReplicas = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  mode = _messages.EnumField('ModeValueValuesEnum', 7)
  scaleDownControl = _messages.MessageField('AutoscalingPolicyScaleDownControl', 8)
  scaleInControl = _messages.MessageField('AutoscalingPolicyScaleInControl', 9)
  scalingSchedules = _messages.MessageField('ScalingSchedulesValue', 10)


class AutoscalingPolicyCpuUtilization(_messages.Message):
  r"""CPU utilization policy.

  Enums:
    PredictiveMethodValueValuesEnum: Indicates whether predictive autoscaling
      based on CPU metric is enabled. Valid values are: * NONE (default). No
      predictive method is used. The autoscaler scales the group to meet
      current demand based on real-time metrics. * OPTIMIZE_AVAILABILITY.
      Predictive autoscaling improves availability by monitoring daily and
      weekly load patterns and scaling out ahead of anticipated demand.

  Fields:
    predictiveMethod: Indicates whether predictive autoscaling based on CPU
      metric is enabled. Valid values are: * NONE (default). No predictive
      method is used. The autoscaler scales the group to meet current demand
      based on real-time metrics. * OPTIMIZE_AVAILABILITY. Predictive
      autoscaling improves availability by monitoring daily and weekly load
      patterns and scaling out ahead of anticipated demand.
    utilizationTarget: The target CPU utilization that the autoscaler
      maintains. Must be a float value in the range (0, 1]. If not specified,
      the default is 0.6. If the CPU level is below the target utilization,
      the autoscaler scales in the number of instances until it reaches the
      minimum number of instances you specified or until the average CPU of
      your instances reaches the target utilization. If the average CPU is
      above the target utilization, the autoscaler scales out until it reaches
      the maximum number of instances you specified or until the average
      utilization reaches the target utilization.
  """

  class PredictiveMethodValueValuesEnum(_messages.Enum):
    r"""Indicates whether predictive autoscaling based on CPU metric is
    enabled. Valid values are: * NONE (default). No predictive method is used.
    The autoscaler scales the group to meet current demand based on real-time
    metrics. * OPTIMIZE_AVAILABILITY. Predictive autoscaling improves
    availability by monitoring daily and weekly load patterns and scaling out
    ahead of anticipated demand.

    Values:
      NONE: No predictive method is used. The autoscaler scales the group to
        meet current demand based on real-time metrics
      OPTIMIZE_AVAILABILITY: Predictive autoscaling improves availability by
        monitoring daily and weekly load patterns and scaling out ahead of
        anticipated demand.
      PREDICTIVE_METHOD_UNSPECIFIED: <no description>
    """
    NONE = 0
    OPTIMIZE_AVAILABILITY = 1
    PREDICTIVE_METHOD_UNSPECIFIED = 2

  predictiveMethod = _messages.EnumField('PredictiveMethodValueValuesEnum', 1)
  utilizationTarget = _messages.FloatField(2)


class AutoscalingPolicyCustomMetricUtilization(_messages.Message):
  r"""Custom utilization metric policy.

  Enums:
    UtilizationTargetTypeValueValuesEnum: Defines how target utilization value
      is expressed for a Stackdriver Monitoring metric. Either GAUGE,
      DELTA_PER_SECOND, or DELTA_PER_MINUTE.

  Fields:
    filter: A filter string, compatible with a Stackdriver Monitoring filter
      string for TimeSeries.list API call. This filter is used to select a
      specific TimeSeries for the purpose of autoscaling and to determine
      whether the metric is exporting per-instance or per-group data. For the
      filter to be valid for autoscaling purposes, the following rules apply:
      - You can only use the AND operator for joining selectors. - You can
      only use direct equality comparison operator (=) without any functions
      for each selector. - You can specify the metric in both the filter
      string and in the metric field. However, if specified in both places,
      the metric must be identical. - The monitored resource type determines
      what kind of values are expected for the metric. If it is a
      gce_instance, the autoscaler expects the metric to include a separate
      TimeSeries for each instance in a group. In such a case, you cannot
      filter on resource labels. If the resource type is any other value, the
      autoscaler expects this metric to contain values that apply to the
      entire autoscaled instance group and resource label filtering can be
      performed to point autoscaler at the correct TimeSeries to scale upon.
      This is called a *per-group metric* for the purpose of autoscaling. If
      not specified, the type defaults to gce_instance. Try to provide a
      filter that is selective enough to pick just one TimeSeries for the
      autoscaled group or for each of the instances (if you are using
      gce_instance resource type). If multiple TimeSeries are returned upon
      the query execution, the autoscaler will sum their respective values to
      obtain its scaling value.
    metric: The identifier (type) of the Stackdriver Monitoring metric. The
      metric cannot have negative values. The metric must have a value type of
      INT64 or DOUBLE.
    singleInstanceAssignment: If scaling is based on a per-group metric value
      that represents the total amount of work to be done or resource usage,
      set this value to an amount assigned for a single instance of the scaled
      group. Autoscaler keeps the number of instances proportional to the
      value of this metric. The metric itself does not change value due to
      group resizing. A good metric to use with the target is for example
      pubsub.googleapis.com/subscription/num_undelivered_messages or a custom
      metric exporting the total number of requests coming to your instances.
      A bad example would be a metric exporting an average or median latency,
      since this value can't include a chunk assignable to a single instance,
      it could be better used with utilization_target instead.
    utilizationTarget: The target value of the metric that autoscaler
      maintains. This must be a positive value. A utilization metric scales
      number of virtual machines handling requests to increase or decrease
      proportionally to the metric. For example, a good metric to use as a
      utilization_target is https://www.googleapis.com/compute/v1/instance/net
      work/received_bytes_count. The autoscaler works to keep this value
      constant for each of the instances.
    utilizationTargetType: Defines how target utilization value is expressed
      for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or
      DELTA_PER_MINUTE.
  """

  class UtilizationTargetTypeValueValuesEnum(_messages.Enum):
    r"""Defines how target utilization value is expressed for a Stackdriver
    Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.

    Values:
      DELTA_PER_MINUTE: Sets the utilization target value for a cumulative or
        delta metric, expressed as the rate of growth per minute.
      DELTA_PER_SECOND: Sets the utilization target value for a cumulative or
        delta metric, expressed as the rate of growth per second.
      GAUGE: Sets the utilization target value for a gauge metric. The
        autoscaler will collect the average utilization of the virtual
        machines from the last couple of minutes, and compare the value to the
        utilization target value to perform autoscaling.
    """
    DELTA_PER_MINUTE = 0
    DELTA_PER_SECOND = 1
    GAUGE = 2

  filter = _messages.StringField(1)
  metric = _messages.StringField(2)
  singleInstanceAssignment = _messages.FloatField(3)
  utilizationTarget = _messages.FloatField(4)
  utilizationTargetType = _messages.EnumField('UtilizationTargetTypeValueValuesEnum', 5)


class AutoscalingPolicyLoadBalancingUtilization(_messages.Message):
  r"""Configuration parameters of autoscaling based on load balancing.

  Fields:
    utilizationTarget: Fraction of backend capacity utilization (set in
      HTTP(S) load balancing configuration) that the autoscaler maintains.
      Must be a positive float value. If not defined, the default is 0.8.
  """

  utilizationTarget = _messages.FloatField(1)


class AutoscalingPolicyScaleDownControl(_messages.Message):
  r"""Configuration that allows for slower scale in so that even if Autoscaler
  recommends an abrupt scale in of a MIG, it will be throttled as specified by
  the parameters below.

  Fields:
    maxScaledDownReplicas: Maximum allowed number (or %) of VMs that can be
      deducted from the peak recommendation during the window autoscaler looks
      at when computing recommendations. Possibly all these VMs can be deleted
      at once so user service needs to be prepared to lose that many VMs in
      one step.
    timeWindowSec: How far back autoscaling looks when computing
      recommendations to include directives regarding slower scale in, as
      described above.
  """

  maxScaledDownReplicas = _messages.MessageField('FixedOrPercent', 1)
  timeWindowSec = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class AutoscalingPolicyScaleInControl(_messages.Message):
  r"""Configuration that allows for slower scale in so that even if Autoscaler
  recommends an abrupt scale in of a MIG, it will be throttled as specified by
  the parameters below.

  Fields:
    maxScaledInReplicas: Maximum allowed number (or %) of VMs that can be
      deducted from the peak recommendation during the window autoscaler looks
      at when computing recommendations. Possibly all these VMs can be deleted
      at once so user service needs to be prepared to lose that many VMs in
      one step.
    timeWindowSec: How far back autoscaling looks when computing
      recommendations to include directives regarding slower scale in, as
      described above.
  """

  maxScaledInReplicas = _messages.MessageField('FixedOrPercent', 1)
  timeWindowSec = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class AutoscalingPolicyScalingSchedule(_messages.Message):
  r"""Scaling based on user-defined schedule. The message describes a single
  scaling schedule. A scaling schedule changes the minimum number of VM
  instances an autoscaler can recommend, which can trigger scaling out.

  Fields:
    description: A description of a scaling schedule.
    disabled: A boolean value that specifies whether a scaling schedule can
      influence autoscaler recommendations. If set to true, then a scaling
      schedule has no effect. This field is optional, and its value is false
      by default.
    durationSec: The duration of time intervals, in seconds, for which this
      scaling schedule is to run. The minimum allowed value is 300. This field
      is required.
    minRequiredReplicas: The minimum number of VM instances that the
      autoscaler will recommend in time intervals starting according to
      schedule. This field is required.
    schedule: The start timestamps of time intervals when this scaling
      schedule is to provide a scaling signal. This field uses the extended
      cron format (with an optional year field). The expression can describe a
      single timestamp if the optional year is set, in which case the scaling
      schedule runs once. The schedule is interpreted with respect to
      time_zone. This field is required. Note: These timestamps only describe
      when autoscaler starts providing the scaling signal. The VMs need
      additional time to become serving.
    timeZone: The time zone to use when interpreting the schedule. The value
      of this field must be a time zone name from the tz database:
      http://en.wikipedia.org/wiki/Tz_database. This field is assigned a
      default value of "UTC" if left empty.
  """

  description = _messages.StringField(1)
  disabled = _messages.BooleanField(2)
  durationSec = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  minRequiredReplicas = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  schedule = _messages.StringField(5)
  timeZone = _messages.StringField(6)


class Backend(_messages.Message):
  r"""Message containing information of one individual backend.

  Enums:
    BalancingModeValueValuesEnum: Specifies how to determine whether the
      backend of a load balancer can handle additional traffic or is fully
      loaded. For usage guidelines, see Connection balancing mode. Backends
      must use compatible balancing modes. For more information, see Supported
      balancing modes and target capacity settings and Restrictions and
      guidance for instance groups. Note: Currently, if you use the API to
      configure incompatible balancing modes, the configuration might be
      accepted even though it has no impact and is ignored. Specifically,
      Backend.maxUtilization is ignored when Backend.balancingMode is RATE. In
      the future, this incompatible combination will be rejected.

  Fields:
    balancingMode: Specifies how to determine whether the backend of a load
      balancer can handle additional traffic or is fully loaded. For usage
      guidelines, see Connection balancing mode. Backends must use compatible
      balancing modes. For more information, see Supported balancing modes and
      target capacity settings and Restrictions and guidance for instance
      groups. Note: Currently, if you use the API to configure incompatible
      balancing modes, the configuration might be accepted even though it has
      no impact and is ignored. Specifically, Backend.maxUtilization is
      ignored when Backend.balancingMode is RATE. In the future, this
      incompatible combination will be rejected.
    capacityScaler: A multiplier applied to the backend's target capacity of
      its balancing mode. The default value is 1, which means the group serves
      up to 100% of its configured capacity (depending on balancingMode). A
      setting of 0 means the group is completely drained, offering 0% of its
      available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot
      configure a setting larger than 0 and smaller than 0.1. You cannot
      configure a setting of 0 when there is only one backend attached to the
      backend service.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    failover: This field designates whether this is a failover backend. More
      than one failover backend can be configured for a given BackendService.
    group: The fully-qualified URL of an instance group or network endpoint
      group (NEG) resource. To determine what types of backends a load
      balancer supports, see the [Backend services
      overview](https://cloud.google.com/load-balancing/docs/backend-
      service#backends). You must use the *fully-qualified* URL (starting with
      https://www.googleapis.com/) to specify the instance group or NEG.
      Partial URLs are not supported.
    maxConnections: Defines a target maximum number of simultaneous
      connections. For usage guidelines, see Connection balancing mode and
      Utilization balancing mode. Not available if the backend's balancingMode
      is RATE.
    maxConnectionsPerEndpoint: Defines a target maximum number of simultaneous
      connections. For usage guidelines, see Connection balancing mode and
      Utilization balancing mode. Not available if the backend's balancingMode
      is RATE.
    maxConnectionsPerInstance: Defines a target maximum number of simultaneous
      connections. For usage guidelines, see Connection balancing mode and
      Utilization balancing mode. Not available if the backend's balancingMode
      is RATE.
    maxRate: Defines a maximum number of HTTP requests per second (RPS). For
      usage guidelines, see Rate balancing mode and Utilization balancing
      mode. Not available if the backend's balancingMode is CONNECTION.
    maxRatePerEndpoint: Defines a maximum target for requests per second
      (RPS). For usage guidelines, see Rate balancing mode and Utilization
      balancing mode. Not available if the backend's balancingMode is
      CONNECTION.
    maxRatePerInstance: Defines a maximum target for requests per second
      (RPS). For usage guidelines, see Rate balancing mode and Utilization
      balancing mode. Not available if the backend's balancingMode is
      CONNECTION.
    maxUtilization: Optional parameter to define a target capacity for the
      UTILIZATIONbalancing mode. The valid range is [0.0, 1.0]. For usage
      guidelines, see Utilization balancing mode.
  """

  class BalancingModeValueValuesEnum(_messages.Enum):
    r"""Specifies how to determine whether the backend of a load balancer can
    handle additional traffic or is fully loaded. For usage guidelines, see
    Connection balancing mode. Backends must use compatible balancing modes.
    For more information, see Supported balancing modes and target capacity
    settings and Restrictions and guidance for instance groups. Note:
    Currently, if you use the API to configure incompatible balancing modes,
    the configuration might be accepted even though it has no impact and is
    ignored. Specifically, Backend.maxUtilization is ignored when
    Backend.balancingMode is RATE. In the future, this incompatible
    combination will be rejected.

    Values:
      CONNECTION: Balance based on the number of simultaneous connections.
      RATE: Balance based on requests per second (RPS).
      UTILIZATION: Balance based on the backend utilization.
    """
    CONNECTION = 0
    RATE = 1
    UTILIZATION = 2

  balancingMode = _messages.EnumField('BalancingModeValueValuesEnum', 1)
  capacityScaler = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  description = _messages.StringField(3)
  failover = _messages.BooleanField(4)
  group = _messages.StringField(5)
  maxConnections = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  maxConnectionsPerEndpoint = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  maxConnectionsPerInstance = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  maxRate = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  maxRatePerEndpoint = _messages.FloatField(10, variant=_messages.Variant.FLOAT)
  maxRatePerInstance = _messages.FloatField(11, variant=_messages.Variant.FLOAT)
  maxUtilization = _messages.FloatField(12, variant=_messages.Variant.FLOAT)


class BackendBucket(_messages.Message):
  r"""Represents a Cloud Storage Bucket resource. This Cloud Storage bucket
  resource is referenced by a URL map of a load balancer. For more
  information, read Backend Buckets.

  Enums:
    CompressionModeValueValuesEnum: Compress text responses using Brotli or
      gzip compression, based on the client's Accept-Encoding header.

  Fields:
    bucketName: Cloud Storage bucket name.
    cdnPolicy: Cloud CDN configuration for this BackendBucket.
    compressionMode: Compress text responses using Brotli or gzip compression,
      based on the client's Accept-Encoding header.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    customResponseHeaders: Headers that the HTTP/S load balancer should add to
      proxied responses.
    description: An optional textual description of the resource; provided by
      the client when the resource is created.
    edgeSecurityPolicy: [Output Only] The resource URL for the edge security
      policy associated with this backend bucket.
    enableCdn: If true, enable Cloud CDN for this BackendBucket.
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    kind: Type of the resource.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    selfLink: [Output Only] Server-defined URL for the resource.
  """

  class CompressionModeValueValuesEnum(_messages.Enum):
    r"""Compress text responses using Brotli or gzip compression, based on the
    client's Accept-Encoding header.

    Values:
      AUTOMATIC: Automatically uses the best compression based on the Accept-
        Encoding header sent by the client.
      DISABLED: Disables compression. Existing compressed responses cached by
        Cloud CDN will not be served to clients.
    """
    AUTOMATIC = 0
    DISABLED = 1

  bucketName = _messages.StringField(1)
  cdnPolicy = _messages.MessageField('BackendBucketCdnPolicy', 2)
  compressionMode = _messages.EnumField('CompressionModeValueValuesEnum', 3)
  creationTimestamp = _messages.StringField(4)
  customResponseHeaders = _messages.StringField(5, repeated=True)
  description = _messages.StringField(6)
  edgeSecurityPolicy = _messages.StringField(7)
  enableCdn = _messages.BooleanField(8)
  id = _messages.IntegerField(9, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(10, default='compute#backendBucket')
  name = _messages.StringField(11)
  selfLink = _messages.StringField(12)


class BackendBucketCdnPolicy(_messages.Message):
  r"""Message containing Cloud CDN configuration for a backend bucket.

  Enums:
    CacheModeValueValuesEnum: Specifies the cache setting for all responses
      from this backend. The possible values are: USE_ORIGIN_HEADERS Requires
      the origin to set valid caching headers to cache content. Responses
      without these headers will not be cached at Google's edge, and will
      require a full trip to the origin on every request, potentially
      impacting performance and increasing load on the origin server.
      FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or
      "no-cache" directives in Cache-Control response headers. Warning: this
      may result in Cloud CDN caching private, per-user (user identifiable)
      content. CACHE_ALL_STATIC Automatically cache static content, including
      common image formats, media (video and audio), and web assets
      (JavaScript and CSS). Requests and responses that are marked as
      uncacheable, as well as dynamic content (including HTML), will not be
      cached.

  Fields:
    bypassCacheOnRequestHeaders: Bypass the cache when the specified request
      headers are matched - e.g. Pragma or Authorization headers. Up to 5
      headers can be specified. The cache is bypassed for all
      cdnPolicy.cacheMode settings.
    cacheKeyPolicy: The CacheKeyPolicy for this CdnPolicy.
    cacheMode: Specifies the cache setting for all responses from this
      backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin
      to set valid caching headers to cache content. Responses without these
      headers will not be cached at Google's edge, and will require a full
      trip to the origin on every request, potentially impacting performance
      and increasing load on the origin server. FORCE_CACHE_ALL Cache all
      content, ignoring any "private", "no-store" or "no-cache" directives in
      Cache-Control response headers. Warning: this may result in Cloud CDN
      caching private, per-user (user identifiable) content. CACHE_ALL_STATIC
      Automatically cache static content, including common image formats,
      media (video and audio), and web assets (JavaScript and CSS). Requests
      and responses that are marked as uncacheable, as well as dynamic content
      (including HTML), will not be cached.
    clientTtl: Specifies a separate client (e.g. browser client) maximum TTL.
      This is used to clamp the max-age (or Expires) value sent to the client.
      With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used
      for the response max-age directive, along with a "public" directive. For
      cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-
      age from the origin (if specified), or else sets the response max-age
      directive to the lesser of the client_ttl and default_ttl, and also
      ensures a "public" cache-control directive is present. If a client TTL
      is not specified, a default value (1 hour) will be used. The maximum
      allowed value is 31,622,400s (1 year).
    defaultTtl: Specifies the default TTL for cached content served by this
      origin for responses that do not have an existing valid TTL (max-age or
      s-max-age). Setting a TTL of "0" means "always revalidate". The value of
      defaultTTL cannot be set to a value greater than that of maxTTL, but can
      be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL
      will overwrite the TTL set in all responses. The maximum allowed value
      is 31,622,400s (1 year), noting that infrequently accessed objects may
      be evicted from the cache before the defined TTL.
    maxTtl: Specifies the maximum allowed TTL for cached content served by
      this origin. Cache directives that attempt to set a max-age or s-maxage
      higher than this, or an Expires header more than maxTTL seconds in the
      future will be capped at the value of maxTTL, as if it were the value of
      an s-maxage Cache-Control directive. Headers sent to the client will not
      be modified. Setting a TTL of "0" means "always revalidate". The maximum
      allowed value is 31,622,400s (1 year), noting that infrequently accessed
      objects may be evicted from the cache before the defined TTL.
    negativeCaching: Negative caching allows per-status code TTLs to be set,
      in order to apply fine-grained caching for common errors or redirects.
      This can reduce the load on your origin and improve end-user experience
      by reducing response latency. When the cache mode is set to
      CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to
      responses with the specified response code that lack any Cache-Control,
      Expires, or Pragma: no-cache directives. When the cache mode is set to
      FORCE_CACHE_ALL, negative caching applies to all responses with the
      specified response code, and override any caching headers. By default,
      Cloud CDN will apply the following default TTLs to these status codes:
      HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404
      (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP
      405 (Method Not Found), 421 (Misdirected Request), 501 (Not
      Implemented): 60s. These defaults can be overridden in
      negative_caching_policy.
    negativeCachingPolicy: Sets a cache TTL for the specified HTTP status
      code. negative_caching must be enabled to configure
      negative_caching_policy. Omitting the policy and leaving
      negative_caching enabled will use Cloud CDN's default cache TTLs. Note
      that when specifying an explicit negative_caching_policy, you should
      take care to specify a cache TTL for all response codes that you wish to
      cache. Cloud CDN will not apply any default negative caching when a
      policy exists.
    requestCoalescing: If true then Cloud CDN will combine multiple concurrent
      cache fill requests into a small number of requests to the origin.
    serveWhileStale: Serve existing content from the cache (if available) when
      revalidating content with the origin, or when an error is encountered
      when refreshing the cache. This setting defines the default "max-stale"
      duration for any cached responses that do not specify a max-stale
      directive. Stale responses that exceed the TTL configured here will not
      be served. The default limit (max-stale) is 86400s (1 day), which will
      allow stale content to be served up to this limit beyond the max-age (or
      s-max-age) of a cached response. The maximum allowed value is 604800 (1
      week). Set this to zero (0) to disable serve-while-stale.
    signedUrlCacheMaxAgeSec: Maximum number of seconds the response to a
      signed URL request will be considered fresh. After this time period, the
      response will be revalidated before being served. Defaults to 1hr
      (3600s). When serving responses to signed URL requests, Cloud CDN will
      internally behave as though all responses from this backend had a
      "Cache-Control: public, max-age=[TTL]" header, regardless of any
      existing Cache-Control header. The actual headers served in responses
      will not be altered.
    signedUrlKeyNames: [Output Only] Names of the keys for signing request
      URLs.
  """

  class CacheModeValueValuesEnum(_messages.Enum):
    r"""Specifies the cache setting for all responses from this backend. The
    possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid
    caching headers to cache content. Responses without these headers will not
    be cached at Google's edge, and will require a full trip to the origin on
    every request, potentially impacting performance and increasing load on
    the origin server. FORCE_CACHE_ALL Cache all content, ignoring any
    "private", "no-store" or "no-cache" directives in Cache-Control response
    headers. Warning: this may result in Cloud CDN caching private, per-user
    (user identifiable) content. CACHE_ALL_STATIC Automatically cache static
    content, including common image formats, media (video and audio), and web
    assets (JavaScript and CSS). Requests and responses that are marked as
    uncacheable, as well as dynamic content (including HTML), will not be
    cached.

    Values:
      CACHE_ALL_STATIC: Automatically cache static content, including common
        image formats, media (video and audio), and web assets (JavaScript and
        CSS). Requests and responses that are marked as uncacheable, as well
        as dynamic content (including HTML), will not be cached.
      FORCE_CACHE_ALL: Cache all content, ignoring any "private", "no-store"
        or "no-cache" directives in Cache-Control response headers. Warning:
        this may result in Cloud CDN caching private, per-user (user
        identifiable) content.
      INVALID_CACHE_MODE: <no description>
      USE_ORIGIN_HEADERS: Requires the origin to set valid caching headers to
        cache content. Responses without these headers will not be cached at
        Google's edge, and will require a full trip to the origin on every
        request, potentially impacting performance and increasing load on the
        origin server.
    """
    CACHE_ALL_STATIC = 0
    FORCE_CACHE_ALL = 1
    INVALID_CACHE_MODE = 2
    USE_ORIGIN_HEADERS = 3

  bypassCacheOnRequestHeaders = _messages.MessageField('BackendBucketCdnPolicyBypassCacheOnRequestHeader', 1, repeated=True)
  cacheKeyPolicy = _messages.MessageField('BackendBucketCdnPolicyCacheKeyPolicy', 2)
  cacheMode = _messages.EnumField('CacheModeValueValuesEnum', 3)
  clientTtl = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  defaultTtl = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  maxTtl = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  negativeCaching = _messages.BooleanField(7)
  negativeCachingPolicy = _messages.MessageField('BackendBucketCdnPolicyNegativeCachingPolicy', 8, repeated=True)
  requestCoalescing = _messages.BooleanField(9)
  serveWhileStale = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  signedUrlCacheMaxAgeSec = _messages.IntegerField(11)
  signedUrlKeyNames = _messages.StringField(12, repeated=True)


class BackendBucketCdnPolicyBypassCacheOnRequestHeader(_messages.Message):
  r"""Bypass the cache when the specified request headers are present, e.g.
  Pragma or Authorization headers. Values are case insensitive. The presence
  of such a header overrides the cache_mode setting.

  Fields:
    headerName: The header field name to match on when bypassing cache. Values
      are case-insensitive.
  """

  headerName = _messages.StringField(1)


class BackendBucketCdnPolicyCacheKeyPolicy(_messages.Message):
  r"""Message containing what to include in the cache key for a request for
  Cloud CDN.

  Fields:
    includeHttpHeaders: Allows HTTP request headers (by name) to be used in
      the cache key.
    queryStringWhitelist: Names of query string parameters to include in cache
      keys. All other parameters will be excluded. '&' and '=' will be percent
      encoded and not treated as delimiters.
  """

  includeHttpHeaders = _messages.StringField(1, repeated=True)
  queryStringWhitelist = _messages.StringField(2, repeated=True)


class BackendBucketCdnPolicyNegativeCachingPolicy(_messages.Message):
  r"""Specify CDN TTLs for response error codes.

  Fields:
    code: The HTTP status code to define a TTL against. Only HTTP status codes
      300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be
      specified as values, and you cannot specify a status code more than
      once.
    ttl: The TTL (in seconds) for which to cache responses with the
      corresponding status code. The maximum allowed value is 1800s (30
      minutes), noting that infrequently accessed objects may be evicted from
      the cache before the defined TTL.
  """

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  ttl = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class BackendBucketList(_messages.Message):
  r"""Contains a list of BackendBucket resources.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of BackendBucket resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: Warning about failed cleanup of transient changes made
          by a failed operation.
        DEPRECATED_RESOURCE_USED: A link to a deprecated resource was created.
        DEPRECATED_TYPE_USED: When deploying and at least one of the resources
          has a type marked as deprecated
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: The user created a boot disk that is
          larger than image size.
        EXPERIMENTAL_TYPE_USED: When deploying and at least one of the
          resources has a type marked as experimental
        EXTERNAL_API_WARNING: Warning that is present in an external api call
        FIELD_VALUE_OVERRIDEN: Warning that value of a field has been
          overridden. Deprecated unused field.
        INJECTED_KERNELS_DEPRECATED: The operation involved use of an injected
          kernel, which is deprecated.
        LARGE_DEPLOYMENT_WARNING: When deploying a deployment with a
          exceedingly large number of resources
        MISSING_TYPE_DEPENDENCY: A resource depends on a missing type
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: The route's nextHopIp address is not
          assigned to an instance on the network.
        NEXT_HOP_CANNOT_IP_FORWARD: The route's next hop instance cannot ip
          forward.
        NEXT_HOP_INSTANCE_NOT_FOUND: The route's nextHopInstance URL refers to
          an instance that does not exist.
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: The route's nextHopInstance URL
          refers to an instance that is not on the same network as the route.
        NEXT_HOP_NOT_RUNNING: The route's next hop instance does not have a
          status of RUNNING.
        NOT_CRITICAL_ERROR: Error which is not critical. We decided to
          continue the process despite the mentioned error.
        NO_RESULTS_ON_PAGE: No results are present on a particular list page.
        PARTIAL_SUCCESS: Success is reported, but some results may be missing
          due to errors
        REQUIRED_TOS_AGREEMENT: The user attempted to use a resource that
          requires a TOS they have not accepted.
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: Warning that a resource is
          in use.
        RESOURCE_NOT_DELETED: One or more of the resources set to auto-delete
          could not be deleted because they were in use.
        SCHEMA_VALIDATION_IGNORED: When a resource schema validation is
          ignored.
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: Instance template used in instance
          group manager is valid as such, but its application does not make a
          lot of sense, because it allows only single instance in instance
          group.
        UNDECLARED_PROPERTIES: When undeclared properties in the schema are
          present
        UNREACHABLE: A given scope cannot be reached.
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      LARGE_DEPLOYMENT_WARNING = 8
      MISSING_TYPE_DEPENDENCY = 9
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 10
      NEXT_HOP_CANNOT_IP_FORWARD = 11
      NEXT_HOP_INSTANCE_NOT_FOUND = 12
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 13
      NEXT_HOP_NOT_RUNNING = 14
      NOT_CRITICAL_ERROR = 15
      NO_RESULTS_ON_PAGE = 16
      PARTIAL_SUCCESS = 17
      REQUIRED_TOS_AGREEMENT = 18
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 19
      RESOURCE_NOT_DELETED = 20
      SCHEMA_VALIDATION_IGNORED = 21
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 22
      UNDECLARED_PROPERTIES = 23
      UNREACHABLE = 24

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('BackendBucket', 2, repeated=True)
  kind = _messages.StringField(3, default='compute#backendBucketList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class BackendService(_messages.Message):
  r"""Represents a Backend Service resource. A backend service defines how
  Google Cloud load balancers distribute traffic. The backend service
  configuration contains a set of values, such as the protocol used to connect
  to backends, various distribution and session settings, health checks, and
  timeouts. These settings provide fine-grained control over how your load
  balancer behaves. Most of the settings have default values that allow for
  easy configuration if you need to get started quickly. Backend services in
  Google Compute Engine can be either regionally or globally scoped. * [Global
  ](https://cloud.google.com/compute/docs/reference/rest/beta/backendServices)
  * [Regional](https://cloud.google.com/compute/docs/reference/rest/beta/regio
  nBackendServices) For more information, see Backend Services.

  Enums:
    CompressionModeValueValuesEnum: Compress text responses using Brotli or
      gzip compression, based on the client's Accept-Encoding header.
    LoadBalancingSchemeValueValuesEnum: Specifies the load balancer type. A
      backend service created for one type of load balancer cannot be used
      with another. For more information, refer to Choosing a load balancer.
    LocalityLbPolicyValueValuesEnum: The load balancing algorithm used within
      the scope of the locality. The possible values are: - ROUND_ROBIN: This
      is a simple policy in which each healthy backend is selected in round
      robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm
      which selects two random healthy hosts and picks the host which has
      fewer active requests. - RING_HASH: The ring/modulo hash load balancer
      implements consistent hashing to backends. The algorithm has the
      property that the addition/removal of a host from a set of N hosts only
      affects 1/N of the requests. - RANDOM: The load balancer selects a
      random healthy host. - ORIGINAL_DESTINATION: Backend host is selected
      based on the client connection metadata, i.e., connections are opened to
      the same address as the destination address of the incoming connection
      before the connection was redirected to the load balancer. - MAGLEV:
      used as a drop in replacement for the ring hash load balancer. Maglev is
      not as stable as ring hash but has faster table lookup build times and
      host selection times. For more information about Maglev, see
      https://ai.google/research/pubs/pub44824 This field is applicable to
      either: - A regional backend service with the service_protocol set to
      HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to
      INTERNAL_MANAGED. - A global backend service with the
      load_balancing_scheme set to INTERNAL_SELF_MANAGED. If sessionAffinity
      is not NONE, and this field is not set to MAGLEV or RING_HASH, session
      affinity settings will not take effect. Only ROUND_ROBIN and RING_HASH
      are supported when the backend service is referenced by a URL map that
      is bound to target gRPC proxy that has validateForProxyless field set to
      true.
    ProtocolValueValuesEnum: The protocol this BackendService uses to
      communicate with backends. Possible values are HTTP, HTTPS, HTTP2, TCP,
      SSL, UDP or GRPC. depending on the chosen load balancer or Traffic
      Director configuration. Refer to the documentation for the load
      balancers or for Traffic Director for more information. Must be set to
      GRPC when the backend service is referenced by a URL map that is bound
      to target gRPC proxy.
    SessionAffinityValueValuesEnum: Type of session affinity to use. The
      default is NONE. Only NONE and HEADER_FIELD are supported when the
      backend service is referenced by a URL map that is bound to target gRPC
      proxy that has validateForProxyless field set to true. For more details,
      see: [Session Affinity](https://cloud.google.com/load-
      balancing/docs/backend-service#session_affinity).

  Fields:
    affinityCookieTtlSec: Lifetime of cookies in seconds. This setting is
      applicable to external and internal HTTP(S) load balancers and Traffic
      Director and requires GENERATED_COOKIE or HTTP_COOKIE session affinity.
      If set to 0, the cookie is non-persistent and lasts only until the end
      of the browser session (or equivalent). The maximum allowed value is one
      day (86,400). Not supported when the backend service is referenced by a
      URL map that is bound to target gRPC proxy that has validateForProxyless
      field set to true.
    backends: The list of backends that serve this BackendService.
    cdnPolicy: Cloud CDN configuration for this BackendService. Only available
      for specified load balancer types.
    circuitBreakers: A CircuitBreakers attribute.
    compressionMode: Compress text responses using Brotli or gzip compression,
      based on the client's Accept-Encoding header.
    connectionDraining: A ConnectionDraining attribute.
    connectionTrackingPolicy: Connection Tracking configuration for this
      BackendService. Connection tracking policy settings are only available
      for Network Load Balancing and Internal TCP/UDP Load Balancing.
    consistentHash: Consistent Hash-based load balancing can be used to
      provide soft session affinity based on HTTP headers, cookies or other
      properties. This load balancing policy is applicable only for HTTP
      connections. The affinity to a particular destination host will be lost
      when one or more hosts are added/removed from the destination service.
      This field specifies parameters that control consistent hashing. This
      field is only applicable when localityLbPolicy is set to MAGLEV or
      RING_HASH. This field is applicable to either: - A regional backend
      service with the service_protocol set to HTTP, HTTPS, or HTTP2, and
      load_balancing_scheme set to INTERNAL_MANAGED. - A global backend
      service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    customRequestHeaders: Headers that the load balancer adds to proxied
      requests. See [Creating custom headers](https://cloud.google.com/load-
      balancing/docs/custom-headers).
    customResponseHeaders: Headers that the load balancer adds to proxied
      responses. See [Creating custom headers](https://cloud.google.com/load-
      balancing/docs/custom-headers).
    description: An optional description of this resource. Provide this
      property when you create the resource.
    edgeSecurityPolicy: [Output Only] The resource URL for the edge security
      policy associated with this backend service.
    enableCDN: If true, enables Cloud CDN for the backend service of an
      external HTTP(S) load balancer.
    failoverPolicy: Requires at least one backend instance group to be defined
      as a backup (failover) backend. For load balancers that have
      configurable failover: [Internal TCP/UDP Load
      Balancing](https://cloud.google.com/load-
      balancing/docs/internal/failover-overview) and [external TCP/UDP Load
      Balancing](https://cloud.google.com/load-
      balancing/docs/network/networklb-failover-overview).
    fingerprint: Fingerprint of this resource. A hash of the contents stored
      in this object. This field is used in optimistic locking. This field
      will be ignored when inserting a BackendService. An up-to-date
      fingerprint must be provided in order to update the BackendService,
      otherwise the request will fail with error 412 conditionNotMet. To see
      the latest fingerprint, make a get() request to retrieve a
      BackendService.
    healthChecks: The list of URLs to the healthChecks, httpHealthChecks
      (legacy), or httpsHealthChecks (legacy) resource for health checking
      this backend service. Not all backend services support legacy health
      checks. See Load balancer guide. Currently, at most one health check can
      be specified for each backend service. Backend services with instance
      group or zonal NEG backends must have a health check. Backend services
      with internet or serverless NEG backends must not have a health check.
    iap: The configurations for Identity-Aware Proxy on this resource. Not
      available for Internal TCP/UDP Load Balancing and Network Load
      Balancing.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of resource. Always compute#backendService for
      backend services.
    loadBalancingScheme: Specifies the load balancer type. A backend service
      created for one type of load balancer cannot be used with another. For
      more information, refer to Choosing a load balancer.
    localityLbPolicy: The load balancing algorithm used within the scope of
      the locality. The possible values are: - ROUND_ROBIN: This is a simple
      policy in which each healthy backend is selected in round robin order.
      This is the default. - LEAST_REQUEST: An O(1) algorithm which selects
      two random healthy hosts and picks the host which has fewer active
      requests. - RING_HASH: The ring/modulo hash load balancer implements
      consistent hashing to backends. The algorithm has the property that the
      addition/removal of a host from a set of N hosts only affects 1/N of the
      requests. - RANDOM: The load balancer selects a random healthy host. -
      ORIGINAL_DESTINATION: Backend host is selected based on the client
      connection metadata, i.e., connections are opened to the same address as
      the destination address of the incoming connection before the connection
      was redirected to the load balancer. - MAGLEV: used as a drop in
      replacement for the ring hash load balancer. Maglev is not as stable as
      ring hash but has faster table lookup build times and host selection
      times. For more information about Maglev, see
      https://ai.google/research/pubs/pub44824 This field is applicable to
      either: - A regional backend service with the service_protocol set to
      HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to
      INTERNAL_MANAGED. - A global backend service with the
      load_balancing_scheme set to INTERNAL_SELF_MANAGED. If sessionAffinity
      is not NONE, and this field is not set to MAGLEV or RING_HASH, session
      affinity settings will not take effect. Only ROUND_ROBIN and RING_HASH
      are supported when the backend service is referenced by a URL map that
      is bound to target gRPC proxy that has validateForProxyless field set to
      true.
    logConfig: This field denotes the logging options for the load balancer
      traffic served by this backend service. If logging is enabled, logs will
      be exported to Stackdriver.
    maxStreamDuration: Specifies the default maximum duration (timeout) for
      streams to this service. Duration is computed from the beginning of the
      stream until the response has been completely processed, including all
      retries. A stream that does not complete in this duration is closed. If
      not specified, there will be no timeout limit, i.e. the maximum duration
      is infinite. This value can be overridden in the PathMatcher
      configuration of the UrlMap that references this backend service. This
      field is only allowed when the loadBalancingScheme of the backend
      service is INTERNAL_SELF_MANAGED.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    network: The URL of the network to which this backend service belongs.
      This field can only be specified when the load balancing scheme is set
      to INTERNAL.
    outlierDetection: Settings controlling the eviction of unhealthy hosts
      from the load balancing pool for the backend service. If not set, this
      feature is considered disabled. This field is applicable to either: - A
      regional backend service with the service_protocol set to HTTP, HTTPS,
      or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. - A global
      backend service with the load_balancing_scheme set to
      INTERNAL_SELF_MANAGED. Not supported when the backend service is
      referenced by a URL map that is bound to target gRPC proxy that has
      validateForProxyless field set to true.
    port: Deprecated in favor of portName. The TCP port to connect on the
      backend. The default value is 80. For Internal TCP/UDP Load Balancing
      and Network Load Balancing, omit port.
    portName: A named port on a backend instance group representing the port
      for communication to the backend VMs in that group. The named port must
      be [defined on each backend instance
      group](https://cloud.google.com/load-balancing/docs/backend-
      service#named_ports). This parameter has no meaning if the backends are
      NEGs. For Internal TCP/UDP Load Balancing and Network Load Balancing,
      omit port_name.
    protocol: The protocol this BackendService uses to communicate with
      backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC.
      depending on the chosen load balancer or Traffic Director configuration.
      Refer to the documentation for the load balancers or for Traffic
      Director for more information. Must be set to GRPC when the backend
      service is referenced by a URL map that is bound to target gRPC proxy.
    region: [Output Only] URL of the region where the regional backend service
      resides. This field is not applicable to global backend services. You
      must specify this field as part of the HTTP request URL. It is not
      settable as a field in the request body.
    securityPolicy: [Output Only] The resource URL for the security policy
      associated with this backend service.
    securitySettings: This field specifies the security policy that applies to
      this backend service. This field is applicable to either: - A regional
      backend service with the service_protocol set to HTTP, HTTPS, or HTTP2,
      and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend
      service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
    selfLink: [Output Only] Server-defined URL for the resource.
    serviceBindings: URLs of networkservices.ServiceBinding resources. Can
      only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set,
      lists of backends and health checks must be both empty.
    sessionAffinity: Type of session affinity to use. The default is NONE.
      Only NONE and HEADER_FIELD are supported when the backend service is
      referenced by a URL map that is bound to target gRPC proxy that has
      validateForProxyless field set to true. For more details, see: [Session
      Affinity](https://cloud.google.com/load-balancing/docs/backend-
      service#session_affinity).
    subsetting: A Subsetting attribute.
    timeoutSec: Not supported when the backend service is referenced by a URL
      map that is bound to target gRPC proxy that has validateForProxyless
      field set to true. Instead, use maxStreamDuration.
  """

  class CompressionModeValueValuesEnum(_messages.Enum):
    r"""Compress text responses using Brotli or gzip compression, based on the
    client's Accept-Encoding header.

    Values:
      AUTOMATIC: Automatically uses the best compression based on the Accept-
        Encoding header sent by the client.
      DISABLED: Disables compression. Existing compressed responses cached by
        Cloud CDN will not be served to clients.
    """
    AUTOMATIC = 0
    DISABLED = 1

  class LoadBalancingSchemeValueValuesEnum(_messages.Enum):
    r"""Specifies the load balancer type. A backend service created for one
    type of load balancer cannot be used with another. For more information,
    refer to Choosing a load balancer.

    Values:
      EXTERNAL: Signifies that this will be used for external HTTP(S), SSL
        Proxy, TCP Proxy, or Network Load Balancing
      EXTERNAL_MANAGED: Signifies that this will be used for External Managed
        HTTP(S) Load Balancing.
      INTERNAL: Signifies that this will be used for Internal TCP/UDP Load
        Balancing.
      INTERNAL_MANAGED: Signifies that this will be used for Internal HTTP(S)
        Load Balancing.
      INTERNAL_SELF_MANAGED: Signifies that this will be used by Traffic
        Director.
      INVALID_LOAD_BALANCING_SCHEME: <no description>
    """
    EXTERNAL = 0
    EXTERNAL_MANAGED = 1
    INTERNAL = 2
    INTERNAL_MANAGED = 3
    INTERNAL_SELF_MANAGED = 4
    INVALID_LOAD_BALANCING_SCHEME = 5

  class LocalityLbPolicyValueValuesEnum(_messages.Enum):
    r"""The load balancing algorithm used within the scope of the locality.
    The possible values are: - ROUND_ROBIN: This is a simple policy in which
    each healthy backend is selected in round robin order. This is the
    default. - LEAST_REQUEST: An O(1) algorithm which selects two random
    healthy hosts and picks the host which has fewer active requests. -
    RING_HASH: The ring/modulo hash load balancer implements consistent
    hashing to backends. The algorithm has the property that the
    addition/removal of a host from a set of N hosts only affects 1/N of the
    requests. - RANDOM: The load balancer selects a random healthy host. -
    ORIGINAL_DESTINATION: Backend host is selected based on the client
    connection metadata, i.e., connections are opened to the same address as
    the destination address of the incoming connection before the connection
    was redirected to the load balancer. - MAGLEV: used as a drop in
    replacement for the ring hash load balancer. Maglev is not as stable as
    ring hash but has faster table lookup build times and host selection
    times. For more information about Maglev, see
    https://ai.google/research/pubs/pub44824 This field is applicable to
    either: - A regional backend service with the service_protocol set to
    HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
    - A global backend service with the load_balancing_scheme set to
    INTERNAL_SELF_MANAGED. If sessionAffinity is not NONE, and this field is
    not set to MAGLEV or RING_HASH, session affinity settings will not take
    effect. Only ROUND_ROBIN and RING_HASH are supported when the backend
    service is referenced by a URL map that is bound to target gRPC proxy that
    has validateForProxyless field set to true.

    Values:
      INVALID_LB_POLICY: <no description>
      LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts
        and picks the host which has fewer active requests.
      MAGLEV: This algorithm implements consistent hashing to backends. Maglev
        can be used as a drop in replacement for the ring hash load balancer.
        Maglev is not as stable as ring hash but has faster table lookup build
        times and host selection times. For more information about Maglev, see
        https://ai.google/research/pubs/pub44824
      ORIGINAL_DESTINATION: Backend host is selected based on the client
        connection metadata, i.e., connections are opened to the same address
        as the destination address of the incoming connection before the
        connection was redirected to the load balancer.
      RANDOM: The load balancer selects a random healthy host.
      RING_HASH: The ring/modulo hash load balancer implements consistent
        hashing to backends. The algorithm has the property that the
        addition/removal of a host from a set of N hosts only affects 1/N of
        the requests.
      ROUND_ROBIN: This is a simple policy in which each healthy backend is
        selected in round robin order. This is the default.
    """
    INVALID_LB_POLICY = 0
    LEAST_REQUEST = 1
    MAGLEV = 2
    ORIGINAL_DESTINATION = 3
    RANDOM = 4
    RING_HASH = 5
    ROUND_ROBIN = 6

  class ProtocolValueValuesEnum(_messages.Enum):
    r"""The protocol this BackendService uses to communicate with backends.
    Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending
    on the chosen load balancer or Traffic Director configuration. Refer to
    the documentation for the load balancers or for Traffic Director for more
    information. Must be set to GRPC when the backend service is referenced by
    a URL map that is bound to target gRPC proxy.

    Values:
      GRPC: gRPC (available for Traffic Director).
      HTTP: <no description>
      HTTP2: HTTP/2 with SSL.
      HTTPS: <no description>
      SSL: TCP proxying with SSL.
      TCP: TCP proxying or TCP pass-through.
      UDP: UDP.
      UNSPECIFIED: If a Backend Service has UNSPECIFIED as its protocol, it
        can be used with any L3/L4 Forwarding Rules.
    """
    GRPC = 0
    HTTP = 1
    HTTP2 = 2
    HTTPS = 3
    SSL = 4
    TCP = 5
    UDP = 6
    UNSPECIFIED = 7

  class SessionAffinityValueValuesEnum(_messages.Enum):
    r"""Type of session affinity to use. The default is NONE. Only NONE and
    HEADER_FIELD are supported when the backend service is referenced by a URL
    map that is bound to target gRPC proxy that has validateForProxyless field
    set to true. For more details, see: [Session
    Affinity](https://cloud.google.com/load-balancing/docs/backend-
    service#session_affinity).

    Values:
      CLIENT_IP: 2-tuple hash on packet's source and destination IP addresses.
        Connections from the same source IP address to the same destination IP
        address will be served by the same backend VM while that VM remains
        healthy.
      CLIENT_IP_NO_DESTINATION: 1-tuple hash only on packet's source IP
        address. Connections from the same source IP address will be served by
        the same backend VM while that VM remains healthy. This option can
        only be used for Internal TCP/UDP Load Balancing.
      CLIENT_IP_PORT_PROTO: 5-tuple hash on packet's source and destination IP
        addresses, IP protocol, and source and destination ports. Connections
        for the same IP protocol from the same source IP address and port to
        the same destination IP address and port will be served by the same
        backend VM while that VM remains healthy. This option cannot be used
        for HTTP(S) load balancing.
      CLIENT_IP_PROTO: 3-tuple hash on packet's source and destination IP
        addresses, and IP protocol. Connections for the same IP protocol from
        the same source IP address to the same destination IP address will be
        served by the same backend VM while that VM remains healthy. This
        option cannot be used for HTTP(S) load balancing.
      GENERATED_COOKIE: Hash based on a cookie generated by the L7
        loadbalancer. Only valid for HTTP(S) load balancing.
      HEADER_FIELD: The hash is based on a user specified header field.
      HTTP_COOKIE: The hash is based on a user provided cookie.
      NONE: No session affinity. Connections from the same client IP may go to
        any instance in the pool.
    """
    CLIENT_IP = 0
    CLIENT_IP_NO_DESTINATION = 1
    CLIENT_IP_PORT_PROTO = 2
    CLIENT_IP_PROTO = 3
    GENERATED_COOKIE = 4
    HEADER_FIELD = 5
    HTTP_COOKIE = 6
    NONE = 7

  affinityCookieTtlSec = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  backends = _messages.MessageField('Backend', 2, repeated=True)
  cdnPolicy = _messages.MessageField('BackendServiceCdnPolicy', 3)
  circuitBreakers = _messages.MessageField('CircuitBreakers', 4)
  compressionMode = _messages.EnumField('CompressionModeValueValuesEnum', 5)
  connectionDraining = _messages.MessageField('ConnectionDraining', 6)
  connectionTrackingPolicy = _messages.MessageField('BackendServiceConnectionTrackingPolicy', 7)
  consistentHash = _messages.MessageField('ConsistentHashLoadBalancerSettings', 8)
  creationTimestamp = _messages.StringField(9)
  customRequestHeaders = _messages.StringField(10, repeated=True)
  customResponseHeaders = _messages.StringField(11, repeated=True)
  description = _messages.StringField(12)
  edgeSecurityPolicy = _messages.StringField(13)
  enableCDN = _messages.BooleanField(14)
  failoverPolicy = _messages.MessageField('BackendServiceFailoverPolicy', 15)
  fingerprint = _messages.BytesField(16)
  healthChecks = _messages.StringField(17, repeated=True)
  iap = _messages.MessageField('BackendServiceIAP', 18)
  id = _messages.IntegerField(19, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(20, default='compute#backendService')
  loadBalancingScheme = _messages.EnumField('LoadBalancingSchemeValueValuesEnum', 21)
  localityLbPolicy = _messages.EnumField('LocalityLbPolicyValueValuesEnum', 22)
  logConfig = _messages.MessageField('BackendServiceLogConfig', 23)
  maxStreamDuration = _messages.MessageField('Duration', 24)
  name = _messages.StringField(25)
  network = _messages.StringField(26)
  outlierDetection = _messages.MessageField('OutlierDetection', 27)
  port = _messages.IntegerField(28, variant=_messages.Variant.INT32)
  portName = _messages.StringField(29)
  protocol = _messages.EnumField('ProtocolValueValuesEnum', 30)
  region = _messages.StringField(31)
  securityPolicy = _messages.StringField(32)
  securitySettings = _messages.MessageField('SecuritySettings', 33)
  selfLink = _messages.StringField(34)
  serviceBindings = _messages.StringField(35, repeated=True)
  sessionAffinity = _messages.EnumField('SessionAffinityValueValuesEnum', 36)
  subsetting = _messages.MessageField('Subsetting', 37)
  timeoutSec = _messages.IntegerField(38, variant=_messages.Variant.INT32)


class BackendServiceAggregatedList(_messages.Message):
  r"""Contains a list of BackendServicesScopedList.

  Messages:
    ItemsValue: A list of BackendServicesScopedList resources.
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of BackendServicesScopedList resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    unreachables: [Output Only] Unreachable resources.
    warning: [Output Only] Informational warning message.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    r"""A list of BackendServicesScopedList resources.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: Name of the scope containing this set of
        BackendServices.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A BackendServicesScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('BackendServicesScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: Warning about failed cleanup of transient changes made
          by a failed operation.
        DEPRECATED_RESOURCE_USED: A link to a deprecated resource was created.
        DEPRECATED_TYPE_USED: When deploying and at least one of the resources
          has a type marked as deprecated
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: The user created a boot disk that is
          larger than image size.
        EXPERIMENTAL_TYPE_USED: When deploying and at least one of the
          resources has a type marked as experimental
        EXTERNAL_API_WARNING: Warning that is present in an external api call
        FIELD_VALUE_OVERRIDEN: Warning that value of a field has been
          overridden. Deprecated unused field.
        INJECTED_KERNELS_DEPRECATED: The operation involved use of an injected
          kernel, which is deprecated.
        LARGE_DEPLOYMENT_WARNING: When deploying a deployment with a
          exceedingly large number of resources
        MISSING_TYPE_DEPENDENCY: A resource depends on a missing type
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: The route's nextHopIp address is not
          assigned to an instance on the network.
        NEXT_HOP_CANNOT_IP_FORWARD: The route's next hop instance cannot ip
          forward.
        NEXT_HOP_INSTANCE_NOT_FOUND: The route's nextHopInstance URL refers to
          an instance that does not exist.
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: The route's nextHopInstance URL
          refers to an instance that is not on the same network as the route.
        NEXT_HOP_NOT_RUNNING: The route's next hop instance does not have a
          status of RUNNING.
        NOT_CRITICAL_ERROR: Error which is not critical. We decided to
          continue the process despite the mentioned error.
        NO_RESULTS_ON_PAGE: No results are present on a particular list page.
        PARTIAL_SUCCESS: Success is reported, but some results may be missing
          due to errors
        REQUIRED_TOS_AGREEMENT: The user attempted to use a resource that
          requires a TOS they have not accepted.
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: Warning that a resource is
          in use.
        RESOURCE_NOT_DELETED: One or more of the resources set to auto-delete
          could not be deleted because they were in use.
        SCHEMA_VALIDATION_IGNORED: When a resource schema validation is
          ignored.
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: Instance template used in instance
          group manager is valid as such, but its application does not make a
          lot of sense, because it allows only single instance in instance
          group.
        UNDECLARED_PROPERTIES: When undeclared properties in the schema are
          present
        UNREACHABLE: A given scope cannot be reached.
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      LARGE_DEPLOYMENT_WARNING = 8
      MISSING_TYPE_DEPENDENCY = 9
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 10
      NEXT_HOP_CANNOT_IP_FORWARD = 11
      NEXT_HOP_INSTANCE_NOT_FOUND = 12
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 13
      NEXT_HOP_NOT_RUNNING = 14
      NOT_CRITICAL_ERROR = 15
      NO_RESULTS_ON_PAGE = 16
      PARTIAL_SUCCESS = 17
      REQUIRED_TOS_AGREEMENT = 18
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 19
      RESOURCE_NOT_DELETED = 20
      SCHEMA_VALIDATION_IGNORED = 21
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 22
      UNDECLARED_PROPERTIES = 23
      UNREACHABLE = 24

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default='compute#backendServiceAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  unreachables = _messages.StringField(6, repeated=True)
  warning = _messages.MessageField('WarningValue', 7)


class BackendServiceCdnPolicy(_messages.Message):
  r"""Message containing Cloud CDN configuration for a backend service.

  Enums:
    CacheModeValueValuesEnum: Specifies the cache setting for all responses
      from this backend. The possible values are: USE_ORIGIN_HEADERS Requires
      the origin to set valid caching headers to cache content. Responses
      without these headers will not be cached at Google's edge, and will
      require a full trip to the origin on every request, potentially
      impacting performance and increasing load on the origin server.
      FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or
      "no-cache" directives in Cache-Control response headers. Warning: this
      may result in Cloud CDN caching private, per-user (user identifiable)
      content. CACHE_ALL_STATIC Automatically cache static content, including
      common image formats, media (video and audio), and web assets
      (JavaScript and CSS). Requests and responses that are marked as
      uncacheable, as well as dynamic content (including HTML), will not be
      cached.

  Fields:
    bypassCacheOnRequestHeaders: Bypass the cache when the specified request
      headers are matched - e.g. Pragma or Authorization headers. Up to 5
      headers can be specified. The cache is bypassed for all
      cdnPolicy.cacheMode settings.
    cacheKeyPolicy: The CacheKeyPolicy for this CdnPolicy.
    cacheMode: Specifies the cache setting for all responses from this
      backend. The possible values are: USE_ORIGIN_HEADERS Requires the origin
      to set valid caching headers to cache content. Responses without these
      headers will not be cached at Google's edge, and will require a full
      trip to the origin on every request, potentially impacting performance
      and increasing load on the origin server. FORCE_CACHE_ALL Cache all
      content, ignoring any "private", "no-store" or "no-cache" directives in
      Cache-Control response headers. Warning: this may result in Cloud CDN
      caching private, per-user (user identifiable) content. CACHE_ALL_STATIC
      Automatically cache static content, including common image formats,
      media (video and audio), and web assets (JavaScript and CSS). Requests
      and responses that are marked as uncacheable, as well as dynamic content
      (including HTML), will not be cached.
    clientTtl: Specifies a separate client (e.g. browser client) maximum TTL.
      This is used to clamp the max-age (or Expires) value sent to the client.
      With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used
      for the response max-age directive, along with a "public" directive. For
      cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-
      age from the origin (if specified), or else sets the response max-age
      directive to the lesser of the client_ttl and default_ttl, and also
      ensures a "public" cache-control directive is present. If a client TTL
      is not specified, a default value (1 hour) will be used. The maximum
      allowed value is 31,622,400s (1 year).
    defaultTtl: Specifies the default TTL for cached content served by this
      origin for responses that do not have an existing valid TTL (max-age or
      s-max-age). Setting a TTL of "0" means "always revalidate". The value of
      defaultTTL cannot be set to a value greater than that of maxTTL, but can
      be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL
      will overwrite the TTL set in all responses. The maximum allowed value
      is 31,622,400s (1 year), noting that infrequently accessed objects may
      be evicted from the cache before the defined TTL.
    maxTtl: Specifies the maximum allowed TTL for cached content served by
      this origin. Cache directives that attempt to set a max-age or s-maxage
      higher than this, or an Expires header more than maxTTL seconds in the
      future will be capped at the value of maxTTL, as if it were the value of
      an s-maxage Cache-Control directive. Headers sent to the client will not
      be modified. Setting a TTL of "0" means "always revalidate". The maximum
      allowed value is 31,622,400s (1 year), noting that infrequently accessed
      objects may be evicted from the cache before the defined TTL.
    negativeCaching: Negative caching allows per-status code TTLs to be set,
      in order to apply fine-grained caching for common errors or redirects.
      This can reduce the load on your origin and improve end-user experience
      by reducing response latency. When the cache mode is set to
      CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to
      responses with the specified response code that lack any Cache-Control,
      Expires, or Pragma: no-cache directives. When the cache mode is set to
      FORCE_CACHE_ALL, negative caching applies to all responses with the
      specified response code, and override any caching headers. By default,
      Cloud CDN will apply the following default TTLs to these status codes:
      HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404
      (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP
      405 (Method Not Found), 421 (Misdirected Request), 501 (Not
      Implemented): 60s. These defaults can be overridden in
      negative_caching_policy.
    negativeCachingPolicy: Sets a cache TTL for the specified HTTP status
      code. negative_caching must be enabled to configure
      negative_caching_policy. Omitting the policy and leaving
      negative_caching enabled will use Cloud CDN's default cache TTLs. Note
      that when specifying an explicit negative_caching_policy, you should
      take care to specify a cache TTL for all response codes that you wish to
      cache. Cloud CDN will not apply any default negative caching when a
      policy exists.
    requestCoalescing: If true then Cloud CDN will combine multiple concurrent
      cache fill requests into a small number of requests to the origin.
    serveWhileStale: Serve existing content from the cache (if available) when
      revalidating content with the origin, or when an error is encountered
      when refreshing the cache. This setting defines the default "max-stale"
      duration for any cached responses that do not specify a max-stale
      directive. Stale responses that exceed the TTL configured here will not
      be served. The default limit (max-stale) is 86400s (1 day), which will
      allow stale content to be served up to this limit beyond the max-age (or
      s-max-age) of a cached response. The maximum allowed value is 604800 (1
      week). Set this to zero (0) to disable serve-while-stale.
    signedUrlCacheMaxAgeSec: Maximum number of seconds the response to a
      signed URL request will be considered fresh. After this time period, the
      response will be revalidated before being served. Defaults to 1hr
      (3600s). When serving responses to signed URL requests, Cloud CDN will
      internally behave as though all responses from this backend had a
      "Cache-Control: public, max-age=[TTL]" header, regardless of any
      existing Cache-Control header. The actual headers served in responses
      will not be altered.
    signedUrlKeyNames: [Output Only] Names of the keys for signing request
      URLs.
  """

  class CacheModeValueValuesEnum(_messages.Enum):
    r"""Specifies the cache setting for all responses from this backend. The
    possible values are: USE_ORIGIN_HEADERS Requires the origin to set valid
    caching headers to cache content. Responses without these headers will not
    be cached at Google's edge, and will require a full trip to the origin on
    every request, potentially impacting performance and increasing load on
    the origin server. FORCE_CACHE_ALL Cache all content, ignoring any
    "private", "no-store" or "no-cache" directives in Cache-Control response
    headers. Warning: this may result in Cloud CDN caching private, per-user
    (user identifiable) content. CACHE_ALL_STATIC Automatically cache static
    content, including common image formats, media (video and audio), and web
    assets (JavaScript and CSS). Requests and responses that are marked as
    uncacheable, as well as dynamic content (including HTML), will not be
    cached.

    Values:
      CACHE_ALL_STATIC: Automatically cache static content, including common
        image formats, media (video and audio), and web assets (JavaScript and
        CSS). Requests and responses that are marked as uncacheable, as well
        as dynamic content (including HTML), will not be cached.
      FORCE_CACHE_ALL: Cache all content, ignoring any "private", "no-store"
        or "no-cache" directives in Cache-Control response headers. Warning:
        this may result in Cloud CDN caching private, per-user (user
        identifiable) content.
      INVALID_CACHE_MODE: <no description>
      USE_ORIGIN_HEADERS: Requires the origin to set valid caching headers to
        cache content. Responses without these headers will not be cached at
        Google's edge, and will require a full trip to the origin on every
        request, potentially impacting performance and increasing load on the
        origin server.
    """
    CACHE_ALL_STATIC = 0
    FORCE_CACHE_ALL = 1
    INVALID_CACHE_MODE = 2
    USE_ORIGIN_HEADERS = 3

  bypassCacheOnRequestHeaders = _messages.MessageField('BackendServiceCdnPolicyBypassCacheOnRequestHeader', 1, repeated=True)
  cacheKeyPolicy = _messages.MessageField('CacheKeyPolicy', 2)
  cacheMode = _messages.EnumField('CacheModeValueValuesEnum', 3)
  clientTtl = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  defaultTtl = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  maxTtl = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  negativeCaching = _messages.BooleanField(7)
  negativeCachingPolicy = _messages.MessageField('BackendServiceCdnPolicyNegativeCachingPolicy', 8, repeated=True)
  requestCoalescing = _messages.BooleanField(9)
  serveWhileStale = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  signedUrlCacheMaxAgeSec = _messages.IntegerField(11)
  signedUrlKeyNames = _messages.StringField(12, repeated=True)


class BackendServiceCdnPolicyBypassCacheOnRequestHeader(_messages.Message):
  r"""Bypass the cache when the specified request headers are present, e.g.
  Pragma or Authorization headers. Values are case insensitive. The presence
  of such a header overrides the cache_mode setting.

  Fields:
    headerName: The header field name to match on when bypassing cache. Values
      are case-insensitive.
  """

  headerName = _messages.StringField(1)


class BackendServiceCdnPolicyNegativeCachingPolicy(_messages.Message):
  r"""Specify CDN TTLs for response error codes.

  Fields:
    code: The HTTP status code to define a TTL against. Only HTTP status codes
      300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be
      specified as values, and you cannot specify a status code more than
      once.
    ttl: The TTL (in seconds) for which to cache responses with the
      corresponding status code. The maximum allowed value is 1800s (30
      minutes), noting that infrequently accessed objects may be evicted from
      the cache before the defined TTL.
  """

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  ttl = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class BackendServiceConnectionTrackingPolicy(_messages.Message):
  r"""Connection Tracking configuration for this BackendService.

  Enums:
    ConnectionPersistenceOnUnhealthyBackendsValueValuesEnum: Specifies
      connection persistence when backends are unhealthy. The default value is
      DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the existing
      connections persist on unhealthy backends only for connection-oriented
      protocols (TCP and SCTP) and only if the Tracking Mode is PER_CONNECTION
      (default tracking mode) or the Session Affinity is configured for
      5-tuple. They do not persist for UDP. If set to NEVER_PERSIST, after a
      backend becomes unhealthy, the existing connections on the unhealthy
      backend are never persisted on the unhealthy backend. They are always
      diverted to newly selected healthy backends (unless all backends are
      unhealthy). If set to ALWAYS_PERSIST, existing connections always
      persist on unhealthy backends regardless of protocol and session
      affinity. It is generally not recommended to use this mode overriding
      the default. For more details, see [Connection Persistence for Network
      Load Balancing](https://cloud.google.com/load-
      balancing/docs/network/networklb-backend-service#connection-persistence)
      and [Connection Persistence for Internal TCP/UDP Load
      Balancing](https://cloud.google.com/load-
      balancing/docs/internal#connection-persistence).
    TrackingModeValueValuesEnum: Specifies the key used for connection
      tracking. There are two options: - PER_CONNECTION: This is the default
      mode. The Connection Tracking is performed as per the Connection Key
      (default Hash Method) for the specific protocol. - PER_SESSION: The
      Connection Tracking is performed as per the configured Session Affinity.
      It matches the configured Session Affinity. For more details, see
      [Tracking Mode for Network Load
      Balancing](https://cloud.google.com/load-
      balancing/docs/network/networklb-backend-service#tracking-mode) and
      [Tracking Mode for Internal TCP/UDP Load
      Balancing](https://cloud.google.com/load-
      balancing/docs/internal#tracking-mode).

  Fields:
    connectionPersistenceOnUnhealthyBackends: Specifies connection persistence
      when backends are unhealthy. The default value is DEFAULT_FOR_PROTOCOL.
      If set to DEFAULT_FOR_PROTOCOL, the existing connections persist on
      unhealthy backends only for connection-oriented protocols (TCP and SCTP)
      and only if the Tracking Mode is PER_CONNECTION (default tracking mode)
      or the Session Affinity is configured for 5-tuple. They do not persist
      for UDP. If set to NEVER_PERSIST, after a backend becomes unhealthy, the
      existing connections on the unhealthy backend are never persisted on the
      unhealthy backend. They are always diverted to newly selected healthy
      backends (unless all backends are unhealthy). If set to ALWAYS_PERSIST,
      existing connections always persist on unhealthy backends regardless of
      protocol and session affinity. It is generally not recommended to use
      this mode overriding the default. For more details, see [Connection
      Persistence for Network Load Balancing](https://cloud.google.com/load-
      balancing/docs/network/networklb-backend-service#connection-persistence)
      and [Connection Persistence for Internal TCP/UDP Load
      Balancing](https://cloud.google.com/load-
      balancing/docs/internal#connection-persistence).
    enableStrongAffinity: Enable Strong Session Affinity for Network Load
      Balancing. This option is not available publicly.
    idleTimeoutSec: Specifies how long to keep a Connection Tracking entry
      while there is no matching traffic (in seconds). For Internal TCP/UDP
      Load Balancing: - The minimum (default) is 10 minutes and the maximum is
      16 hours. - It can be set only if Connection Tracking is less than
      5-tuple (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION, CLIENT_IP or
      CLIENT_IP_PROTO, and Tracking Mode is PER_SESSION). For Network Load
      Balancer the default is 60 seconds. This option is not available
      publicly.
    trackingMode: Specifies the key used for connection tracking. There are
      two options: - PER_CONNECTION: This is the default mode. The Connection
      Tracking is performed as per the Connection Key (default Hash Method)
      for the specific protocol. - PER_SESSION: The Connection Tracking is
      performed as per the configured Session Affinity. It matches the
      configured Session Affinity. For more details, see [Tracking Mode for
      Network Load Balancing](https://cloud.google.com/load-
      balancing/docs/network/networklb-backend-service#tracking-mode) and
      [Tracking Mode for Internal TCP/UDP Load
      Balancing](https://cloud.google.com/load-
      balancing/docs/internal#tracking-mode).
  """

  class ConnectionPersistenceOnUnhealthyBackendsValueValuesEnum(_messages.Enum):
    r"""Specifies connection persistence when backends are unhealthy. The
    default value is DEFAULT_FOR_PROTOCOL. If set to DEFAULT_FOR_PROTOCOL, the
    existing connections persist on unhealthy backends only for connection-
    oriented protocols (TCP and SCTP) and only if the Tracking Mode is
    PER_CONNECTION (default tracking mode) or the Session Affinity is
    configured for 5-tuple. They do not persist for UDP. If set to
    NEVER_PERSIST, after a backend becomes unhealthy, the existing connections
    on the unhealthy backend are never persisted on the unhealthy backend.
    They are always diverted to newly selected healthy backends (unless all
    backends are unhealthy). If set to ALWAYS_PERSIST, existing connections
    always persist on unhealthy backends regardless of protocol and session
    affinity. It is generally not recommended to use this mode overriding the
    default. For more details, see [Connection Persistence for Network Load
    Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-
    backend-service#connection-persistence) and [Connection Persistence for
    Internal TCP/UDP Load Balancing](https://cloud.google.com/load-
    balancing/docs/internal#connection-persistence).

    Values:
      ALWAYS_PERSIST: <no description>
      DEFAULT_FOR_PROTOCOL: <no description>
      NEVER_PERSIST: <no description>
    """
    ALWAYS_PERSIST = 0
    DEFAULT_FOR_PROTOCOL = 1
    NEVER_PERSIST = 2

  class TrackingModeValueValuesEnum(_messages.Enum):
    r"""Specifies the key used for connection tracking. There are two options:
    - PER_CONNECTION: This is the default mode. The Connection Tracking is
    performed as per the Connection Key (default Hash Method) for the specific
    protocol. - PER_SESSION: The Connection Tracking is performed as per the
    configured Session Affinity. It matches the configured Session Affinity.
    For more details, see [Tracking Mode for Network Load
    Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-
    backend-service#tracking-mode) and [Tracking Mode for Internal TCP/UDP
    Load Balancing](https://cloud.google.com/load-
    balancing/docs/internal#tracking-mode).

    Values:
      INVALID_TRACKING_MODE: <no description>
      PER_CONNECTION: <no description>
      PER_SESSION: <no description>
    """
    INVALID_TRACKING_MODE = 0
    PER_CONNECTION = 1
    PER_SESSION = 2

  connectionPersistenceOnUnhealthyBackends = _messages.EnumField('ConnectionPersistenceOnUnhealthyBackendsValueValuesEnum', 1)
  enableStrongAffinity = _messages.BooleanField(2)
  idleTimeoutSec = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  trackingMode = _messages.EnumField('TrackingModeValueValuesEnum', 4)


class BackendServiceFailoverPolicy(_messages.Message):
  r"""For load balancers that have configurable failover: [Internal TCP/UDP
  Load Balancing](https://cloud.google.com/load-
  balancing/docs/internal/failover-overview) and [external TCP/UDP Load
  Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-
  failover-overview). On failover or failback, this field indicates whether
  connection draining will be honored. Google Cloud has a fixed connection
  draining timeout of 10 minutes. A setting of true terminates existing TCP
  connections to the active pool during failover and failback, immediately
  draining traffic. A setting of false allows existing TCP connections to
  persist, even on VMs no longer in the active pool, for up to the duration of
  the connection draining timeout (10 minutes).

  Fields:
    disableConnectionDrainOnFailover: This can be set to true only if the
      protocol is TCP. The default is false.
    dropTrafficIfUnhealthy: If set to true, connections to the load balancer
      are dropped when all primary and all backup backend VMs are unhealthy.If
      set to false, connections are distributed among all primary VMs when all
      primary and all backup backend VMs are unhealthy. For load balancers
      that have configurable failover: [Internal TCP/UDP Load
      Balancing](https://cloud.google.com/load-
      balancing/docs/internal/failover-overview) and [external TCP/UDP Load
      Balancing](https://cloud.google.com/load-
      balancing/docs/network/networklb-failover-overview). The default is
      false.
    failoverRatio: The value of the field must be in the range [0, 1]. If the
      value is 0, the load balancer performs a failover when the number of
      healthy primary VMs equals zero. For all other values, the load balancer
      performs a failover when the total number of healthy primary VMs is less
      than this ratio. For load balancers that have configurable failover:
      [Internal TCP/UDP Load Balancing](https://cloud.google.com/load-
      balancing/docs/internal/failover-overview) and [external TCP/UDP Load
      Balancing](https://cloud.google.com/load-
      balancing/docs/network/networklb-failover-overview).
  """

  disableConnectionDrainOnFailover = _messages.BooleanField(1)
  dropTrafficIfUnhealthy = _messages.BooleanField(2)
  failoverRatio = _messages.FloatField(3, variant=_messages.Variant.FLOAT)


class BackendServiceGroupHealth(_messages.Message):
  r"""A BackendServiceGroupHealth object.

  Messages:
    AnnotationsValue: Metadata defined as annotations on the network endpoint
      group.

  Fields:
    annotations: Metadata defined as annotations on the network endpoint
      group.
    healthStatus: Health state of the backend instances or endpoints in
      requested instance or network endpoint group, determined based on
      configured health checks.
    kind: [Output Only] Type of resource. Always
      compute#backendServiceGroupHealth for the health of backend services.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Metadata defined as annotations on the network endpoint group.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  healthStatus = _messages.MessageField('HealthStatus', 2, repeated=True)
  kind = _messages.StringField(3, default='compute#backendServiceGroupHealth')


class BackendServiceIAP(_messages.Message):
  r"""Identity-Aware Proxy

  Fields:
    enabled: Whether the serving infrastructure will authenticate and
      authorize all incoming requests. If true, the oauth2ClientId and
      oauth2ClientSecret fields must be non-empty.
    oauth2ClientId: OAuth2 client ID to use for the authentication flow.
    oauth2ClientSecret: OAuth2 client secret to use for the authentication
      flow. For security reasons, this value cannot be retrieved via the API.
      Instead, the SHA-256 hash of the value is returned in the
      oauth2ClientSecretSha256 field. @InputOnly
    oauth2ClientSecretSha256: [Output Only] SHA256 hash value for the field
      oauth2_client_secret above.
  """

  enabled = _messages.BooleanField(1)
  oauth2ClientId = _messages.StringField(2)
  oauth2ClientSecret = _messages.StringField(3)
  oauth2ClientSecretSha256 = _messages.StringField(4)


class BackendServiceList(_messages.Message):
  r"""Contains a list of BackendService resources.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of BackendService resources.
    kind: [Output Only] Type of resource. Always compute#backendServiceList
      for lists of backend services.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: Warning about failed cleanup of transient changes made
          by a failed operation.
        DEPRECATED_RESOURCE_USED: A link to a deprecated resource was created.
        DEPRECATED_TYPE_USED: When deploying and at least one of the resources
          has a type marked as deprecated
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: The user created a boot disk that is
          larger than image size.
        EXPERIMENTAL_TYPE_USED: When deploying and at least one of the
          resources has a type marked as experimental
        EXTERNAL_API_WARNING: Warning that is present in an external api call
        FIELD_VALUE_OVERRIDEN: Warning that value of a field has been
          overridden. Deprecated unused field.
        INJECTED_KERNELS_DEPRECATED: The operation involved use of an injected
          kernel, which is deprecated.
        LARGE_DEPLOYMENT_WARNING: When deploying a deployment with a
          exceedingly large number of resources
        MISSING_TYPE_DEPENDENCY: A resource depends on a missing type
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: The route's nextHopIp address is not
          assigned to an instance on the network.
        NEXT_HOP_CANNOT_IP_FORWARD: The route's next hop instance cannot ip
          forward.
        NEXT_HOP_INSTANCE_NOT_FOUND: The route's nextHopInstance URL refers to
          an instance that does not exist.
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: The route's nextHopInstance URL
          refers to an instance that is not on the same network as the route.
        NEXT_HOP_NOT_RUNNING: The route's next hop instance does not have a
          status of RUNNING.
        NOT_CRITICAL_ERROR: Error which is not critical. We decided to
          continue the process despite the mentioned error.
        NO_RESULTS_ON_PAGE: No results are present on a particular list page.
        PARTIAL_SUCCESS: Success is reported, but some results may be missing
          due to errors
        REQUIRED_TOS_AGREEMENT: The user attempted to use a resource that
          requires a TOS they have not accepted.
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: Warning that a resource is
          in use.
        RESOURCE_NOT_DELETED: One or more of the resources set to auto-delete
          could not be deleted because they were in use.
        SCHEMA_VALIDATION_IGNORED: When a resource schema validation is
          ignored.
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: Instance template used in instance
          group manager is valid as such, but its application does not make a
          lot of sense, because it allows only single instance in instance
          group.
        UNDECLARED_PROPERTIES: When undeclared properties in the schema are
          present
        UNREACHABLE: A given scope cannot be reached.
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      LARGE_DEPLOYMENT_WARNING = 8
      MISSING_TYPE_DEPENDENCY = 9
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 10
      NEXT_HOP_CANNOT_IP_FORWARD = 11
      NEXT_HOP_INSTANCE_NOT_FOUND = 12
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 13
      NEXT_HOP_NOT_RUNNING = 14
      NOT_CRITICAL_ERROR = 15
      NO_RESULTS_ON_PAGE = 16
      PARTIAL_SUCCESS = 17
      REQUIRED_TOS_AGREEMENT = 18
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 19
      RESOURCE_NOT_DELETED = 20
      SCHEMA_VALIDATION_IGNORED = 21
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 22
      UNDECLARED_PROPERTIES = 23
      UNREACHABLE = 24

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('BackendService', 2, repeated=True)
  kind = _messages.StringField(3, default='compute#backendServiceList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class BackendServiceLogConfig(_messages.Message):
  r"""The available logging options for the load balancer traffic served by
  this backend service.

  Fields:
    enable: This field denotes whether to enable logging for the load balancer
      traffic served by this backend service.
    sampleRate: This field can only be specified if logging is enabled for
      this backend service. The value of the field must be in [0, 1]. This
      configures the sampling rate of requests to the load balancer where 1.0
      means all logged requests are reported and 0.0 means no logged requests
      are reported. The default value is 1.0.
  """

  enable = _messages.BooleanField(1)
  sampleRate = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class BackendServiceReference(_messages.Message):
  r"""A BackendServiceReference object.

  Fields:
    backendService: A string attribute.
  """

  backendService = _messages.StringField(1)


class BackendServicesScopedList(_messages.Message):
  r"""A BackendServicesScopedList object.

  Messages:
    WarningValue: Informational warning which replaces the list of backend
      services when the list is empty.

  Fields:
    backendServices: A list of BackendServices contained in this scope.
    warning: Informational warning which replaces the list of backend services
      when the list is empty.
  """

  class WarningValue(_messages.Message):
    r"""Informational warning which replaces the list of backend services when
    the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: Warning about failed cleanup of transient changes made
          by a failed operation.
        DEPRECATED_RESOURCE_USED: A link to a deprecated resource was created.
        DEPRECATED_TYPE_USED: When deploying and at least one of the resources
          has a type marked as deprecated
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: The user created a boot disk that is
          larger than image size.
        EXPERIMENTAL_TYPE_USED: When deploying and at least one of the
          resources has a type marked as experimental
        EXTERNAL_API_WARNING: Warning that is present in an external api call
        FIELD_VALUE_OVERRIDEN: Warning that value of a field has been
          overridden. Deprecated unused field.
        INJECTED_KERNELS_DEPRECATED: The operation involved use of an injected
          kernel, which is deprecated.
        LARGE_DEPLOYMENT_WARNING: When deploying a deployment with a
          exceedingly large number of resources
        MISSING_TYPE_DEPENDENCY: A resource depends on a missing type
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: The route's nextHopIp address is not
          assigned to an instance on the network.
        NEXT_HOP_CANNOT_IP_FORWARD: The route's next hop instance cannot ip
          forward.
        NEXT_HOP_INSTANCE_NOT_FOUND: The route's nextHopInstance URL refers to
          an instance that does not exist.
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: The route's nextHopInstance URL
          refers to an instance that is not on the same network as the route.
        NEXT_HOP_NOT_RUNNING: The route's next hop instance does not have a
          status of RUNNING.
        NOT_CRITICAL_ERROR: Error which is not critical. We decided to
          continue the process despite the mentioned error.
        NO_RESULTS_ON_PAGE: No results are present on a particular list page.
        PARTIAL_SUCCESS: Success is reported, but some results may be missing
          due to errors
        REQUIRED_TOS_AGREEMENT: The user attempted to use a resource that
          requires a TOS they have not accepted.
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: Warning that a resource is
          in use.
        RESOURCE_NOT_DELETED: One or more of the resources set to auto-delete
          could not be deleted because they were in use.
        SCHEMA_VALIDATION_IGNORED: When a resource schema validation is
          ignored.
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: Instance template used in instance
          group manager is valid as such, but its application does not make a
          lot of sense, because it allows only single instance in instance
          group.
        UNDECLARED_PROPERTIES: When undeclared properties in the schema are
          present
        UNREACHABLE: A given scope cannot be reached.
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      LARGE_DEPLOYMENT_WARNING = 8
      MISSING_TYPE_DEPENDENCY = 9
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 10
      NEXT_HOP_CANNOT_IP_FORWARD = 11
      NEXT_HOP_INSTANCE_NOT_FOUND = 12
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 13
      NEXT_HOP_NOT_RUNNING = 14
      NOT_CRITICAL_ERROR = 15
      NO_RESULTS_ON_PAGE = 16
      PARTIAL_SUCCESS = 17
      REQUIRED_TOS_AGREEMENT = 18
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 19
      RESOURCE_NOT_DELETED = 20
      SCHEMA_VALIDATION_IGNORED = 21
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 22
      UNDECLARED_PROPERTIES = 23
      UNREACHABLE = 24

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  backendServices = _messages.MessageField('BackendService', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class BfdPacket(_messages.Message):
  r"""A BfdPacket object.

  Enums:
    DiagnosticValueValuesEnum: The diagnostic code specifies the local
      system's reason for the last change in session state. This allows remote
      systems to determine the reason that the previous session failed, for
      example. These diagnostic codes are specified in section 4.1 of RFC5880
    StateValueValuesEnum: The current BFD session state as seen by the
      transmitting system. These states are specified in section 4.1 of
      RFC5880

  Fields:
    authenticationPresent: The Authentication Present bit of the BFD packet.
      This is specified in section 4.1 of RFC5880
    controlPlaneIndependent: The Control Plane Independent bit of the BFD
      packet. This is specified in section 4.1 of RFC5880
    demand: The demand bit of the BFD packet. This is specified in section 4.1
      of RFC5880
    diagnostic: The diagnostic code specifies the local system's reason for
      the last change in session state. This allows remote systems to
      determine the reason that the previous session failed, for example.
      These diagnostic codes are specified in section 4.1 of RFC5880
    final: The Final bit of the BFD packet. This is specified in section 4.1
      of RFC5880
    length: The length of the BFD Control packet in bytes. This is specified
      in section 4.1 of RFC5880
    minEchoRxIntervalMs: The Required Min Echo RX Interval value in the BFD
      packet. This is specified in section 4.1 of RFC5880
    minRxIntervalMs: The Required Min RX Interval value in the BFD packet.
      This is specified in section 4.1 of RFC5880
    minTxIntervalMs: The Desired Min TX Interval value in the BFD packet. This
      is specified in section 4.1 of RFC5880
    multiplier: The detection time multiplier of the BFD packet. This is
      specified in section 4.1 of RFC5880
    multipoint: The multipoint bit of the BFD packet. This is specified in
      section 4.1 of RFC5880
    myDiscriminator: The My Discriminator value in the BFD packet. This is
      specified in section 4.1 of RFC5880
    poll: The Poll bit of the BFD packet. This is specified in section 4.1 of
      RFC5880
    state: The current BFD session state as seen by the transmitting system.
      These states are specified in section 4.1 of RFC5880
    version: The version number of the BFD protocol, as specified in section
      4.1 of RFC5880.
    yourDiscriminator: The Your Discriminator value in the BFD packet. This is
      specified in section 4.1 of RFC5880
  """

  class DiagnosticValueValuesEnum(_messages.Enum):
    r"""The diagnostic code specifies the local system's reason for the last
    change in session state. This allows remote systems to determine the
    reason that the previous session failed, for example. These diagnostic
    codes are specified in section 4.1 of RFC5880

    Values:
      ADMINISTRATIVELY_DOWN: <no description>
      CONCATENATED_PATH_DOWN: <no description>
      CONTROL_DETECTION_TIME_EXPIRED: <no description>
      DIAGNOSTIC_UNSPECIFIED: <no description>
      ECHO_FUNCTION_FAILED: <no description>
      FORWARDING_PLANE_RESET: <no description>
      NEIGHBOR_SIGNALED_SESSION_DOWN: <no description>
      NO_DIAGNOSTIC: <no description>
      PATH_DOWN: <no description>
      REVERSE_CONCATENATED_PATH_DOWN: <no description>
    """
    ADMINISTRATIVELY_DOWN = 0
    CONCATENATED_PATH_DOWN = 1
    CONTROL_DETECTION_TIME_EXPIRED = 2
    DIAGNOSTIC_UNSPECIFIED = 3
    ECHO_FUNCTION_FAILED = 4
    FORWARDING_PLANE_RESET = 5
    NEIGHBOR_SIGNALED_SESSION_DOWN = 6
    NO_DIAGNOSTIC = 7
    PATH_DOWN = 8
    REVERSE_CONCATENATED_PATH_DOWN = 9

  class StateValueValuesEnum(_messages.Enum):
    r"""The current BFD session state as seen by the transmitting system.
    These states are specified in section 4.1 of RFC5880

    Values:
      ADMIN_DOWN: <no description>
      DOWN: <no description>
      INIT: <no description>
      STATE_UNSPECIFIED: <no description>
      UP: <no description>
    """
    ADMIN_DOWN = 0
    DOWN = 1
    INIT = 2
    STATE_UNSPECIFIED = 3
    UP = 4

  authenticationPresent = _messages.BooleanField(1)
  controlPlaneIndependent = _messages.BooleanField(2)
  demand = _messages.BooleanField(3)
  diagnostic = _messages.EnumField('DiagnosticValueValuesEnum', 4)
  final = _messages.BooleanField(5)
  length = _messages.IntegerField(6, variant=_messages.Variant.UINT32)
  minEchoRxIntervalMs = _messages.IntegerField(7, variant=_messages.Variant.UINT32)
  minRxIntervalMs = _messages.IntegerField(8, variant=_messages.Variant.UINT32)
  minTxIntervalMs = _messages.IntegerField(9, variant=_messages.Variant.UINT32)
  multiplier = _messages.IntegerField(10, variant=_messages.Variant.UINT32)
  multipoint = _messages.BooleanField(11)
  myDiscriminator = _messages.IntegerField(12, variant=_messages.Variant.UINT32)
  poll = _messages.BooleanField(13)
  state = _messages.EnumField('StateValueValuesEnum', 14)
  version = _messages.IntegerField(15, variant=_messages.Variant.UINT32)
  yourDiscriminator = _messages.IntegerField(16, variant=_messages.Variant.UINT32)


class BfdStatus(_messages.Message):
  r"""Next free: 15

  Enums:
    BfdSessionInitializationModeValueValuesEnum: The BFD session
      initialization mode for this BGP peer. If set to ACTIVE, the Cloud
      Router will initiate the BFD session for this BGP peer. If set to
      PASSIVE, the Cloud Router will wait for the peer router to initiate the
      BFD session for this BGP peer. If set to DISABLED, BFD is disabled for
      this BGP peer.
    LocalDiagnosticValueValuesEnum: The diagnostic code specifies the local
      system's reason for the last change in session state. This allows remote
      systems to determine the reason that the previous session failed, for
      example. These diagnostic codes are specified in section 4.1 of RFC5880
    LocalStateValueValuesEnum: The current BFD session state as seen by the
      transmitting system. These states are specified in section 4.1 of
      RFC5880

  Fields:
    bfdSessionInitializationMode: The BFD session initialization mode for this
      BGP peer. If set to ACTIVE, the Cloud Router will initiate the BFD
      session for this BGP peer. If set to PASSIVE, the Cloud Router will wait
      for the peer router to initiate the BFD session for this BGP peer. If
      set to DISABLED, BFD is disabled for this BGP peer.
    configUpdateTimestampMicros: Unix timestamp of the most recent config
      update.
    controlPacketCounts: Control packet counts for the current BFD session.
    controlPacketIntervals: Inter-packet time interval statistics for control
      packets.
    localDiagnostic: The diagnostic code specifies the local system's reason
      for the last change in session state. This allows remote systems to
      determine the reason that the previous session failed, for example.
      These diagnostic codes are specified in section 4.1 of RFC5880
    localState: The current BFD session state as seen by the transmitting
      system. These states are specified in section 4.1 of RFC5880
    negotiatedLocalControlTxIntervalMs: Negotiated transmit interval for
      control packets.
    rxPacket: The most recent Rx control packet for this BFD session.
    txPacket: The most recent Tx control packet for this BFD session.
    uptimeMs: Session uptime in milliseconds. Value will be 0 if session is
      not up.
  """

  class BfdSessionInitializationModeValueValuesEnum(_messages.Enum):
    r"""The BFD session initialization mode for this BGP peer. If set to
    ACTIVE, the Cloud Router will initiate the BFD session for this BGP peer.
    If set to PASSIVE, the Cloud Router will wait for the peer router to
    initiate the BFD session for this BGP peer. If set to DISABLED, BFD is
    disabled for this BGP peer.

    Values:
      ACTIVE: <no description>
      DISABLED: <no description>
      PASSIVE: <no description>
    """
    ACTIVE = 0
    DISABLED = 1
    PASSIVE = 2

  class LocalDiagnosticValueValuesEnum(_messages.Enum):
    r"""The diagnostic code specifies the local system's reason for the last
    change in session state. This allows remote systems to determine the
    reason that the previous session failed, for example. These diagnostic
    codes are specified in section 4.1 of RFC5880

    Values:
      ADMINISTRATIVELY_DOWN: <no description>
      CONCATENATED_PATH_DOWN: <no description>
      CONTROL_DETECTION_TIME_EXPIRED: <no description>
      DIAGNOSTIC_UNSPECIFIED: <no description>
      ECHO_FUNCTION_FAILED: <no description>
      FORWARDING_PLANE_RESET: <no description>
      NEIGHBOR_SIGNALED_SESSION_DOWN: <no description>
      NO_DIAGNOSTIC: <no description>
      PATH_DOWN: <no description>
      REVERSE_CONCATENATED_PATH_DOWN: <no description>
    """
    ADMINISTRATIVELY_DOWN = 0
    CONCATENATED_PATH_DOWN = 1
    CONTROL_DETECTION_TIME_EXPIRED = 2
    DIAGNOSTIC_UNSPECIFIED = 3
    ECHO_FUNCTION_FAILED = 4
    FORWARDING_PLANE_RESET = 5
    NEIGHBOR_SIGNALED_SESSION_DOWN = 6
    NO_DIAGNOSTIC = 7
    PATH_DOWN = 8
    REVERSE_CONCATENATED_PATH_DOWN = 9

  class LocalStateValueValuesEnum(_messages.Enum):
    r"""The current BFD session state as seen by the transmitting system.
    These states are specified in section 4.1 of RFC5880

    Values:
      ADMIN_DOWN: <no description>
      DOWN: <no description>
      INIT: <no description>
      STATE_UNSPECIFIED: <no description>
      UP: <no description>
    """
    ADMIN_DOWN = 0
    DOWN = 1
    INIT = 2
    STATE_UNSPECIFIED = 3
    UP = 4

  bfdSessionInitializationMode = _messages.EnumField('BfdSessionInitializationModeValueValuesEnum', 1)
  configUpdateTimestampMicros = _messages.IntegerField(2)
  controlPacketCounts = _messages.MessageField('BfdStatusPacketCounts', 3)
  controlPacketIntervals = _messages.MessageField('PacketIntervals', 4, repeated=True)
  localDiagnostic = _messages.EnumField('LocalDiagnosticValueValuesEnum', 5)
  localState = _messages.EnumField('LocalStateValueValuesEnum', 6)
  negotiatedLocalControlTxIntervalMs = _messages.IntegerField(7, variant=_messages.Variant.UINT32)
  rxPacket = _messages.MessageField('BfdPacket', 8)
  txPacket = _messages.MessageField('BfdPacket', 9)
  uptimeMs = _messages.IntegerField(10)


class BfdStatusPacketCounts(_messages.Message):
  r"""A BfdStatusPacketCounts object.

  Fields:
    numRx: Number of packets received since the beginning of the current BFD
      session.
    numRxRejected: Number of packets received that were rejected because of
      errors since the beginning of the current BFD session.
    numRxSuccessful: Number of packets received that were successfully
      processed since the beginning of the current BFD session.
    numTx: Number of packets transmitted since the beginning of the current
      BFD session.
  """

  numRx = _messages.IntegerField(1, variant=_messages.Variant.UINT32)
  numRxRejected = _messages.IntegerField(2, variant=_messages.Variant.UINT32)
  numRxSuccessful = _messages.IntegerField(3, variant=_messages.Variant.UINT32)
  numTx = _messages.IntegerField(4, variant=_messages.Variant.UINT32)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    bindingId: This is deprecated and has no effect. Do not use.
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Cloud Platform
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`.
  """

  bindingId = _messages.StringField(1)
  condition = _messages.MessageField('Expr', 2)
  members = _messages.StringField(3, repeated=True)
  role = _messages.StringField(4)


class BulkInsertInstanceResource(_messages.Message):
  r"""A transient resource used in compute.instances.bulkInsert and
  compute.regionInstances.bulkInsert . This resource is not persisted
  anywhere, it is used only for processing the requests.

  Messages:
    PerInstancePropertiesValue: Per-instance properties to be set on
      individual instances. Keys of this map specify requested instance names.
      Can be empty if name_pattern is used.

  Fields:
    count: The maximum number of instances to create.
    instanceProperties: The instance properties defining the VM instances to
      be created. Required if sourceInstanceTemplate is not provided.
    locationPolicy: Policy for chosing target zone.
    minCount: The minimum number of instances to create. If no min_count is
      specified then count is used as the default value. If min_count
      instances cannot be created, then no instances will be created and
      instances already created will be deleted.
    namePattern: The string pattern used for the names of the VMs. Either
      name_pattern or per_instance_properties must be set. The pattern must
      contain one continuous sequence of placeholder hash characters (#) with
      each character corresponding to one digit of the generated instance
      name. Example: a name_pattern of inst-#### generates instance names such
      as inst-0001 and inst-0002. If existing instances in the same project
      and zone have names that match the name pattern then the generated
      instance numbers start after the biggest existing number. For example,
      if there exists an instance with name inst-0050, then instance names
      generated using the pattern inst-#### begin with inst-0051. The name
      pattern placeholder #...# can contain up to 18 characters.
    perInstanceProperties: Per-instance properties to be set on individual
      instances. Keys of this map specify requested instance names. Can be
      empty if name_pattern is used.
    sourceInstanceTemplate: Specifies the instance template from which to
      create instances. You may combine sourceInstanceTemplate with
      instanceProperties to override specific values from an existing instance
      template. Bulk API follows the semantics of JSON Merge Patch described
      by RFC 7396. It can be a full or partial URL. For example, the following
      are all valid URLs to an instance template: -
      https://www.googleapis.com/compute/v1/projects/project
      /global/instanceTemplates/instanceTemplate -
      projects/project/global/instanceTemplates/instanceTemplate -
      global/instanceTemplates/instanceTemplate This field is optional.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PerInstancePropertiesValue(_messages.Message):
    r"""Per-instance properties to be set on individual instances. Keys of
    this map specify requested instance names. Can be empty if name_pattern is
    used.

    Messages:
      AdditionalProperty: An additional property for a
        PerInstancePropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type
        PerInstancePropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PerInstancePropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A BulkInsertInstanceResourcePerInstanceProperties attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('BulkInsertInstanceResourcePerInstanceProperties', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  count = _messages.IntegerField(1)
  instanceProperties = _messages.MessageField('InstanceProperties', 2)
  locationPolicy = _messages.MessageField('LocationPolicy', 3)
  minCount = _messages.IntegerField(4)
  namePattern = _messages.StringField(5)
  perInstanceProperties = _messages.MessageField('PerInstancePropertiesValue', 6)
  sourceInstanceTemplate = _messages.StringField(7)


class BulkInsertInstanceResourcePerInstanceProperties(_messages.Message):
  r"""Per-instance properties to be set on individual instances. To be
  extended in the future.

  Fields:
    name: This field is only temporary. It will be removed. Do not use it.
  """

  name = _messages.StringField(1)


class CacheInvalidationRule(_messages.Message):
  r"""A CacheInvalidationRule object.

  Fields:
    host: If set, this invalidation rule will only apply to requests with a
      Host header matching host.
    path: A string attribute.
  """

  host = _messages.StringField(1)
  path = _messages.StringField(2)


class CacheKeyPolicy(_messages.Message):
  r"""Message containing what to include in the cache key for a request for
  Cloud CDN.

  Fields:
    includeHost: If true, requests to different hosts will be cached
      separately.
    includeHttpHeaders: Allows HTTP request headers (by name) to be used in
      the cache key.
    includeNamedCookies: Allows HTTP cookies (by name) to be used in the cache
      key. The name=value pair will be used in the cache key Cloud CDN
      generates.
    includeProtocol: If true, http and https requests will be cached
      separately.
    includeQueryString: If true, include query string parameters in the cache
      key according to query_string_whitelist and query_string_blacklist. If
      neither is set, the entire query string will be included. If false, the
      query string will be excluded from the cache key entirely.
    queryStringBlacklist: Names of query string parameters to exclude in cache
      keys. All other parameters will be included. Either specify
      query_string_whitelist or query_string_blacklist, not both. '&' and '='
      will be percent encoded and not treated as delimiters.
    queryStringWhitelist: Names of query string parameters to include in cache
      keys. All other parameters will be excluded. Either specify
      query_string_whitelist or query_string_blacklist, not both. '&' and '='
      will be percent encoded and not treated as delimiters.
  """

  includeHost = _messages.BooleanField(1)
  includeHttpHeaders = _messages.StringField(2, repeated=True)
  includeNamedCookies = _messages.StringField(3, repeated=True)
  includeProtocol = _messages.BooleanField(4)
  includeQueryString = _messages.BooleanField(5)
  queryStringBlacklist = _messages.StringField(6, repeated=True)
  queryStringWhitelist = _messages.StringField(7, repeated=True)


class CircuitBreakers(_messages.Message):
  r"""Settings controlling the volume of requests, connections and retries to
  this backend service.

  Fields:
    connectTimeout: The timeout for new network connections to hosts.
    maxConnections: Not supported when the backend service is referenced by a
      URL map that is bound to target gRPC proxy that has validateForProxyless
      field set to true.
    maxPendingRequests: Not supported when the backend service is referenced
      by a URL map that is bound to target gRPC proxy that has
      validateForProxyless field set to true.
    maxRequests: The maximum number of parallel requests that allowed to the
      backend service. If not specified, there is no limit.
    maxRequestsPerConnection: Not supported when the backend service is
      referenced by a URL map that is bound to target gRPC proxy that has
      validateForProxyless field set to true.
    maxRetries: Not supported when the backend service is referenced by a URL
      map that is bound to target gRPC proxy that has validateForProxyless
      field set to true.
  """

  connectTimeout = _messages.MessageField('Duration', 1)
  maxConnections = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  maxPendingRequests = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  maxRequests = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  maxRequestsPerConnection = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  maxRetries = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class Commitment(_messages.Message):
  r"""Represents a regional Commitment resource. Creating a commitment
  resource means that you are purchasing a committed use contract with an
  explicit start and end time. You can create commitments based on vCPUs and
  memory usage and receive discounted rates. For full details, read Signing Up
  for Committed Use Discounts.

  Enums:
    CategoryValueValuesEnum: The category of the commitment. Category MACHINE
      specifies commitments composed of machine resources such as VCPU or
      MEMORY, listed in resources. Category LICENSE specifies commitments
      composed of software licenses, listed in licenseResources. Note that
      only MACHINE commitments should have a Type specified.
    PlanValueValuesEnum: The plan for this commitment, which determines
      duration and discount rate. The currently supported plans are
      TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
    StatusValueValuesEnum: [Output Only] Status of the commitment with regards
      to eventual expiration (each commitment has an end date defined). One of
      the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
    TypeValueValuesEnum: The type of commitment, which affects the discount
      rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a
      commitment that will only apply to memory optimized machines. Type
      ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to
      accelerator optimized machines.

  Fields:
    autoRenew: Specifies whether to enable automatic renewal for the
      commitment. The default value is false if not specified. The field can
      be updated until the day of the commitment expiration at 12:00am PST. If
      the field is set to true, the commitment will be automatically renewed
      for either one or three years according to the terms of the existing
      commitment.
    category: The category of the commitment. Category MACHINE specifies
      commitments composed of machine resources such as VCPU or MEMORY, listed
      in resources. Category LICENSE specifies commitments composed of
      software licenses, listed in licenseResources. Note that only MACHINE
      commitments should have a Type specified.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    endTimestamp: [Output Only] Commitment end time in RFC3339 text format.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#commitment for
      commitments.
    licenseResource: The license specification required as part of a license
      commitment.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    plan: The plan for this commitment, which determines duration and discount
      rate. The currently supported plans are TWELVE_MONTH (1 year), and
      THIRTY_SIX_MONTH (3 years).
    region: [Output Only] URL of the region where this commitment may be used.
    reservations: List of reservations in this commitment.
    resources: A list of commitment amounts for particular resources. Note
      that VCPU and MEMORY resource commitments must occur together.
    selfLink: [Output Only] Server-defined URL for the resource.
    startTimestamp: [Output Only] Commitment start time in RFC3339 text
      format.
    status: [Output Only] Status of the commitment with regards to eventual
      expiration (each commitment has an end date defined). One of the
      following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
    statusMessage: [Output Only] An optional, human-readable explanation of
      the status.
    type: The type of commitment, which affects the discount rate and the
      eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that
      will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED
      specifies a commitment that will only apply to accelerator optimized
      machines.
  """

  class CategoryValueValuesEnum(_messages.Enum):
    r"""The category of the commitment. Category MACHINE specifies commitments
    composed of machine resources such as VCPU or MEMORY, listed in resources.
    Category LICENSE specifies commitments composed of software licenses,
    listed in licenseResources. Note that only MACHINE commitments should have
    a Type specified.

    Values:
      CATEGORY_UNSPECIFIED: <no description>
      LICENSE: <no description>
      MACHINE: <no description>
    """
    CATEGORY_UNSPECIFIED = 0
    LICENSE = 1
    MACHINE = 2

  class PlanValueValuesEnum(_messages.Enum):
    r"""The plan for this commitment, which determines duration and discount
    rate. The currently supported plans are TWELVE_MONTH (1 year), and
    THIRTY_SIX_MONTH (3 years).

    Values:
      INVALID: <no description>
      THIRTY_SIX_MONTH: <no description>
      TWELVE_MONTH: <no description>
    """
    INVALID = 0
    THIRTY_SIX_MONTH = 1
    TWELVE_MONTH = 2

  class StatusValueValuesEnum(_messages.Enum):
    r"""[Output Only] Status of the commitment with regards to eventual
    expiration (each commitment has an end date defined). One of the following
    values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.

    Values:
      ACTIVE: <no description>
      CREATING: <no description>
      EXPIRED: <no description>
      NOT_YET_ACTIVE: <no description>
    """
    ACTIVE = 0
    CREATING = 1
    EXPIRED = 2
    NOT_YET_ACTIVE = 3

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of commitment, which affects the discount rate and the
    eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will
    only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED
    specifies a commitment that will only apply to accelerator optimized
    machines.

    Values:
      ACCELERATOR_OPTIMIZED: <no description>
      COMPUTE_OPTIMIZED: <no description>
      COMPUTE_OPTIMIZED_C2D: <no description>
      GENERAL_PURPOSE: <no description>
      GENERAL_PURPOSE_E2: <no description>
      GENERAL_PURPOSE_N2: <no description>
      GENERAL_PURPOSE_N2D: <no description>
      GENERAL_PURPOSE_T2D: <no description>
      MEMORY_OPTIMIZED: <no description>
      TYPE_UNSPECIFIED: <no description>
    """
    ACCELERATOR_OPTIMIZED = 0
    COMPUTE_OPTIMIZED = 1
    COMPUTE_OPTIMIZED_C2D = 2
    GENERAL_PURPOSE = 3
    GENERAL_PURPOSE_E2 = 4
    GENERAL_PURPOSE_N2 = 5
    GENERAL_PURPOSE_N2D = 6
    GENERAL_PURPOSE_T2D = 7
    MEMORY_OPTIMIZED = 8
    TYPE_UNSPECIFIED = 9

  autoRenew = _messages.BooleanField(1)
  category = _messages.EnumField('CategoryValueValuesEnum', 2)
  creationTimestamp = _messages.StringField(3)
  description = _messages.StringField(4)
  endTimestamp = _messages.StringField(5)
  id = _messages.IntegerField(6, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(7, default='compute#commitment')
  licenseResource = _messages.MessageField('LicenseResourceCommitment', 8)
  name = _messages.StringField(9)
  plan = _messages.EnumField('PlanValueValuesEnum', 10)
  region = _messages.StringField(11)
  reservations = _messages.MessageField('Reservation', 12, repeated=True)
  resources = _messages.MessageField('ResourceCommitment', 13, repeated=True)
  selfLink = _messages.StringField(14)
  startTimestamp = _messages.StringField(15)
  status = _messages.EnumField('StatusValueValuesEnum', 16)
  statusMessage = _messages.StringField(17)
  type = _messages.EnumField('TypeValueValuesEnum', 18)


class CommitmentAggregatedList(_messages.Message):
  r"""A CommitmentAggregatedList object.

  Messages:
    ItemsValue: A list of CommitmentsScopedList resources.
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of CommitmentsScopedList resources.
    kind: [Output Only] Type of resource. Always
      compute#commitmentAggregatedList for aggregated lists of commitments.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    unreachables: [Output Only] Unreachable resources.
    warning: [Output Only] Informational warning message.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    r"""A list of CommitmentsScopedList resources.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of commitments.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A CommitmentsScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('CommitmentsScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: Warning about failed cleanup of transient changes made
          by a failed operation.
        DEPRECATED_RESOURCE_USED: A link to a deprecated resource was created.
        DEPRECATED_TYPE_USED: When deploying and at least one of the resources
          has a type marked as deprecated
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: The user created a boot disk that is
          larger than image size.
        EXPERIMENTAL_TYPE_USED: When deploying and at least one of the
          resources has a type marked as experimental
        EXTERNAL_API_WARNING: Warning that is present in an external api call
        FIELD_VALUE_OVERRIDEN: Warning that value of a field has been
          overridden. Deprecated unused field.
        INJECTED_KERNELS_DEPRECATED: The operation involved use of an injected
          kernel, which is deprecated.
        LARGE_DEPLOYMENT_WARNING: When deploying a deployment with a
          exceedingly large number of resources
        MISSING_TYPE_DEPENDENCY: A resource depends on a missing type
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: The route's nextHopIp address is not
          assigned to an instance on the network.
        NEXT_HOP_CANNOT_IP_FORWARD: The route's next hop instance cannot ip
          forward.
        NEXT_HOP_INSTANCE_NOT_FOUND: The route's nextHopInstance URL refers to
          an instance that does not exist.
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: The route's nextHopInstance URL
          refers to an instance that is not on the same network as the route.
        NEXT_HOP_NOT_RUNNING: The route's next hop instance does not have a
          status of RUNNING.
        NOT_CRITICAL_ERROR: Error which is not critical. We decided to
          continue the process despite the mentioned error.
        NO_RESULTS_ON_PAGE: No results are present on a particular list page.
        PARTIAL_SUCCESS: Success is reported, but some results may be missing
          due to errors
        REQUIRED_TOS_AGREEMENT: The user attempted to use a resource that
          requires a TOS they have not accepted.
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: Warning that a resource is
          in use.
        RESOURCE_NOT_DELETED: One or more of the resources set to auto-delete
          could not be deleted because they were in use.
        SCHEMA_VALIDATION_IGNORED: When a resource schema validation is
          ignored.
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: Instance template used in instance
          group manager is valid as such, but its application does not make a
          lot of sense, because it allows only single instance in instance
          group.
        UNDECLARED_PROPERTIES: When undeclared properties in the schema are
          present
        UNREACHABLE: A given scope cannot be reached.
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      LARGE_DEPLOYMENT_WARNING = 8
      MISSING_TYPE_DEPENDENCY = 9
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 10
      NEXT_HOP_CANNOT_IP_FORWARD = 11
      NEXT_HOP_INSTANCE_NOT_FOUND = 12
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 13
      NEXT_HOP_NOT_RUNNING = 14
      NOT_CRITICAL_ERROR = 15
      NO_RESULTS_ON_PAGE = 16
      PARTIAL_SUCCESS = 17
      REQUIRED_TOS_AGREEMENT = 18
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 19
      RESOURCE_NOT_DELETED = 20
      SCHEMA_VALIDATION_IGNORED = 21
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 22
      UNDECLARED_PROPERTIES = 23
      UNREACHABLE = 24

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default='compute#commitmentAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  unreachables = _messages.StringField(6, repeated=True)
  warning = _messages.MessageField('WarningValue', 7)


class CommitmentList(_messages.Message):
  r"""Contains a list of Commitment resources.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of Commitment resources.
    kind: [Output Only] Type of resource. Always compute#commitmentList for
      lists of commitments.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: Warning about failed cleanup of transient changes made
          by a failed operation.
        DEPRECATED_RESOURCE_USED: A link to a deprecated resource was created.
        DEPRECATED_TYPE_USED: When deploying and at least one of the resources
          has a type marked as deprecated
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: The user created a boot disk that is
          larger than image size.
        EXPERIMENTAL_TYPE_USED: When deploying and at least one of the
          resources has a type marked as experimental
        EXTERNAL_API_WARNING: Warning that is present in an external api call
        FIELD_VALUE_OVERRIDEN: Warning that value of a field has been
          overridden. Deprecated unused field.
        INJECTED_KERNELS_DEPRECATED: The operation involved use of an injected
          kernel, which is deprecated.
        LARGE_DEPLOYMENT_WARNING: When deploying a deployment with a
          exceedingly large number of resources
        MISSING_TYPE_DEPENDENCY: A resource depends on a missing type
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: The route's nextHopIp address is not
          assigned to an instance on the network.
        NEXT_HOP_CANNOT_IP_FORWARD: The route's next hop instance cannot ip
          forward.
        NEXT_HOP_INSTANCE_NOT_FOUND: The route's nextHopInstance URL refers to
          an instance that does not exist.
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: The route's nextHopInstance URL
          refers to an instance that is not on the same network as the route.
        NEXT_HOP_NOT_RUNNING: The route's next hop instance does not have a
          status of RUNNING.
        NOT_CRITICAL_ERROR: Error which is not critical. We decided to
          continue the process despite the mentioned error.
        NO_RESULTS_ON_PAGE: No results are present on a particular list page.
        PARTIAL_SUCCESS: Success is reported, but some results may be missing
          due to errors
        REQUIRED_TOS_AGREEMENT: The user attempted to use a resource that
          requires a TOS they have not accepted.
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: Warning that a resource is
          in use.
        RESOURCE_NOT_DELETED: One or more of the resources set to auto-delete
          could not be deleted because they were in use.
        SCHEMA_VALIDATION_IGNORED: When a resource schema validation is
          ignored.
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: Instance template used in instance
          group manager is valid as such, but its application does not make a
          lot of sense, because it allows only single instance in instance
          group.
        UNDECLARED_PROPERTIES: When undeclared properties in the schema are
          present
        UNREACHABLE: A given scope cannot be reached.
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      LARGE_DEPLOYMENT_WARNING = 8
      MISSING_TYPE_DEPENDENCY = 9
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 10
      NEXT_HOP_CANNOT_IP_FORWARD = 11
      NEXT_HOP_INSTANCE_NOT_FOUND = 12
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 13
      NEXT_HOP_NOT_RUNNING = 14
      NOT_CRITICAL_ERROR = 15
      NO_RESULTS_ON_PAGE = 16
      PARTIAL_SUCCESS = 17
      REQUIRED_TOS_AGREEMENT = 18
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 19
      RESOURCE_NOT_DELETED = 20
      SCHEMA_VALIDATION_IGNORED = 21
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 22
      UNDECLARED_PROPERTIES = 23
      UNREACHABLE = 24

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('Commitment', 2, repeated=True)
  kind = _messages.StringField(3, default='compute#commitmentList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class CommitmentsScopedList(_messages.Message):
  r"""A CommitmentsScopedList object.

  Messages:
    WarningValue: [Output Only] Informational warning which replaces the list
      of commitments when the list is empty.

  Fields:
    commitments: [Output Only] A list of commitments contained in this scope.
    warning: [Output Only] Informational warning which replaces the list of
      commitments when the list is empty.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning which replaces the list of
    commitments when the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: Warning about failed cleanup of transient changes made
          by a failed operation.
        DEPRECATED_RESOURCE_USED: A link to a deprecated resource was created.
        DEPRECATED_TYPE_USED: When deploying and at least one of the resources
          has a type marked as deprecated
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: The user created a boot disk that is
          larger than image size.
        EXPERIMENTAL_TYPE_USED: When deploying and at least one of the
          resources has a type marked as experimental
        EXTERNAL_API_WARNING: Warning that is present in an external api call
        FIELD_VALUE_OVERRIDEN: Warning that value of a field has been
          overridden. Deprecated unused field.
        INJECTED_KERNELS_DEPRECATED: The operation involved use of an injected
          kernel, which is deprecated.
        LARGE_DEPLOYMENT_WARNING: When deploying a deployment with a
          exceedingly large number of resources
        MISSING_TYPE_DEPENDENCY: A resource depends on a missing type
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: The route's nextHopIp address is not
          assigned to an instance on the network.
        NEXT_HOP_CANNOT_IP_FORWARD: The route's next hop instance cannot ip
          forward.
        NEXT_HOP_INSTANCE_NOT_FOUND: The route's nextHopInstance URL refers to
          an instance that does not exist.
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: The route's nextHopInstance URL
          refers to an instance that is not on the same network as the route.
        NEXT_HOP_NOT_RUNNING: The route's next hop instance does not have a
          status of RUNNING.
        NOT_CRITICAL_ERROR: Error which is not critical. We decided to
          continue the process despite the mentioned error.
        NO_RESULTS_ON_PAGE: No results are present on a particular list page.
        PARTIAL_SUCCESS: Success is reported, but some results may be missing
          due to errors
        REQUIRED_TOS_AGREEMENT: The user attempted to use a resource that
          requires a TOS they have not accepted.
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: Warning that a resource is
          in use.
        RESOURCE_NOT_DELETED: One or more of the resources set to auto-delete
          could not be deleted because they were in use.
        SCHEMA_VALIDATION_IGNORED: When a resource schema validation is
          ignored.
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: Instance template used in instance
          group manager is valid as such, but its application does not make a
          lot of sense, because it allows only single instance in instance
          group.
        UNDECLARED_PROPERTIES: When undeclared properties in the schema are
          present
        UNREACHABLE: A given scope cannot be reached.
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      LARGE_DEPLOYMENT_WARNING = 8
      MISSING_TYPE_DEPENDENCY = 9
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 10
      NEXT_HOP_CANNOT_IP_FORWARD = 11
      NEXT_HOP_INSTANCE_NOT_FOUND = 12
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 13
      NEXT_HOP_NOT_RUNNING = 14
      NOT_CRITICAL_ERROR = 15
      NO_RESULTS_ON_PAGE = 16
      PARTIAL_SUCCESS = 17
      REQUIRED_TOS_AGREEMENT = 18
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 19
      RESOURCE_NOT_DELETED = 20
      SCHEMA_VALIDATION_IGNORED = 21
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 22
      UNDECLARED_PROPERTIES = 23
      UNREACHABLE = 24

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  commitments = _messages.MessageField('Commitment', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class ComputeAcceleratorTypesAggregatedListRequest(_messages.Message):
  r"""A ComputeAcceleratorTypesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeAcceleratorTypesGetRequest(_messages.Message):
  r"""A ComputeAcceleratorTypesGetRequest object.

  Fields:
    acceleratorType: Name of the accelerator type to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  acceleratorType = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeAcceleratorTypesListRequest(_messages.Message):
  r"""A ComputeAcceleratorTypesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)
  zone = _messages.StringField(7, required=True)


class ComputeAddressesAggregatedListRequest(_messages.Message):
  r"""A ComputeAddressesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeAddressesDeleteRequest(_messages.Message):
  r"""A ComputeAddressesDeleteRequest object.

  Fields:
    address: Name of the address resource to delete.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  address = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeAddressesGetRequest(_messages.Message):
  r"""A ComputeAddressesGetRequest object.

  Fields:
    address: Name of the address resource to return.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  address = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeAddressesInsertRequest(_messages.Message):
  r"""A ComputeAddressesInsertRequest object.

  Fields:
    address: A Address resource to be passed as the request body.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  address = _messages.MessageField('Address', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeAddressesListRequest(_messages.Message):
  r"""A ComputeAddressesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeAddressesSetLabelsRequest(_messages.Message):
  r"""A ComputeAddressesSetLabelsRequest object.

  Fields:
    project: Project ID for this request.
    region: The region for this request.
    regionSetLabelsRequest: A RegionSetLabelsRequest resource to be passed as
      the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    resource: Name or id of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionSetLabelsRequest = _messages.MessageField('RegionSetLabelsRequest', 3)
  requestId = _messages.StringField(4)
  resource = _messages.StringField(5, required=True)


class ComputeAddressesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeAddressesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeAutoscalersAggregatedListRequest(_messages.Message):
  r"""A ComputeAutoscalersAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeAutoscalersDeleteRequest(_messages.Message):
  r"""A ComputeAutoscalersDeleteRequest object.

  Fields:
    autoscaler: Name of the autoscaler to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: Name of the zone for this request.
  """

  autoscaler = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeAutoscalersGetRequest(_messages.Message):
  r"""A ComputeAutoscalersGetRequest object.

  Fields:
    autoscaler: Name of the autoscaler to return.
    project: Project ID for this request.
    zone: Name of the zone for this request.
  """

  autoscaler = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeAutoscalersInsertRequest(_messages.Message):
  r"""A ComputeAutoscalersInsertRequest object.

  Fields:
    autoscaler: A Autoscaler resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: Name of the zone for this request.
  """

  autoscaler = _messages.MessageField('Autoscaler', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeAutoscalersListRequest(_messages.Message):
  r"""A ComputeAutoscalersListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: Name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)
  zone = _messages.StringField(7, required=True)


class ComputeAutoscalersPatchRequest(_messages.Message):
  r"""A ComputeAutoscalersPatchRequest object.

  Fields:
    autoscaler: Name of the autoscaler to patch.
    autoscalerResource: A Autoscaler resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: Name of the zone for this request.
  """

  autoscaler = _messages.StringField(1)
  autoscalerResource = _messages.MessageField('Autoscaler', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeAutoscalersTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeAutoscalersTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeAutoscalersUpdateRequest(_messages.Message):
  r"""A ComputeAutoscalersUpdateRequest object.

  Fields:
    autoscaler: Name of the autoscaler to update.
    autoscalerResource: A Autoscaler resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: Name of the zone for this request.
  """

  autoscaler = _messages.StringField(1)
  autoscalerResource = _messages.MessageField('Autoscaler', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeBackendBucketsAddSignedUrlKeyRequest(_messages.Message):
  r"""A ComputeBackendBucketsAddSignedUrlKeyRequest object.

  Fields:
    backendBucket: Name of the BackendBucket resource to which the Signed URL
      Key should be added. The name should conform to RFC1035.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    signedUrlKey: A SignedUrlKey resource to be passed as the request body.
  """

  backendBucket = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  signedUrlKey = _messages.MessageField('SignedUrlKey', 4)


class ComputeBackendBucketsDeleteRequest(_messages.Message):
  r"""A ComputeBackendBucketsDeleteRequest object.

  Fields:
    backendBucket: Name of the BackendBucket resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  backendBucket = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeBackendBucketsDeleteSignedUrlKeyRequest(_messages.Message):
  r"""A ComputeBackendBucketsDeleteSignedUrlKeyRequest object.

  Fields:
    backendBucket: Name of the BackendBucket resource to which the Signed URL
      Key should be added. The name should conform to RFC1035.
    keyName: The name of the Signed URL Key to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  backendBucket = _messages.StringField(1, required=True)
  keyName = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeBackendBucketsGetIamPolicyRequest(_messages.Message):
  r"""A ComputeBackendBucketsGetIamPolicyRequest object.

  Fields:
    optionsRequestedPolicyVersion: Requested IAM Policy version.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
  """

  optionsRequestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeBackendBucketsGetRequest(_messages.Message):
  r"""A ComputeBackendBucketsGetRequest object.

  Fields:
    backendBucket: Name of the BackendBucket resource to return.
    project: Project ID for this request.
  """

  backendBucket = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeBackendBucketsInsertRequest(_messages.Message):
  r"""A ComputeBackendBucketsInsertRequest object.

  Fields:
    backendBucket: A BackendBucket resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  backendBucket = _messages.MessageField('BackendBucket', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeBackendBucketsListRequest(_messages.Message):
  r"""A ComputeBackendBucketsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeBackendBucketsPatchRequest(_messages.Message):
  r"""A ComputeBackendBucketsPatchRequest object.

  Fields:
    backendBucket: Name of the BackendBucket resource to patch.
    backendBucketResource: A BackendBucket resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  backendBucket = _messages.StringField(1, required=True)
  backendBucketResource = _messages.MessageField('BackendBucket', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeBackendBucketsSetEdgeSecurityPolicyRequest(_messages.Message):
  r"""A ComputeBackendBucketsSetEdgeSecurityPolicyRequest object.

  Fields:
    backendBucket: Name of the BackendService resource to which the security
      policy should be set. The name should conform to RFC1035.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    securityPolicyReference: A SecurityPolicyReference resource to be passed
      as the request body.
  """

  backendBucket = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  securityPolicyReference = _messages.MessageField('SecurityPolicyReference', 4)


class ComputeBackendBucketsSetIamPolicyRequest(_messages.Message):
  r"""A ComputeBackendBucketsSetIamPolicyRequest object.

  Fields:
    globalSetPolicyRequest: A GlobalSetPolicyRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
  """

  globalSetPolicyRequest = _messages.MessageField('GlobalSetPolicyRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeBackendBucketsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeBackendBucketsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeBackendBucketsUpdateRequest(_messages.Message):
  r"""A ComputeBackendBucketsUpdateRequest object.

  Fields:
    backendBucket: Name of the BackendBucket resource to update.
    backendBucketResource: A BackendBucket resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  backendBucket = _messages.StringField(1, required=True)
  backendBucketResource = _messages.MessageField('BackendBucket', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeBackendServicesAddSignedUrlKeyRequest(_messages.Message):
  r"""A ComputeBackendServicesAddSignedUrlKeyRequest object.

  Fields:
    backendService: Name of the BackendService resource to which the Signed
      URL Key should be added. The name should conform to RFC1035.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    signedUrlKey: A SignedUrlKey resource to be passed as the request body.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  signedUrlKey = _messages.MessageField('SignedUrlKey', 4)


class ComputeBackendServicesAggregatedListRequest(_messages.Message):
  r"""A ComputeBackendServicesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Name of the project scoping this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeBackendServicesDeleteRequest(_messages.Message):
  r"""A ComputeBackendServicesDeleteRequest object.

  Fields:
    backendService: Name of the BackendService resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeBackendServicesDeleteSignedUrlKeyRequest(_messages.Message):
  r"""A ComputeBackendServicesDeleteSignedUrlKeyRequest object.

  Fields:
    backendService: Name of the BackendService resource to which the Signed
      URL Key should be added. The name should conform to RFC1035.
    keyName: The name of the Signed URL Key to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.StringField(1, required=True)
  keyName = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeBackendServicesGetHealthRequest(_messages.Message):
  r"""A ComputeBackendServicesGetHealthRequest object.

  Fields:
    backendService: Name of the BackendService resource to which the queried
      instance belongs.
    project: A string attribute.
    resourceGroupReference: A ResourceGroupReference resource to be passed as
      the request body.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  resourceGroupReference = _messages.MessageField('ResourceGroupReference', 3)


class ComputeBackendServicesGetIamPolicyRequest(_messages.Message):
  r"""A ComputeBackendServicesGetIamPolicyRequest object.

  Fields:
    optionsRequestedPolicyVersion: Requested IAM Policy version.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
  """

  optionsRequestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeBackendServicesGetRequest(_messages.Message):
  r"""A ComputeBackendServicesGetRequest object.

  Fields:
    backendService: Name of the BackendService resource to return.
    project: Project ID for this request.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeBackendServicesInsertRequest(_messages.Message):
  r"""A ComputeBackendServicesInsertRequest object.

  Fields:
    backendService: A BackendService resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.MessageField('BackendService', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeBackendServicesListRequest(_messages.Message):
  r"""A ComputeBackendServicesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeBackendServicesPatchRequest(_messages.Message):
  r"""A ComputeBackendServicesPatchRequest object.

  Fields:
    backendService: Name of the BackendService resource to patch.
    backendServiceResource: A BackendService resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.StringField(1, required=True)
  backendServiceResource = _messages.MessageField('BackendService', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeBackendServicesSetEdgeSecurityPolicyRequest(_messages.Message):
  r"""A ComputeBackendServicesSetEdgeSecurityPolicyRequest object.

  Fields:
    backendService: Name of the BackendService resource to which the edge
      security policy should be set. The name should conform to RFC1035.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    securityPolicyReference: A SecurityPolicyReference resource to be passed
      as the request body.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  securityPolicyReference = _messages.MessageField('SecurityPolicyReference', 4)


class ComputeBackendServicesSetIamPolicyRequest(_messages.Message):
  r"""A ComputeBackendServicesSetIamPolicyRequest object.

  Fields:
    globalSetPolicyRequest: A GlobalSetPolicyRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
  """

  globalSetPolicyRequest = _messages.MessageField('GlobalSetPolicyRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeBackendServicesSetSecurityPolicyRequest(_messages.Message):
  r"""A ComputeBackendServicesSetSecurityPolicyRequest object.

  Fields:
    backendService: Name of the BackendService resource to which the security
      policy should be set. The name should conform to RFC1035.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    securityPolicyReference: A SecurityPolicyReference resource to be passed
      as the request body.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  securityPolicyReference = _messages.MessageField('SecurityPolicyReference', 4)


class ComputeBackendServicesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeBackendServicesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeBackendServicesUpdateRequest(_messages.Message):
  r"""A ComputeBackendServicesUpdateRequest object.

  Fields:
    backendService: Name of the BackendService resource to update.
    backendServiceResource: A BackendService resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.StringField(1, required=True)
  backendServiceResource = _messages.MessageField('BackendService', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeDiskTypesAggregatedListRequest(_messages.Message):
  r"""A ComputeDiskTypesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeDiskTypesGetRequest(_messages.Message):
  r"""A ComputeDiskTypesGetRequest object.

  Fields:
    diskType: Name of the disk type to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  diskType = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeDiskTypesListRequest(_messages.Message):
  r"""A ComputeDiskTypesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)
  zone = _messages.StringField(7, required=True)


class ComputeDisksAddResourcePoliciesRequest(_messages.Message):
  r"""A ComputeDisksAddResourcePoliciesRequest object.

  Fields:
    disk: The disk name for this request.
    disksAddResourcePoliciesRequest: A DisksAddResourcePoliciesRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  disk = _messages.StringField(1, required=True)
  disksAddResourcePoliciesRequest = _messages.MessageField('DisksAddResourcePoliciesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeDisksAggregatedListRequest(_messages.Message):
  r"""A ComputeDisksAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeDisksCreateSnapshotRequest(_messages.Message):
  r"""A ComputeDisksCreateSnapshotRequest object.

  Fields:
    disk: Name of the persistent disk to snapshot.
    guestFlush: [Input Only] Whether to attempt an application consistent
      snapshot by informing the OS to prepare for the snapshot process.
      Currently only supported on Windows instances using the Volume Shadow
      Copy Service (VSS).
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    snapshot: A Snapshot resource to be passed as the request body.
    zone: The name of the zone for this request.
  """

  disk = _messages.StringField(1, required=True)
  guestFlush = _messages.BooleanField(2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  snapshot = _messages.MessageField('Snapshot', 5)
  zone = _messages.StringField(6, required=True)


class ComputeDisksDeleteRequest(_messages.Message):
  r"""A ComputeDisksDeleteRequest object.

  Fields:
    disk: Name of the persistent disk to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeDisksGetIamPolicyRequest(_messages.Message):
  r"""A ComputeDisksGetIamPolicyRequest object.

  Fields:
    optionsRequestedPolicyVersion: Requested IAM Policy version.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    zone: The name of the zone for this request.
  """

  optionsRequestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeDisksGetRequest(_messages.Message):
  r"""A ComputeDisksGetRequest object.

  Fields:
    disk: Name of the persistent disk to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeDisksInsertRequest(_messages.Message):
  r"""A ComputeDisksInsertRequest object.

  Fields:
    disk: A Disk resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    sourceImage: Source image to restore onto a disk. This field is optional.
    zone: The name of the zone for this request.
  """

  disk = _messages.MessageField('Disk', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  sourceImage = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeDisksListRequest(_messages.Message):
  r"""A ComputeDisksListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)
  zone = _messages.StringField(7, required=True)


class ComputeDisksRemoveResourcePoliciesRequest(_messages.Message):
  r"""A ComputeDisksRemoveResourcePoliciesRequest object.

  Fields:
    disk: The disk name for this request.
    disksRemoveResourcePoliciesRequest: A DisksRemoveResourcePoliciesRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  disk = _messages.StringField(1, required=True)
  disksRemoveResourcePoliciesRequest = _messages.MessageField('DisksRemoveResourcePoliciesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeDisksResizeRequest(_messages.Message):
  r"""A ComputeDisksResizeRequest object.

  Fields:
    disk: The name of the persistent disk.
    disksResizeRequest: A DisksResizeRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  disk = _messages.StringField(1, required=True)
  disksResizeRequest = _messages.MessageField('DisksResizeRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeDisksSetIamPolicyRequest(_messages.Message):
  r"""A ComputeDisksSetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    zone: The name of the zone for this request.
    zoneSetPolicyRequest: A ZoneSetPolicyRequest resource to be passed as the
      request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)
  zoneSetPolicyRequest = _messages.MessageField('ZoneSetPolicyRequest', 4)


class ComputeDisksSetLabelsRequest(_messages.Message):
  r"""A ComputeDisksSetLabelsRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    resource: Name or id of the resource for this request.
    zone: The name of the zone for this request.
    zoneSetLabelsRequest: A ZoneSetLabelsRequest resource to be passed as the
      request body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  resource = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)
  zoneSetLabelsRequest = _messages.MessageField('ZoneSetLabelsRequest', 5)


class ComputeDisksTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeDisksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeDisksUpdateRequest(_messages.Message):
  r"""A ComputeDisksUpdateRequest object.

  Fields:
    disk: The disk name for this request.
    diskResource: A Disk resource to be passed as the request body.
    paths: A string attribute.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    updateMask: update_mask indicates fields to be updated as part of this
      request.
    zone: The name of the zone for this request.
  """

  disk = _messages.StringField(1, required=True)
  diskResource = _messages.MessageField('Disk', 2)
  paths = _messages.StringField(3, repeated=True)
  project = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)
  updateMask = _messages.StringField(6)
  zone = _messages.StringField(7, required=True)


class ComputeExternalVpnGatewaysDeleteRequest(_messages.Message):
  r"""A ComputeExternalVpnGatewaysDeleteRequest object.

  Fields:
    externalVpnGateway: Name of the externalVpnGateways to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  externalVpnGateway = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeExternalVpnGatewaysGetRequest(_messages.Message):
  r"""A ComputeExternalVpnGatewaysGetRequest object.

  Fields:
    externalVpnGateway: Name of the externalVpnGateway to return.
    project: Project ID for this request.
  """

  externalVpnGateway = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeExternalVpnGatewaysInsertRequest(_messages.Message):
  r"""A ComputeExternalVpnGatewaysInsertRequest object.

  Fields:
    externalVpnGateway: A ExternalVpnGateway resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  externalVpnGateway = _messages.MessageField('ExternalVpnGateway', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeExternalVpnGatewaysListRequest(_messages.Message):
  r"""A ComputeExternalVpnGatewaysListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeExternalVpnGatewaysSetLabelsRequest(_messages.Message):
  r"""A ComputeExternalVpnGatewaysSetLabelsRequest object.

  Fields:
    globalSetLabelsRequest: A GlobalSetLabelsRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
  """

  globalSetLabelsRequest = _messages.MessageField('GlobalSetLabelsRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeExternalVpnGatewaysTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeExternalVpnGatewaysTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeFirewallPoliciesAddAssociationRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesAddAssociationRequest object.

  Fields:
    firewallPolicy: Name of the firewall policy to update.
    firewallPolicyAssociation: A FirewallPolicyAssociation resource to be
      passed as the request body.
    replaceExistingAssociation: Indicates whether or not to replace it if an
      association of the attachment already exists. This is false by default,
      in which case an error will be returned if an association already
      exists.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  firewallPolicy = _messages.StringField(1, required=True)
  firewallPolicyAssociation = _messages.MessageField('FirewallPolicyAssociation', 2)
  replaceExistingAssociation = _messages.BooleanField(3)
  requestId = _messages.StringField(4)


class ComputeFirewallPoliciesAddRuleRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesAddRuleRequest object.

  Fields:
    firewallPolicy: Name of the firewall policy to update.
    firewallPolicyRule: A FirewallPolicyRule resource to be passed as the
      request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  firewallPolicy = _messages.StringField(1, required=True)
  firewallPolicyRule = _messages.MessageField('FirewallPolicyRule', 2)
  requestId = _messages.StringField(3)


class ComputeFirewallPoliciesCloneRulesRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesCloneRulesRequest object.

  Fields:
    firewallPolicy: Name of the firewall policy to update.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    sourceFirewallPolicy: The firewall policy from which to copy rules.
  """

  firewallPolicy = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  sourceFirewallPolicy = _messages.StringField(3)


class ComputeFirewallPoliciesDeleteRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesDeleteRequest object.

  Fields:
    firewallPolicy: Name of the firewall policy to delete.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  firewallPolicy = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class ComputeFirewallPoliciesGetAssociationRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesGetAssociationRequest object.

  Fields:
    firewallPolicy: Name of the firewall policy to which the queried rule
      belongs.
    name: The name of the association to get from the firewall policy.
  """

  firewallPolicy = _messages.StringField(1, required=True)
  name = _messages.StringField(2)


class ComputeFirewallPoliciesGetIamPolicyRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesGetIamPolicyRequest object.

  Fields:
    optionsRequestedPolicyVersion: Requested IAM Policy version.
    resource: Name or id of the resource for this request.
  """

  optionsRequestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ComputeFirewallPoliciesGetRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesGetRequest object.

  Fields:
    firewallPolicy: Name of the firewall policy to get.
  """

  firewallPolicy = _messages.StringField(1, required=True)


class ComputeFirewallPoliciesGetRuleRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesGetRuleRequest object.

  Fields:
    firewallPolicy: Name of the firewall policy to which the queried rule
      belongs.
    priority: The priority of the rule to get from the firewall policy.
  """

  firewallPolicy = _messages.StringField(1, required=True)
  priority = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class ComputeFirewallPoliciesInsertRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesInsertRequest object.

  Fields:
    firewallPolicy: A FirewallPolicy resource to be passed as the request
      body.
    parentId: Parent ID for this request. The ID can be either be
      "folders/[FOLDER_ID]" if the parent is a folder or
      "organizations/[ORGANIZATION_ID]" if the parent is an organization.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  firewallPolicy = _messages.MessageField('FirewallPolicy', 1)
  parentId = _messages.StringField(2)
  requestId = _messages.StringField(3)


class ComputeFirewallPoliciesListAssociationsRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesListAssociationsRequest object.

  Fields:
    targetResource: The target resource to list associations. It is an
      organization, or a folder.
  """

  targetResource = _messages.StringField(1)


class ComputeFirewallPoliciesListRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    parentId: Parent ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  parentId = _messages.StringField(5)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeFirewallPoliciesMoveRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesMoveRequest object.

  Fields:
    firewallPolicy: Name of the firewall policy to update.
    parentId: The new parent of the firewall policy.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  firewallPolicy = _messages.StringField(1, required=True)
  parentId = _messages.StringField(2)
  requestId = _messages.StringField(3)


class ComputeFirewallPoliciesPatchRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesPatchRequest object.

  Fields:
    firewallPolicy: Name of the firewall policy to update.
    firewallPolicyResource: A FirewallPolicy resource to be passed as the
      request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  firewallPolicy = _messages.StringField(1, required=True)
  firewallPolicyResource = _messages.MessageField('FirewallPolicy', 2)
  requestId = _messages.StringField(3)


class ComputeFirewallPoliciesPatchRuleRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesPatchRuleRequest object.

  Fields:
    firewallPolicy: Name of the firewall policy to update.
    firewallPolicyRule: A FirewallPolicyRule resource to be passed as the
      request body.
    priority: The priority of the rule to patch.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  firewallPolicy = _messages.StringField(1, required=True)
  firewallPolicyRule = _messages.MessageField('FirewallPolicyRule', 2)
  priority = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  requestId = _messages.StringField(4)


class ComputeFirewallPoliciesRemoveAssociationRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesRemoveAssociationRequest object.

  Fields:
    firewallPolicy: Name of the firewall policy to update.
    name: Name for the attachment that will be removed.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  firewallPolicy = _messages.StringField(1, required=True)
  name = _messages.StringField(2)
  requestId = _messages.StringField(3)


class ComputeFirewallPoliciesRemoveRuleRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesRemoveRuleRequest object.

  Fields:
    firewallPolicy: Name of the firewall policy to update.
    priority: The priority of the rule to remove from the firewall policy.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  firewallPolicy = _messages.StringField(1, required=True)
  priority = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  requestId = _messages.StringField(3)


class ComputeFirewallPoliciesSetIamPolicyRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesSetIamPolicyRequest object.

  Fields:
    globalOrganizationSetPolicyRequest: A GlobalOrganizationSetPolicyRequest
      resource to be passed as the request body.
    resource: Name or id of the resource for this request.
  """

  globalOrganizationSetPolicyRequest = _messages.MessageField('GlobalOrganizationSetPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class ComputeFirewallPoliciesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeFirewallPoliciesTestIamPermissionsRequest object.

  Fields:
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  resource = _messages.StringField(1, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 2)


class ComputeFirewallsDeleteRequest(_messages.Message):
  r"""A ComputeFirewallsDeleteRequest object.

  Fields:
    firewall: Name of the firewall rule to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  firewall = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeFirewallsGetRequest(_messages.Message):
  r"""A ComputeFirewallsGetRequest object.

  Fields:
    firewall: Name of the firewall rule to return.
    project: Project ID for this request.
  """

  firewall = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeFirewallsInsertRequest(_messages.Message):
  r"""A ComputeFirewallsInsertRequest object.

  Fields:
    firewall: A Firewall resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  firewall = _messages.MessageField('Firewall', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeFirewallsListRequest(_messages.Message):
  r"""A ComputeFirewallsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeFirewallsPatchRequest(_messages.Message):
  r"""A ComputeFirewallsPatchRequest object.

  Fields:
    firewall: Name of the firewall rule to patch.
    firewallResource: A Firewall resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  firewall = _messages.StringField(1, required=True)
  firewallResource = _messages.MessageField('Firewall', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeFirewallsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeFirewallsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeFirewallsUpdateRequest(_messages.Message):
  r"""A ComputeFirewallsUpdateRequest object.

  Fields:
    firewall: Name of the firewall rule to update.
    firewallResource: A Firewall resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  firewall = _messages.StringField(1, required=True)
  firewallResource = _messages.MessageField('Firewall', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeForwardingRulesAggregatedListRequest(_messages.Message):
  r"""A ComputeForwardingRulesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeForwardingRulesDeleteRequest(_messages.Message):
  r"""A ComputeForwardingRulesDeleteRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource to delete.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeForwardingRulesGetRequest(_messages.Message):
  r"""A ComputeForwardingRulesGetRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource to return.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeForwardingRulesInsertRequest(_messages.Message):
  r"""A ComputeForwardingRulesInsertRequest object.

  Fields:
    forwardingRule: A ForwardingRule resource to be passed as the request
      body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  forwardingRule = _messages.MessageField('ForwardingRule', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeForwardingRulesListRequest(_messages.Message):
  r"""A ComputeForwardingRulesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeForwardingRulesPatchRequest(_messages.Message):
  r"""A ComputeForwardingRulesPatchRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource to patch.
    forwardingRuleResource: A ForwardingRule resource to be passed as the
      request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  forwardingRule = _messages.StringField(1, required=True)
  forwardingRuleResource = _messages.MessageField('ForwardingRule', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeForwardingRulesSetLabelsRequest(_messages.Message):
  r"""A ComputeForwardingRulesSetLabelsRequest object.

  Fields:
    project: Project ID for this request.
    region: The region for this request.
    regionSetLabelsRequest: A RegionSetLabelsRequest resource to be passed as
      the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    resource: Name or id of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionSetLabelsRequest = _messages.MessageField('RegionSetLabelsRequest', 3)
  requestId = _messages.StringField(4)
  resource = _messages.StringField(5, required=True)


class ComputeForwardingRulesSetTargetRequest(_messages.Message):
  r"""A ComputeForwardingRulesSetTargetRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource in which target is to
      be set.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    targetReference: A TargetReference resource to be passed as the request
      body.
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  targetReference = _messages.MessageField('TargetReference', 5)


class ComputeForwardingRulesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeForwardingRulesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeGlobalAddressesDeleteRequest(_messages.Message):
  r"""A ComputeGlobalAddressesDeleteRequest object.

  Fields:
    address: Name of the address resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  address = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeGlobalAddressesGetRequest(_messages.Message):
  r"""A ComputeGlobalAddressesGetRequest object.

  Fields:
    address: Name of the address resource to return.
    project: Project ID for this request.
  """

  address = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeGlobalAddressesInsertRequest(_messages.Message):
  r"""A ComputeGlobalAddressesInsertRequest object.

  Fields:
    address: A Address resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  address = _messages.MessageField('Address', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeGlobalAddressesListRequest(_messages.Message):
  r"""A ComputeGlobalAddressesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeGlobalAddressesSetLabelsRequest(_messages.Message):
  r"""A ComputeGlobalAddressesSetLabelsRequest object.

  Fields:
    globalSetLabelsRequest: A GlobalSetLabelsRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
  """

  globalSetLabelsRequest = _messages.MessageField('GlobalSetLabelsRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeGlobalAddressesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeGlobalAddressesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeGlobalForwardingRulesDeleteRequest(_messages.Message):
  r"""A ComputeGlobalForwardingRulesDeleteRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeGlobalForwardingRulesGetRequest(_messages.Message):
  r"""A ComputeGlobalForwardingRulesGetRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource to return.
    project: Project ID for this request.
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeGlobalForwardingRulesInsertRequest(_messages.Message):
  r"""A ComputeGlobalForwardingRulesInsertRequest object.

  Fields:
    forwardingRule: A ForwardingRule resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  forwardingRule = _messages.MessageField('ForwardingRule', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeGlobalForwardingRulesListRequest(_messages.Message):
  r"""A ComputeGlobalForwardingRulesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeGlobalForwardingRulesPatchRequest(_messages.Message):
  r"""A ComputeGlobalForwardingRulesPatchRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource to patch.
    forwardingRuleResource: A ForwardingRule resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  forwardingRule = _messages.StringField(1, required=True)
  forwardingRuleResource = _messages.MessageField('ForwardingRule', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeGlobalForwardingRulesSetLabelsRequest(_messages.Message):
  r"""A ComputeGlobalForwardingRulesSetLabelsRequest object.

  Fields:
    globalSetLabelsRequest: A GlobalSetLabelsRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
  """

  globalSetLabelsRequest = _messages.MessageField('GlobalSetLabelsRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeGlobalForwardingRulesSetTargetRequest(_messages.Message):
  r"""A ComputeGlobalForwardingRulesSetTargetRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource in which target is to
      be set.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    targetReference: A TargetReference resource to be passed as the request
      body.
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  targetReference = _messages.MessageField('TargetReference', 4)


class ComputeGlobalForwardingRulesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeGlobalForwardingRulesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeGlobalNetworkEndpointGroupsAttachNetworkEndpointsRequest(_messages.Message):
  r"""A ComputeGlobalNetworkEndpointGroupsAttachNetworkEndpointsRequest
  object.

  Fields:
    globalNetworkEndpointGroupsAttachEndpointsRequest: A
      GlobalNetworkEndpointGroupsAttachEndpointsRequest resource to be passed
      as the request body.
    networkEndpointGroup: The name of the network endpoint group where you are
      attaching network endpoints to. It should comply with RFC1035.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  globalNetworkEndpointGroupsAttachEndpointsRequest = _messages.MessageField('GlobalNetworkEndpointGroupsAttachEndpointsRequest', 1)
  networkEndpointGroup = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeGlobalNetworkEndpointGroupsDeleteRequest(_messages.Message):
  r"""A ComputeGlobalNetworkEndpointGroupsDeleteRequest object.

  Fields:
    networkEndpointGroup: The name of the network endpoint group to delete. It
      should comply with RFC1035.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  networkEndpointGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeGlobalNetworkEndpointGroupsDetachNetworkEndpointsRequest(_messages.Message):
  r"""A ComputeGlobalNetworkEndpointGroupsDetachNetworkEndpointsRequest
  object.

  Fields:
    globalNetworkEndpointGroupsDetachEndpointsRequest: A
      GlobalNetworkEndpointGroupsDetachEndpointsRequest resource to be passed
      as the request body.
    networkEndpointGroup: The name of the network endpoint group where you are
      removing network endpoints. It should comply with RFC1035.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  globalNetworkEndpointGroupsDetachEndpointsRequest = _messages.MessageField('GlobalNetworkEndpointGroupsDetachEndpointsRequest', 1)
  networkEndpointGroup = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeGlobalNetworkEndpointGroupsGetRequest(_messages.Message):
  r"""A ComputeGlobalNetworkEndpointGroupsGetRequest object.

  Fields:
    networkEndpointGroup: The name of the network endpoint group. It should
      comply with RFC1035.
    project: Project ID for this request.
  """

  networkEndpointGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeGlobalNetworkEndpointGroupsInsertRequest(_messages.Message):
  r"""A ComputeGlobalNetworkEndpointGroupsInsertRequest object.

  Fields:
    networkEndpointGroup: A NetworkEndpointGroup resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  networkEndpointGroup = _messages.MessageField('NetworkEndpointGroup', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeGlobalNetworkEndpointGroupsListNetworkEndpointsRequest(_messages.Message):
  r"""A ComputeGlobalNetworkEndpointGroupsListNetworkEndpointsRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    networkEndpointGroup: The name of the network endpoint group from which
      you want to generate a list of included network endpoints. It should
      comply with RFC1035.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  networkEndpointGroup = _messages.StringField(3, required=True)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeGlobalNetworkEndpointGroupsListRequest(_messages.Message):
  r"""A ComputeGlobalNetworkEndpointGroupsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeGlobalOperationsAggregatedListRequest(_messages.Message):
  r"""A ComputeGlobalOperationsAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeGlobalOperationsDeleteRequest(_messages.Message):
  r"""A ComputeGlobalOperationsDeleteRequest object.

  Fields:
    operation: Name of the Operations resource to delete.
    project: Project ID for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeGlobalOperationsDeleteResponse(_messages.Message):
  r"""An empty ComputeGlobalOperationsDelete response."""


class ComputeGlobalOperationsGetRequest(_messages.Message):
  r"""A ComputeGlobalOperationsGetRequest object.

  Fields:
    operation: Name of the Operations resource to return.
    project: Project ID for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeGlobalOperationsListRequest(_messages.Message):
  r"""A ComputeGlobalOperationsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeGlobalOperationsWaitRequest(_messages.Message):
  r"""A ComputeGlobalOperationsWaitRequest object.

  Fields:
    operation: Name of the Operations resource to return.
    project: Project ID for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeGlobalOrganizationOperationsDeleteRequest(_messages.Message):
  r"""A ComputeGlobalOrganizationOperationsDeleteRequest object.

  Fields:
    operation: Name of the Operations resource to delete.
    parentId: Parent ID for this request.
  """

  operation = _messages.StringField(1, required=True)
  parentId = _messages.StringField(2)


class ComputeGlobalOrganizationOperationsDeleteResponse(_messages.Message):
  r"""An empty ComputeGlobalOrganizationOperationsDelete response."""


class ComputeGlobalOrganizationOperationsGetRequest(_messages.Message):
  r"""A ComputeGlobalOrganizationOperationsGetRequest object.

  Fields:
    operation: Name of the Operations resource to return.
    parentId: Parent ID for this request.
  """

  operation = _messages.StringField(1, required=True)
  parentId = _messages.StringField(2)


class ComputeGlobalOrganizationOperationsListRequest(_messages.Message):
  r"""A ComputeGlobalOrganizationOperationsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    parentId: Parent ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  parentId = _messages.StringField(5)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeGlobalPublicDelegatedPrefixesDeleteRequest(_messages.Message):
  r"""A ComputeGlobalPublicDelegatedPrefixesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    publicDelegatedPrefix: Name of the PublicDelegatedPrefix resource to
      delete.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  publicDelegatedPrefix = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeGlobalPublicDelegatedPrefixesGetRequest(_messages.Message):
  r"""A ComputeGlobalPublicDelegatedPrefixesGetRequest object.

  Fields:
    project: Project ID for this request.
    publicDelegatedPrefix: Name of the PublicDelegatedPrefix resource to
      return.
  """

  project = _messages.StringField(1, required=True)
  publicDelegatedPrefix = _messages.StringField(2, required=True)


class ComputeGlobalPublicDelegatedPrefixesInsertRequest(_messages.Message):
  r"""A ComputeGlobalPublicDelegatedPrefixesInsertRequest object.

  Fields:
    project: Project ID for this request.
    publicDelegatedPrefix: A PublicDelegatedPrefix resource to be passed as
      the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  publicDelegatedPrefix = _messages.MessageField('PublicDelegatedPrefix', 2)
  requestId = _messages.StringField(3)


class ComputeGlobalPublicDelegatedPrefixesListRequest(_messages.Message):
  r"""A ComputeGlobalPublicDelegatedPrefixesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeGlobalPublicDelegatedPrefixesPatchRequest(_messages.Message):
  r"""A ComputeGlobalPublicDelegatedPrefixesPatchRequest object.

  Fields:
    project: Project ID for this request.
    publicDelegatedPrefix: Name of the PublicDelegatedPrefix resource to
      patch.
    publicDelegatedPrefixResource: A PublicDelegatedPrefix resource to be
      passed as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  publicDelegatedPrefix = _messages.StringField(2, required=True)
  publicDelegatedPrefixResource = _messages.MessageField('PublicDelegatedPrefix', 3)
  requestId = _messages.StringField(4)


class ComputeHealthChecksAggregatedListRequest(_messages.Message):
  r"""A ComputeHealthChecksAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Name of the project scoping this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeHealthChecksDeleteRequest(_messages.Message):
  r"""A ComputeHealthChecksDeleteRequest object.

  Fields:
    healthCheck: Name of the HealthCheck resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  healthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeHealthChecksGetRequest(_messages.Message):
  r"""A ComputeHealthChecksGetRequest object.

  Fields:
    healthCheck: Name of the HealthCheck resource to return.
    project: Project ID for this request.
  """

  healthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeHealthChecksInsertRequest(_messages.Message):
  r"""A ComputeHealthChecksInsertRequest object.

  Fields:
    healthCheck: A HealthCheck resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  healthCheck = _messages.MessageField('HealthCheck', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeHealthChecksListRequest(_messages.Message):
  r"""A ComputeHealthChecksListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeHealthChecksPatchRequest(_messages.Message):
  r"""A ComputeHealthChecksPatchRequest object.

  Fields:
    healthCheck: Name of the HealthCheck resource to patch.
    healthCheckResource: A HealthCheck resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  healthCheck = _messages.StringField(1, required=True)
  healthCheckResource = _messages.MessageField('HealthCheck', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeHealthChecksTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeHealthChecksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeHealthChecksUpdateRequest(_messages.Message):
  r"""A ComputeHealthChecksUpdateRequest object.

  Fields:
    healthCheck: Name of the HealthCheck resource to update.
    healthCheckResource: A HealthCheck resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  healthCheck = _messages.StringField(1, required=True)
  healthCheckResource = _messages.MessageField('HealthCheck', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeHttpHealthChecksDeleteRequest(_messages.Message):
  r"""A ComputeHttpHealthChecksDeleteRequest object.

  Fields:
    httpHealthCheck: Name of the HttpHealthCheck resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  httpHealthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeHttpHealthChecksGetRequest(_messages.Message):
  r"""A ComputeHttpHealthChecksGetRequest object.

  Fields:
    httpHealthCheck: Name of the HttpHealthCheck resource to return.
    project: Project ID for this request.
  """

  httpHealthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeHttpHealthChecksInsertRequest(_messages.Message):
  r"""A ComputeHttpHealthChecksInsertRequest object.

  Fields:
    httpHealthCheck: A HttpHealthCheck resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  httpHealthCheck = _messages.MessageField('HttpHealthCheck', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeHttpHealthChecksListRequest(_messages.Message):
  r"""A ComputeHttpHealthChecksListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeHttpHealthChecksPatchRequest(_messages.Message):
  r"""A ComputeHttpHealthChecksPatchRequest object.

  Fields:
    httpHealthCheck: Name of the HttpHealthCheck resource to patch.
    httpHealthCheckResource: A HttpHealthCheck resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  httpHealthCheck = _messages.StringField(1, required=True)
  httpHealthCheckResource = _messages.MessageField('HttpHealthCheck', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeHttpHealthChecksTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeHttpHealthChecksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeHttpHealthChecksUpdateRequest(_messages.Message):
  r"""A ComputeHttpHealthChecksUpdateRequest object.

  Fields:
    httpHealthCheck: Name of the HttpHealthCheck resource to update.
    httpHealthCheckResource: A HttpHealthCheck resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  httpHealthCheck = _messages.StringField(1, required=True)
  httpHealthCheckResource = _messages.MessageField('HttpHealthCheck', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeHttpsHealthChecksDeleteRequest(_messages.Message):
  r"""A ComputeHttpsHealthChecksDeleteRequest object.

  Fields:
    httpsHealthCheck: Name of the HttpsHealthCheck resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  httpsHealthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeHttpsHealthChecksGetRequest(_messages.Message):
  r"""A ComputeHttpsHealthChecksGetRequest object.

  Fields:
    httpsHealthCheck: Name of the HttpsHealthCheck resource to return.
    project: Project ID for this request.
  """

  httpsHealthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeHttpsHealthChecksInsertRequest(_messages.Message):
  r"""A ComputeHttpsHealthChecksInsertRequest object.

  Fields:
    httpsHealthCheck: A HttpsHealthCheck resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  httpsHealthCheck = _messages.MessageField('HttpsHealthCheck', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeHttpsHealthChecksListRequest(_messages.Message):
  r"""A ComputeHttpsHealthChecksListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeHttpsHealthChecksPatchRequest(_messages.Message):
  r"""A ComputeHttpsHealthChecksPatchRequest object.

  Fields:
    httpsHealthCheck: Name of the HttpsHealthCheck resource to patch.
    httpsHealthCheckResource: A HttpsHealthCheck resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  httpsHealthCheck = _messages.StringField(1, required=True)
  httpsHealthCheckResource = _messages.MessageField('HttpsHealthCheck', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeHttpsHealthChecksTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeHttpsHealthChecksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeHttpsHealthChecksUpdateRequest(_messages.Message):
  r"""A ComputeHttpsHealthChecksUpdateRequest object.

  Fields:
    httpsHealthCheck: Name of the HttpsHealthCheck resource to update.
    httpsHealthCheckResource: A HttpsHealthCheck resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  httpsHealthCheck = _messages.StringField(1, required=True)
  httpsHealthCheckResource = _messages.MessageField('HttpsHealthCheck', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeImageFamilyViewsGetRequest(_messages.Message):
  r"""A ComputeImageFamilyViewsGetRequest object.

  Fields:
    family: Name of the image family to search for.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  family = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeImagesDeleteRequest(_messages.Message):
  r"""A ComputeImagesDeleteRequest object.

  Fields:
    image: Name of the image resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  image = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeImagesDeprecateRequest(_messages.Message):
  r"""A ComputeImagesDeprecateRequest object.

  Fields:
    deprecationStatus: A DeprecationStatus resource to be passed as the
      request body.
    image: Image name.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  deprecationStatus = _messages.MessageField('DeprecationStatus', 1)
  image = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeImagesGetFromFamilyRequest(_messages.Message):
  r"""A ComputeImagesGetFromFamilyRequest object.

  Fields:
    family: Name of the image family to search for.
    project: Project ID for this request.
  """

  family = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeImagesGetIamPolicyRequest(_messages.Message):
  r"""A ComputeImagesGetIamPolicyRequest object.

  Fields:
    optionsRequestedPolicyVersion: Requested IAM Policy version.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
  """

  optionsRequestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeImagesGetRequest(_messages.Message):
  r"""A ComputeImagesGetRequest object.

  Fields:
    image: Name of the image resource to return.
    project: Project ID for this request.
  """

  image = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeImagesInsertRequest(_messages.Message):
  r"""A ComputeImagesInsertRequest object.

  Fields:
    forceCreate: Force image creation if true.
    image: A Image resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  forceCreate = _messages.BooleanField(1)
  image = _messages.MessageField('Image', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeImagesListRequest(_messages.Message):
  r"""A ComputeImagesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeImagesPatchRequest(_messages.Message):
  r"""A ComputeImagesPatchRequest object.

  Fields:
    image: Name of the image resource to patch.
    imageResource: A Image resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  image = _messages.StringField(1, required=True)
  imageResource = _messages.MessageField('Image', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeImagesSetIamPolicyRequest(_messages.Message):
  r"""A ComputeImagesSetIamPolicyRequest object.

  Fields:
    globalSetPolicyRequest: A GlobalSetPolicyRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
  """

  globalSetPolicyRequest = _messages.MessageField('GlobalSetPolicyRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeImagesSetLabelsRequest(_messages.Message):
  r"""A ComputeImagesSetLabelsRequest object.

  Fields:
    globalSetLabelsRequest: A GlobalSetLabelsRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
  """

  globalSetLabelsRequest = _messages.MessageField('GlobalSetLabelsRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeImagesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeImagesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeInstanceGroupManagersAbandonInstancesRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersAbandonInstancesRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersAbandonInstancesRequest: A
      InstanceGroupManagersAbandonInstancesRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersAbandonInstancesRequest = _messages.MessageField('InstanceGroupManagersAbandonInstancesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersAggregatedListRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeInstanceGroupManagersApplyUpdatesToInstancesRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersApplyUpdatesToInstancesRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group, should
      conform to RFC1035.
    instanceGroupManagersApplyUpdatesRequest: A
      InstanceGroupManagersApplyUpdatesRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    zone: The name of the zone where the managed instance group is located.
      Should conform to RFC1035.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersApplyUpdatesRequest = _messages.MessageField('InstanceGroupManagersApplyUpdatesRequest', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupManagersCreateInstancesRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersCreateInstancesRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group. It should
      conform to RFC1035.
    instanceGroupManagersCreateInstancesRequest: A
      InstanceGroupManagersCreateInstancesRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. The request ID must
      be a valid UUID with the exception that zero UUID is not supported (
      00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located. It
      should conform to RFC1035.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersCreateInstancesRequest = _messages.MessageField('InstanceGroupManagersCreateInstancesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersDeleteInstancesRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersDeleteInstancesRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersDeleteInstancesRequest: A
      InstanceGroupManagersDeleteInstancesRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersDeleteInstancesRequest = _messages.MessageField('InstanceGroupManagersDeleteInstancesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersDeletePerInstanceConfigsRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersDeletePerInstanceConfigsRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group. It should
      conform to RFC1035.
    instanceGroupManagersDeletePerInstanceConfigsReq: A
      InstanceGroupManagersDeletePerInstanceConfigsReq resource to be passed
      as the request body.
    project: Project ID for this request.
    zone: The name of the zone where the managed instance group is located. It
      should conform to RFC1035.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersDeletePerInstanceConfigsReq = _messages.MessageField('InstanceGroupManagersDeletePerInstanceConfigsReq', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupManagersDeleteRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersDeleteRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupManagersGetRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersGetRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    project: Project ID for this request.
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstanceGroupManagersInsertRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersInsertRequest object.

  Fields:
    instanceGroupManager: A InstanceGroupManager resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where you want to create the managed instance
      group.
  """

  instanceGroupManager = _messages.MessageField('InstanceGroupManager', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupManagersListErrorsRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersListErrorsRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    instanceGroupManager: The name of the managed instance group. It must be a
      string that meets the requirements in RFC1035, or an unsigned long
      integer: must match regexp pattern:
      (?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?)|1-9{0,19}.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: The name of the zone where the managed instance group is located. It
      should conform to RFC1035.
  """

  filter = _messages.StringField(1)
  instanceGroupManager = _messages.StringField(2, required=True)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)
  zone = _messages.StringField(8, required=True)


class ComputeInstanceGroupManagersListManagedInstancesRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersListManagedInstancesRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    instanceGroupManager: The name of the managed instance group.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: The name of the zone where the managed instance group is located.
  """

  filter = _messages.StringField(1)
  instanceGroupManager = _messages.StringField(2, required=True)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)
  zone = _messages.StringField(8, required=True)


class ComputeInstanceGroupManagersListPerInstanceConfigsRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersListPerInstanceConfigsRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    instanceGroupManager: The name of the managed instance group. It should
      conform to RFC1035.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: The name of the zone where the managed instance group is located. It
      should conform to RFC1035.
  """

  filter = _messages.StringField(1)
  instanceGroupManager = _messages.StringField(2, required=True)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)
  zone = _messages.StringField(8, required=True)


class ComputeInstanceGroupManagersListRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: The name of the zone where the managed instance group is located.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)
  zone = _messages.StringField(7, required=True)


class ComputeInstanceGroupManagersPatchPerInstanceConfigsRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersPatchPerInstanceConfigsRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group. It should
      conform to RFC1035.
    instanceGroupManagersPatchPerInstanceConfigsReq: A
      InstanceGroupManagersPatchPerInstanceConfigsReq resource to be passed as
      the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located. It
      should conform to RFC1035.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersPatchPerInstanceConfigsReq = _messages.MessageField('InstanceGroupManagersPatchPerInstanceConfigsReq', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersPatchRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersPatchRequest object.

  Fields:
    instanceGroupManager: The name of the instance group manager.
    instanceGroupManagerResource: A InstanceGroupManager resource to be passed
      as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where you want to create the managed instance
      group.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagerResource = _messages.MessageField('InstanceGroupManager', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersRecreateInstancesRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersRecreateInstancesRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersRecreateInstancesRequest: A
      InstanceGroupManagersRecreateInstancesRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersRecreateInstancesRequest = _messages.MessageField('InstanceGroupManagersRecreateInstancesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersResizeAdvancedRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersResizeAdvancedRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersResizeAdvancedRequest: A
      InstanceGroupManagersResizeAdvancedRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersResizeAdvancedRequest = _messages.MessageField('InstanceGroupManagersResizeAdvancedRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersResizeRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersResizeRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    size: The number of running instances that the managed instance group
      should maintain at any given time. The group automatically adds or
      removes instances to maintain the number of instances specified by this
      parameter.
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  size = _messages.IntegerField(4, required=True, variant=_messages.Variant.INT32)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersSetAutoHealingPoliciesRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersSetAutoHealingPoliciesRequest object.

  Fields:
    instanceGroupManager: The name of the instance group manager.
    instanceGroupManagersSetAutoHealingRequest: A
      InstanceGroupManagersSetAutoHealingRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersSetAutoHealingRequest = _messages.MessageField('InstanceGroupManagersSetAutoHealingRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersSetInstanceTemplateRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersSetInstanceTemplateRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersSetInstanceTemplateRequest: A
      InstanceGroupManagersSetInstanceTemplateRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersSetInstanceTemplateRequest = _messages.MessageField('InstanceGroupManagersSetInstanceTemplateRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersSetTargetPoolsRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersSetTargetPoolsRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersSetTargetPoolsRequest: A
      InstanceGroupManagersSetTargetPoolsRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersSetTargetPoolsRequest = _messages.MessageField('InstanceGroupManagersSetTargetPoolsRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupManagersUpdatePerInstanceConfigsRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersUpdatePerInstanceConfigsRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group. It should
      conform to RFC1035.
    instanceGroupManagersUpdatePerInstanceConfigsReq: A
      InstanceGroupManagersUpdatePerInstanceConfigsReq resource to be passed
      as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located. It
      should conform to RFC1035.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersUpdatePerInstanceConfigsReq = _messages.MessageField('InstanceGroupManagersUpdatePerInstanceConfigsReq', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersUpdateRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersUpdateRequest object.

  Fields:
    instanceGroupManager: The name of the instance group manager.
    instanceGroupManagerResource: A InstanceGroupManager resource to be passed
      as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where you want to create the managed instance
      group.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagerResource = _messages.MessageField('InstanceGroupManager', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupsAddInstancesRequest(_messages.Message):
  r"""A ComputeInstanceGroupsAddInstancesRequest object.

  Fields:
    instanceGroup: The name of the instance group where you are adding
      instances.
    instanceGroupsAddInstancesRequest: A InstanceGroupsAddInstancesRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the instance group is located.
  """

  instanceGroup = _messages.StringField(1, required=True)
  instanceGroupsAddInstancesRequest = _messages.MessageField('InstanceGroupsAddInstancesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupsAggregatedListRequest(_messages.Message):
  r"""A ComputeInstanceGroupsAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeInstanceGroupsDeleteRequest(_messages.Message):
  r"""A ComputeInstanceGroupsDeleteRequest object.

  Fields:
    instanceGroup: The name of the instance group to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the instance group is located.
  """

  instanceGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupsGetRequest(_messages.Message):
  r"""A ComputeInstanceGroupsGetRequest object.

  Fields:
    instanceGroup: The name of the instance group.
    project: Project ID for this request.
    zone: The name of the zone where the instance group is located.
  """

  instanceGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstanceGroupsInsertRequest(_messages.Message):
  r"""A ComputeInstanceGroupsInsertRequest object.

  Fields:
    instanceGroup: A InstanceGroup resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where you want to create the instance group.
  """

  instanceGroup = _messages.MessageField('InstanceGroup', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupsListInstancesRequest(_messages.Message):
  r"""A ComputeInstanceGroupsListInstancesRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    instanceGroup: The name of the instance group from which you want to
      generate a list of included instances.
    instanceGroupsListInstancesRequest: A InstanceGroupsListInstancesRequest
      resource to be passed as the request body.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: The name of the zone where the instance group is located.
  """

  filter = _messages.StringField(1)
  instanceGroup = _messages.StringField(2, required=True)
  instanceGroupsListInstancesRequest = _messages.MessageField('InstanceGroupsListInstancesRequest', 3)
  maxResults = _messages.IntegerField(4, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(5)
  pageToken = _messages.StringField(6)
  project = _messages.StringField(7, required=True)
  returnPartialSuccess = _messages.BooleanField(8)
  zone = _messages.StringField(9, required=True)


class ComputeInstanceGroupsListRequest(_messages.Message):
  r"""A ComputeInstanceGroupsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: The name of the zone where the instance group is located.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)
  zone = _messages.StringField(7, required=True)


class ComputeInstanceGroupsRemoveInstancesRequest(_messages.Message):
  r"""A ComputeInstanceGroupsRemoveInstancesRequest object.

  Fields:
    instanceGroup: The name of the instance group where the specified
      instances will be removed.
    instanceGroupsRemoveInstancesRequest: A
      InstanceGroupsRemoveInstancesRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the instance group is located.
  """

  instanceGroup = _messages.StringField(1, required=True)
  instanceGroupsRemoveInstancesRequest = _messages.MessageField('InstanceGroupsRemoveInstancesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupsSetNamedPortsRequest(_messages.Message):
  r"""A ComputeInstanceGroupsSetNamedPortsRequest object.

  Fields:
    instanceGroup: The name of the instance group where the named ports are
      updated.
    instanceGroupsSetNamedPortsRequest: A InstanceGroupsSetNamedPortsRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the instance group is located.
  """

  instanceGroup = _messages.StringField(1, required=True)
  instanceGroupsSetNamedPortsRequest = _messages.MessageField('InstanceGroupsSetNamedPortsRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeInstanceGroupsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceTemplatesDeleteRequest(_messages.Message):
  r"""A ComputeInstanceTemplatesDeleteRequest object.

  Fields:
    instanceTemplate: The name of the instance template to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  instanceTemplate = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeInstanceTemplatesGetIamPolicyRequest(_messages.Message):
  r"""A ComputeInstanceTemplatesGetIamPolicyRequest object.

  Fields:
    optionsRequestedPolicyVersion: Requested IAM Policy version.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
  """

  optionsRequestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeInstanceTemplatesGetRequest(_messages.Message):
  r"""A ComputeInstanceTemplatesGetRequest object.

  Fields:
    instanceTemplate: The name of the instance template.
    project: Project ID for this request.
  """

  instanceTemplate = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeInstanceTemplatesInsertRequest(_messages.Message):
  r"""A ComputeInstanceTemplatesInsertRequest object.

  Fields:
    instanceTemplate: A InstanceTemplate resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  instanceTemplate = _messages.MessageField('InstanceTemplate', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeInstanceTemplatesListRequest(_messages.Message):
  r"""A ComputeInstanceTemplatesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeInstanceTemplatesSetIamPolicyRequest(_messages.Message):
  r"""A ComputeInstanceTemplatesSetIamPolicyRequest object.

  Fields:
    globalSetPolicyRequest: A GlobalSetPolicyRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
  """

  globalSetPolicyRequest = _messages.MessageField('GlobalSetPolicyRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeInstanceTemplatesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeInstanceTemplatesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeInstancesAddAccessConfigRequest(_messages.Message):
  r"""A ComputeInstancesAddAccessConfigRequest object.

  Fields:
    accessConfig: A AccessConfig resource to be passed as the request body.
    instance: The instance name for this request.
    networkInterface: The name of the network interface to add to this
      instance.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  accessConfig = _messages.MessageField('AccessConfig', 1)
  instance = _messages.StringField(2, required=True)
  networkInterface = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)
  zone = _messages.StringField(6, required=True)


class ComputeInstancesAddResourcePoliciesRequest(_messages.Message):
  r"""A ComputeInstancesAddResourcePoliciesRequest object.

  Fields:
    instance: The instance name for this request.
    instancesAddResourcePoliciesRequest: A InstancesAddResourcePoliciesRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesAddResourcePoliciesRequest = _messages.MessageField('InstancesAddResourcePoliciesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesAggregatedListRequest(_messages.Message):
  r"""A ComputeInstancesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeInstancesAttachDiskRequest(_messages.Message):
  r"""A ComputeInstancesAttachDiskRequest object.

  Fields:
    attachedDisk: A AttachedDisk resource to be passed as the request body.
    forceAttach: Whether to force attach the regional disk even if it's
      currently attached to another instance. If you try to force attach a
      zonal disk to an instance, you will receive an error.
    instance: The instance name for this request.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  attachedDisk = _messages.MessageField('AttachedDisk', 1)
  forceAttach = _messages.BooleanField(2)
  instance = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)
  zone = _messages.StringField(6, required=True)


class ComputeInstancesBulkInsertRequest(_messages.Message):
  r"""A ComputeInstancesBulkInsertRequest object.

  Fields:
    bulkInsertInstanceResource: A BulkInsertInstanceResource resource to be
      passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  bulkInsertInstanceResource = _messages.MessageField('BulkInsertInstanceResource', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesDeleteAccessConfigRequest(_messages.Message):
  r"""A ComputeInstancesDeleteAccessConfigRequest object.

  Fields:
    accessConfig: The name of the access config to delete.
    instance: The instance name for this request.
    networkInterface: The name of the network interface.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  accessConfig = _messages.StringField(1, required=True)
  instance = _messages.StringField(2, required=True)
  networkInterface = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)
  zone = _messages.StringField(6, required=True)


class ComputeInstancesDeleteRequest(_messages.Message):
  r"""A ComputeInstancesDeleteRequest object.

  Fields:
    instance: Name of the instance resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesDetachDiskRequest(_messages.Message):
  r"""A ComputeInstancesDetachDiskRequest object.

  Fields:
    deviceName: The device name of the disk to detach. Make a get() request on
      the instance to view currently attached disks and device names.
    instance: Instance name for this request.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  deviceName = _messages.StringField(1, required=True)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesGetEffectiveFirewallsRequest(_messages.Message):
  r"""A ComputeInstancesGetEffectiveFirewallsRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    networkInterface: The name of the network interface to get the effective
      firewalls.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  networkInterface = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesGetGuestAttributesRequest(_messages.Message):
  r"""A ComputeInstancesGetGuestAttributesRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    queryPath: Specifies the guest attributes path to be queried.
    variableKey: Specifies the key for the guest attributes entry.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  queryPath = _messages.StringField(3)
  variableKey = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesGetIamPolicyRequest(_messages.Message):
  r"""A ComputeInstancesGetIamPolicyRequest object.

  Fields:
    optionsRequestedPolicyVersion: Requested IAM Policy version.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    zone: The name of the zone for this request.
  """

  optionsRequestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesGetRequest(_messages.Message):
  r"""A ComputeInstancesGetRequest object.

  Fields:
    instance: Name of the instance resource to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesGetScreenshotRequest(_messages.Message):
  r"""A ComputeInstancesGetScreenshotRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesGetSerialPortOutputRequest(_messages.Message):
  r"""A ComputeInstancesGetSerialPortOutputRequest object.

  Fields:
    instance: Name of the instance for this request.
    port: Specifies which COM or serial port to retrieve data from.
    project: Project ID for this request.
    start: Specifies the starting byte position of the output to return. To
      start with the first byte of output to the specified port, omit this
      field or set it to `0`. If the output for that byte position is
      available, this field matches the `start` parameter sent with the
      request. If the amount of serial console output exceeds the size of the
      buffer (1 MB), the oldest output is discarded and is no longer
      available. If the requested start position refers to discarded output,
      the start position is adjusted to the oldest output still available, and
      the adjusted start position is returned as the `start` property value.
      You can also provide a negative start position, which translates to the
      most recent number of bytes written to the serial port. For example, -3
      is interpreted as the most recent 3 bytes written to the serial console.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  port = _messages.IntegerField(2, variant=_messages.Variant.INT32, default=1)
  project = _messages.StringField(3, required=True)
  start = _messages.IntegerField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesGetShieldedInstanceIdentityRequest(_messages.Message):
  r"""A ComputeInstancesGetShieldedInstanceIdentityRequest object.

  Fields:
    instance: Name or id of the instance scoping this request.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesGetShieldedVmIdentityRequest(_messages.Message):
  r"""A ComputeInstancesGetShieldedVmIdentityRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesInsertRequest(_messages.Message):
  r"""A ComputeInstancesInsertRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    sourceInstanceTemplate: Specifies instance template to create the
      instance. This field is optional. It can be a full or partial URL. For
      example, the following are all valid URLs to an instance template: -
      https://www.googleapis.com/compute/v1/projects/project
      /global/instanceTemplates/instanceTemplate -
      projects/project/global/instanceTemplates/instanceTemplate -
      global/instanceTemplates/instanceTemplate
    sourceMachineImage: Specifies the machine image to use to create the
      instance. This field is optional. It can be a full or partial URL. For
      example, the following are all valid URLs to a machine image: -
      https://www.googleapis.com/compute/v1/projects/project/global/global
      /machineImages/machineImage -
      projects/project/global/global/machineImages/machineImage -
      global/machineImages/machineImage
    zone: The name of the zone for this request.
  """

  instance = _messages.MessageField('Instance', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  sourceInstanceTemplate = _messages.StringField(4)
  sourceMachineImage = _messages.StringField(5)
  zone = _messages.StringField(6, required=True)


class ComputeInstancesListReferrersRequest(_messages.Message):
  r"""A ComputeInstancesListReferrersRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    instance: Name of the target instance scoping this request, or '-' if the
      request should span over all instances in the container.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  instance = _messages.StringField(2, required=True)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)
  zone = _messages.StringField(8, required=True)


class ComputeInstancesListRequest(_messages.Message):
  r"""A ComputeInstancesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)
  zone = _messages.StringField(7, required=True)


class ComputeInstancesRemoveResourcePoliciesRequest(_messages.Message):
  r"""A ComputeInstancesRemoveResourcePoliciesRequest object.

  Fields:
    instance: The instance name for this request.
    instancesRemoveResourcePoliciesRequest: A
      InstancesRemoveResourcePoliciesRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesRemoveResourcePoliciesRequest = _messages.MessageField('InstancesRemoveResourcePoliciesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesResetRequest(_messages.Message):
  r"""A ComputeInstancesResetRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesResumeRequest(_messages.Message):
  r"""A ComputeInstancesResumeRequest object.

  Fields:
    instance: Name of the instance resource to resume.
    instancesResumeRequest: A InstancesResumeRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesResumeRequest = _messages.MessageField('InstancesResumeRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSendDiagnosticInterruptRequest(_messages.Message):
  r"""A ComputeInstancesSendDiagnosticInterruptRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesSendDiagnosticInterruptResponse(_messages.Message):
  r"""An empty ComputeInstancesSendDiagnosticInterrupt response."""


class ComputeInstancesSetDeletionProtectionRequest(_messages.Message):
  r"""A ComputeInstancesSetDeletionProtectionRequest object.

  Fields:
    deletionProtection: Whether the resource should be protected against
      deletion.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    resource: Name or id of the resource for this request.
    zone: The name of the zone for this request.
  """

  deletionProtection = _messages.BooleanField(1, default=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  resource = _messages.StringField(4, required=True)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetDiskAutoDeleteRequest(_messages.Message):
  r"""A ComputeInstancesSetDiskAutoDeleteRequest object.

  Fields:
    autoDelete: Whether to auto-delete the disk when the instance is deleted.
    deviceName: The device name of the disk to modify. Make a get() request on
      the instance to view currently attached disks and device names.
    instance: The instance name for this request.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  autoDelete = _messages.BooleanField(1, required=True)
  deviceName = _messages.StringField(2, required=True)
  instance = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)
  zone = _messages.StringField(6, required=True)


class ComputeInstancesSetIamPolicyRequest(_messages.Message):
  r"""A ComputeInstancesSetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    zone: The name of the zone for this request.
    zoneSetPolicyRequest: A ZoneSetPolicyRequest resource to be passed as the
      request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)
  zoneSetPolicyRequest = _messages.MessageField('ZoneSetPolicyRequest', 4)


class ComputeInstancesSetLabelsRequest(_messages.Message):
  r"""A ComputeInstancesSetLabelsRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    instancesSetLabelsRequest: A InstancesSetLabelsRequest resource to be
      passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesSetLabelsRequest = _messages.MessageField('InstancesSetLabelsRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetMachineResourcesRequest(_messages.Message):
  r"""A ComputeInstancesSetMachineResourcesRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    instancesSetMachineResourcesRequest: A InstancesSetMachineResourcesRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesSetMachineResourcesRequest = _messages.MessageField('InstancesSetMachineResourcesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetMachineTypeRequest(_messages.Message):
  r"""A ComputeInstancesSetMachineTypeRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    instancesSetMachineTypeRequest: A InstancesSetMachineTypeRequest resource
      to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesSetMachineTypeRequest = _messages.MessageField('InstancesSetMachineTypeRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetMetadataRequest(_messages.Message):
  r"""A ComputeInstancesSetMetadataRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    metadata: A Metadata resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  metadata = _messages.MessageField('Metadata', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetMinCpuPlatformRequest(_messages.Message):
  r"""A ComputeInstancesSetMinCpuPlatformRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    instancesSetMinCpuPlatformRequest: A InstancesSetMinCpuPlatformRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesSetMinCpuPlatformRequest = _messages.MessageField('InstancesSetMinCpuPlatformRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetNameRequest(_messages.Message):
  r"""A ComputeInstancesSetNameRequest object.

  Fields:
    instance: The instance name for this request.
    instancesSetNameRequest: A InstancesSetNameRequest resource to be passed
      as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesSetNameRequest = _messages.MessageField('InstancesSetNameRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetSchedulingRequest(_messages.Message):
  r"""A ComputeInstancesSetSchedulingRequest object.

  Fields:
    instance: Instance name for this request.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    scheduling: A Scheduling resource to be passed as the request body.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  scheduling = _messages.MessageField('Scheduling', 4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetServiceAccountRequest(_messages.Message):
  r"""A ComputeInstancesSetServiceAccountRequest object.

  Fields:
    instance: Name of the instance resource to start.
    instancesSetServiceAccountRequest: A InstancesSetServiceAccountRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesSetServiceAccountRequest = _messages.MessageField('InstancesSetServiceAccountRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetShieldedInstanceIntegrityPolicyRequest(_messages.Message):
  r"""A ComputeInstancesSetShieldedInstanceIntegrityPolicyRequest object.

  Fields:
    instance: Name or id of the instance scoping this request.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    shieldedInstanceIntegrityPolicy: A ShieldedInstanceIntegrityPolicy
      resource to be passed as the request body.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  shieldedInstanceIntegrityPolicy = _messages.MessageField('ShieldedInstanceIntegrityPolicy', 4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetShieldedVmIntegrityPolicyRequest(_messages.Message):
  r"""A ComputeInstancesSetShieldedVmIntegrityPolicyRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    shieldedVmIntegrityPolicy: A ShieldedVmIntegrityPolicy resource to be
      passed as the request body.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  shieldedVmIntegrityPolicy = _messages.MessageField('ShieldedVmIntegrityPolicy', 4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetTagsRequest(_messages.Message):
  r"""A ComputeInstancesSetTagsRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    tags: A Tags resource to be passed as the request body.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  tags = _messages.MessageField('Tags', 4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSimulateMaintenanceEventRequest(_messages.Message):
  r"""A ComputeInstancesSimulateMaintenanceEventRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesStartRequest(_messages.Message):
  r"""A ComputeInstancesStartRequest object.

  Fields:
    instance: Name of the instance resource to start.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesStartWithEncryptionKeyRequest(_messages.Message):
  r"""A ComputeInstancesStartWithEncryptionKeyRequest object.

  Fields:
    instance: Name of the instance resource to start.
    instancesStartWithEncryptionKeyRequest: A
      InstancesStartWithEncryptionKeyRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesStartWithEncryptionKeyRequest = _messages.MessageField('InstancesStartWithEncryptionKeyRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesStopRequest(_messages.Message):
  r"""A ComputeInstancesStopRequest object.

  Fields:
    instance: Name of the instance resource to stop.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesSuspendRequest(_messages.Message):
  r"""A ComputeInstancesSuspendRequest object.

  Fields:
    discardLocalSsd: If true, discard the contents of any attached localSSD
      partitions. Default value is false (== preserve localSSD data).
    instance: Name of the instance resource to suspend.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  discardLocalSsd = _messages.BooleanField(1)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeInstancesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesUpdateAccessConfigRequest(_messages.Message):
  r"""A ComputeInstancesUpdateAccessConfigRequest object.

  Fields:
    accessConfig: A AccessConfig resource to be passed as the request body.
    instance: The instance name for this request.
    networkInterface: The name of the network interface where the access
      config is attached.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  accessConfig = _messages.MessageField('AccessConfig', 1)
  instance = _messages.StringField(2, required=True)
  networkInterface = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)
  zone = _messages.StringField(6, required=True)


class ComputeInstancesUpdateDisplayDeviceRequest(_messages.Message):
  r"""A ComputeInstancesUpdateDisplayDeviceRequest object.

  Fields:
    displayDevice: A DisplayDevice resource to be passed as the request body.
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  displayDevice = _messages.MessageField('DisplayDevice', 1)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesUpdateNetworkInterfaceRequest(_messages.Message):
  r"""A ComputeInstancesUpdateNetworkInterfaceRequest object.

  Fields:
    instance: The instance name for this request.
    networkInterface: The name of the network interface to update.
    networkInterfaceResource: A NetworkInterface resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  networkInterface = _messages.StringField(2, required=True)
  networkInterfaceResource = _messages.MessageField('NetworkInterface', 3)
  project = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)
  zone = _messages.StringField(6, required=True)


class ComputeInstancesUpdateRequest(_messages.Message):
  r"""A ComputeInstancesUpdateRequest object.

  Enums:
    MinimalActionValueValuesEnum: Specifies the action to take when updating
      an instance even if the updated properties do not require it. If not
      specified, then Compute Engine acts based on the minimum action that the
      updated properties require.
    MostDisruptiveAllowedActionValueValuesEnum: Specifies the most disruptive
      action that can be taken on the instance as part of the update. Compute
      Engine returns an error if the instance properties require a more
      disruptive action as part of the instance update. Valid options from
      lowest to highest are NO_EFFECT, REFRESH, and RESTART.

  Fields:
    instance: Name of the instance resource to update.
    instanceResource: A Instance resource to be passed as the request body.
    minimalAction: Specifies the action to take when updating an instance even
      if the updated properties do not require it. If not specified, then
      Compute Engine acts based on the minimum action that the updated
      properties require.
    mostDisruptiveAllowedAction: Specifies the most disruptive action that can
      be taken on the instance as part of the update. Compute Engine returns
      an error if the instance properties require a more disruptive action as
      part of the instance update. Valid options from lowest to highest are
      NO_EFFECT, REFRESH, and RESTART.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  class MinimalActionValueValuesEnum(_messages.Enum):
    r"""Specifies the action to take when updating an instance even if the
    updated properties do not require it. If not specified, then Compute
    Engine acts based on the minimum action that the updated properties
    require.

    Values:
      INVALID: <no description>
      NO_EFFECT: No changes can be made to the instance.
      REFRESH: The instance will not restart.
      RESTART: The instance will restart.
    """
    INVALID = 0
    NO_EFFECT = 1
    REFRESH = 2
    RESTART = 3

  class MostDisruptiveAllowedActionValueValuesEnum(_messages.Enum):
    r"""Specifies the most disruptive action that can be taken on the instance
    as part of the update. Compute Engine returns an error if the instance
    properties require a more disruptive action as part of the instance
    update. Valid options from lowest to highest are NO_EFFECT, REFRESH, and
    RESTART.

    Values:
      INVALID: <no description>
      NO_EFFECT: No changes can be made to the instance.
      REFRESH: The instance will not restart.
      RESTART: The instance will restart.
    """
    INVALID = 0
    NO_EFFECT = 1
    REFRESH = 2
    RESTART = 3

  instance = _messages.StringField(1, required=True)
  instanceResource = _messages.MessageField('Instance', 2)
  minimalAction = _messages.EnumField('MinimalActionValueValuesEnum', 3)
  mostDisruptiveAllowedAction = _messages.EnumField('MostDisruptiveAllowedActionValueValuesEnum', 4)
  project = _messages.StringField(5, required=True)
  requestId = _messages.StringField(6)
  zone = _messages.StringField(7, required=True)


class ComputeInstancesUpdateShieldedInstanceConfigRequest(_messages.Message):
  r"""A ComputeInstancesUpdateShieldedInstanceConfigRequest object.

  Fields:
    instance: Name or id of the instance scoping this request.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    shieldedInstanceConfig: A ShieldedInstanceConfig resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  shieldedInstanceConfig = _messages.MessageField('ShieldedInstanceConfig', 4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesUpdateShieldedVmConfigRequest(_messages.Message):
  r"""A ComputeInstancesUpdateShieldedVmConfigRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    shieldedVmConfig: A ShieldedVmConfig resource to be passed as the request
      body.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  shieldedVmConfig = _messages.MessageField('ShieldedVmConfig', 4)
  zone = _messages.StringField(5, required=True)


class ComputeInterconnectAttachmentsAggregatedListRequest(_messages.Message):
  r"""A ComputeInterconnectAttachmentsAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeInterconnectAttachmentsDeleteRequest(_messages.Message):
  r"""A ComputeInterconnectAttachmentsDeleteRequest object.

  Fields:
    interconnectAttachment: Name of the interconnect attachment to delete.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  interconnectAttachment = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeInterconnectAttachmentsGetRequest(_messages.Message):
  r"""A ComputeInterconnectAttachmentsGetRequest object.

  Fields:
    interconnectAttachment: Name of the interconnect attachment to return.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  interconnectAttachment = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeInterconnectAttachmentsInsertRequest(_messages.Message):
  r"""A ComputeInterconnectAttachmentsInsertRequest object.

  Fields:
    interconnectAttachment: A InterconnectAttachment resource to be passed as
      the request body.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    validateOnly: If true, the request will not be committed.
  """

  interconnectAttachment = _messages.MessageField('InterconnectAttachment', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class ComputeInterconnectAttachmentsListRequest(_messages.Message):
  r"""A ComputeInterconnectAttachmentsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeInterconnectAttachmentsPatchRequest(_messages.Message):
  r"""A ComputeInterconnectAttachmentsPatchRequest object.

  Fields:
    interconnectAttachment: Name of the interconnect attachment to patch.
    interconnectAttachmentResource: A InterconnectAttachment resource to be
      passed as the request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  interconnectAttachment = _messages.StringField(1, required=True)
  interconnectAttachmentResource = _messages.MessageField('InterconnectAttachment', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeInterconnectAttachmentsSetLabelsRequest(_messages.Message):
  r"""A ComputeInterconnectAttachmentsSetLabelsRequest object.

  Fields:
    project: Project ID for this request.
    region: The region for this request.
    regionSetLabelsRequest: A RegionSetLabelsRequest resource to be passed as
      the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    resource: Name or id of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionSetLabelsRequest = _messages.MessageField('RegionSetLabelsRequest', 3)
  requestId = _messages.StringField(4)
  resource = _messages.StringField(5, required=True)


class ComputeInterconnectAttachmentsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeInterconnectAttachmentsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeInterconnectLocationsGetRequest(_messages.Message):
  r"""A ComputeInterconnectLocationsGetRequest object.

  Fields:
    interconnectLocation: Name of the interconnect location to return.
    project: Project ID for this request.
  """

  interconnectLocation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeInterconnectLocationsListRequest(_messages.Message):
  r"""A ComputeInterconnectLocationsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeInterconnectsDeleteRequest(_messages.Message):
  r"""A ComputeInterconnectsDeleteRequest object.

  Fields:
    interconnect: Name of the interconnect to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  interconnect = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeInterconnectsGetDiagnosticsRequest(_messages.Message):
  r"""A ComputeInterconnectsGetDiagnosticsRequest object.

  Fields:
    interconnect: Name of the interconnect resource to query.
    project: Project ID for this request.
  """

  interconnect = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeInterconnectsGetRequest(_messages.Message):
  r"""A ComputeInterconnectsGetRequest object.

  Fields:
    interconnect: Name of the interconnect to return.
    project: Project ID for this request.
  """

  interconnect = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeInterconnectsInsertRequest(_messages.Message):
  r"""A ComputeInterconnectsInsertRequest object.

  Fields:
    interconnect: A Interconnect resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  interconnect = _messages.MessageField('Interconnect', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeInterconnectsListRequest(_messages.Message):
  r"""A ComputeInterconnectsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeInterconnectsPatchRequest(_messages.Message):
  r"""A ComputeInterconnectsPatchRequest object.

  Fields:
    interconnect: Name of the interconnect to update.
    interconnectResource: A Interconnect resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  interconnect = _messages.StringField(1, required=True)
  interconnectResource = _messages.MessageField('Interconnect', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeInterconnectsSetLabelsRequest(_messages.Message):
  r"""A ComputeInterconnectsSetLabelsRequest object.

  Fields:
    globalSetLabelsRequest: A GlobalSetLabelsRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
  """

  globalSetLabelsRequest = _messages.MessageField('GlobalSetLabelsRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeInterconnectsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeInterconnectsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeLicenseCodesGetRequest(_messages.Message):
  r"""A ComputeLicenseCodesGetRequest object.

  Fields:
    licenseCode: Number corresponding to the License code resource to return.
    project: Project ID for this request.
  """

  licenseCode = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeLicenseCodesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeLicenseCodesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeLicensesDeleteRequest(_messages.Message):
  r"""A ComputeLicensesDeleteRequest object.

  Fields:
    license: Name of the license resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  license = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeLicensesGetIamPolicyRequest(_messages.Message):
  r"""A ComputeLicensesGetIamPolicyRequest object.

  Fields:
    optionsRequestedPolicyVersion: Requested IAM Policy version.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
  """

  optionsRequestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeLicensesGetRequest(_messages.Message):
  r"""A ComputeLicensesGetRequest object.

  Fields:
    license: Name of the License resource to return.
    project: Project ID for this request.
  """

  license = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeLicensesInsertRequest(_messages.Message):
  r"""A ComputeLicensesInsertRequest object.

  Fields:
    license: A License resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  license = _messages.MessageField('License', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeLicensesListRequest(_messages.Message):
  r"""A ComputeLicensesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeLicensesSetIamPolicyRequest(_messages.Message):
  r"""A ComputeLicensesSetIamPolicyRequest object.

  Fields:
    globalSetPolicyRequest: A GlobalSetPolicyRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
  """

  globalSetPolicyRequest = _messages.MessageField('GlobalSetPolicyRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeLicensesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeLicensesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeMachineImagesDeleteRequest(_messages.Message):
  r"""A ComputeMachineImagesDeleteRequest object.

  Fields:
    machineImage: The name of the machine image to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  machineImage = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeMachineImagesGetIamPolicyRequest(_messages.Message):
  r"""A ComputeMachineImagesGetIamPolicyRequest object.

  Fields:
    optionsRequestedPolicyVersion: Requested IAM Policy version.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
  """

  optionsRequestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeMachineImagesGetRequest(_messages.Message):
  r"""A ComputeMachineImagesGetRequest object.

  Fields:
    machineImage: The name of the machine image.
    project: Project ID for this request.
  """

  machineImage = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeMachineImagesInsertRequest(_messages.Message):
  r"""A ComputeMachineImagesInsertRequest object.

  Fields:
    machineImage: A MachineImage resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    sourceInstance: Required. Source instance that is used to create the
      machine image from.
  """

  machineImage = _messages.MessageField('MachineImage', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  sourceInstance = _messages.StringField(4)


class ComputeMachineImagesListRequest(_messages.Message):
  r"""A ComputeMachineImagesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeMachineImagesSetIamPolicyRequest(_messages.Message):
  r"""A ComputeMachineImagesSetIamPolicyRequest object.

  Fields:
    globalSetPolicyRequest: A GlobalSetPolicyRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
  """

  globalSetPolicyRequest = _messages.MessageField('GlobalSetPolicyRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeMachineImagesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeMachineImagesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeMachineTypesAggregatedListRequest(_messages.Message):
  r"""A ComputeMachineTypesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeMachineTypesGetRequest(_messages.Message):
  r"""A ComputeMachineTypesGetRequest object.

  Fields:
    machineType: Name of the machine type to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  machineType = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeMachineTypesListRequest(_messages.Message):
  r"""A ComputeMachineTypesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)
  zone = _messages.StringField(7, required=True)


class ComputeNetworkEndpointGroupsAggregatedListRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeNetworkEndpointGroupsAttachNetworkEndpointsRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsAttachNetworkEndpointsRequest object.

  Fields:
    networkEndpointGroup: The name of the network endpoint group where you are
      attaching network endpoints to. It should comply with RFC1035.
    networkEndpointGroupsAttachEndpointsRequest: A
      NetworkEndpointGroupsAttachEndpointsRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the network endpoint group is located. It
      should comply with RFC1035.
  """

  networkEndpointGroup = _messages.StringField(1, required=True)
  networkEndpointGroupsAttachEndpointsRequest = _messages.MessageField('NetworkEndpointGroupsAttachEndpointsRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeNetworkEndpointGroupsDeleteRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsDeleteRequest object.

  Fields:
    networkEndpointGroup: The name of the network endpoint group to delete. It
      should comply with RFC1035.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the network endpoint group is located. It
      should comply with RFC1035.
  """

  networkEndpointGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeNetworkEndpointGroupsDetachNetworkEndpointsRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsDetachNetworkEndpointsRequest object.

  Fields:
    networkEndpointGroup: The name of the network endpoint group where you are
      removing network endpoints. It should comply with RFC1035.
    networkEndpointGroupsDetachEndpointsRequest: A
      NetworkEndpointGroupsDetachEndpointsRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the network endpoint group is located. It
      should comply with RFC1035.
  """

  networkEndpointGroup = _messages.StringField(1, required=True)
  networkEndpointGroupsDetachEndpointsRequest = _messages.MessageField('NetworkEndpointGroupsDetachEndpointsRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeNetworkEndpointGroupsGetRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsGetRequest object.

  Fields:
    networkEndpointGroup: The name of the network endpoint group. It should
      comply with RFC1035.
    project: Project ID for this request.
    zone: The name of the zone where the network endpoint group is located. It
      should comply with RFC1035.
  """

  networkEndpointGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeNetworkEndpointGroupsInsertRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsInsertRequest object.

  Fields:
    networkEndpointGroup: A NetworkEndpointGroup resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where you want to create the network endpoint
      group. It should comply with RFC1035.
  """

  networkEndpointGroup = _messages.MessageField('NetworkEndpointGroup', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeNetworkEndpointGroupsListNetworkEndpointsRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsListNetworkEndpointsRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    networkEndpointGroup: The name of the network endpoint group from which
      you want to generate a list of included network endpoints. It should
      comply with RFC1035.
    networkEndpointGroupsListEndpointsRequest: A
      NetworkEndpointGroupsListEndpointsRequest resource to be passed as the
      request body.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: The name of the zone where the network endpoint group is located. It
      should comply with RFC1035.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  networkEndpointGroup = _messages.StringField(3, required=True)
  networkEndpointGroupsListEndpointsRequest = _messages.MessageField('NetworkEndpointGroupsListEndpointsRequest', 4)
  orderBy = _messages.StringField(5)
  pageToken = _messages.StringField(6)
  project = _messages.StringField(7, required=True)
  returnPartialSuccess = _messages.BooleanField(8)
  zone = _messages.StringField(9, required=True)


class ComputeNetworkEndpointGroupsListRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: The name of the zone where the network endpoint group is located. It
      should comply with RFC1035.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)
  zone = _messages.StringField(7, required=True)


class ComputeNetworkEndpointGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeNetworksAddPeeringRequest(_messages.Message):
  r"""A ComputeNetworksAddPeeringRequest object.

  Fields:
    network: Name of the network resource to add peering to.
    networksAddPeeringRequest: A NetworksAddPeeringRequest resource to be
      passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  network = _messages.StringField(1, required=True)
  networksAddPeeringRequest = _messages.MessageField('NetworksAddPeeringRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeNetworksDeleteRequest(_messages.Message):
  r"""A ComputeNetworksDeleteRequest object.

  Fields:
    network: Name of the network to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  network = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeNetworksGetEffectiveFirewallsRequest(_messages.Message):
  r"""A ComputeNetworksGetEffectiveFirewallsRequest object.

  Fields:
    network: Name of the network for this request.
    project: Project ID for this request.
  """

  network = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeNetworksGetRequest(_messages.Message):
  r"""A ComputeNetworksGetRequest object.

  Fields:
    network: Name of the network to return.
    project: Project ID for this request.
  """

  network = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeNetworksInsertRequest(_messages.Message):
  r"""A ComputeNetworksInsertRequest object.

  Fields:
    network: A Network resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  network = _messages.MessageField('Network', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeNetworksListPeeringRoutesRequest(_messages.Message):
  r"""A ComputeNetworksListPeeringRoutesRequest object.

  Enums:
    DirectionValueValuesEnum: The direction of the exchanged routes.

  Fields:
    direction: The direction of the exchanged routes.
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    network: Name of the network for this request.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    peeringName: The response will show routes exchanged over the given
      peering connection.
    project: Project ID for this request.
    region: The region of the request. The response will include all subnet
      routes, static routes and dynamic routes in the region.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  class DirectionValueValuesEnum(_messages.Enum):
    r"""The direction of the exchanged routes.

    Values:
      INCOMING: For routes exported from peer network.
      OUTGOING: For routes exported from local network.
    """
    INCOMING = 0
    OUTGOING = 1

  direction = _messages.EnumField('DirectionValueValuesEnum', 1)
  filter = _messages.StringField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  network = _messages.StringField(4, required=True)
  orderBy = _messages.StringField(5)
  pageToken = _messages.StringField(6)
  peeringName = _messages.StringField(7)
  project = _messages.StringField(8, required=True)
  region = _messages.StringField(9)
  returnPartialSuccess = _messages.BooleanField(10)


class ComputeNetworksListRequest(_messages.Message):
  r"""A ComputeNetworksListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeNetworksPatchRequest(_messages.Message):
  r"""A ComputeNetworksPatchRequest object.

  Fields:
    network: Name of the network to update.
    networkResource: A Network resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  network = _messages.StringField(1, required=True)
  networkResource = _messages.MessageField('Network', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeNetworksRemovePeeringRequest(_messages.Message):
  r"""A ComputeNetworksRemovePeeringRequest object.

  Fields:
    network: Name of the network resource to remove peering from.
    networksRemovePeeringRequest: A NetworksRemovePeeringRequest resource to
      be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  network = _messages.StringField(1, required=True)
  networksRemovePeeringRequest = _messages.MessageField('NetworksRemovePeeringRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeNetworksSwitchToCustomModeRequest(_messages.Message):
  r"""A ComputeNetworksSwitchToCustomModeRequest object.

  Fields:
    network: Name of the network to be updated.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  network = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeNetworksTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeNetworksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeNetworksUpdatePeeringRequest(_messages.Message):
  r"""A ComputeNetworksUpdatePeeringRequest object.

  Fields:
    network: Name of the network resource which the updated peering is
      belonging to.
    networksUpdatePeeringRequest: A NetworksUpdatePeeringRequest resource to
      be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  network = _messages.StringField(1, required=True)
  networksUpdatePeeringRequest = _messages.MessageField('NetworksUpdatePeeringRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeNodeGroupsAddNodesRequest(_messages.Message):
  r"""A ComputeNodeGroupsAddNodesRequest object.

  Fields:
    nodeGroup: Name of the NodeGroup resource.
    nodeGroupsAddNodesRequest: A NodeGroupsAddNodesRequest resource to be
      passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  nodeGroup = _messages.StringField(1, required=True)
  nodeGroupsAddNodesRequest = _messages.MessageField('NodeGroupsAddNodesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeNodeGroupsAggregatedListRequest(_messages.Message):
  r"""A ComputeNodeGroupsAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeNodeGroupsDeleteNodesRequest(_messages.Message):
  r"""A ComputeNodeGroupsDeleteNodesRequest object.

  Fields:
    nodeGroup: Name of the NodeGroup resource whose nodes will be deleted.
    nodeGroupsDeleteNodesRequest: A NodeGroupsDeleteNodesRequest resource to
      be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  nodeGroup = _messages.StringField(1, required=True)
  nodeGroupsDeleteNodesRequest = _messages.MessageField('NodeGroupsDeleteNodesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeNodeGroupsDeleteRequest(_messages.Message):
  r"""A ComputeNodeGroupsDeleteRequest object.

  Fields:
    nodeGroup: Name of the NodeGroup resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  nodeGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeNodeGroupsGetIamPolicyRequest(_messages.Message):
  r"""A ComputeNodeGroupsGetIamPolicyRequest object.

  Fields:
    optionsRequestedPolicyVersion: Requested IAM Policy version.
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    zone: The name of the zone for this request.
  """

  optionsRequestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeNodeGroupsGetRequest(_messages.Message):
  r"""A ComputeNodeGroupsGetRequest object.

  Fields:
    nodeGroup: Name of the node group to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  nodeGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeNodeGroupsInsertRequest(_messages.Message):
  r"""A ComputeNodeGroupsInsertRequest object.

  Fields:
    initialNodeCount: Initial count of nodes in the node group.
    nodeGroup: A NodeGroup resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  initialNodeCount = _messages.IntegerField(1, required=True, variant=_messages.Variant.INT32)
  nodeGroup = _messages.MessageField('NodeGroup', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeNodeGroupsListNodesRequest(_messages.Message):
  r"""A ComputeNodeGroupsListNodesRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    nodeGroup: Name of the NodeGroup resource whose nodes you want to list.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  nodeGroup = _messages.StringField(3, required=True)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)
  zone = _messages.StringField(8, required=True)


class ComputeNodeGroupsListRequest(_messages.Message):
  r"""A ComputeNodeGroupsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)
  zone = _messages.StringField(7, required=True)


class ComputeNodeGroupsPatchRequest(_messages.Message):
  r"""A ComputeNodeGroupsPatchRequest object.

  Fields:
    nodeGroup: Name of the NodeGroup resource to update.
    nodeGroupResource: A NodeGroup resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  nodeGroup = _messages.StringField(1, required=True)
  nodeGroupResource = _messages.MessageField('NodeGroup', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeNodeGroupsSetIamPolicyRequest(_messages.Message):
  r"""A ComputeNodeGroupsSetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    zone: The name of the zone for this request.
    zoneSetPolicyRequest: A ZoneSetPolicyRequest resource to be passed as the
      request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)
  zoneSetPolicyRequest = _messages.MessageField('ZoneSetPolicyRequest', 4)


class ComputeNodeGroupsSetNodeTemplateRequest(_messages.Message):
  r"""A ComputeNodeGroupsSetNodeTemplateRequest object.

  Fields:
    nodeGroup: Name of the NodeGroup resource to update.
    nodeGroupsSetNodeTemplateRequest: A NodeGroupsSetNodeTemplateRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  nodeGroup = _messages.StringField(1, required=True)
  nodeGroupsSetNodeTemplateRequest = _messages.MessageField('NodeGroupsSetNodeTemplateRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeNodeGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeNodeGroupsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeNodeTemplatesAggregatedListRequest(_messages.Message):
  r"""A ComputeNodeTemplatesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeNodeTemplatesDeleteRequest(_messages.Message):
  r"""A ComputeNodeTemplatesDeleteRequest object.

  Fields:
    nodeTemplate: Name of the NodeTemplate resource to delete.
    project: Project ID for this request.
    region: The name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  nodeTemplate = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeNodeTemplatesGetIamPolicyRequest(_messages.Message):
  r"""A ComputeNodeTemplatesGetIamPolicyRequest object.

  Fields:
    optionsRequestedPolicyVersion: Requested IAM Policy version.
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name or id of the resource for this request.
  """

  optionsRequestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  resource = _messages.StringField(4, required=True)


class ComputeNodeTemplatesGetRequest(_messages.Message):
  r"""A ComputeNodeTemplatesGetRequest object.

  Fields:
    nodeTemplate: Name of the node template to return.
    project: Project ID for this request.
    region: The name of the region for this request.
  """

  nodeTemplate = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeNodeTemplatesInsertRequest(_messages.Message):
  r"""A ComputeNodeTemplatesInsertRequest object.

  Fields:
    nodeTemplate: A NodeTemplate resource to be passed as the request body.
    project: Project ID for this request.
    region: The name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  nodeTemplate = _messages.MessageField('NodeTemplate', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeNodeTemplatesListRequest(_messages.Message):
  r"""A ComputeNodeTemplatesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: The name of the region for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeNodeTemplatesSetIamPolicyRequest(_messages.Message):
  r"""A ComputeNodeTemplatesSetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    regionSetPolicyRequest: A RegionSetPolicyRequest resource to be passed as
      the request body.
    resource: Name or id of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionSetPolicyRequest = _messages.MessageField('RegionSetPolicyRequest', 3)
  resource = _messages.StringField(4, required=True)


class ComputeNodeTemplatesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeNodeTemplatesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeNodeTypesAggregatedListRequest(_messages.Message):
  r"""A ComputeNodeTypesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeNodeTypesGetRequest(_messages.Message):
  r"""A ComputeNodeTypesGetRequest object.

  Fields:
    nodeType: Name of the node type to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  nodeType = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeNodeTypesListRequest(_messages.Message):
  r"""A ComputeNodeTypesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)
  zone = _messages.StringField(7, required=True)


class ComputeOrganizationSecurityPoliciesAddAssociationRequest(_messages.Message):
  r"""A ComputeOrganizationSecurityPoliciesAddAssociationRequest object.

  Fields:
    replaceExistingAssociation: Indicates whether or not to replace it if an
      association of the attachment already exists. This is false by default,
      in which case an error will be returned if an association already
      exists.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    securityPolicy: Name of the security policy to update.
    securityPolicyAssociation: A SecurityPolicyAssociation resource to be
      passed as the request body.
  """

  replaceExistingAssociation = _messages.BooleanField(1)
  requestId = _messages.StringField(2)
  securityPolicy = _messages.StringField(3, required=True)
  securityPolicyAssociation = _messages.MessageField('SecurityPolicyAssociation', 4)


class ComputeOrganizationSecurityPoliciesAddRuleRequest(_messages.Message):
  r"""A ComputeOrganizationSecurityPoliciesAddRuleRequest object.

  Fields:
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    securityPolicy: Name of the security policy to update.
    securityPolicyRule: A SecurityPolicyRule resource to be passed as the
      request body.
  """

  requestId = _messages.StringField(1)
  securityPolicy = _messages.StringField(2, required=True)
  securityPolicyRule = _messages.MessageField('SecurityPolicyRule', 3)


class ComputeOrganizationSecurityPoliciesCopyRulesRequest(_messages.Message):
  r"""A ComputeOrganizationSecurityPoliciesCopyRulesRequest object.

  Fields:
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    securityPolicy: Name of the security policy to update.
    sourceSecurityPolicy: The security policy from which to copy rules.
  """

  requestId = _messages.StringField(1)
  securityPolicy = _messages.StringField(2, required=True)
  sourceSecurityPolicy = _messages.StringField(3)


class ComputeOrganizationSecurityPoliciesDeleteRequest(_messages.Message):
  r"""A ComputeOrganizationSecurityPoliciesDeleteRequest object.

  Fields:
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    securityPolicy: Name of the security policy to delete.
  """

  requestId = _messages.StringField(1)
  securityPolicy = _messages.StringField(2, required=True)


class ComputeOrganizationSecurityPoliciesGetAssociationRequest(_messages.Message):
  r"""A ComputeOrganizationSecurityPoliciesGetAssociationRequest object.

  Fields:
    name: The name of the association to get from the security policy.
    securityPolicy: Name of the security policy to which the queried rule
      belongs.
  """

  name = _messages.StringField(1)
  securityPolicy = _messages.StringField(2, required=True)


class ComputeOrganizationSecurityPoliciesGetRequest(_messages.Message):
  r"""A ComputeOrganizationSecurityPoliciesGetRequest object.

  Fields:
    securityPolicy: Name of the security policy to get.
  """

  securityPolicy = _messages.StringField(1, required=True)


class ComputeOrganizationSecurityPoliciesGetRuleRequest(_messages.Message):
  r"""A ComputeOrganizationSecurityPoliciesGetRuleRequest object.

  Fields:
    priority: The priority of the rule to get from the security policy.
    securityPolicy: Name of the security policy to which the queried rule
      belongs.
  """

  priority = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  securityPolicy = _messages.StringField(2, required=True)


class ComputeOrganizationSecurityPoliciesInsertRequest(_messages.Message):
  r"""A ComputeOrganizationSecurityPoliciesInsertRequest object.

  Fields:
    parentId: Parent ID for this request. The ID can be either be
      "folders/[FOLDER_ID]" if the parent is a folder or
      "organizations/[ORGANIZATION_ID]" if the parent is an organization.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    securityPolicy: A SecurityPolicy resource to be passed as the request
      body.
  """

  parentId = _messages.StringField(1)
  requestId = _messages.StringField(2)
  securityPolicy = _messages.MessageField('SecurityPolicy', 3)


class ComputeOrganizationSecurityPoliciesListAssociationsRequest(_messages.Message):
  r"""A ComputeOrganizationSecurityPoliciesListAssociationsRequest object.

  Fields:
    targetResource: The target resource to list associations. It is an
      organization, or a folder.
  """

  targetResource = _messages.StringField(1)


class ComputeOrganizationSecurityPoliciesListRequest(_messages.Message):
  r"""A ComputeOrganizationSecurityPoliciesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    parentId: Parent ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  parentId = _messages.StringField(5)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeOrganizationSecurityPoliciesMoveRequest(_messages.Message):
  r"""A ComputeOrganizationSecurityPoliciesMoveRequest object.

  Fields:
    parentId: The new parent of the security policy.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    securityPolicy: Name of the security policy to update.
  """

  parentId = _messages.StringField(1)
  requestId = _messages.StringField(2)
  securityPolicy = _messages.StringField(3, required=True)


class ComputeOrganizationSecurityPoliciesPatchRequest(_messages.Message):
  r"""A ComputeOrganizationSecurityPoliciesPatchRequest object.

  Fields:
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    securityPolicy: Name of the security policy to update.
    securityPolicyResource: A SecurityPolicy resource to be passed as the
      request body.
  """

  requestId = _messages.StringField(1)
  securityPolicy = _messages.StringField(2, required=True)
  securityPolicyResource = _messages.MessageField('SecurityPolicy', 3)


class ComputeOrganizationSecurityPoliciesPatchRuleRequest(_messages.Message):
  r"""A ComputeOrganizationSecurityPoliciesPatchRuleRequest object.

  Fields:
    priority: The priority of the rule to patch.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    securityPolicy: Name of the security policy to update.
    securityPolicyRule: A SecurityPolicyRule resource to be passed as the
      request body.
  """

  priority = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  requestId = _messages.StringField(2)
  securityPolicy = _messages.StringField(3, required=True)
  securityPolicyRule = _messages.MessageField('SecurityPolicyRule', 4)


class ComputeOrganizationSecurityPoliciesRemoveAssociationRequest(_messages.Message):
  r"""A ComputeOrganizationSecurityPoliciesRemoveAssociationRequest object.

  Fields:
    name: Name for the attachment that will be removed.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    securityPolicy: Name of the security policy to update.
  """

  name = _messages.StringField(1)
  requestId = _messages.StringField(2)
  securityPolicy = _messages.StringField(3, required=True)


class ComputeOrganizationSecurityPoliciesRemoveRuleRequest(_messages.Message):
  r"""A ComputeOrganizationSecurityPoliciesRemoveRuleRequest object.

  Fields:
    priority: The priority of the rule to remove from the security policy.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    securityPolicy: Name of the security policy to update.
  """

  priority = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  requestId = _messages.StringField(2)
  securityPolicy = _messages.StringField(3, required=True)


class ComputePacketMirroringsAggregatedListRequest(_messages.Message):
  r"""A ComputePacketMirroringsAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputePacketMirroringsDeleteRequest(_messages.Message):
  r"""A ComputePacketMirroringsDeleteRequest object.

  Fields:
    packetMirroring: Name of the PacketMirroring resource to delete.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  packetMirroring = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputePacketMirroringsGetRequest(_messages.Message):
  r"""A ComputePacketMirroringsGetRequest object.

  Fields:
    packetMirroring: Name of the PacketMirroring resource to return.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  packetMirroring = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputePacketMirroringsInsertRequest(_messages.Message):
  r"""A ComputePacketMirroringsInsertRequest object.

  Fields:
    packetMirroring: A PacketMirroring resource to be passed as the request
      body.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  packetMirroring = _messages.MessageField('PacketMirroring', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputePacketMirroringsListRequest(_messages.Message):
  r"""A ComputePacketMirroringsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputePacketMirroringsPatchRequest(_messages.Message):
  r"""A ComputePacketMirroringsPatchRequest object.

  Fields:
    packetMirroring: Name of the PacketMirroring resource to patch.
    packetMirroringResource: A PacketMirroring resource to be passed as the
      request body.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  packetMirroring = _messages.StringField(1, required=True)
  packetMirroringResource = _messages.MessageField('PacketMirroring', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputePacketMirroringsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputePacketMirroringsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeProjectsDisableXpnHostRequest(_messages.Message):
  r"""A ComputeProjectsDisableXpnHostRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class ComputeProjectsDisableXpnResourceRequest(_messages.Message):
  r"""A ComputeProjectsDisableXpnResourceRequest object.

  Fields:
    project: Project ID for this request.
    projectsDisableXpnResourceRequest: A ProjectsDisableXpnResourceRequest
      resource to be passed as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  projectsDisableXpnResourceRequest = _messages.MessageField('ProjectsDisableXpnResourceRequest', 2)
  requestId = _messages.StringField(3)


class ComputeProjectsEnableXpnHostRequest(_messages.Message):
  r"""A ComputeProjectsEnableXpnHostRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class ComputeProjectsEnableXpnResourceRequest(_messages.Message):
  r"""A ComputeProjectsEnableXpnResourceRequest object.

  Fields:
    project: Project ID for this request.
    projectsEnableXpnResourceRequest: A ProjectsEnableXpnResourceRequest
      resource to be passed as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  projectsEnableXpnResourceRequest = _messages.MessageField('ProjectsEnableXpnResourceRequest', 2)
  requestId = _messages.StringField(3)


class ComputeProjectsGetRequest(_messages.Message):
  r"""A ComputeProjectsGetRequest object.

  Fields:
    project: Project ID for this request.
  """

  project = _messages.StringField(1, required=True)


class ComputeProjectsGetXpnHostRequest(_messages.Message):
  r"""A ComputeProjectsGetXpnHostRequest object.

  Fields:
    project: Project ID for this request.
  """

  project = _messages.StringField(1, required=True)


class ComputeProjectsGetXpnResourcesRequest(_messages.Message):
  r"""A ComputeProjectsGetXpnResourcesRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputeProjectsListXpnHostsRequest(_messages.Message):
  r"""A ComputeProjectsListXpnHostsRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    projectsListXpnHostsRequest: A ProjectsListXpnHostsRequest resource to be
      passed as the request body.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  projectsListXpnHostsRequest = _messages.MessageField('ProjectsListXpnHostsRequest', 6)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeProjectsMoveDiskRequest(_messages.Message):
  r"""A ComputeProjectsMoveDiskRequest object.

  Fields:
    diskMoveRequest: A DiskMoveRequest resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  diskMoveRequest = _messages.MessageField('DiskMoveRequest', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeProjectsMoveInstanceRequest(_messages.Message):
  r"""A ComputeProjectsMoveInstanceRequest object.

  Fields:
    instanceMoveRequest: A InstanceMoveRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  instanceMoveRequest = _messages.MessageField('InstanceMoveRequest', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeProjectsSetCommonInstanceMetadataRequest(_messages.Message):
  r"""A ComputeProjectsSetCommonInstanceMetadataRequest object.

  Fields:
    metadata: A Metadata resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  metadata = _messages.MessageField('Metadata', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeProjectsSetDefaultNetworkTierRequest(_messages.Message):
  r"""A ComputeProjectsSetDefaultNetworkTierRequest object.

  Fields:
    project: Project ID for this request.
    projectsSetDefaultNetworkTierRequest: A
      ProjectsSetDefaultNetworkTierRequest resource to be passed as the
      request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  projectsSetDefaultNetworkTierRequest = _messages.MessageField('ProjectsSetDefaultNetworkTierRequest', 2)
  requestId = _messages.StringField(3)


class ComputeProjectsSetUsageExportBucketRequest(_messages.Message):
  r"""A ComputeProjectsSetUsageExportBucketRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    usageExportLocation: A UsageExportLocation resource to be passed as the
      request body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  usageExportLocation = _messages.MessageField('UsageExportLocation', 3)


class ComputePublicAdvertisedPrefixesDeleteRequest(_messages.Message):
  r"""A ComputePublicAdvertisedPrefixesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    publicAdvertisedPrefix: Name of the PublicAdvertisedPrefix resource to
      delete.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  publicAdvertisedPrefix = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputePublicAdvertisedPrefixesGetRequest(_messages.Message):
  r"""A ComputePublicAdvertisedPrefixesGetRequest object.

  Fields:
    project: Project ID for this request.
    publicAdvertisedPrefix: Name of the PublicAdvertisedPrefix resource to
      return.
  """

  project = _messages.StringField(1, required=True)
  publicAdvertisedPrefix = _messages.StringField(2, required=True)


class ComputePublicAdvertisedPrefixesInsertRequest(_messages.Message):
  r"""A ComputePublicAdvertisedPrefixesInsertRequest object.

  Fields:
    project: Project ID for this request.
    publicAdvertisedPrefix: A PublicAdvertisedPrefix resource to be passed as
      the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  publicAdvertisedPrefix = _messages.MessageField('PublicAdvertisedPrefix', 2)
  requestId = _messages.StringField(3)


class ComputePublicAdvertisedPrefixesListRequest(_messages.Message):
  r"""A ComputePublicAdvertisedPrefixesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  returnPartialSuccess = _messages.BooleanField(6)


class ComputePublicAdvertisedPrefixesPatchRequest(_messages.Message):
  r"""A ComputePublicAdvertisedPrefixesPatchRequest object.

  Fields:
    project: Project ID for this request.
    publicAdvertisedPrefix: Name of the PublicAdvertisedPrefix resource to
      patch.
    publicAdvertisedPrefixResource: A PublicAdvertisedPrefix resource to be
      passed as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  publicAdvertisedPrefix = _messages.StringField(2, required=True)
  publicAdvertisedPrefixResource = _messages.MessageField('PublicAdvertisedPrefix', 3)
  requestId = _messages.StringField(4)


class ComputePublicDelegatedPrefixesAggregatedListRequest(_messages.Message):
  r"""A ComputePublicDelegatedPrefixesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Name of the project scoping this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputePublicDelegatedPrefixesDeleteRequest(_messages.Message):
  r"""A ComputePublicDelegatedPrefixesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    publicDelegatedPrefix: Name of the PublicDelegatedPrefix resource to
      delete.
    region: Name of the region of this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  publicDelegatedPrefix = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputePublicDelegatedPrefixesGetRequest(_messages.Message):
  r"""A ComputePublicDelegatedPrefixesGetRequest object.

  Fields:
    project: Project ID for this request.
    publicDelegatedPrefix: Name of the PublicDelegatedPrefix resource to
      return.
    region: Name of the region of this request.
  """

  project = _messages.StringField(1, required=True)
  publicDelegatedPrefix = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputePublicDelegatedPrefixesInsertRequest(_messages.Message):
  r"""A ComputePublicDelegatedPrefixesInsertRequest object.

  Fields:
    project: Project ID for this request.
    publicDelegatedPrefix: A PublicDelegatedPrefix resource to be passed as
      the request body.
    region: Name of the region of this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  publicDelegatedPrefix = _messages.MessageField('PublicDelegatedPrefix', 2)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputePublicDelegatedPrefixesListRequest(_messages.Message):
  r"""A ComputePublicDelegatedPrefixesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region of this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputePublicDelegatedPrefixesPatchRequest(_messages.Message):
  r"""A ComputePublicDelegatedPrefixesPatchRequest object.

  Fields:
    project: Project ID for this request.
    publicDelegatedPrefix: Name of the PublicDelegatedPrefix resource to
      patch.
    publicDelegatedPrefixResource: A PublicDelegatedPrefix resource to be
      passed as the request body.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  publicDelegatedPrefix = _messages.StringField(2, required=True)
  publicDelegatedPrefixResource = _messages.MessageField('PublicDelegatedPrefix', 3)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeRegionAutoscalersDeleteRequest(_messages.Message):
  r"""A ComputeRegionAutoscalersDeleteRequest object.

  Fields:
    autoscaler: Name of the autoscaler to delete.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  autoscaler = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionAutoscalersGetRequest(_messages.Message):
  r"""A ComputeRegionAutoscalersGetRequest object.

  Fields:
    autoscaler: Name of the autoscaler to return.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  autoscaler = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionAutoscalersInsertRequest(_messages.Message):
  r"""A ComputeRegionAutoscalersInsertRequest object.

  Fields:
    autoscaler: A Autoscaler resource to be passed as the request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  autoscaler = _messages.MessageField('Autoscaler', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionAutoscalersListRequest(_messages.Message):
  r"""A ComputeRegionAutoscalersListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeRegionAutoscalersPatchRequest(_messages.Message):
  r"""A ComputeRegionAutoscalersPatchRequest object.

  Fields:
    autoscaler: Name of the autoscaler to patch.
    autoscalerResource: A Autoscaler resource to be passed as the request
      body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  autoscaler = _messages.StringField(1)
  autoscalerResource = _messages.MessageField('Autoscaler', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeRegionAutoscalersTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeRegionAutoscalersTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionAutoscalersUpdateRequest(_messages.Message):
  r"""A ComputeRegionAutoscalersUpdateRequest object.

  Fields:
    autoscaler: Name of the autoscaler to update.
    autoscalerResource: A Autoscaler resource to be passed as the request
      body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  autoscaler = _messages.StringField(1)
  autoscalerResource = _messages.MessageField('Autoscaler', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeRegionBackendServicesDeleteRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesDeleteRequest object.

  Fields:
    backendService: Name of the BackendService resource to delete.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionBackendServicesGetHealthRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesGetHealthRequest object.

  Fields:
    backendService: Name of the BackendService resource for which to get
      health.
    project: A string attribute.
    region: Name of the region scoping this request.
    resourceGroupReference: A ResourceGroupReference resource to be passed as
      the request body.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  resourceGroupReference = _messages.MessageField('ResourceGroupReference', 4)


class ComputeRegionBackendServicesGetIamPolicyRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesGetIamPolicyRequest object.

  Fields:
    optionsRequestedPolicyVersion: Requested IAM Policy version.
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name or id of the resource for this request.
  """

  optionsRequestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  resource = _messages.StringField(4, required=True)


class ComputeRegionBackendServicesGetRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesGetRequest object.

  Fields:
    backendService: Name of the BackendService resource to return.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionBackendServicesInsertRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesInsertRequest object.

  Fields:
    backendService: A BackendService resource to be passed as the request
      body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.MessageField('BackendService', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionBackendServicesListRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeRegionBackendServicesPatchRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesPatchRequest object.

  Fields:
    backendService: Name of the BackendService resource to patch.
    backendServiceResource: A BackendService resource to be passed as the
      request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.StringField(1, required=True)
  backendServiceResource = _messages.MessageField('BackendService', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeRegionBackendServicesSetIamPolicyRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesSetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    regionSetPolicyRequest: A RegionSetPolicyRequest resource to be passed as
      the request body.
    resource: Name or id of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionSetPolicyRequest = _messages.MessageField('RegionSetPolicyRequest', 3)
  resource = _messages.StringField(4, required=True)


class ComputeRegionBackendServicesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionBackendServicesUpdateRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesUpdateRequest object.

  Fields:
    backendService: Name of the BackendService resource to update.
    backendServiceResource: A BackendService resource to be passed as the
      request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.StringField(1, required=True)
  backendServiceResource = _messages.MessageField('BackendService', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeRegionCommitmentsAggregatedListRequest(_messages.Message):
  r"""A ComputeRegionCommitmentsAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    includeAllScopes: Indicates whether every visible scope for each scope
      type (zone, region, global) should be included in the response. For new
      resource types added after this field, the flag has no effect as new
      resource types will always include every visible scope for each scope
      type in response. For resource types which predate this field, if this
      flag is omitted or false, only scopes of the scope types where the
      resource type is expected to be found will be included.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  includeAllScopes = _messages.BooleanField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeRegionCommitmentsGetRequest(_messages.Message):
  r"""A ComputeRegionCommitmentsGetRequest object.

  Fields:
    commitment: Name of the commitment to return.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  commitment = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionCommitmentsInsertRequest(_messages.Message):
  r"""A ComputeRegionCommitmentsInsertRequest object.

  Fields:
    commitment: A Commitment resource to be passed as the request body.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  commitment = _messages.MessageField('Commitment', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionCommitmentsListRequest(_messages.Message):
  r"""A ComputeRegionCommitmentsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeRegionCommitmentsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeRegionCommitmentsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionCommitmentsUpdateRequest(_messages.Message):
  r"""A ComputeRegionCommitmentsUpdateRequest object.

  Fields:
    commitment: Name of the commitment for which auto renew is being updated.
    commitmentResource: A Commitment resource to be passed as the request
      body.
    paths: A string attribute.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    updateMask: update_mask indicates fields to be updated as part of this
      request.
  """

  commitment = _messages.StringField(1, required=True)
  commitmentResource = _messages.MessageField('Commitment', 2)
  paths = _messages.StringField(3, repeated=True)
  project = _messages.StringField(4, required=True)
  region = _messages.StringField(5, required=True)
  requestId = _messages.StringField(6)
  updateMask = _messages.StringField(7)


class ComputeRegionCommitmentsUpdateReservationsRequest(_messages.Message):
  r"""A ComputeRegionCommitmentsUpdateReservationsRequest object.

  Fields:
    commitment: Name of the commitment for which the reservation is being
      updated.
    project: Project ID for this request.
    region: Name of the region for this request.
    regionCommitmentsUpdateReservationsRequest: A
      RegionCommitmentsUpdateReservationsRequest resource to be passed as the
      request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  commitment = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionCommitmentsUpdateReservationsRequest = _messages.MessageField('RegionCommitmentsUpdateReservationsRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionDiskTypesGetRequest(_messages.Message):
  r"""A ComputeRegionDiskTypesGetRequest object.

  Fields:
    diskType: Name of the disk type to return.
    project: Project ID for this request.
    region: The name of the region for this request.
  """

  diskType = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionDiskTypesListRequest(_messages.Message):
  r"""A ComputeRegionDiskTypesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: The name of the region for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeRegionDisksAddResourcePoliciesRequest(_messages.Message):
  r"""A ComputeRegionDisksAddResourcePoliciesRequest object.

  Fields:
    disk: The disk name for this request.
    project: Project ID for this request.
    region: The name of the region for this request.
    regionDisksAddResourcePoliciesRequest: A
      RegionDisksAddResourcePoliciesRequest resource to be passed as the
      request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionDisksAddResourcePoliciesRequest = _messages.MessageField('RegionDisksAddResourcePoliciesRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionDisksCreateSnapshotRequest(_messages.Message):
  r"""A ComputeRegionDisksCreateSnapshotRequest object.

  Fields:
    disk: Name of the regional persistent disk to snapshot.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    snapshot: A Snapshot resource to be passed as the request body.
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  snapshot = _messages.MessageField('Snapshot', 5)


class ComputeRegionDisksDeleteRequest(_messages.Message):
  r"""A ComputeRegionDisksDeleteRequest object.

  Fields:
    disk: Name of the regional persistent disk to delete.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionDisksGetIamPolicyRequest(_messages.Message):
  r"""A ComputeRegionDisksGetIamPolicyRequest object.

  Fields:
    optionsRequestedPolicyVersion: Requested IAM Policy version.
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name or id of the resource for this request.
  """

  optionsRequestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  resource = _messages.StringField(4, required=True)


class ComputeRegionDisksGetRequest(_messages.Message):
  r"""A ComputeRegionDisksGetRequest object.

  Fields:
    disk: Name of the regional persistent disk to return.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionDisksInsertRequest(_messages.Message):
  r"""A ComputeRegionDisksInsertRequest object.

  Fields:
    disk: A Disk resource to be passed as the request body.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    sourceImage: Source image to restore onto a disk. This field is optional.
  """

  disk = _messages.MessageField('Disk', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  sourceImage = _messages.StringField(5)


class ComputeRegionDisksListRequest(_messages.Message):
  r"""A ComputeRegionDisksListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeRegionDisksRemoveResourcePoliciesRequest(_messages.Message):
  r"""A ComputeRegionDisksRemoveResourcePoliciesRequest object.

  Fields:
    disk: The disk name for this request.
    project: Project ID for this request.
    region: The name of the region for this request.
    regionDisksRemoveResourcePoliciesRequest: A
      RegionDisksRemoveResourcePoliciesRequest resource to be passed as the
      request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionDisksRemoveResourcePoliciesRequest = _messages.MessageField('RegionDisksRemoveResourcePoliciesRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionDisksResizeRequest(_messages.Message):
  r"""A ComputeRegionDisksResizeRequest object.

  Fields:
    disk: Name of the regional persistent disk.
    project: The project ID for this request.
    region: Name of the region for this request.
    regionDisksResizeRequest: A RegionDisksResizeRequest resource to be passed
      as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionDisksResizeRequest = _messages.MessageField('RegionDisksResizeRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionDisksSetIamPolicyRequest(_messages.Message):
  r"""A ComputeRegionDisksSetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    regionSetPolicyRequest: A RegionSetPolicyRequest resource to be passed as
      the request body.
    resource: Name or id of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionSetPolicyRequest = _messages.MessageField('RegionSetPolicyRequest', 3)
  resource = _messages.StringField(4, required=True)


class ComputeRegionDisksSetLabelsRequest(_messages.Message):
  r"""A ComputeRegionDisksSetLabelsRequest object.

  Fields:
    project: Project ID for this request.
    region: The region for this request.
    regionSetLabelsRequest: A RegionSetLabelsRequest resource to be passed as
      the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    resource: Name or id of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionSetLabelsRequest = _messages.MessageField('RegionSetLabelsRequest', 3)
  requestId = _messages.StringField(4)
  resource = _messages.StringField(5, required=True)


class ComputeRegionDisksTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeRegionDisksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionDisksUpdateRequest(_messages.Message):
  r"""A ComputeRegionDisksUpdateRequest object.

  Fields:
    disk: The disk name for this request.
    diskResource: A Disk resource to be passed as the request body.
    paths: A string attribute.
    project: Project ID for this request.
    region: The name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    updateMask: update_mask indicates fields to be updated as part of this
      request.
  """

  disk = _messages.StringField(1, required=True)
  diskResource = _messages.MessageField('Disk', 2)
  paths = _messages.StringField(3, repeated=True)
  project = _messages.StringField(4, required=True)
  region = _messages.StringField(5, required=True)
  requestId = _messages.StringField(6)
  updateMask = _messages.StringField(7)


class ComputeRegionHealthCheckServicesDeleteRequest(_messages.Message):
  r"""A ComputeRegionHealthCheckServicesDeleteRequest object.

  Fields:
    healthCheckService: Name of the HealthCheckService to delete. The name
      must be 1-63 characters long, and comply with RFC1035.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  healthCheckService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionHealthCheckServicesGetRequest(_messages.Message):
  r"""A ComputeRegionHealthCheckServicesGetRequest object.

  Fields:
    healthCheckService: Name of the HealthCheckService to update. The name
      must be 1-63 characters long, and comply with RFC1035.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  healthCheckService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionHealthCheckServicesInsertRequest(_messages.Message):
  r"""A ComputeRegionHealthCheckServicesInsertRequest object.

  Fields:
    healthCheckService: A HealthCheckService resource to be passed as the
      request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  healthCheckService = _messages.MessageField('HealthCheckService', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionHealthCheckServicesListRequest(_messages.Message):
  r"""A ComputeRegionHealthCheckServicesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeRegionHealthCheckServicesPatchRequest(_messages.Message):
  r"""A ComputeRegionHealthCheckServicesPatchRequest object.

  Fields:
    healthCheckService: Name of the HealthCheckService to update. The name
      must be 1-63 characters long, and comply with RFC1035.
    healthCheckServiceResource: A HealthCheckService resource to be passed as
      the request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  healthCheckService = _messages.StringField(1, required=True)
  healthCheckServiceResource = _messages.MessageField('HealthCheckService', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeRegionHealthCheckServicesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeRegionHealthCheckServicesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionHealthChecksDeleteRequest(_messages.Message):
  r"""A ComputeRegionHealthChecksDeleteRequest object.

  Fields:
    healthCheck: Name of the HealthCheck resource to delete.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  healthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionHealthChecksGetRequest(_messages.Message):
  r"""A ComputeRegionHealthChecksGetRequest object.

  Fields:
    healthCheck: Name of the HealthCheck resource to return.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  healthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionHealthChecksInsertRequest(_messages.Message):
  r"""A ComputeRegionHealthChecksInsertRequest object.

  Fields:
    healthCheck: A HealthCheck resource to be passed as the request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  healthCheck = _messages.MessageField('HealthCheck', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionHealthChecksListRequest(_messages.Message):
  r"""A ComputeRegionHealthChecksListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeRegionHealthChecksPatchRequest(_messages.Message):
  r"""A ComputeRegionHealthChecksPatchRequest object.

  Fields:
    healthCheck: Name of the HealthCheck resource to patch.
    healthCheckResource: A HealthCheck resource to be passed as the request
      body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  healthCheck = _messages.StringField(1, required=True)
  healthCheckResource = _messages.MessageField('HealthCheck', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeRegionHealthChecksTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeRegionHealthChecksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionHealthChecksUpdateRequest(_messages.Message):
  r"""A ComputeRegionHealthChecksUpdateRequest object.

  Fields:
    healthCheck: Name of the HealthCheck resource to update.
    healthCheckResource: A HealthCheck resource to be passed as the request
      body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  healthCheck = _messages.StringField(1, required=True)
  healthCheckResource = _messages.MessageField('HealthCheck', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersAbandonInstancesRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersAbandonInstancesRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersAbandonInstancesRequest: A
      RegionInstanceGroupManagersAbandonInstancesRequest resource to be passed
      as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersAbandonInstancesRequest = _messages.MessageField('RegionInstanceGroupManagersAbandonInstancesRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersApplyUpdatesToInstancesRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersApplyUpdatesToInstancesRequest
  object.

  Fields:
    instanceGroupManager: The name of the managed instance group, should
      conform to RFC1035.
    project: Project ID for this request.
    region: Name of the region scoping this request, should conform to
      RFC1035.
    regionInstanceGroupManagersApplyUpdatesRequest: A
      RegionInstanceGroupManagersApplyUpdatesRequest resource to be passed as
      the request body.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersApplyUpdatesRequest = _messages.MessageField('RegionInstanceGroupManagersApplyUpdatesRequest', 4)


class ComputeRegionInstanceGroupManagersCreateInstancesRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersCreateInstancesRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group. It should
      conform to RFC1035.
    project: Project ID for this request.
    region: The name of the region where the managed instance group is
      located. It should conform to RFC1035.
    regionInstanceGroupManagersCreateInstancesRequest: A
      RegionInstanceGroupManagersCreateInstancesRequest resource to be passed
      as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. The request ID must
      be a valid UUID with the exception that zero UUID is not supported (
      00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersCreateInstancesRequest = _messages.MessageField('RegionInstanceGroupManagersCreateInstancesRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersDeleteInstancesRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersDeleteInstancesRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersDeleteInstancesRequest: A
      RegionInstanceGroupManagersDeleteInstancesRequest resource to be passed
      as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersDeleteInstancesRequest = _messages.MessageField('RegionInstanceGroupManagersDeleteInstancesRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersDeletePerInstanceConfigsRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersDeletePerInstanceConfigsRequest
  object.

  Fields:
    instanceGroupManager: The name of the managed instance group. It should
      conform to RFC1035.
    project: Project ID for this request.
    region: Name of the region scoping this request, should conform to
      RFC1035.
    regionInstanceGroupManagerDeleteInstanceConfigReq: A
      RegionInstanceGroupManagerDeleteInstanceConfigReq resource to be passed
      as the request body.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagerDeleteInstanceConfigReq = _messages.MessageField('RegionInstanceGroupManagerDeleteInstanceConfigReq', 4)


class ComputeRegionInstanceGroupManagersDeleteRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersDeleteRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group to delete.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionInstanceGroupManagersGetRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersGetRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group to return.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionInstanceGroupManagersInsertRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersInsertRequest object.

  Fields:
    instanceGroupManager: A InstanceGroupManager resource to be passed as the
      request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.MessageField('InstanceGroupManager', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionInstanceGroupManagersListErrorsRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersListErrorsRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    instanceGroupManager: The name of the managed instance group. It must be a
      string that meets the requirements in RFC1035, or an unsigned long
      integer: must match regexp pattern:
      (?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?)|1-9{0,19}.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request. This should conform to
      RFC1035.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  instanceGroupManager = _messages.StringField(2, required=True)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  region = _messages.StringField(7, required=True)
  returnPartialSuccess = _messages.BooleanField(8)


class ComputeRegionInstanceGroupManagersListManagedInstancesRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersListManagedInstancesRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    instanceGroupManager: The name of the managed instance group.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  instanceGroupManager = _messages.StringField(2, required=True)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  region = _messages.StringField(7, required=True)
  returnPartialSuccess = _messages.BooleanField(8)


class ComputeRegionInstanceGroupManagersListPerInstanceConfigsRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersListPerInstanceConfigsRequest
  object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    instanceGroupManager: The name of the managed instance group. It should
      conform to RFC1035.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request, should conform to
      RFC1035.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  instanceGroupManager = _messages.StringField(2, required=True)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  region = _messages.StringField(7, required=True)
  returnPartialSuccess = _messages.BooleanField(8)


class ComputeRegionInstanceGroupManagersListRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeRegionInstanceGroupManagersPatchPerInstanceConfigsRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersPatchPerInstanceConfigsRequest
  object.

  Fields:
    instanceGroupManager: The name of the managed instance group. It should
      conform to RFC1035.
    project: Project ID for this request.
    region: Name of the region scoping this request, should conform to
      RFC1035.
    regionInstanceGroupManagerPatchInstanceConfigReq: A
      RegionInstanceGroupManagerPatchInstanceConfigReq resource to be passed
      as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagerPatchInstanceConfigReq = _messages.MessageField('RegionInstanceGroupManagerPatchInstanceConfigReq', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersPatchRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersPatchRequest object.

  Fields:
    instanceGroupManager: The name of the instance group manager.
    instanceGroupManagerResource: A InstanceGroupManager resource to be passed
      as the request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagerResource = _messages.MessageField('InstanceGroupManager', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersRecreateInstancesRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersRecreateInstancesRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersRecreateRequest: A
      RegionInstanceGroupManagersRecreateRequest resource to be passed as the
      request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersRecreateRequest = _messages.MessageField('RegionInstanceGroupManagersRecreateRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersResizeAdvancedRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersResizeAdvancedRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group. It must be a
      string that meets the requirements in RFC1035.
    project: Project ID for this request.
    region: Name of the region scoping this request. It must be a string that
      meets the requirements in RFC1035.
    regionInstanceGroupManagersResizeAdvancedRequest: A
      RegionInstanceGroupManagersResizeAdvancedRequest resource to be passed
      as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersResizeAdvancedRequest = _messages.MessageField('RegionInstanceGroupManagersResizeAdvancedRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersResizeRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersResizeRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
    size: Number of instances that should exist in this instance group
      manager.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  size = _messages.IntegerField(5, required=True, variant=_messages.Variant.INT32)


class ComputeRegionInstanceGroupManagersSetAutoHealingPoliciesRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersSetAutoHealingPoliciesRequest
  object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersSetAutoHealingRequest: A
      RegionInstanceGroupManagersSetAutoHealingRequest resource to be passed
      as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersSetAutoHealingRequest = _messages.MessageField('RegionInstanceGroupManagersSetAutoHealingRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersSetInstanceTemplateRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersSetInstanceTemplateRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersSetTemplateRequest: A
      RegionInstanceGroupManagersSetTemplateRequest resource to be passed as
      the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersSetTemplateRequest = _messages.MessageField('RegionInstanceGroupManagersSetTemplateRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersSetTargetPoolsRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersSetTargetPoolsRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersSetTargetPoolsRequest: A
      RegionInstanceGroupManagersSetTargetPoolsRequest resource to be passed
      as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersSetTargetPoolsRequest = _messages.MessageField('RegionInstanceGroupManagersSetTargetPoolsRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionInstanceGroupManagersUpdatePerInstanceConfigsRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersUpdatePerInstanceConfigsRequest
  object.

  Fields:
    instanceGroupManager: The name of the managed instance group. It should
      conform to RFC1035.
    project: Project ID for this request.
    region: Name of the region scoping this request, should conform to
      RFC1035.
    regionInstanceGroupManagerUpdateInstanceConfigReq: A
      RegionInstanceGroupManagerUpdateInstanceConfigReq resource to be passed
      as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagerUpdateInstanceConfigReq = _messages.MessageField('RegionInstanceGroupManagerUpdateInstanceConfigReq', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersUpdateRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersUpdateRequest object.

  Fields:
    instanceGroupManager: The name of the instance group manager.
    instanceGroupManagerResource: A InstanceGroupManager resource to be passed
      as the request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagerResource = _messages.MessageField('InstanceGroupManager', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupsGetRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupsGetRequest object.

  Fields:
    instanceGroup: Name of the instance group resource to return.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  instanceGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionInstanceGroupsListInstancesRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupsListInstancesRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    instanceGroup: Name of the regional instance group for which we want to
      list the instances.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupsListInstancesRequest: A
      RegionInstanceGroupsListInstancesRequest resource to be passed as the
      request body.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  instanceGroup = _messages.StringField(2, required=True)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  region = _messages.StringField(7, required=True)
  regionInstanceGroupsListInstancesRequest = _messages.MessageField('RegionInstanceGroupsListInstancesRequest', 8)
  returnPartialSuccess = _messages.BooleanField(9)


class ComputeRegionInstanceGroupsListRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeRegionInstanceGroupsSetNamedPortsRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupsSetNamedPortsRequest object.

  Fields:
    instanceGroup: The name of the regional instance group where the named
      ports are updated.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupsSetNamedPortsRequest: A
      RegionInstanceGroupsSetNamedPortsRequest resource to be passed as the
      request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  instanceGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupsSetNamedPortsRequest = _messages.MessageField('RegionInstanceGroupsSetNamedPortsRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name or id of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionInstancesBulkInsertRequest(_messages.Message):
  r"""A ComputeRegionInstancesBulkInsertRequest object.

  Fields:
    bulkInsertInstanceResource: A BulkInsertInstanceResource resource to be
      passed as the request body.
    project: Project ID for this request.
    region: The name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  bulkInsertInstanceResource = _messages.MessageField('BulkInsertInstanceResource', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionNetworkEndpointGroupsDeleteRequest(_messages.Message):
  r"""A ComputeRegionNetworkEndpointGroupsDeleteRequest object.

  Fields:
    networkEndpointGroup: The name of the network endpoint group to delete. It
      should comply with RFC1035.
    project: Project ID for this request.
    region: The name of the region where the network endpoint group is
      located. It should comply with RFC1035.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  networkEndpointGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionNetworkEndpointGroupsGetRequest(_messages.Message):
  r"""A ComputeRegionNetworkEndpointGroupsGetRequest object.

  Fields:
    networkEndpointGroup: The name of the network endpoint group. It should
      comply with RFC1035.
    project: Project ID for this request.
    region: The name of the region where the network endpoint group is
      located. It should comply with RFC1035.
  """

  networkEndpointGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionNetworkEndpointGroupsInsertRequest(_messages.Message):
  r"""A ComputeRegionNetworkEndpointGroupsInsertRequest object.

  Fields:
    networkEndpointGroup: A NetworkEndpointGroup resource to be passed as the
      request body.
    project: Project ID for this request.
    region: The name of the region where you want to create the network
      endpoint group. It should comply with RFC1035.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  networkEndpointGroup = _messages.MessageField('NetworkEndpointGroup', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionNetworkEndpointGroupsListRequest(_messages.Message):
  r"""A ComputeRegionNetworkEndpointGroupsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, an operator, and the value
      that you want to use for filtering. The value must be a string, a
      number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`,
      `<=`, `>=` or `:`. For example, if you are filtering Compute Engine
      instances, you can exclude instances named `example-instance` by
      specifying `name != example-instance`. The `:` operator can be used with
      string fields to match substrings. For non-string fields it is
      equivalent to the `=` operator. The `:*` comparison can be used to test
      whether a key has been defined. For example, to find all objects with
      `owner` label use: ``` labels.owner:* ``` You can also filter nested
      fields. For example, you could specify `scheduling.automaticRestart =
      false` to include instances only if they are not scheduled for automatic
      restarts. You can use filtering on nested fields to filter based on
      resource labels. To filter on multiple expressions, provide each
      separate expression within parentheses. For example: ```
      (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake") ```
      By default, each expression is an `AND` expression. However, you can
      include `AND` and `OR` expressions explicitly. For example: ```
      (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND
      (scheduling.automaticRestart = true) ```
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than
      `maxResults`, Compute Engine returns a `nextPageToken` that can be used
      to get the next page of results in subsequent list requests. Acceptable
      values are `0` to `500`, inclusive. (Default: `500`)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name. You can
      also sort results in descending order based on the creation timestamp
      using `orderBy="creationTimestamp desc"`. This sorts results based on
      the `creationTimestamp` field in reverse chronological order (newest
      result first). Use this to sort resources like operations so that the
      newest operation is returned first. Currently, only sorting by `name` or
      `creationTimestamp desc` is supported.
    pageToken: Specifies a page token to use. Set `pageToken` to the
      `nextPageToken` returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: The name of the region where the network endpoint group is
      located. It should comply with RFC1035.
    returnPartialSuccess: Opt-in for partial success behavior which provides
      partial results in case of failure. The default value is false.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)
  returnPartialSuccess = _messages.BooleanField(7)


class ComputeRegionNotificationEndpointsDeleteRequest(_messages.Message):
  r"""A ComputeRegionNotificationEndpointsDeleteRequest object.

  Fields:
    notificationEndpoint: Name of the NotificationEndpoint resource to delete.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  notificationEndpoint = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionNotificationEndpointsGetRequest(_messages.Message):
  r"""A ComputeRegionNotificationEndpointsGetRequest object.

  Fields:
    notificationEndpoint: Name of the NotificationEndpoint resource to return.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  notificationEndpoint = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionNotificationEndpointsInsertRequest(_messages.Message):
  r"""A ComputeRegionNotificationEndpointsInsertRequest object.

  Fields:
    notificationEndpoint: A NotificationEndpoint resource to be passed as the
      request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      ( 00000000-0000-0000-0000-000000000000).
  """

  notificationEndpoint = _messages.MessageField('NotificationEndpoint', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionNotificationEndpointsListRequest(_messages.Message):
  r"""A ComputeRegionNotificationEndpointsListRequest object.

  Fields:
    filter: A filter e