"""Generated message classes for beyondcorp version v1alpha.

Beyondcorp Enterprise provides identity and context aware access controls for
enterprise resources and enables zero-trust access. Using the Beyondcorp
Enterprise APIs, enterprises can set up multi-cloud and on-prem connectivity
using the App Connector hybrid connectivity solution.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'beyondcorp'


class ApplicationEndpoint(_messages.Message):
  r"""ApplicationEndpoint represents a remote application endpoint.

  Fields:
    host: Required. Hostname or IP address of the remote application endpoint.
    port: Required. Port of the remote application endpoint.
  """

  host = _messages.StringField(1)
  port = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class BeyondcorpProjectsLocationsConnectionsCreateRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectionsCreateRequest object.

  Fields:
    connection: A Connection resource to be passed as the request body.
    connectionId: Optional. User-settable connection resource ID. * Must start
      with a letter. * Must contain between 4-63 characters from (/a-z-/). *
      Must end with a number or a letter.
    parent: Required. The resource project name of the connection location
      using the form: `projects/{project_id}/locations/{location_id}`
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. If set, validates request by executing a dry-run
      which would not alter the resource in any way.
  """

  connection = _messages.MessageField('Connection', 1)
  connectionId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class BeyondcorpProjectsLocationsConnectionsDeleteRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectionsDeleteRequest object.

  Fields:
    name: Required. BeyondCorp Connector name using the form: `projects/{proje
      ct_id}/locations/{location_id}/connections/{connection_id}`
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. If set, validates request by executing a dry-run
      which would not alter the resource in any way.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  validateOnly = _messages.BooleanField(3)


class BeyondcorpProjectsLocationsConnectionsGetIamPolicyRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectionsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class BeyondcorpProjectsLocationsConnectionsGetRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectionsGetRequest object.

  Fields:
    name: Required. BeyondCorp Connection name using the form: `projects/{proj
      ect_id}/locations/{location_id}/connections/{connection_id}`
  """

  name = _messages.StringField(1, required=True)


class BeyondcorpProjectsLocationsConnectionsListRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectionsListRequest object.

  Fields:
    filter: Optional. A filter specifying constraints of a list operation.
    orderBy: Optional. Specifies the ordering of results. See [Sorting
      order](https://cloud.google.com/apis/design/design_patterns#sorting_orde
      r) for more information.
    pageSize: Optional. The maximum number of items to return. If not
      specified, a default value of 50 will be used by the service. Regardless
      of the page_size value, the response may include a partial list and a
      caller should only rely on response's next_page_token to determine if
      there are more instances left to be queried.
    pageToken: Optional. The next_page_token value returned from a previous
      ListConnectionsRequest, if any.
    parent: Required. The resource name of the connection location using the
      form: `projects/{project_id}/locations/{location_id}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class BeyondcorpProjectsLocationsConnectionsPatchRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectionsPatchRequest object.

  Fields:
    allowMissing: Optional. If set as true, will create the resource if it is
      not found.
    connection: A Connection resource to be passed as the request body.
    name: Required. Unique resource name of the connection. The name is
      ignored when creating a connection.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Mask of fields to update. At least one path must be
      supplied in this field. The elements of the repeated paths field may
      only include these fields from [BeyondCorp.Connection]: * `labels` *
      `display_name` * `application_endpoint` * `connectors`
    validateOnly: Optional. If set, validates request by executing a dry-run
      which would not alter the resource in any way.
  """

  allowMissing = _messages.BooleanField(1)
  connection = _messages.MessageField('Connection', 2)
  name = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  updateMask = _messages.StringField(5)
  validateOnly = _messages.BooleanField(6)


class BeyondcorpProjectsLocationsConnectionsResolveRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectionsResolveRequest object.

  Fields:
    connectorId: Required. BeyondCorp Connector name of the connector
      associated with those connections using the form: `projects/{project_id}
      /locations/{location_id}/connectors/{connector_id}`
    pageSize: Optional. The maximum number of items to return. If not
      specified, a default value of 50 will be used by the service. Regardless
      of the page_size value, the response may include a partial list and a
      caller should only rely on response's next_page_token to determine if
      there are more instances left to be queried.
    pageToken: Optional. The next_page_token value returned from a previous
      ResolveConnectionsResponse, if any.
    parent: Required. The resource name of the connection location using the
      form: `projects/{project_id}/locations/{location_id}`
  """

  connectorId = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class BeyondcorpProjectsLocationsConnectionsSetIamPolicyRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectionsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class BeyondcorpProjectsLocationsConnectionsTestIamPermissionsRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectionsTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class BeyondcorpProjectsLocationsConnectorsCreateRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectorsCreateRequest object.

  Fields:
    connector: A Connector resource to be passed as the request body.
    connectorId: Optional. User-settable connector resource ID. * Must start
      with a letter. * Must contain between 4-63 characters from (/a-z-/). *
      Must end with a number or a letter.
    parent: Required. The resource project name of the connector location
      using the form: `projects/{project_id}/locations/{location_id}`
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. If set, validates request by executing a dry-run
      which would not alter the resource in any way.
  """

  connector = _messages.MessageField('Connector', 1)
  connectorId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class BeyondcorpProjectsLocationsConnectorsDeleteRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectorsDeleteRequest object.

  Fields:
    name: Required. BeyondCorp Connector name using the form:
      `projects/{project_id}/locations/{location_id}/connectors/{connector_id}
      `
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. If set, validates request by executing a dry-run
      which would not alter the resource in any way.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  validateOnly = _messages.BooleanField(3)


class BeyondcorpProjectsLocationsConnectorsGetIamPolicyRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectorsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class BeyondcorpProjectsLocationsConnectorsGetRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectorsGetRequest object.

  Fields:
    name: Required. BeyondCorp Connector name using the form:
      `projects/{project_id}/locations/{location_id}/connectors/{connector_id}
      `
  """

  name = _messages.StringField(1, required=True)


class BeyondcorpProjectsLocationsConnectorsListRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectorsListRequest object.

  Fields:
    filter: Optional. A filter specifying constraints of a list operation.
    orderBy: Optional. Specifies the ordering of results. See [Sorting
      order](https://cloud.google.com/apis/design/design_patterns#sorting_orde
      r) for more information.
    pageSize: Optional. The maximum number of items to return. If not
      specified, a default value of 50 will be used by the service. Regardless
      of the page_size value, the response may include a partial list and a
      caller should only rely on response's next_page_token to determine if
      there are more instances left to be queried.
    pageToken: Optional. The next_page_token value returned from a previous
      ListConnectorsRequest, if any.
    parent: Required. The resource name of the connector location using the
      form: `projects/{project_id}/locations/{location_id}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class BeyondcorpProjectsLocationsConnectorsPatchRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectorsPatchRequest object.

  Fields:
    connector: A Connector resource to be passed as the request body.
    name: Required. Unique resource name of the connector. The name is ignored
      when creating a connector.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Mask of fields to update. At least one path must be
      supplied in this field. The elements of the repeated paths field may
      only include these fields from [BeyondCorp.Connector]: * `labels` *
      `display_name`
    validateOnly: Optional. If set, validates request by executing a dry-run
      which would not alter the resource in any way.
  """

  connector = _messages.MessageField('Connector', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class BeyondcorpProjectsLocationsConnectorsReportStatusRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectorsReportStatusRequest object.

  Fields:
    connector: Required. BeyondCorp Connector name using the form:
      `projects/{project_id}/locations/{location_id}/connectors/{connector}`
    reportStatusRequest: A ReportStatusRequest resource to be passed as the
      request body.
  """

  connector = _messages.StringField(1, required=True)
  reportStatusRequest = _messages.MessageField('ReportStatusRequest', 2)


class BeyondcorpProjectsLocationsConnectorsResolveInstanceConfigRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectorsResolveInstanceConfigRequest
  object.

  Fields:
    connector: Required. BeyondCorp Connector name using the form:
      `projects/{project_id}/locations/{location_id}/connectors/{connector}`
  """

  connector = _messages.StringField(1, required=True)


class BeyondcorpProjectsLocationsConnectorsSetIamPolicyRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectorsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class BeyondcorpProjectsLocationsConnectorsTestIamPermissionsRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsConnectorsTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class BeyondcorpProjectsLocationsGetRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class BeyondcorpProjectsLocationsListRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like "displayName=tokyo", and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class BeyondcorpProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsOperationsCancelRequest object.

  Fields:
    googleLongrunningCancelOperationRequest: A
      GoogleLongrunningCancelOperationRequest resource to be passed as the
      request body.
    name: The name of the operation resource to be cancelled.
  """

  googleLongrunningCancelOperationRequest = _messages.MessageField('GoogleLongrunningCancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class BeyondcorpProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class BeyondcorpProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class BeyondcorpProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A BeyondcorpProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class CloudPubSubNotificationConfig(_messages.Message):
  r"""The configuration for Pub/Sub messaging for the connector.

  Fields:
    pubsubSubscription: The Pub/Sub subscription the connector uses to receive
      notifications.
  """

  pubsubSubscription = _messages.StringField(1)


class Connection(_messages.Message):
  r"""A Beyondcorp Connection resource represents a BeyondCorp protected
  connection to a remote application. It creates all the necessary GCP
  components needed for creating a BeyondCorp protected connection. Multiple
  connectors can be authorised for a single Connection.

  Enums:
    StateValueValuesEnum: Output only. The current state of the connection.
    TypeValueValuesEnum: Required. The type of network connnectivity used by
      the connection.

  Messages:
    LabelsValue: Optional. Resource labels to represent user provided
      metadata.

  Fields:
    applicationEndpoint: Required. Address of the remote application endpoint
      for the Beyondcorp Connection.
    connectors: Optional. List of
      [google.cloud.beyondcorp.v1main.Connector.name] that are authorised to
      be associated with this Connection.
    createTime: Output only. Timestamp when the resource was created.
    displayName: Optional. An arbitrary user-provided name for the connection.
      Cannot exceed 64 characters.
    gateway: Optional. Gateway used by the connection.
    labels: Optional. Resource labels to represent user provided metadata.
    name: Required. Unique resource name of the connection. The name is
      ignored when creating a connection.
    state: Output only. The current state of the connection.
    type: Required. The type of network connnectivity used by the connection.
    uid: Output only. A unique identifier for the instance generated by the
      system.
    updateTime: Output only. Timestamp when the resource was last modified.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the connection.

    Values:
      STATE_UNSPECIFIED: Default value. This value is unused.
      CREATING: Connection is being created.
      CREATED: Connection has been created.
      UPDATING: Connection's configuration is being updated.
      DELETING: Connection is being deleted.
      DOWN: Connection is down and may be restored in the future. This happens
        when CCFE sends ProjectState = OFF.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    CREATED = 2
    UPDATING = 3
    DELETING = 4
    DOWN = 5

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of network connnectivity used by the connection.

    Values:
      TYPE_UNSPECIFIED: Default value. This value is unused.
      TCP_PROXY: TCP Proxy based Beyondcorp Connection. API will default to
        this if unset.
    """
    TYPE_UNSPECIFIED = 0
    TCP_PROXY = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Resource labels to represent user provided metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  applicationEndpoint = _messages.MessageField('ApplicationEndpoint', 1)
  connectors = _messages.StringField(2, repeated=True)
  createTime = _messages.StringField(3)
  displayName = _messages.StringField(4)
  gateway = _messages.MessageField('Gateway', 5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  state = _messages.EnumField('StateValueValuesEnum', 8)
  type = _messages.EnumField('TypeValueValuesEnum', 9)
  uid = _messages.StringField(10)
  updateTime = _messages.StringField(11)


class ConnectionDetails(_messages.Message):
  r"""Details of the Connection.

  Fields:
    connection: A BeyondCorp Connection in the project.
    recentMigVms: If type=GCP_REGIONAL_MIG, contains most recent VM instances,
      like "https://www.googleapis.com/compute/v1/projects/{project_id}/zones/
      {zone_id}/instances/{instance_id}".
  """

  connection = _messages.MessageField('Connection', 1)
  recentMigVms = _messages.StringField(2, repeated=True)


class ConnectionOperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Connector(_messages.Message):
  r"""A Beyondcorp connector resource that represents an application facing
  component deployed proximal to and with direct access to the application
  instances. It is used to establish connectivity between the remote
  enterprise environment and GCP. It initiates connections to the applications
  and can proxy the data from users over the connection.

  Enums:
    StateValueValuesEnum: Output only. The current state of the connector.

  Messages:
    LabelsValue: Optional. Resource labels to represent user provided
      metadata.

  Fields:
    createTime: Output only. Timestamp when the resource was created.
    displayName: Optional. An arbitrary user-provided name for the connector.
      Cannot exceed 64 characters.
    labels: Optional. Resource labels to represent user provided metadata.
    name: Required. Unique resource name of the connector. The name is ignored
      when creating a connector.
    principalInfo: Required. Principal information about the Identity of the
      connector.
    resourceInfo: Optional. Resource info of the connector.
    state: Output only. The current state of the connector.
    uid: Output only. A unique identifier for the instance generated by the
      system.
    updateTime: Output only. Timestamp when the resource was last modified.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the connector.

    Values:
      STATE_UNSPECIFIED: Default value. This value is unused.
      CREATING: Connector is being created.
      CREATED: Connector has been created.
      UPDATING: Connector's configuration is being updated.
      DELETING: Connector is being deleted.
      DOWN: Connector is down and may be restored in the future. This happens
        when CCFE sends ProjectState = OFF.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    CREATED = 2
    UPDATING = 3
    DELETING = 4
    DOWN = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Resource labels to represent user provided metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  principalInfo = _messages.MessageField('PrincipalInfo', 5)
  resourceInfo = _messages.MessageField('ResourceInfo', 6)
  state = _messages.EnumField('StateValueValuesEnum', 7)
  uid = _messages.StringField(8)
  updateTime = _messages.StringField(9)


class ConnectorInstanceConfig(_messages.Message):
  r"""ConnectorInstanceConfig defines the instance config of a connector.

  Messages:
    InstanceConfigValue: The SLM instance agent configuration.

  Fields:
    imageConfig: ImageConfig defines the GCR images to run for the remote
      agent's control plane.
    instanceConfig: The SLM instance agent configuration.
    notificationConfig: NotificationConfig defines the notification mechanism
      that the remote instance should subscribe to in order to receive
      notification.
    sequenceNumber: Required. A monotonically increasing number generated and
      maintained by the API provider. Every time a config changes in the
      backend, the sequenceNumber should be bumped up to reflect the change.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InstanceConfigValue(_messages.Message):
    r"""The SLM instance agent configuration.

    Messages:
      AdditionalProperty: An additional property for a InstanceConfigValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InstanceConfigValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  imageConfig = _messages.MessageField('ImageConfig', 1)
  instanceConfig = _messages.MessageField('InstanceConfigValue', 2)
  notificationConfig = _messages.MessageField('NotificationConfig', 3)
  sequenceNumber = _messages.IntegerField(4)


class ConnectorOperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class Gateway(_messages.Message):
  r"""Gateway represents a user facing component that serves as an entrance to
  enable connectivity.

  Enums:
    TypeValueValuesEnum: Required. The type of hosting used by the gateway.

  Fields:
    type: Required. The type of hosting used by the gateway.
    uri: Output only. Server-defined URI for this resource.
    userPort: Output only. User port reserved on the gateways for this
      connection, if not specified or zero, the default port is 19443.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of hosting used by the gateway.

    Values:
      TYPE_UNSPECIFIED: Default value. This value is unused.
      GCP_REGIONAL_MIG: Gateway hosted in a GCP regional managed instance
        group.
    """
    TYPE_UNSPECIFIED = 0
    GCP_REGIONAL_MIG = 1

  type = _messages.EnumField('TypeValueValuesEnum', 1)
  uri = _messages.StringField(2)
  userPort = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudLocationListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('GoogleCloudLocationLocation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudLocationLocation(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class GoogleIamV1AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts jose@example.com from DATA_READ logging, and
  aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('GoogleIamV1AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class GoogleIamV1AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class GoogleIamV1Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Cloud Platform
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('GoogleTypeExpr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class GoogleIamV1Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('GoogleIamV1AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('GoogleIamV1Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleIamV1SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('GoogleIamV1Policy', 1)
  updateMask = _messages.StringField(2)


class GoogleIamV1TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class GoogleIamV1TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class GoogleLongrunningCancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GoogleTypeExpr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class ImageConfig(_messages.Message):
  r"""ImageConfig defines the control plane images to run.

  Fields:
    stableImage: The stable image that the remote agent will fallback to if
      the target image fails.
    targetImage: The initial image the remote agent will attempt to run for
      the control plane.
  """

  stableImage = _messages.StringField(1)
  targetImage = _messages.StringField(2)


class ListConnectionsResponse(_messages.Message):
  r"""Response message for BeyondCorp.ListConnections.

  Fields:
    connections: A list of BeyondCorp Connections in the project.
    nextPageToken: A token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachable: A list of locations that could not be reached.
  """

  connections = _messages.MessageField('Connection', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListConnectorsResponse(_messages.Message):
  r"""Response message for BeyondCorp.ListConnectors.

  Fields:
    connectors: A list of BeyondCorp Connectors in the project.
    nextPageToken: A token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachable: A list of locations that could not be reached.
  """

  connectors = _messages.MessageField('Connector', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class NotificationConfig(_messages.Message):
  r"""NotificationConfig defines the mechanisms to notify instance agent.

  Fields:
    pubsubNotification: Pub/Sub topic for Connector to subscribe and receive
      notifications from `projects/{project}/topics/{pubsub_topic}`
  """

  pubsubNotification = _messages.MessageField('CloudPubSubNotificationConfig', 1)


class PrincipalInfo(_messages.Message):
  r"""PrincipalInfo represents an Identity oneof.

  Fields:
    serviceAccount: A GCP service account.
  """

  serviceAccount = _messages.MessageField('ServiceAccount', 1)


class ReportStatusRequest(_messages.Message):
  r"""Request report the connector status.

  Fields:
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    resourceInfo: Required. Resource info of the connector.
    validateOnly: Optional. If set, validates request by executing a dry-run
      which would not alter the resource in any way.
  """

  requestId = _messages.StringField(1)
  resourceInfo = _messages.MessageField('ResourceInfo', 2)
  validateOnly = _messages.BooleanField(3)


class ResolveConnectionsResponse(_messages.Message):
  r"""Response message for BeyondCorp.ResolveConnections.

  Fields:
    connectionDetails: A list of BeyondCorp Connections with details in the
      project.
    nextPageToken: A token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachable: A list of locations that could not be reached.
  """

  connectionDetails = _messages.MessageField('ConnectionDetails', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ResolveInstanceConfigResponse(_messages.Message):
  r"""Response message for BeyondCorp.ResolveInstanceConfig.

  Fields:
    instanceConfig: ConnectorInstanceConfig.
  """

  instanceConfig = _messages.MessageField('ConnectorInstanceConfig', 1)


class ResourceInfo(_messages.Message):
  r"""ResourceInfo represents the information/status of the associated
  resource.

  Enums:
    StatusValueValuesEnum: Overall health status. Overall status is derived
      based on the status of each sub level resources.

  Messages:
    ResourceValue: Specific details for the resource.

  Fields:
    id: Required. Unique Id for the resource.
    resource: Specific details for the resource.
    status: Overall health status. Overall status is derived based on the
      status of each sub level resources.
    sub: List of Info for the sub level resources.
    time: The timestamp to collect the info. It is suggested to be set by the
      topmost level resource only.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Overall health status. Overall status is derived based on the status
    of each sub level resources.

    Values:
      HEALTH_STATUS_UNSPECIFIED: Health status is unknown: not initialized or
        failed to retrieve.
      HEALTHY: The resource is healthy.
      UNHEALTHY: The resource is unhealthy.
      UNRESPONSIVE: The resource is unresponsive.
      DEGRADED: The resource is some sub-resources are UNHEALTHY.
    """
    HEALTH_STATUS_UNSPECIFIED = 0
    HEALTHY = 1
    UNHEALTHY = 2
    UNRESPONSIVE = 3
    DEGRADED = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResourceValue(_messages.Message):
    r"""Specific details for the resource.

    Messages:
      AdditionalProperty: An additional property for a ResourceValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResourceValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  id = _messages.StringField(1)
  resource = _messages.MessageField('ResourceValue', 2)
  status = _messages.EnumField('StatusValueValuesEnum', 3)
  sub = _messages.MessageField('ResourceInfo', 4, repeated=True)
  time = _messages.StringField(5)


class ServiceAccount(_messages.Message):
  r"""ServiceAccount represents a GCP service account.

  Fields:
    email: Email address of the service account.
  """

  email = _messages.StringField(1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
