"""Generated message classes for osconfig version v1alpha2.

OS management tools that can be used for patch management, patch compliance,
and configuration management on VM instances.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'osconfig'


class AptRepository(_messages.Message):
  r"""Represents a single apt package repository. These will be added to a
  repo file that will be managed at
  /etc/apt/sources.list.d/google_osconfig.list.

  Enums:
    ArchiveTypeValueValuesEnum: Type of archive files in this repository. The
      default behavior is DEB.

  Fields:
    archiveType: Type of archive files in this repository. The default
      behavior is DEB.
    components: List of components for this repository. Must contain at least
      one item.
    distribution: Required. Distribution of this repository.
    gpgKey: Optional. URI of the key file for this repository. The agent will
      maintain a keyring at /etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg
      containing all the keys in any applied GuestPolicy.
    uri: Required. URI for this repository.
  """

  class ArchiveTypeValueValuesEnum(_messages.Enum):
    r"""Type of archive files in this repository. The default behavior is DEB.

    Values:
      ARCHIVE_TYPE_UNSPECIFIED: Unspecified.
      DEB: Deb indicates that the archive contains binary files.
      DEB_SRC: Deb-src indicates that the archive contains source files.
    """
    ARCHIVE_TYPE_UNSPECIFIED = 0
    DEB = 1
    DEB_SRC = 2

  archiveType = _messages.EnumField('ArchiveTypeValueValuesEnum', 1)
  components = _messages.StringField(2, repeated=True)
  distribution = _messages.StringField(3)
  gpgKey = _messages.StringField(4)
  uri = _messages.StringField(5)


class AptSettings(_messages.Message):
  r"""Apt patching will be performed by executing `apt-get update && apt-get
  upgrade`. Additional options can be set to control how this is executed.

  Enums:
    TypeValueValuesEnum: Optional. By changing the type to DIST, the patching
      will be performed using `apt-get dist-upgrade` instead.

  Fields:
    excludes: List of packages to exclude from update.
    exclusivePackages: An exclusive list of packages to be updated. These are
      the only packages that will be updated. If these packages are not
      installed, they will be ignored. This field cannot be specified with any
      other patch configuration fields.
    type: Optional. By changing the type to DIST, the patching will be
      performed using `apt-get dist-upgrade` instead.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Optional. By changing the type to DIST, the patching will be performed
    using `apt-get dist-upgrade` instead.

    Values:
      TYPE_UNSPECIFIED: By default, upgrade will be performed.
      DIST: Runs `apt-get dist-upgrade`.
      UPGRADE: Runs `apt-get upgrade`.
    """
    TYPE_UNSPECIFIED = 0
    DIST = 1
    UPGRADE = 2

  excludes = _messages.StringField(1, repeated=True)
  exclusivePackages = _messages.StringField(2, repeated=True)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class Assignment(_messages.Message):
  r"""An Assignment represents the group or groups of VMs that the policy
  applies to. If an Assignment is empty, it applies to all VMs. Otherwise, the
  targeted VMs must meet ALL criteria specified. So if both labels and zones
  are specified, the policy will apply to VMs with those labels AND in those
  zones.

  Fields:
    groupLabels: Targets instances matching at least one of these label sets.
      This allows an assignment to target disparate groups, for example
      "env=prod or env=staging".
    instanceNamePrefixes: Targets VMs whose name starts with one of these
      prefixes. Like labels, this is another way to group VMs when targeting
      configs, for example prefix="prod-". Only supported for project-level
      policies.
    instances: Targets any of the instances specified. Instances are specified
      by their URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]` or `ht
      tps://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/i
      nstances/[INSTANCE_NAME]` Instance targeting is uncommon and is
      supported to facilitate orchestrating changes by instance or to target
      specific VMs for development and testing. Only supported for project-
      level policies and must reference instances within this project.
    osArchitectures: Targets VMs with OS Inventory enabled and having one of
      the following OS architectures.
    osShortNames: Targets VMs with OS Inventory enabled and having one of the
      following OS short names, for example "debian", "windows".
    osVersions: Targets VMs with OS Inventory enabled and having one of the
      following OS versions.
    zones: Targets instances in ANY of these zones. Leave empty to target
      instances in any zone. Zonal targeting is uncommon and is supported to
      facilitate orchestrating changes by zone.
  """

  groupLabels = _messages.MessageField('AssignmentGroupLabel', 1, repeated=True)
  instanceNamePrefixes = _messages.StringField(2, repeated=True)
  instances = _messages.StringField(3, repeated=True)
  osArchitectures = _messages.StringField(4, repeated=True)
  osShortNames = _messages.StringField(5, repeated=True)
  osVersions = _messages.StringField(6, repeated=True)
  zones = _messages.StringField(7, repeated=True)


class AssignmentGroupLabel(_messages.Message):
  r"""Represents a group of VMs that can be identified as having all these
  labels, for example "env=prod and app=web".

  Messages:
    LabelsValue: GCE instance labels that must be present for an instance to
      be included in this assignment group.

  Fields:
    labels: GCE instance labels that must be present for an instance to be
      included in this assignment group.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""GCE instance labels that must be present for an instance to be
    included in this assignment group.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labels = _messages.MessageField('LabelsValue', 1)


class CancelPatchJobRequest(_messages.Message):
  r"""Message for canceling a patch job."""


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class ExecStep(_messages.Message):
  r"""A step that runs an executable for a PatchJob.

  Fields:
    linuxExecStepConfig: The ExecStepConfig for all Linux VMs targeted by the
      PatchJob.
    windowsExecStepConfig: The ExecStepConfig for all Windows VMs targeted by
      the PatchJob.
  """

  linuxExecStepConfig = _messages.MessageField('ExecStepConfig', 1)
  windowsExecStepConfig = _messages.MessageField('ExecStepConfig', 2)


class ExecStepConfig(_messages.Message):
  r"""Common configurations for an ExecStep.

  Enums:
    InterpreterValueValuesEnum: The script interpreter to use to run the
      script. If no interpreter is specified the script will be executed
      directly, which will likely only succeed for scripts with shebang lines.
      [Wikipedia shebang](https://en.wikipedia.org/wiki/Shebang_(Unix)).

  Fields:
    allowedSuccessCodes: Optional. Defaults to [0]. A list of possible return
      values that the execution can return to indicate a success.
    gcsObject: A GCS object containing the executable.
    interpreter: The script interpreter to use to run the script. If no
      interpreter is specified the script will be executed directly, which
      will likely only succeed for scripts with shebang lines. [Wikipedia
      shebang](https://en.wikipedia.org/wiki/Shebang_(Unix)).
    localPath: An absolute path to the executable on the VM.
  """

  class InterpreterValueValuesEnum(_messages.Enum):
    r"""The script interpreter to use to run the script. If no interpreter is
    specified the script will be executed directly, which will likely only
    succeed for scripts with shebang lines. [Wikipedia
    shebang](https://en.wikipedia.org/wiki/Shebang_(Unix)).

    Values:
      INTERPRETER_UNSPECIFIED: Default value.
      SHELL: Indicates that the script will be run with /bin/sh on Linux and
        cmd on windows.
      POWERSHELL: Indicates that the file will be run with PowerShell.
    """
    INTERPRETER_UNSPECIFIED = 0
    SHELL = 1
    POWERSHELL = 2

  allowedSuccessCodes = _messages.IntegerField(1, repeated=True, variant=_messages.Variant.INT32)
  gcsObject = _messages.MessageField('GcsObject', 2)
  interpreter = _messages.EnumField('InterpreterValueValuesEnum', 3)
  localPath = _messages.StringField(4)


class ExecutePatchJobRequest(_messages.Message):
  r"""A request message to initiate patching across Compute Engine instances.

  Fields:
    description: Description of the PatchJob. Length of the description is
      limited to 1024 characters.
    displayName: Display name for this patch job. This does not have to be
      unique.
    dryRun: Should this patch be a dry-run only. Instances will be contacted,
      but they will do nothing.
    duration: Optional. Duration of the patch job. After the duration ends,
      the patch job will time out.
    filter: Instances to patch. This is the same filter used when listing
      compute instances. Use instance_filter instead.
    instanceFilter: Instances to patch, either explicitly or filtered by some
      criteria like zone or labels.
    patchConfig: Optional. Patch configuration being applied. If omitted,
      instances will be patched using the default configurations.
    rollout: Optional. Rollout strategy of the patch job.
  """

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  dryRun = _messages.BooleanField(3)
  duration = _messages.StringField(4)
  filter = _messages.StringField(5)
  instanceFilter = _messages.MessageField('PatchInstanceFilter', 6)
  patchConfig = _messages.MessageField('PatchConfig', 7)
  rollout = _messages.MessageField('PatchRollout', 8)


class FixedOrPercent(_messages.Message):
  r"""Message encapsulating a value that can be either absolute ("fixed") or
  relative ("percent") to a value.

  Fields:
    fixed: Specifies a fixed value.
    percent: Specifies the relative value defined as a percentage, which will
      be multiplied by a reference value.
  """

  fixed = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  percent = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GcsObject(_messages.Message):
  r"""GCS object representation.

  Fields:
    bucket: Bucket of the GCS object.
    generationNumber: Generation number of the GCS object. This is used to
      ensure that the ExecStep specified by this PatchJob does not change.
    object: Name of the GCS object.
  """

  bucket = _messages.StringField(1)
  generationNumber = _messages.IntegerField(2)
  object = _messages.StringField(3)


class GooRepository(_messages.Message):
  r"""Represents a Goo package repository. These will be added to a repo file
  that will be managed at C:/ProgramData/GooGet/repos/google_osconfig.repo.

  Fields:
    name: Required. The name of the repository.
    url: Required. The url of the repository.
  """

  name = _messages.StringField(1)
  url = _messages.StringField(2)


class GooSettings(_messages.Message):
  r"""Googet patching is performed by running `googet update`."""


class GoogleCloudOsconfigV1OSPolicyAssignmentOperationMetadata(_messages.Message):
  r"""OS policy assignment operation metadata provided by OS policy assignment
  API methods that return long running operations.

  Enums:
    ApiMethodValueValuesEnum: The OS policy assignment API method.
    RolloutStateValueValuesEnum: State of the rollout

  Fields:
    apiMethod: The OS policy assignment API method.
    osPolicyAssignment: Reference to the `OSPolicyAssignment` API resource.
      Format: `projects/{project_number}/locations/{location}/osPolicyAssignme
      nts/{os_policy_assignment_id@revision_id}`
    rolloutStartTime: Rollout start time
    rolloutState: State of the rollout
    rolloutUpdateTime: Rollout update time
  """

  class ApiMethodValueValuesEnum(_messages.Enum):
    r"""The OS policy assignment API method.

    Values:
      API_METHOD_UNSPECIFIED: Invalid value
      CREATE: Create OS policy assignment API method
      UPDATE: Update OS policy assignment API method
      DELETE: Delete OS policy assignment API method
    """
    API_METHOD_UNSPECIFIED = 0
    CREATE = 1
    UPDATE = 2
    DELETE = 3

  class RolloutStateValueValuesEnum(_messages.Enum):
    r"""State of the rollout

    Values:
      ROLLOUT_STATE_UNSPECIFIED: Invalid value
      IN_PROGRESS: The rollout is in progress.
      CANCELLING: The rollout is being cancelled.
      CANCELLED: The rollout is cancelled.
      SUCCEEDED: The rollout has completed successfully.
    """
    ROLLOUT_STATE_UNSPECIFIED = 0
    IN_PROGRESS = 1
    CANCELLING = 2
    CANCELLED = 3
    SUCCEEDED = 4

  apiMethod = _messages.EnumField('ApiMethodValueValuesEnum', 1)
  osPolicyAssignment = _messages.StringField(2)
  rolloutStartTime = _messages.StringField(3)
  rolloutState = _messages.EnumField('RolloutStateValueValuesEnum', 4)
  rolloutUpdateTime = _messages.StringField(5)


class GuestPolicy(_messages.Message):
  r"""An OS Config resource representing a guest configuration policy. These
  policies represent the desired state for a VM's guest environment including
  packages to install or remove, package repository configurations, and
  software to install.

  Fields:
    assignment: Specifies the VMs that are assigned this policy. This allows
      you to target sets or groups of VMs by different parameters such as
      labels, names, OS, or zones. Empty assignments will target ALL VMs
      underneath this policy. Conflict Management Policies that exist higher
      up in the resource hierarchy (closer to the Org) will override those
      lower down if there is a conflict. At the same level in the resource
      hierarchy (ie. within a project), the service will prevent the creation
      of multiple policies that conflict with each other. If there are
      multiple policies that specify the same config (eg. package, software
      recipe, repository, etc.), the service will ensure that no VM could
      potentially receive instructions from both policies. To create multiple
      policies that specify different versions of a package or different
      configs for different Operating Systems, each policy must be mutually
      exclusive in their targeting according to labels, OS, or other criteria.
      Different configs are identified for conflicts in different ways.
      Packages are identified by their name and the package manager(s) they
      target. Package repositories are identified by their unique id where
      applicable. Some package managers don't have a unique identifier for
      repositories and where that's the case, no uniqueness is validated by
      the service. Note that if OS Inventory is disabled, a VM will not be
      assigned a policy that targets by OS because the service will see this
      VM's OS as unknown.
    createTime: Output only. Time this GuestPolicy was created.
    description: Description of the GuestPolicy. Length of the description is
      limited to 1024 characters.
    etag: The etag for this GuestPolicy. If this is provided on update, it
      must match the server's etag.
    name: Unique name of the resource in this project using the form:
      `projects/{project_id}/guestPolicies/{guest_policy_id}`.
    packageRepositories: Optional. A list of package repositories to configure
      on the VM. This will be done before any other configs are applied so
      they can use these repos. Package repositories will only be configured
      if the corresponding package manager(s) are available.
    packages: The software packages to be managed by this policy.
    recipes: Optional. A list of Recipes to install on the VM.
    updateTime: Output only. Last time this GuestPolicy was updated.
  """

  assignment = _messages.MessageField('Assignment', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  etag = _messages.StringField(4)
  name = _messages.StringField(5)
  packageRepositories = _messages.MessageField('PackageRepository', 6, repeated=True)
  packages = _messages.MessageField('Package', 7, repeated=True)
  recipes = _messages.MessageField('SoftwareRecipe', 8, repeated=True)
  updateTime = _messages.StringField(9)


class ListGuestPoliciesResponse(_messages.Message):
  r"""A response message for listing GuestPolicies.

  Fields:
    guestPolicies: The list of GuestPolicies.
    nextPageToken: A pagination token that can be used to get the next page of
      GuestPolicies.
  """

  guestPolicies = _messages.MessageField('GuestPolicy', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListPatchDeploymentsResponse(_messages.Message):
  r"""A response message for listing patch deployments.

  Fields:
    nextPageToken: A pagination token that can be used to get the next page of
      patch deployments.
    patchDeployments: The list of patch deployments.
  """

  nextPageToken = _messages.StringField(1)
  patchDeployments = _messages.MessageField('PatchDeployment', 2, repeated=True)


class ListPatchJobInstanceDetailsResponse(_messages.Message):
  r"""A response message for listing the instances' details for a patch job.

  Fields:
    nextPageToken: A pagination token that can be used to get the next page of
      results.
    patchJobInstanceDetails: The list of instance status.
  """

  nextPageToken = _messages.StringField(1)
  patchJobInstanceDetails = _messages.MessageField('PatchJobInstanceDetails', 2, repeated=True)


class ListPatchJobsResponse(_messages.Message):
  r"""A response message for listing patch jobs.

  Fields:
    nextPageToken: A pagination token that can be used to get the next page of
      results.
    patchJobs: The list of patch jobs.
  """

  nextPageToken = _messages.StringField(1)
  patchJobs = _messages.MessageField('PatchJob', 2, repeated=True)


class LookupEffectiveGuestPoliciesRequest(_messages.Message):
  r"""A request message for getting the policies assigned to the instance.

  Fields:
    instanceIdToken: This is the GCE instance identity token described in
      https://cloud.google.com/compute/docs/instances/verifying-instance-
      identity where the audience is 'osconfig.googleapis.com' and the format
      is 'full'. If this is not provided, the request credentials will be used
      to authorize the request.
    osArchitecture: Architecture of OS running on the instance. The OS Config
      agent will only provide this field for targeting if OS Inventory is
      enabled for that instance.
    osShortName: Short name of the OS running on the instance. The OS Config
      agent will only provide this field for targeting if OS Inventory is
      enabled for that instance.
    osVersion: Version of the OS running on the instance. The OS Config agent
      will only provide this field for targeting if OS Inventory is enabled
      for that instance.
  """

  instanceIdToken = _messages.StringField(1)
  osArchitecture = _messages.StringField(2)
  osShortName = _messages.StringField(3)
  osVersion = _messages.StringField(4)


class LookupEffectiveGuestPoliciesResponse(_messages.Message):
  r"""Response with policy configs assigned to the instance.

  Fields:
    packageRepositories: List of package repository configurations assigned to
      the VM.
    packages: List of package configurations assigned to the VM
    softwareRecipes: List of recipes assigned to the VM
  """

  packageRepositories = _messages.MessageField('LookupEffectiveGuestPoliciesResponseSourcedPackageRepository', 1, repeated=True)
  packages = _messages.MessageField('LookupEffectiveGuestPoliciesResponseSourcedPackage', 2, repeated=True)
  softwareRecipes = _messages.MessageField('LookupEffectiveGuestPoliciesResponseSourcedSoftwareRecipe', 3, repeated=True)


class LookupEffectiveGuestPoliciesResponseSourcedPackage(_messages.Message):
  r"""A GuestPolicy package including its source.

  Fields:
    package: A software package to configure on the VM.
    source: Name of the GuestPolicy providing this config.
  """

  package = _messages.MessageField('Package', 1)
  source = _messages.StringField(2)


class LookupEffectiveGuestPoliciesResponseSourcedPackageRepository(_messages.Message):
  r"""A GuestPolicy package repository including its source.

  Fields:
    packageRepository: A software package repository to configure on the VM.
    source: Name of the GuestPolicy providing this config.
  """

  packageRepository = _messages.MessageField('PackageRepository', 1)
  source = _messages.StringField(2)


class LookupEffectiveGuestPoliciesResponseSourcedSoftwareRecipe(_messages.Message):
  r"""A GuestPolicy recipe including its source.

  Fields:
    softwareRecipe: A software recipe to configure on the VM.
    source: Name of the GuestPolicy providing this config.
  """

  softwareRecipe = _messages.MessageField('SoftwareRecipe', 1)
  source = _messages.StringField(2)


class MonthlySchedule(_messages.Message):
  r"""Represents a monthly schedule. An example of a valid monthly schedule is
  "on the third Tuesday of the month" or "on the 15th of the month".

  Fields:
    monthDay: Required. One day of the month. 1-31 indicates the 1st to the
      31st day. -1 indicates the last day of the month. Months without the
      target day will be skipped. For example, a schedule to run "every month
      on the 31st" will not run in February, April, June, etc.
    weekDayOfMonth: Required. Week day in a month.
  """

  monthDay = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  weekDayOfMonth = _messages.MessageField('WeekDayOfMonth', 2)


class OSPolicyAssignmentOperationMetadata(_messages.Message):
  r"""OS policy assignment operation metadata provided by OS policy assignment
  API methods that return long running operations.

  Enums:
    ApiMethodValueValuesEnum: The OS policy assignment API method.
    RolloutStateValueValuesEnum: State of the rollout

  Fields:
    apiMethod: The OS policy assignment API method.
    osPolicyAssignment: Reference to the `OSPolicyAssignment` API resource.
      Format: `projects/{project_number}/locations/{location}/osPolicyAssignme
      nts/{os_policy_assignment_id@revision_id}`
    rolloutStartTime: Rollout start time
    rolloutState: State of the rollout
    rolloutUpdateTime: Rollout update time
  """

  class ApiMethodValueValuesEnum(_messages.Enum):
    r"""The OS policy assignment API method.

    Values:
      API_METHOD_UNSPECIFIED: Invalid value
      CREATE: Create OS policy assignment API method
      UPDATE: Update OS policy assignment API method
      DELETE: Delete OS policy assignment API method
    """
    API_METHOD_UNSPECIFIED = 0
    CREATE = 1
    UPDATE = 2
    DELETE = 3

  class RolloutStateValueValuesEnum(_messages.Enum):
    r"""State of the rollout

    Values:
      ROLLOUT_STATE_UNSPECIFIED: Invalid value
      IN_PROGRESS: The rollout is in progress.
      CANCELLING: The rollout is being cancelled.
      CANCELLED: The rollout is cancelled.
      SUCCEEDED: The rollout has completed successfully.
    """
    ROLLOUT_STATE_UNSPECIFIED = 0
    IN_PROGRESS = 1
    CANCELLING = 2
    CANCELLED = 3
    SUCCEEDED = 4

  apiMethod = _messages.EnumField('ApiMethodValueValuesEnum', 1)
  osPolicyAssignment = _messages.StringField(2)
  rolloutStartTime = _messages.StringField(3)
  rolloutState = _messages.EnumField('RolloutStateValueValuesEnum', 4)
  rolloutUpdateTime = _messages.StringField(5)


class OneTimeSchedule(_messages.Message):
  r"""Represents the time for a patch job execution.

  Fields:
    executeTime: Required. The desired patch job execution time.
  """

  executeTime = _messages.StringField(1)


class OsconfigFoldersGuestPoliciesCreateRequest(_messages.Message):
  r"""A OsconfigFoldersGuestPoliciesCreateRequest object.

  Fields:
    guestPolicy: A GuestPolicy resource to be passed as the request body.
    guestPolicyId: Required. The logical name of the Guest Policy in the
      project with the following restrictions: * Must contain only lowercase
      letters, numbers, and hyphens. * Must start with a letter. * Must be
      between 1-63 characters. * Must end with a number or a letter. * Must be
      unique within the project.
    parent: The resource name of the parent.
  """

  guestPolicy = _messages.MessageField('GuestPolicy', 1)
  guestPolicyId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OsconfigFoldersGuestPoliciesDeleteRequest(_messages.Message):
  r"""A OsconfigFoldersGuestPoliciesDeleteRequest object.

  Fields:
    name: The resource name of the GuestPolicy.
  """

  name = _messages.StringField(1, required=True)


class OsconfigFoldersGuestPoliciesGetRequest(_messages.Message):
  r"""A OsconfigFoldersGuestPoliciesGetRequest object.

  Fields:
    name: The resource name of the GuestPolicy.
  """

  name = _messages.StringField(1, required=True)


class OsconfigFoldersGuestPoliciesListRequest(_messages.Message):
  r"""A OsconfigFoldersGuestPoliciesListRequest object.

  Fields:
    pageSize: The maximum number of GuestPolicies to return.
    pageToken: A pagination token returned from a previous call to
      ListGuestPolicies that indicates where this listing should continue
      from. This field is optional.
    parent: The resource name of the parent.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OsconfigFoldersGuestPoliciesPatchRequest(_messages.Message):
  r"""A OsconfigFoldersGuestPoliciesPatchRequest object.

  Fields:
    guestPolicy: A GuestPolicy resource to be passed as the request body.
    name: Unique name of the resource in this project using the form:
      `projects/{project_id}/guestPolicies/{guest_policy_id}`.
    updateMask: Field mask that controls which fields of the GuestPolicy
      should be updated.
  """

  guestPolicy = _messages.MessageField('GuestPolicy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class OsconfigOrganizationsGuestPoliciesCreateRequest(_messages.Message):
  r"""A OsconfigOrganizationsGuestPoliciesCreateRequest object.

  Fields:
    guestPolicy: A GuestPolicy resource to be passed as the request body.
    guestPolicyId: Required. The logical name of the Guest Policy in the
      project with the following restrictions: * Must contain only lowercase
      letters, numbers, and hyphens. * Must start with a letter. * Must be
      between 1-63 characters. * Must end with a number or a letter. * Must be
      unique within the project.
    parent: The resource name of the parent.
  """

  guestPolicy = _messages.MessageField('GuestPolicy', 1)
  guestPolicyId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OsconfigOrganizationsGuestPoliciesDeleteRequest(_messages.Message):
  r"""A OsconfigOrganizationsGuestPoliciesDeleteRequest object.

  Fields:
    name: The resource name of the GuestPolicy.
  """

  name = _messages.StringField(1, required=True)


class OsconfigOrganizationsGuestPoliciesGetRequest(_messages.Message):
  r"""A OsconfigOrganizationsGuestPoliciesGetRequest object.

  Fields:
    name: The resource name of the GuestPolicy.
  """

  name = _messages.StringField(1, required=True)


class OsconfigOrganizationsGuestPoliciesListRequest(_messages.Message):
  r"""A OsconfigOrganizationsGuestPoliciesListRequest object.

  Fields:
    pageSize: The maximum number of GuestPolicies to return.
    pageToken: A pagination token returned from a previous call to
      ListGuestPolicies that indicates where this listing should continue
      from. This field is optional.
    parent: The resource name of the parent.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OsconfigOrganizationsGuestPoliciesPatchRequest(_messages.Message):
  r"""A OsconfigOrganizationsGuestPoliciesPatchRequest object.

  Fields:
    guestPolicy: A GuestPolicy resource to be passed as the request body.
    name: Unique name of the resource in this project using the form:
      `projects/{project_id}/guestPolicies/{guest_policy_id}`.
    updateMask: Field mask that controls which fields of the GuestPolicy
      should be updated.
  """

  guestPolicy = _messages.MessageField('GuestPolicy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class OsconfigProjectsGuestPoliciesCreateRequest(_messages.Message):
  r"""A OsconfigProjectsGuestPoliciesCreateRequest object.

  Fields:
    guestPolicy: A GuestPolicy resource to be passed as the request body.
    guestPolicyId: Required. The logical name of the Guest Policy in the
      project with the following restrictions: * Must contain only lowercase
      letters, numbers, and hyphens. * Must start with a letter. * Must be
      between 1-63 characters. * Must end with a number or a letter. * Must be
      unique within the project.
    parent: The resource name of the parent.
  """

  guestPolicy = _messages.MessageField('GuestPolicy', 1)
  guestPolicyId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OsconfigProjectsGuestPoliciesDeleteRequest(_messages.Message):
  r"""A OsconfigProjectsGuestPoliciesDeleteRequest object.

  Fields:
    name: The resource name of the GuestPolicy.
  """

  name = _messages.StringField(1, required=True)


class OsconfigProjectsGuestPoliciesGetRequest(_messages.Message):
  r"""A OsconfigProjectsGuestPoliciesGetRequest object.

  Fields:
    name: The resource name of the GuestPolicy.
  """

  name = _messages.StringField(1, required=True)


class OsconfigProjectsGuestPoliciesListRequest(_messages.Message):
  r"""A OsconfigProjectsGuestPoliciesListRequest object.

  Fields:
    pageSize: The maximum number of GuestPolicies to return.
    pageToken: A pagination token returned from a previous call to
      ListGuestPolicies that indicates where this listing should continue
      from. This field is optional.
    parent: The resource name of the parent.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OsconfigProjectsGuestPoliciesPatchRequest(_messages.Message):
  r"""A OsconfigProjectsGuestPoliciesPatchRequest object.

  Fields:
    guestPolicy: A GuestPolicy resource to be passed as the request body.
    name: Unique name of the resource in this project using the form:
      `projects/{project_id}/guestPolicies/{guest_policy_id}`.
    updateMask: Field mask that controls which fields of the GuestPolicy
      should be updated.
  """

  guestPolicy = _messages.MessageField('GuestPolicy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class OsconfigProjectsPatchDeploymentsCreateRequest(_messages.Message):
  r"""A OsconfigProjectsPatchDeploymentsCreateRequest object.

  Fields:
    parent: Required. The project to apply this patch deployment to in the
      form `projects/*`.
    patchDeployment: A PatchDeployment resource to be passed as the request
      body.
    patchDeploymentId: Required. The logical name of the patch deployment in
      the project with the following restrictions: * Must contain only
      lowercase letters, numbers, and hyphens. * Must start with a letter. *
      Must be between 1-63 characters. * Must end with a number or a letter. *
      Must be unique within the project.
  """

  parent = _messages.StringField(1, required=True)
  patchDeployment = _messages.MessageField('PatchDeployment', 2)
  patchDeploymentId = _messages.StringField(3)


class OsconfigProjectsPatchDeploymentsDeleteRequest(_messages.Message):
  r"""A OsconfigProjectsPatchDeploymentsDeleteRequest object.

  Fields:
    name: Required. The resource name of the patch deployment in the form
      `projects/*/patchDeployments/*`.
  """

  name = _messages.StringField(1, required=True)


class OsconfigProjectsPatchDeploymentsGetRequest(_messages.Message):
  r"""A OsconfigProjectsPatchDeploymentsGetRequest object.

  Fields:
    name: Required. The resource name of the patch deployment in the form
      `projects/*/patchDeployments/*`.
  """

  name = _messages.StringField(1, required=True)


class OsconfigProjectsPatchDeploymentsListRequest(_messages.Message):
  r"""A OsconfigProjectsPatchDeploymentsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of patch deployments to return.
      Default is 100.
    pageToken: Optional. A pagination token returned from a previous call to
      ListPatchDeployments that indicates where this listing should continue
      from.
    parent: Required. The resource name of the parent in the form
      `projects/*`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OsconfigProjectsPatchDeploymentsPatchRequest(_messages.Message):
  r"""A OsconfigProjectsPatchDeploymentsPatchRequest object.

  Fields:
    name: Unique name of the resource in this project using the form:
      `projects/{project_id}/patchDeployments/{patch_deployment_id}`. Ignored
      when creating a new PatchDeployment.
    patchDeployment: A PatchDeployment resource to be passed as the request
      body.
    updateMask: Optional. Field mask that controls which fields of the patch
      deployment should be updated.
  """

  name = _messages.StringField(1, required=True)
  patchDeployment = _messages.MessageField('PatchDeployment', 2)
  updateMask = _messages.StringField(3)


class OsconfigProjectsPatchJobsCancelRequest(_messages.Message):
  r"""A OsconfigProjectsPatchJobsCancelRequest object.

  Fields:
    cancelPatchJobRequest: A CancelPatchJobRequest resource to be passed as
      the request body.
    name: Name of the patch in the form `projects/*/patchJobs/*`
  """

  cancelPatchJobRequest = _messages.MessageField('CancelPatchJobRequest', 1)
  name = _messages.StringField(2, required=True)


class OsconfigProjectsPatchJobsExecuteRequest(_messages.Message):
  r"""A OsconfigProjectsPatchJobsExecuteRequest object.

  Fields:
    executePatchJobRequest: A ExecutePatchJobRequest resource to be passed as
      the request body.
    parent: The project in which to run this patch in the form `projects/*`
  """

  executePatchJobRequest = _messages.MessageField('ExecutePatchJobRequest', 1)
  parent = _messages.StringField(2, required=True)


class OsconfigProjectsPatchJobsGetRequest(_messages.Message):
  r"""A OsconfigProjectsPatchJobsGetRequest object.

  Fields:
    name: Name of the patch in the form `projects/*/patchJobs/*`
  """

  name = _messages.StringField(1, required=True)


class OsconfigProjectsPatchJobsInstanceDetailsListRequest(_messages.Message):
  r"""A OsconfigProjectsPatchJobsInstanceDetailsListRequest object.

  Fields:
    filter: A filter expression that filters results listed in the response.
      Supports filtering results by instance zone, name, state, or
      failure_reason.
    pageSize: The maximum number of instance details records to return.
    pageToken: Optional. A pagination token returned from a previous call that
      indicates where this listing should continue from.
    parent: In the form of `projects/*/patchJobs/*`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class OsconfigProjectsPatchJobsListRequest(_messages.Message):
  r"""A OsconfigProjectsPatchJobsListRequest object.

  Fields:
    filter: If provided, this field specifies the criteria that must be met by
      patch jobs to be included in the response. Currently, filtering is only
      available on the patch_deployment field.
    pageSize: The maximum number of instance status to return.
    pageToken: Optional. A pagination token returned from a previous call that
      indicates where this listing should continue from.
    parent: In the form of `projects/*`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class OsconfigProjectsZonesInstancesLookupGuestPoliciesRequest(_messages.Message):
  r"""A OsconfigProjectsZonesInstancesLookupGuestPoliciesRequest object.

  Fields:
    instance: The GCE VM instance whose policies are being looked up.
    lookupEffectiveGuestPoliciesRequest: A LookupEffectiveGuestPoliciesRequest
      resource to be passed as the request body.
  """

  instance = _messages.StringField(1, required=True)
  lookupEffectiveGuestPoliciesRequest = _messages.MessageField('LookupEffectiveGuestPoliciesRequest', 2)


class Package(_messages.Message):
  r"""Package is a reference to the software package to be installed or
  removed. The agent on the VM will use the system package manager to apply
  the config. These are the commands that the agent will use to install or
  remove packages. Apt install: `apt-get update && apt-get -y install package1
  package2 package3` remove: `apt-get -y remove package1 package2 package3`
  Yum install: `yum -y install package1 package2 package3` remove: `yum -y
  remove package1 package2 package3` Zypper install: `zypper install package1
  package2 package3` remove: `zypper rm package1 package2` Googet install:
  `googet -noconfirm install package1 package2 package3` remove: `googet
  -noconfirm remove package1 package2 package3`

  Enums:
    DesiredStateValueValuesEnum: Optional. The desired_state the agent should
      maintain for this package. The default is to ensure the package is
      installed.
    ManagerValueValuesEnum: Optional. Type of package manager that can be used
      to install this package. If a system does not have the package manager,
      the package will not be installed/removed and there is no error. By
      default or when specifying ANY, the agent will attempt to install and
      remove this package using the default package manager. This is helpful
      when creating a policy that applies to different types of systems. The
      default behavior is ANY.

  Fields:
    desiredState: Optional. The desired_state the agent should maintain for
      this package. The default is to ensure the package is installed.
    manager: Optional. Type of package manager that can be used to install
      this package. If a system does not have the package manager, the package
      will not be installed/removed and there is no error. By default or when
      specifying ANY, the agent will attempt to install and remove this
      package using the default package manager. This is helpful when creating
      a policy that applies to different types of systems. The default
      behavior is ANY.
    name: The name of the package. A package is uniquely identified for
      conflict validation by checking its name and the manager(s) it targets.
  """

  class DesiredStateValueValuesEnum(_messages.Enum):
    r"""Optional. The desired_state the agent should maintain for this
    package. The default is to ensure the package is installed.

    Values:
      DESIRED_STATE_UNSPECIFIED: The default is to ensure the package is
        installed.
      INSTALLED: The agent will ensure that the package is installed.
      UPDATED: The agent will ensure that the package is installed and will
        periodically check for and install any updates.
      REMOVED: The agent will ensure that the package is not installed and
        uninstall it if detected.
    """
    DESIRED_STATE_UNSPECIFIED = 0
    INSTALLED = 1
    UPDATED = 2
    REMOVED = 3

  class ManagerValueValuesEnum(_messages.Enum):
    r"""Optional. Type of package manager that can be used to install this
    package. If a system does not have the package manager, the package will
    not be installed/removed and there is no error. By default or when
    specifying ANY, the agent will attempt to install and remove this package
    using the default package manager. This is helpful when creating a policy
    that applies to different types of systems. The default behavior is ANY.

    Values:
      MANAGER_UNSPECIFIED: The default behavior is ANY.
      ANY: Apply this package config using the default system package manager.
      APT: Apply this package config only if Apt is available on the system.
      YUM: Apply this package config only if Yum is available on the system.
      ZYPPER: Apply this package config only if Zypper is available on the
        system.
      GOO: Apply this package config only if GooGet is available on the
        system.
    """
    MANAGER_UNSPECIFIED = 0
    ANY = 1
    APT = 2
    YUM = 3
    ZYPPER = 4
    GOO = 5

  desiredState = _messages.EnumField('DesiredStateValueValuesEnum', 1)
  manager = _messages.EnumField('ManagerValueValuesEnum', 2)
  name = _messages.StringField(3)


class PackageRepository(_messages.Message):
  r"""A package repository.

  Fields:
    apt: An Apt Repository.
    goo: A Goo Repository.
    yum: A Yum Repository.
    zypper: A Zypper Repository.
  """

  apt = _messages.MessageField('AptRepository', 1)
  goo = _messages.MessageField('GooRepository', 2)
  yum = _messages.MessageField('YumRepository', 3)
  zypper = _messages.MessageField('ZypperRepository', 4)


class PatchConfig(_messages.Message):
  r"""Patch configuration specifications. Contains details on specifically how
  to apply the patch(es) to an instance.

  Enums:
    RebootConfigValueValuesEnum: Optional. Post-patch reboot settings.

  Fields:
    apt: Apt update settings. Use this override the default apt patch rules.
    goo: Goo update settings. Use this override the default goo patch rules.
    postStep: Optional. The ExecStep to run after the patch update.
    preStep: Optional. The ExecStep to run before the patch update.
    rebootConfig: Optional. Post-patch reboot settings.
    retryStrategy: Optional. Retry strategy can be defined to have the agent
      retry patching during the window if patching fails. If omitted, the
      agent will use its default retry strategy.
    windowsUpdate: Windows update settings. Use this override the default
      windows patch rules.
    yum: Yum update settings. Use this override the default yum patch rules.
    zypper: Zypper update settings. Use this override the default zypper patch
      rules.
  """

  class RebootConfigValueValuesEnum(_messages.Enum):
    r"""Optional. Post-patch reboot settings.

    Values:
      REBOOT_CONFIG_UNSPECIFIED: The default behavior is DEFAULT.
      DEFAULT: The agent will decide if a reboot is necessary by checking well
        known signals such as registry keys on Windows or `/var/run/reboot-
        required` on APT based systems. On RPM based systems a set of core
        system package install times will be compared with system boot time.
      ALWAYS: Always reboot the machine after the update has completed.
      NEVER: Never reboot the machine after the update has completed.
    """
    REBOOT_CONFIG_UNSPECIFIED = 0
    DEFAULT = 1
    ALWAYS = 2
    NEVER = 3

  apt = _messages.MessageField('AptSettings', 1)
  goo = _messages.MessageField('GooSettings', 2)
  postStep = _messages.MessageField('ExecStep', 3)
  preStep = _messages.MessageField('ExecStep', 4)
  rebootConfig = _messages.EnumField('RebootConfigValueValuesEnum', 5)
  retryStrategy = _messages.MessageField('RetryStrategy', 6)
  windowsUpdate = _messages.MessageField('WindowsUpdateSettings', 7)
  yum = _messages.MessageField('YumSettings', 8)
  zypper = _messages.MessageField('ZypperSettings', 9)


class PatchDeployment(_messages.Message):
  r"""An OS Config resource representing a patch deployment. These deployments
  represent configurations that individual patch jobs should be executed with,
  such as the instance filter, package repository settings, and a schedule.

  Fields:
    createTime: Output only. Time this patch deployment was created.
    description: Optional. Description of the patch deployment. Length of the
      description is limited to 1024 characters.
    duration: Optional. Duration of the patch. After the duration ends, patch
      will time out.
    instanceFilter: Required. Instances to patch.
    lastExecuteTime: Output only. The last execution time of a patch job
      triggered by this deployment.
    name: Unique name of the resource in this project using the form:
      `projects/{project_id}/patchDeployments/{patch_deployment_id}`. Ignored
      when creating a new PatchDeployment.
    oneTimeSchedule: Required. Schedule with an one-time execution.
    patchConfig: Optional. Patch configuration being applied.
    recurringSchedule: Required. Schedule with recurring executions.
    rollout: Optional. Rollout strategy of the patch job.
    updateTime: Output only. Time this patch deployment was updated.
  """

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  duration = _messages.StringField(3)
  instanceFilter = _messages.MessageField('PatchInstanceFilter', 4)
  lastExecuteTime = _messages.StringField(5)
  name = _messages.StringField(6)
  oneTimeSchedule = _messages.MessageField('OneTimeSchedule', 7)
  patchConfig = _messages.MessageField('PatchConfig', 8)
  recurringSchedule = _messages.MessageField('RecurringSchedule', 9)
  rollout = _messages.MessageField('PatchRollout', 10)
  updateTime = _messages.StringField(11)


class PatchInstanceFilter(_messages.Message):
  r"""A filter to target VM instances for patching. The targeted VMs must meet
  all criteria specified. So if both labels and zones are specified, the patch
  job will target only VMs with those labels AND in those zones.

  Fields:
    all: Target all instances in the project. If true, no other criteria is
      permitted.
    groupLabels: Targets VM instances matching at least one of these label
      sets. This allows targeting of disparate groups, for example "env=prod
      or env=staging".
    instanceNamePrefixes: Targets VMs whose name starts with one of these
      prefixes. Like labels, this is another way to group VMs when targeting
      configs, for example prefix="prod-".
    instances: Targets any of the VM instances specified. Instances are
      specified by their URI in the form
      `zones/[ZONE]/instances/[INSTANCE_NAME],
      `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or `http
      s://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/ins
      tances/[INSTANCE_NAME]`
    zones: Targets VM instances in ANY of these zones. Leave empty to target
      instances in any zone.
  """

  all = _messages.BooleanField(1)
  groupLabels = _messages.MessageField('PatchInstanceFilterGroupLabel', 2, repeated=True)
  instanceNamePrefixes = _messages.StringField(3, repeated=True)
  instances = _messages.StringField(4, repeated=True)
  zones = _messages.StringField(5, repeated=True)


class PatchInstanceFilterGroupLabel(_messages.Message):
  r"""Represents a group of VMs that can be identified as having all these
  labels, for example "env=prod and app=web".

  Messages:
    LabelsValue: Compute Engine instance labels that must be present for an
      instance to be targeted by this filter.

  Fields:
    labels: Compute Engine instance labels that must be present for an
      instance to be targeted by this filter.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Compute Engine instance labels that must be present for an instance to
    be targeted by this filter.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labels = _messages.MessageField('LabelsValue', 1)


class PatchJob(_messages.Message):
  r"""A high level representation of a patch job that is either in progress or
  has completed. Instance details are not included in the job. To paginate
  through instance details, use `ListPatchJobInstanceDetails`.

  Enums:
    StateValueValuesEnum: Output only. The current state of the PatchJob.

  Fields:
    createTime: Output only. Time this PatchJob was created.
    description: Description of the patch job. Length of the description is
      limited to 1024 characters.
    displayName: Display name for this patch job. This is not a unique
      identifier.
    dryRun: If this patch job is a dry run, the agent will report that it has
      finished without running any updates on the VM.
    duration: Duration of the patch job. After the duration ends, the patch
      job will time out.
    errorMessage: If this patch job failed, this message will provide
      information about the failure.
    filter: Instances to patch. This is the same filter used when listing
      compute instances. Use instance_filter instead.
    instanceDetailsSummary: Summary of instance details.
    instanceFilter: Instances to patch.
    name: Output only. Unique identifier for this patch job in the form
      `projects/*/patchJobs/*`
    patchConfig: Patch configuration being applied.
    patchDeployment: Output only. Name of the patch deployment that created
      this patch job.
    percentComplete: Reflects the overall progress of the patch job in the
      range of 0.0 being no progress to 100.0 being complete.
    rollout: Optional. Rollout strategy being applied.
    state: Output only. The current state of the PatchJob.
    updateTime: Output only. Last time this PatchJob was updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the PatchJob.

    Values:
      STATE_UNSPECIFIED: State must be specified.
      STARTED: The patch job was successfully initiated.
      INSTANCE_LOOKUP: The patch job is looking up instances to run the patch
        on.
      PATCHING: Instances are being patched.
      SUCCEEDED: Patch job completed successfully.
      COMPLETED_WITH_ERRORS: Patch job completed but there were errors.
      CANCELED: The patch job was canceled.
      TIMED_OUT: The patch job has timed out.
    """
    STATE_UNSPECIFIED = 0
    STARTED = 1
    INSTANCE_LOOKUP = 2
    PATCHING = 3
    SUCCEEDED = 4
    COMPLETED_WITH_ERRORS = 5
    CANCELED = 6
    TIMED_OUT = 7

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  dryRun = _messages.BooleanField(4)
  duration = _messages.StringField(5)
  errorMessage = _messages.StringField(6)
  filter = _messages.StringField(7)
  instanceDetailsSummary = _messages.MessageField('PatchJobInstanceDetailsSummary', 8)
  instanceFilter = _messages.MessageField('PatchInstanceFilter', 9)
  name = _messages.StringField(10)
  patchConfig = _messages.MessageField('PatchConfig', 11)
  patchDeployment = _messages.StringField(12)
  percentComplete = _messages.FloatField(13)
  rollout = _messages.MessageField('PatchRollout', 14)
  state = _messages.EnumField('StateValueValuesEnum', 15)
  updateTime = _messages.StringField(16)


class PatchJobInstanceDetails(_messages.Message):
  r"""Patch details of an instance.

  Enums:
    StateValueValuesEnum: Current state of instance patch.

  Fields:
    attemptCount: Number of times the agent attempted to apply the patch.
    failureReason: If the patch has failed, this is the reason.
    instanceSystemId: The unique, system-generated identifier for the
      instance.
    name: The instance name in the form `projects/*/zones/*/instances/*`
    state: Current state of instance patch.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Current state of instance patch.

    Values:
      PATCH_STATE_UNSPECIFIED: Unspecified.
      PENDING: The instance has not been notified yet.
      INACTIVE: Instance is inactive and cannot be patched.
      NOTIFIED: The instance has been notified that it should patch.
      STARTED: The instance has started the patching process.
      DOWNLOADING_PATCHES: The instance is downloading patches.
      APPLYING_PATCHES: The instance is applying patches.
      REBOOTING: The instance is rebooting.
      SUCCEEDED: The instance has completed applying patches.
      SUCCEEDED_REBOOT_REQUIRED: The instance has completed applying patches
        but a reboot is required.
      FAILED: The instance has failed to apply the patch.
      ACKED: The instance acked the notification and will start shortly.
      TIMED_OUT: The instance exceeded the time out while applying the patch.
      RUNNING_PRE_PATCH_STEP: The instance is running the pre-patch step.
      RUNNING_POST_PATCH_STEP: The instance is running the post-patch step.
      NO_AGENT_DETECTED: The service could not detect the presence of the
        agent. Check to ensure that the agent is installed, running, and able
        to communicate with the service.
    """
    PATCH_STATE_UNSPECIFIED = 0
    PENDING = 1
    INACTIVE = 2
    NOTIFIED = 3
    STARTED = 4
    DOWNLOADING_PATCHES = 5
    APPLYING_PATCHES = 6
    REBOOTING = 7
    SUCCEEDED = 8
    SUCCEEDED_REBOOT_REQUIRED = 9
    FAILED = 10
    ACKED = 11
    TIMED_OUT = 12
    RUNNING_PRE_PATCH_STEP = 13
    RUNNING_POST_PATCH_STEP = 14
    NO_AGENT_DETECTED = 15

  attemptCount = _messages.IntegerField(1)
  failureReason = _messages.StringField(2)
  instanceSystemId = _messages.StringField(3)
  name = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class PatchJobInstanceDetailsSummary(_messages.Message):
  r"""A summary of the current patch state across all instances this patch job
  affects. Contains counts of instances in different states. These states map
  to `InstancePatchState`. List patch job instance details to see the specific
  states of each instance.

  Fields:
    instancesAcked: Number of instances that have acked and will start
      shortly.
    instancesApplyingPatches: Number of instances that are applying patches.
    instancesDownloadingPatches: Number of instances that are downloading
      patches.
    instancesFailed: Number of instances that failed.
    instancesInactive: Number of instances that are inactive.
    instancesNoAgentDetected: Number of instances that do not appear to be
      running the agent. Check to ensure that the agent is installed, running,
      and able to communicate with the service.
    instancesNotified: Number of instances notified about patch job.
    instancesPending: Number of instances pending patch job.
    instancesRebooting: Number of instances rebooting.
    instancesRunningPostPatchStep: Number of instances that are running the
      post-patch step.
    instancesRunningPrePatchStep: Number of instances that are running the
      pre-patch step.
    instancesStarted: Number of instances that have started.
    instancesSucceeded: Number of instances that have completed successfully.
    instancesSucceededRebootRequired: Number of instances that require reboot.
    instancesTimedOut: Number of instances that exceeded the time out while
      applying the patch.
  """

  instancesAcked = _messages.IntegerField(1)
  instancesApplyingPatches = _messages.IntegerField(2)
  instancesDownloadingPatches = _messages.IntegerField(3)
  instancesFailed = _messages.IntegerField(4)
  instancesInactive = _messages.IntegerField(5)
  instancesNoAgentDetected = _messages.IntegerField(6)
  instancesNotified = _messages.IntegerField(7)
  instancesPending = _messages.IntegerField(8)
  instancesRebooting = _messages.IntegerField(9)
  instancesRunningPostPatchStep = _messages.IntegerField(10)
  instancesRunningPrePatchStep = _messages.IntegerField(11)
  instancesStarted = _messages.IntegerField(12)
  instancesSucceeded = _messages.IntegerField(13)
  instancesSucceededRebootRequired = _messages.IntegerField(14)
  instancesTimedOut = _messages.IntegerField(15)


class PatchRollout(_messages.Message):
  r"""Patch rollout configuration specifications. Contains details on the
  concurrency control when applying patch(es) to all targeted VMs.

  Enums:
    ModeValueValuesEnum: Mode of the patch rollout.

  Fields:
    disruptionBudget: The maximum number (or percentage) of VMs per zone to
      disrupt at any given moment. The number of VMs calculated from
      multiplying the percentage by the total number of VMs in a zone is
      rounded up. During patching, a VM is considered disrupted from the time
      the agent is notified to begin until patching has completed. This
      disruption time includes the time to complete reboot and any post-patch
      steps. A VM contributes to the disruption budget if its patching
      operation fails either when applying the patches, running pre or post
      patch steps, or if it fails to respond with a success notification
      before timing out. VMs that are not running or do not have an active
      agent do not count toward this disruption budget. For zone-by-zone
      rollouts, if the disruption budget in a zone is exceeded, the patch job
      stops, because continuing to the next zone requires completion of the
      patch process in the previous zone. For example, if the disruption
      budget has a fixed value of `10`, and 8 VMs fail to patch in the current
      zone, the patch job continues to patch 2 VMs at a time until the zone is
      completed. When that zone is completed successfully, patching begins
      with 10 VMs at a time in the next zone. If 10 VMs in the next zone fail
      to patch, the patch job stops.
    mode: Mode of the patch rollout.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""Mode of the patch rollout.

    Values:
      MODE_UNSPECIFIED: Mode must be specified.
      ZONE_BY_ZONE: Patches are applied one zone at a time. The patch job
        begins in the region with the lowest number of targeted VMs. Within
        the region, patching begins in the zone with the lowest number of
        targeted VMs. If multiple regions (or zones within a region) have the
        same number of targeted VMs, a tie-breaker is achieved by sorting the
        regions or zones in alphabetical order.
      CONCURRENT_ZONES: Patches are applied to VMs in all zones at the same
        time.
    """
    MODE_UNSPECIFIED = 0
    ZONE_BY_ZONE = 1
    CONCURRENT_ZONES = 2

  disruptionBudget = _messages.MessageField('FixedOrPercent', 1)
  mode = _messages.EnumField('ModeValueValuesEnum', 2)


class RecurringSchedule(_messages.Message):
  r"""Represents a recurring schedule for patch job executions.

  Enums:
    FrequencyValueValuesEnum: Required. The frequency unit of this recurring
      schedule.

  Fields:
    endTime: Optional. The end time for a recurring schedule to be active.
    frequency: Required. The frequency unit of this recurring schedule.
    lastExecuteTime: Output only. The last actual patch execution time for
      display.
    monthly: Required. Schedule with monthly executions.
    nextExecuteTime: Output only. The next expected patch execution time for
      display.
    startTime: Optional. The start time for a recurring schedule to be active.
      Defaults to create_time of the patch deployment.
    timeOfDay: Required. Time of the day for an instance of the recurrence.
    timeZone: Required. Defines the time zone that day_time will be relative
      to. The rules for daylight saving time are determined by the chosen time
      zone. , see b/141445686.
    weekly: Required. Schedule with weekly executions.
  """

  class FrequencyValueValuesEnum(_messages.Enum):
    r"""Required. The frequency unit of this recurring schedule.

    Values:
      FREQUENCY_UNSPECIFIED: Invalid. A frequency must be specified.
      WEEKLY: Indicates that the recurrence frequency should be expressed in
        terms of weeks.
      MONTHLY: Indicates that the recurrence frequency should be expressed in
        terms of months.
      DAILY: Indicates that the recurrence frequency should be expressed in
        terms of days.
    """
    FREQUENCY_UNSPECIFIED = 0
    WEEKLY = 1
    MONTHLY = 2
    DAILY = 3

  endTime = _messages.StringField(1)
  frequency = _messages.EnumField('FrequencyValueValuesEnum', 2)
  lastExecuteTime = _messages.StringField(3)
  monthly = _messages.MessageField('MonthlySchedule', 4)
  nextExecuteTime = _messages.StringField(5)
  startTime = _messages.StringField(6)
  timeOfDay = _messages.MessageField('TimeOfDay', 7)
  timeZone = _messages.MessageField('TimeZone', 8)
  weekly = _messages.MessageField('WeeklySchedule', 9)


class RetryStrategy(_messages.Message):
  r"""The strategy for retrying failed patches during the patch window.

  Fields:
    enabled: If true, the agent will continue to try and patch until the
      window has ended.
  """

  enabled = _messages.BooleanField(1)


class SoftwareRecipe(_messages.Message):
  r"""A software recipe is a set of instructions for installing and
  configuring a piece of software. It consists of a set of artifacts that will
  be downloaded and a set of steps that install, configure, and/or update th
  software. Recipes supports installing and updating software from artifacts
  in the following formats: Zip archive, Tar archive, Windows MSI, Debian
  package, and RPM package. Additionally it supports executing a script
  (either defined in a file or directly in this api) in bash, sh, cmd, and
  powershell. Updating a Software Recipe If a recipe is assigned to an
  instance and there is a recipe with the same name but a lower version
  already installed on the instance and the state of the recipe is
  INSTALLED_KEEP_UPDATED then the recipe will be updated to the new version.
  Script Working Directories Each script or exec step will be run in its own
  temporary directory which is deleted after completing the step.

  Enums:
    DesiredStateValueValuesEnum: Default is INSTALLED. The desired state the
      agent should maintain for this recipe. INSTALLED: The software recipe
      will be installed on the instance but won't be updated to new versions.
      INSTALLED_KEEP_UPDATED: The software recipe will be installed on the
      instance. It will also be updated to a higher version of the recipe if a
      higher version is assigned to this instance. REMOVE: Remove is
      unsupported for software recipes and attempts to create or update a
      recipe to the REMOVE state will be rejected.

  Fields:
    artifacts: Resources available to be used in the steps in the recipe.
    desiredState: Default is INSTALLED. The desired state the agent should
      maintain for this recipe. INSTALLED: The software recipe will be
      installed on the instance but won't be updated to new versions.
      INSTALLED_KEEP_UPDATED: The software recipe will be installed on the
      instance. It will also be updated to a higher version of the recipe if a
      higher version is assigned to this instance. REMOVE: Remove is
      unsupported for software recipes and attempts to create or update a
      recipe to the REMOVE state will be rejected.
    installSteps: Actions to be taken for installing this recipe. On failure
      it will stop executing steps and not attempt another installation. Any
      steps taken (including partially completed steps) will not be rolled
      back.
    name: Unique identifier for the recipe. Only one recipe with a given name
      will be installed on an instance. Names are also used to identify
      resource to determine whether guest policies conflict. This means that
      requests to create multiple recipes with the same name and version that
      could possibly have conflicting assignments will be rejected.
    updateSteps: Actions to be taken for updating this recipe. On failure it
      will stop executing steps and not attempt another update for this
      recipe. Any steps taken (including partially completed steps) will not
      be rolled back.
    version: The version of this software recipe. Version can be up to 4
      period separated numbers (e.g. 12.34.56.78).
  """

  class DesiredStateValueValuesEnum(_messages.Enum):
    r"""Default is INSTALLED. The desired state the agent should maintain for
    this recipe. INSTALLED: The software recipe will be installed on the
    instance but won't be updated to new versions. INSTALLED_KEEP_UPDATED: The
    software recipe will be installed on the instance. It will also be updated
    to a higher version of the recipe if a higher version is assigned to this
    instance. REMOVE: Remove is unsupported for software recipes and attempts
    to create or update a recipe to the REMOVE state will be rejected.

    Values:
      DESIRED_STATE_UNSPECIFIED: The default is to ensure the package is
        installed.
      INSTALLED: The agent will ensure that the package is installed.
      UPDATED: The agent will ensure that the package is installed and will
        periodically check for and install any updates.
      REMOVED: The agent will ensure that the package is not installed and
        uninstall it if detected.
    """
    DESIRED_STATE_UNSPECIFIED = 0
    INSTALLED = 1
    UPDATED = 2
    REMOVED = 3

  artifacts = _messages.MessageField('SoftwareRecipeArtifact', 1, repeated=True)
  desiredState = _messages.EnumField('DesiredStateValueValuesEnum', 2)
  installSteps = _messages.MessageField('SoftwareRecipeStep', 3, repeated=True)
  name = _messages.StringField(4)
  updateSteps = _messages.MessageField('SoftwareRecipeStep', 5, repeated=True)
  version = _messages.StringField(6)


class SoftwareRecipeArtifact(_messages.Message):
  r"""Specifies a resource to be used in the recipe.

  Fields:
    allowInsecure: Defaults to false. When false, recipes will be subject to
      validations based on the artifact type: Remote: A checksum must be
      specified, and only protocols with transport-layer security will be
      permitted. GCS: An object generation number must be specified.
    gcs: A GCS artifact.
    id: Id of the artifact, which the installation and update steps of this
      recipe can reference. Artifacts in a recipe cannot have the same id.
    remote: A generic remote artifact.
  """

  allowInsecure = _messages.BooleanField(1)
  gcs = _messages.MessageField('SoftwareRecipeArtifactGcs', 2)
  id = _messages.StringField(3)
  remote = _messages.MessageField('SoftwareRecipeArtifactRemote', 4)


class SoftwareRecipeArtifactGcs(_messages.Message):
  r"""Specifies an artifact available as a GCS Object.

  Fields:
    bucket: Bucket of the GCS object.
    generation: Optional if allow_insecure is true. Generation number of the
      GCS object.
    object: Name of the GCS object.
  """

  bucket = _messages.StringField(1)
  generation = _messages.IntegerField(2)
  object = _messages.StringField(3)


class SoftwareRecipeArtifactRemote(_messages.Message):
  r"""Specifies an artifact available via some URI.

  Fields:
    checksum: Optional if allow_insecure is true. SHA256 checksum to compare
      to the checksum of the artifact. If the checksum is not empty and it
      doesn't match the artifact then the recipe installation will fail before
      running any of the steps.
    uri: URI from which to fetch the object. It should contain both the
      protocol and path following the format {protocol}://{location}.
  """

  checksum = _messages.StringField(1)
  uri = _messages.StringField(2)


class SoftwareRecipeStep(_messages.Message):
  r"""An action that can be taken as part of installing or updating a recipe.

  Fields:
    archiveExtraction: Extracts an archive into the specified directory.
    dpkgInstallation: Installs a deb file via dpkg.
    fileCopy: Copies a file onto the instance.
    fileExec: Executes an artifact or local file.
    msiInstallation: Installs an MSI file.
    rpmInstallation: Installs an rpm file via the rpm utility.
    scriptRun: Runs commands in a shell.
  """

  archiveExtraction = _messages.MessageField('SoftwareRecipeStepExtractArchive', 1)
  dpkgInstallation = _messages.MessageField('SoftwareRecipeStepInstallDpkg', 2)
  fileCopy = _messages.MessageField('SoftwareRecipeStepCopyFile', 3)
  fileExec = _messages.MessageField('SoftwareRecipeStepExecFile', 4)
  msiInstallation = _messages.MessageField('SoftwareRecipeStepInstallMsi', 5)
  rpmInstallation = _messages.MessageField('SoftwareRecipeStepInstallRpm', 6)
  scriptRun = _messages.MessageField('SoftwareRecipeStepRunScript', 7)


class SoftwareRecipeStepCopyFile(_messages.Message):
  r"""Copies the artifact to the specified path on the instance.

  Fields:
    artifactId: The id of the relevant artifact in the recipe.
    destination: The absolute path on the instance to put the file.
    overwrite: Whether to allow this step to overwrite existing files. If this
      is false and the file already exists the file will not be overwritten
      and the step will be considered a success. Defaults to false.
    permissions: Consists of three octal digits which represent, in order, the
      permissions of the owner, group, and other users for the file (similarly
      to the numeric mode used in the linux chmod utility). Each digit
      represents a three bit number with the 4 bit corresponding to the read
      permissions, the 2 bit corresponds to the write bit, and the one bit
      corresponds to the execute permission. Default behavior is 755. Below
      are some examples of permissions and their associated values: read,
      write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
  """

  artifactId = _messages.StringField(1)
  destination = _messages.StringField(2)
  overwrite = _messages.BooleanField(3)
  permissions = _messages.StringField(4)


class SoftwareRecipeStepExecFile(_messages.Message):
  r"""Executes an artifact or local file.

  Fields:
    allowedExitCodes: Defaults to [0]. A list of possible return values that
      the program can return to indicate a success.
    args: Arguments to be passed to the provided executable.
    artifactId: The id of the relevant artifact in the recipe.
    localPath: The absolute path of the file on the local filesystem.
  """

  allowedExitCodes = _messages.IntegerField(1, repeated=True, variant=_messages.Variant.INT32)
  args = _messages.StringField(2, repeated=True)
  artifactId = _messages.StringField(3)
  localPath = _messages.StringField(4)


class SoftwareRecipeStepExtractArchive(_messages.Message):
  r"""Extracts an archive of the type specified in the specified directory.

  Enums:
    TypeValueValuesEnum: The type of the archive to extract.

  Fields:
    artifactId: The id of the relevant artifact in the recipe.
    destination: Directory to extract archive to. Defaults to / on Linux or
      C:\ on Windows.
    type: The type of the archive to extract.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of the archive to extract.

    Values:
      ARCHIVE_TYPE_UNSPECIFIED: Indicates that the archive type isn't
        specified.
      TAR: Indicates that the archive is a tar archive with no encryption.
      TAR_GZIP: Indicates that the archive is a tar archive with gzip
        encryption.
      TAR_BZIP: Indicates that the archive is a tar archive with bzip
        encryption.
      TAR_LZMA: Indicates that the archive is a tar archive with lzma
        encryption.
      TAR_XZ: Indicates that the archive is a tar archive with xz encryption.
      ZIP: Indicates that the archive is a zip archive.
    """
    ARCHIVE_TYPE_UNSPECIFIED = 0
    TAR = 1
    TAR_GZIP = 2
    TAR_BZIP = 3
    TAR_LZMA = 4
    TAR_XZ = 5
    ZIP = 6

  artifactId = _messages.StringField(1)
  destination = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class SoftwareRecipeStepInstallDpkg(_messages.Message):
  r"""Installs a deb via dpkg.

  Fields:
    artifactId: The id of the relevant artifact in the recipe.
  """

  artifactId = _messages.StringField(1)


class SoftwareRecipeStepInstallMsi(_messages.Message):
  r"""Installs an MSI file.

  Fields:
    allowedExitCodes: Return codes that indicate that the software installed
      or updated successfully. Behaviour defaults to [0]
    artifactId: The id of the relevant artifact in the recipe.
    flags: The flags to use when installing the MSI defaults to ["/i"] (i.e.
      the install flag).
  """

  allowedExitCodes = _messages.IntegerField(1, repeated=True, variant=_messages.Variant.INT32)
  artifactId = _messages.StringField(2)
  flags = _messages.StringField(3, repeated=True)


class SoftwareRecipeStepInstallRpm(_messages.Message):
  r"""Installs an rpm file via the rpm utility.

  Fields:
    artifactId: The id of the relevant artifact in the recipe.
  """

  artifactId = _messages.StringField(1)


class SoftwareRecipeStepRunScript(_messages.Message):
  r"""Runs a script through an interpreter.

  Enums:
    InterpreterValueValuesEnum: The script interpreter to use to run the
      script. If no interpreter is specified the script will be executed
      directly, which will likely only succeed for scripts with shebang lines.
      [Wikipedia shebang](https://en.wikipedia.org/wiki/Shebang_(Unix)).

  Fields:
    allowedExitCodes: Return codes that indicate that the software installed
      or updated successfully. Behaviour defaults to [0]
    args: Arguments to be passed to the provided script.
    interpreter: The script interpreter to use to run the script. If no
      interpreter is specified the script will be executed directly, which
      will likely only succeed for scripts with shebang lines. [Wikipedia
      shebang](https://en.wikipedia.org/wiki/Shebang_(Unix)).
    script: The shell script to be executed.
  """

  class InterpreterValueValuesEnum(_messages.Enum):
    r"""The script interpreter to use to run the script. If no interpreter is
    specified the script will be executed directly, which will likely only
    succeed for scripts with shebang lines. [Wikipedia
    shebang](https://en.wikipedia.org/wiki/Shebang_(Unix)).

    Values:
      INTERPRETER_UNSPECIFIED: Default value for ScriptType.
      SHELL: Indicates that the script will be run with /bin/sh on Linux and
        cmd on windows.
      POWERSHELL: Indicates that the script will be run with powershell.
    """
    INTERPRETER_UNSPECIFIED = 0
    SHELL = 1
    POWERSHELL = 2

  allowedExitCodes = _messages.IntegerField(1, repeated=True, variant=_messages.Variant.INT32)
  args = _messages.StringField(2, repeated=True)
  interpreter = _messages.EnumField('InterpreterValueValuesEnum', 3)
  script = _messages.StringField(4)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class TimeOfDay(_messages.Message):
  r"""Represents a time of day. The date and time zone are either not
  significant or are specified elsewhere. An API may choose to allow leap
  seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.

  Fields:
    hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may
      choose to allow the value "24:00:00" for scenarios like business closing
      time.
    minutes: Minutes of hour of day. Must be from 0 to 59.
    nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An
      API may allow the value 60 if it allows leap-seconds.
  """

  hours = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minutes = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  nanos = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class TimeZone(_messages.Message):
  r"""Represents a time zone from the [IANA Time Zone
  Database](https://www.iana.org/time-zones).

  Fields:
    id: IANA Time Zone Database time zone, e.g. "America/New_York".
    version: Optional. IANA Time Zone Database version number, e.g. "2019a".
  """

  id = _messages.StringField(1)
  version = _messages.StringField(2)


class WeekDayOfMonth(_messages.Message):
  r"""Represents one week day in a month. An example is "the 4th Sunday".

  Enums:
    DayOfWeekValueValuesEnum: Required. A day of the week.

  Fields:
    dayOfWeek: Required. A day of the week.
    weekOrdinal: Required. Week number in a month. 1-4 indicates the 1st to
      4th week of the month. -1 indicates the last week of the month.
  """

  class DayOfWeekValueValuesEnum(_messages.Enum):
    r"""Required. A day of the week.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  dayOfWeek = _messages.EnumField('DayOfWeekValueValuesEnum', 1)
  weekOrdinal = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class WeeklySchedule(_messages.Message):
  r"""Represents a weekly schedule.

  Enums:
    DayOfWeekValueValuesEnum: Required. Day of the week.

  Fields:
    dayOfWeek: Required. Day of the week.
  """

  class DayOfWeekValueValuesEnum(_messages.Enum):
    r"""Required. Day of the week.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  dayOfWeek = _messages.EnumField('DayOfWeekValueValuesEnum', 1)


class WindowsUpdateSettings(_messages.Message):
  r"""Windows patching is performed using the Windows Update Agent.

  Enums:
    ClassificationsValueListEntryValuesEnum:

  Fields:
    classifications: Only apply updates of these windows update
      classifications. If empty, all updates will be applied.
    excludes: Optional. List of KBs to exclude from update.
    exclusivePatches: An exclusive list of kbs to be updated. These are the
      only patches that will be updated. This field must not be used with
      other patch configurations.
  """

  class ClassificationsValueListEntryValuesEnum(_messages.Enum):
    r"""ClassificationsValueListEntryValuesEnum enum type.

    Values:
      CLASSIFICATION_UNSPECIFIED: Invalid. If classifications are included,
        they must be specified.
      CRITICAL: "A widely released fix for a specific problem that addresses a
        critical, non-security-related bug." [1]
      SECURITY: "A widely released fix for a product-specific, security-
        related vulnerability. Security vulnerabilities are rated by their
        severity. The severity rating is indicated in the Microsoft security
        bulletin as critical, important, moderate, or low." [1]
      DEFINITION: "A widely released and frequent software update that
        contains additions to a product's definition database. Definition
        databases are often used to detect objects that have specific
        attributes, such as malicious code, phishing websites, or junk mail."
        [1]
      DRIVER: "Software that controls the input and output of a device." [1]
      FEATURE_PACK: "New product functionality that is first distributed
        outside the context of a product release and that is typically
        included in the next full product release." [1]
      SERVICE_PACK: "A tested, cumulative set of all hotfixes, security
        updates, critical updates, and updates. Additionally, service packs
        may contain additional fixes for problems that are found internally
        since the release of the product. Service packs my also contain a
        limited number of customer-requested design changes or features." [1]
      TOOL: "A utility or feature that helps complete a task or set of tasks."
        [1]
      UPDATE_ROLLUP: "A tested, cumulative set of hotfixes, security updates,
        critical updates, and updates that are packaged together for easy
        deployment. A rollup generally targets a specific area, such as
        security, or a component of a product, such as Internet Information
        Services (IIS)." [1]
      UPDATE: "A widely released fix for a specific problem. An update
        addresses a noncritical, non-security-related bug." [1]
    """
    CLASSIFICATION_UNSPECIFIED = 0
    CRITICAL = 1
    SECURITY = 2
    DEFINITION = 3
    DRIVER = 4
    FEATURE_PACK = 5
    SERVICE_PACK = 6
    TOOL = 7
    UPDATE_ROLLUP = 8
    UPDATE = 9

  classifications = _messages.EnumField('ClassificationsValueListEntryValuesEnum', 1, repeated=True)
  excludes = _messages.StringField(2, repeated=True)
  exclusivePatches = _messages.StringField(3, repeated=True)


class YumRepository(_messages.Message):
  r"""Represents a single yum package repository. These will be added to a
  repo file that will be managed at /etc/yum.repos.d/google_osconfig.repo.

  Fields:
    baseUrl: Required. The location of the repository directory.
    displayName: Optional.
    gpgKeys: Optional. URIs of GPG keys.
    id: Required. A one word, unique name for this repository. This will be
      the `repo id` in the yum config file and also the `display_name` if
      `display_name` is omitted. This id is also used as the unique identifier
      when checking for GuestPolicy conflicts.
  """

  baseUrl = _messages.StringField(1)
  displayName = _messages.StringField(2)
  gpgKeys = _messages.StringField(3, repeated=True)
  id = _messages.StringField(4)


class YumSettings(_messages.Message):
  r"""Yum patching will be performed by executing `yum update`. Additional
  options can be set to control how this is executed. Note that not all
  settings are supported on all platforms.

  Fields:
    excludes: List of packages to exclude from update. These packages will be
      excluded by using the yum `--exclude` field.
    exclusivePackages: An exclusive list of packages to be updated. These are
      the only packages that will be updated. If these packages are not
      installed, they will be ignored. This field must not be specified with
      any other patch configuration fields.
    minimal: Optional. Will cause patch to run `yum update-minimal` instead.
    security: Optional. Adds the `--security` flag to `yum update`. Not
      supported on all platforms.
  """

  excludes = _messages.StringField(1, repeated=True)
  exclusivePackages = _messages.StringField(2, repeated=True)
  minimal = _messages.BooleanField(3)
  security = _messages.BooleanField(4)


class ZypperRepository(_messages.Message):
  r"""Represents a single zypper package repository. These will be added to a
  repo file that will be managed at /etc/zypp/repos.d/google_osconfig.repo.

  Fields:
    baseUrl: Required. The location of the repository directory.
    displayName: Optional.
    gpgKeys: Optional. URIs of GPG keys.
    id: Required. A one word, unique name for this repository. This will be
      the `repo id` in the zypper config file and also the `display_name` if
      `display_name` is omitted. This id is also used as the unique identifier
      when checking for GuestPolicy conflicts.
  """

  baseUrl = _messages.StringField(1)
  displayName = _messages.StringField(2)
  gpgKeys = _messages.StringField(3, repeated=True)
  id = _messages.StringField(4)


class ZypperSettings(_messages.Message):
  r"""Zypper patching is performed by running `zypper patch`. See also
  https://en.opensuse.org/SDB:Zypper_manual.

  Fields:
    categories: Optional. Install only patches with these categories. Common
      categories include security, recommended, and feature.
    excludes: List of patches to exclude from update.
    exclusivePatches: An exclusive list of patches to be updated. These are
      the only patches that will be installed using 'zypper patch patch:'
      command. This field must not be used with any other patch configuration
      fields.
    severities: Optional. Install only patches with these severities. Common
      severities include critical, important, moderate, and low.
    withOptional: Optional. Adds the `--with-optional` flag to `zypper patch`.
    withUpdate: Optional. Adds the `--with-update` flag, to `zypper patch`.
  """

  categories = _messages.StringField(1, repeated=True)
  excludes = _messages.StringField(2, repeated=True)
  exclusivePatches = _messages.StringField(3, repeated=True)
  severities = _messages.StringField(4, repeated=True)
  withOptional = _messages.BooleanField(5)
  withUpdate = _messages.BooleanField(6)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
