# -*- coding: utf-8 -*- #
"""Cloud SDK static completion CLI tree."""
# pylint: disable=line-too-long,bad-continuation
STATIC_COMPLETION_CLI_TREE = {
  "commands": {
    "access-approval": {
      "commands": {
        "requests": {
          "commands": {
            "approve": {
              "commands": {},
              "flags": {}
            },
            "dismiss": {
              "commands": {},
              "flags": {}
            },
            "get": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--folder": "value",
                "--limit": "value",
                "--organization": "value",
                "--page-size": "value",
                "--sort-by": "value",
                "--state": "value"
              }
            }
          },
          "flags": {}
        },
        "settings": {
          "commands": {
            "delete": {
              "commands": {},
              "flags": {
                "--folder": "value",
                "--organization": "value"
              }
            },
            "get": {
              "commands": {},
              "flags": {
                "--folder": "value",
                "--organization": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--enrolled_services": "value",
                "--folder": "value",
                "--notification_emails": "value",
                "--organization": "value"
              }
            }
          },
          "flags": {}
        }
      },
      "flags": {}
    },
    "access-context-manager": {
      "commands": {
        "cloud-bindings": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--group-key": "value",
                "--level": "value",
                "--organization": "value",
                "--policy": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--binding": "value",
                "--organization": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--binding": "value",
                "--organization": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--organization": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--binding": "value",
                "--level": "value",
                "--organization": "value",
                "--policy": "value"
              }
            }
          },
          "flags": {}
        },
        "levels": {
          "commands": {
            "conditions": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--level": "value",
                    "--policy": "value"
                  }
                }
              },
              "flags": {}
            },
            "create": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--basic-level-spec": "value",
                "--combine-function": [
                  "and",
                  "or"
                ],
                "--custom-level-spec": "value",
                "--description": "value",
                "--policy": "value",
                "--title": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--policy": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--policy": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--policy": "value",
                "--sort-by": "value"
              }
            },
            "replace-all": {
              "commands": {},
              "flags": {
                "--etag": "value",
                "--source-file": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--basic-level-spec": "value",
                "--combine-function": [
                  "and",
                  "or"
                ],
                "--custom-level-spec": "value",
                "--description": "value",
                "--policy": "value",
                "--title": "value"
              }
            }
          },
          "flags": {}
        },
        "perimeters": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--access-levels": "value",
                "--async": "bool",
                "--description": "value",
                "--egress-policies": "value",
                "--enable-vpc-accessible-services": "bool",
                "--ingress-policies": "value",
                "--perimeter-type": [
                  "bridge",
                  "regular"
                ],
                "--policy": "value",
                "--resources": "value",
                "--restricted-services": "value",
                "--title": "value",
                "--vpc-allowed-services": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--policy": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--policy": "value"
              }
            },
            "dry-run": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--access-levels": "value",
                    "--async": "bool",
                    "--egress-policies": "value",
                    "--enable-vpc-accessible-services": "bool",
                    "--ingress-policies": "value",
                    "--perimeter-access-levels": "value",
                    "--perimeter-description": "value",
                    "--perimeter-egress-policies": "value",
                    "--perimeter-enable-vpc-accessible-services": "bool",
                    "--perimeter-ingress-policies": "value",
                    "--perimeter-resources": "value",
                    "--perimeter-restricted-services": "value",
                    "--perimeter-title": "value",
                    "--perimeter-type": "value",
                    "--perimeter-vpc-allowed-services": "value",
                    "--policy": "value",
                    "--resources": "value",
                    "--restricted-services": "value",
                    "--vpc-allowed-services": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--policy": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--policy": "value"
                  }
                },
                "drop": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--policy": "value"
                  }
                },
                "enforce": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--policy": "value"
                  }
                },
                "enforce-all": {
                  "commands": {},
                  "flags": {
                    "--etag": "value",
                    "--policy": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--policy": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-access-levels": "value",
                    "--add-resources": "value",
                    "--add-restricted-services": "value",
                    "--add-vpc-allowed-services": "value",
                    "--async": "bool",
                    "--clear-access-levels": "bool",
                    "--clear-egress-policies": "bool",
                    "--clear-ingress-policies": "bool",
                    "--clear-resources": "bool",
                    "--clear-restricted-services": "bool",
                    "--clear-vpc-allowed-services": "bool",
                    "--enable-vpc-accessible-services": "bool",
                    "--policy": "value",
                    "--remove-access-levels": "value",
                    "--remove-resources": "value",
                    "--remove-restricted-services": "value",
                    "--remove-vpc-allowed-services": "value",
                    "--set-egress-policies": "value",
                    "--set-ingress-policies": "value"
                  }
                }
              },
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--policy": "value",
                "--sort-by": "value"
              }
            },
            "replace-all": {
              "commands": {},
              "flags": {
                "--etag": "value",
                "--source-file": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--add-access-levels": "value",
                "--add-resources": "value",
                "--add-restricted-services": "value",
                "--add-vpc-allowed-services": "value",
                "--clear-access-levels": "bool",
                "--clear-egress-policies": "bool",
                "--clear-ingress-policies": "bool",
                "--clear-resources": "bool",
                "--clear-restricted-services": "bool",
                "--clear-vpc-allowed-services": "bool",
                "--description": "value",
                "--enable-vpc-accessible-services": "bool",
                "--policy": "value",
                "--remove-access-levels": "value",
                "--remove-resources": "value",
                "--remove-restricted-services": "value",
                "--remove-vpc-allowed-services": "value",
                "--set-access-levels": "value",
                "--set-egress-policies": "value",
                "--set-ingress-policies": "value",
                "--set-resources": "value",
                "--set-restricted-services": "value",
                "--title": "value",
                "--type": [
                  "bridge",
                  "regular"
                ]
              }
            }
          },
          "flags": {}
        },
        "policies": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--organization": "value",
                "--title": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--organization": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--title": "value"
              }
            }
          },
          "flags": {}
        }
      },
      "flags": {}
    },
    "active-directory": {
      "commands": {
        "domains": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--admin-name": "value",
                "--async": "bool",
                "--authorized-networks": "value",
                "--enable-audit-logs": "bool",
                "--labels": "value",
                "--region": "value",
                "--reserved-ip-range": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--async": "bool"
              }
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "describe-ldaps-settings": {
              "commands": {},
              "flags": {}
            },
            "get-iam-policy": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "reset-admin-password": {
              "commands": {},
              "flags": {}
            },
            "set-iam-policy": {
              "commands": {},
              "flags": {}
            },
            "trusts": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--direction": [
                      "bidirectional",
                      "inbound",
                      "outbound",
                      "trust-direction-unspecified"
                    ],
                    "--handshake-secret": "value",
                    "--selective-authentication": "bool",
                    "--target-dns-ip-addresses": "value",
                    "--target-domain-name": "value",
                    "--type": [
                      "external",
                      "forest",
                      "trust-type-unspecified"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--target-domain-name": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--target-dns-ip-addresses": "value",
                    "--target-domain-name": "value"
                  }
                },
                "validate-state": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--target-domain-name": "value"
                  }
                }
              },
              "flags": {}
            },
            "update": {
              "commands": {},
              "flags": {
                "--add-authorized-networks": "value",
                "--add-region": "value",
                "--async": "bool",
                "--clear-labels": "bool",
                "--enable-audit-logs": "bool",
                "--remove-authorized-networks": "value",
                "--remove-labels": "value",
                "--remove-region": "value",
                "--update-labels": "value"
              }
            },
            "update-ldaps-settings": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--certificate-password": "value",
                "--certificate-pfx-file": "value",
                "--clear-certificates": "bool"
              }
            }
          },
          "flags": {}
        },
        "operations": {
          "commands": {
            "cancel": {
              "commands": {},
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            }
          },
          "flags": {}
        }
      },
      "flags": {}
    },
    "ai": {
      "commands": {
        "custom-jobs": {
          "commands": {
            "cancel": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "create": {
              "commands": {},
              "flags": {
                "--args": "value",
                "--command": "value",
                "--config": "value",
                "--display-name": "value",
                "--kms-key": "dynamic",
                "--kms-keyring": "dynamic",
                "--kms-location": "dynamic",
                "--kms-project": "dynamic",
                "--network": "value",
                "--python-package-uris": "value",
                "--region": "value",
                "--service-account": "value",
                "--worker-pool-spec": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "stream-logs": {
              "commands": {},
              "flags": {
                "--allow-multiline-logs": "bool",
                "--polling-interval": "value",
                "--region": "dynamic",
                "--task-name": "value"
              }
            }
          },
          "flags": {}
        },
        "endpoints": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--description": "value",
                "--display-name": "value",
                "--labels": "value",
                "--region": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "deploy-model": {
              "commands": {},
              "flags": {
                "--accelerator": "value",
                "--disable-container-logging": "bool",
                "--display-name": "value",
                "--enable-access-logging": "bool",
                "--machine-type": "value",
                "--max-replica-count": "value",
                "--min-replica-count": "value",
                "--model": "value",
                "--region": "dynamic",
                "--service-account": "value",
                "--traffic-split": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "explain": {
              "commands": {},
              "flags": {
                "--deployed-model-id": "value",
                "--json-request": "value",
                "--region": "dynamic"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "predict": {
              "commands": {},
              "flags": {
                "--json-request": "value",
                "--region": "dynamic"
              }
            },
            "undeploy-model": {
              "commands": {},
              "flags": {
                "--deployed-model-id": "value",
                "--region": "dynamic",
                "--traffic-split": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--clear-labels": "bool",
                "--clear-traffic-split": "bool",
                "--description": "value",
                "--display-name": "value",
                "--region": "dynamic",
                "--remove-labels": "value",
                "--traffic-split": "value",
                "--update-labels": "value"
              }
            }
          },
          "flags": {}
        },
        "hp-tuning-jobs": {
          "commands": {
            "cancel": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "create": {
              "commands": {},
              "flags": {
                "--algorithm": [
                  "algorithm-unspecified",
                  "grid-search",
                  "random-search"
                ],
                "--config": "value",
                "--display-name": "value",
                "--kms-key": "dynamic",
                "--kms-keyring": "dynamic",
                "--kms-location": "dynamic",
                "--kms-project": "dynamic",
                "--max-trial-count": "value",
                "--network": "value",
                "--parallel-trial-count": "value",
                "--region": "value",
                "--service-account": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "stream-logs": {
              "commands": {},
              "flags": {
                "--allow-multiline-logs": "bool",
                "--polling-interval": "value",
                "--region": "dynamic",
                "--task-name": "value"
              }
            }
          },
          "flags": {}
        },
        "models": {
          "commands": {
            "delete": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "upload": {
              "commands": {},
              "flags": {
                "--artifact-uri": "value",
                "--container-args": "value",
                "--container-command": "value",
                "--container-env-vars": "value",
                "--container-health-route": "value",
                "--container-image-uri": "value",
                "--container-ports": "value",
                "--container-predict-route": "value",
                "--description": "value",
                "--display-name": "value",
                "--explanation-metadata-file": "value",
                "--explanation-method": "value",
                "--explanation-path-count": "value",
                "--explanation-step-count": "value",
                "--region": "value",
                "--smooth-grad-noise-sigma": "value",
                "--smooth-grad-noise-sigma-by-feature": "value",
                "--smooth-grad-noisy-sample-count": "value"
              }
            }
          },
          "flags": {}
        }
      },
      "flags": {}
    },
    "ai-platform": {
      "commands": {
        "jobs": {
          "commands": {
            "cancel": {
              "commands": {},
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {
                "--summarize": "bool"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "stream-logs": {
              "commands": {},
              "flags": {
                "--allow-multiline-logs": "bool",
                "--polling-interval": "value",
                "--task-name": "value"
              }
            },
            "submit": {
              "commands": {
                "prediction": {
                  "commands": {},
                  "flags": {
                    "--batch-size": "value",
                    "--data-format": [
                      "text",
                      "tf-record",
                      "tf-record-gzip"
                    ],
                    "--input-paths": "value",
                    "--labels": "value",
                    "--max-worker-count": "value",
                    "--model": "value",
                    "--model-dir": "value",
                    "--output-path": "value",
                    "--region": "value",
                    "--runtime-version": "value",
                    "--signature-name": "value"
                  }
                },
                "training": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--config": "value",
                    "--job-dir": "value",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--master-accelerator": "value",
                    "--master-image-uri": "value",
                    "--master-machine-type": "value",
                    "--module-name": "value",
                    "--package-path": "value",
                    "--packages": "value",
                    "--parameter-server-accelerator": "value",
                    "--parameter-server-count": "value",
                    "--parameter-server-image-uri": "value",
                    "--parameter-server-machine-type": "value",
                    "--python-version": "value",
                    "--region": "dynamic",
                    "--runtime-version": "value",
                    "--scale-tier": [
                      "basic",
                      "basic-gpu",
                      "basic-tpu",
                      "custom",
                      "premium-1",
                      "standard-1"
                    ],
                    "--service-account": "value",
                    "--staging-bucket": "value",
                    "--stream-logs": "bool",
                    "--use-chief-in-tf-config": "value",
                    "--worker-accelerator": "value",
                    "--worker-count": "value",
                    "--worker-image-uri": "value",
                    "--worker-machine-type": "value"
                  }
                }
              },
              "flags": {}
            },
            "update": {
              "commands": {},
              "flags": {
                "--clear-labels": "bool",
                "--remove-labels": "value",
                "--update-labels": "value"
              }
            }
          },
          "flags": {}
        },
        "local": {
          "commands": {
            "predict": {
              "commands": {},
              "flags": {
                "--framework": [
                  "scikit-learn",
                  "tensorflow",
                  "xgboost"
                ],
                "--json-instances": "value",
                "--json-request": "value",
                "--model-dir": "value",
                "--signature-name": "value",
                "--text-instances": "value"
              }
            },
            "train": {
              "commands": {},
              "flags": {
                "--distributed": "bool",
                "--evaluator-count": "value",
                "--job-dir": "value",
                "--module-name": "value",
                "--package-path": "value",
                "--parameter-server-count": "value",
                "--start-port": "value",
                "--worker-count": "value"
              }
            }
          },
          "flags": {}
        },
        "models": {
          "commands": {
            "add-iam-policy-binding": {
              "commands": {},
              "flags": {
                "--member": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--role": "dynamic"
              }
            },
            "create": {
              "commands": {},
              "flags": {
                "--description": "value",
                "--enable-logging": "bool",
                "--labels": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--regions": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            },
            "get-iam-policy": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--sort-by": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "remove-iam-policy-binding": {
              "commands": {},
              "flags": {
                "--member": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--role": "value"
              }
            },
            "set-iam-policy": {
              "commands": {},
              "flags": {
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--clear-labels": "bool",
                "--description": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--remove-labels": "value",
                "--update-labels": "value"
              }
            }
          },
          "flags": {}
        },
        "operations": {
          "commands": {
            "cancel": {
              "commands": {},
              "flags": {
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "wait": {
              "commands": {},
              "flags": {
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            }
          },
          "flags": {}
        },
        "predict": {
          "commands": {},
          "flags": {
            "--json-instances": "value",
            "--json-request": "value",
            "--model": "value",
            "--region": [
              "asia-east1",
              "asia-northeast1",
              "asia-southeast1",
              "australia-southeast1",
              "europe-west1",
              "europe-west2",
              "europe-west3",
              "europe-west4",
              "global",
              "northamerica-northeast1",
              "us-central1",
              "us-east1",
              "us-east4",
              "us-west1"
            ],
            "--signature-name": "value",
            "--text-instances": "value"
          }
        },
        "versions": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--accelerator": "value",
                "--async": "bool",
                "--config": "value",
                "--description": "value",
                "--framework": [
                  "scikit-learn",
                  "tensorflow",
                  "xgboost"
                ],
                "--labels": "value",
                "--machine-type": "value",
                "--max-nodes": "value",
                "--metric-targets": "value",
                "--min-nodes": "value",
                "--model": "value",
                "--origin": "value",
                "--python-version": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--runtime-version": "value",
                "--staging-bucket": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--model": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--model": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--model": "value",
                "--page-size": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "set-default": {
              "commands": {},
              "flags": {
                "--model": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--clear-labels": "bool",
                "--config": "value",
                "--description": "value",
                "--model": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--remove-labels": "value",
                "--update-labels": "value"
              }
            }
          },
          "flags": {}
        }
      },
      "flags": {}
    },
    "alpha": {
      "commands": {
        "access-approval": {
          "commands": {
            "requests": {
              "commands": {
                "approve": {
                  "commands": {},
                  "flags": {}
                },
                "dismiss": {
                  "commands": {},
                  "flags": {}
                },
                "get": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--folder": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--state": "value"
                  }
                }
              },
              "flags": {}
            },
            "settings": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "get": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--enrolled_services": "value",
                    "--folder": "value",
                    "--notification_emails": "value",
                    "--organization": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "access-context-manager": {
          "commands": {
            "cloud-bindings": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--group-key": "value",
                    "--level": "value",
                    "--organization": "value",
                    "--policy": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--binding": "value",
                    "--organization": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--binding": "value",
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--binding": "value",
                    "--level": "value",
                    "--organization": "value",
                    "--policy": "value"
                  }
                }
              },
              "flags": {}
            },
            "levels": {
              "commands": {
                "conditions": {
                  "commands": {
                    "list": {
                      "commands": {},
                      "flags": {
                        "--level": "value",
                        "--policy": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--basic-level-spec": "value",
                    "--combine-function": [
                      "and",
                      "or"
                    ],
                    "--custom-level-spec": "value",
                    "--description": "value",
                    "--policy": "value",
                    "--title": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--policy": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--policy": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--policy": "value",
                    "--sort-by": "value"
                  }
                },
                "replace-all": {
                  "commands": {},
                  "flags": {
                    "--etag": "value",
                    "--source-file": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--basic-level-spec": "value",
                    "--combine-function": [
                      "and",
                      "or"
                    ],
                    "--custom-level-spec": "value",
                    "--description": "value",
                    "--policy": "value",
                    "--title": "value"
                  }
                }
              },
              "flags": {}
            },
            "perimeters": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--access-levels": "value",
                    "--async": "bool",
                    "--description": "value",
                    "--egress-policies": "value",
                    "--enable-vpc-accessible-services": "bool",
                    "--ingress-policies": "value",
                    "--perimeter-type": [
                      "bridge",
                      "regular"
                    ],
                    "--policy": "value",
                    "--resources": "value",
                    "--restricted-services": "value",
                    "--title": "value",
                    "--vpc-allowed-services": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--policy": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--policy": "value"
                  }
                },
                "dry-run": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--access-levels": "value",
                        "--async": "bool",
                        "--egress-policies": "value",
                        "--enable-vpc-accessible-services": "bool",
                        "--ingress-policies": "value",
                        "--perimeter-access-levels": "value",
                        "--perimeter-description": "value",
                        "--perimeter-egress-policies": "value",
                        "--perimeter-enable-vpc-accessible-services": "bool",
                        "--perimeter-ingress-policies": "value",
                        "--perimeter-resources": "value",
                        "--perimeter-restricted-services": "value",
                        "--perimeter-title": "value",
                        "--perimeter-type": "value",
                        "--perimeter-vpc-allowed-services": "value",
                        "--policy": "value",
                        "--resources": "value",
                        "--restricted-services": "value",
                        "--vpc-allowed-services": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--policy": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--policy": "value"
                      }
                    },
                    "drop": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--policy": "value"
                      }
                    },
                    "enforce": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--policy": "value"
                      }
                    },
                    "enforce-all": {
                      "commands": {},
                      "flags": {
                        "--etag": "value",
                        "--policy": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--policy": "value",
                        "--sort-by": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--add-access-levels": "value",
                        "--add-resources": "value",
                        "--add-restricted-services": "value",
                        "--add-vpc-allowed-services": "value",
                        "--async": "bool",
                        "--clear-access-levels": "bool",
                        "--clear-egress-policies": "bool",
                        "--clear-ingress-policies": "bool",
                        "--clear-resources": "bool",
                        "--clear-restricted-services": "bool",
                        "--clear-vpc-allowed-services": "bool",
                        "--enable-vpc-accessible-services": "bool",
                        "--policy": "value",
                        "--remove-access-levels": "value",
                        "--remove-resources": "value",
                        "--remove-restricted-services": "value",
                        "--remove-vpc-allowed-services": "value",
                        "--set-egress-policies": "value",
                        "--set-ingress-policies": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--policy": "value",
                    "--sort-by": "value"
                  }
                },
                "replace-all": {
                  "commands": {},
                  "flags": {
                    "--etag": "value",
                    "--source-file": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-access-levels": "value",
                    "--add-resources": "value",
                    "--add-restricted-services": "value",
                    "--add-vpc-allowed-services": "value",
                    "--clear-access-levels": "bool",
                    "--clear-egress-policies": "bool",
                    "--clear-ingress-policies": "bool",
                    "--clear-resources": "bool",
                    "--clear-restricted-services": "bool",
                    "--clear-vpc-allowed-services": "bool",
                    "--description": "value",
                    "--enable-vpc-accessible-services": "bool",
                    "--policy": "value",
                    "--remove-access-levels": "value",
                    "--remove-resources": "value",
                    "--remove-restricted-services": "value",
                    "--remove-vpc-allowed-services": "value",
                    "--set-access-levels": "value",
                    "--set-egress-policies": "value",
                    "--set-ingress-policies": "value",
                    "--set-resources": "value",
                    "--set-restricted-services": "value",
                    "--title": "value",
                    "--type": [
                      "bridge",
                      "regular"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "policies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--organization": "value",
                    "--title": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--title": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "active-directory": {
          "commands": {
            "domains": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--admin-name": "value",
                    "--async": "bool",
                    "--authorized-networks": "value",
                    "--enable-audit-logs": "bool",
                    "--labels": "value",
                    "--region": "value",
                    "--reserved-ip-range": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "describe-ldaps-settings": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "reset-admin-password": {
                  "commands": {},
                  "flags": {}
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "sql-integrations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--domain": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--domain": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "trusts": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--direction": [
                          "bidirectional",
                          "inbound",
                          "outbound",
                          "trust-direction-unspecified"
                        ],
                        "--handshake-secret": "value",
                        "--selective-authentication": "bool",
                        "--target-dns-ip-addresses": "value",
                        "--target-domain-name": "value",
                        "--type": [
                          "external",
                          "forest",
                          "trust-type-unspecified"
                        ]
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--target-domain-name": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--target-dns-ip-addresses": "value",
                        "--target-domain-name": "value"
                      }
                    },
                    "validate-state": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--target-domain-name": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-authorized-networks": "value",
                    "--add-region": "value",
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--enable-audit-logs": "bool",
                    "--remove-authorized-networks": "value",
                    "--remove-labels": "value",
                    "--remove-region": "value",
                    "--update-labels": "value"
                  }
                },
                "update-ldaps-settings": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--certificate-password": "value",
                    "--certificate-pfx-file": "value",
                    "--clear-certificates": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "peerings": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--authorized-network": "value",
                    "--domain": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "ai": {
          "commands": {
            "custom-jobs": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--args": "value",
                    "--command": "value",
                    "--config": "value",
                    "--display-name": "value",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--network": "value",
                    "--python-package-uris": "value",
                    "--region": "value",
                    "--service-account": "value",
                    "--worker-pool-spec": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "local-run": {
                  "commands": {},
                  "flags": {
                    "--base-image": "value",
                    "--extra-dirs": "value",
                    "--extra-packages": "value",
                    "--gpu": "bool",
                    "--output-image-uri": "value",
                    "--python-module": "value",
                    "--requirements": "value",
                    "--script": "value",
                    "--service-account-key-file": "value",
                    "--work-dir": "value"
                  }
                },
                "stream-logs": {
                  "commands": {},
                  "flags": {
                    "--allow-multiline-logs": "bool",
                    "--polling-interval": "value",
                    "--region": "dynamic",
                    "--task-name": "value"
                  }
                }
              },
              "flags": {}
            },
            "endpoints": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--labels": "value",
                    "--network": "value",
                    "--region": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "deploy-model": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--autoscaling-metric-specs": "value",
                    "--display-name": "value",
                    "--enable-access-logging": "bool",
                    "--enable-container-logging": "bool",
                    "--machine-type": "value",
                    "--max-replica-count": "value",
                    "--min-replica-count": "value",
                    "--model": "value",
                    "--region": "dynamic",
                    "--service-account": "value",
                    "--traffic-split": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "explain": {
                  "commands": {},
                  "flags": {
                    "--deployed-model-id": "value",
                    "--json-request": "value",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "predict": {
                  "commands": {},
                  "flags": {
                    "--json-request": "value",
                    "--region": "dynamic"
                  }
                },
                "undeploy-model": {
                  "commands": {},
                  "flags": {
                    "--deployed-model-id": "value",
                    "--region": "dynamic",
                    "--traffic-split": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--clear-traffic-split": "bool",
                    "--description": "value",
                    "--display-name": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--traffic-split": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "hp-tuning-jobs": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--algorithm": [
                      "algorithm-unspecified",
                      "grid-search",
                      "random-search"
                    ],
                    "--config": "value",
                    "--display-name": "value",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--max-trial-count": "value",
                    "--network": "value",
                    "--parallel-trial-count": "value",
                    "--region": "value",
                    "--service-account": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "stream-logs": {
                  "commands": {},
                  "flags": {
                    "--allow-multiline-logs": "bool",
                    "--polling-interval": "value",
                    "--region": "dynamic",
                    "--task-name": "value"
                  }
                }
              },
              "flags": {}
            },
            "index-endpoints": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--labels": "value",
                    "--network": "value",
                    "--region": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "deploy-index": {
                  "commands": {},
                  "flags": {
                    "--deployed-index-id": "value",
                    "--display-name": "value",
                    "--index": "value",
                    "--max-replica-count": "value",
                    "--min-replica-count": "value",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "undeploy-index": {
                  "commands": {},
                  "flags": {
                    "--deployed-index-id": "value",
                    "--region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--display-name": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "indexes": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--labels": "value",
                    "--metadata-file": "value",
                    "--metadata-schema-uri": "value",
                    "--region": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--display-name": "value",
                    "--metadata-file": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "model-monitoring-jobs": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--analysis-instance-schema": "value",
                    "--bigquery-uri": "value",
                    "--data-format": "value",
                    "--dataset": "value",
                    "--display-name": "value",
                    "--emails": "value",
                    "--endpoint": "value",
                    "--feature-attribution-thresholds": "value",
                    "--feature-thresholds": "value",
                    "--gcs-uris": "value",
                    "--labels": "value",
                    "--log-ttl": "value",
                    "--monitoring-config-from-file": "value",
                    "--monitoring-frequency": "value",
                    "--predict-instance-schema": "value",
                    "--prediction-sampling-rate": "value",
                    "--region": "value",
                    "--sample-predict-request": "value",
                    "--target-field": "value",
                    "--training-sampling-rate": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "pause": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "resume": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--display-name": "value",
                    "--emails": "value",
                    "--feature-attribution-thresholds": "value",
                    "--feature-thresholds": "value",
                    "--log-ttl": "value",
                    "--monitoring-config-from-file": "value",
                    "--monitoring-frequency": "value",
                    "--prediction-sampling-rate": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "models": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "upload": {
                  "commands": {},
                  "flags": {
                    "--artifact-uri": "value",
                    "--container-args": "value",
                    "--container-command": "value",
                    "--container-env-vars": "value",
                    "--container-health-route": "value",
                    "--container-image-uri": "value",
                    "--container-ports": "value",
                    "--container-predict-route": "value",
                    "--description": "value",
                    "--display-name": "value",
                    "--explanation-metadata-file": "value",
                    "--explanation-method": "value",
                    "--explanation-path-count": "value",
                    "--explanation-step-count": "value",
                    "--region": "value",
                    "--smooth-grad-noise-sigma": "value",
                    "--smooth-grad-noise-sigma-by-feature": "value",
                    "--smooth-grad-noisy-sample-count": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--index": "value",
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "tensorboard-experiments": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--labels": "value",
                    "--region": "dynamic",
                    "--tensorboard-experiment-id": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--tensorboard-id": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--tensorboard-id": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--display-name": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--tensorboard-id": "dynamic",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "tensorboard-runs": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--labels": "value",
                    "--region": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--tensorboard-run-id": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--display-name": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "tensorboard-time-series": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--plugin-data": "value",
                    "--plugin-name": "value",
                    "--region": "dynamic",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--type": [
                      "blob-sequence",
                      "scalar",
                      "tensor"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--tensorboard-run-id": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--tensorboard-run-id": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--tensorboard-run-id": "dynamic",
                    "--uri": "bool"
                  }
                },
                "read": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--max-data-points": "value",
                    "--region": "dynamic",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--tensorboard-run-id": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--plugin-data": "value",
                    "--plugin-name": "value",
                    "--region": "dynamic",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--tensorboard-run-id": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "tensorboards": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--labels": "value",
                    "--region": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--display-name": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "ai-platform": {
          "commands": {
            "explain": {
              "commands": {},
              "flags": {
                "--json-instances": "value",
                "--json-request": "value",
                "--model": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--text-instances": "value"
              }
            },
            "jobs": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--summarize": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "stream-logs": {
                  "commands": {},
                  "flags": {
                    "--allow-multiline-logs": "bool",
                    "--polling-interval": "value",
                    "--task-name": "value"
                  }
                },
                "submit": {
                  "commands": {
                    "prediction": {
                      "commands": {},
                      "flags": {
                        "--accelerator-count": "value",
                        "--accelerator-type": [
                          "nvidia-tesla-k80",
                          "nvidia-tesla-p100"
                        ],
                        "--batch-size": "value",
                        "--data-format": [
                          "text",
                          "tf-record",
                          "tf-record-gzip"
                        ],
                        "--input-paths": "value",
                        "--labels": "value",
                        "--max-worker-count": "value",
                        "--model": "value",
                        "--model-dir": "value",
                        "--output-path": "value",
                        "--region": "value",
                        "--runtime-version": "value",
                        "--signature-name": "value"
                      }
                    },
                    "training": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--config": "value",
                        "--job-dir": "value",
                        "--kms-key": "dynamic",
                        "--kms-keyring": "dynamic",
                        "--kms-location": "dynamic",
                        "--kms-project": "dynamic",
                        "--labels": "value",
                        "--master-accelerator": "value",
                        "--master-image-uri": "value",
                        "--master-machine-type": "value",
                        "--module-name": "value",
                        "--network": "value",
                        "--package-path": "value",
                        "--packages": "value",
                        "--parameter-server-accelerator": "value",
                        "--parameter-server-count": "value",
                        "--parameter-server-image-uri": "value",
                        "--parameter-server-machine-type": "value",
                        "--python-version": "value",
                        "--region": "dynamic",
                        "--runtime-version": "value",
                        "--scale-tier": [
                          "basic",
                          "basic-gpu",
                          "basic-tpu",
                          "custom",
                          "premium-1",
                          "standard-1"
                        ],
                        "--service-account": "value",
                        "--staging-bucket": "value",
                        "--stream-logs": "bool",
                        "--tpu-tf-version": "value",
                        "--use-chief-in-tf-config": "value",
                        "--worker-accelerator": "value",
                        "--worker-count": "value",
                        "--worker-image-uri": "value",
                        "--worker-machine-type": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "local": {
              "commands": {
                "predict": {
                  "commands": {},
                  "flags": {
                    "--framework": [
                      "scikit-learn",
                      "tensorflow",
                      "xgboost"
                    ],
                    "--json-instances": "value",
                    "--json-request": "value",
                    "--model-dir": "value",
                    "--signature-name": "value",
                    "--text-instances": "value"
                  }
                },
                "train": {
                  "commands": {},
                  "flags": {
                    "--distributed": "bool",
                    "--evaluator-count": "value",
                    "--job-dir": "value",
                    "--module-name": "value",
                    "--package-path": "value",
                    "--parameter-server-count": "value",
                    "--start-port": "value",
                    "--worker-count": "value"
                  }
                }
              },
              "flags": {}
            },
            "locations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "models": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--enable-console-logging": "bool",
                    "--enable-logging": "bool",
                    "--labels": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--regions": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--role": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "predict": {
              "commands": {},
              "flags": {
                "--json-instances": "value",
                "--json-request": "value",
                "--model": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--signature-name": "value",
                "--text-instances": "value"
              }
            },
            "versions": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--args": "value",
                    "--async": "bool",
                    "--command": "value",
                    "--config": "value",
                    "--description": "value",
                    "--env-vars": "value",
                    "--explanation-method": [
                      "integrated-gradients",
                      "sampled-shapley",
                      "xrai"
                    ],
                    "--framework": [
                      "scikit-learn",
                      "tensorflow",
                      "xgboost"
                    ],
                    "--health-route": "value",
                    "--image": "value",
                    "--labels": "value",
                    "--machine-type": "value",
                    "--max-nodes": "value",
                    "--metric-targets": "value",
                    "--min-nodes": "value",
                    "--model": "value",
                    "--num-integral-steps": "value",
                    "--num-paths": "value",
                    "--origin": "value",
                    "--package-uris": "value",
                    "--ports": "value",
                    "--predict-route": "value",
                    "--prediction-class": "value",
                    "--python-version": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--runtime-version": "value",
                    "--service-account": "value",
                    "--staging-bucket": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--model": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--model": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--model": "value",
                    "--page-size": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-default": {
                  "commands": {},
                  "flags": {
                    "--model": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--bigquery-table-name": "value",
                    "--clear-labels": "bool",
                    "--config": "value",
                    "--description": "value",
                    "--model": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--remove-labels": "value",
                    "--sampling-percentage": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "anthos": {
          "commands": {
            "apply": {
              "commands": {},
              "flags": {}
            },
            "auth": {
              "commands": {
                "login": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--dry-run": "bool",
                    "--kubeconfig": "value",
                    "--login-config": "value",
                    "--login-config-cert": "value",
                    "--set-preferred-auth": "bool",
                    "--user": "value"
                  }
                }
              },
              "flags": {}
            },
            "config": {
              "commands": {
                "controller": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--cluster-ipv4-cidr-block": "value",
                        "--cluster-named-range": "value",
                        "--location": "dynamic",
                        "--man-block": "value",
                        "--master-ipv4-cidr-block": "value",
                        "--network": "value",
                        "--services-ipv4-cidr-block": "value",
                        "--services-named-range": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "dynamic"
                      }
                    },
                    "get-credentials": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "operations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "create-login-config": {
              "commands": {},
              "flags": {
                "--kubeconfig": "value",
                "--merge-from": "value",
                "--output": "value"
              }
            },
            "export": {
              "commands": {},
              "flags": {
                "--location": "value",
                "--output-directory": "value"
              }
            }
          },
          "flags": {}
        },
        "api-gateway": {
          "commands": {
            "api-configs": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--async": "bool",
                    "--backend-auth-service-account": "value",
                    "--display-name": "value",
                    "--grpc-files": "value",
                    "--labels": "value",
                    "--openapi-spec": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--view": [
                      "BASIC",
                      "FULL"
                    ]
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--display-name": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "apis": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--display-name": "value",
                    "--labels": "value",
                    "--managed-service": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--display-name": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "gateways": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--api-config": "value",
                    "--async": "bool",
                    "--display-name": "value",
                    "--labels": "value",
                    "--location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--api-config": "value",
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--display-name": "value",
                    "--location": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "apigee": {
          "commands": {
            "apis": {
              "commands": {
                "deploy": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--environment": "value",
                    "--organization": "value",
                    "--override": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value",
                    "--revision": "value",
                    "--verbose": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "undeploy": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--environment": "value",
                    "--organization": "value"
                  }
                }
              },
              "flags": {}
            },
            "applications": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--developer": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "deployments": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--environment": "value",
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--environment": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--revision": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "developers": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "environments": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "organizations": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "provision": {
                  "commands": {},
                  "flags": {
                    "--analytics-region": "value",
                    "--async": "bool",
                    "--authorized-network": "value",
                    "--runtime-location": "value"
                  }
                }
              },
              "flags": {}
            },
            "products": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--all-environments": "bool",
                    "--all-proxies": "bool",
                    "--apis": "value",
                    "--attributes": "value",
                    "--description": "value",
                    "--display-name": "value",
                    "--environments": "value",
                    "--internal-access": "bool",
                    "--manual-approval": "bool",
                    "--oauth-scopes": "value",
                    "--organization": "value",
                    "--private-access": "bool",
                    "--public-access": "bool",
                    "--quota": "value",
                    "--quota-interval": "value",
                    "--quota-unit": [
                      "day",
                      "hour",
                      "minute",
                      "month"
                    ],
                    "--resources": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-api": "value",
                    "--add-attribute": "value",
                    "--add-environment": "value",
                    "--add-oauth-scope": "value",
                    "--add-resource": "value",
                    "--all-apis": "bool",
                    "--all-environments": "bool",
                    "--all-resources": "bool",
                    "--automatic-approval": "bool",
                    "--clear-attributes": "bool",
                    "--clear-description": "bool",
                    "--clear-oauth-scopes": "bool",
                    "--clear-quota": "bool",
                    "--description": "value",
                    "--display-name": "value",
                    "--internal-access": "bool",
                    "--manual-approval": "bool",
                    "--organization": "value",
                    "--private-access": "bool",
                    "--public-access": "bool",
                    "--quota": "value",
                    "--quota-interval": "value",
                    "--quota-unit": [
                      "day",
                      "hour",
                      "minute",
                      "month"
                    ],
                    "--remove-api": "value",
                    "--remove-attribute": "value",
                    "--remove-environment": "value",
                    "--remove-oauth-scope": "value",
                    "--remove-resource": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "app": {
          "commands": {
            "domain-mappings": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--certificate-id": "value",
                    "--certificate-management": [
                      "automatic",
                      "manual"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--certificate-id": "value",
                    "--certificate-management": [
                      "automatic",
                      "manual"
                    ],
                    "--no-certificate-id": "bool"
                  }
                }
              },
              "flags": {}
            },
            "ssl-certificates": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--certificate": "value",
                    "--display-name": "value",
                    "--private-key": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--certificate": "value",
                    "--display-name": "value",
                    "--private-key": "value"
                  }
                }
              },
              "flags": {}
            },
            "update": {
              "commands": {},
              "flags": {
                "--split-health-checks": "bool"
              }
            }
          },
          "flags": {}
        },
        "artifacts": {
          "commands": {
            "apt": {
              "commands": {
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--gcs-source": "value",
                    "--location": "value"
                  }
                },
                "upload": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--source": "value"
                  }
                }
              },
              "flags": {}
            },
            "docker": {
              "commands": {
                "images": {
                  "commands": {
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--delete-tags": "bool"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--metadata-filter": "value",
                        "--show-all-metadata": "bool",
                        "--show-build-details": "bool",
                        "--show-deployment": "bool",
                        "--show-image-basis": "bool",
                        "--show-package-vulnerability": "bool"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--include-tags": "bool",
                        "--limit": "value",
                        "--occurrence-filter": "value",
                        "--page-size": "value",
                        "--show-occurrences": "bool",
                        "--show-occurrences-from": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "tags": {
                  "commands": {
                    "add": {
                      "commands": {},
                      "flags": {}
                    },
                    "delete": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "locations": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            },
            "packages": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--repository": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--repository": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "print-settings": {
              "commands": {
                "apt": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--repository": "value"
                  }
                },
                "gradle": {
                  "commands": {},
                  "flags": {
                    "--json-key": "value",
                    "--location": "value",
                    "--repository": "value"
                  }
                },
                "mvn": {
                  "commands": {},
                  "flags": {
                    "--json-key": "value",
                    "--location": "value",
                    "--repository": "value"
                  }
                },
                "npm": {
                  "commands": {},
                  "flags": {
                    "--json-key": "value",
                    "--location": "value",
                    "--repository": "value",
                    "--scope": "value"
                  }
                },
                "python": {
                  "commands": {},
                  "flags": {
                    "--json-key": "value",
                    "--location": "value",
                    "--repository": "value"
                  }
                },
                "yum": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--repository": "value"
                  }
                }
              },
              "flags": {}
            },
            "repositories": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--kms-key": "value",
                    "--labels": "value",
                    "--location": "value",
                    "--repository-format": [
                      "apt",
                      "docker",
                      "googet",
                      "maven",
                      "npm",
                      "pypi",
                      "python",
                      "yum"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--location": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "tags": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--package": "value",
                    "--repository": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--package": "value",
                    "--repository": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--package": "value",
                    "--page-size": "value",
                    "--repository": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--package": "value",
                    "--repository": "value"
                  }
                }
              },
              "flags": {}
            },
            "versions": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--delete-tags": "bool",
                    "--location": "value",
                    "--package": "value",
                    "--repository": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--package": "value",
                    "--page-size": "value",
                    "--repository": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "yum": {
              "commands": {
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--gcs-source": "value",
                    "--location": "value"
                  }
                },
                "upload": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--source": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "asset": {
          "commands": {
            "export": {
              "commands": {},
              "flags": {
                "--asset-types": "value",
                "--bigquery-dataset": "dynamic",
                "--bigquery-table": "dynamic",
                "--content-type": [
                  "access-policy",
                  "iam-policy",
                  "org-policy",
                  "os-inventory",
                  "relationship",
                  "resource"
                ],
                "--folder": "value",
                "--organization": "value",
                "--output-bigquery-force": "bool",
                "--output-path": "value",
                "--output-path-prefix": "value",
                "--partition-key": [
                  "read-time",
                  "request-time"
                ],
                "--per-asset-type": "bool",
                "--relationship-types": "value",
                "--snapshot-time": "value"
              }
            },
            "feeds": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--asset-names": "value",
                    "--asset-types": "value",
                    "--condition-description": "value",
                    "--condition-expression": "value",
                    "--condition-title": "value",
                    "--content-type": [
                      "access-policy",
                      "iam-policy",
                      "org-policy",
                      "os-inventory",
                      "relationship",
                      "resource"
                    ],
                    "--folder": "value",
                    "--organization": "value",
                    "--pubsub-topic": "value",
                    "--relationship-types": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-asset-names": "value",
                    "--add-asset-types": "value",
                    "--add-relationship-types": "value",
                    "--clear-asset-names": "bool",
                    "--clear-asset-types": "bool",
                    "--clear-condition-description": "bool",
                    "--clear-condition-expression": "bool",
                    "--clear-condition-title": "bool",
                    "--clear-content-type": "bool",
                    "--clear-relationship-types": "bool",
                    "--condition-description": "value",
                    "--condition-expression": "value",
                    "--condition-title": "value",
                    "--content-type": [
                      "access-policy",
                      "iam-policy",
                      "org-policy",
                      "os-inventory",
                      "relationship",
                      "resource"
                    ],
                    "--folder": "value",
                    "--organization": "value",
                    "--pubsub-topic": "value",
                    "--remove-asset-names": "value",
                    "--remove-asset-types": "value",
                    "--remove-relationship-types": "value"
                  }
                }
              },
              "flags": {}
            },
            "get-history": {
              "commands": {},
              "flags": {
                "--asset-names": "value",
                "--content-type": [
                  "access-policy",
                  "iam-policy",
                  "org-policy",
                  "os-inventory",
                  "relationship",
                  "resource"
                ],
                "--end-time": "value",
                "--organization": "value",
                "--relationship-types": "value",
                "--start-time": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--asset-types": "value",
                "--content-type": [
                  "access-policy",
                  "iam-policy",
                  "org-policy",
                  "os-inventory",
                  "relationship",
                  "resource"
                ],
                "--filter": "value",
                "--folder": "value",
                "--limit": "value",
                "--organization": "value",
                "--page-size": "value",
                "--relationship-types": "value",
                "--snapshot-time": "value",
                "--sort-by": "value"
              }
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "assured": {
          "commands": {
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "workloads": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--compliance-regime": [
                      "CA_REGIONS_AND_SUPPORT",
                      "CJIS",
                      "EU_REGIONS_AND_SUPPORT",
                      "FEDRAMP_HIGH",
                      "FEDRAMP_MODERATE",
                      "HIPAA",
                      "HITRUST",
                      "IL4",
                      "US_REGIONAL_ACCESS"
                    ],
                    "--display-name": "value",
                    "--external-identifier": "value",
                    "--labels": "value",
                    "--location": "value",
                    "--next-rotation-time": "value",
                    "--organization": "value",
                    "--provisioned-resources-parent": "value",
                    "--resource-settings": "value",
                    "--rotation-period": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--etag": "value",
                    "--location": "value",
                    "--organization": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--display-name": "value",
                    "--etag": "value",
                    "--labels": "value",
                    "--location": "value",
                    "--organization": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "auth": {
          "commands": {
            "activate-service-account": {
              "commands": {},
              "flags": {
                "--key-file": "value",
                "--password-file": "value",
                "--prompt-for-password": "bool"
              }
            },
            "configure-docker": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--filter-account": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "login": {
              "commands": {},
              "flags": {
                "--activate": "bool",
                "--brief": "bool",
                "--enable-gdrive-access": "bool",
                "--force": "bool",
                "--launch-browser": "bool",
                "--update-adc": "bool"
              }
            },
            "print-access-token": {
              "commands": {},
              "flags": {}
            },
            "print-identity-token": {
              "commands": {},
              "flags": {
                "--audiences": "value",
                "--include-email": "bool",
                "--include-license": "bool",
                "--token-format": [
                  "full",
                  "standard"
                ]
              }
            },
            "revoke": {
              "commands": {},
              "flags": {
                "--all": "bool"
              }
            }
          },
          "flags": {}
        },
        "bigtable": {
          "commands": {
            "app-profiles": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--force": "bool",
                    "--instance": "dynamic",
                    "--route-any": "bool",
                    "--route-to": "dynamic",
                    "--transactional-writes": "bool"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--force": "bool",
                    "--instance": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--force": "bool",
                    "--instance": "dynamic",
                    "--route-any": "bool",
                    "--route-to": "dynamic",
                    "--transactional-writes": "bool"
                  }
                }
              },
              "flags": {}
            },
            "backups": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--cluster": "dynamic",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--instance": "dynamic",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster": "dynamic",
                    "--expiration-date": "value",
                    "--instance": "dynamic",
                    "--retention-period": "value",
                    "--table": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--cluster": "dynamic",
                    "--instance": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--cluster": "dynamic",
                    "--instance": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--cluster": "dynamic",
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--cluster": "dynamic",
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--cluster": "dynamic",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--instance": "dynamic",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--cluster": "dynamic",
                    "--instance": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--cluster": "dynamic",
                    "--expiration-date": "value",
                    "--instance": "dynamic",
                    "--retention-period": "value"
                  }
                }
              },
              "flags": {}
            },
            "clusters": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--instance": "dynamic",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--num-nodes": "value",
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instances": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--instance": "dynamic",
                    "--num-nodes": "value"
                  }
                }
              },
              "flags": {}
            },
            "hot-tablets": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--end-time": "value",
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--start-time": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "instances": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster": "dynamic",
                    "--cluster-config": "value",
                    "--cluster-num-nodes": "value",
                    "--cluster-storage-type": [
                      "hdd",
                      "ssd"
                    ],
                    "--cluster-zone": "value",
                    "--display-name": "value",
                    "--instance-type": [
                      "DEVELOPMENT",
                      "PRODUCTION"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "tables": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--instance": "dynamic",
                        "--member": "value",
                        "--role": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--instance": "dynamic",
                        "--view": [
                          "encryption",
                          "full",
                          "name",
                          "replication",
                          "schema"
                        ]
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--instance": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--instances": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--instance": "dynamic",
                        "--member": "value",
                        "--role": "dynamic"
                      }
                    },
                    "restore": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--destination": "dynamic",
                        "--destination-instance": "dynamic",
                        "--source": "dynamic",
                        "--source-cluster": "dynamic",
                        "--source-instance": "dynamic"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--instance": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--display-name": "value"
                  }
                },
                "upgrade": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "billing": {
          "commands": {
            "accounts": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "projects": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "link": {
                      "commands": {},
                      "flags": {
                        "--account-id": "dynamic",
                        "--billing-account": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--billing-account": "dynamic",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "unlink": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "budgets": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--all-updates-rule-monitoring-notification-channels": "value",
                    "--all-updates-rule-pubsub-topic": "value",
                    "--billing-account": "value",
                    "--budget-amount": "value",
                    "--calendar-period": [
                      "calendar-period-unspecified",
                      "month",
                      "quarter",
                      "year"
                    ],
                    "--credit-types-treatment": [
                      "credit-types-treatment-unspecified",
                      "exclude-all-credits",
                      "include-all-credits",
                      "include-specified-credits"
                    ],
                    "--disable-default-iam-recipients": "bool",
                    "--display-name": "value",
                    "--end-date": "value",
                    "--filter-credit-types": "value",
                    "--filter-labels": "value",
                    "--filter-projects": "value",
                    "--filter-services": "value",
                    "--filter-subaccounts": "value",
                    "--last-period-amount": "bool",
                    "--start-date": "value",
                    "--threshold-rule": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-threshold-rule": "value",
                    "--all-updates-rule-monitoring-notification-channels": "value",
                    "--all-updates-rule-pubsub-topic": "value",
                    "--billing-account": "value",
                    "--budget-amount": "value",
                    "--calendar-period": [
                      "calendar-period-unspecified",
                      "month",
                      "quarter",
                      "year"
                    ],
                    "--clear-threshold-rules": "bool",
                    "--credit-types-treatment": [
                      "credit-types-treatment-unspecified",
                      "exclude-all-credits",
                      "include-all-credits",
                      "include-specified-credits"
                    ],
                    "--disable-default-iam-recipients": "bool",
                    "--display-name": "value",
                    "--end-date": "value",
                    "--filter-credit-types": "value",
                    "--filter-labels": "value",
                    "--filter-projects": "value",
                    "--filter-services": "value",
                    "--filter-subaccounts": "value",
                    "--last-period-amount": "bool",
                    "--start-date": "value",
                    "--threshold-rules-from-file": "value"
                  }
                }
              },
              "flags": {}
            },
            "projects": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "link": {
                  "commands": {},
                  "flags": {
                    "--account-id": "dynamic",
                    "--billing-account": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "dynamic",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "unlink": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "bms": {
          "commands": {
            "instances": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--limit": "value",
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "bq": {
          "commands": {
            "datasets": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--overwrite": "bool",
                    "--permissions-file": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--remove-tables": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--permissions-file": "value"
                  }
                }
              },
              "flags": {}
            },
            "jobs": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--show-all-users": "bool",
                    "--show-config": "bool",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "tables": {
              "commands": {
                "copy": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination": "dynamic",
                    "--destination-dataset": "dynamic",
                    "--job-id": "value",
                    "--overwrite": "bool",
                    "--source": "dynamic",
                    "--source-dataset": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--dataset": "dynamic",
                    "--description": "value",
                    "--expiration": "value",
                    "--overwrite": "bool",
                    "--schema": "value",
                    "--schema-file": "value",
                    "--use-legacy-sql": "bool",
                    "--view": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--dataset": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--dataset": "dynamic"
                  }
                },
                "insert": {
                  "commands": {},
                  "flags": {
                    "--data": "value",
                    "--dataset": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--dataset": "dynamic",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "show-rows": {
                  "commands": {},
                  "flags": {
                    "--dataset": "dynamic",
                    "--limit": "value",
                    "--start": "value",
                    "--table": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-columns": "value",
                    "--add-columns-file": "value",
                    "--dataset": "dynamic",
                    "--description": "value",
                    "--expiration": "value",
                    "--relax-columns": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "builds": {
          "commands": {
            "approve": {
              "commands": {},
              "flags": {
                "--comment": "value",
                "--url": "value"
              }
            },
            "cancel": {
              "commands": {},
              "flags": {
                "--region": "value"
              }
            },
            "deploy": {
              "commands": {
                "configure": {
                  "commands": {
                    "gke": {
                      "commands": {},
                      "flags": {
                        "--app-name": "value",
                        "--branch-pattern": "value",
                        "--cluster": "value",
                        "--comment-control": "bool",
                        "--config": "value",
                        "--dockerfile": "value",
                        "--expose": "value",
                        "--gcs-config-staging-dir": "value",
                        "--location": "value",
                        "--namespace": "value",
                        "--preview-expiry": "value",
                        "--pull-request-pattern": "value",
                        "--pull-request-preview": "bool",
                        "--repo-name": "value",
                        "--repo-owner": "value",
                        "--repo-type": [
                          "bitbucket_mirrored",
                          "csr",
                          "github",
                          "github_mirrored"
                        ],
                        "--tag-pattern": "value",
                        "--timeout": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "gke": {
                  "commands": {},
                  "flags": {
                    "--app-name": "value",
                    "--app-version": "value",
                    "--async": "bool",
                    "--cluster": "value",
                    "--config": "value",
                    "--expose": "value",
                    "--gcs-staging-dir": "value",
                    "--image": "value",
                    "--location": "value",
                    "--namespace": "value",
                    "--no-source": "bool",
                    "--tag": "value",
                    "--timeout": "value"
                  }
                }
              },
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "value"
              }
            },
            "enterprise-config": {
              "commands": {
                "bitbucketserver": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--admin-access-token-name": "value",
                        "--api-key": "value",
                        "--host-uri": "value",
                        "--peered-network": "value",
                        "--read-access-token-name": "value",
                        "--user-name": "value",
                        "--webhook-secret-name": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {}
                    },
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--admin-access-token-name": "value",
                        "--api-key": "value",
                        "--host-uri": "value",
                        "--read-access-token-name": "value",
                        "--user-name": "value",
                        "--webhook-secret-name": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "github": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--app-id": "value",
                        "--gcs-bucket": "value",
                        "--gcs-object": "value",
                        "--generation": "value",
                        "--host-uri": "value",
                        "--oauth-client-id-name": "value",
                        "--oauth-client-id-version-name": "value",
                        "--oauth-secret-name": "value",
                        "--oauth-secret-version-name": "value",
                        "--peered-network": "value",
                        "--private-key-name": "value",
                        "--private-key-version-name": "value",
                        "--webhook-key": "value",
                        "--webhook-secret-name": "value",
                        "--webhook-secret-version-name": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {}
                    },
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--app-id": "value",
                        "--gcs-bucket": "value",
                        "--gcs-object": "value",
                        "--generation": "value",
                        "--host-uri": "value",
                        "--oauth-client-id-name": "value",
                        "--oauth-client-id-version-name": "value",
                        "--oauth-secret-name": "value",
                        "--oauth-secret-version-name": "value",
                        "--private-key-name": "value",
                        "--private-key-version-name": "value",
                        "--webhook-key": "value",
                        "--webhook-secret-name": "value",
                        "--webhook-secret-version-name": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--ongoing": "bool",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "log": {
              "commands": {},
              "flags": {
                "--region": "value",
                "--stream": "bool"
              }
            },
            "reject": {
              "commands": {},
              "flags": {
                "--comment": "value",
                "--url": "value"
              }
            },
            "submit": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--config": "value",
                "--disk-size": "value",
                "--gcs-log-dir": "value",
                "--gcs-source-staging-dir": "value",
                "--ignore-file": "value",
                "--machine-type": [
                  "e2-highcpu-32",
                  "e2-highcpu-8",
                  "n1-highcpu-32",
                  "n1-highcpu-8"
                ],
                "--no-cache": "bool",
                "--no-source": "bool",
                "--pack": "value",
                "--region": "value",
                "--substitutions": "value",
                "--suppress-logs": "bool",
                "--tag": "value",
                "--timeout": "value",
                "--worker-pool": "value"
              }
            },
            "triggers": {
              "commands": {
                "create": {
                  "commands": {
                    "bitbucketserver": {
                      "commands": {},
                      "flags": {
                        "--bitbucket-server-config-resource": "value",
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--comment-control": "value",
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--inline-config": "value",
                        "--name": "value",
                        "--project-key": "value",
                        "--pull-request-pattern": "value",
                        "--repo-slug": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--substitutions": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value"
                      }
                    },
                    "cloud-source-repositories": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--inline-config": "value",
                        "--name": "value",
                        "--repo": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--substitutions": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value"
                      }
                    },
                    "github": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--comment-control": "value",
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--inline-config": "value",
                        "--name": "value",
                        "--pull-request-pattern": "value",
                        "--repo-name": "value",
                        "--repo-owner": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--substitutions": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value"
                      }
                    },
                    "pubsub": {
                      "commands": {},
                      "flags": {
                        "--branch": "value",
                        "--build-config": "value",
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--filter": "value",
                        "--inline-config": "value",
                        "--name": "value",
                        "--repo": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--substitutions": "value",
                        "--tag": "value",
                        "--topic": "value",
                        "--trigger-config": "value"
                      }
                    },
                    "webhook": {
                      "commands": {},
                      "flags": {
                        "--branch": "value",
                        "--build-config": "value",
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--filter": "value",
                        "--inline-config": "value",
                        "--name": "value",
                        "--repo": "value",
                        "--require-approval": "bool",
                        "--secret": "value",
                        "--service-account": "value",
                        "--substitutions": "value",
                        "--tag": "value",
                        "--trigger-config": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--region": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "run": {
                  "commands": {},
                  "flags": {
                    "--branch": "value",
                    "--region": "value",
                    "--sha": "value",
                    "--tag": "value"
                  }
                }
              },
              "flags": {}
            },
            "worker-pools": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--config-from-file": "value",
                    "--no-external-ip": "bool",
                    "--peered-network": "value",
                    "--region": "value",
                    "--worker-disk-size": "value",
                    "--worker-machine-type": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--config-from-file": "value",
                    "--no-external-ip": "bool",
                    "--region": "value",
                    "--worker-disk-size": "value",
                    "--worker-machine-type": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "certificate-manager": {
          "commands": {
            "certificates": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--certificate-file": "value",
                    "--description": "value",
                    "--dns-authorizations": "value",
                    "--domains": "value",
                    "--labels": "value",
                    "--location": "value",
                    "--private-key-file": "value",
                    "--scope": [
                      "default",
                      "edge-cache"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--certificate-file": "value",
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--private-key-file": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "dns-authorizations": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--domain": "value",
                    "--labels": "value",
                    "--location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--location": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "maps": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--labels": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "entries": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--certificates": "dynamic",
                        "--description": "value",
                        "--hostname": "value",
                        "--labels": "value",
                        "--map": "dynamic",
                        "--set-primary": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--map": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--map": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--map": "dynamic",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--certificates": "dynamic",
                        "--clear-certificates": "bool",
                        "--clear-labels": "bool",
                        "--description": "value",
                        "--map": "dynamic",
                        "--remove-labels": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "cloud-shell": {
          "commands": {
            "get-mount-command": {
              "commands": {},
              "flags": {
                "--force-key-file-overwrite": "bool",
                "--ssh-key-file": "bool"
              }
            },
            "scp": {
              "commands": {},
              "flags": {
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--recurse": "bool",
                "--scp-flag": "value",
                "--ssh-key-file": "bool"
              }
            },
            "ssh": {
              "commands": {},
              "flags": {
                "--authorize-session": "bool",
                "--command": "value",
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--ssh-flag": "value",
                "--ssh-key-file": "bool"
              }
            }
          },
          "flags": {}
        },
        "code": {
          "commands": {
            "clean-up": {
              "commands": {},
              "flags": {
                "--minikube-profile": "value"
              }
            },
            "dev": {
              "commands": {},
              "flags": {
                "--allow-secret-manager": "bool",
                "--application-default-credential": "bool",
                "--builder": "value",
                "--cloudsql-instances": "value",
                "--cpu": "value",
                "--dockerfile": "value",
                "--env-vars": "value",
                "--env-vars-file": "value",
                "--image": "value",
                "--kube-context": "value",
                "--local-port": "value",
                "--memory": "value",
                "--minikube-profile": "value",
                "--minikube-vm-driver": "value",
                "--namespace": "value",
                "--secrets": "value",
                "--service-account": "value",
                "--service-name": "value",
                "--source": "value",
                "--stop-cluster": "bool"
              }
            }
          },
          "flags": {}
        },
        "composer": {
          "commands": {
            "environments": {
              "commands": {
                "check-upgrade": {
                  "commands": {},
                  "flags": {
                    "--airflow-version": "value",
                    "--async": "bool",
                    "--image-version": "value",
                    "--location": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--airflow-configs": "value",
                    "--airflow-version": "value",
                    "--async": "bool",
                    "--cloud-sql-ipv4-cidr": "value",
                    "--cloud-sql-machine-type": "value",
                    "--cluster-ipv4-cidr": "value",
                    "--cluster-secondary-range-name": "value",
                    "--composer-network-ipv4-cidr": "value",
                    "--disk-size": "value",
                    "--enable-ip-alias": "bool",
                    "--enable-private-endpoint": "bool",
                    "--enable-private-environment": "bool",
                    "--env-variables": "value",
                    "--environment-size": [
                      "large",
                      "medium",
                      "small",
                      "unspecified"
                    ],
                    "--image-version": "value",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--location": "value",
                    "--machine-type": "value",
                    "--maintenance-window-end": "value",
                    "--maintenance-window-recurrence": "value",
                    "--maintenance-window-start": "value",
                    "--master-ipv4-cidr": "value",
                    "--max-pods-per-node": "value",
                    "--max-workers": "value",
                    "--min-workers": "value",
                    "--network": "value",
                    "--node-count": "value",
                    "--oauth-scopes": "value",
                    "--python-version": [
                      "2",
                      "3"
                    ],
                    "--scheduler-count": "value",
                    "--scheduler-cpu": "value",
                    "--scheduler-memory": "value",
                    "--scheduler-storage": "value",
                    "--service-account": "value",
                    "--services-ipv4-cidr": "value",
                    "--services-secondary-range-name": "value",
                    "--subnetwork": "value",
                    "--tags": "value",
                    "--web-server-allow-all": "bool",
                    "--web-server-allow-ip": "value",
                    "--web-server-cpu": "value",
                    "--web-server-deny-all": "bool",
                    "--web-server-ipv4-cidr": "value",
                    "--web-server-machine-type": "value",
                    "--web-server-memory": "value",
                    "--web-server-storage": "value",
                    "--worker-cpu": "value",
                    "--worker-memory": "value",
                    "--worker-storage": "value",
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--locations": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-packages": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--tree": "bool"
                  }
                },
                "list-upgrades": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "restart-web-server": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "run": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "storage": {
                  "commands": {
                    "dags": {
                      "commands": {
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        },
                        "export": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "import": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "data": {
                      "commands": {
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        },
                        "export": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "import": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "plugins": {
                      "commands": {
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        },
                        "export": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "import": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--airflow-version": "value",
                    "--async": "bool",
                    "--clear-airflow-configs": "bool",
                    "--clear-env-variables": "bool",
                    "--clear-labels": "bool",
                    "--clear-pypi-packages": "bool",
                    "--cloud-sql-machine-type": "value",
                    "--environment-size": [
                      "large",
                      "medium",
                      "small",
                      "unspecified"
                    ],
                    "--image-version": "value",
                    "--location": "value",
                    "--maintenance-window-end": "value",
                    "--maintenance-window-recurrence": "value",
                    "--maintenance-window-start": "value",
                    "--max-workers": "value",
                    "--min-workers": "value",
                    "--node-count": "value",
                    "--remove-airflow-configs": "value",
                    "--remove-env-variables": "value",
                    "--remove-labels": "value",
                    "--remove-pypi-packages": "value",
                    "--scheduler-count": "value",
                    "--scheduler-cpu": "value",
                    "--scheduler-memory": "value",
                    "--scheduler-storage": "value",
                    "--update-airflow-configs": "value",
                    "--update-env-variables": "value",
                    "--update-labels": "value",
                    "--update-pypi-package": "value",
                    "--update-pypi-packages-from-file": "value",
                    "--update-web-server-allow-ip": "value",
                    "--web-server-allow-all": "bool",
                    "--web-server-cpu": "value",
                    "--web-server-deny-all": "bool",
                    "--web-server-machine-type": "value",
                    "--web-server-memory": "value",
                    "--web-server-storage": "value",
                    "--worker-cpu": "value",
                    "--worker-memory": "value",
                    "--worker-storage": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--locations": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "compute": {
          "commands": {
            "accelerator-types": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "addresses": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--region": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--addresses": "value",
                    "--description": "value",
                    "--global": "bool",
                    "--ip-version": [
                      "IPV4",
                      "IPV6"
                    ],
                    "--network": "value",
                    "--network-tier": "value",
                    "--prefix-length": "value",
                    "--purpose": [
                      "GCE_ENDPOINT",
                      "IPSEC_INTERCONNECT",
                      "PRIVATE_SERVICE_CONNECT",
                      "SHARED_LOADBALANCER_VIP",
                      "VPC_PEERING"
                    ],
                    "--region": "dynamic",
                    "--subnet": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--global": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "backend-buckets": {
              "commands": {
                "add-signed-url-key": {
                  "commands": {},
                  "flags": {
                    "--key-file": "value",
                    "--key-name": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--bypass-cache-on-request-headers": "value",
                    "--cache-mode": [
                      "CACHE_ALL_STATIC",
                      "FORCE_CACHE_ALL",
                      "USE_ORIGIN_HEADERS"
                    ],
                    "--client-ttl": "value",
                    "--custom-response-header": "value",
                    "--default-ttl": "value",
                    "--description": "value",
                    "--enable-cdn": "bool",
                    "--gcs-bucket-name": "dynamic",
                    "--max-ttl": "value",
                    "--negative-caching": "bool",
                    "--negative-caching-policy": "value",
                    "--request-coalescing": "bool",
                    "--serve-while-stale": "value",
                    "--signed-url-cache-max-age": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "delete-signed-url-key": {
                  "commands": {},
                  "flags": {
                    "--key-name": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--bypass-cache-on-request-headers": "value",
                    "--cache-mode": [
                      "CACHE_ALL_STATIC",
                      "FORCE_CACHE_ALL",
                      "USE_ORIGIN_HEADERS"
                    ],
                    "--client-ttl": "value",
                    "--custom-response-header": "value",
                    "--default-ttl": "value",
                    "--description": "value",
                    "--edge-security-policy": "dynamic",
                    "--enable-cdn": "bool",
                    "--gcs-bucket-name": "dynamic",
                    "--max-ttl": "value",
                    "--negative-caching": "bool",
                    "--negative-caching-policy": "value",
                    "--no-bypass-cache-on-request-headers": "bool",
                    "--no-client-ttl": "bool",
                    "--no-custom-response-headers": "bool",
                    "--no-default-ttl": "bool",
                    "--no-max-ttl": "bool",
                    "--no-negative-caching-policies": "bool",
                    "--no-serve-while-stale": "bool",
                    "--request-coalescing": "bool",
                    "--serve-while-stale": "value",
                    "--signed-url-cache-max-age": "value"
                  }
                }
              },
              "flags": {}
            },
            "backend-services": {
              "commands": {
                "add-backend": {
                  "commands": {},
                  "flags": {
                    "--balancing-mode": [
                      "CONNECTION",
                      "RATE",
                      "UTILIZATION"
                    ],
                    "--capacity-scaler": "value",
                    "--description": "value",
                    "--failover": "bool",
                    "--global": "bool",
                    "--global-network-endpoint-group": "bool",
                    "--instance-group": "dynamic",
                    "--instance-group-region": "dynamic",
                    "--instance-group-zone": "dynamic",
                    "--max-connections": "value",
                    "--max-connections-per-endpoint": "value",
                    "--max-connections-per-instance": "value",
                    "--max-rate": "value",
                    "--max-rate-per-endpoint": "value",
                    "--max-rate-per-instance": "value",
                    "--max-utilization": "value",
                    "--network-endpoint-group": "value",
                    "--network-endpoint-group-region": "dynamic",
                    "--network-endpoint-group-zone": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "add-signed-url-key": {
                  "commands": {},
                  "flags": {
                    "--key-file": "value",
                    "--key-name": "value"
                  }
                },
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--global": "bool",
                        "--path": "value",
                        "--region": "dynamic",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--affinity-cookie-ttl": "value",
                    "--bypass-cache-on-request-headers": "value",
                    "--cache-key-include-host": "bool",
                    "--cache-key-include-protocol": "bool",
                    "--cache-key-include-query-string": "bool",
                    "--cache-key-query-string-blacklist": "value",
                    "--cache-key-query-string-whitelist": "value",
                    "--cache-mode": [
                      "CACHE_ALL_STATIC",
                      "FORCE_CACHE_ALL",
                      "USE_ORIGIN_HEADERS"
                    ],
                    "--client-ttl": "value",
                    "--connection-drain-on-failover": "bool",
                    "--connection-draining-timeout": "value",
                    "--connection-persistence-on-unhealthy-backends": [
                      "ALWAYS_PERSIST",
                      "DEFAULT_FOR_PROTOCOL",
                      "NEVER_PERSIST"
                    ],
                    "--custom-request-header": "value",
                    "--custom-response-header": "value",
                    "--default-ttl": "value",
                    "--description": "value",
                    "--drop-traffic-if-unhealthy": "bool",
                    "--enable-cdn": "bool",
                    "--enable-logging": "bool",
                    "--failover-ratio": "value",
                    "--global": "bool",
                    "--global-health-checks": "bool",
                    "--health-checks": "dynamic",
                    "--health-checks-region": "dynamic",
                    "--http-health-checks": "dynamic",
                    "--https-health-checks": "dynamic",
                    "--iap": "value",
                    "--idle-timeout-sec": "value",
                    "--load-balancing-scheme": [
                      "EXTERNAL",
                      "EXTERNAL_MANAGED",
                      "INTERNAL",
                      "INTERNAL_MANAGED",
                      "INTERNAL_SELF_MANAGED"
                    ],
                    "--logging-sample-rate": "value",
                    "--max-ttl": "value",
                    "--negative-caching": "bool",
                    "--negative-caching-policy": "value",
                    "--network": "value",
                    "--port-name": "value",
                    "--protocol": "value",
                    "--region": "dynamic",
                    "--request-coalescing": "bool",
                    "--serve-while-stale": "value",
                    "--session-affinity": [
                      "CLIENT_IP",
                      "CLIENT_IP_NO_DESTINATION",
                      "CLIENT_IP_PORT_PROTO",
                      "CLIENT_IP_PROTO",
                      "GENERATED_COOKIE",
                      "HEADER_FIELD",
                      "HTTP_COOKIE",
                      "NONE"
                    ],
                    "--signed-url-cache-max-age": "value",
                    "--subsetting-policy": [
                      "CONSISTENT_HASH_SUBSETTING",
                      "NONE"
                    ],
                    "--subsetting-subset-size": "value",
                    "--timeout": "value",
                    "--tracking-mode": [
                      "PER_CONNECTION",
                      "PER_SESSION"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "delete-signed-url-key": {
                  "commands": {},
                  "flags": {
                    "--key-name": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "edit": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "get-health": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-backend": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--global-network-endpoint-group": "bool",
                    "--instance-group": "dynamic",
                    "--instance-group-region": "dynamic",
                    "--instance-group-zone": "dynamic",
                    "--network-endpoint-group": "value",
                    "--network-endpoint-group-region": "dynamic",
                    "--network-endpoint-group-zone": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "set-security-policy": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--security-policy": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--affinity-cookie-ttl": "value",
                    "--bypass-cache-on-request-headers": "value",
                    "--cache-key-include-host": "bool",
                    "--cache-key-include-protocol": "bool",
                    "--cache-key-include-query-string": "bool",
                    "--cache-key-query-string-blacklist": "value",
                    "--cache-key-query-string-whitelist": "value",
                    "--cache-mode": [
                      "CACHE_ALL_STATIC",
                      "FORCE_CACHE_ALL",
                      "USE_ORIGIN_HEADERS"
                    ],
                    "--client-ttl": "value",
                    "--connection-drain-on-failover": "bool",
                    "--connection-draining-timeout": "value",
                    "--connection-persistence-on-unhealthy-backends": [
                      "ALWAYS_PERSIST",
                      "DEFAULT_FOR_PROTOCOL",
                      "NEVER_PERSIST"
                    ],
                    "--custom-request-header": "value",
                    "--custom-response-header": "value",
                    "--default-ttl": "value",
                    "--description": "value",
                    "--drop-traffic-if-unhealthy": "bool",
                    "--edge-security-policy": "dynamic",
                    "--enable-cdn": "bool",
                    "--enable-logging": "bool",
                    "--failover-ratio": "value",
                    "--global": "bool",
                    "--global-health-checks": "bool",
                    "--health-checks": "dynamic",
                    "--health-checks-region": "dynamic",
                    "--http-health-checks": "dynamic",
                    "--https-health-checks": "dynamic",
                    "--iap": "value",
                    "--idle-timeout-sec": "value",
                    "--logging-sample-rate": "value",
                    "--max-ttl": "value",
                    "--negative-caching": "bool",
                    "--negative-caching-policy": "value",
                    "--no-bypass-cache-on-request-headers": "bool",
                    "--no-client-ttl": "bool",
                    "--no-custom-request-headers": "bool",
                    "--no-custom-response-headers": "bool",
                    "--no-default-ttl": "bool",
                    "--no-health-checks": "bool",
                    "--no-max-ttl": "bool",
                    "--no-negative-caching-policies": "bool",
                    "--no-serve-while-stale": "bool",
                    "--port-name": "value",
                    "--protocol": "value",
                    "--region": "dynamic",
                    "--request-coalescing": "bool",
                    "--security-policy": "dynamic",
                    "--serve-while-stale": "value",
                    "--session-affinity": [
                      "CLIENT_IP",
                      "CLIENT_IP_NO_DESTINATION",
                      "CLIENT_IP_PORT_PROTO",
                      "CLIENT_IP_PROTO",
                      "GENERATED_COOKIE",
                      "HEADER_FIELD",
                      "HTTP_COOKIE",
                      "NONE"
                    ],
                    "--signed-url-cache-max-age": "value",
                    "--subsetting-policy": [
                      "CONSISTENT_HASH_SUBSETTING",
                      "NONE"
                    ],
                    "--subsetting-subset-size": "value",
                    "--timeout": "value",
                    "--tracking-mode": [
                      "PER_CONNECTION",
                      "PER_SESSION"
                    ]
                  }
                },
                "update-backend": {
                  "commands": {},
                  "flags": {
                    "--balancing-mode": [
                      "CONNECTION",
                      "RATE",
                      "UTILIZATION"
                    ],
                    "--capacity-scaler": "value",
                    "--description": "value",
                    "--failover": "bool",
                    "--global": "bool",
                    "--instance-group": "dynamic",
                    "--instance-group-region": "dynamic",
                    "--instance-group-zone": "dynamic",
                    "--max-connections": "value",
                    "--max-connections-per-endpoint": "value",
                    "--max-connections-per-instance": "value",
                    "--max-rate": "value",
                    "--max-rate-per-endpoint": "value",
                    "--max-rate-per-instance": "value",
                    "--max-utilization": "value",
                    "--network-endpoint-group": "value",
                    "--network-endpoint-group-zone": "dynamic",
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "commitments": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--auto-renew": "bool",
                    "--local-ssd": "value",
                    "--machine-type": "value",
                    "--min-cpu-platform": "value",
                    "--plan": [
                      "12-month",
                      "36-month"
                    ],
                    "--region": "dynamic",
                    "--require-specific-reservation": "bool",
                    "--reservation": "dynamic",
                    "--reservation-zone": "dynamic",
                    "--reservations-from-file": "value",
                    "--resources": "value",
                    "--resources-accelerator": "value",
                    "--share-setting": [
                      "folders",
                      "organization",
                      "projects"
                    ],
                    "--share-with": "value",
                    "--type": [
                      "accelerator-optimized",
                      "compute-optimized",
                      "compute-optimized-c2d",
                      "general-purpose",
                      "general-purpose-e2",
                      "general-purpose-n2",
                      "general-purpose-n2d",
                      "general-purpose-t2d",
                      "memory-optimized"
                    ],
                    "--vm-count": "value"
                  }
                },
                "create-license": {
                  "commands": {},
                  "flags": {
                    "--amount": "value",
                    "--cores-per-license": "value",
                    "--license": "value",
                    "--plan": [
                      "12-month",
                      "36-month"
                    ],
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--auto-renew": "bool",
                    "--region": "dynamic"
                  }
                },
                "update-reservations": {
                  "commands": {},
                  "flags": {
                    "--dest-accelerator": "value",
                    "--dest-local-ssd": "value",
                    "--dest-reservation": "value",
                    "--dest-share-setting": [
                      "folders",
                      "organization",
                      "projects"
                    ],
                    "--dest-share-with": "value",
                    "--region": "dynamic",
                    "--reservations-from-file": "value",
                    "--source-accelerator": "value",
                    "--source-local-ssd": "value",
                    "--source-reservation": "value",
                    "--source-share-setting": [
                      "folders",
                      "organization",
                      "projects"
                    ],
                    "--source-share-with": "value"
                  }
                }
              },
              "flags": {}
            },
            "config-ssh": {
              "commands": {},
              "flags": {
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--remove": "bool",
                "--ssh-config-file": "value",
                "--ssh-key-file": "value"
              }
            },
            "connect-to-serial-port": {
              "commands": {},
              "flags": {
                "--dry-run": "bool",
                "--extra-args": "value",
                "--force-key-file-overwrite": "bool",
                "--port": "value",
                "--ssh-key-expiration": "value",
                "--ssh-key-expire-after": "value",
                "--ssh-key-file": "value",
                "--zone": "dynamic"
              }
            },
            "copy-files": {
              "commands": {},
              "flags": {
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--plain": "bool",
                "--ssh-key-expiration": "value",
                "--ssh-key-expire-after": "value",
                "--ssh-key-file": "value",
                "--strict-host-key-checking": [
                  "ask",
                  "no",
                  "yes"
                ],
                "--zone": "value"
              }
            },
            "diagnose": {
              "commands": {
                "export-logs": {
                  "commands": {},
                  "flags": {
                    "--collect-process-traces": "bool",
                    "--zone": "dynamic"
                  }
                },
                "routes": {
                  "commands": {},
                  "flags": {
                    "--container": "value",
                    "--dry-run": "bool",
                    "--external-route-ip": "value",
                    "--force-key-file-overwrite": "bool",
                    "--plain": "bool",
                    "--regexp": "value",
                    "--reverse-traceroute": "bool",
                    "--ssh-flag": "value",
                    "--ssh-key-expiration": "value",
                    "--ssh-key-expire-after": "value",
                    "--ssh-key-file": "value",
                    "--strict-host-key-checking": [
                      "ask",
                      "no",
                      "yes"
                    ],
                    "--user": "value",
                    "--zones": "dynamic"
                  }
                },
                "sosreport": {
                  "commands": {},
                  "flags": {
                    "--download-dir": "value",
                    "--dry-run": "bool",
                    "--force-key-file-overwrite": "bool",
                    "--plain": "bool",
                    "--python-path": "value",
                    "--reports-path": "value",
                    "--sosreport-install-path": "value",
                    "--ssh-flag": "value",
                    "--ssh-key-expiration": "value",
                    "--ssh-key-expire-after": "value",
                    "--ssh-key-file": "value",
                    "--strict-host-key-checking": [
                      "ask",
                      "no",
                      "yes"
                    ],
                    "--user": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "disk-types": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                }
              },
              "flags": {}
            },
            "disks": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--labels": "value",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "add-resource-policies": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--resource-policies": "value",
                    "--zone": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--csek-key-file": "value",
                    "--description": "value",
                    "--erase-windows-vss-signature": "bool",
                    "--guest-os-features": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-family-scope": [
                      "global",
                      "zonal"
                    ],
                    "--image-project": "value",
                    "--interface": "value",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--licenses": "value",
                    "--multi-writer": "bool",
                    "--physical-block-size": [
                      "16384",
                      "4096"
                    ],
                    "--provisioned-iops": "value",
                    "--region": "dynamic",
                    "--replica-zones": "value",
                    "--require-csek-key-create": "bool",
                    "--resource-policies": "value",
                    "--size": "value",
                    "--source-disk": "dynamic",
                    "--source-disk-region": "dynamic",
                    "--source-disk-zone": "dynamic",
                    "--source-instant-snapshot": "dynamic",
                    "--source-snapshot": "dynamic",
                    "--type": "dynamic",
                    "--user-licenses": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                },
                "move": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination-zone": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "remove-labels": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--labels": "value",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "remove-resource-policies": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--resource-policies": "value",
                    "--zone": "dynamic"
                  }
                },
                "resize": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--size": "value",
                    "--zone": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "snapshot": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--chain-name": "value",
                    "--csek-key-file": "value",
                    "--description": "value",
                    "--guest-flush": "bool",
                    "--labels": "value",
                    "--region": "dynamic",
                    "--snapshot-names": "value",
                    "--storage-location": "value",
                    "--zone": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--clear-user-licenses": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value",
                    "--update-user-licenses": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "external-vpn-gateways": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--interfaces": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "firewall-policies": {
              "commands": {
                "associations": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--folder": "value",
                        "--name": "value",
                        "--organization": "value",
                        "--replace-association-on-target": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--organization": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--folder": "value",
                        "--limit": "value",
                        "--organization": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "clone-rules": {
                  "commands": {},
                  "flags": {
                    "--organization": "value",
                    "--source-firewall-policy": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--folder": "value",
                    "--organization": "value",
                    "--short-name": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--folder": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-rules": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "move": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "rules": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny",
                          "goto_next"
                        ],
                        "--description": "value",
                        "--dest-ip-ranges": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--disabled": "bool",
                        "--enable-logging": "bool",
                        "--firewall-policy": "value",
                        "--layer4-configs": "value",
                        "--organization": "value",
                        "--src-ip-ranges": "value",
                        "--target-resources": "value",
                        "--target-service-accounts": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--organization": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--organization": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny",
                          "goto_next"
                        ],
                        "--description": "value",
                        "--dest-ip-ranges": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--disabled": "bool",
                        "--enable-logging": "bool",
                        "--firewall-policy": "value",
                        "--layer4-configs": "value",
                        "--new-priority": "value",
                        "--organization": "value",
                        "--src-ip-ranges": "value",
                        "--target-resources": "value",
                        "--target-service-accounts": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--organization": "value"
                  }
                }
              },
              "flags": {}
            },
            "firewall-rules": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--action": [
                      "ALLOW",
                      "DENY"
                    ],
                    "--allow": "value",
                    "--description": "value",
                    "--destination-ranges": "value",
                    "--direction": [
                      "EGRESS",
                      "IN",
                      "INGRESS",
                      "OUT"
                    ],
                    "--disabled": "bool",
                    "--enable-logging": "bool",
                    "--logging-metadata": [
                      "exclude-all",
                      "include-all"
                    ],
                    "--network": "value",
                    "--priority": "value",
                    "--rules": "value",
                    "--source-ranges": "value",
                    "--source-service-accounts": "value",
                    "--source-tags": "value",
                    "--target-service-accounts": "value",
                    "--target-tags": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--allow": "value",
                    "--description": "value",
                    "--destination-ranges": "value",
                    "--disabled": "bool",
                    "--enable-logging": "bool",
                    "--logging-metadata": [
                      "exclude-all",
                      "include-all"
                    ],
                    "--priority": "value",
                    "--rules": "value",
                    "--source-ranges": "value",
                    "--source-service-accounts": "value",
                    "--source-tags": "value",
                    "--target-service-accounts": "value",
                    "--target-tags": "value"
                  }
                }
              },
              "flags": {}
            },
            "forwarding-rules": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--global": "bool",
                        "--path": "value",
                        "--region": "dynamic",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--address": "dynamic",
                    "--address-region": "dynamic",
                    "--allow-global-access": "bool",
                    "--backend-service": "value",
                    "--backend-service-region": "dynamic",
                    "--description": "value",
                    "--global": "bool",
                    "--global-address": "bool",
                    "--global-backend-service": "bool",
                    "--global-target-http-proxy": "bool",
                    "--global-target-https-proxy": "bool",
                    "--ip-protocol": [
                      "AH",
                      "ALL",
                      "ESP",
                      "ICMP",
                      "L3_DEFAULT",
                      "SCTP",
                      "TCP",
                      "UDP"
                    ],
                    "--ip-version": [
                      "IPV4",
                      "IPV6"
                    ],
                    "--is-mirroring-collector": "bool",
                    "--load-balancing-scheme": [
                      "EXTERNAL",
                      "EXTERNAL_MANAGED",
                      "INTERNAL",
                      "INTERNAL_MANAGED",
                      "INTERNAL_SELF_MANAGED"
                    ],
                    "--network": "value",
                    "--network-tier": "value",
                    "--port-range": "value",
                    "--ports": "value",
                    "--region": "dynamic",
                    "--service-directory-registration": "value",
                    "--service-label": "value",
                    "--source-ip-ranges": "value",
                    "--subnet": "value",
                    "--subnet-region": "dynamic",
                    "--target-google-apis-bundle": "value",
                    "--target-grpc-proxy": "value",
                    "--target-http-proxy": "value",
                    "--target-http-proxy-region": "dynamic",
                    "--target-https-proxy": "value",
                    "--target-https-proxy-region": "dynamic",
                    "--target-instance": "value",
                    "--target-instance-zone": "dynamic",
                    "--target-pool": "value",
                    "--target-pool-region": "dynamic",
                    "--target-service-attachment": "value",
                    "--target-service-attachment-region": "dynamic",
                    "--target-ssl-proxy": "value",
                    "--target-tcp-proxy": "value",
                    "--target-vpn-gateway": "value",
                    "--target-vpn-gateway-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-target": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "value",
                    "--backend-service-region": "dynamic",
                    "--global": "bool",
                    "--global-backend-service": "bool",
                    "--global-target-http-proxy": "bool",
                    "--global-target-https-proxy": "bool",
                    "--load-balancing-scheme": [
                      "EXTERNAL",
                      "EXTERNAL_MANAGED",
                      "INTERNAL",
                      "INTERNAL_MANAGED",
                      "INTERNAL_SELF_MANAGED"
                    ],
                    "--network": "value",
                    "--region": "dynamic",
                    "--subnet": "value",
                    "--subnet-region": "dynamic",
                    "--target-grpc-proxy": "value",
                    "--target-http-proxy": "value",
                    "--target-http-proxy-region": "dynamic",
                    "--target-https-proxy": "value",
                    "--target-https-proxy-region": "dynamic",
                    "--target-instance": "value",
                    "--target-instance-zone": "dynamic",
                    "--target-pool": "value",
                    "--target-pool-region": "dynamic",
                    "--target-ssl-proxy": "value",
                    "--target-tcp-proxy": "value",
                    "--target-vpn-gateway": "value",
                    "--target-vpn-gateway-region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--allow-global-access": "bool",
                    "--clear-labels": "bool",
                    "--global": "bool",
                    "--network-tier": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--source-ip-ranges": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "future-reservations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--description": "value",
                    "--duration": "value",
                    "--end-time": "value",
                    "--local-ssd": "value",
                    "--machine-type": "value",
                    "--maintenance-freeze-duration": "value",
                    "--maintenance-interval": [
                      "PERIODIC"
                    ],
                    "--min-cpu-platform": "value",
                    "--name-prefix": "value",
                    "--share-setting": [
                      "projects"
                    ],
                    "--share-with": "value",
                    "--start-time": "value",
                    "--total-count": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--duration": "value",
                    "--end-time": "value",
                    "--start-time": "value",
                    "--total-count": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "health-checks": {
              "commands": {
                "create": {
                  "commands": {
                    "grpc": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--grpc-service-name": "value",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--region": "dynamic",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "http": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool",
                        "--weight-report-mode": [
                          "DISABLE",
                          "DRY_RUN",
                          "ENABLE"
                        ]
                      }
                    },
                    "http2": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool",
                        "--weight-report-mode": [
                          "DISABLE",
                          "DRY_RUN",
                          "ENABLE"
                        ]
                      }
                    },
                    "https": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool",
                        "--weight-report-mode": [
                          "DISABLE",
                          "DRY_RUN",
                          "ENABLE"
                        ]
                      }
                    },
                    "ssl": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "tcp": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--protocol": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {
                    "grpc": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--grpc-service-name": "value",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--region": "dynamic",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "http": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool",
                        "--weight-report-mode": [
                          "DISABLE",
                          "DRY_RUN",
                          "ENABLE"
                        ]
                      }
                    },
                    "http2": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool",
                        "--weight-report-mode": [
                          "DISABLE",
                          "DRY_RUN",
                          "ENABLE"
                        ]
                      }
                    },
                    "https": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool",
                        "--weight-report-mode": [
                          "DISABLE",
                          "DRY_RUN",
                          "ENABLE"
                        ]
                      }
                    },
                    "ssl": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "tcp": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "http-health-checks": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--check-interval": "value",
                    "--description": "value",
                    "--healthy-threshold": "value",
                    "--host": "value",
                    "--port": "value",
                    "--request-path": "value",
                    "--timeout": "value",
                    "--unhealthy-threshold": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--check-interval": "value",
                    "--description": "value",
                    "--healthy-threshold": "value",
                    "--host": "value",
                    "--port": "value",
                    "--request-path": "value",
                    "--timeout": "value",
                    "--unhealthy-threshold": "value"
                  }
                }
              },
              "flags": {}
            },
            "https-health-checks": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--check-interval": "value",
                    "--description": "value",
                    "--healthy-threshold": "value",
                    "--host": "value",
                    "--port": "value",
                    "--request-path": "value",
                    "--timeout": "value",
                    "--unhealthy-threshold": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--check-interval": "value",
                    "--description": "value",
                    "--healthy-threshold": "value",
                    "--host": "value",
                    "--port": "value",
                    "--request-path": "value",
                    "--timeout": "value",
                    "--unhealthy-threshold": "value"
                  }
                }
              },
              "flags": {}
            },
            "images": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--labels": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--csek-key-file": "value",
                    "--description": "value",
                    "--family": "value",
                    "--forbidden-database-file": "value",
                    "--force": "bool",
                    "--force-create": "bool",
                    "--guest-os-features": "value",
                    "--key-exchange-key-file": "value",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--licenses": "value",
                    "--platform-key-file": "value",
                    "--require-csek-key-create": "bool",
                    "--signature-database-file": "value",
                    "--source-disk": "dynamic",
                    "--source-disk-project": "value",
                    "--source-disk-zone": "dynamic",
                    "--source-image": "value",
                    "--source-image-family": "value",
                    "--source-image-project": "value",
                    "--source-snapshot": "dynamic",
                    "--source-uri": "value",
                    "--storage-location": "value",
                    "--user-licenses": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "deprecate": {
                  "commands": {},
                  "flags": {
                    "--delete-in": "value",
                    "--delete-on": "value",
                    "--deprecate-in": "value",
                    "--deprecate-on": "value",
                    "--obsolete-in": "value",
                    "--obsolete-on": "value",
                    "--replacement": "dynamic",
                    "--state": [
                      "ACTIVE",
                      "DELETED",
                      "DEPRECATED",
                      "OBSOLETE"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "describe-from-family": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--compute-service-account": "value",
                    "--destination-uri": "value",
                    "--export-format": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--log-location": "value",
                    "--network": "value",
                    "--subnet": "value",
                    "--timeout": "value",
                    "--zone": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--aws-access-key-id": "value",
                    "--aws-ami-export-location": "value",
                    "--aws-ami-id": "value",
                    "--aws-region": "value",
                    "--aws-secret-access-key": "value",
                    "--aws-session-token": "value",
                    "--aws-source-ami-file-path": "value",
                    "--byol": "bool",
                    "--compute-service-account": "value",
                    "--data-disk": "bool",
                    "--description": "value",
                    "--family": "value",
                    "--guest-environment": "bool",
                    "--log-location": "value",
                    "--network": "value",
                    "--no-address": "bool",
                    "--os": [
                      "centos-7",
                      "centos-8",
                      "debian-10",
                      "debian-8",
                      "debian-9",
                      "opensuse-15",
                      "rhel-6",
                      "rhel-6-byol",
                      "rhel-7",
                      "rhel-7-byol",
                      "rhel-8",
                      "rhel-8-byol",
                      "sles-12",
                      "sles-12-byol",
                      "sles-15",
                      "sles-15-byol",
                      "sles-sap-12",
                      "sles-sap-12-byol",
                      "sles-sap-15",
                      "sles-sap-15-byol",
                      "ubuntu-1404",
                      "ubuntu-1604",
                      "ubuntu-1804",
                      "ubuntu-2004",
                      "windows-10-x64-byol",
                      "windows-10-x86-byol",
                      "windows-2008r2",
                      "windows-2008r2-byol",
                      "windows-2012",
                      "windows-2012-byol",
                      "windows-2012r2",
                      "windows-2012r2-byol",
                      "windows-2016",
                      "windows-2016-byol",
                      "windows-2019",
                      "windows-2019-byol",
                      "windows-7-x64-byol",
                      "windows-7-x86-byol",
                      "windows-8-x64-byol",
                      "windows-8-x86-byol"
                    ],
                    "--source-file": "value",
                    "--source-image": "dynamic",
                    "--storage-location": "value",
                    "--subnet": "value",
                    "--timeout": "value",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--preview-images": "bool",
                    "--regexp": "value",
                    "--show-deprecated": "bool",
                    "--sort-by": "value",
                    "--standard-images": "bool",
                    "--uri": "bool"
                  }
                },
                "packages": {
                  "commands": {
                    "diff": {
                      "commands": {},
                      "flags": {
                        "--base-image": "dynamic",
                        "--base-project": "dynamic",
                        "--diff-image": "dynamic",
                        "--diff-project": "dynamic",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--show-added-packages": "bool",
                        "--show-removed-packages": "bool",
                        "--show-updated-packages": "bool",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--image": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "remove-labels": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--labels": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--family": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                },
                "vulnerabilities": {
                  "commands": {
                    "describe-note": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--image": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "instance-groups": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "get-named-ports": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                },
                "list-instances": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "dynamic"
                  }
                },
                "managed": {
                  "commands": {
                    "abandon-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--base-instance-name": "value",
                        "--description": "value",
                        "--health-check": "dynamic",
                        "--http-health-check": "value",
                        "--https-health-check": "value",
                        "--initial-delay": "value",
                        "--instance-redistribution-type": [
                          "NONE",
                          "PROACTIVE"
                        ],
                        "--region": "dynamic",
                        "--size": "value",
                        "--stateful-disk": "value",
                        "--stateful-external-ip": "value",
                        "--stateful-internal-ip": "value",
                        "--target-distribution-shape": [
                          "ANY",
                          "BALANCED",
                          "EVEN"
                        ],
                        "--target-pool": "value",
                        "--template": "value",
                        "--zone": "dynamic",
                        "--zones": "dynamic"
                      }
                    },
                    "create-instance": {
                      "commands": {},
                      "flags": {
                        "--instance": "value",
                        "--region": "dynamic",
                        "--stateful-disk": "value",
                        "--stateful-external-ip": "value",
                        "--stateful-internal-ip": "value",
                        "--stateful-metadata": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "delete-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--skip-instances-on-validation-error": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "describe-instance": {
                      "commands": {},
                      "flags": {
                        "--instance": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "export-autoscaling": {
                      "commands": {},
                      "flags": {
                        "--autoscaling-file": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "get-named-ports": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "dynamic",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "instance-configs": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--instance": "value",
                            "--instance-update-minimal-action": [
                              "none",
                              "refresh",
                              "replace",
                              "restart"
                            ],
                            "--region": "dynamic",
                            "--stateful-disk": "value",
                            "--stateful-external-ip": "value",
                            "--stateful-internal-ip": "value",
                            "--stateful-metadata": "value",
                            "--update-instance": "bool",
                            "--zone": "dynamic"
                          }
                        },
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--instance-update-minimal-action": [
                              "none",
                              "refresh",
                              "replace",
                              "restart"
                            ],
                            "--instances": "value",
                            "--region": "dynamic",
                            "--update-instance": "bool",
                            "--zone": "dynamic"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--region": "dynamic",
                            "--sort-by": "value",
                            "--zone": "dynamic"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--instance": "value",
                            "--instance-update-minimal-action": [
                              "none",
                              "refresh",
                              "replace",
                              "restart"
                            ],
                            "--region": "dynamic",
                            "--remove-stateful-disks": "value",
                            "--remove-stateful-external-ips": "value",
                            "--remove-stateful-internal-ips": "value",
                            "--remove-stateful-metadata": "value",
                            "--stateful-disk": "value",
                            "--stateful-external-ip": "value",
                            "--stateful-internal-ip": "value",
                            "--stateful-metadata": "value",
                            "--update-instance": "bool",
                            "--zone": "dynamic"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--regions": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zones": "value"
                      }
                    },
                    "list-errors": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "dynamic",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "list-instances": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "dynamic",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "recreate-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "resize": {
                      "commands": {},
                      "flags": {
                        "--creation-retries": "bool",
                        "--region": "dynamic",
                        "--size": "value",
                        "--stopped-size": "value",
                        "--suspended-size": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "resume-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "rolling-action": {
                      "commands": {
                        "replace": {
                          "commands": {},
                          "flags": {
                            "--max-surge": "value",
                            "--max-unavailable": "value",
                            "--min-ready": "value",
                            "--region": "dynamic",
                            "--replacement-method": [
                              "recreate",
                              "substitute"
                            ],
                            "--zone": "dynamic"
                          }
                        },
                        "restart": {
                          "commands": {},
                          "flags": {
                            "--max-unavailable": "value",
                            "--min-ready": "value",
                            "--region": "dynamic",
                            "--zone": "dynamic"
                          }
                        },
                        "start-update": {
                          "commands": {},
                          "flags": {
                            "--canary-version": "value",
                            "--force": "bool",
                            "--max-surge": "value",
                            "--max-unavailable": "value",
                            "--min-ready": "value",
                            "--minimal-action": [
                              "refresh",
                              "replace",
                              "restart"
                            ],
                            "--most-disruptive-allowed-action": [
                              "refresh",
                              "replace",
                              "restart"
                            ],
                            "--region": "dynamic",
                            "--replacement-method": [
                              "recreate",
                              "substitute"
                            ],
                            "--type": [
                              "opportunistic",
                              "proactive"
                            ],
                            "--zone": "dynamic"
                          }
                        },
                        "stop-proactive-update": {
                          "commands": {},
                          "flags": {
                            "--region": "dynamic",
                            "--zone": "dynamic"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "set-autohealing": {
                      "commands": {},
                      "flags": {
                        "--health-check": "dynamic",
                        "--http-health-check": "value",
                        "--https-health-check": "value",
                        "--initial-delay": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "set-autoscaling": {
                      "commands": {},
                      "flags": {
                        "--autoscaling-file": "value",
                        "--cool-down-period": "value",
                        "--cpu-utilization-predictive-method": [
                          "none",
                          "optimize-availability",
                          "standard"
                        ],
                        "--custom-metric-utilization": "value",
                        "--description": "value",
                        "--max-num-replicas": "value",
                        "--min-num-replicas": "value",
                        "--mode": [
                          "off",
                          "on",
                          "only-scale-out",
                          "only-up"
                        ],
                        "--region": "dynamic",
                        "--remove-stackdriver-metric": "value",
                        "--scale-based-on-cpu": "bool",
                        "--scale-based-on-load-balancing": "bool",
                        "--scale-in-control": "value",
                        "--schedule-cron": "value",
                        "--schedule-description": "value",
                        "--schedule-duration-sec": "value",
                        "--schedule-min-required-replicas": "value",
                        "--schedule-time-zone": "value",
                        "--set-schedule": "value",
                        "--stackdriver-metric-filter": "value",
                        "--stackdriver-metric-single-instance-assignment": "value",
                        "--stackdriver-metric-utilization-target": "value",
                        "--stackdriver-metric-utilization-target-type": [
                          "delta-per-minute",
                          "delta-per-second",
                          "gauge"
                        ],
                        "--target-cpu-utilization": "value",
                        "--target-load-balancing-utilization": "value",
                        "--update-stackdriver-metric": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "set-instance-template": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--template": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "set-named-ports": {
                      "commands": {},
                      "flags": {
                        "--named-ports": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "set-standby-policy": {
                      "commands": {},
                      "flags": {
                        "--initial-delay": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "set-target-pools": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--target-pools": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "start-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "stop-autoscaling": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "stop-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "suspend-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--clear-autohealing": "bool",
                        "--description": "value",
                        "--health-check": "dynamic",
                        "--http-health-check": "value",
                        "--https-health-check": "value",
                        "--initial-delay": "value",
                        "--instance-redistribution-type": [
                          "NONE",
                          "PROACTIVE"
                        ],
                        "--region": "dynamic",
                        "--remove-stateful-disks": "value",
                        "--remove-stateful-external-ips": "value",
                        "--remove-stateful-internal-ips": "value",
                        "--stateful-disk": "value",
                        "--stateful-external-ip": "value",
                        "--stateful-internal-ip": "value",
                        "--target-distribution-shape": [
                          "ANY",
                          "BALANCED",
                          "EVEN"
                        ],
                        "--zone": "dynamic"
                      }
                    },
                    "update-autoscaling": {
                      "commands": {},
                      "flags": {
                        "--clear-scale-in-control": "bool",
                        "--cpu-utilization-predictive-method": [
                          "none",
                          "optimize-availability",
                          "standard"
                        ],
                        "--disable-schedule": "value",
                        "--enable-schedule": "value",
                        "--max-num-replicas": "value",
                        "--min-num-replicas": "value",
                        "--mode": [
                          "off",
                          "on",
                          "only-scale-out",
                          "only-up"
                        ],
                        "--region": "dynamic",
                        "--remove-schedule": "value",
                        "--scale-in-control": "value",
                        "--schedule-cron": "value",
                        "--schedule-description": "value",
                        "--schedule-duration-sec": "value",
                        "--schedule-min-required-replicas": "value",
                        "--schedule-time-zone": "value",
                        "--set-schedule": "value",
                        "--update-schedule": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "update-instances": {
                      "commands": {},
                      "flags": {
                        "--all-instances": "bool",
                        "--instances": "value",
                        "--minimal-action": [
                          "none",
                          "refresh",
                          "replace",
                          "restart"
                        ],
                        "--most-disruptive-allowed-action": [
                          "none",
                          "refresh",
                          "replace",
                          "restart"
                        ],
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "wait-until": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--stable": "bool",
                        "--timeout": "value",
                        "--version-target-reached": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "wait-until-stable": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--timeout": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "set-named-ports": {
                  "commands": {},
                  "flags": {
                    "--named-ports": "value",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "unmanaged": {
                  "commands": {
                    "add-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--description": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "get-named-ports": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "dynamic",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zones": "dynamic"
                      }
                    },
                    "list-instances": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "remove-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "set-named-ports": {
                      "commands": {},
                      "flags": {
                        "--named-ports": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "instance-templates": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--address": "value",
                    "--boot-disk-auto-delete": "bool",
                    "--boot-disk-device-name": "value",
                    "--boot-disk-kms-key": "dynamic",
                    "--boot-disk-kms-keyring": "dynamic",
                    "--boot-disk-kms-location": "dynamic",
                    "--boot-disk-kms-project": "dynamic",
                    "--boot-disk-provisioned-iops": "value",
                    "--boot-disk-size": "value",
                    "--boot-disk-type": "value",
                    "--can-ip-forward": "bool",
                    "--confidential-compute": "bool",
                    "--configure-disk": "value",
                    "--create-disk": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--description": "value",
                    "--disk": "value",
                    "--enable-nested-virtualization": "bool",
                    "--host-error-timeout-seconds": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--ipv6-network-tier": [
                      "PREMIUM"
                    ],
                    "--labels": "value",
                    "--local-nvdimm": "value",
                    "--local-ssd": "value",
                    "--machine-type": "dynamic",
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--mesh": "value",
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--min-node-cpu": "value",
                    "--network": "value",
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--node": "value",
                    "--node-affinity-file": "value",
                    "--node-group": "value",
                    "--numa-node-count": "value",
                    "--on-host-maintenance": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--post-key-revocation-action-type": [
                      "noop",
                      "shutdown"
                    ],
                    "--preemptible": "bool",
                    "--private-ipv6-google-access-type": [
                      "enable-bidirectional-access",
                      "enable-outbound-vm-access",
                      "inherit-subnetwork"
                    ],
                    "--private-network-ip": "value",
                    "--provisioning-model": [
                      "SPOT"
                    ],
                    "--region": "dynamic",
                    "--reservation": "value",
                    "--reservation-affinity": [
                      "any",
                      "none",
                      "specific"
                    ],
                    "--resource-policies": "value",
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--service-proxy": "value",
                    "--service-proxy-labels": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--source-instance": "dynamic",
                    "--source-instance-zone": "dynamic",
                    "--stack-type": [
                      "IPV4_IPV6",
                      "IPV4_ONLY"
                    ],
                    "--subnet": "value",
                    "--tags": "value",
                    "--threads-per-core": "value",
                    "--visible-core-count": "value"
                  }
                },
                "create-with-container": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--address": "value",
                    "--boot-disk-auto-delete": "bool",
                    "--boot-disk-device-name": "value",
                    "--boot-disk-provisioned-iops": "value",
                    "--boot-disk-size": "value",
                    "--boot-disk-type": "value",
                    "--can-ip-forward": "bool",
                    "--confidential-compute": "bool",
                    "--container-arg": "value",
                    "--container-command": "value",
                    "--container-env": "value",
                    "--container-env-file": "value",
                    "--container-image": "value",
                    "--container-mount-disk": "value",
                    "--container-mount-host-path": "value",
                    "--container-mount-tmpfs": "value",
                    "--container-privileged": "bool",
                    "--container-restart-policy": [
                      "always",
                      "never",
                      "on-failure"
                    ],
                    "--container-stdin": "bool",
                    "--container-tty": "bool",
                    "--create-disk": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--description": "value",
                    "--disk": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--ipv6-network-tier": [
                      "PREMIUM"
                    ],
                    "--labels": "value",
                    "--local-nvdimm": "value",
                    "--local-ssd": "value",
                    "--machine-type": "dynamic",
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--network": "value",
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--on-host-maintenance": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--preemptible": "bool",
                    "--private-ipv6-google-access-type": [
                      "enable-bidirectional-access",
                      "enable-outbound-vm-access",
                      "inherit-subnetwork"
                    ],
                    "--private-network-ip": "value",
                    "--region": "dynamic",
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--stack-type": [
                      "IPV4_IPV6",
                      "IPV4_ONLY"
                    ],
                    "--subnet": "value",
                    "--tags": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "instances": {
              "commands": {
                "add-access-config": {
                  "commands": {},
                  "flags": {
                    "--access-config-name": "value",
                    "--address": "value",
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-public-dns": "bool",
                    "--no-public-ptr": "bool",
                    "--no-public-ptr-domain": "bool",
                    "--public-dns": "bool",
                    "--public-ptr": "bool",
                    "--public-ptr-domain": "value",
                    "--zone": "dynamic"
                  }
                },
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--labels": "value",
                    "--zone": "dynamic"
                  }
                },
                "add-metadata": {
                  "commands": {},
                  "flags": {
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--zone": "dynamic"
                  }
                },
                "add-resource-policies": {
                  "commands": {},
                  "flags": {
                    "--resource-policies": "value",
                    "--zone": "dynamic"
                  }
                },
                "add-tags": {
                  "commands": {},
                  "flags": {
                    "--tags": "value",
                    "--zone": "dynamic"
                  }
                },
                "attach-disk": {
                  "commands": {},
                  "flags": {
                    "--boot": "bool",
                    "--csek-key-file": "value",
                    "--device-name": "value",
                    "--disk": "value",
                    "--disk-scope": [
                      "regional",
                      "zonal"
                    ],
                    "--force-attach": "bool",
                    "--mode": [
                      "ro",
                      "rw"
                    ],
                    "--zone": "dynamic"
                  }
                },
                "bulk": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--accelerator": "value",
                        "--async": "bool",
                        "--boot-disk-auto-delete": "bool",
                        "--boot-disk-device-name": "value",
                        "--boot-disk-kms-key": "dynamic",
                        "--boot-disk-kms-keyring": "dynamic",
                        "--boot-disk-kms-location": "dynamic",
                        "--boot-disk-kms-project": "dynamic",
                        "--boot-disk-provisioned-iops": "value",
                        "--boot-disk-size": "value",
                        "--boot-disk-type": "value",
                        "--can-ip-forward": "bool",
                        "--confidential-compute": "bool",
                        "--count": "value",
                        "--create-disk": "value",
                        "--custom-cpu": "value",
                        "--custom-extensions": "bool",
                        "--custom-memory": "value",
                        "--custom-vm-type": "value",
                        "--description": "value",
                        "--enable-display-device": "bool",
                        "--enable-nested-virtualization": "bool",
                        "--erase-windows-vss-signature": "bool",
                        "--host-error-timeout-seconds": "value",
                        "--image": "value",
                        "--image-family": "value",
                        "--image-project": "value",
                        "--labels": "value",
                        "--local-ssd": "value",
                        "--location-policy": "value",
                        "--machine-type": "dynamic",
                        "--maintenance-policy": [
                          "MIGRATE",
                          "TERMINATE"
                        ],
                        "--metadata": "value",
                        "--metadata-from-file": "value",
                        "--min-count": "value",
                        "--min-cpu-platform": "value",
                        "--min-node-cpu": "value",
                        "--name-pattern": "value",
                        "--network": "value",
                        "--network-interface": "value",
                        "--network-tier": "value",
                        "--no-address": "bool",
                        "--no-public-dns": "bool",
                        "--no-scopes": "bool",
                        "--no-service-account": "bool",
                        "--numa-node-count": "value",
                        "--on-host-maintenance": [
                          "MIGRATE",
                          "TERMINATE"
                        ],
                        "--post-key-revocation-action-type": [
                          "noop",
                          "shutdown"
                        ],
                        "--predefined-names": "value",
                        "--preemptible": "bool",
                        "--public-dns": "bool",
                        "--region": "value",
                        "--reservation": "value",
                        "--reservation-affinity": [
                          "any",
                          "none",
                          "specific"
                        ],
                        "--resource-policies": "value",
                        "--restart-on-failure": "bool",
                        "--scopes": "value",
                        "--secure-tags": "value",
                        "--service-account": "value",
                        "--shielded-integrity-monitoring": "bool",
                        "--shielded-secure-boot": "bool",
                        "--shielded-vtpm": "bool",
                        "--source-instance-template": "dynamic",
                        "--source-snapshot": "value",
                        "--subnet": "value",
                        "--tags": "value",
                        "--threads-per-core": "value",
                        "--visible-core-count": "value",
                        "--zone": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ],
                        "--zone": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--address": "value",
                    "--async": "bool",
                    "--boot-disk-auto-delete": "bool",
                    "--boot-disk-device-name": "value",
                    "--boot-disk-kms-key": "dynamic",
                    "--boot-disk-kms-keyring": "dynamic",
                    "--boot-disk-kms-location": "dynamic",
                    "--boot-disk-kms-project": "dynamic",
                    "--boot-disk-provisioned-iops": "value",
                    "--boot-disk-size": "value",
                    "--boot-disk-type": "value",
                    "--can-ip-forward": "bool",
                    "--confidential-compute": "bool",
                    "--create-disk": "value",
                    "--csek-key-file": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--deletion-protection": "bool",
                    "--description": "value",
                    "--disk": "value",
                    "--enable-display-device": "bool",
                    "--enable-nested-virtualization": "bool",
                    "--erase-windows-vss-signature": "bool",
                    "--host-error-timeout-seconds": "value",
                    "--hostname": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-family-scope": [
                      "global",
                      "zonal"
                    ],
                    "--image-project": "value",
                    "--ipv6-network-tier": [
                      "PREMIUM"
                    ],
                    "--ipv6-public-ptr-domain": "value",
                    "--labels": "value",
                    "--local-nvdimm": "value",
                    "--local-ssd": "value",
                    "--machine-type": "dynamic",
                    "--maintenance-freeze-duration": "value",
                    "--maintenance-interval": [
                      "PERIODIC"
                    ],
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--min-node-cpu": "value",
                    "--network": "value",
                    "--network-interface": "value",
                    "--network-interface-from-file": "value",
                    "--network-interface-from-json-string": "value",
                    "--network-performance-configs": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-public-dns": "bool",
                    "--no-public-ptr": "bool",
                    "--no-public-ptr-domain": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--node": "value",
                    "--node-affinity-file": "value",
                    "--node-group": "value",
                    "--node-project": "value",
                    "--numa-node-count": "value",
                    "--on-host-maintenance": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--post-key-revocation-action-type": [
                      "noop",
                      "shutdown"
                    ],
                    "--preemptible": "bool",
                    "--private-ipv6-google-access-type": [
                      "enable-bidirectional-access",
                      "enable-outbound-vm-access",
                      "inherit-subnetwork"
                    ],
                    "--private-network-ip": "value",
                    "--provisioning-model": [
                      "SPOT"
                    ],
                    "--public-dns": "bool",
                    "--public-ptr": "bool",
                    "--public-ptr-domain": "value",
                    "--require-csek-key-create": "bool",
                    "--reservation": "value",
                    "--reservation-affinity": [
                      "any",
                      "none",
                      "specific"
                    ],
                    "--resource-policies": "value",
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--secure-tags": "value",
                    "--service-account": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--source-instance-template": "dynamic",
                    "--source-machine-image": "dynamic",
                    "--source-machine-image-csek-key-file": "value",
                    "--source-snapshot": "value",
                    "--stack-type": [
                      "IPV4_IPV6",
                      "IPV4_ONLY"
                    ],
                    "--subnet": "value",
                    "--tags": "value",
                    "--threads-per-core": "value",
                    "--visible-core-count": "value",
                    "--zone": "dynamic"
                  }
                },
                "create-with-container": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--address": "value",
                    "--boot-disk-auto-delete": "bool",
                    "--boot-disk-device-name": "value",
                    "--boot-disk-provisioned-iops": "value",
                    "--boot-disk-size": "value",
                    "--boot-disk-type": "value",
                    "--can-ip-forward": "bool",
                    "--confidential-compute": "bool",
                    "--container-arg": "value",
                    "--container-command": "value",
                    "--container-env": "value",
                    "--container-env-file": "value",
                    "--container-image": "value",
                    "--container-mount-disk": "value",
                    "--container-mount-host-path": "value",
                    "--container-mount-tmpfs": "value",
                    "--container-privileged": "bool",
                    "--container-restart-policy": [
                      "always",
                      "never",
                      "on-failure"
                    ],
                    "--container-stdin": "bool",
                    "--container-tty": "bool",
                    "--create-disk": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--description": "value",
                    "--disk": "value",
                    "--enable-nested-virtualization": "bool",
                    "--host-error-timeout-seconds": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--ipv6-network-tier": [
                      "PREMIUM"
                    ],
                    "--labels": "value",
                    "--local-nvdimm": "value",
                    "--local-ssd": "value",
                    "--machine-type": "dynamic",
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--network": "value",
                    "--network-interface": "value",
                    "--network-performance-configs": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-public-dns": "bool",
                    "--no-public-ptr": "bool",
                    "--no-public-ptr-domain": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--numa-node-count": "value",
                    "--on-host-maintenance": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--preemptible": "bool",
                    "--private-ipv6-google-access-type": [
                      "enable-bidirectional-access",
                      "enable-outbound-vm-access",
                      "inherit-subnetwork"
                    ],
                    "--private-network-ip": "value",
                    "--public-dns": "bool",
                    "--public-ptr": "bool",
                    "--public-ptr-domain": "value",
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--source-instance-template": "dynamic",
                    "--stack-type": [
                      "IPV4_IPV6",
                      "IPV4_ONLY"
                    ],
                    "--subnet": "value",
                    "--tags": "value",
                    "--threads-per-core": "value",
                    "--visible-core-count": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--delete-disks": [
                      "all",
                      "boot",
                      "data"
                    ],
                    "--keep-disks": [
                      "all",
                      "boot",
                      "data"
                    ],
                    "--zone": "dynamic"
                  }
                },
                "delete-access-config": {
                  "commands": {},
                  "flags": {
                    "--access-config-name": "value",
                    "--network-interface": "value",
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--guest-attributes": "value",
                    "--zone": "dynamic"
                  }
                },
                "detach-disk": {
                  "commands": {},
                  "flags": {
                    "--device-name": "value",
                    "--disk": "value",
                    "--disk-scope": [
                      "regional",
                      "zonal"
                    ],
                    "--zone": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--zone": "value"
                  }
                },
                "get-guest-attributes": {
                  "commands": {},
                  "flags": {
                    "--query-path": "value",
                    "--zone": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--zone": "value"
                  }
                },
                "get-serial-port-output": {
                  "commands": {},
                  "flags": {
                    "--port": "value",
                    "--start": "value",
                    "--zone": "dynamic"
                  }
                },
                "get-shielded-identity": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--byol": "bool",
                    "--can-ip-forward": "bool",
                    "--compute-service-account": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--deletion-protection": "bool",
                    "--description": "value",
                    "--guest-environment": "bool",
                    "--hostname": "value",
                    "--labels": "value",
                    "--log-location": "value",
                    "--machine-type": "dynamic",
                    "--network": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--node": "value",
                    "--node-affinity-file": "value",
                    "--node-group": "value",
                    "--os": [
                      "centos-7",
                      "centos-8",
                      "debian-10",
                      "debian-8",
                      "debian-9",
                      "opensuse-15",
                      "rhel-6",
                      "rhel-6-byol",
                      "rhel-7",
                      "rhel-7-byol",
                      "rhel-8",
                      "rhel-8-byol",
                      "sles-12",
                      "sles-12-byol",
                      "sles-15",
                      "sles-15-byol",
                      "sles-sap-12",
                      "sles-sap-12-byol",
                      "sles-sap-15",
                      "sles-sap-15-byol",
                      "ubuntu-1404",
                      "ubuntu-1604",
                      "ubuntu-1804",
                      "ubuntu-2004",
                      "windows-10-x64-byol",
                      "windows-10-x86-byol",
                      "windows-2008r2",
                      "windows-2008r2-byol",
                      "windows-2012",
                      "windows-2012-byol",
                      "windows-2012r2",
                      "windows-2012r2-byol",
                      "windows-2016",
                      "windows-2016-byol",
                      "windows-2019",
                      "windows-2019-byol",
                      "windows-7-x64-byol",
                      "windows-7-x86-byol",
                      "windows-8-x64-byol",
                      "windows-8-x86-byol"
                    ],
                    "--private-network-ip": "value",
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--source-uri": "value",
                    "--subnet": "value",
                    "--tags": "value",
                    "--timeout": "value",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "dynamic"
                  }
                },
                "move": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination-zone": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "network-interfaces": {
                  "commands": {
                    "get-effective-firewalls": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--network-interface": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--aliases": "value",
                        "--ipv6-network-tier": [
                          "PREMIUM"
                        ],
                        "--network": "value",
                        "--network-interface": "value",
                        "--private-network-ip": "value",
                        "--stack-type": [
                          "IPV4_IPV6",
                          "IPV4_ONLY"
                        ],
                        "--subnetwork": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "ops-agents": {
                  "commands": {
                    "policies": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--agent-rules": "value",
                            "--description": "value",
                            "--group-labels": "value",
                            "--instances": "value",
                            "--os-types": "value",
                            "--zones": "value"
                          }
                        },
                        "delete": {
                          "commands": {},
                          "flags": {}
                        },
                        "describe": {
                          "commands": {},
                          "flags": {}
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value",
                            "--uri": "bool"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--agent-rules": "value",
                            "--clear-group-labels": "bool",
                            "--clear-instances": "bool",
                            "--clear-zones": "bool",
                            "--description": "value",
                            "--etag": "value",
                            "--group-labels": "value",
                            "--instances": "value",
                            "--os-types": "value",
                            "--zones": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "os-inventory": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "list-instances": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--inventory-filter": "value",
                        "--kernel-version": "value",
                        "--limit": "value",
                        "--os-shortname": "value",
                        "--os-version": "value",
                        "--package-name": "value",
                        "--package-version": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "remove-labels": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--labels": "value",
                    "--zone": "dynamic"
                  }
                },
                "remove-metadata": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--keys": "value",
                    "--zone": "dynamic"
                  }
                },
                "remove-resource-policies": {
                  "commands": {},
                  "flags": {
                    "--resource-policies": "value",
                    "--zone": "dynamic"
                  }
                },
                "remove-tags": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--tags": "value",
                    "--zone": "dynamic"
                  }
                },
                "reset": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "resume": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--csek-key-file": "value",
                    "--zone": "dynamic"
                  }
                },
                "send-diagnostic-interrupt": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "set-disk-auto-delete": {
                  "commands": {},
                  "flags": {
                    "--auto-delete": "bool",
                    "--device-name": "value",
                    "--disk": "value",
                    "--zone": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "set-machine-type": {
                  "commands": {},
                  "flags": {
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--machine-type": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "set-min-cpu-platform": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--min-cpu-platform": "value",
                    "--zone": "dynamic"
                  }
                },
                "set-name": {
                  "commands": {},
                  "flags": {
                    "--new-name": "value",
                    "--zone": "dynamic"
                  }
                },
                "set-scheduling": {
                  "commands": {},
                  "flags": {
                    "--clear-min-node-cpu": "bool",
                    "--clear-node-affinities": "bool",
                    "--host-error-timeout-seconds": "value",
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--min-node-cpu": "value",
                    "--node": "value",
                    "--node-affinity-file": "value",
                    "--node-group": "value",
                    "--on-host-maintenance": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--preemptible": "bool",
                    "--restart-on-failure": "bool",
                    "--zone": "dynamic"
                  }
                },
                "set-scopes": {
                  "commands": {},
                  "flags": {
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--zone": "dynamic"
                  }
                },
                "simulate-maintenance-event": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "dynamic"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--csek-key-file": "value",
                    "--zone": "dynamic"
                  }
                },
                "stop": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--discard-local-ssd": "bool",
                    "--zone": "dynamic"
                  }
                },
                "suspend": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--discard-local-ssd": "bool",
                    "--zone": "dynamic"
                  }
                },
                "tail-serial-port-output": {
                  "commands": {},
                  "flags": {
                    "--port": "value",
                    "--zone": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--clear-node-affinities": "bool",
                    "--deletion-protection": "bool",
                    "--enable-display-device": "bool",
                    "--min-cpu-platform": "value",
                    "--node": "value",
                    "--node-affinity-file": "value",
                    "--node-group": "value",
                    "--remove-labels": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-learn-integrity-policy": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--update-labels": "value",
                    "--zone": "dynamic"
                  }
                },
                "update-access-config": {
                  "commands": {},
                  "flags": {
                    "--ipv6-public-ptr-domain": "value",
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-ipv6-public-ptr": "bool",
                    "--no-public-dns": "bool",
                    "--no-public-ptr": "bool",
                    "--no-public-ptr-domain": "bool",
                    "--public-dns": "bool",
                    "--public-ptr": "bool",
                    "--public-ptr-domain": "value",
                    "--zone": "dynamic"
                  }
                },
                "update-container": {
                  "commands": {},
                  "flags": {
                    "--clear-container-args": "bool",
                    "--clear-container-command": "bool",
                    "--container-arg": "value",
                    "--container-command": "value",
                    "--container-env": "value",
                    "--container-env-file": "value",
                    "--container-image": "value",
                    "--container-mount-disk": "value",
                    "--container-mount-host-path": "value",
                    "--container-mount-tmpfs": "value",
                    "--container-privileged": "bool",
                    "--container-restart-policy": [
                      "always",
                      "never",
                      "on-failure"
                    ],
                    "--container-stdin": "bool",
                    "--container-tty": "bool",
                    "--remove-container-env": "value",
                    "--remove-container-mounts": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-learn-integrity-policy": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--zone": "dynamic"
                  }
                },
                "update-from-file": {
                  "commands": {},
                  "flags": {
                    "--clear-secure-tag": "bool",
                    "--minimal-action": "value",
                    "--most-disruptive-allowed-action": "value",
                    "--source": "value",
                    "--zone": "dynamic"
                  }
                },
                "vulnerabilities": {
                  "commands": {
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--instance": "dynamic",
                        "--instance-zone": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "instant-snapshots": {
              "commands": {
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--labels": "value",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--labels": "value",
                    "--region": "dynamic",
                    "--source-disk": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                }
              },
              "flags": {}
            },
            "interconnects": {
              "commands": {
                "attachments": {
                  "commands": {
                    "dedicated": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--bandwidth": [
                              "100m",
                              "10g",
                              "1g",
                              "200m",
                              "20g",
                              "2g",
                              "300m",
                              "400m",
                              "500m",
                              "50g",
                              "50m",
                              "5g"
                            ],
                            "--candidate-ipv6-subnets": "value",
                            "--candidate-subnets": "value",
                            "--cloud-router-ipv6-interface-id": "value",
                            "--customer-router-ipv6-interface-id": "value",
                            "--description": "value",
                            "--dry-run": "bool",
                            "--enable-admin": "bool",
                            "--interconnect": "dynamic",
                            "--mtu": "value",
                            "--region": "dynamic",
                            "--router": "dynamic",
                            "--stack-type": [
                              "IPV4_IPV6",
                              "IPV4_ONLY"
                            ],
                            "--vlan": "value"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--bandwidth": [
                              "100m",
                              "10g",
                              "1g",
                              "200m",
                              "20g",
                              "2g",
                              "300m",
                              "400m",
                              "500m",
                              "50g",
                              "50m",
                              "5g"
                            ],
                            "--candidate-ipv6-subnets": "value",
                            "--clear-labels": "bool",
                            "--cloud-router-ipv6-interface-id": "value",
                            "--customer-router-ipv6-interface-id": "value",
                            "--description": "value",
                            "--enable-admin": "bool",
                            "--mtu": "value",
                            "--region": "dynamic",
                            "--remove-labels": "value",
                            "--stack-type": [
                              "IPV4_IPV6",
                              "IPV4_ONLY"
                            ],
                            "--update-labels": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "partner": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--description": "value",
                            "--dry-run": "bool",
                            "--edge-availability-domain": [
                              "any",
                              "availability-domain-1",
                              "availability-domain-2"
                            ],
                            "--enable-admin": "bool",
                            "--mtu": "value",
                            "--region": "dynamic",
                            "--router": "dynamic"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--clear-labels": "bool",
                            "--description": "value",
                            "--enable-admin": "bool",
                            "--mtu": "value",
                            "--region": "dynamic",
                            "--remove-labels": "value",
                            "--update-labels": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--admin-enabled": "bool",
                    "--customer-name": "value",
                    "--description": "value",
                    "--interconnect-type": [
                      "DEDICATED",
                      "IT_PRIVATE",
                      "PARTNER"
                    ],
                    "--link-type": [
                      "LINK_TYPE_ETHERNET_100G_LR",
                      "LINK_TYPE_ETHERNET_10G_LR"
                    ],
                    "--location": "dynamic",
                    "--noc-contact-email": "value",
                    "--requested-link-count": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-diagnostics": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "locations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "macsec": {
                  "commands": {
                    "add-key": {
                      "commands": {},
                      "flags": {
                        "--key-name": "value",
                        "--start-time": "value"
                      }
                    },
                    "get-config": {
                      "commands": {},
                      "flags": {}
                    },
                    "remove-key": {
                      "commands": {},
                      "flags": {
                        "--key-name": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--enabled": "bool",
                        "--fail-open": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--admin-enabled": "bool",
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--noc-contact-email": "value",
                    "--remove-labels": "value",
                    "--requested-link-count": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "machine-images": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--csek-key-file": "value",
                    "--description": "value",
                    "--guest-flush": "bool",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--require-csek-key-create": "bool",
                    "--source-disk-csek-key": "value",
                    "--source-instance": "dynamic",
                    "--source-instance-zone": "dynamic",
                    "--storage-location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--byol": "bool",
                    "--can-ip-forward": "bool",
                    "--compute-service-account": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--description": "value",
                    "--guest-environment": "bool",
                    "--guest-flush": "bool",
                    "--labels": "value",
                    "--log-location": "value",
                    "--machine-type": "dynamic",
                    "--network": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--os": [
                      "centos-7",
                      "centos-8",
                      "debian-10",
                      "debian-8",
                      "debian-9",
                      "opensuse-15",
                      "rhel-6",
                      "rhel-6-byol",
                      "rhel-7",
                      "rhel-7-byol",
                      "rhel-8",
                      "rhel-8-byol",
                      "sles-12",
                      "sles-12-byol",
                      "sles-15",
                      "sles-15-byol",
                      "sles-sap-12",
                      "sles-sap-12-byol",
                      "sles-sap-15",
                      "sles-sap-15-byol",
                      "ubuntu-1404",
                      "ubuntu-1604",
                      "ubuntu-1804",
                      "ubuntu-2004",
                      "windows-10-x64-byol",
                      "windows-10-x86-byol",
                      "windows-2008r2",
                      "windows-2008r2-byol",
                      "windows-2012",
                      "windows-2012-byol",
                      "windows-2012r2",
                      "windows-2012r2-byol",
                      "windows-2016",
                      "windows-2016-byol",
                      "windows-2019",
                      "windows-2019-byol",
                      "windows-7-x64-byol",
                      "windows-7-x86-byol",
                      "windows-8-x64-byol",
                      "windows-8-x86-byol"
                    ],
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--source-uri": "value",
                    "--storage-location": "value",
                    "--subnet": "value",
                    "--tags": "value",
                    "--timeout": "value",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "machine-types": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "network-endpoint-groups": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--app-engine-app": "bool",
                    "--app-engine-service": "value",
                    "--app-engine-url-mask": "value",
                    "--app-engine-version": "value",
                    "--cloud-function-name": "value",
                    "--cloud-function-url-mask": "value",
                    "--cloud-run-service": "value",
                    "--cloud-run-tag": "value",
                    "--cloud-run-url-mask": "value",
                    "--default-port": "value",
                    "--global": "bool",
                    "--network": "value",
                    "--network-endpoint-type": [
                      "gce-vm-ip",
                      "gce-vm-ip-port",
                      "gce-vm-primary-ip",
                      "internet-fqdn-port",
                      "internet-ip-port",
                      "non-gcp-private-ip-port",
                      "private-service-connect",
                      "serverless"
                    ],
                    "--psc-target-service": "value",
                    "--region": "dynamic",
                    "--serverless-deployment-platform": "value",
                    "--serverless-deployment-resource": "value",
                    "--serverless-deployment-url-mask": "value",
                    "--serverless-deployment-version": "value",
                    "--subnet": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                },
                "list-network-endpoints": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--zone": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-endpoint": "value",
                    "--global": "bool",
                    "--remove-endpoint": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "network-firewall-policies": {
              "commands": {
                "associations": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--firewall-policy-region": "dynamic",
                        "--global-firewall-policy": "bool",
                        "--name": "value",
                        "--network": "value",
                        "--replace-association-on-target": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--firewall-policy-region": "dynamic",
                        "--global-firewall-policy": "bool",
                        "--name": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "clone-rules": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source-firewall-policy": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "rules": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny",
                          "goto_next"
                        ],
                        "--description": "value",
                        "--dest-ip-ranges": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--disabled": "bool",
                        "--enable-logging": "bool",
                        "--firewall-policy": "value",
                        "--firewall-policy-region": "dynamic",
                        "--global-firewall-policy": "bool",
                        "--layer4-configs": "value",
                        "--src-ip-ranges": "value",
                        "--src-secure-tags": "value",
                        "--target-secure-tags": "value",
                        "--target-service-accounts": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--firewall-policy-region": "dynamic",
                        "--global-firewall-policy": "bool"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--firewall-policy-region": "dynamic",
                        "--global-firewall-policy": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny",
                          "goto_next"
                        ],
                        "--description": "value",
                        "--dest-ip-ranges": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--disabled": "bool",
                        "--enable-logging": "bool",
                        "--firewall-policy": "value",
                        "--firewall-policy-region": "dynamic",
                        "--global-firewall-policy": "bool",
                        "--layer4-configs": "value",
                        "--new-priority": "value",
                        "--src-ip-ranges": "value",
                        "--src-secure-tags": "value",
                        "--target-secure-tags": "value",
                        "--target-service-accounts": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "networks": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--bgp-routing-mode": [
                      "global",
                      "regional"
                    ],
                    "--description": "value",
                    "--mtu": "value",
                    "--range": "value",
                    "--subnet-mode": [
                      "auto",
                      "custom",
                      "legacy"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-effective-firewalls": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-ip-addresses": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--types": "value"
                  }
                },
                "list-ip-owners": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--ip-cidr-range": "value",
                    "--limit": "value",
                    "--owner-projects": "value",
                    "--owner-types": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--subnet-name": "value",
                    "--subnet-region": "value",
                    "--uri": "bool"
                  }
                },
                "peerings": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--auto-create-routes": "bool",
                        "--export-custom-routes": "bool",
                        "--export-subnet-routes-with-public-ip": "bool",
                        "--import-custom-routes": "bool",
                        "--import-subnet-routes-with-public-ip": "bool",
                        "--network": "value",
                        "--peer-network": "value",
                        "--peer-project": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--network": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--network": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list-routes": {
                      "commands": {},
                      "flags": {
                        "--direction": [
                          "INCOMING",
                          "OUTGOING"
                        ],
                        "--filter": "value",
                        "--limit": "value",
                        "--network": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--export-custom-routes": "bool",
                        "--export-subnet-routes-with-public-ip": "bool",
                        "--import-custom-routes": "bool",
                        "--import-subnet-routes-with-public-ip": "bool",
                        "--network": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "subnets": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--region": "value",
                        "--role": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--aggregation-interval": [
                          "interval-1-min",
                          "interval-10-min",
                          "interval-15-min",
                          "interval-30-sec",
                          "interval-5-min",
                          "interval-5-sec"
                        ],
                        "--description": "value",
                        "--enable-flow-logs": "bool",
                        "--enable-l2": "bool",
                        "--enable-private-ip-google-access": "bool",
                        "--flow-sampling": "value",
                        "--ipv6-access-type": [
                          "EXTERNAL",
                          "INTERNAL"
                        ],
                        "--logging-aggregation-interval": [
                          "interval-1-min",
                          "interval-10-min",
                          "interval-15-min",
                          "interval-30-sec",
                          "interval-5-min",
                          "interval-5-sec"
                        ],
                        "--logging-filter-expr": "value",
                        "--logging-flow-sampling": "value",
                        "--logging-metadata": [
                          "custom",
                          "exclude-all",
                          "include-all"
                        ],
                        "--logging-metadata-fields": "value",
                        "--metadata": [
                          "exclude-all-metadata",
                          "include-all-metadata"
                        ],
                        "--network": "dynamic",
                        "--private-ipv6-google-access-type": [
                          "disable",
                          "enable-bidirectional-access",
                          "enable-outbound-vm-access"
                        ],
                        "--purpose": [
                          "AGGREGATE",
                          "INTERNAL_HTTPS_LOAD_BALANCER",
                          "PRIVATE",
                          "PRIVATE_SERVICE_CONNECT",
                          "REGIONAL_MANAGED_PROXY"
                        ],
                        "--range": "value",
                        "--region": "dynamic",
                        "--role": [
                          "ACTIVE",
                          "BACKUP"
                        ],
                        "--secondary-range": "value",
                        "--stack-type": [
                          "IPV4_IPV6",
                          "IPV4_ONLY"
                        ],
                        "--vlan": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "expand-ip-range": {
                      "commands": {},
                      "flags": {
                        "--prefix-length": "value",
                        "--region": "dynamic"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--network": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--regions": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list-usable": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--region": "value",
                        "--role": "dynamic"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--region": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--add-secondary-ranges": "value",
                        "--aggregation-interval": [
                          "interval-1-min",
                          "interval-10-min",
                          "interval-15-min",
                          "interval-30-sec",
                          "interval-5-min",
                          "interval-5-sec"
                        ],
                        "--drain-timeout": "value",
                        "--enable-flow-logs": "bool",
                        "--enable-private-ip-google-access": "bool",
                        "--flow-sampling": "value",
                        "--ipv6-access-type": [
                          "EXTERNAL",
                          "INTERNAL"
                        ],
                        "--logging-aggregation-interval": [
                          "interval-1-min",
                          "interval-10-min",
                          "interval-15-min",
                          "interval-30-sec",
                          "interval-5-min",
                          "interval-5-sec"
                        ],
                        "--logging-filter-expr": "value",
                        "--logging-flow-sampling": "value",
                        "--logging-metadata": [
                          "custom",
                          "exclude-all",
                          "include-all"
                        ],
                        "--logging-metadata-fields": "value",
                        "--metadata": [
                          "exclude-all-metadata",
                          "include-all-metadata"
                        ],
                        "--private-ipv6-google-access-type": [
                          "disable",
                          "enable-bidirectional-access",
                          "enable-outbound-vm-access"
                        ],
                        "--purpose": [
                          "REGIONAL_MANAGED_PROXY"
                        ],
                        "--region": "dynamic",
                        "--remove-secondary-ranges": "value",
                        "--role": [
                          "ACTIVE"
                        ],
                        "--stack-type": [
                          "IPV4_IPV6",
                          "IPV4_ONLY"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--bgp-routing-mode": [
                      "global",
                      "regional"
                    ],
                    "--mtu": "value",
                    "--switch-to-custom-subnet-mode": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                }
              },
              "flags": {}
            },
            "org-security-policies": {
              "commands": {
                "associations": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--folder": "value",
                        "--name": "value",
                        "--organization": "value",
                        "--replace-association-on-target": "bool",
                        "--security-policy": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--organization": "value",
                        "--security-policy": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--folder": "value",
                        "--limit": "value",
                        "--organization": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "copy-rules": {
                  "commands": {},
                  "flags": {
                    "--organization": "value",
                    "--source-security-policy": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--folder": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-rules": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "move": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "rules": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny",
                          "goto_next"
                        ],
                        "--description": "value",
                        "--dest-ip-ranges": "value",
                        "--dest-ports": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--enable-logging": "bool",
                        "--layer4-configs": "value",
                        "--organization": "value",
                        "--security-policy": "value",
                        "--src-ip-ranges": "value",
                        "--target-resources": "value",
                        "--target-service-accounts": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--organization": "value",
                        "--security-policy": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--organization": "value",
                        "--security-policy": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny",
                          "goto_next"
                        ],
                        "--description": "value",
                        "--dest-ip-ranges": "value",
                        "--dest-ports": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--enable-logging": "bool",
                        "--layer4-configs": "value",
                        "--new-priority": "value",
                        "--organization": "value",
                        "--security-policy": "value",
                        "--src-ip-ranges": "value",
                        "--target-resources": "value",
                        "--target-service-accounts": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--organization": "value"
                  }
                }
              },
              "flags": {}
            },
            "os-config": {
              "commands": {
                "guest-policies": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--file": "value",
                        "--folder": "value",
                        "--organization": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--folder": "value",
                        "--organization": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--folder": "value",
                        "--organization": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--folder": "value",
                        "--limit": "value",
                        "--organization": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "lookup": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--file": "value",
                        "--folder": "value",
                        "--organization": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "instance-os-policies-compliances": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "inventories": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--view": [
                          "basic",
                          "full"
                        ]
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--view": [
                          "basic",
                          "full"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "os-policy-assignments": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--file": "value",
                        "--location": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list-revisions": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "operations": {
                      "commands": {
                        "cancel": {
                          "commands": {},
                          "flags": {
                            "--location": "value",
                            "--os-policy-assignment": "value"
                          }
                        },
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--location": "value",
                            "--os-policy-assignment": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--file": "value",
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "os-upgrade": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--auto-rollback": "bool",
                    "--create-machine-backup": "bool",
                    "--log-location": "value",
                    "--source-os": [
                      "windows-2008r2"
                    ],
                    "--target-os": [
                      "windows-2012r2"
                    ],
                    "--timeout": "value",
                    "--zone": "dynamic"
                  }
                },
                "patch-deployments": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--file": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {}
                    },
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "patch-jobs": {
                  "commands": {
                    "cancel": {
                      "commands": {},
                      "flags": {}
                    },
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "execute": {
                      "commands": {},
                      "flags": {
                        "--apt-dist": "bool",
                        "--apt-excludes": "value",
                        "--apt-exclusive-packages": "value",
                        "--async": "bool",
                        "--description": "value",
                        "--display-name": "value",
                        "--dry-run": "bool",
                        "--duration": "value",
                        "--instance-filter": "value",
                        "--instance-filter-all": "bool",
                        "--instance-filter-group-labels": "value",
                        "--instance-filter-name-prefixes": "value",
                        "--instance-filter-names": "value",
                        "--instance-filter-zones": "value",
                        "--post-patch-linux-executable": "value",
                        "--post-patch-linux-success-codes": "value",
                        "--post-patch-windows-executable": "value",
                        "--post-patch-windows-success-codes": "value",
                        "--pre-patch-linux-executable": "value",
                        "--pre-patch-linux-success-codes": "value",
                        "--pre-patch-windows-executable": "value",
                        "--pre-patch-windows-success-codes": "value",
                        "--reboot-config": [
                          "always",
                          "default",
                          "never"
                        ],
                        "--retry": "bool",
                        "--rollout-disruption-budget": "value",
                        "--rollout-disruption-budget-percent": "value",
                        "--rollout-mode": [
                          "concurrent-zones",
                          "zone-by-zone"
                        ],
                        "--windows-classifications": "value",
                        "--windows-excludes": "value",
                        "--windows-exclusive-patches": "value",
                        "--yum-excludes": "value",
                        "--yum-exclusive-packages": "value",
                        "--yum-minimal": "bool",
                        "--yum-security": "bool",
                        "--zypper-categories": "value",
                        "--zypper-exclusive-patches": "value",
                        "--zypper-severities": "value",
                        "--zypper-with-optional": "bool",
                        "--zypper-with-update": "bool"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list-instance-details": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "vulnerability-reports": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "os-login": {
              "commands": {
                "describe-profile": {
                  "commands": {},
                  "flags": {}
                },
                "remove-profile": {
                  "commands": {},
                  "flags": {
                    "--operating-system": [
                      "linux",
                      "windows"
                    ]
                  }
                },
                "ssh-keys": {
                  "commands": {
                    "add": {
                      "commands": {},
                      "flags": {
                        "--key": "value",
                        "--key-file": "value",
                        "--ttl": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--key": "value",
                        "--key-file": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "remove": {
                      "commands": {},
                      "flags": {
                        "--key": "value",
                        "--key-file": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--key": "value",
                        "--key-file": "value",
                        "--ttl": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "packet-mirrorings": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--collector-ilb": "value",
                    "--description": "value",
                    "--enable": "bool",
                    "--filter-cidr-ranges": "value",
                    "--filter-direction": [
                      "both",
                      "egress",
                      "ingress"
                    ],
                    "--filter-protocols": "value",
                    "--mirrored-instances": "value",
                    "--mirrored-subnets": "value",
                    "--mirrored-tags": "value",
                    "--network": "value",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-filter-cidr-ranges": "value",
                    "--add-filter-protocols": "value",
                    "--add-mirrored-instances": "value",
                    "--add-mirrored-subnets": "value",
                    "--add-mirrored-tags": "value",
                    "--async": "bool",
                    "--clear-filter-cidr-ranges": "bool",
                    "--clear-filter-protocols": "bool",
                    "--clear-mirrored-instances": "bool",
                    "--clear-mirrored-subnets": "bool",
                    "--clear-mirrored-tags": "bool",
                    "--collector-ilb": "value",
                    "--description": "value",
                    "--enable": "bool",
                    "--filter-direction": [
                      "both",
                      "egress",
                      "ingress"
                    ],
                    "--region": "dynamic",
                    "--remove-filter-cidr-ranges": "value",
                    "--remove-filter-protocols": "value",
                    "--remove-mirrored-instances": "value",
                    "--remove-mirrored-subnets": "value",
                    "--remove-mirrored-tags": "value",
                    "--set-filter-cidr-ranges": "value",
                    "--set-filter-protocols": "value",
                    "--set-mirrored-instances": "value",
                    "--set-mirrored-subnets": "value",
                    "--set-mirrored-tags": "value"
                  }
                }
              },
              "flags": {}
            },
            "project-info": {
              "commands": {
                "add-metadata": {
                  "commands": {},
                  "flags": {
                    "--metadata": "value",
                    "--metadata-from-file": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "remove-metadata": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--keys": "value"
                  }
                },
                "set-default-service-account": {
                  "commands": {},
                  "flags": {
                    "--no-service-account": "bool",
                    "--service-account": "value"
                  }
                },
                "set-usage-bucket": {
                  "commands": {},
                  "flags": {
                    "--bucket": "value",
                    "--no-bucket": "bool",
                    "--prefix": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--default-network-tier": [
                      "PREMIUM",
                      "STANDARD"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "public-advertised-prefixes": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--dns-verification-ip": "value",
                    "--range": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--status": [
                      "ptr-configured"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "public-delegated-prefixes": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--enable-live-migration": "bool",
                    "--global": "bool",
                    "--public-advertised-prefix": "value",
                    "--range": "value",
                    "--region": "dynamic"
                  }
                },
                "delegated-sub-prefixes": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--create-addresses": "bool",
                        "--delegatee-project": "value",
                        "--description": "value",
                        "--global-public-delegated-prefix": "bool",
                        "--public-delegated-prefix": "value",
                        "--public-delegated-prefix-region": "dynamic",
                        "--range": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--global-public-delegated-prefix": "bool",
                        "--public-delegated-prefix": "value",
                        "--public-delegated-prefix-region": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "regions": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "reservations": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--description": "value",
                    "--local-ssd": "value",
                    "--machine-type": "value",
                    "--maintenance-freeze-duration": "value",
                    "--maintenance-interval": [
                      "PERIODIC"
                    ],
                    "--min-cpu-platform": "value",
                    "--require-specific-reservation": "bool",
                    "--share-setting": [
                      "folders",
                      "organization",
                      "projects"
                    ],
                    "--share-with": "value",
                    "--vm-count": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--share-with": "value",
                    "--vm-count": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "reset-windows-password": {
              "commands": {},
              "flags": {
                "--user": "value",
                "--zone": "dynamic"
              }
            },
            "resource-policies": {
              "commands": {
                "create": {
                  "commands": {
                    "group-placement": {
                      "commands": {},
                      "flags": {
                        "--availability-domain-count": "value",
                        "--collocation": [
                          "clustered",
                          "collocated",
                          "unspecified-collocation"
                        ],
                        "--description": "value",
                        "--region": "dynamic",
                        "--scope": [
                          "host",
                          "unspecified-scope"
                        ],
                        "--vm-count": "value"
                      }
                    },
                    "instance-schedule": {
                      "commands": {},
                      "flags": {
                        "--description": "value",
                        "--end-date": "value",
                        "--initiation-date": "value",
                        "--region": "dynamic",
                        "--timezone": "value",
                        "--vm-start-schedule": "value",
                        "--vm-stop-schedule": "value"
                      }
                    },
                    "snapshot-schedule": {
                      "commands": {},
                      "flags": {
                        "--daily-schedule": "bool",
                        "--description": "value",
                        "--guest-flush": "bool",
                        "--hourly-schedule": "value",
                        "--max-retention-days": "value",
                        "--on-source-disk-delete": [
                          "apply-retention-policy",
                          "keep-auto-snapshots"
                        ],
                        "--region": "dynamic",
                        "--snapshot-labels": "value",
                        "--start-time": "value",
                        "--storage-location": "value",
                        "--weekly-schedule": [
                          "friday",
                          "monday",
                          "saturday",
                          "sunday",
                          "thursday",
                          "tuesday",
                          "wednesday"
                        ],
                        "--weekly-schedule-from-file": "value"
                      }
                    },
                    "vm-maintenance": {
                      "commands": {
                        "concurrency-limit": {
                          "commands": {},
                          "flags": {
                            "--description": "value",
                            "--max-percent": "value",
                            "--region": "dynamic"
                          }
                        },
                        "maintenance-window": {
                          "commands": {},
                          "flags": {
                            "--daily-window": "bool",
                            "--description": "value",
                            "--region": "dynamic",
                            "--start-time": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "create-snapshot-schedule": {
                  "commands": {},
                  "flags": {
                    "--daily-schedule": "bool",
                    "--description": "value",
                    "--guest-flush": "bool",
                    "--hourly-schedule": "value",
                    "--max-retention-days": "value",
                    "--on-source-disk-delete": [
                      "apply-retention-policy",
                      "keep-auto-snapshots"
                    ],
                    "--region": "dynamic",
                    "--snapshot-labels": "value",
                    "--start-time": "value",
                    "--storage-location": "value",
                    "--weekly-schedule": [
                      "friday",
                      "monday",
                      "saturday",
                      "sunday",
                      "thursday",
                      "tuesday",
                      "wednesday"
                    ],
                    "--weekly-schedule-from-file": "value"
                  }
                },
                "create-vm-maintenance": {
                  "commands": {},
                  "flags": {
                    "--daily-window": "bool",
                    "--description": "value",
                    "--region": "dynamic",
                    "--start-time": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                }
              },
              "flags": {}
            },
            "routers": {
              "commands": {
                "add-bgp-peer": {
                  "commands": {},
                  "flags": {
                    "--advertised-route-priority": "value",
                    "--advertisement-mode": [
                      "CUSTOM",
                      "DEFAULT"
                    ],
                    "--async": "bool",
                    "--enable-ipv6": "bool",
                    "--enabled": "bool",
                    "--instance": "dynamic",
                    "--instance-zone": "dynamic",
                    "--interface": "value",
                    "--ipv6-nexthop-address": "value",
                    "--peer-asn": "value",
                    "--peer-ip-address": "value",
                    "--peer-ipv6-nexthop-address": "value",
                    "--peer-name": "value",
                    "--region": "dynamic",
                    "--set-advertisement-groups": "value",
                    "--set-advertisement-ranges": "value"
                  }
                },
                "add-interface": {
                  "commands": {},
                  "flags": {
                    "--interconnect-attachment": "dynamic",
                    "--interconnect-attachment-region": "dynamic",
                    "--interface-name": "value",
                    "--ip-address": "value",
                    "--mask-length": "value",
                    "--redundant-interface": "value",
                    "--region": "dynamic",
                    "--subnetwork": "dynamic",
                    "--subnetwork-region": "dynamic",
                    "--vpn-tunnel": "dynamic",
                    "--vpn-tunnel-region": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--advertisement-mode": [
                      "CUSTOM",
                      "DEFAULT"
                    ],
                    "--asn": "value",
                    "--async": "bool",
                    "--description": "value",
                    "--keepalive-interval": "value",
                    "--network": "dynamic",
                    "--region": "dynamic",
                    "--set-advertisement-groups": "value",
                    "--set-advertisement-ranges": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "get-nat-mapping-info": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--nat-name": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value"
                  }
                },
                "get-status": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "nats": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--auto-allocate-nat-external-ips": "bool",
                        "--enable-dynamic-port-allocation": "bool",
                        "--enable-endpoint-independent-mapping": "bool",
                        "--enable-logging": "bool",
                        "--icmp-idle-timeout": "value",
                        "--log-filter": [
                          "ALL",
                          "ERRORS_ONLY",
                          "TRANSLATIONS_ONLY"
                        ],
                        "--max-ports-per-vm": "value",
                        "--min-ports-per-vm": "value",
                        "--nat-all-subnet-ip-ranges": "bool",
                        "--nat-custom-subnet-ip-ranges": "value",
                        "--nat-external-ip-pool": "value",
                        "--nat-primary-subnet-ip-ranges": "bool",
                        "--region": "dynamic",
                        "--router": "dynamic",
                        "--rules": "value",
                        "--tcp-established-idle-timeout": "value",
                        "--tcp-time-wait-timeout": "value",
                        "--tcp-transitory-idle-timeout": "value",
                        "--udp-idle-timeout": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--router": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--router": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--router": "dynamic"
                      }
                    },
                    "rules": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--async": "bool",
                            "--match": "value",
                            "--nat": "value",
                            "--region": "dynamic",
                            "--router": "dynamic",
                            "--source-nat-active-ips": "value"
                          }
                        },
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--nat": "value",
                            "--region": "dynamic",
                            "--router": "dynamic"
                          }
                        },
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--nat": "value",
                            "--region": "dynamic",
                            "--router": "dynamic"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--nat": "value",
                            "--region": "dynamic",
                            "--router": "dynamic"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--async": "bool",
                            "--clear-source-nat-drain-ips": "bool",
                            "--match": "value",
                            "--nat": "value",
                            "--region": "dynamic",
                            "--router": "dynamic",
                            "--source-nat-active-ips": "value",
                            "--source-nat-drain-ips": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--auto-allocate-nat-external-ips": "bool",
                        "--clear-icmp-idle-timeout": "bool",
                        "--clear-max-ports-per-vm": "bool",
                        "--clear-min-ports-per-vm": "bool",
                        "--clear-nat-external-drain-ip-pool": "bool",
                        "--clear-tcp-established-idle-timeout": "bool",
                        "--clear-tcp-time-wait-timeout": "bool",
                        "--clear-tcp-transitory-idle-timeout": "bool",
                        "--clear-udp-idle-timeout": "bool",
                        "--enable-dynamic-port-allocation": "bool",
                        "--enable-endpoint-independent-mapping": "bool",
                        "--enable-logging": "bool",
                        "--icmp-idle-timeout": "value",
                        "--log-filter": [
                          "ALL",
                          "ERRORS_ONLY",
                          "TRANSLATIONS_ONLY"
                        ],
                        "--max-ports-per-vm": "value",
                        "--min-ports-per-vm": "value",
                        "--nat-all-subnet-ip-ranges": "bool",
                        "--nat-custom-subnet-ip-ranges": "value",
                        "--nat-external-drain-ip-pool": "value",
                        "--nat-external-ip-pool": "value",
                        "--nat-primary-subnet-ip-ranges": "bool",
                        "--region": "dynamic",
                        "--router": "dynamic",
                        "--rules": "value",
                        "--tcp-established-idle-timeout": "value",
                        "--tcp-time-wait-timeout": "value",
                        "--tcp-transitory-idle-timeout": "value",
                        "--udp-idle-timeout": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "remove-bgp-peer": {
                  "commands": {},
                  "flags": {
                    "--peer-name": "value",
                    "--peer-names": "value",
                    "--region": "dynamic"
                  }
                },
                "remove-interface": {
                  "commands": {},
                  "flags": {
                    "--interface-name": "value",
                    "--interface-names": "value",
                    "--region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-advertisement-groups": "value",
                    "--add-advertisement-ranges": "value",
                    "--advertisement-mode": [
                      "CUSTOM",
                      "DEFAULT"
                    ],
                    "--asn": "value",
                    "--async": "bool",
                    "--keepalive-interval": "value",
                    "--region": "dynamic",
                    "--remove-advertisement-groups": "value",
                    "--remove-advertisement-ranges": "value",
                    "--set-advertisement-groups": "value",
                    "--set-advertisement-ranges": "value"
                  }
                },
                "update-bgp-peer": {
                  "commands": {},
                  "flags": {
                    "--add-advertisement-groups": "value",
                    "--add-advertisement-ranges": "value",
                    "--advertised-route-priority": "value",
                    "--advertisement-mode": [
                      "CUSTOM",
                      "DEFAULT"
                    ],
                    "--async": "bool",
                    "--enable-ipv6": "bool",
                    "--enabled": "bool",
                    "--interface": "value",
                    "--ip-address": "value",
                    "--ipv6-nexthop-address": "value",
                    "--peer-asn": "value",
                    "--peer-ip-address": "value",
                    "--peer-ipv6-nexthop-address": "value",
                    "--peer-name": "value",
                    "--region": "dynamic",
                    "--remove-advertisement-groups": "value",
                    "--remove-advertisement-ranges": "value",
                    "--set-advertisement-groups": "value",
                    "--set-advertisement-ranges": "value"
                  }
                },
                "update-interface": {
                  "commands": {},
                  "flags": {
                    "--interconnect-attachment": "dynamic",
                    "--interconnect-attachment-region": "dynamic",
                    "--interface-name": "value",
                    "--ip-address": "value",
                    "--mask-length": "value",
                    "--region": "dynamic",
                    "--vpn-tunnel": "dynamic",
                    "--vpn-tunnel-region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "routes": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--destination-range": "value",
                    "--network": "value",
                    "--next-hop-address": "value",
                    "--next-hop-gateway": "dynamic",
                    "--next-hop-ilb": "value",
                    "--next-hop-ilb-region": "value",
                    "--next-hop-instance": "value",
                    "--next-hop-instance-zone": "value",
                    "--next-hop-vpn-tunnel": "value",
                    "--next-hop-vpn-tunnel-region": "value",
                    "--priority": "value",
                    "--tags": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "scp": {
              "commands": {},
              "flags": {
                "--compress": "bool",
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--internal-ip": "bool",
                "--network": "value",
                "--plain": "bool",
                "--port": "value",
                "--recurse": "bool",
                "--region": "value",
                "--scp-flag": "value",
                "--ssh-key-expiration": "value",
                "--ssh-key-expire-after": "value",
                "--ssh-key-file": "value",
                "--strict-host-key-checking": [
                  "ask",
                  "no",
                  "yes"
                ],
                "--tunnel-through-iap": "bool",
                "--zone": "value"
              }
            },
            "security-policies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--file-format": [
                      "json",
                      "yaml"
                    ],
                    "--file-name": "value",
                    "--type": [
                      "CLOUD_ARMOR",
                      "CLOUD_ARMOR_EDGE"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--file-format": [
                      "json",
                      "yaml"
                    ],
                    "--file-name": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--file-format": [
                      "json",
                      "yaml"
                    ],
                    "--file-name": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-preconfigured-expression-sets": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "rules": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny",
                          "deny-403",
                          "deny-404",
                          "deny-502",
                          "rate-based-ban",
                          "redirect",
                          "redirect-to-recaptcha",
                          "throttle"
                        ],
                        "--ban-duration-sec": "value",
                        "--ban-threshold-count": "value",
                        "--ban-threshold-interval-sec": "value",
                        "--conform-action": [
                          "allow"
                        ],
                        "--description": "value",
                        "--enforce-on-key": [
                          "all",
                          "http-header",
                          "ip",
                          "xff-ip"
                        ],
                        "--enforce-on-key-name": "value",
                        "--exceed-action": [
                          "deny",
                          "deny-403",
                          "deny-404",
                          "deny-429",
                          "deny-502"
                        ],
                        "--expression": "value",
                        "--preview": "bool",
                        "--rate-limit-threshold-count": "value",
                        "--rate-limit-threshold-interval-sec": "value",
                        "--redirect-target": "value",
                        "--redirect-type": [
                          "external-302",
                          "google-recaptcha"
                        ],
                        "--request-headers-to-add": "value",
                        "--security-policy": "dynamic",
                        "--src-ip-ranges": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--security-policy": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--security-policy": "dynamic"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny",
                          "deny-403",
                          "deny-404",
                          "deny-502",
                          "rate-based-ban",
                          "redirect",
                          "redirect-to-recaptcha",
                          "throttle"
                        ],
                        "--ban-duration-sec": "value",
                        "--ban-threshold-count": "value",
                        "--ban-threshold-interval-sec": "value",
                        "--conform-action": [
                          "allow"
                        ],
                        "--description": "value",
                        "--enforce-on-key": [
                          "all",
                          "http-header",
                          "ip",
                          "xff-ip"
                        ],
                        "--enforce-on-key-name": "value",
                        "--exceed-action": [
                          "deny",
                          "deny-403",
                          "deny-404",
                          "deny-429",
                          "deny-502"
                        ],
                        "--expression": "value",
                        "--preview": "bool",
                        "--rate-limit-threshold-count": "value",
                        "--rate-limit-threshold-interval-sec": "value",
                        "--redirect-target": "value",
                        "--redirect-type": [
                          "external-302",
                          "google-recaptcha"
                        ],
                        "--request-headers-to-add": "value",
                        "--security-policy": "dynamic",
                        "--src-ip-ranges": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--enable-layer7-ddos-defense": "bool",
                    "--enable-ml": "bool",
                    "--json-parsing": [
                      "DISABLED",
                      "STANDARD"
                    ],
                    "--layer7-ddos-defense-rule-visibility": [
                      "PREMIUM",
                      "STANDARD"
                    ],
                    "--log-level": [
                      "NORMAL",
                      "VERBOSE"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "service-attachments": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--connection-preference": [
                      "ACCEPT_AUTOMATIC",
                      "ACCEPT_MANUAL"
                    ],
                    "--consumer-accept-list": "value",
                    "--consumer-reject-list": "value",
                    "--description": "value",
                    "--enable-proxy-protocol": "bool",
                    "--nat-subnets": "dynamic",
                    "--nat-subnets-region": "dynamic",
                    "--producer-forwarding-rule": "dynamic",
                    "--producer-forwarding-rule-region": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--connection-preference": [
                      "ACCEPT_AUTOMATIC",
                      "ACCEPT_MANUAL"
                    ],
                    "--consumer-accept-list": "value",
                    "--consumer-reject-list": "value",
                    "--enable-proxy-protocol": "bool",
                    "--nat-subnets": "dynamic",
                    "--nat-subnets-region": "dynamic",
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "shared-vpc": {
              "commands": {
                "associated-projects": {
                  "commands": {
                    "add": {
                      "commands": {},
                      "flags": {
                        "--host-project": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove": {
                      "commands": {},
                      "flags": {
                        "--host-project": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "disable": {
                  "commands": {},
                  "flags": {}
                },
                "enable": {
                  "commands": {},
                  "flags": {}
                },
                "get-host-project": {
                  "commands": {},
                  "flags": {}
                },
                "list-associated-resources": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "organizations": {
                  "commands": {
                    "list-host-projects": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "sign-url": {
              "commands": {},
              "flags": {
                "--expires-in": "value",
                "--key-file": "value",
                "--key-name": "value",
                "--validate": "bool"
              }
            },
            "snapshots": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--labels": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--chain-name": "value",
                    "--csek-key-file": "value",
                    "--description": "value",
                    "--guest-flush": "bool",
                    "--labels": "value",
                    "--source-disk": "dynamic",
                    "--source-disk-key-file": "value",
                    "--source-disk-region": "dynamic",
                    "--source-disk-zone": "dynamic",
                    "--storage-location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "remove-labels": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--labels": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "sole-tenancy": {
              "commands": {
                "node-groups": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--role": "dynamic",
                        "--zone": "value"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--autoscaler-mode": [
                          "off",
                          "on",
                          "only-scale-out"
                        ],
                        "--description": "value",
                        "--maintenance-policy": [
                          "default",
                          "migrate-within-node-group",
                          "restart-in-place"
                        ],
                        "--maintenance-window-start-time": "value",
                        "--max-nodes": "value",
                        "--min-nodes": "value",
                        "--node-template": "value",
                        "--share-setting": "value",
                        "--target-size": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--zone": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list-nodes": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--role": "dynamic",
                        "--zone": "value"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--zone": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--add-nodes": "value",
                        "--autoscaler-mode": [
                          "off",
                          "on",
                          "only-scale-out"
                        ],
                        "--delete-nodes": "value",
                        "--max-nodes": "value",
                        "--min-nodes": "value",
                        "--node-template": "value",
                        "--share-setting": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "node-templates": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--region": "value",
                        "--role": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--accelerator": "value",
                        "--cpu-overcommit-type": [
                          "enabled",
                          "none"
                        ],
                        "--description": "value",
                        "--disk": "value",
                        "--node-affinity-labels": "value",
                        "--node-requirements": "value",
                        "--node-type": "value",
                        "--region": "dynamic",
                        "--server-binding": [
                          "restart-node-on-any-server",
                          "restart-node-on-minimal-servers"
                        ]
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--region": "value",
                        "--role": "dynamic"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--region": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "node-types": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "ssh": {
              "commands": {},
              "flags": {
                "--command": "value",
                "--container": "value",
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--internal-ip": "bool",
                "--network": "value",
                "--plain": "bool",
                "--region": "value",
                "--ssh-flag": "value",
                "--ssh-key-expiration": "value",
                "--ssh-key-expire-after": "value",
                "--ssh-key-file": "value",
                "--strict-host-key-checking": [
                  "ask",
                  "no",
                  "yes"
                ],
                "--troubleshoot": "bool",
                "--tunnel-through-iap": "bool",
                "--zone": "dynamic"
              }
            },
            "ssl-certificates": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--certificate": "value",
                    "--description": "value",
                    "--domains": "value",
                    "--global": "bool",
                    "--private-key": "value",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "ssl-policies": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--custom-features": "value",
                    "--description": "value",
                    "--min-tls-version": [
                      "1.0",
                      "1.1",
                      "1.2"
                    ],
                    "--profile": [
                      "COMPATIBLE",
                      "CUSTOM",
                      "MODERN",
                      "RESTRICTED"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-available-features": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--custom-features": "value",
                    "--min-tls-version": [
                      "1.0",
                      "1.1",
                      "1.2"
                    ],
                    "--profile": [
                      "COMPATIBLE",
                      "CUSTOM",
                      "MODERN",
                      "RESTRICTED"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "start-iap-tunnel": {
              "commands": {},
              "flags": {
                "--iap-tunnel-disable-connection-check": "bool",
                "--local-host-port": "value",
                "--network": "value",
                "--region": "value",
                "--zone": "dynamic"
              }
            },
            "target-grpc-proxies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--url-map": "dynamic",
                    "--validate-for-proxyless": "bool"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "target-http-proxies": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--global": "bool",
                        "--path": "value",
                        "--region": "dynamic",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--global": "bool",
                    "--global-url-map": "bool",
                    "--proxy-bind": "bool",
                    "--region": "dynamic",
                    "--url-map": "dynamic",
                    "--url-map-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--global-url-map": "bool",
                    "--region": "dynamic",
                    "--url-map": "dynamic",
                    "--url-map-region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-https-proxies": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--global": "bool",
                    "--global-ssl-certificates": "bool",
                    "--global-url-map": "bool",
                    "--proxy-bind": "bool",
                    "--quic-override": [
                      "DISABLE",
                      "ENABLE",
                      "NONE"
                    ],
                    "--region": "dynamic",
                    "--ssl-certificates": "dynamic",
                    "--ssl-certificates-region": "dynamic",
                    "--ssl-policy": "dynamic",
                    "--url-map": "dynamic",
                    "--url-map-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-ssl-policy": "bool",
                    "--global": "bool",
                    "--global-ssl-certificates": "bool",
                    "--global-url-map": "bool",
                    "--quic-override": [
                      "DISABLE",
                      "ENABLE",
                      "NONE"
                    ],
                    "--region": "dynamic",
                    "--ssl-certificates": "dynamic",
                    "--ssl-certificates-region": "dynamic",
                    "--ssl-policy": "dynamic",
                    "--url-map": "dynamic",
                    "--url-map-region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-instances": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--instance": "dynamic",
                    "--instance-zone": "dynamic",
                    "--network": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-pools": {
              "commands": {
                "add-health-checks": {
                  "commands": {},
                  "flags": {
                    "--http-health-check": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "add-instances": {
                  "commands": {},
                  "flags": {
                    "--instances": "dynamic",
                    "--instances-zone": "dynamic",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--backup-pool": "value",
                    "--description": "value",
                    "--failover-ratio": "value",
                    "--health-check": "value",
                    "--http-health-check": "dynamic",
                    "--region": "dynamic",
                    "--session-affinity": [
                      "CLIENT_IP",
                      "CLIENT_IP_PROTO",
                      "NONE"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "get-health": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-health-checks": {
                  "commands": {},
                  "flags": {
                    "--http-health-check": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "remove-instances": {
                  "commands": {},
                  "flags": {
                    "--instances": "dynamic",
                    "--instances-zone": "dynamic",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "set-backup": {
                  "commands": {},
                  "flags": {
                    "--backup-pool": "dynamic",
                    "--failover-ratio": "value",
                    "--no-backup-pool": "bool",
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-ssl-proxies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "dynamic",
                    "--description": "value",
                    "--proxy-header": [
                      "NONE",
                      "PROXY_V1"
                    ],
                    "--ssl-certificates": "dynamic",
                    "--ssl-policy": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "dynamic",
                    "--clear-ssl-policy": "bool",
                    "--proxy-header": [
                      "NONE",
                      "PROXY_V1"
                    ],
                    "--ssl-certificates": "dynamic",
                    "--ssl-policy": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-tcp-proxies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "dynamic",
                    "--description": "value",
                    "--proxy-bind": "bool",
                    "--proxy-header": [
                      "NONE",
                      "PROXY_V1"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "dynamic",
                    "--proxy-header": [
                      "NONE",
                      "PROXY_V1"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "target-vpn-gateways": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--network": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "tpus": {
              "commands": {
                "accelerator-types": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator-type": "value",
                    "--async": "bool",
                    "--description": "value",
                    "--model-base-path": "value",
                    "--model-config-file": "value",
                    "--model-name": "value",
                    "--network": "value",
                    "--platform-config-file": "value",
                    "--preemptible": "bool",
                    "--range": "value",
                    "--reserved": "bool",
                    "--use-service-networking": "bool",
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "execution-groups": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--accelerator-type": "value",
                        "--disk-size": "value",
                        "--dry-run": "bool",
                        "--forward-ports": "bool",
                        "--gce-image": "value",
                        "--machine-type": "value",
                        "--name": "value",
                        "--network": "value",
                        "--preemptible": "bool",
                        "--preemptible-vm": "bool",
                        "--tf-version": "value",
                        "--tpu-only": "bool",
                        "--use-dl-images": "bool",
                        "--use-with-notebook": "bool",
                        "--vm-only": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--tpu-only": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "resume": {
                      "commands": {},
                      "flags": {
                        "--accelerator-type": "value",
                        "--network": "value",
                        "--preemptible": "bool",
                        "--tf-version": "value",
                        "--vm-only": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "suspend": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "dynamic"
                  }
                },
                "locations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "reimage": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "stop": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "tpu-vm": {
                  "commands": {
                    "accelerator-types": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--zone": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value",
                            "--zone": "dynamic"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--accelerator-type": "value",
                        "--async": "bool",
                        "--data-disk": "value",
                        "--description": "value",
                        "--internal-ips": "bool",
                        "--labels": "value",
                        "--metadata": "value",
                        "--metadata-from-file": "value",
                        "--network": "value",
                        "--preemptible": "bool",
                        "--range": "value",
                        "--reserved": "bool",
                        "--scopes": "value",
                        "--service-account": "value",
                        "--subnetwork": "value",
                        "--tags": "value",
                        "--zone": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--zone": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "value"
                      }
                    },
                    "get-guest-attributes": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--query-path": "value",
                        "--sort-by": "value",
                        "--zone": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "scp": {
                      "commands": {},
                      "flags": {
                        "--compress": "bool",
                        "--dry-run": "bool",
                        "--force-key-file-overwrite": "bool",
                        "--internal-ip": "bool",
                        "--plain": "bool",
                        "--recurse": "bool",
                        "--scp-flag": "value",
                        "--ssh-key-expiration": "value",
                        "--ssh-key-expire-after": "value",
                        "--ssh-key-file": "value",
                        "--strict-host-key-checking": [
                          "ask",
                          "no",
                          "yes"
                        ],
                        "--worker": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "service-identity": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--zone": "dynamic"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "ssh": {
                      "commands": {},
                      "flags": {
                        "--command": "value",
                        "--dry-run": "bool",
                        "--force-key-file-overwrite": "bool",
                        "--internal-ip": "bool",
                        "--output-directory": "value",
                        "--plain": "bool",
                        "--ssh-flag": "value",
                        "--ssh-key-expiration": "value",
                        "--ssh-key-expire-after": "value",
                        "--ssh-key-file": "value",
                        "--strict-host-key-checking": [
                          "ask",
                          "no",
                          "yes"
                        ],
                        "--worker": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "start": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--zone": "value"
                      }
                    },
                    "stop": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--zone": "value"
                      }
                    },
                    "versions": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--zone": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value",
                            "--zone": "dynamic"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "versions": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "url-maps": {
              "commands": {
                "add-host-rule": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--global": "bool",
                    "--hosts": "value",
                    "--path-matcher-name": "value",
                    "--region": "dynamic"
                  }
                },
                "add-path-matcher": {
                  "commands": {},
                  "flags": {
                    "--backend-bucket-path-rules": "value",
                    "--backend-service-path-rules": "value",
                    "--default-backend-bucket": "value",
                    "--default-service": "value",
                    "--delete-orphaned-path-matcher": "bool",
                    "--description": "value",
                    "--existing-host": "value",
                    "--global": "bool",
                    "--new-hosts": "value",
                    "--path-matcher-name": "value",
                    "--path-rules": "value",
                    "--region": "dynamic"
                  }
                },
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--global": "bool",
                        "--path": "value",
                        "--region": "dynamic",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--default-backend-bucket": "value",
                    "--default-service": "value",
                    "--description": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "edit": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "invalidate-cdn-cache": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--global": "bool",
                    "--host": "value",
                    "--path": "value",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-cdn-cache-invalidations": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--limit": "value",
                    "--region": "dynamic"
                  }
                },
                "remove-host-rule": {
                  "commands": {},
                  "flags": {
                    "--delete-orphaned-path-matcher": "bool",
                    "--global": "bool",
                    "--host": "value",
                    "--region": "dynamic"
                  }
                },
                "remove-path-matcher": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--path-matcher-name": "value",
                    "--region": "dynamic"
                  }
                },
                "set-default-service": {
                  "commands": {},
                  "flags": {
                    "--default-backend-bucket": "value",
                    "--default-service": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "validate": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "value",
                    "--source": "value"
                  }
                }
              },
              "flags": {}
            },
            "vpn-gateways": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--network": "dynamic",
                    "--region": "dynamic",
                    "--stack-type": [
                      "IPV4_IPV6",
                      "IPV4_ONLY"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "get-status": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "vpn-tunnels": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--ike-version": [
                      1,
                      2
                    ],
                    "--interface": [
                      0,
                      1
                    ],
                    "--local-traffic-selector": "value",
                    "--peer-address": "value",
                    "--peer-external-gateway": "dynamic",
                    "--peer-external-gateway-interface": [
                      0,
                      1,
                      2,
                      3
                    ],
                    "--peer-gcp-gateway": "dynamic",
                    "--peer-gcp-gateway-region": "dynamic",
                    "--region": "dynamic",
                    "--remote-traffic-selector": "value",
                    "--router": "dynamic",
                    "--router-region": "dynamic",
                    "--shared-secret": "value",
                    "--target-vpn-gateway": "dynamic",
                    "--target-vpn-gateway-region": "dynamic",
                    "--vpn-gateway": "dynamic",
                    "--vpn-gateway-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "zones": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "config": {
          "commands": {
            "configurations": {
              "commands": {
                "activate": {
                  "commands": {},
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--activate": "bool"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--all": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--all": "bool",
                "--filter": "value",
                "--limit": "value",
                "--sort-by": "value"
              }
            },
            "set": {
              "commands": {},
              "flags": {
                "--installation": "bool"
              }
            },
            "unset": {
              "commands": {},
              "flags": {
                "--installation": "bool"
              }
            }
          },
          "flags": {}
        },
        "container": {
          "commands": {
            "aws": {
              "commands": {
                "clusters": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--aws-region": "value",
                        "--cluster-version": "value",
                        "--database-encryption-kms-key-arn": "value",
                        "--iam-instance-profile": "value",
                        "--instance-type": "value",
                        "--location": "value",
                        "--main-volume-iops": "value",
                        "--main-volume-kms-key-arn": "value",
                        "--main-volume-size": "value",
                        "--main-volume-type": [
                          "gp2",
                          "gp3"
                        ],
                        "--pod-address-cidr-blocks": "value",
                        "--proxy-secret-arn": "value",
                        "--proxy-secret-version-id": "value",
                        "--role-arn": "value",
                        "--role-session-name": "value",
                        "--root-volume-iops": "value",
                        "--root-volume-kms-key-arn": "value",
                        "--root-volume-size": "value",
                        "--root-volume-type": [
                          "gp2",
                          "gp3"
                        ],
                        "--security-group-ids": "value",
                        "--service-address-cidr-blocks": "value",
                        "--service-load-balancer-subnet-ids": "value",
                        "--ssh-ec2-key-pair": "value",
                        "--subnet-ids": "value",
                        "--tags": "value",
                        "--validate-only": "bool",
                        "--vpc-id": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "value",
                        "--validate-only": "bool"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "get-credentials": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "get-kubeconfig": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--output-file": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "get-server-config": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "node-pools": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--cluster": "value",
                        "--iam-instance-profile": "value",
                        "--instance-type": "value",
                        "--location": "value",
                        "--max-nodes": "value",
                        "--max-pods-per-node": "value",
                        "--min-nodes": "value",
                        "--node-labels": "value",
                        "--node-taints": "value",
                        "--node-version": "value",
                        "--proxy-secret-arn": "value",
                        "--proxy-secret-version-id": "value",
                        "--root-volume-iops": "value",
                        "--root-volume-kms-key-arn": "value",
                        "--root-volume-size": "value",
                        "--root-volume-type": [
                          "gp2",
                          "gp3"
                        ],
                        "--security-group-ids": "value",
                        "--ssh-ec2-key-pair": "value",
                        "--subnet-id": "value",
                        "--tags": "value",
                        "--validate-only": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--cluster": "value",
                        "--location": "value",
                        "--validate-only": "bool"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--cluster": "value",
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--cluster": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "operations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "wait": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "azure": {
              "commands": {
                "clients": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--application-id": "value",
                        "--location": "value",
                        "--tenant-id": "value",
                        "--validate-only": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "get-public-cert": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--output-file": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "clusters": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--azure-region": "value",
                        "--client": "value",
                        "--cluster-version": "value",
                        "--location": "value",
                        "--main-volume-size": "value",
                        "--pod-address-cidr-blocks": "value",
                        "--proxy-resource-group-id": "value",
                        "--proxy-secret-id": "value",
                        "--replica-placements": "value",
                        "--resource-group-id": "value",
                        "--root-volume-size": "value",
                        "--service-address-cidr-blocks": "value",
                        "--ssh-public-key": "value",
                        "--subnet-id": "value",
                        "--tags": "value",
                        "--validate-only": "bool",
                        "--vm-size": "value",
                        "--vnet-id": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "get-credentials": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "get-kubeconfig": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--output-file": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "get-server-config": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "node-pools": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--azure-availability-zone": "value",
                        "--cluster": "value",
                        "--location": "value",
                        "--max-nodes": "value",
                        "--max-pods-per-node": "value",
                        "--min-nodes": "value",
                        "--node-labels": "value",
                        "--node-taints": "value",
                        "--node-version": "value",
                        "--proxy-resource-group-id": "value",
                        "--proxy-secret-id": "value",
                        "--root-volume-size": "value",
                        "--ssh-public-key": "value",
                        "--subnet-id": "value",
                        "--tags": "value",
                        "--validate-only": "bool",
                        "--vm-size": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--cluster": "value",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--cluster": "value",
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--cluster": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "operations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "wait": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "backup-restore": {
              "commands": {
                "backup-plans": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--all-namespaces": "bool",
                        "--async": "bool",
                        "--backup-delete-lock-days": "value",
                        "--backup-retain-days": "value",
                        "--cluster": "value",
                        "--cron-schedule": "value",
                        "--deactivated": "bool",
                        "--description": "value",
                        "--encryption-key": "value",
                        "--include-secrets": "bool",
                        "--include-volume-data": "bool",
                        "--labels": "value",
                        "--location": "value",
                        "--locked": "bool",
                        "--paused": "bool",
                        "--selected-applications": "value",
                        "--selected-namespaces": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--etag": "value",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--all-namespaces": "bool",
                        "--async": "bool",
                        "--backup-delete-lock-days": "value",
                        "--backup-retain-days": "value",
                        "--clear-labels": "bool",
                        "--cron-schedule": "value",
                        "--deactivated": "bool",
                        "--description": "value",
                        "--encryption-key": "value",
                        "--etag": "value",
                        "--include-secrets": "bool",
                        "--include-volume-data": "bool",
                        "--location": "value",
                        "--locked": "bool",
                        "--paused": "bool",
                        "--remove-labels": "value",
                        "--selected-applications": "value",
                        "--selected-namespaces": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "backups": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--backup-plan": "value",
                        "--delete-lock-days": "value",
                        "--description": "value",
                        "--labels": "value",
                        "--location": "value",
                        "--retain-days": "value",
                        "--wait-for-completion": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--backup-plan": "value",
                        "--etag": "value",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--backup-plan": "value",
                        "--location": "value"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--backup-plan": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--backup-plan": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--backup-plan": "value",
                        "--location": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--backup-plan": "value",
                        "--clear-labels": "bool",
                        "--delete-lock-days": "value",
                        "--description": "value",
                        "--etag": "value",
                        "--location": "value",
                        "--remove-labels": "value",
                        "--retain-days": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "locations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "restores": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--all-namespaces": "bool",
                        "--async": "bool",
                        "--backup": "value",
                        "--cluster": "value",
                        "--cluster-resource-conflict-policy": [
                          "USE_BACKUP_VERSION",
                          "USE_EXISTING_VERSION"
                        ],
                        "--cluster-resource-restore-scope": "value",
                        "--description": "value",
                        "--labels": "value",
                        "--location": "value",
                        "--namespaced-resource-restore-mode": [
                          "DELETE_AND_RESTORE",
                          "FAIL_ON_CONFLICT"
                        ],
                        "--selected-applications": "value",
                        "--selected-namespaces": "value",
                        "--substitution-rules-file": "value",
                        "--volume-data-restore-policy": [
                          "NO_VOLUME_DATA_RESTORATION",
                          "RESTORE_VOLUME_DATA_FROM_BACKUP",
                          "REUSE_VOLUME_HANDLE_FROM_BACKUP"
                        ],
                        "--wait-for-completion": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--etag": "value",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--clear-labels": "bool",
                        "--description": "value",
                        "--etag": "value",
                        "--location": "value",
                        "--remove-labels": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "volume-backups": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--backup": "value",
                        "--backup-plan": "value",
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--backup": "value",
                        "--backup-plan": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "volume-restores": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--restore": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--restore": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "binauthz": {
              "commands": {
                "attestations": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--artifact-url": "value",
                        "--attestor": "value",
                        "--attestor-project": "value",
                        "--payload-file": "value",
                        "--public-key-id": "value",
                        "--signature-file": "value",
                        "--validate": "bool"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--artifact-url": "value",
                        "--attestor": "value",
                        "--attestor-project": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "sign-and-create": {
                      "commands": {},
                      "flags": {
                        "--artifact-url": "value",
                        "--attestor": "value",
                        "--attestor-project": "value",
                        "--keyversion": "value",
                        "--keyversion-key": "value",
                        "--keyversion-keyring": "value",
                        "--keyversion-location": "value",
                        "--keyversion-project": "value",
                        "--public-key-id-override": "value",
                        "--validate": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "attestors": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--role": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--attestation-authority-note": "value",
                        "--attestation-authority-note-project": "value",
                        "--description": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {}
                    },
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "public-keys": {
                      "commands": {
                        "add": {
                          "commands": {},
                          "flags": {
                            "--attestor": "value",
                            "--comment": "value",
                            "--keyversion": "value",
                            "--keyversion-key": "value",
                            "--keyversion-keyring": "value",
                            "--keyversion-location": "value",
                            "--keyversion-project": "value",
                            "--pgp-public-key-file": "value",
                            "--pkix-public-key-algorithm": [
                              "ec-sign-p256-sha256",
                              "ec-sign-p384-sha384",
                              "ec-sign-p521-sha512",
                              "ecdsa-p256-sha256",
                              "ecdsa-p384-sha384",
                              "ecdsa-p521-sha512",
                              "rsa-pss-2048-sha256",
                              "rsa-pss-3072-sha256",
                              "rsa-pss-4096-sha256",
                              "rsa-pss-4096-sha512",
                              "rsa-sign-pkcs1-2048-sha256",
                              "rsa-sign-pkcs1-3072-sha256",
                              "rsa-sign-pkcs1-4096-sha256",
                              "rsa-sign-pkcs1-4096-sha512"
                            ],
                            "--pkix-public-key-file": "value",
                            "--public-key-id-override": "value"
                          }
                        },
                        "remove": {
                          "commands": {},
                          "flags": {
                            "--attestor": "value"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--attestor": "value",
                            "--comment": "value",
                            "--pgp-public-key-file": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--role": "dynamic"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {}
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--description": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "continuous-validation": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "disable": {
                      "commands": {},
                      "flags": {}
                    },
                    "enable": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "create-signature-payload": {
                  "commands": {},
                  "flags": {
                    "--artifact-url": "value"
                  }
                },
                "policy": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--role": "dynamic"
                      }
                    },
                    "export": {
                      "commands": {},
                      "flags": {}
                    },
                    "export-system-policy": {
                      "commands": {},
                      "flags": {
                        "--location": [
                          "asia-east1",
                          "asia-east2",
                          "asia-northeast1",
                          "asia-northeast2",
                          "asia-northeast3",
                          "asia-south1",
                          "asia-southeast1",
                          "asia-southeast2",
                          "australia-southeast1",
                          "europe-north1",
                          "europe-west1",
                          "europe-west2",
                          "europe-west3",
                          "europe-west4",
                          "europe-west5",
                          "europe-west6",
                          "global",
                          "northamerica-northeast1",
                          "southamerica-east1",
                          "us-central1",
                          "us-east1",
                          "us-east4",
                          "us-west1",
                          "us-west2",
                          "us-west3",
                          "us-west4"
                        ]
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "import": {
                      "commands": {},
                      "flags": {
                        "--strict-validation": "bool"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--role": "dynamic"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "clusters": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--location": "value",
                        "--path": "value",
                        "--region": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ],
                        "--zone": "value"
                      }
                    }
                  },
                  "flags": {
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--additional-zones": "value",
                    "--addons": "value",
                    "--allow-route-overlap": "bool",
                    "--async": "bool",
                    "--autoprovisioning-config-file": "value",
                    "--autoprovisioning-image-type": "value",
                    "--autoprovisioning-locations": "value",
                    "--autoprovisioning-max-surge-upgrade": "value",
                    "--autoprovisioning-max-unavailable-upgrade": "value",
                    "--autoprovisioning-min-cpu-platform": "value",
                    "--autoprovisioning-scopes": "value",
                    "--autoprovisioning-service-account": "value",
                    "--autoscaling-profile": "value",
                    "--boot-disk-kms-key": "value",
                    "--cloud-run-config": "value",
                    "--cluster-dns": [
                      "clouddns",
                      "default"
                    ],
                    "--cluster-dns-domain": "value",
                    "--cluster-dns-scope": [
                      "cluster",
                      "vpc"
                    ],
                    "--cluster-ipv4-cidr": "value",
                    "--cluster-secondary-range-name": "value",
                    "--cluster-version": "value",
                    "--create-subnetwork": "value",
                    "--database-encryption-key": "value",
                    "--default-max-pods-per-node": "value",
                    "--disable-default-snat": "bool",
                    "--disk-size": "value",
                    "--disk-type": [
                      "pd-balanced",
                      "pd-ssd",
                      "pd-standard"
                    ],
                    "--enable-autoprovisioning": "bool",
                    "--enable-autoprovisioning-autorepair": "bool",
                    "--enable-autoprovisioning-autoupgrade": "bool",
                    "--enable-autorepair": "bool",
                    "--enable-autoscaling": "bool",
                    "--enable-autoupgrade": "bool",
                    "--enable-basic-auth": "bool",
                    "--enable-binauthz": "bool",
                    "--enable-cloud-logging": "bool",
                    "--enable-cloud-monitoring": "bool",
                    "--enable-cloud-run-alpha": "bool",
                    "--enable-confidential-nodes": "bool",
                    "--enable-cost-management": "bool",
                    "--enable-dataplane-v2": "bool",
                    "--enable-gke-oidc": "bool",
                    "--enable-gvnic": "bool",
                    "--enable-identity-service": "bool",
                    "--enable-intra-node-visibility": "bool",
                    "--enable-ip-alias": "bool",
                    "--enable-kubernetes-alpha": "bool",
                    "--enable-l4-ilb-subsetting": "bool",
                    "--enable-legacy-authorization": "bool",
                    "--enable-logging-monitoring-system-only": "bool",
                    "--enable-master-authorized-networks": "bool",
                    "--enable-master-global-access": "bool",
                    "--enable-network-egress-metering": "bool",
                    "--enable-network-policy": "bool",
                    "--enable-pod-security-policy": "bool",
                    "--enable-private-endpoint": "bool",
                    "--enable-private-nodes": "bool",
                    "--enable-resource-consumption-metering": "bool",
                    "--enable-service-externalips": "bool",
                    "--enable-shielded-nodes": "bool",
                    "--enable-stackdriver-kubernetes": "bool",
                    "--enable-tpu": "bool",
                    "--enable-tpu-service-networking": "bool",
                    "--enable-vertical-pod-autoscaling": "bool",
                    "--ephemeral-storage": "value",
                    "--identity-provider": "value",
                    "--image-type": "value",
                    "--issue-client-certificate": "bool",
                    "--istio-config": "value",
                    "--labels": "value",
                    "--linux-sysctls": "value",
                    "--local-ssd-count": "value",
                    "--local-ssd-volumes": "value",
                    "--logging": "value",
                    "--machine-type": "value",
                    "--maintenance-window": "value",
                    "--maintenance-window-end": "value",
                    "--maintenance-window-recurrence": "value",
                    "--maintenance-window-start": "value",
                    "--master-authorized-networks": "value",
                    "--master-ipv4-cidr": "value",
                    "--max-accelerator": "value",
                    "--max-cpu": "value",
                    "--max-memory": "value",
                    "--max-nodes": "value",
                    "--max-nodes-per-pool": "value",
                    "--max-pods-per-node": "value",
                    "--max-surge-upgrade": "value",
                    "--max-unavailable-upgrade": "value",
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-accelerator": "value",
                    "--min-cpu": "value",
                    "--min-cpu-platform": "value",
                    "--min-memory": "value",
                    "--min-nodes": "value",
                    "--monitoring": "value",
                    "--network": "value",
                    "--node-labels": "value",
                    "--node-locations": "value",
                    "--node-pool-name": "value",
                    "--node-taints": "value",
                    "--node-version": "value",
                    "--notification-config": "value",
                    "--num-nodes": "value",
                    "--password": "value",
                    "--preemptible": "bool",
                    "--private-cluster": "bool",
                    "--private-ipv6-google-access-type": [
                      "bidirectional",
                      "disabled",
                      "outbound-only"
                    ],
                    "--region": "value",
                    "--release-channel": [
                      "None",
                      "rapid",
                      "regular",
                      "stable"
                    ],
                    "--reservation": "value",
                    "--reservation-affinity": [
                      "any",
                      "none",
                      "specific"
                    ],
                    "--resource-usage-bigquery-dataset": "value",
                    "--scopes": "value",
                    "--security-group": "value",
                    "--security-profile": "value",
                    "--security-profile-runtime-rules": "bool",
                    "--service-account": "value",
                    "--services-ipv4-cidr": "value",
                    "--services-secondary-range-name": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--subnetwork": "value",
                    "--system-config-from-file": "value",
                    "--tags": "value",
                    "--threads-per-core": "value",
                    "--tpu-ipv4-cidr": "value",
                    "--username": "value",
                    "--workload-metadata": [
                      "EXPOSED",
                      "GCE_METADATA",
                      "GKE_METADATA",
                      "GKE_METADATA_SERVER",
                      "SECURE"
                    ],
                    "--workload-pool": "value",
                    "--zone": "value"
                  }
                },
                "create-auto": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster-ipv4-cidr": "value",
                    "--cluster-secondary-range-name": "value",
                    "--cluster-version": "value",
                    "--create-subnetwork": "value",
                    "--enable-master-authorized-networks": "bool",
                    "--enable-private-endpoint": "bool",
                    "--enable-private-nodes": "bool",
                    "--logging": "value",
                    "--master-authorized-networks": "value",
                    "--master-ipv4-cidr": "value",
                    "--monitoring": "value",
                    "--network": "value",
                    "--region": "value",
                    "--release-channel": [
                      "None",
                      "rapid",
                      "regular",
                      "stable"
                    ],
                    "--scopes": "value",
                    "--security-group": "value",
                    "--service-account": "value",
                    "--services-ipv4-cidr": "value",
                    "--services-secondary-range-name": "value",
                    "--subnetwork": "value",
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "get-credentials": {
                  "commands": {},
                  "flags": {
                    "--internal-ip": "bool",
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "value"
                  }
                },
                "resize": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--node-pool": "value",
                    "--num-nodes": "value",
                    "--region": "value",
                    "--size": "value",
                    "--zone": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-maintenance-exclusion-end": "value",
                    "--add-maintenance-exclusion-name": "value",
                    "--add-maintenance-exclusion-start": "value",
                    "--additional-zones": "value",
                    "--async": "bool",
                    "--autoprovisioning-config-file": "value",
                    "--autoprovisioning-image-type": "value",
                    "--autoprovisioning-locations": "value",
                    "--autoprovisioning-max-surge-upgrade": "value",
                    "--autoprovisioning-max-unavailable-upgrade": "value",
                    "--autoprovisioning-min-cpu-platform": "value",
                    "--autoprovisioning-scopes": "value",
                    "--autoprovisioning-service-account": "value",
                    "--autoscaling-profile": "value",
                    "--clear-maintenance-window": "bool",
                    "--clear-resource-usage-bigquery-dataset": "bool",
                    "--cloud-run-config": "value",
                    "--cluster-dns": [
                      "clouddns",
                      "default"
                    ],
                    "--cluster-dns-domain": "value",
                    "--cluster-dns-scope": [
                      "cluster",
                      "vpc"
                    ],
                    "--complete-credential-rotation": "bool",
                    "--complete-ip-rotation": "bool",
                    "--database-encryption-key": "value",
                    "--disable-autopilot": "bool",
                    "--disable-database-encryption": "bool",
                    "--disable-default-snat": "bool",
                    "--disable-workload-identity": "bool",
                    "--enable-autoprovisioning": "bool",
                    "--enable-autoprovisioning-autorepair": "bool",
                    "--enable-autoprovisioning-autoupgrade": "bool",
                    "--enable-autoscaling": "bool",
                    "--enable-basic-auth": "bool",
                    "--enable-binauthz": "bool",
                    "--enable-cost-management": "bool",
                    "--enable-gke-oidc": "bool",
                    "--enable-identity-service": "bool",
                    "--enable-intra-node-visibility": "bool",
                    "--enable-l4-ilb-subsetting": "bool",
                    "--enable-legacy-authorization": "bool",
                    "--enable-logging-monitoring-system-only": "bool",
                    "--enable-master-authorized-networks": "bool",
                    "--enable-master-global-access": "bool",
                    "--enable-network-egress-metering": "bool",
                    "--enable-network-policy": "bool",
                    "--enable-pod-security-policy": "bool",
                    "--enable-resource-consumption-metering": "bool",
                    "--enable-service-externalips": "bool",
                    "--enable-shielded-nodes": "bool",
                    "--enable-stackdriver-kubernetes": "bool",
                    "--enable-tpu": "bool",
                    "--enable-tpu-service-networking": "bool",
                    "--enable-vertical-pod-autoscaling": "bool",
                    "--generate-password": "bool",
                    "--identity-provider": "value",
                    "--istio-config": "value",
                    "--logging": "value",
                    "--logging-service": "value",
                    "--maintenance-window": "value",
                    "--maintenance-window-end": "value",
                    "--maintenance-window-recurrence": "value",
                    "--maintenance-window-start": "value",
                    "--master-authorized-networks": "value",
                    "--max-accelerator": "value",
                    "--max-cpu": "value",
                    "--max-memory": "value",
                    "--max-nodes": "value",
                    "--min-accelerator": "value",
                    "--min-cpu": "value",
                    "--min-memory": "value",
                    "--min-nodes": "value",
                    "--monitoring": "value",
                    "--monitoring-service": "value",
                    "--node-locations": "value",
                    "--node-pool": "value",
                    "--notification-config": "value",
                    "--password": "value",
                    "--private-ipv6-google-access-type": [
                      "bidirectional",
                      "disabled",
                      "outbound-only"
                    ],
                    "--region": "value",
                    "--release-channel": [
                      "None",
                      "rapid",
                      "regular",
                      "stable"
                    ],
                    "--remove-labels": "value",
                    "--remove-maintenance-exclusion": "value",
                    "--resource-usage-bigquery-dataset": "value",
                    "--security-group": "value",
                    "--security-profile": "value",
                    "--set-password": "bool",
                    "--start-credential-rotation": "bool",
                    "--start-ip-rotation": "bool",
                    "--tpu-ipv4-cidr": "value",
                    "--update-addons": "value",
                    "--update-labels": "value",
                    "--username": "value",
                    "--workload-pool": "value",
                    "--zone": "value"
                  }
                },
                "upgrade": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster-version": "value",
                    "--image-type": "value",
                    "--master": "bool",
                    "--node-pool": "value",
                    "--region": "value",
                    "--security-profile": "value",
                    "--security-profile-runtime-rules": "bool",
                    "--zone": "value"
                  }
                }
              },
              "flags": {
                "--region": "value",
                "--zone": "value"
              }
            },
            "get-server-config": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--region": "value",
                "--sort-by": "value",
                "--zone": "value"
              }
            },
            "hub": {
              "commands": {
                "cloudrun": {
                  "commands": {
                    "apply": {
                      "commands": {},
                      "flags": {
                        "--config": "value",
                        "--context": "value",
                        "--gke-cluster": "value",
                        "--gke-uri": "value",
                        "--kubeconfig": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "disable": {
                      "commands": {},
                      "flags": {
                        "--force": "bool"
                      }
                    },
                    "enable": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "config-management": {
                  "commands": {
                    "apply": {
                      "commands": {},
                      "flags": {
                        "--config": "value",
                        "--membership": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--membership": "value"
                      }
                    },
                    "disable": {
                      "commands": {},
                      "flags": {
                        "--force": "bool"
                      }
                    },
                    "enable": {
                      "commands": {},
                      "flags": {}
                    },
                    "fetch-for-apply": {
                      "commands": {},
                      "flags": {
                        "--membership": "value"
                      }
                    },
                    "status": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "unmanage": {
                      "commands": {},
                      "flags": {
                        "--membership": "value"
                      }
                    },
                    "upgrade": {
                      "commands": {},
                      "flags": {
                        "--membership": "value"
                      }
                    },
                    "version": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "features": {
                  "commands": {
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "identity-service": {
                  "commands": {
                    "apply": {
                      "commands": {},
                      "flags": {
                        "--config": "value",
                        "--membership": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--membership": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "disable": {
                      "commands": {},
                      "flags": {
                        "--force": "bool"
                      }
                    },
                    "enable": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "ingress": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "disable": {
                      "commands": {},
                      "flags": {
                        "--force": "bool"
                      }
                    },
                    "enable": {
                      "commands": {},
                      "flags": {
                        "--config-membership": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--config-membership": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "memberships": {
                  "commands": {
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "generate-gateway-rbac": {
                      "commands": {},
                      "flags": {
                        "--anthos-support": "bool",
                        "--membership": "value",
                        "--rbac-output-file": "value",
                        "--role": "value",
                        "--users": "value"
                      }
                    },
                    "get-credentials": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "register": {
                      "commands": {},
                      "flags": {
                        "--context": "value",
                        "--enable-workload-identity": "bool",
                        "--gke-cluster": "value",
                        "--gke-uri": "value",
                        "--has-private-issuer": "bool",
                        "--kubeconfig": "value",
                        "--manifest-output-file": "value",
                        "--proxy": "value",
                        "--public-issuer-url": "value",
                        "--service-account-key-file": "value"
                      }
                    },
                    "unregister": {
                      "commands": {},
                      "flags": {
                        "--context": "value",
                        "--gke-cluster": "value",
                        "--gke-uri": "value",
                        "--kubeconfig": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--clear-labels": "bool",
                        "--location": "value",
                        "--remove-labels": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "mesh": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "disable": {
                      "commands": {},
                      "flags": {
                        "--force": "bool"
                      }
                    },
                    "enable": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "multi-cluster-services": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "disable": {
                      "commands": {},
                      "flags": {
                        "--force": "bool"
                      }
                    },
                    "enable": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "service-directory": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "disable": {
                      "commands": {},
                      "flags": {
                        "--force": "bool"
                      }
                    },
                    "enable": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "images": {
              "commands": {
                "add-tag": {
                  "commands": {},
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--force-delete-tags": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--metadata-filter": "value",
                    "--show-all-metadata": "bool",
                    "--show-build-details": "bool",
                    "--show-deployment": "bool",
                    "--show-image-basis": "bool",
                    "--show-package-vulnerability": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--repository": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-tags": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--occurrence-filter": "value",
                    "--page-size": "value",
                    "--show-occurrences": "bool",
                    "--show-occurrences-from": "value",
                    "--sort-by": "value"
                  }
                },
                "untag": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "node-pools": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--boot-disk-kms-key": "value",
                    "--cluster": "value",
                    "--create-pod-ipv4-range": "value",
                    "--disk-size": "value",
                    "--disk-type": [
                      "pd-balanced",
                      "pd-ssd",
                      "pd-standard"
                    ],
                    "--enable-autoprovisioning": "bool",
                    "--enable-autorepair": "bool",
                    "--enable-autoscaling": "bool",
                    "--enable-autoupgrade": "bool",
                    "--enable-gvnic": "bool",
                    "--ephemeral-storage": "value",
                    "--image-type": "value",
                    "--linux-sysctls": "value",
                    "--local-ssd-count": "value",
                    "--local-ssd-volumes": "value",
                    "--machine-type": "value",
                    "--max-nodes": "value",
                    "--max-pods-per-node": "value",
                    "--max-surge-upgrade": "value",
                    "--max-unavailable-upgrade": "value",
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--min-nodes": "value",
                    "--node-group": "value",
                    "--node-labels": "value",
                    "--node-locations": "value",
                    "--node-taints": "value",
                    "--node-version": "value",
                    "--num-nodes": "value",
                    "--pod-ipv4-range": "value",
                    "--preemptible": "bool",
                    "--region": "value",
                    "--reservation": "value",
                    "--reservation-affinity": [
                      "any",
                      "none",
                      "specific"
                    ],
                    "--sandbox": "value",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--system-config-from-file": "value",
                    "--tags": "value",
                    "--threads-per-core": "value",
                    "--workload-metadata": [
                      "EXPOSED",
                      "GCE_METADATA",
                      "GKE_METADATA",
                      "GKE_METADATA_SERVER",
                      "SECURE"
                    ],
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster": "value",
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "value"
                  }
                },
                "rollback": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster": "value",
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--enable-autoprovisioning": "bool",
                    "--enable-autorepair": "bool",
                    "--enable-autoscaling": "bool",
                    "--enable-autoupgrade": "bool",
                    "--enable-gvnic": "bool",
                    "--max-nodes": "value",
                    "--max-surge-upgrade": "value",
                    "--max-unavailable-upgrade": "value",
                    "--min-nodes": "value",
                    "--node-labels": "value",
                    "--node-locations": "value",
                    "--node-taints": "value",
                    "--region": "value",
                    "--system-config-from-file": "value",
                    "--tags": "value",
                    "--workload-metadata": [
                      "EXPOSED",
                      "GCE_METADATA",
                      "GKE_METADATA",
                      "GKE_METADATA_SERVER",
                      "SECURE"
                    ],
                    "--zone": "value"
                  }
                }
              },
              "flags": {
                "--region": "value",
                "--zone": "value"
              }
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--zone": "value"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--zone": "value"
                  }
                }
              },
              "flags": {
                "--region": "value",
                "--zone": "value"
              }
            },
            "subnets": {
              "commands": {
                "list-usable": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--network-project": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "data-catalog": {
          "commands": {
            "crawler-runs": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--crawler": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "crawlers": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--buckets": "value",
                    "--bundle-specs": "value",
                    "--crawl-scope": [
                      "bucket",
                      "organization",
                      "project"
                    ],
                    "--description": "value",
                    "--display-name": "value",
                    "--run-option": [
                      "manual",
                      "scheduled"
                    ],
                    "--run-schedule": [
                      "daily",
                      "weekly"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-buckets": "value",
                    "--add-bundle-specs": "value",
                    "--clear-buckets": "bool",
                    "--clear-bundle-specs": "bool",
                    "--crawl-scope": [
                      "bucket",
                      "organization",
                      "project"
                    ],
                    "--description": "value",
                    "--display-name": "value",
                    "--remove-buckets": "value",
                    "--remove-bundle-specs": "value",
                    "--run-option": [
                      "manual",
                      "scheduled"
                    ],
                    "--run-schedule": [
                      "daily",
                      "weekly"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "entries": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--entry-group": "value",
                    "--gcs-file-patterns": "value",
                    "--location": "value",
                    "--schema": "value",
                    "--schema-from-file": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--entry-group": "value",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--entry-group": "value",
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--entry-group": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "lookup": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-file-patterns": "value",
                    "--clear-file-patterns": "bool",
                    "--description": "value",
                    "--display-name": "value",
                    "--entry-group": "value",
                    "--location": "value",
                    "--lookup-entry": "value",
                    "--remove-file-patterns": "value",
                    "--schema": "value",
                    "--schema-from-file": "value"
                  }
                }
              },
              "flags": {}
            },
            "entry-groups": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            },
            "search": {
              "commands": {},
              "flags": {
                "--include-gcp-public-datasets": "bool",
                "--include-organization-ids": "value",
                "--include-project-ids": "value",
                "--limit": "value",
                "--order-by": "value",
                "--page-size": "value",
                "--restricted-locations": "value"
              }
            },
            "tag-templates": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--display-name": "value",
                    "--field": "value",
                    "--location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--force": "bool",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "fields": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--display-name": "value",
                        "--location": "value",
                        "--tag-template": "value",
                        "--type": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--force": "bool",
                        "--location": "value",
                        "--tag-template": "value"
                      }
                    },
                    "enum-values": {
                      "commands": {
                        "rename": {
                          "commands": {},
                          "flags": {
                            "--field": "value",
                            "--location": "value",
                            "--new-id": "value",
                            "--tag-template": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "rename": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--new-id": "value",
                        "--tag-template": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--display-name": "value",
                        "--enum-values": "value",
                        "--location": "value",
                        "--required": "bool",
                        "--tag-template": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--display-name": "value",
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            },
            "tags": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--entry": "value",
                    "--entry-group": "value",
                    "--location": "value",
                    "--scope": "value",
                    "--tag-file": "value",
                    "--tag-template": "value",
                    "--tag-template-location": "value",
                    "--tag-template-project": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--entry": "value",
                    "--entry-group": "value",
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--entry": "value",
                    "--entry-group": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--entry": "value",
                    "--entry-group": "value",
                    "--location": "value",
                    "--tag-file": "value",
                    "--tag-template": "value",
                    "--tag-template-location": "value",
                    "--tag-template-project": "value"
                  }
                }
              },
              "flags": {}
            },
            "taxonomies": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "policy-tags": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--member": "value",
                        "--role": "dynamic",
                        "--taxonomy": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--taxonomy": "value"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--taxonomy": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--taxonomy": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--member": "value",
                        "--role": "dynamic",
                        "--taxonomy": "value"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--taxonomy": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "database-migration": {
          "commands": {
            "connection-profiles": {
              "commands": {
                "create": {
                  "commands": {
                    "cloudsql": {
                      "commands": {},
                      "flags": {
                        "--activation-policy": [
                          "ALWAYS",
                          "NEVER"
                        ],
                        "--authorized-networks": "value",
                        "--auto-storage-increase": "value",
                        "--data-disk-size": "value",
                        "--data-disk-type": [
                          "PD_HDD",
                          "PD_SSD"
                        ],
                        "--database-flags": "value",
                        "--database-version": [
                          "MYSQL_5_6",
                          "MYSQL_5_7",
                          "MYSQL_8_0",
                          "POSTGRES_10",
                          "POSTGRES_11",
                          "POSTGRES_12",
                          "POSTGRES_13",
                          "POSTGRES_9_6"
                        ],
                        "--display-name": "value",
                        "--enable-ip-v4": "value",
                        "--labels": "value",
                        "--private-network": "value",
                        "--provider": [
                          "CLOUDSQL",
                          "RDS"
                        ],
                        "--region": "dynamic",
                        "--require-ssl": "value",
                        "--source-id": "dynamic",
                        "--storage-auto-resize-limit": "value",
                        "--tier": "value",
                        "--user-labels": "value",
                        "--zone": "value"
                      }
                    },
                    "mysql": {
                      "commands": {},
                      "flags": {
                        "--ca-certificate": "value",
                        "--certificate": "value",
                        "--display-name": "value",
                        "--host": "value",
                        "--instance": "value",
                        "--labels": "value",
                        "--password": "value",
                        "--port": "value",
                        "--private-key": "value",
                        "--prompt-for-password": "bool",
                        "--provider": [
                          "CLOUDSQL",
                          "RDS"
                        ],
                        "--region": "dynamic",
                        "--username": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--force": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--ca-certificate": "value",
                    "--certificate": "value",
                    "--clear-labels": "bool",
                    "--display-name": "value",
                    "--host": "value",
                    "--instance": "value",
                    "--password": "value",
                    "--port": "value",
                    "--private-key": "value",
                    "--prompt-for-password": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value",
                    "--username": "value"
                  }
                }
              },
              "flags": {}
            },
            "migration-jobs": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--destination": "dynamic",
                    "--display-name": "value",
                    "--dump-path": "value",
                    "--labels": "value",
                    "--peer-vpc": "value",
                    "--region": "dynamic",
                    "--source": "dynamic",
                    "--type": [
                      "CONTINUOUS",
                      "ONE_TIME"
                    ],
                    "--vm": "value",
                    "--vm-ip": "value",
                    "--vm-port": "value",
                    "--vpc": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--force": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "generate-ssh-script": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--vm": "value",
                    "--vm-machine-type": "value",
                    "--vm-port": "value",
                    "--vm-zone": "value",
                    "--vm-zone-create": "value",
                    "--vpc": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "promote": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "restart": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "resume": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "stop": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--destination": "dynamic",
                    "--display-name": "value",
                    "--dump-path": "value",
                    "--peer-vpc": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--source": "dynamic",
                    "--type": [
                      "CONTINUOUS",
                      "ONE_TIME"
                    ],
                    "--update-labels": "value",
                    "--vm": "value",
                    "--vm-ip": "value",
                    "--vm-port": "value",
                    "--vpc": "value"
                  }
                },
                "verify": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "dataflow": {
          "commands": {
            "jobs": {
              "commands": {
                "export-steps": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "resume-unsupported-sdk": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--token": "value"
                  }
                }
              },
              "flags": {}
            },
            "logs": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--after": "value",
                    "--before": "value",
                    "--filter": "value",
                    "--importance": [
                      "debug",
                      "detailed",
                      "error",
                      "warning"
                    ],
                    "--limit": "value",
                    "--region": "value"
                  }
                }
              },
              "flags": {}
            },
            "metrics": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--changed-after": "value",
                    "--filter": "value",
                    "--hide-committed": "bool",
                    "--limit": "value",
                    "--region": "value",
                    "--source": [
                      "all",
                      "service",
                      "user"
                    ],
                    "--tentative": "bool",
                    "--transform": "value"
                  }
                }
              },
              "flags": {}
            },
            "snapshots": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--job-id": "value",
                    "--region": "value",
                    "--snapshot-sources": "value",
                    "--snapshot-ttl": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--job-id": "value",
                    "--region": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "dataproc": {
          "commands": {
            "autoscaling-policies": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--region": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                }
              },
              "flags": {}
            },
            "clusters": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--autoscaling-policy": "value",
                    "--bucket": "value",
                    "--dataproc-metastore": "value",
                    "--enable-component-gateway": "bool",
                    "--enable-kerberos": "bool",
                    "--expiration-time": "value",
                    "--gce-pd-kms-key": "dynamic",
                    "--gce-pd-kms-key-keyring": "dynamic",
                    "--gce-pd-kms-key-location": "dynamic",
                    "--gce-pd-kms-key-project": "dynamic",
                    "--image": "value",
                    "--image-version": "value",
                    "--initialization-action-timeout": "value",
                    "--initialization-actions": "value",
                    "--kerberos-config-file": "value",
                    "--kerberos-kms-key": "dynamic",
                    "--kerberos-kms-key-keyring": "dynamic",
                    "--kerberos-kms-key-location": "dynamic",
                    "--kerberos-kms-key-project": "dynamic",
                    "--kerberos-root-principal-password-uri": "value",
                    "--labels": "value",
                    "--master-accelerator": "value",
                    "--master-boot-disk-size": "value",
                    "--master-boot-disk-type": "value",
                    "--master-machine-type": "value",
                    "--master-min-cpu-platform": "value",
                    "--max-age": "value",
                    "--max-idle": "value",
                    "--metadata": "value",
                    "--network": "value",
                    "--no-address": "bool",
                    "--node-group": "value",
                    "--num-master-local-ssds": "value",
                    "--num-masters": "value",
                    "--num-secondary-worker-local-ssds": "value",
                    "--num-secondary-workers": "value",
                    "--num-worker-local-ssds": "value",
                    "--num-workers": "value",
                    "--optional-components": "value",
                    "--private-ipv6-google-access-type": [
                      "bidirectional",
                      "inherit-subnetwork",
                      "outbound"
                    ],
                    "--properties": "value",
                    "--region": "value",
                    "--reservation": "value",
                    "--reservation-affinity": [
                      "any",
                      "none",
                      "specific"
                    ],
                    "--scopes": "value",
                    "--secondary-worker-accelerator": "value",
                    "--secondary-worker-boot-disk-size": "value",
                    "--secondary-worker-boot-disk-type": "value",
                    "--secondary-worker-type": [
                      "non-preemptible",
                      "preemptible"
                    ],
                    "--service-account": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--single-node": "bool",
                    "--subnet": "value",
                    "--tags": "value",
                    "--temp-bucket": "value",
                    "--worker-accelerator": "value",
                    "--worker-boot-disk-size": "value",
                    "--worker-boot-disk-type": "value",
                    "--worker-machine-type": "value",
                    "--worker-min-cpu-platform": "value",
                    "--zone": "value"
                  }
                },
                "create-from-file": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--file": "value",
                    "--region": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "diagnose": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--region": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "value",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "value"
                  }
                },
                "stop": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--autoscaling-policy": "value",
                    "--clear-labels": "bool",
                    "--disable-autoscaling": "bool",
                    "--expiration-time": "value",
                    "--graceful-decommission-timeout": "value",
                    "--max-age": "value",
                    "--max-idle": "value",
                    "--no-max-age": "bool",
                    "--no-max-idle": "bool",
                    "--num-secondary-workers": "value",
                    "--num-workers": "value",
                    "--region": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "jobs": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value"
                  }
                },
                "kill": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--state-filter": [
                      "active",
                      "inactive"
                    ]
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "submit": {
                  "commands": {
                    "hadoop": {
                      "commands": {},
                      "flags": {
                        "--archives": "value",
                        "--async": "bool",
                        "--bucket": "value",
                        "--class": "value",
                        "--cluster": "value",
                        "--cluster-labels": "value",
                        "--driver-log-levels": "value",
                        "--files": "value",
                        "--jar": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--max-failures-per-hour": "value",
                        "--max-failures-total": "value",
                        "--properties": "value",
                        "--region": "value"
                      }
                    },
                    "hive": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--bucket": "value",
                        "--cluster": "value",
                        "--cluster-labels": "value",
                        "--continue-on-failure": "bool",
                        "--execute": "value",
                        "--file": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--max-failures-per-hour": "value",
                        "--max-failures-total": "value",
                        "--params": "value",
                        "--properties": "value",
                        "--region": "value"
                      }
                    },
                    "pig": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--bucket": "value",
                        "--cluster": "value",
                        "--cluster-labels": "value",
                        "--continue-on-failure": "bool",
                        "--driver-log-levels": "value",
                        "--execute": "value",
                        "--file": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--max-failures-per-hour": "value",
                        "--max-failures-total": "value",
                        "--params": "value",
                        "--properties": "value",
                        "--region": "value"
                      }
                    },
                    "presto": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--bucket": "value",
                        "--client-tags": "value",
                        "--cluster": "value",
                        "--cluster-labels": "value",
                        "--continue-on-failure": "bool",
                        "--driver-log-levels": "value",
                        "--execute": "value",
                        "--file": "value",
                        "--labels": "value",
                        "--max-failures-per-hour": "value",
                        "--max-failures-total": "value",
                        "--properties": "value",
                        "--query-output-format": "value",
                        "--region": "value"
                      }
                    },
                    "pyspark": {
                      "commands": {},
                      "flags": {
                        "--archives": "value",
                        "--async": "bool",
                        "--bucket": "value",
                        "--cluster": "value",
                        "--cluster-labels": "value",
                        "--driver-log-levels": "value",
                        "--files": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--max-failures-per-hour": "value",
                        "--max-failures-total": "value",
                        "--properties": "value",
                        "--py-files": "value",
                        "--region": "value"
                      }
                    },
                    "spark": {
                      "commands": {},
                      "flags": {
                        "--archives": "value",
                        "--async": "bool",
                        "--bucket": "value",
                        "--class": "value",
                        "--cluster": "value",
                        "--cluster-labels": "value",
                        "--driver-log-levels": "value",
                        "--files": "value",
                        "--jar": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--max-failures-per-hour": "value",
                        "--max-failures-total": "value",
                        "--properties": "value",
                        "--region": "value"
                      }
                    },
                    "spark-r": {
                      "commands": {},
                      "flags": {
                        "--archives": "value",
                        "--async": "bool",
                        "--bucket": "value",
                        "--cluster": "value",
                        "--cluster-labels": "value",
                        "--driver-log-levels": "value",
                        "--files": "value",
                        "--labels": "value",
                        "--max-failures-per-hour": "value",
                        "--max-failures-total": "value",
                        "--properties": "value",
                        "--region": "value"
                      }
                    },
                    "spark-sql": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--bucket": "value",
                        "--cluster": "value",
                        "--cluster-labels": "value",
                        "--driver-log-levels": "value",
                        "--execute": "value",
                        "--file": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--max-failures-per-hour": "value",
                        "--max-failures-total": "value",
                        "--params": "value",
                        "--properties": "value",
                        "--region": "value"
                      }
                    }
                  },
                  "flags": {
                    "--async": "bool",
                    "--bucket": "value",
                    "--region": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--region": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--state-filter": [
                      "active",
                      "inactive"
                    ]
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                }
              },
              "flags": {}
            },
            "workflow-templates": {
              "commands": {
                "add-job": {
                  "commands": {
                    "hadoop": {
                      "commands": {},
                      "flags": {
                        "--archives": "value",
                        "--class": "value",
                        "--driver-log-levels": "value",
                        "--files": "value",
                        "--jar": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--properties": "value",
                        "--region": "value",
                        "--start-after": "value",
                        "--step-id": "value",
                        "--workflow-template": "value"
                      }
                    },
                    "hive": {
                      "commands": {},
                      "flags": {
                        "--continue-on-failure": "bool",
                        "--execute": "value",
                        "--file": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--params": "value",
                        "--properties": "value",
                        "--region": "value",
                        "--start-after": "value",
                        "--step-id": "value",
                        "--workflow-template": "value"
                      }
                    },
                    "pig": {
                      "commands": {},
                      "flags": {
                        "--continue-on-failure": "bool",
                        "--driver-log-levels": "value",
                        "--execute": "value",
                        "--file": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--params": "value",
                        "--properties": "value",
                        "--region": "value",
                        "--start-after": "value",
                        "--step-id": "value",
                        "--workflow-template": "value"
                      }
                    },
                    "presto": {
                      "commands": {},
                      "flags": {
                        "--client-tags": "value",
                        "--continue-on-failure": "bool",
                        "--driver-log-levels": "value",
                        "--execute": "value",
                        "--file": "value",
                        "--labels": "value",
                        "--properties": "value",
                        "--query-output-format": "value",
                        "--region": "value",
                        "--start-after": "value",
                        "--step-id": "value",
                        "--workflow-template": "value"
                      }
                    },
                    "pyspark": {
                      "commands": {},
                      "flags": {
                        "--archives": "value",
                        "--driver-log-levels": "value",
                        "--files": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--properties": "value",
                        "--py-files": "value",
                        "--region": "value",
                        "--start-after": "value",
                        "--step-id": "value",
                        "--workflow-template": "value"
                      }
                    },
                    "spark": {
                      "commands": {},
                      "flags": {
                        "--archives": "value",
                        "--class": "value",
                        "--driver-log-levels": "value",
                        "--files": "value",
                        "--jar": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--properties": "value",
                        "--region": "value",
                        "--start-after": "value",
                        "--step-id": "value",
                        "--workflow-template": "value"
                      }
                    },
                    "spark-r": {
                      "commands": {},
                      "flags": {
                        "--archives": "value",
                        "--driver-log-levels": "value",
                        "--files": "value",
                        "--labels": "value",
                        "--properties": "value",
                        "--region": "value",
                        "--start-after": "value",
                        "--step-id": "value",
                        "--workflow-template": "value"
                      }
                    },
                    "spark-sql": {
                      "commands": {},
                      "flags": {
                        "--driver-log-levels": "value",
                        "--execute": "value",
                        "--file": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--params": "value",
                        "--properties": "value",
                        "--region": "value",
                        "--start-after": "value",
                        "--step-id": "value",
                        "--workflow-template": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--dag-timeout": "value",
                    "--labels": "value",
                    "--region": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--region": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--source": "value"
                  }
                },
                "instantiate": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--parameters": "value",
                    "--region": "value"
                  }
                },
                "instantiate-from-file": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--file": "value",
                    "--region": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-dag-timeout": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "remove-job": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--step-id": "value"
                  }
                },
                "run": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "value"
                  }
                },
                "set-cluster-selector": {
                  "commands": {},
                  "flags": {
                    "--cluster-labels": "value",
                    "--region": "value"
                  }
                },
                "set-dag-timeout": {
                  "commands": {},
                  "flags": {
                    "--dag-timeout": "value",
                    "--region": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "set-managed-cluster": {
                  "commands": {},
                  "flags": {
                    "--autoscaling-policy": "value",
                    "--bucket": "value",
                    "--cluster-name": "value",
                    "--dataproc-metastore": "value",
                    "--enable-component-gateway": "bool",
                    "--enable-kerberos": "bool",
                    "--image": "value",
                    "--image-version": "value",
                    "--initialization-action-timeout": "value",
                    "--initialization-actions": "value",
                    "--kerberos-config-file": "value",
                    "--kerberos-kms-key": "dynamic",
                    "--kerberos-kms-key-keyring": "dynamic",
                    "--kerberos-kms-key-location": "dynamic",
                    "--kerberos-kms-key-project": "dynamic",
                    "--kerberos-root-principal-password-uri": "value",
                    "--labels": "value",
                    "--master-accelerator": "value",
                    "--master-boot-disk-size": "value",
                    "--master-boot-disk-type": "value",
                    "--master-machine-type": "value",
                    "--master-min-cpu-platform": "value",
                    "--metadata": "value",
                    "--network": "value",
                    "--no-address": "bool",
                    "--node-group": "value",
                    "--num-master-local-ssds": "value",
                    "--num-masters": "value",
                    "--num-secondary-worker-local-ssds": "value",
                    "--num-secondary-workers": "value",
                    "--num-worker-local-ssds": "value",
                    "--num-workers": "value",
                    "--optional-components": "value",
                    "--private-ipv6-google-access-type": [
                      "bidirectional",
                      "inherit-subnetwork",
                      "outbound"
                    ],
                    "--properties": "value",
                    "--region": "value",
                    "--reservation": "value",
                    "--reservation-affinity": [
                      "any",
                      "none",
                      "specific"
                    ],
                    "--scopes": "value",
                    "--secondary-worker-accelerator": "value",
                    "--secondary-worker-boot-disk-size": "value",
                    "--secondary-worker-boot-disk-type": "value",
                    "--secondary-worker-type": [
                      "non-preemptible",
                      "preemptible"
                    ],
                    "--service-account": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--single-node": "bool",
                    "--subnet": "value",
                    "--tags": "value",
                    "--temp-bucket": "value",
                    "--worker-accelerator": "value",
                    "--worker-boot-disk-size": "value",
                    "--worker-boot-disk-type": "value",
                    "--worker-machine-type": "value",
                    "--worker-min-cpu-platform": "value",
                    "--zone": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "datastore": {
          "commands": {
            "databases": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                }
              },
              "flags": {}
            },
            "export": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--kinds": "value",
                "--namespaces": "value",
                "--operation-labels": "value"
              }
            },
            "import": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--kinds": "value",
                "--namespaces": "value",
                "--operation-labels": "value"
              }
            },
            "indexes": {
              "commands": {
                "cleanup": {
                  "commands": {},
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "deploy": {
          "commands": {
            "apply": {
              "commands": {},
              "flags": {
                "--file": "value",
                "--region": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--file": "value",
                "--force": "bool",
                "--region": "value"
              }
            },
            "delivery-pipelines": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--region": "dynamic",
                    "--role": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--force": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--region": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--region": "dynamic",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "releases": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--annotations": "value",
                    "--build-artifacts": "value",
                    "--delivery-pipeline": "dynamic",
                    "--description": "value",
                    "--gcs-source-staging-dir": "value",
                    "--ignore-file": "value",
                    "--images": "value",
                    "--labels": "value",
                    "--region": "dynamic",
                    "--source": "value",
                    "--to-target": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--delivery-pipeline": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--delivery-pipeline": "dynamic",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "promote": {
                  "commands": {},
                  "flags": {
                    "--annotations": "value",
                    "--delivery-pipeline": "dynamic",
                    "--labels": "value",
                    "--region": "dynamic",
                    "--release": "dynamic",
                    "--rollout-id": "value",
                    "--to-target": "value"
                  }
                }
              },
              "flags": {}
            },
            "rollouts": {
              "commands": {
                "approve": {
                  "commands": {},
                  "flags": {
                    "--delivery-pipeline": "dynamic",
                    "--region": "dynamic",
                    "--release": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--delivery-pipeline": "dynamic",
                    "--region": "dynamic",
                    "--release": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--delivery-pipeline": "dynamic",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--release": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "reject": {
                  "commands": {},
                  "flags": {
                    "--delivery-pipeline": "dynamic",
                    "--region": "dynamic",
                    "--release": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "targets": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--region": "dynamic",
                    "--role": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--delivery-pipeline": "value",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--region": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--region": "dynamic",
                    "--role": "dynamic"
                  }
                },
                "rollback": {
                  "commands": {},
                  "flags": {
                    "--delivery-pipeline": "value",
                    "--region": "dynamic",
                    "--release": "value",
                    "--rollout-id": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "deployment-manager": {
          "commands": {
            "deployments": {
              "commands": {
                "cancel-preview": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--fingerprint": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--automatic-rollback-on-error": "bool",
                    "--composite-type": "value",
                    "--config": "value",
                    "--create-policy": [
                      "acquire",
                      "create",
                      "create-or-acquire"
                    ],
                    "--credential": "value",
                    "--description": "value",
                    "--labels": "value",
                    "--preview": "bool",
                    "--properties": "value",
                    "--template": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--delete-policy": [
                      "abandon",
                      "delete"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--simple-list": "bool",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "stop": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--fingerprint": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--composite-type": "value",
                    "--config": "value",
                    "--create-policy": [
                      "acquire",
                      "create",
                      "create-or-acquire"
                    ],
                    "--credential": "value",
                    "--delete-policy": [
                      "abandon",
                      "delete"
                    ],
                    "--description": "value",
                    "--fingerprint": "value",
                    "--manifest-id": "value",
                    "--preview": "bool",
                    "--properties": "value",
                    "--remove-labels": "value",
                    "--template": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "manifests": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--deployment": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--deployment": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--simple-list": "bool",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--simple-list": "bool",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "resources": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--deployment": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--deployment": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--simple-list": "bool",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {
                "--deployment": "value"
              }
            },
            "type-providers": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--api-options-file": "value",
                    "--async": "bool",
                    "--custom-certificate-authority-roots": "value",
                    "--description": "value",
                    "--descriptor-url": "value",
                    "--labels": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--api-options-file": "value",
                    "--async": "bool",
                    "--custom-certificate-authority-roots": "value",
                    "--description": "value",
                    "--descriptor-url": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "types": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--labels": "value",
                    "--status": [
                      "DEPRECATED",
                      "EXPERIMENTAL",
                      "SUPPORTED"
                    ],
                    "--template": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--provider": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--provider": "value",
                    "--provider-project": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--remove-labels": "value",
                    "--status": [
                      "DEPRECATED",
                      "EXPERIMENTAL",
                      "SUPPORTED"
                    ],
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "dialogflow": {
          "commands": {
            "agent": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--replace-all": "bool",
                    "--source": "value"
                  }
                },
                "query": {
                  "commands": {},
                  "flags": {
                    "--audio-encoding": [
                      "audio-encoding-amr",
                      "audio-encoding-amr-wb",
                      "audio-encoding-flac",
                      "audio-encoding-linear-16",
                      "audio-encoding-mulaw",
                      "audio-encoding-ogg-opus",
                      "audio-encoding-speex-with-header-byte",
                      "audio-encoding-unspecified"
                    ],
                    "--language": "value",
                    "--query-audio-file": "value",
                    "--query-text": "value",
                    "--sample-rate": "value",
                    "--session": "value"
                  }
                },
                "train": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                }
              },
              "flags": {}
            },
            "entity-types": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--auto-expand": "bool",
                    "--display-name": "value",
                    "--entities": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-entities": "value",
                    "--auto-expand": "bool",
                    "--clear-entities": "bool",
                    "--display-name": "value",
                    "--remove-entities": "value"
                  }
                }
              },
              "flags": {}
            },
            "intents": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--display-name": "value",
                    "--is-fallback": "bool",
                    "--ml-enabled": "bool",
                    "--other-properties": "value",
                    "--priority": "value",
                    "--responses": "value",
                    "--training-phrases": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--is-fallback": "bool",
                    "--ml-enabled": "bool",
                    "--other-properties": "value",
                    "--priority": "value",
                    "--responses": "value",
                    "--training-phrases": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "dlp": {
          "commands": {
            "datasources": {
              "commands": {
                "bigquery": {
                  "commands": {
                    "analyze": {
                      "commands": {},
                      "flags": {
                        "--categorical-stat-field": "value",
                        "--job-id": "value",
                        "--numerical-stat-field": "value",
                        "--output-table": "value",
                        "--output-topics": "value",
                        "--quasi-ids": "value",
                        "--sensitive-attribute": "value"
                      }
                    },
                    "inspect": {
                      "commands": {},
                      "flags": {
                        "--exclude-info-types": "bool",
                        "--identifying-fields": "value",
                        "--include-quote": "bool",
                        "--info-types": "value",
                        "--job-id": "value",
                        "--max-findings": "value",
                        "--max-findings-per-item": "value",
                        "--max-time": "value",
                        "--min-likelihood": [
                          "likely",
                          "possible",
                          "unlikely",
                          "very-likely",
                          "very-unlikely"
                        ],
                        "--min-time": "value",
                        "--output-table": "value",
                        "--output-topics": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "datastore": {
                  "commands": {
                    "inspect": {
                      "commands": {},
                      "flags": {
                        "--exclude-info-types": "bool",
                        "--include-quote": "bool",
                        "--info-types": "value",
                        "--job-id": "value",
                        "--max-findings": "value",
                        "--max-findings-per-item": "value",
                        "--max-time": "value",
                        "--min-likelihood": [
                          "likely",
                          "possible",
                          "unlikely",
                          "very-likely",
                          "very-unlikely"
                        ],
                        "--min-time": "value",
                        "--output-table": "value",
                        "--output-topics": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "gcs": {
                  "commands": {
                    "inspect": {
                      "commands": {},
                      "flags": {
                        "--exclude-info-types": "bool",
                        "--file-size-limit": "value",
                        "--include-quote": "bool",
                        "--info-types": "value",
                        "--job-id": "value",
                        "--max-findings": "value",
                        "--max-findings-per-item": "value",
                        "--max-time": "value",
                        "--min-likelihood": [
                          "likely",
                          "possible",
                          "unlikely",
                          "very-likely",
                          "very-unlikely"
                        ],
                        "--min-time": "value",
                        "--output-table": "value",
                        "--output-topics": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "images": {
              "commands": {
                "inspect": {
                  "commands": {},
                  "flags": {
                    "--exclude-info-types": "bool",
                    "--include-quote": "bool",
                    "--info-types": "value",
                    "--max-findings": "value",
                    "--min-likelihood": [
                      "likely",
                      "possible",
                      "unlikely",
                      "very-likely",
                      "very-unlikely"
                    ]
                  }
                },
                "redact": {
                  "commands": {},
                  "flags": {
                    "--include-quote": "bool",
                    "--info-types": "value",
                    "--min-likelihood": [
                      "likely",
                      "possible",
                      "unlikely",
                      "very-likely",
                      "very-unlikely"
                    ],
                    "--output-file": "value",
                    "--redact-all-text": "bool",
                    "--redact-color": "value"
                  }
                }
              },
              "flags": {}
            },
            "job-triggers": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--datastore-kind": "value",
                    "--description": "value",
                    "--display-name": "value",
                    "--exclude-info-types": "bool",
                    "--include-quote": "bool",
                    "--info-types": "value",
                    "--input-table": "value",
                    "--max-findings": "value",
                    "--max-findings-per-item": "value",
                    "--min-likelihood": [
                      "likely",
                      "possible",
                      "unlikely",
                      "very-likely",
                      "very-unlikely"
                    ],
                    "--output-table": "value",
                    "--output-topics": "value",
                    "--path": "value",
                    "--trigger-schedule": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "jobs": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--job-type": [
                      "inspect",
                      "risk-analysis"
                    ],
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "text": {
              "commands": {
                "inspect": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--exclude-info-types": "bool",
                    "--include-quote": "bool",
                    "--info-types": "value",
                    "--max-findings": "value",
                    "--min-likelihood": [
                      "likely",
                      "possible",
                      "unlikely",
                      "very-likely",
                      "very-unlikely"
                    ]
                  }
                },
                "redact": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--info-types": "value",
                    "--min-likelihood": [
                      "likely",
                      "possible",
                      "unlikely",
                      "very-likely",
                      "very-unlikely"
                    ],
                    "--output-file": "value",
                    "--remove-findings": "bool",
                    "--replace-with-info-type": "bool",
                    "--replacement-text": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "dns": {
          "commands": {
            "active-peering-zones": {
              "commands": {},
              "flags": {}
            },
            "dns-keys": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--sort-by": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "managed-zones": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--denial-of-existence": [
                      "nsec",
                      "nsec3"
                    ],
                    "--description": "value",
                    "--dns-name": "value",
                    "--dnssec-state": [
                      "off",
                      "on",
                      "transfer"
                    ],
                    "--forwarding-targets": "value",
                    "--gkeclusters": "value",
                    "--ksk-algorithm": [
                      "ecdsap256sha256",
                      "ecdsap384sha384",
                      "rsasha1",
                      "rsasha256",
                      "rsasha512"
                    ],
                    "--ksk-key-length": "value",
                    "--labels": "value",
                    "--managed-reverse-lookup": "bool",
                    "--networks": "value",
                    "--private-forwarding-targets": "value",
                    "--service-directory-namespace": "value",
                    "--target-network": "value",
                    "--target-project": "value",
                    "--visibility": [
                      "private",
                      "public"
                    ],
                    "--zsk-algorithm": [
                      "ecdsap256sha256",
                      "ecdsap384sha384",
                      "rsasha1",
                      "rsasha256",
                      "rsasha512"
                    ],
                    "--zsk-key-length": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--denial-of-existence": [
                      "nsec",
                      "nsec3"
                    ],
                    "--description": "value",
                    "--dnssec-state": [
                      "off",
                      "on",
                      "transfer"
                    ],
                    "--forwarding-targets": "value",
                    "--gkeclusters": "value",
                    "--ksk-algorithm": [
                      "ecdsap256sha256",
                      "ecdsap384sha384",
                      "rsasha1",
                      "rsasha256",
                      "rsasha512"
                    ],
                    "--ksk-key-length": "value",
                    "--managed-reverse-lookup": "bool",
                    "--networks": "value",
                    "--private-forwarding-targets": "value",
                    "--remove-labels": "value",
                    "--target-network": "value",
                    "--target-project": "value",
                    "--update-labels": "value",
                    "--zsk-algorithm": [
                      "ecdsap256sha256",
                      "ecdsap384sha384",
                      "rsasha1",
                      "rsasha256",
                      "rsasha512"
                    ],
                    "--zsk-key-length": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--sort-by": "value",
                    "--zones": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "policies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--alternative-name-servers": "value",
                    "--description": "value",
                    "--enable-inbound-forwarding": "bool",
                    "--enable-logging": "bool",
                    "--networks": "value",
                    "--private-alternative-name-servers": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--alternative-name-servers": "value",
                    "--description": "value",
                    "--enable-inbound-forwarding": "bool",
                    "--enable-logging": "bool",
                    "--networks": "value",
                    "--private-alternative-name-servers": "value"
                  }
                }
              },
              "flags": {}
            },
            "project-info": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "record-sets": {
              "commands": {
                "changes": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--sort-order": [
                          "ascending",
                          "descending"
                        ],
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--routing_policy_data": "value",
                    "--routing_policy_type": [
                      "GEO",
                      "WRR"
                    ],
                    "--rrdatas": "value",
                    "--ttl": "value",
                    "--type": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--type": "value",
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--type": "value",
                    "--zone": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic",
                    "--zone-file-format": "bool"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--delete-all-existing": "bool",
                    "--replace-origin-ns": "bool",
                    "--zone": "dynamic",
                    "--zone-file-format": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--name": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--type": "value",
                    "--uri": "bool",
                    "--zone": "dynamic"
                  }
                },
                "transaction": {
                  "commands": {
                    "abort": {
                      "commands": {},
                      "flags": {
                        "--transaction-file": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "add": {
                      "commands": {},
                      "flags": {
                        "--name": "value",
                        "--transaction-file": "value",
                        "--ttl": "value",
                        "--type": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--transaction-file": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "execute": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--transaction-file": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "remove": {
                      "commands": {},
                      "flags": {
                        "--name": "value",
                        "--transaction-file": "value",
                        "--ttl": "value",
                        "--type": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "start": {
                      "commands": {},
                      "flags": {
                        "--transaction-file": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {
                    "--transaction-file": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--routing_policy_data": "value",
                    "--routing_policy_type": [
                      "GEO",
                      "WRR"
                    ],
                    "--rrdatas": "value",
                    "--ttl": "value",
                    "--type": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "response-policies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--gkeclusters": "value",
                    "--networks": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "rules": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--behavior": [
                          "bypassresponsepolicy"
                        ],
                        "--dns-name": "value",
                        "--local-data": "value",
                        "--response-policy": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--response-policy": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--response-policy": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--behavior": [
                          "bypassresponsepolicy"
                        ],
                        "--dns-name": "value",
                        "--local-data": "value",
                        "--response-policy": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--gkeclusters": "value",
                    "--networks": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "domains": {
          "commands": {
            "registrations": {
              "commands": {
                "authorization-code": {
                  "commands": {
                    "get": {
                      "commands": {},
                      "flags": {}
                    },
                    "reset": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "configure": {
                  "commands": {
                    "contacts": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--contact-data-from-file": "value",
                        "--contact-privacy": [
                          "private-contact-data",
                          "public-contact-data",
                          "redacted-contact-data"
                        ],
                        "--notices": "value",
                        "--validate-only": "bool"
                      }
                    },
                    "dns": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--cloud-dns-zone": "value",
                        "--disable-dnssec": "bool",
                        "--dns-settings-from-file": "value",
                        "--name-servers": "value",
                        "--unsafe-dns-update": "bool",
                        "--use-google-domains-dns": "bool",
                        "--validate-only": "bool"
                      }
                    },
                    "management": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--transfer-lock-state": [
                          "locked",
                          "unlocked"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "get-register-parameters": {
                  "commands": {},
                  "flags": {}
                },
                "get-transfer-parameters": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "operations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "wait": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "register": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cloud-dns-zone": "value",
                    "--contact-data-from-file": "value",
                    "--contact-privacy": [
                      "private-contact-data",
                      "public-contact-data",
                      "redacted-contact-data"
                    ],
                    "--disable-dnssec": "bool",
                    "--labels": "value",
                    "--name-servers": "value",
                    "--notices": "value",
                    "--use-google-domains-dns": "bool",
                    "--validate-only": "bool",
                    "--yearly-price": "value"
                  }
                },
                "search-domains": {
                  "commands": {},
                  "flags": {}
                },
                "transfer": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--authorization-code-from-file": "value",
                    "--cloud-dns-zone": "value",
                    "--contact-data-from-file": "value",
                    "--contact-privacy": [
                      "private-contact-data",
                      "public-contact-data",
                      "redacted-contact-data"
                    ],
                    "--keep-dns-settings": "bool",
                    "--labels": "value",
                    "--notices": "value",
                    "--use-google-domains-dns": "bool",
                    "--validate-only": "bool",
                    "--yearly-price": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "emulators": {
          "commands": {
            "bigtable": {
              "commands": {
                "env-init": {
                  "commands": {},
                  "flags": {}
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--host-port": "value"
                  }
                }
              },
              "flags": {}
            },
            "datastore": {
              "commands": {
                "env-init": {
                  "commands": {},
                  "flags": {
                    "--data-dir": "value"
                  }
                },
                "env-unset": {
                  "commands": {},
                  "flags": {
                    "--data-dir": "value"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--consistency": "value",
                    "--data-dir": "value",
                    "--host-port": "value",
                    "--store-on-disk": "bool"
                  }
                }
              },
              "flags": {
                "--data-dir": "value"
              }
            },
            "firestore": {
              "commands": {
                "start": {
                  "commands": {},
                  "flags": {
                    "--host-port": "value",
                    "--rules": "value"
                  }
                }
              },
              "flags": {}
            },
            "pubsub": {
              "commands": {
                "env-init": {
                  "commands": {},
                  "flags": {
                    "--data-dir": "value"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--data-dir": "value",
                    "--host-port": "value"
                  }
                }
              },
              "flags": {
                "--data-dir": "value"
              }
            },
            "spanner": {
              "commands": {
                "env-init": {
                  "commands": {},
                  "flags": {}
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--enable-fault-injection": "value",
                    "--host-port": "value",
                    "--rest-port": "value",
                    "--use-docker": "value"
                  }
                }
              },
              "flags": {}
            },
            "start": {
              "commands": {},
              "flags": {
                "--emulators": "value",
                "--proxy-port": "value",
                "--route-to-public": "value"
              }
            }
          },
          "flags": {}
        },
        "endpoints": {
          "commands": {
            "configs": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--service": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--service": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--service": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "quota": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--consumer": "value",
                    "--dimensions": "value",
                    "--force": "bool",
                    "--metric": "value",
                    "--service": "value",
                    "--unit": "value",
                    "--value": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--consumer": "value",
                    "--force": "bool",
                    "--metric": "value",
                    "--override-id": "value",
                    "--service": "value",
                    "--unit": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--consumer": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--service": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--consumer": "value",
                    "--dimensions": "value",
                    "--force": "bool",
                    "--metric": "value",
                    "--service": "value",
                    "--unit": "value",
                    "--value": "value"
                  }
                }
              },
              "flags": {}
            },
            "services": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "check-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "deploy": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--force": "bool",
                    "--validate-only": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "undelete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "essential-contacts": {
          "commands": {
            "compute": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--folder": "value",
                "--limit": "value",
                "--notification-categories": "value",
                "--organization": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "create": {
              "commands": {},
              "flags": {
                "--email": "value",
                "--folder": "value",
                "--language": "value",
                "--notification-categories": "value",
                "--organization": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--folder": "value",
                "--organization": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--folder": "value",
                "--organization": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--folder": "value",
                "--limit": "value",
                "--organization": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--folder": "value",
                "--language": "value",
                "--notification-categories": "value",
                "--organization": "value"
              }
            }
          },
          "flags": {}
        },
        "filestore": {
          "commands": {
            "backups": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--file-share": "value",
                    "--instance": "value",
                    "--instance-zone": "value",
                    "--labels": "value",
                    "--region": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--region": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "instances": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--file-share": "value",
                    "--labels": "value",
                    "--location": "value",
                    "--network": "value",
                    "--region": "value",
                    "--tier": [
                      "basic-hdd",
                      "basic-ssd",
                      "enterprise",
                      "high-scale-ssd",
                      "premium",
                      "standard"
                    ],
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "value"
                  }
                },
                "restore": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--file-share": "value",
                    "--source-backup": "value",
                    "--source-backup-region": "value",
                    "--source-snapshot": "value",
                    "--source-snapshot-region": "value",
                    "--zone": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--file-share": "value",
                    "--location": "value",
                    "--region": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value",
                    "--zone": "value"
                  }
                }
              },
              "flags": {}
            },
            "locations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "value"
                  }
                }
              },
              "flags": {}
            },
            "regions": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "snapshots": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--file-share": "value",
                    "--instance": "value",
                    "--instance-zone": "value",
                    "--labels": "value",
                    "--region": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--region": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value",
                    "--zone": "value"
                  }
                }
              },
              "flags": {}
            },
            "zones": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "firebase": {
          "commands": {
            "test": {
              "commands": {
                "android": {
                  "commands": {
                    "locales": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {}
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "models": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {}
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "run": {
                      "commands": {},
                      "flags": {
                        "--additional-apks": "value",
                        "--app": "value",
                        "--app-package": "value",
                        "--async": "bool",
                        "--auto-google-login": "bool",
                        "--client-details": "value",
                        "--device": "value",
                        "--device-ids": "value",
                        "--directories-to-pull": "value",
                        "--environment-variables": "value",
                        "--filter": "value",
                        "--grant-permissions": [
                          "all",
                          "none"
                        ],
                        "--limit": "value",
                        "--locales": "value",
                        "--network-profile": "value",
                        "--num-flaky-test-attempts": "value",
                        "--num-uniform-shards": "value",
                        "--obb-files": "value",
                        "--orientations": "dynamic",
                        "--os-version-ids": "value",
                        "--other-files": "value",
                        "--page-size": "value",
                        "--performance-metrics": "bool",
                        "--record-video": "bool",
                        "--resign": "bool",
                        "--results-bucket": "value",
                        "--results-dir": "value",
                        "--results-history-name": "value",
                        "--robo-directives": "value",
                        "--robo-script": "value",
                        "--scenario-labels": "value",
                        "--scenario-numbers": "value",
                        "--sort-by": "value",
                        "--test": "value",
                        "--test-package": "value",
                        "--test-runner-class": "value",
                        "--test-targets": "value",
                        "--test-targets-for-shard": "value",
                        "--timeout": "value",
                        "--type": [
                          "game-loop",
                          "instrumentation",
                          "robo"
                        ],
                        "--use-orchestrator": "bool"
                      }
                    },
                    "versions": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {}
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "ios": {
                  "commands": {
                    "locales": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {}
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "models": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {}
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "run": {
                      "commands": {},
                      "flags": {
                        "--additional-ipas": "value",
                        "--app": "value",
                        "--async": "bool",
                        "--client-details": "value",
                        "--device": "value",
                        "--directories-to-pull": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--num-flaky-test-attempts": "value",
                        "--other-files": "value",
                        "--page-size": "value",
                        "--record-video": "bool",
                        "--results-bucket": "value",
                        "--results-dir": "value",
                        "--results-history-name": "value",
                        "--scenario-numbers": "value",
                        "--sort-by": "value",
                        "--test": "value",
                        "--test-special-entitlements": "bool",
                        "--timeout": "value",
                        "--type": [
                          "game-loop",
                          "xctest"
                        ],
                        "--xcode-version": "value",
                        "--xctestrun-file": "value"
                      }
                    },
                    "versions": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {}
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "ip-blocks": {
                  "commands": {
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "network-profiles": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "firestore": {
          "commands": {
            "databases": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                }
              },
              "flags": {}
            },
            "export": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--collection-ids": "value"
              }
            },
            "import": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--collection-ids": "value"
              }
            },
            "indexes": {
              "commands": {
                "composite": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--collection-group": "value",
                        "--field-config": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {}
                    },
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "fields": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--collection-group": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--collection-group": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--clear-exemption": "bool",
                        "--collection-group": "value",
                        "--disable-indexes": "bool",
                        "--index": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "functions": {
          "commands": {
            "add-iam-policy-binding": {
              "commands": {},
              "flags": {
                "--member": "value",
                "--region": "dynamic",
                "--role": "value",
                "--v2": "bool"
              }
            },
            "add-invoker-policy-binding": {
              "commands": {},
              "flags": {
                "--member": "value",
                "--region": "dynamic"
              }
            },
            "call": {
              "commands": {},
              "flags": {
                "--cloud-event": "value",
                "--data": "value",
                "--region": "dynamic",
                "--v2": "bool"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--region": "dynamic",
                "--v2": "bool"
              }
            },
            "deploy": {
              "commands": {},
              "flags": {
                "--allow-unauthenticated": "bool",
                "--build-env-vars-file": "value",
                "--build-worker-pool": "value",
                "--clear-build-env-vars": "bool",
                "--clear-build-worker-pool": "bool",
                "--clear-docker-repository": "bool",
                "--clear-env-vars": "bool",
                "--clear-kms-key": "bool",
                "--clear-labels": "bool",
                "--clear-max-instances": "bool",
                "--clear-min-instances": "bool",
                "--clear-secrets": "bool",
                "--clear-vpc-connector": "bool",
                "--docker-repository": "value",
                "--egress-settings": [
                  "all",
                  "private-ranges-only"
                ],
                "--entry-point": "value",
                "--env-vars-file": "value",
                "--ignore-file": "value",
                "--ingress-settings": [
                  "all",
                  "internal-and-gclb",
                  "internal-only"
                ],
                "--kms-key": "value",
                "--max-instances": "value",
                "--memory": "value",
                "--min-instances": "value",
                "--region": "dynamic",
                "--remove-build-env-vars": "value",
                "--remove-env-vars": "value",
                "--remove-labels": "value",
                "--remove-secrets": "value",
                "--retry": "bool",
                "--run-service-account": "value",
                "--runtime": "value",
                "--security-level": [
                  "secure-always",
                  "secure-optional"
                ],
                "--service-account": "value",
                "--set-build-env-vars": "value",
                "--set-env-vars": "value",
                "--set-secrets": "value",
                "--signature-type": [
                  "cloudevent",
                  "event",
                  "http"
                ],
                "--source": "value",
                "--stage-bucket": "value",
                "--timeout": "value",
                "--trigger-bucket": "value",
                "--trigger-event": "value",
                "--trigger-event-filters": "value",
                "--trigger-http": "bool",
                "--trigger-location": "dynamic",
                "--trigger-resource": "value",
                "--trigger-service-account": "value",
                "--trigger-topic": "value",
                "--update-build-env-vars": "value",
                "--update-env-vars": "value",
                "--update-labels": "value",
                "--update-secrets": "value",
                "--v2": "bool",
                "--vpc-connector": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "dynamic",
                "--v2": "bool"
              }
            },
            "event-types": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--v2": "bool"
                  }
                }
              },
              "flags": {}
            },
            "get-iam-policy": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "dynamic",
                "--sort-by": "value",
                "--uri": "bool",
                "--v2": "bool"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--regions": "value",
                "--sort-by": "value",
                "--v2": "bool"
              }
            },
            "logs": {
              "commands": {
                "read": {
                  "commands": {},
                  "flags": {
                    "--end-time": "value",
                    "--execution-id": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--min-log-level": [
                      "debug",
                      "error",
                      "info"
                    ],
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--start-time": "value",
                    "--uri": "bool",
                    "--v2": "bool"
                  }
                }
              },
              "flags": {}
            },
            "regions": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--v2": "bool"
                  }
                }
              },
              "flags": {}
            },
            "remove-iam-policy-binding": {
              "commands": {},
              "flags": {
                "--member": "value",
                "--region": "dynamic",
                "--role": "value",
                "--v2": "bool"
              }
            },
            "remove-invoker-policy-binding": {
              "commands": {},
              "flags": {
                "--member": "value",
                "--region": "dynamic"
              }
            },
            "set-iam-policy": {
              "commands": {},
              "flags": {
                "--region": "dynamic",
                "--v2": "bool"
              }
            }
          },
          "flags": {}
        },
        "game": {
          "commands": {
            "locations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "servers": {
              "commands": {
                "clusters": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--allocation-priority": [
                          "p1",
                          "p2",
                          "p3",
                          "p4",
                          "priority-unspecified"
                        ],
                        "--description": "value",
                        "--dry-run": "bool",
                        "--gke-cluster": "value",
                        "--hub-membership": "value",
                        "--labels": "value",
                        "--location": "value",
                        "--namespace": "value",
                        "--preview-time": "value",
                        "--realm": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--dry-run": "bool",
                        "--location": "value",
                        "--preview-time": "value",
                        "--realm": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--realm": "value",
                        "--view": [
                          "basic",
                          "full"
                        ]
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--realm": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--view": [
                          "basic",
                          "full"
                        ]
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--allocation-priority": [
                          "p1",
                          "p2",
                          "p3",
                          "p4",
                          "priority-unspecified"
                        ],
                        "--clear-labels": "bool",
                        "--description": "value",
                        "--dry-run": "bool",
                        "--location": "value",
                        "--preview-time": "value",
                        "--realm": "value",
                        "--remove-labels": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "configs": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--deployment": "value",
                        "--description": "value",
                        "--fleet-configs-file": "value",
                        "--labels": "value",
                        "--location": "value",
                        "--scaling-configs-file": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--deployment": "value",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--deployment": "value",
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--deployment": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "deployments": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--description": "value",
                        "--labels": "value",
                        "--location": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "describe-rollout": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "fetch-state": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--clear-labels": "bool",
                        "--description": "value",
                        "--location": "value",
                        "--remove-labels": "value",
                        "--update-labels": "value"
                      }
                    },
                    "update-rollout": {
                      "commands": {},
                      "flags": {
                        "--clear-config-overrides": "bool",
                        "--clear-default-config": "bool",
                        "--config-overrides-file": "value",
                        "--default-config": "value",
                        "--dry-run": "bool",
                        "--location": "value",
                        "--preview-time": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "realms": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--description": "value",
                        "--labels": "value",
                        "--location": "value",
                        "--time-zone": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--clear-labels": "bool",
                        "--description": "value",
                        "--dry-run": "bool",
                        "--location": "value",
                        "--preview-time": "value",
                        "--remove-labels": "value",
                        "--time-zone": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "genomics": {
          "commands": {
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "pipelines": {
              "commands": {
                "run": {
                  "commands": {},
                  "flags": {
                    "--boot-disk-size": "value",
                    "--command-line": "value",
                    "--cpus": "value",
                    "--disk-size": "value",
                    "--docker-image": "value",
                    "--env-vars": "value",
                    "--inputs": "value",
                    "--inputs-from-file": "value",
                    "--labels": "value",
                    "--logging": "value",
                    "--memory": "value",
                    "--network": "value",
                    "--outputs": "value",
                    "--pipeline-file": "value",
                    "--preemptible": "bool",
                    "--regions": "value",
                    "--service-account-email": "value",
                    "--service-account-scopes": "value",
                    "--subnetwork": "value",
                    "--zones": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "healthcare": {
          "commands": {
            "annotation-stores": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "evaluate": {
                  "commands": {
                    "bq": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--bq-table": "value",
                        "--dataset": "value",
                        "--golden-store": "value",
                        "--location": "value",
                        "--write-disposition": [
                          "write-append",
                          "write-empty",
                          "write-truncate"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "export": {
                  "commands": {
                    "bq": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--bq-table": "value",
                        "--dataset": "value",
                        "--location": "value",
                        "--write-disposition": [
                          "write-append",
                          "write-empty",
                          "write-truncate"
                        ]
                      }
                    },
                    "gcs": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--dataset": "value",
                        "--gcs-uri": "value",
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "import": {
                  "commands": {
                    "gcs": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--dataset": "value",
                        "--gcs-uri": "value",
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            },
            "consent-stores": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "check-data-access": {
                  "commands": {},
                  "flags": {
                    "--data-id": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--request-attributes": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--labels": "value",
                    "--location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "evaluate-user-consents": {
                  "commands": {},
                  "flags": {
                    "--consent-list": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--page-token": "value",
                    "--request-attributes": "value",
                    "--resource-attributes": "value",
                    "--response-view": [
                      "basic",
                      "full",
                      "response-view-unspecified"
                    ],
                    "--user-id": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "query-accessible-data": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--dataset": "value",
                    "--gcs-uri": "value",
                    "--location": "value",
                    "--request-attributes": "value",
                    "--resource-attributes": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--dataset": "value",
                    "--location": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "datasets": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--storage-class": [
                      "archive",
                      "blob-storage-class-unspecified",
                      "coldline",
                      "nearline",
                      "standard"
                    ],
                    "--time-zone": "value"
                  }
                },
                "deidentify": {
                  "commands": {},
                  "flags": {
                    "--annotation-store": "value",
                    "--async": "bool",
                    "--default-fhir-config": "bool",
                    "--destination-dataset": "value",
                    "--dicom-filter-tags": "value",
                    "--location": "value",
                    "--text-redaction-mode": [
                      "all"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--time-zone": "value"
                  }
                }
              },
              "flags": {}
            },
            "dicom-stores": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value",
                    "--pubsub-topic": "value",
                    "--send-for-bulk-import": "bool"
                  }
                },
                "deidentify": {
                  "commands": {},
                  "flags": {
                    "--annotation-store": "value",
                    "--async": "bool",
                    "--dataset": "value",
                    "--destination-store": "value",
                    "--dicom-filter-tags": "value",
                    "--location": "value",
                    "--text-redaction-mode": [
                      "all"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "export": {
                  "commands": {
                    "bq": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--bq-table": "value",
                        "--dataset": "value",
                        "--filter-config-gcs-uri": "value",
                        "--location": "value",
                        "--overwrite-table": "bool",
                        "--write-disposition": [
                          "write-append",
                          "write-empty",
                          "write-truncate"
                        ]
                      }
                    },
                    "gcs": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--dataset": "value",
                        "--filter-config-gcs-uri": "value",
                        "--gcs-uri-prefix": "value",
                        "--location": "value",
                        "--mime-type": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "import": {
                  "commands": {
                    "gcs": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--dataset": "value",
                        "--gcs-uri": "value",
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value",
                    "--pubsub-topic": "value",
                    "--send-for-bulk-import": "bool"
                  }
                }
              },
              "flags": {}
            },
            "fhir-stores": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--disable-referential-integrity": "bool",
                    "--disable-resource-versioning": "bool",
                    "--enable-update-create": "bool",
                    "--location": "value",
                    "--pubsub-topic": "value"
                  }
                },
                "deidentify": {
                  "commands": {},
                  "flags": {
                    "--annotation-store": "value",
                    "--async": "bool",
                    "--dataset": "value",
                    "--destination-store": "value",
                    "--location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "export": {
                  "commands": {
                    "bq": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--bq-dataset": "value",
                        "--dataset": "value",
                        "--location": "value",
                        "--recursive-depth": "value",
                        "--schema-type": [
                          "analytics",
                          "lossless"
                        ],
                        "--write-disposition": [
                          "write-append",
                          "write-empty",
                          "write-truncate"
                        ]
                      }
                    },
                    "gcs": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--dataset": "value",
                        "--gcs-uri": "value",
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "import": {
                  "commands": {
                    "gcs": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--content-structure": [
                          "bundle",
                          "bundle-pretty",
                          "resource",
                          "resource-pretty"
                        ],
                        "--dataset": "value",
                        "--error-gcs-uri": "value",
                        "--gcs-uri": "value",
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--enable-update-create": "bool",
                    "--location": "value",
                    "--pubsub-topic": "value"
                  }
                }
              },
              "flags": {}
            },
            "hl7v2-stores": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value",
                    "--pubsub-topic": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "export": {
                  "commands": {
                    "gcs": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--dataset": "value",
                        "--end-time": "value",
                        "--gcs-uri": "value",
                        "--location": "value",
                        "--message-view": [
                          "basic",
                          "full",
                          "parsed-only",
                          "raw-only",
                          "schematized-only"
                        ],
                        "--start-time": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "import": {
                  "commands": {
                    "gcs": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--dataset": "value",
                        "--gcs-uri": "value",
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value",
                    "--pubsub-topic": "value"
                  }
                }
              },
              "flags": {}
            },
            "nlp": {
              "commands": {
                "analyze-entities": {
                  "commands": {},
                  "flags": {
                    "--document-content": "value",
                    "--nlp-service": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "help": {
          "commands": {},
          "flags": {
            "--filter": "value",
            "--limit": "value",
            "--page-size": "value",
            "--sort-by": "value"
          }
        },
        "iam": {
          "commands": {
            "list-grantable-roles": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--page-size": "value"
              }
            },
            "list-testable-permissions": {
              "commands": {},
              "flags": {
                "--filter": "value"
              }
            },
            "policies": {
              "commands": {
                "lint-condition": {
                  "commands": {},
                  "flags": {
                    "--condition-from-file": "value",
                    "--description": "value",
                    "--expression": "value",
                    "--resource-name": "value",
                    "--title": "value"
                  }
                }
              },
              "flags": {}
            },
            "roles": {
              "commands": {
                "copy": {
                  "commands": {},
                  "flags": {
                    "--dest-organization": "value",
                    "--dest-project": "value",
                    "--destination": "value",
                    "--source": "value",
                    "--source-organization": "value",
                    "--source-project": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--file": "value",
                    "--organization": "value",
                    "--permissions": "value",
                    "--stage": "value",
                    "--title": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--show-deleted": "bool",
                    "--sort-by": "value"
                  }
                },
                "undelete": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-permissions": "value",
                    "--description": "value",
                    "--file": "value",
                    "--organization": "value",
                    "--permissions": "value",
                    "--remove-permissions": "value",
                    "--stage": "value",
                    "--title": "value"
                  }
                }
              },
              "flags": {}
            },
            "service-accounts": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "disable": {
                  "commands": {},
                  "flags": {}
                },
                "enable": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "keys": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--iam-account": "value",
                        "--key-file-type": [
                          "json",
                          "p12"
                        ]
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--iam-account": "value"
                      }
                    },
                    "disable": {
                      "commands": {},
                      "flags": {
                        "--iam-account": "dynamic"
                      }
                    },
                    "enable": {
                      "commands": {},
                      "flags": {
                        "--iam-account": "dynamic"
                      }
                    },
                    "get-public-key": {
                      "commands": {},
                      "flags": {
                        "--iam-account": "value",
                        "--output-file": "value",
                        "--type": [
                          "pem",
                          "raw"
                        ]
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--created-before": "value",
                        "--filter": "value",
                        "--iam-account": "value",
                        "--limit": "value",
                        "--managed-by": [
                          "any",
                          "system",
                          "user"
                        ],
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "upload": {
                      "commands": {},
                      "flags": {
                        "--iam-account": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "sign-blob": {
                  "commands": {},
                  "flags": {
                    "--iam-account": "value"
                  }
                },
                "sign-jwt": {
                  "commands": {},
                  "flags": {
                    "--iam-account": "value"
                  }
                },
                "undelete": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value"
                  }
                }
              },
              "flags": {}
            },
            "workload-identity-pools": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--disabled": "bool",
                    "--display-name": "value",
                    "--location": "value"
                  }
                },
                "create-cred-config": {
                  "commands": {},
                  "flags": {
                    "--app-id-uri": "value",
                    "--aws": "bool",
                    "--azure": "bool",
                    "--credential-source-field-name": "value",
                    "--credential-source-file": "value",
                    "--credential-source-headers": "value",
                    "--credential-source-type": "value",
                    "--credential-source-url": "value",
                    "--output-file": "value",
                    "--service-account": "value",
                    "--subject-token-type": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--show-deleted": "bool",
                    "--sort-by": "value"
                  }
                },
                "operations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--workload-identity-pool": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "providers": {
                  "commands": {
                    "create-aws": {
                      "commands": {},
                      "flags": {
                        "--account-id": "value",
                        "--attribute-condition": "value",
                        "--attribute-mapping": "value",
                        "--description": "value",
                        "--disabled": "bool",
                        "--display-name": "value",
                        "--location": "value",
                        "--workload-identity-pool": "dynamic"
                      }
                    },
                    "create-oidc": {
                      "commands": {},
                      "flags": {
                        "--allowed-audiences": "value",
                        "--attribute-condition": "value",
                        "--attribute-mapping": "value",
                        "--description": "value",
                        "--disabled": "bool",
                        "--display-name": "value",
                        "--issuer-uri": "value",
                        "--location": "value",
                        "--workload-identity-pool": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--workload-identity-pool": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--workload-identity-pool": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--show-deleted": "bool",
                        "--sort-by": "value",
                        "--workload-identity-pool": "dynamic"
                      }
                    },
                    "operations": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--location": "value",
                            "--provider": "dynamic",
                            "--workload-identity-pool": "dynamic"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "undelete": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--workload-identity-pool": "dynamic"
                      }
                    },
                    "update-aws": {
                      "commands": {},
                      "flags": {
                        "--account-id": "value",
                        "--attribute-condition": "value",
                        "--attribute-mapping": "value",
                        "--description": "value",
                        "--disabled": "bool",
                        "--display-name": "value",
                        "--location": "value",
                        "--workload-identity-pool": "dynamic"
                      }
                    },
                    "update-oidc": {
                      "commands": {},
                      "flags": {
                        "--allowed-audiences": "value",
                        "--attribute-condition": "value",
                        "--attribute-mapping": "value",
                        "--description": "value",
                        "--disabled": "bool",
                        "--display-name": "value",
                        "--issuer-uri": "value",
                        "--location": "value",
                        "--workload-identity-pool": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "undelete": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--disabled": "bool",
                    "--display-name": "value",
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "iap": {
          "commands": {
            "oauth-brands": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--application_title": "value",
                    "--support_email": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "oauth-clients": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--display_name": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--brand": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--brand": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "reset-secret": {
                  "commands": {},
                  "flags": {
                    "--brand": "value"
                  }
                }
              },
              "flags": {}
            },
            "settings": {
              "commands": {
                "get": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value",
                    "--region": "value",
                    "--resource-type": [
                      "app-engine",
                      "compute",
                      "folder",
                      "iap_web",
                      "organization"
                    ],
                    "--service": "value"
                  }
                },
                "set": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value",
                    "--region": "value",
                    "--resource-type": [
                      "app-engine",
                      "compute",
                      "folder",
                      "iap_web",
                      "organization"
                    ],
                    "--service": "value"
                  }
                }
              },
              "flags": {}
            },
            "web": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--region": "value",
                    "--resource-type": [
                      "app-engine",
                      "backend-services",
                      "iap_gateway"
                    ],
                    "--role": "value",
                    "--service": "value"
                  }
                },
                "disable": {
                  "commands": {},
                  "flags": {
                    "--resource-type": [
                      "app-engine",
                      "backend-services"
                    ],
                    "--service": "value"
                  }
                },
                "enable": {
                  "commands": {},
                  "flags": {
                    "--oauth2-client-id": "value",
                    "--oauth2-client-secret": "value",
                    "--resource-type": [
                      "app-engine",
                      "backend-services"
                    ],
                    "--service": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--resource-type": [
                      "app-engine",
                      "backend-services",
                      "iap_gateway"
                    ],
                    "--service": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--region": "value",
                    "--resource-type": [
                      "app-engine",
                      "backend-services",
                      "iap_gateway"
                    ],
                    "--role": "value",
                    "--service": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--resource-type": [
                      "app-engine",
                      "backend-services",
                      "iap_gateway"
                    ],
                    "--service": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "identity": {
          "commands": {
            "groups": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--dynamic-user-query": "value",
                    "--group-type": [
                      "discussion",
                      "dynamic",
                      "security"
                    ],
                    "--labels": "value",
                    "--organization": "value",
                    "--posix-group": "value",
                    "--with-initial-owner": [
                      "empty",
                      "with-initial-owner"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "memberships": {
                  "commands": {
                    "add": {
                      "commands": {},
                      "flags": {
                        "--expiration": "value",
                        "--group-email": "value",
                        "--member-email": "value",
                        "--organization": "value",
                        "--roles": "value"
                      }
                    },
                    "check-transitive-membership": {
                      "commands": {},
                      "flags": {
                        "--group-email": "value",
                        "--member-email": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--group-email": "value",
                        "--member-email": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--group-email": "value",
                        "--member-email": "value"
                      }
                    },
                    "get-membership-graph": {
                      "commands": {},
                      "flags": {
                        "--group-email": "value",
                        "--labels": "value",
                        "--member-email": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--group-email": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--page-token": "value",
                        "--sort-by": "value",
                        "--view": [
                          "basic",
                          "full"
                        ]
                      }
                    },
                    "modify-membership-roles": {
                      "commands": {},
                      "flags": {
                        "--add-roles": "value",
                        "--group-email": "value",
                        "--member-email": "value",
                        "--remove-roles": "value",
                        "--update-roles-params": "value"
                      }
                    },
                    "search-transitive-groups": {
                      "commands": {},
                      "flags": {
                        "--labels": "value",
                        "--member-email": "value",
                        "--page-size": "value",
                        "--page-token": "value"
                      }
                    },
                    "search-transitive-memberships": {
                      "commands": {},
                      "flags": {
                        "--group-email": "value",
                        "--page-size": "value",
                        "--page-token": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "preview": {
                  "commands": {},
                  "flags": {
                    "--custom-field-mask": "value",
                    "--customer": "value",
                    "--max-results": "value",
                    "--page-token": "value",
                    "--projection": [
                      "basic",
                      "custom",
                      "full"
                    ],
                    "--query": "value",
                    "--view-type": [
                      "admin-view",
                      "domain-public"
                    ]
                  }
                },
                "search": {
                  "commands": {},
                  "flags": {
                    "--labels": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--page-token": "value",
                    "--view": [
                      "basic",
                      "full"
                    ]
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-posix-group": "value",
                    "--clear-description": "bool",
                    "--clear-display-name": "bool",
                    "--clear-posix-groups": "bool",
                    "--description": "value",
                    "--display-name": "value",
                    "--dynamic-user-query": "value",
                    "--remove-posix-groups": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "ids": {
          "commands": {
            "endpoints": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--enable-traffic-logs": "bool",
                    "--labels": "value",
                    "--max-wait": "value",
                    "--network": "value",
                    "--severity": [
                      "CRITICAL",
                      "HIGH",
                      "INFORMATIONAL",
                      "LOW",
                      "MEDIUM"
                    ],
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--max-wait": "value",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "init": {
          "commands": {},
          "flags": {
            "--console-only": "bool",
            "--no-launch-browser": "bool",
            "--skip-diagnostics": "bool"
          }
        },
        "interactive": {
          "commands": {},
          "flags": {
            "--context": "value"
          }
        },
        "iot": {
          "commands": {
            "devices": {
              "commands": {
                "commands": {
                  "commands": {
                    "send": {
                      "commands": {},
                      "flags": {
                        "--command-data": "value",
                        "--command-file": "value",
                        "--device": "dynamic",
                        "--region": "value",
                        "--registry": "dynamic",
                        "--subfolder": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "configs": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "get-value": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--registry": "dynamic",
                        "--sort-by": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--config-data": "value",
                        "--config-file": "value",
                        "--device": "dynamic",
                        "--region": "value",
                        "--registry": "dynamic",
                        "--version-to-update": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--auth-method": [
                      "association-and-device-auth-token",
                      "association-only",
                      "device-auth-token-only"
                    ],
                    "--blocked": "bool",
                    "--device-type": [
                      "gateway",
                      "non-gateway"
                    ],
                    "--log-level": [
                      "debug",
                      "error",
                      "info",
                      "none"
                    ],
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--public-key": "value",
                    "--region": "value",
                    "--registry": "dynamic"
                  }
                },
                "credentials": {
                  "commands": {
                    "clear": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--expiration-time": "value",
                        "--path": "value",
                        "--region": "value",
                        "--registry": "dynamic",
                        "--type": [
                          "es256",
                          "es256-pem",
                          "es256-x509-pem",
                          "rs256",
                          "rsa-pem",
                          "rsa-x509-pem"
                        ]
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--filter": "value",
                        "--limit": "value",
                        "--region": "value",
                        "--registry": "dynamic",
                        "--sort-by": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--expiration-time": "value",
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--registry": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--registry": "dynamic"
                  }
                },
                "gateways": {
                  "commands": {
                    "bind": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--device-region": "value",
                        "--device-registry": "dynamic",
                        "--gateway": "dynamic",
                        "--gateway-region": "value",
                        "--gateway-registry": "dynamic"
                      }
                    },
                    "list-bound-devices": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--gateway": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--registry": "dynamic",
                        "--sort-by": "value"
                      }
                    },
                    "unbind": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--device-region": "value",
                        "--device-registry": "dynamic",
                        "--gateway": "dynamic",
                        "--gateway-region": "value",
                        "--gateway-registry": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--device-ids": "value",
                    "--device-num-ids": "value",
                    "--device-type": [
                      "gateway",
                      "non-gateway"
                    ],
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--registry": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "states": {
                  "commands": {
                    "list": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--registry": "dynamic",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--auth-method": [
                      "association-and-device-auth-token",
                      "association-only",
                      "device-auth-token-only"
                    ],
                    "--blocked": "bool",
                    "--log-level": [
                      "debug",
                      "error",
                      "info",
                      "none"
                    ],
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--region": "value",
                    "--registry": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "registries": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--region": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--enable-http-config": "bool",
                    "--enable-mqtt-config": "bool",
                    "--event-notification-config": "value",
                    "--log-level": [
                      "debug",
                      "error",
                      "info",
                      "none"
                    ],
                    "--public-key-path": "value",
                    "--region": "value",
                    "--state-pubsub-topic": "value"
                  }
                },
                "credentials": {
                  "commands": {
                    "clear": {
                      "commands": {},
                      "flags": {
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--path": "value",
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--region": "value",
                        "--registry": "dynamic",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--region": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--enable-http-config": "bool",
                    "--enable-mqtt-config": "bool",
                    "--event-notification-config": "value",
                    "--log-level": [
                      "debug",
                      "error",
                      "info",
                      "none"
                    ],
                    "--region": "value",
                    "--state-pubsub-topic": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "kms": {
          "commands": {
            "asymmetric-decrypt": {
              "commands": {},
              "flags": {
                "--ciphertext-file": "value",
                "--key": "dynamic",
                "--keyring": "dynamic",
                "--location": "dynamic",
                "--plaintext-file": "value",
                "--skip-integrity-verification": "bool"
              }
            },
            "asymmetric-sign": {
              "commands": {},
              "flags": {
                "--digest-algorithm": [
                  "sha256",
                  "sha384",
                  "sha512"
                ],
                "--input-file": "value",
                "--key": "dynamic",
                "--keyring": "dynamic",
                "--location": "dynamic",
                "--signature-file": "value",
                "--skip-integrity-verification": "bool"
              }
            },
            "decrypt": {
              "commands": {},
              "flags": {
                "--additional-authenticated-data-file": "value",
                "--ciphertext-file": "value",
                "--key": "dynamic",
                "--keyring": "dynamic",
                "--location": "dynamic",
                "--plaintext-file": "value",
                "--skip-integrity-verification": "bool"
              }
            },
            "encrypt": {
              "commands": {},
              "flags": {
                "--additional-authenticated-data-file": "value",
                "--ciphertext-file": "value",
                "--key": "dynamic",
                "--keyring": "dynamic",
                "--location": "dynamic",
                "--plaintext-file": "value",
                "--skip-integrity-verification": "bool"
              }
            },
            "import-jobs": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--keyring": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--import-method": [
                      "rsa-oaep-3072-sha1-aes-256",
                      "rsa-oaep-4096-sha1-aes-256"
                    ],
                    "--keyring": "dynamic",
                    "--location": "dynamic",
                    "--protection-level": [
                      "hsm",
                      "software"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--attestation-file": "value",
                    "--keyring": "dynamic",
                    "--location": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--keyring": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--keyring": "dynamic",
                    "--limit": "value",
                    "--location": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--keyring": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--keyring": "value",
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            },
            "keyrings": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "keys": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--keyring": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--default-algorithm": [
                      "ec-sign-p256-sha256",
                      "ec-sign-p384-sha384",
                      "ec-sign-secp256k1-sha256",
                      "external-symmetric-encryption",
                      "google-symmetric-encryption",
                      "rsa-decrypt-oaep-2048-sha256",
                      "rsa-decrypt-oaep-3072-sha256",
                      "rsa-decrypt-oaep-4096-sha256",
                      "rsa-decrypt-oaep-4096-sha512",
                      "rsa-sign-pkcs1-2048-sha256",
                      "rsa-sign-pkcs1-3072-sha256",
                      "rsa-sign-pkcs1-4096-sha256",
                      "rsa-sign-pkcs1-4096-sha512",
                      "rsa-sign-pss-2048-sha256",
                      "rsa-sign-pss-3072-sha256",
                      "rsa-sign-pss-4096-sha256",
                      "rsa-sign-pss-4096-sha512"
                    ],
                    "--keyring": "dynamic",
                    "--labels": "value",
                    "--location": "dynamic",
                    "--next-rotation-time": "value",
                    "--protection-level": [
                      "external",
                      "hsm",
                      "software"
                    ],
                    "--purpose": [
                      "asymmetric-encryption",
                      "asymmetric-signing",
                      "encryption"
                    ],
                    "--rotation-period": "value",
                    "--skip-initial-version-creation": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--keyring": "dynamic",
                    "--location": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--keyring": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--keyring": "dynamic",
                    "--limit": "value",
                    "--location": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--keyring": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "remove-rotation-schedule": {
                  "commands": {},
                  "flags": {
                    "--keyring": "dynamic",
                    "--location": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--keyring": "value",
                    "--location": "value"
                  }
                },
                "set-primary-version": {
                  "commands": {},
                  "flags": {
                    "--keyring": "dynamic",
                    "--location": "dynamic"
                  }
                },
                "set-rotation-schedule": {
                  "commands": {},
                  "flags": {
                    "--keyring": "dynamic",
                    "--location": "dynamic",
                    "--next-rotation-time": "value",
                    "--rotation-period": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--default-algorithm": [
                      "ec-sign-p256-sha256",
                      "ec-sign-p384-sha384",
                      "ec-sign-secp256k1-sha256",
                      "external-symmetric-encryption",
                      "google-symmetric-encryption",
                      "rsa-decrypt-oaep-2048-sha256",
                      "rsa-decrypt-oaep-3072-sha256",
                      "rsa-decrypt-oaep-4096-sha256",
                      "rsa-decrypt-oaep-4096-sha512",
                      "rsa-sign-pkcs1-2048-sha256",
                      "rsa-sign-pkcs1-3072-sha256",
                      "rsa-sign-pkcs1-4096-sha256",
                      "rsa-sign-pkcs1-4096-sha512",
                      "rsa-sign-pss-2048-sha256",
                      "rsa-sign-pss-3072-sha256",
                      "rsa-sign-pss-4096-sha256",
                      "rsa-sign-pss-4096-sha512"
                    ],
                    "--keyring": "dynamic",
                    "--location": "dynamic",
                    "--next-rotation-time": "value",
                    "--primary-version": "dynamic",
                    "--remove-labels": "value",
                    "--remove-rotation-schedule": "bool",
                    "--rotation-period": "value",
                    "--update-labels": "value"
                  }
                },
                "versions": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--external-key-uri": "value",
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic",
                        "--primary": "bool"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--attestation-file": "value",
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic"
                      }
                    },
                    "destroy": {
                      "commands": {},
                      "flags": {
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic"
                      }
                    },
                    "disable": {
                      "commands": {},
                      "flags": {
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic"
                      }
                    },
                    "enable": {
                      "commands": {},
                      "flags": {
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic"
                      }
                    },
                    "get-certificate-chain": {
                      "commands": {},
                      "flags": {
                        "--certificate-chain-type": [
                          "all",
                          "cavium",
                          "google-card",
                          "google-partition"
                        ],
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic",
                        "--output-file": "value"
                      }
                    },
                    "get-public-key": {
                      "commands": {},
                      "flags": {
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic",
                        "--output-file": "value"
                      }
                    },
                    "import": {
                      "commands": {},
                      "flags": {
                        "--algorithm": [
                          "ec-sign-p256-sha256",
                          "ec-sign-p384-sha384",
                          "ec-sign-secp256k1-sha256",
                          "google-symmetric-encryption",
                          "rsa-decrypt-oaep-2048-sha256",
                          "rsa-decrypt-oaep-3072-sha256",
                          "rsa-decrypt-oaep-4096-sha256",
                          "rsa-decrypt-oaep-4096-sha512",
                          "rsa-sign-pkcs1-2048-sha256",
                          "rsa-sign-pkcs1-3072-sha256",
                          "rsa-sign-pkcs1-4096-sha256",
                          "rsa-sign-pkcs1-4096-sha512",
                          "rsa-sign-pss-2048-sha256",
                          "rsa-sign-pss-3072-sha256",
                          "rsa-sign-pss-4096-sha256",
                          "rsa-sign-pss-4096-sha512"
                        ],
                        "--import-job": "dynamic",
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic",
                        "--public-key-file": "value",
                        "--rsa-aes-wrapped-key-file": "value",
                        "--target-key-file": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--limit": "value",
                        "--location": "dynamic",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "restore": {
                      "commands": {},
                      "flags": {
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--external-key-uri": "value",
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic",
                        "--state": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "locations": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "lifesciences": {
          "commands": {
            "locations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "pipelines": {
              "commands": {
                "run": {
                  "commands": {},
                  "flags": {
                    "--boot-disk-size": "value",
                    "--command-line": "value",
                    "--disk-size": "value",
                    "--docker-image": "value",
                    "--env-vars": "value",
                    "--inputs": "value",
                    "--inputs-from-file": "value",
                    "--labels": "value",
                    "--location": "dynamic",
                    "--logging": "value",
                    "--machine-type": "value",
                    "--network": "value",
                    "--outputs": "value",
                    "--pipeline-file": "value",
                    "--preemptible": "bool",
                    "--regions": "value",
                    "--service-account-email": "value",
                    "--service-account-scopes": "value",
                    "--subnetwork": "value",
                    "--zones": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "logging": {
          "commands": {
            "buckets": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--enable-analytics": "bool",
                    "--index": "value",
                    "--location": "value",
                    "--restricted-fields": "value",
                    "--retention-days": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--folder": "value",
                    "--location": "value",
                    "--organization": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--folder": "value",
                    "--location": "value",
                    "--organization": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--filter": "value",
                    "--folder": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--organization": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "undelete": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--folder": "value",
                    "--location": "value",
                    "--organization": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-index": "value",
                    "--clear-indexes": "bool",
                    "--description": "value",
                    "--enable-loglink": "bool",
                    "--location": "value",
                    "--locked": "bool",
                    "--remove-indexes": "value",
                    "--restricted-fields": "value",
                    "--retention-days": "value",
                    "--update-index": "value"
                  }
                }
              },
              "flags": {}
            },
            "copy": {
              "commands": {},
              "flags": {
                "--billing-account": "value",
                "--folder": "value",
                "--location": "value",
                "--log-filter": "value",
                "--organization": "dynamic"
              }
            },
            "locations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--folder": "value",
                    "--organization": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--filter": "value",
                    "--folder": "value",
                    "--limit": "value",
                    "--organization": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "logs": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "metrics": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--config-from-file": "value",
                    "--description": "value",
                    "--log-filter": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--config-from-file": "value",
                    "--description": "value",
                    "--log-filter": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--folder": "value",
                    "--location": "value",
                    "--organization": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--folder": "value",
                    "--location": "value",
                    "--organization": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--folder": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--operation-filter": "value",
                    "--organization": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "read": {
              "commands": {},
              "flags": {
                "--billing-account": "value",
                "--bucket": "value",
                "--folder": "value",
                "--freshness": "value",
                "--limit": "value",
                "--location": "value",
                "--order": [
                  "asc",
                  "desc"
                ],
                "--organization": "dynamic",
                "--view": "value"
              }
            },
            "resource-descriptors": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "sinks": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--description": "value",
                    "--disabled": "bool",
                    "--exclusion": "value",
                    "--folder": "value",
                    "--include-children": "bool",
                    "--log-filter": "value",
                    "--organization": "dynamic",
                    "--use-partitioned-tables": "bool"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--folder": "value",
                    "--organization": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--folder": "value",
                    "--organization": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--filter": "value",
                    "--folder": "value",
                    "--limit": "value",
                    "--organization": "dynamic",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-exclusion": "value",
                    "--billing-account": "value",
                    "--clear-exclusions": "bool",
                    "--description": "value",
                    "--disabled": "bool",
                    "--folder": "value",
                    "--log-filter": "value",
                    "--organization": "dynamic",
                    "--remove-exclusions": "value",
                    "--update-exclusion": "value",
                    "--use-partitioned-tables": "bool"
                  }
                }
              },
              "flags": {}
            },
            "tail": {
              "commands": {},
              "flags": {
                "--billing-account": "value",
                "--bucket": "value",
                "--buffer-window": "value",
                "--folder": "value",
                "--location": "value",
                "--organization": "dynamic",
                "--view": "value"
              }
            },
            "views": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--bucket": "value",
                    "--description": "value",
                    "--folder": "value",
                    "--location": "value",
                    "--log-filter": "value",
                    "--organization": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--bucket": "value",
                    "--folder": "value",
                    "--location": "value",
                    "--organization": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--bucket": "value",
                    "--folder": "value",
                    "--location": "value",
                    "--organization": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--bucket": "value",
                    "--filter": "value",
                    "--folder": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--organization": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--bucket": "value",
                    "--description": "value",
                    "--folder": "value",
                    "--location": "value",
                    "--log-filter": "value",
                    "--organization": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "write": {
              "commands": {},
              "flags": {
                "--billing-account": "value",
                "--folder": "value",
                "--organization": "dynamic",
                "--payload-type": [
                  "json",
                  "text"
                ],
                "--severity": [
                  "ALERT",
                  "CRITICAL",
                  "DEBUG",
                  "DEFAULT",
                  "EMERGENCY",
                  "ERROR",
                  "INFO",
                  "NOTICE",
                  "WARNING"
                ]
              }
            }
          },
          "flags": {}
        },
        "media": {
          "commands": {},
          "flags": {}
        },
        "memcache": {
          "commands": {
            "instances": {
              "commands": {
                "apply-parameters": {
                  "commands": {},
                  "flags": {
                    "--apply-all": "bool",
                    "--async": "bool",
                    "--node-ids": "value",
                    "--region": "dynamic"
                  }
                },
                "apply-software-update": {
                  "commands": {},
                  "flags": {
                    "--apply-all": "bool",
                    "--async": "bool",
                    "--node-ids": "value",
                    "--region": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--authorized-network": "value",
                    "--display-name": "value",
                    "--labels": "value",
                    "--memcached-version": [
                      "1.5"
                    ],
                    "--node-count": "value",
                    "--node-cpu": "value",
                    "--node-memory": "value",
                    "--parameters": "value",
                    "--region": "dynamic",
                    "--zones": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--display-name": "value",
                    "--labels": "value",
                    "--node-count": "value",
                    "--parameters": "value",
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "regions": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "metastore": {
          "commands": {
            "locations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            },
            "services": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "backups": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--member": "value",
                        "--role": "dynamic",
                        "--service": "value"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--description": "value",
                        "--location": "value",
                        "--service": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "value",
                        "--service": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--service": "value"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--service": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--service": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--member": "value",
                        "--role": "dynamic",
                        "--service": "value"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--service": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--data-catalog-sync": "bool",
                    "--encryption-kms-key": "value",
                    "--hive-metastore-configs": "value",
                    "--hive-metastore-configs-from-file": "value",
                    "--hive-metastore-version": "value",
                    "--kerberos-principal": "value",
                    "--keytab": "value",
                    "--krb5-config": "value",
                    "--labels": "value",
                    "--location": "value",
                    "--maintenance-window-day": [
                      "fri",
                      "mon",
                      "sat",
                      "sun",
                      "thu",
                      "tue",
                      "wed"
                    ],
                    "--maintenance-window-hour": "value",
                    "--network": "value",
                    "--port": "value",
                    "--release-channel": [
                      "canary",
                      "stable"
                    ],
                    "--tier": [
                      "developer",
                      "enterprise"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "export": {
                  "commands": {
                    "gcs": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--destination-folder": "value",
                        "--dump-type": [
                          "avro",
                          "mysql"
                        ],
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "import": {
                  "commands": {
                    "gcs": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--database-dump": "value",
                        "--description": "value",
                        "--dump-type": [
                          "avro",
                          "mysql"
                        ],
                        "--import-id": "value",
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "imports": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--database-dump": "value",
                        "--database-dump-type": [
                          "mysql"
                        ],
                        "--database-type": [
                          "mysql"
                        ],
                        "--description": "value",
                        "--location": "value",
                        "--service": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--service": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--service": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--description": "value",
                        "--location": "value",
                        "--service": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "restore": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--backup": "value",
                    "--location": "value",
                    "--restore-type": [
                      "full",
                      "metadata-only"
                    ]
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-hive-metastore-configs": "bool",
                    "--clear-labels": "bool",
                    "--data-catalog-sync": "bool",
                    "--kerberos-principal": "value",
                    "--keytab": "value",
                    "--krb5-config": "value",
                    "--location": "value",
                    "--maintenance-window-day": [
                      "fri",
                      "mon",
                      "sat",
                      "sun",
                      "thu",
                      "tue",
                      "wed"
                    ],
                    "--maintenance-window-hour": "value",
                    "--port": "value",
                    "--remove-hive-metastore-configs": "value",
                    "--remove-labels": "value",
                    "--tier": [
                      "developer",
                      "enterprise"
                    ],
                    "--update-hive-metastore-configs": "value",
                    "--update-hive-metastore-configs-from-file": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "ml": {
          "commands": {
            "language": {
              "commands": {
                "analyze-entities": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--content-type": [
                      "html",
                      "plain-text"
                    ],
                    "--encoding-type": [
                      "none",
                      "utf16",
                      "utf32",
                      "utf8"
                    ],
                    "--language": "value"
                  }
                },
                "analyze-entity-sentiment": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--content-type": [
                      "html",
                      "plain-text"
                    ],
                    "--encoding-type": [
                      "none",
                      "utf16",
                      "utf32",
                      "utf8"
                    ],
                    "--language": "value"
                  }
                },
                "analyze-sentiment": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--content-type": [
                      "html",
                      "plain-text"
                    ],
                    "--encoding-type": [
                      "none",
                      "utf16",
                      "utf32",
                      "utf8"
                    ],
                    "--language": "value"
                  }
                },
                "analyze-syntax": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--content-type": [
                      "html",
                      "plain-text"
                    ],
                    "--encoding-type": [
                      "none",
                      "utf16",
                      "utf32",
                      "utf8"
                    ],
                    "--language": "value"
                  }
                },
                "classify-text": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--content-type": [
                      "html",
                      "plain-text"
                    ],
                    "--language": "value"
                  }
                }
              },
              "flags": {}
            },
            "speech": {
              "commands": {
                "operations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "wait": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "recognize": {
                  "commands": {},
                  "flags": {
                    "--additional-language-codes": "value",
                    "--audio-channel-count": "value",
                    "--audio-topic": "value",
                    "--diarization-speaker-count": "value",
                    "--enable-automatic-punctuation": "bool",
                    "--enable-speaker-diarization": "bool",
                    "--encoding": [
                      "amr",
                      "amr-wb",
                      "encoding-unspecified",
                      "flac",
                      "linear16",
                      "mp3",
                      "mulaw",
                      "ogg-opus",
                      "speex-with-header-byte",
                      "webm-opus"
                    ],
                    "--filter-profanity": "bool",
                    "--hints": "value",
                    "--include-word-confidence": "bool",
                    "--include-word-time-offsets": "bool",
                    "--interaction-type": [
                      "dictation",
                      "discussion",
                      "phone-call",
                      "professionally-produced",
                      "voice-command",
                      "voice-search",
                      "voicemail"
                    ],
                    "--language-code": "value",
                    "--max-alternatives": "value",
                    "--microphone-distance": [
                      "farfield",
                      "midfield",
                      "nearfield"
                    ],
                    "--naics-code": "value",
                    "--original-media-type": [
                      "audio",
                      "video"
                    ],
                    "--original-mime-type": "value",
                    "--recording-device-name": "value",
                    "--recording-device-type": [
                      "indoor",
                      "outdoor",
                      "pc",
                      "phone-line",
                      "smartphone",
                      "vehicle"
                    ],
                    "--sample-rate": "value",
                    "--separate-channel-recognition": "bool"
                  }
                },
                "recognize-long-running": {
                  "commands": {},
                  "flags": {
                    "--additional-language-codes": "value",
                    "--async": "bool",
                    "--audio-channel-count": "value",
                    "--audio-topic": "value",
                    "--diarization-speaker-count": "value",
                    "--enable-automatic-punctuation": "bool",
                    "--enable-speaker-diarization": "bool",
                    "--encoding": [
                      "amr",
                      "amr-wb",
                      "encoding-unspecified",
                      "flac",
                      "linear16",
                      "mp3",
                      "mulaw",
                      "ogg-opus",
                      "speex-with-header-byte",
                      "webm-opus"
                    ],
                    "--filter-profanity": "bool",
                    "--hints": "value",
                    "--include-word-confidence": "bool",
                    "--include-word-time-offsets": "bool",
                    "--interaction-type": [
                      "dictation",
                      "discussion",
                      "phone-call",
                      "professionally-produced",
                      "voice-command",
                      "voice-search",
                      "voicemail"
                    ],
                    "--language-code": "value",
                    "--max-alternatives": "value",
                    "--microphone-distance": [
                      "farfield",
                      "midfield",
                      "nearfield"
                    ],
                    "--naics-code": "value",
                    "--original-media-type": [
                      "audio",
                      "video"
                    ],
                    "--original-mime-type": "value",
                    "--output-uri": "value",
                    "--recording-device-name": "value",
                    "--recording-device-type": [
                      "indoor",
                      "outdoor",
                      "pc",
                      "phone-line",
                      "smartphone",
                      "vehicle"
                    ],
                    "--sample-rate": "value",
                    "--separate-channel-recognition": "bool"
                  }
                }
              },
              "flags": {}
            },
            "translate": {
              "commands": {
                "batch-translate-text": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--glossaries": "value",
                    "--models": "value",
                    "--source": "value",
                    "--source-language": "value",
                    "--target-language-codes": "value",
                    "--zone": "value"
                  }
                },
                "detect-language": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--mime-type": "value",
                    "--model": "value",
                    "--zone": "value"
                  }
                },
                "get-supported-languages": {
                  "commands": {},
                  "flags": {
                    "--display-language-code": "value",
                    "--model": "value",
                    "--zone": "value"
                  }
                },
                "translate-text": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--glossary-config": "value",
                    "--mime-type": "value",
                    "--model": "value",
                    "--source-language": "value",
                    "--target-language": "value",
                    "--zone": "value"
                  }
                }
              },
              "flags": {}
            },
            "video": {
              "commands": {
                "detect-explicit-content": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--output-uri": "value",
                    "--region": [
                      "asia-east1",
                      "europe-west1",
                      "us-east1",
                      "us-west1"
                    ],
                    "--segments": "value"
                  }
                },
                "detect-labels": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--detection-mode": [
                      "frame",
                      "shot",
                      "shot-and-frame"
                    ],
                    "--output-uri": "value",
                    "--region": [
                      "asia-east1",
                      "europe-west1",
                      "us-east1",
                      "us-west1"
                    ],
                    "--segments": "value"
                  }
                },
                "detect-object": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--output-uri": "value",
                    "--region": [
                      "asia-east1",
                      "europe-west1",
                      "us-east1",
                      "us-west1"
                    ],
                    "--segments": "value"
                  }
                },
                "detect-shot-changes": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--output-uri": "value",
                    "--region": [
                      "asia-east1",
                      "europe-west1",
                      "us-east1",
                      "us-west1"
                    ],
                    "--segments": "value"
                  }
                },
                "detect-text": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--language-hints": "value",
                    "--output-uri": "value",
                    "--region": [
                      "asia-east1",
                      "europe-west1",
                      "us-east1",
                      "us-west1"
                    ],
                    "--segments": "value"
                  }
                },
                "operations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "wait": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "transcribe-speech": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--audio-tracks": "value",
                    "--diarization-speaker-count": "value",
                    "--enable-automatic-punctuation": "bool",
                    "--enable-speaker-diarization": "bool",
                    "--enable-word-confidence": "bool",
                    "--filter-profanity": "bool",
                    "--hints": "value",
                    "--language-code": "value",
                    "--max-alternatives": "value",
                    "--output-uri": "value",
                    "--region": [
                      "asia-east1",
                      "europe-west1",
                      "us-east1",
                      "us-west1"
                    ],
                    "--segments": "value"
                  }
                }
              },
              "flags": {}
            },
            "vision": {
              "commands": {
                "detect-document": {
                  "commands": {},
                  "flags": {
                    "--language-hints": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-faces": {
                  "commands": {},
                  "flags": {
                    "--max-results": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-image-properties": {
                  "commands": {},
                  "flags": {
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-labels": {
                  "commands": {},
                  "flags": {
                    "--max-results": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-landmarks": {
                  "commands": {},
                  "flags": {
                    "--max-results": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-logos": {
                  "commands": {},
                  "flags": {
                    "--max-results": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-objects": {
                  "commands": {},
                  "flags": {
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-product": {
                  "commands": {},
                  "flags": {
                    "--bounding-polygon": "value",
                    "--category": "value",
                    "--filter": "value",
                    "--max-results": "value",
                    "--product-set": "value",
                    "--product-set-location": "value"
                  }
                },
                "detect-safe-search": {
                  "commands": {},
                  "flags": {
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-text": {
                  "commands": {},
                  "flags": {
                    "--language-hints": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-text-pdf": {
                  "commands": {},
                  "flags": {
                    "--batch-size": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-text-tiff": {
                  "commands": {},
                  "flags": {
                    "--batch-size": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-web": {
                  "commands": {},
                  "flags": {
                    "--include-geo-results": "bool",
                    "--max-results": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "operations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "product-search": {
                  "commands": {
                    "images": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--bounding-polygon": "value",
                            "--location": "value",
                            "--product": "value",
                            "--storage-location": "value"
                          }
                        },
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--location": "value",
                            "--product": "value"
                          }
                        },
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--location": "value",
                            "--product": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--location": "value",
                            "--page-size": "value",
                            "--product": "value",
                            "--sort-by": "value",
                            "--uri": "bool"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "product-sets": {
                      "commands": {
                        "add-product": {
                          "commands": {},
                          "flags": {
                            "--location": "value",
                            "--product": "value"
                          }
                        },
                        "create": {
                          "commands": {},
                          "flags": {
                            "--display-name": "value",
                            "--location": "value"
                          }
                        },
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--location": "value"
                          }
                        },
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--location": "value"
                          }
                        },
                        "import": {
                          "commands": {},
                          "flags": {
                            "--async": "bool",
                            "--location": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--location": "value",
                            "--page-size": "value",
                            "--sort-by": "value",
                            "--uri": "bool"
                          }
                        },
                        "list-products": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--location": "value",
                            "--page-size": "value",
                            "--product-set": "value",
                            "--sort-by": "value"
                          }
                        },
                        "remove-product": {
                          "commands": {},
                          "flags": {
                            "--location": "value",
                            "--product": "value"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--display-name": "value",
                            "--location": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "products": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--category": [
                              "apparel",
                              "homegoods",
                              "toys"
                            ],
                            "--description": "value",
                            "--display-name": "value",
                            "--location": "value",
                            "--product-labels": "value"
                          }
                        },
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--location": "value"
                          }
                        },
                        "delete-all": {
                          "commands": {},
                          "flags": {
                            "--force": "bool",
                            "--orphan-products": "bool",
                            "--product-set": "value"
                          }
                        },
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--location": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--location": "value",
                            "--page-size": "value",
                            "--sort-by": "value",
                            "--uri": "bool"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--add-product-labels": "value",
                            "--clear-product-labels": "bool",
                            "--description": "value",
                            "--display-name": "value",
                            "--location": "value",
                            "--remove-product-labels": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "suggest-crop": {
                  "commands": {},
                  "flags": {
                    "--aspect-ratios": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "ml-engine": {
          "commands": {
            "explain": {
              "commands": {},
              "flags": {
                "--json-instances": "value",
                "--json-request": "value",
                "--model": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--text-instances": "value"
              }
            },
            "jobs": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--summarize": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "stream-logs": {
                  "commands": {},
                  "flags": {
                    "--allow-multiline-logs": "bool",
                    "--polling-interval": "value",
                    "--task-name": "value"
                  }
                },
                "submit": {
                  "commands": {
                    "prediction": {
                      "commands": {},
                      "flags": {
                        "--accelerator-count": "value",
                        "--accelerator-type": [
                          "nvidia-tesla-k80",
                          "nvidia-tesla-p100"
                        ],
                        "--batch-size": "value",
                        "--data-format": [
                          "text",
                          "tf-record",
                          "tf-record-gzip"
                        ],
                        "--input-paths": "value",
                        "--labels": "value",
                        "--max-worker-count": "value",
                        "--model": "value",
                        "--model-dir": "value",
                        "--output-path": "value",
                        "--region": "value",
                        "--runtime-version": "value",
                        "--signature-name": "value"
                      }
                    },
                    "training": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--config": "value",
                        "--job-dir": "value",
                        "--kms-key": "dynamic",
                        "--kms-keyring": "dynamic",
                        "--kms-location": "dynamic",
                        "--kms-project": "dynamic",
                        "--labels": "value",
                        "--master-accelerator": "value",
                        "--master-image-uri": "value",
                        "--master-machine-type": "value",
                        "--module-name": "value",
                        "--network": "value",
                        "--package-path": "value",
                        "--packages": "value",
                        "--parameter-server-accelerator": "value",
                        "--parameter-server-count": "value",
                        "--parameter-server-image-uri": "value",
                        "--parameter-server-machine-type": "value",
                        "--python-version": "value",
                        "--region": "dynamic",
                        "--runtime-version": "value",
                        "--scale-tier": [
                          "basic",
                          "basic-gpu",
                          "basic-tpu",
                          "custom",
                          "premium-1",
                          "standard-1"
                        ],
                        "--service-account": "value",
                        "--staging-bucket": "value",
                        "--stream-logs": "bool",
                        "--tpu-tf-version": "value",
                        "--use-chief-in-tf-config": "value",
                        "--worker-accelerator": "value",
                        "--worker-count": "value",
                        "--worker-image-uri": "value",
                        "--worker-machine-type": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "local": {
              "commands": {
                "predict": {
                  "commands": {},
                  "flags": {
                    "--framework": [
                      "scikit-learn",
                      "tensorflow",
                      "xgboost"
                    ],
                    "--json-instances": "value",
                    "--json-request": "value",
                    "--model-dir": "value",
                    "--signature-name": "value",
                    "--text-instances": "value"
                  }
                },
                "train": {
                  "commands": {},
                  "flags": {
                    "--distributed": "bool",
                    "--evaluator-count": "value",
                    "--job-dir": "value",
                    "--module-name": "value",
                    "--package-path": "value",
                    "--parameter-server-count": "value",
                    "--start-port": "value",
                    "--worker-count": "value"
                  }
                }
              },
              "flags": {}
            },
            "locations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "models": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--enable-console-logging": "bool",
                    "--enable-logging": "bool",
                    "--labels": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--regions": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--role": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "predict": {
              "commands": {},
              "flags": {
                "--json-instances": "value",
                "--json-request": "value",
                "--model": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--signature-name": "value",
                "--text-instances": "value"
              }
            },
            "versions": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--args": "value",
                    "--async": "bool",
                    "--command": "value",
                    "--config": "value",
                    "--description": "value",
                    "--env-vars": "value",
                    "--explanation-method": [
                      "integrated-gradients",
                      "sampled-shapley",
                      "xrai"
                    ],
                    "--framework": [
                      "scikit-learn",
                      "tensorflow",
                      "xgboost"
                    ],
                    "--health-route": "value",
                    "--image": "value",
                    "--labels": "value",
                    "--machine-type": "value",
                    "--max-nodes": "value",
                    "--metric-targets": "value",
                    "--min-nodes": "value",
                    "--model": "value",
                    "--num-integral-steps": "value",
                    "--num-paths": "value",
                    "--origin": "value",
                    "--package-uris": "value",
                    "--ports": "value",
                    "--predict-route": "value",
                    "--prediction-class": "value",
                    "--python-version": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--runtime-version": "value",
                    "--service-account": "value",
                    "--staging-bucket": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--model": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--model": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--model": "value",
                    "--page-size": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-default": {
                  "commands": {},
                  "flags": {
                    "--model": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--bigquery-table-name": "value",
                    "--clear-labels": "bool",
                    "--config": "value",
                    "--description": "value",
                    "--model": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--remove-labels": "value",
                    "--sampling-percentage": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "monitoring": {
          "commands": {
            "channel-descriptors": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "channels": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--channel-content": "value",
                    "--channel-content-from-file": "value",
                    "--channel-labels": "value",
                    "--description": "value",
                    "--display-name": "value",
                    "--enabled": "bool",
                    "--type": "value",
                    "--user-labels": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--force": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--type": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--channel-content": "value",
                    "--channel-content-from-file": "value",
                    "--clear-channel-labels": "bool",
                    "--clear-user-labels": "bool",
                    "--description": "value",
                    "--display-name": "value",
                    "--enabled": "bool",
                    "--fields": "value",
                    "--remove-channel-labels": "value",
                    "--remove-user-labels": "value",
                    "--type": "value",
                    "--update-channel-labels": "value",
                    "--update-user-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "dashboards": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--config": "value",
                    "--config-from-file": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--config": "value",
                    "--config-from-file": "value"
                  }
                }
              },
              "flags": {}
            },
            "policies": {
              "commands": {
                "conditions": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--aggregation": "value",
                        "--condition": "value",
                        "--condition-display-name": "value",
                        "--condition-filter": "value",
                        "--condition-from-file": "value",
                        "--duration": "value",
                        "--if": "value",
                        "--trigger-count": "value",
                        "--trigger-percent": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--policy": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--policy": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--display-name": "value",
                        "--if": "value",
                        "--policy": "value",
                        "--trigger-count": "value",
                        "--trigger-percent": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--aggregation": "value",
                    "--combiner": [
                      "AND",
                      "AND_WITH_MATCHING_RESOURCE",
                      "COMBINE_UNSPECIFIED",
                      "OR"
                    ],
                    "--condition-display-name": "value",
                    "--condition-filter": "value",
                    "--display-name": "value",
                    "--documentation": "value",
                    "--documentation-format": "value",
                    "--documentation-from-file": "value",
                    "--duration": "value",
                    "--enabled": "bool",
                    "--if": "value",
                    "--notification-channels": "value",
                    "--policy": "value",
                    "--policy-from-file": "value",
                    "--trigger-count": "value",
                    "--trigger-percent": "value",
                    "--user-labels": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-notification-channels": "value",
                    "--clear-notification-channels": "bool",
                    "--clear-user-labels": "bool",
                    "--combiner": [
                      "AND",
                      "AND_WITH_MATCHING_RESOURCE",
                      "COMBINE_UNSPECIFIED",
                      "OR"
                    ],
                    "--display-name": "value",
                    "--documentation": "value",
                    "--documentation-format": "value",
                    "--documentation-from-file": "value",
                    "--enabled": "bool",
                    "--fields": "value",
                    "--policy": "value",
                    "--policy-from-file": "value",
                    "--remove-notification-channels": "value",
                    "--remove-user-labels": "value",
                    "--set-notification-channels": "value",
                    "--update-user-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "network-connectivity": {
          "commands": {
            "hubs": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--labels": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "spokes": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--hub": "value",
                    "--interconnect-attachment": "value",
                    "--labels": "value",
                    "--region": "value",
                    "--router-appliance": "value",
                    "--vpn-tunnel": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--labels": "value",
                    "--region": "value",
                    "--router-appliance": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "network-security": {
          "commands": {
            "authorization-policies": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--location": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "client-tls-policies": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--location": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "server-tls-policies": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--location": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "network-services": {
          "commands": {
            "endpoint-config-selectors": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--location": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "endpoint-policies": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--location": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "grpc-routes": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--location": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "http-filters": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--location": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "http-routes": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--location": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags