"""Generated message classes for monitoring version v1.

Manages your Cloud Monitoring data and configurations. Most projects must be
associated with a Workspace, with a few exceptions as noted on the individual
method pages. The table entries below are presented in alphabetical order, not
in order of common use. For explanations of the concepts found in the table
entries, read the Cloud Monitoring documentation
(https://cloud.google.com/monitoring/docs).
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'monitoring'


class Aggregation(_messages.Message):
  r"""Describes how to combine multiple time series to provide a different
  view of the data. Aggregation of time series is done in two steps. First,
  each time series in the set is aligned to the same time interval boundaries,
  then the set of time series is optionally reduced in number.Alignment
  consists of applying the per_series_aligner operation to each time series
  after its data has been divided into regular alignment_period time
  intervals. This process takes all of the data points in an alignment period,
  applies a mathematical transformation such as averaging, minimum, maximum,
  delta, etc., and converts them into a single data point per period.Reduction
  is when the aligned and transformed time series can optionally be combined,
  reducing the number of time series through similar mathematical
  transformations. Reduction involves applying a cross_series_reducer to all
  the time series, optionally sorting the time series into subsets with
  group_by_fields, and applying the reducer to each subset.The raw time series
  data can contain a huge amount of information from multiple sources.
  Alignment and reduction transforms this mass of data into a more manageable
  and representative collection of data, for example "the 95% latency across
  the average of all tasks in a cluster". This representative data can be more
  easily graphed and comprehended, and the individual time series data is
  still available for later drilldown. For more details, see Filtering and
  aggregation (https://cloud.google.com/monitoring/api/v3/aggregation).

  Enums:
    CrossSeriesReducerValueValuesEnum: The reduction operation to be used to
      combine time series into a single time series, where the value of each
      data point in the resulting series is a function of all the already
      aligned values in the input time series.Not all reducer operations can
      be applied to all time series. The valid choices depend on the
      metric_kind and the value_type of the original time series. Reduction
      can yield a time series with a different metric_kind or value_type than
      the input time series.Time series data must first be aligned (see
      per_series_aligner) in order to perform cross-time series reduction. If
      cross_series_reducer is specified, then per_series_aligner must be
      specified, and must not be ALIGN_NONE. An alignment_period must also be
      specified; otherwise, an error is returned.
    PerSeriesAlignerValueValuesEnum: An Aligner describes how to bring the
      data points in a single time series into temporal alignment. Except for
      ALIGN_NONE, all alignments cause all the data points in an
      alignment_period to be mathematically grouped together, resulting in a
      single data point for each alignment_period with end timestamp at the
      end of the period.Not all alignment operations may be applied to all
      time series. The valid choices depend on the metric_kind and value_type
      of the original time series. Alignment can change the metric_kind or the
      value_type of the time series.Time series data must be aligned in order
      to perform cross-time series reduction. If cross_series_reducer is
      specified, then per_series_aligner must be specified and not equal to
      ALIGN_NONE and alignment_period must be specified; otherwise, an error
      is returned.

  Fields:
    alignmentPeriod: The alignment_period specifies a time interval, in
      seconds, that is used to divide the data in all the time series into
      consistent blocks of time. This will be done before the per-series
      aligner can be applied to the data.The value must be at least 60
      seconds. If a per-series aligner other than ALIGN_NONE is specified,
      this field is required or an error is returned. If no per-series aligner
      is specified, or the aligner ALIGN_NONE is specified, then this field is
      ignored.The maximum value of the alignment_period is 2 years, or 104
      weeks.
    crossSeriesReducer: The reduction operation to be used to combine time
      series into a single time series, where the value of each data point in
      the resulting series is a function of all the already aligned values in
      the input time series.Not all reducer operations can be applied to all
      time series. The valid choices depend on the metric_kind and the
      value_type of the original time series. Reduction can yield a time
      series with a different metric_kind or value_type than the input time
      series.Time series data must first be aligned (see per_series_aligner)
      in order to perform cross-time series reduction. If cross_series_reducer
      is specified, then per_series_aligner must be specified, and must not be
      ALIGN_NONE. An alignment_period must also be specified; otherwise, an
      error is returned.
    groupByFields: The set of fields to preserve when cross_series_reducer is
      specified. The group_by_fields determine how the time series are
      partitioned into subsets prior to applying the aggregation operation.
      Each subset contains time series that have the same value for each of
      the grouping fields. Each individual time series is a member of exactly
      one subset. The cross_series_reducer is applied to each subset of time
      series. It is not possible to reduce across different resource types, so
      this field implicitly contains resource.type. Fields not specified in
      group_by_fields are aggregated away. If group_by_fields is not specified
      and all the time series have the same resource type, then the time
      series are aggregated into a single output time series. If
      cross_series_reducer is not defined, this field is ignored.
    perSeriesAligner: An Aligner describes how to bring the data points in a
      single time series into temporal alignment. Except for ALIGN_NONE, all
      alignments cause all the data points in an alignment_period to be
      mathematically grouped together, resulting in a single data point for
      each alignment_period with end timestamp at the end of the period.Not
      all alignment operations may be applied to all time series. The valid
      choices depend on the metric_kind and value_type of the original time
      series. Alignment can change the metric_kind or the value_type of the
      time series.Time series data must be aligned in order to perform cross-
      time series reduction. If cross_series_reducer is specified, then
      per_series_aligner must be specified and not equal to ALIGN_NONE and
      alignment_period must be specified; otherwise, an error is returned.
  """

  class CrossSeriesReducerValueValuesEnum(_messages.Enum):
    r"""The reduction operation to be used to combine time series into a
    single time series, where the value of each data point in the resulting
    series is a function of all the already aligned values in the input time
    series.Not all reducer operations can be applied to all time series. The
    valid choices depend on the metric_kind and the value_type of the original
    time series. Reduction can yield a time series with a different
    metric_kind or value_type than the input time series.Time series data must
    first be aligned (see per_series_aligner) in order to perform cross-time
    series reduction. If cross_series_reducer is specified, then
    per_series_aligner must be specified, and must not be ALIGN_NONE. An
    alignment_period must also be specified; otherwise, an error is returned.

    Values:
      REDUCE_NONE: No cross-time series reduction. The output of the Aligner
        is returned.
      REDUCE_MEAN: Reduce by computing the mean value across time series for
        each alignment period. This reducer is valid for DELTA and GAUGE
        metrics with numeric or distribution values. The value_type of the
        output is DOUBLE.
      REDUCE_MIN: Reduce by computing the minimum value across time series for
        each alignment period. This reducer is valid for DELTA and GAUGE
        metrics with numeric values. The value_type of the output is the same
        as the value_type of the input.
      REDUCE_MAX: Reduce by computing the maximum value across time series for
        each alignment period. This reducer is valid for DELTA and GAUGE
        metrics with numeric values. The value_type of the output is the same
        as the value_type of the input.
      REDUCE_SUM: Reduce by computing the sum across time series for each
        alignment period. This reducer is valid for DELTA and GAUGE metrics
        with numeric and distribution values. The value_type of the output is
        the same as the value_type of the input.
      REDUCE_STDDEV: Reduce by computing the standard deviation across time
        series for each alignment period. This reducer is valid for DELTA and
        GAUGE metrics with numeric or distribution values. The value_type of
        the output is DOUBLE.
      REDUCE_COUNT: Reduce by computing the number of data points across time
        series for each alignment period. This reducer is valid for DELTA and
        GAUGE metrics of numeric, Boolean, distribution, and string
        value_type. The value_type of the output is INT64.
      REDUCE_COUNT_TRUE: Reduce by computing the number of True-valued data
        points across time series for each alignment period. This reducer is
        valid for DELTA and GAUGE metrics of Boolean value_type. The
        value_type of the output is INT64.
      REDUCE_COUNT_FALSE: Reduce by computing the number of False-valued data
        points across time series for each alignment period. This reducer is
        valid for DELTA and GAUGE metrics of Boolean value_type. The
        value_type of the output is INT64.
      REDUCE_FRACTION_TRUE: Reduce by computing the ratio of the number of
        True-valued data points to the total number of data points for each
        alignment period. This reducer is valid for DELTA and GAUGE metrics of
        Boolean value_type. The output value is in the range 0.0, 1.0 and has
        value_type DOUBLE.
      REDUCE_PERCENTILE_99: Reduce by computing the 99th percentile
        (https://en.wikipedia.org/wiki/Percentile) of data points across time
        series for each alignment period. This reducer is valid for GAUGE and
        DELTA metrics of numeric and distribution type. The value of the
        output is DOUBLE.
      REDUCE_PERCENTILE_95: Reduce by computing the 95th percentile
        (https://en.wikipedia.org/wiki/Percentile) of data points across time
        series for each alignment period. This reducer is valid for GAUGE and
        DELTA metrics of numeric and distribution type. The value of the
        output is DOUBLE.
      REDUCE_PERCENTILE_50: Reduce by computing the 50th percentile
        (https://en.wikipedia.org/wiki/Percentile) of data points across time
        series for each alignment period. This reducer is valid for GAUGE and
        DELTA metrics of numeric and distribution type. The value of the
        output is DOUBLE.
      REDUCE_PERCENTILE_05: Reduce by computing the 5th percentile
        (https://en.wikipedia.org/wiki/Percentile) of data points across time
        series for each alignment period. This reducer is valid for GAUGE and
        DELTA metrics of numeric and distribution type. The value of the
        output is DOUBLE.
    """
    REDUCE_NONE = 0
    REDUCE_MEAN = 1
    REDUCE_MIN = 2
    REDUCE_MAX = 3
    REDUCE_SUM = 4
    REDUCE_STDDEV = 5
    REDUCE_COUNT = 6
    REDUCE_COUNT_TRUE = 7
    REDUCE_COUNT_FALSE = 8
    REDUCE_FRACTION_TRUE = 9
    REDUCE_PERCENTILE_99 = 10
    REDUCE_PERCENTILE_95 = 11
    REDUCE_PERCENTILE_50 = 12
    REDUCE_PERCENTILE_05 = 13

  class PerSeriesAlignerValueValuesEnum(_messages.Enum):
    r"""An Aligner describes how to bring the data points in a single time
    series into temporal alignment. Except for ALIGN_NONE, all alignments
    cause all the data points in an alignment_period to be mathematically
    grouped together, resulting in a single data point for each
    alignment_period with end timestamp at the end of the period.Not all
    alignment operations may be applied to all time series. The valid choices
    depend on the metric_kind and value_type of the original time series.
    Alignment can change the metric_kind or the value_type of the time
    series.Time series data must be aligned in order to perform cross-time
    series reduction. If cross_series_reducer is specified, then
    per_series_aligner must be specified and not equal to ALIGN_NONE and
    alignment_period must be specified; otherwise, an error is returned.

    Values:
      ALIGN_NONE: No alignment. Raw data is returned. Not valid if cross-
        series reduction is requested. The value_type of the result is the
        same as the value_type of the input.
      ALIGN_DELTA: Align and convert to DELTA. The output is delta = y1 -
        y0.This alignment is valid for CUMULATIVE and DELTA metrics. If the
        selected alignment period results in periods with no data, then the
        aligned value for such a period is created by interpolation. The
        value_type of the aligned result is the same as the value_type of the
        input.
      ALIGN_RATE: Align and convert to a rate. The result is computed as rate
        = (y1 - y0)/(t1 - t0), or "delta over time". Think of this aligner as
        providing the slope of the line that passes through the value at the
        start and at the end of the alignment_period.This aligner is valid for
        CUMULATIVE and DELTA metrics with numeric values. If the selected
        alignment period results in periods with no data, then the aligned
        value for such a period is created by interpolation. The output is a
        GAUGE metric with value_type DOUBLE.If, by "rate", you mean
        "percentage change", see the ALIGN_PERCENT_CHANGE aligner instead.
      ALIGN_INTERPOLATE: Align by interpolating between adjacent points around
        the alignment period boundary. This aligner is valid for GAUGE metrics
        with numeric values. The value_type of the aligned result is the same
        as the value_type of the input.
      ALIGN_NEXT_OLDER: Align by moving the most recent data point before the
        end of the alignment period to the boundary at the end of the
        alignment period. This aligner is valid for GAUGE metrics. The
        value_type of the aligned result is the same as the value_type of the
        input.
      ALIGN_MIN: Align the time series by returning the minimum value in each
        alignment period. This aligner is valid for GAUGE and DELTA metrics
        with numeric values. The value_type of the aligned result is the same
        as the value_type of the input.
      ALIGN_MAX: Align the time series by returning the maximum value in each
        alignment period. This aligner is valid for GAUGE and DELTA metrics
        with numeric values. The value_type of the aligned result is the same
        as the value_type of the input.
      ALIGN_MEAN: Align the time series by returning the mean value in each
        alignment period. This aligner is valid for GAUGE and DELTA metrics
        with numeric values. The value_type of the aligned result is DOUBLE.
      ALIGN_COUNT: Align the time series by returning the number of values in
        each alignment period. This aligner is valid for GAUGE and DELTA
        metrics with numeric or Boolean values. The value_type of the aligned
        result is INT64.
      ALIGN_SUM: Align the time series by returning the sum of the values in
        each alignment period. This aligner is valid for GAUGE and DELTA
        metrics with numeric and distribution values. The value_type of the
        aligned result is the same as the value_type of the input.
      ALIGN_STDDEV: Align the time series by returning the standard deviation
        of the values in each alignment period. This aligner is valid for
        GAUGE and DELTA metrics with numeric values. The value_type of the
        output is DOUBLE.
      ALIGN_COUNT_TRUE: Align the time series by returning the number of True
        values in each alignment period. This aligner is valid for GAUGE
        metrics with Boolean values. The value_type of the output is INT64.
      ALIGN_COUNT_FALSE: Align the time series by returning the number of
        False values in each alignment period. This aligner is valid for GAUGE
        metrics with Boolean values. The value_type of the output is INT64.
      ALIGN_FRACTION_TRUE: Align the time series by returning the ratio of the
        number of True values to the total number of values in each alignment
        period. This aligner is valid for GAUGE metrics with Boolean values.
        The output value is in the range 0.0, 1.0 and has value_type DOUBLE.
      ALIGN_PERCENTILE_99: Align the time series by using percentile
        aggregation (https://en.wikipedia.org/wiki/Percentile). The resulting
        data point in each alignment period is the 99th percentile of all data
        points in the period. This aligner is valid for GAUGE and DELTA
        metrics with distribution values. The output is a GAUGE metric with
        value_type DOUBLE.
      ALIGN_PERCENTILE_95: Align the time series by using percentile
        aggregation (https://en.wikipedia.org/wiki/Percentile). The resulting
        data point in each alignment period is the 95th percentile of all data
        points in the period. This aligner is valid for GAUGE and DELTA
        metrics with distribution values. The output is a GAUGE metric with
        value_type DOUBLE.
      ALIGN_PERCENTILE_50: Align the time series by using percentile
        aggregation (https://en.wikipedia.org/wiki/Percentile). The resulting
        data point in each alignment period is the 50th percentile of all data
        points in the period. This aligner is valid for GAUGE and DELTA
        metrics with distribution values. The output is a GAUGE metric with
        value_type DOUBLE.
      ALIGN_PERCENTILE_05: Align the time series by using percentile
        aggregation (https://en.wikipedia.org/wiki/Percentile). The resulting
        data point in each alignment period is the 5th percentile of all data
        points in the period. This aligner is valid for GAUGE and DELTA
        metrics with distribution values. The output is a GAUGE metric with
        value_type DOUBLE.
      ALIGN_PERCENT_CHANGE: Align and convert to a percentage change. This
        aligner is valid for GAUGE and DELTA metrics with numeric values. This
        alignment returns ((current - previous)/previous) * 100, where the
        value of previous is determined based on the alignment_period.If the
        values of current and previous are both 0, then the returned value is
        0. If only previous is 0, the returned value is infinity.A 10-minute
        moving mean is computed at each point of the alignment period prior to
        the above calculation to smooth the metric and prevent false positives
        from very short-lived spikes. The moving mean is only applicable for
        data whose values are >= 0. Any values < 0 are treated as a missing
        datapoint, and are ignored. While DELTA metrics are accepted by this
        alignment, special care should be taken that the values for the metric
        will always be positive. The output is a GAUGE metric with value_type
        DOUBLE.
    """
    ALIGN_NONE = 0
    ALIGN_DELTA = 1
    ALIGN_RATE = 2
    ALIGN_INTERPOLATE = 3
    ALIGN_NEXT_OLDER = 4
    ALIGN_MIN = 5
    ALIGN_MAX = 6
    ALIGN_MEAN = 7
    ALIGN_COUNT = 8
    ALIGN_SUM = 9
    ALIGN_STDDEV = 10
    ALIGN_COUNT_TRUE = 11
    ALIGN_COUNT_FALSE = 12
    ALIGN_FRACTION_TRUE = 13
    ALIGN_PERCENTILE_99 = 14
    ALIGN_PERCENTILE_95 = 15
    ALIGN_PERCENTILE_50 = 16
    ALIGN_PERCENTILE_05 = 17
    ALIGN_PERCENT_CHANGE = 18

  alignmentPeriod = _messages.StringField(1)
  crossSeriesReducer = _messages.EnumField('CrossSeriesReducerValueValuesEnum', 2)
  groupByFields = _messages.StringField(3, repeated=True)
  perSeriesAligner = _messages.EnumField('PerSeriesAlignerValueValuesEnum', 4)


class AlertChart(_messages.Message):
  r"""A chart that displays alert policy data.

  Fields:
    name: Required. The resource name of the alert policy. The format is:
      projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID]
  """

  name = _messages.StringField(1)


class Axis(_messages.Message):
  r"""A chart axis.

  Enums:
    ScaleValueValuesEnum: The axis scale. By default, a linear scale is used.

  Fields:
    label: The label of the axis.
    scale: The axis scale. By default, a linear scale is used.
  """

  class ScaleValueValuesEnum(_messages.Enum):
    r"""The axis scale. By default, a linear scale is used.

    Values:
      SCALE_UNSPECIFIED: Scale is unspecified. The view will default to
        LINEAR.
      LINEAR: Linear scale.
      LOG10: Logarithmic scale (base 10).
    """
    SCALE_UNSPECIFIED = 0
    LINEAR = 1
    LOG10 = 2

  label = _messages.StringField(1)
  scale = _messages.EnumField('ScaleValueValuesEnum', 2)


class ChartOptions(_messages.Message):
  r"""Options to control visual rendering of a chart.

  Enums:
    ModeValueValuesEnum: The chart mode.

  Fields:
    mode: The chart mode.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""The chart mode.

    Values:
      MODE_UNSPECIFIED: Mode is unspecified. The view will default to COLOR.
      COLOR: The chart distinguishes data series using different color. Line
        colors may get reused when there are many lines in the chart.
      X_RAY: The chart uses the Stackdriver x-ray mode, in which each data set
        is plotted using the same semi-transparent color.
      STATS: The chart displays statistics such as average, median, 95th
        percentile, and more.
    """
    MODE_UNSPECIFIED = 0
    COLOR = 1
    X_RAY = 2
    STATS = 3

  mode = _messages.EnumField('ModeValueValuesEnum', 1)


class Column(_messages.Message):
  r"""Defines the layout properties and content for a column.

  Fields:
    weight: The relative weight of this column. The column weight is used to
      adjust the width of columns on the screen (relative to peers). Greater
      the weight, greater the width of the column on the screen. If omitted, a
      value of 1 is used while rendering.
    widgets: The display widgets arranged vertically in this column.
  """

  weight = _messages.IntegerField(1)
  widgets = _messages.MessageField('Widget', 2, repeated=True)


class ColumnLayout(_messages.Message):
  r"""A simplified layout that divides the available space into vertical
  columns and arranges a set of widgets vertically in each column.

  Fields:
    columns: The columns of content to display.
  """

  columns = _messages.MessageField('Column', 1, repeated=True)


class Dashboard(_messages.Message):
  r"""A Google Stackdriver dashboard. Dashboards define the content and layout
  of pages in the Stackdriver web application.

  Fields:
    columnLayout: The content is divided into equally spaced columns and the
      widgets are arranged vertically.
    displayName: Required. The mutable, human-readable name.
    etag: etag is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. An
      etag is returned in the response to GetDashboard, and users are expected
      to put that etag in the request to UpdateDashboard to ensure that their
      change will be applied to the same version of the Dashboard
      configuration. The field should not be passed during dashboard creation.
    gridLayout: Content is arranged with a basic layout that re-flows a simple
      list of informational elements like widgets or tiles.
    mosaicLayout: The content is arranged as a grid of tiles, with each
      content widget occupying one or more grid blocks.
    name: Immutable. The resource name of the dashboard.
    rowLayout: The content is divided into equally spaced rows and the widgets
      are arranged horizontally.
  """

  columnLayout = _messages.MessageField('ColumnLayout', 1)
  displayName = _messages.StringField(2)
  etag = _messages.StringField(3)
  gridLayout = _messages.MessageField('GridLayout', 4)
  mosaicLayout = _messages.MessageField('MosaicLayout', 5)
  name = _messages.StringField(6)
  rowLayout = _messages.MessageField('RowLayout', 7)


class DataSet(_messages.Message):
  r"""Groups a time series query definition with charting options.

  Enums:
    PlotTypeValueValuesEnum: How this data should be plotted on the chart.

  Fields:
    legendTemplate: A template string for naming TimeSeries in the resulting
      data set. This should be a string with interpolations of the form
      ${label_name}, which will resolve to the label's value.
    minAlignmentPeriod: Optional. The lower bound on data point frequency for
      this data set, implemented by specifying the minimum alignment period to
      use in a time series query For example, if the data is published once
      every 10 minutes, the min_alignment_period should be at least 10
      minutes. It would not make sense to fetch and align data at one minute
      intervals.
    plotType: How this data should be plotted on the chart.
    timeSeriesQuery: Required. Fields for querying time series data from the
      Stackdriver metrics API.
  """

  class PlotTypeValueValuesEnum(_messages.Enum):
    r"""How this data should be plotted on the chart.

    Values:
      PLOT_TYPE_UNSPECIFIED: Plot type is unspecified. The view will default
        to LINE.
      LINE: The data is plotted as a set of lines (one line per series).
      STACKED_AREA: The data is plotted as a set of filled areas (one area per
        series), with the areas stacked vertically (the base of each area is
        the top of its predecessor, and the base of the first area is the X
        axis). Since the areas do not overlap, each is filled with a different
        opaque color.
      STACKED_BAR: The data is plotted as a set of rectangular boxes (one box
        per series), with the boxes stacked vertically (the base of each box
        is the top of its predecessor, and the base of the first box is the X
        axis). Since the boxes do not overlap, each is filled with a different
        opaque color.
      HEATMAP: The data is plotted as a heatmap. The series being plotted must
        have a DISTRIBUTION value type. The value of each bucket in the
        distribution is displayed as a color. This type is not currently
        available in the Stackdriver Monitoring application.
    """
    PLOT_TYPE_UNSPECIFIED = 0
    LINE = 1
    STACKED_AREA = 2
    STACKED_BAR = 3
    HEATMAP = 4

  legendTemplate = _messages.StringField(1)
  minAlignmentPeriod = _messages.StringField(2)
  plotType = _messages.EnumField('PlotTypeValueValuesEnum', 3)
  timeSeriesQuery = _messages.MessageField('TimeSeriesQuery', 4)


class DroppedLabels(_messages.Message):
  r"""A set of (label, value) pairs that were removed from a Distribution time
  series during aggregation and then added as an attachment to a
  Distribution.Exemplar.The full label set for the exemplars is constructed by
  using the dropped pairs in combination with the label values that remain on
  the aggregated Distribution time series. The constructed full label set can
  be used to identify the specific entity, such as the instance or job, which
  might be contributing to a long-tail. However, with dropped labels, the
  storage requirements are reduced because only the aggregated distribution
  values for a large group of time series are stored.Note that there are no
  guarantees on ordering of the labels from exemplar-to-exemplar and from
  distribution-to-distribution in the same stream, and there may be
  duplicates. It is up to clients to resolve any ambiguities.

  Messages:
    LabelValue: Map from label to its value, for all labels dropped in any
      aggregation.

  Fields:
    label: Map from label to its value, for all labels dropped in any
      aggregation.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelValue(_messages.Message):
    r"""Map from label to its value, for all labels dropped in any
    aggregation.

    Messages:
      AdditionalProperty: An additional property for a LabelValue object.

    Fields:
      additionalProperties: Additional properties of type LabelValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  label = _messages.MessageField('LabelValue', 1)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for Empty is empty JSON object {}.
  """



class Field(_messages.Message):
  r"""A single field of a message type.

  Enums:
    CardinalityValueValuesEnum: The field cardinality.
    KindValueValuesEnum: The field type.

  Fields:
    cardinality: The field cardinality.
    defaultValue: The string value of the default value of this field. Proto2
      syntax only.
    jsonName: The field JSON name.
    kind: The field type.
    name: The field name.
    number: The field number.
    oneofIndex: The index of the field type in Type.oneofs, for message or
      enumeration types. The first type has index 1; zero means the type is
      not in the list.
    options: The protocol buffer options.
    packed: Whether to use alternative packed wire representation.
    typeUrl: The field type URL, without the scheme, for message or
      enumeration types. Example:
      "type.googleapis.com/google.protobuf.Timestamp".
  """

  class CardinalityValueValuesEnum(_messages.Enum):
    r"""The field cardinality.

    Values:
      CARDINALITY_UNKNOWN: For fields with unknown cardinality.
      CARDINALITY_OPTIONAL: For optional fields.
      CARDINALITY_REQUIRED: For required fields. Proto2 syntax only.
      CARDINALITY_REPEATED: For repeated fields.
    """
    CARDINALITY_UNKNOWN = 0
    CARDINALITY_OPTIONAL = 1
    CARDINALITY_REQUIRED = 2
    CARDINALITY_REPEATED = 3

  class KindValueValuesEnum(_messages.Enum):
    r"""The field type.

    Values:
      TYPE_UNKNOWN: Field type unknown.
      TYPE_DOUBLE: Field type double.
      TYPE_FLOAT: Field type float.
      TYPE_INT64: Field type int64.
      TYPE_UINT64: Field type uint64.
      TYPE_INT32: Field type int32.
      TYPE_FIXED64: Field type fixed64.
      TYPE_FIXED32: Field type fixed32.
      TYPE_BOOL: Field type bool.
      TYPE_STRING: Field type string.
      TYPE_GROUP: Field type group. Proto2 syntax only, and deprecated.
      TYPE_MESSAGE: Field type message.
      TYPE_BYTES: Field type bytes.
      TYPE_UINT32: Field type uint32.
      TYPE_ENUM: Field type enum.
      TYPE_SFIXED32: Field type sfixed32.
      TYPE_SFIXED64: Field type sfixed64.
      TYPE_SINT32: Field type sint32.
      TYPE_SINT64: Field type sint64.
    """
    TYPE_UNKNOWN = 0
    TYPE_DOUBLE = 1
    TYPE_FLOAT = 2
    TYPE_INT64 = 3
    TYPE_UINT64 = 4
    TYPE_INT32 = 5
    TYPE_FIXED64 = 6
    TYPE_FIXED32 = 7
    TYPE_BOOL = 8
    TYPE_STRING = 9
    TYPE_GROUP = 10
    TYPE_MESSAGE = 11
    TYPE_BYTES = 12
    TYPE_UINT32 = 13
    TYPE_ENUM = 14
    TYPE_SFIXED32 = 15
    TYPE_SFIXED64 = 16
    TYPE_SINT32 = 17
    TYPE_SINT64 = 18

  cardinality = _messages.EnumField('CardinalityValueValuesEnum', 1)
  defaultValue = _messages.StringField(2)
  jsonName = _messages.StringField(3)
  kind = _messages.EnumField('KindValueValuesEnum', 4)
  name = _messages.StringField(5)
  number = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  oneofIndex = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  options = _messages.MessageField('Option', 8, repeated=True)
  packed = _messages.BooleanField(9)
  typeUrl = _messages.StringField(10)


class GaugeView(_messages.Message):
  r"""A gauge chart shows where the current value sits within a pre-defined
  range. The upper and lower bounds should define the possible range of values
  for the scorecard's query (inclusive).

  Fields:
    lowerBound: The lower bound for this gauge chart. The value of the chart
      should always be greater than or equal to this.
    upperBound: The upper bound for this gauge chart. The value of the chart
      should always be less than or equal to this.
  """

  lowerBound = _messages.FloatField(1)
  upperBound = _messages.FloatField(2)


class GridLayout(_messages.Message):
  r"""A basic layout divides the available space into vertical columns of
  equal width and arranges a list of widgets using a row-first strategy.

  Fields:
    columns: The number of columns into which the view's width is divided. If
      omitted or set to zero, a system default will be used while rendering.
    widgets: The informational elements that are arranged into the columns
      row-first.
  """

  columns = _messages.IntegerField(1)
  widgets = _messages.MessageField('Widget', 2, repeated=True)


class ListDashboardsResponse(_messages.Message):
  r"""The ListDashboards request.

  Fields:
    dashboards: The list of requested dashboards.
    nextPageToken: If there are more results than have been returned, then
      this field is set to a non-empty value. To see the additional results,
      use that value as page_token in the next call to this method.
  """

  dashboards = _messages.MessageField('Dashboard', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMetricsScopesByMonitoredProjectResponse(_messages.Message):
  r"""Response for the ListMetricsScopesByMonitoredProject method.

  Fields:
    metricsScopes: A set of all metrics scopes that the specified monitored
      project has been added to.
  """

  metricsScopes = _messages.MessageField('MetricsScope', 1, repeated=True)


class MetricsScope(_messages.Message):
  r"""Represents a Metrics Scope
  (https://cloud.google.com/monitoring/settings#concept-scope) in Cloud
  Monitoring, which specifies one or more Google projects and zero or more AWS
  accounts to monitor together.

  Fields:
    createTime: Output only. The time when this Metrics Scope was created.
    monitoredProjects: Output only. The list of projects monitored by this
      Metrics Scope.
    name: Immutable. The resource name of the Monitoring Metrics Scope. On
      input, the resource name can be specified with the scoping project ID or
      number. On output, the resource name is specified with the scoping
      project number. Example:
      locations/global/metricsScopes/{SCOPING_PROJECT_ID_OR_NUMBER}
    updateTime: Output only. The time when this Metrics Scope record was last
      updated.
  """

  createTime = _messages.StringField(1)
  monitoredProjects = _messages.MessageField('MonitoredProject', 2, repeated=True)
  name = _messages.StringField(3)
  updateTime = _messages.StringField(4)


class MonitoredProject(_messages.Message):
  r"""A project being monitored
  (https://cloud.google.com/monitoring/settings/multiple-projects#create-
  multi) by a Metrics Scope.

  Fields:
    createTime: Output only. The time when this MonitoredProject was created.
    name: Immutable. The resource name of the MonitoredProject. On input, the
      resource name includes the scoping project ID and monitored project ID.
      On output, it contains the equivalent project numbers. Example: location
      s/global/metricsScopes/{SCOPING_PROJECT_ID_OR_NUMBER}/projects/{MONITORE
      D_PROJECT_ID_OR_NUMBER}
  """

  createTime = _messages.StringField(1)
  name = _messages.StringField(2)


class MonitoringLocationsGlobalMetricsScopesGetRequest(_messages.Message):
  r"""A MonitoringLocationsGlobalMetricsScopesGetRequest object.

  Fields:
    name: Required. The resource name of the Metrics Scope. Example:
      locations/global/metricsScopes/{SCOPING_PROJECT_ID_OR_NUMBER}
  """

  name = _messages.StringField(1, required=True)


class MonitoringLocationsGlobalMetricsScopesListMetricsScopesByMonitoredProjectRequest(_messages.Message):
  r"""A MonitoringLocationsGlobalMetricsScopesListMetricsScopesByMonitoredProj
  ectRequest object.

  Fields:
    monitoredResourceContainer: Required. The resource name of the Monitored
      Project being requested. Example:
      projects/{MONITORED_PROJECT_ID_OR_NUMBER}
  """

  monitoredResourceContainer = _messages.StringField(1)


class MonitoringLocationsGlobalMetricsScopesProjectsCreateRequest(_messages.Message):
  r"""A MonitoringLocationsGlobalMetricsScopesProjectsCreateRequest object.

  Fields:
    monitoredProject: A MonitoredProject resource to be passed as the request
      body.
    parent: Required. The resource name of the existing Metrics Scope that
      will monitor this project. Example:
      locations/global/metricsScopes/{SCOPING_PROJECT_ID_OR_NUMBER}
  """

  monitoredProject = _messages.MessageField('MonitoredProject', 1)
  parent = _messages.StringField(2, required=True)


class MonitoringLocationsGlobalMetricsScopesProjectsDeleteRequest(_messages.Message):
  r"""A MonitoringLocationsGlobalMetricsScopesProjectsDeleteRequest object.

  Fields:
    name: Required. The resource name of the MonitoredProject. Example: locati
      ons/global/metricsScopes/{SCOPING_PROJECT_ID_OR_NUMBER}/projects/{MONITO
      RED_PROJECT_ID_OR_NUMBER}Authorization requires the following Google IAM
      (https://cloud.google.com/iam) permissions on both the Metrics Scope and
      on the MonitoredProject: monitoring.metricsScopes.link
  """

  name = _messages.StringField(1, required=True)


class MonitoringOperationsGetRequest(_messages.Message):
  r"""A MonitoringOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class MonitoringProjectsDashboardsCreateRequest(_messages.Message):
  r"""A MonitoringProjectsDashboardsCreateRequest object.

  Fields:
    dashboard: A Dashboard resource to be passed as the request body.
    parent: Required. The project on which to execute the request. The format
      is: projects/[PROJECT_ID_OR_NUMBER] The [PROJECT_ID_OR_NUMBER] must
      match the dashboard resource name.
    validateOnly: If set, validate the request and preview the review, but do
      not actually save it.
  """

  dashboard = _messages.MessageField('Dashboard', 1)
  parent = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class MonitoringProjectsDashboardsDeleteRequest(_messages.Message):
  r"""A MonitoringProjectsDashboardsDeleteRequest object.

  Fields:
    name: Required. The resource name of the Dashboard. The format is:
      projects/[PROJECT_ID_OR_NUMBER]/dashboards/[DASHBOARD_ID]
  """

  name = _messages.StringField(1, required=True)


class MonitoringProjectsDashboardsGetRequest(_messages.Message):
  r"""A MonitoringProjectsDashboardsGetRequest object.

  Fields:
    name: Required. The resource name of the Dashboard. The format is one of:
      dashboards/[DASHBOARD_ID] (for system dashboards)
      projects/[PROJECT_ID_OR_NUMBER]/dashboards/[DASHBOARD_ID] (for custom
      dashboards).
  """

  name = _messages.StringField(1, required=True)


class MonitoringProjectsDashboardsListRequest(_messages.Message):
  r"""A MonitoringProjectsDashboardsListRequest object.

  Fields:
    pageSize: A positive number that is the maximum number of results to
      return. If unspecified, a default of 1000 is used.
    pageToken: If this field is not empty then it must contain the
      nextPageToken value returned by a previous call to this method. Using
      this field causes the method to return additional results from the
      previous method call.
    parent: Required. The scope of the dashboards to list. The format is:
      projects/[PROJECT_ID_OR_NUMBER]
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class MonitoringProjectsDashboardsPatchRequest(_messages.Message):
  r"""A MonitoringProjectsDashboardsPatchRequest object.

  Fields:
    dashboard: A Dashboard resource to be passed as the request body.
    name: Immutable. The resource name of the dashboard.
    validateOnly: If set, validate the request and preview the review, but do
      not actually save it.
  """

  dashboard = _messages.MessageField('Dashboard', 1)
  name = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class MosaicLayout(_messages.Message):
  r"""A mosaic layout divides the available space into a grid of blocks, and
  overlays the grid with tiles. Unlike GridLayout, tiles may span multiple
  grid blocks and can be placed at arbitrary locations in the grid.

  Fields:
    columns: The number of columns in the mosaic grid. The number of columns
      must be between 1 and 12, inclusive.
    tiles: The tiles to display.
  """

  columns = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  tiles = _messages.MessageField('Tile', 2, repeated=True)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as Delete, the
      response is google.protobuf.Empty. If the original method is standard
      Get/Create/Update, the response should be the resource. For other
      methods, the response should have the type XxxResponse, where Xxx is the
      original method name. For example, if the original method name is
      TakeSnapshot(), the inferred response type is TakeSnapshotResponse.

  Fields:
    done: If the value is false, it means the operation is still in progress.
      If true, the operation is completed, and either error or response is
      available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the name should be a resource name ending with operations/{unique_id}.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as Delete, the response
      is google.protobuf.Empty. If the original method is standard
      Get/Create/Update, the response should be the resource. For other
      methods, the response should have the type XxxResponse, where Xxx is the
      original method name. For example, if the original method name is
      TakeSnapshot(), the inferred response type is TakeSnapshotResponse.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as Delete, the response
    is google.protobuf.Empty. If the original method is standard
    Get/Create/Update, the response should be the resource. For other methods,
    the response should have the type XxxResponse, where Xxx is the original
    method name. For example, if the original method name is TakeSnapshot(),
    the inferred response type is TakeSnapshotResponse.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Contains metadata for longrunning operation for the edit Metrics Scope
  endpoints.

  Enums:
    StateValueValuesEnum: Current state of the batch operation.

  Fields:
    createTime: The time when the batch request was received.
    state: Current state of the batch operation.
    updateTime: The time when the operation result was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Current state of the batch operation.

    Values:
      STATE_UNSPECIFIED: Invalid.
      CREATED: Request has been received.
      RUNNING: Request is actively being processed.
      DONE: The batch processing is done.
      CANCELLED: The batch processing was cancelled.
    """
    STATE_UNSPECIFIED = 0
    CREATED = 1
    RUNNING = 2
    DONE = 3
    CANCELLED = 4

  createTime = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)
  updateTime = _messages.StringField(3)


class Option(_messages.Message):
  r"""A protocol buffer option, which can be attached to a message, field,
  enumeration, etc.

  Messages:
    ValueValue: The option's value packed in an Any message. If the value is a
      primitive, the corresponding wrapper type defined in
      google/protobuf/wrappers.proto should be used. If the value is an enum,
      it should be stored as an int32 value using the
      google.protobuf.Int32Value type.

  Fields:
    name: The option's name. For protobuf built-in options (options defined in
      descriptor.proto), this is the short name. For example, "map_entry". For
      custom options, it should be the fully-qualified name. For example,
      "google.api.http".
    value: The option's value packed in an Any message. If the value is a
      primitive, the corresponding wrapper type defined in
      google/protobuf/wrappers.proto should be used. If the value is an enum,
      it should be stored as an int32 value using the
      google.protobuf.Int32Value type.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ValueValue(_messages.Message):
    r"""The option's value packed in an Any message. If the value is a
    primitive, the corresponding wrapper type defined in
    google/protobuf/wrappers.proto should be used. If the value is an enum, it
    should be stored as an int32 value using the google.protobuf.Int32Value
    type.

    Messages:
      AdditionalProperty: An additional property for a ValueValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ValueValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  name = _messages.StringField(1)
  value = _messages.MessageField('ValueValue', 2)


class PickTimeSeriesFilter(_messages.Message):
  r"""Describes a ranking-based time series filter. Each input time series is
  ranked with an aligner. The filter will allow up to num_time_series time
  series to pass through it, selecting them based on the relative ranking.For
  example, if ranking_method is METHOD_MEAN,direction is BOTTOM, and
  num_time_series is 3, then the 3 times series with the lowest mean values
  will pass through the filter.

  Enums:
    DirectionValueValuesEnum: How to use the ranking to select time series
      that pass through the filter.
    RankingMethodValueValuesEnum: ranking_method is applied to each time
      series independently to produce the value which will be used to compare
      the time series to other time series.

  Fields:
    direction: How to use the ranking to select time series that pass through
      the filter.
    numTimeSeries: How many time series to allow to pass through the filter.
    rankingMethod: ranking_method is applied to each time series independently
      to produce the value which will be used to compare the time series to
      other time series.
  """

  class DirectionValueValuesEnum(_messages.Enum):
    r"""How to use the ranking to select time series that pass through the
    filter.

    Values:
      DIRECTION_UNSPECIFIED: Not allowed. You must specify a different
        Direction if you specify a PickTimeSeriesFilter.
      TOP: Pass the highest num_time_series ranking inputs.
      BOTTOM: Pass the lowest num_time_series ranking inputs.
    """
    DIRECTION_UNSPECIFIED = 0
    TOP = 1
    BOTTOM = 2

  class RankingMethodValueValuesEnum(_messages.Enum):
    r"""ranking_method is applied to each time series independently to produce
    the value which will be used to compare the time series to other time
    series.

    Values:
      METHOD_UNSPECIFIED: Not allowed. You must specify a different Method if
        you specify a PickTimeSeriesFilter.
      METHOD_MEAN: Select the mean of all values.
      METHOD_MAX: Select the maximum value.
      METHOD_MIN: Select the minimum value.
      METHOD_SUM: Compute the sum of all values.
      METHOD_LATEST: Select the most recent value.
    """
    METHOD_UNSPECIFIED = 0
    METHOD_MEAN = 1
    METHOD_MAX = 2
    METHOD_MIN = 3
    METHOD_SUM = 4
    METHOD_LATEST = 5

  direction = _messages.EnumField('DirectionValueValuesEnum', 1)
  numTimeSeries = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  rankingMethod = _messages.EnumField('RankingMethodValueValuesEnum', 3)


class RatioPart(_messages.Message):
  r"""Describes a query to build the numerator or denominator of a
  TimeSeriesFilterRatio.

  Fields:
    aggregation: By default, the raw time series data is returned. Use this
      field to combine multiple time series for different views of the data.
    filter: Required. The monitoring filter
      (https://cloud.google.com/monitoring/api/v3/filters) that identifies the
      metric types, resources, and projects to query.
  """

  aggregation = _messages.MessageField('Aggregation', 1)
  filter = _messages.StringField(2)


class Row(_messages.Message):
  r"""Defines the layout properties and content for a row.

  Fields:
    weight: The relative weight of this row. The row weight is used to adjust
      the height of rows on the screen (relative to peers). Greater the
      weight, greater the height of the row on the screen. If omitted, a value
      of 1 is used while rendering.
    widgets: The display widgets arranged horizontally in this row.
  """

  weight = _messages.IntegerField(1)
  widgets = _messages.MessageField('Widget', 2, repeated=True)


class RowLayout(_messages.Message):
  r"""A simplified layout that divides the available space into rows and
  arranges a set of widgets horizontally in each row.

  Fields:
    rows: The rows of content to display.
  """

  rows = _messages.MessageField('Row', 1, repeated=True)


class Scorecard(_messages.Message):
  r"""A widget showing the latest value of a metric, and how this value
  relates to one or more thresholds.

  Fields:
    gaugeView: Will cause the scorecard to show a gauge chart.
    sparkChartView: Will cause the scorecard to show a spark chart.
    thresholds: The thresholds used to determine the state of the scorecard
      given the time series' current value. For an actual value x, the
      scorecard is in a danger state if x is less than or equal to a danger
      threshold that triggers below, or greater than or equal to a danger
      threshold that triggers above. Similarly, if x is above/below a warning
      threshold that triggers above/below, then the scorecard is in a warning
      state - unless x also puts it in a danger state. (Danger trumps
      warning.)As an example, consider a scorecard with the following four
      thresholds: { value: 90, category: 'DANGER', trigger: 'ABOVE', }, {
      value: 70, category: 'WARNING', trigger: 'ABOVE', }, { value: 10,
      category: 'DANGER', trigger: 'BELOW', }, { value: 20, category:
      'WARNING', trigger: 'BELOW', }Then: values less than or equal to 10
      would put the scorecard in a DANGER state, values greater than 10 but
      less than or equal to 20 a WARNING state, values strictly between 20 and
      70 an OK state, values greater than or equal to 70 but less than 90 a
      WARNING state, and values greater than or equal to 90 a DANGER state.
    timeSeriesQuery: Required. Fields for querying time series data from the
      Stackdriver metrics API.
  """

  gaugeView = _messages.MessageField('GaugeView', 1)
  sparkChartView = _messages.MessageField('SparkChartView', 2)
  thresholds = _messages.MessageField('Threshold', 3, repeated=True)
  timeSeriesQuery = _messages.MessageField('TimeSeriesQuery', 4)


class SourceContext(_messages.Message):
  r"""SourceContext represents information about the source of a protobuf
  element, like the file in which it is defined.

  Fields:
    fileName: The path-qualified name of the .proto file that contained the
      associated protobuf element. For example:
      "google/protobuf/source_context.proto".
  """

  fileName = _messages.StringField(1)


class SpanContext(_messages.Message):
  r"""The context of a span. This is attached to an Exemplar in Distribution
  values during aggregation.It contains the name of a span with format:
  projects/[PROJECT_ID_OR_NUMBER]/traces/[TRACE_ID]/spans/[SPAN_ID]

  Fields:
    spanName: The resource name of the span. The format is:
      projects/[PROJECT_ID_OR_NUMBER]/traces/[TRACE_ID]/spans/[SPAN_ID]
      [TRACE_ID] is a unique identifier for a trace within a project; it is a
      32-character hexadecimal encoding of a 16-byte array.[SPAN_ID] is a
      unique identifier for a span within a trace; it is a 16-character
      hexadecimal encoding of an 8-byte array.
  """

  spanName = _messages.StringField(1)


class SparkChartView(_messages.Message):
  r"""A sparkChart is a small chart suitable for inclusion in a table-cell or
  inline in text. This message contains the configuration for a sparkChart to
  show up on a Scorecard, showing recent trends of the scorecard's timeseries.

  Enums:
    SparkChartTypeValueValuesEnum: Required. The type of sparkchart to show in
      this chartView.

  Fields:
    minAlignmentPeriod: The lower bound on data point frequency in the chart
      implemented by specifying the minimum alignment period to use in a time
      series query. For example, if the data is published once every 10
      minutes it would not make sense to fetch and align data at one minute
      intervals. This field is optional and exists only as a hint.
    sparkChartType: Required. The type of sparkchart to show in this
      chartView.
  """

  class SparkChartTypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of sparkchart to show in this chartView.

    Values:
      SPARK_CHART_TYPE_UNSPECIFIED: Not allowed in well-formed requests.
      SPARK_LINE: The sparkline will be rendered as a small line chart.
      SPARK_BAR: The sparkbar will be rendered as a small bar chart.
    """
    SPARK_CHART_TYPE_UNSPECIFIED = 0
    SPARK_LINE = 1
    SPARK_BAR = 2

  minAlignmentPeriod = _messages.StringField(1)
  sparkChartType = _messages.EnumField('SparkChartTypeValueValuesEnum', 2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class StatisticalTimeSeriesFilter(_messages.Message):
  r"""A filter that ranks streams based on their statistical relation to other
  streams in a request. Note: This field is deprecated and completely ignored
  by the API.

  Enums:
    RankingMethodValueValuesEnum: rankingMethod is applied to a set of time
      series, and then the produced value for each individual time series is
      used to compare a given time series to others. These are methods that
      cannot be applied stream-by-stream, but rather require the full context
      of a request to evaluate time series.

  Fields:
    numTimeSeries: How many time series to output.
    rankingMethod: rankingMethod is applied to a set of time series, and then
      the produced value for each individual time series is used to compare a
      given time series to others. These are methods that cannot be applied
      stream-by-stream, but rather require the full context of a request to
      evaluate time series.
  """

  class RankingMethodValueValuesEnum(_messages.Enum):
    r"""rankingMethod is applied to a set of time series, and then the
    produced value for each individual time series is used to compare a given
    time series to others. These are methods that cannot be applied stream-by-
    stream, but rather require the full context of a request to evaluate time
    series.

    Values:
      METHOD_UNSPECIFIED: Not allowed in well-formed requests.
      METHOD_CLUSTER_OUTLIER: Compute the outlier score of each stream.
    """
    METHOD_UNSPECIFIED = 0
    METHOD_CLUSTER_OUTLIER = 1

  numTimeSeries = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  rankingMethod = _messages.EnumField('RankingMethodValueValuesEnum', 2)


class Status(_messages.Message):
  r"""The Status type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by gRPC (https://github.com/grpc). Each Status message contains three
  pieces of data: error code, error message, and error details.You can find
  out more about this error model and how to work with it in the API Design
  Guide (https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Text(_messages.Message):
  r"""A widget that displays textual content.

  Enums:
    FormatValueValuesEnum: How the text content is formatted.

  Fields:
    content: The text content to be displayed.
    format: How the text content is formatted.
  """

  class FormatValueValuesEnum(_messages.Enum):
    r"""How the text content is formatted.

    Values:
      FORMAT_UNSPECIFIED: Format is unspecified. Defaults to MARKDOWN.
      MARKDOWN: The text contains Markdown formatting.
      RAW: The text contains no special formatting.
    """
    FORMAT_UNSPECIFIED = 0
    MARKDOWN = 1
    RAW = 2

  content = _messages.StringField(1)
  format = _messages.EnumField('FormatValueValuesEnum', 2)


class Threshold(_messages.Message):
  r"""Defines a threshold for categorizing time series values.

  Enums:
    ColorValueValuesEnum: The state color for this threshold. Color is not
      allowed in a XyChart.
    DirectionValueValuesEnum: The direction for the current threshold.
      Direction is not allowed in a XyChart.

  Fields:
    color: The state color for this threshold. Color is not allowed in a
      XyChart.
    direction: The direction for the current threshold. Direction is not
      allowed in a XyChart.
    label: A label for the threshold.
    value: The value of the threshold. The value should be defined in the
      native scale of the metric.
  """

  class ColorValueValuesEnum(_messages.Enum):
    r"""The state color for this threshold. Color is not allowed in a XyChart.

    Values:
      COLOR_UNSPECIFIED: Color is unspecified. Not allowed in well-formed
        requests.
      YELLOW: Crossing the threshold is "concerning" behavior.
      RED: Crossing the threshold is "emergency" behavior.
    """
    COLOR_UNSPECIFIED = 0
    YELLOW = 1
    RED = 2

  class DirectionValueValuesEnum(_messages.Enum):
    r"""The direction for the current threshold. Direction is not allowed in a
    XyChart.

    Values:
      DIRECTION_UNSPECIFIED: Not allowed in well-formed requests.
      ABOVE: The threshold will be considered crossed if the actual value is
        above the threshold value.
      BELOW: The threshold will be considered crossed if the actual value is
        below the threshold value.
    """
    DIRECTION_UNSPECIFIED = 0
    ABOVE = 1
    BELOW = 2

  color = _messages.EnumField('ColorValueValuesEnum', 1)
  direction = _messages.EnumField('DirectionValueValuesEnum', 2)
  label = _messages.StringField(3)
  value = _messages.FloatField(4)


class Tile(_messages.Message):
  r"""A single tile in the mosaic. The placement and size of the tile are
  configurable.

  Fields:
    height: The height of the tile, measured in grid blocks. Tiles must have a
      minimum height of 1.
    widget: The informational widget contained in the tile. For example an
      XyChart.
    width: The width of the tile, measured in grid blocks. Tiles must have a
      minimum width of 1.
    xPos: The zero-indexed position of the tile in grid blocks relative to the
      left edge of the grid. Tiles must be contained within the specified
      number of columns. x_pos cannot be negative.
    yPos: The zero-indexed position of the tile in grid blocks relative to the
      top edge of the grid. y_pos cannot be negative.
  """

  height = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  widget = _messages.MessageField('Widget', 2)
  width = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  xPos = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  yPos = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class TimeSeriesFilter(_messages.Message):
  r"""A filter that defines a subset of time series data that is displayed in
  a widget. Time series data is fetched using the ListTimeSeries (https://clou
  d.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list) method.

  Fields:
    aggregation: By default, the raw time series data is returned. Use this
      field to combine multiple time series for different views of the data.
    filter: Required. The monitoring filter
      (https://cloud.google.com/monitoring/api/v3/filters) that identifies the
      metric types, resources, and projects to query.
    pickTimeSeriesFilter: Ranking based time series filter.
    secondaryAggregation: Apply a second aggregation after aggregation is
      applied.
    statisticalTimeSeriesFilter: Statistics based time series filter. Note:
      This field is deprecated and completely ignored by the API.
  """

  aggregation = _messages.MessageField('Aggregation', 1)
  filter = _messages.StringField(2)
  pickTimeSeriesFilter = _messages.MessageField('PickTimeSeriesFilter', 3)
  secondaryAggregation = _messages.MessageField('Aggregation', 4)
  statisticalTimeSeriesFilter = _messages.MessageField('StatisticalTimeSeriesFilter', 5)


class TimeSeriesFilterRatio(_messages.Message):
  r"""A pair of time series filters that define a ratio computation. The
  output time series is the pair-wise division of each aligned element from
  the numerator and denominator time series.

  Fields:
    denominator: The denominator of the ratio.
    numerator: The numerator of the ratio.
    pickTimeSeriesFilter: Ranking based time series filter.
    secondaryAggregation: Apply a second aggregation after the ratio is
      computed.
    statisticalTimeSeriesFilter: Statistics based time series filter. Note:
      This field is deprecated and completely ignored by the API.
  """

  denominator = _messages.MessageField('RatioPart', 1)
  numerator = _messages.MessageField('RatioPart', 2)
  pickTimeSeriesFilter = _messages.MessageField('PickTimeSeriesFilter', 3)
  secondaryAggregation = _messages.MessageField('Aggregation', 4)
  statisticalTimeSeriesFilter = _messages.MessageField('StatisticalTimeSeriesFilter', 5)


class TimeSeriesQuery(_messages.Message):
  r"""TimeSeriesQuery collects the set of supported methods for querying time
  series data from the Stackdriver metrics API.

  Fields:
    timeSeriesFilter: Filter parameters to fetch time series.
    timeSeriesFilterRatio: Parameters to fetch a ratio between two time series
      filters.
    timeSeriesQueryLanguage: A query used to fetch time series.
    unitOverride: The unit of data contained in fetched time series. If non-
      empty, this unit will override any unit that accompanies fetched data.
      The format is the same as the unit (https://cloud.google.com/monitoring/
      api/ref_v3/rest/v3/projects.metricDescriptors) field in
      MetricDescriptor.
  """

  timeSeriesFilter = _messages.MessageField('TimeSeriesFilter', 1)
  timeSeriesFilterRatio = _messages.MessageField('TimeSeriesFilterRatio', 2)
  timeSeriesQueryLanguage = _messages.StringField(3)
  unitOverride = _messages.StringField(4)


class Type(_messages.Message):
  r"""A protocol buffer message type.

  Enums:
    SyntaxValueValuesEnum: The source syntax.

  Fields:
    fields: The list of fields.
    name: The fully qualified message name.
    oneofs: The list of types appearing in oneof definitions in this type.
    options: The protocol buffer options.
    sourceContext: The source context.
    syntax: The source syntax.
  """

  class SyntaxValueValuesEnum(_messages.Enum):
    r"""The source syntax.

    Values:
      SYNTAX_PROTO2: Syntax proto2.
      SYNTAX_PROTO3: Syntax proto3.
    """
    SYNTAX_PROTO2 = 0
    SYNTAX_PROTO3 = 1

  fields = _messages.MessageField('Field', 1, repeated=True)
  name = _messages.StringField(2)
  oneofs = _messages.StringField(3, repeated=True)
  options = _messages.MessageField('Option', 4, repeated=True)
  sourceContext = _messages.MessageField('SourceContext', 5)
  syntax = _messages.EnumField('SyntaxValueValuesEnum', 6)


class Widget(_messages.Message):
  r"""Widget contains a single dashboard component and configuration of how to
  present the component in the dashboard.

  Fields:
    alertChart: A chart of alert policy data.
    blank: A blank space.
    scorecard: A scorecard summarizing time series data.
    text: A raw string or markdown displaying textual content.
    title: Optional. The title of the widget.
    xyChart: A chart of time series data.
  """

  alertChart = _messages.MessageField('AlertChart', 1)
  blank = _messages.MessageField('Empty', 2)
  scorecard = _messages.MessageField('Scorecard', 3)
  text = _messages.MessageField('Text', 4)
  title = _messages.StringField(5)
  xyChart = _messages.MessageField('XyChart', 6)


class XyChart(_messages.Message):
  r"""A chart that displays data on a 2D (X and Y axes) plane.

  Fields:
    chartOptions: Display options for the chart.
    dataSets: Required. The data displayed in this chart.
    thresholds: Threshold lines drawn horizontally across the chart.
    timeshiftDuration: The duration used to display a comparison chart. A
      comparison chart simultaneously shows values from two similar-length
      time periods (e.g., week-over-week metrics). The duration must be
      positive, and it can only be applied to charts with data sets of LINE
      plot type.
    xAxis: The properties applied to the X axis.
    yAxis: The properties applied to the Y axis.
  """

  chartOptions = _messages.MessageField('ChartOptions', 1)
  dataSets = _messages.MessageField('DataSet', 2, repeated=True)
  thresholds = _messages.MessageField('Threshold', 3, repeated=True)
  timeshiftDuration = _messages.StringField(4)
  xAxis = _messages.MessageField('Axis', 5)
  yAxis = _messages.MessageField('Axis', 6)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
