"""Generated message classes for gkemulticloud version v1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'gkemulticloud'


class GkemulticloudProjectsLocationsAwsClustersAwsNodePoolsCreateRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAwsClustersAwsNodePoolsCreateRequest
  object.

  Fields:
    awsNodePoolId: Required. The ID to use for the node pool, which will
      become the final component of the node pool's resource name. This value
      must be up to 40 characters, and valid characters are /a-z-/.
    googleCloudGkemulticloudV1AwsNodePool: A
      GoogleCloudGkemulticloudV1AwsNodePool resource to be passed as the
      request body.
    parent: Required. The parent resource where this node pool will be
      created. projects/{project}/locations/{location}/awsClusters/{cluster}
    validateOnly: If set, only validate the request, but do not actually
      create the node pool.
  """

  awsNodePoolId = _messages.StringField(1)
  googleCloudGkemulticloudV1AwsNodePool = _messages.MessageField('GoogleCloudGkemulticloudV1AwsNodePool', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class GkemulticloudProjectsLocationsAwsClustersAwsNodePoolsDeleteRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAwsClustersAwsNodePoolsDeleteRequest
  object.

  Fields:
    allowMissing: If set to true, and the AWS Node Pool is not found, the
      request will succeed but no action will be taken on the server and
      return a completed LRO.
    etag: The current etag of the AWSNodePool. If an etag is provided and does
      not match the current etag of the nodepool, deletion will be blocked and
      an ABORTED error will be returned.
    name: Required. The name of the node pool to delete. Format: projects/{pro
      ject}/locations/{location}/awsClusters/{cluster}/awsNodePools/{nodepool}
    validateOnly: If set, only validate the request, but do not actually
      delete the node pool.
  """

  allowMissing = _messages.BooleanField(1)
  etag = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class GkemulticloudProjectsLocationsAwsClustersAwsNodePoolsGetRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAwsClustersAwsNodePoolsGetRequest
  object.

  Fields:
    name: Required. The name of the node pool to retrieve. Format: projects/{p
      roject}/locations/{location}/awsClusters/{cluster}/awsNodePools/{nodepoo
      l}
  """

  name = _messages.StringField(1, required=True)


class GkemulticloudProjectsLocationsAwsClustersAwsNodePoolsListRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAwsClustersAwsNodePoolsListRequest
  object.

  Fields:
    pageSize: The maximum number of node pools to return. The service may
      return fewer than this value. If unspecified, at most 50 node pools will
      be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: A page token, received from a previous `ListAwsNodePools` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListAwsNodePools` must match the call that
      provided the page token.
    parent: Required. The parent, which owns this collection of node pools.
      Format: projects/{project}/locations/{location}/awsClusters/{cluster-id}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class GkemulticloudProjectsLocationsAwsClustersCreateRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAwsClustersCreateRequest object.

  Fields:
    awsClusterId: Required. The ID to use for the cluster, which will become
      the final component of the cluster's resource name. This value must be
      up to 40 characters, and valid characters are /a-z-/.
    googleCloudGkemulticloudV1AwsCluster: A
      GoogleCloudGkemulticloudV1AwsCluster resource to be passed as the
      request body.
    parent: Required. The parent resource where this cluster will be created.
      Format: projects/{project}/locations/{location}
    validateOnly: If set, only validate the request, but do not actually
      create the cluster.
  """

  awsClusterId = _messages.StringField(1)
  googleCloudGkemulticloudV1AwsCluster = _messages.MessageField('GoogleCloudGkemulticloudV1AwsCluster', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class GkemulticloudProjectsLocationsAwsClustersDeleteRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAwsClustersDeleteRequest object.

  Fields:
    allowMissing: If set to true, and the AWS Cluster is not found, the
      request will succeed but no action will be taken on the server and
      return a completed LRO.
    etag: The current etag of the AWSCluster. If an etag is provided and does
      not match the current etag of the cluster, deletion will be blocked and
      an ABORTED error will be returned.
    name: Required. The name of the cluster to delete. Format:
      projects/{project}/locations/{location}/awsClusters/{cluster}
    validateOnly: If set, only validate the request, but do not actually
      delete the cluster.
  """

  allowMissing = _messages.BooleanField(1)
  etag = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class GkemulticloudProjectsLocationsAwsClustersGetAwsClusterAdminKubeconfigRequest(_messages.Message):
  r"""A
  GkemulticloudProjectsLocationsAwsClustersGetAwsClusterAdminKubeconfigRequest
  object.

  Fields:
    awsCluster: Required. The name of the cluster. Format:
      projects/{project}/locations/{location}/awsClusters/{cluster}
  """

  awsCluster = _messages.StringField(1, required=True)


class GkemulticloudProjectsLocationsAwsClustersGetJwksRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAwsClustersGetJwksRequest object.

  Fields:
    awsCluster: Required. The AwsCluster, which owns the JsonWebKeys. Format:
      projects/{project}/locations/{location}/awsClusters/{cluster}
  """

  awsCluster = _messages.StringField(1, required=True)


class GkemulticloudProjectsLocationsAwsClustersGetRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAwsClustersGetRequest object.

  Fields:
    name: Required. The name of the cluster to retrieve. Format:
      projects/{project}/locations/{location}/awsClusters/{cluster}
  """

  name = _messages.StringField(1, required=True)


class GkemulticloudProjectsLocationsAwsClustersListRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAwsClustersListRequest object.

  Fields:
    pageSize: The maximum number of clusters to return. The service may return
      fewer than this value. If unspecified, at most 50 clusters will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: A page token, received from a previous `ListAwsClusters` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListAwsClusters` must match the call that
      provided the page token.
    parent: Required. The parent, which owns this collection of clusters.
      Format: projects/{project}/locations/{location}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class GkemulticloudProjectsLocationsAwsClustersPatchRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAwsClustersPatchRequest object.

  Fields:
    googleCloudGkemulticloudV1AwsCluster: A
      GoogleCloudGkemulticloudV1AwsCluster resource to be passed as the
      request body.
    name: The resource name of this cluster.
    updateMask: The list of fields to be updated.
    validateOnly: If set, only validate the request, but do not actually
      update the cluster.
  """

  googleCloudGkemulticloudV1AwsCluster = _messages.MessageField('GoogleCloudGkemulticloudV1AwsCluster', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class GkemulticloudProjectsLocationsAwsClustersWellKnownGetOpenidConfigurationRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAwsClustersWellKnownGetOpenidConfigurati
  onRequest object.

  Fields:
    awsCluster: Required. The AwsCluster, which owns the OIDC discovery
      document. Format:
      projects/{project}/locations/{location}/awsClusters/{cluster}
  """

  awsCluster = _messages.StringField(1, required=True)


class GkemulticloudProjectsLocationsAzureClientsCreateRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAzureClientsCreateRequest object.

  Fields:
    azureClientId: Required. The ID to use for the Azure client, which will
      become the final component of the client's resource name. This value
      must be up to 40 characters, and valid characters are /a-z-/.
    googleCloudGkemulticloudV1AzureClient: A
      GoogleCloudGkemulticloudV1AzureClient resource to be passed as the
      request body.
    parent: Required. The parent resource where this Azure client will be
      created. Format: projects/{project}/locations/{location}
    validateOnly: If set, only validate the request, but do not actually
      create the client.
  """

  azureClientId = _messages.StringField(1)
  googleCloudGkemulticloudV1AzureClient = _messages.MessageField('GoogleCloudGkemulticloudV1AzureClient', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class GkemulticloudProjectsLocationsAzureClientsDeleteRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAzureClientsDeleteRequest object.

  Fields:
    allowMissing: If set to true, and the Azure Client is not found, the
      request will succeed but no action will be taken on the server and
      return a completed LRO.
    name: Required. The name of the Azure clients to delete. Format:
      projects/{project}/locations/{location}/azureClients/{client-id}
    validateOnly: If set, only validate the request, but do not actually
      delete the azure client.
  """

  allowMissing = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class GkemulticloudProjectsLocationsAzureClientsGetRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAzureClientsGetRequest object.

  Fields:
    name: Required. The name of the zure client to retrieve. Format:
      projects/{project}/locations/{location}/azureClients/{client-id}
  """

  name = _messages.StringField(1, required=True)


class GkemulticloudProjectsLocationsAzureClientsListRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAzureClientsListRequest object.

  Fields:
    pageSize: The maximum number of Azure clients to return. The service may
      return fewer than this value. If unspecified, at most 50 Azure clients
      will be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: A page token, received from a previous `ListAzureClients` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListAzureClients` must match the call that
      provided the page token.
    parent: Required. The parent, which owns this collection of Azure clients.
      Format: projects/{project}/locations/{location}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class GkemulticloudProjectsLocationsAzureClustersAzureNodePoolsCreateRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAzureClustersAzureNodePoolsCreateRequest
  object.

  Fields:
    azureNodePoolId: Required. The ID to use for the node pool, which will
      become the final component of the node pool's resource name. This value
      must be up to 40 characters, and valid characters are /a-z-/.
    googleCloudGkemulticloudV1AzureNodePool: A
      GoogleCloudGkemulticloudV1AzureNodePool resource to be passed as the
      request body.
    parent: Required. The parent resource where this node pool will be
      created. projects/{project}/locations/{location}/azureClusters/{cluster}
    validateOnly: If set, only validate the request, but do not actually
      create the node pool.
  """

  azureNodePoolId = _messages.StringField(1)
  googleCloudGkemulticloudV1AzureNodePool = _messages.MessageField('GoogleCloudGkemulticloudV1AzureNodePool', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class GkemulticloudProjectsLocationsAzureClustersAzureNodePoolsDeleteRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAzureClustersAzureNodePoolsDeleteRequest
  object.

  Fields:
    allowMissing: If set to true, and the Azure node pool is not found, the
      request will succeed but no action will be taken on the server and
      return a completed LRO.
    etag: The current etag of the AzureNodePool. If an etag is provided and
      does not match the current etag of the nodepool, deletion will be
      blocked and an ABORTED error will be returned.
    name: Required. The name of the node pool to delete. Format: projects/{pro
      ject}/locations/{location}/azureClusters/{cluster}/azureNodePools/{nodep
      ool}
    validateOnly: If set, only validate the request, but do not actually
      delete the node pool.
  """

  allowMissing = _messages.BooleanField(1)
  etag = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class GkemulticloudProjectsLocationsAzureClustersAzureNodePoolsGetRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAzureClustersAzureNodePoolsGetRequest
  object.

  Fields:
    name: Required. The name of the node pool to retrieve. Format: projects/{p
      roject}/locations/{location}/azureClusters/{cluster}/azureNodePools/{nod
      epool}
  """

  name = _messages.StringField(1, required=True)


class GkemulticloudProjectsLocationsAzureClustersAzureNodePoolsListRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAzureClustersAzureNodePoolsListRequest
  object.

  Fields:
    pageSize: The maximum number of node pools to return. The service may
      return fewer than this value. If unspecified, at most 50 node pools will
      be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: A page token, received from a previous `ListAzureNodePools`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListAzureNodePools` must match the call
      that provided the page token.
    parent: Required. The parent, which owns this collection of node pools.
      Format: projects/{project}/locations/{location}/azureClusters/{cluster-
      id}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class GkemulticloudProjectsLocationsAzureClustersCreateRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAzureClustersCreateRequest object.

  Fields:
    azureClusterId: Required. The ID to use for the cluster, which will become
      the final component of the cluster's resource name. This value must be
      up to 40 characters, and valid characters are /a-z-/.
    googleCloudGkemulticloudV1AzureCluster: A
      GoogleCloudGkemulticloudV1AzureCluster resource to be passed as the
      request body.
    parent: Required. The parent resource where this cluster will be created.
      Format: projects/{project}/locations/{location}
    validateOnly: If set, only validate the request, but do not actually
      create the cluster.
  """

  azureClusterId = _messages.StringField(1)
  googleCloudGkemulticloudV1AzureCluster = _messages.MessageField('GoogleCloudGkemulticloudV1AzureCluster', 2)
  parent = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class GkemulticloudProjectsLocationsAzureClustersDeleteRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAzureClustersDeleteRequest object.

  Fields:
    allowMissing: If set to true, and the Azure Cluster is not found, the
      request will succeed but no action will be taken on the server and
      return a completed LRO.
    etag: The current etag of the AzureCluster. If an etag is provided and
      does not match the current etag of the cluster, deletion will be blocked
      and an ABORTED error will be returned.
    name: Required. The name of the cluster to delete. Format:
      projects/{project}/locations/{location}/azureClusters/{cluster}
    validateOnly: If set, only validate the request, but do not actually
      delete the cluster.
  """

  allowMissing = _messages.BooleanField(1)
  etag = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class GkemulticloudProjectsLocationsAzureClustersGetAzureClusterAdminKubeconfigRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAzureClustersGetAzureClusterAdminKubecon
  figRequest object.

  Fields:
    azureCluster: Required. The name of the cluster. Format:
      projects/{project}/locations/{location}/azureClusters/{cluster}
  """

  azureCluster = _messages.StringField(1, required=True)


class GkemulticloudProjectsLocationsAzureClustersGetJwksRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAzureClustersGetJwksRequest object.

  Fields:
    azureCluster: Required. The AzureCluster, which owns the JsonWebKeys.
      Format: projects/{project}/locations/{location}/azureClusters/{cluster}
  """

  azureCluster = _messages.StringField(1, required=True)


class GkemulticloudProjectsLocationsAzureClustersGetRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAzureClustersGetRequest object.

  Fields:
    name: Required. The name of the cluster to retrieve. Format:
      projects/{project}/locations/{location}/azureClusters/{cluster}
  """

  name = _messages.StringField(1, required=True)


class GkemulticloudProjectsLocationsAzureClustersListRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAzureClustersListRequest object.

  Fields:
    pageSize: The maximum number of clusters to return. The service may return
      fewer than this value. If unspecified, at most 50 clusters will be
      returned. The maximum value is 1000; values above 1000 will be coerced
      to 1000.
    pageToken: A page token, received from a previous `ListAzureClusters`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListAzureClusters` must match the call
      that provided the page token.
    parent: Required. The parent, which owns this collection of clusters.
      Format: projects/{project}/locations{location}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class GkemulticloudProjectsLocationsAzureClustersPatchRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAzureClustersPatchRequest object.

  Fields:
    googleCloudGkemulticloudV1AzureCluster: A
      GoogleCloudGkemulticloudV1AzureCluster resource to be passed as the
      request body.
    name: The resource name of this cluster.
    updateMask: Required. The list of fields to be updated.
    validateOnly: If set, only validate the request, but do not actually
      update the cluster.
  """

  googleCloudGkemulticloudV1AzureCluster = _messages.MessageField('GoogleCloudGkemulticloudV1AzureCluster', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class GkemulticloudProjectsLocationsAzureClustersWellKnownGetOpenidConfigurationRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsAzureClustersWellKnownGetOpenidConfigura
  tionRequest object.

  Fields:
    azureCluster: Required. The AzureCluster, which owns the OIDC discovery
      document. Format:
      projects/{project}/locations/{location}/azureClusters/{cluster}
  """

  azureCluster = _messages.StringField(1, required=True)


class GkemulticloudProjectsLocationsGetAwsServerConfigRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsGetAwsServerConfigRequest object.

  Fields:
    name: Required. The name of the AWS server config to retrieve. Format:
      projects/{project}/locations/{location}/awsServerConfig
  """

  name = _messages.StringField(1, required=True)


class GkemulticloudProjectsLocationsGetAzureServerConfigRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsGetAzureServerConfigRequest object.

  Fields:
    name: Required. The name of the Azure server config to retrieve. Format:
      projects/{project}/locations/{location}/azureServerConfig
  """

  name = _messages.StringField(1, required=True)


class GkemulticloudProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsOperationsCancelRequest object.

  Fields:
    googleLongrunningCancelOperationRequest: A
      GoogleLongrunningCancelOperationRequest resource to be passed as the
      request body.
    name: The name of the operation resource to be cancelled.
  """

  googleLongrunningCancelOperationRequest = _messages.MessageField('GoogleLongrunningCancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class GkemulticloudProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class GkemulticloudProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class GkemulticloudProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A GkemulticloudProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GoogleCloudGkemulticloudV1AwsAuthorization(_messages.Message):
  r"""Configuration related to the cluster RBAC settings.

  Fields:
    adminUsers: Users to perform operations as a cluster admin. A new
      ClusterRoleBinding will be created to grant the cluster-admin
      ClusterRole to the users. At most one user can be specified. For more
      info on RBAC, see https://kubernetes.io/docs/reference/access-authn-
      authz/rbac/#user-facing-roles
  """

  adminUsers = _messages.MessageField('GoogleCloudGkemulticloudV1AwsClusterUser', 1, repeated=True)


class GoogleCloudGkemulticloudV1AwsCluster(_messages.Message):
  r"""A GKE cluster running on AWS.

  Enums:
    StateValueValuesEnum: Output only. The current state of the cluster.

  Messages:
    AnnotationsValue: Annotations on the cluster. This field has the same
      restrictions as Kubernetes annotations. The total size of all keys and
      values combined is limited to 256k. Key can have 2 segments: prefix
      (optional) and name (required), separated by a slash (/). Prefix must be
      a DNS subdomain. Name must be 63 characters or less, begin and end with
      alphanumerics, with dashes (-), underscores (_), dots (.), and
      alphanumerics between.

  Fields:
    annotations: Annotations on the cluster. This field has the same
      restrictions as Kubernetes annotations. The total size of all keys and
      values combined is limited to 256k. Key can have 2 segments: prefix
      (optional) and name (required), separated by a slash (/). Prefix must be
      a DNS subdomain. Name must be 63 characters or less, begin and end with
      alphanumerics, with dashes (-), underscores (_), dots (.), and
      alphanumerics between.
    authorization: Configuration related to the cluster RBAC settings.
    awsRegion: The AWS region where this cluster runs.
    controlPlane: Configuration related to the cluster control plane.
    createTime: Output only. The time at which this cluster was created.
    description: A human readable description of this cluster.
    endpoint: Output only. The DNS name of this cluster's API server.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding. Allows clients to
      perform consistent read-modify-writes through optimistic concurrency
      control.
    name: The resource name of this cluster.
    networking: Cluster-wide networking configuration.
    reconciling: Output only. If set, there are currently changes in flight to
      the cluster.
    state: Output only. The current state of the cluster.
    uid: Output only. The unique identifier of the cluster.
    updateTime: Output only. The time at which this cluster was last updated.
    workloadIdentityConfig: Output only. Workload Identity settings.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the cluster.

    Values:
      STATE_UNSPECIFIED: Not set.
      PROVISIONING: The PROVISIONING state indicates the cluster is being
        created.
      RUNNING: The RUNNING state indicates the cluster has been created and is
        fully usable.
      RECONCILING: The RECONCILING state indicates that the cluster is being
        reconciled.
      STOPPING: The STOPPING state indicates the cluster is being deleted.
      ERROR: The ERROR state indicates the cluster is in a broken
        unrecoverable state.
      DEGRADED: The DEGRADED state indicates the cluster requires user action
        to restore full functionality.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    RUNNING = 2
    RECONCILING = 3
    STOPPING = 4
    ERROR = 5
    DEGRADED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Annotations on the cluster. This field has the same restrictions as
    Kubernetes annotations. The total size of all keys and values combined is
    limited to 256k. Key can have 2 segments: prefix (optional) and name
    (required), separated by a slash (/). Prefix must be a DNS subdomain. Name
    must be 63 characters or less, begin and end with alphanumerics, with
    dashes (-), underscores (_), dots (.), and alphanumerics between.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  authorization = _messages.MessageField('GoogleCloudGkemulticloudV1AwsAuthorization', 2)
  awsRegion = _messages.StringField(3)
  controlPlane = _messages.MessageField('GoogleCloudGkemulticloudV1AwsControlPlane', 4)
  createTime = _messages.StringField(5)
  description = _messages.StringField(6)
  endpoint = _messages.StringField(7)
  etag = _messages.StringField(8)
  name = _messages.StringField(9)
  networking = _messages.MessageField('GoogleCloudGkemulticloudV1AwsClusterNetworking', 10)
  reconciling = _messages.BooleanField(11)
  state = _messages.EnumField('StateValueValuesEnum', 12)
  uid = _messages.StringField(13)
  updateTime = _messages.StringField(14)
  workloadIdentityConfig = _messages.MessageField('GoogleCloudGkemulticloudV1WorkloadIdentityConfig', 15)


class GoogleCloudGkemulticloudV1AwsClusterNetworking(_messages.Message):
  r"""ClusterNetworking defines cluster-wide networking configuration. GKE
  clusters on AWS run on a single VPC. This includes control plane and node
  pool nodes.

  Fields:
    podAddressCidrBlocks: All pods in the cluster are assigned an RFC1918 IPv4
      address from these ranges. Only a single range is supported. This field
      cannot be changed after creation.
    serviceAddressCidrBlocks: All services in the cluster are assigned an
      RFC1918 IPv4 address from these ranges. Only a single range is
      supported. This field cannot be changed after creation.
    serviceLoadBalancerSubnetIds: When creating Kubernetes services of type
      'Load Balancer', the load balancer will be created in these subnets.
    vpcId: The VPC associated with your cluster. All component clusters (i.e.
      control plane and node pools) run on a single vpc. This field cannot be
      changed after creation.
  """

  podAddressCidrBlocks = _messages.StringField(1, repeated=True)
  serviceAddressCidrBlocks = _messages.StringField(2, repeated=True)
  serviceLoadBalancerSubnetIds = _messages.StringField(3, repeated=True)
  vpcId = _messages.StringField(4)


class GoogleCloudGkemulticloudV1AwsClusterUser(_messages.Message):
  r"""Identities of a user-type subject for AWS clusters.

  Fields:
    username: The name of the user, e.g. my-gcp-id@gmail.com.
  """

  username = _messages.StringField(1)


class GoogleCloudGkemulticloudV1AwsControlPlane(_messages.Message):
  r"""ControlPlane defines common parameters between control plane nodes.

  Messages:
    TagsValue: Key/value metadata to assign to each underlying AWS resource.
      Specify at most 50 pairs containing alphanumerics, spaces, and symbols
      (.+-=_:@/). Keys can be up to 127 Unicode characters. Values can be up
      to 255 Unicode characters.

  Fields:
    awsServicesAuthentication: Authentication configuration for management of
      AWS resources.
    databaseEncryption: The ARN of the AWS KMS key used to encrypt cluster
      secrets.
    iamInstanceProfile: The name of the AWS IAM role assigned to control plane
      replicas.
    instanceType: The AWS instance type.
    mainVolume: Template for the volume provisioned for etcd storage. Volumes
      will be provisioned in the availability zone associated with the
      corresponding subnet.
    rootVolume: Template for the root volume provisioned for control plane
      node instances. Volumes will be provisioned in the availability zone
      associated with the corresponding subnet.
    securityGroupIds: The IDs of additional security groups to add to control
      plane replicas. The manager will automatically create security groups
      with minimum rules needed for a functioning cluster.
    sshConfig: The SSH configuration.
    subnetIds: The list of subnets where control plane nodes will run. A node
      will be provisioned on each subnet.
    tags: Key/value metadata to assign to each underlying AWS resource.
      Specify at most 50 pairs containing alphanumerics, spaces, and symbols
      (.+-=_:@/). Keys can be up to 127 Unicode characters. Values can be up
      to 255 Unicode characters.
    version: The kubernetes control plane version (e.g. 1.16.9-gke.12).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TagsValue(_messages.Message):
    r"""Key/value metadata to assign to each underlying AWS resource. Specify
    at most 50 pairs containing alphanumerics, spaces, and symbols (.+-=_:@/).
    Keys can be up to 127 Unicode characters. Values can be up to 255 Unicode
    characters.

    Messages:
      AdditionalProperty: An additional property for a TagsValue object.

    Fields:
      additionalProperties: Additional properties of type TagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  awsServicesAuthentication = _messages.MessageField('GoogleCloudGkemulticloudV1AwsServicesAuthentication', 1)
  databaseEncryption = _messages.MessageField('GoogleCloudGkemulticloudV1AwsDatabaseEncryption', 2)
  iamInstanceProfile = _messages.StringField(3)
  instanceType = _messages.StringField(4)
  mainVolume = _messages.MessageField('GoogleCloudGkemulticloudV1AwsVolumeTemplate', 5)
  rootVolume = _messages.MessageField('GoogleCloudGkemulticloudV1AwsVolumeTemplate', 6)
  securityGroupIds = _messages.StringField(7, repeated=True)
  sshConfig = _messages.MessageField('GoogleCloudGkemulticloudV1AwsSshConfig', 8)
  subnetIds = _messages.StringField(9, repeated=True)
  tags = _messages.MessageField('TagsValue', 10)
  version = _messages.StringField(11)


class GoogleCloudGkemulticloudV1AwsDatabaseEncryption(_messages.Message):
  r"""Configuration related to application-layer secrets encryption.

  Fields:
    kmsKeyArn: The ARN of the AWS KMS key used to encrypt cluster secrets.
  """

  kmsKeyArn = _messages.StringField(1)


class GoogleCloudGkemulticloudV1AwsJsonWebKeys(_messages.Message):
  r"""AwsJsonWebKeys is a valid JSON Web Key Set as specififed in RFC 7517.

  Fields:
    keys: The public component of the keys used by the cluster to sign token
      requests.
  """

  keys = _messages.MessageField('GoogleCloudGkemulticloudV1Jwk', 1, repeated=True)


class GoogleCloudGkemulticloudV1AwsK8sVersionInfo(_messages.Message):
  r"""Kubernetes version information of GKE cluster on AWS.

  Fields:
    version: Kubernetes version name.
  """

  version = _messages.StringField(1)


class GoogleCloudGkemulticloudV1AwsNodeConfig(_messages.Message):
  r"""Parameters that describe the nodes in a cluster.

  Messages:
    LabelsValue: The initial labels assigned to nodes of this node pool. An
      object containing a list of "key": value pairs. Example: { "name":
      "wrench", "mass": "1.3kg", "count": "3" }.
    TagsValue: Key/value metadata to assign to each underlying AWS resource.
      Specify at most 50 pairs containing alphanumerics, spaces, and symbols
      (.+-=_:@/). Keys can be up to 127 Unicode characters. Values can be up
      to 255 Unicode characters.

  Fields:
    iamInstanceProfile: The name of the AWS IAM role assigned to nodes in the
      pool.
    instanceType: The AWS instance type.
    labels: The initial labels assigned to nodes of this node pool. An object
      containing a list of "key": value pairs. Example: { "name": "wrench",
      "mass": "1.3kg", "count": "3" }.
    rootVolume: Template for the root volume provisioned for node pool nodes.
      Volumes will be provisioned in the availability zone assigned to the
      node pool subnet.
    securityGroupIds: The IDs of additional security groups to add to nodes in
      this pool. The manager will automatically create security groups with
      minimum rules needed for a functioning cluster.
    sshConfig: The SSH configuration.
    tags: Key/value metadata to assign to each underlying AWS resource.
      Specify at most 50 pairs containing alphanumerics, spaces, and symbols
      (.+-=_:@/). Keys can be up to 127 Unicode characters. Values can be up
      to 255 Unicode characters.
    taints: The initial taints assigned to nodes of this node pool.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The initial labels assigned to nodes of this node pool. An object
    containing a list of "key": value pairs. Example: { "name": "wrench",
    "mass": "1.3kg", "count": "3" }.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TagsValue(_messages.Message):
    r"""Key/value metadata to assign to each underlying AWS resource. Specify
    at most 50 pairs containing alphanumerics, spaces, and symbols (.+-=_:@/).
    Keys can be up to 127 Unicode characters. Values can be up to 255 Unicode
    characters.

    Messages:
      AdditionalProperty: An additional property for a TagsValue object.

    Fields:
      additionalProperties: Additional properties of type TagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  iamInstanceProfile = _messages.StringField(1)
  instanceType = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  rootVolume = _messages.MessageField('GoogleCloudGkemulticloudV1AwsVolumeTemplate', 4)
  securityGroupIds = _messages.StringField(5, repeated=True)
  sshConfig = _messages.MessageField('GoogleCloudGkemulticloudV1AwsSshConfig', 6)
  tags = _messages.MessageField('TagsValue', 7)
  taints = _messages.MessageField('GoogleCloudGkemulticloudV1AwsNodeTaint', 8, repeated=True)


class GoogleCloudGkemulticloudV1AwsNodePool(_messages.Message):
  r"""A GKE node pool running on AWS infrastructure.

  Enums:
    StateValueValuesEnum: Output only. The lifecycle state of the node pool.

  Messages:
    AnnotationsValue: Annotations on the node pool. This field has the same
      restrictions as Kubernetes annotations. The total size of all keys and
      values combined is limited to 256k. Key can have 2 segments: prefix
      (optional) and name (required), separated by a slash (/). Prefix must be
      a DNS subdomain. Name must be 63 characters or less, begin and end with
      alphanumerics, with dashes (-), underscores (_), dots (.), and
      alphanumerics between.

  Fields:
    annotations: Annotations on the node pool. This field has the same
      restrictions as Kubernetes annotations. The total size of all keys and
      values combined is limited to 256k. Key can have 2 segments: prefix
      (optional) and name (required), separated by a slash (/). Prefix must be
      a DNS subdomain. Name must be 63 characters or less, begin and end with
      alphanumerics, with dashes (-), underscores (_), dots (.), and
      alphanumerics between.
    autoscaling: Autoscaler configuration for this NodePool.
    config: The node configuration of the pool.
    createTime: Output only. The time at which this node pool was created.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding. Allows clients to
      perform consistent read-modify-writes through optimistic concurrency
      control.
    maxPodsConstraint: The constraint on the maximum number of pods that can
      be run simultaneously on a node in the node pool.
    name: The resource name of this node pool.
    reconciling: Output only. If set, there are currently changes in flight to
      the node pool.
    state: Output only. The lifecycle state of the node pool.
    subnetId: The subnet where the node pool node run.
    uid: Output only. The unique identifier of the node pool.
    updateTime: Output only. The time at which this node pool was last
      updated.
    version: The kubernetes version (e.g. 1.16.9-gke.12) running on this node
      pool.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The lifecycle state of the node pool.

    Values:
      STATE_UNSPECIFIED: Not set.
      PROVISIONING: The PROVISIONING state indicates the node pool is being
        created.
      RUNNING: The RUNNING state indicates the node pool has been created and
        is fully usable.
      RECONCILING: The RECONCILING state indicates that the node pool is being
        reconciled.
      STOPPING: The STOPPING state indicates the node pool is being deleted.
      ERROR: The ERROR state indicates the node pool is in a broken
        unrecoverable state.
      DEGRADED: The DEGRADED state indicates the node pool requires user
        action to restore full functionality.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    RUNNING = 2
    RECONCILING = 3
    STOPPING = 4
    ERROR = 5
    DEGRADED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Annotations on the node pool. This field has the same restrictions as
    Kubernetes annotations. The total size of all keys and values combined is
    limited to 256k. Key can have 2 segments: prefix (optional) and name
    (required), separated by a slash (/). Prefix must be a DNS subdomain. Name
    must be 63 characters or less, begin and end with alphanumerics, with
    dashes (-), underscores (_), dots (.), and alphanumerics between.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  autoscaling = _messages.MessageField('GoogleCloudGkemulticloudV1AwsNodePoolAutoscaling', 2)
  config = _messages.MessageField('GoogleCloudGkemulticloudV1AwsNodeConfig', 3)
  createTime = _messages.StringField(4)
  etag = _messages.StringField(5)
  maxPodsConstraint = _messages.MessageField('GoogleCloudGkemulticloudV1MaxPodsConstraint', 6)
  name = _messages.StringField(7)
  reconciling = _messages.BooleanField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  subnetId = _messages.StringField(10)
  uid = _messages.StringField(11)
  updateTime = _messages.StringField(12)
  version = _messages.StringField(13)


class GoogleCloudGkemulticloudV1AwsNodePoolAutoscaling(_messages.Message):
  r"""AwsNodePoolAutoscaling contains information required by cluster
  autoscaler to adjust the size of the node pool to the current cluster usage.

  Fields:
    maxNodeCount: Maximum number of nodes in the NodePool. Must be >=
      min_node_count.
    minNodeCount: Minimum number of nodes in the NodePool. Must be >= 1 and <=
      max_node_count.
  """

  maxNodeCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minNodeCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudGkemulticloudV1AwsNodeTaint(_messages.Message):
  r"""The taint content for the node taint.

  Enums:
    EffectValueValuesEnum: The taint effect.

  Fields:
    effect: The taint effect.
    key: Key for the taint.
    value: Value for the taint.
  """

  class EffectValueValuesEnum(_messages.Enum):
    r"""The taint effect.

    Values:
      EFFECT_UNSPECIFIED: Not set.
      NO_SCHEDULE: Do not allow new pods to schedule onto the node unless they
        tolerate the taint, but allow all pods submitted to Kubelet without
        going through the scheduler to start, and allow all already-running
        pods to continue running. Enforced by the scheduler.
      PREFER_NO_SCHEDULE: Like TaintEffectNoSchedule, but the scheduler tries
        not to schedule new pods onto the node, rather than prohibiting new
        pods from scheduling onto the node entirely. Enforced by the
        scheduler.
      NO_EXECUTE: Evict any already-running pods that do not tolerate the
        taint. Currently enforced by NodeController.
    """
    EFFECT_UNSPECIFIED = 0
    NO_SCHEDULE = 1
    PREFER_NO_SCHEDULE = 2
    NO_EXECUTE = 3

  effect = _messages.EnumField('EffectValueValuesEnum', 1)
  key = _messages.StringField(2)
  value = _messages.StringField(3)


class GoogleCloudGkemulticloudV1AwsOpenIdConfig(_messages.Message):
  r"""AwsOpenIdConfig is an OIDC discovery document for the cluster. See the
  OpenID Connect Discovery 1.0 specification for details.

  Fields:
    claims_supported: Supported claims.
    grant_types: Supported grant types.
    id_token_signing_alg_values_supported: supported ID Token signing
      Algorithms.
    issuer: OIDC Issuer.
    jwks_uri: JSON Web Key uri.
    response_types_supported: Supported response types.
    subject_types_supported: Supported subject types.
  """

  claims_supported = _messages.StringField(1, repeated=True)
  grant_types = _messages.StringField(2, repeated=True)
  id_token_signing_alg_values_supported = _messages.StringField(3, repeated=True)
  issuer = _messages.StringField(4)
  jwks_uri = _messages.StringField(5)
  response_types_supported = _messages.StringField(6, repeated=True)
  subject_types_supported = _messages.StringField(7, repeated=True)


class GoogleCloudGkemulticloudV1AwsServerConfig(_messages.Message):
  r"""AwsServerConfig is the configuration of GKE cluster on AWS.

  Fields:
    name: The resource name of the config.
    supportedAwsRegions: The list of supported AWS regions.
    validVersions: List of valid Kubernetes versions.
  """

  name = _messages.StringField(1)
  supportedAwsRegions = _messages.StringField(2, repeated=True)
  validVersions = _messages.MessageField('GoogleCloudGkemulticloudV1AwsK8sVersionInfo', 3, repeated=True)


class GoogleCloudGkemulticloudV1AwsServicesAuthentication(_messages.Message):
  r"""Authentication configuration for the management of AWS resources.

  Fields:
    roleArn: The Amazon Resource Name (ARN) of the role to assume when
      managing AWS resources on your account.
    roleSessionName: An identifier for the assumed role session. Optional.
      Defaults to 'multicloud-service-agent'.
  """

  roleArn = _messages.StringField(1)
  roleSessionName = _messages.StringField(2)


class GoogleCloudGkemulticloudV1AwsSshConfig(_messages.Message):
  r"""SSH configuration for AWS resources.

  Fields:
    ec2KeyPair: The name of the EC2 key pair used to login into cluster
      machines.
  """

  ec2KeyPair = _messages.StringField(1)


class GoogleCloudGkemulticloudV1AwsVolumeTemplate(_messages.Message):
  r"""Configuration template for AWS EBS volumes.

  Enums:
    VolumeTypeValueValuesEnum: Type of the EBS volume. Defaults to GP2 volume.

  Fields:
    iops: The number of I/O operations per second (IOPS) to provision for GP3
      volume.
    kmsKeyArn: Immutable. The ARN of the customer managed key (CMK) used to
      encrypt AWS EBS volumes. If not specified, the default Amazon managed
      key will be used.
    sizeGib: The size of the volume, in GiBs.
    volumeType: Type of the EBS volume. Defaults to GP2 volume.
  """

  class VolumeTypeValueValuesEnum(_messages.Enum):
    r"""Type of the EBS volume. Defaults to GP2 volume.

    Values:
      VOLUME_TYPE_UNSPECIFIED: Not set.
      GP2: GP2 (General Purpose SSD volume type).
      GP3: GP3 (General Purpose SSD volume type).
    """
    VOLUME_TYPE_UNSPECIFIED = 0
    GP2 = 1
    GP3 = 2

  iops = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  kmsKeyArn = _messages.StringField(2)
  sizeGib = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  volumeType = _messages.EnumField('VolumeTypeValueValuesEnum', 4)


class GoogleCloudGkemulticloudV1AzureAuthorization(_messages.Message):
  r"""Configuration related to the cluster RBAC settings.

  Fields:
    adminUsers: Users that can perform operations as a cluster admin. A new
      ClusterRoleBinding will be created to grant the cluster-admin
      ClusterRole to the users. At most one user can be specified. For more
      info on RBAC, see https://kubernetes.io/docs/reference/access-authn-
      authz/rbac/#user-facing-roles
  """

  adminUsers = _messages.MessageField('GoogleCloudGkemulticloudV1AzureClusterUser', 1, repeated=True)


class GoogleCloudGkemulticloudV1AzureClient(_messages.Message):
  r"""AzureClient represents the configurations to connect Azure.

  Fields:
    applicationId: The Azure Active Directory application ID.
    certificate: Output only. Output Only. The PEM encoded x509 certificate.
    createTime: Output only. Output Only. The time at which this Azure client
      was created.
    name: The resource name of the Azure client.
    tenantId: The Azure Active Directory Tenant ID.
    uid: Output only. Output Only. The unique identifier of the Azure client.
  """

  applicationId = _messages.StringField(1)
  certificate = _messages.BytesField(2)
  createTime = _messages.StringField(3)
  name = _messages.StringField(4)
  tenantId = _messages.StringField(5)
  uid = _messages.StringField(6)


class GoogleCloudGkemulticloudV1AzureCluster(_messages.Message):
  r"""A GKE cluster running on Azure.

  Enums:
    StateValueValuesEnum: Output only. The current state of the cluster.

  Messages:
    AnnotationsValue: Annotations on the cluster. This field has the same
      restrictions as Kubernetes annotations. The total size of all keys and
      values combined is limited to 256k. Key can have 2 segments: prefix
      (optional) and name (required), separated by a slash (/). Prefix must be
      a DNS subdomain. Name must be 63 characters or less, begin and end with
      alphanumerics, with dashes (-), underscores (_), dots (.), and
      alphanumerics between.

  Fields:
    annotations: Annotations on the cluster. This field has the same
      restrictions as Kubernetes annotations. The total size of all keys and
      values combined is limited to 256k. Key can have 2 segments: prefix
      (optional) and name (required), separated by a slash (/). Prefix must be
      a DNS subdomain. Name must be 63 characters or less, begin and end with
      alphanumerics, with dashes (-), underscores (_), dots (.), and
      alphanumerics between.
    authorization: Configuration related to the cluster RBAC settings.
    azureClient: Name of the azure client that contains the configurations to
      connect Azure. Format:
      projects/{project}/locations/{location}/azureClients/{client-id}
    azureRegion: The Azure region where the cluster runs.
    controlPlane: Configuration related to the cluster control plane.
    createTime: Output only. The time at which this cluster was created.
    description: A human readable description of this cluster.
    endpoint: Output only. The endpoint of the cluster's API server.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding. Allows clients to
      perform consistent read-modify-writes through optimistic concurrency
      control.
    name: The resource name of this cluster.
    networking: Cluster-wide networking configuration.
    reconciling: Output only. If set, there are currently changes in flight to
      the cluster.
    resourceGroupId: The ARM ID of the resource group where the cluster
      resources are deployed. Example: "/subscriptions//resourceGroups/"
    state: Output only. The current state of the cluster.
    uid: Output only. The unique identifier of the cluster.
    updateTime: Output only. The time at which this cluster was last updated.
    workloadIdentityConfig: Output only. Workload Identity settings.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the cluster.

    Values:
      STATE_UNSPECIFIED: Not set.
      PROVISIONING: The PROVISIONING state indicates the cluster is being
        created.
      RUNNING: The RUNNING state indicates the cluster has been created and is
        fully usable.
      RECONCILING: The RECONCILING state indicates that the cluster is being
        reconciled.
      STOPPING: The STOPPING state indicates the cluster is being deleted.
      ERROR: The ERROR state indicates the cluster is in a broken
        unrecoverable state.
      DEGRADED: The DEGRADED state indicates the cluster requires user action
        to restore full functionality.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    RUNNING = 2
    RECONCILING = 3
    STOPPING = 4
    ERROR = 5
    DEGRADED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Annotations on the cluster. This field has the same restrictions as
    Kubernetes annotations. The total size of all keys and values combined is
    limited to 256k. Key can have 2 segments: prefix (optional) and name
    (required), separated by a slash (/). Prefix must be a DNS subdomain. Name
    must be 63 characters or less, begin and end with alphanumerics, with
    dashes (-), underscores (_), dots (.), and alphanumerics between.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  authorization = _messages.MessageField('GoogleCloudGkemulticloudV1AzureAuthorization', 2)
  azureClient = _messages.StringField(3)
  azureRegion = _messages.StringField(4)
  controlPlane = _messages.MessageField('GoogleCloudGkemulticloudV1AzureControlPlane', 5)
  createTime = _messages.StringField(6)
  description = _messages.StringField(7)
  endpoint = _messages.StringField(8)
  etag = _messages.StringField(9)
  name = _messages.StringField(10)
  networking = _messages.MessageField('GoogleCloudGkemulticloudV1AzureClusterNetworking', 11)
  reconciling = _messages.BooleanField(12)
  resourceGroupId = _messages.StringField(13)
  state = _messages.EnumField('StateValueValuesEnum', 14)
  uid = _messages.StringField(15)
  updateTime = _messages.StringField(16)
  workloadIdentityConfig = _messages.MessageField('GoogleCloudGkemulticloudV1WorkloadIdentityConfig', 17)


class GoogleCloudGkemulticloudV1AzureClusterNetworking(_messages.Message):
  r"""ClusterNetworking defines cluster-wide networking configuration.

  Fields:
    podAddressCidrBlocks: All pods in the cluster are assigned an RFC1918 IPv4
      address from these ranges. Only a single range is supported. This field
      cannot be changed after creation.
    serviceAddressCidrBlocks: All services in the cluster are assigned an
      RFC1918 IPv4 address from these ranges. Only a single range is
      supported. This field cannot be changed after creation.
    virtualNetworkId: The ARM ID of the VNet associated with your cluster. All
      components in the cluster (i.e. control plane and node pools) run on a
      single VNet. Example: "/subscriptions/d00494d6-6f3c-4280-bbb2-899e163d1d
      30/resourceGroups/anthos_cluster_gke4ywe/providers/Microsoft.Network/vir
      tualNetworks/gke-vnet-gke4ywe" This field cannot be changed after
      creation.
  """

  podAddressCidrBlocks = _messages.StringField(1, repeated=True)
  serviceAddressCidrBlocks = _messages.StringField(2, repeated=True)
  virtualNetworkId = _messages.StringField(3)


class GoogleCloudGkemulticloudV1AzureClusterUser(_messages.Message):
  r"""Identities of a user-type subject for Azure clusters.

  Fields:
    username: The name of the user, e.g. my-gcp-id@gmail.com.
  """

  username = _messages.StringField(1)


class GoogleCloudGkemulticloudV1AzureControlPlane(_messages.Message):
  r"""AzureControlPlane represents the control plane configurations.

  Messages:
    TagsValue: Tags to apply on the Azure resources owned by the cluster.

  Fields:
    azureServicesAuthentication: Authentication configuration for management
      of Azure resources.
    databaseEncryption: Key information used to encrypt cluster secrets.
    mainVolume: Template for the volume provisioned for etcd storage.
    rootVolume: Template for the volume provisioned for control plane VM
      storage.
    sshConfig: The SSH configuration.
    subnetId: The ARM ID of the subnet where the control plane VMs are
      deployed. Example: "/subscriptions/d00494d6-6f3c-4280-bbb2-899e163d1d30/
      resourceGroups/anthos_cluster_gkeust4/providers/Microsoft.Network/virtua
      lNetworks/gke-vnet-gkeust4/subnets/default"
    tags: Tags to apply on the Azure resources owned by the cluster.
    version: The Kubernetes control plane version (e.g. 1.16.9-gke.12).
    vmSize: The Azure VM size name. Example: Standard_DS2_v2. For available VM
      sizes, see https://docs.microsoft.com/en-us/azure/virtual-machines/vm-
      naming-conventions.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TagsValue(_messages.Message):
    r"""Tags to apply on the Azure resources owned by the cluster.

    Messages:
      AdditionalProperty: An additional property for a TagsValue object.

    Fields:
      additionalProperties: Additional properties of type TagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  azureServicesAuthentication = _messages.MessageField('GoogleCloudGkemulticloudV1AzureServicesAuthentication', 1)
  databaseEncryption = _messages.MessageField('GoogleCloudGkemulticloudV1AzureDatabaseEncryption', 2)
  mainVolume = _messages.MessageField('GoogleCloudGkemulticloudV1AzureDiskTemplate', 3)
  rootVolume = _messages.MessageField('GoogleCloudGkemulticloudV1AzureDiskTemplate', 4)
  sshConfig = _messages.MessageField('GoogleCloudGkemulticloudV1AzureSshConfig', 5)
  subnetId = _messages.StringField(6)
  tags = _messages.MessageField('TagsValue', 7)
  version = _messages.StringField(8)
  vmSize = _messages.StringField(9)


class GoogleCloudGkemulticloudV1AzureDatabaseEncryption(_messages.Message):
  r"""Configuration related to application-layer secrets encryption.

  Fields:
    kmsKeyIdentifier: The URL the of the byo key with its version. Example:
      "https://controlplane-gke1b4k-kv.vault.azure.net/keys/kmskey-
      gke1b4k/6e4e757da9dc4a38b2265fbca3ffb7bd"
    resourceGroupId: The ARM ID the of the resourcegroup containing BYO
      keyvault. Example: "/subscriptions/d00494d6-6f3c-4280-bbb2-899e163d1d30/
      resourceGroups/anthos_cluster_gke1b4k"
  """

  kmsKeyIdentifier = _messages.StringField(1)
  resourceGroupId = _messages.StringField(2)


class GoogleCloudGkemulticloudV1AzureDiskTemplate(_messages.Message):
  r"""Configuration template for Azure Disks.

  Fields:
    sizeGib: The size of the disk, in GiBs.
  """

  sizeGib = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudGkemulticloudV1AzureJsonWebKeys(_messages.Message):
  r"""AzureJsonWebKeys is a valid JSON Web Key Set as specififed in RFC 7517.

  Fields:
    keys: The public component of the keys used by the cluster to sign token
      requests.
  """

  keys = _messages.MessageField('GoogleCloudGkemulticloudV1Jwk', 1, repeated=True)


class GoogleCloudGkemulticloudV1AzureK8sVersionInfo(_messages.Message):
  r"""Kubernetes version information of GKE cluster on Azure.

  Fields:
    version: Kubernetes version name.
  """

  version = _messages.StringField(1)


class GoogleCloudGkemulticloudV1AzureNodeConfig(_messages.Message):
  r"""Parameters that describe the nodes in a cluster.

  Messages:
    TagsValue: Tags to apply on the node pool.

  Fields:
    rootVolume: Template for the volume provisioned for nodepool VMSS storage.
    sshConfig: The SSH configuration.
    tags: Tags to apply on the node pool.
    vmSize: The Azure VM size name. Example: Standard_DS2_v2. For available VM
      sizes, see https://docs.microsoft.com/en-us/azure/virtual-machines/vm-
      naming-conventions.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TagsValue(_messages.Message):
    r"""Tags to apply on the node pool.

    Messages:
      AdditionalProperty: An additional property for a TagsValue object.

    Fields:
      additionalProperties: Additional properties of type TagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  rootVolume = _messages.MessageField('GoogleCloudGkemulticloudV1AzureDiskTemplate', 1)
  sshConfig = _messages.MessageField('GoogleCloudGkemulticloudV1AzureSshConfig', 2)
  tags = _messages.MessageField('TagsValue', 3)
  vmSize = _messages.StringField(4)


class GoogleCloudGkemulticloudV1AzureNodePool(_messages.Message):
  r"""A GKE node pool running on Azure infrastructure.

  Enums:
    StateValueValuesEnum: Output only. The current state of the node pool.

  Messages:
    AnnotationsValue: Annotations on the node pool. This field has the same
      restrictions as Kubernetes annotations. The total size of all keys and
      values combined is limited to 256k. Key can have 2 segments: prefix
      (optional) and name (required), separated by a slash (/). Prefix must be
      a DNS subdomain. Name must be 63 characters or less, begin and end with
      alphanumerics, with dashes (-), underscores (_), dots (.), and
      alphanumerics between.

  Fields:
    annotations: Annotations on the node pool. This field has the same
      restrictions as Kubernetes annotations. The total size of all keys and
      values combined is limited to 256k. Key can have 2 segments: prefix
      (optional) and name (required), separated by a slash (/). Prefix must be
      a DNS subdomain. Name must be 63 characters or less, begin and end with
      alphanumerics, with dashes (-), underscores (_), dots (.), and
      alphanumerics between.
    autoscaling: Autoscaler configuration for this NodePool.
    config: The node configuration of the pool.
    createTime: Output only. The time at which this node pool was created.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding. Allows clients to
      perform consistent read-modify-writes through optimistic concurrency
      control.
    maxPodsConstraint: The constraint on the maximum number of pods that can
      be run simultaneously on a node in the node pool.
    name: The resource name of this node pool.
    reconciling: Output only. If set, there are currently changes in flight to
      the node pool.
    state: Output only. The current state of the node pool.
    subnetId: The ARM ID of the subnet where the node pool VMs run. Make sure
      it's a subnet under the virtual network in the cluster configuration.
    uid: Output only. The unique identifier of the node pool.
    updateTime: Output only. The time at which this node pool was last
      updated.
    version: The kubernetes version (e.g. 1.16.9-gke.12) running on this node
      pool.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the node pool.

    Values:
      STATE_UNSPECIFIED: Not set.
      PROVISIONING: The PROVISIONING state indicates the node pool is being
        created.
      RUNNING: The RUNNING state indicates the node pool has been created and
        is fully usable.
      RECONCILING: The RECONCILING state indicates that the node pool is being
        reconciled.
      STOPPING: The STOPPING state indicates the node pool is being deleted.
      ERROR: The ERROR state indicates the node pool is in a broken
        unrecoverable state.
      DEGRADED: The DEGRADED state indicates the node pool requires user
        action to restore full functionality.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    RUNNING = 2
    RECONCILING = 3
    STOPPING = 4
    ERROR = 5
    DEGRADED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Annotations on the node pool. This field has the same restrictions as
    Kubernetes annotations. The total size of all keys and values combined is
    limited to 256k. Key can have 2 segments: prefix (optional) and name
    (required), separated by a slash (/). Prefix must be a DNS subdomain. Name
    must be 63 characters or less, begin and end with alphanumerics, with
    dashes (-), underscores (_), dots (.), and alphanumerics between.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  autoscaling = _messages.MessageField('GoogleCloudGkemulticloudV1AzureNodePoolAutoscaling', 2)
  config = _messages.MessageField('GoogleCloudGkemulticloudV1AzureNodeConfig', 3)
  createTime = _messages.StringField(4)
  etag = _messages.StringField(5)
  maxPodsConstraint = _messages.MessageField('GoogleCloudGkemulticloudV1MaxPodsConstraint', 6)
  name = _messages.StringField(7)
  reconciling = _messages.BooleanField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  subnetId = _messages.StringField(10)
  uid = _messages.StringField(11)
  updateTime = _messages.StringField(12)
  version = _messages.StringField(13)


class GoogleCloudGkemulticloudV1AzureNodePoolAutoscaling(_messages.Message):
  r"""AzureNodePoolAutoscaling contains information required by cluster
  autoscaler to adjust the size of the node pool to the current cluster usage.

  Fields:
    maxNodeCount: Maximum number of nodes in the NodePool. Must be >=
      min_node_count.
    minNodeCount: Minimum number of nodes in the NodePool. Must be >= 1 and <=
      max_node_count.
  """

  maxNodeCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minNodeCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudGkemulticloudV1AzureOpenIdConfig(_messages.Message):
  r"""AzureOpenIdConfig is an OIDC discovery document for the cluster. See the
  OpenID Connect Discovery 1.0 specification for details.

  Fields:
    claims_supported: Supported claims.
    grant_types: Supported grant types.
    id_token_signing_alg_values_supported: supported ID Token signing
      Algorithms.
    issuer: OIDC Issuer.
    jwks_uri: JSON Web Key uri.
    response_types_supported: Supported response types.
    subject_types_supported: Supported subject types.
  """

  claims_supported = _messages.StringField(1, repeated=True)
  grant_types = _messages.StringField(2, repeated=True)
  id_token_signing_alg_values_supported = _messages.StringField(3, repeated=True)
  issuer = _messages.StringField(4)
  jwks_uri = _messages.StringField(5)
  response_types_supported = _messages.StringField(6, repeated=True)
  subject_types_supported = _messages.StringField(7, repeated=True)


class GoogleCloudGkemulticloudV1AzureServerConfig(_messages.Message):
  r"""AzureServerConfig is the configuration of GKE cluster on Azure.

  Fields:
    name: The resource name of the config.
    supportedAzureRegions: The list of supported Azure regions.
    validVersions: List of valid Kubernetes versions.
  """

  name = _messages.StringField(1)
  supportedAzureRegions = _messages.StringField(2, repeated=True)
  validVersions = _messages.MessageField('GoogleCloudGkemulticloudV1AzureK8sVersionInfo', 3, repeated=True)


class GoogleCloudGkemulticloudV1AzureServicesAuthentication(_messages.Message):
  r"""Authentication configuration for the management of Azure resources.

  Fields:
    aadApplication: The Azure Active Directory application ID.
    aadApplicationKeypairSecret: The resource name of the Secret in the format
      "projects/*/secrets/*" for the authentication to the Azure Active
      Directory application. The latest SecretVersion is used.
    aadTenant: The Azure Active Directory Tenant ID.
    subscription: The Azure subscription ID.
  """

  aadApplication = _messages.StringField(1)
  aadApplicationKeypairSecret = _messages.StringField(2)
  aadTenant = _messages.StringField(3)
  subscription = _messages.StringField(4)


class GoogleCloudGkemulticloudV1AzureSshConfig(_messages.Message):
  r"""SSH configuration for Azure resources.

  Fields:
    authorizedKey: The SSH public key data for cluster machines. This accepts
      the authorized_keys file format used in OpenSSH according to the sshd(8)
      manual page.
  """

  authorizedKey = _messages.StringField(1)


class GoogleCloudGkemulticloudV1GetAwsClusterAdminKubeconfigResponse(_messages.Message):
  r"""Response message for `AwsClusters.GetAwsClusterAdminKubeconfig` method.

  Fields:
    kubeconfig: The admin kubeconfig. The generated client credentials expire
      after 20 hours.
  """

  kubeconfig = _messages.StringField(1)


class GoogleCloudGkemulticloudV1GetAzureClusterAdminKubeconfigResponse(_messages.Message):
  r"""Response message for `Clusters.GetAzureClusterAdminKubeconfig` method.

  Fields:
    kubeconfig: The admin kubeconfig. The generated client credentials expire
      after 20 hours.
  """

  kubeconfig = _messages.StringField(1)


class GoogleCloudGkemulticloudV1Jwk(_messages.Message):
  r"""Jwk is a JSON Web Key as specified in RFC 7517.

  Fields:
    alg: Algorithm.
    crv: Used for ECDSA keys.
    e: Used for RSA keys.
    kid: Key ID.
    kty: Key Type.
    n: Used for RSA keys.
    use: Permitted uses for the public keys.
    x: Used for ECDSA keys.
    y: Used for ECDSA keys.
  """

  alg = _messages.StringField(1)
  crv = _messages.StringField(2)
  e = _messages.StringField(3)
  kid = _messages.StringField(4)
  kty = _messages.StringField(5)
  n = _messages.StringField(6)
  use = _messages.StringField(7)
  x = _messages.StringField(8)
  y = _messages.StringField(9)


class GoogleCloudGkemulticloudV1ListAwsClustersResponse(_messages.Message):
  r"""Response message for `AwsClusters.ListAwsClusters` method.

  Fields:
    awsClusters: The clusters from the specified parent resource.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  awsClusters = _messages.MessageField('GoogleCloudGkemulticloudV1AwsCluster', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudGkemulticloudV1ListAwsNodePoolsResponse(_messages.Message):
  r"""Response message for `AwsClusters.ListAwsNodePools` method.

  Fields:
    awsNodePools: The node pools from the specified parent resource.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  awsNodePools = _messages.MessageField('GoogleCloudGkemulticloudV1AwsNodePool', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudGkemulticloudV1ListAzureClientsResponse(_messages.Message):
  r"""Response message for `Clusters.ListAzureClients` method.

  Fields:
    azureClients: The Azure clients from the specified parent resource.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  azureClients = _messages.MessageField('GoogleCloudGkemulticloudV1AzureClient', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudGkemulticloudV1ListAzureClustersResponse(_messages.Message):
  r"""Response message for `Clusters.ListAzureClusters` method.

  Fields:
    azureClusters: The clusters from the specified parent resource.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  azureClusters = _messages.MessageField('GoogleCloudGkemulticloudV1AzureCluster', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudGkemulticloudV1ListAzureNodePoolsResponse(_messages.Message):
  r"""Response message for `Clusters.ListAzureNodePools` method.

  Fields:
    azureNodePools: The node pools from the specified parent resource.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  azureNodePools = _messages.MessageField('GoogleCloudGkemulticloudV1AzureNodePool', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudGkemulticloudV1MaxPodsConstraint(_messages.Message):
  r"""Constraints applied to pods.

  Fields:
    maxPodsPerNode: Constraint enforced on the max num of pods per node.
  """

  maxPodsPerNode = _messages.IntegerField(1)


class GoogleCloudGkemulticloudV1WorkloadIdentityConfig(_messages.Message):
  r"""Workload Identity settings.

  Fields:
    identityProvider: The ID of the OIDC Identity Provider (IdP) associated to
      the Workload Identity Pool.
    issuerUri: The OIDC issuer URL for this cluster.
    workloadPool: The Workload Identity Pool associated to the cluster.
  """

  identityProvider = _messages.StringField(1)
  issuerUri = _messages.StringField(2)
  workloadPool = _messages.StringField(3)


class GoogleLongrunningCancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleProtobufEmpty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
