"""Generated message classes for run version v1alpha1.

Deploy and manage user provided container images that scale automatically
based on HTTP traffic.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'run'


class Capabilities(_messages.Message):
  r"""Adds and removes POSIX capabilities from running containers.

  Fields:
    add: Added capabilities +optional
    drop: Removed capabilities +optional
  """

  add = _messages.StringField(1, repeated=True)
  drop = _messages.StringField(2, repeated=True)


class ConfigMapEnvSource(_messages.Message):
  r"""ConfigMapEnvSource selects a ConfigMap to populate the environment
  variables with. The contents of the target ConfigMap's Data field will
  represent the key-value pairs as environment variables.

  Fields:
    localObjectReference: This field should not be used directly as it is
      meant to be inlined directly into the message. Use the "name" field
      instead.
    name: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported The ConfigMap to select from.
    optional: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported Specify whether the ConfigMap must be defined +optional
  """

  localObjectReference = _messages.MessageField('LocalObjectReference', 1)
  name = _messages.StringField(2)
  optional = _messages.BooleanField(3)


class ConfigMapKeySelector(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run on GKE: supported
  Selects a key from a ConfigMap.

  Fields:
    key: Cloud Run fully managed: not supported Cloud Run on GKE: supported
      The key to select.
    localObjectReference: This field should not be used directly as it is
      meant to be inlined directly into the message. Use the "name" field
      instead.
    name: Cloud Run fully managed: not supported Cloud Run on GKE: supported
      The ConfigMap to select from.
    optional: Cloud Run fully managed: not supported Cloud Run on GKE:
      supported Specify whether the ConfigMap or its key must be defined
      +optional
  """

  key = _messages.StringField(1)
  localObjectReference = _messages.MessageField('LocalObjectReference', 2)
  name = _messages.StringField(3)
  optional = _messages.BooleanField(4)


class ConfigMapVolumeSource(_messages.Message):
  r"""Adapts a ConfigMap into a volume. The contents of the target ConfigMap's
  Data field will be presented in a volume as files using the keys in the Data
  field as the file names, unless the items element is populated with specific
  mappings of keys to paths.

  Fields:
    defaultMode: Mode bits to use on created files by default. Must be a value
      between 0 and 0777. Defaults to 0644. Directories within the path are
      not affected by this setting. This might be in conflict with other
      options that affect the file mode, like fsGroup, and the result can be
      other mode bits set.
    items: If unspecified, each key-value pair in the Data field of the
      referenced Secret will be projected into the volume as a file whose name
      is the key and content is the value. If specified, the listed keys will
      be projected into the specified paths, and unlisted keys will not be
      present. If a key is specified which is not present in the Secret, the
      volume setup will error unless it is marked optional.
    name: Name of the config.
    optional: Specify whether the Secret or its keys must be defined.
  """

  defaultMode = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  items = _messages.MessageField('KeyToPath', 2, repeated=True)
  name = _messages.StringField(3)
  optional = _messages.BooleanField(4)


class Container(_messages.Message):
  r"""A single application container. This specifies both the container to
  run, the command to run in the container and the arguments to supply to it.
  Note that additional arguments may be supplied by the system to the
  container at runtime.

  Fields:
    args: Arguments to the entrypoint. The docker image's CMD is used if this
      is not provided. Variable references $(VAR_NAME) are expanded using the
      container's environment. If a variable cannot be resolved, the reference
      in the input string will be unchanged. The $(VAR_NAME) syntax can be
      escaped with a double $$, ie: $$(VAR_NAME). Escaped references will
      never be expanded, regardless of whether the variable exists or not.
      Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-
      data-application/define-command-argument-container/#running-a-command-
      in-a-shell +optional
    command: Entrypoint array. Not executed within a shell. The docker image's
      ENTRYPOINT is used if this is not provided. Variable references
      $(VAR_NAME) are expanded using the container's environment. If a
      variable cannot be resolved, the reference in the input string will be
      unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie:
      $$(VAR_NAME). Escaped references will never be expanded, regardless of
      whether the variable exists or not. Cannot be updated. More info:
      https://kubernetes.io/docs/tasks/inject-data-application/define-command-
      argument-container/#running-a-command-in-a-shell +optional
    env: List of environment variables to set in the container. Cannot be
      updated. +optional
    envFrom: List of sources to populate environment variables in the
      container. The keys defined within a source must be a C_IDENTIFIER. All
      invalid keys will be reported as an event when the container is
      starting. When a key exists in multiple sources, the value associated
      with the last source will take precedence. Values defined by an Env with
      a duplicate key will take precedence. Cannot be updated. +optional
    image: Docker image name. More info:
      https://kubernetes.io/docs/concepts/containers/images
    imagePullPolicy: Image pull policy. One of Always, Never, IfNotPresent.
      Defaults to Always if :latest tag is specified, or IfNotPresent
      otherwise. Cannot be updated. More info:
      https://kubernetes.io/docs/concepts/containers/images#updating-images
      +optional
    lifecycle: Actions that the management system should take in response to
      container lifecycle events. Cannot be updated. +optional
    livenessProbe: Periodic probe of container liveness. Container will be
      restarted if the probe fails. Cannot be updated. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-
      lifecycle#container-probes +optional
    name: Name of the container specified as a DNS_LABEL. Each container must
      have a unique name (DNS_LABEL). Cannot be updated.
    ports: List of ports to expose from the container. Exposing a port here
      gives the system additional information about the network connections a
      container uses, but is primarily informational. Not specifying a port
      here DOES NOT prevent that port from being exposed. Any port which is
      listening on the default "0.0.0.0" address inside a container will be
      accessible from the network. Cannot be updated. +optional
    readinessProbe: Periodic probe of container service readiness. Container
      will be removed from service endpoints if the probe fails. Cannot be
      updated. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-
      lifecycle#container-probes +optional
    resources: Compute Resources required by this container. Cannot be
      updated. More info:
      https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
      +optional
    securityContext: Security options the pod should run with. More info:
      https://kubernetes.io/docs/concepts/policy/security-context/ More info:
      https://kubernetes.io/docs/tasks/configure-pod-container/security-
      context/ +optional
    stdin: Whether this container should allocate a buffer for stdin in the
      container runtime. If this is not set, reads from stdin in the container
      will always result in EOF. Default is false. +optional
    stdinOnce: Whether the container runtime should close the stdin channel
      after it has been opened by a single attach. When stdin is true the
      stdin stream will remain open across multiple attach sessions. If
      stdinOnce is set to true, stdin is opened on container start, is empty
      until the first client attaches to stdin, and then remains open and
      accepts data until the client disconnects, at which time stdin is closed
      and remains closed until the container is restarted. If this flag is
      false, a container processes that reads from stdin will never receive an
      EOF. Default is false +optional
    terminationMessagePath: Optional: Path at which the file to which the
      container's termination message will be written is mounted into the
      container's filesystem. Message written is intended to be brief final
      status, such as an assertion failure message. Will be truncated by the
      node if greater than 4096 bytes. The total message length across all
      containers will be limited to 12kb. Defaults to /dev/termination-log.
      Cannot be updated. +optional
    terminationMessagePolicy: Indicate how the termination message should be
      populated. File will use the contents of terminationMessagePath to
      populate the container status message on both success and failure.
      FallbackToLogsOnError will use the last chunk of container log output if
      the termination message file is empty and the container exited with an
      error. The log output is limited to 2048 bytes or 80 lines, whichever is
      smaller. Defaults to File. Cannot be updated. +optional
    tty: Whether this container should allocate a TTY for itself, also
      requires 'stdin' to be true. Default is false. +optional
    volumeDevices: volumeDevices is the list of block devices to be used by
      the container. This is an alpha feature and may change in the future.
      +optional
    volumeMounts: Pod volumes to mount into the container's filesystem. Cannot
      be updated. +optional
    workingDir: Container's working directory. If not specified, the container
      runtime's default will be used, which might be configured in the
      container image. Cannot be updated. +optional
  """

  args = _messages.StringField(1, repeated=True)
  command = _messages.StringField(2, repeated=True)
  env = _messages.MessageField('EnvVar', 3, repeated=True)
  envFrom = _messages.MessageField('EnvFromSource', 4, repeated=True)
  image = _messages.StringField(5)
  imagePullPolicy = _messages.StringField(6)
  lifecycle = _messages.MessageField('Lifecycle', 7)
  livenessProbe = _messages.MessageField('Probe', 8)
  name = _messages.StringField(9)
  ports = _messages.MessageField('ContainerPort', 10, repeated=True)
  readinessProbe = _messages.MessageField('Probe', 11)
  resources = _messages.MessageField('ResourceRequirements', 12)
  securityContext = _messages.MessageField('SecurityContext', 13)
  stdin = _messages.BooleanField(14)
  stdinOnce = _messages.BooleanField(15)
  terminationMessagePath = _messages.StringField(16)
  terminationMessagePolicy = _messages.StringField(17)
  tty = _messages.BooleanField(18)
  volumeDevices = _messages.MessageField('VolumeDevice', 19, repeated=True)
  volumeMounts = _messages.MessageField('VolumeMount', 20, repeated=True)
  workingDir = _messages.StringField(21)


class ContainerPort(_messages.Message):
  r"""ContainerPort represents a network port in a single container.

  Fields:
    containerPort: Number of port to expose on the pod's IP address. This must
      be a valid port number, 0 < x < 65536.
    hostIP: What host IP to bind the external port to. +optional
    hostPort: Number of port to expose on the host. If specified, this must be
      a valid port number, 0 < x < 65536. If HostNetwork is specified, this
      must match ContainerPort. Most containers do not need this. +optional
    name: If specified, this must be an IANA_SVC_NAME and unique within the
      pod. Each named port in a pod must have a unique name. Name for the port
      that can be referred to by services. +optional
    protocol: Protocol for port. Must be UDP or TCP. Defaults to "TCP".
      +optional
  """

  containerPort = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  hostIP = _messages.StringField(2)
  hostPort = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  name = _messages.StringField(4)
  protocol = _messages.StringField(5)


class DomainMapping(_messages.Message):
  r"""Resource to hold the state and status of a user's domain mapping. NOTE:
  This resource is currently in Beta.

  Fields:
    apiVersion: The API version for this call such as
      "domains.cloudrun.com/v1alpha1".
    kind: The kind of resource, in this case "DomainMapping".
    metadata: Metadata associated with this BuildTemplate.
    spec: The spec for this DomainMapping.
    status: The current status of the DomainMapping.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('DomainMappingSpec', 4)
  status = _messages.MessageField('DomainMappingStatus', 5)


class DomainMappingCondition(_messages.Message):
  r"""DomainMappingCondition contains state information for a DomainMapping.

  Fields:
    lastTransitionTime: Last time the condition transitioned from one status
      to another. +optional
    message: Human readable message indicating details about the current
      status. +optional
    reason: One-word CamelCase reason for the condition's current status.
      +optional
    severity: How to interpret failures of this condition, one of Error,
      Warning, Info +optional
    status: Status of the condition, one of True, False, Unknown.
    type: Type of domain mapping condition.
  """

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  severity = _messages.StringField(4)
  status = _messages.StringField(5)
  type = _messages.StringField(6)


class DomainMappingSpec(_messages.Message):
  r"""The desired state of the Domain Mapping.

  Enums:
    CertificateModeValueValuesEnum: The mode of the certificate.

  Fields:
    certificateMode: The mode of the certificate.
    forceOverride: If set, the mapping will override any mapping set before
      this spec was set. It is recommended that the user leaves this empty to
      receive an error warning about a potential conflict and only set it once
      the respective UI has given such a warning.
    routeName: The name of the Knative Route that this DomainMapping applies
      to. The route must exist.
  """

  class CertificateModeValueValuesEnum(_messages.Enum):
    r"""The mode of the certificate.

    Values:
      CERTIFICATE_MODE_UNSPECIFIED: <no description>
      NONE: Do not provision an HTTPS certificate.
      AUTOMATIC: Automatically provisions an HTTPS certificate via GoogleCA or
        LetsEncrypt.
    """
    CERTIFICATE_MODE_UNSPECIFIED = 0
    NONE = 1
    AUTOMATIC = 2

  certificateMode = _messages.EnumField('CertificateModeValueValuesEnum', 1)
  forceOverride = _messages.BooleanField(2)
  routeName = _messages.StringField(3)


class DomainMappingStatus(_messages.Message):
  r"""The current state of the Domain Mapping.

  Fields:
    conditions: Array of observed DomainMappingConditions, indicating the
      current state of the DomainMapping.
    mappedRouteName: The name of the route that the mapping currently points
      to.
    observedGeneration: ObservedGeneration is the 'Generation' of the
      DomainMapping that was last processed by the controller. Clients polling
      for completed reconciliation should poll until observedGeneration =
      metadata.generation and the Ready condition's status is True or False.
    resourceRecords: The resource records required to configure this domain
      mapping. These records must be added to the domain's DNS configuration
      in order to serve the application via this domain mapping.
    url: Cloud Run fully managed: not supported Cloud Run on GKE: supported
      Holds the URL that will serve the traffic of the DomainMapping.
      +optional
  """

  conditions = _messages.MessageField('DomainMappingCondition', 1, repeated=True)
  mappedRouteName = _messages.StringField(2)
  observedGeneration = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  resourceRecords = _messages.MessageField('ResourceRecord', 4, repeated=True)
  url = _messages.StringField(5)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class EnvFromSource(_messages.Message):
  r"""EnvFromSource represents the source of a set of ConfigMaps

  Fields:
    configMapRef: The ConfigMap to select from +optional
    prefix: An optional identifier to prepend to each key in the ConfigMap.
      Must be a C_IDENTIFIER. +optional
    secretRef: The Secret to select from +optional
  """

  configMapRef = _messages.MessageField('ConfigMapEnvSource', 1)
  prefix = _messages.StringField(2)
  secretRef = _messages.MessageField('SecretEnvSource', 3)


class EnvVar(_messages.Message):
  r"""EnvVar represents an environment variable present in a Container.

  Fields:
    name: Name of the environment variable. Must be a C_IDENTIFIER.
    value: Variable references $(VAR_NAME) are expanded using the previous
      defined environment variables in the container and any route environment
      variables. If a variable cannot be resolved, the reference in the input
      string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
      double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
      regardless of whether the variable exists or not. Defaults to "".
      +optional
    valueFrom: Cloud Run fully managed: supported Source for the environment
      variable's value. Only supports secret_key_ref. Cloud Run for Anthos:
      supported Source for the environment variable's value. Cannot be used if
      value is not empty. +optional
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)
  valueFrom = _messages.MessageField('EnvVarSource', 3)


class EnvVarSource(_messages.Message):
  r"""Cloud Run fully managed: not supported Cloud Run on GKE: supported
  EnvVarSource represents a source for the value of an EnvVar.

  Fields:
    configMapKeyRef: Cloud Run fully managed: not supported Cloud Run on GKE:
      supported Selects a key of a ConfigMap. +optional
    secretKeyRef: Cloud Run fully managed: supported. Selects a key (version)
      of a secret in Secret Manager. Cloud Run for Anthos: supported. Selects
      a key of a secret in the pod's namespace. +optional
  """

  configMapKeyRef = _messages.MessageField('ConfigMapKeySelector', 1)
  secretKeyRef = _messages.MessageField('SecretKeySelector', 2)


class ExecAction(_messages.Message):
  r"""ExecAction describes a "run in container" action.

  Fields:
    command: Command is the command line to execute inside the container, the
      working directory for the command is root ('/') in the container's
      filesystem. The command is simply exec'd, it is not run inside a shell,
      so traditional shell instructions ('|', etc) won't work. To use a shell,
      you need to explicitly call out to that shell. Exit status of 0 is
      treated as live/healthy and non-zero is unhealthy. +optional
  """

  command = _messages.StringField(1, repeated=True)


class HTTPGetAction(_messages.Message):
  r"""HTTPGetAction describes an action based on HTTP Get requests.

  Fields:
    host: Host name to connect to, defaults to the pod IP. You probably want
      to set "Host" in httpHeaders instead. +optional
    httpHeaders: Custom headers to set in the request. HTTP allows repeated
      headers. +optional
    path: Path to access on the HTTP server. +optional
    port: Name or number of the port to access on the container. Number must
      be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
    scheme: Scheme to use for connecting to the host. Defaults to HTTP.
      +optional
  """

  host = _messages.StringField(1)
  httpHeaders = _messages.MessageField('HTTPHeader', 2, repeated=True)
  path = _messages.StringField(3)
  port = _messages.MessageField('IntOrString', 4)
  scheme = _messages.StringField(5)


class HTTPHeader(_messages.Message):
  r"""HTTPHeader describes a custom header to be used in HTTP probes

  Fields:
    name: The header field name
    value: The header field value
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class Handler(_messages.Message):
  r"""Handler defines a specific action that should be taken

  Fields:
    exec_: One and only one of the following should be specified. Exec
      specifies the action to take. +optional
    httpGet: HTTPGet specifies the http request to perform. +optional
    tcpSocket: TCPSocket specifies an action involving a TCP port. TCP hooks
      not yet supported
  """

  exec_ = _messages.MessageField('ExecAction', 1)
  httpGet = _messages.MessageField('HTTPGetAction', 2)
  tcpSocket = _messages.MessageField('TCPSocketAction', 3)


class InstanceSpec(_messages.Message):
  r"""InstanceSpec is a description of an instance.

  Fields:
    activeDeadlineSeconds: Optional. Optional duration in seconds the instance
      may be active relative to StartTime before the system will actively try
      to mark it failed and kill associated containers. If set to zero, the
      system will never attempt to kill an instance based on time. Otherwise,
      value must be a positive integer. +optional
    containers: Optional. List of containers belonging to the instance. We
      disallow a number of fields on this Container. Only a single container
      may be provided.
    restartPolicy: Optional. Restart policy for all containers within the
      instance. Allowed values are: - OnFailure: Instances will always be
      restarted on failure if the backoffLimit has not been reached. - Never:
      Instances are never restarted and all failures are permanent. Cannot be
      used if backoffLimit is set. +optional
    serviceAccountName: Optional. Email address of the IAM service account
      associated with the instance of a Job. The service account represents
      the identity of the running instance, and determines what permissions
      the instance has. If not provided, the instance will use the project's
      default service account. +optional
    terminationGracePeriodSeconds: Optional. Optional duration in seconds the
      instance needs to terminate gracefully. Value must be non-negative
      integer. The value zero indicates delete immediately. The grace period
      is the duration in seconds after the processes running in the instance
      are sent a termination signal and the time when the processes are
      forcibly halted with a kill signal. Set this value longer than the
      expected cleanup time for your process. +optional
    volumes: Optional. List of volumes that can be mounted by containers
      belonging to the instance. More info:
      https://kubernetes.io/docs/concepts/storage/volumes +optional
  """

  activeDeadlineSeconds = _messages.IntegerField(1)
  containers = _messages.MessageField('Container', 2, repeated=True)
  restartPolicy = _messages.StringField(3)
  serviceAccountName = _messages.StringField(4)
  terminationGracePeriodSeconds = _messages.IntegerField(5)
  volumes = _messages.MessageField('Volume', 6, repeated=True)


class InstanceStatus(_messages.Message):
  r"""Instance represents the status of an instance of a Job.

  Fields:
    completionTime: Optional. Represents time when the instance was completed.
      It is not guaranteed to be set in happens-before order across separate
      operations. It is represented in RFC3339 form and is in UTC. +optional
    failed: Optional. The number of times this instance exited with code > 0;
      +optional
    index: Required. Index of the instance, unique per Job, and beginning at
      0.
    lastExitCode: Optional. Last exit code seen for this instance. +optional
    restarted: Optional. The number of times this instance was restarted.
      Instances are restarted according the restartPolicy configured in the
      Job template. +optional
    startTime: Optional. Represents time when the instance was created by the
      job controller. It is not guaranteed to be set in happens-before order
      across separate operations. It is represented in RFC3339 form and is in
      UTC. +optional
    succeeded: Optional. The number of times this instance exited with code ==
      0. +optional
  """

  completionTime = _messages.StringField(1)
  failed = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  index = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  lastExitCode = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  restarted = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(6)
  succeeded = _messages.IntegerField(7, variant=_messages.Variant.INT32)


class InstanceTemplateSpec(_messages.Message):
  r"""InstanceTemplateSpec describes the data an instance should have when
  created from a template.

  Fields:
    spec: Optional. Specification of the desired behavior of the instance.
      More info: https://git.k8s.io/community/contributors/devel/sig-
      architecture/api-conventions.md#spec-and-status +optional
  """

  spec = _messages.MessageField('InstanceSpec', 1)


class IntOrString(_messages.Message):
  r"""IntOrString is a type that can hold an int32 or a string. When used in
  JSON or YAML marshalling and unmarshalling, it produces or consumes the
  inner type. This allows you to have, for example, a JSON field that can
  accept a name or number.

  Fields:
    intVal: The int value.
    strVal: The string value.
    type: The type of the value.
  """

  intVal = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  strVal = _messages.StringField(2)
  type = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class Job(_messages.Message):
  r"""Job represents the configuration of a single job. A job an immutable
  resource that references a container image which is run to completion.

  Fields:
    apiVersion: Optional. APIVersion defines the versioned schema of this
      representation of an object. Servers should convert recognized schemas
      to the latest internal value, and may reject unrecognized values. More
      info: https://git.k8s.io/community/contributors/devel/sig-
      architecture/api-conventions.md#resources +optional
    kind: Optional. Kind is a string value representing the REST resource this
      object represents. Servers may infer this from the endpoint the client
      submits requests to. Cannot be updated. In CamelCase. More info:
      https://git.k8s.io/community/contributors/devel/sig-architecture/api-
      conventions.md#types-kinds +optional
    metadata: Optional. Standard object's metadata. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata +optional
    spec: Optional. Specification of the desired behavior of a job. More info:
      https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-
      and-status +optional
    status: Optional. Current status of a job. More info:
      https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-
      and-status +optional
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  metadata = _messages.MessageField('ObjectMeta', 3)
  spec = _messages.MessageField('JobSpec', 4)
  status = _messages.MessageField('JobStatus', 5)


class JobCondition(_messages.Message):
  r"""JobCondition defines a readiness condition for a Revision.

  Fields:
    lastTransitionTime: Optional. Last time the condition transitioned from
      one status to another.
    message: Optional. Human readable message indicating details about the
      current status.
    reason: Optional. One-word CamelCase reason for the condition's last
      transition.
    severity: Optional. How to interpret failures of this condition, one of
      Error, Warning, Info
    status: Required. Status of the condition, one of True, False, Unknown.
    type: Required. Type is used to communicate the status of the
      reconciliation process. See also: https://github.com/knative/serving/blo
      b/master/docs/spec/errors.md#error-conditions-and-reporting Types
      include: * "Completed": True when the Job has successfully completed. *
      "Started": True when the Job has successfully started running. *
      "ResourcesAvailable": True when underlying resources have been
      provisioned.
  """

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  severity = _messages.StringField(4)
  status = _messages.StringField(5)
  type = _messages.StringField(6)


class JobSpec(_messages.Message):
  r"""JobSpec describes how the job execution will look like.

  Fields:
    activeDeadlineSeconds: Optional. Not supported. Specifies the duration in
      seconds relative to the startTime that the job may be active before the
      system tries to terminate it. If set to zero, the system will never
      attempt to terminate the job based on time. Otherwise, the value must be
      positive integer. +optional
    backoffLimit: Optional. Specifies the number of retries per instance,
      before marking this job failed. If set to zero, instances will never
      retry on failure. +optional
    completions: Optional. Specifies the desired number of successfully
      finished instances the job should be run with. Setting to 1 means that
      parallelism is limited to 1 and the success of that instance signals the
      success of the job. More info:
      https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-
      completion/ +optional
    parallelism: Optional. Specifies the maximum desired number of instances
      the job should run at any given time. Must be <= completions. The actual
      number of instances running in steady state will be less than this
      number when ((.spec.completions - .status.successful) <
      .spec.parallelism), i.e. when the work left to do is less than max
      parallelism. More info:
      https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-
      completion/ +optional
    template: Optional. Describes the instance that will be created when
      executing a job.
    ttlSecondsAfterFinished: Optional. Not supported. ttlSecondsAfterFinished
      limits the lifetime of a Job that has finished execution (either
      Complete or Failed). If this field is set, ttlSecondsAfterFinished after
      the Job finishes, it is eligible to be automatically deleted. When the
      Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be
      honored. If this field is set to zero, the Job won't be automatically
      deleted. +optional
  """

  activeDeadlineSeconds = _messages.IntegerField(1)
  backoffLimit = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  completions = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  parallelism = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  template = _messages.MessageField('InstanceTemplateSpec', 5)
  ttlSecondsAfterFinished = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class JobStatus(_messages.Message):
  r"""JobStatus represents the current state of a Job.

  Fields:
    active: Optional. The number of actively running instances. +optional
    completionTime: Optional. Represents time when the job was completed. It
      is not guaranteed to be set in happens-before order across separate
      operations. It is represented in RFC3339 form and is in UTC. +optional
    conditions: Optional. The latest available observations of a job's current
      state. More info:
      https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-
      completion/ +optional
    failed: Optional. The number of instances which reached phase Failed.
      +optional
    imageDigest: Optional. ImageDigest holds the resolved digest for the image
      specified within .Spec.Template.Spec.Container.Image. The digest is
      resolved during the creation of the Job. This field holds the digest
      value regardless of whether a tag or digest was originally specified in
      the Container object.
    instances: Optional. Status of completed, failed, and running instances.
      +optional
    observedGeneration: Optional. The 'generation' of the job that was last
      processed by the controller.
    startTime: Optional. Represents time when the job was acknowledged by the
      job controller. It is not guaranteed to be set in happens-before order
      across separate operations. It is represented in RFC3339 form and is in
      UTC. +optional
    succeeded: Optional. The number of instances which reached phase
      Succeeded. +optional
  """

  active = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  completionTime = _messages.StringField(2)
  conditions = _messages.MessageField('JobCondition', 3, repeated=True)
  failed = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  imageDigest = _messages.StringField(5)
  instances = _messages.MessageField('InstanceStatus', 6, repeated=True)
  observedGeneration = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(8)
  succeeded = _messages.IntegerField(9, variant=_messages.Variant.INT32)


class KeyToPath(_messages.Message):
  r"""Maps a string key to a path within a volume.

  Fields:
    key: Cloud Run fully managed: supported The Cloud Secret Manager secret
      version. Can be 'latest' for the latest value or an integer for a
      specific version. Cloud Run for Anthos: supported The key to project.
    mode: Mode bits to use on this file, must be a value between 0 and 0777.
      If not specified, the volume defaultMode will be used. This might be in
      conflict with other options that affect the file mode, like fsGroup, and
      the result can be other mode bits set. +optional
    path: Cloud Run fully managed: supported Cloud Run for Anthos: supported
      The relative path of the file to map the key to. May not be an absolute
      path. May not contain the path element '..'. May not start with the
      string '..'.
  """

  key = _messages.StringField(1)
  mode = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  path = _messages.StringField(3)


class Lifecycle(_messages.Message):
  r"""Lifecycle describes actions that the management system should take in
  response to container lifecycle events. For the PostStart and PreStop
  lifecycle handlers, management of the container blocks until the action is
  complete, unless the container process fails, in which case the handler is
  aborted.

  Fields:
    postStart: PostStart is called immediately after a container is created.
      If the handler fails, the container is terminated and restarted
      according to its restart policy. Other management of the container
      blocks until the hook completes. More info:
      https://kubernetes.io/docs/concepts/containers/container-lifecycle-
      hooks/#container-hooks +optional
    preStop: PreStop is called immediately before a container is terminated.
      The container is terminated after the handler completes. The reason for
      termination is passed to the handler. Regardless of the outcome of the
      handler, the container is eventually terminated. Other management of the
      container blocks until the hook completes. More info:
      https://kubernetes.io/docs/concepts/containers/container-lifecycle-
      hooks/#container-hooks +optional
  """

  postStart = _messages.MessageField('Handler', 1)
  preStop = _messages.MessageField('Handler', 2)


class ListDomainMappingsResponse(_messages.Message):
  r"""ListDomainMappingsResponse is a list of DomainMapping resources.

  Fields:
    apiVersion: The API version for this call such as
      "domains.cloudrun.com/v1alpha1".
    items: List of DomainMappings.
    kind: The kind of this resource, in this case "DomainMappingList".
    metadata: Metadata associated with this DomainMapping list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('DomainMapping', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class ListJobsResponse(_messages.Message):
  r"""ListJobsResponse is a list of Jobs resources.

  Fields:
    apiVersion: The API version for this call such as
      "run.googleapis.com/v1alpha1".
    items: List of Jobs.
    kind: The kind of this resource, in this case "JobsList".
    metadata: Metadata associated with this jobs list.
    nextPageToken: This field is equivalent to the metadata.continue field and
      is provided as a convenience for compatibility with
      https://google.aip.dev/158. The value is opaque and may be used to issue
      another request to the endpoint that served this list to retrieve the
      next set of available objects. Continuing a list may not be possible if
      the server configuration has changed or more than a few minutes have
      passed. The metadata.resourceVersion field returned when using this
      field will be identical to the value in the first response.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('Job', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  nextPageToken = _messages.StringField(5)
  unreachable = _messages.StringField(6, repeated=True)


class ListMeta(_messages.Message):
  r"""ListMeta describes metadata that synthetic resources must have,
  including lists and various status objects. A resource may have only one of
  {ObjectMeta, ListMeta}.

  Fields:
    continue_: continue may be set if the user set a limit on the number of
      items returned, and indicates that the server has more data available.
      The value is opaque and may be used to issue another request to the
      endpoint that served this list to retrieve the next set of available
      objects. Continuing a list may not be possible if the server
      configuration has changed or more than a few minutes have passed. The
      resourceVersion field returned when using this continue value will be
      identical to the value in the first response.
    resourceVersion: String that identifies the server's internal version of
      this object that can be used by clients to determine when objects have
      changed. Value must be treated as opaque by clients and passed
      unmodified back to the server. Populated by the system. Read-only. More
      info: https://git.k8s.io/community/contributors/devel/api-
      conventions.md#concurrency-control-and-consistency +optional
    selfLink: SelfLink is a URL representing this object. Populated by the
      system. Read-only. +optional
  """

  continue_ = _messages.StringField(1)
  resourceVersion = _messages.StringField(2)
  selfLink = _messages.StringField(3)


class LocalObjectReference(_messages.Message):
  r"""LocalObjectReference contains enough information to let you locate the
  referenced object inside the same namespace.

  Fields:
    name: Name of the referent. More info:
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/names/#names
  """

  name = _messages.StringField(1)


class ObjectMeta(_messages.Message):
  r"""ObjectMeta is metadata that all persisted resources must have, which
  includes all objects users must create.

  Messages:
    AnnotationsValue: Annotations is an unstructured key value map stored with
      a resource that may be set by external tools to store and retrieve
      arbitrary metadata. They are not queryable and should be preserved when
      modifying objects. More info: http://kubernetes.io/docs/user-
      guide/annotations +optional
    LabelsValue: Map of string keys and values that can be used to organize
      and categorize (scope and select) objects. May match selectors of
      replication controllers and routes. More info:
      http://kubernetes.io/docs/user-guide/labels +optional

  Fields:
    annotations: Annotations is an unstructured key value map stored with a
      resource that may be set by external tools to store and retrieve
      arbitrary metadata. They are not queryable and should be preserved when
      modifying objects. More info: http://kubernetes.io/docs/user-
      guide/annotations +optional
    clusterName: Not currently supported by Cloud Run. The name of the cluster
      which the object belongs to. This is used to distinguish resources with
      same name and namespace in different clusters. This field is not set
      anywhere right now and apiserver is going to ignore it if set in create
      or update request. +optional
    creationTimestamp: CreationTimestamp is a timestamp representing the
      server time when this object was created. It is not guaranteed to be set
      in happens-before order across separate operations. Clients may not set
      this value. It is represented in RFC3339 form and is in UTC. Populated
      by the system. Read-only. Null for lists. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata +optional
    deletionGracePeriodSeconds: Not currently supported by Cloud Run. Number
      of seconds allowed for this object to gracefully terminate before it
      will be removed from the system. Only set when deletionTimestamp is also
      set. May only be shortened. Read-only. +optional
    deletionTimestamp: DeletionTimestamp is RFC 3339 date and time at which
      this resource will be deleted. This field is set by the server when a
      graceful deletion is requested by the user, and is not directly settable
      by a client. The resource is expected to be deleted (no longer visible
      from resource lists, and not reachable by name) after the time in this
      field, once the finalizers list is empty. As long as the finalizers list
      contains items, deletion is blocked. Once the deletionTimestamp is set,
      this value may not be unset or be set further into the future, although
      it may be shortened or the resource may be deleted prior to this time.
      For example, a user may request that a pod is deleted in 30 seconds. The
      Kubelet will react by sending a graceful termination signal to the
      containers in the pod. After that 30 seconds, the Kubelet will send a
      hard termination signal (SIGKILL) to the container and after cleanup,
      remove the pod from the API. In the presence of network partitions, this
      object may still exist after this timestamp, until an administrator or
      automated process can determine the resource is fully terminated. If not
      set, graceful deletion of the object has not been requested. Populated
      by the system when a graceful deletion is requested. Read-only. More
      info: https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata +optional
    finalizers: Not currently supported by Cloud Run. Must be empty before the
      object is deleted from the registry. Each entry is an identifier for the
      responsible component that will remove the entry from the list. If the
      deletionTimestamp of the object is non-nil, entries in this list can
      only be removed. +optional +patchStrategy=merge
    generateName: Not currently supported by Cloud Run. GenerateName is an
      optional prefix, used by the server, to generate a unique name ONLY IF
      the Name field has not been provided. If this field is used, the name
      returned to the client will be different than the name passed. This
      value will also be combined with a unique suffix. The provided value has
      the same validation rules as the Name field, and may be truncated by the
      length of the suffix required to make the value unique on the server. If
      this field is specified and the generated name exists, the server will
      NOT return a 409 - instead, it will either return 201 Created or 500
      with Reason ServerTimeout indicating a unique name could not be found in
      the time allotted, and the client should retry (optionally after the
      time indicated in the Retry-After header). Applied only if Name is not
      specified. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#idempotency +optional string generateName = 2;
    generation: A sequence number representing a specific generation of the
      desired state. Populated by the system. Read-only. +optional
    labels: Map of string keys and values that can be used to organize and
      categorize (scope and select) objects. May match selectors of
      replication controllers and routes. More info:
      http://kubernetes.io/docs/user-guide/labels +optional
    name: Name must be unique within a namespace, within a Cloud Run region.
      Is required when creating resources, although some resources may allow a
      client to request the generation of an appropriate name automatically.
      Name is primarily intended for creation idempotence and configuration
      definition. Cannot be updated. More info:
      http://kubernetes.io/docs/user-guide/identifiers#names +optional
    namespace: Namespace defines the space within each name must be unique,
      within a Cloud Run region. In Cloud Run the namespace must be equal to
      either the project ID or project number.
    ownerReferences: List of objects that own this object. If ALL objects in
      the list have been deleted, this object will be garbage collected.
      +optional
    resourceVersion: An opaque value that represents the internal version of
      this object that can be used by clients to determine when objects have
      changed. May be used for optimistic concurrency, change detection, and
      the watch operation on a resource or set of resources. Clients must
      treat these values as opaque and passed unmodified back to the server.
      They may only be valid for a particular resource or set of resources.
      Populated by the system. Read-only. Value must be treated as opaque by
      clients and . More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#concurrency-control-and-consistency +optional
    selfLink: SelfLink is a URL representing this object. Populated by the
      system. Read-only. +optional string selfLink = 4;
    uid: UID is the unique in time and space value for this object. It is
      typically generated by the server on successful creation of a resource
      and is not allowed to change on PUT operations. Populated by the system.
      Read-only. More info: http://kubernetes.io/docs/user-
      guide/identifiers#uids +optional
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Annotations is an unstructured key value map stored with a resource
    that may be set by external tools to store and retrieve arbitrary
    metadata. They are not queryable and should be preserved when modifying
    objects. More info: http://kubernetes.io/docs/user-guide/annotations
    +optional

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Map of string keys and values that can be used to organize and
    categorize (scope and select) objects. May match selectors of replication
    controllers and routes. More info: http://kubernetes.io/docs/user-
    guide/labels +optional

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  clusterName = _messages.StringField(2)
  creationTimestamp = _messages.StringField(3)
  deletionGracePeriodSeconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  deletionTimestamp = _messages.StringField(5)
  finalizers = _messages.StringField(6, repeated=True)
  generateName = _messages.StringField(7)
  generation = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  labels = _messages.MessageField('LabelsValue', 9)
  name = _messages.StringField(10)
  namespace = _messages.StringField(11)
  ownerReferences = _messages.MessageField('OwnerReference', 12, repeated=True)
  resourceVersion = _messages.StringField(13)
  selfLink = _messages.StringField(14)
  uid = _messages.StringField(15)


class OwnerReference(_messages.Message):
  r"""OwnerReference contains enough information to let you identify an owning
  object. Currently, an owning object must be in the same namespace, so there
  is no namespace field.

  Fields:
    apiVersion: API version of the referent.
    blockOwnerDeletion: If true, AND if the owner has the "foregroundDeletion"
      finalizer, then the owner cannot be deleted from the key-value store
      until this reference is removed. Defaults to false. To set this field, a
      user needs "delete" permission of the owner, otherwise 422
      (Unprocessable Entity) will be returned. +optional
    controller: If true, this reference points to the managing controller.
      +optional
    kind: Kind of the referent. More info:
      https://git.k8s.io/community/contributors/devel/sig-architecture/api-
      conventions.md#types-kinds
    name: Name of the referent. More info: http://kubernetes.io/docs/user-
      guide/identifiers#names
    uid: UID of the referent. More info: http://kubernetes.io/docs/user-
      guide/identifiers#uids
  """

  apiVersion = _messages.StringField(1)
  blockOwnerDeletion = _messages.BooleanField(2)
  controller = _messages.BooleanField(3)
  kind = _messages.StringField(4)
  name = _messages.StringField(5)
  uid = _messages.StringField(6)


class Probe(_messages.Message):
  r"""Probe describes a health check to be performed against a container to
  determine whether it is alive or ready to receive traffic.

  Fields:
    failureThreshold: Minimum consecutive failures for the probe to be
      considered failed after having succeeded. Defaults to 3. Minimum value
      is 1. +optional
    handler: The action taken to determine the health of a container
    initialDelaySeconds: Number of seconds after the container has started
      before liveness probes are initiated. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-
      lifecycle#container-probes +optional
    periodSeconds: How often (in seconds) to perform the probe. Default to 10
      seconds. Minimum value is 1. +optional
    successThreshold: Minimum consecutive successes for the probe to be
      considered successful after having failed. Defaults to 1. Must be 1 for
      liveness. Minimum value is 1. +optional
    timeoutSeconds: Number of seconds after which the probe times out.
      Defaults to 1 second. Minimum value is 1. More info:
      https://kubernetes.io/docs/concepts/workloads/pods/pod-
      lifecycle#container-probes +optional
  """

  failureThreshold = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  handler = _messages.MessageField('Handler', 2)
  initialDelaySeconds = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  periodSeconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  successThreshold = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  timeoutSeconds = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class Quantity(_messages.Message):
  r"""The view model of a single quantity, e.g. "800 MiB". Corresponds to http
  s://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachi
  nery/pkg/api/resource/generated.proto

  Fields:
    string: Stringified version of the quantity, e.g., "800 MiB".
  """

  string = _messages.StringField(1)


class ResourceRecord(_messages.Message):
  r"""A DNS resource record.

  Enums:
    TypeValueValuesEnum: Resource record type. Example: `AAAA`.

  Fields:
    name: Relative name of the object affected by this record. Only applicable
      for `CNAME` records. Example: 'www'.
    rrdata: Data for this record. Values vary by record type, as defined in
      RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
    type: Resource record type. Example: `AAAA`.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Resource record type. Example: `AAAA`.

    Values:
      RECORD_TYPE_UNSPECIFIED: An unknown resource record.
      A: An A resource record. Data is an IPv4 address.
      AAAA: An AAAA resource record. Data is an IPv6 address.
      CNAME: A CNAME resource record. Data is a domain name to be aliased.
    """
    RECORD_TYPE_UNSPECIFIED = 0
    A = 1
    AAAA = 2
    CNAME = 3

  name = _messages.StringField(1)
  rrdata = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class ResourceRequirements(_messages.Message):
  r"""ResourceRequirements describes the compute resource requirements.

  Messages:
    LimitsValue: Limits describes the maximum amount of compute resources
      allowed. The values of the map is string form of the 'quantity' k8s
      type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k
      8s.io/apimachinery/pkg/api/resource/quantity.go
    LimitsInMapValue: Limits describes the maximum amount of compute resources
      allowed. This is a temporary field created to migrate away from the map
      limits field. This is done to become compliant with k8s style API. This
      field is deprecated in favor of limits field.
    RequestsValue: Requests describes the minimum amount of compute resources
      required. If Requests is omitted for a container, it defaults to Limits
      if that is explicitly specified, otherwise to an implementation-defined
      value. The values of the map is string form of the 'quantity' k8s type:
      https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/
      apimachinery/pkg/api/resource/quantity.go
    RequestsInMapValue: Requests describes the minimum amount of compute
      resources required. If Requests is omitted for a container, it defaults
      to Limits if that is explicitly specified, otherwise to an
      implementation-defined value. This is a temporary field created to
      migrate away from the map requests field. This is done to become
      compliant with k8s style API. This field is deprecated in favor of
      requests field.

  Fields:
    limits: Limits describes the maximum amount of compute resources allowed.
      The values of the map is string form of the 'quantity' k8s type: https:/
      /github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimach
      inery/pkg/api/resource/quantity.go
    limitsInMap: Limits describes the maximum amount of compute resources
      allowed. This is a temporary field created to migrate away from the map
      limits field. This is done to become compliant with k8s style API. This
      field is deprecated in favor of limits field.
    requests: Requests describes the minimum amount of compute resources
      required. If Requests is omitted for a container, it defaults to Limits
      if that is explicitly specified, otherwise to an implementation-defined
      value. The values of the map is string form of the 'quantity' k8s type:
      https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/
      apimachinery/pkg/api/resource/quantity.go
    requestsInMap: Requests describes the minimum amount of compute resources
      required. If Requests is omitted for a container, it defaults to Limits
      if that is explicitly specified, otherwise to an implementation-defined
      value. This is a temporary field created to migrate away from the map
      requests field. This is done to become compliant with k8s style API.
      This field is deprecated in favor of requests field.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LimitsInMapValue(_messages.Message):
    r"""Limits describes the maximum amount of compute resources allowed. This
    is a temporary field created to migrate away from the map limits field.
    This is done to become compliant with k8s style API. This field is
    deprecated in favor of limits field.

    Messages:
      AdditionalProperty: An additional property for a LimitsInMapValue
        object.

    Fields:
      additionalProperties: Additional properties of type LimitsInMapValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LimitsInMapValue object.

      Fields:
        key: Name of the additional property.
        value: A Quantity attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Quantity', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LimitsValue(_messages.Message):
    r"""Limits describes the maximum amount of compute resources allowed. The
    values of the map is string form of the 'quantity' k8s type: https://githu
    b.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pk
    g/api/resource/quantity.go

    Messages:
      AdditionalProperty: An additional property for a LimitsValue object.

    Fields:
      additionalProperties: Additional properties of type LimitsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LimitsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RequestsInMapValue(_messages.Message):
    r"""Requests describes the minimum amount of compute resources required.
    If Requests is omitted for a container, it defaults to Limits if that is
    explicitly specified, otherwise to an implementation-defined value. This
    is a temporary field created to migrate away from the map requests field.
    This is done to become compliant with k8s style API. This field is
    deprecated in favor of requests field.

    Messages:
      AdditionalProperty: An additional property for a RequestsInMapValue
        object.

    Fields:
      additionalProperties: Additional properties of type RequestsInMapValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RequestsInMapValue object.

      Fields:
        key: Name of the additional property.
        value: A Quantity attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Quantity', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RequestsValue(_messages.Message):
    r"""Requests describes the minimum amount of compute resources required.
    If Requests is omitted for a container, it defaults to Limits if that is
    explicitly specified, otherwise to an implementation-defined value. The
    values of the map is string form of the 'quantity' k8s type: https://githu
    b.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pk
    g/api/resource/quantity.go

    Messages:
      AdditionalProperty: An additional property for a RequestsValue object.

    Fields:
      additionalProperties: Additional properties of type RequestsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RequestsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  limits = _messages.MessageField('LimitsValue', 1)
  limitsInMap = _messages.MessageField('LimitsInMapValue', 2)
  requests = _messages.MessageField('RequestsValue', 3)
  requestsInMap = _messages.MessageField('RequestsInMapValue', 4)


class RunNamespacesDomainmappingsCreateRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsCreateRequest object.

  Fields:
    domainMapping: A DomainMapping resource to be passed as the request body.
    parent: The project ID or project number in which this domain mapping
      should be created.
  """

  domainMapping = _messages.MessageField('DomainMapping', 1)
  parent = _messages.StringField(2, required=True)


class RunNamespacesDomainmappingsDeleteRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the domain mapping being deleted. If needed, replace
      {namespace_id} with the project ID.
    orphanDependents: Deprecated. Specifies the cascade behavior on delete.
      Cloud Run only supports cascading behavior, so this must be false. This
      attribute is deprecated, and is now replaced with PropagationPolicy See
      https://github.com/kubernetes/kubernetes/issues/46659 for more info.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  orphanDependents = _messages.BooleanField(4)
  propagationPolicy = _messages.StringField(5)


class RunNamespacesDomainmappingsGetRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsGetRequest object.

  Fields:
    name: The name of the domain mapping being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesDomainmappingsListRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the domain mappings
      should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunNamespacesDomainmappingsReplaceDomainMappingRequest(_messages.Message):
  r"""A RunNamespacesDomainmappingsReplaceDomainMappingRequest object.

  Fields:
    domainMapping: A DomainMapping resource to be passed as the request body.
    name: The name of the domain mapping being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  domainMapping = _messages.MessageField('DomainMapping', 1)
  name = _messages.StringField(2, required=True)


class RunNamespacesJobsCreateRequest(_messages.Message):
  r"""A RunNamespacesJobsCreateRequest object.

  Fields:
    job: A Job resource to be passed as the request body.
    parent: Required. The namespace in which the job should be created.
      Replace {namespace_id} with the project ID or number.
  """

  job = _messages.MessageField('Job', 1)
  parent = _messages.StringField(2, required=True)


class RunNamespacesJobsDeleteRequest(_messages.Message):
  r"""A RunNamespacesJobsDeleteRequest object.

  Fields:
    apiVersion: Optional. Cloud Run currently ignores this parameter.
    kind: Optional. Cloud Run currently ignores this parameter.
    name: Required. The name of the job to delete. For Cloud Run (fully
      managed), replace {namespace_id} with the project ID or number.
    propagationPolicy: Optional. Specifies the propagation policy of delete.
      Cloud Run currently ignores this setting, and deletes in the background.
      Please see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class RunNamespacesJobsGetRequest(_messages.Message):
  r"""A RunNamespacesJobsGetRequest object.

  Fields:
    name: Required. The name of the job to retrieve. For Cloud Run (fully
      managed), replace {namespace_id} with the project ID or number.
  """

  name = _messages.StringField(1, required=True)


class RunNamespacesJobsListRequest(_messages.Message):
  r"""A RunNamespacesJobsListRequest object.

  Fields:
    continue_: Optional. Optional encoded string to continue paging.
    fieldSelector: Optional. Allows to filter resources based on a specific
      value for a field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Optional. Not currently used by Cloud Run.
    labelSelector: Optional. Allows to filter resources based on a label.
      Supported operations are =, !=, exists, in, and notIn.
    limit: Optional. The maximum number of records that should be returned.
    parent: Required. The namespace from which the jobs should be listed.
      Replace {namespace_id} with the project ID or number.
    resourceVersion: Optional. The baseline resource version from which the
      list or watch operation should start. Not currently used by Cloud Run.
    watch: Optional. Flag that indicates that the client expects to watch this
      resource as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsDomainmappingsCreateRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsCreateRequest object.

  Fields:
    domainMapping: A DomainMapping resource to be passed as the request body.
    parent: The project ID or project number in which this domain mapping
      should be created.
  """

  domainMapping = _messages.MessageField('DomainMapping', 1)
  parent = _messages.StringField(2, required=True)


class RunProjectsLocationsDomainmappingsDeleteRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: The name of the domain mapping being deleted. If needed, replace
      {namespace_id} with the project ID.
    orphanDependents: Deprecated. Specifies the cascade behavior on delete.
      Cloud Run only supports cascading behavior, so this must be false. This
      attribute is deprecated, and is now replaced with PropagationPolicy See
      https://github.com/kubernetes/kubernetes/issues/46659 for more info.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  orphanDependents = _messages.BooleanField(4)
  propagationPolicy = _messages.StringField(5)


class RunProjectsLocationsDomainmappingsGetRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsGetRequest object.

  Fields:
    name: The name of the domain mapping being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class RunProjectsLocationsDomainmappingsListRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: The project ID or project number from which the domain mappings
      should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class RunProjectsLocationsDomainmappingsReplaceDomainMappingRequest(_messages.Message):
  r"""A RunProjectsLocationsDomainmappingsReplaceDomainMappingRequest object.

  Fields:
    domainMapping: A DomainMapping resource to be passed as the request body.
    name: The name of the domain mapping being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  domainMapping = _messages.MessageField('DomainMapping', 1)
  name = _messages.StringField(2, required=True)


class SELinuxOptions(_messages.Message):
  r"""SELinuxOptions are the labels to be applied to the container

  Fields:
    level: Level is SELinux level label that applies to the container.
      +optional
    role: Role is a SELinux role label that applies to the container.
      +optional
    type: Type is a SELinux type label that applies to the container.
      +optional
    user: User is a SELinux user label that applies to the container.
      +optional
  """

  level = _messages.StringField(1)
  role = _messages.StringField(2)
  type = _messages.StringField(3)
  user = _messages.StringField(4)


class SecretEnvSource(_messages.Message):
  r"""SecretEnvSource selects a Secret to populate the environment variables
  with. The contents of the target Secret's Data field will represent the key-
  value pairs as environment variables.

  Fields:
    localObjectReference: This field should not be used directly as it is
      meant to be inlined directly into the message. Use the "name" field
      instead.
    name: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported The Secret to select from.
    optional: Cloud Run fully managed: not supported Cloud Run for Anthos:
      supported Specify whether the Secret must be defined +optional
  """

  localObjectReference = _messages.MessageField('LocalObjectReference', 1)
  name = _messages.StringField(2)
  optional = _messages.BooleanField(3)


class SecretKeySelector(_messages.Message):
  r"""Cloud Run fully managed: supported Cloud Run on GKE: supported
  SecretKeySelector selects a key of a Secret.

  Fields:
    key: Cloud Run fully managed: supported A Cloud Secret Manager secret
      version. Must be 'latest' for the latest version or an integer for a
      specific version. Cloud Run for Anthos: supported The key of the secret
      to select from. Must be a valid secret key.
    localObjectReference: This field should not be used directly as it is
      meant to be inlined directly into the message. Use the "name" field
      instead.
    name: Cloud Run fully managed: supported The name of the secret in Cloud
      Secret Manager. By default, the secret is assumed to be in the same
      project. If the secret is in another project, you must define an alias.
      An alias definition has the form: :projects//secrets/. If multiple alias
      definitions are needed, they must be separated by commas. The alias
      definitions must be set on the run.googleapis.com/secrets annotation.
      Cloud Run for Anthos: supported The name of the secret in the pod's
      namespace to select from.
    optional: Cloud Run fully managed: not supported Cloud Run on GKE:
      supported Specify whether the Secret or its key must be defined
      +optional
  """

  key = _messages.StringField(1)
  localObjectReference = _messages.MessageField('LocalObjectReference', 2)
  name = _messages.StringField(3)
  optional = _messages.BooleanField(4)


class SecretVolumeSource(_messages.Message):
  r"""The contents of the target Secret's Data field will be presented in a
  volume as files using the keys in the Data field as the file names.

  Fields:
    defaultMode: Mode bits to use on created files by default. Must be a value
      between 0 and 0777. Defaults to 0644. Directories within the path are
      not affected by this setting. This might be in conflict with other
      options that affect the file mode, like fsGroup, and the result can be
      other mode bits set.
    items: Cloud Run fully managed: supported If unspecified, the volume will
      expose a file whose name is the secret_name. If specified, the key will
      be used as the version to fetch from Cloud Secret Manager and the path
      will be the name of the file exposed in the volume. When items are
      defined, they must specify a key and a path. Cloud Run for Anthos:
      supported If unspecified, each key-value pair in the Data field of the
      referenced Secret will be projected into the volume as a file whose name
      is the key and content is the value. If specified, the listed keys will
      be projected into the specified paths, and unlisted keys will not be
      present. If a key is specified which is not present in the Secret, the
      volume setup will error unless it is marked optional.
    optional: Specify whether the Secret or its keys must be defined.
    secretName: Cloud Run fully managed: supported The name of the secret in
      Cloud Secret Manager. By default, the secret is assumed to be in the
      same project. If the secret is in another project, you must define an
      alias. An alias definition has the form: :projects//secrets/. If
      multiple alias definitions are needed, they must be separated by commas.
      The alias definitions must be set on the run.googleapis.com/secrets
      annotation. Cloud Run for Anthos: supported Name of the secret in the
      container's namespace to use.
  """

  defaultMode = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  items = _messages.MessageField('KeyToPath', 2, repeated=True)
  optional = _messages.BooleanField(3)
  secretName = _messages.StringField(4)


class SecurityContext(_messages.Message):
  r"""SecurityContext holds security configuration that will be applied to a
  container. Some fields are present in both SecurityContext and
  PodSecurityContext. When both are set, the values in SecurityContext take
  precedence.

  Fields:
    allowPrivilegeEscalation: AllowPrivilegeEscalation controls whether a
      process can gain more privileges than its parent process. This bool
      directly controls if the no_new_privs flag will be set on the container
      process. AllowPrivilegeEscalation is true always when the container is:
      1) run as Privileged 2) has CAP_SYS_ADMIN +optional
    capabilities: The capabilities to add/drop when running containers.
      Defaults to the default set of capabilities granted by the container
      runtime. +optional
    privileged: Run container in privileged mode. Processes in privileged
      containers are essentially equivalent to root on the host. Defaults to
      false. +optional
    readOnlyRootFilesystem: Whether this container has a read-only root
      filesystem. Default is false. +optional
    runAsGroup: The GID to run the entrypoint of the container process. Uses
      runtime default if unset. May also be set in PodSecurityContext. If set
      in both SecurityContext and PodSecurityContext, the value specified in
      SecurityContext takes precedence. +optional
    runAsNonRoot: Indicates that the container must run as a non-root user. If
      true, the Kubelet will validate the image at runtime to ensure that it
      does not run as UID 0 (root) and fail to start the container if it does.
      If unset or false, no such validation will be performed. May also be set
      in PodSecurityContext. If set in both SecurityContext and
      PodSecurityContext, the value specified in SecurityContext takes
      precedence. +optional
    runAsUser: The UID to run the entrypoint of the container process.
      Defaults to user specified in image metadata if unspecified. May also be
      set in PodSecurityContext. If set in both SecurityContext and
      PodSecurityContext, the value specified in SecurityContext takes
      precedence. +optional
    seLinuxOptions: The SELinux context to be applied to the container. If
      unspecified, the container runtime will allocate a random SELinux
      context for each container. May also be set in PodSecurityContext. If
      set in both SecurityContext and PodSecurityContext, the value specified
      in SecurityContext takes precedence. +optional
  """

  allowPrivilegeEscalation = _messages.BooleanField(1)
  capabilities = _messages.MessageField('Capabilities', 2)
  privileged = _messages.BooleanField(3)
  readOnlyRootFilesystem = _messages.BooleanField(4)
  runAsGroup = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  runAsNonRoot = _messages.BooleanField(6)
  runAsUser = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  seLinuxOptions = _messages.MessageField('SELinuxOptions', 8)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class TCPSocketAction(_messages.Message):
  r"""TCPSocketAction describes an action based on opening a socket

  Fields:
    host: Optional: Host name to connect to, defaults to the pod IP. +optional
    port: Number or name of the port to access on the container. Number must
      be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
  """

  host = _messages.StringField(1)
  port = _messages.MessageField('IntOrString', 2)


class Volume(_messages.Message):
  r"""Volume represents a named volume in a container.

  Fields:
    configMap: A ConfigMapVolumeSource attribute.
    name: Volume's name.
    secret: A SecretVolumeSource attribute.
  """

  configMap = _messages.MessageField('ConfigMapVolumeSource', 1)
  name = _messages.StringField(2)
  secret = _messages.MessageField('SecretVolumeSource', 3)


class VolumeDevice(_messages.Message):
  r"""volumeDevice describes a mapping of a raw block device within a
  container.

  Fields:
    devicePath: devicePath is the path inside of the container that the device
      will be mapped to.
    name: name must match the name of a persistentVolumeClaim in the pod
  """

  devicePath = _messages.StringField(1)
  name = _messages.StringField(2)


class VolumeMount(_messages.Message):
  r"""VolumeMount describes a mounting of a Volume within a container.

  Fields:
    mountPath: Path within the container at which the volume should be
      mounted. Must not contain ':'.
    mountPropagation: mountPropagation determines how mounts are propagated
      from the host to container and the other way around. When not set,
      MountPropagationHostToContainer is used. This field is beta in 1.10.
      +optional
    name: This must match the Name of a Volume.
    readOnly: Mounted read-only if true, read-write otherwise (false or
      unspecified). Defaults to false. +optional
    subPath: Path within the volume from which the container's volume should
      be mounted. Defaults to "" (volume's root). +optional
  """

  mountPath = _messages.StringField(1)
  mountPropagation = _messages.StringField(2)
  name = _messages.StringField(3)
  readOnly = _messages.BooleanField(4)
  subPath = _messages.StringField(5)


encoding.AddCustomJsonFieldMapping(
    Handler, 'exec_', 'exec')
encoding.AddCustomJsonFieldMapping(
    ListMeta, 'continue_', 'continue')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
