"""Generated message classes for aiplatform version v1alpha1.

Train high-quality custom machine learning models with minimal machine
learning expertise and effort.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'aiplatform'


class AiplatformProjectsLocationsBatchPredictionJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsCancelRequest object.

  Fields:
    googleCloudAiplatformV1alpha1CancelBatchPredictionJobRequest: A
      GoogleCloudAiplatformV1alpha1CancelBatchPredictionJobRequest resource to
      be passed as the request body.
    name: Required. The name of the BatchPredictionJob to cancel. Format: `pro
      jects/{project}/locations/{location}/batchPredictionJobs/{batch_predicti
      on_job}`
  """

  googleCloudAiplatformV1alpha1CancelBatchPredictionJobRequest = _messages.MessageField('GoogleCloudAiplatformV1alpha1CancelBatchPredictionJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsBatchPredictionJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1alpha1BatchPredictionJob: A
      GoogleCloudAiplatformV1alpha1BatchPredictionJob resource to be passed as
      the request body.
    parent: Required. The resource name of the Location to create the
      BatchPredictionJob in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1alpha1BatchPredictionJob = _messages.MessageField('GoogleCloudAiplatformV1alpha1BatchPredictionJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsBatchPredictionJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsDeleteRequest object.

  Fields:
    name: Required. The name of the BatchPredictionJob resource to be deleted.
      Format: `projects/{project}/locations/{location}/batchPredictionJobs/{ba
      tch_prediction_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsBatchPredictionJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsGetRequest object.

  Fields:
    name: Required. The name of the BatchPredictionJob resource. Format: `proj
      ects/{project}/locations/{location}/batchPredictionJobs/{batch_predictio
      n_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsBatchPredictionJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsBatchPredictionJobsListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports = and !=. * `state` supports = and !=. Some examples of using
      the filter are: * `state="JOB_STATE_SUCCEEDED" AND
      display_name="my_job"` * `state="JOB_STATE_RUNNING" OR
      display_name="my_job"` * `NOT display_name="my_job"` *
      `state="JOB_STATE_FAILED"`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListBatchPredictionJobsResponse.next_page_token of the previous
      JobService.ListBatchPredictionJobs call.
    parent: Required. The resource name of the Location to list the
      BatchPredictionJobs from. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsCustomJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsCancelRequest object.

  Fields:
    googleCloudAiplatformV1alpha1CancelCustomJobRequest: A
      GoogleCloudAiplatformV1alpha1CancelCustomJobRequest resource to be
      passed as the request body.
    name: Required. The name of the CustomJob to cancel. Format:
      `projects/{project}/locations/{location}/customJobs/{custom_job}`
  """

  googleCloudAiplatformV1alpha1CancelCustomJobRequest = _messages.MessageField('GoogleCloudAiplatformV1alpha1CancelCustomJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsCustomJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1alpha1CustomJob: A
      GoogleCloudAiplatformV1alpha1CustomJob resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create the
      CustomJob in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1alpha1CustomJob = _messages.MessageField('GoogleCloudAiplatformV1alpha1CustomJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsCustomJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsDeleteRequest object.

  Fields:
    name: Required. The name of the CustomJob resource to be deleted. Format:
      `projects/{project}/locations/{location}/customJobs/{custom_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCustomJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsGetRequest object.

  Fields:
    name: Required. The name of the CustomJob resource. Format:
      `projects/{project}/locations/{location}/customJobs/{custom_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCustomJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports = and !=. * `state` supports = and !=. Some examples of using
      the filter are: * `state="JOB_STATE_SUCCEEDED" AND
      display_name="my_job"` * `state="JOB_STATE_RUNNING" OR
      display_name="my_job"` * `NOT display_name="my_job"` *
      `state="JOB_STATE_FAILED"`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListCustomJobsResponse.next_page_token of the previous
      JobService.ListCustomJobs call.
    parent: Required. The resource name of the Location to list the CustomJobs
      from. Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsCustomJobsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCustomJobsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCustomJobsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsCustomJobsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsCustomJobsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsCustomJobsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDataLabelingJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsCancelRequest object.

  Fields:
    googleCloudAiplatformV1alpha1CancelDataLabelingJobRequest: A
      GoogleCloudAiplatformV1alpha1CancelDataLabelingJobRequest resource to be
      passed as the request body.
    name: Required. The name of the DataLabelingJob. Format: `projects/{projec
      t}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
  """

  googleCloudAiplatformV1alpha1CancelDataLabelingJobRequest = _messages.MessageField('GoogleCloudAiplatformV1alpha1CancelDataLabelingJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDataLabelingJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsCreateRequest object.

  Fields:
    googleCloudAiplatformV1alpha1DataLabelingJob: A
      GoogleCloudAiplatformV1alpha1DataLabelingJob resource to be passed as
      the request body.
    parent: Required. The parent of the DataLabelingJob. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1alpha1DataLabelingJob = _messages.MessageField('GoogleCloudAiplatformV1alpha1DataLabelingJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDataLabelingJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsDeleteRequest object.

  Fields:
    name: Required. The name of the DataLabelingJob to be deleted. Format: `pr
      ojects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_jo
      b}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDataLabelingJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsGetRequest object.

  Fields:
    name: Required. The name of the DataLabelingJob. Format: `projects/{projec
      t}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDataLabelingJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports = and !=. * `state` supports = and !=. Some examples of using
      the filter are: * `state="JOB_STATE_SUCCEEDED" AND
      display_name="my_job"` * `state="JOB_STATE_RUNNING" OR
      display_name="my_job"` * `NOT display_name="my_job"` *
      `state="JOB_STATE_FAILED"`
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The parent of the DataLabelingJob. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read. FieldMask represents a set
      of symbolic field paths. For example, the mask can be `paths: "name"`.
      The "name" here is a field in DataLabelingJob. If this field is not set,
      all fields of the DataLabelingJob are returned.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsDataLabelingJobsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDataLabelingJobsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDataLabelingJobsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDataLabelingJobsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDataLabelingJobsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDataLabelingJobsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsAnnotationSpecsGetRequest object.

  Fields:
    name: Required. The name of the AnnotationSpec resource. Format: `projects
      /{project}/locations/{location}/datasets/{dataset}/annotationSpecs/{anno
      tation_spec}`
    readMask: Mask specifying which fields to read.
  """

  name = _messages.StringField(1, required=True)
  readMask = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsAnnotationSpecsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsCreateRequest object.

  Fields:
    googleCloudAiplatformV1alpha1Dataset: A
      GoogleCloudAiplatformV1alpha1Dataset resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create the Dataset
      in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1alpha1Dataset = _messages.MessageField('GoogleCloudAiplatformV1alpha1Dataset', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsAnnotationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The resource name of the DataItem to list Annotations
      from. Format: `projects/{project}/locations/{location}/datasets/{dataset
      }/dataItems/{data_item}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsCance
  lRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsDelet
  eRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsDatasetsDataItemsAnnotationsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsDataItemsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsListRequest object.

  Fields:
    filter: The standard list filter.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The resource name of the Dataset to list DataItems from.
      Format: `projects/{project}/locations/{location}/datasets/{dataset}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsDatasetsDataItemsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsDataItemsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDatasetsDataItemsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDataItemsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsDeleteRequest object.

  Fields:
    name: Required. The resource name of the Dataset to delete. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsExportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsExportRequest object.

  Fields:
    googleCloudAiplatformV1alpha1ExportDataRequest: A
      GoogleCloudAiplatformV1alpha1ExportDataRequest resource to be passed as
      the request body.
    name: Required. The name of the Dataset resource. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
  """

  googleCloudAiplatformV1alpha1ExportDataRequest = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExportDataRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDatasetsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsGetRequest object.

  Fields:
    name: Required. The name of the Dataset resource.
    readMask: Mask specifying which fields to read.
  """

  name = _messages.StringField(1, required=True)
  readMask = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsImportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsImportRequest object.

  Fields:
    googleCloudAiplatformV1alpha1ImportDataRequest: A
      GoogleCloudAiplatformV1alpha1ImportDataRequest resource to be passed as
      the request body.
    name: Required. The name of the Dataset resource. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
  """

  googleCloudAiplatformV1alpha1ImportDataRequest = _messages.MessageField('GoogleCloudAiplatformV1alpha1ImportDataRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsDatasetsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsListRequest object.

  Fields:
    filter: An expression for filtering the results of the request. For field
      names both snake_case and camelCase are supported. * `display_name`:
      supports = and != * `metadata_schema_uri`: supports = and != * `labels`
      supports general map functions that is: * `labels.key=value` - key:value
      equality * `labels.key:* or labels:key - key existence * A key including
      a space must be quoted. `labels."a key"`. Some examples: *
      `displayName="myDisplayName"` * `labels.myKey="myValue"`
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    parent: Required. The name of the Dataset's parent resource. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsDatasetsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDatasetsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsDatasetsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsPatchRequest object.

  Fields:
    googleCloudAiplatformV1alpha1Dataset: A
      GoogleCloudAiplatformV1alpha1Dataset resource to be passed as the
      request body.
    name: Output only. The resource name of the Dataset.
    updateMask: Required. The update mask applies to the resource. For the
      `FieldMask` definition, see
      [FieldMask](https://tinyurl.com/protobufs/google.protobuf#fieldmask).
      Updatable fields: * `display_name` * `description` * `labels`
  """

  googleCloudAiplatformV1alpha1Dataset = _messages.MessageField('GoogleCloudAiplatformV1alpha1Dataset', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsDatasetsSavedQueriesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsSavedQueriesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsSavedQueriesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsDatasetsSavedQueriesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsDatasetsSavedQueriesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsDatasetsSavedQueriesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsEndpointsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsCreateRequest object.

  Fields:
    googleCloudAiplatformV1alpha1Endpoint: A
      GoogleCloudAiplatformV1alpha1Endpoint resource to be passed as the
      request body.
    parent: Required. The resource name of the Location to create the Endpoint
      in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1alpha1Endpoint = _messages.MessageField('GoogleCloudAiplatformV1alpha1Endpoint', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsEndpointsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsDeleteRequest object.

  Fields:
    name: Required. The name of the Endpoint resource to be deleted. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEndpointsDeployModelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsDeployModelRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint resource into which to deploy
      a Model. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1alpha1DeployModelRequest: A
      GoogleCloudAiplatformV1alpha1DeployModelRequest resource to be passed as
      the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1alpha1DeployModelRequest = _messages.MessageField('GoogleCloudAiplatformV1alpha1DeployModelRequest', 2)


class AiplatformProjectsLocationsEndpointsExplainRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsExplainRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      explanation. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1alpha1ExplainRequest: A
      GoogleCloudAiplatformV1alpha1ExplainRequest resource to be passed as the
      request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1alpha1ExplainRequest = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExplainRequest', 2)


class AiplatformProjectsLocationsEndpointsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsGetRequest object.

  Fields:
    name: Required. The name of the Endpoint resource. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEndpointsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsListRequest object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      For field names both snake_case and camelCase are supported. *
      `endpoint` supports = and !=. `endpoint` represents the Endpoint ID,
      i.e. the last segment of the Endpoint's resource name. * `display_name`
      supports = and, != * `labels` supports general map functions that is: *
      `labels.key=value` - key:value equality * `labels.key:* or labels:key -
      key existence * A key including a space must be quoted. `labels."a
      key"`. Some examples: * `endpoint=1` * `displayName="myDisplayName"` *
      `labels.myKey="myValue"`
    pageSize: Optional. The standard list page size.
    pageToken: Optional. The standard list page token. Typically obtained via
      ListEndpointsResponse.next_page_token of the previous
      EndpointService.ListEndpoints call.
    parent: Required. The resource name of the Location from which to list the
      Endpoints. Format: `projects/{project}/locations/{location}`
    readMask: Optional. Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsEndpointsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEndpointsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEndpointsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsEndpointsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsEndpointsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsEndpointsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsPatchRequest object.

  Fields:
    googleCloudAiplatformV1alpha1Endpoint: A
      GoogleCloudAiplatformV1alpha1Endpoint resource to be passed as the
      request body.
    name: Output only. The resource name of the Endpoint.
    updateMask: Required. The update mask applies to the resource. See
      [FieldMask](https://tinyurl.com/protobufs/google.protobuf#fieldmask).
  """

  googleCloudAiplatformV1alpha1Endpoint = _messages.MessageField('GoogleCloudAiplatformV1alpha1Endpoint', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsEndpointsPredictRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsPredictRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint requested to serve the
      prediction. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1alpha1PredictRequest: A
      GoogleCloudAiplatformV1alpha1PredictRequest resource to be passed as the
      request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1alpha1PredictRequest = _messages.MessageField('GoogleCloudAiplatformV1alpha1PredictRequest', 2)


class AiplatformProjectsLocationsEndpointsUndeployModelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsEndpointsUndeployModelRequest object.

  Fields:
    endpoint: Required. The name of the Endpoint resource from which to
      undeploy a Model. Format:
      `projects/{project}/locations/{location}/endpoints/{endpoint}`
    googleCloudAiplatformV1alpha1UndeployModelRequest: A
      GoogleCloudAiplatformV1alpha1UndeployModelRequest resource to be passed
      as the request body.
  """

  endpoint = _messages.StringField(1, required=True)
  googleCloudAiplatformV1alpha1UndeployModelRequest = _messages.MessageField('GoogleCloudAiplatformV1alpha1UndeployModelRequest', 2)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsC
  ancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsD
  eleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsG
  etRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsL
  istRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsW
  aitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsFeaturestoresEntityTypesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsFeaturestoresOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsFeaturestoresOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsFeaturestoresOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsFeaturestoresOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsCancelRequest
  object.

  Fields:
    googleCloudAiplatformV1alpha1CancelHyperparameterTuningJobRequest: A
      GoogleCloudAiplatformV1alpha1CancelHyperparameterTuningJobRequest
      resource to be passed as the request body.
    name: Required. The name of the HyperparameterTuningJob to cancel. Format:
      `projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyper
      parameter_tuning_job}`
  """

  googleCloudAiplatformV1alpha1CancelHyperparameterTuningJobRequest = _messages.MessageField('GoogleCloudAiplatformV1alpha1CancelHyperparameterTuningJobRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsCreateRequest
  object.

  Fields:
    googleCloudAiplatformV1alpha1HyperparameterTuningJob: A
      GoogleCloudAiplatformV1alpha1HyperparameterTuningJob resource to be
      passed as the request body.
    parent: Required. The resource name of the Location to create the
      HyperparameterTuningJob in. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1alpha1HyperparameterTuningJob = _messages.MessageField('GoogleCloudAiplatformV1alpha1HyperparameterTuningJob', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsDeleteRequest
  object.

  Fields:
    name: Required. The name of the HyperparameterTuningJob resource to be
      deleted. Format: `projects/{project}/locations/{location}/hyperparameter
      TuningJobs/{hyperparameter_tuning_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsGetRequest object.

  Fields:
    name: Required. The name of the HyperparameterTuningJob resource. Format:
      `projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyper
      parameter_tuning_job}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsHyperparameterTuningJobsListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports = and !=. * `state` supports = and !=. Some examples of using
      the filter are: * `state="JOB_STATE_SUCCEEDED" AND
      display_name="my_job"` * `state="JOB_STATE_RUNNING" OR
      display_name="my_job"` * `NOT display_name="my_job"` *
      `state="JOB_STATE_FAILED"`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListHyperparameterTuningJobsResponse.next_page_token of the previous
      JobService.ListHyperparameterTuningJobs call.
    parent: Required. The resource name of the Location to list the
      HyperparameterTuningJobs from. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsHyperparameterTuningJobsOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsHyperparameterTuningJobsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsHyperparameterTuningJobsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsHyperparameterTuningJobsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsHyperparameterTuningJobsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsHyperparameterTuningJobsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsHyperparameterTuningJobsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsHyperparameterTuningJobsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsMigratableResourcesBatchMigrateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesBatchMigrateRequest
  object.

  Fields:
    googleCloudAiplatformV1alpha1BatchMigrateResourcesRequest: A
      GoogleCloudAiplatformV1alpha1BatchMigrateResourcesRequest resource to be
      passed as the request body.
    parent: Required. The location of the migrated resource will live in.
      Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1alpha1BatchMigrateResourcesRequest = _messages.MessageField('GoogleCloudAiplatformV1alpha1BatchMigrateResourcesRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsMigratableResourcesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMigratableResourcesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMigratableResourcesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsMigratableResourcesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsMigratableResourcesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsMigratableResourcesSearchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsMigratableResourcesSearchRequest object.

  Fields:
    googleCloudAiplatformV1alpha1SearchMigratableResourcesRequest: A
      GoogleCloudAiplatformV1alpha1SearchMigratableResourcesRequest resource
      to be passed as the request body.
    parent: Required. The location that the migratable resources should be
      searched from. It's the AI Platform location that the resources can be
      migrated to, not the resources' original location. Format:
      `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1alpha1SearchMigratableResourcesRequest = _messages.MessageField('GoogleCloudAiplatformV1alpha1SearchMigratableResourcesRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsCanc
  elRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsDele
  teRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsList
  Request object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelDeploymentMonitoringJobsOperationsWait
  Request object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsModelsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsDeleteRequest object.

  Fields:
    name: Required. The name of the Model resource to be deleted. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsExportEvaluatedDataItemsRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsModelsEvaluationsExportEvaluatedDataItemsRequest
  object.

  Fields:
    googleCloudAiplatformV1alpha1ExportEvaluatedDataItemsRequest: A
      GoogleCloudAiplatformV1alpha1ExportEvaluatedDataItemsRequest resource to
      be passed as the request body.
    modelEvaluation: Required. The resource name of the ModelEvaluation whose
      evaluated DataItems are to be exported. Format: `projects/{project}/loca
      tions/{location}/models/{model}/evaluations/{evaluation}`
  """

  googleCloudAiplatformV1alpha1ExportEvaluatedDataItemsRequest = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExportEvaluatedDataItemsRequest', 1)
  modelEvaluation = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsEvaluationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsGetRequest object.

  Fields:
    name: Required. The name of the ModelEvaluation resource. Format: `project
      s/{project}/locations/{location}/models/{model}/evaluations/{evaluation}
      `
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsListRequest object.

  Fields:
    filter: The standard list filter.
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListModelEvaluationsResponse.next_page_token of the previous
      ModelService.ListModelEvaluations call.
    parent: Required. The resource name of the Model to list the
      ModelEvaluations from. Format:
      `projects/{project}/locations/{location}/models/{model}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsModelsEvaluationsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsModelsEvaluationsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsModelsEvaluationsSlicesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsSlicesGetRequest object.

  Fields:
    name: Required. The name of the ModelEvaluationSlice resource. Format: `pr
      ojects/{project}/locations/{location}/models/{model}/evaluations/{evalua
      tion}/slices/{slice}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsEvaluationsSlicesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsEvaluationsSlicesListRequest object.

  Fields:
    filter: The standard list filter. * `slice.dimension` - for =.
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListModelEvaluationSlicesResponse.next_page_token of the previous
      ModelService.ListModelEvaluationSlices call.
    parent: Required. The resource name of the ModelEvaluation to list the
      ModelEvaluationSlices from. Format: `projects/{project}/locations/{locat
      ion}/models/{model}/evaluations/{evaluation}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsModelsExportRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsExportRequest object.

  Fields:
    googleCloudAiplatformV1alpha1ExportModelRequest: A
      GoogleCloudAiplatformV1alpha1ExportModelRequest resource to be passed as
      the request body.
    name: Required. The resource name of the Model to export. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  googleCloudAiplatformV1alpha1ExportModelRequest = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExportModelRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsModelsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsGetRequest object.

  Fields:
    name: Required. The name of the Model resource. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsListRequest object.

  Fields:
    filter: An expression for filtering the results of the request. For field
      names both snake_case and camelCase are supported. * `model` supports =
      and !=. `model` represents the Model ID, i.e. the last segment of the
      Model's resource name. * `display_name` supports = and != * `labels`
      supports general map functions that is: * `labels.key=value` - key:value
      equality * `labels.key:* or labels:key - key existence * A key including
      a space must be quoted. `labels."a key"`. Some examples: * `model=1234`
      * `displayName="myDisplayName"` * `labels.myKey="myValue"`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListModelsResponse.next_page_token of the previous
      ModelService.ListModels call.
    parent: Required. The resource name of the Location to list the Models
      from. Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsModelsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsModelsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsModelsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsModelsUploadRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsModelsUploadRequest object.

  Fields:
    googleCloudAiplatformV1alpha1UploadModelRequest: A
      GoogleCloudAiplatformV1alpha1UploadModelRequest resource to be passed as
      the request body.
    parent: Required. The resource name of the Location into which to upload
      the Model. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1alpha1UploadModelRequest = _messages.MessageField('GoogleCloudAiplatformV1alpha1UploadModelRequest', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsCancelRequest object.

  Fields:
    googleLongrunningCancelOperationRequest: A
      GoogleLongrunningCancelOperationRequest resource to be passed as the
      request body.
    name: The name of the operation resource to be cancelled.
  """

  googleLongrunningCancelOperationRequest = _messages.MessageField('GoogleLongrunningCancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsOperationsWaitRequest object.

  Fields:
    googleLongrunningWaitOperationRequest: A
      GoogleLongrunningWaitOperationRequest resource to be passed as the
      request body.
    name: The name of the operation resource to wait on.
  """

  googleLongrunningWaitOperationRequest = _messages.MessageField('GoogleLongrunningWaitOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsPipelineJobsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPipelineJobsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPipelineJobsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsPipelineJobsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsPipelineJobsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsPipelineJobsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsSpecialistPoolsCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsCreateRequest object.

  Fields:
    googleCloudAiplatformV1alpha1SpecialistPool: A
      GoogleCloudAiplatformV1alpha1SpecialistPool resource to be passed as the
      request body.
    parent: Required. The parent Project name for the new SpecialistPool. The
      form is `projects/{project}/locations/{location}`.
  """

  googleCloudAiplatformV1alpha1SpecialistPool = _messages.MessageField('GoogleCloudAiplatformV1alpha1SpecialistPool', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsSpecialistPoolsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsDeleteRequest object.

  Fields:
    force: If set to true, any specialist managers in this SpecialistPool will
      also be deleted. (Otherwise, the request will only work if the
      SpecialistPool has no specialist managers.)
    name: Required. The resource name of the SpecialistPool to delete. Format:
      `projects/{project}/locations/{location}/specialistPools/{specialist_poo
      l}`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsSpecialistPoolsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsGetRequest object.

  Fields:
    name: Required. The name of the SpecialistPool resource. The form is `proj
      ects/{project}/locations/{location}/specialistPools/{specialist_pool}`.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSpecialistPoolsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsListRequest object.

  Fields:
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained by
      ListSpecialistPoolsResponse.next_page_token of the previous
      SpecialistPoolService.ListSpecialistPools call. Return first page if
      empty.
    parent: Required. The name of the SpecialistPool's parent resource.
      Format: `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read. FieldMask represents a set
      of
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  readMask = _messages.StringField(4)


class AiplatformProjectsLocationsSpecialistPoolsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSpecialistPoolsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSpecialistPoolsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsSpecialistPoolsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsSpecialistPoolsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsSpecialistPoolsPatchRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsSpecialistPoolsPatchRequest object.

  Fields:
    googleCloudAiplatformV1alpha1SpecialistPool: A
      GoogleCloudAiplatformV1alpha1SpecialistPool resource to be passed as the
      request body.
    name: Required. The resource name of the SpecialistPool.
    updateMask: Required. The update mask applies to the resource.
  """

  googleCloudAiplatformV1alpha1SpecialistPool = _messages.MessageField('GoogleCloudAiplatformV1alpha1SpecialistPool', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AiplatformProjectsLocationsStudiesTrialsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesTrialsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesTrialsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsStudiesTrialsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsStudiesTrialsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsStudiesTrialsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsTensorboardsExperimentsOperationsCancelRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsOperationsDeleteRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsTensorboardsExperimentsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsCancel
  Request object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsDelete
  Request object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsGetRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsListRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsWaitRequest(_messages.Message):
  r"""A
  AiplatformProjectsLocationsTensorboardsExperimentsRunsOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperat
  ionsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperat
  ionsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperat
  ionsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperat
  ionsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperat
  ionsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsTensorboardsOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTensorboardsOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsTensorboardsOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTensorboardsOperationsWaitRequest object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class AiplatformProjectsLocationsTrainingPipelinesCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesCancelRequest object.

  Fields:
    googleCloudAiplatformV1alpha1CancelTrainingPipelineRequest: A
      GoogleCloudAiplatformV1alpha1CancelTrainingPipelineRequest resource to
      be passed as the request body.
    name: Required. The name of the TrainingPipeline to cancel. Format: `proje
      cts/{project}/locations/{location}/trainingPipelines/{training_pipeline}
      `
  """

  googleCloudAiplatformV1alpha1CancelTrainingPipelineRequest = _messages.MessageField('GoogleCloudAiplatformV1alpha1CancelTrainingPipelineRequest', 1)
  name = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTrainingPipelinesCreateRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesCreateRequest object.

  Fields:
    googleCloudAiplatformV1alpha1TrainingPipeline: A
      GoogleCloudAiplatformV1alpha1TrainingPipeline resource to be passed as
      the request body.
    parent: Required. The resource name of the Location to create the
      TrainingPipeline in. Format: `projects/{project}/locations/{location}`
  """

  googleCloudAiplatformV1alpha1TrainingPipeline = _messages.MessageField('GoogleCloudAiplatformV1alpha1TrainingPipeline', 1)
  parent = _messages.StringField(2, required=True)


class AiplatformProjectsLocationsTrainingPipelinesDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesDeleteRequest object.

  Fields:
    name: Required. The name of the TrainingPipeline resource to be deleted.
      Format: `projects/{project}/locations/{location}/trainingPipelines/{trai
      ning_pipeline}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesGetRequest object.

  Fields:
    name: Required. The name of the TrainingPipeline resource. Format: `projec
      ts/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesListRequest object.

  Fields:
    filter: The standard list filter. Supported fields: * `display_name`
      supports = and !=. * `state` supports = and !=. Some examples of using
      the filter are: * `state="PIPELINE_STATE_SUCCEEDED" AND
      display_name="my_pipeline"` * `state="PIPELINE_STATE_RUNNING" OR
      display_name="my_pipeline"` * `NOT display_name="my_pipeline"` *
      `state="PIPELINE_STATE_FAILED"`
    pageSize: The standard list page size.
    pageToken: The standard list page token. Typically obtained via
      ListTrainingPipelinesResponse.next_page_token of the previous
      PipelineService.ListTrainingPipelines call.
    parent: Required. The resource name of the Location to list the
      TrainingPipelines from. Format:
      `projects/{project}/locations/{location}`
    readMask: Mask specifying which fields to read.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  readMask = _messages.StringField(5)


class AiplatformProjectsLocationsTrainingPipelinesOperationsCancelRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesOperationsCancelRequest
  object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesOperationsDeleteRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesOperationsGetRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AiplatformProjectsLocationsTrainingPipelinesOperationsListRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class AiplatformProjectsLocationsTrainingPipelinesOperationsWaitRequest(_messages.Message):
  r"""A AiplatformProjectsLocationsTrainingPipelinesOperationsWaitRequest
  object.

  Fields:
    name: The name of the operation resource to wait on.
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  name = _messages.StringField(1, required=True)
  timeout = _messages.StringField(2)


class GoogleCloudAiplatformInternalBatchConfig(_messages.Message):
  r"""Configurations describing how to construct labeling tasks from collected
  prediction results.

  Fields:
    batchCount: A new labeling task will be generated once batch_count number
      of data items are collected.
    pendingDuration: A new labeling task will be generated once the oldest
      collected data item is pending for longer than pending_duration.
  """

  batchCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pendingDuration = _messages.StringField(2)


class GoogleCloudAiplatformInternalCreateHumanInTheLoopOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  HumanInTheLoopService.CreateHumanInTheLoop.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformInternalGenericOperationMetadata', 1)


class GoogleCloudAiplatformInternalDocumentCriteria(_messages.Message):
  r"""Describes the triggering criteria of the human in the loop configuration
  for document AI.

  Enums:
    CriteriaTypeValueValuesEnum: The current enabled criteria.

  Fields:
    criteriaType: The current enabled criteria.
    documentLevelCriteria: Document level criteria configuration.
    fieldCriteria: The list of field criteria user added.
    randomSampling: Randomly sample the documents for human review.
  """

  class CriteriaTypeValueValuesEnum(_messages.Enum):
    r"""The current enabled criteria.

    Values:
      CRITERIA_TYPE_UNSPECIFIED: Unspecified criteria type.
      RANDOM_SAMPLING: Randomly sample the document for human review.
      DOCUMENT_LEVEL: Configuration for the whole document fields/entities.
      FIELD_LEVEL: Configuration for each field/entity.
      CRITERIA_DISABLED: Criteria is disabled.
    """
    CRITERIA_TYPE_UNSPECIFIED = 0
    RANDOM_SAMPLING = 1
    DOCUMENT_LEVEL = 2
    FIELD_LEVEL = 3
    CRITERIA_DISABLED = 4

  criteriaType = _messages.EnumField('CriteriaTypeValueValuesEnum', 1)
  documentLevelCriteria = _messages.MessageField('GoogleCloudAiplatformInternalDocumentCriteriaDocumentLevelCriteria', 2)
  fieldCriteria = _messages.MessageField('GoogleCloudAiplatformInternalDocumentCriteriaFieldLevelCriteria', 3, repeated=True)
  randomSampling = _messages.MessageField('GoogleCloudAiplatformInternalHumanInTheLoopRandomSampling', 4)


class GoogleCloudAiplatformInternalDocumentCriteriaDocumentLevelCriteria(_messages.Message):
  r"""The general criteria for all the entities/fields in one document.

  Fields:
    confidenceThreshold: Confidence Threshold, between 0 - 1.0.
  """

  confidenceThreshold = _messages.FloatField(1)


class GoogleCloudAiplatformInternalDocumentCriteriaFieldLevelCriteria(_messages.Message):
  r"""Criteria for each field/entity interested.

  Enums:
    OccurrenceTypeValueValuesEnum: The expected OccurrenceType for the
      field/entity.

  Fields:
    confidenceThreshold: Confidence threshold, between 0 - 1.0.
    fieldName: Field/Entity Name.
    occurrenceType: The expected OccurrenceType for the field/entity.
  """

  class OccurrenceTypeValueValuesEnum(_messages.Enum):
    r"""The expected OccurrenceType for the field/entity.

    Values:
      OCCURRENCE_TYPE_UNSPECIFIED: Unspecified occurrence type.
      OPTIONAL_ONCE: The entity type will appear zero times or once.
      OPTIONAL_MULTIPLE: The entity type will appear zero or multiple times.
      REQUIRED_ONCE: The entity type will only appear exactly once.
      REQUIRED_MULTIPLE: The entity type will appear once or more times.
    """
    OCCURRENCE_TYPE_UNSPECIFIED = 0
    OPTIONAL_ONCE = 1
    OPTIONAL_MULTIPLE = 2
    REQUIRED_ONCE = 3
    REQUIRED_MULTIPLE = 4

  confidenceThreshold = _messages.FloatField(1)
  fieldName = _messages.StringField(2)
  occurrenceType = _messages.EnumField('OccurrenceTypeValueValuesEnum', 3)


class GoogleCloudAiplatformInternalDocumentMetadata(_messages.Message):
  r"""Metadata for the document AI human in the loop configuration.

  Fields:
    processorVersion: The Atlas processor version name that creates this human
      in the loop configuration.
  """

  processorVersion = _messages.StringField(1)


class GoogleCloudAiplatformInternalGenericOperationMetadata(_messages.Message):
  r"""Generic Metadata shared by all operations.

  Fields:
    createTime: Output only. Time when the operation was created.
    partialFailures: Output only. Partial failures encountered. E.g. single
      files that couldn't be read. This field should never exceed 20 entries.
      Status details field will contain standard GCP error details.
    updateTime: Output only. Time when the operation was updated for the last
      time. If the operation has finished (successfully or not), this is the
      finish time.
  """

  createTime = _messages.StringField(1)
  partialFailures = _messages.MessageField('GoogleRpcStatus', 2, repeated=True)
  updateTime = _messages.StringField(3)


class GoogleCloudAiplatformInternalHumanInTheLoop(_messages.Message):
  r"""A human in the loop configuration describing how to trigger a human
  labeling job in a prediction process and properties of the human labeling
  job. Next id: 23

  Enums:
    GoogleSpecialistRegionValueValuesEnum: Residency of Google in-house
      specialists. If users select to use Google in-house specialists to do
      the human review, Indian specialists are used by default; otherwise,
      users need to specify the Google specialist region here. If users select
      to use customized specialists, the Google specialist region here will be
      ignored.
    StateValueValuesEnum: State of the human in the loop feature.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your human
      in the loop configuration. Label keys and values can be no longer than
      64 characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable. Following system labels
      exist for each HumanInTheLoop: * "aiplatform.googleapis.com/schema": -
      output only, its value is the inputs_schema's title.

  Fields:
    batchConfig: Batching configuration of this human in the loop
      configuration.
    completedDataItemsCount: Output only. Number of labeled data items from
      this human in the loop configuration.
    completedDataLabelingJobsCount: Output only. Number of completed data
      labeling jobs from this human in the loop configuration.
    createTime: Output only. Timestamp when this configuration was created.
    dataLabelingJobInputsSchemaUri: Required. Points to a YAML file stored on
      Google Cloud Storage describing the configuration for a specific type of
      DataLabelingJob created from this configuration.
    dataLabelingJobParameters: Required. Input configuration parameters for
      the DataLabelingJob created from this configuration.
    displayName: Required. The user-defined name of the Human in the Loop. The
      name can be up to 128 characters long and can be consist of any UTF-8
      characters. This field should be unique on project-level.
    documentCriteria: Required. Criteria for triggering a document labeling
      job.
    documentMetadata: Metadata for document labeling.
    googleSpecialistRegion: Residency of Google in-house specialists. If users
      select to use Google in-house specialists to do the human review, Indian
      specialists are used by default; otherwise, users need to specify the
      Google specialist region here. If users select to use customized
      specialists, the Google specialist region here will be ignored.
    instructionUri: Required. The Google Cloud Storage location of the
      instruction pdf. This pdf is shared with labelers, and provides detailed
      description on how to label DataItems in Datasets.
    labels: The labels with user-defined metadata to organize your human in
      the loop configuration. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable. Following system labels
      exist for each HumanInTheLoop: * "aiplatform.googleapis.com/schema": -
      output only, its value is the inputs_schema's title.
    name: Output only. The resource name of the human in the loop
      configuration.
    outputPath: Cloud Storage path the labeling answer will be written to.
    pendingDataItemsCount: Output only. Number of data items that are
      collected but not yet sent to human review.
    replicaCount: Required. Number of labelers to work on each DataItem.
    runningDataItemsCount: Output only. Number of data items that belongs to
      the current running data labeling jobs from this human in the loop
      configuration.
    runningDataLabelingJobsCount: Output only. Number of currently running
      data labeling jobs from this human in the loop configuration.
    specialistPool: Resource names of the specialist pools used in this
      configuration.
    state: State of the human in the loop feature.
    updateTime: Output only. Timestamp when this configuration was updated
      most recently.
  """

  class GoogleSpecialistRegionValueValuesEnum(_messages.Enum):
    r"""Residency of Google in-house specialists. If users select to use
    Google in-house specialists to do the human review, Indian specialists are
    used by default; otherwise, users need to specify the Google specialist
    region here. If users select to use customized specialists, the Google
    specialist region here will be ignored.

    Values:
      GOOGLE_SPECIALIST_REGION_UNSPECIFIED: Unspecified.
      IN: Google specialist residented in IN.
      US: Google specialist residented in US.
      EU: Google specialist residented in EU.
    """
    GOOGLE_SPECIALIST_REGION_UNSPECIFIED = 0
    IN = 1
    US = 2
    EU = 3

  class StateValueValuesEnum(_messages.Enum):
    r"""State of the human in the loop feature.

    Values:
      STATE_UNSPECIFIED: Unspecified.
      DISABLED: Feature is disabled;
      ENABLED: Feature is enabled.
    """
    STATE_UNSPECIFIED = 0
    DISABLED = 1
    ENABLED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your human in the
    loop configuration. Label keys and values can be no longer than 64
    characters (Unicode codepoints), can only contain lowercase letters,
    numeric characters, underscores and dashes. International characters are
    allowed. See https://goo.gl/xmQnxf for more information and examples of
    labels. System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable. Following system labels
    exist for each HumanInTheLoop: * "aiplatform.googleapis.com/schema": -
    output only, its value is the inputs_schema's title.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  batchConfig = _messages.MessageField('GoogleCloudAiplatformInternalBatchConfig', 1)
  completedDataItemsCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  completedDataLabelingJobsCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  createTime = _messages.StringField(4)
  dataLabelingJobInputsSchemaUri = _messages.StringField(5)
  dataLabelingJobParameters = _messages.MessageField('extra_types.JsonValue', 6)
  displayName = _messages.StringField(7)
  documentCriteria = _messages.MessageField('GoogleCloudAiplatformInternalDocumentCriteria', 8)
  documentMetadata = _messages.MessageField('GoogleCloudAiplatformInternalDocumentMetadata', 9)
  googleSpecialistRegion = _messages.EnumField('GoogleSpecialistRegionValueValuesEnum', 10)
  instructionUri = _messages.StringField(11)
  labels = _messages.MessageField('LabelsValue', 12)
  name = _messages.StringField(13)
  outputPath = _messages.StringField(14)
  pendingDataItemsCount = _messages.IntegerField(15, variant=_messages.Variant.INT32)
  replicaCount = _messages.IntegerField(16, variant=_messages.Variant.INT32)
  runningDataItemsCount = _messages.IntegerField(17, variant=_messages.Variant.INT32)
  runningDataLabelingJobsCount = _messages.IntegerField(18, variant=_messages.Variant.INT32)
  specialistPool = _messages.StringField(19, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 20)
  updateTime = _messages.StringField(21)


class GoogleCloudAiplatformInternalHumanInTheLoopRandomSampling(_messages.Message):
  r"""Describe the random sampling parameters for triggering human in the
  loop.

  Fields:
    rate: Sampling rate: (0,1]
  """

  rate = _messages.FloatField(1)


class GoogleCloudAiplatformInternalSendHumanInTheLoopEntryOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  HumanInTheLoopService.SendHumanInTheLoopEntry

  Fields:
    genericMetadata: The operation generic information.
    labelingProgress: Output only. Current labeling job progress percentage
      scaled in interval [0, 100], indicating the percentage of DataItems that
      has been finished.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformInternalGenericOperationMetadata', 1)
  labelingProgress = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformInternalSendHumanInTheLoopEntryResponse(_messages.Message):
  r"""Response message for HumanInTheLoopService.SendHumanInTheLoopEntry

  Enums:
    StateValueValuesEnum: Output only. State of the sent entries.

  Fields:
    annotationSpecCount: Output only. The number of annotation specs used in
      this operation.
    currentSpend: Output only. Estimated cost(in US dollars) that the
      DataLabelingJob has incurred to date.
    dataItemCount: Output only. The number of data items that are labeled in
      this operation.
    exportedFiles: Output only. All of the files that are exported from export
      dataset.
    state: Output only. State of the sent entries.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the sent entries.

    Values:
      HUMAN_IN_THE_LOOP_ENTRY_STATE_UNSPECIFIED: Default, shall not be used.
      ENQUEUEING: The entry is being enqueued to a batch.
      WAITING_FOR_LABELING: The entry is in a batch waiting for a labeling job
        to be created.
      LABELING: The entry is in a labeling job and being labeled.
      FINISHING: The entry is labeled and the annotations are being collected
        and exported.
      FINISHED: The entry is labeled and the annotations are exported.
      FAILED: The entry failed.
    """
    HUMAN_IN_THE_LOOP_ENTRY_STATE_UNSPECIFIED = 0
    ENQUEUEING = 1
    WAITING_FOR_LABELING = 2
    LABELING = 3
    FINISHING = 4
    FINISHED = 5
    FAILED = 6

  annotationSpecCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  currentSpend = _messages.MessageField('GoogleTypeMoney', 2)
  dataItemCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  exportedFiles = _messages.StringField(4, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class GoogleCloudAiplatformUiAnnotationSpecStats(_messages.Message):
  r"""Stats of DataItems annotated by the specified AnnotationSpec and
  Annotations with the AnnotationSpec in a SavedQuery.

  Fields:
    annotationSpecDisplayName: Output only. The user-defined name of the
      AnnotationSpec.
    annotationSpecId: Output only. ID of an AnnotationSpec. Counters in the
      stats are for DataItems annotated by this anntoation spec and
      Annotations have this AnnotationSpec in the SavedQuery.
    annotationsCount: Output only. Count on Annotations with AnnotationSpec
      identified by annotation_spec_id.
    dataItemsCount: Output only. Count on DataItems that are annotated with
      the AnnotationSpec identified by annotation_spec_id.
    testAnnotationsCount: Output only. Count on Annotations with
      AnnotationSpec identified by annotation_spec_id and under all DataItems
      that match test_filter and do not match training_filter and
      validation_filter.
    testDataItemsCount: Output only. Count on DataItems that match test_filter
      and do not match training_filter and validation_filter and are annotated
      with the AnnotationSpec identified by annotation_spec_id.
    trainingAnnotationsCount: Output only. Count on Annotations with
      AnnotationSpec identified by annotation_spec_id and under all DataItems
      that match training_filter.
    trainingDataItemsCount: Output only. Count on DataItems that match
      training_filter and annotated with the AnnotationSpec identified by
      annotation_spec_id.
    validationAnnotationsCount: Output only. Count on Annotations with
      AnnotationSpec identified by annotation_spec_id and under all DataItems
      that match validation_filter and do not match training_filter.
    validationDataItemsCount: Output only. Count on DataItems that match
      validation_filter and do not match training_filter and are annotated
      with the AnnotationSpec identified by annotation_spec_id.
  """

  annotationSpecDisplayName = _messages.StringField(1)
  annotationSpecId = _messages.IntegerField(2)
  annotationsCount = _messages.IntegerField(3)
  dataItemsCount = _messages.IntegerField(4)
  testAnnotationsCount = _messages.IntegerField(5)
  testDataItemsCount = _messages.IntegerField(6)
  trainingAnnotationsCount = _messages.IntegerField(7)
  trainingDataItemsCount = _messages.IntegerField(8)
  validationAnnotationsCount = _messages.IntegerField(9)
  validationDataItemsCount = _messages.IntegerField(10)


class GoogleCloudAiplatformUiAutomaticResources(_messages.Message):
  r"""A description of resources that to large degree are decided by AI
  Platform, and require only a modest additional configuration. Each Model
  supporting these resources documents its specific guidelines.

  Fields:
    maxReplicaCount: Immutable. The maximum number of replicas this
      DeployedModel may be deployed on when the traffic against it increases.
      If requested value is too large, the deployment will error, but if
      deployment succeeds then the ability to scale the model to that many
      replicas is guaranteed (barring service outages). If traffic against the
      DeployedModel increases beyond what its replicas at maximum may handle,
      a portion of the traffic will be dropped. If this value is not provided,
      a no upper bound for scaling under heavy traffic will be assume, though
      AI Platform may be unable to scale beyond certain replica number.
    minReplicaCount: Immutable. The minimum number of replicas this
      DeployedModel will be always deployed on. If traffic against it
      increases, it may dynamically be deployed onto more replicas up to
      max_replica_count, and as traffic decreases, some of these extra
      replicas may be freed. If requested value is too large, the deployment
      will error.
  """

  maxReplicaCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiBatchMigrateResourcesOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  MigrationService.BatchMigrateResources.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiBatchMigrateResourcesResponse(_messages.Message):
  r"""Response message for MigrationService.BatchMigrateResources.

  Fields:
    migrateResourceResponses: Successfully migrated resources.
  """

  migrateResourceResponses = _messages.MessageField('GoogleCloudAiplatformUiMigrateResourceResponse', 1, repeated=True)


class GoogleCloudAiplatformUiCalculateSavedQueryStatsOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  DatasetService.CalculateSavedQueryStats.

  Fields:
    calculateStatsConfig: Whether calculate the stats by MlUse and the
      standard filters by MlUse.
    genericMetadata: The common part of the operation metadata.
  """

  calculateStatsConfig = _messages.MessageField('GoogleCloudAiplatformUiCalculateStatsConfig', 1)
  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 2)


class GoogleCloudAiplatformUiCalculateSavedQueryStatsResponse(_messages.Message):
  r"""Response message for DatasetService.CalculateSavedQueryStats.

  Fields:
    annotatedDataItemsCount: Count on DataItems that are annotated with at
      least one AnnotationSpec in this SavedQuery.
    annotationSpecStats: A list of per AnnotationSpec stats of the SavedQuery.
      This list contains stats of each AnnotationSpec that is associated with
      the SavedQuery even if there is no DataItem annotated with the
      AnnotationSpec.
    dataItemsCount: Count on DataItems in the SavedQuery.
    testDataItemsCount: Output only. Count on DataItems that match
      test_filter.
    trainingDataItemsCount: Output only. Count on DataItems that match
      training_filter.
    validationDataItemsCount: Output only. Count on DataItems that match
      validation_filter.
  """

  annotatedDataItemsCount = _messages.IntegerField(1)
  annotationSpecStats = _messages.MessageField('GoogleCloudAiplatformUiAnnotationSpecStats', 2, repeated=True)
  dataItemsCount = _messages.IntegerField(3)
  testDataItemsCount = _messages.IntegerField(4)
  trainingDataItemsCount = _messages.IntegerField(5)
  validationDataItemsCount = _messages.IntegerField(6)


class GoogleCloudAiplatformUiCalculateStatsConfig(_messages.Message):
  r"""Describes how the stats of a SavedQuery will be calculated.

  Fields:
    annotationFilter: A filter on Annotations. If this field is set, all of
      the stats will be restricted to the DataItems with the Annotations that
      match this filter. Supported filter: `data_labeling_job_id` - for =.
      Filters by the specified data_labeling_job.
    testFilter: A filter on DataItems of the Dataset. Test set stats will be
      calculated from DataItems that match this filter and does not match the
      filters specified in training_filter and validation_filter. The filter
      only support filtering by at most one resource label.
    trainingFilter: A filter on DataItems of the Dataset. Training set stats
      will be calculated from DataItems that match this filter. The filter
      only support filtering by at most one resource label.
    validationFilter: A filter on DataItems of the Dataset. Validation set
      stats will be calculated from DataItems that match this filter and does
      not match the filter specified in training_filter. The filter only
      support filtering by at most one resource label.
  """

  annotationFilter = _messages.StringField(1)
  testFilter = _messages.StringField(2)
  trainingFilter = _messages.StringField(3)
  validationFilter = _messages.StringField(4)


class GoogleCloudAiplatformUiCreateDatasetOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.CreateDataset.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiCreateEndpointOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.CreateEndpoint.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiCreateSpecialistPoolOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  SpecialistPoolService.CreateSpecialistPool.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiDataLabelingJobRef(_messages.Message):
  r"""DataLabelingJob's names needed by SpecialistPools it associates with.

  Fields:
    dataLabelingJob: Output only. Resource name of the DataLabelingJob, same
      as DataLabelingJob.name.
    dataLabelingJobDisplayName: Output only. The user-defined name of the
      DataLabelingJob, same as DataLabelingJob.display_name.
    dataLabelingJobObjective: Output only. The objective of the
      DataLabelingJob, same as SavedQuery.problem_type.
    dataLabelingJobProgress: Output only. The progress of the DataLabelingJob,
      same as DataLabelingJob.labeling_progress.
  """

  dataLabelingJob = _messages.StringField(1)
  dataLabelingJobDisplayName = _messages.StringField(2)
  dataLabelingJobObjective = _messages.StringField(3)
  dataLabelingJobProgress = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiDedicatedResources(_messages.Message):
  r"""A description of resources that are dedicated to a DeployedModel, and
  that need a higher degree of manual configuration.

  Fields:
    machineSpec: Required. Immutable. The specification of a single machine
      used by the prediction.
    maxReplicaCount: Immutable. The maximum number of replicas this
      DeployedModel may be deployed on when the traffic against it increases.
      If requested value is too large, the deployment will error, but if
      deployment succeeds then the ability to scale the model to that many
      replicas is guaranteed (barring service outages). If traffic against the
      DeployedModel increases beyond what its replicas at maximum may handle,
      a portion of the traffic will be dropped. If this value is not provided,
      will use min_replica_count as the default value.
    minReplicaCount: Required. Immutable. The minimum number of machine
      replicas this DeployedModel will be always deployed on. If traffic
      against it increases, it may dynamically be deployed onto more replicas,
      and as traffic decreases, some of these extra replicas may be freed.
      Note: if machine_spec.accelerator_count is above 0, currently the model
      will be always deployed precisely on min_replica_count.
  """

  machineSpec = _messages.MessageField('GoogleCloudAiplatformUiMachineSpec', 1)
  maxReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  minReplicaCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiDeleteOperationMetadata(_messages.Message):
  r"""Details of operations that perform deletes of any entities.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiDeployModelOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.DeployModel.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiDeployModelResponse(_messages.Message):
  r"""Response message for EndpointService.DeployModel.

  Fields:
    deployedModel: The DeployedModel that had been deployed in the Endpoint.
  """

  deployedModel = _messages.MessageField('GoogleCloudAiplatformUiDeployedModel', 1)


class GoogleCloudAiplatformUiDeployedModel(_messages.Message):
  r"""A deployment of a Model. Endpoints contain one or more DeployedModels.

  Enums:
    UiStateValueValuesEnum: Output only. The state of the model deployment.
      Different from public API, BEING_DEPLOYED and FAILED deployment state
      model will also be returned in Ui ListEndpoints.

  Fields:
    automaticResources: A description of resources that to large degree are
      decided by AI Platform, and require only a modest additional
      configuration.
    createTime: Output only. Timestamp when the DeployedModel was created.
    dedicatedResources: A description of resources that are dedicated to the
      DeployedModel, and that need a higher degree of manual configuration.
    displayName: The display name of the DeployedModel. If not provided upon
      creation, the Model's display_name is used.
    enableAccessLogging: These logs are like standard server access logs,
      containing information like timestamp and latency for each prediction
      request. Note that Stackdriver logs may incur a cost, especially if your
      project receives prediction requests at a high queries per second rate
      (QPS). Estimate your costs before enabling this option.
    enableContainerLogging: If true, the container of the DeployedModel
      instances will send `stderr` and `stdout` streams to Stackdriver
      Logging. Only supported for custom-trained Models and AutoML Tables
      Models.
    explanationSpec: Explanation configuration for this DeployedModel. When
      deploying a Model using EndpointService.DeployModel, this value
      overrides the value of Model.explanation_spec. All fields of
      explanation_spec are optional in the request. If a field of
      explanation_spec is not populated, the value of the same field of
      Model.explanation_spec is inherited. The corresponding
      Model.explanation_spec must be populated, otherwise explanation for this
      Model is not allowed.
    id: Output only. The ID of the DeployedModel.
    model: Required. The name of the Model this is the deployment of. Note
      that the Model may be in a different location than the DeployedModel's
      Endpoint.
    modelDisplayName: Output only. The display name of the Model this
      DeployedModel was created from.
    modelObjective: Output only. The objective of the Model this DeployedModel
      was created from.
    serviceAccount: The service account that the DeployedModel's container
      runs as. Specify the email address of the service account. If this
      service account is not specified, the container runs as a service
      account that doesn't have access to the resource project. Users
      deploying the Model must have the `iam.serviceAccounts.actAs` permission
      on this service account.
    uiState: Output only. The state of the model deployment. Different from
      public API, BEING_DEPLOYED and FAILED deployment state model will also
      be returned in Ui ListEndpoints.
  """

  class UiStateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the model deployment. Different from public
    API, BEING_DEPLOYED and FAILED deployment state model will also be
    returned in Ui ListEndpoints.

    Values:
      UI_DEPLOYMENT_STATE_UNSPECIFIED: Should not be used.
      UI_DEPLOYMENT_STATE_BEING_DEPLOYED: The deployment of the model is
        ongoing and not ready for use yet. The resource is not usable at this
        state.
      UI_DEPLOYMENT_STATE_DEPLOYED: The model is deployed.
      UI_DEPLOYMENT_STATE_BEING_UNDEPLOYED: The model is being undeployed. The
        resource is not usable at this state.
      UI_DEPLOYMENT_STATE_FAILED: The model is failed to deploy or undeploy.
        The resource is not usable at this state.
    """
    UI_DEPLOYMENT_STATE_UNSPECIFIED = 0
    UI_DEPLOYMENT_STATE_BEING_DEPLOYED = 1
    UI_DEPLOYMENT_STATE_DEPLOYED = 2
    UI_DEPLOYMENT_STATE_BEING_UNDEPLOYED = 3
    UI_DEPLOYMENT_STATE_FAILED = 4

  automaticResources = _messages.MessageField('GoogleCloudAiplatformUiAutomaticResources', 1)
  createTime = _messages.StringField(2)
  dedicatedResources = _messages.MessageField('GoogleCloudAiplatformUiDedicatedResources', 3)
  displayName = _messages.StringField(4)
  enableAccessLogging = _messages.BooleanField(5)
  enableContainerLogging = _messages.BooleanField(6)
  explanationSpec = _messages.MessageField('GoogleCloudAiplatformUiExplanationSpec', 7)
  id = _messages.StringField(8)
  model = _messages.StringField(9)
  modelDisplayName = _messages.StringField(10)
  modelObjective = _messages.StringField(11)
  serviceAccount = _messages.StringField(12)
  uiState = _messages.EnumField('UiStateValueValuesEnum', 13)


class GoogleCloudAiplatformUiExplanationMetadata(_messages.Message):
  r"""Metadata describing the Model's input and output for explanation.

  Messages:
    InputsValue: Required. Map from feature names to feature input metadata.
      Keys are the name of the features. Values are the specification of the
      feature. An empty InputMetadata is valid. It describes a text feature
      which has the name specified as the key in ExplanationMetadata.inputs.
      The baseline of the empty feature is chosen by AI Platform. For AI
      Platform provided Tensorflow images, the key can be any friendly name of
      the feature. Once specified, featureAttributions are keyed by this key
      (if not grouped with another feature). For custom images, the key must
      match with the key in instance.
    OutputsValue: Required. Map from output names to output metadata. For AI
      Platform provided Tensorflow images, keys can be any string user
      defines. For custom images, keys are the name of the output field in the
      prediction to be explained. Currently only one key is allowed.

  Fields:
    featureAttributionsSchemaUri: Points to a YAML file stored on Google Cloud
      Storage describing the format of the feature attributions. The schema is
      defined as an OpenAPI 3.0.2 [Schema
      Object](https://tinyurl.com/y538mdwt#schema-object). AutoML tabular
      Models always have this field populated by AI Platform. Note: The URI
      given on output may be different, including the URI scheme, than the one
      given on input. The output URI will point to a location where the user
      only has a read access.
    inputs: Required. Map from feature names to feature input metadata. Keys
      are the name of the features. Values are the specification of the
      feature. An empty InputMetadata is valid. It describes a text feature
      which has the name specified as the key in ExplanationMetadata.inputs.
      The baseline of the empty feature is chosen by AI Platform. For AI
      Platform provided Tensorflow images, the key can be any friendly name of
      the feature. Once specified, featureAttributions are keyed by this key
      (if not grouped with another feature). For custom images, the key must
      match with the key in instance.
    outputs: Required. Map from output names to output metadata. For AI
      Platform provided Tensorflow images, keys can be any string user
      defines. For custom images, keys are the name of the output field in the
      prediction to be explained. Currently only one key is allowed.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InputsValue(_messages.Message):
    r"""Required. Map from feature names to feature input metadata. Keys are
    the name of the features. Values are the specification of the feature. An
    empty InputMetadata is valid. It describes a text feature which has the
    name specified as the key in ExplanationMetadata.inputs. The baseline of
    the empty feature is chosen by AI Platform. For AI Platform provided
    Tensorflow images, the key can be any friendly name of the feature. Once
    specified, featureAttributions are keyed by this key (if not grouped with
    another feature). For custom images, the key must match with the key in
    instance.

    Messages:
      AdditionalProperty: An additional property for a InputsValue object.

    Fields:
      additionalProperties: Additional properties of type InputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformUiExplanationMetadataInputMetadata
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformUiExplanationMetadataInputMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OutputsValue(_messages.Message):
    r"""Required. Map from output names to output metadata. For AI Platform
    provided Tensorflow images, keys can be any string user defines. For
    custom images, keys are the name of the output field in the prediction to
    be explained. Currently only one key is allowed.

    Messages:
      AdditionalProperty: An additional property for a OutputsValue object.

    Fields:
      additionalProperties: Additional properties of type OutputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OutputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformUiExplanationMetadataOutputMetadata
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformUiExplanationMetadataOutputMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  featureAttributionsSchemaUri = _messages.StringField(1)
  inputs = _messages.MessageField('InputsValue', 2)
  outputs = _messages.MessageField('OutputsValue', 3)


class GoogleCloudAiplatformUiExplanationMetadataInputMetadata(_messages.Message):
  r"""Metadata of the input of a feature. Fields other than
  InputMetadata.input_baselines are applicable only for Models that are using
  AI Platform-provided images for Tensorflow.

  Enums:
    EncodingValueValuesEnum: Defines how the feature is encoded into the input
      tensor. Defaults to IDENTITY.

  Fields:
    denseShapeTensorName: Specifies the shape of the values of the input if
      the input is a sparse representation. Refer to Tensorflow documentation
      for more details:
      https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
    encodedBaselines: A list of baselines for the encoded tensor. The shape of
      each baseline should match the shape of the encoded tensor. If a scalar
      is provided, AI Platform broadcast to the same shape as the encoded
      tensor.
    encodedTensorName: Encoded tensor is a transformation of the input tensor.
      Must be provided if choosing Integrated Gradients attribution or XRAI
      attribution and the input tensor is not differentiable. An encoded
      tensor is generated if the input tensor is encoded by a lookup table.
    encoding: Defines how the feature is encoded into the input tensor.
      Defaults to IDENTITY.
    featureValueDomain: The domain details of the input feature value. Like
      min/max, original mean or standard deviation if normalized.
    groupName: Name of the group that the input belongs to. Features with the
      same group name will be treated as one feature when computing
      attributions. Features grouped together can have different shapes in
      value. If provided, there will be one single attribution generated in
      featureAttributions, keyed by the group name.
    indexFeatureMapping: A list of feature names for each index in the input
      tensor. Required when the input InputMetadata.encoding is
      BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
    indicesTensorName: Specifies the index of the values of the input tensor.
      Required when the input tensor is a sparse representation. Refer to
      Tensorflow documentation for more details:
      https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
    inputBaselines: Baseline inputs for this feature. If no baseline is
      specified, AI Platform chooses the baseline for this feature. If
      multiple baselines are specified, AI Platform returns the average
      attributions across them in Attributions.baseline_attribution. For AI
      Platform provided Tensorflow images (both 1.x and 2.x), the shape of
      each baseline must match the shape of the input tensor. If a scalar is
      provided, we broadcast to the same shape as the input tensor. For custom
      images, the element of the baselines must be in the same format as the
      feature's input in the instance[]. The schema of any single instance may
      be specified via Endpoint's DeployedModels' Model's PredictSchemata's
      instance_schema_uri.
    inputTensorName: Name of the input tensor for this feature. Required and
      is only applicable to AI Platform provided images for Tensorflow.
    modality: Modality of the feature. Valid values are: numeric, image.
      Defaults to numeric.
    visualization: Visualization configurations for image explanation.
  """

  class EncodingValueValuesEnum(_messages.Enum):
    r"""Defines how the feature is encoded into the input tensor. Defaults to
    IDENTITY.

    Values:
      ENCODING_UNSPECIFIED: Default value. This is the same as IDENTITY.
      IDENTITY: The tensor represents one feature.
      BAG_OF_FEATURES: The tensor represents a bag of features where each
        index maps to a feature. InputMetadata.index_feature_mapping must be
        provided for this encoding. For example: ``` input = [27, 6.0, 150]
        index_feature_mapping = ["age", "height", "weight"] ```
      BAG_OF_FEATURES_SPARSE: The tensor represents a bag of features where
        each index maps to a feature. Zero values in the tensor indicates
        feature being non-existent. InputMetadata.index_feature_mapping must
        be provided for this encoding. For example: ``` input = [2, 0, 5, 0,
        1] index_feature_mapping = ["a", "b", "c", "d", "e"] ```
      INDICATOR: The tensor is a list of binaries representing whether a
        feature exists or not (1 indicates existence).
        InputMetadata.index_feature_mapping must be provided for this
        encoding. For example: ``` input = [1, 0, 1, 0, 1]
        index_feature_mapping = ["a", "b", "c", "d", "e"] ```
      COMBINED_EMBEDDING: The tensor is encoded into a 1-dimensional array
        represented by an encoded tensor. InputMetadata.encoded_tensor_name
        must be provided for this encoding. For example: ``` input = ["This",
        "is", "a", "test", "."] encoded = [0.1, 0.2, 0.3, 0.4, 0.5] ```
      CONCAT_EMBEDDING: Select this encoding when the input tensor is encoded
        into a 2-dimensional array represented by an encoded tensor.
        InputMetadata.encoded_tensor_name must be provided for this encoding.
        The first dimension of the encoded tensor's shape is the same as the
        input tensor's shape. For example: ``` input = ["This", "is", "a",
        "test", "."] encoded = [[0.1, 0.2, 0.3, 0.4, 0.5], [0.2, 0.1, 0.4,
        0.3, 0.5], [0.5, 0.1, 0.3, 0.5, 0.4], [0.5, 0.3, 0.1, 0.2, 0.4], [0.4,
        0.3, 0.2, 0.5, 0.1]] ```
    """
    ENCODING_UNSPECIFIED = 0
    IDENTITY = 1
    BAG_OF_FEATURES = 2
    BAG_OF_FEATURES_SPARSE = 3
    INDICATOR = 4
    COMBINED_EMBEDDING = 5
    CONCAT_EMBEDDING = 6

  denseShapeTensorName = _messages.StringField(1)
  encodedBaselines = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)
  encodedTensorName = _messages.StringField(3)
  encoding = _messages.EnumField('EncodingValueValuesEnum', 4)
  featureValueDomain = _messages.MessageField('GoogleCloudAiplatformUiExplanationMetadataInputMetadataFeatureValueDomain', 5)
  groupName = _messages.StringField(6)
  indexFeatureMapping = _messages.StringField(7, repeated=True)
  indicesTensorName = _messages.StringField(8)
  inputBaselines = _messages.MessageField('extra_types.JsonValue', 9, repeated=True)
  inputTensorName = _messages.StringField(10)
  modality = _messages.StringField(11)
  visualization = _messages.MessageField('GoogleCloudAiplatformUiExplanationMetadataInputMetadataVisualization', 12)


class GoogleCloudAiplatformUiExplanationMetadataInputMetadataFeatureValueDomain(_messages.Message):
  r"""Domain details of the input feature value. Provides numeric information
  about the feature, such as its range (min, max). If the feature has been
  pre-processed, for example with z-scoring, then it provides information
  about how to recover the original feature. For example, if the input feature
  is an image and it has been pre-processed to obtain 0-mean and stddev = 1
  values, then original_mean, and original_stddev refer to the mean and stddev
  of the original feature (e.g. image tensor) from which input feature (with
  mean = 0 and stddev = 1) was obtained.

  Fields:
    maxValue: The maximum permissible value for this feature.
    minValue: The minimum permissible value for this feature.
    originalMean: If this input feature has been normalized to a mean value of
      0, the original_mean specifies the mean value of the domain prior to
      normalization.
    originalStddev: If this input feature has been normalized to a standard
      deviation of 1.0, the original_stddev specifies the standard deviation
      of the domain prior to normalization.
  """

  maxValue = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  minValue = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  originalMean = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  originalStddev = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformUiExplanationMetadataInputMetadataVisualization(_messages.Message):
  r"""Visualization configurations for image explanation.

  Enums:
    ColorMapValueValuesEnum: The color scheme used for the highlighted areas.
      Defaults to PINK_GREEN for Integrated Gradients attribution, which shows
      positive attributions in green and negative in pink. Defaults to VIRIDIS
      for XRAI attribution, which highlights the most influential regions in
      yellow and the least influential in blue.
    OverlayTypeValueValuesEnum: How the original image is displayed in the
      visualization. Adjusting the overlay can help increase visual clarity if
      the original image makes it difficult to view the visualization.
      Defaults to NONE.
    PolarityValueValuesEnum: Whether to only highlight pixels with positive
      contributions, negative or both. Defaults to POSITIVE.
    TypeValueValuesEnum: Type of the image visualization. Only applicable to
      Integrated Gradients attribution. OUTLINES shows regions of attribution,
      while PIXELS shows per-pixel attribution. Defaults to OUTLINES.

  Fields:
    clipPercentLowerbound: Excludes attributions below the specified
      percentile, from the highlighted areas. Defaults to 35.
    clipPercentUpperbound: Excludes attributions above the specified
      percentile from the highlighted areas. Using the clip_percent_upperbound
      and clip_percent_lowerbound together can be useful for filtering out
      noise and making it easier to see areas of strong attribution. Defaults
      to 99.9.
    colorMap: The color scheme used for the highlighted areas. Defaults to
      PINK_GREEN for Integrated Gradients attribution, which shows positive
      attributions in green and negative in pink. Defaults to VIRIDIS for XRAI
      attribution, which highlights the most influential regions in yellow and
      the least influential in blue.
    overlayType: How the original image is displayed in the visualization.
      Adjusting the overlay can help increase visual clarity if the original
      image makes it difficult to view the visualization. Defaults to NONE.
    polarity: Whether to only highlight pixels with positive contributions,
      negative or both. Defaults to POSITIVE.
    type: Type of the image visualization. Only applicable to Integrated
      Gradients attribution. OUTLINES shows regions of attribution, while
      PIXELS shows per-pixel attribution. Defaults to OUTLINES.
  """

  class ColorMapValueValuesEnum(_messages.Enum):
    r"""The color scheme used for the highlighted areas. Defaults to
    PINK_GREEN for Integrated Gradients attribution, which shows positive
    attributions in green and negative in pink. Defaults to VIRIDIS for XRAI
    attribution, which highlights the most influential regions in yellow and
    the least influential in blue.

    Values:
      COLOR_MAP_UNSPECIFIED: Should not be used.
      PINK_GREEN: Positive: green. Negative: pink.
      VIRIDIS: Viridis color map: A perceptually uniform color mapping which
        is easier to see by those with colorblindness and progresses from
        yellow to green to blue. Positive: yellow. Negative: blue.
      RED: Positive: red. Negative: red.
      GREEN: Positive: green. Negative: green.
      RED_GREEN: Positive: green. Negative: red.
      PINK_WHITE_GREEN: PiYG palette.
    """
    COLOR_MAP_UNSPECIFIED = 0
    PINK_GREEN = 1
    VIRIDIS = 2
    RED = 3
    GREEN = 4
    RED_GREEN = 5
    PINK_WHITE_GREEN = 6

  class OverlayTypeValueValuesEnum(_messages.Enum):
    r"""How the original image is displayed in the visualization. Adjusting
    the overlay can help increase visual clarity if the original image makes
    it difficult to view the visualization. Defaults to NONE.

    Values:
      OVERLAY_TYPE_UNSPECIFIED: Default value. This is the same as NONE.
      NONE: No overlay.
      ORIGINAL: The attributions are shown on top of the original image.
      GRAYSCALE: The attributions are shown on top of grayscaled version of
        the original image.
      MASK_BLACK: The attributions are used as a mask to reveal predictive
        parts of the image and hide the un-predictive parts.
    """
    OVERLAY_TYPE_UNSPECIFIED = 0
    NONE = 1
    ORIGINAL = 2
    GRAYSCALE = 3
    MASK_BLACK = 4

  class PolarityValueValuesEnum(_messages.Enum):
    r"""Whether to only highlight pixels with positive contributions, negative
    or both. Defaults to POSITIVE.

    Values:
      POLARITY_UNSPECIFIED: Default value. This is the same as POSITIVE.
      POSITIVE: Highlights the pixels/outlines that were most influential to
        the model's prediction.
      NEGATIVE: Setting polarity to negative highlights areas that does not
        lead to the models's current prediction.
      BOTH: Shows both positive and negative attributions.
    """
    POLARITY_UNSPECIFIED = 0
    POSITIVE = 1
    NEGATIVE = 2
    BOTH = 3

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of the image visualization. Only applicable to Integrated
    Gradients attribution. OUTLINES shows regions of attribution, while PIXELS
    shows per-pixel attribution. Defaults to OUTLINES.

    Values:
      TYPE_UNSPECIFIED: Should not be used.
      PIXELS: Shows which pixel contributed to the image prediction.
      OUTLINES: Shows which region contributed to the image prediction by
        outlining the region.
    """
    TYPE_UNSPECIFIED = 0
    PIXELS = 1
    OUTLINES = 2

  clipPercentLowerbound = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  clipPercentUpperbound = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  colorMap = _messages.EnumField('ColorMapValueValuesEnum', 3)
  overlayType = _messages.EnumField('OverlayTypeValueValuesEnum', 4)
  polarity = _messages.EnumField('PolarityValueValuesEnum', 5)
  type = _messages.EnumField('TypeValueValuesEnum', 6)


class GoogleCloudAiplatformUiExplanationMetadataOutputMetadata(_messages.Message):
  r"""Metadata of the prediction output to be explained.

  Fields:
    displayNameMappingKey: Specify a field name in the prediction to look for
      the display name. Use this if the prediction contains the display names
      for the outputs. The display names in the prediction must have the same
      shape of the outputs, so that it can be located by
      Attribution.output_index for a specific output.
    indexDisplayNameMapping: Static mapping between the index and display
      name. Use this if the outputs are a deterministic n-dimensional array,
      e.g. a list of scores of all the classes in a pre-defined order for a
      multi-classification Model. It's not feasible if the outputs are non-
      deterministic, e.g. the Model produces top-k classes or sort the outputs
      by their values. The shape of the value must be an n-dimensional array
      of strings. The number of dimentions must match that of the outputs to
      be explained. The Attribution.output_display_name is populated by
      locating in the mapping with Attribution.output_index.
    outputTensorName: Name of the output tensor. Required and is only
      applicable to AI Platform provided images for Tensorflow.
  """

  displayNameMappingKey = _messages.StringField(1)
  indexDisplayNameMapping = _messages.MessageField('extra_types.JsonValue', 2)
  outputTensorName = _messages.StringField(3)


class GoogleCloudAiplatformUiExplanationParameters(_messages.Message):
  r"""Parameters to configure explaining for Model's predictions.

  Fields:
    integratedGradientsAttribution: An attribution method that computes
      Aumann-Shapley values taking advantage of the model's fully
      differentiable structure. Refer to this paper for more details:
      https://arxiv.org/abs/1703.01365
    outputIndices: If populated, only returns attributions that have
      output_index contained in output_indices. It must be an ndarray of
      integers, with the same shape of the output it's explaining. If not
      populated, returns attributions for top_k indices of outputs. If neither
      top_k nor output_indeices is populated, returns the argmax index of the
      outputs. Only applicable to Models that predict multiple outputs (e,g,
      multi-class Models that predict multiple classes).
    sampledShapleyAttribution: An attribution method that approximates Shapley
      values for features that contribute to the label being predicted. A
      sampling strategy is used to approximate the value rather than
      considering all subsets of features. Refer to this paper for model
      details: https://arxiv.org/abs/1306.4265.
    topK: If populated, returns attributions for top K indices of outputs
      (defaults to 1). Only applies to Models that predicts more than one
      outputs (e,g, multi-class Models). When set to -1, returns explanations
      for all outputs.
    xraiAttribution: An attribution method that redistributes Integrated
      Gradients attribution to segmented regions, taking advantage of the
      model's fully differentiable structure. Refer to this paper for more
      details: https://arxiv.org/abs/1906.02825 XRAI currently performs better
      on natural images, like a picture of a house or an animal. If the images
      are taken in artificial environments, like a lab or manufacturing line,
      or from diagnostic equipment, like x-rays or quality-control cameras,
      use Integrated Gradients instead.
  """

  integratedGradientsAttribution = _messages.MessageField('GoogleCloudAiplatformUiIntegratedGradientsAttribution', 1)
  outputIndices = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)
  sampledShapleyAttribution = _messages.MessageField('GoogleCloudAiplatformUiSampledShapleyAttribution', 3)
  topK = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  xraiAttribution = _messages.MessageField('GoogleCloudAiplatformUiXraiAttribution', 5)


class GoogleCloudAiplatformUiExplanationSpec(_messages.Message):
  r"""Specification of Model explanation.

  Fields:
    metadata: Required. Metadata describing the Model's input and output for
      explanation.
    parameters: Required. Parameters that configure explaining of the Model's
      predictions.
  """

  metadata = _messages.MessageField('GoogleCloudAiplatformUiExplanationMetadata', 1)
  parameters = _messages.MessageField('GoogleCloudAiplatformUiExplanationParameters', 2)


class GoogleCloudAiplatformUiExportDataOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.ExportData.

  Fields:
    gcsOutputDirectory: A Google Cloud Storage directory which path ends with
      '/'. The exported data is stored in the directory.
    genericMetadata: The common part of the operation metadata.
  """

  gcsOutputDirectory = _messages.StringField(1)
  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 2)


class GoogleCloudAiplatformUiExportDataResponse(_messages.Message):
  r"""Response message for DatasetService.ExportData.

  Fields:
    exportedFiles: All of the files that are exported in this export
      operation.
  """

  exportedFiles = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformUiExportEvaluatedDataItemsOperationMetadata(_messages.Message):
  r"""Details of ModelService.ExportEvaluatedDataItems operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
    outputInfo: Output only. Information further describing the output of this
      operation.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)
  outputInfo = _messages.MessageField('GoogleCloudAiplatformUiExportEvaluatedDataItemsOperationMetadataOutputInfo', 2)


class GoogleCloudAiplatformUiExportEvaluatedDataItemsOperationMetadataOutputInfo(_messages.Message):
  r"""Further describes this operation's output. Supplements
  ExportEvaluatedDataItemsRequest.output_config.

  Fields:
    bigqueryOutputDataset: Output only. The path of the BigQuery dataset
      created, in bq://projectId.bqDatasetId.tableId format, into which the
      evaluated DataItems are exported.
  """

  bigqueryOutputDataset = _messages.StringField(1)


class GoogleCloudAiplatformUiExportEvaluatedDataItemsOperationResponse(_messages.Message):
  r"""Response of ModelService.ExportEvaluatedDataItems operation."""


class GoogleCloudAiplatformUiExportModelOperationMetadata(_messages.Message):
  r"""Details of ModelService.ExportModel operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
    outputInfo: Output only. Information further describing the output of this
      Model export.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)
  outputInfo = _messages.MessageField('GoogleCloudAiplatformUiExportModelOperationMetadataOutputInfo', 2)


class GoogleCloudAiplatformUiExportModelOperationMetadataOutputInfo(_messages.Message):
  r"""Further describes the output of the ExportModel. Supplements
  ExportModelRequest.OutputConfig.

  Fields:
    artifactOutputUri: Output only. If the Model artifact is being exported to
      Google Cloud Storage this is the full path of the directory created,
      into which the Model files are being written to.
    gcsOutputDirectory: Output only. If the Model is being exported to Google
      Cloud Storage this is the full path of the directory created, into which
      the Model files are being written to.
    imageOutputUri: Output only. If the Model image is being exported to
      Google Container Registry or Artifact Registry this is the full path of
      the image created.
  """

  artifactOutputUri = _messages.StringField(1)
  gcsOutputDirectory = _messages.StringField(2)
  imageOutputUri = _messages.StringField(3)


class GoogleCloudAiplatformUiExportModelResponse(_messages.Message):
  r"""Response message of ModelService.ExportModel operation."""


class GoogleCloudAiplatformUiFeatureNoiseSigma(_messages.Message):
  r"""Noise sigma by features. Noise sigma represents the standard deviation
  of the gaussian kernel that will be used to add noise to interpolated inputs
  prior to computing gradients.

  Fields:
    noiseSigma: Noise sigma per feature. No noise is added to features that
      are not set.
  """

  noiseSigma = _messages.MessageField('GoogleCloudAiplatformUiFeatureNoiseSigmaNoiseSigmaForFeature', 1, repeated=True)


class GoogleCloudAiplatformUiFeatureNoiseSigmaNoiseSigmaForFeature(_messages.Message):
  r"""Noise sigma for a single feature.

  Fields:
    name: The name of the input feature for which noise sigma is provided. The
      features are defined in explanation metadata inputs.
    sigma: This represents the standard deviation of the Gaussian kernel that
      will be used to add noise to the feature prior to computing gradients.
      Similar to noise_sigma but represents the noise added to the current
      feature. Defaults to 0.1.
  """

  name = _messages.StringField(1)
  sigma = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformUiGenerateDatasetStatsOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.GenerateDatasetStats.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiGenerateDatasetStatsResponse(_messages.Message):
  r"""Response message for DatasetService.GenerateDatasetStats."""


class GoogleCloudAiplatformUiGenericOperationMetadata(_messages.Message):
  r"""Generic Metadata shared by all operations.

  Enums:
    StateValueValuesEnum: Output only. Used only when Operation.done field is
      false. This field can indicate the pending state of operation and will
      be set to DONE when operation is done.

  Fields:
    cancellable: Output only. True if operation can be cancelled. If false,
      calling CancelOperation will return UNIMPLEMENTED error.
    createTime: Output only. Time when the operation was created.
    partialFailures: Output only. Partial failures encountered. E.g. single
      files that couldn't be read. This field should never exceed 20 entries.
      Status details field will contain standard GCP error details.
    state: Output only. Used only when Operation.done field is false. This
      field can indicate the pending state of operation and will be set to
      DONE when operation is done.
    updateTime: Output only. Time when the operation was updated for the last
      time. If the operation has finished (successfully or not), this is the
      finish time.
    worksOn: Output only. List of resource names that the operation is working
      on.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Used only when Operation.done field is false. This field
    can indicate the pending state of operation and will be set to DONE when
    operation is done.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      RUNNING: Operation is still running.
      CANCELLING: Operation is being cancelled.
      DONE: Operation is done.
    """
    STATE_UNSPECIFIED = 0
    RUNNING = 1
    CANCELLING = 2
    DONE = 3

  cancellable = _messages.BooleanField(1)
  createTime = _messages.StringField(2)
  partialFailures = _messages.MessageField('GoogleRpcStatus', 3, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  updateTime = _messages.StringField(5)
  worksOn = _messages.StringField(6, repeated=True)


class GoogleCloudAiplatformUiImportDataOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.ImportData.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiImportDataResponse(_messages.Message):
  r"""Response message for DatasetService.ImportData."""


class GoogleCloudAiplatformUiIntegratedGradientsAttribution(_messages.Message):
  r"""An attribution method that computes the Aumann-Shapley value taking
  advantage of the model's fully differentiable structure. Refer to this paper
  for more details: https://arxiv.org/abs/1703.01365

  Fields:
    smoothGradConfig: Config for SmoothGrad approximation of gradients. When
      enabled, the gradients are approximated by averaging the gradients from
      noisy samples in the vicinity of the inputs. Adding noise can help
      improve the computed gradients. Refer to this paper for more details:
      https://arxiv.org/pdf/1706.03825.pdf
    stepCount: Required. The number of steps for approximating the path
      integral. A good value to start is 50 and gradually increase until the
      sum to diff property is within the desired error range. Valid range of
      its value is [1, 100], inclusively.
  """

  smoothGradConfig = _messages.MessageField('GoogleCloudAiplatformUiSmoothGradConfig', 1)
  stepCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiMachineSpec(_messages.Message):
  r"""Specification of a single machine.

  Enums:
    AcceleratorTypeValueValuesEnum: Immutable. The type of accelerator(s) that
      may be attached to the machine as per accelerator_count.

  Fields:
    acceleratorCount: The number of accelerators to attach to the machine.
    acceleratorType: Immutable. The type of accelerator(s) that may be
      attached to the machine as per accelerator_count.
    machineType: Immutable. The type of the machine. For the machine types
      supported for prediction, see https://tinyurl.com/aip-
      docs/predictions/machine-types. For machine types supported for creating
      a custom training job, see https://tinyurl.com/aip-
      docs/training/configure-compute. For DeployedModel this field is
      optional, and the default value is `n1-standard-2`. For
      BatchPredictionJob or as part of WorkerPoolSpec this field is required.
  """

  class AcceleratorTypeValueValuesEnum(_messages.Enum):
    r"""Immutable. The type of accelerator(s) that may be attached to the
    machine as per accelerator_count.

    Values:
      ACCELERATOR_TYPE_UNSPECIFIED: Unspecified accelerator type, which means
        no accelerator.
      NVIDIA_TESLA_K80: Nvidia Tesla K80 GPU.
      NVIDIA_TESLA_P100: Nvidia Tesla P100 GPU.
      NVIDIA_TESLA_V100: Nvidia Tesla V100 GPU.
      NVIDIA_TESLA_P4: Nvidia Tesla P4 GPU.
      NVIDIA_TESLA_T4: Nvidia Tesla T4 GPU.
      TPU_V2: TPU v2.
      TPU_V3: TPU v3.
    """
    ACCELERATOR_TYPE_UNSPECIFIED = 0
    NVIDIA_TESLA_K80 = 1
    NVIDIA_TESLA_P100 = 2
    NVIDIA_TESLA_V100 = 3
    NVIDIA_TESLA_P4 = 4
    NVIDIA_TESLA_T4 = 5
    TPU_V2 = 6
    TPU_V3 = 7

  acceleratorCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  acceleratorType = _messages.EnumField('AcceleratorTypeValueValuesEnum', 2)
  machineType = _messages.StringField(3)


class GoogleCloudAiplatformUiMigratableResource(_messages.Message):
  r"""Represents one resource that exists in automl.googleapis.com,
  datalabeling.googleapis.com or ml.googleapis.com.

  Fields:
    automlDataset: Output only. Represents one Dataset in
      automl.googleapis.com.
    automlModel: Output only. Represents one Model in automl.googleapis.com.
    dataLabelingDataset: Output only. Represents one Dataset in
      datalabeling.googleapis.com.
    lastMigrateTime: Output only. Timestamp when last migrate attempt on this
      MigratableResource started. Will not be set if there's no migrate
      attempt on this MigratableResource.
    lastUpdateTime: Output only. Timestamp when this MigratableResource was
      last updated.
    mlEngineModelVersion: Output only. Represents one Version in
      ml.googleapis.com.
  """

  automlDataset = _messages.MessageField('GoogleCloudAiplatformUiMigratableResourceAutomlDataset', 1)
  automlModel = _messages.MessageField('GoogleCloudAiplatformUiMigratableResourceAutomlModel', 2)
  dataLabelingDataset = _messages.MessageField('GoogleCloudAiplatformUiMigratableResourceDataLabelingDataset', 3)
  lastMigrateTime = _messages.StringField(4)
  lastUpdateTime = _messages.StringField(5)
  mlEngineModelVersion = _messages.MessageField('GoogleCloudAiplatformUiMigratableResourceMlEngineModelVersion', 6)


class GoogleCloudAiplatformUiMigratableResourceAutomlDataset(_messages.Message):
  r"""Represents one Dataset in automl.googleapis.com.

  Fields:
    dataset: Full resource name of automl Dataset. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`.
    datasetDisplayName: The Dataset's display name in automl.googleapis.com.
    suggestedDatasetDisplayName: Suggested display name of the Dataset in AI
      Platform.
    suggestedSavedQueryDisplayName: Suggested display name of the SavedQuery
      in AI Platform.
  """

  dataset = _messages.StringField(1)
  datasetDisplayName = _messages.StringField(2)
  suggestedDatasetDisplayName = _messages.StringField(3)
  suggestedSavedQueryDisplayName = _messages.StringField(4)


class GoogleCloudAiplatformUiMigratableResourceAutomlModel(_messages.Message):
  r"""Represents one Model in automl.googleapis.com.

  Fields:
    model: Full resource name of automl Model. Format:
      `projects/{project}/locations/{location}/models/{model}`.
    modelDisplayName: The Model's display name in automl.googleapis.com.
    suggestedModelDisplayName: Suggested display name of the model in AI
      Platform.
  """

  model = _messages.StringField(1)
  modelDisplayName = _messages.StringField(2)
  suggestedModelDisplayName = _messages.StringField(3)


class GoogleCloudAiplatformUiMigratableResourceDataLabelingDataset(_messages.Message):
  r"""Represents one Dataset in datalabeling.googleapis.com.

  Fields:
    dataLabelingAnnotatedDatasets: The migratable AnnotatedDataset in
      datalabeling.googleapis.com belongs to the data labeling Dataset.
    dataset: Full resource name of data labeling Dataset. Format:
      `projects/{project}/datasets/{dataset}`.
    datasetDisplayName: The Dataset's display name in
      datalabeling.googleapis.com.
    suggestedDatasetDisplayName: Suggested display name of the Dataset in AI
      Platform.
  """

  dataLabelingAnnotatedDatasets = _messages.MessageField('GoogleCloudAiplatformUiMigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset', 1, repeated=True)
  dataset = _messages.StringField(2)
  datasetDisplayName = _messages.StringField(3)
  suggestedDatasetDisplayName = _messages.StringField(4)


class GoogleCloudAiplatformUiMigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset(_messages.Message):
  r"""Represents one AnnotatedDataset in datalabeling.googleapis.com.

  Fields:
    annotatedDataset: Full resource name of data labeling AnnotatedDataset.
      Format: `projects/{project}/datasets/{dataset}/annotatedDatasets/{annota
      ted_dataset}`.
    annotatedDatasetDisplayName: The AnnotatedDataset's display name in
      datalabeling.googleapis.com.
    suggestedSavedQueryDisplayName: Suggested display name of the SavedQuery
      in AI Platform.
  """

  annotatedDataset = _messages.StringField(1)
  annotatedDatasetDisplayName = _messages.StringField(2)
  suggestedSavedQueryDisplayName = _messages.StringField(3)


class GoogleCloudAiplatformUiMigratableResourceMlEngineModelVersion(_messages.Message):
  r"""Represents one model Version in ml.googleapis.com.

  Fields:
    endpoint: The ml.googleapis.com endpoint that this model Version currently
      lives in. Example values: * ml.googleapis.com * us-centrall-
      ml.googleapis.com * europe-west4-ml.googleapis.com * asia-
      east1-ml.googleapis.com
    suggestedModelDisplayName: Suggested display name of the model in AI
      Platform.
    version: Full resource name of ml engine model Version. Format:
      `projects/{project}/models/{model}/versions/{version}`.
  """

  endpoint = _messages.StringField(1)
  suggestedModelDisplayName = _messages.StringField(2)
  version = _messages.StringField(3)


class GoogleCloudAiplatformUiMigrateResourceResponse(_messages.Message):
  r"""Describes a successfully migrated resource.

  Fields:
    dataset: Migrated Dataset's resource name.
    migratableResource: Before migration, the identifier in ml.googleapis.com,
      automl.googleapis.com or datalabeling.googleapis.com.
    model: Migrated Model's resource name.
  """

  dataset = _messages.StringField(1)
  migratableResource = _messages.MessageField('GoogleCloudAiplatformUiMigratableResource', 2)
  model = _messages.StringField(3)


class GoogleCloudAiplatformUiRemoveAnnotationSpecFromSavedQueryOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  DatasetService.RemoveAnnotationSpecFromSavedQuery.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiSampledShapleyAttribution(_messages.Message):
  r"""An attribution method that approximates Shapley values for features that
  contribute to the label being predicted. A sampling strategy is used to
  approximate the value rather than considering all subsets of features.

  Fields:
    pathCount: Required. The number of feature permutations to consider when
      approximating the Shapley values. Valid range of its value is [1, 50],
      inclusively.
  """

  pathCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiSchemaAnnotationSpecColor(_messages.Message):
  r"""An entry of mapping between color and AnnotationSpec. The mapping is
  used in segmentation mask.

  Fields:
    color: The color of the AnnotationSpec in a segmentation mask.
    displayName: The display name of the AnnotationSpec represented by the
      color in the segmentation mask.
    id: The ID of the AnnotationSpec represented by the color in the
      segmentation mask.
  """

  color = _messages.MessageField('GoogleTypeColor', 1)
  displayName = _messages.StringField(2)
  id = _messages.StringField(3)


class GoogleCloudAiplatformUiSchemaImageBoundingBoxAnnotation(_messages.Message):
  r"""Annotation details specific to image object detection.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    xMax: The rightmost coordinate of the bounding box.
    xMin: The leftmost coordinate of the bounding box.
    yMax: The bottommost coordinate of the bounding box.
    yMin: The topmost coordinate of the bounding box.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  xMax = _messages.FloatField(3)
  xMin = _messages.FloatField(4)
  yMax = _messages.FloatField(5)
  yMin = _messages.FloatField(6)


class GoogleCloudAiplatformUiSchemaImageClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to image classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)


class GoogleCloudAiplatformUiSchemaImageDataItem(_messages.Message):
  r"""Payload of Image DataItem.

  Fields:
    contentUri: Output only. Signed HTTP URI points to the normalized image,
      expires in 10 minutes.
    gcsUri: Required. Google Cloud Storage URI points to the original image in
      user's bucket. The image is up to 30MB in size.
    mimeType: Output only. The mime type of the content of the image. Only the
      images in below listed mime types are supported. - image/jpeg -
      image/gif - image/png - image/webp - image/bmp - image/tiff -
      image/vnd.microsoft.icon
    resolution: Output only. The resolution of the original image.
    thumbnailUri: Output only. Signed HTTP URI points to the thumbnail image,
      expires in 10 minutes.
  """

  contentUri = _messages.StringField(1)
  gcsUri = _messages.StringField(2)
  mimeType = _messages.StringField(3)
  resolution = _messages.MessageField('GoogleCloudAiplatformUiSchemaResolution', 4)
  thumbnailUri = _messages.StringField(5)


class GoogleCloudAiplatformUiSchemaImageDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Image DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Image DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformUiSchemaImageSegmentationAnnotation(_messages.Message):
  r"""Annotation details specific to image segmentation.

  Fields:
    maskAnnotation: Mask based segmentation annotation. Only one mask
      annotation can exist for one image.
    polygonAnnotation: Polygon annotation.
    polylineAnnotation: Polyline annotation.
  """

  maskAnnotation = _messages.MessageField('GoogleCloudAiplatformUiSchemaImageSegmentationAnnotationMaskAnnotation', 1)
  polygonAnnotation = _messages.MessageField('GoogleCloudAiplatformUiSchemaImageSegmentationAnnotationPolygonAnnotation', 2)
  polylineAnnotation = _messages.MessageField('GoogleCloudAiplatformUiSchemaImageSegmentationAnnotationPolylineAnnotation', 3)


class GoogleCloudAiplatformUiSchemaImageSegmentationAnnotationMaskAnnotation(_messages.Message):
  r"""The mask based segmentation annotation.

  Fields:
    annotationSpecColors: The mapping between color and AnnotationSpec for
      this Annotation.
    maskGcsUri: Google Cloud Storage URI that points to the mask image. The
      image must be in PNG format. It must have the same size as the
      DataItem's image. Each pixel in the image mask represents the
      AnnotationSpec which the pixel in the image DataItem belong to. Each
      color is mapped to one AnnotationSpec based on annotation_spec_colors.
    maskUri: Signed HTTP URI points to the mask, expires in 10 minutes.
  """

  annotationSpecColors = _messages.MessageField('GoogleCloudAiplatformUiSchemaAnnotationSpecColor', 1, repeated=True)
  maskGcsUri = _messages.StringField(2)
  maskUri = _messages.StringField(3)


class GoogleCloudAiplatformUiSchemaImageSegmentationAnnotationPolygonAnnotation(_messages.Message):
  r"""Represents a polygon in image.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    vertexes: The vertexes are connected one by one and the last vertex is
      connected to the first one to represent a polygon.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  vertexes = _messages.MessageField('GoogleCloudAiplatformUiSchemaVertex', 3, repeated=True)


class GoogleCloudAiplatformUiSchemaImageSegmentationAnnotationPolylineAnnotation(_messages.Message):
  r"""Represents a polyline in image.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    vertexes: The vertexes are connected one by one and the last vertex in not
      connected to the first one.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  vertexes = _messages.MessageField('GoogleCloudAiplatformUiSchemaVertex', 3, repeated=True)


class GoogleCloudAiplatformUiSchemaImageSegmentationSavedQueryMetadata(_messages.Message):
  r"""The metadata of SavedQuery contains ImageSegmentation Annotations.

  Enums:
    AnnotationTypeValueValuesEnum: Type of annotations that can be referenced
      by the saved query.

  Fields:
    annotationType: Type of annotations that can be referenced by the saved
      query.
    colorMap: The mapping between color and AnnotationSpec for this
      SavedQuery.
  """

  class AnnotationTypeValueValuesEnum(_messages.Enum):
    r"""Type of annotations that can be referenced by the saved query.

    Values:
      SEGMENTATION_ANNOTATION_TYPE_UNSPECIFIED: <no description>
      SEGMENTATION_ANNOTATION_TYPE_MASK: <no description>
      SEGMENTATION_ANNOTATION_TYPE_POLYGON: <no description>
      SEGMENTATION_ANNOTATION_TYPE_POLYLINE: <no description>
    """
    SEGMENTATION_ANNOTATION_TYPE_UNSPECIFIED = 0
    SEGMENTATION_ANNOTATION_TYPE_MASK = 1
    SEGMENTATION_ANNOTATION_TYPE_POLYGON = 2
    SEGMENTATION_ANNOTATION_TYPE_POLYLINE = 3

  annotationType = _messages.EnumField('AnnotationTypeValueValuesEnum', 1)
  colorMap = _messages.MessageField('GoogleCloudAiplatformUiSchemaAnnotationSpecColor', 2, repeated=True)


class GoogleCloudAiplatformUiSchemaResolution(_messages.Message):
  r"""Represents the resolution of an image or a video frame.

  Fields:
    height: Number of pixels in the vertical dimension.
    width: Number of pixels in the horizontal dimension.
  """

  height = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  width = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiSchemaTablesDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain tables data.

  Fields:
    inputConfig: A
      GoogleCloudAiplatformUiSchemaTablesDatasetMetadataInputConfig attribute.
  """

  inputConfig = _messages.MessageField('GoogleCloudAiplatformUiSchemaTablesDatasetMetadataInputConfig', 1)


class GoogleCloudAiplatformUiSchemaTablesDatasetMetadataBigQuerySource(_messages.Message):
  r"""A GoogleCloudAiplatformUiSchemaTablesDatasetMetadataBigQuerySource
  object.

  Fields:
    uri: The URI of a BigQuery table.
  """

  uri = _messages.StringField(1)


class GoogleCloudAiplatformUiSchemaTablesDatasetMetadataGcsSource(_messages.Message):
  r"""A GoogleCloudAiplatformUiSchemaTablesDatasetMetadataGcsSource object.

  Fields:
    uri: Cloud Storage URI of one or more files. Only CSV files are supported.
      The first line of the CSV file is used as the header. If there are
      multiple files, the header is the first line of the lexicographically
      first file, the other files must either contain the exact same header or
      omit the header.
  """

  uri = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformUiSchemaTablesDatasetMetadataInputConfig(_messages.Message):
  r"""The tables Dataset's data source. The Dataset doesn't store the data
  directly, but only pointer(s) to its data.

  Fields:
    bigquerySource: A
      GoogleCloudAiplatformUiSchemaTablesDatasetMetadataBigQuerySource
      attribute.
    gcsSource: A GoogleCloudAiplatformUiSchemaTablesDatasetMetadataGcsSource
      attribute.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformUiSchemaTablesDatasetMetadataBigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformUiSchemaTablesDatasetMetadataGcsSource', 2)


class GoogleCloudAiplatformUiSchemaTextClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to text classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)


class GoogleCloudAiplatformUiSchemaTextDataItem(_messages.Message):
  r"""Payload of Text DataItem.

  Fields:
    content: Output only. It is only returned in GetDataItem response. The
      content of the text snippet as a string.
    gcsUri: Output only. Google Cloud Storage URI points to the original text
      in user's bucket. The text file is up to 10MB in size.
    trucatedContent: Output only. It is only returned in ListDataItems
      response. Same as content if content has up to 100 characters. Otherwise
      this field contains first 100 characters of the content.
    truncated: Output only. It is only returned in ListDataItems response.
      True if and only if the truncated_content is different from the full
      content.
  """

  content = _messages.StringField(1)
  gcsUri = _messages.StringField(2)
  trucatedContent = _messages.StringField(3)
  truncated = _messages.BooleanField(4)


class GoogleCloudAiplatformUiSchemaTextDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Text DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Text DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformUiSchemaTextExtractionAnnotation(_messages.Message):
  r"""Annotation details specific to text extraction.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    textSegment: The segment of the text content.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  textSegment = _messages.MessageField('GoogleCloudAiplatformUiSchemaTextSegment', 3)


class GoogleCloudAiplatformUiSchemaTextSegment(_messages.Message):
  r"""The text segment inside of DataItem.

  Fields:
    content: The text content in the segment for output only.
    endOffset: Zero-based character index of the first character past the end
      of the text segment (counting character from the beginning of the text).
      The character at the end_offset is NOT included in the text segment.
    startOffset: Zero-based character index of the first character of the text
      segment (counting characters from the beginning of the text).
  """

  content = _messages.StringField(1)
  endOffset = _messages.IntegerField(2, variant=_messages.Variant.UINT64)
  startOffset = _messages.IntegerField(3, variant=_messages.Variant.UINT64)


class GoogleCloudAiplatformUiSchemaTextSentimentAnnotation(_messages.Message):
  r"""Annotation details specific to text sentiment.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    sentiment: The sentiment score for text.
    sentimentMax: The sentiment max score for text.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  sentiment = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  sentimentMax = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiSchemaTextSentimentSavedQueryMetadata(_messages.Message):
  r"""The metadata of SavedQuery contains TextSentiment Annotations.

  Fields:
    sentimentMax: The maximum sentiment of sentiment Anntoation in this
      SavedQuery.
  """

  sentimentMax = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiSchemaTimeSegment(_messages.Message):
  r"""A time period inside of a DataItem that has a time dimension (e.g.
  video).

  Fields:
    endTimeOffset: End of the time segment (exclusive), represented as the
      duration since the start of the DataItem.
    startTimeOffset: Start of the time segment (inclusive), represented as the
      duration since the start of the DataItem.
  """

  endTimeOffset = _messages.StringField(1)
  startTimeOffset = _messages.StringField(2)


class GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain time series data.

  Fields:
    inputConfig: A
      GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataInputConfig
      attribute.
    timeColumn: The column name of the time column that identifies time order
      in the time series.
    timeSeriesIdentifierColumn: The column name of the time series identifier
      column that identifies the time series.
  """

  inputConfig = _messages.MessageField('GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataInputConfig', 1)
  timeColumn = _messages.StringField(2)
  timeSeriesIdentifierColumn = _messages.StringField(3)


class GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataBigQuerySource(_messages.Message):
  r"""A GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataBigQuerySource
  object.

  Fields:
    uri: The URI of a BigQuery table.
  """

  uri = _messages.StringField(1)


class GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataGcsSource(_messages.Message):
  r"""A GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataGcsSource
  object.

  Fields:
    uri: Cloud Storage URI of one or more files. Only CSV files are supported.
      The first line of the CSV file is used as the header. If there are
      multiple files, the header is the first line of the lexicographically
      first file, the other files must either contain the exact same header or
      omit the header.
  """

  uri = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataInputConfig(_messages.Message):
  r"""The time series Dataset's data source. The Dataset doesn't store the
  data directly, but only pointer(s) to its data.

  Fields:
    bigquerySource: A
      GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataBigQuerySource
      attribute.
    gcsSource: A
      GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataGcsSource
      attribute.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataBigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformUiSchemaTimeSeriesDatasetMetadataGcsSource', 2)


class GoogleCloudAiplatformUiSchemaVertex(_messages.Message):
  r"""A vertex represents a 2D point in the image. NOTE: the normalized vertex
  coordinates are relative to the original image and range from 0 to 1.

  Fields:
    x: X coordinate.
    y: Y coordinate.
  """

  x = _messages.FloatField(1)
  y = _messages.FloatField(2)


class GoogleCloudAiplatformUiSchemaVideoActionRecognitionAnnotation(_messages.Message):
  r"""Annotation details specific to video action recognition.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    timeSegment: This Annotation applies to the time period represented by the
      TimeSegment. If it's not set, the Annotation applies to the whole video.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  timeSegment = _messages.MessageField('GoogleCloudAiplatformUiSchemaTimeSegment', 3)


class GoogleCloudAiplatformUiSchemaVideoClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to video classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    timeSegment: This Annotation applies to the time period represented by the
      TimeSegment. If it's not set, the Annotation applies to the whole video.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  timeSegment = _messages.MessageField('GoogleCloudAiplatformUiSchemaTimeSegment', 3)


class GoogleCloudAiplatformUiSchemaVideoDataItem(_messages.Message):
  r"""Payload of Video DataItem.

  Fields:
    contentUri: Output only. Signed HTTP URI points to the transcoded video,
      expires in 1 hour.
    duration: Output only. The duration of the video.
    frameRate: Output only. The number of frames per second of the video.
    gcsUri: Required. Google Cloud Storage URI points to the original video in
      user's bucket. The video is up to 50 GB in size and up to 3 hour in
      duration.
    mimeType: Output only. The mime type of the content of the video. Only the
      videos in below listed mime types are supported. Supported mime_type: -
      video/mp4 - video/avi - video/quicktime
    resolution: Output only. The resolution of the video.
    thumbnailUri: Output only. Signed HTTP URI point to thumbnail image of the
      video, expires in 1 hour.
  """

  contentUri = _messages.StringField(1)
  duration = _messages.StringField(2)
  frameRate = _messages.FloatField(3)
  gcsUri = _messages.StringField(4)
  mimeType = _messages.StringField(5)
  resolution = _messages.MessageField('GoogleCloudAiplatformUiSchemaResolution', 6)
  thumbnailUri = _messages.StringField(7)


class GoogleCloudAiplatformUiSchemaVideoDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Video DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Video DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformUiSchemaVideoObjectTrackingAnnotation(_messages.Message):
  r"""Annotation details specific to video object tracking.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    instanceId: The instance of the object, expressed as a positive integer.
      Used to track the same object across different frames.
    timeOffset: A time (frame) of a video to which this annotation pertains.
      Represented as the duration since the video's start.
    xMax: The rightmost coordinate of the bounding box.
    xMin: The leftmost coordinate of the bounding box.
    yMax: The bottommost coordinate of the bounding box.
    yMin: The topmost coordinate of the bounding box.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  instanceId = _messages.IntegerField(3)
  timeOffset = _messages.StringField(4)
  xMax = _messages.FloatField(5)
  xMin = _messages.FloatField(6)
  yMax = _messages.FloatField(7)
  yMin = _messages.FloatField(8)


class GoogleCloudAiplatformUiSchemaVisualInspectionClassificationLabelSavedQueryMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformUiSchemaVisualInspectionClassificationLabelSavedQ
  ueryMetadata object.

  Fields:
    multiLabel: Whether or not the classification label is multi_label.
  """

  multiLabel = _messages.BooleanField(1)


class GoogleCloudAiplatformUiSchemaVisualInspectionMaskSavedQueryMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformUiSchemaVisualInspectionMaskSavedQueryMetadata
  object.

  Fields:
    colorMap: The mapping between color and AnnotationSpec for this
      SavedQuery.
  """

  colorMap = _messages.MessageField('GoogleCloudAiplatformUiSchemaAnnotationSpecColor', 1, repeated=True)


class GoogleCloudAiplatformUiSmoothGradConfig(_messages.Message):
  r"""Config for SmoothGrad approximation of gradients. When enabled, the
  gradients are approximated by averaging the gradients from noisy samples in
  the vicinity of the inputs. Adding noise can help improve the computed
  gradients. Refer to this paper for more details:
  https://arxiv.org/pdf/1706.03825.pdf

  Fields:
    featureNoiseSigma: This is similar to noise_sigma, but provides additional
      flexibility. A separate noise sigma can be provided for each feature,
      which is useful if their distributions are different. No noise is added
      to features that are not set. If this field is unset, noise_sigma will
      be used for all features.
    noiseSigma: This is a single float value and will be used to add noise to
      all the features. Use this field when all features are normalized to
      have the same distribution: scale to range [0, 1], [-1, 1] or z-scoring,
      where features are normalized to have 0-mean and 1-variance. For more
      details about normalization: https://tinyurl.com/dgc-normalization. For
      best results the recommended value is about 10% - 20% of the standard
      deviation of the input feature. Refer to section 3.2 of the SmoothGrad
      paper: https://arxiv.org/pdf/1706.03825.pdf. Defaults to 0.1. If the
      distribution is different per feature, set feature_noise_sigma instead
      for each feature.
    noisySampleCount: The number of gradient samples to use for approximation.
      The higher this number, the more accurate the gradient is, but the
      runtime complexity increases by this factor as well. Valid range of its
      value is [1, 50]. Defaults to 3.
  """

  featureNoiseSigma = _messages.MessageField('GoogleCloudAiplatformUiFeatureNoiseSigma', 1)
  noiseSigma = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  noisySampleCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiSpecialistPool(_messages.Message):
  r"""SpecialistPool represents customers' own workforce to work on their data
  labeling jobs. It includes a group of specialist managers who are
  responsible for managing the labelers in this pool as well as customers'
  data labeling jobs associated with this pool. Customers create specialist
  pool as well as start data labeling jobs on Cloud, managers and labelers
  work with the jobs using CrowdCompute console.

  Fields:
    displayName: Required. The user-defined name of the SpecialistPool. The
      name can be up to 128 characters long and can be consist of any UTF-8
      characters. This field should be unique on project-level.
    name: Required. The resource name of the SpecialistPool.
    pendingDataLabelingJobObjects: Output only. The DataLabelingJobs' metadata
      in JOB_STATE_RUNNING using this SpecialistPool.
    pendingDataLabelingJobs: Output only. The resource name of the pending
      data labeling jobs.
    specialistManagerEmails: The email addresses of the specialists in the
      SpecialistPool.
    specialistManagersCount: Output only. The number of Specialists in this
      SpecialistPool.
  """

  displayName = _messages.StringField(1)
  name = _messages.StringField(2)
  pendingDataLabelingJobObjects = _messages.MessageField('GoogleCloudAiplatformUiDataLabelingJobRef', 3, repeated=True)
  pendingDataLabelingJobs = _messages.StringField(4, repeated=True)
  specialistManagerEmails = _messages.StringField(5, repeated=True)
  specialistManagersCount = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformUiUndeployModelOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.UndeployModel.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiUndeployModelResponse(_messages.Message):
  r"""Response message for EndpointService.UndeployModel."""


class GoogleCloudAiplatformUiUpdateSpecialistPoolOperationMetadata(_messages.Message):
  r"""Runtime operation metadata for
  SpecialistPoolService.UpdateSpecialistPool.

  Fields:
    genericMetadata: The operation generic information.
    specialistPool: Output only. The name of the SpecialistPool to which the
      specialists are being added. Format: `projects/{project_id}/locations/{l
      ocation_id}/specialistPools/{specialist_pool}`
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)
  specialistPool = _messages.StringField(2)


class GoogleCloudAiplatformUiUploadModelOperationMetadata(_messages.Message):
  r"""Details of ModelService.UploadModel operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformUiGenericOperationMetadata', 1)


class GoogleCloudAiplatformUiUploadModelResponse(_messages.Message):
  r"""Response message of ModelService.UploadModel operation.

  Fields:
    model: The name of the uploaded Model resource. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  model = _messages.StringField(1)


class GoogleCloudAiplatformUiXraiAttribution(_messages.Message):
  r"""An explanation method that redistributes Integrated Gradients
  attributions to segmented regions, taking advantage of the model's fully
  differentiable structure. Refer to this paper for more details:
  https://arxiv.org/abs/1906.02825 Supported only by image Models.

  Fields:
    smoothGradConfig: Config for SmoothGrad approximation of gradients. When
      enabled, the gradients are approximated by averaging the gradients from
      noisy samples in the vicinity of the inputs. Adding noise can help
      improve the computed gradients. Refer to this paper for more details:
      https://arxiv.org/pdf/1706.03825.pdf
    stepCount: Required. The number of steps for approximating the path
      integral. A good value to start is 50 and gradually increase until the
      sum to diff property is met within the desired error range. Valid range
      of its value is [1, 100], inclusively.
  """

  smoothGradConfig = _messages.MessageField('GoogleCloudAiplatformUiSmoothGradConfig', 1)
  stepCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1alpha1ActiveLearningConfig(_messages.Message):
  r"""Parameters that configure active learning pipeline. Active learning will
  label the data incrementally by several iterations. For every iteration, it
  will select a batch of data based on the sampling strategy.

  Fields:
    maxDataItemCount: Max number of human labeled DataItems.
    maxDataItemPercentage: Max percent of total DataItems for human labeling.
    sampleConfig: Active learning data sampling config. For every active
      learning labeling iteration, it will select a batch of data based on the
      sampling strategy.
    trainingConfig: CMLE training config. For every active learning labeling
      iteration, system will train a machine learning model on CMLE. The
      trained model will be used by data sampling algorithm to select
      DataItems.
  """

  maxDataItemCount = _messages.IntegerField(1)
  maxDataItemPercentage = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  sampleConfig = _messages.MessageField('GoogleCloudAiplatformV1alpha1SampleConfig', 3)
  trainingConfig = _messages.MessageField('GoogleCloudAiplatformV1alpha1TrainingConfig', 4)


class GoogleCloudAiplatformV1alpha1Annotation(_messages.Message):
  r"""Used to assign specific AnnotationSpec to a particular area of a
  DataItem or the whole part of the DataItem.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your Annotations. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      Annotation(System labels are excluded). See https://goo.gl/xmQnxf for
      more information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable. Following
      system labels exist for each Annotation: *
      "aiplatform.googleapis.com/annotation_set_name": optional, name of the
      UI's annotation set this Annotation belongs to. If not set the
      Annotation is not visible in the UI. *
      "aiplatform.googleapis.com/payload_schema": output only, its value is
      the payload_schema's title.

  Fields:
    annotationSource: Output only. The source of the Annotation.
    createTime: Output only. Timestamp when this Annotation was created.
    etag: Optional. Used to perform a consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    labels: Optional. The labels with user-defined metadata to organize your
      Annotations. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      Annotation(System labels are excluded). See https://goo.gl/xmQnxf for
      more information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable. Following
      system labels exist for each Annotation: *
      "aiplatform.googleapis.com/annotation_set_name": optional, name of the
      UI's annotation set this Annotation belongs to. If not set the
      Annotation is not visible in the UI. *
      "aiplatform.googleapis.com/payload_schema": output only, its value is
      the payload_schema's title.
    name: Output only. Resource name of the Annotation.
    payload: Required. The schema of the payload can be found in
      payload_schema.
    payloadSchemaUri: Required. Google Cloud Storage URI points to a YAML file
      describing payload. The schema is defined as an [OpenAPI 3.0.2 Schema
      Object](https://tinyurl.com/y538mdwt). The schema files that can be used
      here are found in gs://google-cloud-
      aiplatform/schema/dataset/annotation/, note that the chosen schema must
      be consistent with the parent Dataset's metadata.
    updateTime: Output only. Timestamp when this Annotation was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    Annotations. Label keys and values can be no longer than 64 characters
    (Unicode codepoints), can only contain lowercase letters, numeric
    characters, underscores and dashes. International characters are allowed.
    No more than 64 user labels can be associated with one Annotation(System
    labels are excluded). See https://goo.gl/xmQnxf for more information and
    examples of labels. System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable. Following system labels
    exist for each Annotation: *
    "aiplatform.googleapis.com/annotation_set_name": optional, name of the
    UI's annotation set this Annotation belongs to. If not set the Annotation
    is not visible in the UI. * "aiplatform.googleapis.com/payload_schema":
    output only, its value is the payload_schema's title.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotationSource = _messages.MessageField('GoogleCloudAiplatformV1alpha1UserActionReference', 1)
  createTime = _messages.StringField(2)
  etag = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  payload = _messages.MessageField('extra_types.JsonValue', 6)
  payloadSchemaUri = _messages.StringField(7)
  updateTime = _messages.StringField(8)


class GoogleCloudAiplatformV1alpha1AnnotationSpec(_messages.Message):
  r"""Identifies a concept with which DataItems may be annotated with.

  Fields:
    createTime: Output only. Timestamp when this AnnotationSpec was created.
    displayName: Required. The user-defined name of the AnnotationSpec. The
      name can be up to 128 characters long and can be consist of any UTF-8
      characters.
    etag: Optional. Used to perform a consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    name: Output only. Resource name of the AnnotationSpec.
    updateTime: Output only. Timestamp when AnnotationSpec was last updated.
  """

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  etag = _messages.StringField(3)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class GoogleCloudAiplatformV1alpha1Attribution(_messages.Message):
  r"""Attribution that explains a particular prediction output.

  Fields:
    approximationError: Output only. Error of feature_attributions caused by
      approximation used in the explanation method. Lower value means more
      precise attributions. * For Sampled Shapley attribution, increasing
      path_count might reduce the error. * For Integrated Gradients
      attribution, increasing step_count might reduce the error. * For XRAI
      attribution, increasing step_count might reduce the error. See [this
      introduction](/ai-platform-unified/docs/explainable-ai/overview) for
      more information.
    baselineOutputValue: Output only. Model predicted output if the input
      instance is constructed from the baselines of all the features defined
      in ExplanationMetadata.inputs. The field name of the output is
      determined by the key in ExplanationMetadata.outputs. If the Model's
      predicted output has multiple dimensions (rank > 1), this is the value
      in the output located by output_index. If there are multiple baselines,
      their output values are averaged.
    featureAttributions: Output only. Attributions of each explained feature.
      Features are extracted from the prediction instances according to
      explanation metadata for inputs. The value is a struct, whose keys are
      the name of the feature. The values are how much the feature in the
      instance contributed to the predicted result. The format of the value is
      determined by the feature's input format: * If the feature is a scalar
      value, the attribution value is a floating number. * If the feature is
      an array of scalar values, the attribution value is an array. * If the
      feature is a struct, the attribution value is a struct. The keys in the
      attribution value struct are the same as the keys in the feature struct.
      The formats of the values in the attribution struct are determined by
      the formats of the values in the feature struct. The
      ExplanationMetadata.feature_attributions_schema_uri field, pointed to by
      the ExplanationSpec field of the Endpoint.deployed_models object, points
      to the schema file that describes the features and their attribution
      values (if it is populated).
    instanceOutputValue: Output only. Model predicted output on the
      corresponding explanation instance. The field name of the output is
      determined by the key in ExplanationMetadata.outputs. If the Model
      predicted output has multiple dimensions, this is the value in the
      output located by output_index.
    outputDisplayName: Output only. The display name of the output identified
      by output_index. For example, the predicted class name by a multi-
      classification Model. This field is only populated iff the Model
      predicts display names as a separate field along with the explained
      output. The predicted display name must has the same shape of the
      explained output, and can be located using output_index.
    outputIndex: Output only. The index that locates the explained prediction
      output. If the prediction output is a scalar value, output_index is not
      populated. If the prediction output has multiple dimensions, the length
      of the output_index list is the same as the number of dimensions of the
      output. The i-th element in output_index is the element index of the
      i-th dimension of the output vector. Indices start from 0.
    outputName: Output only. Name of the explain output. Specified as the key
      in ExplanationMetadata.outputs.
  """

  approximationError = _messages.FloatField(1)
  baselineOutputValue = _messages.FloatField(2)
  featureAttributions = _messages.MessageField('extra_types.JsonValue', 3)
  instanceOutputValue = _messages.FloatField(4)
  outputDisplayName = _messages.StringField(5)
  outputIndex = _messages.IntegerField(6, repeated=True, variant=_messages.Variant.INT32)
  outputName = _messages.StringField(7)


class GoogleCloudAiplatformV1alpha1AutomaticResources(_messages.Message):
  r"""A description of resources that to large degree are decided by AI
  Platform, and require only a modest additional configuration. Each Model
  supporting these resources documents its specific guidelines.

  Fields:
    maxReplicaCount: Immutable. The maximum number of replicas this
      DeployedModel may be deployed on when the traffic against it increases.
      If requested value is too large, the deployment will error, but if
      deployment succeeds then the ability to scale the model to that many
      replicas is guaranteed (barring service outages). If traffic against the
      DeployedModel increases beyond what its replicas at maximum may handle,
      a portion of the traffic will be dropped. If this value is not provided,
      a no upper bound for scaling under heavy traffic will be assume, though
      AI Platform may be unable to scale beyond certain replica number.
    minReplicaCount: Immutable. The minimum number of replicas this
      DeployedModel will be always deployed on. If traffic against it
      increases, it may dynamically be deployed onto more replicas up to
      max_replica_count, and as traffic decreases, some of these extra
      replicas may be freed. If requested value is too large, the deployment
      will error.
  """

  maxReplicaCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1alpha1BatchDedicatedResources(_messages.Message):
  r"""A description of resources that are used for performing batch
  operations, are dedicated to a Model, and need manual configuration.

  Fields:
    machineSpec: Required. Immutable. The specification of a single machine.
    maxReplicaCount: Immutable. The maximum number of machine replicas the
      batch operation may be scaled to. The default value is 10.
    startingReplicaCount: Immutable. The number of machine replicas used at
      the start of the batch operation. If not set, AI Platform decides
      starting number, not greater than max_replica_count
  """

  machineSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1MachineSpec', 1)
  maxReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  startingReplicaCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1alpha1BatchMigrateResourcesOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  MigrationService.BatchMigrateResources.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1BatchMigrateResourcesRequest(_messages.Message):
  r"""Request message for MigrationService.BatchMigrateResources.

  Fields:
    migrateResourceRequests: Required. The request messages specifying the
      resources to migrate. They must be in the same location as the
      destination. Up to 50 resources can be migrated in one batch.
  """

  migrateResourceRequests = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigrateResourceRequest', 1, repeated=True)


class GoogleCloudAiplatformV1alpha1BatchMigrateResourcesResponse(_messages.Message):
  r"""Response message for MigrationService.BatchMigrateResources.

  Fields:
    migrateResourceResponses: Successfully migrated resources.
  """

  migrateResourceResponses = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigrateResourceResponse', 1, repeated=True)


class GoogleCloudAiplatformV1alpha1BatchPredictionJob(_messages.Message):
  r"""A job that uses a Model to produce predictions on multiple input
  instances. If predictions for significant portion of the instances fail, the
  job may finish without attempting predictions for all remaining instances.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the job.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize
      BatchPredictionJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    completionStats: Output only. Statistics on completed and failed
      prediction instances.
    createTime: Output only. Time when the BatchPredictionJob was created.
    dedicatedResources: The config of resources used by the Model during the
      batch prediction. If the Model supports DEDICATED_RESOURCES this config
      may be provided (and the job will use these resources), if the Model
      doesn't support AUTOMATIC_RESOURCES, this config must be provided.
    displayName: Required. The user-defined name of this BatchPredictionJob.
    encryptionSpec: Customer-managed encryption key options for a
      BatchPredictionJob. If this is set, then all resources created by the
      BatchPredictionJob will be encrypted with the provided encryption key.
    endTime: Output only. Time when the BatchPredictionJob entered any of the
      following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
      `JOB_STATE_CANCELLED`.
    error: Output only. Only populated when the job's state is
      JOB_STATE_FAILED or JOB_STATE_CANCELLED.
    generateExplanation: Generate explanation with the batch prediction
      results. When set to `true`, the batch prediction output changes based
      on the `predictions_format` field of the
      BatchPredictionJob.output_config object: * `bigquery`: output includes a
      column named `explanation`. The value is a struct that conforms to the
      Explanation object. * `jsonl`: The JSON objects on each line include an
      additional entry keyed `explanation`. The value of the entry is a JSON
      object that conforms to the Explanation object. * `csv`: Generating
      explanations for CSV format is not supported. If this field is set to
      true, the Model.explanation_spec must be populated.
    inputConfig: Required. Input configuration of the instances on which
      predictions are performed. The schema of any single instance may be
      specified via the Model's PredictSchemata's instance_schema_uri.
    labels: The labels with user-defined metadata to organize
      BatchPredictionJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.
    manualBatchTuningParameters: Immutable. Parameters configuring the batch
      behavior. Currently only applicable when dedicated_resources are used
      (in other cases AI Platform does the tuning itself).
    model: Required. The name of the Model that produces the predictions via
      this job, must share the same ancestor Location. Starting this job has
      no impact on any existing deployments of the Model and their resources.
    modelParameters: The parameters that govern the predictions. The schema of
      the parameters may be specified via the Model's PredictSchemata's
      parameters_schema_uri.
    name: Output only. Resource name of the BatchPredictionJob.
    outputConfig: Required. The Configuration specifying where output
      predictions should be written. The schema of any single prediction may
      be specified as a concatenation of Model's PredictSchemata's
      instance_schema_uri and prediction_schema_uri.
    outputInfo: Output only. Information further describing the output of this
      job.
    partialFailures: Output only. Partial failures encountered. For example,
      single files that can't be read. This field never exceeds 20 entries.
      Status details fields contain standard GCP error details.
    resourcesConsumed: Output only. Information about resources that had been
      consumed by this job. Provided in real time at best effort basis, as
      well as a final value once the job completes. Note: This field currently
      may be not populated for batch predictions that use AutoML Models.
    startTime: Output only. Time when the BatchPredictionJob for the first
      time entered the `JOB_STATE_RUNNING` state.
    state: Output only. The detailed state of the job.
    updateTime: Output only. Time when the BatchPredictionJob was most
      recently updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the job.

    Values:
      JOB_STATE_UNSPECIFIED: The job state is unspecified.
      JOB_STATE_QUEUED: The job has been just created or resumed and
        processing has not yet begun.
      JOB_STATE_PENDING: The service is preparing to run the job.
      JOB_STATE_RUNNING: The job is in progress.
      JOB_STATE_SUCCEEDED: The job completed successfully.
      JOB_STATE_FAILED: The job failed.
      JOB_STATE_CANCELLING: The job is being cancelled. From this state the
        job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
        `JOB_STATE_CANCELLED`.
      JOB_STATE_CANCELLED: The job has been cancelled.
      JOB_STATE_PAUSED: The job has been stopped, and can be resumed.
    """
    JOB_STATE_UNSPECIFIED = 0
    JOB_STATE_QUEUED = 1
    JOB_STATE_PENDING = 2
    JOB_STATE_RUNNING = 3
    JOB_STATE_SUCCEEDED = 4
    JOB_STATE_FAILED = 5
    JOB_STATE_CANCELLING = 6
    JOB_STATE_CANCELLED = 7
    JOB_STATE_PAUSED = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize BatchPredictionJobs.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. See
    https://goo.gl/xmQnxf for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  completionStats = _messages.MessageField('GoogleCloudAiplatformV1alpha1CompletionStats', 1)
  createTime = _messages.StringField(2)
  dedicatedResources = _messages.MessageField('GoogleCloudAiplatformV1alpha1BatchDedicatedResources', 3)
  displayName = _messages.StringField(4)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1EncryptionSpec', 5)
  endTime = _messages.StringField(6)
  error = _messages.MessageField('GoogleRpcStatus', 7)
  generateExplanation = _messages.BooleanField(8)
  inputConfig = _messages.MessageField('GoogleCloudAiplatformV1alpha1BatchPredictionJobInputConfig', 9)
  labels = _messages.MessageField('LabelsValue', 10)
  manualBatchTuningParameters = _messages.MessageField('GoogleCloudAiplatformV1alpha1ManualBatchTuningParameters', 11)
  model = _messages.StringField(12)
  modelParameters = _messages.MessageField('extra_types.JsonValue', 13)
  name = _messages.StringField(14)
  outputConfig = _messages.MessageField('GoogleCloudAiplatformV1alpha1BatchPredictionJobOutputConfig', 15)
  outputInfo = _messages.MessageField('GoogleCloudAiplatformV1alpha1BatchPredictionJobOutputInfo', 16)
  partialFailures = _messages.MessageField('GoogleRpcStatus', 17, repeated=True)
  resourcesConsumed = _messages.MessageField('GoogleCloudAiplatformV1alpha1ResourcesConsumed', 18)
  startTime = _messages.StringField(19)
  state = _messages.EnumField('StateValueValuesEnum', 20)
  updateTime = _messages.StringField(21)


class GoogleCloudAiplatformV1alpha1BatchPredictionJobInputConfig(_messages.Message):
  r"""Configures the input to BatchPredictionJob. See
  Model.supported_input_storage_formats for Model's supported input formats,
  and how instances should be expressed via any of them.

  Fields:
    bigquerySource: The BigQuery location of the input table. The schema of
      the table should be in the format described by the given context OpenAPI
      Schema, if one is provided. The table may contain additional columns
      that are not described by the schema, and they will be ignored.
    gcsSource: The Cloud Storage location for the input instances.
    instancesFormat: Required. The format in which instances are given, must
      be one of the Model's supported_input_storage_formats.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1alpha1BigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1alpha1GcsSource', 2)
  instancesFormat = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1BatchPredictionJobOutputConfig(_messages.Message):
  r"""Configures the output of BatchPredictionJob. See
  Model.supported_output_storage_formats for supported output formats, and how
  predictions are expressed via any of them.

  Fields:
    bigqueryDestination: The BigQuery project location where the output is to
      be written to. In the given project a new dataset is created with name
      `prediction__` where is made BigQuery-dataset-name compatible (for
      example, most special characters become underscores), and timestamp is
      in YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset
      two tables will be created, `predictions`, and `errors`. If the Model
      has both instance and prediction schemata defined then the tables have
      columns as follows: The `predictions` table contains instances for which
      the prediction succeeded, it has columns as per a concatenation of the
      Model's instance and prediction schemata. The `errors` table contains
      rows for which the prediction has failed, it has instance columns, as
      per the instance schema, followed by a single "errors" column, which as
      values has [`google.rpc.Status`](Status) represented as a STRUCT, and
      containing only `code` and `message`.
    gcsDestination: The Cloud Storage location of the directory where the
      output is to be written to. In the given directory a new directory is
      created. Its name is `prediction--`, where timestamp is in YYYY-MM-
      DDThh:mm:ss.sssZ ISO-8601 format. Inside of it files
      `predictions_0001.`, `predictions_0002.`, ..., `predictions_N.` are
      created where `` depends on chosen predictions_format, and N may equal
      0001 and depends on the total number of successfully predicted
      instances. If the Model has both instance and prediction schemata
      defined then each such file contains predictions as per the
      predictions_format. If prediction for any instance failed (partially or
      completely), then an additional `errors_0001.`, `errors_0002.`,...,
      `errors_N.` files are created (N depends on total number of failed
      predictions). These files contain the failed instances, as per their
      schema, followed by an additional `error` field which as value has
      [`google.rpc.Status`](Status) containing only `code` and `message`
      fields.
    predictionsFormat: Required. The format in which AI Platform gives the
      predictions, must be one of the Model's
      supported_output_storage_formats.
  """

  bigqueryDestination = _messages.MessageField('GoogleCloudAiplatformV1alpha1BigQueryDestination', 1)
  gcsDestination = _messages.MessageField('GoogleCloudAiplatformV1alpha1GcsDestination', 2)
  predictionsFormat = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1BatchPredictionJobOutputInfo(_messages.Message):
  r"""Further describes this job's output. Supplements output_config.

  Fields:
    bigqueryOutputDataset: Output only. The path of the BigQuery dataset
      created, in `bq://projectId.bqDatasetId` format, into which the
      prediction output is written.
    gcsOutputDirectory: Output only. The full path of the Cloud Storage
      directory created, into which the prediction output is written.
  """

  bigqueryOutputDataset = _messages.StringField(1)
  gcsOutputDirectory = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1BigQueryDestination(_messages.Message):
  r"""The BigQuery location for the output content.

  Fields:
    outputUri: Required. BigQuery URI to a project, up to 2000 characters
      long. Accepted forms: * BigQuery path. For example: `bq://projectId`.
  """

  outputUri = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1BigQuerySource(_messages.Message):
  r"""The BigQuery location for the input content.

  Fields:
    inputUri: Required. BigQuery URI to a table, up to 2000 characters long.
      Accepted forms: * BigQuery path. For example:
      `bq://projectId.bqDatasetId.bqTableId`.
  """

  inputUri = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1CancelBatchPredictionJobRequest(_messages.Message):
  r"""Request message for JobService.CancelBatchPredictionJob."""


class GoogleCloudAiplatformV1alpha1CancelCustomJobRequest(_messages.Message):
  r"""Request message for JobService.CancelCustomJob."""


class GoogleCloudAiplatformV1alpha1CancelDataLabelingJobRequest(_messages.Message):
  r"""Request message for DataLabelingJobService.CancelDataLabelingJob."""


class GoogleCloudAiplatformV1alpha1CancelHyperparameterTuningJobRequest(_messages.Message):
  r"""Request message for JobService.CancelHyperparameterTuningJob."""


class GoogleCloudAiplatformV1alpha1CancelTrainingPipelineRequest(_messages.Message):
  r"""Request message for PipelineService.CancelTrainingPipeline."""


class GoogleCloudAiplatformV1alpha1CompletionStats(_messages.Message):
  r"""Success and error statistics of processing multiple entities (for
  example, DataItems or structured data rows) in batch.

  Fields:
    failedCount: Output only. The number of entities for which any error was
      encountered.
    incompleteCount: Output only. In cases when enough errors are encountered
      a job, pipeline, or operation may be failed as a whole. Below is the
      number of entities for which the processing had not been finished
      (either in successful or failed state). Set to -1 if the number is
      unknown (for example, the operation failed before the total entity
      number could be collected).
    successfulCount: Output only. The number of entities that had been
      processed successfully.
  """

  failedCount = _messages.IntegerField(1)
  incompleteCount = _messages.IntegerField(2)
  successfulCount = _messages.IntegerField(3)


class GoogleCloudAiplatformV1alpha1ContainerSpec(_messages.Message):
  r"""The spec of a Container.

  Fields:
    args: The arguments to be passed when starting the container.
    command: The command to be invoked when the container is started. It
      overrides the entrypoint instruction in Dockerfile when provided.
    imageUri: Required. The URI of a container image in the Container Registry
      that is to be run on each worker replica.
  """

  args = _messages.StringField(1, repeated=True)
  command = _messages.StringField(2, repeated=True)
  imageUri = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1CreateDatasetOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.CreateDataset.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1CreateEndpointOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.CreateEndpoint.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1CreateSpecialistPoolOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  SpecialistPoolService.CreateSpecialistPool.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1CustomJob(_messages.Message):
  r"""Represents a job that runs custom workloads such as a Docker container
  or a Python package. A CustomJob can have multiple worker pools and each
  worker pool can have its own machine and input spec. A CustomJob will be
  cleaned up once the job enters terminal state (failed or succeeded).

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the job.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize CustomJobs.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.

  Fields:
    createTime: Output only. Time when the CustomJob was created.
    displayName: Required. The display name of the CustomJob. The name can be
      up to 128 characters long and can be consist of any UTF-8 characters.
    encryptionSpec: Customer-managed encryption key options for a CustomJob.
      If this is set, then all resources created by the CustomJob will be
      encrypted with the provided encryption key.
    endTime: Output only. Time when the CustomJob entered any of the following
      states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
      `JOB_STATE_CANCELLED`.
    error: Output only. Only populated when job's state is `JOB_STATE_FAILED`
      or `JOB_STATE_CANCELLED`.
    jobSpec: Required. Job spec.
    labels: The labels with user-defined metadata to organize CustomJobs.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.
    name: Output only. Resource name of a CustomJob.
    startTime: Output only. Time when the CustomJob for the first time entered
      the `JOB_STATE_RUNNING` state.
    state: Output only. The detailed state of the job.
    updateTime: Output only. Time when the CustomJob was most recently
      updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the job.

    Values:
      JOB_STATE_UNSPECIFIED: The job state is unspecified.
      JOB_STATE_QUEUED: The job has been just created or resumed and
        processing has not yet begun.
      JOB_STATE_PENDING: The service is preparing to run the job.
      JOB_STATE_RUNNING: The job is in progress.
      JOB_STATE_SUCCEEDED: The job completed successfully.
      JOB_STATE_FAILED: The job failed.
      JOB_STATE_CANCELLING: The job is being cancelled. From this state the
        job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
        `JOB_STATE_CANCELLED`.
      JOB_STATE_CANCELLED: The job has been cancelled.
      JOB_STATE_PAUSED: The job has been stopped, and can be resumed.
    """
    JOB_STATE_UNSPECIFIED = 0
    JOB_STATE_QUEUED = 1
    JOB_STATE_PENDING = 2
    JOB_STATE_RUNNING = 3
    JOB_STATE_SUCCEEDED = 4
    JOB_STATE_FAILED = 5
    JOB_STATE_CANCELLING = 6
    JOB_STATE_CANCELLED = 7
    JOB_STATE_PAUSED = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize CustomJobs. Label
    keys and values can be no longer than 64 characters (Unicode codepoints),
    can only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. See https://goo.gl/xmQnxf
    for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1EncryptionSpec', 3)
  endTime = _messages.StringField(4)
  error = _messages.MessageField('GoogleRpcStatus', 5)
  jobSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1CustomJobSpec', 6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  startTime = _messages.StringField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  updateTime = _messages.StringField(11)


class GoogleCloudAiplatformV1alpha1CustomJobSpec(_messages.Message):
  r"""Represents the spec of a CustomJob.

  Fields:
    scheduling: Scheduling options for a CustomJob.
    serviceAccount: Specifies the service account for workload run-as account.
      Users submitting jobs must have act-as permission on this run-as
      account. If unspecified, the AI Platform Custom Code Service Agent for
      the CustomJob's project is used.
    workerPoolSpecs: Required. The spec of the worker pools including machine
      type and Docker image.
  """

  scheduling = _messages.MessageField('GoogleCloudAiplatformV1alpha1Scheduling', 1)
  serviceAccount = _messages.StringField(2)
  workerPoolSpecs = _messages.MessageField('GoogleCloudAiplatformV1alpha1WorkerPoolSpec', 3, repeated=True)


class GoogleCloudAiplatformV1alpha1DataItem(_messages.Message):
  r"""A piece of data in a Dataset. Could be an image, a video, a document or
  plain text.

  Messages:
    LabelsValue: Optional. The labels with user-defined metadata to organize
      your DataItems. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      DataItem(System labels are excluded). See https://goo.gl/xmQnxf for more
      information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.

  Fields:
    createTime: Output only. Timestamp when this DataItem was created.
    etag: Optional. Used to perform a consistent read-modify-write updates. If
      not set, a blind "overwrite" update happens.
    labels: Optional. The labels with user-defined metadata to organize your
      DataItems. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one
      DataItem(System labels are excluded). See https://goo.gl/xmQnxf for more
      information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable.
    name: Output only. The resource name of the DataItem.
    payload: Required. The data that the DataItem represents (for example, an
      image or a text snippet). The schema of the payload is stored in the
      parent Dataset's metadata schema's dataItemSchemaUri field.
    updateTime: Output only. Timestamp when this DataItem was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels with user-defined metadata to organize your
    DataItems. Label keys and values can be no longer than 64 characters
    (Unicode codepoints), can only contain lowercase letters, numeric
    characters, underscores and dashes. International characters are allowed.
    No more than 64 user labels can be associated with one DataItem(System
    labels are excluded). See https://goo.gl/xmQnxf for more information and
    examples of labels. System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  etag = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  payload = _messages.MessageField('extra_types.JsonValue', 5)
  updateTime = _messages.StringField(6)


class GoogleCloudAiplatformV1alpha1DataLabelingJob(_messages.Message):
  r"""DataLabelingJob is used to trigger a human labeling job on unlabeled
  data from the following Dataset:

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the job.

  Messages:
    AnnotationLabelsValue: Labels to assign to annotations generated by this
      DataLabelingJob. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable.
    LabelsValue: The labels with user-defined metadata to organize your
      DataLabelingJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable. Following system labels
      exist for each DataLabelingJob: * "aiplatform.googleapis.com/schema":
      output only, its value is the inputs_schema's title.

  Fields:
    activeLearningConfig: Parameters that configure active learning pipeline.
      Active learning will label the data incrementally via several
      iterations. For every iteration, it will select a batch of data based on
      the sampling strategy.
    annotationLabels: Labels to assign to annotations generated by this
      DataLabelingJob. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable.
    createTime: Output only. Timestamp when this DataLabelingJob was created.
    currentSpend: Output only. Estimated cost(in US dollars) that the
      DataLabelingJob has incurred to date.
    datasets: Required. Dataset resource names. Right now we only support
      labeling from a single Dataset. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`
    displayName: Required. The user-defined name of the DataLabelingJob. The
      name can be up to 128 characters long and can be consist of any UTF-8
      characters. Display name of a DataLabelingJob.
    error: Output only. DataLabelingJob errors. It is only populated when
      job's state is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
    inputs: Required. Input config parameters for the DataLabelingJob.
    inputsSchemaUri: Required. Points to a YAML file stored on Google Cloud
      Storage describing the config for a specific type of DataLabelingJob.
      The schema files that can be used here are found in the
      https://storage.googleapis.com/google-cloud-aiplatform bucket in the
      /schema/datalabelingjob/inputs/ folder.
    instructionUri: Required. The Google Cloud Storage location of the
      instruction pdf. This pdf is shared with labelers, and provides detailed
      description on how to label DataItems in Datasets.
    labelerCount: Required. Number of labelers to work on each DataItem.
    labelingProgress: Output only. Current labeling job progress percentage
      scaled in interval [0, 100], indicating the percentage of DataItems that
      has been finished.
    labels: The labels with user-defined metadata to organize your
      DataLabelingJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable. Following system labels
      exist for each DataLabelingJob: * "aiplatform.googleapis.com/schema":
      output only, its value is the inputs_schema's title.
    name: Output only. Resource name of the DataLabelingJob.
    specialistPools: The SpecialistPools' resource names associated with this
      job.
    state: Output only. The detailed state of the job.
    updateTime: Output only. Timestamp when this DataLabelingJob was updated
      most recently.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the job.

    Values:
      JOB_STATE_UNSPECIFIED: The job state is unspecified.
      JOB_STATE_QUEUED: The job has been just created or resumed and
        processing has not yet begun.
      JOB_STATE_PENDING: The service is preparing to run the job.
      JOB_STATE_RUNNING: The job is in progress.
      JOB_STATE_SUCCEEDED: The job completed successfully.
      JOB_STATE_FAILED: The job failed.
      JOB_STATE_CANCELLING: The job is being cancelled. From this state the
        job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
        `JOB_STATE_CANCELLED`.
      JOB_STATE_CANCELLED: The job has been cancelled.
      JOB_STATE_PAUSED: The job has been stopped, and can be resumed.
    """
    JOB_STATE_UNSPECIFIED = 0
    JOB_STATE_QUEUED = 1
    JOB_STATE_PENDING = 2
    JOB_STATE_RUNNING = 3
    JOB_STATE_SUCCEEDED = 4
    JOB_STATE_FAILED = 5
    JOB_STATE_CANCELLING = 6
    JOB_STATE_CANCELLED = 7
    JOB_STATE_PAUSED = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationLabelsValue(_messages.Message):
    r"""Labels to assign to annotations generated by this DataLabelingJob.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. See
    https://goo.gl/xmQnxf for more information and examples of labels. System
    reserved label keys are prefixed with "aiplatform.googleapis.com/" and are
    immutable.

    Messages:
      AdditionalProperty: An additional property for a AnnotationLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        AnnotationLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your
    DataLabelingJobs. Label keys and values can be no longer than 64
    characters (Unicode codepoints), can only contain lowercase letters,
    numeric characters, underscores and dashes. International characters are
    allowed. See https://goo.gl/xmQnxf for more information and examples of
    labels. System reserved label keys are prefixed with
    "aiplatform.googleapis.com/" and are immutable. Following system labels
    exist for each DataLabelingJob: * "aiplatform.googleapis.com/schema":
    output only, its value is the inputs_schema's title.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  activeLearningConfig = _messages.MessageField('GoogleCloudAiplatformV1alpha1ActiveLearningConfig', 1)
  annotationLabels = _messages.MessageField('AnnotationLabelsValue', 2)
  createTime = _messages.StringField(3)
  currentSpend = _messages.MessageField('GoogleTypeMoney', 4)
  datasets = _messages.StringField(5, repeated=True)
  displayName = _messages.StringField(6)
  error = _messages.MessageField('GoogleRpcStatus', 7)
  inputs = _messages.MessageField('extra_types.JsonValue', 8)
  inputsSchemaUri = _messages.StringField(9)
  instructionUri = _messages.StringField(10)
  labelerCount = _messages.IntegerField(11, variant=_messages.Variant.INT32)
  labelingProgress = _messages.IntegerField(12, variant=_messages.Variant.INT32)
  labels = _messages.MessageField('LabelsValue', 13)
  name = _messages.StringField(14)
  specialistPools = _messages.StringField(15, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 16)
  updateTime = _messages.StringField(17)


class GoogleCloudAiplatformV1alpha1Dataset(_messages.Message):
  r"""A collection of DataItems and Annotations on them.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Datasets. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. No more than 64 user labels can be associated with one Dataset
      (System labels are excluded). See https://goo.gl/xmQnxf for more
      information and examples of labels. System reserved label keys are
      prefixed with "aiplatform.googleapis.com/" and are immutable. Following
      system labels exist for each Dataset: *
      "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
      value is the metadata_schema's title.

  Fields:
    createTime: Output only. Timestamp when this Dataset was created.
    displayName: Required. The user-defined name of the Dataset. The name can
      be up to 128 characters long and can be consist of any UTF-8 characters.
    encryptionSpec: Customer-managed encryption key spec for a Dataset. If
      set, this Dataset and all sub-resources of this Dataset will be secured
      by this key.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    labels: The labels with user-defined metadata to organize your Datasets.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. No more
      than 64 user labels can be associated with one Dataset (System labels
      are excluded). See https://goo.gl/xmQnxf for more information and
      examples of labels. System reserved label keys are prefixed with
      "aiplatform.googleapis.com/" and are immutable. Following system labels
      exist for each Dataset: *
      "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
      value is the metadata_schema's title.
    metadata: Required. Additional information about the Dataset.
    metadataSchemaUri: Required. Points to a YAML file stored on Google Cloud
      Storage describing additional information about the Dataset. The schema
      is defined as an OpenAPI 3.0.2 Schema Object. The schema files that can
      be used here are found in gs://google-cloud-
      aiplatform/schema/dataset/metadata/.
    name: Output only. The resource name of the Dataset.
    updateTime: Output only. Timestamp when this Dataset was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Datasets. Label
    keys and values can be no longer than 64 characters (Unicode codepoints),
    can only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. No more than 64 user labels
    can be associated with one Dataset (System labels are excluded). See
    https://goo.gl/xmQnxf for more information and examples of labels. System
    reserved label keys are prefixed with "aiplatform.googleapis.com/" and are
    immutable. Following system labels exist for each Dataset: *
    "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
    value is the metadata_schema's title.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1EncryptionSpec', 3)
  etag = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  metadata = _messages.MessageField('extra_types.JsonValue', 6)
  metadataSchemaUri = _messages.StringField(7)
  name = _messages.StringField(8)
  updateTime = _messages.StringField(9)


class GoogleCloudAiplatformV1alpha1DedicatedResources(_messages.Message):
  r"""A description of resources that are dedicated to a DeployedModel, and
  that need a higher degree of manual configuration.

  Fields:
    machineSpec: Required. Immutable. The specification of a single machine
      used by the prediction.
    minReplicaCount: Required. Immutable. The minimum number of machine
      replicas this DeployedModel will be always deployed on. If traffic
      against it increases, it may dynamically be deployed onto more replicas,
      and as traffic decreases, some of these extra replicas may be freed.
      Note: if machine_spec.accelerator_count is above 0, currently the model
      will be always deployed precisely on min_replica_count.
  """

  machineSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1MachineSpec', 1)
  minReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1alpha1DeleteOperationMetadata(_messages.Message):
  r"""Details of operations that perform deletes of any entities.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1DeployModelOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.DeployModel.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1DeployModelRequest(_messages.Message):
  r"""Request message for EndpointService.DeployModel.

  Messages:
    TrafficSplitValue: A map from a DeployedModel's ID to the percentage of
      this Endpoint's traffic that should be forwarded to that DeployedModel.
      If this field is non-empty, then the Endpoint's traffic_split will be
      overwritten with it. To refer to the ID of the just being deployed
      Model, a "0" should be used, and the actual ID of the new DeployedModel
      will be filled in its place by this method. The traffic percentage
      values must add up to 100. If this field is empty, then the Endpoint's
      traffic_split is not updated.

  Fields:
    deployedModel: Required. The DeployedModel to be created within the
      Endpoint. Note that Endpoint.traffic_split must be updated for the
      DeployedModel to start receiving traffic, either as part of this call,
      or via EndpointService.UpdateEndpoint.
    trafficSplit: A map from a DeployedModel's ID to the percentage of this
      Endpoint's traffic that should be forwarded to that DeployedModel. If
      this field is non-empty, then the Endpoint's traffic_split will be
      overwritten with it. To refer to the ID of the just being deployed
      Model, a "0" should be used, and the actual ID of the new DeployedModel
      will be filled in its place by this method. The traffic percentage
      values must add up to 100. If this field is empty, then the Endpoint's
      traffic_split is not updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TrafficSplitValue(_messages.Message):
    r"""A map from a DeployedModel's ID to the percentage of this Endpoint's
    traffic that should be forwarded to that DeployedModel. If this field is
    non-empty, then the Endpoint's traffic_split will be overwritten with it.
    To refer to the ID of the just being deployed Model, a "0" should be used,
    and the actual ID of the new DeployedModel will be filled in its place by
    this method. The traffic percentage values must add up to 100. If this
    field is empty, then the Endpoint's traffic_split is not updated.

    Messages:
      AdditionalProperty: An additional property for a TrafficSplitValue
        object.

    Fields:
      additionalProperties: Additional properties of type TrafficSplitValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TrafficSplitValue object.

      Fields:
        key: Name of the additional property.
        value: A integer attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2, variant=_messages.Variant.INT32)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  deployedModel = _messages.MessageField('GoogleCloudAiplatformV1alpha1DeployedModel', 1)
  trafficSplit = _messages.MessageField('TrafficSplitValue', 2)


class GoogleCloudAiplatformV1alpha1DeployModelResponse(_messages.Message):
  r"""Response message for EndpointService.DeployModel.

  Fields:
    deployedModel: The DeployedModel that had been deployed in the Endpoint.
  """

  deployedModel = _messages.MessageField('GoogleCloudAiplatformV1alpha1DeployedModel', 1)


class GoogleCloudAiplatformV1alpha1DeployedModel(_messages.Message):
  r"""A deployment of a Model. Endpoints contain one or more DeployedModels.

  Fields:
    automaticResources: A description of resources that to large degree are
      decided by AI Platform, and require only a modest additional
      configuration.
    createTime: Output only. Timestamp when the DeployedModel was created.
    dedicatedResources: A description of resources that are dedicated to the
      DeployedModel, and that need a higher degree of manual configuration.
    displayName: The display name of the DeployedModel. If not provided upon
      creation, the Model's display_name is used.
    explanationSpec: Explanation configuration for this DeployedModel. When
      deploying a Model using EndpointService.DeployModel, this value
      overrides the value of Model.explanation_spec. All fields of
      explanation_spec are optional in the request. If a field of
      explanation_spec is not populated, the value of the same field of
      Model.explanation_spec is inherited. The corresponding
      Model.explanation_spec must be populated, otherwise explanation for this
      Model is not allowed.
    id: Output only. The ID of the DeployedModel.
    model: Required. The name of the Model this is the deployment of. Note
      that the Model may be in a different location than the DeployedModel's
      Endpoint.
  """

  automaticResources = _messages.MessageField('GoogleCloudAiplatformV1alpha1AutomaticResources', 1)
  createTime = _messages.StringField(2)
  dedicatedResources = _messages.MessageField('GoogleCloudAiplatformV1alpha1DedicatedResources', 3)
  displayName = _messages.StringField(4)
  explanationSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExplanationSpec', 5)
  id = _messages.StringField(6)
  model = _messages.StringField(7)


class GoogleCloudAiplatformV1alpha1DeployedModelRef(_messages.Message):
  r"""Points to a DeployedModel.

  Fields:
    deployedModelId: Immutable. An ID of a DeployedModel in the above
      Endpoint.
    endpoint: Immutable. A resource name of an Endpoint.
  """

  deployedModelId = _messages.StringField(1)
  endpoint = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1EncryptionSpec(_messages.Message):
  r"""Represents a customer-managed encryption key spec that can be applied to
  a top-level resource.

  Fields:
    kmsKeyName: Required. The Cloud KMS resource identifier of the customer
      managed encryption key used to protect a resource. Has the form:
      `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-
      key`. The key needs to be in the same region as where the compute
      resource is created.
  """

  kmsKeyName = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1Endpoint(_messages.Message):
  r"""Models are deployed into it, and afterwards Endpoint is called to obtain
  predictions and explanations.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Endpoints. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.
    TrafficSplitValue: A map from a DeployedModel's ID to the percentage of
      this Endpoint's traffic that should be forwarded to that DeployedModel.
      If a DeployedModel's ID is not listed in this map, then it receives no
      traffic. The traffic percentage values must add up to 100, or map must
      be empty if the Endpoint is to not accept any traffic at a moment.

  Fields:
    createTime: Output only. Timestamp when this Endpoint was created.
    deployedModels: Output only. The models deployed in this Endpoint. To add
      or remove DeployedModels use EndpointService.DeployModel and
      EndpointService.UndeployModel respectively.
    description: The description of the Endpoint.
    displayName: Required. The display name of the Endpoint. The name can be
      up to 128 characters long and can be consist of any UTF-8 characters.
    encryptionSpec: Customer-managed encryption key spec for an Endpoint. If
      set, this Endpoint and all sub-resources of this Endpoint will be
      secured by this key.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    labels: The labels with user-defined metadata to organize your Endpoints.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.
    name: Output only. The resource name of the Endpoint.
    trafficSplit: A map from a DeployedModel's ID to the percentage of this
      Endpoint's traffic that should be forwarded to that DeployedModel. If a
      DeployedModel's ID is not listed in this map, then it receives no
      traffic. The traffic percentage values must add up to 100, or map must
      be empty if the Endpoint is to not accept any traffic at a moment.
    updateTime: Output only. Timestamp when this Endpoint was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Endpoints.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. See
    https://goo.gl/xmQnxf for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TrafficSplitValue(_messages.Message):
    r"""A map from a DeployedModel's ID to the percentage of this Endpoint's
    traffic that should be forwarded to that DeployedModel. If a
    DeployedModel's ID is not listed in this map, then it receives no traffic.
    The traffic percentage values must add up to 100, or map must be empty if
    the Endpoint is to not accept any traffic at a moment.

    Messages:
      AdditionalProperty: An additional property for a TrafficSplitValue
        object.

    Fields:
      additionalProperties: Additional properties of type TrafficSplitValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TrafficSplitValue object.

      Fields:
        key: Name of the additional property.
        value: A integer attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2, variant=_messages.Variant.INT32)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  deployedModels = _messages.MessageField('GoogleCloudAiplatformV1alpha1DeployedModel', 2, repeated=True)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1EncryptionSpec', 5)
  etag = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  trafficSplit = _messages.MessageField('TrafficSplitValue', 9)
  updateTime = _messages.StringField(10)


class GoogleCloudAiplatformV1alpha1EnvVar(_messages.Message):
  r"""Represents an environment variable present in a Container or Python
  Module.

  Fields:
    name: Required. Name of the environment variable. Must be a valid C
      identifier.
    value: Required. Variables that reference a $(VAR_NAME) are expanded using
      the previous defined environment variables in the container and any
      service environment variables. If a variable cannot be resolved, the
      reference in the input string will be unchanged. The $(VAR_NAME) syntax
      can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references
      will never be expanded, regardless of whether the variable exists or
      not.
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1ExplainRequest(_messages.Message):
  r"""Request message for PredictionService.Explain.

  Fields:
    deployedModelId: If specified, this ExplainRequest will be served by the
      chosen DeployedModel, overriding Endpoint.traffic_split.
    instances: Required. The instances that are the input to the explanation
      call. A DeployedModel may have an upper limit on the number of instances
      it supports per request, and when it is exceeded the explanation call
      errors in case of AutoML Models, or, in case of customer created Models,
      the behaviour is as documented by that Model. The schema of any single
      instance may be specified via Endpoint's DeployedModels' Model's
      PredictSchemata's instance_schema_uri.
    parameters: The parameters that govern the prediction. The schema of the
      parameters may be specified via Endpoint's DeployedModels' Model's
      PredictSchemata's parameters_schema_uri.
  """

  deployedModelId = _messages.StringField(1)
  instances = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)
  parameters = _messages.MessageField('extra_types.JsonValue', 3)


class GoogleCloudAiplatformV1alpha1ExplainResponse(_messages.Message):
  r"""Response message for PredictionService.Explain.

  Fields:
    deployedModelId: ID of the Endpoint's DeployedModel that served this
      explanation.
    explanations: The explanations of the Model's PredictResponse.predictions.
      It has the same number of elements as instances to be explained.
    predictions: The predictions that are the output of the predictions call.
      Same as PredictResponse.predictions.
  """

  deployedModelId = _messages.StringField(1)
  explanations = _messages.MessageField('GoogleCloudAiplatformV1alpha1Explanation', 2, repeated=True)
  predictions = _messages.MessageField('extra_types.JsonValue', 3, repeated=True)


class GoogleCloudAiplatformV1alpha1Explanation(_messages.Message):
  r"""Explanation of a prediction (provided in PredictResponse.predictions)
  produced by the Model on a given instance.

  Fields:
    attributions: Output only. Feature attributions grouped by predicted
      outputs. For Models that predict only one output, such as regression
      Models that predict only one score, there is only one attibution that
      explains the predicted output. For Models that predict multiple outputs,
      such as multiclass Models that predict multiple classes, each element
      explains one specific item. Attribution.output_index can be used to
      identify which output this attribution is explaining. If users set
      ExplanationParameters.top_k, the attributions are sorted by
      instance_output_value in descending order. If
      ExplanationParameters.output_indices is specified, the attributions are
      stored by Attribution.output_index in the same order as they appear in
      the output_indices.
  """

  attributions = _messages.MessageField('GoogleCloudAiplatformV1alpha1Attribution', 1, repeated=True)


class GoogleCloudAiplatformV1alpha1ExplanationMetadata(_messages.Message):
  r"""Metadata describing the Model's input and output for explanation.

  Messages:
    InputsValue: Required. Map from feature names to feature input metadata.
      Keys are the name of the features. Values are the specification of the
      feature. An empty InputMetadata is valid. It describes a text feature
      which has the name specified as the key in ExplanationMetadata.inputs.
      The baseline of the empty feature is chosen by AI Platform. For AI
      Platform provided Tensorflow images, the key can be any friendly name of
      the feature. Once specified, featureAttributions are keyed by this key
      (if not grouped with another feature). For custom images, the key must
      match with the key in instance.
    OutputsValue: Required. Map from output names to output metadata. For AI
      Platform provided Tensorflow images, keys can be any string user
      defines. For custom images, keys are the name of the output field in the
      prediction to be explained. Currently only one key is allowed.

  Fields:
    featureAttributionsSchemaUri: Points to a YAML file stored on Google Cloud
      Storage describing the format of the feature attributions. The schema is
      defined as an OpenAPI 3.0.2 [Schema
      Object](https://tinyurl.com/y538mdwt#schema-object). AutoML tabular
      Models always have this field populated by AI Platform. Note: The URI
      given on output may be different, including the URI scheme, than the one
      given on input. The output URI will point to a location where the user
      only has a read access.
    inputs: Required. Map from feature names to feature input metadata. Keys
      are the name of the features. Values are the specification of the
      feature. An empty InputMetadata is valid. It describes a text feature
      which has the name specified as the key in ExplanationMetadata.inputs.
      The baseline of the empty feature is chosen by AI Platform. For AI
      Platform provided Tensorflow images, the key can be any friendly name of
      the feature. Once specified, featureAttributions are keyed by this key
      (if not grouped with another feature). For custom images, the key must
      match with the key in instance.
    outputs: Required. Map from output names to output metadata. For AI
      Platform provided Tensorflow images, keys can be any string user
      defines. For custom images, keys are the name of the output field in the
      prediction to be explained. Currently only one key is allowed.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InputsValue(_messages.Message):
    r"""Required. Map from feature names to feature input metadata. Keys are
    the name of the features. Values are the specification of the feature. An
    empty InputMetadata is valid. It describes a text feature which has the
    name specified as the key in ExplanationMetadata.inputs. The baseline of
    the empty feature is chosen by AI Platform. For AI Platform provided
    Tensorflow images, the key can be any friendly name of the feature. Once
    specified, featureAttributions are keyed by this key (if not grouped with
    another feature). For custom images, the key must match with the key in
    instance.

    Messages:
      AdditionalProperty: An additional property for a InputsValue object.

    Fields:
      additionalProperties: Additional properties of type InputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1alpha1ExplanationMetadataInputMetadata
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExplanationMetadataInputMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OutputsValue(_messages.Message):
    r"""Required. Map from output names to output metadata. For AI Platform
    provided Tensorflow images, keys can be any string user defines. For
    custom images, keys are the name of the output field in the prediction to
    be explained. Currently only one key is allowed.

    Messages:
      AdditionalProperty: An additional property for a OutputsValue object.

    Fields:
      additionalProperties: Additional properties of type OutputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OutputsValue object.

      Fields:
        key: Name of the additional property.
        value: A
          GoogleCloudAiplatformV1alpha1ExplanationMetadataOutputMetadata
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExplanationMetadataOutputMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  featureAttributionsSchemaUri = _messages.StringField(1)
  inputs = _messages.MessageField('InputsValue', 2)
  outputs = _messages.MessageField('OutputsValue', 3)


class GoogleCloudAiplatformV1alpha1ExplanationMetadataInputMetadata(_messages.Message):
  r"""Metadata of the input of a feature. Fields other than
  InputMetadata.input_baselines are applicable only for Models that are using
  AI Platform-provided images for Tensorflow.

  Fields:
    inputBaselines: Baseline inputs for this feature. If no baseline is
      specified, AI Platform chooses the baseline for this feature. If
      multiple baselines are specified, AI Platform returns the average
      attributions across them in Attributions.baseline_attribution. For AI
      Platform provided Tensorflow images (both 1.x and 2.x), the shape of
      each baseline must match the shape of the input tensor. If a scalar is
      provided, we broadcast to the same shape as the input tensor. For custom
      images, the element of the baselines must be in the same format as the
      feature's input in the instance[]. The schema of any single instance may
      be specified via Endpoint's DeployedModels' Model's PredictSchemata's
      instance_schema_uri.
  """

  inputBaselines = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)


class GoogleCloudAiplatformV1alpha1ExplanationMetadataOutputMetadata(_messages.Message):
  r"""Metadata of the prediction output to be explained.

  Fields:
    displayNameMappingKey: Specify a field name in the prediction to look for
      the display name. Use this if the prediction contains the display names
      for the outputs. The display names in the prediction must have the same
      shape of the outputs, so that it can be located by
      Attribution.output_index for a specific output.
    indexDisplayNameMapping: Static mapping between the index and display
      name. Use this if the outputs are a deterministic n-dimensional array,
      e.g. a list of scores of all the classes in a pre-defined order for a
      multi-classification Model. It's not feasible if the outputs are non-
      deterministic, e.g. the Model produces top-k classes or sort the outputs
      by their values. The shape of the value must be an n-dimensional array
      of strings. The number of dimentions must match that of the outputs to
      be explained. The Attribution.output_display_name is populated by
      locating in the mapping with Attribution.output_index.
  """

  displayNameMappingKey = _messages.StringField(1)
  indexDisplayNameMapping = _messages.MessageField('extra_types.JsonValue', 2)


class GoogleCloudAiplatformV1alpha1ExplanationParameters(_messages.Message):
  r"""Parameters to configure explaining for Model's predictions.

  Fields:
    sampledShapleyAttribution: An attribution method that approximates Shapley
      values for features that contribute to the label being predicted. A
      sampling strategy is used to approximate the value rather than
      considering all subsets of features. Refer to this paper for model
      details: https://arxiv.org/abs/1306.4265.
  """

  sampledShapleyAttribution = _messages.MessageField('GoogleCloudAiplatformV1alpha1SampledShapleyAttribution', 1)


class GoogleCloudAiplatformV1alpha1ExplanationSpec(_messages.Message):
  r"""Specification of Model explanation.

  Fields:
    metadata: Required. Metadata describing the Model's input and output for
      explanation.
    parameters: Required. Parameters that configure explaining of the Model's
      predictions.
  """

  metadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExplanationMetadata', 1)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExplanationParameters', 2)


class GoogleCloudAiplatformV1alpha1ExportDataConfig(_messages.Message):
  r"""Describes what part of the Dataset is to be exported, the destination of
  the export and how to export.

  Fields:
    annotationsFilter: A filter on Annotations of the Dataset. Only
      Annotations on to-be-exported DataItems(specified by data_items_filter)
      that match this filter will be exported. The filter syntax is the same
      as in ListAnnotations.
    gcsDestination: The Google Cloud Storage location where the output is to
      be written to. In the given directory a new directory will be created
      with name: `export-data--` where timestamp is in YYYY-MM-
      DDThh:mm:ss.sssZ ISO-8601 format. All export output will be written into
      that directory. Inside that directory, annotations with the same schema
      will be grouped into sub directories which are named with the
      corresponding annotations' schema title. Inside these sub directories, a
      schema.yaml will be created to describe the output format.
  """

  annotationsFilter = _messages.StringField(1)
  gcsDestination = _messages.MessageField('GoogleCloudAiplatformV1alpha1GcsDestination', 2)


class GoogleCloudAiplatformV1alpha1ExportDataOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.ExportData.

  Fields:
    gcsOutputDirectory: A Google Cloud Storage directory which path ends with
      '/'. The exported data is stored in the directory.
    genericMetadata: The common part of the operation metadata.
  """

  gcsOutputDirectory = _messages.StringField(1)
  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 2)


class GoogleCloudAiplatformV1alpha1ExportDataRequest(_messages.Message):
  r"""Request message for DatasetService.ExportData.

  Fields:
    exportConfig: Required. The desired output location.
  """

  exportConfig = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExportDataConfig', 1)


class GoogleCloudAiplatformV1alpha1ExportDataResponse(_messages.Message):
  r"""Response message for DatasetService.ExportData.

  Fields:
    exportedFiles: All of the files that are exported in this export
      operation.
  """

  exportedFiles = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1alpha1ExportEvaluatedDataItemsOperationMetadata(_messages.Message):
  r"""Details of ModelService.ExportEvaluatedDataItems operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
    outputInfo: Output only. Information further describing the output of this
      operation.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)
  outputInfo = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExportEvaluatedDataItemsOperationMetadataOutputInfo', 2)


class GoogleCloudAiplatformV1alpha1ExportEvaluatedDataItemsOperationMetadataOutputInfo(_messages.Message):
  r"""Further describes this operation's output. Supplements
  ExportEvaluatedDataItemsRequest.output_config.

  Fields:
    bigqueryOutputDataset: Output only. The path of the BigQuery dataset
      created, in bq://projectId.bqDatasetId.tableId format, into which the
      evaluated DataItems are exported.
  """

  bigqueryOutputDataset = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1ExportEvaluatedDataItemsOperationResponse(_messages.Message):
  r"""Response of ModelService.ExportEvaluatedDataItems operation."""


class GoogleCloudAiplatformV1alpha1ExportEvaluatedDataItemsRequest(_messages.Message):
  r"""Request message for ModelService.ExportEvaluatedDataItems.

  Fields:
    outputConfig: Required. The desired output location and configuration.
  """

  outputConfig = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExportEvaluatedDataItemsRequestOutputConfig', 1)


class GoogleCloudAiplatformV1alpha1ExportEvaluatedDataItemsRequestOutputConfig(_messages.Message):
  r"""Output configuration for the exported DataItems.

  Fields:
    bigqueryDestination: Required. The BigQuery location where the output is
      to be written to. In the given project a new dataset will be created
      with name `export_evaluated_dataitems__` where `` will be made BigQuery-
      dataset-name compatible (e.g. most special characters will become
      underscores), and timestamp will be in YYYY_MM_DDThh_mm_ss_sssZ "based
      on ISO-8601" format. In the dataset an `evaluated_dataitems` table will
      be created. If the Model has both instance and prediction schemata
      defined, the table will have columns that include: * Instances of the
      test data, as per the instance schema. * Ground truth of the test data,
      as per the prediction schema. * Modle predicted results on the
      instances. The column names are in the format of `predicted_`.
      field_name is the corresponding field of the prediction as per
      prediction schema. NOTE: For AutoML tabular Models, the ground truth is
      the target column. There is one prediction column, named `predicted_`.
  """

  bigqueryDestination = _messages.MessageField('GoogleCloudAiplatformV1alpha1BigQueryDestination', 1)


class GoogleCloudAiplatformV1alpha1ExportModelOperationMetadata(_messages.Message):
  r"""Details of ModelService.ExportModel operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
    outputInfo: Output only. Information further describing the output of this
      Model export.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)
  outputInfo = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExportModelOperationMetadataOutputInfo', 2)


class GoogleCloudAiplatformV1alpha1ExportModelOperationMetadataOutputInfo(_messages.Message):
  r"""Further describes the output of the ExportModel. Supplements
  ExportModelRequest.OutputConfig.

  Fields:
    gcsOutputDirectory: Output only. If the Model is being exported to Google
      Cloud Storage this is the full path of the directory created, into which
      the Model files are being written to.
  """

  gcsOutputDirectory = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1ExportModelRequest(_messages.Message):
  r"""Request message for ModelService.ExportModel.

  Fields:
    outputConfig: Required. The desired output location and configuration.
  """

  outputConfig = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExportModelRequestOutputConfig', 1)


class GoogleCloudAiplatformV1alpha1ExportModelRequestOutputConfig(_messages.Message):
  r"""Output configuration for the Model export.

  Fields:
    exportFormatId: The ID of the format in which the Model must be exported.
      Each Model lists the export formats it supports. If no value is provided
      here, then the first from the list of the Model's supported formats is
      used by default.
    gcsDestination: The Google Cloud Storage location where the Model is to be
      written to. Under the specified destination directory, a new directory
      is created with the name `model-export--`, where timestamp is in `YYYY-
      MM-DDThh:mm:ss.sssZ` ISO-8601 format. The Model and all of its
      supporting files are placed in the new directory.
  """

  exportFormatId = _messages.StringField(1)
  gcsDestination = _messages.MessageField('GoogleCloudAiplatformV1alpha1GcsDestination', 2)


class GoogleCloudAiplatformV1alpha1ExportModelResponse(_messages.Message):
  r"""Response message of ModelService.ExportModel operation."""


class GoogleCloudAiplatformV1alpha1FilterSplit(_messages.Message):
  r"""Assigns input data to training, validation, and test sets based on the
  given filters, data pieces not matched by any filter are ignored. Currently
  only supported for Datasets containing DataItems. If any of the filters in
  this message are to match nothing, then they can be set as '-' (the minus
  sign). Supported only for unstructured Datasets.

  Fields:
    testFilter: Required. A filter on DataItems of the Dataset. DataItems that
      match this filter are used to test the Model. A filter with same syntax
      as the one used in DatasetService.ListDataItems may be used. If a single
      DataItem is matched by more than one of the FilterSplit filters, then it
      is assigned to the first set that applies to it in the training,
      validation, test order.
    trainingFilter: Required. A filter on DataItems of the Dataset. DataItems
      that match this filter are used to train the Model. A filter with same
      syntax as the one used in DatasetService.ListDataItems may be used. If a
      single DataItem is matched by more than one of the FilterSplit filters,
      then it is assigned to the first set that applies to it in the training,
      validation, test order.
    validationFilter: Required. A filter on DataItems of the Dataset.
      DataItems that match this filter are used to validate the Model. A
      filter with same syntax as the one used in DatasetService.ListDataItems
      may be used. If a single DataItem is matched by more than one of the
      FilterSplit filters, then it is assigned to the first set that applies
      to it in the training, validation, test order.
  """

  testFilter = _messages.StringField(1)
  trainingFilter = _messages.StringField(2)
  validationFilter = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1FractionSplit(_messages.Message):
  r"""Assigns the input data to training, validation, and test sets as per the
  given fractions. Any of `training_fraction`, `validation_fraction` and
  `test_fraction` may optionally be provided, they must sum to up to 1. If the
  provided ones sum to less than 1, the remainder is assigned to sets as
  decided by AI Platform. If none of the fractions are set, by default roughly
  80% of data is used for training, 10% for validation, and 10% for test.

  Fields:
    testFraction: The fraction of the input data that is to be used to
      evaluate the Model.
    trainingFraction: The fraction of the input data that is to be used to
      train the Model.
    validationFraction: The fraction of the input data that is to be used to
      validate the Model.
  """

  testFraction = _messages.FloatField(1)
  trainingFraction = _messages.FloatField(2)
  validationFraction = _messages.FloatField(3)


class GoogleCloudAiplatformV1alpha1GcsDestination(_messages.Message):
  r"""The Google Cloud Storage location where the output is to be written to.

  Fields:
    outputUriPrefix: Required. Google Cloud Storage URI to output directory.
      If the uri doesn't end with '/', a '/' will be automatically appended.
      The directory is created if it doesn't exist.
  """

  outputUriPrefix = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1GcsSource(_messages.Message):
  r"""The Google Cloud Storage location for the input content.

  Fields:
    uris: Required. Google Cloud Storage URI(-s) to the input file(s). May
      contain wildcards. For more information on wildcards, see
      https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames.
  """

  uris = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1alpha1GenericOperationMetadata(_messages.Message):
  r"""Generic Metadata shared by all operations.

  Fields:
    createTime: Output only. Time when the operation was created.
    partialFailures: Output only. Partial failures encountered. E.g. single
      files that couldn't be read. This field should never exceed 20 entries.
      Status details field will contain standard GCP error details.
    updateTime: Output only. Time when the operation was updated for the last
      time. If the operation has finished (successfully or not), this is the
      finish time.
  """

  createTime = _messages.StringField(1)
  partialFailures = _messages.MessageField('GoogleRpcStatus', 2, repeated=True)
  updateTime = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1HyperparameterTuningJob(_messages.Message):
  r"""Represents a HyperparameterTuningJob. A HyperparameterTuningJob has a
  Study specification and multiple CustomJobs with identical CustomJob
  specification.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the job.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize
      HyperparameterTuningJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    createTime: Output only. Time when the HyperparameterTuningJob was
      created.
    displayName: Required. The display name of the HyperparameterTuningJob.
      The name can be up to 128 characters long and can be consist of any
      UTF-8 characters.
    encryptionSpec: Customer-managed encryption key options for a
      HyperparameterTuningJob. If this is set, then all resources created by
      the HyperparameterTuningJob will be encrypted with the provided
      encryption key.
    endTime: Output only. Time when the HyperparameterTuningJob entered any of
      the following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
      `JOB_STATE_CANCELLED`.
    error: Output only. Only populated when job's state is JOB_STATE_FAILED or
      JOB_STATE_CANCELLED.
    labels: The labels with user-defined metadata to organize
      HyperparameterTuningJobs. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.
    maxFailedTrialCount: The number of failed Trials that need to be seen
      before failing the HyperparameterTuningJob. If set to 0, AI Platform
      decides how many Trials must fail before the whole job fails.
    maxTrialCount: Required. The desired total number of Trials.
    name: Output only. Resource name of the HyperparameterTuningJob.
    parallelTrialCount: Required. The desired number of Trials to run in
      parallel.
    startTime: Output only. Time when the HyperparameterTuningJob for the
      first time entered the `JOB_STATE_RUNNING` state.
    state: Output only. The detailed state of the job.
    studySpec: Required. Study configuration of the HyperparameterTuningJob.
    trialJobSpec: Required. The spec of a trial job. The same spec applies to
      the CustomJobs created in all the trials.
    trials: Output only. Trials of the HyperparameterTuningJob.
    updateTime: Output only. Time when the HyperparameterTuningJob was most
      recently updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the job.

    Values:
      JOB_STATE_UNSPECIFIED: The job state is unspecified.
      JOB_STATE_QUEUED: The job has been just created or resumed and
        processing has not yet begun.
      JOB_STATE_PENDING: The service is preparing to run the job.
      JOB_STATE_RUNNING: The job is in progress.
      JOB_STATE_SUCCEEDED: The job completed successfully.
      JOB_STATE_FAILED: The job failed.
      JOB_STATE_CANCELLING: The job is being cancelled. From this state the
        job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
        `JOB_STATE_CANCELLED`.
      JOB_STATE_CANCELLED: The job has been cancelled.
      JOB_STATE_PAUSED: The job has been stopped, and can be resumed.
    """
    JOB_STATE_UNSPECIFIED = 0
    JOB_STATE_QUEUED = 1
    JOB_STATE_PENDING = 2
    JOB_STATE_RUNNING = 3
    JOB_STATE_SUCCEEDED = 4
    JOB_STATE_FAILED = 5
    JOB_STATE_CANCELLING = 6
    JOB_STATE_CANCELLED = 7
    JOB_STATE_PAUSED = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize
    HyperparameterTuningJobs. Label keys and values can be no longer than 64
    characters (Unicode codepoints), can only contain lowercase letters,
    numeric characters, underscores and dashes. International characters are
    allowed. See https://goo.gl/xmQnxf for more information and examples of
    labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1EncryptionSpec', 3)
  endTime = _messages.StringField(4)
  error = _messages.MessageField('GoogleRpcStatus', 5)
  labels = _messages.MessageField('LabelsValue', 6)
  maxFailedTrialCount = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  maxTrialCount = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  name = _messages.StringField(9)
  parallelTrialCount = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(11)
  state = _messages.EnumField('StateValueValuesEnum', 12)
  studySpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1StudySpec', 13)
  trialJobSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1CustomJobSpec', 14)
  trials = _messages.MessageField('GoogleCloudAiplatformV1alpha1Trial', 15, repeated=True)
  updateTime = _messages.StringField(16)


class GoogleCloudAiplatformV1alpha1ImportDataConfig(_messages.Message):
  r"""Describes the location from where we import data into a Dataset,
  together with the labels that will be applied to the DataItems and the
  Annotations.

  Messages:
    DataItemLabelsValue: Labels that will be applied to newly imported
      DataItems. If an identical DataItem as one being imported already exists
      in the Dataset, then these labels will be appended to these of the
      already existing one, and if labels with identical key is imported
      before, the old label value will be overwritten. If two DataItems are
      identical in the same import data operation, the labels will be combined
      and if key collision happens in this case, one of the values will be
      picked randomly. Two DataItems are considered identical if their content
      bytes are identical (e.g. image bytes or pdf bytes). These labels will
      be overridden by Annotation labels specified inside index file refenced
      by import_schema_uri, e.g. jsonl file.

  Fields:
    dataItemLabels: Labels that will be applied to newly imported DataItems.
      If an identical DataItem as one being imported already exists in the
      Dataset, then these labels will be appended to these of the already
      existing one, and if labels with identical key is imported before, the
      old label value will be overwritten. If two DataItems are identical in
      the same import data operation, the labels will be combined and if key
      collision happens in this case, one of the values will be picked
      randomly. Two DataItems are considered identical if their content bytes
      are identical (e.g. image bytes or pdf bytes). These labels will be
      overridden by Annotation labels specified inside index file refenced by
      import_schema_uri, e.g. jsonl file.
    gcsSource: The Google Cloud Storage location for the input content.
    importSchemaUri: Required. Points to a YAML file stored on Google Cloud
      Storage describing the import format. Validation will be done against
      the schema. The schema is defined as an [OpenAPI 3.0.2 Schema
      Object](https://tinyurl.com/y538mdwt).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DataItemLabelsValue(_messages.Message):
    r"""Labels that will be applied to newly imported DataItems. If an
    identical DataItem as one being imported already exists in the Dataset,
    then these labels will be appended to these of the already existing one,
    and if labels with identical key is imported before, the old label value
    will be overwritten. If two DataItems are identical in the same import
    data operation, the labels will be combined and if key collision happens
    in this case, one of the values will be picked randomly. Two DataItems are
    considered identical if their content bytes are identical (e.g. image
    bytes or pdf bytes). These labels will be overridden by Annotation labels
    specified inside index file refenced by import_schema_uri, e.g. jsonl
    file.

    Messages:
      AdditionalProperty: An additional property for a DataItemLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type DataItemLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DataItemLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  dataItemLabels = _messages.MessageField('DataItemLabelsValue', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1alpha1GcsSource', 2)
  importSchemaUri = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1ImportDataOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.ImportData.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1ImportDataRequest(_messages.Message):
  r"""Request message for DatasetService.ImportData.

  Fields:
    importConfigs: Required. The desired input locations. The contents of all
      input locations will be imported in one batch.
  """

  importConfigs = _messages.MessageField('GoogleCloudAiplatformV1alpha1ImportDataConfig', 1, repeated=True)


class GoogleCloudAiplatformV1alpha1ImportDataResponse(_messages.Message):
  r"""Response message for DatasetService.ImportData."""


class GoogleCloudAiplatformV1alpha1InputDataConfig(_messages.Message):
  r"""Specifies AI Platform owned input data to be used for training, and
  possibly evaluating, the Model.

  Fields:
    annotationsFilter: Applicable only to Datasets that have DataItems and
      Annotations. A filter on Annotations of the Dataset. Only Annotations
      that both match this filter and belong to DataItems not ignored by the
      split method are used in respectively training, validation or test role,
      depending on the role of the DataItem they are on (for the auto-assigned
      that role is decided by AI Platform). A filter with same syntax as the
      one used in ListAnnotations may be used, but note here it filters across
      all Annotations of the Dataset, and not just within a single DataItem.
    datasetId: Required. The ID of the Dataset in the same Project and
      Location which data will be used to train the Model. The Dataset must
      use schema compatible with Model being trained, and what is compatible
      should be described in the used TrainingPipeline's
      training_task_definition. For tabular Datasets, all their data is
      exported to training, to pick and choose from.
    filterSplit: Split based on the provided filters for each set.
    fractionSplit: Split based on fractions defining the size of each set.
    predefinedSplit: Supported only for tabular Datasets. Split based on a
      predefined key.
    timestampSplit: Supported only for tabular Datasets. Split based on the
      timestamp of the input data pieces.
  """

  annotationsFilter = _messages.StringField(1)
  datasetId = _messages.StringField(2)
  filterSplit = _messages.MessageField('GoogleCloudAiplatformV1alpha1FilterSplit', 3)
  fractionSplit = _messages.MessageField('GoogleCloudAiplatformV1alpha1FractionSplit', 4)
  predefinedSplit = _messages.MessageField('GoogleCloudAiplatformV1alpha1PredefinedSplit', 5)
  timestampSplit = _messages.MessageField('GoogleCloudAiplatformV1alpha1TimestampSplit', 6)


class GoogleCloudAiplatformV1alpha1ListAnnotationsResponse(_messages.Message):
  r"""Response message for DatasetService.ListAnnotations.

  Fields:
    annotations: A list of Annotations that matches the specified filter in
      the request.
    nextPageToken: The standard List next-page token.
  """

  annotations = _messages.MessageField('GoogleCloudAiplatformV1alpha1Annotation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1ListBatchPredictionJobsResponse(_messages.Message):
  r"""Response message for JobService.ListBatchPredictionJobs

  Fields:
    batchPredictionJobs: List of BatchPredictionJobs in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListBatchPredictionJobsRequest.page_token to obtain that page.
  """

  batchPredictionJobs = _messages.MessageField('GoogleCloudAiplatformV1alpha1BatchPredictionJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1ListCustomJobsResponse(_messages.Message):
  r"""Response message for JobService.ListCustomJobs

  Fields:
    customJobs: List of CustomJobs in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListCustomJobsRequest.page_token to obtain that page.
  """

  customJobs = _messages.MessageField('GoogleCloudAiplatformV1alpha1CustomJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1ListDataItemsResponse(_messages.Message):
  r"""Response message for DatasetService.ListDataItems.

  Fields:
    dataItems: A list of DataItems that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  dataItems = _messages.MessageField('GoogleCloudAiplatformV1alpha1DataItem', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1ListDataLabelingJobsResponse(_messages.Message):
  r"""Response message for JobService.ListDataLabelingJobs.

  Fields:
    dataLabelingJobs: A list of DataLabelingJobs that matches the specified
      filter in the request.
    nextPageToken: The standard List next-page token.
  """

  dataLabelingJobs = _messages.MessageField('GoogleCloudAiplatformV1alpha1DataLabelingJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1ListDatasetsResponse(_messages.Message):
  r"""Response message for DatasetService.ListDatasets.

  Fields:
    datasets: A list of Datasets that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  datasets = _messages.MessageField('GoogleCloudAiplatformV1alpha1Dataset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1ListEndpointsResponse(_messages.Message):
  r"""Response message for EndpointService.ListEndpoints.

  Fields:
    endpoints: List of Endpoints in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListEndpointsRequest.page_token to obtain that page.
  """

  endpoints = _messages.MessageField('GoogleCloudAiplatformV1alpha1Endpoint', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1ListHyperparameterTuningJobsResponse(_messages.Message):
  r"""Response message for JobService.ListHyperparameterTuningJobs

  Fields:
    hyperparameterTuningJobs: List of HyperparameterTuningJobs in the
      requested page. HyperparameterTuningJob.trials of the jobs will be not
      be returned.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListHyperparameterTuningJobsRequest.page_token to obtain that page.
  """

  hyperparameterTuningJobs = _messages.MessageField('GoogleCloudAiplatformV1alpha1HyperparameterTuningJob', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1ListModelEvaluationSlicesResponse(_messages.Message):
  r"""Response message for ModelService.ListModelEvaluationSlices.

  Fields:
    modelEvaluationSlices: List of ModelEvaluations in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListModelEvaluationSlicesRequest.page_token to obtain that page.
  """

  modelEvaluationSlices = _messages.MessageField('GoogleCloudAiplatformV1alpha1ModelEvaluationSlice', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1ListModelEvaluationsResponse(_messages.Message):
  r"""Response message for ModelService.ListModelEvaluations.

  Fields:
    modelEvaluations: List of ModelEvaluations in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListModelEvaluationsRequest.page_token to obtain that page.
  """

  modelEvaluations = _messages.MessageField('GoogleCloudAiplatformV1alpha1ModelEvaluation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1ListModelsResponse(_messages.Message):
  r"""Response message for ModelService.ListModels

  Fields:
    models: List of Models in the requested page.
    nextPageToken: A token to retrieve next page of results. Pass to
      ListModelsRequest.page_token to obtain that page.
  """

  models = _messages.MessageField('GoogleCloudAiplatformV1alpha1Model', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1ListSpecialistPoolsResponse(_messages.Message):
  r"""Response message for SpecialistPoolService.ListSpecialistPools.

  Fields:
    nextPageToken: The standard List next-page token.
    specialistPools: A list of SpecialistPools that matches the specified
      filter in the request.
  """

  nextPageToken = _messages.StringField(1)
  specialistPools = _messages.MessageField('GoogleCloudAiplatformV1alpha1SpecialistPool', 2, repeated=True)


class GoogleCloudAiplatformV1alpha1ListTrainingPipelinesResponse(_messages.Message):
  r"""Response message for PipelineService.ListTrainingPipelines

  Fields:
    nextPageToken: A token to retrieve next page of results. Pass to
      ListTrainingPipelinesRequest.page_token to obtain that page.
    trainingPipelines: List of TrainingPipelines in the requested page.
  """

  nextPageToken = _messages.StringField(1)
  trainingPipelines = _messages.MessageField('GoogleCloudAiplatformV1alpha1TrainingPipeline', 2, repeated=True)


class GoogleCloudAiplatformV1alpha1MachineSpec(_messages.Message):
  r"""Specification of a single machine.

  Enums:
    AcceleratorTypeValueValuesEnum: Immutable. The type of accelerator(s) that
      may be attached to the machine as per accelerator_count.

  Fields:
    acceleratorCount: The number of accelerators to attach to the machine.
    acceleratorType: Immutable. The type of accelerator(s) that may be
      attached to the machine as per accelerator_count.
    machineType: Immutable. The type of the machine. For the machine types
      supported for prediction, see https://tinyurl.com/aip-
      docs/predictions/machine-types. For machine types supported for creating
      a custom training job, see https://tinyurl.com/aip-
      docs/training/configure-compute. For DeployedModel this field is
      optional, and the default value is `n1-standard-2`. For
      BatchPredictionJob or as part of WorkerPoolSpec this field is required.
  """

  class AcceleratorTypeValueValuesEnum(_messages.Enum):
    r"""Immutable. The type of accelerator(s) that may be attached to the
    machine as per accelerator_count.

    Values:
      ACCELERATOR_TYPE_UNSPECIFIED: Unspecified accelerator type, which means
        no accelerator.
      NVIDIA_TESLA_K80: Nvidia Tesla K80 GPU.
      NVIDIA_TESLA_P100: Nvidia Tesla P100 GPU.
      NVIDIA_TESLA_V100: Nvidia Tesla V100 GPU.
      NVIDIA_TESLA_P4: Nvidia Tesla P4 GPU.
      NVIDIA_TESLA_T4: Nvidia Tesla T4 GPU.
      TPU_V2: TPU v2.
      TPU_V3: TPU v3.
    """
    ACCELERATOR_TYPE_UNSPECIFIED = 0
    NVIDIA_TESLA_K80 = 1
    NVIDIA_TESLA_P100 = 2
    NVIDIA_TESLA_V100 = 3
    NVIDIA_TESLA_P4 = 4
    NVIDIA_TESLA_T4 = 5
    TPU_V2 = 6
    TPU_V3 = 7

  acceleratorCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  acceleratorType = _messages.EnumField('AcceleratorTypeValueValuesEnum', 2)
  machineType = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1ManualBatchTuningParameters(_messages.Message):
  r"""Manual batch tuning parameters.

  Fields:
    batchSize: Immutable. The number of the records (e.g. instances) of the
      operation given in each batch to a machine replica. Machine type, and
      size of a single record should be considered when setting this
      parameter, higher value speeds up the batch operation's execution, but
      too high value will result in a whole batch not fitting in a machine's
      memory, and the whole operation will fail. The default value is 4.
  """

  batchSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1alpha1Measurement(_messages.Message):
  r"""A message representing a Measurement of a Trial. A Measurement contains
  the Metrics got by executing a Trial using suggested hyperparameter values.

  Fields:
    metrics: Output only. A list of metrics got by evaluating the objective
      functions using suggested Parameter values.
    stepCount: Output only. The number of steps the machine learning model has
      been trained for. Must be non-negative.
  """

  metrics = _messages.MessageField('GoogleCloudAiplatformV1alpha1MeasurementMetric', 1, repeated=True)
  stepCount = _messages.IntegerField(2)


class GoogleCloudAiplatformV1alpha1MeasurementMetric(_messages.Message):
  r"""A message representing a metric in the measurement.

  Fields:
    metricId: Output only. The ID of the Metric. The Metric should be defined
      in StudySpec's Metrics.
    value: Output only. The value for this metric.
  """

  metricId = _messages.StringField(1)
  value = _messages.FloatField(2)


class GoogleCloudAiplatformV1alpha1MigratableResource(_messages.Message):
  r"""Represents one resource that exists in automl.googleapis.com,
  datalabeling.googleapis.com or ml.googleapis.com.

  Fields:
    automlDataset: Output only. Represents one Dataset in
      automl.googleapis.com.
    automlModel: Output only. Represents one Model in automl.googleapis.com.
    dataLabelingDataset: Output only. Represents one Dataset in
      datalabeling.googleapis.com.
    lastMigrateTime: Output only. Timestamp when last migrate attempt on this
      MigratableResource started. Will not be set if there's no migrate
      attempt on this MigratableResource.
    lastUpdateTime: Output only. Timestamp when this MigratableResource was
      last updated.
    mlEngineModelVersion: Output only. Represents one Version in
      ml.googleapis.com.
  """

  automlDataset = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigratableResourceAutomlDataset', 1)
  automlModel = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigratableResourceAutomlModel', 2)
  dataLabelingDataset = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigratableResourceDataLabelingDataset', 3)
  lastMigrateTime = _messages.StringField(4)
  lastUpdateTime = _messages.StringField(5)
  mlEngineModelVersion = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigratableResourceMlEngineModelVersion', 6)


class GoogleCloudAiplatformV1alpha1MigratableResourceAutomlDataset(_messages.Message):
  r"""Represents one Dataset in automl.googleapis.com.

  Fields:
    dataset: Full resource name of automl Dataset. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`.
    datasetDisplayName: The Dataset's display name in automl.googleapis.com.
  """

  dataset = _messages.StringField(1)
  datasetDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1MigratableResourceAutomlModel(_messages.Message):
  r"""Represents one Model in automl.googleapis.com.

  Fields:
    model: Full resource name of automl Model. Format:
      `projects/{project}/locations/{location}/models/{model}`.
    modelDisplayName: The Model's display name in automl.googleapis.com.
  """

  model = _messages.StringField(1)
  modelDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1MigratableResourceDataLabelingDataset(_messages.Message):
  r"""Represents one Dataset in datalabeling.googleapis.com.

  Fields:
    dataLabelingAnnotatedDatasets: The migratable AnnotatedDataset in
      datalabeling.googleapis.com belongs to the data labeling Dataset.
    dataset: Full resource name of data labeling Dataset. Format:
      `projects/{project}/datasets/{dataset}`.
    datasetDisplayName: The Dataset's display name in
      datalabeling.googleapis.com.
  """

  dataLabelingAnnotatedDatasets = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset', 1, repeated=True)
  dataset = _messages.StringField(2)
  datasetDisplayName = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1MigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset(_messages.Message):
  r"""Represents one AnnotatedDataset in datalabeling.googleapis.com.

  Fields:
    annotatedDataset: Full resource name of data labeling AnnotatedDataset.
      Format: `projects/{project}/datasets/{dataset}/annotatedDatasets/{annota
      ted_dataset}`.
    annotatedDatasetDisplayName: The AnnotatedDataset's display name in
      datalabeling.googleapis.com.
  """

  annotatedDataset = _messages.StringField(1)
  annotatedDatasetDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1MigratableResourceMlEngineModelVersion(_messages.Message):
  r"""Represents one model Version in ml.googleapis.com.

  Fields:
    endpoint: The ml.googleapis.com endpoint that this model Version currently
      lives in. Example values: * ml.googleapis.com * us-centrall-
      ml.googleapis.com * europe-west4-ml.googleapis.com * asia-
      east1-ml.googleapis.com
    version: Full resource name of ml engine model Version. Format:
      `projects/{project}/models/{model}/versions/{version}`.
  """

  endpoint = _messages.StringField(1)
  version = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1MigrateResourceRequest(_messages.Message):
  r"""Config of migrating one resource from automl.googleapis.com,
  datalabeling.googleapis.com and ml.googleapis.com to AI Platform.

  Fields:
    migrateAutomlDatasetConfig: Config for migrating Dataset in
      automl.googleapis.com to AI Platform's Dataset.
    migrateAutomlModelConfig: Config for migrating Model in
      automl.googleapis.com to AI Platform's Model.
    migrateDataLabelingDatasetConfig: Config for migrating Dataset in
      datalabeling.googleapis.com to AI Platform's Dataset.
    migrateMlEngineModelVersionConfig: Config for migrating Version in
      ml.googleapis.com to AI Platform's Model.
  """

  migrateAutomlDatasetConfig = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigrateResourceRequestMigrateAutomlDatasetConfig', 1)
  migrateAutomlModelConfig = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigrateResourceRequestMigrateAutomlModelConfig', 2)
  migrateDataLabelingDatasetConfig = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigrateResourceRequestMigrateDataLabelingDatasetConfig', 3)
  migrateMlEngineModelVersionConfig = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigrateResourceRequestMigrateMlEngineModelVersionConfig', 4)


class GoogleCloudAiplatformV1alpha1MigrateResourceRequestMigrateAutomlDatasetConfig(_messages.Message):
  r"""Config for migrating Dataset in automl.googleapis.com to AI Platform's
  Dataset.

  Fields:
    dataset: Required. Full resource name of automl Dataset. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`.
    datasetDisplayName: Required. Display name of the Dataset in AI Platform.
      System will pick a display name if unspecified.
  """

  dataset = _messages.StringField(1)
  datasetDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1MigrateResourceRequestMigrateAutomlModelConfig(_messages.Message):
  r"""Config for migrating Model in automl.googleapis.com to AI Platform's
  Model.

  Fields:
    model: Required. Full resource name of automl Model. Format:
      `projects/{project}/locations/{location}/models/{model}`.
    modelDisplayName: Optional. Display name of the model in AI Platform.
      System will pick a display name if unspecified.
  """

  model = _messages.StringField(1)
  modelDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1MigrateResourceRequestMigrateDataLabelingDatasetConfig(_messages.Message):
  r"""Config for migrating Dataset in datalabeling.googleapis.com to AI
  Platform's Dataset.

  Fields:
    dataset: Required. Full resource name of data labeling Dataset. Format:
      `projects/{project}/datasets/{dataset}`.
    datasetDisplayName: Optional. Display name of the Dataset in AI Platform.
      System will pick a display name if unspecified.
    migrateDataLabelingAnnotatedDatasetConfigs: Optional. Configs for
      migrating AnnotatedDataset in datalabeling.googleapis.com to AI
      Platform's SavedQuery. The specified AnnotatedDatasets have to belong to
      the datalabeling Dataset.
  """

  dataset = _messages.StringField(1)
  datasetDisplayName = _messages.StringField(2)
  migrateDataLabelingAnnotatedDatasetConfigs = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigrateResourceRequestMigrateDataLabelingDatasetConfigMigrateDataLabelingAnnotatedDatasetConfig', 3, repeated=True)


class GoogleCloudAiplatformV1alpha1MigrateResourceRequestMigrateDataLabelingDatasetConfigMigrateDataLabelingAnnotatedDatasetConfig(_messages.Message):
  r"""Config for migrating AnnotatedDataset in datalabeling.googleapis.com to
  AI Platform's SavedQuery.

  Fields:
    annotatedDataset: Required. Full resource name of data labeling
      AnnotatedDataset. Format: `projects/{project}/datasets/{dataset}/annotat
      edDatasets/{annotated_dataset}`.
  """

  annotatedDataset = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1MigrateResourceRequestMigrateMlEngineModelVersionConfig(_messages.Message):
  r"""Config for migrating version in ml.googleapis.com to AI Platform's
  Model.

  Fields:
    endpoint: Required. The ml.googleapis.com endpoint that this model version
      should be migrated from. Example values: * ml.googleapis.com * us-
      centrall-ml.googleapis.com * europe-west4-ml.googleapis.com * asia-
      east1-ml.googleapis.com
    modelDisplayName: Required. Display name of the model in AI Platform.
      System will pick a display name if unspecified.
    modelVersion: Required. Full resource name of ml engine model version.
      Format: `projects/{project}/models/{model}/versions/{version}`.
  """

  endpoint = _messages.StringField(1)
  modelDisplayName = _messages.StringField(2)
  modelVersion = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1MigrateResourceResponse(_messages.Message):
  r"""Describes a successfully migrated resource.

  Fields:
    dataset: Migrated Dataset's resource name.
    migratableResource: Before migration, the identifier in ml.googleapis.com,
      automl.googleapis.com or datalabeling.googleapis.com.
    model: Migrated Model's resource name.
  """

  dataset = _messages.StringField(1)
  migratableResource = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigratableResource', 2)
  model = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1Model(_messages.Message):
  r"""A trained machine learning Model.

  Enums:
    SupportedDeploymentResourcesTypesValueListEntryValuesEnum:

  Messages:
    LabelsValue: The labels with user-defined metadata to organize your
      Models. Label keys and values can be no longer than 64 characters
      (Unicode codepoints), can only contain lowercase letters, numeric
      characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    artifactUri: Immutable. The path to the directory containing the Model
      artifact and any of its supporting files. Not present for AutoML Models.
    containerSpec: Input only. The specification of the container that is to
      be used when deploying this Model. The specification is ingested upon
      ModelService.UploadModel, and all binaries it contains are copied and
      stored internally by AI Platform. Not present for AutoML Models.
    createTime: Output only. Timestamp when this Model was uploaded into AI
      Platform.
    deployedModels: Output only. The pointers to DeployedModels created from
      this Model. Note that Model could have been deployed to Endpoints in
      different Locations.
    description: The description of the Model.
    displayName: Required. The display name of the Model. The name can be up
      to 128 characters long and can be consist of any UTF-8 characters.
    encryptionSpec: Customer-managed encryption key spec for a Model. If set,
      this Model and all sub-resources of this Model will be secured by this
      key.
    etag: Used to perform consistent read-modify-write updates. If not set, a
      blind "overwrite" update happens.
    explanationSpec: The default explanation specification for this Model. The
      Model can be used for requesting explanation after being deployed iff it
      is populated. The Model can be used for batch explanation iff it is
      populated. All fields of the explanation_spec can be overridden by
      explanation_spec of DeployModelRequest.deployed_model, or
      explanation_spec of BatchPredictionJob.
    labels: The labels with user-defined metadata to organize your Models.
      Label keys and values can be no longer than 64 characters (Unicode
      codepoints), can only contain lowercase letters, numeric characters,
      underscores and dashes. International characters are allowed. See
      https://goo.gl/xmQnxf for more information and examples of labels.
    metadata: Immutable. An additional information about the Model; the schema
      of the metadata can be found in metadata_schema. Unset if the Model does
      not have any additional information.
    metadataSchemaUri: Immutable. Points to a YAML file stored on Google Cloud
      Storage describing additional information about the Model, that is
      specific to it. Unset if the Model does not have any additional
      information. The schema is defined as an OpenAPI 3.0.2 [Schema
      Object](https://tinyurl.com/y538mdwt#schema-object). AutoML Models
      always have this field populated by AI Platform, if no additional
      metadata is needed this field is set to an empty string. Note: The URI
      given on output will be immutable and probably different, including the
      URI scheme, than the one given on input. The output URI will point to a
      location where the user only has a read access.
    name: The resource name of the Model.
    predictSchemata: The schemata that describe formats of the Model's
      predictions and explanations as given and returned via
      PredictionService.Predict and PredictionService.Explain.
    supportedDeploymentResourcesTypes: Output only. When this Model is
      deployed, its prediction resources are described by the
      `prediction_resources` field of the Endpoint.deployed_models object.
      Because not all Models support all resource configuration types, the
      configuration types this Model supports are listed here. If no
      configuration types are listed, the Model cannot be deployed to an
      Endpoint and does not support online predictions
      (PredictionService.Predict or PredictionService.Explain). Such a Model
      can serve predictions by using a BatchPredictionJob, if it has at least
      one entry each in supported_input_storage_formats and
      supported_output_storage_formats.
    supportedExportFormats: Output only. The formats in which this Model may
      be exported. If empty, this Model is not available for export.
    supportedInputStorageFormats: Output only. The formats this Model supports
      in BatchPredictionJob.input_config. If
      PredictSchemata.instance_schema_uri exists, the instances should be
      given as per that schema. The possible formats are: * `jsonl` The JSON
      Lines format, where each instance is a single line. Uses GcsSource. *
      `csv` The CSV format, where each instance is a single comma-separated
      line. The first line in the file is the header, containing comma-
      separated field names. Uses GcsSource. * `tf-record` The TFRecord
      format, where each instance is a single record in tfrecord syntax. Uses
      GcsSource. * `tf-record-gzip` Similar to `tf-record`, but the file is
      gzipped. Uses GcsSource. * `bigquery` Each instance is a single row in
      BigQuery. Uses BigQuerySource. * `file-list` Each line of the file is
      the location of an instance to process, uses `gcs_source` field of the
      InputConfig object. If this Model doesn't support any of these formats
      it means it cannot be used with a BatchPredictionJob. However, if it has
      supported_deployment_resources_types, it could serve online predictions
      by using PredictionService.Predict or PredictionService.Explain.
    supportedOutputStorageFormats: Output only. The formats this Model
      supports in BatchPredictionJob.output_config. If both
      PredictSchemata.instance_schema_uri and
      PredictSchemata.prediction_schema_uri exist, the predictions are
      returned together with their instances. In other words, the prediction
      has the original instance data first, followed by the actual prediction
      content (as per the schema). The possible formats are: * `jsonl` The
      JSON Lines format, where each prediction is a single line. Uses
      GcsDestination. * `csv` The CSV format, where each prediction is a
      single comma-separated line. The first line in the file is the header,
      containing comma-separated field names. Uses GcsDestination. *
      `bigquery` Each prediction is a single row in a BigQuery table, uses
      BigQueryDestination . If this Model doesn't support any of these formats
      it means it cannot be used with a BatchPredictionJob. However, if it has
      supported_deployment_resources_types, it could serve online predictions
      by using PredictionService.Predict or PredictionService.Explain.
    trainingPipeline: Output only. The resource name of the TrainingPipeline
      that uploaded this Model, if any.
    updateTime: Output only. Timestamp when this Model was most recently
      updated.
  """

  class SupportedDeploymentResourcesTypesValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedDeploymentResourcesTypesValueListEntryValuesEnum enum type.

    Values:
      DEPLOYMENT_RESOURCES_TYPE_UNSPECIFIED: Should not be used.
      DEDICATED_RESOURCES: Resources that are dedicated to the DeployedModel,
        and that need a higher degree of manual configuration.
      AUTOMATIC_RESOURCES: Resources that to large degree are decided by AI
        Platform, and require only a modest additional configuration.
    """
    DEPLOYMENT_RESOURCES_TYPE_UNSPECIFIED = 0
    DEDICATED_RESOURCES = 1
    AUTOMATIC_RESOURCES = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize your Models. Label
    keys and values can be no longer than 64 characters (Unicode codepoints),
    can only contain lowercase letters, numeric characters, underscores and
    dashes. International characters are allowed. See https://goo.gl/xmQnxf
    for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  artifactUri = _messages.StringField(1)
  containerSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1ModelContainerSpec', 2)
  createTime = _messages.StringField(3)
  deployedModels = _messages.MessageField('GoogleCloudAiplatformV1alpha1DeployedModelRef', 4, repeated=True)
  description = _messages.StringField(5)
  displayName = _messages.StringField(6)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1EncryptionSpec', 7)
  etag = _messages.StringField(8)
  explanationSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExplanationSpec', 9)
  labels = _messages.MessageField('LabelsValue', 10)
  metadata = _messages.MessageField('extra_types.JsonValue', 11)
  metadataSchemaUri = _messages.StringField(12)
  name = _messages.StringField(13)
  predictSchemata = _messages.MessageField('GoogleCloudAiplatformV1alpha1PredictSchemata', 14)
  supportedDeploymentResourcesTypes = _messages.EnumField('SupportedDeploymentResourcesTypesValueListEntryValuesEnum', 15, repeated=True)
  supportedExportFormats = _messages.MessageField('GoogleCloudAiplatformV1alpha1ModelExportFormat', 16, repeated=True)
  supportedInputStorageFormats = _messages.StringField(17, repeated=True)
  supportedOutputStorageFormats = _messages.StringField(18, repeated=True)
  trainingPipeline = _messages.StringField(19)
  updateTime = _messages.StringField(20)


class GoogleCloudAiplatformV1alpha1ModelContainerSpec(_messages.Message):
  r"""Specification of a container for serving predictions. This message is a
  subset of the Kubernetes Container v1 core
  [specification](https://tinyurl.com/k8s-io-api/v1.18/#container-v1-core).

  Fields:
    args: Immutable. Specifies arguments for the command that runs when the
      container starts. This overrides the container's
      [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify
      this field as an array of executable and arguments, similar to a Docker
      `CMD`'s "default parameters" form. If you don't specify this field but
      do specify the command field, then the command from the `command` field
      runs without any additional arguments. See the [Kubernetes
      documentation](https://tinyurl.com/y8bvllf4) about how the `command` and
      `args` fields interact with a container's `ENTRYPOINT` and `CMD`. If you
      don't specify this field and don't specify the `command` field, then the
      container's
      [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd)
      and `CMD` determine what runs based on their default behavior. See the
      Docker documentation about how `CMD` and `ENTRYPOINT`
      [interact](https://tinyurl.com/h3kdcgs). In this field, you can
      reference environment variables [set by AI
      Platform](https://tinyurl.com/cust-cont-reqs#aip-variables) and
      environment variables set in the env field. You cannot reference
      environment variables set in the Docker image. In order for environment
      variables to be expanded, reference them by using the following syntax:
      $(VARIABLE_NAME) Note that this differs from Bash variable expansion,
      which does not use parentheses. If a variable cannot be resolved, the
      reference in the input string is used unchanged. To avoid variable
      expansion, you can escape this syntax with `$$`; for example:
      $$(VARIABLE_NAME) This field corresponds to the `args` field of the
      Kubernetes Containers [v1 core API](https://tinyurl.com/k8s-io-
      api/v1.18/#container-v1-core).
    command: Immutable. Specifies the command that runs when the container
      starts. This overrides the container's [ENTRYPOINT](https://docs.docker.
      com/engine/reference/builder/#entrypoint). Specify this field as an
      array of executable and arguments, similar to a Docker `ENTRYPOINT`'s
      "exec" form, not its "shell" form. If you do not specify this field,
      then the container's `ENTRYPOINT` runs, in conjunction with the args
      field or the container's
      [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd), if
      either exists. If this field is not specified and the container does not
      have an `ENTRYPOINT`, then refer to the Docker documentation about how
      `CMD` and `ENTRYPOINT` [interact](https://tinyurl.com/h3kdcgs). If you
      specify this field, then you can also specify the `args` field to
      provide additional arguments for this command. However, if you specify
      this field, then the container's `CMD` is ignored. See the [Kubernetes
      documentation](https://tinyurl.com/y8bvllf4) about how the `command` and
      `args` fields interact with a container's `ENTRYPOINT` and `CMD`. In
      this field, you can reference environment variables [set by AI
      Platform](https://tinyurl.com/cust-cont-reqs#aip-variables) and
      environment variables set in the env field. You cannot reference
      environment variables set in the Docker image. In order for environment
      variables to be expanded, reference them by using the following syntax:
      $(VARIABLE_NAME) Note that this differs from Bash variable expansion,
      which does not use parentheses. If a variable cannot be resolved, the
      reference in the input string is used unchanged. To avoid variable
      expansion, you can escape this syntax with `$$`; for example:
      $$(VARIABLE_NAME) This field corresponds to the `command` field of the
      Kubernetes Containers [v1 core API](https://tinyurl.com/k8s-io-
      api/v1.18/#container-v1-core).
    env: Immutable. List of environment variables to set in the container.
      After the container starts running, code running in the container can
      read these environment variables. Additionally, the command and args
      fields can reference these variables. Later entries in this list can
      also reference earlier entries. For example, the following example sets
      the variable `VAR_2` to have the value `foo bar`: ```json [ { "name":
      "VAR_1", "value": "foo" }, { "name": "VAR_2", "value": "$(VAR_1) bar" }
      ] ``` If you switch the order of the variables in the example, then the
      expansion does not occur. This field corresponds to the `env` field of
      the Kubernetes Containers [v1 core API](https://tinyurl.com/k8s-io-
      api/v1.18/#container-v1-core).
    healthRoute: Immutable. HTTP path on the container to send health checkss
      to. AI Platform intermittently sends GET requests to this path on the
      container's IP address and port to check that the container is healthy.
      Read more about [health checks](https://tinyurl.com/cust-cont-
      reqs#checks). For example, if you set this field to `/bar`, then AI
      Platform intermittently sends a GET request to the `/bar` path on the
      port of your container specified by the first value of this
      `ModelContainerSpec`'s ports field. If you don't specify this field, it
      defaults to the following value when you deploy this Model to an
      Endpoint: /v1/endpoints/ENDPOINT/deployedModels/DEPLOYED_MODEL :predict
      The placeholders in this value are replaced as follows: * ENDPOINT: The
      last segment (following `endpoints/`)of the Endpoint.name][] field of
      the Endpoint where this Model has been deployed. (AI Platform makes this
      value available to your container code as the
      [`AIP_ENDPOINT_ID`](https://tinyurl.com/cust-cont-reqs#aip-variables)
      environment variable.) * DEPLOYED_MODEL: DeployedModel.id of the
      `DeployedModel`. (AI Platform makes this value available to your
      container code as the
      [`AIP_DEPLOYED_MODEL_ID`](https://tinyurl.com/cust-cont-reqs#aip-
      variables) environment variable.)
    imageUri: Required. Immutable. URI of the Docker image to be used as the
      custom container for serving predictions. This URI must identify an
      image in Artifact Registry or Container Registry. Learn more about the
      container publishing requirements, including permissions requirements
      for the AI Platform Service Agent, [here](https://tinyurl.com/cust-cont-
      reqs#publishing). The container image is ingested upon
      ModelService.UploadModel, stored internally, and this original path is
      afterwards not used. To learn about the requirements for the Docker
      image itself, see [Custom container
      requirements](https://tinyurl.com/cust-cont-reqs).
    ports: Immutable. List of ports to expose from the container. AI Platform
      sends any prediction requests that it receives to the first port on this
      list. AI Platform also sends [liveness and health
      checks](https://tinyurl.com/cust-cont-reqs#health) to this port. If you
      do not specify this field, it defaults to following value: ```json [ {
      "containerPort": 8080 } ] ``` AI Platform does not use ports other than
      the first one listed. This field corresponds to the `ports` field of the
      Kubernetes Containers [v1 core API](https://tinyurl.com/k8s-io-
      api/v1.18/#container-v1-core).
    predictRoute: Immutable. HTTP path on the container to send prediction
      requests to. AI Platform forwards requests sent using
      projects.locations.endpoints.predict to this path on the container's IP
      address and port. AI Platform then returns the container's response in
      the API response. For example, if you set this field to `/foo`, then
      when AI Platform receives a prediction request, it forwards the request
      body in a POST request to the `/foo` path on the port of your container
      specified by the first value of this `ModelContainerSpec`'s ports field.
      If you don't specify this field, it defaults to the following value when
      you deploy this Model to an Endpoint:
      /v1/endpoints/ENDPOINT/deployedModels/DEPLOYED_MODEL:predict The
      placeholders in this value are replaced as follows: * ENDPOINT: The last
      segment (following `endpoints/`)of the Endpoint.name][] field of the
      Endpoint where this Model has been deployed. (AI Platform makes this
      value available to your container code as the
      [`AIP_ENDPOINT_ID`](https://tinyurl.com/cust-cont-reqs#aip-variables)
      environment variable.) * DEPLOYED_MODEL: DeployedModel.id of the
      `DeployedModel`. (AI Platform makes this value available to your
      container code as the [`AIP_DEPLOYED_MODEL_ID` environment
      variable](https://tinyurl.com/cust-cont-reqs#aip-variables).)
  """

  args = _messages.StringField(1, repeated=True)
  command = _messages.StringField(2, repeated=True)
  env = _messages.MessageField('GoogleCloudAiplatformV1alpha1EnvVar', 3, repeated=True)
  healthRoute = _messages.StringField(4)
  imageUri = _messages.StringField(5)
  ports = _messages.MessageField('GoogleCloudAiplatformV1alpha1Port', 6, repeated=True)
  predictRoute = _messages.StringField(7)


class GoogleCloudAiplatformV1alpha1ModelEvaluation(_messages.Message):
  r"""A collection of metrics calculated by comparing Model's predictions on
  all of the test data against annotations from the test data.

  Fields:
    createTime: Output only. Timestamp when this ModelEvaluation was created.
    explanationSpecs: Output only. Describes the values of ExplanationSpec
      that are used for explaining the predicted values on the evaluated data.
    metrics: Output only. Evaluation metrics of the Model. The schema of the
      metrics is stored in metrics_schema_uri
    metricsSchemaUri: Output only. Points to a YAML file stored on Google
      Cloud Storage describing the metrics of this ModelEvaluation. The schema
      is defined as an OpenAPI 3.0.2 [Schema
      Object](https://tinyurl.com/y538mdwt#schema-object).
    modelExplanation: Output only. Aggregated explanation metrics for the
      Model's prediction output over the data this ModelEvaluation uses. This
      field is populated only if the Model is evaluated with explanations, and
      only for AutoML tabular Models.
    name: Output only. The resource name of the ModelEvaluation.
    sliceDimensions: Output only. All possible dimensions of
      ModelEvaluationSlices. The dimensions can be used as the filter of the
      ModelService.ListModelEvaluationSlices request, in the form of
      `slice.dimension = `.
  """

  createTime = _messages.StringField(1)
  explanationSpecs = _messages.MessageField('GoogleCloudAiplatformV1alpha1ModelEvaluationModelEvaluationExplanationSpec', 2, repeated=True)
  metrics = _messages.MessageField('extra_types.JsonValue', 3)
  metricsSchemaUri = _messages.StringField(4)
  modelExplanation = _messages.MessageField('GoogleCloudAiplatformV1alpha1ModelExplanation', 5)
  name = _messages.StringField(6)
  sliceDimensions = _messages.StringField(7, repeated=True)


class GoogleCloudAiplatformV1alpha1ModelEvaluationModelEvaluationExplanationSpec(_messages.Message):
  r"""A
  GoogleCloudAiplatformV1alpha1ModelEvaluationModelEvaluationExplanationSpec
  object.

  Fields:
    explanationSpec: Explanation spec details.
    explanationType: Explanation type. For AutoML Image Classification models,
      possible values are: * `image-integrated-gradients` * `image-xrai`
  """

  explanationSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1ExplanationSpec', 1)
  explanationType = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1ModelEvaluationSlice(_messages.Message):
  r"""A collection of metrics calculated by comparing Model's predictions on a
  slice of the test data against ground truth annotations.

  Fields:
    createTime: Output only. Timestamp when this ModelEvaluationSlice was
      created.
    metrics: Output only. Sliced evaluation metrics of the Model. The schema
      of the metrics is stored in metrics_schema_uri
    metricsSchemaUri: Output only. Points to a YAML file stored on Google
      Cloud Storage describing the metrics of this ModelEvaluationSlice. The
      schema is defined as an OpenAPI 3.0.2 [Schema
      Object](https://tinyurl.com/y538mdwt#schema-object).
    name: Output only. The resource name of the ModelEvaluationSlice.
    slice: Output only. The slice of the test data that is used to evaluate
      the Model.
  """

  createTime = _messages.StringField(1)
  metrics = _messages.MessageField('extra_types.JsonValue', 2)
  metricsSchemaUri = _messages.StringField(3)
  name = _messages.StringField(4)
  slice = _messages.MessageField('GoogleCloudAiplatformV1alpha1ModelEvaluationSliceSlice', 5)


class GoogleCloudAiplatformV1alpha1ModelEvaluationSliceSlice(_messages.Message):
  r"""Definition of a slice.

  Fields:
    dimension: Output only. The dimension of the slice. Well-known dimensions
      are: * `annotationSpec`: This slice is on the test data that has either
      ground truth or prediction with AnnotationSpec.display_name equals to
      value.
    value: Output only. The value of the dimension in this slice.
  """

  dimension = _messages.StringField(1)
  value = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1ModelExplanation(_messages.Message):
  r"""Aggregated explanation metrics for a Model over a set of instances.

  Fields:
    meanAttributions: Output only. Aggregated attributions explaning the
      Model's prediction outputs over the set of instances. The attributions
      are grouped by outputs. For Models that predict only one output, such as
      regression Models that predict only one score, there is only one
      attibution that explains the predicted output. For Models that predict
      multiple outputs, such as multiclass Models that predict multiple
      classes, each element explains one specific item.
      Attribution.output_index can be used to identify which output this
      attribution is explaining. The baselineOutputValue, instanceOutputValue
      and featureAttributions fields are averaged over the test data. NOTE:
      Currently AutoML tabular classification Models produce only one
      attribution, which averages attributions over all the classes it
      predicts. Attribution.approximation_error is not populated.
  """

  meanAttributions = _messages.MessageField('GoogleCloudAiplatformV1alpha1Attribution', 1, repeated=True)


class GoogleCloudAiplatformV1alpha1ModelExportFormat(_messages.Message):
  r"""Represents a supported by the Model export format. All formats export to
  Google Cloud Storage.

  Fields:
    id: Output only. The ID of the export format. The possible format IDs are:
      * `tflite` Used for Android mobile devices. * `edgetpu-tflite` Used for
      [Edge TPU](https://cloud.google.com/edge-tpu/) devices. * `tf-saved-
      model` A tensorflow model in SavedModel format. * `tf-js` A
      [TensorFlow.js](https://www.tensorflow.org/js) model that can be used in
      the browser and in Node.js using JavaScript. * `core-ml` Used for iOS
      mobile devices. * `custom-trained` A Model that was uploaded or trained
      by custom code.
  """

  id = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1Port(_messages.Message):
  r"""Represents a network port in a container.

  Fields:
    containerPort: The number of the port to expose on the pod's IP address.
      Must be a valid port number, between 1 and 65535 inclusive.
  """

  containerPort = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1alpha1PredefinedSplit(_messages.Message):
  r"""Assigns input data to training, validation, and test sets based on the
  value of a provided key. Supported only for tabular Datasets.

  Fields:
    key: Required. The key is a name of one of the Dataset's data columns. The
      value of the key (either the label's value or value in the column) must
      be one of {`training`, `validation`, `test`}, and it defines to which
      set the given piece of data is assigned. If for a piece of data the key
      is not present or has an invalid value, that piece is ignored by the
      pipeline.
  """

  key = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1PredictRequest(_messages.Message):
  r"""Request message for PredictionService.Predict.

  Fields:
    instances: Required. The instances that are the input to the prediction
      call. A DeployedModel may have an upper limit on the number of instances
      it supports per request, and when it is exceeded the prediction call
      errors in case of AutoML Models, or, in case of customer created Models,
      the behaviour is as documented by that Model. The schema of any single
      instance may be specified via Endpoint's DeployedModels' Model's
      PredictSchemata's instance_schema_uri.
    parameters: The parameters that govern the prediction. The schema of the
      parameters may be specified via Endpoint's DeployedModels' Model's
      PredictSchemata's parameters_schema_uri.
  """

  instances = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)
  parameters = _messages.MessageField('extra_types.JsonValue', 2)


class GoogleCloudAiplatformV1alpha1PredictResponse(_messages.Message):
  r"""Response message for PredictionService.Predict.

  Fields:
    deployedModelId: ID of the Endpoint's DeployedModel that served this
      prediction.
    predictions: The predictions that are the output of the predictions call.
      The schema of any single prediction may be specified via Endpoint's
      DeployedModels' Model's PredictSchemata's prediction_schema_uri.
  """

  deployedModelId = _messages.StringField(1)
  predictions = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)


class GoogleCloudAiplatformV1alpha1PredictSchemata(_messages.Message):
  r"""Contains the schemata used in Model's predictions and explanations via
  PredictionService.Predict, PredictionService.Explain and BatchPredictionJob.

  Fields:
    instanceSchemaUri: Immutable. Points to a YAML file stored on Google Cloud
      Storage describing the format of a single instance, which are used in
      PredictRequest.instances, ExplainRequest.instances and
      BatchPredictionJob.input_config. The schema is defined as an OpenAPI
      3.0.2 [Schema Object](https://tinyurl.com/y538mdwt#schema-object).
      AutoML Models always have this field populated by AI Platform. Note: The
      URI given on output will be immutable and probably different, including
      the URI scheme, than the one given on input. The output URI will point
      to a location where the user only has a read access.
    parametersSchemaUri: Immutable. Points to a YAML file stored on Google
      Cloud Storage describing the parameters of prediction and explanation
      via PredictRequest.parameters, ExplainRequest.parameters and
      BatchPredictionJob.model_parameters. The schema is defined as an OpenAPI
      3.0.2 [Schema Object](https://tinyurl.com/y538mdwt#schema-object).
      AutoML Models always have this field populated by AI Platform, if no
      parameters are supported it is set to an empty string. Note: The URI
      given on output will be immutable and probably different, including the
      URI scheme, than the one given on input. The output URI will point to a
      location where the user only has a read access.
    predictionSchemaUri: Immutable. Points to a YAML file stored on Google
      Cloud Storage describing the format of a single prediction produced by
      this Model, which are returned via PredictResponse.predictions,
      ExplainResponse.explanations, and BatchPredictionJob.output_config. The
      schema is defined as an OpenAPI 3.0.2 [Schema
      Object](https://tinyurl.com/y538mdwt#schema-object). AutoML Models
      always have this field populated by AI Platform. Note: The URI given on
      output will be immutable and probably different, including the URI
      scheme, than the one given on input. The output URI will point to a
      location where the user only has a read access.
  """

  instanceSchemaUri = _messages.StringField(1)
  parametersSchemaUri = _messages.StringField(2)
  predictionSchemaUri = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1PythonPackageSpec(_messages.Message):
  r"""The spec of a Python packaged code.

  Fields:
    args: Command line arguments to be passed to the Python task.
    executorImageUri: Required. The URI of a container image in the Container
      Registry that will run the provided python package. AI Platform provides
      wide range of executor images with pre-installed packages to meet users'
      various use cases. Only one of the provided images can be set here.
    packageUris: Required. The Google Cloud Storage location of the Python
      package files which are the training program and its dependent packages.
      The maximum number of package URIs is 100.
    pythonModule: Required. The Python module name to run after installing the
      packages.
  """

  args = _messages.StringField(1, repeated=True)
  executorImageUri = _messages.StringField(2)
  packageUris = _messages.StringField(3, repeated=True)
  pythonModule = _messages.StringField(4)


class GoogleCloudAiplatformV1alpha1ResourcesConsumed(_messages.Message):
  r"""Statistics information about resource consumption.

  Fields:
    replicaHours: Output only. The number of replica hours used. Note that
      many replicas may run in parallel, and additionally any given work may
      be queued for some time. Therefore this value is not strictly related to
      wall time.
  """

  replicaHours = _messages.FloatField(1)


class GoogleCloudAiplatformV1alpha1SampleConfig(_messages.Message):
  r"""Active learning data sampling config. For every active learning labeling
  iteration, it will select a batch of data based on the sampling strategy.

  Enums:
    SampleStrategyValueValuesEnum: Field to chose sampling strategy. Sampling
      strategy will decide which data should be selected for human labeling in
      every batch.

  Fields:
    followingBatchSamplePercentage: The percentage of data needed to be
      labeled in each following batch (except the first batch).
    initialBatchSamplePercentage: The percentage of data needed to be labeled
      in the first batch.
    sampleStrategy: Field to chose sampling strategy. Sampling strategy will
      decide which data should be selected for human labeling in every batch.
  """

  class SampleStrategyValueValuesEnum(_messages.Enum):
    r"""Field to chose sampling strategy. Sampling strategy will decide which
    data should be selected for human labeling in every batch.

    Values:
      SAMPLE_STRATEGY_UNSPECIFIED: Default will be treated as UNCERTAINTY.
      UNCERTAINTY: Sample the most uncertain data to label.
    """
    SAMPLE_STRATEGY_UNSPECIFIED = 0
    UNCERTAINTY = 1

  followingBatchSamplePercentage = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  initialBatchSamplePercentage = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  sampleStrategy = _messages.EnumField('SampleStrategyValueValuesEnum', 3)


class GoogleCloudAiplatformV1alpha1SampledShapleyAttribution(_messages.Message):
  r"""An attribution method that approximates Shapley values for features that
  contribute to the label being predicted. A sampling strategy is used to
  approximate the value rather than considering all subsets of features.

  Fields:
    pathCount: Required. The number of feature permutations to consider when
      approximating the Shapley values. Valid range of its value is [1, 50],
      inclusively.
  """

  pathCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1alpha1Scheduling(_messages.Message):
  r"""All parameters related to queuing and scheduling of custom jobs.

  Fields:
    restartJobOnWorkerRestart: Restarts the entire CustomJob if a worker gets
      restarted. This feature can be used by distributed training jobs that
      are not resilient to workers leaving and joining a job.
    timeout: The maximum job running time. The default is 7 days.
  """

  restartJobOnWorkerRestart = _messages.BooleanField(1)
  timeout = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaAnnotationSpecColor(_messages.Message):
  r"""An entry of mapping between color and AnnotationSpec. The mapping is
  used in segmentation mask.

  Fields:
    color: The color of the AnnotationSpec in a segmentation mask.
    displayName: The display name of the AnnotationSpec represented by the
      color in the segmentation mask.
    id: The ID of the AnnotationSpec represented by the color in the
      segmentation mask.
  """

  color = _messages.MessageField('GoogleTypeColor', 1)
  displayName = _messages.StringField(2)
  id = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1SchemaImageBoundingBoxAnnotation(_messages.Message):
  r"""Annotation details specific to image object detection.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    xMax: The rightmost coordinate of the bounding box.
    xMin: The leftmost coordinate of the bounding box.
    yMax: The bottommost coordinate of the bounding box.
    yMin: The topmost coordinate of the bounding box.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  xMax = _messages.FloatField(3)
  xMin = _messages.FloatField(4)
  yMax = _messages.FloatField(5)
  yMin = _messages.FloatField(6)


class GoogleCloudAiplatformV1alpha1SchemaImageClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to image classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaImageDataItem(_messages.Message):
  r"""Payload of Image DataItem.

  Fields:
    gcsUri: Required. Google Cloud Storage URI points to the original image in
      user's bucket. The image is up to 30MB in size.
    mimeType: Output only. The mime type of the content of the image. Only the
      images in below listed mime types are supported. - image/jpeg -
      image/gif - image/png - image/webp - image/bmp - image/tiff -
      image/vnd.microsoft.icon
  """

  gcsUri = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaImageDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Image DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Image DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaImageSegmentationAnnotation(_messages.Message):
  r"""Annotation details specific to image segmentation.

  Fields:
    maskAnnotation: Mask based segmentation annotation. Only one mask
      annotation can exist for one image.
    polygonAnnotation: Polygon annotation.
    polylineAnnotation: Polyline annotation.
  """

  maskAnnotation = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaImageSegmentationAnnotationMaskAnnotation', 1)
  polygonAnnotation = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaImageSegmentationAnnotationPolygonAnnotation', 2)
  polylineAnnotation = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaImageSegmentationAnnotationPolylineAnnotation', 3)


class GoogleCloudAiplatformV1alpha1SchemaImageSegmentationAnnotationMaskAnnotation(_messages.Message):
  r"""The mask based segmentation annotation.

  Fields:
    annotationSpecColors: The mapping between color and AnnotationSpec for
      this Annotation.
    maskGcsUri: Google Cloud Storage URI that points to the mask image. The
      image must be in PNG format. It must have the same size as the
      DataItem's image. Each pixel in the image mask represents the
      AnnotationSpec which the pixel in the image DataItem belong to. Each
      color is mapped to one AnnotationSpec based on annotation_spec_colors.
  """

  annotationSpecColors = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaAnnotationSpecColor', 1, repeated=True)
  maskGcsUri = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaImageSegmentationAnnotationPolygonAnnotation(_messages.Message):
  r"""Represents a polygon in image.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    vertexes: The vertexes are connected one by one and the last vertex is
      connected to the first one to represent a polygon.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  vertexes = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaVertex', 3, repeated=True)


class GoogleCloudAiplatformV1alpha1SchemaImageSegmentationAnnotationPolylineAnnotation(_messages.Message):
  r"""Represents a polyline in image.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    vertexes: The vertexes are connected one by one and the last vertex in not
      connected to the first one.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  vertexes = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaVertex', 3, repeated=True)


class GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain tables data.

  Fields:
    inputConfig: A
      GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataInputConfig
      attribute.
  """

  inputConfig = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataInputConfig', 1)


class GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataBigQuerySource(_messages.Message):
  r"""A GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataBigQuerySource
  object.

  Fields:
    uri: The URI of a BigQuery table.
  """

  uri = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataGcsSource(_messages.Message):
  r"""A GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataGcsSource
  object.

  Fields:
    uri: Cloud Storage URI of one or more files. Only CSV files are supported.
      The first line of the CSV file is used as the header. If there are
      multiple files, the header is the first line of the lexicographically
      first file, the other files must either contain the exact same header or
      omit the header.
  """

  uri = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataInputConfig(_messages.Message):
  r"""The tables Dataset's data source. The Dataset doesn't store the data
  directly, but only pointer(s) to its data.

  Fields:
    bigquerySource: A
      GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataBigQuerySource
      attribute.
    gcsSource: A
      GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataGcsSource
      attribute.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataBigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTablesDatasetMetadataGcsSource', 2)


class GoogleCloudAiplatformV1alpha1SchemaTextClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to text classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaTextDataItem(_messages.Message):
  r"""Payload of Text DataItem.

  Fields:
    gcsUri: Output only. Google Cloud Storage URI points to the original text
      in user's bucket. The text file is up to 10MB in size.
  """

  gcsUri = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1SchemaTextDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Text DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Text DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaTextExtractionAnnotation(_messages.Message):
  r"""Annotation details specific to text extraction.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    textSegment: The segment of the text content.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  textSegment = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTextSegment', 3)


class GoogleCloudAiplatformV1alpha1SchemaTextSegment(_messages.Message):
  r"""The text segment inside of DataItem.

  Fields:
    content: The text content in the segment for output only.
    endOffset: Zero-based character index of the first character past the end
      of the text segment (counting character from the beginning of the text).
      The character at the end_offset is NOT included in the text segment.
    startOffset: Zero-based character index of the first character of the text
      segment (counting characters from the beginning of the text).
  """

  content = _messages.StringField(1)
  endOffset = _messages.IntegerField(2, variant=_messages.Variant.UINT64)
  startOffset = _messages.IntegerField(3, variant=_messages.Variant.UINT64)


class GoogleCloudAiplatformV1alpha1SchemaTextSentimentAnnotation(_messages.Message):
  r"""Annotation details specific to text sentiment.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    sentiment: The sentiment score for text.
    sentimentMax: The sentiment max score for text.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  sentiment = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  sentimentMax = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1alpha1SchemaTextSentimentSavedQueryMetadata(_messages.Message):
  r"""The metadata of SavedQuery contains TextSentiment Annotations.

  Fields:
    sentimentMax: The maximum sentiment of sentiment Anntoation in this
      SavedQuery.
  """

  sentimentMax = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1alpha1SchemaTimeSegment(_messages.Message):
  r"""A time period inside of a DataItem that has a time dimension (e.g.
  video).

  Fields:
    endTimeOffset: End of the time segment (exclusive), represented as the
      duration since the start of the DataItem.
    startTimeOffset: Start of the time segment (inclusive), represented as the
      duration since the start of the DataItem.
  """

  endTimeOffset = _messages.StringField(1)
  startTimeOffset = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain time series data.

  Fields:
    inputConfig: A
      GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataInputConfig
      attribute.
    timeColumn: The column name of the time column that identifies time order
      in the time series.
    timeSeriesIdentifierColumn: The column name of the time series identifier
      column that identifies the time series.
  """

  inputConfig = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataInputConfig', 1)
  timeColumn = _messages.StringField(2)
  timeSeriesIdentifierColumn = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataBigQuerySource(_messages.Message):
  r"""A
  GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataBigQuerySource
  object.

  Fields:
    uri: The URI of a BigQuery table.
  """

  uri = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataGcsSource(_messages.Message):
  r"""A GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataGcsSource
  object.

  Fields:
    uri: Cloud Storage URI of one or more files. Only CSV files are supported.
      The first line of the CSV file is used as the header. If there are
      multiple files, the header is the first line of the lexicographically
      first file, the other files must either contain the exact same header or
      omit the header.
  """

  uri = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataInputConfig(_messages.Message):
  r"""The time series Dataset's data source. The Dataset doesn't store the
  data directly, but only pointer(s) to its data.

  Fields:
    bigquerySource: A
      GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataBigQuerySour
      ce attribute.
    gcsSource: A
      GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataGcsSource
      attribute.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataBigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTimeSeriesDatasetMetadataGcsSource', 2)


class GoogleCloudAiplatformV1alpha1SchemaVertex(_messages.Message):
  r"""A vertex represents a 2D point in the image. NOTE: the normalized vertex
  coordinates are relative to the original image and range from 0 to 1.

  Fields:
    x: X coordinate.
    y: Y coordinate.
  """

  x = _messages.FloatField(1)
  y = _messages.FloatField(2)


class GoogleCloudAiplatformV1alpha1SchemaVideoActionRecognitionAnnotation(_messages.Message):
  r"""Annotation details specific to video action recognition.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    timeSegment: This Annotation applies to the time period represented by the
      TimeSegment. If it's not set, the Annotation applies to the whole video.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  timeSegment = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTimeSegment', 3)


class GoogleCloudAiplatformV1alpha1SchemaVideoClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to video classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    timeSegment: This Annotation applies to the time period represented by the
      TimeSegment. If it's not set, the Annotation applies to the whole video.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  timeSegment = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaTimeSegment', 3)


class GoogleCloudAiplatformV1alpha1SchemaVideoDataItem(_messages.Message):
  r"""Payload of Video DataItem.

  Fields:
    gcsUri: Required. Google Cloud Storage URI points to the original video in
      user's bucket. The video is up to 50 GB in size and up to 3 hour in
      duration.
    mimeType: Output only. The mime type of the content of the video. Only the
      videos in below listed mime types are supported. Supported mime_type: -
      video/mp4 - video/avi - video/quicktime
  """

  gcsUri = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaVideoDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Video DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Video DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SchemaVideoObjectTrackingAnnotation(_messages.Message):
  r"""Annotation details specific to video object tracking.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    instanceId: The instance of the object, expressed as a positive integer.
      Used to track the same object across different frames.
    timeOffset: A time (frame) of a video to which this annotation pertains.
      Represented as the duration since the video's start.
    xMax: The rightmost coordinate of the bounding box.
    xMin: The leftmost coordinate of the bounding box.
    yMax: The bottommost coordinate of the bounding box.
    yMin: The topmost coordinate of the bounding box.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  instanceId = _messages.IntegerField(3)
  timeOffset = _messages.StringField(4)
  xMax = _messages.FloatField(5)
  xMin = _messages.FloatField(6)
  yMax = _messages.FloatField(7)
  yMin = _messages.FloatField(8)


class GoogleCloudAiplatformV1alpha1SchemaVisualInspectionClassificationLabelSavedQueryMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformV1alpha1SchemaVisualInspectionClassificationLabel
  SavedQueryMetadata object.

  Fields:
    multiLabel: Whether or not the classification label is multi_label.
  """

  multiLabel = _messages.BooleanField(1)


class GoogleCloudAiplatformV1alpha1SchemaVisualInspectionMaskSavedQueryMetadata(_messages.Message):
  r"""A
  GoogleCloudAiplatformV1alpha1SchemaVisualInspectionMaskSavedQueryMetadata
  object.

  Fields:
    colorMap: The mapping between color and AnnotationSpec for this
      SavedQuery.
  """

  colorMap = _messages.MessageField('GoogleCloudAiplatformV1alpha1SchemaAnnotationSpecColor', 1, repeated=True)


class GoogleCloudAiplatformV1alpha1SearchMigratableResourcesRequest(_messages.Message):
  r"""Request message for MigrationService.SearchMigratableResources.

  Fields:
    filter: Supported filters are: * Resource type: For a specific type of
      MigratableResource. * `ml_engine_model_version:*` * `automl_model:*`, *
      `automl_dataset:*` * `data_labeling_dataset:*`. * Migrated or not:
      Filter migrated resource or not by last_migrate_time. *
      `last_migrate_time:*` will filter migrated resources. * `NOT
      last_migrate_time:*` will filter not yet migrated resource.
    pageSize: The standard page size. The default and maximum value is 100.
    pageToken: The standard page token.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1SearchMigratableResourcesResponse(_messages.Message):
  r"""Response message for MigrationService.SearchMigratableResources.

  Fields:
    migratableResources: All migratable resources that can be migrated to the
      location specified in the request.
    nextPageToken: The standard next-page token. The migratable_resources may
      not fill page_size in SearchMigratableResourcesRequest even when there
      are subsequent pages.
  """

  migratableResources = _messages.MessageField('GoogleCloudAiplatformV1alpha1MigratableResource', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1SpecialistPool(_messages.Message):
  r"""SpecialistPool represents customers' own workforce to work on their data
  labeling jobs. It includes a group of specialist managers who are
  responsible for managing the labelers in this pool as well as customers'
  data labeling jobs associated with this pool. Customers create specialist
  pool as well as start data labeling jobs on Cloud, managers and labelers
  work with the jobs using CrowdCompute console.

  Fields:
    displayName: Required. The user-defined name of the SpecialistPool. The
      name can be up to 128 characters long and can be consist of any UTF-8
      characters. This field should be unique on project-level.
    name: Required. The resource name of the SpecialistPool.
    pendingDataLabelingJobs: Output only. The resource name of the pending
      data labeling jobs.
    specialistManagerEmails: The email addresses of the specialists in the
      SpecialistPool.
    specialistManagersCount: Output only. The number of Specialists in this
      SpecialistPool.
  """

  displayName = _messages.StringField(1)
  name = _messages.StringField(2)
  pendingDataLabelingJobs = _messages.StringField(3, repeated=True)
  specialistManagerEmails = _messages.StringField(4, repeated=True)
  specialistManagersCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1alpha1StudySpec(_messages.Message):
  r"""Represents specification of a Study.

  Enums:
    AlgorithmValueValuesEnum: The search algorithm specified for the Study.
    ObservationNoiseValueValuesEnum: The observation noise level of the study.
      Currently only supported by the Vizier service. Not supported by
      HyperparamterTuningJob or TrainingPipeline.

  Fields:
    algorithm: The search algorithm specified for the Study.
    metrics: Required. Metric specs for the Study.
    observationNoise: The observation noise level of the study. Currently only
      supported by the Vizier service. Not supported by HyperparamterTuningJob
      or TrainingPipeline.
    parameters: Required. The set of parameters to tune.
  """

  class AlgorithmValueValuesEnum(_messages.Enum):
    r"""The search algorithm specified for the Study.

    Values:
      ALGORITHM_UNSPECIFIED: The default algorithm used by AI Platform
        Optimization service.
      GRID_SEARCH: Simple grid search within the feasible space. To use grid
        search, all parameters must be `INTEGER`, `CATEGORICAL`, or
        `DISCRETE`.
      RANDOM_SEARCH: Simple random search within the feasible space.
    """
    ALGORITHM_UNSPECIFIED = 0
    GRID_SEARCH = 1
    RANDOM_SEARCH = 2

  class ObservationNoiseValueValuesEnum(_messages.Enum):
    r"""The observation noise level of the study. Currently only supported by
    the Vizier service. Not supported by HyperparamterTuningJob or
    TrainingPipeline.

    Values:
      OBSERVATION_NOISE_UNSPECIFIED: The default noise level chosen by the AI
        Platform service.
      LOW: AI Platform Vizier assumes that the objective function is (nearly)
        perfectly reproducible, and will never repeat the same Trial
        parameters.
      HIGH: AI Platform Vizier will estimate the amount of noise in metric
        evaluations, it may repeat the same Trial parameters more than once.
    """
    OBSERVATION_NOISE_UNSPECIFIED = 0
    LOW = 1
    HIGH = 2

  algorithm = _messages.EnumField('AlgorithmValueValuesEnum', 1)
  metrics = _messages.MessageField('GoogleCloudAiplatformV1alpha1StudySpecMetricSpec', 2, repeated=True)
  observationNoise = _messages.EnumField('ObservationNoiseValueValuesEnum', 3)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1alpha1StudySpecParameterSpec', 4, repeated=True)


class GoogleCloudAiplatformV1alpha1StudySpecMetricSpec(_messages.Message):
  r"""Represents a metric to optimize.

  Enums:
    GoalValueValuesEnum: Required. The optimization goal of the metric.

  Fields:
    goal: Required. The optimization goal of the metric.
    metricId: Required. The ID of the metric. Must not contain whitespaces and
      must be unique amongst all MetricSpecs.
  """

  class GoalValueValuesEnum(_messages.Enum):
    r"""Required. The optimization goal of the metric.

    Values:
      GOAL_TYPE_UNSPECIFIED: Goal Type will default to maximize.
      MAXIMIZE: Maximize the goal metric.
      MINIMIZE: Minimize the goal metric.
    """
    GOAL_TYPE_UNSPECIFIED = 0
    MAXIMIZE = 1
    MINIMIZE = 2

  goal = _messages.EnumField('GoalValueValuesEnum', 1)
  metricId = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1StudySpecParameterSpec(_messages.Message):
  r"""Represents a single parameter to optimize.

  Enums:
    ScaleTypeValueValuesEnum: How the parameter should be scaled. Leave unset
      for `CATEGORICAL` parameters.

  Fields:
    categoricalValueSpec: The value spec for a 'CATEGORICAL' parameter.
    discreteValueSpec: The value spec for a 'DISCRETE' parameter.
    doubleValueSpec: The value spec for a 'DOUBLE' parameter.
    integerValueSpec: The value spec for an 'INTEGER' parameter.
    parameterId: Required. The ID of the parameter. Must not contain
      whitespaces and must be unique amongst all ParameterSpecs.
    scaleType: How the parameter should be scaled. Leave unset for
      `CATEGORICAL` parameters.
  """

  class ScaleTypeValueValuesEnum(_messages.Enum):
    r"""How the parameter should be scaled. Leave unset for `CATEGORICAL`
    parameters.

    Values:
      SCALE_TYPE_UNSPECIFIED: By default, no scaling is applied.
      UNIT_LINEAR_SCALE: Scales the feasible space to (0, 1) linearly.
      UNIT_LOG_SCALE: Scales the feasible space logarithmically to (0, 1). The
        entire feasible space must be strictly positive.
      UNIT_REVERSE_LOG_SCALE: Scales the feasible space "reverse"
        logarithmically to (0, 1). The result is that values close to the top
        of the feasible space are spread out more than points near the bottom.
        The entire feasible space must be strictly positive.
    """
    SCALE_TYPE_UNSPECIFIED = 0
    UNIT_LINEAR_SCALE = 1
    UNIT_LOG_SCALE = 2
    UNIT_REVERSE_LOG_SCALE = 3

  categoricalValueSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1StudySpecParameterSpecCategoricalValueSpec', 1)
  discreteValueSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1StudySpecParameterSpecDiscreteValueSpec', 2)
  doubleValueSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1StudySpecParameterSpecDoubleValueSpec', 3)
  integerValueSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1StudySpecParameterSpecIntegerValueSpec', 4)
  parameterId = _messages.StringField(5)
  scaleType = _messages.EnumField('ScaleTypeValueValuesEnum', 6)


class GoogleCloudAiplatformV1alpha1StudySpecParameterSpecCategoricalValueSpec(_messages.Message):
  r"""Value specification for a parameter in `CATEGORICAL` type.

  Fields:
    values: Required. The list of possible categories.
  """

  values = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1alpha1StudySpecParameterSpecDiscreteValueSpec(_messages.Message):
  r"""Value specification for a parameter in `DISCRETE` type.

  Fields:
    values: Required. A list of possible values. The list should be in
      increasing order and at least 1e-10 apart. For instance, this parameter
      might have possible settings of 1.5, 2.5, and 4.0. This list should not
      contain more than 1,000 values.
  """

  values = _messages.FloatField(1, repeated=True)


class GoogleCloudAiplatformV1alpha1StudySpecParameterSpecDoubleValueSpec(_messages.Message):
  r"""Value specification for a parameter in `DOUBLE` type.

  Fields:
    maxValue: Required. Inclusive maximum value of the parameter.
    minValue: Required. Inclusive minimum value of the parameter.
  """

  maxValue = _messages.FloatField(1)
  minValue = _messages.FloatField(2)


class GoogleCloudAiplatformV1alpha1StudySpecParameterSpecIntegerValueSpec(_messages.Message):
  r"""Value specification for a parameter in `INTEGER` type.

  Fields:
    maxValue: Required. Inclusive maximum value of the parameter.
    minValue: Required. Inclusive minimum value of the parameter.
  """

  maxValue = _messages.IntegerField(1)
  minValue = _messages.IntegerField(2)


class GoogleCloudAiplatformV1alpha1TimestampSplit(_messages.Message):
  r"""Assigns input data to training, validation, and test sets based on a
  provided timestamps. The youngest data pieces are assigned to training set,
  next to validation set, and the oldest to the test set. Supported only for
  tabular Datasets.

  Fields:
    key: Required. The key is a name of one of the Dataset's data columns. The
      values of the key (the values in the column) must be in RFC 3339 `date-
      time` format, where `time-offset` = `"Z"` (e.g.
      1985-04-12T23:20:50.52Z). If for a piece of data the key is not present
      or has an invalid value, that piece is ignored by the pipeline.
    testFraction: The fraction of the input data that is to be used to
      evaluate the Model.
    trainingFraction: The fraction of the input data that is to be used to
      train the Model.
    validationFraction: The fraction of the input data that is to be used to
      validate the Model.
  """

  key = _messages.StringField(1)
  testFraction = _messages.FloatField(2)
  trainingFraction = _messages.FloatField(3)
  validationFraction = _messages.FloatField(4)


class GoogleCloudAiplatformV1alpha1TrainingConfig(_messages.Message):
  r"""CMLE training config. For every active learning labeling iteration,
  system will train a machine learning model on CMLE. The trained model will
  be used by data sampling algorithm to select DataItems.

  Fields:
    timeoutTrainingMilliHours: The timeout hours for the CMLE training job,
      expressed in milli hours i.e. 1,000 value in this field means 1 hour.
  """

  timeoutTrainingMilliHours = _messages.IntegerField(1)


class GoogleCloudAiplatformV1alpha1TrainingPipeline(_messages.Message):
  r"""The TrainingPipeline orchestrates tasks associated with training a
  Model. It always executes the training task, and optionally may also export
  data from AI Platform's Dataset which becomes the training input, upload the
  Model to AI Platform, and evaluate the Model.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the pipeline.

  Messages:
    LabelsValue: The labels with user-defined metadata to organize
      TrainingPipelines. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.

  Fields:
    createTime: Output only. Time when the TrainingPipeline was created.
    displayName: Required. The user-defined name of this TrainingPipeline.
    encryptionSpec: Customer-managed encryption key spec for a
      TrainingPipeline. If set, this TrainingPipeline will be secured by this
      key. Note: Model trained by this TrainingPipeline is also secured by
      this key if model_to_upload is not set separately.
    endTime: Output only. Time when the TrainingPipeline entered any of the
      following states: `PIPELINE_STATE_SUCCEEDED`, `PIPELINE_STATE_FAILED`,
      `PIPELINE_STATE_CANCELLED`.
    error: Output only. Only populated when the pipeline's state is
      `PIPELINE_STATE_FAILED` or `PIPELINE_STATE_CANCELLED`.
    inputDataConfig: Specifies AI Platform owned input data that may be used
      for training the Model. The TrainingPipeline's training_task_definition
      should make clear whether this config is used and if there are any
      special requirements on how it should be filled. If nothing about this
      config is mentioned in the training_task_definition, then it should be
      assumed that the TrainingPipeline does not depend on this configuration.
    labels: The labels with user-defined metadata to organize
      TrainingPipelines. Label keys and values can be no longer than 64
      characters (Unicode codepoints), can only contain lowercase letters,
      numeric characters, underscores and dashes. International characters are
      allowed. See https://goo.gl/xmQnxf for more information and examples of
      labels.
    modelToUpload: Describes the Model that may be uploaded (via
      ModelService.UploadModel) by this TrainingPipeline. The
      TrainingPipeline's training_task_definition should make clear whether
      this Model description should be populated, and if there are any special
      requirements regarding how it should be filled. If nothing is mentioned
      in the training_task_definition, then it should be assumed that this
      field should not be filled and the training task either uploads the
      Model without a need of this information, or that training task does not
      support uploading a Model as part of the pipeline. When the Pipeline's
      state becomes `PIPELINE_STATE_SUCCEEDED` and the trained Model had been
      uploaded into AI Platform, then the model_to_upload's resource name is
      populated. The Model is always uploaded into the Project and Location in
      which this pipeline is.
    name: Output only. Resource name of the TrainingPipeline.
    startTime: Output only. Time when the TrainingPipeline for the first time
      entered the `PIPELINE_STATE_RUNNING` state.
    state: Output only. The detailed state of the pipeline.
    trainingTaskDefinition: Required. A Google Cloud Storage path to the YAML
      file that defines the training task which is responsible for producing
      the model artifact, and may also include additional auxiliary work. The
      definition files that can be used here are found in gs://google-cloud-
      aiplatform/schema/trainingjob/definition/. Note: The URI given on output
      will be immutable and probably different, including the URI scheme, than
      the one given on input. The output URI will point to a location where
      the user only has a read access.
    trainingTaskInputs: Required. The training task's parameter(s), as
      specified in the training_task_definition's `inputs`.
    trainingTaskMetadata: Output only. The metadata information as specified
      in the training_task_definition's `metadata`. This metadata is an
      auxiliary runtime and final information about the training task. While
      the pipeline is running this information is populated only at a best
      effort basis. Only present if the pipeline's training_task_definition
      contains `metadata` object.
    updateTime: Output only. Time when the TrainingPipeline was most recently
      updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the pipeline.

    Values:
      PIPELINE_STATE_UNSPECIFIED: The pipeline state is unspecified.
      PIPELINE_STATE_QUEUED: The pipeline has been just created or resumed and
        processing has not yet begun.
      PIPELINE_STATE_PENDING: The service is preparing to run the pipeline.
      PIPELINE_STATE_RUNNING: The pipeline is in progress.
      PIPELINE_STATE_SUCCEEDED: The pipeline completed successfully.
      PIPELINE_STATE_FAILED: The pipeline failed.
      PIPELINE_STATE_CANCELLING: The pipeline is being cancelled. From this
        state the pipeline may only go to either PIPELINE_STATE_SUCCEEDED,
        PIPELINE_STATE_FAILED or PIPELINE_STATE_CANCELLED.
      PIPELINE_STATE_CANCELLED: The pipeline has been cancelled.
      PIPELINE_STATE_PAUSED: The pipeline has been stopped, and can be
        resumed.
    """
    PIPELINE_STATE_UNSPECIFIED = 0
    PIPELINE_STATE_QUEUED = 1
    PIPELINE_STATE_PENDING = 2
    PIPELINE_STATE_RUNNING = 3
    PIPELINE_STATE_SUCCEEDED = 4
    PIPELINE_STATE_FAILED = 5
    PIPELINE_STATE_CANCELLING = 6
    PIPELINE_STATE_CANCELLED = 7
    PIPELINE_STATE_PAUSED = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels with user-defined metadata to organize TrainingPipelines.
    Label keys and values can be no longer than 64 characters (Unicode
    codepoints), can only contain lowercase letters, numeric characters,
    underscores and dashes. International characters are allowed. See
    https://goo.gl/xmQnxf for more information and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  encryptionSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1EncryptionSpec', 3)
  endTime = _messages.StringField(4)
  error = _messages.MessageField('GoogleRpcStatus', 5)
  inputDataConfig = _messages.MessageField('GoogleCloudAiplatformV1alpha1InputDataConfig', 6)
  labels = _messages.MessageField('LabelsValue', 7)
  modelToUpload = _messages.MessageField('GoogleCloudAiplatformV1alpha1Model', 8)
  name = _messages.StringField(9)
  startTime = _messages.StringField(10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  trainingTaskDefinition = _messages.StringField(12)
  trainingTaskInputs = _messages.MessageField('extra_types.JsonValue', 13)
  trainingTaskMetadata = _messages.MessageField('extra_types.JsonValue', 14)
  updateTime = _messages.StringField(15)


class GoogleCloudAiplatformV1alpha1Trial(_messages.Message):
  r"""A message representing a Trial. A Trial contains a unique set of
  Parameters that has been or will be evaluated, along with the objective
  metrics got by running the Trial.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of the Trial.

  Fields:
    endTime: Output only. Time when the Trial's status changed to `SUCCEEDED`
      or `INFEASIBLE`.
    finalMeasurement: Output only. The final measurement containing the
      objective value.
    id: Output only. The identifier of the Trial assigned by the service.
    parameters: Output only. The parameters of the Trial.
    startTime: Output only. Time when the Trial was started.
    state: Output only. The detailed state of the Trial.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of the Trial.

    Values:
      STATE_UNSPECIFIED: The Trial state is unspecified.
      REQUESTED: Indicates that a specific Trial has been requested, but it
        has not yet been suggested by the service.
      ACTIVE: Indicates that the Trial has been suggested.
      STOPPING: Indicates that the Trial should stop according to the service.
      SUCCEEDED: Indicates that the Trial is completed successfully.
      INFEASIBLE: Indicates that the Trial should not be attempted again. The
        service will set a Trial to INFEASIBLE when it's done but missing the
        final_measurement.
    """
    STATE_UNSPECIFIED = 0
    REQUESTED = 1
    ACTIVE = 2
    STOPPING = 3
    SUCCEEDED = 4
    INFEASIBLE = 5

  endTime = _messages.StringField(1)
  finalMeasurement = _messages.MessageField('GoogleCloudAiplatformV1alpha1Measurement', 2)
  id = _messages.StringField(3)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1alpha1TrialParameter', 4, repeated=True)
  startTime = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)


class GoogleCloudAiplatformV1alpha1TrialParameter(_messages.Message):
  r"""A message representing a parameter to be tuned.

  Fields:
    parameterId: Output only. The ID of the parameter. The parameter should be
      defined in StudySpec's Parameters.
    value: Output only. The value of the parameter. `number_value` will be set
      if a parameter defined in StudySpec is in type 'INTEGER', 'DOUBLE' or
      'DISCRETE'. `string_value` will be set if a parameter defined in
      StudySpec is in type 'CATEGORICAL'.
  """

  parameterId = _messages.StringField(1)
  value = _messages.MessageField('extra_types.JsonValue', 2)


class GoogleCloudAiplatformV1alpha1UndeployModelOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.UndeployModel.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1UndeployModelRequest(_messages.Message):
  r"""Request message for EndpointService.UndeployModel.

  Messages:
    TrafficSplitValue: If this field is provided, then the Endpoint's
      traffic_split will be overwritten with it. If last DeployedModel is
      being undeployed from the Endpoint, the [Endpoint.traffic_split] will
      always end up empty when this call returns. A DeployedModel will be
      successfully undeployed only if it doesn't have any traffic assigned to
      it when this method executes, or if this field unassigns any traffic to
      it.

  Fields:
    deployedModelId: Required. The ID of the DeployedModel to be undeployed
      from the Endpoint.
    trafficSplit: If this field is provided, then the Endpoint's traffic_split
      will be overwritten with it. If last DeployedModel is being undeployed
      from the Endpoint, the [Endpoint.traffic_split] will always end up empty
      when this call returns. A DeployedModel will be successfully undeployed
      only if it doesn't have any traffic assigned to it when this method
      executes, or if this field unassigns any traffic to it.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TrafficSplitValue(_messages.Message):
    r"""If this field is provided, then the Endpoint's traffic_split will be
    overwritten with it. If last DeployedModel is being undeployed from the
    Endpoint, the [Endpoint.traffic_split] will always end up empty when this
    call returns. A DeployedModel will be successfully undeployed only if it
    doesn't have any traffic assigned to it when this method executes, or if
    this field unassigns any traffic to it.

    Messages:
      AdditionalProperty: An additional property for a TrafficSplitValue
        object.

    Fields:
      additionalProperties: Additional properties of type TrafficSplitValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TrafficSplitValue object.

      Fields:
        key: Name of the additional property.
        value: A integer attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2, variant=_messages.Variant.INT32)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  deployedModelId = _messages.StringField(1)
  trafficSplit = _messages.MessageField('TrafficSplitValue', 2)


class GoogleCloudAiplatformV1alpha1UndeployModelResponse(_messages.Message):
  r"""Response message for EndpointService.UndeployModel."""


class GoogleCloudAiplatformV1alpha1UpdateSpecialistPoolOperationMetadata(_messages.Message):
  r"""Runtime operation metadata for
  SpecialistPoolService.UpdateSpecialistPool.

  Fields:
    genericMetadata: The operation generic information.
    specialistPool: Output only. The name of the SpecialistPool to which the
      specialists are being added. Format: `projects/{project_id}/locations/{l
      ocation_id}/specialistPools/{specialist_pool}`
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)
  specialistPool = _messages.StringField(2)


class GoogleCloudAiplatformV1alpha1UploadModelOperationMetadata(_messages.Message):
  r"""Details of ModelService.UploadModel operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1alpha1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1alpha1UploadModelRequest(_messages.Message):
  r"""Request message for ModelService.UploadModel.

  Fields:
    model: Required. The Model to create.
  """

  model = _messages.MessageField('GoogleCloudAiplatformV1alpha1Model', 1)


class GoogleCloudAiplatformV1alpha1UploadModelResponse(_messages.Message):
  r"""Response message of ModelService.UploadModel operation.

  Fields:
    model: The name of the uploaded Model resource. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  model = _messages.StringField(1)


class GoogleCloudAiplatformV1alpha1UserActionReference(_messages.Message):
  r"""References an API call. It contains more information about long running
  operation and Jobs that are triggered by the API call.

  Fields:
    dataLabelingJob: For API calls that start a LabelingJob. Resource name of
      the LabelingJob. Format: 'projects/{project}/locations/{location}/dataLa
      belingJobs/{data_labeling_job}'
    method: The method name of the API call. For example,
      "/google.cloud.aiplatform.v1alpha1.DatasetService.CreateDataset"
    operation: For API calls that return a long running operation. Resource
      name of the long running operation. Format:
      'projects/{project}/locations/{location}/operations/{operation}'
  """

  dataLabelingJob = _messages.StringField(1)
  method = _messages.StringField(2)
  operation = _messages.StringField(3)


class GoogleCloudAiplatformV1alpha1WorkerPoolSpec(_messages.Message):
  r"""Represents the spec of a worker pool in a job.

  Fields:
    containerSpec: The custom container task.
    machineSpec: Optional. Immutable. The specification of a single machine.
    pythonPackageSpec: The Python packaged task.
    replicaCount: Optional. The number of worker replicas to use for this
      worker pool.
  """

  containerSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1ContainerSpec', 1)
  machineSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1MachineSpec', 2)
  pythonPackageSpec = _messages.MessageField('GoogleCloudAiplatformV1alpha1PythonPackageSpec', 3)
  replicaCount = _messages.IntegerField(4)


class GoogleCloudAiplatformV1beta1AutomaticResources(_messages.Message):
  r"""A description of resources that to large degree are decided by AI
  Platform, and require only a modest additional configuration. Each Model
  supporting these resources documents its specific guidelines.

  Fields:
    maxReplicaCount: Immutable. The maximum number of replicas this
      DeployedModel may be deployed on when the traffic against it increases.
      If requested value is too large, the deployment will error, but if
      deployment succeeds then the ability to scale the model to that many
      replicas is guaranteed (barring service outages). If traffic against the
      DeployedModel increases beyond what its replicas at maximum may handle,
      a portion of the traffic will be dropped. If this value is not provided,
      a no upper bound for scaling under heavy traffic will be assume, though
      AI Platform may be unable to scale beyond certain replica number.
    minReplicaCount: Immutable. The minimum number of replicas this
      DeployedModel will be always deployed on. If traffic against it
      increases, it may dynamically be deployed onto more replicas up to
      max_replica_count, and as traffic decreases, some of these extra
      replicas may be freed. If requested value is too large, the deployment
      will error.
  """

  maxReplicaCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1BatchMigrateResourcesOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  MigrationService.BatchMigrateResources.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1BatchMigrateResourcesResponse(_messages.Message):
  r"""Response message for MigrationService.BatchMigrateResources.

  Fields:
    migrateResourceResponses: Successfully migrated resources.
  """

  migrateResourceResponses = _messages.MessageField('GoogleCloudAiplatformV1beta1MigrateResourceResponse', 1, repeated=True)


class GoogleCloudAiplatformV1beta1CreateDatasetOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.CreateDataset.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateEndpointOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.CreateEndpoint.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1CreateSpecialistPoolOperationMetadata(_messages.Message):
  r"""Runtime operation information for
  SpecialistPoolService.CreateSpecialistPool.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1DedicatedResources(_messages.Message):
  r"""A description of resources that are dedicated to a DeployedModel, and
  that need a higher degree of manual configuration.

  Fields:
    machineSpec: Required. Immutable. The specification of a single machine
      used by the prediction.
    maxReplicaCount: Immutable. The maximum number of replicas this
      DeployedModel may be deployed on when the traffic against it increases.
      If requested value is too large, the deployment will error, but if
      deployment succeeds then the ability to scale the model to that many
      replicas is guaranteed (barring service outages). If traffic against the
      DeployedModel increases beyond what its replicas at maximum may handle,
      a portion of the traffic will be dropped. If this value is not provided,
      will use min_replica_count as the default value.
    minReplicaCount: Required. Immutable. The minimum number of machine
      replicas this DeployedModel will be always deployed on. If traffic
      against it increases, it may dynamically be deployed onto more replicas,
      and as traffic decreases, some of these extra replicas may be freed.
      Note: if machine_spec.accelerator_count is above 0, currently the model
      will be always deployed precisely on min_replica_count.
  """

  machineSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1MachineSpec', 1)
  maxReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  minReplicaCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1DeleteOperationMetadata(_messages.Message):
  r"""Details of operations that perform deletes of any entities.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1DeployModelOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.DeployModel.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1DeployModelResponse(_messages.Message):
  r"""Response message for EndpointService.DeployModel.

  Fields:
    deployedModel: The DeployedModel that had been deployed in the Endpoint.
  """

  deployedModel = _messages.MessageField('GoogleCloudAiplatformV1beta1DeployedModel', 1)


class GoogleCloudAiplatformV1beta1DeployedModel(_messages.Message):
  r"""A deployment of a Model. Endpoints contain one or more DeployedModels.

  Fields:
    automaticResources: A description of resources that to large degree are
      decided by AI Platform, and require only a modest additional
      configuration.
    createTime: Output only. Timestamp when the DeployedModel was created.
    dedicatedResources: A description of resources that are dedicated to the
      DeployedModel, and that need a higher degree of manual configuration.
    displayName: The display name of the DeployedModel. If not provided upon
      creation, the Model's display_name is used.
    enableAccessLogging: These logs are like standard server access logs,
      containing information like timestamp and latency for each prediction
      request. Note that Stackdriver logs may incur a cost, especially if your
      project receives prediction requests at a high queries per second rate
      (QPS). Estimate your costs before enabling this option.
    enableContainerLogging: If true, the container of the DeployedModel
      instances will send `stderr` and `stdout` streams to Stackdriver
      Logging. Only supported for custom-trained Models and AutoML Tables
      Models.
    explanationSpec: Explanation configuration for this DeployedModel. When
      deploying a Model using EndpointService.DeployModel, this value
      overrides the value of Model.explanation_spec. All fields of
      explanation_spec are optional in the request. If a field of
      explanation_spec is not populated, the value of the same field of
      Model.explanation_spec is inherited. The corresponding
      Model.explanation_spec must be populated, otherwise explanation for this
      Model is not allowed.
    id: Output only. The ID of the DeployedModel.
    model: Required. The name of the Model this is the deployment of. Note
      that the Model may be in a different location than the DeployedModel's
      Endpoint.
    serviceAccount: The service account that the DeployedModel's container
      runs as. Specify the email address of the service account. If this
      service account is not specified, the container runs as a service
      account that doesn't have access to the resource project. Users
      deploying the Model must have the `iam.serviceAccounts.actAs` permission
      on this service account.
  """

  automaticResources = _messages.MessageField('GoogleCloudAiplatformV1beta1AutomaticResources', 1)
  createTime = _messages.StringField(2)
  dedicatedResources = _messages.MessageField('GoogleCloudAiplatformV1beta1DedicatedResources', 3)
  displayName = _messages.StringField(4)
  enableAccessLogging = _messages.BooleanField(5)
  enableContainerLogging = _messages.BooleanField(6)
  explanationSpec = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationSpec', 7)
  id = _messages.StringField(8)
  model = _messages.StringField(9)
  serviceAccount = _messages.StringField(10)


class GoogleCloudAiplatformV1beta1ExplanationMetadata(_messages.Message):
  r"""Metadata describing the Model's input and output for explanation.

  Messages:
    InputsValue: Required. Map from feature names to feature input metadata.
      Keys are the name of the features. Values are the specification of the
      feature. An empty InputMetadata is valid. It describes a text feature
      which has the name specified as the key in ExplanationMetadata.inputs.
      The baseline of the empty feature is chosen by AI Platform. For AI
      Platform provided Tensorflow images, the key can be any friendly name of
      the feature. Once specified, featureAttributions are keyed by this key
      (if not grouped with another feature). For custom images, the key must
      match with the key in instance.
    OutputsValue: Required. Map from output names to output metadata. For AI
      Platform provided Tensorflow images, keys can be any string user
      defines. For custom images, keys are the name of the output field in the
      prediction to be explained. Currently only one key is allowed.

  Fields:
    featureAttributionsSchemaUri: Points to a YAML file stored on Google Cloud
      Storage describing the format of the feature attributions. The schema is
      defined as an OpenAPI 3.0.2 [Schema
      Object](https://tinyurl.com/y538mdwt#schema-object). AutoML tabular
      Models always have this field populated by AI Platform. Note: The URI
      given on output may be different, including the URI scheme, than the one
      given on input. The output URI will point to a location where the user
      only has a read access.
    inputs: Required. Map from feature names to feature input metadata. Keys
      are the name of the features. Values are the specification of the
      feature. An empty InputMetadata is valid. It describes a text feature
      which has the name specified as the key in ExplanationMetadata.inputs.
      The baseline of the empty feature is chosen by AI Platform. For AI
      Platform provided Tensorflow images, the key can be any friendly name of
      the feature. Once specified, featureAttributions are keyed by this key
      (if not grouped with another feature). For custom images, the key must
      match with the key in instance.
    outputs: Required. Map from output names to output metadata. For AI
      Platform provided Tensorflow images, keys can be any string user
      defines. For custom images, keys are the name of the output field in the
      prediction to be explained. Currently only one key is allowed.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InputsValue(_messages.Message):
    r"""Required. Map from feature names to feature input metadata. Keys are
    the name of the features. Values are the specification of the feature. An
    empty InputMetadata is valid. It describes a text feature which has the
    name specified as the key in ExplanationMetadata.inputs. The baseline of
    the empty feature is chosen by AI Platform. For AI Platform provided
    Tensorflow images, the key can be any friendly name of the feature. Once
    specified, featureAttributions are keyed by this key (if not grouped with
    another feature). For custom images, the key must match with the key in
    instance.

    Messages:
      AdditionalProperty: An additional property for a InputsValue object.

    Fields:
      additionalProperties: Additional properties of type InputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadata
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class OutputsValue(_messages.Message):
    r"""Required. Map from output names to output metadata. For AI Platform
    provided Tensorflow images, keys can be any string user defines. For
    custom images, keys are the name of the output field in the prediction to
    be explained. Currently only one key is allowed.

    Messages:
      AdditionalProperty: An additional property for a OutputsValue object.

    Fields:
      additionalProperties: Additional properties of type OutputsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a OutputsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudAiplatformV1beta1ExplanationMetadataOutputMetadata
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationMetadataOutputMetadata', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  featureAttributionsSchemaUri = _messages.StringField(1)
  inputs = _messages.MessageField('InputsValue', 2)
  outputs = _messages.MessageField('OutputsValue', 3)


class GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadata(_messages.Message):
  r"""Metadata of the input of a feature. Fields other than
  InputMetadata.input_baselines are applicable only for Models that are using
  AI Platform-provided images for Tensorflow.

  Enums:
    EncodingValueValuesEnum: Defines how the feature is encoded into the input
      tensor. Defaults to IDENTITY.

  Fields:
    denseShapeTensorName: Specifies the shape of the values of the input if
      the input is a sparse representation. Refer to Tensorflow documentation
      for more details:
      https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
    encodedBaselines: A list of baselines for the encoded tensor. The shape of
      each baseline should match the shape of the encoded tensor. If a scalar
      is provided, AI Platform broadcast to the same shape as the encoded
      tensor.
    encodedTensorName: Encoded tensor is a transformation of the input tensor.
      Must be provided if choosing Integrated Gradients attribution or XRAI
      attribution and the input tensor is not differentiable. An encoded
      tensor is generated if the input tensor is encoded by a lookup table.
    encoding: Defines how the feature is encoded into the input tensor.
      Defaults to IDENTITY.
    featureValueDomain: The domain details of the input feature value. Like
      min/max, original mean or standard deviation if normalized.
    groupName: Name of the group that the input belongs to. Features with the
      same group name will be treated as one feature when computing
      attributions. Features grouped together can have different shapes in
      value. If provided, there will be one single attribution generated in
      featureAttributions, keyed by the group name.
    indexFeatureMapping: A list of feature names for each index in the input
      tensor. Required when the input InputMetadata.encoding is
      BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
    indicesTensorName: Specifies the index of the values of the input tensor.
      Required when the input tensor is a sparse representation. Refer to
      Tensorflow documentation for more details:
      https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
    inputBaselines: Baseline inputs for this feature. If no baseline is
      specified, AI Platform chooses the baseline for this feature. If
      multiple baselines are specified, AI Platform returns the average
      attributions across them in Attributions.baseline_attribution. For AI
      Platform provided Tensorflow images (both 1.x and 2.x), the shape of
      each baseline must match the shape of the input tensor. If a scalar is
      provided, we broadcast to the same shape as the input tensor. For custom
      images, the element of the baselines must be in the same format as the
      feature's input in the instance[]. The schema of any single instance may
      be specified via Endpoint's DeployedModels' Model's PredictSchemata's
      instance_schema_uri.
    inputTensorName: Name of the input tensor for this feature. Required and
      is only applicable to AI Platform provided images for Tensorflow.
    modality: Modality of the feature. Valid values are: numeric, image.
      Defaults to numeric.
    visualization: Visualization configurations for image explanation.
  """

  class EncodingValueValuesEnum(_messages.Enum):
    r"""Defines how the feature is encoded into the input tensor. Defaults to
    IDENTITY.

    Values:
      ENCODING_UNSPECIFIED: Default value. This is the same as IDENTITY.
      IDENTITY: The tensor represents one feature.
      BAG_OF_FEATURES: The tensor represents a bag of features where each
        index maps to a feature. InputMetadata.index_feature_mapping must be
        provided for this encoding. For example: ``` input = [27, 6.0, 150]
        index_feature_mapping = ["age", "height", "weight"] ```
      BAG_OF_FEATURES_SPARSE: The tensor represents a bag of features where
        each index maps to a feature. Zero values in the tensor indicates
        feature being non-existent. InputMetadata.index_feature_mapping must
        be provided for this encoding. For example: ``` input = [2, 0, 5, 0,
        1] index_feature_mapping = ["a", "b", "c", "d", "e"] ```
      INDICATOR: The tensor is a list of binaries representing whether a
        feature exists or not (1 indicates existence).
        InputMetadata.index_feature_mapping must be provided for this
        encoding. For example: ``` input = [1, 0, 1, 0, 1]
        index_feature_mapping = ["a", "b", "c", "d", "e"] ```
      COMBINED_EMBEDDING: The tensor is encoded into a 1-dimensional array
        represented by an encoded tensor. InputMetadata.encoded_tensor_name
        must be provided for this encoding. For example: ``` input = ["This",
        "is", "a", "test", "."] encoded = [0.1, 0.2, 0.3, 0.4, 0.5] ```
      CONCAT_EMBEDDING: Select this encoding when the input tensor is encoded
        into a 2-dimensional array represented by an encoded tensor.
        InputMetadata.encoded_tensor_name must be provided for this encoding.
        The first dimension of the encoded tensor's shape is the same as the
        input tensor's shape. For example: ``` input = ["This", "is", "a",
        "test", "."] encoded = [[0.1, 0.2, 0.3, 0.4, 0.5], [0.2, 0.1, 0.4,
        0.3, 0.5], [0.5, 0.1, 0.3, 0.5, 0.4], [0.5, 0.3, 0.1, 0.2, 0.4], [0.4,
        0.3, 0.2, 0.5, 0.1]] ```
    """
    ENCODING_UNSPECIFIED = 0
    IDENTITY = 1
    BAG_OF_FEATURES = 2
    BAG_OF_FEATURES_SPARSE = 3
    INDICATOR = 4
    COMBINED_EMBEDDING = 5
    CONCAT_EMBEDDING = 6

  denseShapeTensorName = _messages.StringField(1)
  encodedBaselines = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)
  encodedTensorName = _messages.StringField(3)
  encoding = _messages.EnumField('EncodingValueValuesEnum', 4)
  featureValueDomain = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataFeatureValueDomain', 5)
  groupName = _messages.StringField(6)
  indexFeatureMapping = _messages.StringField(7, repeated=True)
  indicesTensorName = _messages.StringField(8)
  inputBaselines = _messages.MessageField('extra_types.JsonValue', 9, repeated=True)
  inputTensorName = _messages.StringField(10)
  modality = _messages.StringField(11)
  visualization = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataVisualization', 12)


class GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataFeatureValueDomain(_messages.Message):
  r"""Domain details of the input feature value. Provides numeric information
  about the feature, such as its range (min, max). If the feature has been
  pre-processed, for example with z-scoring, then it provides information
  about how to recover the original feature. For example, if the input feature
  is an image and it has been pre-processed to obtain 0-mean and stddev = 1
  values, then original_mean, and original_stddev refer to the mean and stddev
  of the original feature (e.g. image tensor) from which input feature (with
  mean = 0 and stddev = 1) was obtained.

  Fields:
    maxValue: The maximum permissible value for this feature.
    minValue: The minimum permissible value for this feature.
    originalMean: If this input feature has been normalized to a mean value of
      0, the original_mean specifies the mean value of the domain prior to
      normalization.
    originalStddev: If this input feature has been normalized to a standard
      deviation of 1.0, the original_stddev specifies the standard deviation
      of the domain prior to normalization.
  """

  maxValue = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  minValue = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  originalMean = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  originalStddev = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataVisualization(_messages.Message):
  r"""Visualization configurations for image explanation.

  Enums:
    ColorMapValueValuesEnum: The color scheme used for the highlighted areas.
      Defaults to PINK_GREEN for Integrated Gradients attribution, which shows
      positive attributions in green and negative in pink. Defaults to VIRIDIS
      for XRAI attribution, which highlights the most influential regions in
      yellow and the least influential in blue.
    OverlayTypeValueValuesEnum: How the original image is displayed in the
      visualization. Adjusting the overlay can help increase visual clarity if
      the original image makes it difficult to view the visualization.
      Defaults to NONE.
    PolarityValueValuesEnum: Whether to only highlight pixels with positive
      contributions, negative or both. Defaults to POSITIVE.
    TypeValueValuesEnum: Type of the image visualization. Only applicable to
      Integrated Gradients attribution. OUTLINES shows regions of attribution,
      while PIXELS shows per-pixel attribution. Defaults to OUTLINES.

  Fields:
    clipPercentLowerbound: Excludes attributions below the specified
      percentile, from the highlighted areas. Defaults to 35.
    clipPercentUpperbound: Excludes attributions above the specified
      percentile from the highlighted areas. Using the clip_percent_upperbound
      and clip_percent_lowerbound together can be useful for filtering out
      noise and making it easier to see areas of strong attribution. Defaults
      to 99.9.
    colorMap: The color scheme used for the highlighted areas. Defaults to
      PINK_GREEN for Integrated Gradients attribution, which shows positive
      attributions in green and negative in pink. Defaults to VIRIDIS for XRAI
      attribution, which highlights the most influential regions in yellow and
      the least influential in blue.
    overlayType: How the original image is displayed in the visualization.
      Adjusting the overlay can help increase visual clarity if the original
      image makes it difficult to view the visualization. Defaults to NONE.
    polarity: Whether to only highlight pixels with positive contributions,
      negative or both. Defaults to POSITIVE.
    type: Type of the image visualization. Only applicable to Integrated
      Gradients attribution. OUTLINES shows regions of attribution, while
      PIXELS shows per-pixel attribution. Defaults to OUTLINES.
  """

  class ColorMapValueValuesEnum(_messages.Enum):
    r"""The color scheme used for the highlighted areas. Defaults to
    PINK_GREEN for Integrated Gradients attribution, which shows positive
    attributions in green and negative in pink. Defaults to VIRIDIS for XRAI
    attribution, which highlights the most influential regions in yellow and
    the least influential in blue.

    Values:
      COLOR_MAP_UNSPECIFIED: Should not be used.
      PINK_GREEN: Positive: green. Negative: pink.
      VIRIDIS: Viridis color map: A perceptually uniform color mapping which
        is easier to see by those with colorblindness and progresses from
        yellow to green to blue. Positive: yellow. Negative: blue.
      RED: Positive: red. Negative: red.
      GREEN: Positive: green. Negative: green.
      RED_GREEN: Positive: green. Negative: red.
      PINK_WHITE_GREEN: PiYG palette.
    """
    COLOR_MAP_UNSPECIFIED = 0
    PINK_GREEN = 1
    VIRIDIS = 2
    RED = 3
    GREEN = 4
    RED_GREEN = 5
    PINK_WHITE_GREEN = 6

  class OverlayTypeValueValuesEnum(_messages.Enum):
    r"""How the original image is displayed in the visualization. Adjusting
    the overlay can help increase visual clarity if the original image makes
    it difficult to view the visualization. Defaults to NONE.

    Values:
      OVERLAY_TYPE_UNSPECIFIED: Default value. This is the same as NONE.
      NONE: No overlay.
      ORIGINAL: The attributions are shown on top of the original image.
      GRAYSCALE: The attributions are shown on top of grayscaled version of
        the original image.
      MASK_BLACK: The attributions are used as a mask to reveal predictive
        parts of the image and hide the un-predictive parts.
    """
    OVERLAY_TYPE_UNSPECIFIED = 0
    NONE = 1
    ORIGINAL = 2
    GRAYSCALE = 3
    MASK_BLACK = 4

  class PolarityValueValuesEnum(_messages.Enum):
    r"""Whether to only highlight pixels with positive contributions, negative
    or both. Defaults to POSITIVE.

    Values:
      POLARITY_UNSPECIFIED: Default value. This is the same as POSITIVE.
      POSITIVE: Highlights the pixels/outlines that were most influential to
        the model's prediction.
      NEGATIVE: Setting polarity to negative highlights areas that does not
        lead to the models's current prediction.
      BOTH: Shows both positive and negative attributions.
    """
    POLARITY_UNSPECIFIED = 0
    POSITIVE = 1
    NEGATIVE = 2
    BOTH = 3

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of the image visualization. Only applicable to Integrated
    Gradients attribution. OUTLINES shows regions of attribution, while PIXELS
    shows per-pixel attribution. Defaults to OUTLINES.

    Values:
      TYPE_UNSPECIFIED: Should not be used.
      PIXELS: Shows which pixel contributed to the image prediction.
      OUTLINES: Shows which region contributed to the image prediction by
        outlining the region.
    """
    TYPE_UNSPECIFIED = 0
    PIXELS = 1
    OUTLINES = 2

  clipPercentLowerbound = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  clipPercentUpperbound = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  colorMap = _messages.EnumField('ColorMapValueValuesEnum', 3)
  overlayType = _messages.EnumField('OverlayTypeValueValuesEnum', 4)
  polarity = _messages.EnumField('PolarityValueValuesEnum', 5)
  type = _messages.EnumField('TypeValueValuesEnum', 6)


class GoogleCloudAiplatformV1beta1ExplanationMetadataOutputMetadata(_messages.Message):
  r"""Metadata of the prediction output to be explained.

  Fields:
    displayNameMappingKey: Specify a field name in the prediction to look for
      the display name. Use this if the prediction contains the display names
      for the outputs. The display names in the prediction must have the same
      shape of the outputs, so that it can be located by
      Attribution.output_index for a specific output.
    indexDisplayNameMapping: Static mapping between the index and display
      name. Use this if the outputs are a deterministic n-dimensional array,
      e.g. a list of scores of all the classes in a pre-defined order for a
      multi-classification Model. It's not feasible if the outputs are non-
      deterministic, e.g. the Model produces top-k classes or sort the outputs
      by their values. The shape of the value must be an n-dimensional array
      of strings. The number of dimentions must match that of the outputs to
      be explained. The Attribution.output_display_name is populated by
      locating in the mapping with Attribution.output_index.
    outputTensorName: Name of the output tensor. Required and is only
      applicable to AI Platform provided images for Tensorflow.
  """

  displayNameMappingKey = _messages.StringField(1)
  indexDisplayNameMapping = _messages.MessageField('extra_types.JsonValue', 2)
  outputTensorName = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1ExplanationParameters(_messages.Message):
  r"""Parameters to configure explaining for Model's predictions.

  Fields:
    integratedGradientsAttribution: An attribution method that computes
      Aumann-Shapley values taking advantage of the model's fully
      differentiable structure. Refer to this paper for more details:
      https://arxiv.org/abs/1703.01365
    outputIndices: If populated, only returns attributions that have
      output_index contained in output_indices. It must be an ndarray of
      integers, with the same shape of the output it's explaining. If not
      populated, returns attributions for top_k indices of outputs. If neither
      top_k nor output_indeices is populated, returns the argmax index of the
      outputs. Only applicable to Models that predict multiple outputs (e,g,
      multi-class Models that predict multiple classes).
    sampledShapleyAttribution: An attribution method that approximates Shapley
      values for features that contribute to the label being predicted. A
      sampling strategy is used to approximate the value rather than
      considering all subsets of features. Refer to this paper for model
      details: https://arxiv.org/abs/1306.4265.
    topK: If populated, returns attributions for top K indices of outputs
      (defaults to 1). Only applies to Models that predicts more than one
      outputs (e,g, multi-class Models). When set to -1, returns explanations
      for all outputs.
    xraiAttribution: An attribution method that redistributes Integrated
      Gradients attribution to segmented regions, taking advantage of the
      model's fully differentiable structure. Refer to this paper for more
      details: https://arxiv.org/abs/1906.02825 XRAI currently performs better
      on natural images, like a picture of a house or an animal. If the images
      are taken in artificial environments, like a lab or manufacturing line,
      or from diagnostic equipment, like x-rays or quality-control cameras,
      use Integrated Gradients instead.
  """

  integratedGradientsAttribution = _messages.MessageField('GoogleCloudAiplatformV1beta1IntegratedGradientsAttribution', 1)
  outputIndices = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)
  sampledShapleyAttribution = _messages.MessageField('GoogleCloudAiplatformV1beta1SampledShapleyAttribution', 3)
  topK = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  xraiAttribution = _messages.MessageField('GoogleCloudAiplatformV1beta1XraiAttribution', 5)


class GoogleCloudAiplatformV1beta1ExplanationSpec(_messages.Message):
  r"""Specification of Model explanation.

  Fields:
    metadata: Required. Metadata describing the Model's input and output for
      explanation.
    parameters: Required. Parameters that configure explaining of the Model's
      predictions.
  """

  metadata = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationMetadata', 1)
  parameters = _messages.MessageField('GoogleCloudAiplatformV1beta1ExplanationParameters', 2)


class GoogleCloudAiplatformV1beta1ExportDataOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.ExportData.

  Fields:
    gcsOutputDirectory: A Google Cloud Storage directory which path ends with
      '/'. The exported data is stored in the directory.
    genericMetadata: The common part of the operation metadata.
  """

  gcsOutputDirectory = _messages.StringField(1)
  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 2)


class GoogleCloudAiplatformV1beta1ExportDataResponse(_messages.Message):
  r"""Response message for DatasetService.ExportData.

  Fields:
    exportedFiles: All of the files that are exported in this export
      operation.
  """

  exportedFiles = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1beta1ExportModelOperationMetadata(_messages.Message):
  r"""Details of ModelService.ExportModel operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
    outputInfo: Output only. Information further describing the output of this
      Model export.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)
  outputInfo = _messages.MessageField('GoogleCloudAiplatformV1beta1ExportModelOperationMetadataOutputInfo', 2)


class GoogleCloudAiplatformV1beta1ExportModelOperationMetadataOutputInfo(_messages.Message):
  r"""Further describes the output of the ExportModel. Supplements
  ExportModelRequest.OutputConfig.

  Fields:
    artifactOutputUri: Output only. If the Model artifact is being exported to
      Google Cloud Storage this is the full path of the directory created,
      into which the Model files are being written to.
    imageOutputUri: Output only. If the Model image is being exported to
      Google Container Registry or Artifact Registry this is the full path of
      the image created.
  """

  artifactOutputUri = _messages.StringField(1)
  imageOutputUri = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1ExportModelResponse(_messages.Message):
  r"""Response message of ModelService.ExportModel operation."""


class GoogleCloudAiplatformV1beta1FeatureNoiseSigma(_messages.Message):
  r"""Noise sigma by features. Noise sigma represents the standard deviation
  of the gaussian kernel that will be used to add noise to interpolated inputs
  prior to computing gradients.

  Fields:
    noiseSigma: Noise sigma per feature. No noise is added to features that
      are not set.
  """

  noiseSigma = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureNoiseSigmaNoiseSigmaForFeature', 1, repeated=True)


class GoogleCloudAiplatformV1beta1FeatureNoiseSigmaNoiseSigmaForFeature(_messages.Message):
  r"""Noise sigma for a single feature.

  Fields:
    name: The name of the input feature for which noise sigma is provided. The
      features are defined in explanation metadata inputs.
    sigma: This represents the standard deviation of the Gaussian kernel that
      will be used to add noise to the feature prior to computing gradients.
      Similar to noise_sigma but represents the noise added to the current
      feature. Defaults to 0.1.
  """

  name = _messages.StringField(1)
  sigma = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1GenericOperationMetadata(_messages.Message):
  r"""Generic Metadata shared by all operations.

  Fields:
    createTime: Output only. Time when the operation was created.
    partialFailures: Output only. Partial failures encountered. E.g. single
      files that couldn't be read. This field should never exceed 20 entries.
      Status details field will contain standard GCP error details.
    updateTime: Output only. Time when the operation was updated for the last
      time. If the operation has finished (successfully or not), this is the
      finish time.
  """

  createTime = _messages.StringField(1)
  partialFailures = _messages.MessageField('GoogleRpcStatus', 2, repeated=True)
  updateTime = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1ImportDataOperationMetadata(_messages.Message):
  r"""Runtime operation information for DatasetService.ImportData.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1ImportDataResponse(_messages.Message):
  r"""Response message for DatasetService.ImportData."""


class GoogleCloudAiplatformV1beta1IntegratedGradientsAttribution(_messages.Message):
  r"""An attribution method that computes the Aumann-Shapley value taking
  advantage of the model's fully differentiable structure. Refer to this paper
  for more details: https://arxiv.org/abs/1703.01365

  Fields:
    smoothGradConfig: Config for SmoothGrad approximation of gradients. When
      enabled, the gradients are approximated by averaging the gradients from
      noisy samples in the vicinity of the inputs. Adding noise can help
      improve the computed gradients. Refer to this paper for more details:
      https://arxiv.org/pdf/1706.03825.pdf
    stepCount: Required. The number of steps for approximating the path
      integral. A good value to start is 50 and gradually increase until the
      sum to diff property is within the desired error range. Valid range of
      its value is [1, 100], inclusively.
  """

  smoothGradConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1SmoothGradConfig', 1)
  stepCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1MachineSpec(_messages.Message):
  r"""Specification of a single machine.

  Enums:
    AcceleratorTypeValueValuesEnum: Immutable. The type of accelerator(s) that
      may be attached to the machine as per accelerator_count.

  Fields:
    acceleratorCount: The number of accelerators to attach to the machine.
    acceleratorType: Immutable. The type of accelerator(s) that may be
      attached to the machine as per accelerator_count.
    machineType: Immutable. The type of the machine. For the machine types
      supported for prediction, see https://tinyurl.com/aip-
      docs/predictions/machine-types. For machine types supported for creating
      a custom training job, see https://tinyurl.com/aip-
      docs/training/configure-compute. For DeployedModel this field is
      optional, and the default value is `n1-standard-2`. For
      BatchPredictionJob or as part of WorkerPoolSpec this field is required.
  """

  class AcceleratorTypeValueValuesEnum(_messages.Enum):
    r"""Immutable. The type of accelerator(s) that may be attached to the
    machine as per accelerator_count.

    Values:
      ACCELERATOR_TYPE_UNSPECIFIED: Unspecified accelerator type, which means
        no accelerator.
      NVIDIA_TESLA_K80: Nvidia Tesla K80 GPU.
      NVIDIA_TESLA_P100: Nvidia Tesla P100 GPU.
      NVIDIA_TESLA_V100: Nvidia Tesla V100 GPU.
      NVIDIA_TESLA_P4: Nvidia Tesla P4 GPU.
      NVIDIA_TESLA_T4: Nvidia Tesla T4 GPU.
      TPU_V2: TPU v2.
      TPU_V3: TPU v3.
    """
    ACCELERATOR_TYPE_UNSPECIFIED = 0
    NVIDIA_TESLA_K80 = 1
    NVIDIA_TESLA_P100 = 2
    NVIDIA_TESLA_V100 = 3
    NVIDIA_TESLA_P4 = 4
    NVIDIA_TESLA_T4 = 5
    TPU_V2 = 6
    TPU_V3 = 7

  acceleratorCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  acceleratorType = _messages.EnumField('AcceleratorTypeValueValuesEnum', 2)
  machineType = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1MigratableResource(_messages.Message):
  r"""Represents one resource that exists in automl.googleapis.com,
  datalabeling.googleapis.com or ml.googleapis.com.

  Fields:
    automlDataset: Output only. Represents one Dataset in
      automl.googleapis.com.
    automlModel: Output only. Represents one Model in automl.googleapis.com.
    dataLabelingDataset: Output only. Represents one Dataset in
      datalabeling.googleapis.com.
    lastMigrateTime: Output only. Timestamp when last migrate attempt on this
      MigratableResource started. Will not be set if there's no migrate
      attempt on this MigratableResource.
    lastUpdateTime: Output only. Timestamp when this MigratableResource was
      last updated.
    mlEngineModelVersion: Output only. Represents one Version in
      ml.googleapis.com.
  """

  automlDataset = _messages.MessageField('GoogleCloudAiplatformV1beta1MigratableResourceAutomlDataset', 1)
  automlModel = _messages.MessageField('GoogleCloudAiplatformV1beta1MigratableResourceAutomlModel', 2)
  dataLabelingDataset = _messages.MessageField('GoogleCloudAiplatformV1beta1MigratableResourceDataLabelingDataset', 3)
  lastMigrateTime = _messages.StringField(4)
  lastUpdateTime = _messages.StringField(5)
  mlEngineModelVersion = _messages.MessageField('GoogleCloudAiplatformV1beta1MigratableResourceMlEngineModelVersion', 6)


class GoogleCloudAiplatformV1beta1MigratableResourceAutomlDataset(_messages.Message):
  r"""Represents one Dataset in automl.googleapis.com.

  Fields:
    dataset: Full resource name of automl Dataset. Format:
      `projects/{project}/locations/{location}/datasets/{dataset}`.
    datasetDisplayName: The Dataset's display name in automl.googleapis.com.
  """

  dataset = _messages.StringField(1)
  datasetDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1MigratableResourceAutomlModel(_messages.Message):
  r"""Represents one Model in automl.googleapis.com.

  Fields:
    model: Full resource name of automl Model. Format:
      `projects/{project}/locations/{location}/models/{model}`.
    modelDisplayName: The Model's display name in automl.googleapis.com.
  """

  model = _messages.StringField(1)
  modelDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1MigratableResourceDataLabelingDataset(_messages.Message):
  r"""Represents one Dataset in datalabeling.googleapis.com.

  Fields:
    dataLabelingAnnotatedDatasets: The migratable AnnotatedDataset in
      datalabeling.googleapis.com belongs to the data labeling Dataset.
    dataset: Full resource name of data labeling Dataset. Format:
      `projects/{project}/datasets/{dataset}`.
    datasetDisplayName: The Dataset's display name in
      datalabeling.googleapis.com.
  """

  dataLabelingAnnotatedDatasets = _messages.MessageField('GoogleCloudAiplatformV1beta1MigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset', 1, repeated=True)
  dataset = _messages.StringField(2)
  datasetDisplayName = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1MigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset(_messages.Message):
  r"""Represents one AnnotatedDataset in datalabeling.googleapis.com.

  Fields:
    annotatedDataset: Full resource name of data labeling AnnotatedDataset.
      Format: `projects/{project}/datasets/{dataset}/annotatedDatasets/{annota
      ted_dataset}`.
    annotatedDatasetDisplayName: The AnnotatedDataset's display name in
      datalabeling.googleapis.com.
  """

  annotatedDataset = _messages.StringField(1)
  annotatedDatasetDisplayName = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1MigratableResourceMlEngineModelVersion(_messages.Message):
  r"""Represents one model Version in ml.googleapis.com.

  Fields:
    endpoint: The ml.googleapis.com endpoint that this model Version currently
      lives in. Example values: * ml.googleapis.com * us-centrall-
      ml.googleapis.com * europe-west4-ml.googleapis.com * asia-
      east1-ml.googleapis.com
    version: Full resource name of ml engine model Version. Format:
      `projects/{project}/models/{model}/versions/{version}`.
  """

  endpoint = _messages.StringField(1)
  version = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1MigrateResourceResponse(_messages.Message):
  r"""Describes a successfully migrated resource.

  Fields:
    dataset: Migrated Dataset's resource name.
    migratableResource: Before migration, the identifier in ml.googleapis.com,
      automl.googleapis.com or datalabeling.googleapis.com.
    model: Migrated Model's resource name.
  """

  dataset = _messages.StringField(1)
  migratableResource = _messages.MessageField('GoogleCloudAiplatformV1beta1MigratableResource', 2)
  model = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1SampledShapleyAttribution(_messages.Message):
  r"""An attribution method that approximates Shapley values for features that
  contribute to the label being predicted. A sampling strategy is used to
  approximate the value rather than considering all subsets of features.

  Fields:
    pathCount: Required. The number of feature permutations to consider when
      approximating the Shapley values. Valid range of its value is [1, 50],
      inclusively.
  """

  pathCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1SchemaAnnotationSpecColor(_messages.Message):
  r"""An entry of mapping between color and AnnotationSpec. The mapping is
  used in segmentation mask.

  Fields:
    color: The color of the AnnotationSpec in a segmentation mask.
    displayName: The display name of the AnnotationSpec represented by the
      color in the segmentation mask.
    id: The ID of the AnnotationSpec represented by the color in the
      segmentation mask.
  """

  color = _messages.MessageField('GoogleTypeColor', 1)
  displayName = _messages.StringField(2)
  id = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1SchemaImageBoundingBoxAnnotation(_messages.Message):
  r"""Annotation details specific to image object detection.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    xMax: The rightmost coordinate of the bounding box.
    xMin: The leftmost coordinate of the bounding box.
    yMax: The bottommost coordinate of the bounding box.
    yMin: The topmost coordinate of the bounding box.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  xMax = _messages.FloatField(3)
  xMin = _messages.FloatField(4)
  yMax = _messages.FloatField(5)
  yMin = _messages.FloatField(6)


class GoogleCloudAiplatformV1beta1SchemaImageClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to image classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaImageDataItem(_messages.Message):
  r"""Payload of Image DataItem.

  Fields:
    gcsUri: Required. Google Cloud Storage URI points to the original image in
      user's bucket. The image is up to 30MB in size.
    mimeType: Output only. The mime type of the content of the image. Only the
      images in below listed mime types are supported. - image/jpeg -
      image/gif - image/png - image/webp - image/bmp - image/tiff -
      image/vnd.microsoft.icon
  """

  gcsUri = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaImageDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Image DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Image DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaImageSegmentationAnnotation(_messages.Message):
  r"""Annotation details specific to image segmentation.

  Fields:
    maskAnnotation: Mask based segmentation annotation. Only one mask
      annotation can exist for one image.
    polygonAnnotation: Polygon annotation.
    polylineAnnotation: Polyline annotation.
  """

  maskAnnotation = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaImageSegmentationAnnotationMaskAnnotation', 1)
  polygonAnnotation = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaImageSegmentationAnnotationPolygonAnnotation', 2)
  polylineAnnotation = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaImageSegmentationAnnotationPolylineAnnotation', 3)


class GoogleCloudAiplatformV1beta1SchemaImageSegmentationAnnotationMaskAnnotation(_messages.Message):
  r"""The mask based segmentation annotation.

  Fields:
    annotationSpecColors: The mapping between color and AnnotationSpec for
      this Annotation.
    maskGcsUri: Google Cloud Storage URI that points to the mask image. The
      image must be in PNG format. It must have the same size as the
      DataItem's image. Each pixel in the image mask represents the
      AnnotationSpec which the pixel in the image DataItem belong to. Each
      color is mapped to one AnnotationSpec based on annotation_spec_colors.
  """

  annotationSpecColors = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaAnnotationSpecColor', 1, repeated=True)
  maskGcsUri = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaImageSegmentationAnnotationPolygonAnnotation(_messages.Message):
  r"""Represents a polygon in image.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    vertexes: The vertexes are connected one by one and the last vertex is
      connected to the first one to represent a polygon.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  vertexes = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaVertex', 3, repeated=True)


class GoogleCloudAiplatformV1beta1SchemaImageSegmentationAnnotationPolylineAnnotation(_messages.Message):
  r"""Represents a polyline in image.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    vertexes: The vertexes are connected one by one and the last vertex in not
      connected to the first one.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  vertexes = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaVertex', 3, repeated=True)


class GoogleCloudAiplatformV1beta1SchemaPredictInstanceImageClassificationPredictionInstance(_messages.Message):
  r"""Prediction input format for Image Classification.

  Fields:
    content: The image bytes or GCS URI to make the prediction on.
    mimeType: The MIME type of the content of the image. Only the images in
      below listed MIME types are supported. - image/jpeg - image/gif -
      image/png - image/webp - image/bmp - image/tiff -
      image/vnd.microsoft.icon
  """

  content = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaPredictInstanceImageObjectDetectionPredictionInstance(_messages.Message):
  r"""Prediction input format for Image Object Detection.

  Fields:
    content: The image bytes or GCS URI to make the prediction on.
    mimeType: The MIME type of the content of the image. Only the images in
      below listed MIME types are supported. - image/jpeg - image/gif -
      image/png - image/webp - image/bmp - image/tiff -
      image/vnd.microsoft.icon
  """

  content = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaPredictInstanceImageSegmentationPredictionInstance(_messages.Message):
  r"""Prediction input format for Image Segmentation.

  Fields:
    content: The image bytes to make the predictions on.
    mimeType: The MIME type of the content of the image. Only the images in
      below listed MIME types are supported. - image/jpeg - image/png
  """

  content = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaPredictInstanceTextClassificationPredictionInstance(_messages.Message):
  r"""Prediction input format for Text Classification.

  Fields:
    content: The text snippet to make the predictions on.
    mimeType: The MIME type of the text snippet. The supported MIME types are
      listed below. - text/plain
  """

  content = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaPredictInstanceTextExtractionPredictionInstance(_messages.Message):
  r"""Prediction input format for Text Extraction.

  Fields:
    content: The text snippet to make the predictions on.
    key: This field is only used for batch prediction. If a key is provided,
      the batch prediction result will by mapped to this key. If omitted, then
      the batch prediction result will contain the entire input instance. AI
      Platform will not check if keys in the request are duplicates, so it is
      up to the caller to ensure the keys are unique.
    mimeType: The MIME type of the text snippet. The supported MIME types are
      listed below. - text/plain
  """

  content = _messages.StringField(1)
  key = _messages.StringField(2)
  mimeType = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1SchemaPredictInstanceTextSentimentPredictionInstance(_messages.Message):
  r"""Prediction input format for Text Sentiment.

  Fields:
    content: The text snippet to make the predictions on.
    mimeType: The MIME type of the text snippet. The supported MIME types are
      listed below. - text/plain
  """

  content = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaPredictInstanceVideoActionRecognitionPredictionInstance(_messages.Message):
  r"""Prediction input format for Video Action Recognition.

  Fields:
    content: The Google Cloud Storage location of the video on which to
      perform the prediction.
    mimeType: The MIME type of the content of the video. Only the following
      are supported: video/mp4 video/avi video/quicktime
    timeSegmentEnd: The end, exclusive, of the video's time segment on which
      to perform the prediction. Expressed as a number of seconds as measured
      from the start of the video, with "s" appended at the end. Fractions are
      allowed, up to a microsecond precision, and "inf" or "Infinity" is
      allowed, which means the end of the video.
    timeSegmentStart: The beginning, inclusive, of the video's time segment on
      which to perform the prediction. Expressed as a number of seconds as
      measured from the start of the video, with "s" appended at the end.
      Fractions are allowed, up to a microsecond precision.
  """

  content = _messages.StringField(1)
  mimeType = _messages.StringField(2)
  timeSegmentEnd = _messages.StringField(3)
  timeSegmentStart = _messages.StringField(4)


class GoogleCloudAiplatformV1beta1SchemaPredictInstanceVideoClassificationPredictionInstance(_messages.Message):
  r"""Prediction input format for Video Classification.

  Fields:
    content: The Google Cloud Storage location of the video on which to
      perform the prediction.
    mimeType: The MIME type of the content of the video. Only the following
      are supported: video/mp4 video/avi video/quicktime
    timeSegmentEnd: The end, exclusive, of the video's time segment on which
      to perform the prediction. Expressed as a number of seconds as measured
      from the start of the video, with "s" appended at the end. Fractions are
      allowed, up to a microsecond precision, and "inf" or "Infinity" is
      allowed, which means the end of the video.
    timeSegmentStart: The beginning, inclusive, of the video's time segment on
      which to perform the prediction. Expressed as a number of seconds as
      measured from the start of the video, with "s" appended at the end.
      Fractions are allowed, up to a microsecond precision.
  """

  content = _messages.StringField(1)
  mimeType = _messages.StringField(2)
  timeSegmentEnd = _messages.StringField(3)
  timeSegmentStart = _messages.StringField(4)


class GoogleCloudAiplatformV1beta1SchemaPredictInstanceVideoObjectTrackingPredictionInstance(_messages.Message):
  r"""Prediction input format for Video Object Tracking.

  Fields:
    content: The Google Cloud Storage location of the video on which to
      perform the prediction.
    mimeType: The MIME type of the content of the video. Only the following
      are supported: video/mp4 video/avi video/quicktime
    timeSegmentEnd: The end, exclusive, of the video's time segment on which
      to perform the prediction. Expressed as a number of seconds as measured
      from the start of the video, with "s" appended at the end. Fractions are
      allowed, up to a microsecond precision, and "inf" or "Infinity" is
      allowed, which means the end of the video.
    timeSegmentStart: The beginning, inclusive, of the video's time segment on
      which to perform the prediction. Expressed as a number of seconds as
      measured from the start of the video, with "s" appended at the end.
      Fractions are allowed, up to a microsecond precision.
  """

  content = _messages.StringField(1)
  mimeType = _messages.StringField(2)
  timeSegmentEnd = _messages.StringField(3)
  timeSegmentStart = _messages.StringField(4)


class GoogleCloudAiplatformV1beta1SchemaPredictParamsImageClassificationPredictionParams(_messages.Message):
  r"""Prediction model parameters for Image Classification.

  Fields:
    confidenceThreshold: The Model only returns predictions with at least this
      confidence score. Default value is 0.0
    maxPredictions: The Model only returns up to that many top, by confidence
      score, predictions per instance. If this number is very high, the Model
      may return fewer predictions. Default value is 10.
  """

  confidenceThreshold = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  maxPredictions = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1SchemaPredictParamsImageObjectDetectionPredictionParams(_messages.Message):
  r"""Prediction model parameters for Image Object Detection.

  Fields:
    confidenceThreshold: The Model only returns predictions with at least this
      confidence score. Default value is 0.0
    maxPredictions: The Model only returns up to that many top, by confidence
      score, predictions per instance. Note that number of returned
      predictions is also limited by metadata's predictionsLimit. Default
      value is 10.
  """

  confidenceThreshold = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  maxPredictions = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1SchemaPredictParamsImageSegmentationPredictionParams(_messages.Message):
  r"""Prediction model parameters for Image Segmentation.

  Fields:
    confidenceThreshold: When the model predicts category of pixels of the
      image, it will only provide predictions for pixels that it is at least
      this much confident about. All other pixels will be classified as
      background. Default value is 0.5.
  """

  confidenceThreshold = _messages.FloatField(1, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1SchemaPredictParamsVideoActionRecognitionPredictionParams(_messages.Message):
  r"""Prediction model parameters for Video Action Recognition.

  Fields:
    confidenceThreshold: The Model only returns predictions with at least this
      confidence score. Default value is 0.0
    maxPredictions: The model only returns up to that many top, by confidence
      score, predictions per frame of the video. If this number is very high,
      the Model may return fewer predictions per frame. Default value is 50.
  """

  confidenceThreshold = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  maxPredictions = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1SchemaPredictParamsVideoClassificationPredictionParams(_messages.Message):
  r"""Prediction model parameters for Video Classification.

  Fields:
    confidenceThreshold: The Model only returns predictions with at least this
      confidence score. Default value is 0.0
    maxPredictions: The Model only returns up to that many top, by confidence
      score, predictions per instance. If this number is very high, the Model
      may return fewer predictions. Default value is 10,000.
    oneSecIntervalClassification: Set to true to request classification for a
      video at one-second intervals. AI Platform returns labels and their
      confidence scores for each second of the entire time segment of the
      video that user specified in the input WARNING: Model evaluation is not
      done for this classification type, the quality of it depends on the
      training data, but there are no metrics provided to describe that
      quality. Default value is false
    segmentClassification: Set to true to request segment-level
      classification. AI Platform returns labels and their confidence scores
      for the entire time segment of the video that user specified in the
      input instance. Default value is true
    shotClassification: Set to true to request shot-level classification. AI
      Platform determines the boundaries for each camera shot in the entire
      time segment of the video that user specified in the input instance. AI
      Platform then returns labels and their confidence scores for each
      detected shot, along with the start and end time of the shot. WARNING:
      Model evaluation is not done for this classification type, the quality
      of it depends on the training data, but there are no metrics provided to
      describe that quality. Default value is false
  """

  confidenceThreshold = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  maxPredictions = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  oneSecIntervalClassification = _messages.BooleanField(3)
  segmentClassification = _messages.BooleanField(4)
  shotClassification = _messages.BooleanField(5)


class GoogleCloudAiplatformV1beta1SchemaPredictParamsVideoObjectTrackingPredictionParams(_messages.Message):
  r"""Prediction model parameters for Video Object Tracking.

  Fields:
    confidenceThreshold: The Model only returns predictions with at least this
      confidence score. Default value is 0.0
    maxPredictions: The model only returns up to that many top, by confidence
      score, predictions per frame of the video. If this number is very high,
      the Model may return fewer predictions per frame. Default value is 50.
    minBoundingBoxSize: Only bounding boxes with shortest edge at least that
      long as a relative value of video frame size are returned. Default value
      is 0.0.
  """

  confidenceThreshold = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  maxPredictions = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  minBoundingBoxSize = _messages.FloatField(3, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1SchemaPredictPredictionClassificationPredictionResult(_messages.Message):
  r"""Prediction output format for Image and Text Classification.

  Fields:
    confidences: The Model's confidences in correctness of the predicted IDs,
      higher value means higher confidence. Order matches the Ids.
    displayNames: The display names of the AnnotationSpecs that had been
      identified, order matches the IDs.
    ids: The resource IDs of the AnnotationSpecs that had been identified,
      ordered by the confidence score descendingly.
  """

  confidences = _messages.FloatField(1, repeated=True, variant=_messages.Variant.FLOAT)
  displayNames = _messages.StringField(2, repeated=True)
  ids = _messages.IntegerField(3, repeated=True)


class GoogleCloudAiplatformV1beta1SchemaPredictPredictionImageObjectDetectionPredictionResult(_messages.Message):
  r"""Prediction output format for Image Object Detection.

  Messages:
    BboxesValueListEntry: Single entry in a BboxesValue.

  Fields:
    bboxes: Bounding boxes, i.e. the rectangles over the image, that pinpoint
      the found AnnotationSpecs. Given in order that matches the IDs. Each
      bounding box is an array of 4 numbers `xMin`, `xMax`, `yMin`, and
      `yMax`, which represent the extremal coordinates of the box. They are
      relative to the image size, and the point 0,0 is in the top left of the
      image.
    confidences: The Model's confidences in correctness of the predicted IDs,
      higher value means higher confidence. Order matches the Ids.
    displayNames: The display names of the AnnotationSpecs that had been
      identified, order matches the IDs.
    ids: The resource IDs of the AnnotationSpecs that had been identified,
      ordered by the confidence score descendingly.
  """

  class BboxesValueListEntry(_messages.Message):
    r"""Single entry in a BboxesValue.

    Fields:
      entry: A extra_types.JsonValue attribute.
    """

    entry = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)

  bboxes = _messages.MessageField('BboxesValueListEntry', 1, repeated=True)
  confidences = _messages.FloatField(2, repeated=True, variant=_messages.Variant.FLOAT)
  displayNames = _messages.StringField(3, repeated=True)
  ids = _messages.IntegerField(4, repeated=True)


class GoogleCloudAiplatformV1beta1SchemaPredictPredictionImageSegmentationPredictionResult(_messages.Message):
  r"""Prediction output format for Image Segmentation.

  Fields:
    categoryMask: A PNG image where each pixel in the mask represents the
      category in which the pixel in the original image was predicted to
      belong to. The size of this image will be the same as the original
      image. The mapping between the AnntoationSpec and the color can be found
      in model's metadata. The model will choose the most likely category and
      if none of the categories reach the confidence threshold, the pixel will
      be marked as background.
    confidenceMask: A one channel image which is encoded as an 8bit lossless
      PNG. The size of the image will be the same as the original image. For a
      specific pixel, darker color means less confidence in correctness of the
      cateogry in the categoryMask for the corresponding pixel. Black means no
      confidence and white means complete confidence.
  """

  categoryMask = _messages.StringField(1)
  confidenceMask = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaPredictPredictionTabularClassificationPredictionResult(_messages.Message):
  r"""Prediction output format for Tabular Classification.

  Fields:
    classes: The name of the classes being classified, contains all possible
      values of the target column.
    scores: The model's confidence in each class being correct, higher value
      means higher confidence. The N-th score corresponds to the N-th class in
      classes.
  """

  classes = _messages.StringField(1, repeated=True)
  scores = _messages.FloatField(2, repeated=True, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1SchemaPredictPredictionTabularRegressionPredictionResult(_messages.Message):
  r"""Prediction output format for Tabular Regression.

  Fields:
    lowerBound: The lower bound of the prediction interval.
    upperBound: The upper bound of the prediction interval.
    value: The regression value.
  """

  lowerBound = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  upperBound = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  value = _messages.FloatField(3, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1SchemaPredictPredictionTextExtractionPredictionResult(_messages.Message):
  r"""Prediction output format for Text Extraction.

  Fields:
    confidences: The Model's confidences in correctness of the predicted IDs,
      higher value means higher confidence. Order matches the Ids.
    displayNames: The display names of the AnnotationSpecs that had been
      identified, order matches the IDs.
    ids: The resource IDs of the AnnotationSpecs that had been identified,
      ordered by the confidence score descendingly.
    textSegmentEndOffsets: The end offsets, inclusive, of the text segment in
      which the AnnotationSpec has been identified. Expressed as a zero-based
      number of characters as measured from the start of the text snippet.
    textSegmentStartOffsets: The start offsets, inclusive, of the text segment
      in which the AnnotationSpec has been identified. Expressed as a zero-
      based number of characters as measured from the start of the text
      snippet.
  """

  confidences = _messages.FloatField(1, repeated=True, variant=_messages.Variant.FLOAT)
  displayNames = _messages.StringField(2, repeated=True)
  ids = _messages.IntegerField(3, repeated=True)
  textSegmentEndOffsets = _messages.IntegerField(4, repeated=True)
  textSegmentStartOffsets = _messages.IntegerField(5, repeated=True)


class GoogleCloudAiplatformV1beta1SchemaPredictPredictionTextSentimentPredictionResult(_messages.Message):
  r"""Represents a line of JSONL in the text sentiment batch prediction output
  file. This is a hack to allow printing of integer values.

  Fields:
    instance: User's input instance.
    prediction: The prediction result.
  """

  instance = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaPredictInstanceTextSentimentPredictionInstance', 1)
  prediction = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaPredictPredictionTextSentimentPredictionResultPrediction', 2)


class GoogleCloudAiplatformV1beta1SchemaPredictPredictionTextSentimentPredictionResultPrediction(_messages.Message):
  r"""Prediction output format for Text Sentiment.

  Fields:
    sentiment: The integer sentiment labels between 0 (inclusive) and
      sentimentMax label (inclusive), while 0 maps to the least positive
      sentiment and sentimentMax maps to the most positive one. The higher the
      score is, the more positive the sentiment in the text snippet is. Note:
      sentimentMax is an integer value between 1 (inclusive) and 10
      (inclusive).
  """

  sentiment = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1SchemaPredictPredictionTimeSeriesForecastingPredictionResult(_messages.Message):
  r"""Prediction output format for Time Series Forecasting.

  Fields:
    lowerBound: The lower bound of the prediction interval.
    upperBound: The upper bound of the prediction interval.
    value: The regression value.
  """

  lowerBound = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  upperBound = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  value = _messages.FloatField(3, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1SchemaPredictPredictionVideoActionRecognitionPredictionResult(_messages.Message):
  r"""Prediction output format for Video Action Recognition.

  Fields:
    confidence: The Model's confidence in correction of this prediction,
      higher value means higher confidence.
    displayName: The display name of the AnnotationSpec that had been
      identified.
    id: The resource ID of the AnnotationSpec that had been identified.
    timeSegmentEnd: The end, exclusive, of the video's time segment in which
      the AnnotationSpec has been identified. Expressed as a number of seconds
      as measured from the start of the video, with fractions up to a
      microsecond precision, and with "s" appended at the end.
    timeSegmentStart: The beginning, inclusive, of the video's time segment in
      which the AnnotationSpec has been identified. Expressed as a number of
      seconds as measured from the start of the video, with fractions up to a
      microsecond precision, and with "s" appended at the end.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  displayName = _messages.StringField(2)
  id = _messages.StringField(3)
  timeSegmentEnd = _messages.StringField(4)
  timeSegmentStart = _messages.StringField(5)


class GoogleCloudAiplatformV1beta1SchemaPredictPredictionVideoClassificationPredictionResult(_messages.Message):
  r"""Prediction output format for Video Classification.

  Fields:
    confidence: The Model's confidence in correction of this prediction,
      higher value means higher confidence.
    displayName: The display name of the AnnotationSpec that had been
      identified.
    id: The resource ID of the AnnotationSpec that had been identified.
    timeSegmentEnd: The end, exclusive, of the video's time segment in which
      the AnnotationSpec has been identified. Expressed as a number of seconds
      as measured from the start of the video, with fractions up to a
      microsecond precision, and with "s" appended at the end. Note that for
      'segment-classification' prediction type, this equals the original
      'timeSegmentEnd' from the input instance, for other types it is the end
      of a shot or a 1 second interval respectively.
    timeSegmentStart: The beginning, inclusive, of the video's time segment in
      which the AnnotationSpec has been identified. Expressed as a number of
      seconds as measured from the start of the video, with fractions up to a
      microsecond precision, and with "s" appended at the end. Note that for
      'segment-classification' prediction type, this equals the original
      'timeSegmentStart' from the input instance, for other types it is the
      start of a shot or a 1 second interval respectively.
    type: The type of the prediction. The requested types can be configured
      via parameters. This will be one of - segment-classification - shot-
      classification - one-sec-interval-classification
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  displayName = _messages.StringField(2)
  id = _messages.StringField(3)
  timeSegmentEnd = _messages.StringField(4)
  timeSegmentStart = _messages.StringField(5)
  type = _messages.StringField(6)


class GoogleCloudAiplatformV1beta1SchemaPredictPredictionVideoObjectTrackingPredictionResult(_messages.Message):
  r"""Prediction output format for Video Object Tracking.

  Fields:
    confidence: The Model's confidence in correction of this prediction,
      higher value means higher confidence.
    displayName: The display name of the AnnotationSpec that had been
      identified.
    frames: All of the frames of the video in which a single object instance
      has been detected. The bounding boxes in the frames identify the same
      object.
    id: The resource ID of the AnnotationSpec that had been identified.
    timeSegmentEnd: The end, inclusive, of the video's time segment in which
      the object instance has been detected. Expressed as a number of seconds
      as measured from the start of the video, with fractions up to a
      microsecond precision, and with "s" appended at the end.
    timeSegmentStart: The beginning, inclusive, of the video's time segment in
      which the object instance has been detected. Expressed as a number of
      seconds as measured from the start of the video, with fractions up to a
      microsecond precision, and with "s" appended at the end.
  """

  confidence = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  displayName = _messages.StringField(2)
  frames = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaPredictPredictionVideoObjectTrackingPredictionResultFrame', 3, repeated=True)
  id = _messages.StringField(4)
  timeSegmentEnd = _messages.StringField(5)
  timeSegmentStart = _messages.StringField(6)


class GoogleCloudAiplatformV1beta1SchemaPredictPredictionVideoObjectTrackingPredictionResultFrame(_messages.Message):
  r"""The fields `xMin`, `xMax`, `yMin`, and `yMax` refer to a bounding box,
  i.e. the rectangle over the video frame pinpointing the found
  AnnotationSpec. The coordinates are relative to the frame size, and the
  point 0,0 is in the top left of the frame.

  Fields:
    timeOffset: A time (frame) of a video in which the object has been
      detected. Expressed as a number of seconds as measured from the start of
      the video, with fractions up to a microsecond precision, and with "s"
      appended at the end.
    xMax: The rightmost coordinate of the bounding box.
    xMin: The leftmost coordinate of the bounding box.
    yMax: The bottommost coordinate of the bounding box.
    yMin: The topmost coordinate of the bounding box.
  """

  timeOffset = _messages.StringField(1)
  xMax = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  xMin = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  yMax = _messages.FloatField(4, variant=_messages.Variant.FLOAT)
  yMin = _messages.FloatField(5, variant=_messages.Variant.FLOAT)


class GoogleCloudAiplatformV1beta1SchemaPredictionResult(_messages.Message):
  r"""Represents a line of JSONL in the batch prediction output file.

  Messages:
    InstanceValue: User's input instance. Struct is used here instead of Any
      so that JsonFormat does not append an extra "@type" field when we
      convert the proto to JSON.

  Fields:
    error: The error result. Do not set prediction if this is set.
    instance: User's input instance. Struct is used here instead of Any so
      that JsonFormat does not append an extra "@type" field when we convert
      the proto to JSON.
    key: Optional user-provided key from the input instance.
    prediction: The prediction result. Value is used here instead of Any so
      that JsonFormat does not append an extra "@type" field when we convert
      the proto to JSON and so we can represent array of objects. Do not set
      error if this is set.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InstanceValue(_messages.Message):
    r"""User's input instance. Struct is used here instead of Any so that
    JsonFormat does not append an extra "@type" field when we convert the
    proto to JSON.

    Messages:
      AdditionalProperty: An additional property for a InstanceValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a InstanceValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  error = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaPredictionResultError', 1)
  instance = _messages.MessageField('InstanceValue', 2)
  key = _messages.StringField(3)
  prediction = _messages.MessageField('extra_types.JsonValue', 4)


class GoogleCloudAiplatformV1beta1SchemaPredictionResultError(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaPredictionResultError object.

  Enums:
    StatusValueValuesEnum: Error status. This will be serialized into the enum
      name e.g. "NOT_FOUND".

  Fields:
    message: Error message with additional details.
    status: Error status. This will be serialized into the enum name e.g.
      "NOT_FOUND".
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Error status. This will be serialized into the enum name e.g.
    "NOT_FOUND".

    Values:
      OK: Not an error; returned on success HTTP Mapping: 200 OK
      CANCELLED: The operation was cancelled, typically by the caller. HTTP
        Mapping: 499 Client Closed Request
      UNKNOWN: Unknown error. For example, this error may be returned when a
        `Status` value received from another address space belongs to an error
        space that is not known in this address space. Also errors raised by
        APIs that do not return enough error information may be converted to
        this error. HTTP Mapping: 500 Internal Server Error
      INVALID_ARGUMENT: The client specified an invalid argument. Note that
        this differs from `FAILED_PRECONDITION`. `INVALID_ARGUMENT` indicates
        arguments that are problematic regardless of the state of the system
        (e.g., a malformed file name). HTTP Mapping: 400 Bad Request
      DEADLINE_EXCEEDED: The deadline expired before the operation could
        complete. For operations that change the state of the system, this
        error may be returned even if the operation has completed
        successfully. For example, a successful response from a server could
        have been delayed long enough for the deadline to expire. HTTP
        Mapping: 504 Gateway Timeout
      NOT_FOUND: Some requested entity (e.g., file or directory) was not
        found. Note to server developers: if a request is denied for an entire
        class of users, such as gradual feature rollout or undocumented
        allowlist, `NOT_FOUND` may be used. If a request is denied for some
        users within a class of users, such as user-based access control,
        `PERMISSION_DENIED` must be used. HTTP Mapping: 404 Not Found
      ALREADY_EXISTS: The entity that a client attempted to create (e.g., file
        or directory) already exists. HTTP Mapping: 409 Conflict
      PERMISSION_DENIED: The caller does not have permission to execute the
        specified operation. `PERMISSION_DENIED` must not be used for
        rejections caused by exhausting some resource (use
        `RESOURCE_EXHAUSTED` instead for those errors). `PERMISSION_DENIED`
        must not be used if the caller can not be identified (use
        `UNAUTHENTICATED` instead for those errors). This error code does not
        imply the request is valid or the requested entity exists or satisfies
        other pre-conditions. HTTP Mapping: 403 Forbidden
      UNAUTHENTICATED: The request does not have valid authentication
        credentials for the operation. HTTP Mapping: 401 Unauthorized
      RESOURCE_EXHAUSTED: Some resource has been exhausted, perhaps a per-user
        quota, or perhaps the entire file system is out of space. HTTP
        Mapping: 429 Too Many Requests
      FAILED_PRECONDITION: The operation was rejected because the system is
        not in a state required for the operation's execution. For example,
        the directory to be deleted is non-empty, an rmdir operation is
        applied to a non-directory, etc. Service implementors can use the
        following guidelines to decide between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`: (a) Use `UNAVAILABLE` if the client can
        retry just the failing call. (b) Use `ABORTED` if the client should
        retry at a higher level (e.g., when a client-specified test-and-set
        fails, indicating the client should restart a read-modify-write
        sequence). (c) Use `FAILED_PRECONDITION` if the client should not
        retry until the system state has been explicitly fixed. E.g., if an
        "rmdir" fails because the directory is non-empty,
        `FAILED_PRECONDITION` should be returned since the client should not
        retry unless the files are deleted from the directory. HTTP Mapping:
        400 Bad Request
      ABORTED: The operation was aborted, typically due to a concurrency issue
        such as a sequencer check failure or transaction abort. See the
        guidelines above for deciding between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`. HTTP Mapping: 409 Conflict
      OUT_OF_RANGE: The operation was attempted past the valid range. E.g.,
        seeking or reading past end-of-file. Unlike `INVALID_ARGUMENT`, this
        error indicates a problem that may be fixed if the system state
        changes. For example, a 32-bit file system will generate
        `INVALID_ARGUMENT` if asked to read at an offset that is not in the
        range [0,2^32-1], but it will generate `OUT_OF_RANGE` if asked to read
        from an offset past the current file size. There is a fair bit of
        overlap between `FAILED_PRECONDITION` and `OUT_OF_RANGE`. We recommend
        using `OUT_OF_RANGE` (the more specific error) when it applies so that
        callers who are iterating through a space can easily look for an
        `OUT_OF_RANGE` error to detect when they are done. HTTP Mapping: 400
        Bad Request
      UNIMPLEMENTED: The operation is not implemented or is not
        supported/enabled in this service. HTTP Mapping: 501 Not Implemented
      INTERNAL: Internal errors. This means that some invariants expected by
        the underlying system have been broken. This error code is reserved
        for serious errors. HTTP Mapping: 500 Internal Server Error
      UNAVAILABLE: The service is currently unavailable. This is most likely a
        transient condition, which can be corrected by retrying with a
        backoff. Note that it is not always safe to retry non-idempotent
        operations. See the guidelines above for deciding between
        `FAILED_PRECONDITION`, `ABORTED`, and `UNAVAILABLE`. HTTP Mapping: 503
        Service Unavailable
      DATA_LOSS: Unrecoverable data loss or corruption. HTTP Mapping: 500
        Internal Server Error
    """
    OK = 0
    CANCELLED = 1
    UNKNOWN = 2
    INVALID_ARGUMENT = 3
    DEADLINE_EXCEEDED = 4
    NOT_FOUND = 5
    ALREADY_EXISTS = 6
    PERMISSION_DENIED = 7
    UNAUTHENTICATED = 8
    RESOURCE_EXHAUSTED = 9
    FAILED_PRECONDITION = 10
    ABORTED = 11
    OUT_OF_RANGE = 12
    UNIMPLEMENTED = 13
    INTERNAL = 14
    UNAVAILABLE = 15
    DATA_LOSS = 16

  message = _messages.StringField(1)
  status = _messages.EnumField('StatusValueValuesEnum', 2)


class GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain tables data.

  Fields:
    inputConfig: A
      GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataInputConfig
      attribute.
  """

  inputConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataInputConfig', 1)


class GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataBigQuerySource(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataBigQuerySource
  object.

  Fields:
    uri: The URI of a BigQuery table.
  """

  uri = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataGcsSource(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataGcsSource
  object.

  Fields:
    uri: Cloud Storage URI of one or more files. Only CSV files are supported.
      The first line of the CSV file is used as the header. If there are
      multiple files, the header is the first line of the lexicographically
      first file, the other files must either contain the exact same header or
      omit the header.
  """

  uri = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataInputConfig(_messages.Message):
  r"""The tables Dataset's data source. The Dataset doesn't store the data
  directly, but only pointer(s) to its data.

  Fields:
    bigquerySource: A
      GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataBigQuerySource
      attribute.
    gcsSource: A
      GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataGcsSource
      attribute.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataBigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTablesDatasetMetadataGcsSource', 2)


class GoogleCloudAiplatformV1beta1SchemaTextClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to text classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaTextDataItem(_messages.Message):
  r"""Payload of Text DataItem.

  Fields:
    gcsUri: Output only. Google Cloud Storage URI points to the original text
      in user's bucket. The text file is up to 10MB in size.
  """

  gcsUri = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1SchemaTextDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Text DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Text DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaTextExtractionAnnotation(_messages.Message):
  r"""Annotation details specific to text extraction.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    textSegment: The segment of the text content.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  textSegment = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTextSegment', 3)


class GoogleCloudAiplatformV1beta1SchemaTextSegment(_messages.Message):
  r"""The text segment inside of DataItem.

  Fields:
    content: The text content in the segment for output only.
    endOffset: Zero-based character index of the first character past the end
      of the text segment (counting character from the beginning of the text).
      The character at the end_offset is NOT included in the text segment.
    startOffset: Zero-based character index of the first character of the text
      segment (counting characters from the beginning of the text).
  """

  content = _messages.StringField(1)
  endOffset = _messages.IntegerField(2, variant=_messages.Variant.UINT64)
  startOffset = _messages.IntegerField(3, variant=_messages.Variant.UINT64)


class GoogleCloudAiplatformV1beta1SchemaTextSentimentAnnotation(_messages.Message):
  r"""Annotation details specific to text sentiment.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    sentiment: The sentiment score for text.
    sentimentMax: The sentiment max score for text.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  sentiment = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  sentimentMax = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1SchemaTextSentimentSavedQueryMetadata(_messages.Message):
  r"""The metadata of SavedQuery contains TextSentiment Annotations.

  Fields:
    sentimentMax: The maximum sentiment of sentiment Anntoation in this
      SavedQuery.
  """

  sentimentMax = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1SchemaTimeSegment(_messages.Message):
  r"""A time period inside of a DataItem that has a time dimension (e.g.
  video).

  Fields:
    endTimeOffset: End of the time segment (exclusive), represented as the
      duration since the start of the DataItem.
    startTimeOffset: Start of the time segment (inclusive), represented as the
      duration since the start of the DataItem.
  """

  endTimeOffset = _messages.StringField(1)
  startTimeOffset = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain time series data.

  Fields:
    inputConfig: A
      GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataInputConfig
      attribute.
    timeColumn: The column name of the time column that identifies time order
      in the time series.
    timeSeriesIdentifierColumn: The column name of the time series identifier
      column that identifies the time series.
  """

  inputConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataInputConfig', 1)
  timeColumn = _messages.StringField(2)
  timeSeriesIdentifierColumn = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataBigQuerySource(_messages.Message):
  r"""A
  GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataBigQuerySource
  object.

  Fields:
    uri: The URI of a BigQuery table.
  """

  uri = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataGcsSource(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataGcsSource
  object.

  Fields:
    uri: Cloud Storage URI of one or more files. Only CSV files are supported.
      The first line of the CSV file is used as the header. If there are
      multiple files, the header is the first line of the lexicographically
      first file, the other files must either contain the exact same header or
      omit the header.
  """

  uri = _messages.StringField(1, repeated=True)


class GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataInputConfig(_messages.Message):
  r"""The time series Dataset's data source. The Dataset doesn't store the
  data directly, but only pointer(s) to its data.

  Fields:
    bigquerySource: A
      GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataBigQuerySourc
      e attribute.
    gcsSource: A
      GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataGcsSource
      attribute.
  """

  bigquerySource = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataBigQuerySource', 1)
  gcsSource = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTimeSeriesDatasetMetadataGcsSource', 2)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecasting(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Forecasting Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
    metadata: The metadata information.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputs', 1)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingMetadata', 2)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecasti
  ngInputs object.

  Fields:
    exportEvaluatedDataItemsConfig: Configuration for exporting test set
      predictions to a BigQuery table. If this configuration is absent, then
      the export is not performed.
    forecastWindowEnd: The number of periods offset into the future as the end
      of the forecast window (the window of future values to predict, relative
      to the present.), where each period is one unit of granularity as
      defined by the `period` field above. Inclusive.
    forecastWindowStart: The number of periods offset into the future as the
      start of the forecast window (the window of future values to predict,
      relative to the present.), where each period is one unit of granularity
      as defined by the `period` field above. Default to 0. Inclusive.
    optimizationObjective: Objective function the model is optimizing towards.
      The training process creates a model that optimizes the value of the
      objective function over the validation set. The supported optimization
      objectives: "minimize-rmse" (default) - Minimize root-mean-squared error
      (RMSE). "minimize-mae" - Minimize mean-absolute error (MAE). "minimize-
      rmsle" - Minimize root-mean-squared log error (RMSLE). "minimize-rmspe"
      - Minimize root-mean-squared percentage error (RMSPE). "minimize-wape-
      mae" - Minimize the combination of weighted absolute percentage error
      (WAPE) and mean-absolute-error (MAE). "minimize-quantile-loss" -
      Minimize the quantile loss at the quantiles defined in `quantiles`.
    pastHorizon: The number of periods offset into the past to restrict past
      sequence, where each period is one unit of granularity as defined by the
      `period`. Default value 0 means that it lets algorithm to define the
      value. Inclusive.
    period: Expected difference in time granularity between rows in the data.
      If it is not set, the period is inferred from data.
    quantiles: Quantiles to use for minimize-quantile-loss
      `optimization_objective`. Up to 5 quantiles are allowed of values
      between 0 and 1, exclusive. Required if the value of
      optimization_objective is minimize-quantile-loss. Represents the percent
      quantiles to use for that objective. Quantiles must be unique.
    staticColumns: Column names that should be used as static columns. The
      value of these columns are static per time series.
    targetColumn: The name of the column that the model is to predict.
    timeColumn: The name of the column that identifies time order in the time
      series.
    timeSeriesIdentifierColumn: The name of the column that identifies the
      time series.
    timeVariantPastAndFutureColumns: Column names that should be used as time
      variant past and future columns. This column contains information for
      the given entity (identified by the key column) that is known for the
      past and the future
    timeVariantPastOnlyColumns: Column names that should be used as time
      variant past only columns. This column contains information for the
      given entity (identified by the time_series_identifier_column) that is
      known for the past but not the future (e.g. population of a city in a
      given year, or weather on a given day).
    trainBudgetMilliNodeHours: Required. The train budget of creating this
      model, expressed in milli node hours i.e. 1,000 value in this field
      means 1 node hour. The training cost of the model will not exceed this
      budget. The final cost will be attempted to be close to the budget,
      though may end up being (even) noticeably smaller - at the backend's
      discretion. This especially may happen when further model training
      ceases to provide any improvements. If the budget is set to a value
      known to be insufficient to train a model for the given dataset, the
      training won't be attempted and will error. The train budget must be
      between 1,000 and 72,000 milli node hours, inclusive.
    transformations: Each transformation will apply transform function to
      given input column. And the result will be used for training. When
      creating transformation for BigQuery Struct column, the column should be
      flattened using "." as the delimiter.
    weightColumn: Column name that should be used as the weight column. Higher
      values in this column give more importance to the row during model
      training. The column must have numeric values between 0 and 10000
      inclusively; 0 means the row is ignored for training. If weight column
      field is not set, then all rows are assumed to have equal weight of 1.
  """

  exportEvaluatedDataItemsConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionExportEvaluatedDataItemsConfig', 1)
  forecastWindowEnd = _messages.IntegerField(2)
  forecastWindowStart = _messages.IntegerField(3)
  optimizationObjective = _messages.StringField(4)
  pastHorizon = _messages.IntegerField(5)
  period = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsPeriod', 6)
  quantiles = _messages.FloatField(7, repeated=True)
  staticColumns = _messages.StringField(8, repeated=True)
  targetColumn = _messages.StringField(9)
  timeColumn = _messages.StringField(10)
  timeSeriesIdentifierColumn = _messages.StringField(11)
  timeVariantPastAndFutureColumns = _messages.StringField(12, repeated=True)
  timeVariantPastOnlyColumns = _messages.StringField(13, repeated=True)
  trainBudgetMilliNodeHours = _messages.IntegerField(14)
  transformations = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformation', 15, repeated=True)
  weightColumn = _messages.StringField(16)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsPeriod(_messages.Message):
  r"""A duration of time expressed in time granularity units.

  Fields:
    quantity: The number of units per period, e.g. 3 weeks or 2 months.
    unit: The time granularity unit of this time period. The supported unit
      are: "minute" "hour" "day" "week" "month" "year"
  """

  quantity = _messages.IntegerField(1)
  unit = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformation(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecasti
  ngInputsTransformation object.

  Fields:
    auto: A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForec
      astingInputsTransformationAutoTransformation attribute.
    categorical: A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAuto
      MlForecastingInputsTransformationCategoricalTransformation attribute.
    numeric: A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlFo
      recastingInputsTransformationNumericTransformation attribute.
    repeatedCategorical: A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefini
      tionAutoMlForecastingInputsTransformationCategoricalArrayTransformation
      attribute.
    repeatedNumeric: A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinition
      AutoMlForecastingInputsTransformationNumericArrayTransformation
      attribute.
    repeatedText: A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAut
      oMlForecastingInputsTransformationTextArrayTransformation attribute.
    text: A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForec
      astingInputsTransformationTextTransformation attribute.
    timestamp: A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMl
      ForecastingInputsTransformationTimestampTransformation attribute.
  """

  auto = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationAutoTransformation', 1)
  categorical = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationCategoricalTransformation', 2)
  numeric = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationNumericTransformation', 3)
  repeatedCategorical = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationCategoricalArrayTransformation', 4)
  repeatedNumeric = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationNumericArrayTransformation', 5)
  repeatedText = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationTextArrayTransformation', 6)
  text = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationTextTransformation', 7)
  timestamp = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationTimestampTransformation', 8)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationAutoTransformation(_messages.Message):
  r"""Training pipeline will infer the proper transformation based on the
  statistic of dataset.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationCategoricalArrayTransformation(_messages.Message):
  r"""Treats the column as categorical array and performs following
  transformation functions. * For each element in the array, convert the
  category name to a dictionary lookup index and generate an embedding for
  each index. Combine the embedding of all elements into a single embedding
  using the mean. * Empty arrays treated as an embedding of zeroes.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationCategoricalTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. * The
  categorical string as is--no change to case, punctuation, spelling, tense,
  and so on. * Convert the category name to a dictionary lookup index and
  generate an embedding for each index. * Categories that appear less than 5
  times in the training dataset are treated as the "unknown" category. The
  "unknown" category gets its own special lookup index and resulting
  embedding.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationNumericArrayTransformation(_messages.Message):
  r"""Treats the column as numerical array and performs following
  transformation functions. * All transformations for Numerical types applied
  to the average of the all elements. * The average of empty arrays is treated
  as zero.

  Fields:
    columnName: A string attribute.
    invalidValuesAllowed: If invalid values is allowed, the training pipeline
      will create a boolean feature that indicated whether the value is valid.
      Otherwise, the training pipeline will discard the input row from
      trainining data.
  """

  columnName = _messages.StringField(1)
  invalidValuesAllowed = _messages.BooleanField(2)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationNumericTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. * The
  value converted to float32. * The z_score of the value. * log(value+1) when
  the value is greater than or equal to 0. Otherwise, this transformation is
  not applied and the value is considered a missing value. * z_score of
  log(value+1) when the value is greater than or equal to 0. Otherwise, this
  transformation is not applied and the value is considered a missing value. *
  A boolean value that indicates whether the value is valid.

  Fields:
    columnName: A string attribute.
    invalidValuesAllowed: If invalid values is allowed, the training pipeline
      will create a boolean feature that indicated whether the value is valid.
      Otherwise, the training pipeline will discard the input row from
      trainining data.
  """

  columnName = _messages.StringField(1)
  invalidValuesAllowed = _messages.BooleanField(2)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationTextArrayTransformation(_messages.Message):
  r"""Treats the column as text array and performs following transformation
  functions. * Concatenate all text values in the array into a single text
  value using a space (" ") as a delimiter, and then treat the result as a
  single text value. Apply the transformations for Text columns. * Empty
  arrays treated as an empty text.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationTextTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. * The
  text as is--no change to case, punctuation, spelling, tense, and so on. *
  Tokenize text to words. Convert each words to a dictionary lookup index and
  generate an embedding for each index. Combine the embedding of all elements
  into a single embedding using the mean. * Tokenization is based on unicode
  script boundaries. * Missing values get their own lookup index and resulting
  embedding. * Stop-words receive no special treatment and are not removed.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationTimestampTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. *
  Apply the transformation functions for Numerical columns. * Determine the
  year, month, day,and weekday. Treat each value from the * timestamp as a
  Categorical column. * Invalid numerical values (for example, values that
  fall outside of a typical timestamp range, or are extreme values) receive no
  special treatment and are not removed.

  Fields:
    columnName: A string attribute.
    invalidValuesAllowed: If invalid values is allowed, the training pipeline
      will create a boolean feature that indicated whether the value is valid.
      Otherwise, the training pipeline will discard the input row from
      trainining data.
    timeFormat: The format in which that time field is expressed. The
      time_format must either be one of: * `unix-seconds` * `unix-
      milliseconds` * `unix-microseconds` * `unix-nanoseconds` (for
      respectively number of seconds, milliseconds, microseconds and
      nanoseconds since start of the Unix epoch); or be written in `strftime`
      syntax. If time_format is not set, then the default format is RFC 3339
      `date-time` format, where `time-offset` = `"Z"` (e.g.
      1985-04-12T23:20:50.52Z)
  """

  columnName = _messages.StringField(1)
  invalidValuesAllowed = _messages.BooleanField(2)
  timeFormat = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlForecastingMetadata(_messages.Message):
  r"""Model metadata specific to AutoML Forecasting.

  Fields:
    trainCostMilliNodeHours: Output only. The actual training cost of the
      model, expressed in milli node hours, i.e. 1,000 value in this field
      means 1 node hour. Guaranteed to not exceed the train budget.
  """

  trainCostMilliNodeHours = _messages.IntegerField(1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageClassification(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Image Classification
  Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
    metadata: The metadata information.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageClassificationInputs', 1)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageClassificationMetadata', 2)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageClassificationInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageClas
  sificationInputs object.

  Enums:
    ModelTypeValueValuesEnum:

  Fields:
    baseModelId: The ID of the `base` model. If it is specified, the new model
      will be trained based on the `base` model. Otherwise, the new model will
      be trained from scratch. The `base` model must be in the same Project
      and Location as the new Model to train, and have the same modelType.
    budgetMilliNodeHours: The training budget of creating this model,
      expressed in milli node hours i.e. 1,000 value in this field means 1
      node hour. The actual metadata.costMilliNodeHours will be equal or less
      than this value. If further model training ceases to provide any
      improvements, it will stop without using the full budget and the
      metadata.successfulStopReason will be `model-converged`. Note, node_hour
      = actual_hour * number_of_nodes_involved. For modelType
      `cloud`(default), the budget must be between 8,000 and 800,000 milli
      node hours, inclusive. The default value is 192,000 which represents one
      day in wall time, considering 8 nodes are used. For model types `mobile-
      tf-low-latency-1`, `mobile-tf-versatile-1`, `mobile-tf-high-accuracy-1`,
      the training budget must be between 1,000 and 100,000 milli node hours,
      inclusive. The default value is 24,000 which represents one day in wall
      time on a single node that is used.
    disableEarlyStopping: Use the entire training budget. This disables the
      early stopping feature. When false the early stopping feature is
      enabled, which means that AutoML Image Classification might stop
      training before the entire training budget has been used.
    modelType: A ModelTypeValueValuesEnum attribute.
    multiLabel: If false, a single-label (multi-class) Model will be trained
      (i.e. assuming that for each image just up to one annotation may be
      applicable). If true, a multi-label Model will be trained (i.e. assuming
      that for each image multiple annotations may be applicable).
  """

  class ModelTypeValueValuesEnum(_messages.Enum):
    r"""ModelTypeValueValuesEnum enum type.

    Values:
      MODEL_TYPE_UNSPECIFIED: Should not be set.
      CLOUD: A Model best tailored to be used within Google Cloud, and which
        cannot be exported. Default.
      MOBILE_TF_LOW_LATENCY_1: A model that, in addition to being available
        within Google Cloud, can also be exported (see
        ModelService.ExportModel) as TensorFlow or Core ML model and used on a
        mobile or edge device afterwards. Expected to have low latency, but
        may have lower prediction quality than other mobile models.
      MOBILE_TF_VERSATILE_1: A model that, in addition to being available
        within Google Cloud, can also be exported (see
        ModelService.ExportModel) as TensorFlow or Core ML model and used on a
        mobile or edge device with afterwards.
      MOBILE_TF_HIGH_ACCURACY_1: A model that, in addition to being available
        within Google Cloud, can also be exported (see
        ModelService.ExportModel) as TensorFlow or Core ML model and used on a
        mobile or edge device afterwards. Expected to have a higher latency,
        but should also have a higher prediction quality than other mobile
        models.
    """
    MODEL_TYPE_UNSPECIFIED = 0
    CLOUD = 1
    MOBILE_TF_LOW_LATENCY_1 = 2
    MOBILE_TF_VERSATILE_1 = 3
    MOBILE_TF_HIGH_ACCURACY_1 = 4

  baseModelId = _messages.StringField(1)
  budgetMilliNodeHours = _messages.IntegerField(2)
  disableEarlyStopping = _messages.BooleanField(3)
  modelType = _messages.EnumField('ModelTypeValueValuesEnum', 4)
  multiLabel = _messages.BooleanField(5)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageClassificationMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageClas
  sificationMetadata object.

  Enums:
    SuccessfulStopReasonValueValuesEnum: For successful job completions, this
      is the reason why the job has finished.

  Fields:
    costMilliNodeHours: The actual training cost of creating this model,
      expressed in milli node hours, i.e. 1,000 value in this field means 1
      node hour. Guaranteed to not exceed inputs.budgetMilliNodeHours.
    successfulStopReason: For successful job completions, this is the reason
      why the job has finished.
  """

  class SuccessfulStopReasonValueValuesEnum(_messages.Enum):
    r"""For successful job completions, this is the reason why the job has
    finished.

    Values:
      SUCCESSFUL_STOP_REASON_UNSPECIFIED: Should not be set.
      BUDGET_REACHED: The inputs.budgetMilliNodeHours had been reached.
      MODEL_CONVERGED: Further training of the Model ceased to increase its
        quality, since it already has converged.
    """
    SUCCESSFUL_STOP_REASON_UNSPECIFIED = 0
    BUDGET_REACHED = 1
    MODEL_CONVERGED = 2

  costMilliNodeHours = _messages.IntegerField(1)
  successfulStopReason = _messages.EnumField('SuccessfulStopReasonValueValuesEnum', 2)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageObjectDetection(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Image Object Detection
  Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
    metadata: The metadata information
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageObjectDetectionInputs', 1)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageObjectDetectionMetadata', 2)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageObjectDetectionInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageObje
  ctDetectionInputs object.

  Enums:
    ModelTypeValueValuesEnum:

  Fields:
    budgetMilliNodeHours: The training budget of creating this model,
      expressed in milli node hours i.e. 1,000 value in this field means 1
      node hour. The actual metadata.costMilliNodeHours will be equal or less
      than this value. If further model training ceases to provide any
      improvements, it will stop without using the full budget and the
      metadata.successfulStopReason will be `model-converged`. Note, node_hour
      = actual_hour * number_of_nodes_involved. For modelType
      `cloud`(default), the budget must be between 20,000 and 900,000 milli
      node hours, inclusive. The default value is 216,000 which represents one
      day in wall time, considering 9 nodes are used. For model types `mobile-
      tf-low-latency-1`, `mobile-tf-versatile-1`, `mobile-tf-high-accuracy-1`
      the training budget must be between 1,000 and 100,000 milli node hours,
      inclusive. The default value is 24,000 which represents one day in wall
      time on a single node that is used.
    disableEarlyStopping: Use the entire training budget. This disables the
      early stopping feature. When false the early stopping feature is
      enabled, which means that AutoML Image Object Detection might stop
      training before the entire training budget has been used.
    modelType: A ModelTypeValueValuesEnum attribute.
  """

  class ModelTypeValueValuesEnum(_messages.Enum):
    r"""ModelTypeValueValuesEnum enum type.

    Values:
      MODEL_TYPE_UNSPECIFIED: Should not be set.
      CLOUD_HIGH_ACCURACY_1: A model best tailored to be used within Google
        Cloud, and which cannot be exported. Expected to have a higher
        latency, but should also have a higher prediction quality than other
        cloud models.
      CLOUD_LOW_LATENCY_1: A model best tailored to be used within Google
        Cloud, and which cannot be exported. Expected to have a low latency,
        but may have lower prediction quality than other cloud models.
      MOBILE_TF_LOW_LATENCY_1: A model that, in addition to being available
        within Google Cloud can also be exported (see
        ModelService.ExportModel) and used on a mobile or edge device with
        TensorFlow afterwards. Expected to have low latency, but may have
        lower prediction quality than other mobile models.
      MOBILE_TF_VERSATILE_1: A model that, in addition to being available
        within Google Cloud can also be exported (see
        ModelService.ExportModel) and used on a mobile or edge device with
        TensorFlow afterwards.
      MOBILE_TF_HIGH_ACCURACY_1: A model that, in addition to being available
        within Google Cloud, can also be exported (see
        ModelService.ExportModel) and used on a mobile or edge device with
        TensorFlow afterwards. Expected to have a higher latency, but should
        also have a higher prediction quality than other mobile models.
    """
    MODEL_TYPE_UNSPECIFIED = 0
    CLOUD_HIGH_ACCURACY_1 = 1
    CLOUD_LOW_LATENCY_1 = 2
    MOBILE_TF_LOW_LATENCY_1 = 3
    MOBILE_TF_VERSATILE_1 = 4
    MOBILE_TF_HIGH_ACCURACY_1 = 5

  budgetMilliNodeHours = _messages.IntegerField(1)
  disableEarlyStopping = _messages.BooleanField(2)
  modelType = _messages.EnumField('ModelTypeValueValuesEnum', 3)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageObjectDetectionMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageObje
  ctDetectionMetadata object.

  Enums:
    SuccessfulStopReasonValueValuesEnum: For successful job completions, this
      is the reason why the job has finished.

  Fields:
    costMilliNodeHours: The actual training cost of creating this model,
      expressed in milli node hours, i.e. 1,000 value in this field means 1
      node hour. Guaranteed to not exceed inputs.budgetMilliNodeHours.
    successfulStopReason: For successful job completions, this is the reason
      why the job has finished.
  """

  class SuccessfulStopReasonValueValuesEnum(_messages.Enum):
    r"""For successful job completions, this is the reason why the job has
    finished.

    Values:
      SUCCESSFUL_STOP_REASON_UNSPECIFIED: Should not be set.
      BUDGET_REACHED: The inputs.budgetMilliNodeHours had been reached.
      MODEL_CONVERGED: Further training of the Model ceased to increase its
        quality, since it already has converged.
    """
    SUCCESSFUL_STOP_REASON_UNSPECIFIED = 0
    BUDGET_REACHED = 1
    MODEL_CONVERGED = 2

  costMilliNodeHours = _messages.IntegerField(1)
  successfulStopReason = _messages.EnumField('SuccessfulStopReasonValueValuesEnum', 2)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageSegmentation(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Image Segmentation
  Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
    metadata: The metadata information.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageSegmentationInputs', 1)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageSegmentationMetadata', 2)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageSegmentationInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageSegm
  entationInputs object.

  Enums:
    ModelTypeValueValuesEnum:

  Fields:
    baseModelId: The ID of the `base` model. If it is specified, the new model
      will be trained based on the `base` model. Otherwise, the new model will
      be trained from scratch. The `base` model must be in the same Project
      and Location as the new Model to train, and have the same modelType.
    budgetMilliNodeHours: The training budget of creating this model,
      expressed in milli node hours i.e. 1,000 value in this field means 1
      node hour. The actual metadata.costMilliNodeHours will be equal or less
      than this value. If further model training ceases to provide any
      improvements, it will stop without using the full budget and the
      metadata.successfulStopReason will be `model-converged`. Note, node_hour
      = actual_hour * number_of_nodes_involved. Or actaul_wall_clock_hours =
      train_budget_milli_node_hours / (number_of_nodes_involved * 1000) For
      modelType `cloud-high-accuracy-1`(default), the budget must be between
      20,000 and 2,000,000 milli node hours, inclusive. The default value is
      192,000 which represents one day in wall time (1000 milli * 24 hours * 8
      nodes).
    modelType: A ModelTypeValueValuesEnum attribute.
  """

  class ModelTypeValueValuesEnum(_messages.Enum):
    r"""ModelTypeValueValuesEnum enum type.

    Values:
      MODEL_TYPE_UNSPECIFIED: Should not be set.
      CLOUD_HIGH_ACCURACY_1: A model to be used via prediction calls to uCAIP
        API. Expected to have a higher latency, but should also have a higher
        prediction quality than other models.
      CLOUD_LOW_ACCURACY_1: A model to be used via prediction calls to uCAIP
        API. Expected to have a lower latency but relatively lower prediction
        quality.
    """
    MODEL_TYPE_UNSPECIFIED = 0
    CLOUD_HIGH_ACCURACY_1 = 1
    CLOUD_LOW_ACCURACY_1 = 2

  baseModelId = _messages.StringField(1)
  budgetMilliNodeHours = _messages.IntegerField(2)
  modelType = _messages.EnumField('ModelTypeValueValuesEnum', 3)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageSegmentationMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlImageSegm
  entationMetadata object.

  Enums:
    SuccessfulStopReasonValueValuesEnum: For successful job completions, this
      is the reason why the job has finished.

  Fields:
    costMilliNodeHours: The actual training cost of creating this model,
      expressed in milli node hours, i.e. 1,000 value in this field means 1
      node hour. Guaranteed to not exceed inputs.budgetMilliNodeHours.
    successfulStopReason: For successful job completions, this is the reason
      why the job has finished.
  """

  class SuccessfulStopReasonValueValuesEnum(_messages.Enum):
    r"""For successful job completions, this is the reason why the job has
    finished.

    Values:
      SUCCESSFUL_STOP_REASON_UNSPECIFIED: Should not be set.
      BUDGET_REACHED: The inputs.budgetMilliNodeHours had been reached.
      MODEL_CONVERGED: Further training of the Model ceased to increase its
        quality, since it already has converged.
    """
    SUCCESSFUL_STOP_REASON_UNSPECIFIED = 0
    BUDGET_REACHED = 1
    MODEL_CONVERGED = 2

  costMilliNodeHours = _messages.IntegerField(1)
  successfulStopReason = _messages.EnumField('SuccessfulStopReasonValueValuesEnum', 2)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTables(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Tables Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
    metadata: The metadata information.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputs', 1)
  metadata = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesMetadata', 2)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputs(_messages.Message):
  r"""A
  GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputs
  object.

  Fields:
    disableEarlyStopping: Use the entire training budget. This disables the
      early stopping feature. By default, the early stopping feature is
      enabled, which means that AutoML Tables might stop training before the
      entire training budget has been used.
    exportEvaluatedDataItemsConfig: Configuration for exporting test set
      predictions to a BigQuery table. If this configuration is absent, then
      the export is not performed.
    optimizationObjective: Objective function the model is optimizing towards.
      The training process creates a model that maximizes/minimizes the value
      of the objective function over the validation set. The supported
      optimization objectives depend on the prediction type. If the field is
      not set, a default objective function is used. classification (binary):
      "maximize-au-roc" (default) - Maximize the area under the receiver
      operating characteristic (ROC) curve. "minimize-log-loss" - Minimize log
      loss. "maximize-au-prc" - Maximize the area under the precision-recall
      curve. "maximize-precision-at-recall" - Maximize precision for a
      specified recall value. "maximize-recall-at-precision" - Maximize recall
      for a specified precision value. classification (multi-class):
      "minimize-log-loss" (default) - Minimize log loss. regression:
      "minimize-rmse" (default) - Minimize root-mean-squared error (RMSE).
      "minimize-mae" - Minimize mean-absolute error (MAE). "minimize-rmsle" -
      Minimize root-mean-squared log error (RMSLE).
    optimizationObjectivePrecisionValue: Required when optimization_objective
      is "maximize-recall-at-precision". Must be between 0 and 1, inclusive.
    optimizationObjectiveRecallValue: Required when optimization_objective is
      "maximize-precision-at-recall". Must be between 0 and 1, inclusive.
    predictionType: The type of prediction the Model is to produce.
      "classification" - Predict one out of multiple target values is picked
      for each row. "regression" - Predict a value based on its relation to
      other values. This type is available only to columns that contain
      semantically numeric values, i.e. integers or floating point number,
      even if stored as e.g. strings.
    targetColumn: The column name of the target column that the model is to
      predict.
    trainBudgetMilliNodeHours: Required. The train budget of creating this
      model, expressed in milli node hours i.e. 1,000 value in this field
      means 1 node hour. The training cost of the model will not exceed this
      budget. The final cost will be attempted to be close to the budget,
      though may end up being (even) noticeably smaller - at the backend's
      discretion. This especially may happen when further model training
      ceases to provide any improvements. If the budget is set to a value
      known to be insufficient to train a model for the given dataset, the
      training won't be attempted and will error. The train budget must be
      between 1,000 and 72,000 milli node hours, inclusive.
    transformations: Each transformation will apply transform function to
      given input column. And the result will be used for training. When
      creating transformation for BigQuery Struct column, the column should be
      flattened using "." as the delimiter.
    weightColumnName: Column name that should be used as the weight column.
      Higher values in this column give more importance to the row during
      model training. The column must have numeric values between 0 and 10000
      inclusively; 0 means the row is ignored for training. If weight column
      field is not set, then all rows are assumed to have equal weight of 1.
  """

  disableEarlyStopping = _messages.BooleanField(1)
  exportEvaluatedDataItemsConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionExportEvaluatedDataItemsConfig', 2)
  optimizationObjective = _messages.StringField(3)
  optimizationObjectivePrecisionValue = _messages.FloatField(4, variant=_messages.Variant.FLOAT)
  optimizationObjectiveRecallValue = _messages.FloatField(5, variant=_messages.Variant.FLOAT)
  predictionType = _messages.StringField(6)
  targetColumn = _messages.StringField(7)
  trainBudgetMilliNodeHours = _messages.IntegerField(8)
  transformations = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformation', 9, repeated=True)
  weightColumnName = _messages.StringField(10)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformation(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInp
  utsTransformation object.

  Fields:
    auto: A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTable
      sInputsTransformationAutoTransformation attribute.
    categorical: A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAuto
      MlTablesInputsTransformationCategoricalTransformation attribute.
    numeric: A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTa
      blesInputsTransformationNumericTransformation attribute.
    repeatedCategorical: A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefini
      tionAutoMlTablesInputsTransformationCategoricalArrayTransformation
      attribute.
    repeatedNumeric: A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinition
      AutoMlTablesInputsTransformationNumericArrayTransformation attribute.
    repeatedText: A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAut
      oMlTablesInputsTransformationTextArrayTransformation attribute.
    text: A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTable
      sInputsTransformationTextTransformation attribute.
    timestamp: A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMl
      TablesInputsTransformationTimestampTransformation attribute.
  """

  auto = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationAutoTransformation', 1)
  categorical = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationCategoricalTransformation', 2)
  numeric = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationNumericTransformation', 3)
  repeatedCategorical = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationCategoricalArrayTransformation', 4)
  repeatedNumeric = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationNumericArrayTransformation', 5)
  repeatedText = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTextArrayTransformation', 6)
  text = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTextTransformation', 7)
  timestamp = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTimestampTransformation', 8)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationAutoTransformation(_messages.Message):
  r"""Training pipeline will infer the proper transformation based on the
  statistic of dataset.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationCategoricalArrayTransformation(_messages.Message):
  r"""Treats the column as categorical array and performs following
  transformation functions. * For each element in the array, convert the
  category name to a dictionary lookup index and generate an embedding for
  each index. Combine the embedding of all elements into a single embedding
  using the mean. * Empty arrays treated as an embedding of zeroes.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationCategoricalTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. * The
  categorical string as is--no change to case, punctuation, spelling, tense,
  and so on. * Convert the category name to a dictionary lookup index and
  generate an embedding for each index. * Categories that appear less than 5
  times in the training dataset are treated as the "unknown" category. The
  "unknown" category gets its own special lookup index and resulting
  embedding.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationNumericArrayTransformation(_messages.Message):
  r"""Treats the column as numerical array and performs following
  transformation functions. * All transformations for Numerical types applied
  to the average of the all elements. * The average of empty arrays is treated
  as zero.

  Fields:
    columnName: A string attribute.
    invalidValuesAllowed: If invalid values is allowed, the training pipeline
      will create a boolean feature that indicated whether the value is valid.
      Otherwise, the training pipeline will discard the input row from
      trainining data.
  """

  columnName = _messages.StringField(1)
  invalidValuesAllowed = _messages.BooleanField(2)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationNumericTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. * The
  value converted to float32. * The z_score of the value. * log(value+1) when
  the value is greater than or equal to 0. Otherwise, this transformation is
  not applied and the value is considered a missing value. * z_score of
  log(value+1) when the value is greater than or equal to 0. Otherwise, this
  transformation is not applied and the value is considered a missing value. *
  A boolean value that indicates whether the value is valid.

  Fields:
    columnName: A string attribute.
    invalidValuesAllowed: If invalid values is allowed, the training pipeline
      will create a boolean feature that indicated whether the value is valid.
      Otherwise, the training pipeline will discard the input row from
      trainining data.
  """

  columnName = _messages.StringField(1)
  invalidValuesAllowed = _messages.BooleanField(2)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTextArrayTransformation(_messages.Message):
  r"""Treats the column as text array and performs following transformation
  functions. * Concatenate all text values in the array into a single text
  value using a space (" ") as a delimiter, and then treat the result as a
  single text value. Apply the transformations for Text columns. * Empty
  arrays treated as an empty text.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTextTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. * The
  text as is--no change to case, punctuation, spelling, tense, and so on. *
  Tokenize text to words. Convert each words to a dictionary lookup index and
  generate an embedding for each index. Combine the embedding of all elements
  into a single embedding using the mean. * Tokenization is based on unicode
  script boundaries. * Missing values get their own lookup index and resulting
  embedding. * Stop-words receive no special treatment and are not removed.

  Fields:
    columnName: A string attribute.
  """

  columnName = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTimestampTransformation(_messages.Message):
  r"""Training pipeline will perform following transformation functions. *
  Apply the transformation functions for Numerical columns. * Determine the
  year, month, day,and weekday. Treat each value from the * timestamp as a
  Categorical column. * Invalid numerical values (for example, values that
  fall outside of a typical timestamp range, or are extreme values) receive no
  special treatment and are not removed.

  Fields:
    columnName: A string attribute.
    invalidValuesAllowed: If invalid values is allowed, the training pipeline
      will create a boolean feature that indicated whether the value is valid.
      Otherwise, the training pipeline will discard the input row from
      trainining data.
    timeFormat: The format in which that time field is expressed. The
      time_format must either be one of: * `unix-seconds` * `unix-
      milliseconds` * `unix-microseconds` * `unix-nanoseconds` (for
      respectively number of seconds, milliseconds, microseconds and
      nanoseconds since start of the Unix epoch); or be written in `strftime`
      syntax. If time_format is not set, then the default format is RFC 3339
      `date-time` format, where `time-offset` = `"Z"` (e.g.
      1985-04-12T23:20:50.52Z)
  """

  columnName = _messages.StringField(1)
  invalidValuesAllowed = _messages.BooleanField(2)
  timeFormat = _messages.StringField(3)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTablesMetadata(_messages.Message):
  r"""Model metadata specific to AutoML Tables.

  Fields:
    trainCostMilliNodeHours: Output only. The actual training cost of the
      model, expressed in milli node hours, i.e. 1,000 value in this field
      means 1 node hour. Guaranteed to not exceed the train budget.
  """

  trainCostMilliNodeHours = _messages.IntegerField(1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTextClassification(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Text Classification
  Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTextClassificationInputs', 1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTextClassificationInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTextClass
  ificationInputs object.

  Fields:
    multiLabel: A boolean attribute.
  """

  multiLabel = _messages.BooleanField(1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTextExtraction(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Text Extraction Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTextExtractionInputs', 1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTextExtractionInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTextExtra
  ctionInputs object.
  """



class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTextSentiment(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Text Sentiment Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTextSentimentInputs', 1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTextSentimentInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlTextSenti
  mentInputs object.

  Fields:
    sentimentMax: A sentiment is expressed as an integer ordinal, where higher
      value means a more positive sentiment. The range of sentiments that will
      be used is between 0 and sentimentMax (inclusive on both ends), and all
      the values in the range must be represented in the dataset before a
      model can be created. Only the Annotations with this sentimentMax will
      be used for training. sentimentMax value must be between 1 and 10
      (inclusive).
  """

  sentimentMax = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlVideoActionRecognition(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Video Action Recognition
  Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlVideoActionRecognitionInputs', 1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlVideoActionRecognitionInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlVideoActi
  onRecognitionInputs object.

  Enums:
    ModelTypeValueValuesEnum:

  Fields:
    modelType: A ModelTypeValueValuesEnum attribute.
  """

  class ModelTypeValueValuesEnum(_messages.Enum):
    r"""ModelTypeValueValuesEnum enum type.

    Values:
      MODEL_TYPE_UNSPECIFIED: Should not be set.
      CLOUD: A model best tailored to be used within Google Cloud, and which c
        annot be exported. Default.
      MOBILE_VERSATILE_1: A model that, in addition to being available within
        Google Cloud, can also be exported (see ModelService.ExportModel) as a
        TensorFlow or TensorFlow Lite model and used on a mobile or edge
        device afterwards.
    """
    MODEL_TYPE_UNSPECIFIED = 0
    CLOUD = 1
    MOBILE_VERSATILE_1 = 2

  modelType = _messages.EnumField('ModelTypeValueValuesEnum', 1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlVideoClassification(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Video Classification
  Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlVideoClassificationInputs', 1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlVideoClassificationInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlVideoClas
  sificationInputs object.

  Enums:
    ModelTypeValueValuesEnum:

  Fields:
    modelType: A ModelTypeValueValuesEnum attribute.
  """

  class ModelTypeValueValuesEnum(_messages.Enum):
    r"""ModelTypeValueValuesEnum enum type.

    Values:
      MODEL_TYPE_UNSPECIFIED: Should not be set.
      CLOUD: A model best tailored to be used within Google Cloud, and which
        cannot be exported. Default.
      MOBILE_VERSATILE_1: A model that, in addition to being available within
        Google Cloud, can also be exported (see ModelService.ExportModel) as a
        TensorFlow or TensorFlow Lite model and used on a mobile or edge
        device afterwards.
    """
    MODEL_TYPE_UNSPECIFIED = 0
    CLOUD = 1
    MOBILE_VERSATILE_1 = 2

  modelType = _messages.EnumField('ModelTypeValueValuesEnum', 1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlVideoObjectTracking(_messages.Message):
  r"""A TrainingJob that trains and uploads an AutoML Video ObjectTracking
  Model.

  Fields:
    inputs: The input parameters of this TrainingJob.
  """

  inputs = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlVideoObjectTrackingInputs', 1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlVideoObjectTrackingInputs(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionAutoMlVideoObje
  ctTrackingInputs object.

  Enums:
    ModelTypeValueValuesEnum:

  Fields:
    modelType: A ModelTypeValueValuesEnum attribute.
  """

  class ModelTypeValueValuesEnum(_messages.Enum):
    r"""ModelTypeValueValuesEnum enum type.

    Values:
      MODEL_TYPE_UNSPECIFIED: Should not be set.
      CLOUD: A model best tailored to be used within Google Cloud, and which c
        annot be exported. Default.
      MOBILE_VERSATILE_1: A model that, in addition to being available within
        Google Cloud, can also be exported (see ModelService.ExportModel) as a
        TensorFlow or TensorFlow Lite model and used on a mobile or edge
        device afterwards.
      MOBILE_CORAL_VERSATILE_1: A versatile model that is meant to be exported
        (see ModelService.ExportModel) and used on a Google Coral device.
      MOBILE_CORAL_LOW_LATENCY_1: A model that trades off quality for low
        latency, to be exported (see ModelService.ExportModel) and used on a
        Google Coral device.
      MOBILE_JETSON_VERSATILE_1: A versatile model that is meant to be
        exported (see ModelService.ExportModel) and used on an NVIDIA Jetson
        device.
      MOBILE_JETSON_LOW_LATENCY_1: A model that trades off quality for low
        latency, to be exported (see ModelService.ExportModel) and used on an
        NVIDIA Jetson device.
    """
    MODEL_TYPE_UNSPECIFIED = 0
    CLOUD = 1
    MOBILE_VERSATILE_1 = 2
    MOBILE_CORAL_VERSATILE_1 = 3
    MOBILE_CORAL_LOW_LATENCY_1 = 4
    MOBILE_JETSON_VERSATILE_1 = 5
    MOBILE_JETSON_LOW_LATENCY_1 = 6

  modelType = _messages.EnumField('ModelTypeValueValuesEnum', 1)


class GoogleCloudAiplatformV1beta1SchemaTrainingjobDefinitionExportEvaluatedDataItemsConfig(_messages.Message):
  r"""Configuration for exporting test set predictions to a BigQuery table.

  Fields:
    destinationBigqueryUri: URI of desired destination BigQuery table.
      Expected format: bq://:: If not specified, then results are exported to
      the following auto-created BigQuery table:
      :export_evaluated_examples__.evaluated_examples
    overrideExistingTable: If true and an export destination is specified,
      then the contents of the destination are overwritten. Otherwise, if the
      export destination already exists, then the export operation fails.
  """

  destinationBigqueryUri = _messages.StringField(1)
  overrideExistingTable = _messages.BooleanField(2)


class GoogleCloudAiplatformV1beta1SchemaVertex(_messages.Message):
  r"""A vertex represents a 2D point in the image. NOTE: the normalized vertex
  coordinates are relative to the original image and range from 0 to 1.

  Fields:
    x: X coordinate.
    y: Y coordinate.
  """

  x = _messages.FloatField(1)
  y = _messages.FloatField(2)


class GoogleCloudAiplatformV1beta1SchemaVideoActionRecognitionAnnotation(_messages.Message):
  r"""Annotation details specific to video action recognition.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    timeSegment: This Annotation applies to the time period represented by the
      TimeSegment. If it's not set, the Annotation applies to the whole video.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  timeSegment = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTimeSegment', 3)


class GoogleCloudAiplatformV1beta1SchemaVideoClassificationAnnotation(_messages.Message):
  r"""Annotation details specific to video classification.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    timeSegment: This Annotation applies to the time period represented by the
      TimeSegment. If it's not set, the Annotation applies to the whole video.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  timeSegment = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaTimeSegment', 3)


class GoogleCloudAiplatformV1beta1SchemaVideoDataItem(_messages.Message):
  r"""Payload of Video DataItem.

  Fields:
    gcsUri: Required. Google Cloud Storage URI points to the original video in
      user's bucket. The video is up to 50 GB in size and up to 3 hour in
      duration.
    mimeType: Output only. The mime type of the content of the video. Only the
      videos in below listed mime types are supported. Supported mime_type: -
      video/mp4 - video/avi - video/quicktime
  """

  gcsUri = _messages.StringField(1)
  mimeType = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaVideoDatasetMetadata(_messages.Message):
  r"""The metadata of Datasets that contain Video DataItems.

  Fields:
    dataItemSchemaUri: Points to a YAML file stored on Google Cloud Storage
      describing payload of the Video DataItems that belong to this Dataset.
    gcsBucket: Google Cloud Storage Bucket name that contains the blob data of
      this Dataset.
  """

  dataItemSchemaUri = _messages.StringField(1)
  gcsBucket = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1SchemaVideoObjectTrackingAnnotation(_messages.Message):
  r"""Annotation details specific to video object tracking.

  Fields:
    annotationSpecId: The resource Id of the AnnotationSpec that this
      Annotation pertains to.
    displayName: The display name of the AnnotationSpec that this Annotation
      pertains to.
    instanceId: The instance of the object, expressed as a positive integer.
      Used to track the same object across different frames.
    timeOffset: A time (frame) of a video to which this annotation pertains.
      Represented as the duration since the video's start.
    xMax: The rightmost coordinate of the bounding box.
    xMin: The leftmost coordinate of the bounding box.
    yMax: The bottommost coordinate of the bounding box.
    yMin: The topmost coordinate of the bounding box.
  """

  annotationSpecId = _messages.StringField(1)
  displayName = _messages.StringField(2)
  instanceId = _messages.IntegerField(3)
  timeOffset = _messages.StringField(4)
  xMax = _messages.FloatField(5)
  xMin = _messages.FloatField(6)
  yMax = _messages.FloatField(7)
  yMin = _messages.FloatField(8)


class GoogleCloudAiplatformV1beta1SchemaVisualInspectionClassificationLabelSavedQueryMetadata(_messages.Message):
  r"""A GoogleCloudAiplatformV1beta1SchemaVisualInspectionClassificationLabelS
  avedQueryMetadata object.

  Fields:
    multiLabel: Whether or not the classification label is multi_label.
  """

  multiLabel = _messages.BooleanField(1)


class GoogleCloudAiplatformV1beta1SchemaVisualInspectionMaskSavedQueryMetadata(_messages.Message):
  r"""A
  GoogleCloudAiplatformV1beta1SchemaVisualInspectionMaskSavedQueryMetadata
  object.

  Fields:
    colorMap: The mapping between color and AnnotationSpec for this
      SavedQuery.
  """

  colorMap = _messages.MessageField('GoogleCloudAiplatformV1beta1SchemaAnnotationSpecColor', 1, repeated=True)


class GoogleCloudAiplatformV1beta1SmoothGradConfig(_messages.Message):
  r"""Config for SmoothGrad approximation of gradients. When enabled, the
  gradients are approximated by averaging the gradients from noisy samples in
  the vicinity of the inputs. Adding noise can help improve the computed
  gradients. Refer to this paper for more details:
  https://arxiv.org/pdf/1706.03825.pdf

  Fields:
    featureNoiseSigma: This is similar to noise_sigma, but provides additional
      flexibility. A separate noise sigma can be provided for each feature,
      which is useful if their distributions are different. No noise is added
      to features that are not set. If this field is unset, noise_sigma will
      be used for all features.
    noiseSigma: This is a single float value and will be used to add noise to
      all the features. Use this field when all features are normalized to
      have the same distribution: scale to range [0, 1], [-1, 1] or z-scoring,
      where features are normalized to have 0-mean and 1-variance. For more
      details about normalization: https://tinyurl.com/dgc-normalization. For
      best results the recommended value is about 10% - 20% of the standard
      deviation of the input feature. Refer to section 3.2 of the SmoothGrad
      paper: https://arxiv.org/pdf/1706.03825.pdf. Defaults to 0.1. If the
      distribution is different per feature, set feature_noise_sigma instead
      for each feature.
    noisySampleCount: The number of gradient samples to use for approximation.
      The higher this number, the more accurate the gradient is, but the
      runtime complexity increases by this factor as well. Valid range of its
      value is [1, 50]. Defaults to 3.
  """

  featureNoiseSigma = _messages.MessageField('GoogleCloudAiplatformV1beta1FeatureNoiseSigma', 1)
  noiseSigma = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  noisySampleCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1SpecialistPool(_messages.Message):
  r"""SpecialistPool represents customers' own workforce to work on their data
  labeling jobs. It includes a group of specialist managers who are
  responsible for managing the labelers in this pool as well as customers'
  data labeling jobs associated with this pool. Customers create specialist
  pool as well as start data labeling jobs on Cloud, managers and labelers
  work with the jobs using CrowdCompute console.

  Fields:
    displayName: Required. The user-defined name of the SpecialistPool. The
      name can be up to 128 characters long and can be consist of any UTF-8
      characters. This field should be unique on project-level.
    name: Required. The resource name of the SpecialistPool.
    pendingDataLabelingJobs: Output only. The resource name of the pending
      data labeling jobs.
    specialistManagerEmails: The email addresses of the specialists in the
      SpecialistPool.
    specialistManagersCount: Output only. The number of Specialists in this
      SpecialistPool.
  """

  displayName = _messages.StringField(1)
  name = _messages.StringField(2)
  pendingDataLabelingJobs = _messages.StringField(3, repeated=True)
  specialistManagerEmails = _messages.StringField(4, repeated=True)
  specialistManagersCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class GoogleCloudAiplatformV1beta1UndeployModelOperationMetadata(_messages.Message):
  r"""Runtime operation information for EndpointService.UndeployModel.

  Fields:
    genericMetadata: The operation generic information.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1UndeployModelResponse(_messages.Message):
  r"""Response message for EndpointService.UndeployModel."""


class GoogleCloudAiplatformV1beta1UpdateSpecialistPoolOperationMetadata(_messages.Message):
  r"""Runtime operation metadata for
  SpecialistPoolService.UpdateSpecialistPool.

  Fields:
    genericMetadata: The operation generic information.
    specialistPool: Output only. The name of the SpecialistPool to which the
      specialists are being added. Format: `projects/{project_id}/locations/{l
      ocation_id}/specialistPools/{specialist_pool}`
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)
  specialistPool = _messages.StringField(2)


class GoogleCloudAiplatformV1beta1UploadModelOperationMetadata(_messages.Message):
  r"""Details of ModelService.UploadModel operation.

  Fields:
    genericMetadata: The common part of the operation metadata.
  """

  genericMetadata = _messages.MessageField('GoogleCloudAiplatformV1beta1GenericOperationMetadata', 1)


class GoogleCloudAiplatformV1beta1UploadModelResponse(_messages.Message):
  r"""Response message of ModelService.UploadModel operation.

  Fields:
    model: The name of the uploaded Model resource. Format:
      `projects/{project}/locations/{location}/models/{model}`
  """

  model = _messages.StringField(1)


class GoogleCloudAiplatformV1beta1XraiAttribution(_messages.Message):
  r"""An explanation method that redistributes Integrated Gradients
  attributions to segmented regions, taking advantage of the model's fully
  differentiable structure. Refer to this paper for more details:
  https://arxiv.org/abs/1906.02825 Supported only by image Models.

  Fields:
    smoothGradConfig: Config for SmoothGrad approximation of gradients. When
      enabled, the gradients are approximated by averaging the gradients from
      noisy samples in the vicinity of the inputs. Adding noise can help
      improve the computed gradients. Refer to this paper for more details:
      https://arxiv.org/pdf/1706.03825.pdf
    stepCount: Required. The number of steps for approximating the path
      integral. A good value to start is 50 and gradually increase until the
      sum to diff property is met within the desired error range. Valid range
      of its value is [1, 100], inclusively.
  """

  smoothGradConfig = _messages.MessageField('GoogleCloudAiplatformV1beta1SmoothGradConfig', 1)
  stepCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudLocationListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('GoogleCloudLocationLocation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudLocationLocation(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class GoogleLongrunningCancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleLongrunningWaitOperationRequest(_messages.Message):
  r"""The request message for Operations.WaitOperation.

  Fields:
    timeout: The maximum duration to wait before timing out. If left blank,
      the wait will be at most the time permitted by the underlying HTTP/RPC
      protocol. If RPC context deadline is also specified, the shorter one
      will be used.
  """

  timeout = _messages.StringField(1)


class GoogleProtobufEmpty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GoogleTypeColor(_messages.Message):
  r"""Represents a color in the RGBA color space. This representation is
  designed for simplicity of conversion to/from color representations in
  various languages over compactness; for example, the fields of this
  representation can be trivially provided to the constructor of
  "java.awt.Color" in Java; it can also be trivially provided to UIColor's
  "+colorWithRed:green:blue:alpha" method in iOS; and, with just a little
  work, it can be easily formatted into a CSS "rgba()" string in JavaScript,
  as well. Note: this proto does not carry information about the absolute
  color space that should be used to interpret the RGB value (e.g. sRGB, Adobe
  RGB, DCI-P3, BT.2020, etc.). By default, applications SHOULD assume the sRGB
  color space. Note: when color equality needs to be decided, implementations,
  unless documented otherwise, will treat two colors to be equal if all their
  red, green, blue and alpha values each differ by at most 1e-5. Example
  (Java): import com.google.type.Color; // ... public static java.awt.Color
  fromProto(Color protocolor) { float alpha = protocolor.hasAlpha() ?
  protocolor.getAlpha().getValue() : 1.0; return new java.awt.Color(
  protocolor.getRed(), protocolor.getGreen(), protocolor.getBlue(), alpha); }
  public static Color toProto(java.awt.Color color) { float red = (float)
  color.getRed(); float green = (float) color.getGreen(); float blue = (float)
  color.getBlue(); float denominator = 255.0; Color.Builder resultBuilder =
  Color .newBuilder() .setRed(red / denominator) .setGreen(green /
  denominator) .setBlue(blue / denominator); int alpha = color.getAlpha(); if
  (alpha != 255) { result.setAlpha( FloatValue .newBuilder()
  .setValue(((float) alpha) / denominator) .build()); } return
  resultBuilder.build(); } // ... Example (iOS / Obj-C): // ... static
  UIColor* fromProto(Color* protocolor) { float red = [protocolor red]; float
  green = [protocolor green]; float blue = [protocolor blue]; FloatValue*
  alpha_wrapper = [protocolor alpha]; float alpha = 1.0; if (alpha_wrapper !=
  nil) { alpha = [alpha_wrapper value]; } return [UIColor colorWithRed:red
  green:green blue:blue alpha:alpha]; } static Color* toProto(UIColor* color)
  { CGFloat red, green, blue, alpha; if (![color getRed:&red green:&green
  blue:&blue alpha:&alpha]) { return nil; } Color* result = [[Color alloc]
  init]; [result setRed:red]; [result setGreen:green]; [result setBlue:blue];
  if (alpha <= 0.9999) { [result setAlpha:floatWrapperWithValue(alpha)]; }
  [result autorelease]; return result; } // ... Example (JavaScript): // ...
  var protoToCssColor = function(rgb_color) { var redFrac = rgb_color.red ||
  0.0; var greenFrac = rgb_color.green || 0.0; var blueFrac = rgb_color.blue
  || 0.0; var red = Math.floor(redFrac * 255); var green =
  Math.floor(greenFrac * 255); var blue = Math.floor(blueFrac * 255); if
  (!('alpha' in rgb_color)) { return rgbToCssColor_(red, green, blue); } var
  alphaFrac = rgb_color.alpha.value || 0.0; var rgbParams = [red, green,
  blue].join(','); return ['rgba(', rgbParams, ',', alphaFrac, ')'].join('');
  }; var rgbToCssColor_ = function(red, green, blue) { var rgbNumber = new
  Number((red << 16) | (green << 8) | blue); var hexString =
  rgbNumber.toString(16); var missingZeros = 6 - hexString.length; var
  resultBuilder = ['#']; for (var i = 0; i < missingZeros; i++) {
  resultBuilder.push('0'); } resultBuilder.push(hexString); return
  resultBuilder.join(''); }; // ...

  Fields:
    alpha: The fraction of this color that should be applied to the pixel.
      That is, the final pixel color is defined by the equation: pixel color =
      alpha * (this color) + (1.0 - alpha) * (background color) This means
      that a value of 1.0 corresponds to a solid color, whereas a value of 0.0
      corresponds to a completely transparent color. This uses a wrapper
      message rather than a simple float scalar so that it is possible to
      distinguish between a default value and the value being unset. If
      omitted, this color object is to be rendered as a solid color (as if the
      alpha value had been explicitly given with a value of 1.0).
    blue: The amount of blue in the color as a value in the interval [0, 1].
    green: The amount of green in the color as a value in the interval [0, 1].
    red: The amount of red in the color as a value in the interval [0, 1].
  """

  alpha = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  blue = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  green = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  red = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class GoogleTypeMoney(_messages.Message):
  r"""Represents an amount of money with its currency type.

  Fields:
    currencyCode: The three-letter currency code defined in ISO 4217.
    nanos: Number of nano (10^-9) units of the amount. The value must be
      between -999,999,999 and +999,999,999 inclusive. If `units` is positive,
      `nanos` must be positive or zero. If `units` is zero, `nanos` can be
      positive, zero, or negative. If `units` is negative, `nanos` must be
      negative or zero. For example $-1.75 is represented as `units`=-1 and
      `nanos`=-750,000,000.
    units: The whole units of the amount. For example if `currencyCode` is
      `"USD"`, then 1 unit is one US dollar.
  """

  currencyCode = _messages.StringField(1)
  nanos = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  units = _messages.IntegerField(3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
