"""Generated message classes for spanner version v1alpha.

Cloud Spanner is a managed, mission-critical, globally consistent and scalable
relational database service.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'spanner'


class BackupInfo(_messages.Message):
  r"""Information about a backup.

  Fields:
    backup: Name of the backup.
    createTime: The backup contains an externally consistent copy of
      `source_database` at the timestamp specified by `create_time`.
    sourceDatabase: Name of the database the backup was created from.
  """

  backup = _messages.StringField(1)
  createTime = _messages.StringField(2)
  sourceDatabase = _messages.StringField(3)


class CreateBackupMetadata(_messages.Message):
  r"""Metadata type for the operation returned by CreateBackup.

  Fields:
    cancelTime: The time at which cancellation of this operation was received.
      Operations.CancelOperation starts asynchronous cancellation on a long-
      running operation. The server makes a best effort to cancel the
      operation, but success is not guaranteed. Clients can use
      Operations.GetOperation or other methods to check whether the
      cancellation succeeded or whether the operation completed despite
      cancellation. On successful cancellation, the operation is not deleted;
      instead, it becomes an operation with an Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    database: The name of the database the backup is created from.
    name: The name of the backup being created.
    progress: The progress of the CreateBackup operation.
  """

  cancelTime = _messages.StringField(1)
  database = _messages.StringField(2)
  name = _messages.StringField(3)
  progress = _messages.MessageField('OperationProgress', 4)


class CreateDatabaseMetadata(_messages.Message):
  r"""Metadata type for the operation returned by CreateDatabase.

  Fields:
    database: The database being created.
  """

  database = _messages.StringField(1)


class CreateInstanceMetadata(_messages.Message):
  r"""Metadata type for the operation returned by CreateInstance.

  Fields:
    cancelTime: The time at which this operation was cancelled. If set, this
      operation is in the process of undoing itself (which is guaranteed to
      succeed) and cannot be cancelled again.
    endTime: The time at which this operation failed or was completed
      successfully.
    instance: The instance being created.
    startTime: The time at which the CreateInstance request was received.
  """

  cancelTime = _messages.StringField(1)
  endTime = _messages.StringField(2)
  instance = _messages.MessageField('Instance', 3)
  startTime = _messages.StringField(4)


class Instance(_messages.Message):
  r"""An isolated set of Cloud Spanner resources on which databases can be
  hosted.

  Enums:
    StateValueValuesEnum: Output only. The current instance state. For
      CreateInstance, the state must be either omitted or set to `CREATING`.
      For UpdateInstance, the state must be either omitted or set to `READY`.

  Messages:
    LabelsValue: Cloud Labels are a flexible and lightweight mechanism for
      organizing cloud resources into groups that reflect a customer's
      organizational needs and deployment strategies. Cloud Labels can be used
      to filter collections of resources. They can be used to control how
      resource metrics are aggregated. And they can be used as arguments to
      policy management rules (e.g. route, firewall, load balancing, etc.). *
      Label keys must be between 1 and 63 characters long and must conform to
      the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`. * Label
      values must be between 0 and 63 characters long and must conform to the
      regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`. * No more than 64
      labels can be associated with a given resource. See
      https://goo.gl/xmQnxf for more information on and examples of labels. If
      you plan to use labels in your own code, please note that additional
      characters may be allowed in the future. And so you are advised to use
      an internal label representation, such as JSON, which doesn't rely upon
      specific characters being disallowed. For example, representing labels
      as the string: name + "_" + value would prove problematic if we were to
      allow "_" in a future release.

  Fields:
    config: Required. The name of the instance's configuration. Values are of
      the form `projects//instanceConfigs/`. See also InstanceConfig and
      ListInstanceConfigs.
    displayName: Required. The descriptive name for this instance as it
      appears in UIs. Must be unique per project and between 4 and 30
      characters in length.
    endpointUris: Deprecated. This field is not populated.
    labels: Cloud Labels are a flexible and lightweight mechanism for
      organizing cloud resources into groups that reflect a customer's
      organizational needs and deployment strategies. Cloud Labels can be used
      to filter collections of resources. They can be used to control how
      resource metrics are aggregated. And they can be used as arguments to
      policy management rules (e.g. route, firewall, load balancing, etc.). *
      Label keys must be between 1 and 63 characters long and must conform to
      the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`. * Label
      values must be between 0 and 63 characters long and must conform to the
      regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`. * No more than 64
      labels can be associated with a given resource. See
      https://goo.gl/xmQnxf for more information on and examples of labels. If
      you plan to use labels in your own code, please note that additional
      characters may be allowed in the future. And so you are advised to use
      an internal label representation, such as JSON, which doesn't rely upon
      specific characters being disallowed. For example, representing labels
      as the string: name + "_" + value would prove problematic if we were to
      allow "_" in a future release.
    name: Required. A unique identifier for the instance, which cannot be
      changed after the instance is created. Values are of the form
      `projects//instances/a-z*[a-z0-9]`. The final segment of the name must
      be between 2 and 64 characters in length.
    nodeCount: The number of nodes allocated to this instance. This may be
      zero in API responses for instances that are not yet in state `READY`.
      See [the documentation](https://cloud.google.com/spanner/docs/instances#
      node_count) for more information about nodes.
    processingUnits: The number of processing units allocated to this
      instance. At most one of processing_units or node_count should be
      present in the message. This may be zeo in API responses for instances
      that are not yet in state `READY`.
    state: Output only. The current instance state. For CreateInstance, the
      state must be either omitted or set to `CREATING`. For UpdateInstance,
      the state must be either omitted or set to `READY`.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current instance state. For CreateInstance, the state
    must be either omitted or set to `CREATING`. For UpdateInstance, the state
    must be either omitted or set to `READY`.

    Values:
      STATE_UNSPECIFIED: Not specified.
      CREATING: The instance is still being created. Resources may not be
        available yet, and operations such as database creation may not work.
      READY: The instance is fully created and ready to do work such as
        creating databases.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cloud Labels are a flexible and lightweight mechanism for organizing
    cloud resources into groups that reflect a customer's organizational needs
    and deployment strategies. Cloud Labels can be used to filter collections
    of resources. They can be used to control how resource metrics are
    aggregated. And they can be used as arguments to policy management rules
    (e.g. route, firewall, load balancing, etc.). * Label keys must be between
    1 and 63 characters long and must conform to the following regular
    expression: `[a-z]([-a-z0-9]*[a-z0-9])?`. * Label values must be between 0
    and 63 characters long and must conform to the regular expression
    `([a-z]([-a-z0-9]*[a-z0-9])?)?`. * No more than 64 labels can be
    associated with a given resource. See https://goo.gl/xmQnxf for more
    information on and examples of labels. If you plan to use labels in your
    own code, please note that additional characters may be allowed in the
    future. And so you are advised to use an internal label representation,
    such as JSON, which doesn't rely upon specific characters being
    disallowed. For example, representing labels as the string: name + "_" +
    value would prove problematic if we were to allow "_" in a future release.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  config = _messages.StringField(1)
  displayName = _messages.StringField(2)
  endpointUris = _messages.StringField(3, repeated=True)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  nodeCount = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  processingUnits = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  state = _messages.EnumField('StateValueValuesEnum', 8)


class OperationProgress(_messages.Message):
  r"""Encapsulates progress related information for a Cloud Spanner long
  running operation.

  Fields:
    endTime: If set, the time at which this operation failed or was completed
      successfully.
    progressPercent: Percent completion of the operation. Values are between 0
      and 100 inclusive.
    startTime: Time the request was received.
  """

  endTime = _messages.StringField(1)
  progressPercent = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(3)


class OptimizeRestoredDatabaseMetadata(_messages.Message):
  r"""Metadata type for the long-running operation used to track the progress
  of optimizations performed on a newly restored database. This long-running
  operation is automatically created by the system after the successful
  completion of a database restore, and cannot be cancelled.

  Fields:
    name: Name of the restored database being optimized.
    progress: The progress of the post-restore optimizations.
  """

  name = _messages.StringField(1)
  progress = _messages.MessageField('OperationProgress', 2)


class RestoreDatabaseMetadata(_messages.Message):
  r"""Metadata type for the long-running operation returned by
  RestoreDatabase.

  Enums:
    SourceTypeValueValuesEnum: The type of the restore source.

  Fields:
    backupInfo: Information about the backup used to restore the database.
    cancelTime: The time at which cancellation of this operation was received.
      Operations.CancelOperation starts asynchronous cancellation on a long-
      running operation. The server makes a best effort to cancel the
      operation, but success is not guaranteed. Clients can use
      Operations.GetOperation or other methods to check whether the
      cancellation succeeded or whether the operation completed despite
      cancellation. On successful cancellation, the operation is not deleted;
      instead, it becomes an operation with an Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    name: Name of the database being created and restored to.
    optimizeDatabaseOperationName: If exists, the name of the long-running
      operation that will be used to track the post-restore optimization
      process to optimize the performance of the restored database, and remove
      the dependency on the restore source. The name is of the form
      `projects//instances//databases//operations/` where the is the name of
      database being created and restored to. The metadata type of the long-
      running operation is OptimizeRestoredDatabaseMetadata. This long-running
      operation will be automatically created by the system after the
      RestoreDatabase long-running operation completes successfully. This
      operation will not be created if the restore was not successful.
    progress: The progress of the RestoreDatabase operation.
    sourceType: The type of the restore source.
  """

  class SourceTypeValueValuesEnum(_messages.Enum):
    r"""The type of the restore source.

    Values:
      TYPE_UNSPECIFIED: No restore associated.
      BACKUP: A backup was used as the source of the restore.
    """
    TYPE_UNSPECIFIED = 0
    BACKUP = 1

  backupInfo = _messages.MessageField('BackupInfo', 1)
  cancelTime = _messages.StringField(2)
  name = _messages.StringField(3)
  optimizeDatabaseOperationName = _messages.StringField(4)
  progress = _messages.MessageField('OperationProgress', 5)
  sourceType = _messages.EnumField('SourceTypeValueValuesEnum', 6)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class UpdateDatabaseDdlMetadata(_messages.Message):
  r"""Metadata type for the operation returned by UpdateDatabaseDdl.

  Fields:
    commitTimestamps: Reports the commit timestamps of all statements that
      have succeeded so far, where `commit_timestamps[i]` is the commit
      timestamp for the statement `statements[i]`.
    database: The database being modified.
    statements: For an update this list contains all the statements. For an
      individual statement, this list contains only that statement.
    throttled: Output only. When true, indicates that the operation is
      throttled e.g due to resource constraints. When resources become
      available the operation will resume and this field will be false again.
  """

  commitTimestamps = _messages.StringField(1, repeated=True)
  database = _messages.StringField(2)
  statements = _messages.StringField(3, repeated=True)
  throttled = _messages.BooleanField(4)


class UpdateInstanceMetadata(_messages.Message):
  r"""Metadata type for the operation returned by UpdateInstance.

  Fields:
    cancelTime: The time at which this operation was cancelled. If set, this
      operation is in the process of undoing itself (which is guaranteed to
      succeed) and cannot be cancelled again.
    endTime: The time at which this operation failed or was completed
      successfully.
    instance: The desired end state of the update.
    startTime: The time at which UpdateInstance request was received.
  """

  cancelTime = _messages.StringField(1)
  endTime = _messages.StringField(2)
  instance = _messages.MessageField('Instance', 3)
  startTime = _messages.StringField(4)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
