"""Generated client library for privateca version v1alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.privateca.v1alpha1 import privateca_v1alpha1_messages as messages


class PrivatecaV1alpha1(base_api.BaseApiClient):
  """Generated client library for service privateca version v1alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://privateca.googleapis.com/'
  MTLS_BASE_URL = 'https://privateca.mtls.googleapis.com/'

  _PACKAGE = 'privateca'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1alpha1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'PrivatecaV1alpha1'
  _URL_VERSION = 'v1alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new privateca handle."""
    url = url or self.BASE_URL
    super(PrivatecaV1alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_certificateAuthorities_certificateRevocationLists = self.ProjectsLocationsCertificateAuthoritiesCertificateRevocationListsService(self)
    self.projects_locations_certificateAuthorities_certificates = self.ProjectsLocationsCertificateAuthoritiesCertificatesService(self)
    self.projects_locations_certificateAuthorities = self.ProjectsLocationsCertificateAuthoritiesService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_reusableConfigs = self.ProjectsLocationsReusableConfigsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsCertificateAuthoritiesCertificateRevocationListsService(base_api.BaseApiService):
    """Service class for the projects_locations_certificateAuthorities_certificateRevocationLists resource."""

    _NAME = 'projects_locations_certificateAuthorities_certificateRevocationLists'

    def __init__(self, client):
      super(PrivatecaV1alpha1.ProjectsLocationsCertificateAuthoritiesCertificateRevocationListsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Create a new CertificateRevocationList in a given Project, Location for a particular CertificateAuthority.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesCertificateRevocationListsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}/certificateRevocationLists',
        http_method='POST',
        method_id='privateca.projects.locations.certificateAuthorities.certificateRevocationLists.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['certificateRevocationListId', 'requestId'],
        relative_path='v1alpha1/{+parent}/certificateRevocationLists',
        request_field='certificateRevocationList',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesCertificateRevocationListsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns a CertificateRevocationList.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesCertificateRevocationListsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CertificateRevocationList) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}/certificateRevocationLists/{certificateRevocationListsId}',
        http_method='GET',
        method_id='privateca.projects.locations.certificateAuthorities.certificateRevocationLists.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesCertificateRevocationListsGetRequest',
        response_type_name='CertificateRevocationList',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesCertificateRevocationListsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}/certificateRevocationLists/{certificateRevocationListsId}:getIamPolicy',
        http_method='GET',
        method_id='privateca.projects.locations.certificateAuthorities.certificateRevocationLists.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1alpha1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesCertificateRevocationListsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists CertificateRevocationLists.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesCertificateRevocationListsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCertificateRevocationListsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}/certificateRevocationLists',
        http_method='GET',
        method_id='privateca.projects.locations.certificateAuthorities.certificateRevocationLists.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/certificateRevocationLists',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesCertificateRevocationListsListRequest',
        response_type_name='ListCertificateRevocationListsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update a CertificateRevocationList.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesCertificateRevocationListsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}/certificateRevocationLists/{certificateRevocationListsId}',
        http_method='PATCH',
        method_id='privateca.projects.locations.certificateAuthorities.certificateRevocationLists.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha1/{+name}',
        request_field='certificateRevocationList',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesCertificateRevocationListsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesCertificateRevocationListsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}/certificateRevocationLists/{certificateRevocationListsId}:setIamPolicy',
        http_method='POST',
        method_id='privateca.projects.locations.certificateAuthorities.certificateRevocationLists.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesCertificateRevocationListsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesCertificateRevocationListsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}/certificateRevocationLists/{certificateRevocationListsId}:testIamPermissions',
        http_method='POST',
        method_id='privateca.projects.locations.certificateAuthorities.certificateRevocationLists.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesCertificateRevocationListsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsCertificateAuthoritiesCertificatesService(base_api.BaseApiService):
    """Service class for the projects_locations_certificateAuthorities_certificates resource."""

    _NAME = 'projects_locations_certificateAuthorities_certificates'

    def __init__(self, client):
      super(PrivatecaV1alpha1.ProjectsLocationsCertificateAuthoritiesCertificatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Create a new Certificate in a given Project, Location from a particular CertificateAuthority.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesCertificatesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}/certificates',
        http_method='POST',
        method_id='privateca.projects.locations.certificateAuthorities.certificates.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['certificateId', 'requestId'],
        relative_path='v1alpha1/{+parent}/certificates',
        request_field='certificate',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesCertificatesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns a Certificate.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesCertificatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Certificate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}/certificates/{certificatesId}',
        http_method='GET',
        method_id='privateca.projects.locations.certificateAuthorities.certificates.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesCertificatesGetRequest',
        response_type_name='Certificate',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesCertificatesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}/certificates/{certificatesId}:getIamPolicy',
        http_method='GET',
        method_id='privateca.projects.locations.certificateAuthorities.certificates.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1alpha1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesCertificatesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Certificates.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesCertificatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCertificatesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}/certificates',
        http_method='GET',
        method_id='privateca.projects.locations.certificateAuthorities.certificates.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/certificates',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesCertificatesListRequest',
        response_type_name='ListCertificatesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update a Certificate.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesCertificatesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}/certificates/{certificatesId}',
        http_method='PATCH',
        method_id='privateca.projects.locations.certificateAuthorities.certificates.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha1/{+name}',
        request_field='certificate',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesCertificatesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Revoke(self, request, global_params=None):
      r"""Revoke a Certificate.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesCertificatesRevokeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Revoke')
      return self._RunMethod(
          config, request, global_params=global_params)

    Revoke.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}/certificates/{certificatesId}:revoke',
        http_method='POST',
        method_id='privateca.projects.locations.certificateAuthorities.certificates.revoke',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:revoke',
        request_field='revokeCertificateRequest',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesCertificatesRevokeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesCertificatesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}/certificates/{certificatesId}:setIamPolicy',
        http_method='POST',
        method_id='privateca.projects.locations.certificateAuthorities.certificates.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesCertificatesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesCertificatesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}/certificates/{certificatesId}:testIamPermissions',
        http_method='POST',
        method_id='privateca.projects.locations.certificateAuthorities.certificates.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesCertificatesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsCertificateAuthoritiesService(base_api.BaseApiService):
    """Service class for the projects_locations_certificateAuthorities resource."""

    _NAME = 'projects_locations_certificateAuthorities'

    def __init__(self, client):
      super(PrivatecaV1alpha1.ProjectsLocationsCertificateAuthoritiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Activate(self, request, global_params=None):
      r"""Activate a pending CertificateAuthority.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesActivateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Activate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Activate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}:activate',
        http_method='POST',
        method_id='privateca.projects.locations.certificateAuthorities.activate',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:activate',
        request_field='activateCertificateAuthorityRequest',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesActivateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Create a new CertificateAuthority in a given Project and Location.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities',
        http_method='POST',
        method_id='privateca.projects.locations.certificateAuthorities.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['certificateAuthorityId', 'requestId'],
        relative_path='v1alpha1/{+parent}/certificateAuthorities',
        request_field='certificateAuthority',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a specific CertificateAuthority. Once deleted, the CertificateAuthority will no longer issue Certificates and CertificateRevocationLists.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}',
        http_method='DELETE',
        method_id='privateca.projects.locations.certificateAuthorities.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Disable(self, request, global_params=None):
      r"""Disable a CertificateAuthority.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesDisableRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Disable')
      return self._RunMethod(
          config, request, global_params=global_params)

    Disable.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}:disable',
        http_method='POST',
        method_id='privateca.projects.locations.certificateAuthorities.disable',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:disable',
        request_field='disableCertificateAuthorityRequest',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesDisableRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Enable(self, request, global_params=None):
      r"""Enable a CertificateAuthority.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesEnableRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Enable')
      return self._RunMethod(
          config, request, global_params=global_params)

    Enable.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}:enable',
        http_method='POST',
        method_id='privateca.projects.locations.certificateAuthorities.enable',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:enable',
        request_field='enableCertificateAuthorityRequest',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesEnableRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns a CertificateAuthority.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CertificateAuthority) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}',
        http_method='GET',
        method_id='privateca.projects.locations.certificateAuthorities.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesGetRequest',
        response_type_name='CertificateAuthority',
        supports_download=False,
    )

    def GetCsr(self, request, global_params=None):
      r"""Get the CSR for a pending CertificateAuthority.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesGetCsrRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetCertificateAuthorityCsrResponse) The response message.
      """
      config = self.GetMethodConfig('GetCsr')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetCsr.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}:getCsr',
        http_method='GET',
        method_id='privateca.projects.locations.certificateAuthorities.getCsr',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:getCsr',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesGetCsrRequest',
        response_type_name='GetCertificateAuthorityCsrResponse',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}:getIamPolicy',
        http_method='GET',
        method_id='privateca.projects.locations.certificateAuthorities.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1alpha1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists CertificateAuthorities.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCertificateAuthoritiesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities',
        http_method='GET',
        method_id='privateca.projects.locations.certificateAuthorities.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/certificateAuthorities',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesListRequest',
        response_type_name='ListCertificateAuthoritiesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update a CertificateAuthority.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}',
        http_method='PATCH',
        method_id='privateca.projects.locations.certificateAuthorities.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha1/{+name}',
        request_field='certificateAuthority',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PublishCrl(self, request, global_params=None):
      r"""Publish a CertificateRevocationList.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesPublishCrlRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PublishCertificateRevocationListResponse) The response message.
      """
      config = self.GetMethodConfig('PublishCrl')
      return self._RunMethod(
          config, request, global_params=global_params)

    PublishCrl.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}:publishCrl',
        http_method='POST',
        method_id='privateca.projects.locations.certificateAuthorities.publishCrl',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:publishCrl',
        request_field='publishCertificateRevocationListRequest',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesPublishCrlRequest',
        response_type_name='PublishCertificateRevocationListResponse',
        supports_download=False,
    )

    def Restore(self, request, global_params=None):
      r"""Restore a CertificateAuthority that is scheduled for deletion.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesRestoreRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Restore')
      return self._RunMethod(
          config, request, global_params=global_params)

    Restore.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}:restore',
        http_method='POST',
        method_id='privateca.projects.locations.certificateAuthorities.restore',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:restore',
        request_field='restoreCertificateAuthorityRequest',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesRestoreRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def ScheduleDelete(self, request, global_params=None):
      r"""Schedule a CertificateAuthority for deletion.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesScheduleDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ScheduleDelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    ScheduleDelete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}:scheduleDelete',
        http_method='POST',
        method_id='privateca.projects.locations.certificateAuthorities.scheduleDelete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:scheduleDelete',
        request_field='scheduleDeleteCertificateAuthorityRequest',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesScheduleDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}:setIamPolicy',
        http_method='POST',
        method_id='privateca.projects.locations.certificateAuthorities.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (PrivatecaProjectsLocationsCertificateAuthoritiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/certificateAuthorities/{certificateAuthoritiesId}:testIamPermissions',
        http_method='POST',
        method_id='privateca.projects.locations.certificateAuthorities.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='PrivatecaProjectsLocationsCertificateAuthoritiesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(PrivatecaV1alpha1.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.

      Args:
        request: (PrivatecaProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='privateca.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='PrivatecaProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (PrivatecaProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='privateca.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (PrivatecaProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='privateca.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to override the binding to use different resource name schemes, such as `users/*/operations`. To override the binding, API services can add a binding such as `"/v1/{name=users/*}/operations"` to their service configuration. For backwards compatibility, the default name includes the operations collection id, however overriding users must ensure the name binding is the parent resource, without the operations collection id.

      Args:
        request: (PrivatecaProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='privateca.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+name}/operations',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsReusableConfigsService(base_api.BaseApiService):
    """Service class for the projects_locations_reusableConfigs resource."""

    _NAME = 'projects_locations_reusableConfigs'

    def __init__(self, client):
      super(PrivatecaV1alpha1.ProjectsLocationsReusableConfigsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Create a new ReusableConfig in a given Project and Location.

      Args:
        request: (PrivatecaProjectsLocationsReusableConfigsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/reusableConfigs',
        http_method='POST',
        method_id='privateca.projects.locations.reusableConfigs.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['requestId', 'reusableConfigId'],
        relative_path='v1alpha1/{+parent}/reusableConfigs',
        request_field='reusableConfig',
        request_type_name='PrivatecaProjectsLocationsReusableConfigsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns a ReusableConfig.

      Args:
        request: (PrivatecaProjectsLocationsReusableConfigsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReusableConfig) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/reusableConfigs/{reusableConfigsId}',
        http_method='GET',
        method_id='privateca.projects.locations.reusableConfigs.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsReusableConfigsGetRequest',
        response_type_name='ReusableConfig',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (PrivatecaProjectsLocationsReusableConfigsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/reusableConfigs/{reusableConfigsId}:getIamPolicy',
        http_method='GET',
        method_id='privateca.projects.locations.reusableConfigs.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1alpha1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsReusableConfigsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists ReusableConfigs.

      Args:
        request: (PrivatecaProjectsLocationsReusableConfigsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListReusableConfigsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/reusableConfigs',
        http_method='GET',
        method_id='privateca.projects.locations.reusableConfigs.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/reusableConfigs',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsReusableConfigsListRequest',
        response_type_name='ListReusableConfigsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update a ReusableConfig.

      Args:
        request: (PrivatecaProjectsLocationsReusableConfigsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/reusableConfigs/{reusableConfigsId}',
        http_method='PATCH',
        method_id='privateca.projects.locations.reusableConfigs.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha1/{+name}',
        request_field='reusableConfig',
        request_type_name='PrivatecaProjectsLocationsReusableConfigsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (PrivatecaProjectsLocationsReusableConfigsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/reusableConfigs/{reusableConfigsId}:setIamPolicy',
        http_method='POST',
        method_id='privateca.projects.locations.reusableConfigs.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='PrivatecaProjectsLocationsReusableConfigsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (PrivatecaProjectsLocationsReusableConfigsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/reusableConfigs/{reusableConfigsId}:testIamPermissions',
        http_method='POST',
        method_id='privateca.projects.locations.reusableConfigs.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='PrivatecaProjectsLocationsReusableConfigsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(PrivatecaV1alpha1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (PrivatecaProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='privateca.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (PrivatecaProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations',
        http_method='GET',
        method_id='privateca.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+name}/locations',
        request_field='',
        request_type_name='PrivatecaProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(PrivatecaV1alpha1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
