"""Generated message classes for anthosevents version v1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'anthosevents'


class AnthoseventsApiV1NamespacesCreateRequest(_messages.Message):
  r"""A AnthoseventsApiV1NamespacesCreateRequest object.

  Fields:
    namespace: A Namespace resource to be passed as the request body.
    parent: Required. The project ID or project number in which this namespace
      should be created.
  """

  namespace = _messages.MessageField('Namespace', 1)
  parent = _messages.StringField(2)


class AnthoseventsApiV1NamespacesDeleteRequest(_messages.Message):
  r"""A AnthoseventsApiV1NamespacesDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: Required. The name of the namespace being deleted. If needed,
      replace {namespace_id} with the project ID.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class AnthoseventsApiV1NamespacesGetRequest(_messages.Message):
  r"""A AnthoseventsApiV1NamespacesGetRequest object.

  Fields:
    name: Required. The name of the namespace being retrieved. If needed,
      replace {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class AnthoseventsApiV1NamespacesListRequest(_messages.Message):
  r"""A AnthoseventsApiV1NamespacesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: Required. The project ID or project number from which the
      namespaces should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class AnthoseventsApiV1NamespacesPatchRequest(_messages.Message):
  r"""A AnthoseventsApiV1NamespacesPatchRequest object.

  Fields:
    name: Required. The name of the namespace being retrieved. If needed,
      replace {namespace_id} with the project ID.
    namespace: A Namespace resource to be passed as the request body.
    updateMask: Required. Indicates which fields in the provided namespace to
      update. This field is currently unused.
  """

  name = _messages.StringField(1, required=True)
  namespace = _messages.MessageField('Namespace', 2)
  updateMask = _messages.StringField(3)


class AnthoseventsApiV1NamespacesReplaceNamespaceRequest(_messages.Message):
  r"""A AnthoseventsApiV1NamespacesReplaceNamespaceRequest object.

  Fields:
    name: Required. The name of the namespace being retrieved. If needed,
      replace {namespace_id} with the project ID.
    namespace: A Namespace resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  namespace = _messages.MessageField('Namespace', 2)


class AnthoseventsApiV1NamespacesSecretsCreateRequest(_messages.Message):
  r"""A AnthoseventsApiV1NamespacesSecretsCreateRequest object.

  Fields:
    parent: Required. The project ID or project number in which this secret
      should be created.
    secret: A Secret resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  secret = _messages.MessageField('Secret', 2)


class AnthoseventsApiV1NamespacesSecretsDeleteRequest(_messages.Message):
  r"""A AnthoseventsApiV1NamespacesSecretsDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: Required. The name of the secret being deleted. If needed, replace
      {namespace_id} with the project ID.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class AnthoseventsApiV1NamespacesSecretsGetRequest(_messages.Message):
  r"""A AnthoseventsApiV1NamespacesSecretsGetRequest object.

  Fields:
    name: Required. The name of the secret being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class AnthoseventsApiV1NamespacesSecretsListRequest(_messages.Message):
  r"""A AnthoseventsApiV1NamespacesSecretsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: Required. The project ID or project number from which the secrets
      should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class AnthoseventsApiV1NamespacesSecretsReplaceSecretRequest(_messages.Message):
  r"""A AnthoseventsApiV1NamespacesSecretsReplaceSecretRequest object.

  Fields:
    name: Required. The name of the secret being retrieved. If needed, replace
      {namespace_id} with the project ID.
    secret: A Secret resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  secret = _messages.MessageField('Secret', 2)


class AnthoseventsProjectsLocationsNamespacesCreateRequest(_messages.Message):
  r"""A AnthoseventsProjectsLocationsNamespacesCreateRequest object.

  Fields:
    namespace: A Namespace resource to be passed as the request body.
    parent: Required. The project ID or project number in which this namespace
      should be created.
  """

  namespace = _messages.MessageField('Namespace', 1)
  parent = _messages.StringField(2, required=True)


class AnthoseventsProjectsLocationsNamespacesDeleteRequest(_messages.Message):
  r"""A AnthoseventsProjectsLocationsNamespacesDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: Required. The name of the namespace being deleted. If needed,
      replace {namespace_id} with the project ID.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class AnthoseventsProjectsLocationsNamespacesGetRequest(_messages.Message):
  r"""A AnthoseventsProjectsLocationsNamespacesGetRequest object.

  Fields:
    name: Required. The name of the namespace being retrieved. If needed,
      replace {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class AnthoseventsProjectsLocationsNamespacesListRequest(_messages.Message):
  r"""A AnthoseventsProjectsLocationsNamespacesListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: Required. The project ID or project number from which the
      namespaces should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class AnthoseventsProjectsLocationsNamespacesPatchRequest(_messages.Message):
  r"""A AnthoseventsProjectsLocationsNamespacesPatchRequest object.

  Fields:
    name: Required. The name of the namespace being retrieved. If needed,
      replace {namespace_id} with the project ID.
    namespace: A Namespace resource to be passed as the request body.
    updateMask: Required. Indicates which fields in the provided namespace to
      update. This field is currently unused.
  """

  name = _messages.StringField(1, required=True)
  namespace = _messages.MessageField('Namespace', 2)
  updateMask = _messages.StringField(3)


class AnthoseventsProjectsLocationsNamespacesReplaceNamespaceRequest(_messages.Message):
  r"""A AnthoseventsProjectsLocationsNamespacesReplaceNamespaceRequest object.

  Fields:
    name: Required. The name of the namespace being retrieved. If needed,
      replace {namespace_id} with the project ID.
    namespace: A Namespace resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  namespace = _messages.MessageField('Namespace', 2)


class AnthoseventsProjectsLocationsSecretsCreateRequest(_messages.Message):
  r"""A AnthoseventsProjectsLocationsSecretsCreateRequest object.

  Fields:
    parent: Required. The project ID or project number in which this secret
      should be created.
    secret: A Secret resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  secret = _messages.MessageField('Secret', 2)


class AnthoseventsProjectsLocationsSecretsDeleteRequest(_messages.Message):
  r"""A AnthoseventsProjectsLocationsSecretsDeleteRequest object.

  Fields:
    apiVersion: Cloud Run currently ignores this parameter.
    kind: Cloud Run currently ignores this parameter.
    name: Required. The name of the secret being deleted. If needed, replace
      {namespace_id} with the project ID.
    propagationPolicy: Specifies the propagation policy of delete. Cloud Run
      currently ignores this setting, and deletes in the background. Please
      see kubernetes.io/docs/concepts/workloads/controllers/garbage-
      collection/ for more information.
  """

  apiVersion = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  propagationPolicy = _messages.StringField(4)


class AnthoseventsProjectsLocationsSecretsGetRequest(_messages.Message):
  r"""A AnthoseventsProjectsLocationsSecretsGetRequest object.

  Fields:
    name: Required. The name of the secret being retrieved. If needed, replace
      {namespace_id} with the project ID.
  """

  name = _messages.StringField(1, required=True)


class AnthoseventsProjectsLocationsSecretsListRequest(_messages.Message):
  r"""A AnthoseventsProjectsLocationsSecretsListRequest object.

  Fields:
    continue_: Optional encoded string to continue paging.
    fieldSelector: Allows to filter resources based on a specific value for a
      field name. Send this in a query string format. i.e.
      'metadata.name%3Dlorem'. Not currently used by Cloud Run.
    includeUninitialized: Not currently used by Cloud Run.
    labelSelector: Allows to filter resources based on a label. Supported
      operations are =, !=, exists, in, and notIn.
    limit: The maximum number of records that should be returned.
    parent: Required. The project ID or project number from which the secrets
      should be listed.
    resourceVersion: The baseline resource version from which the list or
      watch operation should start. Not currently used by Cloud Run.
    watch: Flag that indicates that the client expects to watch this resource
      as well. Not currently used by Cloud Run.
  """

  continue_ = _messages.StringField(1)
  fieldSelector = _messages.StringField(2)
  includeUninitialized = _messages.BooleanField(3)
  labelSelector = _messages.StringField(4)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  parent = _messages.StringField(6, required=True)
  resourceVersion = _messages.StringField(7)
  watch = _messages.BooleanField(8)


class AnthoseventsProjectsLocationsSecretsReplaceSecretRequest(_messages.Message):
  r"""A AnthoseventsProjectsLocationsSecretsReplaceSecretRequest object.

  Fields:
    name: Required. The name of the secret being retrieved. If needed, replace
      {namespace_id} with the project ID.
    secret: A Secret resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  secret = _messages.MessageField('Secret', 2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class ListMeta(_messages.Message):
  r"""ListMeta describes metadata that synthetic resources must have,
  including lists and various status objects. A resource may have only one of
  {ObjectMeta, ListMeta}.

  Fields:
    continue_: continue may be set if the user set a limit on the number of
      items returned, and indicates that the server has more data available.
      The value is opaque and may be used to issue another request to the
      endpoint that served this list to retrieve the next set of available
      objects. Continuing a list may not be possible if the server
      configuration has changed or more than a few minutes have passed. The
      resourceVersion field returned when using this continue value will be
      identical to the value in the first response.
    resourceVersion: String that identifies the server's internal version of
      this object that can be used by clients to determine when objects have
      changed. Value must be treated as opaque by clients and passed
      unmodified back to the server. Populated by the system. Read-only. More
      info: https://git.k8s.io/community/contributors/devel/api-
      conventions.md#concurrency-control-and-consistency +optional
    selfLink: SelfLink is a URL representing this object. Populated by the
      system. Read-only. +optional
  """

  continue_ = _messages.StringField(1)
  resourceVersion = _messages.StringField(2)
  selfLink = _messages.StringField(3)


class ListNamespacesResponse(_messages.Message):
  r"""ListNamespacesResponse is a list of Namespace resources.

  Fields:
    apiVersion: The API version for this call such as "core/v1". The core API
      group that Namespaces are part of do not specify an explicit group name
      in the api version. So the api version here is just "v1".
    items: List of Namespaces. More info:
      https://kubernetes.io/docs/concepts/configuration/namespace
    kind: The kind of this resource, in this case "NamespaceList".
    metadata: A ListMeta attribute.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('Namespace', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class ListSecretsResponse(_messages.Message):
  r"""ListSecretsResponse is a list of Secret resources.

  Fields:
    apiVersion: The API version for this call such as "core/v1". The core API
      group that Secrets are part of do not specify an explicit group name in
      the api version. So the api version here is just "v1".
    items: List of Secrets. More info:
      https://kubernetes.io/docs/concepts/configuration/secret
    kind: The kind of this resource, in this case "SecretList".
    metadata: Metadata associated with this Secret list.
    unreachable: Locations that could not be reached.
  """

  apiVersion = _messages.StringField(1)
  items = _messages.MessageField('Secret', 2, repeated=True)
  kind = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  unreachable = _messages.StringField(5, repeated=True)


class Namespace(_messages.Message):
  r"""Cloud Run fully managed: not supported  Cloud Run on GKE: supported
  Namespace provides a scope for Names. Use of multiple namespaces is
  optional.

  Fields:
    metadata: Standard object's metadata. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata
    spec: Spec defines the behavior of the Namespace. More info:
      https://git.k8s.io/community/contributors/devel/sig-architecture/api-
      conventions.md#spec-and-status
    status: Status describes the current status of a Namespace. More info:
      https://git.k8s.io/community/contributors/devel/sig-architecture/api-
      conventions.md#spec-and-status
  """

  metadata = _messages.MessageField('ObjectMeta', 1)
  spec = _messages.MessageField('NamespaceSpec', 2)
  status = _messages.MessageField('NamespaceStatus', 3)


class NamespaceSpec(_messages.Message):
  r"""Cloud Run fully managed: not supported  Cloud Run on GKE: supported
  NamespaceSpec describes the attributes on a Namespace.

  Fields:
    finalizers: Finalizers is an opaque list of values that must be empty to
      permanently remove object from storage. More info:
      https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
  """

  finalizers = _messages.StringField(1, repeated=True)


class NamespaceStatus(_messages.Message):
  r"""Cloud Run fully managed: not supported  Cloud Run on GKE: supported
  NamespaceStatus is information about the current status of a Namespace.

  Fields:
    phase: Phase is the current lifecycle phase of the namespace. More info:
      https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
  """

  phase = _messages.StringField(1)


class ObjectMeta(_messages.Message):
  r"""k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta is metadata that all
  persisted resources must have, which includes all objects users must create.

  Messages:
    AnnotationsValue: (Optional)  Annotations is an unstructured key value map
      stored with a resource that may be set by external tools to store and
      retrieve arbitrary metadata. They are not queryable and should be
      preserved when modifying objects. More info:
      http://kubernetes.io/docs/user-guide/annotations
    LabelsValue: (Optional)  Map of string keys and values that can be used to
      organize and categorize (scope and select) objects. May match selectors
      of replication controllers and routes. More info:
      http://kubernetes.io/docs/user-guide/labels

  Fields:
    annotations: (Optional)  Annotations is an unstructured key value map
      stored with a resource that may be set by external tools to store and
      retrieve arbitrary metadata. They are not queryable and should be
      preserved when modifying objects. More info:
      http://kubernetes.io/docs/user-guide/annotations
    clusterName: (Optional)  Cloud Run fully managed: not supported  Cloud Run
      for Anthos: supported  The name of the cluster which the object belongs
      to. This is used to distinguish resources with same name and namespace
      in different clusters. This field is not set anywhere right now and
      apiserver is going to ignore it if set in create or update request.
    creationTimestamp: (Optional)  CreationTimestamp is a timestamp
      representing the server time when this object was created. It is not
      guaranteed to be set in happens-before order across separate operations.
      Clients may not set this value. It is represented in RFC3339 form and is
      in UTC.  Populated by the system. Read-only. Null for lists. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata
    deletionGracePeriodSeconds: (Optional)  Cloud Run fully managed: not
      supported  Cloud Run for Anthos: supported  Number of seconds allowed
      for this object to gracefully terminate before it will be removed from
      the system. Only set when deletionTimestamp is also set. May only be
      shortened. Read-only.
    deletionTimestamp: (Optional)  Cloud Run fully managed: not supported
      Cloud Run for Anthos: supported  DeletionTimestamp is RFC 3339 date and
      time at which this resource will be deleted. This field is set by the
      server when a graceful deletion is requested by the user, and is not
      directly settable by a client. The resource is expected to be deleted
      (no longer visible from resource lists, and not reachable by name) after
      the time in this field, once the finalizers list is empty. As long as
      the finalizers list contains items, deletion is blocked. Once the
      deletionTimestamp is set, this value may not be unset or be set further
      into the future, although it may be shortened or the resource may be
      deleted prior to this time. For example, a user may request that a pod
      is deleted in 30 seconds. The Kubelet will react by sending a graceful
      termination signal to the containers in the pod. After that 30 seconds,
      the Kubelet will send a hard termination signal (SIGKILL) to the
      container and after cleanup, remove the pod from the API. In the
      presence of network partitions, this object may still exist after this
      timestamp, until an administrator or automated process can determine the
      resource is fully terminated. If not set, graceful deletion of the
      object has not been requested.  Populated by the system when a graceful
      deletion is requested. Read-only. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata
    finalizers: (Optional)  Cloud Run fully managed: not supported  Cloud Run
      for Anthos: supported  Must be empty before the object is deleted from
      the registry. Each entry is an identifier for the responsible component
      that will remove the entry from the list. If the deletionTimestamp of
      the object is non-nil, entries in this list can only be removed.
      +patchStrategy=merge
    generateName: (Optional)  Cloud Run fully managed: not supported  Cloud
      Run for Anthos: supported  GenerateName is an optional prefix, used by
      the server, to generate a unique name ONLY IF the Name field has not
      been provided. If this field is used, the name returned to the client
      will be different than the name passed. This value will also be combined
      with a unique suffix. The provided value has the same validation rules
      as the Name field, and may be truncated by the length of the suffix
      required to make the value unique on the server.  If this field is
      specified and the generated name exists, the server will NOT return a
      409 - instead, it will either return 201 Created or 500 with Reason
      ServerTimeout indicating a unique name could not be found in the time
      allotted, and the client should retry (optionally after the time
      indicated in the Retry-After header).  Applied only if Name is not
      specified. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#idempotency  string generateName = 2;
    generation: (Optional)  A sequence number representing a specific
      generation of the desired state. Populated by the system. Read-only.
    labels: (Optional)  Map of string keys and values that can be used to
      organize and categorize (scope and select) objects. May match selectors
      of replication controllers and routes. More info:
      http://kubernetes.io/docs/user-guide/labels
    name: Name must be unique within a namespace, within a Cloud Run region.
      Is required when creating resources, although some resources may allow a
      client to request the generation of an appropriate name automatically.
      Name is primarily intended for creation idempotence and configuration
      definition. Cannot be updated. More info:
      http://kubernetes.io/docs/user-guide/identifiers#names +optional
    namespace: Namespace defines the space within each name must be unique,
      within a Cloud Run region. In Cloud Run the namespace must be equal to
      either the project ID or project number.
    ownerReferences: (Optional)  Cloud Run fully managed: not supported  Cloud
      Run for Anthos: supported  List of objects that own this object. If ALL
      objects in the list have been deleted, this object will be garbage
      collected.
    resourceVersion: (Optional)  An opaque value that represents the internal
      version of this object that can be used by clients to determine when
      objects have changed. May be used for optimistic concurrency, change
      detection, and the watch operation on a resource or set of resources.
      Clients must treat these values as opaque and passed unmodified back to
      the server. They may only be valid for a particular resource or set of
      resources.  Populated by the system. Read-only. Value must be treated as
      opaque by clients and . More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#concurrency-control-and-consistency
    selfLink: (Optional)  SelfLink is a URL representing this object.
      Populated by the system. Read-only.  string selfLink = 4;
    uid: (Optional)  UID is the unique in time and space value for this
      object. It is typically generated by the server on successful creation
      of a resource and is not allowed to change on PUT operations.  Populated
      by the system. Read-only. More info: http://kubernetes.io/docs/user-
      guide/identifiers#uids
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""(Optional)  Annotations is an unstructured key value map stored with a
    resource that may be set by external tools to store and retrieve arbitrary
    metadata. They are not queryable and should be preserved when modifying
    objects. More info: http://kubernetes.io/docs/user-guide/annotations

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""(Optional)  Map of string keys and values that can be used to organize
    and categorize (scope and select) objects. May match selectors of
    replication controllers and routes. More info:
    http://kubernetes.io/docs/user-guide/labels

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  clusterName = _messages.StringField(2)
  creationTimestamp = _messages.StringField(3)
  deletionGracePeriodSeconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  deletionTimestamp = _messages.StringField(5)
  finalizers = _messages.StringField(6, repeated=True)
  generateName = _messages.StringField(7)
  generation = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  labels = _messages.MessageField('LabelsValue', 9)
  name = _messages.StringField(10)
  namespace = _messages.StringField(11)
  ownerReferences = _messages.MessageField('OwnerReference', 12, repeated=True)
  resourceVersion = _messages.StringField(13)
  selfLink = _messages.StringField(14)
  uid = _messages.StringField(15)


class OwnerReference(_messages.Message):
  r"""OwnerReference contains enough information to let you identify an owning
  object. Currently, an owning object must be in the same namespace, so there
  is no namespace field.

  Fields:
    apiVersion: API version of the referent.
    blockOwnerDeletion: If true, AND if the owner has the "foregroundDeletion"
      finalizer, then the owner cannot be deleted from the key-value store
      until this reference is removed. Defaults to false. To set this field, a
      user needs "delete" permission of the owner, otherwise 422
      (Unprocessable Entity) will be returned. +optional
    controller: If true, this reference points to the managing controller.
      +optional
    kind: Kind of the referent. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#types-kinds
    name: Name of the referent. More info: http://kubernetes.io/docs/user-
      guide/identifiers#names
    uid: UID of the referent. More info: http://kubernetes.io/docs/user-
      guide/identifiers#uids
  """

  apiVersion = _messages.StringField(1)
  blockOwnerDeletion = _messages.BooleanField(2)
  controller = _messages.BooleanField(3)
  kind = _messages.StringField(4)
  name = _messages.StringField(5)
  uid = _messages.StringField(6)


class Secret(_messages.Message):
  r"""Cloud Run fully managed: not supported  Cloud Run on GKE: supported
  Secret holds secret data of a certain type. The total bytes of the values in
  the Data field must be less than MaxSecretSize bytes.

  Messages:
    DataValue: Data contains the secret data. Each key must consist of
      alphanumeric characters, '-', '_' or '.'. The serialized form of the
      secret data is a base64 encoded string, representing the arbitrary
      (possibly non-string) data value here. Described in
      https://tools.ietf.org/html/rfc4648#section-4
    StringDataValue: stringData allows specifying non-binary secret data in
      string form. It is provided as a write-only convenience method. All keys
      and values are merged into the data field on write, overwriting any
      existing values. It is never output when reading from the API.
      +k8s:conversion-gen=false

  Fields:
    data: Data contains the secret data. Each key must consist of alphanumeric
      characters, '-', '_' or '.'. The serialized form of the secret data is a
      base64 encoded string, representing the arbitrary (possibly non-string)
      data value here. Described in
      https://tools.ietf.org/html/rfc4648#section-4
    metadata: Standard object's metadata. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata
    stringData: stringData allows specifying non-binary secret data in string
      form. It is provided as a write-only convenience method. All keys and
      values are merged into the data field on write, overwriting any existing
      values. It is never output when reading from the API. +k8s:conversion-
      gen=false
    type: Used to facilitate programmatic handling of secret data.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DataValue(_messages.Message):
    r"""Data contains the secret data. Each key must consist of alphanumeric
    characters, '-', '_' or '.'. The serialized form of the secret data is a
    base64 encoded string, representing the arbitrary (possibly non-string)
    data value here. Described in
    https://tools.ietf.org/html/rfc4648#section-4

    Messages:
      AdditionalProperty: An additional property for a DataValue object.

    Fields:
      additionalProperties: Additional properties of type DataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DataValue object.

      Fields:
        key: Name of the additional property.
        value: A byte attribute.
      """

      key = _messages.StringField(1)
      value = _messages.BytesField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class StringDataValue(_messages.Message):
    r"""stringData allows specifying non-binary secret data in string form. It
    is provided as a write-only convenience method. All keys and values are
    merged into the data field on write, overwriting any existing values. It
    is never output when reading from the API. +k8s:conversion-gen=false

    Messages:
      AdditionalProperty: An additional property for a StringDataValue object.

    Fields:
      additionalProperties: Additional properties of type StringDataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a StringDataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  data = _messages.MessageField('DataValue', 1)
  metadata = _messages.MessageField('ObjectMeta', 2)
  stringData = _messages.MessageField('StringDataValue', 3)
  type = _messages.StringField(4)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    ListMeta, 'continue_', 'continue')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
