"""Generated client library for anthosevents version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.anthosevents.v1 import anthosevents_v1_messages as messages


class AnthoseventsV1(base_api.BaseApiClient):
  """Generated client library for service anthosevents version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://anthosevents.googleapis.com/'
  MTLS_BASE_URL = 'https://anthosevents.mtls.googleapis.com/'

  _PACKAGE = 'anthosevents'
  _SCOPES = ['https://www.googleapis.com/auth/userinfo.email']
  _VERSION = 'v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'AnthoseventsV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new anthosevents handle."""
    url = url or self.BASE_URL
    super(AnthoseventsV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.api_v1_namespaces_secrets = self.ApiV1NamespacesSecretsService(self)
    self.api_v1_namespaces = self.ApiV1NamespacesService(self)
    self.api_v1 = self.ApiV1Service(self)
    self.api = self.ApiService(self)
    self.projects_locations_namespaces = self.ProjectsLocationsNamespacesService(self)
    self.projects_locations_secrets = self.ProjectsLocationsSecretsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ApiV1NamespacesSecretsService(base_api.BaseApiService):
    """Service class for the api_v1_namespaces_secrets resource."""

    _NAME = 'api_v1_namespaces_secrets'

    def __init__(self, client):
      super(AnthoseventsV1.ApiV1NamespacesSecretsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new secret.

      Args:
        request: (AnthoseventsApiV1NamespacesSecretsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Secret) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/secrets',
        http_method='POST',
        method_id='anthosevents.api.v1.namespaces.secrets.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='api/v1/{+parent}/secrets',
        request_field='secret',
        request_type_name='AnthoseventsApiV1NamespacesSecretsCreateRequest',
        response_type_name='Secret',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a secret.

      Args:
        request: (AnthoseventsApiV1NamespacesSecretsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/secrets/{secretsId}',
        http_method='DELETE',
        method_id='anthosevents.api.v1.namespaces.secrets.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='api/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsApiV1NamespacesSecretsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a secret.

      Args:
        request: (AnthoseventsApiV1NamespacesSecretsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Secret) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/secrets/{secretsId}',
        http_method='GET',
        method_id='anthosevents.api.v1.namespaces.secrets.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='api/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsApiV1NamespacesSecretsGetRequest',
        response_type_name='Secret',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list secrets.

      Args:
        request: (AnthoseventsApiV1NamespacesSecretsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSecretsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/secrets',
        http_method='GET',
        method_id='anthosevents.api.v1.namespaces.secrets.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='api/v1/{+parent}/secrets',
        request_field='',
        request_type_name='AnthoseventsApiV1NamespacesSecretsListRequest',
        response_type_name='ListSecretsResponse',
        supports_download=False,
    )

    def ReplaceSecret(self, request, global_params=None):
      r"""Rpc to replace a secret.

Only the spec and metadata labels and annotations are modifiable. After
the Update request, Cloud Run will work to make the 'status'
match the requested 'spec'.

May provide metadata.resourceVersion to enforce update from last read for
optimistic concurrency control.

      Args:
        request: (AnthoseventsApiV1NamespacesSecretsReplaceSecretRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Secret) The response message.
      """
      config = self.GetMethodConfig('ReplaceSecret')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceSecret.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}/secrets/{secretsId}',
        http_method='PUT',
        method_id='anthosevents.api.v1.namespaces.secrets.replaceSecret',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='api/v1/{+name}',
        request_field='secret',
        request_type_name='AnthoseventsApiV1NamespacesSecretsReplaceSecretRequest',
        response_type_name='Secret',
        supports_download=False,
    )

  class ApiV1NamespacesService(base_api.BaseApiService):
    """Service class for the api_v1_namespaces resource."""

    _NAME = 'api_v1_namespaces'

    def __init__(self, client):
      super(AnthoseventsV1.ApiV1NamespacesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new namespace.

      Args:
        request: (AnthoseventsApiV1NamespacesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='anthosevents.api.v1.namespaces.create',
        ordered_params=[],
        path_params=[],
        query_params=['parent'],
        relative_path='api/v1/namespaces',
        request_field='namespace',
        request_type_name='AnthoseventsApiV1NamespacesCreateRequest',
        response_type_name='Namespace',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a namespace.

      Args:
        request: (AnthoseventsApiV1NamespacesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}',
        http_method='DELETE',
        method_id='anthosevents.api.v1.namespaces.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='api/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsApiV1NamespacesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a namespace.

      Args:
        request: (AnthoseventsApiV1NamespacesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}',
        http_method='GET',
        method_id='anthosevents.api.v1.namespaces.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='api/v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsApiV1NamespacesGetRequest',
        response_type_name='Namespace',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list namespaces.

      Args:
        request: (AnthoseventsApiV1NamespacesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNamespacesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='anthosevents.api.v1.namespaces.list',
        ordered_params=[],
        path_params=[],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'parent', 'resourceVersion', 'watch'],
        relative_path='api/v1/namespaces',
        request_field='',
        request_type_name='AnthoseventsApiV1NamespacesListRequest',
        response_type_name='ListNamespacesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Rpc to update a namespace.

      Args:
        request: (AnthoseventsApiV1NamespacesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}',
        http_method='PATCH',
        method_id='anthosevents.api.v1.namespaces.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='api/v1/{+name}',
        request_field='namespace',
        request_type_name='AnthoseventsApiV1NamespacesPatchRequest',
        response_type_name='Namespace',
        supports_download=False,
    )

    def ReplaceNamespace(self, request, global_params=None):
      r"""Rpc to replace a namespace.

      Args:
        request: (AnthoseventsApiV1NamespacesReplaceNamespaceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('ReplaceNamespace')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceNamespace.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='api/v1/namespaces/{namespacesId}',
        http_method='PUT',
        method_id='anthosevents.api.v1.namespaces.replaceNamespace',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='api/v1/{+name}',
        request_field='namespace',
        request_type_name='AnthoseventsApiV1NamespacesReplaceNamespaceRequest',
        response_type_name='Namespace',
        supports_download=False,
    )

  class ApiV1Service(base_api.BaseApiService):
    """Service class for the api_v1 resource."""

    _NAME = 'api_v1'

    def __init__(self, client):
      super(AnthoseventsV1.ApiV1Service, self).__init__(client)
      self._upload_configs = {
          }

  class ApiService(base_api.BaseApiService):
    """Service class for the api resource."""

    _NAME = 'api'

    def __init__(self, client):
      super(AnthoseventsV1.ApiService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLocationsNamespacesService(base_api.BaseApiService):
    """Service class for the projects_locations_namespaces resource."""

    _NAME = 'projects_locations_namespaces'

    def __init__(self, client):
      super(AnthoseventsV1.ProjectsLocationsNamespacesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new namespace.

      Args:
        request: (AnthoseventsProjectsLocationsNamespacesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/namespaces',
        http_method='POST',
        method_id='anthosevents.projects.locations.namespaces.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/namespaces',
        request_field='namespace',
        request_type_name='AnthoseventsProjectsLocationsNamespacesCreateRequest',
        response_type_name='Namespace',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a namespace.

      Args:
        request: (AnthoseventsProjectsLocationsNamespacesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}',
        http_method='DELETE',
        method_id='anthosevents.projects.locations.namespaces.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsProjectsLocationsNamespacesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a namespace.

      Args:
        request: (AnthoseventsProjectsLocationsNamespacesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}',
        http_method='GET',
        method_id='anthosevents.projects.locations.namespaces.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsProjectsLocationsNamespacesGetRequest',
        response_type_name='Namespace',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list namespaces.

      Args:
        request: (AnthoseventsProjectsLocationsNamespacesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNamespacesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/namespaces',
        http_method='GET',
        method_id='anthosevents.projects.locations.namespaces.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='v1/{+parent}/namespaces',
        request_field='',
        request_type_name='AnthoseventsProjectsLocationsNamespacesListRequest',
        response_type_name='ListNamespacesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Rpc to update a namespace.

      Args:
        request: (AnthoseventsProjectsLocationsNamespacesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}',
        http_method='PATCH',
        method_id='anthosevents.projects.locations.namespaces.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='namespace',
        request_type_name='AnthoseventsProjectsLocationsNamespacesPatchRequest',
        response_type_name='Namespace',
        supports_download=False,
    )

    def ReplaceNamespace(self, request, global_params=None):
      r"""Rpc to replace a namespace.

      Args:
        request: (AnthoseventsProjectsLocationsNamespacesReplaceNamespaceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Namespace) The response message.
      """
      config = self.GetMethodConfig('ReplaceNamespace')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceNamespace.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/namespaces/{namespacesId}',
        http_method='PUT',
        method_id='anthosevents.projects.locations.namespaces.replaceNamespace',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='namespace',
        request_type_name='AnthoseventsProjectsLocationsNamespacesReplaceNamespaceRequest',
        response_type_name='Namespace',
        supports_download=False,
    )

  class ProjectsLocationsSecretsService(base_api.BaseApiService):
    """Service class for the projects_locations_secrets resource."""

    _NAME = 'projects_locations_secrets'

    def __init__(self, client):
      super(AnthoseventsV1.ProjectsLocationsSecretsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new secret.

      Args:
        request: (AnthoseventsProjectsLocationsSecretsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Secret) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/secrets',
        http_method='POST',
        method_id='anthosevents.projects.locations.secrets.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/secrets',
        request_field='secret',
        request_type_name='AnthoseventsProjectsLocationsSecretsCreateRequest',
        response_type_name='Secret',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Rpc to delete a secret.

      Args:
        request: (AnthoseventsProjectsLocationsSecretsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/secrets/{secretsId}',
        http_method='DELETE',
        method_id='anthosevents.projects.locations.secrets.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['apiVersion', 'kind', 'propagationPolicy'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsProjectsLocationsSecretsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Rpc to get information about a secret.

      Args:
        request: (AnthoseventsProjectsLocationsSecretsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Secret) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/secrets/{secretsId}',
        http_method='GET',
        method_id='anthosevents.projects.locations.secrets.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='AnthoseventsProjectsLocationsSecretsGetRequest',
        response_type_name='Secret',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Rpc to list secrets.

      Args:
        request: (AnthoseventsProjectsLocationsSecretsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSecretsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/secrets',
        http_method='GET',
        method_id='anthosevents.projects.locations.secrets.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['continue_', 'fieldSelector', 'includeUninitialized', 'labelSelector', 'limit', 'resourceVersion', 'watch'],
        relative_path='v1/{+parent}/secrets',
        request_field='',
        request_type_name='AnthoseventsProjectsLocationsSecretsListRequest',
        response_type_name='ListSecretsResponse',
        supports_download=False,
    )

    def ReplaceSecret(self, request, global_params=None):
      r"""Rpc to replace a secret.

Only the spec and metadata labels and annotations are modifiable. After
the Update request, Cloud Run will work to make the 'status'
match the requested 'spec'.

May provide metadata.resourceVersion to enforce update from last read for
optimistic concurrency control.

      Args:
        request: (AnthoseventsProjectsLocationsSecretsReplaceSecretRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Secret) The response message.
      """
      config = self.GetMethodConfig('ReplaceSecret')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceSecret.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/secrets/{secretsId}',
        http_method='PUT',
        method_id='anthosevents.projects.locations.secrets.replaceSecret',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='secret',
        request_type_name='AnthoseventsProjectsLocationsSecretsReplaceSecretRequest',
        response_type_name='Secret',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(AnthoseventsV1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(AnthoseventsV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
