"""Generated message classes for sql version v1beta4.

API for Cloud SQL database instance management
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'sql'


class AclEntry(_messages.Message):
  r"""An entry for an Access Control list.

  Fields:
    expirationTime: The time when this access control entry expires in <a
      href="https://tools.ietf.org/html/rfc3339">RFC 3339</a> format, for
      example <b>2012-11-15T16:19:00.094Z</b>.
    kind: This is always <b>sql#aclEntry</b>.
    name: Optional. A label to identify this entry.
    value: The whitelisted value for the access control list.
  """

  expirationTime = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3)
  value = _messages.StringField(4)


class ApiWarning(_messages.Message):
  r"""An Admin API warning message.

  Enums:
    CodeValueValuesEnum: Code to uniquely identify the warning type.

  Fields:
    code: Code to uniquely identify the warning type.
    message: The warning message.
  """

  class CodeValueValuesEnum(_messages.Enum):
    r"""Code to uniquely identify the warning type.

    Values:
      SQL_API_WARNING_CODE_UNSPECIFIED: An unknown or unset warning type from
        Cloud SQL API.
      REGION_UNREACHABLE: Warning when one or more regions are not reachable.
        The returned result set may be incomplete.
    """
    SQL_API_WARNING_CODE_UNSPECIFIED = 0
    REGION_UNREACHABLE = 1

  code = _messages.EnumField('CodeValueValuesEnum', 1)
  message = _messages.StringField(2)


class BackupConfiguration(_messages.Message):
  r"""Database instance backup configuration.

  Fields:
    binaryLogEnabled: (MySQL only) Whether binary log is enabled. If backup
      configuration is disabled, binarylog must be disabled as well.
    enabled: Whether this configuration is enabled.
    kind: This is always <b>sql#backupConfiguration</b>.
    location: Location of the backup
    pointInTimeRecoveryEnabled: Reserved for future use.
    replicationLogArchivingEnabled: Reserved for future use.
    startTime: Start time for the daily backup configuration in UTC timezone
      in the 24 hour format - <b>HH:MM</b>.
  """

  binaryLogEnabled = _messages.BooleanField(1)
  enabled = _messages.BooleanField(2)
  kind = _messages.StringField(3)
  location = _messages.StringField(4)
  pointInTimeRecoveryEnabled = _messages.BooleanField(5)
  replicationLogArchivingEnabled = _messages.BooleanField(6)
  startTime = _messages.StringField(7)


class BackupRun(_messages.Message):
  r"""A BackupRun resource.

  Enums:
    BackupKindValueValuesEnum: Specifies the kind of backup, PHYSICAL or
      DEFAULT_SNAPSHOT.
    StatusValueValuesEnum: The status of this run.
    TypeValueValuesEnum: The type of this run; can be either "AUTOMATED" or
      "ON_DEMAND".

  Fields:
    backupKind: Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
    description: The description of this run, only applicable to on-demand
      backups.
    diskEncryptionConfiguration: Encryption configuration specific to a
      backup. Applies only to Second Generation instances.
    diskEncryptionStatus: Encryption status specific to a backup. Applies only
      to Second Generation instances.
    endTime: The time the backup operation completed in UTC timezone in <a
      href="https://tools.ietf.org/html/rfc3339">RFC 3339</a> format, for
      example <b>2012-11-15T16:19:00.094Z</b>.
    enqueuedTime: The time the run was enqueued in UTC timezone in <a
      href="https://tools.ietf.org/html/rfc3339">RFC 3339</a> format, for
      example <b>2012-11-15T16:19:00.094Z</b>.
    error: Information about why the backup operation failed. This is only
      present if the run has the FAILED status.
    id: The identifier for this backup run. Unique only for a specific Cloud
      SQL instance.
    instance: Name of the database instance.
    kind: This is always <b>sql#backupRun</b>.
    location: Location of the backups.
    selfLink: The URI of this resource.
    startTime: The time the backup operation actually started in UTC timezone
      in <a href="https://tools.ietf.org/html/rfc3339">RFC 3339</a> format,
      for example <b>2012-11-15T16:19:00.094Z</b>.
    status: The status of this run.
    type: The type of this run; can be either "AUTOMATED" or "ON_DEMAND".
    windowStartTime: The start time of the backup window during which this the
      backup was attempted in <a
      href="https://tools.ietf.org/html/rfc3339">RFC 3339</a> format, for
      example <b>2012-11-15T16:19:00.094Z</b>.
  """

  class BackupKindValueValuesEnum(_messages.Enum):
    r"""Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.

    Values:
      SQL_BACKUP_KIND_UNSPECIFIED: This is an unknown BackupKind.
      SNAPSHOT: The snapshot based backups
      PHYSICAL: Physical backups
    """
    SQL_BACKUP_KIND_UNSPECIFIED = 0
    SNAPSHOT = 1
    PHYSICAL = 2

  class StatusValueValuesEnum(_messages.Enum):
    r"""The status of this run.

    Values:
      SQL_BACKUP_RUN_STATUS_UNSPECIFIED: The status of the run is unknown.
      ENQUEUED: The backup operation was enqueued.
      OVERDUE: The backup is overdue across a given backup window. Indicates a
        problem. Example: Long-running operation in progress during the whole
        window.
      RUNNING: The backup is in progress.
      FAILED: The backup failed.
      SUCCESSFUL: The backup was successful.
      SKIPPED: The backup was skipped (without problems) for a given backup
        window. Example: Instance was idle.
      DELETION_PENDING: The backup is about to be deleted.
      DELETION_FAILED: The backup deletion failed.
      DELETED: The backup has been deleted.
    """
    SQL_BACKUP_RUN_STATUS_UNSPECIFIED = 0
    ENQUEUED = 1
    OVERDUE = 2
    RUNNING = 3
    FAILED = 4
    SUCCESSFUL = 5
    SKIPPED = 6
    DELETION_PENDING = 7
    DELETION_FAILED = 8
    DELETED = 9

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of this run; can be either "AUTOMATED" or "ON_DEMAND".

    Values:
      SQL_BACKUP_RUN_TYPE_UNSPECIFIED: This is an unknown BackupRun type.
      AUTOMATED: The backup schedule automatically triggers a backup.
      ON_DEMAND: The user manually triggers a backup.
    """
    SQL_BACKUP_RUN_TYPE_UNSPECIFIED = 0
    AUTOMATED = 1
    ON_DEMAND = 2

  backupKind = _messages.EnumField('BackupKindValueValuesEnum', 1)
  description = _messages.StringField(2)
  diskEncryptionConfiguration = _messages.MessageField('DiskEncryptionConfiguration', 3)
  diskEncryptionStatus = _messages.MessageField('DiskEncryptionStatus', 4)
  endTime = _messages.StringField(5)
  enqueuedTime = _messages.StringField(6)
  error = _messages.MessageField('OperationError', 7)
  id = _messages.IntegerField(8)
  instance = _messages.StringField(9)
  kind = _messages.StringField(10)
  location = _messages.StringField(11)
  selfLink = _messages.StringField(12)
  startTime = _messages.StringField(13)
  status = _messages.EnumField('StatusValueValuesEnum', 14)
  type = _messages.EnumField('TypeValueValuesEnum', 15)
  windowStartTime = _messages.StringField(16)


class BackupRunsListResponse(_messages.Message):
  r"""Backup run list results.

  Fields:
    items: A list of backup runs in reverse chronological order of the
      enqueued time.
    kind: This is always <b>sql#backupRunsList</b>.
    nextPageToken: The continuation token, used to page through large result
      sets. Provide this value in a subsequent request to return the next page
      of results.
  """

  items = _messages.MessageField('BackupRun', 1, repeated=True)
  kind = _messages.StringField(2)
  nextPageToken = _messages.StringField(3)


class BinLogCoordinates(_messages.Message):
  r"""Binary log coordinates.

  Fields:
    binLogFileName: Name of the binary log file for a Cloud SQL instance.
    binLogPosition: Position (offset) within the binary log file.
    kind: This is always <b>sql#binLogCoordinates</b>.
  """

  binLogFileName = _messages.StringField(1)
  binLogPosition = _messages.IntegerField(2)
  kind = _messages.StringField(3)


class CloneContext(_messages.Message):
  r"""Database instance clone context.

  Fields:
    binLogCoordinates: Binary log coordinates, if specified, identify the
      position up to which the source instance should be cloned. If not
      specified, the source instance is cloned up to the most recent binary
      log coordinates.
    destinationInstanceName: Name of the Cloud SQL instance to be created as a
      clone.
    kind: This is always <b>sql#cloneContext</b>.
    pitrTimestampMs: Reserved for future use.
    pointInTime: Reserved for future use.
  """

  binLogCoordinates = _messages.MessageField('BinLogCoordinates', 1)
  destinationInstanceName = _messages.StringField(2)
  kind = _messages.StringField(3)
  pitrTimestampMs = _messages.IntegerField(4)
  pointInTime = _messages.StringField(5)


class Database(_messages.Message):
  r"""Represents a SQL database on the Cloud SQL instance.

  Fields:
    charset: The Cloud SQL charset value.
    collation: The Cloud SQL collation value.
    etag: This field is deprecated and will be removed from a future version
      of the API.
    instance: The name of the Cloud SQL instance. This does not include the
      project ID.
    kind: This is always <b>sql#database</b>.
    name: The name of the database in the Cloud SQL instance. This does not
      include the project ID or instance name.
    project: The project ID of the project containing the Cloud SQL database.
      The Google apps domain is prefixed if applicable.
    selfLink: The URI of this resource.
    sqlserverDatabaseDetails: A SqlServerDatabaseDetails attribute.
  """

  charset = _messages.StringField(1)
  collation = _messages.StringField(2)
  etag = _messages.StringField(3)
  instance = _messages.StringField(4)
  kind = _messages.StringField(5)
  name = _messages.StringField(6)
  project = _messages.StringField(7)
  selfLink = _messages.StringField(8)
  sqlserverDatabaseDetails = _messages.MessageField('SqlServerDatabaseDetails', 9)


class DatabaseFlags(_messages.Message):
  r"""Database flags for Cloud SQL instances.

  Fields:
    name: The name of the flag. These flags are passed at instance startup, so
      include both server options and system variables for MySQL. Flags should
      be specified with underscores, not hyphens. For more information, see <a
      href="/sql/docs/mysql/flags">Configuring Database Flags</a> in the Cloud
      SQL documentation.
    value: The value of the flag. Booleans should be set to <b>on</b> for true
      and <b>off</b> for false. This field must be omitted if the flag doesn't
      take a value.
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class DatabaseInstance(_messages.Message):
  r"""A Cloud SQL instance resource. Next field: 34

  Enums:
    BackendTypeValueValuesEnum: <br><b>SECOND_GEN</b>: Cloud SQL database
      instance. <br><b>EXTERNAL</b>: A database server that is not managed by
      Google. <br>This property is read-only; use the <b>tier</b> property in
      the <b>settings</b> object to determine the database type.
    DatabaseVersionValueValuesEnum: The database engine type and version. The
      <b>databaseVersion</b> field cannot be changed after instance creation.
      <br>MySQL instances: <b>MYSQL_5_7</b> (default), or <b>MYSQL_5_6</b>.
      <br>PostgreSQL instances: <b>POSTGRES_9_6</b> (default), or
      <b>POSTGRES_10</b>, or <b>POSTGRES_11 Beta</b>, or <b>POSTGRES_12</b>.
      <br>SQL Server instances: <b>SQLSERVER_2017_STANDARD</b> (default),
      <b>SQLSERVER_2017_ENTERPRISE</b>, <b>SQLSERVER_2017_EXPRESS</b>, or
      <b>SQLSERVER_2017_WEB</b>.
    InstanceTypeValueValuesEnum: The instance type. This can be one of the
      following. <br><b>CLOUD_SQL_INSTANCE</b>: A Cloud SQL instance that is
      not replicating from a master. <br><b>ON_PREMISES_INSTANCE</b>: An
      instance running on the customer's premises.
      <br><b>READ_REPLICA_INSTANCE</b>: A Cloud SQL instance configured as a
      read-replica.
    StateValueValuesEnum: The current serving state of the Cloud SQL instance.
      This can be one of the following. <br><b>RUNNABLE</b>: The instance is
      running, or is ready to run when accessed. <br><b>SUSPENDED</b>: The
      instance is not available, for example due to problems with billing.
      <br><b>PENDING_CREATE</b>: The instance is being created.
      <br><b>MAINTENANCE</b>: The instance is down for maintenance.
      <br><b>FAILED</b>: The instance creation failed.
      <br><b>UNKNOWN_STATE</b>: The state of the instance is unknown.
    SuspensionReasonValueListEntryValuesEnum:

  Messages:
    FailoverReplicaValue: The name and status of the failover replica. This
      property is applicable only to Second Generation instances.

  Fields:
    backendType: <br><b>SECOND_GEN</b>: Cloud SQL database instance.
      <br><b>EXTERNAL</b>: A database server that is not managed by Google.
      <br>This property is read-only; use the <b>tier</b> property in the
      <b>settings</b> object to determine the database type.
    connectionName: Connection name of the Cloud SQL instance used in
      connection strings.
    currentDiskSize: The current disk usage of the instance in bytes. This
      property has been deprecated. Users should use the
      "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
      Monitoring API instead. Please see <a
      href="https://groups.google.com/d/msg/google-cloud-sql-
      announce/I_7-F9EBhT0/BtvFtdFeAgAJ">this announcement</a> for details.
    databaseVersion: The database engine type and version. The
      <b>databaseVersion</b> field cannot be changed after instance creation.
      <br>MySQL instances: <b>MYSQL_5_7</b> (default), or <b>MYSQL_5_6</b>.
      <br>PostgreSQL instances: <b>POSTGRES_9_6</b> (default), or
      <b>POSTGRES_10</b>, or <b>POSTGRES_11 Beta</b>, or <b>POSTGRES_12</b>.
      <br>SQL Server instances: <b>SQLSERVER_2017_STANDARD</b> (default),
      <b>SQLSERVER_2017_ENTERPRISE</b>, <b>SQLSERVER_2017_EXPRESS</b>, or
      <b>SQLSERVER_2017_WEB</b>.
    diskEncryptionConfiguration: Disk encryption configuration specific to an
      instance. Applies only to Second Generation instances.
    diskEncryptionStatus: Disk encryption status specific to an instance.
      Applies only to Second Generation instances.
    etag: This field is deprecated and will be removed from a future version
      of the API. Use the <b>settings.settingsVersion</b> field instead.
    failoverReplica: The name and status of the failover replica. This
      property is applicable only to Second Generation instances.
    gceZone: The Compute Engine zone that the instance is currently serving
      from. This value could be different from the zone that was specified
      when the instance was created if the instance has failed over to its
      secondary zone.
    instanceType: The instance type. This can be one of the following.
      <br><b>CLOUD_SQL_INSTANCE</b>: A Cloud SQL instance that is not
      replicating from a master. <br><b>ON_PREMISES_INSTANCE</b>: An instance
      running on the customer's premises. <br><b>READ_REPLICA_INSTANCE</b>: A
      Cloud SQL instance configured as a read-replica.
    ipAddresses: The assigned IP addresses for the instance.
    ipv6Address: The IPv6 address assigned to the instance. (Deprecated) This
      property was applicable only to First Generation instances.
    kind: This is always <b>sql#instance</b>.
    masterInstanceName: The name of the instance which will act as master in
      the replication setup.
    maxDiskSize: The maximum disk size of the instance in bytes.
    name: Name of the Cloud SQL instance. This does not include the project
      ID.
    onPremisesConfiguration: Configuration specific to on-premises instances.
    project: The project ID of the project containing the Cloud SQL instance.
      The Google apps domain is prefixed if applicable.
    region: The geographical region. Can be <br><b>us-central</b>
      (<b>FIRST_GEN</b> instances only) <br><b>us-central1</b>
      (<b>SECOND_GEN</b> instances only) <br><b>asia-east1</b> or <b>europe-
      west1</b>. <br>Defaults to <b>us-central</b> or <b>us-central1</b>
      depending on the instance type. The region cannot be changed after
      instance creation.
    replicaConfiguration: Configuration specific to failover replicas and read
      replicas.
    replicaNames: The replicas of the instance.
    rootPassword: Initial root password. Use only on creation.
    scheduledMaintenance: The start time of any upcoming scheduled maintenance
      for this instance.
    selfLink: The URI of this resource.
    serverCaCert: SSL configuration.
    serviceAccountEmailAddress: The service account email address assigned to
      the instance. This property is applicable only to Second Generation
      instances.
    settings: The user settings.
    state: The current serving state of the Cloud SQL instance. This can be
      one of the following. <br><b>RUNNABLE</b>: The instance is running, or
      is ready to run when accessed. <br><b>SUSPENDED</b>: The instance is not
      available, for example due to problems with billing.
      <br><b>PENDING_CREATE</b>: The instance is being created.
      <br><b>MAINTENANCE</b>: The instance is down for maintenance.
      <br><b>FAILED</b>: The instance creation failed.
      <br><b>UNKNOWN_STATE</b>: The state of the instance is unknown.
    suspensionReason: If the instance state is SUSPENDED, the reason for the
      suspension.
  """

  class BackendTypeValueValuesEnum(_messages.Enum):
    r"""<br><b>SECOND_GEN</b>: Cloud SQL database instance.
    <br><b>EXTERNAL</b>: A database server that is not managed by Google.
    <br>This property is read-only; use the <b>tier</b> property in the
    <b>settings</b> object to determine the database type.

    Values:
      SQL_BACKEND_TYPE_UNSPECIFIED: This is an unknown backend type for
        instance.
      FIRST_GEN: V1 speckle instance.
      SECOND_GEN: V2 speckle instance.
      EXTERNAL: On premises instance.
    """
    SQL_BACKEND_TYPE_UNSPECIFIED = 0
    FIRST_GEN = 1
    SECOND_GEN = 2
    EXTERNAL = 3

  class DatabaseVersionValueValuesEnum(_messages.Enum):
    r"""The database engine type and version. The <b>databaseVersion</b> field
    cannot be changed after instance creation. <br>MySQL instances:
    <b>MYSQL_5_7</b> (default), or <b>MYSQL_5_6</b>. <br>PostgreSQL instances:
    <b>POSTGRES_9_6</b> (default), or <b>POSTGRES_10</b>, or <b>POSTGRES_11
    Beta</b>, or <b>POSTGRES_12</b>. <br>SQL Server instances:
    <b>SQLSERVER_2017_STANDARD</b> (default),
    <b>SQLSERVER_2017_ENTERPRISE</b>, <b>SQLSERVER_2017_EXPRESS</b>, or
    <b>SQLSERVER_2017_WEB</b>.

    Values:
      SQL_DATABASE_VERSION_UNSPECIFIED: This is an unknown database version.
      MYSQL_5_1: The database version is MySQL 5.1.
      MYSQL_5_5: The database version is MySQL 5.5.
      MYSQL_5_6: The database version is MySQL 5.6.
      MYSQL_5_7: The database version is MySQL 5.7.
      POSTGRES_9_6: The database version is PostgreSQL 9.6.
      POSTGRES_11: The database version is PostgreSQL 11.
      SQLSERVER_2017_STANDARD: The database version is SQL Server 2017
        Standard.
      SQLSERVER_2017_ENTERPRISE: The database version is SQL Server 2017
        Enterprise.
      SQLSERVER_2017_EXPRESS: The database version is SQL Server 2017 Express.
      SQLSERVER_2017_WEB: The database version is SQL Server 2017 Web.
      POSTGRES_10: The database version is PostgreSQL 10.
      POSTGRES_12: The database version is PostgreSQL 12.
      MYSQL_8_0: The database version is MySQL 8.
    """
    SQL_DATABASE_VERSION_UNSPECIFIED = 0
    MYSQL_5_1 = 1
    MYSQL_5_5 = 2
    MYSQL_5_6 = 3
    MYSQL_5_7 = 4
    POSTGRES_9_6 = 5
    POSTGRES_11 = 6
    SQLSERVER_2017_STANDARD = 7
    SQLSERVER_2017_ENTERPRISE = 8
    SQLSERVER_2017_EXPRESS = 9
    SQLSERVER_2017_WEB = 10
    POSTGRES_10 = 11
    POSTGRES_12 = 12
    MYSQL_8_0 = 13

  class InstanceTypeValueValuesEnum(_messages.Enum):
    r"""The instance type. This can be one of the following.
    <br><b>CLOUD_SQL_INSTANCE</b>: A Cloud SQL instance that is not
    replicating from a master. <br><b>ON_PREMISES_INSTANCE</b>: An instance
    running on the customer's premises. <br><b>READ_REPLICA_INSTANCE</b>: A
    Cloud SQL instance configured as a read-replica.

    Values:
      SQL_INSTANCE_TYPE_UNSPECIFIED: This is an unknown Cloud SQL instance
        type.
      CLOUD_SQL_INSTANCE: A regular Cloud SQL instance.
      ON_PREMISES_INSTANCE: An instance running on the customer's premises
        that is not managed by Cloud SQL.
      READ_REPLICA_INSTANCE: A Cloud SQL instance acting as a read-replica.
    """
    SQL_INSTANCE_TYPE_UNSPECIFIED = 0
    CLOUD_SQL_INSTANCE = 1
    ON_PREMISES_INSTANCE = 2
    READ_REPLICA_INSTANCE = 3

  class StateValueValuesEnum(_messages.Enum):
    r"""The current serving state of the Cloud SQL instance. This can be one
    of the following. <br><b>RUNNABLE</b>: The instance is running, or is
    ready to run when accessed. <br><b>SUSPENDED</b>: The instance is not
    available, for example due to problems with billing.
    <br><b>PENDING_CREATE</b>: The instance is being created.
    <br><b>MAINTENANCE</b>: The instance is down for maintenance.
    <br><b>FAILED</b>: The instance creation failed. <br><b>UNKNOWN_STATE</b>:
    The state of the instance is unknown.

    Values:
      SQL_INSTANCE_STATE_UNSPECIFIED: The state of the instance is unknown.
      RUNNABLE: The instance is running.
      SUSPENDED: The instance is currently offline, but it may run again in
        the future.
      PENDING_DELETE: The instance is being deleted.
      PENDING_CREATE: The instance is being created.
      MAINTENANCE: The instance is down for maintenance.
      FAILED: The instance failed to be created.
    """
    SQL_INSTANCE_STATE_UNSPECIFIED = 0
    RUNNABLE = 1
    SUSPENDED = 2
    PENDING_DELETE = 3
    PENDING_CREATE = 4
    MAINTENANCE = 5
    FAILED = 6

  class SuspensionReasonValueListEntryValuesEnum(_messages.Enum):
    r"""SuspensionReasonValueListEntryValuesEnum enum type.

    Values:
      SQL_SUSPENSION_REASON_UNSPECIFIED: <no description>
      BILLING_ISSUE: <no description>
      LEGAL_ISSUE: <no description>
      OPERATIONAL_ISSUE: <no description>
      KMS_KEY_ISSUE: <no description>
    """
    SQL_SUSPENSION_REASON_UNSPECIFIED = 0
    BILLING_ISSUE = 1
    LEGAL_ISSUE = 2
    OPERATIONAL_ISSUE = 3
    KMS_KEY_ISSUE = 4

  class FailoverReplicaValue(_messages.Message):
    r"""The name and status of the failover replica. This property is
    applicable only to Second Generation instances.

    Fields:
      available: The availability status of the failover replica. A false
        status indicates that the failover replica is out of sync. The master
        can only failover to the failover replica when the status is true.
      name: The name of the failover replica. If specified at instance
        creation, a failover replica is created for the instance. The name
        doesn't include the project ID. This property is applicable only to
        Second Generation instances.
    """

    available = _messages.BooleanField(1)
    name = _messages.StringField(2)

  backendType = _messages.EnumField('BackendTypeValueValuesEnum', 1)
  connectionName = _messages.StringField(2)
  currentDiskSize = _messages.IntegerField(3)
  databaseVersion = _messages.EnumField('DatabaseVersionValueValuesEnum', 4)
  diskEncryptionConfiguration = _messages.MessageField('DiskEncryptionConfiguration', 5)
  diskEncryptionStatus = _messages.MessageField('DiskEncryptionStatus', 6)
  etag = _messages.StringField(7)
  failoverReplica = _messages.MessageField('FailoverReplicaValue', 8)
  gceZone = _messages.StringField(9)
  instanceType = _messages.EnumField('InstanceTypeValueValuesEnum', 10)
  ipAddresses = _messages.MessageField('IpMapping', 11, repeated=True)
  ipv6Address = _messages.StringField(12)
  kind = _messages.StringField(13)
  masterInstanceName = _messages.StringField(14)
  maxDiskSize = _messages.IntegerField(15)
  name = _messages.StringField(16)
  onPremisesConfiguration = _messages.MessageField('OnPremisesConfiguration', 17)
  project = _messages.StringField(18)
  region = _messages.StringField(19)
  replicaConfiguration = _messages.MessageField('ReplicaConfiguration', 20)
  replicaNames = _messages.StringField(21, repeated=True)
  rootPassword = _messages.StringField(22)
  scheduledMaintenance = _messages.MessageField('SqlScheduledMaintenance', 23)
  selfLink = _messages.StringField(24)
  serverCaCert = _messages.MessageField('SslCert', 25)
  serviceAccountEmailAddress = _messages.StringField(26)
  settings = _messages.MessageField('Settings', 27)
  state = _messages.EnumField('StateValueValuesEnum', 28)
  suspensionReason = _messages.EnumField('SuspensionReasonValueListEntryValuesEnum', 29, repeated=True)


class DatabasesListResponse(_messages.Message):
  r"""Database list response.

  Fields:
    items: List of database resources in the instance.
    kind: This is always <b>sql#databasesList</b>.
  """

  items = _messages.MessageField('Database', 1, repeated=True)
  kind = _messages.StringField(2)


class DemoteMasterConfiguration(_messages.Message):
  r"""Read-replica configuration for connecting to the on-premises master.

  Fields:
    kind: This is always <b>sql#demoteMasterConfiguration</b>.
    mysqlReplicaConfiguration: MySQL specific configuration when replicating
      from a MySQL on-premises master. Replication configuration information
      such as the username, password, certificates, and keys are not stored in
      the instance metadata. The configuration information is used only to set
      up the replication connection and is stored by MySQL in a file named
      <b>master.info</b> in the data directory.
  """

  kind = _messages.StringField(1)
  mysqlReplicaConfiguration = _messages.MessageField('DemoteMasterMySqlReplicaConfiguration', 2)


class DemoteMasterContext(_messages.Message):
  r"""Database instance demote master context.

  Fields:
    kind: This is always <b>sql#demoteMasterContext</b>.
    masterInstanceName: The name of the instance which will act as on-premises
      master in the replication setup.
    replicaConfiguration: Configuration specific to read-replicas replicating
      from the on-premises master.
    verifyGtidConsistency: Verify GTID consistency for demote operation.
      Default value: <b>True</b>. Second Generation instances only.  Setting
      this flag to false enables you to bypass GTID consistency check between
      on-premises master and Cloud SQL instance during the demotion operation
      but also exposes you to the risk of future replication failures. Change
      the value only if you know the reason for the GTID divergence and are
      confident that doing so will not cause any replication issues.
  """

  kind = _messages.StringField(1)
  masterInstanceName = _messages.StringField(2)
  replicaConfiguration = _messages.MessageField('DemoteMasterConfiguration', 3)
  verifyGtidConsistency = _messages.BooleanField(4)


class DemoteMasterMySqlReplicaConfiguration(_messages.Message):
  r"""Read-replica configuration specific to MySQL databases.

  Fields:
    caCertificate: PEM representation of the trusted CA's x509 certificate.
    clientCertificate: PEM representation of the slave's x509 certificate.
    clientKey: PEM representation of the slave's private key. The
      corresponsing public key is encoded in the client's certificate. The
      format of the slave's private key can be either PKCS #1 or PKCS #8.
    kind: This is always <b>sql#demoteMasterMysqlReplicaConfiguration</b>.
    password: The password for the replication connection.
    username: The username for the replication connection.
  """

  caCertificate = _messages.StringField(1)
  clientCertificate = _messages.StringField(2)
  clientKey = _messages.StringField(3)
  kind = _messages.StringField(4)
  password = _messages.StringField(5)
  username = _messages.StringField(6)


class DiskEncryptionConfiguration(_messages.Message):
  r"""Disk encryption configuration for an instance.

  Fields:
    kind: This is always <b>sql#diskEncryptionConfiguration</b>.
    kmsKeyName: Resource name of KMS key for disk encryption
  """

  kind = _messages.StringField(1)
  kmsKeyName = _messages.StringField(2)


class DiskEncryptionStatus(_messages.Message):
  r"""Disk encryption status for an instance.

  Fields:
    kind: This is always <b>sql#diskEncryptionStatus</b>.
    kmsKeyVersionName: KMS key version used to encrypt the Cloud SQL instance
      resource
  """

  kind = _messages.StringField(1)
  kmsKeyVersionName = _messages.StringField(2)


class ExportContext(_messages.Message):
  r"""Database instance export context.

  Enums:
    FileTypeValueValuesEnum: The file type for the specified uri.
      <br><b>SQL</b>: The file contains SQL statements. <br><b>CSV</b>: The
      file contains CSV data.

  Messages:
    CsvExportOptionsValue: Options for exporting data as CSV.
    SqlExportOptionsValue: Options for exporting data as SQL statements.

  Fields:
    csvExportOptions: Options for exporting data as CSV.
    databases: Databases to be exported. <br /> <b>MySQL instances:</b> If
      <b>fileType</b> is <b>SQL</b> and no database is specified, all
      databases are exported, except for the <b>mysql</b> system database. If
      <b>fileType</b> is <b>CSV</b>, you can specify one database, either by
      using this property or by using the <b>csvExportOptions.selectQuery</b>
      property, which takes precedence over this property. <br />
      <b>PostgreSQL instances:</b> You must specify one database to be
      exported. If <b>fileType</b> is <b>CSV</b>, this database must match the
      one specified in the <b>csvExportOptions.selectQuery</b> property.
    fileType: The file type for the specified uri. <br><b>SQL</b>: The file
      contains SQL statements. <br><b>CSV</b>: The file contains CSV data.
    kind: This is always <b>sql#exportContext</b>.
    sqlExportOptions: Options for exporting data as SQL statements.
    uri: The path to the file in Google Cloud Storage where the export will be
      stored. The URI is in the form <b>gs: //bucketName/fileName</b>. If the
      file already exists, the requests // succeeds, but the operation fails.
      If <b>fileType</b> is // <b>SQL</b> and the filename ends with .gz, the
      contents are // compressed.
  """

  class FileTypeValueValuesEnum(_messages.Enum):
    r"""The file type for the specified uri. <br><b>SQL</b>: The file contains
    SQL statements. <br><b>CSV</b>: The file contains CSV data.

    Values:
      SQL_FILE_TYPE_UNSPECIFIED: Unknown file type.
      SQL: File containing SQL statements.
      CSV: File in CSV format.
      BAK: <no description>
    """
    SQL_FILE_TYPE_UNSPECIFIED = 0
    SQL = 1
    CSV = 2
    BAK = 3

  class CsvExportOptionsValue(_messages.Message):
    r"""Options for exporting data as CSV.

    Fields:
      selectQuery: The select query used to extract the data.
    """

    selectQuery = _messages.StringField(1)

  class SqlExportOptionsValue(_messages.Message):
    r"""Options for exporting data as SQL statements.

    Messages:
      MysqlExportOptionsValue: Options for exporting from MySQL.

    Fields:
      mysqlExportOptions: Options for exporting from MySQL.
      schemaOnly: Export only schemas.
      tables: Tables to export, or that were exported, from the specified
        database. If you specify tables, specify one and only one database.
        For PostgreSQL instances, you can specify only one table.
    """

    class MysqlExportOptionsValue(_messages.Message):
      r"""Options for exporting from MySQL.

      Fields:
        masterData: Option to include SQL statement required to set up
          replication. <br>If set to <b>1</b>, the dump file includes  a
          CHANGE MASTER TO statement with the binary log coordinates. <br>If
          set to <b>2</b>, the CHANGE MASTER TO statement is written as  a SQL
          comment, and has no effect. All other values are ignored.
      """

      masterData = _messages.IntegerField(1, variant=_messages.Variant.INT32)

    mysqlExportOptions = _messages.MessageField('MysqlExportOptionsValue', 1)
    schemaOnly = _messages.BooleanField(2)
    tables = _messages.StringField(3, repeated=True)

  csvExportOptions = _messages.MessageField('CsvExportOptionsValue', 1)
  databases = _messages.StringField(2, repeated=True)
  fileType = _messages.EnumField('FileTypeValueValuesEnum', 3)
  kind = _messages.StringField(4)
  sqlExportOptions = _messages.MessageField('SqlExportOptionsValue', 5)
  uri = _messages.StringField(6)


class FailoverContext(_messages.Message):
  r"""Database instance failover context.

  Fields:
    kind: This is always <b>sql#failoverContext</b>.
    settingsVersion: The current settings version of this instance. Request
      will be rejected if this version doesn't match the current settings
      version.
  """

  kind = _messages.StringField(1)
  settingsVersion = _messages.IntegerField(2)


class Flag(_messages.Message):
  r"""A flag resource.

  Enums:
    AppliesToValueListEntryValuesEnum:
    TypeValueValuesEnum: The type of the flag. Flags are typed to being
      <b>BOOLEAN</b>, <b>STRING</b>, <b>INTEGER</b> or <b>NONE</b>.
      <b>NONE</b> is used for flags which do not take a value, such as
      <b>skip_grant_tables</b>.

  Fields:
    allowedIntValues: Use this field if only certain integers are accepted.
      Can be combined with min_value and max_value to add additional values.
    allowedStringValues: For <b>STRING</b> flags, a list of strings that the
      value can be set to.
    appliesTo: The database version this flag applies to. Can be
      <b>MYSQL_5_5</b>, <b>MYSQL_5_6</b>, or <b>MYSQL_5_7</b>.
      <b>MYSQL_5_7</b> is applicable only to Second Generation instances.
    inBeta: Whether or not the flag is considered in beta.
    kind: This is always <b>sql#flag</b>.
    maxValue: For <b>INTEGER</b> flags, the maximum allowed value.
    minValue: For <b>INTEGER</b> flags, the minimum allowed value.
    name: This is the name of the flag. Flag names always use underscores, not
      hyphens, e.g. <b>max_allowed_packet</b>
    requiresRestart: Indicates whether changing this flag will trigger a
      database restart. Only applicable to Second Generation instances.
    type: The type of the flag. Flags are typed to being <b>BOOLEAN</b>,
      <b>STRING</b>, <b>INTEGER</b> or <b>NONE</b>. <b>NONE</b> is used for
      flags which do not take a value, such as <b>skip_grant_tables</b>.
  """

  class AppliesToValueListEntryValuesEnum(_messages.Enum):
    r"""AppliesToValueListEntryValuesEnum enum type.

    Values:
      SQL_DATABASE_VERSION_UNSPECIFIED: <no description>
      MYSQL_5_1: <no description>
      MYSQL_5_5: <no description>
      MYSQL_5_6: <no description>
      MYSQL_5_7: <no description>
      POSTGRES_9_6: <no description>
      POSTGRES_11: <no description>
      SQLSERVER_2017_STANDARD: <no description>
      SQLSERVER_2017_ENTERPRISE: <no description>
      SQLSERVER_2017_EXPRESS: <no description>
      SQLSERVER_2017_WEB: <no description>
      POSTGRES_10: <no description>
      POSTGRES_12: <no description>
      MYSQL_8_0: <no description>
    """
    SQL_DATABASE_VERSION_UNSPECIFIED = 0
    MYSQL_5_1 = 1
    MYSQL_5_5 = 2
    MYSQL_5_6 = 3
    MYSQL_5_7 = 4
    POSTGRES_9_6 = 5
    POSTGRES_11 = 6
    SQLSERVER_2017_STANDARD = 7
    SQLSERVER_2017_ENTERPRISE = 8
    SQLSERVER_2017_EXPRESS = 9
    SQLSERVER_2017_WEB = 10
    POSTGRES_10 = 11
    POSTGRES_12 = 12
    MYSQL_8_0 = 13

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of the flag. Flags are typed to being <b>BOOLEAN</b>,
    <b>STRING</b>, <b>INTEGER</b> or <b>NONE</b>. <b>NONE</b> is used for
    flags which do not take a value, such as <b>skip_grant_tables</b>.

    Values:
      SQL_FLAG_TYPE_UNSPECIFIED: This is an unknown flag type.
      BOOLEAN: Boolean type flag.
      STRING: String type flag.
      INTEGER: Integer type flag.
      NONE: Flag type used for a server startup option.
      MYSQL_TIMEZONE_OFFSET: Type introduced specically for MySQL TimeZone
        offset. Accept a string value with the format [-12:59, 13:00].
      FLOAT: Float type flag.
      REPEATED_STRING: Comma-separated list of the strings in a SqlFlagType
        enum.
    """
    SQL_FLAG_TYPE_UNSPECIFIED = 0
    BOOLEAN = 1
    STRING = 2
    INTEGER = 3
    NONE = 4
    MYSQL_TIMEZONE_OFFSET = 5
    FLOAT = 6
    REPEATED_STRING = 7

  allowedIntValues = _messages.IntegerField(1, repeated=True)
  allowedStringValues = _messages.StringField(2, repeated=True)
  appliesTo = _messages.EnumField('AppliesToValueListEntryValuesEnum', 3, repeated=True)
  inBeta = _messages.BooleanField(4)
  kind = _messages.StringField(5)
  maxValue = _messages.IntegerField(6)
  minValue = _messages.IntegerField(7)
  name = _messages.StringField(8)
  requiresRestart = _messages.BooleanField(9)
  type = _messages.EnumField('TypeValueValuesEnum', 10)


class FlagsListResponse(_messages.Message):
  r"""Flags list response.

  Fields:
    items: List of flags.
    kind: This is always <b>sql#flagsList</b>.
  """

  items = _messages.MessageField('Flag', 1, repeated=True)
  kind = _messages.StringField(2)


class ImportContext(_messages.Message):
  r"""Database instance import context.

  Enums:
    FileTypeValueValuesEnum: The file type for the specified uri.
      <br><b>SQL</b>: The file contains SQL statements. <br><b>CSV</b>: The
      file contains CSV data.

  Messages:
    BakImportOptionsValue: Import parameters specific to SQL Server .BAK files
    CsvImportOptionsValue: Options for importing data as CSV.

  Fields:
    bakImportOptions: Import parameters specific to SQL Server .BAK files
    csvImportOptions: Options for importing data as CSV.
    database: The target database for the import. If <b>fileType</b> is
      <b>SQL</b>, this field is required only if the import file does not
      specify a database, and is overridden by any database specification in
      the import file. If <b>fileType</b> is <b>CSV</b>, one database must be
      specified.
    fileType: The file type for the specified uri. <br><b>SQL</b>: The file
      contains SQL statements. <br><b>CSV</b>: The file contains CSV data.
    importUser: The PostgreSQL user for this import operation. PostgreSQL
      instances only.
    kind: This is always <b>sql#importContext</b>.
    uri: Path to the import file in Cloud Storage, in the form <b>gs:
      //bucketName/fileName</b>. Compressed gzip files (.gz) are supported //
      when <b>fileType</b> is <b>SQL</b>. The instance must have // write
      permissions to the bucket and read access to the file.
  """

  class FileTypeValueValuesEnum(_messages.Enum):
    r"""The file type for the specified uri. <br><b>SQL</b>: The file contains
    SQL statements. <br><b>CSV</b>: The file contains CSV data.

    Values:
      SQL_FILE_TYPE_UNSPECIFIED: Unknown file type.
      SQL: File containing SQL statements.
      CSV: File in CSV format.
      BAK: <no description>
    """
    SQL_FILE_TYPE_UNSPECIFIED = 0
    SQL = 1
    CSV = 2
    BAK = 3

  class BakImportOptionsValue(_messages.Message):
    r"""Import parameters specific to SQL Server .BAK files

    Messages:
      EncryptionOptionsValue: A EncryptionOptionsValue object.

    Fields:
      encryptionOptions: A EncryptionOptionsValue attribute.
    """

    class EncryptionOptionsValue(_messages.Message):
      r"""A EncryptionOptionsValue object.

      Fields:
        certPath: Path to the Certificate (.cer) in Cloud Storage, in the form
          <b>gs://bucketName/fileName</b>. The instance must have write
          permissions to the bucket and read access to the file.
        pvkPassword: Password that encrypts the private key
        pvkPath: Path to the Certificate Private Key (.pvk)  in Cloud Storage,
          in the form <b>gs://bucketName/fileName</b>. The instance must have
          write permissions to the bucket and read access to the file.
      """

      certPath = _messages.StringField(1)
      pvkPassword = _messages.StringField(2)
      pvkPath = _messages.StringField(3)

    encryptionOptions = _messages.MessageField('EncryptionOptionsValue', 1)

  class CsvImportOptionsValue(_messages.Message):
    r"""Options for importing data as CSV.

    Fields:
      columns: The columns to which CSV data is imported. If not specified,
        all columns of the database table are loaded with CSV data.
      table: The table to which CSV data is imported.
    """

    columns = _messages.StringField(1, repeated=True)
    table = _messages.StringField(2)

  bakImportOptions = _messages.MessageField('BakImportOptionsValue', 1)
  csvImportOptions = _messages.MessageField('CsvImportOptionsValue', 2)
  database = _messages.StringField(3)
  fileType = _messages.EnumField('FileTypeValueValuesEnum', 4)
  importUser = _messages.StringField(5)
  kind = _messages.StringField(6)
  uri = _messages.StringField(7)


class InstancesCloneRequest(_messages.Message):
  r"""Database instance clone request.

  Fields:
    cloneContext: Contains details about the clone operation.
  """

  cloneContext = _messages.MessageField('CloneContext', 1)


class InstancesDemoteMasterRequest(_messages.Message):
  r"""Database demote master request.

  Fields:
    demoteMasterContext: Contains details about the demoteMaster operation.
  """

  demoteMasterContext = _messages.MessageField('DemoteMasterContext', 1)


class InstancesExportRequest(_messages.Message):
  r"""Database instance export request.

  Fields:
    exportContext: Contains details about the export operation.
  """

  exportContext = _messages.MessageField('ExportContext', 1)


class InstancesFailoverRequest(_messages.Message):
  r"""Instance failover request.

  Fields:
    failoverContext: Failover Context.
  """

  failoverContext = _messages.MessageField('FailoverContext', 1)


class InstancesImportRequest(_messages.Message):
  r"""Database instance import request.

  Fields:
    importContext: Contains details about the import operation.
  """

  importContext = _messages.MessageField('ImportContext', 1)


class InstancesListResponse(_messages.Message):
  r"""Database instances list response.

  Fields:
    items: List of database instance resources.
    kind: This is always <b>sql#instancesList</b>.
    nextPageToken: The continuation token, used to page through large result
      sets. Provide this value in a subsequent request to return the next page
      of results.
    warnings: List of warnings that occurred while handling the request.
  """

  items = _messages.MessageField('DatabaseInstance', 1, repeated=True)
  kind = _messages.StringField(2)
  nextPageToken = _messages.StringField(3)
  warnings = _messages.MessageField('ApiWarning', 4, repeated=True)


class InstancesListServerCasResponse(_messages.Message):
  r"""Instances ListServerCas response.

  Fields:
    activeVersion: A string attribute.
    certs: List of server CA certificates for the instance.
    kind: This is always <b>sql#instancesListServerCas</b>.
  """

  activeVersion = _messages.StringField(1)
  certs = _messages.MessageField('SslCert', 2, repeated=True)
  kind = _messages.StringField(3)


class InstancesRestoreBackupRequest(_messages.Message):
  r"""Database instance restore backup request.

  Fields:
    restoreBackupContext: Parameters required to perform the restore backup
      operation.
  """

  restoreBackupContext = _messages.MessageField('RestoreBackupContext', 1)


class InstancesRotateServerCaRequest(_messages.Message):
  r"""Rotate Server CA request.

  Fields:
    rotateServerCaContext: Contains details about the rotate server CA
      operation.
  """

  rotateServerCaContext = _messages.MessageField('RotateServerCaContext', 1)


class InstancesTruncateLogRequest(_messages.Message):
  r"""Instance truncate log request.

  Fields:
    truncateLogContext: Contains details about the truncate log operation.
  """

  truncateLogContext = _messages.MessageField('TruncateLogContext', 1)


class IpConfiguration(_messages.Message):
  r"""IP Management configuration.

  Fields:
    authorizedNetworks: The list of external networks that are allowed to
      connect to the instance using the IP. In 'CIDR' notation, also known as
      'slash' notation (e.g. <b>192.168.100.0/24</b>).
    ipv4Enabled: Whether the instance should be assigned an IP address or not.
    privateNetwork: The resource link for the VPC network from which the Cloud
      SQL instance is accessible for private IP. For example,
      <b>/projects/myProject/global/networks/default</b>. This setting can be
      updated, but it cannot be removed after it is set.
    requireSsl: Whether SSL connections over IP should be enforced or not.
  """

  authorizedNetworks = _messages.MessageField('AclEntry', 1, repeated=True)
  ipv4Enabled = _messages.BooleanField(2)
  privateNetwork = _messages.StringField(3)
  requireSsl = _messages.BooleanField(4)


class IpMapping(_messages.Message):
  r"""Database instance IP Mapping.

  Enums:
    TypeValueValuesEnum: The type of this IP address. A <b>PRIMARY</b> address
      is a public address that can accept incoming connections. A
      <b>PRIVATE</b> address is a private address that can accept incoming
      connections. An <b>OUTGOING</b> address is the source address of
      connections originating from the instance, if supported.

  Fields:
    ipAddress: The IP address assigned.
    timeToRetire: The due time for this IP to be retired in <a
      href="https://tools.ietf.org/html/rfc3339">RFC 3339</a> format, for
      example <b>2012-11-15T16:19:00.094Z</b>. This field is only available
      when the IP is scheduled to be retired.
    type: The type of this IP address. A <b>PRIMARY</b> address is a public
      address that can accept incoming connections. A <b>PRIVATE</b> address
      is a private address that can accept incoming connections. An
      <b>OUTGOING</b> address is the source address of connections originating
      from the instance, if supported.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of this IP address. A <b>PRIMARY</b> address is a public
    address that can accept incoming connections. A <b>PRIVATE</b> address is
    a private address that can accept incoming connections. An <b>OUTGOING</b>
    address is the source address of connections originating from the
    instance, if supported.

    Values:
      SQL_IP_ADDRESS_TYPE_UNSPECIFIED: This is an unknown IP address type.
      PRIMARY: IP address the customer is supposed to connect to. Usually this
        is the load balancer's IP address
      OUTGOING: Source IP address of the connection a read replica establishes
        to its external master. This IP address can be whitelisted by the
        customer in case it has a firewall that filters incoming connection to
        its on premises master.
      PRIVATE: Private IP used when using private IPs and network peering.
      MIGRATED_1ST_GEN: V1 IP of a migrated instance. We want the user to
        decommission this IP as soon as the migration is complete. Note: V1
        instances with V1 ip addresses will be counted as PRIMARY.
    """
    SQL_IP_ADDRESS_TYPE_UNSPECIFIED = 0
    PRIMARY = 1
    OUTGOING = 2
    PRIVATE = 3
    MIGRATED_1ST_GEN = 4

  ipAddress = _messages.StringField(1)
  timeToRetire = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class LocationPreference(_messages.Message):
  r"""Preferred location. This specifies where a Cloud SQL instance should
  preferably be located, either in a specific Compute Engine zone, or co-
  located with an App Engine application. Note that if the preferred location
  is not available, the instance will be located as close as possible within
  the region. Only one location may be specified.

  Fields:
    followGaeApplication: The App Engine application to follow, it must be in
      the same region as the Cloud SQL instance.
    kind: This is always <b>sql#locationPreference</b>.
    zone: The preferred Compute Engine zone (e.g. us-central1-a, us-
      central1-b, etc.).
  """

  followGaeApplication = _messages.StringField(1)
  kind = _messages.StringField(2)
  zone = _messages.StringField(3)


class MaintenanceWindow(_messages.Message):
  r"""Maintenance window. This specifies when a v2 Cloud SQL instance should
  preferably be restarted for system maintenance purposes.

  Enums:
    UpdateTrackValueValuesEnum: Maintenance timing setting: <b>canary</b>
      (Earlier) or <b>stable</b> (Later). <br /><a
      href="/sql/docs/db_path/instance-settings#maintenance-timing-2ndgen">
      Learn more</a>.

  Fields:
    day: day of week (1-7), starting on Monday.
    hour: hour of day - 0 to 23.
    kind: This is always <b>sql#maintenanceWindow</b>.
    updateTrack: Maintenance timing setting: <b>canary</b> (Earlier) or
      <b>stable</b> (Later). <br /><a href="/sql/docs/db_path/instance-
      settings#maintenance-timing-2ndgen"> Learn more</a>.
  """

  class UpdateTrackValueValuesEnum(_messages.Enum):
    r"""Maintenance timing setting: <b>canary</b> (Earlier) or <b>stable</b>
    (Later). <br /><a href="/sql/docs/db_path/instance-settings#maintenance-
    timing-2ndgen"> Learn more</a>.

    Values:
      SQL_UPDATE_TRACK_UNSPECIFIED: This is an unknown maintenance timing
        preference.
      canary: For instance update that requires a restart, this update track
        indicates your instance prefer to restart for new version early in
        maintenance window.
      stable: For instance update that requires a restart, this update track
        indicates your instance prefer to let Cloud SQL choose the timing of
        restart (within its Maintenance window, if applicable).
    """
    SQL_UPDATE_TRACK_UNSPECIFIED = 0
    canary = 1
    stable = 2

  day = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  hour = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  kind = _messages.StringField(3)
  updateTrack = _messages.EnumField('UpdateTrackValueValuesEnum', 4)


class MySqlReplicaConfiguration(_messages.Message):
  r"""Read-replica configuration specific to MySQL databases.

  Fields:
    caCertificate: PEM representation of the trusted CA's x509 certificate.
    clientCertificate: PEM representation of the slave's x509 certificate.
    clientKey: PEM representation of the slave's private key. The
      corresponsing public key is encoded in the client's certificate.
    connectRetryInterval: Seconds to wait between connect retries. MySQL's
      default is 60 seconds.
    dumpFilePath: Path to a SQL dump file in Google Cloud Storage from which
      the slave instance is to be created. The URI is in the form
      gs://bucketName/fileName. Compressed gzip files (.gz) are also
      supported. Dumps should have the binlog co-ordinates from which
      replication should begin. This can be accomplished by setting --master-
      data to 1 when using mysqldump.
    kind: This is always <b>sql#mysqlReplicaConfiguration</b>.
    masterHeartbeatPeriod: Interval in milliseconds between replication
      heartbeats.
    password: The password for the replication connection.
    sslCipher: A list of permissible ciphers to use for SSL encryption.
    username: The username for the replication connection.
    verifyServerCertificate: Whether or not to check the master's Common Name
      value in the certificate that it sends during the SSL handshake.
  """

  caCertificate = _messages.StringField(1)
  clientCertificate = _messages.StringField(2)
  clientKey = _messages.StringField(3)
  connectRetryInterval = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  dumpFilePath = _messages.StringField(5)
  kind = _messages.StringField(6)
  masterHeartbeatPeriod = _messages.IntegerField(7)
  password = _messages.StringField(8)
  sslCipher = _messages.StringField(9)
  username = _messages.StringField(10)
  verifyServerCertificate = _messages.BooleanField(11)


class OnPremisesConfiguration(_messages.Message):
  r"""On-premises instance configuration.

  Fields:
    caCertificate: PEM representation of the trusted CA's x509 certificate.
    clientCertificate: PEM representation of the slave's x509 certificate.
    clientKey: PEM representation of the slave's private key. The
      corresponsing public key is encoded in the client's certificate.
    dumpFilePath: The dump file to create the Cloud SQL replica.
    hostPort: The host and port of the on-premises instance in host:port
      format
    kind: This is always <b>sql#onPremisesConfiguration</b>.
    password: The password for connecting to on-premises instance.
    username: The username for connecting to on-premises instance.
  """

  caCertificate = _messages.StringField(1)
  clientCertificate = _messages.StringField(2)
  clientKey = _messages.StringField(3)
  dumpFilePath = _messages.StringField(4)
  hostPort = _messages.StringField(5)
  kind = _messages.StringField(6)
  password = _messages.StringField(7)
  username = _messages.StringField(8)


class Operation(_messages.Message):
  r"""An Operation resource.&nbsp;For successful operations that return an
  Operation resource, only the fields relevant to the operation are populated
  in the resource.

  Enums:
    OperationTypeValueValuesEnum: The type of the operation. Valid values are:
      <br><b>CREATE</b> <br><b>DELETE</b> <br><b>UPDATE</b> <br><b>RESTART</b>
      <br><b>IMPORT</b> <br><b>EXPORT</b> <br><b>BACKUP_VOLUME</b>
      <br><b>RESTORE_VOLUME</b> <br><b>CREATE_USER</b> <br><b>DELETE_USER</b>
      <br><b>CREATE_DATABASE</b> <br><b>DELETE_DATABASE</b>
    StatusValueValuesEnum: The status of an operation. Valid values are:
      <br><b>PENDING</b> <br><b>RUNNING</b> <br><b>DONE</b>
      <br><b>SQL_OPERATION_STATUS_UNSPECIFIED</b>

  Fields:
    endTime: The time this operation finished in UTC timezone in <a
      href="https://tools.ietf.org/html/rfc3339">RFC 3339</a> format, for
      example <b>2012-11-15T16:19:00.094Z</b>.
    error: If errors occurred during processing of this operation, this field
      will be populated.
    exportContext: The context for export operation, if applicable.
    importContext: The context for import operation, if applicable.
    insertTime: The time this operation was enqueued in UTC timezone in <a
      href="https://tools.ietf.org/html/rfc3339">RFC 3339</a> format, for
      example <b>2012-11-15T16:19:00.094Z</b>.
    kind: This is always <b>sql#operation</b>.
    name: An identifier that uniquely identifies the operation. You can use
      this identifier to retrieve the Operations resource that has information
      about the operation.
    operationType: The type of the operation. Valid values are:
      <br><b>CREATE</b> <br><b>DELETE</b> <br><b>UPDATE</b> <br><b>RESTART</b>
      <br><b>IMPORT</b> <br><b>EXPORT</b> <br><b>BACKUP_VOLUME</b>
      <br><b>RESTORE_VOLUME</b> <br><b>CREATE_USER</b> <br><b>DELETE_USER</b>
      <br><b>CREATE_DATABASE</b> <br><b>DELETE_DATABASE</b>
    selfLink: The URI of this resource.
    startTime: The time this operation actually started in UTC timezone in <a
      href="https://tools.ietf.org/html/rfc3339">RFC 3339</a> format, for
      example <b>2012-11-15T16:19:00.094Z</b>.
    status: The status of an operation. Valid values are: <br><b>PENDING</b>
      <br><b>RUNNING</b> <br><b>DONE</b>
      <br><b>SQL_OPERATION_STATUS_UNSPECIFIED</b>
    targetId: Name of the database instance related to this operation.
    targetLink: A string attribute.
    targetProject: The project ID of the target instance related to this
      operation.
    user: The email address of the user who initiated this operation.
  """

  class OperationTypeValueValuesEnum(_messages.Enum):
    r"""The type of the operation. Valid values are: <br><b>CREATE</b>
    <br><b>DELETE</b> <br><b>UPDATE</b> <br><b>RESTART</b> <br><b>IMPORT</b>
    <br><b>EXPORT</b> <br><b>BACKUP_VOLUME</b> <br><b>RESTORE_VOLUME</b>
    <br><b>CREATE_USER</b> <br><b>DELETE_USER</b> <br><b>CREATE_DATABASE</b>
    <br><b>DELETE_DATABASE</b>

    Values:
      SQL_OPERATION_TYPE_UNSPECIFIED: Unknown operation type.
      IMPORT: Imports data into a Cloud SQL instance.
      EXPORT: Exports data from a Cloud SQL instance to a Cloud Storage
        bucket.
      CREATE: Creates a new Cloud SQL instance.
      UPDATE: Updates the settings of a Cloud SQL instance.
      DELETE: Deletes a Cloud SQL instance.
      RESTART: Restarts the Cloud SQL instance.
      BACKUP: <no description>
      SNAPSHOT: <no description>
      BACKUP_VOLUME: Performs instance backup.
      DELETE_VOLUME: Deletes an instance backup.
      RESTORE_VOLUME: Restores an instance backup.
      INJECT_USER: Injects a privileged user in mysql for MOB instances.
      CLONE: Clones a Cloud SQL instance.
      STOP_REPLICA: Stops replication on a Cloud SQL read replica instance.
      START_REPLICA: Starts replication on a Cloud SQL read replica instance.
      PROMOTE_REPLICA: Promotes a Cloud SQL replica instance.
      CREATE_REPLICA: Creates a Cloud SQL replica instance.
      CREATE_USER: Creates a new user in a Cloud SQL instance.
      DELETE_USER: Deletes a user from a Cloud SQL instance.
      UPDATE_USER: Updates an existing user in a Cloud SQL instance.
      CREATE_DATABASE: Creates a database in the Cloud SQL instance.
      DELETE_DATABASE: Deletes a database in the Cloud SQL instance.
      UPDATE_DATABASE: Updates a database in the Cloud SQL instance.
      FAILOVER: Performs failover of an HA-enabled Cloud SQL failover replica.
      DELETE_BACKUP: Deletes the backup taken by a backup run.
      RECREATE_REPLICA: <no description>
      TRUNCATE_LOG: Truncates a general or slow log table in MySQL.
      DEMOTE_MASTER: Demotes the stand-alone instance to be a Cloud SQL read
        replica for an external database server.
      MAINTENANCE: Indicates that the instance is currently in maintenance.
        Maintenance typically causes the instance to be unavailable for 1-3
        minutes.
      ENABLE_PRIVATE_IP: This field is deprecated, and will be removed in
        future version of API.
      DEFER_MAINTENANCE: <no description>
      CREATE_CLONE: Creates clone instance.
      RESCHEDULE_MAINTENANCE: Reschedule maintenance to another time.
      START_EXTERNAL_SYNC: Starts external sync of a Cloud SQL EM replica to
        an external master.
    """
    SQL_OPERATION_TYPE_UNSPECIFIED = 0
    IMPORT = 1
    EXPORT = 2
    CREATE = 3
    UPDATE = 4
    DELETE = 5
    RESTART = 6
    BACKUP = 7
    SNAPSHOT = 8
    BACKUP_VOLUME = 9
    DELETE_VOLUME = 10
    RESTORE_VOLUME = 11
    INJECT_USER = 12
    CLONE = 13
    STOP_REPLICA = 14
    START_REPLICA = 15
    PROMOTE_REPLICA = 16
    CREATE_REPLICA = 17
    CREATE_USER = 18
    DELETE_USER = 19
    UPDATE_USER = 20
    CREATE_DATABASE = 21
    DELETE_DATABASE = 22
    UPDATE_DATABASE = 23
    FAILOVER = 24
    DELETE_BACKUP = 25
    RECREATE_REPLICA = 26
    TRUNCATE_LOG = 27
    DEMOTE_MASTER = 28
    MAINTENANCE = 29
    ENABLE_PRIVATE_IP = 30
    DEFER_MAINTENANCE = 31
    CREATE_CLONE = 32
    RESCHEDULE_MAINTENANCE = 33
    START_EXTERNAL_SYNC = 34

  class StatusValueValuesEnum(_messages.Enum):
    r"""The status of an operation. Valid values are: <br><b>PENDING</b>
    <br><b>RUNNING</b> <br><b>DONE</b>
    <br><b>SQL_OPERATION_STATUS_UNSPECIFIED</b>

    Values:
      SQL_OPERATION_STATUS_UNSPECIFIED: The state of the operation is unknown.
      PENDING: The operation has been queued, but has not started yet.
      RUNNING: The operation is running.
      DONE: The operation completed.
    """
    SQL_OPERATION_STATUS_UNSPECIFIED = 0
    PENDING = 1
    RUNNING = 2
    DONE = 3

  endTime = _messages.StringField(1)
  error = _messages.MessageField('OperationErrors', 2)
  exportContext = _messages.MessageField('ExportContext', 3)
  importContext = _messages.MessageField('ImportContext', 4)
  insertTime = _messages.StringField(5)
  kind = _messages.StringField(6)
  name = _messages.StringField(7)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 8)
  selfLink = _messages.StringField(9)
  startTime = _messages.StringField(10)
  status = _messages.EnumField('StatusValueValuesEnum', 11)
  targetId = _messages.StringField(12)
  targetLink = _messages.StringField(13)
  targetProject = _messages.StringField(14)
  user = _messages.StringField(15)


class OperationError(_messages.Message):
  r"""Database instance operation error.

  Fields:
    code: Identifies the specific error that occurred.
    kind: This is always <b>sql#operationError</b>.
    message: Additional information about the error encountered.
  """

  code = _messages.StringField(1)
  kind = _messages.StringField(2)
  message = _messages.StringField(3)


class OperationErrors(_messages.Message):
  r"""Database instance operation errors list wrapper.

  Fields:
    errors: The list of errors encountered while processing this operation.
    kind: This is always <b>sql#operationErrors</b>.
  """

  errors = _messages.MessageField('OperationError', 1, repeated=True)
  kind = _messages.StringField(2)


class OperationsListResponse(_messages.Message):
  r"""Database instance list operations response.

  Fields:
    items: List of operation resources.
    kind: This is always <b>sql#operationsList</b>.
    nextPageToken: The continuation token, used to page through large result
      sets. Provide this value in a subsequent request to return the next page
      of results.
  """

  items = _messages.MessageField('Operation', 1, repeated=True)
  kind = _messages.StringField(2)
  nextPageToken = _messages.StringField(3)


class ReplicaConfiguration(_messages.Message):
  r"""Read-replica configuration for connecting to the master.

  Fields:
    failoverTarget: Specifies if the replica is the failover target. If the
      field is set to <b>true</b> the replica will be designated as a failover
      replica. In case the master instance fails, the replica instance will be
      promoted as the new master instance.  <p>Only one replica can be
      specified as failover target, and the replica has to be in different
      zone with the master instance.
    kind: This is always <b>sql#replicaConfiguration</b>.
    mysqlReplicaConfiguration: MySQL specific configuration when replicating
      from a MySQL on-premises master. Replication configuration information
      such as the username, password, certificates, and keys are not stored in
      the instance metadata. The configuration information is used only to set
      up the replication connection and is stored by MySQL in a file named
      <b>master.info</b> in the data directory.
  """

  failoverTarget = _messages.BooleanField(1)
  kind = _messages.StringField(2)
  mysqlReplicaConfiguration = _messages.MessageField('MySqlReplicaConfiguration', 3)


class Reschedule(_messages.Message):
  r"""A Reschedule object.

  Enums:
    RescheduleTypeValueValuesEnum: Required. The type of the reschedule.

  Fields:
    rescheduleType: Required. The type of the reschedule.
    scheduleTime: Optional. Timestamp when the maintenance shall be
      rescheduled to if reschedule_type=SPECIFIC_TIME, in <a
      href="https://tools.ietf.org/html/rfc3339">RFC 3339</a> format, for
      example <b>2012-11-15T16:19:00.094Z</b>.
  """

  class RescheduleTypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the reschedule.

    Values:
      RESCHEDULE_TYPE_UNSPECIFIED: <no description>
      IMMEDIATE: If the user wants to schedule the maintenance to happen now.
      NEXT_AVAILABLE_WINDOW: If the user wants to use the existing maintenance
        policy to find the next available window.
      SPECIFIC_TIME: If the user wants to reschedule the maintenance to a
        specific time.
    """
    RESCHEDULE_TYPE_UNSPECIFIED = 0
    IMMEDIATE = 1
    NEXT_AVAILABLE_WINDOW = 2
    SPECIFIC_TIME = 3

  rescheduleType = _messages.EnumField('RescheduleTypeValueValuesEnum', 1)
  scheduleTime = _messages.StringField(2)


class RestoreBackupContext(_messages.Message):
  r"""Database instance restore from backup context. Backup context contains
  source instance id and project id.

  Fields:
    backupRunId: The ID of the backup run to restore from.
    instanceId: The ID of the instance that the backup was taken from.
    kind: This is always <b>sql#restoreBackupContext</b>.
    project: The full project ID of the source instance.
  """

  backupRunId = _messages.IntegerField(1)
  instanceId = _messages.StringField(2)
  kind = _messages.StringField(3)
  project = _messages.StringField(4)


class RotateServerCaContext(_messages.Message):
  r"""Instance rotate server CA context.

  Fields:
    kind: This is always <b>sql#rotateServerCaContext</b>.
    nextVersion: The fingerprint of the next version to be rotated to. If left
      unspecified, will be rotated to the most recently added server CA
      version.
  """

  kind = _messages.StringField(1)
  nextVersion = _messages.StringField(2)


class Settings(_messages.Message):
  r"""Database instance settings.

  Enums:
    ActivationPolicyValueValuesEnum: The activation policy specifies when the
      instance is activated; it is applicable only when the instance state is
      RUNNABLE. Valid values:   <br><b>ALWAYS</b>: The instance is on, and
      remains so even in the absence of connection requests.
      <br><b>NEVER</b>: The instance is off; it is not activated, even if a
      connection request arrives.
    AvailabilityTypeValueValuesEnum: Availability type. Potential values:
      <br><b>ZONAL</b>: The instance serves data from only one zone. Outages
      in that zone affect data accessibility.   <br><b>REGIONAL</b>: The
      instance can serve data from more than one zone   in a region (it is
      highly available). <br>For more information, see <a
      href="/sql/docs/postgres/high-availability"> Overview of the High
      Availability Configuration</a>.
    DataDiskTypeValueValuesEnum: The type of data disk: PD_SSD (default) or
      PD_HDD. Not used for First Generation instances.
    PricingPlanValueValuesEnum: The pricing plan for this instance. This can
      be either <b>PER_USE</b> or <b>PACKAGE</b>. Only <b>PER_USE</b> is
      supported for Second Generation instances.
    ReplicationTypeValueValuesEnum: The type of replication this instance
      uses. This can be either <b>ASYNCHRONOUS</b> or <b>SYNCHRONOUS</b>.
      (Deprecated_ This property was only applicable to First Generation
      instances.

  Messages:
    UserLabelsValue: User-provided labels, represented as a dictionary where
      each label is a single key value pair.

  Fields:
    activationPolicy: The activation policy specifies when the instance is
      activated; it is applicable only when the instance state is RUNNABLE.
      Valid values:   <br><b>ALWAYS</b>: The instance is on, and remains so
      even in the absence of connection requests.   <br><b>NEVER</b>: The
      instance is off; it is not activated, even if a   connection request
      arrives.
    activeDirectoryConfig: Active Directory configuration, for now relevant
      only for SQL Server
    authorizedGaeApplications: The App Engine app IDs that can access this
      instance. (Deprecated) Applied to First Generation instances only.
    availabilityType: Availability type. Potential values:   <br><b>ZONAL</b>:
      The instance serves data from only one zone. Outages in that zone affect
      data accessibility.   <br><b>REGIONAL</b>: The instance can serve data
      from more than one zone   in a region (it is highly available). <br>For
      more information, see <a href="/sql/docs/postgres/high-availability">
      Overview of the High Availability Configuration</a>.
    backupConfiguration: The daily backup configuration for the instance.
    collation: The name of server Instance collation.
    crashSafeReplicationEnabled: Configuration specific to read replica
      instances. Indicates whether database flags for crash-safe replication
      are enabled. This property was only applicable to First Generation
      instances.
    dataDiskSizeGb: The size of data disk, in GB. The data disk size minimum
      is 10GB.
    dataDiskType: The type of data disk: PD_SSD (default) or PD_HDD. Not used
      for First Generation instances.
    databaseFlags: The database flags passed to the instance at startup.
    databaseReplicationEnabled: Configuration specific to read replica
      instances. Indicates whether replication is enabled or not.
    ipConfiguration: The settings for IP Management. This allows to enable or
      disable the instance IP and manage which external networks can connect
      to the instance. The IPv4 address cannot be disabled for Second
      Generation instances.
    kind: This is always <b>sql#settings</b>.
    locationPreference: The location preference settings. This allows the
      instance to be located as near as possible to either an App Engine app
      or Compute Engine zone for better performance. App Engine co-location
      was only applicable to First Generation instances.
    maintenanceWindow: The maintenance window for this instance. This
      specifies when the instance can be restarted for maintenance purposes.
    pricingPlan: The pricing plan for this instance. This can be either
      <b>PER_USE</b> or <b>PACKAGE</b>. Only <b>PER_USE</b> is supported for
      Second Generation instances.
    replicationType: The type of replication this instance uses. This can be
      either <b>ASYNCHRONOUS</b> or <b>SYNCHRONOUS</b>. (Deprecated_ This
      property was only applicable to First Generation instances.
    settingsVersion: The version of instance settings. This is a required
      field for update method to make sure concurrent updates are handled
      properly. During update, use the most recent settingsVersion value for
      this instance and do not try to update this value.
    storageAutoResize: Configuration to increase storage size automatically.
      The default value is true.
    storageAutoResizeLimit: The maximum size to which storage capacity can be
      automatically increased. The default value is 0, which specifies that
      there is no limit.
    tier: The tier (or machine type) for this instance, for example
      <b>db-n1-standard-1</b> (MySQL instances) or <b>db-custom-1-3840</b>
      (PostgreSQL instances).
    userLabels: User-provided labels, represented as a dictionary where each
      label is a single key value pair.
  """

  class ActivationPolicyValueValuesEnum(_messages.Enum):
    r"""The activation policy specifies when the instance is activated; it is
    applicable only when the instance state is RUNNABLE. Valid values:
    <br><b>ALWAYS</b>: The instance is on, and remains so even in the absence
    of connection requests.   <br><b>NEVER</b>: The instance is off; it is not
    activated, even if a   connection request arrives.

    Values:
      SQL_ACTIVATION_POLICY_UNSPECIFIED: Unknown activation plan.
      ALWAYS: The instance is always up and running.
      NEVER: The instance should never spin up.
      ON_DEMAND: The instance spins up upon receiving requests.
    """
    SQL_ACTIVATION_POLICY_UNSPECIFIED = 0
    ALWAYS = 1
    NEVER = 2
    ON_DEMAND = 3

  class AvailabilityTypeValueValuesEnum(_messages.Enum):
    r"""Availability type. Potential values:   <br><b>ZONAL</b>: The instance
    serves data from only one zone. Outages in that zone affect data
    accessibility.   <br><b>REGIONAL</b>: The instance can serve data from
    more than one zone   in a region (it is highly available). <br>For more
    information, see <a href="/sql/docs/postgres/high-availability"> Overview
    of the High Availability Configuration</a>.

    Values:
      SQL_AVAILABILITY_TYPE_UNSPECIFIED: This is an unknown Availability type.
      ZONAL: Zonal available instance.
      REGIONAL: Regional available instance.
    """
    SQL_AVAILABILITY_TYPE_UNSPECIFIED = 0
    ZONAL = 1
    REGIONAL = 2

  class DataDiskTypeValueValuesEnum(_messages.Enum):
    r"""The type of data disk: PD_SSD (default) or PD_HDD. Not used for First
    Generation instances.

    Values:
      SQL_DATA_DISK_TYPE_UNSPECIFIED: This is an unknown data disk type.
      PD_SSD: An SSD data disk.
      PD_HDD: An HDD data disk.
      OBSOLETE_LOCAL_SSD: This field is deprecated and will be removed from a
        future version of the API.
    """
    SQL_DATA_DISK_TYPE_UNSPECIFIED = 0
    PD_SSD = 1
    PD_HDD = 2
    OBSOLETE_LOCAL_SSD = 3

  class PricingPlanValueValuesEnum(_messages.Enum):
    r"""The pricing plan for this instance. This can be either <b>PER_USE</b>
    or <b>PACKAGE</b>. Only <b>PER_USE</b> is supported for Second Generation
    instances.

    Values:
      SQL_PRICING_PLAN_UNSPECIFIED: This is an unknown pricing plan for this
        instance.
      PACKAGE: The instance is billed at a monthly flat rate.
      PER_USE: The instance is billed per usage.
    """
    SQL_PRICING_PLAN_UNSPECIFIED = 0
    PACKAGE = 1
    PER_USE = 2

  class ReplicationTypeValueValuesEnum(_messages.Enum):
    r"""The type of replication this instance uses. This can be either
    <b>ASYNCHRONOUS</b> or <b>SYNCHRONOUS</b>. (Deprecated_ This property was
    only applicable to First Generation instances.

    Values:
      SQL_REPLICATION_TYPE_UNSPECIFIED: This is an unknown replication type
        for a Cloud SQL instance.
      SYNCHRONOUS: The synchronous replication mode for First Generation
        instances. It is the default value.
      ASYNCHRONOUS: The asynchronous replication mode for First Generation
        instances. It provides a slight performance gain, but if an outage
        occurs while this option is set to asynchronous, you can lose up to a
        few seconds of updates to your data.
    """
    SQL_REPLICATION_TYPE_UNSPECIFIED = 0
    SYNCHRONOUS = 1
    ASYNCHRONOUS = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class UserLabelsValue(_messages.Message):
    r"""User-provided labels, represented as a dictionary where each label is
    a single key value pair.

    Messages:
      AdditionalProperty: An additional property for a UserLabelsValue object.

    Fields:
      additionalProperties: Additional properties of type UserLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a UserLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  activationPolicy = _messages.EnumField('ActivationPolicyValueValuesEnum', 1)
  activeDirectoryConfig = _messages.MessageField('SqlActiveDirectoryConfig', 2)
  authorizedGaeApplications = _messages.StringField(3, repeated=True)
  availabilityType = _messages.EnumField('AvailabilityTypeValueValuesEnum', 4)
  backupConfiguration = _messages.MessageField('BackupConfiguration', 5)
  collation = _messages.StringField(6)
  crashSafeReplicationEnabled = _messages.BooleanField(7)
  dataDiskSizeGb = _messages.IntegerField(8)
  dataDiskType = _messages.EnumField('DataDiskTypeValueValuesEnum', 9)
  databaseFlags = _messages.MessageField('DatabaseFlags', 10, repeated=True)
  databaseReplicationEnabled = _messages.BooleanField(11)
  ipConfiguration = _messages.MessageField('IpConfiguration', 12)
  kind = _messages.StringField(13)
  locationPreference = _messages.MessageField('LocationPreference', 14)
  maintenanceWindow = _messages.MessageField('MaintenanceWindow', 15)
  pricingPlan = _messages.EnumField('PricingPlanValueValuesEnum', 16)
  replicationType = _messages.EnumField('ReplicationTypeValueValuesEnum', 17)
  settingsVersion = _messages.IntegerField(18)
  storageAutoResize = _messages.BooleanField(19)
  storageAutoResizeLimit = _messages.IntegerField(20)
  tier = _messages.StringField(21)
  userLabels = _messages.MessageField('UserLabelsValue', 22)


class SqlActiveDirectoryConfig(_messages.Message):
  r"""Active Directory configuration, for now relevant only for SQL Server

  Fields:
    domain: Domain name
    kind: This will be always sql#activeDirectoryConfig.
  """

  domain = _messages.StringField(1)
  kind = _messages.StringField(2)


class SqlBackupRunsDeleteRequest(_messages.Message):
  r"""A SqlBackupRunsDeleteRequest object.

  Fields:
    id: The ID of the Backup Run to delete. To find a Backup Run ID, use the
      <a href="/sql/docs/db_path/admin-
      api/rest/v1beta4/backupRuns/list">list</a> method.
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  id = _messages.IntegerField(1, required=True)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlBackupRunsGetRequest(_messages.Message):
  r"""A SqlBackupRunsGetRequest object.

  Fields:
    id: The ID of this Backup Run.
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  id = _messages.IntegerField(1, required=True)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlBackupRunsInsertRequest(_messages.Message):
  r"""A SqlBackupRunsInsertRequest object.

  Fields:
    backupRun: A BackupRun resource to be passed as the request body.
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  backupRun = _messages.MessageField('BackupRun', 1)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlBackupRunsListRequest(_messages.Message):
  r"""A SqlBackupRunsListRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    maxResults: Maximum number of backup runs per response.
    pageToken: A previously-returned page token representing part of the
      larger set of results to view.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)


class SqlDatabasesDeleteRequest(_messages.Message):
  r"""A SqlDatabasesDeleteRequest object.

  Fields:
    database: Name of the database to be deleted in the instance.
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  database = _messages.StringField(1, required=True)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlDatabasesGetRequest(_messages.Message):
  r"""A SqlDatabasesGetRequest object.

  Fields:
    database: Name of the database in the instance.
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  database = _messages.StringField(1, required=True)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlDatabasesListRequest(_messages.Message):
  r"""A SqlDatabasesListRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlDatabasesPatchRequest(_messages.Message):
  r"""A SqlDatabasesPatchRequest object.

  Fields:
    database: Name of the database to be updated in the instance.
    databaseResource: A Database resource to be passed as the request body.
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  database = _messages.StringField(1, required=True)
  databaseResource = _messages.MessageField('Database', 2)
  instance = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)


class SqlDatabasesUpdateRequest(_messages.Message):
  r"""A SqlDatabasesUpdateRequest object.

  Fields:
    database: Name of the database to be updated in the instance.
    databaseResource: A Database resource to be passed as the request body.
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  database = _messages.StringField(1, required=True)
  databaseResource = _messages.MessageField('Database', 2)
  instance = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)


class SqlExternalSyncSettingError(_messages.Message):
  r"""External master migration setting error.

  Enums:
    TypeValueValuesEnum: Identifies the specific error that occurred.

  Fields:
    detail: Additional information about the error encountered.
    kind: This is always <b>sql#migrationSettingError</b>.
    type: Identifies the specific error that occurred.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Identifies the specific error that occurred.

    Values:
      SQL_EXTERNAL_SYNC_SETTING_ERROR_TYPE_UNSPECIFIED: <no description>
      CONNECTION_FAILURE: <no description>
      BINLOG_NOT_ENABLED: <no description>
      INCOMPATIBLE_DATABASE_VERSION: <no description>
      REPLICA_ALREADY_SETUP: <no description>
      INSUFFICIENT_PRIVILEGE: <no description>
      UNSUPPORTED_MIGRATION_TYPE: Unsupported migration type.
      NO_PGLOGICAL_INSTALLED: No pglogical extension installed on databases,
        applicable for postgres.
      PGLOGICAL_NODE_ALREADY_EXISTS: pglogical node already exists on
        databases, applicable for postgres.
      INVALID_WAL_LEVEL: The value of parameter wal_level is not set to
        logical.
      INVALID_SHARED_PRELOAD_LIBRARY: The value of parameter
        shared_preload_libraries does not include pglogical.
      INSUFFICIENT_MAX_REPLICATION_SLOTS: The value of parameter
        max_replication_slots is not sufficient.
      INSUFFICIENT_MAX_WAL_SENDERS: The value of parameter max_wal_senders is
        not sufficient.
      INSUFFICIENT_MAX_WORKER_PROCESSES: The value of parameter
        max_worker_processes is not sufficient.
      UNSUPPORTED_EXTENSIONS: Extensions installed are either not supported or
        having unsupported versions
    """
    SQL_EXTERNAL_SYNC_SETTING_ERROR_TYPE_UNSPECIFIED = 0
    CONNECTION_FAILURE = 1
    BINLOG_NOT_ENABLED = 2
    INCOMPATIBLE_DATABASE_VERSION = 3
    REPLICA_ALREADY_SETUP = 4
    INSUFFICIENT_PRIVILEGE = 5
    UNSUPPORTED_MIGRATION_TYPE = 6
    NO_PGLOGICAL_INSTALLED = 7
    PGLOGICAL_NODE_ALREADY_EXISTS = 8
    INVALID_WAL_LEVEL = 9
    INVALID_SHARED_PRELOAD_LIBRARY = 10
    INSUFFICIENT_MAX_REPLICATION_SLOTS = 11
    INSUFFICIENT_MAX_WAL_SENDERS = 12
    INSUFFICIENT_MAX_WORKER_PROCESSES = 13
    UNSUPPORTED_EXTENSIONS = 14

  detail = _messages.StringField(1)
  kind = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class SqlFlagsListRequest(_messages.Message):
  r"""A SqlFlagsListRequest object.

  Fields:
    databaseVersion: Database type and version you want to retrieve flags for.
      By default, this method returns flags for all database types and
      versions.
  """

  databaseVersion = _messages.StringField(1)


class SqlInstancesAddServerCaRequest(_messages.Message):
  r"""A SqlInstancesAddServerCaRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesCloneRequest(_messages.Message):
  r"""A SqlInstancesCloneRequest object.

  Fields:
    instance: The ID of the Cloud SQL instance to be cloned (source). This
      does not include the project ID.
    instancesCloneRequest: A InstancesCloneRequest resource to be passed as
      the request body.
    project: Project ID of the source as well as the clone Cloud SQL instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesCloneRequest = _messages.MessageField('InstancesCloneRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesDeleteRequest(_messages.Message):
  r"""A SqlInstancesDeleteRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance to be
      deleted.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesDemoteMasterRequest(_messages.Message):
  r"""A SqlInstancesDemoteMasterRequest object.

  Fields:
    instance: Cloud SQL instance name.
    instancesDemoteMasterRequest: A InstancesDemoteMasterRequest resource to
      be passed as the request body.
    project: ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesDemoteMasterRequest = _messages.MessageField('InstancesDemoteMasterRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesExportRequest(_messages.Message):
  r"""A SqlInstancesExportRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    instancesExportRequest: A InstancesExportRequest resource to be passed as
      the request body.
    project: Project ID of the project that contains the instance to be
      exported.
  """

  instance = _messages.StringField(1, required=True)
  instancesExportRequest = _messages.MessageField('InstancesExportRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesFailoverRequest(_messages.Message):
  r"""A SqlInstancesFailoverRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    instancesFailoverRequest: A InstancesFailoverRequest resource to be passed
      as the request body.
    project: ID of the project that contains the read replica.
  """

  instance = _messages.StringField(1, required=True)
  instancesFailoverRequest = _messages.MessageField('InstancesFailoverRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesGetRequest(_messages.Message):
  r"""A SqlInstancesGetRequest object.

  Fields:
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesImportRequest(_messages.Message):
  r"""A SqlInstancesImportRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    instancesImportRequest: A InstancesImportRequest resource to be passed as
      the request body.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesImportRequest = _messages.MessageField('InstancesImportRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesListRequest(_messages.Message):
  r"""A SqlInstancesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression is in the form of field:value. For example,
      'instanceType:CLOUD_SQL_INSTANCE'. Fields can be nested as needed as per
      their JSON representation, such as
      'settings.userLabels.auto_start:true'.  Multiple filter queries are
      space-separated. For example. 'state:RUNNABLE
      instanceType:CLOUD_SQL_INSTANCE'. By default, each expression is an AND
      expression. However, you can include AND and OR expressions explicitly.
    maxResults: The maximum number of results to return per response.
    pageToken: A previously-returned page token representing part of the
      larger set of results to view.
    project: Project ID of the project for which to list Cloud SQL instances.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)


class SqlInstancesListServerCasRequest(_messages.Message):
  r"""A SqlInstancesListServerCasRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesPatchRequest(_messages.Message):
  r"""A SqlInstancesPatchRequest object.

  Fields:
    databaseInstance: A DatabaseInstance resource to be passed as the request
      body.
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  databaseInstance = _messages.MessageField('DatabaseInstance', 1)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlInstancesPromoteReplicaRequest(_messages.Message):
  r"""A SqlInstancesPromoteReplicaRequest object.

  Fields:
    instance: Cloud SQL read replica instance name.
    project: ID of the project that contains the read replica.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesRescheduleMaintenanceRequestBody(_messages.Message):
  r"""Reschedule options for maintenance windows.

  Fields:
    reschedule: Required. The type of the reschedule the user wants.
  """

  reschedule = _messages.MessageField('Reschedule', 1)


class SqlInstancesResetSslConfigRequest(_messages.Message):
  r"""A SqlInstancesResetSslConfigRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesRestartRequest(_messages.Message):
  r"""A SqlInstancesRestartRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance to be
      restarted.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesRestoreBackupRequest(_messages.Message):
  r"""A SqlInstancesRestoreBackupRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    instancesRestoreBackupRequest: A InstancesRestoreBackupRequest resource to
      be passed as the request body.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesRestoreBackupRequest = _messages.MessageField('InstancesRestoreBackupRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesRotateServerCaRequest(_messages.Message):
  r"""A SqlInstancesRotateServerCaRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    instancesRotateServerCaRequest: A InstancesRotateServerCaRequest resource
      to be passed as the request body.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesRotateServerCaRequest = _messages.MessageField('InstancesRotateServerCaRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesStartReplicaRequest(_messages.Message):
  r"""A SqlInstancesStartReplicaRequest object.

  Fields:
    instance: Cloud SQL read replica instance name.
    project: ID of the project that contains the read replica.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesStopReplicaRequest(_messages.Message):
  r"""A SqlInstancesStopReplicaRequest object.

  Fields:
    instance: Cloud SQL read replica instance name.
    project: ID of the project that contains the read replica.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesTruncateLogRequest(_messages.Message):
  r"""A SqlInstancesTruncateLogRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    instancesTruncateLogRequest: A InstancesTruncateLogRequest resource to be
      passed as the request body.
    project: Project ID of the Cloud SQL project.
  """

  instance = _messages.StringField(1, required=True)
  instancesTruncateLogRequest = _messages.MessageField('InstancesTruncateLogRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesUpdateRequest(_messages.Message):
  r"""A SqlInstancesUpdateRequest object.

  Fields:
    databaseInstance: A DatabaseInstance resource to be passed as the request
      body.
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  databaseInstance = _messages.MessageField('DatabaseInstance', 1)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlInstancesVerifyExternalSyncSettingsResponse(_messages.Message):
  r"""Instance verify external sync settings response.

  Fields:
    errors: List of migration violations.
    kind: This is always <b>sql#migrationSettingErrorList</b>.
  """

  errors = _messages.MessageField('SqlExternalSyncSettingError', 1, repeated=True)
  kind = _messages.StringField(2)


class SqlOperationsGetRequest(_messages.Message):
  r"""A SqlOperationsGetRequest object.

  Fields:
    operation: Instance operation ID.
    project: Project ID of the project that contains the instance.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlOperationsListRequest(_messages.Message):
  r"""A SqlOperationsListRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    maxResults: Maximum number of operations per response.
    pageToken: A previously-returned page token representing part of the
      larger set of results to view.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)


class SqlProjectsInstancesRescheduleMaintenanceRequest(_messages.Message):
  r"""A SqlProjectsInstancesRescheduleMaintenanceRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: ID of the project that contains the instance.
    sqlInstancesRescheduleMaintenanceRequestBody: A
      SqlInstancesRescheduleMaintenanceRequestBody resource to be passed as
      the request body.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sqlInstancesRescheduleMaintenanceRequestBody = _messages.MessageField('SqlInstancesRescheduleMaintenanceRequestBody', 3)


class SqlProjectsInstancesStartExternalSyncRequest(_messages.Message):
  r"""A SqlProjectsInstancesStartExternalSyncRequest object.

  Enums:
    SyncModeValueValuesEnum: External sync mode

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: ID of the project that contains the first generation instance.
    syncMode: External sync mode
  """

  class SyncModeValueValuesEnum(_messages.Enum):
    r"""External sync mode

    Values:
      EXTERNAL_SYNC_MODE_UNSPECIFIED: <no description>
      ONLINE: <no description>
      OFFLINE: <no description>
    """
    EXTERNAL_SYNC_MODE_UNSPECIFIED = 0
    ONLINE = 1
    OFFLINE = 2

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  syncMode = _messages.EnumField('SyncModeValueValuesEnum', 3)


class SqlProjectsInstancesVerifyExternalSyncSettingsRequest(_messages.Message):
  r"""A SqlProjectsInstancesVerifyExternalSyncSettingsRequest object.

  Enums:
    SyncModeValueValuesEnum: External sync mode

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
    syncMode: External sync mode
    verifyConnectionOnly: Flag to enable verifying connection only
  """

  class SyncModeValueValuesEnum(_messages.Enum):
    r"""External sync mode

    Values:
      EXTERNAL_SYNC_MODE_UNSPECIFIED: <no description>
      ONLINE: <no description>
      OFFLINE: <no description>
    """
    EXTERNAL_SYNC_MODE_UNSPECIFIED = 0
    ONLINE = 1
    OFFLINE = 2

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  syncMode = _messages.EnumField('SyncModeValueValuesEnum', 3)
  verifyConnectionOnly = _messages.BooleanField(4)


class SqlScheduledMaintenance(_messages.Message):
  r"""Any scheduled maintenancce for this instance.

  Fields:
    canDefer: A boolean attribute.
    canReschedule: If the scheduled maintenance can be rescheduled.
    startTime: The start time of any upcoming scheduled maintenance for this
      instance.
  """

  canDefer = _messages.BooleanField(1)
  canReschedule = _messages.BooleanField(2)
  startTime = _messages.StringField(3)


class SqlServerDatabaseDetails(_messages.Message):
  r"""Represents a Sql Server database on the Cloud SQL instance.

  Fields:
    compatibilityLevel: The version of SQL Server with which the database is
      to be made compatible
    recoveryModel: The recovery model of a SQL Server database
  """

  compatibilityLevel = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  recoveryModel = _messages.StringField(2)


class SqlServerUserDetails(_messages.Message):
  r"""Represents a Sql Server user on the Cloud SQL instance.

  Fields:
    disabled: If the user has been disabled
    serverRoles: The server roles for this user
  """

  disabled = _messages.BooleanField(1)
  serverRoles = _messages.StringField(2, repeated=True)


class SqlSslCertsCreateEphemeralRequest(_messages.Message):
  r"""A SqlSslCertsCreateEphemeralRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the Cloud SQL project.
    sslCertsCreateEphemeralRequest: A SslCertsCreateEphemeralRequest resource
      to be passed as the request body.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sslCertsCreateEphemeralRequest = _messages.MessageField('SslCertsCreateEphemeralRequest', 3)


class SqlSslCertsDeleteRequest(_messages.Message):
  r"""A SqlSslCertsDeleteRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
    sha1Fingerprint: Sha1 FingerPrint.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sha1Fingerprint = _messages.StringField(3, required=True)


class SqlSslCertsGetRequest(_messages.Message):
  r"""A SqlSslCertsGetRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
    sha1Fingerprint: Sha1 FingerPrint.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sha1Fingerprint = _messages.StringField(3, required=True)


class SqlSslCertsInsertRequest(_messages.Message):
  r"""A SqlSslCertsInsertRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
    sslCertsInsertRequest: A SslCertsInsertRequest resource to be passed as
      the request body.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sslCertsInsertRequest = _messages.MessageField('SslCertsInsertRequest', 3)


class SqlSslCertsListRequest(_messages.Message):
  r"""A SqlSslCertsListRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlTiersListRequest(_messages.Message):
  r"""A SqlTiersListRequest object.

  Fields:
    project: Project ID of the project for which to list tiers.
  """

  project = _messages.StringField(1, required=True)


class SqlUsersDeleteRequest(_messages.Message):
  r"""A SqlUsersDeleteRequest object.

  Fields:
    host: Host of the user in the instance.
    instance: Database instance ID. This does not include the project ID.
    name: Name of the user in the instance.
    project: Project ID of the project that contains the instance.
  """

  host = _messages.StringField(1)
  instance = _messages.StringField(2, required=True)
  name = _messages.StringField(3)
  project = _messages.StringField(4, required=True)


class SqlUsersListRequest(_messages.Message):
  r"""A SqlUsersListRequest object.

  Fields:
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlUsersUpdateRequest(_messages.Message):
  r"""A SqlUsersUpdateRequest object.

  Fields:
    host: Optional. Host of the user in the instance.
    instance: Database instance ID. This does not include the project ID.
    name: Name of the user in the instance.
    project: Project ID of the project that contains the instance.
    user: A User resource to be passed as the request body.
  """

  host = _messages.StringField(1)
  instance = _messages.StringField(2, required=True)
  name = _messages.StringField(3)
  project = _messages.StringField(4, required=True)
  user = _messages.MessageField('User', 5)


class SslCert(_messages.Message):
  r"""SslCerts Resource

  Fields:
    cert: PEM representation.
    certSerialNumber: Serial number, as extracted from the certificate.
    commonName: User supplied name.  Constrained to [a-zA-Z.-_ ]+.
    createTime: The time when the certificate was created in <a
      href="https://tools.ietf.org/html/rfc3339">RFC 3339</a> format, for
      example <b>2012-11-15T16:19:00.094Z</b>
    expirationTime: The time when the certificate expires in <a
      href="https://tools.ietf.org/html/rfc3339">RFC 3339</a> format, for
      example <b>2012-11-15T16:19:00.094Z</b>.
    instance: Name of the database instance.
    kind: This is always <b>sql#sslCert</b>.
    selfLink: The URI of this resource.
    sha1Fingerprint: Sha1 Fingerprint.
  """

  cert = _messages.StringField(1)
  certSerialNumber = _messages.StringField(2)
  commonName = _messages.StringField(3)
  createTime = _messages.StringField(4)
  expirationTime = _messages.StringField(5)
  instance = _messages.StringField(6)
  kind = _messages.StringField(7)
  selfLink = _messages.StringField(8)
  sha1Fingerprint = _messages.StringField(9)


class SslCertDetail(_messages.Message):
  r"""SslCertDetail.

  Fields:
    certInfo: The public information about the cert.
    certPrivateKey: The private key for the client cert, in pem format.  Keep
      private in order to protect your security.
  """

  certInfo = _messages.MessageField('SslCert', 1)
  certPrivateKey = _messages.StringField(2)


class SslCertsCreateEphemeralRequest(_messages.Message):
  r"""SslCerts create ephemeral certificate request.

  Fields:
    public_key: PEM encoded public key to include in the signed certificate.
  """

  public_key = _messages.StringField(1)


class SslCertsInsertRequest(_messages.Message):
  r"""SslCerts insert request.

  Fields:
    commonName: User supplied name.  Must be a distinct name from the other
      certificates for this instance.
  """

  commonName = _messages.StringField(1)


class SslCertsInsertResponse(_messages.Message):
  r"""SslCert insert response.

  Fields:
    clientCert: The new client certificate and private key.
    kind: This is always <b>sql#sslCertsInsert</b>.
    operation: The operation to track the ssl certs insert request.
    serverCaCert: The server Certificate Authority's certificate.  If this is
      missing you can force a new one to be generated by calling
      resetSslConfig method on instances resource.
  """

  clientCert = _messages.MessageField('SslCertDetail', 1)
  kind = _messages.StringField(2)
  operation = _messages.MessageField('Operation', 3)
  serverCaCert = _messages.MessageField('SslCert', 4)


class SslCertsListResponse(_messages.Message):
  r"""SslCerts list response.

  Fields:
    items: List of client certificates for the instance.
    kind: This is always <b>sql#sslCertsList</b>.
  """

  items = _messages.MessageField('SslCert', 1, repeated=True)
  kind = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Tier(_messages.Message):
  r"""A Google Cloud SQL service tier resource.

  Fields:
    DiskQuota: The maximum disk size of this tier in bytes.
    RAM: The maximum RAM usage of this tier in bytes.
    kind: This is always <b>sql#tier</b>.
    region: The applicable regions for this tier.
    tier: An identifier for the machine type, for example, db-n1-standard-1.
      For related information, see <a href="/sql/pricing">Pricing</a>.
  """

  DiskQuota = _messages.IntegerField(1)
  RAM = _messages.IntegerField(2)
  kind = _messages.StringField(3)
  region = _messages.StringField(4, repeated=True)
  tier = _messages.StringField(5)


class TiersListResponse(_messages.Message):
  r"""Tiers list response.

  Fields:
    items: List of tiers.
    kind: This is always <b>sql#tiersList</b>.
  """

  items = _messages.MessageField('Tier', 1, repeated=True)
  kind = _messages.StringField(2)


class TruncateLogContext(_messages.Message):
  r"""Database Instance truncate log context.

  Fields:
    kind: This is always <b>sql#truncateLogContext</b>.
    logType: The type of log to truncate. Valid values are
      <b>MYSQL_GENERAL_TABLE</b> and <b>MYSQL_SLOW_TABLE</b>.
  """

  kind = _messages.StringField(1)
  logType = _messages.StringField(2)


class User(_messages.Message):
  r"""A Cloud SQL user resource.

  Enums:
    TypeValueValuesEnum: The user type. It determines the method to
      authenticate the user during login.   <br><b>NATIVE</b>: database native
      user. (default)   <br><b>CLOUD_IAM_USER</b>: Cloud IAM user.

  Fields:
    etag: This field is deprecated and will be removed from a future version
      of the API.
    host: The host name from which the user can connect. For <b>insert</b>
      operations, host defaults to an empty string. For <b>update</b>
      operations, host is specified as part of the request URL. The host name
      cannot be updated after insertion.
    instance: The name of the Cloud SQL instance. This does not include the
      project ID. Can be omitted for <b>update</b> since it is already
      specified on the URL.
    kind: This is always <b>sql#user</b>.
    name: The name of the user in the Cloud SQL instance. Can be omitted for
      <b>update</b> since it is already specified in the URL.
    password: The password for the user.
    project: The project ID of the project containing the Cloud SQL database.
      The Google apps domain is prefixed if applicable. Can be omitted for
      <b>update</b> since it is already specified on the URL.
    sqlserverUserDetails: A SqlServerUserDetails attribute.
    type: The user type. It determines the method to authenticate the user
      during login.   <br><b>NATIVE</b>: database native user. (default)
      <br><b>CLOUD_IAM_USER</b>: Cloud IAM user.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The user type. It determines the method to authenticate the user
    during login.   <br><b>NATIVE</b>: database native user. (default)
    <br><b>CLOUD_IAM_USER</b>: Cloud IAM user.

    Values:
      NATIVE: <no description>
      CLOUD_IAM_USER: <no description>
      CLOUD_IAM_SERVICE_ACCOUNT: <no description>
    """
    NATIVE = 0
    CLOUD_IAM_USER = 1
    CLOUD_IAM_SERVICE_ACCOUNT = 2

  etag = _messages.StringField(1)
  host = _messages.StringField(2)
  instance = _messages.StringField(3)
  kind = _messages.StringField(4)
  name = _messages.StringField(5)
  password = _messages.StringField(6)
  project = _messages.StringField(7)
  sqlserverUserDetails = _messages.MessageField('SqlServerUserDetails', 8)
  type = _messages.EnumField('TypeValueValuesEnum', 9)


class UsersListResponse(_messages.Message):
  r"""User list response.

  Fields:
    items: List of user resources in the instance.
    kind: This is always <b>sql#usersList</b>.
    nextPageToken: An identifier that uniquely identifies the operation. You
      can use this identifier to retrieve the Operations resource that has
      information about the operation.
  """

  items = _messages.MessageField('User', 1, repeated=True)
  kind = _messages.StringField(2)
  nextPageToken = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
