"""Generated message classes for cloudbuild version v1alpha1.

Creates and manages builds on Google Cloud Platform.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudbuild'


class ArtifactObjects(_messages.Message):
  r"""Files in the workspace to upload to Cloud Storage upon successful
  completion of all build steps.

  Fields:
    location: Cloud Storage bucket and optional object path, in the form
      "gs://bucket/path/to/somewhere/". (see [Bucket Name
      Requirements](https://cloud.google.com/storage/docs/bucket-
      naming#requirements)).  Files in the workspace matching any path pattern
      will be uploaded to Cloud Storage with this location as a prefix.
    paths: Path globs used to match files in the build's workspace.
    timing: Output only. Stores timing information for pushing all artifact
      objects.
  """

  location = _messages.StringField(1)
  paths = _messages.StringField(2, repeated=True)
  timing = _messages.MessageField('TimeSpan', 3)


class ArtifactResult(_messages.Message):
  r"""An artifact that was uploaded during a build. This is a single record in
  the artifact manifest JSON file.

  Fields:
    fileHash: The file hash of the artifact.
    location: The path of an artifact in a Google Cloud Storage bucket, with
      the generation number. For example,
      `gs://mybucket/path/to/output.jar#generation`.
  """

  fileHash = _messages.MessageField('FileHashes', 1, repeated=True)
  location = _messages.StringField(2)


class Artifacts(_messages.Message):
  r"""Artifacts produced by a build that should be uploaded upon successful
  completion of all build steps.

  Fields:
    images: A list of images to be pushed upon the successful completion of
      all build steps.  The images will be pushed using the builder service
      account's credentials.  The digests of the pushed images will be stored
      in the Build resource's results field.  If any of the images fail to be
      pushed, the build is marked FAILURE.
    objects: A list of objects to be uploaded to Cloud Storage upon successful
      completion of all build steps.  Files in the workspace matching
      specified paths globs will be uploaded to the specified Cloud Storage
      location using the builder service account's credentials.  The location
      and generation of the uploaded objects will be stored in the Build
      resource's results field.  If any objects fail to be pushed, the build
      is marked FAILURE.
  """

  images = _messages.StringField(1, repeated=True)
  objects = _messages.MessageField('ArtifactObjects', 2)


class Build(_messages.Message):
  r"""A build resource in the Cloud Build API.  At a high level, a `Build`
  describes where to find source code, how to build it (for example, the
  builder image to run on the source), and where to store the built artifacts.
  Fields can include the following variables, which will be expanded when the
  build is created:  - $PROJECT_ID: the project ID of the build. - $BUILD_ID:
  the autogenerated ID of the build. - $REPO_NAME: the source repository name
  specified by RepoSource. - $BRANCH_NAME: the branch name specified by
  RepoSource. - $TAG_NAME: the tag name specified by RepoSource. -
  $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or
  resolved from the specified branch or tag. - $SHORT_SHA: first 7 characters
  of $REVISION_ID or $COMMIT_SHA.

  Enums:
    StatusValueValuesEnum: Output only. Status of the build.

  Messages:
    SubstitutionsValue: Substitutions data for `Build` resource.
    TimingValue: Output only. Stores timing information for phases of the
      build. Valid keys are:  * BUILD: time to execute all build steps * PUSH:
      time to push all specified images. * FETCHSOURCE: time to fetch source.
      If the build does not specify source or images, these keys will not be
      included.

  Fields:
    artifacts: Artifacts produced by the build that should be uploaded upon
      successful completion of all build steps.
    buildTriggerId: Output only. The ID of the `BuildTrigger` that triggered
      this build, if it was triggered automatically.
    createTime: Output only. Time at which the request to create the build was
      received.
    finishTime: Output only. Time at which execution of the build was
      finished.  The difference between finish_time and start_time is the
      duration of the build's execution.
    id: Output only. Unique identifier of the build.
    images: A list of images to be pushed upon the successful completion of
      all build steps.  The images are pushed using the builder service
      account's credentials.  The digests of the pushed images will be stored
      in the `Build` resource's results field.  If any of the images fail to
      be pushed, the build status is marked `FAILURE`.
    logUrl: Output only. URL to logs for this build in Google Cloud Console.
    logsBucket: Google Cloud Storage bucket where logs should be written (see
      [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-
      naming#requirements)). Logs file names will be of the format
      `${logs_bucket}/log-${build_id}.txt`.
    options: Special options for this build.
    projectId: Output only. ID of the project.
    queueTtl: TTL in queue for this build. If provided and the build is
      enqueued longer than this value, the build will expire and the build
      status will be `EXPIRED`.  The TTL starts ticking from create_time.
    results: Output only. Results of the build.
    secrets: Secrets to decrypt using Cloud Key Management Service.
    source: The location of the source files to build.
    sourceProvenance: Output only. A permanent fixed identifier for source.
    startTime: Output only. Time at which execution of the build was started.
    status: Output only. Status of the build.
    statusDetail: Output only. Customer-readable message about the current
      status.
    steps: Required. The operations to be performed on the workspace.
    substitutions: Substitutions data for `Build` resource.
    tags: Tags for annotation of a `Build`. These are not docker tags.
    timeout: Amount of time that this build should be allowed to run, to
      second granularity. If this amount of time elapses, work on the build
      will cease and the build status will be `TIMEOUT`.  `timeout` starts
      ticking from `startTime`.  Default time is ten minutes.
    timing: Output only. Stores timing information for phases of the build.
      Valid keys are:  * BUILD: time to execute all build steps * PUSH: time
      to push all specified images. * FETCHSOURCE: time to fetch source.  If
      the build does not specify source or images, these keys will not be
      included.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Output only. Status of the build.

    Values:
      STATUS_UNKNOWN: Status of the build is unknown.
      QUEUED: Build or step is queued; work has not yet begun.
      WORKING: Build or step is being executed.
      SUCCESS: Build or step finished successfully.
      FAILURE: Build or step failed to complete successfully.
      INTERNAL_ERROR: Build or step failed due to an internal cause.
      TIMEOUT: Build or step took longer than was allowed.
      CANCELLED: Build or step was canceled by a user.
      EXPIRED: Build was enqueued for longer than the value of `queue_ttl`.
    """
    STATUS_UNKNOWN = 0
    QUEUED = 1
    WORKING = 2
    SUCCESS = 3
    FAILURE = 4
    INTERNAL_ERROR = 5
    TIMEOUT = 6
    CANCELLED = 7
    EXPIRED = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SubstitutionsValue(_messages.Message):
    r"""Substitutions data for `Build` resource.

    Messages:
      AdditionalProperty: An additional property for a SubstitutionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type SubstitutionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SubstitutionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TimingValue(_messages.Message):
    r"""Output only. Stores timing information for phases of the build. Valid
    keys are:  * BUILD: time to execute all build steps * PUSH: time to push
    all specified images. * FETCHSOURCE: time to fetch source.  If the build
    does not specify source or images, these keys will not be included.

    Messages:
      AdditionalProperty: An additional property for a TimingValue object.

    Fields:
      additionalProperties: Additional properties of type TimingValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TimingValue object.

      Fields:
        key: Name of the additional property.
        value: A TimeSpan attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('TimeSpan', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  artifacts = _messages.MessageField('Artifacts', 1)
  buildTriggerId = _messages.StringField(2)
  createTime = _messages.StringField(3)
  finishTime = _messages.StringField(4)
  id = _messages.StringField(5)
  images = _messages.StringField(6, repeated=True)
  logUrl = _messages.StringField(7)
  logsBucket = _messages.StringField(8)
  options = _messages.MessageField('BuildOptions', 9)
  projectId = _messages.StringField(10)
  queueTtl = _messages.StringField(11)
  results = _messages.MessageField('Results', 12)
  secrets = _messages.MessageField('Secret', 13, repeated=True)
  source = _messages.MessageField('Source', 14)
  sourceProvenance = _messages.MessageField('SourceProvenance', 15)
  startTime = _messages.StringField(16)
  status = _messages.EnumField('StatusValueValuesEnum', 17)
  statusDetail = _messages.StringField(18)
  steps = _messages.MessageField('BuildStep', 19, repeated=True)
  substitutions = _messages.MessageField('SubstitutionsValue', 20)
  tags = _messages.StringField(21, repeated=True)
  timeout = _messages.StringField(22)
  timing = _messages.MessageField('TimingValue', 23)


class BuildOperationMetadata(_messages.Message):
  r"""Metadata for build operations.

  Fields:
    build: The build that the operation is tracking.
  """

  build = _messages.MessageField('Build', 1)


class BuildOptions(_messages.Message):
  r"""Optional arguments to enable specific features of builds.

  Enums:
    LogStreamingOptionValueValuesEnum: Option to define build log streaming
      behavior to Google Cloud Storage.
    LoggingValueValuesEnum: Option to specify the logging mode, which
      determines if and where build logs are stored.
    MachineTypeValueValuesEnum: Compute Engine machine type on which to run
      the build.
    RequestedVerifyOptionValueValuesEnum: Requested verifiability options.
    SourceProvenanceHashValueListEntryValuesEnum:
    SubstitutionOptionValueValuesEnum: Option to specify behavior when there
      is an error in the substitution checks.  NOTE: this is always set to
      ALLOW_LOOSE for triggered builds and cannot be overridden in the build
      configuration file.

  Fields:
    diskSizeGb: Requested disk size for the VM that runs the build. Note that
      this is *NOT* "disk free"; some of the space will be used by the
      operating system and build utilities. Also note that this is the minimum
      disk size that will be allocated for the build -- the build may run with
      a larger disk than requested. At present, the maximum disk size is
      1000GB; builds that request more than the maximum are rejected with an
      error.
    dynamicSubstitutions: Option to specify whether or not to apply bash style
      string operations to the substitutions.  NOTE: this is always enabled
      for triggered builds and cannot be overridden in the build configuration
      file.
    env: A list of global environment variable definitions that will exist for
      all build steps in this build. If a variable is defined in both globally
      and in a build step, the variable will use the build step value.  The
      elements are of the form "KEY=VALUE" for the environment variable "KEY"
      being given the value "VALUE".
    logStreamingOption: Option to define build log streaming behavior to
      Google Cloud Storage.
    logging: Option to specify the logging mode, which determines if and where
      build logs are stored.
    machineType: Compute Engine machine type on which to run the build.
    requestedVerifyOption: Requested verifiability options.
    secretEnv: A list of global environment variables, which are encrypted
      using a Cloud Key Management Service crypto key. These values must be
      specified in the build's `Secret`. These variables will be available to
      all build steps in this build.
    sourceProvenanceHash: Requested hash for SourceProvenance.
    substitutionOption: Option to specify behavior when there is an error in
      the substitution checks.  NOTE: this is always set to ALLOW_LOOSE for
      triggered builds and cannot be overridden in the build configuration
      file.
    volumes: Global list of volumes to mount for ALL build steps  Each volume
      is created as an empty volume prior to starting the build process. Upon
      completion of the build, volumes and their contents are discarded.
      Global volume names and paths cannot conflict with the volumes defined a
      build step.  Using a global volume in a build with only one step is not
      valid as it is indicative of a build request with an incorrect
      configuration.
    workerPool: Option to specify a `WorkerPool` for the build. Format:
      projects/{project}/workerPools/{workerPool}  This field is experimental.
  """

  class LogStreamingOptionValueValuesEnum(_messages.Enum):
    r"""Option to define build log streaming behavior to Google Cloud Storage.

    Values:
      STREAM_DEFAULT: Service may automatically determine build log streaming
        behavior.
      STREAM_ON: Build logs should be streamed to Google Cloud Storage.
      STREAM_OFF: Build logs should not be streamed to Google Cloud Storage;
        they will be written when the build is completed.
    """
    STREAM_DEFAULT = 0
    STREAM_ON = 1
    STREAM_OFF = 2

  class LoggingValueValuesEnum(_messages.Enum):
    r"""Option to specify the logging mode, which determines if and where
    build logs are stored.

    Values:
      LOGGING_UNSPECIFIED: The service determines the logging mode. The
        default is `LEGACY`. Do not rely on the default logging behavior as it
        may change in the future.
      LEGACY: Stackdriver logging and Cloud Storage logging are enabled.
      GCS_ONLY: Only Cloud Storage logging is enabled.
    """
    LOGGING_UNSPECIFIED = 0
    LEGACY = 1
    GCS_ONLY = 2

  class MachineTypeValueValuesEnum(_messages.Enum):
    r"""Compute Engine machine type on which to run the build.

    Values:
      UNSPECIFIED: Standard machine type.
      N1_HIGHCPU_8: Highcpu machine with 8 CPUs.
      N1_HIGHCPU_32: Highcpu machine with 32 CPUs.
    """
    UNSPECIFIED = 0
    N1_HIGHCPU_8 = 1
    N1_HIGHCPU_32 = 2

  class RequestedVerifyOptionValueValuesEnum(_messages.Enum):
    r"""Requested verifiability options.

    Values:
      NOT_VERIFIED: Not a verifiable build. (default)
      VERIFIED: Verified build.
    """
    NOT_VERIFIED = 0
    VERIFIED = 1

  class SourceProvenanceHashValueListEntryValuesEnum(_messages.Enum):
    r"""SourceProvenanceHashValueListEntryValuesEnum enum type.

    Values:
      NONE: <no description>
      SHA256: <no description>
      MD5: <no description>
    """
    NONE = 0
    SHA256 = 1
    MD5 = 2

  class SubstitutionOptionValueValuesEnum(_messages.Enum):
    r"""Option to specify behavior when there is an error in the substitution
    checks.  NOTE: this is always set to ALLOW_LOOSE for triggered builds and
    cannot be overridden in the build configuration file.

    Values:
      MUST_MATCH: Fails the build if error in substitutions checks, like
        missing a substitution in the template or in the map.
      ALLOW_LOOSE: Do not fail the build if error in substitutions checks.
    """
    MUST_MATCH = 0
    ALLOW_LOOSE = 1

  diskSizeGb = _messages.IntegerField(1)
  dynamicSubstitutions = _messages.BooleanField(2)
  env = _messages.StringField(3, repeated=True)
  logStreamingOption = _messages.EnumField('LogStreamingOptionValueValuesEnum', 4)
  logging = _messages.EnumField('LoggingValueValuesEnum', 5)
  machineType = _messages.EnumField('MachineTypeValueValuesEnum', 6)
  requestedVerifyOption = _messages.EnumField('RequestedVerifyOptionValueValuesEnum', 7)
  secretEnv = _messages.StringField(8, repeated=True)
  sourceProvenanceHash = _messages.EnumField('SourceProvenanceHashValueListEntryValuesEnum', 9, repeated=True)
  substitutionOption = _messages.EnumField('SubstitutionOptionValueValuesEnum', 10)
  volumes = _messages.MessageField('Volume', 11, repeated=True)
  workerPool = _messages.StringField(12)


class BuildStep(_messages.Message):
  r"""A step in the build pipeline.

  Enums:
    StatusValueValuesEnum: Output only. Status of the build step. At this
      time, build step status is only updated on build completion; step status
      is not updated in real-time as the build progresses.

  Fields:
    args: A list of arguments that will be presented to the step when it is
      started.  If the image used to run the step's container has an
      entrypoint, the `args` are used as arguments to that entrypoint. If the
      image does not define an entrypoint, the first element in args is used
      as the entrypoint, and the remainder will be used as arguments.
    dir: Working directory to use when running this step's container.  If this
      value is a relative path, it is relative to the build's working
      directory. If this value is absolute, it may be outside the build's
      working directory, in which case the contents of the path may not be
      persisted across build step executions, unless a `volume` for that path
      is specified.  If the build specifies a `RepoSource` with `dir` and a
      step with a `dir`, which specifies an absolute path, the `RepoSource`
      `dir` is ignored for the step's execution.
    entrypoint: Entrypoint to be used instead of the build step image's
      default entrypoint. If unset, the image's default entrypoint is used.
    env: A list of environment variable definitions to be used when running a
      step.  The elements are of the form "KEY=VALUE" for the environment
      variable "KEY" being given the value "VALUE".
    id: Unique identifier for this build step, used in `wait_for` to reference
      this build step as a dependency.
    name: Required. The name of the container image that will run this
      particular build step.  If the image is available in the host's Docker
      daemon's cache, it will be run directly. If not, the host will attempt
      to pull the image first, using the builder service account's credentials
      if necessary.  The Docker daemon's cache will already have the latest
      versions of all of the officially supported build steps
      ([https://github.com/GoogleCloudPlatform/cloud-
      builders](https://github.com/GoogleCloudPlatform/cloud-builders)). The
      Docker daemon will also have cached many of the layers for some popular
      images, like "ubuntu", "debian", but they will be refreshed at the time
      you attempt to use them.  If you built an image in a previous build
      step, it will be stored in the host's Docker daemon's cache and is
      available to use as the name for a later build step.
    pullTiming: Output only. Stores timing information for pulling this build
      step's builder image only.
    secretEnv: A list of environment variables which are encrypted using a
      Cloud Key Management Service crypto key. These values must be specified
      in the build's `Secret`.
    status: Output only. Status of the build step. At this time, build step
      status is only updated on build completion; step status is not updated
      in real-time as the build progresses.
    timeout: Time limit for executing this build step. If not defined, the
      step has no time limit and will be allowed to continue to run until
      either it completes or the build itself times out.
    timing: Output only. Stores timing information for executing this build
      step.
    volumes: List of volumes to mount into the build step.  Each volume is
      created as an empty volume prior to execution of the build step. Upon
      completion of the build, volumes and their contents are discarded.
      Using a named volume in only one step is not valid as it is indicative
      of a build request with an incorrect configuration.
    waitFor: The ID(s) of the step(s) that this build step depends on. This
      build step will not start until all the build steps in `wait_for` have
      completed successfully. If `wait_for` is empty, this build step will
      start when all previous build steps in the `Build.Steps` list have
      completed successfully.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Output only. Status of the build step. At this time, build step status
    is only updated on build completion; step status is not updated in real-
    time as the build progresses.

    Values:
      STATUS_UNKNOWN: Status of the build is unknown.
      QUEUED: Build or step is queued; work has not yet begun.
      WORKING: Build or step is being executed.
      SUCCESS: Build or step finished successfully.
      FAILURE: Build or step failed to complete successfully.
      INTERNAL_ERROR: Build or step failed due to an internal cause.
      TIMEOUT: Build or step took longer than was allowed.
      CANCELLED: Build or step was canceled by a user.
      EXPIRED: Build was enqueued for longer than the value of `queue_ttl`.
    """
    STATUS_UNKNOWN = 0
    QUEUED = 1
    WORKING = 2
    SUCCESS = 3
    FAILURE = 4
    INTERNAL_ERROR = 5
    TIMEOUT = 6
    CANCELLED = 7
    EXPIRED = 8

  args = _messages.StringField(1, repeated=True)
  dir = _messages.StringField(2)
  entrypoint = _messages.StringField(3)
  env = _messages.StringField(4, repeated=True)
  id = _messages.StringField(5)
  name = _messages.StringField(6)
  pullTiming = _messages.MessageField('TimeSpan', 7)
  secretEnv = _messages.StringField(8, repeated=True)
  status = _messages.EnumField('StatusValueValuesEnum', 9)
  timeout = _messages.StringField(10)
  timing = _messages.MessageField('TimeSpan', 11)
  volumes = _messages.MessageField('Volume', 12, repeated=True)
  waitFor = _messages.StringField(13, repeated=True)


class BuiltImage(_messages.Message):
  r"""An image built by the pipeline.

  Fields:
    digest: Docker Registry 2.0 digest.
    name: Name used to push the container image to Google Container Registry,
      as presented to `docker push`.
    pushTiming: Output only. Stores timing information for pushing the
      specified image.
  """

  digest = _messages.StringField(1)
  name = _messages.StringField(2)
  pushTiming = _messages.MessageField('TimeSpan', 3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudbuildProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudbuildProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CloudbuildProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A CloudbuildProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class CloudbuildProjectsWorkerPoolsCreateRequest(_messages.Message):
  r"""A CloudbuildProjectsWorkerPoolsCreateRequest object.

  Fields:
    parent: ID of the parent project.
    workerPool: A WorkerPool resource to be passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  workerPool = _messages.MessageField('WorkerPool', 2)


class CloudbuildProjectsWorkerPoolsDeleteRequest(_messages.Message):
  r"""A CloudbuildProjectsWorkerPoolsDeleteRequest object.

  Fields:
    name: The field will contain name of the resource requested, for example:
      "projects/project-1/workerPools/workerpool-name"
  """

  name = _messages.StringField(1, required=True)


class CloudbuildProjectsWorkerPoolsGetRequest(_messages.Message):
  r"""A CloudbuildProjectsWorkerPoolsGetRequest object.

  Fields:
    name: The field will contain name of the resource requested, for example:
      "projects/project-1/workerPools/workerpool-name"
  """

  name = _messages.StringField(1, required=True)


class CloudbuildProjectsWorkerPoolsListRequest(_messages.Message):
  r"""A CloudbuildProjectsWorkerPoolsListRequest object.

  Fields:
    parent: ID of the parent project.
  """

  parent = _messages.StringField(1, required=True)


class CloudbuildProjectsWorkerPoolsPatchRequest(_messages.Message):
  r"""A CloudbuildProjectsWorkerPoolsPatchRequest object.

  Fields:
    name: The field will contain name of the resource requested, for example:
      "projects/project-1/workerPools/workerpool-name"
    workerPool: A WorkerPool resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  workerPool = _messages.MessageField('WorkerPool', 2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class FileHashes(_messages.Message):
  r"""Container message for hashes of byte content of files, used in
  SourceProvenance messages to verify integrity of source input to the build.

  Fields:
    fileHash: Collection of file hashes.
  """

  fileHash = _messages.MessageField('Hash', 1, repeated=True)


class Hash(_messages.Message):
  r"""Container message for hash values.

  Enums:
    TypeValueValuesEnum: The type of hash that was performed.

  Fields:
    type: The type of hash that was performed.
    value: The hash value.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of hash that was performed.

    Values:
      NONE: No hash requested.
      SHA256: Use a sha256 hash.
      MD5: Use a md5 hash.
    """
    NONE = 0
    SHA256 = 1
    MD5 = 2

  type = _messages.EnumField('TypeValueValuesEnum', 1)
  value = _messages.BytesField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListWorkerPoolsResponse(_messages.Message):
  r"""Response containing existing `WorkerPools`.

  Fields:
    workerPools: `WorkerPools` for the project.
  """

  workerPools = _messages.MessageField('WorkerPool', 1, repeated=True)


class Network(_messages.Message):
  r"""Network describes the GCP network used to create workers in.

  Fields:
    network: Network on which the workers are created. "default" network is
      used if empty.
    projectId: Project id containing the defined network and subnetwork. For a
      peered VPC, this will be the same as the project_id in which the workers
      are created. For a shared VPC, this will be the project sharing the
      network with the project_id project in which workers will be created.
      For custom workers with no VPC, this will be the same as project_id.
    subnetwork: Subnetwork on which the workers are created. "default"
      subnetwork is used if empty.
  """

  network = _messages.StringField(1)
  projectId = _messages.StringField(2)
  subnetwork = _messages.StringField(3)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class RepoSource(_messages.Message):
  r"""Location of the source in a Google Cloud Source Repository.

  Messages:
    SubstitutionsValue: Substitutions to use in a triggered build. Should only
      be used with RunBuildTrigger

  Fields:
    branchName: Regex matching branches to build.  The syntax of the regular
      expressions accepted is the syntax accepted by RE2 and described at
      https://github.com/google/re2/wiki/Syntax
    commitSha: Explicit commit SHA to build.
    dir: Directory, relative to the source root, in which to run the build.
      This must be a relative path. If a step's `dir` is specified and is an
      absolute path, this value is ignored for that step's execution.
    invertRegex: Only trigger a build if the revision regex does NOT match the
      revision regex.
    projectId: ID of the project that owns the Cloud Source Repository. If
      omitted, the project ID requesting the build is assumed.
    repoName: Required. Name of the Cloud Source Repository.
    substitutions: Substitutions to use in a triggered build. Should only be
      used with RunBuildTrigger
    tagName: Regex matching tags to build.  The syntax of the regular
      expressions accepted is the syntax accepted by RE2 and described at
      https://github.com/google/re2/wiki/Syntax
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SubstitutionsValue(_messages.Message):
    r"""Substitutions to use in a triggered build. Should only be used with
    RunBuildTrigger

    Messages:
      AdditionalProperty: An additional property for a SubstitutionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type SubstitutionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SubstitutionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  branchName = _messages.StringField(1)
  commitSha = _messages.StringField(2)
  dir = _messages.StringField(3)
  invertRegex = _messages.BooleanField(4)
  projectId = _messages.StringField(5)
  repoName = _messages.StringField(6)
  substitutions = _messages.MessageField('SubstitutionsValue', 7)
  tagName = _messages.StringField(8)


class Results(_messages.Message):
  r"""Artifacts created by the build pipeline.

  Fields:
    artifactManifest: Path to the artifact manifest. Only populated when
      artifacts are uploaded.
    artifactTiming: Time to push all non-container artifacts.
    buildStepImages: List of build step digests, in the order corresponding to
      build step indices.
    buildStepOutputs: List of build step outputs, produced by builder images,
      in the order corresponding to build step indices.  [Cloud
      Builders](https://cloud.google.com/cloud-build/docs/cloud-builders) can
      produce this output by writing to `$BUILDER_OUTPUT/output`. Only the
      first 4KB of data is stored.
    images: Container images that were built as a part of the build.
    numArtifacts: Number of artifacts uploaded. Only populated when artifacts
      are uploaded.
  """

  artifactManifest = _messages.StringField(1)
  artifactTiming = _messages.MessageField('TimeSpan', 2)
  buildStepImages = _messages.StringField(3, repeated=True)
  buildStepOutputs = _messages.BytesField(4, repeated=True)
  images = _messages.MessageField('BuiltImage', 5, repeated=True)
  numArtifacts = _messages.IntegerField(6)


class Secret(_messages.Message):
  r"""Pairs a set of secret environment variables containing encrypted values
  with the Cloud KMS key to use to decrypt the value.

  Messages:
    SecretEnvValue: Map of environment variable name to its encrypted value.
      Secret environment variables must be unique across all of a build's
      secrets, and must be used by at least one build step. Values can be at
      most 64 KB in size. There can be at most 100 secret values across all of
      a build's secrets.

  Fields:
    kmsKeyName: Cloud KMS key name to use to decrypt these envs.
    secretEnv: Map of environment variable name to its encrypted value.
      Secret environment variables must be unique across all of a build's
      secrets, and must be used by at least one build step. Values can be at
      most 64 KB in size. There can be at most 100 secret values across all of
      a build's secrets.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SecretEnvValue(_messages.Message):
    r"""Map of environment variable name to its encrypted value.  Secret
    environment variables must be unique across all of a build's secrets, and
    must be used by at least one build step. Values can be at most 64 KB in
    size. There can be at most 100 secret values across all of a build's
    secrets.

    Messages:
      AdditionalProperty: An additional property for a SecretEnvValue object.

    Fields:
      additionalProperties: Additional properties of type SecretEnvValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SecretEnvValue object.

      Fields:
        key: Name of the additional property.
        value: A byte attribute.
      """

      key = _messages.StringField(1)
      value = _messages.BytesField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  kmsKeyName = _messages.StringField(1)
  secretEnv = _messages.MessageField('SecretEnvValue', 2)


class Source(_messages.Message):
  r"""Location of the source in a supported storage service.

  Fields:
    repoSource: If provided, get the source from this location in a Cloud
      Source Repository.
    storageSource: If provided, get the source from this location in Google
      Cloud Storage.
  """

  repoSource = _messages.MessageField('RepoSource', 1)
  storageSource = _messages.MessageField('StorageSource', 2)


class SourceProvenance(_messages.Message):
  r"""Provenance of the source. Ways to find the original source, or verify
  that some source was used for this build.

  Messages:
    FileHashesValue: Output only. Hash(es) of the build source, which can be
      used to verify that the original source integrity was maintained in the
      build. Note that `FileHashes` will only be populated if `BuildOptions`
      has requested a `SourceProvenanceHash`.  The keys to this map are file
      paths used as build source and the values contain the hash values for
      those files.  If the build source came in a single package such as a
      gzipped tarfile (`.tar.gz`), the `FileHash` will be for the single path
      to that file.

  Fields:
    fileHashes: Output only. Hash(es) of the build source, which can be used
      to verify that the original source integrity was maintained in the
      build. Note that `FileHashes` will only be populated if `BuildOptions`
      has requested a `SourceProvenanceHash`.  The keys to this map are file
      paths used as build source and the values contain the hash values for
      those files.  If the build source came in a single package such as a
      gzipped tarfile (`.tar.gz`), the `FileHash` will be for the single path
      to that file.
    resolvedRepoSource: A copy of the build's `source.repo_source`, if exists,
      with any revisions resolved.
    resolvedStorageSource: A copy of the build's `source.storage_source`, if
      exists, with any generations resolved.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FileHashesValue(_messages.Message):
    r"""Output only. Hash(es) of the build source, which can be used to verify
    that the original source integrity was maintained in the build. Note that
    `FileHashes` will only be populated if `BuildOptions` has requested a
    `SourceProvenanceHash`.  The keys to this map are file paths used as build
    source and the values contain the hash values for those files.  If the
    build source came in a single package such as a gzipped tarfile
    (`.tar.gz`), the `FileHash` will be for the single path to that file.

    Messages:
      AdditionalProperty: An additional property for a FileHashesValue object.

    Fields:
      additionalProperties: Additional properties of type FileHashesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FileHashesValue object.

      Fields:
        key: Name of the additional property.
        value: A FileHashes attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('FileHashes', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  fileHashes = _messages.MessageField('FileHashesValue', 1)
  resolvedRepoSource = _messages.MessageField('RepoSource', 2)
  resolvedStorageSource = _messages.MessageField('StorageSource', 3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StorageSource(_messages.Message):
  r"""Location of the source in an archive file in Google Cloud Storage.

  Fields:
    bucket: Google Cloud Storage bucket containing the source (see [Bucket
      Name Requirements](https://cloud.google.com/storage/docs/bucket-
      naming#requirements)).
    generation: Google Cloud Storage generation for the object. If the
      generation is omitted, the latest generation will be used.
    object: Google Cloud Storage object containing the source.  This object
      must be a gzipped archive file (`.tar.gz`) containing source to build.
  """

  bucket = _messages.StringField(1)
  generation = _messages.IntegerField(2)
  object = _messages.StringField(3)


class TimeSpan(_messages.Message):
  r"""Start and end times for a build execution phase.

  Fields:
    endTime: End of time span.
    startTime: Start of time span.
  """

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class Volume(_messages.Message):
  r"""Volume describes a Docker container volume which is mounted into build
  steps in order to persist files across build step execution.

  Fields:
    name: Name of the volume to mount.  Volume names must be unique per build
      step and must be valid names for Docker volumes. Each named volume must
      be used by at least two build steps.
    path: Path at which to mount the volume.  Paths must be absolute and
      cannot conflict with other volume paths on the same build step or with
      certain reserved volume paths.
  """

  name = _messages.StringField(1)
  path = _messages.StringField(2)


class WorkerConfig(_messages.Message):
  r"""WorkerConfig defines the configuration to be used for a creating workers
  in the pool.

  Fields:
    diskSizeGb: Size of the disk attached to the worker, in GB. See
      https://cloud.google.com/compute/docs/disks/ If `0` is specified, Cloud
      Build will use a standard disk size. `disk_size` is overridden if you
      specify a different disk size in `build_options`. In this case, a VM
      with a disk size specified in the `build_options` will be created on
      demand at build time. For more information see
      https://cloud.google.com/cloud-
      build/docs/api/reference/rest/v1/projects.builds#buildoptions
    machineType: Machine Type of the worker, such as n1-standard-1. See
      https://cloud.google.com/compute/docs/machine-types. If left blank,
      Cloud Build will use a standard unspecified machine to create the worker
      pool. `machine_type` is overridden if you specify a different machine
      type in `build_options`. In this case, the VM specified in the
      `build_options` will be created on demand at build time. For more
      information see https://cloud.google.com/cloud-build/docs/speeding-up-
      builds#using_custom_virtual_machine_sizes
    network: The network definition used to create the worker. If this section
      is left empty, the workers will be created in WorkerPool.project_id on
      the default network.
    tag: The tag applied to the worker, and the same tag used by the firewall
      rule. It is used to identify the Cloud Build workers among other VMs.
      The default value for tag is `worker`.
  """

  diskSizeGb = _messages.IntegerField(1)
  machineType = _messages.StringField(2)
  network = _messages.MessageField('Network', 3)
  tag = _messages.StringField(4)


class WorkerPool(_messages.Message):
  r"""Configuration for a WorkerPool to run the builds.  Workers are machines
  that Cloud Build uses to run your builds. By default, all workers run in a
  project owned by Cloud Build. To have full control over the workers that
  execute your builds -- such as enabling them to access private resources on
  your private network -- you can request Cloud Build to run the workers in
  your own project by creating a custom workers pool.

  Enums:
    RegionsValueListEntryValuesEnum:
    StatusValueValuesEnum: Output only. WorkerPool Status.

  Fields:
    createTime: Output only. Time at which the request to create the
      `WorkerPool` was received.
    deleteTime: Output only. Time at which the request to delete the
      `WorkerPool` was received.
    name: User-defined name of the `WorkerPool`.
    projectId: The project ID of the GCP project for which the `WorkerPool` is
      created.
    regions: List of regions to create the `WorkerPool`. Regions can't be
      empty. If Cloud Build adds a new GCP region in the future, the existing
      `WorkerPool` will not be enabled in the new region automatically; you
      must add the new region to the `regions` field to enable the
      `WorkerPool` in that region.
    serviceAccountEmail: Output only. The service account used to manage the
      `WorkerPool`. The service account must have the Compute Instance Admin
      (Beta) permission at the project level.
    status: Output only. WorkerPool Status.
    updateTime: Output only. Time at which the request to update the
      `WorkerPool` was received.
    workerConfig: Configuration to be used for a creating workers in the
      `WorkerPool`.
    workerCount: Total number of workers to be created across all requested
      regions.
  """

  class RegionsValueListEntryValuesEnum(_messages.Enum):
    r"""RegionsValueListEntryValuesEnum enum type.

    Values:
      REGION_UNSPECIFIED: <no description>
      us_central1: <no description>
      us_west1: <no description>
      us_east1: <no description>
      us_east4: <no description>
    """
    REGION_UNSPECIFIED = 0
    us_central1 = 1
    us_west1 = 2
    us_east1 = 3
    us_east4 = 4

  class StatusValueValuesEnum(_messages.Enum):
    r"""Output only. WorkerPool Status.

    Values:
      STATUS_UNSPECIFIED: Status of the `WorkerPool` is unknown.
      CREATING: `WorkerPool` is being created.
      RUNNING: `WorkerPool` is running.
      DELETING: `WorkerPool` is being deleted: cancelling builds and draining
        workers.
      DELETED: `WorkerPool` is deleted.
    """
    STATUS_UNSPECIFIED = 0
    CREATING = 1
    RUNNING = 2
    DELETING = 3
    DELETED = 4

  createTime = _messages.StringField(1)
  deleteTime = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  regions = _messages.EnumField('RegionsValueListEntryValuesEnum', 5, repeated=True)
  serviceAccountEmail = _messages.StringField(6)
  status = _messages.EnumField('StatusValueValuesEnum', 7)
  updateTime = _messages.StringField(8)
  workerConfig = _messages.MessageField('WorkerConfig', 9)
  workerCount = _messages.IntegerField(10)


encoding.AddCustomJsonEnumMapping(
    WorkerPool.RegionsValueListEntryValuesEnum, 'us_central1', 'us-central1')
encoding.AddCustomJsonEnumMapping(
    WorkerPool.RegionsValueListEntryValuesEnum, 'us_west1', 'us-west1')
encoding.AddCustomJsonEnumMapping(
    WorkerPool.RegionsValueListEntryValuesEnum, 'us_east1', 'us-east1')
encoding.AddCustomJsonEnumMapping(
    WorkerPool.RegionsValueListEntryValuesEnum, 'us_east4', 'us-east4')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
