"""Generated message classes for dataproc version v1.

Manages Hadoop-based clusters and jobs on Google Cloud Platform.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'dataproc'


class AcceleratorConfig(_messages.Message):
  r"""Specifies the type and number of accelerator cards attached to the
  instances of an instance. See GPUs on Compute Engine
  (https://cloud.google.com/compute/docs/gpus/).

  Fields:
    acceleratorCount: The number of the accelerator cards of this type exposed
      to this instance.
    acceleratorTypeUri: Full URL, partial URI, or short name of the
      accelerator type resource to expose to this instance. See Compute Engine
      AcceleratorTypes (https://cloud.google.com/compute/docs/reference/beta/a
      cceleratorTypes).Examples:
      https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-
      east1-a/acceleratorTypes/nvidia-tesla-k80
      projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80
      nvidia-tesla-k80Auto Zone Exception: If you are using the Dataproc Auto
      Zone Placement
      (https://cloud.google.com/dataproc/docs/concepts/configuring-
      clusters/auto-zone#using_auto_zone_placement) feature, you must use the
      short name of the accelerator type resource, for example, nvidia-
      tesla-k80.
  """

  acceleratorCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  acceleratorTypeUri = _messages.StringField(2)


class AutoscalingConfig(_messages.Message):
  r"""Autoscaling Policy config associated with the cluster.

  Fields:
    policyUri: Optional. The autoscaling policy used by the cluster.Only
      resource names including projectid and location (region) are valid.
      Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/lo
      cations/[dataproc_region]/autoscalingPolicies/[policy_id] projects/[proj
      ect_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]Note
      that the policy must be in the same project and Dataproc region.
  """

  policyUri = _messages.StringField(1)


class AutoscalingPolicy(_messages.Message):
  r"""Describes an autoscaling policy for Dataproc cluster autoscaler.

  Fields:
    basicAlgorithm: A BasicAutoscalingAlgorithm attribute.
    id: Required. The policy id.The id must contain only letters (a-z, A-Z),
      numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end
      with underscore or hyphen. Must consist of between 3 and 50 characters.
    name: Output only. The "resource name" of the autoscaling policy, as
      described in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.autoscalingPolicies, the resource name of the  policy
      has the following format:
      projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}
      For projects.locations.autoscalingPolicies, the resource name of the
      policy has the following format:  projects/{project_id}/locations/{locat
      ion}/autoscalingPolicies/{policy_id}
    secondaryWorkerConfig: Optional. Describes how the autoscaler will operate
      for secondary workers.
    workerConfig: Required. Describes how the autoscaler will operate for
      primary workers.
  """

  basicAlgorithm = _messages.MessageField('BasicAutoscalingAlgorithm', 1)
  id = _messages.StringField(2)
  name = _messages.StringField(3)
  secondaryWorkerConfig = _messages.MessageField('InstanceGroupAutoscalingPolicyConfig', 4)
  workerConfig = _messages.MessageField('InstanceGroupAutoscalingPolicyConfig', 5)


class BasicAutoscalingAlgorithm(_messages.Message):
  r"""Basic algorithm for autoscaling.

  Fields:
    cooldownPeriod: Optional. Duration between scaling events. A scaling
      period starts after the update operation from the previous event has
      completed.Bounds: 2m, 1d. Default: 2m.
    yarnConfig: Required. YARN autoscaling configuration.
  """

  cooldownPeriod = _messages.StringField(1)
  yarnConfig = _messages.MessageField('BasicYarnAutoscalingConfig', 2)


class BasicYarnAutoscalingConfig(_messages.Message):
  r"""Basic autoscaling configurations for YARN.

  Fields:
    gracefulDecommissionTimeout: Required. Timeout for YARN graceful
      decommissioning of Node Managers. Specifies the duration to wait for
      jobs to complete before forcefully removing workers (and potentially
      interrupting jobs). Only applicable to downscaling operations.Bounds:
      0s, 1d.
    scaleDownFactor: Required. Fraction of average YARN pending memory in the
      last cooldown period for which to remove workers. A scale-down factor of
      1 will result in scaling down so that there is no available memory
      remaining after the update (more aggressive scaling). A scale-down
      factor of 0 disables removing workers, which can be beneficial for
      autoscaling a single job. See How autoscaling works for more
      information.Bounds: 0.0, 1.0.
    scaleDownMinWorkerFraction: Optional. Minimum scale-down threshold as a
      fraction of total cluster size before scaling occurs. For example, in a
      20-worker cluster, a threshold of 0.1 means the autoscaler must
      recommend at least a 2 worker scale-down for the cluster to scale. A
      threshold of 0 means the autoscaler will scale down on any recommended
      change.Bounds: 0.0, 1.0. Default: 0.0.
    scaleUpFactor: Required. Fraction of average YARN pending memory in the
      last cooldown period for which to add workers. A scale-up factor of 1.0
      will result in scaling up so that there is no pending memory remaining
      after the update (more aggressive scaling). A scale-up factor closer to
      0 will result in a smaller magnitude of scaling up (less aggressive
      scaling). See How autoscaling works for more information.Bounds: 0.0,
      1.0.
    scaleUpMinWorkerFraction: Optional. Minimum scale-up threshold as a
      fraction of total cluster size before scaling occurs. For example, in a
      20-worker cluster, a threshold of 0.1 means the autoscaler must
      recommend at least a 2-worker scale-up for the cluster to scale. A
      threshold of 0 means the autoscaler will scale up on any recommended
      change.Bounds: 0.0, 1.0. Default: 0.0.
  """

  gracefulDecommissionTimeout = _messages.StringField(1)
  scaleDownFactor = _messages.FloatField(2)
  scaleDownMinWorkerFraction = _messages.FloatField(3)
  scaleUpFactor = _messages.FloatField(4)
  scaleUpMinWorkerFraction = _messages.FloatField(5)


class Binding(_messages.Message):
  r"""Associates members with a role.

  Fields:
    condition: The condition that is associated with this binding.If the
      condition evaluates to true, then this binding applies to the current
      request.If the condition evaluates to false, then this binding does not
      apply to the current request. However, a different role binding might
      grant the same role to one or more of the members in this binding.To
      learn which resources support conditions in their IAM policies, see the
      IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
    members: Specifies the identities requesting access for a Cloud Platform
      resource. members can have the following values: allUsers: A special
      identifier that represents anyone who is  on the internet; with or
      without a Google account. allAuthenticatedUsers: A special identifier
      that represents anyone  who is authenticated with a Google account or a
      service account. user:{emailid}: An email address that represents a
      specific Google  account. For example, alice@example.com .
      serviceAccount:{emailid}: An email address that represents a service
      account. For example, my-other-app@appspot.gserviceaccount.com.
      group:{emailid}: An email address that represents a Google group.  For
      example, admins@example.com. deleted:user:{emailid}?uid={uniqueid}: An
      email address (plus unique  identifier) representing a user that has
      been recently deleted. For  example,
      alice@example.com?uid=123456789012345678901. If the user is  recovered,
      this value reverts to user:{emailid} and the recovered user  retains the
      role in the binding. deleted:serviceAccount:{emailid}?uid={uniqueid}: An
      email address (plus  unique identifier) representing a service account
      that has been recently  deleted. For example,  my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901.  If the
      service account is undeleted, this value reverts to
      serviceAccount:{emailid} and the undeleted service account retains the
      role in the binding. deleted:group:{emailid}?uid={uniqueid}: An email
      address (plus unique  identifier) representing a Google group that has
      been recently  deleted. For example,
      admins@example.com?uid=123456789012345678901. If  the group is
      recovered, this value reverts to group:{emailid} and the  recovered
      group retains the role in the binding. domain:{domain}: The G Suite
      domain (primary) that represents all the  users of that domain. For
      example, google.com or example.com.
    role: Role that is assigned to members. For example, roles/viewer,
      roles/editor, or roles/owner.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelJobRequest(_messages.Message):
  r"""A request to cancel a job."""


class Cluster(_messages.Message):
  r"""Describes the identifying information, config, and status of a cluster
  of Compute Engine instances.

  Messages:
    LabelsValue: Optional. The labels to associate with this cluster. Label
      keys must contain 1 to 63 characters, and must conform to RFC 1035
      (https://www.ietf.org/rfc/rfc1035.txt). Label values may be empty, but,
      if present, must contain 1 to 63 characters, and must conform to RFC
      1035 (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can
      be associated with a cluster.

  Fields:
    clusterName: Required. The cluster name. Cluster names within a project
      must be unique. Names of deleted clusters can be reused.
    clusterUuid: Output only. A cluster UUID (Unique Universal Identifier).
      Dataproc generates this value when it creates the cluster.
    config: Required. The cluster config. Note that Dataproc may set default
      values, and values may change when clusters are updated.
    labels: Optional. The labels to associate with this cluster. Label keys
      must contain 1 to 63 characters, and must conform to RFC 1035
      (https://www.ietf.org/rfc/rfc1035.txt). Label values may be empty, but,
      if present, must contain 1 to 63 characters, and must conform to RFC
      1035 (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can
      be associated with a cluster.
    metrics: Output only. Contains cluster daemon metrics such as HDFS and
      YARN stats.Beta Feature: This report is available for testing purposes
      only. It may be changed before final release.
    projectId: Required. The Google Cloud Platform project ID that the cluster
      belongs to.
    status: Output only. Cluster status.
    statusHistory: Output only. The previous cluster status.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels to associate with this cluster. Label keys must
    contain 1 to 63 characters, and must conform to RFC 1035
    (https://www.ietf.org/rfc/rfc1035.txt). Label values may be empty, but, if
    present, must contain 1 to 63 characters, and must conform to RFC 1035
    (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
    associated with a cluster.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusterName = _messages.StringField(1)
  clusterUuid = _messages.StringField(2)
  config = _messages.MessageField('ClusterConfig', 3)
  labels = _messages.MessageField('LabelsValue', 4)
  metrics = _messages.MessageField('ClusterMetrics', 5)
  projectId = _messages.StringField(6)
  status = _messages.MessageField('ClusterStatus', 7)
  statusHistory = _messages.MessageField('ClusterStatus', 8, repeated=True)


class ClusterConfig(_messages.Message):
  r"""The cluster config.

  Fields:
    autoscalingConfig: Optional. Autoscaling config for the policy associated
      with the cluster. Cluster does not autoscale if this field is unset.
    configBucket: Optional. A Cloud Storage bucket used to stage job
      dependencies, config files, and job driver console output. If you do not
      specify a staging bucket, Cloud Dataproc will determine a Cloud Storage
      location (US, ASIA, or EU) for your cluster's staging bucket according
      to the Compute Engine zone where your cluster is deployed, and then
      create and manage this project-level, per-location bucket (see Dataproc
      staging bucket
      (https://cloud.google.com/dataproc/docs/concepts/configuring-
      clusters/staging-bucket)).
    encryptionConfig: Optional. Encryption settings for the cluster.
    endpointConfig: Optional. Port/endpoint configuration for this cluster
    gceClusterConfig: Optional. The shared Compute Engine config settings for
      all instances in a cluster.
    initializationActions: Optional. Commands to execute on each node after
      config is completed. By default, executables are run on master and all
      worker nodes. You can test a node's role metadata to run an executable
      on a master or worker node, as shown below using curl (you can also use
      wget): ROLE=$(curl -H Metadata-Flavor:Google
      http://metadata/computeMetadata/v1/instance/attributes/dataproc-role) if
      [[ "${ROLE}" == 'Master' ]]; then   ... master specific actions ... else
      ... worker specific actions ... fi
    lifecycleConfig: Optional. Lifecycle setting for the cluster.
    masterConfig: Optional. The Compute Engine config settings for the master
      instance in a cluster.
    secondaryWorkerConfig: Optional. The Compute Engine config settings for
      additional worker instances in a cluster.
    securityConfig: Optional. Security settings for the cluster.
    softwareConfig: Optional. The config settings for software inside the
      cluster.
    workerConfig: Optional. The Compute Engine config settings for worker
      instances in a cluster.
  """

  autoscalingConfig = _messages.MessageField('AutoscalingConfig', 1)
  configBucket = _messages.StringField(2)
  encryptionConfig = _messages.MessageField('EncryptionConfig', 3)
  endpointConfig = _messages.MessageField('EndpointConfig', 4)
  gceClusterConfig = _messages.MessageField('GceClusterConfig', 5)
  initializationActions = _messages.MessageField('NodeInitializationAction', 6, repeated=True)
  lifecycleConfig = _messages.MessageField('LifecycleConfig', 7)
  masterConfig = _messages.MessageField('InstanceGroupConfig', 8)
  secondaryWorkerConfig = _messages.MessageField('InstanceGroupConfig', 9)
  securityConfig = _messages.MessageField('SecurityConfig', 10)
  softwareConfig = _messages.MessageField('SoftwareConfig', 11)
  workerConfig = _messages.MessageField('InstanceGroupConfig', 12)


class ClusterMetrics(_messages.Message):
  r"""Contains cluster daemon metrics, such as HDFS and YARN stats.Beta
  Feature: This report is available for testing purposes only. It may be
  changed before final release.

  Messages:
    HdfsMetricsValue: The HDFS metrics.
    YarnMetricsValue: The YARN metrics.

  Fields:
    hdfsMetrics: The HDFS metrics.
    yarnMetrics: The YARN metrics.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HdfsMetricsValue(_messages.Message):
    r"""The HDFS metrics.

    Messages:
      AdditionalProperty: An additional property for a HdfsMetricsValue
        object.

    Fields:
      additionalProperties: Additional properties of type HdfsMetricsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a HdfsMetricsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class YarnMetricsValue(_messages.Message):
    r"""The YARN metrics.

    Messages:
      AdditionalProperty: An additional property for a YarnMetricsValue
        object.

    Fields:
      additionalProperties: Additional properties of type YarnMetricsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a YarnMetricsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  hdfsMetrics = _messages.MessageField('HdfsMetricsValue', 1)
  yarnMetrics = _messages.MessageField('YarnMetricsValue', 2)


class ClusterOperation(_messages.Message):
  r"""The cluster operation triggered by a workflow.

  Fields:
    done: Output only. Indicates the operation is done.
    error: Output only. Error, if operation failed.
    operationId: Output only. The id of the cluster operation.
  """

  done = _messages.BooleanField(1)
  error = _messages.StringField(2)
  operationId = _messages.StringField(3)


class ClusterOperationMetadata(_messages.Message):
  r"""Metadata describing the operation.

  Messages:
    LabelsValue: Output only. Labels associated with the operation

  Fields:
    clusterName: Output only. Name of the cluster for the operation.
    clusterUuid: Output only. Cluster UUID for the operation.
    description: Output only. Short description of operation.
    labels: Output only. Labels associated with the operation
    operationType: Output only. The operation type.
    status: Output only. Current operation status.
    statusHistory: Output only. The previous operation status.
    warnings: Output only. Errors encountered during operation execution.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Output only. Labels associated with the operation

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusterName = _messages.StringField(1)
  clusterUuid = _messages.StringField(2)
  description = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  operationType = _messages.StringField(5)
  status = _messages.MessageField('ClusterOperationStatus', 6)
  statusHistory = _messages.MessageField('ClusterOperationStatus', 7, repeated=True)
  warnings = _messages.StringField(8, repeated=True)


class ClusterOperationStatus(_messages.Message):
  r"""The status of the operation.

  Enums:
    StateValueValuesEnum: Output only. A message containing the operation
      state.

  Fields:
    details: Output only. A message containing any operation metadata details.
    innerState: Output only. A message containing the detailed operation
      state.
    state: Output only. A message containing the operation state.
    stateStartTime: Output only. The time this state was entered.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. A message containing the operation state.

    Values:
      UNKNOWN: Unused.
      PENDING: The operation has been created.
      RUNNING: The operation is running.
      DONE: The operation is done; either cancelled or completed.
    """
    UNKNOWN = 0
    PENDING = 1
    RUNNING = 2
    DONE = 3

  details = _messages.StringField(1)
  innerState = _messages.StringField(2)
  state = _messages.EnumField('StateValueValuesEnum', 3)
  stateStartTime = _messages.StringField(4)


class ClusterSelector(_messages.Message):
  r"""A selector that chooses target cluster for jobs based on metadata.

  Messages:
    ClusterLabelsValue: Required. The cluster labels. Cluster must have all
      labels to match.

  Fields:
    clusterLabels: Required. The cluster labels. Cluster must have all labels
      to match.
    zone: Optional. The zone where workflow process executes. This parameter
      does not affect the selection of the cluster.If unspecified, the zone of
      the first cluster matching the selector is used.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ClusterLabelsValue(_messages.Message):
    r"""Required. The cluster labels. Cluster must have all labels to match.

    Messages:
      AdditionalProperty: An additional property for a ClusterLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type ClusterLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ClusterLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusterLabels = _messages.MessageField('ClusterLabelsValue', 1)
  zone = _messages.StringField(2)


class ClusterStatus(_messages.Message):
  r"""The status of a cluster and its instances.

  Enums:
    StateValueValuesEnum: Output only. The cluster's state.
    SubstateValueValuesEnum: Output only. Additional state information that
      includes status reported by the agent.

  Fields:
    detail: Optional. Output only. Details of cluster's state.
    state: Output only. The cluster's state.
    stateStartTime: Output only. Time when this state was entered (see JSON
      representation of Timestamp (https://developers.google.com/protocol-
      buffers/docs/proto3#json)).
    substate: Output only. Additional state information that includes status
      reported by the agent.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The cluster's state.

    Values:
      UNKNOWN: The cluster state is unknown.
      CREATING: The cluster is being created and set up. It is not ready for
        use.
      RUNNING: The cluster is currently running and healthy. It is ready for
        use.
      ERROR: The cluster encountered an error. It is not ready for use.
      DELETING: The cluster is being deleted. It cannot be used.
      UPDATING: The cluster is being updated. It continues to accept and
        process jobs.
      STOPPING: The cluster is being stopped. It cannot be used.
      STOPPED: The cluster is currently stopped. It is not ready for use.
      STARTING: The cluster is being started. It is not ready for use.
    """
    UNKNOWN = 0
    CREATING = 1
    RUNNING = 2
    ERROR = 3
    DELETING = 4
    UPDATING = 5
    STOPPING = 6
    STOPPED = 7
    STARTING = 8

  class SubstateValueValuesEnum(_messages.Enum):
    r"""Output only. Additional state information that includes status
    reported by the agent.

    Values:
      UNSPECIFIED: The cluster substate is unknown.
      UNHEALTHY: The cluster is known to be in an unhealthy state (for
        example, critical daemons are not running or HDFS capacity is
        exhausted).Applies to RUNNING state.
      STALE_STATUS: The agent-reported status is out of date (may occur if
        Dataproc loses communication with Agent).Applies to RUNNING state.
    """
    UNSPECIFIED = 0
    UNHEALTHY = 1
    STALE_STATUS = 2

  detail = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)
  stateStartTime = _messages.StringField(3)
  substate = _messages.EnumField('SubstateValueValuesEnum', 4)


class DataprocProjectsLocationsAutoscalingPoliciesCreateRequest(_messages.Message):
  r"""A DataprocProjectsLocationsAutoscalingPoliciesCreateRequest object.

  Fields:
    autoscalingPolicy: A AutoscalingPolicy resource to be passed as the
      request body.
    parent: Required. The "resource name" of the region or location, as
      described in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.autoscalingPolicies.create, the resource name  of the
      region has the following format:  projects/{project_id}/regions/{region}
      For projects.locations.autoscalingPolicies.create, the resource name  of
      the location has the following format:
      projects/{project_id}/locations/{location}
  """

  autoscalingPolicy = _messages.MessageField('AutoscalingPolicy', 1)
  parent = _messages.StringField(2, required=True)


class DataprocProjectsLocationsAutoscalingPoliciesDeleteRequest(_messages.Message):
  r"""A DataprocProjectsLocationsAutoscalingPoliciesDeleteRequest object.

  Fields:
    name: Required. The "resource name" of the autoscaling policy, as
      described in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.autoscalingPolicies.delete, the resource name  of the
      policy has the following format:
      projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}
      For projects.locations.autoscalingPolicies.delete, the resource name  of
      the policy has the following format:  projects/{project_id}/locations/{l
      ocation}/autoscalingPolicies/{policy_id}
  """

  name = _messages.StringField(1, required=True)


class DataprocProjectsLocationsAutoscalingPoliciesGetIamPolicyRequest(_messages.Message):
  r"""A DataprocProjectsLocationsAutoscalingPoliciesGetIamPolicyRequest
  object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataprocProjectsLocationsAutoscalingPoliciesGetRequest(_messages.Message):
  r"""A DataprocProjectsLocationsAutoscalingPoliciesGetRequest object.

  Fields:
    name: Required. The "resource name" of the autoscaling policy, as
      described in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.autoscalingPolicies.get, the resource name  of the
      policy has the following format:
      projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}
      For projects.locations.autoscalingPolicies.get, the resource name  of
      the policy has the following format:  projects/{project_id}/locations/{l
      ocation}/autoscalingPolicies/{policy_id}
  """

  name = _messages.StringField(1, required=True)


class DataprocProjectsLocationsAutoscalingPoliciesListRequest(_messages.Message):
  r"""A DataprocProjectsLocationsAutoscalingPoliciesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return in each
      response. Must be less than or equal to 1000. Defaults to 100.
    pageToken: Optional. The page token, returned by a previous call, to
      request the next page of results.
    parent: Required. The "resource name" of the region or location, as
      described in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.autoscalingPolicies.list, the resource name  of the
      region has the following format:  projects/{project_id}/regions/{region}
      For projects.locations.autoscalingPolicies.list, the resource name  of
      the location has the following format:
      projects/{project_id}/locations/{location}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DataprocProjectsLocationsAutoscalingPoliciesSetIamPolicyRequest(_messages.Message):
  r"""A DataprocProjectsLocationsAutoscalingPoliciesSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DataprocProjectsLocationsAutoscalingPoliciesTestIamPermissionsRequest(_messages.Message):
  r"""A DataprocProjectsLocationsAutoscalingPoliciesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DataprocProjectsLocationsWorkflowTemplatesCreateRequest(_messages.Message):
  r"""A DataprocProjectsLocationsWorkflowTemplatesCreateRequest object.

  Fields:
    parent: Required. The resource name of the region or location, as
      described in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.workflowTemplates,create, the resource name of the
      region has the following format:  projects/{project_id}/regions/{region}
      For projects.locations.workflowTemplates.create, the resource name of
      the location has the following format:
      projects/{project_id}/locations/{location}
    workflowTemplate: A WorkflowTemplate resource to be passed as the request
      body.
  """

  parent = _messages.StringField(1, required=True)
  workflowTemplate = _messages.MessageField('WorkflowTemplate', 2)


class DataprocProjectsLocationsWorkflowTemplatesDeleteRequest(_messages.Message):
  r"""A DataprocProjectsLocationsWorkflowTemplatesDeleteRequest object.

  Fields:
    name: Required. The resource name of the workflow template, as described
      in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.workflowTemplates.delete, the resource name of the
      template has the following format:
      projects/{project_id}/regions/{region}/workflowTemplates/{template_id}
      For projects.locations.workflowTemplates.instantiate, the resource name
      of the template has the following format:  projects/{project_id}/locatio
      ns/{location}/workflowTemplates/{template_id}
    version: Optional. The version of workflow template to delete. If
      specified, will only delete the template if the current server version
      matches specified version.
  """

  name = _messages.StringField(1, required=True)
  version = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class DataprocProjectsLocationsWorkflowTemplatesGetIamPolicyRequest(_messages.Message):
  r"""A DataprocProjectsLocationsWorkflowTemplatesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataprocProjectsLocationsWorkflowTemplatesGetRequest(_messages.Message):
  r"""A DataprocProjectsLocationsWorkflowTemplatesGetRequest object.

  Fields:
    name: Required. The resource name of the workflow template, as described
      in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.workflowTemplates.get, the resource name of the
      template has the following format:
      projects/{project_id}/regions/{region}/workflowTemplates/{template_id}
      For projects.locations.workflowTemplates.get, the resource name of the
      template has the following format:  projects/{project_id}/locations/{loc
      ation}/workflowTemplates/{template_id}
    version: Optional. The version of workflow template to retrieve. Only
      previously instantiated versions can be retrieved.If unspecified,
      retrieves the current version.
  """

  name = _messages.StringField(1, required=True)
  version = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class DataprocProjectsLocationsWorkflowTemplatesInstantiateInlineRequest(_messages.Message):
  r"""A DataprocProjectsLocationsWorkflowTemplatesInstantiateInlineRequest
  object.

  Fields:
    parent: Required. The resource name of the region or location, as
      described in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.workflowTemplates,instantiateinline, the resource  name
      of the region has the following format:
      projects/{project_id}/regions/{region} For
      projects.locations.workflowTemplates.instantiateinline, the  resource
      name of the location has the following format:
      projects/{project_id}/locations/{location}
    requestId: Optional. A tag that prevents multiple concurrent workflow
      instances with the same tag from running. This mitigates risk of
      concurrent instances started due to retries.It is recommended to always
      set this value to a UUID
      (https://en.wikipedia.org/wiki/Universally_unique_identifier).The tag
      must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
      and hyphens (-). The maximum length is 40 characters.
    workflowTemplate: A WorkflowTemplate resource to be passed as the request
      body.
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  workflowTemplate = _messages.MessageField('WorkflowTemplate', 3)


class DataprocProjectsLocationsWorkflowTemplatesInstantiateRequest(_messages.Message):
  r"""A DataprocProjectsLocationsWorkflowTemplatesInstantiateRequest object.

  Fields:
    instantiateWorkflowTemplateRequest: A InstantiateWorkflowTemplateRequest
      resource to be passed as the request body.
    name: Required. The resource name of the workflow template, as described
      in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.workflowTemplates.instantiate, the resource name of the
      template has the following format:
      projects/{project_id}/regions/{region}/workflowTemplates/{template_id}
      For projects.locations.workflowTemplates.instantiate, the resource name
      of the template has the following format:  projects/{project_id}/locatio
      ns/{location}/workflowTemplates/{template_id}
  """

  instantiateWorkflowTemplateRequest = _messages.MessageField('InstantiateWorkflowTemplateRequest', 1)
  name = _messages.StringField(2, required=True)


class DataprocProjectsLocationsWorkflowTemplatesListRequest(_messages.Message):
  r"""A DataprocProjectsLocationsWorkflowTemplatesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return in each
      response.
    pageToken: Optional. The page token, returned by a previous call, to
      request the next page of results.
    parent: Required. The resource name of the region or location, as
      described in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.workflowTemplates,list, the resource  name of the
      region has the following format:  projects/{project_id}/regions/{region}
      For projects.locations.workflowTemplates.list, the  resource name of the
      location has the following format:
      projects/{project_id}/locations/{location}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DataprocProjectsLocationsWorkflowTemplatesSetIamPolicyRequest(_messages.Message):
  r"""A DataprocProjectsLocationsWorkflowTemplatesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DataprocProjectsLocationsWorkflowTemplatesTestIamPermissionsRequest(_messages.Message):
  r"""A DataprocProjectsLocationsWorkflowTemplatesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DataprocProjectsRegionsAutoscalingPoliciesCreateRequest(_messages.Message):
  r"""A DataprocProjectsRegionsAutoscalingPoliciesCreateRequest object.

  Fields:
    autoscalingPolicy: A AutoscalingPolicy resource to be passed as the
      request body.
    parent: Required. The "resource name" of the region or location, as
      described in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.autoscalingPolicies.create, the resource name  of the
      region has the following format:  projects/{project_id}/regions/{region}
      For projects.locations.autoscalingPolicies.create, the resource name  of
      the location has the following format:
      projects/{project_id}/locations/{location}
  """

  autoscalingPolicy = _messages.MessageField('AutoscalingPolicy', 1)
  parent = _messages.StringField(2, required=True)


class DataprocProjectsRegionsAutoscalingPoliciesDeleteRequest(_messages.Message):
  r"""A DataprocProjectsRegionsAutoscalingPoliciesDeleteRequest object.

  Fields:
    name: Required. The "resource name" of the autoscaling policy, as
      described in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.autoscalingPolicies.delete, the resource name  of the
      policy has the following format:
      projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}
      For projects.locations.autoscalingPolicies.delete, the resource name  of
      the policy has the following format:  projects/{project_id}/locations/{l
      ocation}/autoscalingPolicies/{policy_id}
  """

  name = _messages.StringField(1, required=True)


class DataprocProjectsRegionsAutoscalingPoliciesGetIamPolicyRequest(_messages.Message):
  r"""A DataprocProjectsRegionsAutoscalingPoliciesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataprocProjectsRegionsAutoscalingPoliciesGetRequest(_messages.Message):
  r"""A DataprocProjectsRegionsAutoscalingPoliciesGetRequest object.

  Fields:
    name: Required. The "resource name" of the autoscaling policy, as
      described in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.autoscalingPolicies.get, the resource name  of the
      policy has the following format:
      projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}
      For projects.locations.autoscalingPolicies.get, the resource name  of
      the policy has the following format:  projects/{project_id}/locations/{l
      ocation}/autoscalingPolicies/{policy_id}
  """

  name = _messages.StringField(1, required=True)


class DataprocProjectsRegionsAutoscalingPoliciesListRequest(_messages.Message):
  r"""A DataprocProjectsRegionsAutoscalingPoliciesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return in each
      response. Must be less than or equal to 1000. Defaults to 100.
    pageToken: Optional. The page token, returned by a previous call, to
      request the next page of results.
    parent: Required. The "resource name" of the region or location, as
      described in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.autoscalingPolicies.list, the resource name  of the
      region has the following format:  projects/{project_id}/regions/{region}
      For projects.locations.autoscalingPolicies.list, the resource name  of
      the location has the following format:
      projects/{project_id}/locations/{location}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DataprocProjectsRegionsAutoscalingPoliciesSetIamPolicyRequest(_messages.Message):
  r"""A DataprocProjectsRegionsAutoscalingPoliciesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DataprocProjectsRegionsAutoscalingPoliciesTestIamPermissionsRequest(_messages.Message):
  r"""A DataprocProjectsRegionsAutoscalingPoliciesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DataprocProjectsRegionsClustersCreateRequest(_messages.Message):
  r"""A DataprocProjectsRegionsClustersCreateRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    projectId: Required. The ID of the Google Cloud Platform project that the
      cluster belongs to.
    region: Required. The Dataproc region in which to handle the request.
    requestId: Optional. A unique id used to identify the request. If the
      server receives two CreateClusterRequest requests with the same id, then
      the second request will be ignored and the first
      google.longrunning.Operation created and stored in the backend is
      returned.It is recommended to always set this value to a UUID
      (https://en.wikipedia.org/wiki/Universally_unique_identifier).The id
      must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
      and hyphens (-). The maximum length is 40 characters.
  """

  cluster = _messages.MessageField('Cluster', 1)
  projectId = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class DataprocProjectsRegionsClustersDeleteRequest(_messages.Message):
  r"""A DataprocProjectsRegionsClustersDeleteRequest object.

  Fields:
    clusterName: Required. The cluster name.
    clusterUuid: Optional. Specifying the cluster_uuid means the RPC should
      fail (with error NOT_FOUND) if cluster with specified UUID does not
      exist.
    projectId: Required. The ID of the Google Cloud Platform project that the
      cluster belongs to.
    region: Required. The Dataproc region in which to handle the request.
    requestId: Optional. A unique id used to identify the request. If the
      server receives two DeleteClusterRequest requests with the same id, then
      the second request will be ignored and the first
      google.longrunning.Operation created and stored in the backend is
      returned.It is recommended to always set this value to a UUID
      (https://en.wikipedia.org/wiki/Universally_unique_identifier).The id
      must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
      and hyphens (-). The maximum length is 40 characters.
  """

  clusterName = _messages.StringField(1, required=True)
  clusterUuid = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class DataprocProjectsRegionsClustersDiagnoseRequest(_messages.Message):
  r"""A DataprocProjectsRegionsClustersDiagnoseRequest object.

  Fields:
    clusterName: Required. The cluster name.
    diagnoseClusterRequest: A DiagnoseClusterRequest resource to be passed as
      the request body.
    projectId: Required. The ID of the Google Cloud Platform project that the
      cluster belongs to.
    region: Required. The Dataproc region in which to handle the request.
  """

  clusterName = _messages.StringField(1, required=True)
  diagnoseClusterRequest = _messages.MessageField('DiagnoseClusterRequest', 2)
  projectId = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)


class DataprocProjectsRegionsClustersGetIamPolicyRequest(_messages.Message):
  r"""A DataprocProjectsRegionsClustersGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataprocProjectsRegionsClustersGetRequest(_messages.Message):
  r"""A DataprocProjectsRegionsClustersGetRequest object.

  Fields:
    clusterName: Required. The cluster name.
    projectId: Required. The ID of the Google Cloud Platform project that the
      cluster belongs to.
    region: Required. The Dataproc region in which to handle the request.
  """

  clusterName = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class DataprocProjectsRegionsClustersListRequest(_messages.Message):
  r"""A DataprocProjectsRegionsClustersListRequest object.

  Fields:
    filter: Optional. A filter constraining the clusters to list. Filters are
      case-sensitive and have the following syntax:field = value AND field =
      value ...where field is one of status.state, clusterName, or
      labels.[KEY], and [KEY] is a label key. value can be * to match all
      values. status.state can be one of the following: ACTIVE, INACTIVE,
      CREATING, RUNNING, ERROR, DELETING, or UPDATING. ACTIVE contains the
      CREATING, UPDATING, and RUNNING states. INACTIVE contains the DELETING
      and ERROR states. clusterName is the name of the cluster provided at
      creation time. Only the logical AND operator is supported; space-
      separated items are treated as having an implicit AND operator.Example
      filter:status.state = ACTIVE AND clusterName = mycluster AND labels.env
      = staging AND labels.starred = *
    pageSize: Optional. The standard List page size.
    pageToken: Optional. The standard List page token.
    projectId: Required. The ID of the Google Cloud Platform project that the
      cluster belongs to.
    region: Required. The Dataproc region in which to handle the request.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  projectId = _messages.StringField(4, required=True)
  region = _messages.StringField(5, required=True)


class DataprocProjectsRegionsClustersPatchRequest(_messages.Message):
  r"""A DataprocProjectsRegionsClustersPatchRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    clusterName: Required. The cluster name.
    gracefulDecommissionTimeout: Optional. Timeout for graceful YARN
      decomissioning. Graceful decommissioning allows removing nodes from the
      cluster without interrupting jobs in progress. Timeout specifies how
      long to wait for jobs in progress to finish before forcefully removing
      nodes (and potentially interrupting jobs). Default timeout is 0 (for
      forceful decommission), and the maximum allowed timeout is 1 day. (see
      JSON representation of Duration (https://developers.google.com/protocol-
      buffers/docs/proto3#json)).Only supported on Dataproc image versions 1.2
      and higher.
    projectId: Required. The ID of the Google Cloud Platform project the
      cluster belongs to.
    region: Required. The Dataproc region in which to handle the request.
    requestId: Optional. A unique id used to identify the request. If the
      server receives two UpdateClusterRequest requests with the same id, then
      the second request will be ignored and the first
      google.longrunning.Operation created and stored in the backend is
      returned.It is recommended to always set this value to a UUID
      (https://en.wikipedia.org/wiki/Universally_unique_identifier).The id
      must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
      and hyphens (-). The maximum length is 40 characters.
    updateMask: Required. Specifies the path, relative to Cluster, of the
      field to update. For example, to change the number of workers in a
      cluster to 5, the update_mask parameter would be specified as
      config.worker_config.num_instances, and the PATCH request body would
      specify the new value, as follows: {   "config":{     "workerConfig":{
      "numInstances":"5"     }   } } Similarly, to change the number of
      preemptible workers in a cluster to 5, the update_mask parameter would
      be config.secondary_worker_config.num_instances, and the PATCH request
      body would be set as follows: {   "config":{
      "secondaryWorkerConfig":{       "numInstances":"5"     }   } }
      <strong>Note:</strong> Currently, only the following fields can be
      updated:<table>  <tbody>  <tr>  <td><strong>Mask</strong></td>
      <td><strong>Purpose</strong></td>  </tr>  <tr>
      <td><strong><em>labels</em></strong></td>  <td>Update labels</td>  </tr>
      <tr>
      <td><strong><em>config.worker_config.num_instances</em></strong></td>
      <td>Resize primary worker group</td>  </tr>  <tr>  <td><strong><em>confi
      g.secondary_worker_config.num_instances</em></strong></td>  <td>Resize
      secondary worker group</td>  </tr>  <tr>
      <td>config.autoscaling_config.policy_uri</td><td>Use, stop using, or
      change autoscaling policies</td>  </tr>  </tbody>  </table>
  """

  cluster = _messages.MessageField('Cluster', 1)
  clusterName = _messages.StringField(2, required=True)
  gracefulDecommissionTimeout = _messages.StringField(3)
  projectId = _messages.StringField(4, required=True)
  region = _messages.StringField(5, required=True)
  requestId = _messages.StringField(6)
  updateMask = _messages.StringField(7)


class DataprocProjectsRegionsClustersSetIamPolicyRequest(_messages.Message):
  r"""A DataprocProjectsRegionsClustersSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DataprocProjectsRegionsClustersTestIamPermissionsRequest(_messages.Message):
  r"""A DataprocProjectsRegionsClustersTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DataprocProjectsRegionsJobsCancelRequest(_messages.Message):
  r"""A DataprocProjectsRegionsJobsCancelRequest object.

  Fields:
    cancelJobRequest: A CancelJobRequest resource to be passed as the request
      body.
    jobId: Required. The job ID.
    projectId: Required. The ID of the Google Cloud Platform project that the
      job belongs to.
    region: Required. The Dataproc region in which to handle the request.
  """

  cancelJobRequest = _messages.MessageField('CancelJobRequest', 1)
  jobId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)


class DataprocProjectsRegionsJobsDeleteRequest(_messages.Message):
  r"""A DataprocProjectsRegionsJobsDeleteRequest object.

  Fields:
    jobId: Required. The job ID.
    projectId: Required. The ID of the Google Cloud Platform project that the
      job belongs to.
    region: Required. The Dataproc region in which to handle the request.
  """

  jobId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class DataprocProjectsRegionsJobsGetIamPolicyRequest(_messages.Message):
  r"""A DataprocProjectsRegionsJobsGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataprocProjectsRegionsJobsGetRequest(_messages.Message):
  r"""A DataprocProjectsRegionsJobsGetRequest object.

  Fields:
    jobId: Required. The job ID.
    projectId: Required. The ID of the Google Cloud Platform project that the
      job belongs to.
    region: Required. The Dataproc region in which to handle the request.
  """

  jobId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class DataprocProjectsRegionsJobsListRequest(_messages.Message):
  r"""A DataprocProjectsRegionsJobsListRequest object.

  Enums:
    JobStateMatcherValueValuesEnum: Optional. Specifies enumerated categories
      of jobs to list. (default = match ALL jobs).If filter is provided,
      jobStateMatcher will be ignored.

  Fields:
    clusterName: Optional. If set, the returned jobs list includes only jobs
      that were submitted to the named cluster.
    filter: Optional. A filter constraining the jobs to list. Filters are
      case-sensitive and have the following syntax:field = value AND field =
      value ...where field is status.state or labels.[KEY], and [KEY] is a
      label key. value can be * to match all values. status.state can be
      either ACTIVE or NON_ACTIVE. Only the logical AND operator is supported;
      space-separated items are treated as having an implicit AND
      operator.Example filter:status.state = ACTIVE AND labels.env = staging
      AND labels.starred = *
    jobStateMatcher: Optional. Specifies enumerated categories of jobs to
      list. (default = match ALL jobs).If filter is provided, jobStateMatcher
      will be ignored.
    pageSize: Optional. The number of results to return in each response.
    pageToken: Optional. The page token, returned by a previous call, to
      request the next page of results.
    projectId: Required. The ID of the Google Cloud Platform project that the
      job belongs to.
    region: Required. The Dataproc region in which to handle the request.
  """

  class JobStateMatcherValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies enumerated categories of jobs to list. (default =
    match ALL jobs).If filter is provided, jobStateMatcher will be ignored.

    Values:
      ALL: <no description>
      ACTIVE: <no description>
      NON_ACTIVE: <no description>
    """
    ALL = 0
    ACTIVE = 1
    NON_ACTIVE = 2

  clusterName = _messages.StringField(1)
  filter = _messages.StringField(2)
  jobStateMatcher = _messages.EnumField('JobStateMatcherValueValuesEnum', 3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  projectId = _messages.StringField(6, required=True)
  region = _messages.StringField(7, required=True)


class DataprocProjectsRegionsJobsPatchRequest(_messages.Message):
  r"""A DataprocProjectsRegionsJobsPatchRequest object.

  Fields:
    job: A Job resource to be passed as the request body.
    jobId: Required. The job ID.
    projectId: Required. The ID of the Google Cloud Platform project that the
      job belongs to.
    region: Required. The Dataproc region in which to handle the request.
    updateMask: Required. Specifies the path, relative to <code>Job</code>, of
      the field to update. For example, to update the labels of a Job the
      <code>update_mask</code> parameter would be specified as
      <code>labels</code>, and the PATCH request body would specify the new
      value. <strong>Note:</strong> Currently, <code>labels</code> is the only
      field that can be updated.
  """

  job = _messages.MessageField('Job', 1)
  jobId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  updateMask = _messages.StringField(5)


class DataprocProjectsRegionsJobsSetIamPolicyRequest(_messages.Message):
  r"""A DataprocProjectsRegionsJobsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DataprocProjectsRegionsJobsSubmitAsOperationRequest(_messages.Message):
  r"""A DataprocProjectsRegionsJobsSubmitAsOperationRequest object.

  Fields:
    projectId: Required. The ID of the Google Cloud Platform project that the
      job belongs to.
    region: Required. The Dataproc region in which to handle the request.
    submitJobRequest: A SubmitJobRequest resource to be passed as the request
      body.
  """

  projectId = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  submitJobRequest = _messages.MessageField('SubmitJobRequest', 3)


class DataprocProjectsRegionsJobsSubmitRequest(_messages.Message):
  r"""A DataprocProjectsRegionsJobsSubmitRequest object.

  Fields:
    projectId: Required. The ID of the Google Cloud Platform project that the
      job belongs to.
    region: Required. The Dataproc region in which to handle the request.
    submitJobRequest: A SubmitJobRequest resource to be passed as the request
      body.
  """

  projectId = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  submitJobRequest = _messages.MessageField('SubmitJobRequest', 3)


class DataprocProjectsRegionsJobsTestIamPermissionsRequest(_messages.Message):
  r"""A DataprocProjectsRegionsJobsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DataprocProjectsRegionsOperationsCancelRequest(_messages.Message):
  r"""A DataprocProjectsRegionsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class DataprocProjectsRegionsOperationsDeleteRequest(_messages.Message):
  r"""A DataprocProjectsRegionsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class DataprocProjectsRegionsOperationsGetIamPolicyRequest(_messages.Message):
  r"""A DataprocProjectsRegionsOperationsGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataprocProjectsRegionsOperationsGetRequest(_messages.Message):
  r"""A DataprocProjectsRegionsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class DataprocProjectsRegionsOperationsListRequest(_messages.Message):
  r"""A DataprocProjectsRegionsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class DataprocProjectsRegionsOperationsSetIamPolicyRequest(_messages.Message):
  r"""A DataprocProjectsRegionsOperationsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DataprocProjectsRegionsOperationsTestIamPermissionsRequest(_messages.Message):
  r"""A DataprocProjectsRegionsOperationsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DataprocProjectsRegionsWorkflowTemplatesCreateRequest(_messages.Message):
  r"""A DataprocProjectsRegionsWorkflowTemplatesCreateRequest object.

  Fields:
    parent: Required. The resource name of the region or location, as
      described in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.workflowTemplates,create, the resource name of the
      region has the following format:  projects/{project_id}/regions/{region}
      For projects.locations.workflowTemplates.create, the resource name of
      the location has the following format:
      projects/{project_id}/locations/{location}
    workflowTemplate: A WorkflowTemplate resource to be passed as the request
      body.
  """

  parent = _messages.StringField(1, required=True)
  workflowTemplate = _messages.MessageField('WorkflowTemplate', 2)


class DataprocProjectsRegionsWorkflowTemplatesDeleteRequest(_messages.Message):
  r"""A DataprocProjectsRegionsWorkflowTemplatesDeleteRequest object.

  Fields:
    name: Required. The resource name of the workflow template, as described
      in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.workflowTemplates.delete, the resource name of the
      template has the following format:
      projects/{project_id}/regions/{region}/workflowTemplates/{template_id}
      For projects.locations.workflowTemplates.instantiate, the resource name
      of the template has the following format:  projects/{project_id}/locatio
      ns/{location}/workflowTemplates/{template_id}
    version: Optional. The version of workflow template to delete. If
      specified, will only delete the template if the current server version
      matches specified version.
  """

  name = _messages.StringField(1, required=True)
  version = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class DataprocProjectsRegionsWorkflowTemplatesGetIamPolicyRequest(_messages.Message):
  r"""A DataprocProjectsRegionsWorkflowTemplatesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class DataprocProjectsRegionsWorkflowTemplatesGetRequest(_messages.Message):
  r"""A DataprocProjectsRegionsWorkflowTemplatesGetRequest object.

  Fields:
    name: Required. The resource name of the workflow template, as described
      in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.workflowTemplates.get, the resource name of the
      template has the following format:
      projects/{project_id}/regions/{region}/workflowTemplates/{template_id}
      For projects.locations.workflowTemplates.get, the resource name of the
      template has the following format:  projects/{project_id}/locations/{loc
      ation}/workflowTemplates/{template_id}
    version: Optional. The version of workflow template to retrieve. Only
      previously instantiated versions can be retrieved.If unspecified,
      retrieves the current version.
  """

  name = _messages.StringField(1, required=True)
  version = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class DataprocProjectsRegionsWorkflowTemplatesInstantiateInlineRequest(_messages.Message):
  r"""A DataprocProjectsRegionsWorkflowTemplatesInstantiateInlineRequest
  object.

  Fields:
    parent: Required. The resource name of the region or location, as
      described in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.workflowTemplates,instantiateinline, the resource  name
      of the region has the following format:
      projects/{project_id}/regions/{region} For
      projects.locations.workflowTemplates.instantiateinline, the  resource
      name of the location has the following format:
      projects/{project_id}/locations/{location}
    requestId: Optional. A tag that prevents multiple concurrent workflow
      instances with the same tag from running. This mitigates risk of
      concurrent instances started due to retries.It is recommended to always
      set this value to a UUID
      (https://en.wikipedia.org/wiki/Universally_unique_identifier).The tag
      must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
      and hyphens (-). The maximum length is 40 characters.
    workflowTemplate: A WorkflowTemplate resource to be passed as the request
      body.
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  workflowTemplate = _messages.MessageField('WorkflowTemplate', 3)


class DataprocProjectsRegionsWorkflowTemplatesInstantiateRequest(_messages.Message):
  r"""A DataprocProjectsRegionsWorkflowTemplatesInstantiateRequest object.

  Fields:
    instantiateWorkflowTemplateRequest: A InstantiateWorkflowTemplateRequest
      resource to be passed as the request body.
    name: Required. The resource name of the workflow template, as described
      in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.workflowTemplates.instantiate, the resource name of the
      template has the following format:
      projects/{project_id}/regions/{region}/workflowTemplates/{template_id}
      For projects.locations.workflowTemplates.instantiate, the resource name
      of the template has the following format:  projects/{project_id}/locatio
      ns/{location}/workflowTemplates/{template_id}
  """

  instantiateWorkflowTemplateRequest = _messages.MessageField('InstantiateWorkflowTemplateRequest', 1)
  name = _messages.StringField(2, required=True)


class DataprocProjectsRegionsWorkflowTemplatesListRequest(_messages.Message):
  r"""A DataprocProjectsRegionsWorkflowTemplatesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return in each
      response.
    pageToken: Optional. The page token, returned by a previous call, to
      request the next page of results.
    parent: Required. The resource name of the region or location, as
      described in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.workflowTemplates,list, the resource  name of the
      region has the following format:  projects/{project_id}/regions/{region}
      For projects.locations.workflowTemplates.list, the  resource name of the
      location has the following format:
      projects/{project_id}/locations/{location}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class DataprocProjectsRegionsWorkflowTemplatesSetIamPolicyRequest(_messages.Message):
  r"""A DataprocProjectsRegionsWorkflowTemplatesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class DataprocProjectsRegionsWorkflowTemplatesTestIamPermissionsRequest(_messages.Message):
  r"""A DataprocProjectsRegionsWorkflowTemplatesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DiagnoseClusterRequest(_messages.Message):
  r"""A request to collect cluster diagnostic information."""


class DiagnoseClusterResults(_messages.Message):
  r"""The location of diagnostic output.

  Fields:
    outputUri: Output only. The Cloud Storage URI of the diagnostic output.
      The output report is a plain text file with a summary of collected
      diagnostics.
  """

  outputUri = _messages.StringField(1)


class DiskConfig(_messages.Message):
  r"""Specifies the config of disk options for a group of VM instances.

  Fields:
    bootDiskSizeGb: Optional. Size in GB of the boot disk (default is 500GB).
    bootDiskType: Optional. Type of the boot disk (default is "pd-standard").
      Valid values: "pd-ssd" (Persistent Disk Solid State Drive) or "pd-
      standard" (Persistent Disk Hard Disk Drive).
    numLocalSsds: Optional. Number of attached SSDs, from 0 to 4 (default is
      0). If SSDs are not attached, the boot disk is used to store runtime
      logs and HDFS
      (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If
      one or more SSDs are attached, this runtime bulk data is spread across
      them, and the boot disk contains only basic config and installed
      binaries.
  """

  bootDiskSizeGb = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  bootDiskType = _messages.StringField(2)
  numLocalSsds = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo {   rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for Empty is empty JSON object {}.
  """



class EncryptionConfig(_messages.Message):
  r"""Encryption settings for the cluster.

  Fields:
    gcePdKmsKeyName: Optional. The Cloud KMS key name to use for PD disk
      encryption for all instances in the cluster.
  """

  gcePdKmsKeyName = _messages.StringField(1)


class EndpointConfig(_messages.Message):
  r"""Endpoint config for this cluster

  Messages:
    HttpPortsValue: Output only. The map of port descriptions to URLs. Will
      only be populated if enable_http_port_access is true.

  Fields:
    enableHttpPortAccess: Optional. If true, enable http access to specific
      ports on the cluster from external sources. Defaults to false.
    httpPorts: Output only. The map of port descriptions to URLs. Will only be
      populated if enable_http_port_access is true.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HttpPortsValue(_messages.Message):
    r"""Output only. The map of port descriptions to URLs. Will only be
    populated if enable_http_port_access is true.

    Messages:
      AdditionalProperty: An additional property for a HttpPortsValue object.

    Fields:
      additionalProperties: Additional properties of type HttpPortsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a HttpPortsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  enableHttpPortAccess = _messages.BooleanField(1)
  httpPorts = _messages.MessageField('HttpPortsValue', 2)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec.Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GceClusterConfig(_messages.Message):
  r"""Common config settings for resources of Compute Engine cluster
  instances, applicable to all instances in the cluster.

  Messages:
    MetadataValue: The Compute Engine metadata entries to add to all instances
      (see Project and instance metadata
      (https://cloud.google.com/compute/docs/storing-retrieving-
      metadata#project_and_instance_metadata)).

  Fields:
    internalIpOnly: Optional. If true, all instances in the cluster will only
      have internal IP addresses. By default, clusters are not restricted to
      internal IP addresses, and will have ephemeral external IP addresses
      assigned to each instance. This internal_ip_only restriction can only be
      enabled for subnetwork enabled networks, and all off-cluster
      dependencies must be configured to be accessible without external IP
      addresses.
    metadata: The Compute Engine metadata entries to add to all instances (see
      Project and instance metadata
      (https://cloud.google.com/compute/docs/storing-retrieving-
      metadata#project_and_instance_metadata)).
    networkUri: Optional. The Compute Engine network to be used for machine
      communications. Cannot be specified with subnetwork_uri. If neither
      network_uri nor subnetwork_uri is specified, the "default" network of
      the project is used, if it exists. Cannot be a "Custom Subnet Network"
      (see Using Subnetworks
      (https://cloud.google.com/compute/docs/subnetworks) for more
      information).A full URL, partial URI, or short name are valid. Examples:
      https://www.googleapis.com/compute/v1/projects/[project_id]/regions/glob
      al/default projects/[project_id]/regions/global/default default
    reservationAffinity: Optional. Reservation Affinity for consuming Zonal
      reservation.
    serviceAccount: Optional. The Dataproc service account
      (https://cloud.google.com/dataproc/docs/concepts/configuring-
      clusters/service-accounts#service_accounts_in_cloud_dataproc) (also see
      VM Data Plane identity
      (https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-
      principals#vm_service_account_data_plane_identity)) used by Dataproc
      cluster VM instances to access Google Cloud Platform services.If not
      specified, the Compute Engine default service account
      (https://cloud.google.com/compute/docs/access/service-
      accounts#default_service_account) is used.
    serviceAccountScopes: Optional. The URIs of service account scopes to be
      included in Compute Engine instances. The following base set of scopes
      is always included:
      https://www.googleapis.com/auth/cloud.useraccounts.readonly
      https://www.googleapis.com/auth/devstorage.read_write
      https://www.googleapis.com/auth/logging.writeIf no scopes are specified,
      the following defaults are also provided:
      https://www.googleapis.com/auth/bigquery
      https://www.googleapis.com/auth/bigtable.admin.table
      https://www.googleapis.com/auth/bigtable.data
      https://www.googleapis.com/auth/devstorage.full_control
    subnetworkUri: Optional. The Compute Engine subnetwork to be used for
      machine communications. Cannot be specified with network_uri.A full URL,
      partial URI, or short name are valid. Examples:
      https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-
      east1/subnetworks/sub0 projects/[project_id]/regions/us-
      east1/subnetworks/sub0 sub0
    tags: The Compute Engine tags to add to all instances (see Tagging
      instances (https://cloud.google.com/compute/docs/label-or-tag-
      resources#tags)).
    zoneUri: Optional. The zone where the Compute Engine cluster will be
      located. On a create request, it is required in the "global" region. If
      omitted in a non-global Dataproc region, the service will pick a zone in
      the corresponding Compute Engine region. On a get request, zone will
      always be present.A full URL, partial URI, or short name are valid.
      Examples:
      https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]
      projects/[project_id]/zones/[zone] us-central1-f
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""The Compute Engine metadata entries to add to all instances (see
    Project and instance metadata
    (https://cloud.google.com/compute/docs/storing-retrieving-
    metadata#project_and_instance_metadata)).

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Additional properties of type MetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  internalIpOnly = _messages.BooleanField(1)
  metadata = _messages.MessageField('MetadataValue', 2)
  networkUri = _messages.StringField(3)
  reservationAffinity = _messages.MessageField('ReservationAffinity', 4)
  serviceAccount = _messages.StringField(5)
  serviceAccountScopes = _messages.StringField(6, repeated=True)
  subnetworkUri = _messages.StringField(7)
  tags = _messages.StringField(8, repeated=True)
  zoneUri = _messages.StringField(9)


class GetIamPolicyRequest(_messages.Message):
  r"""Request message for GetIamPolicy method.

  Fields:
    options: OPTIONAL: A GetPolicyOptions object for specifying options to
      GetIamPolicy.
  """

  options = _messages.MessageField('GetPolicyOptions', 1)


class GetPolicyOptions(_messages.Message):
  r"""Encapsulates settings provided to GetIamPolicy.

  Fields:
    requestedPolicyVersion: Optional. The policy format version to be
      returned.Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.To learn
      which resources support conditions in their IAM policies, see the IAM
      documentation (https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class HadoopJob(_messages.Message):
  r"""A Dataproc job for running Apache Hadoop MapReduce
  (https://hadoop.apache.org/docs/current/hadoop-mapreduce-client/hadoop-
  mapreduce-client-core/MapReduceTutorial.html) jobs on Apache Hadoop YARN
  (https://hadoop.apache.org/docs/r2.7.1/hadoop-yarn/hadoop-yarn-
  site/YARN.html).

  Messages:
    PropertiesValue: Optional. A mapping of property names to values, used to
      configure Hadoop. Properties that conflict with values set by the
      Dataproc API may be overwritten. Can include properties set in
      /etc/hadoop/conf/*-site and classes in user code.

  Fields:
    archiveUris: Optional. HCFS URIs of archives to be extracted in the
      working directory of Hadoop drivers and tasks. Supported file types:
      .jar, .tar, .tar.gz, .tgz, or .zip.
    args: Optional. The arguments to pass to the driver. Do not include
      arguments, such as -libjars or -Dfoo=bar, that can be set as job
      properties, since a collision may occur that causes an incorrect job
      submission.
    fileUris: Optional. HCFS (Hadoop Compatible Filesystem) URIs of files to
      be copied to the working directory of Hadoop drivers and distributed
      tasks. Useful for naively parallel tasks.
    jarFileUris: Optional. Jar file URIs to add to the CLASSPATHs of the
      Hadoop driver and tasks.
    loggingConfig: Optional. The runtime log config for job execution.
    mainClass: The name of the driver's main class. The jar file containing
      the class must be in the default CLASSPATH or specified in
      jar_file_uris.
    mainJarFileUri: The HCFS URI of the jar file containing the main class.
      Examples:  'gs://foo-bucket/analytics-binaries/extract-useful-metrics-
      mr.jar'  'hdfs:/tmp/test-samples/custom-wordcount.jar'
      'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'
    properties: Optional. A mapping of property names to values, used to
      configure Hadoop. Properties that conflict with values set by the
      Dataproc API may be overwritten. Can include properties set in
      /etc/hadoop/conf/*-site and classes in user code.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Optional. A mapping of property names to values, used to configure
    Hadoop. Properties that conflict with values set by the Dataproc API may
    be overwritten. Can include properties set in /etc/hadoop/conf/*-site and
    classes in user code.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  archiveUris = _messages.StringField(1, repeated=True)
  args = _messages.StringField(2, repeated=True)
  fileUris = _messages.StringField(3, repeated=True)
  jarFileUris = _messages.StringField(4, repeated=True)
  loggingConfig = _messages.MessageField('LoggingConfig', 5)
  mainClass = _messages.StringField(6)
  mainJarFileUri = _messages.StringField(7)
  properties = _messages.MessageField('PropertiesValue', 8)


class HiveJob(_messages.Message):
  r"""A Dataproc job for running Apache Hive (https://hive.apache.org/)
  queries on YARN.

  Messages:
    PropertiesValue: Optional. A mapping of property names and values, used to
      configure Hive. Properties that conflict with values set by the Dataproc
      API may be overwritten. Can include properties set in
      /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes
      in user code.
    ScriptVariablesValue: Optional. Mapping of query variable names to values
      (equivalent to the Hive command: SET name="value";).

  Fields:
    continueOnFailure: Optional. Whether to continue executing queries if a
      query fails. The default value is false. Setting to true can be useful
      when executing independent parallel queries.
    jarFileUris: Optional. HCFS URIs of jar files to add to the CLASSPATH of
      the Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes
      and UDFs.
    properties: Optional. A mapping of property names and values, used to
      configure Hive. Properties that conflict with values set by the Dataproc
      API may be overwritten. Can include properties set in
      /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes
      in user code.
    queryFileUri: The HCFS URI of the script that contains Hive queries.
    queryList: A list of queries.
    scriptVariables: Optional. Mapping of query variable names to values
      (equivalent to the Hive command: SET name="value";).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Optional. A mapping of property names and values, used to configure
    Hive. Properties that conflict with values set by the Dataproc API may be
    overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml,
    /etc/hive/conf/hive-site.xml, and classes in user code.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ScriptVariablesValue(_messages.Message):
    r"""Optional. Mapping of query variable names to values (equivalent to the
    Hive command: SET name="value";).

    Messages:
      AdditionalProperty: An additional property for a ScriptVariablesValue
        object.

    Fields:
      additionalProperties: Additional properties of type ScriptVariablesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ScriptVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  continueOnFailure = _messages.BooleanField(1)
  jarFileUris = _messages.StringField(2, repeated=True)
  properties = _messages.MessageField('PropertiesValue', 3)
  queryFileUri = _messages.StringField(4)
  queryList = _messages.MessageField('QueryList', 5)
  scriptVariables = _messages.MessageField('ScriptVariablesValue', 6)


class InstanceGroupAutoscalingPolicyConfig(_messages.Message):
  r"""Configuration for the size bounds of an instance group, including its
  proportional size to other groups.

  Fields:
    maxInstances: Required. Maximum number of instances for this group.
      Required for primary workers. Note that by default, clusters will not
      use secondary workers. Required for secondary workers if the minimum
      secondary instances is set.Primary workers - Bounds: [min_instances, ).
      Secondary workers - Bounds: [min_instances, ). Default: 0.
    minInstances: Optional. Minimum number of instances for this group.Primary
      workers - Bounds: 2, max_instances. Default: 2. Secondary workers -
      Bounds: 0, max_instances. Default: 0.
    weight: Optional. Weight for the instance group, which is used to
      determine the fraction of total workers in the cluster from this
      instance group. For example, if primary workers have weight 2, and
      secondary workers have weight 1, the cluster will have approximately 2
      primary workers for each secondary worker.The cluster may not reach the
      specified balance if constrained by min/max bounds or other autoscaling
      settings. For example, if max_instances for secondary workers is 0, then
      only primary workers will be added. The cluster can also be out of
      balance when created.If weight is not set on any instance group, the
      cluster will default to equal weight for all groups: the cluster will
      attempt to maintain an equal number of workers in each group within the
      configured size bounds for each group. If weight is set for one group
      only, the cluster will default to zero weight on the unset group. For
      example if weight is set only on primary workers, the cluster will use
      primary workers only and no secondary workers.
  """

  maxInstances = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minInstances = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  weight = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class InstanceGroupConfig(_messages.Message):
  r"""The config settings for Compute Engine resources in an instance group,
  such as a master or worker group.

  Enums:
    PreemptibilityValueValuesEnum: Optional. Specifies the preemptibility of
      the instance group.The default value for master and worker groups is
      NON_PREEMPTIBLE. This default cannot be changed.The default value for
      secondary instances is PREEMPTIBLE.

  Fields:
    accelerators: Optional. The Compute Engine accelerator configuration for
      these instances.
    diskConfig: Optional. Disk option config settings.
    imageUri: Optional. The Compute Engine image resource used for cluster
      instances.The URI can represent an image or image family.Image examples:
      https://www.googleapis.com/compute/beta/projects/[project_id]/global/ima
      ges/[image-id] projects/[project_id]/global/images/[image-id] image-
      idImage family examples. Dataproc will use the most recent image from
      the family: https://www.googleapis.com/compute/beta/projects/[project_id
      ]/global/images/family/[custom-image-family-name]
      projects/[project_id]/global/images/family/[custom-image-family-name]If
      the URI is unspecified, it will be inferred from
      SoftwareConfig.image_version or the system default.
    instanceNames: Output only. The list of instance names. Dataproc derives
      the names from cluster_name, num_instances, and the instance group.
    isPreemptible: Output only. Specifies that this instance group contains
      preemptible instances.
    machineTypeUri: Optional. The Compute Engine machine type used for cluster
      instances.A full URL, partial URI, or short name are valid. Examples:
      https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-
      east1-a/machineTypes/n1-standard-2 projects/[project_id]/zones/us-
      east1-a/machineTypes/n1-standard-2 n1-standard-2Auto Zone Exception: If
      you are using the Dataproc Auto Zone Placement
      (https://cloud.google.com/dataproc/docs/concepts/configuring-
      clusters/auto-zone#using_auto_zone_placement) feature, you must use the
      short name of the machine type resource, for example, n1-standard-2.
    managedGroupConfig: Output only. The config for Compute Engine Instance
      Group Manager that manages this group. This is only used for preemptible
      instance groups.
    minCpuPlatform: Optional. Specifies the minimum cpu platform for the
      Instance Group. See Dataproc -&gt; Minimum CPU Platform
      (https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-
      cpu).
    numInstances: Optional. The number of VM instances in the instance group.
      For master instance groups, must be set to 1.
    preemptibility: Optional. Specifies the preemptibility of the instance
      group.The default value for master and worker groups is NON_PREEMPTIBLE.
      This default cannot be changed.The default value for secondary instances
      is PREEMPTIBLE.
  """

  class PreemptibilityValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the preemptibility of the instance group.The
    default value for master and worker groups is NON_PREEMPTIBLE. This
    default cannot be changed.The default value for secondary instances is
    PREEMPTIBLE.

    Values:
      PREEMPTIBILITY_UNSPECIFIED: Preemptibility is unspecified, the system
        will choose the appropriate setting for each instance group.
      NON_PREEMPTIBLE: Instances are non-preemptible.This option is allowed
        for all instance groups and is the only valid value for Master and
        Worker instance groups.
      PREEMPTIBLE: Instances are preemptible.This option is allowed only for
        secondary worker groups.
    """
    PREEMPTIBILITY_UNSPECIFIED = 0
    NON_PREEMPTIBLE = 1
    PREEMPTIBLE = 2

  accelerators = _messages.MessageField('AcceleratorConfig', 1, repeated=True)
  diskConfig = _messages.MessageField('DiskConfig', 2)
  imageUri = _messages.StringField(3)
  instanceNames = _messages.StringField(4, repeated=True)
  isPreemptible = _messages.BooleanField(5)
  machineTypeUri = _messages.StringField(6)
  managedGroupConfig = _messages.MessageField('ManagedGroupConfig', 7)
  minCpuPlatform = _messages.StringField(8)
  numInstances = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  preemptibility = _messages.EnumField('PreemptibilityValueValuesEnum', 10)


class InstantiateWorkflowTemplateRequest(_messages.Message):
  r"""A request to instantiate a workflow template.

  Messages:
    ParametersValue: Optional. Map from parameter names to values that should
      be used for those parameters. Values may not exceed 100 characters.

  Fields:
    parameters: Optional. Map from parameter names to values that should be
      used for those parameters. Values may not exceed 100 characters.
    requestId: Optional. A tag that prevents multiple concurrent workflow
      instances with the same tag from running. This mitigates risk of
      concurrent instances started due to retries.It is recommended to always
      set this value to a UUID
      (https://en.wikipedia.org/wiki/Universally_unique_identifier).The tag
      must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
      and hyphens (-). The maximum length is 40 characters.
    version: Optional. The version of workflow template to instantiate. If
      specified, the workflow will be instantiated only if the current version
      of the workflow template has the supplied version.This option cannot be
      used to instantiate a previous version of workflow template.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Optional. Map from parameter names to values that should be used for
    those parameters. Values may not exceed 100 characters.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  parameters = _messages.MessageField('ParametersValue', 1)
  requestId = _messages.StringField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class Job(_messages.Message):
  r"""A Dataproc job resource.

  Messages:
    LabelsValue: Optional. The labels to associate with this job. Label keys
      must contain 1 to 63 characters, and must conform to RFC 1035
      (https://www.ietf.org/rfc/rfc1035.txt). Label values may be empty, but,
      if present, must contain 1 to 63 characters, and must conform to RFC
      1035 (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can
      be associated with a job.

  Fields:
    done: Output only. Indicates whether the job is completed. If the value is
      false, the job is still in progress. If true, the job is completed, and
      status.state field will indicate if it was successful, failed, or
      cancelled.
    driverControlFilesUri: Output only. If present, the location of
      miscellaneous control files which may be used as part of job setup and
      handling. If not present, control files may be placed in the same
      location as driver_output_uri.
    driverOutputResourceUri: Output only. A URI pointing to the location of
      the stdout of the job's driver program.
    hadoopJob: Optional. Job is a Hadoop job.
    hiveJob: Optional. Job is a Hive job.
    jobUuid: Output only. A UUID that uniquely identifies a job within the
      project over time. This is in contrast to a user-settable
      reference.job_id that may be reused over time.
    labels: Optional. The labels to associate with this job. Label keys must
      contain 1 to 63 characters, and must conform to RFC 1035
      (https://www.ietf.org/rfc/rfc1035.txt). Label values may be empty, but,
      if present, must contain 1 to 63 characters, and must conform to RFC
      1035 (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can
      be associated with a job.
    pigJob: Optional. Job is a Pig job.
    placement: Required. Job information, including how, when, and where to
      run the job.
    prestoJob: Optional. Job is a Presto job.
    pysparkJob: Optional. Job is a PySpark job.
    reference: Optional. The fully qualified reference to the job, which can
      be used to obtain the equivalent REST path of the job resource. If this
      property is not specified when a job is created, the server generates a
      <code>job_id</code>.
    scheduling: Optional. Job scheduling configuration.
    sparkJob: Optional. Job is a Spark job.
    sparkRJob: Optional. Job is a SparkR job.
    sparkSqlJob: Optional. Job is a SparkSql job.
    status: Output only. The job status. Additional application-specific
      status information may be contained in the <code>type_job</code> and
      <code>yarn_applications</code> fields.
    statusHistory: Output only. The previous job status.
    yarnApplications: Output only. The collection of YARN applications spun up
      by this job.Beta Feature: This report is available for testing purposes
      only. It may be changed before final release.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels to associate with this job. Label keys must
    contain 1 to 63 characters, and must conform to RFC 1035
    (https://www.ietf.org/rfc/rfc1035.txt). Label values may be empty, but, if
    present, must contain 1 to 63 characters, and must conform to RFC 1035
    (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
    associated with a job.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  driverControlFilesUri = _messages.StringField(2)
  driverOutputResourceUri = _messages.StringField(3)
  hadoopJob = _messages.MessageField('HadoopJob', 4)
  hiveJob = _messages.MessageField('HiveJob', 5)
  jobUuid = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  pigJob = _messages.MessageField('PigJob', 8)
  placement = _messages.MessageField('JobPlacement', 9)
  prestoJob = _messages.MessageField('PrestoJob', 10)
  pysparkJob = _messages.MessageField('PySparkJob', 11)
  reference = _messages.MessageField('JobReference', 12)
  scheduling = _messages.MessageField('JobScheduling', 13)
  sparkJob = _messages.MessageField('SparkJob', 14)
  sparkRJob = _messages.MessageField('SparkRJob', 15)
  sparkSqlJob = _messages.MessageField('SparkSqlJob', 16)
  status = _messages.MessageField('JobStatus', 17)
  statusHistory = _messages.MessageField('JobStatus', 18, repeated=True)
  yarnApplications = _messages.MessageField('YarnApplication', 19, repeated=True)


class JobMetadata(_messages.Message):
  r"""Job Operation metadata.

  Fields:
    jobId: Output only. The job id.
    operationType: Output only. Operation type.
    startTime: Output only. Job submission time.
    status: Output only. Most recent job status.
  """

  jobId = _messages.StringField(1)
  operationType = _messages.StringField(2)
  startTime = _messages.StringField(3)
  status = _messages.MessageField('JobStatus', 4)


class JobPlacement(_messages.Message):
  r"""Dataproc job config.

  Fields:
    clusterName: Required. The name of the cluster where the job will be
      submitted.
    clusterUuid: Output only. A cluster UUID generated by the Dataproc service
      when the job is submitted.
  """

  clusterName = _messages.StringField(1)
  clusterUuid = _messages.StringField(2)


class JobReference(_messages.Message):
  r"""Encapsulates the full scoping used to reference a job.

  Fields:
    jobId: Optional. The job ID, which must be unique within the project.The
      ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
      or hyphens (-). The maximum length is 100 characters.If not specified by
      the caller, the job ID will be provided by the server.
    projectId: Required. The ID of the Google Cloud Platform project that the
      job belongs to.
  """

  jobId = _messages.StringField(1)
  projectId = _messages.StringField(2)


class JobScheduling(_messages.Message):
  r"""Job scheduling options.

  Fields:
    maxFailuresPerHour: Optional. Maximum number of times per hour a driver
      may be restarted as a result of driver terminating with non-zero code
      before job is reported failed.A job may be reported as thrashing if
      driver exits with non-zero code 4 times within 10 minute window.Maximum
      value is 10.
  """

  maxFailuresPerHour = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class JobStatus(_messages.Message):
  r"""Dataproc job status.

  Enums:
    StateValueValuesEnum: Output only. A state message specifying the overall
      job state.
    SubstateValueValuesEnum: Output only. Additional state information, which
      includes status reported by the agent.

  Fields:
    details: Optional. Output only. Job state details, such as an error
      description if the state is <code>ERROR</code>.
    state: Output only. A state message specifying the overall job state.
    stateStartTime: Output only. The time when this state was entered.
    substate: Output only. Additional state information, which includes status
      reported by the agent.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. A state message specifying the overall job state.

    Values:
      STATE_UNSPECIFIED: The job state is unknown.
      PENDING: The job is pending; it has been submitted, but is not yet
        running.
      SETUP_DONE: Job has been received by the service and completed initial
        setup; it will soon be submitted to the cluster.
      RUNNING: The job is running on the cluster.
      CANCEL_PENDING: A CancelJob request has been received, but is pending.
      CANCEL_STARTED: Transient in-flight resources have been canceled, and
        the request to cancel the running job has been issued to the cluster.
      CANCELLED: The job cancellation was successful.
      DONE: The job has completed successfully.
      ERROR: The job has completed, but encountered an error.
      ATTEMPT_FAILURE: Job attempt has failed. The detail field contains
        failure details for this attempt.Applies to restartable jobs only.
    """
    STATE_UNSPECIFIED = 0
    PENDING = 1
    SETUP_DONE = 2
    RUNNING = 3
    CANCEL_PENDING = 4
    CANCEL_STARTED = 5
    CANCELLED = 6
    DONE = 7
    ERROR = 8
    ATTEMPT_FAILURE = 9

  class SubstateValueValuesEnum(_messages.Enum):
    r"""Output only. Additional state information, which includes status
    reported by the agent.

    Values:
      UNSPECIFIED: The job substate is unknown.
      SUBMITTED: The Job is submitted to the agent.Applies to RUNNING state.
      QUEUED: The Job has been received and is awaiting execution (it may be
        waiting for a condition to be met). See the "details" field for the
        reason for the delay.Applies to RUNNING state.
      STALE_STATUS: The agent-reported status is out of date, which may be
        caused by a loss of communication between the agent and Dataproc. If
        the agent does not send a timely update, the job will fail.Applies to
        RUNNING state.
    """
    UNSPECIFIED = 0
    SUBMITTED = 1
    QUEUED = 2
    STALE_STATUS = 3

  details = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)
  stateStartTime = _messages.StringField(3)
  substate = _messages.EnumField('SubstateValueValuesEnum', 4)


class KerberosConfig(_messages.Message):
  r"""Specifies Kerberos related configuration.

  Fields:
    crossRealmTrustAdminServer: Optional. The admin server (IP or hostname)
      for the remote trusted realm in a cross realm trust relationship.
    crossRealmTrustKdc: Optional. The KDC (IP or hostname) for the remote
      trusted realm in a cross realm trust relationship.
    crossRealmTrustRealm: Optional. The remote realm the Dataproc on-cluster
      KDC will trust, should the user enable cross realm trust.
    crossRealmTrustSharedPasswordUri: Optional. The Cloud Storage URI of a KMS
      encrypted file containing the shared password between the on-cluster
      Kerberos realm and the remote trusted realm, in a cross realm trust
      relationship.
    enableKerberos: Optional. Flag to indicate whether to Kerberize the
      cluster (default: false). Set this field to true to enable Kerberos on a
      cluster.
    kdcDbKeyUri: Optional. The Cloud Storage URI of a KMS encrypted file
      containing the master key of the KDC database.
    keyPasswordUri: Optional. The Cloud Storage URI of a KMS encrypted file
      containing the password to the user provided key. For the self-signed
      certificate, this password is generated by Dataproc.
    keystorePasswordUri: Optional. The Cloud Storage URI of a KMS encrypted
      file containing the password to the user provided keystore. For the
      self-signed certificate, this password is generated by Dataproc.
    keystoreUri: Optional. The Cloud Storage URI of the keystore file used for
      SSL encryption. If not provided, Dataproc will provide a self-signed
      certificate.
    kmsKeyUri: Required. The uri of the KMS key used to encrypt various
      sensitive files.
    realm: Optional. The name of the on-cluster Kerberos realm. If not
      specified, the uppercased domain of hostnames will be the realm.
    rootPrincipalPasswordUri: Required. The Cloud Storage URI of a KMS
      encrypted file containing the root principal password.
    tgtLifetimeHours: Optional. The lifetime of the ticket granting ticket, in
      hours. If not specified, or user specifies 0, then default value 10 will
      be used.
    truststorePasswordUri: Optional. The Cloud Storage URI of a KMS encrypted
      file containing the password to the user provided truststore. For the
      self-signed certificate, this password is generated by Dataproc.
    truststoreUri: Optional. The Cloud Storage URI of the truststore file used
      for SSL encryption. If not provided, Dataproc will provide a self-signed
      certificate.
  """

  crossRealmTrustAdminServer = _messages.StringField(1)
  crossRealmTrustKdc = _messages.StringField(2)
  crossRealmTrustRealm = _messages.StringField(3)
  crossRealmTrustSharedPasswordUri = _messages.StringField(4)
  enableKerberos = _messages.BooleanField(5)
  kdcDbKeyUri = _messages.StringField(6)
  keyPasswordUri = _messages.StringField(7)
  keystorePasswordUri = _messages.StringField(8)
  keystoreUri = _messages.StringField(9)
  kmsKeyUri = _messages.StringField(10)
  realm = _messages.StringField(11)
  rootPrincipalPasswordUri = _messages.StringField(12)
  tgtLifetimeHours = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  truststorePasswordUri = _messages.StringField(14)
  truststoreUri = _messages.StringField(15)


class LifecycleConfig(_messages.Message):
  r"""Specifies the cluster auto-delete schedule configuration.

  Fields:
    autoDeleteTime: Optional. The time when cluster will be auto-deleted (see
      JSON representation of Timestamp
      (https://developers.google.com/protocol-buffers/docs/proto3#json)).
    autoDeleteTtl: Optional. The lifetime duration of cluster. The cluster
      will be auto-deleted at the end of this period. Minimum value is 10
      minutes; maximum value is 14 days (see JSON representation of Duration
      (https://developers.google.com/protocol-buffers/docs/proto3#json)).
    idleDeleteTtl: Optional. The duration to keep the cluster alive while
      idling (when no jobs are running). Passing this threshold will cause the
      cluster to be deleted. Minimum value is 10 minutes; maximum value is 14
      days (see JSON representation of Duration
      (https://developers.google.com/protocol-buffers/docs/proto3#json).
    idleStartTime: Output only. The time when cluster became idle (most recent
      job finished) and became eligible for deletion due to idleness (see JSON
      representation of Timestamp (https://developers.google.com/protocol-
      buffers/docs/proto3#json)).
  """

  autoDeleteTime = _messages.StringField(1)
  autoDeleteTtl = _messages.StringField(2)
  idleDeleteTtl = _messages.StringField(3)
  idleStartTime = _messages.StringField(4)


class ListAutoscalingPoliciesResponse(_messages.Message):
  r"""A response to a request to list autoscaling policies in a project.

  Fields:
    nextPageToken: Output only. This token is included in the response if
      there are more results to fetch.
    policies: Output only. Autoscaling policies list.
  """

  nextPageToken = _messages.StringField(1)
  policies = _messages.MessageField('AutoscalingPolicy', 2, repeated=True)


class ListClustersResponse(_messages.Message):
  r"""The list of all clusters in a project.

  Fields:
    clusters: Output only. The clusters in the project.
    nextPageToken: Output only. This token is included in the response if
      there are more results to fetch. To fetch additional results, provide
      this value as the page_token in a subsequent ListClustersRequest.
  """

  clusters = _messages.MessageField('Cluster', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListJobsResponse(_messages.Message):
  r"""A list of jobs in a project.

  Fields:
    jobs: Output only. Jobs list.
    nextPageToken: Optional. This token is included in the response if there
      are more results to fetch. To fetch additional results, provide this
      value as the page_token in a subsequent <code>ListJobsRequest</code>.
  """

  jobs = _messages.MessageField('Job', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListWorkflowTemplatesResponse(_messages.Message):
  r"""A response to a request to list workflow templates in a project.

  Fields:
    nextPageToken: Output only. This token is included in the response if
      there are more results to fetch. To fetch additional results, provide
      this value as the page_token in a subsequent
      <code>ListWorkflowTemplatesRequest</code>.
    templates: Output only. WorkflowTemplates list.
  """

  nextPageToken = _messages.StringField(1)
  templates = _messages.MessageField('WorkflowTemplate', 2, repeated=True)


class LoggingConfig(_messages.Message):
  r"""The runtime logging config of the job.

  Messages:
    DriverLogLevelsValue: The per-package log levels for the driver. This may
      include "root" package name to configure rootLogger. Examples:
      'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'

  Fields:
    driverLogLevels: The per-package log levels for the driver. This may
      include "root" package name to configure rootLogger. Examples:
      'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DriverLogLevelsValue(_messages.Message):
    r"""The per-package log levels for the driver. This may include "root"
    package name to configure rootLogger. Examples:  'com.google = FATAL',
    'root = INFO', 'org.apache = DEBUG'

    Messages:
      AdditionalProperty: An additional property for a DriverLogLevelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type DriverLogLevelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DriverLogLevelsValue object.

      Enums:
        ValueValueValuesEnum:

      Fields:
        key: Name of the additional property.
        value: A ValueValueValuesEnum attribute.
      """

      class ValueValueValuesEnum(_messages.Enum):
        r"""ValueValueValuesEnum enum type.

        Values:
          LEVEL_UNSPECIFIED: <no description>
          ALL: <no description>
          TRACE: <no description>
          DEBUG: <no description>
          INFO: <no description>
          WARN: <no description>
          ERROR: <no description>
          FATAL: <no description>
          OFF: <no description>
        """
        LEVEL_UNSPECIFIED = 0
        ALL = 1
        TRACE = 2
        DEBUG = 3
        INFO = 4
        WARN = 5
        ERROR = 6
        FATAL = 7
        OFF = 8

      key = _messages.StringField(1)
      value = _messages.EnumField('ValueValueValuesEnum', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  driverLogLevels = _messages.MessageField('DriverLogLevelsValue', 1)


class ManagedCluster(_messages.Message):
  r"""Cluster that is managed by the workflow.

  Messages:
    LabelsValue: Optional. The labels to associate with this cluster.Label
      keys must be between 1 and 63 characters long, and must conform to the
      following PCRE regular expression: \p{Ll}\p{Lo}{0,62}Label values must
      be between 1 and 63 characters long, and must conform to the following
      PCRE regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels
      can be associated with a given cluster.

  Fields:
    clusterName: Required. The cluster name prefix. A unique cluster name will
      be formed by appending a random suffix.The name must contain only lower-
      case letters (a-z), numbers (0-9), and hyphens (-). Must begin with a
      letter. Cannot begin or end with hyphen. Must consist of between 2 and
      35 characters.
    config: Required. The cluster configuration.
    labels: Optional. The labels to associate with this cluster.Label keys
      must be between 1 and 63 characters long, and must conform to the
      following PCRE regular expression: \p{Ll}\p{Lo}{0,62}Label values must
      be between 1 and 63 characters long, and must conform to the following
      PCRE regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels
      can be associated with a given cluster.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels to associate with this cluster.Label keys must be
    between 1 and 63 characters long, and must conform to the following PCRE
    regular expression: \p{Ll}\p{Lo}{0,62}Label values must be between 1 and
    63 characters long, and must conform to the following PCRE regular
    expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be
    associated with a given cluster.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusterName = _messages.StringField(1)
  config = _messages.MessageField('ClusterConfig', 2)
  labels = _messages.MessageField('LabelsValue', 3)


class ManagedGroupConfig(_messages.Message):
  r"""Specifies the resources used to actively manage an instance group.

  Fields:
    instanceGroupManagerName: Output only. The name of the Instance Group
      Manager for this group.
    instanceTemplateName: Output only. The name of the Instance Template used
      for the Managed Instance Group.
  """

  instanceGroupManagerName = _messages.StringField(1)
  instanceTemplateName = _messages.StringField(2)


class NodeInitializationAction(_messages.Message):
  r"""Specifies an executable to run on a fully configured node and a timeout
  period for executable completion.

  Fields:
    executableFile: Required. Cloud Storage URI of executable file.
    executionTimeout: Optional. Amount of time executable has to complete.
      Default is 10 minutes (see JSON representation of Duration
      (https://developers.google.com/protocol-
      buffers/docs/proto3#json)).Cluster creation fails with an explanatory
      error message (the name of the executable that caused the error and the
      exceeded timeout period) if the executable is not completed at end of
      the timeout period.
  """

  executableFile = _messages.StringField(1)
  executionTimeout = _messages.StringField(2)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as Delete, the
      response is google.protobuf.Empty. If the original method is standard
      Get/Create/Update, the response should be the resource. For other
      methods, the response should have the type XxxResponse, where Xxx is the
      original method name. For example, if the original method name is
      TakeSnapshot(), the inferred response type is TakeSnapshotResponse.

  Fields:
    done: If the value is false, it means the operation is still in progress.
      If true, the operation is completed, and either error or response is
      available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the name should be a resource name ending with operations/{unique_id}.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as Delete, the response
      is google.protobuf.Empty. If the original method is standard
      Get/Create/Update, the response should be the resource. For other
      methods, the response should have the type XxxResponse, where Xxx is the
      original method name. For example, if the original method name is
      TakeSnapshot(), the inferred response type is TakeSnapshotResponse.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as Delete, the response
    is google.protobuf.Empty. If the original method is standard
    Get/Create/Update, the response should be the resource. For other methods,
    the response should have the type XxxResponse, where Xxx is the original
    method name. For example, if the original method name is TakeSnapshot(),
    the inferred response type is TakeSnapshotResponse.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OrderedJob(_messages.Message):
  r"""A job executed by the workflow.

  Messages:
    LabelsValue: Optional. The labels to associate with this job.Label keys
      must be between 1 and 63 characters long, and must conform to the
      following regular expression: \p{Ll}\p{Lo}{0,62}Label values must be
      between 1 and 63 characters long, and must conform to the following
      regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can
      be associated with a given job.

  Fields:
    hadoopJob: Optional. Job is a Hadoop job.
    hiveJob: Optional. Job is a Hive job.
    labels: Optional. The labels to associate with this job.Label keys must be
      between 1 and 63 characters long, and must conform to the following
      regular expression: \p{Ll}\p{Lo}{0,62}Label values must be between 1 and
      63 characters long, and must conform to the following regular
      expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be
      associated with a given job.
    pigJob: Optional. Job is a Pig job.
    prerequisiteStepIds: Optional. The optional list of prerequisite job
      step_ids. If not specified, the job will start at the beginning of
      workflow.
    prestoJob: Optional. Job is a Presto job.
    pysparkJob: Optional. Job is a PySpark job.
    scheduling: Optional. Job scheduling configuration.
    sparkJob: Optional. Job is a Spark job.
    sparkRJob: Optional. Job is a SparkR job.
    sparkSqlJob: Optional. Job is a SparkSql job.
    stepId: Required. The step id. The id must be unique among all jobs within
      the template.The step id is used as prefix for job id, as job goog-
      dataproc-workflow-step-id label, and in prerequisiteStepIds field from
      other steps.The id must contain only letters (a-z, A-Z), numbers (0-9),
      underscores (_), and hyphens (-). Cannot begin or end with underscore or
      hyphen. Must consist of between 3 and 50 characters.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels to associate with this job.Label keys must be
    between 1 and 63 characters long, and must conform to the following
    regular expression: \p{Ll}\p{Lo}{0,62}Label values must be between 1 and
    63 characters long, and must conform to the following regular expression:
    \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be associated with a
    given job.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  hadoopJob = _messages.MessageField('HadoopJob', 1)
  hiveJob = _messages.MessageField('HiveJob', 2)
  labels = _messages.MessageField('LabelsValue', 3)
  pigJob = _messages.MessageField('PigJob', 4)
  prerequisiteStepIds = _messages.StringField(5, repeated=True)
  prestoJob = _messages.MessageField('PrestoJob', 6)
  pysparkJob = _messages.MessageField('PySparkJob', 7)
  scheduling = _messages.MessageField('JobScheduling', 8)
  sparkJob = _messages.MessageField('SparkJob', 9)
  sparkRJob = _messages.MessageField('SparkRJob', 10)
  sparkSqlJob = _messages.MessageField('SparkSqlJob', 11)
  stepId = _messages.StringField(12)


class ParameterValidation(_messages.Message):
  r"""Configuration for parameter validation.

  Fields:
    regex: Validation based on regular expressions.
    values: Validation based on a list of allowed values.
  """

  regex = _messages.MessageField('RegexValidation', 1)
  values = _messages.MessageField('ValueValidation', 2)


class PigJob(_messages.Message):
  r"""A Dataproc job for running Apache Pig (https://pig.apache.org/) queries
  on YARN.

  Messages:
    PropertiesValue: Optional. A mapping of property names to values, used to
      configure Pig. Properties that conflict with values set by the Dataproc
      API may be overwritten. Can include properties set in
      /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes
      in user code.
    ScriptVariablesValue: Optional. Mapping of query variable names to values
      (equivalent to the Pig command: name=[value]).

  Fields:
    continueOnFailure: Optional. Whether to continue executing queries if a
      query fails. The default value is false. Setting to true can be useful
      when executing independent parallel queries.
    jarFileUris: Optional. HCFS URIs of jar files to add to the CLASSPATH of
      the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
    loggingConfig: Optional. The runtime log config for job execution.
    properties: Optional. A mapping of property names to values, used to
      configure Pig. Properties that conflict with values set by the Dataproc
      API may be overwritten. Can include properties set in
      /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes
      in user code.
    queryFileUri: The HCFS URI of the script that contains the Pig queries.
    queryList: A list of queries.
    scriptVariables: Optional. Mapping of query variable names to values
      (equivalent to the Pig command: name=[value]).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Optional. A mapping of property names to values, used to configure
    Pig. Properties that conflict with values set by the Dataproc API may be
    overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml,
    /etc/pig/conf/pig.properties, and classes in user code.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ScriptVariablesValue(_messages.Message):
    r"""Optional. Mapping of query variable names to values (equivalent to the
    Pig command: name=[value]).

    Messages:
      AdditionalProperty: An additional property for a ScriptVariablesValue
        object.

    Fields:
      additionalProperties: Additional properties of type ScriptVariablesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ScriptVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  continueOnFailure = _messages.BooleanField(1)
  jarFileUris = _messages.StringField(2, repeated=True)
  loggingConfig = _messages.MessageField('LoggingConfig', 3)
  properties = _messages.MessageField('PropertiesValue', 4)
  queryFileUri = _messages.StringField(5)
  queryList = _messages.MessageField('QueryList', 6)
  scriptVariables = _messages.MessageField('ScriptVariablesValue', 7)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources.A Policy is a collection of bindings. A
  binding binds one or more members to a single role. Members can be user
  accounts, service accounts, Google groups, and domains (such as G Suite). A
  role is a named list of permissions; each role can be an IAM predefined role
  or a user-created custom role.For some types of Google Cloud resources, a
  binding can also specify a condition, which is a logical expression that
  allows access to a resource only if the expression evaluates to true. A
  condition can add constraints based on attributes of the request, the
  resource, or both. To learn which resources support conditions in their IAM
  policies, see the IAM documentation
  (https://cloud.google.com/iam/help/conditions/resource-policies).JSON
  example: {   "bindings": [     {       "role":
  "roles/resourcemanager.organizationAdmin",       "members": [
  "user:mike@example.com",         "group:admins@example.com",
  "domain:google.com",         "serviceAccount:my-project-
  id@appspot.gserviceaccount.com"       ]     },     {       "role":
  "roles/resourcemanager.organizationViewer",       "members": [
  "user:eve@example.com"       ],       "condition": {         "title":
  "expirable access",         "description": "Does not grant access after Sep
  2020",         "expression": "request.time <
  timestamp('2020-10-01T00:00:00.000Z')",       }     }   ],   "etag":
  "BwWWja0YfJA=",   "version": 3 } YAML example: bindings: - members:   -
  user:mike@example.com   - group:admins@example.com   - domain:google.com   -
  serviceAccount:my-project-id@appspot.gserviceaccount.com   role:
  roles/resourcemanager.organizationAdmin - members:   - user:eve@example.com
  role: roles/resourcemanager.organizationViewer   condition:     title:
  expirable access     description: Does not grant access after Sep 2020
  expression: request.time < timestamp('2020-10-01T00:00:00.000Z') - etag:
  BwWWja0YfJA= - version: 3 For a description of IAM and its features, see the
  IAM documentation (https://cloud.google.com/iam/docs/).

  Fields:
    bindings: Associates a list of members to a role. Optionally, may specify
      a condition that determines how and when the bindings are applied. Each
      of the bindings must contain at least one member.
    etag: etag is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the etag in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An etag is returned in the response to getIamPolicy, and
      systems are expected to put that etag in the request to setIamPolicy to
      ensure that their change will be applied to the same version of the
      policy.Important: If you use IAM Conditions, you must include the etag
      field whenever you call setIamPolicy. If you omit this field, then IAM
      allows you to overwrite a version 3 policy with a version 1 policy, and
      all of the conditions in the version 3 policy are lost.
    version: Specifies the format of the policy.Valid values are 0, 1, and 3.
      Requests that specify an invalid value are rejected.Any operation that
      affects conditional role bindings must specify version 3. This
      requirement applies to the following operations: Getting a policy that
      includes a conditional role binding Adding a conditional role binding to
      a policy Changing a conditional role binding in a policy Removing any
      role binding, with or without a condition, from a policy  that includes
      conditionsImportant: If you use IAM Conditions, you must include the
      etag field whenever you call setIamPolicy. If you omit this field, then
      IAM allows you to overwrite a version 3 policy with a version 1 policy,
      and all of the conditions in the version 3 policy are lost.If a policy
      does not include any conditions, operations on that policy may specify
      any valid version or leave the field unset.To learn which resources
      support conditions in their IAM policies, see the IAM documentation
      (https://cloud.google.com/iam/help/conditions/resource-policies).
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class PrestoJob(_messages.Message):
  r"""A Dataproc job for running Presto (https://prestosql.io/) queries.
  IMPORTANT: The Dataproc Presto Optional Component
  (https://cloud.google.com/dataproc/docs/concepts/components/presto) must be
  enabled when the cluster is created to submit a Presto job to the cluster.

  Messages:
    PropertiesValue: Optional. A mapping of property names to values. Used to
      set Presto session properties (https://prestodb.io/docs/current/sql/set-
      session.html) Equivalent to using the --session flag in the Presto CLI

  Fields:
    clientTags: Optional. Presto client tags to attach to this query
    continueOnFailure: Optional. Whether to continue executing queries if a
      query fails. The default value is false. Setting to true can be useful
      when executing independent parallel queries.
    loggingConfig: Optional. The runtime log config for job execution.
    outputFormat: Optional. The format in which query output will be
      displayed. See the Presto documentation for supported output formats
    properties: Optional. A mapping of property names to values. Used to set
      Presto session properties (https://prestodb.io/docs/current/sql/set-
      session.html) Equivalent to using the --session flag in the Presto CLI
    queryFileUri: The HCFS URI of the script that contains SQL queries.
    queryList: A list of queries.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Optional. A mapping of property names to values. Used to set Presto
    session properties (https://prestodb.io/docs/current/sql/set-session.html)
    Equivalent to using the --session flag in the Presto CLI

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clientTags = _messages.StringField(1, repeated=True)
  continueOnFailure = _messages.BooleanField(2)
  loggingConfig = _messages.MessageField('LoggingConfig', 3)
  outputFormat = _messages.StringField(4)
  properties = _messages.MessageField('PropertiesValue', 5)
  queryFileUri = _messages.StringField(6)
  queryList = _messages.MessageField('QueryList', 7)


class PySparkJob(_messages.Message):
  r"""A Dataproc job for running Apache PySpark
  (https://spark.apache.org/docs/0.9.0/python-programming-guide.html)
  applications on YARN.

  Messages:
    PropertiesValue: Optional. A mapping of property names to values, used to
      configure PySpark. Properties that conflict with values set by the
      Dataproc API may be overwritten. Can include properties set in
      /etc/spark/conf/spark-defaults.conf and classes in user code.

  Fields:
    archiveUris: Optional. HCFS URIs of archives to be extracted into the
      working directory of each executor. Supported file types: .jar, .tar,
      .tar.gz, .tgz, and .zip.
    args: Optional. The arguments to pass to the driver. Do not include
      arguments, such as --conf, that can be set as job properties, since a
      collision may occur that causes an incorrect job submission.
    fileUris: Optional. HCFS URIs of files to be placed in the working
      directory of each executor. Useful for naively parallel tasks.
    jarFileUris: Optional. HCFS URIs of jar files to add to the CLASSPATHs of
      the Python driver and tasks.
    loggingConfig: Optional. The runtime log config for job execution.
    mainPythonFileUri: Required. The HCFS URI of the main Python file to use
      as the driver. Must be a .py file.
    properties: Optional. A mapping of property names to values, used to
      configure PySpark. Properties that conflict with values set by the
      Dataproc API may be overwritten. Can include properties set in
      /etc/spark/conf/spark-defaults.conf and classes in user code.
    pythonFileUris: Optional. HCFS file URIs of Python files to pass to the
      PySpark framework. Supported file types: .py, .egg, and .zip.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Optional. A mapping of property names to values, used to configure
    PySpark. Properties that conflict with values set by the Dataproc API may
    be overwritten. Can include properties set in /etc/spark/conf/spark-
    defaults.conf and classes in user code.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  archiveUris = _messages.StringField(1, repeated=True)
  args = _messages.StringField(2, repeated=True)
  fileUris = _messages.StringField(3, repeated=True)
  jarFileUris = _messages.StringField(4, repeated=True)
  loggingConfig = _messages.MessageField('LoggingConfig', 5)
  mainPythonFileUri = _messages.StringField(6)
  properties = _messages.MessageField('PropertiesValue', 7)
  pythonFileUris = _messages.StringField(8, repeated=True)


class QueryList(_messages.Message):
  r"""A list of queries to run on a cluster.

  Fields:
    queries: Required. The queries to execute. You do not need to terminate a
      query with a semicolon. Multiple queries can be specified in one string
      by separating each with a semicolon. Here is an example of an Cloud
      Dataproc API snippet that uses a QueryList to specify a HiveJob:
      "hiveJob": {   "queryList": {     "queries": [       "query1",
      "query2",       "query3;query4",     ]   } }
  """

  queries = _messages.StringField(1, repeated=True)


class RegexValidation(_messages.Message):
  r"""Validation based on regular expressions.

  Fields:
    regexes: Required. RE2 regular expressions used to validate the
      parameter's value. The value must match the regex in its entirety
      (substring matches are not sufficient).
  """

  regexes = _messages.StringField(1, repeated=True)


class ReservationAffinity(_messages.Message):
  r"""Reservation Affinity for consuming Zonal reservation.

  Enums:
    ConsumeReservationTypeValueValuesEnum: Optional. Type of reservation to
      consume

  Fields:
    consumeReservationType: Optional. Type of reservation to consume
    key: Optional. Corresponds to the label key of reservation resource.
    values: Optional. Corresponds to the label values of reservation resource.
  """

  class ConsumeReservationTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Type of reservation to consume

    Values:
      TYPE_UNSPECIFIED: <no description>
      NO_RESERVATION: Do not consume from any allocated capacity.
      ANY_RESERVATION: Consume any reservation available.
      SPECIFIC_RESERVATION: Must consume from a specific reservation. Must
        specify key value fields for specifying the reservations.
    """
    TYPE_UNSPECIFIED = 0
    NO_RESERVATION = 1
    ANY_RESERVATION = 2
    SPECIFIC_RESERVATION = 3

  consumeReservationType = _messages.EnumField('ConsumeReservationTypeValueValuesEnum', 1)
  key = _messages.StringField(2)
  values = _messages.StringField(3, repeated=True)


class SecurityConfig(_messages.Message):
  r"""Security related configuration, including Kerberos.

  Fields:
    kerberosConfig: Kerberos related configuration.
  """

  kerberosConfig = _messages.MessageField('KerberosConfig', 1)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for SetIamPolicy method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the resource. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
  """

  policy = _messages.MessageField('Policy', 1)


class SoftwareConfig(_messages.Message):
  r"""Specifies the selection and config of software inside the cluster.

  Enums:
    OptionalComponentsValueListEntryValuesEnum:

  Messages:
    PropertiesValue: Optional. The properties to set on daemon config
      files.Property keys are specified in prefix:property format, for example
      core:hadoop.tmp.dir. The following are supported prefixes and their
      mappings: capacity-scheduler: capacity-scheduler.xml core: core-site.xml
      distcp: distcp-default.xml hdfs: hdfs-site.xml hive: hive-site.xml
      mapred: mapred-site.xml pig: pig.properties spark: spark-defaults.conf
      yarn: yarn-site.xmlFor more information, see Cluster properties
      (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).

  Fields:
    imageVersion: Optional. The version of software inside the cluster. It
      must be one of the supported Dataproc Versions
      (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-
      versions#supported_cloud_dataproc_versions), such as "1.2" (including a
      subminor version, such as "1.2.29"), or the "preview" version
      (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-
      versions#other_versions). If unspecified, it defaults to the latest
      Debian version.
    optionalComponents: Optional. The set of components to activate on the
      cluster.
    properties: Optional. The properties to set on daemon config
      files.Property keys are specified in prefix:property format, for example
      core:hadoop.tmp.dir. The following are supported prefixes and their
      mappings: capacity-scheduler: capacity-scheduler.xml core: core-site.xml
      distcp: distcp-default.xml hdfs: hdfs-site.xml hive: hive-site.xml
      mapred: mapred-site.xml pig: pig.properties spark: spark-defaults.conf
      yarn: yarn-site.xmlFor more information, see Cluster properties
      (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
  """

  class OptionalComponentsValueListEntryValuesEnum(_messages.Enum):
    r"""OptionalComponentsValueListEntryValuesEnum enum type.

    Values:
      COMPONENT_UNSPECIFIED: <no description>
      ANACONDA: <no description>
      DOCKER: <no description>
      DRUID: <no description>
      FLINK: <no description>
      HBASE: <no description>
      HIVE_WEBHCAT: <no description>
      JUPYTER: <no description>
      KERBEROS: <no description>
      PRESTO: <no description>
      RANGER: <no description>
      SOLR: <no description>
      ZEPPELIN: <no description>
      ZOOKEEPER: <no description>
    """
    COMPONENT_UNSPECIFIED = 0
    ANACONDA = 1
    DOCKER = 2
    DRUID = 3
    FLINK = 4
    HBASE = 5
    HIVE_WEBHCAT = 6
    JUPYTER = 7
    KERBEROS = 8
    PRESTO = 9
    RANGER = 10
    SOLR = 11
    ZEPPELIN = 12
    ZOOKEEPER = 13

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Optional. The properties to set on daemon config files.Property keys
    are specified in prefix:property format, for example core:hadoop.tmp.dir.
    The following are supported prefixes and their mappings: capacity-
    scheduler: capacity-scheduler.xml core: core-site.xml distcp: distcp-
    default.xml hdfs: hdfs-site.xml hive: hive-site.xml mapred: mapred-
    site.xml pig: pig.properties spark: spark-defaults.conf yarn: yarn-
    site.xmlFor more information, see Cluster properties
    (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  imageVersion = _messages.StringField(1)
  optionalComponents = _messages.EnumField('OptionalComponentsValueListEntryValuesEnum', 2, repeated=True)
  properties = _messages.MessageField('PropertiesValue', 3)


class SparkJob(_messages.Message):
  r"""A Dataproc job for running Apache Spark (http://spark.apache.org/)
  applications on YARN.

  Messages:
    PropertiesValue: Optional. A mapping of property names to values, used to
      configure Spark. Properties that conflict with values set by the
      Dataproc API may be overwritten. Can include properties set in
      /etc/spark/conf/spark-defaults.conf and classes in user code.

  Fields:
    archiveUris: Optional. HCFS URIs of archives to be extracted into the
      working directory of each executor. Supported file types: .jar, .tar,
      .tar.gz, .tgz, and .zip.
    args: Optional. The arguments to pass to the driver. Do not include
      arguments, such as --conf, that can be set as job properties, since a
      collision may occur that causes an incorrect job submission.
    fileUris: Optional. HCFS URIs of files to be placed in the working
      directory of each executor. Useful for naively parallel tasks.
    jarFileUris: Optional. HCFS URIs of jar files to add to the CLASSPATHs of
      the Spark driver and tasks.
    loggingConfig: Optional. The runtime log config for job execution.
    mainClass: The name of the driver's main class. The jar file that contains
      the class must be in the default CLASSPATH or specified in
      jar_file_uris.
    mainJarFileUri: The HCFS URI of the jar file that contains the main class.
    properties: Optional. A mapping of property names to values, used to
      configure Spark. Properties that conflict with values set by the
      Dataproc API may be overwritten. Can include properties set in
      /etc/spark/conf/spark-defaults.conf and classes in user code.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Optional. A mapping of property names to values, used to configure
    Spark. Properties that conflict with values set by the Dataproc API may be
    overwritten. Can include properties set in /etc/spark/conf/spark-
    defaults.conf and classes in user code.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  archiveUris = _messages.StringField(1, repeated=True)
  args = _messages.StringField(2, repeated=True)
  fileUris = _messages.StringField(3, repeated=True)
  jarFileUris = _messages.StringField(4, repeated=True)
  loggingConfig = _messages.MessageField('LoggingConfig', 5)
  mainClass = _messages.StringField(6)
  mainJarFileUri = _messages.StringField(7)
  properties = _messages.MessageField('PropertiesValue', 8)


class SparkRJob(_messages.Message):
  r"""A Dataproc job for running Apache SparkR
  (https://spark.apache.org/docs/latest/sparkr.html) applications on YARN.

  Messages:
    PropertiesValue: Optional. A mapping of property names to values, used to
      configure SparkR. Properties that conflict with values set by the
      Dataproc API may be overwritten. Can include properties set in
      /etc/spark/conf/spark-defaults.conf and classes in user code.

  Fields:
    archiveUris: Optional. HCFS URIs of archives to be extracted into the
      working directory of each executor. Supported file types: .jar, .tar,
      .tar.gz, .tgz, and .zip.
    args: Optional. The arguments to pass to the driver. Do not include
      arguments, such as --conf, that can be set as job properties, since a
      collision may occur that causes an incorrect job submission.
    fileUris: Optional. HCFS URIs of files to be placed in the working
      directory of each executor. Useful for naively parallel tasks.
    loggingConfig: Optional. The runtime log config for job execution.
    mainRFileUri: Required. The HCFS URI of the main R file to use as the
      driver. Must be a .R file.
    properties: Optional. A mapping of property names to values, used to
      configure SparkR. Properties that conflict with values set by the
      Dataproc API may be overwritten. Can include properties set in
      /etc/spark/conf/spark-defaults.conf and classes in user code.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Optional. A mapping of property names to values, used to configure
    SparkR. Properties that conflict with values set by the Dataproc API may
    be overwritten. Can include properties set in /etc/spark/conf/spark-
    defaults.conf and classes in user code.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  archiveUris = _messages.StringField(1, repeated=True)
  args = _messages.StringField(2, repeated=True)
  fileUris = _messages.StringField(3, repeated=True)
  loggingConfig = _messages.MessageField('LoggingConfig', 4)
  mainRFileUri = _messages.StringField(5)
  properties = _messages.MessageField('PropertiesValue', 6)


class SparkSqlJob(_messages.Message):
  r"""A Dataproc job for running Apache Spark SQL
  (http://spark.apache.org/sql/) queries.

  Messages:
    PropertiesValue: Optional. A mapping of property names to values, used to
      configure Spark SQL's SparkConf. Properties that conflict with values
      set by the Dataproc API may be overwritten.
    ScriptVariablesValue: Optional. Mapping of query variable names to values
      (equivalent to the Spark SQL command: SET name="value";).

  Fields:
    jarFileUris: Optional. HCFS URIs of jar files to be added to the Spark
      CLASSPATH.
    loggingConfig: Optional. The runtime log config for job execution.
    properties: Optional. A mapping of property names to values, used to
      configure Spark SQL's SparkConf. Properties that conflict with values
      set by the Dataproc API may be overwritten.
    queryFileUri: The HCFS URI of the script that contains SQL queries.
    queryList: A list of queries.
    scriptVariables: Optional. Mapping of query variable names to values
      (equivalent to the Spark SQL command: SET name="value";).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Optional. A mapping of property names to values, used to configure
    Spark SQL's SparkConf. Properties that conflict with values set by the
    Dataproc API may be overwritten.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ScriptVariablesValue(_messages.Message):
    r"""Optional. Mapping of query variable names to values (equivalent to the
    Spark SQL command: SET name="value";).

    Messages:
      AdditionalProperty: An additional property for a ScriptVariablesValue
        object.

    Fields:
      additionalProperties: Additional properties of type ScriptVariablesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ScriptVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  jarFileUris = _messages.StringField(1, repeated=True)
  loggingConfig = _messages.MessageField('LoggingConfig', 2)
  properties = _messages.MessageField('PropertiesValue', 3)
  queryFileUri = _messages.StringField(4)
  queryList = _messages.MessageField('QueryList', 5)
  scriptVariables = _messages.MessageField('ScriptVariablesValue', 6)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  alt = _messages.EnumField('AltValueValuesEnum', 2, default='json')
  callback = _messages.StringField(3)
  fields = _messages.StringField(4)
  key = _messages.StringField(5)
  prettyPrint = _messages.BooleanField(6, default=True)
  quotaUser = _messages.StringField(7)
  trace = _messages.StringField(8)
  uploadType = _messages.StringField(9)
  upload_protocol = _messages.StringField(10)


class Status(_messages.Message):
  r"""The Status type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by gRPC (https://github.com/grpc). Each Status message contains three
  pieces of data: error code, error message, and error details.You can find
  out more about this error model and how to work with it in the API Design
  Guide (https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class SubmitJobRequest(_messages.Message):
  r"""A request to submit a job.

  Fields:
    job: Required. The job resource.
    requestId: Optional. A unique id used to identify the request. If the
      server receives two SubmitJobRequest requests with the same id, then the
      second request will be ignored and the first Job created and stored in
      the backend is returned.It is recommended to always set this value to a
      UUID (https://en.wikipedia.org/wiki/Universally_unique_identifier).The
      id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
      and hyphens (-). The maximum length is 40 characters.
  """

  job = _messages.MessageField('Job', 1)
  requestId = _messages.StringField(2)


class TemplateParameter(_messages.Message):
  r"""A configurable parameter that replaces one or more fields in the
  template. Parameterizable fields: - Labels - File uris - Job properties -
  Job arguments - Script variables - Main class (in HadoopJob and SparkJob) -
  Zone (in ClusterSelector)

  Fields:
    description: Optional. Brief description of the parameter. Must not exceed
      1024 characters.
    fields: Required. Paths to all fields that the parameter replaces. A field
      is allowed to appear in at most one parameter's list of field paths.A
      field path is similar in syntax to a google.protobuf.FieldMask. For
      example, a field path that references the zone field of a workflow
      template's cluster selector would be specified as
      placement.clusterSelector.zone.Also, field paths can reference fields
      using the following syntax: Values in maps can be referenced by key:
      labels'key' placement.clusterSelector.clusterLabels'key'
      placement.managedCluster.labels'key'
      placement.clusterSelector.clusterLabels'key' jobs'step-id'.labels'key'
      Jobs in the jobs list can be referenced by step-id: jobs'step-
      id'.hadoopJob.mainJarFileUri jobs'step-id'.hiveJob.queryFileUri
      jobs'step-id'.pySparkJob.mainPythonFileUri jobs'step-
      id'.hadoopJob.jarFileUris0 jobs'step-id'.hadoopJob.archiveUris0
      jobs'step-id'.hadoopJob.fileUris0 jobs'step-
      id'.pySparkJob.pythonFileUris0 Items in repeated fields can be
      referenced by a zero-based index: jobs'step-id'.sparkJob.args0 Other
      examples: jobs'step-id'.hadoopJob.properties'key' jobs'step-
      id'.hadoopJob.args0 jobs'step-id'.hiveJob.scriptVariables'key'
      jobs'step-id'.hadoopJob.mainJarFileUri placement.clusterSelector.zoneIt
      may not be possible to parameterize maps and repeated fields in their
      entirety since only individual map values and individual items in
      repeated fields can be referenced. For example, the following field
      paths are invalid: placement.clusterSelector.clusterLabels jobs'step-
      id'.sparkJob.args
    name: Required. Parameter name. The parameter name is used as the key, and
      paired with the parameter value, which are passed to the template when
      the template is instantiated. The name must contain only capital letters
      (A-Z), numbers (0-9), and underscores (_), and must not start with a
      number. The maximum length is 40 characters.
    validation: Optional. Validation rules to be applied to this parameter's
      value.
  """

  description = _messages.StringField(1)
  fields = _messages.StringField(2, repeated=True)
  name = _messages.StringField(3)
  validation = _messages.MessageField('ParameterValidation', 4)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for TestIamPermissions method.

  Fields:
    permissions: The set of permissions to check for the resource. Permissions
      with wildcards (such as '*' or 'storage.*') are not allowed. For more
      information see IAM Overview
      (https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for TestIamPermissions method.

  Fields:
    permissions: A subset of TestPermissionsRequest.permissions that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class ValueValidation(_messages.Message):
  r"""Validation based on a list of allowed values.

  Fields:
    values: Required. List of allowed values for the parameter.
  """

  values = _messages.StringField(1, repeated=True)


class WorkflowGraph(_messages.Message):
  r"""The workflow graph.

  Fields:
    nodes: Output only. The workflow nodes.
  """

  nodes = _messages.MessageField('WorkflowNode', 1, repeated=True)


class WorkflowMetadata(_messages.Message):
  r"""A Dataproc workflow template resource.

  Enums:
    StateValueValuesEnum: Output only. The workflow state.

  Messages:
    ParametersValue: Map from parameter names to values that were used for
      those parameters.

  Fields:
    clusterName: Output only. The name of the target cluster.
    clusterUuid: Output only. The UUID of target cluster.
    createCluster: Output only. The create cluster operation metadata.
    deleteCluster: Output only. The delete cluster operation metadata.
    endTime: Output only. Workflow end time.
    graph: Output only. The workflow graph.
    parameters: Map from parameter names to values that were used for those
      parameters.
    startTime: Output only. Workflow start time.
    state: Output only. The workflow state.
    template: Output only. The resource name of the workflow template as
      described in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.workflowTemplates, the resource name of the  template
      has the following format:
      projects/{project_id}/regions/{region}/workflowTemplates/{template_id}
      For projects.locations.workflowTemplates, the resource name of the
      template has the following format:  projects/{project_id}/locations/{loc
      ation}/workflowTemplates/{template_id}
    version: Output only. The version of template at the time of workflow
      instantiation.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The workflow state.

    Values:
      UNKNOWN: Unused.
      PENDING: The operation has been created.
      RUNNING: The operation is running.
      DONE: The operation is done; either cancelled or completed.
    """
    UNKNOWN = 0
    PENDING = 1
    RUNNING = 2
    DONE = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Map from parameter names to values that were used for those
    parameters.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusterName = _messages.StringField(1)
  clusterUuid = _messages.StringField(2)
  createCluster = _messages.MessageField('ClusterOperation', 3)
  deleteCluster = _messages.MessageField('ClusterOperation', 4)
  endTime = _messages.StringField(5)
  graph = _messages.MessageField('WorkflowGraph', 6)
  parameters = _messages.MessageField('ParametersValue', 7)
  startTime = _messages.StringField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  template = _messages.StringField(10)
  version = _messages.IntegerField(11, variant=_messages.Variant.INT32)


class WorkflowNode(_messages.Message):
  r"""The workflow node.

  Enums:
    StateValueValuesEnum: Output only. The node state.

  Fields:
    error: Output only. The error detail.
    jobId: Output only. The job id; populated after the node enters RUNNING
      state.
    prerequisiteStepIds: Output only. Node's prerequisite nodes.
    state: Output only. The node state.
    stepId: Output only. The name of the node.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The node state.

    Values:
      NODE_STATE_UNSPECIFIED: State is unspecified.
      BLOCKED: The node is awaiting prerequisite node to finish.
      RUNNABLE: The node is runnable but not running.
      RUNNING: The node is running.
      COMPLETED: The node completed successfully.
      FAILED: The node failed. A node can be marked FAILED because its
        ancestor or peer failed.
    """
    NODE_STATE_UNSPECIFIED = 0
    BLOCKED = 1
    RUNNABLE = 2
    RUNNING = 3
    COMPLETED = 4
    FAILED = 5

  error = _messages.StringField(1)
  jobId = _messages.StringField(2)
  prerequisiteStepIds = _messages.StringField(3, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  stepId = _messages.StringField(5)


class WorkflowTemplate(_messages.Message):
  r"""A Dataproc workflow template resource.

  Messages:
    LabelsValue: Optional. The labels to associate with this template. These
      labels will be propagated to all jobs and clusters created by the
      workflow instance.Label keys must contain 1 to 63 characters, and must
      conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt).Label values
      may be empty, but, if present, must contain 1 to 63 characters, and must
      conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt).No more than
      32 labels can be associated with a template.

  Fields:
    createTime: Output only. The time template was created.
    id: A string attribute.
    jobs: Required. The Directed Acyclic Graph of Jobs to submit.
    labels: Optional. The labels to associate with this template. These labels
      will be propagated to all jobs and clusters created by the workflow
      instance.Label keys must contain 1 to 63 characters, and must conform to
      RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt).Label values may be
      empty, but, if present, must contain 1 to 63 characters, and must
      conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt).No more than
      32 labels can be associated with a template.
    name: Output only. The resource name of the workflow template, as
      described in https://cloud.google.com/apis/design/resource_names. For
      projects.regions.workflowTemplates, the resource name of the  template
      has the following format:
      projects/{project_id}/regions/{region}/workflowTemplates/{template_id}
      For projects.locations.workflowTemplates, the resource name of the
      template has the following format:  projects/{project_id}/locations/{loc
      ation}/workflowTemplates/{template_id}
    parameters: Optional. emplate parameters whose values are substituted into
      the template. Values for parameters must be provided when the template
      is instantiated.
    placement: Required. WorkflowTemplate scheduling information.
    updateTime: Output only. The time template was last updated.
    version: Optional. Used to perform a consistent read-modify-write.This
      field should be left blank for a CreateWorkflowTemplate request. It is
      required for an UpdateWorkflowTemplate request, and must match the
      current server version. A typical update template flow would fetch the
      current template with a GetWorkflowTemplate request, which will return
      the current template with the version field filled in with the current
      server version. The user updates other fields in the template, then
      returns it as part of the UpdateWorkflowTemplate request.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels to associate with this template. These labels
    will be propagated to all jobs and clusters created by the workflow
    instance.Label keys must contain 1 to 63 characters, and must conform to
    RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt).Label values may be empty,
    but, if present, must contain 1 to 63 characters, and must conform to RFC
    1035 (https://www.ietf.org/rfc/rfc1035.txt).No more than 32 labels can be
    associated with a template.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  id = _messages.StringField(2)
  jobs = _messages.MessageField('OrderedJob', 3, repeated=True)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  parameters = _messages.MessageField('TemplateParameter', 6, repeated=True)
  placement = _messages.MessageField('WorkflowTemplatePlacement', 7)
  updateTime = _messages.StringField(8)
  version = _messages.IntegerField(9, variant=_messages.Variant.INT32)


class WorkflowTemplatePlacement(_messages.Message):
  r"""Specifies workflow execution target.Either managed_cluster or
  cluster_selector is required.

  Fields:
    clusterSelector: Optional. A selector that chooses target cluster for jobs
      based on metadata.The selector is evaluated at the time each job is
      submitted.
    managedCluster: A cluster that is managed by the workflow.
  """

  clusterSelector = _messages.MessageField('ClusterSelector', 1)
  managedCluster = _messages.MessageField('ManagedCluster', 2)


class YarnApplication(_messages.Message):
  r"""A YARN application created by a job. Application information is a subset
  of <code>org.apache.hadoop.yarn.proto.YarnProtos.ApplicationReportProto</cod
  e>.Beta Feature: This report is available for testing purposes only. It may
  be changed before final release.

  Enums:
    StateValueValuesEnum: Required. The application state.

  Fields:
    name: Required. The application name.
    progress: Required. The numerical progress of the application, from 1 to
      100.
    state: Required. The application state.
    trackingUrl: Optional. The HTTP URL of the ApplicationMaster,
      HistoryServer, or TimelineServer that provides application-specific
      information. The URL uses the internal hostname, and requires a proxy
      server for resolution and, possibly, access.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Required. The application state.

    Values:
      STATE_UNSPECIFIED: Status is unspecified.
      NEW: Status is NEW.
      NEW_SAVING: Status is NEW_SAVING.
      SUBMITTED: Status is SUBMITTED.
      ACCEPTED: Status is ACCEPTED.
      RUNNING: Status is RUNNING.
      FINISHED: Status is FINISHED.
      FAILED: Status is FAILED.
      KILLED: Status is KILLED.
    """
    STATE_UNSPECIFIED = 0
    NEW = 1
    NEW_SAVING = 2
    SUBMITTED = 3
    ACCEPTED = 4
    RUNNING = 5
    FINISHED = 6
    FAILED = 7
    KILLED = 8

  name = _messages.StringField(1)
  progress = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  state = _messages.EnumField('StateValueValuesEnum', 3)
  trackingUrl = _messages.StringField(4)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
