"""Generated client library for securitycenter version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.securitycenter.v1 import securitycenter_v1_messages as messages


class SecuritycenterV1(base_api.BaseApiClient):
  """Generated client library for service securitycenter version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://securitycenter.googleapis.com/'
  MTLS_BASE_URL = 'https://securitycenter.mtls.googleapis.com/'

  _PACKAGE = 'securitycenter'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'SecuritycenterV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new securitycenter handle."""
    url = url or self.BASE_URL
    super(SecuritycenterV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.organizations_assets = self.OrganizationsAssetsService(self)
    self.organizations_notificationConfigs = self.OrganizationsNotificationConfigsService(self)
    self.organizations_operations = self.OrganizationsOperationsService(self)
    self.organizations_sources_findings = self.OrganizationsSourcesFindingsService(self)
    self.organizations_sources = self.OrganizationsSourcesService(self)
    self.organizations = self.OrganizationsService(self)

  class OrganizationsAssetsService(base_api.BaseApiService):
    """Service class for the organizations_assets resource."""

    _NAME = 'organizations_assets'

    def __init__(self, client):
      super(SecuritycenterV1.OrganizationsAssetsService, self).__init__(client)
      self._upload_configs = {
          }

    def Group(self, request, global_params=None):
      r"""Filters an organization's assets and  groups them by their specified.
properties.

      Args:
        request: (SecuritycenterOrganizationsAssetsGroupRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GroupAssetsResponse) The response message.
      """
      config = self.GetMethodConfig('Group')
      return self._RunMethod(
          config, request, global_params=global_params)

    Group.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/assets:group',
        http_method='POST',
        method_id='securitycenter.organizations.assets.group',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/assets:group',
        request_field='groupAssetsRequest',
        request_type_name='SecuritycenterOrganizationsAssetsGroupRequest',
        response_type_name='GroupAssetsResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists an organization's assets.

      Args:
        request: (SecuritycenterOrganizationsAssetsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAssetsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/assets',
        http_method='GET',
        method_id='securitycenter.organizations.assets.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['compareDuration', 'fieldMask', 'filter', 'orderBy', 'pageSize', 'pageToken', 'readTime'],
        relative_path='v1/{+parent}/assets',
        request_field='',
        request_type_name='SecuritycenterOrganizationsAssetsListRequest',
        response_type_name='ListAssetsResponse',
        supports_download=False,
    )

    def RunDiscovery(self, request, global_params=None):
      r"""Runs asset discovery. The discovery is tracked with a long-running.
operation.

This API can only be called with limited frequency for an organization. If
it is called too frequently the caller will receive a TOO_MANY_REQUESTS
error.

      Args:
        request: (SecuritycenterOrganizationsAssetsRunDiscoveryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RunDiscovery')
      return self._RunMethod(
          config, request, global_params=global_params)

    RunDiscovery.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/assets:runDiscovery',
        http_method='POST',
        method_id='securitycenter.organizations.assets.runDiscovery',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/assets:runDiscovery',
        request_field='runAssetDiscoveryRequest',
        request_type_name='SecuritycenterOrganizationsAssetsRunDiscoveryRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdateSecurityMarks(self, request, global_params=None):
      r"""Updates security marks.

      Args:
        request: (SecuritycenterOrganizationsAssetsUpdateSecurityMarksRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityMarks) The response message.
      """
      config = self.GetMethodConfig('UpdateSecurityMarks')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateSecurityMarks.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/assets/{assetsId}/securityMarks',
        http_method='PATCH',
        method_id='securitycenter.organizations.assets.updateSecurityMarks',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['startTime', 'updateMask'],
        relative_path='v1/{+name}',
        request_field='securityMarks',
        request_type_name='SecuritycenterOrganizationsAssetsUpdateSecurityMarksRequest',
        response_type_name='SecurityMarks',
        supports_download=False,
    )

  class OrganizationsNotificationConfigsService(base_api.BaseApiService):
    """Service class for the organizations_notificationConfigs resource."""

    _NAME = 'organizations_notificationConfigs'

    def __init__(self, client):
      super(SecuritycenterV1.OrganizationsNotificationConfigsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a notification config.

      Args:
        request: (SecuritycenterOrganizationsNotificationConfigsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NotificationConfig) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/notificationConfigs',
        http_method='POST',
        method_id='securitycenter.organizations.notificationConfigs.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['configId'],
        relative_path='v1/{+parent}/notificationConfigs',
        request_field='notificationConfig',
        request_type_name='SecuritycenterOrganizationsNotificationConfigsCreateRequest',
        response_type_name='NotificationConfig',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a notification config.

      Args:
        request: (SecuritycenterOrganizationsNotificationConfigsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/notificationConfigs/{notificationConfigsId}',
        http_method='DELETE',
        method_id='securitycenter.organizations.notificationConfigs.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SecuritycenterOrganizationsNotificationConfigsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a notification config.

      Args:
        request: (SecuritycenterOrganizationsNotificationConfigsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NotificationConfig) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/notificationConfigs/{notificationConfigsId}',
        http_method='GET',
        method_id='securitycenter.organizations.notificationConfigs.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SecuritycenterOrganizationsNotificationConfigsGetRequest',
        response_type_name='NotificationConfig',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists notification configs.

      Args:
        request: (SecuritycenterOrganizationsNotificationConfigsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNotificationConfigsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/notificationConfigs',
        http_method='GET',
        method_id='securitycenter.organizations.notificationConfigs.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/notificationConfigs',
        request_field='',
        request_type_name='SecuritycenterOrganizationsNotificationConfigsListRequest',
        response_type_name='ListNotificationConfigsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r""".
Updates a notification config.

      Args:
        request: (SecuritycenterOrganizationsNotificationConfigsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NotificationConfig) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/notificationConfigs/{notificationConfigsId}',
        http_method='PATCH',
        method_id='securitycenter.organizations.notificationConfigs.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='notificationConfig',
        request_type_name='SecuritycenterOrganizationsNotificationConfigsPatchRequest',
        response_type_name='NotificationConfig',
        supports_download=False,
    )

  class OrganizationsOperationsService(base_api.BaseApiService):
    """Service class for the organizations_operations resource."""

    _NAME = 'organizations_operations'

    def __init__(self, client):
      super(SecuritycenterV1.OrganizationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation.  The server.
makes a best effort to cancel the operation, but success is not
guaranteed.  If the server doesn't support this method, it returns
`google.rpc.Code.UNIMPLEMENTED`.  Clients can use
Operations.GetOperation or
other methods to check whether the cancellation succeeded or whether the
operation completed despite cancellation. On successful cancellation,
the operation is not deleted; instead, it becomes an operation with
an Operation.error value with a google.rpc.Status.code of 1,
corresponding to `Code.CANCELLED`.

      Args:
        request: (SecuritycenterOrganizationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='securitycenter.organizations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:cancel',
        request_field='',
        request_type_name='SecuritycenterOrganizationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is.
no longer interested in the operation result. It does not cancel the
operation. If the server doesn't support this method, it returns
`google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (SecuritycenterOrganizationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='securitycenter.organizations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SecuritycenterOrganizationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (SecuritycenterOrganizationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='securitycenter.organizations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SecuritycenterOrganizationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the.
server doesn't support this method, it returns `UNIMPLEMENTED`.

NOTE: the `name` binding allows API services to override the binding
to use different resource name schemes, such as `users/*/operations`. To
override the binding, API services can add a binding such as
`"/v1/{name=users/*}/operations"` to their service configuration.
For backwards compatibility, the default name includes the operations
collection id, however overriding users must ensure the name binding
is the parent resource, without the operations collection id.

      Args:
        request: (SecuritycenterOrganizationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/operations',
        http_method='GET',
        method_id='securitycenter.organizations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SecuritycenterOrganizationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class OrganizationsSourcesFindingsService(base_api.BaseApiService):
    """Service class for the organizations_sources_findings resource."""

    _NAME = 'organizations_sources_findings'

    def __init__(self, client):
      super(SecuritycenterV1.OrganizationsSourcesFindingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a finding. The corresponding source must exist for finding creation.
to succeed.

      Args:
        request: (SecuritycenterOrganizationsSourcesFindingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Finding) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sources/{sourcesId}/findings',
        http_method='POST',
        method_id='securitycenter.organizations.sources.findings.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['findingId'],
        relative_path='v1/{+parent}/findings',
        request_field='finding',
        request_type_name='SecuritycenterOrganizationsSourcesFindingsCreateRequest',
        response_type_name='Finding',
        supports_download=False,
    )

    def Group(self, request, global_params=None):
      r"""Filters an organization or source's findings and  groups them by their.
specified properties.

To group across all sources provide a `-` as the source id.
Example: /v1/organizations/{organization_id}/sources/-/findings

      Args:
        request: (SecuritycenterOrganizationsSourcesFindingsGroupRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GroupFindingsResponse) The response message.
      """
      config = self.GetMethodConfig('Group')
      return self._RunMethod(
          config, request, global_params=global_params)

    Group.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sources/{sourcesId}/findings:group',
        http_method='POST',
        method_id='securitycenter.organizations.sources.findings.group',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/findings:group',
        request_field='groupFindingsRequest',
        request_type_name='SecuritycenterOrganizationsSourcesFindingsGroupRequest',
        response_type_name='GroupFindingsResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists an organization or source's findings.

To list across all sources provide a `-` as the source id.
Example: /v1/organizations/{organization_id}/sources/-/findings

      Args:
        request: (SecuritycenterOrganizationsSourcesFindingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFindingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sources/{sourcesId}/findings',
        http_method='GET',
        method_id='securitycenter.organizations.sources.findings.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['compareDuration', 'fieldMask', 'filter', 'orderBy', 'pageSize', 'pageToken', 'readTime'],
        relative_path='v1/{+parent}/findings',
        request_field='',
        request_type_name='SecuritycenterOrganizationsSourcesFindingsListRequest',
        response_type_name='ListFindingsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Creates or updates a finding. The corresponding source must exist for a.
finding creation to succeed.

      Args:
        request: (SecuritycenterOrganizationsSourcesFindingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Finding) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sources/{sourcesId}/findings/{findingsId}',
        http_method='PATCH',
        method_id='securitycenter.organizations.sources.findings.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='finding',
        request_type_name='SecuritycenterOrganizationsSourcesFindingsPatchRequest',
        response_type_name='Finding',
        supports_download=False,
    )

    def SetState(self, request, global_params=None):
      r"""Updates the state of a finding.

      Args:
        request: (SecuritycenterOrganizationsSourcesFindingsSetStateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Finding) The response message.
      """
      config = self.GetMethodConfig('SetState')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetState.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sources/{sourcesId}/findings/{findingsId}:setState',
        http_method='POST',
        method_id='securitycenter.organizations.sources.findings.setState',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:setState',
        request_field='setFindingStateRequest',
        request_type_name='SecuritycenterOrganizationsSourcesFindingsSetStateRequest',
        response_type_name='Finding',
        supports_download=False,
    )

    def UpdateSecurityMarks(self, request, global_params=None):
      r"""Updates security marks.

      Args:
        request: (SecuritycenterOrganizationsSourcesFindingsUpdateSecurityMarksRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityMarks) The response message.
      """
      config = self.GetMethodConfig('UpdateSecurityMarks')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateSecurityMarks.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sources/{sourcesId}/findings/{findingsId}/securityMarks',
        http_method='PATCH',
        method_id='securitycenter.organizations.sources.findings.updateSecurityMarks',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['startTime', 'updateMask'],
        relative_path='v1/{+name}',
        request_field='securityMarks',
        request_type_name='SecuritycenterOrganizationsSourcesFindingsUpdateSecurityMarksRequest',
        response_type_name='SecurityMarks',
        supports_download=False,
    )

  class OrganizationsSourcesService(base_api.BaseApiService):
    """Service class for the organizations_sources resource."""

    _NAME = 'organizations_sources'

    def __init__(self, client):
      super(SecuritycenterV1.OrganizationsSourcesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a source.

      Args:
        request: (SecuritycenterOrganizationsSourcesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Source) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sources',
        http_method='POST',
        method_id='securitycenter.organizations.sources.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/sources',
        request_field='source',
        request_type_name='SecuritycenterOrganizationsSourcesCreateRequest',
        response_type_name='Source',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a source.

      Args:
        request: (SecuritycenterOrganizationsSourcesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Source) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sources/{sourcesId}',
        http_method='GET',
        method_id='securitycenter.organizations.sources.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SecuritycenterOrganizationsSourcesGetRequest',
        response_type_name='Source',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy on the specified Source.

      Args:
        request: (SecuritycenterOrganizationsSourcesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sources/{sourcesId}:getIamPolicy',
        http_method='POST',
        method_id='securitycenter.organizations.sources.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='SecuritycenterOrganizationsSourcesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all sources belonging to an organization.

      Args:
        request: (SecuritycenterOrganizationsSourcesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sources',
        http_method='GET',
        method_id='securitycenter.organizations.sources.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/sources',
        request_field='',
        request_type_name='SecuritycenterOrganizationsSourcesListRequest',
        response_type_name='ListSourcesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a source.

      Args:
        request: (SecuritycenterOrganizationsSourcesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Source) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sources/{sourcesId}',
        http_method='PATCH',
        method_id='securitycenter.organizations.sources.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='source',
        request_type_name='SecuritycenterOrganizationsSourcesPatchRequest',
        response_type_name='Source',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified Source.

      Args:
        request: (SecuritycenterOrganizationsSourcesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sources/{sourcesId}:setIamPolicy',
        http_method='POST',
        method_id='securitycenter.organizations.sources.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='SecuritycenterOrganizationsSourcesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns the permissions that a caller has on the specified source.

      Args:
        request: (SecuritycenterOrganizationsSourcesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sources/{sourcesId}:testIamPermissions',
        http_method='POST',
        method_id='securitycenter.organizations.sources.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='SecuritycenterOrganizationsSourcesTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class OrganizationsService(base_api.BaseApiService):
    """Service class for the organizations resource."""

    _NAME = 'organizations'

    def __init__(self, client):
      super(SecuritycenterV1.OrganizationsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetOrganizationSettings(self, request, global_params=None):
      r"""Gets the settings for an organization.

      Args:
        request: (SecuritycenterOrganizationsGetOrganizationSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrganizationSettings) The response message.
      """
      config = self.GetMethodConfig('GetOrganizationSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetOrganizationSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/organizationSettings',
        http_method='GET',
        method_id='securitycenter.organizations.getOrganizationSettings',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='SecuritycenterOrganizationsGetOrganizationSettingsRequest',
        response_type_name='OrganizationSettings',
        supports_download=False,
    )

    def UpdateOrganizationSettings(self, request, global_params=None):
      r"""Updates an organization's settings.

      Args:
        request: (SecuritycenterOrganizationsUpdateOrganizationSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrganizationSettings) The response message.
      """
      config = self.GetMethodConfig('UpdateOrganizationSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateOrganizationSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/organizationSettings',
        http_method='PATCH',
        method_id='securitycenter.organizations.updateOrganizationSettings',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='organizationSettings',
        request_type_name='SecuritycenterOrganizationsUpdateOrganizationSettingsRequest',
        response_type_name='OrganizationSettings',
        supports_download=False,
    )
