"""Generated client library for domains version v1alpha2."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.domains.v1alpha2 import domains_v1alpha2_messages as messages


class DomainsV1alpha2(base_api.BaseApiClient):
  """Generated client library for service domains version v1alpha2."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://domains.googleapis.com/'
  MTLS_BASE_URL = u'https://domains.mtls.googleapis.com/'

  _PACKAGE = u'domains'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1alpha2'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = u'google-cloud-sdk'
  _CLIENT_CLASS_NAME = u'DomainsV1alpha2'
  _URL_VERSION = u'v1alpha2'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new domains handle."""
    url = url or self.BASE_URL
    super(DomainsV1alpha2, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_registrations = self.ProjectsLocationsRegistrationsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = u'projects_locations_operations'

    def __init__(self, client):
      super(DomainsV1alpha2.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (DomainsProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method=u'GET',
        method_id=u'domains.projects.locations.operations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'DomainsProjectsLocationsOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the.
server doesn't support this method, it returns `UNIMPLEMENTED`.

NOTE: the `name` binding allows API services to override the binding
to use different resource name schemes, such as `users/*/operations`. To
override the binding, API services can add a binding such as
`"/v1/{name=users/*}/operations"` to their service configuration.
For backwards compatibility, the default name includes the operations
collection id, however overriding users must ensure the name binding
is the parent resource, without the operations collection id.

      Args:
        request: (DomainsProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/operations',
        http_method=u'GET',
        method_id=u'domains.projects.locations.operations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+name}/operations',
        request_field='',
        request_type_name=u'DomainsProjectsLocationsOperationsListRequest',
        response_type_name=u'ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsRegistrationsService(base_api.BaseApiService):
    """Service class for the projects_locations_registrations resource."""

    _NAME = u'projects_locations_registrations'

    def __init__(self, client):
      super(DomainsV1alpha2.ProjectsLocationsRegistrationsService, self).__init__(client)
      self._upload_configs = {
          }

    def ConfigureContactSettings(self, request, global_params=None):
      r"""Updates Registration's contact settings. In some cases this change will.
have to be confirmed using an email sent to the registrant. In order to
resend the email, call this method again.

      Args:
        request: (DomainsProjectsLocationsRegistrationsConfigureContactSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ConfigureContactSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    ConfigureContactSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/registrations/{registrationsId}:configureContactSettings',
        http_method=u'POST',
        method_id=u'domains.projects.locations.registrations.configureContactSettings',
        ordered_params=[u'registration'],
        path_params=[u'registration'],
        query_params=[],
        relative_path=u'v1alpha2/{+registration}:configureContactSettings',
        request_field=u'configureContactSettingsRequest',
        request_type_name=u'DomainsProjectsLocationsRegistrationsConfigureContactSettingsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def ConfigureDnsSettings(self, request, global_params=None):
      r"""Updates Registration's DNS settings.

      Args:
        request: (DomainsProjectsLocationsRegistrationsConfigureDnsSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ConfigureDnsSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    ConfigureDnsSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/registrations/{registrationsId}:configureDnsSettings',
        http_method=u'POST',
        method_id=u'domains.projects.locations.registrations.configureDnsSettings',
        ordered_params=[u'registration'],
        path_params=[u'registration'],
        query_params=[],
        relative_path=u'v1alpha2/{+registration}:configureDnsSettings',
        request_field=u'configureDnsSettingsRequest',
        request_type_name=u'DomainsProjectsLocationsRegistrationsConfigureDnsSettingsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def ConfigureManagementSettings(self, request, global_params=None):
      r"""Updates Registration's management settings.

      Args:
        request: (DomainsProjectsLocationsRegistrationsConfigureManagementSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ConfigureManagementSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    ConfigureManagementSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/registrations/{registrationsId}:configureManagementSettings',
        http_method=u'POST',
        method_id=u'domains.projects.locations.registrations.configureManagementSettings',
        ordered_params=[u'registration'],
        path_params=[u'registration'],
        query_params=[],
        relative_path=u'v1alpha2/{+registration}:configureManagementSettings',
        request_field=u'configureManagementSettingsRequest',
        request_type_name=u'DomainsProjectsLocationsRegistrationsConfigureManagementSettingsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Registration.
Can only be called on Registrations in state EXPORTED with expire_time
in the past. It also works for Registrations in state REGISTRATION_FAILED.

      Args:
        request: (DomainsProjectsLocationsRegistrationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/registrations/{registrationsId}',
        http_method=u'DELETE',
        method_id=u'domains.projects.locations.registrations.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'DomainsProjectsLocationsRegistrationsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Export(self, request, global_params=None):
      r"""Export a Registration to Google Domains direct management. After calling.
this method, the resource will be in state EXPORTED. Permissions to the
domain will be managed in Google Domains instead of Cloud IAM and the
calling user will become the sole owner. Also the automatic renewal will
turn off.

      Args:
        request: (DomainsProjectsLocationsRegistrationsExportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Export')
      return self._RunMethod(
          config, request, global_params=global_params)

    Export.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/registrations/{registrationsId}:export',
        http_method=u'POST',
        method_id=u'domains.projects.locations.registrations.export',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:export',
        request_field=u'exportRegistrationRequest',
        request_type_name=u'DomainsProjectsLocationsRegistrationsExportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Registration.

      Args:
        request: (DomainsProjectsLocationsRegistrationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Registration) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/registrations/{registrationsId}',
        http_method=u'GET',
        method_id=u'domains.projects.locations.registrations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'DomainsProjectsLocationsRegistrationsGetRequest',
        response_type_name=u'Registration',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (DomainsProjectsLocationsRegistrationsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/registrations/{registrationsId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'domains.projects.locations.registrations.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1alpha2/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'DomainsProjectsLocationsRegistrationsGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Registrations in a given project.

      Args:
        request: (DomainsProjectsLocationsRegistrationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRegistrationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/registrations',
        http_method=u'GET',
        method_id=u'domains.projects.locations.registrations.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/registrations',
        request_field='',
        request_type_name=u'DomainsProjectsLocationsRegistrationsListRequest',
        response_type_name=u'ListRegistrationsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the Registration. Currently used for updating Labels only. Use.
custom configure methods to change management, DNS or contact settings.

      Args:
        request: (DomainsProjectsLocationsRegistrationsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/registrations/{registrationsId}',
        http_method=u'PATCH',
        method_id=u'domains.projects.locations.registrations.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'registration',
        request_type_name=u'DomainsProjectsLocationsRegistrationsPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Register(self, request, global_params=None):
      r"""Registers a new domain name. Call RetrieveRegisterParameters first to check.
availability of the domain name and determine parameters like price.

      Args:
        request: (DomainsProjectsLocationsRegistrationsRegisterRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Register')
      return self._RunMethod(
          config, request, global_params=global_params)

    Register.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/registrations:register',
        http_method=u'POST',
        method_id=u'domains.projects.locations.registrations.register',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/registrations:register',
        request_field=u'registerDomainRequest',
        request_type_name=u'DomainsProjectsLocationsRegistrationsRegisterRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def ResetAuthorizationCode(self, request, global_params=None):
      r"""Resets the Authorization Code of the registration.
Can only be called after 60 days have elapsed since initial registration.

      Args:
        request: (DomainsProjectsLocationsRegistrationsResetAuthorizationCodeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AuthorizationCode) The response message.
      """
      config = self.GetMethodConfig('ResetAuthorizationCode')
      return self._RunMethod(
          config, request, global_params=global_params)

    ResetAuthorizationCode.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/registrations/{registrationsId}:resetAuthorizationCode',
        http_method=u'POST',
        method_id=u'domains.projects.locations.registrations.resetAuthorizationCode',
        ordered_params=[u'registration'],
        path_params=[u'registration'],
        query_params=[],
        relative_path=u'v1alpha2/{+registration}:resetAuthorizationCode',
        request_field=u'resetAuthorizationCodeRequest',
        request_type_name=u'DomainsProjectsLocationsRegistrationsResetAuthorizationCodeRequest',
        response_type_name=u'AuthorizationCode',
        supports_download=False,
    )

    def RetrieveAuthorizationCode(self, request, global_params=None):
      r"""Gets Authorization Code of the Registration.
Can only be called after 60 days have elapsed since initial registration.

      Args:
        request: (DomainsProjectsLocationsRegistrationsRetrieveAuthorizationCodeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AuthorizationCode) The response message.
      """
      config = self.GetMethodConfig('RetrieveAuthorizationCode')
      return self._RunMethod(
          config, request, global_params=global_params)

    RetrieveAuthorizationCode.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/registrations/{registrationsId}:retrieveAuthorizationCode',
        http_method=u'GET',
        method_id=u'domains.projects.locations.registrations.retrieveAuthorizationCode',
        ordered_params=[u'registration'],
        path_params=[u'registration'],
        query_params=[],
        relative_path=u'v1alpha2/{+registration}:retrieveAuthorizationCode',
        request_field='',
        request_type_name=u'DomainsProjectsLocationsRegistrationsRetrieveAuthorizationCodeRequest',
        response_type_name=u'AuthorizationCode',
        supports_download=False,
    )

    def RetrieveRegisterParameters(self, request, global_params=None):
      r"""Gets parameters needed to register a domain name, including price and.
availability. Some of these values are needed to pass to RegisterDomain.
This method uses fresh information from the registry.

      Args:
        request: (DomainsProjectsLocationsRegistrationsRetrieveRegisterParametersRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RetrieveRegisterParametersResponse) The response message.
      """
      config = self.GetMethodConfig('RetrieveRegisterParameters')
      return self._RunMethod(
          config, request, global_params=global_params)

    RetrieveRegisterParameters.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/registrations:retrieveRegisterParameters',
        http_method=u'GET',
        method_id=u'domains.projects.locations.registrations.retrieveRegisterParameters',
        ordered_params=[u'location'],
        path_params=[u'location'],
        query_params=[u'domainName'],
        relative_path=u'v1alpha2/{+location}/registrations:retrieveRegisterParameters',
        request_field='',
        request_type_name=u'DomainsProjectsLocationsRegistrationsRetrieveRegisterParametersRequest',
        response_type_name=u'RetrieveRegisterParametersResponse',
        supports_download=False,
    )

    def SearchDomains(self, request, global_params=None):
      r"""Searches available domains similar to the given query.
Returned domain availability allows some staleness.

      Args:
        request: (DomainsProjectsLocationsRegistrationsSearchDomainsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchDomainsResponse) The response message.
      """
      config = self.GetMethodConfig('SearchDomains')
      return self._RunMethod(
          config, request, global_params=global_params)

    SearchDomains.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/registrations:searchDomains',
        http_method=u'GET',
        method_id=u'domains.projects.locations.registrations.searchDomains',
        ordered_params=[u'location'],
        path_params=[u'location'],
        query_params=[u'query'],
        relative_path=u'v1alpha2/{+location}/registrations:searchDomains',
        request_field='',
        request_type_name=u'DomainsProjectsLocationsRegistrationsSearchDomainsRequest',
        response_type_name=u'SearchDomainsResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (DomainsProjectsLocationsRegistrationsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/registrations/{registrationsId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'domains.projects.locations.registrations.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'DomainsProjectsLocationsRegistrationsSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a `NOT_FOUND` error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (DomainsProjectsLocationsRegistrationsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/registrations/{registrationsId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'domains.projects.locations.registrations.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'DomainsProjectsLocationsRegistrationsTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(DomainsV1alpha2.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (DomainsProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}',
        http_method=u'GET',
        method_id=u'domains.projects.locations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'DomainsProjectsLocationsGetRequest',
        response_type_name=u'Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (DomainsProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations',
        http_method=u'GET',
        method_id=u'domains.projects.locations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'includeUnrevealedLocations', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+name}/locations',
        request_field='',
        request_type_name=u'DomainsProjectsLocationsListRequest',
        response_type_name=u'ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(DomainsV1alpha2.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
