"""Generated message classes for managedidentities version v1beta1.

The Managed Service for Microsoft Active Directory API is used for managing a
highly available, hardened service running Microsoft Active Directory (AD).
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'managedidentities'


class AttachTrustRequest(_messages.Message):
  r"""Request message for AttachTrust

  Fields:
    trust: Required. The domain trust resource.
  """

  trust = _messages.MessageField('Trust', 1)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. NOTE: An
      unsatisfied condition will not allow user access via current binding.
      Different bindings, including their conditions, are examined
      independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example,
      `alice@example.com` .   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.  *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding.  *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus    unique identifier) representing a service account that has been
      recently    deleted. For example,    `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`.    If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding.  * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique    identifier) representing a Google group
      that has been recently    deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If    the group is
      recovered, this value reverts to `group:{emailid}` and the    recovered
      group retains the role in the binding.   * `domain:{domain}`: The G
      Suite domain (primary) that represents all the    users of that domain.
      For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class DetachTrustRequest(_messages.Message):
  r"""Request message for DetachTrust

  Fields:
    trust: Required. The domain trust resource to removed.
  """

  trust = _messages.MessageField('Trust', 1)


class Domain(_messages.Message):
  r"""Represents a managed Microsoft Active Directory domain.

  Enums:
    StateValueValuesEnum: Output only. The current state of this domain.

  Messages:
    LabelsValue: Optional. Resource labels that can contain user-provided
      metadata.

  Fields:
    admin: Optional. The name of delegated administrator account used to
      perform Active Directory operations. If not specified, `setupadmin` will
      be used.
    authorizedNetworks: Optional. The full names of the Google Compute Engine
      [networks](/compute/docs/networks-and-firewalls#networks) the domain
      instance is connected to. Networks can be added using UpdateDomain. The
      domain is only available on networks listed in `authorized_networks`. If
      CIDR subnets overlap between networks, domain creation will fail.
    createTime: Output only. The time the instance was created.
    fqdn: Output only. The fully-qualified domain name of the exposed domain
      used by clients to connect to the service. Similar to what would be
      chosen for an Active Directory set up on an internal network.
    labels: Optional. Resource labels that can contain user-provided metadata.
    locations: Required. Locations where domain needs to be provisioned.
      regions e.g. us-west1 or us-east4 Service supports up to 4 locations at
      once. Each location will use a /26 block.
    name: Output only. The unique name of the domain using the form:
      `projects/{project_id}/locations/global/domains/{domain_name}`.
    reservedIpRange: Required. The CIDR range of internal addresses that are
      reserved for this domain. Reserved networks must be /24 or larger.
      Ranges must be unique and non-overlapping with existing subnets in
      [Domain].[authorized_networks].
    state: Output only. The current state of this domain.
    statusMessage: Output only. Additional information about the current
      status of this domain, if available.
    trusts: Output only. The current trusts associated with the domain.
    updateTime: Output only. The last update time.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of this domain.

    Values:
      STATE_UNSPECIFIED: Not set.
      CREATING: The domain is being created.
      READY: The domain has been created and is fully usable.
      UPDATING: The domain's configuration is being updated.
      DELETING: The domain is being deleted.
      REPAIRING: The domain is being repaired and may be unusable. Details can
        be found in the `status_message` field.
      PERFORMING_MAINTENANCE: The domain is undergoing maintenance.
      UNAVAILABLE: The domain is not serving requests.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    UPDATING = 3
    DELETING = 4
    REPAIRING = 5
    PERFORMING_MAINTENANCE = 6
    UNAVAILABLE = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Resource labels that can contain user-provided metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  admin = _messages.StringField(1)
  authorizedNetworks = _messages.StringField(2, repeated=True)
  createTime = _messages.StringField(3)
  fqdn = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  locations = _messages.StringField(6, repeated=True)
  name = _messages.StringField(7)
  reservedIpRange = _messages.StringField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  statusMessage = _messages.StringField(10)
  trusts = _messages.MessageField('Trust', 11, repeated=True)
  updateTime = _messages.StringField(12)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec.  Example (Comparison):
  title: "Summary size limit"     description: "Determines if a summary is
  less than 100 chars"     expression: "document.summary.size() < 100"
  Example (Equality):      title: "Requestor is owner"     description:
  "Determines if requestor is the document owner"     expression:
  "document.owner == request.auth.claims.email"  Example (Logic):      title:
  "Public documents"     description: "Determine whether the document should
  be publicly visible"     expression: "document.type != 'private' &&
  document.type != 'internal'"  Example (Data Manipulation):      title:
  "Notification string"     description: "Create a notification string with a
  timestamp."     expression: "'New message received at ' +
  string(document.create_time)"  The exact variables and functions that may be
  referenced within an expression are determined by the service that evaluates
  it. See the service documentation for additional information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GoogleCloudManagedidentitiesV1OpMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  target = _messages.StringField(5)
  verb = _messages.StringField(6)


class GoogleCloudManagedidentitiesV1alpha1OpMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  target = _messages.StringField(5)
  verb = _messages.StringField(6)


class GoogleCloudManagedidentitiesV1beta1OpMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  target = _messages.StringField(5)
  verb = _messages.StringField(6)


class GoogleCloudSaasacceleratorManagementProvidersV1Instance(_messages.Message):
  r"""A GoogleCloudSaasacceleratorManagementProvidersV1Instance object.

  Enums:
    StateValueValuesEnum: Output only. Current lifecycle state of the resource
      (e.g. if it's being created or ready to use).

  Messages:
    LabelsValue: Optional. Resource labels to represent user provided
      metadata. Each label is a key-value pair, where both the key and the
      value are arbitrary strings provided by the user.
    MaintenancePolicyNamesValue: The MaintenancePolicies that have been
      attached to the instance. The key must be of the type name of the oneof
      policy name defined in MaintenancePolicy, and the referenced policy must
      define the same policy type. For complete details of MaintenancePolicy,
      please refer to go/cloud-saas-mw-ug.
    MaintenanceSchedulesValue: The MaintenanceSchedule contains the scheduling
      information of published maintenance schedule.
    ProducerMetadataValue: Output only. Custom string attributes used
      primarily to expose producer-specific information in monitoring
      dashboards. See go/get-instance-metadata.
    SoftwareVersionsValue: Software versions that are used to deploy this
      instance. This can be mutated by rollout services.

  Fields:
    consumerDefinedName: consumer_defined_name is the name that is set by the
      consumer. On the other hand Name field represents system-assigned id of
      an instance so consumers are not necessarily aware of it.
      consumer_defined_name is used for notification/UI purposes for consumer
      to recognize their instances.
    createTime: Output only. Timestamp when the resource was created.
    labels: Optional. Resource labels to represent user provided metadata.
      Each label is a key-value pair, where both the key and the value are
      arbitrary strings provided by the user.
    maintenancePolicyNames: The MaintenancePolicies that have been attached to
      the instance. The key must be of the type name of the oneof policy name
      defined in MaintenancePolicy, and the referenced policy must define the
      same policy type. For complete details of MaintenancePolicy, please
      refer to go/cloud-saas-mw-ug.
    maintenanceSchedules: The MaintenanceSchedule contains the scheduling
      information of published maintenance schedule.
    name: Unique name of the resource. It uses the form:
      `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
    producerMetadata: Output only. Custom string attributes used primarily to
      expose producer-specific information in monitoring dashboards. See go
      /get-instance-metadata.
    provisionedResources: Output only. The list of data plane resources
      provisioned for this instance, e.g. compute VMs. See go/get-instance-
      metadata.
    slmInstanceTemplate: Link to the SLM instance template. Only populated
      when updating SLM instances via SSA's Actuation service adaptor. Service
      producers with custom control plane (e.g. Cloud SQL) doesn't need to
      populate this field. Instead they should use software_versions.
    sloMetadata: Output only. SLO metadata for instance classification in the
      Standardized dataplane SLO platform. See go/cloud-ssa-standard-slo for
      feature description.
    softwareVersions: Software versions that are used to deploy this instance.
      This can be mutated by rollout services.
    state: Output only. Current lifecycle state of the resource (e.g. if it's
      being created or ready to use).
    tenantProjectId: Output only. ID of the associated GCP tenant project. See
      go/get-instance-metadata.
    updateTime: Output only. Timestamp when the resource was last modified.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current lifecycle state of the resource (e.g. if it's
    being created or ready to use).

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      CREATING: Instance is being created.
      READY: Instance has been created and is ready to use.
      UPDATING: Instance is being updated.
      REPAIRING: Instance is unheathy and under repair.
      DELETING: Instance is being deleted.
      ERROR: Instance encountered an error and is in indeterministic state.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    UPDATING = 3
    REPAIRING = 4
    DELETING = 5
    ERROR = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Resource labels to represent user provided metadata. Each
    label is a key-value pair, where both the key and the value are arbitrary
    strings provided by the user.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MaintenancePolicyNamesValue(_messages.Message):
    r"""The MaintenancePolicies that have been attached to the instance. The
    key must be of the type name of the oneof policy name defined in
    MaintenancePolicy, and the referenced policy must define the same policy
    type. For complete details of MaintenancePolicy, please refer to go/cloud-
    saas-mw-ug.

    Messages:
      AdditionalProperty: An additional property for a
        MaintenancePolicyNamesValue object.

    Fields:
      additionalProperties: Additional properties of type
        MaintenancePolicyNamesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MaintenancePolicyNamesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MaintenanceSchedulesValue(_messages.Message):
    r"""The MaintenanceSchedule contains the scheduling information of
    published maintenance schedule.

    Messages:
      AdditionalProperty: An additional property for a
        MaintenanceSchedulesValue object.

    Fields:
      additionalProperties: Additional properties of type
        MaintenanceSchedulesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MaintenanceSchedulesValue object.

      Fields:
        key: Name of the additional property.
        value: A
          GoogleCloudSaasacceleratorManagementProvidersV1MaintenanceSchedule
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1MaintenanceSchedule', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ProducerMetadataValue(_messages.Message):
    r"""Output only. Custom string attributes used primarily to expose
    producer-specific information in monitoring dashboards. See go/get-
    instance-metadata.

    Messages:
      AdditionalProperty: An additional property for a ProducerMetadataValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        ProducerMetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ProducerMetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SoftwareVersionsValue(_messages.Message):
    r"""Software versions that are used to deploy this instance. This can be
    mutated by rollout services.

    Messages:
      AdditionalProperty: An additional property for a SoftwareVersionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        SoftwareVersionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SoftwareVersionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  consumerDefinedName = _messages.StringField(1)
  createTime = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  maintenancePolicyNames = _messages.MessageField('MaintenancePolicyNamesValue', 4)
  maintenanceSchedules = _messages.MessageField('MaintenanceSchedulesValue', 5)
  name = _messages.StringField(6)
  producerMetadata = _messages.MessageField('ProducerMetadataValue', 7)
  provisionedResources = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1ProvisionedResource', 8, repeated=True)
  slmInstanceTemplate = _messages.StringField(9)
  sloMetadata = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1SloMetadata', 10)
  softwareVersions = _messages.MessageField('SoftwareVersionsValue', 11)
  state = _messages.EnumField('StateValueValuesEnum', 12)
  tenantProjectId = _messages.StringField(13)
  updateTime = _messages.StringField(14)


class GoogleCloudSaasacceleratorManagementProvidersV1MaintenanceSchedule(_messages.Message):
  r"""Maintenance schedule which is exposed to customer and potentially end
  user, indicating published upcoming future maintenance schedule

  Fields:
    canReschedule: Can this scheduled update be rescheduled? By default, it's
      true and API needs to do explicitly check whether it's set, if it's set
      as false explicitly, it's false
    endTime: The scheduled end time for the maintenance.
    rolloutManagementPolicy: The rollout management policy this maintenance
      schedule is associated with. When doing reschedule update request, the
      reschedule should be against this given policy.
    startTime: The scheduled start time for the maintenance.
  """

  canReschedule = _messages.BooleanField(1)
  endTime = _messages.StringField(2)
  rolloutManagementPolicy = _messages.StringField(3)
  startTime = _messages.StringField(4)


class GoogleCloudSaasacceleratorManagementProvidersV1NodeSloMetadata(_messages.Message):
  r"""Node information for custom per-node SLO implementations. SSA does not
  support per-node SLO, but producers can populate per-node information in
  SloMetadata for custom precomputations. SSA Eligibility Exporter will emit
  per-node metric based on this information.

  Fields:
    exclusions: By default node is eligible if instance is eligible. But
      individual node might be excluded from SLO by adding entry here. For
      semantic see SloMetadata.exclusions. If both instance and node level
      exclusions are present for time period, the node level's reason will be
      reported by Eligibility Exporter.
    location: The location of the node, if different from instance location.
    nodeId: The id of the node. This should be equal to
      SaasInstanceNode.node_id.
  """

  exclusions = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1SloExclusion', 1, repeated=True)
  location = _messages.StringField(2)
  nodeId = _messages.StringField(3)


class GoogleCloudSaasacceleratorManagementProvidersV1ProvisionedResource(_messages.Message):
  r"""Describes provisioned dataplane resources.

  Fields:
    resourceType: Type of the resource. This can be either a GCP resource or a
      custom one (e.g. another cloud provider's VM). For GCP compute resources
      use singular form of the names listed in GCP compute API documentation
      (https://cloud.google.com/compute/docs/reference/rest/v1/), prefixed
      with 'compute-', for example: 'compute-instance', 'compute-disk',
      'compute-autoscaler'.
    resourceUrl: URL identifying the resource, e.g.
      "https://www.googleapis.com/compute/v1/projects/...)".
  """

  resourceType = _messages.StringField(1)
  resourceUrl = _messages.StringField(2)


class GoogleCloudSaasacceleratorManagementProvidersV1SloEligibility(_messages.Message):
  r"""SloEligibility is a tuple containing eligibility value: true if an
  instance is eligible for SLO calculation or false if it should be excluded
  from all SLO-related calculations along with a user-defined reason.

  Fields:
    eligible: Whether an instance is eligible or ineligible.
    reason: User-defined reason for the current value of instance eligibility.
      Usually, this can be directly mapped to the internal state. An empty
      reason is allowed.
  """

  eligible = _messages.BooleanField(1)
  reason = _messages.StringField(2)


class GoogleCloudSaasacceleratorManagementProvidersV1SloExclusion(_messages.Message):
  r"""SloExclusion represents an exclusion in SLI calculation applies to all
  SLOs.

  Fields:
    duration: Exclusion duration. No restrictions on the possible values.
      When an ongoing operation is taking longer than initially expected, an
      existing entry in the exclusion list can be updated by extending the
      duration. This is supported by the subsystem exporting eligibility data
      as long as such extension is committed at least 10 minutes before the
      original exclusion expiration - otherwise it is possible that there will
      be "gaps" in the exclusion application in the exported timeseries.
    reason: Human-readable reason for the exclusion. This should be a static
      string (e.g. "Disruptive update in progress") and should not contain
      dynamically generated data (e.g. instance name). Can be left empty.
    sliName: Name of an SLI that this exclusion applies to. Can be left empty,
      signaling that the instance should be excluded from all SLIs defined in
      the service SLO configuration.
    startTime: Start time of the exclusion. No alignment (e.g. to a full
      minute) needed.
  """

  duration = _messages.StringField(1)
  reason = _messages.StringField(2)
  sliName = _messages.StringField(3)
  startTime = _messages.StringField(4)


class GoogleCloudSaasacceleratorManagementProvidersV1SloMetadata(_messages.Message):
  r"""SloMetadata contains resources required for proper SLO classification of
  the instance.

  Fields:
    eligibility: Optional. User-defined instance eligibility.
    exclusions: List of SLO exclusion windows. When multiple entries in the
      list match (matching the exclusion time-window against current time
      point) the exclusion reason used in the first matching entry will be
      published.  It is not needed to include expired exclusion in this list,
      as only the currently applicable exclusions are taken into account by
      the eligibility exporting subsystem (the historical state of exclusions
      will be reflected in the historically produced timeseries regardless of
      the current state).  This field can be used to mark the instance as
      temporary ineligible for the purpose of SLO calculation. For permanent
      instance SLO exclusion, use of custom instance eligibility is
      recommended. See 'eligibility' field below.
    nodes: Optional. List of nodes. Some producers need to use per-node
      metadata to calculate SLO. This field allows such producers to publish
      per-node SLO meta data, which will be consumed by SSA Eligibility
      Exporter and published in the form of per node metric to Monarch.
    tier: Name of the SLO tier the Instance belongs to. This name will be
      expected to match the tiers specified in the service SLO configuration.
      Field is mandatory and must not be empty.
  """

  eligibility = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1SloEligibility', 1)
  exclusions = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1SloExclusion', 2, repeated=True)
  nodes = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1NodeSloMetadata', 3, repeated=True)
  tier = _messages.StringField(4)


class ListDomainsResponse(_messages.Message):
  r"""Response message for ListDomains

  Fields:
    domains: A list of Managed Identities Service domains in the project.
    nextPageToken: A token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachable: A list of locations that could not be reached.
  """

  domains = _messages.MessageField('Domain', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class ManagedidentitiesProjectsLocationsGetRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsAttachTrustRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsAttachTrustRequest
  object.

  Fields:
    attachTrustRequest: A AttachTrustRequest resource to be passed as the
      request body.
    name: Required. The resource domain name, project name and location using
      the form: `projects/{project_id}/locations/global/domains/{domain_name}`
  """

  attachTrustRequest = _messages.MessageField('AttachTrustRequest', 1)
  name = _messages.StringField(2, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsCreateRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsCreateRequest object.

  Fields:
    domain: A Domain resource to be passed as the request body.
    domainName: Required. A domain name, e.g. mydomain.myorg.com, with the
      following restrictions:  * Must contain only lowercase letters, numbers,
      periods and hyphens.  * Must start with a letter.  * Must contain
      between 2-64 characters.  * Must end with a number or a letter.  * Must
      not start with period.  * First segement length (mydomain form example
      above) shouldn't exceed    15 chars.  * The last segment cannot be fully
      numeric.  * Must be unique within the customer project.
    parent: Required. The resource project name and location using the form:
      `projects/{project_id}/locations/global`
  """

  domain = _messages.MessageField('Domain', 1)
  domainName = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsDeleteRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsDeleteRequest object.

  Fields:
    name: Required. The domain resource name using the form:
      `projects/{project_id}/locations/global/domains/{domain_name}`
  """

  name = _messages.StringField(1, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsDetachTrustRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsDetachTrustRequest
  object.

  Fields:
    detachTrustRequest: A DetachTrustRequest resource to be passed as the
      request body.
    name: Required. The resource domain name, project name, and location using
      the form: `projects/{project_id}/locations/global/domains/{domain_name}`
  """

  detachTrustRequest = _messages.MessageField('DetachTrustRequest', 1)
  name = _messages.StringField(2, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsGetIamPolicyRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.  Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.  Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsGetRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsGetRequest object.

  Fields:
    name: Required. The domain resource name using the form:
      `projects/{project_id}/locations/global/domains/{domain_name}`
  """

  name = _messages.StringField(1, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsListRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsListRequest object.

  Fields:
    filter: Optional. A filter specifying constraints of a list operation. For
      example, `Domain.fqdn="mydomain.myorginization"`.
    orderBy: Optional. Specifies the ordering of results. See [Sorting
      order](https://cloud.google.com/apis/design/design_patterns#sorting_orde
      r) for more information.
    pageSize: Optional. The maximum number of items to return. If not
      specified, a default value of 1000 will be used. Regardless of the
      page_size value, the response may include a partial list. Callers should
      rely on a response's next_page_token to determine if there are
      additional results to list.
    pageToken: The `next_page_token` value returned from a previous
      ListDomainsRequest request, if any.
    parent: Required. The resource name of the domain location using the form:
      `projects/{project_id}/locations/global`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsPatchRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsPatchRequest object.

  Fields:
    domain: A Domain resource to be passed as the request body.
    name: Output only. The unique name of the domain using the form:
      `projects/{project_id}/locations/global/domains/{domain_name}`.
    updateMask: Required. Mask of fields to update. At least one path must be
      supplied in this field. The elements of the repeated paths field may
      only include fields from Domain:  * `labels`  * `locations`  *
      `authorized_networks`
  """

  domain = _messages.MessageField('Domain', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class ManagedidentitiesProjectsLocationsGlobalDomainsReconfigureTrustRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsReconfigureTrustRequest
  object.

  Fields:
    name: Required. The resource domain name, project name and location using
      the form: `projects/{project_id}/locations/global/domains/{domain_name}`
    reconfigureTrustRequest: A ReconfigureTrustRequest resource to be passed
      as the request body.
  """

  name = _messages.StringField(1, required=True)
  reconfigureTrustRequest = _messages.MessageField('ReconfigureTrustRequest', 2)


class ManagedidentitiesProjectsLocationsGlobalDomainsResetAdminPasswordRequest(_messages.Message):
  r"""A
  ManagedidentitiesProjectsLocationsGlobalDomainsResetAdminPasswordRequest
  object.

  Fields:
    name: Required. The domain resource name using the form:
      `projects/{project_id}/locations/global/domains/{domain_name}`
    resetAdminPasswordRequest: A ResetAdminPasswordRequest resource to be
      passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  resetAdminPasswordRequest = _messages.MessageField('ResetAdminPasswordRequest', 2)


class ManagedidentitiesProjectsLocationsGlobalDomainsSetIamPolicyRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ManagedidentitiesProjectsLocationsGlobalDomainsTestIamPermissionsRequest(_messages.Message):
  r"""A
  ManagedidentitiesProjectsLocationsGlobalDomainsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ManagedidentitiesProjectsLocationsGlobalDomainsValidateTrustRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsValidateTrustRequest
  object.

  Fields:
    name: Required. The resource domain name, project name, and location using
      the form: `projects/{project_id}/locations/global/domains/{domain_name}`
    validateTrustRequest: A ValidateTrustRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  validateTrustRequest = _messages.MessageField('ValidateTrustRequest', 2)


class ManagedidentitiesProjectsLocationsGlobalOperationsCancelRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalOperationsCancelRequest
  object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class ManagedidentitiesProjectsLocationsGlobalOperationsDeleteRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class ManagedidentitiesProjectsLocationsGlobalOperationsGetRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class ManagedidentitiesProjectsLocationsGlobalOperationsListRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ManagedidentitiesProjectsLocationsListRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsListRequest object.

  Fields:
    filter: The standard list filter.
    includeUnrevealedLocations: If true, the returned list will include
      locations which are not yet revealed.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  includeUnrevealedLocations = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: [Output only] API version used to start the operation.
    cancelRequested: [Output only] Identifies whether the user has requested
      cancellation of the operation. Operations that have successfully been
      cancelled have Operation.error value with a google.rpc.Status.code of 1,
      corresponding to `Code.CANCELLED`.
    createTime: [Output only] The time the operation was created.
    endTime: [Output only] The time the operation finished running.
    statusDetail: [Output only] Human-readable status of the operation, if
      any.
    target: [Output only] Server-defined resource path for the target of the
      operation.
    verb: [Output only] Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  cancelRequested = _messages.BooleanField(2)
  createTime = _messages.StringField(3)
  endTime = _messages.StringField(4)
  statusDetail = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources.   A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role.  Optionally, a
  `binding` can specify a `condition`, which is a logical expression that
  allows access to a resource only if the expression evaluates to `true`. A
  condition can add constraints based on attributes of the request, the
  resource, or both.  **JSON example:**      {       "bindings": [         {
  "role": "roles/resourcemanager.organizationAdmin",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-project-
  id@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/resourcemanager.organizationViewer",           "members":
  ["user:eve@example.com"],           "condition": {             "title":
  "expirable access",             "description": "Does not grant access after
  Sep 2020",             "expression": "request.time <
  timestamp('2020-10-01T00:00:00.000Z')",           }         }       ],
  "etag": "BwWWja0YfJA=",       "version": 3     }  **YAML example:**
  bindings:     - members:       - user:mike@example.com       -
  group:admins@example.com       - domain:google.com       - serviceAccount
  :my-project-id@appspot.gserviceaccount.com       role:
  roles/resourcemanager.organizationAdmin     - members:       -
  user:eve@example.com       role: roles/resourcemanager.organizationViewer
  condition:         title: expirable access         description: Does not
  grant access after Sep 2020         expression: request.time <
  timestamp('2020-10-01T00:00:00.000Z')     - etag: BwWWja0YfJA=     -
  version: 3  For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy.  Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected.  Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations:  * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy   that includes conditions  **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost.  If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset.
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class ReconfigureTrustRequest(_messages.Message):
  r"""Request message for ReconfigureTrust

  Fields:
    targetDnsIpAddresses: Required. The target DNS server IP addresses to
      resolve the remote domain involved in the trust.
    targetDomainName: Required. The fully-qualified target domain name which
      will be in trust with current domain.
  """

  targetDnsIpAddresses = _messages.StringField(1, repeated=True)
  targetDomainName = _messages.StringField(2)


class ResetAdminPasswordRequest(_messages.Message):
  r"""Request message for
ResetAdminPassword"""


class ResetAdminPasswordResponse(_messages.Message):
  r"""Response message for ResetAdminPassword

  Fields:
    password: A random password. See admin for more information.
  """

  password = _messages.StringField(1)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
  """

  policy = _messages.MessageField('Policy', 1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class Trust(_messages.Message):
  r"""Represents a relationship between two domains. This allows a controller
  in one domain to authenticate a user in another domain.

  Enums:
    StateValueValuesEnum: Output only. The current state of the trust.
    TrustDirectionValueValuesEnum: The trust direction, which decides if the
      current domain is trusted, trusting, or both.
    TrustTypeValueValuesEnum: The type of trust represented by the trust
      resource.

  Fields:
    createTime: Output only. The time the instance was created.
    lastTrustHeartbeatTime: Output only. The last heartbeat time when the
      trust was known to be connected.
    selectiveAuthentication: The trust authentication type, which decides
      whether the trusted side has forest/domain wide access or selective
      access to an approved set of resources.
    state: Output only. The current state of the trust.
    stateDescription: Output only. Additional information about the current
      state of the trust, if available.
    targetDnsIpAddresses: The target DNS server IP addresses which can resolve
      the remote domain involved in the trust.
    targetDomainName: The fully qualified target domain name which will be in
      trust with the current domain.
    trustDirection: The trust direction, which decides if the current domain
      is trusted, trusting, or both.
    trustHandshakeSecret: Input only, and will not be stored. The trust secret
      used for the handshake with the target domain.
    trustType: The type of trust represented by the trust resource.
    updateTime: Output only. The last update time.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the trust.

    Values:
      STATE_UNSPECIFIED: Not set.
      CREATING: The domain trust is being created.
      UPDATING: The domain trust is being updated.
      DELETING: The domain trust is being deleted.
      CONNECTED: The domain trust is connected.
      DISCONNECTED: The domain trust is disconnected.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    UPDATING = 2
    DELETING = 3
    CONNECTED = 4
    DISCONNECTED = 5

  class TrustDirectionValueValuesEnum(_messages.Enum):
    r"""The trust direction, which decides if the current domain is trusted,
    trusting, or both.

    Values:
      TRUST_DIRECTION_UNSPECIFIED: Not set.
      INBOUND: The inbound direction represents the trusting side.
      OUTBOUND: The outboud direction represents the trusted side.
      BIDIRECTIONAL: The bidirectional direction represents the trusted /
        trusting side.
    """
    TRUST_DIRECTION_UNSPECIFIED = 0
    INBOUND = 1
    OUTBOUND = 2
    BIDIRECTIONAL = 3

  class TrustTypeValueValuesEnum(_messages.Enum):
    r"""The type of trust represented by the trust resource.

    Values:
      TRUST_TYPE_UNSPECIFIED: Not set.
      FOREST: The forest trust.
      EXTERNAL: The external domain trust.
    """
    TRUST_TYPE_UNSPECIFIED = 0
    FOREST = 1
    EXTERNAL = 2

  createTime = _messages.StringField(1)
  lastTrustHeartbeatTime = _messages.StringField(2)
  selectiveAuthentication = _messages.BooleanField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  stateDescription = _messages.StringField(5)
  targetDnsIpAddresses = _messages.StringField(6, repeated=True)
  targetDomainName = _messages.StringField(7)
  trustDirection = _messages.EnumField('TrustDirectionValueValuesEnum', 8)
  trustHandshakeSecret = _messages.StringField(9)
  trustType = _messages.EnumField('TrustTypeValueValuesEnum', 10)
  updateTime = _messages.StringField(11)


class ValidateTrustRequest(_messages.Message):
  r"""Request message for ValidateTrust

  Fields:
    trust: Required. The domain trust to validate trust state for.
  """

  trust = _messages.MessageField('Trust', 1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
