"""Generated client library for healthcare version v1alpha2."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.healthcare.v1alpha2 import healthcare_v1alpha2_messages as messages


class HealthcareV1alpha2(base_api.BaseApiClient):
  """Generated client library for service healthcare version v1alpha2."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://healthcare.googleapis.com/'
  MTLS_BASE_URL = u'https://healthcare.mtls.googleapis.com/'

  _PACKAGE = u'healthcare'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1alpha2'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = u'google-cloud-sdk'
  _CLIENT_CLASS_NAME = u'HealthcareV1alpha2'
  _URL_VERSION = u'v1alpha2'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new healthcare handle."""
    url = url or self.BASE_URL
    super(HealthcareV1alpha2, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_datasets_annotationStores = self.ProjectsLocationsDatasetsAnnotationStoresService(self)
    self.projects_locations_datasets_consentStores_attributeDefinitions = self.ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService(self)
    self.projects_locations_datasets_consentStores_consentArtifacts = self.ProjectsLocationsDatasetsConsentStoresConsentArtifactsService(self)
    self.projects_locations_datasets_consentStores_consents_history = self.ProjectsLocationsDatasetsConsentStoresConsentsHistoryService(self)
    self.projects_locations_datasets_consentStores_consents = self.ProjectsLocationsDatasetsConsentStoresConsentsService(self)
    self.projects_locations_datasets_consentStores_userDataMappings = self.ProjectsLocationsDatasetsConsentStoresUserDataMappingsService(self)
    self.projects_locations_datasets_consentStores = self.ProjectsLocationsDatasetsConsentStoresService(self)
    self.projects_locations_datasets_dataProtectionStores = self.ProjectsLocationsDatasetsDataProtectionStoresService(self)
    self.projects_locations_datasets_dicomStores = self.ProjectsLocationsDatasetsDicomStoresService(self)
    self.projects_locations_datasets_fhirStores = self.ProjectsLocationsDatasetsFhirStoresService(self)
    self.projects_locations_datasets_hl7V2Stores = self.ProjectsLocationsDatasetsHl7V2StoresService(self)
    self.projects_locations_datasets_operations = self.ProjectsLocationsDatasetsOperationsService(self)
    self.projects_locations_datasets = self.ProjectsLocationsDatasetsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsDatasetsAnnotationStoresService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_annotationStores resource."""

    _NAME = u'projects_locations_datasets_annotationStores'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsAnnotationStoresService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Annotation store within the parent dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AnnotationStore) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'annotationStoreId'],
        relative_path=u'v1alpha2/{+parent}/annotationStores',
        request_field=u'annotationStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresCreateRequest',
        response_type_name=u'AnnotationStore',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Annotation store and removes all annotations that are.
contained within it.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Evaluate(self, request, global_params=None):
      r"""Evaluate an Annotation store against a.
ground truth Annotation store.
When the operation finishes successfully, a detailed response is returned
of type EvaluateAnnotationStoreResponse, contained in the response. The metadata field type is
OperationMetadata.
Errors are logged to Stackdriver
(see [Viewing logs](/healthcare/docs/how-tos/stackdriver-logging) and
ImportAnnotations for a sample log entry).

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresEvaluateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Evaluate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Evaluate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}:evaluate',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.evaluate',
        ordered_params=[u'evalStore'],
        path_params=[u'evalStore'],
        query_params=[],
        relative_path=u'v1alpha2/{+evalStore}:evaluate',
        request_field=u'evaluateAnnotationStoreRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresEvaluateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Export(self, request, global_params=None):
      r"""Export.
Annotations from
the Annotation
store.
If the request is successful, a detailed response is returned of type
ExportAnnotationsResponse, contained in the
response field when the
operation finishes.
The metadata field type is
OperationMetadata.
If errors occur, the error
field type is ImportAnnotationsErrorDetails.
Errors are also logged to Stackdriver
(see [Viewing logs](/healthcare/docs/how-tos/stackdriver-logging) and
ImportAnnotations for a sample log entry).

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresExportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Export')
      return self._RunMethod(
          config, request, global_params=global_params)

    Export.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}:export',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.export',
        ordered_params=[u'annotationStore'],
        path_params=[u'annotationStore'],
        query_params=[],
        relative_path=u'v1alpha2/{+annotationStore}:export',
        request_field=u'exportAnnotationsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresExportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the specified Annotation store or returns NOT_FOUND if it does not.
exist.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AnnotationStore) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresGetRequest',
        response_type_name=u'AnnotationStore',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1alpha2/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Import(self, request, global_params=None):
      r"""Import.
Annotations to
the Annotation
store by
loading data from the specified sources.
If the request is successful, a detailed response is returned as of type
ImportAnnotationsResponse, contained in the
response field when the
operation finishes.
The metadata field type is
OperationMetadata.
If errors occur, the error
field type is ImportAnnotationsErrorDetails.
Errors are also logged to Stackdriver
(see [Viewing logs](/healthcare/docs/how-tos/stackdriver-logging)).
For example, the following sample log entry shows a
`failed to parse Cloud Storage object` error that occurred while attempting
to import `gs://ANNOTATION_FILENAME.json` to
`projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annotationStores/{annotation_store_id}`.
```json
jsonPayload: {
  @type:
  "type.googleapis.com/google.cloud.healthcare.logging.ImportAnnotationLogEntry"
  error: {
    code:  3
    message:  "failed to parse Cloud Storage object"
  }
  source:  "gs://ANNOTATION_FILENAME.json"
}
logName:
"projects/{project_id}/logs/healthcare.googleapis.com%2Fimport_annotations"
operation: {
  id:
  "projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/operations/{operation_id}"
  producer:  "healthcare.googleapis.com/ImportAnnotations"
}
receiveTimestamp:  "TIMESTAMP"
resource: {
  labels: {
    annotation_store_id:  "{annotation_store_id}"
    dataset_id:  "{dataset_id}"
    location:  "{location_id}"
    project_id:  "{project_id}"
  }
  type:  "healthcare_annotation_store"
}
severity:  "ERROR"
timestamp:  "TIMESTAMP"
```

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresImportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Import')
      return self._RunMethod(
          config, request, global_params=global_params)

    Import.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}:import',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.import',
        ordered_params=[u'annotationStore'],
        path_params=[u'annotationStore'],
        query_params=[],
        relative_path=u'v1alpha2/{+annotationStore}:import',
        request_field=u'importAnnotationsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresImportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the Annotation stores in the given dataset for a source store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAnnotationStoresResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/annotationStores',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresListRequest',
        response_type_name=u'ListAnnotationStoresResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified Annotation store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AnnotationStore) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'annotationStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresPatchRequest',
        response_type_name=u'AnnotationStore',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

Can return Public Errors: NOT_FOUND, INVALID_ARGUMENT and PERMISSION_DENIED

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a NOT_FOUND error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (HealthcareProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/annotationStores/{annotationStoresId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.annotationStores.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_consentStores_attributeDefinitions resource."""

    _NAME = u'projects_locations_datasets_consentStores_attributeDefinitions'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsConsentStoresAttributeDefinitionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Attribute definition in the.
parent Consent store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AttributeDefinition) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/attributeDefinitions',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.consentStores.attributeDefinitions.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'attributeDefinitionId'],
        relative_path=u'v1alpha2/{+parent}/attributeDefinitions',
        request_field=u'attributeDefinition',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresAttributeDefinitionsCreateRequest',
        response_type_name=u'AttributeDefinition',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Attribute definition. Fails if it.
is referenced in any Consent or User data mapping.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/attributeDefinitions/{attributeDefinitionsId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.consentStores.attributeDefinitions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresAttributeDefinitionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the specified Attribute definition.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AttributeDefinition) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/attributeDefinitions/{attributeDefinitionsId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.consentStores.attributeDefinitions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresAttributeDefinitionsGetRequest',
        response_type_name=u'AttributeDefinition',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the Attribute definitions in the given.
Consent store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAttributeDefinitionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/attributeDefinitions',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.consentStores.attributeDefinitions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/attributeDefinitions',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresAttributeDefinitionsListRequest',
        response_type_name=u'ListAttributeDefinitionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified Attribute definition.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AttributeDefinition) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/attributeDefinitions/{attributeDefinitionsId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.consentStores.attributeDefinitions.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'attributeDefinition',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresAttributeDefinitionsPatchRequest',
        response_type_name=u'AttributeDefinition',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsConsentStoresConsentArtifactsService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_consentStores_consentArtifacts resource."""

    _NAME = u'projects_locations_datasets_consentStores_consentArtifacts'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsConsentStoresConsentArtifactsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Consent artifact in the.
parent Consent store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConsentArtifact) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/consentArtifacts',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.consentStores.consentArtifacts.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/consentArtifacts',
        request_field=u'consentArtifact',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresConsentArtifactsCreateRequest',
        response_type_name=u'ConsentArtifact',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Consent artifact. Fails if it is.
referenced by any Consent.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/consentArtifacts/{consentArtifactsId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.consentStores.consentArtifacts.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresConsentArtifactsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the specified Consent artifact.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresConsentArtifactsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConsentArtifact) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/consentArtifacts/{consentArtifactsId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.consentStores.consentArtifacts.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresConsentArtifactsGetRequest',
        response_type_name=u'ConsentArtifact',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the Consent artifacts in the given.
Consent store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresConsentArtifactsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConsentArtifactsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/consentArtifacts',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.consentStores.consentArtifacts.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/consentArtifacts',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresConsentArtifactsListRequest',
        response_type_name=u'ListConsentArtifactsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsConsentStoresConsentsHistoryService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_consentStores_consents_history resource."""

    _NAME = u'projects_locations_datasets_consentStores_consents_history'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsConsentStoresConsentsHistoryService, self).__init__(client)
      self._upload_configs = {
          }

    def DeleteAll(self, request, global_params=None):
      r"""Deletes historical versions of a Consent excluding the.
current version from the Consent store.
This operation does not affect the related consent artifact.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresConsentsHistoryDeleteAllRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('DeleteAll')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteAll.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/consents/{consentsId}/history:deleteAll',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.consentStores.consents.history.deleteAll',
        ordered_params=[u'consent'],
        path_params=[u'consent'],
        query_params=[],
        relative_path=u'v1alpha2/{+consent}/history:deleteAll',
        request_field=u'deleteAllConsentHistoryRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresConsentsHistoryDeleteAllRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists historical versions of a Consent excluding the.
current version from the Consent store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresConsentsHistoryListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConsentHistoryResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/consents/{consentsId}/history',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.consentStores.consents.history.list',
        ordered_params=[u'consent'],
        path_params=[u'consent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+consent}/history',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresConsentsHistoryListRequest',
        response_type_name=u'ListConsentHistoryResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsConsentStoresConsentsService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_consentStores_consents resource."""

    _NAME = u'projects_locations_datasets_consentStores_consents'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsConsentStoresConsentsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Consent.
in the parent Consent store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresConsentsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Consent) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/consents',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.consentStores.consents.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/consents',
        request_field=u'consent',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresConsentsCreateRequest',
        response_type_name=u'Consent',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the Consent and.
its history. To keep a record of the Consent but mark it inactive, see
[RevokeConsent]. To delete the history of a Consent, see
[DeleteAllConsentHistory]. This operation does not affect the related
consent artifact.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresConsentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/consents/{consentsId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.consentStores.consents.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresConsentsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the specified Consent.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresConsentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Consent) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/consents/{consentsId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.consentStores.consents.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresConsentsGetRequest',
        response_type_name=u'Consent',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the Consents in.
the given Consent store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresConsentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConsentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/consents',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.consentStores.consents.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/consents',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresConsentsListRequest',
        response_type_name=u'ListConsentsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the Consent.
The existing consent is archived and replaced with the one that has updated
fields. Only active consents can be updated. To view previous versions, use
the [ListConsentHistory] operation.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresConsentsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Consent) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/consents/{consentsId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.consentStores.consents.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'consent',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresConsentsPatchRequest',
        response_type_name=u'Consent',
        supports_download=False,
    )

    def Revoke(self, request, global_params=None):
      r"""Revokes the current version of the specified Consent.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresConsentsRevokeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RevokeConsentResponse) The response message.
      """
      config = self.GetMethodConfig('Revoke')
      return self._RunMethod(
          config, request, global_params=global_params)

    Revoke.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/consents/{consentsId}:revoke',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.consentStores.consents.revoke',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:revoke',
        request_field=u'revokeConsentRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresConsentsRevokeRequest',
        response_type_name=u'RevokeConsentResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsConsentStoresUserDataMappingsService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_consentStores_userDataMappings resource."""

    _NAME = u'projects_locations_datasets_consentStores_userDataMappings'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsConsentStoresUserDataMappingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Archive(self, request, global_params=None):
      r"""Archives the specified User data mapping.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ArchiveUserDataMappingResponse) The response message.
      """
      config = self.GetMethodConfig('Archive')
      return self._RunMethod(
          config, request, global_params=global_params)

    Archive.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/userDataMappings/{userDataMappingsId}:archive',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.consentStores.userDataMappings.archive',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:archive',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresUserDataMappingsArchiveRequest',
        response_type_name=u'ArchiveUserDataMappingResponse',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new User data mapping in the.
parent Consent store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UserDataMapping) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/userDataMappings',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.consentStores.userDataMappings.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/userDataMappings',
        request_field=u'userDataMapping',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresUserDataMappingsCreateRequest',
        response_type_name=u'UserDataMapping',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified User data mapping.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/userDataMappings/{userDataMappingsId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.consentStores.userDataMappings.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresUserDataMappingsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the specified User data mapping.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresUserDataMappingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UserDataMapping) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/userDataMappings/{userDataMappingsId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.consentStores.userDataMappings.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresUserDataMappingsGetRequest',
        response_type_name=u'UserDataMapping',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the User data mappings in the given.
Consent store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresUserDataMappingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListUserDataMappingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/userDataMappings',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.consentStores.userDataMappings.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/userDataMappings',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresUserDataMappingsListRequest',
        response_type_name=u'ListUserDataMappingsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified User data mapping.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UserDataMapping) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}/userDataMappings/{userDataMappingsId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.consentStores.userDataMappings.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'userDataMapping',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresUserDataMappingsPatchRequest',
        response_type_name=u'UserDataMapping',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsConsentStoresService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_consentStores resource."""

    _NAME = u'projects_locations_datasets_consentStores'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsConsentStoresService, self).__init__(client)
      self._upload_configs = {
          }

    def CheckDataAccess(self, request, global_params=None):
      r"""Checks if a particular data_id of a User data mapping in the given.
Consent store is
consented for a given use.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresCheckDataAccessRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CheckDataAccessResponse) The response message.
      """
      config = self.GetMethodConfig('CheckDataAccess')
      return self._RunMethod(
          config, request, global_params=global_params)

    CheckDataAccess.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}:checkDataAccess',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.consentStores.checkDataAccess',
        ordered_params=[u'consentStore'],
        path_params=[u'consentStore'],
        query_params=[],
        relative_path=u'v1alpha2/{+consentStore}:checkDataAccess',
        request_field=u'checkDataAccessRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresCheckDataAccessRequest',
        response_type_name=u'CheckDataAccessResponse',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new Consent store in the.
parent dataset. Attempting to create a consent store with the same ID as an
existing store fails with an ALREADY_EXISTS error.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConsentStore) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.consentStores.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'consentStoreId'],
        relative_path=u'v1alpha2/{+parent}/consentStores',
        request_field=u'consentStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresCreateRequest',
        response_type_name=u'ConsentStore',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Consent store and removes all.
consent data in the specified consent store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.consentStores.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the specified Consent store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConsentStore) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.consentStores.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresGetRequest',
        response_type_name=u'ConsentStore',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.consentStores.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1alpha2/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the Consent stores in the given.
dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConsentStoresResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.consentStores.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/consentStores',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresListRequest',
        response_type_name=u'ListConsentStoresResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified Consent store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConsentStore) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.consentStores.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'consentStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresPatchRequest',
        response_type_name=u'ConsentStore',
        supports_download=False,
    )

    def QueryAccessibleData(self, request, global_params=None):
      r"""Queries all data_ids that are consented for a given use in the given.
Consent store and
writes them to a specified destination. Note that if a user has a
Policy in their consents
that grants the given use, then the user is considered to have consented
even if other policies do not allow the given use. For example, if a user
has a policy with `resource_attributes` matching the requested
`resource_attributes` and an `authorization_rule` supporting the requested
`request_attributes`, then the user is considered to have consented even if
the user has another policy with the same `resource_attributes` and an
`authorization_rule` rejecting the requested `request_attributes`.
Errors are logged to Cloud Logging (see [Viewing logs]
(/healthcare/docs/how-tos/stackdriver-logging)). For example, the following
sample log entry shows a `failed to evaluate consent policy` error that
occurred during a QueryAccessibleData call to consent store
`projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}`.
```json
jsonPayload: {
  @type:
  "type.googleapis.com/google.cloud.healthcare.logging.QueryAccessibleDataLogEntry"
  error: {
    code:  9
    message:  "failed to evaluate consent policy"
  }
  resourceName:
  "projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}"
}
logName:
"projects/{project_id}/logs/healthcare.googleapis.com%2Fquery_accessible_data"
operation: {
  id:
  "projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/operations/{operation_id}"
  producer:  "healthcare.googleapis.com/QueryAccessibleData"
}
receiveTimestamp:  "TIMESTAMP"
resource: {
  labels: {
    consent_store_id:  "{consent_store_id}"
    dataset_id:  "{dataset_id}"
    location:  "{location_id}"
    project_id:  "{project_id}"
  }
  type:  "healthcare_consent_store"
}
severity:  "ERROR"
timestamp:  "TIMESTAMP"
```

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresQueryAccessibleDataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('QueryAccessibleData')
      return self._RunMethod(
          config, request, global_params=global_params)

    QueryAccessibleData.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}:queryAccessibleData',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.consentStores.queryAccessibleData',
        ordered_params=[u'consentStore'],
        path_params=[u'consentStore'],
        query_params=[],
        relative_path=u'v1alpha2/{+consentStore}:queryAccessibleData',
        request_field=u'queryAccessibleDataRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresQueryAccessibleDataRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

Can return Public Errors: NOT_FOUND, INVALID_ARGUMENT and PERMISSION_DENIED

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.consentStores.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a NOT_FOUND error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (HealthcareProjectsLocationsDatasetsConsentStoresTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/consentStores/{consentStoresId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.consentStores.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsConsentStoresTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsDataProtectionStoresService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_dataProtectionStores resource."""

    _NAME = u'projects_locations_datasets_dataProtectionStores'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsDataProtectionStoresService, self).__init__(client)
      self._upload_configs = {
          }

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDataProtectionStoresGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dataProtectionStores/{dataProtectionStoresId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dataProtectionStores.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1alpha2/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDataProtectionStoresGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

Can return Public Errors: NOT_FOUND, INVALID_ARGUMENT and PERMISSION_DENIED

      Args:
        request: (HealthcareProjectsLocationsDatasetsDataProtectionStoresSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dataProtectionStores/{dataProtectionStoresId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dataProtectionStores.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDataProtectionStoresSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsDicomStoresService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_dicomStores resource."""

    _NAME = u'projects_locations_datasets_dicomStores'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsDicomStoresService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new DICOM store within the parent dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DicomStore) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'dicomStoreId'],
        relative_path=u'v1alpha2/{+parent}/dicomStores',
        request_field=u'dicomStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresCreateRequest',
        response_type_name=u'DicomStore',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified DICOM store and removes all images that are contained.
within it.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Export(self, request, global_params=None):
      r"""Exports data to the specified destination by copying it from the DICOM.
store.
Errors are also logged to Stackdriver Logging. For more information,
see [Viewing logs](/healthcare/docs/how-tos/stackdriver-logging).
The metadata field type is
OperationMetadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresExportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Export')
      return self._RunMethod(
          config, request, global_params=global_params)

    Export.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}:export',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.export',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:export',
        request_field=u'exportDicomDataRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresExportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the specified DICOM store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DicomStore) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresGetRequest',
        response_type_name=u'DicomStore',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1alpha2/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Import(self, request, global_params=None):
      r"""Imports data into the DICOM store by copying it from the specified source.
For errors, the Operation is populated with error details (in the form
of ImportDicomDataErrorDetails in error.details), which holds
finer-grained error information. Errors are also logged to Stackdriver
Logging. For more information, see
[Viewing logs](/healthcare/docs/how-tos/stackdriver-logging).
The metadata field type is
OperationMetadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresImportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Import')
      return self._RunMethod(
          config, request, global_params=global_params)

    Import.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}:import',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.import',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:import',
        request_field=u'importDicomDataRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresImportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the DICOM stores in the given dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDicomStoresResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/dicomStores',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresListRequest',
        response_type_name=u'ListDicomStoresResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified DICOM store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DicomStore) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'dicomStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresPatchRequest',
        response_type_name=u'DicomStore',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

Can return Public Errors: NOT_FOUND, INVALID_ARGUMENT and PERMISSION_DENIED

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a NOT_FOUND error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (HealthcareProjectsLocationsDatasetsDicomStoresTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/dicomStores/{dicomStoresId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.dicomStores.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDicomStoresTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsFhirStoresService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_fhirStores resource."""

    _NAME = u'projects_locations_datasets_fhirStores'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsFhirStoresService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new FHIR store within the parent dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FhirStore) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'fhirStoreId'],
        relative_path=u'v1alpha2/{+parent}/fhirStores',
        request_field=u'fhirStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresCreateRequest',
        response_type_name=u'FhirStore',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified FHIR store and removes all resources within it.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Export(self, request, global_params=None):
      r"""Export resources from the FHIR store to the specified destination.

This method returns an Operation that can
be used to track the status of the export by calling
GetOperation.

Immediate fatal errors appear in the
error field, errors are also logged
to Stackdriver (see [Viewing
logs](/healthcare/docs/how-tos/stackdriver-logging)).
Otherwise, when the operation finishes, a detailed response of type
ExportResourcesResponse is returned in the
response field.
The metadata field type for this
operation is OperationMetadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresExportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Export')
      return self._RunMethod(
          config, request, global_params=global_params)

    Export.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}:export',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.export',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:export',
        request_field=u'exportResourcesRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresExportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the configuration of the specified FHIR store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FhirStore) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresGetRequest',
        response_type_name=u'FhirStore',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1alpha2/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def Import(self, request, global_params=None):
      r"""Import resources to the FHIR store by loading data from the specified.
sources. This method is optimized to load large quantities of data using
import semantics that ignore some FHIR store configuration options and are
not suitable for all use cases. It is primarily intended to load data into
an empty FHIR store that is not being used by other clients. In cases
where this method is not appropriate, consider using ExecuteBundle to
load data.

Every resource in the input must contain a client-supplied ID and is
stored using that ID regardless of the
enable_update_create setting on the FHIR
store.

The import process does not enforce referential integrity, regardless of
the
disable_referential_integrity
setting on the FHIR store. This allows the import of resources with
arbitrary interdependencies without considering grouping or ordering, but
if the input data contains invalid references or if some resources fail to
be imported, the FHIR store might be left in a state that violates
referential integrity.

The import process does not trigger Cloud Pub/Sub notification or BigQuery
streaming update, regardless of how those are configured on the FHIR store.

If a resource with the specified ID already exists, the most recent
version of the resource is overwritten without creating a new historical
version, regardless of the
disable_resource_versioning
setting on the FHIR store. If transient failures occur during the import,
successfully imported resources could be overwritten more than once.

The import operation is idempotent unless the input data contains multiple
valid resources with the same ID but different contents. In that case,
after the import completes, the store contains exactly one resource
with that ID but there is no ordering guarantee on which version of the
contents it has. The operation result counters do not count
duplicate IDs as an error and count one success for each resource in
the input, which might result in a success count larger than the number
of resources in the FHIR store. This often occurs when importing data
organized in bundles produced by Patient-everything
where each bundle contains its own copy of a resource such as Practitioner
that might be referred to by many patients.

If some resources fail to import, for example due to parsing errors,
successfully imported resources are not rolled back.

The location and format of the input data is specified by the parameters
below. Note that if no format is specified, this method assumes the
`BUNDLE` format. When using the `BUNDLE` format this method ignores the
`Bundle.type` field, except that `history` bundles are rejected, and does
not apply any of the bundle processing semantics for batch or transaction
bundles. Unlike in ExecuteBundle, transaction bundles are not executed
as a single transaction and bundle-internal references are not rewritten.
The bundle is treated as a collection of resources to be written as
provided in `Bundle.entry.resource`, ignoring `Bundle.entry.request`. As
an example, this allows the import of `searchset` bundles produced by a
FHIR search or
Patient-everything operation.

This method returns an Operation that can
be used to track the status of the import by calling
GetOperation.

Immediate fatal errors appear in the
error field, errors are also logged
to Stackdriver (see [Viewing
logs](/healthcare/docs/how-tos/stackdriver-logging)). Otherwise, when the
operation finishes, a detailed response of type ImportResourcesResponse
is returned in the response field.
The metadata field type for this
operation is OperationMetadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresImportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Import')
      return self._RunMethod(
          config, request, global_params=global_params)

    Import.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}:import',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.import',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:import',
        request_field=u'importResourcesRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresImportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the FHIR stores in the given dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFhirStoresResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/fhirStores',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresListRequest',
        response_type_name=u'ListFhirStoresResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the configuration of the specified FHIR store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FhirStore) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'fhirStore',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresPatchRequest',
        response_type_name=u'FhirStore',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

Can return Public Errors: NOT_FOUND, INVALID_ARGUMENT and PERMISSION_DENIED

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a NOT_FOUND error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (HealthcareProjectsLocationsDatasetsFhirStoresTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/fhirStores/{fhirStoresId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.fhirStores.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsFhirStoresTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsHl7V2StoresService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_hl7V2Stores resource."""

    _NAME = u'projects_locations_datasets_hl7V2Stores'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsHl7V2StoresService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new HL7v2 store within the parent dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Hl7V2Store) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'hl7V2StoreId'],
        relative_path=u'v1alpha2/{+parent}/hl7V2Stores',
        request_field=u'hl7V2Store',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresCreateRequest',
        response_type_name=u'Hl7V2Store',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified HL7v2 store and removes all messages that are.
contained within it.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the specified HL7v2 store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Hl7V2Store) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresGetRequest',
        response_type_name=u'Hl7V2Store',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1alpha2/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the HL7v2 stores in the given dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListHl7V2StoresResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/hl7V2Stores',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresListRequest',
        response_type_name=u'ListHl7V2StoresResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the HL7v2 store.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Hl7V2Store) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'hl7V2Store',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresPatchRequest',
        response_type_name=u'Hl7V2Store',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

Can return Public Errors: NOT_FOUND, INVALID_ARGUMENT and PERMISSION_DENIED

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a NOT_FOUND error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (HealthcareProjectsLocationsDatasetsHl7V2StoresTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/hl7V2Stores/{hl7V2StoresId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.hl7V2Stores.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsHl7V2StoresTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets_operations resource."""

    _NAME = u'projects_locations_datasets_operations'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation.  The server.
makes a best effort to cancel the operation, but success is not
guaranteed.  If the server doesn't support this method, it returns
`google.rpc.Code.UNIMPLEMENTED`.  Clients can use
Operations.GetOperation or
other methods to check whether the cancellation succeeded or whether the
operation completed despite cancellation. On successful cancellation,
the operation is not deleted; instead, it becomes an operation with
an Operation.error value with a google.rpc.Status.code of 1,
corresponding to `Code.CANCELLED`.

      Args:
        request: (HealthcareProjectsLocationsDatasetsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/operations/{operationsId}:cancel',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.operations.cancel',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:cancel',
        request_field=u'cancelOperationRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsOperationsCancelRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (HealthcareProjectsLocationsDatasetsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/operations/{operationsId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.operations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the.
server doesn't support this method, it returns `UNIMPLEMENTED`.

NOTE: the `name` binding allows API services to override the binding
to use different resource name schemes, such as `users/*/operations`. To
override the binding, API services can add a binding such as
`"/v1/{name=users/*}/operations"` to their service configuration.
For backwards compatibility, the default name includes the operations
collection id, however overriding users must ensure the name binding
is the parent resource, without the operations collection id.

      Args:
        request: (HealthcareProjectsLocationsDatasetsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}/operations',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.operations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+name}/operations',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsOperationsListRequest',
        response_type_name=u'ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsDatasetsService(base_api.BaseApiService):
    """Service class for the projects_locations_datasets resource."""

    _NAME = u'projects_locations_datasets'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsDatasetsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new health dataset. Results are returned through the.
Operation interface which returns either an
`Operation.response` which contains a Dataset or
`Operation.error`. The metadata
field type is OperationMetadata.
A Google Cloud Platform project can contain up to 500 datasets across all
regions.

      Args:
        request: (HealthcareProjectsLocationsDatasetsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'datasetId'],
        relative_path=u'v1alpha2/{+parent}/datasets',
        request_field=u'dataset',
        request_type_name=u'HealthcareProjectsLocationsDatasetsCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Deidentify(self, request, global_params=None):
      r"""Creates a new dataset containing de-identified data from the source.
dataset. The metadata field type
is OperationMetadata.
If the request is successful, the
response field type is
DeidentifySummary.
If errors occur, the
error
details field type is
DeidentifyErrorDetails.
The LRO result may still be successful if de-identification fails for some
DICOM instances. The new de-identified dataset will not contain these
failed resources. Failed resource totals are tracked in
DeidentifySummary.failure_resource_count.
Error details are also logged to Stackdriver Logging. For more information,
see [Viewing logs](/healthcare/docs/how-tos/stackdriver-logging).

      Args:
        request: (HealthcareProjectsLocationsDatasetsDeidentifyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Deidentify')
      return self._RunMethod(
          config, request, global_params=global_params)

    Deidentify.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}:deidentify',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.deidentify',
        ordered_params=[u'sourceDataset'],
        path_params=[u'sourceDataset'],
        query_params=[],
        relative_path=u'v1alpha2/{+sourceDataset}:deidentify',
        request_field=u'deidentifyDatasetRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDeidentifyRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified health dataset and all data contained in the dataset.
Deleting a dataset does not affect the sources from which the dataset was
imported (if any).

      Args:
        request: (HealthcareProjectsLocationsDatasetsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}',
        http_method=u'DELETE',
        method_id=u'healthcare.projects.locations.datasets.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets any metadata associated with a dataset.

      Args:
        request: (HealthcareProjectsLocationsDatasetsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Dataset) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsGetRequest',
        response_type_name=u'Dataset',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (HealthcareProjectsLocationsDatasetsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1alpha2/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the health datasets in the current project.

      Args:
        request: (HealthcareProjectsLocationsDatasetsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDatasetsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.datasets.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/datasets',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsDatasetsListRequest',
        response_type_name=u'ListDatasetsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates dataset metadata.

      Args:
        request: (HealthcareProjectsLocationsDatasetsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Dataset) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}',
        http_method=u'PATCH',
        method_id=u'healthcare.projects.locations.datasets.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'dataset',
        request_type_name=u'HealthcareProjectsLocationsDatasetsPatchRequest',
        response_type_name=u'Dataset',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

Can return Public Errors: NOT_FOUND, INVALID_ARGUMENT and PERMISSION_DENIED

      Args:
        request: (HealthcareProjectsLocationsDatasetsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a NOT_FOUND error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (HealthcareProjectsLocationsDatasetsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}/datasets/{datasetsId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'healthcare.projects.locations.datasets.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'HealthcareProjectsLocationsDatasetsTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (HealthcareProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations/{locationsId}',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsGetRequest',
        response_type_name=u'Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (HealthcareProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/locations',
        http_method=u'GET',
        method_id=u'healthcare.projects.locations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+name}/locations',
        request_field='',
        request_type_name=u'HealthcareProjectsLocationsListRequest',
        response_type_name=u'ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(HealthcareV1alpha2.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
