"""Generated message classes for healthcare version v1beta1.

Manage, store, and access healthcare data in Google Cloud Platform.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'healthcare'


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:jose@example.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "sampleservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:aliya@example.com"               ]             }           ]         }
  ]     }  For sampleservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging,
  and aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:jose@example.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  jose@example.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. NOTE: An
      unsatisfied condition will not allow user access via current binding.
      Different bindings, including their conditions, are examined
      independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example,
      `alice@example.com` .   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.  *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding.  *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus    unique identifier) representing a service account that has been
      recently    deleted. For example,    `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`.    If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding.  * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique    identifier) representing a Google group
      that has been recently    deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If    the group is
      recovered, this value reverts to `group:{emailid}` and the    recovered
      group retains the role in the binding.   * `domain:{domain}`: The G
      Suite domain (primary) that represents all the    users of that domain.
      For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CharacterMaskConfig(_messages.Message):
  r"""Mask a string by replacing its characters with a fixed character.

  Fields:
    maskingCharacter: Character to mask the sensitive values. If not supplied,
      defaults to "*".
  """

  maskingCharacter = _messages.StringField(1)


class CreateMessageRequest(_messages.Message):
  r"""Creates a new message.

  Fields:
    message: HL7v2 message.
  """

  message = _messages.MessageField('Message', 1)


class CryptoHashConfig(_messages.Message):
  r"""Pseudonymization method that generates surrogates via cryptographic
  hashing. Uses SHA-256. Outputs a base64-encoded representation of the hashed
  output (for example, `L7k0BHmF1ha5U3NfGykjro4xWi1MPVQPjhMAZbSV9mM=`).

  Fields:
    cryptoKey: An AES 128/192/256 bit key. Causes the hash to be computed
      based on this key. A default key is generated for each Deidentify
      operation and is used wherever crypto_key is not specified.
  """

  cryptoKey = _messages.BytesField(1)


class Dataset(_messages.Message):
  r"""A message representing a health dataset.  A health dataset represents a
  collection of healthcare data pertaining to one or more patients. This may
  include multiple modalities of healthcare data, such as electronic medical
  records or medical imaging data.

  Fields:
    name: Output only. Resource name of the dataset, of the form
      `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
    timeZone: The default timezone used by this dataset. Must be a either a
      valid IANA time zone name such as "America/New_York" or empty, which
      defaults to UTC. This is used for parsing times in resources, such as
      HL7 messages, where no explicit timezone is specified.
  """

  name = _messages.StringField(1)
  timeZone = _messages.StringField(2)


class DateShiftConfig(_messages.Message):
  r"""Shift a date forward or backward in time by a random amount which is
  consistent for a given patient and crypto key combination.

  Fields:
    cryptoKey: An AES 128/192/256 bit key. Causes the shift to be computed
      based on this key and the patient ID. A default key is generated for
      each Deidentify operation and is used wherever crypto_key is not
      specified.
  """

  cryptoKey = _messages.BytesField(1)


class DeidentifyConfig(_messages.Message):
  r"""Configures de-id options specific to different types of content. Each
  submessage customizes the handling of an https://tools.ietf.org/html/rfc6838
  media type or subtype. Configs are applied in a nested manner at runtime.

  Fields:
    dicom: Configures de-id of application/DICOM content.
    fhir: Configures de-id of application/FHIR content.
    image: Configures de-identification of image pixels wherever they are
      found in the source_dataset.
    text: Configures de-identification of text wherever it is found in the
      source_dataset.
  """

  dicom = _messages.MessageField('DicomConfig', 1)
  fhir = _messages.MessageField('FhirConfig', 2)
  image = _messages.MessageField('ImageConfig', 3)
  text = _messages.MessageField('TextConfig', 4)


class DeidentifyDatasetRequest(_messages.Message):
  r"""Redacts identifying information from the specified dataset.

  Fields:
    config: Deidentify configuration.
    destinationDataset: The name of the dataset resource to create and write
      the redacted data to.   * The destination dataset must not exist.  * The
      destination dataset must be in the same project and location as the
      source dataset. De-identifying data across multiple projects or
      locations  is not supported.
  """

  config = _messages.MessageField('DeidentifyConfig', 1)
  destinationDataset = _messages.StringField(2)


class DeidentifyDicomStoreRequest(_messages.Message):
  r"""Creates a new DICOM store with sensitive information de-identified.

  Fields:
    config: De-identify configuration.
    destinationStore: The name of the DICOM store to create and write the
      redacted data to. For example, `projects/{project_id}/locations/{locatio
      n_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.   * The
      destination dataset must exist.  * The source dataset and destination
      dataset must both reside in the same    project. De-identifying data
      across multiple projects is not supported.  * The destination DICOM
      store must not exist.  * The caller must have the necessary permissions
      to create the destination    DICOM store.
    filterConfig: Filter configuration.
  """

  config = _messages.MessageField('DeidentifyConfig', 1)
  destinationStore = _messages.StringField(2)
  filterConfig = _messages.MessageField('DicomFilterConfig', 3)


class DeidentifyErrorDetails(_messages.Message):
  r"""Contains the status of the Deidentify operation.

  Fields:
    failureResourceCount: Number of resources that failed to process.
    failureStoreCount: Number of stores that failed to process.
    successResourceCount: Number of resources successfully processed.
    successStoreCount: Number of stores successfully processed.
  """

  failureResourceCount = _messages.IntegerField(1)
  failureStoreCount = _messages.IntegerField(2)
  successResourceCount = _messages.IntegerField(3)
  successStoreCount = _messages.IntegerField(4)


class DeidentifyFhirStoreRequest(_messages.Message):
  r"""Creates a new FHIR store with sensitive information de-identified.

  Fields:
    config: Deidentify configuration.
    destinationStore: The name of the FHIR store to create and write the
      redacted data to. For example, `projects/{project_id}/locations/{locatio
      n_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.   * The
      destination dataset must exist.  * The source dataset and destination
      dataset must both reside in the same    project. De-identifying data
      across multiple projects is not supported.  * The destination FHIR store
      must exist.  * The caller must have the healthcare.fhirResources.update
      permission to    write to the destination FHIR store.
    resourceFilter: A filter specifying the resources to include in the
      output. If not specified, all resources are included in the output.
  """

  config = _messages.MessageField('DeidentifyConfig', 1)
  destinationStore = _messages.StringField(2)
  resourceFilter = _messages.MessageField('FhirFilter', 3)


class DeidentifySummary(_messages.Message):
  r"""Contains a detailed summary of the Deidentify operation.

  Fields:
    failureResourceCount: Number of resources that failed to process. The
      failures might be caused by:    * Invalid user input data   * Transient
      errors that could be skipped
    successResourceCount: Number of resources successfully processed.
    successStoreCount: Number of stores successfully processed.
  """

  failureResourceCount = _messages.IntegerField(1)
  successResourceCount = _messages.IntegerField(2)
  successStoreCount = _messages.IntegerField(3)


class DicomConfig(_messages.Message):
  r"""Specifies the parameters needed for de-identification of DICOM stores.

  Enums:
    FilterProfileValueValuesEnum: Tag filtering profile that determines which
      tags to keep/remove.

  Fields:
    filterProfile: Tag filtering profile that determines which tags to
      keep/remove.
    keepList: List of tags to keep. Remove all other tags.
    removeList: List of tags to remove. Keep all other tags.
    skipIdRedaction: If true, skip replacing StudyInstanceUID,
      SeriesInstanceUID, SOPInstanceUID, and MediaStorageSOPInstanceUID and
      leave them untouched. The Cloud Healthcare API regenerates these UIDs by
      default based on the DICOM Standard's reasoning: "Whilst these UIDs
      cannot be mapped directly to an individual out of context, given access
      to the original images, or to a database of the original images
      containing the UIDs, it would be possible to recover the individual's
      identity." http://dicom.nema.org/medical/dicom/current/output/chtml/part
      15/sect_E.3.9.html
  """

  class FilterProfileValueValuesEnum(_messages.Enum):
    r"""Tag filtering profile that determines which tags to keep/remove.

    Values:
      TAG_FILTER_PROFILE_UNSPECIFIED: No tag filtration profile provided. Same
        as KEEP_ALL_PROFILE.
      MINIMAL_KEEP_LIST_PROFILE: Keep only tags required to produce valid
        DICOM.
      ATTRIBUTE_CONFIDENTIALITY_BASIC_PROFILE: Remove tags based on DICOM
        Standard's Attribute Confidentiality Basic Profile (DICOM Standard
        Edition 2018e) http://dicom.nema.org/medical/dicom/2018e/output/chtml/
        part15/chapter_E.html.
      KEEP_ALL_PROFILE: Keep all tags.
      DEIDENTIFY_TAG_CONTENTS: Inspects within tag contents and replaces
        sensitive text. The process can be configured using the TextConfig.
        Applies to all tags with the following Value Representation names: AE,
        LO, LT, PN, SH, ST, UC, UT, DA, DT, AS
    """
    TAG_FILTER_PROFILE_UNSPECIFIED = 0
    MINIMAL_KEEP_LIST_PROFILE = 1
    ATTRIBUTE_CONFIDENTIALITY_BASIC_PROFILE = 2
    KEEP_ALL_PROFILE = 3
    DEIDENTIFY_TAG_CONTENTS = 4

  filterProfile = _messages.EnumField('FilterProfileValueValuesEnum', 1)
  keepList = _messages.MessageField('TagFilterList', 2)
  removeList = _messages.MessageField('TagFilterList', 3)
  skipIdRedaction = _messages.BooleanField(4)


class DicomFilterConfig(_messages.Message):
  r"""Specifies the filter configuration for DICOM resources.

  Fields:
    resourcePathsGcsUri: The Cloud Storage location of the filter
      configuration file. The `gcs_uri` must be in the format
      `gs://bucket/path/to/object`. The filter configuration file must contain
      a list of resource paths separated by newline characters (\n or \r\n).
      Each resource path must be in the format
      "/studies/{studyUID}[/series/{seriesUID}[/instances/{instanceUID}]]"
      The Cloud Healthcare API service account must have the
      `roles/storage.objectViewer` Cloud IAM role for this Cloud Storage
      location.
  """

  resourcePathsGcsUri = _messages.StringField(1)


class DicomStore(_messages.Message):
  r"""Represents a DICOM store.

  Messages:
    LabelsValue: User-supplied key-value pairs used to organize DICOM stores.
      Label keys must be between 1 and 63 characters long, have a UTF-8
      encoding of maximum 128 bytes, and must conform to the following PCRE
      regular expression: \p{Ll}\p{Lo}{0,62}  Label values are optional, must
      be between 1 and 63 characters long, have a UTF-8 encoding of maximum
      128 bytes, and must conform to the following PCRE regular expression:
      [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be associated
      with a given store.

  Fields:
    labels: User-supplied key-value pairs used to organize DICOM stores.
      Label keys must be between 1 and 63 characters long, have a UTF-8
      encoding of maximum 128 bytes, and must conform to the following PCRE
      regular expression: \p{Ll}\p{Lo}{0,62}  Label values are optional, must
      be between 1 and 63 characters long, have a UTF-8 encoding of maximum
      128 bytes, and must conform to the following PCRE regular expression:
      [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be associated
      with a given store.
    name: Output only. Resource name of the DICOM store, of the form `projects
      /{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/
      {dicom_store_id}`.
    notificationConfig: Notification destination for new DICOM instances.
      Supplied by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""User-supplied key-value pairs used to organize DICOM stores.  Label
    keys must be between 1 and 63 characters long, have a UTF-8 encoding of
    maximum 128 bytes, and must conform to the following PCRE regular
    expression: \p{Ll}\p{Lo}{0,62}  Label values are optional, must be between
    1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and
    must conform to the following PCRE regular expression:
    [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be associated with
    a given store.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labels = _messages.MessageField('LabelsValue', 1)
  name = _messages.StringField(2)
  notificationConfig = _messages.MessageField('NotificationConfig', 3)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class ErrorDetail(_messages.Message):
  r"""Structure to describe the error encountered during batch operation on
  one resource. This is used both for sample errors in operation response, and
  for format of errors in error reports.

  Fields:
    error: The status of the error.
    resource: The identifier of the resource.
  """

  error = _messages.MessageField('Status', 1)
  resource = _messages.StringField(2)


class ExportDicomDataRequest(_messages.Message):
  r"""Exports data from the specified DICOM store. If a given resource, such
  as a DICOM object with the same SOPInstance UID, already exists in the
  output, it is overwritten with the version in the source dataset. Exported
  DICOM data persists when the DICOM store from which it was exported is
  deleted.

  Fields:
    bigqueryDestination: The BigQuery output destination.  You can only export
      to a BigQuery dataset that's in the same project as the DICOM store
      you're exporting from.  The BigQuery location requires two IAM roles:
      `roles/bigquery.dataEditor` and `roles/bigquery.jobUser`.
    gcsDestination: The Cloud Storage output destination.  The Cloud Storage
      location requires the `roles/storage.objectAdmin` Cloud IAM role.
  """

  bigqueryDestination = _messages.MessageField('GoogleCloudHealthcareV1beta1DicomBigQueryDestination', 1)
  gcsDestination = _messages.MessageField('GoogleCloudHealthcareV1beta1DicomGcsDestination', 2)


class ExportDicomDataResponse(_messages.Message):
  r"""Returns additional information in regards to a completed DICOM store
  export.
  """



class ExportResourcesRequest(_messages.Message):
  r"""Request to export resources.

  Fields:
    bigqueryDestination: The BigQuery output destination.  The BigQuery
      location requires two IAM roles: `roles/bigquery.dataEditor` and
      `roles/bigquery.jobUser`.  The output will be one BigQuery table per
      resource type.
    gcsDestination: The Cloud Storage output destination.  The Cloud Storage
      location requires the `roles/storage.objectAdmin` Cloud IAM role.  The
      exported outputs are organized by FHIR resource types. The server will
      create one object per resource type. Each object contains newline
      delimited JSON, and each line is a FHIR resource.
  """

  bigqueryDestination = _messages.MessageField('GoogleCloudHealthcareV1beta1FhirBigQueryDestination', 1)
  gcsDestination = _messages.MessageField('GoogleCloudHealthcareV1beta1FhirRestGcsDestination', 2)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec.  Example (Comparison):
  title: "Summary size limit"     description: "Determines if a summary is
  less than 100 chars"     expression: "document.summary.size() < 100"
  Example (Equality):      title: "Requestor is owner"     description:
  "Determines if requestor is the document owner"     expression:
  "document.owner == request.auth.claims.email"  Example (Logic):      title:
  "Public documents"     description: "Determine whether the document should
  be publicly visible"     expression: "document.type != 'private' &&
  document.type != 'internal'"  Example (Data Manipulation):      title:
  "Notification string"     description: "Create a notification string with a
  timestamp."     expression: "'New message received at ' +
  string(document.create_time)"  The exact variables and functions that may be
  referenced within an expression are determined by the service that evaluates
  it. See the service documentation for additional information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class FhirConfig(_messages.Message):
  r"""Specifies how to handle de-identification of a FHIR store.

  Fields:
    fieldMetadataList: Specifies FHIR paths to match and how to transform
      them. Any field that is not matched by a FieldMetadata is passed through
      to the output dataset unmodified. All extensions are removed in the
      output. If a field can be matched by more than one FieldMetadata, the
      first FieldMetadata.Action is applied.
  """

  fieldMetadataList = _messages.MessageField('FieldMetadata', 1, repeated=True)


class FhirFilter(_messages.Message):
  r"""Filter configuration.

  Fields:
    resources: List of resources to include in the output. If this list is
      empty or not specified, all resources are included in the output.
  """

  resources = _messages.MessageField('Resources', 1)


class FhirStore(_messages.Message):
  r"""Represents a FHIR store.

  Enums:
    VersionValueValuesEnum: The FHIR specification version that this FHIR
      store supports natively. This field is immutable after store creation.
      Requests are rejected if they contain FHIR resources of a different
      version. An empty value is treated as STU3.

  Messages:
    LabelsValue: User-supplied key-value pairs used to organize FHIR stores.
      Label keys must be between 1 and 63 characters long, have a UTF-8
      encoding of maximum 128 bytes, and must conform to the following PCRE
      regular expression: \p{Ll}\p{Lo}{0,62}  Label values are optional, must
      be between 1 and 63 characters long, have a UTF-8 encoding of maximum
      128 bytes, and must conform to the following PCRE regular expression:
      [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be associated
      with a given store.

  Fields:
    defaultSearchHandlingStrict: If true, overrides the default search
      behavior for this FHIR store to `handling=strict` which returns an error
      for unrecognized search parameters. If false, uses the FHIR
      specification default `handling=lenient` which ignores unrecognized
      search parameters. The handling can always be changed from the default
      on an individual API call by setting the HTTP header `Prefer:
      handling=strict` or `Prefer: handling=lenient`.
    disableReferentialIntegrity: Whether to disable referential integrity in
      this FHIR store. This field is immutable after FHIR store creation. The
      default value is false, meaning that the API enforces referential
      integrity and fails the requests that result in inconsistent state in
      the FHIR store. When this field is set to true, the API skips
      referential integrity checks. Consequently, operations that rely on
      references, such as GetPatientEverything, do not return all the results
      if broken references exist.
    disableResourceVersioning: Whether to disable resource versioning for this
      FHIR store. This field can not be changed after the creation of FHIR
      store. If set to false, which is the default behavior, all write
      operations cause historical versions to be recorded automatically. The
      historical versions can be fetched through the history APIs, but cannot
      be updated. If set to true, no historical versions are kept. The server
      sends errors for attempts to read the historical versions.
    enableUpdateCreate: Whether this FHIR store has the [updateCreate
      capability](https://www.hl7.org/fhir/capabilitystatement-
      definitions.html#CapabilityStatement.rest.resource.updateCreate). This
      determines if the client can use an Update operation to create a new
      resource with a client-specified ID. If false, all IDs are server-
      assigned through the Create operation and attempts to update a non-
      existent resource return errors. Please treat the audit logs with
      appropriate levels of care if client-specified resource IDs contain
      sensitive data such as patient identifiers, those IDs are part of the
      FHIR resource path recorded in Cloud audit logs and Cloud Pub/Sub
      notifications.
    labels: User-supplied key-value pairs used to organize FHIR stores.  Label
      keys must be between 1 and 63 characters long, have a UTF-8 encoding of
      maximum 128 bytes, and must conform to the following PCRE regular
      expression: \p{Ll}\p{Lo}{0,62}  Label values are optional, must be
      between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
      bytes, and must conform to the following PCRE regular expression:
      [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be associated
      with a given store.
    name: Output only. Resource name of the FHIR store, of the form
      `projects/{project_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`
      .
    notificationConfig: If non-empty, publish all resource modifications of
      this FHIR store to this destination. The Cloud Pub/Sub message
      attributes contain a map with a string describing the action that has
      triggered the notification. For example, "action":"CreateResource".
    streamConfigs: A list of streaming configs that configure the destinations
      of streaming export for every resource mutation in this FHIR store. Each
      store is allowed to have up to 10 streaming configs. After a new config
      is added, the next resource mutation is streamed to the new location in
      addition to the existing ones. When a location is removed from the list,
      the server stops streaming to that location. Before adding a new config,
      you must add the required
      [`bigquery.dataEditor`](https://cloud.google.com/bigquery/docs/access-
      control#bigquery.dataEditor) role to your project's **Cloud Healthcare
      Service Agent** [service account](https://cloud.google.com/iam/docs
      /service-accounts). Some lag (typically on the order of dozens of
      seconds) is expected before the results show up in the streaming
      destination.
    version: The FHIR specification version that this FHIR store supports
      natively. This field is immutable after store creation. Requests are
      rejected if they contain FHIR resources of a different version. An empty
      value is treated as STU3.
  """

  class VersionValueValuesEnum(_messages.Enum):
    r"""The FHIR specification version that this FHIR store supports natively.
    This field is immutable after store creation. Requests are rejected if
    they contain FHIR resources of a different version. An empty value is
    treated as STU3.

    Values:
      VERSION_UNSPECIFIED: VERSION_UNSPECIFIED is treated as STU3 to
        accommodate the existing FHIR stores.
      DSTU2: Draft Standard for Trial Use, [Release
        2](https://www.hl7.org/fhir/DSTU2)
      STU3: Standard for Trial Use, [Release 3](https://www.hl7.org/fhir/STU3)
      R4: [Release 4](https://www.hl7.org/fhir/R4)
    """
    VERSION_UNSPECIFIED = 0
    DSTU2 = 1
    STU3 = 2
    R4 = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""User-supplied key-value pairs used to organize FHIR stores.  Label
    keys must be between 1 and 63 characters long, have a UTF-8 encoding of
    maximum 128 bytes, and must conform to the following PCRE regular
    expression: \p{Ll}\p{Lo}{0,62}  Label values are optional, must be between
    1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and
    must conform to the following PCRE regular expression:
    [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be associated with
    a given store.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  defaultSearchHandlingStrict = _messages.BooleanField(1)
  disableReferentialIntegrity = _messages.BooleanField(2)
  disableResourceVersioning = _messages.BooleanField(3)
  enableUpdateCreate = _messages.BooleanField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  notificationConfig = _messages.MessageField('NotificationConfig', 7)
  streamConfigs = _messages.MessageField('StreamConfig', 8, repeated=True)
  version = _messages.EnumField('VersionValueValuesEnum', 9)


class Field(_messages.Message):
  r"""A (sub) field of a type.

  Fields:
    maxOccurs: The maximum number of times this field can be repeated. 0 or -1
      means unbounded.
    minOccurs: The minimum number of times this field must be
      present/repeated.
    name: The name of the field. For example, "PID-1" or just "1".
    table: The HL7v2 table this field refers to. For example, PID-15
      (Patient's Primary Language) usually refers to table "0296".
    type: The type of this field. A Type with this name must be defined in an
      Hl7TypesConfig.
  """

  maxOccurs = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minOccurs = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  name = _messages.StringField(3)
  table = _messages.StringField(4)
  type = _messages.StringField(5)


class FieldMetadata(_messages.Message):
  r"""Specifies FHIR paths to match, and how to handle de-identification of
  matching fields.

  Enums:
    ActionValueValuesEnum: Deidentify action for one field.

  Fields:
    action: Deidentify action for one field.
    paths: List of paths to FHIR fields to redact. Each path is a period-
      separated list where each component is either a field name or FHIR type
      name. All types begin with an upper case letter. For example, the
      resource field "Patient.Address.city", which uses a string type, can be
      matched by "Patient.Address.String". Path also supports partial
      matching. For example, "Patient.Address.city" can be matched by
      "Address.city" (Patient omitted). Partial matching and type matching can
      be combined, for example "Patient.Address.city" can be matched by
      "Address.String". For "choice" types (those defined in the FHIR spec
      with the form: field[x]), use two separate components. For example,
      "deceasedAge.unit" is matched by "Deceased.Age.unit". Supported types
      are: AdministrativeGenderCode, Code, Date, DateTime, Decimal, HumanName,
      Id, LanguageCode, Markdown, Oid, String, Uri, Uuid, Xhtml. The sub-type
      for HumanName(for example HumanName.given, HumanName.family) can be
      omitted.
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""Deidentify action for one field.

    Values:
      ACTION_UNSPECIFIED: No action specified.
      TRANSFORM: Transform the entire field based on transformations specified
        in TextConfig. When the specified transformation cannot be applied to
        a field (for example, a Crypto Hash transformation cannot be applied
        to a FHIR Date field), RedactConfig is used.
      INSPECT_AND_TRANSFORM: Inspect and transform any found PHI.
      DO_NOT_TRANSFORM: Do not transform.
    """
    ACTION_UNSPECIFIED = 0
    TRANSFORM = 1
    INSPECT_AND_TRANSFORM = 2
    DO_NOT_TRANSFORM = 3

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  paths = _messages.StringField(2, repeated=True)


class GoogleCloudHealthcareV1beta1DeidentifyDeidentifyDicomStoreSummary(_messages.Message):
  r"""Contains a summary of the DeidentifyDicomStore operation.

  Fields:
    failureResourceCount: Number of objects that processing failed for.
    successResourceCount: Number of objects successfully processed.
  """

  failureResourceCount = _messages.IntegerField(1)
  successResourceCount = _messages.IntegerField(2)


class GoogleCloudHealthcareV1beta1DeidentifyDeidentifyFhirStoreSummary(_messages.Message):
  r"""Contains a summary of the DeidentifyFhirStore operation.

  Fields:
    successResourceCount: Number of resources successfully processed.
  """

  successResourceCount = _messages.IntegerField(1)


class GoogleCloudHealthcareV1beta1DicomBigQueryDestination(_messages.Message):
  r"""The BigQuery table where the server writes the output.

  Fields:
    force: If the destination table already exists and this flag is `TRUE`,
      the table is overwritten by the contents of the DICOM store. If the flag
      is not set and the destination table already exists, the export call
      returns an error.
    tableUri: BigQuery URI to a table, up to 2000 characters long, in the
      format `bq://projectId.bqDatasetId.tableId`
  """

  force = _messages.BooleanField(1)
  tableUri = _messages.StringField(2)


class GoogleCloudHealthcareV1beta1DicomGcsDestination(_messages.Message):
  r"""The Cloud Storage location where the server writes the output and the
  export configuration.

  Fields:
    mimeType: MIME types supported by DICOM spec. Each file is written in the
      following format:
      `.../{study_id}/{series_id}/{instance_id}[/{frame_number}].{extension}`
      The frame_number component exists only for multi-frame instances.
      Supported MIME types are consistent with supported formats in DICOMweb:
      https://cloud.google.com/healthcare/docs/dicom#retrieve_transaction.
      Specifically, the following are supported:    - application/dicom;
      transfer-syntax=1.2.840.10008.1.2.1     (uncompressed DICOM)   -
      application/dicom; transfer-syntax=1.2.840.10008.1.2.4.50     (DICOM
      with embedded JPEG Baseline)   - application/dicom; transfer-
      syntax=1.2.840.10008.1.2.4.90     (DICOM with embedded JPEG 2000
      Lossless Only)   - application/dicom; transfer-
      syntax=1.2.840.10008.1.2.4.91     (DICOM with embedded JPEG 2000)h   -
      application/dicom; transfer-syntax=*     (DICOM with no transcoding)   -
      application/octet-stream; transfer-syntax=1.2.840.10008.1.2.1     (raw
      uncompressed PixelData)   - application/octet-stream; transfer-syntax=*
      (raw PixelData in whatever format it was uploaded in)   - image/jpeg;
      transfer-syntax=1.2.840.10008.1.2.4.50     (Consumer JPEG)   - image/png
      The following extensions are used for output files:   -
      application/dicom -> .dcm  - image/jpeg -> .jpg  - image/png -> .png  -
      application/octet-stream -> no extension  If unspecified, the instances
      are exported in the original DICOM format they were uploaded in.
    uriPrefix: The Cloud Storage destination to export to.  URI for a Cloud
      Storage directory where the server writes the result files, in the
      format `gs://{bucket-id}/{path/to/destination/dir}`). If there is no
      trailing slash, the service appends one when composing the object path.
      The user is responsible for creating the Cloud Storage bucket referenced
      in `uri_prefix`.
  """

  mimeType = _messages.StringField(1)
  uriPrefix = _messages.StringField(2)


class GoogleCloudHealthcareV1beta1DicomGcsSource(_messages.Message):
  r"""Specifies the configuration for importing data from Cloud Storage.

  Fields:
    uri: Points to a Cloud Storage URI containing file(s) with content only.
      The URI must be in the following format: `gs://{bucket_id}/{object_id}`.
      The URI can include wildcards in `object_id` and thus identify multiple
      files. Supported wildcards:  '*' to match 0 or more non-separator
      characters  '**' to match 0 or more characters (including separators).
      Must be used at       the end of a path and with no other wildcards in
      the       path. Can also be used with a file extension (such as .dcm),
      which       imports all files with the extension in the specified
      directory and       its sub-directories. For example,       `gs://my-
      bucket/my-directory/**.dcm` imports all files with .dcm       extensions
      in `my-directory/` and its sub-directories.  '?' to match 1 character
      All other URI formats are invalid. Files matching the wildcard are
      expected to contain content only, no metadata.
  """

  uri = _messages.StringField(1)


class GoogleCloudHealthcareV1beta1FhirBigQueryDestination(_messages.Message):
  r"""The configuration for exporting to BigQuery.

  Fields:
    datasetUri: BigQuery URI to a dataset, up to 2000 characters long, in the
      format `bq://projectId.bqDatasetId`
    force: If this flag is `TRUE`, all tables will be deleted from the dataset
      before the new exported tables are written. If the flag is not set and
      the destination dataset contains tables, the export call returns an
      error.
    schemaConfig: The configuration for the exported BigQuery schema.
  """

  datasetUri = _messages.StringField(1)
  force = _messages.BooleanField(2)
  schemaConfig = _messages.MessageField('SchemaConfig', 3)


class GoogleCloudHealthcareV1beta1FhirRestExportResourcesErrorDetails(_messages.Message):
  r"""Response when errors occur while exporting resources. This structure is
  included in the error details to describe the detailed outcome. It is only
  included when the operation finishes with errors.

  Fields:
    errorCount: The number of resources that had errors.
    fhirStore: The name of the FHIR store where resources have been exported,
      in the format `projects/{project_id}/locations/{location_id}/datasets/{d
      ataset_id}/fhirStores/{fhir_store_id}`.
    resourceCount: The total number of resources included in the export
      operation. This is the sum of the success and error counts.
    successCount: The number of resources that were exported.
  """

  errorCount = _messages.IntegerField(1)
  fhirStore = _messages.StringField(2)
  resourceCount = _messages.IntegerField(3)
  successCount = _messages.IntegerField(4)


class GoogleCloudHealthcareV1beta1FhirRestExportResourcesResponse(_messages.Message):
  r"""Response when all resources export successfully. This structure will be
  included in the response to describe the detailed outcome. It will only be
  included when the operation finishes successfully.

  Fields:
    fhirStore: The name of the FHIR store where resources have been exported,
      in the format `projects/{project_id}/locations/{location_id}/datasets/{d
      ataset_id}/fhirStores/{fhir_store_id}`.
    resourceCount: The total number of resources exported from the requested
      FHIR store.
  """

  fhirStore = _messages.StringField(1)
  resourceCount = _messages.IntegerField(2)


class GoogleCloudHealthcareV1beta1FhirRestGcsDestination(_messages.Message):
  r"""The configuration for exporting to Cloud Storage.

  Fields:
    uriPrefix: URI for a Cloud Storage directory where result files should be
      written (in the format `gs://{bucket-id}/{path/to/destination/dir}`). If
      there is no trailing slash, the service will append one when composing
      the object path. The user is responsible for creating the Cloud Storage
      bucket referenced in `uri_prefix`.
  """

  uriPrefix = _messages.StringField(1)


class GoogleCloudHealthcareV1beta1FhirRestGcsSource(_messages.Message):
  r"""Specifies the configuration for importing data from Cloud Storage.

  Fields:
    uri: Points to a Cloud Storage URI containing file(s) to import.  The URI
      must be in the following format: `gs://{bucket_id}/{object_id}`. The URI
      can include wildcards in `object_id` and thus identify multiple files.
      Supported wildcards:  *  `*` to match 0 or more non-separator characters
      *  `**` to match 0 or more characters (including separators). Must be
      used at the end of a path and with no other wildcards in the path. Can
      also be used with a file extension (such as .ndjson), which imports all
      files with the extension in the specified directory and its sub-
      directories. For example, `gs://my-bucket/my-directory/**.ndjson`
      imports all files with `.ndjson` extensions in `my-directory/` and its
      sub-directories. *  `?` to match 1 character  Files matching the
      wildcard are expected to contain content only, no metadata.
  """

  uri = _messages.StringField(1)


class GoogleCloudHealthcareV1beta1FhirRestImportResourcesErrorDetails(_messages.Message):
  r"""Error response of importing resources. This structure will be included
  in the error details to describe the detailed error. It will only be
  included when the operation finishes with some failure.

  Fields:
    errorCount: The number of resources that had errors.
    fhirStore: The name of the FHIR store where resources have been imported,
      in the format `projects/{project_id}/locations/{location_id}/datasets/{d
      ataset_id}/fhirStores/{fhir_store_id}`.
    inputSize: The total number of resources included in the source data. This
      is the sum of the success and error counts.
    successCount: The number of resources that have been imported.
  """

  errorCount = _messages.IntegerField(1)
  fhirStore = _messages.StringField(2)
  inputSize = _messages.IntegerField(3)
  successCount = _messages.IntegerField(4)


class GoogleCloudHealthcareV1beta1FhirRestImportResourcesResponse(_messages.Message):
  r"""Final response of importing resources. This structure will be included
  in the response to describe the detailed outcome. It will only be included
  when the operation finishes successfully.

  Fields:
    fhirStore: The name of the FHIR store where the resources have been
      imported, in the format `projects/{project_id}/locations/{location_id}/d
      atasets/{dataset_id}/fhirStores/{fhir_store_id}`.
    inputSize: The total number of resources included in the source data.
  """

  fhirStore = _messages.StringField(1)
  inputSize = _messages.IntegerField(2)


class GroupOrSegment(_messages.Message):
  r"""Construct representing a logical group or a segment.

  Fields:
    group: A SchemaGroup attribute.
    segment: A SchemaSegment attribute.
  """

  group = _messages.MessageField('SchemaGroup', 1)
  segment = _messages.MessageField('SchemaSegment', 2)


class HealthcareProjectsLocationsDatasetsAnnotationStoresGetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsAnnotationStoresGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.  Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.  Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsAnnotationStoresSetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsAnnotationStoresSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class HealthcareProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class HealthcareProjectsLocationsDatasetsCreateRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsCreateRequest object.

  Fields:
    dataset: A Dataset resource to be passed as the request body.
    datasetId: The ID of the dataset that is being created. The string must
      match the following regex: `[\p{L}\p{N}_\-\.]{1,256}`.
    parent: The name of the project where the server creates the dataset. For
      example, `projects/{project_id}/locations/{location_id}`.
  """

  dataset = _messages.MessageField('Dataset', 1)
  datasetId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsDeidentifyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDeidentifyRequest object.

  Fields:
    deidentifyDatasetRequest: A DeidentifyDatasetRequest resource to be passed
      as the request body.
    sourceDataset: Source dataset resource name. For example,
      `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
  """

  deidentifyDatasetRequest = _messages.MessageField('DeidentifyDatasetRequest', 1)
  sourceDataset = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDeleteRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDeleteRequest object.

  Fields:
    name: The name of the dataset to delete. For example,
      `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresCreateRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresCreateRequest object.

  Fields:
    dicomStore: A DicomStore resource to be passed as the request body.
    dicomStoreId: The ID of the DICOM store that is being created. Any string
      value up to 256 characters in length.
    parent: The name of the dataset this DICOM store belongs to.
  """

  dicomStore = _messages.MessageField('DicomStore', 1)
  dicomStoreId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresDeidentifyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresDeidentifyRequest
  object.

  Fields:
    deidentifyDicomStoreRequest: A DeidentifyDicomStoreRequest resource to be
      passed as the request body.
    sourceStore: Source DICOM store resource name. For example, `projects/{pro
      ject_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dico
      m_store_id}`.
  """

  deidentifyDicomStoreRequest = _messages.MessageField('DeidentifyDicomStoreRequest', 1)
  sourceStore = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresDeleteRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresDeleteRequest object.

  Fields:
    name: The resource name of the DICOM store to delete.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresExportRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresExportRequest object.

  Fields:
    exportDicomDataRequest: A ExportDicomDataRequest resource to be passed as
      the request body.
    name: The DICOM store resource name from which to export the data. For
      example, `projects/{project_id}/locations/{location_id}/datasets/{datase
      t_id}/dicomStores/{dicom_store_id}`.
  """

  exportDicomDataRequest = _messages.MessageField('ExportDicomDataRequest', 1)
  name = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresGetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.  Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.  Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresGetRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresGetRequest object.

  Fields:
    name: The resource name of the DICOM store to get.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresImportRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresImportRequest object.

  Fields:
    importDicomDataRequest: A ImportDicomDataRequest resource to be passed as
      the request body.
    name: The name of the DICOM store resource into which the data is
      imported. For example, `projects/{project_id}/locations/{location_id}/da
      tasets/{dataset_id}/dicomStores/{dicom_store_id}`.
  """

  importDicomDataRequest = _messages.MessageField('ImportDicomDataRequest', 1)
  name = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresListRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresListRequest object.

  Fields:
    filter: Restricts stores returned to those matching a filter. Syntax: http
      s://cloud.google.com/appengine/docs/standard/python/search/query_strings
      Only filtering on labels is supported. For example, `labels.key=value`.
    pageSize: Limit on the number of DICOM stores to return in a single
      response. If zero the default page size of 100 is used.
    pageToken: The next_page_token value returned from the previous List
      request, if any.
    parent: Name of the dataset.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresPatchRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresPatchRequest object.

  Fields:
    dicomStore: A DicomStore resource to be passed as the request body.
    name: Output only. Resource name of the DICOM store, of the form `projects
      /{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/
      {dicom_store_id}`.
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  dicomStore = _messages.MessageField('DicomStore', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class HealthcareProjectsLocationsDatasetsDicomStoresSearchForInstancesRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsDicomStoresSearchForInstancesRequest
  object.

  Fields:
    dicomWebPath: The path of the SearchForInstancesRequest DICOMweb request.
      For example, `instances`, `series/{series_uid}/instances`, or
      `studies/{study_uid}/instances`.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresSearchForSeriesRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresSearchForSeriesRequest
  object.

  Fields:
    dicomWebPath: The path of the SearchForSeries DICOMweb request. For
      example, `series` or `studies/{study_uid}/series`.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresSearchForStudiesRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresSearchForStudiesRequest
  object.

  Fields:
    dicomWebPath: The path of the SearchForStudies DICOMweb request. For
      example, `studies`.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresSetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class HealthcareProjectsLocationsDatasetsDicomStoresStoreInstancesRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresStoreInstancesRequest
  object.

  Fields:
    dicomWebPath: The path of the StoreInstances DICOMweb request. For
      example, `studies/[{study_uid}]`. Note that the `study_uid` is optional.
    httpBody: A HttpBody resource to be passed as the request body.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  httpBody = _messages.MessageField('HttpBody', 2)
  parent = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresStudiesDeleteRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresStudiesDeleteRequest
  object.

  Fields:
    dicomWebPath: The path of the DeleteStudy request. For example,
      `studies/{study_uid}`.
    parent: A string attribute.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsDicomStoresStudiesRetrieveMetadataRequest
  object.

  Fields:
    dicomWebPath: The path of the RetrieveStudyMetadata DICOMweb request. For
      example, `studies/{study_uid}/metadata`.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsDicomStoresStudiesRetrieveStudyRequest
  object.

  Fields:
    dicomWebPath: The path of the RetrieveStudy DICOMweb request. For example,
      `studies/{study_uid}`.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresStudiesSearchForInstancesRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresStudiesSearchForInstance
  sRequest object.

  Fields:
    dicomWebPath: The path of the SearchForInstancesRequest DICOMweb request.
      For example, `instances`, `series/{series_uid}/instances`, or
      `studies/{study_uid}/instances`.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsDicomStoresStudiesSearchForSeriesRequest
  object.

  Fields:
    dicomWebPath: The path of the SearchForSeries DICOMweb request. For
      example, `series` or `studies/{study_uid}/series`.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesDeleteRequest
  object.

  Fields:
    dicomWebPath: The path of the DeleteSeries request. For example,
      `studies/{study_uid}/series/{series_uid}`.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDeleteRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesDe
  leteRequest object.

  Fields:
    dicomWebPath: The path of the DeleteInstance request. For example,
      `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}`.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveFramesRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFr
  amesRetrieveFramesRequest object.

  Fields:
    dicomWebPath: The path of the RetrieveFrames DICOMweb request. For
      example, `studies/{study_uid}/series/{series_uid}/instances/{instance_ui
      d}/frames/{frame_list}`.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFramesRetrieveRenderedRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesFr
  amesRetrieveRenderedRequest object.

  Fields:
    dicomWebPath: The path of the RetrieveRenderedFrames DICOMweb request. For
      example, `studies/{study_uid}/series/{series_uid}/instances/{instance_ui
      d}/frames/{frame_list}/rendered`.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveInstanceRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRe
  trieveInstanceRequest object.

  Fields:
    dicomWebPath: The path of the RetrieveInstance DICOMweb request. For
      example,
      `studies/{study_uid}/series/{series_uid}/instances/{instance_uid}`.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveMetadataRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRe
  trieveMetadataRequest object.

  Fields:
    dicomWebPath: The path of the RetrieveInstanceMetadata DICOMweb request.
      For example, `studies/{study_uid}/series/{series_uid}/instances/{instanc
      e_uid}/metadata`.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRetrieveRenderedRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesInstancesRe
  trieveRenderedRequest object.

  Fields:
    dicomWebPath: The path of the RetrieveRenderedInstance DICOMweb request.
      For example, `studies/{study_uid}/series/{series_uid}/instances/{instanc
      e_uid}/rendered`.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMetadataRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveMet
  adataRequest object.

  Fields:
    dicomWebPath: The path of the RetrieveSeriesMetadata DICOMweb request. For
      example, `studies/{study_uid}/series/{series_uid}/metadata`.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSeriesRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesRetrieveSer
  iesRequest object.

  Fields:
    dicomWebPath: The path of the RetrieveSeries DICOMweb request. For
      example, `studies/{study_uid}/series/{series_uid}`.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForInstancesRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresStudiesSeriesSearchForIn
  stancesRequest object.

  Fields:
    dicomWebPath: The path of the SearchForInstancesRequest DICOMweb request.
      For example, `instances`, `series/{series_uid}/instances`, or
      `studies/{study_uid}/instances`.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsDicomStoresStudiesStoreInstancesRequest
  object.

  Fields:
    dicomWebPath: The path of the StoreInstances DICOMweb request. For
      example, `studies/[{study_uid}]`. Note that the `study_uid` is optional.
    httpBody: A HttpBody resource to be passed as the request body.
    parent: The name of the DICOM store that is being accessed. For example, `
      projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dico
      mStores/{dicom_store_id}`.
  """

  dicomWebPath = _messages.StringField(1, required=True)
  httpBody = _messages.MessageField('HttpBody', 2)
  parent = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresTestIamPermissionsRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsDicomStoresTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class HealthcareProjectsLocationsDatasetsFhirStoresCreateRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresCreateRequest object.

  Fields:
    fhirStore: A FhirStore resource to be passed as the request body.
    fhirStoreId: The ID of the FHIR store that is being created. The string
      must match the following regex: `[\p{L}\p{N}_\-\.]{1,256}`.
    parent: The name of the dataset this FHIR store belongs to.
  """

  fhirStore = _messages.MessageField('FhirStore', 1)
  fhirStoreId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresDeidentifyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresDeidentifyRequest object.

  Fields:
    deidentifyFhirStoreRequest: A DeidentifyFhirStoreRequest resource to be
      passed as the request body.
    sourceStore: Source FHIR store resource name. For example, `projects/{proj
      ect_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_s
      tore_id}`.
  """

  deidentifyFhirStoreRequest = _messages.MessageField('DeidentifyFhirStoreRequest', 1)
  sourceStore = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresDeleteRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresDeleteRequest object.

  Fields:
    name: The resource name of the FHIR store to delete.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresExportRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresExportRequest object.

  Fields:
    exportResourcesRequest: A ExportResourcesRequest resource to be passed as
      the request body.
    name: The name of the FHIR store to export resource from. The name should
      be in the format of `projects/{project_id}/locations/{location_id}/datas
      ets/{dataset_id}/fhirStores/{fhir_store_id}`.
  """

  exportResourcesRequest = _messages.MessageField('ExportResourcesRequest', 1)
  name = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresFhirCapabilitiesRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresFhirCapabilitiesRequest
  object.

  Fields:
    name: Name of the FHIR store to retrieve the capabilities for.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalDeleteRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalDeleteRequest
  object.

  Fields:
    parent: The name of the FHIR store this resource belongs to.
    type: The FHIR resource type to delete, such as Patient or Observation.
      For a complete list, see the FHIR Resource Index ([DSTU2](http://hl7.org
      /implement/standards/fhir/DSTU2/resourcelist.html),
      [STU3](http://hl7.org/implement/standards/fhir/STU3/resourcelist.html),
      [R4](http://hl7.org/implement/standards/fhir/R4/resourcelist.html)).
  """

  parent = _messages.StringField(1, required=True)
  type = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalPatchRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalPatchRequest
  object.

  Fields:
    httpBody: A HttpBody resource to be passed as the request body.
    parent: The name of the FHIR store this resource belongs to.
    type: The FHIR resource type to update, such as Patient or Observation.
      For a complete list, see the FHIR Resource Index ([DSTU2](http://hl7.org
      /implement/standards/fhir/DSTU2/resourcelist.html),
      [STU3](http://hl7.org/implement/standards/fhir/STU3/resourcelist.html),
      [R4](http://hl7.org/implement/standards/fhir/R4/resourcelist.html)).
  """

  httpBody = _messages.MessageField('HttpBody', 1)
  parent = _messages.StringField(2, required=True)
  type = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalUpdateRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsFhirStoresFhirConditionalUpdateRequest
  object.

  Fields:
    httpBody: A HttpBody resource to be passed as the request body.
    parent: The name of the FHIR store this resource belongs to.
    type: The FHIR resource type to update, such as Patient or Observation.
      For a complete list, see the FHIR Resource Index ([DSTU2](http://hl7.org
      /implement/standards/fhir/DSTU2/resourcelist.html),
      [STU3](http://hl7.org/implement/standards/fhir/STU3/resourcelist.html),
      [R4](http://hl7.org/implement/standards/fhir/R4/resourcelist.html)).
      Must match the resource type in the provided content.
  """

  httpBody = _messages.MessageField('HttpBody', 1)
  parent = _messages.StringField(2, required=True)
  type = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresFhirCreateRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresFhirCreateRequest object.

  Fields:
    httpBody: A HttpBody resource to be passed as the request body.
    parent: The name of the FHIR store this resource belongs to.
    type: The FHIR resource type to create, such as Patient or Observation.
      For a complete list, see the FHIR Resource Index ([DSTU2](http://hl7.org
      /implement/standards/fhir/DSTU2/resourcelist.html),
      [STU3](http://hl7.org/implement/standards/fhir/STU3/resourcelist.html),
      [R4](http://hl7.org/implement/standards/fhir/R4/resourcelist.html)).
      Must match the resource type in the provided content.
  """

  httpBody = _messages.MessageField('HttpBody', 1)
  parent = _messages.StringField(2, required=True)
  type = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresFhirDeleteRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresFhirDeleteRequest object.

  Fields:
    name: The name of the resource to delete.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresFhirExecuteBundleRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresFhirExecuteBundleRequest
  object.

  Fields:
    httpBody: A HttpBody resource to be passed as the request body.
    parent: Name of the FHIR store in which this bundle will be executed.
  """

  httpBody = _messages.MessageField('HttpBody', 1)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresFhirHistoryRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresFhirHistoryRequest
  object.

  Fields:
    _at: Only include resource versions that were current at some point during
      the time period specified in the date time value. The date parameter
      format is yyyy-mm-ddThh:mm:ss[Z|(+|-)hh:mm]  Clients may specify any of
      the following:  *  An entire year: `_at=2019` *  An entire month:
      `_at=2019-01` *  A specific day: `_at=2019-01-20` *  A specific second:
      `_at=2018-12-31T23:59:58Z`
    _count: The maximum number of search results on a page. Defaults to 1000.
    _page_token: Used to retrieve the first, previous, next, or last page of
      resource versions when using pagination. Value should be set to the
      value of `_page_token` set in next or previous page links' URLs. Next
      and previous page are returned in the response bundle's links field,
      where `link.relation` is "previous" or "next".  Omit `_page_token` if no
      previous request has been made.
    _since: Only include resource versions that were created at or after the
      given instant in time. The instant in time uses the format YYYY-MM-
      DDThh:mm:ss.sss+zz:zz (for example 2015-02-07T13:28:17.239+02:00 or
      2017-01-01T00:00:00Z). The time must be specified to the second and
      include a time zone.
    name: The name of the resource to retrieve.
  """

  _at = _messages.StringField(1)
  _count = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  _page_token = _messages.StringField(3)
  _since = _messages.StringField(4)
  name = _messages.StringField(5, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresFhirObservationLastnRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsFhirStoresFhirObservationLastnRequest
  object.

  Fields:
    parent: Name of the FHIR store to retrieve resources from.
  """

  parent = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresFhirPatchRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresFhirPatchRequest object.

  Fields:
    httpBody: A HttpBody resource to be passed as the request body.
    name: The name of the resource to update.
  """

  httpBody = _messages.MessageField('HttpBody', 1)
  name = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresFhirPatientEverythingRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsFhirStoresFhirPatientEverythingRequest
  object.

  Fields:
    _count: Maximum number of resources in a page. Defaults to 100.
    _page_token: Used to retrieve the next or previous page of results when
      using pagination. Value should be set to the value of page_token set in
      next or previous page links' urls. Next and previous page are returned
      in the response bundle's links field, where `link.relation` is
      "previous" or "next".  Omit `page_token` if no previous request has been
      made.
    end: The response includes records prior to the end date. If no end date
      is provided, all records subsequent to the start date are in scope.
    name: Name of the `Patient` resource for which the information is
      required.
    start: The response includes records subsequent to the start date. If no
      start date is provided, all records prior to the end date are in scope.
  """

  _count = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  _page_token = _messages.StringField(2)
  end = _messages.StringField(3)
  name = _messages.StringField(4, required=True)
  start = _messages.StringField(5)


class HealthcareProjectsLocationsDatasetsFhirStoresFhirReadRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresFhirReadRequest object.

  Fields:
    name: The name of the resource to retrieve.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresFhirResourcePurgeRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresFhirResourcePurgeRequest
  object.

  Fields:
    name: The name of the resource to purge.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresFhirSearchRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresFhirSearchRequest object.

  Fields:
    parent: Name of the FHIR store to retrieve resources from.
    searchResourcesRequest: A SearchResourcesRequest resource to be passed as
      the request body.
  """

  parent = _messages.StringField(1, required=True)
  searchResourcesRequest = _messages.MessageField('SearchResourcesRequest', 2)


class HealthcareProjectsLocationsDatasetsFhirStoresFhirUpdateRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresFhirUpdateRequest object.

  Fields:
    httpBody: A HttpBody resource to be passed as the request body.
    name: The name of the resource to update.
  """

  httpBody = _messages.MessageField('HttpBody', 1)
  name = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresFhirVreadRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresFhirVreadRequest object.

  Fields:
    name: The name of the resource version to retrieve.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresGetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.  Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.  Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresGetRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresGetRequest object.

  Fields:
    name: The resource name of the FHIR store to get.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresImportRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresImportRequest object.

  Fields:
    importResourcesRequest: A ImportResourcesRequest resource to be passed as
      the request body.
    name: The name of the FHIR store to import FHIR resources to. The name
      should be in the format of `projects/{project_id}/locations/{location_id
      }/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
  """

  importResourcesRequest = _messages.MessageField('ImportResourcesRequest', 1)
  name = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresListRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresListRequest object.

  Fields:
    filter: Restricts stores returned to those matching a filter. Syntax: http
      s://cloud.google.com/appengine/docs/standard/python/search/query_strings
      Only filtering on labels is supported, for example `labels.key=value`.
    pageSize: Limit on the number of FHIR stores to return in a single
      response.  If zero the default page size of 100 is used.
    pageToken: The next_page_token value returned from the previous List
      request, if any.
    parent: Name of the dataset.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresPatchRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresPatchRequest object.

  Fields:
    fhirStore: A FhirStore resource to be passed as the request body.
    name: Output only. Resource name of the FHIR store, of the form
      `projects/{project_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`
      .
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  fhirStore = _messages.MessageField('FhirStore', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class HealthcareProjectsLocationsDatasetsFhirStoresSearchRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresSearchRequest object.

  Fields:
    parent: Name of the FHIR store to retrieve resources from.
    resourceType: The FHIR resource type to search, such as Patient or
      Observation. For a complete list, see the FHIR Resource Index ([DSTU2](h
      ttp://hl7.org/implement/standards/fhir/DSTU2/resourcelist.html),
      [STU3](http://hl7.org/implement/standards/fhir/STU3/resourcelist.html),
      [R4](http://hl7.org/implement/standards/fhir/R4/resourcelist.html)).
  """

  parent = _messages.StringField(1, required=True)
  resourceType = _messages.StringField(2)


class HealthcareProjectsLocationsDatasetsFhirStoresSetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class HealthcareProjectsLocationsDatasetsFhirStoresTestIamPermissionsRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class HealthcareProjectsLocationsDatasetsGetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.  Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.  Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsGetRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsGetRequest object.

  Fields:
    name: The name of the dataset to read. For example,
      `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresCreateRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresCreateRequest object.

  Fields:
    hl7V2Store: A Hl7V2Store resource to be passed as the request body.
    hl7V2StoreId: The ID of the HL7v2 store that is being created. The string
      must match the following regex: `[\p{L}\p{N}_\-\.]{1,256}`.
    parent: The name of the dataset this HL7v2 store belongs to.
  """

  hl7V2Store = _messages.MessageField('Hl7V2Store', 1)
  hl7V2StoreId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresDeleteRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresDeleteRequest object.

  Fields:
    name: The resource name of the HL7v2 store to delete.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresGetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned.  Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.  Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresGetRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresGetRequest object.

  Fields:
    name: The resource name of the HL7v2 store to get.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresListRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresListRequest object.

  Fields:
    filter: Restricts stores returned to those matching a filter. Syntax: http
      s://cloud.google.com/appengine/docs/standard/python/search/query_strings
      Only filtering on labels is supported. For example, `labels.key=value`.
    pageSize: Limit on the number of HL7v2 stores to return in a single
      response. If zero the default page size of 100 is used.
    pageToken: The next_page_token value returned from the previous List
      request, if any.
    parent: Name of the dataset.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesCreateRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesCreateRequest
  object.

  Fields:
    createMessageRequest: A CreateMessageRequest resource to be passed as the
      request body.
    parent: The name of the dataset this message belongs to.
  """

  createMessageRequest = _messages.MessageField('CreateMessageRequest', 1)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesDeleteRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesDeleteRequest
  object.

  Fields:
    name: The resource name of the HL7v2 message to delete.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesGetRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesGetRequest
  object.

  Enums:
    ViewValueValuesEnum: Specifies which parts of the Message resource to
      return in the response. When unspecified, equivalent to FULL.

  Fields:
    name: The resource name of the HL7v2 message to retrieve.
    view: Specifies which parts of the Message resource to return in the
      response. When unspecified, equivalent to FULL.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Specifies which parts of the Message resource to return in the
    response. When unspecified, equivalent to FULL.

    Values:
      MESSAGE_VIEW_UNSPECIFIED: <no description>
      RAW_ONLY: <no description>
      PARSED_ONLY: <no description>
      FULL: <no description>
      BASIC: <no description>
    """
    MESSAGE_VIEW_UNSPECIFIED = 0
    RAW_ONLY = 1
    PARSED_ONLY = 2
    FULL = 3
    BASIC = 4

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesIngestRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesIngestRequest
  object.

  Fields:
    ingestMessageRequest: A IngestMessageRequest resource to be passed as the
      request body.
    parent: The name of the HL7v2 store this message belongs to.
  """

  ingestMessageRequest = _messages.MessageField('IngestMessageRequest', 1)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesListRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesListRequest
  object.

  Enums:
    ViewValueValuesEnum: Specifies the parts of the Message to return in the
      response. When unspecified, equivalent to BASIC. Setting this to
      anything other than BASIC with a `page_size` larger than the default can
      generate a large response, which impacts the performance of this method.

  Fields:
    filter: Restricts messages returned to those matching a filter. Syntax: ht
      tps://cloud.google.com/appengine/docs/standard/python/search/query_strin
      gs  Fields/functions available for filtering are:  *  `message_type`,
      from the MSH-9.1 field. For example, `NOT message_type = "ADT"`. *
      `send_date` or `sendDate`, the YYYY-MM-DD date the message was sent in
      the dataset's time_zone, from the MSH-7 segment. For example, `send_date
      < "2017-01-02"`. *  `send_time`, the timestamp when the message was
      sent, using the RFC3339 time format for comparisons, from the MSH-7
      segment. For example, `send_time < "2017-01-02T00:00:00-05:00"`. *
      `send_facility`, the care center that the message came from, from the
      MSH-4 segment. For example, `send_facility = "ABC"`. *
      `PatientId(value, type)`, which matches if the message lists a patient
      having an ID of the given value and type in the PID-2, PID-3, or PID-4
      segments. For example, `PatientId("123456", "MRN")`. *  `labels.x`, a
      string value of the label with key `x` as set using the Message.labels
      map. For example, `labels."priority"="high"`. The operator `:*` can be
      used to assert the existence of a label. For example,
      `labels."priority":*`.
    orderBy: Orders messages returned by the specified order_by clause.
      Syntax:
      https://cloud.google.com/apis/design/design_patterns#sorting_order
      Fields available for ordering are:  *  `send_time`
    pageSize: Limit on the number of messages to return in a single response.
      If zero the default page size of 100 is used.
    pageToken: The next_page_token value returned from the previous List
      request, if any.
    parent: Name of the HL7v2 store to retrieve messages from.
    view: Specifies the parts of the Message to return in the response. When
      unspecified, equivalent to BASIC. Setting this to anything other than
      BASIC with a `page_size` larger than the default can generate a large
      response, which impacts the performance of this method.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Specifies the parts of the Message to return in the response. When
    unspecified, equivalent to BASIC. Setting this to anything other than
    BASIC with a `page_size` larger than the default can generate a large
    response, which impacts the performance of this method.

    Values:
      MESSAGE_VIEW_UNSPECIFIED: <no description>
      RAW_ONLY: <no description>
      PARSED_ONLY: <no description>
      FULL: <no description>
      BASIC: <no description>
    """
    MESSAGE_VIEW_UNSPECIFIED = 0
    RAW_ONLY = 1
    PARSED_ONLY = 2
    FULL = 3
    BASIC = 4

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 6)


class HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesPatchRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesPatchRequest
  object.

  Fields:
    message: A Message resource to be passed as the request body.
    name: Resource name of the Message, of the form `projects/{project_id}/dat
      asets/{dataset_id}/hl7V2Stores/{hl7_v2_store_id}/messages/{message_id}`.
      Assigned by the server.
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  message = _messages.MessageField('Message', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class HealthcareProjectsLocationsDatasetsHl7V2StoresPatchRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresPatchRequest object.

  Fields:
    hl7V2Store: A Hl7V2Store resource to be passed as the request body.
    name: Output only. Resource name of the HL7v2 store, of the form `projects
      /{project_id}/datasets/{dataset_id}/hl7V2Stores/{hl7v2_store_id}`.
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  hl7V2Store = _messages.MessageField('Hl7V2Store', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class HealthcareProjectsLocationsDatasetsHl7V2StoresSetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class HealthcareProjectsLocationsDatasetsHl7V2StoresTestIamPermissionsRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsHl7V2StoresTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class HealthcareProjectsLocationsDatasetsListRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsListRequest object.

  Fields:
    pageSize: The maximum number of items to return. Capped to 100 if not
      specified. May not be larger than 1000.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: The name of the project whose datasets should be listed. For
      example, `projects/{project_id}/locations/{location_id}`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsOperationsCancelRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsOperationsGetRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsOperationsListRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class HealthcareProjectsLocationsDatasetsPatchRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsPatchRequest object.

  Fields:
    dataset: A Dataset resource to be passed as the request body.
    name: Output only. Resource name of the dataset, of the form
      `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  dataset = _messages.MessageField('Dataset', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class HealthcareProjectsLocationsDatasetsSetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class HealthcareProjectsLocationsDatasetsTestIamPermissionsRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class HealthcareProjectsLocationsGetRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsListRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class Hl7SchemaConfig(_messages.Message):
  r"""Root config message for HL7v2 schema. This contains a schema structure
  of groups and segments, and filters that determine which messages to apply
  the schema structure to.

  Messages:
    MessageSchemaConfigsValue: Map from each HL7v2 message type and trigger
      event pair, such as ADT_A04, to its schema configuration root group.

  Fields:
    messageSchemaConfigs: Map from each HL7v2 message type and trigger event
      pair, such as ADT_A04, to its schema configuration root group.
    version: Each VersionSource is tested and only if they all match is the
      schema used for the message.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MessageSchemaConfigsValue(_messages.Message):
    r"""Map from each HL7v2 message type and trigger event pair, such as
    ADT_A04, to its schema configuration root group.

    Messages:
      AdditionalProperty: An additional property for a
        MessageSchemaConfigsValue object.

    Fields:
      additionalProperties: Additional properties of type
        MessageSchemaConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MessageSchemaConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A SchemaGroup attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('SchemaGroup', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  messageSchemaConfigs = _messages.MessageField('MessageSchemaConfigsValue', 1)
  version = _messages.MessageField('VersionSource', 2, repeated=True)


class Hl7TypesConfig(_messages.Message):
  r"""Root config for HL7v2 datatype definitions for a specific HL7v2 version.

  Fields:
    type: The HL7v2 type definitions.
    version: The version selectors that this config applies to. A message must
      match ALL version sources to apply.
  """

  type = _messages.MessageField('Type', 1, repeated=True)
  version = _messages.MessageField('VersionSource', 2, repeated=True)


class Hl7V2NotificationConfig(_messages.Message):
  r"""Specifies where and whether to send notifications upon changes to a data
  store.

  Fields:
    filter: Restricts notifications sent for messages matching a filter. If
      this is empty, all messages are matched. Syntax: https://cloud.google.co
      m/appengine/docs/standard/python/search/query_strings  Fields/functions
      available for filtering are:  *  `message_type`, from the MSH-9.1 field.
      For example, `NOT message_type = "ADT"`. *  `send_date` or `sendDate`,
      the YYYY-MM-DD date the message was sent in the dataset's time_zone,
      from the MSH-7 segment. For example, `send_date < "2017-01-02"`. *
      `send_time`, the timestamp when the message was sent, using the RFC3339
      time format for comparisons, from the MSH-7 segment. For example,
      `send_time < "2017-01-02T00:00:00-05:00"`. *  `send_facility`, the care
      center that the message came from, from the MSH-4 segment. For example,
      `send_facility = "ABC"`. *  `PatientId(value, type)`, which matches if
      the message lists a patient having an ID of the given value and type in
      the PID-2, PID-3, or PID-4 segments. For example, `PatientId("123456",
      "MRN")`. *  `labels.x`, a string value of the label with key `x` as set
      using the Message.labels map. For example, `labels."priority"="high"`.
      The operator `:*` can be used to assert the existence of a label. For
      example, `labels."priority":*`.
    pubsubTopic: The [Cloud Pubsub](https://cloud.google.com/pubsub/docs/)
      topic that notifications of changes are published on. Supplied by the
      client. The notification is a `PubsubMessage` with the following fields:
      *  `PubsubMessage.Data` contains the resource name. *
      `PubsubMessage.MessageId` is the ID of this notification. It is
      guaranteed to be unique within the topic. *  `PubsubMessage.PublishTime`
      is the time at which the message was published.  Note that notifications
      are only sent if the topic is non-empty. [Topic
      names](https://cloud.google.com/pubsub/docs/overview#names) must be
      scoped to a project. cloud-healthcare@system.gserviceaccount.com must
      have publisher permissions on the given Pubsub topic. Not having
      adequate permissions causes the calls that send notifications to fail.
      If a notification cannot be published to Cloud Pub/Sub, errors will be
      logged to Stackdriver (see [Viewing logs](/healthcare/docs/how- tos
      /stackdriver-logging)).
  """

  filter = _messages.StringField(1)
  pubsubTopic = _messages.StringField(2)


class Hl7V2Store(_messages.Message):
  r"""Represents an HL7v2 store.

  Messages:
    LabelsValue: User-supplied key-value pairs used to organize HL7v2 stores.
      Label keys must be between 1 and 63 characters long, have a UTF-8
      encoding of maximum 128 bytes, and must conform to the following PCRE
      regular expression: \p{Ll}\p{Lo}{0,62}  Label values are optional, must
      be between 1 and 63 characters long, have a UTF-8 encoding of maximum
      128 bytes, and must conform to the following PCRE regular expression:
      [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be associated
      with a given store.

  Fields:
    labels: User-supplied key-value pairs used to organize HL7v2 stores.
      Label keys must be between 1 and 63 characters long, have a UTF-8
      encoding of maximum 128 bytes, and must conform to the following PCRE
      regular expression: \p{Ll}\p{Lo}{0,62}  Label values are optional, must
      be between 1 and 63 characters long, have a UTF-8 encoding of maximum
      128 bytes, and must conform to the following PCRE regular expression:
      [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be associated
      with a given store.
    name: Output only. Resource name of the HL7v2 store, of the form `projects
      /{project_id}/datasets/{dataset_id}/hl7V2Stores/{hl7v2_store_id}`.
    notificationConfig: The notification destination all messages (both Ingest
      & Create) are published on. Only the message name is sent as part of the
      notification. If this is unset, no notifications are sent. Supplied by
      the client.
    notificationConfigs: A list of notification configs. Each configuration
      uses a filter to determine whether to publish a message (both Ingest &
      Create) on the corresponding notification destination. Only the message
      name is sent as part of the notification. Supplied by the client.
    parserConfig: The configuration for the parser. It determines how the
      server parses the messages.
    rejectDuplicateMessage: Determines whether duplicate messages should be
      rejected. A duplicate message is a message with the same raw bytes as a
      message that has already been ingested/created in this HL7v2 store. The
      default value is false, meaning that the store accepts the duplicate
      messages and it also returns the same ACK message in the
      IngestMessageResponse as has been returned previously. Note that only
      one resource is created in the store. When this field is set to true,
      CreateMessage/IngestMessage requests with a duplicate message will be
      rejected by the store, and IngestMessageErrorDetail returns a NACK
      message upon rejection.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""User-supplied key-value pairs used to organize HL7v2 stores.  Label
    keys must be between 1 and 63 characters long, have a UTF-8 encoding of
    maximum 128 bytes, and must conform to the following PCRE regular
    expression: \p{Ll}\p{Lo}{0,62}  Label values are optional, must be between
    1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and
    must conform to the following PCRE regular expression:
    [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be associated with
    a given store.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labels = _messages.MessageField('LabelsValue', 1)
  name = _messages.StringField(2)
  notificationConfig = _messages.MessageField('NotificationConfig', 3)
  notificationConfigs = _messages.MessageField('Hl7V2NotificationConfig', 4, repeated=True)
  parserConfig = _messages.MessageField('ParserConfig', 5)
  rejectDuplicateMessage = _messages.BooleanField(6)


class HttpBody(_messages.Message):
  r"""Message that represents an arbitrary HTTP body. It should only be used
  for payload formats that can't be represented as JSON, such as raw binary or
  an HTML page.   This message can be used both in streaming and non-streaming
  API methods in the request as well as the response.  It can be used as a
  top-level request field, which is convenient if one wants to extract
  parameters from either the URL or HTTP template into the request fields and
  also want access to the raw HTTP body.  Example:      message
  GetResourceRequest {       // A unique request id.       string request_id =
  1;        // The raw HTTP body is bound to this field.
  google.api.HttpBody http_body = 2;     }      service ResourceService {
  rpc GetResource(GetResourceRequest) returns (google.api.HttpBody);       rpc
  UpdateResource(google.api.HttpBody) returns       (google.protobuf.Empty);
  }  Example with streaming methods:      service CaldavService {       rpc
  GetCalendar(stream google.api.HttpBody)         returns (stream
  google.api.HttpBody);       rpc UpdateCalendar(stream google.api.HttpBody)
  returns (stream google.api.HttpBody);     }  Use of this type only changes
  how the request and response bodies are handled, all other features will
  continue to work unchanged.

  Messages:
    ExtensionsValueListEntry: A ExtensionsValueListEntry object.

  Fields:
    contentType: The HTTP Content-Type header value specifying the content
      type of the body.
    data: The HTTP request/response body as raw binary.
    extensions: Application specific response metadata. Must be set in the
      first response for streaming APIs.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExtensionsValueListEntry(_messages.Message):
    r"""A ExtensionsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a
        ExtensionsValueListEntry object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ExtensionsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  contentType = _messages.StringField(1)
  data = _messages.BytesField(2)
  extensions = _messages.MessageField('ExtensionsValueListEntry', 3, repeated=True)


class ImageConfig(_messages.Message):
  r"""Specifies how to handle de-identification of image pixels.

  Enums:
    TextRedactionModeValueValuesEnum: Determines how to redact text from
      image.

  Fields:
    textRedactionMode: Determines how to redact text from image.
  """

  class TextRedactionModeValueValuesEnum(_messages.Enum):
    r"""Determines how to redact text from image.

    Values:
      TEXT_REDACTION_MODE_UNSPECIFIED: No text redaction specified. Same as
        REDACT_NO_TEXT.
      REDACT_ALL_TEXT: Redact all text.
      REDACT_SENSITIVE_TEXT: Redact sensitive text.
      REDACT_NO_TEXT: Do not redact text.
    """
    TEXT_REDACTION_MODE_UNSPECIFIED = 0
    REDACT_ALL_TEXT = 1
    REDACT_SENSITIVE_TEXT = 2
    REDACT_NO_TEXT = 3

  textRedactionMode = _messages.EnumField('TextRedactionModeValueValuesEnum', 1)


class ImportDicomDataErrorDetails(_messages.Message):
  r"""Returns the errors encountered during DICOM store import.

  Fields:
    sampleErrors: Deprecated. Use only for debugging purposes.  Contains
      sample errors encountered in imports of individual resources. For
      example, a Cloud Storage object.
  """

  sampleErrors = _messages.MessageField('ErrorDetail', 1, repeated=True)


class ImportDicomDataRequest(_messages.Message):
  r"""Imports data into the specified DICOM store. Returns an error if any of
  the files to import are not DICOM files. This API accepts duplicate DICOM
  instances by ignoring the newly-pushed instance. It does not overwrite.

  Fields:
    gcsSource: Cloud Storage source data location and import configuration.
      The Cloud Storage location requires the `roles/storage.objectViewer`
      Cloud IAM role.
  """

  gcsSource = _messages.MessageField('GoogleCloudHealthcareV1beta1DicomGcsSource', 1)


class ImportDicomDataResponse(_messages.Message):
  r"""Returns additional information in regards to a completed DICOM store
  import.
  """



class ImportResourcesRequest(_messages.Message):
  r"""Request to import resources.

  Enums:
    ContentStructureValueValuesEnum: The content structure in the source
      location. If not specified, the server treats the input source files as
      BUNDLE.

  Fields:
    contentStructure: The content structure in the source location. If not
      specified, the server treats the input source files as BUNDLE.
    gcsSource: Cloud Storage source data location and import configuration.
      The Cloud Storage location requires the `roles/storage.objectViewer`
      Cloud IAM role.  Each Cloud Storage object should be a text file that
      contains the format specified in ContentStructure.
  """

  class ContentStructureValueValuesEnum(_messages.Enum):
    r"""The content structure in the source location. If not specified, the
    server treats the input source files as BUNDLE.

    Values:
      CONTENT_STRUCTURE_UNSPECIFIED: If the content structure is not
        specified, the default value `BUNDLE` will be used.
      BUNDLE: The source file contains one or more lines of newline-delimited
        JSON (ndjson). Each line is a bundle, which contains one or more
        resources. Set the bundle type to `history` to import resource
        versions.
      RESOURCE: The source file contains one or more lines of newline-
        delimited JSON (ndjson). Each line is a single resource.
      BUNDLE_PRETTY: The entire file is one JSON bundle. The JSON can span
        multiple lines.
      RESOURCE_PRETTY: The entire file is one JSON resource. The JSON can span
        multiple lines.
    """
    CONTENT_STRUCTURE_UNSPECIFIED = 0
    BUNDLE = 1
    RESOURCE = 2
    BUNDLE_PRETTY = 3
    RESOURCE_PRETTY = 4

  contentStructure = _messages.EnumField('ContentStructureValueValuesEnum', 1)
  gcsSource = _messages.MessageField('GoogleCloudHealthcareV1beta1FhirRestGcsSource', 2)


class InfoTypeTransformation(_messages.Message):
  r"""A transformation to apply to text that is identified as a specific
  info_type.

  Fields:
    characterMaskConfig: Config for character mask.
    cryptoHashConfig: Config for crypto hash.
    dateShiftConfig: Config for date shift.
    infoTypes: InfoTypes to apply this transformation to. If this is not
      specified, this transformation becomes the default transformation, and
      is used for any info_type that is not specified in another
      transformation.
    redactConfig: Config for text redaction.
    replaceWithInfoTypeConfig: Config for replace with InfoType.
  """

  characterMaskConfig = _messages.MessageField('CharacterMaskConfig', 1)
  cryptoHashConfig = _messages.MessageField('CryptoHashConfig', 2)
  dateShiftConfig = _messages.MessageField('DateShiftConfig', 3)
  infoTypes = _messages.StringField(4, repeated=True)
  redactConfig = _messages.MessageField('RedactConfig', 5)
  replaceWithInfoTypeConfig = _messages.MessageField('ReplaceWithInfoTypeConfig', 6)


class IngestMessageRequest(_messages.Message):
  r"""Ingests a message into the specified HL7v2 store.

  Fields:
    message: HL7v2 message to ingest.
  """

  message = _messages.MessageField('Message', 1)


class IngestMessageResponse(_messages.Message):
  r"""Acknowledges that a message has been ingested into the specified HL7v2
  store.

  Fields:
    hl7Ack: HL7v2 ACK message.
    message: Created message resource.
  """

  hl7Ack = _messages.BytesField(1)
  message = _messages.MessageField('Message', 2)


class ListDatasetsResponse(_messages.Message):
  r"""Lists the available datasets.

  Fields:
    datasets: The first page of datasets.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  datasets = _messages.MessageField('Dataset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDicomStoresResponse(_messages.Message):
  r"""Lists the DICOM stores in the given dataset.

  Fields:
    dicomStores: The returned DICOM stores. Won't be more DICOM stores than
      the value of page_size in the request.
    nextPageToken: Token to retrieve the next page of results or empty if
      there are no more results in the list.
  """

  dicomStores = _messages.MessageField('DicomStore', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListFhirStoresResponse(_messages.Message):
  r"""Lists the FHIR stores in the given dataset.

  Fields:
    fhirStores: The returned FHIR stores. Won't be more FHIR stores than the
      value of page_size in the request.
    nextPageToken: Token to retrieve the next page of results or empty if
      there are no more results in the list.
  """

  fhirStores = _messages.MessageField('FhirStore', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListHl7V2StoresResponse(_messages.Message):
  r"""Lists the HL7v2 stores in the given dataset.

  Fields:
    hl7V2Stores: The returned HL7v2 stores. Won't be more HL7v2 stores than
      the value of page_size in the request.
    nextPageToken: Token to retrieve the next page of results or empty if
      there are no more results in the list.
  """

  hl7V2Stores = _messages.MessageField('Hl7V2Store', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMessagesResponse(_messages.Message):
  r"""Lists the messages in the specified HL7v2 store.

  Fields:
    hl7V2Messages: The returned Messages. Won't be more Messages than the
      value of page_size in the request. See view for populated fields.
    nextPageToken: Token to retrieve the next page of results or empty if
      there are no more results in the list.
  """

  hl7V2Messages = _messages.MessageField('Message', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Message(_messages.Message):
  r"""A complete HL7v2 message. See
  http://www.hl7.org/implement/standards/index.cfm?ref=common for details on
  the standard.

  Messages:
    LabelsValue: User-supplied key-value pairs used to organize HL7v2 stores.
      Label keys must be between 1 and 63 characters long, have a UTF-8
      encoding of maximum 128 bytes, and must conform to the following PCRE
      regular expression: \p{Ll}\p{Lo}{0,62}  Label values are optional, must
      be between 1 and 63 characters long, have a UTF-8 encoding of maximum
      128 bytes, and must conform to the following PCRE regular expression:
      [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be associated
      with a given store.

  Fields:
    createTime: Output only. The datetime when the message was created. Set by
      the server.
    data: Raw message bytes.
    labels: User-supplied key-value pairs used to organize HL7v2 stores.
      Label keys must be between 1 and 63 characters long, have a UTF-8
      encoding of maximum 128 bytes, and must conform to the following PCRE
      regular expression: \p{Ll}\p{Lo}{0,62}  Label values are optional, must
      be between 1 and 63 characters long, have a UTF-8 encoding of maximum
      128 bytes, and must conform to the following PCRE regular expression:
      [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be associated
      with a given store.
    messageType: The message type for this message. MSH-9.1.
    name: Resource name of the Message, of the form `projects/{project_id}/dat
      asets/{dataset_id}/hl7V2Stores/{hl7_v2_store_id}/messages/{message_id}`.
      Assigned by the server.
    parsedData: Output only. The parsed version of the raw message data.
    patientIds: All patient IDs listed in the PID-2, PID-3, and PID-4 segments
      of this message.
    schematizedData: The parsed version of the raw message data schematized
      according to this store's schemas and type definitions.
    sendFacility: The hospital that this message came from. MSH-4.
    sendTime: The datetime the sending application sent this message. MSH-7.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""User-supplied key-value pairs used to organize HL7v2 stores.  Label
    keys must be between 1 and 63 characters long, have a UTF-8 encoding of
    maximum 128 bytes, and must conform to the following PCRE regular
    expression: \p{Ll}\p{Lo}{0,62}  Label values are optional, must be between
    1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and
    must conform to the following PCRE regular expression:
    [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be associated with
    a given store.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  data = _messages.BytesField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  messageType = _messages.StringField(4)
  name = _messages.StringField(5)
  parsedData = _messages.MessageField('ParsedData', 6)
  patientIds = _messages.MessageField('PatientId', 7, repeated=True)
  schematizedData = _messages.MessageField('SchematizedData', 8)
  sendFacility = _messages.StringField(9)
  sendTime = _messages.StringField(10)


class NotificationConfig(_messages.Message):
  r"""Specifies where to send notifications upon changes to a data store.

  Fields:
    pubsubTopic: The [Cloud Pub/Sub](https://cloud.google.com/pubsub/docs/)
      topic that notifications of changes are published on. Supplied by the
      client. PubsubMessage.Data contains the resource name.
      PubsubMessage.MessageId is the ID of this message. It is guaranteed to
      be unique within the topic. PubsubMessage.PublishTime is the time at
      which the message was published. Notifications are only sent if the
      topic is non-empty. [Topic
      names](https://cloud.google.com/pubsub/docs/overview#names) must be
      scoped to a project. cloud-healthcare@system.gserviceaccount.com must
      have publisher permissions on the given Cloud Pub/Sub topic. Not having
      adequate permissions causes the calls that send notifications to fail.
      If a notification can't be published to Cloud Pub/Sub, errors are logged
      to Stackdriver (see [Viewing logs](/healthcare/docs/how-tos/stackdriver-
      logging)). If the number of errors exceeds a certain rate, some aren't
      submitted.
  """

  pubsubTopic = _messages.StringField(1)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""OperationMetadata provides information about the operation execution.
  Returned in the long-running operation's metadata field.

  Fields:
    apiMethodName: The name of the API method that initiated the operation.
    cancelRequested: Specifies if cancellation was requested for the
      operation.
    counter: A ProgressCounter attribute.
    createTime: The time at which the operation was created by the API.
    endTime: The time at which execution was completed.
    logsUrl: A link to audit and error logs in the log viewer. Error logs are
      generated only by some operations, listed at
      https://cloud.google.com/healthcare/docs/how-tos/stackdriver-logging.
  """

  apiMethodName = _messages.StringField(1)
  cancelRequested = _messages.BooleanField(2)
  counter = _messages.MessageField('ProgressCounter', 3)
  createTime = _messages.StringField(4)
  endTime = _messages.StringField(5)
  logsUrl = _messages.StringField(6)


class ParsedData(_messages.Message):
  r"""The content of an HL7v2 message in a structured format.

  Fields:
    segments: A Segment attribute.
  """

  segments = _messages.MessageField('Segment', 1, repeated=True)


class ParserConfig(_messages.Message):
  r"""The configuration for the parser. It determines how the server parses
  the messages.

  Fields:
    allowNullHeader: Determines whether messages with no header are allowed.
    schema: Schemas used to parse messages in this store, if schematized
      parsing is desired.
    segmentTerminator: Byte(s) to use as the segment terminator. If this is
      unset, '\r' is used as segment terminator, matching the HL7 version 2
      specification.
  """

  allowNullHeader = _messages.BooleanField(1)
  schema = _messages.MessageField('SchemaPackage', 2)
  segmentTerminator = _messages.BytesField(3)


class PatientId(_messages.Message):
  r"""A patient identifier and associated type.

  Fields:
    type: ID type. For example, MRN or NHS.
    value: The patient's unique identifier.
  """

  type = _messages.StringField(1)
  value = _messages.StringField(2)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources.   A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role.  Optionally, a
  `binding` can specify a `condition`, which is a logical expression that
  allows access to a resource only if the expression evaluates to `true`. A
  condition can add constraints based on attributes of the request, the
  resource, or both.  **JSON example:**      {       "bindings": [         {
  "role": "roles/resourcemanager.organizationAdmin",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-project-
  id@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/resourcemanager.organizationViewer",           "members":
  ["user:eve@example.com"],           "condition": {             "title":
  "expirable access",             "description": "Does not grant access after
  Sep 2020",             "expression": "request.time <
  timestamp('2020-10-01T00:00:00.000Z')",           }         }       ],
  "etag": "BwWWja0YfJA=",       "version": 3     }  **YAML example:**
  bindings:     - members:       - user:mike@example.com       -
  group:admins@example.com       - domain:google.com       - serviceAccount
  :my-project-id@appspot.gserviceaccount.com       role:
  roles/resourcemanager.organizationAdmin     - members:       -
  user:eve@example.com       role: roles/resourcemanager.organizationViewer
  condition:         title: expirable access         description: Does not
  grant access after Sep 2020         expression: request.time <
  timestamp('2020-10-01T00:00:00.000Z')     - etag: BwWWja0YfJA=     -
  version: 3  For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy.  Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected.  Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations:  * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy   that includes conditions  **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost.  If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class ProgressCounter(_messages.Message):
  r"""ProgressCounter provides counters to describe an operation's progress.

  Fields:
    failure: The number of units that failed in the operation.
    pending: The number of units that are pending in the operation.
    success: The number of units that succeeded in the operation.
  """

  failure = _messages.IntegerField(1)
  pending = _messages.IntegerField(2)
  success = _messages.IntegerField(3)


class RedactConfig(_messages.Message):
  r"""Define how to redact sensitive values. Default behaviour is erase. For
  example, "My name is Jane." becomes "My name is ."
  """



class ReplaceWithInfoTypeConfig(_messages.Message):
  r"""When using the INSPECT_AND_TRANSFORM action, each match is replaced with
  the name of the info_type. For example, "My name is Jane" becomes "My name
  is [PERSON_NAME]." The TRANSFORM action is equivalent to redacting.
  """



class Resources(_messages.Message):
  r"""A list of FHIR resources.

  Fields:
    resources: List of resources IDs. For example, "Patient/1234".
  """

  resources = _messages.StringField(1, repeated=True)


class SchemaConfig(_messages.Message):
  r"""Configuration for the FHIR BigQuery schema. Determines how the server
  generates the schema.

  Enums:
    SchemaTypeValueValuesEnum: Specifies the output schema type. If
      unspecified, the default is `LOSSLESS`.

  Fields:
    recursiveStructureDepth: The depth for all recursive structures in the
      output analytics schema. For example, `concept` in the CodeSystem
      resource is a recursive structure; when the depth is 2, the CodeSystem
      table will have a column called `concept.concept` but not
      `concept.concept.concept`. If not specified or set to 0, the server will
      use the default value 2. The maximum depth allowed is 5.
    schemaType: Specifies the output schema type. If unspecified, the default
      is `LOSSLESS`.
  """

  class SchemaTypeValueValuesEnum(_messages.Enum):
    r"""Specifies the output schema type. If unspecified, the default is
    `LOSSLESS`.

    Values:
      SCHEMA_TYPE_UNSPECIFIED: No schema type specified. Same as `LOSSLESS`.
      LOSSLESS: A data-driven schema generated from the fields present in the
        FHIR data being exported, with no additional simplification.
      ANALYTICS: Analytics schema defined by the FHIR community. See
        https://github.com/FHIR/sql-on-fhir/blob/master/sql-on-fhir.md.
    """
    SCHEMA_TYPE_UNSPECIFIED = 0
    LOSSLESS = 1
    ANALYTICS = 2

  recursiveStructureDepth = _messages.IntegerField(1)
  schemaType = _messages.EnumField('SchemaTypeValueValuesEnum', 2)


class SchemaGroup(_messages.Message):
  r"""An HL7v2 logical group construct.

  Fields:
    choice: True indicates that this is a choice group, meaning that only one
      of its segments can exist in a given message.
    maxOccurs: The maximum number of times this group can be repeated. 0 or -1
      means unbounded.
    members: Nested groups and/or segments.
    minOccurs: The minimum number of times this group must be
      present/repeated.
    name: The name of this group. For example, "ORDER_DETAIL".
  """

  choice = _messages.BooleanField(1)
  maxOccurs = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  members = _messages.MessageField('GroupOrSegment', 3, repeated=True)
  minOccurs = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  name = _messages.StringField(5)


class SchemaPackage(_messages.Message):
  r"""A schema package contains a set of schemas and type definitions.

  Enums:
    SchematizedParsingTypeValueValuesEnum: Determines how messages that don't
      parse successfully are handled.

  Fields:
    ignoreMinOccurs: Flag to ignore all min_occurs restrictions in the schema.
      This means that incoming messages can omit any group, segment, field,
      component, or subcomponent.
    schemas: Schema configs that are layered based on their VersionSources
      that match the incoming message. Schema configs present in higher
      indices override those in lower indices with the same message type and
      trigger event if their VersionSources all match an incoming message.
    schematizedParsingType: Determines how messages that don't parse
      successfully are handled.
    types: Schema type definitions that are layered based on their
      VersionSources that match the incoming message. Type definitions present
      in higher indices override those in lower indices with the same type
      name if their VersionSources all match an incoming message.
  """

  class SchematizedParsingTypeValueValuesEnum(_messages.Enum):
    r"""Determines how messages that don't parse successfully are handled.

    Values:
      SCHEMATIZED_PARSING_TYPE_UNSPECIFIED: Unspecified schematized parsing
        type, equivalent to `SOFT_FAIL`.
      SOFT_FAIL: Messages that fail to parse are still stored and ACKed but a
        parser error is stored in place of the schematized data.
      HARD_FAIL: Messages that fail to parse are rejected from
        ingestion/insertion and return an error code.
    """
    SCHEMATIZED_PARSING_TYPE_UNSPECIFIED = 0
    SOFT_FAIL = 1
    HARD_FAIL = 2

  ignoreMinOccurs = _messages.BooleanField(1)
  schemas = _messages.MessageField('Hl7SchemaConfig', 2, repeated=True)
  schematizedParsingType = _messages.EnumField('SchematizedParsingTypeValueValuesEnum', 3)
  types = _messages.MessageField('Hl7TypesConfig', 4, repeated=True)


class SchemaSegment(_messages.Message):
  r"""An HL7v2 Segment.

  Fields:
    maxOccurs: The maximum number of times this segment can be present in this
      group. 0 or -1 means unbounded.
    minOccurs: The minimum number of times this segment can be present in this
      group.
    type: The Segment type. For example, "PID".
  """

  maxOccurs = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minOccurs = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  type = _messages.StringField(3)


class SchematizedData(_messages.Message):
  r"""The content of an HL7v2 message in a structured format as specified by a
  schema.

  Fields:
    data: JSON output of the parser.
    error: The error output of the parser.
  """

  data = _messages.StringField(1)
  error = _messages.StringField(2)


class SearchResourcesRequest(_messages.Message):
  r"""Request to search the resources in the specified FHIR store.

  Fields:
    resourceType: The FHIR resource type to search, such as Patient or
      Observation. For a complete list, see the FHIR Resource Index ([DSTU2](h
      ttp://hl7.org/implement/standards/fhir/DSTU2/resourcelist.html),
      [STU3](http://hl7.org/implement/standards/fhir/STU3/resourcelist.html),
      [R4](http://hl7.org/implement/standards/fhir/R4/resourcelist.html)).
  """

  resourceType = _messages.StringField(1)


class Segment(_messages.Message):
  r"""A segment in a structured format.

  Messages:
    FieldsValue: A mapping from the positional location to the value. The key
      string uses zero-based indexes separated by dots to identify Fields,
      components and sub-components. A bracket notation is also used to
      identify different instances of a repeated field. Regex for key:
      (\d+)(\[\d+\])?(.\d+)?(.\d+)?  Examples of (key, value) pairs:  * (0.1,
      "hemoglobin") denotes that the first component of Field 0 has the
      value "hemoglobin".  * (1.1.2, "CBC") denotes that the second sub-
      component of the first   component of Field 1 has the value "CBC".  *
      (1[0].1, "HbA1c") denotes that the first component of the   first
      Instance of Field 1, which is repeated, has the value "HbA1c".

  Fields:
    fields: A mapping from the positional location to the value. The key
      string uses zero-based indexes separated by dots to identify Fields,
      components and sub-components. A bracket notation is also used to
      identify different instances of a repeated field. Regex for key:
      (\d+)(\[\d+\])?(.\d+)?(.\d+)?  Examples of (key, value) pairs:  * (0.1,
      "hemoglobin") denotes that the first component of Field 0 has the
      value "hemoglobin".  * (1.1.2, "CBC") denotes that the second sub-
      component of the first   component of Field 1 has the value "CBC".  *
      (1[0].1, "HbA1c") denotes that the first component of the   first
      Instance of Field 1, which is repeated, has the value "HbA1c".
    segmentId: A string that indicates the type of segment. For example, EVN
      or PID.
    setId: Set ID for segments that can be in a set. This can be empty if it's
      missing or isn't applicable.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FieldsValue(_messages.Message):
    r"""A mapping from the positional location to the value. The key string
    uses zero-based indexes separated by dots to identify Fields, components
    and sub-components. A bracket notation is also used to identify different
    instances of a repeated field. Regex for key:
    (\d+)(\[\d+\])?(.\d+)?(.\d+)?  Examples of (key, value) pairs:  * (0.1,
    "hemoglobin") denotes that the first component of Field 0 has the   value
    "hemoglobin".  * (1.1.2, "CBC") denotes that the second sub-component of
    the first   component of Field 1 has the value "CBC".  * (1[0].1, "HbA1c")
    denotes that the first component of the   first Instance of Field 1, which
    is repeated, has the value "HbA1c".

    Messages:
      AdditionalProperty: An additional property for a FieldsValue object.

    Fields:
      additionalProperties: Additional properties of type FieldsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FieldsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  fields = _messages.MessageField('FieldsValue', 1)
  segmentId = _messages.StringField(2)
  setId = _messages.StringField(3)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StreamConfig(_messages.Message):
  r"""This structure contains configuration for streaming FHIR export.

  Fields:
    bigqueryDestination: The destination BigQuery structure that contains both
      the dataset location and corresponding schema config.  The output is
      organized in one table per resource type. The server reuses the existing
      tables (if any) that are named after the resource types, e.g. "Patient",
      "Observation". When there is no existing table for a given resource
      type, the server attempts to create one.  When a table schema doesn't
      align with the schema config, either because of existing incompatible
      schema or out of band incompatible modification, the server does not
      stream in new data.  One resolution in this case is to delete the
      incompatible table and let the server recreate one, though the newly
      created table only contains data after the table recreation.  BigQuery
      imposes a 1 MB limit on streaming insert row size, therefore any
      resource mutation that generates more than 1 MB of BigQuery data will
      not be streamed.  Results are appended to the corresponding BigQuery
      tables. Different versions of the same resource are distinguishable by
      the meta.versionId and meta.lastUpdated columns. The operation
      (CREATE/UPDATE/DELETE) that results in the new version is recorded in
      the meta.tag.  The tables contain all historical resource versions since
      streaming was enabled. For query convenience, the server also creates
      one view per table of the same name containing only the current resource
      version.  If a resource mutation cannot be streamed to BigQuery, errors
      will be logged to Stackdriver (see [Viewing logs](/healthcare/docs/how-
      tos/stackdriver-logging)).
    resourceTypes: Supply a FHIR resource type (such as "Patient" or
      "Observation"). See https://www.hl7.org/fhir/valueset-resource-
      types.html for a list of all FHIR resource types. The server treats an
      empty list as an intent to stream all the supported resource types in
      this FHIR store.
  """

  bigqueryDestination = _messages.MessageField('GoogleCloudHealthcareV1beta1FhirBigQueryDestination', 1)
  resourceTypes = _messages.StringField(2, repeated=True)


class TagFilterList(_messages.Message):
  r"""List of tags to be filtered.

  Fields:
    tags: Tags to be filtered. Tags must be DICOM Data Elements, File Meta
      Elements, or Directory Structuring Elements, as defined at: http://dicom
      .nema.org/medical/dicom/current/output/html/part06.html#table_6-1,. They
      may be provided by "Keyword" or "Tag". For example "PatientID",
      "00100010".
  """

  tags = _messages.StringField(1, repeated=True)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class TextConfig(_messages.Message):
  r"""A TextConfig object.

  Fields:
    transformations: The transformations to apply to the detected data.
  """

  transformations = _messages.MessageField('InfoTypeTransformation', 1, repeated=True)


class Type(_messages.Message):
  r"""A type definition for some HL7v2 type (incl. Segments and Datatypes).

  Enums:
    PrimitiveValueValuesEnum: If this is a primitive type then this field is
      the type of the primitive For example, STRING. Leave unspecified for
      composite types.

  Fields:
    fields: The (sub) fields this type has (if not primitive).
    name: The name of this type. This would be the segment or datatype name.
      For example, "PID" or "XPN".
    primitive: If this is a primitive type then this field is the type of the
      primitive For example, STRING. Leave unspecified for composite types.
  """

  class PrimitiveValueValuesEnum(_messages.Enum):
    r"""If this is a primitive type then this field is the type of the
    primitive For example, STRING. Leave unspecified for composite types.

    Values:
      PRIMITIVE_UNSPECIFIED: Not a primitive.
      STRING: String primitive.
      VARIES: Element that can have unschematized children.
      UNESCAPED_STRING: Like STRING, but all delimiters below this element are
        ignored.
    """
    PRIMITIVE_UNSPECIFIED = 0
    STRING = 1
    VARIES = 2
    UNESCAPED_STRING = 3

  fields = _messages.MessageField('Field', 1, repeated=True)
  name = _messages.StringField(2)
  primitive = _messages.EnumField('PrimitiveValueValuesEnum', 3)


class VersionSource(_messages.Message):
  r"""Describes a selector for extracting and matching an MSH field to a
  value.

  Fields:
    mshField: The field to extract from the MSH segment. For example, "3.1" or
      "18[1].1".
    value: The value to match with the field. For example, "My Application
      Name" or "2.3".
  """

  mshField = _messages.StringField(1)
  value = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
