"""Generated client library for recaptchaenterprise version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.recaptchaenterprise.v1 import recaptchaenterprise_v1_messages as messages


class RecaptchaenterpriseV1(base_api.BaseApiClient):
  """Generated client library for service recaptchaenterprise version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://recaptchaenterprise.googleapis.com/'
  MTLS_BASE_URL = u'https://recaptchaenterprise.mtls.googleapis.com/'

  _PACKAGE = u'recaptchaenterprise'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'RecaptchaenterpriseV1'
  _URL_VERSION = u'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new recaptchaenterprise handle."""
    url = url or self.BASE_URL
    super(RecaptchaenterpriseV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_assessments = self.ProjectsAssessmentsService(self)
    self.projects_keys = self.ProjectsKeysService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsAssessmentsService(base_api.BaseApiService):
    """Service class for the projects_assessments resource."""

    _NAME = u'projects_assessments'

    def __init__(self, client):
      super(RecaptchaenterpriseV1.ProjectsAssessmentsService, self).__init__(client)
      self._upload_configs = {
          }

    def Annotate(self, request, global_params=None):
      r"""Annotates a previously created Assessment to provide additional information.
on whether the event turned out to be authentic or fradulent.

      Args:
        request: (RecaptchaenterpriseProjectsAssessmentsAnnotateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentResponse) The response message.
      """
      config = self.GetMethodConfig('Annotate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Annotate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/assessments/{assessmentsId}:annotate',
        http_method=u'POST',
        method_id=u'recaptchaenterprise.projects.assessments.annotate',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:annotate',
        request_field=u'googleCloudRecaptchaenterpriseV1AnnotateAssessmentRequest',
        request_type_name=u'RecaptchaenterpriseProjectsAssessmentsAnnotateRequest',
        response_type_name=u'GoogleCloudRecaptchaenterpriseV1AnnotateAssessmentResponse',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates an Assessment of the likelihood an event is legitimate.

      Args:
        request: (RecaptchaenterpriseProjectsAssessmentsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecaptchaenterpriseV1Assessment) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/assessments',
        http_method=u'POST',
        method_id=u'recaptchaenterprise.projects.assessments.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1/{+parent}/assessments',
        request_field=u'googleCloudRecaptchaenterpriseV1Assessment',
        request_type_name=u'RecaptchaenterpriseProjectsAssessmentsCreateRequest',
        response_type_name=u'GoogleCloudRecaptchaenterpriseV1Assessment',
        supports_download=False,
    )

  class ProjectsKeysService(base_api.BaseApiService):
    """Service class for the projects_keys resource."""

    _NAME = u'projects_keys'

    def __init__(self, client):
      super(RecaptchaenterpriseV1.ProjectsKeysService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new reCAPTCHA Enterprise key.

      Args:
        request: (RecaptchaenterpriseProjectsKeysCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecaptchaenterpriseV1Key) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/keys',
        http_method=u'POST',
        method_id=u'recaptchaenterprise.projects.keys.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1/{+parent}/keys',
        request_field=u'googleCloudRecaptchaenterpriseV1Key',
        request_type_name=u'RecaptchaenterpriseProjectsKeysCreateRequest',
        response_type_name=u'GoogleCloudRecaptchaenterpriseV1Key',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified key.

      Args:
        request: (RecaptchaenterpriseProjectsKeysDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/keys/{keysId}',
        http_method=u'DELETE',
        method_id=u'recaptchaenterprise.projects.keys.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'RecaptchaenterpriseProjectsKeysDeleteRequest',
        response_type_name=u'GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified key.

      Args:
        request: (RecaptchaenterpriseProjectsKeysGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecaptchaenterpriseV1Key) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/keys/{keysId}',
        http_method=u'GET',
        method_id=u'recaptchaenterprise.projects.keys.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'RecaptchaenterpriseProjectsKeysGetRequest',
        response_type_name=u'GoogleCloudRecaptchaenterpriseV1Key',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns the list of all keys that belong to a project.

      Args:
        request: (RecaptchaenterpriseProjectsKeysListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecaptchaenterpriseV1ListKeysResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/keys',
        http_method=u'GET',
        method_id=u'recaptchaenterprise.projects.keys.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1/{+parent}/keys',
        request_field='',
        request_type_name=u'RecaptchaenterpriseProjectsKeysListRequest',
        response_type_name=u'GoogleCloudRecaptchaenterpriseV1ListKeysResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified key.

      Args:
        request: (RecaptchaenterpriseProjectsKeysPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudRecaptchaenterpriseV1Key) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/projects/{projectsId}/keys/{keysId}',
        http_method=u'PATCH',
        method_id=u'recaptchaenterprise.projects.keys.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1/{+name}',
        request_field=u'googleCloudRecaptchaenterpriseV1Key',
        request_type_name=u'RecaptchaenterpriseProjectsKeysPatchRequest',
        response_type_name=u'GoogleCloudRecaptchaenterpriseV1Key',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(RecaptchaenterpriseV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
