"""Generated message classes for bigtableadmin version v2.

Administer your Cloud Bigtable tables and instances.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'bigtableadmin'


class AppProfile(_messages.Message):
  r"""A configuration object describing how Cloud Bigtable should treat
  traffic from a particular end user application.

  Fields:
    description: Optional long form description of the use case for this
      AppProfile.
    etag: Strongly validated etag for optimistic concurrency control. Preserve
      the value returned from `GetAppProfile` when calling `UpdateAppProfile`
      to fail the request if there has been a modification in the mean time.
      The `update_mask` of the request need not include `etag` for this
      protection to apply. See
      [Wikipedia](https://en.wikipedia.org/wiki/HTTP_ETag) and [RFC
      7232](https://tools.ietf.org/html/rfc7232#section-2.3) for more details.
    multiClusterRoutingUseAny: Use a multi-cluster routing policy.
    name: (`OutputOnly`) The unique name of the app profile. Values are of the
      form `projects/<project>/instances/<instance>/appProfiles/_a-zA-Z0-9*`.
    singleClusterRouting: Use a single-cluster routing policy.
  """

  description = _messages.StringField(1)
  etag = _messages.StringField(2)
  multiClusterRoutingUseAny = _messages.MessageField('MultiClusterRoutingUseAny', 3)
  name = _messages.StringField(4)
  singleClusterRouting = _messages.MessageField('SingleClusterRouting', 5)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:jose@example.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "sampleservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:aliya@example.com"               ]             }           ]         }
  ]     }  For sampleservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging,
  and aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:jose@example.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  jose@example.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Backup(_messages.Message):
  r"""A backup of a Cloud Bigtable table.

  Enums:
    StateValueValuesEnum: Output only. The current state of the backup.

  Fields:
    endTime: Output only. `end_time` is the time that the backup was finished.
      The row data in the backup will be no newer than this timestamp.
    expireTime: Required for the CreateBackup operation. The expiration time
      of the backup, with microseconds granularity that must be at least 6
      hours and at most 30 days from the time the request is received. Once
      the `expire_time` has passed, Cloud Bigtable will delete the backup and
      free the resources used by the backup.
    name: Output only. A globally unique identifier for the backup which
      cannot be changed. Values are of the form
      `projects/<project>/instances/<instance>/clusters/<cluster>/    backups
      /_a-zA-Z0-9*` The final segment of the name must be between 1 and 50
      characters in length.  The backup is stored in the cluster identified by
      the prefix of the backup name of the form
      `projects/<project>/instances/<instance>/clusters/<cluster>`.
    sizeBytes: Output only. Size of the backup in bytes.
    sourceTable: Immutable. Required for the CreateBackup operation. Name of
      the table from which this backup was created. This needs to be in the
      same instance as the backup. Values are of the form
      `projects/<project>/instances/<instance>/tables/<source_table>`.
    startTime: Output only. `start_time` is the time that the backup was
      started (i.e. approximately the time the CreateBackup request is
      received).  The row data in this backup will be no older than this
      timestamp.
    state: Output only. The current state of the backup.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the backup.

    Values:
      STATE_UNSPECIFIED: Not specified.
      CREATING: The pending backup is still being created. Operations on the
        backup may fail with `FAILED_PRECONDITION` in this state.
      READY: The backup is complete and ready for use.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2

  endTime = _messages.StringField(1)
  expireTime = _messages.StringField(2)
  name = _messages.StringField(3)
  sizeBytes = _messages.IntegerField(4)
  sourceTable = _messages.StringField(5)
  startTime = _messages.StringField(6)
  state = _messages.EnumField('StateValueValuesEnum', 7)


class BackupInfo(_messages.Message):
  r"""Information about a backup.

  Fields:
    backup: Output only. Name of the backup.
    endTime: Output only. This time that the backup was finished. Row data in
      the backup will be no newer than this timestamp.
    sourceTable: Output only. Name of the table the backup was created from.
    startTime: Output only. The time that the backup was started. Row data in
      the backup will be no older than this timestamp.
  """

  backup = _messages.StringField(1)
  endTime = _messages.StringField(2)
  sourceTable = _messages.StringField(3)
  startTime = _messages.StringField(4)


class BigtableadminOperationsCancelRequest(_messages.Message):
  r"""A BigtableadminOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminOperationsDeleteRequest(_messages.Message):
  r"""A BigtableadminOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminOperationsGetRequest(_messages.Message):
  r"""A BigtableadminOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminOperationsProjectsOperationsListRequest(_messages.Message):
  r"""A BigtableadminOperationsProjectsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class BigtableadminProjectsInstancesAppProfilesCreateRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesAppProfilesCreateRequest object.

  Fields:
    appProfile: A AppProfile resource to be passed as the request body.
    appProfileId: The ID to be used when referring to the new app profile
      within its instance, e.g., just `myprofile` rather than
      `projects/myproject/instances/myinstance/appProfiles/myprofile`.
    ignoreWarnings: If true, ignore safety checks when creating the app
      profile.
    parent: The unique name of the instance in which to create the new app
      profile. Values are of the form
      `projects/<project>/instances/<instance>`.
  """

  appProfile = _messages.MessageField('AppProfile', 1)
  appProfileId = _messages.StringField(2)
  ignoreWarnings = _messages.BooleanField(3)
  parent = _messages.StringField(4, required=True)


class BigtableadminProjectsInstancesAppProfilesDeleteRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesAppProfilesDeleteRequest object.

  Fields:
    ignoreWarnings: If true, ignore safety checks when deleting the app
      profile.
    name: The unique name of the app profile to be deleted. Values are of the
      form
      `projects/<project>/instances/<instance>/appProfiles/<app_profile>`.
  """

  ignoreWarnings = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesAppProfilesGetRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesAppProfilesGetRequest object.

  Fields:
    name: The unique name of the requested app profile. Values are of the form
      `projects/<project>/instances/<instance>/appProfiles/<app_profile>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesAppProfilesListRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesAppProfilesListRequest object.

  Fields:
    pageSize: Maximum number of results per page.  A page_size of zero lets
      the server choose the number of items to return. A page_size which is
      strictly positive will return at most that many items. A negative
      page_size will cause an error.  Following the first request, subsequent
      paginated calls are not required to pass a page_size. If a page_size is
      set in subsequent calls, it must match the page_size given in the first
      request.
    pageToken: The value of `next_page_token` returned by a previous call.
    parent: The unique name of the instance for which a list of app profiles
      is requested. Values are of the form
      `projects/<project>/instances/<instance>`. Use `<instance> = '-'` to
      list AppProfiles for all Instances in a project, e.g.,
      `projects/myproject/instances/-`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BigtableadminProjectsInstancesAppProfilesPatchRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesAppProfilesPatchRequest object.

  Fields:
    appProfile: A AppProfile resource to be passed as the request body.
    ignoreWarnings: If true, ignore safety checks when updating the app
      profile.
    name: (`OutputOnly`) The unique name of the app profile. Values are of the
      form `projects/<project>/instances/<instance>/appProfiles/_a-zA-Z0-9*`.
    updateMask: The subset of app profile fields which should be replaced. If
      unset, all fields will be replaced.
  """

  appProfile = _messages.MessageField('AppProfile', 1)
  ignoreWarnings = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class BigtableadminProjectsInstancesClustersBackupsCreateRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesClustersBackupsCreateRequest object.

  Fields:
    backup: A Backup resource to be passed as the request body.
    backupId: Required. The id of the backup to be created. The `backup_id`
      along with the parent `parent` are combined as
      <parent>/backups/<backup_id> to create the full backup name, of the
      form: `projects/<project>/instances/<instance>/clusters/<cluster>/backup
      s/<backup_id>`. This string must be between 1 and 50 characters in
      length and match the regex _a-zA-Z0-9*.
    parent: Required. This must be one of the clusters in the instance in
      which this table is located. The backup will be stored in this cluster.
      Values are of the form
      `projects/<project>/instances/<instance>/clusters/<cluster>`.
  """

  backup = _messages.MessageField('Backup', 1)
  backupId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BigtableadminProjectsInstancesClustersBackupsDeleteRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesClustersBackupsDeleteRequest object.

  Fields:
    name: Required. Name of the backup to delete. Values are of the form `proj
      ects/<project>/instances/<instance>/clusters/<cluster>/backups/<backup>`
      .
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesClustersBackupsGetRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesClustersBackupsGetRequest object.

  Fields:
    name: Required. Name of the backup. Values are of the form `projects/<proj
      ect>/instances/<instance>/clusters/<cluster>/backups/<backup>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesClustersBackupsListRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesClustersBackupsListRequest object.

  Fields:
    filter: A filter expression that filters backups listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be <, >,
      <=, >=, !=, =, or :. Colon ':' represents a HAS operator which is
      roughly synonymous with equality. Filter rules are case insensitive.
      The fields eligible for filtering are:   * `name`   * `source_table`   *
      `state`   * `start_time` (and values are of the format YYYY-MM-
      DDTHH:MM:SSZ)   * `end_time` (and values are of the format YYYY-MM-
      DDTHH:MM:SSZ)   * `expire_time` (and values are of the format YYYY-MM-
      DDTHH:MM:SSZ)   * `size_bytes`  To filter on multiple expressions,
      provide each separate expression within parentheses. By default, each
      expression is an AND expression. However, you can include AND, OR, and
      NOT expressions explicitly.  Some examples of using filters are:    *
      `name:"exact"` --> The backup's name is the string "exact".   *
      `name:howl` --> The backup's name contains the string "howl".   *
      `source_table:prod`          --> The source_table's name contains the
      string "prod".   * `state:CREATING` --> The backup is pending creation.
      * `state:READY` --> The backup is fully created and ready for use.   *
      `(name:howl) AND (start_time < \"2018-03-28T14:50:00Z\")`          -->
      The backup name contains the string "howl" and start_time
      of the backup is before 2018-03-28T14:50:00Z.   * `size_bytes >
      10000000000` --> The backup's size is greater than 10GB
    orderBy: An expression for specifying the sort order of the results of the
      request. The string value should specify one or more fields in Backup.
      The full syntax is described at https://aip.dev/132#ordering.  Fields
      supported are:    * name    * source_table    * expire_time    *
      start_time    * end_time    * size_bytes    * state  For example,
      "start_time". The default sorting order is ascending. To specify
      descending order for the field, a suffix " desc" should be appended to
      the field name. For example, "start_time desc". Redundant space
      characters in the syntax are insigificant.  If order_by is empty,
      results will be sorted by `start_time` in descending order starting from
      the most recently created backup.
    pageSize: Number of backups to be returned in the response. If 0 or less,
      defaults to the server's maximum allowed page size.
    pageToken: If non-empty, `page_token` should contain a next_page_token
      from a previous ListBackupsResponse to the same `parent` and with the
      same `filter`.
    parent: Required. The cluster to list backups from.  Values are of the
      form `projects/<project>/instances/<instance>/clusters/<cluster>`. Use
      `<cluster> = '-'` to list backups for all clusters in an instance, e.g.,
      `projects/<project>/instances/<instance>/clusters/-`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class BigtableadminProjectsInstancesClustersBackupsPatchRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesClustersBackupsPatchRequest object.

  Fields:
    backup: A Backup resource to be passed as the request body.
    name: Output only. A globally unique identifier for the backup which
      cannot be changed. Values are of the form
      `projects/<project>/instances/<instance>/clusters/<cluster>/    backups
      /_a-zA-Z0-9*` The final segment of the name must be between 1 and 50
      characters in length.  The backup is stored in the cluster identified by
      the prefix of the backup name of the form
      `projects/<project>/instances/<instance>/clusters/<cluster>`.
    updateMask: Required. A mask specifying which fields (e.g. `expire_time`)
      in the Backup resource should be updated. This mask is relative to the
      Backup resource, not to the request message. The field mask must always
      be specified; this prevents any future fields from being erased
      accidentally by clients that do not know about them.
  """

  backup = _messages.MessageField('Backup', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class BigtableadminProjectsInstancesClustersCreateRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesClustersCreateRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    clusterId: The ID to be used when referring to the new cluster within its
      instance, e.g., just `mycluster` rather than
      `projects/myproject/instances/myinstance/clusters/mycluster`.
    parent: The unique name of the instance in which to create the new
      cluster. Values are of the form
      `projects/<project>/instances/<instance>`.
  """

  cluster = _messages.MessageField('Cluster', 1)
  clusterId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BigtableadminProjectsInstancesClustersDeleteRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesClustersDeleteRequest object.

  Fields:
    name: The unique name of the cluster to be deleted. Values are of the form
      `projects/<project>/instances/<instance>/clusters/<cluster>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesClustersGetRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesClustersGetRequest object.

  Fields:
    name: The unique name of the requested cluster. Values are of the form
      `projects/<project>/instances/<instance>/clusters/<cluster>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesClustersListRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesClustersListRequest object.

  Fields:
    pageToken: DEPRECATED: This field is unused and ignored.
    parent: The unique name of the instance for which a list of clusters is
      requested. Values are of the form
      `projects/<project>/instances/<instance>`. Use `<instance> = '-'` to
      list Clusters for all Instances in a project, e.g.,
      `projects/myproject/instances/-`.
  """

  pageToken = _messages.StringField(1)
  parent = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesDeleteRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesDeleteRequest object.

  Fields:
    name: The unique name of the instance to be deleted. Values are of the
      form `projects/<project>/instances/<instance>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesGetIamPolicyRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesGetRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesGetRequest object.

  Fields:
    name: The unique name of the requested instance. Values are of the form
      `projects/<project>/instances/<instance>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesListRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesListRequest object.

  Fields:
    pageToken: DEPRECATED: This field is unused and ignored.
    parent: The unique name of the project for which a list of instances is
      requested. Values are of the form `projects/<project>`.
  """

  pageToken = _messages.StringField(1)
  parent = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesPartialUpdateInstanceRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesPartialUpdateInstanceRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    name: (`OutputOnly`) The unique name of the instance. Values are of the
      form `projects/<project>/instances/a-z+[a-z0-9]`.
    updateMask: The subset of Instance fields which should be replaced. Must
      be explicitly set.
  """

  instance = _messages.MessageField('Instance', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class BigtableadminProjectsInstancesSetIamPolicyRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class BigtableadminProjectsInstancesTablesCheckConsistencyRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesCheckConsistencyRequest object.

  Fields:
    checkConsistencyRequest: A CheckConsistencyRequest resource to be passed
      as the request body.
    name: The unique name of the Table for which to check replication
      consistency. Values are of the form
      `projects/<project>/instances/<instance>/tables/<table>`.
  """

  checkConsistencyRequest = _messages.MessageField('CheckConsistencyRequest', 1)
  name = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesTablesCreateRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesCreateRequest object.

  Fields:
    createTableRequest: A CreateTableRequest resource to be passed as the
      request body.
    parent: The unique name of the instance in which to create the table.
      Values are of the form `projects/<project>/instances/<instance>`.
  """

  createTableRequest = _messages.MessageField('CreateTableRequest', 1)
  parent = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesTablesDeleteRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesDeleteRequest object.

  Fields:
    name: The unique name of the table to be deleted. Values are of the form
      `projects/<project>/instances/<instance>/tables/<table>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesTablesDropRowRangeRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesDropRowRangeRequest object.

  Fields:
    dropRowRangeRequest: A DropRowRangeRequest resource to be passed as the
      request body.
    name: The unique name of the table on which to drop a range of rows.
      Values are of the form
      `projects/<project>/instances/<instance>/tables/<table>`.
  """

  dropRowRangeRequest = _messages.MessageField('DropRowRangeRequest', 1)
  name = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesTablesGenerateConsistencyTokenRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesGenerateConsistencyTokenRequest
  object.

  Fields:
    generateConsistencyTokenRequest: A GenerateConsistencyTokenRequest
      resource to be passed as the request body.
    name: The unique name of the Table for which to create a consistency
      token. Values are of the form
      `projects/<project>/instances/<instance>/tables/<table>`.
  """

  generateConsistencyTokenRequest = _messages.MessageField('GenerateConsistencyTokenRequest', 1)
  name = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesTablesGetIamPolicyRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesTablesGetRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesGetRequest object.

  Enums:
    ViewValueValuesEnum: The view to be applied to the returned table's
      fields. Defaults to `SCHEMA_VIEW` if unspecified.

  Fields:
    name: The unique name of the requested table. Values are of the form
      `projects/<project>/instances/<instance>/tables/<table>`.
    view: The view to be applied to the returned table's fields. Defaults to
      `SCHEMA_VIEW` if unspecified.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The view to be applied to the returned table's fields. Defaults to
    `SCHEMA_VIEW` if unspecified.

    Values:
      VIEW_UNSPECIFIED: <no description>
      NAME_ONLY: <no description>
      SCHEMA_VIEW: <no description>
      REPLICATION_VIEW: <no description>
      FULL: <no description>
    """
    VIEW_UNSPECIFIED = 0
    NAME_ONLY = 1
    SCHEMA_VIEW = 2
    REPLICATION_VIEW = 3
    FULL = 4

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class BigtableadminProjectsInstancesTablesListRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesListRequest object.

  Enums:
    ViewValueValuesEnum: The view to be applied to the returned tables'
      fields. Only NAME_ONLY view (default) and REPLICATION_VIEW are
      supported.

  Fields:
    pageSize: Maximum number of results per page.  A page_size of zero lets
      the server choose the number of items to return. A page_size which is
      strictly positive will return at most that many items. A negative
      page_size will cause an error.  Following the first request, subsequent
      paginated calls are not required to pass a page_size. If a page_size is
      set in subsequent calls, it must match the page_size given in the first
      request.
    pageToken: The value of `next_page_token` returned by a previous call.
    parent: The unique name of the instance for which tables should be listed.
      Values are of the form `projects/<project>/instances/<instance>`.
    view: The view to be applied to the returned tables' fields. Only
      NAME_ONLY view (default) and REPLICATION_VIEW are supported.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The view to be applied to the returned tables' fields. Only NAME_ONLY
    view (default) and REPLICATION_VIEW are supported.

    Values:
      VIEW_UNSPECIFIED: <no description>
      NAME_ONLY: <no description>
      SCHEMA_VIEW: <no description>
      REPLICATION_VIEW: <no description>
      FULL: <no description>
    """
    VIEW_UNSPECIFIED = 0
    NAME_ONLY = 1
    SCHEMA_VIEW = 2
    REPLICATION_VIEW = 3
    FULL = 4

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class BigtableadminProjectsInstancesTablesModifyColumnFamiliesRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesModifyColumnFamiliesRequest
  object.

  Fields:
    modifyColumnFamiliesRequest: A ModifyColumnFamiliesRequest resource to be
      passed as the request body.
    name: The unique name of the table whose families should be modified.
      Values are of the form
      `projects/<project>/instances/<instance>/tables/<table>`.
  """

  modifyColumnFamiliesRequest = _messages.MessageField('ModifyColumnFamiliesRequest', 1)
  name = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesTablesRestoreRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesRestoreRequest object.

  Fields:
    parent: Required. The name of the instance in which to create the restored
      table. This instance must be the parent of the source backup. Values are
      of the form `projects/<project>/instances/<instance>`.
    restoreTableRequest: A RestoreTableRequest resource to be passed as the
      request body.
  """

  parent = _messages.StringField(1, required=True)
  restoreTableRequest = _messages.MessageField('RestoreTableRequest', 2)


class BigtableadminProjectsInstancesTablesSetIamPolicyRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class BigtableadminProjectsInstancesTablesTestIamPermissionsRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTablesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class BigtableadminProjectsInstancesTestIamPermissionsRequest(_messages.Message):
  r"""A BigtableadminProjectsInstancesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class BigtableadminProjectsLocationsGetRequest(_messages.Message):
  r"""A BigtableadminProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsLocationsListRequest(_messages.Message):
  r"""A BigtableadminProjectsLocationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. NOTE: An
      unsatisfied condition will not allow user access via current binding.
      Different bindings, including their conditions, are examined
      independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example,
      `alice@example.com` .   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.  *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding.  *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus    unique identifier) representing a service account that has been
      recently    deleted. For example,    `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`.    If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding.  * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique    identifier) representing a Google group
      that has been recently    deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If    the group is
      recovered, this value reverts to `group:{emailid}` and the    recovered
      group retains the role in the binding.   * `domain:{domain}`: The G
      Suite domain (primary) that represents all the    users of that domain.
      For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CheckConsistencyRequest(_messages.Message):
  r"""Request message for
  google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency

  Fields:
    consistencyToken: The token created using GenerateConsistencyToken for the
      Table.
  """

  consistencyToken = _messages.StringField(1)


class CheckConsistencyResponse(_messages.Message):
  r"""Response message for
  google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency

  Fields:
    consistent: True only if the token is consistent. A token is consistent if
      replication has caught up with the restrictions specified in the
      request.
  """

  consistent = _messages.BooleanField(1)


class Cluster(_messages.Message):
  r"""A resizable group of nodes in a particular cloud location, capable of
  serving all Tables in the parent Instance.

  Enums:
    DefaultStorageTypeValueValuesEnum: (`CreationOnly`) The type of storage
      used by this cluster to serve its parent instance's tables, unless
      explicitly overridden.
    StateValueValuesEnum: (`OutputOnly`) The current state of the cluster.

  Fields:
    defaultStorageType: (`CreationOnly`) The type of storage used by this
      cluster to serve its parent instance's tables, unless explicitly
      overridden.
    location: (`CreationOnly`) The location where this cluster's nodes and
      storage reside. For best performance, clients should be located as close
      as possible to this cluster. Currently only zones are supported, so
      values should be of the form `projects/<project>/locations/<zone>`.
    name: (`OutputOnly`) The unique name of the cluster. Values are of the
      form `projects/<project>/instances/<instance>/clusters/a-z*`.
    serveNodes: The number of nodes allocated to this cluster. More nodes
      enable higher throughput and more consistent performance.
    state: (`OutputOnly`) The current state of the cluster.
  """

  class DefaultStorageTypeValueValuesEnum(_messages.Enum):
    r"""(`CreationOnly`) The type of storage used by this cluster to serve its
    parent instance's tables, unless explicitly overridden.

    Values:
      STORAGE_TYPE_UNSPECIFIED: The user did not specify a storage type.
      SSD: Flash (SSD) storage should be used.
      HDD: Magnetic drive (HDD) storage should be used.
    """
    STORAGE_TYPE_UNSPECIFIED = 0
    SSD = 1
    HDD = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""(`OutputOnly`) The current state of the cluster.

    Values:
      STATE_NOT_KNOWN: The state of the cluster could not be determined.
      READY: The cluster has been successfully created and is ready to serve
        requests.
      CREATING: The cluster is currently being created, and may be destroyed
        if the creation process encounters an error. A cluster may not be able
        to serve requests while being created.
      RESIZING: The cluster is currently being resized, and may revert to its
        previous node count if the process encounters an error. A cluster is
        still capable of serving requests while being resized, but may exhibit
        performance as if its number of allocated nodes is between the
        starting and requested states.
      DISABLED: The cluster has no backing nodes. The data (tables) still
        exist, but no operations can be performed on the cluster.
    """
    STATE_NOT_KNOWN = 0
    READY = 1
    CREATING = 2
    RESIZING = 3
    DISABLED = 4

  defaultStorageType = _messages.EnumField('DefaultStorageTypeValueValuesEnum', 1)
  location = _messages.StringField(2)
  name = _messages.StringField(3)
  serveNodes = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class ClusterState(_messages.Message):
  r"""The state of a table's data in a particular cluster.

  Enums:
    ReplicationStateValueValuesEnum: Output only. The state of replication for
      the table in this cluster.

  Fields:
    replicationState: Output only. The state of replication for the table in
      this cluster.
  """

  class ReplicationStateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of replication for the table in this cluster.

    Values:
      STATE_NOT_KNOWN: The replication state of the table is unknown in this
        cluster.
      INITIALIZING: The cluster was recently created, and the table must
        finish copying over pre-existing data from other clusters before it
        can begin receiving live replication updates and serving Data API
        requests.
      PLANNED_MAINTENANCE: The table is temporarily unable to serve Data API
        requests from this cluster due to planned internal maintenance.
      UNPLANNED_MAINTENANCE: The table is temporarily unable to serve Data API
        requests from this cluster due to unplanned or emergency maintenance.
      READY: The table can serve Data API requests from this cluster.
        Depending on replication delay, reads may not immediately reflect the
        state of the table in other clusters.
      READY_OPTIMIZING: The table is fully created and ready for use after a
        restore, and is being optimized for performance. When optimizations
        are complete, the table will transition to `READY` state.
    """
    STATE_NOT_KNOWN = 0
    INITIALIZING = 1
    PLANNED_MAINTENANCE = 2
    UNPLANNED_MAINTENANCE = 3
    READY = 4
    READY_OPTIMIZING = 5

  replicationState = _messages.EnumField('ReplicationStateValueValuesEnum', 1)


class ColumnFamily(_messages.Message):
  r"""A set of columns within a table which share a common configuration.

  Fields:
    gcRule: Garbage collection rule specified as a protobuf. Must serialize to
      at most 500 bytes.  NOTE: Garbage collection executes opportunistically
      in the background, and so it's possible for reads to return a cell even
      if it matches the active GC expression for its family.
  """

  gcRule = _messages.MessageField('GcRule', 1)


class CreateBackupMetadata(_messages.Message):
  r"""Metadata type for the operation returned by CreateBackup.

  Fields:
    endTime: If set, the time at which this operation finished or was
      cancelled.
    name: The name of the backup being created.
    sourceTable: The name of the table the backup is created from.
    startTime: The time at which this operation started.
  """

  endTime = _messages.StringField(1)
  name = _messages.StringField(2)
  sourceTable = _messages.StringField(3)
  startTime = _messages.StringField(4)


class CreateClusterMetadata(_messages.Message):
  r"""The metadata for the Operation returned by CreateCluster.

  Messages:
    TablesValue: Keys: the full `name` of each table that existed in the
      instance when CreateCluster was first called, i.e.
      `projects/<project>/instances/<instance>/tables/<table>`. Any table
      added to the instance by a later API call will be created in the new
      cluster by that API call, not this one.  Values: information on how much
      of a table's data has been copied to the newly-created cluster so far.

  Fields:
    finishTime: The time at which the operation failed or was completed
      successfully.
    originalRequest: The request that prompted the initiation of this
      CreateCluster operation.
    requestTime: The time at which the original request was received.
    tables: Keys: the full `name` of each table that existed in the instance
      when CreateCluster was first called, i.e.
      `projects/<project>/instances/<instance>/tables/<table>`. Any table
      added to the instance by a later API call will be created in the new
      cluster by that API call, not this one.  Values: information on how much
      of a table's data has been copied to the newly-created cluster so far.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TablesValue(_messages.Message):
    r"""Keys: the full `name` of each table that existed in the instance when
    CreateCluster was first called, i.e.
    `projects/<project>/instances/<instance>/tables/<table>`. Any table added
    to the instance by a later API call will be created in the new cluster by
    that API call, not this one.  Values: information on how much of a table's
    data has been copied to the newly-created cluster so far.

    Messages:
      AdditionalProperty: An additional property for a TablesValue object.

    Fields:
      additionalProperties: Additional properties of type TablesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TablesValue object.

      Fields:
        key: Name of the additional property.
        value: A TableProgress attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('TableProgress', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  finishTime = _messages.StringField(1)
  originalRequest = _messages.MessageField('CreateClusterRequest', 2)
  requestTime = _messages.StringField(3)
  tables = _messages.MessageField('TablesValue', 4)


class CreateClusterRequest(_messages.Message):
  r"""Request message for BigtableInstanceAdmin.CreateCluster.

  Fields:
    cluster: The cluster to be created. Fields marked `OutputOnly` must be
      left blank.
    clusterId: The ID to be used when referring to the new cluster within its
      instance, e.g., just `mycluster` rather than
      `projects/myproject/instances/myinstance/clusters/mycluster`.
    parent: The unique name of the instance in which to create the new
      cluster. Values are of the form
      `projects/<project>/instances/<instance>`.
  """

  cluster = _messages.MessageField('Cluster', 1)
  clusterId = _messages.StringField(2)
  parent = _messages.StringField(3)


class CreateInstanceMetadata(_messages.Message):
  r"""The metadata for the Operation returned by CreateInstance.

  Fields:
    finishTime: The time at which the operation failed or was completed
      successfully.
    originalRequest: The request that prompted the initiation of this
      CreateInstance operation.
    requestTime: The time at which the original request was received.
  """

  finishTime = _messages.StringField(1)
  originalRequest = _messages.MessageField('CreateInstanceRequest', 2)
  requestTime = _messages.StringField(3)


class CreateInstanceRequest(_messages.Message):
  r"""Request message for BigtableInstanceAdmin.CreateInstance.

  Messages:
    ClustersValue: The clusters to be created within the instance, mapped by
      desired cluster ID, e.g., just `mycluster` rather than
      `projects/myproject/instances/myinstance/clusters/mycluster`. Fields
      marked `OutputOnly` must be left blank. Currently, at most four clusters
      can be specified.

  Fields:
    clusters: The clusters to be created within the instance, mapped by
      desired cluster ID, e.g., just `mycluster` rather than
      `projects/myproject/instances/myinstance/clusters/mycluster`. Fields
      marked `OutputOnly` must be left blank. Currently, at most four clusters
      can be specified.
    instance: The instance to create. Fields marked `OutputOnly` must be left
      blank.
    instanceId: The ID to be used when referring to the new instance within
      its project, e.g., just `myinstance` rather than
      `projects/myproject/instances/myinstance`.
    parent: The unique name of the project in which to create the new
      instance. Values are of the form `projects/<project>`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ClustersValue(_messages.Message):
    r"""The clusters to be created within the instance, mapped by desired
    cluster ID, e.g., just `mycluster` rather than
    `projects/myproject/instances/myinstance/clusters/mycluster`. Fields
    marked `OutputOnly` must be left blank. Currently, at most four clusters
    can be specified.

    Messages:
      AdditionalProperty: An additional property for a ClustersValue object.

    Fields:
      additionalProperties: Additional properties of type ClustersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ClustersValue object.

      Fields:
        key: Name of the additional property.
        value: A Cluster attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Cluster', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusters = _messages.MessageField('ClustersValue', 1)
  instance = _messages.MessageField('Instance', 2)
  instanceId = _messages.StringField(3)
  parent = _messages.StringField(4)


class CreateTableRequest(_messages.Message):
  r"""Request message for
  google.bigtable.admin.v2.BigtableTableAdmin.CreateTable

  Fields:
    initialSplits: The optional list of row keys that will be used to
      initially split the table into several tablets (tablets are similar to
      HBase regions). Given two split keys, `s1` and `s2`, three tablets will
      be created, spanning the key ranges: `[, s1), [s1, s2), [s2, )`.
      Example:  * Row keys := `["a", "apple", "custom", "customer_1",
      "customer_2",`                `"other", "zz"]` * initial_split_keys :=
      `["apple", "customer_1", "customer_2", "other"]` * Key assignment:     -
      Tablet 1 `[, apple)                => {"a"}.`     - Tablet 2 `[apple,
      customer_1)      => {"apple", "custom"}.`     - Tablet 3 `[customer_1,
      customer_2) => {"customer_1"}.`     - Tablet 4 `[customer_2, other)
      => {"customer_2"}.`     - Tablet 5 `[other, )                =>
      {"other", "zz"}.`
    table: The Table to create.
    tableId: The name by which the new table should be referred to within the
      parent instance, e.g., `foobar` rather than `<parent>/tables/foobar`.
      Maximum 50 characters.
  """

  initialSplits = _messages.MessageField('Split', 1, repeated=True)
  table = _messages.MessageField('Table', 2)
  tableId = _messages.StringField(3)


class DropRowRangeRequest(_messages.Message):
  r"""Request message for
  google.bigtable.admin.v2.BigtableTableAdmin.DropRowRange

  Fields:
    deleteAllDataFromTable: Delete all rows in the table. Setting this to
      false is a no-op.
    rowKeyPrefix: Delete all rows that start with this row key prefix. Prefix
      cannot be zero length.
  """

  deleteAllDataFromTable = _messages.BooleanField(1)
  rowKeyPrefix = _messages.BytesField(2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents an expression text. Example:      title: "User account
  presence"     description: "Determines whether the request has a user
  account"     expression: "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GcRule(_messages.Message):
  r"""Rule for determining which cells to delete during garbage collection.

  Fields:
    intersection: Delete cells that would be deleted by every nested rule.
    maxAge: Delete cells in a column older than the given age. Values must be
      at least one millisecond, and will be truncated to microsecond
      granularity.
    maxNumVersions: Delete all cells in a column except the most recent N.
    union: Delete cells that would be deleted by any nested rule.
  """

  intersection = _messages.MessageField('Intersection', 1)
  maxAge = _messages.StringField(2)
  maxNumVersions = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  union = _messages.MessageField('Union', 4)


class GenerateConsistencyTokenRequest(_messages.Message):
  r"""Request message for
  google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken
  """



class GenerateConsistencyTokenResponse(_messages.Message):
  r"""Response message for
  google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken

  Fields:
    consistencyToken: The generated consistency token.
  """

  consistencyToken = _messages.StringField(1)


class GetIamPolicyRequest(_messages.Message):
  r"""Request message for `GetIamPolicy` method.

  Fields:
    options: OPTIONAL: A `GetPolicyOptions` object for specifying options to
      `GetIamPolicy`. This field is only used by Cloud IAM.
  """

  options = _messages.MessageField('GetPolicyOptions', 1)


class GetPolicyOptions(_messages.Message):
  r"""Encapsulates settings provided to GetIamPolicy.

  Fields:
    requestedPolicyVersion: Optional. The policy format version to be
      returned.  Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.  Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.
  """

  requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class Instance(_messages.Message):
  r"""A collection of Bigtable Tables and the resources that serve them. All
  tables in an instance are served from all Clusters in the instance.

  Enums:
    StateValueValuesEnum: (`OutputOnly`) The current state of the instance.
    TypeValueValuesEnum: The type of the instance. Defaults to `PRODUCTION`.

  Messages:
    LabelsValue: Labels are a flexible and lightweight mechanism for
      organizing cloud resources into groups that reflect a customer's
      organizational needs and deployment strategies. They can be used to
      filter resources and aggregate metrics.  * Label keys must be between 1
      and 63 characters long and must conform to   the regular expression:
      `\p{Ll}\p{Lo}{0,62}`. * Label values must be between 0 and 63 characters
      long and must conform to   the regular expression:
      `[\p{Ll}\p{Lo}\p{N}_-]{0,63}`. * No more than 64 labels can be
      associated with a given resource. * Keys and values must both be under
      128 bytes.

  Fields:
    displayName: The descriptive name for this instance as it appears in UIs.
      Can be changed at any time, but should be kept globally unique to avoid
      confusion.
    labels: Labels are a flexible and lightweight mechanism for organizing
      cloud resources into groups that reflect a customer's organizational
      needs and deployment strategies. They can be used to filter resources
      and aggregate metrics.  * Label keys must be between 1 and 63 characters
      long and must conform to   the regular expression: `\p{Ll}\p{Lo}{0,62}`.
      * Label values must be between 0 and 63 characters long and must conform
      to   the regular expression: `[\p{Ll}\p{Lo}\p{N}_-]{0,63}`. * No more
      than 64 labels can be associated with a given resource. * Keys and
      values must both be under 128 bytes.
    name: (`OutputOnly`) The unique name of the instance. Values are of the
      form `projects/<project>/instances/a-z+[a-z0-9]`.
    state: (`OutputOnly`) The current state of the instance.
    type: The type of the instance. Defaults to `PRODUCTION`.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""(`OutputOnly`) The current state of the instance.

    Values:
      STATE_NOT_KNOWN: The state of the instance could not be determined.
      READY: The instance has been successfully created and can serve requests
        to its tables.
      CREATING: The instance is currently being created, and may be destroyed
        if the creation process encounters an error.
    """
    STATE_NOT_KNOWN = 0
    READY = 1
    CREATING = 2

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of the instance. Defaults to `PRODUCTION`.

    Values:
      TYPE_UNSPECIFIED: The type of the instance is unspecified. If set when
        creating an instance, a `PRODUCTION` instance will be created. If set
        when updating an instance, the type will be left unchanged.
      PRODUCTION: An instance meant for production use. `serve_nodes` must be
        set on the cluster.
      DEVELOPMENT: The instance is meant for development and testing purposes
        only; it has no performance or uptime guarantees and is not covered by
        SLA. After a development instance is created, it can be upgraded by
        updating the instance to type `PRODUCTION`. An instance created as a
        production instance cannot be changed to a development instance. When
        creating a development instance, `serve_nodes` on the cluster must not
        be set.
    """
    TYPE_UNSPECIFIED = 0
    PRODUCTION = 1
    DEVELOPMENT = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels are a flexible and lightweight mechanism for organizing cloud
    resources into groups that reflect a customer's organizational needs and
    deployment strategies. They can be used to filter resources and aggregate
    metrics.  * Label keys must be between 1 and 63 characters long and must
    conform to   the regular expression: `\p{Ll}\p{Lo}{0,62}`. * Label values
    must be between 0 and 63 characters long and must conform to   the regular
    expression: `[\p{Ll}\p{Lo}\p{N}_-]{0,63}`. * No more than 64 labels can be
    associated with a given resource. * Keys and values must both be under 128
    bytes.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  type = _messages.EnumField('TypeValueValuesEnum', 5)


class Intersection(_messages.Message):
  r"""A GcRule which deletes cells matching all of the given rules.

  Fields:
    rules: Only delete cells which would be deleted by every element of
      `rules`.
  """

  rules = _messages.MessageField('GcRule', 1, repeated=True)


class ListAppProfilesResponse(_messages.Message):
  r"""Response message for BigtableInstanceAdmin.ListAppProfiles.

  Fields:
    appProfiles: The list of requested app profiles.
    failedLocations: Locations from which AppProfile information could not be
      retrieved, due to an outage or some other transient condition.
      AppProfiles from these locations may be missing from `app_profiles`.
      Values are of the form `projects/<project>/locations/<zone_id>`
    nextPageToken: Set if not all app profiles could be returned in a single
      response. Pass this value to `page_token` in another request to get the
      next page of results.
  """

  appProfiles = _messages.MessageField('AppProfile', 1, repeated=True)
  failedLocations = _messages.StringField(2, repeated=True)
  nextPageToken = _messages.StringField(3)


class ListBackupsResponse(_messages.Message):
  r"""The response for ListBackups.

  Fields:
    backups: The list of matching backups.
    nextPageToken: `next_page_token` can be sent in a subsequent ListBackups
      call to fetch more of the matching backups.
  """

  backups = _messages.MessageField('Backup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListClustersResponse(_messages.Message):
  r"""Response message for BigtableInstanceAdmin.ListClusters.

  Fields:
    clusters: The list of requested clusters.
    failedLocations: Locations from which Cluster information could not be
      retrieved, due to an outage or some other transient condition. Clusters
      from these locations may be missing from `clusters`, or may only have
      partial information returned. Values are of the form
      `projects/<project>/locations/<zone_id>`
    nextPageToken: DEPRECATED: This field is unused and ignored.
  """

  clusters = _messages.MessageField('Cluster', 1, repeated=True)
  failedLocations = _messages.StringField(2, repeated=True)
  nextPageToken = _messages.StringField(3)


class ListInstancesResponse(_messages.Message):
  r"""Response message for BigtableInstanceAdmin.ListInstances.

  Fields:
    failedLocations: Locations from which Instance information could not be
      retrieved, due to an outage or some other transient condition. Instances
      whose Clusters are all in one of the failed locations may be missing
      from `instances`, and Instances with at least one Cluster in a failed
      location may only have partial information returned. Values are of the
      form `projects/<project>/locations/<zone_id>`
    instances: The list of requested instances.
    nextPageToken: DEPRECATED: This field is unused and ignored.
  """

  failedLocations = _messages.StringField(1, repeated=True)
  instances = _messages.MessageField('Instance', 2, repeated=True)
  nextPageToken = _messages.StringField(3)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListTablesResponse(_messages.Message):
  r"""Response message for
  google.bigtable.admin.v2.BigtableTableAdmin.ListTables

  Fields:
    nextPageToken: Set if not all tables could be returned in a single
      response. Pass this value to `page_token` in another request to get the
      next page of results.
    tables: The tables present in the requested instance.
  """

  nextPageToken = _messages.StringField(1)
  tables = _messages.MessageField('Table', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Modification(_messages.Message):
  r"""A create, update, or delete of a particular column family.

  Fields:
    create: Create a new column family with the specified schema, or fail if
      one already exists with the given ID.
    drop: Drop (delete) the column family with the given ID, or fail if no
      such family exists.
    id: The ID of the column family to be modified.
    update: Update an existing column family to the specified schema, or fail
      if no column family exists with the given ID.
  """

  create = _messages.MessageField('ColumnFamily', 1)
  drop = _messages.BooleanField(2)
  id = _messages.StringField(3)
  update = _messages.MessageField('ColumnFamily', 4)


class ModifyColumnFamiliesRequest(_messages.Message):
  r"""Request message for
  google.bigtable.admin.v2.BigtableTableAdmin.ModifyColumnFamilies

  Fields:
    modifications: Modifications to be atomically applied to the specified
      table's families. Entries are applied in order, meaning that earlier
      modifications can be masked by later ones (in the case of repeated
      updates to the same family, for example).
  """

  modifications = _messages.MessageField('Modification', 1, repeated=True)


class MultiClusterRoutingUseAny(_messages.Message):
  r"""Read/write requests are routed to the nearest cluster in the instance,
  and will fail over to the nearest cluster that is available in the event of
  transient errors or delays. Clusters in a region are considered equidistant.
  Choosing this option sacrifices read-your-writes consistency to improve
  availability.
  """



class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationProgress(_messages.Message):
  r"""Encapsulates progress related information for a Cloud Bigtable long
  running operation.

  Fields:
    endTime: If set, the time at which this operation failed or was completed
      successfully.
    progressPercent: Percent completion of the operation. Values are between 0
      and 100 inclusive.
    startTime: Time the request was received.
  """

  endTime = _messages.StringField(1)
  progressPercent = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  startTime = _messages.StringField(3)


class OptimizeRestoredTableMetadata(_messages.Message):
  r"""Metadata type for the long-running operation used to track the progress
  of optimizations performed on a newly restored table. This long-running
  operation is automatically created by the system after the successful
  completion of a table restore, and cannot be cancelled.

  Fields:
    name: Name of the restored table being optimized.
    progress: The progress of the post-restore optimizations.
  """

  name = _messages.StringField(1)
  progress = _messages.MessageField('OperationProgress', 2)


class PartialUpdateInstanceRequest(_messages.Message):
  r"""Request message for BigtableInstanceAdmin.PartialUpdateInstance.

  Fields:
    instance: The Instance which will (partially) replace the current value.
    updateMask: The subset of Instance fields which should be replaced. Must
      be explicitly set.
  """

  instance = _messages.MessageField('Instance', 1)
  updateMask = _messages.StringField(2)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources.   A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role.  Optionally, a
  `binding` can specify a `condition`, which is a logical expression that
  allows access to a resource only if the expression evaluates to `true`. A
  condition can add constraints based on attributes of the request, the
  resource, or both.  **JSON example:**      {       "bindings": [         {
  "role": "roles/resourcemanager.organizationAdmin",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-project-
  id@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/resourcemanager.organizationViewer",           "members":
  ["user:eve@example.com"],           "condition": {             "title":
  "expirable access",             "description": "Does not grant access after
  Sep 2020",             "expression": "request.time <
  timestamp('2020-10-01T00:00:00.000Z')",           }         }       ],
  "etag": "BwWWja0YfJA=",       "version": 3     }  **YAML example:**
  bindings:     - members:       - user:mike@example.com       -
  group:admins@example.com       - domain:google.com       - serviceAccount
  :my-project-id@appspot.gserviceaccount.com       role:
  roles/resourcemanager.organizationAdmin     - members:       -
  user:eve@example.com       role: roles/resourcemanager.organizationViewer
  condition:         title: expirable access         description: Does not
  grant access after Sep 2020         expression: request.time <
  timestamp('2020-10-01T00:00:00.000Z')     - etag: BwWWja0YfJA=     -
  version: 3  For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy.  Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected.  Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations:  * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy   that includes conditions  **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost.  If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class RestoreInfo(_messages.Message):
  r"""Information about a table restore.

  Enums:
    SourceTypeValueValuesEnum: The type of the restore source.

  Fields:
    backupInfo: Information about the backup used to restore the table. The
      backup may no longer exist.
    sourceType: The type of the restore source.
  """

  class SourceTypeValueValuesEnum(_messages.Enum):
    r"""The type of the restore source.

    Values:
      RESTORE_SOURCE_TYPE_UNSPECIFIED: No restore associated.
      BACKUP: A backup was used as the source of the restore.
    """
    RESTORE_SOURCE_TYPE_UNSPECIFIED = 0
    BACKUP = 1

  backupInfo = _messages.MessageField('BackupInfo', 1)
  sourceType = _messages.EnumField('SourceTypeValueValuesEnum', 2)


class RestoreTableMetadata(_messages.Message):
  r"""Metadata type for the long-running operation returned by RestoreTable.

  Enums:
    SourceTypeValueValuesEnum: The type of the restore source.

  Fields:
    backupInfo: A BackupInfo attribute.
    name: Name of the table being created and restored to.
    optimizeTableOperationName: If exists, the name of the long-running
      operation that will be used to track the post-restore optimization
      process to optimize the performance of the restored table. The metadata
      type of the long-running operation is OptimizeRestoreTableMetadata. The
      response type is Empty. This long-running operation will be
      automatically created by the system after the RestoreTable long-running
      operation completes successfully. This operation will not be created if
      the restore was not successful.
    progress: The progress of the RestoreTable operation.
    sourceType: The type of the restore source.
  """

  class SourceTypeValueValuesEnum(_messages.Enum):
    r"""The type of the restore source.

    Values:
      RESTORE_SOURCE_TYPE_UNSPECIFIED: No restore associated.
      BACKUP: A backup was used as the source of the restore.
    """
    RESTORE_SOURCE_TYPE_UNSPECIFIED = 0
    BACKUP = 1

  backupInfo = _messages.MessageField('BackupInfo', 1)
  name = _messages.StringField(2)
  optimizeTableOperationName = _messages.StringField(3)
  progress = _messages.MessageField('OperationProgress', 4)
  sourceType = _messages.EnumField('SourceTypeValueValuesEnum', 5)


class RestoreTableRequest(_messages.Message):
  r"""The request for RestoreTable.

  Fields:
    backup: Name of the backup from which to restore.  Values are of the form
      `projects/<project>/instances/<instance>/clusters/<cluster>/backups/<bac
      kup>`.
    tableId: Required. The id of the table to create and restore to. This
      table must not already exist. The `table_id` appended to `parent` forms
      the full table name of the form
      `projects/<project>/instances/<instance>/tables/<table_id>`.
  """

  backup = _messages.StringField(1)
  tableId = _messages.StringField(2)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class SingleClusterRouting(_messages.Message):
  r"""Unconditionally routes all read/write requests to a specific cluster.
  This option preserves read-your-writes consistency but does not improve
  availability.

  Fields:
    allowTransactionalWrites: Whether or not `CheckAndMutateRow` and
      `ReadModifyWriteRow` requests are allowed by this app profile. It is
      unsafe to send these requests to the same table/row/column in multiple
      clusters.
    clusterId: The cluster to which read/write requests should be routed.
  """

  allowTransactionalWrites = _messages.BooleanField(1)
  clusterId = _messages.StringField(2)


class Split(_messages.Message):
  r"""An initial split point for a newly created table.

  Fields:
    key: Row key to use as an initial tablet boundary.
  """

  key = _messages.BytesField(1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Table(_messages.Message):
  r"""A collection of user data indexed by row, column, and timestamp. Each
  table is served using the resources of its parent cluster.

  Enums:
    GranularityValueValuesEnum: (`CreationOnly`) The granularity (i.e.
      `MILLIS`) at which timestamps are stored in this table. Timestamps not
      matching the granularity will be rejected. If unspecified at creation
      time, the value will be set to `MILLIS`. Views: `SCHEMA_VIEW`, `FULL`.

  Messages:
    ClusterStatesValue: Output only. Map from cluster ID to per-cluster table
      state. If it could not be determined whether or not the table has data
      in a particular cluster (for example, if its zone is unavailable), then
      there will be an entry for the cluster with UNKNOWN
      `replication_status`. Views: `REPLICATION_VIEW`, `FULL`
    ColumnFamiliesValue: (`CreationOnly`) The column families configured for
      this table, mapped by column family ID. Views: `SCHEMA_VIEW`, `FULL`

  Fields:
    clusterStates: Output only. Map from cluster ID to per-cluster table
      state. If it could not be determined whether or not the table has data
      in a particular cluster (for example, if its zone is unavailable), then
      there will be an entry for the cluster with UNKNOWN
      `replication_status`. Views: `REPLICATION_VIEW`, `FULL`
    columnFamilies: (`CreationOnly`) The column families configured for this
      table, mapped by column family ID. Views: `SCHEMA_VIEW`, `FULL`
    granularity: (`CreationOnly`) The granularity (i.e. `MILLIS`) at which
      timestamps are stored in this table. Timestamps not matching the
      granularity will be rejected. If unspecified at creation time, the value
      will be set to `MILLIS`. Views: `SCHEMA_VIEW`, `FULL`.
    name: Output only. The unique name of the table. Values are of the form
      `projects/<project>/instances/<instance>/tables/_a-zA-Z0-9*`. Views:
      `NAME_ONLY`, `SCHEMA_VIEW`, `REPLICATION_VIEW`, `FULL`
    restoreInfo: Output only. If this table was restored from another data
      source (e.g. a backup), this field will be populated with information
      about the restore.
  """

  class GranularityValueValuesEnum(_messages.Enum):
    r"""(`CreationOnly`) The granularity (i.e. `MILLIS`) at which timestamps
    are stored in this table. Timestamps not matching the granularity will be
    rejected. If unspecified at creation time, the value will be set to
    `MILLIS`. Views: `SCHEMA_VIEW`, `FULL`.

    Values:
      TIMESTAMP_GRANULARITY_UNSPECIFIED: The user did not specify a
        granularity. Should not be returned. When specified during table
        creation, MILLIS will be used.
      MILLIS: The table keeps data versioned at a granularity of 1ms.
    """
    TIMESTAMP_GRANULARITY_UNSPECIFIED = 0
    MILLIS = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ClusterStatesValue(_messages.Message):
    r"""Output only. Map from cluster ID to per-cluster table state. If it
    could not be determined whether or not the table has data in a particular
    cluster (for example, if its zone is unavailable), then there will be an
    entry for the cluster with UNKNOWN `replication_status`. Views:
    `REPLICATION_VIEW`, `FULL`

    Messages:
      AdditionalProperty: An additional property for a ClusterStatesValue
        object.

    Fields:
      additionalProperties: Additional properties of type ClusterStatesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ClusterStatesValue object.

      Fields:
        key: Name of the additional property.
        value: A ClusterState attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ClusterState', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ColumnFamiliesValue(_messages.Message):
    r"""(`CreationOnly`) The column families configured for this table, mapped
    by column family ID. Views: `SCHEMA_VIEW`, `FULL`

    Messages:
      AdditionalProperty: An additional property for a ColumnFamiliesValue
        object.

    Fields:
      additionalProperties: Additional properties of type ColumnFamiliesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ColumnFamiliesValue object.

      Fields:
        key: Name of the additional property.
        value: A ColumnFamily attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ColumnFamily', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusterStates = _messages.MessageField('ClusterStatesValue', 1)
  columnFamilies = _messages.MessageField('ColumnFamiliesValue', 2)
  granularity = _messages.EnumField('GranularityValueValuesEnum', 3)
  name = _messages.StringField(4)
  restoreInfo = _messages.MessageField('RestoreInfo', 5)


class TableProgress(_messages.Message):
  r"""Progress info for copying a table's data to the new cluster.

  Enums:
    StateValueValuesEnum:

  Fields:
    estimatedCopiedBytes: Estimate of the number of bytes copied so far for
      this table. This will eventually reach 'estimated_size_bytes' unless the
      table copy is CANCELLED.
    estimatedSizeBytes: Estimate of the size of the table to be copied.
    state: A StateValueValuesEnum attribute.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""StateValueValuesEnum enum type.

    Values:
      STATE_UNSPECIFIED: <no description>
      PENDING: The table has not yet begun copying to the new cluster.
      COPYING: The table is actively being copied to the new cluster.
      COMPLETED: The table has been fully copied to the new cluster.
      CANCELLED: The table was deleted before it finished copying to the new
        cluster. Note that tables deleted after completion will stay marked as
        COMPLETED, not CANCELLED.
    """
    STATE_UNSPECIFIED = 0
    PENDING = 1
    COPYING = 2
    COMPLETED = 3
    CANCELLED = 4

  estimatedCopiedBytes = _messages.IntegerField(1)
  estimatedSizeBytes = _messages.IntegerField(2)
  state = _messages.EnumField('StateValueValuesEnum', 3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class Union(_messages.Message):
  r"""A GcRule which deletes cells matching any of the given rules.

  Fields:
    rules: Delete cells which would be deleted by any element of `rules`.
  """

  rules = _messages.MessageField('GcRule', 1, repeated=True)


class UpdateAppProfileMetadata(_messages.Message):
  r"""The metadata for the Operation returned by UpdateAppProfile."""


class UpdateClusterMetadata(_messages.Message):
  r"""The metadata for the Operation returned by UpdateCluster.

  Fields:
    finishTime: The time at which the operation failed or was completed
      successfully.
    originalRequest: The request that prompted the initiation of this
      UpdateCluster operation.
    requestTime: The time at which the original request was received.
  """

  finishTime = _messages.StringField(1)
  originalRequest = _messages.MessageField('Cluster', 2)
  requestTime = _messages.StringField(3)


class UpdateInstanceMetadata(_messages.Message):
  r"""The metadata for the Operation returned by UpdateInstance.

  Fields:
    finishTime: The time at which the operation failed or was completed
      successfully.
    originalRequest: The request that prompted the initiation of this
      UpdateInstance operation.
    requestTime: The time at which the original request was received.
  """

  finishTime = _messages.StringField(1)
  originalRequest = _messages.MessageField('PartialUpdateInstanceRequest', 2)
  requestTime = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
