"""Generated message classes for logging version v2.

Writes log entries and manages your Stackdriver Logging configuration. The
table entries below are presented in alphabetical order, not in order of
common use. For explanations of the concepts found in the table entries, read
the <a href=https://cloud.google.com/logging/docs>Stackdriver Logging
documentation</a>.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'logging'


class BigQueryOptions(_messages.Message):
  r"""Options that change functionality of a sink exporting data to BigQuery.

  Fields:
    usePartitionedTables: Optional. Whether to use BigQuery's partition
      tables. By default, Logging creates dated tables based on the log
      entries' timestamps, e.g. syslog_20170523. With partitioned tables the
      date suffix is no longer present and special query syntax has to be used
      instead. In both cases, tables are sharded based on UTC timezone.
  """

  usePartitionedTables = _messages.BooleanField(1)


class BucketOptions(_messages.Message):
  r"""BucketOptions describes the bucket boundaries used to create a histogram
  for the distribution. The buckets can be in a linear sequence, an
  exponential sequence, or each bucket can be specified explicitly.
  BucketOptions does not include the number of values in each bucket.A bucket
  has an inclusive lower bound and exclusive upper bound for the values that
  are counted for that bucket. The upper bound of a bucket must be strictly
  greater than the lower bound. The sequence of N buckets for a distribution
  consists of an underflow bucket (number 0), zero or more finite buckets
  (number 1 through N - 2) and an overflow bucket (number N - 1). The buckets
  are contiguous: the lower bound of bucket i (i > 0) is the same as the upper
  bound of bucket i - 1. The buckets span the whole range of finite values:
  lower bound of the underflow bucket is -infinity and the upper bound of the
  overflow bucket is +infinity. The finite buckets are so-called because both
  bounds are finite.

  Fields:
    explicitBuckets: The explicit buckets.
    exponentialBuckets: The exponential buckets.
    linearBuckets: The linear bucket.
  """

  explicitBuckets = _messages.MessageField('Explicit', 1)
  exponentialBuckets = _messages.MessageField('Exponential', 2)
  linearBuckets = _messages.MessageField('Linear', 3)


class CmekSettings(_messages.Message):
  r"""Describes the customer-managed encryption key (CMEK) settings associated
  with a project, folder, organization, billing account, or flexible
  resource.Note: CMEK for the Logs Router can currently only be configured for
  GCP organizations. Once configured, it applies to all projects and folders
  in the GCP organization.See Enabling CMEK for Logs Router for more
  information.

  Fields:
    kmsKeyName: The resource name for the configured Cloud KMS key.KMS key
      name format:  "projects/PROJECT_ID/locations/LOCATION/keyRings/KEYRING/c
      ryptoKeys/KEY"For example:  "projects/my-project-id/locations/my-
      region/keyRings/key-ring-name/cryptoKeys/key-name"To enable CMEK for the
      Logs Router, set this field to a valid kms_key_name for which the
      associated service account has the required
      roles/cloudkms.cryptoKeyEncrypterDecrypter role assigned for the key.The
      Cloud KMS key used by the Log Router can be updated by changing the
      kms_key_name to a new valid key name. Encryption operations that are in
      progress will be completed with the key that was in use when they
      started. Decryption operations will be completed using the key that was
      used at the time of encryption unless access to that key has been
      revoked.To disable CMEK for the Logs Router, set this field to an empty
      string.See Enabling CMEK for Logs Router for more information.
    name: Output Only. The resource name of the CMEK settings.
    serviceAccountId: Output Only. The service account that will be used by
      the Logs Router to access your Cloud KMS key.Before enabling CMEK for
      Logs Router, you must first assign the role
      roles/cloudkms.cryptoKeyEncrypterDecrypter to the service account that
      the Logs Router will use to access your Cloud KMS key. Use
      GetCmekSettings to obtain the service account ID.See Enabling CMEK for
      Logs Router for more information.
  """

  kmsKeyName = _messages.StringField(1)
  name = _messages.StringField(2)
  serviceAccountId = _messages.StringField(3)


class DlpOptions(_messages.Message):
  r"""Options specific to sinks that require de-identification by the Data
  Loss Prevention (DLP) API.

  Fields:
    deidentifyTemplateName: Required. DLP template used to specify how to
      perform the de-identification of log data. See Creating Cloud DLP de-
      identification templates. For example:
      "projects/[PROJECT_ID]/deidentifyTemplates/[TEMPLATE_ID]"
    includedFields: Optional. Fields within the log entries to include in DLP
      de-identification. Each field is identified using the advanced logs
      filter syntax. If any fields are specified, the de-identification will
      only be applied to these fields and other fields will remain unmodified.
      If no fields are specified, payload and http_request fields will be
      included in the de-identification. Specifying included fields is useful
      for limiting the amount of billable data sent to the DLP API. For
      example:"httpRequest.remoteIp"  "jsonPayload.user.phoneNumber"
      "jsonPayload.person.socialSecurityNumber"
    inspectTemplateName: Required. DLP template used to specify what types of
      data within a log to inspect. See Creating Cloud DLP inspection
      templates. For example:
      "projects/[PROJECT_ID]/inspectTemplates/[TEMPLATE_ID]"
  """

  deidentifyTemplateName = _messages.StringField(1)
  includedFields = _messages.StringField(2, repeated=True)
  inspectTemplateName = _messages.StringField(3)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo {   rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for Empty is empty JSON object {}.
  """



class Explicit(_messages.Message):
  r"""Specifies a set of buckets with arbitrary widths.There are size(bounds)
  + 1 (= N) buckets. Bucket i has the following boundaries:Upper bound (0 <= i
  < N-1): boundsi  Lower bound (1 <= i < N); boundsi - 1The bounds field must
  contain at least one element. If bounds has only one element, then there are
  no finite buckets, and that single element is the common boundary of the
  overflow and underflow buckets.

  Fields:
    bounds: The values must be monotonically increasing.
  """

  bounds = _messages.FloatField(1, repeated=True)


class Exponential(_messages.Message):
  r"""Specifies an exponential sequence of buckets that have a width that is
  proportional to the value of the lower bound. Each bucket represents a
  constant relative uncertainty on a specific value in the bucket.There are
  num_finite_buckets + 2 (= N) buckets. Bucket i has the following
  boundaries:Upper bound (0 <= i < N-1): scale * (growth_factor ^ i).  Lower
  bound (1 <= i < N): scale * (growth_factor ^ (i - 1)).

  Fields:
    growthFactor: Must be greater than 1.
    numFiniteBuckets: Must be greater than 0.
    scale: Must be greater than 0.
  """

  growthFactor = _messages.FloatField(1)
  numFiniteBuckets = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  scale = _messages.FloatField(3)


class HttpRequest(_messages.Message):
  r"""A common proto for logging HTTP requests. Only contains semantics
  defined by the HTTP specification. Product-specific logging information MUST
  be defined in a separate message.

  Fields:
    cacheFillBytes: The number of HTTP response bytes inserted into cache. Set
      only when a cache fill was attempted.
    cacheHit: Whether or not an entity was served from cache (with or without
      validation).
    cacheLookup: Whether or not a cache lookup was attempted.
    cacheValidatedWithOriginServer: Whether or not the response was validated
      with the origin server before being served from cache. This field is
      only meaningful if cache_hit is True.
    latency: The request processing latency on the server, from the time the
      request was received until the response was sent.
    protocol: Protocol used for the request. Examples: "HTTP/1.1", "HTTP/2",
      "websocket"
    referer: The referer URL of the request, as defined in HTTP/1.1 Header
      Field Definitions
      (http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
    remoteIp: The IP address (IPv4 or IPv6) of the client that issued the HTTP
      request. Examples: "192.168.1.1", "FE80::0202:B3FF:FE1E:8329".
    requestMethod: The request method. Examples: "GET", "HEAD", "PUT", "POST".
    requestSize: The size of the HTTP request message in bytes, including the
      request headers and the request body.
    requestUrl: The scheme (http, https), the host name, the path and the
      query portion of the URL that was requested. Example:
      "http://example.com/some/info?color=red".
    responseSize: The size of the HTTP response message sent back to the
      client, in bytes, including the response headers and the response body.
    serverIp: The IP address (IPv4 or IPv6) of the origin server that the
      request was sent to.
    status: The response code indicating the status of response. Examples:
      200, 404.
    userAgent: The user agent sent by the client. Example: "Mozilla/4.0
      (compatible; MSIE 6.0; Windows 98; Q312461; .NET CLR 1.0.3705)".
  """

  cacheFillBytes = _messages.IntegerField(1)
  cacheHit = _messages.BooleanField(2)
  cacheLookup = _messages.BooleanField(3)
  cacheValidatedWithOriginServer = _messages.BooleanField(4)
  latency = _messages.StringField(5)
  protocol = _messages.StringField(6)
  referer = _messages.StringField(7)
  remoteIp = _messages.StringField(8)
  requestMethod = _messages.StringField(9)
  requestSize = _messages.IntegerField(10)
  requestUrl = _messages.StringField(11)
  responseSize = _messages.IntegerField(12)
  serverIp = _messages.StringField(13)
  status = _messages.IntegerField(14, variant=_messages.Variant.INT32)
  userAgent = _messages.StringField(15)


class LabelDescriptor(_messages.Message):
  r"""A description of a label.

  Enums:
    ValueTypeValueValuesEnum: The type of data that can be assigned to the
      label.

  Fields:
    description: A human-readable description for the label.
    key: The label key.
    valueType: The type of data that can be assigned to the label.
  """

  class ValueTypeValueValuesEnum(_messages.Enum):
    r"""The type of data that can be assigned to the label.

    Values:
      STRING: A variable-length string. This is the default.
      BOOL: Boolean; true or false.
      INT64: A 64-bit signed integer.
    """
    STRING = 0
    BOOL = 1
    INT64 = 2

  description = _messages.StringField(1)
  key = _messages.StringField(2)
  valueType = _messages.EnumField('ValueTypeValueValuesEnum', 3)


class Linear(_messages.Message):
  r"""Specifies a linear sequence of buckets that all have the same width
  (except overflow and underflow). Each bucket represents a constant absolute
  uncertainty on the specific value in the bucket.There are num_finite_buckets
  + 2 (= N) buckets. Bucket i has the following boundaries:Upper bound (0 <= i
  < N-1): offset + (width * i).  Lower bound (1 <= i < N): offset + (width *
  (i - 1)).

  Fields:
    numFiniteBuckets: Must be greater than 0.
    offset: Lower bound of the first bucket.
    width: Must be greater than 0.
  """

  numFiniteBuckets = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  offset = _messages.FloatField(2)
  width = _messages.FloatField(3)


class ListBucketsResponse(_messages.Message):
  r"""The response from ListBuckets

  Fields:
    buckets: A list of buckets.
    nextPageToken: If there might be more results than appear in this
      response, then nextPageToken is included. To get the next set of
      results, call the same method again using the value of nextPageToken as
      pageToken.
  """

  buckets = _messages.MessageField('LogBucket', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListExclusionsResponse(_messages.Message):
  r"""Result returned from ListExclusions.

  Fields:
    exclusions: A list of exclusions.
    nextPageToken: If there might be more results than appear in this
      response, then nextPageToken is included. To get the next set of
      results, call the same method again using the value of nextPageToken as
      pageToken.
  """

  exclusions = _messages.MessageField('LogExclusion', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLogEntriesRequest(_messages.Message):
  r"""The parameters to ListLogEntries.

  Fields:
    filter: Optional. A filter that chooses which log entries to return. See
      Advanced Logs Queries. Only log entries that match the filter are
      returned. An empty filter matches all log entries in the resources
      listed in resource_names. Referencing a parent resource that is not
      listed in resource_names will cause the filter to return no results. The
      maximum length of the filter is 20000 characters.
    orderBy: Optional. How the results should be sorted. Presently, the only
      permitted values are "timestamp asc" (default) and "timestamp desc". The
      first option returns entries in order of increasing values of
      LogEntry.timestamp (oldest first), and the second option returns entries
      in order of decreasing timestamps (newest first). Entries with equal
      timestamps are returned in order of their insert_id values.
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of
      next_page_token in the response indicates that more results might be
      available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. page_token must be the value of
      next_page_token from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    projectIds: Deprecated. Use resource_names instead. One or more project
      identifiers or project numbers from which to retrieve log entries.
      Example: "my-project-1A".
    resourceNames: Required. Names of one or more parent resources from which
      to retrieve log entries: "projects/[PROJECT_ID]"
      "organizations/[ORGANIZATION_ID]" "billingAccounts/[BILLING_ACCOUNT_ID]"
      "folders/[FOLDER_ID]" Projects listed in the project_ids field are added
      to this list.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  projectIds = _messages.StringField(5, repeated=True)
  resourceNames = _messages.StringField(6, repeated=True)


class ListLogEntriesResponse(_messages.Message):
  r"""Result returned from ListLogEntries.

  Fields:
    entries: A list of log entries. If entries is empty, nextPageToken may
      still be returned, indicating that more entries may exist. See
      nextPageToken for more information.
    nextPageToken: If there might be more results than those appearing in this
      response, then nextPageToken is included. To get the next set of
      results, call this method again using the value of nextPageToken as
      pageToken.If a value for next_page_token appears and the entries field
      is empty, it means that the search found no log entries so far but it
      did not have time to search all the possible log entries. Retry the
      method with this value for page_token to continue the search.
      Alternatively, consider speeding up the search by changing your filter
      to specify a single log name or resource type, or to narrow the time
      range of the search.
    viewNames: The list of views that were examined. e.g. "projects/my-
      project/locations/my-location/buckets/my-bucket/views/my-view".
  """

  entries = _messages.MessageField('LogEntry', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  viewNames = _messages.StringField(3, repeated=True)


class ListLogMetricsResponse(_messages.Message):
  r"""Result returned from ListLogMetrics.

  Fields:
    metrics: A list of logs-based metrics.
    nextPageToken: If there might be more results than appear in this
      response, then nextPageToken is included. To get the next set of
      results, call this method again using the value of nextPageToken as
      pageToken.
  """

  metrics = _messages.MessageField('LogMetric', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLogsResponse(_messages.Message):
  r"""Result returned from ListLogs.

  Fields:
    logNames: A list of log names. For example, "projects/my-
      project/logs/syslog" or
      "organizations/123/logs/cloudresourcemanager.googleapis.com%2Factivity".
    nextPageToken: If there might be more results than those appearing in this
      response, then nextPageToken is included. To get the next set of
      results, call this method again using the value of nextPageToken as
      pageToken.
  """

  logNames = _messages.StringField(1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMonitoredResourceDescriptorsResponse(_messages.Message):
  r"""Result returned from ListMonitoredResourceDescriptors.

  Fields:
    nextPageToken: If there might be more results than those appearing in this
      response, then nextPageToken is included. To get the next set of
      results, call this method again using the value of nextPageToken as
      pageToken.
    resourceDescriptors: A list of resource descriptors.
  """

  nextPageToken = _messages.StringField(1)
  resourceDescriptors = _messages.MessageField('MonitoredResourceDescriptor', 2, repeated=True)


class ListSinksResponse(_messages.Message):
  r"""Result returned from ListSinks.

  Fields:
    nextPageToken: If there might be more results than appear in this
      response, then nextPageToken is included. To get the next set of
      results, call the same method again using the value of nextPageToken as
      pageToken.
    sinks: A list of sinks.
  """

  nextPageToken = _messages.StringField(1)
  sinks = _messages.MessageField('LogSink', 2, repeated=True)


class ListViewsResponse(_messages.Message):
  r"""The response from ListViews.

  Fields:
    nextPageToken: If there might be more results than appear in this
      response, then nextPageToken is included. To get the next set of
      results, call the same method again using the value of nextPageToken as
      pageToken.
    views: A list of views.
  """

  nextPageToken = _messages.StringField(1)
  views = _messages.MessageField('LogView', 2, repeated=True)


class LogBucket(_messages.Message):
  r"""Describes a repository of logs.

  Enums:
    LifecycleStateValueValuesEnum: The bucket lifecycle state.Output only.

  Fields:
    createTime: Output only. The creation timestamp of the bucket. This is not
      set for any of the default buckets.
    description: Describes this bucket.
    displayName: Display name of the bucket.
    etag: etag is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a bucket from overwriting each other. It
      is strongly suggested that systems make use of the etag in the read-
      modify-write cycle to perform bucket updates in order to avoid race
      conditions: An etag is returned in the response to getBucket, and
      systems are expected to put that etag in the request to setIamPolicy to
      ensure that their change will be applied to the same version of the
      bucket.If no etag is provided in the call to UpdateBucket, then the
      existing bucket is overwritten blindly.
    lifecycleState: The bucket lifecycle state.Output only.
    locked: Whether the bucket has been locked. The retention period on a
      locked bucket may not be changed. A locked bucket may not have any
      retention rules. Logs may not be deleted from a locked bucket.
    name: The resource name of the bucket. For example: "projects/my-project-
      id/locations/my-location/buckets/my-bucket-id The supported locations
      are:  "global"  "us-central1"For the location of global it is
      unspecified where logs are actually stored. Once a bucket has been
      created, the location can not be changed.
    retentionDays: Logs will be retained by default for this amount of time,
      after which they will automatically be deleted. The minimum retention
      period is 1 day. If this value is set to zero at bucket creation time,
      the default time of 30 days will be used.
    updateTime: Output only. The last update timestamp of the bucket.
  """

  class LifecycleStateValueValuesEnum(_messages.Enum):
    r"""The bucket lifecycle state.Output only.

    Values:
      LIFECYCLE_STATE_UNSPECIFIED: Unspecified state. This is only used/useful
        for distinguishing unset values.
      ACTIVE: The normal and active state.
      DELETE_REQUESTED: The bucket has been marked for deletion by the user
        (by invoking DeleteBucket). This can be reversed by invoking
        UndeleteBucket.
    """
    LIFECYCLE_STATE_UNSPECIFIED = 0
    ACTIVE = 1
    DELETE_REQUESTED = 2

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  etag = _messages.BytesField(4)
  lifecycleState = _messages.EnumField('LifecycleStateValueValuesEnum', 5)
  locked = _messages.BooleanField(6)
  name = _messages.StringField(7)
  retentionDays = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  updateTime = _messages.StringField(9)


class LogEntry(_messages.Message):
  r"""An individual entry in a log.

  Enums:
    SeverityValueValuesEnum: Optional. The severity of the log entry. The
      default value is LogSeverity.DEFAULT.

  Messages:
    JsonPayloadValue: The log entry payload, represented as a structure that
      is expressed as a JSON object.
    LabelsValue: Optional. A set of user-defined (key, value) data that
      provides additional information about the log entry.
    ProtoPayloadValue: The log entry payload, represented as a protocol
      buffer. Some Google Cloud Platform services use this field for their log
      entry payloads.The following protocol buffer types are supported; user-
      defined types are not
      supported:"type.googleapis.com/google.cloud.audit.AuditLog"
      "type.googleapis.com/google.appengine.logging.v1.RequestLog"

  Fields:
    httpRequest: Optional. Information about the HTTP request associated with
      this log entry, if applicable.
    insertId: Optional. A unique identifier for the log entry. If you provide
      a value, then Logging considers other log entries in the same project,
      with the same timestamp, and with the same insert_id to be duplicates
      which can be removed. If omitted in new log entries, then Logging
      assigns its own unique identifier. The insert_id is also used to order
      log entries that have the same timestamp value.
    jsonPayload: The log entry payload, represented as a structure that is
      expressed as a JSON object.
    labels: Optional. A set of user-defined (key, value) data that provides
      additional information about the log entry.
    logName: Required. The resource name of the log to which this log entry
      belongs: "projects/[PROJECT_ID]/logs/[LOG_ID]"
      "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
      "folders/[FOLDER_ID]/logs/[LOG_ID]" A project number may optionally be
      used in place of PROJECT_ID. The project number is translated to its
      corresponding PROJECT_ID internally and the log_name field will contain
      PROJECT_ID in queries and exports.[LOG_ID] must be URL-encoded within
      log_name. Example: "organizations/1234567890/logs/cloudresourcemanager.g
      oogleapis.com%2Factivity". [LOG_ID] must be less than 512 characters
      long and can only include the following characters: upper and lower case
      alphanumeric characters, forward-slash, underscore, hyphen, and
      period.For backward compatibility, if log_name begins with a forward-
      slash, such as /projects/..., then the log entry is ingested as usual
      but the forward-slash is removed. Listing the log entry will not show
      the leading slash and filtering for a log name with a leading slash will
      never return any results.
    metadata: Deprecated. Output only. Additional metadata about the monitored
      resource.Only k8s_container, k8s_pod, and k8s_node MonitoredResources
      have this field populated for GKE versions older than 1.12.6. For GKE
      versions 1.12.6 and above, the metadata field has been deprecated. The
      Kubernetes pod labels that used to be in metadata.userLabels will now be
      present in the labels field with a key prefix of k8s-pod/. The
      Stackdriver system labels that were present in the metadata.systemLabels
      field will no longer be available in the LogEntry.
    operation: Optional. Information about an operation associated with the
      log entry, if applicable.
    protoPayload: The log entry payload, represented as a protocol buffer.
      Some Google Cloud Platform services use this field for their log entry
      payloads.The following protocol buffer types are supported; user-defined
      types are not
      supported:"type.googleapis.com/google.cloud.audit.AuditLog"
      "type.googleapis.com/google.appengine.logging.v1.RequestLog"
    receiveTimestamp: Output only. The time the log entry was received by
      Logging.
    receivedLocation: Output only. The cloud region that this LogEntry was
      received in, such as "us-east1".
    resource: Required. The monitored resource that produced this log
      entry.Example: a log entry that reports a database error would be
      associated with the monitored resource designating the particular
      database that reported the error.
    severity: Optional. The severity of the log entry. The default value is
      LogSeverity.DEFAULT.
    sourceLocation: Optional. Source code location information associated with
      the log entry, if any.
    spanId: Optional. The span ID within the trace associated with the log
      entry.For Trace spans, this is the same format that the Trace API v2
      uses: a 16-character hexadecimal encoding of an 8-byte array, such as
      <code>"000000000000004a"</code>.
    textPayload: The log entry payload, represented as a Unicode string
      (UTF-8).
    timestamp: Optional. The time the event described by the log entry
      occurred. This time is used to compute the log entry's age and to
      enforce the logs retention period. If this field is omitted in a new log
      entry, then Logging assigns it the current time. Timestamps have
      nanosecond accuracy, but trailing zeros in the fractional seconds might
      be omitted when the timestamp is displayed.Incoming log entries should
      have timestamps that are no more than the logs retention period in the
      past, and no more than 24 hours in the future. Log entries outside those
      time boundaries will not be available when calling entries.list, but
      those log entries can still be exported with LogSinks.
    trace: Optional. Resource name of the trace associated with the log entry,
      if any. If it contains a relative resource name, the name is assumed to
      be relative to //tracing.googleapis.com. Example: projects/my-
      projectid/traces/06796866738c859f2f19b7cfb3214824
    traceSampled: Optional. The sampling decision of the trace associated with
      the log entry.True means that the trace resource name in the trace field
      was sampled for storage in a trace backend. False means that the trace
      was not sampled for storage when this log entry was written, or the
      sampling decision was unknown at the time. A non-sampled trace value is
      still useful as a request correlation identifier. The default is False.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Optional. The severity of the log entry. The default value is
    LogSeverity.DEFAULT.

    Values:
      DEFAULT: (0) The log entry has no assigned severity level.
      DEBUG: (100) Debug or trace information.
      INFO: (200) Routine information, such as ongoing status or performance.
      NOTICE: (300) Normal but significant events, such as start up, shut
        down, or a configuration change.
      WARNING: (400) Warning events might cause problems.
      ERROR: (500) Error events are likely to cause problems.
      CRITICAL: (600) Critical events cause more severe problems or outages.
      ALERT: (700) A person must take an action immediately.
      EMERGENCY: (800) One or more systems are unusable.
    """
    DEFAULT = 0
    DEBUG = 1
    INFO = 2
    NOTICE = 3
    WARNING = 4
    ERROR = 5
    CRITICAL = 6
    ALERT = 7
    EMERGENCY = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class JsonPayloadValue(_messages.Message):
    r"""The log entry payload, represented as a structure that is expressed as
    a JSON object.

    Messages:
      AdditionalProperty: An additional property for a JsonPayloadValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a JsonPayloadValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. A set of user-defined (key, value) data that provides
    additional information about the log entry.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ProtoPayloadValue(_messages.Message):
    r"""The log entry payload, represented as a protocol buffer. Some Google
    Cloud Platform services use this field for their log entry payloads.The
    following protocol buffer types are supported; user-defined types are not
    supported:"type.googleapis.com/google.cloud.audit.AuditLog"
    "type.googleapis.com/google.appengine.logging.v1.RequestLog"

    Messages:
      AdditionalProperty: An additional property for a ProtoPayloadValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ProtoPayloadValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  httpRequest = _messages.MessageField('HttpRequest', 1)
  insertId = _messages.StringField(2)
  jsonPayload = _messages.MessageField('JsonPayloadValue', 3)
  labels = _messages.MessageField('LabelsValue', 4)
  logName = _messages.StringField(5)
  metadata = _messages.MessageField('MonitoredResourceMetadata', 6)
  operation = _messages.MessageField('LogEntryOperation', 7)
  protoPayload = _messages.MessageField('ProtoPayloadValue', 8)
  receiveTimestamp = _messages.StringField(9)
  receivedLocation = _messages.StringField(10)
  resource = _messages.MessageField('MonitoredResource', 11)
  severity = _messages.EnumField('SeverityValueValuesEnum', 12)
  sourceLocation = _messages.MessageField('LogEntrySourceLocation', 13)
  spanId = _messages.StringField(14)
  textPayload = _messages.StringField(15)
  timestamp = _messages.StringField(16)
  trace = _messages.StringField(17)
  traceSampled = _messages.BooleanField(18)


class LogEntryOperation(_messages.Message):
  r"""Additional information about a potentially long-running operation with
  which a log entry is associated.

  Fields:
    first: Optional. Set this to True if this is the first log entry in the
      operation.
    id: Optional. An arbitrary operation identifier. Log entries with the same
      identifier are assumed to be part of the same operation.
    last: Optional. Set this to True if this is the last log entry in the
      operation.
    producer: Optional. An arbitrary producer identifier. The combination of
      id and producer must be globally unique. Examples for producer:
      "MyDivision.MyBigCompany.com", "github.com/MyProject/MyApplication".
  """

  first = _messages.BooleanField(1)
  id = _messages.StringField(2)
  last = _messages.BooleanField(3)
  producer = _messages.StringField(4)


class LogEntrySourceLocation(_messages.Message):
  r"""Additional information about the source code location that produced the
  log entry.

  Fields:
    file: Optional. Source file name. Depending on the runtime environment,
      this might be a simple name or a fully-qualified name.
    function: Optional. Human-readable name of the function or method being
      invoked, with optional context such as the class or package name. This
      information may be used in contexts such as the logs viewer, where a
      file and line number are less meaningful. The format can vary by
      language. For example: qual.if.ied.Class.method (Java), dir/package.func
      (Go), function (Python).
    line: Optional. Line within the source file. 1-based; 0 indicates no line
      number available.
  """

  file = _messages.StringField(1)
  function = _messages.StringField(2)
  line = _messages.IntegerField(3)


class LogExclusion(_messages.Message):
  r"""Specifies a set of log entries that are not to be stored in Logging. If
  your GCP resource receives a large volume of logs, you can use exclusions to
  reduce your chargeable logs. Exclusions are processed after log sinks, so
  you can export log entries before they are excluded. Note that organization-
  level and folder-level exclusions don't apply to child resources, and that
  you can't exclude audit log entries.

  Fields:
    createTime: Output only. The creation timestamp of the exclusion.This
      field may not be present for older exclusions.
    description: Optional. A description of this exclusion.
    disabled: Optional. If set to True, then this exclusion is disabled and it
      does not exclude any log entries. You can update an exclusion to change
      the value of this field.
    filter: Required. An advanced logs filter that matches the log entries to
      be excluded. By using the sample function, you can exclude less than
      100% of the matching log entries. For example, the following query
      matches 99% of low-severity log entries from Google Cloud Storage
      buckets:"resource.type=gcs_bucket severity<ERROR sample(insertId, 0.99)"
    name: Required. A client-assigned identifier, such as "load-balancer-
      exclusion". Identifiers are limited to 100 characters and can include
      only letters, digits, underscores, hyphens, and periods. First character
      has to be alphanumeric.
    updateTime: Output only. The last update timestamp of the exclusion.This
      field may not be present for older exclusions.
  """

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  disabled = _messages.BooleanField(3)
  filter = _messages.StringField(4)
  name = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class LogLine(_messages.Message):
  r"""Application log line emitted while processing a request.

  Enums:
    SeverityValueValuesEnum: Severity of this log entry.

  Fields:
    logMessage: App-provided log message.
    severity: Severity of this log entry.
    sourceLocation: Where in the source code this log message was written.
    time: Approximate time when this log entry was made.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Severity of this log entry.

    Values:
      DEFAULT: (0) The log entry has no assigned severity level.
      DEBUG: (100) Debug or trace information.
      INFO: (200) Routine information, such as ongoing status or performance.
      NOTICE: (300) Normal but significant events, such as start up, shut
        down, or a configuration change.
      WARNING: (400) Warning events might cause problems.
      ERROR: (500) Error events are likely to cause problems.
      CRITICAL: (600) Critical events cause more severe problems or outages.
      ALERT: (700) A person must take an action immediately.
      EMERGENCY: (800) One or more systems are unusable.
    """
    DEFAULT = 0
    DEBUG = 1
    INFO = 2
    NOTICE = 3
    WARNING = 4
    ERROR = 5
    CRITICAL = 6
    ALERT = 7
    EMERGENCY = 8

  logMessage = _messages.StringField(1)
  severity = _messages.EnumField('SeverityValueValuesEnum', 2)
  sourceLocation = _messages.MessageField('SourceLocation', 3)
  time = _messages.StringField(4)


class LogMetric(_messages.Message):
  r"""Describes a logs-based metric. The value of the metric is the number of
  log entries that match a logs filter in a given time interval.Logs-based
  metric can also be used to extract values from logs and create a a
  distribution of the values. The distribution records the statistics of the
  extracted values along with an optional histogram of the values as specified
  by the bucket options.

  Enums:
    VersionValueValuesEnum: Deprecated. The API version that created or
      updated this metric. The v2 format is used by default and cannot be
      changed.

  Messages:
    LabelExtractorsValue: Optional. A map from a label key string to an
      extractor expression which is used to extract data from a log entry
      field and assign as the label value. Each label key specified in the
      LabelDescriptor must have an associated extractor expression in this
      map. The syntax of the extractor expression is the same as for the
      value_extractor field.The extracted value is converted to the type
      defined in the label descriptor. If the either the extraction or the
      type conversion fails, the label will have a default value. The default
      value for a string label is an empty string, for an integer label its 0,
      and for a boolean label its false.Note that there are upper bounds on
      the maximum number of labels and the number of active time series that
      are allowed in a project.

  Fields:
    bucketOptions: Optional. The bucket_options are required when the logs-
      based metric is using a DISTRIBUTION value type and it describes the
      bucket boundaries used to create a histogram of the extracted values.
    createTime: Output only. The creation timestamp of the metric.This field
      may not be present for older metrics.
    description: Optional. A description of this metric, which is used in
      documentation. The maximum length of the description is 8000 characters.
    disabled: Optional. If set to True, then this metric is disabled and it
      does not generate any points.
    filter: Required. An advanced logs filter which is used to match log
      entries. Example: "resource.type=gae_app AND severity>=ERROR" The
      maximum length of the filter is 20000 characters.
    labelExtractors: Optional. A map from a label key string to an extractor
      expression which is used to extract data from a log entry field and
      assign as the label value. Each label key specified in the
      LabelDescriptor must have an associated extractor expression in this
      map. The syntax of the extractor expression is the same as for the
      value_extractor field.The extracted value is converted to the type
      defined in the label descriptor. If the either the extraction or the
      type conversion fails, the label will have a default value. The default
      value for a string label is an empty string, for an integer label its 0,
      and for a boolean label its false.Note that there are upper bounds on
      the maximum number of labels and the number of active time series that
      are allowed in a project.
    metricDescriptor: Optional. The metric descriptor associated with the
      logs-based metric. If unspecified, it uses a default metric descriptor
      with a DELTA metric kind, INT64 value type, with no labels and a unit of
      "1". Such a metric counts the number of log entries matching the filter
      expression.The name, type, and description fields in the
      metric_descriptor are output only, and is constructed using the name and
      description field in the LogMetric.To create a logs-based metric that
      records a distribution of log values, a DELTA metric kind with a
      DISTRIBUTION value type must be used along with a value_extractor
      expression in the LogMetric.Each label in the metric descriptor must
      have a matching label name as the key and an extractor expression as the
      value in the label_extractors map.The metric_kind and value_type fields
      in the metric_descriptor cannot be updated once initially configured.
      New labels can be added in the metric_descriptor, but existing labels
      cannot be modified except for their description.
    name: Required. The client-assigned metric identifier. Examples:
      "error_count", "nginx/requests".Metric identifiers are limited to 100
      characters and can include only the following characters: A-Z, a-z, 0-9,
      and the special characters _-.,+!*',()%/. The forward-slash character
      (/) denotes a hierarchy of name pieces, and it cannot be the first
      character of the name.The metric identifier in this field must not be
      URL-encoded (https://en.wikipedia.org/wiki/Percent-encoding). However,
      when the metric identifier appears as the [METRIC_ID] part of a
      metric_name API parameter, then the metric identifier must be URL-
      encoded. Example: "projects/my-project/metrics/nginx%2Frequests".
    updateTime: Output only. The last update timestamp of the metric.This
      field may not be present for older metrics.
    valueExtractor: Optional. A value_extractor is required when using a
      distribution logs-based metric to extract the values to record from a
      log entry. Two functions are supported for value extraction:
      EXTRACT(field) or REGEXP_EXTRACT(field, regex). The argument are:  1.
      field: The name of the log entry field from which the value is to be
      extracted.  2. regex: A regular expression using the Google RE2 syntax
      (https://github.com/google/re2/wiki/Syntax) with a single capture  group
      to extract data from the specified log entry field. The value  of the
      field is converted to a string before applying the regex.  It is an
      error to specify a regex that does not include exactly one  capture
      group.The result of the extraction must be convertible to a double type,
      as the distribution always records double values. If either the
      extraction or the conversion to double fails, then those values are not
      recorded in the distribution.Example:
      REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(\d+).*")
    version: Deprecated. The API version that created or updated this metric.
      The v2 format is used by default and cannot be changed.
  """

  class VersionValueValuesEnum(_messages.Enum):
    r"""Deprecated. The API version that created or updated this metric. The
    v2 format is used by default and cannot be changed.

    Values:
      V2: Logging API v2.
      V1: Logging API v1.
    """
    V2 = 0
    V1 = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelExtractorsValue(_messages.Message):
    r"""Optional. A map from a label key string to an extractor expression
    which is used to extract data from a log entry field and assign as the
    label value. Each label key specified in the LabelDescriptor must have an
    associated extractor expression in this map. The syntax of the extractor
    expression is the same as for the value_extractor field.The extracted
    value is converted to the type defined in the label descriptor. If the
    either the extraction or the type conversion fails, the label will have a
    default value. The default value for a string label is an empty string,
    for an integer label its 0, and for a boolean label its false.Note that
    there are upper bounds on the maximum number of labels and the number of
    active time series that are allowed in a project.

    Messages:
      AdditionalProperty: An additional property for a LabelExtractorsValue
        object.

    Fields:
      additionalProperties: Additional properties of type LabelExtractorsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelExtractorsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  bucketOptions = _messages.MessageField('BucketOptions', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  disabled = _messages.BooleanField(4)
  filter = _messages.StringField(5)
  labelExtractors = _messages.MessageField('LabelExtractorsValue', 6)
  metricDescriptor = _messages.MessageField('MetricDescriptor', 7)
  name = _messages.StringField(8)
  updateTime = _messages.StringField(9)
  valueExtractor = _messages.StringField(10)
  version = _messages.EnumField('VersionValueValuesEnum', 11)


class LogSink(_messages.Message):
  r"""Describes a sink used to export log entries to one of the following
  destinations in any project: a Cloud Storage bucket, a BigQuery dataset, or
  a Cloud Pub/Sub topic. A logs filter controls which log entries are
  exported. The sink must be created within a project, organization, billing
  account, or folder.

  Enums:
    OutputVersionFormatValueValuesEnum: Deprecated. The log entry format to
      use for this sink's exported log entries. The v2 format is used by
      default and cannot be changed.

  Fields:
    bigqueryOptions: Optional. Options that affect sinks exporting data to
      BigQuery.
    createTime: Output only. The creation timestamp of the sink.This field may
      not be present for older sinks.
    description: Optional. A description of this sink. The maximum length of
      the description is 8000 characters.
    destination: Required. The export destination:
      "storage.googleapis.com/[GCS_BUCKET]"
      "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]"
      "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]" The
      sink's writer_identity, set when the sink is created, must have
      permission to write to the destination or else the log entries are not
      exported. For more information, see Exporting Logs with Sinks.
    disabled: Optional. If set to True, then this sink is disabled and it does
      not export any log entries.
    dlpOptions: Optional. Settings for Data Loss Prevention (DLP) enabled
      sinks.
    endTime: Do not use. This field is ignored.
    exclusions: Optional. Log entries that match any of the exclusion filters
      will not be exported. If a log entry is matched by both filter and one
      of exclusion_filters it will not be exported.
    filter: Optional. An advanced logs filter. The only exported log entries
      are those that are in the resource owning the sink and that match the
      filter. For example: logName="projects/[PROJECT_ID]/logs/[LOG_ID]" AND
      severity>=ERROR
    includeChildren: Optional. This field applies only to sinks owned by
      organizations and folders. If the field is false, the default, only the
      logs owned by the sink's parent resource are available for export. If
      the field is true, then logs from all the projects, folders, and billing
      accounts contained in the sink's parent resource are also available for
      export. Whether a particular log entry from the children is exported
      depends on the sink's filter expression. For example, if this field is
      true, then the filter resource.type=gce_instance would export all
      Compute Engine VM instance log entries from all projects in the sink's
      parent. To only export entries from certain child projects, filter on
      the project part of the log name: logName:("projects/test-project1/" OR
      "projects/test-project2/") AND resource.type=gce_instance
    name: Required. The client-assigned sink identifier, unique within the
      project. Example: "my-syslog-errors-to-pubsub". Sink identifiers are
      limited to 100 characters and can include only the following characters:
      upper and lower-case alphanumeric characters, underscores, hyphens, and
      periods. First character has to be alphanumeric.
    outputVersionFormat: Deprecated. The log entry format to use for this
      sink's exported log entries. The v2 format is used by default and cannot
      be changed.
    startTime: Do not use. This field is ignored.
    updateTime: Output only. The last update timestamp of the sink.This field
      may not be present for older sinks.
    writerIdentity: Output only. An IAM identity&mdash;a service account or
      group&mdash;under which Logging writes the exported log entries to the
      sink's destination. This field is set by sinks.create and sinks.update
      based on the value of unique_writer_identity in those methods.Until you
      grant this identity write-access to the destination, log entry exports
      from this sink will fail. For more information, see Granting Access for
      a Resource. Consult the destination service's documentation to determine
      the appropriate IAM roles to assign to the identity.
  """

  class OutputVersionFormatValueValuesEnum(_messages.Enum):
    r"""Deprecated. The log entry format to use for this sink's exported log
    entries. The v2 format is used by default and cannot be changed.

    Values:
      VERSION_FORMAT_UNSPECIFIED: An unspecified format version that will
        default to V2.
      V2: LogEntry version 2 format.
      V1: LogEntry version 1 format.
    """
    VERSION_FORMAT_UNSPECIFIED = 0
    V2 = 1
    V1 = 2

  bigqueryOptions = _messages.MessageField('BigQueryOptions', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  destination = _messages.StringField(4)
  disabled = _messages.BooleanField(5)
  dlpOptions = _messages.MessageField('DlpOptions', 6)
  endTime = _messages.StringField(7)
  exclusions = _messages.MessageField('LogExclusion', 8, repeated=True)
  filter = _messages.StringField(9)
  includeChildren = _messages.BooleanField(10)
  name = _messages.StringField(11)
  outputVersionFormat = _messages.EnumField('OutputVersionFormatValueValuesEnum', 12)
  startTime = _messages.StringField(13)
  updateTime = _messages.StringField(14)
  writerIdentity = _messages.StringField(15)


class LogView(_messages.Message):
  r"""Describes a view over logs in a bucket

  Fields:
    createTime: Output only. The creation timestamp of the view.
    description: Describes this view.
    displayName: Display name of the view.
    expireTime: Time at which this view will no longer be useable. Requests to
      view logs after expire_time has passed will fail with a
      FAILED_PRECONDITION error.
    filter: Filter that restricts which log entries in a bucket are visible in
      this view. Filters are restricted to be a logical AND of ==/!= of any of
      the following:  originating project/folder/organization/billing account.
      resource type  log id  user labels
    name: The resource name of the view. For example "projects/my-project-
      id/locations/my-location/buckets/my-bucket-id/views/my-view
    updateTime: Output only. The last update timestamp of the view.
  """

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  expireTime = _messages.StringField(4)
  filter = _messages.StringField(5)
  name = _messages.StringField(6)
  updateTime = _messages.StringField(7)


class LoggingBillingAccountsBucketsGetRequest(_messages.Message):
  r"""A LoggingBillingAccountsBucketsGetRequest object.

  Fields:
    name: Required. The resource name of the bucket:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingBillingAccountsBucketsViewsGetRequest(_messages.Message):
  r"""A LoggingBillingAccountsBucketsViewsGetRequest object.

  Fields:
    name: Required. The resource name of the policy: "projects/[PROJECT_ID]/lo
      cations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]" Example:
      "projects/my-project-id/locations/my-location/buckets/my-bucket-id/views
      /my-view-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingBillingAccountsExclusionsCreateRequest(_messages.Message):
  r"""A LoggingBillingAccountsExclusionsCreateRequest object.

  Fields:
    logExclusion: A LogExclusion resource to be passed as the request body.
    parent: Required. The parent resource in which to create the exclusion:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]" Examples:
      "projects/my-logging-project", "organizations/123456789".
  """

  logExclusion = _messages.MessageField('LogExclusion', 1)
  parent = _messages.StringField(2, required=True)


class LoggingBillingAccountsExclusionsDeleteRequest(_messages.Message):
  r"""A LoggingBillingAccountsExclusionsDeleteRequest object.

  Fields:
    name: Required. The resource name of an existing exclusion to delete:
      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" Example: "projects/my-
      project-id/exclusions/my-exclusion-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingBillingAccountsExclusionsGetRequest(_messages.Message):
  r"""A LoggingBillingAccountsExclusionsGetRequest object.

  Fields:
    name: Required. The resource name of an existing exclusion:
      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" Example: "projects/my-
      project-id/exclusions/my-exclusion-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingBillingAccountsExclusionsListRequest(_messages.Message):
  r"""A LoggingBillingAccountsExclusionsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The parent resource whose exclusions are to be listed.
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingBillingAccountsExclusionsPatchRequest(_messages.Message):
  r"""A LoggingBillingAccountsExclusionsPatchRequest object.

  Fields:
    logExclusion: A LogExclusion resource to be passed as the request body.
    name: Required. The resource name of the exclusion to update:
      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" Example: "projects/my-
      project-id/exclusions/my-exclusion-id".
    updateMask: Required. A non-empty list of fields to change in the existing
      exclusion. New values for the fields are taken from the corresponding
      fields in the LogExclusion included in this request. Fields not
      mentioned in update_mask are not changed and are ignored in the
      request.For example, to change the filter and description of an
      exclusion, specify an update_mask of "filter,description".
  """

  logExclusion = _messages.MessageField('LogExclusion', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class LoggingBillingAccountsLocationsBucketsCreateRequest(_messages.Message):
  r"""A LoggingBillingAccountsLocationsBucketsCreateRequest object.

  Fields:
    bucketId: Required. A client-assigned identifier such as "my-bucket".
      Identifiers are limited to 100 characters and can include only letters,
      digits, underscores, hyphens, and periods.
    logBucket: A LogBucket resource to be passed as the request body.
    parent: Required. The resource in which to create the bucket:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
      "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]" Example: "projects/my-
      logging-project/locations/global"
  """

  bucketId = _messages.StringField(1)
  logBucket = _messages.MessageField('LogBucket', 2)
  parent = _messages.StringField(3, required=True)


class LoggingBillingAccountsLocationsBucketsDeleteRequest(_messages.Message):
  r"""A LoggingBillingAccountsLocationsBucketsDeleteRequest object.

  Fields:
    name: Required. The full resource name of the bucket to delete.
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingBillingAccountsLocationsBucketsListRequest(_messages.Message):
  r"""A LoggingBillingAccountsLocationsBucketsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The parent resource whose buckets are to be listed:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
      "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]" Note: The locations
      portion of the resource is required, but supplying the character - in
      place of LOCATION_ID will return all buckets.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingBillingAccountsLocationsBucketsPatchRequest(_messages.Message):
  r"""A LoggingBillingAccountsLocationsBucketsPatchRequest object.

  Fields:
    logBucket: A LogBucket resource to be passed as the request body.
    name: Required. The full resource name of the bucket to update.
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id". Also requires permission
      "resourcemanager.projects.updateLiens" to set the locked property
    updateMask: Required. Field mask that specifies the fields in bucket that
      need an update. A bucket field will be overwritten if, and only if, it
      is in the update mask. name and output only fields cannot be updated.For
      a detailed FieldMask definition, see https://developers.google.com
      /protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=retention_days.
  """

  logBucket = _messages.MessageField('LogBucket', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class LoggingBillingAccountsLocationsBucketsUndeleteRequest(_messages.Message):
  r"""A LoggingBillingAccountsLocationsBucketsUndeleteRequest object.

  Fields:
    name: Required. The full resource name of the bucket to undelete.
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id".
    undeleteBucketRequest: A UndeleteBucketRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  undeleteBucketRequest = _messages.MessageField('UndeleteBucketRequest', 2)


class LoggingBillingAccountsLocationsBucketsViewsCreateRequest(_messages.Message):
  r"""A LoggingBillingAccountsLocationsBucketsViewsCreateRequest object.

  Fields:
    logView: A LogView resource to be passed as the request body.
    parent: Required. The bucket in which to create the view
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-logging-project/locations/my-location/buckets/my-
      bucket"
    viewId: Required. The id to use for this view.
  """

  logView = _messages.MessageField('LogView', 1)
  parent = _messages.StringField(2, required=True)
  viewId = _messages.StringField(3)


class LoggingBillingAccountsLocationsBucketsViewsDeleteRequest(_messages.Message):
  r"""A LoggingBillingAccountsLocationsBucketsViewsDeleteRequest object.

  Fields:
    name: Required. The full resource name of the view to delete: "projects/[P
      ROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
      Example:  "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id/views/my-view-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingBillingAccountsLocationsBucketsViewsListRequest(_messages.Message):
  r"""A LoggingBillingAccountsLocationsBucketsViewsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The bucket whose views are to be listed:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingBillingAccountsLocationsBucketsViewsPatchRequest(_messages.Message):
  r"""A LoggingBillingAccountsLocationsBucketsViewsPatchRequest object.

  Fields:
    logView: A LogView resource to be passed as the request body.
    name: Required. The full resource name of the view to update "projects/[PR
      OJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
      Example:  "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id/views/my-view-id".
    updateMask: Optional. Field mask that specifies the fields in view that
      need an update. A field will be overwritten if, and only if, it is in
      the update mask. name and output only fields cannot be updated.For a
      detailed FieldMask definition, see https://developers.google.com
      /protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=filter.
  """

  logView = _messages.MessageField('LogView', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class LoggingBillingAccountsLogsDeleteRequest(_messages.Message):
  r"""A LoggingBillingAccountsLogsDeleteRequest object.

  Fields:
    logName: Required. The resource name of the log to delete:
      "projects/[PROJECT_ID]/logs/[LOG_ID]"
      "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
      "folders/[FOLDER_ID]/logs/[LOG_ID]" [LOG_ID] must be URL-encoded. For
      example, "projects/my-project-id/logs/syslog", "organizations/1234567890
      /logs/cloudresourcemanager.googleapis.com%2Factivity". For more
      information about log names, see LogEntry.
  """

  logName = _messages.StringField(1, required=True)


class LoggingBillingAccountsLogsListRequest(_messages.Message):
  r"""A LoggingBillingAccountsLogsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The resource name that owns the logs:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]"
    resourceNames: Required for Logging Data Model V2. The resource name that
      owns the logs:  projects/PROJECT_ID/locations/LOCATION_ID/buckets/BUCKET
      _ID/views/VIEW_ID  organization/ORGANIZATION_ID/locations/LOCATION_ID/bu
      ckets/BUCKET_ID/views/VIEW_ID  billingAccounts/BILLING_ACCOUNT_ID/locati
      ons/LOCATION_ID/buckets/BUCKET_ID/views/VIEW_ID  folders/FOLDER_ID/locat
      ions/LOCATION_ID/buckets/BUCKET_ID/views/VIEW_IDTo support legacy
      queries, it could also be:  "projects/PROJECT_ID"
      "organizations/ORGANIZATION_ID"  "billingAccounts/BILLING_ACCOUNT_ID"
      "folders/FOLDER_ID"Note: It is not supported for query across multiple
      projects/orgs/folders/billingAccounts
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  resourceNames = _messages.StringField(4, repeated=True)


class LoggingBillingAccountsSinksCreateRequest(_messages.Message):
  r"""A LoggingBillingAccountsSinksCreateRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    parent: Required. The resource in which to create the sink:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]" Examples:
      "projects/my-logging-project", "organizations/123456789".
    uniqueWriterIdentity: Optional. Determines the kind of IAM identity
      returned as writer_identity in the new sink. If this value is omitted or
      set to false, and if the sink's parent is a project, then the value
      returned as writer_identity is the same group or service account used by
      Logging before the addition of writer identities to this API. The sink's
      destination must be in the same project as the sink itself.If this field
      is set to true, or if the sink is owned by a non-project resource such
      as an organization, then the value of writer_identity will be a unique
      service account used only for exports from the new sink. For more
      information, see writer_identity in LogSink.
  """

  logSink = _messages.MessageField('LogSink', 1)
  parent = _messages.StringField(2, required=True)
  uniqueWriterIdentity = _messages.BooleanField(3)


class LoggingBillingAccountsSinksDeleteRequest(_messages.Message):
  r"""A LoggingBillingAccountsSinksDeleteRequest object.

  Fields:
    sinkName: Required. The full resource name of the sink to delete,
      including the parent resource and the sink identifier:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
  """

  sinkName = _messages.StringField(1, required=True)


class LoggingBillingAccountsSinksGetRequest(_messages.Message):
  r"""A LoggingBillingAccountsSinksGetRequest object.

  Fields:
    sinkName: Required. The resource name of the sink:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
  """

  sinkName = _messages.StringField(1, required=True)


class LoggingBillingAccountsSinksListRequest(_messages.Message):
  r"""A LoggingBillingAccountsSinksListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The parent resource whose sinks are to be listed:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingBillingAccountsSinksPatchRequest(_messages.Message):
  r"""A LoggingBillingAccountsSinksPatchRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    sinkName: Required. The full resource name of the sink to update,
      including the parent resource and the sink identifier:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
    uniqueWriterIdentity: Optional. See sinks.create for a description of this
      field. When updating a sink, the effect of this field on the value of
      writer_identity in the updated sink depends on both the old and new
      values of this field: If the old and new values of this field are both
      false or both true, then there is no change to the sink's
      writer_identity. If the old value is false and the new value is true,
      then writer_identity is changed to a unique service account. It is an
      error if the old value is true and the new value is set to false or
      defaulted to false.
    updateMask: Optional. Field mask that specifies the fields in sink that
      need an update. A sink field will be overwritten if, and only if, it is
      in the update mask. name and output only fields cannot be updated.An
      empty updateMask is temporarily treated as using the following mask for
      backwards compatibility purposes:  destination,filter,includeChildren At
      some point in the future, behavior will be removed and specifying an
      empty updateMask will be an error.For a detailed FieldMask definition,
      see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=filter.
  """

  logSink = _messages.MessageField('LogSink', 1)
  sinkName = _messages.StringField(2, required=True)
  uniqueWriterIdentity = _messages.BooleanField(3)
  updateMask = _messages.StringField(4)


class LoggingBillingAccountsSinksUpdateRequest(_messages.Message):
  r"""A LoggingBillingAccountsSinksUpdateRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    sinkName: Required. The full resource name of the sink to update,
      including the parent resource and the sink identifier:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
    uniqueWriterIdentity: Optional. See sinks.create for a description of this
      field. When updating a sink, the effect of this field on the value of
      writer_identity in the updated sink depends on both the old and new
      values of this field: If the old and new values of this field are both
      false or both true, then there is no change to the sink's
      writer_identity. If the old value is false and the new value is true,
      then writer_identity is changed to a unique service account. It is an
      error if the old value is true and the new value is set to false or
      defaulted to false.
    updateMask: Optional. Field mask that specifies the fields in sink that
      need an update. A sink field will be overwritten if, and only if, it is
      in the update mask. name and output only fields cannot be updated.An
      empty updateMask is temporarily treated as using the following mask for
      backwards compatibility purposes:  destination,filter,includeChildren At
      some point in the future, behavior will be removed and specifying an
      empty updateMask will be an error.For a detailed FieldMask definition,
      see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=filter.
  """

  logSink = _messages.MessageField('LogSink', 1)
  sinkName = _messages.StringField(2, required=True)
  uniqueWriterIdentity = _messages.BooleanField(3)
  updateMask = _messages.StringField(4)


class LoggingExclusionsCreateRequest(_messages.Message):
  r"""A LoggingExclusionsCreateRequest object.

  Fields:
    logExclusion: A LogExclusion resource to be passed as the request body.
    parent: Required. The parent resource in which to create the exclusion:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]" Examples:
      "projects/my-logging-project", "organizations/123456789".
  """

  logExclusion = _messages.MessageField('LogExclusion', 1)
  parent = _messages.StringField(2, required=True)


class LoggingExclusionsDeleteRequest(_messages.Message):
  r"""A LoggingExclusionsDeleteRequest object.

  Fields:
    name: Required. The resource name of an existing exclusion to delete:
      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" Example: "projects/my-
      project-id/exclusions/my-exclusion-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingExclusionsGetRequest(_messages.Message):
  r"""A LoggingExclusionsGetRequest object.

  Fields:
    name: Required. The resource name of an existing exclusion:
      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" Example: "projects/my-
      project-id/exclusions/my-exclusion-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingExclusionsListRequest(_messages.Message):
  r"""A LoggingExclusionsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The parent resource whose exclusions are to be listed.
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingExclusionsPatchRequest(_messages.Message):
  r"""A LoggingExclusionsPatchRequest object.

  Fields:
    logExclusion: A LogExclusion resource to be passed as the request body.
    name: Required. The resource name of the exclusion to update:
      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" Example: "projects/my-
      project-id/exclusions/my-exclusion-id".
    updateMask: Required. A non-empty list of fields to change in the existing
      exclusion. New values for the fields are taken from the corresponding
      fields in the LogExclusion included in this request. Fields not
      mentioned in update_mask are not changed and are ignored in the
      request.For example, to change the filter and description of an
      exclusion, specify an update_mask of "filter,description".
  """

  logExclusion = _messages.MessageField('LogExclusion', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class LoggingFoldersExclusionsCreateRequest(_messages.Message):
  r"""A LoggingFoldersExclusionsCreateRequest object.

  Fields:
    logExclusion: A LogExclusion resource to be passed as the request body.
    parent: Required. The parent resource in which to create the exclusion:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]" Examples:
      "projects/my-logging-project", "organizations/123456789".
  """

  logExclusion = _messages.MessageField('LogExclusion', 1)
  parent = _messages.StringField(2, required=True)


class LoggingFoldersExclusionsDeleteRequest(_messages.Message):
  r"""A LoggingFoldersExclusionsDeleteRequest object.

  Fields:
    name: Required. The resource name of an existing exclusion to delete:
      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" Example: "projects/my-
      project-id/exclusions/my-exclusion-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingFoldersExclusionsGetRequest(_messages.Message):
  r"""A LoggingFoldersExclusionsGetRequest object.

  Fields:
    name: Required. The resource name of an existing exclusion:
      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" Example: "projects/my-
      project-id/exclusions/my-exclusion-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingFoldersExclusionsListRequest(_messages.Message):
  r"""A LoggingFoldersExclusionsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The parent resource whose exclusions are to be listed.
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingFoldersExclusionsPatchRequest(_messages.Message):
  r"""A LoggingFoldersExclusionsPatchRequest object.

  Fields:
    logExclusion: A LogExclusion resource to be passed as the request body.
    name: Required. The resource name of the exclusion to update:
      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" Example: "projects/my-
      project-id/exclusions/my-exclusion-id".
    updateMask: Required. A non-empty list of fields to change in the existing
      exclusion. New values for the fields are taken from the corresponding
      fields in the LogExclusion included in this request. Fields not
      mentioned in update_mask are not changed and are ignored in the
      request.For example, to change the filter and description of an
      exclusion, specify an update_mask of "filter,description".
  """

  logExclusion = _messages.MessageField('LogExclusion', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class LoggingFoldersLocationsBucketsCreateRequest(_messages.Message):
  r"""A LoggingFoldersLocationsBucketsCreateRequest object.

  Fields:
    bucketId: Required. A client-assigned identifier such as "my-bucket".
      Identifiers are limited to 100 characters and can include only letters,
      digits, underscores, hyphens, and periods.
    logBucket: A LogBucket resource to be passed as the request body.
    parent: Required. The resource in which to create the bucket:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
      "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]" Example: "projects/my-
      logging-project/locations/global"
  """

  bucketId = _messages.StringField(1)
  logBucket = _messages.MessageField('LogBucket', 2)
  parent = _messages.StringField(3, required=True)


class LoggingFoldersLocationsBucketsDeleteRequest(_messages.Message):
  r"""A LoggingFoldersLocationsBucketsDeleteRequest object.

  Fields:
    name: Required. The full resource name of the bucket to delete.
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingFoldersLocationsBucketsGetRequest(_messages.Message):
  r"""A LoggingFoldersLocationsBucketsGetRequest object.

  Fields:
    name: Required. The resource name of the bucket:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingFoldersLocationsBucketsListRequest(_messages.Message):
  r"""A LoggingFoldersLocationsBucketsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The parent resource whose buckets are to be listed:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
      "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]" Note: The locations
      portion of the resource is required, but supplying the character - in
      place of LOCATION_ID will return all buckets.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingFoldersLocationsBucketsPatchRequest(_messages.Message):
  r"""A LoggingFoldersLocationsBucketsPatchRequest object.

  Fields:
    logBucket: A LogBucket resource to be passed as the request body.
    name: Required. The full resource name of the bucket to update.
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id". Also requires permission
      "resourcemanager.projects.updateLiens" to set the locked property
    updateMask: Required. Field mask that specifies the fields in bucket that
      need an update. A bucket field will be overwritten if, and only if, it
      is in the update mask. name and output only fields cannot be updated.For
      a detailed FieldMask definition, see https://developers.google.com
      /protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=retention_days.
  """

  logBucket = _messages.MessageField('LogBucket', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class LoggingFoldersLocationsBucketsUndeleteRequest(_messages.Message):
  r"""A LoggingFoldersLocationsBucketsUndeleteRequest object.

  Fields:
    name: Required. The full resource name of the bucket to undelete.
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id".
    undeleteBucketRequest: A UndeleteBucketRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  undeleteBucketRequest = _messages.MessageField('UndeleteBucketRequest', 2)


class LoggingFoldersLocationsBucketsViewsCreateRequest(_messages.Message):
  r"""A LoggingFoldersLocationsBucketsViewsCreateRequest object.

  Fields:
    logView: A LogView resource to be passed as the request body.
    parent: Required. The bucket in which to create the view
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-logging-project/locations/my-location/buckets/my-
      bucket"
    viewId: Required. The id to use for this view.
  """

  logView = _messages.MessageField('LogView', 1)
  parent = _messages.StringField(2, required=True)
  viewId = _messages.StringField(3)


class LoggingFoldersLocationsBucketsViewsDeleteRequest(_messages.Message):
  r"""A LoggingFoldersLocationsBucketsViewsDeleteRequest object.

  Fields:
    name: Required. The full resource name of the view to delete: "projects/[P
      ROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
      Example:  "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id/views/my-view-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingFoldersLocationsBucketsViewsGetRequest(_messages.Message):
  r"""A LoggingFoldersLocationsBucketsViewsGetRequest object.

  Fields:
    name: Required. The resource name of the policy: "projects/[PROJECT_ID]/lo
      cations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]" Example:
      "projects/my-project-id/locations/my-location/buckets/my-bucket-id/views
      /my-view-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingFoldersLocationsBucketsViewsListRequest(_messages.Message):
  r"""A LoggingFoldersLocationsBucketsViewsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The bucket whose views are to be listed:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingFoldersLocationsBucketsViewsPatchRequest(_messages.Message):
  r"""A LoggingFoldersLocationsBucketsViewsPatchRequest object.

  Fields:
    logView: A LogView resource to be passed as the request body.
    name: Required. The full resource name of the view to update "projects/[PR
      OJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
      Example:  "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id/views/my-view-id".
    updateMask: Optional. Field mask that specifies the fields in view that
      need an update. A field will be overwritten if, and only if, it is in
      the update mask. name and output only fields cannot be updated.For a
      detailed FieldMask definition, see https://developers.google.com
      /protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=filter.
  """

  logView = _messages.MessageField('LogView', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class LoggingFoldersLogsDeleteRequest(_messages.Message):
  r"""A LoggingFoldersLogsDeleteRequest object.

  Fields:
    logName: Required. The resource name of the log to delete:
      "projects/[PROJECT_ID]/logs/[LOG_ID]"
      "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
      "folders/[FOLDER_ID]/logs/[LOG_ID]" [LOG_ID] must be URL-encoded. For
      example, "projects/my-project-id/logs/syslog", "organizations/1234567890
      /logs/cloudresourcemanager.googleapis.com%2Factivity". For more
      information about log names, see LogEntry.
  """

  logName = _messages.StringField(1, required=True)


class LoggingFoldersLogsListRequest(_messages.Message):
  r"""A LoggingFoldersLogsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The resource name that owns the logs:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]"
    resourceNames: Required for Logging Data Model V2. The resource name that
      owns the logs:  projects/PROJECT_ID/locations/LOCATION_ID/buckets/BUCKET
      _ID/views/VIEW_ID  organization/ORGANIZATION_ID/locations/LOCATION_ID/bu
      ckets/BUCKET_ID/views/VIEW_ID  billingAccounts/BILLING_ACCOUNT_ID/locati
      ons/LOCATION_ID/buckets/BUCKET_ID/views/VIEW_ID  folders/FOLDER_ID/locat
      ions/LOCATION_ID/buckets/BUCKET_ID/views/VIEW_IDTo support legacy
      queries, it could also be:  "projects/PROJECT_ID"
      "organizations/ORGANIZATION_ID"  "billingAccounts/BILLING_ACCOUNT_ID"
      "folders/FOLDER_ID"Note: It is not supported for query across multiple
      projects/orgs/folders/billingAccounts
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  resourceNames = _messages.StringField(4, repeated=True)


class LoggingFoldersSinksCreateRequest(_messages.Message):
  r"""A LoggingFoldersSinksCreateRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    parent: Required. The resource in which to create the sink:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]" Examples:
      "projects/my-logging-project", "organizations/123456789".
    uniqueWriterIdentity: Optional. Determines the kind of IAM identity
      returned as writer_identity in the new sink. If this value is omitted or
      set to false, and if the sink's parent is a project, then the value
      returned as writer_identity is the same group or service account used by
      Logging before the addition of writer identities to this API. The sink's
      destination must be in the same project as the sink itself.If this field
      is set to true, or if the sink is owned by a non-project resource such
      as an organization, then the value of writer_identity will be a unique
      service account used only for exports from the new sink. For more
      information, see writer_identity in LogSink.
  """

  logSink = _messages.MessageField('LogSink', 1)
  parent = _messages.StringField(2, required=True)
  uniqueWriterIdentity = _messages.BooleanField(3)


class LoggingFoldersSinksDeleteRequest(_messages.Message):
  r"""A LoggingFoldersSinksDeleteRequest object.

  Fields:
    sinkName: Required. The full resource name of the sink to delete,
      including the parent resource and the sink identifier:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
  """

  sinkName = _messages.StringField(1, required=True)


class LoggingFoldersSinksGetRequest(_messages.Message):
  r"""A LoggingFoldersSinksGetRequest object.

  Fields:
    sinkName: Required. The resource name of the sink:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
  """

  sinkName = _messages.StringField(1, required=True)


class LoggingFoldersSinksListRequest(_messages.Message):
  r"""A LoggingFoldersSinksListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The parent resource whose sinks are to be listed:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingFoldersSinksPatchRequest(_messages.Message):
  r"""A LoggingFoldersSinksPatchRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    sinkName: Required. The full resource name of the sink to update,
      including the parent resource and the sink identifier:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
    uniqueWriterIdentity: Optional. See sinks.create for a description of this
      field. When updating a sink, the effect of this field on the value of
      writer_identity in the updated sink depends on both the old and new
      values of this field: If the old and new values of this field are both
      false or both true, then there is no change to the sink's
      writer_identity. If the old value is false and the new value is true,
      then writer_identity is changed to a unique service account. It is an
      error if the old value is true and the new value is set to false or
      defaulted to false.
    updateMask: Optional. Field mask that specifies the fields in sink that
      need an update. A sink field will be overwritten if, and only if, it is
      in the update mask. name and output only fields cannot be updated.An
      empty updateMask is temporarily treated as using the following mask for
      backwards compatibility purposes:  destination,filter,includeChildren At
      some point in the future, behavior will be removed and specifying an
      empty updateMask will be an error.For a detailed FieldMask definition,
      see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=filter.
  """

  logSink = _messages.MessageField('LogSink', 1)
  sinkName = _messages.StringField(2, required=True)
  uniqueWriterIdentity = _messages.BooleanField(3)
  updateMask = _messages.StringField(4)


class LoggingFoldersSinksUpdateRequest(_messages.Message):
  r"""A LoggingFoldersSinksUpdateRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    sinkName: Required. The full resource name of the sink to update,
      including the parent resource and the sink identifier:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
    uniqueWriterIdentity: Optional. See sinks.create for a description of this
      field. When updating a sink, the effect of this field on the value of
      writer_identity in the updated sink depends on both the old and new
      values of this field: If the old and new values of this field are both
      false or both true, then there is no change to the sink's
      writer_identity. If the old value is false and the new value is true,
      then writer_identity is changed to a unique service account. It is an
      error if the old value is true and the new value is set to false or
      defaulted to false.
    updateMask: Optional. Field mask that specifies the fields in sink that
      need an update. A sink field will be overwritten if, and only if, it is
      in the update mask. name and output only fields cannot be updated.An
      empty updateMask is temporarily treated as using the following mask for
      backwards compatibility purposes:  destination,filter,includeChildren At
      some point in the future, behavior will be removed and specifying an
      empty updateMask will be an error.For a detailed FieldMask definition,
      see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=filter.
  """

  logSink = _messages.MessageField('LogSink', 1)
  sinkName = _messages.StringField(2, required=True)
  uniqueWriterIdentity = _messages.BooleanField(3)
  updateMask = _messages.StringField(4)


class LoggingGetCmekSettingsRequest(_messages.Message):
  r"""A LoggingGetCmekSettingsRequest object.

  Fields:
    name: Required. The resource for which to retrieve CMEK settings.
      "projects/[PROJECT_ID]/cmekSettings"
      "organizations/[ORGANIZATION_ID]/cmekSettings"
      "billingAccounts/[BILLING_ACCOUNT_ID]/cmekSettings"
      "folders/[FOLDER_ID]/cmekSettings" Example:
      "organizations/12345/cmekSettings".Note: CMEK for the Logs Router can
      currently only be configured for GCP organizations. Once configured, it
      applies to all projects and folders in the GCP organization.
  """

  name = _messages.StringField(1, required=True)


class LoggingLocationsBucketsCreateRequest(_messages.Message):
  r"""A LoggingLocationsBucketsCreateRequest object.

  Fields:
    bucketId: Required. A client-assigned identifier such as "my-bucket".
      Identifiers are limited to 100 characters and can include only letters,
      digits, underscores, hyphens, and periods.
    logBucket: A LogBucket resource to be passed as the request body.
    parent: Required. The resource in which to create the bucket:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
      "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]" Example: "projects/my-
      logging-project/locations/global"
  """

  bucketId = _messages.StringField(1)
  logBucket = _messages.MessageField('LogBucket', 2)
  parent = _messages.StringField(3, required=True)


class LoggingLocationsBucketsDeleteRequest(_messages.Message):
  r"""A LoggingLocationsBucketsDeleteRequest object.

  Fields:
    name: Required. The full resource name of the bucket to delete.
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingLocationsBucketsGetRequest(_messages.Message):
  r"""A LoggingLocationsBucketsGetRequest object.

  Fields:
    name: Required. The resource name of the bucket:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingLocationsBucketsListRequest(_messages.Message):
  r"""A LoggingLocationsBucketsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The parent resource whose buckets are to be listed:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
      "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]" Note: The locations
      portion of the resource is required, but supplying the character - in
      place of LOCATION_ID will return all buckets.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingLocationsBucketsPatchRequest(_messages.Message):
  r"""A LoggingLocationsBucketsPatchRequest object.

  Fields:
    logBucket: A LogBucket resource to be passed as the request body.
    name: Required. The full resource name of the bucket to update.
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id". Also requires permission
      "resourcemanager.projects.updateLiens" to set the locked property
    updateMask: Required. Field mask that specifies the fields in bucket that
      need an update. A bucket field will be overwritten if, and only if, it
      is in the update mask. name and output only fields cannot be updated.For
      a detailed FieldMask definition, see https://developers.google.com
      /protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=retention_days.
  """

  logBucket = _messages.MessageField('LogBucket', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class LoggingLocationsBucketsUndeleteRequest(_messages.Message):
  r"""A LoggingLocationsBucketsUndeleteRequest object.

  Fields:
    name: Required. The full resource name of the bucket to undelete.
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id".
    undeleteBucketRequest: A UndeleteBucketRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  undeleteBucketRequest = _messages.MessageField('UndeleteBucketRequest', 2)


class LoggingLocationsBucketsViewsCreateRequest(_messages.Message):
  r"""A LoggingLocationsBucketsViewsCreateRequest object.

  Fields:
    logView: A LogView resource to be passed as the request body.
    parent: Required. The bucket in which to create the view
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-logging-project/locations/my-location/buckets/my-
      bucket"
    viewId: Required. The id to use for this view.
  """

  logView = _messages.MessageField('LogView', 1)
  parent = _messages.StringField(2, required=True)
  viewId = _messages.StringField(3)


class LoggingLocationsBucketsViewsDeleteRequest(_messages.Message):
  r"""A LoggingLocationsBucketsViewsDeleteRequest object.

  Fields:
    name: Required. The full resource name of the view to delete: "projects/[P
      ROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
      Example:  "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id/views/my-view-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingLocationsBucketsViewsGetRequest(_messages.Message):
  r"""A LoggingLocationsBucketsViewsGetRequest object.

  Fields:
    name: Required. The resource name of the policy: "projects/[PROJECT_ID]/lo
      cations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]" Example:
      "projects/my-project-id/locations/my-location/buckets/my-bucket-id/views
      /my-view-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingLocationsBucketsViewsListRequest(_messages.Message):
  r"""A LoggingLocationsBucketsViewsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The bucket whose views are to be listed:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingLocationsBucketsViewsPatchRequest(_messages.Message):
  r"""A LoggingLocationsBucketsViewsPatchRequest object.

  Fields:
    logView: A LogView resource to be passed as the request body.
    name: Required. The full resource name of the view to update "projects/[PR
      OJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
      Example:  "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id/views/my-view-id".
    updateMask: Optional. Field mask that specifies the fields in view that
      need an update. A field will be overwritten if, and only if, it is in
      the update mask. name and output only fields cannot be updated.For a
      detailed FieldMask definition, see https://developers.google.com
      /protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=filter.
  """

  logView = _messages.MessageField('LogView', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class LoggingLogsDeleteRequest(_messages.Message):
  r"""A LoggingLogsDeleteRequest object.

  Fields:
    logName: Required. The resource name of the log to delete:
      "projects/[PROJECT_ID]/logs/[LOG_ID]"
      "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
      "folders/[FOLDER_ID]/logs/[LOG_ID]" [LOG_ID] must be URL-encoded. For
      example, "projects/my-project-id/logs/syslog", "organizations/1234567890
      /logs/cloudresourcemanager.googleapis.com%2Factivity". For more
      information about log names, see LogEntry.
  """

  logName = _messages.StringField(1, required=True)


class LoggingLogsListRequest(_messages.Message):
  r"""A LoggingLogsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The resource name that owns the logs:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]"
    resourceNames: Required for Logging Data Model V2. The resource name that
      owns the logs:  projects/PROJECT_ID/locations/LOCATION_ID/buckets/BUCKET
      _ID/views/VIEW_ID  organization/ORGANIZATION_ID/locations/LOCATION_ID/bu
      ckets/BUCKET_ID/views/VIEW_ID  billingAccounts/BILLING_ACCOUNT_ID/locati
      ons/LOCATION_ID/buckets/BUCKET_ID/views/VIEW_ID  folders/FOLDER_ID/locat
      ions/LOCATION_ID/buckets/BUCKET_ID/views/VIEW_IDTo support legacy
      queries, it could also be:  "projects/PROJECT_ID"
      "organizations/ORGANIZATION_ID"  "billingAccounts/BILLING_ACCOUNT_ID"
      "folders/FOLDER_ID"Note: It is not supported for query across multiple
      projects/orgs/folders/billingAccounts
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  resourceNames = _messages.StringField(4, repeated=True)


class LoggingMonitoredResourceDescriptorsListRequest(_messages.Message):
  r"""A LoggingMonitoredResourceDescriptorsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)


class LoggingOrganizationsExclusionsCreateRequest(_messages.Message):
  r"""A LoggingOrganizationsExclusionsCreateRequest object.

  Fields:
    logExclusion: A LogExclusion resource to be passed as the request body.
    parent: Required. The parent resource in which to create the exclusion:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]" Examples:
      "projects/my-logging-project", "organizations/123456789".
  """

  logExclusion = _messages.MessageField('LogExclusion', 1)
  parent = _messages.StringField(2, required=True)


class LoggingOrganizationsExclusionsDeleteRequest(_messages.Message):
  r"""A LoggingOrganizationsExclusionsDeleteRequest object.

  Fields:
    name: Required. The resource name of an existing exclusion to delete:
      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" Example: "projects/my-
      project-id/exclusions/my-exclusion-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingOrganizationsExclusionsGetRequest(_messages.Message):
  r"""A LoggingOrganizationsExclusionsGetRequest object.

  Fields:
    name: Required. The resource name of an existing exclusion:
      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" Example: "projects/my-
      project-id/exclusions/my-exclusion-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingOrganizationsExclusionsListRequest(_messages.Message):
  r"""A LoggingOrganizationsExclusionsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The parent resource whose exclusions are to be listed.
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingOrganizationsExclusionsPatchRequest(_messages.Message):
  r"""A LoggingOrganizationsExclusionsPatchRequest object.

  Fields:
    logExclusion: A LogExclusion resource to be passed as the request body.
    name: Required. The resource name of the exclusion to update:
      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" Example: "projects/my-
      project-id/exclusions/my-exclusion-id".
    updateMask: Required. A non-empty list of fields to change in the existing
      exclusion. New values for the fields are taken from the corresponding
      fields in the LogExclusion included in this request. Fields not
      mentioned in update_mask are not changed and are ignored in the
      request.For example, to change the filter and description of an
      exclusion, specify an update_mask of "filter,description".
  """

  logExclusion = _messages.MessageField('LogExclusion', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class LoggingOrganizationsGetCmekSettingsRequest(_messages.Message):
  r"""A LoggingOrganizationsGetCmekSettingsRequest object.

  Fields:
    name: Required. The resource for which to retrieve CMEK settings.
      "projects/[PROJECT_ID]/cmekSettings"
      "organizations/[ORGANIZATION_ID]/cmekSettings"
      "billingAccounts/[BILLING_ACCOUNT_ID]/cmekSettings"
      "folders/[FOLDER_ID]/cmekSettings" Example:
      "organizations/12345/cmekSettings".Note: CMEK for the Logs Router can
      currently only be configured for GCP organizations. Once configured, it
      applies to all projects and folders in the GCP organization.
  """

  name = _messages.StringField(1, required=True)


class LoggingOrganizationsLocationsBucketsCreateRequest(_messages.Message):
  r"""A LoggingOrganizationsLocationsBucketsCreateRequest object.

  Fields:
    bucketId: Required. A client-assigned identifier such as "my-bucket".
      Identifiers are limited to 100 characters and can include only letters,
      digits, underscores, hyphens, and periods.
    logBucket: A LogBucket resource to be passed as the request body.
    parent: Required. The resource in which to create the bucket:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
      "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]" Example: "projects/my-
      logging-project/locations/global"
  """

  bucketId = _messages.StringField(1)
  logBucket = _messages.MessageField('LogBucket', 2)
  parent = _messages.StringField(3, required=True)


class LoggingOrganizationsLocationsBucketsDeleteRequest(_messages.Message):
  r"""A LoggingOrganizationsLocationsBucketsDeleteRequest object.

  Fields:
    name: Required. The full resource name of the bucket to delete.
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingOrganizationsLocationsBucketsGetRequest(_messages.Message):
  r"""A LoggingOrganizationsLocationsBucketsGetRequest object.

  Fields:
    name: Required. The resource name of the bucket:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingOrganizationsLocationsBucketsListRequest(_messages.Message):
  r"""A LoggingOrganizationsLocationsBucketsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The parent resource whose buckets are to be listed:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
      "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]" Note: The locations
      portion of the resource is required, but supplying the character - in
      place of LOCATION_ID will return all buckets.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingOrganizationsLocationsBucketsPatchRequest(_messages.Message):
  r"""A LoggingOrganizationsLocationsBucketsPatchRequest object.

  Fields:
    logBucket: A LogBucket resource to be passed as the request body.
    name: Required. The full resource name of the bucket to update.
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id". Also requires permission
      "resourcemanager.projects.updateLiens" to set the locked property
    updateMask: Required. Field mask that specifies the fields in bucket that
      need an update. A bucket field will be overwritten if, and only if, it
      is in the update mask. name and output only fields cannot be updated.For
      a detailed FieldMask definition, see https://developers.google.com
      /protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=retention_days.
  """

  logBucket = _messages.MessageField('LogBucket', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class LoggingOrganizationsLocationsBucketsUndeleteRequest(_messages.Message):
  r"""A LoggingOrganizationsLocationsBucketsUndeleteRequest object.

  Fields:
    name: Required. The full resource name of the bucket to undelete.
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id".
    undeleteBucketRequest: A UndeleteBucketRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  undeleteBucketRequest = _messages.MessageField('UndeleteBucketRequest', 2)


class LoggingOrganizationsLocationsBucketsViewsCreateRequest(_messages.Message):
  r"""A LoggingOrganizationsLocationsBucketsViewsCreateRequest object.

  Fields:
    logView: A LogView resource to be passed as the request body.
    parent: Required. The bucket in which to create the view
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-logging-project/locations/my-location/buckets/my-
      bucket"
    viewId: Required. The id to use for this view.
  """

  logView = _messages.MessageField('LogView', 1)
  parent = _messages.StringField(2, required=True)
  viewId = _messages.StringField(3)


class LoggingOrganizationsLocationsBucketsViewsDeleteRequest(_messages.Message):
  r"""A LoggingOrganizationsLocationsBucketsViewsDeleteRequest object.

  Fields:
    name: Required. The full resource name of the view to delete: "projects/[P
      ROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
      Example:  "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id/views/my-view-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingOrganizationsLocationsBucketsViewsGetRequest(_messages.Message):
  r"""A LoggingOrganizationsLocationsBucketsViewsGetRequest object.

  Fields:
    name: Required. The resource name of the policy: "projects/[PROJECT_ID]/lo
      cations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]" Example:
      "projects/my-project-id/locations/my-location/buckets/my-bucket-id/views
      /my-view-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingOrganizationsLocationsBucketsViewsListRequest(_messages.Message):
  r"""A LoggingOrganizationsLocationsBucketsViewsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The bucket whose views are to be listed:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingOrganizationsLocationsBucketsViewsPatchRequest(_messages.Message):
  r"""A LoggingOrganizationsLocationsBucketsViewsPatchRequest object.

  Fields:
    logView: A LogView resource to be passed as the request body.
    name: Required. The full resource name of the view to update "projects/[PR
      OJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
      Example:  "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id/views/my-view-id".
    updateMask: Optional. Field mask that specifies the fields in view that
      need an update. A field will be overwritten if, and only if, it is in
      the update mask. name and output only fields cannot be updated.For a
      detailed FieldMask definition, see https://developers.google.com
      /protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=filter.
  """

  logView = _messages.MessageField('LogView', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class LoggingOrganizationsLogsDeleteRequest(_messages.Message):
  r"""A LoggingOrganizationsLogsDeleteRequest object.

  Fields:
    logName: Required. The resource name of the log to delete:
      "projects/[PROJECT_ID]/logs/[LOG_ID]"
      "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
      "folders/[FOLDER_ID]/logs/[LOG_ID]" [LOG_ID] must be URL-encoded. For
      example, "projects/my-project-id/logs/syslog", "organizations/1234567890
      /logs/cloudresourcemanager.googleapis.com%2Factivity". For more
      information about log names, see LogEntry.
  """

  logName = _messages.StringField(1, required=True)


class LoggingOrganizationsLogsListRequest(_messages.Message):
  r"""A LoggingOrganizationsLogsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The resource name that owns the logs:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]"
    resourceNames: Required for Logging Data Model V2. The resource name that
      owns the logs:  projects/PROJECT_ID/locations/LOCATION_ID/buckets/BUCKET
      _ID/views/VIEW_ID  organization/ORGANIZATION_ID/locations/LOCATION_ID/bu
      ckets/BUCKET_ID/views/VIEW_ID  billingAccounts/BILLING_ACCOUNT_ID/locati
      ons/LOCATION_ID/buckets/BUCKET_ID/views/VIEW_ID  folders/FOLDER_ID/locat
      ions/LOCATION_ID/buckets/BUCKET_ID/views/VIEW_IDTo support legacy
      queries, it could also be:  "projects/PROJECT_ID"
      "organizations/ORGANIZATION_ID"  "billingAccounts/BILLING_ACCOUNT_ID"
      "folders/FOLDER_ID"Note: It is not supported for query across multiple
      projects/orgs/folders/billingAccounts
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  resourceNames = _messages.StringField(4, repeated=True)


class LoggingOrganizationsSinksCreateRequest(_messages.Message):
  r"""A LoggingOrganizationsSinksCreateRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    parent: Required. The resource in which to create the sink:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]" Examples:
      "projects/my-logging-project", "organizations/123456789".
    uniqueWriterIdentity: Optional. Determines the kind of IAM identity
      returned as writer_identity in the new sink. If this value is omitted or
      set to false, and if the sink's parent is a project, then the value
      returned as writer_identity is the same group or service account used by
      Logging before the addition of writer identities to this API. The sink's
      destination must be in the same project as the sink itself.If this field
      is set to true, or if the sink is owned by a non-project resource such
      as an organization, then the value of writer_identity will be a unique
      service account used only for exports from the new sink. For more
      information, see writer_identity in LogSink.
  """

  logSink = _messages.MessageField('LogSink', 1)
  parent = _messages.StringField(2, required=True)
  uniqueWriterIdentity = _messages.BooleanField(3)


class LoggingOrganizationsSinksDeleteRequest(_messages.Message):
  r"""A LoggingOrganizationsSinksDeleteRequest object.

  Fields:
    sinkName: Required. The full resource name of the sink to delete,
      including the parent resource and the sink identifier:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
  """

  sinkName = _messages.StringField(1, required=True)


class LoggingOrganizationsSinksGetRequest(_messages.Message):
  r"""A LoggingOrganizationsSinksGetRequest object.

  Fields:
    sinkName: Required. The resource name of the sink:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
  """

  sinkName = _messages.StringField(1, required=True)


class LoggingOrganizationsSinksListRequest(_messages.Message):
  r"""A LoggingOrganizationsSinksListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The parent resource whose sinks are to be listed:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingOrganizationsSinksPatchRequest(_messages.Message):
  r"""A LoggingOrganizationsSinksPatchRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    sinkName: Required. The full resource name of the sink to update,
      including the parent resource and the sink identifier:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
    uniqueWriterIdentity: Optional. See sinks.create for a description of this
      field. When updating a sink, the effect of this field on the value of
      writer_identity in the updated sink depends on both the old and new
      values of this field: If the old and new values of this field are both
      false or both true, then there is no change to the sink's
      writer_identity. If the old value is false and the new value is true,
      then writer_identity is changed to a unique service account. It is an
      error if the old value is true and the new value is set to false or
      defaulted to false.
    updateMask: Optional. Field mask that specifies the fields in sink that
      need an update. A sink field will be overwritten if, and only if, it is
      in the update mask. name and output only fields cannot be updated.An
      empty updateMask is temporarily treated as using the following mask for
      backwards compatibility purposes:  destination,filter,includeChildren At
      some point in the future, behavior will be removed and specifying an
      empty updateMask will be an error.For a detailed FieldMask definition,
      see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=filter.
  """

  logSink = _messages.MessageField('LogSink', 1)
  sinkName = _messages.StringField(2, required=True)
  uniqueWriterIdentity = _messages.BooleanField(3)
  updateMask = _messages.StringField(4)


class LoggingOrganizationsSinksUpdateRequest(_messages.Message):
  r"""A LoggingOrganizationsSinksUpdateRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    sinkName: Required. The full resource name of the sink to update,
      including the parent resource and the sink identifier:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
    uniqueWriterIdentity: Optional. See sinks.create for a description of this
      field. When updating a sink, the effect of this field on the value of
      writer_identity in the updated sink depends on both the old and new
      values of this field: If the old and new values of this field are both
      false or both true, then there is no change to the sink's
      writer_identity. If the old value is false and the new value is true,
      then writer_identity is changed to a unique service account. It is an
      error if the old value is true and the new value is set to false or
      defaulted to false.
    updateMask: Optional. Field mask that specifies the fields in sink that
      need an update. A sink field will be overwritten if, and only if, it is
      in the update mask. name and output only fields cannot be updated.An
      empty updateMask is temporarily treated as using the following mask for
      backwards compatibility purposes:  destination,filter,includeChildren At
      some point in the future, behavior will be removed and specifying an
      empty updateMask will be an error.For a detailed FieldMask definition,
      see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=filter.
  """

  logSink = _messages.MessageField('LogSink', 1)
  sinkName = _messages.StringField(2, required=True)
  uniqueWriterIdentity = _messages.BooleanField(3)
  updateMask = _messages.StringField(4)


class LoggingOrganizationsUpdateCmekSettingsRequest(_messages.Message):
  r"""A LoggingOrganizationsUpdateCmekSettingsRequest object.

  Fields:
    cmekSettings: A CmekSettings resource to be passed as the request body.
    name: Required. The resource name for the CMEK settings to update.
      "projects/[PROJECT_ID]/cmekSettings"
      "organizations/[ORGANIZATION_ID]/cmekSettings"
      "billingAccounts/[BILLING_ACCOUNT_ID]/cmekSettings"
      "folders/[FOLDER_ID]/cmekSettings" Example:
      "organizations/12345/cmekSettings".Note: CMEK for the Logs Router can
      currently only be configured for GCP organizations. Once configured, it
      applies to all projects and folders in the GCP organization.
    updateMask: Optional. Field mask identifying which fields from
      cmek_settings should be updated. A field will be overwritten if and only
      if it is in the update mask. Output only fields cannot be updated.See
      FieldMask for more information.Example: "updateMask=kmsKeyName"
  """

  cmekSettings = _messages.MessageField('CmekSettings', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class LoggingProjectsExclusionsCreateRequest(_messages.Message):
  r"""A LoggingProjectsExclusionsCreateRequest object.

  Fields:
    logExclusion: A LogExclusion resource to be passed as the request body.
    parent: Required. The parent resource in which to create the exclusion:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]" Examples:
      "projects/my-logging-project", "organizations/123456789".
  """

  logExclusion = _messages.MessageField('LogExclusion', 1)
  parent = _messages.StringField(2, required=True)


class LoggingProjectsExclusionsDeleteRequest(_messages.Message):
  r"""A LoggingProjectsExclusionsDeleteRequest object.

  Fields:
    name: Required. The resource name of an existing exclusion to delete:
      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" Example: "projects/my-
      project-id/exclusions/my-exclusion-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingProjectsExclusionsGetRequest(_messages.Message):
  r"""A LoggingProjectsExclusionsGetRequest object.

  Fields:
    name: Required. The resource name of an existing exclusion:
      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" Example: "projects/my-
      project-id/exclusions/my-exclusion-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingProjectsExclusionsListRequest(_messages.Message):
  r"""A LoggingProjectsExclusionsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The parent resource whose exclusions are to be listed.
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingProjectsExclusionsPatchRequest(_messages.Message):
  r"""A LoggingProjectsExclusionsPatchRequest object.

  Fields:
    logExclusion: A LogExclusion resource to be passed as the request body.
    name: Required. The resource name of the exclusion to update:
      "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
      "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
      "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" Example: "projects/my-
      project-id/exclusions/my-exclusion-id".
    updateMask: Required. A non-empty list of fields to change in the existing
      exclusion. New values for the fields are taken from the corresponding
      fields in the LogExclusion included in this request. Fields not
      mentioned in update_mask are not changed and are ignored in the
      request.For example, to change the filter and description of an
      exclusion, specify an update_mask of "filter,description".
  """

  logExclusion = _messages.MessageField('LogExclusion', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class LoggingProjectsLocationsBucketsCreateRequest(_messages.Message):
  r"""A LoggingProjectsLocationsBucketsCreateRequest object.

  Fields:
    bucketId: Required. A client-assigned identifier such as "my-bucket".
      Identifiers are limited to 100 characters and can include only letters,
      digits, underscores, hyphens, and periods.
    logBucket: A LogBucket resource to be passed as the request body.
    parent: Required. The resource in which to create the bucket:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
      "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]" Example: "projects/my-
      logging-project/locations/global"
  """

  bucketId = _messages.StringField(1)
  logBucket = _messages.MessageField('LogBucket', 2)
  parent = _messages.StringField(3, required=True)


class LoggingProjectsLocationsBucketsDeleteRequest(_messages.Message):
  r"""A LoggingProjectsLocationsBucketsDeleteRequest object.

  Fields:
    name: Required. The full resource name of the bucket to delete.
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingProjectsLocationsBucketsGetRequest(_messages.Message):
  r"""A LoggingProjectsLocationsBucketsGetRequest object.

  Fields:
    name: Required. The resource name of the bucket:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingProjectsLocationsBucketsListRequest(_messages.Message):
  r"""A LoggingProjectsLocationsBucketsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The parent resource whose buckets are to be listed:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
      "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]" Note: The locations
      portion of the resource is required, but supplying the character - in
      place of LOCATION_ID will return all buckets.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingProjectsLocationsBucketsPatchRequest(_messages.Message):
  r"""A LoggingProjectsLocationsBucketsPatchRequest object.

  Fields:
    logBucket: A LogBucket resource to be passed as the request body.
    name: Required. The full resource name of the bucket to update.
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id". Also requires permission
      "resourcemanager.projects.updateLiens" to set the locked property
    updateMask: Required. Field mask that specifies the fields in bucket that
      need an update. A bucket field will be overwritten if, and only if, it
      is in the update mask. name and output only fields cannot be updated.For
      a detailed FieldMask definition, see https://developers.google.com
      /protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=retention_days.
  """

  logBucket = _messages.MessageField('LogBucket', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class LoggingProjectsLocationsBucketsUndeleteRequest(_messages.Message):
  r"""A LoggingProjectsLocationsBucketsUndeleteRequest object.

  Fields:
    name: Required. The full resource name of the bucket to undelete.
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" "org
      anizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]
      " "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/
      [BUCKET_ID]"
      "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id".
    undeleteBucketRequest: A UndeleteBucketRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  undeleteBucketRequest = _messages.MessageField('UndeleteBucketRequest', 2)


class LoggingProjectsLocationsBucketsViewsCreateRequest(_messages.Message):
  r"""A LoggingProjectsLocationsBucketsViewsCreateRequest object.

  Fields:
    logView: A LogView resource to be passed as the request body.
    parent: Required. The bucket in which to create the view
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
      Example: "projects/my-logging-project/locations/my-location/buckets/my-
      bucket"
    viewId: Required. The id to use for this view.
  """

  logView = _messages.MessageField('LogView', 1)
  parent = _messages.StringField(2, required=True)
  viewId = _messages.StringField(3)


class LoggingProjectsLocationsBucketsViewsDeleteRequest(_messages.Message):
  r"""A LoggingProjectsLocationsBucketsViewsDeleteRequest object.

  Fields:
    name: Required. The full resource name of the view to delete: "projects/[P
      ROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
      Example:  "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id/views/my-view-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingProjectsLocationsBucketsViewsGetRequest(_messages.Message):
  r"""A LoggingProjectsLocationsBucketsViewsGetRequest object.

  Fields:
    name: Required. The resource name of the policy: "projects/[PROJECT_ID]/lo
      cations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]" Example:
      "projects/my-project-id/locations/my-location/buckets/my-bucket-id/views
      /my-view-id".
  """

  name = _messages.StringField(1, required=True)


class LoggingProjectsLocationsBucketsViewsListRequest(_messages.Message):
  r"""A LoggingProjectsLocationsBucketsViewsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The bucket whose views are to be listed:
      "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingProjectsLocationsBucketsViewsPatchRequest(_messages.Message):
  r"""A LoggingProjectsLocationsBucketsViewsPatchRequest object.

  Fields:
    logView: A LogView resource to be passed as the request body.
    name: Required. The full resource name of the view to update "projects/[PR
      OJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
      Example:  "projects/my-project-id/locations/my-location/buckets/my-
      bucket-id/views/my-view-id".
    updateMask: Optional. Field mask that specifies the fields in view that
      need an update. A field will be overwritten if, and only if, it is in
      the update mask. name and output only fields cannot be updated.For a
      detailed FieldMask definition, see https://developers.google.com
      /protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=filter.
  """

  logView = _messages.MessageField('LogView', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class LoggingProjectsLogsDeleteRequest(_messages.Message):
  r"""A LoggingProjectsLogsDeleteRequest object.

  Fields:
    logName: Required. The resource name of the log to delete:
      "projects/[PROJECT_ID]/logs/[LOG_ID]"
      "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
      "folders/[FOLDER_ID]/logs/[LOG_ID]" [LOG_ID] must be URL-encoded. For
      example, "projects/my-project-id/logs/syslog", "organizations/1234567890
      /logs/cloudresourcemanager.googleapis.com%2Factivity". For more
      information about log names, see LogEntry.
  """

  logName = _messages.StringField(1, required=True)


class LoggingProjectsLogsListRequest(_messages.Message):
  r"""A LoggingProjectsLogsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The resource name that owns the logs:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]"
    resourceNames: Required for Logging Data Model V2. The resource name that
      owns the logs:  projects/PROJECT_ID/locations/LOCATION_ID/buckets/BUCKET
      _ID/views/VIEW_ID  organization/ORGANIZATION_ID/locations/LOCATION_ID/bu
      ckets/BUCKET_ID/views/VIEW_ID  billingAccounts/BILLING_ACCOUNT_ID/locati
      ons/LOCATION_ID/buckets/BUCKET_ID/views/VIEW_ID  folders/FOLDER_ID/locat
      ions/LOCATION_ID/buckets/BUCKET_ID/views/VIEW_IDTo support legacy
      queries, it could also be:  "projects/PROJECT_ID"
      "organizations/ORGANIZATION_ID"  "billingAccounts/BILLING_ACCOUNT_ID"
      "folders/FOLDER_ID"Note: It is not supported for query across multiple
      projects/orgs/folders/billingAccounts
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  resourceNames = _messages.StringField(4, repeated=True)


class LoggingProjectsMetricsCreateRequest(_messages.Message):
  r"""A LoggingProjectsMetricsCreateRequest object.

  Fields:
    logMetric: A LogMetric resource to be passed as the request body.
    parent: The resource name of the project in which to create the metric:
      "projects/[PROJECT_ID]" The new metric must be provided in the request.
  """

  logMetric = _messages.MessageField('LogMetric', 1)
  parent = _messages.StringField(2, required=True)


class LoggingProjectsMetricsDeleteRequest(_messages.Message):
  r"""A LoggingProjectsMetricsDeleteRequest object.

  Fields:
    metricName: The resource name of the metric to delete:
      "projects/[PROJECT_ID]/metrics/[METRIC_ID]"
  """

  metricName = _messages.StringField(1, required=True)


class LoggingProjectsMetricsGetRequest(_messages.Message):
  r"""A LoggingProjectsMetricsGetRequest object.

  Fields:
    metricName: The resource name of the desired metric:
      "projects/[PROJECT_ID]/metrics/[METRIC_ID]"
  """

  metricName = _messages.StringField(1, required=True)


class LoggingProjectsMetricsListRequest(_messages.Message):
  r"""A LoggingProjectsMetricsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The name of the project containing the metrics:
      "projects/[PROJECT_ID]"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingProjectsMetricsUpdateRequest(_messages.Message):
  r"""A LoggingProjectsMetricsUpdateRequest object.

  Fields:
    logMetric: A LogMetric resource to be passed as the request body.
    metricName: The resource name of the metric to update:
      "projects/[PROJECT_ID]/metrics/[METRIC_ID]" The updated metric must be
      provided in the request and it's name field must be the same as
      [METRIC_ID] If the metric does not exist in [PROJECT_ID], then a new
      metric is created.
  """

  logMetric = _messages.MessageField('LogMetric', 1)
  metricName = _messages.StringField(2, required=True)


class LoggingProjectsSinksCreateRequest(_messages.Message):
  r"""A LoggingProjectsSinksCreateRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    parent: Required. The resource in which to create the sink:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]" Examples:
      "projects/my-logging-project", "organizations/123456789".
    uniqueWriterIdentity: Optional. Determines the kind of IAM identity
      returned as writer_identity in the new sink. If this value is omitted or
      set to false, and if the sink's parent is a project, then the value
      returned as writer_identity is the same group or service account used by
      Logging before the addition of writer identities to this API. The sink's
      destination must be in the same project as the sink itself.If this field
      is set to true, or if the sink is owned by a non-project resource such
      as an organization, then the value of writer_identity will be a unique
      service account used only for exports from the new sink. For more
      information, see writer_identity in LogSink.
  """

  logSink = _messages.MessageField('LogSink', 1)
  parent = _messages.StringField(2, required=True)
  uniqueWriterIdentity = _messages.BooleanField(3)


class LoggingProjectsSinksDeleteRequest(_messages.Message):
  r"""A LoggingProjectsSinksDeleteRequest object.

  Fields:
    sinkName: Required. The full resource name of the sink to delete,
      including the parent resource and the sink identifier:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
  """

  sinkName = _messages.StringField(1, required=True)


class LoggingProjectsSinksGetRequest(_messages.Message):
  r"""A LoggingProjectsSinksGetRequest object.

  Fields:
    sinkName: Required. The resource name of the sink:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
  """

  sinkName = _messages.StringField(1, required=True)


class LoggingProjectsSinksListRequest(_messages.Message):
  r"""A LoggingProjectsSinksListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The parent resource whose sinks are to be listed:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingProjectsSinksPatchRequest(_messages.Message):
  r"""A LoggingProjectsSinksPatchRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    sinkName: Required. The full resource name of the sink to update,
      including the parent resource and the sink identifier:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
    uniqueWriterIdentity: Optional. See sinks.create for a description of this
      field. When updating a sink, the effect of this field on the value of
      writer_identity in the updated sink depends on both the old and new
      values of this field: If the old and new values of this field are both
      false or both true, then there is no change to the sink's
      writer_identity. If the old value is false and the new value is true,
      then writer_identity is changed to a unique service account. It is an
      error if the old value is true and the new value is set to false or
      defaulted to false.
    updateMask: Optional. Field mask that specifies the fields in sink that
      need an update. A sink field will be overwritten if, and only if, it is
      in the update mask. name and output only fields cannot be updated.An
      empty updateMask is temporarily treated as using the following mask for
      backwards compatibility purposes:  destination,filter,includeChildren At
      some point in the future, behavior will be removed and specifying an
      empty updateMask will be an error.For a detailed FieldMask definition,
      see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=filter.
  """

  logSink = _messages.MessageField('LogSink', 1)
  sinkName = _messages.StringField(2, required=True)
  uniqueWriterIdentity = _messages.BooleanField(3)
  updateMask = _messages.StringField(4)


class LoggingProjectsSinksUpdateRequest(_messages.Message):
  r"""A LoggingProjectsSinksUpdateRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    sinkName: Required. The full resource name of the sink to update,
      including the parent resource and the sink identifier:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
    uniqueWriterIdentity: Optional. See sinks.create for a description of this
      field. When updating a sink, the effect of this field on the value of
      writer_identity in the updated sink depends on both the old and new
      values of this field: If the old and new values of this field are both
      false or both true, then there is no change to the sink's
      writer_identity. If the old value is false and the new value is true,
      then writer_identity is changed to a unique service account. It is an
      error if the old value is true and the new value is set to false or
      defaulted to false.
    updateMask: Optional. Field mask that specifies the fields in sink that
      need an update. A sink field will be overwritten if, and only if, it is
      in the update mask. name and output only fields cannot be updated.An
      empty updateMask is temporarily treated as using the following mask for
      backwards compatibility purposes:  destination,filter,includeChildren At
      some point in the future, behavior will be removed and specifying an
      empty updateMask will be an error.For a detailed FieldMask definition,
      see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=filter.
  """

  logSink = _messages.MessageField('LogSink', 1)
  sinkName = _messages.StringField(2, required=True)
  uniqueWriterIdentity = _messages.BooleanField(3)
  updateMask = _messages.StringField(4)


class LoggingSinksCreateRequest(_messages.Message):
  r"""A LoggingSinksCreateRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    parent: Required. The resource in which to create the sink:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]" Examples:
      "projects/my-logging-project", "organizations/123456789".
    uniqueWriterIdentity: Optional. Determines the kind of IAM identity
      returned as writer_identity in the new sink. If this value is omitted or
      set to false, and if the sink's parent is a project, then the value
      returned as writer_identity is the same group or service account used by
      Logging before the addition of writer identities to this API. The sink's
      destination must be in the same project as the sink itself.If this field
      is set to true, or if the sink is owned by a non-project resource such
      as an organization, then the value of writer_identity will be a unique
      service account used only for exports from the new sink. For more
      information, see writer_identity in LogSink.
  """

  logSink = _messages.MessageField('LogSink', 1)
  parent = _messages.StringField(2, required=True)
  uniqueWriterIdentity = _messages.BooleanField(3)


class LoggingSinksDeleteRequest(_messages.Message):
  r"""A LoggingSinksDeleteRequest object.

  Fields:
    sinkName: Required. The full resource name of the sink to delete,
      including the parent resource and the sink identifier:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
  """

  sinkName = _messages.StringField(1, required=True)


class LoggingSinksGetRequest(_messages.Message):
  r"""A LoggingSinksGetRequest object.

  Fields:
    sinkName: Required. The resource name of the sink:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
  """

  sinkName = _messages.StringField(1, required=True)


class LoggingSinksListRequest(_messages.Message):
  r"""A LoggingSinksListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return from this
      request. Non-positive values are ignored. The presence of nextPageToken
      in the response indicates that more results might be available.
    pageToken: Optional. If present, then retrieve the next batch of results
      from the preceding call to this method. pageToken must be the value of
      nextPageToken from the previous response. The values of other method
      parameters should be identical to those in the previous call.
    parent: Required. The parent resource whose sinks are to be listed:
      "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LoggingSinksUpdateRequest(_messages.Message):
  r"""A LoggingSinksUpdateRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    sinkName: Required. The full resource name of the sink to update,
      including the parent resource and the sink identifier:
      "projects/[PROJECT_ID]/sinks/[SINK_ID]"
      "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
      "folders/[FOLDER_ID]/sinks/[SINK_ID]" Example: "projects/my-project-
      id/sinks/my-sink-id".
    uniqueWriterIdentity: Optional. See sinks.create for a description of this
      field. When updating a sink, the effect of this field on the value of
      writer_identity in the updated sink depends on both the old and new
      values of this field: If the old and new values of this field are both
      false or both true, then there is no change to the sink's
      writer_identity. If the old value is false and the new value is true,
      then writer_identity is changed to a unique service account. It is an
      error if the old value is true and the new value is set to false or
      defaulted to false.
    updateMask: Optional. Field mask that specifies the fields in sink that
      need an update. A sink field will be overwritten if, and only if, it is
      in the update mask. name and output only fields cannot be updated.An
      empty updateMask is temporarily treated as using the following mask for
      backwards compatibility purposes:  destination,filter,includeChildren At
      some point in the future, behavior will be removed and specifying an
      empty updateMask will be an error.For a detailed FieldMask definition,
      see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskExample:
      updateMask=filter.
  """

  logSink = _messages.MessageField('LogSink', 1)
  sinkName = _messages.StringField(2, required=True)
  uniqueWriterIdentity = _messages.BooleanField(3)
  updateMask = _messages.StringField(4)


class LoggingUpdateCmekSettingsRequest(_messages.Message):
  r"""A LoggingUpdateCmekSettingsRequest object.

  Fields:
    cmekSettings: A CmekSettings resource to be passed as the request body.
    name: Required. The resource name for the CMEK settings to update.
      "projects/[PROJECT_ID]/cmekSettings"
      "organizations/[ORGANIZATION_ID]/cmekSettings"
      "billingAccounts/[BILLING_ACCOUNT_ID]/cmekSettings"
      "folders/[FOLDER_ID]/cmekSettings" Example:
      "organizations/12345/cmekSettings".Note: CMEK for the Logs Router can
      currently only be configured for GCP organizations. Once configured, it
      applies to all projects and folders in the GCP organization.
    updateMask: Optional. Field mask identifying which fields from
      cmek_settings should be updated. A field will be overwritten if and only
      if it is in the update mask. Output only fields cannot be updated.See
      FieldMask for more information.Example: "updateMask=kmsKeyName"
  """

  cmekSettings = _messages.MessageField('CmekSettings', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class MetricDescriptor(_messages.Message):
  r"""Defines a metric type and its schema. Once a metric descriptor is
  created, deleting or altering it stops data collection and makes the metric
  type's existing data unusable.

  Enums:
    LaunchStageValueValuesEnum: Optional. The launch stage of the metric
      definition.
    MetricKindValueValuesEnum: Whether the metric records instantaneous
      values, changes to a value, etc. Some combinations of metric_kind and
      value_type might not be supported.
    ValueTypeValueValuesEnum: Whether the measurement is an integer, a
      floating-point number, etc. Some combinations of metric_kind and
      value_type might not be supported.

  Fields:
    description: A detailed description of the metric, which can be used in
      documentation.
    displayName: A concise name for the metric, which can be displayed in user
      interfaces. Use sentence case without an ending period, for example
      "Request count". This field is optional but it is recommended to be set
      for any metrics associated with user-visible concepts, such as Quota.
    labels: The set of labels that can be used to describe a specific instance
      of this metric type. For example, the
      appengine.googleapis.com/http/server/response_latencies metric type has
      a label for the HTTP response code, response_code, so you can look at
      latencies for successful responses or just for responses that failed.
    launchStage: Optional. The launch stage of the metric definition.
    metadata: Optional. Metadata which can be used to guide usage of the
      metric.
    metricKind: Whether the metric records instantaneous values, changes to a
      value, etc. Some combinations of metric_kind and value_type might not be
      supported.
    monitoredResourceTypes: Read-only. If present, then a time series, which
      is identified partially by a metric type and a
      MonitoredResourceDescriptor, that is associated with this metric type
      can only be associated with one of the monitored resource types listed
      here.
    name: The resource name of the metric descriptor.
    type: The metric type, including its DNS name prefix. The type is not URL-
      encoded. All user-defined metric types have the DNS name
      custom.googleapis.com or external.googleapis.com. Metric types should
      use a natural hierarchical grouping. For example:
      "custom.googleapis.com/invoice/paid/amount"
      "external.googleapis.com/prometheus/up"
      "appengine.googleapis.com/http/server/response_latencies"
    unit: The units in which the metric value is reported. It is only
      applicable if the value_type is INT64, DOUBLE, or DISTRIBUTION. The unit
      defines the representation of the stored metric values.Different systems
      may scale the values to be more easily displayed (so a value of 0.02KBy
      might be displayed as 20By, and a value of 3523KBy might be displayed as
      3.5MBy). However, if the unit is KBy, then the value of the metric is
      always in thousands of bytes, no matter how it may be displayed..If you
      want a custom metric to record the exact number of CPU-seconds used by a
      job, you can create an INT64 CUMULATIVE metric whose unit is s{CPU} (or
      equivalently 1s{CPU} or just s). If the job uses 12,005 CPU-seconds,
      then the value is written as 12005.Alternatively, if you want a custom
      metric to record data in a more granular way, you can create a DOUBLE
      CUMULATIVE metric whose unit is ks{CPU}, and then write the value 12.005
      (which is 12005/1000), or use Kis{CPU} and write 11.723 (which is
      12005/1024).The supported units are a subset of The Unified Code for
      Units of Measure (http://unitsofmeasure.org/ucum.html) standard:Basic
      units (UNIT) bit bit By byte s second min minute h hour d dayPrefixes
      (PREFIX) k kilo (10^3) M mega (10^6) G giga (10^9) T tera (10^12) P peta
      (10^15) E exa (10^18) Z zetta (10^21) Y yotta (10^24) m milli (10^-3) u
      micro (10^-6) n nano (10^-9) p pico (10^-12) f femto (10^-15) a atto
      (10^-18) z zepto (10^-21) y yocto (10^-24) Ki kibi (2^10) Mi mebi (2^20)
      Gi gibi (2^30) Ti tebi (2^40) Pi pebi (2^50)GrammarThe grammar also
      includes these connectors: / division or ratio (as an infix operator).
      For examples,  kBy/{email} or MiBy/10ms (although you should almost
      never  have /s in a metric unit; rates should always be computed at
      query time from the underlying cumulative or delta value). .
      multiplication or composition (as an infix operator). For  examples,
      GBy.d or k{watt}.h.The grammar for a unit is as follows: Expression =
      Component { "." Component } { "/" Component } ;  Component = ( [ PREFIX
      ] UNIT | "%" ) [ Annotation ]           | Annotation           | "1"
      ;  Annotation = "{" NAME "}" ; Notes: Annotation is just a comment if it
      follows a UNIT. If the annotation  is used alone, then the unit is
      equivalent to 1. For examples,  {request}/s == 1/s, By{transmitted}/s ==
      By/s. NAME is a sequence of non-blank printable ASCII characters not
      containing { or }. 1 represents a unitary dimensionless  unit
      (https://en.wikipedia.org/wiki/Dimensionless_quantity) of 1, such  as in
      1/s. It is typically used when none of the basic units are  appropriate.
      For example, "new users per day" can be represented as  1/d or {new-
      users}/d (and a metric value 5 would mean "5 new  users). Alternatively,
      "thousands of page views per day" would be  represented as 1000/d or
      k1/d or k{page_views}/d (and a metric  value of 5.3 would mean "5300
      page views per day"). % represents dimensionless value of 1/100, and
      annotates values giving  a percentage (so the metric values are
      typically in the range of 0..100,  and a metric value 3 means "3
      percent"). 10^2.% indicates a metric contains a ratio, typically in the
      range  0..1, that will be multiplied by 100 and displayed as a
      percentage  (so a metric value 0.03 means "3 percent").
    valueType: Whether the measurement is an integer, a floating-point number,
      etc. Some combinations of metric_kind and value_type might not be
      supported.
  """

  class LaunchStageValueValuesEnum(_messages.Enum):
    r"""Optional. The launch stage of the metric definition.

    Values:
      LAUNCH_STAGE_UNSPECIFIED: Do not use this default value.
      EARLY_ACCESS: Early Access features are limited to a closed group of
        testers. To use these features, you must sign up in advance and sign a
        Trusted Tester agreement (which includes confidentiality provisions).
        These features may be unstable, changed in backward-incompatible ways,
        and are not guaranteed to be released.
      ALPHA: Alpha is a limited availability test for releases before they are
        cleared for widespread use. By Alpha, all significant design issues
        are resolved and we are in the process of verifying functionality.
        Alpha customers need to apply for access, agree to applicable terms,
        and have their projects whitelisted. Alpha releases don't have to be
        feature complete, no SLAs are provided, and there are no technical
        support obligations, but they will be far enough along that customers
        can actually use them in test environments or for limited-use tests --
        just like they would in normal production cases.
      BETA: Beta is the point at which we are ready to open a release for any
        customer to use. There are no SLA or technical support obligations in
        a Beta release. Products will be complete from a feature perspective,
        but may have some open outstanding issues. Beta releases are suitable
        for limited production use cases.
      GA: GA features are open to all developers and are considered stable and
        fully qualified for production use.
      DEPRECATED: Deprecated features are scheduled to be shut down and
        removed. For more information, see the "Deprecation Policy" section of
        our Terms of Service (https://cloud.google.com/terms/) and the Google
        Cloud Platform Subject to the Deprecation Policy
        (https://cloud.google.com/terms/deprecation) documentation.
    """
    LAUNCH_STAGE_UNSPECIFIED = 0
    EARLY_ACCESS = 1
    ALPHA = 2
    BETA = 3
    GA = 4
    DEPRECATED = 5

  class MetricKindValueValuesEnum(_messages.Enum):
    r"""Whether the metric records instantaneous values, changes to a value,
    etc. Some combinations of metric_kind and value_type might not be
    supported.

    Values:
      METRIC_KIND_UNSPECIFIED: Do not use this default value.
      GAUGE: An instantaneous measurement of a value.
      DELTA: The change in a value during a time interval.
      CUMULATIVE: A value accumulated over a time interval. Cumulative
        measurements in a time series should have the same start time and
        increasing end times, until an event resets the cumulative value to
        zero and sets a new start time for the following points.
    """
    METRIC_KIND_UNSPECIFIED = 0
    GAUGE = 1
    DELTA = 2
    CUMULATIVE = 3

  class ValueTypeValueValuesEnum(_messages.Enum):
    r"""Whether the measurement is an integer, a floating-point number, etc.
    Some combinations of metric_kind and value_type might not be supported.

    Values:
      VALUE_TYPE_UNSPECIFIED: Do not use this default value.
      BOOL: The value is a boolean. This value type can be used only if the
        metric kind is GAUGE.
      INT64: The value is a signed 64-bit integer.
      DOUBLE: The value is a double precision floating point number.
      STRING: The value is a text string. This value type can be used only if
        the metric kind is GAUGE.
      DISTRIBUTION: The value is a Distribution.
      MONEY: The value is money.
    """
    VALUE_TYPE_UNSPECIFIED = 0
    BOOL = 1
    INT64 = 2
    DOUBLE = 3
    STRING = 4
    DISTRIBUTION = 5
    MONEY = 6

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  labels = _messages.MessageField('LabelDescriptor', 3, repeated=True)
  launchStage = _messages.EnumField('LaunchStageValueValuesEnum', 4)
  metadata = _messages.MessageField('MetricDescriptorMetadata', 5)
  metricKind = _messages.EnumField('MetricKindValueValuesEnum', 6)
  monitoredResourceTypes = _messages.StringField(7, repeated=True)
  name = _messages.StringField(8)
  type = _messages.StringField(9)
  unit = _messages.StringField(10)
  valueType = _messages.EnumField('ValueTypeValueValuesEnum', 11)


class MetricDescriptorMetadata(_messages.Message):
  r"""Additional annotations that can be used to guide the usage of a metric.

  Enums:
    LaunchStageValueValuesEnum: Deprecated. Must use the
      MetricDescriptor.launch_stage instead.

  Fields:
    ingestDelay: The delay of data points caused by ingestion. Data points
      older than this age are guaranteed to be ingested and available to be
      read, excluding data loss due to errors.
    launchStage: Deprecated. Must use the MetricDescriptor.launch_stage
      instead.
    samplePeriod: The sampling period of metric data points. For metrics which
      are written periodically, consecutive data points are stored at this
      time interval, excluding data loss due to errors. Metrics with a higher
      granularity have a smaller sampling period.
  """

  class LaunchStageValueValuesEnum(_messages.Enum):
    r"""Deprecated. Must use the MetricDescriptor.launch_stage instead.

    Values:
      LAUNCH_STAGE_UNSPECIFIED: Do not use this default value.
      EARLY_ACCESS: Early Access features are limited to a closed group of
        testers. To use these features, you must sign up in advance and sign a
        Trusted Tester agreement (which includes confidentiality provisions).
        These features may be unstable, changed in backward-incompatible ways,
        and are not guaranteed to be released.
      ALPHA: Alpha is a limited availability test for releases before they are
        cleared for widespread use. By Alpha, all significant design issues
        are resolved and we are in the process of verifying functionality.
        Alpha customers need to apply for access, agree to applicable terms,
        and have their projects whitelisted. Alpha releases don't have to be
        feature complete, no SLAs are provided, and there are no technical
        support obligations, but they will be far enough along that customers
        can actually use them in test environments or for limited-use tests --
        just like they would in normal production cases.
      BETA: Beta is the point at which we are ready to open a release for any
        customer to use. There are no SLA or technical support obligations in
        a Beta release. Products will be complete from a feature perspective,
        but may have some open outstanding issues. Beta releases are suitable
        for limited production use cases.
      GA: GA features are open to all developers and are considered stable and
        fully qualified for production use.
      DEPRECATED: Deprecated features are scheduled to be shut down and
        removed. For more information, see the "Deprecation Policy" section of
        our Terms of Service (https://cloud.google.com/terms/) and the Google
        Cloud Platform Subject to the Deprecation Policy
        (https://cloud.google.com/terms/deprecation) documentation.
    """
    LAUNCH_STAGE_UNSPECIFIED = 0
    EARLY_ACCESS = 1
    ALPHA = 2
    BETA = 3
    GA = 4
    DEPRECATED = 5

  ingestDelay = _messages.StringField(1)
  launchStage = _messages.EnumField('LaunchStageValueValuesEnum', 2)
  samplePeriod = _messages.StringField(3)


class MonitoredResource(_messages.Message):
  r"""An object representing a resource that can be used for monitoring,
  logging, billing, or other purposes. Examples include virtual machine
  instances, databases, and storage devices such as disks. The type field
  identifies a MonitoredResourceDescriptor object that describes the
  resource's schema. Information in the labels field identifies the actual
  resource and its attributes according to the schema. For example, a
  particular Compute Engine VM instance could be represented by the following
  object, because the MonitoredResourceDescriptor for "gce_instance" has
  labels "instance_id" and "zone": { "type": "gce_instance",   "labels": {
  "instance_id": "12345678901234",               "zone": "us-central1-a" }}

  Messages:
    LabelsValue: Required. Values for all of the labels listed in the
      associated monitored resource descriptor. For example, Compute Engine VM
      instances use the labels "project_id", "instance_id", and "zone".

  Fields:
    labels: Required. Values for all of the labels listed in the associated
      monitored resource descriptor. For example, Compute Engine VM instances
      use the labels "project_id", "instance_id", and "zone".
    type: Required. The monitored resource type. This field must match the
      type field of a MonitoredResourceDescriptor object. For example, the
      type of a Compute Engine VM instance is gce_instance.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Required. Values for all of the labels listed in the associated
    monitored resource descriptor. For example, Compute Engine VM instances
    use the labels "project_id", "instance_id", and "zone".

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labels = _messages.MessageField('LabelsValue', 1)
  type = _messages.StringField(2)


class MonitoredResourceDescriptor(_messages.Message):
  r"""An object that describes the schema of a MonitoredResource object using
  a type name and a set of labels. For example, the monitored resource
  descriptor for Google Compute Engine VM instances has a type of
  "gce_instance" and specifies the use of the labels "instance_id" and "zone"
  to identify particular VM instances.Different APIs can support different
  monitored resource types. APIs generally provide a list method that returns
  the monitored resource descriptors used by the API.

  Enums:
    LaunchStageValueValuesEnum: Optional. The launch stage of the monitored
      resource definition.

  Fields:
    description: Optional. A detailed description of the monitored resource
      type that might be used in documentation.
    displayName: Optional. A concise name for the monitored resource type that
      might be displayed in user interfaces. It should be a Title Cased Noun
      Phrase, without any article or other determiners. For example, "Google
      Cloud SQL Database".
    labels: Required. A set of labels used to describe instances of this
      monitored resource type. For example, an individual Google Cloud SQL
      database is identified by values for the labels "database_id" and
      "zone".
    launchStage: Optional. The launch stage of the monitored resource
      definition.
    name: Optional. The resource name of the monitored resource descriptor:
      "projects/{project_id}/monitoredResourceDescriptors/{type}" where {type}
      is the value of the type field in this object and {project_id} is a
      project ID that provides API-specific context for accessing the type.
      APIs that do not use project information can use the resource name
      format "monitoredResourceDescriptors/{type}".
    type: Required. The monitored resource type. For example, the type
      "cloudsql_database" represents databases in Google Cloud SQL. The
      maximum length of this value is 256 characters.
  """

  class LaunchStageValueValuesEnum(_messages.Enum):
    r"""Optional. The launch stage of the monitored resource definition.

    Values:
      LAUNCH_STAGE_UNSPECIFIED: Do not use this default value.
      EARLY_ACCESS: Early Access features are limited to a closed group of
        testers. To use these features, you must sign up in advance and sign a
        Trusted Tester agreement (which includes confidentiality provisions).
        These features may be unstable, changed in backward-incompatible ways,
        and are not guaranteed to be released.
      ALPHA: Alpha is a limited availability test for releases before they are
        cleared for widespread use. By Alpha, all significant design issues
        are resolved and we are in the process of verifying functionality.
        Alpha customers need to apply for access, agree to applicable terms,
        and have their projects whitelisted. Alpha releases don't have to be
        feature complete, no SLAs are provided, and there are no technical
        support obligations, but they will be far enough along that customers
        can actually use them in test environments or for limited-use tests --
        just like they would in normal production cases.
      BETA: Beta is the point at which we are ready to open a release for any
        customer to use. There are no SLA or technical support obligations in
        a Beta release. Products will be complete from a feature perspective,
        but may have some open outstanding issues. Beta releases are suitable
        for limited production use cases.
      GA: GA features are open to all developers and are considered stable and
        fully qualified for production use.
      DEPRECATED: Deprecated features are scheduled to be shut down and
        removed. For more information, see the "Deprecation Policy" section of
        our Terms of Service (https://cloud.google.com/terms/) and the Google
        Cloud Platform Subject to the Deprecation Policy
        (https://cloud.google.com/terms/deprecation) documentation.
    """
    LAUNCH_STAGE_UNSPECIFIED = 0
    EARLY_ACCESS = 1
    ALPHA = 2
    BETA = 3
    GA = 4
    DEPRECATED = 5

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  labels = _messages.MessageField('LabelDescriptor', 3, repeated=True)
  launchStage = _messages.EnumField('LaunchStageValueValuesEnum', 4)
  name = _messages.StringField(5)
  type = _messages.StringField(6)


class MonitoredResourceMetadata(_messages.Message):
  r"""Auxiliary metadata for a MonitoredResource object. MonitoredResource
  objects contain the minimum set of information to uniquely identify a
  monitored resource instance. There is some other useful auxiliary metadata.
  Monitoring and Logging use an ingestion pipeline to extract metadata for
  cloud resources of all types, and store the metadata in this message.

  Messages:
    SystemLabelsValue: Output only. Values for predefined system metadata
      labels. System labels are a kind of metadata extracted by Google,
      including "machine_image", "vpc", "subnet_id", "security_group", "name",
      etc. System label values can be only strings, Boolean values, or a list
      of strings. For example: { "name": "my-test-instance",
      "security_group": ["a", "b", "c"],   "spot_instance": false }
    UserLabelsValue: Output only. A map of user-defined metadata labels.

  Fields:
    systemLabels: Output only. Values for predefined system metadata labels.
      System labels are a kind of metadata extracted by Google, including
      "machine_image", "vpc", "subnet_id", "security_group", "name", etc.
      System label values can be only strings, Boolean values, or a list of
      strings. For example: { "name": "my-test-instance",   "security_group":
      ["a", "b", "c"],   "spot_instance": false }
    userLabels: Output only. A map of user-defined metadata labels.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SystemLabelsValue(_messages.Message):
    r"""Output only. Values for predefined system metadata labels. System
    labels are a kind of metadata extracted by Google, including
    "machine_image", "vpc", "subnet_id", "security_group", "name", etc. System
    label values can be only strings, Boolean values, or a list of strings.
    For example: { "name": "my-test-instance",   "security_group": ["a", "b",
    "c"],   "spot_instance": false }

    Messages:
      AdditionalProperty: An additional property for a SystemLabelsValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SystemLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class UserLabelsValue(_messages.Message):
    r"""Output only. A map of user-defined metadata labels.

    Messages:
      AdditionalProperty: An additional property for a UserLabelsValue object.

    Fields:
      additionalProperties: Additional properties of type UserLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a UserLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  systemLabels = _messages.MessageField('SystemLabelsValue', 1)
  userLabels = _messages.MessageField('UserLabelsValue', 2)


class RequestLog(_messages.Message):
  r"""Complete log information about a single HTTP request to an App Engine
  application.

  Fields:
    appEngineRelease: App Engine release version.
    appId: Application that handled this request.
    cost: An indication of the relative cost of serving this request.
    endTime: Time when the request finished.
    finished: Whether this request is finished or active.
    first: Whether this is the first RequestLog entry for this request. If an
      active request has several RequestLog entries written to Stackdriver
      Logging, then this field will be set for one of them.
    host: Internet host and port number of the resource being requested.
    httpVersion: HTTP version of request. Example: "HTTP/1.1".
    instanceId: An identifier for the instance that handled the request.
    instanceIndex: If the instance processing this request belongs to a
      manually scaled module, then this is the 0-based index of the instance.
      Otherwise, this value is -1.
    ip: Origin IP address.
    latency: Latency of the request.
    line: A list of log lines emitted by the application while serving this
      request.
    megaCycles: Number of CPU megacycles used to process request.
    method: Request method. Example: "GET", "HEAD", "PUT", "POST", "DELETE".
    moduleId: Module of the application that handled this request.
    nickname: The logged-in user who made the request.Most likely, this is the
      part of the user's email before the @ sign. The field value is the same
      for different requests from the same user, but different users can have
      similar names. This information is also available to the application via
      the App Engine Users API.This field will be populated starting with App
      Engine 1.9.21.
    pendingTime: Time this request spent in the pending request queue.
    referrer: Referrer URL of request.
    requestId: Globally unique identifier for a request, which is based on the
      request start time. Request IDs for requests which started later will
      compare greater as strings than those for requests which started
      earlier.
    resource: Contains the path and query portion of the URL that was
      requested. For example, if the URL was
      "http://example.com/app?name=val", the resource would be
      "/app?name=val". The fragment identifier, which is identified by the #
      character, is not included.
    responseSize: Size in bytes sent back to client by request.
    sourceReference: Source code for the application that handled this
      request. There can be more than one source reference per deployed
      application if source code is distributed among multiple repositories.
    startTime: Time when the request started.
    status: HTTP response status code. Example: 200, 404.
    taskName: Task name of the request, in the case of an offline request.
    taskQueueName: Queue name of the request, in the case of an offline
      request.
    traceId: Stackdriver Trace identifier for this request.
    traceSampled: If true, the value in the 'trace_id' field was sampled for
      storage in a trace backend.
    urlMapEntry: File or class that handled the request.
    userAgent: User agent that made the request.
    versionId: Version of the application that handled this request.
    wasLoadingRequest: Whether this was a loading request for the instance.
  """

  appEngineRelease = _messages.StringField(1)
  appId = _messages.StringField(2)
  cost = _messages.FloatField(3)
  endTime = _messages.StringField(4)
  finished = _messages.BooleanField(5)
  first = _messages.BooleanField(6)
  host = _messages.StringField(7)
  httpVersion = _messages.StringField(8)
  instanceId = _messages.StringField(9)
  instanceIndex = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  ip = _messages.StringField(11)
  latency = _messages.StringField(12)
  line = _messages.MessageField('LogLine', 13, repeated=True)
  megaCycles = _messages.IntegerField(14)
  method = _messages.StringField(15)
  moduleId = _messages.StringField(16)
  nickname = _messages.StringField(17)
  pendingTime = _messages.StringField(18)
  referrer = _messages.StringField(19)
  requestId = _messages.StringField(20)
  resource = _messages.StringField(21)
  responseSize = _messages.IntegerField(22)
  sourceReference = _messages.MessageField('SourceReference', 23, repeated=True)
  startTime = _messages.StringField(24)
  status = _messages.IntegerField(25, variant=_messages.Variant.INT32)
  taskName = _messages.StringField(26)
  taskQueueName = _messages.StringField(27)
  traceId = _messages.StringField(28)
  traceSampled = _messages.BooleanField(29)
  urlMapEntry = _messages.StringField(30)
  userAgent = _messages.StringField(31)
  versionId = _messages.StringField(32)
  wasLoadingRequest = _messages.BooleanField(33)


class SourceLocation(_messages.Message):
  r"""Specifies a location in a source code file.

  Fields:
    file: Source file name. Depending on the runtime environment, this might
      be a simple name or a fully-qualified name.
    functionName: Human-readable name of the function or method being invoked,
      with optional context such as the class or package name. This
      information is used in contexts such as the logs viewer, where a file
      and line number are less meaningful. The format can vary by language.
      For example: qual.if.ied.Class.method (Java), dir/package.func (Go),
      function (Python).
    line: Line within the source file.
  """

  file = _messages.StringField(1)
  functionName = _messages.StringField(2)
  line = _messages.IntegerField(3)


class SourceReference(_messages.Message):
  r"""A reference to a particular snapshot of the source tree used to build
  and deploy an application.

  Fields:
    repository: Optional. A URI string identifying the repository. Example:
      "https://github.com/GoogleCloudPlatform/kubernetes.git"
    revisionId: The canonical and persistent identifier of the deployed
      revision. Example (git): "0035781c50ec7aa23385dc841529ce8a4b70db1b"
  """

  repository = _messages.StringField(1)
  revisionId = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class UndeleteBucketRequest(_messages.Message):
  r"""The parameters to UndeleteBucket."""


class WriteLogEntriesRequest(_messages.Message):
  r"""The parameters to WriteLogEntries.

  Messages:
    LabelsValue: Optional. Default labels that are added to the labels field
      of all log entries in entries. If a log entry already has a label with
      the same key as a label in this parameter, then the log entry's label is
      not changed. See LogEntry.

  Fields:
    dryRun: Optional. If true, the request should expect normal response, but
      the entries won't be persisted nor exported. Useful for checking whether
      the logging API endpoints are working properly before sending valuable
      data.
    entries: Required. The log entries to send to Logging. The order of log
      entries in this list does not matter. Values supplied in this method's
      log_name, resource, and labels fields are copied into those log entries
      in this list that do not include values for their corresponding fields.
      For more information, see the LogEntry type.If the timestamp or
      insert_id fields are missing in log entries, then this method supplies
      the current time or a unique identifier, respectively. The supplied
      values are chosen so that, among the log entries that did not supply
      their own values, the entries earlier in the list will sort before the
      entries later in the list. See the entries.list method.Log entries with
      timestamps that are more than the logs retention period in the past or
      more than 24 hours in the future will not be available when calling
      entries.list. However, those log entries can still be exported with
      LogSinks.To improve throughput and to avoid exceeding the quota limit
      for calls to entries.write, you should try to include several log
      entries in this list, rather than calling this method for each
      individual log entry.
    labels: Optional. Default labels that are added to the labels field of all
      log entries in entries. If a log entry already has a label with the same
      key as a label in this parameter, then the log entry's label is not
      changed. See LogEntry.
    logName: Optional. A default log resource name that is assigned to all log
      entries in entries that do not specify a value for log_name:
      "projects/[PROJECT_ID]/logs/[LOG_ID]"
      "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
      "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
      "folders/[FOLDER_ID]/logs/[LOG_ID]" [LOG_ID] must be URL-encoded. For
      example: "projects/my-project-id/logs/syslog" "organizations/1234567890/
      logs/cloudresourcemanager.googleapis.com%2Factivity" The permission
      <code>logging.logEntries.create</code> is needed on each project,
      organization, billing account, or folder that is receiving new log
      entries, whether the resource is specified in <code>logName</code> or in
      an individual log entry.
    partialSuccess: Optional. Whether valid entries should be written even if
      some other entries fail due to INVALID_ARGUMENT or PERMISSION_DENIED
      errors. If any entry is not written, then the response status is the
      error associated with one of the failed entries and the response
      includes error details keyed by the entries' zero-based index in the
      entries.write method.
    resource: Optional. A default monitored resource object that is assigned
      to all log entries in entries that do not specify a value for resource.
      Example: { "type": "gce_instance",   "labels": {     "zone": "us-
      central1-a", "instance_id": "00000000000000000000" }} See LogEntry.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Default labels that are added to the labels field of all log
    entries in entries. If a log entry already has a label with the same key
    as a label in this parameter, then the log entry's label is not changed.
    See LogEntry.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  dryRun = _messages.BooleanField(1)
  entries = _messages.MessageField('LogEntry', 2, repeated=True)
  labels = _messages.MessageField('LabelsValue', 3)
  logName = _messages.StringField(4)
  partialSuccess = _messages.BooleanField(5)
  resource = _messages.MessageField('MonitoredResource', 6)


class WriteLogEntriesResponse(_messages.Message):
  r"""Result returned from WriteLogEntries. empty"""


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
