# -*- coding: utf-8 -*- #
"""Cloud SDK static completion CLI tree."""
# pylint: disable=line-too-long,bad-continuation
STATIC_COMPLETION_CLI_TREE = {
  "commands": {
    "access-context-manager": {
      "commands": {
        "levels": {
          "commands": {
            "conditions": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--level": "value",
                    "--policy": "value"
                  }
                }
              },
              "flags": {}
            },
            "create": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--basic-level-spec": "value",
                "--combine-function": [
                  "and",
                  "or"
                ],
                "--description": "value",
                "--policy": "value",
                "--title": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--policy": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--policy": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--policy": "value",
                "--sort-by": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--basic-level-spec": "value",
                "--combine-function": [
                  "and",
                  "or"
                ],
                "--description": "value",
                "--policy": "value",
                "--title": "value"
              }
            }
          },
          "flags": {}
        },
        "perimeters": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--access-levels": "value",
                "--async": "bool",
                "--description": "value",
                "--perimeter-type": [
                  "bridge",
                  "regular"
                ],
                "--policy": "value",
                "--resources": "value",
                "--restricted-services": "value",
                "--title": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--policy": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--policy": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--policy": "value",
                "--sort-by": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--add-access-levels": "value",
                "--add-resources": "value",
                "--add-restricted-services": "value",
                "--clear-access-levels": "bool",
                "--clear-resources": "bool",
                "--clear-restricted-services": "bool",
                "--description": "value",
                "--policy": "value",
                "--remove-access-levels": "value",
                "--remove-resources": "value",
                "--remove-restricted-services": "value",
                "--set-access-levels": "value",
                "--set-resources": "value",
                "--set-restricted-services": "value",
                "--title": "value",
                "--type": [
                  "bridge",
                  "regular"
                ]
              }
            }
          },
          "flags": {}
        },
        "policies": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--organization": "value",
                "--title": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--organization": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--title": "value"
              }
            }
          },
          "flags": {}
        }
      },
      "flags": {}
    },
    "active-directory": {
      "commands": {
        "domains": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--admin-name": "value",
                "--async": "bool",
                "--authorized-networks": "value",
                "--labels": "value",
                "--region": "value",
                "--reserved-ip-range": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--async": "bool"
              }
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "get-iam-policy": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "reset-admin-password": {
              "commands": {},
              "flags": {}
            },
            "set-iam-policy": {
              "commands": {},
              "flags": {}
            },
            "trusts": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--direction": [
                      "bidirectional",
                      "inbound",
                      "outbound",
                      "trust-direction-unspecified"
                    ],
                    "--handshake-secret": "value",
                    "--selective-authentication": "bool",
                    "--target-dns-ip-addresses": "value",
                    "--target-domain-name": "value",
                    "--type": [
                      "external",
                      "forest",
                      "trust-type-unspecified"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--target-domain-name": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--target-dns-ip-addresses": "value",
                    "--target-domain-name": "value"
                  }
                },
                "validate-state": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--target-domain-name": "value"
                  }
                }
              },
              "flags": {}
            },
            "update": {
              "commands": {},
              "flags": {
                "--add-authorized-networks": "value",
                "--add-region": "value",
                "--async": "bool",
                "--clear-labels": "bool",
                "--remove-authorized-networks": "value",
                "--remove-labels": "value",
                "--remove-region": "value",
                "--update-labels": "value"
              }
            }
          },
          "flags": {}
        },
        "operations": {
          "commands": {
            "cancel": {
              "commands": {},
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            }
          },
          "flags": {}
        }
      },
      "flags": {}
    },
    "ai-platform": {
      "commands": {
        "jobs": {
          "commands": {
            "cancel": {
              "commands": {},
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {
                "--summarize": "bool"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "stream-logs": {
              "commands": {},
              "flags": {
                "--allow-multiline-logs": "bool",
                "--polling-interval": "value",
                "--task-name": "value"
              }
            },
            "submit": {
              "commands": {
                "prediction": {
                  "commands": {},
                  "flags": {
                    "--batch-size": "value",
                    "--data-format": [
                      "text",
                      "tf-record",
                      "tf-record-gzip"
                    ],
                    "--input-paths": "value",
                    "--labels": "value",
                    "--max-worker-count": "value",
                    "--model": "value",
                    "--model-dir": "value",
                    "--output-path": "value",
                    "--region": "value",
                    "--runtime-version": "value",
                    "--signature-name": "value"
                  }
                },
                "training": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--config": "value",
                    "--job-dir": "value",
                    "--labels": "value",
                    "--master-accelerator": "value",
                    "--master-image-uri": "value",
                    "--master-machine-type": "value",
                    "--module-name": "value",
                    "--package-path": "value",
                    "--packages": "value",
                    "--parameter-server-accelerator": "value",
                    "--parameter-server-count": "value",
                    "--parameter-server-image-uri": "value",
                    "--parameter-server-machine-type": "value",
                    "--python-version": "value",
                    "--region": "dynamic",
                    "--runtime-version": "value",
                    "--scale-tier": [
                      "basic",
                      "basic-gpu",
                      "basic-tpu",
                      "custom",
                      "premium-1",
                      "standard-1"
                    ],
                    "--staging-bucket": "value",
                    "--stream-logs": "bool",
                    "--worker-accelerator": "value",
                    "--worker-count": "value",
                    "--worker-image-uri": "value",
                    "--worker-machine-type": "value"
                  }
                }
              },
              "flags": {}
            },
            "update": {
              "commands": {},
              "flags": {
                "--clear-labels": "bool",
                "--remove-labels": "value",
                "--update-labels": "value"
              }
            }
          },
          "flags": {}
        },
        "local": {
          "commands": {
            "predict": {
              "commands": {},
              "flags": {
                "--framework": [
                  "scikit-learn",
                  "tensorflow",
                  "xgboost"
                ],
                "--json-instances": "value",
                "--model-dir": "value",
                "--signature-name": "value",
                "--text-instances": "value"
              }
            },
            "train": {
              "commands": {},
              "flags": {
                "--distributed": "bool",
                "--job-dir": "value",
                "--module-name": "value",
                "--package-path": "value",
                "--parameter-server-count": "value",
                "--start-port": "value",
                "--worker-count": "value"
              }
            }
          },
          "flags": {}
        },
        "models": {
          "commands": {
            "add-iam-policy-binding": {
              "commands": {},
              "flags": {
                "--member": "value",
                "--role": "dynamic"
              }
            },
            "create": {
              "commands": {},
              "flags": {
                "--description": "value",
                "--enable-logging": "bool",
                "--labels": "value",
                "--regions": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "get-iam-policy": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "remove-iam-policy-binding": {
              "commands": {},
              "flags": {
                "--member": "value",
                "--role": "dynamic"
              }
            },
            "set-iam-policy": {
              "commands": {},
              "flags": {}
            },
            "update": {
              "commands": {},
              "flags": {
                "--clear-labels": "bool",
                "--description": "value",
                "--remove-labels": "value",
                "--update-labels": "value"
              }
            }
          },
          "flags": {}
        },
        "operations": {
          "commands": {
            "cancel": {
              "commands": {},
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "wait": {
              "commands": {},
              "flags": {}
            }
          },
          "flags": {}
        },
        "predict": {
          "commands": {},
          "flags": {
            "--json-instances": "value",
            "--model": "value",
            "--signature-name": "value",
            "--text-instances": "value"
          }
        },
        "versions": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--config": "value",
                "--description": "value",
                "--framework": [
                  "scikit-learn",
                  "tensorflow",
                  "xgboost"
                ],
                "--labels": "value",
                "--model": "value",
                "--origin": "value",
                "--python-version": "value",
                "--runtime-version": "value",
                "--staging-bucket": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--model": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--model": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--model": "value",
                "--page-size": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "set-default": {
              "commands": {},
              "flags": {
                "--model": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--clear-labels": "bool",
                "--description": "value",
                "--model": "value",
                "--remove-labels": "value",
                "--update-labels": "value"
              }
            }
          },
          "flags": {}
        }
      },
      "flags": {}
    },
    "alpha": {
      "commands": {
        "access-context-manager": {
          "commands": {
            "levels": {
              "commands": {
                "conditions": {
                  "commands": {
                    "list": {
                      "commands": {},
                      "flags": {
                        "--level": "value",
                        "--policy": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--basic-level-spec": "value",
                    "--combine-function": [
                      "and",
                      "or"
                    ],
                    "--description": "value",
                    "--policy": "value",
                    "--title": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--policy": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--policy": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--policy": "value",
                    "--sort-by": "value"
                  }
                },
                "replace-all": {
                  "commands": {},
                  "flags": {
                    "--source-file": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--basic-level-spec": "value",
                    "--combine-function": [
                      "and",
                      "or"
                    ],
                    "--description": "value",
                    "--policy": "value",
                    "--title": "value"
                  }
                }
              },
              "flags": {}
            },
            "perimeters": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--access-levels": "value",
                    "--async": "bool",
                    "--description": "value",
                    "--enable-vpc-service-restriction": "bool",
                    "--perimeter-type": [
                      "bridge",
                      "regular"
                    ],
                    "--policy": "value",
                    "--resources": "value",
                    "--restricted-services": "value",
                    "--title": "value",
                    "--vpc-allowed-services": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--policy": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--policy": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--policy": "value",
                    "--sort-by": "value"
                  }
                },
                "replace-all": {
                  "commands": {},
                  "flags": {
                    "--source-file": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-access-levels": "value",
                    "--add-resources": "value",
                    "--add-restricted-services": "value",
                    "--add-vpc-allowed-services": "value",
                    "--clear-access-levels": "bool",
                    "--clear-resources": "bool",
                    "--clear-restricted-services": "bool",
                    "--clear-vpc-allowed-services": "bool",
                    "--description": "value",
                    "--enable-vpc-service-restriction": "bool",
                    "--policy": "value",
                    "--remove-access-levels": "value",
                    "--remove-resources": "value",
                    "--remove-restricted-services": "value",
                    "--remove-vpc-allowed-services": "value",
                    "--set-access-levels": "value",
                    "--set-resources": "value",
                    "--set-restricted-services": "value",
                    "--title": "value",
                    "--type": [
                      "bridge",
                      "regular"
                    ]
                  }
                },
                "update-dry-run-config": {
                  "commands": {},
                  "flags": {
                    "--add-access-levels": "value",
                    "--add-resources": "value",
                    "--add-restricted-services": "value",
                    "--add-vpc-allowed-services": "value",
                    "--clear": "bool",
                    "--clear-access-levels": "bool",
                    "--clear-resources": "bool",
                    "--clear-restricted-services": "bool",
                    "--clear-vpc-allowed-services": "bool",
                    "--enable-vpc-service-restriction": "bool",
                    "--policy": "value",
                    "--remove-access-levels": "value",
                    "--remove-resources": "value",
                    "--remove-restricted-services": "value",
                    "--remove-vpc-allowed-services": "value"
                  }
                }
              },
              "flags": {}
            },
            "policies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--organization": "value",
                    "--title": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--title": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "active-directory": {
          "commands": {
            "domains": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--admin-name": "value",
                    "--async": "bool",
                    "--authorized-networks": "value",
                    "--labels": "value",
                    "--region": "value",
                    "--reserved-ip-range": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "reset-admin-password": {
                  "commands": {},
                  "flags": {}
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "trusts": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--direction": [
                          "bidirectional",
                          "inbound",
                          "outbound",
                          "trust-direction-unspecified"
                        ],
                        "--handshake-secret": "value",
                        "--selective-authentication": "bool",
                        "--target-dns-ip-addresses": "value",
                        "--target-domain-name": "value",
                        "--type": [
                          "external",
                          "forest",
                          "trust-type-unspecified"
                        ]
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--target-domain-name": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--target-dns-ip-addresses": "value",
                        "--target-domain-name": "value"
                      }
                    },
                    "validate-state": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--target-domain-name": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-authorized-networks": "value",
                    "--add-region": "value",
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--remove-authorized-networks": "value",
                    "--remove-labels": "value",
                    "--remove-region": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "ai-platform": {
          "commands": {
            "explain": {
              "commands": {},
              "flags": {
                "--json-instances": "value",
                "--model": "value",
                "--text-instances": "value"
              }
            },
            "jobs": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--summarize": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "stream-logs": {
                  "commands": {},
                  "flags": {
                    "--allow-multiline-logs": "bool",
                    "--polling-interval": "value",
                    "--task-name": "value"
                  }
                },
                "submit": {
                  "commands": {
                    "prediction": {
                      "commands": {},
                      "flags": {
                        "--accelerator-count": "value",
                        "--accelerator-type": [
                          "nvidia-tesla-k80",
                          "nvidia-tesla-p100"
                        ],
                        "--batch-size": "value",
                        "--data-format": [
                          "text",
                          "tf-record",
                          "tf-record-gzip"
                        ],
                        "--input-paths": "value",
                        "--labels": "value",
                        "--max-worker-count": "value",
                        "--model": "value",
                        "--model-dir": "value",
                        "--output-path": "value",
                        "--region": "value",
                        "--runtime-version": "value",
                        "--signature-name": "value"
                      }
                    },
                    "training": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--config": "value",
                        "--job-dir": "value",
                        "--labels": "value",
                        "--master-accelerator": "value",
                        "--master-image-uri": "value",
                        "--master-machine-type": "value",
                        "--module-name": "value",
                        "--package-path": "value",
                        "--packages": "value",
                        "--parameter-server-accelerator": "value",
                        "--parameter-server-count": "value",
                        "--parameter-server-image-uri": "value",
                        "--parameter-server-machine-type": "value",
                        "--python-version": "value",
                        "--region": "dynamic",
                        "--runtime-version": "value",
                        "--scale-tier": [
                          "basic",
                          "basic-gpu",
                          "basic-tpu",
                          "custom",
                          "premium-1",
                          "standard-1"
                        ],
                        "--staging-bucket": "value",
                        "--stream-logs": "bool",
                        "--tpu-tf-version": "value",
                        "--worker-accelerator": "value",
                        "--worker-count": "value",
                        "--worker-image-uri": "value",
                        "--worker-machine-type": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "local": {
              "commands": {
                "predict": {
                  "commands": {},
                  "flags": {
                    "--framework": [
                      "scikit-learn",
                      "tensorflow",
                      "xgboost"
                    ],
                    "--json-instances": "value",
                    "--model-dir": "value",
                    "--signature-name": "value",
                    "--text-instances": "value"
                  }
                },
                "train": {
                  "commands": {},
                  "flags": {
                    "--distributed": "bool",
                    "--job-dir": "value",
                    "--module-name": "value",
                    "--package-path": "value",
                    "--parameter-server-count": "value",
                    "--start-port": "value",
                    "--worker-count": "value"
                  }
                }
              },
              "flags": {}
            },
            "locations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "models": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--enable-console-logging": "bool",
                    "--enable-logging": "bool",
                    "--labels": "value",
                    "--regions": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "predict": {
              "commands": {},
              "flags": {
                "--json-instances": "value",
                "--model": "value",
                "--signature-name": "value",
                "--text-instances": "value"
              }
            },
            "versions": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--async": "bool",
                    "--config": "value",
                    "--description": "value",
                    "--explanation-method": [
                      "integrated-gradients",
                      "sampled-shapley"
                    ],
                    "--framework": [
                      "scikit-learn",
                      "tensorflow",
                      "xgboost"
                    ],
                    "--labels": "value",
                    "--machine-type": "value",
                    "--model": "value",
                    "--num-integral-steps": "value",
                    "--num-paths": "value",
                    "--origin": "value",
                    "--package-uris": "value",
                    "--prediction-class": "value",
                    "--python-version": "value",
                    "--runtime-version": "value",
                    "--service-account": "value",
                    "--staging-bucket": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--model": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--model": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--model": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-default": {
                  "commands": {},
                  "flags": {
                    "--model": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--model": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "app": {
          "commands": {
            "domain-mappings": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--certificate-id": "value",
                    "--certificate-management": [
                      "automatic",
                      "manual"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--certificate-id": "value",
                    "--certificate-management": [
                      "automatic",
                      "manual"
                    ],
                    "--no-certificate-id": "bool"
                  }
                }
              },
              "flags": {}
            },
            "ssl-certificates": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--certificate": "value",
                    "--display-name": "value",
                    "--private-key": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--certificate": "value",
                    "--display-name": "value",
                    "--private-key": "value"
                  }
                }
              },
              "flags": {}
            },
            "update": {
              "commands": {},
              "flags": {
                "--split-health-checks": "bool",
                "--use-container-optimized-os": "bool"
              }
            }
          },
          "flags": {}
        },
        "asset": {
          "commands": {
            "analyze-iam-policy": {
              "commands": {},
              "flags": {
                "--expand-groups": "bool",
                "--expand-resources": "bool",
                "--expand-roles": "bool",
                "--full-resource-name": "value",
                "--identity": "value",
                "--organization": "value",
                "--output-group-edges": "bool",
                "--output-partial-result-before-timeout": "bool",
                "--output-resource-edges": "bool",
                "--permissions": "value",
                "--roles": "value"
              }
            },
            "export": {
              "commands": {},
              "flags": {
                "--asset-types": "value",
                "--bigquery-dataset": "dynamic",
                "--bigquery-table": "dynamic",
                "--content-type": [
                  "access-policy",
                  "iam-policy",
                  "org-policy",
                  "resource"
                ],
                "--folder": "value",
                "--organization": "value",
                "--output-bigquery-force": "bool",
                "--output-path": "value",
                "--output-path-prefix": "value",
                "--snapshot-time": "value"
              }
            },
            "feeds": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--asset-names": "value",
                    "--asset-types": "value",
                    "--content-type": [
                      "iam-policy",
                      "resource"
                    ],
                    "--folder": "value",
                    "--organization": "value",
                    "--pubsub-topic": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-asset-names": "value",
                    "--add-asset-types": "value",
                    "--clear-asset-names": "bool",
                    "--clear-asset-types": "bool",
                    "--clear-content-type": "bool",
                    "--content-type": [
                      "iam-policy",
                      "resource"
                    ],
                    "--folder": "value",
                    "--organization": "value",
                    "--pubsub-topic": "value",
                    "--remove-asset-names": "value",
                    "--remove-asset-types": "value"
                  }
                }
              },
              "flags": {}
            },
            "get-history": {
              "commands": {},
              "flags": {
                "--asset-names": "value",
                "--content-type": [
                  "access-policy",
                  "iam-policy",
                  "org-policy",
                  "resource"
                ],
                "--end-time": "value",
                "--organization": "value",
                "--start-time": "value"
              }
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "search-iam-policies": {
              "commands": {},
              "flags": {
                "--page-size": "value",
                "--page-token": "value",
                "--query": "value"
              }
            }
          },
          "flags": {}
        },
        "auth": {
          "commands": {
            "activate-service-account": {
              "commands": {},
              "flags": {
                "--key-file": "value",
                "--password-file": "value",
                "--prompt-for-password": "bool"
              }
            },
            "configure-docker": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--filter-account": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "login": {
              "commands": {},
              "flags": {
                "--activate": "bool",
                "--brief": "bool",
                "--enable-gdrive-access": "bool",
                "--force": "bool",
                "--launch-browser": "bool"
              }
            },
            "print-access-token": {
              "commands": {},
              "flags": {}
            },
            "print-identity-token": {
              "commands": {},
              "flags": {
                "--audiences": "value",
                "--include-email": "bool",
                "--include-license": "bool",
                "--token-format": [
                  "full",
                  "standard"
                ]
              }
            },
            "revoke": {
              "commands": {},
              "flags": {
                "--all": "bool"
              }
            }
          },
          "flags": {}
        },
        "bigtable": {
          "commands": {
            "app-profiles": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--force": "bool",
                    "--instance": "dynamic",
                    "--route-any": "bool",
                    "--route-to": "dynamic",
                    "--transactional-writes": "bool"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--force": "bool",
                    "--instance": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--force": "bool",
                    "--instance": "dynamic",
                    "--route-any": "bool",
                    "--route-to": "dynamic",
                    "--transactional-writes": "bool"
                  }
                }
              },
              "flags": {}
            },
            "clusters": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--instance": "dynamic",
                    "--num-nodes": "value",
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instances": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--instance": "dynamic",
                    "--num-nodes": "value"
                  }
                }
              },
              "flags": {}
            },
            "instances": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster": "dynamic",
                    "--cluster-num-nodes": "value",
                    "--cluster-storage-type": [
                      "hdd",
                      "ssd"
                    ],
                    "--cluster-zone": "value",
                    "--display-name": "value",
                    "--instance-type": [
                      "DEVELOPMENT",
                      "PRODUCTION"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "tables": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--instance": "dynamic",
                        "--member": "value",
                        "--role": "dynamic"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--instance": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--instances": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--instance": "dynamic",
                        "--member": "value",
                        "--role": "dynamic"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--instance": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--display-name": "value"
                  }
                },
                "upgrade": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "billing": {
          "commands": {
            "accounts": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "projects": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "link": {
                      "commands": {},
                      "flags": {
                        "--account-id": "dynamic",
                        "--billing-account": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--billing-account": "dynamic",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "unlink": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "projects": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "link": {
                  "commands": {},
                  "flags": {
                    "--account-id": "dynamic",
                    "--billing-account": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "dynamic",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "unlink": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "bq": {
          "commands": {
            "datasets": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--overwrite": "bool",
                    "--permissions-file": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--remove-tables": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--permissions-file": "value"
                  }
                }
              },
              "flags": {}
            },
            "jobs": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--show-all-users": "bool",
                    "--show-config": "bool",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "tables": {
              "commands": {
                "copy": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination": "dynamic",
                    "--destination-dataset": "dynamic",
                    "--job-id": "value",
                    "--overwrite": "bool",
                    "--source": "dynamic",
                    "--source-dataset": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--dataset": "dynamic",
                    "--description": "value",
                    "--expiration": "value",
                    "--overwrite": "bool",
                    "--schema": "value",
                    "--schema-file": "value",
                    "--use-legacy-sql": "bool",
                    "--view": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--dataset": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--dataset": "dynamic"
                  }
                },
                "insert": {
                  "commands": {},
                  "flags": {
                    "--data": "value",
                    "--dataset": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--dataset": "dynamic",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "show-rows": {
                  "commands": {},
                  "flags": {
                    "--dataset": "dynamic",
                    "--limit": "value",
                    "--start": "value",
                    "--table": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-columns": "value",
                    "--add-columns-file": "value",
                    "--dataset": "dynamic",
                    "--description": "value",
                    "--expiration": "value",
                    "--relax-columns": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "build-artifacts": {
          "commands": {
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "packages": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--repository": "dynamic",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "print-settings": {
              "commands": {
                "gradle": {
                  "commands": {},
                  "flags": {
                    "--repository": "dynamic"
                  }
                },
                "maven": {
                  "commands": {},
                  "flags": {
                    "--repository": "dynamic"
                  }
                },
                "npm": {
                  "commands": {},
                  "flags": {
                    "--repository": "dynamic",
                    "--scope": "value"
                  }
                }
              },
              "flags": {}
            },
            "repositories": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--location": "value",
                    "--repository-format": [
                      "docker",
                      "format-unspecified",
                      "maven",
                      "npm",
                      "pypi"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "versions": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--package": "dynamic",
                    "--page-size": "value",
                    "--repository": "dynamic",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "builds": {
          "commands": {
            "cancel": {
              "commands": {},
              "flags": {}
            },
            "deploy": {
              "commands": {
                "configure": {
                  "commands": {
                    "gke": {
                      "commands": {},
                      "flags": {
                        "--app-name": "value",
                        "--branch-pattern": "value",
                        "--cluster": "value",
                        "--comment-control": "bool",
                        "--config": "value",
                        "--dockerfile": "value",
                        "--expose": "value",
                        "--gcs-config-staging-dir": "value",
                        "--location": "value",
                        "--namespace": "value",
                        "--preview-expiry": "value",
                        "--pull-request-pattern": "value",
                        "--pull-request-preview": "bool",
                        "--repo-name": "value",
                        "--repo-owner": "value",
                        "--repo-type": [
                          "bitbucket_mirrored",
                          "csr",
                          "github",
                          "github_mirrored"
                        ],
                        "--tag-pattern": "value",
                        "--timeout": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "gke": {
                  "commands": {},
                  "flags": {
                    "--app-name": "value",
                    "--app-version": "value",
                    "--async": "bool",
                    "--cluster": "value",
                    "--config": "value",
                    "--expose": "value",
                    "--gcs-staging-dir": "value",
                    "--image": "value",
                    "--location": "value",
                    "--namespace": "value",
                    "--tag": "value",
                    "--tag-default": "bool",
                    "--timeout": "value"
                  }
                }
              },
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--ongoing": "bool",
                "--page-size": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "log": {
              "commands": {},
              "flags": {
                "--stream": "bool"
              }
            },
            "submit": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--config": "value",
                "--disk-size": "value",
                "--gcs-log-dir": "value",
                "--gcs-source-staging-dir": "value",
                "--ignore-file": "value",
                "--machine-type": [
                  "n1-highcpu-32",
                  "n1-highcpu-8"
                ],
                "--no-cache": "bool",
                "--no-source": "bool",
                "--substitutions": "value",
                "--tag": "value",
                "--timeout": "value"
              }
            },
            "triggers": {
              "commands": {
                "create": {
                  "commands": {
                    "cloud-source-repositories": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--repo": "value",
                        "--substitutions": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value"
                      }
                    },
                    "github": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--comment-control": "bool",
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--pull-request-pattern": "value",
                        "--repo-name": "value",
                        "--repo-owner": "value",
                        "--substitutions": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "run": {
                  "commands": {},
                  "flags": {
                    "--branch": "value",
                    "--sha": "value",
                    "--tag": "value"
                  }
                }
              },
              "flags": {}
            },
            "worker-pools": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--config-from-file": "value",
                    "--regions": "value",
                    "--worker-count": "value",
                    "--worker-disk-size": "value",
                    "--worker-machine-type": "value",
                    "--worker-network-name": "value",
                    "--worker-network-project": "value",
                    "--worker-network-subnet": "value",
                    "--worker-tag": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-regions": "value",
                    "--clear-regions": "bool",
                    "--config-from-file": "value",
                    "--remove-regions": "value",
                    "--worker-count": "value",
                    "--worker-disk-size": "value",
                    "--worker-machine-type": "value",
                    "--worker-network-name": "value",
                    "--worker-network-project": "value",
                    "--worker-network-subnet": "value",
                    "--worker-tag": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "cloud-shell": {
          "commands": {
            "get-mount-command": {
              "commands": {},
              "flags": {
                "--boosted": "bool",
                "--force-key-file-overwrite": "bool",
                "--ssh-key-file": "bool"
              }
            },
            "scp": {
              "commands": {},
              "flags": {
                "--boosted": "bool",
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--recurse": "bool",
                "--scp-flag": "value",
                "--ssh-key-file": "bool"
              }
            },
            "ssh": {
              "commands": {},
              "flags": {
                "--boosted": "bool",
                "--command": "value",
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--ssh-flag": "value",
                "--ssh-key-file": "bool"
              }
            }
          },
          "flags": {}
        },
        "composer": {
          "commands": {
            "environments": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--airflow-configs": "value",
                    "--airflow-version": "value",
                    "--async": "bool",
                    "--cluster-ipv4-cidr": "value",
                    "--cluster-secondary-range-name": "value",
                    "--disk-size": "value",
                    "--enable-ip-alias": "bool",
                    "--enable-private-endpoint": "bool",
                    "--enable-private-environment": "bool",
                    "--env-variables": "value",
                    "--image-version": "value",
                    "--labels": "value",
                    "--location": "value",
                    "--machine-type": "value",
                    "--master-ipv4-cidr": "value",
                    "--network": "value",
                    "--node-count": "value",
                    "--oauth-scopes": "value",
                    "--python-version": [
                      "2",
                      "3"
                    ],
                    "--service-account": "value",
                    "--services-ipv4-cidr": "value",
                    "--services-secondary-range-name": "value",
                    "--subnetwork": "value",
                    "--tags": "value",
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--locations": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-upgrades": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "run": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "storage": {
                  "commands": {
                    "dags": {
                      "commands": {
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        },
                        "export": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "import": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "data": {
                      "commands": {
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        },
                        "export": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "import": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "plugins": {
                      "commands": {
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        },
                        "export": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "import": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--airflow-version": "value",
                    "--async": "bool",
                    "--clear-airflow-configs": "bool",
                    "--clear-env-variables": "bool",
                    "--clear-labels": "bool",
                    "--clear-pypi-packages": "bool",
                    "--image-version": "value",
                    "--location": "value",
                    "--node-count": "value",
                    "--remove-airflow-configs": "value",
                    "--remove-env-variables": "value",
                    "--remove-labels": "value",
                    "--remove-pypi-packages": "value",
                    "--update-airflow-configs": "value",
                    "--update-env-variables": "value",
                    "--update-labels": "value",
                    "--update-pypi-package": "value",
                    "--update-pypi-packages-from-file": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--locations": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "compute": {
          "commands": {
            "accelerator-types": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "addresses": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--addresses": "value",
                    "--description": "value",
                    "--global": "bool",
                    "--ip-version": [
                      "IPV4",
                      "IPV6"
                    ],
                    "--network": "value",
                    "--network-tier": "value",
                    "--prefix-length": "value",
                    "--purpose": [
                      "GCE_ENDPOINT",
                      "SHARED_LOADBALANCER_VIP",
                      "VPC_PEERING"
                    ],
                    "--region": "dynamic",
                    "--subnet": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--global": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "backend-buckets": {
              "commands": {
                "add-signed-url-key": {
                  "commands": {},
                  "flags": {
                    "--key-file": "value",
                    "--key-name": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--enable-cdn": "bool",
                    "--gcs-bucket-name": "dynamic",
                    "--signed-url-cache-max-age": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "delete-signed-url-key": {
                  "commands": {},
                  "flags": {
                    "--key-name": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--enable-cdn": "bool",
                    "--gcs-bucket-name": "dynamic",
                    "--signed-url-cache-max-age": "value"
                  }
                }
              },
              "flags": {}
            },
            "backend-services": {
              "commands": {
                "add-backend": {
                  "commands": {},
                  "flags": {
                    "--balancing-mode": [
                      "CONNECTION",
                      "RATE",
                      "UTILIZATION"
                    ],
                    "--capacity-scaler": "value",
                    "--description": "value",
                    "--failover": "bool",
                    "--global": "bool",
                    "--global-network-endpoint-group": "bool",
                    "--instance-group": "dynamic",
                    "--instance-group-region": "dynamic",
                    "--instance-group-zone": "dynamic",
                    "--max-connections": "value",
                    "--max-connections-per-endpoint": "value",
                    "--max-connections-per-instance": "value",
                    "--max-rate": "value",
                    "--max-rate-per-endpoint": "value",
                    "--max-rate-per-instance": "value",
                    "--max-utilization": "value",
                    "--network-endpoint-group": "value",
                    "--network-endpoint-group-zone": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "add-signed-url-key": {
                  "commands": {},
                  "flags": {
                    "--key-file": "value",
                    "--key-name": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--affinity-cookie-ttl": "value",
                    "--cache-key-include-host": "bool",
                    "--cache-key-include-protocol": "bool",
                    "--cache-key-include-query-string": "bool",
                    "--cache-key-query-string-blacklist": "value",
                    "--cache-key-query-string-whitelist": "value",
                    "--connection-drain-on-failover": "bool",
                    "--connection-draining-timeout": "value",
                    "--custom-request-header": "value",
                    "--description": "value",
                    "--drop-traffic-if-unhealthy": "bool",
                    "--enable-cdn": "bool",
                    "--enable-logging": "bool",
                    "--failover-ratio": "value",
                    "--global": "bool",
                    "--global-health-checks": "bool",
                    "--health-checks": "dynamic",
                    "--health-checks-region": "dynamic",
                    "--http-health-checks": "dynamic",
                    "--https-health-checks": "dynamic",
                    "--iap": "value",
                    "--load-balancing-scheme": [
                      "EXTERNAL",
                      "INTERNAL",
                      "INTERNAL_MANAGED",
                      "INTERNAL_SELF_MANAGED"
                    ],
                    "--logging-sample-rate": "value",
                    "--network": "value",
                    "--port-name": "value",
                    "--protocol": "value",
                    "--region": "dynamic",
                    "--session-affinity": [
                      "CLIENT_IP",
                      "CLIENT_IP_PORT_PROTO",
                      "CLIENT_IP_PROTO",
                      "GENERATED_COOKIE",
                      "HEADER_FIELD",
                      "HTTP_COOKIE",
                      "NONE"
                    ],
                    "--signed-url-cache-max-age": "value",
                    "--timeout": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "delete-signed-url-key": {
                  "commands": {},
                  "flags": {
                    "--key-name": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "edit": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "get-health": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-backend": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--instance-group": "dynamic",
                    "--instance-group-region": "dynamic",
                    "--instance-group-zone": "dynamic",
                    "--network-endpoint-group": "value",
                    "--network-endpoint-group-zone": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "set-security-policy": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--security-policy": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--affinity-cookie-ttl": "value",
                    "--cache-key-include-host": "bool",
                    "--cache-key-include-protocol": "bool",
                    "--cache-key-include-query-string": "bool",
                    "--cache-key-query-string-blacklist": "value",
                    "--cache-key-query-string-whitelist": "value",
                    "--connection-drain-on-failover": "bool",
                    "--connection-draining-timeout": "value",
                    "--custom-request-header": "value",
                    "--description": "value",
                    "--drop-traffic-if-unhealthy": "bool",
                    "--enable-cdn": "bool",
                    "--enable-logging": "bool",
                    "--failover-ratio": "value",
                    "--global": "bool",
                    "--global-health-checks": "bool",
                    "--health-checks": "dynamic",
                    "--health-checks-region": "dynamic",
                    "--http-health-checks": "dynamic",
                    "--https-health-checks": "dynamic",
                    "--iap": "value",
                    "--logging-sample-rate": "value",
                    "--no-custom-request-headers": "bool",
                    "--port-name": "value",
                    "--protocol": "value",
                    "--region": "dynamic",
                    "--security-policy": "dynamic",
                    "--session-affinity": [
                      "CLIENT_IP",
                      "CLIENT_IP_PORT_PROTO",
                      "CLIENT_IP_PROTO",
                      "GENERATED_COOKIE",
                      "HEADER_FIELD",
                      "HTTP_COOKIE",
                      "NONE"
                    ],
                    "--signed-url-cache-max-age": "value",
                    "--timeout": "value"
                  }
                },
                "update-backend": {
                  "commands": {},
                  "flags": {
                    "--balancing-mode": [
                      "CONNECTION",
                      "RATE",
                      "UTILIZATION"
                    ],
                    "--capacity-scaler": "value",
                    "--description": "value",
                    "--failover": "bool",
                    "--global": "bool",
                    "--instance-group": "dynamic",
                    "--instance-group-region": "dynamic",
                    "--instance-group-zone": "dynamic",
                    "--max-connections": "value",
                    "--max-connections-per-endpoint": "value",
                    "--max-connections-per-instance": "value",
                    "--max-rate": "value",
                    "--max-rate-per-endpoint": "value",
                    "--max-rate-per-instance": "value",
                    "--max-utilization": "value",
                    "--network-endpoint-group": "value",
                    "--network-endpoint-group-zone": "dynamic",
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "commitments": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--local-ssd": "value",
                    "--machine-type": "value",
                    "--min-cpu-platform": "value",
                    "--plan": [
                      "12-month",
                      "36-month"
                    ],
                    "--region": "dynamic",
                    "--require-specific-reservation": "bool",
                    "--reservation": "dynamic",
                    "--reservation-zone": "dynamic",
                    "--reservations-from-file": "value",
                    "--resources": "value",
                    "--resources-accelerator": "value",
                    "--type": [
                      "compute-optimized",
                      "general-purpose",
                      "general-purpose-e2",
                      "general-purpose-n2",
                      "general-purpose-n2d",
                      "memory-optimized"
                    ],
                    "--vm-count": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update-reservations": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--local-ssd": "value",
                    "--machine-type": "value",
                    "--min-cpu-platform": "value",
                    "--region": "dynamic",
                    "--require-specific-reservation": "bool",
                    "--reservation": "dynamic",
                    "--reservation-zone": "dynamic",
                    "--reservations-from-file": "value",
                    "--vm-count": "value"
                  }
                }
              },
              "flags": {}
            },
            "config-ssh": {
              "commands": {},
              "flags": {
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--remove": "bool",
                "--ssh-config-file": "value",
                "--ssh-key-file": "value"
              }
            },
            "connect-to-serial-port": {
              "commands": {},
              "flags": {
                "--dry-run": "bool",
                "--extra-args": "value",
                "--force-key-file-overwrite": "bool",
                "--port": "value",
                "--ssh-key-expiration": "value",
                "--ssh-key-expire-after": "value",
                "--ssh-key-file": "value",
                "--zone": "dynamic"
              }
            },
            "copy-files": {
              "commands": {},
              "flags": {
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--plain": "bool",
                "--ssh-key-expiration": "value",
                "--ssh-key-expire-after": "value",
                "--ssh-key-file": "value",
                "--strict-host-key-checking": [
                  "ask",
                  "no",
                  "yes"
                ],
                "--zone": "value"
              }
            },
            "diagnose": {
              "commands": {
                "export-logs": {
                  "commands": {},
                  "flags": {
                    "--collect-process-traces": "bool",
                    "--zone": "dynamic"
                  }
                },
                "routes": {
                  "commands": {},
                  "flags": {
                    "--container": "value",
                    "--dry-run": "bool",
                    "--external-route-ip": "value",
                    "--force-key-file-overwrite": "bool",
                    "--plain": "bool",
                    "--regexp": "value",
                    "--reverse-traceroute": "bool",
                    "--ssh-flag": "value",
                    "--ssh-key-expiration": "value",
                    "--ssh-key-expire-after": "value",
                    "--ssh-key-file": "value",
                    "--strict-host-key-checking": [
                      "ask",
                      "no",
                      "yes"
                    ],
                    "--user": "value",
                    "--zones": "dynamic"
                  }
                },
                "sosreport": {
                  "commands": {},
                  "flags": {
                    "--download-dir": "value",
                    "--dry-run": "bool",
                    "--force-key-file-overwrite": "bool",
                    "--plain": "bool",
                    "--python-path": "value",
                    "--reports-path": "value",
                    "--sosreport-install-path": "value",
                    "--ssh-flag": "value",
                    "--ssh-key-expiration": "value",
                    "--ssh-key-expire-after": "value",
                    "--ssh-key-file": "value",
                    "--strict-host-key-checking": [
                      "ask",
                      "no",
                      "yes"
                    ],
                    "--user": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "disk-types": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                }
              },
              "flags": {}
            },
            "disks": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--labels": "value",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "add-resource-policies": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--resource-policies": "value",
                    "--zone": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--csek-key-file": "value",
                    "--description": "value",
                    "--erase-windows-vss-signature": "bool",
                    "--guest-os-features": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--licenses": "value",
                    "--multi-writer": "bool",
                    "--physical-block-size": [
                      "16384",
                      "4096"
                    ],
                    "--region": "dynamic",
                    "--replica-zones": "value",
                    "--require-csek-key-create": "bool",
                    "--resource-policies": "value",
                    "--size": "value",
                    "--source-disk": "dynamic",
                    "--source-disk-zone": "dynamic",
                    "--source-snapshot": "dynamic",
                    "--type": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                },
                "move": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination-zone": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "remove-labels": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--labels": "value",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "remove-resource-policies": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--resource-policies": "value",
                    "--zone": "dynamic"
                  }
                },
                "resize": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--size": "value",
                    "--zone": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "snapshot": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--csek-key-file": "value",
                    "--description": "value",
                    "--guest-flush": "bool",
                    "--labels": "value",
                    "--region": "dynamic",
                    "--snapshot-names": "value",
                    "--storage-location": "value",
                    "--zone": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "external-vpn-gateways": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--interfaces": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "firewall-rules": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--action": [
                      "ALLOW",
                      "DENY"
                    ],
                    "--allow": "value",
                    "--description": "value",
                    "--destination-ranges": "value",
                    "--direction": [
                      "EGRESS",
                      "IN",
                      "INGRESS",
                      "OUT"
                    ],
                    "--disabled": "bool",
                    "--enable-logging": "bool",
                    "--logging-metadata": [
                      "exclude-all",
                      "include-all"
                    ],
                    "--network": "value",
                    "--priority": "value",
                    "--rules": "value",
                    "--source-ranges": "value",
                    "--source-service-accounts": "value",
                    "--source-tags": "value",
                    "--target-service-accounts": "value",
                    "--target-tags": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--allow": "value",
                    "--description": "value",
                    "--destination-ranges": "value",
                    "--disabled": "bool",
                    "--enable-logging": "bool",
                    "--logging-metadata": [
                      "exclude-all",
                      "include-all"
                    ],
                    "--priority": "value",
                    "--rules": "value",
                    "--source-ranges": "value",
                    "--source-service-accounts": "value",
                    "--source-tags": "value",
                    "--target-service-accounts": "value",
                    "--target-tags": "value"
                  }
                }
              },
              "flags": {}
            },
            "forwarding-rules": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--address": "dynamic",
                    "--address-region": "dynamic",
                    "--allow-global-access": "bool",
                    "--backend-service": "value",
                    "--backend-service-region": "dynamic",
                    "--description": "value",
                    "--global": "bool",
                    "--global-address": "bool",
                    "--global-backend-service": "bool",
                    "--global-target-http-proxy": "bool",
                    "--global-target-https-proxy": "bool",
                    "--ip-protocol": [
                      "AH",
                      "ESP",
                      "ICMP",
                      "SCTP",
                      "TCP",
                      "UDP"
                    ],
                    "--ip-version": [
                      "IPV4",
                      "IPV6"
                    ],
                    "--is-mirroring-collector": "bool",
                    "--load-balancing-scheme": [
                      "EXTERNAL",
                      "INTERNAL",
                      "INTERNAL_MANAGED",
                      "INTERNAL_SELF_MANAGED"
                    ],
                    "--network": "value",
                    "--network-tier": "value",
                    "--port-range": "value",
                    "--ports": "value",
                    "--region": "dynamic",
                    "--service-label": "value",
                    "--subnet": "value",
                    "--subnet-region": "dynamic",
                    "--target-http-proxy": "value",
                    "--target-http-proxy-region": "dynamic",
                    "--target-https-proxy": "value",
                    "--target-https-proxy-region": "dynamic",
                    "--target-instance": "value",
                    "--target-instance-zone": "dynamic",
                    "--target-pool": "value",
                    "--target-pool-region": "dynamic",
                    "--target-ssl-proxy": "value",
                    "--target-tcp-proxy": "value",
                    "--target-vpn-gateway": "value",
                    "--target-vpn-gateway-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-target": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "value",
                    "--backend-service-region": "dynamic",
                    "--global": "bool",
                    "--global-backend-service": "bool",
                    "--global-target-http-proxy": "bool",
                    "--global-target-https-proxy": "bool",
                    "--load-balancing-scheme": [
                      "EXTERNAL",
                      "INTERNAL",
                      "INTERNAL_MANAGED",
                      "INTERNAL_SELF_MANAGED"
                    ],
                    "--network": "value",
                    "--region": "dynamic",
                    "--subnet": "value",
                    "--subnet-region": "dynamic",
                    "--target-http-proxy": "value",
                    "--target-http-proxy-region": "dynamic",
                    "--target-https-proxy": "value",
                    "--target-https-proxy-region": "dynamic",
                    "--target-instance": "value",
                    "--target-instance-zone": "dynamic",
                    "--target-pool": "value",
                    "--target-pool-region": "dynamic",
                    "--target-ssl-proxy": "value",
                    "--target-tcp-proxy": "value",
                    "--target-vpn-gateway": "value",
                    "--target-vpn-gateway-region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--allow-global-access": "bool",
                    "--clear-labels": "bool",
                    "--global": "bool",
                    "--network-tier": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "health-checks": {
              "commands": {
                "create": {
                  "commands": {
                    "http": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "http2": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "https": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "ssl": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "tcp": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--protocol": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {
                    "http": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "http2": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "https": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "ssl": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "tcp": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "http-health-checks": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--check-interval": "value",
                    "--description": "value",
                    "--healthy-threshold": "value",
                    "--host": "value",
                    "--port": "value",
                    "--request-path": "value",
                    "--timeout": "value",
                    "--unhealthy-threshold": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--check-interval": "value",
                    "--description": "value",
                    "--healthy-threshold": "value",
                    "--host": "value",
                    "--port": "value",
                    "--request-path": "value",
                    "--timeout": "value",
                    "--unhealthy-threshold": "value"
                  }
                }
              },
              "flags": {}
            },
            "https-health-checks": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--check-interval": "value",
                    "--description": "value",
                    "--healthy-threshold": "value",
                    "--host": "value",
                    "--port": "value",
                    "--request-path": "value",
                    "--timeout": "value",
                    "--unhealthy-threshold": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--check-interval": "value",
                    "--description": "value",
                    "--healthy-threshold": "value",
                    "--host": "value",
                    "--port": "value",
                    "--request-path": "value",
                    "--timeout": "value",
                    "--unhealthy-threshold": "value"
                  }
                }
              },
              "flags": {}
            },
            "images": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--labels": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--csek-key-file": "value",
                    "--description": "value",
                    "--family": "value",
                    "--forbidden-database-file": "value",
                    "--force": "bool",
                    "--force-create": "bool",
                    "--guest-os-features": "value",
                    "--key-exchange-key-file": "value",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--licenses": "value",
                    "--platform-key-file": "value",
                    "--require-csek-key-create": "bool",
                    "--signature-database-file": "value",
                    "--source-disk": "dynamic",
                    "--source-disk-zone": "dynamic",
                    "--source-image": "value",
                    "--source-image-family": "value",
                    "--source-image-project": "value",
                    "--source-snapshot": "dynamic",
                    "--source-uri": "value",
                    "--storage-location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "deprecate": {
                  "commands": {},
                  "flags": {
                    "--delete-in": "value",
                    "--delete-on": "value",
                    "--deprecate-in": "value",
                    "--deprecate-on": "value",
                    "--obsolete-in": "value",
                    "--obsolete-on": "value",
                    "--replacement": "dynamic",
                    "--state": [
                      "ACTIVE",
                      "DELETED",
                      "DEPRECATED",
                      "OBSOLETE"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "describe-from-family": {
                  "commands": {},
                  "flags": {}
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination-uri": "value",
                    "--export-format": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--log-location": "value",
                    "--network": "value",
                    "--subnet": "value",
                    "--timeout": "value",
                    "--zone": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--data-disk": "bool",
                    "--description": "value",
                    "--family": "value",
                    "--guest-environment": "bool",
                    "--log-location": "value",
                    "--network": "value",
                    "--os": [
                      "centos-6",
                      "centos-7",
                      "debian-8",
                      "debian-9",
                      "rhel-6",
                      "rhel-6-byol",
                      "rhel-7",
                      "rhel-7-byol",
                      "ubuntu-1404",
                      "ubuntu-1604",
                      "windows-10-x64-byol",
                      "windows-10-x86-byol",
                      "windows-2008r2",
                      "windows-2008r2-byol",
                      "windows-2012",
                      "windows-2012-byol",
                      "windows-2012r2",
                      "windows-2012r2-byol",
                      "windows-2016",
                      "windows-2016-byol",
                      "windows-2019",
                      "windows-2019-byol",
                      "windows-7-x64-byol",
                      "windows-7-x86-byol",
                      "windows-8-x64-byol",
                      "windows-8-x86-byol"
                    ],
                    "--source-file": "value",
                    "--source-image": "dynamic",
                    "--storage-location": "value",
                    "--subnet": "value",
                    "--timeout": "value",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--preview-images": "bool",
                    "--regexp": "value",
                    "--show-deprecated": "bool",
                    "--sort-by": "value",
                    "--standard-images": "bool",
                    "--uri": "bool"
                  }
                },
                "packages": {
                  "commands": {
                    "diff": {
                      "commands": {},
                      "flags": {
                        "--base-image": "dynamic",
                        "--base-project": "dynamic",
                        "--diff-image": "dynamic",
                        "--diff-project": "dynamic",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--show-added-packages": "bool",
                        "--show-removed-packages": "bool",
                        "--show-updated-packages": "bool",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--image": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "remove-labels": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--labels": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                },
                "vulnerabilities": {
                  "commands": {
                    "describe-note": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--image": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "instance-groups": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "get-named-ports": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                },
                "list-instances": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "dynamic"
                  }
                },
                "managed": {
                  "commands": {
                    "abandon-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--base-instance-name": "value",
                        "--description": "value",
                        "--health-check": "dynamic",
                        "--http-health-check": "value",
                        "--https-health-check": "value",
                        "--initial-delay": "value",
                        "--instance-redistribution-type": [
                          "NONE",
                          "PROACTIVE"
                        ],
                        "--region": "dynamic",
                        "--size": "value",
                        "--stateful-disk": "value",
                        "--target-pool": "value",
                        "--template": "value",
                        "--zone": "dynamic",
                        "--zones": "dynamic"
                      }
                    },
                    "create-instance": {
                      "commands": {},
                      "flags": {
                        "--instance": "value",
                        "--region": "dynamic",
                        "--stateful-disk": "value",
                        "--stateful-metadata": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "delete-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "export-autoscaling": {
                      "commands": {},
                      "flags": {
                        "--autoscaling-file": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "get-named-ports": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "dynamic",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "instance-configs": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--instance": "value",
                            "--region": "dynamic",
                            "--stateful-disk": "value",
                            "--stateful-metadata": "value",
                            "--update-instance": "bool",
                            "--zone": "dynamic"
                          }
                        },
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--instances": "value",
                            "--region": "dynamic",
                            "--update-instance": "bool",
                            "--zone": "dynamic"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--region": "dynamic",
                            "--sort-by": "value",
                            "--zone": "dynamic"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--instance": "value",
                            "--region": "dynamic",
                            "--remove-stateful-disks": "value",
                            "--remove-stateful-metadata": "value",
                            "--update-instance": "bool",
                            "--update-stateful-disk": "value",
                            "--update-stateful-metadata": "value",
                            "--zone": "dynamic"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--regions": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zones": "value"
                      }
                    },
                    "list-errors": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "dynamic",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "list-instances": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "dynamic",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "recreate-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "resize": {
                      "commands": {},
                      "flags": {
                        "--creation-retries": "bool",
                        "--region": "dynamic",
                        "--size": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "rolling-action": {
                      "commands": {
                        "replace": {
                          "commands": {},
                          "flags": {
                            "--max-surge": "value",
                            "--max-unavailable": "value",
                            "--min-ready": "value",
                            "--region": "dynamic",
                            "--replacement-method": [
                              "recreate",
                              "substitute"
                            ],
                            "--zone": "dynamic"
                          }
                        },
                        "restart": {
                          "commands": {},
                          "flags": {
                            "--max-unavailable": "value",
                            "--min-ready": "value",
                            "--region": "dynamic",
                            "--zone": "dynamic"
                          }
                        },
                        "start-update": {
                          "commands": {},
                          "flags": {
                            "--canary-version": "value",
                            "--force": "bool",
                            "--max-surge": "value",
                            "--max-unavailable": "value",
                            "--min-ready": "value",
                            "--region": "dynamic",
                            "--replacement-method": [
                              "recreate",
                              "substitute"
                            ],
                            "--type": [
                              "opportunistic",
                              "proactive"
                            ],
                            "--zone": "dynamic"
                          }
                        },
                        "stop-proactive-update": {
                          "commands": {},
                          "flags": {
                            "--region": "dynamic",
                            "--zone": "dynamic"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "set-autohealing": {
                      "commands": {},
                      "flags": {
                        "--health-check": "dynamic",
                        "--http-health-check": "value",
                        "--https-health-check": "value",
                        "--initial-delay": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "set-autoscaling": {
                      "commands": {},
                      "flags": {
                        "--autoscaling-file": "value",
                        "--cool-down-period": "value",
                        "--custom-metric-utilization": "value",
                        "--description": "value",
                        "--max-num-replicas": "value",
                        "--min-num-replicas": "value",
                        "--mode": [
                          "off",
                          "on",
                          "only-up"
                        ],
                        "--queue-scaling-acceptable-backlog-per-instance": "value",
                        "--queue-scaling-cloud-pub-sub": "value",
                        "--queue-scaling-single-worker-throughput": "value",
                        "--region": "dynamic",
                        "--remove-stackdriver-metric": "value",
                        "--scale-based-on-cpu": "bool",
                        "--scale-based-on-load-balancing": "bool",
                        "--scale-down-control": "value",
                        "--stackdriver-metric-filter": "value",
                        "--stackdriver-metric-single-instance-assignment": "value",
                        "--stackdriver-metric-utilization-target": "value",
                        "--stackdriver-metric-utilization-target-type": [
                          "delta-per-minute",
                          "delta-per-second",
                          "gauge"
                        ],
                        "--target-cpu-utilization": "value",
                        "--target-load-balancing-utilization": "value",
                        "--update-stackdriver-metric": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "set-instance-template": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--template": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "set-named-ports": {
                      "commands": {},
                      "flags": {
                        "--named-ports": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "set-target-pools": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--target-pools": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "stop-autoscaling": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--clear-autohealing": "bool",
                        "--health-check": "dynamic",
                        "--http-health-check": "value",
                        "--https-health-check": "value",
                        "--initial-delay": "value",
                        "--instance-redistribution-type": [
                          "NONE",
                          "PROACTIVE"
                        ],
                        "--region": "dynamic",
                        "--remove-stateful-disks": "value",
                        "--update-stateful-disk": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "update-autoscaling": {
                      "commands": {},
                      "flags": {
                        "--mode": [
                          "off",
                          "on",
                          "only-up"
                        ],
                        "--region": "dynamic",
                        "--scale-down-control": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "update-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--minimal-action": [
                          "none",
                          "refresh",
                          "replace",
                          "restart"
                        ],
                        "--most-disruptive-allowed-action": [
                          "none",
                          "refresh",
                          "replace",
                          "restart"
                        ],
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "wait-until": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--stable": "bool",
                        "--timeout": "value",
                        "--version-target-reached": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "wait-until-stable": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--timeout": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "set-named-ports": {
                  "commands": {},
                  "flags": {
                    "--named-ports": "value",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "unmanaged": {
                  "commands": {
                    "add-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--description": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "get-named-ports": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "dynamic",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zones": "dynamic"
                      }
                    },
                    "list-instances": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "remove-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "set-named-ports": {
                      "commands": {},
                      "flags": {
                        "--named-ports": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "instance-templates": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--address": "value",
                    "--boot-disk-auto-delete": "bool",
                    "--boot-disk-device-name": "value",
                    "--boot-disk-kms-key": "dynamic",
                    "--boot-disk-kms-keyring": "dynamic",
                    "--boot-disk-kms-location": "dynamic",
                    "--boot-disk-kms-project": "dynamic",
                    "--boot-disk-size": "value",
                    "--boot-disk-type": "value",
                    "--can-ip-forward": "bool",
                    "--confidential-compute": "bool",
                    "--configure-disk": "value",
                    "--create-disk": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--description": "value",
                    "--disk": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--labels": "value",
                    "--local-nvdimm": "value",
                    "--local-ssd": "value",
                    "--machine-type": "dynamic",
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--min-node-cpus": "value",
                    "--network": "value",
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--node": "value",
                    "--node-affinity-file": "value",
                    "--node-group": "value",
                    "--on-host-maintenance": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--preemptible": "bool",
                    "--private-network-ip": "value",
                    "--region": "dynamic",
                    "--reservation": "value",
                    "--reservation-affinity": [
                      "any",
                      "none",
                      "specific"
                    ],
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--source-instance": "dynamic",
                    "--source-instance-zone": "dynamic",
                    "--subnet": "value",
                    "--tags": "value"
                  }
                },
                "create-with-container": {
                  "commands": {},
                  "flags": {
                    "--address": "value",
                    "--boot-disk-auto-delete": "bool",
                    "--boot-disk-device-name": "value",
                    "--boot-disk-size": "value",
                    "--boot-disk-type": "value",
                    "--can-ip-forward": "bool",
                    "--container-arg": "value",
                    "--container-command": "value",
                    "--container-env": "value",
                    "--container-env-file": "value",
                    "--container-image": "value",
                    "--container-mount-disk": "value",
                    "--container-mount-host-path": "value",
                    "--container-mount-tmpfs": "value",
                    "--container-privileged": "bool",
                    "--container-restart-policy": [
                      "always",
                      "never",
                      "on-failure"
                    ],
                    "--container-stdin": "bool",
                    "--container-tty": "bool",
                    "--create-disk": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--description": "value",
                    "--disk": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--labels": "value",
                    "--local-nvdimm": "value",
                    "--local-ssd": "value",
                    "--machine-type": "dynamic",
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--network": "value",
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--on-host-maintenance": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--preemptible": "bool",
                    "--private-network-ip": "value",
                    "--region": "dynamic",
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--subnet": "value",
                    "--tags": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "instances": {
              "commands": {
                "add-access-config": {
                  "commands": {},
                  "flags": {
                    "--access-config-name": "value",
                    "--address": "value",
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-public-dns": "bool",
                    "--no-public-ptr": "bool",
                    "--no-public-ptr-domain": "bool",
                    "--public-dns": "bool",
                    "--public-ptr": "bool",
                    "--public-ptr-domain": "value",
                    "--zone": "dynamic"
                  }
                },
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--labels": "value",
                    "--zone": "dynamic"
                  }
                },
                "add-metadata": {
                  "commands": {},
                  "flags": {
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--zone": "dynamic"
                  }
                },
                "add-resource-policies": {
                  "commands": {},
                  "flags": {
                    "--resource-policies": "value",
                    "--zone": "dynamic"
                  }
                },
                "add-tags": {
                  "commands": {},
                  "flags": {
                    "--tags": "value",
                    "--zone": "dynamic"
                  }
                },
                "attach-disk": {
                  "commands": {},
                  "flags": {
                    "--boot": "bool",
                    "--csek-key-file": "value",
                    "--device-name": "value",
                    "--disk": "value",
                    "--disk-scope": [
                      "regional",
                      "zonal"
                    ],
                    "--force-attach": "bool",
                    "--mode": [
                      "ro",
                      "rw"
                    ],
                    "--zone": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--address": "value",
                    "--async": "bool",
                    "--boot-disk-auto-delete": "bool",
                    "--boot-disk-device-name": "value",
                    "--boot-disk-kms-key": "dynamic",
                    "--boot-disk-kms-keyring": "dynamic",
                    "--boot-disk-kms-location": "dynamic",
                    "--boot-disk-kms-project": "dynamic",
                    "--boot-disk-size": "value",
                    "--boot-disk-type": "value",
                    "--can-ip-forward": "bool",
                    "--confidential-compute": "bool",
                    "--create-disk": "value",
                    "--csek-key-file": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--deletion-protection": "bool",
                    "--description": "value",
                    "--disk": "value",
                    "--enable-display-device": "bool",
                    "--erase-windows-vss-signature": "bool",
                    "--hostname": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--labels": "value",
                    "--local-nvdimm": "value",
                    "--local-ssd": "value",
                    "--machine-type": "dynamic",
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--min-node-cpus": "value",
                    "--network": "value",
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-public-dns": "bool",
                    "--no-public-ptr": "bool",
                    "--no-public-ptr-domain": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--node": "value",
                    "--node-affinity-file": "value",
                    "--node-group": "value",
                    "--on-host-maintenance": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--preemptible": "bool",
                    "--private-network-ip": "value",
                    "--public-dns": "bool",
                    "--public-ptr": "bool",
                    "--public-ptr-domain": "value",
                    "--require-csek-key-create": "bool",
                    "--reservation": "value",
                    "--reservation-affinity": [
                      "any",
                      "none",
                      "specific"
                    ],
                    "--resource-policies": "value",
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--source-instance-template": "dynamic",
                    "--source-machine-image": "dynamic",
                    "--source-machine-image-csek-key-file": "value",
                    "--source-snapshot": "value",
                    "--subnet": "value",
                    "--tags": "value",
                    "--zone": "dynamic"
                  }
                },
                "create-with-container": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--address": "value",
                    "--boot-disk-auto-delete": "bool",
                    "--boot-disk-device-name": "value",
                    "--boot-disk-size": "value",
                    "--boot-disk-type": "value",
                    "--can-ip-forward": "bool",
                    "--container-arg": "value",
                    "--container-command": "value",
                    "--container-env": "value",
                    "--container-env-file": "value",
                    "--container-image": "value",
                    "--container-mount-disk": "value",
                    "--container-mount-host-path": "value",
                    "--container-mount-tmpfs": "value",
                    "--container-privileged": "bool",
                    "--container-restart-policy": [
                      "always",
                      "never",
                      "on-failure"
                    ],
                    "--container-stdin": "bool",
                    "--container-tty": "bool",
                    "--create-disk": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--description": "value",
                    "--disk": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--labels": "value",
                    "--local-nvdimm": "value",
                    "--local-ssd": "value",
                    "--machine-type": "dynamic",
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--network": "value",
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-public-dns": "bool",
                    "--no-public-ptr": "bool",
                    "--no-public-ptr-domain": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--on-host-maintenance": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--preemptible": "bool",
                    "--private-network-ip": "value",
                    "--public-dns": "bool",
                    "--public-ptr": "bool",
                    "--public-ptr-domain": "value",
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--source-instance-template": "dynamic",
                    "--subnet": "value",
                    "--tags": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--delete-disks": [
                      "all",
                      "boot",
                      "data"
                    ],
                    "--keep-disks": [
                      "all",
                      "boot",
                      "data"
                    ],
                    "--zone": "dynamic"
                  }
                },
                "delete-access-config": {
                  "commands": {},
                  "flags": {
                    "--access-config-name": "value",
                    "--network-interface": "value",
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--guest-attributes": "value",
                    "--zone": "dynamic"
                  }
                },
                "detach-disk": {
                  "commands": {},
                  "flags": {
                    "--device-name": "value",
                    "--disk": "value",
                    "--disk-scope": [
                      "regional",
                      "zonal"
                    ],
                    "--zone": "dynamic"
                  }
                },
                "get-guest-attributes": {
                  "commands": {},
                  "flags": {
                    "--query-path": "value",
                    "--zone": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--zone": "value"
                  }
                },
                "get-serial-port-output": {
                  "commands": {},
                  "flags": {
                    "--port": "value",
                    "--start": "value",
                    "--zone": "dynamic"
                  }
                },
                "get-shielded-identity": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--can-ip-forward": "bool",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--deletion-protection": "bool",
                    "--description": "value",
                    "--guest-environment": "bool",
                    "--labels": "value",
                    "--machine-type": "dynamic",
                    "--network": "value",
                    "--network-tier": "value",
                    "--node": "value",
                    "--node-affinity-file": "value",
                    "--node-group": "value",
                    "--os": [
                      "centos-6",
                      "centos-7",
                      "debian-8",
                      "debian-9",
                      "rhel-6",
                      "rhel-6-byol",
                      "rhel-7",
                      "rhel-7-byol",
                      "ubuntu-1404",
                      "ubuntu-1604",
                      "windows-10-x64-byol",
                      "windows-10-x86-byol",
                      "windows-2008r2",
                      "windows-2008r2-byol",
                      "windows-2012",
                      "windows-2012-byol",
                      "windows-2012r2",
                      "windows-2012r2-byol",
                      "windows-2016",
                      "windows-2016-byol",
                      "windows-2019",
                      "windows-2019-byol",
                      "windows-7-x64-byol",
                      "windows-7-x86-byol",
                      "windows-8-x64-byol",
                      "windows-8-x86-byol"
                    ],
                    "--private-network-ip": "value",
                    "--restart-on-failure": "bool",
                    "--source-uri": "value",
                    "--subnet": "value",
                    "--tags": "value",
                    "--timeout": "value",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "dynamic"
                  }
                },
                "move": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination-zone": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "network-interfaces": {
                  "commands": {
                    "get-effective-firewalls": {
                      "commands": {},
                      "flags": {
                        "--network-interface": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--aliases": "value",
                        "--network-interface": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "os-inventory": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "list-instances": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--inventory-filter": "value",
                        "--kernel-version": "value",
                        "--limit": "value",
                        "--os-shortname": "value",
                        "--os-version": "value",
                        "--package-name": "value",
                        "--package-version": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "remove-labels": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--labels": "value",
                    "--zone": "dynamic"
                  }
                },
                "remove-metadata": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--keys": "value",
                    "--zone": "dynamic"
                  }
                },
                "remove-resource-policies": {
                  "commands": {},
                  "flags": {
                    "--resource-policies": "value",
                    "--zone": "dynamic"
                  }
                },
                "remove-tags": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--tags": "value",
                    "--zone": "dynamic"
                  }
                },
                "reset": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "resume": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--csek-key-file": "value",
                    "--zone": "dynamic"
                  }
                },
                "set-disk-auto-delete": {
                  "commands": {},
                  "flags": {
                    "--auto-delete": "bool",
                    "--device-name": "value",
                    "--disk": "value",
                    "--zone": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "set-machine-type": {
                  "commands": {},
                  "flags": {
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--machine-type": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "set-min-cpu-platform": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--min-cpu-platform": "value",
                    "--zone": "dynamic"
                  }
                },
                "set-name": {
                  "commands": {},
                  "flags": {
                    "--new-name": "value",
                    "--zone": "dynamic"
                  }
                },
                "set-scheduling": {
                  "commands": {},
                  "flags": {
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--min-node-cpus": "value",
                    "--on-host-maintenance": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--restart-on-failure": "bool",
                    "--zone": "dynamic"
                  }
                },
                "set-scopes": {
                  "commands": {},
                  "flags": {
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--zone": "dynamic"
                  }
                },
                "simulate-maintenance-event": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "dynamic"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--csek-key-file": "value",
                    "--zone": "dynamic"
                  }
                },
                "stop": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--discard-local-ssd": "bool",
                    "--zone": "dynamic"
                  }
                },
                "suspend": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--discard-local-ssd": "bool",
                    "--zone": "dynamic"
                  }
                },
                "tail-serial-port-output": {
                  "commands": {},
                  "flags": {
                    "--port": "value",
                    "--zone": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--deletion-protection": "bool",
                    "--enable-display-device": "bool",
                    "--min-cpu-platform": "value",
                    "--remove-labels": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-learn-integrity-policy": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--update-labels": "value",
                    "--zone": "dynamic"
                  }
                },
                "update-access-config": {
                  "commands": {},
                  "flags": {
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-public-dns": "bool",
                    "--no-public-ptr": "bool",
                    "--no-public-ptr-domain": "bool",
                    "--public-dns": "bool",
                    "--public-ptr": "bool",
                    "--public-ptr-domain": "value",
                    "--zone": "dynamic"
                  }
                },
                "update-container": {
                  "commands": {},
                  "flags": {
                    "--clear-container-args": "bool",
                    "--clear-container-command": "bool",
                    "--container-arg": "value",
                    "--container-command": "value",
                    "--container-env": "value",
                    "--container-env-file": "value",
                    "--container-image": "value",
                    "--container-mount-disk": "value",
                    "--container-mount-host-path": "value",
                    "--container-mount-tmpfs": "value",
                    "--container-privileged": "bool",
                    "--container-restart-policy": [
                      "always",
                      "never",
                      "on-failure"
                    ],
                    "--container-stdin": "bool",
                    "--container-tty": "bool",
                    "--remove-container-env": "value",
                    "--remove-container-mounts": "value",
                    "--zone": "dynamic"
                  }
                },
                "vulnerabilities": {
                  "commands": {
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--instance": "dynamic",
                        "--instance-zone": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "interconnects": {
              "commands": {
                "attachments": {
                  "commands": {
                    "dedicated": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--bandwidth": [
                              "100m",
                              "10g",
                              "1g",
                              "200m",
                              "20g",
                              "2g",
                              "300m",
                              "400m",
                              "500m",
                              "50g",
                              "50m",
                              "5g"
                            ],
                            "--candidate-subnets": "value",
                            "--description": "value",
                            "--dry-run": "bool",
                            "--enable-admin": "bool",
                            "--interconnect": "dynamic",
                            "--mtu": "value",
                            "--region": "dynamic",
                            "--router": "dynamic",
                            "--vlan": "value"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--bandwidth": [
                              "100m",
                              "10g",
                              "1g",
                              "200m",
                              "20g",
                              "2g",
                              "300m",
                              "400m",
                              "500m",
                              "50g",
                              "50m",
                              "5g"
                            ],
                            "--clear-labels": "bool",
                            "--description": "value",
                            "--enable-admin": "bool",
                            "--mtu": "value",
                            "--region": "dynamic",
                            "--remove-labels": "value",
                            "--update-labels": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "partner": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--description": "value",
                            "--dry-run": "bool",
                            "--edge-availability-domain": [
                              "any",
                              "availability-domain-1",
                              "availability-domain-2"
                            ],
                            "--enable-admin": "bool",
                            "--mtu": "value",
                            "--region": "dynamic",
                            "--router": "dynamic"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--clear-labels": "bool",
                            "--description": "value",
                            "--enable-admin": "bool",
                            "--mtu": "value",
                            "--region": "dynamic",
                            "--remove-labels": "value",
                            "--update-labels": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--admin-enabled": "bool",
                    "--customer-name": "value",
                    "--description": "value",
                    "--interconnect-type": [
                      "DEDICATED",
                      "IT_PRIVATE",
                      "PARTNER"
                    ],
                    "--link-type": [
                      "LINK_TYPE_ETHERNET_100G_LR",
                      "LINK_TYPE_ETHERNET_10G_LR"
                    ],
                    "--location": "dynamic",
                    "--noc-contact-email": "value",
                    "--requested-link-count": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-diagnostics": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "locations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--admin-enabled": "bool",
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--noc-contact-email": "value",
                    "--remove-labels": "value",
                    "--requested-link-count": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "machine-images": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--csek-key-file": "value",
                    "--description": "value",
                    "--guest-flush": "bool",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--require-csek-key-create": "bool",
                    "--source-disk-csek-key": "value",
                    "--source-instance": "dynamic",
                    "--source-instance-zone": "dynamic",
                    "--storage-location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "machine-types": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "network-endpoint-groups": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--default-port": "value",
                    "--global": "bool",
                    "--network": "value",
                    "--network-endpoint-type": [
                      "gce-vm-ip-port",
                      "gce-vm-primary-ip",
                      "internet-fqdn-port",
                      "internet-ip-port",
                      "non-gcp-private-ip-port"
                    ],
                    "--subnet": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                },
                "list-network-endpoints": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--zone": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-endpoint": "value",
                    "--global": "bool",
                    "--remove-endpoint": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "networks": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--bgp-routing-mode": [
                      "global",
                      "regional"
                    ],
                    "--description": "value",
                    "--mtu": "value",
                    "--range": "value",
                    "--subnet-mode": [
                      "auto",
                      "custom",
                      "legacy"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-effective-firewalls": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-ip-addresses": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--types": "value"
                  }
                },
                "list-ip-owners": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--ip-cidr-range": "value",
                    "--limit": "value",
                    "--owner-projects": "value",
                    "--owner-types": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--subnet-name": "value",
                    "--subnet-region": "value",
                    "--uri": "bool"
                  }
                },
                "peerings": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--auto-create-routes": "bool",
                        "--export-custom-routes": "bool",
                        "--export-subnet-routes-with-public-ip": "bool",
                        "--import-custom-routes": "bool",
                        "--import-subnet-routes-with-public-ip": "bool",
                        "--network": "value",
                        "--peer-network": "value",
                        "--peer-project": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--network": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--network": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list-routes": {
                      "commands": {},
                      "flags": {
                        "--direction": [
                          "INCOMING",
                          "OUTGOING"
                        ],
                        "--filter": "value",
                        "--limit": "value",
                        "--network": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--export-custom-routes": "bool",
                        "--export-subnet-routes-with-public-ip": "bool",
                        "--import-custom-routes": "bool",
                        "--import-subnet-routes-with-public-ip": "bool",
                        "--network": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "subnets": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--region": "value",
                        "--role": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--aggregation-interval": [
                          "interval-1-min",
                          "interval-10-min",
                          "interval-15-min",
                          "interval-30-sec",
                          "interval-5-min",
                          "interval-5-sec"
                        ],
                        "--description": "value",
                        "--enable-flow-logs": "bool",
                        "--enable-private-ip-google-access": "bool",
                        "--enable-private-ipv6-access": "bool",
                        "--flow-sampling": "value",
                        "--logging-aggregation-interval": [
                          "interval-1-min",
                          "interval-10-min",
                          "interval-15-min",
                          "interval-30-sec",
                          "interval-5-min",
                          "interval-5-sec"
                        ],
                        "--logging-filter-expr": "value",
                        "--logging-flow-sampling": "value",
                        "--logging-metadata": [
                          "custom",
                          "exclude-all",
                          "include-all"
                        ],
                        "--logging-metadata-fields": "value",
                        "--metadata": [
                          "exclude-all-metadata",
                          "include-all-metadata"
                        ],
                        "--network": "dynamic",
                        "--private-ipv6-google-access-service-accounts": "value",
                        "--private-ipv6-google-access-type": [
                          "disable",
                          "enable-bidirectional-access",
                          "enable-outbound-vm-access",
                          "enable-outbound-vm-access-for-service-accounts"
                        ],
                        "--purpose": [
                          "AGGREGATE",
                          "INTERNAL_HTTPS_LOAD_BALANCER",
                          "PRIVATE"
                        ],
                        "--range": "value",
                        "--region": "dynamic",
                        "--role": [
                          "ACTIVE",
                          "BACKUP"
                        ],
                        "--secondary-range": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "expand-ip-range": {
                      "commands": {},
                      "flags": {
                        "--prefix-length": "value",
                        "--region": "dynamic"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--network": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--regions": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list-usable": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--region": "value",
                        "--role": "dynamic"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--region": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--add-secondary-ranges": "value",
                        "--aggregation-interval": [
                          "interval-1-min",
                          "interval-10-min",
                          "interval-15-min",
                          "interval-30-sec",
                          "interval-5-min",
                          "interval-5-sec"
                        ],
                        "--drain-timeout": "value",
                        "--enable-flow-logs": "bool",
                        "--enable-private-ip-google-access": "bool",
                        "--enable-private-ipv6-access": "bool",
                        "--flow-sampling": "value",
                        "--logging-aggregation-interval": [
                          "interval-1-min",
                          "interval-10-min",
                          "interval-15-min",
                          "interval-30-sec",
                          "interval-5-min",
                          "interval-5-sec"
                        ],
                        "--logging-filter-expr": "value",
                        "--logging-flow-sampling": "value",
                        "--logging-metadata": [
                          "custom",
                          "exclude-all",
                          "include-all"
                        ],
                        "--logging-metadata-fields": "value",
                        "--metadata": [
                          "exclude-all-metadata",
                          "include-all-metadata"
                        ],
                        "--private-ipv6-google-access-service-accounts": "value",
                        "--private-ipv6-google-access-type": [
                          "disable",
                          "enable-bidirectional-access",
                          "enable-outbound-vm-access",
                          "enable-outbound-vm-access-for-service-accounts"
                        ],
                        "--region": "dynamic",
                        "--remove-secondary-ranges": "value",
                        "--role": [
                          "ACTIVE"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--bgp-routing-mode": [
                      "global",
                      "regional"
                    ],
                    "--mtu": "value",
                    "--switch-to-custom-subnet-mode": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                }
              },
              "flags": {}
            },
            "org-security-policies": {
              "commands": {
                "associations": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--folder": "value",
                        "--name": "value",
                        "--organization": "value",
                        "--replace-association-on-target": "bool",
                        "--security-policy": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--security-policy": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--folder": "value",
                        "--organization": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "copy-rules": {
                  "commands": {},
                  "flags": {
                    "--source-security-policy": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--folder": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "move": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "rules": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny",
                          "goto_next"
                        ],
                        "--description": "value",
                        "--dest-ip-ranges": "value",
                        "--dest-ports": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--enable-logging": "bool",
                        "--security-policy": "value",
                        "--src-ip-ranges": "value",
                        "--target-resources": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--security-policy": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--security-policy": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny",
                          "goto_next"
                        ],
                        "--description": "value",
                        "--dest-ip-ranges": "value",
                        "--dest-ports": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--enable-logging": "bool",
                        "--new-priority": "value",
                        "--security-policy": "value",
                        "--src-ip-ranges": "value",
                        "--target-resources": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value"
                  }
                }
              },
              "flags": {}
            },
            "os-config": {
              "commands": {
                "guest-policies": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--description": "value",
                        "--file": "value",
                        "--folder": "value",
                        "--organization": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--folder": "value",
                        "--organization": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--folder": "value",
                        "--organization": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--folder": "value",
                        "--limit": "value",
                        "--organization": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "lookup": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--description": "value",
                        "--etag": "value",
                        "--file": "value",
                        "--folder": "value",
                        "--organization": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "patch-deployments": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--file": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {}
                    },
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "patch-jobs": {
                  "commands": {
                    "cancel": {
                      "commands": {},
                      "flags": {}
                    },
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "execute": {
                      "commands": {},
                      "flags": {
                        "--apt-dist": "bool",
                        "--apt-excludes": "value",
                        "--apt-exclusive-packages": "value",
                        "--async": "bool",
                        "--description": "value",
                        "--display-name": "value",
                        "--dry-run": "bool",
                        "--duration": "value",
                        "--instance-filter": "value",
                        "--instance-filter-all": "bool",
                        "--instance-filter-group-labels": "value",
                        "--instance-filter-name-prefixes": "value",
                        "--instance-filter-names": "value",
                        "--instance-filter-zones": "value",
                        "--post-patch-linux-executable": "value",
                        "--post-patch-linux-success-codes": "value",
                        "--post-patch-windows-executable": "value",
                        "--post-patch-windows-success-codes": "value",
                        "--pre-patch-linux-executable": "value",
                        "--pre-patch-linux-success-codes": "value",
                        "--pre-patch-windows-executable": "value",
                        "--pre-patch-windows-success-codes": "value",
                        "--reboot-config": [
                          "always",
                          "default",
                          "never"
                        ],
                        "--retry": "bool",
                        "--windows-classifications": "value",
                        "--windows-excludes": "value",
                        "--windows-exclusive-patches": "value",
                        "--yum-excludes": "value",
                        "--yum-exclusive-packages": "value",
                        "--yum-minimal": "bool",
                        "--yum-security": "bool",
                        "--zypper-categories": "value",
                        "--zypper-exclusive-patches": "value",
                        "--zypper-severities": "value",
                        "--zypper-with-optional": "bool",
                        "--zypper-with-update": "bool"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list-instance-details": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "os-login": {
              "commands": {
                "describe-profile": {
                  "commands": {},
                  "flags": {}
                },
                "remove-profile": {
                  "commands": {},
                  "flags": {
                    "--operating-system": [
                      "linux",
                      "windows"
                    ]
                  }
                },
                "ssh-keys": {
                  "commands": {
                    "add": {
                      "commands": {},
                      "flags": {
                        "--key": "value",
                        "--key-file": "value",
                        "--ttl": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--key": "value",
                        "--key-file": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "remove": {
                      "commands": {},
                      "flags": {
                        "--key": "value",
                        "--key-file": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--key": "value",
                        "--key-file": "value",
                        "--ttl": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "packet-mirrorings": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--collector-ilb": "value",
                    "--description": "value",
                    "--enable": "bool",
                    "--filter-cidr-ranges": "value",
                    "--filter-protocols": "value",
                    "--mirrored-instances": "value",
                    "--mirrored-subnets": "value",
                    "--mirrored-tags": "value",
                    "--network": "value",
                    "--priority": "value",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-filter-cidr-ranges": "value",
                    "--add-filter-protocols": "value",
                    "--add-mirrored-instances": "value",
                    "--add-mirrored-subnets": "value",
                    "--add-mirrored-tags": "value",
                    "--async": "bool",
                    "--clear-filter-cidr-ranges": "bool",
                    "--clear-filter-protocols": "bool",
                    "--clear-mirrored-instances": "bool",
                    "--clear-mirrored-subnets": "bool",
                    "--clear-mirrored-tags": "bool",
                    "--collector-ilb": "value",
                    "--description": "value",
                    "--enable": "bool",
                    "--priority": "value",
                    "--region": "dynamic",
                    "--remove-filter-cidr-ranges": "value",
                    "--remove-filter-protocols": "value",
                    "--remove-mirrored-instances": "value",
                    "--remove-mirrored-subnets": "value",
                    "--remove-mirrored-tags": "value",
                    "--set-filter-cidr-ranges": "value",
                    "--set-filter-protocols": "value",
                    "--set-mirrored-instances": "value",
                    "--set-mirrored-subnets": "value",
                    "--set-mirrored-tags": "value"
                  }
                }
              },
              "flags": {}
            },
            "project-info": {
              "commands": {
                "add-metadata": {
                  "commands": {},
                  "flags": {
                    "--metadata": "value",
                    "--metadata-from-file": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "remove-metadata": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--keys": "value"
                  }
                },
                "set-default-service-account": {
                  "commands": {},
                  "flags": {
                    "--no-service-account": "bool",
                    "--service-account": "value"
                  }
                },
                "set-usage-bucket": {
                  "commands": {},
                  "flags": {
                    "--bucket": "value",
                    "--no-bucket": "bool",
                    "--prefix": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--default-network-tier": [
                      "PREMIUM",
                      "STANDARD"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "regions": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "reservations": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--description": "value",
                    "--local-ssd": "value",
                    "--machine-type": "value",
                    "--min-cpu-platform": "value",
                    "--require-specific-reservation": "bool",
                    "--vm-count": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--vm-count": "value",
                    "--zone": "value"
                  }
                }
              },
              "flags": {}
            },
            "reset-windows-password": {
              "commands": {},
              "flags": {
                "--user": "value",
                "--zone": "dynamic"
              }
            },
            "resource-policies": {
              "commands": {
                "create": {
                  "commands": {
                    "snapshot-schedule": {
                      "commands": {},
                      "flags": {
                        "--daily-schedule": "bool",
                        "--description": "value",
                        "--guest-flush": "bool",
                        "--hourly-schedule": "value",
                        "--max-retention-days": "value",
                        "--on-source-disk-delete": [
                          "apply-retention-policy",
                          "keep-auto-snapshots"
                        ],
                        "--region": "dynamic",
                        "--snapshot-labels": "value",
                        "--start-time": "value",
                        "--storage-location": "value",
                        "--weekly-schedule": [
                          "friday",
                          "monday",
                          "saturday",
                          "sunday",
                          "thursday",
                          "tuesday",
                          "wednesday"
                        ],
                        "--weekly-schedule-from-file": "value"
                      }
                    },
                    "vm-maintenance": {
                      "commands": {
                        "concurrency-limit": {
                          "commands": {},
                          "flags": {
                            "--description": "value",
                            "--max-percent": "value",
                            "--region": "dynamic"
                          }
                        },
                        "maintenance-window": {
                          "commands": {},
                          "flags": {
                            "--daily-window": "bool",
                            "--description": "value",
                            "--region": "dynamic",
                            "--start-time": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "create-snapshot-schedule": {
                  "commands": {},
                  "flags": {
                    "--daily-schedule": "bool",
                    "--description": "value",
                    "--guest-flush": "bool",
                    "--hourly-schedule": "value",
                    "--max-retention-days": "value",
                    "--on-source-disk-delete": [
                      "apply-retention-policy",
                      "keep-auto-snapshots"
                    ],
                    "--region": "dynamic",
                    "--snapshot-labels": "value",
                    "--start-time": "value",
                    "--storage-location": "value",
                    "--weekly-schedule": [
                      "friday",
                      "monday",
                      "saturday",
                      "sunday",
                      "thursday",
                      "tuesday",
                      "wednesday"
                    ],
                    "--weekly-schedule-from-file": "value"
                  }
                },
                "create-vm-maintenance": {
                  "commands": {},
                  "flags": {
                    "--daily-window": "bool",
                    "--description": "value",
                    "--region": "dynamic",
                    "--start-time": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "routers": {
              "commands": {
                "add-bgp-peer": {
                  "commands": {},
                  "flags": {
                    "--advertised-route-priority": "value",
                    "--advertisement-mode": [
                      "CUSTOM",
                      "DEFAULT"
                    ],
                    "--async": "bool",
                    "--interface": "value",
                    "--peer-asn": "value",
                    "--peer-ip-address": "value",
                    "--peer-name": "value",
                    "--region": "dynamic",
                    "--set-advertisement-groups": "value",
                    "--set-advertisement-ranges": "value"
                  }
                },
                "add-interface": {
                  "commands": {},
                  "flags": {
                    "--interconnect-attachment": "dynamic",
                    "--interconnect-attachment-region": "dynamic",
                    "--interface-name": "value",
                    "--ip-address": "value",
                    "--mask-length": "value",
                    "--region": "dynamic",
                    "--vpn-tunnel": "dynamic",
                    "--vpn-tunnel-region": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--advertisement-mode": [
                      "CUSTOM",
                      "DEFAULT"
                    ],
                    "--asn": "value",
                    "--async": "bool",
                    "--description": "value",
                    "--network": "dynamic",
                    "--region": "dynamic",
                    "--set-advertisement-groups": "value",
                    "--set-advertisement-ranges": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "get-nat-mapping-info": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--nat-name": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value"
                  }
                },
                "get-status": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "nats": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--auto-allocate-nat-external-ips": "bool",
                        "--enable-logging": "bool",
                        "--icmp-idle-timeout": "value",
                        "--log-filter": [
                          "ALL",
                          "ERRORS_ONLY",
                          "TRANSLATIONS_ONLY"
                        ],
                        "--min-ports-per-vm": "value",
                        "--nat-all-subnet-ip-ranges": "bool",
                        "--nat-custom-subnet-ip-ranges": "value",
                        "--nat-external-ip-pool": "value",
                        "--nat-primary-subnet-ip-ranges": "bool",
                        "--region": "dynamic",
                        "--router": "dynamic",
                        "--tcp-established-idle-timeout": "value",
                        "--tcp-transitory-idle-timeout": "value",
                        "--udp-idle-timeout": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--router": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--router": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--router": "dynamic"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--auto-allocate-nat-external-ips": "bool",
                        "--clear-icmp-idle-timeout": "bool",
                        "--clear-min-ports-per-vm": "bool",
                        "--clear-nat-external-drain-ip-pool": "bool",
                        "--clear-tcp-established-idle-timeout": "bool",
                        "--clear-tcp-transitory-idle-timeout": "bool",
                        "--clear-udp-idle-timeout": "bool",
                        "--enable-logging": "bool",
                        "--icmp-idle-timeout": "value",
                        "--log-filter": [
                          "ALL",
                          "ERRORS_ONLY",
                          "TRANSLATIONS_ONLY"
                        ],
                        "--min-ports-per-vm": "value",
                        "--nat-all-subnet-ip-ranges": "bool",
                        "--nat-custom-subnet-ip-ranges": "value",
                        "--nat-external-drain-ip-pool": "value",
                        "--nat-external-ip-pool": "value",
                        "--nat-primary-subnet-ip-ranges": "bool",
                        "--region": "dynamic",
                        "--router": "dynamic",
                        "--tcp-established-idle-timeout": "value",
                        "--tcp-transitory-idle-timeout": "value",
                        "--udp-idle-timeout": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "remove-bgp-peer": {
                  "commands": {},
                  "flags": {
                    "--peer-name": "value",
                    "--region": "dynamic"
                  }
                },
                "remove-interface": {
                  "commands": {},
                  "flags": {
                    "--interface-name": "value",
                    "--region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-advertisement-groups": "value",
                    "--add-advertisement-ranges": "value",
                    "--advertisement-mode": [
                      "CUSTOM",
                      "DEFAULT"
                    ],
                    "--async": "bool",
                    "--region": "dynamic",
                    "--remove-advertisement-groups": "value",
                    "--remove-advertisement-ranges": "value",
                    "--set-advertisement-groups": "value",
                    "--set-advertisement-ranges": "value"
                  }
                },
                "update-bgp-peer": {
                  "commands": {},
                  "flags": {
                    "--add-advertisement-groups": "value",
                    "--add-advertisement-ranges": "value",
                    "--advertised-route-priority": "value",
                    "--advertisement-mode": [
                      "CUSTOM",
                      "DEFAULT"
                    ],
                    "--async": "bool",
                    "--interface": "value",
                    "--ip-address": "value",
                    "--peer-asn": "value",
                    "--peer-ip-address": "value",
                    "--peer-name": "value",
                    "--region": "dynamic",
                    "--remove-advertisement-groups": "value",
                    "--remove-advertisement-ranges": "value",
                    "--set-advertisement-groups": "value",
                    "--set-advertisement-ranges": "value"
                  }
                },
                "update-interface": {
                  "commands": {},
                  "flags": {
                    "--interconnect-attachment": "dynamic",
                    "--interconnect-attachment-region": "dynamic",
                    "--interface-name": "value",
                    "--ip-address": "value",
                    "--mask-length": "value",
                    "--region": "dynamic",
                    "--vpn-tunnel": "dynamic",
                    "--vpn-tunnel-region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "routes": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--destination-range": "value",
                    "--network": "value",
                    "--next-hop-address": "value",
                    "--next-hop-gateway": "dynamic",
                    "--next-hop-ilb": "value",
                    "--next-hop-ilb-region": "value",
                    "--next-hop-instance": "value",
                    "--next-hop-instance-zone": "value",
                    "--next-hop-vpn-tunnel": "value",
                    "--next-hop-vpn-tunnel-region": "value",
                    "--priority": "value",
                    "--tags": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "scp": {
              "commands": {},
              "flags": {
                "--compress": "bool",
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--internal-ip": "bool",
                "--plain": "bool",
                "--port": "value",
                "--recurse": "bool",
                "--scp-flag": "value",
                "--ssh-key-expiration": "value",
                "--ssh-key-expire-after": "value",
                "--ssh-key-file": "value",
                "--strict-host-key-checking": [
                  "ask",
                  "no",
                  "yes"
                ],
                "--tunnel-through-iap": "bool",
                "--zone": "value"
              }
            },
            "security-policies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--file-format": [
                      "json",
                      "yaml"
                    ],
                    "--file-name": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--file-format": [
                      "json",
                      "yaml"
                    ],
                    "--file-name": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--file-format": [
                      "json",
                      "yaml"
                    ],
                    "--file-name": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-preconfigured-expression-sets": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "rules": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny-403",
                          "deny-404",
                          "deny-502"
                        ],
                        "--description": "value",
                        "--expression": "value",
                        "--preview": "bool",
                        "--security-policy": "dynamic",
                        "--src-ip-ranges": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--security-policy": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--security-policy": "dynamic"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny-403",
                          "deny-404",
                          "deny-502"
                        ],
                        "--description": "value",
                        "--expression": "value",
                        "--preview": "bool",
                        "--security-policy": "dynamic",
                        "--src-ip-ranges": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "shared-vpc": {
              "commands": {
                "associated-projects": {
                  "commands": {
                    "add": {
                      "commands": {},
                      "flags": {
                        "--host-project": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove": {
                      "commands": {},
                      "flags": {
                        "--host-project": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "disable": {
                  "commands": {},
                  "flags": {}
                },
                "enable": {
                  "commands": {},
                  "flags": {}
                },
                "get-host-project": {
                  "commands": {},
                  "flags": {}
                },
                "list-associated-resources": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "organizations": {
                  "commands": {
                    "list-host-projects": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "sign-url": {
              "commands": {},
              "flags": {
                "--expires-in": "value",
                "--key-file": "value",
                "--key-name": "value",
                "--validate": "bool"
              }
            },
            "snapshots": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--labels": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "remove-labels": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--labels": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "sole-tenancy": {
              "commands": {
                "node-groups": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--role": "dynamic",
                        "--zone": "value"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--autoscaler-mode": [
                          "off",
                          "on",
                          "only-scale-out"
                        ],
                        "--description": "value",
                        "--maintenance-policy": [
                          "default",
                          "migrate-within-node-group",
                          "restart-in-place"
                        ],
                        "--max-nodes": "value",
                        "--min-nodes": "value",
                        "--node-template": "value",
                        "--target-size": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--zone": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list-nodes": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--role": "dynamic",
                        "--zone": "value"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--zone": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--add-nodes": "value",
                        "--autoscaler-mode": [
                          "off",
                          "on",
                          "only-scale-out"
                        ],
                        "--delete-nodes": "value",
                        "--max-nodes": "value",
                        "--min-nodes": "value",
                        "--node-template": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "node-templates": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--region": "value",
                        "--role": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--description": "value",
                        "--disk": "value",
                        "--node-affinity-labels": "value",
                        "--node-requirements": "value",
                        "--node-type": "value",
                        "--region": "dynamic",
                        "--server-binding": [
                          "restart-node-on-any-server",
                          "restart-node-on-minimal-servers"
                        ]
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--region": "value",
                        "--role": "dynamic"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--region": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "node-types": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "ssh": {
              "commands": {},
              "flags": {
                "--command": "value",
                "--container": "value",
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--internal-ip": "bool",
                "--plain": "bool",
                "--ssh-flag": "value",
                "--ssh-key-expiration": "value",
                "--ssh-key-expire-after": "value",
                "--ssh-key-file": "value",
                "--strict-host-key-checking": [
                  "ask",
                  "no",
                  "yes"
                ],
                "--tunnel-through-iap": "bool",
                "--zone": "dynamic"
              }
            },
            "ssl-certificates": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--certificate": "value",
                    "--description": "value",
                    "--domains": "value",
                    "--global": "bool",
                    "--private-key": "value",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "ssl-policies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--custom-features": "value",
                    "--description": "value",
                    "--min-tls-version": [
                      "1.0",
                      "1.1",
                      "1.2"
                    ],
                    "--profile": [
                      "COMPATIBLE",
                      "CUSTOM",
                      "MODERN",
                      "RESTRICTED"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-available-features": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--custom-features": "value",
                    "--min-tls-version": [
                      "1.0",
                      "1.1",
                      "1.2"
                    ],
                    "--profile": [
                      "COMPATIBLE",
                      "CUSTOM",
                      "MODERN",
                      "RESTRICTED"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "start-iap-tunnel": {
              "commands": {},
              "flags": {
                "--local-host-port": "value",
                "--zone": "dynamic"
              }
            },
            "target-http-proxies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--global": "bool",
                    "--global-url-map": "bool",
                    "--proxy-bind": "bool",
                    "--region": "dynamic",
                    "--url-map": "dynamic",
                    "--url-map-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--global-url-map": "bool",
                    "--region": "dynamic",
                    "--url-map": "dynamic",
                    "--url-map-region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-https-proxies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--global": "bool",
                    "--global-ssl-certificates": "bool",
                    "--global-url-map": "bool",
                    "--proxy-bind": "bool",
                    "--quic-override": [
                      "DISABLE",
                      "ENABLE",
                      "NONE"
                    ],
                    "--region": "dynamic",
                    "--ssl-certificates": "dynamic",
                    "--ssl-certificates-region": "dynamic",
                    "--ssl-policy": "dynamic",
                    "--url-map": "dynamic",
                    "--url-map-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-ssl-policy": "bool",
                    "--global": "bool",
                    "--global-ssl-certificates": "bool",
                    "--global-url-map": "bool",
                    "--quic-override": [
                      "DISABLE",
                      "ENABLE",
                      "NONE"
                    ],
                    "--region": "dynamic",
                    "--ssl-certificates": "dynamic",
                    "--ssl-certificates-region": "dynamic",
                    "--ssl-policy": "dynamic",
                    "--url-map": "dynamic",
                    "--url-map-region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-instances": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--instance": "dynamic",
                    "--instance-zone": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-pools": {
              "commands": {
                "add-health-checks": {
                  "commands": {},
                  "flags": {
                    "--http-health-check": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "add-instances": {
                  "commands": {},
                  "flags": {
                    "--instances": "dynamic",
                    "--instances-zone": "dynamic",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--backup-pool": "value",
                    "--description": "value",
                    "--failover-ratio": "value",
                    "--health-check": "value",
                    "--http-health-check": "dynamic",
                    "--region": "dynamic",
                    "--session-affinity": [
                      "CLIENT_IP",
                      "CLIENT_IP_PROTO",
                      "NONE"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "get-health": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-health-checks": {
                  "commands": {},
                  "flags": {
                    "--http-health-check": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "remove-instances": {
                  "commands": {},
                  "flags": {
                    "--instances": "dynamic",
                    "--instances-zone": "dynamic",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "set-backup": {
                  "commands": {},
                  "flags": {
                    "--backup-pool": "dynamic",
                    "--failover-ratio": "value",
                    "--no-backup-pool": "bool",
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-ssl-proxies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "dynamic",
                    "--description": "value",
                    "--proxy-header": [
                      "NONE",
                      "PROXY_V1"
                    ],
                    "--ssl-certificates": "dynamic",
                    "--ssl-policy": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "dynamic",
                    "--clear-ssl-policy": "bool",
                    "--proxy-header": [
                      "NONE",
                      "PROXY_V1"
                    ],
                    "--ssl-certificates": "dynamic",
                    "--ssl-policy": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-tcp-proxies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "dynamic",
                    "--description": "value",
                    "--proxy-header": [
                      "NONE",
                      "PROXY_V1"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "dynamic",
                    "--proxy-header": [
                      "NONE",
                      "PROXY_V1"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "target-vpn-gateways": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--network": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "tpus": {
              "commands": {
                "accelerator-types": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator-type": "value",
                    "--async": "bool",
                    "--description": "value",
                    "--model-base-path": "value",
                    "--model-config-file": "value",
                    "--model-name": "value",
                    "--network": "value",
                    "--platform-config-file": "value",
                    "--preemptible": "bool",
                    "--range": "value",
                    "--reserved": "bool",
                    "--use-service-networking": "bool",
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "dynamic"
                  }
                },
                "locations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "reimage": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "stop": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "versions": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "url-maps": {
              "commands": {
                "add-host-rule": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--global": "bool",
                    "--hosts": "value",
                    "--path-matcher-name": "value",
                    "--region": "dynamic"
                  }
                },
                "add-path-matcher": {
                  "commands": {},
                  "flags": {
                    "--backend-bucket-path-rules": "value",
                    "--backend-service-path-rules": "value",
                    "--default-backend-bucket": "value",
                    "--default-service": "value",
                    "--delete-orphaned-path-matcher": "bool",
                    "--description": "value",
                    "--existing-host": "value",
                    "--global": "bool",
                    "--new-hosts": "value",
                    "--path-matcher-name": "value",
                    "--path-rules": "value",
                    "--region": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--default-backend-bucket": "value",
                    "--default-service": "value",
                    "--description": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "edit": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "invalidate-cdn-cache": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--global": "bool",
                    "--host": "value",
                    "--path": "value",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-cdn-cache-invalidations": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--limit": "value",
                    "--region": "dynamic"
                  }
                },
                "remove-host-rule": {
                  "commands": {},
                  "flags": {
                    "--delete-orphaned-path-matcher": "bool",
                    "--global": "bool",
                    "--host": "value",
                    "--region": "dynamic"
                  }
                },
                "remove-path-matcher": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--path-matcher-name": "value",
                    "--region": "dynamic"
                  }
                },
                "set-default-service": {
                  "commands": {},
                  "flags": {
                    "--default-backend-bucket": "value",
                    "--default-service": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "vpn-gateways": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--network": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "get-status": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "vpn-tunnels": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--ike-version": [
                      1,
                      2
                    ],
                    "--interface": [
                      0,
                      1
                    ],
                    "--local-traffic-selector": "value",
                    "--peer-address": "value",
                    "--peer-external-gateway": "dynamic",
                    "--peer-external-gateway-interface": [
                      0,
                      1,
                      2,
                      3
                    ],
                    "--peer-gcp-gateway": "dynamic",
                    "--peer-gcp-gateway-region": "dynamic",
                    "--region": "dynamic",
                    "--remote-traffic-selector": "value",
                    "--router": "dynamic",
                    "--router-region": "dynamic",
                    "--shared-secret": "value",
                    "--target-vpn-gateway": "dynamic",
                    "--target-vpn-gateway-region": "dynamic",
                    "--vpn-gateway": "dynamic",
                    "--vpn-gateway-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "zones": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "config": {
          "commands": {
            "configurations": {
              "commands": {
                "activate": {
                  "commands": {},
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--activate": "bool"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--all": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--all": "bool",
                "--filter": "value",
                "--limit": "value",
                "--sort-by": "value"
              }
            },
            "set": {
              "commands": {},
              "flags": {
                "--installation": "bool"
              }
            },
            "unset": {
              "commands": {},
              "flags": {
                "--installation": "bool"
              }
            }
          },
          "flags": {}
        },
        "container": {
          "commands": {
            "binauthz": {
              "commands": {
                "attestations": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--artifact-url": "value",
                        "--attestor": "value",
                        "--attestor-project": "value",
                        "--payload-file": "value",
                        "--public-key-id": "value",
                        "--signature-file": "value",
                        "--validate": "bool"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--artifact-url": "value",
                        "--attestor": "value",
                        "--attestor-project": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "sign-and-create": {
                      "commands": {},
                      "flags": {
                        "--artifact-url": "value",
                        "--attestor": "value",
                        "--attestor-project": "value",
                        "--keyversion": "value",
                        "--keyversion-key": "value",
                        "--keyversion-keyring": "value",
                        "--keyversion-location": "value",
                        "--keyversion-project": "value",
                        "--public-key-id-override": "value",
                        "--validate": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "attestors": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--role": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--attestation-authority-note": "value",
                        "--attestation-authority-note-project": "value",
                        "--description": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {}
                    },
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "public-keys": {
                      "commands": {
                        "add": {
                          "commands": {},
                          "flags": {
                            "--attestor": "value",
                            "--comment": "value",
                            "--keyversion": "value",
                            "--keyversion-key": "value",
                            "--keyversion-keyring": "value",
                            "--keyversion-location": "value",
                            "--keyversion-project": "value",
                            "--pgp-public-key-file": "value",
                            "--pkix-public-key-algorithm": [
                              "ecdsa-p256-sha256",
                              "ecdsa-p384-sha384",
                              "ecdsa-p521-sha512",
                              "rsa-pss-2048-sha256",
                              "rsa-pss-3072-sha256",
                              "rsa-pss-4096-sha256",
                              "rsa-pss-4096-sha512",
                              "rsa-sign-pkcs1-2048-sha256",
                              "rsa-sign-pkcs1-3072-sha256",
                              "rsa-sign-pkcs1-4096-sha256",
                              "rsa-sign-pkcs1-4096-sha512"
                            ],
                            "--pkix-public-key-file": "value",
                            "--public-key-id-override": "value"
                          }
                        },
                        "remove": {
                          "commands": {},
                          "flags": {
                            "--attestor": "value"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--attestor": "value",
                            "--comment": "value",
                            "--pgp-public-key-file": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--role": "dynamic"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {}
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--description": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "create-signature-payload": {
                  "commands": {},
                  "flags": {
                    "--artifact-url": "value"
                  }
                },
                "policy": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--role": "dynamic"
                      }
                    },
                    "export": {
                      "commands": {},
                      "flags": {}
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "import": {
                      "commands": {},
                      "flags": {
                        "--strict-validation": "bool"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--role": "dynamic"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "clusters": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--additional-zones": "value",
                    "--addons": "value",
                    "--allow-route-overlap": "bool",
                    "--async": "bool",
                    "--autoprovisioning-config-file": "value",
                    "--autoprovisioning-locations": "value",
                    "--autoprovisioning-scopes": "value",
                    "--autoprovisioning-service-account": "value",
                    "--cluster-ipv4-cidr": "value",
                    "--cluster-secondary-range-name": "value",
                    "--cluster-version": "value",
                    "--create-subnetwork": "value",
                    "--database-encryption-key": "value",
                    "--default-max-pods-per-node": "value",
                    "--disable-default-snat": "bool",
                    "--disk-size": "value",
                    "--disk-type": [
                      "pd-ssd",
                      "pd-standard"
                    ],
                    "--enable-autoprovisioning": "bool",
                    "--enable-autorepair": "bool",
                    "--enable-autoscaling": "bool",
                    "--enable-autoupgrade": "bool",
                    "--enable-basic-auth": "bool",
                    "--enable-binauthz": "bool",
                    "--enable-cloud-logging": "bool",
                    "--enable-cloud-monitoring": "bool",
                    "--enable-cloud-run-alpha": "bool",
                    "--enable-cost-management": "bool",
                    "--enable-intra-node-visibility": "bool",
                    "--enable-ip-alias": "bool",
                    "--enable-kubernetes-alpha": "bool",
                    "--enable-legacy-authorization": "bool",
                    "--enable-master-authorized-networks": "bool",
                    "--enable-network-egress-metering": "bool",
                    "--enable-network-policy": "bool",
                    "--enable-peering-route-sharing": "bool",
                    "--enable-pod-security-policy": "bool",
                    "--enable-private-endpoint": "bool",
                    "--enable-private-nodes": "bool",
                    "--enable-resource-consumption-metering": "bool",
                    "--enable-shielded-nodes": "bool",
                    "--enable-stackdriver-kubernetes": "bool",
                    "--enable-tpu": "bool",
                    "--enable-tpu-service-networking": "bool",
                    "--enable-vertical-pod-autoscaling": "bool",
                    "--identity-namespace": "value",
                    "--image-type": "value",
                    "--issue-client-certificate": "bool",
                    "--istio-config": "value",
                    "--labels": "value",
                    "--linux-sysctls": "value",
                    "--local-ssd-count": "value",
                    "--local-ssd-volumes": "value",
                    "--machine-type": "value",
                    "--maintenance-window": "value",
                    "--maintenance-window-end": "value",
                    "--maintenance-window-recurrence": "value",
                    "--maintenance-window-start": "value",
                    "--master-authorized-networks": "value",
                    "--master-ipv4-cidr": "value",
                    "--max-accelerator": "value",
                    "--max-cpu": "value",
                    "--max-memory": "value",
                    "--max-nodes": "value",
                    "--max-nodes-per-pool": "value",
                    "--max-pods-per-node": "value",
                    "--max-surge-upgrade": "value",
                    "--max-unavailable-upgrade": "value",
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-accelerator": "value",
                    "--min-cpu": "value",
                    "--min-cpu-platform": "value",
                    "--min-memory": "value",
                    "--min-nodes": "value",
                    "--network": "value",
                    "--node-config": "value",
                    "--node-labels": "value",
                    "--node-locations": "value",
                    "--node-pool-name": "value",
                    "--node-taints": "value",
                    "--node-version": "value",
                    "--num-nodes": "value",
                    "--password": "value",
                    "--preemptible": "bool",
                    "--private-cluster": "bool",
                    "--region": "value",
                    "--release-channel": [
                      "rapid",
                      "regular",
                      "stable"
                    ],
                    "--resource-usage-bigquery-dataset": "value",
                    "--scopes": "value",
                    "--security-group": "value",
                    "--security-profile": "value",
                    "--security-profile-runtime-rules": "bool",
                    "--service-account": "value",
                    "--services-ipv4-cidr": "value",
                    "--services-secondary-range-name": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--subnetwork": "value",
                    "--tags": "value",
                    "--tpu-ipv4-cidr": "value",
                    "--username": "value",
                    "--workload-metadata-from-node": [
                      "EXPOSED",
                      "GKE_METADATA_SERVER",
                      "SECURE",
                      "UNSPECIFIED"
                    ],
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "get-credentials": {
                  "commands": {},
                  "flags": {
                    "--internal-ip": "bool",
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "value"
                  }
                },
                "resize": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--node-pool": "value",
                    "--num-nodes": "value",
                    "--region": "value",
                    "--size": "value",
                    "--zone": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-maintenance-exclusion-end": "value",
                    "--add-maintenance-exclusion-name": "value",
                    "--add-maintenance-exclusion-start": "value",
                    "--additional-zones": "value",
                    "--async": "bool",
                    "--autoprovisioning-config-file": "value",
                    "--autoprovisioning-locations": "value",
                    "--autoprovisioning-scopes": "value",
                    "--autoprovisioning-service-account": "value",
                    "--clear-maintenance-window": "bool",
                    "--clear-resource-usage-bigquery-dataset": "bool",
                    "--complete-credential-rotation": "bool",
                    "--complete-ip-rotation": "bool",
                    "--database-encryption-key": "value",
                    "--disable-database-encryption": "bool",
                    "--disable-default-snat": "bool",
                    "--disable-workload-identity": "bool",
                    "--enable-autoprovisioning": "bool",
                    "--enable-autoscaling": "bool",
                    "--enable-basic-auth": "bool",
                    "--enable-binauthz": "bool",
                    "--enable-cost-management": "bool",
                    "--enable-intra-node-visibility": "bool",
                    "--enable-legacy-authorization": "bool",
                    "--enable-master-authorized-networks": "bool",
                    "--enable-network-egress-metering": "bool",
                    "--enable-network-policy": "bool",
                    "--enable-peering-route-sharing": "bool",
                    "--enable-pod-security-policy": "bool",
                    "--enable-resource-consumption-metering": "bool",
                    "--enable-shielded-nodes": "bool",
                    "--enable-stackdriver-kubernetes": "bool",
                    "--enable-vertical-pod-autoscaling": "bool",
                    "--generate-password": "bool",
                    "--identity-namespace": "value",
                    "--istio-config": "value",
                    "--logging-service": "value",
                    "--maintenance-window": "value",
                    "--maintenance-window-end": "value",
                    "--maintenance-window-recurrence": "value",
                    "--maintenance-window-start": "value",
                    "--master-authorized-networks": "value",
                    "--max-accelerator": "value",
                    "--max-cpu": "value",
                    "--max-memory": "value",
                    "--max-nodes": "value",
                    "--min-accelerator": "value",
                    "--min-cpu": "value",
                    "--min-memory": "value",
                    "--min-nodes": "value",
                    "--monitoring-service": "value",
                    "--node-locations": "value",
                    "--node-pool": "value",
                    "--password": "value",
                    "--region": "value",
                    "--release-channel": [
                      "None",
                      "rapid",
                      "regular",
                      "stable"
                    ],
                    "--remove-labels": "value",
                    "--remove-maintenance-exclusion": "value",
                    "--resource-usage-bigquery-dataset": "value",
                    "--security-profile": "value",
                    "--set-password": "bool",
                    "--start-credential-rotation": "bool",
                    "--start-ip-rotation": "bool",
                    "--update-addons": "value",
                    "--update-labels": "value",
                    "--username": "value",
                    "--zone": "value"
                  }
                },
                "upgrade": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster-version": "value",
                    "--concurrent-node-count": "value",
                    "--image-type": "value",
                    "--master": "bool",
                    "--node-pool": "value",
                    "--region": "value",
                    "--security-profile": "value",
                    "--security-profile-runtime-rules": "bool",
                    "--zone": "value"
                  }
                }
              },
              "flags": {
                "--region": "value",
                "--zone": "value"
              }
            },
            "get-server-config": {
              "commands": {},
              "flags": {
                "--region": "value",
                "--zone": "value"
              }
            },
            "hub": {
              "commands": {},
              "flags": {}
            },
            "images": {
              "commands": {
                "add-tag": {
                  "commands": {},
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--force-delete-tags": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--metadata-filter": "value",
                    "--show-all-metadata": "bool",
                    "--show-build-details": "bool",
                    "--show-deployment": "bool",
                    "--show-image-basis": "bool",
                    "--show-package-vulnerability": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--repository": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-tags": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--occurrence-filter": "value",
                    "--page-size": "value",
                    "--show-occurrences": "bool",
                    "--show-occurrences-from": "value",
                    "--sort-by": "value"
                  }
                },
                "untag": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "memberships": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--gke-cluster-self-link": "value",
                    "--labels": "value",
                    "--location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "register": {
                  "commands": {},
                  "flags": {
                    "--context": "value",
                    "--kubeconfig": "value",
                    "--manifest-output-file": "value",
                    "--proxy": "value",
                    "--service-account-key-file": "value"
                  }
                },
                "unregister": {
                  "commands": {},
                  "flags": {
                    "--context": "value",
                    "--kubeconfig": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--gke-cluster-self-link": "value",
                    "--location": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "node-pools": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--cluster": "value",
                    "--disk-size": "value",
                    "--disk-type": [
                      "pd-ssd",
                      "pd-standard"
                    ],
                    "--enable-autoprovisioning": "bool",
                    "--enable-autorepair": "bool",
                    "--enable-autoscaling": "bool",
                    "--enable-autoupgrade": "bool",
                    "--image-type": "value",
                    "--linux-sysctls": "value",
                    "--local-ssd-count": "value",
                    "--local-ssd-volumes": "value",
                    "--machine-type": "value",
                    "--max-nodes": "value",
                    "--max-pods-per-node": "value",
                    "--max-surge-upgrade": "value",
                    "--max-unavailable-upgrade": "value",
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--min-nodes": "value",
                    "--node-config": "value",
                    "--node-group": "value",
                    "--node-labels": "value",
                    "--node-locations": "value",
                    "--node-taints": "value",
                    "--node-version": "value",
                    "--num-nodes": "value",
                    "--preemptible": "bool",
                    "--region": "value",
                    "--sandbox": "value",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--tags": "value",
                    "--workload-metadata-from-node": [
                      "EXPOSED",
                      "GKE_METADATA_SERVER",
                      "SECURE",
                      "UNSPECIFIED"
                    ],
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster": "value",
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "value"
                  }
                },
                "rollback": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster": "value",
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--enable-autoprovisioning": "bool",
                    "--enable-autorepair": "bool",
                    "--enable-autoscaling": "bool",
                    "--enable-autoupgrade": "bool",
                    "--max-nodes": "value",
                    "--max-surge-upgrade": "value",
                    "--max-unavailable-upgrade": "value",
                    "--min-nodes": "value",
                    "--node-locations": "value",
                    "--region": "value",
                    "--workload-metadata-from-node": [
                      "EXPOSED",
                      "GKE_METADATA_SERVER",
                      "SECURE",
                      "UNSPECIFIED"
                    ],
                    "--zone": "value"
                  }
                }
              },
              "flags": {
                "--region": "value",
                "--zone": "value"
              }
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--zone": "value"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--zone": "value"
                  }
                }
              },
              "flags": {
                "--region": "value",
                "--zone": "value"
              }
            },
            "subnets": {
              "commands": {
                "list-usable": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--network-project": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "data-catalog": {
          "commands": {
            "crawler-runs": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--crawler": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "crawlers": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--buckets": "value",
                    "--bundle-specs": "value",
                    "--crawl-scope": [
                      "bucket",
                      "organization",
                      "project"
                    ],
                    "--description": "value",
                    "--display-name": "value",
                    "--run-option": [
                      "manual",
                      "scheduled"
                    ],
                    "--run-schedule": [
                      "daily",
                      "weekly"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-buckets": "value",
                    "--add-bundle-specs": "value",
                    "--clear-buckets": "bool",
                    "--clear-bundle-specs": "bool",
                    "--crawl-scope": [
                      "bucket",
                      "organization",
                      "project"
                    ],
                    "--description": "value",
                    "--display-name": "value",
                    "--remove-buckets": "value",
                    "--remove-bundle-specs": "value",
                    "--run-option": [
                      "manual",
                      "scheduled"
                    ],
                    "--run-schedule": [
                      "daily",
                      "weekly"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "entries": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--entry-group": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--entry-group": "value",
                    "--gcs-file-patterns": "value",
                    "--location": "value",
                    "--schema": "value",
                    "--schema-from-file": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--entry-group": "value",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--entry-group": "value",
                    "--location": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--entry-group": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "lookup": {
                  "commands": {},
                  "flags": {}
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--entry-group": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--entry-group": "value",
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--entry-group": "value",
                    "--location": "value",
                    "--lookup-entry": "value",
                    "--schema": "value",
                    "--schema-from-file": "value"
                  }
                }
              },
              "flags": {}
            },
            "entry-groups": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            },
            "search": {
              "commands": {},
              "flags": {
                "--include-gcp-public-datasets": "bool",
                "--include-organization-ids": "value",
                "--include-project-ids": "value",
                "--limit": "value",
                "--order-by": "value",
                "--page-size": "value"
              }
            },
            "tag-templates": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--display-name": "value",
                    "--field": "value",
                    "--location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--force": "bool",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "fields": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--display-name": "value",
                        "--location": "value",
                        "--tag-template": "value",
                        "--type": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--force": "bool",
                        "--location": "value",
                        "--tag-template": "value"
                      }
                    },
                    "rename": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--new-id": "value",
                        "--tag-template": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--add-enum-values": "value",
                        "--display-name": "value",
                        "--location": "value",
                        "--tag-template": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--display-name": "value",
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            },
            "tags": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--entry": "value",
                    "--entry-group": "value",
                    "--location": "value",
                    "--scope": "value",
                    "--tag-file": "value",
                    "--tag-template": "value",
                    "--tag-template-location": "value",
                    "--tag-template-project": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--entry": "value",
                    "--entry-group": "value",
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--entry": "value",
                    "--entry-group": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--entry": "value",
                    "--entry-group": "value",
                    "--location": "value",
                    "--tag-file": "value",
                    "--tag-template": "value",
                    "--tag-template-location": "value",
                    "--tag-template-project": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "dataflow": {
          "commands": {
            "jobs": {
              "commands": {
                "export-steps": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                }
              },
              "flags": {}
            },
            "logs": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--after": "value",
                    "--before": "value",
                    "--filter": "value",
                    "--importance": [
                      "debug",
                      "detailed",
                      "error",
                      "warning"
                    ],
                    "--limit": "value",
                    "--region": "value"
                  }
                }
              },
              "flags": {}
            },
            "metrics": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--changed-after": "value",
                    "--filter": "value",
                    "--hide-committed": "bool",
                    "--limit": "value",
                    "--region": "value",
                    "--source": [
                      "all",
                      "service",
                      "user"
                    ],
                    "--tentative": "bool",
                    "--transform": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "dataproc": {
          "commands": {
            "autoscaling-policies": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--region": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                }
              },
              "flags": {}
            },
            "clusters": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--autoscaling-policy": "value",
                    "--bucket": "value",
                    "--enable-component-gateway": "bool",
                    "--expiration-time": "value",
                    "--gce-pd-kms-key": "dynamic",
                    "--gce-pd-kms-key-keyring": "dynamic",
                    "--gce-pd-kms-key-location": "dynamic",
                    "--gce-pd-kms-key-project": "dynamic",
                    "--image": "value",
                    "--image-version": "value",
                    "--initialization-action-timeout": "value",
                    "--initialization-actions": "value",
                    "--kerberos-config-file": "value",
                    "--kerberos-kms-key": "dynamic",
                    "--kerberos-kms-key-keyring": "dynamic",
                    "--kerberos-kms-key-location": "dynamic",
                    "--kerberos-kms-key-project": "dynamic",
                    "--kerberos-root-principal-password-uri": "value",
                    "--labels": "value",
                    "--master-accelerator": "value",
                    "--master-boot-disk-size": "value",
                    "--master-boot-disk-type": "value",
                    "--master-machine-type": "value",
                    "--master-min-cpu-platform": "value",
                    "--max-age": "value",
                    "--max-idle": "value",
                    "--metadata": "value",
                    "--network": "value",
                    "--no-address": "bool",
                    "--num-master-local-ssds": "value",
                    "--num-masters": "value",
                    "--num-preemptible-worker-local-ssds": "value",
                    "--num-preemptible-workers": "value",
                    "--num-worker-local-ssds": "value",
                    "--num-workers": "value",
                    "--optional-components": "value",
                    "--preemptible-worker-accelerator": "value",
                    "--preemptible-worker-boot-disk-size": "value",
                    "--preemptible-worker-boot-disk-type": "value",
                    "--properties": "value",
                    "--region": "value",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--single-node": "bool",
                    "--subnet": "value",
                    "--tags": "value",
                    "--worker-accelerator": "value",
                    "--worker-boot-disk-size": "value",
                    "--worker-boot-disk-type": "value",
                    "--worker-machine-type": "value",
                    "--worker-min-cpu-platform": "value",
                    "--zone": "value"
                  }
                },
                "create-from-file": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--file": "value",
                    "--region": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "diagnose": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--region": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "value",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--autoscaling-policy": "value",
                    "--clear-labels": "bool",
                    "--disable-autoscaling": "bool",
                    "--expiration-time": "value",
                    "--graceful-decommission-timeout": "value",
                    "--max-age": "value",
                    "--max-idle": "value",
                    "--no-max-age": "bool",
                    "--no-max-idle": "bool",
                    "--num-preemptible-workers": "value",
                    "--num-workers": "value",
                    "--region": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "jobs": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value"
                  }
                },
                "kill": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--state-filter": [
                      "active",
                      "inactive"
                    ]
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "submit": {
                  "commands": {
                    "hadoop": {
                      "commands": {},
                      "flags": {
                        "--archives": "value",
                        "--async": "bool",
                        "--bucket": "value",
                        "--class": "value",
                        "--cluster": "value",
                        "--driver-log-levels": "value",
                        "--files": "value",
                        "--jar": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--max-failures-per-hour": "value",
                        "--properties": "value",
                        "--region": "value"
                      }
                    },
                    "hive": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--bucket": "value",
                        "--cluster": "value",
                        "--continue-on-failure": "bool",
                        "--execute": "value",
                        "--file": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--max-failures-per-hour": "value",
                        "--params": "value",
                        "--properties": "value",
                        "--region": "value"
                      }
                    },
                    "pig": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--bucket": "value",
                        "--cluster": "value",
                        "--continue-on-failure": "bool",
                        "--driver-log-levels": "value",
                        "--execute": "value",
                        "--file": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--max-failures-per-hour": "value",
                        "--params": "value",
                        "--properties": "value",
                        "--region": "value"
                      }
                    },
                    "presto": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--bucket": "value",
                        "--client-tags": "value",
                        "--cluster": "value",
                        "--continue-on-failure": "bool",
                        "--driver-log-levels": "value",
                        "--execute": "value",
                        "--file": "value",
                        "--labels": "value",
                        "--max-failures-per-hour": "value",
                        "--properties": "value",
                        "--query-output-format": "value",
                        "--region": "value"
                      }
                    },
                    "pyspark": {
                      "commands": {},
                      "flags": {
                        "--archives": "value",
                        "--async": "bool",
                        "--bucket": "value",
                        "--cluster": "value",
                        "--driver-log-levels": "value",
                        "--files": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--max-failures-per-hour": "value",
                        "--properties": "value",
                        "--py-files": "value",
                        "--region": "value"
                      }
                    },
                    "spark": {
                      "commands": {},
                      "flags": {
                        "--archives": "value",
                        "--async": "bool",
                        "--bucket": "value",
                        "--class": "value",
                        "--cluster": "value",
                        "--driver-log-levels": "value",
                        "--files": "value",
                        "--jar": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--max-failures-per-hour": "value",
                        "--properties": "value",
                        "--region": "value"
                      }
                    },
                    "spark-r": {
                      "commands": {},
                      "flags": {
                        "--archives": "value",
                        "--async": "bool",
                        "--bucket": "value",
                        "--cluster": "value",
                        "--driver-log-levels": "value",
                        "--files": "value",
                        "--labels": "value",
                        "--max-failures-per-hour": "value",
                        "--properties": "value",
                        "--region": "value"
                      }
                    },
                    "spark-sql": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--bucket": "value",
                        "--cluster": "value",
                        "--driver-log-levels": "value",
                        "--execute": "value",
                        "--file": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--max-failures-per-hour": "value",
                        "--params": "value",
                        "--properties": "value",
                        "--region": "value"
                      }
                    }
                  },
                  "flags": {
                    "--async": "bool",
                    "--bucket": "value",
                    "--region": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--region": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--state-filter": [
                      "active",
                      "inactive"
                    ]
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                }
              },
              "flags": {}
            },
            "workflow-templates": {
              "commands": {
                "add-job": {
                  "commands": {
                    "hadoop": {
                      "commands": {},
                      "flags": {
                        "--archives": "value",
                        "--class": "value",
                        "--driver-log-levels": "value",
                        "--files": "value",
                        "--jar": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--properties": "value",
                        "--region": "value",
                        "--start-after": "value",
                        "--step-id": "value",
                        "--workflow-template": "value"
                      }
                    },
                    "hive": {
                      "commands": {},
                      "flags": {
                        "--continue-on-failure": "bool",
                        "--execute": "value",
                        "--file": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--params": "value",
                        "--properties": "value",
                        "--region": "value",
                        "--start-after": "value",
                        "--step-id": "value",
                        "--workflow-template": "value"
                      }
                    },
                    "pig": {
                      "commands": {},
                      "flags": {
                        "--continue-on-failure": "bool",
                        "--driver-log-levels": "value",
                        "--execute": "value",
                        "--file": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--params": "value",
                        "--properties": "value",
                        "--region": "value",
                        "--start-after": "value",
                        "--step-id": "value",
                        "--workflow-template": "value"
                      }
                    },
                    "presto": {
                      "commands": {},
                      "flags": {
                        "--client-tags": "value",
                        "--continue-on-failure": "bool",
                        "--driver-log-levels": "value",
                        "--execute": "value",
                        "--file": "value",
                        "--labels": "value",
                        "--properties": "value",
                        "--query-output-format": "value",
                        "--region": "value",
                        "--start-after": "value",
                        "--step-id": "value",
                        "--workflow-template": "value"
                      }
                    },
                    "pyspark": {
                      "commands": {},
                      "flags": {
                        "--archives": "value",
                        "--driver-log-levels": "value",
                        "--files": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--properties": "value",
                        "--py-files": "value",
                        "--region": "value",
                        "--start-after": "value",
                        "--step-id": "value",
                        "--workflow-template": "value"
                      }
                    },
                    "spark": {
                      "commands": {},
                      "flags": {
                        "--archives": "value",
                        "--class": "value",
                        "--driver-log-levels": "value",
                        "--files": "value",
                        "--jar": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--properties": "value",
                        "--region": "value",
                        "--start-after": "value",
                        "--step-id": "value",
                        "--workflow-template": "value"
                      }
                    },
                    "spark-r": {
                      "commands": {},
                      "flags": {
                        "--archives": "value",
                        "--driver-log-levels": "value",
                        "--files": "value",
                        "--labels": "value",
                        "--properties": "value",
                        "--region": "value",
                        "--start-after": "value",
                        "--step-id": "value",
                        "--workflow-template": "value"
                      }
                    },
                    "spark-sql": {
                      "commands": {},
                      "flags": {
                        "--driver-log-levels": "value",
                        "--execute": "value",
                        "--file": "value",
                        "--jars": "value",
                        "--labels": "value",
                        "--params": "value",
                        "--properties": "value",
                        "--region": "value",
                        "--start-after": "value",
                        "--step-id": "value",
                        "--workflow-template": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--labels": "value",
                    "--region": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--region": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--source": "value"
                  }
                },
                "instantiate": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--parameters": "value",
                    "--region": "value"
                  }
                },
                "instantiate-from-file": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--file": "value",
                    "--region": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-job": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--step-id": "value"
                  }
                },
                "run": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "value"
                  }
                },
                "set-cluster-selector": {
                  "commands": {},
                  "flags": {
                    "--cluster-labels": "value",
                    "--region": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "set-managed-cluster": {
                  "commands": {},
                  "flags": {
                    "--autoscaling-policy": "value",
                    "--bucket": "value",
                    "--cluster-name": "value",
                    "--enable-component-gateway": "bool",
                    "--image": "value",
                    "--image-version": "value",
                    "--initialization-action-timeout": "value",
                    "--initialization-actions": "value",
                    "--kerberos-config-file": "value",
                    "--kerberos-kms-key": "dynamic",
                    "--kerberos-kms-key-keyring": "dynamic",
                    "--kerberos-kms-key-location": "dynamic",
                    "--kerberos-kms-key-project": "dynamic",
                    "--kerberos-root-principal-password-uri": "value",
                    "--labels": "value",
                    "--master-accelerator": "value",
                    "--master-boot-disk-size": "value",
                    "--master-boot-disk-type": "value",
                    "--master-machine-type": "value",
                    "--master-min-cpu-platform": "value",
                    "--metadata": "value",
                    "--network": "value",
                    "--no-address": "bool",
                    "--num-master-local-ssds": "value",
                    "--num-masters": "value",
                    "--num-preemptible-worker-local-ssds": "value",
                    "--num-preemptible-workers": "value",
                    "--num-worker-local-ssds": "value",
                    "--num-workers": "value",
                    "--optional-components": "value",
                    "--preemptible-worker-accelerator": "value",
                    "--preemptible-worker-boot-disk-size": "value",
                    "--preemptible-worker-boot-disk-type": "value",
                    "--properties": "value",
                    "--region": "value",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--single-node": "bool",
                    "--subnet": "value",
                    "--tags": "value",
                    "--worker-accelerator": "value",
                    "--worker-boot-disk-size": "value",
                    "--worker-boot-disk-type": "value",
                    "--worker-machine-type": "value",
                    "--worker-min-cpu-platform": "value",
                    "--zone": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "datastore": {
          "commands": {
            "export": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--kinds": "value",
                "--namespaces": "value",
                "--operation-labels": "value"
              }
            },
            "import": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--kinds": "value",
                "--namespaces": "value",
                "--operation-labels": "value"
              }
            },
            "indexes": {
              "commands": {
                "cleanup": {
                  "commands": {},
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "deployment-manager": {
          "commands": {
            "deployments": {
              "commands": {
                "cancel-preview": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--fingerprint": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--automatic-rollback-on-error": "bool",
                    "--composite-type": "value",
                    "--config": "value",
                    "--create-policy": [
                      "acquire",
                      "create",
                      "create-or-acquire"
                    ],
                    "--credential": "value",
                    "--description": "value",
                    "--labels": "value",
                    "--preview": "bool",
                    "--properties": "value",
                    "--template": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--delete-policy": [
                      "abandon",
                      "delete"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--simple-list": "bool",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "stop": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--fingerprint": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--composite-type": "value",
                    "--config": "value",
                    "--create-policy": [
                      "acquire",
                      "create",
                      "create-or-acquire"
                    ],
                    "--credential": "value",
                    "--delete-policy": [
                      "abandon",
                      "delete"
                    ],
                    "--description": "value",
                    "--fingerprint": "value",
                    "--manifest-id": "value",
                    "--preview": "bool",
                    "--properties": "value",
                    "--remove-labels": "value",
                    "--template": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "manifests": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--deployment": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--deployment": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--simple-list": "bool",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--simple-list": "bool",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "resources": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--deployment": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--deployment": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--simple-list": "bool",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {
                "--deployment": "value"
              }
            },
            "type-providers": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--api-options-file": "value",
                    "--async": "bool",
                    "--description": "value",
                    "--descriptor-url": "value",
                    "--labels": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--api-options-file": "value",
                    "--async": "bool",
                    "--description": "value",
                    "--descriptor-url": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "types": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--labels": "value",
                    "--status": [
                      "DEPRECATED",
                      "EXPERIMENTAL",
                      "SUPPORTED"
                    ],
                    "--template": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--provider": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--provider": "value",
                    "--provider-project": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--remove-labels": "value",
                    "--status": [
                      "DEPRECATED",
                      "EXPERIMENTAL",
                      "SUPPORTED"
                    ],
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "dialogflow": {
          "commands": {
            "agent": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--replace-all": "bool",
                    "--source": "value"
                  }
                },
                "query": {
                  "commands": {},
                  "flags": {
                    "--audio-encoding": [
                      "audio-encoding-amr",
                      "audio-encoding-amr-wb",
                      "audio-encoding-flac",
                      "audio-encoding-linear-16",
                      "audio-encoding-mulaw",
                      "audio-encoding-ogg-opus",
                      "audio-encoding-speex-with-header-byte",
                      "audio-encoding-unspecified"
                    ],
                    "--language": "value",
                    "--query-audio-file": "value",
                    "--query-text": "value",
                    "--sample-rate": "value",
                    "--session": "value"
                  }
                },
                "train": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                }
              },
              "flags": {}
            },
            "entity-types": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--auto-expand": "bool",
                    "--display-name": "value",
                    "--entities": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-entities": "value",
                    "--auto-expand": "bool",
                    "--clear-entities": "bool",
                    "--display-name": "value",
                    "--remove-entities": "value"
                  }
                }
              },
              "flags": {}
            },
            "intents": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--display-name": "value",
                    "--is-fallback": "bool",
                    "--ml-enabled": "bool",
                    "--other-properties": "value",
                    "--priority": "value",
                    "--responses": "value",
                    "--training-phrases": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--is-fallback": "bool",
                    "--ml-enabled": "bool",
                    "--other-properties": "value",
                    "--priority": "value",
                    "--responses": "value",
                    "--training-phrases": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "dlp": {
          "commands": {
            "datasources": {
              "commands": {
                "bigquery": {
                  "commands": {
                    "analyze": {
                      "commands": {},
                      "flags": {
                        "--categorical-stat-field": "value",
                        "--job-id": "value",
                        "--numerical-stat-field": "value",
                        "--output-table": "value",
                        "--output-topics": "value",
                        "--quasi-ids": "value",
                        "--sensitive-attribute": "value"
                      }
                    },
                    "inspect": {
                      "commands": {},
                      "flags": {
                        "--exclude-info-types": "bool",
                        "--identifying-fields": "value",
                        "--include-quote": "bool",
                        "--info-types": "value",
                        "--job-id": "value",
                        "--max-findings": "value",
                        "--max-findings-per-item": "value",
                        "--max-time": "value",
                        "--min-likelihood": [
                          "likely",
                          "possible",
                          "unlikely",
                          "very-likely",
                          "very-unlikely"
                        ],
                        "--min-time": "value",
                        "--output-table": "value",
                        "--output-topics": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "datastore": {
                  "commands": {
                    "inspect": {
                      "commands": {},
                      "flags": {
                        "--exclude-info-types": "bool",
                        "--include-quote": "bool",
                        "--info-types": "value",
                        "--job-id": "value",
                        "--max-findings": "value",
                        "--max-findings-per-item": "value",
                        "--max-time": "value",
                        "--min-likelihood": [
                          "likely",
                          "possible",
                          "unlikely",
                          "very-likely",
                          "very-unlikely"
                        ],
                        "--min-time": "value",
                        "--output-table": "value",
                        "--output-topics": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "gcs": {
                  "commands": {
                    "inspect": {
                      "commands": {},
                      "flags": {
                        "--exclude-info-types": "bool",
                        "--file-size-limit": "value",
                        "--include-quote": "bool",
                        "--info-types": "value",
                        "--job-id": "value",
                        "--max-findings": "value",
                        "--max-findings-per-item": "value",
                        "--max-time": "value",
                        "--min-likelihood": [
                          "likely",
                          "possible",
                          "unlikely",
                          "very-likely",
                          "very-unlikely"
                        ],
                        "--min-time": "value",
                        "--output-table": "value",
                        "--output-topics": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "images": {
              "commands": {
                "inspect": {
                  "commands": {},
                  "flags": {
                    "--exclude-info-types": "bool",
                    "--include-quote": "bool",
                    "--info-types": "value",
                    "--max-findings": "value",
                    "--min-likelihood": [
                      "likely",
                      "possible",
                      "unlikely",
                      "very-likely",
                      "very-unlikely"
                    ]
                  }
                },
                "redact": {
                  "commands": {},
                  "flags": {
                    "--include-quote": "bool",
                    "--info-types": "value",
                    "--min-likelihood": [
                      "likely",
                      "possible",
                      "unlikely",
                      "very-likely",
                      "very-unlikely"
                    ],
                    "--output-file": "value",
                    "--redact-all-text": "bool",
                    "--redact-color": "value"
                  }
                }
              },
              "flags": {}
            },
            "job-triggers": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--datastore-kind": "value",
                    "--description": "value",
                    "--display-name": "value",
                    "--exclude-info-types": "bool",
                    "--include-quote": "bool",
                    "--info-types": "value",
                    "--input-table": "value",
                    "--max-findings": "value",
                    "--max-findings-per-item": "value",
                    "--min-likelihood": [
                      "likely",
                      "possible",
                      "unlikely",
                      "very-likely",
                      "very-unlikely"
                    ],
                    "--output-table": "value",
                    "--output-topics": "value",
                    "--path": "value",
                    "--trigger-schedule": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "jobs": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--job-type": [
                      "inspect",
                      "risk-analysis"
                    ],
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "text": {
              "commands": {
                "inspect": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--exclude-info-types": "bool",
                    "--include-quote": "bool",
                    "--info-types": "value",
                    "--max-findings": "value",
                    "--min-likelihood": [
                      "likely",
                      "possible",
                      "unlikely",
                      "very-likely",
                      "very-unlikely"
                    ]
                  }
                },
                "redact": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--info-types": "value",
                    "--min-likelihood": [
                      "likely",
                      "possible",
                      "unlikely",
                      "very-likely",
                      "very-unlikely"
                    ],
                    "--output-file": "value",
                    "--remove-findings": "bool",
                    "--replace-with-info-type": "bool",
                    "--replacement-text": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "dns": {
          "commands": {
            "active-peering-zones": {
              "commands": {},
              "flags": {}
            },
            "dns-keys": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--sort-by": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "managed-zones": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--denial-of-existence": [
                      "nsec",
                      "nsec3"
                    ],
                    "--description": "value",
                    "--dns-name": "value",
                    "--dnssec-state": [
                      "off",
                      "on",
                      "transfer"
                    ],
                    "--forwarding-targets": "value",
                    "--ksk-algorithm": [
                      "ecdsap256sha256",
                      "ecdsap384sha384",
                      "rsasha1",
                      "rsasha256",
                      "rsasha512"
                    ],
                    "--ksk-key-length": "value",
                    "--labels": "value",
                    "--managed-reverse-lookup": "bool",
                    "--networks": "value",
                    "--private-forwarding-targets": "value",
                    "--target-network": "value",
                    "--target-project": "value",
                    "--visibility": [
                      "private",
                      "public"
                    ],
                    "--zsk-algorithm": [
                      "ecdsap256sha256",
                      "ecdsap384sha384",
                      "rsasha1",
                      "rsasha256",
                      "rsasha512"
                    ],
                    "--zsk-key-length": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--denial-of-existence": [
                      "nsec",
                      "nsec3"
                    ],
                    "--description": "value",
                    "--dnssec-state": [
                      "off",
                      "on",
                      "transfer"
                    ],
                    "--forwarding-targets": "value",
                    "--ksk-algorithm": [
                      "ecdsap256sha256",
                      "ecdsap384sha384",
                      "rsasha1",
                      "rsasha256",
                      "rsasha512"
                    ],
                    "--ksk-key-length": "value",
                    "--managed-reverse-lookup": "bool",
                    "--networks": "value",
                    "--private-forwarding-targets": "value",
                    "--remove-labels": "value",
                    "--target-network": "value",
                    "--target-project": "value",
                    "--update-labels": "value",
                    "--zsk-algorithm": [
                      "ecdsap256sha256",
                      "ecdsap384sha384",
                      "rsasha1",
                      "rsasha256",
                      "rsasha512"
                    ],
                    "--zsk-key-length": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--sort-by": "value",
                    "--zones": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "policies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--alternative-name-servers": "value",
                    "--description": "value",
                    "--enable-inbound-forwarding": "bool",
                    "--enable-logging": "bool",
                    "--networks": "value",
                    "--private-alternative-name-servers": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--alternative-name-servers": "value",
                    "--description": "value",
                    "--enable-inbound-forwarding": "bool",
                    "--enable-logging": "bool",
                    "--networks": "value",
                    "--private-alternative-name-servers": "value"
                  }
                }
              },
              "flags": {}
            },
            "project-info": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "record-sets": {
              "commands": {
                "changes": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--sort-order": [
                          "ascending",
                          "descending"
                        ],
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic",
                    "--zone-file-format": "bool"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--delete-all-existing": "bool",
                    "--replace-origin-ns": "bool",
                    "--zone": "dynamic",
                    "--zone-file-format": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--name": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--type": "value",
                    "--uri": "bool",
                    "--zone": "dynamic"
                  }
                },
                "transaction": {
                  "commands": {
                    "abort": {
                      "commands": {},
                      "flags": {
                        "--transaction-file": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "add": {
                      "commands": {},
                      "flags": {
                        "--name": "value",
                        "--transaction-file": "value",
                        "--ttl": "value",
                        "--type": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--transaction-file": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "execute": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--transaction-file": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "remove": {
                      "commands": {},
                      "flags": {
                        "--name": "value",
                        "--transaction-file": "value",
                        "--ttl": "value",
                        "--type": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "start": {
                      "commands": {},
                      "flags": {
                        "--transaction-file": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {
                    "--transaction-file": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "domains": {
          "commands": {
            "registrations": {
              "commands": {
                "authorization-code": {
                  "commands": {
                    "get": {
                      "commands": {},
                      "flags": {}
                    },
                    "reset": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "check-availability": {
                  "commands": {},
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cloud-dns-zone": "value",
                    "--labels": "value",
                    "--name-servers": "value",
                    "--registrant-contact-from-file": "value",
                    "--validate-only": "bool",
                    "--whois-privacy": [
                      "publish-redacted-contact-data",
                      "use-whois-privacy-proxy"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "detach": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "operations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "wait": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "search-domains": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--cloud-dns-zone": "value",
                    "--name-servers": "value",
                    "--registrant-contact-from-file": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value",
                    "--validate-only": "bool",
                    "--whois-privacy": [
                      "publish-redacted-contact-data",
                      "use-whois-privacy-proxy"
                    ]
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "emulators": {
          "commands": {
            "bigtable": {
              "commands": {
                "env-init": {
                  "commands": {},
                  "flags": {}
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--host-port": "value"
                  }
                }
              },
              "flags": {}
            },
            "datastore": {
              "commands": {
                "env-init": {
                  "commands": {},
                  "flags": {
                    "--data-dir": "value"
                  }
                },
                "env-unset": {
                  "commands": {},
                  "flags": {
                    "--data-dir": "value"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--consistency": "value",
                    "--data-dir": "value",
                    "--host-port": "value",
                    "--store-on-disk": "bool"
                  }
                }
              },
              "flags": {
                "--data-dir": "value"
              }
            },
            "firestore": {
              "commands": {
                "start": {
                  "commands": {},
                  "flags": {
                    "--host-port": "value",
                    "--rules": "value"
                  }
                }
              },
              "flags": {}
            },
            "pubsub": {
              "commands": {
                "env-init": {
                  "commands": {},
                  "flags": {
                    "--data-dir": "value"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--data-dir": "value",
                    "--host-port": "value"
                  }
                }
              },
              "flags": {
                "--data-dir": "value"
              }
            },
            "start": {
              "commands": {},
              "flags": {
                "--emulators": "value",
                "--proxy-port": "value",
                "--route-to-public": "value"
              }
            }
          },
          "flags": {}
        },
        "endpoints": {
          "commands": {
            "configs": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--service": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--service": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--service": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "quota": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--consumer": "value",
                    "--dimensions": "value",
                    "--force": "bool",
                    "--metric": "value",
                    "--service": "value",
                    "--unit": "value",
                    "--value": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--consumer": "value",
                    "--force": "bool",
                    "--metric": "value",
                    "--override-id": "value",
                    "--service": "value",
                    "--unit": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--consumer": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--service": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--consumer": "value",
                    "--dimensions": "value",
                    "--force": "bool",
                    "--metric": "value",
                    "--override-id": "value",
                    "--service": "value",
                    "--unit": "value",
                    "--value": "value"
                  }
                }
              },
              "flags": {}
            },
            "services": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "check-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "deploy": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--force": "bool",
                    "--validate-only": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "undelete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "filestore": {
          "commands": {
            "instances": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--file-share": "value",
                    "--labels": "value",
                    "--location": "value",
                    "--network": "value",
                    "--tier": [
                      "premium",
                      "standard"
                    ],
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "value"
                  }
                }
              },
              "flags": {}
            },
            "locations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "value"
                  }
                }
              },
              "flags": {}
            },
            "regions": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "zones": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "firebase": {
          "commands": {
            "test": {
              "commands": {
                "android": {
                  "commands": {
                    "locales": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {}
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "models": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {}
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "run": {
                      "commands": {},
                      "flags": {
                        "--additional-apks": "value",
                        "--app": "value",
                        "--app-package": "value",
                        "--async": "bool",
                        "--auto-google-login": "bool",
                        "--client-details": "value",
                        "--device": "value",
                        "--device-ids": "value",
                        "--directories-to-pull": "value",
                        "--environment-variables": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--locales": "value",
                        "--network-profile": "value",
                        "--num-flaky-test-attempts": "value",
                        "--num-uniform-shards": "value",
                        "--obb-files": "value",
                        "--orientations": "dynamic",
                        "--os-version-ids": "value",
                        "--other-files": "value",
                        "--page-size": "value",
                        "--performance-metrics": "bool",
                        "--record-video": "bool",
                        "--results-bucket": "value",
                        "--results-dir": "value",
                        "--results-history-name": "value",
                        "--robo-directives": "value",
                        "--robo-script": "value",
                        "--scenario-labels": "value",
                        "--scenario-numbers": "value",
                        "--sort-by": "value",
                        "--test": "value",
                        "--test-package": "value",
                        "--test-runner-class": "value",
                        "--test-targets": "value",
                        "--test-targets-for-shard": "value",
                        "--timeout": "value",
                        "--type": [
                          "game-loop",
                          "instrumentation",
                          "robo"
                        ],
                        "--use-orchestrator": "bool"
                      }
                    },
                    "versions": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {}
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "ios": {
                  "commands": {
                    "locales": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {}
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "models": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {}
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "run": {
                      "commands": {},
                      "flags": {
                        "--app": "value",
                        "--async": "bool",
                        "--client-details": "value",
                        "--device": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--num-flaky-test-attempts": "value",
                        "--page-size": "value",
                        "--record-video": "bool",
                        "--results-bucket": "value",
                        "--results-dir": "value",
                        "--results-history-name": "value",
                        "--scenario-numbers": "value",
                        "--sort-by": "value",
                        "--test": "value",
                        "--timeout": "value",
                        "--type": [
                          "game-loop",
                          "xctest"
                        ],
                        "--xcode-version": "value",
                        "--xctestrun-file": "value"
                      }
                    },
                    "versions": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {}
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "network-profiles": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "firestore": {
          "commands": {
            "databases": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                }
              },
              "flags": {}
            },
            "export": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--collection-ids": "value"
              }
            },
            "import": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--collection-ids": "value"
              }
            },
            "indexes": {
              "commands": {
                "composite": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--collection-group": "value",
                        "--field-config": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {}
                    },
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "fields": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--collection-group": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--collection-group": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--clear-exemption": "bool",
                        "--collection-group": "value",
                        "--disable-indexes": "bool",
                        "--index": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "functions": {
          "commands": {
            "add-iam-policy-binding": {
              "commands": {},
              "flags": {
                "--member": "value",
                "--region": "dynamic",
                "--role": "value"
              }
            },
            "call": {
              "commands": {},
              "flags": {
                "--data": "value",
                "--region": "dynamic"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "deploy": {
              "commands": {},
              "flags": {
                "--allow-unauthenticated": "bool",
                "--clear-env-vars": "bool",
                "--clear-labels": "bool",
                "--clear-max-instances": "bool",
                "--clear-vpc-connector": "bool",
                "--egress-settings": [
                  "all",
                  "private-ranges-only"
                ],
                "--entry-point": "value",
                "--env-vars-file": "value",
                "--ignore-file": "value",
                "--ingress-settings": [
                  "all",
                  "internal-only"
                ],
                "--max-instances": "value",
                "--memory": "value",
                "--region": "dynamic",
                "--remove-env-vars": "value",
                "--remove-labels": "value",
                "--retry": "bool",
                "--runtime": "value",
                "--service-account": "value",
                "--set-env-vars": "value",
                "--source": "value",
                "--stage-bucket": "value",
                "--timeout": "value",
                "--trigger-bucket": "value",
                "--trigger-event": "value",
                "--trigger-http": "bool",
                "--trigger-resource": "value",
                "--trigger-topic": "value",
                "--update-env-vars": "value",
                "--update-labels": "value",
                "--vpc-connector": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "event-types": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "get-iam-policy": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "dynamic",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--regions": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "logs": {
              "commands": {
                "read": {
                  "commands": {},
                  "flags": {
                    "--end-time": "value",
                    "--execution-id": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--min-log-level": [
                      "debug",
                      "error",
                      "info"
                    ],
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--start-time": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "regions": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "remove-iam-policy-binding": {
              "commands": {},
              "flags": {
                "--member": "value",
                "--region": "dynamic",
                "--role": "value"
              }
            },
            "set-iam-policy": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            }
          },
          "flags": {}
        },
        "game": {
          "commands": {
            "locations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "servers": {
              "commands": {
                "allocation-policies": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--labels": "value",
                        "--location": "value",
                        "--match-clusters": "value",
                        "--priority": "value",
                        "--schedule": "value",
                        "--weight": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--clear-labels": "bool",
                        "--clear-match-clusters": "bool",
                        "--location": "value",
                        "--match-clusters": "value",
                        "--priority": "value",
                        "--remove-labels": "value",
                        "--schedule": "value",
                        "--update-labels": "value",
                        "--weight": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "clusters": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--dry-run": "bool",
                        "--gke-cluster": "value",
                        "--labels": "value",
                        "--location": "value",
                        "--namespace": "value",
                        "--preview-time": "value",
                        "--realm": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--dry-run": "bool",
                        "--location": "value",
                        "--preview-time": "value",
                        "--realm": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--realm": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--realm": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--clear-labels": "bool",
                        "--dry-run": "bool",
                        "--location": "value",
                        "--preview-time": "value",
                        "--realm": "value",
                        "--remove-labels": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "configs": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--deployment": "value",
                        "--description": "value",
                        "--fleet-configs-file": "value",
                        "--labels": "value",
                        "--location": "value",
                        "--scaling-configs-file": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--deployment": "value",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--deployment": "value",
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--deployment": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "deployments": {
                  "commands": {
                    "commit-rollout": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "value"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--description": "value",
                        "--labels": "value",
                        "--location": "value",
                        "--spec-file": "value",
                        "--template-id": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "describe-rollout": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "revert-rollout": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "value"
                      }
                    },
                    "set-rollout-target": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "value",
                        "--selector": "value"
                      }
                    },
                    "start-rollout": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--description": "value",
                        "--location": "value",
                        "--spec-file": "value",
                        "--template-id": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--clear-labels": "bool",
                        "--location": "value",
                        "--remove-labels": "value",
                        "--update-labels": "value"
                      }
                    },
                    "update-rollout": {
                      "commands": {},
                      "flags": {
                        "--clear-config-overrides": "bool",
                        "--config-overrides-file": "value",
                        "--default-config": "value",
                        "--dry-run": "bool",
                        "--location": "value",
                        "--preview-time": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "realms": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--labels": "value",
                        "--location": "value",
                        "--time-zone": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--clear-labels": "bool",
                        "--dry-run": "bool",
                        "--location": "value",
                        "--preview-time": "value",
                        "--remove-labels": "value",
                        "--time-zone": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "scaling-policies": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--buffer-size": "value",
                        "--buffer-size-percent": "value",
                        "--deployment": "value",
                        "--labels": "value",
                        "--location": "value",
                        "--match-clusters": "value",
                        "--max-replicas": "value",
                        "--min-replicas": "value",
                        "--priority": "value",
                        "--schedule": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--buffer-size": "value",
                        "--buffer-size-percent": "value",
                        "--clear-labels": "bool",
                        "--clear-match-clusters": "bool",
                        "--location": "value",
                        "--match-clusters": "value",
                        "--max-replicas": "value",
                        "--min-replicas": "value",
                        "--priority": "value",
                        "--remove-labels": "value",
                        "--schedule": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "genomics": {
          "commands": {
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--where": "value"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "pipelines": {
              "commands": {
                "run": {
                  "commands": {},
                  "flags": {
                    "--boot-disk-size": "value",
                    "--command-line": "value",
                    "--cpus": "value",
                    "--disk-size": "value",
                    "--docker-image": "value",
                    "--env-vars": "value",
                    "--inputs": "value",
                    "--inputs-from-file": "value",
                    "--labels": "value",
                    "--logging": "value",
                    "--memory": "value",
                    "--network": "value",
                    "--outputs": "value",
                    "--pipeline-file": "value",
                    "--preemptible": "bool",
                    "--regions": "value",
                    "--service-account-email": "value",
                    "--service-account-scopes": "value",
                    "--subnetwork": "value",
                    "--zones": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "healthcare": {
          "commands": {
            "annotation-stores": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "evaluate": {
                  "commands": {
                    "bq": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--bq-table": "value",
                        "--dataset": "value",
                        "--golden-store": "value",
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "export": {
                  "commands": {
                    "bq": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--bq-table": "value",
                        "--dataset": "value",
                        "--location": "value"
                      }
                    },
                    "gcs": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--dataset": "value",
                        "--gcs-uri": "value",
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "import": {
                  "commands": {
                    "gcs": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--dataset": "value",
                        "--gcs-uri": "value",
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            },
            "datasets": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--time-zone": "value"
                  }
                },
                "deidentify": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--default-fhir-config": "bool",
                    "--destination-dataset": "value",
                    "--dicom-filter-tags": "value",
                    "--location": "value",
                    "--text-redaction-mode": [
                      "all"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--time-zone": "value"
                  }
                }
              },
              "flags": {}
            },
            "dicom-stores": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value",
                    "--pubsub-topic": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "export": {
                  "commands": {
                    "bq": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--bq-table": "value",
                        "--dataset": "value",
                        "--location": "value",
                        "--overwrite-table": "bool"
                      }
                    },
                    "gcs": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--dataset": "value",
                        "--gcs-uri-prefix": "value",
                        "--location": "value",
                        "--mime-type": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "import": {
                  "commands": {
                    "gcs": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--dataset": "value",
                        "--gcs-uri": "value",
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value",
                    "--pubsub-topic": "value"
                  }
                }
              },
              "flags": {}
            },
            "fhir-stores": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--disable-referential-integrity": "bool",
                    "--disable-resource-versioning": "bool",
                    "--enable-update-create": "bool",
                    "--location": "value",
                    "--pubsub-topic": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "export": {
                  "commands": {
                    "bq": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--bq-dataset": "value",
                        "--dataset": "value",
                        "--location": "value",
                        "--recursive-depth": "value",
                        "--schema-type": [
                          "analytics",
                          "lossless"
                        ]
                      }
                    },
                    "gcs": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--dataset": "value",
                        "--gcs-uri": "value",
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "import": {
                  "commands": {
                    "gcs": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--content-structure": [
                          "bundle",
                          "bundle-pretty",
                          "resource",
                          "resource-pretty"
                        ],
                        "--dataset": "value",
                        "--error-gcs-uri": "value",
                        "--gcs-uri": "value",
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--enable-update-create": "bool",
                    "--location": "value",
                    "--pubsub-topic": "value"
                  }
                }
              },
              "flags": {}
            },
            "hl7v2-stores": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value",
                    "--pubsub-topic": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--dataset": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value",
                    "--pubsub-topic": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--dataset": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "help": {
          "commands": {},
          "flags": {
            "--filter": "value",
            "--limit": "value",
            "--page-size": "value",
            "--sort-by": "value"
          }
        },
        "iam": {
          "commands": {
            "list-grantable-roles": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--page-size": "value"
              }
            },
            "list-testable-permissions": {
              "commands": {},
              "flags": {
                "--filter": "value"
              }
            },
            "policies": {
              "commands": {
                "lint-condition": {
                  "commands": {},
                  "flags": {
                    "--condition-from-file": "value",
                    "--description": "value",
                    "--expression": "value",
                    "--resource-name": "value",
                    "--title": "value"
                  }
                }
              },
              "flags": {}
            },
            "roles": {
              "commands": {
                "copy": {
                  "commands": {},
                  "flags": {
                    "--dest-organization": "value",
                    "--dest-project": "value",
                    "--destination": "value",
                    "--source": "value",
                    "--source-organization": "value",
                    "--source-project": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--file": "value",
                    "--organization": "value",
                    "--permissions": "value",
                    "--stage": "value",
                    "--title": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--show-deleted": "bool",
                    "--sort-by": "value"
                  }
                },
                "undelete": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-permissions": "value",
                    "--description": "value",
                    "--file": "value",
                    "--organization": "value",
                    "--permissions": "value",
                    "--remove-permissions": "value",
                    "--stage": "value",
                    "--title": "value"
                  }
                }
              },
              "flags": {}
            },
            "service-accounts": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "disable": {
                  "commands": {},
                  "flags": {}
                },
                "enable": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "keys": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--iam-account": "value",
                        "--key-file-type": [
                          "json",
                          "p12"
                        ]
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--iam-account": "value"
                      }
                    },
                    "get-public-key": {
                      "commands": {},
                      "flags": {
                        "--iam-account": "value",
                        "--output-file": "value",
                        "--type": [
                          "pem",
                          "raw"
                        ]
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--created-before": "value",
                        "--filter": "value",
                        "--iam-account": "value",
                        "--limit": "value",
                        "--managed-by": [
                          "any",
                          "system",
                          "user"
                        ],
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "upload": {
                      "commands": {},
                      "flags": {
                        "--iam-account": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "sign-blob": {
                  "commands": {},
                  "flags": {
                    "--iam-account": "value"
                  }
                },
                "sign-jwt": {
                  "commands": {},
                  "flags": {
                    "--iam-account": "value"
                  }
                },
                "undelete": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "iap": {
          "commands": {
            "web": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--resource-type": [
                      "app-engine",
                      "backend-services"
                    ],
                    "--role": "value",
                    "--service": "value"
                  }
                },
                "disable": {
                  "commands": {},
                  "flags": {
                    "--resource-type": [
                      "app-engine",
                      "backend-services"
                    ],
                    "--service": "value"
                  }
                },
                "enable": {
                  "commands": {},
                  "flags": {
                    "--oauth2-client-id": "value",
                    "--oauth2-client-secret": "value",
                    "--resource-type": [
                      "app-engine",
                      "backend-services"
                    ],
                    "--service": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--resource-type": [
                      "app-engine",
                      "backend-services"
                    ],
                    "--service": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--resource-type": [
                      "app-engine",
                      "backend-services"
                    ],
                    "--role": "value",
                    "--service": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--resource-type": [
                      "app-engine",
                      "backend-services"
                    ],
                    "--service": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "identity": {
          "commands": {
            "groups": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--dynamic-user-query": "value",
                    "--labels": "value",
                    "--organization": "value",
                    "--with-initial-owner": [
                      "initial-group-config-unspecified",
                      "with-initial-owner"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "memberships": {
                  "commands": {
                    "add": {
                      "commands": {},
                      "flags": {
                        "--expiration": "value",
                        "--group-email": "value",
                        "--member-email": "value",
                        "--organization": "value",
                        "--roles": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--group-email": "value",
                        "--member-email": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--group-email": "value",
                        "--member-email": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--group-email": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--page-token": "value",
                        "--sort-by": "value",
                        "--view": [
                          "basic",
                          "full"
                        ]
                      }
                    },
                    "modify-membership-roles": {
                      "commands": {},
                      "flags": {
                        "--add-roles": "value",
                        "--group-email": "value",
                        "--member-email": "value",
                        "--remove-roles": "value",
                        "--update-roles-params": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "preview": {
                  "commands": {},
                  "flags": {
                    "--custom-field-mask": "value",
                    "--customer": "value",
                    "--max-results": "value",
                    "--page-token": "value",
                    "--projection": [
                      "basic",
                      "custom",
                      "full"
                    ],
                    "--query": "value",
                    "--view-type": [
                      "admin-view",
                      "domain-public"
                    ]
                  }
                },
                "search": {
                  "commands": {},
                  "flags": {
                    "--labels": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--page-token": "value",
                    "--view": [
                      "basic",
                      "full"
                    ]
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-description": "bool",
                    "--clear-display-name": "bool",
                    "--description": "value",
                    "--display-name": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "init": {
          "commands": {},
          "flags": {
            "--console-only": "bool",
            "--skip-diagnostics": "bool"
          }
        },
        "interactive": {
          "commands": {},
          "flags": {
            "--context": "value"
          }
        },
        "iot": {
          "commands": {
            "devices": {
              "commands": {
                "commands": {
                  "commands": {
                    "send": {
                      "commands": {},
                      "flags": {
                        "--command-data": "value",
                        "--command-file": "value",
                        "--device": "dynamic",
                        "--region": "value",
                        "--registry": "dynamic",
                        "--subfolder": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "configs": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "get-value": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--registry": "dynamic",
                        "--sort-by": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--config-data": "value",
                        "--config-file": "value",
                        "--device": "dynamic",
                        "--region": "value",
                        "--registry": "dynamic",
                        "--version-to-update": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--auth-method": [
                      "association-and-device-auth-token",
                      "association-only",
                      "device-auth-token-only"
                    ],
                    "--blocked": "bool",
                    "--device-type": [
                      "gateway",
                      "non-gateway"
                    ],
                    "--log-level": [
                      "debug",
                      "error",
                      "info",
                      "none"
                    ],
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--public-key": "value",
                    "--region": "value",
                    "--registry": "dynamic"
                  }
                },
                "credentials": {
                  "commands": {
                    "clear": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--expiration-time": "value",
                        "--path": "value",
                        "--region": "value",
                        "--registry": "dynamic",
                        "--type": [
                          "es256",
                          "es256-pem",
                          "es256-x509-pem",
                          "rs256",
                          "rsa-pem",
                          "rsa-x509-pem"
                        ]
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--filter": "value",
                        "--limit": "value",
                        "--region": "value",
                        "--registry": "dynamic",
                        "--sort-by": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--expiration-time": "value",
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--registry": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--registry": "dynamic"
                  }
                },
                "gateways": {
                  "commands": {
                    "bind": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--device-region": "value",
                        "--device-registry": "dynamic",
                        "--gateway": "dynamic",
                        "--gateway-region": "value",
                        "--gateway-registry": "dynamic"
                      }
                    },
                    "list-bound-devices": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--gateway": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--registry": "dynamic",
                        "--sort-by": "value"
                      }
                    },
                    "unbind": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--device-region": "value",
                        "--device-registry": "dynamic",
                        "--gateway": "dynamic",
                        "--gateway-region": "value",
                        "--gateway-registry": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--device-ids": "value",
                    "--device-num-ids": "value",
                    "--device-type": [
                      "gateway",
                      "non-gateway"
                    ],
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--registry": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "states": {
                  "commands": {
                    "list": {
                      "commands": {},
                      "flags": {
                        "--device": "dynamic",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--registry": "dynamic",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--auth-method": [
                      "association-and-device-auth-token",
                      "association-only",
                      "device-auth-token-only"
                    ],
                    "--blocked": "bool",
                    "--log-level": [
                      "debug",
                      "error",
                      "info",
                      "none"
                    ],
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--region": "value",
                    "--registry": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "registries": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--region": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--enable-http-config": "bool",
                    "--enable-mqtt-config": "bool",
                    "--event-notification-config": "value",
                    "--log-level": [
                      "debug",
                      "error",
                      "info",
                      "none"
                    ],
                    "--public-key-path": "value",
                    "--region": "value",
                    "--state-pubsub-topic": "value"
                  }
                },
                "credentials": {
                  "commands": {
                    "clear": {
                      "commands": {},
                      "flags": {
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--path": "value",
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "value",
                        "--registry": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--region": "value",
                        "--registry": "dynamic",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--region": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--enable-http-config": "bool",
                    "--enable-mqtt-config": "bool",
                    "--event-notification-config": "value",
                    "--log-level": [
                      "debug",
                      "error",
                      "info",
                      "none"
                    ],
                    "--region": "value",
                    "--state-pubsub-topic": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "kms": {
          "commands": {
            "asymmetric-decrypt": {
              "commands": {},
              "flags": {
                "--ciphertext-file": "value",
                "--key": "dynamic",
                "--keyring": "dynamic",
                "--location": "dynamic",
                "--plaintext-file": "value"
              }
            },
            "asymmetric-sign": {
              "commands": {},
              "flags": {
                "--digest-algorithm": [
                  "sha256",
                  "sha384",
                  "sha512"
                ],
                "--input-file": "value",
                "--key": "dynamic",
                "--keyring": "dynamic",
                "--location": "dynamic",
                "--signature-file": "value"
              }
            },
            "decrypt": {
              "commands": {},
              "flags": {
                "--additional-authenticated-data-file": "value",
                "--ciphertext-file": "value",
                "--key": "dynamic",
                "--keyring": "dynamic",
                "--location": "dynamic",
                "--plaintext-file": "value"
              }
            },
            "encrypt": {
              "commands": {},
              "flags": {
                "--additional-authenticated-data-file": "value",
                "--ciphertext-file": "value",
                "--key": "dynamic",
                "--keyring": "dynamic",
                "--location": "dynamic",
                "--plaintext-file": "value"
              }
            },
            "import-jobs": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--keyring": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--import-method": [
                      "rsa-oaep-3072-sha1-aes-256",
                      "rsa-oaep-4096-sha1-aes-256"
                    ],
                    "--keyring": "dynamic",
                    "--location": "dynamic",
                    "--protection-level": [
                      "hsm",
                      "software"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--attestation-file": "value",
                    "--keyring": "dynamic",
                    "--location": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--keyring": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--keyring": "dynamic",
                    "--limit": "value",
                    "--location": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--keyring": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--keyring": "value",
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            },
            "keyrings": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "keys": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--keyring": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--default-algorithm": [
                      "ec-sign-p256-sha256",
                      "ec-sign-p384-sha384",
                      "external-symmetric-encryption",
                      "google-symmetric-encryption",
                      "rsa-decrypt-oaep-2048-sha256",
                      "rsa-decrypt-oaep-3072-sha256",
                      "rsa-decrypt-oaep-4096-sha256",
                      "rsa-decrypt-oaep-4096-sha512",
                      "rsa-sign-pkcs1-2048-sha256",
                      "rsa-sign-pkcs1-3072-sha256",
                      "rsa-sign-pkcs1-4096-sha256",
                      "rsa-sign-pkcs1-4096-sha512",
                      "rsa-sign-pss-2048-sha256",
                      "rsa-sign-pss-3072-sha256",
                      "rsa-sign-pss-4096-sha256",
                      "rsa-sign-pss-4096-sha512"
                    ],
                    "--keyring": "dynamic",
                    "--labels": "value",
                    "--location": "dynamic",
                    "--next-rotation-time": "value",
                    "--protection-level": [
                      "external",
                      "hsm",
                      "software"
                    ],
                    "--purpose": [
                      "asymmetric-encryption",
                      "asymmetric-signing",
                      "encryption"
                    ],
                    "--rotation-period": "value",
                    "--skip-initial-version-creation": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--keyring": "dynamic",
                    "--location": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--keyring": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--keyring": "dynamic",
                    "--limit": "value",
                    "--location": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--keyring": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "remove-rotation-schedule": {
                  "commands": {},
                  "flags": {
                    "--keyring": "dynamic",
                    "--location": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--keyring": "value",
                    "--location": "value"
                  }
                },
                "set-primary-version": {
                  "commands": {},
                  "flags": {
                    "--keyring": "dynamic",
                    "--location": "dynamic"
                  }
                },
                "set-rotation-schedule": {
                  "commands": {},
                  "flags": {
                    "--keyring": "dynamic",
                    "--location": "dynamic",
                    "--next-rotation-time": "value",
                    "--rotation-period": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--default-algorithm": [
                      "ec-sign-p256-sha256",
                      "ec-sign-p384-sha384",
                      "external-symmetric-encryption",
                      "google-symmetric-encryption",
                      "rsa-decrypt-oaep-2048-sha256",
                      "rsa-decrypt-oaep-3072-sha256",
                      "rsa-decrypt-oaep-4096-sha256",
                      "rsa-decrypt-oaep-4096-sha512",
                      "rsa-sign-pkcs1-2048-sha256",
                      "rsa-sign-pkcs1-3072-sha256",
                      "rsa-sign-pkcs1-4096-sha256",
                      "rsa-sign-pkcs1-4096-sha512",
                      "rsa-sign-pss-2048-sha256",
                      "rsa-sign-pss-3072-sha256",
                      "rsa-sign-pss-4096-sha256",
                      "rsa-sign-pss-4096-sha512"
                    ],
                    "--keyring": "dynamic",
                    "--location": "dynamic",
                    "--next-rotation-time": "value",
                    "--primary-version": "dynamic",
                    "--remove-labels": "value",
                    "--remove-rotation-schedule": "bool",
                    "--rotation-period": "value",
                    "--update-labels": "value"
                  }
                },
                "versions": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--external-key-uri": "value",
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic",
                        "--primary": "bool"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--attestation-file": "value",
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic"
                      }
                    },
                    "destroy": {
                      "commands": {},
                      "flags": {
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic"
                      }
                    },
                    "disable": {
                      "commands": {},
                      "flags": {
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic"
                      }
                    },
                    "enable": {
                      "commands": {},
                      "flags": {
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic"
                      }
                    },
                    "get-public-key": {
                      "commands": {},
                      "flags": {
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic",
                        "--output-file": "value"
                      }
                    },
                    "import": {
                      "commands": {},
                      "flags": {
                        "--algorithm": [
                          "ec-sign-p256-sha256",
                          "ec-sign-p384-sha384",
                          "google-symmetric-encryption",
                          "rsa-decrypt-oaep-2048-sha256",
                          "rsa-decrypt-oaep-3072-sha256",
                          "rsa-decrypt-oaep-4096-sha256",
                          "rsa-decrypt-oaep-4096-sha512",
                          "rsa-sign-pkcs1-2048-sha256",
                          "rsa-sign-pkcs1-3072-sha256",
                          "rsa-sign-pkcs1-4096-sha256",
                          "rsa-sign-pkcs1-4096-sha512",
                          "rsa-sign-pss-2048-sha256",
                          "rsa-sign-pss-3072-sha256",
                          "rsa-sign-pss-4096-sha256",
                          "rsa-sign-pss-4096-sha512"
                        ],
                        "--import-job": "dynamic",
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic",
                        "--public-key-file": "value",
                        "--rsa-aes-wrapped-key-file": "value",
                        "--target-key-file": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--limit": "value",
                        "--location": "dynamic",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "restore": {
                      "commands": {},
                      "flags": {
                        "--key": "dynamic",
                        "--keyring": "dynamic",
                        "--location": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "locations": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "lifesciences": {
          "commands": {
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "pipelines": {
              "commands": {
                "run": {
                  "commands": {},
                  "flags": {
                    "--boot-disk-size": "value",
                    "--command-line": "value",
                    "--disk-size": "value",
                    "--docker-image": "value",
                    "--env-vars": "value",
                    "--inputs": "value",
                    "--inputs-from-file": "value",
                    "--labels": "value",
                    "--location": "dynamic",
                    "--logging": "value",
                    "--machine-type": "value",
                    "--network": "value",
                    "--outputs": "value",
                    "--pipeline-file": "value",
                    "--preemptible": "bool",
                    "--regions": "value",
                    "--service-account-email": "value",
                    "--service-account-scopes": "value",
                    "--subnetwork": "value",
                    "--zones": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "local": {
          "commands": {
            "dev": {
              "commands": {},
              "flags": {
                "--build-context-directory": "value",
                "--delete-minikube": "bool",
                "--dockerfile": "value",
                "--image-name": "value",
                "--kube-context": "value",
                "--minikube-profile": "value",
                "--service-account": "value",
                "--service-name": "value"
              }
            },
            "setup": {
              "commands": {},
              "flags": {
                "--build-context-directory": "value",
                "--dockerfile": "value",
                "--image-name": "value",
                "--kubernetes-file": "value",
                "--service-account": "value",
                "--service-name": "value",
                "--skaffold-file": "value"
              }
            }
          },
          "flags": {}
        },
        "logging": {
          "commands": {
            "buckets": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--location": "value",
                    "--retention-days": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--folder": "value",
                    "--location": "value",
                    "--organization": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--folder": "value",
                    "--location": "value",
                    "--organization": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--filter": "value",
                    "--folder": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--organization": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "undelete": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--folder": "value",
                    "--location": "value",
                    "--organization": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--location": "value",
                    "--retention-days": "value"
                  }
                }
              },
              "flags": {}
            },
            "logs": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "metrics": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--config-from-file": "value",
                    "--description": "value",
                    "--log-filter": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--config-from-file": "value",
                    "--description": "value",
                    "--log-filter": "value"
                  }
                }
              },
              "flags": {}
            },
            "read": {
              "commands": {},
              "flags": {
                "--billing-account": "value",
                "--folder": "value",
                "--freshness": "value",
                "--limit": "value",
                "--order": [
                  "asc",
                  "desc"
                ],
                "--organization": "dynamic"
              }
            },
            "resource-descriptors": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "sinks": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--description": "value",
                    "--disabled": "bool",
                    "--dlp-deidentify-template": "value",
                    "--dlp-inspect-template": "value",
                    "--exclusion": "value",
                    "--folder": "value",
                    "--include-children": "bool",
                    "--log-filter": "value",
                    "--organization": "dynamic",
                    "--use-partitioned-tables": "bool"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--folder": "value",
                    "--organization": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--folder": "value",
                    "--organization": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--filter": "value",
                    "--folder": "value",
                    "--limit": "value",
                    "--organization": "dynamic",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-exclusions": "value",
                    "--billing-account": "value",
                    "--clear-exclusions": "bool",
                    "--description": "value",
                    "--disabled": "bool",
                    "--dlp-deidentify-template": "value",
                    "--dlp-inspect-template": "value",
                    "--folder": "value",
                    "--log-filter": "value",
                    "--organization": "dynamic",
                    "--remove-exclusions": "value",
                    "--use-partitioned-tables": "bool"
                  }
                }
              },
              "flags": {}
            },
            "write": {
              "commands": {},
              "flags": {
                "--billing-account": "value",
                "--folder": "value",
                "--organization": "dynamic",
                "--payload-type": [
                  "json",
                  "text"
                ],
                "--severity": [
                  "ALERT",
                  "CRITICAL",
                  "DEBUG",
                  "DEFAULT",
                  "EMERGENCY",
                  "ERROR",
                  "INFO",
                  "NOTICE",
                  "WARNING"
                ]
              }
            }
          },
          "flags": {}
        },
        "ml": {
          "commands": {
            "language": {
              "commands": {
                "analyze-entities": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--content-type": [
                      "html",
                      "plain-text"
                    ],
                    "--encoding-type": [
                      "none",
                      "utf16",
                      "utf32",
                      "utf8"
                    ],
                    "--language": "value"
                  }
                },
                "analyze-entity-sentiment": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--content-type": [
                      "html",
                      "plain-text"
                    ],
                    "--encoding-type": [
                      "none",
                      "utf16",
                      "utf32",
                      "utf8"
                    ],
                    "--language": "value"
                  }
                },
                "analyze-sentiment": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--content-type": [
                      "html",
                      "plain-text"
                    ],
                    "--encoding-type": [
                      "none",
                      "utf16",
                      "utf32",
                      "utf8"
                    ],
                    "--language": "value"
                  }
                },
                "analyze-syntax": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--content-type": [
                      "html",
                      "plain-text"
                    ],
                    "--encoding-type": [
                      "none",
                      "utf16",
                      "utf32",
                      "utf8"
                    ],
                    "--language": "value"
                  }
                },
                "classify-text": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--content-type": [
                      "html",
                      "plain-text"
                    ],
                    "--language": "value"
                  }
                }
              },
              "flags": {}
            },
            "speech": {
              "commands": {
                "operations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "wait": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "recognize": {
                  "commands": {},
                  "flags": {
                    "--additional-language-codes": "value",
                    "--audio-channel-count": "value",
                    "--audio-topic": "value",
                    "--diarization-speaker-count": "value",
                    "--enable-automatic-punctuation": "bool",
                    "--enable-speaker-diarization": "bool",
                    "--encoding": [
                      "amr",
                      "amr-wb",
                      "encoding-unspecified",
                      "flac",
                      "linear16",
                      "mp3",
                      "mulaw",
                      "ogg-opus",
                      "speex-with-header-byte"
                    ],
                    "--filter-profanity": "bool",
                    "--hints": "value",
                    "--include-word-confidence": "bool",
                    "--include-word-time-offsets": "bool",
                    "--interaction-type": [
                      "dictation",
                      "discussion",
                      "phone-call",
                      "professionally-produced",
                      "voice-command",
                      "voice-search",
                      "voicemail"
                    ],
                    "--language-code": "value",
                    "--max-alternatives": "value",
                    "--microphone-distance": [
                      "farfield",
                      "midfield",
                      "nearfield"
                    ],
                    "--naics-code": "value",
                    "--original-media-type": [
                      "audio",
                      "video"
                    ],
                    "--original-mime-type": "value",
                    "--recording-device-name": "value",
                    "--recording-device-type": [
                      "indoor",
                      "outdoor",
                      "pc",
                      "phone-line",
                      "smartphone",
                      "vehicle"
                    ],
                    "--sample-rate": "value",
                    "--separate-channel-recognition": "bool"
                  }
                },
                "recognize-long-running": {
                  "commands": {},
                  "flags": {
                    "--additional-language-codes": "value",
                    "--async": "bool",
                    "--audio-channel-count": "value",
                    "--audio-topic": "value",
                    "--diarization-speaker-count": "value",
                    "--enable-automatic-punctuation": "bool",
                    "--enable-speaker-diarization": "bool",
                    "--encoding": [
                      "amr",
                      "amr-wb",
                      "encoding-unspecified",
                      "flac",
                      "linear16",
                      "mp3",
                      "mulaw",
                      "ogg-opus",
                      "speex-with-header-byte"
                    ],
                    "--filter-profanity": "bool",
                    "--hints": "value",
                    "--include-word-confidence": "bool",
                    "--include-word-time-offsets": "bool",
                    "--interaction-type": [
                      "dictation",
                      "discussion",
                      "phone-call",
                      "professionally-produced",
                      "voice-command",
                      "voice-search",
                      "voicemail"
                    ],
                    "--language-code": "value",
                    "--max-alternatives": "value",
                    "--microphone-distance": [
                      "farfield",
                      "midfield",
                      "nearfield"
                    ],
                    "--naics-code": "value",
                    "--original-media-type": [
                      "audio",
                      "video"
                    ],
                    "--original-mime-type": "value",
                    "--recording-device-name": "value",
                    "--recording-device-type": [
                      "indoor",
                      "outdoor",
                      "pc",
                      "phone-line",
                      "smartphone",
                      "vehicle"
                    ],
                    "--sample-rate": "value",
                    "--separate-channel-recognition": "bool"
                  }
                }
              },
              "flags": {}
            },
            "translate": {
              "commands": {
                "batch-translate-text": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--glossaries": "value",
                    "--models": "value",
                    "--source": "value",
                    "--source-language": "value",
                    "--target-language-codes": "value",
                    "--zone": "value"
                  }
                },
                "detect-language": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--mime-type": "value",
                    "--model": "value",
                    "--zone": "value"
                  }
                },
                "get-supported-languages": {
                  "commands": {},
                  "flags": {
                    "--display-language-code": "value",
                    "--model": "value",
                    "--zone": "value"
                  }
                },
                "translate-text": {
                  "commands": {},
                  "flags": {
                    "--content": "value",
                    "--content-file": "value",
                    "--glossary-config": "value",
                    "--mime-type": "value",
                    "--model": "value",
                    "--source-language": "value",
                    "--target-language": "value",
                    "--zone": "value"
                  }
                }
              },
              "flags": {}
            },
            "video": {
              "commands": {
                "detect-explicit-content": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--output-uri": "value",
                    "--region": [
                      "asia-east1",
                      "europe-west1",
                      "us-east1",
                      "us-west1"
                    ],
                    "--segments": "value"
                  }
                },
                "detect-labels": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--detection-mode": [
                      "frame",
                      "shot",
                      "shot-and-frame"
                    ],
                    "--output-uri": "value",
                    "--region": [
                      "asia-east1",
                      "europe-west1",
                      "us-east1",
                      "us-west1"
                    ],
                    "--segments": "value"
                  }
                },
                "detect-object": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--output-uri": "value",
                    "--region": [
                      "asia-east1",
                      "europe-west1",
                      "us-east1",
                      "us-west1"
                    ],
                    "--segments": "value"
                  }
                },
                "detect-shot-changes": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--output-uri": "value",
                    "--region": [
                      "asia-east1",
                      "europe-west1",
                      "us-east1",
                      "us-west1"
                    ],
                    "--segments": "value"
                  }
                },
                "detect-text": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--language-hints": "value",
                    "--output-uri": "value",
                    "--region": [
                      "asia-east1",
                      "europe-west1",
                      "us-east1",
                      "us-west1"
                    ],
                    "--segments": "value"
                  }
                },
                "operations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "wait": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "transcribe-speech": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--audio-tracks": "value",
                    "--diarization-speaker-count": "value",
                    "--enable-automatic-punctuation": "bool",
                    "--enable-speaker-diarization": "bool",
                    "--enable-word-confidence": "bool",
                    "--filter-profanity": "bool",
                    "--hints": "value",
                    "--language-code": "value",
                    "--max-alternatives": "value",
                    "--output-uri": "value",
                    "--region": [
                      "asia-east1",
                      "europe-west1",
                      "us-east1",
                      "us-west1"
                    ],
                    "--segments": "value"
                  }
                }
              },
              "flags": {}
            },
            "vision": {
              "commands": {
                "detect-document": {
                  "commands": {},
                  "flags": {
                    "--language-hints": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-faces": {
                  "commands": {},
                  "flags": {
                    "--max-results": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-image-properties": {
                  "commands": {},
                  "flags": {
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-labels": {
                  "commands": {},
                  "flags": {
                    "--max-results": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-landmarks": {
                  "commands": {},
                  "flags": {
                    "--max-results": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-logos": {
                  "commands": {},
                  "flags": {
                    "--max-results": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-objects": {
                  "commands": {},
                  "flags": {
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-product": {
                  "commands": {},
                  "flags": {
                    "--bounding-polygon": "value",
                    "--category": "value",
                    "--filter": "value",
                    "--max-results": "value",
                    "--product-set": "value",
                    "--product-set-location": "value"
                  }
                },
                "detect-safe-search": {
                  "commands": {},
                  "flags": {
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-text": {
                  "commands": {},
                  "flags": {
                    "--language-hints": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-text-pdf": {
                  "commands": {},
                  "flags": {
                    "--batch-size": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-text-tiff": {
                  "commands": {},
                  "flags": {
                    "--batch-size": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "detect-web": {
                  "commands": {},
                  "flags": {
                    "--include-geo-results": "bool",
                    "--max-results": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                },
                "operations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "product-search": {
                  "commands": {
                    "images": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--bounding-polygon": "value",
                            "--location": "value",
                            "--product": "value",
                            "--storage-location": "value"
                          }
                        },
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--location": "value",
                            "--product": "value"
                          }
                        },
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--location": "value",
                            "--product": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--location": "value",
                            "--page-size": "value",
                            "--product": "value",
                            "--sort-by": "value",
                            "--uri": "bool"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "product-sets": {
                      "commands": {
                        "add-product": {
                          "commands": {},
                          "flags": {
                            "--location": "value",
                            "--product": "value"
                          }
                        },
                        "create": {
                          "commands": {},
                          "flags": {
                            "--display-name": "value",
                            "--location": "value"
                          }
                        },
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--location": "value"
                          }
                        },
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--location": "value"
                          }
                        },
                        "import": {
                          "commands": {},
                          "flags": {
                            "--async": "bool",
                            "--location": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--location": "value",
                            "--page-size": "value",
                            "--sort-by": "value",
                            "--uri": "bool"
                          }
                        },
                        "list-products": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--location": "value",
                            "--page-size": "value",
                            "--product-set": "value",
                            "--sort-by": "value"
                          }
                        },
                        "remove-product": {
                          "commands": {},
                          "flags": {
                            "--location": "value",
                            "--product": "value"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--display-name": "value",
                            "--location": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "products": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--category": [
                              "apparel",
                              "homegoods",
                              "toys"
                            ],
                            "--description": "value",
                            "--display-name": "value",
                            "--location": "value",
                            "--product-labels": "value"
                          }
                        },
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--location": "value"
                          }
                        },
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--location": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--location": "value",
                            "--page-size": "value",
                            "--sort-by": "value",
                            "--uri": "bool"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--add-product-labels": "value",
                            "--clear-product-labels": "bool",
                            "--description": "value",
                            "--display-name": "value",
                            "--location": "value",
                            "--remove-product-labels": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "suggest-crop": {
                  "commands": {},
                  "flags": {
                    "--aspect-ratios": "value",
                    "--model-version": [
                      "builtin/latest",
                      "builtin/stable"
                    ]
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "ml-engine": {
          "commands": {
            "explain": {
              "commands": {},
              "flags": {
                "--json-instances": "value",
                "--model": "value",
                "--text-instances": "value"
              }
            },
            "jobs": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--summarize": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "stream-logs": {
                  "commands": {},
                  "flags": {
                    "--allow-multiline-logs": "bool",
                    "--polling-interval": "value",
                    "--task-name": "value"
                  }
                },
                "submit": {
                  "commands": {
                    "prediction": {
                      "commands": {},
                      "flags": {
                        "--accelerator-count": "value",
                        "--accelerator-type": [
                          "nvidia-tesla-k80",
                          "nvidia-tesla-p100"
                        ],
                        "--batch-size": "value",
                        "--data-format": [
                          "text",
                          "tf-record",
                          "tf-record-gzip"
                        ],
                        "--input-paths": "value",
                        "--labels": "value",
                        "--max-worker-count": "value",
                        "--model": "value",
                        "--model-dir": "value",
                        "--output-path": "value",
                        "--region": "value",
                        "--runtime-version": "value",
                        "--signature-name": "value"
                      }
                    },
                    "training": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--config": "value",
                        "--job-dir": "value",
                        "--labels": "value",
                        "--master-accelerator": "value",
                        "--master-image-uri": "value",
                        "--master-machine-type": "value",
                        "--module-name": "value",
                        "--package-path": "value",
                        "--packages": "value",
                        "--parameter-server-accelerator": "value",
                        "--parameter-server-count": "value",
                        "--parameter-server-image-uri": "value",
                        "--parameter-server-machine-type": "value",
                        "--python-version": "value",
                        "--region": "dynamic",
                        "--runtime-version": "value",
                        "--scale-tier": [
                          "basic",
                          "basic-gpu",
                          "basic-tpu",
                          "custom",
                          "premium-1",
                          "standard-1"
                        ],
                        "--staging-bucket": "value",
                        "--stream-logs": "bool",
                        "--tpu-tf-version": "value",
                        "--worker-accelerator": "value",
                        "--worker-count": "value",
                        "--worker-image-uri": "value",
                        "--worker-machine-type": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "local": {
              "commands": {
                "predict": {
                  "commands": {},
                  "flags": {
                    "--framework": [
                      "scikit-learn",
                      "tensorflow",
                      "xgboost"
                    ],
                    "--json-instances": "value",
                    "--model-dir": "value",
                    "--signature-name": "value",
                    "--text-instances": "value"
                  }
                },
                "train": {
                  "commands": {},
                  "flags": {
                    "--distributed": "bool",
                    "--job-dir": "value",
                    "--module-name": "value",
                    "--package-path": "value",
                    "--parameter-server-count": "value",
                    "--start-port": "value",
                    "--worker-count": "value"
                  }
                }
              },
              "flags": {}
            },
            "locations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "models": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--enable-console-logging": "bool",
                    "--enable-logging": "bool",
                    "--labels": "value",
                    "--regions": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "predict": {
              "commands": {},
              "flags": {
                "--json-instances": "value",
                "--model": "value",
                "--signature-name": "value",
                "--text-instances": "value"
              }
            },
            "versions": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--async": "bool",
                    "--config": "value",
                    "--description": "value",
                    "--explanation-method": [
                      "integrated-gradients",
                      "sampled-shapley"
                    ],
                    "--framework": [
                      "scikit-learn",
                      "tensorflow",
                      "xgboost"
                    ],
                    "--labels": "value",
                    "--machine-type": "value",
                    "--model": "value",
                    "--num-integral-steps": "value",
                    "--num-paths": "value",
                    "--origin": "value",
                    "--package-uris": "value",
                    "--prediction-class": "value",
                    "--python-version": "value",
                    "--runtime-version": "value",
                    "--service-account": "value",
                    "--staging-bucket": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--model": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--model": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--model": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-default": {
                  "commands": {},
                  "flags": {
                    "--model": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--model": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "monitoring": {
          "commands": {
            "channel-descriptors": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "channels": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--channel-content": "value",
                    "--channel-content-from-file": "value",
                    "--channel-labels": "value",
                    "--description": "value",
                    "--display-name": "value",
                    "--enabled": "bool",
                    "--type": "value",
                    "--user-labels": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--force": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--type": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--channel-content": "value",
                    "--channel-content-from-file": "value",
                    "--clear-channel-labels": "bool",
                    "--clear-user-labels": "bool",
                    "--description": "value",
                    "--display-name": "value",
                    "--enabled": "bool",
                    "--fields": "value",
                    "--remove-channel-labels": "value",
                    "--remove-user-labels": "value",
                    "--type": "value",
                    "--update-channel-labels": "value",
                    "--update-user-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "policies": {
              "commands": {
                "conditions": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--aggregation": "value",
                        "--condition": "value",
                        "--condition-display-name": "value",
                        "--condition-filter": "value",
                        "--condition-from-file": "value",
                        "--duration": "value",
                        "--if": "value",
                        "--trigger-count": "value",
                        "--trigger-percent": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--policy": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--policy": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--display-name": "value",
                        "--if": "value",
                        "--policy": "value",
                        "--trigger-count": "value",
                        "--trigger-percent": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--aggregation": "value",
                    "--combiner": [
                      "AND",
                      "AND_WITH_MATCHING_RESOURCE",
                      "COMBINE_UNSPECIFIED",
                      "OR"
                    ],
                    "--condition-display-name": "value",
                    "--condition-filter": "value",
                    "--display-name": "value",
                    "--documentation": "value",
                    "--documentation-format": "value",
                    "--documentation-from-file": "value",
                    "--duration": "value",
                    "--enabled": "bool",
                    "--if": "value",
                    "--notification-channels": "value",
                    "--policy": "value",
                    "--policy-from-file": "value",
                    "--trigger-count": "value",
                    "--trigger-percent": "value",
                    "--user-labels": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-notification-channels": "value",
                    "--clear-notification-channels": "bool",
                    "--clear-user-labels": "bool",
                    "--combiner": [
                      "AND",
                      "AND_WITH_MATCHING_RESOURCE",
                      "COMBINE_UNSPECIFIED",
                      "OR"
                    ],
                    "--display-name": "value",
                    "--documentation": "value",
                    "--documentation-format": "value",
                    "--documentation-from-file": "value",
                    "--enabled": "bool",
                    "--fields": "value",
                    "--policy": "value",
                    "--policy-from-file": "value",
                    "--remove-notification-channels": "value",
                    "--remove-user-labels": "value",
                    "--set-notification-channels": "value",
                    "--update-user-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "organizations": {
          "commands": {
            "add-iam-policy-binding": {
              "commands": {},
              "flags": {
                "--condition": "value",
                "--condition-from-file": "value",
                "--member": "value",
                "--role": "dynamic"
              }
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "get-iam-policy": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "remove-iam-policy-binding": {
              "commands": {},
              "flags": {
                "--all": "bool",
                "--condition": "value",
                "--condition-from-file": "value",
                "--member": "value",
                "--role": "dynamic"
              }
            },
            "set-iam-policy": {
              "commands": {},
              "flags": {}
            }
          },
          "flags": {}
        },
        "policy-troubleshoot": {
          "commands": {
            "iam": {
              "commands": {},
              "flags": {
                "--permission": "value",
                "--principal-email": "value"
              }
            }
          },
          "flags": {}
        },
        "projects": {
          "commands": {
            "add-iam-policy-binding": {
              "commands": {},
              "flags": {
                "--condition": "value",
                "--condition-from-file": "value",
                "--member": "value",
                "--role": "dynamic"
              }
            },
            "create": {
              "commands": {},
              "flags": {
                "--enable-cloud-apis": "bool",
                "--folder": "value",
                "--labels": "value",
                "--name": "value",
                "--organization": "value",
                "--set-as-default": "bool"
              }
            },
            "delete": {
              "commands": {},
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "get-ancestors": {
              "commands": {},
              "flags": {}
            },
            "get-iam-policy": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "move": {
              "commands": {},
              "flags": {
                "--folder": "value",
                "--organization": "value"
              }
            },
            "remove-iam-policy-binding": {
              "commands": {},
              "flags": {
                "--all": "bool",
                "--condition": "value",
                "--condition-from-file": "value",
                "--member": "value",
                "--role": "dynamic"
              }
            },
            "set-iam-policy": {
              "commands": {},
              "flags": {}
            },
            "undelete": {
              "commands": {},
              "flags": {}
            },
            "update": {
              "commands": {},
              "flags": {
                "--clear-labels": "bool",
                "--name": "value",
                "--remove-labels": "value",
                "--update-labels": "value"
              }
            }
          },
          "flags": {}
        },
        "pubsub": {
          "commands": {
            "snapshots": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--labels": "value",
                    "--subscription": "value",
                    "--subscription-project": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "subscriptions": {
              "commands": {
                "ack": {
                  "commands": {},
                  "flags": {
                    "--ack-ids": "value"
                  }
                },
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--ack-deadline": "value",
                    "--dead-letter-topic": "value",
                    "--dead-letter-topic-project": "value",
                    "--enable-message-ordering": "bool",
                    "--expiration-period": "value",
                    "--labels": "value",
                    "--max-delivery-attempts": "value",
                    "--message-retention-duration": "value",
                    "--push-auth-service-account": "value",
                    "--push-auth-token-audience": "value",
                    "--push-endpoint": "value",
                    "--retain-acked-messages": "bool",
                    "--topic": "value",
                    "--topic-project": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "modify-ack-deadline": {
                  "commands": {},
                  "flags": {
                    "--ack-deadline": "value",
                    "--ack-ids": "value"
                  }
                },
                "modify-message-ack-deadline": {
                  "commands": {},
                  "flags": {
                    "--ack-deadline": "value",
                    "--ack-ids": "value"
                  }
                },
                "modify-push-config": {
                  "commands": {},
                  "flags": {
                    "--push-auth-service-account": "value",
                    "--push-auth-token-audience": "value",
                    "--push-endpoint": "value"
                  }
                },
                "pull": {
                  "commands": {},
                  "flags": {
                    "--auto-ack": "bool",
                    "--filter": "value",
                    "--limit": "value",
                    "--max-messages": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--wait": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "seek": {
                  "commands": {},
                  "flags": {
                    "--snapshot": "value",
                    "--snapshot-project": "value",
                    "--time": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--ack-deadline": "value",
                    "--clear-dead-letter-policy": "bool",
                    "--clear-labels": "bool",
                    "--dead-letter-topic": "value",
                    "--dead-letter-topic-project": "value",
                    "--expiration-period": "value",
                    "--max-delivery-attempts": "value",
                    "--message-retention-duration": "value",
                    "--push-auth-service-account": "value",
                    "--push-auth-token-audience": "value",
                    "--push-endpoint": "value",
                    "--remove-labels": "value",
                    "--retain-acked-messages": "bool",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "topics": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--labels": "value",
                    "--message-storage-policy-allowed-regions": "value",
                    "--topic-encryption-key": "dynamic",
                    "--topic-encryption-key-keyring": "dynamic",
                    "--topic-encryption-key-location": "dynamic",
                    "--topic-encryption-key-project": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-snapshots": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-subscriptions": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "publish": {
                  "commands": {},
                  "flags": {
                    "--attribute": "value",
                    "--message": "value",
                    "--ordering-key": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--message-storage-policy-allowed-regions": "value",
                    "--recompute-message-storage-policy": "bool",
                    "--remove-labels": "value",
                    "--topic-encryption-key": "dynamic",
                    "--topic-encryption-key-keyring": "dynamic",
                    "--topic-encryption-key-location": "dynamic",
                    "--topic-encryption-key-project": "dynamic",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "recommender": {
          "commands": {
            "insights": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--insight-type": "value",
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--insight-type": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "mark-accepted": {
                  "commands": {},
                  "flags": {
                    "--etag": "value",
                    "--insight-type": "value",
                    "--location": "value",
                    "--state-metadata": "value"
                  }
                },
                "mark-active": {
                  "commands": {},
                  "flags": {
                    "--etag": "value",
                    "--insight-type": "value",
                    "--location": "value"
                  }
                },
                "mark-dismissed": {
                  "commands": {},
                  "flags": {
                    "--etag": "value",
                    "--insight-type": "value",
                    "--location": "value",
                    "--recommendation-change-type": [
                      "dismiss",
                      "leave_unchanged"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "recommendations": {
              "commands": {
                "create-rule": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--recommender": "value",
                    "--target-state": [
                      "active",
                      "claimed",
                      "dismissed",
                      "failed",
                      "succeeded"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--recommender": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--recommender": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "mark-active": {
                  "commands": {},
                  "flags": {
                    "--etag": "value",
                    "--location": "value",
                    "--recommender": "value"
                  }
                },
                "mark-claimed": {
                  "commands": {},
                  "flags": {
                    "--etag": "value",
                    "--location": "value",
                    "--recommender": "value",
                    "--state-metadata": "value"
                  }
                },
                "mark-dismissed": {
                  "commands": {},
                  "flags": {
                    "--etag": "value",
                    "--location": "value",
                    "--recommender": "value"
                  }
                },
                "mark-failed": {
                  "commands": {},
                  "flags": {
                    "--etag": "value",
                    "--location": "value",
                    "--recommender": "value",
                    "--state-metadata": "value"
                  }
                },
                "mark-succeeded": {
                  "commands": {},
                  "flags": {
                    "--etag": "value",
                    "--location": "value",
                    "--recommender": "value",
                    "--state-metadata": "value"
                  }
                }
              },
              "flags": {}
            },
            "rules": {
              "commands": {
                "apply": {
                  "commands": {},
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "redis": {
          "commands": {
            "instances": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--alternative-zone": "value",
                    "--async": "bool",
                    "--display-name": "value",
                    "--labels": "value",
                    "--network": "value",
                    "--redis-config": "value",
                    "--redis-version": [
                      "redis_3_2",
                      "redis_4_0"
                    ],
                    "--region": "dynamic",
                    "--reserved-ip-range": "value",
                    "--size": "value",
                    "--tier": [
                      "basic",
                      "standard"
                    ],
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "dynamic"
                  }
                },
                "failover": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--data-protection-mode": [
                      "force-data-loss",
                      "limited-data-loss"
                    ],
                    "--region": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--display-name": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--remove-redis-config": "value",
                    "--size": "value",
                    "--update-labels": "value",
                    "--update-redis-config": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "regions": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "zones": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "remote-build-execution": {
          "commands": {
            "instances": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "worker-pools": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator-count": "value",
                    "--accelerator-type": "value",
                    "--async": "bool",
                    "--disk-size": "value",
                    "--instance": "value",
                    "--labels": "value",
                    "--machine-type": "value",
                    "--min-cpu-platform": "value",
                    "--network-access": [
                      "private",
                      "public",
                      "restricted-private"
                    ],
                    "--reserved": "bool",
                    "--worker-count": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--instance": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--instance": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--accelerator-count": "value",
                    "--accelerator-type": "value",
                    "--async": "bool",
                    "--clear-accelerator-config": "bool",
                    "--clear-labels": "bool",
                    "--disk-size": "value",
                    "--instance": "value",
                    "--machine-type": "value",
                    "--min-cpu-platform": "value",
                    "--network-access": [
                      "private",
                      "public",
                      "restricted-private"
                    ],
                    "--remove-labels": "value",
                    "--reserved": "bool",
                    "--update-labels": "value",
                    "--worker-count": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "resource-manager": {
          "commands": {
            "folders": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--display-name": "value",
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--folder": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "move": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "undelete": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--display-name": "value"
                  }
                }
              },
              "flags": {}
            },
            "liens": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--origin": "value",
                    "--reason": "value",
                    "--restrictions": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "org-policies": {
              "commands": {
                "allow": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "dynamic"
                  }
                },
                "deny": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--effective": "bool",
                    "--folder": "value",
                    "--organization": "dynamic"
                  }
                },
                "disable-enforce": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "dynamic"
                  }
                },
                "enable-enforce": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--folder": "value",
                    "--limit": "value",
                    "--organization": "dynamic",
                    "--page-size": "value",
                    "--show-unset": "bool",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-policy": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "dynamic"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "resources": {
          "commands": {
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            }
          },
          "flags": {}
        },
        "run": {
          "commands": {
            "deploy": {
              "commands": {},
              "flags": {
                "--add-cloudsql-instances": "value",
                "--allow-unauthenticated": "bool",
                "--args": "value",
                "--async": "bool",
                "--clear-cloudsql-instances": "bool",
                "--clear-config-maps": "bool",
                "--clear-env-vars": "bool",
                "--clear-labels": "bool",
                "--clear-secrets": "bool",
                "--cluster": "value",
                "--cluster-location": "value",
                "--command": "value",
                "--concurrency": "value",
                "--connectivity": [
                  "external",
                  "internal"
                ],
                "--context": "value",
                "--cpu": "value",
                "--image": "value",
                "--kubeconfig": "value",
                "--labels": "value",
                "--max-instances": "value",
                "--memory": "value",
                "--min-instances": "value",
                "--namespace": "value",
                "--no-traffic": "bool",
                "--platform": [
                  "gke",
                  "kubernetes",
                  "managed"
                ],
                "--port": "value",
                "--region": "value",
                "--remove-cloudsql-instances": "value",
                "--remove-config-maps": "value",
                "--remove-env-vars": "value",
                "--remove-labels": "value",
                "--remove-secrets": "value",
                "--revision-suffix": "value",
                "--service-account": "value",
                "--set-cloudsql-instances": "value",
                "--set-config-maps": "value",
                "--set-env-vars": "value",
                "--set-secrets": "value",
                "--timeout": "value",
                "--update-config-maps": "value",
                "--update-env-vars": "value",
                "--update-labels": "value",
                "--update-secrets": "value",
                "--use-http2": "bool"
              }
            },
            "domain-mappings": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--cluster-location": "value",
                    "--context": "value",
                    "--domain": "value",
                    "--kubeconfig": "value",
                    "--namespace": "value",
                    "--platform": [
                      "gke",
                      "kubernetes",
                      "managed"
                    ],
                    "--region": "value",
                    "--service": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--cluster-location": "value",
                    "--context": "value",
                    "--domain": "value",
                    "--kubeconfig": "value",
                    "--namespace": "value",
                    "--platform": [
                      "gke",
                      "kubernetes",
                      "managed"
                    ],
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--cluster-location": "value",
                    "--context": "value",
                    "--domain": "value",
                    "--kubeconfig": "value",
                    "--namespace": "value",
                    "--platform": [
                      "gke",
                      "kubernetes",
                      "managed"
                    ],
                    "--region": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--cluster-location": "value",
                    "--context": "value",
                    "--filter": "value",
                    "--kubeconfig": "value",
                    "--limit": "value",
                    "--namespace": "value",
                    "--page-size": "value",
                    "--platform": [
                      "gke",
                      "kubernetes",
                      "managed"
                    ],
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {
                "--cluster": "value",
                "--cluster-location": "value",
                "--context": "value",
                "--kubeconfig": "value",
                "--platform": [
                  "gke",
                  "kubernetes",
                  "managed"
                ],
                "--region": "value"
              }
            },
            "revisions": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--cluster-location": "value",
                    "--context": "value",
                    "--kubeconfig": "value",
                    "--namespace": "value",
                    "--platform": [
                      "gke",
                      "kubernetes",
                      "managed"
                    ],
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--cluster-location": "value",
                    "--context": "value",
                    "--kubeconfig": "value",
                    "--namespace": "value",
                    "--platform": [
                      "gke",
                      "kubernetes",
                      "managed"
                    ],
                    "--region": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--cluster-location": "value",
                    "--context": "value",
                    "--filter": "value",
                    "--kubeconfig": "value",
                    "--limit": "value",
                    "--namespace": "value",
                    "--page-size": "value",
                    "--platform": [
                      "gke",
                      "kubernetes",
                      "managed"
                    ],
                    "--region": "value",
                    "--service": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {
                "--cluster": "value",
                "--cluster-location": "value",
                "--context": "value",
                "--kubeconfig": "value",
                "--platform": [
                  "gke",
                  "kubernetes",
                  "managed"
                ],
                "--region": "value"
              }
            },
            "services": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--cluster-location": "value",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--context": "value",
                    "--kubeconfig": "value",
                    "--member": "value",
                    "--platform": [
                      "gke",
                      "kubernetes",
                      "managed"
                    ],
                    "--region": "value",
                    "--role": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--cluster-location": "value",
                    "--context": "value",
                    "--kubeconfig": "value",
                    "--namespace": "value",
                    "--platform": [
                      "gke",
                      "kubernetes",
                      "managed"
                    ],
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--cluster-location": "value",
                    "--context": "value",
                    "--kubeconfig": "value",
                    "--namespace": "value",
                    "--platform": [
                      "gke",
                      "kubernetes",
                      "managed"
                    ],
                    "--region": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--cluster-location": "value",
                    "--context": "value",
                    "--filter": "value",
                    "--kubeconfig": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--platform": [
                      "gke",
                      "kubernetes",
                      "managed"
                    ],
                    "--region": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--cluster-location": "value",
                    "--context": "value",
                    "--filter": "value",
                    "--kubeconfig": "value",
                    "--limit": "value",
                    "--namespace": "value",
                    "--page-size": "value",
                    "--platform": [
                      "gke",
                      "kubernetes",
                      "managed"
                    ],
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--cluster": "value",
                    "--cluster-location": "value",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--context": "value",
                    "--kubeconfig": "value",
                    "--member": "value",
                    "--platform": [
                      "gke",
                      "kubernetes",
                      "managed"
                    ],
                    "--region": "value",
                    "--role": "dynamic"
                  }
                },
                "replace": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster": "value",
                    "--cluster-location": "value",
                    "--context": "value",
                    "--kubeconfig": "value",
                    "--namespace": "value",
                    "--platform": [
                      "gke",
                      "kubernetes",
                      "managed"
                    ],
                    "--region": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--cluster-location": "value",
                    "--context": "value",
                    "--kubeconfig": "value",
                    "--platform": [
                      "gke",
                      "kubernetes",
                      "managed"
                    ],
                    "--region": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-cloudsql-instances": "value",
                    "--args": "value",
                    "--async": "bool",
                    "--clear-cloudsql-instances": "bool",
                    "--clear-config-maps": "bool",
                    "--clear-env-vars": "bool",
                    "--clear-labels": "bool",
                    "--clear-secrets": "bool",
                    "--clear-vpc-connector": "bool",
                    "--cluster": "value",
                    "--cluster-location": "value",
                    "--command": "value",
                    "--concurrency": "value",
                    "--connectivity": [
                      "external",
                      "internal"
                    ],
                    "--context": "value",
                    "--cpu": "value",
                    "--kubeconfig": "value",
                    "--labels": "value",
                    "--max-instances": "value",
                    "--memory": "value",
                    "--min-instances": "value",
                    "--namespace": "value",
                    "--platform": [
                      "gke",
                      "kubernetes",
                      "managed"
                    ],
                    "--port": "value",
                    "--region": "value",
                    "--remove-cloudsql-instances": "value",
                    "--remove-config-maps": "value",
                    "--remove-env-vars": "value",
                    "--remove-labels": "value",
                    "--remove-secrets": "value",
                    "--revision-suffix": "value",
                    "--service-account": "value",
                    "--set-cloudsql-instances": "value",
                    "--set-config-maps": "value",
                    "--set-env-vars": "value",
                    "--set-secrets": "value",
                    "--timeout": "value",
                    "--update-config-maps": "value",
                    "--update-env-vars": "value",
                    "--update-labels": "value",
                    "--update-secrets": "value",
                    "--use-http2": "bool",
                    "--vpc-connector": "value"
                  }
                },
                "update-traffic": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster": "value",
                    "--cluster-location": "value",
                    "--context": "value",
                    "--kubeconfig": "value",
                    "--namespace": "value",
                    "--platform": [
                      "gke",
                      "kubernetes",
                      "managed"
                    ],
                    "--region": "value",
                    "--to-latest": "bool",
                    "--to-revisions": "value"
                  }
                }
              },
              "flags": {
                "--cluster": "value",
                "--cluster-location": "value",
                "--context": "value",
                "--kubeconfig": "value",
                "--platform": [
                  "gke",
                  "kubernetes",
                  "managed"
                ],
                "--region": "value"
              }
            }
          },
          "flags": {
            "--cluster": "value",
            "--cluster-location": "value",
            "--context": "value",
            "--kubeconfig": "value",
            "--platform": [
              "gke",
              "kubernetes",
              "managed"
            ],
            "--region": "value"
          }
        },
        "scc": {
          "commands": {
            "assets": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--asset": "value",
                    "--resource-name": "value"
                  }
                },
                "get-parent": {
                  "commands": {},
                  "flags": {
                    "--asset": "value",
                    "--resource-name": "value"
                  }
                },
                "get-project": {
                  "commands": {},
                  "flags": {
                    "--asset": "value",
                    "--resource-name": "value"
                  }
                },
                "group": {
                  "commands": {},
                  "flags": {
                    "--compare-duration": "value",
                    "--filter": "value",
                    "--group-by": "value",
                    "--page-size": "value",
                    "--page-token": "value",
                    "--read-time": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--compare-duration": "value",
                    "--field-mask": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--order-by": "value",
                    "--page-size": "value",
                    "--page-token": "value",
                    "--read-time": "value",
                    "--sort-by": "value"
                  }
                },
                "list-marks": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--page-token": "value",
                    "--read-time": "value",
                    "--sort-by": "value"
                  }
                },
                "run-discovery": {
                  "commands": {},
                  "flags": {}
                },
                "update-marks": {
                  "commands": {},
                  "flags": {
                    "--organization": "value",
                    "--security-marks": "value",
                    "--start-time": "value",
                    "--update-mask": "value"
                  }
                }
              },
              "flags": {}
            },
            "findings": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--category": "value",
                    "--event-time": "value",
                    "--external-uri": "value",
                    "--organization": "value",
                    "--resource-name": "value",
                    "--source": "dynamic",
                    "--source-properties": "value",
                    "--state": [
                      "active",
                      "inactive",
                      "state-unspecified"
                    ]
                  }
                },
                "group": {
                  "commands": {},
                  "flags": {
                    "--compare-duration": "value",
                    "--filter": "value",
                    "--group-by": "value",
                    "--page-size": "value",
                    "--page-token": "value",
                    "--read-time": "value",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--compare-duration": "value",
                    "--field-mask": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--order-by": "value",
                    "--page-size": "value",
                    "--page-token": "value",
                    "--read-time": "value",
                    "--sort-by": "value",
                    "--source": "value"
                  }
                },
                "list-marks": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--page-token": "value",
                    "--read-time": "value",
                    "--sort-by": "value",
                    "--source": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--event-time": "value",
                    "--external-uri": "value",
                    "--organization": "value",
                    "--source": "dynamic",
                    "--source-properties": "value",
                    "--state": [
                      "active",
                      "inactive",
                      "state-unspecified"
                    ],
                    "--update-mask": "value"
                  }
                },
                "update-marks": {
                  "commands": {},
                  "flags": {
                    "--organization": "value",
                    "--security-marks": "value",
                    "--source": "dynamic",
                    "--start-time": "value",
                    "--update-mask": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                }
              },
              "flags": {}
            },
            "sources": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--source": "value",
                    "--source-display-name": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "scheduler": {
          "commands": {
            "jobs": {
              "commands": {
                "create": {
                  "commands": {
                    "app-engine": {
                      "commands": {},
                      "flags": {
                        "--attempt-deadline": "value",
                        "--description": "value",
                        "--headers": "value",
                        "--http-method": [
                          "delete",
                          "get",
                          "head",
                          "post",
                          "put"
                        ],
                        "--max-backoff": "value",
                        "--max-doublings": "value",
                        "--max-retry-attempts": "value",
                        "--max-retry-duration": "value",
                        "--message-body": "value",
                        "--message-body-from-file": "value",
                        "--min-backoff": "value",
                        "--relative-url": "value",
                        "--schedule": "value",
                        "--service": "value",
                        "--time-zone": "value"
                      }
                    },
                    "http": {
                      "commands": {},
                      "flags": {
                        "--attempt-deadline": "value",
                        "--description": "value",
                        "--headers": "value",
                        "--http-method": [
                          "delete",
                          "get",
                          "head",
                          "post",
                          "put"
                        ],
                        "--max-backoff": "value",
                        "--max-doublings": "value",
                        "--max-retry-attempts": "value",
                        "--max-retry-duration": "value",
                        "--message-body": "value",
                        "--message-body-from-file": "value",
                        "--min-backoff": "value",
                        "--oauth-service-account-email": "value",
                        "--oauth-token-scope": "value",
                        "--oidc-service-account-email": "value",
                        "--oidc-token-audience": "value",
                        "--schedule": "value",
                        "--time-zone": "value",
                        "--uri": "value"
                      }
                    },
                    "pubsub": {
                      "commands": {},
                      "flags": {
                        "--attributes": "value",
                        "--description": "value",
                        "--max-backoff": "value",
                        "--max-doublings": "value",
                        "--max-retry-attempts": "value",
                        "--max-retry-duration": "value",
                        "--message-body": "value",
                        "--message-body-from-file": "value",
                        "--min-backoff": "value",
                        "--schedule": "value",
                        "--time-zone": "value",
                        "--topic": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "pause": {
                  "commands": {},
                  "flags": {}
                },
                "resume": {
                  "commands": {},
                  "flags": {}
                },
                "run": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {
                    "app-engine": {
                      "commands": {},
                      "flags": {
                        "--attempt-deadline": "value",
                        "--clear-headers": "bool",
                        "--clear-max-backoff": "bool",
                        "--clear-max-doublings": "bool",
                        "--clear-max-retry-attempts": "bool",
                        "--clear-max-retry-duration": "bool",
                        "--clear-message-body": "bool",
                        "--clear-min-backoff": "bool",
                        "--clear-relative-url": "bool",
                        "--clear-service": "bool",
                        "--clear-time-zone": "bool",
                        "--description": "value",
                        "--http-method": [
                          "delete",
                          "get",
                          "head",
                          "post",
                          "put"
                        ],
                        "--max-backoff": "value",
                        "--max-doublings": "value",
                        "--max-retry-attempts": "value",
                        "--max-retry-duration": "value",
                        "--message-body": "value",
                        "--message-body-from-file": "value",
                        "--min-backoff": "value",
                        "--relative-url": "value",
                        "--remove-headers": "value",
                        "--schedule": "value",
                        "--service": "value",
                        "--time-zone": "value",
                        "--update-headers": "value"
                      }
                    },
                    "http": {
                      "commands": {},
                      "flags": {
                        "--attempt-deadline": "value",
                        "--clear-auth-token": "bool",
                        "--clear-headers": "bool",
                        "--clear-max-backoff": "bool",
                        "--clear-max-doublings": "bool",
                        "--clear-max-retry-attempts": "bool",
                        "--clear-max-retry-duration": "bool",
                        "--clear-message-body": "bool",
                        "--clear-min-backoff": "bool",
                        "--clear-time-zone": "bool",
                        "--description": "value",
                        "--http-method": [
                          "delete",
                          "get",
                          "head",
                          "post",
                          "put"
                        ],
                        "--max-backoff": "value",
                        "--max-doublings": "value",
                        "--max-retry-attempts": "value",
                        "--max-retry-duration": "value",
                        "--message-body": "value",
                        "--message-body-from-file": "value",
                        "--min-backoff": "value",
                        "--oauth-service-account-email": "value",
                        "--oauth-token-scope": "value",
                        "--oidc-service-account-email": "value",
                        "--oidc-token-audience": "value",
                        "--remove-headers": "value",
                        "--schedule": "value",
                        "--time-zone": "value",
                        "--update-headers": "value",
                        "--uri": "value"
                      }
                    },
                    "pubsub": {
                      "commands": {},
                      "flags": {
                        "--clear-attributes": "bool",
                        "--clear-max-backoff": "bool",
                        "--clear-max-doublings": "bool",
                        "--clear-max-retry-attempts": "bool",
                        "--clear-max-retry-duration": "bool",
                        "--clear-min-backoff": "bool",
                        "--clear-time-zone": "bool",
                        "--description": "value",
                        "--max-backoff": "value",
                        "--max-doublings": "value",
                        "--max-retry-attempts": "value",
                        "--max-retry-duration": "value",
                        "--message-body": "value",
                        "--message-body-from-file": "value",
                        "--min-backoff": "value",
                        "--remove-attributes": "value",
                        "--schedule": "value",
                        "--time-zone": "value",
                        "--topic": "value",
                        "--update-attributes": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "search-help": {
          "commands": {},
          "flags": {
            "--filter": "value",
            "--limit": "value",
            "--page-size": "value",
            "--sort-by": "value"
          }
        },
        "services": {
          "commands": {
            "disable": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--force": "bool"
              }
            },
            "enable": {
              "commands": {},
              "flags": {
                "--async": "bool"
              }
            },
            "identity": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--service": "value"
                  }
                }
              },
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--available": "bool",
                "--enabled": "bool",
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--full": "value"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "vpc-peerings": {
              "commands": {
                "connect": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--network": "value",
                    "--ranges": "value",
                    "--service": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--network": "value",
                    "--service": "value"
                  }
                },
                "operations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--name": "value"
                      }
                    },
                    "wait": {
                      "commands": {},
                      "flags": {
                        "--name": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--force": "bool",
                    "--network": "value",
                    "--ranges": "value",
                    "--service": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "source": {
          "commands": {
            "project-configs": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-topic": "value",
                    "--disable-pushblock": "bool",
                    "--enable-pushblock": "bool",
                    "--message-format": [
                      "json",
                      "protobuf"
                    ],
                    "--remove-topic": "value",
                    "--service-account": "value",
                    "--topic-project": "value",
                    "--update-topic": "value"
                  }
                }
              },
              "flags": {}
            },
            "repos": {
              "commands": {
                "clone": {
                  "commands": {},
                  "flags": {
                    "--dry-run": "bool",
                    "--use-full-gcloud-path": "bool"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--force": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-topic": "value",
                    "--message-format": [
                      "json",
                      "protobuf"
                    ],
                    "--remove-topic": "value",
                    "--service-account": "value",
                    "--topic-project": "value",
                    "--update-topic": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "spanner": {
          "commands": {
            "databases": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--instance": "dynamic",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--ddl": "value",
                    "--instance": "value"
                  }
                },
                "ddl": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--instance": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--ddl": "value",
                        "--instance": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--instance": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--instance": "value"
                  }
                },
                "execute-sql": {
                  "commands": {},
                  "flags": {
                    "--enable-partitioned-dml": "bool",
                    "--instance": "value",
                    "--query-mode": [
                      "NORMAL",
                      "PLAN",
                      "PROFILE"
                    ],
                    "--sql": "value",
                    "--timeout": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--instance": "dynamic",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "sessions": {
                  "commands": {
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--database": "value",
                        "--instance": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--database": "value",
                        "--filter": "value",
                        "--instance": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--server-filter": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--instance": "value"
                  }
                }
              },
              "flags": {}
            },
            "instance-configs": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "instances": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--config": "dynamic",
                    "--description": "value",
                    "--nodes": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--nodes": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--database": "dynamic",
                    "--instance": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--database": "dynamic",
                    "--instance": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--database": "dynamic",
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "rows": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--database": "value",
                    "--instance": "value",
                    "--keys": "value",
                    "--table": "value"
                  }
                },
                "insert": {
                  "commands": {},
                  "flags": {
                    "--data": "value",
                    "--database": "value",
                    "--instance": "value",
                    "--table": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--data": "value",
                    "--database": "value",
                    "--instance": "value",
                    "--table": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "sql": {
          "commands": {
            "backups": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--instance": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--instance": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "restore": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--backup-instance": "dynamic",
                    "--restore-instance": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "connect": {
              "commands": {},
              "flags": {
                "--database": "value",
                "--port": "value",
                "--user": "value"
              }
            },
            "databases": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--charset": "value",
                    "--collation": "value",
                    "--instance": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "patch": {
                  "commands": {},
                  "flags": {
                    "--charset": "value",
                    "--collation": "value",
                    "--diff": "bool",
                    "--instance": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "export": {
              "commands": {
                "bak": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--database": "value"
                  }
                },
                "csv": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--database": "value",
                    "--query": "value"
                  }
                },
                "sql": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--database": "value",
                    "--table": "value"
                  }
                }
              },
              "flags": {}
            },
            "flags": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--database-version": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "import": {
              "commands": {
                "bak": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cert-path": "value",
                    "--database": "value",
                    "--prompt-for-pvk-password": "bool",
                    "--pvk-password": "value",
                    "--pvk-path": "value"
                  }
                },
                "csv": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--columns": "value",
                    "--database": "value",
                    "--table": "value",
                    "--user": "value"
                  }
                },
                "sql": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--database": "value",
                    "--user": "value"
                  }
                }
              },
              "flags": {}
            },
            "instances": {
              "commands": {
                "clone": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--bin-log-file-name": "value",
                    "--bin-log-position": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--activation-policy": [
                      "always",
                      "never",
                      "on-demand"
                    ],
                    "--assign-ip": "bool",
                    "--async": "bool",
                    "--authorized-gae-apps": "value",
                    "--authorized-networks": "value",
                    "--availability-type": [
                      "regional",
                      "zonal"
                    ],
                    "--backup": "bool",
                    "--backup-start-time": "value",
                    "--client-certificate-path": "value",
                    "--client-key-path": "value",
                    "--cpu": "value",
                    "--database-flags": "value",
                    "--database-version": "value",
                    "--disk-encryption-key": "dynamic",
                    "--disk-encryption-key-keyring": "dynamic",
                    "--disk-encryption-key-location": "dynamic",
                    "--disk-encryption-key-project": "dynamic",
                    "--enable-bin-log": "bool",
                    "--failover-replica-name": "value",
                    "--follow-gae-app": "value",
                    "--gce-zone": "value",
                    "--labels": "value",
                    "--maintenance-release-channel": [
                      "preview",
                      "production"
                    ],
                    "--maintenance-window-day": [
                      "FRI",
                      "MON",
                      "SAT",
                      "SUN",
                      "THU",
                      "TUE",
                      "WED"
                    ],
                    "--maintenance-window-hour": "value",
                    "--master-ca-certificate-path": "value",
                    "--master-dump-file-path": "value",
                    "--master-instance-name": "value",
                    "--master-password": "value",
                    "--master-username": "value",
                    "--memory": "value",
                    "--network": "value",
                    "--pricing-plan": [
                      "PACKAGE",
                      "PER_USE"
                    ],
                    "--prompt-for-master-password": "bool",
                    "--region": "value",
                    "--replica-type": [
                      "FAILOVER",
                      "READ"
                    ],
                    "--replication": [
                      "asynchronous",
                      "synchronous"
                    ],
                    "--require-ssl": "bool",
                    "--root-password": "value",
                    "--source-ip-address": "value",
                    "--source-port": "value",
                    "--storage-auto-increase": "bool",
                    "--storage-auto-increase-limit": "value",
                    "--storage-size": "value",
                    "--storage-type": [
                      "HDD",
                      "SSD"
                    ],
                    "--tier": "value",
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--database": "value",
                    "--table": "value"
                  }
                },
                "failover": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--database": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "patch": {
                  "commands": {},
                  "flags": {
                    "--activation-policy": [
                      "always",
                      "never",
                      "on-demand"
                    ],
                    "--assign-ip": "bool",
                    "--async": "bool",
                    "--authorized-gae-apps": "value",
                    "--authorized-networks": "value",
                    "--availability-type": [
                      "regional",
                      "zonal"
                    ],
                    "--backup-start-time": "value",
                    "--clear-authorized-networks": "bool",
                    "--clear-database-flags": "bool",
                    "--clear-gae-apps": "bool",
                    "--clear-labels": "bool",
                    "--cpu": "value",
                    "--database-flags": "value",
                    "--diff": "bool",
                    "--enable-bin-log": "bool",
                    "--enable-database-replication": "bool",
                    "--follow-gae-app": "value",
                    "--gce-zone": "value",
                    "--maintenance-release-channel": [
                      "preview",
                      "production"
                    ],
                    "--maintenance-window-any": "bool",
                    "--maintenance-window-day": [
                      "FRI",
                      "MON",
                      "SAT",
                      "SUN",
                      "THU",
                      "TUE",
                      "WED"
                    ],
                    "--maintenance-window-hour": "value",
                    "--memory": "value",
                    "--network": "value",
                    "--no-backup": "bool",
                    "--pricing-plan": [
                      "PACKAGE",
                      "PER_USE"
                    ],
                    "--remove-labels": "value",
                    "--replication": [
                      "asynchronous",
                      "synchronous"
                    ],
                    "--require-ssl": "bool",
                    "--storage-auto-increase": "bool",
                    "--storage-auto-increase-limit": "value",
                    "--storage-size": "value",
                    "--tier": "value",
                    "--update-labels": "value",
                    "--zone": "value"
                  }
                },
                "promote-replica": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "reset-ssl-config": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "restart": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "restore-backup": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--backup-id": "value",
                    "--backup-instance": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--timeout": "value"
                  }
                }
              },
              "flags": {}
            },
            "ssl": {
              "commands": {
                "client-certs": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--instance": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--instance": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--instance": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--instance": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "server-ca-certs": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--instance": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--instance": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "rollback": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--instance": "dynamic"
                      }
                    },
                    "rotate": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--instance": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "ssl-certs": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--instance": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "tiers": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "users": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--host": "value",
                    "--instance": "dynamic",
                    "--password": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--host": "value",
                    "--instance": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-password": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--host": "value",
                    "--instance": "dynamic",
                    "--password": "value",
                    "--prompt-for-password": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "survey": {
          "commands": {},
          "flags": {}
        },
        "tasks": {
          "commands": {
            "acknowledge": {
              "commands": {},
              "flags": {
                "--queue": "value",
                "--schedule-time": "value"
              }
            },
            "cancel-lease": {
              "commands": {},
              "flags": {
                "--queue": "value",
                "--schedule-time": "value"
              }
            },
            "create-app-engine-task": {
              "commands": {},
              "flags": {
                "--header": "value",
                "--method": "value",
                "--payload-content": "value",
                "--payload-file": "value",
                "--queue": "value",
                "--routing": "value",
                "--schedule-time": "value",
                "--url": "value"
              }
            },
            "create-http-task": {
              "commands": {},
              "flags": {
                "--body-content": "value",
                "--body-file": "value",
                "--header": "value",
                "--method": "value",
                "--oauth-service-account-email": "value",
                "--oauth-token-scope": "value",
                "--oidc-service-account-email": "value",
                "--oidc-token-audience": "value",
                "--queue": "value",
                "--schedule-time": "value",
                "--url": "value"
              }
            },
            "create-pull-task": {
              "commands": {},
              "flags": {
                "--payload-content": "value",
                "--payload-file": "value",
                "--queue": "value",
                "--schedule-time": "value",
                "--tag": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--queue": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--queue": "value"
              }
            },
            "lease": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--lease-duration": "value",
                "--limit": "value",
                "--oldest-tag": "bool",
                "--queue": "value",
                "--sort-by": "value",
                "--tag": "value",
                "--uri": "bool"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--queue": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "locations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "queues": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--max-attempts": "value",
                    "--max-backoff": "value",
                    "--max-concurrent-tasks": "value",
                    "--max-doublings": "value",
                    "--max-retry-duration": "value",
                    "--max-tasks-dispatched-per-second": "value",
                    "--min-backoff": "value",
                    "--routing-override": "value"
                  }
                },
                "create-app-engine-queue": {
                  "commands": {},
                  "flags": {
                    "--max-attempts": "value",
                    "--max-backoff": "value",
                    "--max-concurrent-tasks": "value",
                    "--max-doublings": "value",
                    "--max-retry-duration": "value",
                    "--max-tasks-dispatched-per-second": "value",
                    "--min-backoff": "value",
                    "--routing-override": "value"
                  }
                },
                "create-pull-queue": {
                  "commands": {},
                  "flags": {
                    "--max-attempts": "value",
                    "--max-retry-duration": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "pause": {
                  "commands": {},
                  "flags": {}
                },
                "purge": {
                  "commands": {},
                  "flags": {}
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "resume": {
                  "commands": {},
                  "flags": {}
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-max-attempts": "bool",
                    "--clear-max-backoff": "bool",
                    "--clear-max-concurrent-tasks": "bool",
                    "--clear-max-doublings": "bool",
                    "--clear-max-retry-duration": "bool",
                    "--clear-max-tasks-dispatched-per-second": "bool",
                    "--clear-min-backoff": "bool",
                    "--clear-routing-override": "bool",
                    "--max-attempts": "value",
                    "--max-backoff": "value",
                    "--max-concurrent-tasks": "value",
                    "--max-doublings": "value",
                    "--max-retry-duration": "value",
                    "--max-tasks-dispatched-per-second": "value",
                    "--min-backoff": "value",
                    "--routing-override": "value"
                  }
                },
                "update-app-engine-queue": {
                  "commands": {},
                  "flags": {
                    "--clear-max-attempts": "bool",
                    "--clear-max-backoff": "bool",
                    "--clear-max-concurrent-tasks": "bool",
                    "--clear-max-doublings": "bool",
                    "--clear-max-retry-duration": "bool",
                    "--clear-max-tasks-dispatched-per-second": "bool",
                    "--clear-min-backoff": "bool",
                    "--clear-routing-override": "bool",
                    "--max-attempts": "value",
                    "--max-backoff": "value",
                    "--max-concurrent-tasks": "value",
                    "--max-doublings": "value",
                    "--max-retry-duration": "value",
                    "--max-tasks-dispatched-per-second": "value",
                    "--min-backoff": "value",
                    "--routing-override": "value"
                  }
                },
                "update-pull-queue": {
                  "commands": {},
                  "flags": {
                    "--clear-max-attempts": "bool",
                    "--clear-max-retry-duration": "bool",
                    "--max-attempts": "value",
                    "--max-retry-duration": "value"
                  }
                }
              },
              "flags": {}
            },
            "renew-lease": {
              "commands": {},
              "flags": {
                "--lease-duration": "value",
                "--queue": "value",
                "--schedule-time": "value"
              }
            },
            "run": {
              "commands": {},
              "flags": {
                "--queue": "value"
              }
            }
          },
          "flags": {}
        },
        "web-security-scanner": {
          "commands": {
            "scan-configs": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--auth-password": "value",
                    "--auth-type": [
                      "custom",
                      "google",
                      "none"
                    ],
                    "--auth-url": "value",
                    "--auth-user": "value",
                    "--blacklist-patterns": "value",
                    "--display-name": "value",
                    "--export-to-security-center": "bool",
                    "--max-qps": "value",
                    "--risk-level": [
                      "low",
                      "normal"
                    ],
                    "--schedule-interval-days": "value",
                    "--schedule-next-start": "value",
                    "--starting-urls": "value",
                    "--target-platforms": "value",
                    "--user-agent": [
                      "chrome-android",
                      "chrome-linux",
                      "safari-iphone",
                      "user-agent-unspecified"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--auth-password": "value",
                    "--auth-type": [
                      "custom",
                      "google",
                      "none"
                    ],
                    "--auth-url": "value",
                    "--auth-user": "value",
                    "--blacklist-patterns": "value",
                    "--display-name": "value",
                    "--export-to-security-center": "bool",
                    "--max-qps": "value",
                    "--risk-level": [
                      "low",
                      "normal"
                    ],
                    "--schedule-interval-days": "value",
                    "--schedule-next-start": "value",
                    "--starting-urls": "value",
                    "--target-platforms": "value",
                    "--user-agent": [
                      "chrome-android",
                      "chrome-linux",
                      "safari-iphone",
                      "user-agent-unspecified"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "scan-runs": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--scan-config": "value"
                  }
                },
                "findings": {
                  "commands": {
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--scan-config": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--scan-config": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-crawled-urls": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--scan-config": "value",
                    "--scan-run": "value",
                    "--sort-by": "value"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {}
                },
                "stop": {
                  "commands": {},
                  "flags": {
                    "--scan-config": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        }
      },
      "flags": {}
    },
    "app": {
      "commands": {
        "browse": {
          "commands": {},
          "flags": {
            "--launch-browser": "bool",
            "--service": "value"
          }
        },
        "create": {
          "commands": {},
          "flags": {
            "--region": "value"
          }
        },
        "deploy": {
          "commands": {},
          "flags": {
            "--bucket": "value",
            "--ignore-file": "value",
            "--image-url": "value",
            "--promote": "bool",
            "--stop-previous-version": "bool"
          }
        },
        "describe": {
          "commands": {},
          "flags": {}
        },
        "domain-mappings": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--certificate-id": "value",
                "--certificate-management": [
                  "automatic",
                  "manual"
                ]
              }
            },
            "delete": {
              "commands": {},
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--certificate-id": "value",
                "--certificate-management": [
                  "automatic",
                  "manual"
                ],
                "--no-certificate-id": "bool"
              }
            }
          },
          "flags": {}
        },
        "firewall-rules": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--action": [
                  "ALLOW",
                  "DENY"
                ],
                "--description": "value",
                "--source-range": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "test-ip": {
              "commands": {},
              "flags": {}
            },
            "update": {
              "commands": {},
              "flags": {
                "--action": [
                  "ALLOW",
                  "DENY"
                ],
                "--description": "value",
                "--source-range": "value"
              }
            }
          },
          "flags": {}
        },
        "instances": {
          "commands": {
            "delete": {
              "commands": {},
              "flags": {
                "--service": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--service": "value"
              }
            },
            "disable-debug": {
              "commands": {},
              "flags": {
                "--service": "value"
              }
            },
            "enable-debug": {
              "commands": {},
              "flags": {
                "--service": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--service": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "scp": {
              "commands": {},
              "flags": {
                "--compress": "bool",
                "--recurse": "bool",
                "--service": "value"
              }
            },
            "ssh": {
              "commands": {},
              "flags": {
                "--container": "value",
                "--service": "value"
              }
            }
          },
          "flags": {}
        },
        "logs": {
          "commands": {
            "read": {
              "commands": {},
              "flags": {
                "--level": [
                  "any",
                  "critical",
                  "debug",
                  "error",
                  "info",
                  "warning"
                ],
                "--limit": "value",
                "--logs": "value",
                "--service": "value"
              }
            },
            "tail": {
              "commands": {},
              "flags": {
                "--level": [
                  "any",
                  "critical",
                  "debug",
                  "error",
                  "info",
                  "warning"
                ],
                "--logs": "value",
                "--service": "value"
              }
            }
          },
          "flags": {}
        },
        "open-console": {
          "commands": {},
          "flags": {
            "--logs": "bool",
            "--service": "value"
          }
        },
        "operations": {
          "commands": {
            "describe": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--pending": "bool",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "wait": {
              "commands": {},
              "flags": {}
            }
          },
          "flags": {}
        },
        "regions": {
          "commands": {
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            }
          },
          "flags": {}
        },
        "services": {
          "commands": {
            "browse": {
              "commands": {},
              "flags": {
                "--launch-browser": "bool"
              }
            },
            "delete": {
              "commands": {},
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "set-traffic": {
              "commands": {},
              "flags": {
                "--migrate": "bool",
                "--split-by": [
                  "cookie",
                  "ip",
                  "random"
                ],
                "--splits": "value"
              }
            }
          },
          "flags": {}
        },
        "ssl-certificates": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--certificate": "value",
                "--display-name": "value",
                "--private-key": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--certificate": "value",
                "--display-name": "value",
                "--private-key": "value"
              }
            }
          },
          "flags": {}
        },
        "update": {
          "commands": {},
          "flags": {
            "--split-health-checks": "bool"
          }
        },
        "versions": {
          "commands": {
            "browse": {
              "commands": {},
              "flags": {
                "--launch-browser": "bool",
                "--service": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--service": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--service": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--hide-no-traffic": "bool",
                "--limit": "value",
                "--page-size": "value",
                "--service": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "migrate": {
              "commands": {},
              "flags": {
                "--service": "value"
              }
            },
            "start": {
              "commands": {},
              "flags": {
                "--service": "value"
              }
            },
            "stop": {
              "commands": {},
              "flags": {
                "--service": "value"
              }
            }
          },
          "flags": {}
        }
      },
      "flags": {}
    },
    "asset": {
      "commands": {
        "export": {
          "commands": {},
          "flags": {
            "--asset-types": "value",
            "--bigquery-dataset": "dynamic",
            "--bigquery-table": "dynamic",
            "--content-type": [
              "access-policy",
              "iam-policy",
              "org-policy",
              "resource"
            ],
            "--folder": "value",
            "--organization": "value",
            "--output-bigquery-force": "bool",
            "--output-path": "value",
            "--output-path-prefix": "value",
            "--snapshot-time": "value"
          }
        },
        "get-history": {
          "commands": {},
          "flags": {
            "--asset-names": "value",
            "--content-type": [
              "access-policy",
              "iam-policy",
              "org-policy",
              "resource"
            ],
            "--end-time": "value",
            "--organization": "value",
            "--start-time": "value"
          }
        },
        "operations": {
          "commands": {
            "describe": {
              "commands": {},
              "flags": {}
            }
          },
          "flags": {}
        }
      },
      "flags": {}
    },
    "auth": {
      "commands": {
        "activate-service-account": {
          "commands": {},
          "flags": {
            "--key-file": "value",
            "--password-file": "value",
            "--prompt-for-password": "bool"
          }
        },
        "application-default": {
          "commands": {
            "login": {
              "commands": {},
              "flags": {
                "--client-id-file": "value",
                "--launch-browser": "bool",
                "--scopes": "value"
              }
            },
            "print-access-token": {
              "commands": {},
              "flags": {}
            },
            "revoke": {
              "commands": {},
              "flags": {}
            }
          },
          "flags": {}
        },
        "configure-docker": {
          "commands": {},
          "flags": {}
        },
        "list": {
          "commands": {},
          "flags": {
            "--filter": "value",
            "--filter-account": "value",
            "--limit": "value",
            "--page-size": "value",
            "--sort-by": "value"
          }
        },
        "login": {
          "commands": {},
          "flags": {
            "--activate": "bool",
            "--brief": "bool",
            "--enable-gdrive-access": "bool",
            "--force": "bool",
            "--launch-browser": "bool"
          }
        },
        "print-access-token": {
          "commands": {},
          "flags": {}
        },
        "print-identity-token": {
          "commands": {},
          "flags": {
            "--audiences": "value",
            "--include-email": "bool",
            "--include-license": "bool",
            "--token-format": [
              "full",
              "standard"
            ]
          }
        },
        "revoke": {
          "commands": {},
          "flags": {
            "--all": "bool"
          }
        }
      },
      "flags": {}
    },
    "beta": {
      "commands": {
        "access-context-manager": {
          "commands": {
            "levels": {
              "commands": {
                "conditions": {
                  "commands": {
                    "list": {
                      "commands": {},
                      "flags": {
                        "--level": "value",
                        "--policy": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--basic-level-spec": "value",
                    "--combine-function": [
                      "and",
                      "or"
                    ],
                    "--description": "value",
                    "--policy": "value",
                    "--title": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--policy": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--policy": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--policy": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--basic-level-spec": "value",
                    "--combine-function": [
                      "and",
                      "or"
                    ],
                    "--description": "value",
                    "--policy": "value",
                    "--title": "value"
                  }
                }
              },
              "flags": {}
            },
            "perimeters": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--access-levels": "value",
                    "--async": "bool",
                    "--description": "value",
                    "--perimeter-type": [
                      "bridge",
                      "regular"
                    ],
                    "--policy": "value",
                    "--resources": "value",
                    "--restricted-services": "value",
                    "--title": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--policy": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--policy": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--policy": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-access-levels": "value",
                    "--add-resources": "value",
                    "--add-restricted-services": "value",
                    "--clear-access-levels": "bool",
                    "--clear-resources": "bool",
                    "--clear-restricted-services": "bool",
                    "--description": "value",
                    "--policy": "value",
                    "--remove-access-levels": "value",
                    "--remove-resources": "value",
                    "--remove-restricted-services": "value",
                    "--set-access-levels": "value",
                    "--set-resources": "value",
                    "--set-restricted-services": "value",
                    "--title": "value",
                    "--type": [
                      "bridge",
                      "regular"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "policies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--organization": "value",
                    "--title": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--title": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "active-directory": {
          "commands": {
            "domains": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--admin-name": "value",
                    "--async": "bool",
                    "--authorized-networks": "value",
                    "--labels": "value",
                    "--region": "value",
                    "--reserved-ip-range": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "reset-admin-password": {
                  "commands": {},
                  "flags": {}
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "trusts": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--direction": [
                          "bidirectional",
                          "inbound",
                          "outbound",
                          "trust-direction-unspecified"
                        ],
                        "--handshake-secret": "value",
                        "--selective-authentication": "bool",
                        "--target-dns-ip-addresses": "value",
                        "--target-domain-name": "value",
                        "--type": [
                          "external",
                          "forest",
                          "trust-type-unspecified"
                        ]
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--target-domain-name": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--target-dns-ip-addresses": "value",
                        "--target-domain-name": "value"
                      }
                    },
                    "validate-state": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--target-domain-name": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-authorized-networks": "value",
                    "--add-region": "value",
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--remove-authorized-networks": "value",
                    "--remove-labels": "value",
                    "--remove-region": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "ai-platform": {
          "commands": {
            "explain": {
              "commands": {},
              "flags": {
                "--json-instances": "value",
                "--model": "value",
                "--text-instances": "value"
              }
            },
            "jobs": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--summarize": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "stream-logs": {
                  "commands": {},
                  "flags": {
                    "--allow-multiline-logs": "bool",
                    "--polling-interval": "value",
                    "--task-name": "value"
                  }
                },
                "submit": {
                  "commands": {
                    "prediction": {
                      "commands": {},
                      "flags": {
                        "--batch-size": "value",
                        "--data-format": [
                          "text",
                          "tf-record",
                          "tf-record-gzip"
                        ],
                        "--input-paths": "value",
                        "--labels": "value",
                        "--max-worker-count": "value",
                        "--model": "value",
                        "--model-dir": "value",
                        "--output-path": "value",
                        "--region": "value",
                        "--runtime-version": "value",
                        "--signature-name": "value"
                      }
                    },
                    "training": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--config": "value",
                        "--job-dir": "value",
                        "--labels": "value",
                        "--master-accelerator": "value",
                        "--master-image-uri": "value",
                        "--master-machine-type": "value",
                        "--module-name": "value",
                        "--package-path": "value",
                        "--packages": "value",
                        "--parameter-server-accelerator": "value",
                        "--parameter-server-count": "value",
                        "--parameter-server-image-uri": "value",
                        "--parameter-server-machine-type": "value",
                        "--python-version": "value",
                        "--region": "dynamic",
                        "--runtime-version": "value",
                        "--scale-tier": [
                          "basic",
                          "basic-gpu",
                          "basic-tpu",
                          "custom",
                          "premium-1",
                          "standard-1"
                        ],
                        "--staging-bucket": "value",
                        "--stream-logs": "bool",
                        "--tpu-tf-version": "value",
                        "--worker-accelerator": "value",
                        "--worker-count": "value",
                        "--worker-image-uri": "value",
                        "--worker-machine-type": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "local": {
              "commands": {
                "predict": {
                  "commands": {},
                  "flags": {
                    "--framework": [
                      "scikit-learn",
                      "tensorflow",
                      "xgboost"
                    ],
                    "--json-instances": "value",
                    "--model-dir": "value",
                    "--signature-name": "value",
                    "--text-instances": "value"
                  }
                },
                "train": {
                  "commands": {},
                  "flags": {
                    "--distributed": "bool",
                    "--job-dir": "value",
                    "--module-name": "value",
                    "--package-path": "value",
                    "--parameter-server-count": "value",
                    "--start-port": "value",
                    "--worker-count": "value"
                  }
                }
              },
              "flags": {}
            },
            "models": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--enable-console-logging": "bool",
                    "--enable-logging": "bool",
                    "--labels": "value",
                    "--regions": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "predict": {
              "commands": {},
              "flags": {
                "--json-instances": "value",
                "--model": "value",
                "--signature-name": "value",
                "--text-instances": "value"
              }
            },
            "versions": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--async": "bool",
                    "--config": "value",
                    "--description": "value",
                    "--explanation-method": [
                      "integrated-gradients",
                      "sampled-shapley"
                    ],
                    "--framework": [
                      "scikit-learn",
                      "tensorflow",
                      "xgboost"
                    ],
                    "--labels": "value",
                    "--machine-type": "value",
                    "--model": "value",
                    "--num-integral-steps": "value",
                    "--num-paths": "value",
                    "--origin": "value",
                    "--package-uris": "value",
                    "--prediction-class": "value",
                    "--python-version": "value",
                    "--runtime-version": "value",
                    "--service-account": "value",
                    "--staging-bucket": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--model": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--model": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--model": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-default": {
                  "commands": {},
                  "flags": {
                    "--model": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--model": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "app": {
          "commands": {
            "browse": {
              "commands": {},
              "flags": {
                "--launch-browser": "bool",
                "--service": "value"
              }
            },
            "create": {
              "commands": {},
              "flags": {
                "--region": "value"
              }
            },
            "deploy": {
              "commands": {},
              "flags": {
                "--bucket": "value",
                "--ignore-file": "value",
                "--image-url": "value",
                "--no-cache": "bool",
                "--promote": "bool",
                "--stop-previous-version": "bool"
              }
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "domain-mappings": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--certificate-id": "value",
                    "--certificate-management": [
                      "automatic",
                      "manual"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--certificate-id": "value",
                    "--certificate-management": [
                      "automatic",
                      "manual"
                    ],
                    "--no-certificate-id": "bool"
                  }
                }
              },
              "flags": {}
            },
            "firewall-rules": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--action": [
                      "ALLOW",
                      "DENY"
                    ],
                    "--description": "value",
                    "--source-range": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "test-ip": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--action": [
                      "ALLOW",
                      "DENY"
                    ],
                    "--description": "value",
                    "--source-range": "value"
                  }
                }
              },
              "flags": {}
            },
            "gen-config": {
              "commands": {},
              "flags": {
                "--config": "value",
                "--custom": "bool",
                "--runtime": "value"
              }
            },
            "instances": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--service": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--service": "value"
                  }
                },
                "disable-debug": {
                  "commands": {},
                  "flags": {
                    "--service": "value"
                  }
                },
                "enable-debug": {
                  "commands": {},
                  "flags": {
                    "--service": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--service": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "scp": {
                  "commands": {},
                  "flags": {
                    "--compress": "bool",
                    "--recurse": "bool",
                    "--service": "value"
                  }
                },
                "ssh": {
                  "commands": {},
                  "flags": {
                    "--container": "value",
                    "--service": "value"
                  }
                }
              },
              "flags": {}
            },
            "logs": {
              "commands": {
                "read": {
                  "commands": {},
                  "flags": {
                    "--level": [
                      "any",
                      "critical",
                      "debug",
                      "error",
                      "info",
                      "warning"
                    ],
                    "--limit": "value",
                    "--logs": "value",
                    "--service": "value"
                  }
                },
                "tail": {
                  "commands": {},
                  "flags": {
                    "--level": [
                      "any",
                      "critical",
                      "debug",
                      "error",
                      "info",
                      "warning"
                    ],
                    "--logs": "value",
                    "--service": "value"
                  }
                }
              },
              "flags": {}
            },
            "migrate-config": {
              "commands": {
                "cron-xml-to-yaml": {
                  "commands": {},
                  "flags": {}
                },
                "datastore-indexes-xml-to-yaml": {
                  "commands": {},
                  "flags": {
                    "--generated-indexes-file": "value"
                  }
                },
                "dispatch-xml-to-yaml": {
                  "commands": {},
                  "flags": {}
                },
                "queue-xml-to-yaml": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "open-console": {
              "commands": {},
              "flags": {
                "--logs": "bool",
                "--service": "value"
              }
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--pending": "bool",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "regions": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "repair": {
              "commands": {},
              "flags": {}
            },
            "services": {
              "commands": {
                "browse": {
                  "commands": {},
                  "flags": {
                    "--launch-browser": "bool"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-traffic": {
                  "commands": {},
                  "flags": {
                    "--migrate": "bool",
                    "--split-by": [
                      "cookie",
                      "ip",
                      "random"
                    ],
                    "--splits": "value"
                  }
                }
              },
              "flags": {}
            },
            "ssl-certificates": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--certificate": "value",
                    "--display-name": "value",
                    "--private-key": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--certificate": "value",
                    "--display-name": "value",
                    "--private-key": "value"
                  }
                }
              },
              "flags": {}
            },
            "update": {
              "commands": {},
              "flags": {
                "--split-health-checks": "bool",
                "--use-container-optimized-os": "bool"
              }
            },
            "versions": {
              "commands": {
                "browse": {
                  "commands": {},
                  "flags": {
                    "--launch-browser": "bool",
                    "--service": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--service": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--service": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--hide-no-traffic": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--service": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "migrate": {
                  "commands": {},
                  "flags": {
                    "--service": "value"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--service": "value"
                  }
                },
                "stop": {
                  "commands": {},
                  "flags": {
                    "--service": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "asset": {
          "commands": {
            "export": {
              "commands": {},
              "flags": {
                "--asset-types": "value",
                "--bigquery-dataset": "dynamic",
                "--bigquery-table": "dynamic",
                "--content-type": [
                  "access-policy",
                  "iam-policy",
                  "org-policy",
                  "resource"
                ],
                "--folder": "value",
                "--organization": "value",
                "--output-bigquery-force": "bool",
                "--output-path": "value",
                "--output-path-prefix": "value",
                "--snapshot-time": "value"
              }
            },
            "feeds": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--asset-names": "value",
                    "--asset-types": "value",
                    "--content-type": [
                      "iam-policy",
                      "resource"
                    ],
                    "--folder": "value",
                    "--organization": "value",
                    "--pubsub-topic": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-asset-names": "value",
                    "--add-asset-types": "value",
                    "--clear-asset-names": "bool",
                    "--clear-asset-types": "bool",
                    "--clear-content-type": "bool",
                    "--content-type": [
                      "iam-policy",
                      "resource"
                    ],
                    "--folder": "value",
                    "--organization": "value",
                    "--pubsub-topic": "value",
                    "--remove-asset-names": "value",
                    "--remove-asset-types": "value"
                  }
                }
              },
              "flags": {}
            },
            "get-history": {
              "commands": {},
              "flags": {
                "--asset-names": "value",
                "--content-type": [
                  "access-policy",
                  "iam-policy",
                  "org-policy",
                  "resource"
                ],
                "--end-time": "value",
                "--organization": "value",
                "--start-time": "value"
              }
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "auth": {
          "commands": {
            "activate-service-account": {
              "commands": {},
              "flags": {
                "--key-file": "value",
                "--password-file": "value",
                "--prompt-for-password": "bool"
              }
            },
            "application-default": {
              "commands": {
                "login": {
                  "commands": {},
                  "flags": {
                    "--client-id-file": "value",
                    "--launch-browser": "bool",
                    "--scopes": "value"
                  }
                },
                "print-access-token": {
                  "commands": {},
                  "flags": {}
                },
                "revoke": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "configure-docker": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--filter-account": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "login": {
              "commands": {},
              "flags": {
                "--activate": "bool",
                "--brief": "bool",
                "--enable-gdrive-access": "bool",
                "--force": "bool",
                "--launch-browser": "bool"
              }
            },
            "print-access-token": {
              "commands": {},
              "flags": {}
            },
            "print-identity-token": {
              "commands": {},
              "flags": {
                "--audiences": "value",
                "--include-email": "bool",
                "--include-license": "bool",
                "--token-format": [
                  "full",
                  "standard"
                ]
              }
            },
            "revoke": {
              "commands": {},
              "flags": {
                "--all": "bool"
              }
            }
          },
          "flags": {}
        },
        "bigtable": {
          "commands": {
            "app-profiles": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--force": "bool",
                    "--instance": "dynamic",
                    "--route-any": "bool",
                    "--route-to": "dynamic",
                    "--transactional-writes": "bool"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--force": "bool",
                    "--instance": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--force": "bool",
                    "--instance": "dynamic",
                    "--route-any": "bool",
                    "--route-to": "dynamic",
                    "--transactional-writes": "bool"
                  }
                }
              },
              "flags": {}
            },
            "clusters": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--instance": "dynamic",
                    "--num-nodes": "value",
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instances": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--instance": "dynamic",
                    "--num-nodes": "value"
                  }
                }
              },
              "flags": {}
            },
            "instances": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster": "dynamic",
                    "--cluster-num-nodes": "value",
                    "--cluster-storage-type": [
                      "hdd",
                      "ssd"
                    ],
                    "--cluster-zone": "value",
                    "--display-name": "value",
                    "--instance-type": [
                      "DEVELOPMENT",
                      "PRODUCTION"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "tables": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--instance": "dynamic",
                        "--member": "value",
                        "--role": "dynamic"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--instance": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--instances": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--instance": "dynamic",
                        "--member": "value",
                        "--role": "dynamic"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--instance": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--display-name": "value"
                  }
                },
                "upgrade": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "billing": {
          "commands": {
            "accounts": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "projects": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "link": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "dynamic",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "unlink": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "builds": {
          "commands": {
            "cancel": {
              "commands": {},
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--ongoing": "bool",
                "--page-size": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "log": {
              "commands": {},
              "flags": {
                "--stream": "bool"
              }
            },
            "submit": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--config": "value",
                "--disk-size": "value",
                "--gcs-log-dir": "value",
                "--gcs-source-staging-dir": "value",
                "--ignore-file": "value",
                "--machine-type": [
                  "n1-highcpu-32",
                  "n1-highcpu-8"
                ],
                "--no-cache": "bool",
                "--no-source": "bool",
                "--substitutions": "value",
                "--tag": "value",
                "--timeout": "value"
              }
            },
            "triggers": {
              "commands": {
                "create": {
                  "commands": {
                    "cloud-source-repositories": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--repo": "value",
                        "--substitutions": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value"
                      }
                    },
                    "github": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--comment-control": "bool",
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--pull-request-pattern": "value",
                        "--repo-name": "value",
                        "--repo-owner": "value",
                        "--substitutions": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "run": {
                  "commands": {},
                  "flags": {
                    "--branch": "value",
                    "--sha": "value",
                    "--tag": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "composer": {
          "commands": {
            "environments": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--airflow-configs": "value",
                    "--airflow-version": "value",
                    "--async": "bool",
                    "--cluster-ipv4-cidr": "value",
                    "--cluster-secondary-range-name": "value",
                    "--disk-size": "value",
                    "--enable-ip-alias": "bool",
                    "--enable-private-endpoint": "bool",
                    "--enable-private-environment": "bool",
                    "--env-variables": "value",
                    "--image-version": "value",
                    "--labels": "value",
                    "--location": "value",
                    "--machine-type": "value",
                    "--master-ipv4-cidr": "value",
                    "--network": "value",
                    "--node-count": "value",
                    "--oauth-scopes": "value",
                    "--python-version": [
                      "2",
                      "3"
                    ],
                    "--service-account": "value",
                    "--services-ipv4-cidr": "value",
                    "--services-secondary-range-name": "value",
                    "--subnetwork": "value",
                    "--tags": "value",
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--locations": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-upgrades": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "run": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "storage": {
                  "commands": {
                    "dags": {
                      "commands": {
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        },
                        "export": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "import": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "data": {
                      "commands": {
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        },
                        "export": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "import": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "plugins": {
                      "commands": {
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        },
                        "export": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "import": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--airflow-version": "value",
                    "--async": "bool",
                    "--clear-airflow-configs": "bool",
                    "--clear-env-variables": "bool",
                    "--clear-labels": "bool",
                    "--clear-pypi-packages": "bool",
                    "--image-version": "value",
                    "--location": "value",
                    "--node-count": "value",
                    "--remove-airflow-configs": "value",
                    "--remove-env-variables": "value",
                    "--remove-labels": "value",
                    "--remove-pypi-packages": "value",
                    "--update-airflow-configs": "value",
                    "--update-env-variables": "value",
                    "--update-labels": "value",
                    "--update-pypi-package": "value",
                    "--update-pypi-packages-from-file": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--locations": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "compute": {
          "commands": {
            "accelerator-types": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "addresses": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--addresses": "value",
                    "--description": "value",
                    "--global": "bool",
                    "--ip-version": [
                      "IPV4",
                      "IPV6"
                    ],
                    "--network": "value",
                    "--network-tier": "value",
                    "--prefix-length": "value",
                    "--purpose": [
                      "GCE_ENDPOINT",
                      "SHARED_LOADBALANCER_VIP",
                      "VPC_PEERING"
                    ],
                    "--region": "dynamic",
                    "--subnet": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--global": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "backend-buckets": {
              "commands": {
                "add-signed-url-key": {
                  "commands": {},
                  "flags": {
                    "--key-file": "value",
                    "--key-name": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--enable-cdn": "bool",
                    "--gcs-bucket-name": "dynamic",
                    "--signed-url-cache-max-age": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "delete-signed-url-key": {
                  "commands": {},
                  "flags": {
                    "--key-name": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--enable-cdn": "bool",
                    "--gcs-bucket-name": "dynamic",
                    "--signed-url-cache-max-age": "value"
                  }
                }
              },
              "flags": {}
            },
            "backend-services": {
              "commands": {
                "add-backend": {
                  "commands": {},
                  "flags": {
                    "--balancing-mode": [
                      "CONNECTION",
                      "RATE",
                      "UTILIZATION"
                    ],
                    "--capacity-scaler": "value",
                    "--description": "value",
                    "--failover": "bool",
                    "--global": "bool",
                    "--instance-group": "dynamic",
                    "--instance-group-region": "dynamic",
                    "--instance-group-zone": "dynamic",
                    "--max-connections": "value",
                    "--max-connections-per-endpoint": "value",
                    "--max-connections-per-instance": "value",
                    "--max-rate": "value",
                    "--max-rate-per-endpoint": "value",
                    "--max-rate-per-instance": "value",
                    "--max-utilization": "value",
                    "--network-endpoint-group": "value",
                    "--network-endpoint-group-zone": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "add-signed-url-key": {
                  "commands": {},
                  "flags": {
                    "--key-file": "value",
                    "--key-name": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--affinity-cookie-ttl": "value",
                    "--cache-key-include-host": "bool",
                    "--cache-key-include-protocol": "bool",
                    "--cache-key-include-query-string": "bool",
                    "--cache-key-query-string-blacklist": "value",
                    "--cache-key-query-string-whitelist": "value",
                    "--connection-drain-on-failover": "bool",
                    "--connection-draining-timeout": "value",
                    "--custom-request-header": "value",
                    "--description": "value",
                    "--drop-traffic-if-unhealthy": "bool",
                    "--enable-cdn": "bool",
                    "--enable-logging": "bool",
                    "--failover-ratio": "value",
                    "--global": "bool",
                    "--global-health-checks": "bool",
                    "--health-checks": "dynamic",
                    "--health-checks-region": "dynamic",
                    "--http-health-checks": "dynamic",
                    "--https-health-checks": "dynamic",
                    "--iap": "value",
                    "--load-balancing-scheme": [
                      "EXTERNAL",
                      "INTERNAL",
                      "INTERNAL_MANAGED",
                      "INTERNAL_SELF_MANAGED"
                    ],
                    "--logging-sample-rate": "value",
                    "--network": "value",
                    "--port-name": "value",
                    "--protocol": "value",
                    "--region": "dynamic",
                    "--session-affinity": [
                      "CLIENT_IP",
                      "CLIENT_IP_PORT_PROTO",
                      "CLIENT_IP_PROTO",
                      "GENERATED_COOKIE",
                      "HEADER_FIELD",
                      "HTTP_COOKIE",
                      "NONE"
                    ],
                    "--signed-url-cache-max-age": "value",
                    "--timeout": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "delete-signed-url-key": {
                  "commands": {},
                  "flags": {
                    "--key-name": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "edit": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "get-health": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-backend": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--instance-group": "dynamic",
                    "--instance-group-region": "dynamic",
                    "--instance-group-zone": "dynamic",
                    "--network-endpoint-group": "value",
                    "--network-endpoint-group-zone": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--affinity-cookie-ttl": "value",
                    "--cache-key-include-host": "bool",
                    "--cache-key-include-protocol": "bool",
                    "--cache-key-include-query-string": "bool",
                    "--cache-key-query-string-blacklist": "value",
                    "--cache-key-query-string-whitelist": "value",
                    "--connection-drain-on-failover": "bool",
                    "--connection-draining-timeout": "value",
                    "--custom-request-header": "value",
                    "--description": "value",
                    "--drop-traffic-if-unhealthy": "bool",
                    "--enable-cdn": "bool",
                    "--enable-logging": "bool",
                    "--failover-ratio": "value",
                    "--global": "bool",
                    "--global-health-checks": "bool",
                    "--health-checks": "dynamic",
                    "--health-checks-region": "dynamic",
                    "--http-health-checks": "dynamic",
                    "--https-health-checks": "dynamic",
                    "--iap": "value",
                    "--logging-sample-rate": "value",
                    "--no-custom-request-headers": "bool",
                    "--port-name": "value",
                    "--protocol": "value",
                    "--region": "dynamic",
                    "--security-policy": "dynamic",
                    "--session-affinity": [
                      "CLIENT_IP",
                      "CLIENT_IP_PORT_PROTO",
                      "CLIENT_IP_PROTO",
                      "GENERATED_COOKIE",
                      "HEADER_FIELD",
                      "HTTP_COOKIE",
                      "NONE"
                    ],
                    "--signed-url-cache-max-age": "value",
                    "--timeout": "value"
                  }
                },
                "update-backend": {
                  "commands": {},
                  "flags": {
                    "--balancing-mode": [
                      "CONNECTION",
                      "RATE",
                      "UTILIZATION"
                    ],
                    "--capacity-scaler": "value",
                    "--description": "value",
                    "--failover": "bool",
                    "--global": "bool",
                    "--instance-group": "dynamic",
                    "--instance-group-region": "dynamic",
                    "--instance-group-zone": "dynamic",
                    "--max-connections": "value",
                    "--max-connections-per-endpoint": "value",
                    "--max-connections-per-instance": "value",
                    "--max-rate": "value",
                    "--max-rate-per-endpoint": "value",
                    "--max-rate-per-instance": "value",
                    "--max-utilization": "value",
                    "--network-endpoint-group": "value",
                    "--network-endpoint-group-zone": "dynamic",
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "commitments": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--local-ssd": "value",
                    "--machine-type": "value",
                    "--min-cpu-platform": "value",
                    "--plan": [
                      "12-month",
                      "36-month"
                    ],
                    "--region": "dynamic",
                    "--require-specific-reservation": "bool",
                    "--reservation": "dynamic",
                    "--reservation-zone": "dynamic",
                    "--reservations-from-file": "value",
                    "--resources": "value",
                    "--resources-accelerator": "value",
                    "--type": [
                      "compute-optimized",
                      "general-purpose",
                      "general-purpose-e2",
                      "general-purpose-n2",
                      "general-purpose-n2d",
                      "memory-optimized"
                    ],
                    "--vm-count": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update-reservations": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--local-ssd": "value",
                    "--machine-type": "value",
                    "--min-cpu-platform": "value",
                    "--region": "dynamic",
                    "--require-specific-reservation": "bool",
                    "--reservation": "dynamic",
                    "--reservation-zone": "dynamic",
                    "--reservations-from-file": "value",
                    "--vm-count": "value"
                  }
                }
              },
              "flags": {}
            },
            "config-ssh": {
              "commands": {},
              "flags": {
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--remove": "bool",
                "--ssh-config-file": "value",
                "--ssh-key-file": "value"
              }
            },
            "connect-to-serial-port": {
              "commands": {},
              "flags": {
                "--dry-run": "bool",
                "--extra-args": "value",
                "--force-key-file-overwrite": "bool",
                "--port": "value",
                "--ssh-key-expiration": "value",
                "--ssh-key-expire-after": "value",
                "--ssh-key-file": "value",
                "--zone": "dynamic"
              }
            },
            "copy-files": {
              "commands": {},
              "flags": {
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--plain": "bool",
                "--ssh-key-expiration": "value",
                "--ssh-key-expire-after": "value",
                "--ssh-key-file": "value",
                "--strict-host-key-checking": [
                  "ask",
                  "no",
                  "yes"
                ],
                "--zone": "value"
              }
            },
            "diagnose": {
              "commands": {
                "routes": {
                  "commands": {},
                  "flags": {
                    "--container": "value",
                    "--dry-run": "bool",
                    "--external-route-ip": "value",
                    "--force-key-file-overwrite": "bool",
                    "--plain": "bool",
                    "--regexp": "value",
                    "--reverse-traceroute": "bool",
                    "--ssh-flag": "value",
                    "--ssh-key-expiration": "value",
                    "--ssh-key-expire-after": "value",
                    "--ssh-key-file": "value",
                    "--strict-host-key-checking": [
                      "ask",
                      "no",
                      "yes"
                    ],
                    "--user": "value",
                    "--zones": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "disk-types": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                }
              },
              "flags": {}
            },
            "disks": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--labels": "value",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "add-resource-policies": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--resource-policies": "value",
                    "--zone": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--csek-key-file": "value",
                    "--description": "value",
                    "--guest-os-features": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--licenses": "value",
                    "--physical-block-size": [
                      "16384",
                      "4096"
                    ],
                    "--region": "dynamic",
                    "--replica-zones": "value",
                    "--require-csek-key-create": "bool",
                    "--resource-policies": "value",
                    "--size": "value",
                    "--source-snapshot": "dynamic",
                    "--type": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                },
                "move": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination-zone": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "remove-labels": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--labels": "value",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "remove-resource-policies": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--resource-policies": "value",
                    "--zone": "dynamic"
                  }
                },
                "resize": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--size": "value",
                    "--zone": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "snapshot": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--csek-key-file": "value",
                    "--description": "value",
                    "--guest-flush": "bool",
                    "--labels": "value",
                    "--region": "dynamic",
                    "--snapshot-names": "value",
                    "--storage-location": "value",
                    "--zone": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "external-vpn-gateways": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--interfaces": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "firewall-rules": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--action": [
                      "ALLOW",
                      "DENY"
                    ],
                    "--allow": "value",
                    "--description": "value",
                    "--destination-ranges": "value",
                    "--direction": [
                      "EGRESS",
                      "IN",
                      "INGRESS",
                      "OUT"
                    ],
                    "--disabled": "bool",
                    "--enable-logging": "bool",
                    "--network": "value",
                    "--priority": "value",
                    "--rules": "value",
                    "--source-ranges": "value",
                    "--source-service-accounts": "value",
                    "--source-tags": "value",
                    "--target-service-accounts": "value",
                    "--target-tags": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--allow": "value",
                    "--description": "value",
                    "--destination-ranges": "value",
                    "--disabled": "bool",
                    "--enable-logging": "bool",
                    "--priority": "value",
                    "--rules": "value",
                    "--source-ranges": "value",
                    "--source-service-accounts": "value",
                    "--source-tags": "value",
                    "--target-service-accounts": "value",
                    "--target-tags": "value"
                  }
                }
              },
              "flags": {}
            },
            "forwarding-rules": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--address": "dynamic",
                    "--address-region": "dynamic",
                    "--allow-global-access": "bool",
                    "--backend-service": "value",
                    "--backend-service-region": "dynamic",
                    "--description": "value",
                    "--global": "bool",
                    "--global-address": "bool",
                    "--global-backend-service": "bool",
                    "--global-target-http-proxy": "bool",
                    "--global-target-https-proxy": "bool",
                    "--ip-protocol": [
                      "AH",
                      "ESP",
                      "ICMP",
                      "SCTP",
                      "TCP",
                      "UDP"
                    ],
                    "--ip-version": [
                      "IPV4",
                      "IPV6"
                    ],
                    "--is-mirroring-collector": "bool",
                    "--load-balancing-scheme": [
                      "EXTERNAL",
                      "INTERNAL",
                      "INTERNAL_MANAGED",
                      "INTERNAL_SELF_MANAGED"
                    ],
                    "--network": "value",
                    "--network-tier": "value",
                    "--port-range": "value",
                    "--ports": "value",
                    "--region": "dynamic",
                    "--service-label": "value",
                    "--subnet": "value",
                    "--subnet-region": "dynamic",
                    "--target-http-proxy": "value",
                    "--target-http-proxy-region": "dynamic",
                    "--target-https-proxy": "value",
                    "--target-https-proxy-region": "dynamic",
                    "--target-instance": "value",
                    "--target-instance-zone": "dynamic",
                    "--target-pool": "value",
                    "--target-pool-region": "dynamic",
                    "--target-ssl-proxy": "value",
                    "--target-tcp-proxy": "value",
                    "--target-vpn-gateway": "value",
                    "--target-vpn-gateway-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-target": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "value",
                    "--backend-service-region": "dynamic",
                    "--global": "bool",
                    "--global-backend-service": "bool",
                    "--global-target-http-proxy": "bool",
                    "--global-target-https-proxy": "bool",
                    "--load-balancing-scheme": [
                      "EXTERNAL",
                      "INTERNAL",
                      "INTERNAL_MANAGED",
                      "INTERNAL_SELF_MANAGED"
                    ],
                    "--network": "value",
                    "--region": "dynamic",
                    "--subnet": "value",
                    "--subnet-region": "dynamic",
                    "--target-http-proxy": "value",
                    "--target-http-proxy-region": "dynamic",
                    "--target-https-proxy": "value",
                    "--target-https-proxy-region": "dynamic",
                    "--target-instance": "value",
                    "--target-instance-zone": "dynamic",
                    "--target-pool": "value",
                    "--target-pool-region": "dynamic",
                    "--target-ssl-proxy": "value",
                    "--target-tcp-proxy": "value",
                    "--target-vpn-gateway": "value",
                    "--target-vpn-gateway-region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--allow-global-access": "bool",
                    "--clear-labels": "bool",
                    "--global": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "health-checks": {
              "commands": {
                "create": {
                  "commands": {
                    "http": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "http2": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "https": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "ssl": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "tcp": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--protocol": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {
                    "http": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "http2": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "https": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "ssl": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "tcp": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "http-health-checks": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--check-interval": "value",
                    "--description": "value",
                    "--healthy-threshold": "value",
                    "--host": "value",
                    "--port": "value",
                    "--request-path": "value",
                    "--timeout": "value",
                    "--unhealthy-threshold": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--check-interval": "value",
                    "--description": "value",
                    "--healthy-threshold": "value",
                    "--host": "value",
                    "--port": "value",
                    "--request-path": "value",
                    "--timeout": "value",
                    "--unhealthy-threshold": "value"
                  }
                }
              },
              "flags": {}
            },
            "https-health-checks": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--check-interval": "value",
                    "--description": "value",
                    "--healthy-threshold": "value",
                    "--host": "value",
                    "--port": "value",
                    "--request-path": "value",
                    "--timeout": "value",
                    "--unhealthy-threshold": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--check-interval": "value",
                    "--description": "value",
                    "--healthy-threshold": "value",
                    "--host": "value",
                    "--port": "value",
                    "--request-path": "value",
                    "--timeout": "value",
                    "--unhealthy-threshold": "value"
                  }
                }
              },
              "flags": {}
            },
            "images": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--labels": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--csek-key-file": "value",
                    "--description": "value",
                    "--family": "value",
                    "--force": "bool",
                    "--force-create": "bool",
                    "--guest-os-features": "value",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--licenses": "value",
                    "--require-csek-key-create": "bool",
                    "--source-disk": "dynamic",
                    "--source-disk-zone": "dynamic",
                    "--source-image": "value",
                    "--source-image-family": "value",
                    "--source-image-project": "value",
                    "--source-snapshot": "dynamic",
                    "--source-uri": "value",
                    "--storage-location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "deprecate": {
                  "commands": {},
                  "flags": {
                    "--delete-in": "value",
                    "--delete-on": "value",
                    "--deprecate-in": "value",
                    "--deprecate-on": "value",
                    "--obsolete-in": "value",
                    "--obsolete-on": "value",
                    "--replacement": "dynamic",
                    "--state": [
                      "ACTIVE",
                      "DELETED",
                      "DEPRECATED",
                      "OBSOLETE"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "describe-from-family": {
                  "commands": {},
                  "flags": {}
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination-uri": "value",
                    "--export-format": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--log-location": "value",
                    "--network": "value",
                    "--subnet": "value",
                    "--timeout": "value",
                    "--zone": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--data-disk": "bool",
                    "--description": "value",
                    "--family": "value",
                    "--guest-environment": "bool",
                    "--log-location": "value",
                    "--network": "value",
                    "--os": [
                      "centos-6",
                      "centos-7",
                      "debian-8",
                      "debian-9",
                      "rhel-6",
                      "rhel-6-byol",
                      "rhel-7",
                      "rhel-7-byol",
                      "ubuntu-1404",
                      "ubuntu-1604",
                      "windows-10-x64-byol",
                      "windows-10-x86-byol",
                      "windows-2008r2",
                      "windows-2008r2-byol",
                      "windows-2012",
                      "windows-2012-byol",
                      "windows-2012r2",
                      "windows-2012r2-byol",
                      "windows-2016",
                      "windows-2016-byol",
                      "windows-2019",
                      "windows-2019-byol",
                      "windows-7-x64-byol",
                      "windows-7-x86-byol",
                      "windows-8-x64-byol",
                      "windows-8-x86-byol"
                    ],
                    "--source-file": "value",
                    "--source-image": "dynamic",
                    "--storage-location": "value",
                    "--subnet": "value",
                    "--timeout": "value",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--preview-images": "bool",
                    "--regexp": "value",
                    "--show-deprecated": "bool",
                    "--sort-by": "value",
                    "--standard-images": "bool",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "remove-labels": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--labels": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "instance-groups": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "get-named-ports": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                },
                "list-instances": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "dynamic"
                  }
                },
                "managed": {
                  "commands": {
                    "abandon-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--base-instance-name": "value",
                        "--description": "value",
                        "--health-check": "dynamic",
                        "--http-health-check": "value",
                        "--https-health-check": "value",
                        "--initial-delay": "value",
                        "--instance-redistribution-type": [
                          "NONE",
                          "PROACTIVE"
                        ],
                        "--region": "dynamic",
                        "--size": "value",
                        "--target-pool": "value",
                        "--template": "value",
                        "--zone": "dynamic",
                        "--zones": "dynamic"
                      }
                    },
                    "create-instance": {
                      "commands": {},
                      "flags": {
                        "--instance": "value",
                        "--region": "dynamic",
                        "--stateful-disk": "value",
                        "--stateful-metadata": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "delete-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "export-autoscaling": {
                      "commands": {},
                      "flags": {
                        "--autoscaling-file": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "get-named-ports": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "dynamic",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--regions": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zones": "value"
                      }
                    },
                    "list-instances": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "dynamic",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "recreate-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "resize": {
                      "commands": {},
                      "flags": {
                        "--creation-retries": "bool",
                        "--region": "dynamic",
                        "--size": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "rolling-action": {
                      "commands": {
                        "replace": {
                          "commands": {},
                          "flags": {
                            "--max-surge": "value",
                            "--max-unavailable": "value",
                            "--min-ready": "value",
                            "--region": "dynamic",
                            "--zone": "dynamic"
                          }
                        },
                        "restart": {
                          "commands": {},
                          "flags": {
                            "--max-unavailable": "value",
                            "--min-ready": "value",
                            "--region": "dynamic",
                            "--zone": "dynamic"
                          }
                        },
                        "start-update": {
                          "commands": {},
                          "flags": {
                            "--canary-version": "value",
                            "--force": "bool",
                            "--max-surge": "value",
                            "--max-unavailable": "value",
                            "--min-ready": "value",
                            "--region": "dynamic",
                            "--type": [
                              "opportunistic",
                              "proactive"
                            ],
                            "--zone": "dynamic"
                          }
                        },
                        "stop-proactive-update": {
                          "commands": {},
                          "flags": {
                            "--region": "dynamic",
                            "--zone": "dynamic"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "set-autohealing": {
                      "commands": {},
                      "flags": {
                        "--health-check": "dynamic",
                        "--http-health-check": "value",
                        "--https-health-check": "value",
                        "--initial-delay": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "set-autoscaling": {
                      "commands": {},
                      "flags": {
                        "--autoscaling-file": "value",
                        "--cool-down-period": "value",
                        "--custom-metric-utilization": "value",
                        "--description": "value",
                        "--max-num-replicas": "value",
                        "--min-num-replicas": "value",
                        "--mode": [
                          "off",
                          "on",
                          "only-up"
                        ],
                        "--region": "dynamic",
                        "--remove-stackdriver-metric": "value",
                        "--scale-based-on-cpu": "bool",
                        "--scale-based-on-load-balancing": "bool",
                        "--stackdriver-metric-filter": "value",
                        "--stackdriver-metric-single-instance-assignment": "value",
                        "--stackdriver-metric-utilization-target": "value",
                        "--stackdriver-metric-utilization-target-type": [
                          "delta-per-minute",
                          "delta-per-second",
                          "gauge"
                        ],
                        "--target-cpu-utilization": "value",
                        "--target-load-balancing-utilization": "value",
                        "--update-stackdriver-metric": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "set-instance-template": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--template": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "set-named-ports": {
                      "commands": {},
                      "flags": {
                        "--named-ports": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "set-target-pools": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--target-pools": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "stop-autoscaling": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--clear-autohealing": "bool",
                        "--health-check": "dynamic",
                        "--http-health-check": "value",
                        "--https-health-check": "value",
                        "--initial-delay": "value",
                        "--instance-redistribution-type": [
                          "NONE",
                          "PROACTIVE"
                        ],
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "update-autoscaling": {
                      "commands": {},
                      "flags": {
                        "--mode": [
                          "off",
                          "on",
                          "only-up"
                        ],
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "update-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--minimal-action": [
                          "none",
                          "refresh",
                          "replace",
                          "restart"
                        ],
                        "--most-disruptive-allowed-action": [
                          "none",
                          "refresh",
                          "replace",
                          "restart"
                        ],
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "wait-until": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--stable": "bool",
                        "--timeout": "value",
                        "--version-target-reached": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "wait-until-stable": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--timeout": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "set-named-ports": {
                  "commands": {},
                  "flags": {
                    "--named-ports": "value",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "unmanaged": {
                  "commands": {
                    "add-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--description": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "get-named-ports": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "dynamic",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zones": "dynamic"
                      }
                    },
                    "list-instances": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "remove-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "set-named-ports": {
                      "commands": {},
                      "flags": {
                        "--named-ports": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "instance-templates": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--address": "value",
                    "--boot-disk-auto-delete": "bool",
                    "--boot-disk-device-name": "value",
                    "--boot-disk-kms-key": "dynamic",
                    "--boot-disk-kms-keyring": "dynamic",
                    "--boot-disk-kms-location": "dynamic",
                    "--boot-disk-kms-project": "dynamic",
                    "--boot-disk-size": "value",
                    "--boot-disk-type": "value",
                    "--can-ip-forward": "bool",
                    "--configure-disk": "value",
                    "--create-disk": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--description": "value",
                    "--disk": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--labels": "value",
                    "--local-ssd": "value",
                    "--machine-type": "dynamic",
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--network": "value",
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--node": "value",
                    "--node-affinity-file": "value",
                    "--node-group": "value",
                    "--preemptible": "bool",
                    "--private-network-ip": "value",
                    "--region": "dynamic",
                    "--reservation": "value",
                    "--reservation-affinity": [
                      "any",
                      "none",
                      "specific"
                    ],
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--source-instance": "dynamic",
                    "--source-instance-zone": "dynamic",
                    "--subnet": "value",
                    "--tags": "value"
                  }
                },
                "create-with-container": {
                  "commands": {},
                  "flags": {
                    "--address": "value",
                    "--boot-disk-auto-delete": "bool",
                    "--boot-disk-device-name": "value",
                    "--boot-disk-size": "value",
                    "--boot-disk-type": "value",
                    "--can-ip-forward": "bool",
                    "--container-arg": "value",
                    "--container-command": "value",
                    "--container-env": "value",
                    "--container-env-file": "value",
                    "--container-image": "value",
                    "--container-mount-disk": "value",
                    "--container-mount-host-path": "value",
                    "--container-mount-tmpfs": "value",
                    "--container-privileged": "bool",
                    "--container-restart-policy": [
                      "always",
                      "never",
                      "on-failure"
                    ],
                    "--container-stdin": "bool",
                    "--container-tty": "bool",
                    "--create-disk": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--description": "value",
                    "--disk": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--labels": "value",
                    "--local-ssd": "value",
                    "--machine-type": "dynamic",
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--network": "value",
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--preemptible": "bool",
                    "--private-network-ip": "value",
                    "--region": "dynamic",
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--subnet": "value",
                    "--tags": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "instances": {
              "commands": {
                "add-access-config": {
                  "commands": {},
                  "flags": {
                    "--access-config-name": "value",
                    "--address": "value",
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-public-ptr": "bool",
                    "--no-public-ptr-domain": "bool",
                    "--public-ptr": "bool",
                    "--public-ptr-domain": "value",
                    "--zone": "dynamic"
                  }
                },
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--labels": "value",
                    "--zone": "dynamic"
                  }
                },
                "add-metadata": {
                  "commands": {},
                  "flags": {
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--zone": "dynamic"
                  }
                },
                "add-tags": {
                  "commands": {},
                  "flags": {
                    "--tags": "value",
                    "--zone": "dynamic"
                  }
                },
                "attach-disk": {
                  "commands": {},
                  "flags": {
                    "--boot": "bool",
                    "--csek-key-file": "value",
                    "--device-name": "value",
                    "--disk": "value",
                    "--disk-scope": [
                      "regional",
                      "zonal"
                    ],
                    "--force-attach": "bool",
                    "--mode": [
                      "ro",
                      "rw"
                    ],
                    "--zone": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--address": "value",
                    "--async": "bool",
                    "--boot-disk-auto-delete": "bool",
                    "--boot-disk-device-name": "value",
                    "--boot-disk-kms-key": "dynamic",
                    "--boot-disk-kms-keyring": "dynamic",
                    "--boot-disk-kms-location": "dynamic",
                    "--boot-disk-kms-project": "dynamic",
                    "--boot-disk-size": "value",
                    "--boot-disk-type": "value",
                    "--can-ip-forward": "bool",
                    "--create-disk": "value",
                    "--csek-key-file": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--deletion-protection": "bool",
                    "--description": "value",
                    "--disk": "value",
                    "--enable-display-device": "bool",
                    "--hostname": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--labels": "value",
                    "--local-ssd": "value",
                    "--machine-type": "dynamic",
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--network": "value",
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-public-ptr": "bool",
                    "--no-public-ptr-domain": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--node": "value",
                    "--node-affinity-file": "value",
                    "--node-group": "value",
                    "--preemptible": "bool",
                    "--private-network-ip": "value",
                    "--public-ptr": "bool",
                    "--public-ptr-domain": "value",
                    "--require-csek-key-create": "bool",
                    "--reservation": "value",
                    "--reservation-affinity": [
                      "any",
                      "none",
                      "specific"
                    ],
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--source-instance-template": "dynamic",
                    "--source-snapshot": "value",
                    "--subnet": "value",
                    "--tags": "value",
                    "--zone": "dynamic"
                  }
                },
                "create-with-container": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--address": "value",
                    "--boot-disk-auto-delete": "bool",
                    "--boot-disk-device-name": "value",
                    "--boot-disk-size": "value",
                    "--boot-disk-type": "value",
                    "--can-ip-forward": "bool",
                    "--container-arg": "value",
                    "--container-command": "value",
                    "--container-env": "value",
                    "--container-env-file": "value",
                    "--container-image": "value",
                    "--container-mount-disk": "value",
                    "--container-mount-host-path": "value",
                    "--container-mount-tmpfs": "value",
                    "--container-privileged": "bool",
                    "--container-restart-policy": [
                      "always",
                      "never",
                      "on-failure"
                    ],
                    "--container-stdin": "bool",
                    "--container-tty": "bool",
                    "--create-disk": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--description": "value",
                    "--disk": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--labels": "value",
                    "--local-ssd": "value",
                    "--machine-type": "dynamic",
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--network": "value",
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-public-dns": "bool",
                    "--no-public-ptr": "bool",
                    "--no-public-ptr-domain": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--preemptible": "bool",
                    "--private-network-ip": "value",
                    "--public-dns": "bool",
                    "--public-ptr": "bool",
                    "--public-ptr-domain": "value",
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--source-instance-template": "dynamic",
                    "--subnet": "value",
                    "--tags": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--delete-disks": [
                      "all",
                      "boot",
                      "data"
                    ],
                    "--keep-disks": [
                      "all",
                      "boot",
                      "data"
                    ],
                    "--zone": "dynamic"
                  }
                },
                "delete-access-config": {
                  "commands": {},
                  "flags": {
                    "--access-config-name": "value",
                    "--network-interface": "value",
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "detach-disk": {
                  "commands": {},
                  "flags": {
                    "--device-name": "value",
                    "--disk": "value",
                    "--disk-scope": [
                      "regional",
                      "zonal"
                    ],
                    "--zone": "dynamic"
                  }
                },
                "get-guest-attributes": {
                  "commands": {},
                  "flags": {
                    "--query-path": "value",
                    "--zone": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--zone": "value"
                  }
                },
                "get-serial-port-output": {
                  "commands": {},
                  "flags": {
                    "--port": "value",
                    "--start": "value",
                    "--zone": "dynamic"
                  }
                },
                "get-shielded-identity": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--can-ip-forward": "bool",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--deletion-protection": "bool",
                    "--description": "value",
                    "--guest-environment": "bool",
                    "--labels": "value",
                    "--machine-type": "dynamic",
                    "--network": "value",
                    "--network-tier": "value",
                    "--node": "value",
                    "--node-affinity-file": "value",
                    "--node-group": "value",
                    "--os": [
                      "centos-6",
                      "centos-7",
                      "debian-8",
                      "debian-9",
                      "rhel-6",
                      "rhel-6-byol",
                      "rhel-7",
                      "rhel-7-byol",
                      "ubuntu-1404",
                      "ubuntu-1604",
                      "windows-10-x64-byol",
                      "windows-10-x86-byol",
                      "windows-2008r2",
                      "windows-2008r2-byol",
                      "windows-2012",
                      "windows-2012-byol",
                      "windows-2012r2",
                      "windows-2012r2-byol",
                      "windows-2016",
                      "windows-2016-byol",
                      "windows-2019",
                      "windows-2019-byol",
                      "windows-7-x64-byol",
                      "windows-7-x86-byol",
                      "windows-8-x64-byol",
                      "windows-8-x86-byol"
                    ],
                    "--private-network-ip": "value",
                    "--restart-on-failure": "bool",
                    "--source-uri": "value",
                    "--subnet": "value",
                    "--tags": "value",
                    "--timeout": "value",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "dynamic"
                  }
                },
                "move": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination-zone": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "network-interfaces": {
                  "commands": {
                    "update": {
                      "commands": {},
                      "flags": {
                        "--aliases": "value",
                        "--network-interface": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "os-inventory": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "list-instances": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--inventory-filter": "value",
                        "--kernel-version": "value",
                        "--limit": "value",
                        "--os-shortname": "value",
                        "--os-version": "value",
                        "--package-name": "value",
                        "--package-version": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "remove-labels": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--labels": "value",
                    "--zone": "dynamic"
                  }
                },
                "remove-metadata": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--keys": "value",
                    "--zone": "dynamic"
                  }
                },
                "remove-tags": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--tags": "value",
                    "--zone": "dynamic"
                  }
                },
                "reset": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "set-disk-auto-delete": {
                  "commands": {},
                  "flags": {
                    "--auto-delete": "bool",
                    "--device-name": "value",
                    "--disk": "value",
                    "--zone": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "set-machine-type": {
                  "commands": {},
                  "flags": {
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--machine-type": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "set-scheduling": {
                  "commands": {},
                  "flags": {
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--restart-on-failure": "bool",
                    "--zone": "dynamic"
                  }
                },
                "set-scopes": {
                  "commands": {},
                  "flags": {
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--zone": "dynamic"
                  }
                },
                "simulate-maintenance-event": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "dynamic"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--csek-key-file": "value",
                    "--zone": "dynamic"
                  }
                },
                "stop": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "dynamic"
                  }
                },
                "tail-serial-port-output": {
                  "commands": {},
                  "flags": {
                    "--port": "value",
                    "--zone": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--deletion-protection": "bool",
                    "--enable-display-device": "bool",
                    "--min-cpu-platform": "value",
                    "--remove-labels": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-learn-integrity-policy": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--update-labels": "value",
                    "--zone": "dynamic"
                  }
                },
                "update-access-config": {
                  "commands": {},
                  "flags": {
                    "--network-interface": "value",
                    "--no-public-ptr": "bool",
                    "--no-public-ptr-domain": "bool",
                    "--public-ptr": "bool",
                    "--public-ptr-domain": "value",
                    "--zone": "dynamic"
                  }
                },
                "update-container": {
                  "commands": {},
                  "flags": {
                    "--clear-container-args": "bool",
                    "--clear-container-command": "bool",
                    "--container-arg": "value",
                    "--container-command": "value",
                    "--container-env": "value",
                    "--container-env-file": "value",
                    "--container-image": "value",
                    "--container-mount-disk": "value",
                    "--container-mount-host-path": "value",
                    "--container-mount-tmpfs": "value",
                    "--container-privileged": "bool",
                    "--container-restart-policy": [
                      "always",
                      "never",
                      "on-failure"
                    ],
                    "--container-stdin": "bool",
                    "--container-tty": "bool",
                    "--remove-container-env": "value",
                    "--remove-container-mounts": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "interconnects": {
              "commands": {
                "attachments": {
                  "commands": {
                    "dedicated": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--bandwidth": [
                              "100m",
                              "10g",
                              "1g",
                              "200m",
                              "20g",
                              "2g",
                              "300m",
                              "400m",
                              "500m",
                              "50g",
                              "50m",
                              "5g"
                            ],
                            "--candidate-subnets": "value",
                            "--description": "value",
                            "--enable-admin": "bool",
                            "--interconnect": "dynamic",
                            "--region": "dynamic",
                            "--router": "dynamic",
                            "--vlan": "value"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--bandwidth": [
                              "100m",
                              "10g",
                              "1g",
                              "200m",
                              "20g",
                              "2g",
                              "300m",
                              "400m",
                              "500m",
                              "50g",
                              "50m",
                              "5g"
                            ],
                            "--clear-labels": "bool",
                            "--description": "value",
                            "--enable-admin": "bool",
                            "--region": "dynamic",
                            "--remove-labels": "value",
                            "--update-labels": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "partner": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--description": "value",
                            "--edge-availability-domain": [
                              "any",
                              "availability-domain-1",
                              "availability-domain-2"
                            ],
                            "--enable-admin": "bool",
                            "--region": "dynamic",
                            "--router": "dynamic"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--clear-labels": "bool",
                            "--description": "value",
                            "--enable-admin": "bool",
                            "--region": "dynamic",
                            "--remove-labels": "value",
                            "--update-labels": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--admin-enabled": "bool",
                    "--customer-name": "value",
                    "--description": "value",
                    "--interconnect-type": [
                      "DEDICATED",
                      "IT_PRIVATE",
                      "PARTNER"
                    ],
                    "--link-type": [
                      "LINK_TYPE_ETHERNET_100G_LR",
                      "LINK_TYPE_ETHERNET_10G_LR"
                    ],
                    "--location": "dynamic",
                    "--noc-contact-email": "value",
                    "--requested-link-count": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-diagnostics": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "locations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--admin-enabled": "bool",
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--noc-contact-email": "value",
                    "--remove-labels": "value",
                    "--requested-link-count": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "machine-types": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "network-endpoint-groups": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--default-port": "value",
                    "--network": "value",
                    "--subnet": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-network-endpoints": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--zone": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-endpoint": "value",
                    "--remove-endpoint": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "networks": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--bgp-routing-mode": [
                      "global",
                      "regional"
                    ],
                    "--description": "value",
                    "--range": "value",
                    "--subnet-mode": [
                      "auto",
                      "custom",
                      "legacy"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "peerings": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--auto-create-routes": "bool",
                        "--export-custom-routes": "bool",
                        "--import-custom-routes": "bool",
                        "--network": "value",
                        "--peer-network": "value",
                        "--peer-project": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--network": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--network": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list-routes": {
                      "commands": {},
                      "flags": {
                        "--direction": [
                          "INCOMING",
                          "OUTGOING"
                        ],
                        "--filter": "value",
                        "--limit": "value",
                        "--network": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--export-custom-routes": "bool",
                        "--import-custom-routes": "bool",
                        "--network": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "subnets": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--member": "value",
                        "--region": "value",
                        "--role": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--description": "value",
                        "--enable-flow-logs": "bool",
                        "--enable-private-ip-google-access": "bool",
                        "--logging-aggregation-interval": [
                          "interval-1-min",
                          "interval-10-min",
                          "interval-15-min",
                          "interval-30-sec",
                          "interval-5-min",
                          "interval-5-sec"
                        ],
                        "--logging-flow-sampling": "value",
                        "--logging-metadata": [
                          "exclude-all",
                          "include-all"
                        ],
                        "--network": "dynamic",
                        "--private-ipv6-google-access-type": [
                          "disable",
                          "enable-bidirectional-access",
                          "enable-outbound-vm-access"
                        ],
                        "--purpose": [
                          "INTERNAL_HTTPS_LOAD_BALANCER",
                          "PRIVATE"
                        ],
                        "--range": "value",
                        "--region": "dynamic",
                        "--role": [
                          "ACTIVE",
                          "BACKUP"
                        ],
                        "--secondary-range": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "expand-ip-range": {
                      "commands": {},
                      "flags": {
                        "--prefix-length": "value",
                        "--region": "dynamic"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--network": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--regions": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list-usable": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--member": "value",
                        "--region": "value",
                        "--role": "dynamic"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--region": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--add-secondary-ranges": "value",
                        "--drain-timeout": "value",
                        "--enable-flow-logs": "bool",
                        "--enable-private-ip-google-access": "bool",
                        "--logging-aggregation-interval": [
                          "interval-1-min",
                          "interval-10-min",
                          "interval-15-min",
                          "interval-30-sec",
                          "interval-5-min",
                          "interval-5-sec"
                        ],
                        "--logging-flow-sampling": "value",
                        "--logging-metadata": [
                          "exclude-all",
                          "include-all"
                        ],
                        "--private-ipv6-google-access-type": [
                          "disable",
                          "enable-bidirectional-access",
                          "enable-outbound-vm-access"
                        ],
                        "--region": "dynamic",
                        "--remove-secondary-ranges": "value",
                        "--role": [
                          "ACTIVE"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--bgp-routing-mode": [
                      "global",
                      "regional"
                    ],
                    "--switch-to-custom-subnet-mode": "bool"
                  }
                },
                "vpc-access": {
                  "commands": {
                    "connectors": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--async": "bool",
                            "--max-throughput": "value",
                            "--min-throughput": "value",
                            "--network": "value",
                            "--range": "value",
                            "--region": "dynamic"
                          }
                        },
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--async": "bool",
                            "--region": "dynamic"
                          }
                        },
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--region": "dynamic"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--region": "dynamic",
                            "--sort-by": "value",
                            "--uri": "bool"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "locations": {
                      "commands": {
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value",
                            "--uri": "bool"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "operations": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--region": "dynamic"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--region": "dynamic",
                            "--sort-by": "value",
                            "--uri": "bool"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                }
              },
              "flags": {}
            },
            "os-config": {
              "commands": {
                "patch-deployments": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--file": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {}
                    },
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "patch-jobs": {
                  "commands": {
                    "cancel": {
                      "commands": {},
                      "flags": {}
                    },
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "execute": {
                      "commands": {},
                      "flags": {
                        "--apt-dist": "bool",
                        "--apt-excludes": "value",
                        "--apt-exclusive-packages": "value",
                        "--async": "bool",
                        "--description": "value",
                        "--display-name": "value",
                        "--dry-run": "bool",
                        "--duration": "value",
                        "--instance-filter-all": "bool",
                        "--instance-filter-group-labels": "value",
                        "--instance-filter-name-prefixes": "value",
                        "--instance-filter-names": "value",
                        "--instance-filter-zones": "value",
                        "--post-patch-linux-executable": "value",
                        "--post-patch-linux-success-codes": "value",
                        "--post-patch-windows-executable": "value",
                        "--post-patch-windows-success-codes": "value",
                        "--pre-patch-linux-executable": "value",
                        "--pre-patch-linux-success-codes": "value",
                        "--pre-patch-windows-executable": "value",
                        "--pre-patch-windows-success-codes": "value",
                        "--reboot-config": [
                          "always",
                          "default",
                          "never"
                        ],
                        "--windows-classifications": "value",
                        "--windows-excludes": "value",
                        "--windows-exclusive-patches": "value",
                        "--yum-excludes": "value",
                        "--yum-exclusive-packages": "value",
                        "--yum-minimal": "bool",
                        "--yum-security": "bool",
                        "--zypper-categories": "value",
                        "--zypper-exclusive-patches": "value",
                        "--zypper-severities": "value",
                        "--zypper-with-optional": "bool",
                        "--zypper-with-update": "bool"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list-instance-details": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "os-login": {
              "commands": {
                "describe-profile": {
                  "commands": {},
                  "flags": {}
                },
                "remove-profile": {
                  "commands": {},
                  "flags": {}
                },
                "ssh-keys": {
                  "commands": {
                    "add": {
                      "commands": {},
                      "flags": {
                        "--key": "value",
                        "--key-file": "value",
                        "--ttl": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--key": "value",
                        "--key-file": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "remove": {
                      "commands": {},
                      "flags": {
                        "--key": "value",
                        "--key-file": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--key": "value",
                        "--key-file": "value",
                        "--ttl": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "packet-mirrorings": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--collector-ilb": "value",
                    "--description": "value",
                    "--enable": "bool",
                    "--filter-cidr-ranges": "value",
                    "--filter-protocols": "value",
                    "--mirrored-instances": "value",
                    "--mirrored-subnets": "value",
                    "--mirrored-tags": "value",
                    "--network": "value",
                    "--priority": "value",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-filter-cidr-ranges": "value",
                    "--add-filter-protocols": "value",
                    "--add-mirrored-instances": "value",
                    "--add-mirrored-subnets": "value",
                    "--add-mirrored-tags": "value",
                    "--async": "bool",
                    "--clear-filter-cidr-ranges": "bool",
                    "--clear-filter-protocols": "bool",
                    "--clear-mirrored-instances": "bool",
                    "--clear-mirrored-subnets": "bool",
                    "--clear-mirrored-tags": "bool",
                    "--collector-ilb": "value",
                    "--description": "value",
                    "--enable": "bool",
                    "--priority": "value",
                    "--region": "dynamic",
                    "--remove-filter-cidr-ranges": "value",
                    "--remove-filter-protocols": "value",
                    "--remove-mirrored-instances": "value",
                    "--remove-mirrored-subnets": "value",
                    "--remove-mirrored-tags": "value",
                    "--set-filter-cidr-ranges": "value",
                    "--set-filter-protocols": "value",
                    "--set-mirrored-instances": "value",
                    "--set-mirrored-subnets": "value",
                    "--set-mirrored-tags": "value"
                  }
                }
              },
              "flags": {}
            },
            "project-info": {
              "commands": {
                "add-metadata": {
                  "commands": {},
                  "flags": {
                    "--metadata": "value",
                    "--metadata-from-file": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "remove-metadata": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--keys": "value"
                  }
                },
                "set-usage-bucket": {
                  "commands": {},
                  "flags": {
                    "--bucket": "value",
                    "--no-bucket": "bool",
                    "--prefix": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--default-network-tier": [
                      "PREMIUM",
                      "STANDARD"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "regions": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "reservations": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--description": "value",
                    "--local-ssd": "value",
                    "--machine-type": "value",
                    "--min-cpu-platform": "value",
                    "--require-specific-reservation": "bool",
                    "--vm-count": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--vm-count": "value",
                    "--zone": "value"
                  }
                }
              },
              "flags": {}
            },
            "reset-windows-password": {
              "commands": {},
              "flags": {
                "--user": "value",
                "--zone": "dynamic"
              }
            },
            "resource-policies": {
              "commands": {
                "create": {
                  "commands": {
                    "snapshot-schedule": {
                      "commands": {},
                      "flags": {
                        "--daily-schedule": "bool",
                        "--description": "value",
                        "--guest-flush": "bool",
                        "--hourly-schedule": "value",
                        "--max-retention-days": "value",
                        "--on-source-disk-delete": [
                          "apply-retention-policy",
                          "keep-auto-snapshots"
                        ],
                        "--region": "dynamic",
                        "--snapshot-labels": "value",
                        "--start-time": "value",
                        "--storage-location": "value",
                        "--weekly-schedule": [
                          "friday",
                          "monday",
                          "saturday",
                          "sunday",
                          "thursday",
                          "tuesday",
                          "wednesday"
                        ],
                        "--weekly-schedule-from-file": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "create-snapshot-schedule": {
                  "commands": {},
                  "flags": {
                    "--daily-schedule": "bool",
                    "--description": "value",
                    "--guest-flush": "bool",
                    "--hourly-schedule": "value",
                    "--max-retention-days": "value",
                    "--on-source-disk-delete": [
                      "apply-retention-policy",
                      "keep-auto-snapshots"
                    ],
                    "--region": "dynamic",
                    "--snapshot-labels": "value",
                    "--start-time": "value",
                    "--storage-location": "value",
                    "--weekly-schedule": [
                      "friday",
                      "monday",
                      "saturday",
                      "sunday",
                      "thursday",
                      "tuesday",
                      "wednesday"
                    ],
                    "--weekly-schedule-from-file": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "routers": {
              "commands": {
                "add-bgp-peer": {
                  "commands": {},
                  "flags": {
                    "--advertised-route-priority": "value",
                    "--advertisement-mode": [
                      "CUSTOM",
                      "DEFAULT"
                    ],
                    "--async": "bool",
                    "--interface": "value",
                    "--peer-asn": "value",
                    "--peer-ip-address": "value",
                    "--peer-name": "value",
                    "--region": "dynamic",
                    "--set-advertisement-groups": "value",
                    "--set-advertisement-ranges": "value"
                  }
                },
                "add-interface": {
                  "commands": {},
                  "flags": {
                    "--interconnect-attachment": "dynamic",
                    "--interconnect-attachment-region": "dynamic",
                    "--interface-name": "value",
                    "--ip-address": "value",
                    "--mask-length": "value",
                    "--region": "dynamic",
                    "--vpn-tunnel": "dynamic",
                    "--vpn-tunnel-region": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--advertisement-mode": [
                      "CUSTOM",
                      "DEFAULT"
                    ],
                    "--asn": "value",
                    "--async": "bool",
                    "--description": "value",
                    "--network": "dynamic",
                    "--region": "dynamic",
                    "--set-advertisement-groups": "value",
                    "--set-advertisement-ranges": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "get-nat-mapping-info": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value"
                  }
                },
                "get-status": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "nats": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--auto-allocate-nat-external-ips": "bool",
                        "--enable-logging": "bool",
                        "--icmp-idle-timeout": "value",
                        "--log-filter": [
                          "ALL",
                          "ERRORS_ONLY",
                          "TRANSLATIONS_ONLY"
                        ],
                        "--min-ports-per-vm": "value",
                        "--nat-all-subnet-ip-ranges": "bool",
                        "--nat-custom-subnet-ip-ranges": "value",
                        "--nat-external-ip-pool": "value",
                        "--nat-primary-subnet-ip-ranges": "bool",
                        "--region": "dynamic",
                        "--router": "dynamic",
                        "--tcp-established-idle-timeout": "value",
                        "--tcp-transitory-idle-timeout": "value",
                        "--udp-idle-timeout": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--router": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--router": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--router": "dynamic"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--auto-allocate-nat-external-ips": "bool",
                        "--clear-icmp-idle-timeout": "bool",
                        "--clear-min-ports-per-vm": "bool",
                        "--clear-nat-external-drain-ip-pool": "bool",
                        "--clear-tcp-established-idle-timeout": "bool",
                        "--clear-tcp-transitory-idle-timeout": "bool",
                        "--clear-udp-idle-timeout": "bool",
                        "--enable-logging": "bool",
                        "--icmp-idle-timeout": "value",
                        "--log-filter": [
                          "ALL",
                          "ERRORS_ONLY",
                          "TRANSLATIONS_ONLY"
                        ],
                        "--min-ports-per-vm": "value",
                        "--nat-all-subnet-ip-ranges": "bool",
                        "--nat-custom-subnet-ip-ranges": "value",
                        "--nat-external-drain-ip-pool": "value",
                        "--nat-external-ip-pool": "value",
                        "--nat-primary-subnet-ip-ranges": "bool",
                        "--region": "dynamic",
                        "--router": "dynamic",
                        "--tcp-established-idle-timeout": "value",
                        "--tcp-transitory-idle-timeout": "value",
                        "--udp-idle-timeout": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "remove-bgp-peer": {
                  "commands": {},
                  "flags": {
                    "--peer-name": "value",
                    "--region": "dynamic"
                  }
                },
                "remove-interface": {
                  "commands": {},
                  "flags": {
                    "--interface-name": "value",
                    "--region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-advertisement-groups": "value",
                    "--add-advertisement-ranges": "value",
                    "--advertisement-mode": [
                      "CUSTOM",
                      "DEFAULT"
                    ],
                    "--async": "bool",
                    "--region": "dynamic",
                    "--remove-advertisement-groups": "value",
                    "--remove-advertisement-ranges": "value",
                    "--set-advertisement-groups": "value",
                    "--set-advertisement-ranges": "value"
                  }
                },
                "update-bgp-peer": {
                  "commands": {},
                  "flags": {
                    "--add-advertisement-groups": "value",
                    "--add-advertisement-ranges": "value",
                    "--advertised-route-priority": "value",
                    "--advertisement-mode": [
                      "CUSTOM",
                      "DEFAULT"
                    ],
                    "--async": "bool",
                    "--interface": "value",
                    "--ip-address": "value",
                    "--peer-asn": "value",
                    "--peer-ip-address": "value",
                    "--peer-name": "value",
                    "--region": "dynamic",
                    "--remove-advertisement-groups": "value",
                    "--remove-advertisement-ranges": "value",
                    "--set-advertisement-groups": "value",
                    "--set-advertisement-ranges": "value"
                  }
                },
                "update-interface": {
                  "commands": {},
                  "flags": {
                    "--interconnect-attachment": "dynamic",
                    "--interconnect-attachment-region": "dynamic",
                    "--interface-name": "value",
                    "--ip-address": "value",
                    "--mask-length": "value",
                    "--region": "dynamic",
                    "--vpn-tunnel": "dynamic",
                    "--vpn-tunnel-region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "routes": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--destination-range": "value",
                    "--network": "value",
                    "--next-hop-address": "value",
                    "--next-hop-gateway": "dynamic",
                    "--next-hop-ilb": "value",
                    "--next-hop-ilb-region": "value",
                    "--next-hop-instance": "value",
                    "--next-hop-instance-zone": "value",
                    "--next-hop-vpn-tunnel": "value",
                    "--next-hop-vpn-tunnel-region": "value",
                    "--priority": "value",
                    "--tags": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "scp": {
              "commands": {},
              "flags": {
                "--compress": "bool",
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--internal-ip": "bool",
                "--plain": "bool",
                "--port": "value",
                "--recurse": "bool",
                "--scp-flag": "value",
                "--ssh-key-expiration": "value",
                "--ssh-key-expire-after": "value",
                "--ssh-key-file": "value",
                "--strict-host-key-checking": [
                  "ask",
                  "no",
                  "yes"
                ],
                "--tunnel-through-iap": "bool",
                "--zone": "value"
              }
            },
            "security-policies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--file-format": [
                      "json",
                      "yaml"
                    ],
                    "--file-name": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--file-format": [
                      "json",
                      "yaml"
                    ],
                    "--file-name": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--file-format": [
                      "json",
                      "yaml"
                    ],
                    "--file-name": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-preconfigured-expression-sets": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "rules": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny-403",
                          "deny-404",
                          "deny-502"
                        ],
                        "--description": "value",
                        "--expression": "value",
                        "--preview": "bool",
                        "--security-policy": "dynamic",
                        "--src-ip-ranges": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--security-policy": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--security-policy": "dynamic"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny-403",
                          "deny-404",
                          "deny-502"
                        ],
                        "--description": "value",
                        "--expression": "value",
                        "--preview": "bool",
                        "--security-policy": "dynamic",
                        "--src-ip-ranges": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "shared-vpc": {
              "commands": {
                "associated-projects": {
                  "commands": {
                    "add": {
                      "commands": {},
                      "flags": {
                        "--host-project": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove": {
                      "commands": {},
                      "flags": {
                        "--host-project": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "disable": {
                  "commands": {},
                  "flags": {}
                },
                "enable": {
                  "commands": {},
                  "flags": {}
                },
                "get-host-project": {
                  "commands": {},
                  "flags": {}
                },
                "list-associated-resources": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "organizations": {
                  "commands": {
                    "list-host-projects": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "sign-url": {
              "commands": {},
              "flags": {
                "--expires-in": "value",
                "--key-file": "value",
                "--key-name": "value",
                "--validate": "bool"
              }
            },
            "snapshots": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--labels": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "remove-labels": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--labels": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "sole-tenancy": {
              "commands": {
                "node-groups": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--member": "value",
                        "--role": "dynamic",
                        "--zone": "value"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--autoscaler-mode": [
                          "off",
                          "on",
                          "only-scale-out"
                        ],
                        "--description": "value",
                        "--max-nodes": "value",
                        "--min-nodes": "value",
                        "--node-template": "value",
                        "--target-size": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--zone": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list-nodes": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--member": "value",
                        "--role": "dynamic",
                        "--zone": "value"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--zone": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--add-nodes": "value",
                        "--autoscaler-mode": [
                          "off",
                          "on",
                          "only-scale-out"
                        ],
                        "--delete-nodes": "value",
                        "--max-nodes": "value",
                        "--min-nodes": "value",
                        "--node-template": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "node-templates": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--member": "value",
                        "--region": "value",
                        "--role": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--description": "value",
                        "--node-affinity-labels": "value",
                        "--node-requirements": "value",
                        "--node-type": "value",
                        "--region": "dynamic",
                        "--server-binding": [
                          "restart-node-on-any-server",
                          "restart-node-on-minimal-servers"
                        ]
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--member": "value",
                        "--region": "value",
                        "--role": "dynamic"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--region": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "node-types": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "ssh": {
              "commands": {},
              "flags": {
                "--command": "value",
                "--container": "value",
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--internal-ip": "bool",
                "--plain": "bool",
                "--ssh-flag": "value",
                "--ssh-key-expiration": "value",
                "--ssh-key-expire-after": "value",
                "--ssh-key-file": "value",
                "--strict-host-key-checking": [
                  "ask",
                  "no",
                  "yes"
                ],
                "--tunnel-through-iap": "bool",
                "--zone": "dynamic"
              }
            },
            "ssl-certificates": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--certificate": "value",
                    "--description": "value",
                    "--domains": "value",
                    "--global": "bool",
                    "--private-key": "value",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "ssl-policies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--custom-features": "value",
                    "--description": "value",
                    "--min-tls-version": [
                      "1.0",
                      "1.1",
                      "1.2"
                    ],
                    "--profile": [
                      "COMPATIBLE",
                      "CUSTOM",
                      "MODERN",
                      "RESTRICTED"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-available-features": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--custom-features": "value",
                    "--min-tls-version": [
                      "1.0",
                      "1.1",
                      "1.2"
                    ],
                    "--profile": [
                      "COMPATIBLE",
                      "CUSTOM",
                      "MODERN",
                      "RESTRICTED"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "start-iap-tunnel": {
              "commands": {},
              "flags": {
                "--local-host-port": "value",
                "--zone": "dynamic"
              }
            },
            "target-http-proxies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--global": "bool",
                    "--global-url-map": "bool",
                    "--region": "dynamic",
                    "--url-map": "dynamic",
                    "--url-map-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--global-url-map": "bool",
                    "--region": "dynamic",
                    "--url-map": "dynamic",
                    "--url-map-region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-https-proxies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--global": "bool",
                    "--global-ssl-certificates": "bool",
                    "--global-url-map": "bool",
                    "--quic-override": [
                      "DISABLE",
                      "ENABLE",
                      "NONE"
                    ],
                    "--region": "dynamic",
                    "--ssl-certificates": "dynamic",
                    "--ssl-certificates-region": "dynamic",
                    "--ssl-policy": "dynamic",
                    "--url-map": "dynamic",
                    "--url-map-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-ssl-policy": "bool",
                    "--global": "bool",
                    "--global-ssl-certificates": "bool",
                    "--global-url-map": "bool",
                    "--quic-override": [
                      "DISABLE",
                      "ENABLE",
                      "NONE"
                    ],
                    "--region": "dynamic",
                    "--ssl-certificates": "dynamic",
                    "--ssl-certificates-region": "dynamic",
                    "--ssl-policy": "dynamic",
                    "--url-map": "dynamic",
                    "--url-map-region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-instances": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--instance": "dynamic",
                    "--instance-zone": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-pools": {
              "commands": {
                "add-health-checks": {
                  "commands": {},
                  "flags": {
                    "--http-health-check": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "add-instances": {
                  "commands": {},
                  "flags": {
                    "--instances": "dynamic",
                    "--instances-zone": "dynamic",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--backup-pool": "value",
                    "--description": "value",
                    "--failover-ratio": "value",
                    "--health-check": "value",
                    "--http-health-check": "dynamic",
                    "--region": "dynamic",
                    "--session-affinity": [
                      "CLIENT_IP",
                      "CLIENT_IP_PROTO",
                      "NONE"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "get-health": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-health-checks": {
                  "commands": {},
                  "flags": {
                    "--http-health-check": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "remove-instances": {
                  "commands": {},
                  "flags": {
                    "--instances": "dynamic",
                    "--instances-zone": "dynamic",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "set-backup": {
                  "commands": {},
                  "flags": {
                    "--backup-pool": "dynamic",
                    "--failover-ratio": "value",
                    "--no-backup-pool": "bool",
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-ssl-proxies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "dynamic",
                    "--description": "value",
                    "--proxy-header": [
                      "NONE",
                      "PROXY_V1"
                    ],
                    "--ssl-certificates": "dynamic",
                    "--ssl-policy": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "dynamic",
                    "--clear-ssl-policy": "bool",
                    "--proxy-header": [
                      "NONE",
                      "PROXY_V1"
                    ],
                    "--ssl-certificates": "dynamic",
                    "--ssl-policy": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-tcp-proxies": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "dynamic",
                    "--description": "value",
                    "--proxy-header": [
                      "NONE",
                      "PROXY_V1"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "dynamic",
                    "--proxy-header": [
                      "NONE",
                      "PROXY_V1"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "target-vpn-gateways": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--network": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "tpus": {
              "commands": {
                "accelerator-types": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator-type": "value",
                    "--async": "bool",
                    "--description": "value",
                    "--network": "value",
                    "--preemptible": "bool",
                    "--range": "value",
                    "--reserved": "bool",
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "dynamic"
                  }
                },
                "locations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "reimage": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "stop": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "versions": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "url-maps": {
              "commands": {
                "add-host-rule": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--global": "bool",
                    "--hosts": "value",
                    "--path-matcher-name": "value",
                    "--region": "dynamic"
                  }
                },
                "add-path-matcher": {
                  "commands": {},
                  "flags": {
                    "--backend-bucket-path-rules": "value",
                    "--backend-service-path-rules": "value",
                    "--default-backend-bucket": "value",
                    "--default-service": "value",
                    "--delete-orphaned-path-matcher": "bool",
                    "--description": "value",
                    "--existing-host": "value",
                    "--global": "bool",
                    "--new-hosts": "value",
                    "--path-matcher-name": "value",
                    "--path-rules": "value",
                    "--region": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--default-backend-bucket": "value",
                    "--default-service": "value",
                    "--description": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "edit": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "invalidate-cdn-cache": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--global": "bool",
                    "--host": "value",
                    "--path": "value",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-cdn-cache-invalidations": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--limit": "value",
                    "--region": "dynamic"
                  }
                },
                "remove-host-rule": {
                  "commands": {},
                  "flags": {
                    "--delete-orphaned-path-matcher": "bool",
                    "--global": "bool",
                    "--host": "value",
                    "--region": "dynamic"
                  }
                },
                "remove-path-matcher": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--path-matcher-name": "value",
                    "--region": "dynamic"
                  }
                },
                "set-default-service": {
                  "commands": {},
                  "flags": {
                    "--default-backend-bucket": "value",
                    "--default-service": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "vpn-gateways": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--network": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "get-status": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "vpn-tunnels": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--ike-version": [
                      1,
                      2
                    ],
                    "--interface": [
                      0,
                      1
                    ],
                    "--local-traffic-selector": "value",
                    "--peer-address": "value",
                    "--peer-external-gateway": "dynamic",
                    "--peer-external-gateway-interface": [
                      0,
                      1,
                      2,
                      3
                    ],
                    "--peer-gcp-gateway": "dynamic",
                    "--peer-gcp-gateway-region": "dynamic",
                    "--region": "dynamic",
                    "--remote-traffic-selector": "value",
                    "--router": "dynamic",
                    "--router-region": "dynamic",
                    "--shared-secret": "value",
                    "--target-vpn-gateway": "dynamic",
                    "--target-vpn-gateway-region": "dynamic",
                    "--vpn-gateway": "dynamic",
                    "--vpn-gateway-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
     