"""Generated message classes for datastore version v1.

Accesses the schemaless NoSQL database to provide fully managed, robust,
scalable storage for your application.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'datastore'


class AllocateIdsRequest(_messages.Message):
  r"""The request for Datastore.AllocateIds.

  Fields:
    keys: A list of keys with incomplete key paths for which to allocate IDs.
      No key may be reserved/read-only.
  """

  keys = _messages.MessageField('Key', 1, repeated=True)


class AllocateIdsResponse(_messages.Message):
  r"""The response for Datastore.AllocateIds.

  Fields:
    keys: The keys specified in the request (in the same order), each with its
      key path completed with a newly allocated ID.
  """

  keys = _messages.MessageField('Key', 1, repeated=True)


class ArrayValue(_messages.Message):
  r"""An array value.

  Fields:
    values: Values in the array. The order of values in an array is preserved
      as long as all values have identical settings for
      'exclude_from_indexes'.
  """

  values = _messages.MessageField('Value', 1, repeated=True)


class BeginTransactionRequest(_messages.Message):
  r"""The request for Datastore.BeginTransaction.

  Fields:
    transactionOptions: Options for a new transaction.
  """

  transactionOptions = _messages.MessageField('TransactionOptions', 1)


class BeginTransactionResponse(_messages.Message):
  r"""The response for Datastore.BeginTransaction.

  Fields:
    transaction: The transaction identifier (always present).
  """

  transaction = _messages.BytesField(1)


class CommitRequest(_messages.Message):
  r"""The request for Datastore.Commit.

  Enums:
    ModeValueValuesEnum: The type of commit to perform. Defaults to
      `TRANSACTIONAL`.

  Fields:
    mode: The type of commit to perform. Defaults to `TRANSACTIONAL`.
    mutations: The mutations to perform.  When mode is `TRANSACTIONAL`,
      mutations affecting a single entity are applied in order. The following
      sequences of mutations affecting a single entity are not permitted in a
      single `Commit` request:  - `insert` followed by `insert` - `update`
      followed by `insert` - `upsert` followed by `insert` - `delete` followed
      by `update`  When mode is `NON_TRANSACTIONAL`, no two mutations may
      affect a single entity.
    transaction: The identifier of the transaction associated with the commit.
      A transaction identifier is returned by a call to
      Datastore.BeginTransaction.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""The type of commit to perform. Defaults to `TRANSACTIONAL`.

    Values:
      MODE_UNSPECIFIED: Unspecified. This value must not be used.
      TRANSACTIONAL: Transactional: The mutations are either all applied, or
        none are applied. Learn about transactions
        [here](https://cloud.google.com/datastore/docs/concepts/transactions).
      NON_TRANSACTIONAL: Non-transactional: The mutations may not apply as all
        or none.
    """
    MODE_UNSPECIFIED = 0
    TRANSACTIONAL = 1
    NON_TRANSACTIONAL = 2

  mode = _messages.EnumField('ModeValueValuesEnum', 1)
  mutations = _messages.MessageField('Mutation', 2, repeated=True)
  transaction = _messages.BytesField(3)


class CommitResponse(_messages.Message):
  r"""The response for Datastore.Commit.

  Fields:
    indexUpdates: The number of index entries updated during the commit, or
      zero if none were updated.
    mutationResults: The result of performing the mutations. The i-th mutation
      result corresponds to the i-th mutation in the request.
  """

  indexUpdates = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  mutationResults = _messages.MessageField('MutationResult', 2, repeated=True)


class CompositeFilter(_messages.Message):
  r"""A filter that merges multiple other filters using the given operator.

  Enums:
    OpValueValuesEnum: The operator for combining multiple filters.

  Fields:
    filters: The list of filters to combine. Must contain at least one filter.
    op: The operator for combining multiple filters.
  """

  class OpValueValuesEnum(_messages.Enum):
    r"""The operator for combining multiple filters.

    Values:
      OPERATOR_UNSPECIFIED: Unspecified. This value must not be used.
      AND: The results are required to satisfy each of the combined filters.
    """
    OPERATOR_UNSPECIFIED = 0
    AND = 1

  filters = _messages.MessageField('Filter', 1, repeated=True)
  op = _messages.EnumField('OpValueValuesEnum', 2)


class DatastoreProjectsAllocateIdsRequest(_messages.Message):
  r"""A DatastoreProjectsAllocateIdsRequest object.

  Fields:
    allocateIdsRequest: A AllocateIdsRequest resource to be passed as the
      request body.
    projectId: The ID of the project against which to make the request.
  """

  allocateIdsRequest = _messages.MessageField('AllocateIdsRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsBeginTransactionRequest(_messages.Message):
  r"""A DatastoreProjectsBeginTransactionRequest object.

  Fields:
    beginTransactionRequest: A BeginTransactionRequest resource to be passed
      as the request body.
    projectId: The ID of the project against which to make the request.
  """

  beginTransactionRequest = _messages.MessageField('BeginTransactionRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsCommitRequest(_messages.Message):
  r"""A DatastoreProjectsCommitRequest object.

  Fields:
    commitRequest: A CommitRequest resource to be passed as the request body.
    projectId: The ID of the project against which to make the request.
  """

  commitRequest = _messages.MessageField('CommitRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsExportRequest(_messages.Message):
  r"""A DatastoreProjectsExportRequest object.

  Fields:
    googleDatastoreAdminV1ExportEntitiesRequest: A
      GoogleDatastoreAdminV1ExportEntitiesRequest resource to be passed as the
      request body.
    projectId: Project ID against which to make the request.
  """

  googleDatastoreAdminV1ExportEntitiesRequest = _messages.MessageField('GoogleDatastoreAdminV1ExportEntitiesRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsImportRequest(_messages.Message):
  r"""A DatastoreProjectsImportRequest object.

  Fields:
    googleDatastoreAdminV1ImportEntitiesRequest: A
      GoogleDatastoreAdminV1ImportEntitiesRequest resource to be passed as the
      request body.
    projectId: Project ID against which to make the request.
  """

  googleDatastoreAdminV1ImportEntitiesRequest = _messages.MessageField('GoogleDatastoreAdminV1ImportEntitiesRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsIndexesDeleteRequest(_messages.Message):
  r"""A DatastoreProjectsIndexesDeleteRequest object.

  Fields:
    indexId: The resource ID of the index to delete.
    projectId: Project ID against which to make the request.
  """

  indexId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsIndexesGetRequest(_messages.Message):
  r"""A DatastoreProjectsIndexesGetRequest object.

  Fields:
    indexId: The resource ID of the index to get.
    projectId: Project ID against which to make the request.
  """

  indexId = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsIndexesListRequest(_messages.Message):
  r"""A DatastoreProjectsIndexesListRequest object.

  Fields:
    filter: A string attribute.
    pageSize: The maximum number of items to return.  If zero, then all
      results will be returned.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    projectId: Project ID against which to make the request.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  projectId = _messages.StringField(4, required=True)


class DatastoreProjectsLookupRequest(_messages.Message):
  r"""A DatastoreProjectsLookupRequest object.

  Fields:
    lookupRequest: A LookupRequest resource to be passed as the request body.
    projectId: The ID of the project against which to make the request.
  """

  lookupRequest = _messages.MessageField('LookupRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsOperationsCancelRequest(_messages.Message):
  r"""A DatastoreProjectsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class DatastoreProjectsOperationsDeleteRequest(_messages.Message):
  r"""A DatastoreProjectsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class DatastoreProjectsOperationsGetRequest(_messages.Message):
  r"""A DatastoreProjectsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class DatastoreProjectsOperationsListRequest(_messages.Message):
  r"""A DatastoreProjectsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class DatastoreProjectsReserveIdsRequest(_messages.Message):
  r"""A DatastoreProjectsReserveIdsRequest object.

  Fields:
    projectId: The ID of the project against which to make the request.
    reserveIdsRequest: A ReserveIdsRequest resource to be passed as the
      request body.
  """

  projectId = _messages.StringField(1, required=True)
  reserveIdsRequest = _messages.MessageField('ReserveIdsRequest', 2)


class DatastoreProjectsRollbackRequest(_messages.Message):
  r"""A DatastoreProjectsRollbackRequest object.

  Fields:
    projectId: The ID of the project against which to make the request.
    rollbackRequest: A RollbackRequest resource to be passed as the request
      body.
  """

  projectId = _messages.StringField(1, required=True)
  rollbackRequest = _messages.MessageField('RollbackRequest', 2)


class DatastoreProjectsRunQueryRequest(_messages.Message):
  r"""A DatastoreProjectsRunQueryRequest object.

  Fields:
    projectId: The ID of the project against which to make the request.
    runQueryRequest: A RunQueryRequest resource to be passed as the request
      body.
  """

  projectId = _messages.StringField(1, required=True)
  runQueryRequest = _messages.MessageField('RunQueryRequest', 2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Entity(_messages.Message):
  r"""A Datastore data object.  An entity is limited to 1 megabyte when
  stored. That _roughly_ corresponds to a limit of 1 megabyte for the
  serialized form of this message.

  Messages:
    PropertiesValue: The entity's properties. The map's keys are property
      names. A property name matching regex `__.*__` is reserved. A reserved
      property name is forbidden in certain documented contexts. The name must
      not contain more than 500 characters. The name cannot be `""`.

  Fields:
    key: The entity's key.  An entity must have a key, unless otherwise
      documented (for example, an entity in `Value.entity_value` may have no
      key). An entity's kind is its key path's last element's kind, or null if
      it has no key.
    properties: The entity's properties. The map's keys are property names. A
      property name matching regex `__.*__` is reserved. A reserved property
      name is forbidden in certain documented contexts. The name must not
      contain more than 500 characters. The name cannot be `""`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""The entity's properties. The map's keys are property names. A property
    name matching regex `__.*__` is reserved. A reserved property name is
    forbidden in certain documented contexts. The name must not contain more
    than 500 characters. The name cannot be `""`.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A Value attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Value', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  key = _messages.MessageField('Key', 1)
  properties = _messages.MessageField('PropertiesValue', 2)


class EntityResult(_messages.Message):
  r"""The result of fetching an entity from Datastore.

  Fields:
    cursor: A cursor that points to the position after the result entity. Set
      only when the `EntityResult` is part of a `QueryResultBatch` message.
    entity: The resulting entity.
    version: The version of the entity, a strictly positive number that
      monotonically increases with changes to the entity.  This field is set
      for `FULL` entity results.  For missing entities in `LookupResponse`,
      this is the version of the snapshot that was used to look up the entity,
      and it is always set except for eventually consistent reads.
  """

  cursor = _messages.BytesField(1)
  entity = _messages.MessageField('Entity', 2)
  version = _messages.IntegerField(3)


class Filter(_messages.Message):
  r"""A holder for any type of filter.

  Fields:
    compositeFilter: A composite filter.
    propertyFilter: A filter on a property.
  """

  compositeFilter = _messages.MessageField('CompositeFilter', 1)
  propertyFilter = _messages.MessageField('PropertyFilter', 2)


class GoogleDatastoreAdminV1CommonMetadata(_messages.Message):
  r"""Metadata common to all Datastore Admin operations.

  Enums:
    OperationTypeValueValuesEnum: The type of the operation. Can be used as a
      filter in ListOperationsRequest.
    StateValueValuesEnum: The current state of the Operation.

  Messages:
    LabelsValue: The client-assigned labels which were provided when the
      operation was created. May also include additional labels.

  Fields:
    endTime: The time the operation ended, either successfully or otherwise.
    labels: The client-assigned labels which were provided when the operation
      was created. May also include additional labels.
    operationType: The type of the operation. Can be used as a filter in
      ListOperationsRequest.
    startTime: The time that work began on the operation.
    state: The current state of the Operation.
  """

  class OperationTypeValueValuesEnum(_messages.Enum):
    r"""The type of the operation. Can be used as a filter in
    ListOperationsRequest.

    Values:
      OPERATION_TYPE_UNSPECIFIED: Unspecified.
      EXPORT_ENTITIES: ExportEntities.
      IMPORT_ENTITIES: ImportEntities.
      CREATE_INDEX: CreateIndex.
      DELETE_INDEX: DeleteIndex.
    """
    OPERATION_TYPE_UNSPECIFIED = 0
    EXPORT_ENTITIES = 1
    IMPORT_ENTITIES = 2
    CREATE_INDEX = 3
    DELETE_INDEX = 4

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the Operation.

    Values:
      STATE_UNSPECIFIED: Unspecified.
      INITIALIZING: Request is being prepared for processing.
      PROCESSING: Request is actively being processed.
      CANCELLING: Request is in the process of being cancelled after user
        called google.longrunning.Operations.CancelOperation on the operation.
      FINALIZING: Request has been processed and is in its finalization stage.
      SUCCESSFUL: Request has completed successfully.
      FAILED: Request has finished being processed, but encountered an error.
      CANCELLED: Request has finished being cancelled after user called
        google.longrunning.Operations.CancelOperation.
    """
    STATE_UNSPECIFIED = 0
    INITIALIZING = 1
    PROCESSING = 2
    CANCELLING = 3
    FINALIZING = 4
    SUCCESSFUL = 5
    FAILED = 6
    CANCELLED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The client-assigned labels which were provided when the operation was
    created. May also include additional labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  endTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 3)
  startTime = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class GoogleDatastoreAdminV1EntityFilter(_messages.Message):
  r"""Identifies a subset of entities in a project. This is specified as
  combinations of kinds and namespaces (either or both of which may be all, as
  described in the following examples). Example usage:  Entire project:
  kinds=[], namespace_ids=[]  Kinds Foo and Bar in all namespaces:
  kinds=['Foo', 'Bar'], namespace_ids=[]  Kinds Foo and Bar only in the
  default namespace:   kinds=['Foo', 'Bar'], namespace_ids=['']  Kinds Foo and
  Bar in both the default and Baz namespaces:   kinds=['Foo', 'Bar'],
  namespace_ids=['', 'Baz']  The entire Baz namespace:   kinds=[],
  namespace_ids=['Baz']

  Fields:
    kinds: If empty, then this represents all kinds.
    namespaceIds: An empty list represents all namespaces. This is the
      preferred usage for projects that don't use namespaces.  An empty string
      element represents the default namespace. This should be used if the
      project has data in non-default namespaces, but doesn't want to include
      them. Each namespace in this list must be unique.
  """

  kinds = _messages.StringField(1, repeated=True)
  namespaceIds = _messages.StringField(2, repeated=True)


class GoogleDatastoreAdminV1ExportEntitiesMetadata(_messages.Message):
  r"""Metadata for ExportEntities operations.

  Fields:
    common: Metadata common to all Datastore Admin operations.
    entityFilter: Description of which entities are being exported.
    outputUrlPrefix: Location for the export metadata and data files. This
      will be the same value as the
      google.datastore.admin.v1.ExportEntitiesRequest.output_url_prefix field.
      The final output location is provided in
      google.datastore.admin.v1.ExportEntitiesResponse.output_url.
    progressBytes: An estimate of the number of bytes processed.
    progressEntities: An estimate of the number of entities processed.
  """

  common = _messages.MessageField('GoogleDatastoreAdminV1CommonMetadata', 1)
  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1EntityFilter', 2)
  outputUrlPrefix = _messages.StringField(3)
  progressBytes = _messages.MessageField('GoogleDatastoreAdminV1Progress', 4)
  progressEntities = _messages.MessageField('GoogleDatastoreAdminV1Progress', 5)


class GoogleDatastoreAdminV1ExportEntitiesRequest(_messages.Message):
  r"""The request for google.datastore.admin.v1.DatastoreAdmin.ExportEntities.

  Messages:
    LabelsValue: Client-assigned labels.

  Fields:
    entityFilter: Description of what data from the project is included in the
      export.
    labels: Client-assigned labels.
    outputUrlPrefix: Location for the export metadata and data files.  The
      full resource URL of the external storage location. Currently, only
      Google Cloud Storage is supported. So output_url_prefix should be of the
      form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the
      name of the Cloud Storage bucket and `NAMESPACE_PATH` is an optional
      Cloud Storage namespace path (this is not a Cloud Datastore namespace).
      For more information about Cloud Storage namespace paths, see [Object
      name considerations](https://cloud.google.com/storage/docs/naming
      #object-considerations).  The resulting files will be nested deeper than
      the specified URL prefix. The final output URL will be provided in the
      google.datastore.admin.v1.ExportEntitiesResponse.output_url field. That
      value should be used for subsequent ImportEntities operations.  By
      nesting the data files deeper, the same Cloud Storage bucket can be used
      in multiple ExportEntities operations without conflict.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Client-assigned labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1EntityFilter', 1)
  labels = _messages.MessageField('LabelsValue', 2)
  outputUrlPrefix = _messages.StringField(3)


class GoogleDatastoreAdminV1ExportEntitiesResponse(_messages.Message):
  r"""The response for
  google.datastore.admin.v1.DatastoreAdmin.ExportEntities.

  Fields:
    outputUrl: Location of the output metadata file. This can be used to begin
      an import into Cloud Datastore (this project or another project). See
      google.datastore.admin.v1.ImportEntitiesRequest.input_url. Only present
      if the operation completed successfully.
  """

  outputUrl = _messages.StringField(1)


class GoogleDatastoreAdminV1ImportEntitiesMetadata(_messages.Message):
  r"""Metadata for ImportEntities operations.

  Fields:
    common: Metadata common to all Datastore Admin operations.
    entityFilter: Description of which entities are being imported.
    inputUrl: The location of the import metadata file. This will be the same
      value as the google.datastore.admin.v1.ExportEntitiesResponse.output_url
      field.
    progressBytes: An estimate of the number of bytes processed.
    progressEntities: An estimate of the number of entities processed.
  """

  common = _messages.MessageField('GoogleDatastoreAdminV1CommonMetadata', 1)
  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1EntityFilter', 2)
  inputUrl = _messages.StringField(3)
  progressBytes = _messages.MessageField('GoogleDatastoreAdminV1Progress', 4)
  progressEntities = _messages.MessageField('GoogleDatastoreAdminV1Progress', 5)


class GoogleDatastoreAdminV1ImportEntitiesRequest(_messages.Message):
  r"""The request for google.datastore.admin.v1.DatastoreAdmin.ImportEntities.

  Messages:
    LabelsValue: Client-assigned labels.

  Fields:
    entityFilter: Optionally specify which kinds/namespaces are to be
      imported. If provided, the list must be a subset of the EntityFilter
      used in creating the export, otherwise a FAILED_PRECONDITION error will
      be returned. If no filter is specified then all entities from the export
      are imported.
    inputUrl: The full resource URL of the external storage location.
      Currently, only Google Cloud Storage is supported. So input_url should
      be of the form:
      `gs://BUCKET_NAME[/NAMESPACE_PATH]/OVERALL_EXPORT_METADATA_FILE`, where
      `BUCKET_NAME` is the name of the Cloud Storage bucket, `NAMESPACE_PATH`
      is an optional Cloud Storage namespace path (this is not a Cloud
      Datastore namespace), and `OVERALL_EXPORT_METADATA_FILE` is the metadata
      file written by the ExportEntities operation. For more information about
      Cloud Storage namespace paths, see [Object name
      considerations](https://cloud.google.com/storage/docs/naming#object-
      considerations).  For more information, see
      google.datastore.admin.v1.ExportEntitiesResponse.output_url.
    labels: Client-assigned labels.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Client-assigned labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1EntityFilter', 1)
  inputUrl = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)


class GoogleDatastoreAdminV1Index(_messages.Message):
  r"""A minimal index definition.

  Enums:
    AncestorValueValuesEnum: The index's ancestor mode.  Must not be
      ANCESTOR_MODE_UNSPECIFIED. Required.
    StateValueValuesEnum: The state of the index. Output only.

  Fields:
    ancestor: The index's ancestor mode.  Must not be
      ANCESTOR_MODE_UNSPECIFIED. Required.
    indexId: The resource ID of the index. Output only.
    kind: The entity kind to which this index applies. Required.
    projectId: Project ID. Output only.
    properties: An ordered sequence of property names and their index
      attributes. Required.
    state: The state of the index. Output only.
  """

  class AncestorValueValuesEnum(_messages.Enum):
    r"""The index's ancestor mode.  Must not be ANCESTOR_MODE_UNSPECIFIED.
    Required.

    Values:
      ANCESTOR_MODE_UNSPECIFIED: The ancestor mode is unspecified.
      NONE: Do not include the entity's ancestors in the index.
      ALL_ANCESTORS: Include all the entity's ancestors in the index.
    """
    ANCESTOR_MODE_UNSPECIFIED = 0
    NONE = 1
    ALL_ANCESTORS = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of the index. Output only.

    Values:
      STATE_UNSPECIFIED: The state is unspecified.
      CREATING: The index is being created, and cannot be used by queries.
        There is an active long-running operation for the index. The index is
        updated when writing an entity. Some index data may exist.
      READY: The index is ready to be used. The index is updated when writing
        an entity. The index is fully populated from all stored entities it
        applies to.
      DELETING: The index is being deleted, and cannot be used by queries.
        There is an active long-running operation for the index. The index is
        not updated when writing an entity. Some index data may exist.
      ERROR: The index was being created or deleted, but something went wrong.
        The index cannot by used by queries. There is no active long-running
        operation for the index, and the most recently finished long-running
        operation failed. The index is not updated when writing an entity.
        Some index data may exist.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    DELETING = 3
    ERROR = 4

  ancestor = _messages.EnumField('AncestorValueValuesEnum', 1)
  indexId = _messages.StringField(2)
  kind = _messages.StringField(3)
  projectId = _messages.StringField(4)
  properties = _messages.MessageField('GoogleDatastoreAdminV1IndexedProperty', 5, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 6)


class GoogleDatastoreAdminV1IndexOperationMetadata(_messages.Message):
  r"""Metadata for Index operations.

  Fields:
    common: Metadata common to all Datastore Admin operations.
    indexId: The index resource ID that this operation is acting on.
    progressEntities: An estimate of the number of entities processed.
  """

  common = _messages.MessageField('GoogleDatastoreAdminV1CommonMetadata', 1)
  indexId = _messages.StringField(2)
  progressEntities = _messages.MessageField('GoogleDatastoreAdminV1Progress', 3)


class GoogleDatastoreAdminV1IndexedProperty(_messages.Message):
  r"""A property of an index.

  Enums:
    DirectionValueValuesEnum: The indexed property's direction.  Must not be
      DIRECTION_UNSPECIFIED. Required.

  Fields:
    direction: The indexed property's direction.  Must not be
      DIRECTION_UNSPECIFIED. Required.
    name: The property name to index. Required.
  """

  class DirectionValueValuesEnum(_messages.Enum):
    r"""The indexed property's direction.  Must not be DIRECTION_UNSPECIFIED.
    Required.

    Values:
      DIRECTION_UNSPECIFIED: The direction is unspecified.
      ASCENDING: The property's values are indexed so as to support sequencing
        in ascending order and also query by <, >, <=, >=, and =.
      DESCENDING: The property's values are indexed so as to support
        sequencing in descending order and also query by <, >, <=, >=, and =.
    """
    DIRECTION_UNSPECIFIED = 0
    ASCENDING = 1
    DESCENDING = 2

  direction = _messages.EnumField('DirectionValueValuesEnum', 1)
  name = _messages.StringField(2)


class GoogleDatastoreAdminV1ListIndexesResponse(_messages.Message):
  r"""The response for google.datastore.admin.v1.DatastoreAdmin.ListIndexes.

  Fields:
    indexes: The indexes.
    nextPageToken: The standard List next-page token.
  """

  indexes = _messages.MessageField('GoogleDatastoreAdminV1Index', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleDatastoreAdminV1Progress(_messages.Message):
  r"""Measures the progress of a particular metric.

  Fields:
    workCompleted: The amount of work that has been completed. Note that this
      may be greater than work_estimated.
    workEstimated: An estimate of how much work needs to be performed. May be
      zero if the work estimate is unavailable.
  """

  workCompleted = _messages.IntegerField(1)
  workEstimated = _messages.IntegerField(2)


class GoogleDatastoreAdminV1beta1CommonMetadata(_messages.Message):
  r"""Metadata common to all Datastore Admin operations.

  Enums:
    OperationTypeValueValuesEnum: The type of the operation. Can be used as a
      filter in ListOperationsRequest.
    StateValueValuesEnum: The current state of the Operation.

  Messages:
    LabelsValue: The client-assigned labels which were provided when the
      operation was created. May also include additional labels.

  Fields:
    endTime: The time the operation ended, either successfully or otherwise.
    labels: The client-assigned labels which were provided when the operation
      was created. May also include additional labels.
    operationType: The type of the operation. Can be used as a filter in
      ListOperationsRequest.
    startTime: The time that work began on the operation.
    state: The current state of the Operation.
  """

  class OperationTypeValueValuesEnum(_messages.Enum):
    r"""The type of the operation. Can be used as a filter in
    ListOperationsRequest.

    Values:
      OPERATION_TYPE_UNSPECIFIED: Unspecified.
      EXPORT_ENTITIES: ExportEntities.
      IMPORT_ENTITIES: ImportEntities.
    """
    OPERATION_TYPE_UNSPECIFIED = 0
    EXPORT_ENTITIES = 1
    IMPORT_ENTITIES = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the Operation.

    Values:
      STATE_UNSPECIFIED: Unspecified.
      INITIALIZING: Request is being prepared for processing.
      PROCESSING: Request is actively being processed.
      CANCELLING: Request is in the process of being cancelled after user
        called google.longrunning.Operations.CancelOperation on the operation.
      FINALIZING: Request has been processed and is in its finalization stage.
      SUCCESSFUL: Request has completed successfully.
      FAILED: Request has finished being processed, but encountered an error.
      CANCELLED: Request has finished being cancelled after user called
        google.longrunning.Operations.CancelOperation.
    """
    STATE_UNSPECIFIED = 0
    INITIALIZING = 1
    PROCESSING = 2
    CANCELLING = 3
    FINALIZING = 4
    SUCCESSFUL = 5
    FAILED = 6
    CANCELLED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The client-assigned labels which were provided when the operation was
    created. May also include additional labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  endTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 3)
  startTime = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class GoogleDatastoreAdminV1beta1EntityFilter(_messages.Message):
  r"""Identifies a subset of entities in a project. This is specified as
  combinations of kinds and namespaces (either or both of which may be all, as
  described in the following examples). Example usage:  Entire project:
  kinds=[], namespace_ids=[]  Kinds Foo and Bar in all namespaces:
  kinds=['Foo', 'Bar'], namespace_ids=[]  Kinds Foo and Bar only in the
  default namespace:   kinds=['Foo', 'Bar'], namespace_ids=['']  Kinds Foo and
  Bar in both the default and Baz namespaces:   kinds=['Foo', 'Bar'],
  namespace_ids=['', 'Baz']  The entire Baz namespace:   kinds=[],
  namespace_ids=['Baz']

  Fields:
    kinds: If empty, then this represents all kinds.
    namespaceIds: An empty list represents all namespaces. This is the
      preferred usage for projects that don't use namespaces.  An empty string
      element represents the default namespace. This should be used if the
      project has data in non-default namespaces, but doesn't want to include
      them. Each namespace in this list must be unique.
  """

  kinds = _messages.StringField(1, repeated=True)
  namespaceIds = _messages.StringField(2, repeated=True)


class GoogleDatastoreAdminV1beta1ExportEntitiesMetadata(_messages.Message):
  r"""Metadata for ExportEntities operations.

  Fields:
    common: Metadata common to all Datastore Admin operations.
    entityFilter: Description of which entities are being exported.
    outputUrlPrefix: Location for the export metadata and data files. This
      will be the same value as the
      google.datastore.admin.v1beta1.ExportEntitiesRequest.output_url_prefix
      field. The final output location is provided in
      google.datastore.admin.v1beta1.ExportEntitiesResponse.output_url.
    progressBytes: An estimate of the number of bytes processed.
    progressEntities: An estimate of the number of entities processed.
  """

  common = _messages.MessageField('GoogleDatastoreAdminV1beta1CommonMetadata', 1)
  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1beta1EntityFilter', 2)
  outputUrlPrefix = _messages.StringField(3)
  progressBytes = _messages.MessageField('GoogleDatastoreAdminV1beta1Progress', 4)
  progressEntities = _messages.MessageField('GoogleDatastoreAdminV1beta1Progress', 5)


class GoogleDatastoreAdminV1beta1ExportEntitiesResponse(_messages.Message):
  r"""The response for
  google.datastore.admin.v1beta1.DatastoreAdmin.ExportEntities.

  Fields:
    outputUrl: Location of the output metadata file. This can be used to begin
      an import into Cloud Datastore (this project or another project). See
      google.datastore.admin.v1beta1.ImportEntitiesRequest.input_url. Only
      present if the operation completed successfully.
  """

  outputUrl = _messages.StringField(1)


class GoogleDatastoreAdminV1beta1ImportEntitiesMetadata(_messages.Message):
  r"""Metadata for ImportEntities operations.

  Fields:
    common: Metadata common to all Datastore Admin operations.
    entityFilter: Description of which entities are being imported.
    inputUrl: The location of the import metadata file. This will be the same
      value as the
      google.datastore.admin.v1beta1.ExportEntitiesResponse.output_url field.
    progressBytes: An estimate of the number of bytes processed.
    progressEntities: An estimate of the number of entities processed.
  """

  common = _messages.MessageField('GoogleDatastoreAdminV1beta1CommonMetadata', 1)
  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1beta1EntityFilter', 2)
  inputUrl = _messages.StringField(3)
  progressBytes = _messages.MessageField('GoogleDatastoreAdminV1beta1Progress', 4)
  progressEntities = _messages.MessageField('GoogleDatastoreAdminV1beta1Progress', 5)


class GoogleDatastoreAdminV1beta1Progress(_messages.Message):
  r"""Measures the progress of a particular metric.

  Fields:
    workCompleted: The amount of work that has been completed. Note that this
      may be greater than work_estimated.
    workEstimated: An estimate of how much work needs to be performed. May be
      zero if the work estimate is unavailable.
  """

  workCompleted = _messages.IntegerField(1)
  workEstimated = _messages.IntegerField(2)


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GqlQuery(_messages.Message):
  r"""A [GQL
  query](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).

  Messages:
    NamedBindingsValue: For each non-reserved named binding site in the query
      string, there must be a named parameter with that name, but not
      necessarily the inverse.  Key must match regex `A-Za-z_$*`, must not
      match regex `__.*__`, and must not be `""`.

  Fields:
    allowLiterals: When false, the query string must not contain any literals
      and instead must bind all values. For example, `SELECT * FROM Kind WHERE
      a = 'string literal'` is not allowed, while `SELECT * FROM Kind WHERE a
      = @value` is.
    namedBindings: For each non-reserved named binding site in the query
      string, there must be a named parameter with that name, but not
      necessarily the inverse.  Key must match regex `A-Za-z_$*`, must not
      match regex `__.*__`, and must not be `""`.
    positionalBindings: Numbered binding site @1 references the first numbered
      parameter, effectively using 1-based indexing, rather than the usual 0.
      For each binding site numbered i in `query_string`, there must be an
      i-th numbered parameter. The inverse must also be true.
    queryString: A string of the format described
      [here](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class NamedBindingsValue(_messages.Message):
    r"""For each non-reserved named binding site in the query string, there
    must be a named parameter with that name, but not necessarily the inverse.
    Key must match regex `A-Za-z_$*`, must not match regex `__.*__`, and must
    not be `""`.

    Messages:
      AdditionalProperty: An additional property for a NamedBindingsValue
        object.

    Fields:
      additionalProperties: Additional properties of type NamedBindingsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a NamedBindingsValue object.

      Fields:
        key: Name of the additional property.
        value: A GqlQueryParameter attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GqlQueryParameter', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  allowLiterals = _messages.BooleanField(1)
  namedBindings = _messages.MessageField('NamedBindingsValue', 2)
  positionalBindings = _messages.MessageField('GqlQueryParameter', 3, repeated=True)
  queryString = _messages.StringField(4)


class GqlQueryParameter(_messages.Message):
  r"""A binding parameter for a GQL query.

  Fields:
    cursor: A query cursor. Query cursors are returned in query result
      batches.
    value: A value parameter.
  """

  cursor = _messages.BytesField(1)
  value = _messages.MessageField('Value', 2)


class Key(_messages.Message):
  r"""A unique identifier for an entity. If a key's partition ID or any of its
  path kinds or names are reserved/read-only, the key is reserved/read-only. A
  reserved/read-only key is forbidden in certain documented contexts.

  Fields:
    partitionId: Entities are partitioned into subsets, currently identified
      by a project ID and namespace ID. Queries are scoped to a single
      partition.
    path: The entity path. An entity path consists of one or more elements
      composed of a kind and a string or numerical identifier, which identify
      entities. The first element identifies a _root entity_, the second
      element identifies a _child_ of the root entity, the third element
      identifies a child of the second entity, and so forth. The entities
      identified by all prefixes of the path are called the element's
      _ancestors_.  An entity path is always fully complete: *all* of the
      entity's ancestors are required to be in the path along with the entity
      identifier itself. The only exception is that in some documented cases,
      the identifier in the last path element (for the entity) itself may be
      omitted. For example, the last path element of the key of
      `Mutation.insert` may have no identifier.  A path can never be empty,
      and a path can have at most 100 elements.
  """

  partitionId = _messages.MessageField('PartitionId', 1)
  path = _messages.MessageField('PathElement', 2, repeated=True)


class KindExpression(_messages.Message):
  r"""A representation of a kind.

  Fields:
    name: The name of the kind.
  """

  name = _messages.StringField(1)


class LatLng(_messages.Message):
  r"""An object representing a latitude/longitude pair. This is expressed as a
  pair of doubles representing degrees latitude and degrees longitude. Unless
  specified otherwise, this must conform to the <a
  href="http://www.unoosa.org/pdf/icg/2012/template/WGS_84.pdf">WGS84
  standard</a>. Values must be within normalized ranges.

  Fields:
    latitude: The latitude in degrees. It must be in the range [-90.0, +90.0].
    longitude: The longitude in degrees. It must be in the range [-180.0,
      +180.0].
  """

  latitude = _messages.FloatField(1)
  longitude = _messages.FloatField(2)


class LookupRequest(_messages.Message):
  r"""The request for Datastore.Lookup.

  Fields:
    keys: Keys of entities to look up.
    readOptions: The options for this lookup request.
  """

  keys = _messages.MessageField('Key', 1, repeated=True)
  readOptions = _messages.MessageField('ReadOptions', 2)


class LookupResponse(_messages.Message):
  r"""The response for Datastore.Lookup.

  Fields:
    deferred: A list of keys that were not looked up due to resource
      constraints. The order of results in this field is undefined and has no
      relation to the order of the keys in the input.
    found: Entities found as `ResultType.FULL` entities. The order of results
      in this field is undefined and has no relation to the order of the keys
      in the input.
    missing: Entities not found as `ResultType.KEY_ONLY` entities. The order
      of results in this field is undefined and has no relation to the order
      of the keys in the input.
  """

  deferred = _messages.MessageField('Key', 1, repeated=True)
  found = _messages.MessageField('EntityResult', 2, repeated=True)
  missing = _messages.MessageField('EntityResult', 3, repeated=True)


class Mutation(_messages.Message):
  r"""A mutation to apply to an entity.

  Fields:
    baseVersion: The version of the entity that this mutation is being applied
      to. If this does not match the current version on the server, the
      mutation conflicts.
    delete: The key of the entity to delete. The entity may or may not already
      exist. Must have a complete key path and must not be reserved/read-only.
    insert: The entity to insert. The entity must not already exist. The
      entity key's final path element may be incomplete.
    update: The entity to update. The entity must already exist. Must have a
      complete key path.
    upsert: The entity to upsert. The entity may or may not already exist. The
      entity key's final path element may be incomplete.
  """

  baseVersion = _messages.IntegerField(1)
  delete = _messages.MessageField('Key', 2)
  insert = _messages.MessageField('Entity', 3)
  update = _messages.MessageField('Entity', 4)
  upsert = _messages.MessageField('Entity', 5)


class MutationResult(_messages.Message):
  r"""The result of applying a mutation.

  Fields:
    conflictDetected: Whether a conflict was detected for this mutation.
      Always false when a conflict detection strategy field is not set in the
      mutation.
    key: The automatically allocated key. Set only when the mutation allocated
      a key.
    version: The version of the entity on the server after processing the
      mutation. If the mutation doesn't change anything on the server, then
      the version will be the version of the current entity or, if no entity
      is present, a version that is strictly greater than the version of any
      previous entity and less than the version of any possible future entity.
  """

  conflictDetected = _messages.BooleanField(1)
  key = _messages.MessageField('Key', 2)
  version = _messages.IntegerField(3)


class PartitionId(_messages.Message):
  r"""A partition ID identifies a grouping of entities. The grouping is always
  by project and namespace, however the namespace ID may be empty.  A
  partition ID contains several dimensions: project ID and namespace ID.
  Partition dimensions:  - May be `""`. - Must be valid UTF-8 bytes. - Must
  have values that match regex `[A-Za-z\d\.\-_]{1,100}` If the value of any
  dimension matches regex `__.*__`, the partition is reserved/read-only. A
  reserved/read-only partition ID is forbidden in certain documented contexts.
  Foreign partition IDs (in which the project ID does not match the context
  project ID ) are discouraged. Reads and writes of foreign partition IDs may
  fail if the project is not in an active state.

  Fields:
    namespaceId: If not empty, the ID of the namespace to which the entities
      belong.
    projectId: The ID of the project to which the entities belong.
  """

  namespaceId = _messages.StringField(1)
  projectId = _messages.StringField(2)


class PathElement(_messages.Message):
  r"""A (kind, ID/name) pair used to construct a key path.  If either name or
  ID is set, the element is complete. If neither is set, the element is
  incomplete.

  Fields:
    id: The auto-allocated ID of the entity. Never equal to zero. Values less
      than zero are discouraged and may not be supported in the future.
    kind: The kind of the entity. A kind matching regex `__.*__` is reserved
      /read-only. A kind must not contain more than 1500 bytes when UTF-8
      encoded. Cannot be `""`.
    name: The name of the entity. A name matching regex `__.*__` is reserved
      /read-only. A name must not be more than 1500 bytes when UTF-8 encoded.
      Cannot be `""`.
  """

  id = _messages.IntegerField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3)


class Projection(_messages.Message):
  r"""A representation of a property in a projection.

  Fields:
    property: The property to project.
  """

  property = _messages.MessageField('PropertyReference', 1)


class PropertyFilter(_messages.Message):
  r"""A filter on a specific property.

  Enums:
    OpValueValuesEnum: The operator to filter by.

  Fields:
    op: The operator to filter by.
    property: The property to filter by.
    value: The value to compare the property to.
  """

  class OpValueValuesEnum(_messages.Enum):
    r"""The operator to filter by.

    Values:
      OPERATOR_UNSPECIFIED: Unspecified. This value must not be used.
      LESS_THAN: Less than.
      LESS_THAN_OR_EQUAL: Less than or equal.
      GREATER_THAN: Greater than.
      GREATER_THAN_OR_EQUAL: Greater than or equal.
      EQUAL: Equal.
      HAS_ANCESTOR: Has ancestor.
    """
    OPERATOR_UNSPECIFIED = 0
    LESS_THAN = 1
    LESS_THAN_OR_EQUAL = 2
    GREATER_THAN = 3
    GREATER_THAN_OR_EQUAL = 4
    EQUAL = 5
    HAS_ANCESTOR = 6

  op = _messages.EnumField('OpValueValuesEnum', 1)
  property = _messages.MessageField('PropertyReference', 2)
  value = _messages.MessageField('Value', 3)


class PropertyOrder(_messages.Message):
  r"""The desired order for a specific property.

  Enums:
    DirectionValueValuesEnum: The direction to order by. Defaults to
      `ASCENDING`.

  Fields:
    direction: The direction to order by. Defaults to `ASCENDING`.
    property: The property to order by.
  """

  class DirectionValueValuesEnum(_messages.Enum):
    r"""The direction to order by. Defaults to `ASCENDING`.

    Values:
      DIRECTION_UNSPECIFIED: Unspecified. This value must not be used.
      ASCENDING: Ascending.
      DESCENDING: Descending.
    """
    DIRECTION_UNSPECIFIED = 0
    ASCENDING = 1
    DESCENDING = 2

  direction = _messages.EnumField('DirectionValueValuesEnum', 1)
  property = _messages.MessageField('PropertyReference', 2)


class PropertyReference(_messages.Message):
  r"""A reference to a property relative to the kind expressions.

  Fields:
    name: The name of the property. If name includes "."s, it may be
      interpreted as a property name path.
  """

  name = _messages.StringField(1)


class Query(_messages.Message):
  r"""A query for entities.

  Fields:
    distinctOn: The properties to make distinct. The query results will
      contain the first result for each distinct combination of values for the
      given properties (if empty, all results are returned).
    endCursor: An ending point for the query results. Query cursors are
      returned in query result batches and [can only be used to limit the same
      query](https://cloud.google.com/datastore/docs/concepts/queries#cursors_
      limits_and_offsets).
    filter: The filter to apply.
    kind: The kinds to query (if empty, returns entities of all kinds).
      Currently at most 1 kind may be specified.
    limit: The maximum number of results to return. Applies after all other
      constraints. Optional. Unspecified is interpreted as no limit. Must be
      >= 0 if specified.
    offset: The number of results to skip. Applies before limit, but after all
      other constraints. Optional. Must be >= 0 if specified.
    order: The order to apply to the query results (if empty, order is
      unspecified).
    projection: The projection to return. Defaults to returning all
      properties.
    startCursor: A starting point for the query results. Query cursors are
      returned in query result batches and [can only be used to continue the
      same query](https://cloud.google.com/datastore/docs/concepts/queries#cur
      sors_limits_and_offsets).
  """

  distinctOn = _messages.MessageField('PropertyReference', 1, repeated=True)
  endCursor = _messages.BytesField(2)
  filter = _messages.MessageField('Filter', 3)
  kind = _messages.MessageField('KindExpression', 4, repeated=True)
  limit = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  offset = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  order = _messages.MessageField('PropertyOrder', 7, repeated=True)
  projection = _messages.MessageField('Projection', 8, repeated=True)
  startCursor = _messages.BytesField(9)


class QueryResultBatch(_messages.Message):
  r"""A batch of results produced by a query.

  Enums:
    EntityResultTypeValueValuesEnum: The result type for every entity in
      `entity_results`.
    MoreResultsValueValuesEnum: The state of the query after the current
      batch.

  Fields:
    endCursor: A cursor that points to the position after the last result in
      the batch.
    entityResultType: The result type for every entity in `entity_results`.
    entityResults: The results for this batch.
    moreResults: The state of the query after the current batch.
    skippedCursor: A cursor that points to the position after the last skipped
      result. Will be set when `skipped_results` != 0.
    skippedResults: The number of results skipped, typically because of an
      offset.
    snapshotVersion: The version number of the snapshot this batch was
      returned from. This applies to the range of results from the query's
      `start_cursor` (or the beginning of the query if no cursor was given) to
      this batch's `end_cursor` (not the query's `end_cursor`).  In a single
      transaction, subsequent query result batches for the same query can have
      a greater snapshot version number. Each batch's snapshot version is
      valid for all preceding batches. The value will be zero for eventually
      consistent queries.
  """

  class EntityResultTypeValueValuesEnum(_messages.Enum):
    r"""The result type for every entity in `entity_results`.

    Values:
      RESULT_TYPE_UNSPECIFIED: Unspecified. This value is never used.
      FULL: The key and properties.
      PROJECTION: A projected subset of properties. The entity may have no
        key.
      KEY_ONLY: Only the key.
    """
    RESULT_TYPE_UNSPECIFIED = 0
    FULL = 1
    PROJECTION = 2
    KEY_ONLY = 3

  class MoreResultsValueValuesEnum(_messages.Enum):
    r"""The state of the query after the current batch.

    Values:
      MORE_RESULTS_TYPE_UNSPECIFIED: Unspecified. This value is never used.
      NOT_FINISHED: There may be additional batches to fetch from this query.
      MORE_RESULTS_AFTER_LIMIT: The query is finished, but there may be more
        results after the limit.
      MORE_RESULTS_AFTER_CURSOR: The query is finished, but there may be more
        results after the end cursor.
      NO_MORE_RESULTS: The query is finished, and there are no more results.
    """
    MORE_RESULTS_TYPE_UNSPECIFIED = 0
    NOT_FINISHED = 1
    MORE_RESULTS_AFTER_LIMIT = 2
    MORE_RESULTS_AFTER_CURSOR = 3
    NO_MORE_RESULTS = 4

  endCursor = _messages.BytesField(1)
  entityResultType = _messages.EnumField('EntityResultTypeValueValuesEnum', 2)
  entityResults = _messages.MessageField('EntityResult', 3, repeated=True)
  moreResults = _messages.EnumField('MoreResultsValueValuesEnum', 4)
  skippedCursor = _messages.BytesField(5)
  skippedResults = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  snapshotVersion = _messages.IntegerField(7)


class ReadOnly(_messages.Message):
  r"""Options specific to read-only transactions."""


class ReadOptions(_messages.Message):
  r"""The options shared by read requests.

  Enums:
    ReadConsistencyValueValuesEnum: The non-transactional read consistency to
      use. Cannot be set to `STRONG` for global queries.

  Fields:
    readConsistency: The non-transactional read consistency to use. Cannot be
      set to `STRONG` for global queries.
    transaction: The identifier of the transaction in which to read. A
      transaction identifier is returned by a call to
      Datastore.BeginTransaction.
  """

  class ReadConsistencyValueValuesEnum(_messages.Enum):
    r"""The non-transactional read consistency to use. Cannot be set to
    `STRONG` for global queries.

    Values:
      READ_CONSISTENCY_UNSPECIFIED: Unspecified. This value must not be used.
      STRONG: Strong consistency.
      EVENTUAL: Eventual consistency.
    """
    READ_CONSISTENCY_UNSPECIFIED = 0
    STRONG = 1
    EVENTUAL = 2

  readConsistency = _messages.EnumField('ReadConsistencyValueValuesEnum', 1)
  transaction = _messages.BytesField(2)


class ReadWrite(_messages.Message):
  r"""Options specific to read / write transactions.

  Fields:
    previousTransaction: The transaction identifier of the transaction being
      retried.
  """

  previousTransaction = _messages.BytesField(1)


class ReserveIdsRequest(_messages.Message):
  r"""The request for Datastore.ReserveIds.

  Fields:
    databaseId: If not empty, the ID of the database against which to make the
      request.
    keys: A list of keys with complete key paths whose numeric IDs should not
      be auto-allocated.
  """

  databaseId = _messages.StringField(1)
  keys = _messages.MessageField('Key', 2, repeated=True)


class ReserveIdsResponse(_messages.Message):
  r"""The response for Datastore.ReserveIds."""


class RollbackRequest(_messages.Message):
  r"""The request for Datastore.Rollback.

  Fields:
    transaction: The transaction identifier, returned by a call to
      Datastore.BeginTransaction.
  """

  transaction = _messages.BytesField(1)


class RollbackResponse(_messages.Message):
  r"""The response for Datastore.Rollback.
(an empty message)."""


class RunQueryRequest(_messages.Message):
  r"""The request for Datastore.RunQuery.

  Fields:
    gqlQuery: The GQL query to run.
    partitionId: Entities are partitioned into subsets, identified by a
      partition ID. Queries are scoped to a single partition. This partition
      ID is normalized with the standard default context partition ID.
    query: The query to run.
    readOptions: The options for this query.
  """

  gqlQuery = _messages.MessageField('GqlQuery', 1)
  partitionId = _messages.MessageField('PartitionId', 2)
  query = _messages.MessageField('Query', 3)
  readOptions = _messages.MessageField('ReadOptions', 4)


class RunQueryResponse(_messages.Message):
  r"""The response for Datastore.RunQuery.

  Fields:
    batch: A batch of query results (always present).
    query: The parsed form of the `GqlQuery` from the request, if it was set.
  """

  batch = _messages.MessageField('QueryResultBatch', 1)
  query = _messages.MessageField('Query', 2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TransactionOptions(_messages.Message):
  r"""Options for beginning a new transaction.  Transactions can be created
  explicitly with calls to Datastore.BeginTransaction or implicitly by setting
  ReadOptions.new_transaction in read requests.

  Fields:
    readOnly: The transaction should only allow reads.
    readWrite: The transaction should allow both reads and writes.
  """

  readOnly = _messages.MessageField('ReadOnly', 1)
  readWrite = _messages.MessageField('ReadWrite', 2)


class Value(_messages.Message):
  r"""A message that can hold any of the supported value types and associated
  metadata.

  Enums:
    NullValueValueValuesEnum: A null value.

  Fields:
    arrayValue: An array value. Cannot contain another array value. A `Value`
      instance that sets field `array_value` must not set fields `meaning` or
      `exclude_from_indexes`.
    blobValue: A blob value. May have at most 1,000,000 bytes. When
      `exclude_from_indexes` is false, may have at most 1500 bytes. In JSON
      requests, must be base64-encoded.
    booleanValue: A boolean value.
    doubleValue: A double value.
    entityValue: An entity value.  - May have no key. - May have a key with an
      incomplete key path. - May have a reserved/read-only key.
    excludeFromIndexes: If the value should be excluded from all indexes
      including those defined explicitly.
    geoPointValue: A geo point value representing a point on the surface of
      Earth.
    integerValue: An integer value.
    keyValue: A key value.
    meaning: The `meaning` field should only be populated for backwards
      compatibility.
    nullValue: A null value.
    stringValue: A UTF-8 encoded string value. When `exclude_from_indexes` is
      false (it is indexed) , may have at most 1500 bytes. Otherwise, may be
      set to at least 1,000,000 bytes.
    timestampValue: A timestamp value. When stored in the Datastore, precise
      only to microseconds; any additional precision is rounded down.
  """

  class NullValueValueValuesEnum(_messages.Enum):
    r"""A null value.

    Values:
      NULL_VALUE: Null value.
    """
    NULL_VALUE = 0

  arrayValue = _messages.MessageField('ArrayValue', 1)
  blobValue = _messages.BytesField(2)
  booleanValue = _messages.BooleanField(3)
  doubleValue = _messages.FloatField(4)
  entityValue = _messages.MessageField('Entity', 5)
  excludeFromIndexes = _messages.BooleanField(6)
  geoPointValue = _messages.MessageField('LatLng', 7)
  integerValue = _messages.IntegerField(8)
  keyValue = _messages.MessageField('Key', 9)
  meaning = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  nullValue = _messages.EnumField('NullValueValueValuesEnum', 11)
  stringValue = _messages.StringField(12)
  timestampValue = _messages.StringField(13)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
