"""Generated message classes for policytroubleshooter version v1beta.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'policytroubleshooter'


class GoogleCloudPolicytroubleshooterV1betaAccessTuple(_messages.Message):
  r"""AccessTuple defines information required for checking an access attempt.
  In other words, this is the tuple given to `CheckAccess`.

  Fields:
    fullResourceName: Required. A full resource name according to
      https://cloud.google.com/apis/design/resource_names. This is the full
      resource name of the resource that access is checked against.
    permission: Required. The Cloud IAM permission under which defines the
      kind of access being explained. Example: "resourcemanager.projects.get"
      would explain if and why the principal has the
      resourcemanager.projects.get permission on the resource specified in
      full_resource_name declared in this structure. See
      https://cloud.google.com/iam/docs/testing-permissions
    principal: Required. The principal on behalf of who the access is
      explained for. The format is one of the principal's email addresses
      associated with its gaia account. It must be an account that can appear
      as an actor. For example groups are not supported. Currently, service
      accounts, users are supported.
  """

  fullResourceName = _messages.StringField(1)
  permission = _messages.StringField(2)
  principal = _messages.StringField(3)


class GoogleCloudPolicytroubleshooterV1betaBindingExplanation(_messages.Message):
  r"""Binding Explanation.

  Enums:
    AccessValueValuesEnum: REQUIRED: Access decision for this binding.
    RelevanceValueValuesEnum: Bubbles up role_permission level relavance to
      BindingExplanation object. If role permission is NORMAL, then binding
      relevance is NORMAL. If role permission is HIGH, then binding relevance
      is HIGH.
    RolePermissionValueValuesEnum: Whether the role of this binding contains
      the checked permission
    RolePermissionRelevanceValueValuesEnum:

  Messages:
    MembershipsValue: For each member in the binding, provides information
      whether or not the principal from the request is included in the member
      by which the CheckResult is keyed. May indicate that the caller has no
      access to this information. example key: 'group:cloud-iam-assist-
      eng@google.com' example value '{NOT_GRANTED, HIGH}

  Fields:
    access: REQUIRED: Access decision for this binding.
    condition: The condition which needs to be satisfied in order for this
      binding to grant the role to the principal. See
      https://cloud.google.com/iam/docs/conditions-base
    memberships: For each member in the binding, provides information whether
      or not the principal from the request is included in the member by which
      the CheckResult is keyed. May indicate that the caller has no access to
      this information. example key: 'group:cloud-iam-assist-eng@google.com'
      example value '{NOT_GRANTED, HIGH}
    relevance: Bubbles up role_permission level relavance to
      BindingExplanation object. If role permission is NORMAL, then binding
      relevance is NORMAL. If role permission is HIGH, then binding relevance
      is HIGH.
    role: The role that this binding grants in the policy. for example
      "roles/compute.serviceAgent"
    rolePermission: Whether the role of this binding contains the checked
      permission
    rolePermissionRelevance: A RolePermissionRelevanceValueValuesEnum
      attribute.
  """

  class AccessValueValuesEnum(_messages.Enum):
    r"""REQUIRED: Access decision for this binding.

    Values:
      ACCESS_STATE_UNSPECIFIED: Reserved
      GRANTED: The access is granted due to one or multiple bindings found.
      NOT_GRANTED: The access is not granted by the policy.
      UNKNOWN_CONDITIONAL: At least one binding was found but it is
        conditional. undecided, undetermined ,uncertain, open, tentative,
        contingent
      UNKNOWN_INFO_DENIED: Indicating that lack of access to the underlying
        information causes the result to be undetermined. This can be due to
        1) The caller has no access to the policy. In this case
        ExplainedPolicy    will have not policy set.  2) The caller has no
        access to some of the items referenced in the policy.    In this case
        the policy in ExplainedPolicy will be set but the    explanations
        field will contain at least one inconclusive element.
    """
    ACCESS_STATE_UNSPECIFIED = 0
    GRANTED = 1
    NOT_GRANTED = 2
    UNKNOWN_CONDITIONAL = 3
    UNKNOWN_INFO_DENIED = 4

  class RelevanceValueValuesEnum(_messages.Enum):
    r"""Bubbles up role_permission level relavance to BindingExplanation
    object. If role permission is NORMAL, then binding relevance is NORMAL. If
    role permission is HIGH, then binding relevance is HIGH.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Default value, presence of this should
        be error.
      NORMAL: Fields annotated with this value contribute equally to
        evaluation result. In other words the fields are NOT specially
        important. This is a superset of fields annotated as HIGH.
      HIGH: Fields annotated with this are more important than the fields
        annotated by NORMAL. They are used for annotating fields which on
        potential modification can alter the overall access result.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    NORMAL = 1
    HIGH = 2

  class RolePermissionRelevanceValueValuesEnum(_messages.Enum):
    r"""RolePermissionRelevanceValueValuesEnum enum type.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Default value, presence of this should
        be error.
      NORMAL: Fields annotated with this value contribute equally to
        evaluation result. In other words the fields are NOT specially
        important. This is a superset of fields annotated as HIGH.
      HIGH: Fields annotated with this are more important than the fields
        annotated by NORMAL. They are used for annotating fields which on
        potential modification can alter the overall access result.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    NORMAL = 1
    HIGH = 2

  class RolePermissionValueValuesEnum(_messages.Enum):
    r"""Whether the role of this binding contains the checked permission

    Values:
      ROLE_PERMISSION_UNSPECIFIED: Reserved
      ROLE_PERMISSION_INCLUDED: Permission is included in the role.
      ROLE_PERMISSION_NOT_INCLUDED: Permission is included in the role.
      ROLE_PERMISSION_UNKNOWN_INFO_DENIED: Calling principal has no access to
        the role permission relation.
    """
    ROLE_PERMISSION_UNSPECIFIED = 0
    ROLE_PERMISSION_INCLUDED = 1
    ROLE_PERMISSION_NOT_INCLUDED = 2
    ROLE_PERMISSION_UNKNOWN_INFO_DENIED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MembershipsValue(_messages.Message):
    r"""For each member in the binding, provides information whether or not
    the principal from the request is included in the member by which the
    CheckResult is keyed. May indicate that the caller has no access to this
    information. example key: 'group:cloud-iam-assist-eng@google.com' example
    value '{NOT_GRANTED, HIGH}

    Messages:
      AdditionalProperty: An additional property for a MembershipsValue
        object.

    Fields:
      additionalProperties: Additional properties of type MembershipsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MembershipsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudPolicytroubleshooterV1betaBindingExplanationAnnota
          tedMembership attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudPolicytroubleshooterV1betaBindingExplanationAnnotatedMembership', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  access = _messages.EnumField('AccessValueValuesEnum', 1)
  condition = _messages.MessageField('GoogleTypeExpr', 2)
  memberships = _messages.MessageField('MembershipsValue', 3)
  relevance = _messages.EnumField('RelevanceValueValuesEnum', 4)
  role = _messages.StringField(5)
  rolePermission = _messages.EnumField('RolePermissionValueValuesEnum', 6)
  rolePermissionRelevance = _messages.EnumField('RolePermissionRelevanceValueValuesEnum', 7)


class GoogleCloudPolicytroubleshooterV1betaBindingExplanationAnnotatedMembership(_messages.Message):
  r"""A
  GoogleCloudPolicytroubleshooterV1betaBindingExplanationAnnotatedMembership
  object.

  Enums:
    MembershipValueValuesEnum:
    RelevanceValueValuesEnum:

  Fields:
    membership: A MembershipValueValuesEnum attribute.
    relevance: A RelevanceValueValuesEnum attribute.
  """

  class MembershipValueValuesEnum(_messages.Enum):
    r"""MembershipValueValuesEnum enum type.

    Values:
      MEMBERSHIP_UNSPECIFIED: Reserved.
      MEMBERSHIP_INCLUDED: Member is included in group/domain/allUsers or is a
        direct match.
      MEMBERSHIP_NOT_INCLUDED: Member is not included in group/domain/allUsers
        nor is a direct match.
      MEMBERSHIP_UNKNOWN_INFO_DENIED: Calling principal has no access to the
        membership relation.
      MEMBERSHIP_UNKNOWN_UNSUPPORTED: This member type is currently not
        supported.
    """
    MEMBERSHIP_UNSPECIFIED = 0
    MEMBERSHIP_INCLUDED = 1
    MEMBERSHIP_NOT_INCLUDED = 2
    MEMBERSHIP_UNKNOWN_INFO_DENIED = 3
    MEMBERSHIP_UNKNOWN_UNSUPPORTED = 4

  class RelevanceValueValuesEnum(_messages.Enum):
    r"""RelevanceValueValuesEnum enum type.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Default value, presence of this should
        be error.
      NORMAL: Fields annotated with this value contribute equally to
        evaluation result. In other words the fields are NOT specially
        important. This is a superset of fields annotated as HIGH.
      HIGH: Fields annotated with this are more important than the fields
        annotated by NORMAL. They are used for annotating fields which on
        potential modification can alter the overall access result.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    NORMAL = 1
    HIGH = 2

  membership = _messages.EnumField('MembershipValueValuesEnum', 1)
  relevance = _messages.EnumField('RelevanceValueValuesEnum', 2)


class GoogleCloudPolicytroubleshooterV1betaExplainedPolicy(_messages.Message):
  r"""An explained IAM policy combines the raw policy in the context of the
  resource which it is attached to along with detailed evaluation on the
  evaluation parameters provided through the request.

  Enums:
    AccessValueValuesEnum: Access decision for this section of the resource's
      effective policy.
    RelevanceValueValuesEnum: Relevance of this Policy.

  Fields:
    access: Access decision for this section of the resource's effective
      policy.
    bindingExplanations: Detailed binding evaluation explanations provide
      information about how each binding contributes to the principal's access
      or the lack thereof.
    fullResourceName: Resource that this section of the effective policy
      attaches to.
    policy: The IAM policy attached to the resource.
    relevance: Relevance of this Policy.
  """

  class AccessValueValuesEnum(_messages.Enum):
    r"""Access decision for this section of the resource's effective policy.

    Values:
      ACCESS_STATE_UNSPECIFIED: Reserved
      GRANTED: The access is granted due to one or multiple bindings found.
      NOT_GRANTED: The access is not granted by the policy.
      UNKNOWN_CONDITIONAL: At least one binding was found but it is
        conditional. undecided, undetermined ,uncertain, open, tentative,
        contingent
      UNKNOWN_INFO_DENIED: Indicating that lack of access to the underlying
        information causes the result to be undetermined. This can be due to
        1) The caller has no access to the policy. In this case
        ExplainedPolicy    will have not policy set.  2) The caller has no
        access to some of the items referenced in the policy.    In this case
        the policy in ExplainedPolicy will be set but the    explanations
        field will contain at least one inconclusive element.
    """
    ACCESS_STATE_UNSPECIFIED = 0
    GRANTED = 1
    NOT_GRANTED = 2
    UNKNOWN_CONDITIONAL = 3
    UNKNOWN_INFO_DENIED = 4

  class RelevanceValueValuesEnum(_messages.Enum):
    r"""Relevance of this Policy.

    Values:
      HEURISTIC_RELEVANCE_UNSPECIFIED: Default value, presence of this should
        be error.
      NORMAL: Fields annotated with this value contribute equally to
        evaluation result. In other words the fields are NOT specially
        important. This is a superset of fields annotated as HIGH.
      HIGH: Fields annotated with this are more important than the fields
        annotated by NORMAL. They are used for annotating fields which on
        potential modification can alter the overall access result.
    """
    HEURISTIC_RELEVANCE_UNSPECIFIED = 0
    NORMAL = 1
    HIGH = 2

  access = _messages.EnumField('AccessValueValuesEnum', 1)
  bindingExplanations = _messages.MessageField('GoogleCloudPolicytroubleshooterV1betaBindingExplanation', 2, repeated=True)
  fullResourceName = _messages.StringField(3)
  policy = _messages.MessageField('GoogleIamV1Policy', 4)
  relevance = _messages.EnumField('RelevanceValueValuesEnum', 5)


class GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyRequest(_messages.Message):
  r"""TroubleshootIamPolicyRequest is used in TroubleshootIamPolicy

  Fields:
    accessTuple: A GoogleCloudPolicytroubleshooterV1betaAccessTuple attribute.
  """

  accessTuple = _messages.MessageField('GoogleCloudPolicytroubleshooterV1betaAccessTuple', 1)


class GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse(_messages.Message):
  r"""TroubleshootIamPolicyResponse is used in TroubleshootIamPolicy.

  Enums:
    AccessValueValuesEnum: Reflects whether the probed access was granted,
      denied or ultimately could not be decided from the caller's point of
      view.

  Fields:
    access: Reflects whether the probed access was granted, denied or
      ultimately could not be decided from the caller's point of view.
    explainedPolicies: List of explained policies. Each explanation
      corresponds to one policy along the ancestry path.
  """

  class AccessValueValuesEnum(_messages.Enum):
    r"""Reflects whether the probed access was granted, denied or ultimately
    could not be decided from the caller's point of view.

    Values:
      ACCESS_STATE_UNSPECIFIED: Reserved
      GRANTED: The access is granted due to one or multiple bindings found.
      NOT_GRANTED: The access is not granted by the policy.
      UNKNOWN_CONDITIONAL: At least one binding was found but it is
        conditional. undecided, undetermined ,uncertain, open, tentative,
        contingent
      UNKNOWN_INFO_DENIED: Indicating that lack of access to the underlying
        information causes the result to be undetermined. This can be due to
        1) The caller has no access to the policy. In this case
        ExplainedPolicy    will have not policy set.  2) The caller has no
        access to some of the items referenced in the policy.    In this case
        the policy in ExplainedPolicy will be set but the    explanations
        field will contain at least one inconclusive element.
    """
    ACCESS_STATE_UNSPECIFIED = 0
    GRANTED = 1
    NOT_GRANTED = 2
    UNKNOWN_CONDITIONAL = 3
    UNKNOWN_INFO_DENIED = 4

  access = _messages.EnumField('AccessValueValuesEnum', 1)
  explainedPolicies = _messages.MessageField('GoogleCloudPolicytroubleshooterV1betaExplainedPolicy', 2, repeated=True)


class GoogleIamV1AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:jose@example.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "sampleservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:aliya@example.com"               ]             }           ]         }
  ]     }  For sampleservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging,
  and aliya@example.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('GoogleIamV1AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class GoogleIamV1AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:jose@example.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  jose@example.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class GoogleIamV1Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. NOTE: An
      unsatisfied condition will not allow user access via current binding.
      Different bindings, including their conditions, are examined
      independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example,
      `alice@example.com` .   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: The G Suite domain (primary) that represents all
      the    users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('GoogleTypeExpr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class GoogleIamV1Policy(_messages.Message):
  r"""Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **JSON Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  **YAML Example**      bindings:     - members:       -
  user:mike@example.com       - group:admins@example.com       -
  domain:google.com       - serviceAccount:my-other-
  app@appspot.gserviceaccount.com       role: roles/owner     - members:
  - user:sean@example.com       role: roles/viewer   For a description of IAM
  and its features, see the [IAM developer's
  guide](https://cloud.google.com/iam/docs).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. `bindings` with no
      members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten.
    version: Deprecated.
  """

  auditConfigs = _messages.MessageField('GoogleIamV1AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('GoogleIamV1Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleTypeExpr(_messages.Message):
  r"""Represents an expression text. Example:      title: "User account
  presence"     description: "Determines whether the request has a user
  account"     expression: "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
