"""Generated client library for gameservices version v1alpha."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.gameservices.v1alpha import gameservices_v1alpha_messages as messages


class GameservicesV1alpha(base_api.BaseApiClient):
  """Generated client library for service gameservices version v1alpha."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://gameservices.googleapis.com/'

  _PACKAGE = u'gameservices'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1alpha'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'GameservicesV1alpha'
  _URL_VERSION = u'v1alpha'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new gameservices handle."""
    url = url or self.BASE_URL
    super(GameservicesV1alpha, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_allocationPolicies = self.ProjectsLocationsAllocationPoliciesService(self)
    self.projects_locations_gameServerDeployments = self.ProjectsLocationsGameServerDeploymentsService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_realms_gameServerClusters = self.ProjectsLocationsRealmsGameServerClustersService(self)
    self.projects_locations_realms = self.ProjectsLocationsRealmsService(self)
    self.projects_locations_scalingPolicies = self.ProjectsLocationsScalingPoliciesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsAllocationPoliciesService(base_api.BaseApiService):
    """Service class for the projects_locations_allocationPolicies resource."""

    _NAME = u'projects_locations_allocationPolicies'

    def __init__(self, client):
      super(GameservicesV1alpha.ProjectsLocationsAllocationPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new allocation policy in a given project and location.

      Args:
        request: (GameservicesProjectsLocationsAllocationPoliciesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/allocationPolicies',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.allocationPolicies.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'allocationPolicyId'],
        relative_path=u'v1alpha/{+parent}/allocationPolicies',
        request_field=u'allocationPolicy',
        request_type_name=u'GameservicesProjectsLocationsAllocationPoliciesCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single allocation policy.

      Args:
        request: (GameservicesProjectsLocationsAllocationPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/allocationPolicies/{allocationPoliciesId}',
        http_method=u'DELETE',
        method_id=u'gameservices.projects.locations.allocationPolicies.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsAllocationPoliciesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single allocation policy.

      Args:
        request: (GameservicesProjectsLocationsAllocationPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AllocationPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/allocationPolicies/{allocationPoliciesId}',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.allocationPolicies.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsAllocationPoliciesGetRequest',
        response_type_name=u'AllocationPolicy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List allocation policies in a given project and location.

      Args:
        request: (GameservicesProjectsLocationsAllocationPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAllocationPoliciesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/allocationPolicies',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.allocationPolicies.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha/{+parent}/allocationPolicies',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsAllocationPoliciesListRequest',
        response_type_name=u'ListAllocationPoliciesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches a single allocation policy.

      Args:
        request: (GameservicesProjectsLocationsAllocationPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/allocationPolicies/{allocationPoliciesId}',
        http_method=u'PATCH',
        method_id=u'gameservices.projects.locations.allocationPolicies.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha/{+name}',
        request_field=u'allocationPolicy',
        request_type_name=u'GameservicesProjectsLocationsAllocationPoliciesPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsLocationsGameServerDeploymentsService(base_api.BaseApiService):
    """Service class for the projects_locations_gameServerDeployments resource."""

    _NAME = u'projects_locations_gameServerDeployments'

    def __init__(self, client):
      super(GameservicesV1alpha.ProjectsLocationsGameServerDeploymentsService, self).__init__(client)
      self._upload_configs = {
          }

    def CommitRollout(self, request, global_params=None):
      r"""Commits the ongoing game server deployment rollout by setting the rollout.
percentage to 100 in all clusters whose labels match labels in the game
server template.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsCommitRolloutRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CommitRollout')
      return self._RunMethod(
          config, request, global_params=global_params)

    CommitRollout.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}:commitRollout',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.gameServerDeployments.commitRollout',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}:commitRollout',
        request_field=u'commitRolloutRequest',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsCommitRolloutRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new game server deployment in a given project and location.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/gameServerDeployments',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.gameServerDeployments.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'deploymentId'],
        relative_path=u'v1alpha/{+parent}/gameServerDeployments',
        request_field=u'gameServerDeployment',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single game server deployment.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}',
        http_method=u'DELETE',
        method_id=u'gameservices.projects.locations.gameServerDeployments.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single game server deployment.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GameServerDeployment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.gameServerDeployments.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsGetRequest',
        response_type_name=u'GameServerDeployment',
        supports_download=False,
    )

    def GetDeploymentTarget(self, request, global_params=None):
      r"""Retrieves information on the rollout target of the deployment, e.g. the.
target percentage of game servers running stable_game_server_template and
new_game_server_template in clusters.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsGetDeploymentTargetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DeploymentTarget) The response message.
      """
      config = self.GetMethodConfig('GetDeploymentTarget')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetDeploymentTarget.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}:getDeploymentTarget',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.gameServerDeployments.getDeploymentTarget',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}:getDeploymentTarget',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsGetDeploymentTargetRequest',
        response_type_name=u'DeploymentTarget',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource.
Returns an empty policy if the resource exists and does not have a policy
set.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}:getIamPolicy',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.gameServerDeployments.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[u'options_requestedPolicyVersion'],
        relative_path=u'v1alpha/{+resource}:getIamPolicy',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists game server deployments in a given project and location.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListGameServerDeploymentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/gameServerDeployments',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.gameServerDeployments.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha/{+parent}/gameServerDeployments',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsListRequest',
        response_type_name=u'ListGameServerDeploymentsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches a game server deployment.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}',
        http_method=u'PATCH',
        method_id=u'gameservices.projects.locations.gameServerDeployments.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha/{+name}',
        request_field=u'gameServerDeployment',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def RevertRollout(self, request, global_params=None):
      r"""Rolls back the ongoing game server deployment rollout by setting the.
rollout percentage to 0 in all clusters whose labels match labels in the
game server template.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsRevertRolloutRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RevertRollout')
      return self._RunMethod(
          config, request, global_params=global_params)

    RevertRollout.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}:revertRollout',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.gameServerDeployments.revertRollout',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}:revertRollout',
        request_field=u'revertRolloutRequest',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsRevertRolloutRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any.
existing policy.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.gameServerDeployments.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def SetRolloutTarget(self, request, global_params=None):
      r"""Sets rollout target for the ongoing game server deployment rollout in the.
specified clusters and based on the given rollout percentage. Default is 0.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsSetRolloutTargetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetRolloutTarget')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetRolloutTarget.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}:setRolloutTarget',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.gameServerDeployments.setRolloutTarget',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}:setRolloutTarget',
        request_field=u'setRolloutTargetRequest',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsSetRolloutTargetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def StartRollout(self, request, global_params=None):
      r"""Starts rollout of this game server deployment based on the given game.
server template.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsStartRolloutRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StartRollout')
      return self._RunMethod(
          config, request, global_params=global_params)

    StartRollout.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}:startRollout',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.gameServerDeployments.startRollout',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}:startRollout',
        request_field=u'startRolloutRequest',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsStartRolloutRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
If the resource does not exist, this will return an empty set of
permissions, not a NOT_FOUND error.

Note: This operation is designed to be used for building permission-aware
UIs and command-line tools, not for authorization checking. This operation
may "fail open" without warning.

      Args:
        request: (GameservicesProjectsLocationsGameServerDeploymentsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/gameServerDeployments/{gameServerDeploymentsId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.gameServerDeployments.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'GameservicesProjectsLocationsGameServerDeploymentsTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = u'projects_locations_operations'

    def __init__(self, client):
      super(GameservicesV1alpha.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation.  The server.
makes a best effort to cancel the operation, but success is not
guaranteed.  If the server doesn't support this method, it returns
`google.rpc.Code.UNIMPLEMENTED`.  Clients can use
Operations.GetOperation or
other methods to check whether the cancellation succeeded or whether the
operation completed despite cancellation. On successful cancellation,
the operation is not deleted; instead, it becomes an operation with
an Operation.error value with a google.rpc.Status.code of 1,
corresponding to `Code.CANCELLED`.

      Args:
        request: (GameservicesProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.operations.cancel',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}:cancel',
        request_field=u'cancelOperationRequest',
        request_type_name=u'GameservicesProjectsLocationsOperationsCancelRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is.
no longer interested in the operation result. It does not cancel the
operation. If the server doesn't support this method, it returns
`google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (GameservicesProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method=u'DELETE',
        method_id=u'gameservices.projects.locations.operations.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsOperationsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (GameservicesProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.operations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the.
server doesn't support this method, it returns `UNIMPLEMENTED`.

NOTE: the `name` binding allows API services to override the binding
to use different resource name schemes, such as `users/*/operations`. To
override the binding, API services can add a binding such as
`"/v1/{name=users/*}/operations"` to their service configuration.
For backwards compatibility, the default name includes the operations
collection id, however overriding users must ensure the name binding
is the parent resource, without the operations collection id.

      Args:
        request: (GameservicesProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/operations',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.operations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha/{+name}/operations',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsOperationsListRequest',
        response_type_name=u'ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsRealmsGameServerClustersService(base_api.BaseApiService):
    """Service class for the projects_locations_realms_gameServerClusters resource."""

    _NAME = u'projects_locations_realms_gameServerClusters'

    def __init__(self, client):
      super(GameservicesV1alpha.ProjectsLocationsRealmsGameServerClustersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new game server cluster in a given project and location.

      Args:
        request: (GameservicesProjectsLocationsRealmsGameServerClustersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}/gameServerClusters',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.realms.gameServerClusters.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'gameServerClusterId'],
        relative_path=u'v1alpha/{+parent}/gameServerClusters',
        request_field=u'gameServerCluster',
        request_type_name=u'GameservicesProjectsLocationsRealmsGameServerClustersCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single game server cluster.

      Args:
        request: (GameservicesProjectsLocationsRealmsGameServerClustersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}/gameServerClusters/{gameServerClustersId}',
        http_method=u'DELETE',
        method_id=u'gameservices.projects.locations.realms.gameServerClusters.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsRealmsGameServerClustersDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single game server cluster.

      Args:
        request: (GameservicesProjectsLocationsRealmsGameServerClustersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GameServerCluster) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}/gameServerClusters/{gameServerClustersId}',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.realms.gameServerClusters.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsRealmsGameServerClustersGetRequest',
        response_type_name=u'GameServerCluster',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists game server clusters in a given project and location.

      Args:
        request: (GameservicesProjectsLocationsRealmsGameServerClustersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListGameServerClustersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}/gameServerClusters',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.realms.gameServerClusters.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha/{+parent}/gameServerClusters',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsRealmsGameServerClustersListRequest',
        response_type_name=u'ListGameServerClustersResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches a single game server cluster.

      Args:
        request: (GameservicesProjectsLocationsRealmsGameServerClustersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}/gameServerClusters/{gameServerClustersId}',
        http_method=u'PATCH',
        method_id=u'gameservices.projects.locations.realms.gameServerClusters.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha/{+name}',
        request_field=u'gameServerCluster',
        request_type_name=u'GameservicesProjectsLocationsRealmsGameServerClustersPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsLocationsRealmsService(base_api.BaseApiService):
    """Service class for the projects_locations_realms resource."""

    _NAME = u'projects_locations_realms'

    def __init__(self, client):
      super(GameservicesV1alpha.ProjectsLocationsRealmsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Realm in a given project and location.

      Args:
        request: (GameservicesProjectsLocationsRealmsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/realms',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.realms.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'realmId'],
        relative_path=u'v1alpha/{+parent}/realms',
        request_field=u'realm',
        request_type_name=u'GameservicesProjectsLocationsRealmsCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single realm.

      Args:
        request: (GameservicesProjectsLocationsRealmsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}',
        http_method=u'DELETE',
        method_id=u'gameservices.projects.locations.realms.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsRealmsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single realm.

      Args:
        request: (GameservicesProjectsLocationsRealmsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Realm) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.realms.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsRealmsGetRequest',
        response_type_name=u'Realm',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists realms in a given project and location.

      Args:
        request: (GameservicesProjectsLocationsRealmsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRealmsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/realms',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.realms.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha/{+parent}/realms',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsRealmsListRequest',
        response_type_name=u'ListRealmsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches a single Realm.

      Args:
        request: (GameservicesProjectsLocationsRealmsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}',
        http_method=u'PATCH',
        method_id=u'gameservices.projects.locations.realms.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha/{+name}',
        request_field=u'realm',
        request_type_name=u'GameservicesProjectsLocationsRealmsPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsLocationsScalingPoliciesService(base_api.BaseApiService):
    """Service class for the projects_locations_scalingPolicies resource."""

    _NAME = u'projects_locations_scalingPolicies'

    def __init__(self, client):
      super(GameservicesV1alpha.ProjectsLocationsScalingPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new scaling policy in a given project and location.

      Args:
        request: (GameservicesProjectsLocationsScalingPoliciesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/scalingPolicies',
        http_method=u'POST',
        method_id=u'gameservices.projects.locations.scalingPolicies.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'scalingPolicyId'],
        relative_path=u'v1alpha/{+parent}/scalingPolicies',
        request_field=u'scalingPolicy',
        request_type_name=u'GameservicesProjectsLocationsScalingPoliciesCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single scaling policy.

      Args:
        request: (GameservicesProjectsLocationsScalingPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/scalingPolicies/{scalingPoliciesId}',
        http_method=u'DELETE',
        method_id=u'gameservices.projects.locations.scalingPolicies.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsScalingPoliciesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single scaling policy.

      Args:
        request: (GameservicesProjectsLocationsScalingPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ScalingPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/scalingPolicies/{scalingPoliciesId}',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.scalingPolicies.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsScalingPoliciesGetRequest',
        response_type_name=u'ScalingPolicy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists ScalingPolicies in a given project and location.

      Args:
        request: (GameservicesProjectsLocationsScalingPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListScalingPoliciesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/scalingPolicies',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.scalingPolicies.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha/{+parent}/scalingPolicies',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsScalingPoliciesListRequest',
        response_type_name=u'ListScalingPoliciesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches a single scaling policy.

      Args:
        request: (GameservicesProjectsLocationsScalingPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}/scalingPolicies/{scalingPoliciesId}',
        http_method=u'PATCH',
        method_id=u'gameservices.projects.locations.scalingPolicies.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha/{+name}',
        request_field=u'scalingPolicy',
        request_type_name=u'GameservicesProjectsLocationsScalingPoliciesPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(GameservicesV1alpha.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (GameservicesProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations/{locationsId}',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha/{+name}',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsGetRequest',
        response_type_name=u'Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (GameservicesProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha/projects/{projectsId}/locations',
        http_method=u'GET',
        method_id=u'gameservices.projects.locations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1alpha/{+name}/locations',
        request_field='',
        request_type_name=u'GameservicesProjectsLocationsListRequest',
        response_type_name=u'ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(GameservicesV1alpha.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
