"""Generated message classes for spanner version v1.

Cloud Spanner is a managed, mission-critical, globally consistent and scalable
relational database service.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'spanner'


class BeginTransactionRequest(_messages.Message):
  r"""The request for BeginTransaction.

  Fields:
    options: Required. Options for the new transaction.
  """

  options = _messages.MessageField('TransactionOptions', 1)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. NOTE: An
      unsatisfied condition will not allow user access via current binding.
      Different bindings, including their conditions, are examined
      independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example,
      `alice@example.com` .   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: The G Suite domain (primary) that represents all
      the    users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class ChildLink(_messages.Message):
  r"""Metadata associated with a parent-child relationship appearing in a
  PlanNode.

  Fields:
    childIndex: The node to which the link points.
    type: The type of the link. For example, in Hash Joins this could be used
      to distinguish between the build child and the probe child, or in the
      case of the child being an output variable, to represent the tag
      associated with the output variable.
    variable: Only present if the child node is SCALAR and corresponds to an
      output variable of the parent node. The field carries the name of the
      output variable. For example, a `TableScan` operator that reads rows
      from a table will have child links to the `SCALAR` nodes representing
      the output variables created for each column that is read by the
      operator. The corresponding `variable` fields will be set to the
      variable names assigned to the columns.
  """

  childIndex = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  type = _messages.StringField(2)
  variable = _messages.StringField(3)


class CommitRequest(_messages.Message):
  r"""The request for Commit.

  Fields:
    mutations: The mutations to be executed when this transaction commits. All
      mutations are applied atomically, in the order they appear in this list.
    singleUseTransaction: Execute mutations in a temporary transaction. Note
      that unlike commit of a previously-started transaction, commit with a
      temporary transaction is non-idempotent. That is, if the `CommitRequest`
      is sent to Cloud Spanner more than once (for instance, due to retries in
      the application, or in the transport library), it is possible that the
      mutations are executed more than once. If this is undesirable, use
      BeginTransaction and Commit instead.
    transactionId: Commit a previously-started transaction.
  """

  mutations = _messages.MessageField('Mutation', 1, repeated=True)
  singleUseTransaction = _messages.MessageField('TransactionOptions', 2)
  transactionId = _messages.BytesField(3)


class CommitResponse(_messages.Message):
  r"""The response for Commit.

  Fields:
    commitTimestamp: The Cloud Spanner timestamp at which the transaction
      committed.
  """

  commitTimestamp = _messages.StringField(1)


class CreateDatabaseMetadata(_messages.Message):
  r"""Metadata type for the operation returned by CreateDatabase.

  Fields:
    database: The database being created.
  """

  database = _messages.StringField(1)


class CreateDatabaseRequest(_messages.Message):
  r"""The request for CreateDatabase.

  Fields:
    createStatement: Required. A `CREATE DATABASE` statement, which specifies
      the ID of the new database.  The database ID must conform to the regular
      expression `a-z*[a-z0-9]` and be between 2 and 30 characters in length.
      If the database ID is a reserved word or if it contains a hyphen, the
      database ID must be enclosed in backticks (`` ` ``).
    extraStatements: An optional list of DDL statements to run inside the
      newly created database. Statements can create tables, indexes, etc.
      These statements execute atomically with the creation of the database:
      if there is an error in any statement, the database is not created.
  """

  createStatement = _messages.StringField(1)
  extraStatements = _messages.StringField(2, repeated=True)


class CreateInstanceMetadata(_messages.Message):
  r"""Metadata type for the operation returned by CreateInstance.

  Fields:
    cancelTime: The time at which this operation was cancelled. If set, this
      operation is in the process of undoing itself (which is guaranteed to
      succeed) and cannot be cancelled again.
    endTime: The time at which this operation failed or was completed
      successfully.
    instance: The instance being created.
    startTime: The time at which the CreateInstance request was received.
  """

  cancelTime = _messages.StringField(1)
  endTime = _messages.StringField(2)
  instance = _messages.MessageField('Instance', 3)
  startTime = _messages.StringField(4)


class CreateInstanceRequest(_messages.Message):
  r"""The request for CreateInstance.

  Fields:
    instance: Required. The instance to create.  The name may be omitted, but
      if specified must be `<parent>/instances/<instance_id>`.
    instanceId: Required. The ID of the instance to create.  Valid identifiers
      are of the form `a-z*[a-z0-9]` and must be between 2 and 64 characters
      in length.
  """

  instance = _messages.MessageField('Instance', 1)
  instanceId = _messages.StringField(2)


class CreateSessionRequest(_messages.Message):
  r"""The request for CreateSession.

  Fields:
    session: The session to create.
  """

  session = _messages.MessageField('Session', 1)


class Database(_messages.Message):
  r"""A Cloud Spanner database.

  Enums:
    StateValueValuesEnum: Output only. The current database state.

  Fields:
    name: Required. The name of the database. Values are of the form
      `projects/<project>/instances/<instance>/databases/<database>`, where
      `<database>` is as specified in the `CREATE DATABASE` statement. This
      name can be passed to other API methods to identify the database.
    state: Output only. The current database state.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current database state.

    Values:
      STATE_UNSPECIFIED: Not specified.
      CREATING: The database is still being created. Operations on the
        database may fail with `FAILED_PRECONDITION` in this state.
      READY: The database is fully created and ready for use.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2

  name = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class Delete(_messages.Message):
  r"""Arguments to delete operations.

  Fields:
    keySet: Required. The primary keys of the rows within table to delete.
      Delete is idempotent. The transaction will succeed even if some or all
      rows do not exist.
    table: Required. The table whose rows will be deleted.
  """

  keySet = _messages.MessageField('KeySet', 1)
  table = _messages.StringField(2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class ExecuteBatchDmlRequest(_messages.Message):
  r"""The request for ExecuteBatchDml.

  Fields:
    seqno: A per-transaction sequence number used to identify this request.
      This field makes each request idempotent such that if the request is
      received multiple times, at most one will succeed.  The sequence number
      must be monotonically increasing within the transaction. If a request
      arrives for the first time with an out-of-order sequence number, the
      transaction may be aborted. Replays of previously handled requests will
      yield the same response as the first execution.
    statements: The list of statements to execute in this batch. Statements
      are executed serially, such that the effects of statement `i` are
      visible to statement `i+1`. Each statement must be a DML statement.
      Execution stops at the first failed statement; the remaining statements
      are not executed.  Callers must provide at least one statement.
    transaction: The transaction to use. Must be a read-write transaction.  To
      protect against replays, single-use transactions are not supported. The
      caller must either supply an existing transaction ID or begin a new
      transaction.
  """

  seqno = _messages.IntegerField(1)
  statements = _messages.MessageField('Statement', 2, repeated=True)
  transaction = _messages.MessageField('TransactionSelector', 3)


class ExecuteBatchDmlResponse(_messages.Message):
  r"""The response for ExecuteBatchDml. Contains a list of ResultSet messages,
  one for each DML statement that has successfully executed, in the same order
  as the statements in the request. If a statement fails, the status in the
  response body identifies the cause of the failure.  To check for DML
  statements that failed, use the following approach:  1. Check the status in
  the response message. The google.rpc.Code enum    value `OK` indicates that
  all statements were executed successfully. 2. If the status was not `OK`,
  check the number of result sets in the    response. If the response contains
  `N` ResultSet messages, then    statement `N+1` in the request failed.
  Example 1:  * Request: 5 DML statements, all executed successfully. *
  Response: 5 ResultSet messages, with the status `OK`.  Example 2:  *
  Request: 5 DML statements. The third statement has a syntax error. *
  Response: 2 ResultSet messages, and a syntax error (`INVALID_ARGUMENT`)
  status. The number of ResultSet messages indicates that the third
  statement failed, and the fourth and fifth statements were not executed.

  Fields:
    resultSets: One ResultSet for each statement in the request that ran
      successfully, in the same order as the statements in the request. Each
      ResultSet does not contain any rows. The ResultSetStats in each
      ResultSet contain the number of rows modified by the statement.  Only
      the first ResultSet in the response contains valid ResultSetMetadata.
    status: If all DML statements are executed successfully, the status is
      `OK`. Otherwise, the error status of the first failed statement.
  """

  resultSets = _messages.MessageField('ResultSet', 1, repeated=True)
  status = _messages.MessageField('Status', 2)


class ExecuteSqlRequest(_messages.Message):
  r"""The request for ExecuteSql and ExecuteStreamingSql.

  Enums:
    QueryModeValueValuesEnum: Used to control the amount of debugging
      information returned in ResultSetStats. If partition_token is set,
      query_mode can only be set to QueryMode.NORMAL.

  Messages:
    ParamTypesValue: It is not always possible for Cloud Spanner to infer the
      right SQL type from a JSON value.  For example, values of type `BYTES`
      and values of type `STRING` both appear in params as JSON strings.  In
      these cases, `param_types` can be used to specify the exact SQL type for
      some or all of the SQL statement parameters. See the definition of Type
      for more information about SQL types.
    ParamsValue: Parameter names and values that bind to placeholders in the
      SQL string.  A parameter placeholder consists of the `@` character
      followed by the parameter name (for example, `@firstName`). Parameter
      names can contain letters, numbers, and underscores.  Parameters can
      appear anywhere that a literal value is expected.  The same parameter
      name can be used more than once, for example:  `"WHERE id > @msg_id AND
      id < @msg_id + 100"`  It is an error to execute a SQL statement with
      unbound parameters.

  Fields:
    paramTypes: It is not always possible for Cloud Spanner to infer the right
      SQL type from a JSON value.  For example, values of type `BYTES` and
      values of type `STRING` both appear in params as JSON strings.  In these
      cases, `param_types` can be used to specify the exact SQL type for some
      or all of the SQL statement parameters. See the definition of Type for
      more information about SQL types.
    params: Parameter names and values that bind to placeholders in the SQL
      string.  A parameter placeholder consists of the `@` character followed
      by the parameter name (for example, `@firstName`). Parameter names can
      contain letters, numbers, and underscores.  Parameters can appear
      anywhere that a literal value is expected.  The same parameter name can
      be used more than once, for example:  `"WHERE id > @msg_id AND id <
      @msg_id + 100"`  It is an error to execute a SQL statement with unbound
      parameters.
    partitionToken: If present, results will be restricted to the specified
      partition previously created using PartitionQuery().  There must be an
      exact match for the values of fields common to this message and the
      PartitionQueryRequest message used to create this partition_token.
    queryMode: Used to control the amount of debugging information returned in
      ResultSetStats. If partition_token is set, query_mode can only be set to
      QueryMode.NORMAL.
    resumeToken: If this request is resuming a previously interrupted SQL
      statement execution, `resume_token` should be copied from the last
      PartialResultSet yielded before the interruption. Doing this enables the
      new SQL statement execution to resume where the last one left off. The
      rest of the request parameters must exactly match the request that
      yielded this token.
    seqno: A per-transaction sequence number used to identify this request.
      This field makes each request idempotent such that if the request is
      received multiple times, at most one will succeed.  The sequence number
      must be monotonically increasing within the transaction. If a request
      arrives for the first time with an out-of-order sequence number, the
      transaction may be aborted. Replays of previously handled requests will
      yield the same response as the first execution.  Required for DML
      statements. Ignored for queries.
    sql: Required. The SQL string.
    transaction: The transaction to use.  For queries, if none is provided,
      the default is a temporary read-only transaction with strong
      concurrency.  Standard DML statements require a read-write transaction.
      To protect against replays, single-use transactions are not supported.
      The caller must either supply an existing transaction ID or begin a new
      transaction.  Partitioned DML requires an existing Partitioned DML
      transaction ID.
  """

  class QueryModeValueValuesEnum(_messages.Enum):
    r"""Used to control the amount of debugging information returned in
    ResultSetStats. If partition_token is set, query_mode can only be set to
    QueryMode.NORMAL.

    Values:
      NORMAL: The default mode. Only the statement results are returned.
      PLAN: This mode returns only the query plan, without any results or
        execution statistics information.
      PROFILE: This mode returns both the query plan and the execution
        statistics along with the results.
    """
    NORMAL = 0
    PLAN = 1
    PROFILE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParamTypesValue(_messages.Message):
    r"""It is not always possible for Cloud Spanner to infer the right SQL
    type from a JSON value.  For example, values of type `BYTES` and values of
    type `STRING` both appear in params as JSON strings.  In these cases,
    `param_types` can be used to specify the exact SQL type for some or all of
    the SQL statement parameters. See the definition of Type for more
    information about SQL types.

    Messages:
      AdditionalProperty: An additional property for a ParamTypesValue object.

    Fields:
      additionalProperties: Additional properties of type ParamTypesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParamTypesValue object.

      Fields:
        key: Name of the additional property.
        value: A Type attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Type', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParamsValue(_messages.Message):
    r"""Parameter names and values that bind to placeholders in the SQL
    string.  A parameter placeholder consists of the `@` character followed by
    the parameter name (for example, `@firstName`). Parameter names can
    contain letters, numbers, and underscores.  Parameters can appear anywhere
    that a literal value is expected.  The same parameter name can be used
    more than once, for example:  `"WHERE id > @msg_id AND id < @msg_id +
    100"`  It is an error to execute a SQL statement with unbound parameters.

    Messages:
      AdditionalProperty: An additional property for a ParamsValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParamsValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  paramTypes = _messages.MessageField('ParamTypesValue', 1)
  params = _messages.MessageField('ParamsValue', 2)
  partitionToken = _messages.BytesField(3)
  queryMode = _messages.EnumField('QueryModeValueValuesEnum', 4)
  resumeToken = _messages.BytesField(5)
  seqno = _messages.IntegerField(6)
  sql = _messages.StringField(7)
  transaction = _messages.MessageField('TransactionSelector', 8)


class Expr(_messages.Message):
  r"""Represents an expression text. Example:      title: "User account
  presence"     description: "Determines whether the request has a user
  account"     expression: "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class Field(_messages.Message):
  r"""Message representing a single field of a struct.

  Fields:
    name: The name of the field. For reads, this is the column name. For SQL
      queries, it is the column alias (e.g., `"Word"` in the query `"SELECT
      'hello' AS Word"`), or the column name (e.g., `"ColName"` in the query
      `"SELECT ColName FROM Table"`). Some columns might have an empty name
      (e.g., !"SELECT UPPER(ColName)"`). Note that a query result can contain
      multiple fields with the same name.
    type: The type of the field.
  """

  name = _messages.StringField(1)
  type = _messages.MessageField('Type', 2)


class GetDatabaseDdlResponse(_messages.Message):
  r"""The response for GetDatabaseDdl.

  Fields:
    statements: A list of formatted DDL statements defining the schema of the
      database specified in the request.
  """

  statements = _messages.StringField(1, repeated=True)


class GetIamPolicyRequest(_messages.Message):
  r"""Request message for `GetIamPolicy` method.

  Fields:
    options: OPTIONAL: A `GetPolicyOptions` object for specifying options to
      `GetIamPolicy`. This field is only used by Cloud IAM.
  """

  options = _messages.MessageField('GetPolicyOptions', 1)


class GetPolicyOptions(_messages.Message):
  r"""Encapsulates settings provided to GetIamPolicy.

  Fields:
    requestedPolicyVersion: Optional. The policy format version to be
      returned. Acceptable values are 0 and 1. If the value is 0, or the field
      is omitted, policy format version 1 will be returned.
  """

  requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class Instance(_messages.Message):
  r"""An isolated set of Cloud Spanner resources on which databases can be
  hosted.

  Enums:
    StateValueValuesEnum: Output only. The current instance state. For
      CreateInstance, the state must be either omitted or set to `CREATING`.
      For UpdateInstance, the state must be either omitted or set to `READY`.

  Messages:
    LabelsValue: Cloud Labels are a flexible and lightweight mechanism for
      organizing cloud resources into groups that reflect a customer's
      organizational needs and deployment strategies. Cloud Labels can be used
      to filter collections of resources. They can be used to control how
      resource metrics are aggregated. And they can be used as arguments to
      policy management rules (e.g. route, firewall, load balancing, etc.).
      * Label keys must be between 1 and 63 characters long and must conform
      to    the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.  *
      Label values must be between 0 and 63 characters long and must conform
      to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.  * No more
      than 64 labels can be associated with a given resource.  See
      https://goo.gl/xmQnxf for more information on and examples of labels.
      If you plan to use labels in your own code, please note that additional
      characters may be allowed in the future. And so you are advised to use
      an internal label representation, such as JSON, which doesn't rely upon
      specific characters being disallowed.  For example, representing labels
      as the string:  name + "_" + value  would prove problematic if we were
      to allow "_" in a future release.

  Fields:
    config: Required. The name of the instance's configuration. Values are of
      the form `projects/<project>/instanceConfigs/<configuration>`. See also
      InstanceConfig and ListInstanceConfigs.
    displayName: Required. The descriptive name for this instance as it
      appears in UIs. Must be unique per project and between 4 and 30
      characters in length.
    labels: Cloud Labels are a flexible and lightweight mechanism for
      organizing cloud resources into groups that reflect a customer's
      organizational needs and deployment strategies. Cloud Labels can be used
      to filter collections of resources. They can be used to control how
      resource metrics are aggregated. And they can be used as arguments to
      policy management rules (e.g. route, firewall, load balancing, etc.).
      * Label keys must be between 1 and 63 characters long and must conform
      to    the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.  *
      Label values must be between 0 and 63 characters long and must conform
      to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.  * No more
      than 64 labels can be associated with a given resource.  See
      https://goo.gl/xmQnxf for more information on and examples of labels.
      If you plan to use labels in your own code, please note that additional
      characters may be allowed in the future. And so you are advised to use
      an internal label representation, such as JSON, which doesn't rely upon
      specific characters being disallowed.  For example, representing labels
      as the string:  name + "_" + value  would prove problematic if we were
      to allow "_" in a future release.
    name: Required. A unique identifier for the instance, which cannot be
      changed after the instance is created. Values are of the form
      `projects/<project>/instances/a-z*[a-z0-9]`. The final segment of the
      name must be between 2 and 64 characters in length.
    nodeCount: Required. The number of nodes allocated to this instance. This
      may be zero in API responses for instances that are not yet in state
      `READY`.  See [the documentation](https://cloud.google.com/spanner/docs/
      instances#node_count) for more information about nodes.
    state: Output only. The current instance state. For CreateInstance, the
      state must be either omitted or set to `CREATING`. For UpdateInstance,
      the state must be either omitted or set to `READY`.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current instance state. For CreateInstance, the state
    must be either omitted or set to `CREATING`. For UpdateInstance, the state
    must be either omitted or set to `READY`.

    Values:
      STATE_UNSPECIFIED: Not specified.
      CREATING: The instance is still being created. Resources may not be
        available yet, and operations such as database creation may not work.
      READY: The instance is fully created and ready to do work such as
        creating databases.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cloud Labels are a flexible and lightweight mechanism for organizing
    cloud resources into groups that reflect a customer's organizational needs
    and deployment strategies. Cloud Labels can be used to filter collections
    of resources. They can be used to control how resource metrics are
    aggregated. And they can be used as arguments to policy management rules
    (e.g. route, firewall, load balancing, etc.).   * Label keys must be
    between 1 and 63 characters long and must conform to    the following
    regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.  * Label values must be
    between 0 and 63 characters long and must conform    to the regular
    expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.  * No more than 64 labels can
    be associated with a given resource.  See https://goo.gl/xmQnxf for more
    information on and examples of labels.  If you plan to use labels in your
    own code, please note that additional characters may be allowed in the
    future. And so you are advised to use an internal label representation,
    such as JSON, which doesn't rely upon specific characters being
    disallowed.  For example, representing labels as the string:  name + "_" +
    value  would prove problematic if we were to allow "_" in a future
    release.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  config = _messages.StringField(1)
  displayName = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  nodeCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  state = _messages.EnumField('StateValueValuesEnum', 6)


class InstanceConfig(_messages.Message):
  r"""A possible configuration for a Cloud Spanner instance. Configurations
  define the geographic placement of nodes and their replication.

  Fields:
    displayName: The name of this instance configuration as it appears in UIs.
    name: A unique identifier for the instance configuration.  Values are of
      the form `projects/<project>/instanceConfigs/a-z*`
    replicas: The geographic placement of nodes in this instance configuration
      and their replication properties.
  """

  displayName = _messages.StringField(1)
  name = _messages.StringField(2)
  replicas = _messages.MessageField('ReplicaInfo', 3, repeated=True)


class KeyRange(_messages.Message):
  r"""KeyRange represents a range of rows in a table or index.  A range has a
  start key and an end key. These keys can be open or closed, indicating if
  the range includes rows with that key.  Keys are represented by lists, where
  the ith value in the list corresponds to the ith component of the table or
  index primary key. Individual values are encoded as described here.  For
  example, consider the following table definition:      CREATE TABLE
  UserEvents (       UserName STRING(MAX),       EventDate STRING(10)     )
  PRIMARY KEY(UserName, EventDate);  The following keys name rows in this
  table:      "Bob", "2014-09-23"  Since the `UserEvents` table's `PRIMARY
  KEY` clause names two columns, each `UserEvents` key has two elements; the
  first is the `UserName`, and the second is the `EventDate`.  Key ranges with
  multiple components are interpreted lexicographically by component using the
  table or index key's declared sort order. For example, the following range
  returns all events for user `"Bob"` that occurred in the year 2015:
  "start_closed": ["Bob", "2015-01-01"]     "end_closed": ["Bob",
  "2015-12-31"]  Start and end keys can omit trailing key components. This
  affects the inclusion and exclusion of rows that exactly match the provided
  key components: if the key is closed, then rows that exactly match the
  provided components are included; if the key is open, then rows that exactly
  match are not included.  For example, the following range includes all
  events for `"Bob"` that occurred during and after the year 2000:
  "start_closed": ["Bob", "2000-01-01"]     "end_closed": ["Bob"]  The next
  example retrieves all events for `"Bob"`:      "start_closed": ["Bob"]
  "end_closed": ["Bob"]  To retrieve events before the year 2000:
  "start_closed": ["Bob"]     "end_open": ["Bob", "2000-01-01"]  The following
  range includes all rows in the table:      "start_closed": []
  "end_closed": []  This range returns all users whose `UserName` begins with
  any character from A to C:      "start_closed": ["A"]     "end_open": ["D"]
  This range returns all users whose `UserName` begins with B:
  "start_closed": ["B"]     "end_open": ["C"]  Key ranges honor column sort
  order. For example, suppose a table is defined as follows:      CREATE TABLE
  DescendingSortedTable {       Key INT64,       ...     ) PRIMARY KEY(Key
  DESC);  The following range retrieves all rows with key values between 1 and
  100 inclusive:      "start_closed": ["100"]     "end_closed": ["1"]  Note
  that 100 is passed as the start, and 1 is passed as the end, because `Key`
  is a descending column in the schema.

  Fields:
    endClosed: If the end is closed, then the range includes all rows whose
      first `len(end_closed)` key columns exactly match `end_closed`.
    endOpen: If the end is open, then the range excludes rows whose first
      `len(end_open)` key columns exactly match `end_open`.
    startClosed: If the start is closed, then the range includes all rows
      whose first `len(start_closed)` key columns exactly match
      `start_closed`.
    startOpen: If the start is open, then the range excludes rows whose first
      `len(start_open)` key columns exactly match `start_open`.
  """

  endClosed = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)
  endOpen = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)
  startClosed = _messages.MessageField('extra_types.JsonValue', 3, repeated=True)
  startOpen = _messages.MessageField('extra_types.JsonValue', 4, repeated=True)


class KeySet(_messages.Message):
  r"""`KeySet` defines a collection of Cloud Spanner keys and/or key ranges.
  All the keys are expected to be in the same table or index. The keys need
  not be sorted in any particular way.  If the same key is specified multiple
  times in the set (for example if two ranges, two keys, or a key and a range
  overlap), Cloud Spanner behaves as if the key were only specified once.

  Messages:
    KeysValueListEntry: Single entry in a KeysValue.

  Fields:
    all: For convenience `all` can be set to `true` to indicate that this
      `KeySet` matches all keys in the table or index. Note that any keys
      specified in `keys` or `ranges` are only yielded once.
    keys: A list of specific keys. Entries in `keys` should have exactly as
      many elements as there are columns in the primary or index key with
      which this `KeySet` is used.  Individual key values are encoded as
      described here.
    ranges: A list of key ranges. See KeyRange for more information about key
      range specifications.
  """

  class KeysValueListEntry(_messages.Message):
    r"""Single entry in a KeysValue.

    Fields:
      entry: A extra_types.JsonValue attribute.
    """

    entry = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)

  all = _messages.BooleanField(1)
  keys = _messages.MessageField('KeysValueListEntry', 2, repeated=True)
  ranges = _messages.MessageField('KeyRange', 3, repeated=True)


class ListDatabasesResponse(_messages.Message):
  r"""The response for ListDatabases.

  Fields:
    databases: Databases that matched the request.
    nextPageToken: `next_page_token` can be sent in a subsequent ListDatabases
      call to fetch more of the matching databases.
  """

  databases = _messages.MessageField('Database', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListInstanceConfigsResponse(_messages.Message):
  r"""The response for ListInstanceConfigs.

  Fields:
    instanceConfigs: The list of requested instance configurations.
    nextPageToken: `next_page_token` can be sent in a subsequent
      ListInstanceConfigs call to fetch more of the matching instance
      configurations.
  """

  instanceConfigs = _messages.MessageField('InstanceConfig', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListInstancesResponse(_messages.Message):
  r"""The response for ListInstances.

  Fields:
    instances: The list of requested instances.
    nextPageToken: `next_page_token` can be sent in a subsequent ListInstances
      call to fetch more of the matching instances.
  """

  instances = _messages.MessageField('Instance', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListSessionsResponse(_messages.Message):
  r"""The response for ListSessions.

  Fields:
    nextPageToken: `next_page_token` can be sent in a subsequent ListSessions
      call to fetch more of the matching sessions.
    sessions: The list of requested sessions.
  """

  nextPageToken = _messages.StringField(1)
  sessions = _messages.MessageField('Session', 2, repeated=True)


class Mutation(_messages.Message):
  r"""A modification to one or more Cloud Spanner rows.  Mutations can be
  applied to a Cloud Spanner database by sending them in a Commit call.

  Fields:
    delete: Delete rows from a table. Succeeds whether or not the named rows
      were present.
    insert: Insert new rows in a table. If any of the rows already exist, the
      write or transaction fails with error `ALREADY_EXISTS`.
    insertOrUpdate: Like insert, except that if the row already exists, then
      its column values are overwritten with the ones provided. Any column
      values not explicitly written are preserved.
    replace: Like insert, except that if the row already exists, it is
      deleted, and the column values provided are inserted instead. Unlike
      insert_or_update, this means any values not explicitly written become
      `NULL`.
    update: Update existing rows in a table. If any of the rows does not
      already exist, the transaction fails with error `NOT_FOUND`.
  """

  delete = _messages.MessageField('Delete', 1)
  insert = _messages.MessageField('Write', 2)
  insertOrUpdate = _messages.MessageField('Write', 3)
  replace = _messages.MessageField('Write', 4)
  update = _messages.MessageField('Write', 5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class PartialResultSet(_messages.Message):
  r"""Partial results from a streaming read or SQL query. Streaming reads and
  SQL queries better tolerate large result sets, large rows, and large values,
  but are a little trickier to consume.

  Fields:
    chunkedValue: If true, then the final value in values is chunked, and must
      be combined with more values from subsequent `PartialResultSet`s to
      obtain a complete field value.
    metadata: Metadata about the result set, such as row type information.
      Only present in the first response.
    resumeToken: Streaming calls might be interrupted for a variety of
      reasons, such as TCP connection loss. If this occurs, the stream of
      results can be resumed by re-sending the original request and including
      `resume_token`. Note that executing any other transaction in the same
      session invalidates the token.
    stats: Query plan and execution statistics for the statement that produced
      this streaming result set. These can be requested by setting
      ExecuteSqlRequest.query_mode and are sent only once with the last
      response in the stream. This field will also be present in the last
      response for DML statements.
    values: A streamed result set consists of a stream of values, which might
      be split into many `PartialResultSet` messages to accommodate large rows
      and/or large values. Every N complete values defines a row, where N is
      equal to the number of entries in metadata.row_type.fields.  Most values
      are encoded based on type as described here.  It is possible that the
      last value in values is "chunked", meaning that the rest of the value is
      sent in subsequent `PartialResultSet`(s). This is denoted by the
      chunked_value field. Two or more chunked values can be merged to form a
      complete value as follows:    * `bool/number/null`: cannot be chunked
      * `string`: concatenate the strings   * `list`: concatenate the lists.
      If the last element in a list is a     `string`, `list`, or `object`,
      merge it with the first element in     the next list by applying these
      rules recursively.   * `object`: concatenate the (field name, field
      value) pairs. If a     field name is duplicated, then apply these rules
      recursively     to merge the field values.  Some examples of merging:
      # Strings are concatenated.     "foo", "bar" => "foobar"      # Lists of
      non-strings are concatenated.     [2, 3], [4] => [2, 3, 4]      # Lists
      are concatenated, but the last and first elements are merged     #
      because they are strings.     ["a", "b"], ["c", "d"] => ["a", "bc", "d"]
      # Lists are concatenated, but the last and first elements are merged
      # because they are lists. Recursively, the last and first elements     #
      of the inner lists are merged because they are strings.     ["a", ["b",
      "c"]], [["d"], "e"] => ["a", ["b", "cd"], "e"]      # Non-overlapping
      object fields are combined.     {"a": "1"}, {"b": "2"} => {"a": "1",
      "b": 2"}      # Overlapping object fields are merged.     {"a": "1"},
      {"a": "2"} => {"a": "12"}      # Examples of merging objects containing
      lists of strings.     {"a": ["1"]}, {"a": ["2"]} => {"a": ["12"]}  For a
      more complete example, suppose a streaming SQL query is yielding a
      result set whose rows contain a single string field. The following
      `PartialResultSet`s might be yielded:      {       "metadata": { ... }
      "values": ["Hello", "W"]       "chunked_value": true
      "resume_token": "Af65..."     }     {       "values": ["orl"]
      "chunked_value": true       "resume_token": "Bqp2..."     }     {
      "values": ["d"]       "resume_token": "Zx1B..."     }  This sequence of
      `PartialResultSet`s encodes two rows, one containing the field value
      `"Hello"`, and a second containing the field value `"World" = "W" +
      "orl" + "d"`.
  """

  chunkedValue = _messages.BooleanField(1)
  metadata = _messages.MessageField('ResultSetMetadata', 2)
  resumeToken = _messages.BytesField(3)
  stats = _messages.MessageField('ResultSetStats', 4)
  values = _messages.MessageField('extra_types.JsonValue', 5, repeated=True)


class Partition(_messages.Message):
  r"""Information returned for each partition returned in a PartitionResponse.

  Fields:
    partitionToken: This token can be passed to Read, StreamingRead,
      ExecuteSql, or ExecuteStreamingSql requests to restrict the results to
      those identified by this partition token.
  """

  partitionToken = _messages.BytesField(1)


class PartitionOptions(_messages.Message):
  r"""Options for a PartitionQueryRequest and PartitionReadRequest.

  Fields:
    maxPartitions: **Note:** This hint is currently ignored by PartitionQuery
      and PartitionRead requests.  The desired maximum number of partitions to
      return.  For example, this may be set to the number of workers
      available.  The default for this option is currently 10,000. The maximum
      value is currently 200,000.  This is only a hint.  The actual number of
      partitions returned may be smaller or larger than this maximum count
      request.
    partitionSizeBytes: **Note:** This hint is currently ignored by
      PartitionQuery and PartitionRead requests.  The desired data size for
      each partition generated.  The default for this option is currently 1
      GiB.  This is only a hint. The actual size of each partition may be
      smaller or larger than this size request.
  """

  maxPartitions = _messages.IntegerField(1)
  partitionSizeBytes = _messages.IntegerField(2)


class PartitionQueryRequest(_messages.Message):
  r"""The request for PartitionQuery

  Messages:
    ParamTypesValue: It is not always possible for Cloud Spanner to infer the
      right SQL type from a JSON value.  For example, values of type `BYTES`
      and values of type `STRING` both appear in params as JSON strings.  In
      these cases, `param_types` can be used to specify the exact SQL type for
      some or all of the SQL query parameters. See the definition of Type for
      more information about SQL types.
    ParamsValue: Parameter names and values that bind to placeholders in the
      SQL string.  A parameter placeholder consists of the `@` character
      followed by the parameter name (for example, `@firstName`). Parameter
      names can contain letters, numbers, and underscores.  Parameters can
      appear anywhere that a literal value is expected.  The same parameter
      name can be used more than once, for example:  `"WHERE id > @msg_id AND
      id < @msg_id + 100"`  It is an error to execute a SQL statement with
      unbound parameters.

  Fields:
    paramTypes: It is not always possible for Cloud Spanner to infer the right
      SQL type from a JSON value.  For example, values of type `BYTES` and
      values of type `STRING` both appear in params as JSON strings.  In these
      cases, `param_types` can be used to specify the exact SQL type for some
      or all of the SQL query parameters. See the definition of Type for more
      information about SQL types.
    params: Parameter names and values that bind to placeholders in the SQL
      string.  A parameter placeholder consists of the `@` character followed
      by the parameter name (for example, `@firstName`). Parameter names can
      contain letters, numbers, and underscores.  Parameters can appear
      anywhere that a literal value is expected.  The same parameter name can
      be used more than once, for example:  `"WHERE id > @msg_id AND id <
      @msg_id + 100"`  It is an error to execute a SQL statement with unbound
      parameters.
    partitionOptions: Additional options that affect how many partitions are
      created.
    sql: The query request to generate partitions for. The request will fail
      if the query is not root partitionable. The query plan of a root
      partitionable query has a single distributed union operator. A
      distributed union operator conceptually divides one or more tables into
      multiple splits, remotely evaluates a subquery independently on each
      split, and then unions all results.  This must not contain DML commands,
      such as INSERT, UPDATE, or DELETE. Use ExecuteStreamingSql with a
      PartitionedDml transaction for large, partition-friendly DML operations.
    transaction: Read only snapshot transactions are supported, read/write and
      single use transactions are not.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParamTypesValue(_messages.Message):
    r"""It is not always possible for Cloud Spanner to infer the right SQL
    type from a JSON value.  For example, values of type `BYTES` and values of
    type `STRING` both appear in params as JSON strings.  In these cases,
    `param_types` can be used to specify the exact SQL type for some or all of
    the SQL query parameters. See the definition of Type for more information
    about SQL types.

    Messages:
      AdditionalProperty: An additional property for a ParamTypesValue object.

    Fields:
      additionalProperties: Additional properties of type ParamTypesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParamTypesValue object.

      Fields:
        key: Name of the additional property.
        value: A Type attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Type', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParamsValue(_messages.Message):
    r"""Parameter names and values that bind to placeholders in the SQL
    string.  A parameter placeholder consists of the `@` character followed by
    the parameter name (for example, `@firstName`). Parameter names can
    contain letters, numbers, and underscores.  Parameters can appear anywhere
    that a literal value is expected.  The same parameter name can be used
    more than once, for example:  `"WHERE id > @msg_id AND id < @msg_id +
    100"`  It is an error to execute a SQL statement with unbound parameters.

    Messages:
      AdditionalProperty: An additional property for a ParamsValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParamsValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  paramTypes = _messages.MessageField('ParamTypesValue', 1)
  params = _messages.MessageField('ParamsValue', 2)
  partitionOptions = _messages.MessageField('PartitionOptions', 3)
  sql = _messages.StringField(4)
  transaction = _messages.MessageField('TransactionSelector', 5)


class PartitionReadRequest(_messages.Message):
  r"""The request for PartitionRead

  Fields:
    columns: The columns of table to be returned for each row matching this
      request.
    index: If non-empty, the name of an index on table. This index is used
      instead of the table primary key when interpreting key_set and sorting
      result rows. See key_set for further information.
    keySet: Required. `key_set` identifies the rows to be yielded. `key_set`
      names the primary keys of the rows in table to be yielded, unless index
      is present. If index is present, then key_set instead names index keys
      in index.  It is not an error for the `key_set` to name rows that do not
      exist in the database. Read yields nothing for nonexistent rows.
    partitionOptions: Additional options that affect how many partitions are
      created.
    table: Required. The name of the table in the database to be read.
    transaction: Read only snapshot transactions are supported, read/write and
      single use transactions are not.
  """

  columns = _messages.StringField(1, repeated=True)
  index = _messages.StringField(2)
  keySet = _messages.MessageField('KeySet', 3)
  partitionOptions = _messages.MessageField('PartitionOptions', 4)
  table = _messages.StringField(5)
  transaction = _messages.MessageField('TransactionSelector', 6)


class PartitionResponse(_messages.Message):
  r"""The response for PartitionQuery or PartitionRead

  Fields:
    partitions: Partitions created by this request.
    transaction: Transaction created by this request.
  """

  partitions = _messages.MessageField('Partition', 1, repeated=True)
  transaction = _messages.MessageField('Transaction', 2)


class PartitionedDml(_messages.Message):
  r"""Message type to initiate a Partitioned DML transaction."""


class PlanNode(_messages.Message):
  r"""Node information for nodes appearing in a QueryPlan.plan_nodes.

  Enums:
    KindValueValuesEnum: Used to determine the type of node. May be needed for
      visualizing different kinds of nodes differently. For example, If the
      node is a SCALAR node, it will have a condensed representation which can
      be used to directly embed a description of the node in its parent.

  Messages:
    ExecutionStatsValue: The execution statistics associated with the node,
      contained in a group of key-value pairs. Only present if the plan was
      returned as a result of a profile query. For example, number of
      executions, number of rows/time per execution etc.
    MetadataValue: Attributes relevant to the node contained in a group of
      key-value pairs. For example, a Parameter Reference node could have the
      following information in its metadata:      {
      "parameter_reference": "param1",       "parameter_type": "array"     }

  Fields:
    childLinks: List of child node `index`es and their relationship to this
      parent.
    displayName: The display name for the node.
    executionStats: The execution statistics associated with the node,
      contained in a group of key-value pairs. Only present if the plan was
      returned as a result of a profile query. For example, number of
      executions, number of rows/time per execution etc.
    index: The `PlanNode`'s index in node list.
    kind: Used to determine the type of node. May be needed for visualizing
      different kinds of nodes differently. For example, If the node is a
      SCALAR node, it will have a condensed representation which can be used
      to directly embed a description of the node in its parent.
    metadata: Attributes relevant to the node contained in a group of key-
      value pairs. For example, a Parameter Reference node could have the
      following information in its metadata:      {
      "parameter_reference": "param1",       "parameter_type": "array"     }
    shortRepresentation: Condensed representation for SCALAR nodes.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""Used to determine the type of node. May be needed for visualizing
    different kinds of nodes differently. For example, If the node is a SCALAR
    node, it will have a condensed representation which can be used to
    directly embed a description of the node in its parent.

    Values:
      KIND_UNSPECIFIED: Not specified.
      RELATIONAL: Denotes a Relational operator node in the expression tree.
        Relational operators represent iterative processing of rows during
        query execution. For example, a `TableScan` operation that reads rows
        from a table.
      SCALAR: Denotes a Scalar node in the expression tree. Scalar nodes
        represent non-iterable entities in the query plan. For example,
        constants or arithmetic operators appearing inside predicate
        expressions or references to column names.
    """
    KIND_UNSPECIFIED = 0
    RELATIONAL = 1
    SCALAR = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExecutionStatsValue(_messages.Message):
    r"""The execution statistics associated with the node, contained in a
    group of key-value pairs. Only present if the plan was returned as a
    result of a profile query. For example, number of executions, number of
    rows/time per execution etc.

    Messages:
      AdditionalProperty: An additional property for a ExecutionStatsValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ExecutionStatsValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Attributes relevant to the node contained in a group of key-value
    pairs. For example, a Parameter Reference node could have the following
    information in its metadata:      {       "parameter_reference": "param1",
    "parameter_type": "array"     }

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  childLinks = _messages.MessageField('ChildLink', 1, repeated=True)
  displayName = _messages.StringField(2)
  executionStats = _messages.MessageField('ExecutionStatsValue', 3)
  index = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  kind = _messages.EnumField('KindValueValuesEnum', 5)
  metadata = _messages.MessageField('MetadataValue', 6)
  shortRepresentation = _messages.MessageField('ShortRepresentation', 7)


class Policy(_messages.Message):
  r"""Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **JSON Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  **YAML Example**      bindings:     - members:       -
  user:mike@example.com       - group:admins@example.com       -
  domain:google.com       - serviceAccount:my-other-
  app@appspot.gserviceaccount.com       role: roles/owner     - members:
  - user:sean@example.com       role: roles/viewer   For a description of IAM
  and its features, see the [IAM developer's
  guide](https://cloud.google.com/iam/docs).

  Fields:
    bindings: Associates a list of `members` to a `role`. `bindings` with no
      members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten.
    version: Deprecated.
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class QueryPlan(_messages.Message):
  r"""Contains an ordered list of nodes appearing in the query plan.

  Fields:
    planNodes: The nodes in the query plan. Plan nodes are returned in pre-
      order starting with the plan root. Each PlanNode's `id` corresponds to
      its index in `plan_nodes`.
  """

  planNodes = _messages.MessageField('PlanNode', 1, repeated=True)


class ReadOnly(_messages.Message):
  r"""Message type to initiate a read-only transaction.

  Fields:
    exactStaleness: Executes all reads at a timestamp that is
      `exact_staleness` old. The timestamp is chosen soon after the read is
      started.  Guarantees that all writes that have committed more than the
      specified number of seconds ago are visible. Because Cloud Spanner
      chooses the exact timestamp, this mode works even if the client's local
      clock is substantially skewed from Cloud Spanner commit timestamps.
      Useful for reading at nearby replicas without the distributed timestamp
      negotiation overhead of `max_staleness`.
    maxStaleness: Read data at a timestamp >= `NOW - max_staleness` seconds.
      Guarantees that all writes that have committed more than the specified
      number of seconds ago are visible. Because Cloud Spanner chooses the
      exact timestamp, this mode works even if the client's local clock is
      substantially skewed from Cloud Spanner commit timestamps.  Useful for
      reading the freshest data available at a nearby replica, while bounding
      the possible staleness if the local replica has fallen behind.  Note
      that this option can only be used in single-use transactions.
    minReadTimestamp: Executes all reads at a timestamp >=
      `min_read_timestamp`.  This is useful for requesting fresher data than
      some previous read, or data that is fresh enough to observe the effects
      of some previously committed transaction whose timestamp is known.  Note
      that this option can only be used in single-use transactions.  A
      timestamp in RFC3339 UTC \"Zulu\" format, accurate to nanoseconds.
      Example: `"2014-10-02T15:01:23.045123456Z"`.
    readTimestamp: Executes all reads at the given timestamp. Unlike other
      modes, reads at a specific timestamp are repeatable; the same read at
      the same timestamp always returns the same data. If the timestamp is in
      the future, the read will block until the specified timestamp, modulo
      the read's deadline.  Useful for large scale consistent reads such as
      mapreduces, or for coordinating many reads against a consistent snapshot
      of the data.  A timestamp in RFC3339 UTC \"Zulu\" format, accurate to
      nanoseconds. Example: `"2014-10-02T15:01:23.045123456Z"`.
    returnReadTimestamp: If true, the Cloud Spanner-selected read timestamp is
      included in the Transaction message that describes the transaction.
    strong: Read at a timestamp where all previously committed transactions
      are visible.
  """

  exactStaleness = _messages.StringField(1)
  maxStaleness = _messages.StringField(2)
  minReadTimestamp = _messages.StringField(3)
  readTimestamp = _messages.StringField(4)
  returnReadTimestamp = _messages.BooleanField(5)
  strong = _messages.BooleanField(6)


class ReadRequest(_messages.Message):
  r"""The request for Read and StreamingRead.

  Fields:
    columns: The columns of table to be returned for each row matching this
      request.
    index: If non-empty, the name of an index on table. This index is used
      instead of the table primary key when interpreting key_set and sorting
      result rows. See key_set for further information.
    keySet: Required. `key_set` identifies the rows to be yielded. `key_set`
      names the primary keys of the rows in table to be yielded, unless index
      is present. If index is present, then key_set instead names index keys
      in index.  If the partition_token field is empty, rows are yielded in
      table primary key order (if index is empty) or index key order (if index
      is non-empty).  If the partition_token field is not empty, rows will be
      yielded in an unspecified order.  It is not an error for the `key_set`
      to name rows that do not exist in the database. Read yields nothing for
      nonexistent rows.
    limit: If greater than zero, only the first `limit` rows are yielded. If
      `limit` is zero, the default is no limit. A limit cannot be specified if
      `partition_token` is set.
    partitionToken: If present, results will be restricted to the specified
      partition previously created using PartitionRead().    There must be an
      exact match for the values of fields common to this message and the
      PartitionReadRequest message used to create this partition_token.
    resumeToken: If this request is resuming a previously interrupted read,
      `resume_token` should be copied from the last PartialResultSet yielded
      before the interruption. Doing this enables the new read to resume where
      the last read left off. The rest of the request parameters must exactly
      match the request that yielded this token.
    table: Required. The name of the table in the database to be read.
    transaction: The transaction to use. If none is provided, the default is a
      temporary read-only transaction with strong concurrency.
  """

  columns = _messages.StringField(1, repeated=True)
  index = _messages.StringField(2)
  keySet = _messages.MessageField('KeySet', 3)
  limit = _messages.IntegerField(4)
  partitionToken = _messages.BytesField(5)
  resumeToken = _messages.BytesField(6)
  table = _messages.StringField(7)
  transaction = _messages.MessageField('TransactionSelector', 8)


class ReadWrite(_messages.Message):
  r"""Message type to initiate a read-write transaction. Currently this
  transaction type has no options.
  """



class ReplicaInfo(_messages.Message):
  r"""A ReplicaInfo object.

  Enums:
    TypeValueValuesEnum: The type of replica.

  Fields:
    defaultLeaderLocation: If true, this location is designated as the default
      leader location where leader replicas are placed. See the [region types
      documentation](https://cloud.google.com/spanner/docs/instances#region_ty
      pes) for more details.
    location: The location of the serving resources, e.g. "us-central1".
    type: The type of replica.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of replica.

    Values:
      TYPE_UNSPECIFIED: Not specified.
      READ_WRITE: Read-write replicas support both reads and writes. These
        replicas:  * Maintain a full copy of your data. * Serve reads. * Can
        vote whether to commit a write. * Participate in leadership election.
        * Are eligible to become a leader.
      READ_ONLY: Read-only replicas only support reads (not writes). Read-only
        replicas:  * Maintain a full copy of your data. * Serve reads. * Do
        not participate in voting to commit writes. * Are not eligible to
        become a leader.
      WITNESS: Witness replicas don't support reads but do participate in
        voting to commit writes. Witness replicas:  * Do not maintain a full
        copy of data. * Do not serve reads. * Vote whether to commit writes. *
        Participate in leader election but are not eligible to become leader.
    """
    TYPE_UNSPECIFIED = 0
    READ_WRITE = 1
    READ_ONLY = 2
    WITNESS = 3

  defaultLeaderLocation = _messages.BooleanField(1)
  location = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class ResultSet(_messages.Message):
  r"""Results from Read or ExecuteSql.

  Messages:
    RowsValueListEntry: Single entry in a RowsValue.

  Fields:
    metadata: Metadata about the result set, such as row type information.
    rows: Each element in `rows` is a row whose format is defined by
      metadata.row_type. The ith element in each row matches the ith field in
      metadata.row_type. Elements are encoded based on type as described here.
    stats: Query plan and execution statistics for the SQL statement that
      produced this result set. These can be requested by setting
      ExecuteSqlRequest.query_mode. DML statements always produce stats
      containing the number of rows modified, unless executed using the
      ExecuteSqlRequest.QueryMode.PLAN ExecuteSqlRequest.query_mode. Other
      fields may or may not be populated, based on the
      ExecuteSqlRequest.query_mode.
  """

  class RowsValueListEntry(_messages.Message):
    r"""Single entry in a RowsValue.

    Fields:
      entry: A extra_types.JsonValue attribute.
    """

    entry = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)

  metadata = _messages.MessageField('ResultSetMetadata', 1)
  rows = _messages.MessageField('RowsValueListEntry', 2, repeated=True)
  stats = _messages.MessageField('ResultSetStats', 3)


class ResultSetMetadata(_messages.Message):
  r"""Metadata about a ResultSet or PartialResultSet.

  Fields:
    rowType: Indicates the field names and types for the rows in the result
      set.  For example, a SQL query like `"SELECT UserId, UserName FROM
      Users"` could return a `row_type` value like:      "fields": [       {
      "name": "UserId", "type": { "code": "INT64" } },       { "name":
      "UserName", "type": { "code": "STRING" } },     ]
    transaction: If the read or SQL query began a transaction as a side-
      effect, the information about the new transaction is yielded here.
  """

  rowType = _messages.MessageField('StructType', 1)
  transaction = _messages.MessageField('Transaction', 2)


class ResultSetStats(_messages.Message):
  r"""Additional statistics about a ResultSet or PartialResultSet.

  Messages:
    QueryStatsValue: Aggregated statistics from the execution of the query.
      Only present when the query is profiled. For example, a query could
      return the statistics as follows:      {       "rows_returned": "3",
      "elapsed_time": "1.22 secs",       "cpu_time": "1.19 secs"     }

  Fields:
    queryPlan: QueryPlan for the query associated with this result.
    queryStats: Aggregated statistics from the execution of the query. Only
      present when the query is profiled. For example, a query could return
      the statistics as follows:      {       "rows_returned": "3",
      "elapsed_time": "1.22 secs",       "cpu_time": "1.19 secs"     }
    rowCountExact: Standard DML returns an exact count of rows that were
      modified.
    rowCountLowerBound: Partitioned DML does not offer exactly-once semantics,
      so it returns a lower bound of the rows modified.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class QueryStatsValue(_messages.Message):
    r"""Aggregated statistics from the execution of the query. Only present
    when the query is profiled. For example, a query could return the
    statistics as follows:      {       "rows_returned": "3",
    "elapsed_time": "1.22 secs",       "cpu_time": "1.19 secs"     }

    Messages:
      AdditionalProperty: An additional property for a QueryStatsValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a QueryStatsValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  queryPlan = _messages.MessageField('QueryPlan', 1)
  queryStats = _messages.MessageField('QueryStatsValue', 2)
  rowCountExact = _messages.IntegerField(3)
  rowCountLowerBound = _messages.IntegerField(4)


class RollbackRequest(_messages.Message):
  r"""The request for Rollback.

  Fields:
    transactionId: Required. The transaction to roll back.
  """

  transactionId = _messages.BytesField(1)


class Session(_messages.Message):
  r"""A session in the Cloud Spanner API.

  Messages:
    LabelsValue: The labels for the session.   * Label keys must be between 1
      and 63 characters long and must conform to    the following regular
      expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.  * Label values must be
      between 0 and 63 characters long and must conform    to the regular
      expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.  * No more than 64 labels
      can be associated with a given session.  See https://goo.gl/xmQnxf for
      more information on and examples of labels.

  Fields:
    approximateLastUseTime: Output only. The approximate timestamp when the
      session is last used. It is typically earlier than the actual last use
      time.
    createTime: Output only. The timestamp when the session is created.
    labels: The labels for the session.   * Label keys must be between 1 and
      63 characters long and must conform to    the following regular
      expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.  * Label values must be
      between 0 and 63 characters long and must conform    to the regular
      expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.  * No more than 64 labels
      can be associated with a given session.  See https://goo.gl/xmQnxf for
      more information on and examples of labels.
    name: The name of the session. This is always system-assigned; values
      provided when creating a session are ignored.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The labels for the session.   * Label keys must be between 1 and 63
    characters long and must conform to    the following regular expression:
    `[a-z]([-a-z0-9]*[a-z0-9])?`.  * Label values must be between 0 and 63
    characters long and must conform    to the regular expression
    `([a-z]([-a-z0-9]*[a-z0-9])?)?`.  * No more than 64 labels can be
    associated with a given session.  See https://goo.gl/xmQnxf for more
    information on and examples of labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  approximateLastUseTime = _messages.StringField(1)
  createTime = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
  """

  policy = _messages.MessageField('Policy', 1)


class ShortRepresentation(_messages.Message):
  r"""Condensed representation of a node and its subtree. Only present for
  `SCALAR` PlanNode(s).

  Messages:
    SubqueriesValue: A mapping of (subquery variable name) -> (subquery node
      id) for cases where the `description` string of this node references a
      `SCALAR` subquery contained in the expression subtree rooted at this
      node. The referenced `SCALAR` subquery may not necessarily be a direct
      child of this node.

  Fields:
    description: A string representation of the expression subtree rooted at
      this node.
    subqueries: A mapping of (subquery variable name) -> (subquery node id)
      for cases where the `description` string of this node references a
      `SCALAR` subquery contained in the expression subtree rooted at this
      node. The referenced `SCALAR` subquery may not necessarily be a direct
      child of this node.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SubqueriesValue(_messages.Message):
    r"""A mapping of (subquery variable name) -> (subquery node id) for cases
    where the `description` string of this node references a `SCALAR` subquery
    contained in the expression subtree rooted at this node. The referenced
    `SCALAR` subquery may not necessarily be a direct child of this node.

    Messages:
      AdditionalProperty: An additional property for a SubqueriesValue object.

    Fields:
      additionalProperties: Additional properties of type SubqueriesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SubqueriesValue object.

      Fields:
        key: Name of the additional property.
        value: A integer attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2, variant=_messages.Variant.INT32)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  description = _messages.StringField(1)
  subqueries = _messages.MessageField('SubqueriesValue', 2)


class SpannerProjectsInstanceConfigsGetRequest(_messages.Message):
  r"""A SpannerProjectsInstanceConfigsGetRequest object.

  Fields:
    name: Required. The name of the requested instance configuration. Values
      are of the form `projects/<project>/instanceConfigs/<config>`.
  """

  name = _messages.StringField(1, required=True)


class SpannerProjectsInstanceConfigsListRequest(_messages.Message):
  r"""A SpannerProjectsInstanceConfigsListRequest object.

  Fields:
    pageSize: Number of instance configurations to be returned in the
      response. If 0 or less, defaults to the server's maximum allowed page
      size.
    pageToken: If non-empty, `page_token` should contain a next_page_token
      from a previous ListInstanceConfigsResponse.
    parent: Required. The name of the project for which a list of supported
      instance configurations is requested. Values are of the form
      `projects/<project>`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SpannerProjectsInstancesCreateRequest(_messages.Message):
  r"""A SpannerProjectsInstancesCreateRequest object.

  Fields:
    createInstanceRequest: A CreateInstanceRequest resource to be passed as
      the request body.
    parent: Required. The name of the project in which to create the instance.
      Values are of the form `projects/<project>`.
  """

  createInstanceRequest = _messages.MessageField('CreateInstanceRequest', 1)
  parent = _messages.StringField(2, required=True)


class SpannerProjectsInstancesDatabasesCreateRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesCreateRequest object.

  Fields:
    createDatabaseRequest: A CreateDatabaseRequest resource to be passed as
      the request body.
    parent: Required. The name of the instance that will serve the new
      database. Values are of the form
      `projects/<project>/instances/<instance>`.
  """

  createDatabaseRequest = _messages.MessageField('CreateDatabaseRequest', 1)
  parent = _messages.StringField(2, required=True)


class SpannerProjectsInstancesDatabasesDropDatabaseRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesDropDatabaseRequest object.

  Fields:
    database: Required. The database to be dropped.
  """

  database = _messages.StringField(1, required=True)


class SpannerProjectsInstancesDatabasesGetDdlRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesGetDdlRequest object.

  Fields:
    database: Required. The database whose schema we wish to get.
  """

  database = _messages.StringField(1, required=True)


class SpannerProjectsInstancesDatabasesGetIamPolicyRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The Cloud Spanner resource for which the policy is
      being retrieved. The format is `projects/<project
      ID>/instances/<instance ID>` for instance resources and
      `projects/<project ID>/instances/<instance ID>/databases/<database ID>`
      for database resources.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class SpannerProjectsInstancesDatabasesGetRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesGetRequest object.

  Fields:
    name: Required. The name of the requested database. Values are of the form
      `projects/<project>/instances/<instance>/databases/<database>`.
  """

  name = _messages.StringField(1, required=True)


class SpannerProjectsInstancesDatabasesListRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesListRequest object.

  Fields:
    pageSize: Number of databases to be returned in the response. If 0 or
      less, defaults to the server's maximum allowed page size.
    pageToken: If non-empty, `page_token` should contain a next_page_token
      from a previous ListDatabasesResponse.
    parent: Required. The instance whose databases should be listed. Values
      are of the form `projects/<project>/instances/<instance>`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SpannerProjectsInstancesDatabasesOperationsCancelRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class SpannerProjectsInstancesDatabasesOperationsDeleteRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class SpannerProjectsInstancesDatabasesOperationsGetRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class SpannerProjectsInstancesDatabasesOperationsListRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class SpannerProjectsInstancesDatabasesSessionsBeginTransactionRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesSessionsBeginTransactionRequest
  object.

  Fields:
    beginTransactionRequest: A BeginTransactionRequest resource to be passed
      as the request body.
    session: Required. The session in which the transaction runs.
  """

  beginTransactionRequest = _messages.MessageField('BeginTransactionRequest', 1)
  session = _messages.StringField(2, required=True)


class SpannerProjectsInstancesDatabasesSessionsCommitRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesSessionsCommitRequest object.

  Fields:
    commitRequest: A CommitRequest resource to be passed as the request body.
    session: Required. The session in which the transaction to be committed is
      running.
  """

  commitRequest = _messages.MessageField('CommitRequest', 1)
  session = _messages.StringField(2, required=True)


class SpannerProjectsInstancesDatabasesSessionsCreateRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesSessionsCreateRequest object.

  Fields:
    createSessionRequest: A CreateSessionRequest resource to be passed as the
      request body.
    database: Required. The database in which the new session is created.
  """

  createSessionRequest = _messages.MessageField('CreateSessionRequest', 1)
  database = _messages.StringField(2, required=True)


class SpannerProjectsInstancesDatabasesSessionsDeleteRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesSessionsDeleteRequest object.

  Fields:
    name: Required. The name of the session to delete.
  """

  name = _messages.StringField(1, required=True)


class SpannerProjectsInstancesDatabasesSessionsExecuteBatchDmlRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesSessionsExecuteBatchDmlRequest
  object.

  Fields:
    executeBatchDmlRequest: A ExecuteBatchDmlRequest resource to be passed as
      the request body.
    session: Required. The session in which the DML statements should be
      performed.
  """

  executeBatchDmlRequest = _messages.MessageField('ExecuteBatchDmlRequest', 1)
  session = _messages.StringField(2, required=True)


class SpannerProjectsInstancesDatabasesSessionsExecuteSqlRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesSessionsExecuteSqlRequest object.

  Fields:
    executeSqlRequest: A ExecuteSqlRequest resource to be passed as the
      request body.
    session: Required. The session in which the SQL query should be performed.
  """

  executeSqlRequest = _messages.MessageField('ExecuteSqlRequest', 1)
  session = _messages.StringField(2, required=True)


class SpannerProjectsInstancesDatabasesSessionsExecuteStreamingSqlRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesSessionsExecuteStreamingSqlRequest
  object.

  Fields:
    executeSqlRequest: A ExecuteSqlRequest resource to be passed as the
      request body.
    session: Required. The session in which the SQL query should be performed.
  """

  executeSqlRequest = _messages.MessageField('ExecuteSqlRequest', 1)
  session = _messages.StringField(2, required=True)


class SpannerProjectsInstancesDatabasesSessionsGetRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesSessionsGetRequest object.

  Fields:
    name: Required. The name of the session to retrieve.
  """

  name = _messages.StringField(1, required=True)


class SpannerProjectsInstancesDatabasesSessionsListRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesSessionsListRequest object.

  Fields:
    database: Required. The database in which to list sessions.
    filter: An expression for filtering the results of the request. Filter
      rules are case insensitive. The fields eligible for filtering are:    *
      `labels.key` where key is the name of a label  Some examples of using
      filters are:    * `labels.env:*` --> The session has the label "env".
      * `labels.env:dev` --> The session has the label "env" and the value of
      the label contains the string "dev".
    pageSize: Number of sessions to be returned in the response. If 0 or less,
      defaults to the server's maximum allowed page size.
    pageToken: If non-empty, `page_token` should contain a next_page_token
      from a previous ListSessionsResponse.
  """

  database = _messages.StringField(1, required=True)
  filter = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class SpannerProjectsInstancesDatabasesSessionsPartitionQueryRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesSessionsPartitionQueryRequest object.

  Fields:
    partitionQueryRequest: A PartitionQueryRequest resource to be passed as
      the request body.
    session: Required. The session used to create the partitions.
  """

  partitionQueryRequest = _messages.MessageField('PartitionQueryRequest', 1)
  session = _messages.StringField(2, required=True)


class SpannerProjectsInstancesDatabasesSessionsPartitionReadRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesSessionsPartitionReadRequest object.

  Fields:
    partitionReadRequest: A PartitionReadRequest resource to be passed as the
      request body.
    session: Required. The session used to create the partitions.
  """

  partitionReadRequest = _messages.MessageField('PartitionReadRequest', 1)
  session = _messages.StringField(2, required=True)


class SpannerProjectsInstancesDatabasesSessionsReadRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesSessionsReadRequest object.

  Fields:
    readRequest: A ReadRequest resource to be passed as the request body.
    session: Required. The session in which the read should be performed.
  """

  readRequest = _messages.MessageField('ReadRequest', 1)
  session = _messages.StringField(2, required=True)


class SpannerProjectsInstancesDatabasesSessionsRollbackRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesSessionsRollbackRequest object.

  Fields:
    rollbackRequest: A RollbackRequest resource to be passed as the request
      body.
    session: Required. The session in which the transaction to roll back is
      running.
  """

  rollbackRequest = _messages.MessageField('RollbackRequest', 1)
  session = _messages.StringField(2, required=True)


class SpannerProjectsInstancesDatabasesSessionsStreamingReadRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesSessionsStreamingReadRequest object.

  Fields:
    readRequest: A ReadRequest resource to be passed as the request body.
    session: Required. The session in which the read should be performed.
  """

  readRequest = _messages.MessageField('ReadRequest', 1)
  session = _messages.StringField(2, required=True)


class SpannerProjectsInstancesDatabasesSetIamPolicyRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The Cloud Spanner resource for which the policy is
      being set. The format is `projects/<project ID>/instances/<instance ID>`
      for instance resources and `projects/<project ID>/instances/<instance
      ID>/databases/<database ID>` for databases resources.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class SpannerProjectsInstancesDatabasesTestIamPermissionsRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The Cloud Spanner resource for which permissions are
      being tested. The format is `projects/<project ID>/instances/<instance
      ID>` for instance resources and `projects/<project
      ID>/instances/<instance ID>/databases/<database ID>` for database
      resources.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class SpannerProjectsInstancesDatabasesUpdateDdlRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDatabasesUpdateDdlRequest object.

  Fields:
    database: Required. The database to update.
    updateDatabaseDdlRequest: A UpdateDatabaseDdlRequest resource to be passed
      as the request body.
  """

  database = _messages.StringField(1, required=True)
  updateDatabaseDdlRequest = _messages.MessageField('UpdateDatabaseDdlRequest', 2)


class SpannerProjectsInstancesDeleteRequest(_messages.Message):
  r"""A SpannerProjectsInstancesDeleteRequest object.

  Fields:
    name: Required. The name of the instance to be deleted. Values are of the
      form `projects/<project>/instances/<instance>`
  """

  name = _messages.StringField(1, required=True)


class SpannerProjectsInstancesGetIamPolicyRequest(_messages.Message):
  r"""A SpannerProjectsInstancesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The Cloud Spanner resource for which the policy is
      being retrieved. The format is `projects/<project
      ID>/instances/<instance ID>` for instance resources and
      `projects/<project ID>/instances/<instance ID>/databases/<database ID>`
      for database resources.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class SpannerProjectsInstancesGetRequest(_messages.Message):
  r"""A SpannerProjectsInstancesGetRequest object.

  Fields:
    name: Required. The name of the requested instance. Values are of the form
      `projects/<project>/instances/<instance>`.
  """

  name = _messages.StringField(1, required=True)


class SpannerProjectsInstancesListRequest(_messages.Message):
  r"""A SpannerProjectsInstancesListRequest object.

  Fields:
    filter: An expression for filtering the results of the request. Filter
      rules are case insensitive. The fields eligible for filtering are:    *
      `name`   * `display_name`   * `labels.key` where key is the name of a
      label  Some examples of using filters are:    * `name:*` --> The
      instance has a name.   * `name:Howl` --> The instance's name contains
      the string "howl".   * `name:HOWL` --> Equivalent to above.   *
      `NAME:howl` --> Equivalent to above.   * `labels.env:*` --> The instance
      has the label "env".   * `labels.env:dev` --> The instance has the label
      "env" and the value of                        the label contains the
      string "dev".   * `name:howl labels.env:dev` --> The instance's name
      contains "howl" and                                  it has the label
      "env" with its value                                  containing "dev".
    pageSize: Number of instances to be returned in the response. If 0 or
      less, defaults to the server's maximum allowed page size.
    pageToken: If non-empty, `page_token` should contain a next_page_token
      from a previous ListInstancesResponse.
    parent: Required. The name of the project for which a list of instances is
      requested. Values are of the form `projects/<project>`.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class SpannerProjectsInstancesOperationsCancelRequest(_messages.Message):
  r"""A SpannerProjectsInstancesOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class SpannerProjectsInstancesOperationsDeleteRequest(_messages.Message):
  r"""A SpannerProjectsInstancesOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class SpannerProjectsInstancesOperationsGetRequest(_messages.Message):
  r"""A SpannerProjectsInstancesOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class SpannerProjectsInstancesOperationsListRequest(_messages.Message):
  r"""A SpannerProjectsInstancesOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class SpannerProjectsInstancesPatchRequest(_messages.Message):
  r"""A SpannerProjectsInstancesPatchRequest object.

  Fields:
    name: Required. A unique identifier for the instance, which cannot be
      changed after the instance is created. Values are of the form
      `projects/<project>/instances/a-z*[a-z0-9]`. The final segment of the
      name must be between 2 and 64 characters in length.
    updateInstanceRequest: A UpdateInstanceRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  updateInstanceRequest = _messages.MessageField('UpdateInstanceRequest', 2)


class SpannerProjectsInstancesSetIamPolicyRequest(_messages.Message):
  r"""A SpannerProjectsInstancesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The Cloud Spanner resource for which the policy is
      being set. The format is `projects/<project ID>/instances/<instance ID>`
      for instance resources and `projects/<project ID>/instances/<instance
      ID>/databases/<database ID>` for databases resources.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class SpannerProjectsInstancesTestIamPermissionsRequest(_messages.Message):
  r"""A SpannerProjectsInstancesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The Cloud Spanner resource for which permissions are
      being tested. The format is `projects/<project ID>/instances/<instance
      ID>` for instance resources and `projects/<project
      ID>/instances/<instance ID>/databases/<database ID>` for database
      resources.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Statement(_messages.Message):
  r"""A single DML statement.

  Messages:
    ParamTypesValue: It is not always possible for Cloud Spanner to infer the
      right SQL type from a JSON value.  For example, values of type `BYTES`
      and values of type `STRING` both appear in params as JSON strings.  In
      these cases, `param_types` can be used to specify the exact SQL type for
      some or all of the SQL statement parameters. See the definition of Type
      for more information about SQL types.
    ParamsValue: Parameter names and values that bind to placeholders in the
      DML string.  A parameter placeholder consists of the `@` character
      followed by the parameter name (for example, `@firstName`). Parameter
      names can contain letters, numbers, and underscores.  Parameters can
      appear anywhere that a literal value is expected.  The same parameter
      name can be used more than once, for example:  `"WHERE id > @msg_id AND
      id < @msg_id + 100"`  It is an error to execute a SQL statement with
      unbound parameters.

  Fields:
    paramTypes: It is not always possible for Cloud Spanner to infer the right
      SQL type from a JSON value.  For example, values of type `BYTES` and
      values of type `STRING` both appear in params as JSON strings.  In these
      cases, `param_types` can be used to specify the exact SQL type for some
      or all of the SQL statement parameters. See the definition of Type for
      more information about SQL types.
    params: Parameter names and values that bind to placeholders in the DML
      string.  A parameter placeholder consists of the `@` character followed
      by the parameter name (for example, `@firstName`). Parameter names can
      contain letters, numbers, and underscores.  Parameters can appear
      anywhere that a literal value is expected.  The same parameter name can
      be used more than once, for example:  `"WHERE id > @msg_id AND id <
      @msg_id + 100"`  It is an error to execute a SQL statement with unbound
      parameters.
    sql: Required. The DML string.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParamTypesValue(_messages.Message):
    r"""It is not always possible for Cloud Spanner to infer the right SQL
    type from a JSON value.  For example, values of type `BYTES` and values of
    type `STRING` both appear in params as JSON strings.  In these cases,
    `param_types` can be used to specify the exact SQL type for some or all of
    the SQL statement parameters. See the definition of Type for more
    information about SQL types.

    Messages:
      AdditionalProperty: An additional property for a ParamTypesValue object.

    Fields:
      additionalProperties: Additional properties of type ParamTypesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParamTypesValue object.

      Fields:
        key: Name of the additional property.
        value: A Type attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Type', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParamsValue(_messages.Message):
    r"""Parameter names and values that bind to placeholders in the DML
    string.  A parameter placeholder consists of the `@` character followed by
    the parameter name (for example, `@firstName`). Parameter names can
    contain letters, numbers, and underscores.  Parameters can appear anywhere
    that a literal value is expected.  The same parameter name can be used
    more than once, for example:  `"WHERE id > @msg_id AND id < @msg_id +
    100"`  It is an error to execute a SQL statement with unbound parameters.

    Messages:
      AdditionalProperty: An additional property for a ParamsValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParamsValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  paramTypes = _messages.MessageField('ParamTypesValue', 1)
  params = _messages.MessageField('ParamsValue', 2)
  sql = _messages.StringField(3)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StructType(_messages.Message):
  r"""`StructType` defines the fields of a STRUCT type.

  Fields:
    fields: The list of fields that make up this struct. Order is significant,
      because values of this struct type are represented as lists, where the
      order of field values matches the order of fields in the StructType. In
      turn, the order of fields matches the order of columns in a read
      request, or the order of fields in the `SELECT` clause of a query.
  """

  fields = _messages.MessageField('Field', 1, repeated=True)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: REQUIRED: The set of permissions to check for 'resource'.
      Permissions with wildcards (such as '*', 'spanner.*',
      'spanner.instances.*') are not allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class Transaction(_messages.Message):
  r"""A transaction.

  Fields:
    id: `id` may be used to identify the transaction in subsequent Read,
      ExecuteSql, Commit, or Rollback calls.  Single-use read-only
      transactions do not have IDs, because single-use transactions do not
      support multiple requests.
    readTimestamp: For snapshot read-only transactions, the read timestamp
      chosen for the transaction. Not returned by default: see
      TransactionOptions.ReadOnly.return_read_timestamp.  A timestamp in
      RFC3339 UTC \"Zulu\" format, accurate to nanoseconds. Example:
      `"2014-10-02T15:01:23.045123456Z"`.
  """

  id = _messages.BytesField(1)
  readTimestamp = _messages.StringField(2)


class TransactionOptions(_messages.Message):
  r"""# Transactions   Each session can have at most one active transaction at
  a time. After the active transaction is completed, the session can
  immediately be re-used for the next transaction. It is not necessary to
  create a new session for each transaction.  # Transaction Modes  Cloud
  Spanner supports three transaction modes:    1. Locking read-write. This
  type of transaction is the only way      to write data into Cloud Spanner.
  These transactions rely on      pessimistic locking and, if necessary, two-
  phase commit.      Locking read-write transactions may abort, requiring the
  application to retry.    2. Snapshot read-only. This transaction type
  provides guaranteed      consistency across several reads, but does not
  allow      writes. Snapshot read-only transactions can be configured to
  read at timestamps in the past. Snapshot read-only      transactions do not
  need to be committed.    3. Partitioned DML. This type of transaction is
  used to execute      a single Partitioned DML statement. Partitioned DML
  partitions      the key space and runs the DML statement over each partition
  in parallel using separate, internal transactions that commit
  independently. Partitioned DML transactions do not need to be
  committed.  For transactions that only read, snapshot read-only transactions
  provide simpler semantics and are almost always faster. In particular, read-
  only transactions do not take locks, so they do not conflict with read-write
  transactions. As a consequence of not taking locks, they also do not abort,
  so retry loops are not needed.  Transactions may only read/write data in a
  single database. They may, however, read/write data in different tables
  within that database.  ## Locking Read-Write Transactions  Locking
  transactions may be used to atomically read-modify-write data anywhere in a
  database. This type of transaction is externally consistent.  Clients should
  attempt to minimize the amount of time a transaction is active. Faster
  transactions commit with higher probability and cause less contention. Cloud
  Spanner attempts to keep read locks active as long as the transaction
  continues to do reads, and the transaction has not been terminated by Commit
  or Rollback.  Long periods of inactivity at the client may cause Cloud
  Spanner to release a transaction's locks and abort it.  Conceptually, a
  read-write transaction consists of zero or more reads or SQL statements
  followed by Commit. At any time before Commit, the client can send a
  Rollback request to abort the transaction.  ### Semantics  Cloud Spanner can
  commit the transaction if all read locks it acquired are still valid at
  commit time, and it is able to acquire write locks for all writes. Cloud
  Spanner can abort the transaction for any reason. If a commit attempt
  returns `ABORTED`, Cloud Spanner guarantees that the transaction has not
  modified any user data in Cloud Spanner.  Unless the transaction commits,
  Cloud Spanner makes no guarantees about how long the transaction's locks
  were held for. It is an error to use Cloud Spanner locks for any sort of
  mutual exclusion other than between Cloud Spanner transactions themselves.
  ### Retrying Aborted Transactions  When a transaction aborts, the
  application can choose to retry the whole transaction again. To maximize the
  chances of successfully committing the retry, the client should execute the
  retry in the same session as the original attempt. The original session's
  lock priority increases with each consecutive abort, meaning that each
  attempt has a slightly better chance of success than the previous.  Under
  some circumstances (e.g., many transactions attempting to modify the same
  row(s)), a transaction can abort many times in a short period before
  successfully committing. Thus, it is not a good idea to cap the number of
  retries a transaction can attempt; instead, it is better to limit the total
  amount of wall time spent retrying.  ### Idle Transactions  A transaction is
  considered idle if it has no outstanding reads or SQL queries and has not
  started a read or SQL query within the last 10 seconds. Idle transactions
  can be aborted by Cloud Spanner so that they don't hold on to locks
  indefinitely. In that case, the commit will fail with error `ABORTED`.  If
  this behavior is undesirable, periodically executing a simple SQL query in
  the transaction (e.g., `SELECT 1`) prevents the transaction from becoming
  idle.  ## Snapshot Read-Only Transactions  Snapshot read-only transactions
  provides a simpler method than locking read-write transactions for doing
  several consistent reads. However, this type of transaction does not support
  writes.  Snapshot transactions do not take locks. Instead, they work by
  choosing a Cloud Spanner timestamp, then executing all reads at that
  timestamp. Since they do not acquire locks, they do not block concurrent
  read-write transactions.  Unlike locking read-write transactions, snapshot
  read-only transactions never abort. They can fail if the chosen read
  timestamp is garbage collected; however, the default garbage collection
  policy is generous enough that most applications do not need to worry about
  this in practice.  Snapshot read-only transactions do not need to call
  Commit or Rollback (and in fact are not permitted to do so).  To execute a
  snapshot transaction, the client specifies a timestamp bound, which tells
  Cloud Spanner how to choose a read timestamp.  The types of timestamp bound
  are:    - Strong (the default).   - Bounded staleness.   - Exact staleness.
  If the Cloud Spanner database to be read is geographically distributed,
  stale read-only transactions can execute more quickly than strong or read-
  write transaction, because they are able to execute far from the leader
  replica.  Each type of timestamp bound is discussed in detail below.  ###
  Strong  Strong reads are guaranteed to see the effects of all transactions
  that have committed before the start of the read. Furthermore, all rows
  yielded by a single read are consistent with each other -- if any part of
  the read observes a transaction, all parts of the read see the transaction.
  Strong reads are not repeatable: two consecutive strong read-only
  transactions might return inconsistent results if there are concurrent
  writes. If consistency across reads is required, the reads should be
  executed within a transaction or at an exact read timestamp.  See
  TransactionOptions.ReadOnly.strong.  ### Exact Staleness  These timestamp
  bounds execute reads at a user-specified timestamp. Reads at a timestamp are
  guaranteed to see a consistent prefix of the global transaction history:
  they observe modifications done by all transactions with a commit timestamp
  <= the read timestamp, and observe none of the modifications done by
  transactions with a larger commit timestamp. They will block until all
  conflicting transactions that may be assigned commit timestamps <= the read
  timestamp have finished.  The timestamp can either be expressed as an
  absolute Cloud Spanner commit timestamp or a staleness relative to the
  current time.  These modes do not require a "negotiation phase" to pick a
  timestamp. As a result, they execute slightly faster than the equivalent
  boundedly stale concurrency modes. On the other hand, boundedly stale reads
  usually return fresher results.  See
  TransactionOptions.ReadOnly.read_timestamp and
  TransactionOptions.ReadOnly.exact_staleness.  ### Bounded Staleness  Bounded
  staleness modes allow Cloud Spanner to pick the read timestamp, subject to a
  user-provided staleness bound. Cloud Spanner chooses the newest timestamp
  within the staleness bound that allows execution of the reads at the closest
  available replica without blocking.  All rows yielded are consistent with
  each other -- if any part of the read observes a transaction, all parts of
  the read see the transaction. Boundedly stale reads are not repeatable: two
  stale reads, even if they use the same staleness bound, can execute at
  different timestamps and thus return inconsistent results.  Boundedly stale
  reads execute in two phases: the first phase negotiates a timestamp among
  all replicas needed to serve the read. In the second phase, reads are
  executed at the negotiated timestamp.  As a result of the two phase
  execution, bounded staleness reads are usually a little slower than
  comparable exact staleness reads. However, they are typically able to return
  fresher results, and are more likely to execute at the closest replica.
  Because the timestamp negotiation requires up-front knowledge of which rows
  will be read, it can only be used with single-use read-only transactions.
  See TransactionOptions.ReadOnly.max_staleness and
  TransactionOptions.ReadOnly.min_read_timestamp.  ### Old Read Timestamps and
  Garbage Collection  Cloud Spanner continuously garbage collects deleted and
  overwritten data in the background to reclaim storage space. This process is
  known as "version GC". By default, version GC reclaims versions after they
  are one hour old. Because of this, Cloud Spanner cannot perform reads at
  read timestamps more than one hour in the past. This restriction also
  applies to in-progress reads and/or SQL queries whose timestamp become too
  old while executing. Reads and SQL queries with too-old read timestamps fail
  with the error `FAILED_PRECONDITION`.  ## Partitioned DML Transactions
  Partitioned DML transactions are used to execute DML statements with a
  different execution strategy that provides different, and often better,
  scalability properties for large, table-wide operations than DML in a
  ReadWrite transaction. Smaller scoped statements, such as an OLTP workload,
  should prefer using ReadWrite transactions.  Partitioned DML partitions the
  keyspace and runs the DML statement on each partition in separate, internal
  transactions. These transactions commit automatically when complete, and run
  independently from one another.  To reduce lock contention, this execution
  strategy only acquires read locks on rows that match the WHERE clause of the
  statement. Additionally, the smaller per-partition transactions hold locks
  for less time.  That said, Partitioned DML is not a drop-in replacement for
  standard DML used in ReadWrite transactions.   - The DML statement must be
  fully-partitionable. Specifically, the statement    must be expressible as
  the union of many statements which each access only    a single row of the
  table.   - The statement is not applied atomically to all rows of the table.
  Rather,    the statement is applied atomically to partitions of the table,
  in    independent transactions. Secondary index rows are updated atomically
  with the base table rows.   - Partitioned DML does not guarantee exactly-
  once execution semantics    against a partition. The statement will be
  applied at least once to each    partition. It is strongly recommended that
  the DML statement should be    idempotent to avoid unexpected results. For
  instance, it is potentially    dangerous to run a statement such as
  `UPDATE table SET column = column + 1` as it could be run multiple times
  against some rows.   - The partitions are committed automatically - there is
  no support for    Commit or Rollback. If the call returns an error, or if
  the client issuing    the ExecuteSql call dies, it is possible that some
  rows had the statement    executed on them successfully. It is also possible
  that statement was    never executed against other rows.   - Partitioned DML
  transactions may only contain the execution of a single    DML statement via
  ExecuteSql or ExecuteStreamingSql.   - If any error is encountered during
  the execution of the partitioned DML    operation (for instance, a UNIQUE
  INDEX violation, division by zero, or a    value that cannot be stored due
  to schema constraints), then the    operation is stopped at that point and
  an error is returned. It is    possible that at this point, some partitions
  have been committed (or even    committed multiple times), and other
  partitions have not been run at all.  Given the above, Partitioned DML is
  good fit for large, database-wide, operations that are idempotent, such as
  deleting old rows from a very large table.

  Fields:
    partitionedDml: Partitioned DML transaction.  Authorization to begin a
      Partitioned DML transaction requires
      `spanner.databases.beginPartitionedDmlTransaction` permission on the
      `session` resource.
    readOnly: Transaction will not write.  Authorization to begin a read-only
      transaction requires `spanner.databases.beginReadOnlyTransaction`
      permission on the `session` resource.
    readWrite: Transaction may write.  Authorization to begin a read-write
      transaction requires
      `spanner.databases.beginOrRollbackReadWriteTransaction` permission on
      the `session` resource.
  """

  partitionedDml = _messages.MessageField('PartitionedDml', 1)
  readOnly = _messages.MessageField('ReadOnly', 2)
  readWrite = _messages.MessageField('ReadWrite', 3)


class TransactionSelector(_messages.Message):
  r"""This message is used to select the transaction in which a Read or
  ExecuteSql call runs.  See TransactionOptions for more information about
  transactions.

  Fields:
    begin: Begin a new transaction and execute this read or SQL query in it.
      The transaction ID of the new transaction is returned in
      ResultSetMetadata.transaction, which is a Transaction.
    id: Execute the read or SQL query in a previously-started transaction.
    singleUse: Execute the read or SQL query in a temporary transaction. This
      is the most efficient way to execute a transaction that consists of a
      single SQL query.
  """

  begin = _messages.MessageField('TransactionOptions', 1)
  id = _messages.BytesField(2)
  singleUse = _messages.MessageField('TransactionOptions', 3)


class Type(_messages.Message):
  r"""`Type` indicates the type of a Cloud Spanner value, as might be stored
  in a table cell or returned from an SQL query.

  Enums:
    CodeValueValuesEnum: Required. The TypeCode for this type.

  Fields:
    arrayElementType: If code == ARRAY, then `array_element_type` is the type
      of the array elements.
    code: Required. The TypeCode for this type.
    structType: If code == STRUCT, then `struct_type` provides type
      information for the struct's fields.
  """

  class CodeValueValuesEnum(_messages.Enum):
    r"""Required. The TypeCode for this type.

    Values:
      TYPE_CODE_UNSPECIFIED: Not specified.
      BOOL: Encoded as JSON `true` or `false`.
      INT64: Encoded as `string`, in decimal format.
      FLOAT64: Encoded as `number`, or the strings `"NaN"`, `"Infinity"`, or
        `"-Infinity"`.
      TIMESTAMP: Encoded as `string` in RFC 3339 timestamp format. The time
        zone must be present, and must be `"Z"`.  If the schema has the column
        option `allow_commit_timestamp=true`, the placeholder string
        `"spanner.commit_timestamp()"` can be used to instruct the system to
        insert the commit timestamp associated with the transaction commit.
      DATE: Encoded as `string` in RFC 3339 date format.
      STRING: Encoded as `string`.
      BYTES: Encoded as a base64-encoded `string`, as described in RFC 4648,
        section 4.
      ARRAY: Encoded as `list`, where the list elements are represented
        according to array_element_type.
      STRUCT: Encoded as `list`, where list element `i` is represented
        according to
        [struct_type.fields[i]][google.spanner.v1.StructType.fields].
    """
    TYPE_CODE_UNSPECIFIED = 0
    BOOL = 1
    INT64 = 2
    FLOAT64 = 3
    TIMESTAMP = 4
    DATE = 5
    STRING = 6
    BYTES = 7
    ARRAY = 8
    STRUCT = 9

  arrayElementType = _messages.MessageField('Type', 1)
  code = _messages.EnumField('CodeValueValuesEnum', 2)
  structType = _messages.MessageField('StructType', 3)


class UpdateDatabaseDdlMetadata(_messages.Message):
  r"""Metadata type for the operation returned by UpdateDatabaseDdl.

  Fields:
    commitTimestamps: Reports the commit timestamps of all statements that
      have succeeded so far, where `commit_timestamps[i]` is the commit
      timestamp for the statement `statements[i]`.
    database: The database being modified.
    statements: For an update this list contains all the statements. For an
      individual statement, this list contains only that statement.
  """

  commitTimestamps = _messages.StringField(1, repeated=True)
  database = _messages.StringField(2)
  statements = _messages.StringField(3, repeated=True)


class UpdateDatabaseDdlRequest(_messages.Message):
  r"""Enqueues the given DDL statements to be applied, in order but not
  necessarily all at once, to the database schema at some point (or points) in
  the future. The server checks that the statements are executable
  (syntactically valid, name tables that exist, etc.) before enqueueing them,
  but they may still fail upon later execution (e.g., if a statement from
  another batch of statements is applied first and it conflicts in some way,
  or if there is some data-related problem like a `NULL` value in a column to
  which `NOT NULL` would be added). If a statement fails, all subsequent
  statements in the batch are automatically cancelled.  Each batch of
  statements is assigned a name which can be used with the Operations API to
  monitor progress. See the operation_id field for more details.

  Fields:
    operationId: If empty, the new update request is assigned an
      automatically-generated operation ID. Otherwise, `operation_id` is used
      to construct the name of the resulting Operation.  Specifying an
      explicit operation ID simplifies determining whether the statements were
      executed in the event that the UpdateDatabaseDdl call is replayed, or
      the return value is otherwise lost: the database and `operation_id`
      fields can be combined to form the name of the resulting
      longrunning.Operation: `<database>/operations/<operation_id>`.
      `operation_id` should be unique within the database, and must be a valid
      identifier: `a-z*`. Note that automatically-generated operation IDs
      always begin with an underscore. If the named operation already exists,
      UpdateDatabaseDdl returns `ALREADY_EXISTS`.
    statements: DDL statements to be applied to the database.
  """

  operationId = _messages.StringField(1)
  statements = _messages.StringField(2, repeated=True)


class UpdateInstanceMetadata(_messages.Message):
  r"""Metadata type for the operation returned by UpdateInstance.

  Fields:
    cancelTime: The time at which this operation was cancelled. If set, this
      operation is in the process of undoing itself (which is guaranteed to
      succeed) and cannot be cancelled again.
    endTime: The time at which this operation failed or was completed
      successfully.
    instance: The desired end state of the update.
    startTime: The time at which UpdateInstance request was received.
  """

  cancelTime = _messages.StringField(1)
  endTime = _messages.StringField(2)
  instance = _messages.MessageField('Instance', 3)
  startTime = _messages.StringField(4)


class UpdateInstanceRequest(_messages.Message):
  r"""The request for UpdateInstance.

  Fields:
    fieldMask: Required. A mask specifying which fields in
      [][google.spanner.admin.instance.v1.UpdateInstanceRequest.instance]
      should be updated. The field mask must always be specified; this
      prevents any future fields in
      [][google.spanner.admin.instance.v1.Instance] from being erased
      accidentally by clients that do not know about them.
    instance: Required. The instance to update, which must always include the
      instance name.  Otherwise, only fields mentioned in
      [][google.spanner.admin.instance.v1.UpdateInstanceRequest.field_mask]
      need be included.
  """

  fieldMask = _messages.StringField(1)
  instance = _messages.MessageField('Instance', 2)


class Write(_messages.Message):
  r"""Arguments to insert, update, insert_or_update, and replace operations.

  Messages:
    ValuesValueListEntry: Single entry in a ValuesValue.

  Fields:
    columns: The names of the columns in table to be written.  The list of
      columns must contain enough columns to allow Cloud Spanner to derive
      values for all primary key columns in the row(s) to be modified.
    table: Required. The table whose rows will be written.
    values: The values to be written. `values` can contain more than one list
      of values. If it does, then multiple rows are written, one for each
      entry in `values`. Each list in `values` must have exactly as many
      entries as there are entries in columns above. Sending multiple lists is
      equivalent to sending multiple `Mutation`s, each containing one `values`
      entry and repeating table and columns. Individual values in each list
      are encoded as described here.
  """

  class ValuesValueListEntry(_messages.Message):
    r"""Single entry in a ValuesValue.

    Fields:
      entry: A extra_types.JsonValue attribute.
    """

    entry = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)

  columns = _messages.StringField(1, repeated=True)
  table = _messages.StringField(2)
  values = _messages.MessageField('ValuesValueListEntry', 3, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
